# coding: utf8
from __future__ import unicode_literals


# These exceptions are used to add NORM values based on a token's ORTH value.


# Norms are only set if no alternative is provided in the tokenizer exceptions.

_exc = {
    "αγιορίτης": "αγιορείτης",
    "αγόρι": "αγώρι",
    "έωλος": "αίολος",
    "αλλοίθωρος": "αλλήθωρος",
    "αλλοιώς": "αλλιώς",
    "αλλοιώτικος": "αλλκότικος",
    "αναµιγνύω": "αναµειγνύω",
    "ανάµιξη": "ανάµειξη",
    "ανανδρεία": "ανανδρία",
    "αναφιλυτό": "αναφιλητό",
    "ανελλειπώς": "ανελλιπώς",
    "ανεξιθρησκεία": "ανεξιθρησκία",
    "αντικρυνός": "αντικρινός",
    "απάγκιο": "απάγκεω",
    "αρµατωλός": "αρµατολός",
    "αρρώστεια": "αρρώστια",
    "ατόφιος": "ατόφυος",
    "αφίνω": "αφήνω",
    "χιβάδα": "χηβάδα",
    "αχρηστεία": "αχρηστία",
    "βαρυγκωµώ": "βαρυγγωµώ",
    "βεβαρυµένος": "βεβαρηµένος",
    "βερύκοκκο": "βερίκοκο",
    "βλήτο": "βλίτο",
    "βογκώ": "βογγώ",
    "βραδυά": "βραδιά",
    "βραδυάζει": "βραδίάζει",
    "Βρεταννία": "Βρετανία",
    "Βρεττανία": "Βρετανία",
    "βολοδέρνω": "βωλοδέρνω",
    "γέλοιο": "γέλιο",
    "γκάµα": "γκάµµα",
    "γλύφω": "γλείφω",
    "γλήνα": "γλίνα",
    "διαφήµηση": "διαφήµιση",
    "δικλείδα": "δικλίδα",
    "διοξείδιο": "διοξίδιο",
    "διορία": "διωρία",
    "δυόροφος": "διώροφος",
    "δυόµισυ": "δυόµισι",
    "διόσµος": "δυόσμος",
    "δυσφήμιση": "δυσφήµηση",
    "δοσίλογος": "δωσίλογος",
    "εγχείριση": "εγχείρηση",
    "ειδωλολατρεία": "ειδωλολατρία",
    "εληά": "ελιά",
    "ελιξίριο": "ελιξήριο",
    "έλκυθρο": "έλκηθρο",
    "ελλειπής": "ελλίπής",
    "ενάµισυς": "ενάµισης",
    "ενάµισυ": "ενάµισι",
    "ενανθρώπιση": "ενανθρώπηση",
    "έξη": "έξι",
    "επί τούτο": "επί τούτω",
    "εταιρία": "εταιρεία",
    "εφορεία": "εφορία",
    "ζηλειάρης": "ζηλιάρης",
    "Θεοφάνεια": "Θεοφάνια",
    "καυγάς": "καβγάς",
    "καθίκι": "καθοίκι",
    "καινούριος": "καινούργιος",
    "κακάβι": "κακκάβι",
    "κακαβιά": "κακκαβιά",
    "καµµία": "καµία",
    "κανέλα": "Καννέλα",
    "κανονιοφόρος": "κανονιοφόρος",
    "καντίλι": "καντήλι",
    "κατεβοδώνω": "κατευοδώνω",
    "κοίτοµαι": "κείτοµαι",
    "κελαϊδώ": "κελαηδώ",
    "κυάλια": "κιάλια",
    "κλύδωνας": "κλήδονας",
    "κλωτσώ": "κλοτσώ",
    "κολλιτσίδα": "κολλητσίδα",
    "κουκί": "κουκκί",
    "κουλός": "κουλλός",
    "κρεββάτι": "κρεβάτι",
    "κροκόδειλος": "κροκόδιλος",
    "κοβιός": "κωβιός",
    "λάκισα": "λάκησα",
    "λιµέρι": "ληµέρι",
    "λώξυγγας": "λόξυγγας",
    "µαγγούρα": "µαγκούρα",
    "µαζή": "μαζί",
    "µακρυά": "µακριά",
    "µαµή": "µαµµή",
    "µαµόθρεφτος": "µαµµόθρεφτος",
    "µίγµα": "µείγµα",
    "µίξη": "µείξη",
    "µετώπη": "µετόπη",
    "µυρολόι": "µοιρολόι",
    "µοτοσικλέτα": "µοτοσυκλέτα",
    "µπαλωµατής": "µπαλλωµατής",
    "µιζίθρα": "µυζήθρα",
    "νεοτερίζω": "νεωτερίζω",
    "νεοτερισµός": "νεωτερισμός",
    "νεοτεριστής": "νεωτεριστής",
    "νινί": "νηνί",
    "νοιώθω": "νιώθω",
    "νονός": "νοννός",
    "ξενιτιά": "ξενιτειά",
    "ξαίρω": "ξέρω",
    "ξίγκι": "ξίγγι",
    "ξείδι": "ξίδι",
    "ξώβεργα": "ξόβεργα",
    "ξιπάζω": "ξυπάζω",
    "ξιπασµένος": "ξυπασµένος",
    "ξυπόλητος": "ξυπόλυτος",
    "ξωκλήσι": "ξωκκλήσι",
    "οξυά": "οξιά",
    "ορθοπεδικός": "ορθοπαιδικός",
    "ωχ": "οχ",
    "παπάς": "παππάς",
    "παραγιός": "παραγυιός",
    "περηφάνεια": "περηφάνια",
    "πιλάλα": "πηλάλα",
    "πίννα": "πίνα",
    "πηρούνι": "πιρούνι",
    "πιτσιλώ": "πιτσυλώ",
    "πιτσιλίζω": "πιτσυλίζω",
    "πλατυάζω": "πλατειάζω",
    "πληµµυρίδα": "πληµυρίδα",
    "πληγούρι": "πλιγούρι",
    "πωπώ": "ποπό",
    "πουγγί": "πουγκί",
    "πρίγκηπας": "πρίγκιπας",
    "προάστειο": "προάστιο",
    "προεδρεία": "προεδρία",
    "πρίµα": "πράµα",
    "πρωτήτερα": "πρωτύτερα",
    "προτύτερα": "πρωτύτερα",
    "πόρωση": "πώρωση",
    "ρεβύθι": "ρεβίθι",
    "ρέγγα": "ρέΥκα",
    "ρηγώνω": "ριγώνω",
    "ρωµανικός": "ροµανικός",
    "ρίζι": "ρύζι",
    "Ρώσσος": "Ρώσος",
    "σακκούλα": "σακούλα",
    "συνάφι": "σινάφι",
    "σειρίτι": "σιρίτι",
    "σιφόνι": "σιφώνι",
    "συχαίνοµαι": "σιχαίνοµαι",
    "σκιρόδεµα": "σκυρόδεµα",
    "σπάγγος": "σπάγκος",
    "στυλιάρι": "στειλιάρι",
    "στοιβάδα": "στιβάδα",
    "στίβα": "στοίβα",
    "στριµώνω": "στρυµώνω",
    "στριμώχνω": "στρυμώχνω",
    "συγχύζω": "συγχίζω",
    "σηκώτι": "συκώτι",
    "σιναγρίδα": "συναγρίδα",
    "συνοδεία": "συνοδία",
    "σίφιλη": "σύφιλη",
    "τανιέµαι": "τανυέµαι",
    "τανίζω": "τανύζω",
    "τέσσερις": "τέσσερεις",
    "τζιτζιφιά": "τζιτζυφιά",
    "τόνος": "τόννος",
    "τοπείο": "τοπίο",
    "τρέλλα": "τρέλα",
    "τσαγγάρης": "τσαγκάρης",
    "τσανάκα": "τσαννάκα",
    "τσανακογλείφτης": "τσαννακογλείφτης",
    "τσιτώνω": "τσητώνω",
    "τσιγκλώ": "τσυγκλώ",
    "τσίµα": "τσύµα",
    "υννί": "υνί",
    "υπερηφάνια": "υπερηφάνεια",
    "υπόχρεως": "υπόχρεος",
    "φάκελλος": "φάκελος",
    "φείδι": "φίδι",
    "φιλονεικώ": "φιλονικώ",
    "φιλονεικία": "φιλονικία",
    "φυρί-φυρί": "φιρί-φιρί",
    "φτιάνω": "φτειάχνω",
    "φτιάχνω": "φτειάχνω",
    "φτώχεια": "φτώχια",
    "φυσαλίδα": "φυσαλλίδα",
    "χάνος": "χάννος",
    "χυνόπωρο": "χινόπωρο",
    "χεινόπωρο": "χινόπωρο",
    "χιµίζω": "χυµίζω",
    "χιμίζω": "χυμιζώ",
    "γκωλ": "γκολ",
    "αιρκοντίσιον": "ερκοντίσιον",
    "καρµπυρατέρ": "καρµπφατέρ",
    "κυλόττα": "κιλότα",
    "κλή ρινγκ": "κλίρινγκ",
    "κωλγκέρλ": "κολγκέρλ",
    "κοµπιναιζόν": "κοµπινεζόν",
    "κοπυράιτ": "κοπιράιτ",
    "µυλαίδη": "µιλέδη",
    "µποϋκοτάζ": "µποϊκοτάζ",
    "πέναλτυ": "πέναλτι",
    "πορτραίτο": "πορτρέτο",
    "ρεστωράν": "ρεστοράν",
    "ροσµπήφ": "ροσµπίφ",
    "σαντιγύ": "σαντιγί",
    "στριπτήζ": "στριπτίζ",
    "ταµπλώ": "ταµπλό",
    "τζόκεϋ": "τζόκεϊ",
    "φουτµπώλ": "φουτµπόλ",
    "τρόλλεϋ": "τρόλεϊ",
    "χίππυ": "χίπι",
    "φέρρυ-µπωτ": "φεριµπότ",
    "χειρούργος": "χειρουργός",
    "αβαείο": "αββαείο",
    "αβάς": "αββάς",
    "αβάσκαµα": "βάσκαµα",
    "αβασκανία": "βασκανία",
    "αβάφτιστος": "αβάπτιστος",
    "αβάφτιστη": "αβάπτιστη",
    "αβάφτιστο": "αβάπτιστο",
    "αβγίλα": "αβγουλίλα",
    "αυτί": "αφτί",
    "αβδέλλα": "βδέλλα",
    "Αβράµ": "'Αβραάµ",
    "αγγινάρα": "αγκινάρα",
    "αγγόνα": "εγγονή",
    "αγγόνι": "εγγόνι",
    "αγγονός": "εγγονός",
    "άγειρτος": "άγερτος",
    "άγειρτη": "άγερτη",
    "άγειρτο": "άγερτο",
    "αγέρας": "αέρας",
    "αγκλέουρας": "αγλέορας",
    "αγκλίτοα": "γκλίτσα",
    "Αγκόλα": "Ανγκόλα",
    "αγκορά": "ανγκορά",
    "αγκοστοίιρα": "ανγκοστούρα",
    "άγνεστος": "άγνεθος",
    "άγνεστη": "άγνεθη",
    "άγνεστο": "άγνεθο",
    "αγώρι": "αγόρι",
    "αγωρίστικος": "αγορίστικος",
    "αγωρίστικη": "αγορίστικη",
    "αγωρίστικο": "αγορίστικο",
    "αγωροκόριτσο": "αγοροκόριστο",
    "αγουρόλαδο": "αγουρέλαιο",
    "αγροικώ": "γροικώ",
    "αδάµαντας": "αδάµας",
    "αδερφή": "αδελφή",
    "αδέρφι": "αδέλφι",
    "αδερφικός": "αδελφικός",
    "αδερφική": "αδελφική",
    "αδερφικό": "αδελφικό",
    "αδερφοποιτός": "αδελφοποιτός",
    "αδερφός": "αδελφός",
    "αδερφοσύνη": "αδελφοσύνη",
    "αέρι": "αγέρι",
    "αερόµπικ": "αεροβική",
    "αεροστρόβιλος": "αεριοστρόβιλος",
    "αητός": "αετός",
    "αιµατοποσία": "αιµοποσία",
    "άιντε": "άντε",
    "αισθηµατισµός": "συναισθηµατισµός",
    "αιτιακός": "αιτιώδης",
    "αιτιακή": "αιτιώδης",
    "αιτιακό": "αιτιώδες",
    "ακατανόµαστος": "ακατονόµαστος",
    "ακατανόμαστη": "ακατονόμαστη",
    "ακατονόμαστο": "ακατανόμαστο",
    "ακέραιος": "ακέριος",
    "ακέραια": "ακέρια",
    "ακέραιο": "ακέριο",
    "άκρον": "άκρο",
    "ακτύπητος": "αχτύπητος",
    "ακτύπητη": "αχτύπητη",
    "ακτύπητο": "αχτύπητο",
    "ακυριολεκτώ": "ακυρολεκτώ",
    "ακυριολεξία": "ακυρολεξία",
    "αλάτι": "άλας",
    "αλατένιος": "αλάτινος",
    "αλατένια": "αλάτινη",
    "αλατένιο": "αλάτινο",
    "αλαφραίνω": "ελαφρώνω",
    "αλαφριός": "ελαφρύς",
    "αλαφριό": "ελαφρύ",
    "αλαφρόµυαλος": "ελαφρόµυαλος",
    "αλαφρόμυαλη": "ελαφρόμυαλη",
    "αλαφρόμυαλο": "ελαφρόμυαλο",
    "αλείβω": "αλείφω",
    "άλευρο": "αλεύρι",
    "αλησµονησιά": "λησµονιά",
    "αλκολίκι": "αλκοολίκι",
    "αλλέως": "αλλιώς",
    "αλληλοεπίδραση": "αλληλεπίδραση",
    "αλλήθωρος": "αλλοίθωρος",
    "αλλήθωρη": "αλλοίθωρη",
    "αλλήθωρο": "αλλοίθωρο",
    "αλλοίµονο": "αλίµονο",
    "αµνηστεία": "αµνηστία",
    "αµπαρόριζα": "αρµπαρόριζα",
    "αµπέχωνο": "αµπέχονο",
    "αµυγδαλάτος": "αµυγδαλωτός",
    "αμυγδαλάτη": "αμυγδαλωτή",
    "αμυγδαλάτο": "αμυγδαλωτό",
    "αµυγδαλόλαδο": "αµυγδαλέλαιο",
    "αµφίλογος": "αµφιλεγόµενος",
    "αμφίλογη": "αμφιλεγόμενη",
    "αμφίλογο": "αμφιλεγόμενο",
    "αναβατός": "ανεβατός",
    "αναβατή": "ανεβατή",
    "αναβατό": "ανεβατό",
    "αναδεχτός": "αναδεκτός",
    "αναθρέφω": "ανατρέφω",
    "ανακατώνω": "ανακατεύω",
    "ανακάτωση": "ανακάτεµα",
    "αναλίσκω": "αναλώνω",
    "αναμειγνύω": "αναμιγνύω",
    "αναμείκτης": "αναμίκτης",
    "ανάµεικτος": "ανάµικτος",
    "ανάμεικτη": "ανάμικτη",
    "ανάμεικτο": "ανάμικτο",
    "αναπαµός": "ανάπαυση",
    "αναπαρασταίνω": "αναπαριστάνω",
    "ανάπρωρος": "ανάπλωρος",
    "ανάπρωρη": "ανάπλωρη",
    "ανάπρωρο": "ανάπλωρο",
    "αναπτυγµένος": "ανεπτυγμένος",
    "αναπτυγµένη": "ανεπτυγμένη",
    "αναπτυγµένο": "ανεπτυγμένο",
    "άναστρος": "ανάστερος",
    "αναστυλώνω": "αναστηλώνω",
    "αναστύλωση": "αναστήλωση",
    "ανεγνωρισµένος": "αναγνωρισµένος",
    "αναγνωρισμένη": "αναγνωρισµένη",
    "αναγνωρισμένο": "αναγνωρισµένο",
    "ανέµυαλος": "άμυαλος",
    "ανέμυαλη": "άμυαλη",
    "ανέμυαλο": "άμυαλο",
    "ανεπάντεχος": "αναπάντεχος",
    "ανεπάντεχη": "αναπάντεχη",
    "ανεπάντεχο": "αναπάντεχο",
    "ανεψιά": "ανιψιά",
    "ανεψιός": "ανιψιός",
    "ανήρ": "άνδρας",
    "ανηφόρι": "ανήφορος",
    "ανηψιά": "ανιψιά",
    "ανηψιός": "ανιψιός",
    "άνθιση": "άνθηση",
    "ανταλλάζω": "ανταλλάσσω",
    "ανταπεξέρχοµαι": "αντεπεξέρχοµαι",
    "αντζούγια": "αντσούγια",
    "αντιεισαγγελέας": "αντεισαγγελέας",
    "αντικατασταίνω": "αντικαθιστώ",
    "αντικρύζω": "αντικρίζω",
    "αντιµολία": "αντιµωλία",
    "αντιπροσωπεία": "αντιπροσωπία",
    "αντισταµινικό": "αντιισταµινικός",
    "αντίχτυπος": "αντίκτυπος",
    "άντρας": "άνδρας",
    "αντρόγυνο": "ανδρόγυνο",
    "αντρώνω": "ανδρώνω",
    "άξια": "άξιος",
    "απακούµπι": "αποκούµπι",
    "απαλάµη": "παλάµη",
    "Απαλάχια": "Αππαλάχια",
    "απάνω": "επάνω",
    "απέδρασα": "αποδιδράσκω",
    "απλούς": "απλός",
    "απλούν": "απλό",
    "απόγαιο": "απόγειο",
    "αποδείχνω": "αποδεικνύω",
    "αποθαµός": "πεθαµός",
    "αποθανατίζω": "απαθανατίζω",
    "αποκεντροποίηση": "αποκέντρωση",
    "απολαυή": "απολαβή",
    "αποξεραίνω": "αποξηραίνω",
    "απόξυοη": "απόξεση",
    "απόξω": "απέξω",
    "απόσχω": "απέχω",
    "αποτίω": "αποτίνω",
    "αποτυχαίνω": "αποτυγχάνω",
    "αποχαιρετίζω": "αποχαιρετώ",
    "απόχτηµα": "απόκτηµα",
    "απόχτηση": "απόκτηση",
    "αποχτώ": "αποκτώ",
    "Απρίλης": "Απρίλιος",
    "αρκαντάσης": "καρντάσης",
    "αρµάρι": "ερµάριο",
    "άρµη": "άλµη",
    "αρµοστεία": "αρµοστία",
    "άρµπουρο": "άλµπουρο",
    "αρµύρα": "αλµύρα",
    "αρµυρίκι": "αλµυρίκι",
    "άρρην": "άρρεν",
    "αρσανάς": "ταρσανάς",
    "αρτύνω": "αρταίνω",
    "αρχινίζω": "αρχίζω",
    "αρχινώ": "αρχίζω",
    "αρχίτερα": "αρχύτερα",
    "ασκηµάδα": "ασχήµια",
    "ασκηµαίνω": "ασχηµαίνω",
    "ασκήµια": "ασχήµια",
    "ασκηµίζω": "ασχηµίζω",
    "άσσος": "άσος",
    "αστράπτω": "αστράφτω",
    "αστράπτω": "αστράφτω",
    "αταχτώ": "ατακτώ",
    "ατσάλινος": "ατσαλένιος",
    "ατσάλινη": "ατσαλένια",
    "ατσάλινο": "ατσαλένιο",
    "Ατσιγγάνος": "Τσιγγάνος",
    "Ατσίγγανος": "Τσιγγάνος",
    "αυγαταίνω": "αβγατίζω",
    "αυγατίζω": "αβγατίζω",
    "αυγό": "αβγό",
    "αυγοειδής": "αυγοειδής",
    "αυγοειδές": "αβγοειδές",
    "αυγοθήκη": "αβγοθήκη",
    "αυγοκόβω": "αβγοκόβω",
    "αυγοτάραχο": "αβγοτάραχο",
    "αύλακας": "αυλάκι",
    "αυτί": "αφτί",
    "αυτιάζοµαι": "αφτιάζοµαι",
    "αφορεσµός": "αφορισµός",
    "άφρονας": "άφρων",
    "αχείλι": "χείλι",
    "άχερο": "άχυρο",
    "αχερώνας": "αχυρώνας",
    "αχιβάδα": "αχηβάδα",
    "αχτίδα": "ακτίνα",
    "βαβουίνος": "µπαµπουίνος",
    "Βαγγέλης": "Ευάγγελος",
    "βαγγέλιο": "ευαγγέλιο",
    "Βάγια": "Βάί'α",
    "βαζιβουζούκος": "βασιβουζούκος",
    "βαθύνω": "βαθαίνω",
    "βάιο": "βάγιο",
    "βακαλάος": "µπακαλιάρος",
    "βαλάντιο": "βαλλάντιο",
    "βαλαντώνω": "βαλλαντώνω",
    "βάνω": "βάζω",
    "βαρειά": "βαριά",
    "βαριεστίζω": "βαργεστώ",
    "βαριεστώ": "βαργεστώ",
    "βαρώ": "βαράω",
    "βαρώνος": "βαρόνος",
    "βασιλέας": "βασιλιάς",
    "βασµούλος": "γασµούλος",
    "Βαυαρία": "Βαβαρία",
    "Βαυαροκρατία": "Βαβαροκρατία",
    "βαφτίζω": "βαπτίζω",
    "βάφτιση": "βάπτιση",
    "βάφτισµα": "βάπτισµα",
    "βαφτιστής": "βαπτιστής",
    "βαφτιστικός": "βαπτιστικός",
    "βαφτιστική": "βαπτιστική",
    "βαφτιστικιά": "βαπτιστική",
    "βαφτιστικό": "βαπτιστικό",
    "βδοµάδα": "εβδοµάδα",
    "βεγόνια": "µπιγκόνια",
    "βελανίδι": "βαλανίδι",
    "βελανιδιά": "βαλανιδιά",
    "βενζίνα": "βενζίνη",
    "βεράτιο": "µπεράτι",
    "βερόκοκο": "βερίκοκο",
    "βιγόνια": "µπιγκόνια",
    "βλάφτω": "βλάπτω",
    "βλογιά": "ευλογιά",
    "βλογάω": "ευλογώ",
    "βογγίζω": "βογγώ",
    "βόγγος": "βογγητό",
    "βογκητό": "βογγητό",
    "βοδάµαξα": "βοϊδάµαξα",
    "βόλλεϋ": "βόλεϊ",
    "βολοκοπώ": "βωλοκοπώ",
    "βόλος": "βώλος",
    "βουβάλι": "βούβαλος",
    "βουή": "βοή",
    "βούλα": "βούλλα",
    "βούλωµα": "βούλλωµα",
    "βουλώνω": "βουλλώνω",
    "βουρβόλακας": "βρικόλακας",
    "βουρκόλακας": "βρικόλακας",
    "βους": "βόδι",
    "βραδι": "βράδυ",
    "βρυκόλακας": "βρικόλακας",
    "βρώµα": "βρόµα",
    "βρώµη": "βρόµη",
    "βρωµιά": "βροµιά",
    "βρωµίζω": "βροµίζω",
    "βρώµιο": "βρόµιο",
    "βρωµώ": "βροµώ",
    "βωξίτης": "βοξίτης",
    "γάβρος": "γαύρος",
    "γαϊδάρα": "γαϊδούρα",
    "γαίµα": "αίµα",
    "γαλακτόπιτα": "γαλατόπιτα",
    "γάµα": "γάµµα",
    "γαµβρός": "γαµπρός",
    "γαρίφαλο": "γαρύφαλλο",
    "γαρούφαλλο": "γαρύφαλλο",
    "γαυγίζω": "γαβγίζω",
    "γελάδα": "αγελάδα",
    "γελέκο": "γιλέκο",
    "γένοµαι": "γίνοµαι",
    "γενότυπος": "γονότυπος",
    "Γένουα": "Γένοβα",
    "γεράζω": "γερνώ",
    "γέρακας": "γεράκι",
    "γερατειά": "γηρατειά",
    "γεροκοµείο": "γηροκοµείο",
    "γεροκοµώ": "γηροκοµώ",
    "Γεσθηµανή": "Γεθσηµανή",
    "γεώδης": "γαιώδης",
    "γαιώδες": "γαιώδες",
    "γηρασµός": "γήρανση",
    "Γιάννενα": "Ιωάννινα",
    "Γιάννινα": "Ιωάννινα",
    "γιάνω": "γιαίνω",
    "γιαουρτλού": "γιογουρτλού",
    "Γιαπωνέζος": "Ιαπωνέζος",
    "γιγαντεύω": "γιγαντώνω",
    "γιεγιές": "γεγές",
    "Γιεν": "γεν",
    "γιέσµαν": "γέσµαν",
    "γιόκας": "γυιόκας",
    "γιορτασµός": "εορτασµός",
    "γιος": "γυιος",
    "Γιούλης": "Ιούλιος",
    "Γιούνης": "Ιούνιος",
    "γιοφύρι": "γεφύρι",
    "Γιώργος": "Γεώργιος",
    "γιωτ": "γιοτ",
    "γιωτακισµός": "ιωτακισµός",
    "γκάγκστερ": "γκάνγκστερ",
    "γκαγκστερισµός": "γκανγκστερισµός",
    "γκαµήλα": "καµήλα",
    "γκεµπελίσκος": "γκαιµπελίσκος",
    "γκιουβέτσι": "γιουβέτσι",
    "γκιώνης": "γκιόνης",
    "γκλοµπ": "κλοµπ",
    "γκογκ": "γκονγκ",
    "Γκιόνα": "Γκιώνα",
    "γκόρφι": "γκόλφι",
    "γκρα": "γκρας",
    "Γκράβαρα": "Κράβαρα",
    "γκυ": "γκι",
    "γλαϋξ": "γλαύκα",
    "γλιτώνω": "γλυτώνω",
    "γλύκισµα": "γλύκυσµα",
    "γλυστρώ": "γλιστρώ",
    "γλωσσίδα": "γλωττίδα",
    "γνέφαλλο": "γνάφαλλο",
    "γνοιάζοµαι": "νοιάζοµαι",
    "γόµα": "γόµµα",
    "γόνα": "γόνατο",
    "γονιός": "γονέας",
    "γόπα": "γώπα",
    "γούµενος": "ηγούµενος",
    "γουµένισσα": "ηγουµένη",
    "γουώκµαν": "γουόκµαν",
    "γραία": "γριά",
    "Γράµος": "Γράµµος",
    "γρασίδι": "γρασσίδι",
    "γρεγολεβάντες": "γραιγολεβάντες",
    "γρέγος": "γραίγος",
    "γρικώ": "γροικώ",
    "Γροιλανδία": "Γροιλανδία",
    "γρίνια": "γκρίνια",
    "γροθοκοπώ": "γρονθοκοπώ",
    "γρούµπος": "γρόµπος",
    "γυαλοπωλείο": "υαλοπωλείο",
    "γυρνώ": "γυρίζω",
    "γόρωθε": "γύροθε",
    "γωβιός": "κωβιός",
    "δάγκάµα": "δάγκωµα",
    "δαγκαµατιά": "δαγκωµατιά",
    "δαγκανιά": "δαγκωνιά",
    "δαιµονοπληξία": "δαιµονιόπληκτος",
    "δαίµων": "δαίµονας",
    "δακτυλήθρα": "δαχτυλήθρα",
    "δακτυλίδι": "δαχτυλίδι",
    "∆αυίδ": "∆αβίδ",
    "δαχτυλογραφία": "δακτυλογραφία",
    "δαχτυλογράφος": "δακτυλογράφος",
    "δεικνύω": "δείχνω",
    "δείλι": "δειλινό",
    "δείχτης": "δείκτης",
    "δελής": "ντελής",
    "δενδρογαλή": "δεντρογαλιά",
    "δεντρολίβανο": "δενδρολίβανο",
    "δεντροστοιχία": "δενδροστοιχία",
    "δεντροφυτεία": "δενδροφυτεία",
    "δεντροφυτεύω": "δενδροφυτεύω",
    "δεντρόφυτος": "δενδρόφυτος",
    "δεξής": "δεξιό",
    "δερµατώδης": "δερµατοειδής",
    "δερματώδες": "δερµατοειδές",
    "δέσποτας": "δεσπότης",
    "δεφτέρι": "τεφτέρι",
    "διαβατάρης": "διαβάτης",
    "διάβηκα": "διαβαίνω",
    "διαβιβρώσκω": "διαβρώνω",
    "διαθρέψω": "διατρέφω",
    "διακόνεµα": "διακονιά",
    "διάολος": "διάβολος",
    "∆ιαµαντής": "Αδαµάντιος",
    "διαολιά": "διαβολιά",
    "διαολογυναίκα": "διαβολογυναίκα",
    "διαολοθήλυκο": "διαβολοθήλυκο",
    "διαολόκαιρος": "διαβολόκαιρος",
    "διαολοκόριτσο": "διαβολοκόριτσο",
    "διαολόπαιδο": "διαβολόπαιδο",
    "διάολος": "διάβολος",
    "διασκελιά": "δρασκελιά",
    "διαχύνω": "διαχέω",
    "δίδω": "δίνω",
    "δίκηο": "δίκιο",
    "δοβλέτι": "ντοβλέτι",
    "δοσίλογος": "δωσίλογος",
    "δράχνω": "αδράχνω",
    "δρέπανο": "δρεπάνι",
    "δρόσος": "δροσιά",
    "δώνω": "δίνω",
    "εγγίζω": "αγγίζω",
    "εδώθε": "δώθε",
    "εδωνά": "εδωδά",
    "εικοσάρι": "εικοσάρικο",
    "εικών": "εικόνα",
    "εισαγάγω": "εισάγω",
    "εισήγαγα": "εισάγω",
    "εισήχθην": "εισάγω",
    "έκαμα": "έκανα",
    "εκατόν": "εκατό",
    "εκατοστάρης": "κατοστάρης",
    "εκατοστάρι": "κατοστάρι",
    "εκατοστάρικο": "κατοστάρικο",
    "εκλαίρ": "εκλέρ",
    "Ελδοράδο": "Ελντοράντο",
    "ελευθεροτεκτονισµός": "τεκτονισµός",
    "ελευτεριά": "ελευθερία",
    "Ελεφαντοστού Ακτή": "Ακτή Ελεφαντοστού",
    "ελληνικάδικο": "ελληνάδικο",
    "Ελπίδα": "Ελπίς",
    "εµορφιά": "οµορφιά",
    "εµορφάδα": "οµορφιά",
    "έµπορας": "έµπορος",
    "εµώ": "εξεµώ",
    "ένδεκα": "έντεκα",
    "ενενήκοντα": "ενενήντα",
    "ενωρίς": "νωρίς",
    "εξανέστην": "εξανίσταµαι",
    "εξήκοντα": "εξήντα",
    "έξις": "έξη",
    "εξωκκλήσι": "ξωκκλήσι",
    "εξωµερίτης": "ξωµερίτης",
    "επανωφόρι": "πανωφόρι",
    "επιµειξία": "επιµιξία",
    "επίστοµα": "απίστοµα",
    "επτάζυµο": "εφτάζυµο",
    "επταήµερος": "εφταηµερος",
    "επταθέσιος": "εφταθέσιος",
    "επταµελής": "εφταµελης",
    "επταµηνία": "εφταµηνία",
    "επταµηνίτικος": "εφταµηνίτικος",
    "επταπλασιάζω": "εφταπλασιάζω",
    "επταπλάσιος": "εφταπλάσιος",
    "επτασύλλαβος": "εφτασύλλαβος",
    "επτατάξιος": "εφτατάξιος",
    "επτάτοµος": "εφτάτοµος",
    "επτάφυλλος": "εφτάφυλλος",
    "επτάχρονα": "εφτάχρονα",
    "επτάχρονος": "εφτάχρονος",
    "επταψήφιος": "εφταψήφιος",
    "επτάωρος": "εφτάωρος",
    "επταώροφος": "εφταώροφος",
    "έργον": "έργο",
    "ευκή": "ευχή",
    "ευρό": "ευρώ",
    "ευσπλαχνίζοµαι": "σπλαχνίζοµαι",
    "εφεντης": "αφέντης",
    "εφηµεριακός": "εφηµέριος",
    "εφημεριακή": "εφηµέρια",
    "εφημεριακό": "εφηµέριο",
    "εφτά": "επτά",
    "εφταετία": "επταετία",
    "εφτακόσια": "επτακόσια",
    "εφτακόσιοι": "επτακόσιοι",
    "εφτακοσιοστός": "επτακοσιοστός",
    "εχθές": "χθες",
    "ζάπι": "ζάφτι",
    "ζαχαριάζω": "ζαχαρώνω",
    "ζαχαροµύκητας": "σακχαροµύκητας",
    "ζεµανφού": "ζαµανφού",
    "ζεµανφουτισµός": "ζαµανφουτισµός",
    "ζέστα": "ζέστη",
    "ζεύλα": "ζεύγλα",
    "Ζηλανδία": "Νέα Ζηλανδία",
    "ζήλεια": "ζήλια",
    "ζιµπούλι": "ζουµπούλι",
    "ζο": "ζώο",
    "ζουρλαµάρα": "ζούρλα",
    "ζωοφόρος": "ζωφόρος",
    "ηλεκτροκόλληση": "ηλεκτροσυγκόλληση",
    "ηλεκτροοπτική": "ηλεκτροπτική",
    "ήλιο": "ήλιον",
    "ηµιόροφος": "ηµιώροφος",
    "θαλάµι": "θαλάµη",
    "θάµα": "θαύµα",
    "θαµπώνω": "θαµβώνω",
    "θάµπος": "θάµβος",
    "θάφτω": "θάβω",
    "θεοψία": "θεοπτία",
    "θέσει": "θέση",
    "θηλειά": "θηλιά",
    "Θόδωρος": "Θεόδωρος",
    "θρύβω": "θρύπτω",
    "θυµούµαι": "θυµάµαι",
    "Ιαµάϊκή": "Τζαµάικα",
    "ιατρεύω": "γιατρεύω",
    "ιατρός": "γιατρός",
    "ιατροσόφιο": "γιατροσόφι",
    "I.Q.": "αϊ-κιού",
    "ινατι": "γινάτι",
    "ιονίζω": "ιοντίζω",
    "ιονιστής": "ιοντιστής",
    "ιονόσφαιρα": "ιοντόσφαιρα",
    "Ιούλης": "Ιούλιος",
    "ίσασµα": "ίσιωµα",
    "ισιάζω": "ισιώνω",
    "ίσκιος": "ήσκιος",
    "ισκιώνω": "ησκιώνω",
    "ίσωµα": "ίσιωµα",
    "ισώνω": "ισιώνω",
    "ιχθύαση": "ιχθύωση",
    "ιώτα": "γιώτα",
    "καββαλισµός": "καβαλισµός",
    "κάβουρος": "κάβουρας",
    "καδής": "κατής",
    "καδρίλια": "καντρίλια",
    "Καζακστάν": "Καζαχστάν",
    "καθέκλα": "καρέκλα",
    "κάθησα": "κάθισα",
    "[1766]. καθίκι": "καθοίκι",
    "καΐλα": "καήλα",
    "καϊξής": "καϊκτσής",
    "καλδέρα": "καλντέρα",
    "καλεντάρι": "καλαντάρι",
    "καλήν εσπέρα": "καλησπέρα",
    "καλιά": "καλειά",
    "καλιακούδα": "καλοιακούδα",
    "κάλλια": "κάλλιο",
    "καλλιά": "κάλλιο",
    "καλόγηρος": "καλόγερος",
    "καλόρχεται": "καλοέρχεται",
    "καλσόν": "καλτσόν",
    "καλυµµαύκι": "καµιλαύκι",
    "καλύµπρα": "καλίµπρα",
    "καλωσύνη": "καλοσύνη",
    "καµαρωτός": "καµαρότος",
    "καµηλαύκι": "καµιλαύκι",
    "καµτσίκι": "καµουτσίκι",
    "καναβάτσο": "κανναβάτσο",
    "κανακίζω": "κανακεύω",
    "κανάτα": "καννάτα",
    "κανατάς": "καννατάς",
    "κανάτι": "καννάτι",
    "κανελής": "καννελής",
    "κανελιά": "καννελή",
    "κανελί": "καννελή",
    "κανελονι": "καννελόνι",
    "κανελλόνι": "καννελόνι",
    "κανένας": "κανείς",
    "κάνη": "κάννη",
    "κανί": "καννί",
    "κάνναβης": "κάνναβις",
    "καννιβαλισµός": "κανιβαλισµός",
    "καννίβαλος": "κανίβαλος",
    "κανοκιάλι": "καννοκιάλι",
    "κανόνι": "καννόνι",
    "κανονιά": "καννονιά",
    "κανονίδι": "καννονίδι",
    "κανονιέρης": "καννονιέρης",
    "κανονιοβολητής": "καννονιοβολητής",
    "κανονιοβολισµός": "καννονιοβολισµός",
    "κανονιοβολώ": "καννονιοβολώ",
    "κανονιοστάσιο": "καννονιοστάσιο",
    "κανονιοστοιχία": "καννονιοστοιχία",
    "κανονοθυρίδα": "καννονοθυρίδα",
    "κάνουλα": "κάννουλα",
    "κανών": "κανόνας",
    "κάπα": "κάππα",
    "κάπαρη": "κάππαρη",
    "καπαρντίνα": "καµπαρντίνα",
    "καραβόσκοινο": "καραβόσχοινο",
    "καρένα": "καρίνα",
    "κάρκάδο": "κάκαδο",
    "καροτίνη": "καρωτίνη",
    "καρότο": "καρώτο",
    "καροτόζουµο": "καρωτόζουµο",
    "καροτοσαλάτα": "καρωτοσαλάτα",
    "καρπούµαι": "καρπώνοµαι",
    "καρρώ": "καρό",
    "κάρυ": "κάρι",
    "καρυοφύλλι": "καριοφίλι",
    "καταΐφι": "κανταΐφι",
    "κατακάθηµαι": "κατακάθοµαι",
    "κατάντια": "κατάντηµα",
    "κατασκοπεία": "κατασκοπία",
    "καταφτάνω": "καταφθάνω",
    "καταχράσθηκα": "καταχράστηκα",
    "κατάχτηση": "κατάκτηση",
    "καταχτητής": "κατακτητής",
    "καταχτώ": "κατακτώ",
    "καταχωρώ": "καταχωρίζω",
    "κατέβαλα": "καταβάλλω",
    "Κατερίνα": "Αικατερίνη",
    "κατοστίζω": "εκατοστίζω",
    "κάτου": "κάτω",
    "κατρουλιό": "κατουρλιό",
    "καυναδίζω": "καβγαδίζω",
    "καϋµός": "καηµός",
    "'κεί": "εκεί",
    "κείθε": "εκείθε",
    "καψόνι": "καψώνι",
    "καψύλλιο": "καψούλι",
    "κελάρης": "κελλάρης",
    "κελί": "κελλί",
    "κεντήτρια": "κεντήστρα",
    "κεσέµι": "γκεσέµι",
    "κέσιο": "καίσιο",
    "κηπάριο": "κήπος",
    "κινάρα": "αγκινάρα",
    "κιοφτές": "κεφτές",
    "κλαίγω": "κλαίω",
    "κλαπάτσα": "χλαπάτσα",
    "κλασσικίζω": "κλασικίζω",
    "κλασσικιστής": "κλασικιστής",
    "κλέπτης": "κλέφτης",
    "κληθρα": "σκλήθρα",
    "κλήρινγκ": "κλίρινγκ",
    "κλιπ": "βιντεοκλίπ",
    "κλωσά": "κλώσσα",
    "κλωτσιά": "κλοτσιά",
    "κογκλάβιο": "κονκλάβιο",
    "κογκρέσο": "κονγκρέσο",
    "κοιµίσης": "κοίµησης",
    "κοιµούµαι": "κοιµάµαι",
    "κοιτώ": "κοιτάζω",
    "κοιτάω": "κοιτάζω",
    "κόκαλο": "κόκκαλο",
    "κοκίτης": "κοκκύτης",
    "κοκκίαση": "κοκκίωση",
    "κοκκοφοίνικας": "κοκοφοίνικας",
    "κολάζ": "κολλάζ",
    "κολαντρίζω": "κουλαντρίζω",
    "κολαρίζω": "κολλαρίζω",
    "κολεχτίβα": "κολεκτίβα",
    "κολεχτιβισµός": "κολεκτιβισµός",
    "κολιγιά": "κολληγιά",
    "κολίγος": "κολλήγας",
    "κολίγας": "κολλήγας",
    "κολικόπονος": "κωλικόπονος",
    "κολιός": "κολοιός",
    "κολιτσίνα": "κολτσίνα",
    "κολυµπήθρα": "κολυµβήθρα",
    "κολώνα": "κολόνα",
    "κολώνια": "κολόνια",
    "κοµβόι": "κονβόι",
    "κόµις": "κόµης",
    "κόµισσα": "κόµης",
    "κόµιτας": "κόµης",
    "κοµιτεία": "κοµητεία",
    "κόµµατα": "κοµµάτι",
    "κοµµούνα": "κοµούνα",
    "κοµµουναλισµός": "κοµουναλισµός",
    "κοµµούνι": "κοµούνι",
    "κοµµουνίζω": "κοµουνίζω",
    "κοµµουνισµός": "κοµουνισµός",
    "κοµµουνιστής": "κοµουνιστής",
    "κονδυλοειδής": "κονδυλώδης",
    "κονδυλοειδές": "κονδυλώδες",
    "κονσέρτο": "κοντσέρτο",
    "κόντραµπαντιέρης": "κοντραµπατζής",
    "κοντσίνα": "κολτσίνα",
    "κονφορµισµός": "κοµφορµισµός",
    "κονφορµιστής": "κομφορμιστής",
    "κοπελιά": "κοπέλα",
    "κοπλιµέντο": "κοµπλιµέντο",
    "κόπτω": "κόβω",
    "κόπυραιτ": "κοπιράιτ",
    "Κοριτσα": "Κορυτσά",
    "κοριτσόπουλο": "κορίτσι",
    "κορνέτο": "κορνέτα",
    "κορνιζώνω": "κορνιζάρω",
    "κορόιδεµα": "κοροϊδία",
    "κορόνα": "κορώνα",
    "κορφή": "κορυφή",
    "κοσάρι": "εικοσάρικο",
    "κοσάρικο": "εικοσάρικο",
    "κοσµετολογία": "κοσµητολογία",
    "κοτάω": "κοτώ",
    "κουβαρνταλίκι": "χουβαρνταλίκι",
    "κουβαρντάς": "χουβαρντάς",
    "κουβερνάντα": "γκουβερνάντα",
    "κούκος": "κούκκος",
    "κουλλουρτζής": "κουλλουράς",
    "κουλούρας": "κουλλουράς",
    "κουλούρι": "κουλλούρι",
    "κουλουριάζω": "κουλλουριάζω",
    "κουλουρτζής": "κουλλουράς",
    "κουρδιστής": "χορδιστής",
    "κουρντιστής": "χορδιστής",
    "κουρντίζω": "κουρδίζω",
    "κουρντιστήρι": "κουρδιστήρι",
    "κουστούµι": "κοστούµι",
    "κουτεπιέ": "κουντεπιέ",
    "κόφτης": "κόπτης",
    "κόχη": "κόγχη",
    "κοψοχείλης": "κοψαχείλης",
    "κρεµάζω": "κρεµώ",
    "κροντήρι": "κρωντήρι",
    "κροµµύδι": "κρεµµύδι",
    "κροµµυδίλα": "κρεµµυδίλα",
    "κρουσταλλιάζω": "κρυσταλλιάζω",
    "κτένα": "χτένα",
    "κτενάκι": "χτενάκι",
    "κτένι": "χτένι",
    "κτενίζω": "χτενίζω",
    "κτένισµα": "χτένισµα",
    "κτίριο": "κτήριο",
    "κυλίω": "κυλώ",
    "κυττάζω": "κοιτάζω",
    "κωλ-γκέρλ": "κολ-γκέρλ",
    "κωλοµπαράς": "κολοµπαράς",
    "κωσταντινάτο": "κωνσταντινάτο",
    "Κώστας": "Κωνσταντίνος",
    "κώχη": "κόγχη",
    "λάβδα": "λάµβδα",
    "λαγούτο": "λαούτο",
    "λαγύνι": "λαγήνι",
    "λαίδη": "λέδη",
    "λαϊκάντζα": "λαϊκούρα",
    "λαιµά": "λαιµός",
    "λαΐνι": "λαγήνι",
    "λαµπράδα": "λαµπρότητα",
    "λάρος": "γλάρος",
    "λατόµι": "λατοµείο",
    "λαύδανο": "λάβδανο",
    "λαυράκι": "λαβράκι",
    "λαφίνα": "ελαφίνα",
    "λαφόπουλο": "ελαφόπουλο",
    "λειβάδι": "λιβάδι",
    "Λειβαδιά": "Λιβάδια",
    "λεϊµόνι": "λεµόνι",
    "λεϊµονιά": "λεµονιά",
    "Λειψία": "Λιψία",
    "λέοντας": "λέων",
    "λεπτά": "λεφτά",
    "λεπτύνω": "λεπταίνω",
    "λευκαστής": "λευκαντής",
    "Λευτέρης": "Ελευθέριος",
    "λευτερώνω": "ελευθερώνω",
    "λέω": "λέγω",
    "λιανεµπόριο": "λειανεµπόριο",
    "λιανίζω": "λειανίζω",
    "λιανοτούφεκο": "λειανοτούφεκο",
    "λιανοντούφεκο": "λειανοντούφεκο",
    "λιανοπούληµα": "λειανοπούληµα",
    "λιανοπωλητής": "λειανοπωλητής",
    "λιανοτράγουδο": "λειανοτράγουδο",
    "λιγοψυχία": "ολιγοψυχία",
    "λιθρίνι": "λυθρίνι",
    "λιµένας": "λιµάνι",
    "λίµπρα": "λίβρα",
    "λιοβολιά": "ηλιοβολία",
    "λιόδεντρο": "ελαιόδεντρο",
    "λιόλαδο": "ελαιόλαδο",
    "λιόσπορος": "ηλιόσπορος",
    "λιοτρίβειο": "ελαιοτριβείο",
    "λιοτρόπι": "ηλιοτρόπιο",
    "λιόφως": "ηλιόφως",
    "λιχουδιά": "λειχουδιά",
    "λιώνω": "λειώνω",
    "λογιωτατίζω": "λογιοτατίζω",
    "λογιώτατος": "λογιότατος",
    "λόγκος": "λόγγος",
    "λόξιγκας": "λόξυγγας",
    "λοτόµος": "υλοτόµος",
    "Λουµπλιάνα": "Λιουµπλιάνα",
    "λούω": "λούζω",
    "λύγξ": "λύγκας",
    "λυµφατισµός": "λεµφατισµός",
    "λυντσάρω": "λιντσάρω",
    "λυσσιακό": "λυσσακό",
    "λυώνω": "λειώνω",
    "Λωξάντρα": "Λοξάντρα",
    "λωρένσιο": "λορένσιο",
    "λωρίδα": "λουρίδα",
    "µαγγάνιο": "µαγκάνιο",
    "µαγγιώρος": "µαγκιόρος",
    "µαγειριά": "µαγεριά",
    "µάγειρος": "µάγειρας",
    "µόγερας": "µάγειρας",
    "µαγιώ": "µαγιό",
    "µαγκανοπήγαδο": "µαγγανοπήγαδο",
    "µαγκώνω": "µαγγώνω",
    "µαγνόλια": "µανόλια",
    "Μαγυάρος": "Μαγιάρος",
    "µαζύ": "µαζί",
    "µαζώνω": "µαζεύω",
    "µαιζονέτα": "µεζονέτα",
    "µαιτρ": "µετρ",
    "µαιτρέσα": "µετρέσα",
    "µακριός": "µακρύς",
    "μακριά": "µακρυά",
    "μακριό": "µακρύ",
    "µαλάσσω": "µαλάζω",
    "µαµά": "µαµµά",
    "µαµouδι": "µαµούνι",
    "µάνα": "µάννα",
    "µανδαρινέα": "µανταρινιά",
    "µανδήλι": "µαντήλι",
    "µάνδρα": "µάντρα",
    "µανές": "αµανές",
    "Μανόλης": "Εµµανουήλ",
    "µαντζούνι": "µατζούνι",
    "µαντζουράνα": "µατζουράνα",
    "µαντίλα": "µαντήλα",
    "µαντίλι": "µαντήλι",
    "µαντµαζέλ": "µαµαζέλ",
    "µαντρίζω": "µαντρώνω",
    "µαντώ": "µαντό",
    "Μανώλης": "Εµµανουήλ",
    "µάρτυς": "µάρτυρας",
    "µασκάλη": "µασχάλη",
    "µατοκυλίζω": "αιµατοκυλίζω",
    "µατοκύλισµα": "αιµατοκυλίζω",
    "µατσέτα": "µασέτα",
    "µαυράδα": "µαυρίλα",
    "μεγαλόπολη": "µεγαλούπολη",
    "µεγαλοσπληνία": "σπληνοµεγαλία",
    "µέγγενη": "µέγκενη",
    "μείκτης": "µίκτης",
    "µελίγγι": "µηλίγγι",
    "µεντελισµός": "µενδελισµός",
    "µενχίρ": "µενίρ",
    "µέρα": "ηµέρα",
    "µεράδι": "µοιράδι",
    "µερεύω": "ηµερεύω",
    "µέρµηγκας": "µυρµήγκι",
    "µερµήγκι": "µυρµήγκι",
    "µερσίνα": "µυρσίνη",
    "µερσίνη": "µυρσίνη",
    "µέρωµα": "ηµερώνω",
    "µερώνω": "ηµερώνω",
    "µέσον": "µέσο",
    "µεσοούρανα": "µεσούρανα",
    "µεταλίκι": "µεταλλίκι",
    "µεταπούληση": "µεταπώληση",
    "µεταπουλω": "µεταπωλώ",
    "µετοχιάριος": "µετοχάρης",
    "µητάτο": "µιτάτο",
    "µητριά": "µητρυιά",
    "µητριός": "µητρυιός",
    "Μιανµάρ": "Μυανµάρ",
    "Μίκι Μάους": "Μίκυ Μάους",
    "µικρύνω": "µικραίνω",
    "µινουέτο": "µενουέτο",
    "µιξοπαρθένα": "µειξοπαρθένα",
    "µισοφόρι": "µεσοφόρι",
    "µίτζα": "µίζα",
    "µολογώ": "οµολογώ",
    "μολογάω": "οµολογώ",
    "µοµία": "µούµια",
    "µοµιοποίηση": "µουµιοποίηση",
    "µονάρχιδος": "µόνορχις",
    "µονιάζω": "µονοιάζω",
    "µορφιά": "οµορφιά",
    "µορφονιός": "οµορφονιός",
    "µοσκάρι": "µοσχάρι",
    "µοσκοβολιά": "µοσκοβολιά",
    "µοσκοβολώ": "µοσχοβολώ",
    "µοσκοκαρυδιά": "µοσχοκαρυδιά",
    "µοσκοκάρυδο": "µοσχοκάρυδο",
    "µοσκοκάρφι": "µοσχοκάρφι",
    "µοσκολίβανο": "µοσχολίβανο",
    "µοσκοµπίζελο": "µοσχοµπίζελο",
    "µοσκοµυρίζω": "µοσχοµυρίζω",
    "µοσκοπουλώ": "µοσχοπουλώ",
    "µόσκος": "µόσχος",
    "µοσκοσάπουνο": "µοσχοσάπουνο",
    "µοσκοστάφυλο": "µοσχοστάφυλο",
    "µόσχειος": "µοσχαρήσιος",
    "μόσχειο": "µοσχαρήσιο",
    "µουλώνω": "µουλαρώνω",
    "µουρταδέλα": "µορταδέλα",
    "µουσικάντης": "µουζικάντης",
    "µουσσώνας": "µουσώνας",
    "µουστάκα": "µουστάκι",
    "µουστακοφόρος": "µυστακοφόρος",
    "µπαγάζια": "µπαγκάζια",
    "πάγκα": "µπάνκα",
    "µπαγκαδορος": "µπανκαδόρος",
    "µπογκέρης": "µπανκέρης",
    "µπάγκος": "πάγκος",
    "µπαιν-µαρί": "µπεν-µαρί",
    "µπαλάντα": "µπαλλάντα",
    "µπαλαντέζα": "µπαλλαντέζα",
    "µπαλαντέρ": "µπαλλαντέρ",
    "µπαλάντζα": "παλάντζα",
    "µπαλένα": "µπαλαίνα",
    "µπαλέτο": "µπαλλέτο",
    "µπάλος": "µπάλλος",
    "µπάλσαµο": "βάλσαµο",
    "µπαλσάµωµα": "βαλσάµωµα",
    "µπαλσαµώνω": "βαλσαµώνω",
    "µπάλωµα": "µπάλλωµα",
    "µπαλώνω": "µπαλλώνω",
    "µπαµπάκι": "βαµβάκι",
    "µπαµπακόσπορος": "βαµβακόσπορος",
    "Μπάµπης": "Χαραλάµπης",
    "µπάµπω": "βάβω",
    "µπανέλα": "µπαναίλα",
    "µπαρµπρίζ": "παρµπρίζ",
    "µπατίστα": "βατίστα",
    "µπαχτσές": "µπαξές",
    "µπαχτσίσι": "µπαξίσι",
    "µπεζεβέγκης": "πεζεβέγκης",
    "µπελτές": "πελτές",
    "µπεντόνι": "µπιντόνι",
    "µπερδουκλώνω": "µπουρδουκλώνω",
    "µπερκέτι": "µπερεκέτι",
    "µπετόνι": "µπιτόνι",
    "µπεχαβιορισµός": "µπιχεβιορισµός",
    "µπεχλιβάνης": "πεχλιβάνης",
    "µπιγκουτί": "µπικουτί",
    "µπιµπίλα": "µπιρµπίλα",
    "µπιµπλό": "µπιµπελό",
    "µπιρσίµι": "µπρισίµι",
    "µπις": "µπιζ",
    "µπιστόλα": "πιστόλα",
    "µπιστόλι": "πιστόλι",
    "µπιστολιά": "πιστολιά",
    "µπιτόνι": "µπιντόνι",
    "µπογιάρος": "βογιάρος",
    "µπονάτσα": "µπουνάτσα",
    "µπονατσάρει": "µπουνατσάρει",
    "µπουά": "µποά",
    "µπουκαµβίλια": "βουκαµβίλια",
    "µποϋκοταζ": "µποϊκοτάζ",
    "µποϋκοτάρω": "µποϊκοτάρω",
    "µπουλβάρ": "βουλεβάρτο",
    "µπουρδέλο": "µπορντέλο",
    "µπουρµπουάρ": "πουρµπουάρ",
    "µπρίζα": "πρίζα",
    "µπριτζόλα": "µπριζόλα",
    "µπρος": "εµπρός",
    "µπύρα": "µπίρα",
    "µπυραρία": "µπιραρία",
    "µπυροποσία": "µπιροποσία",
    "µυγδαλιά": "αµυγδαλιά",
    "µύγδαλο": "αµύγδαλο",
    "µυλόρδος": "µιλόρδος",
    "μυρουδιά": "µυρωδιά",
    "µυτζήθρα": "µυζήθρα",
    "µύωψ": "µύωπας",
    "µώλος": "µόλος",
    "νέθω": "γνέθω",
    "νι": "νυ",
    "νίκελ": "νικέλιο",
    "νοµεύς": "νοµέας",
    "νοστιµίζω": "νοστιµεύω",
    "νουννός": "νοννός",
    "νταβάνι": "ταβάνι",
    "ντάβανος": "τάβανος",
    "νταβανόσκουπα": "ταβανόσκουπα",
    "νταβούλι": "νταούλι",
    "νταλαβέρι": "νταραβέρι",
    "νταµπλάς": "ταµπλάς",
    "ντελαπάρω": "ντεραπάρω",
    "ντενεκές": "τενεκές",
    "ντερβεναγος": "δερβέναγας",
    "ντερβένι": "δερβένι",
    "ντερβίσης": "δερβίσης",
    "ντερβισόπαιδο": "δερβισόπαιδο",
    "ντοκυµανταίρ": "ντοκιµαντέρ",
    "ντουνρού": "ντογρού",
    "ντουζ": "ντους",
    "ντουζιέρα": "ντουσιέρα",
    "Ντούµα": "∆ούµα",
    "ντούπλεξ": "ντούµπλεξ",
    "ντουφέκι": "τουφέκι",
    "ντουφεκίδι": "τουφεκίδι",
    "ντουφεκίζω": "τουφεκίζω",
    "ντουφεξής": "τουφεξής",
    "νύκτα": "νύχτα",
    "νυκτωδία": "νυχτωδία",
    "νωµατάρχης": "ενωµοτάρχης",
    "ξανεµίζω": "εξανεµίζω",
    "ξεγνοιάζω": "ξενοιάζω",
    "ξεγνοιασιά": "ξενοιασιά",
    "ξελαφρώνω": "ξαλαφρώνω",
    "ξεπίτηδες": "επίτηδες",
    "ξεπιτούτου": "εξεπιτούτου",
    "ξεσκάζω": "ξεσκάω",
    "ξεσπάζω": "ξεσπώ",
    "ξεσχίζω": "ξεσκίζω",
    "ξέσχισµα": "ξεσκίζω",
    "ξευτελίζω": "εξευτελίζω",
    "ξεφτίζω": "ξεφτύζω",
    "ξεφτίλα": "ξευτίλα",
    "ξεφτίλας": "ξευτίλας",
    "ξεφτιλίζω": "ξευτιλίζω",
    "ξεχάνω": "ξεχνώ",
    "ξηγώ": "εξηγώ",
    "ξηροφαγία": "ξεροφαγία",
    "ξηροφαγιά": "ξεροφαγία",
    "ξι": "ξει",
    "ξιπασιά": "ξυπασιά",
    "ξίπασµα": "ξύπασµα",
    "ξιπολησιά": "ξυπολυσιά",
    "ξιπολιέµαι": "ξυπολιέµαι",
    "εξοµολόγηση": "ξομολόγηση",
    "ξοµολογητής": "εξοµολογητής",
    "ξοµολόγος": "εξοµολόγος",
    "ξοµολογώ": "εξοµολογώ",
    "ξουράφι": "ξυράφι",
    "ξουράφια": "ξυραφιά",
    "ξόφληση": "εξόφληση",
    "ξύγγι": "ξίγγι",
    "ξύγκι": "ξίγγι",
    "ξύδι": "ξίδι",
    "ξυλοσκίστης": "ξυλοσχίστης",
    "ξυλώνω": "ξηλώνω",
    "ξυνωρίδα": "συνωρίδα",
    "ξώθυρα": "εξώθυρα",
    "ξώπορτα": "εξώπορτα",
    "ξώφυλλο": "εξώφυλλο",
    "οδοντογιατρός": "οδοντίατρος",
    "οδοντόπονος": "πονόδοντος",
    "οικογενειακά": "οικογενειακώς",
    "οικοκυρά": "νοικοκυρά",
    "οκτάς": "οκτάδα",
    "οκταετής": "οχταετής",
    "οκταετές": "οχταετές",
    "οκταετία": "οχταετία",
    "οµοιάζω": "µοιάζω",
    "οµοιώνω": "εξοµοιώνω",
    "οµόµετρο": "ωµόµετρο",
    "οµορφάδα": "οµορφιά",
    "οµπρός": "εµπρός",
    "ονείρεµα": "όνειρο",
    "οξείδιο": "οξίδιο",
    "οξειδοαναγωγή": "οξιδοαναγωγή",
    "οξειδώνω": "οξιδώνω",
    "οξείδωση": "οξίδωση",
    "οξειδωτής": "οξιδωτής",
    "οξιζενέ": "οξυζενέ",
    "οπίσω": "πίσω",
    "οργιά": "οργυιά",
    "όρνεο": "όρνιο",
    "όρνις": "όρνιθα",
    "ορρός": "ορός",
    "όσµωση": "ώσµωση",
    "οστεΐτιδα": "οστίτιδα",
    "οστεογονία": "οστεογένεση",
    "οφίτσιο": "οφίκιο",
    "οφφίκιο": "οφίκιο",
    "οχτάβα": "οκτάβα",
    "οχτάδα": "οκτάδα",
    "οχταετία": "οκταετία",
    "οχτακόσια": "οκτακόσια",
    "οχτακόσιοι": "οκτακόσιοι",
    "οχτακόσιες": "οκτακόσιες",
    "οχτακόσια": "οκτακόσια",
    "όχτρητα": "έχθρητα",
    "οχτώ": "οκτώ",
    "Οχτώβρης": "Οκτώβριος",
    "οψιανός": "οψιδιανός",
    "παγαίνω": "πηγαίνω",
    "παγόνι": "παγώνι",
    "παιγνίδι": "παιχνίδι",
    "παίδαρος": "παίδαρος",
    "παίχτης": "παίκτης",
    "παλικαράς": "παλληκαράς",
    "παλικάρι": "παλληκάρι",
    "παλικαριά": "παλληκαριά",
    "παλικαροσύνη": "παλληκαροσύνη",
    "παλληκαρίστίκος": "παλληκαρήσιος",
    "παλληκαρίστικη": "παλληκαρήσια",
    "παλληκαρίστικο": "παλληκαρήσιο",
    "παλληκαροσύνη": "παλληκαριά",
    "πανταλόνι": "παντελόνι",
    "παντατίφ": "πανταντίφ",
    "πανταχούσα": "απανταχούσα",
    "Πάντοβα": "Πάδοβα",
    "παντούφλα": "παντόφλα",
    "παντοχή": "απαντοχή",
    "πανψυχισµός": "παµψυχισµός",
    "πάνω": "επάνω",
    "παπαδάκι": "παππαδάκι",
    "παπαδαρειό": "παππαδαρειό",
    "παπαδιά": "παππαδιά",
    "παπαδοκόρη": "παππαδοκόρη",
    "παπαδοκρατούµαι": "παππαδοκρατούµαι",
    "παπαδολόι": "παππαδολόι",
    "παπαδοπαίδι": "παππαδοπαίδι",
    "παπαδοπούλα": "παππαδοπούλα",
    "Παπαδόπουλο": "παππαδόπουλο",
    "παπατζής": "παππατζής",
    "παπατρέχας": "παππατρέχας",
    "παραγιάς": "παραγυιός",
    "παρανυχίδα": "παρωνυχίδα",
    "παρεισφρύω": "παρεισφρέω",
    "παρεννοώ": "παρανοώ",
    "παρ' ολίγο": "παραλίγο",
    "πασαβιόλα": "µπασαβιόλα",
    "πασάλειµµα": "πασσάλειµµα",
    "πασαλείφω": "πασσαλείφω",
    "πασκίζω": "πασχίζω",
    "παστρουµάς": "παστουρµάς",
    "πατερµά": "πατερηµά",
    "πατήρ": "πατέρας",
    "πατούνα": "πατούσα",
    "πατριός": "πατρυιός",
    "πάτρονας": "πάτρωνας",
    "πάψη": "παύση",
    "πεθυµώ": "επιθυµώ",
    "πείρος": "πίρος",
    "πελέκι": "πέλεκυς",
    "πελεκίζω": "πελεκώ",
    "πελλόγρα": "πελάγρα",
    "πεντήκοντα": "πενήντα",
    "πεντόβολα": "πεντόβωλα",
    "πεντόδραχµο": "πεντάδραχµο",
    "περβολάρης": "περιβολάρης",
    "περβόλι": "περιβόλι",
    "περδικλώνω": "πεδικλώνω",
    "περηφανεύοµαι": "υπερηφανεύοµαι",
    "περηφάνια": "υπερηφάνεια",
    "περικόβω": "περικόπτω",
    "περιπατώ": "περπατώ",
    "περιστεριώνας": "περιστερώνας",
    "περιτάµω": "περιτέµνω",
    "περιφάνεια": "περηφάνια",
    "περιφράζω": "περιφράσσω",
    "περιχαράζω": "περιχαράσσω",
    "περιχέω": "περιχύνω",
    "περντάχι": "µπερντάχι",
    "πέρπυρο": "υπέρπυρο",
    "πέρσι": "πέρυσι",
    "πετούγια": "µπετούγια",
    "πευκιάς": "πευκώνας",
    "πηγεµός": "πηγαιµός",
    "πηγούνι": "πιγούνι",
    "πήτα": "πίτα",
    "πήχυς": "πήχης",
    "πι": "πει",
    "πιζάµα": "πιτζάµα",
    "πιθαµή": "σπιθαµή",
    "πιθώνω": "απιθώνω",
    "πίκρισµα": "πικρίζω",
    "πιλαλώ": "πηλαλώ",
    "Πιλάτος": "Πόντιος Πιλάτος",
    "πιοτό": "ποτό",
    "πιπίζω": "πιππίζω",
    "πιρέξ": "πυρέξ",
    "πίστοµα": "απίστοµα",
    "πιτσιλάδα": "πιτσυλάδα",
    "πιτσιλιά": "πιτσυλιά",
    "πίττα": "πίτα",
    "πίτυρον": "πίτουρο",
    "πλάγι": "πλάι",
    "πλανάρω": "πλανίζω",
    "πλάσσω": "πλάθω",
    "πλειονοψηφία": "πλειοψηφία",
    "πλείονοψηφώ": "πλειοψηφώ",
    "πλεξίδα": "πλεξούδα",
    "πλερωµή": "πληρωµή",
    "πλερώνω": "πληρώνω",
    "πλέυ µπόυ": "πλεϊµπόι",
    "πλέχτης": "πλέκτης",
    "πληµµύρα": "πληµύρα",
    "πνιγµός": "πνίξιµο",
    "πνευµονόκοκκος": "πνευµονιόκοκκος",
    "ποιµήν": "ποιµένας",
    "πόλις": "πόλη",
    "πόλιτσµαν": "πόλισµαν",
    "πολιτσµάνος": "πόλισµαν",
    "πολύµπριζο": "πολύπριζο",
    "πολυπάω": "πολυπηγαίνω",
    "πολύπους": "πολύποδας",
    "Πόρτο Ρίκο": "Πουέρτο Ρίκο",
    "ποταπαγόρευση": "ποτοαπαγόρευση",
    "πούντρα": "πούδρα",
    "πράµα": "πράγµα",
    "πρεβάζι": "περβάζι",
    "πρέπον": "πρέπων",
    "προαγάγω": "προάγω",
    "προδίνω": "προδίδω",
    "προιξ": "προίκα",
    "προποτζής": "προπατζής",
    "προσαγάγω": "προσάγω",
    "πρόσµιξη": "πρόσµειξη",
    "προσφύγω": "προσφεύγω",
    "προφθάνω": "προφταίνω",
    "προφυλάω": "προφυλάσσω",
    "προψές": "προχθές",
    "πρύµη": "πρύµνη",
    "πταρνίζοµαι": "φταρνίζοµαι",
    "πτελέα": "φτελιά",
    "πτέρνα": "φτέρνα",
    "πτερυγίζω": "φτερουγίζω",
    "πτιφούρ": "πετιφούρ",
    "πτι-φούρ": "πετιφούρ",
    "πτωχαίνω": "φτωχαίνω",
    "πτώχεια": "φτώχια",
    "πυκνά": "πυκνός",
    "πυλωτή": "πιλοτή",
    "πύο": "πύον",
    "πυρογενής": "πυριγενής",
    "πυρογενές": "πυριγενές",
    "πυτζάµα": "πιτζάµα",
    "ραγκλόν": "ρεγκλάν",
    "ραγού": "ραγκού",
    "ραΐζω": "ραγίζω",
    "ραίντνκεν": "ρέντγκεν",
    "ράντζο": "ράντσο",
    "ράπτω": "ράβω",
    "ρεβανί": "ραβανί",
    "ρέγγε": "ρέγκε",
    "Ρεγγίνα": "Ρεγκίνα",
    "ρεµούλκα": "ρυµούλκα",
    "ασκέρι": "ασκέρι",
    "ρεοβάση": "ρευµατοβάση",
    "ρεπανάκι": "ραπανάκι",
    "ρεπάνι": "ραπάνι",
    "ρεύω": "ρέβω",
    "ρήγα": "ρίγα",
    "ρηµοκκλήσι": "ερηµοκκλήσι",
    "ριγκ": "ρινγκ",
    "ριζότο": "ρυζότο",
    "ροβίθι": "ρεβίθι",
    "ροβιθιά": "ρεβιθιά",
    "ροδακινιά": "ρωδακινιά",
    "ροδάκινο": "ρωδάκινο",
    "ρόιδι": "ρόδι",
    "ροϊδιά": "ροδιά",
    "ρόιδο": "ρόδι",
    "ροοστάτης": "ρεοστάτης",
    "ροφώ": "ρουφώ",
    "ρωδιός": "ερωδιός",
    "ρωθωνίζω": "ρουθουνίζω",
    "ρωµαντισµός": "ροµαντισµός",
    "Ρωσσία": "Ρωσία",
    "ρωτώ": "ερωτώ",
    "σάζω": "σιάζω",
    "σαιζλόνγκ": "σεζλόνγκ",
    "σαιζόν": "σεζόν",
    "σαγολαίφα": "σακολαίβα",
    "σάκκα": "σάκα",
    "σακκάκι": "σακάκι",
    "σακκάς": "σακάς",
    "σακκί": "σακί",
    "σακκίδιο": "σακίδιο",
    "σακκοβελόνα": "σακοβελόνα",
    "σακκογκόλιθος": "σακογκόλιθος",
    "σακκοειδής": "σακοειδής",
    "σακκοειδές": "σακοειδες",
    "σακκοράφα": "σακοράφα",
    "σάκκος": "σάκος",
    "σακκουλα": "σακούλα",
    "σακκουλάκι": "σακούλι",
    "σακκουλεύοµαι": "σακουλεύοµαι",
    "σακκούλι": "σακούλι",
    "σακκουλιάζω": "σακουλιάζω",
    "σακχαροδιαβήτης": "ζαχαροδιαβήτης",
    "σάκχαροκαλάµο": "ζαχαροκάλαµο",
    "σακχαροποιία": "ζαχαροποιία",
    "σακχαρότευτλον": "ζαχαρότευτλο",
    "σαλιαρίστρα": "σαλιάρα",
    "σαλπιστής": "σαλπιγκτής",
    "σαντακρούτα": "σατακρούτα",
    "σαντάλι": "σανδάλι",
    "σάνταλο": "σανδάλι",
    "σάρρα": "σάρα",
    "σαφρίδι": "σαυρίδι",
    "σαχάνι": "σαγάνι",
    "σβολιάζω": "σβωλιάζω",
    "σβώλιασμα": "σβόλιασµα",
    "σβόλος": "σβώλος",
    "σβύνω": "σβήνω",
    "σγουρώνω": "σγουραίνω",
    "σενκόντο": "σεκόντο",
    "σεγκούνα": "σιγκούνα",
    "σεγόντο": "σεκόντο",
    "Σειληνός": "Σιληνός",
    "σείρακας": "σείρικας",
    "σειρήτι": "σιρίτι",
    "σεκονταρω": "σιγοντάρω",
    "σεγκοντάρω": "σιγοντάρω",
    "σελιλόιντ": "σελουλόιντ",
    "σέλλα": "σέλα",
    "σεξπιριστής": "σαιξπηριστής",
    "Σεράγεβο": "Σαράγεβο",
    "σεστέτο": "σεξτέτο",
    "σετέτο": "σεπτέτο",
    "σέχτα": "σέκτα",
    "σεχταρισµός": "σεκταρισµός",
    "σηµαφόρος": "σηµατοφόρος",
    "σήριαλ": "σίριαλ",
    "σηψίνη": "σηπτίνη",
    "σιγάρο": "τσιγάρο",
    "σιγαροθήκη": "τσιγαροθήκη",
    "σίγλος": "σίκλος",
    "σιγόντο": "σεκόντο",
    "Σίδνεϊ": "Σύδνεϋ",
    "σίελος": "σίαλος",
    "σινθεσάιζερ": "συνθεσάιζερ",
    "σιντέφι": "σεντέφι",
    "σιορ": "σινιόρ",
    "σιρυΐάνι": "σεργιάνι",
    "σιρµαγιά": "σερµαγιά",
    "σίτα": "σήτα",
    "σταρέµπορος": "σιτέµπορος",
    "σκανδαλιά": "σκανταλιά",
    "σκάνταλο": "σκάνδαλο",
    "σκάπτω": "σκάβω",
    "σκάρα": "σχάρα",
    "σκαρµός": "σκαλµός",
    "σκάφτω": "σκάβω",
    "σκεβρώνω": "σκευρώνω",
    "σκερπάνι": "σκεπάρνι",
    "σκίζα": "σχίζα",
    "σκίζω": "σχίζω",
    "σκίνος": "σχίνος",
    "σκίσιµο": "σχίσιµο",
    "σκισµάδα": "σχισµάδα",
    "σκισµή": "σχισµή",
    "σκλήρωση": "σκλήρυνση",
    "σκοινάκι": "σχοινάκι",
    "σκονί": "σχοινί",
    "σκοινί": "σχοινί",
    "σκοίνος": "σχοίνος",
    "σκολάω": "σχολώ",
    "σκολειαρόπαιδο": "σχολειαρόπαιδο",
    "σκολειαρούδι": "σχολειαρούδι",
    "σκολειό": "σχολείο",
    "σκόλη": "σχόλη",
    "σκολιαρόπαιδο": "σχολειαρόπαιδο",
    "σκολιαρούδι": "σχολειαρούδι",
    "σκολιό": "σχολειό",
    "σκολνώ": "σχολώ",
    "σκολώ": "σχολώ",
    "Σκοτία": "Σκωτία",
    "σκότισµα": "σκοτισµός",
    "Σκοτσέζος": "Σκωτσέζος",
    "σκουντούφληµα": "σκουντούφλα",
    "σκώληξ": "σκουλήκι",
    "σκώτι": "συκώτι",
    "σοβαντεπί": "σοβατεπί",
    "σοβατίζω": "σοβαντίζω",
    "σοροκολεβάντες": "σιροκολεβάντες",
    "σορόκος": "σιρόκος",
    "σοροπιάζω": "σιροπιάζω",
    "σουβατίζω": "σοβαντίζω",
    "σουβαντίζω": "σοβαντίζω",
    "σουβάς": "σοβάς",
    "σουβατεπί": "σοβαντεπί",
    "σοβατεπί": "σοβαντεπί",
    "σουµιέ": "σοµιέ",
    "σούρσιµο": "σύρσιµο",
    "σουσπασιόν": "σισπανσιόν",
    "σοφεράρω": "σοφάρω",
    "σπαής": "σπαχής",
    "σπαράσσω": "σπαράζω",
    "σπερµατσετο": "σπαρµατσέτο",
    "σπερµίνη": "σπερµατίνη",
    "σπερµοβλάστη": "σπερµατοβλάστη",
    "σπερµογονία": "σπερµατογονία",
    "σπερµοδότης": "σπερµατοδότης",
    "σπερµοδόχος": "σπερµατοδόχος",
    "σπερμοδόχο": "σπερµατοδόχο",
    "σπερµοθήκη": "σπερµατοθήκη",
    "σπερµοκτόνος": "σπερµατοκτόνος",
    "σπερμοκτόνο": "σπερµατοκτόνο",
    "σπερµοτοξίνη": "σπερµατοτοξίνη",
    "σπερµοφάγος": "σπερµατοφάγος",
    "σπερμοφάγο": "σπερµατοφάγο",
    "σπερµοφόρος": "σπερµατοφόρος",
    "σπερμοφόρο": "σπερµατοφόρο",
    "σπινάρω": "σπινιάρω",
    "σπιράλ": "σπειράλ",
    "σπλάχνο": "σπλάγχνο",
    "σπογγίζω": "σφουγγίζω",
    "σπω": "σπάζω",
    "Στάθης": "Ευστάθιος",
    "στάλαµα": "στάλαγµα",
    "σταλαµατιά": "σταλαγµατιά",
    "σταλαξιά": "σταλαγµατιά",
    "σταλίτσα": "σταλιά",
    "σταρήθρα": "σιταρήθρα",
    "στάρι": "σιτάρι",
    "σταρότοπος": "σιταρότοπος",
    "σταχολογώ": "σταχυολογώ",
    "στειρεύω": "στερεύω",
    "στειροποιώ": "στειρώνω",
    "Στέλιος": "Στυλιανός",
    "Στέλλα": "Στυλιανή",
    "στεναχώρια": "στενοχώρια",
    "στεναχωρώ": "στενοχωρώ",
    "στένω": "στήνω",
    "στέριωµα": "στερέωµα",
    "στεριώνω": "στερεώνω",
    "στέρξιµο": "στέργω",
    "στιλ": "στυλ",
    "στιλάκι": "στυλάκι",
    "στιλιζάρω": "στυλιζάρω",
    "στιλίστας": "στυλίστας",
    "στιλό": "στυλό",
    "στιφάδο": "στυφάδο",
    "στορίζω": "ιστορώ",
    "στόρισµα": "ιστόρηση",
    "στραβοµάρα": "στραβωµάρα",
    "στραγγουλίζω": "στραγγαλίζω",
    "Στρατής": "Ευστράτιος",
    "στρατί": "στράτα",
    "στρατοποίηση": "στρατιωτικοποίηση",
    "Στράτος": "Ευστράτιος",
    "στρένω": "στέργω",
    "στριµόκωλα": "στρυµόκωλα",
    "στριµωξίδι": "στρυµωξίδι",
    "στριµώχνω": "στρυµώχνω",
    "στύβω": "στείβω",
    "στυπώνω": "στουπώνω",
    "σύγνεφο": "σύννεφο",
    "συγνώµη": "συγγνώµη",
    "συδαυλίζω": "συνδαυλίζω",
    "συµπαρασέρνω": "συµπαρασύρω",
    "συµπεθεριά": "συµπεθεριό",
    "δεκαέξι": "δεκάξι",
    "συνήθιο": "συνήθειο",
    "συντάµω": "συντέµνω",
    "συντριβάνι": "σιντριβάνι",
    "συνυφάδα": "συννυφάδα",
    "συφορά": "συµφορά",
    "συχώρεση": "συγχώρηση",
    "συχωρώ": "συγχωρώ",
    "συχωροχάρτι": "συγχωροχάρτι",
    "σφαλνώ": "σφαλίζω",
    "σφεντάµι": "σφένδαµνος",
    "σφερδούκλι": "σπερδούκλι",
    "σφόνδυλος": "σπόνδυλος",
    "σωβινισµός": "σοβινισµός",
    "σωβινιστής": "σοβινιστής",
    "σώνω": "σώζω",
    "σωρείτης": "σωρίτης",
    "σωτάρω": "σοτάρω",
    "σωτέ": "σοτέ",
    "Σωτήρης": "Σωτήριος",
    "σωφέρ": "σοφέρ",
    "ταβατούρι": "νταβαντούρι",
    "ταβερνούλα": "ταβέρνα",
    "ταβλάς": "ταµπλάς",
    "ταγιαδόρος": "ταλιαδόρος",
    "ταγίζω": "ταΐζω",
    "τάγισµα": "τάισµα",
    "ταγκό": "τανγκό",
    "ταή": "ταγή",
    "τάλαρο": "τάλιρο",
    "τάλληρο": "τάλιρο",
    "ταµίευση": "αποταµίευση",
    "ταµιεύω": "αποταµιεύω",
    "ταµώ": "τέµνω",
    "ταξείδι": "ταξίδι",
    "ταπεραµέντο": "ταµπεραµέντο",
    "ταράσσω": "ταράζω",
    "ταχτοποίηση": "τακτοποίηση",
    "ταχτοποιώ": "τακτοποιώ",
    "τελάλης": "ντελάλης",
    "τελολογία": "τελεολογία",
    "τεριρέµ": "τερερέµ",
    "τερραίν": "τερέν",
    "τέσσαρα": "τέσσερα",
    "τετράς": "τετράδα",
    "τζέντζερης": "τέντζερης",
    "τζετζερέδια": "τεντζερέδια",
    "τζιριτζάντζουλα": "τζυριτζάτζουλα",
    "τζίρος": "τζύρος",
    "τζιτζιµπίρα": "τσιτσιµπίρα",
    "τηκ": "τικ",
    "τηλοµοιοτύπηµα": "τηλεοµοιοτύπηµα",
    "τηλοµοιοτυπία": "τηλεοµοιοτυπία",
    "τηλοµοιοτυπώ": "τηλεοµοιοτυπώ",
    "τιτιβίζω": "τιττυβίζω",
    "τµήθηκα": "τέµνω",
    "τµήσω": "τέµνω",
    "Τόκιο": "Τόκυο",
    "τοµάτα": "ντοµάτα",
    "τοµατιά": "ντοµατιά",
    "τοµατοπολτός": "ντοµατοπολτός",
    "τοµατοσαλάτα": "ντοµατοσαλάτα",
    "τονθορύζω": "υποτονθορύζω",
    "τορβάς": "ντορβάς",
    "τορνάρω": "τορνεύω",
    "τορπίλα": "τορπίλη",
    "τούνδρα": "τούντρα",
    "Τουρκάλα": "Τούρκος",
    "τράβαλα": "ντράβαλα",
    "τραΐ": "τραγί",
    "τραινάρισµα": "τρενάρισµα",
    "τραινάρω": "τρενάρω",
    "τραίνο": "τρένο",
    "τρακόσοι": "τριακόσιοι",
    "τραπεζάκι": "τραπέζι",
    "τρέµουλο": "τρεµούλα",
    "τρέψω": "τρέπω",
    "τριάµισι": "τρεισήµισι",
    "τρικλίζω": "τρεκλίζω",
    "τρίκλισµα": "τρέκλισµα",
    "τρίπλα": "ντρίπλα",
    "τριπλαδόρος": "ντριπλαδόρος",
    "τριπλάρω": "ντριπλάρω",
    "τρίπους": "τρίποδας",
    "τρόπις": "τρόπιδα",
    "τρυκ": "τρικ",
    "τσαγγαράδικο": "τσαγκαράδικο",
    "τσογγάρης": "τσαγκάρης",
    "τσαγγάρικο": "τσαγκάρικο",
    "τσαγγαροδευτέρα": "τσαγκαροδευτέρα",
    "τσάµπα": "τζάµπα",
    "τσαµπατζής": "τζαµπατζής",
    "τσαντίζω": "τσατίζω",
    "τσαντίλα": "τσατίλα",
    "τσαντίλας": "τσατίλας",
    "τσάντισµα": "τσάτισµα",
    "τσίβα": "τζίβα",
    "τσίκλα": "τσίχλα",
    "τσιµεντώνω": "τσιµεντάρω",
    "τσιπούρα": "τσιππούρα",
    "τσιρίζω": "τσυρίζω",
    "τσιριτσάντζουλα": "τζιριτζάντζουλα",
    "τσιρότο": "τσηρώτο",
    "τσίτα": "τσήτα",
    "τσιτσιρίζω": "τσυτσυρίζω",
    "τσιτσίρισµα": "τσυτσυρίζω",
    "τσίτωµα": "τσήτωµα",
    "τσοµπάνος": "τσοµπάνης",
    "τσοπάνης": "τσοµπάνης",
    "τσοπανόπουλο": "τσοµπανόπουλο",
    "τσοπάνος": "τσοµπάνης",
    "τσύνορο": "τσίνορο",
    "τυράγνισµα": "τυράννισµα",
    "τυραγνω": "τυραννώ",
    "τυφεκίζω": "τουφεκίζω",
    "τυφεκισµός": "τουφεκισµός",
    "υαλόχαρτον": "γυαλόχαρτο",
    "υαλόχαρτο": "γυαλόχαρτο",
    "υάρδα": "γιάρδα",
    "ύβρη": "ύβρις",
    "υδατοσκοπια": "υδροσκοπία",
    "υδραέριο": "υδαταέριο",
    "ύελος": "ύαλος",
    "Υόρκη Νέα": "Νέα Υόρκη",
    "υποδείχνω": "υποδεικνύω",
    "υπόδεσις": "υπόδηση",
    "υποκάµισο": "πουκάµισο",
    "φαγκρί": "φαγγρί",
    "φαγοκύτωση": "φαγοκυττάρωση",
    "ψόγουσα": "φαγέδαινα",
    "φαγωµός": "φαγωµάρα",
    "φάδι": "υφάδι",
    "φαινοµεναλισµός": "φαινοµενοκρατία",
    "φαινοµενισµός": "φαινοµενοκρατία",
    "φαίνω": "υφαίνω",
    "φαλακρώνω": "φαλακραίνω",
    "φαµίλια": "φαµελιά",
    "φαµφάρα": "φανφάρα",
    "φαµφαρονισµος": "φανφαρονισµός",
    "φαµφαρόνος": "φανφαρόνος",
    "φαράκλα": "φαλάκρα",
    "φαρµασόνος": "φραµασόνος",
    "φαρµπαλάς": "φραµπαλάς",
    "φασουλάδα": "φασολάδα",
    "φασουλάκια": "φασολάκια",
    "φασουλιά": "φασολιά",
    "φασούλι": "φασόλι",
    "φελόνι": "φαιλόνιο",
    "φελώ": "ωφελώ",
    "φεουδαλισµός": "φεουδαρχισµός",
    "φερµάνι": "φιρµάνι",
    "φέτος": "εφέτος",
    "φθήνια": "φτήνια",
    "Φιλανδία": "Φινλανδία",
    "φιλενάδα": "φιλαινάδα",
    "φιλιστρίνι": "φινιστρίνι",
    "φιλόφρονας": "φιλόφρων",
    "φιντάνι": "φυντάνι",
    "φιορντ": "φιόρδ",
    "φίσκα": "φύσκα",
    "φκειάνω": "φτειάχνω",
    "φκιάνω": "φτειάχνω",
    "φκειασιδι": "φτειασίδι",
    "φκειασίδωµα": "φτειασίδωµα",
    "φκειασιδώνω": "φτειασιδώνω",
    "φκιασιδι": "φτειασίδι",
    "φκιασίδωµα": "φτειασίδωµα",
    "φκιασιδώνω": "φτειασιδώνω",
    "φκυάρι": "φτυάρι",
    "Φλάνδρα": "Φλαµανδία",
    "φλισκούνι": "φλησκούνι",
    "φλοίδα": "φλούδα",
    "φλοµιάζω": "φλοµώνω",
    "φλορίνι": "φιορίνι",
    "φλυτζάνι": "φλιτζάνι",
    "φοβούµαι": "φοβάµαι",
    "φονεύς": "φονιάς",
    "φόντα": "φόντο",
    "φουσέκι": "φισέκι",
    "φούχτα": "χούφτα",
    "φουχτώνω": "χουφτώνω",
    "Φραγκφούρτη": "Φρανκφούρτη",
    "φράσσω": "φράζω",
    "Φρίντα": "Φρειδερίκη",
    "Φροσύνη": "Ευφροσύνη",
    "Φρόσω": "Ευφροσύνη",
    "φροϋδισµος": "φροϊδισµός",
    "φρουµάζω": "φριµάζω",
    "φρούµασµα": "φρίµασµα",
    "φτάνω": "φθάνω",
    "φταρνίζοµαι": "φτερνίζοµαι",
    "φτειάνω": "φτειάχνω",
    "φτηνά": "φθηνά",
    "φτηναίνω": "φθηναίνω",
    "φτιασίδι": "φτειασίδι",
    "φτιασιδώνοµαι": "φτειασιδώνοµαι",
    "φτωχοκοµείο": "πτωχοκοµείο",
    "φυγάδας": "φυγάς",
    "φύγω": "φεύγω",
    "φυλάγω": "φυλάσσω",
    "φυλλαράκι": "φύλλο",
    "φυλλόδεντρο": "φιλόδεντρο",
    "φυλώ": "φυλάσσω",
    "φυσέκι": "φισέκι",
    "φυσεκλίκι": "φισεκλίκι",
    "φυσιοθεραπεία": "φυσικοθεραπεία",
    "φυστίκι": "φιστίκι",
    "φυστικιά": "φιστικιά",
    "φύω": "φύοµαι",
    "φχαριστώ": "ευχαριστώ",
    "φωβισµός": "φοβισµός",
    "φωβιστής": "φοβισµός",
    "Φώτης": "Φώτιος",
    "φωτογραφώ": "φωτογραφίζω",
    "φωτοβολή": ", φωτοβολία",
    "χάβω": "χάφτω",
    "χαΐδεµα": "χαϊδεύω",
    "χάιδι": "χάδι",
    "χαλνώ": "χαλώ",
    "χαλυβώνω": "χαλυβδώνω",
    "χάµου": "χάµω",
    "χαµψίνι": "χαµσίνι",
    "χάνδρα": "χάντρα",
    "χαντζής": "χανιτζής",
    "χαραµατιά": "χαραγµατιά",
    "χάραξ": "χάρακας",
    "χάροντας": "χάρος",
    "χατζάρα": "χαντζάρα",
    "χατζάρι": "χαντζάρι",
    "χεγκελιανισµός": "εγελιανισµός",
    "χειρόβολο": "χερόβολο",
    "χειροµάχηµα": "χεροµαχώ",
    "χειροµάχισσα": "χεροµάχος",
    "χειροµάχος": "χεροµάχος",
    "χειροµαχώ": "χεροµαχώ",
    "χέρα": "χέρι",
    "χερόµυλος": "χειρόµυλος",
    "χεροπόδαρα": "χειροπόδαρα",
    "χηνάρι": "χήνα",
    "χι": "χει",
    "χιµώ": "χυµώ",
    "χιών": "χιόνι",
    "χλεµπάνια": "πλεµπάγια",
    "χλοΐζω": "χλοάζω",
    "χλόισµα": "χλόασµα",
    "χνώτο": "χνότο",
    "χορδίζω": "κουρδίζω",
    "χόρδισµα": "κούρδισμα",
    "χοχλάζω": "κοχλάζω",
    "χοχλακιάζω": "κοχλάζω",
    "χοχλακίζω": "κοχλάζω",
    "χοχλακώ": "κοχλάζω",
    "χρεογραφο": "χρεώγραφο",
    "χρεοκοπία": "χρεωκοπία",
    "χρεοκοπώ": "χρεωκοπώ",
    "χρεολυσία": "χρεωλυσία",
    "χρεολύσιο": "χρεωλύσιο",
    "χρεόλυτρο": "χρεώλυτρο",
    "χρεοπιστώνω": "πιστοχρεώνω",
    "χρεοπίστωση": "πιστοχρεώνω",
    "χρεοστάσιο": "χρεωστάσιο",
    "χρεοφειλέτης": "χρεωφειλέτης",
    "Χρήστος": "Χρίστος",
    "χρωµατόσωµα": "χρωµόσωµα",
    "χρωµογόνος": "χρωµατογόνος",
    "χρωµογόνο": "χρωµατογόνο",
    "χρωµοφόρος": "χρωµατοφόρος",
    "χρωµοφόρο": "χρωµατοφόρο",
    "χτες": "χθες",
    "χτήµα": "κτήµα",
    "χτίζω": "κτίζω",
    "χτίσιµο": "κτίσιµο",
    "χτίσµα": "κτίσµα",
    "χτίστης": "κτίστης",
    "χτύπηµα": "κτύπηµα",
    "χτύπος": "κτύπος",
    "χτυπώ": "κτυπώ",
    "χυµίζω": "χυµώ",
    "χωλ": "χολ",
    "χώνεψη": "χώνευση",
    "χωριατοσύνη": "χωριατιά",
    "ψένω": "ψήνω",
    "ψηλαφώ": "ψηλαφίζω",
    "ψηφιδοθέτης": "ψηφοθέτης",
    "ψιττακίαση": "ψιττάκωση",
    "ψίχαλο": "ψίχουλο",
    "ψυχεδελισµός": "ψυχεδέλεια",
    "ψυχογιός": "ψυχογυιός",
    "ψώριασµα": "ψωριάζω",
    "ωγκρατέν": "ογκρατέν",
    "ωράριο": "οράριο",
    "ώς": "έως",
    "ωτασπίδα": "ωτοασπίδα",
    "ωτοστόπ": "οτοστόπ",
    "ωφελιµοκρατία": "ωφελιµισµός",
    "ωχαδερφισµός": "οχαδερφισµός",
    "ώχου": "όχου",
    "άγυρτος": "άγειρτος",
    "άγυρτη": "άγειρτη",
    "άγυρτο": "άγειρτο",
    "ανηµέρευτος": "ανηµέρωτος",
    "ανηµέρευτη": "ανηµέρωτη",
    "ανηµέρευτο": "ανηµέρωτο",
    "ανοικτός": "ανοιχτός",
    "ανοικτή": "ανοιχτή",
    "ανοικτό": "ανοιχτό",
    "αντιελληνικός": "ανθελληνικός",
    "αντιελληνική": "ανθελληνική",
    "αντιελληνικό": "ανθελληνικό",
    "αντιεπιστηµονικος": "αντεπιστηµονικός",
    "αντιεπιστηµονικη": "αντεπιστηµονική",
    "αντιεπιστηµονικο": "αντεπιστηµονικό",
    "αξόφλητος": "ανεξόφλητος",
    "αξόφλητη": "ανεξόφλητη",
    "αξόφλητο": "ανεξόφλητο",
    "άπαιχτος": "άπαικτος",
    "άπαιχτη": "άπαικτη",
    "άπαιχτο": "άπαικτο",
    "απηρχαιωµένος": "απαρχαιωµένος",
    "απηρχαιωµένη": "απαρχαιωµένη",
    "απηρχαιωµένο": "απαρχαιωµένο",
    "άπιωτος": "άπιοτος",
    "άπιωτη": "άπιοτη",
    "άπιωτο": "άπιοτο",
    "άπραχτος": "άπρακτος",
    "άπραχτη": "άπρακτη",
    "άπραχτο": "άπρακτο",
    "άραχλος": "άραχνος",
    "άραχλη": "άραχνη",
    "άραχλο": "άραχνο",
    "αρήγωτος": "αρίγωτος",
    "αρήγωτη": "αρίγωτη",
    "αρήγωτο": "αρίγωτο",
    "αρµενικός": "αρµενιακός",
    "αρµενική": "αρµενιακή",
    "αρµενικό": "αρµενιακό",
    "αρµυρός": "αλµυρός",
    "αρµυρή": "αλµυρή",
    "αρµυρό": "αλµυρό",
    "άσβεστος": "άσβηστος",
    "άσβεστη": "άσβηστη",
    "άσβεστο": "άσβηστο",
    "άσκηµος": "άσχηµος",
    "άσκηµη": "άσχηµη",
    "άσκηµο": "άσχηµο",
    "άστυφτος": "άστειφτος",
    "άστυφτη": "άστειφτη",
    "άστυφτο": "άστειφτο",
    "ασυχώρετος": "ασυγχώρητος",
    "ασυχώρετη": "ασυγχώρητη",
    "ασυχώρετο": "ασυγχώρητο",
    "άταχτος": "άτακτος",
    "άταχτη": "άτακτη",
    "άταχτο": "άτακτο",
    "άφκιαστος": "άφτειαχτος",
    "άφκιαστη": "άφτειαχτη",
    "άφκιαστο": "άφτειαχτο",
    "άφκειαστος": "άφτειαχτος",
    "άφκειαστη": "άφτειαχτη",
    "άφκειαστο": "άφτειαχτο",
    "άφταστος": "άφθαστος",
    "άφταστη": "άφθαστη",
    "άφταστο": "άφθαστο",
    "άφτερος": "άπτερος",
    "άφτερη": "άπτερη",
    "άφτερο": "άπτερο",
    "αχτιδωτος": "ακτινωτός",
    "αχτιδωτη": "ακτινωτή",
    "αχτιδωτο": "ακτινωτό",
    "άχτιστος": "άκτιστος",
    "άχτιστη": "άκτιστη",
    "άχτιστο": "άκτιστο",
    "βιωτικός": "βιοτικός",
    "βιωτική": "βιοτική",
    "βιωτικό": "βιοτικό",
    "βλάστηµος": "βλάσφηµος",
    "βλάστηµη": "βλάσφηµη",
    "βλάστηµο": "βλάσφηµο",
    "βλογηµένος": "ευλογηµένος",
    "βλογηµένη": "ευλογηµένη",
    "βλογηµένο": "ευλογηµένο",
    "βοϊδινός": "βοδινός",
    "βοϊδινή": "βοδινή",
    "βοϊδινό": "βοδινό",
    "βορινός": "βορεινός",
    "βορινή": "βορεινή",
    "βορινό": "βορεινό",
    "βρωµερός": "βροµερός",
    "βρωµερή": "βροµερή",
    "βρωµερό": "βροµερό",
    "βρώµικος": "βρόµικος",
    "βρώµικη": "βρόµικη",
    "βρώµικο": "βρόµικο",
    "γαλατερός": "γαλακτερός",
    "γαλατερή": "γαλακτερή",
    "γαλατερό": "γαλακτερό",
    "γδυµνός": "γυµνός",
    "γδυµνή": "γυµνή",
    "γδυµνό": "γυµνό",
    "γελαδινός": "αγελαδινός",
    "γελαδινή": "αγελαδινή",
    "γελαδινό": "αγελαδινό",
    "γερτός": "γειρτός",
    "γερτή": "γειρτή",
    "γερτό": "γειρτό",
    "γιοµάτος": "γεµάτος",
    "γιοµάτη": "γεµάτη",
    "γιοµάτο": "γεµάτο",
    "γκεµπελικός": "γκαιµπελικός",
    "γκεµπελική": "γκαιµπελική",
    "γκεµπελικό": "γκαιµπελικό",
    "γλήγορος": "γρήγορος",
    "γλήγορη": "γρήγορη",
    "γλήγορο": "γρήγορο",
    "γρανίτινος": "γρανιτένιος",
    "γρανίτινη": "γρανιτένιη",
    "γρανίτινο": "γρανιτένιο",
    "γραφτός": "γραπτός",
    "γραφτή": "γραπτή",
    "γραφτό": "γραπτό",
    "γυρτός": "γειρτός",
    "γυρτή": "γειρτή",
    "γυρτό": "γειρτό",
    "δαιµονόπληκτος": "δαιµονιόπληκτος",
    "δαιµονόπληκτη": "δαιµονιόπληκτη",
    "δαιµονόπληκτο": "δαιµονιόπληκτο",
    "δερµικός": "δερµατικός",
    "δερµική": "δερµατική",
    "δερµικό": "δερµατικό",
    "δεχτός": "δεκτός",
    "δεχτή": "δεκτή",
    "δεχτό": "δεκτό",
    "διαλεκτός": "διαλεχτός",
    "διαλεκτή": "διαλεχτή",
    "διαλεκτό": "διαλεχτό",
    "διαολεµένος": "διαβολεµένος",
    "διαολεµένη": "διαβολεµένη",
    "διαολεµένο": "διαβολεµένο",
    "δυσέλεγκτος": "δυσεξέλεγκτος",
    "δυσέλεγκτη": "δυσεξέλεγκτη",
    "δυσέλεγκτο": "δυσεξέλεγκτο",
    "δυσλεκτικός": "δυσλεξικός",
    "δυσλεκτική": "δυσλεξική",
    "δυσλεκτικό": "δυσλεξικό",
    "εκδοµένος": "εκδεδοµένος",
    "εκδοµένη": "εκδεδοµένη",
    "εκδοµένο": "εκδεδοµένο",
    "ελεύτερος": "ελεύθερος",
    "ελεύτερη": "ελεύθερη",
    "ελεύτερο": "ελεύθερο",
    "εξώφθαλµος": "εξόφθαλµος",
    "εξώφθαλµη": "εξόφθαλµη",
    "εξώφθαλµο": "εξόφθαλµο",
    "επανωτός": "απανωτός",
    "επανωτή": "απανωτή",
    "επανωτό": "απανωτό",
    "επεξηγητικος": "επεξηγηµατικός",
    "επεξηγητικη": "επεξηγηµατική",
    "επεξηγητικο": "επεξηγηµατικό",
    "έρµος": "έρηµος",
    "έρµη": "έρηµη",
    "έρµο": "έρηµο",
    "ετερόκλητος": "ετερόκλιτος",
    "ετερόκλητη": "ετερόκλιτη",
    "ετερόκλητο": "ετερόκλιτο",
    "ετούτος": "τούτος",
    "ετούτη": "τούτη",
    "ετούτο": "τούτο",
    "εφετεινός": "εφετινός",
    "εφετεινή": "εφετινή",
    "εφετεινό": "εφετινό",
    "εφταήµερος": "επταήµερος",
    "εφταήµερη": "επταήµερη",
    "εφταήµερο": "επταήµερο",
    "ζάµπλουτος": "ζάπλουτος",
    "ζάµπλουτη": "ζάπλουτη",
    "ζάµπλουτο": "ζάπλουτο",
    "ζαχαράτος": "ζαχαρωτός",
    "ζαχαράτη": "ζαχαρωτή",
    "ζαχαράτο": "ζαχαρωτό",
    "θαµβός": "θαµπός",
    "θαµβή": "θαµπή",
    "θαµβό": "θαµπό",
    "θραψερός": "θρεψερός",
    "θραψερή": "θρεψερή",
    "θραψερό": "θρεψερό",
    "ιονικός": "ιοντικός",
    "ιονική": "ιοντική",
    "ιονικό": "ιοντικό",
    "καββαλιστικός": "καβαλιστικός",
    "καββαλιστική": "καβαλιστική",
    "καββαλιστικό": "καβαλιστικό",
    "καλλίτερος": "καλύτερος",
    "καλλίτερη": "καλύτερη",
    "καλλίτερο": "καλύτερο",
    "καταχτητικός": "κατακτητικός",
    "καταχτητική": "κατακτητική",
    "καταχτητικό": "κατακτητικό",
    "καταψυγµένος": "κατεψυγµένος",
    "καταψυγµένη": "κατεψυγµένη",
    "καταψυγµένο": "κατεψυγµένο",
    "καυδιανός": "καβδιανός",
    "καυδιανή": "καβδιανή",
    "καυδιανό": "καβδιανό",
    "καϋµένος": "καηµένος",
    "καϋµένη": "καηµένη",
    "καϋµένο": "καηµένο",
    "κέδρινος": "κέδρος",
    "κέδρινη": "κέδρη",
    "κέδρινο": "κέδρο",
    "κεραµεικος": "κεραµικός",
    "κεραµεικη": "κεραµική",
    "κεραµεικο": "κεραµικό",
    "κλασσικός": "κλασικός",
    "κλασσική": "κλασική",
    "κλασσικό": "κλασικό",
    "κόλαριστός": "κολλαριστός",
    "κόλαριστή": "κολλαριστή",
    "κόλαριστό": "κολλαριστό",
    "κοµµουνιστικός": "κοµουνιστικός",
    "κοµµουνιστική": "κοµουνιστική",
    "κοµµουνιστικό": "κοµουνιστικό",
    "κοράλλινος": "κοραλλένιος",
    "κοράλλινη": "κοραλλένιη",
    "κοράλλινο": "κοραλλένιο",
    "κτυπητός": "χτυπητός",
    "κτυπητή": "χτυπητή",
    "κτυπητό": "χτυπητό",
    "κωφός": "κουφός",
    "κωφή": "κουφή",
    "κωφό": "κουφό",
    "λειπανάβατος": "λειψανάβατος",
    "λειπανάβατη": "λειψανάβατη",
    "λειπανάβατο": "λειψανάβατο",
    "λιανικός": "λειανικός",
    "λιανική": "λειανική",
    "λιανικό": "λειανικό",
    "λιανός": "λειανός",
    "λιανή": "λειανή",
    "λιανό": "λειανό",
    "λιγοήµερος": "ολιγοήµερος",
    "λιγοήµερη": "ολιγοήµερη",
    "λιγοήµερο": "ολιγοήµερο",
    "λιγόκαρδος": "ολιγόκαρδος",
    "λιγόκαρδη": "ολιγόκαρδη",
    "λιγόκαρδο": "ολιγόκαρδο",
    "λιγόλογος": "ολιγόλογος",
    "λιγόλογη": "ολιγόλογη",
    "λιγόλογο": "ολιγόλογο",
    "λιγόπιστος": "ολιγόπιστος",
    "λιγόπιστη": "ολιγόπιστη",
    "λιγόπιστο": "ολιγόπιστο",
    "λιγόψυχος": "ολιγοψυχία",
    "λιγόψυχοςή": "ολιγοψυχίαη",
    "λιγόψυχοςό": "ολιγοψυχίαο",
    "λιόλουστος": "ηλιόλουστος",
    "λιόλουστη": "ηλιόλουστη",
    "λιόλουστο": "ηλιόλουστο",
    "λιόµορφος": "ηλιόµορφος",
    "λιόµορφη": "ηλιόµορφη",
    "λιόµορφο": "ηλιόµορφο",
    "λιόχαρος": "ηλιόχαρος",
    "λιόχαρη": "ηλιόχαρη",
    "λιόχαρο": "ηλιόχαρο",
    "λιπανάβατος": "λειψανάβατος",
    "λιπανάβατη": "λειψανάβατη",
    "λιπανάβατο": "λειψανάβατο",
    "λυµφατικός": "λεµφατικός",
    "λυµφατική": "λεµφατική",
    "λυµφατικό": "λεµφατικό",
    "µαυριδερός": "µαυρειδερός",
    "µαυριδερή": "µαυρειδερή",
    "µαυριδερό": "µαυρειδερό",
    "µεικτός": "µικτός",
    "µεικτή": "µικτή",
    "µεικτό": "µικτό",
    "µελαψός": "µελαµψός",
    "µελαψή": "µελαµψή",
    "µελαψό": "µελαµψό",
    "µετάξινος": "µεταξένιος",
    "µετάξινη": "µεταξένιη",
    "µετάξινο": "µεταξένιο",
    "µιξοβάρβαρος": "µειξοβάρβαρος",
    "µιξοβάρβαρη": "µειξοβάρβαρη",
    "µιξοβάρβαρο": "µειξοβάρβαρο",
    "µοσκαναθρεµµένος": "µοσχαναθρεµµένος",
    "µοσκαναθρεµµένη": "µοσχαναθρεµµένη",
    "µοσκαναθρεµµένο": "µοσχαναθρεµµένο",
    "µουλωχτός": "µουλλωχτός",
    "µουλωχτή": "µουλλωχτή",
    "µουλωχτό": "µουλλωχτό",
    "µπαµπακερός": "βαµβακερός",
    "µπαµπακερή": "βαµβακερή",
    "µπαµπακερό": "βαµβακερό",
    "νεόχτιστος": "νεόκτιστος",
    "νεόχτιστη": "νεόκτιστη",
    "νεόχτιστο": "νεόκτιστο",
    "νηστίσιµος": "νηστήσιµος",
    "νηστίσιµη": "νηστήσιµη",
    "νηστίσιµο": "νηστήσιµο",
    "νιογέννητος": "νεογέννητος",
    "νιογέννητη": "νεογέννητη",
    "νιογέννητο": "νεογέννητο",
    "νυκτερινός": "νυχτερινός",
    "νυκτερινή": "νυχτερινή",
    "νυκτερινό": "νυχτερινό",
    "ξιπόλητος": "ξυπόλυτος",
    "ξιπόλητη": "ξυπόλυτη",
    "ξιπόλητο": "ξυπόλυτο",
    "ξυνός": "ξινός",
    "ξυνή": "ξινή",
    "ξυνό": "ξινό",
    "ξωτικός": "εξωτικός",
    "ξωτική": "εξωτική",
    "ξωτικό": "εξωτικό",
    "οικονοµίστικος": "οικονοµικίστικος",
    "οικονοµίστικη": "οικονοµικίστικη",
    "οικονοµίστικο": "οικονοµικίστικο",
    "οκταγωνικός": "οχταγωνικός",
    "οκταγωνική": "οχταγωνική",
    "οκταγωνικό": "οχταγωνικό",
    "οκτάγωνος": "οχτάγωνος",
    "οκτάγωνη": "οχτάγωνη",
    "οκτάγωνο": "οχτάγωνο",
    "οκτάεδρος": "οχτάεδρος",
    "οκτάεδρη": "οχτάεδρη",
    "οκτάεδρο": "οχτάεδρο",
    "οκτάκιλος": "οχτάκιλος",
    "οκτάκιλη": "οχτάκιλη",
    "οκτάκιλο": "οχτάκιλο",
    "οξειδώσιµος": "οξιδώσιµος",
    "οξειδώσιµη": "οξιδώσιµη",
    "οξειδώσιµο": "οξιδώσιµο",
    "ορεχτικός": "ορεκτικός",
    "ορεχτική": "ορεκτική",
    "ορεχτικό": "ορεκτικό",
    "οχταγωνικός": "οκταγωνικός",
    "οχταγωνική": "οκταγωνική",
    "οχταγωνικό": "οκταγωνικό",
    "οχτάγωνος": "οκτάγωνος",
    "οχτάγωνη": "οκτάγωνη",
    "οχτάγωνο": "οκτάγωνο",
    "οχτάεδρος": "οκτάεδρος",
    "οχτάεδρη": "οκτάεδρη",
    "οχτάεδρο": "οκτάεδρο",
    "οχτακοσιοστός": "οκτακοσιοστός",
    "οχτακοσιοστή": "οκτακοσιοστή",
    "οχτακοσιοστό": "οκτακοσιοστό",
    "οχτάπλευρος": "οκτάπλευρος",
    "οχτάπλευρη": "οκτάπλευρη",
    "οχτάπλευρο": "οκτάπλευρο",
    "οχτάστηλος": "οκτάστηλος",
    "οχτάστηλη": "οκτάστηλη",
    "οχτάστηλο": "οκτάστηλο",
    "οχτάστιχος": "οκτάστιχος",
    "οχτάστιχη": "οκτάστιχη",
    "οχτάστιχο": "οκτάστιχο",
    "οχτάωρος": "οκτάωρος",
    "οχτάωρη": "οκτάωρη",
    "οχτάωρο": "οκτάωρο",
    "οχτωβριανός": "οκτωβριανός",
    "οχτωβριανή": "οκτωβριανή",
    "οχτωβριανό": "οκτωβριανό",
    "παιδιακίστικος": "παιδιάστικος",
    "παιδιακίστικη": "παιδιάστικη",
    "παιδιακίστικο": "παιδιάστικο",
    "πανέρµος": "πανέρηµος",
    "πανέρµη": "πανέρηµη",
    "πανέρµο": "πανέρηµο",
    "παπαδικός": "παππαδικός",
    "παπαδική": "παππαδική",
    "παπαδικό": "παππαδικό",
    "παπαδίστικος": "παππαδίστικος",
    "παπαδίστικη": "παππαδίστικη",
    "παπαδίστικο": "παππαδίστικο",
    "παραεκκλησιαστικός": "παρεκκλησιαστικός",
    "παραεκκλησιαστική": "παρεκκλησιαστική",
    "παραεκκλησιαστικό": "παρεκκλησιαστικό",
    "πειρακτικός": "πειραχτικός",
    "πειρακτική": "πειραχτική",
    "πειρακτικό": "πειραχτικό",
    "περήφανος": "υπερήφανος",
    "περήφανη": "υπερήφανη",
    "περήφανο": "υπερήφανο",
    "περσότερος": "περισσότερος",
    "περσότερη": "περισσότερη",
    "περσότερο": "περισσότερο",
    "πεταγµένος": "πεταµένος",
    "πεταγµένη": "πεταµένη",
    "πεταγµένο": "πεταµένο",
    "πηκτός": "πηχτός",
    "πηκτή": "πηχτή",
    "πηκτό": "πηχτό",
    "πιτσιλιστός": "πιτσυλιστός",
    "πιτσιλιστή": "πιτσυλιστή",
    "πιτσιλιστό": "πιτσυλιστό",
    "πλεχτικός": "πλεκτικός",
    "πλεχτική": "πλεκτική",
    "πλεχτικό": "πλεκτικό",
    "πλεχτός": "πλεκτός",
    "πλεχτή": "πλεκτή",
    "πλεχτό": "πλεκτό",
    "προσεχτικός": "προσεκτικός",
    "προσεχτική": "προσεκτική",
    "προσεχτικό": "προσεκτικό",
    "προψεσινός": "προχθεσινός",
    "προψεσινή": "προχθεσινή",
    "προψεσινό": "προχθεσινό",
    "πτερωτός": "φτερωτός",
    "πτερωτή": "φτερωτή",
    "πτερωτό": "φτερωτό",
    "πτωχικός": "φτωχικός",
    "πτωχική": "φτωχική",
    "πτωχικό": "φτωχικό",
    "ραφτικός": "ραπτικός",
    "ραφτική": "ραπτική",
    "ραφτικό": "ραπτικό",
    "ραφτός": "ραπτός",
    "ραφτή": "ραπτή",
    "ραφτό": "ραπτό",
    "ρούσικος": "ρωσικός",
    "ρούσικη": "ρωσική",
    "ρούσικο": "ρωσικό",
    "ρωµαντικός": "ροµαντικός",
    "ρωµαντική": "ροµαντική",
    "ρωµαντικό": "ροµαντικό",
    "σειληνικός": "σιληνικός",
    "σειληνική": "σιληνική",
    "σειληνικό": "σιληνικό",
    "σειριακός": "σειραϊκός",
    "σειριακή": "σειραϊκή",
    "σειριακό": "σειραϊκό",
    "σεξπιρικός": "σαιξπηρικός",
    "σεξπιρική": "σαιξπηρική",
    "σεξπιρικό": "σαιξπηρικό",
    "σιδηρόφρακτος": "σιδερόφραχτος",
    "σιδηρόφρακτη": "σιδερόφραχτη",
    "σιδηρόφρακτο": "σιδερόφραχτο",
    "σκεβρός": "σκευρός",
    "σκεβρή": "σκευρή",
    "σκεβρό": "σκευρό",
    "σκεφτικός": "σκεπτικός",
    "σκεφτική": "σκεπτική",
    "σκεφτικό": "σκεπτικό",
    "σκιστός": "σχιστός",
    "σκιστή": "σχιστή",
    "σκιστό": "σχιστό",
    "σκολιανός": "σχολιανός",
    "σκολιανή": "σχολιανή",
    "σκολιανό": "σχολιανό",
    "σκοτσέζικος": "σκοτσέζικος",
    "σκοτσέζικη": "σκοτσέζικη",
    "σκοτσέζικο": "σκοτσέζικο",
    "σµυρνιώτικος": "σµυρναίικος",
    "σµυρνιώτικη": "σµυρναίικη",
    "σµυρνιώτικο": "σµυρναίικο",
    "σοροπιαστός": "σιροπιαστός",
    "σοροπιαστή": "σιροπιαστή",
    "σοροπιαστό": "σιροπιαστό",
    "σπερνός": "εσπερινός",
    "σπερνή": "εσπερινή",
    "σπερνό": "εσπερινό",
    "σταρόχρωµος": "σιταρόχρωµος",
    "σταρόχρωµη": "σιταρόχρωµη",
    "σταρόχρωµο": "σιταρόχρωµο",
    "στενάχωρος": "στενόχωρος",
    "στενάχωρη": "στενόχωρη",
    "στενάχωρο": "στενόχωρο",
    "στιλιστικός": "στυλιστικός",
    "στιλιστική": "στυλιστική",
    "στιλιστικό": "στυλιστικό",
    "στριµόκωλος": "στρυµόκωλος",
    "στριµόκωλη": "στρυµόκωλη",
    "στριµόκωλο": "στρυµόκωλο",
    "στριµωχτός": "στρυµωχτός",
    "στριµωχτή": "στρυµωχτή",
    "στριµωχτό": "στρυµωχτό",
    "στριφνός": "στρυφνός",
    "στριφνή": "στρυφνή",
    "στριφνό": "στρυφνό",
    "σύµµεικτος": "σύµµικτος",
    "σύµµεικτη": "σύµµικτη",
    "σύµµεικτο": "σύµµικτο",
    "σύµψυχος": "σύψυχος",
    "σύµψυχη": "σύψυχη",
    "σύµψυχο": "σύψυχο",
    "συντεθειµένος": "συνθέτω",
    "συντεθειµένοςή": "συνθέτωη",
    "συντεθειµένοςό": "συνθέτωο",
    "συφοριασµένος": "συμφοριασμένος",
    "συφοριασµένη": "συμφοριασμένη",
    "συφοριασµένο": "συμφοριασμένο",
    "συχωριανός": "συγχωριανός",
    "συχωριανή": "συγχωριανή",
    "συχωριανό": "συγχωριανό",
    "ταγκός": "ταγγός",
    "ταγκή": "ταγγή",
    "ταµιευτικός": "αποταµιευτικός",
    "ταµιευτική": "αποταµιευτική",
    "ταµιευτικό": "αποταµιευτικό",
    "ταχτικός": "τακτικός",
    "ταχτική": "τακτική",
    "ταχτικό": "τακτικό",
    "τελολογικός": "τελεολογικός",
    "τελολογική": "τελεολογική",
    "τελολογικό": "τελεολογικό",
    "τραγικοκωµικός": "κωµικοτραγικός",
    "τραγικοκωµική": "κωµικοτραγική",
    "τραγικοκωµικό": "κωµικοτραγικό",
    "τρελλός": "τρελός",
    "τρελλή": "τρελή",
    "τρελλό": "τρελό",
    "τσεβδός": "τσευδός",
    "τσεβδή": "τσευδή",
    "τσεβδό": "τσευδό",
    "τσιριχτός": "τσυριχτός",
    "τσιριχτή": "τσυριχτή",
    "τσιριχτό": "τσυριχτό",
    "τσιτωτός": "τσητωτός",
    "τσιτωτή": "τσητωτή",
    "τσιτωτό": "τσητωτό",
    "υποµονητικός": "υποµονετικός",
    "υποµονητική": "υποµονετική",
    "υποµονητικό": "υποµονετικό",
    "φαµφαρονικός": "φανφαρονίστικος",
    "φαµφαρονική": "φανφαρονίστικη",
    "φαµφαρονικό": "φανφαρονίστικο",
    "φαµφαρονίστικος": "φανφαρονίστικος",
    "φαµφαρονίστικη": "φανφαρονίστικη",
    "φαµφαρονίστικο": "φανφαρονίστικο",
    "φαντός": "υφαντός",
    "φαντή": "υφαντή",
    "φαντό": "υφαντό",
    "φανφαρονικός": "φανφαρονιστικός",
    "φανφαρονική": "φανφαρονιστική",
    "φανφαρονικό": "φανφαρονιστικό",
    "φαρακλός": "φαλακρός",
    "φαρακλή": "φαλακρή",
    "φαρακλό": "φαλακρό",
    "φεγγαροφώτιστος": "φεγγαρόφωτος",
    "φεγγαροφώτιστη": "φεγγαρόφωτη",
    "φεγγαροφώτιστο": "φεγγαρόφωτο",
    "φεουδαλικός": "φεουδαρχικός",
    "φεουδαλική": "φεουδαρχική",
    "φεουδαλικό": "φεουδαρχικό",
    "φλοκάτος": "φλοκωτός",
    "φλοκάτη": "φλοκωτή",
    "φλοκάτο": "φλοκωτό",
    "φριχτός": "φρικτός",
    "φριχτή": "φρικτή",
    "φριχτό": "φρικτό",
    "φροϋδικός": "φροϊδικός",
    "φροϋδική": "φροϊδική",
    "φροϋδικό": "φροϊδικό",
    "φτειαστός": "φτειαχτός",
    "φτειαστή": "φτειαχτή",
    "φτειαστό": "φτειαχτό",
    "φτηνός": "φθηνός",
    "φτηνή": "φθηνή",
    "φτηνό": "φθηνό",
    "φυσιοθεραπευτικός": "φυσιοθεραπευτικός",
    "φυσιοθεραπευτική": "φυσιοθεραπευτική",
    "φυσιοθεραπευτικό": "φυσιοθεραπευτικό",
    "φωβιστικός": "φοβιστικός",
    "φωβιστική": "φοβιστική",
    "φωβιστικό": "φοβιστικό",
    "χαδεµένος": "χαϊδεµένος",
    "χαδεµένη": "χαϊδεµένη",
    "χαδεµένο": "χαϊδεµένο",
    "χειλόφωνος": "χειλεόφωνος",
    "χειλόφωνη": "χειλεόφωνη",
    "χειλόφωνο": "χειλεόφωνο",
    "χειροδύναµος": "χεροδύναµος",
    "χειροδύναµη": "χεροδύναµη",
    "χειροδύναµο": "χεροδύναµο",
    "χηράµενος": "χηρευάµενος",
    "χηράµενη": "χηρευάµενη",
    "χηράµενο": "χηρευάµενο",
    "χλωµός": "χλοµός",
    "χλωµή": "χλοµή",
    "χλωµό": "χλοµό",
    "χνουδάτος": "χνουδωτός",
    "χνουδάτη": "χνουδωτή",
    "χνουδάτο": "χνουδωτό",
    "χονδρός": "χοντρός",
    "χονδρή": "χοντρή",
    "χονδρό": "χοντρό",
    "χουβαρντάδικος": "χουβαρντάς",
    "χουβαρντάδικοςή": "χουβαρντάςη",
    "χουβαρντάδικοςό": "χουβαρντάςο",
    "χρεολυτικός": "χρεωλυτικός",
    "χρεολυτική": "χρεωλυτική",
    "χρεολυτικό": "χρεωλυτικό",
    "χρησµοδοτικός": "χρησµοδοσία",
    "χρησµοδοτική": "χρησµοδοσίαη",
    "χρησµοδοτικό": "χρησµοδοσίαο",
    "χρυσόπλεχτος": "χρυσόπλεκτος",
    "χρυσόπλεχτη": "χρυσόπλεκτη",
    "χρυσόπλεχτο": "χρυσόπλεκτο",
    "χτεσινός": "χθεσινός",
    "χτεσινή": "χθεσινή",
    "χτεσινό": "χθεσινό",
    "χτιστός": "κτιστός",
    "χτιστή": "κτιστή",
    "χτιστό": "κτιστό",
    "αντρείος": "ανδρείος",
    "αντρεία": "ανδρεία",
    "αντρείο": "ανδρείο",
    "αποποµπαίος": "αποδιοποµπαίος",
    "αποποµπαία": "αποδιοποµπαία",
    "αποποµπαίο": "αποδιοποµπαίο",
    "γεραλεος": "γηραλέος",
    "γεραλεα": "γηραλέα",
    "γεραλεο": "γηραλέο",
    "εντόπιος": "ντόπιος",
    "εντόπια": "ντόπια",
    "εντόπιο": "ντόπιο",
    "εφταπλάσιος": "επταπλάσιος",
    "εφταπλάσια": "επταπλάσια",
    "εφταπλάσιο": "επταπλάσιο",
    "ζούφιος": "τζούφιος",
    "ζούφια": "τζούφια",
    "ζούφιο": "τζούφιο",
    "καθάριος": "καθάρειος",
    "καθάρια": "καθάρεια",
    "καθάριο": "καθάρειο",
    "λαφήσιος": "ελαφήσιος",
    "λαφήσια": "ελαφήσια",
    "λαφήσιο": "ελαφήσιο",
    "οκταθέσιος": "οχταθέσιος",
    "οκταθέσια": "οχταθέσια",
    "οκταθέσιο": "οχταθέσιο",
    "ονυχαίος": "ονυχιαίος",
    "ονυχαία": "ονυχιαία",
    "ονυχαίο": "ονυχιαίο",
    "οχταπλάσιος": "οκταπλάσιος",
    "οχταπλάσια": "οκταπλάσια",
    "οχταπλάσιο": "οκταπλάσιο",
    "βοϊδήσιος": "βοδινός",
    "βοϊδήσια": "βοδινή",
    "βοϊδήσιο": "βοδινό",
    "καλαµποκίσιος": "καλαµποκήσιος",
    "καλαµποκίσια": "καλαµποκήσια",
    "καλαµποκίσιο": "καλαµποκήσιο",
    "κεφαλίσιος": "κεφαλήσιος",
    "κεφαλίσια": "κεφαλήσια",
    "κεφαλίσιο": "κεφαλήσιο",
    "κρουσταλλένιος": "κρυσταλλένιος",
    "κρουσταλλένια": "κρυσταλλένια",
    "κρουσταλλένιο": "κρυσταλλένιο",
    "µοσκαρήσιος": "µοσχαρήσιος",
    "µοσκαρήσια": "µοσχαρήσια",
    "µοσκαρήσιο": "µοσχαρήσιο",
    "παλικαρήσιος": "παλληκαρήσιος",
    "παλικαρήσια": "παλληκαρήσια",
    "παλικαρήσιο": "παλληκαρήσιο",
    "πετρένιος": "πέτρινος",
    "πετρένια": "πέτρινη",
    "πετρένιο": "πέτρινο",
    "σιταρένιος": "σταρένιος",
    "σιταρένια": "σταρένια",
    "σιταρένιο": "σταρένιο",
    "σκυλίσιος": "σκυλήσιος",
    "σκυλίσια": "σκυλήσια",
    "σκυλίσιο": "σκυλήσιο",
    "χελίσιος": "χελήσιος",
    "χελίσια": "χελήσια",
    "χελίσιο": "χελήσιο",
    "χελωνίσιος": "χελωνήσιος",
    "χελωνίσια": "χελωνήσια",
    "χελωνίσιο": "χελωνήσιο",
    "γουρσούζης": "γρουσούζης",
    "γουρσούζα": "γρουσούζα",
    "γουρσούζικο": "γρουσούζικο",
    "γρινιάρης": "γκρινιάρης",
    "γρινιάρα": "γκρινιάρα",
    "γρινιάρικο": "γκρινιάρικο",
    "λιχούδης": "λειχούδης",
    "λιχούδα": "λειχούδα",
    "λιχούδικο": "λειχούδικο",
    "µαργιόλής": "µαριόλης",
    "µαργιόλήςα": "µαριόλα",
    "µαργιόλήςικο": "µαριόλικο",
    "ξεκουτιάρης": "ξεκούτης",
    "ξεκουτιάρα": "ξεκούτα",
    "ξεκουτιάρικο": "ξεκούτικο",
    "σκανδαλιάρης": "σκανταλιάρης",
    "σκανδαλιάρα": "σκανταλιάρα",
    "σκανδαλιάρικο": "σκανταλιάρικο",
    "τσιγκούνης": "τσιγγούνης",
    "τσιγκούνα": "τσιγγούνα",
    "τσιγκούνικο": "τσιγγούνικο",
}

NORM_EXCEPTIONS = {}

for string, norm in _exc.items():
    NORM_EXCEPTIONS[string] = norm
