# coding: utf8
from __future__ import unicode_literals


ADJECTIVE_RULES = [
    ["οί", "ός"],  # καρδιακοί -> καρδιακός. Ονομαστική πλ. σε -ός. (m)
    ["ών", "ός"],  # καρδιακών -> καρδιακός. Γενική πλ. σε -ός. (m)
    ["ού", "ός"],  # καρδιακού -> καρδιακός. Γενική εν. σε -ός. (m)
    ["ή", "ός"],  # καρδιακή -> καρδιακός. Ονομαστική εν. σε -ή. (f)
    ["ής", "ός"],  # καρδιακής -> καρδιακός. Γενική εν. σε -ή. (f)
    ["ές", "ός"],  # καρδιακές -> καρδιακός. Ονομαστική πλ. σε -ή. (f)
    ["οι", "ος"],  # ωραίοι -> ωραίος. Ονομαστική πλ. σε -ος. (m)
    ["ων", "ος"],  # ωραίων -> ωραίος. Γενική πλ. σε -ος. (m)
    ["ου", "ος"],  # ωραίου -> ωραίος. Γενική εν. σε -ος. (m)
    ["ο", "ος"],  # ωραίο -> ωραίος. Ονομαστική εν. σε -ο. (n)
    ["α", "ος"],  # χυδαία -> χυδαίος. Ονομαστική πλ. σε -ο. (n)
    ["ώδη", "ώδες"],  # δασώδη -> δασώδες. Ονομαστική πλ. σε -ώδες. (n)
    ["ύτερη", "ός"],  # καλύτερη -> καλός. Συγκριτικός βαθμός σε -ή. (f)
    ["ύτερης", "ός"],  # καλύτερης -> καλός. (f)
    ["ύτερων", "ός"],  # καλύτερων -> καλός. (f)
    ["ύτερος", "ός"],  # καλύτερος -> καλός. Συγκριτικός βαθμός σε -ός. (m)
    ["ύτερου", "ός"],  # καλύτερου -> καλός. (m)
]

# masculine -> m, feminine -> f, neuter -> n.
NOUN_RULES = [
    ["ιού", "ί"],  # παιδιού -> παιδί. Γενική ενικού σε -ί. (n)
    ["ιά", "ί"],  # παιδιά -> παιδί. Ονομαστική πληθυντικού σε -ί. (n)
    ["ιών", "ί"],  # παιδιών -> παιδί. Γενική πληθυντικού σε -ί. (n)
    ["ηριού", "ήρι"],  # ποτηριού -> ποτήρι. Γενική ενικού σε -ι. (n)
    ["ια", "ι"],  # ποτήρια -> ποτήρι. Ονομαστική πληθυντικού σε -ι. (n)
    ["ηριών", "ήρι"],  # ποτηριών -> ποτήρι. Γενική πληθυντικού σε -ι. (n)
    ["ας", "α"],  # κεραμίδας -> κεραμίδα. Γενική ενικού σε -α. (f)
    ["ες", "α"],  # κεραμίδες -> κεραμίδα. Ονομαστική πληθυντικού σε -α. (f)
    ["ων", "α"],  # κεραμίδων -> κεραμίδα. Γενική πληθυντικού σε -α. (f)
    ["άς", "ά"],  # βελανιδιάς -> βελανιδιά. Γενική ενικού σε -ά. (f)
    ["ές", "ά"],  # βελανιδιές -> βελανιδιά. Ονομαστική πληθυντικού σε -ά. (f)
    ["ών", "ά"],  # βελανιδιών -> βελανιδιά. Γενική πληθυντικού σε -ά. (f)
    ["ής", "ή"],  # φυλακής -> φυλακή. Γενική ενικού σε -ή. (f)
    ["ές", "ή"],  # φυλακές -> φυλακή. Ονομαστική πληθυντικού σε -ή. (f)
    ["ών", "ή"],  # φυλακών -> φυλακή. Γενική πληθυντικού σε -ή. (f)
    ["ές", "ής"],  # καθηγητές -> καθηγητής. Ονομαστική πληθυντικού σε -ής. (m)
    ["ών", "ής"],  # καθηγητών -> καθηγητής. Γενική πληθυντικού σε -ής. (m)
    ["ου", "ο"],  # προβάτου -> πρόβατο. Γενική ενικού σε -ο. (n)
    ["α", "ο"],  # πρόβατα -> πρόβατο. Ονομαστική πληθυντικού σε -o. (n)
    ["ων", "ο"],  # προβάτων -> πρόβατο. Γενική πληθυντικού σε -ο. (n)
    ["ητήματος", "ήτημα"],  # ζητήματος -> ζήτημα. Γενική ενικού σε -α (n)
    # ζητήματα -> ζήτημα. Ονομαστική πληθυντικού σε -α. (n)
    ["ητήματα", "ήτημα"],
    # ζητημάτων -> ζήτημα. Γενική πληθυντικού σε -α. (n)
    ["ητημάτων", "ήτημα"],
    ["τος", ""],  # στόματος -> στόμα. Γενική ενικού σε -α. (n)
    ["τα", "α"],  # στόματα -> στόμα. Ονομαστική πληθυντικού σε -α. (n)
    ["ομάτων", "όμα"],  # στομάτων -> στόμα. Γενική πληθυντικού σε -α. (n)
    ["ού", "ός"],  # υπουργού -> υπουργός. Γενική ενικού σε -ος. (m)
    ["οί", "ός"],  # υπουργοί -> υπουργούς. Ονομαστική πληυθυντικού σε -ος. (m)
    ["ών", "ός"],  # υπουργών -> υπουργός. Γενική πληθυντικού σε -ος. (m)
    ["ς", ""],  # δικτατορίας -> δικτατορία. Γενική ενικού σε -ας. (f)
    # δικτατορίες -> δικτατορία. Ονομαστική πληθυντικού σε -ας. (f)
    ["ες", "α"],
    ["ιών", "ία"],  # δικτατοριών -> δικτατορία. Γενική πληθυντικού σε -ας. (f)
    ["α", "ας"],  # βασιλιά -> βασιλιάς. Γενική ενικού σε -άς. (m)
    ["δων", ""],  # βασιλιάδων -> βασιλιά. Γενική πληθυντικού σε -άς. (m)
]


VERB_RULES = [
    ["εις", "ω"],  # πάρεις -> πάρω. Ενεστώτας ρήματος σε -ω.
    ["ει", "ω"],
    ["ουμε", "ω"],
    ["ετε", "ω"],
    ["ουνε", "ω"],
    ["ουν", "ω"],
    ["είς", "ώ"],  # πονείς -> πονώ. Ενεστώτας ρήματος σε -ώ vol1.
    ["εί", "ώ"],  # οι κανόνες που λείπουν καλύπτονται από το αγαπώ.
    ["ούν", "ώ"],
    ["εσαι", "ομαι"],  # αισθάνεσαι -> αισθάνομαι. Ενεστώτας ρήματος σε -ομαι.
    ["εται", "ομαι"],
    ["ανόμαστε", "άνομαι"],
    ["εστε", "ομαι"],
    ["ονται", "ομαι"],
    ["άς", "ώ"],  # αγαπάς -> αγαπάω (ή αγαπώ). Ενεστώτας ρήματος σε -ώ vol2.
    ["άει", "ώ"],
    ["άμε", "ώ"],
    ["άτε", "ώ"],
    ["άνε", "ώ"],
    ["άν", "ώ"],
    ["άω", "ώ"],
    ["ώ", "άω"],
    # ζαλιζόμουν -> ζαλίζομαι. Παρατατικός ρήματος -ίζομαι.
    ["ιζόμουν", "ίζομαι"],
    ["ιζόσουν", "ίζομαι"],
    ["ιζόταν", "ίζομαι"],
    ["ιζόμασταν", "ίζομαι"],
    ["ιζόσασταν", "ίζομαι"],
    ["ονταν", "ομαι"],
    ["όμουν", "άμαι"],  # κοιμόμουν -> κοιμάμαι. Παρατατικός ρήματος σε -άμαι.
    ["όσουν", "άμαι"],
    ["όταν", "άμαι"],
    ["όμασταν", "άμαι"],
    ["όσασταν", "άμαι"],
    ["όντουσταν", "άμαι"],
    ["ούσα", "ώ"],  # ζητούσα -> ζητώ. # Παρατατικός ρήματος σε -ώ.
    ["ούσες", "ώ"],
    ["ούσε", "ώ"],
    ["ούσαμε", "ώ"],
    ["ούσατε", "ώ"],
    ["ούσαν", "ώ"],
    ["ούσανε", "ώ"],
    ["λαμε", "ζω"],  # βγάλαμε -> βγάζω. Αόριστος ρήματος σε -ω vol1.
    ["λατε", "ζω"],
    ["ήρα", "άρω"],  # πήρα -> πάρω. Αόριστος ρήματος σε -ω vol2.
    ["ήρες", "άρω"],
    ["ήρε", "άρω"],
    ["ήραμε", "άρω"],
    ["ήρατε", "άρω"],
    ["ήρα", "άρω"],
    ["ένησα", "ενώ"],  # φιλοξένησα -> φιλοξενώ. Αόριστος ρήματος σε -ώ vol1.
    ["ένησες", "ενώ"],
    ["ένησε", "ενώ"],
    ["ενήσαμε", "ενώ"],
    ["ένησατε", "ενώ"],
    ["ένησαν", "ενώ"],
    ["όνεσα", "ονώ"],  # πόνεσα -> πονώ. Αόριστος ρήματος σε -ώ vol2.
    ["όνεσες", "ονώ"],
    ["όνεσε", "ονώ"],
    ["έσαμε", "ώ"],
    ["έσατε", "ώ"],
    ["ισα", "ομαι"],  # κάθισα -> κάθομαι. Αόριστος ρήματος σε -ομαι.
    ["ισες", "ομαι"],
    ["ισε", "ομαι"],
    ["αθίσαμε", "άθομαι"],
    ["αθίσατε", "άθομαι"],
    ["ισαν", "ομαι"],
    ["άπα", "απώ"],  # αγάπα -> αγαπώ. Προστακτική ρήματος σε -άω/ώ vol1.
    ["ά", "ώ"],  # τιμά -> τιμώ. Προστακτική ρήματος σε άω/ώ vol2.
    ["οντας", "ω"],  # βλέποντας -> βλέπω. Μετοχή.
    ["ξω", "ζω"],  # παίξω -> παίζω. Μέλλοντας σε -ω.
    ["ξεις", "ζω"],
    ["ξουμε", "ζω"],
    ["ξετε", "ζω"],
    ["ξουν", "ζω"],





]


PUNCT_RULES = [
    ["“", "\""],
    ["”", "\""],
    ["\u2018", "'"],
    ["\u2019", "'"]
]
