# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

VERBS_WORDFORMS = {
'abandoner': ('abandonere',),
'abandonere': ('abandonere',),
'abandonerer': ('abandonere',),
'abandoneres': ('abandonere',),
'abandonert': ('abandonere',),
'abandonerte': ('abandonere',),
'abbrevier': ('abbreviere',),
'abbreviere': ('abbreviere',),
'abbrevierer': ('abbreviere',),
'abbrevieres': ('abbreviere',),
'abbreviert': ('abbreviere',),
'abbrevierte': ('abbreviere',),
'abdiser': ('abdisere',),
'abdisere': ('abdisere',),
'abdiserer': ('abdisere',),
'abdiseres': ('abdisere',),
'abdisert': ('abdisere',),
'abdiserte': ('abdisere',),
'abonner': ('abonnere',),
'abonnere': ('abonnere',),
'abonnerer': ('abonnere',),
'abonneres': ('abonnere',),
'abonnert': ('abonnere',),
'abonnerte': ('abonnere',),
'aborter': ('abortere',),
'abortere': ('abortere',),
'aborterer': ('abortere',),
'aborteres': ('abortere',),
'abortert': ('abortere',),
'aborterte': ('abortere',),
'absenter': ('absentere',),
'absentere': ('absentere',),
'absenterer': ('absentere',),
'absenteres': ('absentere',),
'absentert': ('absentere',),
'absenterte': ('absentere',),
'absolver': ('absolvere',),
'absolvere': ('absolvere',),
'absolverer': ('absolvere',),
'absolveres': ('absolvere',),
'absolvert': ('absolvere',),
'absolverte': ('absolvere',),
'absorber': ('absorbere',),
'absorbere': ('absorbere',),
'absorberer': ('absorbere',),
'absorberes': ('absorbere',),
'absorbert': ('absorbere',),
'absorberte': ('absorbere',),
'abstraher': ('abstrahere',),
'abstrahere': ('abstrahere',),
'abstraherer': ('abstrahere',),
'abstraheres': ('abstrahere',),
'abstrahert': ('abstrahere',),
'abstraherte': ('abstrahere',),
'adapter': ('adaptere',),
'adaptere': ('adaptere',),
'adapterer': ('adaptere',),
'adapteres': ('adaptere',),
'adaptert': ('adaptere',),
'adapterte': ('adaptere',),
'adder': ('addere',),
'addere': ('addere',),
'adderer': ('addere',),
'adderes': ('addere',),
'addert': ('addere',),
'adderte': ('addere',),
'adherer': ('adherere',),
'adherere': ('adherere',),
'adhererer': ('adherere',),
'adhereres': ('adherere',),
'adherert': ('adherere',),
'adhererte': ('adherere',),
'adjektiver': ('adjektivere',),
'adjektivere': ('adjektivere',),
'adjektiverer': ('adjektivere',),
'adjektiveres': ('adjektivere',),
'adjektivert': ('adjektivere',),
'adjektiverte': ('adjektivere',),
'adl': ('adle',),
'adla': ('adle',),
'adle': ('adle',),
'adler': ('adle',),
'adles': ('adle',),
'adlet': ('adle',),
'adlyd': ('adlyde',),
'adlyde': ('adlyde',),
'adlyder': ('adlyde',),
'adlydes': ('adlyde',),
'adlydt': ('adlyde',),
'adlød': ('adlyde',),
'administrer': ('administrere',),
'administrere': ('administrere',),
'administrerer': ('administrere',),
'administreres': ('administrere',),
'administrert': ('administrere',),
'administrerte': ('administrere',),
'adopter': ('adoptere',),
'adoptere': ('adoptere',),
'adopterer': ('adoptere',),
'adopteres': ('adoptere',),
'adoptert': ('adoptere',),
'adopterte': ('adoptere',),
'adresser': ('adressere',),
'adressere': ('adressere',),
'adresserer': ('adressere',),
'adresseres': ('adressere',),
'adressert': ('adressere',),
'adresserte': ('adressere',),
'adsorber': ('adsorbere',),
'adsorbere': ('adsorbere',),
'adsorberer': ('adsorbere',),
'adsorberes': ('adsorbere',),
'adsorbert': ('adsorbere',),
'adsorberte': ('adsorbere',),
'adstringer': ('adstringere',),
'adstringere': ('adstringere',),
'adstringerer': ('adstringere',),
'adstringeres': ('adstringere',),
'adstringert': ('adstringere',),
'adstringerte': ('adstringere',),
'advar': ('advare',),
'advare': ('advare',),
'advarer': ('advare',),
'advares': ('advare',),
'advart': ('advare',),
'advarte': ('advare',),
'adviser': ('advisere',),
'advisere': ('advisere',),
'adviserer': ('advisere',),
'adviseres': ('advisere',),
'advisert': ('advisere',),
'adviserte': ('advisere',),
'affekter': ('affektere',),
'affektere': ('affektere',),
'affekterer': ('affektere',),
'affekteres': ('affektere',),
'affektert': ('affektere',),
'affekterte': ('affektere',),
'affiser': ('affisere',),
'affisere': ('affisere',),
'affiserer': ('affisere',),
'affiseres': ('affisere',),
'affisert': ('affisere',),
'affiserte': ('affisere',),
'afrikaniser': ('afrikanisere',),
'afrikanisere': ('afrikanisere',),
'afrikaniserer': ('afrikanisere',),
'afrikaniseres': ('afrikanisere',),
'afrikanisert': ('afrikanisere',),
'afrikaniserte': ('afrikanisere',),
'ag': ('age',),
'aga': ('age',),
'age': ('age',),
'ager': ('age',),
'ages': ('age',),
'aget': ('age',),
'ager': ('agere',),
'agere': ('agere',),
'agerer': ('agere',),
'ageres': ('agere',),
'agert': ('agere',),
'agerte': ('agere',),
'agglutiner': ('agglutinere',),
'agglutinere': ('agglutinere',),
'agglutinerer': ('agglutinere',),
'agglutineres': ('agglutinere',),
'agglutinert': ('agglutinere',),
'agglutinerte': ('agglutinere',),
'agiter': ('agitere',),
'agitere': ('agitere',),
'agiterer': ('agitere',),
'agiteres': ('agitere',),
'agitert': ('agitere',),
'agiterte': ('agitere',),
'agn': ('agne',),
'agna': ('agne',),
'agne': ('agne',),
'agner': ('agne',),
'agnes': ('agne',),
'agnet': ('agne',),
'ajourfør': ('ajourføre',),
'ajourføre': ('ajourføre',),
'ajourfører': ('ajourføre',),
'ajourføres': ('ajourføre',),
'ajourført': ('ajourføre',),
'ajourførte': ('ajourføre',),
'ak': ('ake',),
'ake': ('ake',),
'aker': ('ake',),
'akes': ('ake',),
'akt': ('ake',),
'akte': ('ake',),
'akk': ('akke',),
'akka': ('akke',),
'akke': ('akke',),
'akker': ('akke',),
'akkes': ('akke',),
'akket': ('akke',),
'akk': ('akke',),
'akka': ('akke',),
'akke': ('akke',),
'akker': ('akke',),
'akkes': ('akke',),
'akket': ('akke',),
'akkeder': ('akkedere',),
'akkedere': ('akkedere',),
'akkederer': ('akkedere',),
'akkederes': ('akkedere',),
'akkedert': ('akkedere',),
'akkederte': ('akkedere',),
'akklimatiser': ('akklimatisere',),
'akklimatisere': ('akklimatisere',),
'akklimatiserer': ('akklimatisere',),
'akklimatiseres': ('akklimatisere',),
'akklimatisert': ('akklimatisere',),
'akklimatiserte': ('akklimatisere',),
'akkommoder': ('akkommodere',),
'akkommodere': ('akkommodere',),
'akkommoderer': ('akkommodere',),
'akkommoderes': ('akkommodere',),
'akkommodert': ('akkommodere',),
'akkommoderte': ('akkommodere',),
'akkompagner': ('akkompagnere',),
'akkompagnere': ('akkompagnere',),
'akkompagnerer': ('akkompagnere',),
'akkompagneres': ('akkompagnere',),
'akkompagnert': ('akkompagnere',),
'akkompagnerte': ('akkompagnere',),
'akkorder': ('akkordere',),
'akkordere': ('akkordere',),
'akkorderer': ('akkordere',),
'akkorderes': ('akkordere',),
'akkordert': ('akkordere',),
'akkorderte': ('akkordere',),
'akkrediter': ('akkreditere',),
'akkreditere': ('akkreditere',),
'akkrediterer': ('akkreditere',),
'akkrediteres': ('akkreditere',),
'akkreditert': ('akkreditere',),
'akkrediterte': ('akkreditere',),
'akkumuler': ('akkumulere',),
'akkumulere': ('akkumulere',),
'akkumulerer': ('akkumulere',),
'akkumuleres': ('akkumulere',),
'akkumulert': ('akkumulere',),
'akkumulerte': ('akkumulere',),
'akkvirer': ('akkvirere',),
'akkvirere': ('akkvirere',),
'akkvirerer': ('akkvirere',),
'akkvireres': ('akkvirere',),
'akkvirert': ('akkvirere',),
'akkvirerte': ('akkvirere',),
'akselerer': ('akselerere',),
'akselerere': ('akselerere',),
'akselererer': ('akselerere',),
'akselereres': ('akselerere',),
'akselerert': ('akselerere',),
'akselererte': ('akselerere',),
'aksentuer': ('aksentuere',),
'aksentuere': ('aksentuere',),
'aksentuerer': ('aksentuere',),
'aksentueres': ('aksentuere',),
'aksentuert': ('aksentuere',),
'aksentuerte': ('aksentuere',),
'aksepter': ('akseptere',),
'akseptere': ('akseptere',),
'aksepterer': ('akseptere',),
'aksepteres': ('akseptere',),
'akseptert': ('akseptere',),
'aksepterte': ('akseptere',),
'aksjoner': ('aksjonere',),
'aksjonere': ('aksjonere',),
'aksjonerer': ('aksjonere',),
'aksjoneres': ('aksjonere',),
'aksjonert': ('aksjonere',),
'aksjonerte': ('aksjonere',),
'aksl': ('aksle',),
'aksla': ('aksle',),
'aksle': ('aksle',),
'aksler': ('aksle',),
'aksles': ('aksle',),
'akslet': ('aksle',),
'akt': ('akte',),
'akta': ('akte',),
'akte': ('akte',),
'akter': ('akte',),
'aktes': ('akte',),
'aktet': ('akte',),
'akterutsegl': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutsegle': ('akterutsegle',),
'akterutsegler': ('akterutsegle',),
'akterutsegles': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutseil': ('akterutseile',),
'akterutseile': ('akterutseile',),
'akterutseiler': ('akterutseile',),
'akterutseiles': ('akterutseile',),
'akterutseilt': ('akterutseile',),
'akterutseilte': ('akterutseile',),
'aktiver': ('aktivere',),
'aktivere': ('aktivere',),
'aktiverer': ('aktivere',),
'aktiveres': ('aktivere',),
'aktivert': ('aktivere',),
'aktiverte': ('aktivere',),
'aktiviser': ('aktivisere',),
'aktivisere': ('aktivisere',),
'aktiviserer': ('aktivisere',),
'aktiviseres': ('aktivisere',),
'aktivisert': ('aktivisere',),
'aktiviserte': ('aktivisere',),
'aktualiser': ('aktualisere',),
'aktualisere': ('aktualisere',),
'aktualiserer': ('aktualisere',),
'aktualiseres': ('aktualisere',),
'aktualisert': ('aktualisere',),
'aktualiserte': ('aktualisere',),
'alarmer': ('alarmere',),
'alarmere': ('alarmere',),
'alarmerer': ('alarmere',),
'alarmeres': ('alarmere',),
'alarmert': ('alarmere',),
'alarmerte': ('alarmere',),
'albog': ('alboge',),
'alboga': ('alboge',),
'alboge': ('alboge',),
'alboger': ('alboge',),
'alboges': ('alboge',),
'alboget': ('alboge',),
'albu': ('albue',),
'albua': ('albue',),
'albue': ('albue',),
'albuer': ('albue',),
'albues': ('albue',),
'albuet': ('albue',),
'aldersbestem': ('aldersbestemme',),
'aldersbestemme': ('aldersbestemme',),
'aldersbestemmer': ('aldersbestemme',),
'aldersbestemmes': ('aldersbestemme',),
'aldersbestemt': ('aldersbestemme',),
'aldersbestemte': ('aldersbestemme',),
'aldr': ('aldre',),
'aldra': ('aldre',),
'aldre': ('aldre',),
'aldrer': ('aldre',),
'aldres': ('aldre',),
'aldret': ('aldre',),
'aldredes': ('aldres',),
'aldres': ('aldres',),
'al': ('ale',),
'ala': ('ale',),
'ale': ('ale',),
'aler': ('ale',),
'ales': ('ale',),
'alet': ('ale',),
'alt': ('ale',),
'alte': ('ale',),
'ol': ('ale',),
'alfabetiser': ('alfabetisere',),
'alfabetisere': ('alfabetisere',),
'alfabetiserer': ('alfabetisere',),
'alfabetiseres': ('alfabetisere',),
'alfabetisert': ('alfabetisere',),
'alfabetiserte': ('alfabetisere',),
'aliener': ('alienere',),
'alienere': ('alienere',),
'alienerer': ('alienere',),
'alieneres': ('alienere',),
'alienert': ('alienere',),
'alienerte': ('alienere',),
'alkoholiser': ('alkoholisere',),
'alkoholisere': ('alkoholisere',),
'alkoholiserer': ('alkoholisere',),
'alkoholiseres': ('alkoholisere',),
'alkoholisert': ('alkoholisere',),
'alkoholiserte': ('alkoholisere',),
'allier': ('alliere',),
'alliere': ('alliere',),
'allierer': ('alliere',),
'allieres': ('alliere',),
'alliert': ('alliere',),
'allierte': ('alliere',),
'allitterer': ('allitterere',),
'allitterere': ('allitterere',),
'allittererer': ('allitterere',),
'allittereres': ('allitterere',),
'allitterert': ('allitterere',),
'allittererte': ('allitterere',),
'alloker': ('allokere',),
'allokere': ('allokere',),
'allokerer': ('allokere',),
'allokeres': ('allokere',),
'allokert': ('allokere',),
'allokerte': ('allokere',),
'alluder': ('alludere',),
'alludere': ('alludere',),
'alluderer': ('alludere',),
'alluderes': ('alludere',),
'alludert': ('alludere',),
'alluderte': ('alludere',),
'alterer': ('alterere',),
'alterere': ('alterere',),
'altererer': ('alterere',),
'altereres': ('alterere',),
'alterert': ('alterere',),
'altererte': ('alterere',),
'alterner': ('alternere',),
'alternere': ('alternere',),
'alternerer': ('alternere',),
'alterneres': ('alternere',),
'alternert': ('alternere',),
'alternerte': ('alternere',),
'aluminer': ('aluminere',),
'aluminere': ('aluminere',),
'aluminerer': ('aluminere',),
'alumineres': ('aluminere',),
'aluminert': ('aluminere',),
'aluminerte': ('aluminere',),
'amalgamer': ('amalgamere',),
'amalgamere': ('amalgamere',),
'amalgamerer': ('amalgamere',),
'amalgameres': ('amalgamere',),
'amalgamert': ('amalgamere',),
'amalgamerte': ('amalgamere',),
'ambuler': ('ambulere',),
'ambulere': ('ambulere',),
'ambulerer': ('ambulere',),
'ambuleres': ('ambulere',),
'ambulert': ('ambulere',),
'ambulerte': ('ambulere',),
'amerikaniser': ('amerikanisere',),
'amerikanisere': ('amerikanisere',),
'amerikaniserer': ('amerikanisere',),
'amerikaniseres': ('amerikanisere',),
'amerikanisert': ('amerikanisere',),
'amerikaniserte': ('amerikanisere',),
'am': ('amme',),
'amma': ('amme',),
'amme': ('amme',),
'ammer': ('amme',),
'ammes': ('amme',),
'ammet': ('amme',),
'amortiser': ('amortisere',),
'amortisere': ('amortisere',),
'amortiserer': ('amortisere',),
'amortiseres': ('amortisere',),
'amortisert': ('amortisere',),
'amortiserte': ('amortisere',),
'amputer': ('amputere',),
'amputere': ('amputere',),
'amputerer': ('amputere',),
'amputeres': ('amputere',),
'amputert': ('amputere',),
'amputerte': ('amputere',),
'analyser': ('analysere',),
'analysere': ('analysere',),
'analyserer': ('analysere',),
'analyseres': ('analysere',),
'analysert': ('analysere',),
'analyserte': ('analysere',),
'anbefal': ('anbefale',),
'anbefale': ('anbefale',),
'anbefaler': ('anbefale',),
'anbefales': ('anbefale',),
'anbefalt': ('anbefale',),
'anbefalte': ('anbefale',),
'anbragt': ('anbringe',),
'anbragte': ('anbringe',),
'anbrakt': ('anbringe',),
'anbrakte': ('anbringe',),
'anbring': ('anbringe',),
'anbringe': ('anbringe',),
'anbringer': ('anbringe',),
'anbringes': ('anbringe',),
'and': ('ande',),
'anda': ('ande',),
'ande': ('ande',),
'ander': ('ande',),
'andes': ('ande',),
'andet': ('ande',),
'andra': ('andra',),
'andradd': ('andra',),
'andrar': ('andra',),
'andras': ('andra',),
'andratt': ('andra',),
'andro': ('andra',),
'androg': ('andra',),
'anduv': ('anduve',),
'anduva': ('anduve',),
'anduve': ('anduve',),
'anduver': ('anduve',),
'anduves': ('anduve',),
'anduvet': ('anduve',),
'andøv': ('andøve',),
'andøva': ('andøve',),
'andøvd': ('andøve',),
'andøvde': ('andøve',),
'andøve': ('andøve',),
'andøver': ('andøve',),
'andøves': ('andøve',),
'andøvet': ('andøve',),
'an': ('ane',),
'ane': ('ane',),
'aner': ('ane',),
'anes': ('ane',),
'ant': ('ane',),
'ante': ('ane',),
'anerkjenn': ('anerkjenne',),
'anerkjenne': ('anerkjenne',),
'anerkjenner': ('anerkjenne',),
'anerkjennes': ('anerkjenne',),
'anerkjent': ('anerkjenne',),
'anerkjente': ('anerkjenne',),
'anesteser': ('anestesere',),
'anestesere': ('anestesere',),
'anesteserer': ('anestesere',),
'anesteseres': ('anestesere',),
'anestesert': ('anestesere',),
'anesteserte': ('anestesere',),
'anfall': ('anfalle',),
'anfalle': ('anfalle',),
'anfaller': ('anfalle',),
'anfalles': ('anfalle',),
'anfalt': ('anfalle',),
'anfekt': ('anfekte',),
'anfekta': ('anfekte',),
'anfekte': ('anfekte',),
'anfekter': ('anfekte',),
'anfektes': ('anfekte',),
'anfektet': ('anfekte',),
'anfør': ('anføre',),
'anføre': ('anføre',),
'anfører': ('anføre',),
'anføres': ('anføre',),
'anført': ('anføre',),
'anførte': ('anføre',),
'ang': ('ange',),
'anga': ('ange',),
'ange': ('ange',),
'anger': ('ange',),
'anges': ('ange',),
'anget': ('ange',),
'anga': ('angi',),
'angav': ('angi',),
'angi': ('angi',),
'angies': ('angi',),
'angir': ('angi',),
'angis': ('angi',),
'angitt': ('angi',),
'angl': ('angle',),
'angla': ('angle',),
'angle': ('angle',),
'angler': ('angle',),
'angles': ('angle',),
'anglet': ('angle',),
'anglifiser': ('anglifisere',),
'anglifisere': ('anglifisere',),
'anglifiserer': ('anglifisere',),
'anglifiseres': ('anglifisere',),
'anglifisert': ('anglifisere',),
'anglifiserte': ('anglifisere',),
'angliser': ('anglisere',),
'anglisere': ('anglisere',),
'angliserer': ('anglisere',),
'angliseres': ('anglisere',),
'anglisert': ('anglisere',),
'angliserte': ('anglisere',),
'angr': ('angre',),
'angra': ('angre',),
'angre': ('angre',),
'angrer': ('angre',),
'angres': ('angre',),
'angret': ('angre',),
'angreip': ('angripe',),
'angrep': ('angripe',),
'angrepet': ('angripe',),
'angrip': ('angripe',),
'angripe': ('angripe',),
'angriper': ('angripe',),
'angripes': ('angripe',),
'angikk': ('angå',),
'angjekk': ('angå',),
'angå': ('angå',),
'angåes': ('angå',),
'angår': ('angå',),
'angås': ('angå',),
'angått': ('angå',),
'anhold': ('anholde',),
'anholde': ('anholde',),
'anholder': ('anholde',),
'anholdes': ('anholde',),
'anholdt': ('anholde',),
'animaliser': ('animalisere',),
'animalisere': ('animalisere',),
'animaliserer': ('animalisere',),
'animaliseres': ('animalisere',),
'animalisert': ('animalisere',),
'animaliserte': ('animalisere',),
'animer': ('animere',),
'animere': ('animere',),
'animerer': ('animere',),
'animeres': ('animere',),
'animert': ('animere',),
'animerte': ('animere',),
'ank': ('anke',),
'anka': ('anke',),
'anke': ('anke',),
'anker': ('anke',),
'ankes': ('anke',),
'anket': ('anke',),
'anklag': ('anklage',),
'anklaga': ('anklage',),
'anklagd': ('anklage',),
'anklagde': ('anklage',),
'anklage': ('anklage',),
'anklager': ('anklage',),
'anklages': ('anklage',),
'anklaget': ('anklage',),
'ankom': ('ankomme',),
'ankomme': ('ankomme',),
'ankommer': ('ankomme',),
'ankommes': ('ankomme',),
'ankommet': ('ankomme',),
'ankr': ('ankre',),
'ankra': ('ankre',),
'ankre': ('ankre',),
'ankrer': ('ankre',),
'ankres': ('ankre',),
'ankret': ('ankre',),
'anla': ('anlegge',),
'anlagt': ('anlegge',),
'anlegg': ('anlegge',),
'anlegge': ('anlegge',),
'anlegger': ('anlegge',),
'anlegges': ('anlegge',),
'anløp': ('anløpe',),
'anløpe': ('anløpe',),
'anløper': ('anløpe',),
'anløpes': ('anløpe',),
'anløpet': ('anløpe',),
'anløpt': ('anløpe',),
'anmass': ('anmasse',),
'anmassa': ('anmasse',),
'anmasse': ('anmasse',),
'anmasser': ('anmasse',),
'anmasses': ('anmasse',),
'anmasset': ('anmasse',),
'anmeld': ('anmelde',),
'anmelde': ('anmelde',),
'anmelder': ('anmelde',),
'anmeldes': ('anmelde',),
'anmeldt': ('anmelde',),
'anmeldte': ('anmelde',),
'anmerk': ('anmerke',),
'anmerka': ('anmerke',),
'anmerke': ('anmerke',),
'anmerker': ('anmerke',),
'anmerkes': ('anmerke',),
'anmerket': ('anmerke',),
'anmod': ('anmode',),
'anmoda': ('anmode',),
'anmode': ('anmode',),
'anmoder': ('anmode',),
'anmodes': ('anmode',),
'anmodet': ('anmode',),
'annam': ('annamme',),
'annamma': ('annamme',),
'annamme': ('annamme',),
'annammer': ('annamme',),
'annammes': ('annamme',),
'annammet': ('annamme',),
'annekter': ('annektere',),
'annektere': ('annektere',),
'annekterer': ('annektere',),
'annekteres': ('annektere',),
'annektert': ('annektere',),
'annekterte': ('annektere',),
'annonser': ('annonsere',),
'annonsere': ('annonsere',),
'annonserer': ('annonsere',),
'annonseres': ('annonsere',),
'annonsert': ('annonsere',),
'annonserte': ('annonsere',),
'annuller': ('annullere',),
'annullere': ('annullere',),
'annullerer': ('annullere',),
'annulleres': ('annullere',),
'annullert': ('annullere',),
'annullerte': ('annullere',),
'anodiser': ('anodisere',),
'anodisere': ('anodisere',),
'anodiserer': ('anodisere',),
'anodiseres': ('anodisere',),
'anodisert': ('anodisere',),
'anodiserte': ('anodisere',),
'anordn': ('anordne',),
'anordna': ('anordne',),
'anordne': ('anordne',),
'anordner': ('anordne',),
'anordnes': ('anordne',),
'anordnet': ('anordne',),
'anrett': ('anrette',),
'anretta': ('anrette',),
'anrette': ('anrette',),
'anretter': ('anrette',),
'anrettes': ('anrette',),
'anrettet': ('anrette',),
'anrik': ('anrike',),
'anrika': ('anrike',),
'anrike': ('anrike',),
'anriker': ('anrike',),
'anrikes': ('anrike',),
'anriket': ('anrike',),
'anrop': ('anrope',),
'anrope': ('anrope',),
'anroper': ('anrope',),
'anropes': ('anrope',),
'anropt': ('anrope',),
'anropte': ('anrope',),
'ans': ('anse',),
'ansa': ('anse',),
'anse': ('anse',),
'anser': ('anse',),
'anses': ('anse',),
'anset': ('anse',),
'anst': ('anse',),
'anste': ('anse',),
'anse': ('anse',),
'ansees': ('anse',),
'anser': ('anse',),
'anses': ('anse',),
'ansett': ('anse',),
'anså': ('anse',),
'ansåg': ('anse',),
'ansatt': ('ansette',),
'ansatte': ('ansette',),
'ansett': ('ansette',),
'ansette': ('ansette',),
'ansetter': ('ansette',),
'ansettes': ('ansette',),
'anskaff': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffe': ('anskaffe',),
'anskaffer': ('anskaffe',),
'anskaffes': ('anskaffe',),
'anskaffet': ('anskaffe',),
'ansku': ('anskue',),
'anskua': ('anskue',),
'anskue': ('anskue',),
'anskuer': ('anskue',),
'anskues': ('anskue',),
'anskuet': ('anskue',),
'anskueliggjorde': ('anskueliggjøre',),
'anskueliggjort': ('anskueliggjøre',),
'anskueliggjør': ('anskueliggjøre',),
'anskueliggjøre': ('anskueliggjøre',),
'anskueliggjøres': ('anskueliggjøre',),
'anslo': ('anslå',),
'anslå': ('anslå',),
'anslåes': ('anslå',),
'anslår': ('anslå',),
'anslås': ('anslå',),
'anslått': ('anslå',),
'anspenn': ('anspenne',),
'anspenne': ('anspenne',),
'anspenner': ('anspenne',),
'anspennes': ('anspenne',),
'anspent': ('anspenne',),
'anspente': ('anspenne',),
'anspor': ('anspore',),
'anspora': ('anspore',),
'anspore': ('anspore',),
'ansporer': ('anspore',),
'anspores': ('anspore',),
'ansporet': ('anspore',),
'ansport': ('anspore',),
'ansporte': ('anspore',),
'anstift': ('anstifte',),
'anstifta': ('anstifte',),
'anstifte': ('anstifte',),
'anstifter': ('anstifte',),
'anstiftes': ('anstifte',),
'anstiftet': ('anstifte',),
'anstill': ('anstille',),
'anstille': ('anstille',),
'anstiller': ('anstille',),
'anstilles': ('anstille',),
'anstilt': ('anstille',),
'anstilte': ('anstille',),
'anstreng': ('anstrenge',),
'anstrenge': ('anstrenge',),
'anstrenger': ('anstrenge',),
'anstrenges': ('anstrenge',),
'anstrengt': ('anstrenge',),
'anstrengte': ('anstrenge',),
'ansto': ('anstå',),
'anstod': ('anstå',),
'anstå': ('anstå',),
'anståes': ('anstå',),
'anstår': ('anstå',),
'anstås': ('anstå',),
'anstått': ('anstå',),
'ansøk': ('ansøke',),
'ansøke': ('ansøke',),
'ansøker': ('ansøke',),
'ansøkes': ('ansøke',),
'ansøkt': ('ansøke',),
'ansøkte': ('ansøke',),
'anta': ('anta',),
'antaes': ('anta',),
'antar': ('anta',),
'antas': ('anta',),
'antatt': ('anta',),
'antok': ('anta',),
'antast': ('antaste',),
'antasta': ('antaste',),
'antaste': ('antaste',),
'antaster': ('antaste',),
'antastes': ('antaste',),
'antastet': ('antaste',),
'antedater': ('antedatere',),
'antedatere': ('antedatere',),
'antedaterer': ('antedatere',),
'antedateres': ('antedatere',),
'antedatert': ('antedatere',),
'antedaterte': ('antedatere',),
'antegn': ('antegne',),
'antegna': ('antegne',),
'antegne': ('antegne',),
'antegner': ('antegne',),
'antegnes': ('antegne',),
'antegnet': ('antegne',),
'antenn': ('antenne',),
'antenne': ('antenne',),
'antenner': ('antenne',),
'antennes': ('antenne',),
'antent': ('antenne',),
'antente': ('antenne',),
'antesiper': ('antesipere',),
'antesipere': ('antesipere',),
'antesiperer': ('antesipere',),
'antesiperes': ('antesipere',),
'antesipert': ('antesipere',),
'antesiperte': ('antesipere',),
'antikiser': ('antikisere',),
'antikisere': ('antikisere',),
'antikiserer': ('antikisere',),
'antikiseres': ('antikisere',),
'antikisert': ('antikisere',),
'antikiserte': ('antikisere',),
'antikrympbehandl': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandle': ('antikrympbehandle',),
'antikrympbehandler': ('antikrympbehandle',),
'antikrympbehandles': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrøllbehandl': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandle': ('antikrøllbehandle',),
'antikrøllbehandler': ('antikrøllbehandle',),
'antikrøllbehandles': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antirefleksbehandl': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandle': ('antirefleksbehandle',),
'antirefleksbehandler': ('antirefleksbehandle',),
'antirefleksbehandles': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirustbehandl': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandle': ('antirustbehandle',),
'antirustbehandler': ('antirustbehandle',),
'antirustbehandles': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antistatbehandl': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandle': ('antistatbehandle',),
'antistatbehandler': ('antistatbehandle',),
'antistatbehandles': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antyd': ('antyde',),
'antyda': ('antyde',),
'antyde': ('antyde',),
'antyder': ('antyde',),
'antydes': ('antyde',),
'antydet': ('antyde',),
'anvend': ('anvende',),
'anvende': ('anvende',),
'anvender': ('anvende',),
'anvendes': ('anvende',),
'anvendt': ('anvende',),
'anvendte': ('anvende',),
'anvis': ('anvise',),
'anvise': ('anvise',),
'anviser': ('anvise',),
'anvises': ('anvise',),
'anvist': ('anvise',),
'anviste': ('anvise',),
'ap': ('ape',),
'apa': ('ape',),
'ape': ('ape',),
'aper': ('ape',),
'apes': ('ape',),
'apet': ('ape',),
'apt': ('ape',),
'apte': ('ape',),
'apokoper': ('apokopere',),
'apokopere': ('apokopere',),
'apokoperer': ('apokopere',),
'apokoperes': ('apokopere',),
'apokopert': ('apokopere',),
'apokoperte': ('apokopere',),
'apostrofer': ('apostrofere',),
'apostrofere': ('apostrofere',),
'apostroferer': ('apostrofere',),
'apostroferes': ('apostrofere',),
'apostrofert': ('apostrofere',),
'apostroferte': ('apostrofere',),
'appeller': ('appellere',),
'appellere': ('appellere',),
'appellerer': ('appellere',),
'appelleres': ('appellere',),
'appellert': ('appellere',),
'appellerte': ('appellere',),
'applauder': ('applaudere',),
'applaudere': ('applaudere',),
'applauderer': ('applaudere',),
'applauderes': ('applaudere',),
'applaudert': ('applaudere',),
'applauderte': ('applaudere',),
'appliker': ('applikere',),
'applikere': ('applikere',),
'applikerer': ('applikere',),
'applikeres': ('applikere',),
'applikert': ('applikere',),
'applikerte': ('applikere',),
'appliser': ('applisere',),
'applisere': ('applisere',),
'appliserer': ('applisere',),
'appliseres': ('applisere',),
'applisert': ('applisere',),
'appliserte': ('applisere',),
'apporter': ('apportere',),
'apportere': ('apportere',),
'apporterer': ('apportere',),
'apporteres': ('apportere',),
'apportert': ('apportere',),
'apporterte': ('apportere',),
'appreter': ('appretere',),
'appretere': ('appretere',),
'appreterer': ('appretere',),
'appreteres': ('appretere',),
'appretert': ('appretere',),
'appreterte': ('appretere',),
'approber': ('approbere',),
'approbere': ('approbere',),
'approberer': ('approbere',),
'approberes': ('approbere',),
'approbert': ('approbere',),
'approberte': ('approbere',),
'approprier': ('appropriere',),
'appropriere': ('appropriere',),
'approprierer': ('appropriere',),
'approprieres': ('appropriere',),
'appropriert': ('appropriere',),
'approprierte': ('appropriere',),
'apter': ('aptere',),
'aptere': ('aptere',),
'apterer': ('aptere',),
'apteres': ('aptere',),
'aptert': ('aptere',),
'apterte': ('aptere',),
'arbeid': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidd': ('arbeide',),
'arbeidde': ('arbeide',),
'arbeide': ('arbeide',),
'arbeider': ('arbeide',),
'arbeides': ('arbeide',),
'arbeidet': ('arbeide',),
'ard': ('arde',),
'arda': ('arde',),
'arde': ('arde',),
'arder': ('arde',),
'ardes': ('arde',),
'ardet': ('arde',),
'arg': ('arge',),
'arga': ('arge',),
'arge': ('arge',),
'arger': ('arge',),
'arges': ('arge',),
'arget': ('arge',),
'argumenter': ('argumentere',),
'argumentere': ('argumentere',),
'argumenterer': ('argumentere',),
'argumenteres': ('argumentere',),
'argumentert': ('argumentere',),
'argumenterte': ('argumentere',),
'arkaiser': ('arkaisere',),
'arkaisere': ('arkaisere',),
'arkaiserer': ('arkaisere',),
'arkaiseres': ('arkaisere',),
'arkaisert': ('arkaisere',),
'arkaiserte': ('arkaisere',),
'arkebuser': ('arkebusere',),
'arkebusere': ('arkebusere',),
'arkebuserer': ('arkebusere',),
'arkebuseres': ('arkebusere',),
'arkebusert': ('arkebusere',),
'arkebuserte': ('arkebusere',),
'arkiver': ('arkivere',),
'arkivere': ('arkivere',),
'arkiverer': ('arkivere',),
'arkiveres': ('arkivere',),
'arkivert': ('arkivere',),
'arkiverte': ('arkivere',),
'arm': ('arme',),
'arma': ('arme',),
'arme': ('arme',),
'armer': ('arme',),
'armes': ('arme',),
'armet': ('arme',),
'armer': ('armere',),
'armere': ('armere',),
'armerer': ('armere',),
'armeres': ('armere',),
'armert': ('armere',),
'armerte': ('armere',),
'aromatiser': ('aromatisere',),
'aromatisere': ('aromatisere',),
'aromatiserer': ('aromatisere',),
'aromatiseres': ('aromatisere',),
'aromatisert': ('aromatisere',),
'aromatiserte': ('aromatisere',),
'arranger': ('arrangere',),
'arrangere': ('arrangere',),
'arrangerer': ('arrangere',),
'arrangeres': ('arrangere',),
'arrangert': ('arrangere',),
'arrangerte': ('arrangere',),
'arrester': ('arrestere',),
'arrestere': ('arrestere',),
'arresterer': ('arrestere',),
'arresteres': ('arrestere',),
'arrestert': ('arrestere',),
'arresterte': ('arrestere',),
'arreter': ('arretere',),
'arretere': ('arretere',),
'arreterer': ('arretere',),
'arreteres': ('arretere',),
'arretert': ('arretere',),
'arreterte': ('arretere',),
'arriver': ('arrivere',),
'arrivere': ('arrivere',),
'arriverer': ('arrivere',),
'arriveres': ('arrivere',),
'arrivert': ('arrivere',),
'arriverte': ('arrivere',),
'arronder': ('arrondere',),
'arrondere': ('arrondere',),
'arronderer': ('arrondere',),
'arronderes': ('arrondere',),
'arrondert': ('arrondere',),
'arronderte': ('arrondere',),
'art': ('arte',),
'arta': ('arte',),
'arte': ('arte',),
'arter': ('arte',),
'artes': ('arte',),
'artet': ('arte',),
'artikuler': ('artikulere',),
'artikulere': ('artikulere',),
'artikulerer': ('artikulere',),
'artikuleres': ('artikulere',),
'artikulert': ('artikulere',),
'artikulerte': ('artikulere',),
'artsbestem': ('artsbestemme',),
'artsbestemme': ('artsbestemme',),
'artsbestemmer': ('artsbestemme',),
'artsbestemmes': ('artsbestemme',),
'artsbestemt': ('artsbestemme',),
'artsbestemte': ('artsbestemme',),
'arv': ('arve',),
'arva': ('arve',),
'arve': ('arve',),
'arver': ('arve',),
'arves': ('arve',),
'arvet': ('arve',),
'as': ('ase',),
'asa': ('ase',),
'ase': ('ase',),
'aser': ('ase',),
'ases': ('ase',),
'ast': ('ase',),
'aste': ('ase',),
'asfalter': ('asfaltere',),
'asfaltere': ('asfaltere',),
'asfalterer': ('asfaltere',),
'asfalteres': ('asfaltere',),
'asfaltert': ('asfaltere',),
'asfalterte': ('asfaltere',),
'aspirer': ('aspirere',),
'aspirere': ('aspirere',),
'aspirerer': ('aspirere',),
'aspireres': ('aspirere',),
'aspirert': ('aspirere',),
'aspirerte': ('aspirere',),
'assimiler': ('assimilere',),
'assimilere': ('assimilere',),
'assimilerer': ('assimilere',),
'assimileres': ('assimilere',),
'assimilert': ('assimilere',),
'assimilerte': ('assimilere',),
'assister': ('assistere',),
'assistere': ('assistere',),
'assisterer': ('assistere',),
'assisteres': ('assistere',),
'assistert': ('assistere',),
'assisterte': ('assistere',),
'assorter': ('assortere',),
'assortere': ('assortere',),
'assorterer': ('assortere',),
'assorteres': ('assortere',),
'assortert': ('assortere',),
'assorterte': ('assortere',),
'assosier': ('assosiere',),
'assosiere': ('assosiere',),
'assosierer': ('assosiere',),
'assosieres': ('assosiere',),
'assosiert': ('assosiere',),
'assosierte': ('assosiere',),
'assurer': ('assurere',),
'assurere': ('assurere',),
'assurerer': ('assurere',),
'assureres': ('assurere',),
'assurert': ('assurere',),
'assurerte': ('assurere',),
'astringer': ('astringere',),
'astringere': ('astringere',),
'astringerer': ('astringere',),
'astringeres': ('astringere',),
'astringert': ('astringere',),
'astringerte': ('astringere',),
'atomiser': ('atomisere',),
'atomisere': ('atomisere',),
'atomiserer': ('atomisere',),
'atomiseres': ('atomisere',),
'atomisert': ('atomisere',),
'atomiserte': ('atomisere',),
'atrofier': ('atrofiere',),
'atrofiere': ('atrofiere',),
'atrofierer': ('atrofiere',),
'atrofieres': ('atrofiere',),
'atrofiert': ('atrofiere',),
'atrofierte': ('atrofiere',),
'atskill': ('atskille',),
'atskille': ('atskille',),
'atskiller': ('atskille',),
'atskilles': ('atskille',),
'atskilt': ('atskille',),
'atskilte': ('atskille',),
'atspre': ('atspre',),
'atspredd': ('atspre',),
'atspredde': ('atspre',),
'atspredt': ('atspre',),
'atspredte': ('atspre',),
'atsprer': ('atspre',),
'atspres': ('atspre',),
'atspred': ('atsprede',),
'atspredd': ('atsprede',),
'atspredde': ('atsprede',),
'atsprede': ('atsprede',),
'atspreder': ('atsprede',),
'atspredes': ('atsprede',),
'atspredt': ('atsprede',),
'atspredte': ('atsprede',),
'attacher': ('attachere',),
'attachere': ('attachere',),
'attacherer': ('attachere',),
'attacheres': ('attachere',),
'attachert': ('attachere',),
'attacherte': ('attachere',),
'attakker': ('attakkere',),
'attakkere': ('attakkere',),
'attakkerer': ('attakkere',),
'attakkeres': ('attakkere',),
'attakkert': ('attakkere',),
'attakkerte': ('attakkere',),
'attester': ('attestere',),
'attestere': ('attestere',),
'attesterer': ('attestere',),
'attesteres': ('attestere',),
'attestert': ('attestere',),
'attesterte': ('attestere',),
'attraher': ('attrahere',),
'attrahere': ('attrahere',),
'attraherer': ('attrahere',),
'attraheres': ('attrahere',),
'attrahert': ('attrahere',),
'attraherte': ('attrahere',),
'attrå': ('attrå',),
'attrådd': ('attrå',),
'attrådde': ('attrå',),
'attrår': ('attrå',),
'attrås': ('attrå',),
'auk': ('auke',),
'auka': ('auke',),
'auke': ('auke',),
'auker': ('auke',),
'aukes': ('auke',),
'auket': ('auke',),
'aukt': ('auke',),
'aukte': ('auke',),
'auksjoner': ('auksjonere',),
'auksjonere': ('auksjonere',),
'auksjonerer': ('auksjonere',),
'auksjoneres': ('auksjonere',),
'auksjonert': ('auksjonere',),
'auksjonerte': ('auksjonere',),
'aur': ('aure',),
'aura': ('aure',),
'aure': ('aure',),
'aurer': ('aure',),
'aures': ('aure',),
'auret': ('aure',),
'aus': ('ause',),
'ause': ('ause',),
'auser': ('ause',),
'auses': ('ause',),
'aust': ('ause',),
'auste': ('ause',),
'autoklaver': ('autoklavere',),
'autoklavere': ('autoklavere',),
'autoklaverer': ('autoklavere',),
'autoklaveres': ('autoklavere',),
'autoklavert': ('autoklavere',),
'autoklaverte': ('autoklavere',),
'automatiser': ('automatisere',),
'automatisere': ('automatisere',),
'automatiserer': ('automatisere',),
'automatiseres': ('automatisere',),
'automatisert': ('automatisere',),
'automatiserte': ('automatisere',),
'autoriser': ('autorisere',),
'autorisere': ('autorisere',),
'autoriserer': ('autorisere',),
'autoriseres': ('autorisere',),
'autorisert': ('autorisere',),
'autoriserte': ('autorisere',),
'avaler': ('avalere',),
'avalere': ('avalere',),
'avalerer': ('avalere',),
'avaleres': ('avalere',),
'avalert': ('avalere',),
'avalerte': ('avalere',),
'avanser': ('avansere',),
'avansere': ('avansere',),
'avanserer': ('avansere',),
'avanseres': ('avansere',),
'avansert': ('avansere',),
'avanserte': ('avansere',),
'avbalanser': ('avbalansere',),
'avbalansere': ('avbalansere',),
'avbalanserer': ('avbalansere',),
'avbalanseres': ('avbalansere',),
'avbalansert': ('avbalansere',),
'avbalanserte': ('avbalansere',),
'avbestill': ('avbestille',),
'avbestille': ('avbestille',),
'avbestiller': ('avbestille',),
'avbestilles': ('avbestille',),
'avbestilt': ('avbestille',),
'avbestilte': ('avbestille',),
'avbetal': ('avbetale',),
'avbetale': ('avbetale',),
'avbetaler': ('avbetale',),
'avbetales': ('avbetale',),
'avbetalt': ('avbetale',),
'avbetalte': ('avbetale',),
'avbild': ('avbilde',),
'avbilda': ('avbilde',),
'avbilde': ('avbilde',),
'avbilder': ('avbilde',),
'avbildes': ('avbilde',),
'avbildet': ('avbilde',),
'avbandt': ('avbinde',),
'avbind': ('avbinde',),
'avbinde': ('avbinde',),
'avbinder': ('avbinde',),
'avbindes': ('avbinde',),
'avbundet': ('avbinde',),
'avblås': ('avblåse',),
'avblåse': ('avblåse',),
'avblåser': ('avblåse',),
'avblåses': ('avblåse',),
'avblåst': ('avblåse',),
'avblåste': ('avblåse',),
'avbraut': ('avbryte',),
'avbrutt': ('avbryte',),
'avbryt': ('avbryte',),
'avbryte': ('avbryte',),
'avbryter': ('avbryte',),
'avbrytes': ('avbryte',),
'avbrøt': ('avbryte',),
'avbrøyt': ('avbryte',),
'avbøt': ('avbøte',),
'avbøte': ('avbøte',),
'avbøter': ('avbøte',),
'avbøtes': ('avbøte',),
'avbøtt': ('avbøte',),
'avbøtte': ('avbøte',),
'avbøy': ('avbøye',),
'avbøya': ('avbøye',),
'avbøyd': ('avbøye',),
'avbøyde': ('avbøye',),
'avbøye': ('avbøye',),
'avbøyer': ('avbøye',),
'avbøyes': ('avbøye',),
'avbøyet': ('avbøye',),
'avdamp': ('avdampe',),
'avdampa': ('avdampe',),
'avdampe': ('avdampe',),
'avdamper': ('avdampe',),
'avdampes': ('avdampe',),
'avdampet': ('avdampe',),
'avdekk': ('avdekke',),
'avdekka': ('avdekke',),
'avdekke': ('avdekke',),
'avdekker': ('avdekke',),
'avdekkes': ('avdekke',),
'avdekket': ('avdekke',),
'avdekt': ('avdekke',),
'avdekte': ('avdekke',),
'avdel': ('avdele',),
'avdele': ('avdele',),
'avdeler': ('avdele',),
'avdeles': ('avdele',),
'avdelt': ('avdele',),
'avdelte': ('avdele',),
'avdemp': ('avdempe',),
'avdempa': ('avdempe',),
'avdempe': ('avdempe',),
'avdemper': ('avdempe',),
'avdempes': ('avdempe',),
'avdempet': ('avdempe',),
'avdra': ('avdra',),
'avdradd': ('avdra',),
'avdrar': ('avdra',),
'avdras': ('avdra',),
'avdratt': ('avdra',),
'avdro': ('avdra',),
'avdrog': ('avdra',),
'avdramatiser': ('avdramatisere',),
'avdramatisere': ('avdramatisere',),
'avdramatiserer': ('avdramatisere',),
'avdramatiseres': ('avdramatisere',),
'avdramatisert': ('avdramatisere',),
'avdramatiserte': ('avdramatisere',),
'avduk': ('avduke',),
'avduka': ('avduke',),
'avduke': ('avduke',),
'avduker': ('avduke',),
'avdukes': ('avduke',),
'avduket': ('avduke',),
'averter': ('avertere',),
'avertere': ('avertere',),
'averterer': ('avertere',),
'averteres': ('avertere',),
'avertert': ('avertere',),
'averterte': ('avertere',),
'avfas': ('avfase',),
'avfasa': ('avfase',),
'avfase': ('avfase',),
'avfaser': ('avfase',),
'avfases': ('avfase',),
'avfaset': ('avfase',),
'avfatt': ('avfatte',),
'avfatta': ('avfatte',),
'avfatte': ('avfatte',),
'avfatter': ('avfatte',),
'avfattes': ('avfatte',),
'avfattet': ('avfatte',),
'avfei': ('avfeie',),
'avfeia': ('avfeie',),
'avfeid': ('avfeie',),
'avfeide': ('avfeie',),
'avfeie': ('avfeie',),
'avfeier': ('avfeie',),
'avfeies': ('avfeie',),
'avfeiet': ('avfeie',),
'avferdig': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdige': ('avferdige',),
'avferdiger': ('avferdige',),
'avferdiges': ('avferdige',),
'avferdiget': ('avferdige',),
'avfett': ('avfette',),
'avfetta': ('avfette',),
'avfette': ('avfette',),
'avfetter': ('avfette',),
'avfettes': ('avfette',),
'avfettet': ('avfette',),
'avfann': ('avfinne',),
'avfant': ('avfinne',),
'avfinn': ('avfinne',),
'avfinne': ('avfinne',),
'avfinner': ('avfinne',),
'avfinnes': ('avfinne',),
'avfunnet': ('avfinne',),
'avfolk': ('avfolke',),
'avfolka': ('avfolke',),
'avfolke': ('avfolke',),
'avfolker': ('avfolke',),
'avfolkes': ('avfolke',),
'avfolket': ('avfolke',),
'avfyr': ('avfyre',),
'avfyre': ('avfyre',),
'avfyrer': ('avfyre',),
'avfyres': ('avfyre',),
'avfyrt': ('avfyre',),
'avfyrte': ('avfyre',),
'avfød': ('avføde',),
'avføde': ('avføde',),
'avføder': ('avføde',),
'avfødes': ('avføde',),
'avfødt': ('avføde',),
'avfødte': ('avføde',),
'avfør': ('avføre',),
'avføre': ('avføre',),
'avfører': ('avføre',),
'avføres': ('avføre',),
'avført': ('avføre',),
'avførte': ('avføre',),
'avga': ('avgi',),
'avgav': ('avgi',),
'avgi': ('avgi',),
'avgies': ('avgi',),
'avgir': ('avgi',),
'avgis': ('avgi',),
'avgitt': ('avgi',),
'avgjorde': ('avgjøre',),
'avgjort': ('avgjøre',),
'avgjør': ('avgjøre',),
'avgjøre': ('avgjøre',),
'avgjøres': ('avgjøre',),
'avgrens': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrense': ('avgrense',),
'avgrenser': ('avgrense',),
'avgrenses': ('avgrense',),
'avgrenset': ('avgrense',),
'avgikk': ('avgå',),
'avgjekk': ('avgå',),
'avgå': ('avgå',),
'avgåes': ('avgå',),
'avgår': ('avgå',),
'avgås': ('avgå',),
'avgått': ('avgå',),
'avheiml': ('avheimle',),
'avheimla': ('avheimle',),
'avheimle': ('avheimle',),
'avheimler': ('avheimle',),
'avheimles': ('avheimle',),
'avheimlet': ('avheimle',),
'avhend': ('avhende',),
'avhenda': ('avhende',),
'avhende': ('avhende',),
'avhender': ('avhende',),
'avhendes': ('avhende',),
'avhendet': ('avhende',),
'avhang': ('avhenge',),
'avheng': ('avhenge',),
'avhenge': ('avhenge',),
'avhenger': ('avhenge',),
'avhenges': ('avhenge',),
'avhengt': ('avhenge',),
'avhent': ('avhente',),
'avhenta': ('avhente',),
'avhente': ('avhente',),
'avhenter': ('avhente',),
'avhentes': ('avhente',),
'avhentet': ('avhente',),
'avherd': ('avherde',),
'avherda': ('avherde',),
'avherde': ('avherde',),
'avherder': ('avherde',),
'avherdes': ('avherde',),
'avherdet': ('avherde',),
'avhjalp': ('avhjelpe',),
'avhjelp': ('avhjelpe',),
'avhjelpe': ('avhjelpe',),
'avhjelper': ('avhjelpe',),
'avhjelpes': ('avhjelpe',),
'avhjulpet': ('avhjelpe',),
'avhjeml': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemle': ('avhjemle',),
'avhjemler': ('avhjemle',),
'avhjemles': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhold': ('avholde',),
'avholde': ('avholde',),
'avholder': ('avholde',),
'avholdes': ('avholde',),
'avholdt': ('avholde',),
'avhør': ('avhøre',),
'avhøre': ('avhøre',),
'avhører': ('avhøre',),
'avhøres': ('avhøre',),
'avhørt': ('avhøre',),
'avhørte': ('avhøre',),
'avis': ('avise',),
'avise': ('avise',),
'aviser': ('avise',),
'avises': ('avise',),
'avist': ('avise',),
'aviste': ('avise',),
'avkant': ('avkante',),
'avkanta': ('avkante',),
'avkante': ('avkante',),
'avkanter': ('avkante',),
'avkantes': ('avkante',),
'avkantet': ('avkante',),
'avkjøl': ('avkjøle',),
'avkjøle': ('avkjøle',),
'avkjøler': ('avkjøle',),
'avkjøles': ('avkjøle',),
'avkjølt': ('avkjøle',),
'avkjølte': ('avkjøle',),
'avkjønn': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønne': ('avkjønne',),
'avkjønner': ('avkjønne',),
'avkjønnes': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avklar': ('avklare',),
'avklare': ('avklare',),
'avklarer': ('avklare',),
'avklares': ('avklare',),
'avklart': ('avklare',),
'avklarte': ('avklare',),
'avkle': ('avkle',),
'avkledd': ('avkle',),
'avkledde': ('avkle',),
'avkler': ('avkle',),
'avkles': ('avkle',),
'avkod': ('avkode',),
'avkoda': ('avkode',),
'avkode': ('avkode',),
'avkoder': ('avkode',),
'avkodes': ('avkode',),
'avkodet': ('avkode',),
'avkok': ('avkoke',),
'avkoke': ('avkoke',),
'avkoker': ('avkoke',),
'avkokes': ('avkoke',),
'avkokt': ('avkoke',),
'avkokte': ('avkoke',),
'avkoloniser': ('avkolonisere',),
'avkolonisere': ('avkolonisere',),
'avkoloniserer': ('avkolonisere',),
'avkoloniseres': ('avkolonisere',),
'avkolonisert': ('avkolonisere',),
'avkoloniserte': ('avkolonisere',),
'avkort': ('avkorte',),
'avkorta': ('avkorte',),
'avkorte': ('avkorte',),
'avkorter': ('avkorte',),
'avkortes': ('avkorte',),
'avkortet': ('avkorte',),
'avkreft': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkrefte': ('avkrefte',),
'avkrefter': ('avkrefte',),
'avkreftes': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkrev': ('avkreve',),
'avkreva': ('avkreve',),
'avkrevd': ('avkreve',),
'avkrevde': ('avkreve',),
'avkreve': ('avkreve',),
'avkrever': ('avkreve',),
'avkreves': ('avkreve',),
'avkrevet': ('avkreve',),
'avkriminaliser': ('avkriminalisere',),
'avkriminalisere': ('avkriminalisere',),
'avkriminaliserer': ('avkriminalisere',),
'avkriminaliseres': ('avkriminalisere',),
'avkriminalisert': ('avkriminalisere',),
'avkriminaliserte': ('avkriminalisere',),
'avkristn': ('avkristne',),
'avkristna': ('avkristne',),
'avkristne': ('avkristne',),
'avkristner': ('avkristne',),
'avkristnes': ('avkristne',),
'avkristnet': ('avkristne',),
'avlast': ('avlaste',),
'avlasta': ('avlaste',),
'avlaste': ('avlaste',),
'avlaster': ('avlaste',),
'avlastes': ('avlaste',),
'avlastet': ('avlaste',),
'avl': ('avle',),
'avla': ('avle',),
'avle': ('avle',),
'avler': ('avle',),
'avles': ('avle',),
'avlet': ('avle',),
'avled': ('avlede',),
'avleda': ('avlede',),
'avlede': ('avlede',),
'avleder': ('avlede',),
'avledes': ('avlede',),
'avledet': ('avlede',),
'avla': ('avlegge',),
'avlagt': ('avlegge',),
'avlegg': ('avlegge',),
'avlegge': ('avlegge',),
'avlegger': ('avlegge',),
'avlegges': ('avlegge',),
'avlei': ('avleie',),
'avleid': ('avleie',),
'avleidd': ('avleie',),
'avleidde': ('avleie',),
'avleide': ('avleie',),
'avleie': ('avleie',),
'avleier': ('avleie',),
'avleies': ('avleie',),
'avleir': ('avleire',),
'avleira': ('avleire',),
'avleire': ('avleire',),
'avleirer': ('avleire',),
'avleires': ('avleire',),
'avleiret': ('avleire',),
'avles': ('avlese',),
'avlese': ('avlese',),
'avleser': ('avlese',),
'avleses': ('avlese',),
'avlest': ('avlese',),
'avleste': ('avlese',),
'avlever': ('avlevere',),
'avlevere': ('avlevere',),
'avleverer': ('avlevere',),
'avleveres': ('avlevere',),
'avlevert': ('avlevere',),
'avleverte': ('avlevere',),
'avliv': ('avlive',),
'avliva': ('avlive',),
'avlive': ('avlive',),
'avliver': ('avlive',),
'avlives': ('avlive',),
'avlivet': ('avlive',),
'avlokk': ('avlokke',),
'avlokka': ('avlokke',),
'avlokke': ('avlokke',),
'avlokker': ('avlokke',),
'avlokkes': ('avlokke',),
'avlokket': ('avlokke',),
'avlur': ('avlure',),
'avlure': ('avlure',),
'avlurer': ('avlure',),
'avlures': ('avlure',),
'avlurt': ('avlure',),
'avlurte': ('avlure',),
'avlus': ('avluse',),
'avlusa': ('avluse',),
'avluse': ('avluse',),
'avluser': ('avluse',),
'avluses': ('avluse',),
'avluset': ('avluse',),
'avlust': ('avluse',),
'avluste': ('avluse',),
'avlys': ('avlyse',),
'avlyse': ('avlyse',),
'avlyser': ('avlyse',),
'avlyses': ('avlyse',),
'avlyst': ('avlyse',),
'avlyste': ('avlyse',),
'avlytt': ('avlytte',),
'avlytta': ('avlytte',),
'avlytte': ('avlytte',),
'avlytter': ('avlytte',),
'avlyttes': ('avlytte',),
'avlyttet': ('avlytte',),
'avlås': ('avlåse',),
'avlåse': ('avlåse',),
'avlåser': ('avlåse',),
'avlåses': ('avlåse',),
'avlåst': ('avlåse',),
'avlåste': ('avlåse',),
'avlønn': ('avlønne',),
'avlønna': ('avlønne',),
'avlønne': ('avlønne',),
'avlønner': ('avlønne',),
'avlønnes': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønt': ('avlønne',),
'avlønte': ('avlønne',),
'avløs': ('avløse',),
'avløse': ('avløse',),
'avløser': ('avløse',),
'avløses': ('avløse',),
'avløst': ('avløse',),
'avløste': ('avløse',),
'avløys': ('avløyse',),
'avløyse': ('avløyse',),
'avløyser': ('avløyse',),
'avløyses': ('avløyse',),
'avløyst': ('avløyse',),
'avløyste': ('avløyse',),
'avmagnetiser': ('avmagnetisere',),
'avmagnetisere': ('avmagnetisere',),
'avmagnetiserer': ('avmagnetisere',),
'avmagnetiseres': ('avmagnetisere',),
'avmagnetisert': ('avmagnetisere',),
'avmagnetiserte': ('avmagnetisere',),
'avmagr': ('avmagre',),
'avmagra': ('avmagre',),
'avmagre': ('avmagre',),
'avmagrer': ('avmagre',),
'avmagres': ('avmagre',),
'avmagret': ('avmagre',),
'avmarsjer': ('avmarsjere',),
'avmarsjere': ('avmarsjere',),
'avmarsjerer': ('avmarsjere',),
'avmarsjeres': ('avmarsjere',),
'avmarsjert': ('avmarsjere',),
'avmarsjerte': ('avmarsjere',),
'avmerk': ('avmerke',),
'avmerka': ('avmerke',),
'avmerke': ('avmerke',),
'avmerker': ('avmerke',),
'avmerkes': ('avmerke',),
'avmerket': ('avmerke',),
'avmilitariser': ('avmilitarisere',),
'avmilitarisere': ('avmilitarisere',),
'avmilitariserer': ('avmilitarisere',),
'avmilitariseres': ('avmilitarisere',),
'avmilitarisert': ('avmilitarisere',),
'avmilitariserte': ('avmilitarisere',),
'avmytologiser': ('avmytologisere',),
'avmytologisere': ('avmytologisere',),
'avmytologiserer': ('avmytologisere',),
'avmytologiseres': ('avmytologisere',),
'avmytologisert': ('avmytologisere',),
'avmytologiserte': ('avmytologisere',),
'avmål': ('avmåle',),
'avmåle': ('avmåle',),
'avmåler': ('avmåle',),
'avmåles': ('avmåle',),
'avmålt': ('avmåle',),
'avmålte': ('avmåle',),
'avmønstr': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstre': ('avmønstre',),
'avmønstrer': ('avmønstre',),
'avmønstres': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avnasjonaliser': ('avnasjonalisere',),
'avnasjonalisere': ('avnasjonalisere',),
'avnasjonaliserer': ('avnasjonalisere',),
'avnasjonaliseres': ('avnasjonalisere',),
'avnasjonalisert': ('avnasjonalisere',),
'avnasjonaliserte': ('avnasjonalisere',),
'avnorsk': ('avnorske',),
'avnorska': ('avnorske',),
'avnorske': ('avnorske',),
'avnorsker': ('avnorske',),
'avnorskes': ('avnorske',),
'avnorsket': ('avnorske',),
'avpass': ('avpasse',),
'avpassa': ('avpasse',),
'avpasse': ('avpasse',),
'avpasser': ('avpasse',),
'avpasses': ('avpasse',),
'avpasset': ('avpasse',),
'avpatruljer': ('avpatruljere',),
'avpatruljere': ('avpatruljere',),
'avpatruljerer': ('avpatruljere',),
'avpatruljeres': ('avpatruljere',),
'avpatruljert': ('avpatruljere',),
'avpatruljerte': ('avpatruljere',),
'avpolitiser': ('avpolitisere',),
'avpolitisere': ('avpolitisere',),
'avpolitiserer': ('avpolitisere',),
'avpolitiseres': ('avpolitisere',),
'avpolitisert': ('avpolitisere',),
'avpolitiserte': ('avpolitisere',),
'avreager': ('avreagere',),
'avreagere': ('avreagere',),
'avreagerer': ('avreagere',),
'avreageres': ('avreagere',),
'avreagert': ('avreagere',),
'avreagerte': ('avreagere',),
'avrett': ('avrette',),
'avretta': ('avrette',),
'avrette': ('avrette',),
'avretter': ('avrette',),
'avrettes': ('avrette',),
'avrettet': ('avrette',),
'avrim': ('avrime',),
'avrima': ('avrime',),
'avrime': ('avrime',),
'avrimer': ('avrime',),
'avrimes': ('avrime',),
'avrimet': ('avrime',),
'avrund': ('avrunde',),
'avrunda': ('avrunde',),
'avrunde': ('avrunde',),
'avrunder': ('avrunde',),
'avrundes': ('avrunde',),
'avrundet': ('avrunde',),
'avrus': ('avruse',),
'avrusa': ('avruse',),
'avruse': ('avruse',),
'avruser': ('avruse',),
'avruses': ('avruse',),
'avruset': ('avruse',),
'avrust': ('avruste',),
'avrusta': ('avruste',),
'avruste': ('avruste',),
'avruster': ('avruste',),
'avrustes': ('avruste',),
'avrustet': ('avruste',),
'avrust': ('avruste',),
'avrusta': ('avruste',),
'avruste': ('avruste',),
'avruster': ('avruste',),
'avrustes': ('avruste',),
'avrustet': ('avruste',),
'avsann': ('avsanne',),
'avsanna': ('avsanne',),
'avsanne': ('avsanne',),
'avsanner': ('avsanne',),
'avsannes': ('avsanne',),
'avsannet': ('avsanne',),
'avse': ('avse',),
'avsees': ('avse',),
'avser': ('avse',),
'avses': ('avse',),
'avsett': ('avse',),
'avså': ('avse',),
'avsåg': ('avse',),
'avsend': ('avsende',),
'avsende': ('avsende',),
'avsender': ('avsende',),
'avsendes': ('avsende',),
'avsendt': ('avsende',),
'avsendte': ('avsende',),
'avsatt': ('avsette',),
'avsatte': ('avsette',),
'avsett': ('avsette',),
'avsette': ('avsette',),
'avsetter': ('avsette',),
'avsettes': ('avsette',),
'avsa': ('avsi',),
'avsagt': ('avsi',),
'avsi': ('avsi',),
'avsier': ('avsi',),
'avsies': ('avsi',),
'avsis': ('avsi',),
'avsil': ('avsile',),
'avsile': ('avsile',),
'avsiler': ('avsile',),
'avsiles': ('avsile',),
'avsilt': ('avsile',),
'avsilte': ('avsile',),
'avskaff': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffe': ('avskaffe',),
'avskaffer': ('avskaffe',),
'avskaffes': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskall': ('avskalle',),
'avskalla': ('avskalle',),
'avskalle': ('avskalle',),
'avskaller': ('avskalle',),
'avskalles': ('avskalle',),
'avskallet': ('avskalle',),
'avskilt': ('avskilte',),
'avskilta': ('avskilte',),
'avskilte': ('avskilte',),
'avskilter': ('avskilte',),
'avskiltes': ('avskilte',),
'avskiltet': ('avskilte',),
'avskip': ('avskipe',),
'avskipa': ('avskipe',),
'avskipe': ('avskipe',),
'avskiper': ('avskipe',),
'avskipes': ('avskipe',),
'avskipet': ('avskipe',),
'avskjedig': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjedige': ('avskjedige',),
'avskjediger': ('avskjedige',),
'avskjediges': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjerm': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjerme': ('avskjerme',),
'avskjermer': ('avskjerme',),
'avskjermes': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskar': ('avskjære',),
'avskjær': ('avskjære',),
'avskjære': ('avskjære',),
'avskjærer': ('avskjære',),
'avskjæres': ('avskjære',),
'avskåret': ('avskjære',),
'avskog': ('avskoge',),
'avskoga': ('avskoge',),
'avskoge': ('avskoge',),
'avskoger': ('avskoge',),
'avskoges': ('avskoge',),
'avskoget': ('avskoge',),
'avskrap': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrape': ('avskrape',),
'avskraper': ('avskrape',),
'avskrapes': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapt': ('avskrape',),
'avskrapte': ('avskrape',),
'avskrekk': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekke': ('avskrekke',),
'avskrekker': ('avskrekke',),
'avskrekkes': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskreiv': ('avskrive',),
'avskrev': ('avskrive',),
'avskrevet': ('avskrive',),
'avskriv': ('avskrive',),
'avskrive': ('avskrive',),
'avskriver': ('avskrive',),
'avskrives': ('avskrive',),
'avsky': ('avsky',),
'avskydd': ('avsky',),
'avskydde': ('avsky',),
'avskyr': ('avsky',),
'avskys': ('avsky',),
'avslutt': ('avslutte',),
'avslutta': ('avslutte',),
'avslutte': ('avslutte',),
'avslutter': ('avslutte',),
'avsluttes': ('avslutte',),
'avsluttet': ('avslutte',),
'avslo': ('avslå',),
'avslå': ('avslå',),
'avslåes': ('avslå',),
'avslår': ('avslå',),
'avslås': ('avslå',),
'avslått': ('avslå',),
'avslør': ('avsløre',),
'avsløra': ('avsløre',),
'avsløre': ('avsløre',),
'avslører': ('avsløre',),
'avsløres': ('avsløre',),
'avsløret': ('avsløre',),
'avslørt': ('avsløre',),
'avslørte': ('avsløre',),
'avsondr': ('avsondre',),
'avsondra': ('avsondre',),
'avsondre': ('avsondre',),
'avsondrer': ('avsondre',),
'avsondres': ('avsondre',),
'avsondret': ('avsondre',),
'avson': ('avsone',),
'avsona': ('avsone',),
'avsone': ('avsone',),
'avsoner': ('avsone',),
'avsones': ('avsone',),
'avsonet': ('avsone',),
'avsont': ('avsone',),
'avsonte': ('avsone',),
'avspalt': ('avspalte',),
'avspalta': ('avspalte',),
'avspalte': ('avspalte',),
'avspalter': ('avspalte',),
'avspaltes': ('avspalte',),
'avspaltet': ('avspalte',),
'avspaser': ('avspasere',),
'avspasere': ('avspasere',),
'avspaserer': ('avspasere',),
'avspaseres': ('avspasere',),
'avspasert': ('avspasere',),
'avspaserte': ('avspasere',),
'avspeil': ('avspeile',),
'avspeila': ('avspeile',),
'avspeile': ('avspeile',),
'avspeiler': ('avspeile',),
'avspeiles': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilt': ('avspeile',),
'avspeilte': ('avspeile',),
'avsperr': ('avsperre',),
'avsperra': ('avsperre',),
'avsperre': ('avsperre',),
'avsperrer': ('avsperre',),
'avsperres': ('avsperre',),
'avsperret': ('avsperre',),
'avspis': ('avspise',),
'avspise': ('avspise',),
'avspiser': ('avspise',),
'avspises': ('avspise',),
'avspist': ('avspise',),
'avspiste': ('avspise',),
'avspor': ('avspore',),
'avspora': ('avspore',),
'avspore': ('avspore',),
'avsporer': ('avspore',),
'avspores': ('avspore',),
'avsporet': ('avspore',),
'avsport': ('avspore',),
'avsporte': ('avspore',),
'avstedkom': ('avstedkomme',),
'avstedkomme': ('avstedkomme',),
'avstedkommer': ('avstedkomme',),
'avstedkommes': ('avstedkomme',),
'avstedkommet': ('avstedkomme',),
'avstem': ('avstemme',),
'avstemme': ('avstemme',),
'avstemmer': ('avstemme',),
'avstemmes': ('avstemme',),
'avstemt': ('avstemme',),
'avstemte': ('avstemme',),
'avstiv': ('avstive',),
'avstiva': ('avstive',),
'avstive': ('avstive',),
'avstiver': ('avstive',),
'avstives': ('avstive',),
'avstivet': ('avstive',),
'avstraff': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffe': ('avstraffe',),
'avstraffer': ('avstraffe',),
'avstraffes': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstress': ('avstresse',),
'avstressa': ('avstresse',),
'avstresse': ('avstresse',),
'avstresser': ('avstresse',),
'avstresses': ('avstresse',),
'avstresset': ('avstresse',),
'avsto': ('avstå',),
'avstod': ('avstå',),
'avstå': ('avstå',),
'avståes': ('avstå',),
'avstår': ('avstå',),
'avstås': ('avstå',),
'avstått': ('avstå',),
'avstøp': ('avstøpe',),
'avstøpe': ('avstøpe',),
'avstøper': ('avstøpe',),
'avstøpes': ('avstøpe',),
'avstøpt': ('avstøpe',),
'avstøpte': ('avstøpe',),
'avsvekk': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekke': ('avsvekke',),
'avsvekker': ('avsvekke',),
'avsvekkes': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekt': ('avsvekke',),
'avsvekte': ('avsvekke',),
'avsverg': ('avsverge',),
'avsverga': ('avsverge',),
'avsverge': ('avsverge',),
'avsverger': ('avsverge',),
'avsverges': ('avsverge',),
'avsverget': ('avsverge',),
'avsvor': ('avsverge',),
'avsvoret': ('avsverge',),
'avsverj': ('avsverje',),
'avsverja': ('avsverje',),
'avsverje': ('avsverje',),
'avsverjer': ('avsverje',),
'avsverjes': ('avsverje',),
'avsverjet': ('avsverje',),
'avsvor': ('avsverje',),
'avsvoret': ('avsverje',),
'avsved': ('avsvi',),
'avsvei': ('avsvi',),
'avsvi': ('avsvi',),
'avsvidd': ('avsvi',),
'avsvidde': ('avsvi',),
'avsvir': ('avsvi',),
'avsvis': ('avsvi',),
'avsang': ('avsynge',),
'avsunget': ('avsynge',),
'avsyng': ('avsynge',),
'avsynge': ('avsynge',),
'avsynger': ('avsynge',),
'avsynges': ('avsynge',),
'avta': ('avta',),
'avtaes': ('avta',),
'avtar': ('avta',),
'avtas': ('avta',),
'avtatt': ('avta',),
'avtok': ('avta',),
'avtal': ('avtale',),
'avtala': ('avtale',),
'avtale': ('avtale',),
'avtaler': ('avtale',),
'avtales': ('avtale',),
'avtalt': ('avtale',),
'avtalte': ('avtale',),
'avtalefest': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefeste': ('avtalefeste',),
'avtalefester': ('avtalefeste',),
'avtalefestes': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtegn': ('avtegne',),
'avtegna': ('avtegne',),
'avtegne': ('avtegne',),
'avtegner': ('avtegne',),
'avtegnes': ('avtegne',),
'avtegnet': ('avtegne',),
'avtjen': ('avtjene',),
'avtjene': ('avtjene',),
'avtjener': ('avtjene',),
'avtjenes': ('avtjene',),
'avtjent': ('avtjene',),
'avtjente': ('avtjene',),
'avtrapp': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappe': ('avtrappe',),
'avtrapper': ('avtrappe',),
'avtrappes': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtvang': ('avtvinge',),
'avtving': ('avtvinge',),
'avtvinge': ('avtvinge',),
'avtvinger': ('avtvinge',),
'avtvinges': ('avtvinge',),
'avtvunget': ('avtvinge',),
'avvei': ('avveie',),
'avveid': ('avveie',),
'avveide': ('avveie',),
'avveie': ('avveie',),
'avveier': ('avveie',),
'avveies': ('avveie',),
'avveiet': ('avveie',),
'avvend': ('avvende',),
'avvende': ('avvende',),
'avvender': ('avvende',),
'avvendes': ('avvende',),
'avvendt': ('avvende',),
'avvendte': ('avvende',),
'avvenn': ('avvenne',),
'avvenna': ('avvenne',),
'avvenne': ('avvenne',),
'avvenner': ('avvenne',),
'avvennes': ('avvenne',),
'avvennet': ('avvenne',),
'avvent': ('avvenne',),
'avvente': ('avvenne',),
'avvent': ('avvente',),
'avventa': ('avvente',),
'avvente': ('avvente',),
'avventer': ('avvente',),
'avventes': ('avvente',),
'avventet': ('avvente',),
'avverg': ('avverge',),
'avverga': ('avverge',),
'avverge': ('avverge',),
'avverger': ('avverge',),
'avverges': ('avverge',),
'avverget': ('avverge',),
'avverj': ('avverje',),
'avverja': ('avverje',),
'avverje': ('avverje',),
'avverjer': ('avverje',),
'avverjes': ('avverje',),
'avverjet': ('avverje',),
'avveik': ('avvike',),
'avvek': ('avvike',),
'avveket': ('avvike',),
'avvik': ('avvike',),
'avvike': ('avvike',),
'avviker': ('avvike',),
'avvikes': ('avvike',),
'avvikl': ('avvikle',),
'avvikla': ('avvikle',),
'avvikle': ('avvikle',),
'avvikler': ('avvikle',),
'avvikles': ('avvikle',),
'avviklet': ('avvikle',),
'avvirk': ('avvirke',),
'avvirka': ('avvirke',),
'avvirke': ('avvirke',),
'avvirker': ('avvirke',),
'avvirkes': ('avvirke',),
'avvirket': ('avvirke',),
'avvis': ('avvise',),
'avvise': ('avvise',),
'avviser': ('avvise',),
'avvises': ('avvise',),
'avvist': ('avvise',),
'avviste': ('avvise',),
'avvæpn': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpne': ('avvæpne',),
'avvæpner': ('avvæpne',),
'avvæpnes': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'babl': ('bable',),
'babla': ('bable',),
'bable': ('bable',),
'babler': ('bable',),
'bables': ('bable',),
'bablet': ('bable',),
'bad': ('bade',),
'bada': ('bade',),
'bade': ('bade',),
'bader': ('bade',),
'bades': ('bade',),
'badet': ('bade',),
'bagatelliser': ('bagatellisere',),
'bagatellisere': ('bagatellisere',),
'bagatelliserer': ('bagatellisere',),
'bagatelliseres': ('bagatellisere',),
'bagatellisert': ('bagatellisere',),
'bagatelliserte': ('bagatellisere',),
'baiss': ('baisse',),
'baissa': ('baisse',),
'baisse': ('baisse',),
'baisser': ('baisse',),
'baisses': ('baisse',),
'baisset': ('baisse',),
'bakbandt': ('bakbinde',),
'bakbind': ('bakbinde',),
'bakbinde': ('bakbinde',),
'bakbinder': ('bakbinde',),
'bakbindes': ('bakbinde',),
'bakbundet': ('bakbinde',),
'bak': ('bake',),
'baka': ('bake',),
'bake': ('bake',),
'baker': ('bake',),
'bakes': ('bake',),
'bakt': ('bake',),
'bakte': ('bake',),
'bakk': ('bakke',),
'bakka': ('bakke',),
'bakke': ('bakke',),
'bakker': ('bakke',),
'bakkes': ('bakke',),
'bakket': ('bakke',),
'bakk': ('bakke',),
'bakka': ('bakke',),
'bakke': ('bakke',),
'bakker': ('bakke',),
'bakkes': ('bakke',),
'bakket': ('bakke',),
'baks': ('bakse',),
'baksa': ('bakse',),
'bakse': ('bakse',),
'bakser': ('bakse',),
'bakses': ('bakse',),
'bakset': ('bakse',),
'baksnakk': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakke': ('baksnakke',),
'baksnakker': ('baksnakke',),
'baksnakkes': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baktal': ('baktale',),
'baktala': ('baktale',),
'baktale': ('baktale',),
'baktaler': ('baktale',),
'baktales': ('baktale',),
'baktalt': ('baktale',),
'baktalte': ('baktale',),
'bakvask': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvaske': ('bakvaske',),
'bakvasker': ('bakvaske',),
'bakvaskes': ('bakvaske',),
'bakvasket': ('bakvaske',),
'balanser': ('balansere',),
'balansere': ('balansere',),
'balanserer': ('balansere',),
'balanseres': ('balansere',),
'balansert': ('balansere',),
'balanserte': ('balansere',),
'bal': ('bale',),
'bala': ('bale',),
'bale': ('bale',),
'baler': ('bale',),
'bales': ('bale',),
'balet': ('bale',),
'balt': ('bale',),
'balte': ('bale',),
'balkaniser': ('balkanisere',),
'balkanisere': ('balkanisere',),
'balkaniserer': ('balkanisere',),
'balkaniseres': ('balkanisere',),
'balkanisert': ('balkanisere',),
'balkaniserte': ('balkanisere',),
'ballast': ('ballaste',),
'ballasta': ('ballaste',),
'ballaste': ('ballaste',),
'ballaster': ('ballaste',),
'ballastes': ('ballaste',),
'ballastet': ('ballaste',),
'ball': ('balle',),
'balla': ('balle',),
'balle': ('balle',),
'baller': ('balle',),
'balles': ('balle',),
'ballet': ('balle',),
'ballotter': ('ballottere',),
'ballottere': ('ballottere',),
'ballotterer': ('ballottere',),
'ballotteres': ('ballottere',),
'ballottert': ('ballottere',),
'ballotterte': ('ballottere',),
'balsamer': ('balsamere',),
'balsamere': ('balsamere',),
'balsamerer': ('balsamere',),
'balsameres': ('balsamere',),
'balsamert': ('balsamere',),
'balsamerte': ('balsamere',),
'banaliser': ('banalisere',),
'banalisere': ('banalisere',),
'banaliserer': ('banalisere',),
'banaliseres': ('banalisere',),
'banalisert': ('banalisere',),
'banaliserte': ('banalisere',),
'bandasjer': ('bandasjere',),
'bandasjere': ('bandasjere',),
'bandasjerer': ('bandasjere',),
'bandasjeres': ('bandasjere',),
'bandasjert': ('bandasjere',),
'bandasjerte': ('bandasjere',),
'band': ('bande',),
'banda': ('bande',),
'bande': ('bande',),
'bander': ('bande',),
'bandes': ('bande',),
'bandet': ('bande',),
'bandla': ('bandlegge',),
'bandlagt': ('bandlegge',),
'bandlegg': ('bandlegge',),
'bandlegge': ('bandlegge',),
'bandlegger': ('bandlegge',),
'bandlegges': ('bandlegge',),
'ban': ('bane',),
'bana': ('bane',),
'bane': ('bane',),
'baner': ('bane',),
'banes': ('bane',),
'banet': ('bane',),
'bant': ('bane',),
'bante': ('bane',),
'bank': ('banke',),
'banka': ('banke',),
'banke': ('banke',),
'banker': ('banke',),
'bankes': ('banke',),
'banket': ('banke',),
'bann': ('banne',),
'banna': ('banne',),
'banne': ('banne',),
'banner': ('banne',),
'bannes': ('banne',),
'bannet': ('banne',),
'bant': ('banne',),
'bante': ('banne',),
'bannlys': ('bannlyse',),
'bannlyse': ('bannlyse',),
'bannlyser': ('bannlyse',),
'bannlyses': ('bannlyse',),
'bannlyst': ('bannlyse',),
'bannlyste': ('bannlyse',),
'bannsatt': ('bannsette',),
'bannsatte': ('bannsette',),
'bannsett': ('bannsette',),
'bannsette': ('bannsette',),
'bannsetter': ('bannsette',),
'bannsettes': ('bannsette',),
'barber': ('barbere',),
'barbere': ('barbere',),
'barberer': ('barbere',),
'barberes': ('barbere',),
'barbert': ('barbere',),
'barberte': ('barbere',),
'barduner': ('bardunere',),
'bardunere': ('bardunere',),
'bardunerer': ('bardunere',),
'barduneres': ('bardunere',),
'bardunert': ('bardunere',),
'bardunerte': ('bardunere',),
'bar': ('bare',),
'bara': ('bare',),
'bare': ('bare',),
'barer': ('bare',),
'bares': ('bare',),
'baret': ('bare',),
'bark': ('barke',),
'barka': ('barke',),
'barke': ('barke',),
'barker': ('barke',),
'barkes': ('barke',),
'barket': ('barke',),
'barrikader': ('barrikadere',),
'barrikadere': ('barrikadere',),
'barrikaderer': ('barrikadere',),
'barrikaderes': ('barrikadere',),
'barrikadert': ('barrikadere',),
'barrikaderte': ('barrikadere',),
'barsk': ('barske',),
'barska': ('barske',),
'barske': ('barske',),
'barsker': ('barske',),
'barskes': ('barske',),
'barsket': ('barske',),
'bas': ('base',),
'basa': ('base',),
'base': ('base',),
'baser': ('base',),
'bases': ('base',),
'bast': ('base',),
'baste': ('base',),
'baser': ('basere',),
'basere': ('basere',),
'baserer': ('basere',),
'baseres': ('basere',),
'basert': ('basere',),
'baserte': ('basere',),
'bask': ('baske',),
'baska': ('baske',),
'baske': ('baske',),
'basker': ('baske',),
'baskes': ('baske',),
'basket': ('baske',),
'bast': ('baste',),
'basta': ('baste',),
'baste': ('baste',),
'baster': ('baste',),
'bastes': ('baste',),
'bastet': ('baste',),
'basuner': ('basunere',),
'basunere': ('basunere',),
'basunerer': ('basunere',),
'basuneres': ('basunere',),
'basunert': ('basunere',),
'basunerte': ('basunere',),
'baut': ('baute',),
'bauta': ('baute',),
'baute': ('baute',),
'bauter': ('baute',),
'bautes': ('baute',),
'bautet': ('baute',),
'ba': ('be',),
'bad': ('be',),
'be': ('be',),
'bedt': ('be',),
'ber': ('be',),
'bes': ('be',),
'bearbeid': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidd': ('bearbeide',),
'bearbeidde': ('bearbeide',),
'bearbeide': ('bearbeide',),
'bearbeider': ('bearbeide',),
'bearbeides': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bebo': ('bebo',),
'bebodd': ('bebo',),
'bebodde': ('bebo',),
'bebor': ('bebo',),
'bebos': ('bebo',),
'bebreid': ('bebreide',),
'bebreida': ('bebreide',),
'bebreide': ('bebreide',),
'bebreider': ('bebreide',),
'bebreides': ('bebreide',),
'bebreidet': ('bebreide',),
'bebud': ('bebude',),
'bebuda': ('bebude',),
'bebude': ('bebude',),
'bebuder': ('bebude',),
'bebudes': ('bebude',),
'bebudet': ('bebude',),
'bebygd': ('bebygge',),
'bebygde': ('bebygge',),
'bebygg': ('bebygge',),
'bebygga': ('bebygge',),
'bebygge': ('bebygge',),
'bebygger': ('bebygge',),
'bebygges': ('bebygge',),
'bebygget': ('bebygge',),
'bebyrd': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrde': ('bebyrde',),
'bebyrder': ('bebyrde',),
'bebyrdes': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bedag': ('bedage',),
'bedaga': ('bedage',),
'bedage': ('bedage',),
'bedager': ('bedage',),
'bedages': ('bedage',),
'bedaget': ('bedage',),
'ba': ('bede',),
'bad': ('bede',),
'bed': ('bede',),
'bede': ('bede',),
'beder': ('bede',),
'bedes': ('bede',),
'bedt': ('bede',),
'bedekk': ('bedekke',),
'bedekka': ('bedekke',),
'bedekke': ('bedekke',),
'bedekker': ('bedekke',),
'bedekkes': ('bedekke',),
'bedekket': ('bedekke',),
'bedekt': ('bedekke',),
'bedekte': ('bedekke',),
'bedra': ('bedra',),
'bedradd': ('bedra',),
'bedrar': ('bedra',),
'bedras': ('bedra',),
'bedratt': ('bedra',),
'bedro': ('bedra',),
'bedrog': ('bedra',),
'bedr': ('bedre',),
'bedra': ('bedre',),
'bedre': ('bedre',),
'bedrer': ('bedre',),
'bedres': ('bedre',),
'bedret': ('bedre',),
'bedreiv': ('bedrive',),
'bedrev': ('bedrive',),
'bedrevet': ('bedrive',),
'bedriv': ('bedrive',),
'bedrive': ('bedrive',),
'bedriver': ('bedrive',),
'bedrives': ('bedrive',),
'bedrøv': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøve': ('bedrøve',),
'bedrøver': ('bedrøve',),
'bedrøves': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedyr': ('bedyre',),
'bedyra': ('bedyre',),
'bedyre': ('bedyre',),
'bedyrer': ('bedyre',),
'bedyres': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrt': ('bedyre',),
'bedyrte': ('bedyre',),
'bedår': ('bedåre',),
'bedåra': ('bedåre',),
'bedåre': ('bedåre',),
'bedårer': ('bedåre',),
'bedåres': ('bedåre',),
'bedåret': ('bedåre',),
'bedøm': ('bedømme',),
'bedømme': ('bedømme',),
'bedømmer': ('bedømme',),
'bedømmes': ('bedømme',),
'bedømt': ('bedømme',),
'bedømte': ('bedømme',),
'bedøv': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvd': ('bedøve',),
'bedøvde': ('bedøve',),
'bedøve': ('bedøve',),
'bedøver': ('bedøve',),
'bedøves': ('bedøve',),
'bedøvet': ('bedøve',),
'beedig': ('beedige',),
'beediga': ('beedige',),
'beedige': ('beedige',),
'beediger': ('beedige',),
'beediges': ('beedige',),
'beediget': ('beedige',),
'befal': ('befale',),
'befale': ('befale',),
'befaler': ('befale',),
'befales': ('befale',),
'befalt': ('befale',),
'befalte': ('befale',),
'befar': ('befare',),
'befare': ('befare',),
'befarer': ('befare',),
'befares': ('befare',),
'befart': ('befare',),
'befarte': ('befare',),
'befatt': ('befatte',),
'befatta': ('befatte',),
'befatte': ('befatte',),
'befatter': ('befatte',),
'befattes': ('befatte',),
'befattet': ('befatte',),
'befest': ('befeste',),
'befesta': ('befeste',),
'befeste': ('befeste',),
'befester': ('befeste',),
'befestes': ('befeste',),
'befestet': ('befeste',),
'befann': ('befinne',),
'befant': ('befinne',),
'befinn': ('befinne',),
'befinne': ('befinne',),
'befinner': ('befinne',),
'befinnes': ('befinne',),
'befunnet': ('befinne',),
'beflitt': ('beflitte',),
'beflitta': ('beflitte',),
'beflitte': ('beflitte',),
'beflitter': ('beflitte',),
'beflittes': ('beflitte',),
'beflittet': ('beflitte',),
'befolk': ('befolke',),
'befolka': ('befolke',),
'befolke': ('befolke',),
'befolker': ('befolke',),
'befolkes': ('befolke',),
'befolket': ('befolke',),
'befordr': ('befordre',),
'befordra': ('befordre',),
'befordre': ('befordre',),
'befordrer': ('befordre',),
'befordres': ('befordre',),
'befordret': ('befordre',),
'befrakt': ('befrakte',),
'befrakta': ('befrakte',),
'befrakte': ('befrakte',),
'befrakter': ('befrakte',),
'befraktes': ('befrakte',),
'befraktet': ('befrakte',),
'befri': ('befri',),
'befridd': ('befri',),
'befridde': ('befri',),
'befrir': ('befri',),
'befris': ('befri',),
'befrukt': ('befrukte',),
'befrukta': ('befrukte',),
'befrukte': ('befrukte',),
'befrukter': ('befrukte',),
'befruktes': ('befrukte',),
'befruktet': ('befrukte',),
'beføl': ('beføle',),
'beføle': ('beføle',),
'beføler': ('beføle',),
'beføles': ('beføle',),
'befølt': ('beføle',),
'befølte': ('beføle',),
'begeistr': ('begeistre',),
'begeistra': ('begeistre',),
'begeistre': ('begeistre',),
'begeistrer': ('begeistre',),
'begeistres': ('begeistre',),
'begeistret': ('begeistre',),
'bega': ('begi',),
'begav': ('begi',),
'begi': ('begi',),
'begies': ('begi',),
'begir': ('begi',),
'begis': ('begi',),
'begitt': ('begi',),
'begjær': ('begjære',),
'begjære': ('begjære',),
'begjærer': ('begjære',),
'begjæres': ('begjære',),
'begjært': ('begjære',),
'begjærte': ('begjære',),
'beglo': ('beglo',),
'beglodd': ('beglo',),
'beglodde': ('beglo',),
'beglor': ('beglo',),
'beglos': ('beglo',),
'begrav': ('begrave',),
'begravd': ('begrave',),
'begravde': ('begrave',),
'begrave': ('begrave',),
'begraver': ('begrave',),
'begraves': ('begrave',),
'begravet': ('begrave',),
'begrov': ('begrave',),
'begrens': ('begrense',),
'begrensa': ('begrense',),
'begrense': ('begrense',),
'begrenser': ('begrense',),
'begrenses': ('begrense',),
'begrenset': ('begrense',),
'begrepsbestem': ('begrepsbestemme',),
'begrepsbestemme': ('begrepsbestemme',),
'begrepsbestemmer': ('begrepsbestemme',),
'begrepsbestemmes': ('begrepsbestemme',),
'begrepsbestemt': ('begrepsbestemme',),
'begrepsbestemte': ('begrepsbestemme',),
'begreip': ('begripe',),
'begrep': ('begripe',),
'begrepet': ('begripe',),
'begrip': ('begripe',),
'begripe': ('begripe',),
'begriper': ('begripe',),
'begripes': ('begripe',),
'begrunn': ('begrunne',),
'begrunna': ('begrunne',),
'begrunne': ('begrunne',),
'begrunner': ('begrunne',),
'begrunnes': ('begrunne',),
'begrunnet': ('begrunne',),
'begunstig': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstige': ('begunstige',),
'begunstiger': ('begunstige',),
'begunstiges': ('begunstige',),
'begunstiget': ('begunstige',),
'begynn': ('begynne',),
'begynne': ('begynne',),
'begynner': ('begynne',),
'begynnes': ('begynne',),
'begynt': ('begynne',),
'begynte': ('begynne',),
'begikk': ('begå',),
'begjekk': ('begå',),
'begå': ('begå',),
'begåes': ('begå',),
'begår': ('begå',),
'begås': ('begå',),
'begått': ('begå',),
'behag': ('behage',),
'behaga': ('behage',),
'behage': ('behage',),
'behager': ('behage',),
'behages': ('behage',),
'behaget': ('behage',),
'behandl': ('behandle',),
'behandla': ('behandle',),
'behandle': ('behandle',),
'behandler': ('behandle',),
'behandles': ('behandle',),
'behandlet': ('behandle',),
'beheft': ('behefte',),
'behefta': ('behefte',),
'behefte': ('behefte',),
'behefter': ('behefte',),
'beheftes': ('behefte',),
'beheftet': ('behefte',),
'behersk': ('beherske',),
'beherska': ('beherske',),
'beherske': ('beherske',),
'behersker': ('beherske',),
'beherskes': ('beherske',),
'behersket': ('beherske',),
'behold': ('beholde',),
'beholde': ('beholde',),
'beholder': ('beholde',),
'beholdes': ('beholde',),
'beholdt': ('beholde',),
'behøv': ('behøve',),
'behøvd': ('behøve',),
'behøvde': ('behøve',),
'behøve': ('behøve',),
'behøver': ('behøve',),
'behøves': ('behøve',),
'beil': ('beile',),
'beila': ('beile',),
'beile': ('beile',),
'beiler': ('beile',),
'beiles': ('beile',),
'beilet': ('beile',),
'beilt': ('beile',),
'beilte': ('beile',),
'bein': ('beine',),
'beina': ('beine',),
'beine': ('beine',),
'beiner': ('beine',),
'beines': ('beine',),
'beinet': ('beine',),
'beinflaug': ('beinflyge',),
'beinflydd': ('beinflyge',),
'beinflyg': ('beinflyge',),
'beinflyge': ('beinflyge',),
'beinflyger': ('beinflyge',),
'beinflyges': ('beinflyge',),
'beinfløy': ('beinflyge',),
'beinfløyet': ('beinflyge',),
'beink': ('beinke',),
'beinka': ('beinke',),
'beinke': ('beinke',),
'beinker': ('beinke',),
'beinkes': ('beinke',),
'beinket': ('beinke',),
'beis': ('beise',),
'beisa': ('beise',),
'beise': ('beise',),
'beiser': ('beise',),
'beises': ('beise',),
'beiset': ('beise',),
'beist': ('beise',),
'beiste': ('beise',),
'beiskn': ('beiskne',),
'beiskna': ('beiskne',),
'beiskne': ('beiskne',),
'beiskner': ('beiskne',),
'beisknes': ('beiskne',),
'beisknet': ('beiskne',),
'beit': ('beite',),
'beita': ('beite',),
'beite': ('beite',),
'beiter': ('beite',),
'beites': ('beite',),
'beitet': ('beite',),
'beitt': ('beite',),
'beitte': ('beite',),
'beja': ('bejae',),
'bejaa': ('bejae',),
'bejae': ('bejae',),
'bejaer': ('bejae',),
'bejaes': ('bejae',),
'bejaet': ('bejae',),
'bek': ('beke',),
'beka': ('beke',),
'beke': ('beke',),
'beker': ('beke',),
'bekes': ('beke',),
'beket': ('beke',),
'bekt': ('beke',),
'bekte': ('beke',),
'bekjemp': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempe': ('bekjempe',),
'bekjemper': ('bekjempe',),
'bekjempes': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjenn': ('bekjenne',),
'bekjenne': ('bekjenne',),
'bekjenner': ('bekjenne',),
'bekjennes': ('bekjenne',),
'bekjent': ('bekjenne',),
'bekjente': ('bekjenne',),
'bekjentgjorde': ('bekjentgjøre',),
'bekjentgjort': ('bekjentgjøre',),
'bekjentgjør': ('bekjentgjøre',),
'bekjentgjøre': ('bekjentgjøre',),
'bekjentgjøres': ('bekjentgjøre',),
'beklag': ('beklage',),
'beklaga': ('beklage',),
'beklagd': ('beklage',),
'beklagde': ('beklage',),
'beklage': ('beklage',),
'beklager': ('beklage',),
'beklages': ('beklage',),
'beklaget': ('beklage',),
'bekle': ('bekle',),
'bekledd': ('bekle',),
'bekledde': ('bekle',),
'bekler': ('bekle',),
'bekles': ('bekle',),
'beklipp': ('beklippe',),
'beklippa': ('beklippe',),
'beklippe': ('beklippe',),
'beklipper': ('beklippe',),
'beklippes': ('beklippe',),
'beklippet': ('beklippe',),
'beklipt': ('beklippe',),
'beklipte': ('beklippe',),
'bekom': ('bekomme',),
'bekomme': ('bekomme',),
'bekommer': ('bekomme',),
'bekommes': ('bekomme',),
'bekommet': ('bekomme',),
'bekost': ('bekoste',),
'bekosta': ('bekoste',),
'bekoste': ('bekoste',),
'bekoster': ('bekoste',),
'bekostes': ('bekoste',),
'bekostet': ('bekoste',),
'bekrans': ('bekranse',),
'bekransa': ('bekranse',),
'bekranse': ('bekranse',),
'bekranser': ('bekranse',),
'bekranses': ('bekranse',),
'bekranset': ('bekranse',),
'bekreft': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekrefte': ('bekrefte',),
'bekrefter': ('bekrefte',),
'bekreftes': ('bekrefte',),
'bekreftet': ('bekrefte',),
'beksl': ('beksle',),
'beksla': ('beksle',),
'beksle': ('beksle',),
'beksler': ('beksle',),
'beksles': ('beksle',),
'bekslet': ('beksle',),
'bekvem': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemme': ('bekvemme',),
'bekvemmer': ('bekvemme',),
'bekvemmes': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekymr': ('bekymre',),
'bekymra': ('bekymre',),
'bekymre': ('bekymre',),
'bekymrer': ('bekymre',),
'bekymres': ('bekymre',),
'bekymret': ('bekymre',),
'belag': ('belage',),
'belaga': ('belage',),
'belagd': ('belage',),
'belagde': ('belage',),
'belage': ('belage',),
'belager': ('belage',),
'belages': ('belage',),
'belaget': ('belage',),
'belast': ('belaste',),
'belasta': ('belaste',),
'belaste': ('belaste',),
'belaster': ('belaste',),
'belastes': ('belaste',),
'belastet': ('belaste',),
'bela': ('belegge',),
'belagt': ('belegge',),
'belegg': ('belegge',),
'belegge': ('belegge',),
'belegger': ('belegge',),
'belegges': ('belegge',),
'beleir': ('beleire',),
'beleira': ('beleire',),
'beleire': ('beleire',),
'beleirer': ('beleire',),
'beleires': ('beleire',),
'beleiret': ('beleire',),
'belemr': ('belemre',),
'belemra': ('belemre',),
'belemre': ('belemre',),
'belemrer': ('belemre',),
'belemres': ('belemre',),
'belemret': ('belemre',),
'beless': ('belesse',),
'belessa': ('belesse',),
'belesse': ('belesse',),
'belesser': ('belesse',),
'belesses': ('belesse',),
'belesset': ('belesse',),
'belest': ('belesse',),
'beleste': ('belesse',),
'belj': ('belje',),
'belja': ('belje',),
'belje': ('belje',),
'beljer': ('belje',),
'beljes': ('belje',),
'beljet': ('belje',),
'belj': ('belje',),
'belja': ('belje',),
'belje': ('belje',),
'beljer': ('belje',),
'beljes': ('belje',),
'beljet': ('belje',),
'belm': ('belme',),
'belma': ('belme',),
'belme': ('belme',),
'belmer': ('belme',),
'belmes': ('belme',),
'belmet': ('belme',),
'belys': ('belyse',),
'belyse': ('belyse',),
'belyser': ('belyse',),
'belyses': ('belyse',),
'belyst': ('belyse',),
'belyste': ('belyse',),
'belån': ('belåne',),
'belåne': ('belåne',),
'belåner': ('belåne',),
'belånes': ('belåne',),
'belånt': ('belåne',),
'belånte': ('belåne',),
'belær': ('belære',),
'belære': ('belære',),
'belærer': ('belære',),
'belæres': ('belære',),
'belært': ('belære',),
'belærte': ('belære',),
'belær': ('belære',),
'belære': ('belære',),
'belærer': ('belære',),
'belæres': ('belære',),
'belært': ('belære',),
'belærte': ('belære',),
'belønn': ('belønne',),
'belønna': ('belønne',),
'belønne': ('belønne',),
'belønner': ('belønne',),
'belønnes': ('belønne',),
'belønnet': ('belønne',),
'belønt': ('belønne',),
'belønte': ('belønne',),
'beløp': ('beløpe',),
'beløpe': ('beløpe',),
'beløper': ('beløpe',),
'beløpes': ('beløpe',),
'beløpet': ('beløpe',),
'beløpt': ('beløpe',),
'bemann': ('bemanne',),
'bemanna': ('bemanne',),
'bemanne': ('bemanne',),
'bemanner': ('bemanne',),
'bemannes': ('bemanne',),
'bemannet': ('bemanne',),
'bemektig': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektige': ('bemektige',),
'bemektiger': ('bemektige',),
'bemektiges': ('bemektige',),
'bemektiget': ('bemektige',),
'bemerk': ('bemerke',),
'bemerka': ('bemerke',),
'bemerke': ('bemerke',),
'bemerker': ('bemerke',),
'bemerkes': ('bemerke',),
'bemerket': ('bemerke',),
'bemyndig': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndige': ('bemyndige',),
'bemyndiger': ('bemyndige',),
'bemyndiges': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemøy': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyd': ('bemøye',),
'bemøyde': ('bemøye',),
'bemøye': ('bemøye',),
'bemøyer': ('bemøye',),
'bemøyes': ('bemøye',),
'bemøyet': ('bemøye',),
'bend': ('bende',),
'bende': ('bende',),
'bender': ('bende',),
'bendes': ('bende',),
'bendt': ('bende',),
'bendte': ('bende',),
'ben': ('bene',),
'bena': ('bene',),
'bene': ('bene',),
'bener': ('bene',),
'benes': ('bene',),
'benet': ('bene',),
'benekt': ('benekte',),
'benekta': ('benekte',),
'benekte': ('benekte',),
'benekter': ('benekte',),
'benektes': ('benekte',),
'benektet': ('benekte',),
'benevn': ('benevne',),
'benevne': ('benevne',),
'benevner': ('benevne',),
'benevnes': ('benevne',),
'benevnt': ('benevne',),
'benevnte': ('benevne',),
'benk': ('benke',),
'benka': ('benke',),
'benke': ('benke',),
'benker': ('benke',),
'benkes': ('benke',),
'benket': ('benke',),
'benk': ('benke',),
'benka': ('benke',),
'benke': ('benke',),
'benker': ('benke',),
'benkes': ('benke',),
'benket': ('benke',),
'benytt': ('benytte',),
'benytta': ('benytte',),
'benytte': ('benytte',),
'benytter': ('benytte',),
'benyttes': ('benytte',),
'benyttet': ('benytte',),
'benåd': ('benåde',),
'benåda': ('benåde',),
'benåde': ('benåde',),
'benåder': ('benåde',),
'benådes': ('benåde',),
'benådet': ('benåde',),
'beordr': ('beordre',),
'beordra': ('beordre',),
'beordre': ('beordre',),
'beordrer': ('beordre',),
'beordres': ('beordre',),
'beordret': ('beordre',),
'beplant': ('beplante',),
'beplanta': ('beplante',),
'beplante': ('beplante',),
'beplanter': ('beplante',),
'beplantes': ('beplante',),
'beplantet': ('beplante',),
'beram': ('beramme',),
'beramma': ('beramme',),
'beramme': ('beramme',),
'berammer': ('beramme',),
'berammes': ('beramme',),
'berammet': ('beramme',),
'bered': ('berede',),
'berede': ('berede',),
'bereder': ('berede',),
'beredes': ('berede',),
'beredt': ('berede',),
'beredte': ('berede',),
'beregn': ('beregne',),
'beregna': ('beregne',),
'beregne': ('beregne',),
'beregner': ('beregne',),
'beregnes': ('beregne',),
'beregnet': ('beregne',),
'berekn': ('berekne',),
'berekna': ('berekne',),
'berekne': ('berekne',),
'berekner': ('berekne',),
'bereknes': ('berekne',),
'bereknet': ('berekne',),
'berett': ('berette',),
'beretta': ('berette',),
'berette': ('berette',),
'beretter': ('berette',),
'berettes': ('berette',),
'berettet': ('berette',),
'berettig': ('berettige',),
'berettiga': ('berettige',),
'berettige': ('berettige',),
'berettiger': ('berettige',),
'berettiges': ('berettige',),
'berettiget': ('berettige',),
'berg': ('berge',),
'berga': ('berge',),
'berge': ('berge',),
'berger': ('berge',),
'berges': ('berge',),
'berget': ('berge',),
'bergta': ('bergta',),
'bergtaes': ('bergta',),
'bergtar': ('bergta',),
'bergtas': ('bergta',),
'bergtatt': ('bergta',),
'bergtok': ('bergta',),
'berik': ('berike',),
'berika': ('berike',),
'berike': ('berike',),
'beriker': ('berike',),
'berikes': ('berike',),
'beriket': ('berike',),
'beriktig': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktige': ('beriktige',),
'beriktiger': ('beriktige',),
'beriktiges': ('beriktige',),
'beriktiget': ('beriktige',),
'bero': ('bero',),
'berodd': ('bero',),
'berodde': ('bero',),
'beror': ('bero',),
'beros': ('bero',),
'berolig': ('berolige',),
'beroliga': ('berolige',),
'berolige': ('berolige',),
'beroliger': ('berolige',),
'beroliges': ('berolige',),
'beroliget': ('berolige',),
'bert': ('berte',),
'berta': ('berte',),
'berte': ('berte',),
'berter': ('berte',),
'bertes': ('berte',),
'bertet': ('berte',),
'berus': ('beruse',),
'berusa': ('beruse',),
'beruse': ('beruse',),
'beruser': ('beruse',),
'beruses': ('beruse',),
'beruset': ('beruse',),
'berust': ('beruse',),
'beruste': ('beruse',),
'berøm': ('berømme',),
'berømma': ('berømme',),
'berømme': ('berømme',),
'berømmer': ('berømme',),
'berømmes': ('berømme',),
'berømmet': ('berømme',),
'berømt': ('berømme',),
'berømte': ('berømme',),
'berør': ('berøre',),
'berøre': ('berøre',),
'berører': ('berøre',),
'berøres': ('berøre',),
'berørt': ('berøre',),
'berørte': ('berøre',),
'berøv': ('berøve',),
'berøva': ('berøve',),
'berøvd': ('berøve',),
'berøvde': ('berøve',),
'berøve': ('berøve',),
'berøver': ('berøve',),
'berøves': ('berøve',),
'berøvet': ('berøve',),
'bese': ('bese',),
'besees': ('bese',),
'beser': ('bese',),
'beses': ('bese',),
'besett': ('bese',),
'beså': ('bese',),
'besåg': ('bese',),
'besegl': ('besegle',),
'besegla': ('besegle',),
'besegle': ('besegle',),
'besegler': ('besegle',),
'besegles': ('besegle',),
'beseglet': ('besegle',),
'beseir': ('beseire',),
'beseira': ('beseire',),
'beseire': ('beseire',),
'beseirer': ('beseire',),
'beseires': ('beseire',),
'beseiret': ('beseire',),
'besatt': ('besette',),
'besatte': ('besette',),
'besett': ('besette',),
'besette': ('besette',),
'besetter': ('besette',),
'besettes': ('besette',),
'besifr': ('besifre',),
'besifra': ('besifre',),
'besifre': ('besifre',),
'besifrer': ('besifre',),
'besifres': ('besifre',),
'besifret': ('besifre',),
'besikt': ('besikte',),
'besikta': ('besikte',),
'besikte': ('besikte',),
'besikter': ('besikte',),
'besiktes': ('besikte',),
'besiktet': ('besikte',),
'besiktig': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktige': ('besiktige',),
'besiktiger': ('besiktige',),
'besiktiges': ('besiktige',),
'besiktiget': ('besiktige',),
'besinn': ('besinne',),
'besinna': ('besinne',),
'besinne': ('besinne',),
'besinner': ('besinne',),
'besinnes': ('besinne',),
'besinnet': ('besinne',),
'besatt': ('besitte',),
'besitt': ('besitte',),
'besitte': ('besitte',),
'besitter': ('besitte',),
'besittes': ('besitte',),
'besittet': ('besitte',),
'besjel': ('besjele',),
'besjele': ('besjele',),
'besjeler': ('besjele',),
'besjeles': ('besjele',),
'besjelt': ('besjele',),
'besjelte': ('besjele',),
'beskadig': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadige': ('beskadige',),
'beskadiger': ('beskadige',),
'beskadiges': ('beskadige',),
'beskadiget': ('beskadige',),
'beskatt': ('beskatte',),
'beskatta': ('beskatte',),
'beskatte': ('beskatte',),
'beskatter': ('beskatte',),
'beskattes': ('beskatte',),
'beskattet': ('beskatte',),
'beskikk': ('beskikke',),
'beskikka': ('beskikke',),
'beskikke': ('beskikke',),
'beskikker': ('beskikke',),
'beskikkes': ('beskikke',),
'beskikket': ('beskikke',),
'beskjeftig': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftige': ('beskjeftige',),
'beskjeftiger': ('beskjeftige',),
'beskjeftiges': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskar': ('beskjære',),
'beskjær': ('beskjære',),
'beskjære': ('beskjære',),
'beskjærer': ('beskjære',),
'beskjæres': ('beskjære',),
'beskåret': ('beskjære',),
'beskar': ('beskjære',),
'beskjær': ('beskjære',),
'beskjære': ('beskjære',),
'beskjærer': ('beskjære',),
'beskjæres': ('beskjære',),
'beskåret': ('beskjære',),
'beskn': ('beskne',),
'beskna': ('beskne',),
'beskne': ('beskne',),
'beskner': ('beskne',),
'besknes': ('beskne',),
'besknet': ('beskne',),
'beskreiv': ('beskrive',),
'beskrev': ('beskrive',),
'beskrevet': ('beskrive',),
'beskriv': ('beskrive',),
'beskrive': ('beskrive',),
'beskriver': ('beskrive',),
'beskrives': ('beskrive',),
'besku': ('beskue',),
'beskua': ('beskue',),
'beskue': ('beskue',),
'beskuer': ('beskue',),
'beskues': ('beskue',),
'beskuet': ('beskue',),
'beskyld': ('beskylde',),
'beskylde': ('beskylde',),
'beskylder': ('beskylde',),
'beskyldes': ('beskylde',),
'beskyldt': ('beskylde',),
'beskyldte': ('beskylde',),
'beskaut': ('beskyte',),
'beskjøt': ('beskyte',),
'beskutt': ('beskyte',),
'beskyt': ('beskyte',),
'beskyte': ('beskyte',),
'beskyter': ('beskyte',),
'beskytes': ('beskyte',),
'beskøyt': ('beskyte',),
'beskytt': ('beskytte',),
'beskytta': ('beskytte',),
'beskytte': ('beskytte',),
'beskytter': ('beskytte',),
'beskyttes': ('beskytte',),
'beskyttet': ('beskytte',),
'beslagla': ('beslaglegge',),
'beslaglagt': ('beslaglegge',),
'beslaglegg': ('beslaglegge',),
'beslaglegge': ('beslaglegge',),
'beslaglegger': ('beslaglegge',),
'beslaglegges': ('beslaglegge',),
'beslutt': ('beslutte',),
'beslutta': ('beslutte',),
'beslutte': ('beslutte',),
'beslutter': ('beslutte',),
'besluttes': ('beslutte',),
'besluttet': ('beslutte',),
'beslo': ('beslå',),
'beslå': ('beslå',),
'beslåes': ('beslå',),
'beslår': ('beslå',),
'beslås': ('beslå',),
'beslått': ('beslå',),
'besmitt': ('besmitte',),
'besmitta': ('besmitte',),
'besmitte': ('besmitte',),
'besmitter': ('besmitte',),
'besmittes': ('besmitte',),
'besmittet': ('besmitte',),
'besnakk': ('besnakke',),
'besnakka': ('besnakke',),
'besnakke': ('besnakke',),
'besnakker': ('besnakke',),
'besnakkes': ('besnakke',),
'besnakket': ('besnakke',),
'besnær': ('besnære',),
'besnæra': ('besnære',),
'besnære': ('besnære',),
'besnærer': ('besnære',),
'besnæres': ('besnære',),
'besnæret': ('besnære',),
'besnært': ('besnære',),
'besnærte': ('besnære',),
'bespis': ('bespise',),
'bespise': ('bespise',),
'bespiser': ('bespise',),
'bespises': ('bespise',),
'bespist': ('bespise',),
'bespiste': ('bespise',),
'bespott': ('bespotte',),
'bespotta': ('bespotte',),
'bespotte': ('bespotte',),
'bespotter': ('bespotte',),
'bespottes': ('bespotte',),
'bespottet': ('bespotte',),
'bestem': ('bestemme',),
'bestemme': ('bestemme',),
'bestemmer': ('bestemme',),
'bestemmes': ('bestemme',),
'bestemt': ('bestemme',),
'bestemte': ('bestemme',),
'besteg': ('bestige',),
'besteget': ('bestige',),
'besteig': ('bestige',),
'bestig': ('bestige',),
'bestige': ('bestige',),
'bestiger': ('bestige',),
'bestiges': ('bestige',),
'bestakk': ('bestikke',),
'bestikk': ('bestikke',),
'bestikke': ('bestikke',),
'bestikker': ('bestikke',),
'bestikkes': ('bestikke',),
'bestukket': ('bestikke',),
'bestill': ('bestille',),
'bestille': ('bestille',),
'bestiller': ('bestille',),
'bestilles': ('bestille',),
'bestilt': ('bestille',),
'bestilte': ('bestille',),
'bestjal': ('bestjele',),
'bestjel': ('bestjele',),
'bestjele': ('bestjele',),
'bestjeler': ('bestjele',),
'bestjeles': ('bestjele',),
'bestjålet': ('bestjele',),
'bestorm': ('bestorme',),
'bestorma': ('bestorme',),
'bestorme': ('bestorme',),
'bestormer': ('bestorme',),
'bestormes': ('bestorme',),
'bestormet': ('bestorme',),
'bestreb': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebe': ('bestrebe',),
'bestreber': ('bestrebe',),
'bestrebes': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestred': ('bestri',),
'bestrei': ('bestri',),
'bestreid': ('bestri',),
'bestri': ('bestri',),
'bestridd': ('bestri',),
'bestridt': ('bestri',),
'bestrir': ('bestri',),
'bestris': ('bestri',),
'bestred': ('bestride',),
'bestrei': ('bestride',),
'bestreid': ('bestride',),
'bestrid': ('bestride',),
'bestridd': ('bestride',),
'bestride': ('bestride',),
'bestrider': ('bestride',),
'bestrides': ('bestride',),
'bestridt': ('bestride',),
'bestrauk': ('bestryke',),
'bestryk': ('bestryke',),
'bestryke': ('bestryke',),
'bestryker': ('bestryke',),
'bestrykes': ('bestryke',),
'bestrøk': ('bestryke',),
'bestrøket': ('bestryke',),
'bestrøyk': ('bestryke',),
'bestrål': ('bestråle',),
'bestråle': ('bestråle',),
'bestråler': ('bestråle',),
'bestråles': ('bestråle',),
'bestrålt': ('bestråle',),
'bestrålte': ('bestråle',),
'bestykk': ('bestykke',),
'bestykka': ('bestykke',),
'bestykke': ('bestykke',),
'bestykker': ('bestykke',),
'bestykkes': ('bestykke',),
'bestykket': ('bestykke',),
'bestyr': ('bestyre',),
'bestyre': ('bestyre',),
'bestyrer': ('bestyre',),
'bestyres': ('bestyre',),
'bestyrt': ('bestyre',),
'bestyrte': ('bestyre',),
'bestyrk': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrke': ('bestyrke',),
'bestyrker': ('bestyrke',),
'bestyrkes': ('bestyrke',),
'bestyrket': ('bestyrke',),
'besto': ('bestå',),
'bestod': ('bestå',),
'bestå': ('bestå',),
'beståes': ('bestå',),
'består': ('bestå',),
'bestås': ('bestå',),
'bestått': ('bestå',),
'bestøv': ('bestøve',),
'bestøva': ('bestøve',),
'bestøve': ('bestøve',),
'bestøver': ('bestøve',),
'bestøves': ('bestøve',),
'bestøvet': ('bestøve',),
'besudl': ('besudle',),
'besudla': ('besudle',),
'besudle': ('besudle',),
'besudler': ('besudle',),
'besudles': ('besudle',),
'besudlet': ('besudle',),
'besvangr': ('besvangre',),
'besvangra': ('besvangre',),
'besvangre': ('besvangre',),
'besvangrer': ('besvangre',),
'besvangres': ('besvangre',),
'besvangret': ('besvangre',),
'besvar': ('besvare',),
'besvara': ('besvare',),
'besvare': ('besvare',),
'besvarer': ('besvare',),
'besvares': ('besvare',),
'besvart': ('besvare',),
'besvarte': ('besvare',),
'besverg': ('besverge',),
'besverga': ('besverge',),
'besverge': ('besverge',),
'besverger': ('besverge',),
'besverges': ('besverge',),
'besverget': ('besverge',),
'besvor': ('besverge',),
'besvoret': ('besverge',),
'besverj': ('besverje',),
'besverja': ('besverje',),
'besverje': ('besverje',),
'besverjer': ('besverje',),
'besverjes': ('besverje',),
'besverjet': ('besverje',),
'besvor': ('besverje',),
'besvoret': ('besverje',),
'besvim': ('besvime',),
'besvime': ('besvime',),
'besvimer': ('besvime',),
'besvimes': ('besvime',),
'besvimt': ('besvime',),
'besvimte': ('besvime',),
'besvær': ('besvære',),
'besværa': ('besvære',),
'besvære': ('besvære',),
'besværer': ('besvære',),
'besværes': ('besvære',),
'besværet': ('besvære',),
'besvært': ('besvære',),
'besværte': ('besvære',),
'besang': ('besynge',),
'besunget': ('besynge',),
'besyng': ('besynge',),
'besynge': ('besynge',),
'besynger': ('besynge',),
'besynges': ('besynge',),
'besøk': ('besøke',),
'besøke': ('besøke',),
'besøker': ('besøke',),
'besøkes': ('besøke',),
'besøkt': ('besøke',),
'besøkte': ('besøke',),
'besørg': ('besørge',),
'besørga': ('besørge',),
'besørge': ('besørge',),
'besørger': ('besørge',),
'besørges': ('besørge',),
'besørget': ('besørge',),
'beta': ('beta',),
'betaes': ('beta',),
'betar': ('beta',),
'betas': ('beta',),
'betatt': ('beta',),
'betok': ('beta',),
'betakk': ('betakke',),
'betakka': ('betakke',),
'betakke': ('betakke',),
'betakker': ('betakke',),
'betakkes': ('betakke',),
'betakket': ('betakke',),
'betal': ('betale',),
'betale': ('betale',),
'betaler': ('betale',),
'betales': ('betale',),
'betalt': ('betale',),
'betalte': ('betale',),
'bete': ('bete',),
'betedd': ('bete',),
'betedde': ('bete',),
'beter': ('bete',),
'betes': ('bete',),
'betegn': ('betegne',),
'betegna': ('betegne',),
'betegne': ('betegne',),
'betegner': ('betegne',),
'betegnes': ('betegne',),
'betegnet': ('betegne',),
'betenk': ('betenke',),
'betenke': ('betenke',),
'betenker': ('betenke',),
'betenkes': ('betenke',),
'betenkt': ('betenke',),
'betenkte': ('betenke',),
'beting': ('betinge',),
'betinga': ('betinge',),
'betinge': ('betinge',),
'betinger': ('betinge',),
'betinges': ('betinge',),
'betinget': ('betinge',),
'betjen': ('betjene',),
'betjene': ('betjene',),
'betjener': ('betjene',),
'betjenes': ('betjene',),
'betjent': ('betjene',),
'betjente': ('betjene',),
'betl': ('betle',),
'betla': ('betle',),
'betle': ('betle',),
'betler': ('betle',),
'betles': ('betle',),
'betlet': ('betle',),
'beton': ('betone',),
'betona': ('betone',),
'betone': ('betone',),
'betoner': ('betone',),
'betones': ('betone',),
'betonet': ('betone',),
'betont': ('betone',),
'betonte': ('betone',),
'betrakt': ('betrakte',),
'betrakta': ('betrakte',),
'betrakte': ('betrakte',),
'betrakter': ('betrakte',),
'betraktes': ('betrakte',),
'betraktet': ('betrakte',),
'betre': ('betre',),
'betrer': ('betre',),
'betres': ('betre',),
'betrådt': ('betre',),
'betrådte': ('betre',),
'betred': ('betrede',),
'betrede': ('betrede',),
'betreder': ('betrede',),
'betredes': ('betrede',),
'betrådt': ('betrede',),
'betrådte': ('betrede',),
'betro': ('betro',),
'betrodd': ('betro',),
'betrodde': ('betro',),
'betror': ('betro',),
'betros': ('betro',),
'betvil': ('betvile',),
'betvile': ('betvile',),
'betviler': ('betvile',),
'betviles': ('betvile',),
'betvilt': ('betvile',),
'betvilte': ('betvile',),
'betvang': ('betvinge',),
'betving': ('betvinge',),
'betvinge': ('betvinge',),
'betvinger': ('betvinge',),
'betvinges': ('betvinge',),
'betvunget': ('betvinge',),
'bety': ('bety',),
'betydd': ('bety',),
'betydde': ('bety',),
'betyr': ('bety',),
'betys': ('bety',),
'betød': ('bety',),
'beundr': ('beundre',),
'beundra': ('beundre',),
'beundre': ('beundre',),
'beundrer': ('beundre',),
'beundres': ('beundre',),
'beundret': ('beundre',),
'bevar': ('bevare',),
'bevare': ('bevare',),
'bevarer': ('bevare',),
'bevares': ('bevare',),
'bevart': ('bevare',),
'bevarte': ('bevare',),
'bev': ('beve',),
'beva': ('beve',),
'bevd': ('beve',),
'bevde': ('beve',),
'beve': ('beve',),
'bever': ('beve',),
'beves': ('beve',),
'bevet': ('beve',),
'beveg': ('bevege',),
'bevega': ('bevege',),
'bevegd': ('bevege',),
'bevegde': ('bevege',),
'bevege': ('bevege',),
'beveger': ('bevege',),
'beveges': ('bevege',),
'beveget': ('bevege',),
'bevert': ('beverte',),
'beverta': ('beverte',),
'beverte': ('beverte',),
'beverter': ('beverte',),
'bevertes': ('beverte',),
'bevertet': ('beverte',),
'bevilg': ('bevilge',),
'bevilga': ('bevilge',),
'bevilge': ('bevilge',),
'bevilger': ('bevilge',),
'bevilges': ('bevilge',),
'bevilget': ('bevilge',),
'bevirk': ('bevirke',),
'bevirka': ('bevirke',),
'bevirke': ('bevirke',),
'bevirker': ('bevirke',),
'bevirkes': ('bevirke',),
'bevirket': ('bevirke',),
'bevis': ('bevise',),
'bevise': ('bevise',),
'beviser': ('bevise',),
'bevises': ('bevise',),
'bevist': ('bevise',),
'beviste': ('bevise',),
'bevisstgjorde': ('bevisstgjøre',),
'bevisstgjort': ('bevisstgjøre',),
'bevisstgjør': ('bevisstgjøre',),
'bevisstgjøre': ('bevisstgjøre',),
'bevisstgjøres': ('bevisstgjøre',),
'bevitn': ('bevitne',),
'bevitna': ('bevitne',),
'bevitne': ('bevitne',),
'bevitner': ('bevitne',),
'bevitnes': ('bevitne',),
'bevitnet': ('bevitne',),
'bevokt': ('bevokte',),
'bevokta': ('bevokte',),
'bevokte': ('bevokte',),
'bevokter': ('bevokte',),
'bevoktes': ('bevokte',),
'bevoktet': ('bevokte',),
'bevr': ('bevre',),
'bevra': ('bevre',),
'bevre': ('bevre',),
'bevrer': ('bevre',),
'bevres': ('bevre',),
'bevret': ('bevre',),
'bevæpn': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpne': ('bevæpne',),
'bevæpner': ('bevæpne',),
'bevæpnes': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'beånd': ('beånde',),
'beånda': ('beånde',),
'beånde': ('beånde',),
'beånder': ('beånde',),
'beåndes': ('beånde',),
'beåndet': ('beånde',),
'beær': ('beære',),
'beæra': ('beære',),
'beære': ('beære',),
'beærer': ('beære',),
'beæres': ('beære',),
'beæret': ('beære',),
'beær': ('beære',),
'beæra': ('beære',),
'beære': ('beære',),
'beærer': ('beære',),
'beæres': ('beære',),
'beæret': ('beære',),
'bibehold': ('bibeholde',),
'bibeholde': ('bibeholde',),
'bibeholder': ('bibeholde',),
'bibeholdes': ('bibeholde',),
'bibeholdt': ('bibeholde',),
'bibragt': ('bibringe',),
'bibragte': ('bibringe',),
'bibrakt': ('bibringe',),
'bibrakte': ('bibringe',),
'bibring': ('bibringe',),
'bibringe': ('bibringe',),
'bibringer': ('bibringe',),
'bibringes': ('bibringe',),
'bidra': ('bidra',),
'bidradd': ('bidra',),
'bidrar': ('bidra',),
'bidras': ('bidra',),
'bidratt': ('bidra',),
'bidro': ('bidra',),
'bidrog': ('bidra',),
'bi': ('bie',),
'bia': ('bie',),
'bidd': ('bie',),
'bidde': ('bie',),
'bie': ('bie',),
'bier': ('bie',),
'bies': ('bie',),
'biet': ('bie',),
'bifall': ('bifalle',),
'bifalle': ('bifalle',),
'bifaller': ('bifalle',),
'bifalles': ('bifalle',),
'bifalt': ('bifalle',),
'bikk': ('bikke',),
'bikka': ('bikke',),
'bikke': ('bikke',),
'bikker': ('bikke',),
'bikkes': ('bikke',),
'bikket': ('bikke',),
'bikt': ('bikte',),
'bikta': ('bikte',),
'bikte': ('bikte',),
'bikter': ('bikte',),
'biktes': ('bikte',),
'biktet': ('bikte',),
'bil': ('bile',),
'bile': ('bile',),
'biler': ('bile',),
'biles': ('bile',),
'bilt': ('bile',),
'bilte': ('bile',),
'bila': ('bilegge',),
'bilagt': ('bilegge',),
'bilegg': ('bilegge',),
'bilegge': ('bilegge',),
'bilegger': ('bilegge',),
'bilegges': ('bilegge',),
'billetter': ('billettere',),
'billettere': ('billettere',),
'billetterer': ('billettere',),
'billetteres': ('billettere',),
'billettert': ('billettere',),
'billetterte': ('billettere',),
'billig': ('billige',),
'billiga': ('billige',),
'billige': ('billige',),
'billiger': ('billige',),
'billiges': ('billige',),
'billiget': ('billige',),
'bandt': ('binde',),
'bind': ('binde',),
'binde': ('binde',),
'binder': ('binde',),
'bindes': ('binde',),
'bundet': ('binde',),
'bisatt': ('bisette',),
'bisatte': ('bisette',),
'bisett': ('bisette',),
'bisette': ('bisette',),
'bisetter': ('bisette',),
'bisettes': ('bisette',),
'bisto': ('bistå',),
'bistod': ('bistå',),
'bistå': ('bistå',),
'biståes': ('bistå',),
'bistår': ('bistå',),
'bistås': ('bistå',),
'bistått': ('bistå',),
'beit': ('bite',),
'bet': ('bite',),
'bit': ('bite',),
'bite': ('bite',),
'biter': ('bite',),
'bites': ('bite',),
'bitt': ('bite',),
'bivuakker': ('bivuakkere',),
'bivuakkere': ('bivuakkere',),
'bivuakkerer': ('bivuakkere',),
'bivuakkeres': ('bivuakkere',),
'bivuakkert': ('bivuakkere',),
'bivuakkerte': ('bivuakkere',),
'bivån': ('bivåne',),
'bivåna': ('bivåne',),
'bivåne': ('bivåne',),
'bivåner': ('bivåne',),
'bivånes': ('bivåne',),
'bivånet': ('bivåne',),
'bivånt': ('bivåne',),
'bivånte': ('bivåne',),
'bjeff': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffe': ('bjeffe',),
'bjeffer': ('bjeffe',),
'bjeffes': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bla': ('bla',),
'bladd': ('bla',),
'bladde': ('bla',),
'blar': ('bla',),
'blas': ('bla',),
'blaff': ('blaffe',),
'blaffa': ('blaffe',),
'blaffe': ('blaffe',),
'blaffer': ('blaffe',),
'blaffes': ('blaffe',),
'blaffet': ('blaffe',),
'blafr': ('blafre',),
'blafra': ('blafre',),
'blafre': ('blafre',),
'blafrer': ('blafre',),
'blafres': ('blafre',),
'blafret': ('blafre',),
'blakk': ('blakke',),
'blakka': ('blakke',),
'blakke': ('blakke',),
'blakker': ('blakke',),
'blakkes': ('blakke',),
'blakket': ('blakke',),
'blakn': ('blakne',),
'blakna': ('blakne',),
'blakne': ('blakne',),
'blakner': ('blakne',),
'blaknes': ('blakne',),
'blaknet': ('blakne',),
'blakr': ('blakre',),
'blakra': ('blakre',),
'blakre': ('blakre',),
'blakrer': ('blakre',),
'blakres': ('blakre',),
'blakret': ('blakre',),
'blamer': ('blamere',),
'blamere': ('blamere',),
'blamerer': ('blamere',),
'blameres': ('blamere',),
'blamert': ('blamere',),
'blamerte': ('blamere',),
'bland': ('blande',),
'blanda': ('blande',),
'blande': ('blande',),
'blander': ('blande',),
'blandes': ('blande',),
'blandet': ('blande',),
'blank': ('blanke',),
'blanka': ('blanke',),
'blanke': ('blanke',),
'blanker': ('blanke',),
'blankes': ('blanke',),
'blanket': ('blanke',),
'blankpuss': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpusse': ('blankpusse',),
'blankpusser': ('blankpusse',),
'blankpusses': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blanksleit': ('blankslite',),
'blankslet': ('blankslite',),
'blankslit': ('blankslite',),
'blankslite': ('blankslite',),
'blanksliter': ('blankslite',),
'blankslites': ('blankslite',),
'blankslitt': ('blankslite',),
'blasoner': ('blasonere',),
'blasonere': ('blasonere',),
'blasonerer': ('blasonere',),
'blasoneres': ('blasonere',),
'blasonert': ('blasonere',),
'blasonerte': ('blasonere',),
'blautgjorde': ('blautgjøre',),
'blautgjort': ('blautgjøre',),
'blautgjør': ('blautgjøre',),
'blautgjøre': ('blautgjøre',),
'blautgjøres': ('blautgjøre',),
'blautkok': ('blautkoke',),
'blautkoke': ('blautkoke',),
'blautkoker': ('blautkoke',),
'blautkokes': ('blautkoke',),
'blautkokt': ('blautkoke',),
'blautkokte': ('blautkoke',),
'bleig': ('bleige',),
'bleigd': ('bleige',),
'bleigde': ('bleige',),
'bleige': ('bleige',),
'bleiger': ('bleige',),
'bleiges': ('bleige',),
'bleik': ('bleike',),
'bleika': ('bleike',),
'bleike': ('bleike',),
'bleiker': ('bleike',),
'bleikes': ('bleike',),
'bleiket': ('bleike',),
'bleikt': ('bleike',),
'bleikte': ('bleike',),
'bleikn': ('bleikne',),
'bleikna': ('bleikne',),
'bleikne': ('bleikne',),
'bleikner': ('bleikne',),
'bleiknes': ('bleikne',),
'bleiknet': ('bleikne',),
'blek': ('bleke',),
'bleka': ('bleke',),
'bleke': ('bleke',),
'bleker': ('bleke',),
'blekes': ('bleke',),
'bleket': ('bleke',),
'blekt': ('bleke',),
'blekte': ('bleke',),
'blek': ('blekke',),
'blekka': ('blekke',),
'blekke': ('blekke',),
'blekker': ('blekke',),
'blekkes': ('blekke',),
'blekket': ('blekke',),
'blekk': ('blekke',),
'blekke': ('blekke',),
'blekker': ('blekke',),
'blekkes': ('blekke',),
'blekt': ('blekke',),
'blekte': ('blekke',),
'blekn': ('blekne',),
'blekna': ('blekne',),
'blekne': ('blekne',),
'blekner': ('blekne',),
'bleknes': ('blekne',),
'bleknet': ('blekne',),
'blend': ('blende',),
'blenda': ('blende',),
'blende': ('blende',),
'blender': ('blende',),
'blendes': ('blende',),
'blendet': ('blende',),
'ble': ('bli',),
'blei': ('bli',),
'bli': ('bli',),
'blir': ('bli',),
'blis': ('bli',),
'blitt': ('bli',),
'vart': ('bli',),
'bleiv': ('bli',),
'blev': ('bli',),
'bli': ('bli',),
'blir': ('bli',),
'blis': ('bli',),
'blitt': ('bli',),
'blidgjorde': ('blidgjøre',),
'blidgjort': ('blidgjøre',),
'blidgjør': ('blidgjøre',),
'blidgjøre': ('blidgjøre',),
'blidgjøres': ('blidgjøre',),
'blind': ('blinde',),
'blinda': ('blinde',),
'blinde': ('blinde',),
'blinder': ('blinde',),
'blindes': ('blinde',),
'blindet': ('blinde',),
'blings': ('blingse',),
'blingsa': ('blingse',),
'blingse': ('blingse',),
'blingser': ('blingse',),
'blingses': ('blingse',),
'blingset': ('blingse',),
'blink': ('blinke',),
'blinka': ('blinke',),
'blinke': ('blinke',),
'blinker': ('blinke',),
'blinkes': ('blinke',),
'blinket': ('blinke',),
'blink': ('blinke',),
'blinka': ('blinke',),
'blinke': ('blinke',),
'blinker': ('blinke',),
'blinkes': ('blinke',),
'blinket': ('blinke',),
'blits': ('blitse',),
'blitsa': ('blitse',),
'blitse': ('blitse',),
'blitser': ('blitse',),
'blitses': ('blitse',),
'blitset': ('blitse',),
'bleiv': ('blive',),
'blev': ('blive',),
'blitt': ('blive',),
'bliv': ('blive',),
'blive': ('blive',),
'bliver': ('blive',),
'blives': ('blive',),
'blogg': ('blogge',),
'blogga': ('blogge',),
'blogge': ('blogge',),
'blogger': ('blogge',),
'blogges': ('blogge',),
'blogget': ('blogge',),
'blokk': ('blokke',),
'blokka': ('blokke',),
'blokke': ('blokke',),
'blokker': ('blokke',),
'blokkes': ('blokke',),
'blokket': ('blokke',),
'blokker': ('blokkere',),
'blokkere': ('blokkere',),
'blokkerer': ('blokkere',),
'blokkeres': ('blokkere',),
'blokkert': ('blokkere',),
'blokkerte': ('blokkere',),
'blomstr': ('blomstre',),
'blomstra': ('blomstre',),
'blomstre': ('blomstre',),
'blomstrer': ('blomstre',),
'blomstres': ('blomstre',),
'blomstret': ('blomstre',),
'blot': ('blote',),
'blota': ('blote',),
'blote': ('blote',),
'bloter': ('blote',),
'blotes': ('blote',),
'blotet': ('blote',),
'blott': ('blotte',),
'blotta': ('blotte',),
'blotte': ('blotte',),
'blotter': ('blotte',),
'blottes': ('blotte',),
'blottet': ('blotte',),
'blottla': ('blottlegge',),
'blottlagt': ('blottlegge',),
'blottlegg': ('blottlegge',),
'blottlegge': ('blottlegge',),
'blottlegger': ('blottlegge',),
'blottlegges': ('blottlegge',),
'blottstill': ('blottstille',),
'blottstille': ('blottstille',),
'blottstiller': ('blottstille',),
'blottstilles': ('blottstille',),
'blottstilt': ('blottstille',),
'blottstilte': ('blottstille',),
'bluedes': ('blues',),
'blues': ('blues',),
'blund': ('blunde',),
'blunda': ('blunde',),
'blunde': ('blunde',),
'blunder': ('blunde',),
'blundes': ('blunde',),
'blundet': ('blunde',),
'blunk': ('blunke',),
'blunka': ('blunke',),
'blunke': ('blunke',),
'blunker': ('blunke',),
'blunkes': ('blunke',),
'blunket': ('blunke',),
'bluss': ('blusse',),
'blussa': ('blusse',),
'blusse': ('blusse',),
'blusser': ('blusse',),
'blusses': ('blusse',),
'blusset': ('blusse',),
'blygdes': ('blyges',),
'blyges': ('blyges',),
'blåhold': ('blåholde',),
'blåholde': ('blåholde',),
'blåholder': ('blåholde',),
'blåholdes': ('blåholde',),
'blåholdt': ('blåholde',),
'blån': ('blåne',),
'blåna': ('blåne',),
'blåne': ('blåne',),
'blåner': ('blåne',),
'blånes': ('blåne',),
'blånet': ('blåne',),
'blånt': ('blåne',),
'blånte': ('blåne',),
'blånekt': ('blånekte',),
'blånekta': ('blånekte',),
'blånekte': ('blånekte',),
'blånekter': ('blånekte',),
'blånektes': ('blånekte',),
'blånektet': ('blånekte',),
'blås': ('blåse',),
'blåse': ('blåse',),
'blåser': ('blåse',),
'blåses': ('blåse',),
'blåst': ('blåse',),
'blåste': ('blåse',),
'blær': ('blære',),
'blæra': ('blære',),
'blære': ('blære',),
'blærer': ('blære',),
'blæres': ('blære',),
'blæret': ('blære',),
'blø': ('blø',),
'blødd': ('blø',),
'blødde': ('blø',),
'blør': ('blø',),
'bløs': ('blø',),
'blød': ('bløde',),
'blødd': ('bløde',),
'blødde': ('bløde',),
'bløde': ('bløde',),
'bløder': ('bløde',),
'blødes': ('bløde',),
'bløff': ('bløffe',),
'bløffa': ('bløffe',),
'bløffe': ('bløffe',),
'bløffer': ('bløffe',),
'bløffes': ('bløffe',),
'bløffet': ('bløffe',),
'bløgg': ('bløgge',),
'bløgga': ('bløgge',),
'bløgge': ('bløgge',),
'bløgger': ('bløgge',),
'bløgges': ('bløgge',),
'bløgget': ('bløgge',),
'bløt': ('bløte',),
'bløte': ('bløte',),
'bløter': ('bløte',),
'bløtes': ('bløte',),
'bløtt': ('bløte',),
'bløtte': ('bløte',),
'bløtgjorde': ('bløtgjøre',),
'bløtgjort': ('bløtgjøre',),
'bløtgjør': ('bløtgjøre',),
'bløtgjøre': ('bløtgjøre',),
'bløtgjøres': ('bløtgjøre',),
'bløtkok': ('bløtkoke',),
'bløtkoke': ('bløtkoke',),
'bløtkoker': ('bløtkoke',),
'bløtkokes': ('bløtkoke',),
'bløtkokt': ('bløtkoke',),
'bløtkokte': ('bløtkoke',),
'bløtla': ('bløtlegge',),
'bløtlagt': ('bløtlegge',),
'bløtlegg': ('bløtlegge',),
'bløtlegge': ('bløtlegge',),
'bløtlegger': ('bløtlegge',),
'bløtlegges': ('bløtlegge',),
'bløtt': ('bløyte',),
'bløtte': ('bløyte',),
'bløyt': ('bløyte',),
'bløyte': ('bløyte',),
'bløyter': ('bløyte',),
'bløytes': ('bløyte',),
'bløytt': ('bløyte',),
'bløytte': ('bløyte',),
'bløytla': ('bløytlegge',),
'bløytlagt': ('bløytlegge',),
'bløytlegg': ('bløytlegge',),
'bløytlegge': ('bløytlegge',),
'bløytlegger': ('bløytlegge',),
'bløytlegges': ('bløytlegge',),
'bo': ('bo',),
'bodd': ('bo',),
'bodde': ('bo',),
'bor': ('bo',),
'bos': ('bo',),
'bobl': ('boble',),
'bobla': ('boble',),
'boble': ('boble',),
'bobler': ('boble',),
'bobles': ('boble',),
'boblet': ('boble',),
'bog': ('boge',),
'boga': ('boge',),
'boge': ('boge',),
'boger': ('boge',),
'boges': ('boge',),
'boget': ('boge',),
'bogn': ('bogne',),
'bogna': ('bogne',),
'bogne': ('bogne',),
'bogner': ('bogne',),
'bognes': ('bogne',),
'bognet': ('bogne',),
'boikott': ('boikotte',),
'boikotta': ('boikotte',),
'boikotte': ('boikotte',),
'boikotter': ('boikotte',),
'boikottes': ('boikotte',),
'boikottet': ('boikotte',),
'bokfør': ('bokføre',),
'bokføre': ('bokføre',),
'bokfører': ('bokføre',),
'bokføres': ('bokføre',),
'bokført': ('bokføre',),
'bokførte': ('bokføre',),
'bokn': ('bokne',),
'bokna': ('bokne',),
'bokne': ('bokne',),
'bokner': ('bokne',),
'boknes': ('bokne',),
'boknet': ('bokne',),
'boks': ('bokse',),
'boksa': ('bokse',),
'bokse': ('bokse',),
'bokser': ('bokse',),
'bokses': ('bokse',),
'bokset': ('bokse',),
'bokstaver': ('bokstavere',),
'bokstavere': ('bokstavere',),
'bokstaverer': ('bokstavere',),
'bokstaveres': ('bokstavere',),
'bokstavert': ('bokstavere',),
'bokstaverte': ('bokstavere',),
'bol': ('bole',),
'bola': ('bole',),
'bole': ('bole',),
'boler': ('bole',),
'boles': ('bole',),
'bolet': ('bole',),
'bolt': ('bole',),
'bolte': ('bole',),
'boln': ('bolne',),
'bolna': ('bolne',),
'bolne': ('bolne',),
'bolner': ('bolne',),
'bolnes': ('bolne',),
'bolnet': ('bolne',),
'bolt': ('bolte',),
'bolta': ('bolte',),
'bolte': ('bolte',),
'bolter': ('bolte',),
'boltes': ('bolte',),
'boltet': ('bolte',),
'boltr': ('boltre',),
'boltra': ('boltre',),
'boltre': ('boltre',),
'boltrer': ('boltre',),
'boltres': ('boltre',),
'boltret': ('boltre',),
'bombarder': ('bombardere',),
'bombardere': ('bombardere',),
'bombarderer': ('bombardere',),
'bombarderes': ('bombardere',),
'bombardert': ('bombardere',),
'bombarderte': ('bombardere',),
'bomb': ('bombe',),
'bomba': ('bombe',),
'bombe': ('bombe',),
'bomber': ('bombe',),
'bombes': ('bombe',),
'bombet': ('bombe',),
'bom': ('bomme',),
'bomma': ('bomme',),
'bomme': ('bomme',),
'bommer': ('bomme',),
'bommes': ('bomme',),
'bommet': ('bomme',),
'bom': ('bomme',),
'bomma': ('bomme',),
'bomme': ('bomme',),
'bommer': ('bomme',),
'bommes': ('bomme',),
'bommet': ('bomme',),
'bom': ('bomme',),
'bomma': ('bomme',),
'bomme': ('bomme',),
'bommer': ('bomme',),
'bommes': ('bomme',),
'bommet': ('bomme',),
'bon': ('bone',),
'bona': ('bone',),
'bone': ('bone',),
'boner': ('bone',),
'bones': ('bone',),
'bonet': ('bone',),
'bont': ('bone',),
'bonte': ('bone',),
'bong': ('bonge',),
'bonga': ('bonge',),
'bonge': ('bonge',),
'bonger': ('bonge',),
'bonges': ('bonge',),
'bonget': ('bonge',),
'boniter': ('bonitere',),
'bonitere': ('bonitere',),
'boniterer': ('bonitere',),
'boniteres': ('bonitere',),
'bonitert': ('bonitere',),
'boniterte': ('bonitere',),
'book': ('booke',),
'booka': ('booke',),
'booke': ('booke',),
'booker': ('booke',),
'bookes': ('booke',),
'booket': ('booke',),
'bord': ('borde',),
'borda': ('borde',),
'borde': ('borde',),
'border': ('borde',),
'bordes': ('borde',),
'bordet': ('borde',),
'bordkle': ('bordkle',),
'bordkledd': ('bordkle',),
'bordkledde': ('bordkle',),
'bordkler': ('bordkle',),
'bordkles': ('bordkle',),
'bor': ('bore',),
'bora': ('bore',),
'bore': ('bore',),
'borer': ('bore',),
'bores': ('bore',),
'boret': ('bore',),
'borg': ('borge',),
'borga': ('borge',),
'borge': ('borge',),
'borger': ('borge',),
'borges': ('borge',),
'borget': ('borge',),
'bortbygsl': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygsle': ('bortbygsle',),
'bortbygsler': ('bortbygsle',),
'bortbygsles': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortfest': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfeste': ('bortfeste',),
'bortfester': ('bortfeste',),
'bortfestes': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortforklar': ('bortforklare',),
'bortforklare': ('bortforklare',),
'bortforklarer': ('bortforklare',),
'bortforklares': ('bortforklare',),
'bortforklart': ('bortforklare',),
'bortforklarte': ('bortforklare',),
'bortfrakt': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfrakte': ('bortfrakte',),
'bortfrakter': ('bortfrakte',),
'bortfraktes': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfør': ('bortføre',),
'bortføre': ('bortføre',),
'bortfører': ('bortføre',),
'bortføres': ('bortføre',),
'bortført': ('bortføre',),
'bortførte': ('bortføre',),
'bortled': ('bortlede',),
'bortleda': ('bortlede',),
'bortlede': ('bortlede',),
'bortleder': ('bortlede',),
'bortledes': ('bortlede',),
'bortledet': ('bortlede',),
'bortse': ('bortse',),
'bortsees': ('bortse',),
'bortser': ('bortse',),
'bortses': ('bortse',),
'bortsett': ('bortse',),
'bortså': ('bortse',),
'bortsåg': ('bortse',),
'bortsatt': ('bortsette',),
'bortsatte': ('bortsette',),
'bortsett': ('bortsette',),
'bortsette': ('bortsette',),
'bortsetter': ('bortsette',),
'bortsettes': ('bortsette',),
'bortødsl': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødsle': ('bortødsle',),
'bortødsler': ('bortødsle',),
'bortødsles': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bosatt': ('bosette',),
'bosatte': ('bosette',),
'bosett': ('bosette',),
'bosette': ('bosette',),
'bosetter': ('bosette',),
'bosettes': ('bosette',),
'botaniser': ('botanisere',),
'botanisere': ('botanisere',),
'botaniserer': ('botanisere',),
'botaniseres': ('botanisere',),
'botanisert': ('botanisere',),
'botaniserte': ('botanisere',),
'botla': ('botlegge',),
'botlagt': ('botlegge',),
'botlegg': ('botlegge',),
'botlegge': ('botlegge',),
'botlegger': ('botlegge',),
'botlegges': ('botlegge',),
'botn': ('botne',),
'botna': ('botne',),
'botne': ('botne',),
'botner': ('botne',),
'botnes': ('botne',),
'botnet': ('botne',),
'botnfell': ('botnfelle',),
'botnfelle': ('botnfelle',),
'botnfeller': ('botnfelle',),
'botnfelles': ('botnfelle',),
'botnfelt': ('botnfelle',),
'botnfelte': ('botnfelle',),
'botnskrap': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrape': ('botnskrape',),
'botnskraper': ('botnskrape',),
'botnskrapes': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapt': ('botnskrape',),
'botnskrapte': ('botnskrape',),
'bowl': ('bowle',),
'bowla': ('bowle',),
'bowle': ('bowle',),
'bowler': ('bowle',),
'bowles': ('bowle',),
'bowlet': ('bowle',),
'brak': ('brake',),
'braka': ('brake',),
'brake': ('brake',),
'braker': ('brake',),
'brakes': ('brake',),
'braket': ('brake',),
'brakt': ('brake',),
'brakte': ('brake',),
'brakk': ('brakke',),
'brakka': ('brakke',),
'brakke': ('brakke',),
'brakker': ('brakke',),
'brakkes': ('brakke',),
'brakket': ('brakke',),
'bram': ('bramme',),
'bramma': ('bramme',),
'bramme': ('bramme',),
'brammer': ('bramme',),
'brammes': ('bramme',),
'brammet': ('bramme',),
'brask': ('braske',),
'braska': ('braske',),
'braske': ('braske',),
'brasker': ('braske',),
'braskes': ('braske',),
'brasket': ('braske',),
'bratn': ('bratne',),
'bratna': ('bratne',),
'bratne': ('bratne',),
'bratner': ('bratne',),
'bratnes': ('bratne',),
'bratnet': ('bratne',),
'braut': ('braute',),
'brauta': ('braute',),
'braute': ('braute',),
'brauter': ('braute',),
'brautes': ('braute',),
'brautet': ('braute',),
'braver': ('bravere',),
'bravere': ('bravere',),
'braverer': ('bravere',),
'braveres': ('bravere',),
'bravert': ('bravere',),
'braverte': ('bravere',),
'brei': ('breie',),
'breia': ('breie',),
'breid': ('breie',),
'breidd': ('breie',),
'breidde': ('breie',),
'breide': ('breie',),
'breie': ('breie',),
'breier': ('breie',),
'breies': ('breie',),
'breiet': ('breie',),
'brei': ('breie',),
'breia': ('breie',),
'breid': ('breie',),
'breidd': ('breie',),
'breidde': ('breie',),
'breide': ('breie',),
'breie': ('breie',),
'breier': ('breie',),
'breies': ('breie',),
'breiet': ('breie',),
'brek': ('breke',),
'breka': ('breke',),
'breke': ('breke',),
'breker': ('breke',),
'brekes': ('breke',),
'breket': ('breke',),
'brekt': ('breke',),
'brekte': ('breke',),
'brekk': ('brekke',),
'brekka': ('brekke',),
'brekke': ('brekke',),
'brekker': ('brekke',),
'brekkes': ('brekke',),
'brekket': ('brekke',),
'brekt': ('brekke',),
'brekte': ('brekke',),
'brakk': ('brekke',),
'brekk': ('brekke',),
'brekke': ('brekke',),
'brekker': ('brekke',),
'brekkes': ('brekke',),
'brukket': ('brekke',),
'brem': ('bremme',),
'bremma': ('bremme',),
'bremme': ('bremme',),
'bremmer': ('bremme',),
'bremmes': ('bremme',),
'bremmet': ('bremme',),
'brems': ('bremse',),
'bremsa': ('bremse',),
'bremse': ('bremse',),
'bremser': ('bremse',),
'bremses': ('bremse',),
'bremset': ('bremse',),
'brennemerk': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerke': ('brennemerke',),
'brennemerker': ('brennemerke',),
'brennemerkes': ('brennemerke',),
'brennemerket': ('brennemerke',),
'breser': ('bresere',),
'bresere': ('bresere',),
'breserer': ('bresere',),
'breseres': ('bresere',),
'bresert': ('bresere',),
'breserte': ('bresere',),
'brest': ('breste',),
'bresta': ('breste',),
'breste': ('breste',),
'brester': ('breste',),
'brestes': ('breste',),
'brestet': ('breste',),
'brast': ('breste',),
'brest': ('breste',),
'breste': ('breste',),
'brester': ('breste',),
'brestes': ('breste',),
'brestet': ('breste',),
'brast': ('breste',),
'brest': ('breste',),
'breste': ('breste',),
'brester': ('breste',),
'brestes': ('breste',),
'brestet': ('breste',),
'brett': ('brette',),
'bretta': ('brette',),
'brette': ('brette',),
'bretter': ('brette',),
'brettes': ('brette',),
'brettet': ('brette',),
'brettsegl': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettsegle': ('brettsegle',),
'brettsegler': ('brettsegle',),
'brettsegles': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettseil': ('brettseile',),
'brettseile': ('brettseile',),
'brettseiler': ('brettseile',),
'brettseiles': ('brettseile',),
'brettseilt': ('brettseile',),
'brettseilte': ('brettseile',),
'brevveksl': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevveksle': ('brevveksle',),
'brevveksler': ('brevveksle',),
'brevveksles': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brif': ('brife',),
'brifa': ('brife',),
'brife': ('brife',),
'brifer': ('brife',),
'brifes': ('brife',),
'brifet': ('brife',),
'briketter': ('brikettere',),
'brikettere': ('brikettere',),
'briketterer': ('brikettere',),
'briketteres': ('brikettere',),
'brikettert': ('brikettere',),
'briketterte': ('brikettere',),
'briljer': ('briljere',),
'briljere': ('briljere',),
'briljerer': ('briljere',),
'briljeres': ('briljere',),
'briljert': ('briljere',),
'briljerte': ('briljere',),
'bragt': ('bringe',),
'bragte': ('bringe',),
'brakt': ('bringe',),
'brakte': ('bringe',),
'bring': ('bringe',),
'bringe': ('bringe',),
'bringer': ('bringe',),
'bringes': ('bringe',),
'bris': ('brise',),
'brise': ('brise',),
'briser': ('brise',),
'brises': ('brise',),
'brist': ('brise',),
'briste': ('brise',),
'brisk': ('briske',),
'briska': ('briske',),
'briske': ('briske',),
'brisker': ('briske',),
'briskes': ('briske',),
'brisket': ('briske',),
'brast': ('briste',),
'brist': ('briste',),
'briste': ('briste',),
'brister': ('briste',),
'bristes': ('briste',),
'bristet': ('briste',),
'brustet': ('briste',),
'brast': ('briste',),
'brist': ('briste',),
'briste': ('briste',),
'brister': ('briste',),
'bristes': ('briste',),
'bristet': ('briste',),
'brustet': ('briste',),
'brodd': ('brodde',),
'brodda': ('brodde',),
'brodde': ('brodde',),
'brodder': ('brodde',),
'broddes': ('brodde',),
'broddet': ('brodde',),
'broder': ('brodere',),
'brodere': ('brodere',),
'broderer': ('brodere',),
'broderes': ('brodere',),
'brodert': ('brodere',),
'broderte': ('brodere',),
'brola': ('brolegge',),
'brolagt': ('brolegge',),
'brolegg': ('brolegge',),
'brolegge': ('brolegge',),
'brolegger': ('brolegge',),
'brolegges': ('brolegge',),
'brons': ('bronse',),
'bronsa': ('bronse',),
'bronse': ('bronse',),
'bronser': ('bronse',),
'bronses': ('bronse',),
'bronset': ('bronse',),
'bronser': ('bronsere',),
'bronsere': ('bronsere',),
'bronserer': ('bronsere',),
'bronseres': ('bronsere',),
'bronsert': ('bronsere',),
'bronserte': ('bronsere',),
'brosjer': ('brosjere',),
'brosjere': ('brosjere',),
'brosjerer': ('brosjere',),
'brosjeres': ('brosjere',),
'brosjert': ('brosjere',),
'brosjerte': ('brosjere',),
'brotn': ('brotne',),
'brotna': ('brotne',),
'brotne': ('brotne',),
'brotner': ('brotne',),
'brotnes': ('brotne',),
'brotnet': ('brotne',),
'brotsj': ('brotsje',),
'brotsja': ('brotsje',),
'brotsje': ('brotsje',),
'brotsjer': ('brotsje',),
'brotsjes': ('brotsje',),
'brotsjet': ('brotsje',),
'bruk': ('bruke',),
'bruke': ('bruke',),
'bruker': ('bruke',),
'brukes': ('bruke',),
'brukt': ('bruke',),
'brukte': ('bruke',),
'brula': ('brulegge',),
'brulagt': ('brulegge',),
'brulegg': ('brulegge',),
'brulegge': ('brulegge',),
'brulegger': ('brulegge',),
'brulegges': ('brulegge',),
'bruml': ('brumle',),
'brumla': ('brumle',),
'brumle': ('brumle',),
'brumler': ('brumle',),
'brumles': ('brumle',),
'brumlet': ('brumle',),
'brum': ('brumme',),
'brumma': ('brumme',),
'brumme': ('brumme',),
'brummer': ('brumme',),
'brummes': ('brumme',),
'brummet': ('brumme',),
'brun': ('brune',),
'bruna': ('brune',),
'brune': ('brune',),
'bruner': ('brune',),
'brunes': ('brune',),
'brunet': ('brune',),
'brunt': ('brune',),
'brunte': ('brune',),
'brunsteik': ('brunsteike',),
'brunsteike': ('brunsteike',),
'brunsteiker': ('brunsteike',),
'brunsteikes': ('brunsteike',),
'brunsteikt': ('brunsteike',),
'brunsteikte': ('brunsteike',),
'brunstek': ('brunsteke',),
'brunsteke': ('brunsteke',),
'brunsteker': ('brunsteke',),
'brunstekes': ('brunsteke',),
'brunstekt': ('brunsteke',),
'brunstekte': ('brunsteke',),
'brus': ('bruse',),
'bruse': ('bruse',),
'bruser': ('bruse',),
'bruses': ('bruse',),
'brust': ('bruse',),
'bruste': ('bruse',),
'brutaliser': ('brutalisere',),
'brutalisere': ('brutalisere',),
'brutaliserer': ('brutalisere',),
'brutaliseres': ('brutalisere',),
'brutalisert': ('brutalisere',),
'brutaliserte': ('brutalisere',),
'bry': ('bry',),
'brydd': ('bry',),
'brydde': ('bry',),
'bryr': ('bry',),
'brys': ('bry',),
'brød': ('bry',),
'brøy': ('bry',),
'brydd': ('brydde',),
'brydda': ('brydde',),
'brydde': ('brydde',),
'brydder': ('brydde',),
'bryddes': ('brydde',),
'bryddet': ('brydde',),
'brygd': ('brygge',),
'brygde': ('brygge',),
'brygg': ('brygge',),
'brygga': ('brygge',),
'brygge': ('brygge',),
'brygger': ('brygge',),
'brygges': ('brygge',),
'brygget': ('brygge',),
'bryn': ('bryne',),
'bryne': ('bryne',),
'bryner': ('bryne',),
'brynes': ('bryne',),
'brynt': ('bryne',),
'brynte': ('bryne',),
'brysk': ('bryske',),
'bryska': ('bryske',),
'bryske': ('bryske',),
'brysker': ('bryske',),
'bryskes': ('bryske',),
'brysket': ('bryske',),
'bryst': ('bryste',),
'brysta': ('bryste',),
'bryste': ('bryste',),
'bryster': ('bryste',),
'brystes': ('bryste',),
'brystet': ('bryste',),
'braut': ('bryte',),
'brutt': ('bryte',),
'bryt': ('bryte',),
'bryte': ('bryte',),
'bryter': ('bryte',),
'brytes': ('bryte',),
'brøt': ('bryte',),
'brøyt': ('bryte',),
'bråbrems': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremse': ('bråbremse',),
'bråbremser': ('bråbremse',),
'bråbremses': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråk': ('bråke',),
'bråka': ('bråke',),
'bråke': ('bråke',),
'bråker': ('bråke',),
'bråkes': ('bråke',),
'bråket': ('bråke',),
'bråkt': ('bråke',),
'bråkte': ('bråke',),
'bråk': ('bråke',),
'bråka': ('bråke',),
'bråke': ('bråke',),
'bråker': ('bråke',),
'bråkes': ('bråke',),
'bråket': ('bråke',),
'bråkt': ('bråke',),
'bråkte': ('bråke',),
'brån': ('bråne',),
'bråna': ('bråne',),
'bråne': ('bråne',),
'bråner': ('bråne',),
'brånes': ('bråne',),
'brånet': ('bråne',),
'brånt': ('bråne',),
'brånte': ('bråne',),
'brødfø': ('brødfø',),
'brødfødd': ('brødfø',),
'brødfødde': ('brødfø',),
'brødfør': ('brødfø',),
'brødføs': ('brødfø',),
'brøl': ('brøle',),
'brøle': ('brøle',),
'brøler': ('brøle',),
'brøles': ('brøle',),
'brølt': ('brøle',),
'brølte': ('brøle',),
'brøyt': ('brøyte',),
'brøyta': ('brøyte',),
'brøyte': ('brøyte',),
'brøyter': ('brøyte',),
'brøytes': ('brøyte',),
'brøytet': ('brøyte',),
'brøytt': ('brøyte',),
'brøytte': ('brøyte',),
'bu': ('bu',),
'budd': ('bu',),
'budde': ('bu',),
'bur': ('bu',),
'bus': ('bu',),
'bu': ('bu',),
'budd': ('bu',),
'budde': ('bu',),
'bur': ('bu',),
'bus': ('bu',),
'budsend': ('budsende',),
'budsende': ('budsende',),
'budsender': ('budsende',),
'budsendes': ('budsende',),
'budsendt': ('budsende',),
'budsendte': ('budsende',),
'budsjetter': ('budsjettere',),
'budsjettere': ('budsjettere',),
'budsjetterer': ('budsjettere',),
'budsjetteres': ('budsjettere',),
'budsjettert': ('budsjettere',),
'budsjetterte': ('budsjettere',),
'bu': ('bue',),
'bua': ('bue',),
'bue': ('bue',),
'buer': ('bue',),
'bues': ('bue',),
'buet': ('bue',),
'bugn': ('bugne',),
'bugna': ('bugne',),
'bugne': ('bugne',),
'bugner': ('bugne',),
'bugnes': ('bugne',),
'bugnet': ('bugne',),
'bukk': ('bukke',),
'bukka': ('bukke',),
'bukke': ('bukke',),
'bukker': ('bukke',),
'bukkes': ('bukke',),
'bukket': ('bukke',),
'bukk': ('bukke',),
'bukka': ('bukke',),
'bukke': ('bukke',),
'bukker': ('bukke',),
'bukkes': ('bukke',),
'bukket': ('bukke',),
'bukland': ('buklande',),
'buklanda': ('buklande',),
'buklande': ('buklande',),
'buklander': ('buklande',),
'buklandes': ('buklande',),
'buklandet': ('buklande',),
'bukser': ('buksere',),
'buksere': ('buksere',),
'bukserer': ('buksere',),
'bukseres': ('buksere',),
'buksert': ('buksere',),
'bukserte': ('buksere',),
'bukt': ('bukte',),
'bukta': ('bukte',),
'bukte': ('bukte',),
'bukter': ('bukte',),
'buktes': ('bukte',),
'buktet': ('bukte',),
'buldr': ('buldre',),
'buldra': ('buldre',),
'buldre': ('buldre',),
'buldrer': ('buldre',),
'buldres': ('buldre',),
'buldret': ('buldre',),
'bul': ('bule',),
'bula': ('bule',),
'bule': ('bule',),
'buler': ('bule',),
'bules': ('bule',),
'bulet': ('bule',),
'bult': ('bule',),
'bulte': ('bule',),
'bulk': ('bulke',),
'bulka': ('bulke',),
'bulke': ('bulke',),
'bulker': ('bulke',),
'bulkes': ('bulke',),
'bulket': ('bulke',),
'buln': ('bulne',),
'bulna': ('bulne',),
'bulne': ('bulne',),
'bulner': ('bulne',),
'bulnes': ('bulne',),
'bulnet': ('bulne',),
'bums': ('bumse',),
'bumsa': ('bumse',),
'bumse': ('bumse',),
'bumser': ('bumse',),
'bumses': ('bumse',),
'bumset': ('bumse',),
'bunk': ('bunke',),
'bunka': ('bunke',),
'bunke': ('bunke',),
'bunker': ('bunke',),
'bunkes': ('bunke',),
'bunket': ('bunke',),
'bunkr': ('bunkre',),
'bunkra': ('bunkre',),
'bunkre': ('bunkre',),
'bunkrer': ('bunkre',),
'bunkres': ('bunkre',),
'bunkret': ('bunkre',),
'bunnfell': ('bunnfelle',),
'bunnfelle': ('bunnfelle',),
'bunnfeller': ('bunnfelle',),
'bunnfelles': ('bunnfelle',),
'bunnfelt': ('bunnfelle',),
'bunnfelte': ('bunnfelle',),
'bunnskrap': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrape': ('bunnskrape',),
'bunnskraper': ('bunnskrape',),
'bunnskrapes': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapt': ('bunnskrape',),
'bunnskrapte': ('bunnskrape',),
'bunt': ('bunte',),
'bunta': ('bunte',),
'bunte': ('bunte',),
'bunter': ('bunte',),
'buntes': ('bunte',),
'buntet': ('bunte',),
'burde': ('burde',),
'burdet': ('burde',),
'bør': ('burde',),
'bur': ('bure',),
'bura': ('bure',),
'bure': ('bure',),
'burer': ('bure',),
'bures': ('bure',),
'buret': ('bure',),
'burt': ('bure',),
'burte': ('bure',),
'bur': ('bure',),
'bura': ('bure',),
'bure': ('bure',),
'burer': ('bure',),
'bures': ('bure',),
'buret': ('bure',),
'burt': ('bure',),
'burte': ('bure',),
'bus': ('buse',),
'busa': ('buse',),
'buse': ('buse',),
'buser': ('buse',),
'buses': ('buse',),
'buset': ('buse',),
'bust': ('buse',),
'buste': ('buse',),
'busatt': ('busette',),
'busatte': ('busette',),
'busett': ('busette',),
'busette': ('busette',),
'busetter': ('busette',),
'busettes': ('busette',),
'busk': ('buske',),
'buska': ('buske',),
'buske': ('buske',),
'busker': ('buske',),
'buskes': ('buske',),
'busket': ('buske',),
'buss': ('busse',),
'bussa': ('busse',),
'busse': ('busse',),
'busser': ('busse',),
'busses': ('busse',),
'busset': ('busse',),
'bust': ('buste',),
'busta': ('buste',),
'buste': ('buste',),
'buster': ('buste',),
'bustes': ('buste',),
'bustet': ('buste',),
'butt': ('butte',),
'butta': ('butte',),
'butte': ('butte',),
'butter': ('butte',),
'buttes': ('butte',),
'buttet': ('butte',),
'baud': ('by',),
'budt': ('by',),
'by': ('by',),
'bydd': ('by',),
'bydde': ('by',),
'byr': ('by',),
'bys': ('by',),
'bød': ('by',),
'bøy': ('by',),
'baud': ('by',),
'budt': ('by',),
'by': ('by',),
'bydd': ('by',),
'bydde': ('by',),
'byr': ('by',),
'bys': ('by',),
'bød': ('by',),
'bøy': ('by',),
'baud': ('byde',),
'budt': ('byde',),
'byd': ('byde',),
'bydd': ('byde',),
'bydde': ('byde',),
'byde': ('byde',),
'byder': ('byde',),
'bydes': ('byde',),
'bød': ('byde',),
'bygd': ('bygge',),
'bygde': ('bygge',),
'bygg': ('bygge',),
'bygga': ('bygge',),
'bygge': ('bygge',),
'bygger': ('bygge',),
'bygges': ('bygge',),
'bygget': ('bygge',),
'bygsl': ('bygsle',),
'bygsla': ('bygsle',),
'bygsle': ('bygsle',),
'bygsler': ('bygsle',),
'bygsles': ('bygsle',),
'bygslet': ('bygsle',),
'byks': ('bykse',),
'bykse': ('bykse',),
'bykser': ('bykse',),
'bykses': ('bykse',),
'bykst': ('bykse',),
'bykste': ('bykse',),
'bylt': ('bylte',),
'bylta': ('bylte',),
'bylte': ('bylte',),
'bylter': ('bylte',),
'byltes': ('bylte',),
'byltet': ('bylte',),
'byråkratiser': ('byråkratisere',),
'byråkratisere': ('byråkratisere',),
'byråkratiserer': ('byråkratisere',),
'byråkratiseres': ('byråkratisere',),
'byråkratisert': ('byråkratisere',),
'byråkratiserte': ('byråkratisere',),
'byss': ('bysse',),
'byssa': ('bysse',),
'bysse': ('bysse',),
'bysser': ('bysse',),
'bysses': ('bysse',),
'bysset': ('bysse',),
'bytt': ('bytte',),
'bytta': ('bytte',),
'bytte': ('bytte',),
'bytter': ('bytte',),
'byttes': ('bytte',),
'byttet': ('bytte',),
'byttelån': ('byttelåne',),
'byttelåne': ('byttelåne',),
'byttelåner': ('byttelåne',),
'byttelånes': ('byttelåne',),
'byttelånt': ('byttelåne',),
'byttelånte': ('byttelåne',),
'båndla': ('båndlegge',),
'båndlagt': ('båndlegge',),
'båndlegg': ('båndlegge',),
'båndlegge': ('båndlegge',),
'båndlegger': ('båndlegge',),
'båndlegges': ('båndlegge',),
'bår': ('båre',),
'båra': ('båre',),
'båre': ('båre',),
'bårer': ('båre',),
'båres': ('båre',),
'båret': ('båre',),
'bæsj': ('bæsje',),
'bæsja': ('bæsje',),
'bæsje': ('bæsje',),
'bæsjer': ('bæsje',),
'bæsjes': ('bæsje',),
'bæsjet': ('bæsje',),
'bølg': ('bølge',),
'bølga': ('bølge',),
'bølge': ('bølge',),
'bølger': ('bølge',),
'bølges': ('bølge',),
'bølget': ('bølge',),
'bølg': ('bølgje',),
'bølgja': ('bølgje',),
'bølgje': ('bølgje',),
'bølgjer': ('bølgje',),
'bølgjes': ('bølgje',),
'bølgjet': ('bølgje',),
'bønnfall': ('bønnfalle',),
'bønnfalle': ('bønnfalle',),
'bønnfaller': ('bønnfalle',),
'bønnfalles': ('bønnfalle',),
'bønnfalt': ('bønnfalle',),
'bønnhør': ('bønnhøre',),
'bønnhøre': ('bønnhøre',),
'bønnhører': ('bønnhøre',),
'bønnhøres': ('bønnhøre',),
'bønnhørt': ('bønnhøre',),
'bønnhørte': ('bønnhøre',),
'børs': ('børse',),
'børsa': ('børse',),
'børse': ('børse',),
'børser': ('børse',),
'børses': ('børse',),
'børset': ('børse',),
'børsnoter': ('børsnotere',),
'børsnotere': ('børsnotere',),
'børsnoterer': ('børsnotere',),
'børsnoteres': ('børsnotere',),
'børsnotert': ('børsnotere',),
'børsnoterte': ('børsnotere',),
'børst': ('børste',),
'børsta': ('børste',),
'børste': ('børste',),
'børster': ('børste',),
'børstes': ('børste',),
'børstet': ('børste',),
'bøt': ('bøte',),
'bøte': ('bøte',),
'bøter': ('bøte',),
'bøtes': ('bøte',),
'bøtt': ('bøte',),
'bøtte': ('bøte',),
'bøtela': ('bøtelegge',),
'bøtelagt': ('bøtelegge',),
'bøtelegg': ('bøtelegge',),
'bøtelegge': ('bøtelegge',),
'bøtelegger': ('bøtelegge',),
'bøtelegges': ('bøtelegge',),
'bøy': ('bøye',),
'bøya': ('bøye',),
'bøyd': ('bøye',),
'bøyde': ('bøye',),
'bøye': ('bøye',),
'bøyer': ('bøye',),
'bøyes': ('bøye',),
'bøyet': ('bøye',),
'camp': ('campe',),
'campa': ('campe',),
'campe': ('campe',),
'camper': ('campe',),
'campes': ('campe',),
'campet': ('campe',),
'cash': ('cashe',),
'casha': ('cashe',),
'cashe': ('cashe',),
'casher': ('cashe',),
'cashes': ('cashe',),
'cashet': ('cashe',),
'celebrer': ('celebrere',),
'celebrere': ('celebrere',),
'celebrerer': ('celebrere',),
'celebreres': ('celebrere',),
'celebrert': ('celebrere',),
'celebrerte': ('celebrere',),
'changer': ('changere',),
'changere': ('changere',),
'changerer': ('changere',),
'changeres': ('changere',),
'changert': ('changere',),
'changerte': ('changere',),
'chartr': ('chartre',),
'chartra': ('chartre',),
'chartre': ('chartre',),
'chartrer': ('chartre',),
'chartres': ('chartre',),
'chartret': ('chartre',),
'chevroter': ('chevrotere',),
'chevrotere': ('chevrotere',),
'chevroterer': ('chevrotere',),
'chevroteres': ('chevrotere',),
'chevrotert': ('chevrotere',),
'chevroterte': ('chevrotere',),
'chiffrer': ('chiffrere',),
'chiffrere': ('chiffrere',),
'chiffrerer': ('chiffrere',),
'chiffreres': ('chiffrere',),
'chiffrert': ('chiffrere',),
'chiffrerte': ('chiffrere',),
'chok': ('choke',),
'choka': ('choke',),
'choke': ('choke',),
'choker': ('choke',),
'chokes': ('choke',),
'choket': ('choke',),
'clinch': ('clinche',),
'clincha': ('clinche',),
'clinche': ('clinche',),
'clincher': ('clinche',),
'clinches': ('clinche',),
'clinchet': ('clinche',),
'clutch': ('clutche',),
'clutcha': ('clutche',),
'clutche': ('clutche',),
'clutcher': ('clutche',),
'clutches': ('clutche',),
'clutchet': ('clutche',),
'cruis': ('cruise',),
'cruisa': ('cruise',),
'cruise': ('cruise',),
'cruiser': ('cruise',),
'cruises': ('cruise',),
'cruiset': ('cruise',),
'cyanidiser': ('cyanidisere',),
'cyanidisere': ('cyanidisere',),
'cyanidiserer': ('cyanidisere',),
'cyanidiseres': ('cyanidisere',),
'cyanidisert': ('cyanidisere',),
'cyanidiserte': ('cyanidisere',),
'dabb': ('dabbe',),
'dabba': ('dabbe',),
'dabbe': ('dabbe',),
'dabber': ('dabbe',),
'dabbes': ('dabbe',),
'dabbet': ('dabbe',),
'dadl': ('dadle',),
'dadla': ('dadle',),
'dadle': ('dadle',),
'dadler': ('dadle',),
'dadles': ('dadle',),
'dadlet': ('dadle',),
'daff': ('daffe',),
'daffa': ('daffe',),
'daffe': ('daffe',),
'daffer': ('daffe',),
'daffes': ('daffe',),
'daffet': ('daffe',),
'dagdrøm': ('dagdrømme',),
'dagdrømme': ('dagdrømme',),
'dagdrømmer': ('dagdrømme',),
'dagdrømmes': ('dagdrømme',),
'dagdrømt': ('dagdrømme',),
'dagdrømte': ('dagdrømme',),
'dag': ('dage',),
'daga': ('dage',),
'dage': ('dage',),
'dager': ('dage',),
'dages': ('dage',),
'daget': ('dage',),
'dagedes': ('dages',),
'dages': ('dages',),
'dal': ('dale',),
'dale': ('dale',),
'daler': ('dale',),
'dales': ('dale',),
'dalt': ('dale',),
'dalte': ('dale',),
'dalk': ('dalke',),
'dalka': ('dalke',),
'dalke': ('dalke',),
'dalker': ('dalke',),
'dalkes': ('dalke',),
'dalket': ('dalke',),
'dalt': ('dalte',),
'dalta': ('dalte',),
'dalte': ('dalte',),
'dalter': ('dalte',),
'daltes': ('dalte',),
'daltet': ('dalte',),
'damascer': ('damascere',),
'damascere': ('damascere',),
'damascerer': ('damascere',),
'damasceres': ('damascere',),
'damascert': ('damascere',),
'damascerte': ('damascere',),
'damp': ('dampe',),
'dampa': ('dampe',),
'dampe': ('dampe',),
'damper': ('dampe',),
'dampes': ('dampe',),
'dampet': ('dampe',),
'dampkok': ('dampkoke',),
'dampkoke': ('dampkoke',),
'dampkoker': ('dampkoke',),
'dampkokes': ('dampkoke',),
'dampkokt': ('dampkoke',),
'dampkokte': ('dampkoke',),
'dander': ('dandere',),
'dandere': ('dandere',),
'danderer': ('dandere',),
'danderes': ('dandere',),
'dandert': ('dandere',),
'danderte': ('dandere',),
'dangl': ('dangle',),
'dangla': ('dangle',),
'dangle': ('dangle',),
'dangler': ('dangle',),
'dangles': ('dangle',),
'danglet': ('dangle',),
'dank': ('danke',),
'danka': ('danke',),
'danke': ('danke',),
'danker': ('danke',),
'dankes': ('danke',),
'danket': ('danke',),
'dann': ('danne',),
'danna': ('danne',),
'danne': ('danne',),
'danner': ('danne',),
'dannes': ('danne',),
'dannet': ('danne',),
'dans': ('danse',),
'dansa': ('danse',),
'danse': ('danse',),
'danser': ('danse',),
'danses': ('danse',),
'danset': ('danse',),
'dansk': ('danske',),
'danska': ('danske',),
'danske': ('danske',),
'dansker': ('danske',),
'danskes': ('danske',),
'dansket': ('danske',),
'darr': ('darre',),
'darra': ('darre',),
'darre': ('darre',),
'darrer': ('darre',),
'darres': ('darre',),
'darret': ('darre',),
'dask': ('daske',),
'daska': ('daske',),
'daske': ('daske',),
'dasker': ('daske',),
'daskes': ('daske',),
'dasket': ('daske',),
'databehandl': ('databehandle',),
'databehandla': ('databehandle',),
'databehandle': ('databehandle',),
'databehandler': ('databehandle',),
'databehandles': ('databehandle',),
'databehandlet': ('databehandle',),
'datafør': ('dataføre',),
'dataføre': ('dataføre',),
'datafører': ('dataføre',),
'dataføres': ('dataføre',),
'dataført': ('dataføre',),
'dataførte': ('dataføre',),
'datastyr': ('datastyre',),
'datastyre': ('datastyre',),
'datastyrer': ('datastyre',),
'datastyres': ('datastyre',),
'datastyrt': ('datastyre',),
'datastyrte': ('datastyre',),
'dater': ('datere',),
'datere': ('datere',),
'daterer': ('datere',),
'dateres': ('datere',),
'datert': ('datere',),
'daterte': ('datere',),
'datostempl': ('datostemple',),
'datostempla': ('datostemple',),
'datostemple': ('datostemple',),
'datostempler': ('datostemple',),
'datostemples': ('datostemple',),
'datostemplet': ('datostemple',),
'daud': ('daude',),
'dauda': ('daude',),
'daude': ('daude',),
'dauder': ('daude',),
'daudes': ('daude',),
'daudet': ('daude',),
'daugjødsl': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødsle': ('daugjødsle',),
'daugjødsler': ('daugjødsle',),
'daugjødsles': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'dauhogd': ('dauhogge',),
'dauhogde': ('dauhogge',),
'dauhogg': ('dauhogge',),
'dauhogge': ('dauhogge',),
'dauhogger': ('dauhogge',),
'dauhogges': ('dauhogge',),
'dauhogget': ('dauhogge',),
'dauhugd': ('dauhugge',),
'dauhugde': ('dauhugge',),
'dauhugg': ('dauhugge',),
'dauhugga': ('dauhugge',),
'dauhugge': ('dauhugge',),
'dauhugger': ('dauhugge',),
'dauhugges': ('dauhugge',),
'dauhugget': ('dauhugge',),
'daukjør': ('daukjøre',),
'daukjøre': ('daukjøre',),
'daukjører': ('daukjøre',),
'daukjøres': ('daukjøre',),
'daukjørt': ('daukjøre',),
'daukjørte': ('daukjøre',),
'debatter': ('debattere',),
'debattere': ('debattere',),
'debatterer': ('debattere',),
'debatteres': ('debattere',),
'debattert': ('debattere',),
'debatterte': ('debattere',),
'debiter': ('debitere',),
'debitere': ('debitere',),
'debiterer': ('debitere',),
'debiteres': ('debitere',),
'debitert': ('debitere',),
'debiterte': ('debitere',),
'debuter': ('debutere',),
'debutere': ('debutere',),
'debuterer': ('debutere',),
'debuteres': ('debutere',),
'debutert': ('debutere',),
'debuterte': ('debutere',),
'dechiffrer': ('dechiffrere',),
'dechiffrere': ('dechiffrere',),
'dechiffrerer': ('dechiffrere',),
'dechiffreres': ('dechiffrere',),
'dechiffrert': ('dechiffrere',),
'dechiffrerte': ('dechiffrere',),
'dediser': ('dedisere',),
'dedisere': ('dedisere',),
'dediserer': ('dedisere',),
'dediseres': ('dedisere',),
'dedisert': ('dedisere',),
'dediserte': ('dedisere',),
'deduser': ('dedusere',),
'dedusere': ('dedusere',),
'deduserer': ('dedusere',),
'deduseres': ('dedusere',),
'dedusert': ('dedusere',),
'deduserte': ('dedusere',),
'defiler': ('defilere',),
'defilere': ('defilere',),
'defilerer': ('defilere',),
'defileres': ('defilere',),
'defilert': ('defilere',),
'defilerte': ('defilere',),
'definer': ('definere',),
'definere': ('definere',),
'definerer': ('definere',),
'defineres': ('definere',),
'definert': ('definere',),
'definerte': ('definere',),
'deflater': ('deflatere',),
'deflatere': ('deflatere',),
'deflaterer': ('deflatere',),
'deflateres': ('deflatere',),
'deflatert': ('deflatere',),
'deflaterte': ('deflatere',),
'deflorer': ('deflorere',),
'deflorere': ('deflorere',),
'deflorerer': ('deflorere',),
'defloreres': ('deflorere',),
'deflorert': ('deflorere',),
'deflorerte': ('deflorere',),
'deformer': ('deformere',),
'deformere': ('deformere',),
'deformerer': ('deformere',),
'deformeres': ('deformere',),
'deformert': ('deformere',),
'deformerte': ('deformere',),
'degenerer': ('degenerere',),
'degenerere': ('degenerere',),
'degenererer': ('degenerere',),
'degenereres': ('degenerere',),
'degenerert': ('degenerere',),
'degenererte': ('degenerere',),
'degg': ('degge',),
'degga': ('degge',),
'degge': ('degge',),
'degger': ('degge',),
'degges': ('degge',),
'degget': ('degge',),
'degrader': ('degradere',),
'degradere': ('degradere',),
'degraderer': ('degradere',),
'degraderes': ('degradere',),
'degradert': ('degradere',),
'degraderte': ('degradere',),
'dehydrer': ('dehydrere',),
'dehydrere': ('dehydrere',),
'dehydrerer': ('dehydrere',),
'dehydreres': ('dehydrere',),
'dehydrert': ('dehydrere',),
'dehydrerte': ('dehydrere',),
'deis': ('deise',),
'deisa': ('deise',),
'deise': ('deise',),
'deiser': ('deise',),
'deises': ('deise',),
'deiset': ('deise',),
'deist': ('deise',),
'deiste': ('deise',),
'dekanter': ('dekantere',),
'dekantere': ('dekantere',),
'dekanterer': ('dekantere',),
'dekanteres': ('dekantere',),
'dekantert': ('dekantere',),
'dekanterte': ('dekantere',),
'dekater': ('dekatere',),
'dekatere': ('dekatere',),
'dekaterer': ('dekatere',),
'dekateres': ('dekatere',),
'dekatert': ('dekatere',),
'dekaterte': ('dekatere',),
'dekk': ('dekke',),
'dekka': ('dekke',),
'dekke': ('dekke',),
'dekker': ('dekke',),
'dekkes': ('dekke',),
'dekket': ('dekke',),
'dekt': ('dekke',),
'dekte': ('dekke',),
'deklamer': ('deklamere',),
'deklamere': ('deklamere',),
'deklamerer': ('deklamere',),
'deklameres': ('deklamere',),
'deklamert': ('deklamere',),
'deklamerte': ('deklamere',),
'deklarer': ('deklarere',),
'deklarere': ('deklarere',),
'deklarerer': ('deklarere',),
'deklareres': ('deklarere',),
'deklarert': ('deklarere',),
'deklarerte': ('deklarere',),
'deklasser': ('deklassere',),
'deklassere': ('deklassere',),
'deklasserer': ('deklassere',),
'deklasseres': ('deklassere',),
'deklassert': ('deklassere',),
'deklasserte': ('deklassere',),
'dekliner': ('deklinere',),
'deklinere': ('deklinere',),
'deklinerer': ('deklinere',),
'deklineres': ('deklinere',),
'deklinert': ('deklinere',),
'deklinerte': ('deklinere',),
'dekod': ('dekode',),
'dekoda': ('dekode',),
'dekode': ('dekode',),
'dekoder': ('dekode',),
'dekodes': ('dekode',),
'dekodet': ('dekode',),
'dekomponer': ('dekomponere',),
'dekomponere': ('dekomponere',),
'dekomponerer': ('dekomponere',),
'dekomponeres': ('dekomponere',),
'dekomponert': ('dekomponere',),
'dekomponerte': ('dekomponere',),
'dekorer': ('dekorere',),
'dekorere': ('dekorere',),
'dekorerer': ('dekorere',),
'dekoreres': ('dekorere',),
'dekorert': ('dekorere',),
'dekorerte': ('dekorere',),
'dekorter': ('dekortere',),
'dekortere': ('dekortere',),
'dekorterer': ('dekortere',),
'dekorteres': ('dekortere',),
'dekortert': ('dekortere',),
'dekorterte': ('dekortere',),
'dekreter': ('dekretere',),
'dekretere': ('dekretere',),
'dekreterer': ('dekretere',),
'dekreteres': ('dekretere',),
'dekretert': ('dekretere',),
'dekreterte': ('dekretere',),
'dekuper': ('dekupere',),
'dekupere': ('dekupere',),
'dekuperer': ('dekupere',),
'dekuperes': ('dekupere',),
'dekupert': ('dekupere',),
'dekuperte': ('dekupere',),
'delabialiser': ('delabialisere',),
'delabialisere': ('delabialisere',),
'delabialiserer': ('delabialisere',),
'delabialiseres': ('delabialisere',),
'delabialisert': ('delabialisere',),
'delabialiserte': ('delabialisere',),
'del': ('dele',),
'dele': ('dele',),
'deler': ('dele',),
'deles': ('dele',),
'delt': ('dele',),
'delte': ('dele',),
'deleger': ('delegere',),
'delegere': ('delegere',),
'delegerer': ('delegere',),
'delegeres': ('delegere',),
'delegert': ('delegere',),
'delegerte': ('delegere',),
'deler': ('delere',),
'delere': ('delere',),
'delerer': ('delere',),
'deleres': ('delere',),
'delert': ('delere',),
'delerte': ('delere',),
'delikater': ('delikatere',),
'delikatere': ('delikatere',),
'delikaterer': ('delikatere',),
'delikateres': ('delikatere',),
'delikatert': ('delikatere',),
'delikaterte': ('delikatere',),
'delirer': ('delirere',),
'delirere': ('delirere',),
'delirerer': ('delirere',),
'delireres': ('delirere',),
'delirert': ('delirere',),
'delirerte': ('delirere',),
'delj': ('delje',),
'delja': ('delje',),
'delje': ('delje',),
'deljer': ('delje',),
'deljes': ('delje',),
'deljet': ('delje',),
'delta': ('delta',),
'deltaes': ('delta',),
'deltar': ('delta',),
'deltas': ('delta',),
'deltatt': ('delta',),
'deltok': ('delta',),
'demasker': ('demaskere',),
'demaskere': ('demaskere',),
'demaskerer': ('demaskere',),
'demaskeres': ('demaskere',),
'demaskert': ('demaskere',),
'demaskerte': ('demaskere',),
'dementer': ('dementere',),
'dementere': ('dementere',),
'dementerer': ('dementere',),
'dementeres': ('dementere',),
'dementert': ('dementere',),
'dementerte': ('dementere',),
'demilitariser': ('demilitarisere',),
'demilitarisere': ('demilitarisere',),
'demilitariserer': ('demilitarisere',),
'demilitariseres': ('demilitarisere',),
'demilitarisert': ('demilitarisere',),
'demilitariserte': ('demilitarisere',),
'demisjoner': ('demisjonere',),
'demisjonere': ('demisjonere',),
'demisjonerer': ('demisjonere',),
'demisjoneres': ('demisjonere',),
'demisjonert': ('demisjonere',),
'demisjonerte': ('demisjonere',),
'dem': ('demme',),
'demm': ('demme',),
'demma': ('demme',),
'demme': ('demme',),
'demmer': ('demme',),
'demmes': ('demme',),
'demmet': ('demme',),
'demt': ('demme',),
'demte': ('demme',),
'demobiliser': ('demobilisere',),
'demobilisere': ('demobilisere',),
'demobiliserer': ('demobilisere',),
'demobiliseres': ('demobilisere',),
'demobilisert': ('demobilisere',),
'demobiliserte': ('demobilisere',),
'demokratiser': ('demokratisere',),
'demokratisere': ('demokratisere',),
'demokratiserer': ('demokratisere',),
'demokratiseres': ('demokratisere',),
'demokratisert': ('demokratisere',),
'demokratiserte': ('demokratisere',),
'demoler': ('demolere',),
'demolere': ('demolere',),
'demolerer': ('demolere',),
'demoleres': ('demolere',),
'demolert': ('demolere',),
'demolerte': ('demolere',),
'demonstrer': ('demonstrere',),
'demonstrere': ('demonstrere',),
'demonstrerer': ('demonstrere',),
'demonstreres': ('demonstrere',),
'demonstrert': ('demonstrere',),
'demonstrerte': ('demonstrere',),
'demonter': ('demontere',),
'demontere': ('demontere',),
'demonterer': ('demontere',),
'demonteres': ('demontere',),
'demontert': ('demontere',),
'demonterte': ('demontere',),
'demoraliser': ('demoralisere',),
'demoralisere': ('demoralisere',),
'demoraliserer': ('demoralisere',),
'demoraliseres': ('demoralisere',),
'demoralisert': ('demoralisere',),
'demoraliserte': ('demoralisere',),
'demp': ('dempe',),
'dempa': ('dempe',),
'dempe': ('dempe',),
'demper': ('dempe',),
'dempes': ('dempe',),
'dempet': ('dempe',),
'demr': ('demre',),
'demra': ('demre',),
'demre': ('demre',),
'demrer': ('demre',),
'demres': ('demre',),
'demret': ('demre',),
'denasjonaliser': ('denasjonalisere',),
'denasjonalisere': ('denasjonalisere',),
'denasjonaliserer': ('denasjonalisere',),
'denasjonaliseres': ('denasjonalisere',),
'denasjonalisert': ('denasjonalisere',),
'denasjonaliserte': ('denasjonalisere',),
'denaturaliser': ('denaturalisere',),
'denaturalisere': ('denaturalisere',),
'denaturaliserer': ('denaturalisere',),
'denaturaliseres': ('denaturalisere',),
'denaturalisert': ('denaturalisere',),
'denaturaliserte': ('denaturalisere',),
'denaturer': ('denaturere',),
'denaturere': ('denaturere',),
'denaturerer': ('denaturere',),
'denatureres': ('denaturere',),
'denaturert': ('denaturere',),
'denaturerte': ('denaturere',),
'deng': ('denge',),
'denge': ('denge',),
'denger': ('denge',),
'denges': ('denge',),
'dengt': ('denge',),
'dengte': ('denge',),
'denoter': ('denotere',),
'denotere': ('denotere',),
'denoterer': ('denotere',),
'denoteres': ('denotere',),
'denotert': ('denotere',),
'denoterte': ('denotere',),
'denuder': ('denudere',),
'denudere': ('denudere',),
'denuderer': ('denudere',),
'denuderes': ('denudere',),
'denudert': ('denudere',),
'denuderte': ('denudere',),
'deoksider': ('deoksidere',),
'deoksidere': ('deoksidere',),
'deoksiderer': ('deoksidere',),
'deoksideres': ('deoksidere',),
'deoksidert': ('deoksidere',),
'deoksiderte': ('deoksidere',),
'deponer': ('deponere',),
'deponere': ('deponere',),
'deponerer': ('deponere',),
'deponeres': ('deponere',),
'deponert': ('deponere',),
'deponerte': ('deponere',),
'deporter': ('deportere',),
'deportere': ('deportere',),
'deporterer': ('deportere',),
'deporteres': ('deportere',),
'deportert': ('deportere',),
'deporterte': ('deportere',),
'depp': ('deppe',),
'deppa': ('deppe',),
'deppe': ('deppe',),
'depper': ('deppe',),
'deppes': ('deppe',),
'deppet': ('deppe',),
'depraver': ('depravere',),
'depravere': ('depravere',),
'depraverer': ('depravere',),
'depraveres': ('depravere',),
'depravert': ('depravere',),
'depraverte': ('depravere',),
'deprimer': ('deprimere',),
'deprimere': ('deprimere',),
'deprimerer': ('deprimere',),
'deprimeres': ('deprimere',),
'deprimert': ('deprimere',),
'deprimerte': ('deprimere',),
'deprivatiser': ('deprivatisere',),
'deprivatisere': ('deprivatisere',),
'deprivatiserer': ('deprivatisere',),
'deprivatiseres': ('deprivatisere',),
'deprivatisert': ('deprivatisere',),
'deprivatiserte': ('deprivatisere',),
'deranger': ('derangere',),
'derangere': ('derangere',),
'derangerer': ('derangere',),
'derangeres': ('derangere',),
'derangert': ('derangere',),
'derangerte': ('derangere',),
'derelinkver': ('derelinkvere',),
'derelinkvere': ('derelinkvere',),
'derelinkverer': ('derelinkvere',),
'derelinkveres': ('derelinkvere',),
'derelinkvert': ('derelinkvere',),
'derelinkverte': ('derelinkvere',),
'deriver': ('derivere',),
'derivere': ('derivere',),
'deriverer': ('derivere',),
'deriveres': ('derivere',),
'derivert': ('derivere',),
'deriverte': ('derivere',),
'desarmer': ('desarmere',),
'desarmere': ('desarmere',),
'desarmerer': ('desarmere',),
'desarmeres': ('desarmere',),
'desarmert': ('desarmere',),
'desarmerte': ('desarmere',),
'desavuer': ('desavuere',),
'desavuere': ('desavuere',),
'desavuerer': ('desavuere',),
'desavueres': ('desavuere',),
'desavuert': ('desavuere',),
'desavuerte': ('desavuere',),
'desentraliser': ('desentralisere',),
'desentralisere': ('desentralisere',),
'desentraliserer': ('desentralisere',),
'desentraliseres': ('desentralisere',),
'desentralisert': ('desentralisere',),
'desentraliserte': ('desentralisere',),
'deserter': ('desertere',),
'desertere': ('desertere',),
'deserterer': ('desertere',),
'deserteres': ('desertere',),
'desertert': ('desertere',),
'deserterte': ('desertere',),
'desider': ('desidere',),
'desidere': ('desidere',),
'desiderer': ('desidere',),
'desideres': ('desidere',),
'desidert': ('desidere',),
'desiderte': ('desidere',),
'design': ('designe',),
'designa': ('designe',),
'designe': ('designe',),
'designer': ('designe',),
'designes': ('designe',),
'designet': ('designe',),
'desillusjoner': ('desillusjonere',),
'desillusjonere': ('desillusjonere',),
'desillusjonerer': ('desillusjonere',),
'desillusjoneres': ('desillusjonere',),
'desillusjonert': ('desillusjonere',),
'desillusjonerte': ('desillusjonere',),
'desimer': ('desimere',),
'desimere': ('desimere',),
'desimerer': ('desimere',),
'desimeres': ('desimere',),
'desimert': ('desimere',),
'desimerte': ('desimere',),
'desinfiser': ('desinfisere',),
'desinfisere': ('desinfisere',),
'desinfiserer': ('desinfisere',),
'desinfiseres': ('desinfisere',),
'desinfisert': ('desinfisere',),
'desinfiserte': ('desinfisere',),
'desinformer': ('desinformere',),
'desinformere': ('desinformere',),
'desinformerer': ('desinformere',),
'desinformeres': ('desinformere',),
'desinformert': ('desinformere',),
'desinformerte': ('desinformere',),
'desintegrer': ('desintegrere',),
'desintegrere': ('desintegrere',),
'desintegrerer': ('desintegrere',),
'desintegreres': ('desintegrere',),
'desintegrert': ('desintegrere',),
'desintegrerte': ('desintegrere',),
'desoksider': ('desoksidere',),
'desoksidere': ('desoksidere',),
'desoksiderer': ('desoksidere',),
'desoksideres': ('desoksidere',),
'desoksidert': ('desoksidere',),
'desoksiderte': ('desoksidere',),
'desorganiser': ('desorganisere',),
'desorganisere': ('desorganisere',),
'desorganiserer': ('desorganisere',),
'desorganiseres': ('desorganisere',),
'desorganisert': ('desorganisere',),
'desorganiserte': ('desorganisere',),
'desorienter': ('desorientere',),
'desorientere': ('desorientere',),
'desorienterer': ('desorientere',),
'desorienteres': ('desorientere',),
'desorientert': ('desorientere',),
'desorienterte': ('desorientere',),
'destiller': ('destillere',),
'destillere': ('destillere',),
'destillerer': ('destillere',),
'destilleres': ('destillere',),
'destillert': ('destillere',),
'destillerte': ('destillere',),
'destruer': ('destruere',),
'destruere': ('destruere',),
'destruerer': ('destruere',),
'destrueres': ('destruere',),
'destruert': ('destruere',),
'destruerte': ('destruere',),
'detaljbehandl': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandle': ('detaljbehandle',),
'detaljbehandler': ('detaljbehandle',),
'detaljbehandles': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljer': ('detaljere',),
'detaljere': ('detaljere',),
'detaljerer': ('detaljere',),
'detaljeres': ('detaljere',),
'detaljert': ('detaljere',),
'detaljerte': ('detaljere',),
'detasjer': ('detasjere',),
'detasjere': ('detasjere',),
'detasjerer': ('detasjere',),
'detasjeres': ('detasjere',),
'detasjert': ('detasjere',),
'detasjerte': ('detasjere',),
'detasjer': ('detasjere',),
'detasjere': ('detasjere',),
'detasjerer': ('detasjere',),
'detasjeres': ('detasjere',),
'detasjert': ('detasjere',),
'detasjerte': ('detasjere',),
'determiner': ('determinere',),
'determinere': ('determinere',),
'determinerer': ('determinere',),
'determineres': ('determinere',),
'determinert': ('determinere',),
'determinerte': ('determinere',),
'detoner': ('detonere',),
'detonere': ('detonere',),
'detonerer': ('detonere',),
'detoneres': ('detonere',),
'detonert': ('detonere',),
'detonerte': ('detonere',),
'detoner': ('detonere',),
'detonere': ('detonere',),
'detonerer': ('detonere',),
'detoneres': ('detonere',),
'detonert': ('detonere',),
'detonerte': ('detonere',),
'detroniser': ('detronisere',),
'detronisere': ('detronisere',),
'detroniserer': ('detronisere',),
'detroniseres': ('detronisere',),
'detronisert': ('detronisere',),
'detroniserte': ('detronisere',),
'datt': ('dette',),
'dett': ('dette',),
'dette': ('dette',),
'detter': ('dette',),
'dettes': ('dette',),
'dettet': ('dette',),
'devaluer': ('devaluere',),
'devaluere': ('devaluere',),
'devaluerer': ('devaluere',),
'devalueres': ('devaluere',),
'devaluert': ('devaluere',),
'devaluerte': ('devaluere',),
'devier': ('deviere',),
'deviere': ('deviere',),
'devierer': ('deviere',),
'devieres': ('deviere',),
'deviert': ('deviere',),
'devierte': ('deviere',),
'diagnostiser': ('diagnostisere',),
'diagnostisere': ('diagnostisere',),
'diagnostiserer': ('diagnostisere',),
'diagnostiseres': ('diagnostisere',),
'diagnostisert': ('diagnostisere',),
'diagnostiserte': ('diagnostisere',),
'dialyser': ('dialysere',),
'dialysere': ('dialysere',),
'dialyserer': ('dialysere',),
'dialyseres': ('dialysere',),
'dialysert': ('dialysere',),
'dialyserte': ('dialysere',),
'di': ('die',),
'dia': ('die',),
'die': ('die',),
'dier': ('die',),
'dies': ('die',),
'diet': ('die',),
'differensier': ('differensiere',),
'differensiere': ('differensiere',),
'differensierer': ('differensiere',),
'differensieres': ('differensiere',),
'differensiert': ('differensiere',),
'differensierte': ('differensiere',),
'differer': ('differere',),
'differere': ('differere',),
'differerer': ('differere',),
'differeres': ('differere',),
'differert': ('differere',),
'differerte': ('differere',),
'diffunder': ('diffundere',),
'diffundere': ('diffundere',),
'diffunderer': ('diffundere',),
'diffunderes': ('diffundere',),
'diffundert': ('diffundere',),
'diffunderte': ('diffundere',),
'diftonger': ('diftongere',),
'diftongere': ('diftongere',),
'diftongerer': ('diftongere',),
'diftongeres': ('diftongere',),
'diftongert': ('diftongere',),
'diftongerte': ('diftongere',),
'digg': ('digge',),
'digga': ('digge',),
'digge': ('digge',),
'digger': ('digge',),
'digges': ('digge',),
'digget': ('digge',),
'digitaliser': ('digitalisere',),
'digitalisere': ('digitalisere',),
'digitaliserer': ('digitalisere',),
'digitaliseres': ('digitalisere',),
'digitalisert': ('digitalisere',),
'digitaliserte': ('digitalisere',),
'dikk': ('dikke',),
'dikka': ('dikke',),
'dikke': ('dikke',),
'dikker': ('dikke',),
'dikkes': ('dikke',),
'dikket': ('dikke',),
'dikk': ('dikke',),
'dikka': ('dikke',),
'dikke': ('dikke',),
'dikker': ('dikke',),
'dikkes': ('dikke',),
'dikket': ('dikke',),
'dikt': ('dikte',),
'dikta': ('dikte',),
'dikte': ('dikte',),
'dikter': ('dikte',),
'diktes': ('dikte',),
'diktet': ('dikte',),
'dikter': ('diktere',),
'diktere': ('diktere',),
'dikterer': ('diktere',),
'dikteres': ('diktere',),
'diktert': ('diktere',),
'dikterte': ('diktere',),
'dill': ('dille',),
'dilla': ('dille',),
'dille': ('dille',),
'diller': ('dille',),
'dilles': ('dille',),
'dillet': ('dille',),
'dilt': ('dilte',),
'dilta': ('dilte',),
'dilte': ('dilte',),
'dilter': ('dilte',),
'diltes': ('dilte',),
'diltet': ('dilte',),
'dimensjoner': ('dimensjonere',),
'dimensjonere': ('dimensjonere',),
'dimensjonerer': ('dimensjonere',),
'dimensjoneres': ('dimensjonere',),
'dimensjonert': ('dimensjonere',),
'dimensjonerte': ('dimensjonere',),
'dimitter': ('dimittere',),
'dimittere': ('dimittere',),
'dimitterer': ('dimittere',),
'dimitteres': ('dimittere',),
'dimittert': ('dimittere',),
'dimitterte': ('dimittere',),
'dim': ('dimme',),
'dimma': ('dimme',),
'dimme': ('dimme',),
'dimmer': ('dimme',),
'dimmes': ('dimme',),
'dimmet': ('dimme',),
'dim': ('dimme',),
'dimma': ('dimme',),
'dimme': ('dimme',),
'dimmer': ('dimme',),
'dimmes': ('dimme',),
'dimmet': ('dimme',),
'dim': ('dimme',),
'dimme': ('dimme',),
'dimmer': ('dimme',),
'dimmes': ('dimme',),
'dimt': ('dimme',),
'dimte': ('dimme',),
'diner': ('dinere',),
'dinere': ('dinere',),
'dinerer': ('dinere',),
'dineres': ('dinere',),
'dinert': ('dinere',),
'dinerte': ('dinere',),
'dingl': ('dingle',),
'dingla': ('dingle',),
'dingle': ('dingle',),
'dingler': ('dingle',),
'dingles': ('dingle',),
'dinglet': ('dingle',),
'diriger': ('dirigere',),
'dirigere': ('dirigere',),
'dirigerer': ('dirigere',),
'dirigeres': ('dirigere',),
'dirigert': ('dirigere',),
'dirigerte': ('dirigere',),
'dirk': ('dirke',),
'dirka': ('dirke',),
'dirke': ('dirke',),
'dirker': ('dirke',),
'dirkes': ('dirke',),
'dirket': ('dirke',),
'dirr': ('dirre',),
'dirra': ('dirre',),
'dirre': ('dirre',),
'dirrer': ('dirre',),
'dirres': ('dirre',),
'dirret': ('dirre',),
'disipliner': ('disiplinere',),
'disiplinere': ('disiplinere',),
'disiplinerer': ('disiplinere',),
'disiplineres': ('disiplinere',),
'disiplinert': ('disiplinere',),
'disiplinerte': ('disiplinere',),
'disk': ('diske',),
'diska': ('diske',),
'diske': ('diske',),
'disker': ('diske',),
'diskes': ('diske',),
'disket': ('diske',),
'disk': ('diske',),
'diska': ('diske',),
'diske': ('diske',),
'disker': ('diske',),
'diskes': ('diske',),
'disket': ('diske',),
'diskonter': ('diskontere',),
'diskontere': ('diskontere',),
'diskonterer': ('diskontere',),
'diskonteres': ('diskontere',),
'diskontert': ('diskontere',),
'diskonterte': ('diskontere',),
'diskrediter': ('diskreditere',),
'diskreditere': ('diskreditere',),
'diskrediterer': ('diskreditere',),
'diskrediteres': ('diskreditere',),
'diskreditert': ('diskreditere',),
'diskrediterte': ('diskreditere',),
'diskriminer': ('diskriminere',),
'diskriminere': ('diskriminere',),
'diskriminerer': ('diskriminere',),
'diskrimineres': ('diskriminere',),
'diskriminert': ('diskriminere',),
'diskriminerte': ('diskriminere',),
'diskuter': ('diskutere',),
'diskutere': ('diskutere',),
'diskuterer': ('diskutere',),
'diskuteres': ('diskutere',),
'diskutert': ('diskutere',),
'diskuterte': ('diskutere',),
'diskvalifiser': ('diskvalifisere',),
'diskvalifisere': ('diskvalifisere',),
'diskvalifiserer': ('diskvalifisere',),
'diskvalifiseres': ('diskvalifisere',),
'diskvalifisert': ('diskvalifisere',),
'diskvalifiserte': ('diskvalifisere',),
'dispasjer': ('dispasjere',),
'dispasjere': ('dispasjere',),
'dispasjerer': ('dispasjere',),
'dispasjeres': ('dispasjere',),
'dispasjert': ('dispasjere',),
'dispasjerte': ('dispasjere',),
'dispenser': ('dispensere',),
'dispensere': ('dispensere',),
'dispenserer': ('dispensere',),
'dispenseres': ('dispensere',),
'dispensert': ('dispensere',),
'dispenserte': ('dispensere',),
'disponer': ('disponere',),
'disponere': ('disponere',),
'disponerer': ('disponere',),
'disponeres': ('disponere',),
'disponert': ('disponere',),
'disponerte': ('disponere',),
'disputer': ('disputere',),
'disputere': ('disputere',),
'disputerer': ('disputere',),
'disputeres': ('disputere',),
'disputert': ('disputere',),
'disputerte': ('disputere',),
'diss': ('disse',),
'dissa': ('disse',),
'disse': ('disse',),
'disser': ('disse',),
'disses': ('disse',),
'disset': ('disse',),
'disseker': ('dissekere',),
'dissekere': ('dissekere',),
'dissekerer': ('dissekere',),
'dissekeres': ('dissekere',),
'dissekert': ('dissekere',),
'dissekerte': ('dissekere',),
'dissenter': ('dissentere',),
'dissentere': ('dissentere',),
'dissenterer': ('dissentere',),
'dissenteres': ('dissentere',),
'dissentert': ('dissentere',),
'dissenterte': ('dissentere',),
'dissimiler': ('dissimilere',),
'dissimilere': ('dissimilere',),
'dissimilerer': ('dissimilere',),
'dissimileres': ('dissimilere',),
'dissimilert': ('dissimilere',),
'dissimilerte': ('dissimilere',),
'dissoner': ('dissonere',),
'dissonere': ('dissonere',),
'dissonerer': ('dissonere',),
'dissoneres': ('dissonere',),
'dissonert': ('dissonere',),
'dissonerte': ('dissonere',),
'dissosier': ('dissosiere',),
'dissosiere': ('dissosiere',),
'dissosierer': ('dissosiere',),
'dissosieres': ('dissosiere',),
'dissosiert': ('dissosiere',),
'dissosierte': ('dissosiere',),
'distanser': ('distansere',),
'distansere': ('distansere',),
'distanserer': ('distansere',),
'distanseres': ('distansere',),
'distansert': ('distansere',),
'distanserte': ('distansere',),
'distingver': ('distingvere',),
'distingvere': ('distingvere',),
'distingverer': ('distingvere',),
'distingveres': ('distingvere',),
'distingvert': ('distingvere',),
'distingverte': ('distingvere',),
'distraher': ('distrahere',),
'distrahere': ('distrahere',),
'distraherer': ('distrahere',),
'distraheres': ('distrahere',),
'distrahert': ('distrahere',),
'distraherte': ('distrahere',),
'distribuer': ('distribuere',),
'distribuere': ('distribuere',),
'distribuerer': ('distribuere',),
'distribueres': ('distribuere',),
'distribuert': ('distribuere',),
'distribuerte': ('distribuere',),
'diverger': ('divergere',),
'divergere': ('divergere',),
'divergerer': ('divergere',),
'divergeres': ('divergere',),
'divergert': ('divergere',),
'divergerte': ('divergere',),
'diverter': ('divertere',),
'divertere': ('divertere',),
'diverterer': ('divertere',),
'diverteres': ('divertere',),
'divertert': ('divertere',),
'diverterte': ('divertere',),
'divider': ('dividere',),
'dividere': ('dividere',),
'dividerer': ('dividere',),
'divideres': ('dividere',),
'dividert': ('dividere',),
'dividerte': ('dividere',),
'djupets': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetse': ('djupetse',),
'djupetser': ('djupetse',),
'djupetses': ('djupetse',),
'djupetset': ('djupetse',),
'djupfrys': ('djupfryse',),
'djupfryse': ('djupfryse',),
'djupfryser': ('djupfryse',),
'djupfryses': ('djupfryse',),
'djupfryst': ('djupfryse',),
'djupfryste': ('djupfryse',),
'djupn': ('djupne',),
'djupna': ('djupne',),
'djupne': ('djupne',),
'djupner': ('djupne',),
'djupnes': ('djupne',),
'djupnet': ('djupne',),
'dobl': ('doble',),
'dobla': ('doble',),
'doble': ('doble',),
'dobler': ('doble',),
'dobles': ('doble',),
'doblet': ('doble',),
'dogg': ('dogge',),
'dogga': ('dogge',),
'dogge': ('dogge',),
'dogger': ('dogge',),
'dogges': ('dogge',),
'dogget': ('dogge',),
'dogg': ('dogge',),
'dogga': ('dogge',),
'dogge': ('dogge',),
'dogger': ('dogge',),
'dogges': ('dogge',),
'dogget': ('dogge',),
'dokk': ('dokke',),
'dokka': ('dokke',),
'dokke': ('dokke',),
'dokker': ('dokke',),
'dokkes': ('dokke',),
'dokket': ('dokke',),
'dokksatt': ('dokksette',),
'dokksatte': ('dokksette',),
'dokksett': ('dokksette',),
'dokksette': ('dokksette',),
'dokksetter': ('dokksette',),
'dokksettes': ('dokksette',),
'doktorer': ('doktorere',),
'doktorere': ('doktorere',),
'doktorerer': ('doktorere',),
'doktoreres': ('doktorere',),
'doktorert': ('doktorere',),
'doktorerte': ('doktorere',),
'dokumenter': ('dokumentere',),
'dokumentere': ('dokumentere',),
'dokumenterer': ('dokumentere',),
'dokumenteres': ('dokumentere',),
'dokumentert': ('dokumentere',),
'dokumenterte': ('dokumentere',),
'dolk': ('dolke',),
'dolka': ('dolke',),
'dolke': ('dolke',),
'dolker': ('dolke',),
'dolkes': ('dolke',),
'dolket': ('dolke',),
'domfell': ('domfelle',),
'domfelle': ('domfelle',),
'domfeller': ('domfelle',),
'domfelles': ('domfelle',),
'domfelt': ('domfelle',),
'domfelte': ('domfelle',),
'dominer': ('dominere',),
'dominere': ('dominere',),
'dominerer': ('dominere',),
'domineres': ('dominere',),
'dominert': ('dominere',),
'dominerte': ('dominere',),
'domisilier': ('domisiliere',),
'domisiliere': ('domisiliere',),
'domisilierer': ('domisiliere',),
'domisilieres': ('domisiliere',),
'domisiliert': ('domisiliere',),
'domisilierte': ('domisiliere',),
'doner': ('donere',),
'donere': ('donere',),
'donerer': ('donere',),
'doneres': ('donere',),
'donert': ('donere',),
'donerte': ('donere',),
'dop': ('dope',),
'dopa': ('dope',),
'dope': ('dope',),
'doper': ('dope',),
'dopes': ('dope',),
'dopet': ('dope',),
'dor': ('dore',),
'dora': ('dore',),
'dore': ('dore',),
'dorer': ('dore',),
'dores': ('dore',),
'doret': ('dore',),
'dort': ('dore',),
'dorte': ('dore',),
'dorg': ('dorge',),
'dorga': ('dorge',),
'dorge': ('dorge',),
'dorger': ('dorge',),
'dorges': ('dorge',),
'dorget': ('dorge',),
'dorm': ('dorme',),
'dorma': ('dorme',),
'dorme': ('dorme',),
'dormer': ('dorme',),
'dormes': ('dorme',),
'dormet': ('dorme',),
'doser': ('dosere',),
'dosere': ('dosere',),
'doserer': ('dosere',),
'doseres': ('dosere',),
'dosert': ('dosere',),
'doserte': ('dosere',),
'doser': ('dosere',),
'dosere': ('dosere',),
'doserer': ('dosere',),
'doseres': ('dosere',),
'dosert': ('dosere',),
'doserte': ('dosere',),
'dosser': ('dossere',),
'dossere': ('dossere',),
'dosserer': ('dossere',),
'dosseres': ('dossere',),
'dossert': ('dossere',),
'dosserte': ('dossere',),
'doter': ('dotere',),
'dotere': ('dotere',),
'doterer': ('dotere',),
'doteres': ('dotere',),
'dotert': ('dotere',),
'doterte': ('dotere',),
'dovn': ('dovne',),
'dovna': ('dovne',),
'dovne': ('dovne',),
'dovner': ('dovne',),
'dovnes': ('dovne',),
'dovnet': ('dovne',),
'dra': ('dra',),
'dradd': ('dra',),
'drar': ('dra',),
'dras': ('dra',),
'dratt': ('dra',),
'dro': ('dra',),
'drog': ('dra',),
'dradd': ('drage',),
'drag': ('drage',),
'drage': ('drage',),
'drager': ('drage',),
'drages': ('drage',),
'dratt': ('drage',),
'dro': ('drage',),
'drog': ('drage',),
'dradd': ('drage',),
'drag': ('drage',),
'drage': ('drage',),
'drager': ('drage',),
'drages': ('drage',),
'dratt': ('drage',),
'dro': ('drage',),
'drog': ('drage',),
'drages': ('drages',),
'droges': ('drages',),
'drages': ('drages',),
'droges': ('drages',),
'drags': ('dragse',),
'dragsa': ('dragse',),
'dragse': ('dragse',),
'dragser': ('dragse',),
'dragses': ('dragse',),
'dragset': ('dragse',),
'dramatiser': ('dramatisere',),
'dramatisere': ('dramatisere',),
'dramatiserer': ('dramatisere',),
'dramatiseres': ('dramatisere',),
'dramatisert': ('dramatisere',),
'dramatiserte': ('dramatisere',),
'draper': ('drapere',),
'drapere': ('drapere',),
'draperer': ('drapere',),
'draperes': ('drapere',),
'drapert': ('drapere',),
'draperte': ('drapere',),
'dras': ('dras',),
'drogs': ('dras',),
'dros': ('dras',),
'dras': ('dras',),
'drogs': ('dras',),
'dros': ('dras',),
'drasjer': ('drasjere',),
'drasjere': ('drasjere',),
'drasjerer': ('drasjere',),
'drasjeres': ('drasjere',),
'drasjert': ('drasjere',),
'drasjerte': ('drasjere',),
'drass': ('drasse',),
'drassa': ('drasse',),
'drasse': ('drasse',),
'drasser': ('drasse',),
'drasses': ('drasse',),
'drasset': ('drasse',),
'dratt': ('dratte',),
'dratta': ('dratte',),
'dratte': ('dratte',),
'dratter': ('dratte',),
'drattes': ('dratte',),
'drattet': ('dratte',),
'dregg': ('dregge',),
'dregga': ('dregge',),
'dregge': ('dregge',),
'dregger': ('dregge',),
'dregges': ('dregge',),
'dregget': ('dregge',),
'drei': ('dreie',),
'dreia': ('dreie',),
'dreid': ('dreie',),
'dreidd': ('dreie',),
'dreidde': ('dreie',),
'dreide': ('dreie',),
'dreie': ('dreie',),
'dreier': ('dreie',),
'dreies': ('dreie',),
'dreiet': ('dreie',),
'dreis': ('dreise',),
'dreise': ('dreise',),
'dreiser': ('dreise',),
'dreises': ('dreise',),
'dreist': ('dreise',),
'dreiste': ('dreise',),
'dren': ('drene',),
'drene': ('drene',),
'drener': ('drene',),
'drenes': ('drene',),
'drent': ('drene',),
'drente': ('drene',),
'drener': ('drenere',),
'drenere': ('drenere',),
'drenerer': ('drenere',),
'dreneres': ('drenere',),
'drenert': ('drenere',),
'drenerte': ('drenere',),
'drap': ('drepe',),
'drep': ('drepe',),
'drepe': ('drepe',),
'dreper': ('drepe',),
'drepes': ('drepe',),
'drept': ('drepe',),
'drepte': ('drepe',),
'dress': ('dresse',),
'dressa': ('dresse',),
'dresse': ('dresse',),
'dresser': ('dresse',),
'dresses': ('dresse',),
'dresset': ('dresse',),
'dresser': ('dressere',),
'dressere': ('dressere',),
'dresserer': ('dressere',),
'dresseres': ('dressere',),
'dressert': ('dressere',),
'dresserte': ('dressere',),
'drett': ('drette',),
'dretta': ('drette',),
'drette': ('drette',),
'dretter': ('drette',),
'drettes': ('drette',),
'drettet': ('drette',),
'driblet': ('drible',),
'dribl': ('drible',),
'dribla': ('drible',),
'drible': ('drible',),
'dribler': ('drible',),
'dribles': ('drible',),
'driblet': ('drible',),
'drift': ('drifte',),
'drifta': ('drifte',),
'drifte': ('drifte',),
'drifter': ('drifte',),
'driftes': ('drifte',),
'driftet': ('drifte',),
'drakk': ('drikke',),
'drikk': ('drikke',),
'drikke': ('drikke',),
'drikker': ('drikke',),
'drikkes': ('drikke',),
'drukket': ('drikke',),
'drill': ('drille',),
'drilla': ('drille',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drillet': ('drille',),
'drill': ('drille',),
'drilla': ('drille',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drill': ('drille',),
'drilla': ('drille',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drill': ('drille',),
'drilla': ('drille',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drist': ('driste',),
'drista': ('driste',),
'driste': ('driste',),
'drister': ('driste',),
'dristes': ('driste',),
'dristet': ('driste',),
'dreit': ('drite',),
'dret': ('drite',),
'drit': ('drite',),
'drite': ('drite',),
'driter': ('drite',),
'drites': ('drite',),
'dritet': ('drite',),
'dritt': ('drite',),
'dreiv': ('drive',),
'drev': ('drive',),
'drevet': ('drive',),
'driv': ('drive',),
'drive': ('drive',),
'driver': ('drive',),
'drives': ('drive',),
'drodl': ('drodle',),
'drodla': ('drodle',),
'drodle': ('drodle',),
'drodler': ('drodle',),
'drodles': ('drodle',),
'drodlet': ('drodle',),
'dropp': ('droppe',),
'droppa': ('droppe',),
'droppe': ('droppe',),
'dropper': ('droppe',),
'droppes': ('droppe',),
'droppet': ('droppe',),
'drukn': ('drukne',),
'drukna': ('drukne',),
'drukne': ('drukne',),
'drukner': ('drukne',),
'druknes': ('drukne',),
'druknet': ('drukne',),
'dryg': ('dryge',),
'drygd': ('dryge',),
'drygde': ('dryge',),
'dryge': ('dryge',),
'dryger': ('dryge',),
'dryges': ('dryge',),
'drypp': ('dryppe',),
'dryppa': ('dryppe',),
'dryppe': ('dryppe',),
'drypper': ('dryppe',),
'dryppes': ('dryppe',),
'dryppet': ('dryppe',),
'drypt': ('dryppe',),
'drypte': ('dryppe',),
'drypptørk': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørke': ('drypptørke',),
'drypptørker': ('drypptørke',),
'drypptørkes': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørr': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørre': ('drypptørre',),
'drypptørrer': ('drypptørre',),
'drypptørres': ('drypptørre',),
'drypptørret': ('drypptørre',),
'dryss': ('drysse',),
'dryssa': ('drysse',),
'drysse': ('drysse',),
'drysser': ('drysse',),
'drysses': ('drysse',),
'drysset': ('drysse',),
'dryst': ('drysse',),
'dryste': ('drysse',),
'drøft': ('drøfte',),
'drøfta': ('drøfte',),
'drøfte': ('drøfte',),
'drøfter': ('drøfte',),
'drøftes': ('drøfte',),
'drøftet': ('drøfte',),
'drøm': ('drømme',),
'drømme': ('drømme',),
'drømmer': ('drømme',),
'drømmes': ('drømme',),
'drømt': ('drømme',),
'drømte': ('drømme',),
'drønn': ('drønne',),
'drønna': ('drønne',),
'drønne': ('drønne',),
'drønner': ('drønne',),
'drønnes': ('drønne',),
'drønnet': ('drønne',),
'drønt': ('drønne',),
'drønte': ('drønne',),
'drøs': ('drøse',),
'drøse': ('drøse',),
'drøser': ('drøse',),
'drøses': ('drøse',),
'drøst': ('drøse',),
'drøste': ('drøse',),
'drøvtygd': ('drøvtygge',),
'drøvtygde': ('drøvtygge',),
'drøvtygg': ('drøvtygge',),
'drøvtygge': ('drøvtygge',),
'drøvtygger': ('drøvtygge',),
'drøvtygges': ('drøvtygge',),
'drøvtygget': ('drøvtygge',),
'drøy': ('drøye',),
'drøyd': ('drøye',),
'drøyde': ('drøye',),
'drøye': ('drøye',),
'drøyer': ('drøye',),
'drøyes': ('drøye',),
'dubb': ('dubbe',),
'dubba': ('dubbe',),
'dubbe': ('dubbe',),
'dubber': ('dubbe',),
'dubbes': ('dubbe',),
'dubbet': ('dubbe',),
'dubb': ('dubbe',),
'dubba': ('dubbe',),
'dubbe': ('dubbe',),
'dubber': ('dubbe',),
'dubbes': ('dubbe',),
'dubbet': ('dubbe',),
'dubler': ('dublere',),
'dublere': ('dublere',),
'dublerer': ('dublere',),
'dubleres': ('dublere',),
'dublert': ('dublere',),
'dublerte': ('dublere',),
'dueller': ('duellere',),
'duellere': ('duellere',),
'duellerer': ('duellere',),
'duelleres': ('duellere',),
'duellert': ('duellere',),
'duellerte': ('duellere',),
'duft': ('dufte',),
'dufta': ('dufte',),
'dufte': ('dufte',),
'dufter': ('dufte',),
'duftes': ('dufte',),
'duftet': ('dufte',),
'dug': ('duge',),
'dugd': ('duge',),
'dugde': ('duge',),
'duge': ('duge',),
'duger': ('duge',),
'duges': ('duge',),
'dugg': ('dugge',),
'dugga': ('dugge',),
'dugge': ('dugge',),
'dugger': ('dugge',),
'dugges': ('dugge',),
'dugget': ('dugge',),
'duk': ('duke',),
'duka': ('duke',),
'duke': ('duke',),
'duker': ('duke',),
'dukes': ('duke',),
'duket': ('duke',),
'dukk': ('dukke',),
'dukka': ('dukke',),
'dukke': ('dukke',),
'dukker': ('dukke',),
'dukkes': ('dukke',),
'dukket': ('dukke',),
'dull': ('dulle',),
'dulla': ('dulle',),
'dulle': ('dulle',),
'duller': ('dulle',),
'dulles': ('dulle',),
'dullet': ('dulle',),
'dulm': ('dulme',),
'dulma': ('dulme',),
'dulme': ('dulme',),
'dulmer': ('dulme',),
'dulmes': ('dulme',),
'dulmet': ('dulme',),
'dult': ('dulte',),
'dulta': ('dulte',),
'dulte': ('dulte',),
'dulter': ('dulte',),
'dultes': ('dulte',),
'dultet': ('dulte',),
'dum': ('dumme',),
'dumma': ('dumme',),
'dumme': ('dumme',),
'dummer': ('dumme',),
'dummes': ('dumme',),
'dummet': ('dumme',),
'dump': ('dumpe',),
'dumpa': ('dumpe',),
'dumpe': ('dumpe',),
'dumper': ('dumpe',),
'dumpes': ('dumpe',),
'dumpet': ('dumpe',),
'dump': ('dumpe',),
'dumpa': ('dumpe',),
'dumpe': ('dumpe',),
'dumper': ('dumpe',),
'dumpes': ('dumpe',),
'dumpet': ('dumpe',),
'dundr': ('dundre',),
'dundra': ('dundre',),
'dundre': ('dundre',),
'dundrer': ('dundre',),
'dundres': ('dundre',),
'dundret': ('dundre',),
'dung': ('dunge',),
'dunga': ('dunge',),
'dunge': ('dunge',),
'dunger': ('dunge',),
'dunges': ('dunge',),
'dunget': ('dunge',),
'dunk': ('dunke',),
'dunka': ('dunke',),
'dunke': ('dunke',),
'dunker': ('dunke',),
'dunkes': ('dunke',),
'dunket': ('dunke',),
'dunst': ('dunste',),
'dunsta': ('dunste',),
'dunste': ('dunste',),
'dunster': ('dunste',),
'dunstes': ('dunste',),
'dunstet': ('dunste',),
'duper': ('dupere',),
'dupere': ('dupere',),
'duperer': ('dupere',),
'duperes': ('dupere',),
'dupert': ('dupere',),
'duperte': ('dupere',),
'dupliser': ('duplisere',),
'duplisere': ('duplisere',),
'dupliserer': ('duplisere',),
'dupliseres': ('duplisere',),
'duplisert': ('duplisere',),
'dupliserte': ('duplisere',),
'dupp': ('duppe',),
'duppa': ('duppe',),
'duppe': ('duppe',),
'dupper': ('duppe',),
'duppes': ('duppe',),
'duppet': ('duppe',),
'dur': ('dure',),
'dura': ('dure',),
'dure': ('dure',),
'durer': ('dure',),
'dures': ('dure',),
'duret': ('dure',),
'durt': ('dure',),
'durte': ('dure',),
'durksy': ('durksy',),
'durksydd': ('durksy',),
'durksydde': ('durksy',),
'durksyr': ('durksy',),
'durksys': ('durksy',),
'dus': ('duse',),
'duse': ('duse',),
'duser': ('duse',),
'duses': ('duse',),
'dust': ('duse',),
'duste': ('duse',),
'dus': ('duse',),
'duse': ('duse',),
'duser': ('duse',),
'duses': ('duse',),
'dust': ('duse',),
'duste': ('duse',),
'dusj': ('dusje',),
'dusja': ('dusje',),
'dusje': ('dusje',),
'dusjer': ('dusje',),
'dusjes': ('dusje',),
'dusjet': ('dusje',),
'duskregn': ('duskregne',),
'duskregna': ('duskregne',),
'duskregne': ('duskregne',),
'duskregner': ('duskregne',),
'duskregnes': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnt': ('duskregne',),
'duskregnte': ('duskregne',),
'dutt': ('dutte',),
'dutta': ('dutte',),
'dutte': ('dutte',),
'dutter': ('dutte',),
'duttes': ('dutte',),
'duttet': ('dutte',),
'dutt': ('dutte',),
'dutta': ('dutte',),
'dutte': ('dutte',),
'dutter': ('dutte',),
'duttes': ('dutte',),
'duttet': ('dutte',),
'duv': ('duve',),
'duva': ('duve',),
'duvd': ('duve',),
'duvde': ('duve',),
'duve': ('duve',),
'duver': ('duve',),
'duves': ('duve',),
'duvet': ('duve',),
'dvel': ('dvele',),
'dvele': ('dvele',),
'dveler': ('dvele',),
'dveles': ('dvele',),
'dvelt': ('dvele',),
'dvelte': ('dvele',),
'dy': ('dy',),
'dydd': ('dy',),
'dydde': ('dy',),
'dyr': ('dy',),
'dys': ('dy',),
'dykk': ('dykke',),
'dykka': ('dykke',),
'dykke': ('dykke',),
'dykker': ('dykke',),
'dykkes': ('dykke',),
'dykket': ('dykke',),
'dyktiggjorde': ('dyktiggjøre',),
'dyktiggjort': ('dyktiggjøre',),
'dyktiggjør': ('dyktiggjøre',),
'dyktiggjøre': ('dyktiggjøre',),
'dyktiggjøres': ('dyktiggjøre',),
'dyng': ('dynge',),
'dynga': ('dynge',),
'dynge': ('dynge',),
'dynger': ('dynge',),
'dynges': ('dynge',),
'dynget': ('dynge',),
'dynk': ('dynke',),
'dynka': ('dynke',),
'dynke': ('dynke',),
'dynker': ('dynke',),
'dynkes': ('dynke',),
'dynket': ('dynke',),
'dypets': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetse': ('dypetse',),
'dypetser': ('dypetse',),
'dypetses': ('dypetse',),
'dypetset': ('dypetse',),
'dypfrys': ('dypfryse',),
'dypfryse': ('dypfryse',),
'dypfryser': ('dypfryse',),
'dypfryses': ('dypfryse',),
'dypfryst': ('dypfryse',),
'dypfryste': ('dypfryse',),
'dypp': ('dyppe',),
'dyppa': ('dyppe',),
'dyppe': ('dyppe',),
'dypper': ('dyppe',),
'dyppes': ('dyppe',),
'dyppet': ('dyppe',),
'dyrk': ('dyrke',),
'dyrka': ('dyrke',),
'dyrke': ('dyrke',),
'dyrker': ('dyrke',),
'dyrkes': ('dyrke',),
'dyrket': ('dyrke',),
'dyss': ('dysse',),
'dyssa': ('dysse',),
'dysse': ('dysse',),
'dysser': ('dysse',),
'dysses': ('dysse',),
'dysset': ('dysse',),
'dytt': ('dytte',),
'dytta': ('dytte',),
'dytte': ('dytte',),
'dytter': ('dytte',),
'dyttes': ('dytte',),
'dyttet': ('dytte',),
'dytt': ('dytte',),
'dytta': ('dytte',),
'dytte': ('dytte',),
'dytter': ('dytte',),
'dyttes': ('dytte',),
'dyttet': ('dytte',),
'dån': ('dåne',),
'dåna': ('dåne',),
'dåne': ('dåne',),
'dåner': ('dåne',),
'dånes': ('dåne',),
'dånet': ('dåne',),
'dånt': ('dåne',),
'dånte': ('dåne',),
'dår': ('dåre',),
'dåra': ('dåre',),
'dåre': ('dåre',),
'dårer': ('dåre',),
'dåres': ('dåre',),
'dåret': ('dåre',),
'dø': ('dø',),
'dødd': ('dø',),
'dødde': ('dø',),
'døde': ('dø',),
'dør': ('dø',),
'døs': ('dø',),
'død': ('døde',),
'døda': ('døde',),
'døde': ('døde',),
'døder': ('døde',),
'dødes': ('døde',),
'dødet': ('døde',),
'dulgt': ('dølge',),
'dulgte': ('dølge',),
'dølg': ('dølge',),
'dølge': ('dølge',),
'dølger': ('dølge',),
'dølges': ('dølge',),
'døm': ('dømme',),
'dømme': ('dømme',),
'dømmer': ('dømme',),
'dømmes': ('dømme',),
'dømt': ('dømme',),
'dømte': ('dømme',),
'dønn': ('dønne',),
'dønna': ('dønne',),
'dønne': ('dønne',),
'dønner': ('dønne',),
'dønnes': ('dønne',),
'dønnet': ('dønne',),
'dønt': ('dønne',),
'dønte': ('dønne',),
'døp': ('døpe',),
'døpe': ('døpe',),
'døper': ('døpe',),
'døpes': ('døpe',),
'døpt': ('døpe',),
'døpte': ('døpe',),
'døs': ('døse',),
'døsa': ('døse',),
'døse': ('døse',),
'døser': ('døse',),
'døses': ('døse',),
'døset': ('døse',),
'døst': ('døse',),
'døste': ('døse',),
'døy': ('døye',),
'døya': ('døye',),
'døyd': ('døye',),
'døyde': ('døye',),
'døye': ('døye',),
'døyer': ('døye',),
'døyes': ('døye',),
'døyet': ('døye',),
'døyv': ('døyve',),
'døyva': ('døyve',),
'døyvd': ('døyve',),
'døyvde': ('døyve',),
'døyve': ('døyve',),
'døyver': ('døyve',),
'døyves': ('døyve',),
'døyvet': ('døyve',),
'ebb': ('ebbe',),
'ebba': ('ebbe',),
'ebbe': ('ebbe',),
'ebber': ('ebbe',),
'ebbes': ('ebbe',),
'ebbet': ('ebbe',),
'edfest': ('edfeste',),
'edfesta': ('edfeste',),
'edfeste': ('edfeste',),
'edfester': ('edfeste',),
'edfestes': ('edfeste',),
'edfestet': ('edfeste',),
'effektiviser': ('effektivisere',),
'effektivisere': ('effektivisere',),
'effektiviserer': ('effektivisere',),
'effektiviseres': ('effektivisere',),
'effektivisert': ('effektivisere',),
'effektiviserte': ('effektivisere',),
'effektuer': ('effektuere',),
'effektuere': ('effektuere',),
'effektuerer': ('effektuere',),
'effektueres': ('effektuere',),
'effektuert': ('effektuere',),
'effektuerte': ('effektuere',),
'egaliser': ('egalisere',),
'egalisere': ('egalisere',),
'egaliserer': ('egalisere',),
'egaliseres': ('egalisere',),
'egalisert': ('egalisere',),
'egaliserte': ('egalisere',),
'egg': ('egge',),
'egga': ('egge',),
'egge': ('egge',),
'egger': ('egge',),
'egges': ('egge',),
'egget': ('egge',),
'egl': ('egle',),
'egla': ('egle',),
'egle': ('egle',),
'egler': ('egle',),
'egles': ('egle',),
'eglet': ('egle',),
'egn': ('egne',),
'egna': ('egne',),
'egne': ('egne',),
'egner': ('egne',),
'egnes': ('egne',),
'egnet': ('egne',),
'egn': ('egne',),
'egna': ('egne',),
'egne': ('egne',),
'egner': ('egne',),
'egnes': ('egne',),
'egnet': ('egne',),
'egnt': ('egne',),
'egnte': ('egne',),
'ei': ('eie',),
'eid': ('eie',),
'eide': ('eie',),
'eie': ('eie',),
'eier': ('eie',),
'eies': ('eie',),
'eiet': ('eie',),
'ått': ('eie',),
'åtte': ('eie',),
'eim': ('eime',),
'eima': ('eime',),
'eime': ('eime',),
'eimer': ('eime',),
'eimes': ('eime',),
'eimet': ('eime',),
'eir': ('eire',),
'eira': ('eire',),
'eire': ('eire',),
'eirer': ('eire',),
'eires': ('eire',),
'eiret': ('eire',),
'ejakuler': ('ejakulere',),
'ejakulere': ('ejakulere',),
'ejakulerer': ('ejakulere',),
'ejakuleres': ('ejakulere',),
'ejakulert': ('ejakulere',),
'ejakulerte': ('ejakulere',),
'eksaminer': ('eksaminere',),
'eksaminere': ('eksaminere',),
'eksaminerer': ('eksaminere',),
'eksamineres': ('eksaminere',),
'eksaminert': ('eksaminere',),
'eksaminerte': ('eksaminere',),
'ekseger': ('eksegere',),
'eksegere': ('eksegere',),
'eksegerer': ('eksegere',),
'eksegeres': ('eksegere',),
'eksegert': ('eksegere',),
'eksegerte': ('eksegere',),
'eksekver': ('eksekvere',),
'eksekvere': ('eksekvere',),
'eksekverer': ('eksekvere',),
'eksekveres': ('eksekvere',),
'eksekvert': ('eksekvere',),
'eksekverte': ('eksekvere',),
'ekseller': ('eksellere',),
'eksellere': ('eksellere',),
'eksellerer': ('eksellere',),
'ekselleres': ('eksellere',),
'eksellert': ('eksellere',),
'eksellerte': ('eksellere',),
'eksemplifiser': ('eksemplifisere',),
'eksemplifisere': ('eksemplifisere',),
'eksemplifiserer': ('eksemplifisere',),
'eksemplifiseres': ('eksemplifisere',),
'eksemplifisert': ('eksemplifisere',),
'eksemplifiserte': ('eksemplifisere',),
'ekserper': ('ekserpere',),
'ekserpere': ('ekserpere',),
'ekserperer': ('ekserpere',),
'ekserperes': ('ekserpere',),
'ekserpert': ('ekserpere',),
'ekserperte': ('ekserpere',),
'ekserser': ('eksersere',),
'eksersere': ('eksersere',),
'ekserserer': ('eksersere',),
'ekserseres': ('eksersere',),
'eksersert': ('eksersere',),
'ekserserte': ('eksersere',),
'ekshaler': ('ekshalere',),
'ekshalere': ('ekshalere',),
'ekshalerer': ('ekshalere',),
'ekshaleres': ('ekshalere',),
'ekshalert': ('ekshalere',),
'ekshalerte': ('ekshalere',),
'eksister': ('eksistere',),
'eksistere': ('eksistere',),
'eksisterer': ('eksistere',),
'eksisteres': ('eksistere',),
'eksistert': ('eksistere',),
'eksisterte': ('eksistere',),
'eksklamer': ('eksklamere',),
'eksklamere': ('eksklamere',),
'eksklamerer': ('eksklamere',),
'eksklameres': ('eksklamere',),
'eksklamert': ('eksklamere',),
'eksklamerte': ('eksklamere',),
'ekskluder': ('ekskludere',),
'ekskludere': ('ekskludere',),
'ekskluderer': ('ekskludere',),
'ekskluderes': ('ekskludere',),
'ekskludert': ('ekskludere',),
'ekskluderte': ('ekskludere',),
'ekskommuniser': ('ekskommunisere',),
'ekskommunisere': ('ekskommunisere',),
'ekskommuniserer': ('ekskommunisere',),
'ekskommuniseres': ('ekskommunisere',),
'ekskommunisert': ('ekskommunisere',),
'ekskommuniserte': ('ekskommunisere',),
'ekspander': ('ekspandere',),
'ekspandere': ('ekspandere',),
'ekspanderer': ('ekspandere',),
'ekspanderes': ('ekspandere',),
'ekspandert': ('ekspandere',),
'ekspanderte': ('ekspandere',),
'ekspatrier': ('ekspatriere',),
'ekspatriere': ('ekspatriere',),
'ekspatrierer': ('ekspatriere',),
'ekspatrieres': ('ekspatriere',),
'ekspatriert': ('ekspatriere',),
'ekspatrierte': ('ekspatriere',),
'ekspeder': ('ekspedere',),
'ekspedere': ('ekspedere',),
'ekspederer': ('ekspedere',),
'ekspederes': ('ekspedere',),
'ekspedert': ('ekspedere',),
'ekspederte': ('ekspedere',),
'eksperimenter': ('eksperimentere',),
'eksperimentere': ('eksperimentere',),
'eksperimenterer': ('eksperimentere',),
'eksperimenteres': ('eksperimentere',),
'eksperimentert': ('eksperimentere',),
'eksperimenterte': ('eksperimentere',),
'ekspirer': ('ekspirere',),
'ekspirere': ('ekspirere',),
'ekspirerer': ('ekspirere',),
'ekspireres': ('ekspirere',),
'ekspirert': ('ekspirere',),
'ekspirerte': ('ekspirere',),
'eksplisitter': ('eksplisittere',),
'eksplisittere': ('eksplisittere',),
'eksplisitterer': ('eksplisittere',),
'eksplisitteres': ('eksplisittere',),
'eksplisittert': ('eksplisittere',),
'eksplisitterte': ('eksplisittere',),
'eksploater': ('eksploatere',),
'eksploatere': ('eksploatere',),
'eksploaterer': ('eksploatere',),
'eksploateres': ('eksploatere',),
'eksploatert': ('eksploatere',),
'eksploaterte': ('eksploatere',),
'eksploder': ('eksplodere',),
'eksplodere': ('eksplodere',),
'eksploderer': ('eksplodere',),
'eksploderes': ('eksplodere',),
'eksplodert': ('eksplodere',),
'eksploderte': ('eksplodere',),
'eksponer': ('eksponere',),
'eksponere': ('eksponere',),
'eksponerer': ('eksponere',),
'eksponeres': ('eksponere',),
'eksponert': ('eksponere',),
'eksponerte': ('eksponere',),
'eksporter': ('eksportere',),
'eksportere': ('eksportere',),
'eksporterer': ('eksportere',),
'eksporteres': ('eksportere',),
'eksportert': ('eksportere',),
'eksporterte': ('eksportere',),
'eksproprier': ('ekspropriere',),
'ekspropriere': ('ekspropriere',),
'eksproprierer': ('ekspropriere',),
'eksproprieres': ('ekspropriere',),
'ekspropriert': ('ekspropriere',),
'eksproprierte': ('ekspropriere',),
'ekstemporer': ('ekstemporere',),
'ekstemporere': ('ekstemporere',),
'ekstemporerer': ('ekstemporere',),
'ekstemporeres': ('ekstemporere',),
'ekstemporert': ('ekstemporere',),
'ekstemporerte': ('ekstemporere',),
'ekstensiver': ('ekstensivere',),
'ekstensivere': ('ekstensivere',),
'ekstensiverer': ('ekstensivere',),
'ekstensiveres': ('ekstensivere',),
'ekstensivert': ('ekstensivere',),
'ekstensiverte': ('ekstensivere',),
'ekstraher': ('ekstrahere',),
'ekstrahere': ('ekstrahere',),
'ekstraherer': ('ekstrahere',),
'ekstraheres': ('ekstrahere',),
'ekstrahert': ('ekstrahere',),
'ekstraherte': ('ekstrahere',),
'ekstrapoler': ('ekstrapolere',),
'ekstrapolere': ('ekstrapolere',),
'ekstrapolerer': ('ekstrapolere',),
'ekstrapoleres': ('ekstrapolere',),
'ekstrapolert': ('ekstrapolere',),
'ekstrapolerte': ('ekstrapolere',),
'ekt': ('ekte',),
'ekta': ('ekte',),
'ekte': ('ekte',),
'ekter': ('ekte',),
'ektes': ('ekte',),
'ektet': ('ekte',),
'ektevi': ('ektevie',),
'ektevia': ('ektevie',),
'ektevidd': ('ektevie',),
'ektevidde': ('ektevie',),
'ektevie': ('ektevie',),
'ektevier': ('ektevie',),
'ektevies': ('ektevie',),
'ekteviet': ('ektevie',),
'ektevigd': ('ektevie',),
'ektevigde': ('ektevie',),
'ekviper': ('ekvipere',),
'ekvipere': ('ekvipere',),
'ekviperer': ('ekvipere',),
'ekviperes': ('ekvipere',),
'ekvipert': ('ekvipere',),
'ekviperte': ('ekvipere',),
'ekvivaler': ('ekvivalere',),
'ekvivalere': ('ekvivalere',),
'ekvivalerer': ('ekvivalere',),
'ekvivaleres': ('ekvivalere',),
'ekvivalert': ('ekvivalere',),
'ekvivalerte': ('ekvivalere',),
'eld': ('elde',),
'elda': ('elde',),
'elde': ('elde',),
'elder': ('elde',),
'eldes': ('elde',),
'eldet': ('elde',),
'eld': ('elde',),
'elda': ('elde',),
'elde': ('elde',),
'elder': ('elde',),
'eldes': ('elde',),
'eldet': ('elde',),
'eld': ('elde',),
'elda': ('elde',),
'elde': ('elde',),
'elder': ('elde',),
'eldes': ('elde',),
'eldet': ('elde',),
'eldedes': ('eldes',),
'eldes': ('eldes',),
'elektrifiser': ('elektrifisere',),
'elektrifisere': ('elektrifisere',),
'elektrifiserer': ('elektrifisere',),
'elektrifiseres': ('elektrifisere',),
'elektrifisert': ('elektrifisere',),
'elektrifiserte': ('elektrifisere',),
'elektriser': ('elektrisere',),
'elektrisere': ('elektrisere',),
'elektriserer': ('elektrisere',),
'elektriseres': ('elektrisere',),
'elektrisert': ('elektrisere',),
'elektriserte': ('elektrisere',),
'elever': ('elevere',),
'elevere': ('elevere',),
'eleverer': ('elevere',),
'eleveres': ('elevere',),
'elevert': ('elevere',),
'eleverte': ('elevere',),
'eliger': ('eligere',),
'eligere': ('eligere',),
'eligerer': ('eligere',),
'eligeres': ('eligere',),
'eligert': ('eligere',),
'eligerte': ('eligere',),
'eliminer': ('eliminere',),
'eliminere': ('eliminere',),
'eliminerer': ('eliminere',),
'elimineres': ('eliminere',),
'eliminert': ('eliminere',),
'eliminerte': ('eliminere',),
'ell': ('elle',),
'ella': ('elle',),
'elle': ('elle',),
'eller': ('elle',),
'elles': ('elle',),
'ellet': ('elle',),
'elokser': ('eloksere',),
'eloksere': ('eloksere',),
'elokserer': ('eloksere',),
'elokseres': ('eloksere',),
'eloksert': ('eloksere',),
'elokserte': ('eloksere',),
'elsk': ('elske',),
'elska': ('elske',),
'elske': ('elske',),
'elsker': ('elske',),
'elskes': ('elske',),
'elsket': ('elske',),
'elt': ('elte',),
'elta': ('elte',),
'elte': ('elte',),
'elter': ('elte',),
'eltes': ('elte',),
'eltet': ('elte',),
'eluder': ('eludere',),
'eludere': ('eludere',),
'eluderer': ('eludere',),
'eluderes': ('eludere',),
'eludert': ('eludere',),
'eluderte': ('eludere',),
'emaljer': ('emaljere',),
'emaljere': ('emaljere',),
'emaljerer': ('emaljere',),
'emaljeres': ('emaljere',),
'emaljert': ('emaljere',),
'emaljerte': ('emaljere',),
'emansiper': ('emansipere',),
'emansipere': ('emansipere',),
'emansiperer': ('emansipere',),
'emansiperes': ('emansipere',),
'emansipert': ('emansipere',),
'emansiperte': ('emansipere',),
'emballer': ('emballere',),
'emballere': ('emballere',),
'emballerer': ('emballere',),
'emballeres': ('emballere',),
'emballert': ('emballere',),
'emballerte': ('emballere',),
'embarker': ('embarkere',),
'embarkere': ('embarkere',),
'embarkerer': ('embarkere',),
'embarkeres': ('embarkere',),
'embarkert': ('embarkere',),
'embarkerte': ('embarkere',),
'emigrer': ('emigrere',),
'emigrere': ('emigrere',),
'emigrerer': ('emigrere',),
'emigreres': ('emigrere',),
'emigrert': ('emigrere',),
'emigrerte': ('emigrere',),
'emitter': ('emittere',),
'emittere': ('emittere',),
'emitterer': ('emittere',),
'emitteres': ('emittere',),
'emittert': ('emittere',),
'emitterte': ('emittere',),
'emn': ('emne',),
'emna': ('emne',),
'emne': ('emne',),
'emner': ('emne',),
'emnes': ('emne',),
'emnet': ('emne',),
'employer': ('employere',),
'employere': ('employere',),
'employerer': ('employere',),
'employeres': ('employere',),
'employert': ('employere',),
'employerte': ('employere',),
'emulger': ('emulgere',),
'emulgere': ('emulgere',),
'emulgerer': ('emulgere',),
'emulgeres': ('emulgere',),
'emulgert': ('emulgere',),
'emulgerte': ('emulgere',),
'end': ('ende',),
'ende': ('ende',),
'ender': ('ende',),
'endes': ('ende',),
'endt': ('ende',),
'endte': ('ende',),
'endevend': ('endevende',),
'endevende': ('endevende',),
'endevender': ('endevende',),
'endevendes': ('endevende',),
'endevendt': ('endevende',),
'endevendte': ('endevende',),
'endosser': ('endossere',),
'endossere': ('endossere',),
'endosserer': ('endossere',),
'endosseres': ('endossere',),
'endossert': ('endossere',),
'endosserte': ('endossere',),
'endr': ('endre',),
'endra': ('endre',),
'endre': ('endre',),
'endrer': ('endre',),
'endres': ('endre',),
'endret': ('endre',),
'en': ('ene',),
'ene': ('ene',),
'ener': ('ene',),
'enes': ('ene',),
'ent': ('ene',),
'ente': ('ene',),
'enerver': ('enervere',),
'enervere': ('enervere',),
'enerverer': ('enervere',),
'enerveres': ('enervere',),
'enervert': ('enervere',),
'enerverte': ('enervere',),
'enes': ('enes',),
'entes': ('enes',),
'engasjer': ('engasjere',),
'engasjere': ('engasjere',),
'engasjerer': ('engasjere',),
'engasjeres': ('engasjere',),
'engasjert': ('engasjere',),
'engasjerte': ('engasjere',),
'engst': ('engste',),
'engsta': ('engste',),
'engste': ('engste',),
'engster': ('engste',),
'engstes': ('engste',),
'engstet': ('engste',),
'ens': ('ense',),
'ensa': ('ense',),
'ense': ('ense',),
'enser': ('ense',),
'enses': ('ense',),
'enset': ('ense',),
'enst': ('ense',),
'enste': ('ense',),
'ensiler': ('ensilere',),
'ensilere': ('ensilere',),
'ensilerer': ('ensilere',),
'ensileres': ('ensilere',),
'ensilert': ('ensilere',),
'ensilerte': ('ensilere',),
'ensrett': ('ensrette',),
'ensretta': ('ensrette',),
'ensrette': ('ensrette',),
'ensretter': ('ensrette',),
'ensrettes': ('ensrette',),
'ensrettet': ('ensrette',),
'entr': ('entre',),
'entra': ('entre',),
'entre': ('entre',),
'entrer': ('entre',),
'entres': ('entre',),
'entret': ('entre',),
'envegsreguler': ('envegsregulere',),
'envegsregulere': ('envegsregulere',),
'envegsregulerer': ('envegsregulere',),
'envegsreguleres': ('envegsregulere',),
'envegsregulert': ('envegsregulere',),
'envegsregulerte': ('envegsregulere',),
'enveisreguler': ('enveisregulere',),
'enveisregulere': ('enveisregulere',),
'enveisregulerer': ('enveisregulere',),
'enveisreguleres': ('enveisregulere',),
'enveisregulert': ('enveisregulere',),
'enveisregulerte': ('enveisregulere',),
'erfar': ('erfare',),
'erfare': ('erfare',),
'erfarer': ('erfare',),
'erfares': ('erfare',),
'erfart': ('erfare',),
'erfarte': ('erfare',),
'erfor': ('erfare',),
'ergr': ('ergre',),
'ergra': ('ergre',),
'ergre': ('ergre',),
'ergrer': ('ergre',),
'ergres': ('ergre',),
'ergret': ('ergre',),
'erhold': ('erholde',),
'erholde': ('erholde',),
'erholder': ('erholde',),
'erholdes': ('erholde',),
'erholdt': ('erholde',),
'eriger': ('erigere',),
'erigere': ('erigere',),
'erigerer': ('erigere',),
'erigeres': ('erigere',),
'erigert': ('erigere',),
'erigerte': ('erigere',),
'erindr': ('erindre',),
'erindra': ('erindre',),
'erindre': ('erindre',),
'erindrer': ('erindre',),
'erindres': ('erindre',),
'erindret': ('erindre',),
'erkjenn': ('erkjenne',),
'erkjenne': ('erkjenne',),
'erkjenner': ('erkjenne',),
'erkjennes': ('erkjenne',),
'erkjent': ('erkjenne',),
'erkjente': ('erkjenne',),
'erklær': ('erklære',),
'erklære': ('erklære',),
'erklærer': ('erklære',),
'erklæres': ('erklære',),
'erklært': ('erklære',),
'erklærte': ('erklære',),
'erla': ('erlegge',),
'erlagt': ('erlegge',),
'erlegg': ('erlegge',),
'erlegge': ('erlegge',),
'erlegger': ('erlegge',),
'erlegges': ('erlegge',),
'ernær': ('ernære',),
'ernære': ('ernære',),
'ernærer': ('ernære',),
'ernæres': ('ernære',),
'ernært': ('ernære',),
'ernærte': ('ernære',),
'erobr': ('erobre',),
'erobra': ('erobre',),
'erobre': ('erobre',),
'erobrer': ('erobre',),
'erobres': ('erobre',),
'erobret': ('erobre',),
'eroder': ('erodere',),
'erodere': ('erodere',),
'eroderer': ('erodere',),
'eroderes': ('erodere',),
'erodert': ('erodere',),
'eroderte': ('erodere',),
'erotiser': ('erotisere',),
'erotisere': ('erotisere',),
'erotiserer': ('erotisere',),
'erotiseres': ('erotisere',),
'erotisert': ('erotisere',),
'erotiserte': ('erotisere',),
'erstatt': ('erstatte',),
'erstatta': ('erstatte',),
'erstatte': ('erstatte',),
'erstatter': ('erstatte',),
'erstattes': ('erstatte',),
'erstattet': ('erstatte',),
'ert': ('erte',),
'erta': ('erte',),
'erte': ('erte',),
'erter': ('erte',),
'ertes': ('erte',),
'ertet': ('erte',),
'erverv': ('erverve',),
'erverva': ('erverve',),
'erverve': ('erverve',),
'erverver': ('erverve',),
'erverves': ('erverve',),
'ervervet': ('erverve',),
'es': ('ese',),
'ese': ('ese',),
'eser': ('ese',),
'eses': ('ese',),
'est': ('ese',),
'este': ('ese',),
'eskaler': ('eskalere',),
'eskalere': ('eskalere',),
'eskalerer': ('eskalere',),
'eskaleres': ('eskalere',),
'eskalert': ('eskalere',),
'eskalerte': ('eskalere',),
'eskamoter': ('eskamotere',),
'eskamotere': ('eskamotere',),
'eskamoterer': ('eskamotere',),
'eskamoteres': ('eskamotere',),
'eskamotert': ('eskamotere',),
'eskamoterte': ('eskamotere',),
'eskaper': ('eskapere',),
'eskapere': ('eskapere',),
'eskaperer': ('eskapere',),
'eskaperes': ('eskapere',),
'eskapert': ('eskapere',),
'eskaperte': ('eskapere',),
'esk': ('eske',),
'eska': ('eske',),
'eske': ('eske',),
'esker': ('eske',),
'eskes': ('eske',),
'esket': ('eske',),
'eskorter': ('eskortere',),
'eskortere': ('eskortere',),
'eskorterer': ('eskortere',),
'eskorteres': ('eskortere',),
'eskortert': ('eskortere',),
'eskorterte': ('eskortere',),
'esl': ('esle',),
'esla': ('esle',),
'esle': ('esle',),
'esler': ('esle',),
'esles': ('esle',),
'eslet': ('esle',),
'estetiser': ('estetisere',),
'estetisere': ('estetisere',),
'estetiserer': ('estetisere',),
'estetiseres': ('estetisere',),
'estetisert': ('estetisere',),
'estetiserte': ('estetisere',),
'estimer': ('estimere',),
'estimere': ('estimere',),
'estimerer': ('estimere',),
'estimeres': ('estimere',),
'estimert': ('estimere',),
'estimerte': ('estimere',),
'etabler': ('etablere',),
'etablere': ('etablere',),
'etablerer': ('etablere',),
'etableres': ('etablere',),
'etablert': ('etablere',),
'etablerte': ('etablere',),
'et': ('ete',),
'ete': ('ete',),
'eter': ('ete',),
'etes': ('ete',),
'ett': ('ete',),
'åt': ('ete',),
'etiketter': ('etikettere',),
'etikettere': ('etikettere',),
'etiketterer': ('etikettere',),
'etiketteres': ('etikettere',),
'etikettert': ('etikettere',),
'etiketterte': ('etikettere',),
'etl': ('etle',),
'etla': ('etle',),
'etle': ('etle',),
'etler': ('etle',),
'etles': ('etle',),
'etlet': ('etle',),
'ets': ('etse',),
'etsa': ('etse',),
'etse': ('etse',),
'etser': ('etse',),
'etses': ('etse',),
'etset': ('etse',),
'etteranmeld': ('etteranmelde',),
'etteranmelde': ('etteranmelde',),
'etteranmelder': ('etteranmelde',),
'etteranmeldes': ('etteranmelde',),
'etteranmeldt': ('etteranmelde',),
'etteranmeldte': ('etteranmelde',),
'etterap': ('etterape',),
'etterapa': ('etterape',),
'etterape': ('etterape',),
'etteraper': ('etterape',),
'etterapes': ('etterape',),
'etterapet': ('etterape',),
'etterapt': ('etterape',),
'etterapte': ('etterape',),
'etterbehandl': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandle': ('etterbehandle',),
'etterbehandler': ('etterbehandle',),
'etterbehandles': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbetal': ('etterbetale',),
'etterbetale': ('etterbetale',),
'etterbetaler': ('etterbetale',),
'etterbetales': ('etterbetale',),
'etterbetalt': ('etterbetale',),
'etterbetalte': ('etterbetale',),
'etterforsk': ('etterforske',),
'etterforska': ('etterforske',),
'etterforske': ('etterforske',),
'etterforsker': ('etterforske',),
'etterforskes': ('etterforske',),
'etterforsket': ('etterforske',),
'etterfyll': ('etterfylle',),
'etterfylle': ('etterfylle',),
'etterfyller': ('etterfylle',),
'etterfylles': ('etterfylle',),
'etterfylt': ('etterfylle',),
'etterfylte': ('etterfylle',),
'etterga': ('ettergi',),
'ettergav': ('ettergi',),
'ettergi': ('ettergi',),
'ettergies': ('ettergi',),
'ettergir': ('ettergi',),
'ettergis': ('ettergi',),
'ettergitt': ('ettergi',),
'ettergjorde': ('ettergjøre',),
'ettergjort': ('ettergjøre',),
'ettergjør': ('ettergjøre',),
'ettergjøre': ('ettergjøre',),
'ettergjøres': ('ettergjøre',),
'etterisoler': ('etterisolere',),
'etterisolere': ('etterisolere',),
'etterisolerer': ('etterisolere',),
'etterisoleres': ('etterisolere',),
'etterisolert': ('etterisolere',),
'etterisolerte': ('etterisolere',),
'etterlat': ('etterlate',),
'etterlate': ('etterlate',),
'etterlater': ('etterlate',),
'etterlates': ('etterlate',),
'etterlatt': ('etterlate',),
'etterlot': ('etterlate',),
'etterlev': ('etterleve',),
'etterlevd': ('etterleve',),
'etterlevde': ('etterleve',),
'etterleve': ('etterleve',),
'etterlever': ('etterleve',),
'etterleves': ('etterleve',),
'etterlign': ('etterligne',),
'etterligna': ('etterligne',),
'etterligne': ('etterligne',),
'etterligner': ('etterligne',),
'etterlignes': ('etterligne',),
'etterlignet': ('etterligne',),
'etterlikn': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterlikne': ('etterlikne',),
'etterlikner': ('etterlikne',),
'etterliknes': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterlys': ('etterlyse',),
'etterlyse': ('etterlyse',),
'etterlyser': ('etterlyse',),
'etterlyses': ('etterlyse',),
'etterlyst': ('etterlyse',),
'etterlyste': ('etterlyse',),
'etterplapr': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplapre': ('etterplapre',),
'etterplaprer': ('etterplapre',),
'etterplapres': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterprøv': ('etterprøve',),
'etterprøvd': ('etterprøve',),
'etterprøvde': ('etterprøve',),
'etterprøve': ('etterprøve',),
'etterprøver': ('etterprøve',),
'etterprøves': ('etterprøve',),
'etterse': ('etterse',),
'ettersees': ('etterse',),
'etterser': ('etterse',),
'etterses': ('etterse',),
'ettersett': ('etterse',),
'etterså': ('etterse',),
'ettersåg': ('etterse',),
'ettersend': ('ettersende',),
'ettersende': ('ettersende',),
'ettersender': ('ettersende',),
'ettersendes': ('ettersende',),
'ettersendt': ('ettersende',),
'ettersendte': ('ettersende',),
'etterslokk': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokke': ('etterslokke',),
'etterslokker': ('etterslokke',),
'etterslokkes': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokt': ('etterslokke',),
'etterslokte': ('etterslokke',),
'etterslukk': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukke': ('etterslukke',),
'etterslukker': ('etterslukke',),
'etterslukkes': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukt': ('etterslukke',),
'etterslukte': ('etterslukke',),
'etterspor': ('etterspore',),
'etterspora': ('etterspore',),
'etterspore': ('etterspore',),
'ettersporer': ('etterspore',),
'etterspores': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersport': ('etterspore',),
'ettersporte': ('etterspore',),
'etterstreb': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebe': ('etterstrebe',),
'etterstreber': ('etterstrebe',),
'etterstrebes': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'ettersynkroniser': ('ettersynkronisere',),
'ettersynkronisere': ('ettersynkronisere',),
'ettersynkroniserer': ('ettersynkronisere',),
'ettersynkroniseres': ('ettersynkronisere',),
'ettersynkronisert': ('ettersynkronisere',),
'ettersynkroniserte': ('ettersynkronisere',),
'ettersøk': ('ettersøke',),
'ettersøke': ('ettersøke',),
'ettersøker': ('ettersøke',),
'ettersøkes': ('ettersøke',),
'ettersøkt': ('ettersøke',),
'ettersøkte': ('ettersøke',),
'ettertrakt': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertrakte': ('ettertrakte',),
'ettertrakter': ('ettertrakte',),
'ettertraktes': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'europeiser': ('europeisere',),
'europeisere': ('europeisere',),
'europeiserer': ('europeisere',),
'europeiseres': ('europeisere',),
'europeisert': ('europeisere',),
'europeiserte': ('europeisere',),
'evakuer': ('evakuere',),
'evakuere': ('evakuere',),
'evakuerer': ('evakuere',),
'evakueres': ('evakuere',),
'evakuert': ('evakuere',),
'evakuerte': ('evakuere',),
'evaluer': ('evaluere',),
'evaluere': ('evaluere',),
'evaluerer': ('evaluere',),
'evalueres': ('evaluere',),
'evaluert': ('evaluere',),
'evaluerte': ('evaluere',),
'evangeliser': ('evangelisere',),
'evangelisere': ('evangelisere',),
'evangeliserer': ('evangelisere',),
'evangeliseres': ('evangelisere',),
'evangelisert': ('evangelisere',),
'evangeliserte': ('evangelisere',),
'evaporer': ('evaporere',),
'evaporere': ('evaporere',),
'evaporerer': ('evaporere',),
'evaporeres': ('evaporere',),
'evaporert': ('evaporere',),
'evaporerte': ('evaporere',),
'ev': ('eve',),
'eva': ('eve',),
'eve': ('eve',),
'ever': ('eve',),
'eves': ('eve',),
'evet': ('eve',),
'evn': ('evne',),
'evna': ('evne',),
'evne': ('evne',),
'evner': ('evne',),
'evnes': ('evne',),
'evnet': ('evne',),
'ex': ('exe',),
'exa': ('exe',),
'exe': ('exe',),
'exer': ('exe',),
'exes': ('exe',),
'exet': ('exe',),
'exit': ('exit',),
'fôr': ('fôre',),
'fôra': ('fôre',),
'fôre': ('fôre',),
'fôrer': ('fôre',),
'fôres': ('fôre',),
'fôret': ('fôre',),
'fôrt': ('fôre',),
'fôrte': ('fôre',),
'fôr': ('fôre',),
'fôra': ('fôre',),
'fôre': ('fôre',),
'fôrer': ('fôre',),
'fôres': ('fôre',),
'fôret': ('fôre',),
'fôrt': ('fôre',),
'fôrte': ('fôre',),
'fabl': ('fable',),
'fabla': ('fable',),
'fable': ('fable',),
'fabler': ('fable',),
'fables': ('fable',),
'fablet': ('fable',),
'fabrikker': ('fabrikkere',),
'fabrikkere': ('fabrikkere',),
'fabrikkerer': ('fabrikkere',),
'fabrikkeres': ('fabrikkere',),
'fabrikkert': ('fabrikkere',),
'fabrikkerte': ('fabrikkere',),
'fabuler': ('fabulere',),
'fabulere': ('fabulere',),
'fabulerer': ('fabulere',),
'fabuleres': ('fabulere',),
'fabulert': ('fabulere',),
'fabulerte': ('fabulere',),
'fad': ('fade',),
'fada': ('fade',),
'fade': ('fade',),
'fader': ('fade',),
'fades': ('fade',),
'fadet': ('fade',),
'fagn': ('fagne',),
'fagna': ('fagne',),
'fagne': ('fagne',),
'fagner': ('fagne',),
'fagnes': ('fagne',),
'fagnet': ('fagne',),
'fakk': ('fakke',),
'fakka': ('fakke',),
'fakke': ('fakke',),
'fakker': ('fakke',),
'fakkes': ('fakke',),
'fakket': ('fakke',),
'faks': ('fakse',),
'faksa': ('fakse',),
'fakse': ('fakse',),
'fakser': ('fakse',),
'fakses': ('fakse',),
'fakset': ('fakse',),
'faksimiler': ('faksimilere',),
'faksimilere': ('faksimilere',),
'faksimilerer': ('faksimilere',),
'faksimileres': ('faksimilere',),
'faksimilert': ('faksimilere',),
'faksimilerte': ('faksimilere',),
'faktoriser': ('faktorisere',),
'faktorisere': ('faktorisere',),
'faktoriserer': ('faktorisere',),
'faktoriseres': ('faktorisere',),
'faktorisert': ('faktorisere',),
'faktoriserte': ('faktorisere',),
'fakturer': ('fakturere',),
'fakturere': ('fakturere',),
'fakturerer': ('fakturere',),
'faktureres': ('fakturere',),
'fakturert': ('fakturere',),
'fakturerte': ('fakturere',),
'falbaud': ('falby',),
'falbudt': ('falby',),
'falby': ('falby',),
'falbydd': ('falby',),
'falbydde': ('falby',),
'falbyr': ('falby',),
'falbys': ('falby',),
'falbød': ('falby',),
'falbøy': ('falby',),
'fald': ('falde',),
'falda': ('falde',),
'falde': ('falde',),
'falder': ('falde',),
'faldes': ('falde',),
'faldet': ('falde',),
'fall': ('falle',),
'falle': ('falle',),
'faller': ('falle',),
'falles': ('falle',),
'falt': ('falle',),
'faller': ('fallere',),
'fallere': ('fallere',),
'fallerer': ('fallere',),
'falleres': ('fallere',),
'fallert': ('fallere',),
'fallerte': ('fallere',),
'falm': ('falme',),
'falma': ('falme',),
'falme': ('falme',),
'falmer': ('falme',),
'falmes': ('falme',),
'falmet': ('falme',),
'fals': ('false',),
'falsa': ('false',),
'false': ('false',),
'falser': ('false',),
'falses': ('false',),
'falset': ('false',),
'falsifiser': ('falsifisere',),
'falsifisere': ('falsifisere',),
'falsifiserer': ('falsifisere',),
'falsifiseres': ('falsifisere',),
'falsifisert': ('falsifisere',),
'falsifiserte': ('falsifisere',),
'faml': ('famle',),
'famla': ('famle',),
'famle': ('famle',),
'famler': ('famle',),
'famles': ('famle',),
'famlet': ('famle',),
'famn': ('famne',),
'famna': ('famne',),
'famne': ('famne',),
'famner': ('famne',),
'famnes': ('famne',),
'famnet': ('famne',),
'famn': ('famne',),
'famna': ('famne',),
'famne': ('famne',),
'famner': ('famne',),
'famnes': ('famne',),
'famnet': ('famne',),
'fang': ('fange',),
'fanga': ('fange',),
'fange': ('fange',),
'fanger': ('fange',),
'fanges': ('fange',),
'fanget': ('fange',),
'fangst': ('fangste',),
'fangsta': ('fangste',),
'fangste': ('fangste',),
'fangster': ('fangste',),
'fangstes': ('fangste',),
'fangstet': ('fangste',),
'fantaser': ('fantasere',),
'fantasere': ('fantasere',),
'fantaserer': ('fantasere',),
'fantaseres': ('fantasere',),
'fantasert': ('fantasere',),
'fantaserte': ('fantasere',),
'fantegikk': ('fantegå',),
'fantegjekk': ('fantegå',),
'fantegå': ('fantegå',),
'fantegåes': ('fantegå',),
'fantegår': ('fantegå',),
'fantegås': ('fantegå',),
'fantegått': ('fantegå',),
'far': ('fare',),
'fare': ('fare',),
'farer': ('fare',),
'fares': ('fare',),
'fart': ('fare',),
'for': ('fare',),
'farg': ('farge',),
'farga': ('farge',),
'farge': ('farge',),
'farger': ('farge',),
'farges': ('farge',),
'farget': ('farge',),
'farser': ('farsere',),
'farsere': ('farsere',),
'farserer': ('farsere',),
'farseres': ('farsere',),
'farsert': ('farsere',),
'farserte': ('farsere',),
'fart': ('farte',),
'farta': ('farte',),
'farte': ('farte',),
'farter': ('farte',),
'fartes': ('farte',),
'fartet': ('farte',),
'fasciner': ('fascinere',),
'fascinere': ('fascinere',),
'fascinerer': ('fascinere',),
'fascineres': ('fascinere',),
'fascinert': ('fascinere',),
'fascinerte': ('fascinere',),
'fas': ('fase',),
'fasa': ('fase',),
'fase': ('fase',),
'faser': ('fase',),
'fases': ('fase',),
'faset': ('fase',),
'fasetter': ('fasettere',),
'fasettere': ('fasettere',),
'fasetterer': ('fasettere',),
'fasetteres': ('fasettere',),
'fasettert': ('fasettere',),
'fasetterte': ('fasettere',),
'fasl': ('fasle',),
'fasla': ('fasle',),
'fasle': ('fasle',),
'fasler': ('fasle',),
'fasles': ('fasle',),
'faslet': ('fasle',),
'fasonger': ('fasongere',),
'fasongere': ('fasongere',),
'fasongerer': ('fasongere',),
'fasongeres': ('fasongere',),
'fasongert': ('fasongere',),
'fasongerte': ('fasongere',),
'fast': ('faste',),
'fasta': ('faste',),
'faste': ('faste',),
'faster': ('faste',),
'fastes': ('faste',),
'fastet': ('faste',),
'fasthold': ('fastholde',),
'fastholde': ('fastholde',),
'fastholder': ('fastholde',),
'fastholdes': ('fastholde',),
'fastholdt': ('fastholde',),
'fastla': ('fastlegge',),
'fastlagt': ('fastlegge',),
'fastlegg': ('fastlegge',),
'fastlegge': ('fastlegge',),
'fastlegger': ('fastlegge',),
'fastlegges': ('fastlegge',),
'fastlås': ('fastlåse',),
'fastlåse': ('fastlåse',),
'fastlåser': ('fastlåse',),
'fastlåses': ('fastlåse',),
'fastlåst': ('fastlåse',),
'fastlåste': ('fastlåse',),
'fastn': ('fastne',),
'fastna': ('fastne',),
'fastne': ('fastne',),
'fastner': ('fastne',),
'fastnes': ('fastne',),
'fastnet': ('fastne',),
'fastsatt': ('fastsette',),
'fastsatte': ('fastsette',),
'fastsett': ('fastsette',),
'fastsette': ('fastsette',),
'fastsetter': ('fastsette',),
'fastsettes': ('fastsette',),
'fat': ('fate',),
'fata': ('fate',),
'fate': ('fate',),
'fater': ('fate',),
'fates': ('fate',),
'fatet': ('fate',),
'fatl': ('fatle',),
'fatla': ('fatle',),
'fatle': ('fatle',),
'fatler': ('fatle',),
'fatles': ('fatle',),
'fatlet': ('fatle',),
'fatt': ('fatte',),
'fatta': ('fatte',),
'fatte': ('fatte',),
'fatter': ('fatte',),
'fattes': ('fatte',),
'fattet': ('fatte',),
'fattedes': ('fattes',),
'fattes': ('fattes',),
'favn': ('favne',),
'favna': ('favne',),
'favne': ('favne',),
'favner': ('favne',),
'favnes': ('favne',),
'favnet': ('favne',),
'favn': ('favne',),
'favna': ('favne',),
'favne': ('favne',),
'favner': ('favne',),
'favnes': ('favne',),
'favnet': ('favne',),
'favoriser': ('favorisere',),
'favorisere': ('favorisere',),
'favoriserer': ('favorisere',),
'favoriseres': ('favorisere',),
'favorisert': ('favorisere',),
'favoriserte': ('favorisere',),
'feid': ('feide',),
'feida': ('feide',),
'feide': ('feide',),
'feider': ('feide',),
'feides': ('feide',),
'feidet': ('feide',),
'fei': ('feie',),
'feia': ('feie',),
'feid': ('feie',),
'feide': ('feie',),
'feie': ('feie',),
'feier': ('feie',),
'feies': ('feie',),
'feiet': ('feie',),
'feilbedøm': ('feilbedømme',),
'feilbedømme': ('feilbedømme',),
'feilbedømmer': ('feilbedømme',),
'feilbedømmes': ('feilbedømme',),
'feilbedømt': ('feilbedømme',),
'feilbedømte': ('feilbedømme',),
'feil': ('feile',),
'feila': ('feile',),
'feile': ('feile',),
'feiler': ('feile',),
'feiles': ('feile',),
'feilet': ('feile',),
'feilt': ('feile',),
'feilte': ('feile',),
'feilvurder': ('feilvurdere',),
'feilvurdere': ('feilvurdere',),
'feilvurderer': ('feilvurdere',),
'feilvurderes': ('feilvurdere',),
'feilvurdert': ('feilvurdere',),
'feilvurderte': ('feilvurdere',),
'feir': ('feire',),
'feira': ('feire',),
'feire': ('feire',),
'feirer': ('feire',),
'feires': ('feire',),
'feiret': ('feire',),
'feit': ('feite',),
'feita': ('feite',),
'feite': ('feite',),
'feiter': ('feite',),
'feites': ('feite',),
'feitet': ('feite',),
'feitn': ('feitne',),
'feitna': ('feitne',),
'feitne': ('feitne',),
'feitner': ('feitne',),
'feitnes': ('feitne',),
'feitnet': ('feitne',),
'fekt': ('fekte',),
'fekta': ('fekte',),
'fekte': ('fekte',),
'fekter': ('fekte',),
'fektes': ('fekte',),
'fektet': ('fekte',),
'fell': ('felle',),
'felle': ('felle',),
'feller': ('felle',),
'felles': ('felle',),
'felt': ('felle',),
'felte': ('felle',),
'femdobl': ('femdoble',),
'femdobla': ('femdoble',),
'femdoble': ('femdoble',),
'femdobler': ('femdoble',),
'femdobles': ('femdoble',),
'femdoblet': ('femdoble',),
'feminiser': ('feminisere',),
'feminisere': ('feminisere',),
'feminiserer': ('feminisere',),
'feminiseres': ('feminisere',),
'feminisert': ('feminisere',),
'feminiserte': ('feminisere',),
'feng': ('fenge',),
'fenga': ('fenge',),
'fenge': ('fenge',),
'fenger': ('fenge',),
'fenges': ('fenge',),
'fenget': ('fenge',),
'fengt': ('fenge',),
'fengte': ('fenge',),
'fengsl': ('fengsle',),
'fengsla': ('fengsle',),
'fengsle': ('fengsle',),
'fengsler': ('fengsle',),
'fengsles': ('fengsle',),
'fengslet': ('fengsle',),
'ferd': ('ferde',),
'ferda': ('ferde',),
'ferde': ('ferde',),
'ferder': ('ferde',),
'ferdes': ('ferde',),
'ferdet': ('ferde',),
'ferdedes': ('ferdes',),
'ferdes': ('ferdes',),
'ferdigbehandl': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandle': ('ferdigbehandle',),
'ferdigbehandler': ('ferdigbehandle',),
'ferdigbehandles': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferg': ('ferge',),
'ferga': ('ferge',),
'ferge': ('ferge',),
'ferger': ('ferge',),
'ferges': ('ferge',),
'ferget': ('ferge',),
'ferier': ('feriere',),
'feriere': ('feriere',),
'ferierer': ('feriere',),
'ferieres': ('feriere',),
'feriert': ('feriere',),
'ferierte': ('feriere',),
'ferj': ('ferje',),
'ferja': ('ferje',),
'ferje': ('ferje',),
'ferjer': ('ferje',),
'ferjes': ('ferje',),
'ferjet': ('ferje',),
'ferm': ('ferme',),
'ferma': ('ferme',),
'ferme': ('ferme',),
'fermer': ('ferme',),
'fermes': ('ferme',),
'fermet': ('ferme',),
'fermenter': ('fermentere',),
'fermentere': ('fermentere',),
'fermenterer': ('fermentere',),
'fermenteres': ('fermentere',),
'fermentert': ('fermentere',),
'fermenterte': ('fermentere',),
'fernisser': ('fernissere',),
'fernissere': ('fernissere',),
'fernisserer': ('fernissere',),
'fernisseres': ('fernissere',),
'fernissert': ('fernissere',),
'fernisserte': ('fernissere',),
'fersk': ('ferske',),
'ferska': ('ferske',),
'ferske': ('ferske',),
'fersker': ('ferske',),
'ferskes': ('ferske',),
'fersket': ('ferske',),
'fest': ('feste',),
'festa': ('feste',),
'feste': ('feste',),
'fester': ('feste',),
'festes': ('feste',),
'festet': ('feste',),
'fest': ('feste',),
'festa': ('feste',),
'feste': ('feste',),
'fester': ('feste',),
'festes': ('feste',),
'festet': ('feste',),
'festn': ('festne',),
'festna': ('festne',),
'festne': ('festne',),
'festner': ('festne',),
'festnes': ('festne',),
'festnet': ('festne',),
'fet': ('fete',),
'feta': ('fete',),
'fete': ('fete',),
'feter': ('fete',),
'fetes': ('fete',),
'fetet': ('fete',),
'feter': ('fetere',),
'fetere': ('fetere',),
'feterer': ('fetere',),
'feteres': ('fetere',),
'fetert': ('fetere',),
'feterte': ('fetere',),
'fetn': ('fetne',),
'fetna': ('fetne',),
'fetne': ('fetne',),
'fetner': ('fetne',),
'fetnes': ('fetne',),
'fetnet': ('fetne',),
'fiff': ('fiffe',),
'fiffa': ('fiffe',),
'fiffe': ('fiffe',),
'fiffer': ('fiffe',),
'fiffes': ('fiffe',),
'fiffet': ('fiffe',),
'fight': ('fighte',),
'fighta': ('fighte',),
'fighte': ('fighte',),
'fighter': ('fighte',),
'fightes': ('fighte',),
'fightet': ('fighte',),
'figurer': ('figurere',),
'figurere': ('figurere',),
'figurerer': ('figurere',),
'figureres': ('figurere',),
'figurert': ('figurere',),
'figurerte': ('figurere',),
'fik': ('fike',),
'fika': ('fike',),
'fike': ('fike',),
'fiker': ('fike',),
'fikes': ('fike',),
'fiket': ('fike',),
'fikt': ('fike',),
'fikte': ('fike',),
'fikl': ('fikle',),
'fikla': ('fikle',),
'fikle': ('fikle',),
'fikler': ('fikle',),
'fikles': ('fikle',),
'fiklet': ('fikle',),
'fiks': ('fikse',),
'fiksa': ('fikse',),
'fikse': ('fikse',),
'fikser': ('fikse',),
'fikses': ('fikse',),
'fikset': ('fikse',),
'fikser': ('fiksere',),
'fiksere': ('fiksere',),
'fikserer': ('fiksere',),
'fikseres': ('fiksere',),
'fiksert': ('fiksere',),
'fikserte': ('fiksere',),
'fil': ('file',),
'fila': ('file',),
'file': ('file',),
'filer': ('file',),
'files': ('file',),
'filet': ('file',),
'filt': ('file',),
'filte': ('file',),
'filer': ('filere',),
'filere': ('filere',),
'filerer': ('filere',),
'fileres': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'filer': ('filere',),
'filere': ('filere',),
'filerer': ('filere',),
'fileres': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'filer': ('filere',),
'filere': ('filere',),
'filerer': ('filere',),
'fileres': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'fileter': ('filetere',),
'filetere': ('filetere',),
'fileterer': ('filetere',),
'fileteres': ('filetere',),
'filetert': ('filetere',),
'fileterte': ('filetere',),
'fileter': ('filetere',),
'filetere': ('filetere',),
'fileterer': ('filetere',),
'fileteres': ('filetere',),
'filetert': ('filetere',),
'fileterte': ('filetere',),
'filmatiser': ('filmatisere',),
'filmatisere': ('filmatisere',),
'filmatiserer': ('filmatisere',),
'filmatiseres': ('filmatisere',),
'filmatisert': ('filmatisere',),
'filmatiserte': ('filmatisere',),
'film': ('filme',),
'filma': ('filme',),
'filme': ('filme',),
'filmer': ('filme',),
'filmes': ('filme',),
'filmet': ('filme',),
'filosofer': ('filosofere',),
'filosofere': ('filosofere',),
'filosoferer': ('filosofere',),
'filosoferes': ('filosofere',),
'filosofert': ('filosofere',),
'filosoferte': ('filosofere',),
'filtr': ('filtre',),
'filtra': ('filtre',),
'filtre': ('filtre',),
'filtrer': ('filtre',),
'filtres': ('filtre',),
'filtret': ('filtre',),
'filtrer': ('filtrere',),
'filtrere': ('filtrere',),
'filtrerer': ('filtrere',),
'filtreres': ('filtrere',),
'filtrert': ('filtrere',),
'filtrerte': ('filtrere',),
'finansier': ('finansiere',),
'finansiere': ('finansiere',),
'finansierer': ('finansiere',),
'finansieres': ('finansiere',),
'finansiert': ('finansiere',),
'finansierte': ('finansiere',),
'finer': ('finere',),
'finere': ('finere',),
'finerer': ('finere',),
'fineres': ('finere',),
'finert': ('finere',),
'finerte': ('finere',),
'finfordel': ('finfordele',),
'finfordele': ('finfordele',),
'finfordeler': ('finfordele',),
'finfordeles': ('finfordele',),
'finfordelt': ('finfordele',),
'finfordelte': ('finfordele',),
'finger': ('fingere',),
'fingere': ('fingere',),
'fingerer': ('fingere',),
'fingeres': ('fingere',),
'fingert': ('fingere',),
'fingerte': ('fingere',),
'fingr': ('fingre',),
'fingra': ('fingre',),
'fingre': ('fingre',),
'fingrer': ('fingre',),
'fingres': ('fingre',),
'fingret': ('fingre',),
'finhakk': ('finhakke',),
'finhakka': ('finhakke',),
'finhakke': ('finhakke',),
'finhakker': ('finhakke',),
'finhakkes': ('finhakke',),
'finhakket': ('finhakke',),
'finhøvl': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvle': ('finhøvle',),
'finhøvler': ('finhøvle',),
'finhøvles': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'fininnstill': ('fininnstille',),
'fininnstille': ('fininnstille',),
'fininnstiller': ('fininnstille',),
'fininnstilles': ('fininnstille',),
'fininnstilt': ('fininnstille',),
'fininnstilte': ('fininnstille',),
'finkjem': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemme': ('finkjemme',),
'finkjemmer': ('finkjemme',),
'finkjemmes': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemt': ('finkjemme',),
'finkjemte': ('finkjemme',),
'finmal': ('finmale',),
'finmale': ('finmale',),
'finmaler': ('finmale',),
'finmales': ('finmale',),
'finmalt': ('finmale',),
'finmalte': ('finmale',),
'fann': ('finne',),
'fant': ('finne',),
'finn': ('finne',),
'finne': ('finne',),
'finner': ('finne',),
'finnes': ('finne',),
'funnet': ('finne',),
'fans': ('finnes',),
'fantes': ('finnes',),
'finnes': ('finnes',),
'fins': ('finnes',),
'funnes': ('finnes',),
'finpuss': ('finpusse',),
'finpussa': ('finpusse',),
'finpusse': ('finpusse',),
'finpusser': ('finpusse',),
'finpusses': ('finpusse',),
'finpusset': ('finpusse',),
'finsikt': ('finsikte',),
'finsikta': ('finsikte',),
'finsikte': ('finsikte',),
'finsikter': ('finsikte',),
'finsiktes': ('finsikte',),
'finsiktet': ('finsikte',),
'fint': ('finte',),
'finta': ('finte',),
'finte': ('finte',),
'finter': ('finte',),
'fintes': ('finte',),
'fintet': ('finte',),
'fintalt': ('fintelle',),
'fintalte': ('fintelle',),
'fintell': ('fintelle',),
'fintella': ('fintelle',),
'fintelle': ('fintelle',),
'finteller': ('fintelle',),
'fintelles': ('fintelle',),
'fintellet': ('fintelle',),
'fintelt': ('fintelle',),
'fintelte': ('fintelle',),
'firdobl': ('firdoble',),
'firdobla': ('firdoble',),
'firdoble': ('firdoble',),
'firdobler': ('firdoble',),
'firdobles': ('firdoble',),
'firdoblet': ('firdoble',),
'fir': ('fire',),
'fira': ('fire',),
'fire': ('fire',),
'firer': ('fire',),
'fires': ('fire',),
'firet': ('fire',),
'firt': ('fire',),
'firte': ('fire',),
'firedobl': ('firedoble',),
'firedobla': ('firedoble',),
'firedoble': ('firedoble',),
'firedobler': ('firedoble',),
'firedobles': ('firedoble',),
'firedoblet': ('firedoble',),
'feis': ('fise',),
'fes': ('fise',),
'feset': ('fise',),
'fis': ('fise',),
'fise': ('fise',),
'fiser': ('fise',),
'fises': ('fise',),
'fist': ('fise',),
'fiste': ('fise',),
'fisjoner': ('fisjonere',),
'fisjonere': ('fisjonere',),
'fisjonerer': ('fisjonere',),
'fisjoneres': ('fisjonere',),
'fisjonert': ('fisjonere',),
'fisjonerte': ('fisjonere',),
'fisk': ('fiske',),
'fiska': ('fiske',),
'fiske': ('fiske',),
'fisker': ('fiske',),
'fiskes': ('fiske',),
'fisket': ('fiske',),
'fisk': ('fiske',),
'fiska': ('fiske',),
'fiske': ('fiske',),
'fisker': ('fiske',),
'fiskes': ('fiske',),
'fisket': ('fiske',),
'fisk': ('fiske',),
'fiska': ('fiske',),
'fiske': ('fiske',),
'fisker': ('fiske',),
'fiskes': ('fiske',),
'fisket': ('fiske',),
'fisl': ('fisle',),
'fisla': ('fisle',),
'fisle': ('fisle',),
'fisler': ('fisle',),
'fisles': ('fisle',),
'fislet': ('fisle',),
'fjams': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamse': ('fjamse',),
'fjamser': ('fjamse',),
'fjamses': ('fjamse',),
'fjamset': ('fjamse',),
'fjas': ('fjase',),
'fjasa': ('fjase',),
'fjase': ('fjase',),
'fjaser': ('fjase',),
'fjases': ('fjase',),
'fjaset': ('fjase',),
'fjast': ('fjase',),
'fjaste': ('fjase',),
'fjelg': ('fjelge',),
'fjelga': ('fjelge',),
'fjelge': ('fjelge',),
'fjelger': ('fjelge',),
'fjelges': ('fjelge',),
'fjelget': ('fjelge',),
'fjern': ('fjerne',),
'fjerna': ('fjerne',),
'fjerne': ('fjerne',),
'fjerner': ('fjerne',),
'fjernes': ('fjerne',),
'fjernet': ('fjerne',),
'fjernstyr': ('fjernstyre',),
'fjernstyre': ('fjernstyre',),
'fjernstyrer': ('fjernstyre',),
'fjernstyres': ('fjernstyre',),
'fjernstyrt': ('fjernstyre',),
'fjernstyrte': ('fjernstyre',),
'fjert': ('fjerte',),
'fjerta': ('fjerte',),
'fjerte': ('fjerte',),
'fjerter': ('fjerte',),
'fjertes': ('fjerte',),
'fjertet': ('fjerte',),
'fjesk': ('fjeske',),
'fjeska': ('fjeske',),
'fjeske': ('fjeske',),
'fjesker': ('fjeske',),
'fjeskes': ('fjeske',),
'fjesket': ('fjeske',),
'fjetr': ('fjetre',),
'fjetra': ('fjetre',),
'fjetre': ('fjetre',),
'fjetrer': ('fjetre',),
'fjetres': ('fjetre',),
'fjetret': ('fjetre',),
'fjoll': ('fjolle',),
'fjolla': ('fjolle',),
'fjolle': ('fjolle',),
'fjoller': ('fjolle',),
'fjolles': ('fjolle',),
'fjollet': ('fjolle',),
'fjusk': ('fjuske',),
'fjuska': ('fjuske',),
'fjuske': ('fjuske',),
'fjusker': ('fjuske',),
'fjuskes': ('fjuske',),
'fjusket': ('fjuske',),
'fjær': ('fjære',),
'fjæra': ('fjære',),
'fjære': ('fjære',),
'fjærer': ('fjære',),
'fjæres': ('fjære',),
'fjæret': ('fjære',),
'fjær': ('fjære',),
'fjæra': ('fjære',),
'fjære': ('fjære',),
'fjærer': ('fjære',),
'fjæres': ('fjære',),
'fjæret': ('fjære',),
'fjør': ('fjøre',),
'fjøra': ('fjøre',),
'fjøre': ('fjøre',),
'fjører': ('fjøre',),
'fjøres': ('fjøre',),
'fjøret': ('fjøre',),
'flagg': ('flagge',),
'flagga': ('flagge',),
'flagge': ('flagge',),
'flagger': ('flagge',),
'flagges': ('flagge',),
'flagget': ('flagge',),
'flagr': ('flagre',),
'flagra': ('flagre',),
'flagre': ('flagre',),
'flagrer': ('flagre',),
'flagres': ('flagre',),
'flagret': ('flagre',),
'flak': ('flake',),
'flaka': ('flake',),
'flake': ('flake',),
'flaker': ('flake',),
'flakes': ('flake',),
'flaket': ('flake',),
'flakt': ('flake',),
'flakte': ('flake',),
'flakk': ('flakke',),
'flakka': ('flakke',),
'flakke': ('flakke',),
'flakker': ('flakke',),
'flakkes': ('flakke',),
'flakket': ('flakke',),
'flakn': ('flakne',),
'flakna': ('flakne',),
'flakne': ('flakne',),
'flakner': ('flakne',),
'flaknes': ('flakne',),
'flaknet': ('flakne',),
'flaks': ('flakse',),
'flaksa': ('flakse',),
'flakse': ('flakse',),
'flakser': ('flakse',),
'flakses': ('flakse',),
'flakset': ('flakse',),
'flamber': ('flambere',),
'flambere': ('flambere',),
'flamberer': ('flambere',),
'flamberes': ('flambere',),
'flambert': ('flambere',),
'flamberte': ('flambere',),
'flam': ('flamme',),
'flamma': ('flamme',),
'flamme': ('flamme',),
'flammer': ('flamme',),
'flammes': ('flamme',),
'flammet': ('flamme',),
'flan': ('flane',),
'flana': ('flane',),
'flane': ('flane',),
'flaner': ('flane',),
'flanes': ('flane',),
'flanet': ('flane',),
'flant': ('flane',),
'flante': ('flane',),
'flaner': ('flanere',),
'flanere': ('flanere',),
'flanerer': ('flanere',),
'flaneres': ('flanere',),
'flanert': ('flanere',),
'flanerte': ('flanere',),
'flanker': ('flankere',),
'flankere': ('flankere',),
'flankerer': ('flankere',),
'flankeres': ('flankere',),
'flankert': ('flankere',),
'flankerte': ('flankere',),
'flar': ('flare',),
'flara': ('flare',),
'flare': ('flare',),
'flarer': ('flare',),
'flares': ('flare',),
'flaret': ('flare',),
'flart': ('flare',),
'flarte': ('flare',),
'flask': ('flaske',),
'flaska': ('flaske',),
'flaske': ('flaske',),
'flasker': ('flaske',),
'flaskes': ('flaske',),
'flasket': ('flaske',),
'flask': ('flaske',),
'flaska': ('flaske',),
'flaske': ('flaske',),
'flasker': ('flaske',),
'flaskes': ('flaske',),
'flasket': ('flaske',),
'flass': ('flasse',),
'flassa': ('flasse',),
'flasse': ('flasse',),
'flasser': ('flasse',),
'flasses': ('flasse',),
'flasset': ('flasse',),
'flat': ('flate',),
'flata': ('flate',),
'flate': ('flate',),
'flater': ('flate',),
'flates': ('flate',),
'flatet': ('flate',),
'flatn': ('flatne',),
'flatna': ('flatne',),
'flatne': ('flatne',),
'flatner': ('flatne',),
'flatnes': ('flatne',),
'flatnet': ('flatne',),
'flatter': ('flattere',),
'flattere': ('flattere',),
'flatterer': ('flattere',),
'flatteres': ('flattere',),
'flattert': ('flattere',),
'flatterte': ('flattere',),
'flau': ('flaue',),
'flaua': ('flaue',),
'flaue': ('flaue',),
'flauer': ('flaue',),
'flaues': ('flaue',),
'flauet': ('flaue',),
'fleip': ('fleipe',),
'fleipa': ('fleipe',),
'fleipe': ('fleipe',),
'fleiper': ('fleipe',),
'fleipes': ('fleipe',),
'fleipet': ('fleipe',),
'fleipt': ('fleipe',),
'fleipte': ('fleipe',),
'flekk': ('flekke',),
'flekka': ('flekke',),
'flekke': ('flekke',),
'flekker': ('flekke',),
'flekkes': ('flekke',),
'flekket': ('flekke',),
'flekk': ('flekke',),
'flekka': ('flekke',),
'flekke': ('flekke',),
'flekker': ('flekke',),
'flekkes': ('flekke',),
'flekket': ('flekke',),
'flekt': ('flekke',),
'flekte': ('flekke',),
'fleks': ('flekse',),
'fleksa': ('flekse',),
'flekse': ('flekse',),
'flekser': ('flekse',),
'flekses': ('flekse',),
'flekset': ('flekse',),
'flekter': ('flektere',),
'flektere': ('flektere',),
'flekterer': ('flektere',),
'flekteres': ('flektere',),
'flektert': ('flektere',),
'flekterte': ('flektere',),
'fleng': ('flenge',),
'flenga': ('flenge',),
'flenge': ('flenge',),
'flenger': ('flenge',),
'flenges': ('flenge',),
'flenget': ('flenge',),
'flengt': ('flenge',),
'flengte': ('flenge',),
'flens': ('flense',),
'flensa': ('flense',),
'flense': ('flense',),
'flenser': ('flense',),
'flenses': ('flense',),
'flenset': ('flense',),
'flens': ('flense',),
'flensa': ('flense',),
'flense': ('flense',),
'flenser': ('flense',),
'flenses': ('flense',),
'flenset': ('flense',),
'flerdobl': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoble': ('flerdoble',),
'flerdobler': ('flerdoble',),
'flerdobles': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flett': ('flette',),
'fletta': ('flette',),
'flette': ('flette',),
'fletter': ('flette',),
'flettes': ('flette',),
'flettet': ('flette',),
'flett': ('flette',),
'fletta': ('flette',),
'flette': ('flette',),
'fletter': ('flette',),
'flettes': ('flette',),
'flettet': ('flette',),
'fli': ('fli',),
'flidd': ('fli',),
'flidde': ('fli',),
'flir': ('fli',),
'flis': ('fli',),
'flikk': ('flikke',),
'flikka': ('flikke',),
'flikke': ('flikke',),
'flikker': ('flikke',),
'flikkes': ('flikke',),
'flikket': ('flikke',),
'flimr': ('flimre',),
'flimra': ('flimre',),
'flimre': ('flimre',),
'flimrer': ('flimre',),
'flimres': ('flimre',),
'flimret': ('flimre',),
'flipp': ('flippe',),
'flippa': ('flippe',),
'flippe': ('flippe',),
'flipper': ('flippe',),
'flippes': ('flippe',),
'flippet': ('flippe',),
'flir': ('flire',),
'flire': ('flire',),
'flirer': ('flire',),
'flires': ('flire',),
'flirt': ('flire',),
'flirte': ('flire',),
'flis': ('flise',),
'flisa': ('flise',),
'flise': ('flise',),
'fliser': ('flise',),
'flises': ('flise',),
'fliset': ('flise',),
'flist': ('flise',),
'fliste': ('flise',),
'flisela': ('fliselegge',),
'fliselagt': ('fliselegge',),
'fliselegg': ('fliselegge',),
'fliselegge': ('fliselegge',),
'fliselegger': ('fliselegge',),
'fliselegges': ('fliselegge',),
'flisla': ('flislegge',),
'flislagt': ('flislegge',),
'flislegg': ('flislegge',),
'flislegge': ('flislegge',),
'flislegger': ('flislegge',),
'flislegges': ('flislegge',),
'flok': ('floke',),
'floka': ('floke',),
'floke': ('floke',),
'floker': ('floke',),
'flokes': ('floke',),
'floket': ('floke',),
'flokk': ('flokke',),
'flokka': ('flokke',),
'flokke': ('flokke',),
'flokker': ('flokke',),
'flokkes': ('flokke',),
'flokket': ('flokke',),
'floks': ('flokse',),
'floksa': ('flokse',),
'flokse': ('flokse',),
'flokser': ('flokse',),
'flokses': ('flokse',),
'flokset': ('flokse',),
'flom': ('flomme',),
'flomma': ('flomme',),
'flomme': ('flomme',),
'flommer': ('flomme',),
'flommes': ('flomme',),
'flommet': ('flomme',),
'flopp': ('floppe',),
'floppa': ('floppe',),
'floppe': ('floppe',),
'flopper': ('floppe',),
'floppes': ('floppe',),
'floppet': ('floppe',),
'flopp': ('floppe',),
'floppa': ('floppe',),
'floppe': ('floppe',),
'flopper': ('floppe',),
'floppes': ('floppe',),
'floppet': ('floppe',),
'floragrafer': ('floragrafere',),
'floragrafere': ('floragrafere',),
'floragraferer': ('floragrafere',),
'floragraferes': ('floragrafere',),
'floragrafert': ('floragrafere',),
'floragraferte': ('floragrafere',),
'florer': ('florere',),
'florere': ('florere',),
'florerer': ('florere',),
'floreres': ('florere',),
'florert': ('florere',),
'florerte': ('florere',),
'flott': ('flotte',),
'flotta': ('flotte',),
'flotte': ('flotte',),
'flotter': ('flotte',),
'flottes': ('flotte',),
'flottet': ('flotte',),
'flukt': ('flukte',),
'flukta': ('flukte',),
'flukte': ('flukte',),
'flukter': ('flukte',),
'fluktes': ('flukte',),
'fluktet': ('flukte',),
'fluktuer': ('fluktuere',),
'fluktuere': ('fluktuere',),
'fluktuerer': ('fluktuere',),
'fluktueres': ('fluktuere',),
'fluktuert': ('fluktuere',),
'fluktuerte': ('fluktuere',),
'fluorescer': ('fluorescere',),
'fluorescere': ('fluorescere',),
'fluorescerer': ('fluorescere',),
'fluoresceres': ('fluorescere',),
'fluorescert': ('fluorescere',),
'fluorescerte': ('fluorescere',),
'fluorider': ('fluoridere',),
'fluoridere': ('fluoridere',),
'fluoriderer': ('fluoridere',),
'fluorideres': ('fluoridere',),
'fluoridert': ('fluoridere',),
'fluoriderte': ('fluoridere',),
'fluoriser': ('fluorisere',),
'fluorisere': ('fluorisere',),
'fluoriserer': ('fluorisere',),
'fluoriseres': ('fluorisere',),
'fluorisert': ('fluorisere',),
'fluoriserte': ('fluorisere',),
'flaug': ('fly',),
'fly': ('fly',),
'flydd': ('fly',),
'flyr': ('fly',),
'flys': ('fly',),
'fløy': ('fly',),
'fløyet': ('fly',),
'flaug': ('flyge',),
'flydd': ('flyge',),
'flyg': ('flyge',),
'flyge': ('flyge',),
'flyger': ('flyge',),
'flyges': ('flyge',),
'fløy': ('flyge',),
'fløyet': ('flyge',),
'flykt': ('flykte',),
'flykta': ('flykte',),
'flykte': ('flykte',),
'flykter': ('flykte',),
'flyktes': ('flykte',),
'flyktet': ('flykte',),
'flaut': ('flyte',),
'flyt': ('flyte',),
'flyte': ('flyte',),
'flyter': ('flyte',),
'flytes': ('flyte',),
'flytt': ('flyte',),
'fløt': ('flyte',),
'fløyt': ('flyte',),
'flytt': ('flytte',),
'flytta': ('flytte',),
'flytte': ('flytte',),
'flytter': ('flytte',),
'flyttes': ('flytte',),
'flyttet': ('flytte',),
'flå': ('flå',),
'flådd': ('flå',),
'flådde': ('flå',),
'flår': ('flå',),
'flås': ('flå',),
'flås': ('flåse',),
'flåse': ('flåse',),
'flåser': ('flåse',),
'flåses': ('flåse',),
'flåst': ('flåse',),
'flåste': ('flåse',),
'flæ': ('flæ',),
'flædd': ('flæ',),
'flædde': ('flæ',),
'flær': ('flæ',),
'flæs': ('flæ',),
'flær': ('flære',),
'flæra': ('flære',),
'flære': ('flære',),
'flærer': ('flære',),
'flæres': ('flære',),
'flæret': ('flære',),
'flø': ('flø',),
'flødd': ('flø',),
'flødde': ('flø',),
'flør': ('flø',),
'fløs': ('flø',),
'fløk': ('fløke',),
'fløke': ('fløke',),
'fløker': ('fløke',),
'fløkes': ('fløke',),
'fløkt': ('fløke',),
'fløkte': ('fløke',),
'fløm': ('flømme',),
'flømm': ('flømme',),
'flømma': ('flømme',),
'flømme': ('flømme',),
'flømmer': ('flømme',),
'flømmes': ('flømme',),
'flømmet': ('flømme',),
'flømt': ('flømme',),
'flømte': ('flømme',),
'flørt': ('flørte',),
'flørta': ('flørte',),
'flørte': ('flørte',),
'flørter': ('flørte',),
'flørtes': ('flørte',),
'flørtet': ('flørte',),
'fløt': ('fløte',),
'fløta': ('fløte',),
'fløte': ('fløte',),
'fløter': ('fløte',),
'fløtes': ('fløte',),
'fløtet': ('fløte',),
'fløtt': ('fløte',),
'fløtte': ('fløte',),
'fløyt': ('fløyte',),
'fløyta': ('fløyte',),
'fløyte': ('fløyte',),
'fløyter': ('fløyte',),
'fløytes': ('fløyte',),
'fløytet': ('fløyte',),
'fløyt': ('fløyte',),
'fløyta': ('fløyte',),
'fløyte': ('fløyte',),
'fløyter': ('fløyte',),
'fløytes': ('fløyte',),
'fløytet': ('fløyte',),
'fløytt': ('fløyte',),
'fløytte': ('fløyte',),
'fnis': ('fnise',),
'fnise': ('fnise',),
'fniser': ('fnise',),
'fnises': ('fnise',),
'fnist': ('fnise',),
'fniste': ('fnise',),
'fnys': ('fnyse',),
'fnyse': ('fnyse',),
'fnyser': ('fnyse',),
'fnyses': ('fnyse',),
'fnyst': ('fnyse',),
'fnyste': ('fnyse',),
'fnøs': ('fnyse',),
'fnøys': ('fnyse',),
'fokuser': ('fokusere',),
'fokusere': ('fokusere',),
'fokuserer': ('fokusere',),
'fokuseres': ('fokusere',),
'fokusert': ('fokusere',),
'fokuserte': ('fokusere',),
'fold': ('folde',),
'folda': ('folde',),
'folde': ('folde',),
'folder': ('folde',),
'foldes': ('folde',),
'foldet': ('folde',),
'fol': ('fole',),
'fola': ('fole',),
'fole': ('fole',),
'foler': ('fole',),
'foles': ('fole',),
'folet': ('fole',),
'folier': ('foliere',),
'foliere': ('foliere',),
'folierer': ('foliere',),
'folieres': ('foliere',),
'foliert': ('foliere',),
'folierte': ('foliere',),
'folk': ('folke',),
'folka': ('folke',),
'folke': ('folke',),
'folker': ('folke',),
'folkes': ('folke',),
'folket': ('folke',),
'foll': ('folle',),
'folla': ('folle',),
'folle': ('folle',),
'foller': ('folle',),
'folles': ('folle',),
'follet': ('folle',),
'foln': ('folne',),
'folna': ('folne',),
'folne': ('folne',),
'folner': ('folne',),
'folnes': ('folne',),
'folnet': ('folne',),
'foml': ('fomle',),
'fomla': ('fomle',),
'fomle': ('fomle',),
'fomler': ('fomle',),
'fomles': ('fomle',),
'fomlet': ('fomle',),
'fonn': ('fonne',),
'fonna': ('fonne',),
'fonne': ('fonne',),
'fonner': ('fonne',),
'fonnes': ('fonne',),
'fonnet': ('fonne',),
'forakt': ('forakte',),
'forakta': ('forakte',),
'forakte': ('forakte',),
'forakter': ('forakte',),
'foraktes': ('forakte',),
'foraktet': ('forakte',),
'forandr': ('forandre',),
'forandra': ('forandre',),
'forandre': ('forandre',),
'forandrer': ('forandre',),
'forandres': ('forandre',),
'forandret': ('forandre',),
'forankr': ('forankre',),
'forankra': ('forankre',),
'forankre': ('forankre',),
'forankrer': ('forankre',),
'forankres': ('forankre',),
'forankret': ('forankre',),
'foranledig': ('foranledige',),
'foranlediga': ('foranledige',),
'foranledige': ('foranledige',),
'foranlediger': ('foranledige',),
'foranlediges': ('foranledige',),
'foranlediget': ('foranledige',),
'foranstalt': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstalte': ('foranstalte',),
'foranstalter': ('foranstalte',),
'foranstaltes': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'forarbeid': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidd': ('forarbeide',),
'forarbeidde': ('forarbeide',),
'forarbeide': ('forarbeide',),
'forarbeider': ('forarbeide',),
'forarbeides': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarg': ('forarge',),
'forarga': ('forarge',),
'forarge': ('forarge',),
'forarger': ('forarge',),
'forarges': ('forarge',),
'forarget': ('forarge',),
'forarm': ('forarme',),
'forarma': ('forarme',),
'forarme': ('forarme',),
'forarmer': ('forarme',),
'forarmes': ('forarme',),
'forarmet': ('forarme',),
'forbann': ('forbanne',),
'forbanna': ('forbanne',),
'forbanne': ('forbanne',),
'forbanner': ('forbanne',),
'forbannes': ('forbanne',),
'forbannet': ('forbanne',),
'forbant': ('forbanne',),
'forbante': ('forbanne',),
'forbarm': ('forbarme',),
'forbarma': ('forbarme',),
'forbarme': ('forbarme',),
'forbarmer': ('forbarme',),
'forbarmes': ('forbarme',),
'forbarmet': ('forbarme',),
'forbaus': ('forbause',),
'forbausa': ('forbause',),
'forbause': ('forbause',),
'forbauser': ('forbause',),
'forbauses': ('forbause',),
'forbauset': ('forbause',),
'forbedr': ('forbedre',),
'forbedra': ('forbedre',),
'forbedre': ('forbedre',),
'forbedrer': ('forbedre',),
'forbedres': ('forbedre',),
'forbedret': ('forbedre',),
'forbehold': ('forbeholde',),
'forbeholde': ('forbeholde',),
'forbeholder': ('forbeholde',),
'forbeholdes': ('forbeholde',),
'forbeholdt': ('forbeholde',),
'forbein': ('forbeine',),
'forbeina': ('forbeine',),
'forbeine': ('forbeine',),
'forbeiner': ('forbeine',),
'forbeines': ('forbeine',),
'forbeinet': ('forbeine',),
'forben': ('forbene',),
'forbena': ('forbene',),
'forbene': ('forbene',),
'forbener': ('forbene',),
'forbenes': ('forbene',),
'forbenet': ('forbene',),
'forbered': ('forberede',),
'forberede': ('forberede',),
'forbereder': ('forberede',),
'forberedes': ('forberede',),
'forberedt': ('forberede',),
'forberedte': ('forberede',),
'forbigikk': ('forbigå',),
'forbigjekk': ('forbigå',),
'forbigå': ('forbigå',),
'forbigåes': ('forbigå',),
'forbigår': ('forbigå',),
'forbigås': ('forbigå',),
'forbigått': ('forbigå',),
'forbandt': ('forbinde',),
'forbind': ('forbinde',),
'forbinde': ('forbinde',),
'forbinder': ('forbinde',),
'forbindes': ('forbinde',),
'forbundet': ('forbinde',),
'forbitr': ('forbitre',),
'forbitra': ('forbitre',),
'forbitre': ('forbitre',),
'forbitrer': ('forbitre',),
'forbitres': ('forbitre',),
'forbitret': ('forbitre',),
'forblend': ('forblende',),
'forblenda': ('forblende',),
'forblende': ('forblende',),
'forblender': ('forblende',),
'forblendes': ('forblende',),
'forblendet': ('forblende',),
'forble': ('forbli',),
'forblei': ('forbli',),
'forbli': ('forbli',),
'forblir': ('forbli',),
'forblis': ('forbli',),
'forblitt': ('forbli',),
'forblind': ('forblinde',),
'forblinda': ('forblinde',),
'forblinde': ('forblinde',),
'forblinder': ('forblinde',),
'forblindes': ('forblinde',),
'forblindet': ('forblinde',),
'forblø': ('forblø',),
'forblødd': ('forblø',),
'forblødde': ('forblø',),
'forblør': ('forblø',),
'forbløs': ('forblø',),
'forbløff': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffe': ('forbløffe',),
'forbløffer': ('forbløffe',),
'forbløffes': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbruk': ('forbruke',),
'forbruke': ('forbruke',),
'forbruker': ('forbruke',),
'forbrukes': ('forbruke',),
'forbrukt': ('forbruke',),
'forbrukte': ('forbruke',),
'forbraut': ('forbryte',),
'forbrutt': ('forbryte',),
'forbryt': ('forbryte',),
'forbryte': ('forbryte',),
'forbryter': ('forbryte',),
'forbrytes': ('forbryte',),
'forbrøt': ('forbryte',),
'forbrøyt': ('forbryte',),
'forbaud': ('forby',),
'forbudt': ('forby',),
'forby': ('forby',),
'forbydd': ('forby',),
'forbydde': ('forby',),
'forbyr': ('forby',),
'forbys': ('forby',),
'forbød': ('forby',),
'forbøy': ('forby',),
'forbytt': ('forbytte',),
'forbytta': ('forbytte',),
'forbytte': ('forbytte',),
'forbytter': ('forbytte',),
'forbyttes': ('forbytte',),
'forbyttet': ('forbytte',),
'fordamp': ('fordampe',),
'fordampa': ('fordampe',),
'fordampe': ('fordampe',),
'fordamper': ('fordampe',),
'fordampes': ('fordampe',),
'fordampet': ('fordampe',),
'fordansk': ('fordanske',),
'fordanska': ('fordanske',),
'fordanske': ('fordanske',),
'fordansker': ('fordanske',),
'fordanskes': ('fordanske',),
'fordansket': ('fordanske',),
'fordel': ('fordele',),
'fordele': ('fordele',),
'fordeler': ('fordele',),
'fordeles': ('fordele',),
'fordelt': ('fordele',),
'fordelte': ('fordele',),
'forderv': ('forderve',),
'forderva': ('forderve',),
'forderve': ('forderve',),
'forderver': ('forderve',),
'forderves': ('forderve',),
'fordervet': ('forderve',),
'fordjup': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupe': ('fordjupe',),
'fordjuper': ('fordjupe',),
'fordjupes': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordobl': ('fordoble',),
'fordobla': ('fordoble',),
'fordoble': ('fordoble',),
'fordobler': ('fordoble',),
'fordobles': ('fordoble',),
'fordoblet': ('fordoble',),
'fordra': ('fordra',),
'fordradd': ('fordra',),
'fordrar': ('fordra',),
'fordras': ('fordra',),
'fordratt': ('fordra',),
'fordro': ('fordra',),
'fordrog': ('fordra',),
'fordr': ('fordre',),
'fordra': ('fordre',),
'fordre': ('fordre',),
'fordrer': ('fordre',),
'fordres': ('fordre',),
'fordret': ('fordre',),
'fordrei': ('fordreie',),
'fordreia': ('fordreie',),
'fordreid': ('fordreie',),
'fordreidd': ('fordreie',),
'fordreidde': ('fordreie',),
'fordreide': ('fordreie',),
'fordreie': ('fordreie',),
'fordreier': ('fordreie',),
'fordreies': ('fordreie',),
'fordreiet': ('fordreie',),
'fordrist': ('fordriste',),
'fordrista': ('fordriste',),
'fordriste': ('fordriste',),
'fordrister': ('fordriste',),
'fordristes': ('fordriste',),
'fordristet': ('fordriste',),
'fordreiv': ('fordrive',),
'fordrev': ('fordrive',),
'fordrevet': ('fordrive',),
'fordriv': ('fordrive',),
'fordrive': ('fordrive',),
'fordriver': ('fordrive',),
'fordrives': ('fordrive',),
'forduft': ('fordufte',),
'fordufta': ('fordufte',),
'fordufte': ('fordufte',),
'fordufter': ('fordufte',),
'forduftes': ('fordufte',),
'forduftet': ('fordufte',),
'fordum': ('fordumme',),
'fordumma': ('fordumme',),
'fordumme': ('fordumme',),
'fordummer': ('fordumme',),
'fordummes': ('fordumme',),
'fordummet': ('fordumme',),
'fordundre': ('fordundre',),
'fordunkl': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunkle': ('fordunkle',),
'fordunkler': ('fordunkle',),
'fordunkles': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunst': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunste': ('fordunste',),
'fordunster': ('fordunste',),
'fordunstes': ('fordunste',),
'fordunstet': ('fordunste',),
'fordyp': ('fordype',),
'fordypa': ('fordype',),
'fordype': ('fordype',),
'fordyper': ('fordype',),
'fordypes': ('fordype',),
'fordypet': ('fordype',),
'fordyr': ('fordyre',),
'fordyra': ('fordyre',),
'fordyre': ('fordyre',),
'fordyrer': ('fordyre',),
'fordyres': ('fordyre',),
'fordyret': ('fordyre',),
'fordøm': ('fordømme',),
'fordømme': ('fordømme',),
'fordømmer': ('fordømme',),
'fordømmes': ('fordømme',),
'fordømt': ('fordømme',),
'fordømte': ('fordømme',),
'fordøy': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyd': ('fordøye',),
'fordøyde': ('fordøye',),
'fordøye': ('fordøye',),
'fordøyer': ('fordøye',),
'fordøyes': ('fordøye',),
'fordøyet': ('fordøye',),
'forebragt': ('forebringe',),
'forebragte': ('forebringe',),
'forebrakt': ('forebringe',),
'forebrakte': ('forebringe',),
'forebring': ('forebringe',),
'forebringe': ('forebringe',),
'forebringer': ('forebringe',),
'forebringes': ('forebringe',),
'forebygd': ('forebygge',),
'forebygde': ('forebygge',),
'forebygg': ('forebygge',),
'forebygga': ('forebygge',),
'forebygge': ('forebygge',),
'forebygger': ('forebygge',),
'forebygges': ('forebygge',),
'forebygget': ('forebygge',),
'foredl': ('foredle',),
'foredla': ('foredle',),
'foredle': ('foredle',),
'foredler': ('foredle',),
'foredles': ('foredle',),
'foredlet': ('foredle',),
'foredra': ('foredra',),
'foredradd': ('foredra',),
'foredrar': ('foredra',),
'foredras': ('foredra',),
'foredratt': ('foredra',),
'foredro': ('foredra',),
'foredrog': ('foredra',),
'forefall': ('forefalle',),
'forefalle': ('forefalle',),
'forefaller': ('forefalle',),
'forefalles': ('forefalle',),
'forefalt': ('forefalle',),
'forefantes': ('forefinnes',),
'forefinnes': ('forefinnes',),
'forefunnes': ('forefinnes',),
'forega': ('foregi',),
'foregav': ('foregi',),
'foregi': ('foregi',),
'foregies': ('foregi',),
'foregir': ('foregi',),
'foregis': ('foregi',),
'foregitt': ('foregi',),
'foregreip': ('foregripe',),
'foregrep': ('foregripe',),
'foregrepet': ('foregripe',),
'foregrip': ('foregripe',),
'foregripe': ('foregripe',),
'foregriper': ('foregripe',),
'foregripes': ('foregripe',),
'foregikk': ('foregå',),
'foregjekk': ('foregå',),
'foregå': ('foregå',),
'foregåes': ('foregå',),
'foregår': ('foregå',),
'foregås': ('foregå',),
'foregått': ('foregå',),
'forehold': ('foreholde',),
'foreholde': ('foreholde',),
'foreholder': ('foreholde',),
'foreholdes': ('foreholde',),
'foreholdt': ('foreholde',),
'forekom': ('forekomme',),
'forekomme': ('forekomme',),
'forekommer': ('forekomme',),
'forekommes': ('forekomme',),
'forekommet': ('forekomme',),
'foreldedes': ('foreldes',),
'foreldes': ('foreldes',),
'forela': ('forelegge',),
'forelagt': ('forelegge',),
'forelegg': ('forelegge',),
'forelegge': ('forelegge',),
'forelegger': ('forelegge',),
'forelegges': ('forelegge',),
'foreles': ('forelese',),
'forelese': ('forelese',),
'foreleser': ('forelese',),
'foreleses': ('forelese',),
'forelest': ('forelese',),
'foreleste': ('forelese',),
'foreligg': ('foreligge',),
'foreligge': ('foreligge',),
'foreligger': ('foreligge',),
'foreligges': ('foreligge',),
'foreligget': ('foreligge',),
'forelå': ('foreligge',),
'forelåg': ('foreligge',),
'forelsk': ('forelske',),
'forelska': ('forelske',),
'forelske': ('forelske',),
'forelsker': ('forelske',),
'forelskes': ('forelske',),
'forelsket': ('forelske',),
'foren': ('forene',),
'forena': ('forene',),
'forene': ('forene',),
'forener': ('forene',),
'forenes': ('forene',),
'forenet': ('forene',),
'forent': ('forene',),
'forente': ('forene',),
'foren': ('forene',),
'forena': ('forene',),
'forene': ('forene',),
'forener': ('forene',),
'forenes': ('forene',),
'forenet': ('forene',),
'forent': ('forene',),
'forente': ('forene',),
'forenkl': ('forenkle',),
'forenkla': ('forenkle',),
'forenkle': ('forenkle',),
'forenkler': ('forenkle',),
'forenkles': ('forenkle',),
'forenklet': ('forenkle',),
'foresatt': ('foresette',),
'foresatte': ('foresette',),
'foresett': ('foresette',),
'foresette': ('foresette',),
'foresetter': ('foresette',),
'foresettes': ('foresette',),
'foresa': ('foresi',),
'foresagt': ('foresi',),
'foresi': ('foresi',),
'foresier': ('foresi',),
'foresies': ('foresi',),
'foresis': ('foresi',),
'foreskreiv': ('foreskrive',),
'foreskrev': ('foreskrive',),
'foreskrevet': ('foreskrive',),
'foreskriv': ('foreskrive',),
'foreskrive': ('foreskrive',),
'foreskriver': ('foreskrive',),
'foreskrives': ('foreskrive',),
'foreslo': ('foreslå',),
'foreslå': ('foreslå',),
'foreslåes': ('foreslå',),
'foreslår': ('foreslå',),
'foreslås': ('foreslå',),
'foreslått': ('foreslå',),
'forespeil': ('forespeile',),
'forespeila': ('forespeile',),
'forespeile': ('forespeile',),
'forespeiler': ('forespeile',),
'forespeiles': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilt': ('forespeile',),
'forespeilte': ('forespeile',),
'forespurt': ('forespørre',),
'forespurte': ('forespørre',),
'forespør': ('forespørre',),
'forespørre': ('forespørre',),
'forespørres': ('forespørre',),
'forestill': ('forestille',),
'forestille': ('forestille',),
'forestiller': ('forestille',),
'forestilles': ('forestille',),
'forestilt': ('forestille',),
'forestilte': ('forestille',),
'foresto': ('forestå',),
'forestod': ('forestå',),
'forestå': ('forestå',),
'foreståes': ('forestå',),
'forestår': ('forestå',),
'forestås': ('forestå',),
'forestått': ('forestå',),
'foresvev': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevd': ('foresveve',),
'foresvevde': ('foresveve',),
'foresveve': ('foresveve',),
'foresvever': ('foresveve',),
'foresveves': ('foresveve',),
'foresvevet': ('foresveve',),
'foreta': ('foreta',),
'foretaes': ('foreta',),
'foretar': ('foreta',),
'foretas': ('foreta',),
'foretatt': ('foreta',),
'foretok': ('foreta',),
'foretrakk': ('foretrekke',),
'foretrekk': ('foretrekke',),
'foretrekke': ('foretrekke',),
'foretrekker': ('foretrekke',),
'foretrekkes': ('foretrekke',),
'foretrukket': ('foretrekke',),
'forevig': ('forevige',),
'foreviga': ('forevige',),
'forevige': ('forevige',),
'foreviger': ('forevige',),
'foreviges': ('forevige',),
'foreviget': ('forevige',),
'forevis': ('forevise',),
'forevise': ('forevise',),
'foreviser': ('forevise',),
'forevises': ('forevise',),
'forevist': ('forevise',),
'foreviste': ('forevise',),
'forfall': ('forfalle',),
'forfalle': ('forfalle',),
'forfaller': ('forfalle',),
'forfalles': ('forfalle',),
'forfalt': ('forfalle',),
'forfalsk': ('forfalske',),
'forfalska': ('forfalske',),
'forfalske': ('forfalske',),
'forfalsker': ('forfalske',),
'forfalskes': ('forfalske',),
'forfalsket': ('forfalske',),
'forfatt': ('forfatte',),
'forfatta': ('forfatte',),
'forfatte': ('forfatte',),
'forfatter': ('forfatte',),
'forfattes': ('forfatte',),
'forfattet': ('forfatte',),
'forfeil': ('forfeile',),
'forfeila': ('forfeile',),
'forfeile': ('forfeile',),
'forfeiler': ('forfeile',),
'forfeiles': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilt': ('forfeile',),
'forfeilte': ('forfeile',),
'forfekt': ('forfekte',),
'forfekta': ('forfekte',),
'forfekte': ('forfekte',),
'forfekter': ('forfekte',),
'forfektes': ('forfekte',),
'forfektet': ('forfekte',),
'forferd': ('forferde',),
'forferda': ('forferde',),
'forferde': ('forferde',),
'forferder': ('forferde',),
'forferdes': ('forferde',),
'forferdet': ('forferde',),
'forferdig': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdige': ('forferdige',),
'forferdiger': ('forferdige',),
'forferdiges': ('forferdige',),
'forferdiget': ('forferdige',),
'forfin': ('forfine',),
'forfina': ('forfine',),
'forfine': ('forfine',),
'forfiner': ('forfine',),
'forfines': ('forfine',),
'forfinet': ('forfine',),
'forfjams': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamse': ('forfjamse',),
'forfjamser': ('forfjamse',),
'forfjamses': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forflat': ('forflate',),
'forflata': ('forflate',),
'forflate': ('forflate',),
'forflater': ('forflate',),
'forflates': ('forflate',),
'forflatet': ('forflate',),
'forfler': ('forflere',),
'forflera': ('forflere',),
'forflere': ('forflere',),
'forflerer': ('forflere',),
'forfleres': ('forflere',),
'forfleret': ('forflere',),
'forflert': ('forflere',),
'forflerte': ('forflere',),
'forflytt': ('forflytte',),
'forflytta': ('forflytte',),
'forflytte': ('forflytte',),
'forflytter': ('forflytte',),
'forflyttes': ('forflytte',),
'forflyttet': ('forflytte',),
'forfordel': ('forfordele',),
'forfordele': ('forfordele',),
'forfordeler': ('forfordele',),
'forfordeles': ('forfordele',),
'forfordelt': ('forfordele',),
'forfordelte': ('forfordele',),
'forfrem': ('forfremme',),
'forfremma': ('forfremme',),
'forfremme': ('forfremme',),
'forfremmer': ('forfremme',),
'forfremmes': ('forfremme',),
'forfremmet': ('forfremme',),
'forfrisk': ('forfriske',),
'forfriska': ('forfriske',),
'forfriske': ('forfriske',),
'forfrisker': ('forfriske',),
'forfriskes': ('forfriske',),
'forfrisket': ('forfriske',),
'forfraus': ('forfryse',),
'forfrosset': ('forfryse',),
'forfrys': ('forfryse',),
'forfryse': ('forfryse',),
'forfryser': ('forfryse',),
'forfryses': ('forfryse',),
'forfrøs': ('forfryse',),
'forfrøys': ('forfryse',),
'forfulgt': ('forfølge',),
'forfulgte': ('forfølge',),
'forfølg': ('forfølge',),
'forfølge': ('forfølge',),
'forfølger': ('forfølge',),
'forfølges': ('forfølge',),
'forfør': ('forføre',),
'forføre': ('forføre',),
'forfører': ('forføre',),
'forføres': ('forføre',),
'forført': ('forføre',),
'forførte': ('forføre',),
'forføy': ('forføye',),
'forføya': ('forføye',),
'forføyd': ('forføye',),
'forføydd': ('forføye',),
'forføydde': ('forføye',),
'forføyde': ('forføye',),
'forføye': ('forføye',),
'forføyer': ('forføye',),
'forføyes': ('forføye',),
'forføyet': ('forføye',),
'forgap': ('forgape',),
'forgapa': ('forgape',),
'forgape': ('forgape',),
'forgaper': ('forgape',),
'forgapes': ('forgape',),
'forgapt': ('forgape',),
'forgapte': ('forgape',),
'forgass': ('forgasse',),
'forgassa': ('forgasse',),
'forgasse': ('forgasse',),
'forgasser': ('forgasse',),
'forgasses': ('forgasse',),
'forgasset': ('forgasse',),
'forga': ('forgi',),
'forgav': ('forgi',),
'forgi': ('forgi',),
'forgies': ('forgi',),
'forgir': ('forgi',),
'forgis': ('forgi',),
'forgitt': ('forgi',),
'forgift': ('forgifte',),
'forgifta': ('forgifte',),
'forgifte': ('forgifte',),
'forgifter': ('forgifte',),
'forgiftes': ('forgifte',),
'forgiftet': ('forgifte',),
'forgjeld': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjelde': ('forgjelde',),
'forgjelder': ('forgjelde',),
'forgjeldes': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjorde': ('forgjøre',),
'forgjort': ('forgjøre',),
'forgjør': ('forgjøre',),
'forgjøre': ('forgjøre',),
'forgjøres': ('forgjøre',),
'forglem': ('forglemme',),
'forglemme': ('forglemme',),
'forglemmer': ('forglemme',),
'forglemmes': ('forglemme',),
'forglemt': ('forglemme',),
'forglemte': ('forglemme',),
'forgløm': ('forglømme',),
'forglømme': ('forglømme',),
'forglømmer': ('forglømme',),
'forglømmes': ('forglømme',),
'forglømt': ('forglømme',),
'forglømte': ('forglømme',),
'forgrein': ('forgreine',),
'forgreina': ('forgreine',),
'forgreine': ('forgreine',),
'forgreiner': ('forgreine',),
'forgreines': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreint': ('forgreine',),
'forgreinte': ('forgreine',),
'forgren': ('forgrene',),
'forgrena': ('forgrene',),
'forgrene': ('forgrene',),
'forgrener': ('forgrene',),
'forgrenes': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrent': ('forgrene',),
'forgrente': ('forgrene',),
'forgreip': ('forgripe',),
'forgrep': ('forgripe',),
'forgrepet': ('forgripe',),
'forgrip': ('forgripe',),
'forgripe': ('forgripe',),
'forgriper': ('forgripe',),
'forgripes': ('forgripe',),
'forgrov': ('forgrove',),
'forgrova': ('forgrove',),
'forgrove': ('forgrove',),
'forgrover': ('forgrove',),
'forgroves': ('forgrove',),
'forgrovet': ('forgrove',),
'forgubb': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbe': ('forgubbe',),
'forgubber': ('forgubbe',),
'forgubbes': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgud': ('forgude',),
'forguda': ('forgude',),
'forgude': ('forgude',),
'forguder': ('forgude',),
'forgudes': ('forgude',),
'forgudet': ('forgude',),
'forgyll': ('forgylle',),
'forgylla': ('forgylle',),
'forgylle': ('forgylle',),
'forgyller': ('forgylle',),
'forgylles': ('forgylle',),
'forgyllet': ('forgylle',),
'forgylt': ('forgylle',),
'forgylte': ('forgylle',),
'forgikk': ('forgå',),
'forgjekk': ('forgå',),
'forgå': ('forgå',),
'forgåes': ('forgå',),
'forgår': ('forgå',),
'forgås': ('forgå',),
'forgått': ('forgå',),
'forhal': ('forhale',),
'forhala': ('forhale',),
'forhale': ('forhale',),
'forhaler': ('forhale',),
'forhales': ('forhale',),
'forhalet': ('forhale',),
'forhalt': ('forhale',),
'forhalte': ('forhale',),
'forhandl': ('forhandle',),
'forhandla': ('forhandle',),
'forhandle': ('forhandle',),
'forhandler': ('forhandle',),
'forhandles': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandsbestill': ('forhandsbestille',),
'forhandsbestille': ('forhandsbestille',),
'forhandsbestiller': ('forhandsbestille',),
'forhandsbestilles': ('forhandsbestille',),
'forhandsbestilt': ('forhandsbestille',),
'forhandsbestilte': ('forhandsbestille',),
'forhandsomtal': ('forhandsomtale',),
'forhandsomtala': ('forhandsomtale',),
'forhandsomtale': ('forhandsomtale',),
'forhandsomtaler': ('forhandsomtale',),
'forhandsomtales': ('forhandsomtale',),
'forhandsomtalt': ('forhandsomtale',),
'forhandsomtalte': ('forhandsomtale',),
'forhandsstem': ('forhandsstemme',),
'forhandsstemme': ('forhandsstemme',),
'forhandsstemmer': ('forhandsstemme',),
'forhandsstemmes': ('forhandsstemme',),
'forhandsstemt': ('forhandsstemme',),
'forhandsstemte': ('forhandsstemme',),
'forhast': ('forhaste',),
'forhasta': ('forhaste',),
'forhaste': ('forhaste',),
'forhaster': ('forhaste',),
'forhastes': ('forhaste',),
'forhastet': ('forhaste',),
'forheks': ('forhekse',),
'forheksa': ('forhekse',),
'forhekse': ('forhekse',),
'forhekser': ('forhekse',),
'forhekses': ('forhekse',),
'forhekset': ('forhekse',),
'forherd': ('forherde',),
'forherda': ('forherde',),
'forherde': ('forherde',),
'forherder': ('forherde',),
'forherdes': ('forherde',),
'forherdet': ('forherde',),
'forherlig': ('forherlige',),
'forherliga': ('forherlige',),
'forherlige': ('forherlige',),
'forherliger': ('forherlige',),
'forherliges': ('forherlige',),
'forherliget': ('forherlige',),
'forhindr': ('forhindre',),
'forhindra': ('forhindre',),
'forhindre': ('forhindre',),
'forhindrer': ('forhindre',),
'forhindres': ('forhindre',),
'forhindret': ('forhindre',),
'forhold': ('forholde',),
'forholde': ('forholde',),
'forholder': ('forholde',),
'forholdes': ('forholde',),
'forholdt': ('forholde',),
'forhyr': ('forhyre',),
'forhyre': ('forhyre',),
'forhyrer': ('forhyre',),
'forhyres': ('forhyre',),
'forhyrt': ('forhyre',),
'forhyrte': ('forhyre',),
'forhåndsbestill': ('forhåndsbestille',),
'forhåndsbestille': ('forhåndsbestille',),
'forhåndsbestiller': ('forhåndsbestille',),
'forhåndsbestilles': ('forhåndsbestille',),
'forhåndsbestilt': ('forhåndsbestille',),
'forhåndsbestilte': ('forhåndsbestille',),
'forhåndsomtal': ('forhåndsomtale',),
'forhåndsomtala': ('forhåndsomtale',),
'forhåndsomtale': ('forhåndsomtale',),
'forhåndsomtaler': ('forhåndsomtale',),
'forhåndsomtales': ('forhåndsomtale',),
'forhåndsomtalt': ('forhåndsomtale',),
'forhåndsomtalte': ('forhåndsomtale',),
'forhåndsstem': ('forhåndsstemme',),
'forhåndsstemme': ('forhåndsstemme',),
'forhåndsstemmer': ('forhåndsstemme',),
'forhåndsstemmes': ('forhåndsstemme',),
'forhåndsstemt': ('forhåndsstemme',),
'forhåndsstemte': ('forhåndsstemme',),
'forhån': ('forhåne',),
'forhåna': ('forhåne',),
'forhåne': ('forhåne',),
'forhåner': ('forhåne',),
'forhånes': ('forhåne',),
'forhånet': ('forhåne',),
'forhånt': ('forhåne',),
'forhånte': ('forhåne',),
'forhør': ('forhøre',),
'forhøre': ('forhøre',),
'forhører': ('forhøre',),
'forhøres': ('forhøre',),
'forhørt': ('forhøre',),
'forhørte': ('forhøre',),
'forhøy': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyd': ('forhøye',),
'forhøyde': ('forhøye',),
'forhøye': ('forhøye',),
'forhøyer': ('forhøye',),
'forhøyes': ('forhøye',),
'forhøyet': ('forhøye',),
'forivr': ('forivre',),
'forivra': ('forivre',),
'forivre': ('forivre',),
'forivrer': ('forivre',),
'forivres': ('forivre',),
'forivret': ('forivre',),
'forjett': ('forjette',),
'forjetta': ('forjette',),
'forjette': ('forjette',),
'forjetter': ('forjette',),
'forjettes': ('forjette',),
'forjettet': ('forjette',),
'forkalk': ('forkalke',),
'forkalka': ('forkalke',),
'forkalke': ('forkalke',),
'forkalker': ('forkalke',),
'forkalkes': ('forkalke',),
'forkalket': ('forkalke',),
'forkast': ('forkaste',),
'forkasta': ('forkaste',),
'forkaste': ('forkaste',),
'forkaster': ('forkaste',),
'forkastes': ('forkaste',),
'forkastet': ('forkaste',),
'forkjetr': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetre': ('forkjetre',),
'forkjetrer': ('forkjetre',),
'forkjetres': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjæl': ('forkjæle',),
'forkjæle': ('forkjæle',),
'forkjæler': ('forkjæle',),
'forkjæles': ('forkjæle',),
'forkjælt': ('forkjæle',),
'forkjælte': ('forkjæle',),
'forkjøl': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjøle': ('forkjøle',),
'forkjøler': ('forkjøle',),
'forkjøles': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølt': ('forkjøle',),
'forkjølte': ('forkjøle',),
'forkjøp': ('forkjøpe',),
'forkjøpe': ('forkjøpe',),
'forkjøper': ('forkjøpe',),
'forkjøpes': ('forkjøpe',),
'forkjøpt': ('forkjøpe',),
'forkjøpte': ('forkjøpe',),
'forklar': ('forklare',),
'forklare': ('forklare',),
'forklarer': ('forklare',),
'forklares': ('forklare',),
'forklart': ('forklare',),
'forklarte': ('forklare',),
'forkle': ('forkle',),
'forkledd': ('forkle',),
'forkledde': ('forkle',),
'forkler': ('forkle',),
'forkles': ('forkle',),
'forklein': ('forkleine',),
'forkleina': ('forkleine',),
'forkleine': ('forkleine',),
'forkleiner': ('forkleine',),
'forkleines': ('forkleine',),
'forkleinet': ('forkleine',),
'forkludr': ('forkludre',),
'forkludra': ('forkludre',),
'forkludre': ('forkludre',),
'forkludrer': ('forkludre',),
'forkludres': ('forkludre',),
'forkludret': ('forkludre',),
'forkobr': ('forkobre',),
'forkobra': ('forkobre',),
'forkobre': ('forkobre',),
'forkobrer': ('forkobre',),
'forkobres': ('forkobre',),
'forkobret': ('forkobre',),
'forkom': ('forkomme',),
'forkomme': ('forkomme',),
'forkommer': ('forkomme',),
'forkommes': ('forkomme',),
'forkommet': ('forkomme',),
'forkopr': ('forkopre',),
'forkopra': ('forkopre',),
'forkopre': ('forkopre',),
'forkoprer': ('forkopre',),
'forkopres': ('forkopre',),
'forkopret': ('forkopre',),
'forkort': ('forkorte',),
'forkorta': ('forkorte',),
'forkorte': ('forkorte',),
'forkorter': ('forkorte',),
'forkortes': ('forkorte',),
'forkortet': ('forkorte',),
'forkrom': ('forkromme',),
'forkromma': ('forkromme',),
'forkromme': ('forkromme',),
'forkrommer': ('forkromme',),
'forkrommes': ('forkromme',),
'forkrommet': ('forkromme',),
'forku': ('forkue',),
'forkua': ('forkue',),
'forkue': ('forkue',),
'forkuer': ('forkue',),
'forkues': ('forkue',),
'forkuet': ('forkue',),
'forkull': ('forkulle',),
'forkulla': ('forkulle',),
'forkulle': ('forkulle',),
'forkuller': ('forkulle',),
'forkulles': ('forkulle',),
'forkullet': ('forkulle',),
'forkvakl': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvakle': ('forkvakle',),
'forkvakler': ('forkvakle',),
'forkvakles': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkynn': ('forkynne',),
'forkynne': ('forkynne',),
'forkynner': ('forkynne',),
'forkynnes': ('forkynne',),
'forkynt': ('forkynne',),
'forkynte': ('forkynne',),
'forlang': ('forlange',),
'forlange': ('forlange',),
'forlanger': ('forlange',),
'forlanges': ('forlange',),
'forlangt': ('forlange',),
'forlangte': ('forlange',),
'forlat': ('forlate',),
'forlate': ('forlate',),
'forlater': ('forlate',),
'forlates': ('forlate',),
'forlatt': ('forlate',),
'forlot': ('forlate',),
'forled': ('forlede',),
'forleda': ('forlede',),
'forlede': ('forlede',),
'forleder': ('forlede',),
'forledes': ('forlede',),
'forledet': ('forlede',),
'forla': ('forlegge',),
'forlagt': ('forlegge',),
'forlegg': ('forlegge',),
'forlegge': ('forlegge',),
'forlegger': ('forlegge',),
'forlegges': ('forlegge',),
'forleng': ('forlenge',),
'forlenga': ('forlenge',),
'forlenge': ('forlenge',),
'forlenger': ('forlenge',),
'forlenges': ('forlenge',),
'forlenget': ('forlenge',),
'forles': ('forlese',),
'forlese': ('forlese',),
'forleser': ('forlese',),
'forleses': ('forlese',),
'forlest': ('forlese',),
'forleste': ('forlese',),
'forlib': ('forlibe',),
'forlibe': ('forlibe',),
'forliber': ('forlibe',),
'forlibes': ('forlibe',),
'forlibt': ('forlibe',),
'forlibte': ('forlibe',),
'forlik': ('forlike',),
'forlike': ('forlike',),
'forliker': ('forlike',),
'forlikes': ('forlike',),
'forlikt': ('forlike',),
'forlikte': ('forlike',),
'forlis': ('forlise',),
'forlise': ('forlise',),
'forliser': ('forlise',),
'forlises': ('forlise',),
'forlist': ('forlise',),
'forliste': ('forlise',),
'forlokk': ('forlokke',),
'forlokka': ('forlokke',),
'forlokke': ('forlokke',),
'forlokker': ('forlokke',),
'forlokkes': ('forlokke',),
'forlokket': ('forlokke',),
'forlov': ('forlove',),
'forlova': ('forlove',),
'forlove': ('forlove',),
'forlover': ('forlove',),
'forloves': ('forlove',),
'forlovet': ('forlove',),
'forlyd': ('forlyde',),
'forlyde': ('forlyde',),
'forlyder': ('forlyde',),
'forlydes': ('forlyde',),
'forlydt': ('forlyde',),
'forlød': ('forlyde',),
'forlyst': ('forlyste',),
'forlysta': ('forlyste',),
'forlyste': ('forlyste',),
'forlyster': ('forlyste',),
'forlystes': ('forlyste',),
'forlystet': ('forlyste',),
'forløft': ('forløfte',),
'forløfta': ('forløfte',),
'forløfte': ('forløfte',),
'forløfter': ('forløfte',),
'forløftes': ('forløfte',),
'forløftet': ('forløfte',),
'forløp': ('forløpe',),
'forløpe': ('forløpe',),
'forløper': ('forløpe',),
'forløpes': ('forløpe',),
'forløpet': ('forløpe',),
'forløpt': ('forløpe',),
'forløs': ('forløse',),
'forløse': ('forløse',),
'forløser': ('forløse',),
'forløses': ('forløse',),
'forløst': ('forløse',),
'forløste': ('forløse',),
'forløys': ('forløyse',),
'forløyse': ('forløyse',),
'forløyser': ('forløyse',),
'forløyses': ('forløyse',),
'forløyst': ('forløyse',),
'forløyste': ('forløyse',),
'formal': ('formale',),
'formale': ('formale',),
'formaler': ('formale',),
'formales': ('formale',),
'formalt': ('formale',),
'formalte': ('formale',),
'formaliser': ('formalisere',),
'formalisere': ('formalisere',),
'formaliserer': ('formalisere',),
'formaliseres': ('formalisere',),
'formalisert': ('formalisere',),
'formaliserte': ('formalisere',),
'forman': ('formane',),
'formana': ('formane',),
'formane': ('formane',),
'formaner': ('formane',),
'formanes': ('formane',),
'formanet': ('formane',),
'formant': ('formane',),
'formante': ('formane',),
'formast': ('formaste',),
'formasta': ('formaste',),
'formaste': ('formaste',),
'formaster': ('formaste',),
'formastes': ('formaste',),
'formastet': ('formaste',),
'formater': ('formatere',),
'formatere': ('formatere',),
'formaterer': ('formatere',),
'formateres': ('formatere',),
'formatert': ('formatere',),
'formaterte': ('formatere',),
'form': ('forme',),
'forma': ('forme',),
'forme': ('forme',),
'former': ('forme',),
'formes': ('forme',),
'formet': ('forme',),
'formen': ('formene',),
'formene': ('formene',),
'formener': ('formene',),
'formenes': ('formene',),
'forment': ('formene',),
'formente': ('formene',),
'former': ('formere',),
'formere': ('formere',),
'formerer': ('formere',),
'formeres': ('formere',),
'formert': ('formere',),
'formerte': ('formere',),
'former': ('formere',),
'formere': ('formere',),
'formerer': ('formere',),
'formeres': ('formere',),
'formert': ('formere',),
'formerte': ('formere',),
'formga': ('formgi',),
'formgav': ('formgi',),
'formgi': ('formgi',),
'formgies': ('formgi',),
'formgir': ('formgi',),
'formgis': ('formgi',),
'formgitt': ('formgi',),
'formidl': ('formidle',),
'formidla': ('formidle',),
'formidle': ('formidle',),
'formidler': ('formidle',),
'formidles': ('formidle',),
'formidlet': ('formidle',),
'formild': ('formilde',),
'formilda': ('formilde',),
'formilde': ('formilde',),
'formilder': ('formilde',),
'formildes': ('formilde',),
'formildet': ('formilde',),
'forminsk': ('forminske',),
'forminska': ('forminske',),
'forminske': ('forminske',),
'forminsker': ('forminske',),
'forminskes': ('forminske',),
'forminsket': ('forminske',),
'formod': ('formode',),
'formoda': ('formode',),
'formode': ('formode',),
'formoder': ('formode',),
'formodes': ('formode',),
'formodet': ('formode',),
'formold': ('formolde',),
'formolda': ('formolde',),
'formolde': ('formolde',),
'formolder': ('formolde',),
'formoldes': ('formolde',),
'formoldet': ('formolde',),
'formuld': ('formulde',),
'formulda': ('formulde',),
'formulde': ('formulde',),
'formulder': ('formulde',),
'formuldes': ('formulde',),
'formuldet': ('formulde',),
'formuler': ('formulere',),
'formulere': ('formulere',),
'formulerer': ('formulere',),
'formuleres': ('formulere',),
'formulert': ('formulere',),
'formulerte': ('formulere',),
'formum': ('formumme',),
'formumma': ('formumme',),
'formumme': ('formumme',),
'formummer': ('formumme',),
'formummes': ('formumme',),
'formummet': ('formumme',),
'formå': ('formå',),
'formådd': ('formå',),
'formådde': ('formå',),
'formår': ('formå',),
'formås': ('formå',),
'formæl': ('formæle',),
'formæle': ('formæle',),
'formæler': ('formæle',),
'formæles': ('formæle',),
'formælt': ('formæle',),
'formælte': ('formæle',),
'formørk': ('formørke',),
'formørka': ('formørke',),
'formørke': ('formørke',),
'formørker': ('formørke',),
'formørkes': ('formørke',),
'formørket': ('formørke',),
'fornedr': ('fornedre',),
'fornedra': ('fornedre',),
'fornedre': ('fornedre',),
'fornedrer': ('fornedre',),
'fornedres': ('fornedre',),
'fornedret': ('fornedre',),
'fornekt': ('fornekte',),
'fornekta': ('fornekte',),
'fornekte': ('fornekte',),
'fornekter': ('fornekte',),
'fornektes': ('fornekte',),
'fornektet': ('fornekte',),
'fornam': ('fornemme',),
'fornem': ('fornemme',),
'fornemma': ('fornemme',),
'fornemme': ('fornemme',),
'fornemmer': ('fornemme',),
'fornemmes': ('fornemme',),
'fornemmet': ('fornemme',),
'fornikl': ('fornikle',),
'fornikla': ('fornikle',),
'fornikle': ('fornikle',),
'fornikler': ('fornikle',),
'fornikles': ('fornikle',),
'forniklet': ('fornikle',),
'fornorsk': ('fornorske',),
'fornorska': ('fornorske',),
'fornorske': ('fornorske',),
'fornorsker': ('fornorske',),
'fornorskes': ('fornorske',),
'fornorsket': ('fornorske',),
'forny': ('fornye',),
'fornya': ('fornye',),
'fornye': ('fornye',),
'fornyer': ('fornye',),
'fornyes': ('fornye',),
'fornyet': ('fornye',),
'fornærm': ('fornærme',),
'fornærma': ('fornærme',),
'fornærme': ('fornærme',),
'fornærmer': ('fornærme',),
'fornærmes': ('fornærme',),
'fornærmet': ('fornærme',),
'fornøy': ('fornøye',),
'fornøya': ('fornøye',),
'fornøyd': ('fornøye',),
'fornøyde': ('fornøye',),
'fornøye': ('fornøye',),
'fornøyer': ('fornøye',),
'fornøyes': ('fornøye',),
'fornøyet': ('fornøye',),
'forordn': ('forordne',),
'forordna': ('forordne',),
'forordne': ('forordne',),
'forordner': ('forordne',),
'forordnes': ('forordne',),
'forordnet': ('forordne',),
'forpakt': ('forpakte',),
'forpakta': ('forpakte',),
'forpakte': ('forpakte',),
'forpakter': ('forpakte',),
'forpaktes': ('forpakte',),
'forpaktet': ('forpakte',),
'forpest': ('forpeste',),
'forpesta': ('forpeste',),
'forpeste': ('forpeste',),
'forpester': ('forpeste',),
'forpestes': ('forpeste',),
'forpestet': ('forpeste',),
'forplant': ('forplante',),
'forplanta': ('forplante',),
'forplante': ('forplante',),
'forplanter': ('forplante',),
'forplantes': ('forplante',),
'forplantet': ('forplante',),
'forplei': ('forpleie',),
'forpleia': ('forpleie',),
'forpleid': ('forpleie',),
'forpleidd': ('forpleie',),
'forpleidde': ('forpleie',),
'forpleide': ('forpleie',),
'forpleie': ('forpleie',),
'forpleier': ('forpleie',),
'forpleies': ('forpleie',),
'forpleiet': ('forpleie',),
'forplikt': ('forplikte',),
'forplikta': ('forplikte',),
'forplikte': ('forplikte',),
'forplikter': ('forplikte',),
'forpliktes': ('forplikte',),
'forpliktet': ('forplikte',),
'forprosjekter': ('forprosjektere',),
'forprosjektere': ('forprosjektere',),
'forprosjekterer': ('forprosjektere',),
'forprosjekteres': ('forprosjektere',),
'forprosjektert': ('forprosjektere',),
'forprosjekterte': ('forprosjektere',),
'forpupp': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppe': ('forpuppe',),
'forpupper': ('forpuppe',),
'forpuppes': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpurr': ('forpurre',),
'forpurra': ('forpurre',),
'forpurre': ('forpurre',),
'forpurrer': ('forpurre',),
'forpurres': ('forpurre',),
'forpurret': ('forpurre',),
'forregn': ('forregne',),
'forregna': ('forregne',),
'forregne': ('forregne',),
'forregner': ('forregne',),
'forregnes': ('forregne',),
'forregnet': ('forregne',),
'forrekn': ('forrekne',),
'forrekna': ('forrekne',),
'forrekne': ('forrekne',),
'forrekner': ('forrekne',),
'forreknes': ('forrekne',),
'forreknet': ('forrekne',),
'forrent': ('forrente',),
'forrenta': ('forrente',),
'forrente': ('forrente',),
'forrenter': ('forrente',),
'forrentes': ('forrente',),
'forrentet': ('forrente',),
'forrett': ('forrette',),
'forretta': ('forrette',),
'forrette': ('forrette',),
'forretter': ('forrette',),
'forrettes': ('forrette',),
'forrettet': ('forrette',),
'forring': ('forringe',),
'forringa': ('forringe',),
'forringe': ('forringe',),
'forringer': ('forringe',),
'forringes': ('forringe',),
'forringet': ('forringe',),
'forrykk': ('forrykke',),
'forrykka': ('forrykke',),
'forrykke': ('forrykke',),
'forrykker': ('forrykke',),
'forrykkes': ('forrykke',),
'forrykket': ('forrykke',),
'forrykt': ('forrykke',),
'forrykte': ('forrykke',),
'forråd': ('forråde',),
'forråde': ('forråde',),
'forråder': ('forråde',),
'forrådes': ('forråde',),
'forrådt': ('forråde',),
'forrådte': ('forråde',),
'forrå': ('forråe',),
'forråa': ('forråe',),
'forråe': ('forråe',),
'forråer': ('forråe',),
'forråes': ('forråe',),
'forrået': ('forråe',),
'forsag': ('forsage',),
'forsaga': ('forsage',),
'forsage': ('forsage',),
'forsager': ('forsage',),
'forsages': ('forsage',),
'forsaget': ('forsage',),
'forsak': ('forsake',),
'forsaka': ('forsake',),
'forsake': ('forsake',),
'forsaker': ('forsake',),
'forsakes': ('forsake',),
'forsaket': ('forsake',),
'forse': ('forse',),
'forsees': ('forse',),
'forser': ('forse',),
'forses': ('forse',),
'forsett': ('forse',),
'forså': ('forse',),
'forsåg': ('forse',),
'forsegl': ('forsegle',),
'forsegla': ('forsegle',),
'forsegle': ('forsegle',),
'forsegler': ('forsegle',),
'forsegles': ('forsegle',),
'forseglet': ('forsegle',),
'forsenk': ('forsenke',),
'forsenka': ('forsenke',),
'forsenke': ('forsenke',),
'forsenker': ('forsenke',),
'forsenkes': ('forsenke',),
'forsenket': ('forsenke',),
'forser': ('forsere',),
'forsere': ('forsere',),
'forserer': ('forsere',),
'forseres': ('forsere',),
'forsert': ('forsere',),
'forserte': ('forsere',),
'forsikr': ('forsikre',),
'forsikra': ('forsikre',),
'forsikre': ('forsikre',),
'forsikrer': ('forsikre',),
'forsikres': ('forsikre',),
'forsikret': ('forsikre',),
'forsimpl': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimple': ('forsimple',),
'forsimpler': ('forsimple',),
'forsimples': ('forsimple',),
'forsimplet': ('forsimple',),
'forsink': ('forsinke',),
'forsinka': ('forsinke',),
'forsinke': ('forsinke',),
'forsinker': ('forsinke',),
'forsinkes': ('forsinke',),
'forsinket': ('forsinke',),
'forsink': ('forsinke',),
'forsinka': ('forsinke',),
'forsinke': ('forsinke',),
'forsinker': ('forsinke',),
'forsinkes': ('forsinke',),
'forsinket': ('forsinke',),
'forsir': ('forsire',),
'forsire': ('forsire',),
'forsirer': ('forsire',),
'forsires': ('forsire',),
'forsirt': ('forsire',),
'forsirte': ('forsire',),
'forsjofl': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjofle': ('forsjofle',),
'forsjofler': ('forsjofle',),
'forsjofles': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forskal': ('forskale',),
'forskala': ('forskale',),
'forskale': ('forskale',),
'forskaler': ('forskale',),
'forskales': ('forskale',),
'forskalet': ('forskale',),
'forskalt': ('forskale',),
'forskalte': ('forskale',),
'forskans': ('forskanse',),
'forskansa': ('forskanse',),
'forskanse': ('forskanse',),
'forskanser': ('forskanse',),
'forskanses': ('forskanse',),
'forskanset': ('forskanse',),
'forsk': ('forske',),
'forska': ('forske',),
'forske': ('forske',),
'forsker': ('forske',),
'forskes': ('forske',),
'forsket': ('forske',),
'forskjellsbehandl': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandle': ('forskjellsbehandle',),
'forskjellsbehandler': ('forskjellsbehandle',),
'forskjellsbehandles': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjønn': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønne': ('forskjønne',),
'forskjønner': ('forskjønne',),
'forskjønnes': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskotter': ('forskottere',),
'forskottere': ('forskottere',),
'forskotterer': ('forskottere',),
'forskotteres': ('forskottere',),
'forskottert': ('forskottere',),
'forskotterte': ('forskottere',),
'forskrekk': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekke': ('forskrekke',),
'forskrekker': ('forskrekke',),
'forskrekkes': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrev': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevd': ('forskreve',),
'forskrevde': ('forskreve',),
'forskreve': ('forskreve',),
'forskrever': ('forskreve',),
'forskreves': ('forskreve',),
'forskrevet': ('forskreve',),
'forskreiv': ('forskrive',),
'forskrev': ('forskrive',),
'forskrevet': ('forskrive',),
'forskriv': ('forskrive',),
'forskrive': ('forskrive',),
'forskriver': ('forskrive',),
'forskrives': ('forskrive',),
'forskusl': ('forskusle',),
'forskusla': ('forskusle',),
'forskusle': ('forskusle',),
'forskusler': ('forskusle',),
'forskusles': ('forskusle',),
'forskuslet': ('forskusle',),
'forskutter': ('forskuttere',),
'forskuttere': ('forskuttere',),
'forskutterer': ('forskuttere',),
'forskutteres': ('forskuttere',),
'forskuttert': ('forskuttere',),
'forskutterte': ('forskuttere',),
'forskyld': ('forskylde',),
'forskylde': ('forskylde',),
'forskylder': ('forskylde',),
'forskyldes': ('forskylde',),
'forskyldt': ('forskylde',),
'forskyldte': ('forskylde',),
'forskjøv': ('forskyve',),
'forskjøvet': ('forskyve',),
'forskyv': ('forskyve',),
'forskyvd': ('forskyve',),
'forskyve': ('forskyve',),
'forskyver': ('forskyve',),
'forskyves': ('forskyve',),
'forskøyv': ('forskyve',),
'forskån': ('forskåne',),
'forskåna': ('forskåne',),
'forskåne': ('forskåne',),
'forskåner': ('forskåne',),
'forskånes': ('forskåne',),
'forskånet': ('forskåne',),
'forskånt': ('forskåne',),
'forskånte': ('forskåne',),
'forsluk': ('forsluke',),
'forsluke': ('forsluke',),
'forsluker': ('forsluke',),
'forslukes': ('forsluke',),
'forslukt': ('forsluke',),
'forslukte': ('forsluke',),
'forslum': ('forslumme',),
'forslumma': ('forslumme',),
'forslumme': ('forslumme',),
'forslummer': ('forslumme',),
'forslummes': ('forslumme',),
'forslummet': ('forslumme',),
'forslo': ('forslå',),
'forslå': ('forslå',),
'forslåes': ('forslå',),
'forslår': ('forslå',),
'forslås': ('forslå',),
'forslått': ('forslå',),
'forsmå': ('forsmå',),
'forsmådd': ('forsmå',),
'forsmådde': ('forsmå',),
'forsmår': ('forsmå',),
'forsmås': ('forsmå',),
'forsnakk': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakke': ('forsnakke',),
'forsnakker': ('forsnakke',),
'forsnakkes': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnevr': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevre': ('forsnevre',),
'forsnevrer': ('forsnevre',),
'forsnevres': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forson': ('forsone',),
'forsona': ('forsone',),
'forsone': ('forsone',),
'forsoner': ('forsone',),
'forsones': ('forsone',),
'forsonet': ('forsone',),
'forsont': ('forsone',),
'forsonte': ('forsone',),
'forsov': ('forsove',),
'forsove': ('forsove',),
'forsover': ('forsove',),
'forsoves': ('forsove',),
'forsovet': ('forsove',),
'forspenn': ('forspenne',),
'forspenne': ('forspenne',),
'forspenner': ('forspenne',),
'forspennes': ('forspenne',),
'forspent': ('forspenne',),
'forspente': ('forspenne',),
'forspenn': ('forspenne',),
'forspenne': ('forspenne',),
'forspenner': ('forspenne',),
'forspennes': ('forspenne',),
'forspent': ('forspenne',),
'forspente': ('forspenne',),
'forspill': ('forspille',),
'forspille': ('forspille',),
'forspiller': ('forspille',),
'forspilles': ('forspille',),
'forspilt': ('forspille',),
'forspilte': ('forspille',),
'forspis': ('forspise',),
'forspise': ('forspise',),
'forspiser': ('forspise',),
'forspises': ('forspise',),
'forspist': ('forspise',),
'forspiste': ('forspise',),
'forspurt': ('forspørre',),
'forspurte': ('forspørre',),
'forspør': ('forspørre',),
'forspørre': ('forspørre',),
'forspørres': ('forspørre',),
'forsterk': ('forsterke',),
'forsterka': ('forsterke',),
'forsterke': ('forsterke',),
'forsterker': ('forsterke',),
'forsterkes': ('forsterke',),
'forsterket': ('forsterke',),
'forstakk': ('forstikke',),
'forstikk': ('forstikke',),
'forstikke': ('forstikke',),
'forstikker': ('forstikke',),
'forstikkes': ('forstikke',),
'forstukket': ('forstikke',),
'forstill': ('forstille',),
'forstille': ('forstille',),
'forstiller': ('forstille',),
'forstilles': ('forstille',),
'forstilt': ('forstille',),
'forstilte': ('forstille',),
'forstu': ('forstue',),
'forstua': ('forstue',),
'forstue': ('forstue',),
'forstuer': ('forstue',),
'forstues': ('forstue',),
'forstuet': ('forstue',),
'forstu': ('forstue',),
'forstua': ('forstue',),
'forstue': ('forstue',),
'forstuer': ('forstue',),
'forstues': ('forstue',),
'forstuet': ('forstue',),
'forstu': ('forstue',),
'forstua': ('forstue',),
'forstue': ('forstue',),
'forstuer': ('forstue',),
'forstues': ('forstue',),
'forstuet': ('forstue',),
'forstum': ('forstumme',),
'forstumma': ('forstumme',),
'forstumme': ('forstumme',),
'forstummer': ('forstumme',),
'forstummes': ('forstumme',),
'forstummet': ('forstumme',),
'forstuv': ('forstuve',),
'forstuva': ('forstuve',),
'forstuve': ('forstuve',),
'forstuver': ('forstuve',),
'forstuves': ('forstuve',),
'forstuvet': ('forstuve',),
'forstuv': ('forstuve',),
'forstuva': ('forstuve',),
'forstuve': ('forstuve',),
'forstuver': ('forstuve',),
'forstuves': ('forstuve',),
'forstuvet': ('forstuve',),
'forstyrr': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrre': ('forstyrre',),
'forstyrrer': ('forstyrre',),
'forstyrres': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forsto': ('forstå',),
'forstod': ('forstå',),
'forstå': ('forstå',),
'forståes': ('forstå',),
'forstår': ('forstå',),
'forstås': ('forstå',),
'forstått': ('forstå',),
'forstørr': ('forstørre',),
'forstørra': ('forstørre',),
'forstørre': ('forstørre',),
'forstørrer': ('forstørre',),
'forstørres': ('forstørre',),
'forstørret': ('forstørre',),
'forstøt': ('forstøte',),
'forstøte': ('forstøte',),
'forstøter': ('forstøte',),
'forstøtes': ('forstøte',),
'forstøtt': ('forstøte',),
'forstøtte': ('forstøte',),
'forstøtt': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøtte': ('forstøtte',),
'forstøtter': ('forstøtte',),
'forstøttes': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøv': ('forstøve',),
'forstøva': ('forstøve',),
'forstøve': ('forstøve',),
'forstøver': ('forstøve',),
'forstøves': ('forstøve',),
'forstøvet': ('forstøve',),
'forsump': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpe': ('forsumpe',),
'forsumper': ('forsumpe',),
'forsumpes': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsur': ('forsure',),
'forsura': ('forsure',),
'forsure': ('forsure',),
'forsurer': ('forsure',),
'forsures': ('forsure',),
'forsuret': ('forsure',),
'forsvar': ('forsvare',),
'forsvare': ('forsvare',),
'forsvarer': ('forsvare',),
'forsvares': ('forsvare',),
'forsvart': ('forsvare',),
'forsvarte': ('forsvare',),
'forsvensk': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvenske': ('forsvenske',),
'forsvensker': ('forsvenske',),
'forsvenskes': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsverg': ('forsverge',),
'forsverga': ('forsverge',),
'forsverge': ('forsverge',),
'forsverger': ('forsverge',),
'forsverges': ('forsverge',),
'forsverget': ('forsverge',),
'forsvor': ('forsverge',),
'forsvoret': ('forsverge',),
'forsverj': ('forsverje',),
'forsverja': ('forsverje',),
'forsverje': ('forsverje',),
'forsverjer': ('forsverje',),
'forsverjes': ('forsverje',),
'forsverjet': ('forsverje',),
'forsvor': ('forsverje',),
'forsvoret': ('forsverje',),
'forsvann': ('forsvinne',),
'forsvant': ('forsvinne',),
'forsvinn': ('forsvinne',),
'forsvinne': ('forsvinne',),
'forsvinner': ('forsvinne',),
'forsvinnes': ('forsvinne',),
'forsvunnet': ('forsvinne',),
'forsynd': ('forsynde',),
'forsynda': ('forsynde',),
'forsynde': ('forsynde',),
'forsynder': ('forsynde',),
'forsyndes': ('forsynde',),
'forsyndet': ('forsynde',),
'forsyn': ('forsyne',),
'forsyne': ('forsyne',),
'forsyner': ('forsyne',),
'forsynes': ('forsyne',),
'forsynt': ('forsyne',),
'forsynte': ('forsyne',),
'forsøk': ('forsøke',),
'forsøke': ('forsøke',),
'forsøker': ('forsøke',),
'forsøkes': ('forsøke',),
'forsøkt': ('forsøke',),
'forsøkte': ('forsøke',),
'forsølv': ('forsølve',),
'forsølva': ('forsølve',),
'forsølve': ('forsølve',),
'forsølver': ('forsølve',),
'forsølves': ('forsølve',),
'forsølvet': ('forsølve',),
'forsøm': ('forsømme',),
'forsømme': ('forsømme',),
'forsømmer': ('forsømme',),
'forsømmes': ('forsømme',),
'forsømt': ('forsømme',),
'forsømte': ('forsømme',),
'forsøpl': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøple': ('forsøple',),
'forsøpler': ('forsøple',),
'forsøples': ('forsøple',),
'forsøplet': ('forsøple',),
'forsørg': ('forsørge',),
'forsørga': ('forsørge',),
'forsørgd': ('forsørge',),
'forsørgde': ('forsørge',),
'forsørge': ('forsørge',),
'forsørger': ('forsørge',),
'forsørges': ('forsørge',),
'forsørget': ('forsørge',),
'forsøt': ('forsøte',),
'forsøta': ('forsøte',),
'forsøte': ('forsøte',),
'forsøter': ('forsøte',),
'forsøtes': ('forsøte',),
'forsøtet': ('forsøte',),
'forta': ('forta',),
'fortaes': ('forta',),
'fortar': ('forta',),
'fortas': ('forta',),
'fortatt': ('forta',),
'fortok': ('forta',),
'fortap': ('fortape',),
'fortape': ('fortape',),
'fortaper': ('fortape',),
'fortapes': ('fortape',),
'fortapt': ('fortape',),
'fortapte': ('fortape',),
'fort': ('forte',),
'forta': ('forte',),
'forte': ('forte',),
'forter': ('forte',),
'fortes': ('forte',),
'fortet': ('forte',),
'fortegn': ('fortegne',),
'fortegna': ('fortegne',),
'fortegne': ('fortegne',),
'fortegner': ('fortegne',),
'fortegnes': ('fortegne',),
'fortegnet': ('fortegne',),
'fortalt': ('fortelle',),
'fortalte': ('fortelle',),
'fortell': ('fortelle',),
'fortelle': ('fortelle',),
'forteller': ('fortelle',),
'fortelles': ('fortelle',),
'fortenk': ('fortenke',),
'fortenke': ('fortenke',),
'fortenker': ('fortenke',),
'fortenkes': ('fortenke',),
'fortenkt': ('fortenke',),
'fortenkte': ('fortenke',),
'fortett': ('fortette',),
'fortetta': ('fortette',),
'fortette': ('fortette',),
'fortetter': ('fortette',),
'fortettes': ('fortette',),
'fortettet': ('fortette',),
'forti': ('fortie',),
'fortia': ('fortie',),
'fortidd': ('fortie',),
'fortidde': ('fortie',),
'fortie': ('fortie',),
'fortier': ('fortie',),
'forties': ('fortie',),
'fortiet': ('fortie',),
'fortinn': ('fortinne',),
'fortinna': ('fortinne',),
'fortinne': ('fortinne',),
'fortinner': ('fortinne',),
'fortinnes': ('fortinne',),
'fortinnet': ('fortinne',),
'fortjen': ('fortjene',),
'fortjene': ('fortjene',),
'fortjener': ('fortjene',),
'fortjenes': ('fortjene',),
'fortjent': ('fortjene',),
'fortjente': ('fortjene',),
'fortn': ('fortne',),
'fortna': ('fortne',),
'fortne': ('fortne',),
'fortner': ('fortne',),
'fortnes': ('fortne',),
'fortnet': ('fortne',),
'fortolk': ('fortolke',),
'fortolka': ('fortolke',),
'fortolke': ('fortolke',),
'fortolker': ('fortolke',),
'fortolkes': ('fortolke',),
'fortolket': ('fortolke',),
'fortoll': ('fortolle',),
'fortolla': ('fortolle',),
'fortolle': ('fortolle',),
'fortoller': ('fortolle',),
'fortolles': ('fortolle',),
'fortollet': ('fortolle',),
'forton': ('fortone',),
'fortona': ('fortone',),
'fortone': ('fortone',),
'fortoner': ('fortone',),
'fortones': ('fortone',),
'fortonet': ('fortone',),
'fortont': ('fortone',),
'fortonte': ('fortone',),
'fortorv': ('fortorve',),
'fortorva': ('fortorve',),
'fortorve': ('fortorve',),
'fortorver': ('fortorve',),
'fortorves': ('fortorve',),
'fortorvet': ('fortorve',),
'fortrakk': ('fortrekke',),
'fortrekk': ('fortrekke',),
'fortrekke': ('fortrekke',),
'fortrekker': ('fortrekke',),
'fortrekkes': ('fortrekke',),
'fortrukket': ('fortrekke',),
'fortreng': ('fortrenge',),
'fortrenge': ('fortrenge',),
'fortrenger': ('fortrenge',),
'fortrenges': ('fortrenge',),
'fortrengt': ('fortrenge',),
'fortrengte': ('fortrenge',),
'fortroll': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrolle': ('fortrolle',),
'fortroller': ('fortrolle',),
'fortrolles': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortryll': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortrylle': ('fortrylle',),
'fortryller': ('fortrylle',),
'fortrylles': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortrylt': ('fortrylle',),
'fortrylte': ('fortrylle',),
'fortrutt': ('fortryte',),
'fortryt': ('fortryte',),
'fortryte': ('fortryte',),
'fortryter': ('fortryte',),
'fortrytes': ('fortryte',),
'fortrøt': ('fortryte',),
'fortrøst': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøste': ('fortrøste',),
'fortrøster': ('fortrøste',),
'fortrøstes': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortsatt': ('fortsette',),
'fortsatte': ('fortsette',),
'fortsett': ('fortsette',),
'fortsette': ('fortsette',),
'fortsetter': ('fortsette',),
'fortsettes': ('fortsette',),
'fortvil': ('fortvile',),
'fortvile': ('fortvile',),
'fortviler': ('fortvile',),
'fortviles': ('fortvile',),
'fortvilt': ('fortvile',),
'fortvilte': ('fortvile',),
'fortykk': ('fortykke',),
'fortykka': ('fortykke',),
'fortykke': ('fortykke',),
'fortykker': ('fortykke',),
'fortykkes': ('fortykke',),
'fortykket': ('fortykke',),
'fortynn': ('fortynne',),
'fortynna': ('fortynne',),
'fortynne': ('fortynne',),
'fortynner': ('fortynne',),
'fortynnes': ('fortynne',),
'fortynnet': ('fortynne',),
'fortær': ('fortære',),
'fortære': ('fortære',),
'fortærer': ('fortære',),
'fortæres': ('fortære',),
'fortært': ('fortære',),
'fortærte': ('fortære',),
'fortørn': ('fortørne',),
'fortørna': ('fortørne',),
'fortørne': ('fortørne',),
'fortørner': ('fortørne',),
'fortørnes': ('fortørne',),
'fortørnet': ('fortørne',),
'fortøy': ('fortøye',),
'fortøyd': ('fortøye',),
'fortøyde': ('fortøye',),
'fortøye': ('fortøye',),
'fortøyer': ('fortøye',),
'fortøyes': ('fortøye',),
'foruleilig': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleilige': ('foruleilige',),
'foruleiliger': ('foruleilige',),
'foruleiliges': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'forulemp': ('forulempe',),
'forulempa': ('forulempe',),
'forulempe': ('forulempe',),
'forulemper': ('forulempe',),
'forulempes': ('forulempe',),
'forulempet': ('forulempe',),
'forulykk': ('forulykke',),
'forulykka': ('forulykke',),
'forulykke': ('forulykke',),
'forulykker': ('forulykke',),
'forulykkes': ('forulykke',),
'forulykket': ('forulykke',),
'forundr': ('forundre',),
'forundra': ('forundre',),
'forundre': ('forundre',),
'forundrer': ('forundre',),
'forundres': ('forundre',),
'forundret': ('forundre',),
'forundr': ('forundre',),
'forundra': ('forundre',),
'forundre': ('forundre',),
'forundrer': ('forundre',),
'forundres': ('forundre',),
'forundret': ('forundre',),
'forunn': ('forunne',),
'forunne': ('forunne',),
'forunner': ('forunne',),
'forunnes': ('forunne',),
'forunt': ('forunne',),
'forunte': ('forunne',),
'forurens': ('forurense',),
'forurensa': ('forurense',),
'forurense': ('forurense',),
'forurenser': ('forurense',),
'forurenses': ('forurense',),
'forurenset': ('forurense',),
'forurett': ('forurette',),
'foruretta': ('forurette',),
'forurette': ('forurette',),
'foruretter': ('forurette',),
'forurettes': ('forurette',),
'forurettet': ('forurette',),
'forurolig': ('forurolige',),
'foruroliga': ('forurolige',),
'forurolige': ('forurolige',),
'foruroliger': ('forurolige',),
'foruroliges': ('forurolige',),
'foruroliget': ('forurolige',),
'forutberegn': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegne': ('forutberegne',),
'forutberegner': ('forutberegne',),
'forutberegnes': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberekn': ('forutberekne',),
'forutberekna': ('forutberekne',),
'forutberekne': ('forutberekne',),
'forutberekner': ('forutberekne',),
'forutbereknes': ('forutberekne',),
'forutbereknet': ('forutberekne',),
'forutbestem': ('forutbestemme',),
'forutbestemme': ('forutbestemme',),
'forutbestemmer': ('forutbestemme',),
'forutbestemmes': ('forutbestemme',),
'forutbestemt': ('forutbestemme',),
'forutbestemte': ('forutbestemme',),
'forutse': ('forutse',),
'forutsees': ('forutse',),
'forutser': ('forutse',),
'forutses': ('forutse',),
'forutsett': ('forutse',),
'forutså': ('forutse',),
'forutsåg': ('forutse',),
'forutsatt': ('forutsette',),
'forutsatte': ('forutsette',),
'forutsett': ('forutsette',),
'forutsette': ('forutsette',),
'forutsetter': ('forutsette',),
'forutsettes': ('forutsette',),
'forutskikk': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikke': ('forutskikke',),
'forutskikker': ('forutskikke',),
'forutskikkes': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forvalt': ('forvalte',),
'forvalta': ('forvalte',),
'forvalte': ('forvalte',),
'forvalter': ('forvalte',),
'forvaltes': ('forvalte',),
'forvaltet': ('forvalte',),
'forvandl': ('forvandle',),
'forvandla': ('forvandle',),
'forvandle': ('forvandle',),
'forvandler': ('forvandle',),
'forvandles': ('forvandle',),
'forvandlet': ('forvandle',),
'forvansk': ('forvanske',),
'forvanska': ('forvanske',),
'forvanske': ('forvanske',),
'forvansker': ('forvanske',),
'forvanskes': ('forvanske',),
'forvansket': ('forvanske',),
'forvar': ('forvare',),
'forvare': ('forvare',),
'forvarer': ('forvare',),
'forvares': ('forvare',),
'forvart': ('forvare',),
'forvarte': ('forvare',),
'forved': ('forvede',),
'forveda': ('forvede',),
'forvede': ('forvede',),
'forveder': ('forvede',),
'forvedes': ('forvede',),
'forvedet': ('forvede',),
'forveksl': ('forveksle',),
'forveksla': ('forveksle',),
'forveksle': ('forveksle',),
'forveksler': ('forveksle',),
'forveksles': ('forveksle',),
'forvekslet': ('forveksle',),
'forvell': ('forvelle',),
'forvella': ('forvelle',),
'forvelle': ('forvelle',),
'forveller': ('forvelle',),
'forvelles': ('forvelle',),
'forvellet': ('forvelle',),
'forvelt': ('forvelle',),
'forvelte': ('forvelle',),
'forvenn': ('forvenne',),
'forvenne': ('forvenne',),
'forvenner': ('forvenne',),
'forvennes': ('forvenne',),
'forvent': ('forvenne',),
'forvente': ('forvenne',),
'forvent': ('forvente',),
'forventa': ('forvente',),
'forvente': ('forvente',),
'forventer': ('forvente',),
'forventes': ('forvente',),
'forventet': ('forvente',),
'forverr': ('forverre',),
'forverra': ('forverre',),
'forverre': ('forverre',),
'forverrer': ('forverre',),
'forverres': ('forverre',),
'forverret': ('forverre',),
'forvill': ('forville',),
'forvilla': ('forville',),
'forville': ('forville',),
'forviller': ('forville',),
'forvilles': ('forville',),
'forvillet': ('forville',),
'forvirr': ('forvirre',),
'forvirra': ('forvirre',),
'forvirre': ('forvirre',),
'forvirrer': ('forvirre',),
'forvirres': ('forvirre',),
'forvirret': ('forvirre',),
'forvis': ('forvise',),
'forvise': ('forvise',),
'forviser': ('forvise',),
'forvises': ('forvise',),
'forvist': ('forvise',),
'forviste': ('forvise',),
'forviss': ('forvisse',),
'forvissa': ('forvisse',),
'forvisse': ('forvisse',),
'forvisser': ('forvisse',),
'forvisses': ('forvisse',),
'forvisset': ('forvisse',),
'forvitr': ('forvitre',),
'forvitra': ('forvitre',),
'forvitre': ('forvitre',),
'forvitrer': ('forvitre',),
'forvitres': ('forvitre',),
'forvitret': ('forvitre',),
'forvold': ('forvolde',),
'forvolde': ('forvolde',),
'forvolder': ('forvolde',),
'forvoldes': ('forvolde',),
'forvoldt': ('forvolde',),
'forvoldte': ('forvolde',),
'forvreng': ('forvrenge',),
'forvrenge': ('forvrenge',),
'forvrenger': ('forvrenge',),
'forvrenges': ('forvrenge',),
'forvrengt': ('forvrenge',),
'forvrengte': ('forvrenge',),
'forvred': ('forvri',),
'forvrei': ('forvri',),
'forvreid': ('forvri',),
'forvri': ('forvri',),
'forvridd': ('forvri',),
'forvridde': ('forvri',),
'forvrir': ('forvri',),
'forvris': ('forvri',),
'foryng': ('forynge',),
'forynga': ('forynge',),
'forynge': ('forynge',),
'forynger': ('forynge',),
'forynges': ('forynge',),
'forynget': ('forynge',),
'forårsak': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsake': ('forårsake',),
'forårsaker': ('forårsake',),
'forårsakes': ('forårsake',),
'forårsaket': ('forårsake',),
'forær': ('forære',),
'forære': ('forære',),
'forærer': ('forære',),
'foræres': ('forære',),
'forært': ('forære',),
'forærte': ('forære',),
'forød': ('forøde',),
'forøda': ('forøde',),
'forøde': ('forøde',),
'forøder': ('forøde',),
'forødes': ('forøde',),
'forødet': ('forøde',),
'forødt': ('forøde',),
'forødte': ('forøde',),
'forøk': ('forøke',),
'forøka': ('forøke',),
'forøke': ('forøke',),
'forøker': ('forøke',),
'forøkes': ('forøke',),
'forøket': ('forøke',),
'forøkt': ('forøke',),
'forøkte': ('forøke',),
'forøv': ('forøve',),
'forøva': ('forøve',),
'forøvd': ('forøve',),
'forøvde': ('forøve',),
'forøve': ('forøve',),
'forøver': ('forøve',),
'forøves': ('forøve',),
'forøvet': ('forøve',),
'fosforescer': ('fosforescere',),
'fosforescere': ('fosforescere',),
'fosforescerer': ('fosforescere',),
'fosforesceres': ('fosforescere',),
'fosforescert': ('fosforescere',),
'fosforescerte': ('fosforescere',),
'foss': ('fosse',),
'fossa': ('fosse',),
'fosse': ('fosse',),
'fosser': ('fosse',),
'fosses': ('fosse',),
'fosset': ('fosse',),
'fosskok': ('fosskoke',),
'fosskoke': ('fosskoke',),
'fosskoker': ('fosskoke',),
'fosskokes': ('fosskoke',),
'fosskokt': ('fosskoke',),
'fosskokte': ('fosskoke',),
'fossregn': ('fossregne',),
'fossregna': ('fossregne',),
'fossregne': ('fossregne',),
'fossregner': ('fossregne',),
'fossregnes': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnt': ('fossregne',),
'fossregnte': ('fossregne',),
'fossro': ('fossro',),
'fossrodd': ('fossro',),
'fossrodde': ('fossro',),
'fossror': ('fossro',),
'fossros': ('fossro',),
'fostr': ('fostre',),
'fostra': ('fostre',),
'fostre': ('fostre',),
'fostrer': ('fostre',),
'fostres': ('fostre',),
'fostret': ('fostre',),
'fot': ('fote',),
'fota': ('fote',),
'fote': ('fote',),
'foter': ('fote',),
'fotes': ('fote',),
'fotet': ('fote',),
'fotografer': ('fotografere',),
'fotografere': ('fotografere',),
'fotograferer': ('fotografere',),
'fotograferes': ('fotografere',),
'fotografert': ('fotografere',),
'fotograferte': ('fotografere',),
'fotokopier': ('fotokopiere',),
'fotokopiere': ('fotokopiere',),
'fotokopierer': ('fotokopiere',),
'fotokopieres': ('fotokopiere',),
'fotokopiert': ('fotokopiere',),
'fotokopierte': ('fotokopiere',),
'fraba': ('frabe',),
'frabad': ('frabe',),
'frabe': ('frabe',),
'frabedt': ('frabe',),
'fraber': ('frabe',),
'frabes': ('frabe',),
'frabeordr': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordre': ('frabeordre',),
'frabeordrer': ('frabeordre',),
'frabeordres': ('frabeordre',),
'frabeordret': ('frabeordre',),
'fradøm': ('fradømme',),
'fradømme': ('fradømme',),
'fradømmer': ('fradømme',),
'fradømmes': ('fradømme',),
'fradømt': ('fradømme',),
'fradømte': ('fradømme',),
'fraflytt': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflytte': ('fraflytte',),
'fraflytter': ('fraflytte',),
'fraflyttes': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fragmenter': ('fragmentere',),
'fragmentere': ('fragmentere',),
'fragmenterer': ('fragmentere',),
'fragmenteres': ('fragmentere',),
'fragmentert': ('fragmentere',),
'fragmenterte': ('fragmentere',),
'fragikk': ('fragå',),
'fragjekk': ('fragå',),
'fragå': ('fragå',),
'fragåes': ('fragå',),
'fragår': ('fragå',),
'fragås': ('fragå',),
'fragått': ('fragå',),
'frakjenn': ('frakjenne',),
'frakjenne': ('frakjenne',),
'frakjenner': ('frakjenne',),
'frakjennes': ('frakjenne',),
'frakjent': ('frakjenne',),
'frakjente': ('frakjenne',),
'frakobl': ('frakoble',),
'frakobla': ('frakoble',),
'frakoble': ('frakoble',),
'frakobler': ('frakoble',),
'frakobles': ('frakoble',),
'frakoblet': ('frakoble',),
'frakopl': ('frakople',),
'frakopla': ('frakople',),
'frakople': ('frakople',),
'frakopler': ('frakople',),
'frakoples': ('frakople',),
'frakoplet': ('frakople',),
'fraksjoner': ('fraksjonere',),
'fraksjonere': ('fraksjonere',),
'fraksjonerer': ('fraksjonere',),
'fraksjoneres': ('fraksjonere',),
'fraksjonert': ('fraksjonere',),
'fraksjonerte': ('fraksjonere',),
'frakt': ('frakte',),
'frakta': ('frakte',),
'frakte': ('frakte',),
'frakter': ('frakte',),
'fraktes': ('frakte',),
'fraktet': ('frakte',),
'frala': ('fralegge',),
'fralagt': ('fralegge',),
'fralegg': ('fralegge',),
'fralegge': ('fralegge',),
'fralegger': ('fralegge',),
'fralegges': ('fralegge',),
'fralokk': ('fralokke',),
'fralokka': ('fralokke',),
'fralokke': ('fralokke',),
'fralokker': ('fralokke',),
'fralokkes': ('fralokke',),
'fralokket': ('fralokke',),
'framdater': ('framdatere',),
'framdatere': ('framdatere',),
'framdaterer': ('framdatere',),
'framdateres': ('framdatere',),
'framdatert': ('framdatere',),
'framdaterte': ('framdatere',),
'framelsk': ('framelske',),
'framelska': ('framelske',),
'framelske': ('framelske',),
'framelsker': ('framelske',),
'framelskes': ('framelske',),
'framelsket': ('framelske',),
'framfør': ('framføre',),
'framføre': ('framføre',),
'framfører': ('framføre',),
'framføres': ('framføre',),
'framført': ('framføre',),
'framførte': ('framføre',),
'framgikk': ('framgå',),
'framgjekk': ('framgå',),
'framgå': ('framgå',),
'framgåes': ('framgå',),
'framgår': ('framgå',),
'framgås': ('framgå',),
'framgått': ('framgå',),
'framhev': ('framheve',),
'framheva': ('framheve',),
'framhevd': ('framheve',),
'framhevde': ('framheve',),
'framheve': ('framheve',),
'framhever': ('framheve',),
'framheves': ('framheve',),
'framhevet': ('framheve',),
'framhold': ('framholde',),
'framholde': ('framholde',),
'framholder': ('framholde',),
'framholdes': ('framholde',),
'framholdt': ('framholde',),
'framkall': ('framkalle',),
'framkalle': ('framkalle',),
'framkaller': ('framkalle',),
'framkalles': ('framkalle',),
'framkalt': ('framkalle',),
'framkalte': ('framkalle',),
'framkast': ('framkaste',),
'framkasta': ('framkaste',),
'framkaste': ('framkaste',),
'framkaster': ('framkaste',),
'framkastes': ('framkaste',),
'framkastet': ('framkaste',),
'framla': ('framlegge',),
'framlagt': ('framlegge',),
'framlegg': ('framlegge',),
'framlegge': ('framlegge',),
'framlegger': ('framlegge',),
'framlegges': ('framlegge',),
'framlei': ('framleie',),
'framleid': ('framleie',),
'framleide': ('framleie',),
'framleie': ('framleie',),
'framleier': ('framleie',),
'framleies': ('framleie',),
'framleiet': ('framleie',),
'framsatt': ('framsette',),
'framsatte': ('framsette',),
'framsett': ('framsette',),
'framsette': ('framsette',),
'framsetter': ('framsette',),
'framsettes': ('framsette',),
'framsa': ('framsi',),
'framsagt': ('framsi',),
'framsi': ('framsi',),
'framsier': ('framsi',),
'framsies': ('framsi',),
'framsis': ('framsi',),
'framskaff': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffe': ('framskaffe',),
'framskaffer': ('framskaffe',),
'framskaffes': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskreiv': ('framskrive',),
'framskrev': ('framskrive',),
'framskrevet': ('framskrive',),
'framskriv': ('framskrive',),
'framskrive': ('framskrive',),
'framskriver': ('framskrive',),
'framskrives': ('framskrive',),
'framskynd': ('framskynde',),
'framskynda': ('framskynde',),
'framskynde': ('framskynde',),
'framskynder': ('framskynde',),
'framskyndes': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndt': ('framskynde',),
'framskyndte': ('framskynde',),
'framskaut': ('framskyte',),
'framskjøt': ('framskyte',),
'framskutt': ('framskyte',),
'framskyt': ('framskyte',),
'framskyte': ('framskyte',),
'framskyter': ('framskyte',),
'framskytes': ('framskyte',),
'framskøyt': ('framskyte',),
'framstill': ('framstille',),
'framstille': ('framstille',),
'framstiller': ('framstille',),
'framstilles': ('framstille',),
'framstilt': ('framstille',),
'framstilte': ('framstille',),
'framsto': ('framstå',),
'framstod': ('framstå',),
'framstå': ('framstå',),
'framståes': ('framstå',),
'framstår': ('framstå',),
'framstås': ('framstå',),
'framstått': ('framstå',),
'framvis': ('framvise',),
'framvise': ('framvise',),
'framviser': ('framvise',),
'framvises': ('framvise',),
'framvist': ('framvise',),
'framviste': ('framvise',),
'franarr': ('franarre',),
'franarra': ('franarre',),
'franarre': ('franarre',),
'franarrer': ('franarre',),
'franarres': ('franarre',),
'franarret': ('franarre',),
'franker': ('frankere',),
'frankere': ('frankere',),
'frankerer': ('frankere',),
'frankeres': ('frankere',),
'frankert': ('frankere',),
'frankerte': ('frankere',),
'frapper': ('frappere',),
'frappere': ('frappere',),
'frapperer': ('frappere',),
'frapperes': ('frappere',),
'frappert': ('frappere',),
'frapperte': ('frappere',),
'fraran': ('frarane',),
'frarana': ('frarane',),
'frarane': ('frarane',),
'fraraner': ('frarane',),
'fraranes': ('frarane',),
'fraranet': ('frarane',),
'frarant': ('frarane',),
'frarante': ('frarane',),
'frarå': ('frarå',),
'frarådd': ('frarå',),
'frarådde': ('frarå',),
'frarår': ('frarå',),
'frarås': ('frarå',),
'fraråd': ('fraråde',),
'fraråda': ('fraråde',),
'frarådd': ('fraråde',),
'frarådde': ('fraråde',),
'fraråde': ('fraråde',),
'fraråder': ('fraråde',),
'frarådes': ('fraråde',),
'frarådet': ('fraråde',),
'fraselg': ('fraselge',),
'fraselge': ('fraselge',),
'fraselger': ('fraselge',),
'fraselges': ('fraselge',),
'frasolgt': ('fraselge',),
'frasolgte': ('fraselge',),
'fraser': ('frasere',),
'frasere': ('frasere',),
'fraserer': ('frasere',),
'fraseres': ('frasere',),
'frasert': ('frasere',),
'fraserte': ('frasere',),
'frasa': ('frasi',),
'frasagt': ('frasi',),
'frasi': ('frasi',),
'frasier': ('frasi',),
'frasies': ('frasi',),
'frasis': ('frasi',),
'fraskill': ('fraskille',),
'fraskille': ('fraskille',),
'fraskiller': ('fraskille',),
'fraskilles': ('fraskille',),
'fraskilt': ('fraskille',),
'fraskilte': ('fraskille',),
'fraskjøt': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøte': ('fraskjøte',),
'fraskjøter': ('fraskjøte',),
'fraskjøtes': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtt': ('fraskjøte',),
'fraskjøtte': ('fraskjøte',),
'fraskreiv': ('fraskrive',),
'fraskrev': ('fraskrive',),
'fraskrevet': ('fraskrive',),
'fraskriv': ('fraskrive',),
'fraskrive': ('fraskrive',),
'fraskriver': ('fraskrive',),
'fraskrives': ('fraskrive',),
'frastjal': ('frastjele',),
'frastjel': ('frastjele',),
'frastjele': ('frastjele',),
'frastjeler': ('frastjele',),
'frastjeles': ('frastjele',),
'frastjålet': ('frastjele',),
'frastøt': ('frastøte',),
'frastøte': ('frastøte',),
'frastøter': ('frastøte',),
'frastøtes': ('frastøte',),
'frastøtt': ('frastøte',),
'frastøtte': ('frastøte',),
'frata': ('frata',),
'frataes': ('frata',),
'fratar': ('frata',),
'fratas': ('frata',),
'fratatt': ('frata',),
'fratok': ('frata',),
'fraterniser': ('fraternisere',),
'fraternisere': ('fraternisere',),
'fraterniserer': ('fraternisere',),
'fraterniseres': ('fraternisere',),
'fraternisert': ('fraternisere',),
'fraterniserte': ('fraternisere',),
'fratre': ('fratre',),
'fratrer': ('fratre',),
'fratres': ('fratre',),
'fratrådt': ('fratre',),
'fratrådte': ('fratre',),
'fraveik': ('fravike',),
'fravek': ('fravike',),
'fraveket': ('fravike',),
'fravik': ('fravike',),
'fravike': ('fravike',),
'fraviker': ('fravike',),
'fravikes': ('fravike',),
'fravrist': ('fravriste',),
'fravrista': ('fravriste',),
'fravriste': ('fravriste',),
'fravrister': ('fravriste',),
'fravristes': ('fravriste',),
'fravristet': ('fravriste',),
'fred': ('frede',),
'freda': ('frede',),
'frede': ('frede',),
'freder': ('frede',),
'fredes': ('frede',),
'fredet': ('frede',),
'freg': ('frege',),
'frega': ('frege',),
'frege': ('frege',),
'freger': ('frege',),
'freges': ('frege',),
'freget': ('frege',),
'frekventer': ('frekventere',),
'frekventere': ('frekventere',),
'frekventerer': ('frekventere',),
'frekventeres': ('frekventere',),
'frekventert': ('frekventere',),
'frekventerte': ('frekventere',),
'frels': ('frelse',),
'frelse': ('frelse',),
'frelser': ('frelse',),
'frelses': ('frelse',),
'frelst': ('frelse',),
'frelste': ('frelse',),
'fremdater': ('fremdatere',),
'fremdatere': ('fremdatere',),
'fremdaterer': ('fremdatere',),
'fremdateres': ('fremdatere',),
'fremdatert': ('fremdatere',),
'fremdaterte': ('fremdatere',),
'fremelsk': ('fremelske',),
'fremelska': ('fremelske',),
'fremelske': ('fremelske',),
'fremelsker': ('fremelske',),
'fremelskes': ('fremelske',),
'fremelsket': ('fremelske',),
'fremfør': ('fremføre',),
'fremføre': ('fremføre',),
'fremfører': ('fremføre',),
'fremføres': ('fremføre',),
'fremført': ('fremføre',),
'fremførte': ('fremføre',),
'fremgikk': ('fremgå',),
'fremgjekk': ('fremgå',),
'fremgå': ('fremgå',),
'fremgåes': ('fremgå',),
'fremgår': ('fremgå',),
'fremgås': ('fremgå',),
'fremgått': ('fremgå',),
'fremhev': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevd': ('fremheve',),
'fremhevde': ('fremheve',),
'fremheve': ('fremheve',),
'fremhever': ('fremheve',),
'fremheves': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhold': ('fremholde',),
'fremholde': ('fremholde',),
'fremholder': ('fremholde',),
'fremholdes': ('fremholde',),
'fremholdt': ('fremholde',),
'fremkall': ('fremkalle',),
'fremkalle': ('fremkalle',),
'fremkaller': ('fremkalle',),
'fremkalles': ('fremkalle',),
'fremkalt': ('fremkalle',),
'fremkalte': ('fremkalle',),
'fremkast': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkaste': ('fremkaste',),
'fremkaster': ('fremkaste',),
'fremkastes': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremla': ('fremlegge',),
'fremlagt': ('fremlegge',),
'fremlegg': ('fremlegge',),
'fremlegge': ('fremlegge',),
'fremlegger': ('fremlegge',),
'fremlegges': ('fremlegge',),
'fremlei': ('fremleie',),
'fremleid': ('fremleie',),
'fremleide': ('fremleie',),
'fremleie': ('fremleie',),
'fremleier': ('fremleie',),
'fremleies': ('fremleie',),
'fremleiet': ('fremleie',),
'frem': ('fremme',),
'fremma': ('fremme',),
'fremme': ('fremme',),
'fremmer': ('fremme',),
'fremmes': ('fremme',),
'fremmet': ('fremme',),
'fremmedgjorde': ('fremmedgjøre',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjør': ('fremmedgjøre',),
'fremmedgjøre': ('fremmedgjøre',),
'fremmedgjøres': ('fremmedgjøre',),
'fremmedgjorde': ('fremmedgjøre',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjør': ('fremmedgjøre',),
'fremmedgjøre': ('fremmedgjøre',),
'fremmedgjøres': ('fremmedgjøre',),
'fremmendgjorde': ('fremmendgjøre',),
'fremmendgjort': ('fremmendgjøre',),
'fremmendgjør': ('fremmendgjøre',),
'fremmendgjøre': ('fremmendgjøre',),
'fremmendgjøres': ('fremmendgjøre',),
'fremmendgjorde': ('fremmendgjøre',),
'fremmendgjort': ('fremmendgjøre',),
'fremmendgjør': ('fremmendgjøre',),
'fremmendgjøre': ('fremmendgjøre',),
'fremmendgjøres': ('fremmendgjøre',),
'fremsatt': ('fremsette',),
'fremsatte': ('fremsette',),
'fremsett': ('fremsette',),
'fremsette': ('fremsette',),
'fremsetter': ('fremsette',),
'fremsettes': ('fremsette',),
'fremsa': ('fremsi',),
'fremsagt': ('fremsi',),
'fremsi': ('fremsi',),
'fremsier': ('fremsi',),
'fremsies': ('fremsi',),
'fremsis': ('fremsi',),
'fremskaff': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffe': ('fremskaffe',),
'fremskaffer': ('fremskaffe',),
'fremskaffes': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskreiv': ('fremskrive',),
'fremskrev': ('fremskrive',),
'fremskrevet': ('fremskrive',),
'fremskriv': ('fremskrive',),
'fremskrive': ('fremskrive',),
'fremskriver': ('fremskrive',),
'fremskrives': ('fremskrive',),
'fremskynd': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskynde': ('fremskynde',),
'fremskynder': ('fremskynde',),
'fremskyndes': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndt': ('fremskynde',),
'fremskyndte': ('fremskynde',),
'fremskaut': ('fremskyte',),
'fremskjøt': ('fremskyte',),
'fremskutt': ('fremskyte',),
'fremskyt': ('fremskyte',),
'fremskyte': ('fremskyte',),
'fremskyter': ('fremskyte',),
'fremskytes': ('fremskyte',),
'fremskøyt': ('fremskyte',),
'fremstill': ('fremstille',),
'fremstille': ('fremstille',),
'fremstiller': ('fremstille',),
'fremstilles': ('fremstille',),
'fremstilt': ('fremstille',),
'fremstilte': ('fremstille',),
'fremsto': ('fremstå',),
'fremstod': ('fremstå',),
'fremstå': ('fremstå',),
'fremståes': ('fremstå',),
'fremstår': ('fremstå',),
'fremstås': ('fremstå',),
'fremstått': ('fremstå',),
'fremvis': ('fremvise',),
'fremvise': ('fremvise',),
'fremviser': ('fremvise',),
'fremvises': ('fremvise',),
'fremvist': ('fremvise',),
'fremviste': ('fremvise',),
'fres': ('frese',),
'frese': ('frese',),
'freser': ('frese',),
'freses': ('frese',),
'frest': ('frese',),
'freste': ('frese',),
'fres': ('frese',),
'frese': ('frese',),
'freser': ('frese',),
'freses': ('frese',),
'frest': ('frese',),
'freste': ('frese',),
'frest': ('freste',),
'fresta': ('freste',),
'freste': ('freste',),
'frester': ('freste',),
'frestes': ('freste',),
'frestet': ('freste',),
'frett': ('frette',),
'fretta': ('frette',),
'frette': ('frette',),
'fretter': ('frette',),
'frettes': ('frette',),
'frettet': ('frette',),
'fri': ('fri',),
'fridd': ('fri',),
'fridde': ('fri',),
'frir': ('fri',),
'fris': ('fri',),
'fri': ('fri',),
'fridd': ('fri',),
'fridde': ('fri',),
'frir': ('fri',),
'fris': ('fri',),
'friga': ('frigi',),
'frigav': ('frigi',),
'frigi': ('frigi',),
'frigies': ('frigi',),
'frigir': ('frigi',),
'frigis': ('frigi',),
'frigitt': ('frigi',),
'frigjorde': ('frigjøre',),
'frigjort': ('frigjøre',),
'frigjør': ('frigjøre',),
'frigjøre': ('frigjøre',),
'frigjøres': ('frigjøre',),
'frikjenn': ('frikjenne',),
'frikjenne': ('frikjenne',),
'frikjenner': ('frikjenne',),
'frikjennes': ('frikjenne',),
'frikjent': ('frikjenne',),
'frikjente': ('frikjenne',),
'frilans': ('frilanse',),
'frilansa': ('frilanse',),
'frilanse': ('frilanse',),
'frilanser': ('frilanse',),
'frilanses': ('frilanse',),
'frilanset': ('frilanse',),
'frilist': ('friliste',),
'frilista': ('friliste',),
'friliste': ('friliste',),
'frilister': ('friliste',),
'frilistes': ('friliste',),
'frilistet': ('friliste',),
'friser': ('frisere',),
'frisere': ('frisere',),
'friserer': ('frisere',),
'friseres': ('frisere',),
'frisert': ('frisere',),
'friserte': ('frisere',),
'frisk': ('friske',),
'friska': ('friske',),
'friske': ('friske',),
'frisker': ('friske',),
'friskes': ('friske',),
'frisket': ('friske',),
'friskmeld': ('friskmelde',),
'friskmelde': ('friskmelde',),
'friskmelder': ('friskmelde',),
'friskmeldes': ('friskmelde',),
'friskmeldt': ('friskmelde',),
'friskmeldte': ('friskmelde',),
'friskn': ('friskne',),
'friskna': ('friskne',),
'friskne': ('friskne',),
'friskner': ('friskne',),
'frisknes': ('friskne',),
'frisknet': ('friskne',),
'frist': ('friste',),
'frista': ('friste',),
'friste': ('friste',),
'frister': ('friste',),
'fristes': ('friste',),
'fristet': ('friste',),
'frist': ('friste',),
'frista': ('friste',),
'friste': ('friste',),
'frister': ('friste',),
'fristes': ('friste',),
'fristet': ('friste',),
'frist': ('friste',),
'frista': ('friste',),
'friste': ('friste',),
'frister': ('friste',),
'fristes': ('friste',),
'fristet': ('friste',),
'frita': ('frita',),
'fritaes': ('frita',),
'fritar': ('frita',),
'fritas': ('frita',),
'fritatt': ('frita',),
'fritok': ('frita',),
'friter': ('fritere',),
'fritere': ('fritere',),
'friterer': ('fritere',),
'friteres': ('fritere',),
'fritert': ('fritere',),
'friterte': ('fritere',),
'fritt': ('fritte',),
'fritta': ('fritte',),
'fritte': ('fritte',),
'fritter': ('fritte',),
'frittes': ('fritte',),
'frittet': ('fritte',),
'fronder': ('frondere',),
'frondere': ('frondere',),
'fronderer': ('frondere',),
'fronderes': ('frondere',),
'frondert': ('frondere',),
'fronderte': ('frondere',),
'frotter': ('frottere',),
'frottere': ('frottere',),
'frotterer': ('frottere',),
'frotteres': ('frottere',),
'frottert': ('frottere',),
'frotterte': ('frottere',),
'frukt': ('frukte',),
'frukta': ('frukte',),
'frukte': ('frukte',),
'frukter': ('frukte',),
'fruktes': ('frukte',),
'fruktet': ('frukte',),
'frustrer': ('frustrere',),
'frustrere': ('frustrere',),
'frustrerer': ('frustrere',),
'frustreres': ('frustrere',),
'frustrert': ('frustrere',),
'frustrerte': ('frustrere',),
'fryd': ('fryde',),
'fryda': ('fryde',),
'fryde': ('fryde',),
'fryder': ('fryde',),
'frydes': ('fryde',),
'frydet': ('fryde',),
'frykt': ('frykte',),
'frykta': ('frykte',),
'frykte': ('frykte',),
'frykter': ('frykte',),
'fryktes': ('frykte',),
'fryktet': ('frykte',),
'fryns': ('frynse',),
'frynsa': ('frynse',),
'frynse': ('frynse',),
'frynser': ('frynse',),
'frynses': ('frynse',),
'frynset': ('frynse',),
'fråd': ('fråde',),
'fråda': ('fråde',),
'fråde': ('fråde',),
'fråder': ('fråde',),
'frådes': ('fråde',),
'frådet': ('fråde',),
'fråss': ('fråsse',),
'fråssa': ('fråsse',),
'fråsse': ('fråsse',),
'fråsser': ('fråsse',),
'fråsses': ('fråsse',),
'fråsset': ('fråsse',),
'fråts': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtse': ('fråtse',),
'fråtser': ('fråtse',),
'fråtses': ('fråtse',),
'fråtset': ('fråtse',),
'frø': ('frø',),
'frødd': ('frø',),
'frødde': ('frø',),
'frør': ('frø',),
'frøs': ('frø',),
'frøs': ('frøse',),
'frøse': ('frøse',),
'frøser': ('frøse',),
'frøses': ('frøse',),
'frøst': ('frøse',),
'frøste': ('frøse',),
'fug': ('fuge',),
'fuga': ('fuge',),
'fuge': ('fuge',),
'fuger': ('fuge',),
'fuges': ('fuge',),
'fuget': ('fuge',),
'fukt': ('fukte',),
'fukta': ('fukte',),
'fukte': ('fukte',),
'fukter': ('fukte',),
'fuktes': ('fukte',),
'fuktet': ('fukte',),
'fullbragt': ('fullbringe',),
'fullbragte': ('fullbringe',),
'fullbrakt': ('fullbringe',),
'fullbrakte': ('fullbringe',),
'fullbring': ('fullbringe',),
'fullbringe': ('fullbringe',),
'fullbringer': ('fullbringe',),
'fullbringes': ('fullbringe',),
'fullbyrd': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrde': ('fullbyrde',),
'fullbyrder': ('fullbyrde',),
'fullbyrdes': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullend': ('fullende',),
'fullende': ('fullende',),
'fullender': ('fullende',),
'fullendes': ('fullende',),
'fullendt': ('fullende',),
'fullendte': ('fullende',),
'fullfør': ('fullføre',),
'fullføre': ('fullføre',),
'fullfører': ('fullføre',),
'fullføres': ('fullføre',),
'fullført': ('fullføre',),
'fullførte': ('fullføre',),
'fullros': ('fullrose',),
'fullrose': ('fullrose',),
'fullroser': ('fullrose',),
'fullroses': ('fullrose',),
'fullrost': ('fullrose',),
'fullroste': ('fullrose',),
'fulltakk': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakke': ('fulltakke',),
'fulltakker': ('fulltakke',),
'fulltakkes': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fundamenter': ('fundamentere',),
'fundamentere': ('fundamentere',),
'fundamenterer': ('fundamentere',),
'fundamenteres': ('fundamentere',),
'fundamentert': ('fundamentere',),
'fundamenterte': ('fundamentere',),
'funder': ('fundere',),
'fundere': ('fundere',),
'funderer': ('fundere',),
'funderes': ('fundere',),
'fundert': ('fundere',),
'funderte': ('fundere',),
'funger': ('fungere',),
'fungere': ('fungere',),
'fungerer': ('fungere',),
'fungeres': ('fungere',),
'fungert': ('fungere',),
'fungerte': ('fungere',),
'funkl': ('funkle',),
'funkla': ('funkle',),
'funkle': ('funkle',),
'funkler': ('funkle',),
'funkles': ('funkle',),
'funklet': ('funkle',),
'funksjoner': ('funksjonere',),
'funksjonere': ('funksjonere',),
'funksjonerer': ('funksjonere',),
'funksjoneres': ('funksjonere',),
'funksjonert': ('funksjonere',),
'funksjonerte': ('funksjonere',),
'furasjer': ('furasjere',),
'furasjere': ('furasjere',),
'furasjerer': ('furasjere',),
'furasjeres': ('furasjere',),
'furasjert': ('furasjere',),
'furasjerte': ('furasjere',),
'fur': ('fure',),
'fura': ('fure',),
'fure': ('fure',),
'furer': ('fure',),
'fures': ('fure',),
'furet': ('fure',),
'furt': ('fure',),
'furte': ('fure',),
'furner': ('furnere',),
'furnere': ('furnere',),
'furnerer': ('furnere',),
'furneres': ('furnere',),
'furnert': ('furnere',),
'furnerte': ('furnere',),
'furt': ('furte',),
'furta': ('furte',),
'furte': ('furte',),
'furter': ('furte',),
'furtes': ('furte',),
'furtet': ('furte',),
'fus': ('fuse',),
'fuse': ('fuse',),
'fuser': ('fuse',),
'fuses': ('fuse',),
'fust': ('fuse',),
'fuste': ('fuse',),
'fusjoner': ('fusjonere',),
'fusjonere': ('fusjonere',),
'fusjonerer': ('fusjonere',),
'fusjoneres': ('fusjonere',),
'fusjonert': ('fusjonere',),
'fusjonerte': ('fusjonere',),
'fusk': ('fuske',),
'fuska': ('fuske',),
'fuske': ('fuske',),
'fusker': ('fuske',),
'fuskes': ('fuske',),
'fusket': ('fuske',),
'futt': ('futte',),
'futta': ('futte',),
'futte': ('futte',),
'futter': ('futte',),
'futtes': ('futte',),
'futtet': ('futte',),
'fauk': ('fyke',),
'fyk': ('fyke',),
'fyke': ('fyke',),
'fyker': ('fyke',),
'fykes': ('fyke',),
'føk': ('fyke',),
'føket': ('fyke',),
'føyk': ('fyke',),
'fylk': ('fylke',),
'fylka': ('fylke',),
'fylke': ('fylke',),
'fylker': ('fylke',),
'fylkes': ('fylke',),
'fylket': ('fylke',),
'fylkt': ('fylke',),
'fylkte': ('fylke',),
'fyll': ('fylle',),
'fylla': ('fylle',),
'fylle': ('fylle',),
'fyller': ('fylle',),
'fylles': ('fylle',),
'fyllet': ('fylle',),
'fyll': ('fylle',),
'fylle': ('fylle',),
'fyller': ('fylle',),
'fylles': ('fylle',),
'fylt': ('fylle',),
'fylte': ('fylle',),
'fyllekjør': ('fyllekjøre',),
'fyllekjøre': ('fyllekjøre',),
'fyllekjører': ('fyllekjøre',),
'fyllekjøres': ('fyllekjøre',),
'fyllekjørt': ('fyllekjøre',),
'fyllekjørte': ('fyllekjøre',),
'fyr': ('fyre',),
'fyre': ('fyre',),
'fyrer': ('fyre',),
'fyres': ('fyre',),
'fyrt': ('fyre',),
'fyrte': ('fyre',),
'fys': ('fyse',),
'fyse': ('fyse',),
'fyser': ('fyse',),
'fyses': ('fyse',),
'fyst': ('fyse',),
'fyste': ('fyse',),
'fekk': ('få',),
'fikk': ('få',),
'få': ('få',),
'fåes': ('få',),
'får': ('få',),
'fås': ('få',),
'fått': ('få',),
'fæl': ('fæle',),
'fæle': ('fæle',),
'fæler': ('fæle',),
'fæles': ('fæle',),
'fælt': ('fæle',),
'fælte': ('fæle',),
'fø': ('fø',),
'fødd': ('fø',),
'fødde': ('fø',),
'før': ('fø',),
'føs': ('fø',),
'fød': ('føde',),
'fødd': ('føde',),
'fødde': ('føde',),
'føde': ('føde',),
'føder': ('føde',),
'fødes': ('føde',),
'født': ('føde',),
'fødte': ('føde',),
'fød': ('føde',),
'fødd': ('føde',),
'fødde': ('føde',),
'føde': ('føde',),
'føder': ('føde',),
'fødes': ('føde',),
'født': ('føde',),
'fødte': ('føde',),
'føl': ('føle',),
'føle': ('føle',),
'føler': ('føle',),
'føles': ('føle',),
'følt': ('føle',),
'følte': ('føle',),
'følg': ('følgje',),
'følgje': ('følgje',),
'følgjer': ('følgje',),
'følgjes': ('følgje',),
'følgt': ('følgje',),
'følgte': ('følgje',),
'følg': ('følgje',),
'følgje': ('følgje',),
'følgjer': ('følgje',),
'følgjes': ('følgje',),
'følgt': ('følgje',),
'følgte': ('følgje',),
'føll': ('følle',),
'følla': ('følle',),
'følle': ('følle',),
'føller': ('følle',),
'følles': ('følle',),
'føllet': ('følle',),
'føn': ('føne',),
'føna': ('føne',),
'føne': ('føne',),
'føner': ('føne',),
'fønes': ('føne',),
'fønet': ('føne',),
'fønt': ('føne',),
'fønte': ('føne',),
'før': ('føre',),
'føre': ('føre',),
'fører': ('føre',),
'føres': ('føre',),
'ført': ('føre',),
'førte': ('føre',),
'førebu': ('førebu',),
'førebudd': ('førebu',),
'førebudde': ('førebu',),
'førebur': ('førebu',),
'førebus': ('førebu',),
'førtidspensjoner': ('førtidspensjonere',),
'førtidspensjonere': ('førtidspensjonere',),
'førtidspensjonerer': ('førtidspensjonere',),
'førtidspensjoneres': ('førtidspensjonere',),
'førtidspensjonert': ('førtidspensjonere',),
'førtidspensjonerte': ('førtidspensjonere',),
'føy': ('føye',),
'føya': ('føye',),
'føyd': ('føye',),
'føydd': ('føye',),
'føydde': ('føye',),
'føyde': ('føye',),
'føye': ('føye',),
'føyer': ('føye',),
'føyes': ('føye',),
'føyet': ('føye',),
'føyk': ('føyke',),
'føyka': ('føyke',),
'føyke': ('føyke',),
'føyker': ('føyke',),
'føykes': ('føyke',),
'føyket': ('føyke',),
'føykt': ('føyke',),
'føykte': ('føyke',),
'føys': ('føyse',),
'føyse': ('føyse',),
'føyser': ('føyse',),
'føyses': ('føyse',),
'føyst': ('føyse',),
'føyste': ('føyse',),
'gafl': ('gafle',),
'gafla': ('gafle',),
'gafle': ('gafle',),
'gafler': ('gafle',),
'gafles': ('gafle',),
'gaflet': ('gafle',),
'gagn': ('gagne',),
'gagna': ('gagne',),
'gagne': ('gagne',),
'gagner': ('gagne',),
'gagnes': ('gagne',),
'gagnet': ('gagne',),
'gakk': ('gakke',),
'gakka': ('gakke',),
'gakke': ('gakke',),
'gakker': ('gakke',),
'gakkes': ('gakke',),
'gakket': ('gakke',),
'galdr': ('galdre',),
'galdra': ('galdre',),
'galdre': ('galdre',),
'galdrer': ('galdre',),
'galdres': ('galdre',),
'galdret': ('galdre',),
'gal': ('gale',),
'gale': ('gale',),
'galer': ('gale',),
'gales': ('gale',),
'galt': ('gale',),
'galte': ('gale',),
'gol': ('gale',),
'galopper': ('galoppere',),
'galoppere': ('galoppere',),
'galopperer': ('galoppere',),
'galopperes': ('galoppere',),
'galoppert': ('galoppere',),
'galopperte': ('galoppere',),
'galvaniser': ('galvanisere',),
'galvanisere': ('galvanisere',),
'galvaniserer': ('galvanisere',),
'galvaniseres': ('galvanisere',),
'galvanisert': ('galvanisere',),
'galvaniserte': ('galvanisere',),
'gambl': ('gamble',),
'gambla': ('gamble',),
'gamble': ('gamble',),
'gambler': ('gamble',),
'gambles': ('gamble',),
'gamblet': ('gamble',),
'gand': ('gande',),
'ganda': ('gande',),
'gande': ('gande',),
'gander': ('gande',),
'gandes': ('gande',),
'gandet': ('gande',),
'gan': ('gane',),
'gana': ('gane',),
'gane': ('gane',),
'ganer': ('gane',),
'ganes': ('gane',),
'ganet': ('gane',),
'gant': ('gane',),
'gante': ('gane',),
'gang': ('gange',),
'ganga': ('gange',),
'gange': ('gange',),
'ganger': ('gange',),
'ganges': ('gange',),
'ganget': ('gange',),
'gant': ('gante',),
'ganta': ('gante',),
'gante': ('gante',),
'ganter': ('gante',),
'gantes': ('gante',),
'gantet': ('gante',),
'gantedes': ('gantes',),
'gantes': ('gantes',),
'gap': ('gape',),
'gapa': ('gape',),
'gape': ('gape',),
'gaper': ('gape',),
'gapes': ('gape',),
'gapt': ('gape',),
'gapte': ('gape',),
'gapskratt': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskratte': ('gapskratte',),
'gapskratter': ('gapskratte',),
'gapskrattes': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'garanter': ('garantere',),
'garantere': ('garantere',),
'garanterer': ('garantere',),
'garanteres': ('garantere',),
'garantert': ('garantere',),
'garanterte': ('garantere',),
'garder': ('gardere',),
'gardere': ('gardere',),
'garderer': ('gardere',),
'garderes': ('gardere',),
'gardert': ('gardere',),
'garderte': ('gardere',),
'garn': ('garne',),
'garna': ('garne',),
'garne': ('garne',),
'garner': ('garne',),
'garnes': ('garne',),
'garnet': ('garne',),
'garner': ('garnere',),
'garnere': ('garnere',),
'garnerer': ('garnere',),
'garneres': ('garnere',),
'garnert': ('garnere',),
'garnerte': ('garnere',),
'garnisoner': ('garnisonere',),
'garnisonere': ('garnisonere',),
'garnisonerer': ('garnisonere',),
'garnisoneres': ('garnisonere',),
'garnisonert': ('garnisonere',),
'garnisonerte': ('garnisonere',),
'garp': ('garpe',),
'garpa': ('garpe',),
'garpe': ('garpe',),
'garper': ('garpe',),
'garpes': ('garpe',),
'garpet': ('garpe',),
'garv': ('garve',),
'garva': ('garve',),
'garve': ('garve',),
'garver': ('garve',),
'garves': ('garve',),
'garvet': ('garve',),
'gasjer': ('gasjere',),
'gasjere': ('gasjere',),
'gasjerer': ('gasjere',),
'gasjeres': ('gasjere',),
'gasjert': ('gasjere',),
'gasjerte': ('gasjere',),
'gass': ('gasse',),
'gassa': ('gasse',),
'gasse': ('gasse',),
'gasser': ('gasse',),
'gasses': ('gasse',),
'gasset': ('gasse',),
'gass': ('gasse',),
'gassa': ('gasse',),
'gasse': ('gasse',),
'gasser': ('gasse',),
'gasses': ('gasse',),
'gasset': ('gasse',),
'gauk': ('gauke',),
'gauka': ('gauke',),
'gauke': ('gauke',),
'gauker': ('gauke',),
'gaukes': ('gauke',),
'gauket': ('gauke',),
'gaul': ('gaule',),
'gaula': ('gaule',),
'gaule': ('gaule',),
'gauler': ('gaule',),
'gaules': ('gaule',),
'gaulet': ('gaule',),
'gault': ('gaule',),
'gaulte': ('gaule',),
'gaum': ('gaume',),
'gauma': ('gaume',),
'gaume': ('gaume',),
'gaumer': ('gaume',),
'gaumes': ('gaume',),
'gaumet': ('gaume',),
'geberd': ('geberde',),
'geberda': ('geberde',),
'geberde': ('geberde',),
'geberder': ('geberde',),
'geberdes': ('geberde',),
'geberdet': ('geberde',),
'geip': ('geipe',),
'geipa': ('geipe',),
'geipe': ('geipe',),
'geiper': ('geipe',),
'geipes': ('geipe',),
'geipet': ('geipe',),
'geipt': ('geipe',),
'geipte': ('geipe',),
'geleid': ('geleide',),
'geleida': ('geleide',),
'geleide': ('geleide',),
'geleider': ('geleide',),
'geleides': ('geleide',),
'geleidet': ('geleide',),
'geminer': ('geminere',),
'geminere': ('geminere',),
'geminerer': ('geminere',),
'gemineres': ('geminere',),
'geminert': ('geminere',),
'geminerte': ('geminere',),
'generaliser': ('generalisere',),
'generalisere': ('generalisere',),
'generaliserer': ('generalisere',),
'generaliseres': ('generalisere',),
'generalisert': ('generalisere',),
'generaliserte': ('generalisere',),
'generer': ('generere',),
'generere': ('generere',),
'genererer': ('generere',),
'genereres': ('generere',),
'generert': ('generere',),
'genererte': ('generere',),
'genierklær': ('genierklære',),
'genierklære': ('genierklære',),
'genierklærer': ('genierklære',),
'genierklæres': ('genierklære',),
'genierklært': ('genierklære',),
'genierklærte': ('genierklære',),
'gerer': ('gerere',),
'gerere': ('gerere',),
'gererer': ('gerere',),
'gereres': ('gerere',),
'gerert': ('gerere',),
'gererte': ('gerere',),
'germaniser': ('germanisere',),
'germanisere': ('germanisere',),
'germaniserer': ('germanisere',),
'germaniseres': ('germanisere',),
'germanisert': ('germanisere',),
'germaniserte': ('germanisere',),
'geråd': ('geråde',),
'geråda': ('geråde',),
'geråde': ('geråde',),
'geråder': ('geråde',),
'gerådes': ('geråde',),
'gerådet': ('geråde',),
'gestalt': ('gestalte',),
'gestalta': ('gestalte',),
'gestalte': ('gestalte',),
'gestalter': ('gestalte',),
'gestaltes': ('gestalte',),
'gestaltet': ('gestalte',),
'gestikuler': ('gestikulere',),
'gestikulere': ('gestikulere',),
'gestikulerer': ('gestikulere',),
'gestikuleres': ('gestikulere',),
'gestikulert': ('gestikulere',),
'gestikulerte': ('gestikulere',),
'ga': ('gi',),
'gav': ('gi',),
'gi': ('gi',),
'gies': ('gi',),
'gir': ('gi',),
'gis': ('gi',),
'gitt': ('gi',),
'gadd': ('gidde',),
'gidd': ('gidde',),
'gidde': ('gidde',),
'gidder': ('gidde',),
'giddes': ('gidde',),
'giddet': ('gidde',),
'gift': ('gifte',),
'gifta': ('gifte',),
'gifte': ('gifte',),
'gifter': ('gifte',),
'giftes': ('gifte',),
'giftet': ('gifte',),
'gigg': ('gigge',),
'gigga': ('gigge',),
'gigge': ('gigge',),
'gigger': ('gigge',),
'gigges': ('gigge',),
'gigget': ('gigge',),
'gildr': ('gildre',),
'gildra': ('gildre',),
'gildre': ('gildre',),
'gildrer': ('gildre',),
'gildres': ('gildre',),
'gildret': ('gildre',),
'giljotiner': ('giljotinere',),
'giljotinere': ('giljotinere',),
'giljotinerer': ('giljotinere',),
'giljotineres': ('giljotinere',),
'giljotinert': ('giljotinere',),
'giljotinerte': ('giljotinere',),
'gimp': ('gimpe',),
'gimpa': ('gimpe',),
'gimpe': ('gimpe',),
'gimper': ('gimpe',),
'gimpes': ('gimpe',),
'gimpet': ('gimpe',),
'gips': ('gipse',),
'gipsa': ('gipse',),
'gipse': ('gipse',),
'gipser': ('gipse',),
'gipses': ('gipse',),
'gipset': ('gipse',),
'gipst': ('gipse',),
'gipste': ('gipse',),
'girer': ('girere',),
'girere': ('girere',),
'girerer': ('girere',),
'gireres': ('girere',),
'girert': ('girere',),
'girerte': ('girere',),
'gisn': ('gisne',),
'gisna': ('gisne',),
'gisne': ('gisne',),
'gisner': ('gisne',),
'gisnes': ('gisne',),
'gisnet': ('gisne',),
'gisp': ('gispe',),
'gispa': ('gispe',),
'gispe': ('gispe',),
'gisper': ('gispe',),
'gispes': ('gispe',),
'gispet': ('gispe',),
'giss': ('gisse',),
'gissa': ('gisse',),
'gisse': ('gisse',),
'gisser': ('gisse',),
'gisses': ('gisse',),
'gisset': ('gisse',),
'gitr': ('gitre',),
'gitra': ('gitre',),
'gitre': ('gitre',),
'gitrer': ('gitre',),
'gitres': ('gitre',),
'gitret': ('gitre',),
'gjall': ('gjalle',),
'gjalla': ('gjalle',),
'gjalle': ('gjalle',),
'gjaller': ('gjalle',),
'gjalles': ('gjalle',),
'gjallet': ('gjalle',),
'gjekk': ('gjekke',),
'gjekka': ('gjekke',),
'gjekke': ('gjekke',),
'gjekker': ('gjekke',),
'gjekkes': ('gjekke',),
'gjekket': ('gjekke',),
'gjeld': ('gjelde',),
'gjelda': ('gjelde',),
'gjelde': ('gjelde',),
'gjelder': ('gjelde',),
'gjeldes': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeldte': ('gjelde',),
'galdt': ('gjelde',),
'gjaldt': ('gjelde',),
'gjeld': ('gjelde',),
'gjelde': ('gjelde',),
'gjelder': ('gjelde',),
'gjelds': ('gjelde',),
'gjeldt': ('gjelde',),
'gjell': ('gjelle',),
'gjelle': ('gjelle',),
'gjeller': ('gjelle',),
'gjelles': ('gjelle',),
'gjelt': ('gjelle',),
'gjelte': ('gjelle',),
'gjem': ('gjemme',),
'gjemme': ('gjemme',),
'gjemmer': ('gjemme',),
'gjemmes': ('gjemme',),
'gjemt': ('gjemme',),
'gjemte': ('gjemme',),
'gjenbruk': ('gjenbruke',),
'gjenbruke': ('gjenbruke',),
'gjenbruker': ('gjenbruke',),
'gjenbrukes': ('gjenbruke',),
'gjenbrukt': ('gjenbruke',),
'gjenbrukte': ('gjenbruke',),
'gjenerobr': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobre': ('gjenerobre',),
'gjenerobrer': ('gjenerobre',),
'gjenerobres': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenforen': ('gjenforene',),
'gjenforena': ('gjenforene',),
'gjenforene': ('gjenforene',),
'gjenforener': ('gjenforene',),
'gjenforenes': ('gjenforene',),
'gjenforenet': ('gjenforene',),
'gjenforent': ('gjenforene',),
'gjenforente': ('gjenforene',),
'gjenforsikrer': ('gjenforsikre',),
'gjenforsikres': ('gjenforsikre',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikr': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikre': ('gjenforsikre',),
'gjenforsikrer': ('gjenforsikre',),
'gjeng': ('gjenge',),
'gjenga': ('gjenge',),
'gjenge': ('gjenge',),
'gjenger': ('gjenge',),
'gjenges': ('gjenge',),
'gjenget': ('gjenge',),
'gjenga': ('gjengi',),
'gjengav': ('gjengi',),
'gjengi': ('gjengi',),
'gjengies': ('gjengi',),
'gjengir': ('gjengi',),
'gjengis': ('gjengi',),
'gjengitt': ('gjengi',),
'gjengift': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengifte': ('gjengifte',),
'gjengifter': ('gjengifte',),
'gjengiftes': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengjeld': ('gjengjelde',),
'gjengjelde': ('gjengjelde',),
'gjengjelder': ('gjengjelde',),
'gjengjeldes': ('gjengjelde',),
'gjengjeldt': ('gjengjelde',),
'gjengjeldte': ('gjengjelde',),
'gjeninnfør': ('gjeninnføre',),
'gjeninnføre': ('gjeninnføre',),
'gjeninnfører': ('gjeninnføre',),
'gjeninnføres': ('gjeninnføre',),
'gjeninnført': ('gjeninnføre',),
'gjeninnførte': ('gjeninnføre',),
'gjeninnsatt': ('gjeninnsette',),
'gjeninnsatte': ('gjeninnsette',),
'gjeninnsett': ('gjeninnsette',),
'gjeninnsette': ('gjeninnsette',),
'gjeninnsetter': ('gjeninnsette',),
'gjeninnsettes': ('gjeninnsette',),
'gjeninnta': ('gjeninnta',),
'gjeninntaes': ('gjeninnta',),
'gjeninntar': ('gjeninnta',),
'gjeninntas': ('gjeninnta',),
'gjeninntatt': ('gjeninnta',),
'gjeninntok': ('gjeninnta',),
'gjenkall': ('gjenkalle',),
'gjenkalle': ('gjenkalle',),
'gjenkaller': ('gjenkalle',),
'gjenkalles': ('gjenkalle',),
'gjenkalt': ('gjenkalle',),
'gjenkalte': ('gjenkalle',),
'gjenkjenn': ('gjenkjenne',),
'gjenkjenne': ('gjenkjenne',),
'gjenkjenner': ('gjenkjenne',),
'gjenkjennes': ('gjenkjenne',),
'gjenkjent': ('gjenkjenne',),
'gjenkjente': ('gjenkjenne',),
'gjenla': ('gjenlegge',),
'gjenlagt': ('gjenlegge',),
'gjenlegg': ('gjenlegge',),
'gjenlegge': ('gjenlegge',),
'gjenlegger': ('gjenlegge',),
'gjenlegges': ('gjenlegge',),
'gjenløs': ('gjenløse',),
'gjenløse': ('gjenløse',),
'gjenløser': ('gjenløse',),
'gjenløses': ('gjenløse',),
'gjenløst': ('gjenløse',),
'gjenløste': ('gjenløse',),
'gjennomarbeid': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidd': ('gjennomarbeide',),
'gjennomarbeidde': ('gjennomarbeide',),
'gjennomarbeide': ('gjennomarbeide',),
'gjennomarbeider': ('gjennomarbeide',),
'gjennomarbeides': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennombor': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennombore': ('gjennombore',),
'gjennomborer': ('gjennombore',),
'gjennombores': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennomdrøft': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøfte': ('gjennomdrøfte',),
'gjennomdrøfter': ('gjennomdrøfte',),
'gjennomdrøftes': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomfør': ('gjennomføre',),
'gjennomføre': ('gjennomføre',),
'gjennomfører': ('gjennomføre',),
'gjennomføres': ('gjennomføre',),
'gjennomført': ('gjennomføre',),
'gjennomførte': ('gjennomføre',),
'gjennomgikk': ('gjennomgå',),
'gjennomgjekk': ('gjennomgå',),
'gjennomgå': ('gjennomgå',),
'gjennomgåes': ('gjennomgå',),
'gjennomgår': ('gjennomgå',),
'gjennomgås': ('gjennomgå',),
'gjennomgått': ('gjennomgå',),
'gjennomhull': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhulle': ('gjennomhulle',),
'gjennomhuller': ('gjennomhulle',),
'gjennomhulles': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomillustrer': ('gjennomillustrere',),
'gjennomillustrere': ('gjennomillustrere',),
'gjennomillustrerer': ('gjennomillustrere',),
'gjennomillustreres': ('gjennomillustrere',),
'gjennomillustrert': ('gjennomillustrere',),
'gjennomillustrerte': ('gjennomillustrere',),
'gjennomles': ('gjennomlese',),
'gjennomlese': ('gjennomlese',),
'gjennomleser': ('gjennomlese',),
'gjennomleses': ('gjennomlese',),
'gjennomlest': ('gjennomlese',),
'gjennomleste': ('gjennomlese',),
'gjennomlev': ('gjennomleve',),
'gjennomlevd': ('gjennomleve',),
'gjennomlevde': ('gjennomleve',),
'gjennomleve': ('gjennomleve',),
'gjennomlever': ('gjennomleve',),
'gjennomleves': ('gjennomleve',),
'gjennomluft': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomlufte': ('gjennomlufte',),
'gjennomlufter': ('gjennomlufte',),
'gjennomluftes': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomlys': ('gjennomlyse',),
'gjennomlyse': ('gjennomlyse',),
'gjennomlyser': ('gjennomlyse',),
'gjennomlyses': ('gjennomlyse',),
'gjennomlyst': ('gjennomlyse',),
'gjennomlyste': ('gjennomlyse',),
'gjennomprøv': ('gjennomprøve',),
'gjennomprøvd': ('gjennomprøve',),
'gjennomprøvde': ('gjennomprøve',),
'gjennomprøve': ('gjennomprøve',),
'gjennomprøver': ('gjennomprøve',),
'gjennomprøves': ('gjennomprøve',),
'gjennomse': ('gjennomse',),
'gjennomsees': ('gjennomse',),
'gjennomser': ('gjennomse',),
'gjennomses': ('gjennomse',),
'gjennomsett': ('gjennomse',),
'gjennomså': ('gjennomse',),
'gjennomsåg': ('gjennomse',),
'gjennomsku': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskue': ('gjennomskue',),
'gjennomskuer': ('gjennomskue',),
'gjennomskues': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomsteik': ('gjennomsteike',),
'gjennomsteike': ('gjennomsteike',),
'gjennomsteiker': ('gjennomsteike',),
'gjennomsteikes': ('gjennomsteike',),
'gjennomsteikt': ('gjennomsteike',),
'gjennomsteikte': ('gjennomsteike',),
'gjennomstek': ('gjennomsteke',),
'gjennomsteke': ('gjennomsteke',),
'gjennomsteker': ('gjennomsteke',),
'gjennomstekes': ('gjennomsteke',),
'gjennomstekt': ('gjennomsteke',),
'gjennomstekte': ('gjennomsteke',),
'gjennomstrøm': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømme': ('gjennomstrømme',),
'gjennomstrømmer': ('gjennomstrømme',),
'gjennomstrømmes': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømt': ('gjennomstrømme',),
'gjennomstrømte': ('gjennomstrømme',),
'gjennomsyr': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyre': ('gjennomsyre',),
'gjennomsyrer': ('gjennomsyre',),
'gjennomsyres': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrt': ('gjennomsyre',),
'gjennomsyrte': ('gjennomsyre',),
'gjennomtenk': ('gjennomtenke',),
'gjennomtenke': ('gjennomtenke',),
'gjennomtenker': ('gjennomtenke',),
'gjennomtenkes': ('gjennomtenke',),
'gjennomtenkt': ('gjennomtenke',),
'gjennomtenkte': ('gjennomtenke',),
'gjennomtreng': ('gjennomtrenge',),
'gjennomtrenge': ('gjennomtrenge',),
'gjennomtrenger': ('gjennomtrenge',),
'gjennomtrenges': ('gjennomtrenge',),
'gjennomtrengt': ('gjennomtrenge',),
'gjennomtrengte': ('gjennomtrenge',),
'gjennomtrål': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtråle': ('gjennomtråle',),
'gjennomtråler': ('gjennomtråle',),
'gjennomtråles': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålt': ('gjennomtråle',),
'gjennomtrålte': ('gjennomtråle',),
'gjenoppbluss': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblusse': ('gjenoppblusse',),
'gjenoppblusser': ('gjenoppblusse',),
'gjenoppblusses': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppbygd': ('gjenoppbygge',),
'gjenoppbygde': ('gjenoppbygge',),
'gjenoppbygg': ('gjenoppbygge',),
'gjenoppbygga': ('gjenoppbygge',),
'gjenoppbygge': ('gjenoppbygge',),
'gjenoppbygger': ('gjenoppbygge',),
'gjenoppbygges': ('gjenoppbygge',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppdag': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdage': ('gjenoppdage',),
'gjenoppdager': ('gjenoppdage',),
'gjenoppdages': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppfrisk': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfriske': ('gjenoppfriske',),
'gjenoppfrisker': ('gjenoppfriske',),
'gjenoppfriskes': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenopplev': ('gjenoppleve',),
'gjenopplevd': ('gjenoppleve',),
'gjenopplevde': ('gjenoppleve',),
'gjenoppleve': ('gjenoppleve',),
'gjenopplever': ('gjenoppleve',),
'gjenoppleves': ('gjenoppleve',),
'gjenoppliv': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplive': ('gjenopplive',),
'gjenoppliver': ('gjenopplive',),
'gjenopplives': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenopprett': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprette': ('gjenopprette',),
'gjenoppretter': ('gjenopprette',),
'gjenopprettes': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenoppta': ('gjenoppta',),
'gjenopptaes': ('gjenoppta',),
'gjenopptar': ('gjenoppta',),
'gjenopptas': ('gjenoppta',),
'gjenopptatt': ('gjenoppta',),
'gjenopptok': ('gjenoppta',),
'gjenopptrykk': ('gjenopptrykke',),
'gjenopptrykka': ('gjenopptrykke',),
'gjenopptrykke': ('gjenopptrykke',),
'gjenopptrykker': ('gjenopptrykke',),
'gjenopptrykkes': ('gjenopptrykke',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykt': ('gjenopptrykke',),
'gjenopptrykte': ('gjenopptrykke',),
'gjenoppvekk': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekke': ('gjenoppvekke',),
'gjenoppvekker': ('gjenoppvekke',),
'gjenoppvekkes': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekt': ('gjenoppvekke',),
'gjenoppvekte': ('gjenoppvekke',),
'gjenreis': ('gjenreise',),
'gjenreise': ('gjenreise',),
'gjenreiser': ('gjenreise',),
'gjenreises': ('gjenreise',),
'gjenreist': ('gjenreise',),
'gjenreiste': ('gjenreise',),
'gjenskap': ('gjenskape',),
'gjenskapa': ('gjenskape',),
'gjenskape': ('gjenskape',),
'gjenskaper': ('gjenskape',),
'gjenskapes': ('gjenskape',),
'gjenskapt': ('gjenskape',),
'gjenskapte': ('gjenskape',),
'gjenspeil': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeile': ('gjenspeile',),
'gjenspeiler': ('gjenspeile',),
'gjenspeiles': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilt': ('gjenspeile',),
'gjenspeilte': ('gjenspeile',),
'gjenta': ('gjenta',),
'gjentaes': ('gjenta',),
'gjentar': ('gjenta',),
'gjentas': ('gjenta',),
'gjentatt': ('gjenta',),
'gjentok': ('gjenta',),
'gjenvalgt': ('gjenvelge',),
'gjenvalgte': ('gjenvelge',),
'gjenvelg': ('gjenvelge',),
'gjenvelge': ('gjenvelge',),
'gjenvelger': ('gjenvelge',),
'gjenvelges': ('gjenvelge',),
'gjenåpn': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpne': ('gjenåpne',),
'gjenåpner': ('gjenåpne',),
'gjenåpnes': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjerd': ('gjerde',),
'gjerda': ('gjerde',),
'gjerde': ('gjerde',),
'gjerder': ('gjerde',),
'gjerdes': ('gjerde',),
'gjerdet': ('gjerde',),
'gjesp': ('gjespe',),
'gjespa': ('gjespe',),
'gjespe': ('gjespe',),
'gjesper': ('gjespe',),
'gjespes': ('gjespe',),
'gjespet': ('gjespe',),
'gjest': ('gjeste',),
'gjesta': ('gjeste',),
'gjeste': ('gjeste',),
'gjester': ('gjeste',),
'gjestes': ('gjeste',),
'gjestet': ('gjeste',),
'gjet': ('gjete',),
'gjete': ('gjete',),
'gjeter': ('gjete',),
'gjetes': ('gjete',),
'gjett': ('gjete',),
'gjette': ('gjete',),
'gjett': ('gjette',),
'gjetta': ('gjette',),
'gjette': ('gjette',),
'gjetter': ('gjette',),
'gjettes': ('gjette',),
'gjettet': ('gjette',),
'gjord': ('gjorde',),
'gjorda': ('gjorde',),
'gjorde': ('gjorde',),
'gjorder': ('gjorde',),
'gjordes': ('gjorde',),
'gjordet': ('gjorde',),
'gjur': ('gjure',),
'gjura': ('gjure',),
'gjure': ('gjure',),
'gjurer': ('gjure',),
'gjures': ('gjure',),
'gjuret': ('gjure',),
'gjurt': ('gjure',),
'gjurte': ('gjure',),
'gjær': ('gjære',),
'gjæra': ('gjære',),
'gjære': ('gjære',),
'gjærer': ('gjære',),
'gjæres': ('gjære',),
'gjæret': ('gjære',),
'gjært': ('gjære',),
'gjærte': ('gjære',),
'gjær': ('gjære',),
'gjæra': ('gjære',),
'gjære': ('gjære',),
'gjærer': ('gjære',),
'gjæres': ('gjære',),
'gjæret': ('gjære',),
'gjært': ('gjære',),
'gjærte': ('gjære',),
'gjø': ('gjø',),
'gjødd': ('gjø',),
'gjødde': ('gjø',),
'gjør': ('gjø',),
'gjøs': ('gjø',),
'gjø': ('gjø',),
'gjødd': ('gjø',),
'gjødde': ('gjø',),
'gjør': ('gjø',),
'gjøs': ('gjø',),
'gjød': ('gjøde',),
'gjødd': ('gjøde',),
'gjødde': ('gjøde',),
'gjøde': ('gjøde',),
'gjøder': ('gjøde',),
'gjødes': ('gjøde',),
'gjødsl': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødsle': ('gjødsle',),
'gjødsler': ('gjødsle',),
'gjødsles': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjøgl': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøgle': ('gjøgle',),
'gjøgler': ('gjøgle',),
'gjøgles': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøl': ('gjøle',),
'gjøle': ('gjøle',),
'gjøler': ('gjøle',),
'gjøles': ('gjøle',),
'gjølt': ('gjøle',),
'gjølte': ('gjøle',),
'gjøm': ('gjømme',),
'gjømme': ('gjømme',),
'gjømmer': ('gjømme',),
'gjømmes': ('gjømme',),
'gjømt': ('gjømme',),
'gjømte': ('gjømme',),
'gjøn': ('gjøne',),
'gjøne': ('gjøne',),
'gjøner': ('gjøne',),
'gjønes': ('gjøne',),
'gjønt': ('gjøne',),
'gjønte': ('gjøne',),
'gjorde': ('gjøre',),
'gjort': ('gjøre',),
'gjør': ('gjøre',),
'gjøre': ('gjøre',),
'gjøres': ('gjøre',),
'gjørm': ('gjørme',),
'gjørma': ('gjørme',),
'gjørme': ('gjørme',),
'gjørmer': ('gjørme',),
'gjørmes': ('gjørme',),
'gjørmet': ('gjørme',),
'gjors': ('gjørs',),
'gjørs': ('gjørs',),
'gla': ('gla',),
'gladd': ('gla',),
'gladde': ('gla',),
'glar': ('gla',),
'glas': ('gla',),
'glafs': ('glafse',),
'glafsa': ('glafse',),
'glafse': ('glafse',),
'glafser': ('glafse',),
'glafses': ('glafse',),
'glafset': ('glafse',),
'glam': ('glamme',),
'glamma': ('glamme',),
'glamme': ('glamme',),
'glammer': ('glamme',),
'glammes': ('glamme',),
'glammet': ('glamme',),
'glamoriser': ('glamorisere',),
'glamorisere': ('glamorisere',),
'glamoriserer': ('glamorisere',),
'glamoriseres': ('glamorisere',),
'glamorisert': ('glamorisere',),
'glamoriserte': ('glamorisere',),
'glan': ('glane',),
'glana': ('glane',),
'glane': ('glane',),
'glaner': ('glane',),
'glanes': ('glane',),
'glant': ('glane',),
'glante': ('glane',),
'glans': ('glanse',),
'glansa': ('glanse',),
'glanse': ('glanse',),
'glanser': ('glanse',),
'glanses': ('glanse',),
'glanset': ('glanse',),
'glaser': ('glasere',),
'glasere': ('glasere',),
'glaserer': ('glasere',),
'glaseres': ('glasere',),
'glasert': ('glasere',),
'glaserte': ('glasere',),
'glaser': ('glasere',),
'glasere': ('glasere',),
'glaserer': ('glasere',),
'glaseres': ('glasere',),
'glasert': ('glasere',),
'glaserte': ('glasere',),
'glasser': ('glassere',),
'glassere': ('glassere',),
'glasserer': ('glassere',),
'glasseres': ('glassere',),
'glassert': ('glassere',),
'glasserte': ('glassere',),
'glasser': ('glassere',),
'glassere': ('glassere',),
'glasserer': ('glassere',),
'glasseres': ('glassere',),
'glassert': ('glassere',),
'glasserte': ('glassere',),
'glattbarber': ('glattbarbere',),
'glattbarbere': ('glattbarbere',),
'glattbarberer': ('glattbarbere',),
'glattbarberes': ('glattbarbere',),
'glattbarbert': ('glattbarbere',),
'glattbarberte': ('glattbarbere',),
'glatt': ('glatte',),
'glatta': ('glatte',),
'glatte': ('glatte',),
'glatter': ('glatte',),
'glattes': ('glatte',),
'glattet': ('glatte',),
'glattkjem': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemme': ('glattkjemme',),
'glattkjemmer': ('glattkjemme',),
'glattkjemmes': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemt': ('glattkjemme',),
'glattkjemte': ('glattkjemme',),
'glattstrauk': ('glattstryke',),
'glattstryk': ('glattstryke',),
'glattstryke': ('glattstryke',),
'glattstryker': ('glattstryke',),
'glattstrykes': ('glattstryke',),
'glattstrøk': ('glattstryke',),
'glattstrøket': ('glattstryke',),
'glattstrøyk': ('glattstryke',),
'gle': ('gle',),
'gledd': ('gle',),
'gledde': ('gle',),
'gler': ('gle',),
'gles': ('gle',),
'gle': ('gle',),
'gledd': ('gle',),
'gledde': ('gle',),
'gler': ('gle',),
'gles': ('gle',),
'gled': ('glede',),
'gleda': ('glede',),
'gledd': ('glede',),
'gledde': ('glede',),
'glede': ('glede',),
'gleder': ('glede',),
'gledes': ('glede',),
'gledet': ('glede',),
'gled': ('glede',),
'gleda': ('glede',),
'gledd': ('glede',),
'gledde': ('glede',),
'glede': ('glede',),
'gleder': ('glede',),
'gledes': ('glede',),
'gledet': ('glede',),
'glefs': ('glefse',),
'glefsa': ('glefse',),
'glefse': ('glefse',),
'glefser': ('glefse',),
'glefses': ('glefse',),
'glefset': ('glefse',),
'glefst': ('glefse',),
'glefste': ('glefse',),
'glem': ('glemme',),
'glemme': ('glemme',),
'glemmer': ('glemme',),
'glemmes': ('glemme',),
'glemt': ('glemme',),
'glemte': ('glemme',),
'glapp': ('gleppe',),
'glepp': ('gleppe',),
'gleppe': ('gleppe',),
'glepper': ('gleppe',),
'gleppes': ('gleppe',),
'gleppet': ('gleppe',),
'gled': ('gli',),
'glei': ('gli',),
'gleid': ('gli',),
'gli': ('gli',),
'glidd': ('gli',),
'glir': ('gli',),
'glis': ('gli',),
'gled': ('gli',),
'glei': ('gli',),
'gleid': ('gli',),
'gli': ('gli',),
'glidd': ('gli',),
'glir': ('gli',),
'glis': ('gli',),
'glideflaug': ('glidefly',),
'glidefly': ('glidefly',),
'glideflydd': ('glidefly',),
'glideflyr': ('glidefly',),
'glideflys': ('glidefly',),
'glidefløy': ('glidefly',),
'glidefløyet': ('glidefly',),
'glideflaug': ('glideflyge',),
'glideflydd': ('glideflyge',),
'glideflyg': ('glideflyge',),
'glideflyge': ('glideflyge',),
'glideflyger': ('glideflyge',),
'glideflyges': ('glideflyge',),
'glidefløy': ('glideflyge',),
'glidefløyet': ('glideflyge',),
'glim': ('glime',),
'glime': ('glime',),
'glimer': ('glime',),
'glimes': ('glime',),
'glimt': ('glime',),
'glimte': ('glime',),
'glimr': ('glimre',),
'glimra': ('glimre',),
'glimre': ('glimre',),
'glimrer': ('glimre',),
'glimres': ('glimre',),
'glimret': ('glimre',),
'glimt': ('glimte',),
'glimta': ('glimte',),
'glimte': ('glimte',),
'glimter': ('glimte',),
'glimtes': ('glimte',),
'glimtet': ('glimte',),
'glins': ('glinse',),
'glinsa': ('glinse',),
'glinse': ('glinse',),
'glinser': ('glinse',),
'glinses': ('glinse',),
'glinset': ('glinse',),
'glip': ('glipe',),
'glipe': ('glipe',),
'gliper': ('glipe',),
'glipes': ('glipe',),
'glipt': ('glipe',),
'glipte': ('glipe',),
'glir': ('glire',),
'glire': ('glire',),
'glirer': ('glire',),
'glires': ('glire',),
'glirt': ('glire',),
'glirte': ('glire',),
'glis': ('glise',),
'glise': ('glise',),
'gliser': ('glise',),
'glises': ('glise',),
'glist': ('glise',),
'gliste': ('glise',),
'glitr': ('glitre',),
'glitra': ('glitre',),
'glitre': ('glitre',),
'glitrer': ('glitre',),
'glitres': ('glitre',),
'glitret': ('glitre',),
'glitt': ('glitte',),
'glitta': ('glitte',),
'glitte': ('glitte',),
'glitter': ('glitte',),
'glittes': ('glitte',),
'glittet': ('glitte',),
'glo': ('glo',),
'glodd': ('glo',),
'glodde': ('glo',),
'glor': ('glo',),
'glos': ('glo',),
'glor': ('glore',),
'glora': ('glore',),
'glore': ('glore',),
'glorer': ('glore',),
'glores': ('glore',),
'gloret': ('glore',),
'glort': ('glore',),
'glorte': ('glore',),
'glorifiser': ('glorifisere',),
'glorifisere': ('glorifisere',),
'glorifiserer': ('glorifisere',),
'glorifiseres': ('glorifisere',),
'glorifisert': ('glorifisere',),
'glorifiserte': ('glorifisere',),
'glø': ('glø',),
'glødd': ('glø',),
'glødde': ('glø',),
'glør': ('glø',),
'gløs': ('glø',),
'glø': ('glø',),
'glødd': ('glø',),
'glødde': ('glø',),
'glør': ('glø',),
'gløs': ('glø',),
'glød': ('gløde',),
'gløda': ('gløde',),
'glødd': ('gløde',),
'glødde': ('gløde',),
'gløde': ('gløde',),
'gløder': ('gløde',),
'glødes': ('gløde',),
'glødet': ('gløde',),
'glød': ('gløde',),
'gløda': ('gløde',),
'glødd': ('gløde',),
'glødde': ('gløde',),
'gløde': ('gløde',),
'gløder': ('gløde',),
'glødes': ('gløde',),
'glødet': ('gløde',),
'gløm': ('glømme',),
'glømme': ('glømme',),
'glømmer': ('glømme',),
'glømmes': ('glømme',),
'glømt': ('glømme',),
'glømte': ('glømme',),
'gløtt': ('gløtte',),
'gløtta': ('gløtte',),
'gløtte': ('gløtte',),
'gløtter': ('gløtte',),
'gløttes': ('gløtte',),
'gløttet': ('gløtte',),
'gnafs': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafse': ('gnafse',),
'gnafser': ('gnafse',),
'gnafses': ('gnafse',),
'gnafset': ('gnafse',),
'gnafst': ('gnafse',),
'gnafste': ('gnafse',),
'gnag': ('gnage',),
'gnagd': ('gnage',),
'gnagde': ('gnage',),
'gnage': ('gnage',),
'gnager': ('gnage',),
'gnages': ('gnage',),
'gnaget': ('gnage',),
'gnog': ('gnage',),
'gnaldr': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldre': ('gnaldre',),
'gnaldrer': ('gnaldre',),
'gnaldres': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gneldr': ('gneldre',),
'gneldra': ('gneldre',),
'gneldre': ('gneldre',),
'gneldrer': ('gneldre',),
'gneldres': ('gneldre',),
'gneldret': ('gneldre',),
'gnall': ('gnelle',),
'gnell': ('gnelle',),
'gnelle': ('gnelle',),
'gneller': ('gnelle',),
'gnelles': ('gnelle',),
'gnelt': ('gnelle',),
'gnelte': ('gnelle',),
'gned': ('gni',),
'gnei': ('gni',),
'gneid': ('gni',),
'gni': ('gni',),
'gnidd': ('gni',),
'gnidde': ('gni',),
'gnir': ('gni',),
'gnis': ('gni',),
'gnidr': ('gnidre',),
'gnidra': ('gnidre',),
'gnidre': ('gnidre',),
'gnidrer': ('gnidre',),
'gnidres': ('gnidre',),
'gnidret': ('gnidre',),
'gnik': ('gnike',),
'gnika': ('gnike',),
'gnike': ('gnike',),
'gniker': ('gnike',),
'gnikes': ('gnike',),
'gniket': ('gnike',),
'gnik': ('gnike',),
'gnika': ('gnike',),
'gnike': ('gnike',),
'gniker': ('gnike',),
'gnikes': ('gnike',),
'gniket': ('gnike',),
'gnikk': ('gnikke',),
'gnikka': ('gnikke',),
'gnikke': ('gnikke',),
'gnikker': ('gnikke',),
'gnikkes': ('gnikke',),
'gnikket': ('gnikke',),
'gnikk': ('gnikke',),
'gnikka': ('gnikke',),
'gnikke': ('gnikke',),
'gnikker': ('gnikke',),
'gnikkes': ('gnikke',),
'gnikket': ('gnikke',),
'gniks': ('gnikse',),
'gniksa': ('gnikse',),
'gnikse': ('gnikse',),
'gnikser': ('gnikse',),
'gnikses': ('gnikse',),
'gnikset': ('gnikse',),
'gnirk': ('gnirke',),
'gnirka': ('gnirke',),
'gnirke': ('gnirke',),
'gnirker': ('gnirke',),
'gnirkes': ('gnirke',),
'gnirket': ('gnirke',),
'gnisl': ('gnisle',),
'gnisla': ('gnisle',),
'gnisle': ('gnisle',),
'gnisler': ('gnisle',),
'gnisles': ('gnisle',),
'gnislet': ('gnisle',),
'gniss': ('gnisse',),
'gnissa': ('gnisse',),
'gnisse': ('gnisse',),
'gnisser': ('gnisse',),
'gnisses': ('gnisse',),
'gnisset': ('gnisse',),
'gnist': ('gniste',),
'gnista': ('gniste',),
'gniste': ('gniste',),
'gnister': ('gniste',),
'gnistes': ('gniste',),
'gnistet': ('gniste',),
'gnistr': ('gnistre',),
'gnistra': ('gnistre',),
'gnistre': ('gnistre',),
'gnistrer': ('gnistre',),
'gnistres': ('gnistre',),
'gnistret': ('gnistre',),
'gnu': ('gnu',),
'gnudd': ('gnu',),
'gnudde': ('gnu',),
'gnur': ('gnu',),
'gnus': ('gnu',),
'gnubb': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbe': ('gnubbe',),
'gnubber': ('gnubbe',),
'gnubbes': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnugg': ('gnugge',),
'gnugga': ('gnugge',),
'gnugge': ('gnugge',),
'gnugger': ('gnugge',),
'gnugges': ('gnugge',),
'gnugget': ('gnugge',),
'gnukk': ('gnukke',),
'gnukka': ('gnukke',),
'gnukke': ('gnukke',),
'gnukker': ('gnukke',),
'gnukkes': ('gnukke',),
'gnukket': ('gnukke',),
'gnur': ('gnure',),
'gnura': ('gnure',),
'gnure': ('gnure',),
'gnurer': ('gnure',),
'gnures': ('gnure',),
'gnuret': ('gnure',),
'gnurt': ('gnure',),
'gnurte': ('gnure',),
'gnusl': ('gnusle',),
'gnusla': ('gnusle',),
'gnusle': ('gnusle',),
'gnusler': ('gnusle',),
'gnusles': ('gnusle',),
'gnuslet': ('gnusle',),
'gnuss': ('gnusse',),
'gnussa': ('gnusse',),
'gnusse': ('gnusse',),
'gnusser': ('gnusse',),
'gnusses': ('gnusse',),
'gnusset': ('gnusse',),
'gny': ('gny',),
'gnydd': ('gny',),
'gnydde': ('gny',),
'gnyr': ('gny',),
'gnys': ('gny',),
'gnål': ('gnåle',),
'gnåle': ('gnåle',),
'gnåler': ('gnåle',),
'gnåles': ('gnåle',),
'gnålt': ('gnåle',),
'gnålte': ('gnåle',),
'godgjorde': ('godgjøre',),
'godgjort': ('godgjøre',),
'godgjør': ('godgjøre',),
'godgjøre': ('godgjøre',),
'godgjøres': ('godgjøre',),
'godkjenn': ('godkjenne',),
'godkjenne': ('godkjenne',),
'godkjenner': ('godkjenne',),
'godkjennes': ('godkjenne',),
'godkjent': ('godkjenne',),
'godkjente': ('godkjenne',),
'godskreiv': ('godskrive',),
'godskrev': ('godskrive',),
'godskrevet': ('godskrive',),
'godskriv': ('godskrive',),
'godskrive': ('godskrive',),
'godskriver': ('godskrive',),
'godskrives': ('godskrive',),
'godsnakk': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakke': ('godsnakke',),
'godsnakker': ('godsnakke',),
'godsnakkes': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godta': ('godta',),
'godtaes': ('godta',),
'godtar': ('godta',),
'godtas': ('godta',),
'godtatt': ('godta',),
'godtok': ('godta',),
'godt': ('godte',),
'godta': ('godte',),
'godte': ('godte',),
'godter': ('godte',),
'godtes': ('godte',),
'godtet': ('godte',),
'godtgjorde': ('godtgjøre',),
'godtgjort': ('godtgjøre',),
'godtgjør': ('godtgjøre',),
'godtgjøre': ('godtgjøre',),
'godtgjøres': ('godtgjøre',),
'goml': ('gomle',),
'gomla': ('gomle',),
'gomle': ('gomle',),
'gomler': ('gomle',),
'gomles': ('gomle',),
'gomlet': ('gomle',),
'gov': ('gove',),
'gova': ('gove',),
'gove': ('gove',),
'gover': ('gove',),
'goves': ('gove',),
'govet': ('gove',),
'grabb': ('grabbe',),
'grabba': ('grabbe',),
'grabbe': ('grabbe',),
'grabber': ('grabbe',),
'grabbes': ('grabbe',),
'grabbet': ('grabbe',),
'gradbøy': ('gradbøye',),
'gradbøya': ('gradbøye',),
'gradbøyd': ('gradbøye',),
'gradbøyde': ('gradbøye',),
'gradbøye': ('gradbøye',),
'gradbøyer': ('gradbøye',),
'gradbøyes': ('gradbøye',),
'gradbøyet': ('gradbøye',),
'grad': ('grade',),
'grada': ('grade',),
'grade': ('grade',),
'grader': ('grade',),
'grades': ('grade',),
'gradet': ('grade',),
'grader': ('gradere',),
'gradere': ('gradere',),
'graderer': ('gradere',),
'graderes': ('gradere',),
'gradert': ('gradere',),
'graderte': ('gradere',),
'graduer': ('graduere',),
'graduere': ('graduere',),
'graduerer': ('graduere',),
'gradueres': ('graduere',),
'graduert': ('graduere',),
'graduerte': ('graduere',),
'grafs': ('grafse',),
'grafsa': ('grafse',),
'grafse': ('grafse',),
'grafser': ('grafse',),
'grafses': ('grafse',),
'grafset': ('grafse',),
'grams': ('gramse',),
'gramsa': ('gramse',),
'gramse': ('gramse',),
'gramser': ('gramse',),
'gramses': ('gramse',),
'gramset': ('gramse',),
'gransk': ('granske',),
'granska': ('granske',),
'granske': ('granske',),
'gransker': ('granske',),
'granskes': ('granske',),
'gransket': ('granske',),
'granuler': ('granulere',),
'granulere': ('granulere',),
'granulerer': ('granulere',),
'granuleres': ('granulere',),
'granulert': ('granulere',),
'granulerte': ('granulere',),
'gras': ('grase',),
'grasa': ('grase',),
'grase': ('grase',),
'graser': ('grase',),
'grases': ('grase',),
'graset': ('grase',),
'grasser': ('grassere',),
'grassere': ('grassere',),
'grasserer': ('grassere',),
'grasseres': ('grassere',),
'grassert': ('grassere',),
'grasserte': ('grassere',),
'gratiner': ('gratinere',),
'gratinere': ('gratinere',),
'gratinerer': ('gratinere',),
'gratineres': ('gratinere',),
'gratinert': ('gratinere',),
'gratinerte': ('gratinere',),
'gratuler': ('gratulere',),
'gratulere': ('gratulere',),
'gratulerer': ('gratulere',),
'gratuleres': ('gratulere',),
'gratulert': ('gratulere',),
'gratulerte': ('gratulere',),
'grav': ('grave',),
'grava': ('grave',),
'gravd': ('grave',),
'gravde': ('grave',),
'grave': ('grave',),
'graver': ('grave',),
'graves': ('grave',),
'gravet': ('grave',),
'grav': ('grave',),
'gravd': ('grave',),
'gravde': ('grave',),
'grave': ('grave',),
'graver': ('grave',),
'graves': ('grave',),
'grov': ('grave',),
'graver': ('gravere',),
'gravere': ('gravere',),
'graverer': ('gravere',),
'graveres': ('gravere',),
'gravert': ('gravere',),
'graverte': ('gravere',),
'graviter': ('gravitere',),
'gravitere': ('gravitere',),
'graviterer': ('gravitere',),
'graviteres': ('gravitere',),
'gravitert': ('gravitere',),
'graviterte': ('gravitere',),
'gravla': ('gravlegge',),
'gravlagt': ('gravlegge',),
'gravlegg': ('gravlegge',),
'gravlegge': ('gravlegge',),
'gravlegger': ('gravlegge',),
'gravlegges': ('gravlegge',),
'gre': ('gre',),
'gredd': ('gre',),
'gredde': ('gre',),
'grer': ('gre',),
'gres': ('gre',),
'grei': ('greie',),
'greid': ('greie',),
'greidd': ('greie',),
'greidde': ('greie',),
'greide': ('greie',),
'greie': ('greie',),
'greier': ('greie',),
'greies': ('greie',),
'grei': ('greie',),
'greid': ('greie',),
'greidd': ('greie',),
'greidde': ('greie',),
'greide': ('greie',),
'greie': ('greie',),
'greier': ('greie',),
'greies': ('greie',),
'grein': ('greine',),
'greina': ('greine',),
'greine': ('greine',),
'greiner': ('greine',),
'greines': ('greine',),
'greinet': ('greine',),
'greint': ('greine',),
'greinte': ('greine',),
'grem': ('gremme',),
'gremma': ('gremme',),
'gremme': ('gremme',),
'gremmer': ('gremme',),
'gremmes': ('gremme',),
'gremmet': ('gremme',),
'gremt': ('gremme',),
'gremte': ('gremme',),
'gren': ('grene',),
'grena': ('grene',),
'grene': ('grene',),
'grener': ('grene',),
'grenes': ('grene',),
'grenet': ('grene',),
'grent': ('grene',),
'grente': ('grene',),
'grens': ('grense',),
'grensa': ('grense',),
'grense': ('grense',),
'grenser': ('grense',),
'grenses': ('grense',),
'grenset': ('grense',),
'gress': ('gresse',),
'gressa': ('gresse',),
'gresse': ('gresse',),
'gresser': ('gresse',),
'gresses': ('gresse',),
'gresset': ('gresse',),
'griljer': ('griljere',),
'griljere': ('griljere',),
'griljerer': ('griljere',),
'griljeres': ('griljere',),
'griljert': ('griljere',),
'griljerte': ('griljere',),
'grill': ('grille',),
'grilla': ('grille',),
'grille': ('grille',),
'griller': ('grille',),
'grilles': ('grille',),
'grillet': ('grille',),
'grim': ('grime',),
'grima': ('grime',),
'grime': ('grime',),
'grimer': ('grime',),
'grimes': ('grime',),
'grimet': ('grime',),
'grein': ('grine',),
'gren': ('grine',),
'grin': ('grine',),
'grine': ('grine',),
'griner': ('grine',),
'grines': ('grine',),
'grint': ('grine',),
'grinte': ('grine',),
'greip': ('gripe',),
'grep': ('gripe',),
'grepet': ('gripe',),
'grip': ('gripe',),
'gripe': ('gripe',),
'griper': ('gripe',),
'gripes': ('gripe',),
'gris': ('grise',),
'grisa': ('grise',),
'grise': ('grise',),
'griser': ('grise',),
'grises': ('grise',),
'griset': ('grise',),
'grist': ('grise',),
'griste': ('grise',),
'grisl': ('grisle',),
'grisla': ('grisle',),
'grisle': ('grisle',),
'grisler': ('grisle',),
'grisles': ('grisle',),
'grislet': ('grisle',),
'grisn': ('grisne',),
'grisna': ('grisne',),
'grisne': ('grisne',),
'grisner': ('grisne',),
'grisnes': ('grisne',),
'grisnet': ('grisne',),
'gro': ('gro',),
'grodd': ('gro',),
'grodde': ('gro',),
'gror': ('gro',),
'gros': ('gro',),
'grop': ('grope',),
'gropa': ('grope',),
'grope': ('grope',),
'groper': ('grope',),
'gropes': ('grope',),
'gropet': ('grope',),
'grovhakk': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakke': ('grovhakke',),
'grovhakker': ('grovhakke',),
'grovhakkes': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovmal': ('grovmale',),
'grovmale': ('grovmale',),
'grovmaler': ('grovmale',),
'grovmales': ('grovmale',),
'grovmalt': ('grovmale',),
'grovmalte': ('grovmale',),
'grovmol': ('grovmale',),
'grovsikt': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsikte': ('grovsikte',),
'grovsikter': ('grovsikte',),
'grovsiktes': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsorter': ('grovsortere',),
'grovsortere': ('grovsortere',),
'grovsorterer': ('grovsortere',),
'grovsorteres': ('grovsortere',),
'grovsortert': ('grovsortere',),
'grovsorterte': ('grovsortere',),
'grovtalt': ('grovtelle',),
'grovtalte': ('grovtelle',),
'grovtell': ('grovtelle',),
'grovtella': ('grovtelle',),
'grovtelle': ('grovtelle',),
'grovteller': ('grovtelle',),
'grovtelles': ('grovtelle',),
'grovtellet': ('grovtelle',),
'grovtelt': ('grovtelle',),
'grovtelte': ('grovtelle',),
'grubl': ('gruble',),
'grubla': ('gruble',),
'gruble': ('gruble',),
'grubler': ('gruble',),
'grubles': ('gruble',),
'grublet': ('gruble',),
'gru': ('grue',),
'grua': ('grue',),
'grudd': ('grue',),
'grudde': ('grue',),
'grue': ('grue',),
'gruer': ('grue',),
'grues': ('grue',),
'gruet': ('grue',),
'grums': ('grumse',),
'grumsa': ('grumse',),
'grumse': ('grumse',),
'grumser': ('grumse',),
'grumses': ('grumse',),
'grumset': ('grumse',),
'grunder': ('grundere',),
'grundere': ('grundere',),
'grunderer': ('grundere',),
'grunderes': ('grundere',),
'grundert': ('grundere',),
'grunderte': ('grundere',),
'grunn': ('grunne',),
'grunna': ('grunne',),
'grunne': ('grunne',),
'grunner': ('grunne',),
'grunnes': ('grunne',),
'grunnet': ('grunne',),
'grunn': ('grunne',),
'grunna': ('grunne',),
'grunne': ('grunne',),
'grunner': ('grunne',),
'grunnes': ('grunne',),
'grunnet': ('grunne',),
'grunn': ('grunne',),
'grunna': ('grunne',),
'grunne': ('grunne',),
'grunner': ('grunne',),
'grunnes': ('grunne',),
'grunnet': ('grunne',),
'grunnfest': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfeste': ('grunnfeste',),
'grunnfester': ('grunnfeste',),
'grunnfestes': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnga': ('grunngi',),
'grunngav': ('grunngi',),
'grunngi': ('grunngi',),
'grunngies': ('grunngi',),
'grunngir': ('grunngi',),
'grunngis': ('grunngi',),
'grunngitt': ('grunngi',),
'grunnla': ('grunnlegge',),
'grunnlagt': ('grunnlegge',),
'grunnlegg': ('grunnlegge',),
'grunnlegge': ('grunnlegge',),
'grunnlegger': ('grunnlegge',),
'grunnlegges': ('grunnlegge',),
'grunnsatt': ('grunnsette',),
'grunnsatte': ('grunnsette',),
'grunnsett': ('grunnsette',),
'grunnsette': ('grunnsette',),
'grunnsetter': ('grunnsette',),
'grunnsettes': ('grunnsette',),
'grunnstøt': ('grunnstøte',),
'grunnstøte': ('grunnstøte',),
'grunnstøter': ('grunnstøte',),
'grunnstøtes': ('grunnstøte',),
'grunnstøtt': ('grunnstøte',),
'grunnstøtte': ('grunnstøte',),
'grupper': ('gruppere',),
'gruppere': ('gruppere',),
'grupperer': ('gruppere',),
'grupperes': ('gruppere',),
'gruppert': ('gruppere',),
'grupperte': ('gruppere',),
'grus': ('gruse',),
'grusa': ('gruse',),
'gruse': ('gruse',),
'gruser': ('gruse',),
'gruses': ('gruse',),
'gruset': ('gruse',),
'grusla': ('gruslegge',),
'gruslagt': ('gruslegge',),
'gruslegg': ('gruslegge',),
'gruslegge': ('gruslegge',),
'gruslegger': ('gruslegge',),
'gruslegges': ('gruslegge',),
'gry': ('gry',),
'grydd': ('gry',),
'grydde': ('gry',),
'gryr': ('gry',),
'grys': ('gry',),
'gryn': ('gryne',),
'gryne': ('gryne',),
'gryner': ('gryne',),
'grynes': ('gryne',),
'grynt': ('gryne',),
'grynte': ('gryne',),
'grynt': ('grynte',),
'grynta': ('grynte',),
'grynte': ('grynte',),
'grynter': ('grynte',),
'gryntes': ('grynte',),
'gryntet': ('grynte',),
'grål': ('gråle',),
'gråle': ('gråle',),
'gråler': ('gråle',),
'gråles': ('gråle',),
'grålt': ('gråle',),
'grålte': ('gråle',),
'grån': ('gråne',),
'gråna': ('gråne',),
'gråne': ('gråne',),
'gråner': ('gråne',),
'grånes': ('gråne',),
'grånet': ('gråne',),
'gret': ('gråte',),
'gråt': ('gråte',),
'gråte': ('gråte',),
'gråter': ('gråte',),
'gråtes': ('gråte',),
'grått': ('gråte',),
'grø': ('grø',),
'grødd': ('grø',),
'grødde': ('grø',),
'grør': ('grø',),
'grøs': ('grø',),
'grø': ('grø',),
'grødd': ('grø',),
'grødde': ('grø',),
'grør': ('grø',),
'grøs': ('grø',),
'grød': ('grøde',),
'grødd': ('grøde',),
'grødde': ('grøde',),
'grøde': ('grøde',),
'grøder': ('grøde',),
'grødes': ('grøde',),
'grød': ('grøde',),
'grødd': ('grøde',),
'grødde': ('grøde',),
'grøde': ('grøde',),
'grøder': ('grøde',),
'grødes': ('grøde',),
'grøft': ('grøfte',),
'grøfta': ('grøfte',),
'grøfte': ('grøfte',),
'grøfter': ('grøfte',),
'grøftes': ('grøfte',),
'grøftet': ('grøfte',),
'grønk': ('grønke',),
'grønka': ('grønke',),
'grønke': ('grønke',),
'grønker': ('grønke',),
'grønkes': ('grønke',),
'grønket': ('grønke',),
'grønkes': ('grønkes',),
'grønktes': ('grønkes',),
'grønnes': ('grønnes',),
'grøntes': ('grønnes',),
'grønsk': ('grønske',),
'grønska': ('grønske',),
'grønske': ('grønske',),
'grønsker': ('grønske',),
'grønskes': ('grønske',),
'grønsket': ('grønske',),
'grøpp': ('grøppe',),
'grøppa': ('grøppe',),
'grøppe': ('grøppe',),
'grøpper': ('grøppe',),
'grøppes': ('grøppe',),
'grøppet': ('grøppe',),
'grøpt': ('grøppe',),
'grøpte': ('grøppe',),
'grøss': ('grøsse',),
'grøssa': ('grøsse',),
'grøsse': ('grøsse',),
'grøsser': ('grøsse',),
'grøsses': ('grøsse',),
'grøsset': ('grøsse',),
'grøst': ('grøsse',),
'grøste': ('grøsse',),
'gufs': ('gufse',),
'gufsa': ('gufse',),
'gufse': ('gufse',),
'gufser': ('gufse',),
'gufses': ('gufse',),
'gufset': ('gufse',),
'guid': ('guide',),
'guida': ('guide',),
'guide': ('guide',),
'guider': ('guide',),
'guides': ('guide',),
'guidet': ('guide',),
'gul': ('gule',),
'gula': ('gule',),
'gule': ('gule',),
'guler': ('gule',),
'gules': ('gule',),
'gulet': ('gule',),
'gulk': ('gulke',),
'gulka': ('gulke',),
'gulke': ('gulke',),
'gulker': ('gulke',),
'gulkes': ('gulke',),
'gulket': ('gulke',),
'guln': ('gulne',),
'gulna': ('gulne',),
'gulne': ('gulne',),
'gulner': ('gulne',),
'gulnes': ('gulne',),
'gulnet': ('gulne',),
'gulp': ('gulpe',),
'gulpa': ('gulpe',),
'gulpe': ('gulpe',),
'gulper': ('gulpe',),
'gulpes': ('gulpe',),
'gulpet': ('gulpe',),
'gummier': ('gummiere',),
'gummiere': ('gummiere',),
'gummierer': ('gummiere',),
'gummieres': ('gummiere',),
'gummiert': ('gummiere',),
'gummierte': ('gummiere',),
'gurgl': ('gurgle',),
'gurgla': ('gurgle',),
'gurgle': ('gurgle',),
'gurgler': ('gurgle',),
'gurgles': ('gurgle',),
'gurglet': ('gurgle',),
'gurp': ('gurpe',),
'gurpa': ('gurpe',),
'gurpe': ('gurpe',),
'gurper': ('gurpe',),
'gurpes': ('gurpe',),
'gurpet': ('gurpe',),
'gust': ('guste',),
'gusta': ('guste',),
'guste': ('guste',),
'guster': ('guste',),
'gustes': ('guste',),
'gustet': ('guste',),
'guter': ('gutere',),
'gutere': ('gutere',),
'guterer': ('gutere',),
'guteres': ('gutere',),
'gutert': ('gutere',),
'guterte': ('gutere',),
'gyll': ('gylle',),
'gylla': ('gylle',),
'gylle': ('gylle',),
'gyller': ('gylle',),
'gylles': ('gylle',),
'gyllet': ('gylle',),
'gylt': ('gylle',),
'gylte': ('gylle',),
'gymnastiser': ('gymnastisere',),
'gymnastisere': ('gymnastisere',),
'gymnastiserer': ('gymnastisere',),
'gymnastiseres': ('gymnastisere',),
'gymnastisert': ('gymnastisere',),
'gymnastiserte': ('gymnastisere',),
'gyng': ('gynge',),
'gynga': ('gynge',),
'gynge': ('gynge',),
'gynger': ('gynge',),
'gynges': ('gynge',),
'gynget': ('gynge',),
'gjøs': ('gyse',),
'gys': ('gyse',),
'gyse': ('gyse',),
'gyser': ('gyse',),
'gyses': ('gyse',),
'gyss': ('gyse',),
'gyst': ('gyse',),
'gyste': ('gyse',),
'gjøt': ('gyte',),
'gyt': ('gyte',),
'gyte': ('gyte',),
'gyter': ('gyte',),
'gytes': ('gyte',),
'gytt': ('gyte',),
'gytte': ('gyte',),
'gauv': ('gyve',),
'gjøv': ('gyve',),
'gjøvet': ('gyve',),
'gyv': ('gyve',),
'gyvd': ('gyve',),
'gyve': ('gyve',),
'gyver': ('gyve',),
'gyves': ('gyve',),
'gøyv': ('gyve',),
'gikk': ('gå',),
'gjekk': ('gå',),
'gå': ('gå',),
'gåes': ('gå',),
'går': ('gå',),
'gås': ('gå',),
'gått': ('gå',),
'går': ('gåre',),
'gåra': ('gåre',),
'gåre': ('gåre',),
'gårer': ('gåre',),
'gåres': ('gåre',),
'gåret': ('gåre',),
'gøys': ('gøyse',),
'gøyse': ('gøyse',),
'gøyser': ('gøyse',),
'gøyses': ('gøyse',),
'gøyst': ('gøyse',),
'gøyste': ('gøyse',),
'ha': ('ha',),
'hadde': ('ha',),
'haes': ('ha',),
'har': ('ha',),
'has': ('ha',),
'hatt': ('ha',),
'habiliter': ('habilitere',),
'habilitere': ('habilitere',),
'habiliterer': ('habilitere',),
'habiliteres': ('habilitere',),
'habilitert': ('habilitere',),
'habiliterte': ('habilitere',),
'hagl': ('hagle',),
'hagla': ('hagle',),
'hagle': ('hagle',),
'hagler': ('hagle',),
'hagles': ('hagle',),
'haglet': ('hagle',),
'haik': ('haike',),
'haika': ('haike',),
'haike': ('haike',),
'haiker': ('haike',),
'haikes': ('haike',),
'haiket': ('haike',),
'hak': ('hake',),
'haka': ('hake',),
'hake': ('hake',),
'haker': ('hake',),
'hakes': ('hake',),
'haket': ('hake',),
'hakt': ('hake',),
'hakte': ('hake',),
'hakk': ('hakke',),
'hakka': ('hakke',),
'hakke': ('hakke',),
'hakker': ('hakke',),
'hakkes': ('hakke',),
'hakket': ('hakke',),
'hal': ('hale',),
'hala': ('hale',),
'hale': ('hale',),
'haler': ('hale',),
'hales': ('hale',),
'halet': ('hale',),
'halt': ('hale',),
'halte': ('hale',),
'hall': ('halle',),
'halla': ('halle',),
'halle': ('halle',),
'haller': ('halle',),
'halles': ('halle',),
'hallet': ('halle',),
'hallusiner': ('hallusinere',),
'hallusinere': ('hallusinere',),
'hallusinerer': ('hallusinere',),
'hallusineres': ('hallusinere',),
'hallusinert': ('hallusinere',),
'hallusinerte': ('hallusinere',),
'hals': ('halse',),
'halsa': ('halse',),
'halse': ('halse',),
'halser': ('halse',),
'halses': ('halse',),
'halset': ('halse',),
'halt': ('halte',),
'halta': ('halte',),
'halte': ('halte',),
'halter': ('halte',),
'haltes': ('halte',),
'haltet': ('halte',),
'halv': ('halve',),
'halva': ('halve',),
'halve': ('halve',),
'halver': ('halve',),
'halves': ('halve',),
'halvet': ('halve',),
'halver': ('halvere',),
'halvere': ('halvere',),
'halverer': ('halvere',),
'halveres': ('halvere',),
'halvert': ('halvere',),
'halverte': ('halvere',),
'halvgarder': ('halvgardere',),
'halvgardere': ('halvgardere',),
'halvgarderer': ('halvgardere',),
'halvgarderes': ('halvgardere',),
'halvgardert': ('halvgardere',),
'halvgarderte': ('halvgardere',),
'halvklar': ('halvklare',),
'halvklare': ('halvklare',),
'halvklarer': ('halvklare',),
'halvklares': ('halvklare',),
'halvklart': ('halvklare',),
'halvklarte': ('halvklare',),
'halvsov': ('halvsove',),
'halvsove': ('halvsove',),
'halvsover': ('halvsove',),
'halvsoves': ('halvsove',),
'halvsovet': ('halvsove',),
'halvsål': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsåle': ('halvsåle',),
'halvsåler': ('halvsåle',),
'halvsåles': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålt': ('halvsåle',),
'halvsålte': ('halvsåle',),
'haml': ('hamle',),
'hamla': ('hamle',),
'hamle': ('hamle',),
'hamler': ('hamle',),
'hamles': ('hamle',),
'hamlet': ('hamle',),
'haml': ('hamle',),
'hamla': ('hamle',),
'hamle': ('hamle',),
'hamler': ('hamle',),
'hamles': ('hamle',),
'hamlet': ('hamle',),
'hamn': ('hamne',),
'hamna': ('hamne',),
'hamne': ('hamne',),
'hamner': ('hamne',),
'hamnes': ('hamne',),
'hamnet': ('hamne',),
'hamn': ('hamne',),
'hamna': ('hamne',),
'hamne': ('hamne',),
'hamner': ('hamne',),
'hamnes': ('hamne',),
'hamnet': ('hamne',),
'hamn': ('hamne',),
'hamna': ('hamne',),
'hamne': ('hamne',),
'hamner': ('hamne',),
'hamnes': ('hamne',),
'hamnet': ('hamne',),
'hamr': ('hamre',),
'hamra': ('hamre',),
'hamre': ('hamre',),
'hamrer': ('hamre',),
'hamres': ('hamre',),
'hamret': ('hamre',),
'hams': ('hamse',),
'hamsa': ('hamse',),
'hamse': ('hamse',),
'hamser': ('hamse',),
'hamses': ('hamse',),
'hamset': ('hamse',),
'hamstr': ('hamstre',),
'hamstra': ('hamstre',),
'hamstre': ('hamstre',),
'hamstrer': ('hamstre',),
'hamstres': ('hamstre',),
'hamstret': ('hamstre',),
'handfar': ('handfare',),
'handfare': ('handfare',),
'handfarer': ('handfare',),
'handfares': ('handfare',),
'handfart': ('handfare',),
'handfor': ('handfare',),
'handga': ('handgi',),
'handgav': ('handgi',),
'handgi': ('handgi',),
'handgies': ('handgi',),
'handgir': ('handgi',),
'handgis': ('handgi',),
'handgitt': ('handgi',),
'handhels': ('handhelse',),
'handhelse': ('handhelse',),
'handhelser': ('handhelse',),
'handhelses': ('handhelse',),
'handhelst': ('handhelse',),
'handhelste': ('handhelse',),
'handhev': ('handheve',),
'handheva': ('handheve',),
'handhevd': ('handheve',),
'handhevde': ('handheve',),
'handheve': ('handheve',),
'handhever': ('handheve',),
'handheves': ('handheve',),
'handhevet': ('handheve',),
'handhils': ('handhilse',),
'handhilse': ('handhilse',),
'handhilser': ('handhilse',),
'handhilses': ('handhilse',),
'handhilst': ('handhilse',),
'handhilste': ('handhilse',),
'handhils': ('handhilse',),
'handhilse': ('handhilse',),
'handhilser': ('handhilse',),
'handhilses': ('handhilse',),
'handhilst': ('handhilse',),
'handhilste': ('handhilse',),
'handikapp': ('handikappe',),
'handikappa': ('handikappe',),
'handikappe': ('handikappe',),
'handikapper': ('handikappe',),
'handikappes': ('handikappe',),
'handikappet': ('handikappe',),
'handl': ('handle',),
'handla': ('handle',),
'handle': ('handle',),
'handler': ('handle',),
'handles': ('handle',),
'handlet': ('handle',),
'handplukk': ('handplukke',),
'handplukka': ('handplukke',),
'handplukke': ('handplukke',),
'handplukker': ('handplukke',),
'handplukkes': ('handplukke',),
'handplukket': ('handplukke',),
'handsam': ('handsame',),
'handsama': ('handsame',),
'handsame': ('handsame',),
'handsamer': ('handsame',),
'handsames': ('handsame',),
'handsamet': ('handsame',),
'hands': ('handse',),
'handsa': ('handse',),
'handse': ('handse',),
'handser': ('handse',),
'handses': ('handse',),
'handset': ('handse',),
'handter': ('handtere',),
'handtere': ('handtere',),
'handterer': ('handtere',),
'handteres': ('handtere',),
'handtert': ('handtere',),
'handterte': ('handtere',),
'hangl': ('hangle',),
'hangla': ('hangle',),
'hangle': ('hangle',),
'hangler': ('hangle',),
'hangles': ('hangle',),
'hanglet': ('hangle',),
'hanskedes': ('hanskes',),
'hanskes': ('hanskes',),
'hardkok': ('hardkoke',),
'hardkoke': ('hardkoke',),
'hardkoker': ('hardkoke',),
'hardkokes': ('hardkoke',),
'hardkokt': ('hardkoke',),
'hardkokte': ('hardkoke',),
'hardn': ('hardne',),
'hardna': ('hardne',),
'hardne': ('hardne',),
'hardner': ('hardne',),
'hardnes': ('hardne',),
'hardnet': ('hardne',),
'hardtramp': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampe': ('hardtrampe',),
'hardtramper': ('hardtrampe',),
'hardtrampes': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtren': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrene': ('hardtrene',),
'hardtrener': ('hardtrene',),
'hardtrenes': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrent': ('hardtrene',),
'hardtrente': ('hardtrene',),
'hark': ('harke',),
'harka': ('harke',),
'harke': ('harke',),
'harker': ('harke',),
'harkes': ('harke',),
'harket': ('harke',),
'harm': ('harme',),
'harma': ('harme',),
'harme': ('harme',),
'harmer': ('harme',),
'harmes': ('harme',),
'harmet': ('harme',),
'harmoner': ('harmonere',),
'harmonere': ('harmonere',),
'harmonerer': ('harmonere',),
'harmoneres': ('harmonere',),
'harmonert': ('harmonere',),
'harmonerte': ('harmonere',),
'harmoniser': ('harmonisere',),
'harmonisere': ('harmonisere',),
'harmoniserer': ('harmonisere',),
'harmoniseres': ('harmonisere',),
'harmonisert': ('harmonisere',),
'harmoniserte': ('harmonisere',),
'harp': ('harpe',),
'harpa': ('harpe',),
'harpe': ('harpe',),
'harper': ('harpe',),
'harpes': ('harpe',),
'harpet': ('harpe',),
'harpeser': ('harpesere',),
'harpesere': ('harpesere',),
'harpeserer': ('harpesere',),
'harpeseres': ('harpesere',),
'harpesert': ('harpesere',),
'harpeserte': ('harpesere',),
'harpuner': ('harpunere',),
'harpunere': ('harpunere',),
'harpunerer': ('harpunere',),
'harpuneres': ('harpunere',),
'harpunert': ('harpunere',),
'harpunerte': ('harpunere',),
'harseler': ('harselere',),
'harselere': ('harselere',),
'harselerer': ('harselere',),
'harseleres': ('harselere',),
'harselert': ('harselere',),
'harselerte': ('harselere',),
'harsk': ('harske',),
'harska': ('harske',),
'harske': ('harske',),
'harsker': ('harske',),
'harskes': ('harske',),
'harsket': ('harske',),
'harskn': ('harskne',),
'harskna': ('harskne',),
'harskne': ('harskne',),
'harskner': ('harskne',),
'harsknes': ('harskne',),
'harsknet': ('harskne',),
'harv': ('harve',),
'harva': ('harve',),
'harve': ('harve',),
'harver': ('harve',),
'harves': ('harve',),
'harvet': ('harve',),
'harv': ('harve',),
'harva': ('harve',),
'harve': ('harve',),
'harver': ('harve',),
'harves': ('harve',),
'harvet': ('harve',),
'hasp': ('haspe',),
'haspa': ('haspe',),
'haspe': ('haspe',),
'hasper': ('haspe',),
'haspes': ('haspe',),
'haspet': ('haspe',),
'haspl': ('hasple',),
'haspla': ('hasple',),
'hasple': ('hasple',),
'haspler': ('hasple',),
'hasples': ('hasple',),
'hasplet': ('hasple',),
'hast': ('haste',),
'hasta': ('haste',),
'haste': ('haste',),
'haster': ('haste',),
'hastes': ('haste',),
'hastet': ('haste',),
'hat': ('hate',),
'hata': ('hate',),
'hate': ('hate',),
'hater': ('hate',),
'hates': ('hate',),
'hatet': ('hate',),
'haug': ('hauge',),
'hauga': ('hauge',),
'hauge': ('hauge',),
'hauger': ('hauge',),
'hauges': ('hauge',),
'hauget': ('hauge',),
'haugla': ('hauglegge',),
'hauglagt': ('hauglegge',),
'hauglegg': ('hauglegge',),
'hauglegge': ('hauglegge',),
'hauglegger': ('hauglegge',),
'hauglegges': ('hauglegge',),
'haugta': ('haugta',),
'haugtaes': ('haugta',),
'haugtar': ('haugta',),
'haugtas': ('haugta',),
'haugtatt': ('haugta',),
'haugtok': ('haugta',),
'hauk': ('hauke',),
'hauka': ('hauke',),
'hauke': ('hauke',),
'hauker': ('hauke',),
'haukes': ('hauke',),
'hauket': ('hauke',),
'hauss': ('hausse',),
'haussa': ('hausse',),
'hausse': ('hausse',),
'hausser': ('hausse',),
'hausses': ('hausse',),
'hausset': ('hausse',),
'havarer': ('havarere',),
'havarere': ('havarere',),
'havarerer': ('havarere',),
'havareres': ('havarere',),
'havarert': ('havarere',),
'havarerte': ('havarere',),
'havn': ('havne',),
'havna': ('havne',),
'havne': ('havne',),
'havner': ('havne',),
'havnes': ('havne',),
'havnet': ('havne',),
'havn': ('havne',),
'havna': ('havne',),
'havne': ('havne',),
'havner': ('havne',),
'havnes': ('havne',),
'havnet': ('havne',),
'havn': ('havne',),
'havna': ('havne',),
'havne': ('havne',),
'havner': ('havne',),
'havnes': ('havne',),
'havnet': ('havne',),
'head': ('heade',),
'heada': ('heade',),
'heade': ('heade',),
'header': ('heade',),
'heades': ('heade',),
'headet': ('heade',),
'hedr': ('hedre',),
'hedra': ('hedre',),
'hedre': ('hedre',),
'hedrer': ('hedre',),
'hedres': ('hedre',),
'hedret': ('hedre',),
'heft': ('hefte',),
'hefta': ('hefte',),
'hefte': ('hefte',),
'hefter': ('hefte',),
'heftes': ('hefte',),
'heftet': ('hefte',),
'hegd': ('hegde',),
'hegda': ('hegde',),
'hegde': ('hegde',),
'hegder': ('hegde',),
'hegdes': ('hegde',),
'hegdet': ('hegde',),
'hegn': ('hegne',),
'hegna': ('hegne',),
'hegne': ('hegne',),
'hegner': ('hegne',),
'hegnes': ('hegne',),
'hegnet': ('hegne',),
'hei': ('heie',),
'heia': ('heie',),
'heie': ('heie',),
'heier': ('heie',),
'heies': ('heie',),
'heiet': ('heie',),
'heilgarder': ('heilgardere',),
'heilgardere': ('heilgardere',),
'heilgarderer': ('heilgardere',),
'heilgarderes': ('heilgardere',),
'heilgardert': ('heilgardere',),
'heilgarderte': ('heilgardere',),
'heilsteik': ('heilsteike',),
'heilsteike': ('heilsteike',),
'heilsteiker': ('heilsteike',),
'heilsteikes': ('heilsteike',),
'heilsteikt': ('heilsteike',),
'heilsteikte': ('heilsteike',),
'heilstek': ('heilsteke',),
'heilsteke': ('heilsteke',),
'heilsteker': ('heilsteke',),
'heilstekes': ('heilsteke',),
'heilstekt': ('heilsteke',),
'heilstekte': ('heilsteke',),
'heilstøp': ('heilstøpe',),
'heilstøpe': ('heilstøpe',),
'heilstøper': ('heilstøpe',),
'heilstøpes': ('heilstøpe',),
'heilstøpt': ('heilstøpe',),
'heilstøpte': ('heilstøpe',),
'heilstøyp': ('heilstøype',),
'heilstøype': ('heilstøype',),
'heilstøyper': ('heilstøype',),
'heilstøypes': ('heilstøype',),
'heilstøypt': ('heilstøype',),
'heilstøypte': ('heilstøype',),
'heilsynkroniser': ('heilsynkronisere',),
'heilsynkronisere': ('heilsynkronisere',),
'heilsynkroniserer': ('heilsynkronisere',),
'heilsynkroniseres': ('heilsynkronisere',),
'heilsynkronisert': ('heilsynkronisere',),
'heilsynkroniserte': ('heilsynkronisere',),
'heim': ('heime',),
'heima': ('heime',),
'heime': ('heime',),
'heimer': ('heime',),
'heimes': ('heime',),
'heimet': ('heime',),
'heimfall': ('heimfalle',),
'heimfalle': ('heimfalle',),
'heimfaller': ('heimfalle',),
'heimfalles': ('heimfalle',),
'heimfalt': ('heimfalle',),
'heimfest': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfeste': ('heimfeste',),
'heimfester': ('heimfeste',),
'heimfestes': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfør': ('heimføre',),
'heimføre': ('heimføre',),
'heimfører': ('heimføre',),
'heimføres': ('heimføre',),
'heimført': ('heimføre',),
'heimførte': ('heimføre',),
'heimkall': ('heimkalle',),
'heimkalle': ('heimkalle',),
'heimkaller': ('heimkalle',),
'heimkalles': ('heimkalle',),
'heimkalt': ('heimkalle',),
'heimkalte': ('heimkalle',),
'heiml': ('heimle',),
'heimla': ('heimle',),
'heimle': ('heimle',),
'heimler': ('heimle',),
'heimles': ('heimle',),
'heimlet': ('heimle',),
'heimsend': ('heimsende',),
'heimsende': ('heimsende',),
'heimsender': ('heimsende',),
'heimsendes': ('heimsende',),
'heimsendt': ('heimsende',),
'heimsendte': ('heimsende',),
'heimsøk': ('heimsøke',),
'heimsøke': ('heimsøke',),
'heimsøker': ('heimsøke',),
'heimsøkes': ('heimsøke',),
'heimsøkt': ('heimsøke',),
'heimsøkte': ('heimsøke',),
'hein': ('heine',),
'heine': ('heine',),
'heiner': ('heine',),
'heines': ('heine',),
'heint': ('heine',),
'heinte': ('heine',),
'heis': ('heise',),
'heise': ('heise',),
'heiser': ('heise',),
'heises': ('heise',),
'heist': ('heise',),
'heiste': ('heise',),
'heis': ('heise',),
'heise': ('heise',),
'heiser': ('heise',),
'heises': ('heise',),
'heist': ('heise',),
'heiste': ('heise',),
'heitn': ('heitne',),
'heitna': ('heitne',),
'heitne': ('heitne',),
'heitner': ('heitne',),
'heitnes': ('heitne',),
'heitnet': ('heitne',),
'hekk': ('hekke',),
'hekka': ('hekke',),
'hekke': ('hekke',),
'hekker': ('hekke',),
'hekkes': ('hekke',),
'hekket': ('hekke',),
'hekl': ('hekle',),
'hekla': ('hekle',),
'hekle': ('hekle',),
'hekler': ('hekle',),
'hekles': ('hekle',),
'heklet': ('hekle',),
'hekl': ('hekle',),
'hekla': ('hekle',),
'hekle': ('hekle',),
'hekler': ('hekle',),
'hekles': ('hekle',),
'heklet': ('hekle',),
'heks': ('hekse',),
'heksa': ('hekse',),
'hekse': ('hekse',),
'hekser': ('hekse',),
'hekses': ('hekse',),
'hekset': ('hekse',),
'hekt': ('hekte',),
'hekta': ('hekte',),
'hekte': ('hekte',),
'hekter': ('hekte',),
'hektes': ('hekte',),
'hektet': ('hekte',),
'hektografer': ('hektografere',),
'hektografere': ('hektografere',),
'hektograferer': ('hektografere',),
'hektograferes': ('hektografere',),
'hektografert': ('hektografere',),
'hektograferte': ('hektografere',),
'helbred': ('helbrede',),
'helbreda': ('helbrede',),
'helbrede': ('helbrede',),
'helbreder': ('helbrede',),
'helbredes': ('helbrede',),
'helbredet': ('helbrede',),
'held': ('helde',),
'helda': ('helde',),
'helde': ('helde',),
'helder': ('helde',),
'heldes': ('helde',),
'heldet': ('helde',),
'helgarder': ('helgardere',),
'helgardere': ('helgardere',),
'helgarderer': ('helgardere',),
'helgarderes': ('helgardere',),
'helgardert': ('helgardere',),
'helgarderte': ('helgardere',),
'hell': ('helle',),
'hella': ('helle',),
'helle': ('helle',),
'heller': ('helle',),
'helles': ('helle',),
'hellet': ('helle',),
'helt': ('helle',),
'helte': ('helle',),
'hellela': ('hellelegge',),
'hellelagt': ('hellelegge',),
'hellelegg': ('hellelegge',),
'hellelegge': ('hellelegge',),
'hellelegger': ('hellelegge',),
'hellelegges': ('hellelegge',),
'hellig': ('hellige',),
'helliga': ('hellige',),
'hellige': ('hellige',),
'helliger': ('hellige',),
'helliges': ('hellige',),
'helliget': ('hellige',),
'hellighold': ('helligholde',),
'helligholde': ('helligholde',),
'helligholder': ('helligholde',),
'helligholdes': ('helligholde',),
'helligholdt': ('helligholde',),
'hels': ('helse',),
'helse': ('helse',),
'helser': ('helse',),
'helses': ('helse',),
'helst': ('helse',),
'helste': ('helse',),
'hels': ('helse',),
'helse': ('helse',),
'helser': ('helse',),
'helses': ('helse',),
'helst': ('helse',),
'helste': ('helse',),
'helseslo': ('helseslå',),
'helseslå': ('helseslå',),
'helseslåes': ('helseslå',),
'helseslår': ('helseslå',),
'helseslås': ('helseslå',),
'helseslått': ('helseslå',),
'helsteik': ('helsteike',),
'helsteike': ('helsteike',),
'helsteiker': ('helsteike',),
'helsteikes': ('helsteike',),
'helsteikt': ('helsteike',),
'helsteikte': ('helsteike',),
'helstek': ('helsteke',),
'helsteke': ('helsteke',),
'helsteker': ('helsteke',),
'helstekes': ('helsteke',),
'helstekt': ('helsteke',),
'helstekte': ('helsteke',),
'helstøp': ('helstøpe',),
'helstøpe': ('helstøpe',),
'helstøper': ('helstøpe',),
'helstøpes': ('helstøpe',),
'helstøpt': ('helstøpe',),
'helstøpte': ('helstøpe',),
'helstøyp': ('helstøype',),
'helstøype': ('helstøype',),
'helstøyper': ('helstøype',),
'helstøypes': ('helstøype',),
'helstøypt': ('helstøype',),
'helstøypte': ('helstøype',),
'helsynkroniser': ('helsynkronisere',),
'helsynkronisere': ('helsynkronisere',),
'helsynkroniserer': ('helsynkronisere',),
'helsynkroniseres': ('helsynkronisere',),
'helsynkronisert': ('helsynkronisere',),
'helsynkroniserte': ('helsynkronisere',),
'hem': ('hemme',),
'hemma': ('hemme',),
'hemme': ('hemme',),
'hemmer': ('hemme',),
'hemmes': ('hemme',),
'hemmet': ('hemme',),
'hemmelighold': ('hemmeligholde',),
'hemmeligholde': ('hemmeligholde',),
'hemmeligholder': ('hemmeligholde',),
'hemmeligholdes': ('hemmeligholde',),
'hemmeligholdt': ('hemmeligholde',),
'hemmeligstempl': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemple': ('hemmeligstemple',),
'hemmeligstempler': ('hemmeligstemple',),
'hemmeligstemples': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hend': ('hende',),
'hende': ('hende',),
'hender': ('hende',),
'hendes': ('hende',),
'hendt': ('hende',),
'hendte': ('hende',),
'henfør': ('henføre',),
'henføre': ('henføre',),
'henfører': ('henføre',),
'henføres': ('henføre',),
'henført': ('henføre',),
'henførte': ('henføre',),
'henga': ('hengi',),
'hengav': ('hengi',),
'hengi': ('hengi',),
'hengies': ('hengi',),
'hengir': ('hengi',),
'hengis': ('hengi',),
'hengitt': ('hengi',),
'hengsl': ('hengsle',),
'hengsla': ('hengsle',),
'hengsle': ('hengsle',),
'hengsler': ('hengsle',),
'hengsles': ('hengsle',),
'hengslet': ('hengsle',),
'henhold': ('henholde',),
'henholde': ('henholde',),
'henholder': ('henholde',),
'henholdes': ('henholde',),
'henholdt': ('henholde',),
'henhør': ('henhøre',),
'henhøre': ('henhøre',),
'henhører': ('henhøre',),
'henhøres': ('henhøre',),
'henhørt': ('henhøre',),
'henhørte': ('henhøre',),
'henkast': ('henkaste',),
'henkasta': ('henkaste',),
'henkaste': ('henkaste',),
'henkaster': ('henkaste',),
'henkastes': ('henkaste',),
'henkastet': ('henkaste',),
'henled': ('henlede',),
'henleda': ('henlede',),
'henlede': ('henlede',),
'henleder': ('henlede',),
'henledes': ('henlede',),
'henledet': ('henlede',),
'henla': ('henlegge',),
'henlagt': ('henlegge',),
'henlegg': ('henlegge',),
'henlegge': ('henlegge',),
'henlegger': ('henlegge',),
'henlegges': ('henlegge',),
'henrekn': ('henrekne',),
'henrekna': ('henrekne',),
'henrekne': ('henrekne',),
'henrekner': ('henrekne',),
'henreknes': ('henrekne',),
'henreknet': ('henrekne',),
'henrett': ('henrette',),
'henretta': ('henrette',),
'henrette': ('henrette',),
'henretter': ('henrette',),
'henrettes': ('henrette',),
'henrettet': ('henrette',),
'henrykk': ('henrykke',),
'henrykka': ('henrykke',),
'henrykke': ('henrykke',),
'henrykker': ('henrykke',),
'henrykkes': ('henrykke',),
'henrykket': ('henrykke',),
'henrykt': ('henrykke',),
'henrykte': ('henrykke',),
'hensatt': ('hensette',),
'hensatte': ('hensette',),
'hensett': ('hensette',),
'hensette': ('hensette',),
'hensetter': ('hensette',),
'hensettes': ('hensette',),
'henskaut': ('henskyte',),
'henskjøt': ('henskyte',),
'henskutt': ('henskyte',),
'henskyt': ('henskyte',),
'henskyte': ('henskyte',),
'henskyter': ('henskyte',),
'henskytes': ('henskyte',),
'henskøyt': ('henskyte',),
'henslep': ('henslepe',),
'henslepe': ('henslepe',),
'hensleper': ('henslepe',),
'henslepes': ('henslepe',),
'henslept': ('henslepe',),
'henslepte': ('henslepe',),
'henspill': ('henspille',),
'henspille': ('henspille',),
'henspiller': ('henspille',),
'henspilles': ('henspille',),
'henspilt': ('henspille',),
'henspilte': ('henspille',),
'henstill': ('henstille',),
'henstille': ('henstille',),
'henstiller': ('henstille',),
'henstilles': ('henstille',),
'henstilt': ('henstille',),
'henstilte': ('henstille',),
'hent': ('hente',),
'henta': ('hente',),
'hente': ('hente',),
'henter': ('hente',),
'hentes': ('hente',),
'hentet': ('hente',),
'hentyd': ('hentyde',),
'hentyda': ('hentyde',),
'hentyde': ('hentyde',),
'hentyder': ('hentyde',),
'hentydes': ('hentyde',),
'hentydet': ('hentyde',),
'henvend': ('henvende',),
'henvende': ('henvende',),
'henvender': ('henvende',),
'henvendes': ('henvende',),
'henvendt': ('henvende',),
'henvendte': ('henvende',),
'henvis': ('henvise',),
'henvise': ('henvise',),
'henviser': ('henvise',),
'henvises': ('henvise',),
'henvist': ('henvise',),
'henviste': ('henvise',),
'hepp': ('heppe',),
'heppa': ('heppe',),
'heppe': ('heppe',),
'hepper': ('heppe',),
'heppes': ('heppe',),
'heppet': ('heppe',),
'herd': ('herde',),
'herda': ('herde',),
'herde': ('herde',),
'herder': ('herde',),
'herdes': ('herde',),
'herdet': ('herde',),
'herdn': ('herdne',),
'herdna': ('herdne',),
'herdne': ('herdne',),
'herdner': ('herdne',),
'herdnes': ('herdne',),
'herdnet': ('herdne',),
'herj': ('herje',),
'herja': ('herje',),
'herje': ('herje',),
'herjer': ('herje',),
'herjes': ('herje',),
'herjet': ('herje',),
'herliggjorde': ('herliggjøre',),
'herliggjort': ('herliggjøre',),
'herliggjør': ('herliggjøre',),
'herliggjøre': ('herliggjøre',),
'herliggjøres': ('herliggjøre',),
'herm': ('herme',),
'herma': ('herme',),
'herme': ('herme',),
'hermer': ('herme',),
'hermes': ('herme',),
'hermet': ('herme',),
'hermt': ('herme',),
'hermte': ('herme',),
'hermetiser': ('hermetisere',),
'hermetisere': ('hermetisere',),
'hermetiserer': ('hermetisere',),
'hermetiseres': ('hermetisere',),
'hermetisert': ('hermetisere',),
'hermetiserte': ('hermetisere',),
'heroiser': ('heroisere',),
'heroisere': ('heroisere',),
'heroiserer': ('heroisere',),
'heroiseres': ('heroisere',),
'heroisert': ('heroisere',),
'heroiserte': ('heroisere',),
'hers': ('herse',),
'hersa': ('herse',),
'herse': ('herse',),
'herser': ('herse',),
'herses': ('herse',),
'herset': ('herse',),
'hersk': ('herske',),
'herska': ('herske',),
'herske': ('herske',),
'hersker': ('herske',),
'herskes': ('herske',),
'hersket': ('herske',),
'hesj': ('hesje',),
'hesja': ('hesje',),
'hesje': ('hesje',),
'hesjer': ('hesje',),
'hesjes': ('hesje',),
'hesjet': ('hesje',),
'hesp': ('hespe',),
'hespa': ('hespe',),
'hespe': ('hespe',),
'hesper': ('hespe',),
'hespes': ('hespe',),
'hespet': ('hespe',),
'hespl': ('hesple',),
'hespla': ('hesple',),
'hesple': ('hesple',),
'hespler': ('hesple',),
'hesples': ('hesple',),
'hesplet': ('hesple',),
'hestehandl': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandle': ('hestehandle',),
'hestehandler': ('hestehandle',),
'hestehandles': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'het': ('hete',),
'heta': ('hete',),
'hete': ('hete',),
'heter': ('hete',),
'hetes': ('hete',),
'hetet': ('hete',),
'het': ('hete',),
'hete': ('hete',),
'heter': ('hete',),
'hetes': ('hete',),
'hett': ('hete',),
'hette': ('hete',),
'hetn': ('hetne',),
'hetna': ('hetne',),
'hetne': ('hetne',),
'hetner': ('hetne',),
'hetnes': ('hetne',),
'hetnet': ('hetne',),
'hets': ('hetse',),
'hetsa': ('hetse',),
'hetse': ('hetse',),
'hetser': ('hetse',),
'hetses': ('hetse',),
'hetset': ('hetse',),
'hevd': ('hevde',),
'hevda': ('hevde',),
'hevde': ('hevde',),
'hevder': ('hevde',),
'hevdes': ('hevde',),
'hevdet': ('hevde',),
'hev': ('heve',),
'heva': ('heve',),
'hevd': ('heve',),
'hevde': ('heve',),
'heve': ('heve',),
'hever': ('heve',),
'heves': ('heve',),
'hevet': ('heve',),
'hevl': ('hevle',),
'hevla': ('hevle',),
'hevle': ('hevle',),
'hevler': ('hevle',),
'hevles': ('hevle',),
'hevlet': ('hevle',),
'hevn': ('hevne',),
'hevna': ('hevne',),
'hevne': ('hevne',),
'hevner': ('hevne',),
'hevnes': ('hevne',),
'hevnet': ('hevne',),
'hi': ('hie',),
'hia': ('hie',),
'hie': ('hie',),
'hier': ('hie',),
'hies': ('hie',),
'hiet': ('hie',),
'hig': ('hige',),
'higa': ('hige',),
'hige': ('hige',),
'higer': ('hige',),
'higes': ('hige',),
'higet': ('hige',),
'hikk': ('hikke',),
'hikka': ('hikke',),
'hikke': ('hikke',),
'hikker': ('hikke',),
'hikkes': ('hikke',),
'hikket': ('hikke',),
'hikst': ('hikste',),
'hiksta': ('hikste',),
'hikste': ('hikste',),
'hikster': ('hikste',),
'hikstes': ('hikste',),
'hikstet': ('hikste',),
'hikstegret': ('hikstegråte',),
'hikstegråt': ('hikstegråte',),
'hikstegråte': ('hikstegråte',),
'hikstegråter': ('hikstegråte',),
'hikstegråtes': ('hikstegråte',),
'hikstegrått': ('hikstegråte',),
'hild': ('hilde',),
'hilda': ('hilde',),
'hilde': ('hilde',),
'hilder': ('hilde',),
'hildes': ('hilde',),
'hildet': ('hilde',),
'hildr': ('hildre',),
'hildra': ('hildre',),
'hildre': ('hildre',),
'hildrer': ('hildre',),
'hildres': ('hildre',),
'hildret': ('hildre',),
'hils': ('hilse',),
'hilse': ('hilse',),
'hilser': ('hilse',),
'hilses': ('hilse',),
'hilst': ('hilse',),
'hilste': ('hilse',),
'hils': ('hilse',),
'hilse': ('hilse',),
'hilser': ('hilse',),
'hilses': ('hilse',),
'hilst': ('hilse',),
'hilste': ('hilse',),
'himl': ('himle',),
'himla': ('himle',),
'himle': ('himle',),
'himler': ('himle',),
'himles': ('himle',),
'himlet': ('himle',),
'himl': ('himle',),
'himla': ('himle',),
'himle': ('himle',),
'himler': ('himle',),
'himles': ('himle',),
'himlet': ('himle',),
'hindr': ('hindre',),
'hindra': ('hindre',),
'hindre': ('hindre',),
'hindrer': ('hindre',),
'hindres': ('hindre',),
'hindret': ('hindre',),
'hink': ('hinke',),
'hinka': ('hinke',),
'hinke': ('hinke',),
'hinker': ('hinke',),
'hinkes': ('hinke',),
'hinket': ('hinke',),
'hip': ('hipe',),
'hipa': ('hipe',),
'hipe': ('hipe',),
'hiper': ('hipe',),
'hipes': ('hipe',),
'hipet': ('hipe',),
'hipt': ('hipe',),
'hipte': ('hipe',),
'hir': ('hire',),
'hire': ('hire',),
'hirer': ('hire',),
'hires': ('hire',),
'hirt': ('hire',),
'hirte': ('hire',),
'hiss': ('hisse',),
'hissa': ('hisse',),
'hisse': ('hisse',),
'hisser': ('hisse',),
'hisses': ('hisse',),
'hisset': ('hisse',),
'hitsatt': ('hitsette',),
'hitsatte': ('hitsette',),
'hitsett': ('hitsette',),
'hitsette': ('hitsette',),
'hitsetter': ('hitsette',),
'hitsettes': ('hitsette',),
'hitt': ('hitte',),
'hitta': ('hitte',),
'hitte': ('hitte',),
'hitter': ('hitte',),
'hittes': ('hitte',),
'hittet': ('hitte',),
'heiv': ('hive',),
'hev': ('hive',),
'hiv': ('hive',),
'hivd': ('hive',),
'hivde': ('hive',),
'hive': ('hive',),
'hiver': ('hive',),
'hives': ('hive',),
'hjalp': ('hjelpe',),
'hjelp': ('hjelpe',),
'hjelpe': ('hjelpe',),
'hjelper': ('hjelpe',),
'hjelpes': ('hjelpe',),
'hjulpet': ('hjelpe',),
'hjemfall': ('hjemfalle',),
'hjemfalle': ('hjemfalle',),
'hjemfaller': ('hjemfalle',),
'hjemfalles': ('hjemfalle',),
'hjemfalt': ('hjemfalle',),
'hjemfest': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfeste': ('hjemfeste',),
'hjemfester': ('hjemfeste',),
'hjemfestes': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfør': ('hjemføre',),
'hjemføre': ('hjemføre',),
'hjemfører': ('hjemføre',),
'hjemføres': ('hjemføre',),
'hjemført': ('hjemføre',),
'hjemførte': ('hjemføre',),
'hjemkall': ('hjemkalle',),
'hjemkalle': ('hjemkalle',),
'hjemkaller': ('hjemkalle',),
'hjemkalles': ('hjemkalle',),
'hjemkalt': ('hjemkalle',),
'hjemkalte': ('hjemkalle',),
'hjeml': ('hjemle',),
'hjemla': ('hjemle',),
'hjemle': ('hjemle',),
'hjemler': ('hjemle',),
'hjemles': ('hjemle',),
'hjemlet': ('hjemle',),
'hjemsend': ('hjemsende',),
'hjemsende': ('hjemsende',),
'hjemsender': ('hjemsende',),
'hjemsendes': ('hjemsende',),
'hjemsendt': ('hjemsende',),
'hjemsendte': ('hjemsende',),
'hjemsøk': ('hjemsøke',),
'hjemsøke': ('hjemsøke',),
'hjemsøker': ('hjemsøke',),
'hjemsøkes': ('hjemsøke',),
'hjemsøkt': ('hjemsøke',),
'hjemsøkte': ('hjemsøke',),
'hjernevask': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevaske': ('hjernevaske',),
'hjernevasker': ('hjernevaske',),
'hjernevaskes': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hofferd': ('hofferde',),
'hofferda': ('hofferde',),
'hofferde': ('hofferde',),
'hofferder': ('hofferde',),
'hofferdes': ('hofferde',),
'hofferdet': ('hofferde',),
'hoi': ('hoie',),
'hoia': ('hoie',),
'hoie': ('hoie',),
'hoier': ('hoie',),
'hoies': ('hoie',),
'hoiet': ('hoie',),
'hold': ('holde',),
'holde': ('holde',),
'holder': ('holde',),
'holdes': ('holde',),
'holdt': ('holde',),
'hol': ('hole',),
'hole': ('hole',),
'holer': ('hole',),
'holes': ('hole',),
'holt': ('hole',),
'holte': ('hole',),
'holk': ('holke',),
'holka': ('holke',),
'holke': ('holke',),
'holker': ('holke',),
'holkes': ('holke',),
'holket': ('holke',),
'holn': ('holne',),
'holna': ('holne',),
'holne': ('holne',),
'holner': ('holne',),
'holnes': ('holne',),
'holnet': ('holne',),
'hom': ('homme',),
'homma': ('homme',),
'homme': ('homme',),
'hommer': ('homme',),
'hommes': ('homme',),
'hommet': ('homme',),
'homogeniser': ('homogenisere',),
'homogenisere': ('homogenisere',),
'homogeniserer': ('homogenisere',),
'homogeniseres': ('homogenisere',),
'homogenisert': ('homogenisere',),
'homogeniserte': ('homogenisere',),
'honninggjøm': ('honninggjømme',),
'honninggjømme': ('honninggjømme',),
'honninggjømmer': ('honninggjømme',),
'honninggjømmes': ('honninggjømme',),
'honninggjømt': ('honninggjømme',),
'honninggjømte': ('honninggjømme',),
'honorer': ('honorere',),
'honorere': ('honorere',),
'honorerer': ('honorere',),
'honoreres': ('honorere',),
'honorert': ('honorere',),
'honorerte': ('honorere',),
'hop': ('hope',),
'hopa': ('hope',),
'hope': ('hope',),
'hoper': ('hope',),
'hopes': ('hope',),
'hopet': ('hope',),
'hop': ('hope',),
'hopa': ('hope',),
'hope': ('hope',),
'hoper': ('hope',),
'hopes': ('hope',),
'hopet': ('hope',),
'hopp': ('hoppe',),
'hoppa': ('hoppe',),
'hoppe': ('hoppe',),
'hopper': ('hoppe',),
'hoppes': ('hoppe',),
'hoppet': ('hoppe',),
'hor': ('hore',),
'hora': ('hore',),
'hore': ('hore',),
'horer': ('hore',),
'hores': ('hore',),
'horet': ('hore',),
'hort': ('hore',),
'horte': ('hore',),
'hors': ('horse',),
'horsa': ('horse',),
'horse': ('horse',),
'horser': ('horse',),
'horses': ('horse',),
'horset': ('horse',),
'hospitaliser': ('hospitalisere',),
'hospitalisere': ('hospitalisere',),
'hospitaliserer': ('hospitalisere',),
'hospitaliseres': ('hospitalisere',),
'hospitalisert': ('hospitalisere',),
'hospitaliserte': ('hospitalisere',),
'hospiter': ('hospitere',),
'hospitere': ('hospitere',),
'hospiterer': ('hospitere',),
'hospiteres': ('hospitere',),
'hospitert': ('hospitere',),
'hospiterte': ('hospitere',),
'host': ('hoste',),
'hosta': ('hoste',),
'hoste': ('hoste',),
'hoster': ('hoste',),
'hostes': ('hoste',),
'hostet': ('hoste',),
'hot': ('hote',),
'hota': ('hote',),
'hote': ('hote',),
'hoter': ('hote',),
'hotes': ('hote',),
'hotet': ('hote',),
'hover': ('hovere',),
'hovere': ('hovere',),
'hoverer': ('hovere',),
'hoveres': ('hovere',),
'hovert': ('hovere',),
'hoverte': ('hovere',),
'hovmesterer': ('hovmesterere',),
'hovmesterere': ('hovmesterere',),
'hovmestererer': ('hovmesterere',),
'hovmestereres': ('hovmesterere',),
'hovmesterert': ('hovmesterere',),
'hovmestererte': ('hovmesterere',),
'hovmod': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmode': ('hovmode',),
'hovmoder': ('hovmode',),
'hovmodes': ('hovmode',),
'hovmodet': ('hovmode',),
'hovn': ('hovne',),
'hovna': ('hovne',),
'hovne': ('hovne',),
'hovner': ('hovne',),
'hovnes': ('hovne',),
'hovnet': ('hovne',),
'hudflett': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflette': ('hudflette',),
'hudfletter': ('hudflette',),
'hudflettes': ('hudflette',),
'hudflettet': ('hudflette',),
'hudstrauk': ('hudstryke',),
'hudstryk': ('hudstryke',),
'hudstryke': ('hudstryke',),
'hudstryker': ('hudstryke',),
'hudstrykes': ('hudstryke',),
'hudstrøk': ('hudstryke',),
'hudstrøket': ('hudstryke',),
'hudstrøyk': ('hudstryke',),
'hufs': ('hufse',),
'hufsa': ('hufse',),
'hufse': ('hufse',),
'hufser': ('hufse',),
'hufses': ('hufse',),
'hufset': ('hufse',),
'hug': ('huge',),
'huga': ('huge',),
'huge': ('huge',),
'huger': ('huge',),
'huges': ('huge',),
'huget': ('huge',),
'hugs': ('hugse',),
'hugsa': ('hugse',),
'hugse': ('hugse',),
'hugser': ('hugse',),
'hugses': ('hugse',),
'hugset': ('hugse',),
'hugsval': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvale': ('hugsvale',),
'hugsvaler': ('hugsvale',),
'hugsvales': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalt': ('hugsvale',),
'hugsvalte': ('hugsvale',),
'hugta': ('hugta',),
'hugtaes': ('hugta',),
'hugtar': ('hugta',),
'hugtas': ('hugta',),
'hugtatt': ('hugta',),
'hugtok': ('hugta',),
'hui': ('huie',),
'huia': ('huie',),
'huie': ('huie',),
'huier': ('huie',),
'huies': ('huie',),
'huiet': ('huie',),
'huk': ('huke',),
'huka': ('huke',),
'huke': ('huke',),
'huker': ('huke',),
'hukes': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'hukte': ('huke',),
'huk': ('huke',),
'huka': ('huke',),
'huke': ('huke',),
'huker': ('huke',),
'hukes': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'hukte': ('huke',),
'hukr': ('hukre',),
'hukra': ('hukre',),
'hukre': ('hukre',),
'hukrer': ('hukre',),
'hukres': ('hukre',),
'hukret': ('hukre',),
'hul': ('hule',),
'hula': ('hule',),
'hule': ('hule',),
'huler': ('hule',),
'hules': ('hule',),
'hulet': ('hule',),
'hult': ('hule',),
'hulte': ('hule',),
'hulk': ('hulke',),
'hulka': ('hulke',),
'hulke': ('hulke',),
'hulker': ('hulke',),
'hulkes': ('hulke',),
'hulket': ('hulke',),
'hull': ('hulle',),
'hulla': ('hulle',),
'hulle': ('hulle',),
'huller': ('hulle',),
'hulles': ('hulle',),
'hullet': ('hulle',),
'humaniser': ('humanisere',),
'humanisere': ('humanisere',),
'humaniserer': ('humanisere',),
'humaniseres': ('humanisere',),
'humanisert': ('humanisere',),
'humaniserte': ('humanisere',),
'hump': ('humpe',),
'humpa': ('humpe',),
'humpe': ('humpe',),
'humper': ('humpe',),
'humpes': ('humpe',),
'humpet': ('humpe',),
'humr': ('humre',),
'humra': ('humre',),
'humre': ('humre',),
'humrer': ('humre',),
'humres': ('humre',),
'humret': ('humre',),
'hundjag': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjagd': ('hundjage',),
'hundjagde': ('hundjage',),
'hundjage': ('hundjage',),
'hundjager': ('hundjage',),
'hundjages': ('hundjage',),
'hundjaget': ('hundjage',),
'hunds': ('hundse',),
'hundsa': ('hundse',),
'hundse': ('hundse',),
'hundser': ('hundse',),
'hundses': ('hundse',),
'hundset': ('hundse',),
'hungr': ('hungre',),
'hungra': ('hungre',),
'hungre': ('hungre',),
'hungrer': ('hungre',),
'hungres': ('hungre',),
'hungret': ('hungre',),
'hurp': ('hurpe',),
'hurpa': ('hurpe',),
'hurpe': ('hurpe',),
'hurper': ('hurpe',),
'hurpes': ('hurpe',),
'hurpet': ('hurpe',),
'hurr': ('hurre',),
'hurra': ('hurre',),
'hurre': ('hurre',),
'hurrer': ('hurre',),
'hurres': ('hurre',),
'hurret': ('hurre',),
'husbankfinansier': ('husbankfinansiere',),
'husbankfinansiere': ('husbankfinansiere',),
'husbankfinansierer': ('husbankfinansiere',),
'husbankfinansieres': ('husbankfinansiere',),
'husbankfinansiert': ('husbankfinansiere',),
'husbankfinansierte': ('husbankfinansiere',),
'hus': ('huse',),
'husa': ('huse',),
'huse': ('huse',),
'huser': ('huse',),
'huses': ('huse',),
'huset': ('huse',),
'hust': ('huse',),
'huste': ('huse',),
'huser': ('husere',),
'husere': ('husere',),
'huserer': ('husere',),
'huseres': ('husere',),
'husert': ('husere',),
'huserte': ('husere',),
'hushold': ('husholde',),
'husholde': ('husholde',),
'husholder': ('husholde',),
'husholdes': ('husholde',),
'husholdt': ('husholde',),
'husholder': ('husholdere',),
'husholdere': ('husholdere',),
'husholderer': ('husholdere',),
'husholderes': ('husholdere',),
'husholdert': ('husholdere',),
'husholderte': ('husholdere',),
'husholderer': ('husholderere',),
'husholderere': ('husholderere',),
'husholdererer': ('husholderere',),
'husholdereres': ('husholderere',),
'husholderert': ('husholderere',),
'husholdererte': ('husholderere',),
'husk': ('huske',),
'huska': ('huske',),
'huske': ('huske',),
'husker': ('huske',),
'huskes': ('huske',),
'husket': ('huske',),
'husk': ('huske',),
'huska': ('huske',),
'huske': ('huske',),
'husker': ('huske',),
'huskes': ('huske',),
'husket': ('huske',),
'hustr': ('hustre',),
'hustra': ('hustre',),
'hustre': ('hustre',),
'hustrer': ('hustre',),
'hustres': ('hustre',),
'hustret': ('hustre',),
'husval': ('husvale',),
'husvale': ('husvale',),
'husvaler': ('husvale',),
'husvales': ('husvale',),
'husvalt': ('husvale',),
'husvalte': ('husvale',),
'hut': ('hute',),
'huta': ('hute',),
'hute': ('hute',),
'huter': ('hute',),
'hutes': ('hute',),
'hutet': ('hute',),
'hutr': ('hutre',),
'hutra': ('hutre',),
'hutre': ('hutre',),
'hutrer': ('hutre',),
'hutres': ('hutre',),
'hutret': ('hutre',),
'hvelv': ('hvelve',),
'hvelva': ('hvelve',),
'hvelve': ('hvelve',),
'hvelver': ('hvelve',),
'hvelves': ('hvelve',),
'hvelvet': ('hvelve',),
'hves': ('hvese',),
'hvese': ('hvese',),
'hveser': ('hvese',),
'hveses': ('hvese',),
'hvest': ('hvese',),
'hveste': ('hvese',),
'hvess': ('hvesse',),
'hvessa': ('hvesse',),
'hvesse': ('hvesse',),
'hvesser': ('hvesse',),
'hvesses': ('hvesse',),
'hvesset': ('hvesse',),
'hvest': ('hvesse',),
'hveste': ('hvesse',),
'hvil': ('hvile',),
'hvile': ('hvile',),
'hviler': ('hvile',),
'hviles': ('hvile',),
'hvilt': ('hvile',),
'hvilte': ('hvile',),
'hvin': ('hvine',),
'hvine': ('hvine',),
'hviner': ('hvine',),
'hvines': ('hvine',),
'hvint': ('hvine',),
'hvinte': ('hvine',),
'hvisk': ('hviske',),
'hviska': ('hviske',),
'hviske': ('hviske',),
'hvisker': ('hviske',),
'hviskes': ('hviske',),
'hvisket': ('hviske',),
'hvisk': ('hviske',),
'hviska': ('hviske',),
'hviske': ('hviske',),
'hvisker': ('hviske',),
'hviskes': ('hviske',),
'hvisket': ('hviske',),
'hvitkalk': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalke': ('hvitkalke',),
'hvitkalker': ('hvitkalke',),
'hvitkalkes': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitn': ('hvitne',),
'hvitna': ('hvitne',),
'hvitne': ('hvitne',),
'hvitner': ('hvitne',),
'hvitnes': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitt': ('hvitte',),
'hvitta': ('hvitte',),
'hvitte': ('hvitte',),
'hvitter': ('hvitte',),
'hvittes': ('hvitte',),
'hvittet': ('hvitte',),
'hvitvask': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvaske': ('hvitvaske',),
'hvitvasker': ('hvitvaske',),
'hvitvaskes': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hygd': ('hygge',),
'hygde': ('hygge',),
'hygg': ('hygge',),
'hygga': ('hygge',),
'hygge': ('hygge',),
'hygger': ('hygge',),
'hygges': ('hygge',),
'hygget': ('hygge',),
'hykl': ('hykle',),
'hykla': ('hykle',),
'hykle': ('hykle',),
'hykler': ('hykle',),
'hykles': ('hykle',),
'hyklet': ('hykle',),
'hyl': ('hyle',),
'hyle': ('hyle',),
'hyler': ('hyle',),
'hyles': ('hyle',),
'hylt': ('hyle',),
'hylte': ('hyle',),
'hyll': ('hylle',),
'hylla': ('hylle',),
'hylle': ('hylle',),
'hyller': ('hylle',),
'hylles': ('hylle',),
'hyllet': ('hylle',),
'hyll': ('hylle',),
'hylla': ('hylle',),
'hylle': ('hylle',),
'hyller': ('hylle',),
'hylles': ('hylle',),
'hyllet': ('hylle',),
'hypnotiser': ('hypnotisere',),
'hypnotisere': ('hypnotisere',),
'hypnotiserer': ('hypnotisere',),
'hypnotiseres': ('hypnotisere',),
'hypnotisert': ('hypnotisere',),
'hypnotiserte': ('hypnotisere',),
'hypp': ('hyppe',),
'hyppa': ('hyppe',),
'hyppe': ('hyppe',),
'hypper': ('hyppe',),
'hyppes': ('hyppe',),
'hyppet': ('hyppe',),
'hyr': ('hyre',),
'hyra': ('hyre',),
'hyre': ('hyre',),
'hyrer': ('hyre',),
'hyres': ('hyre',),
'hyret': ('hyre',),
'hyrt': ('hyre',),
'hyrte': ('hyre',),
'hyr': ('hyre',),
'hyra': ('hyre',),
'hyre': ('hyre',),
'hyrer': ('hyre',),
'hyres': ('hyre',),
'hyret': ('hyre',),
'hyrt': ('hyre',),
'hyrte': ('hyre',),
'hysj': ('hysje',),
'hysja': ('hysje',),
'hysje': ('hysje',),
'hysjer': ('hysje',),
'hysjes': ('hysje',),
'hysjet': ('hysje',),
'hyss': ('hysse',),
'hyssa': ('hysse',),
'hysse': ('hysse',),
'hysser': ('hysse',),
'hysses': ('hysse',),
'hysset': ('hysse',),
'hytt': ('hytte',),
'hytta': ('hytte',),
'hytte': ('hytte',),
'hytter': ('hytte',),
'hyttes': ('hytte',),
'hyttet': ('hytte',),
'hytt': ('hytte',),
'hytta': ('hytte',),
'hytte': ('hytte',),
'hytter': ('hytte',),
'hyttes': ('hytte',),
'hyttet': ('hytte',),
'håndga': ('håndgi',),
'håndgav': ('håndgi',),
'håndgi': ('håndgi',),
'håndgies': ('håndgi',),
'håndgir': ('håndgi',),
'håndgis': ('håndgi',),
'håndgitt': ('håndgi',),
'håndhev': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevd': ('håndheve',),
'håndhevde': ('håndheve',),
'håndheve': ('håndheve',),
'håndhever': ('håndheve',),
'håndheves': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhils': ('håndhilse',),
'håndhilse': ('håndhilse',),
'håndhilser': ('håndhilse',),
'håndhilses': ('håndhilse',),
'håndhilst': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndhils': ('håndhilse',),
'håndhilse': ('håndhilse',),
'håndhilser': ('håndhilse',),
'håndhilses': ('håndhilse',),
'håndhilst': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndplukk': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukke': ('håndplukke',),
'håndplukker': ('håndplukke',),
'håndplukkes': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndter': ('håndtere',),
'håndtere': ('håndtere',),
'håndterer': ('håndtere',),
'håndteres': ('håndtere',),
'håndtert': ('håndtere',),
'håndterte': ('håndtere',),
'hån': ('håne',),
'håna': ('håne',),
'håne': ('håne',),
'håner': ('håne',),
'hånes': ('håne',),
'hånet': ('håne',),
'hånt': ('håne',),
'hånte': ('håne',),
'hånflir': ('hånflire',),
'hånflire': ('hånflire',),
'hånflirer': ('hånflire',),
'hånflires': ('hånflire',),
'hånflirt': ('hånflire',),
'hånflirte': ('hånflire',),
'hånle': ('hånle',),
'hånledd': ('hånle',),
'hånler': ('hånle',),
'hånles': ('hånle',),
'hånlo': ('hånle',),
'håp': ('håpe',),
'håpa': ('håpe',),
'håpe': ('håpe',),
'håper': ('håpe',),
'håpes': ('håpe',),
'håpet': ('håpe',),
'håpt': ('håpe',),
'håpte': ('håpe',),
'håv': ('håve',),
'håva': ('håve',),
'håve': ('håve',),
'håver': ('håve',),
'håves': ('håve',),
'håvet': ('håve',),
'hæl': ('hæle',),
'hæla': ('hæle',),
'hæle': ('hæle',),
'hæler': ('hæle',),
'hæles': ('hæle',),
'hælet': ('hæle',),
'hælt': ('hæle',),
'hælte': ('hæle',),
'hælspark': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparke': ('hælsparke',),
'hælsparker': ('hælsparke',),
'hælsparkes': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hærta': ('hærta',),
'hærtaes': ('hærta',),
'hærtar': ('hærta',),
'hærtas': ('hærta',),
'hærtatt': ('hærta',),
'hærtok': ('hærta',),
'høkr': ('høkre',),
'høkra': ('høkre',),
'høkre': ('høkre',),
'høkrer': ('høkre',),
'høkres': ('høkre',),
'høkret': ('høkre',),
'hølj': ('hølje',),
'hølja': ('hølje',),
'hølje': ('hølje',),
'høljer': ('hølje',),
'høljes': ('hølje',),
'høljet': ('hølje',),
'høljeregn': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregne': ('høljeregne',),
'høljeregner': ('høljeregne',),
'høljeregnes': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnt': ('høljeregne',),
'høljeregnte': ('høljeregne',),
'høljregn': ('høljregne',),
'høljregna': ('høljregne',),
'høljregne': ('høljregne',),
'høljregner': ('høljregne',),
'høljregnes': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnt': ('høljregne',),
'høljregnte': ('høljregne',),
'hør': ('høre',),
'høre': ('høre',),
'hører': ('høre',),
'høres': ('høre',),
'hørt': ('høre',),
'hørte': ('høre',),
'høres': ('høres',),
'hørtes': ('høres',),
'høst': ('høste',),
'høsta': ('høste',),
'høste': ('høste',),
'høster': ('høste',),
'høstes': ('høste',),
'høstet': ('høste',),
'høv': ('høve',),
'høvd': ('høve',),
'høvde': ('høve',),
'høve': ('høve',),
'høver': ('høve',),
'høves': ('høve',),
'høvl': ('høvle',),
'høvla': ('høvle',),
'høvle': ('høvle',),
'høvler': ('høvle',),
'høvles': ('høvle',),
'høvlet': ('høvle',),
'høy': ('høye',),
'høya': ('høye',),
'høye': ('høye',),
'høyer': ('høye',),
'høyes': ('høye',),
'høyet': ('høye',),
'høyn': ('høyne',),
'høyna': ('høyne',),
'høyne': ('høyne',),
'høyner': ('høyne',),
'høynes': ('høyne',),
'høynet': ('høyne',),
'iaktta': ('iaktta',),
'iakttaes': ('iaktta',),
'iakttar': ('iaktta',),
'iakttas': ('iaktta',),
'iakttatt': ('iaktta',),
'iakttok': ('iaktta',),
'iberegn': ('iberegne',),
'iberegna': ('iberegne',),
'iberegne': ('iberegne',),
'iberegner': ('iberegne',),
'iberegnes': ('iberegne',),
'iberegnet': ('iberegne',),
'ibland': ('iblande',),
'iblanda': ('iblande',),
'iblande': ('iblande',),
'iblander': ('iblande',),
'iblandes': ('iblande',),
'iblandet': ('iblande',),
'idealiser': ('idealisere',),
'idealisere': ('idealisere',),
'idealiserer': ('idealisere',),
'idealiseres': ('idealisere',),
'idealisert': ('idealisere',),
'idealiserte': ('idealisere',),
'identifiser': ('identifisere',),
'identifisere': ('identifisere',),
'identifiserer': ('identifisere',),
'identifiseres': ('identifisere',),
'identifisert': ('identifisere',),
'identifiserte': ('identifisere',),
'ideologiser': ('ideologisere',),
'ideologisere': ('ideologisere',),
'ideologiserer': ('ideologisere',),
'ideologiseres': ('ideologisere',),
'ideologisert': ('ideologisere',),
'ideologiserte': ('ideologisere',),
'iddest': ('idest',),
'idest': ('idest',),
'ist': ('idest',),
'idk': ('idke',),
'idka': ('idke',),
'idke': ('idke',),
'idker': ('idke',),
'idkes': ('idke',),
'idket': ('idke',),
'idylliser': ('idyllisere',),
'idyllisere': ('idyllisere',),
'idylliserer': ('idyllisere',),
'idylliseres': ('idyllisere',),
'idyllisert': ('idyllisere',),
'idylliserte': ('idyllisere',),
'idøm': ('idømme',),
'idømme': ('idømme',),
'idømmer': ('idømme',),
'idømmes': ('idømme',),
'idømt': ('idømme',),
'idømte': ('idømme',),
'ifør': ('iføre',),
'iføre': ('iføre',),
'ifører': ('iføre',),
'iføres': ('iføre',),
'iført': ('iføre',),
'iførte': ('iføre',),
'igangsatt': ('igangsette',),
'igangsatte': ('igangsette',),
'igangsett': ('igangsette',),
'igangsette': ('igangsette',),
'igangsetter': ('igangsette',),
'igangsettes': ('igangsette',),
'ignorer': ('ignorere',),
'ignorere': ('ignorere',),
'ignorerer': ('ignorere',),
'ignoreres': ('ignorere',),
'ignorert': ('ignorere',),
'ignorerte': ('ignorere',),
'ihukom': ('ihukomme',),
'ihukomme': ('ihukomme',),
'ihukommer': ('ihukomme',),
'ihukommes': ('ihukomme',),
'ihukommet': ('ihukomme',),
'ikle': ('ikle',),
'ikledd': ('ikle',),
'ikledde': ('ikle',),
'ikler': ('ikle',),
'ikles': ('ikle',),
'ilandfør': ('ilandføre',),
'ilandføre': ('ilandføre',),
'ilandfører': ('ilandføre',),
'ilandføres': ('ilandføre',),
'ilandført': ('ilandføre',),
'ilandførte': ('ilandføre',),
'ild': ('ilde',),
'ilda': ('ilde',),
'ilde': ('ilde',),
'ilder': ('ilde',),
'ildes': ('ilde',),
'ildet': ('ilde',),
'ild': ('ilde',),
'ilda': ('ilde',),
'ilde': ('ilde',),
'ilder': ('ilde',),
'ildes': ('ilde',),
'ildet': ('ilde',),
'ildn': ('ildne',),
'ildna': ('ildne',),
'ildne': ('ildne',),
'ildner': ('ildne',),
'ildnes': ('ildne',),
'ildnet': ('ildne',),
'il': ('ile',),
'ile': ('ile',),
'iler': ('ile',),
'iles': ('ile',),
'ilt': ('ile',),
'ilte': ('ile',),
'ila': ('ilegge',),
'ilagt': ('ilegge',),
'ilegg': ('ilegge',),
'ilegge': ('ilegge',),
'ilegger': ('ilegge',),
'ilegges': ('ilegge',),
'ilign': ('iligne',),
'iligna': ('iligne',),
'iligne': ('iligne',),
'iligner': ('iligne',),
'ilignes': ('iligne',),
'ilignet': ('iligne',),
'ilikn': ('ilikne',),
'ilikna': ('ilikne',),
'ilikne': ('ilikne',),
'ilikner': ('ilikne',),
'iliknes': ('ilikne',),
'iliknet': ('ilikne',),
'illgjø': ('illgjø',),
'illgjødd': ('illgjø',),
'illgjødde': ('illgjø',),
'illgjør': ('illgjø',),
'illgjøs': ('illgjø',),
'illhui': ('illhuie',),
'illhuia': ('illhuie',),
'illhuie': ('illhuie',),
'illhuier': ('illhuie',),
'illhuies': ('illhuie',),
'illhuiet': ('illhuie',),
'illskreik': ('illskrike',),
'illskrek': ('illskrike',),
'illskreket': ('illskrike',),
'illskrik': ('illskrike',),
'illskrike': ('illskrike',),
'illskriker': ('illskrike',),
'illskrikes': ('illskrike',),
'illuder': ('illudere',),
'illudere': ('illudere',),
'illuderer': ('illudere',),
'illuderes': ('illudere',),
'illudert': ('illudere',),
'illuderte': ('illudere',),
'illuminer': ('illuminere',),
'illuminere': ('illuminere',),
'illuminerer': ('illuminere',),
'illumineres': ('illuminere',),
'illuminert': ('illuminere',),
'illuminerte': ('illuminere',),
'illustrer': ('illustrere',),
'illustrere': ('illustrere',),
'illustrerer': ('illustrere',),
'illustreres': ('illustrere',),
'illustrert': ('illustrere',),
'illustrerte': ('illustrere',),
'ilsk': ('ilske',),
'ilska': ('ilske',),
'ilske': ('ilske',),
'ilsker': ('ilske',),
'ilskes': ('ilske',),
'ilsket': ('ilske',),
'ilskn': ('ilskne',),
'ilskna': ('ilskne',),
'ilskne': ('ilskne',),
'ilskner': ('ilskne',),
'ilsknes': ('ilskne',),
'ilsknet': ('ilskne',),
'imaginer': ('imaginere',),
'imaginere': ('imaginere',),
'imaginerer': ('imaginere',),
'imagineres': ('imaginere',),
'imaginert': ('imaginere',),
'imaginerte': ('imaginere',),
'imiter': ('imitere',),
'imitere': ('imitere',),
'imiterer': ('imitere',),
'imiteres': ('imitere',),
'imitert': ('imitere',),
'imiterte': ('imitere',),
'immatrikuler': ('immatrikulere',),
'immatrikulere': ('immatrikulere',),
'immatrikulerer': ('immatrikulere',),
'immatrikuleres': ('immatrikulere',),
'immatrikulert': ('immatrikulere',),
'immatrikulerte': ('immatrikulere',),
'immigrer': ('immigrere',),
'immigrere': ('immigrere',),
'immigrerer': ('immigrere',),
'immigreres': ('immigrere',),
'immigrert': ('immigrere',),
'immigrerte': ('immigrere',),
'immortaliser': ('immortalisere',),
'immortalisere': ('immortalisere',),
'immortaliserer': ('immortalisere',),
'immortaliseres': ('immortalisere',),
'immortalisert': ('immortalisere',),
'immortaliserte': ('immortalisere',),
'immuniser': ('immunisere',),
'immunisere': ('immunisere',),
'immuniserer': ('immunisere',),
'immuniseres': ('immunisere',),
'immunisert': ('immunisere',),
'immuniserte': ('immunisere',),
'implanter': ('implantere',),
'implantere': ('implantere',),
'implanterer': ('implantere',),
'implanteres': ('implantere',),
'implantert': ('implantere',),
'implanterte': ('implantere',),
'implementer': ('implementere',),
'implementere': ('implementere',),
'implementerer': ('implementere',),
'implementeres': ('implementere',),
'implementert': ('implementere',),
'implementerte': ('implementere',),
'impliser': ('implisere',),
'implisere': ('implisere',),
'impliserer': ('implisere',),
'impliseres': ('implisere',),
'implisert': ('implisere',),
'impliserte': ('implisere',),
'imploder': ('implodere',),
'implodere': ('implodere',),
'imploderer': ('implodere',),
'imploderes': ('implodere',),
'implodert': ('implodere',),
'imploderte': ('implodere',),
'imponer': ('imponere',),
'imponere': ('imponere',),
'imponerer': ('imponere',),
'imponeres': ('imponere',),
'imponert': ('imponere',),
'imponerte': ('imponere',),
'importer': ('importere',),
'importere': ('importere',),
'importerer': ('importere',),
'importeres': ('importere',),
'importert': ('importere',),
'importerte': ('importere',),
'impregner': ('impregnere',),
'impregnere': ('impregnere',),
'impregnerer': ('impregnere',),
'impregneres': ('impregnere',),
'impregnert': ('impregnere',),
'impregnerte': ('impregnere',),
'improviser': ('improvisere',),
'improvisere': ('improvisere',),
'improviserer': ('improvisere',),
'improviseres': ('improvisere',),
'improvisert': ('improvisere',),
'improviserte': ('improvisere',),
'imøtegikk': ('imøtegå',),
'imøtegjekk': ('imøtegå',),
'imøtegå': ('imøtegå',),
'imøtegåes': ('imøtegå',),
'imøtegår': ('imøtegå',),
'imøtegås': ('imøtegå',),
'imøtegått': ('imøtegå',),
'imøtese': ('imøtese',),
'imøtesees': ('imøtese',),
'imøteser': ('imøtese',),
'imøteses': ('imøtese',),
'imøtesett': ('imøtese',),
'imøteså': ('imøtese',),
'imøtesåg': ('imøtese',),
'inaktiver': ('inaktivere',),
'inaktivere': ('inaktivere',),
'inaktiverer': ('inaktivere',),
'inaktiveres': ('inaktivere',),
'inaktivert': ('inaktivere',),
'inaktiverte': ('inaktivere',),
'inaugurer': ('inaugurere',),
'inaugurere': ('inaugurere',),
'inaugurerer': ('inaugurere',),
'inaugureres': ('inaugurere',),
'inaugurert': ('inaugurere',),
'inaugurerte': ('inaugurere',),
'inciter': ('incitere',),
'incitere': ('incitere',),
'inciterer': ('incitere',),
'inciteres': ('incitere',),
'incitert': ('incitere',),
'inciterte': ('incitere',),
'indiker': ('indikere',),
'indikere': ('indikere',),
'indikerer': ('indikere',),
'indikeres': ('indikere',),
'indikert': ('indikere',),
'indikerte': ('indikere',),
'individualiser': ('individualisere',),
'individualisere': ('individualisere',),
'individualiserer': ('individualisere',),
'individualiseres': ('individualisere',),
'individualisert': ('individualisere',),
'individualiserte': ('individualisere',),
'indoktriner': ('indoktrinere',),
'indoktrinere': ('indoktrinere',),
'indoktrinerer': ('indoktrinere',),
'indoktrineres': ('indoktrinere',),
'indoktrinert': ('indoktrinere',),
'indoktrinerte': ('indoktrinere',),
'induser': ('indusere',),
'indusere': ('indusere',),
'induserer': ('indusere',),
'induseres': ('indusere',),
'indusert': ('indusere',),
'induserte': ('indusere',),
'industrialiser': ('industrialisere',),
'industrialisere': ('industrialisere',),
'industrialiserer': ('industrialisere',),
'industrialiseres': ('industrialisere',),
'industrialisert': ('industrialisere',),
'industrialiserte': ('industrialisere',),
'infamer': ('infamere',),
'infamere': ('infamere',),
'infamerer': ('infamere',),
'infameres': ('infamere',),
'infamert': ('infamere',),
'infamerte': ('infamere',),
'infantiliser': ('infantilisere',),
'infantilisere': ('infantilisere',),
'infantiliserer': ('infantilisere',),
'infantiliseres': ('infantilisere',),
'infantilisert': ('infantilisere',),
'infantiliserte': ('infantilisere',),
'infiltrer': ('infiltrere',),
'infiltrere': ('infiltrere',),
'infiltrerer': ('infiltrere',),
'infiltreres': ('infiltrere',),
'infiltrert': ('infiltrere',),
'infiltrerte': ('infiltrere',),
'infiser': ('infisere',),
'infisere': ('infisere',),
'infiserer': ('infisere',),
'infiseres': ('infisere',),
'infisert': ('infisere',),
'infiserte': ('infisere',),
'inflammer': ('inflammere',),
'inflammere': ('inflammere',),
'inflammerer': ('inflammere',),
'inflammeres': ('inflammere',),
'inflammert': ('inflammere',),
'inflammerte': ('inflammere',),
'inflater': ('inflatere',),
'inflatere': ('inflatere',),
'inflaterer': ('inflatere',),
'inflateres': ('inflatere',),
'inflatert': ('inflatere',),
'inflaterte': ('inflatere',),
'influer': ('influere',),
'influere': ('influere',),
'influerer': ('influere',),
'influeres': ('influere',),
'influert': ('influere',),
'influerte': ('influere',),
'informer': ('informere',),
'informere': ('informere',),
'informerer': ('informere',),
'informeres': ('informere',),
'informert': ('informere',),
'informerte': ('informere',),
'inhaler': ('inhalere',),
'inhalere': ('inhalere',),
'inhalerer': ('inhalere',),
'inhaleres': ('inhalere',),
'inhalert': ('inhalere',),
'inhalerte': ('inhalere',),
'inherer': ('inherere',),
'inherere': ('inherere',),
'inhererer': ('inherere',),
'inhereres': ('inherere',),
'inherert': ('inherere',),
'inhererte': ('inherere',),
'inhiber': ('inhibere',),
'inhibere': ('inhibere',),
'inhiberer': ('inhibere',),
'inhiberes': ('inhibere',),
'inhibert': ('inhibere',),
'inhiberte': ('inhibere',),
'initier': ('initiere',),
'initiere': ('initiere',),
'initierer': ('initiere',),
'initieres': ('initiere',),
'initiert': ('initiere',),
'initierte': ('initiere',),
'injiser': ('injisere',),
'injisere': ('injisere',),
'injiserer': ('injisere',),
'injiseres': ('injisere',),
'injisert': ('injisere',),
'injiserte': ('injisere',),
'injurier': ('injuriere',),
'injuriere': ('injuriere',),
'injurierer': ('injuriere',),
'injurieres': ('injuriere',),
'injuriert': ('injuriere',),
'injurierte': ('injuriere',),
'inkarner': ('inkarnere',),
'inkarnere': ('inkarnere',),
'inkarnerer': ('inkarnere',),
'inkarneres': ('inkarnere',),
'inkarnert': ('inkarnere',),
'inkarnerte': ('inkarnere',),
'inkliner': ('inklinere',),
'inklinere': ('inklinere',),
'inklinerer': ('inklinere',),
'inklineres': ('inklinere',),
'inklinert': ('inklinere',),
'inklinerte': ('inklinere',),
'inkluder': ('inkludere',),
'inkludere': ('inkludere',),
'inkluderer': ('inkludere',),
'inkluderes': ('inkludere',),
'inkludert': ('inkludere',),
'inkluderte': ('inkludere',),
'inkorporer': ('inkorporere',),
'inkorporere': ('inkorporere',),
'inkorporerer': ('inkorporere',),
'inkorporeres': ('inkorporere',),
'inkorporert': ('inkorporere',),
'inkorporerte': ('inkorporere',),
'innank': ('innanke',),
'innanka': ('innanke',),
'innanke': ('innanke',),
'innanker': ('innanke',),
'innankes': ('innanke',),
'innanket': ('innanke',),
'innarbeid': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidd': ('innarbeide',),
'innarbeidde': ('innarbeide',),
'innarbeide': ('innarbeide',),
'innarbeider': ('innarbeide',),
'innarbeides': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innbefatt': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefatte': ('innbefatte',),
'innbefatter': ('innbefatte',),
'innbefattes': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innberett': ('innberette',),
'innberetta': ('innberette',),
'innberette': ('innberette',),
'innberetter': ('innberette',),
'innberettes': ('innberette',),
'innberettet': ('innberette',),
'innbetal': ('innbetale',),
'innbetale': ('innbetale',),
'innbetaler': ('innbetale',),
'innbetales': ('innbetale',),
'innbetalt': ('innbetale',),
'innbetalte': ('innbetale',),
'innbill': ('innbille',),
'innbille': ('innbille',),
'innbiller': ('innbille',),
'innbilles': ('innbille',),
'innbilt': ('innbille',),
'innbilte': ('innbille',),
'innbandt': ('innbinde',),
'innbind': ('innbinde',),
'innbinde': ('innbinde',),
'innbinder': ('innbinde',),
'innbindes': ('innbinde',),
'innbundet': ('innbinde',),
'innbland': ('innblande',),
'innblanda': ('innblande',),
'innblande': ('innblande',),
'innblander': ('innblande',),
'innblandes': ('innblande',),
'innblandet': ('innblande',),
'innbragt': ('innbringe',),
'innbragte': ('innbringe',),
'innbrakt': ('innbringe',),
'innbrakte': ('innbringe',),
'innbring': ('innbringe',),
'innbringe': ('innbringe',),
'innbringer': ('innbringe',),
'innbringes': ('innbringe',),
'innbaud': ('innby',),
'innbudt': ('innby',),
'innby': ('innby',),
'innbydd': ('innby',),
'innbydde': ('innby',),
'innbyr': ('innby',),
'innbys': ('innby',),
'innbød': ('innby',),
'innbøy': ('innby',),
'inndamp': ('inndampe',),
'inndampa': ('inndampe',),
'inndampe': ('inndampe',),
'inndamper': ('inndampe',),
'inndampes': ('inndampe',),
'inndampet': ('inndampe',),
'inndel': ('inndele',),
'inndele': ('inndele',),
'inndeler': ('inndele',),
'inndeles': ('inndele',),
'inndelt': ('inndele',),
'inndelte': ('inndele',),
'inndra': ('inndra',),
'inndradd': ('inndra',),
'inndrar': ('inndra',),
'inndras': ('inndra',),
'inndratt': ('inndra',),
'inndro': ('inndra',),
'inndrog': ('inndra',),
'inndreiv': ('inndrive',),
'inndrev': ('inndrive',),
'inndrevet': ('inndrive',),
'inndriv': ('inndrive',),
'inndrive': ('inndrive',),
'inndriver': ('inndrive',),
'inndrives': ('inndrive',),
'innebar': ('innebære',),
'innebåret': ('innebære',),
'innebær': ('innebære',),
'innebære': ('innebære',),
'innebærer': ('innebære',),
'innebæres': ('innebære',),
'inneha': ('inneha',),
'innehadde': ('inneha',),
'innehaes': ('inneha',),
'innehar': ('inneha',),
'innehas': ('inneha',),
'innehatt': ('inneha',),
'innehold': ('inneholde',),
'inneholde': ('inneholde',),
'inneholder': ('inneholde',),
'inneholdes': ('inneholde',),
'inneholdt': ('inneholde',),
'innekserser': ('inneksersere',),
'inneksersere': ('inneksersere',),
'innekserserer': ('inneksersere',),
'innekserseres': ('inneksersere',),
'inneksersert': ('inneksersere',),
'innekserserte': ('inneksersere',),
'innfatt': ('innfatte',),
'innfatta': ('innfatte',),
'innfatte': ('innfatte',),
'innfatter': ('innfatte',),
'innfattes': ('innfatte',),
'innfattet': ('innfatte',),
'innfell': ('innfelle',),
'innfelle': ('innfelle',),
'innfeller': ('innfelle',),
'innfelles': ('innfelle',),
'innfelt': ('innfelle',),
'innfelte': ('innfelle',),
'innfiltr': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltre': ('innfiltre',),
'innfiltrer': ('innfiltre',),
'innfiltres': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfann': ('innfinne',),
'innfant': ('innfinne',),
'innfinn': ('innfinne',),
'innfinne': ('innfinne',),
'innfinner': ('innfinne',),
'innfinnes': ('innfinne',),
'innfunnet': ('innfinne',),
'innforliv': ('innforlive',),
'innforliva': ('innforlive',),
'innforlive': ('innforlive',),
'innforliver': ('innforlive',),
'innforlives': ('innforlive',),
'innforlivet': ('innforlive',),
'innfri': ('innfri',),
'innfridd': ('innfri',),
'innfridde': ('innfri',),
'innfrir': ('innfri',),
'innfris': ('innfri',),
'innfør': ('innføre',),
'innføre': ('innføre',),
'innfører': ('innføre',),
'innføres': ('innføre',),
'innført': ('innføre',),
'innførte': ('innføre',),
'innføy': ('innføye',),
'innføya': ('innføye',),
'innføyd': ('innføye',),
'innføydd': ('innføye',),
'innføydde': ('innføye',),
'innføyde': ('innføye',),
'innføye': ('innføye',),
'innføyer': ('innføye',),
'innføyes': ('innføye',),
'innføyet': ('innføye',),
'innga': ('inngi',),
'inngav': ('inngi',),
'inngi': ('inngi',),
'inngies': ('inngi',),
'inngir': ('inngi',),
'inngis': ('inngi',),
'inngitt': ('inngi',),
'inngift': ('inngifte',),
'inngifta': ('inngifte',),
'inngifte': ('inngifte',),
'inngifter': ('inngifte',),
'inngiftes': ('inngifte',),
'inngiftet': ('inngifte',),
'inngjerd': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerde': ('inngjerde',),
'inngjerder': ('inngjerde',),
'inngjerdes': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngraver': ('inngravere',),
'inngravere': ('inngravere',),
'inngraverer': ('inngravere',),
'inngraveres': ('inngravere',),
'inngravert': ('inngravere',),
'inngraverte': ('inngravere',),
'inngjøt': ('inngyte',),
'inngyt': ('inngyte',),
'inngyte': ('inngyte',),
'inngyter': ('inngyte',),
'inngytes': ('inngyte',),
'inngytt': ('inngyte',),
'inngytte': ('inngyte',),
'inngikk': ('inngå',),
'inngjekk': ('inngå',),
'inngå': ('inngå',),
'inngåes': ('inngå',),
'inngår': ('inngå',),
'inngås': ('inngå',),
'inngått': ('inngå',),
'innhegn': ('innhegne',),
'innhegna': ('innhegne',),
'innhegne': ('innhegne',),
'innhegner': ('innhegne',),
'innhegnes': ('innhegne',),
'innhegnet': ('innhegne',),
'innhent': ('innhente',),
'innhenta': ('innhente',),
'innhente': ('innhente',),
'innhenter': ('innhente',),
'innhentes': ('innhente',),
'innhentet': ('innhente',),
'innhyll': ('innhylle',),
'innhylla': ('innhylle',),
'innhylle': ('innhylle',),
'innhyller': ('innhylle',),
'innhylles': ('innhylle',),
'innhyllet': ('innhylle',),
'innhøst': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøste': ('innhøste',),
'innhøster': ('innhøste',),
'innhøstes': ('innhøste',),
'innhøstet': ('innhøste',),
'innkalkuler': ('innkalkulere',),
'innkalkulere': ('innkalkulere',),
'innkalkulerer': ('innkalkulere',),
'innkalkuleres': ('innkalkulere',),
'innkalkulert': ('innkalkulere',),
'innkalkulerte': ('innkalkulere',),
'innkall': ('innkalle',),
'innkalle': ('innkalle',),
'innkaller': ('innkalle',),
'innkalles': ('innkalle',),
'innkalt': ('innkalle',),
'innkalte': ('innkalle',),
'innkapsl': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapsle': ('innkapsle',),
'innkapsler': ('innkapsle',),
'innkapsles': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkasser': ('innkassere',),
'innkassere': ('innkassere',),
'innkasserer': ('innkassere',),
'innkasseres': ('innkassere',),
'innkassert': ('innkassere',),
'innkasserte': ('innkassere',),
'innkast': ('innkaste',),
'innkasta': ('innkaste',),
'innkaste': ('innkaste',),
'innkaster': ('innkaste',),
'innkastes': ('innkaste',),
'innkastet': ('innkaste',),
'innkjør': ('innkjøre',),
'innkjøre': ('innkjøre',),
'innkjører': ('innkjøre',),
'innkjøres': ('innkjøre',),
'innkjørt': ('innkjøre',),
'innkjørte': ('innkjøre',),
'innklag': ('innklage',),
'innklaga': ('innklage',),
'innklagd': ('innklage',),
'innklagde': ('innklage',),
'innklage': ('innklage',),
'innklager': ('innklage',),
'innklages': ('innklage',),
'innklaget': ('innklage',),
'innklarer': ('innklarere',),
'innklarere': ('innklarere',),
'innklarerer': ('innklarere',),
'innklareres': ('innklarere',),
'innklarert': ('innklarere',),
'innklarerte': ('innklarere',),
'innkobl': ('innkoble',),
'innkobla': ('innkoble',),
'innkoble': ('innkoble',),
'innkobler': ('innkoble',),
'innkobles': ('innkoble',),
'innkoblet': ('innkoble',),
'innkommander': ('innkommandere',),
'innkommandere': ('innkommandere',),
'innkommanderer': ('innkommandere',),
'innkommanderes': ('innkommandere',),
'innkommandert': ('innkommandere',),
'innkommanderte': ('innkommandere',),
'innkom': ('innkomme',),
'innkomme': ('innkomme',),
'innkommer': ('innkomme',),
'innkommes': ('innkomme',),
'innkommet': ('innkomme',),
'innkopl': ('innkople',),
'innkopla': ('innkople',),
'innkople': ('innkople',),
'innkopler': ('innkople',),
'innkoples': ('innkople',),
'innkoplet': ('innkople',),
'innkort': ('innkorte',),
'innkorta': ('innkorte',),
'innkorte': ('innkorte',),
'innkorter': ('innkorte',),
'innkortes': ('innkorte',),
'innkortet': ('innkorte',),
'innkrev': ('innkreve',),
'innkreva': ('innkreve',),
'innkrevd': ('innkreve',),
'innkrevde': ('innkreve',),
'innkreve': ('innkreve',),
'innkrever': ('innkreve',),
'innkreves': ('innkreve',),
'innkrevet': ('innkreve',),
'innkvarter': ('innkvartere',),
'innkvartere': ('innkvartere',),
'innkvarterer': ('innkvartere',),
'innkvarteres': ('innkvartere',),
'innkvartert': ('innkvartere',),
'innkvarterte': ('innkvartere',),
'innlat': ('innlate',),
'innlate': ('innlate',),
'innlater': ('innlate',),
'innlates': ('innlate',),
'innlatt': ('innlate',),
'innlot': ('innlate',),
'innled': ('innlede',),
'innleda': ('innlede',),
'innlede': ('innlede',),
'innleder': ('innlede',),
'innledes': ('innlede',),
'innledet': ('innlede',),
'innla': ('innlegge',),
'innlagt': ('innlegge',),
'innlegg': ('innlegge',),
'innlegge': ('innlegge',),
'innlegger': ('innlegge',),
'innlegges': ('innlegge',),
'innlei': ('innleie',),
'innleid': ('innleie',),
'innleide': ('innleie',),
'innleie': ('innleie',),
'innleier': ('innleie',),
'innleies': ('innleie',),
'innleiet': ('innleie',),
'innlem': ('innlemme',),
'innlemma': ('innlemme',),
'innlemme': ('innlemme',),
'innlemmer': ('innlemme',),
'innlemmes': ('innlemme',),
'innlemmet': ('innlemme',),
'innles': ('innlese',),
'innlese': ('innlese',),
'innleser': ('innlese',),
'innleses': ('innlese',),
'innlest': ('innlese',),
'innleste': ('innlese',),
'innlever': ('innlevere',),
'innlevere': ('innlevere',),
'innleverer': ('innlevere',),
'innleveres': ('innlevere',),
'innlevert': ('innlevere',),
'innleverte': ('innlevere',),
'innlosjer': ('innlosjere',),
'innlosjere': ('innlosjere',),
'innlosjerer': ('innlosjere',),
'innlosjeres': ('innlosjere',),
'innlosjert': ('innlosjere',),
'innlosjerte': ('innlosjere',),
'innlån': ('innlåne',),
'innlåne': ('innlåne',),
'innlåner': ('innlåne',),
'innlånes': ('innlåne',),
'innlånt': ('innlåne',),
'innlånte': ('innlåne',),
'innløp': ('innløpe',),
'innløpe': ('innløpe',),
'innløper': ('innløpe',),
'innløpes': ('innløpe',),
'innløpet': ('innløpe',),
'innløpt': ('innløpe',),
'innløs': ('innløse',),
'innløse': ('innløse',),
'innløser': ('innløse',),
'innløses': ('innløse',),
'innløst': ('innløse',),
'innløste': ('innløse',),
'innløys': ('innløyse',),
'innløyse': ('innløyse',),
'innløyser': ('innløyse',),
'innløyses': ('innløyse',),
'innløyst': ('innløyse',),
'innløyste': ('innløyse',),
'innmur': ('innmure',),
'innmura': ('innmure',),
'innmure': ('innmure',),
'innmurer': ('innmure',),
'innmures': ('innmure',),
'innmuret': ('innmure',),
'innmurt': ('innmure',),
'innmurte': ('innmure',),
'innordn': ('innordne',),
'innordna': ('innordne',),
'innordne': ('innordne',),
'innordner': ('innordne',),
'innordnes': ('innordne',),
'innordnet': ('innordne',),
'innover': ('innovere',),
'innovere': ('innovere',),
'innoverer': ('innovere',),
'innoveres': ('innovere',),
'innovert': ('innovere',),
'innoverte': ('innovere',),
'innpakk': ('innpakke',),
'innpakka': ('innpakke',),
'innpakke': ('innpakke',),
'innpakker': ('innpakke',),
'innpakkes': ('innpakke',),
'innpakket': ('innpakke',),
'innpass': ('innpasse',),
'innpassa': ('innpasse',),
'innpasse': ('innpasse',),
'innpasser': ('innpasse',),
'innpasses': ('innpasse',),
'innpasset': ('innpasse',),
'innpasser': ('innpassere',),
'innpassere': ('innpassere',),
'innpasserer': ('innpassere',),
'innpasseres': ('innpassere',),
'innpassert': ('innpassere',),
'innpasserte': ('innpassere',),
'innpisk': ('innpiske',),
'innpiska': ('innpiske',),
'innpiske': ('innpiske',),
'innpisker': ('innpiske',),
'innpiskes': ('innpiske',),
'innpisket': ('innpiske',),
'innplant': ('innplante',),
'innplanta': ('innplante',),
'innplante': ('innplante',),
'innplanter': ('innplante',),
'innplantes': ('innplante',),
'innplantet': ('innplante',),
'innpod': ('innpode',),
'innpoda': ('innpode',),
'innpode': ('innpode',),
'innpoder': ('innpode',),
'innpodes': ('innpode',),
'innpodet': ('innpode',),
'innpot': ('innpote',),
'innpota': ('innpote',),
'innpote': ('innpote',),
'innpoter': ('innpote',),
'innpotes': ('innpote',),
'innpotet': ('innpote',),
'innprent': ('innprente',),
'innprenta': ('innprente',),
'innprente': ('innprente',),
'innprenter': ('innprente',),
'innprentes': ('innprente',),
'innprentet': ('innprente',),
'innram': ('innramme',),
'innramma': ('innramme',),
'innramme': ('innramme',),
'innrammer': ('innramme',),
'innrammes': ('innramme',),
'innrammet': ('innramme',),
'innrapporter': ('innrapportere',),
'innrapportere': ('innrapportere',),
'innrapporterer': ('innrapportere',),
'innrapporteres': ('innrapportere',),
'innrapportert': ('innrapportere',),
'innrapporterte': ('innrapportere',),
'innred': ('innrede',),
'innreda': ('innrede',),
'innrede': ('innrede',),
'innreder': ('innrede',),
'innredes': ('innrede',),
'innredet': ('innrede',),
'innrei': ('innreie',),
'innreid': ('innreie',),
'innreidd': ('innreie',),
'innreidde': ('innreie',),
'innreide': ('innreie',),
'innreie': ('innreie',),
'innreier': ('innreie',),
'innreies': ('innreie',),
'innrett': ('innrette',),
'innretta': ('innrette',),
'innrette': ('innrette',),
'innretter': ('innrette',),
'innrettes': ('innrette',),
'innrettet': ('innrette',),
'innring': ('innringe',),
'innringa': ('innringe',),
'innringe': ('innringe',),
'innringer': ('innringe',),
'innringes': ('innringe',),
'innringet': ('innringe',),
'innruller': ('innrullere',),
'innrullere': ('innrullere',),
'innrullerer': ('innrullere',),
'innrulleres': ('innrullere',),
'innrullert': ('innrullere',),
'innrullerte': ('innrullere',),
'innrykk': ('innrykke',),
'innrykka': ('innrykke',),
'innrykke': ('innrykke',),
'innrykker': ('innrykke',),
'innrykkes': ('innrykke',),
'innrykket': ('innrykke',),
'innrykt': ('innrykke',),
'innrykte': ('innrykke',),
'innrøm': ('innrømme',),
'innrømma': ('innrømme',),
'innrømme': ('innrømme',),
'innrømmer': ('innrømme',),
'innrømmes': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømt': ('innrømme',),
'innrømte': ('innrømme',),
'innsaml': ('innsamle',),
'innsamla': ('innsamle',),
'innsamle': ('innsamle',),
'innsamler': ('innsamle',),
'innsamles': ('innsamle',),
'innsamlet': ('innsamle',),
'innse': ('innse',),
'innsees': ('innse',),
'innser': ('innse',),
'innses': ('innse',),
'innsett': ('innse',),
'innså': ('innse',),
'innsåg': ('innse',),
'innsegl': ('innsegle',),
'innsegla': ('innsegle',),
'innsegle': ('innsegle',),
'innsegler': ('innsegle',),
'innsegles': ('innsegle',),
'innseglet': ('innsegle',),
'innseil': ('innseile',),
'innseile': ('innseile',),
'innseiler': ('innseile',),
'innseiles': ('innseile',),
'innseilt': ('innseile',),
'innseilte': ('innseile',),
'innsend': ('innsende',),
'innsende': ('innsende',),
'innsender': ('innsende',),
'innsendes': ('innsende',),
'innsendt': ('innsende',),
'innsendte': ('innsende',),
'innsatt': ('innsette',),
'innsatte': ('innsette',),
'innsett': ('innsette',),
'innsette': ('innsette',),
'innsetter': ('innsette',),
'innsettes': ('innsette',),
'innsikt': ('innsikte',),
'innsikta': ('innsikte',),
'innsikte': ('innsikte',),
'innsikter': ('innsikte',),
'innsiktes': ('innsikte',),
'innsiktet': ('innsikte',),
'innsirkl': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirkle': ('innsirkle',),
'innsirkler': ('innsirkle',),
'innsirkles': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innskip': ('innskipe',),
'innskipa': ('innskipe',),
'innskipe': ('innskipe',),
'innskiper': ('innskipe',),
'innskipes': ('innskipe',),
'innskipet': ('innskipe',),
'innskjerp': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpe': ('innskjerpe',),
'innskjerper': ('innskjerpe',),
'innskjerpes': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskar': ('innskjære',),
'innskjær': ('innskjære',),
'innskjære': ('innskjære',),
'innskjærer': ('innskjære',),
'innskjæres': ('innskjære',),
'innskåret': ('innskjære',),
'innskrenk': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenke': ('innskrenke',),
'innskrenker': ('innskrenke',),
'innskrenkes': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskreiv': ('innskrive',),
'innskrev': ('innskrive',),
'innskrevet': ('innskrive',),
'innskriv': ('innskrive',),
'innskrive': ('innskrive',),
'innskriver': ('innskrive',),
'innskrives': ('innskrive',),
'innskaut': ('innskyte',),
'innskjøt': ('innskyte',),
'innskutt': ('innskyte',),
'innskyt': ('innskyte',),
'innskyte': ('innskyte',),
'innskyter': ('innskyte',),
'innskytes': ('innskyte',),
'innskøyt': ('innskyte',),
'innsmigr': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigre': ('innsmigre',),
'innsmigrer': ('innsmigre',),
'innsmigres': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmugl': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmugle': ('innsmugle',),
'innsmugler': ('innsmugle',),
'innsmugles': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmurt': ('innsmøre',),
'innsmurte': ('innsmøre',),
'innsmør': ('innsmøre',),
'innsmøre': ('innsmøre',),
'innsmører': ('innsmøre',),
'innsmøres': ('innsmøre',),
'innsnevr': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevre': ('innsnevre',),
'innsnevrer': ('innsnevre',),
'innsnevres': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsprøyt': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøyte': ('innsprøyte',),
'innsprøyter': ('innsprøyte',),
'innsprøytes': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innstevn': ('innstevne',),
'innstevna': ('innstevne',),
'innstevne': ('innstevne',),
'innstevner': ('innstevne',),
'innstevnes': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevnte': ('innstevne',),
'innstevn': ('innstevne',),
'innstevna': ('innstevne',),
'innstevne': ('innstevne',),
'innstevner': ('innstevne',),
'innstevnes': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevnte': ('innstevne',),
'innstift': ('innstifte',),
'innstifta': ('innstifte',),
'innstifte': ('innstifte',),
'innstifter': ('innstifte',),
'innstiftes': ('innstifte',),
'innstiftet': ('innstifte',),
'innstill': ('innstille',),
'innstille': ('innstille',),
'innstiller': ('innstille',),
'innstilles': ('innstille',),
'innstilt': ('innstille',),
'innstilte': ('innstille',),
'innstram': ('innstramme',),
'innstramma': ('innstramme',),
'innstramme': ('innstramme',),
'innstrammer': ('innstramme',),
'innstrammes': ('innstramme',),
'innstrammet': ('innstramme',),
'innstuder': ('innstudere',),
'innstudere': ('innstudere',),
'innstuderer': ('innstudere',),
'innstuderes': ('innstudere',),
'innstudert': ('innstudere',),
'innstuderte': ('innstudere',),
'innstøp': ('innstøpe',),
'innstøpe': ('innstøpe',),
'innstøper': ('innstøpe',),
'innstøpes': ('innstøpe',),
'innstøpt': ('innstøpe',),
'innstøpte': ('innstøpe',),
'innstøyp': ('innstøype',),
'innstøype': ('innstøype',),
'innstøyper': ('innstøype',),
'innstøypes': ('innstøype',),
'innstøypt': ('innstøype',),
'innstøypte': ('innstøype',),
'innsug': ('innsuge',),
'innsuga': ('innsuge',),
'innsugd': ('innsuge',),
'innsugde': ('innsuge',),
'innsuge': ('innsuge',),
'innsuger': ('innsuge',),
'innsuges': ('innsuge',),
'innsuget': ('innsuge',),
'innsang': ('innsynge',),
'innsunget': ('innsynge',),
'innsyng': ('innsynge',),
'innsynge': ('innsynge',),
'innsynger': ('innsynge',),
'innsynges': ('innsynge',),
'innta': ('innta',),
'inntaes': ('innta',),
'inntar': ('innta',),
'inntas': ('innta',),
'inntatt': ('innta',),
'inntok': ('innta',),
'inntast': ('inntaste',),
'inntasta': ('inntaste',),
'inntaste': ('inntaste',),
'inntaster': ('inntaste',),
'inntastes': ('inntaste',),
'inntastet': ('inntaste',),
'inntegn': ('inntegne',),
'inntegna': ('inntegne',),
'inntegne': ('inntegne',),
'inntegner': ('inntegne',),
'inntegnes': ('inntegne',),
'inntegnet': ('inntegne',),
'inntre': ('inntre',),
'inntrer': ('inntre',),
'inntres': ('inntre',),
'inntrådt': ('inntre',),
'inntrådte': ('inntre',),
'inntraff': ('inntreffe',),
'inntreff': ('inntreffe',),
'inntreffe': ('inntreffe',),
'inntreffer': ('inntreffe',),
'inntreffes': ('inntreffe',),
'inntruffet': ('inntreffe',),
'innvandr': ('innvandre',),
'innvandra': ('innvandre',),
'innvandre': ('innvandre',),
'innvandrer': ('innvandre',),
'innvandres': ('innvandre',),
'innvandret': ('innvandre',),
'innvarsl': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarsle': ('innvarsle',),
'innvarsler': ('innvarsle',),
'innvarsles': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvei': ('innveie',),
'innveid': ('innveie',),
'innveide': ('innveie',),
'innveie': ('innveie',),
'innveier': ('innveie',),
'innveies': ('innveie',),
'innveiet': ('innveie',),
'innvalgt': ('innvelge',),
'innvalgte': ('innvelge',),
'innvelg': ('innvelge',),
'innvelge': ('innvelge',),
'innvelger': ('innvelge',),
'innvelges': ('innvelge',),
'innvend': ('innvende',),
'innvende': ('innvende',),
'innvender': ('innvende',),
'innvendes': ('innvende',),
'innvendt': ('innvende',),
'innvendte': ('innvende',),
'innvi': ('innvie',),
'innvia': ('innvie',),
'innvidd': ('innvie',),
'innvidde': ('innvie',),
'innvie': ('innvie',),
'innvier': ('innvie',),
'innvies': ('innvie',),
'innviet': ('innvie',),
'innvigd': ('innvie',),
'innvigde': ('innvie',),
'innvikl': ('innvikle',),
'innvikla': ('innvikle',),
'innvikle': ('innvikle',),
'innvikler': ('innvikle',),
'innvikles': ('innvikle',),
'innviklet': ('innvikle',),
'innvilg': ('innvilge',),
'innvilga': ('innvilge',),
'innvilge': ('innvilge',),
'innvilger': ('innvilge',),
'innvilges': ('innvilge',),
'innvilget': ('innvilge',),
'innvann': ('innvinne',),
'innvant': ('innvinne',),
'innvinn': ('innvinne',),
'innvinne': ('innvinne',),
'innvinner': ('innvinne',),
'innvinnes': ('innvinne',),
'innvunnet': ('innvinne',),
'innvirk': ('innvirke',),
'innvirka': ('innvirke',),
'innvirke': ('innvirke',),
'innvirker': ('innvirke',),
'innvirkes': ('innvirke',),
'innvirket': ('innvirke',),
'innvoter': ('innvotere',),
'innvotere': ('innvotere',),
'innvoterer': ('innvotere',),
'innvoteres': ('innvotere',),
'innvotert': ('innvotere',),
'innvoterte': ('innvotere',),
'innynd': ('innynde',),
'innynda': ('innynde',),
'innynde': ('innynde',),
'innynder': ('innynde',),
'innyndes': ('innynde',),
'innyndet': ('innynde',),
'innånd': ('innånde',),
'innånda': ('innånde',),
'innånde': ('innånde',),
'innånder': ('innånde',),
'innåndes': ('innånde',),
'innåndet': ('innånde',),
'innøv': ('innøve',),
'innøva': ('innøve',),
'innøvd': ('innøve',),
'innøvde': ('innøve',),
'innøve': ('innøve',),
'innøver': ('innøve',),
'innøves': ('innøve',),
'innøvet': ('innøve',),
'inokuler': ('inokulere',),
'inokulere': ('inokulere',),
'inokulerer': ('inokulere',),
'inokuleres': ('inokulere',),
'inokulert': ('inokulere',),
'inokulerte': ('inokulere',),
'inseminer': ('inseminere',),
'inseminere': ('inseminere',),
'inseminerer': ('inseminere',),
'insemineres': ('inseminere',),
'inseminert': ('inseminere',),
'inseminerte': ('inseminere',),
'insinuer': ('insinuere',),
'insinuere': ('insinuere',),
'insinuerer': ('insinuere',),
'insinueres': ('insinuere',),
'insinuert': ('insinuere',),
'insinuerte': ('insinuere',),
'insister': ('insistere',),
'insistere': ('insistere',),
'insisterer': ('insistere',),
'insisteres': ('insistere',),
'insistert': ('insistere',),
'insisterte': ('insistere',),
'inspirer': ('inspirere',),
'inspirere': ('inspirere',),
'inspirerer': ('inspirere',),
'inspireres': ('inspirere',),
'inspirert': ('inspirere',),
'inspirerte': ('inspirere',),
'inspiser': ('inspisere',),
'inspisere': ('inspisere',),
'inspiserer': ('inspisere',),
'inspiseres': ('inspisere',),
'inspisert': ('inspisere',),
'inspiserte': ('inspisere',),
'installer': ('installere',),
'installere': ('installere',),
'installerer': ('installere',),
'installeres': ('installere',),
'installert': ('installere',),
'installerte': ('installere',),
'instituer': ('instituere',),
'instituere': ('instituere',),
'instituerer': ('instituere',),
'institueres': ('instituere',),
'instituert': ('instituere',),
'instituerte': ('instituere',),
'institusjonaliser': ('institusjonalisere',),
'institusjonalisere': ('institusjonalisere',),
'institusjonaliserer': ('institusjonalisere',),
'institusjonaliseres': ('institusjonalisere',),
'institusjonalisert': ('institusjonalisere',),
'institusjonaliserte': ('institusjonalisere',),
'instruer': ('instruere',),
'instruere': ('instruere',),
'instruerer': ('instruere',),
'instrueres': ('instruere',),
'instruert': ('instruere',),
'instruerte': ('instruere',),
'instrumenter': ('instrumentere',),
'instrumentere': ('instrumentere',),
'instrumenterer': ('instrumentere',),
'instrumenteres': ('instrumentere',),
'instrumentert': ('instrumentere',),
'instrumenterte': ('instrumentere',),
'integrer': ('integrere',),
'integrere': ('integrere',),
'integrerer': ('integrere',),
'integreres': ('integrere',),
'integrert': ('integrere',),
'integrerte': ('integrere',),
'intellektualiser': ('intellektualisere',),
'intellektualisere': ('intellektualisere',),
'intellektualiserer': ('intellektualisere',),
'intellektualiseres': ('intellektualisere',),
'intellektualisert': ('intellektualisere',),
'intellektualiserte': ('intellektualisere',),
'intender': ('intendere',),
'intendere': ('intendere',),
'intenderer': ('intendere',),
'intenderes': ('intendere',),
'intendert': ('intendere',),
'intenderte': ('intendere',),
'intensiver': ('intensivere',),
'intensivere': ('intensivere',),
'intensiverer': ('intensivere',),
'intensiveres': ('intensivere',),
'intensivert': ('intensivere',),
'intensiverte': ('intensivere',),
'interesser': ('interessere',),
'interessere': ('interessere',),
'interesserer': ('interessere',),
'interesseres': ('interessere',),
'interessert': ('interessere',),
'interesserte': ('interessere',),
'interferer': ('interferere',),
'interferere': ('interferere',),
'interfererer': ('interferere',),
'interfereres': ('interferere',),
'interferert': ('interferere',),
'interfererte': ('interferere',),
'interfolier': ('interfoliere',),
'interfoliere': ('interfoliere',),
'interfolierer': ('interfoliere',),
'interfolieres': ('interfoliere',),
'interfoliert': ('interfoliere',),
'interfolierte': ('interfoliere',),
'internasjonaliser': ('internasjonalisere',),
'internasjonalisere': ('internasjonalisere',),
'internasjonaliserer': ('internasjonalisere',),
'internasjonaliseres': ('internasjonalisere',),
'internasjonalisert': ('internasjonalisere',),
'internasjonaliserte': ('internasjonalisere',),
'interner': ('internere',),
'internere': ('internere',),
'internerer': ('internere',),
'interneres': ('internere',),
'internert': ('internere',),
'internerte': ('internere',),
'interpeller': ('interpellere',),
'interpellere': ('interpellere',),
'interpellerer': ('interpellere',),
'interpelleres': ('interpellere',),
'interpellert': ('interpellere',),
'interpellerte': ('interpellere',),
'interpoler': ('interpolere',),
'interpolere': ('interpolere',),
'interpolerer': ('interpolere',),
'interpoleres': ('interpolere',),
'interpolert': ('interpolere',),
'interpolerte': ('interpolere',),
'interpreter': ('interpretere',),
'interpretere': ('interpretere',),
'interpreterer': ('interpretere',),
'interpreteres': ('interpretere',),
'interpretert': ('interpretere',),
'interpreterte': ('interpretere',),
'intervener': ('intervenere',),
'intervenere': ('intervenere',),
'intervenerer': ('intervenere',),
'interveneres': ('intervenere',),
'intervenert': ('intervenere',),
'intervenerte': ('intervenere',),
'intervju': ('intervjue',),
'intervjua': ('intervjue',),
'intervjue': ('intervjue',),
'intervjuer': ('intervjue',),
'intervjues': ('intervjue',),
'intervjuet': ('intervjue',),
'intimider': ('intimidere',),
'intimidere': ('intimidere',),
'intimiderer': ('intimidere',),
'intimideres': ('intimidere',),
'intimidert': ('intimidere',),
'intimiderte': ('intimidere',),
'intoner': ('intonere',),
'intonere': ('intonere',),
'intonerer': ('intonere',),
'intoneres': ('intonere',),
'intonert': ('intonere',),
'intonerte': ('intonere',),
'intriger': ('intrigere',),
'intrigere': ('intrigere',),
'intrigerer': ('intrigere',),
'intrigeres': ('intrigere',),
'intrigert': ('intrigere',),
'intrigerte': ('intrigere',),
'introduser': ('introdusere',),
'introdusere': ('introdusere',),
'introduserer': ('introdusere',),
'introduseres': ('introdusere',),
'introdusert': ('introdusere',),
'introduserte': ('introdusere',),
'invader': ('invadere',),
'invadere': ('invadere',),
'invaderer': ('invadere',),
'invaderes': ('invadere',),
'invadert': ('invadere',),
'invaderte': ('invadere',),
'invalidiser': ('invalidisere',),
'invalidisere': ('invalidisere',),
'invalidiserer': ('invalidisere',),
'invalidiseres': ('invalidisere',),
'invalidisert': ('invalidisere',),
'invalidiserte': ('invalidisere',),
'inventer': ('inventere',),
'inventere': ('inventere',),
'inventerer': ('inventere',),
'inventeres': ('inventere',),
'inventert': ('inventere',),
'inventerte': ('inventere',),
'inverter': ('invertere',),
'invertere': ('invertere',),
'inverterer': ('invertere',),
'inverteres': ('invertere',),
'invertert': ('invertere',),
'inverterte': ('invertere',),
'invester': ('investere',),
'investere': ('investere',),
'investerer': ('investere',),
'investeres': ('investere',),
'investert': ('investere',),
'investerte': ('investere',),
'inviter': ('invitere',),
'invitere': ('invitere',),
'inviterer': ('invitere',),
'inviteres': ('invitere',),
'invitert': ('invitere',),
'inviterte': ('invitere',),
'involver': ('involvere',),
'involvere': ('involvere',),
'involverer': ('involvere',),
'involveres': ('involvere',),
'involvert': ('involvere',),
'involverte': ('involvere',),
'ioniser': ('ionisere',),
'ionisere': ('ionisere',),
'ioniserer': ('ionisere',),
'ioniseres': ('ionisere',),
'ionisert': ('ionisere',),
'ioniserte': ('ionisere',),
'irettesatt': ('irettesette',),
'irettesatte': ('irettesette',),
'irettesett': ('irettesette',),
'irettesette': ('irettesette',),
'irettesetter': ('irettesette',),
'irettesettes': ('irettesette',),
'iriser': ('irisere',),
'irisere': ('irisere',),
'iriserer': ('irisere',),
'iriseres': ('irisere',),
'irisert': ('irisere',),
'iriserte': ('irisere',),
'ironiser': ('ironisere',),
'ironisere': ('ironisere',),
'ironiserer': ('ironisere',),
'ironiseres': ('ironisere',),
'ironisert': ('ironisere',),
'ironiserte': ('ironisere',),
'irr': ('irre',),
'irra': ('irre',),
'irre': ('irre',),
'irrer': ('irre',),
'irres': ('irre',),
'irret': ('irre',),
'irr': ('irre',),
'irra': ('irre',),
'irre': ('irre',),
'irrer': ('irre',),
'irres': ('irre',),
'irret': ('irre',),
'irriger': ('irrigere',),
'irrigere': ('irrigere',),
'irrigerer': ('irrigere',),
'irrigeres': ('irrigere',),
'irrigert': ('irrigere',),
'irrigerte': ('irrigere',),
'irriter': ('irritere',),
'irritere': ('irritere',),
'irriterer': ('irritere',),
'irriteres': ('irritere',),
'irritert': ('irritere',),
'irriterte': ('irritere',),
'iscenesatt': ('iscenesette',),
'iscenesatte': ('iscenesette',),
'iscenesett': ('iscenesette',),
'iscenesette': ('iscenesette',),
'iscenesetter': ('iscenesette',),
'iscenesettes': ('iscenesette',),
'is': ('ise',),
'isa': ('ise',),
'ise': ('ise',),
'iser': ('ise',),
'ises': ('ise',),
'iset': ('ise',),
'ist': ('ise',),
'iste': ('ise',),
'islamiser': ('islamisere',),
'islamisere': ('islamisere',),
'islamiserer': ('islamisere',),
'islamiseres': ('islamisere',),
'islamisert': ('islamisere',),
'islamiserte': ('islamisere',),
'isn': ('isne',),
'isna': ('isne',),
'isne': ('isne',),
'isner': ('isne',),
'isnes': ('isne',),
'isnet': ('isne',),
'isoler': ('isolere',),
'isolere': ('isolere',),
'isolerer': ('isolere',),
'isoleres': ('isolere',),
'isolert': ('isolere',),
'isolerte': ('isolere',),
'ispe': ('ispe',),
'ispedd': ('ispe',),
'ispedde': ('ispe',),
'isper': ('ispe',),
'ispes': ('ispe',),
'istem': ('istemme',),
'istemme': ('istemme',),
'istemmer': ('istemme',),
'istemmes': ('istemme',),
'istemt': ('istemme',),
'istemte': ('istemme',),
'iterer': ('iterere',),
'iterere': ('iterere',),
'itererer': ('iterere',),
'itereres': ('iterere',),
'iterert': ('iterere',),
'itererte': ('iterere',),
'ivareta': ('ivareta',),
'ivaretaes': ('ivareta',),
'ivaretar': ('ivareta',),
'ivaretas': ('ivareta',),
'ivaretatt': ('ivareta',),
'ivaretok': ('ivareta',),
'iverksatt': ('iverksette',),
'iverksatte': ('iverksette',),
'iverksett': ('iverksette',),
'iverksette': ('iverksette',),
'iverksetter': ('iverksette',),
'iverksettes': ('iverksette',),
'ivr': ('ivre',),
'ivra': ('ivre',),
'ivre': ('ivre',),
'ivrer': ('ivre',),
'ivres': ('ivre',),
'ivret': ('ivre',),
'jabb': ('jabbe',),
'jabba': ('jabbe',),
'jabbe': ('jabbe',),
'jabber': ('jabbe',),
'jabbes': ('jabbe',),
'jabbet': ('jabbe',),
'jabb': ('jabbe',),
'jabba': ('jabbe',),
'jabbe': ('jabbe',),
'jabber': ('jabbe',),
'jabbes': ('jabbe',),
'jabbet': ('jabbe',),
'jafs': ('jafse',),
'jafsa': ('jafse',),
'jafse': ('jafse',),
'jafser': ('jafse',),
'jafses': ('jafse',),
'jafset': ('jafse',),
'jag': ('jage',),
'jaga': ('jage',),
'jagd': ('jage',),
'jagde': ('jage',),
'jage': ('jage',),
'jager': ('jage',),
'jages': ('jage',),
'jaget': ('jage',),
'jog': ('jage',),
'jakt': ('jakte',),
'jakta': ('jakte',),
'jakte': ('jakte',),
'jakter': ('jakte',),
'jaktes': ('jakte',),
'jaktet': ('jakte',),
'jalm': ('jalme',),
'jalma': ('jalme',),
'jalme': ('jalme',),
'jalmer': ('jalme',),
'jalmes': ('jalme',),
'jalmet': ('jalme',),
'jamfør': ('jamføre',),
'jamføre': ('jamføre',),
'jamfører': ('jamføre',),
'jamføres': ('jamføre',),
'jamført': ('jamføre',),
'jamførte': ('jamføre',),
'jam': ('jamme',),
'jamma': ('jamme',),
'jamme': ('jamme',),
'jammer': ('jamme',),
'jammes': ('jamme',),
'jammet': ('jamme',),
'jam': ('jamme',),
'jamma': ('jamme',),
'jamme': ('jamme',),
'jammer': ('jamme',),
'jammes': ('jamme',),
'jammet': ('jamme',),
'jamn': ('jamne',),
'jamna': ('jamne',),
'jamne': ('jamne',),
'jamner': ('jamne',),
'jamnes': ('jamne',),
'jamnet': ('jamne',),
'jamr': ('jamre',),
'jamra': ('jamre',),
'jamre': ('jamre',),
'jamrer': ('jamre',),
'jamres': ('jamre',),
'jamret': ('jamre',),
'jamstill': ('jamstille',),
'jamstille': ('jamstille',),
'jamstiller': ('jamstille',),
'jamstilles': ('jamstille',),
'jamstilt': ('jamstille',),
'jamstilte': ('jamstille',),
'jar': ('jare',),
'jara': ('jare',),
'jare': ('jare',),
'jarer': ('jare',),
'jares': ('jare',),
'jaret': ('jare',),
'jask': ('jaske',),
'jaska': ('jaske',),
'jaske': ('jaske',),
'jasker': ('jaske',),
'jaskes': ('jaske',),
'jasket': ('jaske',),
'jass': ('jasse',),
'jassa': ('jasse',),
'jasse': ('jasse',),
'jasser': ('jasse',),
'jasses': ('jasse',),
'jasset': ('jasse',),
'jassifiser': ('jassifisere',),
'jassifisere': ('jassifisere',),
'jassifiserer': ('jassifisere',),
'jassifiseres': ('jassifisere',),
'jassifisert': ('jassifisere',),
'jassifiserte': ('jassifisere',),
'jatt': ('jatte',),
'jatta': ('jatte',),
'jatte': ('jatte',),
'jatter': ('jatte',),
'jattes': ('jatte',),
'jattet': ('jatte',),
'jazz': ('jazze',),
'jazza': ('jazze',),
'jazze': ('jazze',),
'jazzer': ('jazze',),
'jazzes': ('jazze',),
'jazzet': ('jazze',),
'jazzifiser': ('jazzifisere',),
'jazzifisere': ('jazzifisere',),
'jazzifiserer': ('jazzifisere',),
'jazzifiseres': ('jazzifisere',),
'jazzifisert': ('jazzifisere',),
'jazzifiserte': ('jazzifisere',),
'jekk': ('jekke',),
'jekka': ('jekke',),
'jekke': ('jekke',),
'jekker': ('jekke',),
'jekkes': ('jekke',),
'jekket': ('jekke',),
'jelk': ('jelke',),
'jelka': ('jelke',),
'jelke': ('jelke',),
'jelker': ('jelke',),
'jelkes': ('jelke',),
'jelket': ('jelke',),
'jenk': ('jenke',),
'jenka': ('jenke',),
'jenke': ('jenke',),
'jenker': ('jenke',),
'jenkes': ('jenke',),
'jenket': ('jenke',),
'jevn': ('jevne',),
'jevna': ('jevne',),
'jevne': ('jevne',),
'jevner': ('jevne',),
'jevnes': ('jevne',),
'jevnet': ('jevne',),
'jevnfør': ('jevnføre',),
'jevnføre': ('jevnføre',),
'jevnfører': ('jevnføre',),
'jevnføres': ('jevnføre',),
'jevnført': ('jevnføre',),
'jevnførte': ('jevnføre',),
'jibb': ('jibbe',),
'jibba': ('jibbe',),
'jibbe': ('jibbe',),
'jibber': ('jibbe',),
'jibbes': ('jibbe',),
'jibbet': ('jibbe',),
'jobb': ('jobbe',),
'jobba': ('jobbe',),
'jobbe': ('jobbe',),
'jobber': ('jobbe',),
'jobbes': ('jobbe',),
'jobbet': ('jobbe',),
'joder': ('jodere',),
'jodere': ('jodere',),
'joderer': ('jodere',),
'joderes': ('jodere',),
'jodert': ('jodere',),
'joderte': ('jodere',),
'jodiser': ('jodisere',),
'jodisere': ('jodisere',),
'jodiserer': ('jodisere',),
'jodiseres': ('jodisere',),
'jodisert': ('jodisere',),
'jodiserte': ('jodisere',),
'jodl': ('jodle',),
'jodla': ('jodle',),
'jodle': ('jodle',),
'jodler': ('jodle',),
'jodles': ('jodle',),
'jodlet': ('jodle',),
'jogg': ('jogge',),
'jogga': ('jogge',),
'jogge': ('jogge',),
'jogger': ('jogge',),
'jogges': ('jogge',),
'jogget': ('jogge',),
'joik': ('joike',),
'joika': ('joike',),
'joike': ('joike',),
'joiker': ('joike',),
'joikes': ('joike',),
'joiket': ('joike',),
'jord': ('jorde',),
'jorda': ('jorde',),
'jorde': ('jorde',),
'jorder': ('jorde',),
'jordes': ('jorde',),
'jordet': ('jorde',),
'jordfest': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfeste': ('jordfeste',),
'jordfester': ('jordfeste',),
'jordfestes': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordslo': ('jordslå',),
'jordslå': ('jordslå',),
'jordslåes': ('jordslå',),
'jordslår': ('jordslå',),
'jordslås': ('jordslå',),
'jordslått': ('jordslå',),
'jort': ('jorte',),
'jorta': ('jorte',),
'jorte': ('jorte',),
'jorter': ('jorte',),
'jortes': ('jorte',),
'jortet': ('jorte',),
'journalfør': ('journalføre',),
'journalføre': ('journalføre',),
'journalfører': ('journalføre',),
'journalføres': ('journalføre',),
'journalført': ('journalføre',),
'journalførte': ('journalføre',),
'journaliser': ('journalisere',),
'journalisere': ('journalisere',),
'journaliserer': ('journalisere',),
'journaliseres': ('journalisere',),
'journalisert': ('journalisere',),
'journaliserte': ('journalisere',),
'jubiler': ('jubilere',),
'jubilere': ('jubilere',),
'jubilerer': ('jubilere',),
'jubileres': ('jubilere',),
'jubilert': ('jubilere',),
'jubilerte': ('jubilere',),
'jubl': ('juble',),
'jubla': ('juble',),
'juble': ('juble',),
'jubler': ('juble',),
'jubles': ('juble',),
'jublet': ('juble',),
'jugl': ('jugle',),
'jugla': ('jugle',),
'jugle': ('jugle',),
'jugler': ('jugle',),
'jugles': ('jugle',),
'juglet': ('jugle',),
'juks': ('jukse',),
'juksa': ('jukse',),
'jukse': ('jukse',),
'jukser': ('jukse',),
'jukses': ('jukse',),
'jukset': ('jukse',),
'juks': ('jukse',),
'juksa': ('jukse',),
'jukse': ('jukse',),
'jukser': ('jukse',),
'jukses': ('jukse',),
'jukset': ('jukse',),
'jul': ('jule',),
'jule': ('jule',),
'juler': ('jule',),
'jules': ('jule',),
'jult': ('jule',),
'julte': ('jule',),
'jump': ('jumpe',),
'jumpa': ('jumpe',),
'jumpe': ('jumpe',),
'jumper': ('jumpe',),
'jumpes': ('jumpe',),
'jumpet': ('jumpe',),
'junk': ('junke',),
'junka': ('junke',),
'junke': ('junke',),
'junker': ('junke',),
'junkes': ('junke',),
'junket': ('junke',),
'juryer': ('juryere',),
'juryere': ('juryere',),
'juryerer': ('juryere',),
'juryeres': ('juryere',),
'juryert': ('juryere',),
'juryerte': ('juryere',),
'juster': ('justere',),
'justere': ('justere',),
'justerer': ('justere',),
'justeres': ('justere',),
'justert': ('justere',),
'justerte': ('justere',),
'jål': ('jåle',),
'jåla': ('jåle',),
'jåle': ('jåle',),
'jåler': ('jåle',),
'jåles': ('jåle',),
'jålet': ('jåle',),
'jålt': ('jåle',),
'jålte': ('jåle',),
'jøy': ('jøye',),
'jøya': ('jøye',),
'jøye': ('jøye',),
'jøyer': ('jøye',),
'jøyes': ('jøye',),
'jøyet': ('jøye',),
'kabb': ('kabbe',),
'kabba': ('kabbe',),
'kabbe': ('kabbe',),
'kabber': ('kabbe',),
'kabbes': ('kabbe',),
'kabbet': ('kabbe',),
'kadmier': ('kadmiere',),
'kadmiere': ('kadmiere',),
'kadmierer': ('kadmiere',),
'kadmieres': ('kadmiere',),
'kadmiert': ('kadmiere',),
'kadmierte': ('kadmiere',),
'kadrei': ('kadreie',),
'kadreia': ('kadreie',),
'kadreid': ('kadreie',),
'kadreidd': ('kadreie',),
'kadreidde': ('kadreie',),
'kadreide': ('kadreie',),
'kadreie': ('kadreie',),
'kadreier': ('kadreie',),
'kadreies': ('kadreie',),
'kadreiet': ('kadreie',),
'kak': ('kake',),
'kaka': ('kake',),
'kake': ('kake',),
'kaker': ('kake',),
'kakes': ('kake',),
'kaket': ('kake',),
'kakk': ('kakke',),
'kakka': ('kakke',),
'kakke': ('kakke',),
'kakker': ('kakke',),
'kakkes': ('kakke',),
'kakket': ('kakke',),
'kakl': ('kakle',),
'kakla': ('kakle',),
'kakle': ('kakle',),
'kakler': ('kakle',),
'kakles': ('kakle',),
'kaklet': ('kakle',),
'kakstrauk': ('kakstryke',),
'kakstryk': ('kakstryke',),
'kakstryke': ('kakstryke',),
'kakstryker': ('kakstryke',),
'kakstrykes': ('kakstryke',),
'kakstrøk': ('kakstryke',),
'kakstrøket': ('kakstryke',),
'kakstrøyk': ('kakstryke',),
'kakuminaliser': ('kakuminalisere',),
'kakuminalisere': ('kakuminalisere',),
'kakuminaliserer': ('kakuminalisere',),
'kakuminaliseres': ('kakuminalisere',),
'kakuminalisert': ('kakuminalisere',),
'kakuminaliserte': ('kakuminalisere',),
'kalandrer': ('kalandrere',),
'kalandrere': ('kalandrere',),
'kalandrerer': ('kalandrere',),
'kalandreres': ('kalandrere',),
'kalandrert': ('kalandrere',),
'kalandrerte': ('kalandrere',),
'kaldflir': ('kaldflire',),
'kaldflire': ('kaldflire',),
'kaldflirer': ('kaldflire',),
'kaldflires': ('kaldflire',),
'kaldflirt': ('kaldflire',),
'kaldflirte': ('kaldflire',),
'kaldrøyk': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøyke': ('kaldrøyke',),
'kaldrøyker': ('kaldrøyke',),
'kaldrøykes': ('kaldrøyke',),
'kaldrøyket': ('kaldrøyke',),
'kaldrøykt': ('kaldrøyke',),
'kaldrøykte': ('kaldrøyke',),
'kaldskratt': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskratte': ('kaldskratte',),
'kaldskratter': ('kaldskratte',),
'kaldskrattes': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldsmi': ('kaldsmi',),
'kaldsmidd': ('kaldsmi',),
'kaldsmidde': ('kaldsmi',),
'kaldsmir': ('kaldsmi',),
'kaldsmis': ('kaldsmi',),
'kaldsvett': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvette': ('kaldsvette',),
'kaldsvetter': ('kaldsvette',),
'kaldsvettes': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvett': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvette': ('kaldsvette',),
'kaldsvetter': ('kaldsvette',),
'kaldsvettes': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kalfatr': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatre': ('kalfatre',),
'kalfatrer': ('kalfatre',),
'kalfatres': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalibrer': ('kalibrere',),
'kalibrere': ('kalibrere',),
'kalibrerer': ('kalibrere',),
'kalibreres': ('kalibrere',),
'kalibrert': ('kalibrere',),
'kalibrerte': ('kalibrere',),
'kalk': ('kalke',),
'kalka': ('kalke',),
'kalke': ('kalke',),
'kalker': ('kalke',),
'kalkes': ('kalke',),
'kalket': ('kalke',),
'kalker': ('kalkere',),
'kalkere': ('kalkere',),
'kalkerer': ('kalkere',),
'kalkeres': ('kalkere',),
'kalkert': ('kalkere',),
'kalkerte': ('kalkere',),
'kalkuler': ('kalkulere',),
'kalkulere': ('kalkulere',),
'kalkulerer': ('kalkulere',),
'kalkuleres': ('kalkulere',),
'kalkulert': ('kalkulere',),
'kalkulerte': ('kalkulere',),
'kall': ('kalle',),
'kalle': ('kalle',),
'kaller': ('kalle',),
'kalles': ('kalle',),
'kalt': ('kalle',),
'kalte': ('kalle',),
'kalligrafer': ('kalligrafere',),
'kalligrafere': ('kalligrafere',),
'kalligraferer': ('kalligrafere',),
'kalligraferes': ('kalligrafere',),
'kalligrafert': ('kalligrafere',),
'kalligraferte': ('kalligrafere',),
'kalsiner': ('kalsinere',),
'kalsinere': ('kalsinere',),
'kalsinerer': ('kalsinere',),
'kalsineres': ('kalsinere',),
'kalsinert': ('kalsinere',),
'kalsinerte': ('kalsinere',),
'kalv': ('kalve',),
'kalva': ('kalve',),
'kalve': ('kalve',),
'kalver': ('kalve',),
'kalves': ('kalve',),
'kalvet': ('kalve',),
'kam': ('kamme',),
'kamma': ('kamme',),
'kamme': ('kamme',),
'kammer': ('kamme',),
'kammes': ('kamme',),
'kammet': ('kamme',),
'kamper': ('kampere',),
'kampere': ('kampere',),
'kamperer': ('kampere',),
'kamperes': ('kampere',),
'kampert': ('kampere',),
'kamperte': ('kampere',),
'kams': ('kamse',),
'kamsa': ('kamse',),
'kamse': ('kamse',),
'kamser': ('kamse',),
'kamses': ('kamse',),
'kamset': ('kamse',),
'kamufler': ('kamuflere',),
'kamuflere': ('kamuflere',),
'kamuflerer': ('kamuflere',),
'kamufleres': ('kamuflere',),
'kamuflert': ('kamuflere',),
'kamuflerte': ('kamuflere',),
'kanaliser': ('kanalisere',),
'kanalisere': ('kanalisere',),
'kanaliserer': ('kanalisere',),
'kanaliseres': ('kanalisere',),
'kanalisert': ('kanalisere',),
'kanaliserte': ('kanalisere',),
'kandider': ('kandidere',),
'kandidere': ('kandidere',),
'kandiderer': ('kandidere',),
'kandideres': ('kandidere',),
'kandidert': ('kandidere',),
'kandiderte': ('kandidere',),
'kandiser': ('kandisere',),
'kandisere': ('kandisere',),
'kandiserer': ('kandisere',),
'kandiseres': ('kandisere',),
'kandisert': ('kandisere',),
'kandiserte': ('kandisere',),
'kanneler': ('kannelere',),
'kannelere': ('kannelere',),
'kannelerer': ('kannelere',),
'kanneleres': ('kannelere',),
'kannelert': ('kannelere',),
'kannelerte': ('kannelere',),
'kanoniser': ('kanonisere',),
'kanonisere': ('kanonisere',),
'kanoniserer': ('kanonisere',),
'kanoniseres': ('kanonisere',),
'kanonisert': ('kanonisere',),
'kanoniserte': ('kanonisere',),
'kanseller': ('kansellere',),
'kansellere': ('kansellere',),
'kansellerer': ('kansellere',),
'kanselleres': ('kansellere',),
'kansellert': ('kansellere',),
'kansellerte': ('kansellere',),
'kant': ('kante',),
'kanta': ('kante',),
'kante': ('kante',),
'kanter': ('kante',),
'kantes': ('kante',),
'kantet': ('kante',),
'kantr': ('kantre',),
'kantra': ('kantre',),
'kantre': ('kantre',),
'kantrer': ('kantre',),
'kantres': ('kantre',),
'kantret': ('kantre',),
'kapitaliser': ('kapitalisere',),
'kapitalisere': ('kapitalisere',),
'kapitaliserer': ('kapitalisere',),
'kapitaliseres': ('kapitalisere',),
'kapitalisert': ('kapitalisere',),
'kapitaliserte': ('kapitalisere',),
'kapituler': ('kapitulere',),
'kapitulere': ('kapitulere',),
'kapitulerer': ('kapitulere',),
'kapituleres': ('kapitulere',),
'kapitulert': ('kapitulere',),
'kapitulerte': ('kapitulere',),
'kappdrakk': ('kappdrikke',),
'kappdrikk': ('kappdrikke',),
'kappdrikke': ('kappdrikke',),
'kappdrikker': ('kappdrikke',),
'kappdrikkes': ('kappdrikke',),
'kappdrukket': ('kappdrikke',),
'kapp': ('kappe',),
'kappa': ('kappe',),
'kappe': ('kappe',),
'kapper': ('kappe',),
'kappes': ('kappe',),
'kappet': ('kappe',),
'kappes': ('kappes',),
'kaptes': ('kappes',),
'kappkjør': ('kappkjøre',),
'kappkjøre': ('kappkjøre',),
'kappkjører': ('kappkjøre',),
'kappkjøres': ('kappkjøre',),
'kappkjørt': ('kappkjøre',),
'kappkjørte': ('kappkjøre',),
'kapr': ('kapre',),
'kapra': ('kapre',),
'kapre': ('kapre',),
'kaprer': ('kapre',),
'kapres': ('kapre',),
'kapret': ('kapre',),
'kapseis': ('kapseise',),
'kapseise': ('kapseise',),
'kapseiser': ('kapseise',),
'kapseises': ('kapseise',),
'kapseist': ('kapseise',),
'kapseiste': ('kapseise',),
'kapsl': ('kapsle',),
'kapsla': ('kapsle',),
'kapsle': ('kapsle',),
'kapsler': ('kapsle',),
'kapsles': ('kapsle',),
'kapslet': ('kapsle',),
'kapuner': ('kapunere',),
'kapunere': ('kapunere',),
'kapunerer': ('kapunere',),
'kapuneres': ('kapunere',),
'kapunert': ('kapunere',),
'kapunerte': ('kapunere',),
'karakteriser': ('karakterisere',),
'karakterisere': ('karakterisere',),
'karakteriserer': ('karakterisere',),
'karakteriseres': ('karakterisere',),
'karakterisert': ('karakterisere',),
'karakteriserte': ('karakterisere',),
'kard': ('karde',),
'karda': ('karde',),
'karde': ('karde',),
'karder': ('karde',),
'kardes': ('karde',),
'kardet': ('karde',),
'kar': ('kare',),
'kara': ('kare',),
'kare': ('kare',),
'karer': ('kare',),
'kares': ('kare',),
'karet': ('kare',),
'kariker': ('karikere',),
'karikere': ('karikere',),
'karikerer': ('karikere',),
'karikeres': ('karikere',),
'karikert': ('karikere',),
'karikerte': ('karikere',),
'karnøfl': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøfle': ('karnøfle',),
'karnøfler': ('karnøfle',),
'karnøfles': ('karnøfle',),
'karnøflet': ('karnøfle',),
'kart': ('karte',),
'karta': ('karte',),
'karte': ('karte',),
'karter': ('karte',),
'kartes': ('karte',),
'kartet': ('karte',),
'karter': ('kartere',),
'kartere': ('kartere',),
'karterer': ('kartere',),
'karteres': ('kartere',),
'kartert': ('kartere',),
'karterte': ('kartere',),
'kartla': ('kartlegge',),
'kartlagt': ('kartlegge',),
'kartlegg': ('kartlegge',),
'kartlegge': ('kartlegge',),
'kartlegger': ('kartlegge',),
'kartlegges': ('kartlegge',),
'kartoner': ('kartonere',),
'kartonere': ('kartonere',),
'kartonerer': ('kartonere',),
'kartoneres': ('kartonere',),
'kartonert': ('kartonere',),
'kartonerte': ('kartonere',),
'karv': ('karve',),
'karva': ('karve',),
'karve': ('karve',),
'karver': ('karve',),
'karves': ('karve',),
'karvet': ('karve',),
'kas': ('kase',),
'kasa': ('kase',),
'kase': ('kase',),
'kaser': ('kase',),
'kases': ('kase',),
'kaset': ('kase',),
'kasser': ('kassere',),
'kassere': ('kassere',),
'kasserer': ('kassere',),
'kasseres': ('kassere',),
'kassert': ('kassere',),
'kasserte': ('kassere',),
'kasser': ('kassere',),
'kassere': ('kassere',),
'kasserer': ('kassere',),
'kasseres': ('kassere',),
'kassert': ('kassere',),
'kasserte': ('kassere',),
'kast': ('kaste',),
'kasta': ('kaste',),
'kaste': ('kaste',),
'kaster': ('kaste',),
'kastes': ('kaste',),
'kastet': ('kaste',),
'kastebytt': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebytte': ('kastebytte',),
'kastebytter': ('kastebytte',),
'kastebyttes': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastrer': ('kastrere',),
'kastrere': ('kastrere',),
'kastrerer': ('kastrere',),
'kastreres': ('kastrere',),
'kastrert': ('kastrere',),
'kastrerte': ('kastrere',),
'katalogiser': ('katalogisere',),
'katalogisere': ('katalogisere',),
'katalogiserer': ('katalogisere',),
'katalogiseres': ('katalogisere',),
'katalogisert': ('katalogisere',),
'katalogiserte': ('katalogisere',),
'katalyser': ('katalysere',),
'katalysere': ('katalysere',),
'katalyserer': ('katalysere',),
'katalyseres': ('katalysere',),
'katalysert': ('katalysere',),
'katalyserte': ('katalysere',),
'kategoriser': ('kategorisere',),
'kategorisere': ('kategorisere',),
'kategoriserer': ('kategorisere',),
'kategoriseres': ('kategorisere',),
'kategorisert': ('kategorisere',),
'kategoriserte': ('kategorisere',),
'katekiser': ('katekisere',),
'katekisere': ('katekisere',),
'katekiserer': ('katekisere',),
'katekiseres': ('katekisere',),
'katekisert': ('katekisere',),
'katekiserte': ('katekisere',),
'katoliser': ('katolisere',),
'katolisere': ('katolisere',),
'katoliserer': ('katolisere',),
'katoliseres': ('katolisere',),
'katolisert': ('katolisere',),
'katoliserte': ('katolisere',),
'katt': ('katte',),
'katta': ('katte',),
'katte': ('katte',),
'katter': ('katte',),
'kattes': ('katte',),
'kattet': ('katte',),
'kau': ('kaue',),
'kaua': ('kaue',),
'kaue': ('kaue',),
'kauer': ('kaue',),
'kaues': ('kaue',),
'kauet': ('kaue',),
'kauk': ('kauke',),
'kauka': ('kauke',),
'kauke': ('kauke',),
'kauker': ('kauke',),
'kaukes': ('kauke',),
'kauket': ('kauke',),
'kausjoner': ('kausjonere',),
'kausjonere': ('kausjonere',),
'kausjonerer': ('kausjonere',),
'kausjoneres': ('kausjonere',),
'kausjonert': ('kausjonere',),
'kausjonerte': ('kausjonere',),
'kav': ('kave',),
'kava': ('kave',),
'kavd': ('kave',),
'kavde': ('kave',),
'kave': ('kave',),
'kaver': ('kave',),
'kaves': ('kave',),
'kavet': ('kave',),
'kaver': ('kavere',),
'kavere': ('kavere',),
'kaverer': ('kavere',),
'kaveres': ('kavere',),
'kavert': ('kavere',),
'kaverte': ('kavere',),
'kavl': ('kavle',),
'kavla': ('kavle',),
'kavle': ('kavle',),
'kavler': ('kavle',),
'kavles': ('kavle',),
'kavlet': ('kavle',),
'kavl': ('kavle',),
'kavla': ('kavle',),
'kavle': ('kavle',),
'kavler': ('kavle',),
'kavles': ('kavle',),
'kavlet': ('kavle',),
'kei': ('keie',),
'keia': ('keie',),
'keie': ('keie',),
'keier': ('keie',),
'keies': ('keie',),
'keiet': ('keie',),
'keik': ('keike',),
'keika': ('keike',),
'keike': ('keike',),
'keiker': ('keike',),
'keikes': ('keike',),
'keiket': ('keike',),
'keikt': ('keike',),
'keikte': ('keike',),
'keivl': ('keivle',),
'keivla': ('keivle',),
'keivle': ('keivle',),
'keivler': ('keivle',),
'keivles': ('keivle',),
'keivlet': ('keivle',),
'kibb': ('kibbe',),
'kibba': ('kibbe',),
'kibbe': ('kibbe',),
'kibber': ('kibbe',),
'kibbes': ('kibbe',),
'kibbet': ('kibbe',),
'kidnapp': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappe': ('kidnappe',),
'kidnapper': ('kidnappe',),
'kidnappes': ('kidnappe',),
'kidnappet': ('kidnappe',),
'kik': ('kike',),
'kika': ('kike',),
'kike': ('kike',),
'kiker': ('kike',),
'kikes': ('kike',),
'kiket': ('kike',),
'kik': ('kike',),
'kike': ('kike',),
'kiker': ('kike',),
'kikes': ('kike',),
'kikt': ('kike',),
'kikte': ('kike',),
'kikk': ('kikke',),
'kikka': ('kikke',),
'kikke': ('kikke',),
'kikker': ('kikke',),
'kikkes': ('kikke',),
'kikket': ('kikke',),
'kikk': ('kikke',),
'kikka': ('kikke',),
'kikke': ('kikke',),
'kikker': ('kikke',),
'kikkes': ('kikke',),
'kikket': ('kikke',),
'kikn': ('kikne',),
'kikna': ('kikne',),
'kikne': ('kikne',),
'kikner': ('kikne',),
'kiknes': ('kikne',),
'kiknet': ('kikne',),
'kikr': ('kikre',),
'kikra': ('kikre',),
'kikre': ('kikre',),
'kikrer': ('kikre',),
'kikres': ('kikre',),
'kikret': ('kikre',),
'kiks': ('kikse',),
'kiksa': ('kikse',),
'kikse': ('kikse',),
'kikser': ('kikse',),
'kikses': ('kikse',),
'kikset': ('kikse',),
'kildr': ('kildre',),
'kildra': ('kildre',),
'kildre': ('kildre',),
'kildrer': ('kildre',),
'kildres': ('kildre',),
'kildret': ('kildre',),
'kil': ('kile',),
'kile': ('kile',),
'kiler': ('kile',),
'kiles': ('kile',),
'kilt': ('kile',),
'kilte': ('kile',),
'kil': ('kile',),
'kile': ('kile',),
'kiler': ('kile',),
'kiles': ('kile',),
'kilt': ('kile',),
'kilte': ('kile',),
'kim': ('kime',),
'kima': ('kime',),
'kime': ('kime',),
'kimer': ('kime',),
'kimes': ('kime',),
'kimet': ('kime',),
'kimt': ('kime',),
'kimte': ('kime',),
'kims': ('kimse',),
'kimsa': ('kimse',),
'kimse': ('kimse',),
'kimser': ('kimse',),
'kimses': ('kimse',),
'kimset': ('kimse',),
'kings': ('kingse',),
'kingsa': ('kingse',),
'kingse': ('kingse',),
'kingser': ('kingse',),
'kingses': ('kingse',),
'kingset': ('kingse',),
'kink': ('kinke',),
'kinka': ('kinke',),
'kinke': ('kinke',),
'kinker': ('kinke',),
'kinkes': ('kinke',),
'kinket': ('kinke',),
'kinks': ('kinkse',),
'kinksa': ('kinkse',),
'kinkse': ('kinkse',),
'kinkser': ('kinkse',),
'kinkses': ('kinkse',),
'kinkset': ('kinkse',),
'kinn': ('kinne',),
'kinna': ('kinne',),
'kinne': ('kinne',),
'kinner': ('kinne',),
'kinnes': ('kinne',),
'kinnet': ('kinne',),
'kipp': ('kippe',),
'kippa': ('kippe',),
'kippe': ('kippe',),
'kipper': ('kippe',),
'kippes': ('kippe',),
'kippet': ('kippe',),
'kipt': ('kippe',),
'kipte': ('kippe',),
'kisl': ('kisle',),
'kisla': ('kisle',),
'kisle': ('kisle',),
'kisler': ('kisle',),
'kisles': ('kisle',),
'kislet': ('kisle',),
'kisl': ('kisle',),
'kisla': ('kisle',),
'kisle': ('kisle',),
'kisler': ('kisle',),
'kisles': ('kisle',),
'kislet': ('kisle',),
'kitl': ('kitle',),
'kitla': ('kitle',),
'kitle': ('kitle',),
'kitler': ('kitle',),
'kitles': ('kitle',),
'kitlet': ('kitle',),
'kitt': ('kitte',),
'kitta': ('kitte',),
'kitte': ('kitte',),
'kitter': ('kitte',),
'kittes': ('kitte',),
'kittet': ('kitte',),
'kiv': ('kive',),
'kiva': ('kive',),
'kivd': ('kive',),
'kivde': ('kive',),
'kive': ('kive',),
'kiver': ('kive',),
'kives': ('kive',),
'kivet': ('kive',),
'kivdes': ('kives',),
'kives': ('kives',),
'kjaks': ('kjakse',),
'kjaksa': ('kjakse',),
'kjakse': ('kjakse',),
'kjakser': ('kjakse',),
'kjakses': ('kjakse',),
'kjakset': ('kjakse',),
'kjangs': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangse': ('kjangse',),
'kjangser': ('kjangse',),
'kjangses': ('kjangse',),
'kjangset': ('kjangse',),
'kjapp': ('kjappe',),
'kjappa': ('kjappe',),
'kjappe': ('kjappe',),
'kjapper': ('kjappe',),
'kjappes': ('kjappe',),
'kjappet': ('kjappe',),
'kjas': ('kjase',),
'kjase': ('kjase',),
'kjaser': ('kjase',),
'kjases': ('kjase',),
'kjast': ('kjase',),
'kjaste': ('kjase',),
'kjav': ('kjave',),
'kjava': ('kjave',),
'kjavd': ('kjave',),
'kjavde': ('kjave',),
'kjave': ('kjave',),
'kjaver': ('kjave',),
'kjaves': ('kjave',),
'kjavet': ('kjave',),
'kjed': ('kjede',),
'kjeda': ('kjede',),
'kjede': ('kjede',),
'kjeder': ('kjede',),
'kjedes': ('kjede',),
'kjedet': ('kjede',),
'kjed': ('kjede',),
'kjeda': ('kjede',),
'kjede': ('kjede',),
'kjeder': ('kjede',),
'kjedes': ('kjede',),
'kjedet': ('kjede',),
'kjederøyk': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøyke': ('kjederøyke',),
'kjederøyker': ('kjederøyke',),
'kjederøykes': ('kjederøyke',),
'kjederøyket': ('kjederøyke',),
'kjederøykt': ('kjederøyke',),
'kjederøykte': ('kjederøyke',),
'kje': ('kjee',),
'kjea': ('kjee',),
'kjee': ('kjee',),
'kjeer': ('kjee',),
'kjees': ('kjee',),
'kjeet': ('kjee',),
'kjeft': ('kjefte',),
'kjefta': ('kjefte',),
'kjefte': ('kjefte',),
'kjefter': ('kjefte',),
'kjeftes': ('kjefte',),
'kjeftet': ('kjefte',),
'kjekk': ('kjekke',),
'kjekka': ('kjekke',),
'kjekke': ('kjekke',),
'kjekker': ('kjekke',),
'kjekkes': ('kjekke',),
'kjekket': ('kjekke',),
'kjekl': ('kjekle',),
'kjekla': ('kjekle',),
'kjekle': ('kjekle',),
'kjekler': ('kjekle',),
'kjekles': ('kjekle',),
'kjeklet': ('kjekle',),
'kjeks': ('kjekse',),
'kjeksa': ('kjekse',),
'kjekse': ('kjekse',),
'kjekser': ('kjekse',),
'kjekses': ('kjekse',),
'kjekset': ('kjekse',),
'kjem': ('kjemme',),
'kjemma': ('kjemme',),
'kjemme': ('kjemme',),
'kjemmer': ('kjemme',),
'kjemmes': ('kjemme',),
'kjemmet': ('kjemme',),
'kjemt': ('kjemme',),
'kjemte': ('kjemme',),
'kjemp': ('kjempe',),
'kjempa': ('kjempe',),
'kjempe': ('kjempe',),
'kjemper': ('kjempe',),
'kjempes': ('kjempe',),
'kjempet': ('kjempe',),
'kjenn': ('kjenne',),
'kjenne': ('kjenne',),
'kjenner': ('kjenne',),
'kjennes': ('kjenne',),
'kjent': ('kjenne',),
'kjente': ('kjenne',),
'kjennetegn': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegne': ('kjennetegne',),
'kjennetegner': ('kjennetegne',),
'kjennetegnes': ('kjennetegne',),
'kjennetegnet': ('kjennetegne',),
'kjeppjag': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjagd': ('kjeppjage',),
'kjeppjagde': ('kjeppjage',),
'kjeppjage': ('kjeppjage',),
'kjeppjager': ('kjeppjage',),
'kjeppjages': ('kjeppjage',),
'kjeppjaget': ('kjeppjage',),
'kjern': ('kjerne',),
'kjerna': ('kjerne',),
'kjerne': ('kjerne',),
'kjerner': ('kjerne',),
'kjernes': ('kjerne',),
'kjernet': ('kjerne',),
'kjerv': ('kjerve',),
'kjerva': ('kjerve',),
'kjerve': ('kjerve',),
'kjerver': ('kjerve',),
'kjerves': ('kjerve',),
'kjervet': ('kjerve',),
'kjes': ('kjese',),
'kjese': ('kjese',),
'kjeser': ('kjese',),
'kjeses': ('kjese',),
'kjest': ('kjese',),
'kjeste': ('kjese',),
'kjesk': ('kjeske',),
'kjeska': ('kjeske',),
'kjeske': ('kjeske',),
'kjesker': ('kjeske',),
'kjeskes': ('kjeske',),
'kjesket': ('kjeske',),
'kjevl': ('kjevle',),
'kjevla': ('kjevle',),
'kjevle': ('kjevle',),
'kjevler': ('kjevle',),
'kjevles': ('kjevle',),
'kjevlet': ('kjevle',),
'kjæl': ('kjæle',),
'kjæle': ('kjæle',),
'kjæler': ('kjæle',),
'kjæles': ('kjæle',),
'kjælt': ('kjæle',),
'kjælte': ('kjæle',),
'kjær': ('kjære',),
'kjære': ('kjære',),
'kjærer': ('kjære',),
'kjæres': ('kjære',),
'kjært': ('kjære',),
'kjærte': ('kjære',),
'kjærtegn': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegne': ('kjærtegne',),
'kjærtegner': ('kjærtegne',),
'kjærtegnes': ('kjærtegne',),
'kjærtegnet': ('kjærtegne',),
'kjæt': ('kjæte',),
'kjæte': ('kjæte',),
'kjæter': ('kjæte',),
'kjætes': ('kjæte',),
'kjætt': ('kjæte',),
'kjætte': ('kjæte',),
'kjøl': ('kjøle',),
'kjøle': ('kjøle',),
'kjøler': ('kjøle',),
'kjøles': ('kjøle',),
'kjølt': ('kjøle',),
'kjølte': ('kjøle',),
'kjølhal': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhale': ('kjølhale',),
'kjølhaler': ('kjølhale',),
'kjølhales': ('kjølhale',),
'kjølhalet': ('kjølhale',),
'kjølhalt': ('kjølhale',),
'kjølhalte': ('kjølhale',),
'kjøln': ('kjølne',),
'kjølna': ('kjølne',),
'kjølne': ('kjølne',),
'kjølner': ('kjølne',),
'kjølnes': ('kjølne',),
'kjølnet': ('kjølne',),
'kjøp': ('kjøpe',),
'kjøpe': ('kjøpe',),
'kjøper': ('kjøpe',),
'kjøpes': ('kjøpe',),
'kjøpt': ('kjøpe',),
'kjøpte': ('kjøpe',),
'kjør': ('kjøre',),
'kjøre': ('kjøre',),
'kjører': ('kjøre',),
'kjøres': ('kjøre',),
'kjørt': ('kjøre',),
'kjørte': ('kjøre',),
'kjørn': ('kjørne',),
'kjørna': ('kjørne',),
'kjørne': ('kjørne',),
'kjørner': ('kjørne',),
'kjørnes': ('kjørne',),
'kjørnet': ('kjørne',),
'kjøv': ('kjøve',),
'kjøvd': ('kjøve',),
'kjøvde': ('kjøve',),
'kjøve': ('kjøve',),
'kjøver': ('kjøve',),
'kjøves': ('kjøve',),
'klabb': ('klabbe',),
'klabba': ('klabbe',),
'klabbe': ('klabbe',),
'klabber': ('klabbe',),
'klabbes': ('klabbe',),
'klabbet': ('klabbe',),
'kladd': ('kladde',),
'kladda': ('kladde',),
'kladde': ('kladde',),
'kladder': ('kladde',),
'kladdes': ('kladde',),
'kladdet': ('kladde',),
'klaff': ('klaffe',),
'klaffa': ('klaffe',),
'klaffe': ('klaffe',),
'klaffer': ('klaffe',),
'klaffes': ('klaffe',),
'klaffet': ('klaffe',),
'klag': ('klage',),
'klaga': ('klage',),
'klagd': ('klage',),
'klagde': ('klage',),
'klage': ('klage',),
'klager': ('klage',),
'klages': ('klage',),
'klaget': ('klage',),
'klak': ('klake',),
'klaka': ('klake',),
'klake': ('klake',),
'klaker': ('klake',),
'klakes': ('klake',),
'klaket': ('klake',),
'klakk': ('klakke',),
'klakka': ('klakke',),
'klakke': ('klakke',),
'klakker': ('klakke',),
'klakkes': ('klakke',),
'klakket': ('klakke',),
'klamp': ('klampe',),
'klampa': ('klampe',),
'klampe': ('klampe',),
'klamper': ('klampe',),
'klampes': ('klampe',),
'klampet': ('klampe',),
'klamr': ('klamre',),
'klamra': ('klamre',),
'klamre': ('klamre',),
'klamrer': ('klamre',),
'klamres': ('klamre',),
'klamret': ('klamre',),
'klandr': ('klandre',),
'klandra': ('klandre',),
'klandre': ('klandre',),
'klandrer': ('klandre',),
'klandres': ('klandre',),
'klandret': ('klandre',),
'klapp': ('klappe',),
'klappa': ('klappe',),
'klappe': ('klappe',),
'klapper': ('klappe',),
'klappes': ('klappe',),
'klappet': ('klappe',),
'klapr': ('klapre',),
'klapra': ('klapre',),
'klapre': ('klapre',),
'klaprer': ('klapre',),
'klapres': ('klapre',),
'klapret': ('klapre',),
'klaps': ('klapse',),
'klapsa': ('klapse',),
'klapse': ('klapse',),
'klapser': ('klapse',),
'klapses': ('klapse',),
'klapset': ('klapse',),
'klar': ('klare',),
'klara': ('klare',),
'klare': ('klare',),
'klarer': ('klare',),
'klares': ('klare',),
'klaret': ('klare',),
'klart': ('klare',),
'klarte': ('klare',),
'klar': ('klare',),
'klare': ('klare',),
'klarer': ('klare',),
'klares': ('klare',),
'klart': ('klare',),
'klarte': ('klare',),
'klarer': ('klarere',),
'klarere': ('klarere',),
'klarerer': ('klarere',),
'klareres': ('klarere',),
'klarert': ('klarere',),
'klarerte': ('klarere',),
'klargjorde': ('klargjøre',),
'klargjort': ('klargjøre',),
'klargjør': ('klargjøre',),
'klargjøre': ('klargjøre',),
'klargjøres': ('klargjøre',),
'klarla': ('klarlegge',),
'klarlagt': ('klarlegge',),
'klarlegg': ('klarlegge',),
'klarlegge': ('klarlegge',),
'klarlegger': ('klarlegge',),
'klarlegges': ('klarlegge',),
'klarn': ('klarne',),
'klarna': ('klarne',),
'klarne': ('klarne',),
'klarner': ('klarne',),
'klarnes': ('klarne',),
'klarnet': ('klarne',),
'klas': ('klase',),
'klasa': ('klase',),
'klase': ('klase',),
'klaser': ('klase',),
'klases': ('klase',),
'klaset': ('klase',),
'klast': ('klase',),
'klaste': ('klase',),
'klask': ('klaske',),
'klaska': ('klaske',),
'klaske': ('klaske',),
'klasker': ('klaske',),
'klaskes': ('klaske',),
'klasket': ('klaske',),
'klass': ('klasse',),
'klassa': ('klasse',),
'klasse': ('klasse',),
'klasser': ('klasse',),
'klasses': ('klasse',),
'klasset': ('klasse',),
'klass': ('klasse',),
'klassa': ('klasse',),
'klasse': ('klasse',),
'klasser': ('klasse',),
'klasses': ('klasse',),
'klasset': ('klasse',),
'klassifiser': ('klassifisere',),
'klassifisere': ('klassifisere',),
'klassifiserer': ('klassifisere',),
'klassifiseres': ('klassifisere',),
'klassifisert': ('klassifisere',),
'klassifiserte': ('klassifisere',),
'klatr': ('klatre',),
'klatra': ('klatre',),
'klatre': ('klatre',),
'klatrer': ('klatre',),
'klatres': ('klatre',),
'klatret': ('klatre',),
'klatt': ('klatte',),
'klatta': ('klatte',),
'klatte': ('klatte',),
'klatter': ('klatte',),
'klattes': ('klatte',),
'klattet': ('klatte',),
'klattemal': ('klattemale',),
'klattemale': ('klattemale',),
'klattemaler': ('klattemale',),
'klattemales': ('klattemale',),
'klattemalt': ('klattemale',),
'klattemalte': ('klattemale',),
'klattmal': ('klattmale',),
'klattmale': ('klattmale',),
'klattmaler': ('klattmale',),
'klattmales': ('klattmale',),
'klattmalt': ('klattmale',),
'klattmalte': ('klattmale',),
'klausuler': ('klausulere',),
'klausulere': ('klausulere',),
'klausulerer': ('klausulere',),
'klausuleres': ('klausulere',),
'klausulert': ('klausulere',),
'klausulerte': ('klausulere',),
'klav': ('klave',),
'klava': ('klave',),
'klavd': ('klave',),
'klavde': ('klave',),
'klave': ('klave',),
'klaver': ('klave',),
'klaves': ('klave',),
'klavet': ('klave',),
'klavebandt': ('klavebinde',),
'klavebind': ('klavebinde',),
'klavebinde': ('klavebinde',),
'klavebinder': ('klavebinde',),
'klavebindes': ('klavebinde',),
'klavebundet': ('klavebinde',),
'kle': ('kle',),
'kledd': ('kle',),
'kledde': ('kle',),
'kledt': ('kle',),
'kledte': ('kle',),
'kler': ('kle',),
'kles': ('kle',),
'kleb': ('klebe',),
'kleba': ('klebe',),
'klebe': ('klebe',),
'kleber': ('klebe',),
'klebes': ('klebe',),
'klebet': ('klebe',),
'klebt': ('klebe',),
'klebte': ('klebe',),
'kled': ('klede',),
'kledd': ('klede',),
'kledde': ('klede',),
'klede': ('klede',),
'kleder': ('klede',),
'kledes': ('klede',),
'klei': ('kleie',),
'kleia': ('kleie',),
'kleid': ('kleie',),
'kleidd': ('kleie',),
'kleidde': ('kleie',),
'kleide': ('kleie',),
'kleie': ('kleie',),
'kleier': ('kleie',),
'kleies': ('kleie',),
'kleiet': ('kleie',),
'kleim': ('kleime',),
'kleime': ('kleime',),
'kleimer': ('kleime',),
'kleimes': ('kleime',),
'kleimt': ('kleime',),
'kleimte': ('kleime',),
'kleis': ('kleise',),
'kleisa': ('kleise',),
'kleise': ('kleise',),
'kleiser': ('kleise',),
'kleises': ('kleise',),
'kleiset': ('kleise',),
'kleist': ('kleise',),
'kleiste': ('kleise',),
'klekk': ('klekke',),
'klekka': ('klekke',),
'klekke': ('klekke',),
'klekker': ('klekke',),
'klekkes': ('klekke',),
'klekket': ('klekke',),
'klekt': ('klekke',),
'klekte': ('klekke',),
'klem': ('klemme',),
'klemme': ('klemme',),
'klemmer': ('klemme',),
'klemmes': ('klemme',),
'klemt': ('klemme',),
'klemte': ('klemme',),
'klemt': ('klemte',),
'klemta': ('klemte',),
'klemte': ('klemte',),
'klemter': ('klemte',),
'klemtes': ('klemte',),
'klemtet': ('klemte',),
'kleng': ('klenge',),
'klenge': ('klenge',),
'klenger': ('klenge',),
'klenges': ('klenge',),
'klengt': ('klenge',),
'klengte': ('klenge',),
'kleng': ('klenge',),
'klenga': ('klenge',),
'klenge': ('klenge',),
'klenger': ('klenge',),
'klenges': ('klenge',),
'klenget': ('klenge',),
'klengt': ('klenge',),
'klengte': ('klenge',),
'klepp': ('kleppe',),
'kleppa': ('kleppe',),
'kleppe': ('kleppe',),
'klepper': ('kleppe',),
'kleppes': ('kleppe',),
'kleppet': ('kleppe',),
'klikk': ('klikke',),
'klikka': ('klikke',),
'klikke': ('klikke',),
'klikker': ('klikke',),
'klikkes': ('klikke',),
'klikket': ('klikke',),
'klimatiser': ('klimatisere',),
'klimatisere': ('klimatisere',),
'klimatiserer': ('klimatisere',),
'klimatiseres': ('klimatisere',),
'klimatisert': ('klimatisere',),
'klimatiserte': ('klimatisere',),
'klimpr': ('klimpre',),
'klimpra': ('klimpre',),
'klimpre': ('klimpre',),
'klimprer': ('klimpre',),
'klimpres': ('klimpre',),
'klimpret': ('klimpre',),
'klin': ('kline',),
'klina': ('kline',),
'kline': ('kline',),
'kliner': ('kline',),
'klines': ('kline',),
'klinet': ('kline',),
'klint': ('kline',),
'klinte': ('kline',),
'klang': ('klinge',),
'kling': ('klinge',),
'klinge': ('klinge',),
'klinger': ('klinge',),
'klinges': ('klinge',),
'klinget': ('klinge',),
'klingt': ('klinge',),
'klingra': ('klingre',),
'klingre': ('klingre',),
'klingrer': ('klingre',),
'klingres': ('klingre',),
'klingret': ('klingre',),
'klingr': ('klingre',),
'klink': ('klinke',),
'klinka': ('klinke',),
'klinke': ('klinke',),
'klinker': ('klinke',),
'klinkes': ('klinke',),
'klinket': ('klinke',),
'klink': ('klinke',),
'klinka': ('klinke',),
'klinke': ('klinke',),
'klinker': ('klinke',),
'klinkes': ('klinke',),
'klinket': ('klinke',),
'kleip': ('klipe',),
'klip': ('klipe',),
'klipe': ('klipe',),
'kliper': ('klipe',),
'klipes': ('klipe',),
'klipt': ('klipe',),
'klipp': ('klippe',),
'klippa': ('klippe',),
'klippe': ('klippe',),
'klipper': ('klippe',),
'klippes': ('klippe',),
'klippet': ('klippe',),
'klipt': ('klippe',),
'klipte': ('klippe',),
'klirr': ('klirre',),
'klirra': ('klirre',),
'klirre': ('klirre',),
'klirrer': ('klirre',),
'klirres': ('klirre',),
'klirret': ('klirre',),
'klisjer': ('klisjere',),
'klisjere': ('klisjere',),
'klisjerer': ('klisjere',),
'klisjeres': ('klisjere',),
'klisjert': ('klisjere',),
'klisjerte': ('klisjere',),
'kliss': ('klisse',),
'klissa': ('klisse',),
'klisse': ('klisse',),
'klisser': ('klisse',),
'klisses': ('klisse',),
'klisset': ('klisse',),
'klistr': ('klistre',),
'klistra': ('klistre',),
'klistre': ('klistre',),
'klistrer': ('klistre',),
'klistres': ('klistre',),
'klistret': ('klistre',),
'kleiv': ('klive',),
'klevet': ('klive',),
'kliv': ('klive',),
'klivd': ('klive',),
'klive': ('klive',),
'kliver': ('klive',),
'klives': ('klive',),
'kloakker': ('kloakkere',),
'kloakkere': ('kloakkere',),
'kloakkerer': ('kloakkere',),
'kloakkeres': ('kloakkere',),
'kloakkert': ('kloakkere',),
'kloakkerte': ('kloakkere',),
'klokk': ('klokke',),
'klokka': ('klokke',),
'klokke': ('klokke',),
'klokker': ('klokke',),
'klokkes': ('klokke',),
'klokket': ('klokke',),
'klon': ('klone',),
'klona': ('klone',),
'klone': ('klone',),
'kloner': ('klone',),
'klones': ('klone',),
'klonet': ('klone',),
'klor': ('klore',),
'klore': ('klore',),
'klorer': ('klore',),
'klores': ('klore',),
'klort': ('klore',),
'klorte': ('klore',),
'klor': ('klore',),
'klore': ('klore',),
'klorer': ('klore',),
'klores': ('klore',),
'klort': ('klore',),
'klorte': ('klore',),
'klorer': ('klorere',),
'klorere': ('klorere',),
'klorerer': ('klorere',),
'kloreres': ('klorere',),
'klorert': ('klorere',),
'klorerte': ('klorere',),
'kloroformer': ('kloroformere',),
'kloroformere': ('kloroformere',),
'kloroformerer': ('kloroformere',),
'kloroformeres': ('kloroformere',),
'kloroformert': ('kloroformere',),
'kloroformerte': ('kloroformere',),
'klovn': ('klovne',),
'klovna': ('klovne',),
'klovne': ('klovne',),
'klovner': ('klovne',),
'klovnes': ('klovne',),
'klovnet': ('klovne',),
'klovn': ('klovne',),
'klovna': ('klovne',),
'klovne': ('klovne',),
'klovner': ('klovne',),
'klovnes': ('klovne',),
'klovnet': ('klovne',),
'klubb': ('klubbe',),
'klubba': ('klubbe',),
'klubbe': ('klubbe',),
'klubber': ('klubbe',),
'klubbes': ('klubbe',),
'klubbet': ('klubbe',),
'kludr': ('kludre',),
'kludra': ('kludre',),
'kludre': ('kludre',),
'kludrer': ('kludre',),
'kludres': ('kludre',),
'kludret': ('kludre',),
'klukk': ('klukke',),
'klukka': ('klukke',),
'klukke': ('klukke',),
'klukker': ('klukke',),
'klukkes': ('klukke',),
'klukket': ('klukke',),
'klump': ('klumpe',),
'klumpa': ('klumpe',),
'klumpe': ('klumpe',),
'klumper': ('klumpe',),
'klumpes': ('klumpe',),
'klumpet': ('klumpe',),
'klums': ('klumse',),
'klumsa': ('klumse',),
'klumse': ('klumse',),
'klumser': ('klumse',),
'klumses': ('klumse',),
'klumset': ('klumse',),
'klundr': ('klundre',),
'klundra': ('klundre',),
'klundre': ('klundre',),
'klundrer': ('klundre',),
'klundres': ('klundre',),
'klundret': ('klundre',),
'klunk': ('klunke',),
'klunka': ('klunke',),
'klunke': ('klunke',),
'klunker': ('klunke',),
'klunkes': ('klunke',),
'klunket': ('klunke',),
'kluss': ('klusse',),
'klussa': ('klusse',),
'klusse': ('klusse',),
'klusser': ('klusse',),
'klusses': ('klusse',),
'klusset': ('klusse',),
'klyng': ('klynge',),
'klynga': ('klynge',),
'klynge': ('klynge',),
'klynger': ('klynge',),
'klynges': ('klynge',),
'klynget': ('klynge',),
'klynk': ('klynke',),
'klynka': ('klynke',),
'klynke': ('klynke',),
'klynker': ('klynke',),
'klynkes': ('klynke',),
'klynket': ('klynke',),
'klyp': ('klype',),
'klype': ('klype',),
'klyper': ('klype',),
'klypes': ('klype',),
'klypt': ('klype',),
'klypte': ('klype',),
'kløp': ('klype',),
'kløpet': ('klype',),
'klauv': ('klyve',),
'klyv': ('klyve',),
'klyvd': ('klyve',),
'klyvde': ('klyve',),
'klyve': ('klyve',),
'klyver': ('klyve',),
'klyves': ('klyve',),
'kløv': ('klyve',),
'kløvet': ('klyve',),
'kløyv': ('klyve',),
'klå': ('klå',),
'klådd': ('klå',),
'klådde': ('klå',),
'klår': ('klå',),
'klås': ('klå',),
'klø': ('klø',),
'klødd': ('klø',),
'klødde': ('klø',),
'klør': ('klø',),
'kløs': ('klø',),
'kløft': ('kløfte',),
'kløfta': ('kløfte',),
'kløfte': ('kløfte',),
'kløfter': ('kløfte',),
'kløftes': ('kløfte',),
'kløftet': ('kløfte',),
'kløkk': ('kløkke',),
'kløkke': ('kløkke',),
'kløkker': ('kløkke',),
'kløkkes': ('kløkke',),
'kløkt': ('kløkke',),
'kløkte': ('kløkke',),
'kløn': ('kløne',),
'kløne': ('kløne',),
'kløner': ('kløne',),
'klønes': ('kløne',),
'klønt': ('kløne',),
'klønte': ('kløne',),
'kløtsj': ('kløtsje',),
'kløtsja': ('kløtsje',),
'kløtsje': ('kløtsje',),
'kløtsjer': ('kløtsje',),
'kløtsjes': ('kløtsje',),
'kløtsjet': ('kløtsje',),
'kløv': ('kløve',),
'kløvd': ('kløve',),
'kløvde': ('kløve',),
'kløve': ('kløve',),
'kløver': ('kløve',),
'kløves': ('kløve',),
'kløvj': ('kløvje',),
'kløvja': ('kløvje',),
'kløvje': ('kløvje',),
'kløvjer': ('kløvje',),
'kløvjes': ('kløvje',),
'kløvjet': ('kløvje',),
'kløvn': ('kløvne',),
'kløvna': ('kløvne',),
'kløvne': ('kløvne',),
'kløvner': ('kløvne',),
'kløvnes': ('kløvne',),
'kløvnet': ('kløvne',),
'kløyv': ('kløyve',),
'kløyvd': ('kløyve',),
'kløyvde': ('kløyve',),
'kløyve': ('kløyve',),
'kløyver': ('kløyve',),
'kløyves': ('kløyve',),
'kna': ('kna',),
'knadd': ('kna',),
'knadde': ('kna',),
'knar': ('kna',),
'knas': ('kna',),
'knabb': ('knabbe',),
'knabba': ('knabbe',),
'knabbe': ('knabbe',),
'knabber': ('knabbe',),
'knabbes': ('knabbe',),
'knabbet': ('knabbe',),
'knak': ('knake',),
'knaka': ('knake',),
'knake': ('knake',),
'knaker': ('knake',),
'knakes': ('knake',),
'knaket': ('knake',),
'knakt': ('knake',),
'knakte': ('knake',),
'knakk': ('knakke',),
'knakka': ('knakke',),
'knakke': ('knakke',),
'knakker': ('knakke',),
'knakkes': ('knakke',),
'knakket': ('knakke',),
'knall': ('knalle',),
'knalla': ('knalle',),
'knalle': ('knalle',),
'knaller': ('knalle',),
'knalles': ('knalle',),
'knallet': ('knalle',),
'knapp': ('knappe',),
'knappa': ('knappe',),
'knappe': ('knappe',),
'knapper': ('knappe',),
'knappes': ('knappe',),
'knappet': ('knappe',),
'knapp': ('knappe',),
'knappa': ('knappe',),
'knappe': ('knappe',),
'knapper': ('knappe',),
'knappes': ('knappe',),
'knappet': ('knappe',),
'knark': ('knarke',),
'knarka': ('knarke',),
'knarke': ('knarke',),
'knarker': ('knarke',),
'knarkes': ('knarke',),
'knarket': ('knarke',),
'knart': ('knarte',),
'knarta': ('knarte',),
'knarte': ('knarte',),
'knarter': ('knarte',),
'knartes': ('knarte',),
'knartet': ('knarte',),
'knas': ('knase',),
'knasa': ('knase',),
'knase': ('knase',),
'knaser': ('knase',),
'knases': ('knase',),
'knaset': ('knase',),
'knast': ('knase',),
'knaste': ('knase',),
'knask': ('knaske',),
'knaska': ('knaske',),
'knaske': ('knaske',),
'knasker': ('knaske',),
'knaskes': ('knaske',),
'knasket': ('knaske',),
'knatr': ('knatre',),
'knatra': ('knatre',),
'knatre': ('knatre',),
'knatrer': ('knatre',),
'knatres': ('knatre',),
'knatret': ('knatre',),
'knatt': ('knatte',),
'knatta': ('knatte',),
'knatte': ('knatte',),
'knatter': ('knatte',),
'knattes': ('knatte',),
'knattet': ('knatte',),
'knebl': ('kneble',),
'knebla': ('kneble',),
'kneble': ('kneble',),
'knebler': ('kneble',),
'knebles': ('kneble',),
'kneblet': ('kneble',),
'kneg': ('knege',),
'knega': ('knege',),
'knege': ('knege',),
'kneger': ('knege',),
'kneges': ('knege',),
'kneget': ('knege',),
'knegd': ('knegge',),
'knegde': ('knegge',),
'knegg': ('knegge',),
'knegga': ('knegge',),
'knegge': ('knegge',),
'knegger': ('knegge',),
'knegges': ('knegge',),
'knegget': ('knegge',),
'knegikk': ('knegå',),
'knegjekk': ('knegå',),
'knegå': ('knegå',),
'knegåes': ('knegå',),
'knegår': ('knegå',),
'knegås': ('knegå',),
'knegått': ('knegå',),
'kneis': ('kneise',),
'kneise': ('kneise',),
'kneiser': ('kneise',),
'kneises': ('kneise',),
'kneist': ('kneise',),
'kneiste': ('kneise',),
'knekk': ('knekke',),
'knekka': ('knekke',),
'knekke': ('knekke',),
'knekker': ('knekke',),
'knekkes': ('knekke',),
'knekket': ('knekke',),
'knekt': ('knekke',),
'knekte': ('knekke',),
'knakk': ('knekke',),
'knekk': ('knekke',),
'knekke': ('knekke',),
'knekker': ('knekke',),
'knekkes': ('knekke',),
'knekket': ('knekke',),
'knekt': ('knekke',),
'knekt': ('knekte',),
'knekta': ('knekte',),
'knekte': ('knekte',),
'knekter': ('knekte',),
'knektes': ('knekte',),
'knektet': ('knekte',),
'knel': ('knele',),
'knele': ('knele',),
'kneler': ('knele',),
'kneles': ('knele',),
'knelt': ('knele',),
'knelte': ('knele',),
'knepp': ('kneppe',),
'kneppa': ('kneppe',),
'kneppe': ('kneppe',),
'knepper': ('kneppe',),
'kneppes': ('kneppe',),
'kneppet': ('kneppe',),
'knept': ('kneppe',),
'knepte': ('kneppe',),
'knepp': ('kneppe',),
'kneppe': ('kneppe',),
'knepper': ('kneppe',),
'kneppes': ('kneppe',),
'knept': ('kneppe',),
'knepte': ('kneppe',),
'knepr': ('knepre',),
'knepra': ('knepre',),
'knepre': ('knepre',),
'kneprer': ('knepre',),
'knepres': ('knepre',),
'knepret': ('knepre',),
'knert': ('knerte',),
'knerta': ('knerte',),
'knerte': ('knerte',),
'knerter': ('knerte',),
'knertes': ('knerte',),
'knertet': ('knerte',),
'knesatt': ('knesette',),
'knesatte': ('knesette',),
'knesett': ('knesette',),
'knesette': ('knesette',),
'knesetter': ('knesette',),
'knesettes': ('knesette',),
'knast': ('kneste',),
'knest': ('kneste',),
'kneste': ('kneste',),
'knester': ('kneste',),
'knestes': ('kneste',),
'knestet': ('kneste',),
'knatt': ('knette',),
'knett': ('knette',),
'knette': ('knette',),
'knetter': ('knette',),
'knettes': ('knette',),
'knettet': ('knette',),
'kniks': ('knikse',),
'kniksa': ('knikse',),
'knikse': ('knikse',),
'knikser': ('knikse',),
'knikses': ('knikse',),
'knikset': ('knikse',),
'kneip': ('knipe',),
'knep': ('knipe',),
'knepet': ('knipe',),
'knip': ('knipe',),
'knipe': ('knipe',),
'kniper': ('knipe',),
'knipes': ('knipe',),
'knipl': ('kniple',),
'knipla': ('kniple',),
'kniple': ('kniple',),
'knipler': ('kniple',),
'kniples': ('kniple',),
'kniplet': ('kniple',),
'knipp': ('knippe',),
'knippa': ('knippe',),
'knippe': ('knippe',),
'knipper': ('knippe',),
'knippes': ('knippe',),
'knippet': ('knippe',),
'knips': ('knipse',),
'knipsa': ('knipse',),
'knipse': ('knipse',),
'knipser': ('knipse',),
'knipses': ('knipse',),
'knipset': ('knipse',),
'knirk': ('knirke',),
'knirka': ('knirke',),
'knirke': ('knirke',),
'knirker': ('knirke',),
'knirkes': ('knirke',),
'knirket': ('knirke',),
'knis': ('knise',),
'knise': ('knise',),
'kniser': ('knise',),
'knises': ('knise',),
'knist': ('knise',),
'kniste': ('knise',),
'knisl': ('knisle',),
'knisla': ('knisle',),
'knisle': ('knisle',),
'knisler': ('knisle',),
'knisles': ('knisle',),
'knislet': ('knisle',),
'knistr': ('knistre',),
'knistra': ('knistre',),
'knistre': ('knistre',),
'knistrer': ('knistre',),
'knistres': ('knistre',),
'knistret': ('knistre',),
'knitr': ('knitre',),
'knitra': ('knitre',),
'knitre': ('knitre',),
'knitrer': ('knitre',),
'knitres': ('knitre',),
'knitret': ('knitre',),
'kniv': ('knive',),
'kniva': ('knive',),
'knive': ('knive',),
'kniver': ('knive',),
'knives': ('knive',),
'knivet': ('knive',),
'knock': ('knocke',),
'knocka': ('knocke',),
'knocke': ('knocke',),
'knocker': ('knocke',),
'knockes': ('knocke',),
'knocket': ('knocke',),
'knockout': ('knockoute',),
'knockouta': ('knockoute',),
'knockoute': ('knockoute',),
'knockouter': ('knockoute',),
'knockoutes': ('knockoute',),
'knockoutet': ('knockoute',),
'knog': ('knoge',),
'knoga': ('knoge',),
'knoge': ('knoge',),
'knoger': ('knoge',),
'knoges': ('knoge',),
'knoget': ('knoge',),
'knop': ('knope',),
'knopa': ('knope',),
'knope': ('knope',),
'knoper': ('knope',),
'knopes': ('knope',),
'knopet': ('knope',),
'knopp': ('knoppe',),
'knoppa': ('knoppe',),
'knoppe': ('knoppe',),
'knopper': ('knoppe',),
'knoppes': ('knoppe',),
'knoppet': ('knoppe',),
'knot': ('knote',),
'knota': ('knote',),
'knote': ('knote',),
'knoter': ('knote',),
'knotes': ('knote',),
'knotet': ('knote',),
'knubb': ('knubbe',),
'knubba': ('knubbe',),
'knubbe': ('knubbe',),
'knubber': ('knubbe',),
'knubbes': ('knubbe',),
'knubbet': ('knubbe',),
'knuff': ('knuffe',),
'knuffa': ('knuffe',),
'knuffe': ('knuffe',),
'knuffer': ('knuffe',),
'knuffes': ('knuffe',),
'knuffet': ('knuffe',),
'knug': ('knuge',),
'knuga': ('knuge',),
'knuge': ('knuge',),
'knuger': ('knuge',),
'knuges': ('knuge',),
'knuget': ('knuge',),
'knull': ('knulle',),
'knulla': ('knulle',),
'knulle': ('knulle',),
'knuller': ('knulle',),
'knulles': ('knulle',),
'knullet': ('knulle',),
'knups': ('knupse',),
'knupsa': ('knupse',),
'knupse': ('knupse',),
'knupser': ('knupse',),
'knupses': ('knupse',),
'knupset': ('knupse',),
'knurk': ('knurke',),
'knurka': ('knurke',),
'knurke': ('knurke',),
'knurker': ('knurke',),
'knurkes': ('knurke',),
'knurket': ('knurke',),
'knurp': ('knurpe',),
'knurpa': ('knurpe',),
'knurpe': ('knurpe',),
'knurper': ('knurpe',),
'knurpes': ('knurpe',),
'knurpet': ('knurpe',),
'knurr': ('knurre',),
'knurra': ('knurre',),
'knurre': ('knurre',),
'knurrer': ('knurre',),
'knurres': ('knurre',),
'knurret': ('knurre',),
'knurv': ('knurve',),
'knurva': ('knurve',),
'knurve': ('knurve',),
'knurver': ('knurve',),
'knurves': ('knurve',),
'knurvet': ('knurve',),
'knus': ('knuse',),
'knuse': ('knuse',),
'knuser': ('knuse',),
'knuses': ('knuse',),
'knust': ('knuse',),
'knuste': ('knuse',),
'knuselsk': ('knuselske',),
'knuselska': ('knuselske',),
'knuselske': ('knuselske',),
'knuselsker': ('knuselske',),
'knuselskes': ('knuselske',),
'knuselsket': ('knuselske',),
'knusl': ('knusle',),
'knusla': ('knusle',),
'knusle': ('knusle',),
'knusler': ('knusle',),
'knusles': ('knusle',),
'knuslet': ('knusle',),
'knusp': ('knuspe',),
'knuspa': ('knuspe',),
'knuspe': ('knuspe',),
'knusper': ('knuspe',),
'knuspes': ('knuspe',),
'knuspet': ('knuspe',),
'knuspr': ('knuspre',),
'knuspra': ('knuspre',),
'knuspre': ('knuspre',),
'knusprer': ('knuspre',),
'knuspres': ('knuspre',),
'knuspret': ('knuspre',),
'knustr': ('knustre',),
'knustra': ('knustre',),
'knustre': ('knustre',),
'knustrer': ('knustre',),
'knustres': ('knustre',),
'knustret': ('knustre',),
'knuvl': ('knuvle',),
'knuvla': ('knuvle',),
'knuvle': ('knuvle',),
'knuvler': ('knuvle',),
'knuvles': ('knuvle',),
'knuvlet': ('knuvle',),
'kny': ('kny',),
'knydd': ('kny',),
'knydde': ('kny',),
'knyr': ('kny',),
'knys': ('kny',),
'knyst': ('knyste',),
'knysta': ('knyste',),
'knyste': ('knyste',),
'knyster': ('knyste',),
'knystes': ('knyste',),
'knystet': ('knyste',),
'knyt': ('knyte',),
'knyte': ('knyte',),
'knyter': ('knyte',),
'knytes': ('knyte',),
'knytt': ('knyte',),
'knytte': ('knyte',),
'knøyt': ('knyte',),
'knytt': ('knytte',),
'knytta': ('knytte',),
'knytte': ('knytte',),
'knytter': ('knytte',),
'knyttes': ('knytte',),
'knyttet': ('knytte',),
'koaguler': ('koagulere',),
'koagulere': ('koagulere',),
'koagulerer': ('koagulere',),
'koaguleres': ('koagulere',),
'koagulert': ('koagulere',),
'koagulerte': ('koagulere',),
'kobl': ('koble',),
'kobla': ('koble',),
'koble': ('koble',),
'kobler': ('koble',),
'kobles': ('koble',),
'koblet': ('koble',),
'kod': ('kode',),
'koda': ('kode',),
'kode': ('kode',),
'koder': ('kode',),
'kodes': ('kode',),
'kodet': ('kode',),
'kodifiser': ('kodifisere',),
'kodifisere': ('kodifisere',),
'kodifiserer': ('kodifisere',),
'kodifiseres': ('kodifisere',),
'kodifisert': ('kodifisere',),
'kodifiserte': ('kodifisere',),
'kogl': ('kogle',),
'kogla': ('kogle',),
'kogle': ('kogle',),
'kogler': ('kogle',),
'kogles': ('kogle',),
'koglet': ('kogle',),
'kok': ('koke',),
'koke': ('koke',),
'koker': ('koke',),
'kokes': ('koke',),
'kokt': ('koke',),
'kokte': ('koke',),
'koketter': ('kokettere',),
'kokettere': ('kokettere',),
'koketterer': ('kokettere',),
'koketteres': ('kokettere',),
'kokettert': ('kokettere',),
'koketterte': ('kokettere',),
'kokkeler': ('kokkelere',),
'kokkelere': ('kokkelere',),
'kokkelerer': ('kokkelere',),
'kokkeleres': ('kokkelere',),
'kokkelert': ('kokkelere',),
'kokkelerte': ('kokkelere',),
'kokkerer': ('kokkerere',),
'kokkerere': ('kokkerere',),
'kokkererer': ('kokkerere',),
'kokkereres': ('kokkerere',),
'kokkerert': ('kokkerere',),
'kokkererte': ('kokkerere',),
'kokr': ('kokre',),
'kokra': ('kokre',),
'kokre': ('kokre',),
'kokrer': ('kokre',),
'kokres': ('kokre',),
'kokret': ('kokre',),
'kol': ('kole',),
'kola': ('kole',),
'kole': ('kole',),
'koler': ('kole',),
'koles': ('kole',),
'kolet': ('kole',),
'kol': ('kole',),
'kola': ('kole',),
'kole': ('kole',),
'koler': ('kole',),
'koles': ('kole',),
'kolet': ('kole',),
'kollaber': ('kollabere',),
'kollabera': ('kollabere',),
'kollabere': ('kollabere',),
'kollaberer': ('kollabere',),
'kollaberes': ('kollabere',),
'kollaberet': ('kollabere',),
'kollaborer': ('kollaborere',),
'kollaborere': ('kollaborere',),
'kollaborerer': ('kollaborere',),
'kollaboreres': ('kollaborere',),
'kollaborert': ('kollaborere',),
'kollaborerte': ('kollaborere',),
'kollaps': ('kollapse',),
'kollapsa': ('kollapse',),
'kollapse': ('kollapse',),
'kollapser': ('kollapse',),
'kollapses': ('kollapse',),
'kollapset': ('kollapse',),
'kollasjoner': ('kollasjonere',),
'kollasjonere': ('kollasjonere',),
'kollasjonerer': ('kollasjonere',),
'kollasjoneres': ('kollasjonere',),
'kollasjonert': ('kollasjonere',),
'kollasjonerte': ('kollasjonere',),
'koll': ('kolle',),
'kolla': ('kolle',),
'kolle': ('kolle',),
'koller': ('kolle',),
'kolles': ('kolle',),
'kollet': ('kolle',),
'kollektiviser': ('kollektivisere',),
'kollektivisere': ('kollektivisere',),
'kollektiviserer': ('kollektivisere',),
'kollektiviseres': ('kollektivisere',),
'kollektivisert': ('kollektivisere',),
'kollektiviserte': ('kollektivisere',),
'kollider': ('kollidere',),
'kollidere': ('kollidere',),
'kolliderer': ('kollidere',),
'kollideres': ('kollidere',),
'kollidert': ('kollidere',),
'kolliderte': ('kollidere',),
'kollokver': ('kollokvere',),
'kollokvere': ('kollokvere',),
'kollokverer': ('kollokvere',),
'kollokveres': ('kollokvere',),
'kollokvert': ('kollokvere',),
'kollokverte': ('kollokvere',),
'kollsegl': ('kollsegle',),
'kollsegla': ('kollsegle',),
'kollsegle': ('kollsegle',),
'kollsegler': ('kollsegle',),
'kollsegles': ('kollsegle',),
'kollseglet': ('kollsegle',),
'kollseil': ('kollseile',),
'kollseile': ('kollseile',),
'kollseiler': ('kollseile',),
'kollseiles': ('kollseile',),
'kollseilt': ('kollseile',),
'kollseilte': ('kollseile',),
'koloniser': ('kolonisere',),
'kolonisere': ('kolonisere',),
'koloniserer': ('kolonisere',),
'koloniseres': ('kolonisere',),
'kolonisert': ('kolonisere',),
'koloniserte': ('kolonisere',),
'kolorer': ('kolorere',),
'kolorere': ('kolorere',),
'kolorerer': ('kolorere',),
'koloreres': ('kolorere',),
'kolorert': ('kolorere',),
'kolorerte': ('kolorere',),
'kolporter': ('kolportere',),
'kolportere': ('kolportere',),
'kolporterer': ('kolportere',),
'kolporteres': ('kolportere',),
'kolportert': ('kolportere',),
'kolporterte': ('kolportere',),
'kombiner': ('kombinere',),
'kombinere': ('kombinere',),
'kombinerer': ('kombinere',),
'kombineres': ('kombinere',),
'kombinert': ('kombinere',),
'kombinerte': ('kombinere',),
'komitébehandl': ('komitébehandle',),
'komitébehandla': ('komitébehandle',),
'komitébehandle': ('komitébehandle',),
'komitébehandler': ('komitébehandle',),
'komitébehandles': ('komitébehandle',),
'komitébehandlet': ('komitébehandle',),
'kommander': ('kommandere',),
'kommandere': ('kommandere',),
'kommanderer': ('kommandere',),
'kommanderes': ('kommandere',),
'kommandert': ('kommandere',),
'kommanderte': ('kommandere',),
'kom': ('komme',),
'komme': ('komme',),
'kommer': ('komme',),
'kommes': ('komme',),
'kommet': ('komme',),
'kommenter': ('kommentere',),
'kommentere': ('kommentere',),
'kommenterer': ('kommentere',),
'kommenteres': ('kommentere',),
'kommentert': ('kommentere',),
'kommenterte': ('kommentere',),
'kommersialiser': ('kommersialisere',),
'kommersialisere': ('kommersialisere',),
'kommersialiserer': ('kommersialisere',),
'kommersialiseres': ('kommersialisere',),
'kommersialisert': ('kommersialisere',),
'kommersialiserte': ('kommersialisere',),
'kommunaliser': ('kommunalisere',),
'kommunalisere': ('kommunalisere',),
'kommunaliserer': ('kommunalisere',),
'kommunaliseres': ('kommunalisere',),
'kommunalisert': ('kommunalisere',),
'kommunaliserte': ('kommunalisere',),
'kommuniser': ('kommunisere',),
'kommunisere': ('kommunisere',),
'kommuniserer': ('kommunisere',),
'kommuniseres': ('kommunisere',),
'kommunisert': ('kommunisere',),
'kommuniserte': ('kommunisere',),
'kommuter': ('kommutere',),
'kommutere': ('kommutere',),
'kommuterer': ('kommutere',),
'kommuteres': ('kommutere',),
'kommutert': ('kommutere',),
'kommuterte': ('kommutere',),
'komparer': ('komparere',),
'komparere': ('komparere',),
'komparerer': ('komparere',),
'kompareres': ('komparere',),
'komparert': ('komparere',),
'komparerte': ('komparere',),
'komp': ('kompe',),
'kompa': ('kompe',),
'kompe': ('kompe',),
'komper': ('kompe',),
'kompes': ('kompe',),
'kompet': ('kompe',),
'kompenser': ('kompensere',),
'kompensere': ('kompensere',),
'kompenserer': ('kompensere',),
'kompenseres': ('kompensere',),
'kompensert': ('kompensere',),
'kompenserte': ('kompensere',),
'kompiler': ('kompilere',),
'kompilere': ('kompilere',),
'kompilerer': ('kompilere',),
'kompileres': ('kompilere',),
'kompilert': ('kompilere',),
'kompilerte': ('kompilere',),
'kompletter': ('komplettere',),
'komplettere': ('komplettere',),
'kompletterer': ('komplettere',),
'kompletteres': ('komplettere',),
'komplettert': ('komplettere',),
'kompletterte': ('komplettere',),
'komplimenter': ('komplimentere',),
'komplimentere': ('komplimentere',),
'komplimenterer': ('komplimentere',),
'komplimenteres': ('komplimentere',),
'komplimentert': ('komplimentere',),
'komplimenterte': ('komplimentere',),
'kompliser': ('komplisere',),
'komplisere': ('komplisere',),
'kompliserer': ('komplisere',),
'kompliseres': ('komplisere',),
'komplisert': ('komplisere',),
'kompliserte': ('komplisere',),
'komponer': ('komponere',),
'komponere': ('komponere',),
'komponerer': ('komponere',),
'komponeres': ('komponere',),
'komponert': ('komponere',),
'komponerte': ('komponere',),
'komposter': ('kompostere',),
'kompostere': ('kompostere',),
'komposterer': ('kompostere',),
'komposteres': ('kompostere',),
'kompostert': ('kompostere',),
'komposterte': ('kompostere',),
'komprimer': ('komprimere',),
'komprimere': ('komprimere',),
'komprimerer': ('komprimere',),
'komprimeres': ('komprimere',),
'komprimert': ('komprimere',),
'komprimerte': ('komprimere',),
'kompromiss': ('kompromisse',),
'kompromissa': ('kompromisse',),
'kompromisse': ('kompromisse',),
'kompromisser': ('kompromisse',),
'kompromisses': ('kompromisse',),
'kompromisset': ('kompromisse',),
'kompromitter': ('kompromittere',),
'kompromittere': ('kompromittere',),
'kompromitterer': ('kompromittere',),
'kompromitteres': ('kompromittere',),
'kompromittert': ('kompromittere',),
'kompromitterte': ('kompromittere',),
'kondemner': ('kondemnere',),
'kondemnere': ('kondemnere',),
'kondemnerer': ('kondemnere',),
'kondemneres': ('kondemnere',),
'kondemnert': ('kondemnere',),
'kondemnerte': ('kondemnere',),
'kondenser': ('kondensere',),
'kondensere': ('kondensere',),
'kondenserer': ('kondensere',),
'kondenseres': ('kondensere',),
'kondensert': ('kondensere',),
'kondenserte': ('kondensere',),
'kondisjoner': ('kondisjonere',),
'kondisjonere': ('kondisjonere',),
'kondisjonerer': ('kondisjonere',),
'kondisjoneres': ('kondisjonere',),
'kondisjonert': ('kondisjonere',),
'kondisjonerte': ('kondisjonere',),
'kondoler': ('kondolere',),
'kondolere': ('kondolere',),
'kondolerer': ('kondolere',),
'kondoleres': ('kondolere',),
'kondolert': ('kondolere',),
'kondolerte': ('kondolere',),
'konferer': ('konferere',),
'konferere': ('konferere',),
'konfererer': ('konferere',),
'konfereres': ('konferere',),
'konferert': ('konferere',),
'konfererte': ('konferere',),
'konfirmer': ('konfirmere',),
'konfirmere': ('konfirmere',),
'konfirmerer': ('konfirmere',),
'konfirmeres': ('konfirmere',),
'konfirmert': ('konfirmere',),
'konfirmerte': ('konfirmere',),
'konfisker': ('konfiskere',),
'konfiskere': ('konfiskere',),
'konfiskerer': ('konfiskere',),
'konfiskeres': ('konfiskere',),
'konfiskert': ('konfiskere',),
'konfiskerte': ('konfiskere',),
'konfronter': ('konfrontere',),
'konfrontere': ('konfrontere',),
'konfronterer': ('konfrontere',),
'konfronteres': ('konfrontere',),
'konfrontert': ('konfrontere',),
'konfronterte': ('konfrontere',),
'kongruer': ('kongruere',),
'kongruere': ('kongruere',),
'kongruerer': ('kongruere',),
'kongrueres': ('kongruere',),
'kongruert': ('kongruere',),
'kongruerte': ('kongruere',),
'konjuger': ('konjugere',),
'konjugere': ('konjugere',),
'konjugerer': ('konjugere',),
'konjugeres': ('konjugere',),
'konjugert': ('konjugere',),
'konjugerte': ('konjugere',),
'konk': ('konke',),
'konka': ('konke',),
'konke': ('konke',),
'konker': ('konke',),
'konkes': ('konke',),
'konket': ('konke',),
'konkluder': ('konkludere',),
'konkludere': ('konkludere',),
'konkluderer': ('konkludere',),
'konkluderes': ('konkludere',),
'konkludert': ('konkludere',),
'konkluderte': ('konkludere',),
'konkretiser': ('konkretisere',),
'konkretisere': ('konkretisere',),
'konkretiserer': ('konkretisere',),
'konkretiseres': ('konkretisere',),
'konkretisert': ('konkretisere',),
'konkretiserte': ('konkretisere',),
'konkurrer': ('konkurrere',),
'konkurrere': ('konkurrere',),
'konkurrerer': ('konkurrere',),
'konkurreres': ('konkurrere',),
'konkurrert': ('konkurrere',),
'konkurrerte': ('konkurrere',),
'konnoter': ('konnotere',),
'konnotere': ('konnotere',),
'konnoterer': ('konnotere',),
'konnoteres': ('konnotere',),
'konnotert': ('konnotere',),
'konnoterte': ('konnotere',),
'konsentrer': ('konsentrere',),
'konsentrere': ('konsentrere',),
'konsentrerer': ('konsentrere',),
'konsentreres': ('konsentrere',),
'konsentrert': ('konsentrere',),
'konsentrerte': ('konsentrere',),
'konserter': ('konsertere',),
'konsertere': ('konsertere',),
'konserterer': ('konsertere',),
'konserteres': ('konsertere',),
'konsertert': ('konsertere',),
'konserterte': ('konsertere',),
'konserver': ('konservere',),
'konservere': ('konservere',),
'konserverer': ('konservere',),
'konserveres': ('konservere',),
'konservert': ('konservere',),
'konserverte': ('konservere',),
'konsigner': ('konsignere',),
'konsignere': ('konsignere',),
'konsignerer': ('konsignere',),
'konsigneres': ('konsignere',),
'konsignert': ('konsignere',),
'konsignerte': ('konsignere',),
'konsiper': ('konsipere',),
'konsipere': ('konsipere',),
'konsiperer': ('konsipere',),
'konsiperes': ('konsipere',),
'konsipert': ('konsipere',),
'konsiperte': ('konsipere',),
'konskriber': ('konskribere',),
'konskribere': ('konskribere',),
'konskriberer': ('konskribere',),
'konskriberes': ('konskribere',),
'konskribert': ('konskribere',),
'konskriberte': ('konskribere',),
'konsolider': ('konsolidere',),
'konsolidere': ('konsolidere',),
'konsoliderer': ('konsolidere',),
'konsolideres': ('konsolidere',),
'konsolidert': ('konsolidere',),
'konsoliderte': ('konsolidere',),
'konspirer': ('konspirere',),
'konspirere': ('konspirere',),
'konspirerer': ('konspirere',),
'konspireres': ('konspirere',),
'konspirert': ('konspirere',),
'konspirerte': ('konspirere',),
'konstater': ('konstatere',),
'konstatere': ('konstatere',),
'konstaterer': ('konstatere',),
'konstateres': ('konstatere',),
'konstatert': ('konstatere',),
'konstaterte': ('konstatere',),
'konstituer': ('konstituere',),
'konstituere': ('konstituere',),
'konstituerer': ('konstituere',),
'konstitueres': ('konstituere',),
'konstituert': ('konstituere',),
'konstituerte': ('konstituere',),
'konstruer': ('konstruere',),
'konstruere': ('konstruere',),
'konstruerer': ('konstruere',),
'konstrueres': ('konstruere',),
'konstruert': ('konstruere',),
'konstruerte': ('konstruere',),
'konsulter': ('konsultere',),
'konsultere': ('konsultere',),
'konsulterer': ('konsultere',),
'konsulteres': ('konsultere',),
'konsultert': ('konsultere',),
'konsulterte': ('konsultere',),
'konsumer': ('konsumere',),
'konsumere': ('konsumere',),
'konsumerer': ('konsumere',),
'konsumeres': ('konsumere',),
'konsumert': ('konsumere',),
'konsumerte': ('konsumere',),
'kontakt': ('kontakte',),
'kontakta': ('kontakte',),
'kontakte': ('kontakte',),
'kontakter': ('kontakte',),
'kontaktes': ('kontakte',),
'kontaktet': ('kontakte',),
'konter': ('kontere',),
'kontere': ('kontere',),
'konterer': ('kontere',),
'konteres': ('kontere',),
'kontert': ('kontere',),
'konterte': ('kontere',),
'kontingenter': ('kontingentere',),
'kontingentere': ('kontingentere',),
'kontingenterer': ('kontingentere',),
'kontingenteres': ('kontingentere',),
'kontingentert': ('kontingentere',),
'kontingenterte': ('kontingentere',),
'kontinuer': ('kontinuere',),
'kontinuere': ('kontinuere',),
'kontinuerer': ('kontinuere',),
'kontinueres': ('kontinuere',),
'kontinuert': ('kontinuere',),
'kontinuerte': ('kontinuere',),
'kontoriser': ('kontorisere',),
'kontorisere': ('kontorisere',),
'kontoriserer': ('kontorisere',),
'kontoriseres': ('kontorisere',),
'kontorisert': ('kontorisere',),
'kontoriserte': ('kontorisere',),
'kontraher': ('kontrahere',),
'kontrahere': ('kontrahere',),
'kontraherer': ('kontrahere',),
'kontraheres': ('kontrahere',),
'kontrahert': ('kontrahere',),
'kontraherte': ('kontrahere',),
'kontrasigner': ('kontrasignere',),
'kontrasignere': ('kontrasignere',),
'kontrasignerer': ('kontrasignere',),
'kontrasigneres': ('kontrasignere',),
'kontrasignert': ('kontrasignere',),
'kontrasignerte': ('kontrasignere',),
'kontraster': ('kontrastere',),
'kontrastere': ('kontrastere',),
'kontrasterer': ('kontrastere',),
'kontrasteres': ('kontrastere',),
'kontrastert': ('kontrastere',),
'kontrasterte': ('kontrastere',),
'kontr': ('kontre',),
'kontra': ('kontre',),
'kontre': ('kontre',),
'kontrer': ('kontre',),
'kontres': ('kontre',),
'kontret': ('kontre',),
'kontribuer': ('kontribuere',),
'kontribuere': ('kontribuere',),
'kontribuerer': ('kontribuere',),
'kontribueres': ('kontribuere',),
'kontribuert': ('kontribuere',),
'kontribuerte': ('kontribuere',),
'kontroller': ('kontrollere',),
'kontrollere': ('kontrollere',),
'kontrollerer': ('kontrollere',),
'kontrolleres': ('kontrollere',),
'kontrollert': ('kontrollere',),
'kontrollerte': ('kontrollere',),
'konverger': ('konvergere',),
'konvergere': ('konvergere',),
'konvergerer': ('konvergere',),
'konvergeres': ('konvergere',),
'konvergert': ('konvergere',),
'konvergerte': ('konvergere',),
'konverser': ('konversere',),
'konversere': ('konversere',),
'konverserer': ('konversere',),
'konverseres': ('konversere',),
'konversert': ('konversere',),
'konverserte': ('konversere',),
'konverter': ('konvertere',),
'konvertere': ('konvertere',),
'konverterer': ('konvertere',),
'konverteres': ('konvertere',),
'konvertert': ('konvertere',),
'konverterte': ('konvertere',),
'konvoier': ('konvoiere',),
'konvoiere': ('konvoiere',),
'konvoierer': ('konvoiere',),
'konvoieres': ('konvoiere',),
'konvoiert': ('konvoiere',),
'konvoierte': ('konvoiere',),
'konvolutter': ('konvoluttere',),
'konvoluttere': ('konvoluttere',),
'konvolutterer': ('konvoluttere',),
'konvolutteres': ('konvoluttere',),
'konvoluttert': ('konvoluttere',),
'konvolutterte': ('konvoluttere',),
'kooperer': ('kooperere',),
'kooperere': ('kooperere',),
'koopererer': ('kooperere',),
'koopereres': ('kooperere',),
'kooperert': ('kooperere',),
'koopererte': ('kooperere',),
'koordiner': ('koordinere',),
'koordinere': ('koordinere',),
'koordinerer': ('koordinere',),
'koordineres': ('koordinere',),
'koordinert': ('koordinere',),
'koordinerte': ('koordinere',),
'kop': ('kope',),
'kope': ('kope',),
'koper': ('kope',),
'kopes': ('kope',),
'kopt': ('kope',),
'kopte': ('kope',),
'kopier': ('kopiere',),
'kopiere': ('kopiere',),
'kopierer': ('kopiere',),
'kopieres': ('kopiere',),
'kopiert': ('kopiere',),
'kopierte': ('kopiere',),
'kopl': ('kople',),
'kopla': ('kople',),
'kople': ('kople',),
'kopler': ('kople',),
'koples': ('kople',),
'koplet': ('kople',),
'kopp': ('koppe',),
'koppa': ('koppe',),
'koppe': ('koppe',),
'kopper': ('koppe',),
'koppes': ('koppe',),
'koppet': ('koppe',),
'kopuler': ('kopulere',),
'kopulere': ('kopulere',),
'kopulerer': ('kopulere',),
'kopuleres': ('kopulere',),
'kopulert': ('kopulere',),
'kopulerte': ('kopulere',),
'kor': ('kore',),
'kora': ('kore',),
'kore': ('kore',),
'korer': ('kore',),
'kores': ('kore',),
'koret': ('kore',),
'koreografer': ('koreografere',),
'koreografere': ('koreografere',),
'koreograferer': ('koreografere',),
'koreograferes': ('koreografere',),
'koreografert': ('koreografere',),
'koreograferte': ('koreografere',),
'kork': ('korke',),
'korka': ('korke',),
'korke': ('korke',),
'korker': ('korke',),
'korkes': ('korke',),
'korket': ('korke',),
'korn': ('korne',),
'korna': ('korne',),
'korne': ('korne',),
'korner': ('korne',),
'kornes': ('korne',),
'kornet': ('korne',),
'korporativiser': ('korporativisere',),
'korporativisere': ('korporativisere',),
'korporativiserer': ('korporativisere',),
'korporativiseres': ('korporativisere',),
'korporativisert': ('korporativisere',),
'korporativiserte': ('korporativisere',),
'korresponder': ('korrespondere',),
'korrespondere': ('korrespondere',),
'korresponderer': ('korrespondere',),
'korresponderes': ('korrespondere',),
'korrespondert': ('korrespondere',),
'korresponderte': ('korrespondere',),
'korriger': ('korrigere',),
'korrigere': ('korrigere',),
'korrigerer': ('korrigere',),
'korrigeres': ('korrigere',),
'korrigert': ('korrigere',),
'korrigerte': ('korrigere',),
'korroder': ('korrodere',),
'korrodere': ('korrodere',),
'korroderer': ('korrodere',),
'korroderes': ('korrodere',),
'korrodert': ('korrodere',),
'korroderte': ('korrodere',),
'korruger': ('korrugere',),
'korrugere': ('korrugere',),
'korrugerer': ('korrugere',),
'korrugeres': ('korrugere',),
'korrugert': ('korrugere',),
'korrugerte': ('korrugere',),
'korrumper': ('korrumpere',),
'korrumpere': ('korrumpere',),
'korrumperer': ('korrumpere',),
'korrumperes': ('korrumpere',),
'korrumpert': ('korrumpere',),
'korrumperte': ('korrumpere',),
'kors': ('korse',),
'korsa': ('korse',),
'korse': ('korse',),
'korser': ('korse',),
'korses': ('korse',),
'korset': ('korse',),
'korsfest': ('korsfeste',),
'korsfesta': ('korsfeste',),
'korsfeste': ('korsfeste',),
'korsfester': ('korsfeste',),
'korsfestes': ('korsfeste',),
'korsfestet': ('korsfeste',),
'korsla': ('korslegge',),
'korslagt': ('korslegge',),
'korslegg': ('korslegge',),
'korslegge': ('korslegge',),
'korslegger': ('korslegge',),
'korslegges': ('korslegge',),
'kort': ('korte',),
'korta': ('korte',),
'korte': ('korte',),
'korter': ('korte',),
'kortes': ('korte',),
'kortet': ('korte',),
'kortn': ('kortne',),
'kortna': ('kortne',),
'kortne': ('kortne',),
'kortner': ('kortne',),
'kortnes': ('kortne',),
'kortnet': ('kortne',),
'kortslutt': ('kortslutte',),
'kortslutta': ('kortslutte',),
'kortslutte': ('kortslutte',),
'kortslutter': ('kortslutte',),
'kortsluttes': ('kortslutte',),
'kortsluttet': ('kortslutte',),
'kos': ('kose',),
'kosa': ('kose',),
'kose': ('kose',),
'koser': ('kose',),
'koses': ('kose',),
'koset': ('kose',),
'kost': ('kose',),
'koste': ('kose',),
'kost': ('koste',),
'kosta': ('koste',),
'koste': ('koste',),
'koster': ('koste',),
'kostes': ('koste',),
'kostet': ('koste',),
'kost': ('koste',),
'kosta': ('koste',),
'koste': ('koste',),
'koster': ('koste',),
'kostes': ('koste',),
'kostet': ('koste',),
'kostnadsberegn': ('kostnadsberegne',),
'kostnadsberegna': ('kostnadsberegne',),
'kostnadsberegne': ('kostnadsberegne',),
'kostnadsberegner': ('kostnadsberegne',),
'kostnadsberegnes': ('kostnadsberegne',),
'kostnadsberegnet': ('kostnadsberegne',),
'kostnadsberekn': ('kostnadsberekne',),
'kostnadsberekna': ('kostnadsberekne',),
'kostnadsberekne': ('kostnadsberekne',),
'kostnadsberekner': ('kostnadsberekne',),
'kostnadsbereknes': ('kostnadsberekne',),
'kostnadsbereknet': ('kostnadsberekne',),
'kostymer': ('kostymere',),
'kostymere': ('kostymere',),
'kostymerer': ('kostymere',),
'kostymeres': ('kostymere',),
'kostymert': ('kostymere',),
'kostymerte': ('kostymere',),
'kovn': ('kovne',),
'kovna': ('kovne',),
'kovne': ('kovne',),
'kovner': ('kovne',),
'kovnes': ('kovne',),
'kovnet': ('kovne',),
'krabb': ('krabbe',),
'krabba': ('krabbe',),
'krabbe': ('krabbe',),
'krabber': ('krabbe',),
'krabbes': ('krabbe',),
'krabbet': ('krabbe',),
'krafs': ('krafse',),
'krafsa': ('krafse',),
'krafse': ('krafse',),
'krafser': ('krafse',),
'krafses': ('krafse',),
'krafset': ('krafse',),
'krag': ('krage',),
'kraga': ('krage',),
'krage': ('krage',),
'krager': ('krage',),
'krages': ('krage',),
'kraget': ('krage',),
'krak': ('krake',),
'kraka': ('krake',),
'krake': ('krake',),
'kraker': ('krake',),
'krakes': ('krake',),
'kraket': ('krake',),
'krakeler': ('krakelere',),
'krakelere': ('krakelere',),
'krakelerer': ('krakelere',),
'krakeleres': ('krakelere',),
'krakelert': ('krakelere',),
'krakelerte': ('krakelere',),
'krakk': ('krakke',),
'krakka': ('krakke',),
'krakke': ('krakke',),
'krakker': ('krakke',),
'krakkes': ('krakke',),
'krakket': ('krakke',),
'kram': ('kramme',),
'kramma': ('kramme',),
'kramme': ('kramme',),
'krammer': ('kramme',),
'krammes': ('kramme',),
'krammet': ('kramme',),
'kram': ('kramme',),
'kramma': ('kramme',),
'kramme': ('kramme',),
'krammer': ('kramme',),
'krammes': ('kramme',),
'krammet': ('kramme',),
'krams': ('kramse',),
'kramsa': ('kramse',),
'kramse': ('kramse',),
'kramser': ('kramse',),
'kramses': ('kramse',),
'kramset': ('kramse',),
'krangl': ('krangle',),
'krangla': ('krangle',),
'krangle': ('krangle',),
'krangler': ('krangle',),
'krangles': ('krangle',),
'kranglet': ('krangle',),
'krans': ('kranse',),
'kransa': ('kranse',),
'kranse': ('kranse',),
'kranser': ('kranse',),
'kranses': ('kranse',),
'kranset': ('kranse',),
'kras': ('krase',),
'krasa': ('krase',),
'krase': ('krase',),
'kraser': ('krase',),
'krases': ('krase',),
'kraset': ('krase',),
'krast': ('krase',),
'kraste': ('krase',),
'krasj': ('krasje',),
'krasja': ('krasje',),
'krasje': ('krasje',),
'krasjer': ('krasje',),
'krasjes': ('krasje',),
'krasjet': ('krasje',),
'krasjland': ('krasjlande',),
'krasjlanda': ('krasjlande',),
'krasjlande': ('krasjlande',),
'krasjlander': ('krasjlande',),
'krasjlandes': ('krasjlande',),
'krasjlandet': ('krasjlande',),
'krasl': ('krasle',),
'krasla': ('krasle',),
'krasle': ('krasle',),
'krasler': ('krasle',),
'krasles': ('krasle',),
'kraslet': ('krasle',),
'krass': ('krasse',),
'krassa': ('krasse',),
'krasse': ('krasse',),
'krasser': ('krasse',),
'krasses': ('krasse',),
'krasset': ('krasse',),
'kraum': ('kraume',),
'krauma': ('kraume',),
'kraume': ('kraume',),
'kraumer': ('kraume',),
'kraumes': ('kraume',),
'kraumet': ('kraume',),
'krav': ('krave',),
'krava': ('krave',),
'krave': ('krave',),
'kraver': ('krave',),
'kraves': ('krave',),
'kravet': ('krave',),
'kravl': ('kravle',),
'kravla': ('kravle',),
'kravle': ('kravle',),
'kravler': ('kravle',),
'kravles': ('kravle',),
'kravlet': ('kravle',),
'krediter': ('kreditere',),
'kreditere': ('kreditere',),
'krediterer': ('kreditere',),
'krediteres': ('kreditere',),
'kreditert': ('kreditere',),
'krediterte': ('kreditere',),
'kreer': ('kreere',),
'kreere': ('kreere',),
'kreerer': ('kreere',),
'kreeres': ('kreere',),
'kreert': ('kreere',),
'kreerte': ('kreere',),
'kreist': ('kreiste',),
'kreista': ('kreiste',),
'kreiste': ('kreiste',),
'kreister': ('kreiste',),
'kreistes': ('kreiste',),
'kreistet': ('kreiste',),
'krak': ('kreke',),
'krek': ('kreke',),
'kreka': ('kreke',),
'kreke': ('kreke',),
'kreker': ('kreke',),
'krekes': ('kreke',),
'kreket': ('kreke',),
'krekt': ('kreke',),
'krekte': ('kreke',),
'kremer': ('kremere',),
'kremere': ('kremere',),
'kremerer': ('kremere',),
'kremeres': ('kremere',),
'kremert': ('kremere',),
'kremerte': ('kremere',),
'kremt': ('kremte',),
'kremta': ('kremte',),
'kremte': ('kremte',),
'kremter': ('kremte',),
'kremtes': ('kremte',),
'kremtet': ('kremte',),
'kreneler': ('krenelere',),
'krenelere': ('krenelere',),
'krenelerer': ('krenelere',),
'kreneleres': ('krenelere',),
'krenelert': ('krenelere',),
'krenelerte': ('krenelere',),
'kreng': ('krenge',),
'krenga': ('krenge',),
'krenge': ('krenge',),
'krenger': ('krenge',),
'krenges': ('krenge',),
'krenget': ('krenge',),
'krengt': ('krenge',),
'krengte': ('krenge',),
'krenk': ('krenke',),
'krenka': ('krenke',),
'krenke': ('krenke',),
'krenker': ('krenke',),
'krenkes': ('krenke',),
'krenket': ('krenke',),
'krenkt': ('krenke',),
'krenkte': ('krenke',),
'kreper': ('krepere',),
'krepere': ('krepere',),
'kreperer': ('krepere',),
'kreperes': ('krepere',),
'krepert': ('krepere',),
'kreperte': ('krepere',),
'krepp': ('kreppe',),
'kreppa': ('kreppe',),
'kreppe': ('kreppe',),
'krepper': ('kreppe',),
'kreppes': ('kreppe',),
'kreppet': ('kreppe',),
'krept': ('kreppe',),
'krepte': ('kreppe',),
'krepp': ('kreppe',),
'kreppa': ('kreppe',),
'kreppe': ('kreppe',),
'krepper': ('kreppe',),
'kreppes': ('kreppe',),
'kreppet': ('kreppe',),
'krept': ('kreppe',),
'krepte': ('kreppe',),
'kreps': ('krepse',),
'krepsa': ('krepse',),
'krepse': ('krepse',),
'krepser': ('krepse',),
'krepses': ('krepse',),
'krepset': ('krepse',),
'krets': ('kretse',),
'kretsa': ('kretse',),
'kretse': ('kretse',),
'kretser': ('kretse',),
'kretses': ('kretse',),
'kretset': ('kretse',),
'krev': ('kreve',),
'kreva': ('kreve',),
'krevd': ('kreve',),
'krevde': ('kreve',),
'kreve': ('kreve',),
'krever': ('kreve',),
'kreves': ('kreve',),
'krevet': ('kreve',),
'kribl': ('krible',),
'kribla': ('krible',),
'krible': ('krible',),
'kribler': ('krible',),
'kribles': ('krible',),
'kriblet': ('krible',),
'krig': ('krige',),
'kriga': ('krige',),
'krige': ('krige',),
'kriger': ('krige',),
'kriges': ('krige',),
'kriget': ('krige',),
'krikl': ('krikle',),
'krikla': ('krikle',),
'krikle': ('krikle',),
'krikler': ('krikle',),
'krikles': ('krikle',),
'kriklet': ('krikle',),
'krill': ('krille',),
'krilla': ('krille',),
'krille': ('krille',),
'kriller': ('krille',),
'krilles': ('krille',),
'krillet': ('krille',),
'kriminaliser': ('kriminalisere',),
'kriminalisere': ('kriminalisere',),
'kriminaliserer': ('kriminalisere',),
'kriminaliseres': ('kriminalisere',),
'kriminalisert': ('kriminalisere',),
'kriminaliserte': ('kriminalisere',),
'kringgikk': ('kringgå',),
'kringgjekk': ('kringgå',),
'kringgå': ('kringgå',),
'kringgåes': ('kringgå',),
'kringgår': ('kringgå',),
'kringgås': ('kringgå',),
'kringgått': ('kringgå',),
'kringkast': ('kringkaste',),
'kringkasta': ('kringkaste',),
'kringkaste': ('kringkaste',),
'kringkaster': ('kringkaste',),
'kringkastes': ('kringkaste',),
'kringkastet': ('kringkaste',),
'kringsatt': ('kringsette',),
'kringsatte': ('kringsette',),
'kringsett': ('kringsette',),
'kringsette': ('kringsette',),
'kringsetter': ('kringsette',),
'kringsettes': ('kringsette',),
'krins': ('krinse',),
'krinsa': ('krinse',),
'krinse': ('krinse',),
'krinser': ('krinse',),
'krinses': ('krinse',),
'krinset': ('krinse',),
'krinst': ('krinse',),
'krinste': ('krinse',),
'krisl': ('krisle',),
'krisla': ('krisle',),
'krisle': ('krisle',),
'krisler': ('krisle',),
'krisles': ('krisle',),
'krislet': ('krisle',),
'kristn': ('kristne',),
'kristna': ('kristne',),
'kristne': ('kristne',),
'kristner': ('kristne',),
'kristnes': ('kristne',),
'kristnet': ('kristne',),
'krit': ('krite',),
'krita': ('krite',),
'krite': ('krite',),
'kriter': ('krite',),
'krites': ('krite',),
'kritet': ('krite',),
'kritiser': ('kritisere',),
'kritisere': ('kritisere',),
'kritiserer': ('kritisere',),
'kritiseres': ('kritisere',),
'kritisert': ('kritisere',),
'kritiserte': ('kritisere',),
'kritl': ('kritle',),
'kritla': ('kritle',),
'kritle': ('kritle',),
'kritler': ('kritle',),
'kritles': ('kritle',),
'kritlet': ('kritle',),
'kritt': ('kritte',),
'kritta': ('kritte',),
'kritte': ('kritte',),
'kritter': ('kritte',),
'krittes': ('kritte',),
'krittet': ('kritte',),
'kro': ('kro',),
'krodd': ('kro',),
'krodde': ('kro',),
'kror': ('kro',),
'kros': ('kro',),
'krok': ('kroke',),
'kroka': ('kroke',),
'kroke': ('kroke',),
'kroker': ('kroke',),
'krokes': ('kroke',),
'kroket': ('kroke',),
'kroker': ('krokere',),
'krokere': ('krokere',),
'krokerer': ('krokere',),
'krokeres': ('krokere',),
'krokert': ('krokere',),
'krokerte': ('krokere',),
'krokker': ('krokkere',),
'krokkere': ('krokkere',),
'krokkerer': ('krokkere',),
'krokkeres': ('krokkere',),
'krokkert': ('krokkere',),
'krokkerte': ('krokkere',),
'krokn': ('krokne',),
'krokna': ('krokne',),
'krokne': ('krokne',),
'krokner': ('krokne',),
'kroknes': ('krokne',),
'kroknet': ('krokne',),
'kromgarv': ('kromgarve',),
'kromgarva': ('kromgarve',),
'kromgarve': ('kromgarve',),
'kromgarver': ('kromgarve',),
'kromgarves': ('kromgarve',),
'kromgarvet': ('kromgarve',),
'kron': ('krone',),
'krona': ('krone',),
'krone': ('krone',),
'kroner': ('krone',),
'krones': ('krone',),
'kronet': ('krone',),
'kront': ('krone',),
'kronte': ('krone',),
'kronikker': ('kronikkere',),
'kronikkere': ('kronikkere',),
'kronikkerer': ('kronikkere',),
'kronikkeres': ('kronikkere',),
'kronikkert': ('kronikkere',),
'kronikkerte': ('kronikkere',),
'kroppsvisiter': ('kroppsvisitere',),
'kroppsvisitere': ('kroppsvisitere',),
'kroppsvisiterer': ('kroppsvisitere',),
'kroppsvisiteres': ('kroppsvisitere',),
'kroppsvisitert': ('kroppsvisitere',),
'kroppsvisiterte': ('kroppsvisitere',),
'krot': ('krote',),
'krota': ('krote',),
'krote': ('krote',),
'kroter': ('krote',),
'krotes': ('krote',),
'krotet': ('krote',),
'kruk': ('kruke',),
'kruke': ('kruke',),
'kruker': ('kruke',),
'krukes': ('kruke',),
'krukt': ('kruke',),
'krukte': ('kruke',),
'kruks': ('krukse',),
'kruksa': ('krukse',),
'krukse': ('krukse',),
'krukser': ('krukse',),
'krukses': ('krukse',),
'krukset': ('krukse',),
'krull': ('krulle',),
'krulla': ('krulle',),
'krulle': ('krulle',),
'kruller': ('krulle',),
'krulles': ('krulle',),
'krullet': ('krulle',),
'krum': ('krumme',),
'krumma': ('krumme',),
'krumme': ('krumme',),
'krummer': ('krumme',),
'krummes': ('krumme',),
'krummet': ('krumme',),
'krus': ('kruse',),
'krusa': ('kruse',),
'kruse': ('kruse',),
'kruser': ('kruse',),
'kruses': ('kruse',),
'kruset': ('kruse',),
'krust': ('kruse',),
'kruste': ('kruse',),
'krusl': ('krusle',),
'krusla': ('krusle',),
'krusle': ('krusle',),
'krusler': ('krusle',),
'krusles': ('krusle',),
'kruslet': ('krusle',),
'kry': ('kry',),
'krydd': ('kry',),
'krydde': ('kry',),
'kryr': ('kry',),
'krys': ('kry',),
'krydr': ('krydre',),
'krydra': ('krydre',),
'krydre': ('krydre',),
'krydrer': ('krydre',),
'krydres': ('krydre',),
'krydret': ('krydre',),
'krymp': ('krympe',),
'krympa': ('krympe',),
'krympe': ('krympe',),
'krymper': ('krympe',),
'krympes': ('krympe',),
'krympet': ('krympe',),
'kryn': ('kryne',),
'kryne': ('kryne',),
'kryner': ('kryne',),
'krynes': ('kryne',),
'krynt': ('kryne',),
'krynte': ('kryne',),
'kraup': ('krype',),
'kryp': ('krype',),
'krype': ('krype',),
'kryper': ('krype',),
'krypes': ('krype',),
'krøp': ('krype',),
'krøpet': ('krype',),
'krøyp': ('krype',),
'krypter': ('kryptere',),
'kryptere': ('kryptere',),
'krypterer': ('kryptere',),
'krypteres': ('kryptere',),
'kryptert': ('kryptere',),
'krypterte': ('kryptere',),
'kryptifiser': ('kryptifisere',),
'kryptifisere': ('kryptifisere',),
'kryptifiserer': ('kryptifisere',),
'kryptifiseres': ('kryptifisere',),
'kryptifisert': ('kryptifisere',),
'kryptifiserte': ('kryptifisere',),
'kryss': ('krysse',),
'kryssa': ('krysse',),
'krysse': ('krysse',),
'krysser': ('krysse',),
'krysses': ('krysse',),
'krysset': ('krysse',),
'kryss': ('krysse',),
'kryssa': ('krysse',),
'krysse': ('krysse',),
'krysser': ('krysse',),
'krysses': ('krysse',),
'krysset': ('krysse',),
'kryssforhør': ('kryssforhøre',),
'kryssforhøre': ('kryssforhøre',),
'kryssforhører': ('kryssforhøre',),
'kryssforhøres': ('kryssforhøre',),
'kryssforhørt': ('kryssforhøre',),
'kryssforhørte': ('kryssforhøre',),
'kryssklipp': ('kryssklippe',),
'kryssklippa': ('kryssklippe',),
'kryssklippe': ('kryssklippe',),
'kryssklipper': ('kryssklippe',),
'kryssklippes': ('kryssklippe',),
'kryssklippet': ('kryssklippe',),
'kryssklipt': ('kryssklippe',),
'kryssklipte': ('kryssklippe',),
'krystalliser': ('krystallisere',),
'krystallisere': ('krystallisere',),
'krystalliserer': ('krystallisere',),
'krystalliseres': ('krystallisere',),
'krystallisert': ('krystallisere',),
'krystalliserte': ('krystallisere',),
'kryst': ('kryste',),
'krysta': ('kryste',),
'kryste': ('kryste',),
'kryster': ('kryste',),
'krystes': ('kryste',),
'krystet': ('kryste',),
'krål': ('kråle',),
'kråla': ('kråle',),
'kråle': ('kråle',),
'kråler': ('kråle',),
'kråles': ('kråle',),
'krålet': ('kråle',),
'krålt': ('kråle',),
'krålte': ('kråle',),
'krøk': ('krøke',),
'krøka': ('krøke',),
'krøke': ('krøke',),
'krøker': ('krøke',),
'krøkes': ('krøke',),
'krøket': ('krøke',),
'krøkt': ('krøke',),
'krøkte': ('krøke',),
'krøkn': ('krøkne',),
'krøkna': ('krøkne',),
'krøkne': ('krøkne',),
'krøkner': ('krøkne',),
'krøknes': ('krøkne',),
'krøknet': ('krøkne',),
'krøll': ('krølle',),
'krølla': ('krølle',),
'krølle': ('krølle',),
'krøller': ('krølle',),
'krølles': ('krølle',),
'krøllet': ('krølle',),
'krøpl': ('krøple',),
'krøpla': ('krøple',),
'krøple': ('krøple',),
'krøpler': ('krøple',),
'krøples': ('krøple',),
'krøplet': ('krøple',),
'krøss': ('krøsse',),
'krøssa': ('krøsse',),
'krøsse': ('krøsse',),
'krøsser': ('krøsse',),
'krøsses': ('krøsse',),
'krøsset': ('krøsse',),
'kubb': ('kubbe',),
'kubba': ('kubbe',),
'kubbe': ('kubbe',),
'kubber': ('kubbe',),
'kubbes': ('kubbe',),
'kubbet': ('kubbe',),
'kub': ('kube',),
'kuba': ('kube',),
'kube': ('kube',),
'kuber': ('kube',),
'kubes': ('kube',),
'kubet': ('kube',),
'kuber': ('kubere',),
'kubere': ('kubere',),
'kuberer': ('kubere',),
'kuberes': ('kubere',),
'kubert': ('kubere',),
'kuberte': ('kubere',),
'ku': ('kue',),
'kua': ('kue',),
'kue': ('kue',),
'kuer': ('kue',),
'kues': ('kue',),
'kuet': ('kue',),
'kujoner': ('kujonere',),
'kujonere': ('kujonere',),
'kujonerer': ('kujonere',),
'kujoneres': ('kujonere',),
'kujonert': ('kujonere',),
'kujonerte': ('kujonere',),
'kukelur': ('kukelure',),
'kukelure': ('kukelure',),
'kukelurer': ('kukelure',),
'kukelures': ('kukelure',),
'kukelurt': ('kukelure',),
'kukelurte': ('kukelure',),
'kuldslo': ('kuldslå',),
'kuldslå': ('kuldslå',),
'kuldslåes': ('kuldslå',),
'kuldslår': ('kuldslå',),
'kuldslås': ('kuldslå',),
'kuldslått': ('kuldslå',),
'kul': ('kule',),
'kula': ('kule',),
'kule': ('kule',),
'kuler': ('kule',),
'kules': ('kule',),
'kulet': ('kule',),
'kult': ('kule',),
'kulte': ('kule',),
'kul': ('kule',),
'kula': ('kule',),
'kule': ('kule',),
'kuler': ('kule',),
'kules': ('kule',),
'kulet': ('kule',),
'kult': ('kule',),
'kulte': ('kule',),
'kull-lys': ('kull-lyse',),
'kull-lyse': ('kull-lyse',),
'kull-lyser': ('kull-lyse',),
'kull-lyses': ('kull-lyse',),
'kull-lyst': ('kull-lyse',),
'kull-lyste': ('kull-lyse',),
'kullkast': ('kullkaste',),
'kullkasta': ('kullkaste',),
'kullkaste': ('kullkaste',),
'kullkaster': ('kullkaste',),
'kullkastes': ('kullkaste',),
'kullkastet': ('kullkaste',),
'kullsegl': ('kullsegle',),
'kullsegla': ('kullsegle',),
'kullsegle': ('kullsegle',),
'kullsegler': ('kullsegle',),
'kullsegles': ('kullsegle',),
'kullseglet': ('kullsegle',),
'kullseil': ('kullseile',),
'kullseile': ('kullseile',),
'kullseiler': ('kullseile',),
'kullseiles': ('kullseile',),
'kullseilt': ('kullseile',),
'kullseilte': ('kullseile',),
'kullys': ('kullyse',),
'kullyse': ('kullyse',),
'kullyser': ('kullyse',),
'kullyses': ('kullyse',),
'kullyst': ('kullyse',),
'kullyste': ('kullyse',),
'kulminer': ('kulminere',),
'kulminere': ('kulminere',),
'kulminerer': ('kulminere',),
'kulmineres': ('kulminere',),
'kulminert': ('kulminere',),
'kulminerte': ('kulminere',),
'kuls': ('kulse',),
'kulsa': ('kulse',),
'kulse': ('kulse',),
'kulser': ('kulse',),
'kulses': ('kulse',),
'kulset': ('kulse',),
'kulsk': ('kulske',),
'kulska': ('kulske',),
'kulske': ('kulske',),
'kulsker': ('kulske',),
'kulskes': ('kulske',),
'kulsket': ('kulske',),
'kult': ('kulte',),
'kulta': ('kulte',),
'kulte': ('kulte',),
'kulter': ('kulte',),
'kultes': ('kulte',),
'kultet': ('kulte',),
'kultiver': ('kultivere',),
'kultivere': ('kultivere',),
'kultiverer': ('kultivere',),
'kultiveres': ('kultivere',),
'kultivert': ('kultivere',),
'kultiverte': ('kultivere',),
'kuml': ('kumle',),
'kumla': ('kumle',),
'kumle': ('kumle',),
'kumler': ('kumle',),
'kumles': ('kumle',),
'kumlet': ('kumle',),
'kumuler': ('kumulere',),
'kumulere': ('kumulere',),
'kumulerer': ('kumulere',),
'kumuleres': ('kumulere',),
'kumulert': ('kumulere',),
'kumulerte': ('kumulere',),
'kan': ('kunne',),
'kunne': ('kunne',),
'kunnes': ('kunne',),
'kunnet': ('kunne',),
'kunngjorde': ('kunngjøre',),
'kunngjort': ('kunngjøre',),
'kunngjør': ('kunngjøre',),
'kunngjøre': ('kunngjøre',),
'kunngjøres': ('kunngjøre',),
'kuper': ('kupere',),
'kupere': ('kupere',),
'kuperer': ('kupere',),
'kuperes': ('kupere',),
'kupert': ('kupere',),
'kuperte': ('kupere',),
'kupl': ('kuple',),
'kupla': ('kuple',),
'kuple': ('kuple',),
'kupler': ('kuple',),
'kuples': ('kuple',),
'kuplet': ('kuple',),
'kupl': ('kuple',),
'kupla': ('kuple',),
'kuple': ('kuple',),
'kupler': ('kuple',),
'kuples': ('kuple',),
'kuplet': ('kuple',),
'kupp': ('kuppe',),
'kuppa': ('kuppe',),
'kuppe': ('kuppe',),
'kupper': ('kuppe',),
'kuppes': ('kuppe',),
'kuppet': ('kuppe',),
'kurer': ('kurere',),
'kurere': ('kurere',),
'kurerer': ('kurere',),
'kureres': ('kurere',),
'kurert': ('kurere',),
'kurerte': ('kurere',),
'kurr': ('kurre',),
'kurra': ('kurre',),
'kurre': ('kurre',),
'kurrer': ('kurre',),
'kurres': ('kurre',),
'kurret': ('kurre',),
'kurs': ('kurse',),
'kursa': ('kurse',),
'kurse': ('kurse',),
'kurser': ('kurse',),
'kurses': ('kurse',),
'kurset': ('kurse',),
'kurser': ('kursere',),
'kursere': ('kursere',),
'kurserer': ('kursere',),
'kurseres': ('kursere',),
'kursert': ('kursere',),
'kurserte': ('kursere',),
'kursiver': ('kursivere',),
'kursivere': ('kursivere',),
'kursiverer': ('kursivere',),
'kursiveres': ('kursivere',),
'kursivert': ('kursivere',),
'kursiverte': ('kursivere',),
'kurtiser': ('kurtisere',),
'kurtisere': ('kurtisere',),
'kurtiserer': ('kurtisere',),
'kurtiseres': ('kurtisere',),
'kurtisert': ('kurtisere',),
'kurtiserte': ('kurtisere',),
'kurv': ('kurve',),
'kurva': ('kurve',),
'kurve': ('kurve',),
'kurver': ('kurve',),
'kurves': ('kurve',),
'kurvet': ('kurve',),
'kusk': ('kuske',),
'kuska': ('kuske',),
'kuske': ('kuske',),
'kusker': ('kuske',),
'kuskes': ('kuske',),
'kusket': ('kuske',),
'kusk': ('kuske',),
'kuska': ('kuske',),
'kuske': ('kuske',),
'kusker': ('kuske',),
'kuskes': ('kuske',),
'kusket': ('kuske',),
'kust': ('kuste',),
'kusta': ('kuste',),
'kuste': ('kuste',),
'kuster': ('kuste',),
'kustes': ('kuste',),
'kustet': ('kuste',),
'kut': ('kute',),
'kuta': ('kute',),
'kute': ('kute',),
'kuter': ('kute',),
'kutes': ('kute',),
'kutet': ('kute',),
'kutt': ('kute',),
'kutte': ('kute',),
'kutt': ('kutte',),
'kutta': ('kutte',),
'kutte': ('kutte',),
'kutter': ('kutte',),
'kuttes': ('kutte',),
'kuttet': ('kutte',),
'kuv': ('kuve',),
'kuva': ('kuve',),
'kuvd': ('kuve',),
'kuvde': ('kuve',),
'kuve': ('kuve',),
'kuver': ('kuve',),
'kuves': ('kuve',),
'kuvet': ('kuve',),
'kuvend': ('kuvende',),
'kuvende': ('kuvende',),
'kuvender': ('kuvende',),
'kuvendes': ('kuvende',),
'kuvendt': ('kuvende',),
'kuvendte': ('kuvende',),
'kvadrer': ('kvadrere',),
'kvadrere': ('kvadrere',),
'kvadrerer': ('kvadrere',),
'kvadreres': ('kvadrere',),
'kvadrert': ('kvadrere',),
'kvadrerte': ('kvadrere',),
'kvakk': ('kvakke',),
'kvakka': ('kvakke',),
'kvakke': ('kvakke',),
'kvakker': ('kvakke',),
'kvakkes': ('kvakke',),
'kvakket': ('kvakke',),
'kvalifiser': ('kvalifisere',),
'kvalifisere': ('kvalifisere',),
'kvalifiserer': ('kvalifisere',),
'kvalifiseres': ('kvalifisere',),
'kvalifisert': ('kvalifisere',),
'kvalifiserte': ('kvalifisere',),
'kvamn': ('kvamne',),
'kvamna': ('kvamne',),
'kvamne': ('kvamne',),
'kvamner': ('kvamne',),
'kvamnes': ('kvamne',),
'kvamnet': ('kvamne',),
'kvantifiser': ('kvantifisere',),
'kvantifisere': ('kvantifisere',),
'kvantifiserer': ('kvantifisere',),
'kvantifiseres': ('kvantifisere',),
'kvantifisert': ('kvantifisere',),
'kvantifiserte': ('kvantifisere',),
'kvantiter': ('kvantitere',),
'kvantitere': ('kvantitere',),
'kvantiterer': ('kvantitere',),
'kvantiteres': ('kvantitere',),
'kvantitert': ('kvantitere',),
'kvantiterte': ('kvantitere',),
'kvar': ('kvare',),
'kvara': ('kvare',),
'kvare': ('kvare',),
'kvarer': ('kvare',),
'kvares': ('kvare',),
'kvaret': ('kvare',),
'kvart': ('kvare',),
'kvarte': ('kvare',),
'kvart': ('kvarte',),
'kvarta': ('kvarte',),
'kvarte': ('kvarte',),
'kvarter': ('kvarte',),
'kvartes': ('kvarte',),
'kvartet': ('kvarte',),
'kvast': ('kvaste',),
'kvasta': ('kvaste',),
'kvaste': ('kvaste',),
'kvaster': ('kvaste',),
'kvastes': ('kvaste',),
'kvastet': ('kvaste',),
'kvad': ('kvede',),
'kved': ('kvede',),
'kvede': ('kvede',),
'kveder': ('kvede',),
'kvedes': ('kvede',),
'kvedet': ('kvede',),
'kve': ('kvee',),
'kvea': ('kvee',),
'kvee': ('kvee',),
'kveer': ('kvee',),
'kvees': ('kvee',),
'kveet': ('kvee',),
'kveg': ('kvege',),
'kvega': ('kvege',),
'kvege': ('kvege',),
'kveger': ('kvege',),
'kveges': ('kvege',),
'kveget': ('kvege',),
'kveik': ('kveike',),
'kveike': ('kveike',),
'kveiker': ('kveike',),
'kveikes': ('kveike',),
'kveikt': ('kveike',),
'kveikte': ('kveike',),
'kveil': ('kveile',),
'kveila': ('kveile',),
'kveile': ('kveile',),
'kveiler': ('kveile',),
'kveiles': ('kveile',),
'kveilet': ('kveile',),
'kveilt': ('kveile',),
'kveilte': ('kveile',),
'kvakk': ('kvekke',),
'kvekk': ('kvekke',),
'kvekke': ('kvekke',),
'kvekker': ('kvekke',),
'kvekkes': ('kvekke',),
'kvekket': ('kvekke',),
'kveld': ('kvelde',),
'kvelda': ('kvelde',),
'kvelde': ('kvelde',),
'kvelder': ('kvelde',),
'kveldes': ('kvelde',),
'kveldet': ('kvelde',),
'kvalt': ('kvele',),
'kvalte': ('kvele',),
'kvel': ('kvele',),
'kvele': ('kvele',),
'kveler': ('kvele',),
'kveles': ('kvele',),
'kvelt': ('kvele',),
'kvelte': ('kvele',),
'kvelv': ('kvelve',),
'kvelva': ('kvelve',),
'kvelvd': ('kvelve',),
'kvelvde': ('kvelve',),
'kvelve': ('kvelve',),
'kvelver': ('kvelve',),
'kvelves': ('kvelve',),
'kvelvet': ('kvelve',),
'kverk': ('kverke',),
'kverka': ('kverke',),
'kverke': ('kverke',),
'kverker': ('kverke',),
'kverkes': ('kverke',),
'kverket': ('kverke',),
'kvern': ('kverne',),
'kverna': ('kverne',),
'kverne': ('kverne',),
'kverner': ('kverne',),
'kvernes': ('kverne',),
'kvernet': ('kverne',),
'kverrsatt': ('kverrsette',),
'kverrsatte': ('kverrsette',),
'kverrsett': ('kverrsette',),
'kverrsette': ('kverrsette',),
'kverrsetter': ('kverrsette',),
'kverrsettes': ('kverrsette',),
'kveruler': ('kverulere',),
'kverulere': ('kverulere',),
'kverulerer': ('kverulere',),
'kveruleres': ('kverulere',),
'kverulert': ('kverulere',),
'kverulerte': ('kverulere',),
'kverv': ('kverve',),
'kverva': ('kverve',),
'kvervd': ('kverve',),
'kvervde': ('kverve',),
'kverve': ('kverve',),
'kverver': ('kverve',),
'kverves': ('kverve',),
'kvervet': ('kverve',),
'kvarv': ('kverve',),
'kverv': ('kverve',),
'kverve': ('kverve',),
'kverver': ('kverve',),
'kverves': ('kverve',),
'kvervet': ('kverve',),
'kves': ('kvese',),
'kvese': ('kvese',),
'kveser': ('kvese',),
'kveses': ('kvese',),
'kvest': ('kvese',),
'kveste': ('kvese',),
'kvess': ('kvesse',),
'kvessa': ('kvesse',),
'kvesse': ('kvesse',),
'kvesser': ('kvesse',),
'kvesses': ('kvesse',),
'kvesset': ('kvesse',),
'kvest': ('kvesse',),
'kveste': ('kvesse',),
'kvest': ('kveste',),
'kvesta': ('kveste',),
'kveste': ('kveste',),
'kvester': ('kveste',),
'kvestes': ('kveste',),
'kvestet': ('kveste',),
'kvi': ('kvi',),
'kvia': ('kvi',),
'kvidd': ('kvi',),
'kvidde': ('kvi',),
'kviet': ('kvi',),
'kvir': ('kvi',),
'kvis': ('kvi',),
'kvi': ('kvie',),
'kvia': ('kvie',),
'kvidd': ('kvie',),
'kvidde': ('kvie',),
'kvie': ('kvie',),
'kvier': ('kvie',),
'kvies': ('kvie',),
'kviet': ('kvie',),
'kvikk': ('kvikke',),
'kvikka': ('kvikke',),
'kvikke': ('kvikke',),
'kvikker': ('kvikke',),
'kvikkes': ('kvikke',),
'kvikket': ('kvikke',),
'kvikn': ('kvikne',),
'kvikna': ('kvikne',),
'kvikne': ('kvikne',),
'kvikner': ('kvikne',),
'kviknes': ('kvikne',),
'kviknet': ('kvikne',),
'kvil': ('kvile',),
'kvile': ('kvile',),
'kviler': ('kvile',),
'kviles': ('kvile',),
'kvilt': ('kvile',),
'kvilte': ('kvile',),
'kvein': ('kvine',),
'kvin': ('kvine',),
'kvine': ('kvine',),
'kviner': ('kvine',),
'kvines': ('kvine',),
'kvint': ('kvine',),
'kvinte': ('kvine',),
'kvink': ('kvinke',),
'kvinka': ('kvinke',),
'kvinke': ('kvinke',),
'kvinker': ('kvinke',),
'kvinkes': ('kvinke',),
'kvinket': ('kvinke',),
'kviskr': ('kviskre',),
'kviskra': ('kviskre',),
'kviskre': ('kviskre',),
'kviskrer': ('kviskre',),
'kviskres': ('kviskre',),
'kviskret': ('kviskre',),
'kviskr': ('kviskre',),
'kviskra': ('kviskre',),
'kviskre': ('kviskre',),
'kviskrer': ('kviskre',),
'kviskres': ('kviskre',),
'kviskret': ('kviskre',),
'kvisl': ('kvisle',),
'kvisla': ('kvisle',),
'kvisle': ('kvisle',),
'kvisler': ('kvisle',),
'kvisles': ('kvisle',),
'kvislet': ('kvisle',),
'kvist': ('kviste',),
'kvista': ('kviste',),
'kviste': ('kviste',),
'kvister': ('kviste',),
'kvistes': ('kviste',),
'kvistet': ('kviste',),
'kvit': ('kvite',),
'kvita': ('kvite',),
'kvite': ('kvite',),
'kviter': ('kvite',),
'kvites': ('kvite',),
'kvitet': ('kvite',),
'kvitkalk': ('kvitkalke',),
'kvitkalka': ('kvitkalke',),
'kvitkalke': ('kvitkalke',),
'kvitkalker': ('kvitkalke',),
'kvitkalkes': ('kvitkalke',),
'kvitkalket': ('kvitkalke',),
'kvitn': ('kvitne',),
'kvitna': ('kvitne',),
'kvitne': ('kvitne',),
'kvitner': ('kvitne',),
'kvitnes': ('kvitne',),
'kvitnet': ('kvitne',),
'kvitr': ('kvitre',),
'kvitra': ('kvitre',),
'kvitre': ('kvitre',),
'kvitrer': ('kvitre',),
'kvitres': ('kvitre',),
'kvitret': ('kvitre',),
'kvitt': ('kvitte',),
'kvitta': ('kvitte',),
'kvitte': ('kvitte',),
'kvitter': ('kvitte',),
'kvittes': ('kvitte',),
'kvittet': ('kvitte',),
'kvitter': ('kvittere',),
'kvittere': ('kvittere',),
'kvitterer': ('kvittere',),
'kvitteres': ('kvittere',),
'kvittert': ('kvittere',),
'kvitterte': ('kvittere',),
'kvitvask': ('kvitvaske',),
'kvitvaska': ('kvitvaske',),
'kvitvaske': ('kvitvaske',),
'kvitvasker': ('kvitvaske',),
'kvitvaskes': ('kvitvaske',),
'kvitvasket': ('kvitvaske',),
'kvoter': ('kvotere',),
'kvotere': ('kvotere',),
'kvoterer': ('kvotere',),
'kvoteres': ('kvotere',),
'kvotert': ('kvotere',),
'kvoterte': ('kvotere',),
'kvæv': ('kvæve',),
'kvævd': ('kvæve',),
'kvævde': ('kvæve',),
'kvæve': ('kvæve',),
'kvæver': ('kvæve',),
'kvæves': ('kvæve',),
'kyl': ('kyle',),
'kyle': ('kyle',),
'kyler': ('kyle',),
'kyles': ('kyle',),
'kylt': ('kyle',),
'kylte': ('kyle',),
'kyll': ('kylle',),
'kylle': ('kylle',),
'kyller': ('kylle',),
'kylles': ('kylle',),
'kylt': ('kylle',),
'kylte': ('kylle',),
'kyss': ('kysse',),
'kyssa': ('kysse',),
'kysse': ('kysse',),
'kysser': ('kysse',),
'kysses': ('kysse',),
'kysset': ('kysse',),
'kyst': ('kysse',),
'kyste': ('kysse',),
'kyt': ('kyte',),
'kyte': ('kyte',),
'kyter': ('kyte',),
'kytes': ('kyte',),
'kytt': ('kyte',),
'kytte': ('kyte',),
'køyt': ('kyte',),
'kå': ('kå',),
'kådd': ('kå',),
'kådde': ('kå',),
'kår': ('kå',),
'kås': ('kå',),
'kål': ('kåle',),
'kåla': ('kåle',),
'kåle': ('kåle',),
'kåler': ('kåle',),
'kåles': ('kåle',),
'kålet': ('kåle',),
'kår': ('kåre',),
'kåra': ('kåre',),
'kåre': ('kåre',),
'kårer': ('kåre',),
'kåres': ('kåre',),
'kåret': ('kåre',),
'kår': ('kåre',),
'kåra': ('kåre',),
'kåre': ('kåre',),
'kårer': ('kåre',),
'kåres': ('kåre',),
'kåret': ('kåre',),
'kåser': ('kåsere',),
'kåsere': ('kåsere',),
'kåserer': ('kåsere',),
'kåseres': ('kåsere',),
'kåsert': ('kåsere',),
'kåserte': ('kåsere',),
'kødd': ('kødde',),
'kødda': ('kødde',),
'kødde': ('kødde',),
'kødder': ('kødde',),
'køddes': ('kødde',),
'køddet': ('kødde',),
'kø': ('køe',),
'køa': ('køe',),
'køe': ('køe',),
'køer': ('køe',),
'køes': ('køe',),
'køet': ('køe',),
'køy': ('køye',),
'køya': ('køye',),
'køye': ('køye',),
'køyer': ('køye',),
'køyes': ('køye',),
'køyet': ('køye',),
'labb': ('labbe',),
'labba': ('labbe',),
'labbe': ('labbe',),
'labber': ('labbe',),
'labbes': ('labbe',),
'labbet': ('labbe',),
'labialiser': ('labialisere',),
'labialisere': ('labialisere',),
'labialiserer': ('labialisere',),
'labialiseres': ('labialisere',),
'labialisert': ('labialisere',),
'labialiserte': ('labialisere',),
'lad': ('lade',),
'lada': ('lade',),
'ladd': ('lade',),
'ladde': ('lade',),
'lade': ('lade',),
'lader': ('lade',),
'lades': ('lade',),
'ladet': ('lade',),
'laft': ('lafte',),
'lafta': ('lafte',),
'lafte': ('lafte',),
'lafter': ('lafte',),
'laftes': ('lafte',),
'laftet': ('lafte',),
'lag': ('lage',),
'laga': ('lage',),
'lagd': ('lage',),
'lagde': ('lage',),
'lage': ('lage',),
'lager': ('lage',),
'lages': ('lage',),
'laget': ('lage',),
'lagerfør': ('lagerføre',),
'lagerføre': ('lagerføre',),
'lagerfører': ('lagerføre',),
'lagerføres': ('lagerføre',),
'lagerført': ('lagerføre',),
'lagerførte': ('lagerføre',),
'lagg': ('lagge',),
'lagga': ('lagge',),
'lagge': ('lagge',),
'lagger': ('lagge',),
'lagges': ('lagge',),
'lagget': ('lagge',),
'lagr': ('lagre',),
'lagra': ('lagre',),
'lagre': ('lagre',),
'lagrer': ('lagre',),
'lagres': ('lagre',),
'lagret': ('lagre',),
'lak': ('lake',),
'laka': ('lake',),
'lake': ('lake',),
'laker': ('lake',),
'lakes': ('lake',),
'laket': ('lake',),
'lakk': ('lakke',),
'lakka': ('lakke',),
'lakke': ('lakke',),
'lakker': ('lakke',),
'lakkes': ('lakke',),
'lakket': ('lakke',),
'lakk': ('lakke',),
'lakka': ('lakke',),
'lakke': ('lakke',),
'lakker': ('lakke',),
'lakkes': ('lakke',),
'lakket': ('lakke',),
'lakker': ('lakkere',),
'lakkere': ('lakkere',),
'lakkerer': ('lakkere',),
'lakkeres': ('lakkere',),
'lakkert': ('lakkere',),
'lakkerte': ('lakkere',),
'lakser': ('laksere',),
'laksere': ('laksere',),
'lakserer': ('laksere',),
'lakseres': ('laksere',),
'laksert': ('laksere',),
'lakserte': ('laksere',),
'lal': ('lale',),
'lala': ('lale',),
'lale': ('lale',),
'laler': ('lale',),
'lales': ('lale',),
'lalet': ('lale',),
'lall': ('lalle',),
'lalla': ('lalle',),
'lalle': ('lalle',),
'laller': ('lalle',),
'lalles': ('lalle',),
'lallet': ('lalle',),
'laminer': ('laminere',),
'laminere': ('laminere',),
'laminerer': ('laminere',),
'lamineres': ('laminere',),
'laminert': ('laminere',),
'laminerte': ('laminere',),
'lam': ('lamme',),
'lamma': ('lamme',),
'lamme': ('lamme',),
'lammer': ('lamme',),
'lammes': ('lamme',),
'lammet': ('lamme',),
'lam': ('lamme',),
'lamma': ('lamme',),
'lamme': ('lamme',),
'lammer': ('lamme',),
'lammes': ('lamme',),
'lammet': ('lamme',),
'lam': ('lamme',),
'lamma': ('lamme',),
'lamme': ('lamme',),
'lammer': ('lamme',),
'lammes': ('lamme',),
'lammet': ('lamme',),
'lamslo': ('lamslå',),
'lamslå': ('lamslå',),
'lamslåes': ('lamslå',),
'lamslår': ('lamslå',),
'lamslås': ('lamslå',),
'lamslått': ('lamslå',),
'land': ('lande',),
'landa': ('lande',),
'lande': ('lande',),
'lander': ('lande',),
'landes': ('lande',),
'landet': ('lande',),
'land': ('lande',),
'landa': ('lande',),
'lande': ('lande',),
'lander': ('lande',),
'landes': ('lande',),
'landet': ('lande',),
'landsatt': ('landsette',),
'landsatte': ('landsette',),
'landsett': ('landsette',),
'landsette': ('landsette',),
'landsetter': ('landsette',),
'landsettes': ('landsette',),
'landsforvis': ('landsforvise',),
'landsforvise': ('landsforvise',),
'landsforviser': ('landsforvise',),
'landsforvises': ('landsforvise',),
'landsforvist': ('landsforvise',),
'landsforviste': ('landsforvise',),
'lang': ('lange',),
'langa': ('lange',),
'lange': ('lange',),
'langer': ('lange',),
'langes': ('lange',),
'langet': ('lange',),
'lanser': ('lansere',),
'lansere': ('lansere',),
'lanserer': ('lansere',),
'lanseres': ('lansere',),
'lansert': ('lansere',),
'lanserte': ('lansere',),
'lapp': ('lappe',),
'lappa': ('lappe',),
'lappe': ('lappe',),
'lapper': ('lappe',),
'lappes': ('lappe',),
'lappet': ('lappe',),
'larm': ('larme',),
'larma': ('larme',),
'larme': ('larme',),
'larmer': ('larme',),
'larmes': ('larme',),
'larmet': ('larme',),
'laser': ('lasere',),
'lasere': ('lasere',),
'laserer': ('lasere',),
'laseres': ('lasere',),
'lasert': ('lasere',),
'laserte': ('lasere',),
'lask': ('laske',),
'laska': ('laske',),
'laske': ('laske',),
'lasker': ('laske',),
'laskes': ('laske',),
'lasket': ('laske',),
'last': ('laste',),
'lasta': ('laste',),
'laste': ('laste',),
'laster': ('laste',),
'lastes': ('laste',),
'lastet': ('laste',),
'last': ('laste',),
'lasta': ('laste',),
'laste': ('laste',),
'laster': ('laste',),
'lastes': ('laste',),
'lastet': ('laste',),
'lat': ('late',),
'lata': ('late',),
'late': ('late',),
'later': ('late',),
'lates': ('late',),
'latet': ('late',),
'lat': ('late',),
'late': ('late',),
'later': ('late',),
'lates': ('late',),
'latt': ('late',),
'lot': ('late',),
'latiniser': ('latinisere',),
'latinisere': ('latinisere',),
'latiniserer': ('latinisere',),
'latiniseres': ('latinisere',),
'latinisert': ('latinisere',),
'latiniserte': ('latinisere',),
'latterliggjorde': ('latterliggjøre',),
'latterliggjort': ('latterliggjøre',),
'latterliggjør': ('latterliggjøre',),
'latterliggjøre': ('latterliggjøre',),
'latterliggjøres': ('latterliggjøre',),
'laug': ('lauge',),
'lauga': ('lauge',),
'lauge': ('lauge',),
'lauger': ('lauge',),
'lauges': ('lauge',),
'lauget': ('lauge',),
'lausga': ('lausgi',),
'lausgav': ('lausgi',),
'lausgi': ('lausgi',),
'lausgies': ('lausgi',),
'lausgir': ('lausgi',),
'lausgis': ('lausgi',),
'lausgitt': ('lausgi',),
'lausgjorde': ('lausgjøre',),
'lausgjort': ('lausgjøre',),
'lausgjør': ('lausgjøre',),
'lausgjøre': ('lausgjøre',),
'lausgjøres': ('lausgjøre',),
'lauv': ('lauve',),
'lauva': ('lauve',),
'lauve': ('lauve',),
'lauver': ('lauve',),
'lauves': ('lauve',),
'lauvet': ('lauve',),
'lav': ('lave',),
'lava': ('lave',),
'lavd': ('lave',),
'lavde': ('lave',),
'lave': ('lave',),
'laver': ('lave',),
'laves': ('lave',),
'lavet': ('lave',),
'layout': ('layoute',),
'layouta': ('layoute',),
'layoute': ('layoute',),
'layouter': ('layoute',),
'layoutes': ('layoute',),
'layoutet': ('layoute',),
'le': ('le',),
'ledd': ('le',),
'ler': ('le',),
'les': ('le',),
'lo': ('le',),
'leas': ('lease',),
'leasa': ('lease',),
'lease': ('lease',),
'leaser': ('lease',),
'leases': ('lease',),
'leaset': ('lease',),
'ledd': ('ledde',),
'ledda': ('ledde',),
'ledde': ('ledde',),
'ledder': ('ledde',),
'leddes': ('ledde',),
'leddet': ('ledde',),
'led': ('lede',),
'leda': ('lede',),
'lede': ('lede',),
'leder': ('lede',),
'ledes': ('lede',),
'ledet': ('lede',),
'lededes': ('ledes',),
'ledes': ('ledes',),
'ledsag': ('ledsage',),
'ledsaga': ('ledsage',),
'ledsage': ('ledsage',),
'ledsager': ('ledsage',),
'ledsages': ('ledsage',),
'ledsaget': ('ledsage',),
'le': ('lee',),
'lea': ('lee',),
'lee': ('lee',),
'leer': ('lee',),
'lees': ('lee',),
'leet': ('lee',),
'lefl': ('lefle',),
'lefla': ('lefle',),
'lefle': ('lefle',),
'lefler': ('lefle',),
'lefles': ('lefle',),
'leflet': ('lefle',),
'legaliser': ('legalisere',),
'legalisere': ('legalisere',),
'legaliserer': ('legalisere',),
'legaliseres': ('legalisere',),
'legalisert': ('legalisere',),
'legaliserte': ('legalisere',),
'leg': ('lege',),
'lega': ('lege',),
'lege': ('lege',),
'leger': ('lege',),
'leges': ('lege',),
'leget': ('lege',),
'legt': ('lege',),
'legte': ('lege',),
'legemliggjorde': ('legemliggjøre',),
'legemliggjort': ('legemliggjøre',),
'legemliggjør': ('legemliggjøre',),
'legemliggjøre': ('legemliggjøre',),
'legemliggjøres': ('legemliggjøre',),
'leger': ('legere',),
'legere': ('legere',),
'legerer': ('legere',),
'legeres': ('legere',),
'legert': ('legere',),
'legerte': ('legere',),
'la': ('legge',),
'lagt': ('legge',),
'legg': ('legge',),
'legge': ('legge',),
'legger': ('legge',),
'legges': ('legge',),
'legitimer': ('legitimere',),
'legitimere': ('legitimere',),
'legitimerer': ('legitimere',),
'legitimeres': ('legitimere',),
'legitimert': ('legitimere',),
'legitimerte': ('legitimere',),
'leiddes': ('leies',),
'leides': ('leies',),
'leies': ('leies',),
'leir': ('leire',),
'leira': ('leire',),
'leire': ('leire',),
'leirer': ('leire',),
'leires': ('leire',),
'leiret': ('leire',),
'leir': ('leire',),
'leira': ('leire',),
'leire': ('leire',),
'leirer': ('leire',),
'leires': ('leire',),
'leiret': ('leire',),
'leiv': ('leive',),
'leivd': ('leive',),
'leivde': ('leive',),
'leive': ('leive',),
'leiver': ('leive',),
'leives': ('leive',),
'lek': ('leke',),
'leke': ('leke',),
'leker': ('leke',),
'lekes': ('leke',),
'lekt': ('leke',),
'lekte': ('leke',),
'lakk': ('lekke',),
'lekk': ('lekke',),
'lekka': ('lekke',),
'lekke': ('lekke',),
'lekker': ('lekke',),
'lekkes': ('lekke',),
'lekket': ('lekke',),
'lekt': ('lekke',),
'lekte': ('lekke',),
'lekr': ('lekre',),
'lekra': ('lekre',),
'lekre': ('lekre',),
'lekrer': ('lekre',),
'lekres': ('lekre',),
'lekret': ('lekre',),
'leks': ('lekse',),
'leksa': ('lekse',),
'lekse': ('lekse',),
'lekser': ('lekse',),
'lekses': ('lekse',),
'lekset': ('lekse',),
'lekt': ('lekte',),
'lekta': ('lekte',),
'lekte': ('lekte',),
'lekter': ('lekte',),
'lektes': ('lekte',),
'lektet': ('lekte',),
'lemlest': ('lemleste',),
'lemlesta': ('lemleste',),
'lemleste': ('lemleste',),
'lemlester': ('lemleste',),
'lemlestes': ('lemleste',),
'lemlestet': ('lemleste',),
'lemmatiser': ('lemmatisere',),
'lemmatisere': ('lemmatisere',),
'lemmatiserer': ('lemmatisere',),
'lemmatiseres': ('lemmatisere',),
'lemmatisert': ('lemmatisere',),
'lemmatiserte': ('lemmatisere',),
'lem': ('lemme',),
'lemma': ('lemme',),
'lemme': ('lemme',),
'lemmer': ('lemme',),
'lemmes': ('lemme',),
'lemmet': ('lemme',),
'lem': ('lemme',),
'lemma': ('lemme',),
'lemme': ('lemme',),
'lemmer': ('lemme',),
'lemmes': ('lemme',),
'lemmet': ('lemme',),
'lem': ('lemme',),
'lemma': ('lemme',),
'lemme': ('lemme',),
'lemmer': ('lemme',),
'lemmes': ('lemme',),
'lemmet': ('lemme',),
'lemp': ('lempe',),
'lempa': ('lempe',),
'lempe': ('lempe',),
'lemper': ('lempe',),
'lempes': ('lempe',),
'lempet': ('lempe',),
'lemstr': ('lemstre',),
'lemstra': ('lemstre',),
'lemstre': ('lemstre',),
'lemstrer': ('lemstre',),
'lemstres': ('lemstre',),
'lemstret': ('lemstre',),
'len': ('lene',),
'lena': ('lene',),
'lene': ('lene',),
'lener': ('lene',),
'lenes': ('lene',),
'lenet': ('lene',),
'lent': ('lene',),
'lente': ('lene',),
'lenges': ('lenges',),
'lengtes': ('lenges',),
'lenges': ('lenges',),
'lengtes': ('lenges',),
'lengt': ('lengte',),
'lengta': ('lengte',),
'lengte': ('lengte',),
'lengter': ('lengte',),
'lengtes': ('lengte',),
'lengtet': ('lengte',),
'lenk': ('lenke',),
'lenka': ('lenke',),
'lenke': ('lenke',),
'lenker': ('lenke',),
'lenkes': ('lenke',),
'lenket': ('lenke',),
'lens': ('lense',),
'lensa': ('lense',),
'lense': ('lense',),
'lenser': ('lense',),
'lenses': ('lense',),
'lenset': ('lense',),
'lens': ('lense',),
'lensa': ('lense',),
'lense': ('lense',),
'lenser': ('lense',),
'lenses': ('lense',),
'lenset': ('lense',),
'lep': ('lepe',),
'lepe': ('lepe',),
'leper': ('lepe',),
'lepes': ('lepe',),
'lept': ('lepe',),
'lepte': ('lepe',),
'lepj': ('lepje',),
'lepja': ('lepje',),
'lepje': ('lepje',),
'lepjer': ('lepje',),
'lepjes': ('lepje',),
'lepjet': ('lepje',),
'les': ('lese',),
'lese': ('lese',),
'leser': ('lese',),
'leses': ('lese',),
'lest': ('lese',),
'leste': ('lese',),
'lesk': ('leske',),
'leska': ('leske',),
'leske': ('leske',),
'lesker': ('leske',),
'leskes': ('leske',),
'lesket': ('leske',),
'lesp': ('lespe',),
'lespa': ('lespe',),
'lespe': ('lespe',),
'lesper': ('lespe',),
'lespes': ('lespe',),
'lespet': ('lespe',),
'less': ('less',),
'less': ('less',),
'less': ('lesse',),
'lessa': ('lesse',),
'lesse': ('lesse',),
'lesser': ('lesse',),
'lesses': ('lesse',),
'lesset': ('lesse',),
'lest': ('lesse',),
'leste': ('lesse',),
'lest': ('lest',),
'lest': ('lest',),
'let': ('lete',),
'lete': ('lete',),
'leter': ('lete',),
'letes': ('lete',),
'lett': ('lete',),
'lette': ('lete',),
'letn': ('letne',),
'letna': ('letne',),
'letne': ('letne',),
'letner': ('letne',),
'letnes': ('letne',),
'letnet': ('letne',),
'lett': ('lette',),
'letta': ('lette',),
'lette': ('lette',),
'letter': ('lette',),
'lettes': ('lette',),
'lettet': ('lette',),
'lev': ('leve',),
'levd': ('leve',),
'levde': ('leve',),
'leve': ('leve',),
'lever': ('leve',),
'leves': ('leve',),
'levet': ('leve',),
'levendegjorde': ('levendegjøre',),
'levendegjort': ('levendegjøre',),
'levendegjør': ('levendegjøre',),
'levendegjøre': ('levendegjøre',),
'levendegjøres': ('levendegjøre',),
'lever': ('levere',),
'levere': ('levere',),
'leverer': ('levere',),
'leveres': ('levere',),
'levert': ('levere',),
'leverte': ('levere',),
'levn': ('levne',),
'levna': ('levne',),
'levne': ('levne',),
'levner': ('levne',),
'levnes': ('levne',),
'levnet': ('levne',),
'levr': ('levre',),
'levra': ('levre',),
'levre': ('levre',),
'levrer': ('levre',),
'levres': ('levre',),
'levret': ('levre',),
'led': ('li',),
'lei': ('li',),
'leid': ('li',),
'li': ('li',),
'lidd': ('li',),
'lidde': ('li',),
'lir': ('li',),
'lis': ('li',),
'led': ('li',),
'lei': ('li',),
'leid': ('li',),
'li': ('li',),
'lidd': ('li',),
'lidde': ('li',),
'lir': ('li',),
'lis': ('li',),
'liberaliser': ('liberalisere',),
'liberalisere': ('liberalisere',),
'liberaliserer': ('liberalisere',),
'liberaliseres': ('liberalisere',),
'liberalisert': ('liberalisere',),
'liberaliserte': ('liberalisere',),
'led': ('lide',),
'lei': ('lide',),
'leid': ('lide',),
'lid': ('lide',),
'lidd': ('lide',),
'lide': ('lide',),
'lider': ('lide',),
'lides': ('lide',),
'lidt': ('lide',),
'ligg': ('ligge',),
'ligge': ('ligge',),
'ligger': ('ligge',),
'ligges': ('ligge',),
'ligget': ('ligge',),
'lå': ('ligge',),
'låg': ('ligge',),
'lign': ('ligne',),
'ligna': ('ligne',),
'ligne': ('ligne',),
'ligner': ('ligne',),
'lignes': ('ligne',),
'lignet': ('ligne',),
'lignifiser': ('lignifisere',),
'lignifisere': ('lignifisere',),
'lignifiserer': ('lignifisere',),
'lignifiseres': ('lignifisere',),
'lignifisert': ('lignifisere',),
'lignifiserte': ('lignifisere',),
'lik': ('like',),
'like': ('like',),
'liker': ('like',),
'likes': ('like',),
'likt': ('like',),
'likte': ('like',),
'lik': ('like',),
'lika': ('like',),
'like': ('like',),
'liker': ('like',),
'likes': ('like',),
'liket': ('like',),
'likt': ('like',),
'likte': ('like',),
'likerett': ('likerette',),
'likeretta': ('likerette',),
'likerette': ('likerette',),
'likeretter': ('likerette',),
'likerettes': ('likerette',),
'likerettet': ('likerette',),
'likestill': ('likestille',),
'likestille': ('likestille',),
'likestiller': ('likestille',),
'likestilles': ('likestille',),
'likestilt': ('likestille',),
'likestilte': ('likestille',),
'likn': ('likne',),
'likna': ('likne',),
'likne': ('likne',),
'likner': ('likne',),
'liknes': ('likne',),
'liknet': ('likne',),
'likvider': ('likvidere',),
'likvidere': ('likvidere',),
'likviderer': ('likvidere',),
'likvideres': ('likvidere',),
'likvidert': ('likvidere',),
'likviderte': ('likvidere',),
'lim': ('lime',),
'lima': ('lime',),
'lime': ('lime',),
'limer': ('lime',),
'limes': ('lime',),
'limet': ('lime',),
'limt': ('lime',),
'limte': ('lime',),
'lind': ('linde',),
'linda': ('linde',),
'linde': ('linde',),
'linder': ('linde',),
'lindes': ('linde',),
'lindet': ('linde',),
'lindr': ('lindre',),
'lindra': ('lindre',),
'lindre': ('lindre',),
'lindrer': ('lindre',),
'lindres': ('lindre',),
'lindret': ('lindre',),
'linjer': ('linjere',),
'linjere': ('linjere',),
'linjerer': ('linjere',),
'linjeres': ('linjere',),
'linjert': ('linjere',),
'linjerte': ('linjere',),
'linn': ('linne',),
'linna': ('linne',),
'linne': ('linne',),
'linner': ('linne',),
'linnes': ('linne',),
'linnet': ('linne',),
'linnkok': ('linnkoke',),
'linnkoke': ('linnkoke',),
'linnkoker': ('linnkoke',),
'linnkokes': ('linnkoke',),
'linnkokt': ('linnkoke',),
'linnkokte': ('linnkoke',),
'linnsalt': ('linnsalte',),
'linnsalta': ('linnsalte',),
'linnsalte': ('linnsalte',),
'linnsalter': ('linnsalte',),
'linnsaltes': ('linnsalte',),
'linnsaltet': ('linnsalte',),
'lir': ('lire',),
'lira': ('lire',),
'lire': ('lire',),
'lirer': ('lire',),
'lires': ('lire',),
'liret': ('lire',),
'lirt': ('lire',),
'lirte': ('lire',),
'lirk': ('lirke',),
'lirka': ('lirke',),
'lirke': ('lirke',),
'lirker': ('lirke',),
'lirkes': ('lirke',),
'lirket': ('lirke',),
'lisensier': ('lisensiere',),
'lisensiere': ('lisensiere',),
'lisensierer': ('lisensiere',),
'lisensieres': ('lisensiere',),
'lisensiert': ('lisensiere',),
'lisensierte': ('lisensiere',),
'lisiter': ('lisitere',),
'lisitere': ('lisitere',),
'lisiterer': ('lisitere',),
'lisiteres': ('lisitere',),
'lisitert': ('lisitere',),
'lisiterte': ('lisitere',),
'liss': ('lisse',),
'lissa': ('lisse',),
'lisse': ('lisse',),
'lisser': ('lisse',),
'lisses': ('lisse',),
'lisset': ('lisse',),
'list': ('liste',),
'lista': ('liste',),
'liste': ('liste',),
'lister': ('liste',),
'listes': ('liste',),
'listet': ('liste',),
'list': ('liste',),
'lista': ('liste',),
'liste': ('liste',),
'lister': ('liste',),
'listes': ('liste',),
'listet': ('liste',),
'list': ('liste',),
'lista': ('liste',),
'liste': ('liste',),
'lister': ('liste',),
'listes': ('liste',),
'listet': ('liste',),
'leit': ('lite',),
'let': ('lite',),
'lit': ('lite',),
'lite': ('lite',),
'liter': ('lite',),
'lites': ('lite',),
'litt': ('lite',),
'litografer': ('litografere',),
'litografere': ('litografere',),
'litograferer': ('litografere',),
'litograferes': ('litografere',),
'litografert': ('litografere',),
'litograferte': ('litografere',),
'livberg': ('livberge',),
'livberga': ('livberge',),
'livberge': ('livberge',),
'livberger': ('livberge',),
'livberges': ('livberge',),
'livberget': ('livberge',),
'liv': ('live',),
'liva': ('live',),
'live': ('live',),
'liver': ('live',),
'lives': ('live',),
'livet': ('live',),
'liv': ('live',),
'livd': ('live',),
'livde': ('live',),
'live': ('live',),
'liver': ('live',),
'lives': ('live',),
'livn': ('livne',),
'livna': ('livne',),
'livne': ('livne',),
'livner': ('livne',),
'livnes': ('livne',),
'livnet': ('livne',),
'livnær': ('livnære',),
'livnæra': ('livnære',),
'livnære': ('livnære',),
'livnærer': ('livnære',),
'livnæres': ('livnære',),
'livnæret': ('livnære',),
'livnært': ('livnære',),
'livnærte': ('livnære',),
'livsforsikr': ('livsforsikre',),
'livsforsikra': ('livsforsikre',),
'livsforsikre': ('livsforsikre',),
'livsforsikrer': ('livsforsikre',),
'livsforsikres': ('livsforsikre',),
'livsforsikret': ('livsforsikre',),
'ljom': ('ljome',),
'ljoma': ('ljome',),
'ljome': ('ljome',),
'ljomer': ('ljome',),
'ljomes': ('ljome',),
'ljomet': ('ljome',),
'laug': ('ljuge',),
'ljug': ('ljuge',),
'ljugd': ('ljuge',),
'ljugde': ('ljuge',),
'ljuge': ('ljuge',),
'ljuger': ('ljuge',),
'ljuges': ('ljuge',),
'løy': ('ljuge',),
'løyet': ('ljuge',),
'laug': ('ljuge',),
'ljug': ('ljuge',),
'ljugd': ('ljuge',),
'ljugde': ('ljuge',),
'ljuge': ('ljuge',),
'ljuger': ('ljuge',),
'ljuges': ('ljuge',),
'løy': ('ljuge',),
'løyet': ('ljuge',),
'lobb': ('lobbe',),
'lobba': ('lobbe',),
'lobbe': ('lobbe',),
'lobber': ('lobbe',),
'lobbes': ('lobbe',),
'lobbet': ('lobbe',),
'lodd': ('lodde',),
'lodda': ('lodde',),
'lodde': ('lodde',),
'lodder': ('lodde',),
'loddes': ('lodde',),
'loddet': ('lodde',),
'lodd': ('lodde',),
'lodda': ('lodde',),
'lodde': ('lodde',),
'lodder': ('lodde',),
'loddes': ('lodde',),
'loddet': ('lodde',),
'lo': ('loe',),
'loa': ('loe',),
'loe': ('loe',),
'loer': ('loe',),
'loes': ('loe',),
'loet': ('loe',),
'loff': ('loffe',),
'loffa': ('loffe',),
'loffe': ('loffe',),
'loffer': ('loffe',),
'loffes': ('loffe',),
'loffet': ('loffe',),
'loff': ('loffe',),
'loffa': ('loffe',),
'loffe': ('loffe',),
'loffer': ('loffe',),
'loffes': ('loffe',),
'loffet': ('loffe',),
'log': ('loge',),
'loga': ('loge',),
'loge': ('loge',),
'loger': ('loge',),
'loges': ('loge',),
'loget': ('loge',),
'logg': ('logge',),
'logga': ('logge',),
'logge': ('logge',),
'logger': ('logge',),
'logges': ('logge',),
'logget': ('logge',),
'logr': ('logre',),
'logra': ('logre',),
'logre': ('logre',),
'logrer': ('logre',),
'logres': ('logre',),
'logret': ('logre',),
'lokalbedøv': ('lokalbedøve',),
'lokalbedøva': ('lokalbedøve',),
'lokalbedøvd': ('lokalbedøve',),
'lokalbedøvde': ('lokalbedøve',),
'lokalbedøve': ('lokalbedøve',),
'lokalbedøver': ('lokalbedøve',),
'lokalbedøves': ('lokalbedøve',),
'lokalbedøvet': ('lokalbedøve',),
'lokaliser': ('lokalisere',),
'lokalisere': ('lokalisere',),
'lokaliserer': ('lokalisere',),
'lokaliseres': ('lokalisere',),
'lokalisert': ('lokalisere',),
'lokaliserte': ('lokalisere',),
'lokk': ('lokke',),
'lokka': ('lokke',),
'lokke': ('lokke',),
'lokker': ('lokke',),
'lokkes': ('lokke',),
'lokket': ('lokke',),
'lokk': ('lokke',),
'lokka': ('lokke',),
'lokke': ('lokke',),
'lokker': ('lokke',),
'lokkes': ('lokke',),
'lokket': ('lokke',),
'lokk': ('lokke',),
'lokka': ('lokke',),
'lokke': ('lokke',),
'lokker': ('lokke',),
'lokkes': ('lokke',),
'lokket': ('lokke',),
'lombarder': ('lombardere',),
'lombardere': ('lombardere',),
'lombarderer': ('lombardere',),
'lombarderes': ('lombardere',),
'lombardert': ('lombardere',),
'lombarderte': ('lombardere',),
'longer': ('longere',),
'longere': ('longere',),
'longerer': ('longere',),
'longeres': ('longere',),
'longert': ('longere',),
'longerte': ('longere',),
'loop': ('loope',),
'loopa': ('loope',),
'loope': ('loope',),
'looper': ('loope',),
'loopes': ('loope',),
'loopet': ('loope',),
'lopp': ('loppe',),
'loppa': ('loppe',),
'loppe': ('loppe',),
'lopper': ('loppe',),
'loppes': ('loppe',),
'loppet': ('loppe',),
'lorgnetter': ('lorgnettere',),
'lorgnettere': ('lorgnettere',),
'lorgnetterer': ('lorgnettere',),
'lorgnetteres': ('lorgnettere',),
'lorgnettert': ('lorgnettere',),
'lorgnetterte': ('lorgnettere',),
'los': ('lose',),
'losa': ('lose',),
'lose': ('lose',),
'loser': ('lose',),
'loses': ('lose',),
'loset': ('lose',),
'lost': ('lose',),
'loste': ('lose',),
'losjer': ('losjere',),
'losjere': ('losjere',),
'losjerer': ('losjere',),
'losjeres': ('losjere',),
'losjert': ('losjere',),
'losjerte': ('losjere',),
'loss': ('losse',),
'lossa': ('losse',),
'losse': ('losse',),
'losser': ('losse',),
'losses': ('losse',),
'losset': ('losse',),
'lovfest': ('lovfeste',),
'lovfesta': ('lovfeste',),
'lovfeste': ('lovfeste',),
'lovfester': ('lovfeste',),
'lovfestes': ('lovfeste',),
'lovfestet': ('lovfeste',),
'lovheiml': ('lovheimle',),
'lovheimla': ('lovheimle',),
'lovheimle': ('lovheimle',),
'lovheimler': ('lovheimle',),
'lovheimles': ('lovheimle',),
'lovheimlet': ('lovheimle',),
'lovhjeml': ('lovhjemle',),
'lovhjemla': ('lovhjemle',),
'lovhjemle': ('lovhjemle',),
'lovhjemler': ('lovhjemle',),
'lovhjemles': ('lovhjemle',),
'lovhjemlet': ('lovhjemle',),
'lovpris': ('lovprise',),
'lovprise': ('lovprise',),
'lovpriser': ('lovprise',),
'lovprises': ('lovprise',),
'lovprist': ('lovprise',),
'lovpriste': ('lovprise',),
'lovsang': ('lovsynge',),
'lovsunget': ('lovsynge',),
'lovsyng': ('lovsynge',),
'lovsynge': ('lovsynge',),
'lovsynger': ('lovsynge',),
'lovsynges': ('lovsynge',),
'lu': ('lue',),
'lua': ('lue',),
'lue': ('lue',),
'luer': ('lue',),
'lues': ('lue',),
'luet': ('lue',),
'luft': ('lufte',),
'lufta': ('lufte',),
'lufte': ('lufte',),
'lufter': ('lufte',),
'luftes': ('lufte',),
'luftet': ('lufte',),
'lufttørk': ('lufttørke',),
'lufttørka': ('lufttørke',),
'lufttørke': ('lufttørke',),
'lufttørker': ('lufttørke',),
'lufttørkes': ('lufttørke',),
'lufttørket': ('lufttørke',),
'lugg': ('lugge',),
'lugga': ('lugge',),
'lugge': ('lugge',),
'lugger': ('lugge',),
'lugges': ('lugge',),
'lugget': ('lugge',),
'lugn': ('lugne',),
'lugna': ('lugne',),
'lugne': ('lugne',),
'lugner': ('lugne',),
'lugnes': ('lugne',),
'lugnet': ('lugne',),
'luk': ('luke',),
'luka': ('luke',),
'luke': ('luke',),
'luker': ('luke',),
'lukes': ('luke',),
'luket': ('luke',),
'lukt': ('luke',),
'lukte': ('luke',),
'lukk': ('lukke',),
'lukka': ('lukke',),
'lukke': ('lukke',),
'lukker': ('lukke',),
'lukkes': ('lukke',),
'lukket': ('lukke',),
'lukrer': ('lukrere',),
'lukrere': ('lukrere',),
'lukrerer': ('lukrere',),
'lukreres': ('lukrere',),
'lukrert': ('lukrere',),
'lukrerte': ('lukrere',),
'lukser': ('luksere',),
'luksere': ('luksere',),
'lukserer': ('luksere',),
'lukseres': ('luksere',),
'luksert': ('luksere',),
'lukserte': ('luksere',),
'lukt': ('lukte',),
'lukta': ('lukte',),
'lukte': ('lukte',),
'lukter': ('lukte',),
'luktes': ('lukte',),
'luktet': ('lukte',),
'lull': ('lulle',),
'lulla': ('lulle',),
'lulle': ('lulle',),
'luller': ('lulle',),
'lulles': ('lulle',),
'lullet': ('lulle',),
'lump': ('lumpe',),
'lumpa': ('lumpe',),
'lumpe': ('lumpe',),
'lumper': ('lumpe',),
'lumpes': ('lumpe',),
'lumpet': ('lumpe',),
'lun': ('lune',),
'luna': ('lune',),
'lune': ('lune',),
'luner': ('lune',),
'lunes': ('lune',),
'lunet': ('lune',),
'lunt': ('lune',),
'lunte': ('lune',),
'lunk': ('lunke',),
'lunka': ('lunke',),
'lunke': ('lunke',),
'lunker': ('lunke',),
'lunkes': ('lunke',),
'lunket': ('lunke',),
'lunk': ('lunke',),
'lunka': ('lunke',),
'lunke': ('lunke',),
'lunker': ('lunke',),
'lunkes': ('lunke',),
'lunket': ('lunke',),
'lunn': ('lunne',),
'lunna': ('lunne',),
'lunne': ('lunne',),
'lunner': ('lunne',),
'lunnes': ('lunne',),
'lunnet': ('lunne',),
'lunn': ('lunne',),
'lunna': ('lunne',),
'lunne': ('lunne',),
'lunner': ('lunne',),
'lunnes': ('lunne',),
'lunnet': ('lunne',),
'lunsj': ('lunsje',),
'lunsja': ('lunsje',),
'lunsje': ('lunsje',),
'lunsjer': ('lunsje',),
'lunsjes': ('lunsje',),
'lunsjet': ('lunsje',),
'lunt': ('lunte',),
'lunta': ('lunte',),
'lunte': ('lunte',),
'lunter': ('lunte',),
'luntes': ('lunte',),
'luntet': ('lunte',),
'lur': ('lure',),
'lure': ('lure',),
'lurer': ('lure',),
'lures': ('lure',),
'lurt': ('lure',),
'lurte': ('lure',),
'lur': ('lure',),
'lura': ('lure',),
'lure': ('lure',),
'lurer': ('lure',),
'lures': ('lure',),
'luret': ('lure',),
'lurt': ('lure',),
'lurte': ('lure',),
'lurv': ('lurve',),
'lurva': ('lurve',),
'lurve': ('lurve',),
'lurver': ('lurve',),
'lurves': ('lurve',),
'lurvet': ('lurve',),
'lus': ('luse',),
'lusa': ('luse',),
'luse': ('luse',),
'luser': ('luse',),
'luses': ('luse',),
'luset': ('luse',),
'lust': ('luse',),
'luste': ('luse',),
'lusk': ('luske',),
'luska': ('luske',),
'luske': ('luske',),
'lusker': ('luske',),
'luskes': ('luske',),
'lusket': ('luske',),
'lut': ('lute',),
'luta': ('lute',),
'lute': ('lute',),
'luter': ('lute',),
'lutes': ('lute',),
'lutet': ('lute',),
'lut': ('lute',),
'luta': ('lute',),
'lute': ('lute',),
'luter': ('lute',),
'lutes': ('lute',),
'lutet': ('lute',),
'lutt': ('lute',),
'lutte': ('lute',),
'lutr': ('lutre',),
'lutra': ('lutre',),
'lutre': ('lutre',),
'lutrer': ('lutre',),
'lutres': ('lutre',),
'lutret': ('lutre',),
'lyd': ('lyde',),
'lydd': ('lyde',),
'lydde': ('lyde',),
'lyde': ('lyde',),
'lyder': ('lyde',),
'lydes': ('lyde',),
'lydt': ('lyde',),
'lød': ('lyde',),
'lyd': ('lyde',),
'lydd': ('lyde',),
'lydde': ('lyde',),
'lyde': ('lyde',),
'lyder': ('lyde',),
'lydes': ('lyde',),
'lydt': ('lyde',),
'lød': ('lyde',),
'ly': ('lye',),
'lydd': ('lye',),
'lydde': ('lye',),
'lye': ('lye',),
'lyer': ('lye',),
'lyes': ('lye',),
'ly': ('lye',),
'lya': ('lye',),
'lydd': ('lye',),
'lydde': ('lye',),
'lye': ('lye',),
'lyer': ('lye',),
'lyes': ('lye',),
'lyet': ('lye',),
'laug': ('lyge',),
'lyg': ('lyge',),
'lyge': ('lyge',),
'lyger': ('lyge',),
'lyges': ('lyge',),
'løy': ('lyge',),
'løyet': ('lyge',),
'laug': ('lyge',),
'lyg': ('lyge',),
'lyge': ('lyge',),
'lyger': ('lyge',),
'lyges': ('lyge',),
'løy': ('lyge',),
'løyet': ('lyge',),
'lykkes': ('lykkes',),
'lyktes': ('lykkes',),
'lykkønsk': ('lykkønske',),
'lykkønska': ('lykkønske',),
'lykkønske': ('lykkønske',),
'lykkønsker': ('lykkønske',),
'lykkønskes': ('lykkønske',),
'lykkønsket': ('lykkønske',),
'lykkønskt': ('lykkønske',),
'lykkønskte': ('lykkønske',),
'lyn': ('lyne',),
'lyne': ('lyne',),
'lyner': ('lyne',),
'lynes': ('lyne',),
'lynt': ('lyne',),
'lynte': ('lyne',),
'lynsj': ('lynsje',),
'lynsja': ('lynsje',),
'lynsje': ('lynsje',),
'lynsjer': ('lynsje',),
'lynsjes': ('lynsje',),
'lynsjet': ('lynsje',),
'lys': ('lyse',),
'lyse': ('lyse',),
'lyser': ('lyse',),
'lyses': ('lyse',),
'lyst': ('lyse',),
'lyste': ('lyse',),
'lysk': ('lyske',),
'lyska': ('lyske',),
'lyske': ('lyske',),
'lysker': ('lyske',),
'lyskes': ('lyske',),
'lysket': ('lyske',),
'lysn': ('lysne',),
'lysna': ('lysne',),
'lysne': ('lysne',),
'lysner': ('lysne',),
'lysnes': ('lysne',),
'lysnet': ('lysne',),
'lyst': ('lyste',),
'lysta': ('lyste',),
'lyste': ('lyste',),
'lyster': ('lyste',),
'lystes': ('lyste',),
'lystet': ('lyste',),
'lystr': ('lystre',),
'lystra': ('lystre',),
'lystre': ('lystre',),
'lystrer': ('lystre',),
'lystres': ('lystre',),
'lystret': ('lystre',),
'lystr': ('lystre',),
'lystra': ('lystre',),
'lystre': ('lystre',),
'lystrer': ('lystre',),
'lystres': ('lystre',),
'lystret': ('lystre',),
'lytt': ('lytte',),
'lytta': ('lytte',),
'lytte': ('lytte',),
'lytter': ('lytte',),
'lyttes': ('lytte',),
'lyttet': ('lytte',),
'lyv': ('lyve',),
'lyve': ('lyve',),
'lyver': ('lyve',),
'lyves': ('lyve',),
'løy': ('lyve',),
'løyet': ('lyve',),
'lyv': ('lyve',),
'lyve': ('lyve',),
'lyver': ('lyve',),
'lyves': ('lyve',),
'løy': ('lyve',),
'løyet': ('lyve',),
'lån': ('låne',),
'låne': ('låne',),
'låner': ('låne',),
'lånes': ('låne',),
'lånt': ('låne',),
'lånte': ('låne',),
'lånta': ('lånta',),
'låntaes': ('lånta',),
'låntar': ('lånta',),
'låntas': ('lånta',),
'låntatt': ('lånta',),
'låntok': ('lånta',),
'lår': ('låre',),
'låra': ('låre',),
'låre': ('låre',),
'lårer': ('låre',),
'låres': ('låre',),
'låret': ('låre',),
'lårt': ('låre',),
'lårte': ('låre',),
'lås': ('låse',),
'låse': ('låse',),
'låser': ('låse',),
'låses': ('låse',),
'låst': ('låse',),
'låste': ('låse',),
'låt': ('låte',),
'låte': ('låte',),
'låter': ('låte',),
'låtes': ('låte',),
'lått': ('låte',),
'lægr': ('lægre',),
'lægra': ('lægre',),
'lægre': ('lægre',),
'lægrer': ('lægre',),
'lægres': ('lægre',),
'lægret': ('lægre',),
'lær': ('lære',),
'lære': ('lære',),
'lærer': ('lære',),
'læres': ('lære',),
'lært': ('lære',),
'lærte': ('lære',),
'lø': ('lø',),
'lødd': ('lø',),
'lødde': ('lø',),
'lør': ('lø',),
'løs': ('lø',),
'lø': ('lø',),
'lødd': ('lø',),
'lødde': ('lø',),
'lør': ('lø',),
'løs': ('lø',),
'lø': ('løe',),
'lødd': ('løe',),
'lødde': ('løe',),
'løe': ('løe',),
'løer': ('løe',),
'løes': ('løe',),
'lø': ('løe',),
'lødd': ('løe',),
'lødde': ('løe',),
'løe': ('løe',),
'løer': ('løe',),
'løes': ('løe',),
'løft': ('løfte',),
'løfta': ('løfte',),
'løfte': ('løfte',),
'løfter': ('løfte',),
'løftes': ('løfte',),
'løftet': ('løfte',),
'lønn': ('lønne',),
'lønna': ('lønne',),
'lønne': ('lønne',),
'lønner': ('lønne',),
'lønnes': ('lønne',),
'lønnet': ('lønne',),
'lønt': ('lønne',),
'lønte': ('lønne',),
'løp': ('løpe',),
'løpe': ('løpe',),
'løper': ('løpe',),
'løpes': ('løpe',),
'løpet': ('løpe',),
'løpt': ('løpe',),
'løs': ('løse',),
'løse': ('løse',),
'løser': ('løse',),
'løses': ('løse',),
'løst': ('løse',),
'løste': ('løse',),
'løsga': ('løsgi',),
'løsgav': ('løsgi',),
'løsgi': ('løsgi',),
'løsgies': ('løsgi',),
'løsgir': ('løsgi',),
'løsgis': ('løsgi',),
'løsgitt': ('løsgi',),
'løsgjorde': ('løsgjøre',),
'løsgjort': ('løsgjøre',),
'løsgjør': ('løsgjøre',),
'løsgjøre': ('løsgjøre',),
'løsgjøres': ('løsgjøre',),
'løsn': ('løsne',),
'løsna': ('løsne',),
'løsne': ('løsne',),
'løsner': ('løsne',),
'løsnes': ('løsne',),
'løsnet': ('løsne',),
'løy': ('løye',),
'løya': ('løye',),
'løye': ('løye',),
'løyer': ('løye',),
'løyes': ('løye',),
'løyet': ('løye',),
'løyn': ('løyne',),
'løyne': ('løyne',),
'løyner': ('løyne',),
'løynes': ('løyne',),
'løynt': ('løyne',),
'løynte': ('løyne',),
'løyp': ('løype',),
'løype': ('løype',),
'løyper': ('løype',),
'løypes': ('løype',),
'løypt': ('løype',),
'løypte': ('løype',),
'løys': ('løyse',),
'løyse': ('løyse',),
'løyser': ('løyse',),
'løyses': ('løyse',),
'løyst': ('løyse',),
'løyste': ('løyse',),
'løyv': ('løyve',),
'løyvd': ('løyve',),
'løyvde': ('løyve',),
'løyve': ('løyve',),
'løyver': ('løyve',),
'løyves': ('løyve',),
'magasiner': ('magasinere',),
'magasinere': ('magasinere',),
'magasinerer': ('magasinere',),
'magasineres': ('magasinere',),
'magasinert': ('magasinere',),
'magasinerte': ('magasinere',),
'mag': ('mage',),
'maga': ('mage',),
'mage': ('mage',),
'mager': ('mage',),
'mages': ('mage',),
'maget': ('mage',),
'magnetiser': ('magnetisere',),
'magnetisere': ('magnetisere',),
'magnetiserer': ('magnetisere',),
'magnetiseres': ('magnetisere',),
'magnetisert': ('magnetisere',),
'magnetiserte': ('magnetisere',),
'magr': ('magre',),
'magra': ('magre',),
'magre': ('magre',),
'magrer': ('magre',),
'magres': ('magre',),
'magret': ('magre',),
'mai': ('maie',),
'maia': ('maie',),
'maie': ('maie',),
'maier': ('maie',),
'maies': ('maie',),
'maiet': ('maie',),
'makadamiser': ('makadamisere',),
'makadamisere': ('makadamisere',),
'makadamiserer': ('makadamisere',),
'makadamiseres': ('makadamisere',),
'makadamisert': ('makadamisere',),
'makadamiserte': ('makadamisere',),
'mak': ('make',),
'maka': ('make',),
'make': ('make',),
'maker': ('make',),
'makes': ('make',),
'maket': ('make',),
'makt': ('make',),
'makte': ('make',),
'makeskift': ('makeskifte',),
'makeskifta': ('makeskifte',),
'makeskifte': ('makeskifte',),
'makeskifter': ('makeskifte',),
'makeskiftes': ('makeskifte',),
'makeskiftet': ('makeskifte',),
'maksimaliser': ('maksimalisere',),
'maksimalisere': ('maksimalisere',),
'maksimaliserer': ('maksimalisere',),
'maksimaliseres': ('maksimalisere',),
'maksimalisert': ('maksimalisere',),
'maksimaliserte': ('maksimalisere',),
'maksimer': ('maksimere',),
'maksimere': ('maksimere',),
'maksimerer': ('maksimere',),
'maksimeres': ('maksimere',),
'maksimert': ('maksimere',),
'maksimerte': ('maksimere',),
'maksl': ('maksle',),
'maksla': ('maksle',),
'maksle': ('maksle',),
'maksler': ('maksle',),
'maksles': ('maksle',),
'makslet': ('maksle',),
'makt': ('makte',),
'makta': ('makte',),
'makte': ('makte',),
'makter': ('makte',),
'maktes': ('makte',),
'maktet': ('makte',),
'maktstjal': ('maktstjele',),
'maktstjel': ('maktstjele',),
'maktstjele': ('maktstjele',),
'maktstjeler': ('maktstjele',),
'maktstjeles': ('maktstjele',),
'maktstjålet': ('maktstjele',),
'makuler': ('makulere',),
'makulere': ('makulere',),
'makulerer': ('makulere',),
'makuleres': ('makulere',),
'makulert': ('makulere',),
'makulerte': ('makulere',),
'malt': ('malte',),
'malta': ('malte',),
'malte': ('malte',),
'malter': ('malte',),
'maltes': ('malte',),
'maltet': ('malte',),
'maltrakter': ('maltraktere',),
'maltraktere': ('maltraktere',),
'maltrakterer': ('maltraktere',),
'maltrakteres': ('maltraktere',),
'maltraktert': ('maltraktere',),
'maltrakterte': ('maltraktere',),
'man': ('mane',),
'mana': ('mane',),
'mane': ('mane',),
'maner': ('mane',),
'manes': ('mane',),
'manet': ('mane',),
'mant': ('mane',),
'mante': ('mane',),
'mangedobl': ('mangedoble',),
'mangedobla': ('mangedoble',),
'mangedoble': ('mangedoble',),
'mangedobler': ('mangedoble',),
'mangedobles': ('mangedoble',),
'mangedoblet': ('mangedoble',),
'mangfoldiggjorde': ('mangfoldiggjøre',),
'mangfoldiggjort': ('mangfoldiggjøre',),
'mangfoldiggjør': ('mangfoldiggjøre',),
'mangfoldiggjøre': ('mangfoldiggjøre',),
'mangfoldiggjøres': ('mangfoldiggjøre',),
'mangl': ('mangle',),
'mangla': ('mangle',),
'mangle': ('mangle',),
'mangler': ('mangle',),
'mangles': ('mangle',),
'manglet': ('mangle',),
'mangl': ('mangle',),
'mangla': ('mangle',),
'mangle': ('mangle',),
'mangler': ('mangle',),
'mangles': ('mangle',),
'manglet': ('mangle',),
'manifester': ('manifestere',),
'manifestere': ('manifestere',),
'manifesterer': ('manifestere',),
'manifesteres': ('manifestere',),
'manifestert': ('manifestere',),
'manifesterte': ('manifestere',),
'manikyrer': ('manikyrere',),
'manikyrere': ('manikyrere',),
'manikyrerer': ('manikyrere',),
'manikyreres': ('manikyrere',),
'manikyrert': ('manikyrere',),
'manikyrerte': ('manikyrere',),
'manipuler': ('manipulere',),
'manipulere': ('manipulere',),
'manipulerer': ('manipulere',),
'manipuleres': ('manipulere',),
'manipulert': ('manipulere',),
'manipulerte': ('manipulere',),
'manker': ('mankere',),
'mankere': ('mankere',),
'mankerer': ('mankere',),
'mankeres': ('mankere',),
'mankert': ('mankere',),
'mankerte': ('mankere',),
'manndaud': ('manndaude',),
'manndauda': ('manndaude',),
'manndaude': ('manndaude',),
'manndauder': ('manndaude',),
'manndaudes': ('manndaude',),
'manndaudet': ('manndaude',),
'mann': ('manne',),
'manna': ('manne',),
'manne': ('manne',),
'manner': ('manne',),
'mannes': ('manne',),
'mannet': ('manne',),
'mannedaud': ('mannedaude',),
'mannedauda': ('mannedaude',),
'mannedaude': ('mannedaude',),
'mannedauder': ('mannedaude',),
'mannedaudes': ('mannedaude',),
'mannedaudet': ('mannedaude',),
'mannsoppdekk': ('mannsoppdekke',),
'mannsoppdekka': ('mannsoppdekke',),
'mannsoppdekke': ('mannsoppdekke',),
'mannsoppdekker': ('mannsoppdekke',),
'mannsoppdekkes': ('mannsoppdekke',),
'mannsoppdekket': ('mannsoppdekke',),
'mannsoppdekt': ('mannsoppdekke',),
'mannsoppdekte': ('mannsoppdekke',),
'manuduser': ('manudusere',),
'manudusere': ('manudusere',),
'manuduserer': ('manudusere',),
'manuduseres': ('manudusere',),
'manudusert': ('manudusere',),
'manuduserte': ('manudusere',),
'manøvrer': ('manøvrere',),
'manøvrere': ('manøvrere',),
'manøvrerer': ('manøvrere',),
'manøvreres': ('manøvrere',),
'manøvrert': ('manøvrere',),
'manøvrerte': ('manøvrere',),
'margstal': ('margstele',),
'margstel': ('margstele',),
'margstele': ('margstele',),
'margsteler': ('margstele',),
'margsteles': ('margstele',),
'margstålet': ('margstele',),
'margstal': ('margstele',),
'margstel': ('margstele',),
'margstele': ('margstele',),
'margsteler': ('margstele',),
'margsteles': ('margstele',),
'margstålet': ('margstele',),
'margstjal': ('margstjele',),
'margstjel': ('margstjele',),
'margstjele': ('margstjele',),
'margstjeler': ('margstjele',),
'margstjeles': ('margstjele',),
'margstjålet': ('margstjele',),
'margstjal': ('margstjele',),
'margstjel': ('margstjele',),
'margstjele': ('margstjele',),
'margstjeler': ('margstjele',),
'margstjeles': ('margstjele',),
'margstjålet': ('margstjele',),
'mariner': ('marinere',),
'marinere': ('marinere',),
'marinerer': ('marinere',),
'marineres': ('marinere',),
'marinert': ('marinere',),
'marinerte': ('marinere',),
'markedsfør': ('markedsføre',),
'markedsføre': ('markedsføre',),
'markedsfører': ('markedsføre',),
'markedsføres': ('markedsføre',),
'markedsført': ('markedsføre',),
'markedsførte': ('markedsføre',),
'marker': ('markere',),
'markere': ('markere',),
'markerer': ('markere',),
'markeres': ('markere',),
'markert': ('markere',),
'markerte': ('markere',),
'marknadsfør': ('marknadsføre',),
'marknadsføre': ('marknadsføre',),
'marknadsfører': ('marknadsføre',),
'marknadsføres': ('marknadsføre',),
'marknadsført': ('marknadsføre',),
'marknadsførte': ('marknadsføre',),
'marm': ('marme',),
'marma': ('marme',),
'marme': ('marme',),
'marmer': ('marme',),
'marmes': ('marme',),
'marmet': ('marme',),
'marmorer': ('marmorere',),
'marmorere': ('marmorere',),
'marmorerer': ('marmorere',),
'marmoreres': ('marmorere',),
'marmorert': ('marmorere',),
'marmorerte': ('marmorere',),
'marsjer': ('marsjere',),
'marsjere': ('marsjere',),
'marsjerer': ('marsjere',),
'marsjeres': ('marsjere',),
'marsjert': ('marsjere',),
'marsjerte': ('marsjere',),
'martr': ('martre',),
'martra': ('martre',),
'martre': ('martre',),
'martrer': ('martre',),
'martres': ('martre',),
'martret': ('martre',),
'mask': ('maske',),
'maska': ('maske',),
'maske': ('maske',),
'masker': ('maske',),
'maskes': ('maske',),
'masket': ('maske',),
'masker': ('maskere',),
'maskere': ('maskere',),
'maskerer': ('maskere',),
'maskeres': ('maskere',),
'maskert': ('maskere',),
'maskerte': ('maskere',),
'maskiner': ('maskinere',),
'maskinere': ('maskinere',),
'maskinerer': ('maskinere',),
'maskineres': ('maskinere',),
'maskinert': ('maskinere',),
'maskinerte': ('maskinere',),
'maskinklipp': ('maskinklippe',),
'maskinklippa': ('maskinklippe',),
'maskinklippe': ('maskinklippe',),
'maskinklipper': ('maskinklippe',),
'maskinklippes': ('maskinklippe',),
'maskinklippet': ('maskinklippe',),
'maskinklipt': ('maskinklippe',),
'maskinklipte': ('maskinklippe',),
'maskinskreiv': ('maskinskrive',),
'maskinskrev': ('maskinskrive',),
'maskinskrevet': ('maskinskrive',),
'maskinskriv': ('maskinskrive',),
'maskinskrive': ('maskinskrive',),
'maskinskriver': ('maskinskrive',),
'maskinskrives': ('maskinskrive',),
'maskinstrikk': ('maskinstrikke',),
'maskinstrikka': ('maskinstrikke',),
'maskinstrikke': ('maskinstrikke',),
'maskinstrikker': ('maskinstrikke',),
'maskinstrikkes': ('maskinstrikke',),
'maskinstrikket': ('maskinstrikke',),
'maskuliniser': ('maskulinisere',),
'maskulinisere': ('maskulinisere',),
'maskuliniserer': ('maskulinisere',),
'maskuliniseres': ('maskulinisere',),
'maskulinisert': ('maskulinisere',),
'maskuliniserte': ('maskulinisere',),
'massakrer': ('massakrere',),
'massakrere': ('massakrere',),
'massakrerer': ('massakrere',),
'massakreres': ('massakrere',),
'massakrert': ('massakrere',),
'massakrerte': ('massakrere',),
'masseproduser': ('masseprodusere',),
'masseprodusere': ('masseprodusere',),
'masseproduserer': ('masseprodusere',),
'masseproduseres': ('masseprodusere',),
'masseprodusert': ('masseprodusere',),
'masseproduserte': ('masseprodusere',),
'masser': ('massere',),
'massere': ('massere',),
'masserer': ('massere',),
'masseres': ('massere',),
'massert': ('massere',),
'masserte': ('massere',),
'mast': ('maste',),
'masta': ('maste',),
'maste': ('maste',),
'master': ('maste',),
'mastes': ('maste',),
'mastet': ('maste',),
'masturber': ('masturbere',),
'masturbere': ('masturbere',),
'masturberer': ('masturbere',),
'masturberes': ('masturbere',),
'masturbert': ('masturbere',),
'masturberte': ('masturbere',),
'matberg': ('matberge',),
'matberga': ('matberge',),
'matberge': ('matberge',),
'matberger': ('matberge',),
'matberges': ('matberge',),
'matberget': ('matberge',),
'match': ('matche',),
'matcha': ('matche',),
'matche': ('matche',),
'matcher': ('matche',),
'matches': ('matche',),
'matchet': ('matche',),
'mat': ('mate',),
'mata': ('mate',),
'mate': ('mate',),
'mater': ('mate',),
'mates': ('mate',),
'matet': ('mate',),
'materialiser': ('materialisere',),
'materialisere': ('materialisere',),
'materialiserer': ('materialisere',),
'materialiseres': ('materialisere',),
'materialisert': ('materialisere',),
'materialiserte': ('materialisere',),
'matrikuler': ('matrikulere',),
'matrikulere': ('matrikulere',),
'matrikulerer': ('matrikulere',),
'matrikuleres': ('matrikulere',),
'matrikulert': ('matrikulere',),
'matrikulerte': ('matrikulere',),
'matt': ('matte',),
'matta': ('matte',),
'matte': ('matte',),
'matter': ('matte',),
'mattes': ('matte',),
'mattet': ('matte',),
'matter': ('mattere',),
'mattere': ('mattere',),
'matterer': ('mattere',),
'matteres': ('mattere',),
'mattert': ('mattere',),
'matterte': ('mattere',),
'maul': ('maule',),
'maula': ('maule',),
'maule': ('maule',),
'mauler': ('maule',),
'maules': ('maule',),
'maulet': ('maule',),
'maur': ('maure',),
'maura': ('maure',),
'maure': ('maure',),
'maurer': ('maure',),
'maures': ('maure',),
'mauret': ('maure',),
'meddel': ('meddele',),
'meddele': ('meddele',),
'meddeler': ('meddele',),
'meddeles': ('meddele',),
'meddelt': ('meddele',),
'meddelte': ('meddele',),
'medfør': ('medføre',),
'medføre': ('medføre',),
'medfører': ('medføre',),
'medføres': ('medføre',),
'medført': ('medføre',),
'medførte': ('medføre',),
'medga': ('medgi',),
'medgav': ('medgi',),
'medgi': ('medgi',),
'medgies': ('medgi',),
'medgir': ('medgi',),
'medgis': ('medgi',),
'medgitt': ('medgi',),
'medisiner': ('medisinere',),
'medisinere': ('medisinere',),
'medisinerer': ('medisinere',),
'medisineres': ('medisinere',),
'medisinert': ('medisinere',),
'medisinerte': ('medisinere',),
'mediter': ('meditere',),
'meditere': ('meditere',),
'mediterer': ('meditere',),
'mediteres': ('meditere',),
'meditert': ('meditere',),
'mediterte': ('meditere',),
'medunderskreiv': ('medunderskrive',),
'medunderskrev': ('medunderskrive',),
'medunderskrevet': ('medunderskrive',),
'medunderskriv': ('medunderskrive',),
'medunderskrive': ('medunderskrive',),
'medunderskriver': ('medunderskrive',),
'medunderskrives': ('medunderskrive',),
'medvirk': ('medvirke',),
'medvirka': ('medvirke',),
'medvirke': ('medvirke',),
'medvirker': ('medvirke',),
'medvirkes': ('medvirke',),
'medvirket': ('medvirke',),
'megl': ('megle',),
'megla': ('megle',),
'megle': ('megle',),
'megler': ('megle',),
'megles': ('megle',),
'meglet': ('megle',),
'mei': ('meie',),
'meia': ('meie',),
'meid': ('meie',),
'meidd': ('meie',),
'meidde': ('meie',),
'meide': ('meie',),
'meie': ('meie',),
'meier': ('meie',),
'meies': ('meie',),
'meiet': ('meie',),
'mein': ('meine',),
'meine': ('meine',),
'meiner': ('meine',),
'meines': ('meine',),
'meint': ('meine',),
'meinte': ('meine',),
'meisl': ('meisle',),
'meisla': ('meisle',),
'meisle': ('meisle',),
'meisler': ('meisle',),
'meisles': ('meisle',),
'meislet': ('meisle',),
'meit': ('meite',),
'meita': ('meite',),
'meite': ('meite',),
'meiter': ('meite',),
'meites': ('meite',),
'meitet': ('meite',),
'mekaniser': ('mekanisere',),
'mekanisere': ('mekanisere',),
'mekaniserer': ('mekanisere',),
'mekaniseres': ('mekanisere',),
'mekanisert': ('mekanisere',),
'mekaniserte': ('mekanisere',),
'mekk': ('mekke',),
'mekka': ('mekke',),
'mekke': ('mekke',),
'mekker': ('mekke',),
'mekkes': ('mekke',),
'mekket': ('mekke',),
'mekl': ('mekle',),
'mekla': ('mekle',),
'mekle': ('mekle',),
'mekler': ('mekle',),
'mekles': ('mekle',),
'meklet': ('mekle',),
'mekr': ('mekre',),
'mekra': ('mekre',),
'mekre': ('mekre',),
'mekrer': ('mekre',),
'mekres': ('mekre',),
'mekret': ('mekre',),
'meld': ('melde',),
'melde': ('melde',),
'melder': ('melde',),
'meldes': ('melde',),
'meldt': ('melde',),
'meldte': ('melde',),
'mel': ('mele',),
'mela': ('mele',),
'mele': ('mele',),
'meler': ('mele',),
'meles': ('mele',),
'melet': ('mele',),
'melt': ('mele',),
'melte': ('mele',),
'meler': ('melere',),
'melere': ('melere',),
'melerer': ('melere',),
'meleres': ('melere',),
'melert': ('melere',),
'melerte': ('melere',),
'melk': ('melke',),
'melka': ('melke',),
'melke': ('melke',),
'melker': ('melke',),
'melkes': ('melke',),
'melket': ('melke',),
'mellomland': ('mellomlande',),
'mellomlanda': ('mellomlande',),
'mellomlande': ('mellomlande',),
'mellomlander': ('mellomlande',),
'mellomlandes': ('mellomlande',),
'mellomlandet': ('mellomlande',),
'melt': ('melte',),
'melta': ('melte',),
'melte': ('melte',),
'melter': ('melte',),
'meltes': ('melte',),
'meltet': ('melte',),
'memorer': ('memorere',),
'memorere': ('memorere',),
'memorerer': ('memorere',),
'memoreres': ('memorere',),
'memorert': ('memorere',),
'memorerte': ('memorere',),
'men': ('mene',),
'mene': ('mene',),
'mener': ('mene',),
'menes': ('mene',),
'ment': ('mene',),
'mente': ('mene',),
'meng': ('menge',),
'menga': ('menge',),
'menge': ('menge',),
'menger': ('menge',),
'menges': ('menge',),
'menget': ('menge',),
'mengt': ('menge',),
'mengte': ('menge',),
'menstruer': ('menstruere',),
'menstruere': ('menstruere',),
'menstruerer': ('menstruere',),
'menstrueres': ('menstruere',),
'menstruert': ('menstruere',),
'menstruerte': ('menstruere',),
'mentalundersøk': ('mentalundersøke',),
'mentalundersøke': ('mentalundersøke',),
'mentalundersøker': ('mentalundersøke',),
'mentalundersøkes': ('mentalundersøke',),
'mentalundersøkt': ('mentalundersøke',),
'mentalundersøkte': ('mentalundersøke',),
'mergl': ('mergle',),
'mergla': ('mergle',),
'mergle': ('mergle',),
'mergler': ('mergle',),
'mergles': ('mergle',),
'merglet': ('mergle',),
'mergstal': ('mergstele',),
'mergstel': ('mergstele',),
'mergstele': ('mergstele',),
'mergsteler': ('mergstele',),
'mergsteles': ('mergstele',),
'mergstålet': ('mergstele',),
'mergstal': ('mergstele',),
'mergstel': ('mergstele',),
'mergstele': ('mergstele',),
'mergsteler': ('mergstele',),
'mergsteles': ('mergstele',),
'mergstålet': ('mergstele',),
'mergstjal': ('mergstjele',),
'mergstjel': ('mergstjele',),
'mergstjele': ('mergstjele',),
'mergstjeler': ('mergstjele',),
'mergstjeles': ('mergstjele',),
'mergstjålet': ('mergstjele',),
'mergstjal': ('mergstjele',),
'mergstjel': ('mergstjele',),
'mergstjele': ('mergstjele',),
'mergstjeler': ('mergstjele',),
'mergstjeles': ('mergstjele',),
'mergstjålet': ('mergstjele',),
'meritter': ('merittere',),
'merittere': ('merittere',),
'meritterer': ('merittere',),
'meritteres': ('merittere',),
'merittert': ('merittere',),
'meritterte': ('merittere',),
'merk': ('merke',),
'merka': ('merke',),
'merke': ('merke',),
'merker': ('merke',),
'merkes': ('merke',),
'merket': ('merke',),
'merl': ('merle',),
'merla': ('merle',),
'merle': ('merle',),
'merler': ('merle',),
'merles': ('merle',),
'merlet': ('merle',),
'mesk': ('meske',),
'meska': ('meske',),
'meske': ('meske',),
'mesker': ('meske',),
'meskes': ('meske',),
'mesket': ('meske',),
'mess': ('messe',),
'messa': ('messe',),
'messe': ('messe',),
'messer': ('messe',),
'messes': ('messe',),
'messet': ('messe',),
'mestr': ('mestre',),
'mestra': ('mestre',),
'mestre': ('mestre',),
'mestrer': ('mestre',),
'mestres': ('mestre',),
'mestret': ('mestre',),
'metalliser': ('metallisere',),
'metallisere': ('metallisere',),
'metalliserer': ('metallisere',),
'metalliseres': ('metallisere',),
'metallisert': ('metallisere',),
'metalliserte': ('metallisere',),
'mett': ('mette',),
'metta': ('mette',),
'mette': ('mette',),
'metter': ('mette',),
'mettes': ('mette',),
'mettet': ('mette',),
'midl': ('midle',),
'midla': ('midle',),
'midle': ('midle',),
'midler': ('midle',),
'midles': ('midle',),
'midlet': ('midle',),
'meg': ('mige',),
'meget': ('mige',),
'meig': ('mige',),
'mig': ('mige',),
'mige': ('mige',),
'miger': ('mige',),
'miges': ('mige',),
'migrer': ('migrere',),
'migrere': ('migrere',),
'migrerer': ('migrere',),
'migreres': ('migrere',),
'migrert': ('migrere',),
'migrerte': ('migrere',),
'mikroskoper': ('mikroskopere',),
'mikroskopere': ('mikroskopere',),
'mikroskoperer': ('mikroskopere',),
'mikroskoperes': ('mikroskopere',),
'mikroskopert': ('mikroskopere',),
'mikroskoperte': ('mikroskopere',),
'miks': ('mikse',),
'miksa': ('mikse',),
'mikse': ('mikse',),
'mikser': ('mikse',),
'mikses': ('mikse',),
'mikset': ('mikse',),
'mildn': ('mildne',),
'mildna': ('mildne',),
'mildne': ('mildne',),
'mildner': ('mildne',),
'mildnes': ('mildne',),
'mildnet': ('mildne',),
'militariser': ('militarisere',),
'militarisere': ('militarisere',),
'militariserer': ('militarisere',),
'militariseres': ('militarisere',),
'militarisert': ('militarisere',),
'militariserte': ('militarisere',),
'mim': ('mime',),
'mima': ('mime',),
'mime': ('mime',),
'mimer': ('mime',),
'mimes': ('mime',),
'mimet': ('mime',),
'mimr': ('mimre',),
'mimra': ('mimre',),
'mimre': ('mimre',),
'mimrer': ('mimre',),
'mimres': ('mimre',),
'mimret': ('mimre',),
'min': ('mine',),
'mina': ('mine',),
'mine': ('mine',),
'miner': ('mine',),
'mines': ('mine',),
'minet': ('mine',),
'mint': ('mine',),
'minte': ('mine',),
'minela': ('minelegge',),
'minelagt': ('minelegge',),
'minelegg': ('minelegge',),
'minelegge': ('minelegge',),
'minelegger': ('minelegge',),
'minelegges': ('minelegge',),
'miner': ('minere',),
'minere': ('minere',),
'minerer': ('minere',),
'mineres': ('minere',),
'minert': ('minere',),
'minerte': ('minere',),
'miniatyriser': ('miniatyrisere',),
'miniatyrisere': ('miniatyrisere',),
'miniatyriserer': ('miniatyrisere',),
'miniatyriseres': ('miniatyrisere',),
'miniatyrisert': ('miniatyrisere',),
'miniatyriserte': ('miniatyrisere',),
'minimaliser': ('minimalisere',),
'minimalisere': ('minimalisere',),
'minimaliserer': ('minimalisere',),
'minimaliseres': ('minimalisere',),
'minimalisert': ('minimalisere',),
'minimaliserte': ('minimalisere',),
'minimer': ('minimere',),
'minimere': ('minimere',),
'minimerer': ('minimere',),
'minimeres': ('minimere',),
'minimert': ('minimere',),
'minimerte': ('minimere',),
'mink': ('minke',),
'minka': ('minke',),
'minke': ('minke',),
'minker': ('minke',),
'minkes': ('minke',),
'minket': ('minke',),
'minn': ('minne',),
'minna': ('minne',),
'minne': ('minne',),
'minner': ('minne',),
'minnes': ('minne',),
'minnet': ('minne',),
'mint': ('minne',),
'minte': ('minne',),
'minnes': ('minnes',),
'mins': ('minnes',),
'mintes': ('minnes',),
'minsk': ('minske',),
'minska': ('minske',),
'minske': ('minske',),
'minsker': ('minske',),
'minskes': ('minske',),
'minsket': ('minske',),
'misbillig': ('misbillige',),
'misbilliga': ('misbillige',),
'misbillige': ('misbillige',),
'misbilliger': ('misbillige',),
'misbilliges': ('misbillige',),
'misbilliget': ('misbillige',),
'misbruk': ('misbruke',),
'misbruke': ('misbruke',),
'misbruker': ('misbruke',),
'misbrukes': ('misbruke',),
'misbrukt': ('misbruke',),
'misbrukte': ('misbruke',),
'misfar': ('misfare',),
'misfare': ('misfare',),
'misfarer': ('misfare',),
'misfares': ('misfare',),
'misfart': ('misfare',),
'misfor': ('misfare',),
'misfarg': ('misfarge',),
'misfarga': ('misfarge',),
'misfarge': ('misfarge',),
'misfarger': ('misfarge',),
'misfarges': ('misfarge',),
'misfarget': ('misfarge',),
'misforsto': ('misforstå',),
'misforstod': ('misforstå',),
'misforstå': ('misforstå',),
'misforståes': ('misforstå',),
'misforstår': ('misforstå',),
'misforstås': ('misforstå',),
'misforstått': ('misforstå',),
'mishag': ('mishage',),
'mishaga': ('mishage',),
'mishage': ('mishage',),
'mishager': ('mishage',),
'mishages': ('mishage',),
'mishaget': ('mishage',),
'mishandl': ('mishandle',),
'mishandla': ('mishandle',),
'mishandle': ('mishandle',),
'mishandler': ('mishandle',),
'mishandles': ('mishandle',),
'mishandlet': ('mishandle',),
'mishør': ('mishøre',),
'mishøre': ('mishøre',),
'mishører': ('mishøre',),
'mishøres': ('mishøre',),
'mishørt': ('mishøre',),
'mishørte': ('mishøre',),
'misjoner': ('misjonere',),
'misjonere': ('misjonere',),
'misjonerer': ('misjonere',),
'misjoneres': ('misjonere',),
'misjonert': ('misjonere',),
'misjonerte': ('misjonere',),
'miskjenn': ('miskjenne',),
'miskjenne': ('miskjenne',),
'miskjenner': ('miskjenne',),
'miskjennes': ('miskjenne',),
'miskjent': ('miskjenne',),
'miskjente': ('miskjenne',),
'miskle': ('miskle',),
'miskledd': ('miskle',),
'miskledde': ('miskle',),
'miskler': ('miskle',),
'miskles': ('miskle',),
'miskunn': ('miskunne',),
'miskunne': ('miskunne',),
'miskunner': ('miskunne',),
'miskunnes': ('miskunne',),
'miskunt': ('miskunne',),
'miskunte': ('miskunne',),
'mislighold': ('misligholde',),
'misligholde': ('misligholde',),
'misligholder': ('misligholde',),
'misligholdes': ('misligholde',),
'misligholdt': ('misligholde',),
'mislik': ('mislike',),
'mislike': ('mislike',),
'misliker': ('mislike',),
'mislikes': ('mislike',),
'mislikt': ('mislike',),
'mislikte': ('mislike',),
'mislykkes': ('mislykkes',),
'mislyktes': ('mislykkes',),
'misoppfatt': ('misoppfatte',),
'misoppfatta': ('misoppfatte',),
'misoppfatte': ('misoppfatte',),
'misoppfatter': ('misoppfatte',),
'misoppfattes': ('misoppfatte',),
'misoppfattet': ('misoppfatte',),
'misregn': ('misregne',),
'misregna': ('misregne',),
'misregne': ('misregne',),
'misregner': ('misregne',),
'misregnes': ('misregne',),
'misregnet': ('misregne',),
'misrekn': ('misrekne',),
'misrekna': ('misrekne',),
'misrekne': ('misrekne',),
'misrekner': ('misrekne',),
'misreknes': ('misrekne',),
'misreknet': ('misrekne',),
'missnakk': ('missnakke',),
'missnakka': ('missnakke',),
'missnakke': ('missnakke',),
'missnakker': ('missnakke',),
'missnakkes': ('missnakke',),
'missnakket': ('missnakke',),
'mista': ('mista',),
'mistaes': ('mista',),
'mistar': ('mista',),
'mistas': ('mista',),
'mistatt': ('mista',),
'mistok': ('mista',),
'mist': ('miste',),
'mista': ('miste',),
'miste': ('miste',),
'mister': ('miste',),
'mistes': ('miste',),
'mistet': ('miste',),
'mistenk': ('mistenke',),
'mistenke': ('mistenke',),
'mistenker': ('mistenke',),
'mistenkes': ('mistenke',),
'mistenkt': ('mistenke',),
'mistenkte': ('mistenke',),
'mistenkeliggjorde': ('mistenkeliggjøre',),
'mistenkeliggjort': ('mistenkeliggjøre',),
'mistenkeliggjør': ('mistenkeliggjøre',),
'mistenkeliggjøre': ('mistenkeliggjøre',),
'mistenkeliggjøres': ('mistenkeliggjøre',),
'mistolk': ('mistolke',),
'mistolka': ('mistolke',),
'mistolke': ('mistolke',),
'mistolker': ('mistolke',),
'mistolkes': ('mistolke',),
'mistolket': ('mistolke',),
'mistreivs': ('mistrives',),
'mistrivdes': ('mistrives',),
'mistrives': ('mistrives',),
'mistrivs': ('mistrives',),
'mistro': ('mistro',),
'mistrodd': ('mistro',),
'mistrodde': ('mistro',),
'mistror': ('mistro',),
'mistros': ('mistro',),
'mistru': ('mistru',),
'mistrudd': ('mistru',),
'mistrudde': ('mistru',),
'mistrur': ('mistru',),
'mistrus': ('mistru',),
'misunn': ('misunne',),
'misunne': ('misunne',),
'misunner': ('misunne',),
'misunnes': ('misunne',),
'misunnet': ('misunne',),
'misunt': ('misunne',),
'misunte': ('misunne',),
'mjau': ('mjaue',),
'mjaua': ('mjaue',),
'mjaue': ('mjaue',),
'mjauer': ('mjaue',),
'mjaues': ('mjaue',),
'mjauet': ('mjaue',),
'mjukland': ('mjuklande',),
'mjuklanda': ('mjuklande',),
'mjuklande': ('mjuklande',),
'mjuklander': ('mjuklande',),
'mjuklandes': ('mjuklande',),
'mjuklandet': ('mjuklande',),
'mjukn': ('mjukne',),
'mjukna': ('mjukne',),
'mjukne': ('mjukne',),
'mjukner': ('mjukne',),
'mjuknes': ('mjukne',),
'mjuknet': ('mjukne',),
'mjukn': ('mjukne',),
'mjukna': ('mjukne',),
'mjukne': ('mjukne',),
'mjukner': ('mjukne',),
'mjuknes': ('mjukne',),
'mjuknet': ('mjukne',),
'mjøl': ('mjøle',),
'mjøla': ('mjøle',),
'mjøle': ('mjøle',),
'mjøler': ('mjøle',),
'mjøles': ('mjøle',),
'mjølet': ('mjøle',),
'mjølt': ('mjøle',),
'mjølte': ('mjøle',),
'mjølk': ('mjølke',),
'mjølka': ('mjølke',),
'mjølke': ('mjølke',),
'mjølker': ('mjølke',),
'mjølkes': ('mjølke',),
'mjølket': ('mjølke',),
'mobb': ('mobbe',),
'mobba': ('mobbe',),
'mobbe': ('mobbe',),
'mobber': ('mobbe',),
'mobbes': ('mobbe',),
'mobbet': ('mobbe',),
'mobiliser': ('mobilisere',),
'mobilisere': ('mobilisere',),
'mobiliserer': ('mobilisere',),
'mobiliseres': ('mobilisere',),
'mobilisert': ('mobilisere',),
'mobiliserte': ('mobilisere',),
'modeller': ('modellere',),
'modellere': ('modellere',),
'modellerer': ('modellere',),
'modelleres': ('modellere',),
'modellert': ('modellere',),
'modellerte': ('modellere',),
'moderer': ('moderere',),
'moderere': ('moderere',),
'modererer': ('moderere',),
'modereres': ('moderere',),
'moderert': ('moderere',),
'modererte': ('moderere',),
'moderniser': ('modernisere',),
'modernisere': ('modernisere',),
'moderniserer': ('modernisere',),
'moderniseres': ('modernisere',),
'modernisert': ('modernisere',),
'moderniserte': ('modernisere',),
'modifiser': ('modifisere',),
'modifisere': ('modifisere',),
'modifiserer': ('modifisere',),
'modifiseres': ('modifisere',),
'modifisert': ('modifisere',),
'modifiserte': ('modifisere',),
'modn': ('modne',),
'modna': ('modne',),
'modne': ('modne',),
'modner': ('modne',),
'modnes': ('modne',),
'modnet': ('modne',),
'modnedes': ('modnes',),
'modnes': ('modnes',),
'moduler': ('modulere',),
'modulere': ('modulere',),
'modulerer': ('modulere',),
'moduleres': ('modulere',),
'modulert': ('modulere',),
'modulerte': ('modulere',),
'mold': ('molde',),
'molda': ('molde',),
'molde': ('molde',),
'molder': ('molde',),
'moldes': ('molde',),
'moldet': ('molde',),
'molester': ('molestere',),
'molestere': ('molestere',),
'molesterer': ('molestere',),
'molesteres': ('molestere',),
'molestert': ('molestere',),
'molesterte': ('molestere',),
'momp': ('mompe',),
'mompa': ('mompe',),
'mompe': ('mompe',),
'momper': ('mompe',),
'mompes': ('mompe',),
'mompet': ('mompe',),
'monn': ('monne',),
'monna': ('monne',),
'monne': ('monne',),
'monner': ('monne',),
'monnes': ('monne',),
'monnet': ('monne',),
'mon': ('monne',),
'monne': ('monne',),
'monoftonger': ('monoftongere',),
'monoftongere': ('monoftongere',),
'monoftongerer': ('monoftongere',),
'monoftongeres': ('monoftongere',),
'monoftongert': ('monoftongere',),
'monoftongerte': ('monoftongere',),
'monopoliser': ('monopolisere',),
'monopolisere': ('monopolisere',),
'monopoliserer': ('monopolisere',),
'monopoliseres': ('monopolisere',),
'monopolisert': ('monopolisere',),
'monopoliserte': ('monopolisere',),
'monter': ('montere',),
'montere': ('montere',),
'monterer': ('montere',),
'monteres': ('montere',),
'montert': ('montere',),
'monterte': ('montere',),
'mopp': ('moppe',),
'moppa': ('moppe',),
'moppe': ('moppe',),
'mopper': ('moppe',),
'moppes': ('moppe',),
'moppet': ('moppe',),
'moraliser': ('moralisere',),
'moralisere': ('moralisere',),
'moraliserer': ('moralisere',),
'moraliseres': ('moralisere',),
'moralisert': ('moralisere',),
'moraliserte': ('moralisere',),
'mor': ('more',),
'mora': ('more',),
'more': ('more',),
'morer': ('more',),
'mores': ('more',),
'moret': ('more',),
'mor': ('more',),
'mora': ('more',),
'more': ('more',),
'morer': ('more',),
'mores': ('more',),
'moret': ('more',),
'mort': ('more',),
'morte': ('more',),
'morgn': ('morgne',),
'morgna': ('morgne',),
'morgne': ('morgne',),
'morgner': ('morgne',),
'morgnes': ('morgne',),
'morgnet': ('morgne',),
'morkn': ('morkne',),
'morkna': ('morkne',),
'morkne': ('morkne',),
'morkner': ('morkne',),
'morknes': ('morkne',),
'morknet': ('morkne',),
'mors': ('morse',),
'morsa': ('morse',),
'morse': ('morse',),
'morser': ('morse',),
'morses': ('morse',),
'morset': ('morse',),
'morsk': ('morske',),
'morska': ('morske',),
'morske': ('morske',),
'morsker': ('morske',),
'morskes': ('morske',),
'morsket': ('morske',),
'mortifiser': ('mortifisere',),
'mortifisere': ('mortifisere',),
'mortifiserer': ('mortifisere',),
'mortifiseres': ('mortifisere',),
'mortifisert': ('mortifisere',),
'mortifiserte': ('mortifisere',),
'mosjoner': ('mosjonere',),
'mosjonere': ('mosjonere',),
'mosjonerer': ('mosjonere',),
'mosjoneres': ('mosjonere',),
'mosjonert': ('mosjonere',),
'mosjonerte': ('mosjonere',),
'motarbeid': ('motarbeide',),
'motarbeida': ('motarbeide',),
'motarbeidd': ('motarbeide',),
'motarbeidde': ('motarbeide',),
'motarbeide': ('motarbeide',),
'motarbeider': ('motarbeide',),
'motarbeides': ('motarbeide',),
'motarbeidet': ('motarbeide',),
'motbevis': ('motbevise',),
'motbevise': ('motbevise',),
'motbeviser': ('motbevise',),
'motbevises': ('motbevise',),
'motbevist': ('motbevise',),
'motbeviste': ('motbevise',),
'motiver': ('motivere',),
'motivere': ('motivere',),
'motiverer': ('motivere',),
'motiveres': ('motivere',),
'motivert': ('motivere',),
'motiverte': ('motivere',),
'motoriser': ('motorisere',),
'motorisere': ('motorisere',),
'motoriserer': ('motorisere',),
'motoriseres': ('motorisere',),
'motorisert': ('motorisere',),
'motoriserte': ('motorisere',),
'motsatt': ('motsette',),
'motsatte': ('motsette',),
'motsett': ('motsette',),
'motsette': ('motsette',),
'motsetter': ('motsette',),
'motsettes': ('motsette',),
'motsvar': ('motsvare',),
'motsvara': ('motsvare',),
'motsvare': ('motsvare',),
'motsvarer': ('motsvare',),
'motsvares': ('motsvare',),
'motsvart': ('motsvare',),
'motsvarte': ('motsvare',),
'motta': ('motta',),
'mottaes': ('motta',),
'mottar': ('motta',),
'mottas': ('motta',),
'mottatt': ('motta',),
'mottok': ('motta',),
'motvirk': ('motvirke',),
'motvirka': ('motvirke',),
'motvirke': ('motvirke',),
'motvirker': ('motvirke',),
'motvirkes': ('motvirke',),
'motvirket': ('motvirke',),
'mover': ('movere',),
'movere': ('movere',),
'moverer': ('movere',),
'moveres': ('movere',),
'movert': ('movere',),
'moverte': ('movere',),
'mudr': ('mudre',),
'mudra': ('mudre',),
'mudre': ('mudre',),
'mudrer': ('mudre',),
'mudres': ('mudre',),
'mudret': ('mudre',),
'mudr': ('mudre',),
'mudra': ('mudre',),
'mudre': ('mudre',),
'mudrer': ('mudre',),
'mudres': ('mudre',),
'mudret': ('mudre',),
'mug': ('muge',),
'muga': ('muge',),
'muge': ('muge',),
'muger': ('muge',),
'muges': ('muge',),
'muget': ('muge',),
'mugg': ('mugge',),
'mugga': ('mugge',),
'mugge': ('mugge',),
'mugger': ('mugge',),
'mugges': ('mugge',),
'mugget': ('mugge',),
'mugn': ('mugne',),
'mugna': ('mugne',),
'mugne': ('mugne',),
'mugner': ('mugne',),
'mugnes': ('mugne',),
'mugnet': ('mugne',),
'mukk': ('mukke',),
'mukka': ('mukke',),
'mukke': ('mukke',),
'mukker': ('mukke',),
'mukkes': ('mukke',),
'mukket': ('mukke',),
'muld': ('mulde',),
'mulda': ('mulde',),
'mulde': ('mulde',),
'mulder': ('mulde',),
'muldes': ('mulde',),
'muldet': ('mulde',),
'mul': ('mule',),
'mule': ('mule',),
'muler': ('mule',),
'mules': ('mule',),
'mult': ('mule',),
'multe': ('mule',),
'mulebandt': ('mulebinde',),
'mulebind': ('mulebinde',),
'mulebinde': ('mulebinde',),
'mulebinder': ('mulebinde',),
'mulebindes': ('mulebinde',),
'mulebundet': ('mulebinde',),
'muliggjorde': ('muliggjøre',),
'muliggjort': ('muliggjøre',),
'muliggjør': ('muliggjøre',),
'muliggjøre': ('muliggjøre',),
'muliggjøres': ('muliggjøre',),
'muljer': ('muljere',),
'muljere': ('muljere',),
'muljerer': ('muljere',),
'muljeres': ('muljere',),
'muljert': ('muljere',),
'muljerte': ('muljere',),
'mulkt': ('mulkte',),
'mulkta': ('mulkte',),
'mulkte': ('mulkte',),
'mulkter': ('mulkte',),
'mulktes': ('mulkte',),
'mulktet': ('mulkte',),
'mulkter': ('mulktere',),
'mulktere': ('mulktere',),
'mulkterer': ('mulktere',),
'mulkteres': ('mulktere',),
'mulktert': ('mulktere',),
'mulkterte': ('mulktere',),
'mull': ('mulle',),
'mulla': ('mulle',),
'mulle': ('mulle',),
'muller': ('mulle',),
'mulles': ('mulle',),
'mullet': ('mulle',),
'muln': ('mulne',),
'mulna': ('mulne',),
'mulne': ('mulne',),
'mulner': ('mulne',),
'mulnes': ('mulne',),
'mulnet': ('mulne',),
'mulr': ('mulre',),
'mulra': ('mulre',),
'mulre': ('mulre',),
'mulrer': ('mulre',),
'mulres': ('mulre',),
'mulret': ('mulre',),
'multipliser': ('multiplisere',),
'multiplisere': ('multiplisere',),
'multipliserer': ('multiplisere',),
'multipliseres': ('multiplisere',),
'multiplisert': ('multiplisere',),
'multipliserte': ('multiplisere',),
'mumifiser': ('mumifisere',),
'mumifisere': ('mumifisere',),
'mumifiserer': ('mumifisere',),
'mumifiseres': ('mumifisere',),
'mumifisert': ('mumifisere',),
'mumifiserte': ('mumifisere',),
'mumiser': ('mumisere',),
'mumisere': ('mumisere',),
'mumiserer': ('mumisere',),
'mumiseres': ('mumisere',),
'mumisert': ('mumisere',),
'mumiserte': ('mumisere',),
'muml': ('mumle',),
'mumla': ('mumle',),
'mumle': ('mumle',),
'mumler': ('mumle',),
'mumles': ('mumle',),
'mumlet': ('mumle',),
'mums': ('mumse',),
'mumsa': ('mumse',),
'mumse': ('mumse',),
'mumser': ('mumse',),
'mumses': ('mumse',),
'mumset': ('mumse',),
'munn': ('munne',),
'munna': ('munne',),
'munne': ('munne',),
'munner': ('munne',),
'munnes': ('munne',),
'munnet': ('munne',),
'munnhogdes': ('munnhogges',),
'munnhogges': ('munnhogges',),
'munnhugdes': ('munnhugges',),
'munnhugges': ('munnhugges',),
'muntr': ('muntre',),
'muntra': ('muntre',),
'muntre': ('muntre',),
'muntrer': ('muntre',),
'muntres': ('muntre',),
'muntret': ('muntre',),
'mur': ('mure',),
'mura': ('mure',),
'mure': ('mure',),
'murer': ('mure',),
'mures': ('mure',),
'muret': ('mure',),
'murt': ('mure',),
'murte': ('mure',),
'murr': ('murre',),
'murra': ('murre',),
'murre': ('murre',),
'murrer': ('murre',),
'murres': ('murre',),
'murret': ('murre',),
'musiser': ('musisere',),
'musisere': ('musisere',),
'musiserer': ('musisere',),
'musiseres': ('musisere',),
'musisert': ('musisere',),
'musiserte': ('musisere',),
'musser': ('mussere',),
'mussere': ('mussere',),
'musserer': ('mussere',),
'musseres': ('mussere',),
'mussert': ('mussere',),
'musserte': ('mussere',),
'mut': ('mute',),
'muta': ('mute',),
'mute': ('mute',),
'muter': ('mute',),
'mutes': ('mute',),
'mutet': ('mute',),
'mut': ('mute',),
'muta': ('mute',),
'mute': ('mute',),
'muter': ('mute',),
'mutes': ('mute',),
'mutet': ('mute',),
'muter': ('mutere',),
'mutere': ('mutere',),
'muterer': ('mutere',),
'muteres': ('mutere',),
'mutert': ('mutere',),
'muterte': ('mutere',),
'mygl': ('mygle',),
'mygla': ('mygle',),
'mygle': ('mygle',),
'mygler': ('mygle',),
'mygles': ('mygle',),
'myglet': ('mygle',),
'myk': ('myke',),
'myka': ('myke',),
'myke': ('myke',),
'myker': ('myke',),
'mykes': ('myke',),
'myket': ('myke',),
'mykt': ('myke',),
'mykte': ('myke',),
'mykland': ('myklande',),
'myklanda': ('myklande',),
'myklande': ('myklande',),
'myklander': ('myklande',),
'myklandes': ('myklande',),
'myklandet': ('myklande',),
'mykn': ('mykne',),
'mykna': ('mykne',),
'mykne': ('mykne',),
'mykner': ('mykne',),
'myknes': ('mykne',),
'myknet': ('mykne',),
'mykn': ('mykne',),
'mykna': ('mykne',),
'mykne': ('mykne',),
'mykner': ('mykne',),
'myknes': ('mykne',),
'myknet': ('mykne',),
'myldr': ('myldre',),
'myldra': ('myldre',),
'myldre': ('myldre',),
'myldrer': ('myldre',),
'myldres': ('myldre',),
'myldret': ('myldre',),
'mynt': ('mynte',),
'mynta': ('mynte',),
'mynte': ('mynte',),
'mynter': ('mynte',),
'myntes': ('mynte',),
'myntet': ('mynte',),
'myrd': ('myrde',),
'myrda': ('myrde',),
'myrde': ('myrde',),
'myrder': ('myrde',),
'myrdes': ('myrde',),
'myrdet': ('myrde',),
'mys': ('myse',),
'myse': ('myse',),
'myser': ('myse',),
'myses': ('myse',),
'myst': ('myse',),
'myste': ('myse',),
'mystifiser': ('mystifisere',),
'mystifisere': ('mystifisere',),
'mystifiserer': ('mystifisere',),
'mystifiseres': ('mystifisere',),
'mystifisert': ('mystifisere',),
'mystifiserte': ('mystifisere',),
'myt': ('myte',),
'myta': ('myte',),
'myte': ('myte',),
'myter': ('myte',),
'mytes': ('myte',),
'mytet': ('myte',),
'mytt': ('myte',),
'mytte': ('myte',),
'måk': ('måke',),
'måka': ('måke',),
'måke': ('måke',),
'måker': ('måke',),
'måkes': ('måke',),
'måket': ('måke',),
'måkt': ('måke',),
'måkte': ('måke',),
'målbandt': ('målbinde',),
'målbind': ('målbinde',),
'målbinde': ('målbinde',),
'målbinder': ('målbinde',),
'målbindes': ('målbinde',),
'målbundet': ('målbinde',),
'mål': ('måle',),
'måle': ('måle',),
'måler': ('måle',),
'måles': ('måle',),
'målt': ('måle',),
'målte': ('måle',),
'måp': ('måpe',),
'måpe': ('måpe',),
'måper': ('måpe',),
'måpes': ('måpe',),
'måpt': ('måpe',),
'måpte': ('måpe',),
'måt': ('måte',),
'måta': ('måte',),
'måte': ('måte',),
'måter': ('måte',),
'måtes': ('måte',),
'måtet': ('måte',),
'må': ('måtte',),
'måtte': ('måtte',),
'måttet': ('måtte',),
'mæl': ('mæle',),
'mæle': ('mæle',),
'mæler': ('mæle',),
'mæles': ('mæle',),
'mælt': ('mæle',),
'mælte': ('mæle',),
'mæl': ('mæle',),
'mæle': ('mæle',),
'mæler': ('mæle',),
'mæles': ('mæle',),
'mælt': ('mæle',),
'mælte': ('mæle',),
'mæt': ('mæte',),
'mæte': ('mæte',),
'mæter': ('mæte',),
'mætes': ('mæte',),
'mætt': ('mæte',),
'mætte': ('mæte',),
'møbler': ('møblere',),
'møblere': ('møblere',),
'møblerer': ('møblere',),
'møbleres': ('møblere',),
'møblert': ('møblere',),
'møblerte': ('møblere',),
'møkk': ('møkke',),
'møkka': ('møkke',),
'møkke': ('møkke',),
'møkker': ('møkke',),
'møkkes': ('møkke',),
'møkket': ('møkke',),
'mønj': ('mønje',),
'mønja': ('mønje',),
'mønje': ('mønje',),
'mønjer': ('mønje',),
'mønjes': ('mønje',),
'mønjet': ('mønje',),
'mønstr': ('mønstre',),
'mønstra': ('mønstre',),
'mønstre': ('mønstre',),
'mønstrer': ('mønstre',),
'mønstres': ('mønstre',),
'mønstret': ('mønstre',),
'mørbank': ('mørbanke',),
'mørbanka': ('mørbanke',),
'mørbanke': ('mørbanke',),
'mørbanker': ('mørbanke',),
'mørbankes': ('mørbanke',),
'mørbanket': ('mørbanke',),
'mørk': ('mørke',),
'mørka': ('mørke',),
'mørke': ('mørke',),
'mørker': ('mørke',),
'mørkes': ('mørke',),
'mørket': ('mørke',),
'mørkla': ('mørklegge',),
'mørklagt': ('mørklegge',),
'mørklegg': ('mørklegge',),
'mørklegge': ('mørklegge',),
'mørklegger': ('mørklegge',),
'mørklegges': ('mørklegge',),
'mørkn': ('mørkne',),
'mørkna': ('mørkne',),
'mørkne': ('mørkne',),
'mørkner': ('mørkne',),
'mørknes': ('mørkne',),
'mørknet': ('mørkne',),
'mørn': ('mørne',),
'mørna': ('mørne',),
'mørne': ('mørne',),
'mørner': ('mørne',),
'mørnes': ('mørne',),
'mørnet': ('mørne',),
'møt': ('møte',),
'møte': ('møte',),
'møter': ('møte',),
'møtes': ('møte',),
'møtt': ('møte',),
'møtte': ('møte',),
'møtes': ('møtes',),
'møts': ('møtes',),
'møttes': ('møtes',),
'nag': ('nage',),
'naga': ('nage',),
'nagd': ('nage',),
'nagde': ('nage',),
'nage': ('nage',),
'nager': ('nage',),
'nages': ('nage',),
'naget': ('nage',),
'nagl': ('nagle',),
'nagla': ('nagle',),
'nagle': ('nagle',),
'nagler': ('nagle',),
'nagles': ('nagle',),
'naglet': ('nagle',),
'napp': ('nappe',),
'nappa': ('nappe',),
'nappe': ('nappe',),
'napper': ('nappe',),
'nappes': ('nappe',),
'nappet': ('nappe',),
'narkotiser': ('narkotisere',),
'narkotisere': ('narkotisere',),
'narkotiserer': ('narkotisere',),
'narkotiseres': ('narkotisere',),
'narkotisert': ('narkotisere',),
'narkotiserte': ('narkotisere',),
'narr': ('narre',),
'narra': ('narre',),
'narre': ('narre',),
'narrer': ('narre',),
'narres': ('narre',),
'narret': ('narre',),
'nasaler': ('nasalere',),
'nasalere': ('nasalere',),
'nasalerer': ('nasalere',),
'nasaleres': ('nasalere',),
'nasalert': ('nasalere',),
'nasalerte': ('nasalere',),
'nasjonaliser': ('nasjonalisere',),
'nasjonalisere': ('nasjonalisere',),
'nasjonaliserer': ('nasjonalisere',),
'nasjonaliseres': ('nasjonalisere',),
'nasjonalisert': ('nasjonalisere',),
'nasjonaliserte': ('nasjonalisere',),
'nask': ('naske',),
'naska': ('naske',),
'naske': ('naske',),
'nasker': ('naske',),
'naskes': ('naske',),
'nasket': ('naske',),
'nat': ('nate',),
'nata': ('nate',),
'nate': ('nate',),
'nater': ('nate',),
'nates': ('nate',),
'natet': ('nate',),
'natt': ('natte',),
'natta': ('natte',),
'natte': ('natte',),
'natter': ('natte',),
'nattes': ('natte',),
'nattet': ('natte',),
'naturaliser': ('naturalisere',),
'naturalisere': ('naturalisere',),
'naturaliserer': ('naturalisere',),
'naturaliseres': ('naturalisere',),
'naturalisert': ('naturalisere',),
'naturaliserte': ('naturalisere',),
'nauba': ('naube',),
'naubad': ('naube',),
'naube': ('naube',),
'naubedt': ('naube',),
'nauber': ('naube',),
'naubes': ('naube',),
'nau': ('naue',),
'naua': ('naue',),
'naud': ('naue',),
'naude': ('naue',),
'naue': ('naue',),
'nauer': ('naue',),
'naues': ('naue',),
'nauet': ('naue',),
'naviger': ('navigere',),
'navigere': ('navigere',),
'navigerer': ('navigere',),
'navigeres': ('navigere',),
'navigert': ('navigere',),
'navigerte': ('navigere',),
'navl': ('navle',),
'navla': ('navle',),
'navle': ('navle',),
'navler': ('navle',),
'navles': ('navle',),
'navlet': ('navle',),
'navn': ('navne',),
'navna': ('navne',),
'navne': ('navne',),
'navner': ('navne',),
'navnes': ('navne',),
'navnet': ('navne',),
'navnga': ('navngi',),
'navngav': ('navngi',),
'navngi': ('navngi',),
'navngies': ('navngi',),
'navngir': ('navngi',),
'navngis': ('navngi',),
'navngitt': ('navngi',),
'nazifiser': ('nazifisere',),
'nazifisere': ('nazifisere',),
'nazifiserer': ('nazifisere',),
'nazifiseres': ('nazifisere',),
'nazifisert': ('nazifisere',),
'nazifiserte': ('nazifisere',),
'nebbes': ('nebbes',),
'nedarvedes': ('nedarves',),
'nedarves': ('nedarves',),
'nedbraut': ('nedbryte',),
'nedbrutt': ('nedbryte',),
'nedbryt': ('nedbryte',),
'nedbryte': ('nedbryte',),
'nedbryter': ('nedbryte',),
'nedbrytes': ('nedbryte',),
'nedbrøt': ('nedbryte',),
'nedbrøyt': ('nedbryte',),
'nedbygd': ('nedbygge',),
'nedbygde': ('nedbygge',),
'nedbygg': ('nedbygge',),
'nedbygga': ('nedbygge',),
'nedbygge': ('nedbygge',),
'nedbygger': ('nedbygge',),
'nedbygges': ('nedbygge',),
'nedbygget': ('nedbygge',),
'neddem': ('neddemme',),
'neddemm': ('neddemme',),
'neddemma': ('neddemme',),
'neddemme': ('neddemme',),
'neddemmer': ('neddemme',),
'neddemmes': ('neddemme',),
'neddemmet': ('neddemme',),
'neddemt': ('neddemme',),
'neddemte': ('neddemme',),
'nedfell': ('nedfelle',),
'nedfelle': ('nedfelle',),
'nedfeller': ('nedfelle',),
'nedfelles': ('nedfelle',),
'nedfelt': ('nedfelle',),
'nedfelte': ('nedfelle',),
'nedkall': ('nedkalle',),
'nedkalle': ('nedkalle',),
'nedkaller': ('nedkalle',),
'nedkalles': ('nedkalle',),
'nedkalt': ('nedkalle',),
'nedkalte': ('nedkalle',),
'nedkjemp': ('nedkjempe',),
'nedkjempa': ('nedkjempe',),
'nedkjempe': ('nedkjempe',),
'nedkjemper': ('nedkjempe',),
'nedkjempes': ('nedkjempe',),
'nedkjempet': ('nedkjempe',),
'nedkjøl': ('nedkjøle',),
'nedkjøle': ('nedkjøle',),
'nedkjøler': ('nedkjøle',),
'nedkjøles': ('nedkjøle',),
'nedkjølt': ('nedkjøle',),
'nedkjølte': ('nedkjøle',),
'nedkjør': ('nedkjøre',),
'nedkjøre': ('nedkjøre',),
'nedkjører': ('nedkjøre',),
'nedkjøres': ('nedkjøre',),
'nedkjørt': ('nedkjøre',),
'nedkjørte': ('nedkjøre',),
'nedkom': ('nedkomme',),
'nedkomme': ('nedkomme',),
'nedkommer': ('nedkomme',),
'nedkommes': ('nedkomme',),
'nedkommet': ('nedkomme',),
'nedlat': ('nedlate',),
'nedlate': ('nedlate',),
'nedlater': ('nedlate',),
'nedlates': ('nedlate',),
'nedlatt': ('nedlate',),
'nedlot': ('nedlate',),
'nedla': ('nedlegge',),
'nedlagt': ('nedlegge',),
'nedlegg': ('nedlegge',),
'nedlegge': ('nedlegge',),
'nedlegger': ('nedlegge',),
'nedlegges': ('nedlegge',),
'nedmold': ('nedmolde',),
'nedmolda': ('nedmolde',),
'nedmolde': ('nedmolde',),
'nedmolder': ('nedmolde',),
'nedmoldes': ('nedmolde',),
'nedmoldet': ('nedmolde',),
'nedmuld': ('nedmulde',),
'nedmulda': ('nedmulde',),
'nedmulde': ('nedmulde',),
'nedmulder': ('nedmulde',),
'nedmuldes': ('nedmulde',),
'nedmuldet': ('nedmulde',),
'nedprioriter': ('nedprioritere',),
'nedprioritere': ('nedprioritere',),
'nedprioriterer': ('nedprioritere',),
'nedprioriteres': ('nedprioritere',),
'nedprioritert': ('nedprioritere',),
'nedprioriterte': ('nedprioritere',),
'nedring': ('nedringe',),
'nedringe': ('nedringe',),
'nedringer': ('nedringe',),
'nedringes': ('nedringe',),
'nedringt': ('nedringe',),
'nedringte': ('nedringe',),
'nedsabl': ('nedsable',),
'nedsabla': ('nedsable',),
'nedsable': ('nedsable',),
'nedsabler': ('nedsable',),
'nedsables': ('nedsable',),
'nedsablet': ('nedsable',),
'nedsatt': ('nedsette',),
'nedsatte': ('nedsette',),
'nedsett': ('nedsette',),
'nedsette': ('nedsette',),
'nedsetter': ('nedsette',),
'nedsettes': ('nedsette',),
'nedskreiv': ('nedskrive',),
'nedskrev': ('nedskrive',),
'nedskrevet': ('nedskrive',),
'nedskriv': ('nedskrive',),
'nedskrive': ('nedskrive',),
'nedskriver': ('nedskrive',),
'nedskrives': ('nedskrive',),
'nedstam': ('nedstamme',),
'nedstamma': ('nedstamme',),
'nedstamme': ('nedstamme',),
'nedstammer': ('nedstamme',),
'nedstammes': ('nedstamme',),
'nedstammet': ('nedstamme',),
'nedstem': ('nedstemme',),
'nedstemme': ('nedstemme',),
'nedstemmer': ('nedstemme',),
'nedstemmes': ('nedstemme',),
'nedstemt': ('nedstemme',),
'nedstemte': ('nedstemme',),
'nedtegn': ('nedtegne',),
'nedtegna': ('nedtegne',),
'nedtegne': ('nedtegne',),
'nedtegner': ('nedtegne',),
'nedtegnes': ('nedtegne',),
'nedtegnet': ('nedtegne',),
'nedtrapp': ('nedtrappe',),
'nedtrappa': ('nedtrappe',),
'nedtrappe': ('nedtrappe',),
'nedtrapper': ('nedtrappe',),
'nedtrappes': ('nedtrappe',),
'nedtrappet': ('nedtrappe',),
'nedverdig': ('nedverdige',),
'nedverdiga': ('nedverdige',),
'nedverdige': ('nedverdige',),
'nedverdiger': ('nedverdige',),
'nedverdiges': ('nedverdige',),
'nedverdiget': ('nedverdige',),
'nedvurder': ('nedvurdere',),
'nedvurdere': ('nedvurdere',),
'nedvurderer': ('nedvurdere',),
'nedvurderes': ('nedvurdere',),
'nedvurdert': ('nedvurdere',),
'nedvurderte': ('nedvurdere',),
'neger': ('negere',),
'negere': ('negere',),
'negerer': ('negere',),
'negeres': ('negere',),
'negert': ('negere',),
'negerte': ('negere',),
'neglisjer': ('neglisjere',),
'neglisjere': ('neglisjere',),
'neglisjerer': ('neglisjere',),
'neglisjeres': ('neglisjere',),
'neglisjert': ('neglisjere',),
'neglisjerte': ('neglisjere',),
'nei': ('neie',),
'neia': ('neie',),
'neid': ('neie',),
'neide': ('neie',),
'neie': ('neie',),
'neier': ('neie',),
'neies': ('neie',),
'neiet': ('neie',),
'nei': ('neie',),
'neid': ('neie',),
'neide': ('neie',),
'neie': ('neie',),
'neier': ('neie',),
'neies': ('neie',),
'neiet': ('neie',),
'nei': ('neie',),
'neid': ('neie',),
'neide': ('neie',),
'neie': ('neie',),
'neier': ('neie',),
'neies': ('neie',),
'neiet': ('neie',),
'nekt': ('nekte',),
'nekta': ('nekte',),
'nekte': ('nekte',),
'nekter': ('nekte',),
'nektes': ('nekte',),
'nektet': ('nekte',),
'nenn': ('nenne',),
'nenna': ('nenne',),
'nenne': ('nenne',),
'nenner': ('nenne',),
'nennes': ('nenne',),
'nennet': ('nenne',),
'nent': ('nenne',),
'nente': ('nenne',),
'nest': ('neste',),
'nesta': ('neste',),
'neste': ('neste',),
'nester': ('neste',),
'nestes': ('neste',),
'nestet': ('neste',),
'nett': ('nette',),
'netta': ('nette',),
'nette': ('nette',),
'netter': ('nette',),
'nettes': ('nette',),
'nettet': ('nette',),
'nevehels': ('nevehelse',),
'nevehelse': ('nevehelse',),
'nevehelser': ('nevehelse',),
'nevehelses': ('nevehelse',),
'nevehelst': ('nevehelse',),
'nevehelste': ('nevehelse',),
'nevehils': ('nevehilse',),
'nevehilse': ('nevehilse',),
'nevehilser': ('nevehilse',),
'nevehilses': ('nevehilse',),
'nevehilst': ('nevehilse',),
'nevehilste': ('nevehilse',),
'nevetakes': ('nevetakes',),
'nevetokes': ('nevetakes',),
'nevetoks': ('nevetakes',),
'nevn': ('nevne',),
'nevne': ('nevne',),
'nevner': ('nevne',),
'nevnes': ('nevne',),
'nevnt': ('nevne',),
'nevnte': ('nevne',),
'nidobl': ('nidoble',),
'nidobla': ('nidoble',),
'nidoble': ('nidoble',),
'nidobler': ('nidoble',),
'nidobles': ('nidoble',),
'nidoblet': ('nidoble',),
'nihold': ('niholde',),
'niholde': ('niholde',),
'niholder': ('niholde',),
'niholdes': ('niholde',),
'niholdt': ('niholde',),
'nikk': ('nikke',),
'nikka': ('nikke',),
'nikke': ('nikke',),
'nikker': ('nikke',),
'nikkes': ('nikke',),
'nikket': ('nikke',),
'nipp': ('nippe',),
'nippa': ('nippe',),
'nippe': ('nippe',),
'nipper': ('nippe',),
'nippes': ('nippe',),
'nippet': ('nippe',),
'nipp': ('nippe',),
'nippa': ('nippe',),
'nippe': ('nippe',),
'nipper': ('nippe',),
'nippes': ('nippe',),
'nippet': ('nippe',),
'niss': ('nisse',),
'nissa': ('nisse',),
'nisse': ('nisse',),
'nisser': ('nisse',),
'nisses': ('nisse',),
'nisset': ('nisse',),
'nist': ('niste',),
'nista': ('niste',),
'niste': ('niste',),
'nister': ('niste',),
'nistes': ('niste',),
'nistet': ('niste',),
'nistirr': ('nistirre',),
'nistirra': ('nistirre',),
'nistirre': ('nistirre',),
'nistirrer': ('nistirre',),
'nistirres': ('nistirre',),
'nistirret': ('nistirre',),
'nitrer': ('nitrere',),
'nitrere': ('nitrere',),
'nitrerer': ('nitrere',),
'nitreres': ('nitrere',),
'nitrert': ('nitrere',),
'nitrerte': ('nitrere',),
'nitrifiser': ('nitrifisere',),
'nitrifisere': ('nitrifisere',),
'nitrifiserer': ('nitrifisere',),
'nitrifiseres': ('nitrifisere',),
'nitrifisert': ('nitrifisere',),
'nitrifiserte': ('nitrifisere',),
'nitt': ('nitte',),
'nitta': ('nitte',),
'nitte': ('nitte',),
'nitter': ('nitte',),
'nittes': ('nitte',),
'nittet': ('nitte',),
'niveller': ('nivellere',),
'nivellere': ('nivellere',),
'nivellerer': ('nivellere',),
'nivelleres': ('nivellere',),
'nivellert': ('nivellere',),
'nivellerte': ('nivellere',),
'nomadiser': ('nomadisere',),
'nomadisere': ('nomadisere',),
'nomadiserer': ('nomadisere',),
'nomadiseres': ('nomadisere',),
'nomadisert': ('nomadisere',),
'nomadiserte': ('nomadisere',),
'nominer': ('nominere',),
'nominere': ('nominere',),
'nominerer': ('nominere',),
'nomineres': ('nominere',),
'nominert': ('nominere',),
'nominerte': ('nominere',),
'nonchaler': ('nonchalere',),
'nonchalere': ('nonchalere',),
'nonchalerer': ('nonchalere',),
'nonchaleres': ('nonchalere',),
'nonchalert': ('nonchalere',),
'nonchalerte': ('nonchalere',),
'normaliser': ('normalisere',),
'normalisere': ('normalisere',),
'normaliserer': ('normalisere',),
'normaliseres': ('normalisere',),
'normalisert': ('normalisere',),
'normaliserte': ('normalisere',),
'normer': ('normere',),
'normere': ('normere',),
'normerer': ('normere',),
'normeres': ('normere',),
'normert': ('normere',),
'normerte': ('normere',),
'norsk': ('norske',),
'norska': ('norske',),
'norske': ('norske',),
'norsker': ('norske',),
'norskes': ('norske',),
'norsket': ('norske',),
'noter': ('notere',),
'notere': ('notere',),
'noterer': ('notere',),
'noteres': ('notere',),
'notert': ('notere',),
'noterte': ('notere',),
'notifiser': ('notifisere',),
'notifisere': ('notifisere',),
'notifiserer': ('notifisere',),
'notifiseres': ('notifisere',),
'notifisert': ('notifisere',),
'notifiserte': ('notifisere',),
'nubb': ('nubbe',),
'nubba': ('nubbe',),
'nubbe': ('nubbe',),
'nubber': ('nubbe',),
'nubbes': ('nubbe',),
'nubbet': ('nubbe',),
'nubb': ('nubbe',),
'nubba': ('nubbe',),
'nubbe': ('nubbe',),
'nubber': ('nubbe',),
'nubbes': ('nubbe',),
'nubbet': ('nubbe',),
'nudd': ('nudde',),
'nudda': ('nudde',),
'nudde': ('nudde',),
'nudder': ('nudde',),
'nuddes': ('nudde',),
'nuddet': ('nudde',),
'nufs': ('nufse',),
'nufsa': ('nufse',),
'nufse': ('nufse',),
'nufser': ('nufse',),
'nufses': ('nufse',),
'nufset': ('nufse',),
'nufst': ('nufse',),
'nufste': ('nufse',),
'nugd': ('nugge',),
'nugde': ('nugge',),
'nugg': ('nugge',),
'nugga': ('nugge',),
'nugge': ('nugge',),
'nugger': ('nugge',),
'nugges': ('nugge',),
'nugget': ('nugge',),
'null': ('nulle',),
'nulla': ('nulle',),
'nulle': ('nulle',),
'nuller': ('nulle',),
'nulles': ('nulle',),
'nullet': ('nulle',),
'nummerer': ('nummerere',),
'nummerere': ('nummerere',),
'nummererer': ('nummerere',),
'nummereres': ('nummerere',),
'nummerert': ('nummerere',),
'nummererte': ('nummerere',),
'nupp': ('nuppe',),
'nuppa': ('nuppe',),
'nuppe': ('nuppe',),
'nupper': ('nuppe',),
'nuppes': ('nuppe',),
'nuppet': ('nuppe',),
'nupr': ('nupre',),
'nupra': ('nupre',),
'nupre': ('nupre',),
'nuprer': ('nupre',),
'nupres': ('nupre',),
'nupret': ('nupre',),
'nusk': ('nuske',),
'nuska': ('nuske',),
'nuske': ('nuske',),
'nusker': ('nuske',),
'nuskes': ('nuske',),
'nusket': ('nuske',),
'nusl': ('nusle',),
'nusla': ('nusle',),
'nusle': ('nusle',),
'nusler': ('nusle',),
'nusles': ('nusle',),
'nuslet': ('nusle',),
'nuss': ('nusse',),
'nussa': ('nusse',),
'nusse': ('nusse',),
'nusser': ('nusse',),
'nusses': ('nusse',),
'nusset': ('nusse',),
'nyanser': ('nyansere',),
'nyansere': ('nyansere',),
'nyanserer': ('nyansere',),
'nyanseres': ('nyansere',),
'nyansert': ('nyansere',),
'nyanserte': ('nyansere',),
'nydann': ('nydanne',),
'nydanna': ('nydanne',),
'nydanne': ('nydanne',),
'nydanner': ('nydanne',),
'nydannes': ('nydanne',),
'nydannet': ('nydanne',),
'nydyrk': ('nydyrke',),
'nydyrka': ('nydyrke',),
'nydyrke': ('nydyrke',),
'nydyrker': ('nydyrke',),
'nydyrkes': ('nydyrke',),
'nydyrket': ('nydyrke',),
'ny': ('nye',),
'nya': ('nye',),
'nye': ('nye',),
'nyer': ('nye',),
'nyes': ('nye',),
'nyet': ('nye',),
'nykk': ('nykke',),
'nykka': ('nykke',),
'nykke': ('nykke',),
'nykker': ('nykke',),
'nykkes': ('nykke',),
'nykket': ('nykke',),
'nykt': ('nykke',),
'nykte': ('nykke',),
'nynn': ('nynne',),
'nynna': ('nynne',),
'nynne': ('nynne',),
'nynner': ('nynne',),
'nynnes': ('nynne',),
'nynnet': ('nynne',),
'nyp': ('nype',),
'nype': ('nype',),
'nyper': ('nype',),
'nypes': ('nype',),
'nypt': ('nype',),
'nypte': ('nype',),
'nyrydd': ('nyrydde',),
'nyrydda': ('nyrydde',),
'nyrydde': ('nyrydde',),
'nyrydder': ('nyrydde',),
'nyryddes': ('nyrydde',),
'nyryddet': ('nyrydde',),
'naus': ('nyse',),
'nys': ('nyse',),
'nyse': ('nyse',),
'nyser': ('nyse',),
'nyses': ('nyse',),
'nyst': ('nyse',),
'nyste': ('nyse',),
'nøs': ('nyse',),
'nøys': ('nyse',),
'nyskap': ('nyskape',),
'nyskapa': ('nyskape',),
'nyskape': ('nyskape',),
'nyskaper': ('nyskape',),
'nyskapes': ('nyskape',),
'nyskapt': ('nyskape',),
'nyskapte': ('nyskape',),
'naut': ('nyte',),
'nyt': ('nyte',),
'nyte': ('nyte',),
'nyter': ('nyte',),
'nytes': ('nyte',),
'nytt': ('nyte',),
'nøt': ('nyte',),
'nøyt': ('nyte',),
'nytt': ('nytte',),
'nytta': ('nytte',),
'nytte': ('nytte',),
'nytter': ('nytte',),
'nyttes': ('nytte',),
'nyttet': ('nytte',),
'nyttiggjorde': ('nyttiggjøre',),
'nyttiggjort': ('nyttiggjøre',),
'nyttiggjør': ('nyttiggjøre',),
'nyttiggjøre': ('nyttiggjøre',),
'nyttiggjøres': ('nyttiggjøre',),
'nyv': ('nyve',),
'nyvd': ('nyve',),
'nyvde': ('nyve',),
'nyve': ('nyve',),
'nyver': ('nyve',),
'nyves': ('nyve',),
'nå': ('nå',),
'nådd': ('nå',),
'nådde': ('nå',),
'når': ('nå',),
'nås': ('nå',),
'nåde': ('nåde',),
'nåtl': ('nåtle',),
'nåtla': ('nåtle',),
'nåtle': ('nåtle',),
'nåtler': ('nåtle',),
'nåtles': ('nåtle',),
'nåtlet': ('nåtle',),
'nær': ('nære',),
'næra': ('nære',),
'nære': ('nære',),
'nærer': ('nære',),
'næres': ('nære',),
'næret': ('nære',),
'nært': ('nære',),
'nærte': ('nære',),
'nærles': ('nærlese',),
'nærlese': ('nærlese',),
'nærleser': ('nærlese',),
'nærleses': ('nærlese',),
'nærlest': ('nærlese',),
'nærleste': ('nærlese',),
'nærm': ('nærme',),
'nærma': ('nærme',),
'nærme': ('nærme',),
'nærmer': ('nærme',),
'nærmes': ('nærme',),
'nærmet': ('nærme',),
'nø': ('nø',),
'nødd': ('nø',),
'nødde': ('nø',),
'nør': ('nø',),
'nøs': ('nø',),
'nø': ('nø',),
'nødd': ('nø',),
'nødde': ('nø',),
'nør': ('nø',),
'nøs': ('nø',),
'nød': ('nøde',),
'nøda': ('nøde',),
'nødd': ('nøde',),
'nødde': ('nøde',),
'nøde': ('nøde',),
'nøder': ('nøde',),
'nødes': ('nøde',),
'nødet': ('nøde',),
'nød': ('nøde',),
'nøda': ('nøde',),
'nødd': ('nøde',),
'nødde': ('nøde',),
'nøde': ('nøde',),
'nøder': ('nøde',),
'nødes': ('nøde',),
'nødet': ('nøde',),
'nødland': ('nødlande',),
'nødlanda': ('nødlande',),
'nødlande': ('nødlande',),
'nødlander': ('nødlande',),
'nødlandes': ('nødlande',),
'nødlandet': ('nødlande',),
'nødslakt': ('nødslakte',),
'nødslakta': ('nødslakte',),
'nødslakte': ('nødslakte',),
'nødslakter': ('nødslakte',),
'nødslaktes': ('nødslakte',),
'nødslaktet': ('nødslakte',),
'nødvendiggjorde': ('nødvendiggjøre',),
'nødvendiggjort': ('nødvendiggjøre',),
'nødvendiggjør': ('nødvendiggjøre',),
'nødvendiggjøre': ('nødvendiggjøre',),
'nødvendiggjøres': ('nødvendiggjøre',),
'nøff': ('nøffe',),
'nøffa': ('nøffe',),
'nøffe': ('nøffe',),
'nøffer': ('nøffe',),
'nøffes': ('nøffe',),
'nøffet': ('nøffe',),
'nøl': ('nøle',),
'nøle': ('nøle',),
'nøler': ('nøle',),
'nøles': ('nøle',),
'nølt': ('nøle',),
'nølte': ('nøle',),
'nør': ('nøre',),
'nøra': ('nøre',),
'nøre': ('nøre',),
'nører': ('nøre',),
'nøres': ('nøre',),
'nøret': ('nøre',),
'nørt': ('nøre',),
'nørte': ('nøre',),
'nøst': ('nøste',),
'nøsta': ('nøste',),
'nøste': ('nøste',),
'nøster': ('nøste',),
'nøstes': ('nøste',),
'nøstet': ('nøste',),
'nøy': ('nøye',),
'nøyd': ('nøye',),
'nøyde': ('nøye',),
'nøye': ('nøye',),
'nøyer': ('nøye',),
'nøyes': ('nøye',),
'nøyt': ('nøyte',),
'nøyte': ('nøyte',),
'nøyter': ('nøyte',),
'nøytes': ('nøyte',),
'nøytt': ('nøyte',),
'nøytte': ('nøyte',),
'nøytraliser': ('nøytralisere',),
'nøytralisere': ('nøytralisere',),
'nøytraliserer': ('nøytralisere',),
'nøytraliseres': ('nøytralisere',),
'nøytralisert': ('nøytralisere',),
'nøytraliserte': ('nøytralisere',),
'obduser': ('obdusere',),
'obdusere': ('obdusere',),
'obduserer': ('obdusere',),
'obduseres': ('obdusere',),
'obdusert': ('obdusere',),
'obduserte': ('obdusere',),
'objektiver': ('objektivere',),
'objektivere': ('objektivere',),
'objektiverer': ('objektivere',),
'objektiveres': ('objektivere',),
'objektivert': ('objektivere',),
'objektiverte': ('objektivere',),
'observer': ('observere',),
'observere': ('observere',),
'observerer': ('observere',),
'observeres': ('observere',),
'observert': ('observere',),
'observerte': ('observere',),
'obstruer': ('obstruere',),
'obstruere': ('obstruere',),
'obstruerer': ('obstruere',),
'obstrueres': ('obstruere',),
'obstruert': ('obstruere',),
'obstruerte': ('obstruere',),
'odl': ('odle',),
'odla': ('odle',),
'odle': ('odle',),
'odler': ('odle',),
'odles': ('odle',),
'odlet': ('odle',),
'offerer': ('offerere',),
'offerere': ('offerere',),
'offererer': ('offerere',),
'offereres': ('offerere',),
'offerert': ('offerere',),
'offererte': ('offerere',),
'ofr': ('ofre',),
'ofra': ('ofre',),
'ofre': ('ofre',),
'ofrer': ('ofre',),
'ofres': ('ofre',),
'ofret': ('ofre',),
'oi': ('oie',),
'oia': ('oie',),
'oie': ('oie',),
'oier': ('oie',),
'oies': ('oie',),
'oiet': ('oie',),
'okk': ('okke',),
'okka': ('okke',),
'okke': ('okke',),
'okker': ('okke',),
'okkes': ('okke',),
'okket': ('okke',),
'okkulter': ('okkultere',),
'okkultere': ('okkultere',),
'okkulterer': ('okkultere',),
'okkulteres': ('okkultere',),
'okkultert': ('okkultere',),
'okkulterte': ('okkultere',),
'okkuper': ('okkupere',),
'okkupere': ('okkupere',),
'okkuperer': ('okkupere',),
'okkuperes': ('okkupere',),
'okkupert': ('okkupere',),
'okkuperte': ('okkupere',),
'oksider': ('oksidere',),
'oksidere': ('oksidere',),
'oksiderer': ('oksidere',),
'oksideres': ('oksidere',),
'oksidert': ('oksidere',),
'oksiderte': ('oksidere',),
'okuler': ('okulere',),
'okulere': ('okulere',),
'okulerer': ('okulere',),
'okuleres': ('okulere',),
'okulert': ('okulere',),
'okulerte': ('okulere',),
'olj': ('olje',),
'olja': ('olje',),
'olje': ('olje',),
'oljer': ('olje',),
'oljes': ('olje',),
'oljet': ('olje',),
'olm': ('olme',),
'olma': ('olme',),
'olme': ('olme',),
'olmer': ('olme',),
'olmes': ('olme',),
'olmet': ('olme',),
'omadresser': ('omadressere',),
'omadressere': ('omadressere',),
'omadresserer': ('omadressere',),
'omadresseres': ('omadressere',),
'omadressert': ('omadressere',),
'omadresserte': ('omadressere',),
'omarbeid': ('omarbeide',),
'omarbeida': ('omarbeide',),
'omarbeidd': ('omarbeide',),
'omarbeidde': ('omarbeide',),
'omarbeide': ('omarbeide',),
'omarbeider': ('omarbeide',),
'omarbeides': ('omarbeide',),
'omarbeidet': ('omarbeide',),
'ombestem': ('ombestemme',),
'ombestemme': ('ombestemme',),
'ombestemmer': ('ombestemme',),
'ombestemmes': ('ombestemme',),
'ombestemt': ('ombestemme',),
'ombestemte': ('ombestemme',),
'ombrakk': ('ombrekke',),
'ombrekk': ('ombrekke',),
'ombrekke': ('ombrekke',),
'ombrekker': ('ombrekke',),
'ombrekkes': ('ombrekke',),
'ombrukket': ('ombrekke',),
'ombragt': ('ombringe',),
'ombragte': ('ombringe',),
'ombrakt': ('ombringe',),
'ombrakte': ('ombringe',),
'ombring': ('ombringe',),
'ombringe': ('ombringe',),
'ombringer': ('ombringe',),
'ombringes': ('ombringe',),
'ombar': ('ombære',),
'ombåret': ('ombære',),
'ombær': ('ombære',),
'ombære': ('ombære',),
'ombærer': ('ombære',),
'ombæres': ('ombære',),
'omdann': ('omdanne',),
'omdanna': ('omdanne',),
'omdanne': ('omdanne',),
'omdanner': ('omdanne',),
'omdannes': ('omdanne',),
'omdannet': ('omdanne',),
'omfamn': ('omfamne',),
'omfamna': ('omfamne',),
'omfamne': ('omfamne',),
'omfamner': ('omfamne',),
'omfamnes': ('omfamne',),
'omfamnet': ('omfamne',),
'omfamn': ('omfamne',),
'omfamna': ('omfamne',),
'omfamne': ('omfamne',),
'omfamner': ('omfamne',),
'omfamnes': ('omfamne',),
'omfamnet': ('omfamne',),
'omfatt': ('omfatte',),
'omfatta': ('omfatte',),
'omfatte': ('omfatte',),
'omfatter': ('omfatte',),
'omfattes': ('omfatte',),
'omfattet': ('omfatte',),
'omfavn': ('omfavne',),
'omfavna': ('omfavne',),
'omfavne': ('omfavne',),
'omfavner': ('omfavne',),
'omfavnes': ('omfavne',),
'omfavnet': ('omfavne',),
'omfavn': ('omfavne',),
'omfavna': ('omfavne',),
'omfavne': ('omfavne',),
'omfavner': ('omfavne',),
'omfavnes': ('omfavne',),
'omfavnet': ('omfavne',),
'omform': ('omforme',),
'omforma': ('omforme',),
'omforme': ('omforme',),
'omformer': ('omforme',),
'omformes': ('omforme',),
'omformet': ('omforme',),
'omga': ('omgi',),
'omgav': ('omgi',),
'omgi': ('omgi',),
'omgies': ('omgi',),
'omgir': ('omgi',),
'omgis': ('omgi',),
'omgitt': ('omgi',),
'omgjorde': ('omgjøre',),
'omgjort': ('omgjøre',),
'omgjør': ('omgjøre',),
'omgjøre': ('omgjøre',),
'omgjøres': ('omgjøre',),
'omgikk': ('omgå',),
'omgjekk': ('omgå',),
'omgå': ('omgå',),
'omgåes': ('omgå',),
'omgår': ('omgå',),
'omgås': ('omgå',),
'omgått': ('omgå',),
'omgikkes': ('omgåes',),
'omgiks': ('omgåes',),
'omgåes': ('omgåes',),
'omgåts': ('omgåes',),
'omgåttes': ('omgåes',),
'omgikkes': ('omgås',),
'omgiks': ('omgås',),
'omgås': ('omgås',),
'omgåts': ('omgås',),
'omgåttes': ('omgås',),
'omhandl': ('omhandle',),
'omhandla': ('omhandle',),
'omhandle': ('omhandle',),
'omhandler': ('omhandle',),
'omhandles': ('omhandle',),
'omhandlet': ('omhandle',),
'ominnred': ('ominnrede',),
'ominnreda': ('ominnrede',),
'ominnrede': ('ominnrede',),
'ominnreder': ('ominnrede',),
'ominnredes': ('ominnrede',),
'ominnredet': ('ominnrede',),
'omkalfatr': ('omkalfatre',),
'omkalfatra': ('omkalfatre',),
'omkalfatre': ('omkalfatre',),
'omkalfatrer': ('omkalfatre',),
'omkalfatres': ('omkalfatre',),
'omkalfatret': ('omkalfatre',),
'omkom': ('omkomme',),
'omkomme': ('omkomme',),
'omkommer': ('omkomme',),
'omkommes': ('omkomme',),
'omkommet': ('omkomme',),
'ommøbler': ('ommøblere',),
'ommøblere': ('ommøblere',),
'ommøblerer': ('ommøblere',),
'ommøbleres': ('ommøblere',),
'ommøblert': ('ommøblere',),
'ommøblerte': ('ommøblere',),
'omorganiser': ('omorganisere',),
'omorganisere': ('omorganisere',),
'omorganiserer': ('omorganisere',),
'omorganiseres': ('omorganisere',),
'omorganisert': ('omorganisere',),
'omorganiserte': ('omorganisere',),
'omplant': ('omplante',),
'omplanta': ('omplante',),
'omplante': ('omplante',),
'omplanter': ('omplante',),
'omplantes': ('omplante',),
'omplantet': ('omplante',),
'ompott': ('ompotte',),
'ompotta': ('ompotte',),
'ompotte': ('ompotte',),
'ompotter': ('ompotte',),
'ompottes': ('ompotte',),
'ompottet': ('ompotte',),
'omprikl': ('omprikle',),
'omprikla': ('omprikle',),
'omprikle': ('omprikle',),
'omprikler': ('omprikle',),
'omprikles': ('omprikle',),
'ompriklet': ('omprikle',),
'omprioriter': ('omprioritere',),
'omprioritere': ('omprioritere',),
'omprioriterer': ('omprioritere',),
'omprioriteres': ('omprioritere',),
'omprioritert': ('omprioritere',),
'omprioriterte': ('omprioritere',),
'omprøv': ('omprøve',),
'omprøvd': ('omprøve',),
'omprøvde': ('omprøve',),
'omprøve': ('omprøve',),
'omprøver': ('omprøve',),
'omprøves': ('omprøve',),
'omram': ('omramme',),
'omramma': ('omramme',),
'omramme': ('omramme',),
'omrammer': ('omramme',),
'omrammes': ('omramme',),
'omrammet': ('omramme',),
'omrediger': ('omredigere',),
'omredigere': ('omredigere',),
'omredigerer': ('omredigere',),
'omredigeres': ('omredigere',),
'omredigert': ('omredigere',),
'omredigerte': ('omredigere',),
'omregn': ('omregne',),
'omregna': ('omregne',),
'omregne': ('omregne',),
'omregner': ('omregne',),
'omregnes': ('omregne',),
'omregnet': ('omregne',),
'omrekn': ('omrekne',),
'omrekna': ('omrekne',),
'omrekne': ('omrekne',),
'omrekner': ('omrekne',),
'omreknes': ('omrekne',),
'omreknet': ('omrekne',),
'omring': ('omringe',),
'omringa': ('omringe',),
'omringe': ('omringe',),
'omringer': ('omringe',),
'omringes': ('omringe',),
'omringet': ('omringe',),
'områ': ('områ',),
'områdd': ('områ',),
'områdde': ('områ',),
'områr': ('områ',),
'områs': ('områ',),
'omrøm': ('omrømme',),
'omrømma': ('omrømme',),
'omrømme': ('omrømme',),
'omrømmer': ('omrømme',),
'omrømmes': ('omrømme',),
'omrømmet': ('omrømme',),
'omsatt': ('omsette',),
'omsatte': ('omsette',),
'omsett': ('omsette',),
'omsette': ('omsette',),
'omsetter': ('omsette',),
'omsettes': ('omsette',),
'omskap': ('omskape',),
'omskapa': ('omskape',),
'omskape': ('omskape',),
'omskaper': ('omskape',),
'omskapes': ('omskape',),
'omskapt': ('omskape',),
'omskapte': ('omskape',),
'omskar': ('omskjære',),
'omskjær': ('omskjære',),
'omskjære': ('omskjære',),
'omskjærer': ('omskjære',),
'omskjæres': ('omskjære',),
'omskåret': ('omskjære',),
'omskol': ('omskole',),
'omskole': ('omskole',),
'omskoler': ('omskole',),
'omskoles': ('omskole',),
'omskolt': ('omskole',),
'omskolte': ('omskole',),
'omskoler': ('omskolere',),
'omskolere': ('omskolere',),
'omskolerer': ('omskolere',),
'omskoleres': ('omskolere',),
'omskolert': ('omskolere',),
'omskolerte': ('omskolere',),
'omskreiv': ('omskrive',),
'omskrev': ('omskrive',),
'omskrevet': ('omskrive',),
'omskriv': ('omskrive',),
'omskrive': ('omskrive',),
'omskriver': ('omskrive',),
'omskrives': ('omskrive',),
'omslutt': ('omslutte',),
'omslutta': ('omslutte',),
'omslutte': ('omslutte',),
'omslutter': ('omslutte',),
'omsluttes': ('omslutte',),
'omsluttet': ('omslutte',),
'omslyng': ('omslynge',),
'omslynga': ('omslynge',),
'omslynge': ('omslynge',),
'omslynger': ('omslynge',),
'omslynges': ('omslynge',),
'omslynget': ('omslynge',),
'omslyngt': ('omslynge',),
'omslyngte': ('omslynge',),
'omstill': ('omstille',),
'omstille': ('omstille',),
'omstiller': ('omstille',),
'omstilles': ('omstille',),
'omstilt': ('omstille',),
'omstilte': ('omstille',),
'omstrukturer': ('omstrukturere',),
'omstrukturere': ('omstrukturere',),
'omstrukturerer': ('omstrukturere',),
'omstruktureres': ('omstrukturere',),
'omstrukturert': ('omstrukturere',),
'omstrukturerte': ('omstrukturere',),
'omstyrt': ('omstyrte',),
'omstyrta': ('omstyrte',),
'omstyrte': ('omstyrte',),
'omstyrter': ('omstyrte',),
'omstyrtes': ('omstyrte',),
'omstyrtet': ('omstyrte',),
'omstøt': ('omstøte',),
'omstøte': ('omstøte',),
'omstøter': ('omstøte',),
'omstøtes': ('omstøte',),
'omstøtt': ('omstøte',),
'omstøtte': ('omstøte',),
'omtal': ('omtale',),
'omtala': ('omtale',),
'omtale': ('omtale',),
'omtaler': ('omtale',),
'omtales': ('omtale',),
'omtalt': ('omtale',),
'omtalte': ('omtale',),
'omvandl': ('omvandle',),
'omvandla': ('omvandle',),
'omvandle': ('omvandle',),
'omvandler': ('omvandle',),
'omvandles': ('omvandle',),
'omvandlet': ('omvandle',),
'omvelt': ('omvelte',),
'omvelta': ('omvelte',),
'omvelte': ('omvelte',),
'omvelter': ('omvelte',),
'omveltes': ('omvelte',),
'omveltet': ('omvelte',),
'omvend': ('omvende',),
'omvende': ('omvende',),
'omvender': ('omvende',),
'omvendes': ('omvende',),
'omvendt': ('omvende',),
'omvendte': ('omvende',),
'omvurder': ('omvurdere',),
'omvurdere': ('omvurdere',),
'omvurderer': ('omvurdere',),
'omvurderes': ('omvurdere',),
'omvurdert': ('omvurdere',),
'omvurderte': ('omvurdere',),
'omvøl': ('omvøle',),
'omvøle': ('omvøle',),
'omvøler': ('omvøle',),
'omvøles': ('omvøle',),
'omvølt': ('omvøle',),
'omvølte': ('omvøle',),
'onaner': ('onanere',),
'onanere': ('onanere',),
'onanerer': ('onanere',),
'onaneres': ('onanere',),
'onanert': ('onanere',),
'onanerte': ('onanere',),
'onduler': ('ondulere',),
'ondulere': ('ondulere',),
'ondulerer': ('ondulere',),
'onduleres': ('ondulere',),
'ondulert': ('ondulere',),
'ondulerte': ('ondulere',),
'onn': ('onne',),
'onna': ('onne',),
'onne': ('onne',),
'onner': ('onne',),
'onnes': ('onne',),
'onnet': ('onne',),
'opalescer': ('opalescere',),
'opalescere': ('opalescere',),
'opalescerer': ('opalescere',),
'opalesceres': ('opalescere',),
'opalescert': ('opalescere',),
'opalescerte': ('opalescere',),
'opaliser': ('opalisere',),
'opalisere': ('opalisere',),
'opaliserer': ('opalisere',),
'opaliseres': ('opalisere',),
'opalisert': ('opalisere',),
'opaliserte': ('opalisere',),
'operasjonaliser': ('operasjonalisere',),
'operasjonalisere': ('operasjonalisere',),
'operasjonaliserer': ('operasjonalisere',),
'operasjonaliseres': ('operasjonalisere',),
'operasjonalisert': ('operasjonalisere',),
'operasjonaliserte': ('operasjonalisere',),
'operer': ('operere',),
'operere': ('operere',),
'opererer': ('operere',),
'opereres': ('operere',),
'operert': ('operere',),
'opererte': ('operere',),
'opparbeid': ('opparbeide',),
'opparbeida': ('opparbeide',),
'opparbeidd': ('opparbeide',),
'opparbeidde': ('opparbeide',),
'opparbeide': ('opparbeide',),
'opparbeider': ('opparbeide',),
'opparbeides': ('opparbeide',),
'opparbeidet': ('opparbeide',),
'oppbevar': ('oppbevare',),
'oppbevare': ('oppbevare',),
'oppbevarer': ('oppbevare',),
'oppbevares': ('oppbevare',),
'oppbevart': ('oppbevare',),
'oppbevarte': ('oppbevare',),
'oppbragt': ('oppbringe',),
'oppbragte': ('oppbringe',),
'oppbrakt': ('oppbringe',),
'oppbrakte': ('oppbringe',),
'oppbring': ('oppbringe',),
'oppbringe': ('oppbringe',),
'oppbringer': ('oppbringe',),
'oppbringes': ('oppbringe',),
'oppbygd': ('oppbygge',),
'oppbygde': ('oppbygge',),
'oppbygg': ('oppbygge',),
'oppbygga': ('oppbygge',),
'oppbygge': ('oppbygge',),
'oppbygger': ('oppbygge',),
'oppbygges': ('oppbygge',),
'oppbygget': ('oppbygge',),
'oppdag': ('oppdage',),
'oppdaga': ('oppdage',),
'oppdage': ('oppdage',),
'oppdager': ('oppdage',),
'oppdages': ('oppdage',),
'oppdaget': ('oppdage',),
'oppdater': ('oppdatere',),
'oppdatere': ('oppdatere',),
'oppdaterer': ('oppdatere',),
'oppdateres': ('oppdatere',),
'oppdatert': ('oppdatere',),
'oppdaterte': ('oppdatere',),
'oppdra': ('oppdra',),
'oppdradd': ('oppdra',),
'oppdrar': ('oppdra',),
'oppdras': ('oppdra',),
'oppdratt': ('oppdra',),
'oppdro': ('oppdra',),
'oppdrog': ('oppdra',),
'oppdrett': ('oppdrette',),
'oppdretta': ('oppdrette',),
'oppdrette': ('oppdrette',),
'oppdretter': ('oppdrette',),
'oppdrettes': ('oppdrette',),
'oppdrettet': ('oppdrette',),
'oppdyrk': ('oppdyrke',),
'oppdyrka': ('oppdyrke',),
'oppdyrke': ('oppdyrke',),
'oppdyrker': ('oppdyrke',),
'oppdyrkes': ('oppdyrke',),
'oppdyrket': ('oppdyrke',),
'opp': ('oppe',),
'oppa': ('oppe',),
'oppe': ('oppe',),
'opper': ('oppe',),
'oppes': ('oppe',),
'oppet': ('oppe',),
'oppebi': ('oppebie',),
'oppebia': ('oppebie',),
'oppebidd': ('oppebie',),
'oppebidde': ('oppebie',),
'oppebie': ('oppebie',),
'oppebier': ('oppebie',),
'oppebies': ('oppebie',),
'oppebiet': ('oppebie',),
'oppelsk': ('oppelske',),
'oppelska': ('oppelske',),
'oppelske': ('oppelske',),
'oppelsker': ('oppelske',),
'oppelskes': ('oppelske',),
'oppelsket': ('oppelske',),
'oppfang': ('oppfange',),
'oppfanga': ('oppfange',),
'oppfange': ('oppfange',),
'oppfanger': ('oppfange',),
'oppfanges': ('oppfange',),
'oppfanget': ('oppfange',),
'oppfatt': ('oppfatte',),
'oppfatta': ('oppfatte',),
'oppfatte': ('oppfatte',),
'oppfatter': ('oppfatte',),
'oppfattes': ('oppfatte',),
'oppfattet': ('oppfatte',),
'oppfann': ('oppfinne',),
'oppfant': ('oppfinne',),
'oppfinn': ('oppfinne',),
'oppfinne': ('oppfinne',),
'oppfinner': ('oppfinne',),
'oppfinnes': ('oppfinne',),
'oppfunnet': ('oppfinne',),
'oppflask': ('oppflaske',),
'oppflaska': ('oppflaske',),
'oppflaske': ('oppflaske',),
'oppflasker': ('oppflaske',),
'oppflaskes': ('oppflaske',),
'oppflasket': ('oppflaske',),
'oppfordr': ('oppfordre',),
'oppfordra': ('oppfordre',),
'oppfordre': ('oppfordre',),
'oppfordrer': ('oppfordre',),
'oppfordres': ('oppfordre',),
'oppfordret': ('oppfordre',),
'oppfostr': ('oppfostre',),
'oppfostra': ('oppfostre',),
'oppfostre': ('oppfostre',),
'oppfostrer': ('oppfostre',),
'oppfostres': ('oppfostre',),
'oppfostret': ('oppfostre',),
'oppfyll': ('oppfylle',),
'oppfylle': ('oppfylle',),
'oppfyller': ('oppfylle',),
'oppfylles': ('oppfylle',),
'oppfylt': ('oppfylle',),
'oppfylte': ('oppfylle',),
'oppfør': ('oppføre',),
'oppføre': ('oppføre',),
'oppfører': ('oppføre',),
'oppføres': ('oppføre',),
'oppført': ('oppføre',),
'oppførte': ('oppføre',),
'oppga': ('oppgi',),
'oppgav': ('oppgi',),
'oppgi': ('oppgi',),
'oppgies': ('oppgi',),
'oppgir': ('oppgi',),
'oppgis': ('oppgi',),
'oppgitt': ('oppgi',),
'opphev': ('oppheve',),
'oppheva': ('oppheve',),
'opphevd': ('oppheve',),
'opphevde': ('oppheve',),
'oppheve': ('oppheve',),
'opphever': ('oppheve',),
'oppheves': ('oppheve',),
'opphevet': ('oppheve',),
'opphiss': ('opphisse',),
'opphissa': ('opphisse',),
'opphisse': ('opphisse',),
'opphisser': ('opphisse',),
'opphisses': ('opphisse',),
'opphisset': ('opphisse',),
'opphold': ('oppholde',),
'oppholde': ('oppholde',),
'oppholder': ('oppholde',),
'oppholdes': ('oppholde',),
'oppholdt': ('oppholde',),
'opphør': ('opphøre',),
'opphøre': ('opphøre',),
'opphører': ('opphøre',),
'opphøres': ('opphøre',),
'opphørt': ('opphøre',),
'opphørte': ('opphøre',),
'opphøy': ('opphøye',),
'opphøya': ('opphøye',),
'opphøyd': ('opphøye',),
'opphøyde': ('opphøye',),
'opphøye': ('opphøye',),
'opphøyer': ('opphøye',),
'opphøyes': ('opphøye',),
'opphøyet': ('opphøye',),
'oppildn': ('oppildne',),
'oppildna': ('oppildne',),
'oppildne': ('oppildne',),
'oppildner': ('oppildne',),
'oppildnes': ('oppildne',),
'oppildnet': ('oppildne',),
'oppirr': ('oppirre',),
'oppirra': ('oppirre',),
'oppirre': ('oppirre',),
'oppirrer': ('oppirre',),
'oppirres': ('oppirre',),
'oppirret': ('oppirre',),
'oppjuster': ('oppjustere',),
'oppjustere': ('oppjustere',),
'oppjusterer': ('oppjustere',),
'oppjusteres': ('oppjustere',),
'oppjustert': ('oppjustere',),
'oppjusterte': ('oppjustere',),
'oppkall': ('oppkalle',),
'oppkalle': ('oppkalle',),
'oppkaller': ('oppkalle',),
'oppkalles': ('oppkalle',),
'oppkalt': ('oppkalle',),
'oppkalte': ('oppkalle',),
'oppkast': ('oppkaste',),
'oppkasta': ('oppkaste',),
'oppkaste': ('oppkaste',),
'oppkaster': ('oppkaste',),
'oppkastes': ('oppkaste',),
'oppkastet': ('oppkaste',),
'oppklar': ('oppklare',),
'oppklare': ('oppklare',),
'oppklarer': ('oppklare',),
'oppklares': ('oppklare',),
'oppklart': ('oppklare',),
'oppklarte': ('oppklare',),
'oppkonstruer': ('oppkonstruere',),
'oppkonstruere': ('oppkonstruere',),
'oppkonstruerer': ('oppkonstruere',),
'oppkonstrueres': ('oppkonstruere',),
'oppkonstruert': ('oppkonstruere',),
'oppkonstruerte': ('oppkonstruere',),
'opplat': ('opplate',),
'opplate': ('opplate',),
'opplater': ('opplate',),
'opplates': ('opplate',),
'opplatt': ('opplate',),
'opplot': ('opplate',),
'opplev': ('oppleve',),
'opplevd': ('oppleve',),
'opplevde': ('oppleve',),
'oppleve': ('oppleve',),
'opplever': ('oppleve',),
'oppleves': ('oppleve',),
'oppliv': ('opplive',),
'oppliva': ('opplive',),
'opplive': ('opplive',),
'oppliver': ('opplive',),
'opplives': ('opplive',),
'opplivet': ('opplive',),
'opplys': ('opplyse',),
'opplyse': ('opplyse',),
'opplyser': ('opplyse',),
'opplyses': ('opplyse',),
'opplyst': ('opplyse',),
'opplyste': ('opplyse',),
'oppløft': ('oppløfte',),
'oppløfta': ('oppløfte',),
'oppløfte': ('oppløfte',),
'oppløfter': ('oppløfte',),
'oppløftes': ('oppløfte',),
'oppløftet': ('oppløfte',),
'oppløs': ('oppløse',),
'oppløse': ('oppløse',),
'oppløser': ('oppløse',),
'oppløses': ('oppløse',),
'oppløst': ('oppløse',),
'oppløste': ('oppløse',),
'oppløys': ('oppløyse',),
'oppløyse': ('oppløyse',),
'oppløyser': ('oppløyse',),
'oppløyses': ('oppløyse',),
'oppløyst': ('oppløyse',),
'oppløyste': ('oppløyse',),
'oppmagasiner': ('oppmagasinere',),
'oppmagasinere': ('oppmagasinere',),
'oppmagasinerer': ('oppmagasinere',),
'oppmagasineres': ('oppmagasinere',),
'oppmagasinert': ('oppmagasinere',),
'oppmagasinerte': ('oppmagasinere',),
'oppmuntr': ('oppmuntre',),
'oppmuntra': ('oppmuntre',),
'oppmuntre': ('oppmuntre',),
'oppmuntrer': ('oppmuntre',),
'oppmuntres': ('oppmuntre',),
'oppmuntret': ('oppmuntre',),
'oppnevn': ('oppnevne',),
'oppnevne': ('oppnevne',),
'oppnevner': ('oppnevne',),
'oppnevnes': ('oppnevne',),
'oppnevnt': ('oppnevne',),
'oppnevnte': ('oppnevne',),
'oppnorsk': ('oppnorske',),
'oppnorska': ('oppnorske',),
'oppnorske': ('oppnorske',),
'oppnorsker': ('oppnorske',),
'oppnorskes': ('oppnorske',),
'oppnorsket': ('oppnorske',),
'oppnå': ('oppnå',),
'oppnådd': ('oppnå',),
'oppnådde': ('oppnå',),
'oppnår': ('oppnå',),
'oppnås': ('oppnå',),
'opponer': ('opponere',),
'opponere': ('opponere',),
'opponerer': ('opponere',),
'opponeres': ('opponere',),
'opponert': ('opponere',),
'opponerte': ('opponere',),
'oppred': ('opprede',),
'oppreda': ('opprede',),
'opprede': ('opprede',),
'oppreder': ('opprede',),
'oppredes': ('opprede',),
'oppredet': ('opprede',),
'oppredt': ('opprede',),
'oppredte': ('opprede',),
'oppreis': ('oppreise',),
'oppreise': ('oppreise',),
'oppreiser': ('oppreise',),
'oppreises': ('oppreise',),
'oppreist': ('oppreise',),
'oppreiste': ('oppreise',),
'oppreklamer': ('oppreklamere',),
'oppreklamere': ('oppreklamere',),
'oppreklamerer': ('oppreklamere',),
'oppreklameres': ('oppreklamere',),
'oppreklamert': ('oppreklamere',),
'oppreklamerte': ('oppreklamere',),
'opprett': ('opprette',),
'oppretta': ('opprette',),
'opprette': ('opprette',),
'oppretter': ('opprette',),
'opprettes': ('opprette',),
'opprettet': ('opprette',),
'oppretthold': ('opprettholde',),
'opprettholde': ('opprettholde',),
'opprettholder': ('opprettholde',),
'opprettholdes': ('opprettholde',),
'opprettholdt': ('opprettholde',),
'opprant': ('opprinne',),
'opprinn': ('opprinne',),
'opprinne': ('opprinne',),
'opprinner': ('opprinne',),
'opprinnes': ('opprinne',),
'opprunnet': ('opprinne',),
'opprust': ('oppruste',),
'opprusta': ('oppruste',),
'oppruste': ('oppruste',),
'oppruster': ('oppruste',),
'opprustes': ('oppruste',),
'opprustet': ('oppruste',),
'opprør': ('opprøre',),
'opprøre': ('opprøre',),
'opprører': ('opprøre',),
'opprøres': ('opprøre',),
'opprørt': ('opprøre',),
'opprørte': ('opprøre',),
'oppsatt': ('oppsette',),
'oppsatte': ('oppsette',),
'oppsett': ('oppsette',),
'oppsette': ('oppsette',),
'oppsetter': ('oppsette',),
'oppsettes': ('oppsette',),
'oppskreiv': ('oppskrive',),
'oppskrev': ('oppskrive',),
'oppskrevet': ('oppskrive',),
'oppskriv': ('oppskrive',),
'oppskrive': ('oppskrive',),
'oppskriver': ('oppskrive',),
'oppskrives': ('oppskrive',),
'oppsluk': ('oppsluke',),
'oppsluke': ('oppsluke',),
'oppsluker': ('oppsluke',),
'oppslukes': ('oppsluke',),
'oppslukt': ('oppsluke',),
'oppslukte': ('oppsluke',),
'oppslutt': ('oppslutte',),
'oppslutta': ('oppslutte',),
'oppslutte': ('oppslutte',),
'oppslutter': ('oppslutte',),
'oppsluttes': ('oppslutte',),
'oppsluttet': ('oppslutte',),
'oppspor': ('oppspore',),
'oppspora': ('oppspore',),
'oppspore': ('oppspore',),
'oppsporer': ('oppspore',),
'oppspores': ('oppspore',),
'oppsporet': ('oppspore',),
'oppsport': ('oppspore',),
'oppsporte': ('oppspore',),
'oppstam': ('oppstamme',),
'oppstamma': ('oppstamme',),
'oppstamme': ('oppstamme',),
'oppstammer': ('oppstamme',),
'oppstammes': ('oppstamme',),
'oppstammet': ('oppstamme',),
'oppstykk': ('oppstykke',),
'oppstykka': ('oppstykke',),
'oppstykke': ('oppstykke',),
'oppstykker': ('oppstykke',),
'oppstykkes': ('oppstykke',),
'oppstykket': ('oppstykke',),
'oppstykt': ('oppstykke',),
'oppstykte': ('oppstykke',),
'oppsto': ('oppstå',),
'oppstod': ('oppstå',),
'oppstå': ('oppstå',),
'oppståes': ('oppstå',),
'oppstår': ('oppstå',),
'oppstås': ('oppstå',),
'oppstått': ('oppstå',),
'oppsummer': ('oppsummere',),
'oppsummere': ('oppsummere',),
'oppsummerer': ('oppsummere',),
'oppsummeres': ('oppsummere',),
'oppsummert': ('oppsummere',),
'oppsummerte': ('oppsummere',),
'oppsøk': ('oppsøke',),
'oppsøke': ('oppsøke',),
'oppsøker': ('oppsøke',),
'oppsøkes': ('oppsøke',),
'oppsøkt': ('oppsøke',),
'oppsøkte': ('oppsøke',),
'oppta': ('oppta',),
'opptaes': ('oppta',),
'opptar': ('oppta',),
'opptas': ('oppta',),
'opptatt': ('oppta',),
'opptok': ('oppta',),
'opptegn': ('opptegne',),
'opptegna': ('opptegne',),
'opptegne': ('opptegne',),
'opptegner': ('opptegne',),
'opptegnes': ('opptegne',),
'opptegnet': ('opptegne',),
'opptenn': ('opptenne',),
'opptenne': ('opptenne',),
'opptenner': ('opptenne',),
'opptennes': ('opptenne',),
'opptent': ('opptenne',),
'opptente': ('opptenne',),
'opptjen': ('opptjene',),
'opptjene': ('opptjene',),
'opptjener': ('opptjene',),
'opptjenes': ('opptjene',),
'opptjent': ('opptjene',),
'opptjente': ('opptjene',),
'opptrapp': ('opptrappe',),
'opptrappa': ('opptrappe',),
'opptrappe': ('opptrappe',),
'opptrapper': ('opptrappe',),
'opptrappes': ('opptrappe',),
'opptrappet': ('opptrappe',),
'opptre': ('opptre',),
'opptrer': ('opptre',),
'opptres': ('opptre',),
'opptrådt': ('opptre',),
'opptrådte': ('opptre',),
'oppvart': ('oppvarte',),
'oppvarta': ('oppvarte',),
'oppvarte': ('oppvarte',),
'oppvarter': ('oppvarte',),
'oppvartes': ('oppvarte',),
'oppvartet': ('oppvarte',),
'oppvei': ('oppveie',),
'oppveid': ('oppveie',),
'oppveide': ('oppveie',),
'oppveie': ('oppveie',),
'oppveier': ('oppveie',),
'oppveies': ('oppveie',),
'oppveiet': ('oppveie',),
'oppvekk': ('oppvekke',),
'oppvekka': ('oppvekke',),
'oppvekke': ('oppvekke',),
'oppvekker': ('oppvekke',),
'oppvekkes': ('oppvekke',),
'oppvekket': ('oppvekke',),
'oppvekt': ('oppvekke',),
'oppvekte': ('oppvekke',),
'oppvigl': ('oppvigle',),
'oppvigla': ('oppvigle',),
'oppvigle': ('oppvigle',),
'oppvigler': ('oppvigle',),
'oppvigles': ('oppvigle',),
'oppviglet': ('oppvigle',),
'oppvis': ('oppvise',),
'oppvise': ('oppvise',),
'oppviser': ('oppvise',),
'oppvises': ('oppvise',),
'oppvist': ('oppvise',),
'oppviste': ('oppvise',),
'oppvurder': ('oppvurdere',),
'oppvurdere': ('oppvurdere',),
'oppvurderer': ('oppvurdere',),
'oppvurderes': ('oppvurdere',),
'oppvurdert': ('oppvurdere',),
'oppvurderte': ('oppvurdere',),
'oppøv': ('oppøve',),
'oppøva': ('oppøve',),
'oppøvd': ('oppøve',),
'oppøvde': ('oppøve',),
'oppøve': ('oppøve',),
'oppøver': ('oppøve',),
'oppøves': ('oppøve',),
'oppøvet': ('oppøve',),
'opter': ('optere',),
'optere': ('optere',),
'opterer': ('optere',),
'opteres': ('optere',),
'optert': ('optere',),
'opterte': ('optere',),
'optimaliser': ('optimalisere',),
'optimalisere': ('optimalisere',),
'optimaliserer': ('optimalisere',),
'optimaliseres': ('optimalisere',),
'optimalisert': ('optimalisere',),
'optimaliserte': ('optimalisere',),
'optimer': ('optimere',),
'optimere': ('optimere',),
'optimerer': ('optimere',),
'optimeres': ('optimere',),
'optimert': ('optimere',),
'optimerte': ('optimere',),
'ord': ('orde',),
'orda': ('orde',),
'orde': ('orde',),
'order': ('orde',),
'ordes': ('orde',),
'ordet': ('orde',),
'ordiner': ('ordinere',),
'ordinere': ('ordinere',),
'ordinerer': ('ordinere',),
'ordineres': ('ordinere',),
'ordinert': ('ordinere',),
'ordinerte': ('ordinere',),
'ordla': ('ordlegge',),
'ordlagt': ('ordlegge',),
'ordlegg': ('ordlegge',),
'ordlegge': ('ordlegge',),
'ordlegger': ('ordlegge',),
'ordlegges': ('ordlegge',),
'ordn': ('ordne',),
'ordna': ('ordne',),
'ordne': ('ordne',),
'ordner': ('ordne',),
'ordnes': ('ordne',),
'ordnet': ('ordne',),
'oreign': ('oreigne',),
'oreigna': ('oreigne',),
'oreigne': ('oreigne',),
'oreigner': ('oreigne',),
'oreignes': ('oreigne',),
'oreignet': ('oreigne',),
'organiser': ('organisere',),
'organisere': ('organisere',),
'organiserer': ('organisere',),
'organiseres': ('organisere',),
'organisert': ('organisere',),
'organiserte': ('organisere',),
'org': ('orge',),
'orga': ('orge',),
'orge': ('orge',),
'orger': ('orge',),
'orges': ('orge',),
'orget': ('orge',),
'orienter': ('orientere',),
'orientere': ('orientere',),
'orienterer': ('orientere',),
'orienteres': ('orientere',),
'orientert': ('orientere',),
'orienterte': ('orientere',),
'ork': ('orke',),
'orka': ('orke',),
'orke': ('orke',),
'orker': ('orke',),
'orkes': ('orke',),
'orket': ('orke',),
'orkestrer': ('orkestrere',),
'orkestrere': ('orkestrere',),
'orkestrerer': ('orkestrere',),
'orkestreres': ('orkestrere',),
'orkestrert': ('orkestrere',),
'orkestrerte': ('orkestrere',),
'orm': ('orme',),
'orma': ('orme',),
'orme': ('orme',),
'ormer': ('orme',),
'ormes': ('orme',),
'ormet': ('orme',),
'ornamenter': ('ornamentere',),
'ornamentere': ('ornamentere',),
'ornamenterer': ('ornamentere',),
'ornamenteres': ('ornamentere',),
'ornamentert': ('ornamentere',),
'ornamenterte': ('ornamentere',),
'osciller': ('oscillere',),
'oscillere': ('oscillere',),
'oscillerer': ('oscillere',),
'oscilleres': ('oscillere',),
'oscillert': ('oscillere',),
'oscillerte': ('oscillere',),
'os': ('ose',),
'ose': ('ose',),
'oser': ('ose',),
'oses': ('ose',),
'ost': ('ose',),
'oste': ('ose',),
'ost': ('oste',),
'osta': ('oste',),
'oste': ('oste',),
'oster': ('oste',),
'ostes': ('oste',),
'ostet': ('oste',),
'otr': ('otre',),
'otra': ('otre',),
'otre': ('otre',),
'otrer': ('otre',),
'otres': ('otre',),
'otret': ('otre',),
'overanstreng': ('overanstrenge',),
'overanstrenge': ('overanstrenge',),
'overanstrenger': ('overanstrenge',),
'overanstrenges': ('overanstrenge',),
'overanstrengt': ('overanstrenge',),
'overanstrengte': ('overanstrenge',),
'overbelast': ('overbelaste',),
'overbelasta': ('overbelaste',),
'overbelaste': ('overbelaste',),
'overbelaster': ('overbelaste',),
'overbelastes': ('overbelaste',),
'overbelastet': ('overbelaste',),
'overbeskatt': ('overbeskatte',),
'overbeskatta': ('overbeskatte',),
'overbeskatte': ('overbeskatte',),
'overbeskatter': ('overbeskatte',),
'overbeskattes': ('overbeskatte',),
'overbeskattet': ('overbeskatte',),
'overbeskytt': ('overbeskytte',),
'overbeskytta': ('overbeskytte',),
'overbeskytte': ('overbeskytte',),
'overbeskytter': ('overbeskytte',),
'overbeskyttes': ('overbeskytte',),
'overbeskyttet': ('overbeskytte',),
'overbeton': ('overbetone',),
'overbetona': ('overbetone',),
'overbetone': ('overbetone',),
'overbetoner': ('overbetone',),
'overbetones': ('overbetone',),
'overbetonet': ('overbetone',),
'overbetont': ('overbetone',),
'overbetonte': ('overbetone',),
'overbevis': ('overbevise',),
'overbevise': ('overbevise',),
'overbeviser': ('overbevise',),
'overbevises': ('overbevise',),
'overbevist': ('overbevise',),
'overbeviste': ('overbevise',),
'overbragt': ('overbringe',),
'overbragte': ('overbringe',),
'overbrakt': ('overbringe',),
'overbrakte': ('overbringe',),
'overbring': ('overbringe',),
'overbringe': ('overbringe',),
'overbringer': ('overbringe',),
'overbringes': ('overbringe',),
'overbroder': ('overbrodere',),
'overbrodere': ('overbrodere',),
'overbroderer': ('overbrodere',),
'overbroderes': ('overbrodere',),
'overbrodert': ('overbrodere',),
'overbroderte': ('overbrodere',),
'overdimensjoner': ('overdimensjonere',),
'overdimensjonere': ('overdimensjonere',),
'overdimensjonerer': ('overdimensjonere',),
'overdimensjoneres': ('overdimensjonere',),
'overdimensjonert': ('overdimensjonere',),
'overdimensjonerte': ('overdimensjonere',),
'overdra': ('overdra',),
'overdradd': ('overdra',),
'overdrar': ('overdra',),
'overdras': ('overdra',),
'overdratt': ('overdra',),
'overdro': ('overdra',),
'overdrog': ('overdra',),
'overdyng': ('overdynge',),
'overdynga': ('overdynge',),
'overdynge': ('overdynge',),
'overdynger': ('overdynge',),
'overdynges': ('overdynge',),
'overdynget': ('overdynge',),
'overdøv': ('overdøve',),
'overdøva': ('overdøve',),
'overdøvd': ('overdøve',),
'overdøvde': ('overdøve',),
'overdøve': ('overdøve',),
'overdøver': ('overdøve',),
'overdøves': ('overdøve',),
'overdøvet': ('overdøve',),
'overeksponer': ('overeksponere',),
'overeksponere': ('overeksponere',),
'overeksponerer': ('overeksponere',),
'overeksponeres': ('overeksponere',),
'overeksponert': ('overeksponere',),
'overeksponerte': ('overeksponere',),
'overflødiggjorde': ('overflødiggjøre',),
'overflødiggjort': ('overflødiggjøre',),
'overflødiggjør': ('overflødiggjøre',),
'overflødiggjøre': ('overflødiggjøre',),
'overflødiggjøres': ('overflødiggjøre',),
'overfløy': ('overfløye',),
'overfløya': ('overfløye',),
'overfløyd': ('overfløye',),
'overfløyde': ('overfløye',),
'overfløye': ('overfløye',),
'overfløyer': ('overfløye',),
'overfløyes': ('overfløye',),
'overfløyet': ('overfløye',),
'overforsikr': ('overforsikre',),
'overforsikra': ('overforsikre',),
'overforsikre': ('overforsikre',),
'overforsikrer': ('overforsikre',),
'overforsikres': ('overforsikre',),
'overforsikret': ('overforsikre',),
'overfus': ('overfuse',),
'overfuse': ('overfuse',),
'overfuser': ('overfuse',),
'overfuses': ('overfuse',),
'overfust': ('overfuse',),
'overfuste': ('overfuse',),
'overfør': ('overføre',),
'overføre': ('overføre',),
'overfører': ('overføre',),
'overføres': ('overføre',),
'overført': ('overføre',),
'overførte': ('overføre',),
'overga': ('overgi',),
'overgav': ('overgi',),
'overgi': ('overgi',),
'overgies': ('overgi',),
'overgir': ('overgi',),
'overgis': ('overgi',),
'overgitt': ('overgi',),
'overgikk': ('overgå',),
'overgjekk': ('overgå',),
'overgå': ('overgå',),
'overgåes': ('overgå',),
'overgår': ('overgå',),
'overgås': ('overgå',),
'overgått': ('overgå',),
'overhal': ('overhale',),
'overhala': ('overhale',),
'overhale': ('overhale',),
'overhaler': ('overhale',),
'overhales': ('overhale',),
'overhalet': ('overhale',),
'overhalt': ('overhale',),
'overhalte': ('overhale',),
'overhold': ('overholde',),
'overholde': ('overholde',),
'overholder': ('overholde',),
'overholdes': ('overholde',),
'overholdt': ('overholde',),
'overhør': ('overhøre',),
'overhøre': ('overhøre',),
'overhører': ('overhøre',),
'overhøres': ('overhøre',),
'overhørt': ('overhøre',),
'overhørte': ('overhøre',),
'overhøvl': ('overhøvle',),
'overhøvla': ('overhøvle',),
'overhøvle': ('overhøvle',),
'overhøvler': ('overhøvle',),
'overhøvles': ('overhøvle',),
'overhøvlet': ('overhøvle',),
'overkjør': ('overkjøre',),
'overkjøre': ('overkjøre',),
'overkjører': ('overkjøre',),
'overkjøres': ('overkjøre',),
'overkjørt': ('overkjøre',),
'overkjørte': ('overkjøre',),
'overkom': ('overkomme',),
'overkomme': ('overkomme',),
'overkommer': ('overkomme',),
'overkommes': ('overkomme',),
'overkommet': ('overkomme',),
'overkompenser': ('overkompensere',),
'overkompensere': ('overkompensere',),
'overkompenserer': ('overkompensere',),
'overkompenseres': ('overkompensere',),
'overkompensert': ('overkompensere',),
'overkompenserte': ('overkompensere',),
'overlapp': ('overlappe',),
'overlappa': ('overlappe',),
'overlappe': ('overlappe',),
'overlapper': ('overlappe',),
'overlappes': ('overlappe',),
'overlappet': ('overlappe',),
'overlast': ('overlaste',),
'overlasta': ('overlaste',),
'overlaste': ('overlaste',),
'overlaster': ('overlaste',),
'overlastes': ('overlaste',),
'overlastet': ('overlaste',),
'overlat': ('overlate',),
'overlate': ('overlate',),
'overlater': ('overlate',),
'overlates': ('overlate',),
'overlatt': ('overlate',),
'overlot': ('overlate',),
'overla': ('overlegge',),
'overlagt': ('overlegge',),
'overlegg': ('overlegge',),
'overlegge': ('overlegge',),
'overlegger': ('overlegge',),
'overlegges': ('overlegge',),
'overless': ('overlesse',),
'overlessa': ('overlesse',),
'overlesse': ('overlesse',),
'overlesser': ('overlesse',),
'overlesses': ('overlesse',),
'overlesset': ('overlesse',),
'overlest': ('overlesse',),
'overleste': ('overlesse',),
'overlev': ('overleve',),
'overlevd': ('overleve',),
'overlevde': ('overleve',),
'overleve': ('overleve',),
'overlever': ('overleve',),
'overleves': ('overleve',),
'overlever': ('overlevere',),
'overlevere': ('overlevere',),
'overleverer': ('overlevere',),
'overleveres': ('overlevere',),
'overlevert': ('overlevere',),
'overleverte': ('overlevere',),
'overlist': ('overliste',),
'overlista': ('overliste',),
'overliste': ('overliste',),
'overlister': ('overliste',),
'overlistes': ('overliste',),
'overlistet': ('overliste',),
'overmann': ('overmanne',),
'overmanna': ('overmanne',),
'overmanne': ('overmanne',),
'overmanner': ('overmanne',),
'overmannes': ('overmanne',),
'overmannet': ('overmanne',),
'overnatt': ('overnatte',),
'overnatta': ('overnatte',),
'overnatte': ('overnatte',),
'overnatter': ('overnatte',),
'overnattes': ('overnatte',),
'overnattet': ('overnatte',),
'overopphet': ('overopphete',),
'overoppheta': ('overopphete',),
'overopphete': ('overopphete',),
'overoppheter': ('overopphete',),
'overopphetes': ('overopphete',),
'overopphetet': ('overopphete',),
'overprøv': ('overprøve',),
'overprøvd': ('overprøve',),
'overprøvde': ('overprøve',),
'overprøve': ('overprøve',),
'overprøver': ('overprøve',),
'overprøves': ('overprøve',),
'overrask': ('overraske',),
'overraska': ('overraske',),
'overraske': ('overraske',),
'overrasker': ('overraske',),
'overraskes': ('overraske',),
'overrasket': ('overraske',),
'overrakt': ('overrekke',),
'overrakte': ('overrekke',),
'overrekk': ('overrekke',),
'overrekke': ('overrekke',),
'overrekker': ('overrekke',),
'overrekkes': ('overrekke',),
'overrenn': ('overrenne',),
'overrenne': ('overrenne',),
'overrenner': ('overrenne',),
'overrennes': ('overrenne',),
'overrent': ('overrenne',),
'overrente': ('overrenne',),
'overrisl': ('overrisle',),
'overrisla': ('overrisle',),
'overrisle': ('overrisle',),
'overrisler': ('overrisle',),
'overrisles': ('overrisle',),
'overrislet': ('overrisle',),
'overrumpl': ('overrumple',),
'overrumpla': ('overrumple',),
'overrumple': ('overrumple',),
'overrumpler': ('overrumple',),
'overrumples': ('overrumple',),
'overrumplet': ('overrumple',),
'overse': ('overse',),
'oversees': ('overse',),
'overser': ('overse',),
'overses': ('overse',),
'oversett': ('overse',),
'overså': ('overse',),
'oversåg': ('overse',),
'oversend': ('oversende',),
'oversende': ('oversende',),
'oversender': ('oversende',),
'oversendes': ('oversende',),
'oversendt': ('oversende',),
'oversendte': ('oversende',),
'oversatt': ('oversette',),
'oversatte': ('oversette',),
'oversett': ('oversette',),
'oversette': ('oversette',),
'oversetter': ('oversette',),
'oversettes': ('oversette',),
'oversatt': ('oversitte',),
'oversitt': ('oversitte',),
'oversitte': ('oversitte',),
'oversitter': ('oversitte',),
'oversittes': ('oversitte',),
'oversittet': ('oversitte',),
'overskred': ('overskride',),
'overskredet': ('overskride',),
'overskrei': ('overskride',),
'overskrid': ('overskride',),
'overskride': ('overskride',),
'overskrider': ('overskride',),
'overskrides': ('overskride',),
'oversku': ('overskue',),
'overskua': ('overskue',),
'overskue': ('overskue',),
'overskuer': ('overskue',),
'overskues': ('overskue',),
'overskuet': ('overskue',),
'overskygd': ('overskygge',),
'overskygde': ('overskygge',),
'overskygg': ('overskygge',),
'overskygga': ('overskygge',),
'overskygge': ('overskygge',),
'overskygger': ('overskygge',),
'overskygges': ('overskygge',),
'overskygget': ('overskygge',),
'overspill': ('overspille',),
'overspille': ('overspille',),
'overspiller': ('overspille',),
'overspilles': ('overspille',),
'overspilt': ('overspille',),
'overspilte': ('overspille',),
'overstem': ('overstemme',),
'overstemme': ('overstemme',),
'overstemmer': ('overstemme',),
'overstemmes': ('overstemme',),
'overstemt': ('overstemme',),
'overstemte': ('overstemme',),
'oversteg': ('overstige',),
'oversteget': ('overstige',),
'oversteig': ('overstige',),
'overstig': ('overstige',),
'overstige': ('overstige',),
'overstiger': ('overstige',),
'overstiges': ('overstige',),
'oversvøm': ('oversvømme',),
'oversvømme': ('oversvømme',),
'oversvømmer': ('oversvømme',),
'oversvømmes': ('oversvømme',),
'oversvømt': ('oversvømme',),
'oversvømte': ('oversvømme',),
'overta': ('overta',),
'overtaes': ('overta',),
'overtar': ('overta',),
'overtas': ('overta',),
'overtatt': ('overta',),
'overtok': ('overta',),
'overtal': ('overtale',),
'overtale': ('overtale',),
'overtaler': ('overtale',),
'overtales': ('overtale',),
'overtalt': ('overtale',),
'overtalte': ('overtale',),
'overtegn': ('overtegne',),
'overtegna': ('overtegne',),
'overtegne': ('overtegne',),
'overtegner': ('overtegne',),
'overtegnes': ('overtegne',),
'overtegnet': ('overtegne',),
'overtre': ('overtre',),
'overtrer': ('overtre',),
'overtres': ('overtre',),
'overtrådt': ('overtre',),
'overtrådte': ('overtre',),
'overtraff': ('overtreffe',),
'overtreff': ('overtreffe',),
'overtreffe': ('overtreffe',),
'overtreffer': ('overtreffe',),
'overtreffes': ('overtreffe',),
'overtruffet': ('overtreffe',),
'overtrakk': ('overtrekke',),
'overtrekk': ('overtrekke',),
'overtrekke': ('overtrekke',),
'overtrekker': ('overtrekke',),
'overtrekkes': ('overtrekke',),
'overtrukket': ('overtrekke',),
'overtyd': ('overtyde',),
'overtyda': ('overtyde',),
'overtydd': ('overtyde',),
'overtydde': ('overtyde',),
'overtyde': ('overtyde',),
'overtyder': ('overtyde',),
'overtydes': ('overtyde',),
'overtydet': ('overtyde',),
'overutvikl': ('overutvikle',),
'overutvikla': ('overutvikle',),
'overutvikle': ('overutvikle',),
'overutvikler': ('overutvikle',),
'overutvikles': ('overutvikle',),
'overutviklet': ('overutvikle',),
'overvei': ('overveie',),
'overveid': ('overveie',),
'overveide': ('overveie',),
'overveie': ('overveie',),
'overveier': ('overveie',),
'overveies': ('overveie',),
'overveiet': ('overveie',),
'overveld': ('overvelde',),
'overvelda': ('overvelde',),
'overvelde': ('overvelde',),
'overvelder': ('overvelde',),
'overveldes': ('overvelde',),
'overveldet': ('overvelde',),
'overvann': ('overvinne',),
'overvant': ('overvinne',),
'overvinn': ('overvinne',),
'overvinne': ('overvinne',),
'overvinner': ('overvinne',),
'overvinnes': ('overvinne',),
'overvunnet': ('overvinne',),
'overvintr': ('overvintre',),
'overvintra': ('overvintre',),
'overvintre': ('overvintre',),
'overvintrer': ('overvintre',),
'overvintres': ('overvintre',),
'overvintret': ('overvintre',),
'overvurder': ('overvurdere',),
'overvurdere': ('overvurdere',),
'overvurderer': ('overvurdere',),
'overvurderes': ('overvurdere',),
'overvurdert': ('overvurdere',),
'overvurderte': ('overvurdere',),
'overvåk': ('overvåke',),
'overvåka': ('overvåke',),
'overvåke': ('overvåke',),
'overvåker': ('overvåke',),
'overvåkes': ('overvåke',),
'overvåket': ('overvåke',),
'overvåkt': ('overvåke',),
'overvåkte': ('overvåke',),
'overvar': ('overvære',),
'overvær': ('overvære',),
'overvære': ('overvære',),
'overværer': ('overvære',),
'overværes': ('overvære',),
'overvært': ('overvære',),
'overøs': ('overøse',),
'overøse': ('overøse',),
'overøser': ('overøse',),
'overøses': ('overøse',),
'overøst': ('overøse',),
'overøste': ('overøse',),
'ovr': ('ovre',),
'ovra': ('ovre',),
'ovre': ('ovre',),
'ovrer': ('ovre',),
'ovres': ('ovre',),
'ovret': ('ovre',),
'pac': ('pace',),
'paca': ('pace',),
'pace': ('pace',),
'pacer': ('pace',),
'paces': ('pace',),
'pacet': ('pace',),
'pact': ('pace',),
'pacte': ('pace',),
'padl': ('padle',),
'padla': ('padle',),
'padle': ('padle',),
'padler': ('padle',),
'padles': ('padle',),
'padlet': ('padle',),
'paff': ('paffe',),
'paffa': ('paffe',),
'paffe': ('paffe',),
'paffer': ('paffe',),
'paffes': ('paffe',),
'paffet': ('paffe',),
'paginer': ('paginere',),
'paginere': ('paginere',),
'paginerer': ('paginere',),
'pagineres': ('paginere',),
'paginert': ('paginere',),
'paginerte': ('paginere',),
'pakk': ('pakke',),
'pakka': ('pakke',),
'pakke': ('pakke',),
'pakker': ('pakke',),
'pakkes': ('pakke',),
'pakket': ('pakke',),
'pakt': ('pakte',),
'pakta': ('pakte',),
'pakte': ('pakte',),
'pakter': ('pakte',),
'paktes': ('pakte',),
'paktet': ('pakte',),
'palataliser': ('palatalisere',),
'palatalisere': ('palatalisere',),
'palataliserer': ('palatalisere',),
'palataliseres': ('palatalisere',),
'palatalisert': ('palatalisere',),
'palataliserte': ('palatalisere',),
'pal': ('pale',),
'pale': ('pale',),
'paler': ('pale',),
'pales': ('pale',),
'palt': ('pale',),
'palte': ('pale',),
'palleter': ('palletere',),
'palletere': ('palletere',),
'palleterer': ('palletere',),
'palleteres': ('palletere',),
'palletert': ('palletere',),
'palleterte': ('palletere',),
'palm': ('palme',),
'palma': ('palme',),
'palme': ('palme',),
'palmer': ('palme',),
'palmes': ('palme',),
'palmet': ('palme',),
'palper': ('palpere',),
'palpere': ('palpere',),
'palperer': ('palpere',),
'palperes': ('palpere',),
'palpert': ('palpere',),
'palperte': ('palpere',),
'panegyrer': ('panegyrere',),
'panegyrere': ('panegyrere',),
'panegyrerer': ('panegyrere',),
'panegyreres': ('panegyrere',),
'panegyrert': ('panegyrere',),
'panegyrerte': ('panegyrere',),
'panel': ('panele',),
'panele': ('panele',),
'paneler': ('panele',),
'paneles': ('panele',),
'panelt': ('panele',),
'panelte': ('panele',),
'paner': ('panere',),
'panere': ('panere',),
'panerer': ('panere',),
'paneres': ('panere',),
'panert': ('panere',),
'panerte': ('panere',),
'panorer': ('panorere',),
'panorere': ('panorere',),
'panorerer': ('panorere',),
'panoreres': ('panorere',),
'panorert': ('panorere',),
'panorerte': ('panorere',),
'pansr': ('pansre',),
'pansra': ('pansre',),
'pansre': ('pansre',),
'pansrer': ('pansre',),
'pansres': ('pansre',),
'pansret': ('pansre',),
'pant': ('pante',),
'panta': ('pante',),
'pante': ('pante',),
'panter': ('pante',),
'pantes': ('pante',),
'pantet': ('pante',),
'pantsatt': ('pantsette',),
'pantsatte': ('pantsette',),
'pantsett': ('pantsette',),
'pantsette': ('pantsette',),
'pantsetter': ('pantsette',),
'pantsettes': ('pantsette',),
'pantstill': ('pantstille',),
'pantstille': ('pantstille',),
'pantstiller': ('pantstille',),
'pantstilles': ('pantstille',),
'pantstilt': ('pantstille',),
'pantstilte': ('pantstille',),
'papp': ('pappe',),
'pappa': ('pappe',),
'pappe': ('pappe',),
'papper': ('pappe',),
'pappes': ('pappe',),
'pappet': ('pappe',),
'parader': ('paradere',),
'paradere': ('paradere',),
'paraderer': ('paradere',),
'paraderes': ('paradere',),
'paradert': ('paradere',),
'paraderte': ('paradere',),
'parafer': ('parafere',),
'parafere': ('parafere',),
'paraferer': ('parafere',),
'paraferes': ('parafere',),
'parafert': ('parafere',),
'paraferte': ('parafere',),
'parafiner': ('parafinere',),
'parafinere': ('parafinere',),
'parafinerer': ('parafinere',),
'parafineres': ('parafinere',),
'parafinert': ('parafinere',),
'parafinerte': ('parafinere',),
'parafraser': ('parafrasere',),
'parafrasere': ('parafrasere',),
'parafraserer': ('parafrasere',),
'parafraseres': ('parafrasere',),
'parafrasert': ('parafrasere',),
'parafraserte': ('parafrasere',),
'paragrafer': ('paragrafere',),
'paragrafere': ('paragrafere',),
'paragraferer': ('paragrafere',),
'paragraferes': ('paragrafere',),
'paragrafert': ('paragrafere',),
'paragraferte': ('paragrafere',),
'parallellforskjøv': ('parallellforskyve',),
'parallellforskjøvet': ('parallellforskyve',),
'parallellforskyv': ('parallellforskyve',),
'parallellforskyvd': ('parallellforskyve',),
'parallellforskyve': ('parallellforskyve',),
'parallellforskyver': ('parallellforskyve',),
'parallellforskyves': ('parallellforskyve',),
'parallellforskøyv': ('parallellforskyve',),
'parallellfør': ('parallellføre',),
'parallellføre': ('parallellføre',),
'parallellfører': ('parallellføre',),
'parallellføres': ('parallellføre',),
'parallellført': ('parallellføre',),
'parallellførte': ('parallellføre',),
'parallelliser': ('parallellisere',),
'parallellisere': ('parallellisere',),
'parallelliserer': ('parallellisere',),
'parallelliseres': ('parallellisere',),
'parallellisert': ('parallellisere',),
'parallelliserte': ('parallellisere',),
'paralyser': ('paralysere',),
'paralysere': ('paralysere',),
'paralyserer': ('paralysere',),
'paralyseres': ('paralysere',),
'paralysert': ('paralysere',),
'paralyserte': ('paralysere',),
'parasitter': ('parasittere',),
'parasittere': ('parasittere',),
'parasitterer': ('parasittere',),
'parasitteres': ('parasittere',),
'parasittert': ('parasittere',),
'parasitterte': ('parasittere',),
'par': ('pare',),
'para': ('pare',),
'pare': ('pare',),
'parer': ('pare',),
'pares': ('pare',),
'paret': ('pare',),
'parer': ('parere',),
'parere': ('parere',),
'parerer': ('parere',),
'pareres': ('parere',),
'parert': ('parere',),
'parerte': ('parere',),
'parer': ('parere',),
'parere': ('parere',),
'parerer': ('parere',),
'pareres': ('parere',),
'parert': ('parere',),
'parerte': ('parere',),
'parfymer': ('parfymere',),
'parfymere': ('parfymere',),
'parfymerer': ('parfymere',),
'parfymeres': ('parfymere',),
'parfymert': ('parfymere',),
'parfymerte': ('parfymere',),
'parker': ('parkere',),
'parkere': ('parkere',),
'parkerer': ('parkere',),
'parkeres': ('parkere',),
'parkert': ('parkere',),
'parkerte': ('parkere',),
'parlamenter': ('parlamentere',),
'parlamentere': ('parlamentere',),
'parlamenterer': ('parlamentere',),
'parlamenteres': ('parlamentere',),
'parlamentert': ('parlamentere',),
'parlamenterte': ('parlamentere',),
'parler': ('parlere',),
'parlere': ('parlere',),
'parlerer': ('parlere',),
'parleres': ('parlere',),
'parlert': ('parlere',),
'parlerte': ('parlere',),
'parodier': ('parodiere',),
'parodiere': ('parodiere',),
'parodierer': ('parodiere',),
'parodieres': ('parodiere',),
'parodiert': ('parodiere',),
'parodierte': ('parodiere',),
'parseller': ('parsellere',),
'parsellere': ('parsellere',),
'parsellerer': ('parsellere',),
'parselleres': ('parsellere',),
'parsellert': ('parsellere',),
'parsellerte': ('parsellere',),
'parter': ('partere',),
'partere': ('partere',),
'parterer': ('partere',),
'parteres': ('partere',),
'partert': ('partere',),
'parterte': ('partere',),
'partisiper': ('partisipere',),
'partisipere': ('partisipere',),
'partisiperer': ('partisipere',),
'partisiperes': ('partisipere',),
'partisipert': ('partisipere',),
'partisiperte': ('partisipere',),
'pasifiser': ('pasifisere',),
'pasifisere': ('pasifisere',),
'pasifiserer': ('pasifisere',),
'pasifiseres': ('pasifisere',),
'pasifisert': ('pasifisere',),
'pasifiserte': ('pasifisere',),
'pass': ('passe',),
'passa': ('passe',),
'passe': ('passe',),
'passer': ('passe',),
'passes': ('passe',),
'passet': ('passe',),
'pass': ('passe',),
'passa': ('passe',),
'passe': ('passe',),
'passer': ('passe',),
'passes': ('passe',),
'passet': ('passe',),
'pass': ('passe',),
'passa': ('passe',),
'passe': ('passe',),
'passer': ('passe',),
'passes': ('passe',),
'passet': ('passe',),
'pass': ('passe',),
'passa': ('passe',),
'passe': ('passe',),
'passer': ('passe',),
'passes': ('passe',),
'passet': ('passe',),
'passer': ('passere',),
'passere': ('passere',),
'passerer': ('passere',),
'passeres': ('passere',),
'passert': ('passere',),
'passerte': ('passere',),
'passiar': ('passiare',),
'passiare': ('passiare',),
'passiarer': ('passiare',),
'passiares': ('passiare',),
'passiart': ('passiare',),
'passiarte': ('passiare',),
'passiver': ('passivere',),
'passivere': ('passivere',),
'passiverer': ('passivere',),
'passiveres': ('passivere',),
'passivert': ('passivere',),
'passiverte': ('passivere',),
'passiviser': ('passivisere',),
'passivisere': ('passivisere',),
'passiviserer': ('passivisere',),
'passiviseres': ('passivisere',),
'passivisert': ('passivisere',),
'passiviserte': ('passivisere',),
'pasteuriser': ('pasteurisere',),
'pasteurisere': ('pasteurisere',),
'pasteuriserer': ('pasteurisere',),
'pasteuriseres': ('pasteurisere',),
'pasteurisert': ('pasteurisere',),
'pasteuriserte': ('pasteurisere',),
'patenter': ('patentere',),
'patentere': ('patentere',),
'patenterer': ('patentere',),
'patenteres': ('patentere',),
'patentert': ('patentere',),
'patenterte': ('patentere',),
'patentsøk': ('patentsøke',),
'patentsøke': ('patentsøke',),
'patentsøker': ('patentsøke',),
'patentsøkes': ('patentsøke',),
'patentsøkt': ('patentsøke',),
'patentsøkte': ('patentsøke',),
'patiner': ('patinere',),
'patinere': ('patinere',),
'patinerer': ('patinere',),
'patineres': ('patinere',),
'patinert': ('patinere',),
'patinerte': ('patinere',),
'patroniser': ('patronisere',),
'patronisere': ('patronisere',),
'patroniserer': ('patronisere',),
'patroniseres': ('patronisere',),
'patronisert': ('patronisere',),
'patroniserte': ('patronisere',),
'patruljer': ('patruljere',),
'patruljere': ('patruljere',),
'patruljerer': ('patruljere',),
'patruljeres': ('patruljere',),
'patruljert': ('patruljere',),
'patruljerte': ('patruljere',),
'patt': ('patte',),
'patta': ('patte',),
'patte': ('patte',),
'patter': ('patte',),
'pattes': ('patte',),
'pattet': ('patte',),
'pauser': ('pausere',),
'pausere': ('pausere',),
'pauserer': ('pausere',),
'pauseres': ('pausere',),
'pausert': ('pausere',),
'pauserte': ('pausere',),
'peil': ('peile',),
'peila': ('peile',),
'peile': ('peile',),
'peiler': ('peile',),
'peiles': ('peile',),
'peilet': ('peile',),
'peilt': ('peile',),
'peilte': ('peile',),
'peis': ('peise',),
'peisa': ('peise',),
'peise': ('peise',),
'peiser': ('peise',),
'peises': ('peise',),
'peiset': ('peise',),
'peist': ('peise',),
'peiste': ('peise',),
'pek': ('peke',),
'peke': ('peke',),
'peker': ('peke',),
'pekes': ('peke',),
'pekt': ('peke',),
'pekte': ('peke',),
'pell': ('pelle',),
'pella': ('pelle',),
'pelle': ('pelle',),
'peller': ('pelle',),
'pelles': ('pelle',),
'pellet': ('pelle',),
'pelt': ('pelle',),
'pelte': ('pelle',),
'pell': ('pelle',),
'pella': ('pelle',),
'pelle': ('pelle',),
'peller': ('pelle',),
'pelles': ('pelle',),
'pellet': ('pelle',),
'pelt': ('pelle',),
'pelte': ('pelle',),
'pelleter': ('pelletere',),
'pelletere': ('pelletere',),
'pelleterer': ('pelletere',),
'pelleteres': ('pelletere',),
'pelletert': ('pelletere',),
'pelleterte': ('pelletere',),
'pels': ('pelse',),
'pelsa': ('pelse',),
'pelse': ('pelse',),
'pelser': ('pelse',),
'pelses': ('pelse',),
'pelset': ('pelse',),
'pendl': ('pendle',),
'pendla': ('pendle',),
'pendle': ('pendle',),
'pendler': ('pendle',),
'pendles': ('pendle',),
'pendlet': ('pendle',),
'penetrer': ('penetrere',),
'penetrere': ('penetrere',),
'penetrerer': ('penetrere',),
'penetreres': ('penetrere',),
'penetrert': ('penetrere',),
'penetrerte': ('penetrere',),
'penn': ('penne',),
'penna': ('penne',),
'penne': ('penne',),
'penner': ('penne',),
'pennes': ('penne',),
'pennet': ('penne',),
'pens': ('pense',),
'pensa': ('pense',),
'pense': ('pense',),
'penser': ('pense',),
'penses': ('pense',),
'penset': ('pense',),
'pensjoner': ('pensjonere',),
'pensjonere': ('pensjonere',),
'pensjonerer': ('pensjonere',),
'pensjoneres': ('pensjonere',),
'pensjonert': ('pensjonere',),
'pensjonerte': ('pensjonere',),
'pensl': ('pensle',),
'pensla': ('pensle',),
'pensle': ('pensle',),
'pensler': ('pensle',),
'pensles': ('pensle',),
'penslet': ('pensle',),
'pepr': ('pepre',),
'pepra': ('pepre',),
'pepre': ('pepre',),
'peprer': ('pepre',),
'pepres': ('pepre',),
'pepret': ('pepre',),
'perenner': ('perennere',),
'perennere': ('perennere',),
'perennerer': ('perennere',),
'perenneres': ('perennere',),
'perennert': ('perennere',),
'perennerte': ('perennere',),
'perfeksjoner': ('perfeksjonere',),
'perfeksjonere': ('perfeksjonere',),
'perfeksjonerer': ('perfeksjonere',),
'perfeksjoneres': ('perfeksjonere',),
'perfeksjonert': ('perfeksjonere',),
'perfeksjonerte': ('perfeksjonere',),
'perforer': ('perforere',),
'perforere': ('perforere',),
'perforerer': ('perforere',),
'perforeres': ('perforere',),
'perforert': ('perforere',),
'perforerte': ('perforere',),
'pergamenter': ('pergamentere',),
'pergamentere': ('pergamentere',),
'pergamenterer': ('pergamentere',),
'pergamenteres': ('pergamentere',),
'pergamentert': ('pergamentere',),
'pergamenterte': ('pergamentere',),
'perkoler': ('perkolere',),
'perkolere': ('perkolere',),
'perkolerer': ('perkolere',),
'perkoleres': ('perkolere',),
'perkolert': ('perkolere',),
'perkolerte': ('perkolere',),
'perkuter': ('perkutere',),
'perkutere': ('perkutere',),
'perkuterer': ('perkutere',),
'perkuteres': ('perkutere',),
'perkutert': ('perkutere',),
'perkuterte': ('perkutere',),
'perl': ('perle',),
'perla': ('perle',),
'perle': ('perle',),
'perler': ('perle',),
'perles': ('perle',),
'perlet': ('perle',),
'permitter': ('permittere',),
'permittere': ('permittere',),
'permitterer': ('permittere',),
'permitteres': ('permittere',),
'permittert': ('permittere',),
'permitterte': ('permittere',),
'permuter': ('permutere',),
'permutere': ('permutere',),
'permuterer': ('permutere',),
'permuteres': ('permutere',),
'permutert': ('permutere',),
'permuterte': ('permutere',),
'pers': ('perse',),
'persa': ('perse',),
'perse': ('perse',),
'perser': ('perse',),
'perses': ('perse',),
'perset': ('perse',),
'pers': ('perse',),
'persa': ('perse',),
'perse': ('perse',),
'perser': ('perse',),
'perses': ('perse',),
'perset': ('perse',),
'persifler': ('persiflere',),
'persiflere': ('persiflere',),
'persiflerer': ('persiflere',),
'persifleres': ('persiflere',),
'persiflert': ('persiflere',),
'persiflerte': ('persiflere',),
'persiper': ('persipere',),
'persipere': ('persipere',),
'persiperer': ('persipere',),
'persiperes': ('persipere',),
'persipert': ('persipere',),
'persiperte': ('persipere',),
'persister': ('persistere',),
'persistere': ('persistere',),
'persisterer': ('persistere',),
'persisteres': ('persistere',),
'persistert': ('persistere',),
'persisterte': ('persistere',),
'personifiser': ('personifisere',),
'personifisere': ('personifisere',),
'personifiserer': ('personifisere',),
'personifiseres': ('personifisere',),
'personifisert': ('personifisere',),
'personifiserte': ('personifisere',),
'personliggjorde': ('personliggjøre',),
'personliggjort': ('personliggjøre',),
'personliggjør': ('personliggjøre',),
'personliggjøre': ('personliggjøre',),
'personliggjøres': ('personliggjøre',),
'perspirer': ('perspirere',),
'perspirere': ('perspirere',),
'perspirerer': ('perspirere',),
'perspireres': ('perspirere',),
'perspirert': ('perspirere',),
'perspirerte': ('perspirere',),
'perturber': ('perturbere',),
'perturbere': ('perturbere',),
'perturberer': ('perturbere',),
'perturberes': ('perturbere',),
'perturbert': ('perturbere',),
'perturberte': ('perturbere',),
'perverter': ('pervertere',),
'pervertere': ('pervertere',),
'perverterer': ('pervertere',),
'perverteres': ('pervertere',),
'pervertert': ('pervertere',),
'perverterte': ('pervertere',),
'pes': ('pese',),
'pese': ('pese',),
'peser': ('pese',),
'peses': ('pese',),
'pest': ('pese',),
'peste': ('pese',),
'piff': ('piffe',),
'piffa': ('piffe',),
'piffe': ('piffe',),
'piffer': ('piffe',),
'piffes': ('piffe',),
'piffet': ('piffe',),
'pigg': ('pigge',),
'pigga': ('pigge',),
'pigge': ('pigge',),
'pigger': ('pigge',),
'pigges': ('pigge',),
'pigget': ('pigge',),
'pigg': ('pigge',),
'pigga': ('pigge',),
'pigge': ('pigge',),
'pigger': ('pigge',),
'pigges': ('pigge',),
'pigget': ('pigge',),
'pigmenter': ('pigmentere',),
'pigmentere': ('pigmentere',),
'pigmenterer': ('pigmentere',),
'pigmenteres': ('pigmentere',),
'pigmentert': ('pigmentere',),
'pigmenterte': ('pigmentere',),
'piker': ('pikere',),
'pikere': ('pikere',),
'pikerer': ('pikere',),
'pikeres': ('pikere',),
'pikert': ('pikere',),
'pikerte': ('pikere',),
'pikk': ('pikke',),
'pikka': ('pikke',),
'pikke': ('pikke',),
'pikker': ('pikke',),
'pikkes': ('pikke',),
'pikket': ('pikke',),
'pil': ('pile',),
'pile': ('pile',),
'piler': ('pile',),
'piles': ('pile',),
'pilt': ('pile',),
'pilte': ('pile',),
'pilk': ('pilke',),
'pilka': ('pilke',),
'pilke': ('pilke',),
'pilker': ('pilke',),
'pilkes': ('pilke',),
'pilket': ('pilke',),
'pilt': ('pilte',),
'pilta': ('pilte',),
'pilte': ('pilte',),
'pilter': ('pilte',),
'piltes': ('pilte',),
'piltet': ('pilte',),
'pimp': ('pimpe',),
'pimpa': ('pimpe',),
'pimpe': ('pimpe',),
'pimper': ('pimpe',),
'pimpes': ('pimpe',),
'pimpet': ('pimpe',),
'pin': ('pine',),
'pine': ('pine',),
'piner': ('pine',),
'pines': ('pine',),
'pint': ('pine',),
'pinte': ('pine',),
'pink': ('pinke',),
'pinka': ('pinke',),
'pinke': ('pinke',),
'pinker': ('pinke',),
'pinkes': ('pinke',),
'pinket': ('pinke',),
'pink': ('pinke',),
'pinka': ('pinke',),
'pinke': ('pinke',),
'pinker': ('pinke',),
'pinkes': ('pinke',),
'pinket': ('pinke',),
'pinn': ('pinne',),
'pinna': ('pinne',),
'pinne': ('pinne',),
'pinner': ('pinne',),
'pinnes': ('pinne',),
'pinnet': ('pinne',),
'pins': ('pinse',),
'pinsa': ('pinse',),
'pinse': ('pinse',),
'pinser': ('pinse',),
'pinses': ('pinse',),
'pinset': ('pinse',),
'peip': ('pipe',),
'pep': ('pipe',),
'pepet': ('pipe',),
'pip': ('pipe',),
'pipe': ('pipe',),
'piper': ('pipe',),
'pipes': ('pipe',),
'pipl': ('piple',),
'pipla': ('piple',),
'piple': ('piple',),
'pipler': ('piple',),
'piples': ('piple',),
'piplet': ('piple',),
'pipp': ('pippe',),
'pippa': ('pippe',),
'pippe': ('pippe',),
'pipper': ('pippe',),
'pippes': ('pippe',),
'pippet': ('pippe',),
'pirk': ('pirke',),
'pirka': ('pirke',),
'pirke': ('pirke',),
'pirker': ('pirke',),
'pirkes': ('pirke',),
'pirket': ('pirke',),
'pirr': ('pirre',),
'pirra': ('pirre',),
'pirre': ('pirre',),
'pirrer': ('pirre',),
'pirres': ('pirre',),
'pirret': ('pirre',),
'piruetter': ('piruettere',),
'piruettere': ('piruettere',),
'piruetterer': ('piruettere',),
'piruetteres': ('piruettere',),
'piruettert': ('piruettere',),
'piruetterte': ('piruettere',),
'pisk': ('piske',),
'piska': ('piske',),
'piske': ('piske',),
'pisker': ('piske',),
'piskes': ('piske',),
'pisket': ('piske',),
'piss': ('pisse',),
'pissa': ('pisse',),
'pisse': ('pisse',),
'pisser': ('pisse',),
'pisses': ('pisse',),
'pisset': ('pisse',),
'pist': ('pisse',),
'piste': ('pisse',),
'pist': ('piste',),
'pista': ('piste',),
'piste': ('piste',),
'pister': ('piste',),
'pistes': ('piste',),
'pistet': ('piste',),
'pistr': ('pistre',),
'pistra': ('pistre',),
'pistre': ('pistre',),
'pistrer': ('pistre',),
'pistres': ('pistre',),
'pistret': ('pistre',),
'pitl': ('pitle',),
'pitla': ('pitle',),
'pitle': ('pitle',),
'pitler': ('pitle',),
'pitles': ('pitle',),
'pitlet': ('pitle',),
'pjall': ('pjalle',),
'pjalla': ('pjalle',),
'pjalle': ('pjalle',),
'pjaller': ('pjalle',),
'pjalles': ('pjalle',),
'pjallet': ('pjalle',),
'pjatt': ('pjatte',),
'pjatta': ('pjatte',),
'pjatte': ('pjatte',),
'pjatter': ('pjatte',),
'pjattes': ('pjatte',),
'pjattet': ('pjatte',),
'pjoltr': ('pjoltre',),
'pjoltra': ('pjoltre',),
'pjoltre': ('pjoltre',),
'pjoltrer': ('pjoltre',),
'pjoltres': ('pjoltre',),
'pjoltret': ('pjoltre',),
'pjusk': ('pjuske',),
'pjuska': ('pjuske',),
'pjuske': ('pjuske',),
'pjusker': ('pjuske',),
'pjuskes': ('pjuske',),
'pjusket': ('pjuske',),
'pjutr': ('pjutre',),
'pjutra': ('pjutre',),
'pjutre': ('pjutre',),
'pjutrer': ('pjutre',),
'pjutres': ('pjutre',),
'pjutret': ('pjutre',),
'plaff': ('plaffe',),
'plaffa': ('plaffe',),
'plaffe': ('plaffe',),
'plaffer': ('plaffe',),
'plaffes': ('plaffe',),
'plaffet': ('plaffe',),
'plag': ('plage',),
'plaga': ('plage',),
'plagd': ('plage',),
'plagde': ('plage',),
'plage': ('plage',),
'plager': ('plage',),
'plages': ('plage',),
'plaget': ('plage',),
'plagier': ('plagiere',),
'plagiere': ('plagiere',),
'plagierer': ('plagiere',),
'plagieres': ('plagiere',),
'plagiert': ('plagiere',),
'plagierte': ('plagiere',),
'plan': ('plane',),
'plana': ('plane',),
'plane': ('plane',),
'planer': ('plane',),
'planes': ('plane',),
'planet': ('plane',),
'plant': ('plane',),
'plante': ('plane',),
'planer': ('planere',),
'planere': ('planere',),
'planerer': ('planere',),
'planeres': ('planere',),
'planert': ('planere',),
'planerte': ('planere',),
'planla': ('planlegge',),
'planlagt': ('planlegge',),
'planlegg': ('planlegge',),
'planlegge': ('planlegge',),
'planlegger': ('planlegge',),
'planlegges': ('planlegge',),
'plant': ('plante',),
'planta': ('plante',),
'plante': ('plante',),
'planter': ('plante',),
'plantes': ('plante',),
'plantet': ('plante',),
'plapr': ('plapre',),
'plapra': ('plapre',),
'plapre': ('plapre',),
'plaprer': ('plapre',),
'plapres': ('plapre',),
'plapret': ('plapre',),
'plask': ('plaske',),
'plaska': ('plaske',),
'plaske': ('plaske',),
'plasker': ('plaske',),
'plaskes': ('plaske',),
'plasket': ('plaske',),
'plasser': ('plassere',),
'plassere': ('plassere',),
'plasserer': ('plassere',),
'plasseres': ('plassere',),
'plassert': ('plassere',),
'plasserte': ('plassere',),
'plastr': ('plastre',),
'plastra': ('plastre',),
'plastre': ('plastre',),
'plastrer': ('plastre',),
'plastres': ('plastre',),
'plastret': ('plastre',),
'platiner': ('platinere',),
'platinere': ('platinere',),
'platinerer': ('platinere',),
'platineres': ('platinere',),
'platinert': ('platinere',),
'platinerte': ('platinere',),
'pleder': ('pledere',),
'pledere': ('pledere',),
'plederer': ('pledere',),
'plederes': ('pledere',),
'pledert': ('pledere',),
'plederte': ('pledere',),
'plei': ('pleie',),
'pleia': ('pleie',),
'pleid': ('pleie',),
'pleidd': ('pleie',),
'pleidde': ('pleie',),
'pleide': ('pleie',),
'pleie': ('pleie',),
'pleier': ('pleie',),
'pleies': ('pleie',),
'pleiet': ('pleie',),
'plei': ('pleie',),
'pleid': ('pleie',),
'pleidd': ('pleie',),
'pleidde': ('pleie',),
'pleide': ('pleie',),
'pleie': ('pleie',),
'pleier': ('pleie',),
'pleies': ('pleie',),
'pleiet': ('pleie',),
'plett': ('plette',),
'pletta': ('plette',),
'plette': ('plette',),
'pletter': ('plette',),
'plettes': ('plette',),
'plettet': ('plette',),
'pletter': ('plettere',),
'plettere': ('plettere',),
'pletterer': ('plettere',),
'pletteres': ('plettere',),
'plettert': ('plettere',),
'pletterte': ('plettere',),
'plikt': ('plikte',),
'plikta': ('plikte',),
'plikte': ('plikte',),
'plikter': ('plikte',),
'pliktes': ('plikte',),
'pliktet': ('plikte',),
'pling': ('plinge',),
'plinga': ('plinge',),
'plinge': ('plinge',),
'plinger': ('plinge',),
'plinges': ('plinge',),
'plinget': ('plinge',),
'plir': ('plire',),
'plira': ('plire',),
'plire': ('plire',),
'plirer': ('plire',),
'plires': ('plire',),
'pliret': ('plire',),
'plirt': ('plire',),
'plirte': ('plire',),
'plisser': ('plissere',),
'plissere': ('plissere',),
'plisserer': ('plissere',),
'plisseres': ('plissere',),
'plissert': ('plissere',),
'plisserte': ('plissere',),
'plog': ('ploge',),
'ploga': ('ploge',),
'ploge': ('ploge',),
'ploger': ('ploge',),
'ploges': ('ploge',),
'ploget': ('ploge',),
'plomber': ('plombere',),
'plombere': ('plombere',),
'plomberer': ('plombere',),
'plomberes': ('plombere',),
'plombert': ('plombere',),
'plomberte': ('plombere',),
'plott': ('plotte',),
'plotta': ('plotte',),
'plotte': ('plotte',),
'plotter': ('plotte',),
'plottes': ('plotte',),
'plottet': ('plotte',),
'pludr': ('pludre',),
'pludra': ('pludre',),
'pludre': ('pludre',),
'pludrer': ('pludre',),
'pludres': ('pludre',),
'pludret': ('pludre',),
'plugg': ('plugge',),
'plugga': ('plugge',),
'plugge': ('plugge',),
'plugger': ('plugge',),
'plugges': ('plugge',),
'plugget': ('plugge',),
'plukk': ('plukke',),
'plukka': ('plukke',),
'plukke': ('plukke',),
'plukker': ('plukke',),
'plukkes': ('plukke',),
'plukket': ('plukke',),
'plump': ('plumpe',),
'plumpa': ('plumpe',),
'plumpe': ('plumpe',),
'plumper': ('plumpe',),
'plumpes': ('plumpe',),
'plumpet': ('plumpe',),
'plundr': ('plundre',),
'plundra': ('plundre',),
'plundre': ('plundre',),
'plundrer': ('plundre',),
'plundres': ('plundre',),
'plundret': ('plundre',),
'pluss': ('plusse',),
'plussa': ('plusse',),
'plusse': ('plusse',),
'plusser': ('plusse',),
'plusses': ('plusse',),
'plusset': ('plusse',),
'plyndr': ('plyndre',),
'plyndra': ('plyndre',),
'plyndre': ('plyndre',),
'plyndrer': ('plyndre',),
'plyndres': ('plyndre',),
'plyndret': ('plyndre',),
'plystr': ('plystre',),
'plystra': ('plystre',),
'plystre': ('plystre',),
'plystrer': ('plystre',),
'plystres': ('plystre',),
'plystret': ('plystre',),
'pløs': ('pløse',),
'pløse': ('pløse',),
'pløser': ('pløse',),
'pløses': ('pløse',),
'pløst': ('pløse',),
'pløste': ('pløse',),
'pløgd': ('pløye',),
'pløgde': ('pløye',),
'pløy': ('pløye',),
'pløyd': ('pløye',),
'pløyde': ('pløye',),
'pløye': ('pløye',),
'pløyer': ('pløye',),
'pløyes': ('pløye',),
'pod': ('pode',),
'poda': ('pode',),
'pode': ('pode',),
'poder': ('pode',),
'podes': ('pode',),
'podet': ('pode',),
'pod': ('pode',),
'poda': ('pode',),
'pode': ('pode',),
'poder': ('pode',),
'podes': ('pode',),
'podet': ('pode',),
'poengter': ('poengtere',),
'poengtere': ('poengtere',),
'poengterer': ('poengtere',),
'poengteres': ('poengtere',),
'poengtert': ('poengtere',),
'poengterte': ('poengtere',),
'poetiser': ('poetisere',),
'poetisere': ('poetisere',),
'poetiserer': ('poetisere',),
'poetiseres': ('poetisere',),
'poetisert': ('poetisere',),
'poetiserte': ('poetisere',),
'pokr': ('pokre',),
'pokra': ('pokre',),
'pokre': ('pokre',),
'pokrer': ('pokre',),
'pokres': ('pokre',),
'pokret': ('pokre',),
'pokuler': ('pokulere',),
'pokulere': ('pokulere',),
'pokulerer': ('pokulere',),
'pokuleres': ('pokulere',),
'pokulert': ('pokulere',),
'pokulerte': ('pokulere',),
'polariser': ('polarisere',),
'polarisere': ('polarisere',),
'polariserer': ('polarisere',),
'polariseres': ('polarisere',),
'polarisert': ('polarisere',),
'polariserte': ('polarisere',),
'pol': ('pole',),
'pola': ('pole',),
'pole': ('pole',),
'poler': ('pole',),
'poles': ('pole',),
'polet': ('pole',),
'polt': ('pole',),
'polte': ('pole',),
'polemiser': ('polemisere',),
'polemisere': ('polemisere',),
'polemiserer': ('polemisere',),
'polemiseres': ('polemisere',),
'polemisert': ('polemisere',),
'polemiserte': ('polemisere',),
'poler': ('polere',),
'polere': ('polere',),
'polerer': ('polere',),
'poleres': ('polere',),
'polert': ('polere',),
'polerte': ('polere',),
'politiser': ('politisere',),
'politisere': ('politisere',),
'politiserer': ('politisere',),
'politiseres': ('politisere',),
'politisert': ('politisere',),
'politiserte': ('politisere',),
'polliner': ('pollinere',),
'pollinere': ('pollinere',),
'pollinerer': ('pollinere',),
'pollineres': ('pollinere',),
'pollinert': ('pollinere',),
'pollinerte': ('pollinere',),
'polstr': ('polstre',),
'polstra': ('polstre',),
'polstre': ('polstre',),
'polstrer': ('polstre',),
'polstres': ('polstre',),
'polstret': ('polstre',),
'polymeriser': ('polymerisere',),
'polymerisere': ('polymerisere',),
'polymeriserer': ('polymerisere',),
'polymeriseres': ('polymerisere',),
'polymerisert': ('polymerisere',),
'polymeriserte': ('polymerisere',),
'pomadiser': ('pomadisere',),
'pomadisere': ('pomadisere',),
'pomadiserer': ('pomadisere',),
'pomadiseres': ('pomadisere',),
'pomadisert': ('pomadisere',),
'pomadiserte': ('pomadisere',),
'poncer': ('poncere',),
'poncere': ('poncere',),
'poncerer': ('poncere',),
'ponceres': ('poncere',),
'poncert': ('poncere',),
'poncerte': ('poncere',),
'poner': ('ponere',),
'ponere': ('ponere',),
'ponerer': ('ponere',),
'poneres': ('ponere',),
'ponert': ('ponere',),
'ponerte': ('ponere',),
'popp': ('poppe',),
'poppa': ('poppe',),
'poppe': ('poppe',),
'popper': ('poppe',),
'poppes': ('poppe',),
'poppet': ('poppe',),
'popp': ('poppe',),
'poppa': ('poppe',),
'poppe': ('poppe',),
'popper': ('poppe',),
'poppes': ('poppe',),
'poppet': ('poppe',),
'populariser': ('popularisere',),
'popularisere': ('popularisere',),
'populariserer': ('popularisere',),
'populariseres': ('popularisere',),
'popularisert': ('popularisere',),
'populariserte': ('popularisere',),
'porsjoner': ('porsjonere',),
'porsjonere': ('porsjonere',),
'porsjonerer': ('porsjonere',),
'porsjoneres': ('porsjonere',),
'porsjonert': ('porsjonere',),
'porsjonerte': ('porsjonere',),
'portretter': ('portrettere',),
'portrettere': ('portrettere',),
'portretterer': ('portrettere',),
'portretteres': ('portrettere',),
'portrettert': ('portrettere',),
'portretterte': ('portrettere',),
'pos': ('pose',),
'posa': ('pose',),
'pose': ('pose',),
'poser': ('pose',),
'poses': ('pose',),
'poset': ('pose',),
'poser': ('posere',),
'posere': ('posere',),
'poserer': ('posere',),
'poseres': ('posere',),
'posert': ('posere',),
'poserte': ('posere',),
'posisjoner': ('posisjonere',),
'posisjonere': ('posisjonere',),
'posisjonerer': ('posisjonere',),
'posisjoneres': ('posisjonere',),
'posisjonert': ('posisjonere',),
'posisjonerte': ('posisjonere',),
'posjer': ('posjere',),
'posjere': ('posjere',),
'posjerer': ('posjere',),
'posjeres': ('posjere',),
'posjert': ('posjere',),
'posjerte': ('posjere',),
'postdater': ('postdatere',),
'postdatere': ('postdatere',),
'postdaterer': ('postdatere',),
'postdateres': ('postdatere',),
'postdatert': ('postdatere',),
'postdaterte': ('postdatere',),
'post': ('poste',),
'posta': ('poste',),
'poste': ('poste',),
'poster': ('poste',),
'postes': ('poste',),
'postet': ('poste',),
'poster': ('postere',),
'postere': ('postere',),
'posterer': ('postere',),
'posteres': ('postere',),
'postert': ('postere',),
'posterte': ('postere',),
'poster': ('postere',),
'postere': ('postere',),
'posterer': ('postere',),
'posteres': ('postere',),
'postert': ('postere',),
'posterte': ('postere',),
'postla': ('postlegge',),
'postlagt': ('postlegge',),
'postlegg': ('postlegge',),
'postlegge': ('postlegge',),
'postlegger': ('postlegge',),
'postlegges': ('postlegge',),
'poststempl': ('poststemple',),
'poststempla': ('poststemple',),
'poststemple': ('poststemple',),
'poststempler': ('poststemple',),
'poststemples': ('poststemple',),
'poststemplet': ('poststemple',),
'postuler': ('postulere',),
'postulere': ('postulere',),
'postulerer': ('postulere',),
'postuleres': ('postulere',),
'postulert': ('postulere',),
'postulerte': ('postulere',),
'pot': ('pote',),
'pota': ('pote',),
'pote': ('pote',),
'poter': ('pote',),
'potes': ('pote',),
'potet': ('pote',),
'pot': ('pote',),
'pota': ('pote',),
'pote': ('pote',),
'poter': ('pote',),
'potes': ('pote',),
'potet': ('pote',),
'potenser': ('potensere',),
'potensere': ('potensere',),
'potenserer': ('potensere',),
'potenseres': ('potensere',),
'potensert': ('potensere',),
'potenserte': ('potensere',),
'pott': ('potte',),
'potta': ('potte',),
'potte': ('potte',),
'potter': ('potte',),
'pottes': ('potte',),
'pottet': ('potte',),
'prai': ('praie',),
'praia': ('praie',),
'praie': ('praie',),
'praier': ('praie',),
'praies': ('praie',),
'praiet': ('praie',),
'prakk': ('prakke',),
'prakka': ('prakke',),
'prakke': ('prakke',),
'prakker': ('prakke',),
'prakkes': ('prakke',),
'prakket': ('prakke',),
'praktiser': ('praktisere',),
'praktisere': ('praktisere',),
'praktiserer': ('praktisere',),
'praktiseres': ('praktisere',),
'praktisert': ('praktisere',),
'praktiserte': ('praktisere',),
'pral': ('prale',),
'prala': ('prale',),
'prale': ('prale',),
'praler': ('prale',),
'prales': ('prale',),
'pralet': ('prale',),
'pralt': ('prale',),
'pralte': ('prale',),
'prang': ('prange',),
'pranga': ('prange',),
'prange': ('prange',),
'pranger': ('prange',),
'pranges': ('prange',),
'pranget': ('prange',),
'prang': ('prange',),
'pranga': ('prange',),
'prange': ('prange',),
'pranger': ('prange',),
'pranges': ('prange',),
'pranget': ('prange',),
'prang': ('prange',),
'pranga': ('prange',),
'prange': ('prange',),
'pranger': ('prange',),
'pranges': ('prange',),
'pranget': ('prange',),
'prasl': ('prasle',),
'prasla': ('prasle',),
'prasle': ('prasle',),
'prasler': ('prasle',),
'prasles': ('prasle',),
'praslet': ('prasle',),
'prat': ('prate',),
'prata': ('prate',),
'prate': ('prate',),
'prater': ('prate',),
'prates': ('prate',),
'pratet': ('prate',),
'predestiner': ('predestinere',),
'predestinere': ('predestinere',),
'predestinerer': ('predestinere',),
'predestineres': ('predestinere',),
'predestinert': ('predestinere',),
'predestinerte': ('predestinere',),
'predeterminer': ('predeterminere',),
'predeterminere': ('predeterminere',),
'predeterminerer': ('predeterminere',),
'predetermineres': ('predeterminere',),
'predeterminert': ('predeterminere',),
'predeterminerte': ('predeterminere',),
'predik': ('predike',),
'predika': ('predike',),
'predike': ('predike',),
'prediker': ('predike',),
'predikes': ('predike',),
'prediket': ('predike',),
'prediker': ('predikere',),
'predikere': ('predikere',),
'predikerer': ('predikere',),
'predikeres': ('predikere',),
'predikert': ('predikere',),
'predikerte': ('predikere',),
'predisponer': ('predisponere',),
'predisponere': ('predisponere',),
'predisponerer': ('predisponere',),
'predisponeres': ('predisponere',),
'predisponert': ('predisponere',),
'predisponerte': ('predisponere',),
'prefabrikker': ('prefabrikkere',),
'prefabrikkere': ('prefabrikkere',),
'prefabrikkerer': ('prefabrikkere',),
'prefabrikkeres': ('prefabrikkere',),
'prefabrikkert': ('prefabrikkere',),
'prefabrikkerte': ('prefabrikkere',),
'preferer': ('preferere',),
'preferere': ('preferere',),
'prefererer': ('preferere',),
'prefereres': ('preferere',),
'preferert': ('preferere',),
'prefererte': ('preferere',),
'preg': ('prege',),
'prega': ('prege',),
'prege': ('prege',),
'preger': ('prege',),
'preges': ('prege',),
'preget': ('prege',),
'prekaver': ('prekavere',),
'prekavere': ('prekavere',),
'prekaverer': ('prekavere',),
'prekaveres': ('prekavere',),
'prekavert': ('prekavere',),
'prekaverte': ('prekavere',),
'prek': ('preke',),
'preke': ('preke',),
'preker': ('preke',),
'prekes': ('preke',),
'prekt': ('preke',),
'prekte': ('preke',),
'prell': ('prelle',),
'prella': ('prelle',),
'prelle': ('prelle',),
'preller': ('prelle',),
'prelles': ('prelle',),
'prellet': ('prelle',),
'preluder': ('preludere',),
'preludere': ('preludere',),
'preluderer': ('preludere',),
'preluderes': ('preludere',),
'preludert': ('preludere',),
'preluderte': ('preludere',),
'premier': ('premiere',),
'premiere': ('premiere',),
'premierer': ('premiere',),
'premieres': ('premiere',),
'premiert': ('premiere',),
'premierte': ('premiere',),
'prent': ('prente',),
'prenta': ('prente',),
'prente': ('prente',),
'prenter': ('prente',),
'prentes': ('prente',),
'prentet': ('prente',),
'prenumerer': ('prenumerere',),
'prenumerere': ('prenumerere',),
'prenumererer': ('prenumerere',),
'prenumereres': ('prenumerere',),
'prenumerert': ('prenumerere',),
'prenumererte': ('prenumerere',),
'preparer': ('preparere',),
'preparere': ('preparere',),
'preparerer': ('preparere',),
'prepareres': ('preparere',),
'preparert': ('preparere',),
'preparerte': ('preparere',),
'prepp': ('preppe',),
'preppa': ('preppe',),
'preppe': ('preppe',),
'prepper': ('preppe',),
'preppes': ('preppe',),
'preppet': ('preppe',),
'presenter': ('presentere',),
'presentere': ('presentere',),
'presenterer': ('presentere',),
'presenteres': ('presentere',),
'presentert': ('presentere',),
'presenterte': ('presentere',),
'preserver': ('preservere',),
'preservere': ('preservere',),
'preserverer': ('preservere',),
'preserveres': ('preservere',),
'preservert': ('preservere',),
'preserverte': ('preservere',),
'presider': ('presidere',),
'presidere': ('presidere',),
'presiderer': ('presidere',),
'presideres': ('presidere',),
'presidert': ('presidere',),
'presiderte': ('presidere',),
'presiser': ('presisere',),
'presisere': ('presisere',),
'presiserer': ('presisere',),
'presiseres': ('presisere',),
'presisert': ('presisere',),
'presiserte': ('presisere',),
'preskriber': ('preskribere',),
'preskribere': ('preskribere',),
'preskriberer': ('preskribere',),
'preskriberes': ('preskribere',),
'preskribert': ('preskribere',),
'preskriberte': ('preskribere',),
'press': ('presse',),
'pressa': ('presse',),
'presse': ('presse',),
'presser': ('presse',),
'presses': ('presse',),
'presset': ('presse',),
'prester': ('prestere',),
'prestere': ('prestere',),
'presterer': ('prestere',),
'presteres': ('prestere',),
'prestert': ('prestere',),
'presterte': ('prestere',),
'prestevi': ('prestevie',),
'prestevia': ('prestevie',),
'prestevidd': ('prestevie',),
'prestevidde': ('prestevie',),
'prestevie': ('prestevie',),
'prestevier': ('prestevie',),
'prestevies': ('prestevie',),
'presteviet': ('prestevie',),
'prestevigd': ('prestevie',),
'prestevigde': ('prestevie',),
'presumer': ('presumere',),
'presumere': ('presumere',),
'presumerer': ('presumere',),
'presumeres': ('presumere',),
'presumert': ('presumere',),
'presumerte': ('presumere',),
'presupponer': ('presupponere',),
'presupponere': ('presupponere',),
'presupponerer': ('presupponere',),
'presupponeres': ('presupponere',),
'presupponert': ('presupponere',),
'presupponerte': ('presupponere',),
'pretender': ('pretendere',),
'pretendere': ('pretendere',),
'pretenderer': ('pretendere',),
'pretenderes': ('pretendere',),
'pretendert': ('pretendere',),
'pretenderte': ('pretendere',),
'prett': ('prette',),
'pretta': ('prette',),
'prette': ('prette',),
'pretter': ('prette',),
'prettes': ('prette',),
'prettet': ('prette',),
'prikk': ('prikke',),
'prikka': ('prikke',),
'prikke': ('prikke',),
'prikker': ('prikke',),
'prikkes': ('prikke',),
'prikket': ('prikke',),
'prikl': ('prikle',),
'prikla': ('prikle',),
'prikle': ('prikle',),
'prikler': ('prikle',),
'prikles': ('prikle',),
'priklet': ('prikle',),
'prill': ('prille',),
'prilla': ('prille',),
'prille': ('prille',),
'priller': ('prille',),
'prilles': ('prille',),
'prillet': ('prille',),
'prim': ('prime',),
'prima': ('prime',),
'prime': ('prime',),
'primer': ('prime',),
'primes': ('prime',),
'primet': ('prime',),
'primt': ('prime',),
'primte': ('prime',),
'primsign': ('primsigne',),
'primsigna': ('primsigne',),
'primsigne': ('primsigne',),
'primsigner': ('primsigne',),
'primsignes': ('primsigne',),
'primsignet': ('primsigne',),
'prioriter': ('prioritere',),
'prioritere': ('prioritere',),
'prioriterer': ('prioritere',),
'prioriteres': ('prioritere',),
'prioritert': ('prioritere',),
'prioriterte': ('prioritere',),
'prisbelønn': ('prisbelønne',),
'prisbelønna': ('prisbelønne',),
'prisbelønne': ('prisbelønne',),
'prisbelønner': ('prisbelønne',),
'prisbelønnes': ('prisbelønne',),
'prisbelønnet': ('prisbelønne',),
'prisbelønt': ('prisbelønne',),
'prisbelønte': ('prisbelønne',),
'pris': ('prise',),
'prisa': ('prise',),
'prise': ('prise',),
'priser': ('prise',),
'prises': ('prise',),
'priset': ('prise',),
'pris': ('prise',),
'prise': ('prise',),
'priser': ('prise',),
'prises': ('prise',),
'prist': ('prise',),
'priste': ('prise',),
'prisga': ('prisgi',),
'prisgav': ('prisgi',),
'prisgi': ('prisgi',),
'prisgies': ('prisgi',),
'prisgir': ('prisgi',),
'prisgis': ('prisgi',),
'prisgitt': ('prisgi',),
'privatiser': ('privatisere',),
'privatisere': ('privatisere',),
'privatiserer': ('privatisere',),
'privatiseres': ('privatisere',),
'privatisert': ('privatisere',),
'privatiserte': ('privatisere',),
'privileger': ('privilegere',),
'privilegere': ('privilegere',),
'privilegerer': ('privilegere',),
'privilegeres': ('privilegere',),
'privilegert': ('privilegere',),
'privilegerte': ('privilegere',),
'prober': ('probere',),
'probere': ('probere',),
'proberer': ('probere',),
'proberes': ('probere',),
'probert': ('probere',),
'proberte': ('probere',),
'problematiser': ('problematisere',),
'problematisere': ('problematisere',),
'problematiserer': ('problematisere',),
'problematiseres': ('problematisere',),
'problematisert': ('problematisere',),
'problematiserte': ('problematisere',),
'produser': ('produsere',),
'produsere': ('produsere',),
'produserer': ('produsere',),
'produseres': ('produsere',),
'produsert': ('produsere',),
'produserte': ('produsere',),
'pro': ('proe',),
'proa': ('proe',),
'proe': ('proe',),
'proer': ('proe',),
'proes': ('proe',),
'proet': ('proe',),
'pro': ('proe',),
'proa': ('proe',),
'proe': ('proe',),
'proer': ('proe',),
'proes': ('proe',),
'proet': ('proe',),
'profaner': ('profanere',),
'profanere': ('profanere',),
'profanerer': ('profanere',),
'profaneres': ('profanere',),
'profanert': ('profanere',),
'profanerte': ('profanere',),
'profesjonaliser': ('profesjonalisere',),
'profesjonalisere': ('profesjonalisere',),
'profesjonaliserer': ('profesjonalisere',),
'profesjonaliseres': ('profesjonalisere',),
'profesjonalisert': ('profesjonalisere',),
'profesjonaliserte': ('profesjonalisere',),
'profeter': ('profetere',),
'profetere': ('profetere',),
'profeterer': ('profetere',),
'profeteres': ('profetere',),
'profetert': ('profetere',),
'profeterte': ('profetere',),
'profiler': ('profilere',),
'profilere': ('profilere',),
'profilerer': ('profilere',),
'profileres': ('profilere',),
'profilert': ('profilere',),
'profilerte': ('profilere',),
'profitter': ('profittere',),
'profittere': ('profittere',),
'profitterer': ('profittere',),
'profitteres': ('profittere',),
'profittert': ('profittere',),
'profitterte': ('profittere',),
'prognoser': ('prognosere',),
'prognosere': ('prognosere',),
'prognoserer': ('prognosere',),
'prognoseres': ('prognosere',),
'prognosert': ('prognosere',),
'prognoserte': ('prognosere',),
'prognostiser': ('prognostisere',),
'prognostisere': ('prognostisere',),
'prognostiserer': ('prognostisere',),
'prognostiseres': ('prognostisere',),
'prognostisert': ('prognostisere',),
'prognostiserte': ('prognostisere',),
'programfest': ('programfeste',),
'programfesta': ('programfeste',),
'programfeste': ('programfeste',),
'programfester': ('programfeste',),
'programfestes': ('programfeste',),
'programfestet': ('programfeste',),
'programmer': ('programmere',),
'programmere': ('programmere',),
'programmerer': ('programmere',),
'programmeres': ('programmere',),
'programmert': ('programmere',),
'programmerte': ('programmere',),
'projiser': ('projisere',),
'projisere': ('projisere',),
'projiserer': ('projisere',),
'projiseres': ('projisere',),
'projisert': ('projisere',),
'projiserte': ('projisere',),
'proklamer': ('proklamere',),
'proklamere': ('proklamere',),
'proklamerer': ('proklamere',),
'proklameres': ('proklamere',),
'proklamert': ('proklamere',),
'proklamerte': ('proklamere',),
'proletariser': ('proletarisere',),
'proletarisere': ('proletarisere',),
'proletariserer': ('proletarisere',),
'proletariseres': ('proletarisere',),
'proletarisert': ('proletarisere',),
'proletariserte': ('proletarisere',),
'prolonger': ('prolongere',),
'prolongere': ('prolongere',),
'prolongerer': ('prolongere',),
'prolongeres': ('prolongere',),
'prolongert': ('prolongere',),
'prolongerte': ('prolongere',),
'promener': ('promenere',),
'promenere': ('promenere',),
'promenerer': ('promenere',),
'promeneres': ('promenere',),
'promenert': ('promenere',),
'promenerte': ('promenere',),
'promover': ('promovere',),
'promovere': ('promovere',),
'promoverer': ('promovere',),
'promoveres': ('promovere',),
'promovert': ('promovere',),
'promoverte': ('promovere',),
'promp': ('prompe',),
'prompa': ('prompe',),
'prompe': ('prompe',),
'promper': ('prompe',),
'prompes': ('prompe',),
'prompet': ('prompe',),
'promulger': ('promulgere',),
'promulgere': ('promulgere',),
'promulgerer': ('promulgere',),
'promulgeres': ('promulgere',),
'promulgert': ('promulgere',),
'promulgerte': ('promulgere',),
'proner': ('pronere',),
'pronere': ('pronere',),
'pronerer': ('pronere',),
'proneres': ('pronere',),
'pronert': ('pronere',),
'pronerte': ('pronere',),
'pronominaliser': ('pronominalisere',),
'pronominalisere': ('pronominalisere',),
'pronominaliserer': ('pronominalisere',),
'pronominaliseres': ('pronominalisere',),
'pronominalisert': ('pronominalisere',),
'pronominaliserte': ('pronominalisere',),
'propagander': ('propagandere',),
'propagandere': ('propagandere',),
'propaganderer': ('propagandere',),
'propaganderes': ('propagandere',),
'propagandert': ('propagandere',),
'propaganderte': ('propagandere',),
'propager': ('propagere',),
'propagere': ('propagere',),
'propagerer': ('propagere',),
'propageres': ('propagere',),
'propagert': ('propagere',),
'propagerte': ('propagere',),
'proponer': ('proponere',),
'proponere': ('proponere',),
'proponerer': ('proponere',),
'proponeres': ('proponere',),
'proponert': ('proponere',),
'proponerte': ('proponere',),
'proporsjoner': ('proporsjonere',),
'proporsjonere': ('proporsjonere',),
'proporsjonerer': ('proporsjonere',),
'proporsjoneres': ('proporsjonere',),
'proporsjonert': ('proporsjonere',),
'proporsjonerte': ('proporsjonere',),
'propp': ('proppe',),
'proppa': ('proppe',),
'proppe': ('proppe',),
'propper': ('proppe',),
'proppes': ('proppe',),
'proppet': ('proppe',),
'proseder': ('prosedere',),
'prosedere': ('prosedere',),
'prosederer': ('prosedere',),
'prosederes': ('prosedere',),
'prosedert': ('prosedere',),
'prosederte': ('prosedere',),
'prosentlønn': ('prosentlønne',),
'prosentlønna': ('prosentlønne',),
'prosentlønne': ('prosentlønne',),
'prosentlønner': ('prosentlønne',),
'prosentlønnes': ('prosentlønne',),
'prosentlønnet': ('prosentlønne',),
'prosentlønt': ('prosentlønne',),
'prosentlønte': ('prosentlønne',),
'prosesser': ('prosessere',),
'prosessere': ('prosessere',),
'prosesserer': ('prosessere',),
'prosesseres': ('prosessere',),
'prosessert': ('prosessere',),
'prosesserte': ('prosessere',),
'prosjekter': ('prosjektere',),
'prosjektere': ('prosjektere',),
'prosjekterer': ('prosjektere',),
'prosjekteres': ('prosjektere',),
'prosjektert': ('prosjektere',),
'prosjekterte': ('prosjektere',),
'proskriber': ('proskribere',),
'proskribere': ('proskribere',),
'proskriberer': ('proskribere',),
'proskriberes': ('proskribere',),
'proskribert': ('proskribere',),
'proskriberte': ('proskribere',),
'prospekter': ('prospektere',),
'prospektere': ('prospektere',),
'prospekterer': ('prospektere',),
'prospekteres': ('prospektere',),
'prospektert': ('prospektere',),
'prospekterte': ('prospektere',),
'prostituer': ('prostituere',),
'prostituere': ('prostituere',),
'prostituerer': ('prostituere',),
'prostitueres': ('prostituere',),
'prostituert': ('prostituere',),
'prostituerte': ('prostituere',),
'protesjer': ('protesjere',),
'protesjere': ('protesjere',),
'protesjerer': ('protesjere',),
'protesjeres': ('protesjere',),
'protesjert': ('protesjere',),
'protesjerte': ('protesjere',),
'protester': ('protestere',),
'protestere': ('protestere',),
'protesterer': ('protestere',),
'protesteres': ('protestere',),
'protestert': ('protestere',),
'protesterte': ('protestere',),
'protokoller': ('protokollere',),
'protokollere': ('protokollere',),
'protokollerer': ('protokollere',),
'protokolleres': ('protokollere',),
'protokollert': ('protokollere',),
'protokollerte': ('protokollere',),
'prott': ('protte',),
'protta': ('protte',),
'protte': ('protte',),
'protter': ('protte',),
'prottes': ('protte',),
'prottet': ('protte',),
'prott': ('protte',),
'protta': ('protte',),
'protte': ('protte',),
'protter': ('protte',),
'prottes': ('protte',),
'prottet': ('protte',),
'prov': ('prove',),
'prova': ('prove',),
'prove': ('prove',),
'prover': ('prove',),
'proves': ('prove',),
'provet': ('prove',),
'provianter': ('proviantere',),
'proviantere': ('proviantere',),
'provianterer': ('proviantere',),
'provianteres': ('proviantere',),
'proviantert': ('proviantere',),
'provianterte': ('proviantere',),
'provider': ('providere',),
'providere': ('providere',),
'providerer': ('providere',),
'provideres': ('providere',),
'providert': ('providere',),
'providerte': ('providere',),
'provoser': ('provosere',),
'provosere': ('provosere',),
'provoserer': ('provosere',),
'provoseres': ('provosere',),
'provosert': ('provosere',),
'provoserte': ('provosere',),
'prunk': ('prunke',),
'prunka': ('prunke',),
'prunke': ('prunke',),
'prunker': ('prunke',),
'prunkes': ('prunke',),
'prunket': ('prunke',),
'prupp': ('pruppe',),
'pruppa': ('pruppe',),
'pruppe': ('pruppe',),
'prupper': ('pruppe',),
'pruppes': ('pruppe',),
'pruppet': ('pruppe',),
'prust': ('pruste',),
'prusta': ('pruste',),
'pruste': ('pruste',),
'pruster': ('pruste',),
'prustes': ('pruste',),
'prustet': ('pruste',),
'prut': ('prute',),
'pruta': ('prute',),
'prute': ('prute',),
'pruter': ('prute',),
'prutes': ('prute',),
'prutet': ('prute',),
'pryd': ('pryde',),
'pryda': ('pryde',),
'pryde': ('pryde',),
'pryder': ('pryde',),
'prydes': ('pryde',),
'prydet': ('pryde',),
'pryl': ('pryle',),
'pryle': ('pryle',),
'pryler': ('pryle',),
'pryles': ('pryle',),
'prylt': ('pryle',),
'prylte': ('pryle',),
'prøv': ('prøve',),
'prøvd': ('prøve',),
'prøvde': ('prøve',),
'prøve': ('prøve',),
'prøver': ('prøve',),
'prøves': ('prøve',),
'prøvebor': ('prøvebore',),
'prøvebora': ('prøvebore',),
'prøvebore': ('prøvebore',),
'prøveborer': ('prøvebore',),
'prøvebores': ('prøvebore',),
'prøveboret': ('prøvebore',),
'prøvefilm': ('prøvefilme',),
'prøvefilma': ('prøvefilme',),
'prøvefilme': ('prøvefilme',),
'prøvefilmer': ('prøvefilme',),
'prøvefilmes': ('prøvefilme',),
'prøvefilmet': ('prøvefilme',),
'prøvekjør': ('prøvekjøre',),
'prøvekjøre': ('prøvekjøre',),
'prøvekjører': ('prøvekjøre',),
'prøvekjøres': ('prøvekjøre',),
'prøvekjørt': ('prøvekjøre',),
'prøvekjørte': ('prøvekjøre',),
'prøveskaut': ('prøveskyte',),
'prøveskjøt': ('prøveskyte',),
'prøveskutt': ('prøveskyte',),
'prøveskyt': ('prøveskyte',),
'prøveskyte': ('prøveskyte',),
'prøveskyter': ('prøveskyte',),
'prøveskytes': ('prøveskyte',),
'prøveskøyt': ('prøveskyte',),
'psyk': ('psyke',),
'psyka': ('psyke',),
'psyke': ('psyke',),
'psyker': ('psyke',),
'psykes': ('psyke',),
'psyket': ('psyke',),
'psykoanalyser': ('psykoanalysere',),
'psykoanalysere': ('psykoanalysere',),
'psykoanalyserer': ('psykoanalysere',),
'psykoanalyseres': ('psykoanalysere',),
'psykoanalysert': ('psykoanalysere',),
'psykoanalyserte': ('psykoanalysere',),
'ptro': ('ptroe',),
'ptroa': ('ptroe',),
'ptroe': ('ptroe',),
'ptroer': ('ptroe',),
'ptroes': ('ptroe',),
'ptroet': ('ptroe',),
'ptro': ('ptroe',),
'ptroa': ('ptroe',),
'ptroe': ('ptroe',),
'ptroer': ('ptroe',),
'ptroes': ('ptroe',),
'ptroet': ('ptroe',),
'ptrott': ('ptrotte',),
'ptrotta': ('ptrotte',),
'ptrotte': ('ptrotte',),
'ptrotter': ('ptrotte',),
'ptrottes': ('ptrotte',),
'ptrottet': ('ptrotte',),
'ptrott': ('ptrotte',),
'ptrotta': ('ptrotte',),
'ptrotte': ('ptrotte',),
'ptrotter': ('ptrotte',),
'ptrottes': ('ptrotte',),
'ptrottet': ('ptrotte',),
'publiser': ('publisere',),
'publisere': ('publisere',),
'publiserer': ('publisere',),
'publiseres': ('publisere',),
'publisert': ('publisere',),
'publiserte': ('publisere',),
'pudr': ('pudre',),
'pudra': ('pudre',),
'pudre': ('pudre',),
'pudrer': ('pudre',),
'pudres': ('pudre',),
'pudret': ('pudre',),
'puff': ('puffe',),
'puffa': ('puffe',),
'puffe': ('puffe',),
'puffer': ('puffe',),
'puffes': ('puffe',),
'puffet': ('puffe',),
'puff': ('puffe',),
'puffa': ('puffe',),
'puffe': ('puffe',),
'puffer': ('puffe',),
'puffes': ('puffe',),
'puffet': ('puffe',),
'pug': ('puge',),
'puga': ('puge',),
'puge': ('puge',),
'puger': ('puge',),
'puges': ('puge',),
'puget': ('puge',),
'pugg': ('pugge',),
'pugga': ('pugge',),
'pugge': ('pugge',),
'pugger': ('pugge',),
'pugges': ('pugge',),
'pugget': ('pugge',),
'pukk': ('pukke',),
'pukka': ('pukke',),
'pukke': ('pukke',),
'pukker': ('pukke',),
'pukkes': ('pukke',),
'pukket': ('pukke',),
'puldr': ('puldre',),
'puldra': ('puldre',),
'puldre': ('puldre',),
'puldrer': ('puldre',),
'puldres': ('puldre',),
'puldret': ('puldre',),
'pul': ('pule',),
'pule': ('pule',),
'puler': ('pule',),
'pules': ('pule',),
'pult': ('pule',),
'pulte': ('pule',),
'puls': ('pulse',),
'pulsa': ('pulse',),
'pulse': ('pulse',),
'pulser': ('pulse',),
'pulses': ('pulse',),
'pulset': ('pulse',),
'puls': ('pulse',),
'pulsa': ('pulse',),
'pulse': ('pulse',),
'pulser': ('pulse',),
'pulses': ('pulse',),
'pulset': ('pulse',),
'pulser': ('pulsere',),
'pulsere': ('pulsere',),
'pulserer': ('pulsere',),
'pulseres': ('pulsere',),
'pulsert': ('pulsere',),
'pulserte': ('pulsere',),
'pulveriser': ('pulverisere',),
'pulverisere': ('pulverisere',),
'pulveriserer': ('pulverisere',),
'pulveriseres': ('pulverisere',),
'pulverisert': ('pulverisere',),
'pulveriserte': ('pulverisere',),
'pump': ('pumpe',),
'pumpa': ('pumpe',),
'pumpe': ('pumpe',),
'pumper': ('pumpe',),
'pumpes': ('pumpe',),
'pumpet': ('pumpe',),
'pumpebrems': ('pumpebremse',),
'pumpebremsa': ('pumpebremse',),
'pumpebremse': ('pumpebremse',),
'pumpebremser': ('pumpebremse',),
'pumpebremses': ('pumpebremse',),
'pumpebremset': ('pumpebremse',),
'punch': ('punche',),
'puncha': ('punche',),
'punche': ('punche',),
'puncher': ('punche',),
'punches': ('punche',),
'punchet': ('punche',),
'pung': ('punge',),
'punga': ('punge',),
'punge': ('punge',),
'punger': ('punge',),
'punges': ('punge',),
'punget': ('punge',),
'punkter': ('punktere',),
'punktere': ('punktere',),
'punkterer': ('punktere',),
'punkteres': ('punktere',),
'punktert': ('punktere',),
'punkterte': ('punktere',),
'purk': ('purke',),
'purka': ('purke',),
'purke': ('purke',),
'purker': ('purke',),
'purkes': ('purke',),
'purket': ('purke',),
'purl': ('purle',),
'purla': ('purle',),
'purle': ('purle',),
'purler': ('purle',),
'purles': ('purle',),
'purlet': ('purle',),
'purr': ('purre',),
'purra': ('purre',),
'purre': ('purre',),
'purrer': ('purre',),
'purres': ('purre',),
'purret': ('purre',),
'push': ('pushe',),
'pusha': ('pushe',),
'pushe': ('pushe',),
'pusher': ('pushe',),
'pushes': ('pushe',),
'pushet': ('pushe',),
'pusl': ('pusle',),
'pusla': ('pusle',),
'pusle': ('pusle',),
'pusler': ('pusle',),
'pusles': ('pusle',),
'puslet': ('pusle',),
'puss': ('pusse',),
'pussa': ('pusse',),
'pusse': ('pusse',),
'pusser': ('pusse',),
'pusses': ('pusse',),
'pusset': ('pusse',),
'puss': ('pusse',),
'pussa': ('pusse',),
'pusse': ('pusse',),
'pusser': ('pusse',),
'pusses': ('pusse',),
'pusset': ('pusse',),
'pust': ('puste',),
'pusta': ('puste',),
'puste': ('puste',),
'puster': ('puste',),
'pustes': ('puste',),
'pustet': ('puste',),
'putl': ('putle',),
'putla': ('putle',),
'putle': ('putle',),
'putler': ('putle',),
'putles': ('putle',),
'putlet': ('putle',),
'putr': ('putre',),
'putra': ('putre',),
'putre': ('putre',),
'putrer': ('putre',),
'putres': ('putre',),
'putret': ('putre',),
'putt': ('putte',),
'putta': ('putte',),
'putte': ('putte',),
'putter': ('putte',),
'puttes': ('putte',),
'puttet': ('putte',),
'pynt': ('pynte',),
'pynta': ('pynte',),
'pynte': ('pynte',),
'pynter': ('pynte',),
'pyntes': ('pynte',),
'pyntet': ('pynte',),
'påakt': ('påakte',),
'påakta': ('påakte',),
'påakte': ('påakte',),
'påakter': ('påakte',),
'påaktes': ('påakte',),
'påaktet': ('påakte',),
'påank': ('påanke',),
'påanka': ('påanke',),
'påanke': ('påanke',),
'påanker': ('påanke',),
'påankes': ('påanke',),
'påanket': ('påanke',),
'påberop': ('påberope',),
'påberope': ('påberope',),
'påberoper': ('påberope',),
'påberopes': ('påberope',),
'påberopt': ('påberope',),
'påberopte': ('påberope',),
'påbaud': ('påby',),
'påbudt': ('påby',),
'påby': ('påby',),
'påbydd': ('påby',),
'påbydde': ('påby',),
'påbyr': ('påby',),
'påbys': ('påby',),
'påbød': ('påby',),
'påbøy': ('påby',),
'pådra': ('pådra',),
'pådradd': ('pådra',),
'pådrar': ('pådra',),
'pådras': ('pådra',),
'pådratt': ('pådra',),
'pådro': ('pådra',),
'pådrog': ('pådra',),
'pådøm': ('pådømme',),
'pådømme': ('pådømme',),
'pådømmer': ('pådømme',),
'pådømmes': ('pådømme',),
'pådømt': ('pådømme',),
'pådømte': ('pådømme',),
'påfør': ('påføre',),
'påføre': ('påføre',),
'påfører': ('påføre',),
'påføres': ('påføre',),
'påført': ('påføre',),
'påførte': ('påføre',),
'pågreip': ('pågripe',),
'pågrep': ('pågripe',),
'pågrepet': ('pågripe',),
'pågrip': ('pågripe',),
'pågripe': ('pågripe',),
'pågriper': ('pågripe',),
'pågripes': ('pågripe',),
'pågikk': ('pågå',),
'pågjekk': ('pågå',),
'pågå': ('pågå',),
'pågåes': ('pågå',),
'pågår': ('pågå',),
'pågås': ('pågå',),
'pågått': ('pågå',),
'påhvil': ('påhvile',),
'påhvile': ('påhvile',),
'påhviler': ('påhvile',),
'påhviles': ('påhvile',),
'påhvilt': ('påhvile',),
'påhvilte': ('påhvile',),
'påkall': ('påkalle',),
'påkalle': ('påkalle',),
'påkaller': ('påkalle',),
'påkalles': ('påkalle',),
'påkalt': ('påkalle',),
'påkalte': ('påkalle',),
'påkjær': ('påkjære',),
'påkjære': ('påkjære',),
'påkjærer': ('påkjære',),
'påkjæres': ('påkjære',),
'påkjært': ('påkjære',),
'påkjærte': ('påkjære',),
'påkjør': ('påkjøre',),
'påkjøre': ('påkjøre',),
'påkjører': ('påkjøre',),
'påkjøres': ('påkjøre',),
'påkjørt': ('påkjøre',),
'påkjørte': ('påkjøre',),
'påklag': ('påklage',),
'påklaga': ('påklage',),
'påklagd': ('påklage',),
'påklagde': ('påklage',),
'påklage': ('påklage',),
'påklager': ('påklage',),
'påklages': ('påklage',),
'påklaget': ('påklage',),
'påla': ('pålegge',),
'pålagt': ('pålegge',),
'pålegg': ('pålegge',),
'pålegge': ('pålegge',),
'pålegger': ('pålegge',),
'pålegges': ('pålegge',),
'påligg': ('påligge',),
'påligge': ('påligge',),
'påligger': ('påligge',),
'påligges': ('påligge',),
'påligget': ('påligge',),
'pålå': ('påligge',),
'pålåg': ('påligge',),
'påløp': ('påløpe',),
'påløpe': ('påløpe',),
'påløper': ('påløpe',),
'påløpes': ('påløpe',),
'påløpet': ('påløpe',),
'påløpt': ('påløpe',),
'påpek': ('påpeke',),
'påpeke': ('påpeke',),
'påpeker': ('påpeke',),
'påpekes': ('påpeke',),
'påpekt': ('påpeke',),
'påpekte': ('påpeke',),
'påregn': ('påregne',),
'påregna': ('påregne',),
'påregne': ('påregne',),
'påregner': ('påregne',),
'påregnes': ('påregne',),
'påregnet': ('påregne',),
'pårekn': ('pårekne',),
'pårekna': ('pårekne',),
'pårekne': ('pårekne',),
'pårekner': ('pårekne',),
'påreknes': ('pårekne',),
'påreknet': ('pårekne',),
'påse': ('påse',),
'påsees': ('påse',),
'påser': ('påse',),
'påses': ('påse',),
'påsett': ('påse',),
'påså': ('påse',),
'påsåg': ('påse',),
'påskjønn': ('påskjønne',),
'påskjønna': ('påskjønne',),
'påskjønne': ('påskjønne',),
'påskjønner': ('påskjønne',),
'påskjønnes': ('påskjønne',),
'påskjønnet': ('påskjønne',),
'påskjønt': ('påskjønne',),
'påskjønte': ('påskjønne',),
'påskynd': ('påskynde',),
'påskynda': ('påskynde',),
'påskynde': ('påskynde',),
'påskynder': ('påskynde',),
'påskyndes': ('påskynde',),
'påskyndet': ('påskynde',),
'påskyndt': ('påskynde',),
'påskyndte': ('påskynde',),
'påsto': ('påstå',),
'påstod': ('påstå',),
'påstå': ('påstå',),
'påståes': ('påstå',),
'påstår': ('påstå',),
'påstås': ('påstå',),
'påstått': ('påstå',),
'påta': ('påta',),
'påtaes': ('påta',),
'påtar': ('påta',),
'påtas': ('påta',),
'påtatt': ('påta',),
'påtok': ('påta',),
'påtal': ('påtale',),
'påtale': ('påtale',),
'påtaler': ('påtale',),
'påtales': ('påtale',),
'påtalt': ('påtale',),
'påtalte': ('påtale',),
'påtegn': ('påtegne',),
'påtegna': ('påtegne',),
'påtegne': ('påtegne',),
'påtegner': ('påtegne',),
'påtegnes': ('påtegne',),
'påtegnet': ('påtegne',),
'påtenn': ('påtenne',),
'påtenne': ('påtenne',),
'påtenner': ('påtenne',),
'påtennes': ('påtenne',),
'påtent': ('påtenne',),
'påtente': ('påtenne',),
'påtraff': ('påtreffe',),
'påtreff': ('påtreffe',),
'påtreffe': ('påtreffe',),
'påtreffer': ('påtreffe',),
'påtreffes': ('påtreffe',),
'påtruffet': ('påtreffe',),
'påtvang': ('påtvinge',),
'påtving': ('påtvinge',),
'påtvinge': ('påtvinge',),
'påtvinger': ('påtvinge',),
'påtvinges': ('påtvinge',),
'påtvunget': ('påtvinge',),
'påvirk': ('påvirke',),
'påvirka': ('påvirke',),
'påvirke': ('påvirke',),
'påvirker': ('påvirke',),
'påvirkes': ('påvirke',),
'påvirket': ('påvirke',),
'påvis': ('påvise',),
'påvise': ('påvise',),
'påviser': ('påvise',),
'påvises': ('påvise',),
'påvist': ('påvise',),
'påviste': ('påvise',),
'pæl': ('pæle',),
'pæla': ('pæle',),
'pæle': ('pæle',),
'pæler': ('pæle',),
'pæles': ('pæle',),
'pælet': ('pæle',),
'pælt': ('pæle',),
'pælte': ('pæle',),
'pæl': ('pæle',),
'pæla': ('pæle',),
'pæle': ('pæle',),
'pæler': ('pæle',),
'pæles': ('pæle',),
'pælet': ('pæle',),
'pælt': ('pæle',),
'pælte': ('pæle',),
'pælm': ('pælme',),
'pælma': ('pælme',),
'pælme': ('pælme',),
'pælmer': ('pælme',),
'pælmes': ('pælme',),
'pælmet': ('pælme',),
'pøbl': ('pøble',),
'pøbla': ('pøble',),
'pøble': ('pøble',),
'pøbler': ('pøble',),
'pøbles': ('pøble',),
'pøblet': ('pøble',),
'pøns': ('pønse',),
'pønsa': ('pønse',),
'pønse': ('pønse',),
'pønser': ('pønse',),
'pønses': ('pønse',),
'pønset': ('pønse',),
'pønsk': ('pønske',),
'pønska': ('pønske',),
'pønske': ('pønske',),
'pønsker': ('pønske',),
'pønskes': ('pønske',),
'pønsket': ('pønske',),
'pøs': ('pøse',),
'pøse': ('pøse',),
'pøser': ('pøse',),
'pøses': ('pøse',),
'pøst': ('pøse',),
'pøste': ('pøse',),
'rabatter': ('rabattere',),
'rabattere': ('rabattere',),
'rabatterer': ('rabattere',),
'rabatteres': ('rabattere',),
'rabattert': ('rabattere',),
'rabatterte': ('rabattere',),
'rabl': ('rable',),
'rabla': ('rable',),
'rable': ('rable',),
'rabler': ('rable',),
'rables': ('rable',),
'rablet': ('rable',),
'rabl': ('rable',),
'rabla': ('rable',),
'rable': ('rable',),
'rabler': ('rable',),
'rables': ('rable',),
'rablet': ('rable',),
'radbrekk': ('radbrekke',),
'radbrekka': ('radbrekke',),
'radbrekke': ('radbrekke',),
'radbrekker': ('radbrekke',),
'radbrekkes': ('radbrekke',),
'radbrekket': ('radbrekke',),
'radbrekt': ('radbrekke',),
'radbrekte': ('radbrekke',),
'rad': ('rade',),
'rada': ('rade',),
'rade': ('rade',),
'rader': ('rade',),
'rades': ('rade',),
'radet': ('rade',),
'rader': ('radere',),
'radere': ('radere',),
'raderer': ('radere',),
'raderes': ('radere',),
'radert': ('radere',),
'raderte': ('radere',),
'radier': ('radiere',),
'radiere': ('radiere',),
'radierer': ('radiere',),
'radieres': ('radiere',),
'radiert': ('radiere',),
'radierte': ('radiere',),
'radikaliser': ('radikalisere',),
'radikalisere': ('radikalisere',),
'radikaliserer': ('radikalisere',),
'radikaliseres': ('radikalisere',),
'radikalisert': ('radikalisere',),
'radikaliserte': ('radikalisere',),
'raffiner': ('raffinere',),
'raffinere': ('raffinere',),
'raffinerer': ('raffinere',),
'raffineres': ('raffinere',),
'raffinert': ('raffinere',),
'raffinerte': ('raffinere',),
'rafs': ('rafse',),
'rafsa': ('rafse',),
'rafse': ('rafse',),
'rafser': ('rafse',),
'rafses': ('rafse',),
'rafset': ('rafse',),
'raft': ('rafte',),
'rafta': ('rafte',),
'rafte': ('rafte',),
'rafter': ('rafte',),
'raftes': ('rafte',),
'raftet': ('rafte',),
'raft': ('rafte',),
'rafta': ('rafte',),
'rafte': ('rafte',),
'rafter': ('rafte',),
'raftes': ('rafte',),
'raftet': ('rafte',),
'rag': ('rage',),
'raga': ('rage',),
'rage': ('rage',),
'rager': ('rage',),
'rages': ('rage',),
'raget': ('rage',),
'rag': ('rage',),
'raga': ('rage',),
'rage': ('rage',),
'rager': ('rage',),
'rages': ('rage',),
'raget': ('rage',),
'rak': ('rake',),
'raka': ('rake',),
'rake': ('rake',),
'raker': ('rake',),
'rakes': ('rake',),
'raket': ('rake',),
'rak': ('rake',),
'raka': ('rake',),
'rake': ('rake',),
'raker': ('rake',),
'rakes': ('rake',),
'raket': ('rake',),
'rakt': ('rake',),
'rakte': ('rake',),
'rak': ('rake',),
'raka': ('rake',),
'rake': ('rake',),
'raker': ('rake',),
'rakes': ('rake',),
'raket': ('rake',),
'rakt': ('rake',),
'rakte': ('rake',),
'rakk': ('rakke',),
'rakka': ('rakke',),
'rakke': ('rakke',),
'rakker': ('rakke',),
'rakkes': ('rakke',),
'rakket': ('rakke',),
'rakl': ('rakle',),
'rakla': ('rakle',),
'rakle': ('rakle',),
'rakler': ('rakle',),
'rakles': ('rakle',),
'raklet': ('rakle',),
'rakl': ('rakle',),
'rakla': ('rakle',),
'rakle': ('rakle',),
'rakler': ('rakle',),
'rakles': ('rakle',),
'raklet': ('rakle',),
'rakn': ('rakne',),
'rakna': ('rakne',),
'rakne': ('rakne',),
'rakner': ('rakne',),
'raknes': ('rakne',),
'raknet': ('rakne',),
'raljer': ('raljere',),
'raljere': ('raljere',),
'raljerer': ('raljere',),
'raljeres': ('raljere',),
'raljert': ('raljere',),
'raljerte': ('raljere',),
'rall': ('ralle',),
'ralla': ('ralle',),
'ralle': ('ralle',),
'raller': ('ralle',),
'ralles': ('ralle',),
'rallet': ('ralle',),
'raml': ('ramle',),
'ramla': ('ramle',),
'ramle': ('ramle',),
'ramler': ('ramle',),
'ramles': ('ramle',),
'ramlet': ('ramle',),
'ram': ('ramme',),
'ramma': ('ramme',),
'ramme': ('ramme',),
'rammer': ('ramme',),
'rammes': ('ramme',),
'rammet': ('ramme',),
'ram': ('ramme',),
'ramma': ('ramme',),
'ramme': ('ramme',),
'rammer': ('ramme',),
'rammes': ('ramme',),
'rammet': ('ramme',),
'ram': ('ramme',),
'ramma': ('ramme',),
'ramme': ('ramme',),
'rammer': ('ramme',),
'rammes': ('ramme',),
'rammet': ('ramme',),
'ramponer': ('ramponere',),
'ramponere': ('ramponere',),
'ramponerer': ('ramponere',),
'ramponeres': ('ramponere',),
'ramponert': ('ramponere',),
'ramponerte': ('ramponere',),
'ramsalt': ('ramsalte',),
'ramsalta': ('ramsalte',),
'ramsalte': ('ramsalte',),
'ramsalter': ('ramsalte',),
'ramsaltes': ('ramsalte',),
'ramsaltet': ('ramsalte',),
'rams': ('ramse',),
'ramsa': ('ramse',),
'ramse': ('ramse',),
'ramser': ('ramse',),
'ramses': ('ramse',),
'ramset': ('ramse',),
'rand': ('rande',),
'randa': ('rande',),
'rande': ('rande',),
'rander': ('rande',),
'randes': ('rande',),
'randet': ('rande',),
'randsy': ('randsy',),
'randsydd': ('randsy',),
'randsydde': ('randsy',),
'randsyr': ('randsy',),
'randsys': ('randsy',),
'ran': ('rane',),
'rana': ('rane',),
'rane': ('rane',),
'raner': ('rane',),
'ranes': ('rane',),
'ranet': ('rane',),
'rant': ('rane',),
'rante': ('rane',),
'rang': ('range',),
'ranga': ('range',),
'range': ('range',),
'ranger': ('range',),
'ranges': ('range',),
'ranget': ('range',),
'ranger': ('rangere',),
'rangere': ('rangere',),
'rangerer': ('rangere',),
'rangeres': ('rangere',),
'rangert': ('rangere',),
'rangerte': ('rangere',),
'rangl': ('rangle',),
'rangla': ('rangle',),
'rangle': ('rangle',),
'rangler': ('rangle',),
'rangles': ('rangle',),
'ranglet': ('rangle',),
'rangl': ('rangle',),
'rangla': ('rangle',),
'rangle': ('rangle',),
'rangler': ('rangle',),
'rangles': ('rangle',),
'ranglet': ('rangle',),
'rank': ('ranke',),
'ranka': ('ranke',),
'ranke': ('ranke',),
'ranker': ('ranke',),
'rankes': ('ranke',),
'ranket': ('ranke',),
'rank': ('ranke',),
'ranka': ('ranke',),
'ranke': ('ranke',),
'ranker': ('ranke',),
'rankes': ('ranke',),
'ranket': ('ranke',),
'ransak': ('ransake',),
'ransaka': ('ransake',),
'ransake': ('ransake',),
'ransaker': ('ransake',),
'ransakes': ('ransake',),
'ransaket': ('ransake',),
'ransakt': ('ransake',),
'ransakte': ('ransake',),
'rap': ('rape',),
'rapa': ('rape',),
'rape': ('rape',),
'raper': ('rape',),
'rapes': ('rape',),
'rapet': ('rape',),
'rapt': ('rape',),
'rapte': ('rape',),
'rap': ('rape',),
'rapa': ('rape',),
'rape': ('rape',),
'raper': ('rape',),
'rapes': ('rape',),
'rapet': ('rape',),
'rapt': ('rape',),
'rapte': ('rape',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappa': ('rappe',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappet': ('rappe',),
'rappeller': ('rappellere',),
'rappellere': ('rappellere',),
'rappellerer': ('rappellere',),
'rappelleres': ('rappellere',),
'rappellert': ('rappellere',),
'rappellerte': ('rappellere',),
'rapporter': ('rapportere',),
'rapportere': ('rapportere',),
'rapporterer': ('rapportere',),
'rapporteres': ('rapportere',),
'rapportert': ('rapportere',),
'rapporterte': ('rapportere',),
'raps': ('rapse',),
'rapsa': ('rapse',),
'rapse': ('rapse',),
'rapser': ('rapse',),
'rapses': ('rapse',),
'rapset': ('rapse',),
'ras': ('rase',),
'rasa': ('rase',),
'rase': ('rase',),
'raser': ('rase',),
'rases': ('rase',),
'rast': ('rase',),
'raste': ('rase',),
'raser': ('rasere',),
'rasere': ('rasere',),
'raserer': ('rasere',),
'raseres': ('rasere',),
'rasert': ('rasere',),
'raserte': ('rasere',),
'rasjonaliser': ('rasjonalisere',),
'rasjonalisere': ('rasjonalisere',),
'rasjonaliserer': ('rasjonalisere',),
'rasjonaliseres': ('rasjonalisere',),
'rasjonalisert': ('rasjonalisere',),
'rasjonaliserte': ('rasjonalisere',),
'rasjoner': ('rasjonere',),
'rasjonere': ('rasjonere',),
'rasjonerer': ('rasjonere',),
'rasjoneres': ('rasjonere',),
'rasjonert': ('rasjonere',),
'rasjonerte': ('rasjonere',),
'rask': ('raske',),
'raska': ('raske',),
'raske': ('raske',),
'rasker': ('raske',),
'raskes': ('raske',),
'rasket': ('raske',),
'rask': ('raske',),
'raska': ('raske',),
'raske': ('raske',),
'rasker': ('raske',),
'raskes': ('raske',),
'rasket': ('raske',),
'rasl': ('rasle',),
'rasla': ('rasle',),
'rasle': ('rasle',),
'rasler': ('rasle',),
'rasles': ('rasle',),
'raslet': ('rasle',),
'rasp': ('raspe',),
'raspa': ('raspe',),
'raspe': ('raspe',),
'rasper': ('raspe',),
'raspes': ('raspe',),
'raspet': ('raspe',),
'rast': ('raste',),
'rasta': ('raste',),
'raste': ('raste',),
'raster': ('raste',),
'rastes': ('raste',),
'rastet': ('raste',),
'ratifiser': ('ratifisere',),
'ratifisere': ('ratifisere',),
'ratifiserer': ('ratifisere',),
'ratifiseres': ('ratifisere',),
'ratifisert': ('ratifisere',),
'ratifiserte': ('ratifisere',),
'ratl': ('ratle',),
'ratla': ('ratle',),
'ratle': ('ratle',),
'ratler': ('ratle',),
'ratles': ('ratle',),
'ratlet': ('ratle',),
'ratt': ('ratte',),
'ratta': ('ratte',),
'ratte': ('ratte',),
'ratter': ('ratte',),
'rattes': ('ratte',),
'rattet': ('ratte',),
'rauk': ('rauke',),
'rauka': ('rauke',),
'rauke': ('rauke',),
'rauker': ('rauke',),
'raukes': ('rauke',),
'rauket': ('rauke',),
'raus': ('rause',),
'rausa': ('rause',),
'rause': ('rause',),
'rauser': ('rause',),
'rauses': ('rause',),
'rauset': ('rause',),
'raust': ('rause',),
'rauste': ('rause',),
'raut': ('raute',),
'rauta': ('raute',),
'raute': ('raute',),
'rauter': ('raute',),
'rautes': ('raute',),
'rautet': ('raute',),
'rav': ('rave',),
'rava': ('rave',),
'rave': ('rave',),
'raver': ('rave',),
'raves': ('rave',),
'ravet': ('rave',),
're': ('re',),
'redd': ('re',),
'redde': ('re',),
'rer': ('re',),
'res': ('re',),
'reager': ('reagere',),
'reagere': ('reagere',),
'reagerer': ('reagere',),
'reageres': ('reagere',),
'reagert': ('reagere',),
'reagerte': ('reagere',),
'reaktiver': ('reaktivere',),
'reaktivere': ('reaktivere',),
'reaktiverer': ('reaktivere',),
'reaktiveres': ('reaktivere',),
'reaktivert': ('reaktivere',),
'reaktiverte': ('reaktivere',),
'realiser': ('realisere',),
'realisere': ('realisere',),
'realiserer': ('realisere',),
'realiseres': ('realisere',),
'realisert': ('realisere',),
'realiserte': ('realisere',),
'realitetsbehandl': ('realitetsbehandle',),
'realitetsbehandla': ('realitetsbehandle',),
'realitetsbehandle': ('realitetsbehandle',),
'realitetsbehandler': ('realitetsbehandle',),
'realitetsbehandles': ('realitetsbehandle',),
'realitetsbehandlet': ('realitetsbehandle',),
'reassurer': ('reassurere',),
'reassurere': ('reassurere',),
'reassurerer': ('reassurere',),
'reassureres': ('reassurere',),
'reassurert': ('reassurere',),
'reassurerte': ('reassurere',),
'rebeller': ('rebellere',),
'rebellere': ('rebellere',),
'rebellerer': ('rebellere',),
'rebelleres': ('rebellere',),
'rebellert': ('rebellere',),
'rebellerte': ('rebellere',),
'recenser': ('recensere',),
'recensere': ('recensere',),
'recenserer': ('recensere',),
'recenseres': ('recensere',),
'recensert': ('recensere',),
'recenserte': ('recensere',),
'redd': ('redde',),
'redda': ('redde',),
'redde': ('redde',),
'redder': ('redde',),
'reddes': ('redde',),
'reddet': ('redde',),
'red': ('rede',),
'reda': ('rede',),
'rede': ('rede',),
'reder': ('rede',),
'redes': ('rede',),
'redet': ('rede',),
'redegjorde': ('redegjøre',),
'redegjort': ('redegjøre',),
'redegjør': ('redegjøre',),
'redegjøre': ('redegjøre',),
'redegjøres': ('redegjøre',),
'rediger': ('redigere',),
'redigere': ('redigere',),
'redigerer': ('redigere',),
'redigeres': ('redigere',),
'redigert': ('redigere',),
'redigerte': ('redigere',),
'redobl': ('redoble',),
'redobla': ('redoble',),
'redoble': ('redoble',),
'redobler': ('redoble',),
'redobles': ('redoble',),
'redoblet': ('redoble',),
'redupliser': ('reduplisere',),
'reduplisere': ('reduplisere',),
'redupliserer': ('reduplisere',),
'redupliseres': ('reduplisere',),
'reduplisert': ('reduplisere',),
'redupliserte': ('reduplisere',),
'reduser': ('redusere',),
'redusere': ('redusere',),
'reduserer': ('redusere',),
'reduseres': ('redusere',),
'redusert': ('redusere',),
'reduserte': ('redusere',),
'referer': ('referere',),
'referere': ('referere',),
'refererer': ('referere',),
'refereres': ('referere',),
'referert': ('referere',),
'refererte': ('referere',),
'reflekter': ('reflektere',),
'reflektere': ('reflektere',),
'reflekterer': ('reflektere',),
'reflekteres': ('reflektere',),
'reflektert': ('reflektere',),
'reflekterte': ('reflektere',),
'reformer': ('reformere',),
'reformere': ('reformere',),
'reformerer': ('reformere',),
'reformeres': ('reformere',),
'reformert': ('reformere',),
'reformerte': ('reformere',),
'refs': ('refse',),
'refsa': ('refse',),
'refse': ('refse',),
'refser': ('refse',),
'refses': ('refse',),
'refset': ('refse',),
'refst': ('refse',),
'refste': ('refse',),
'refunder': ('refundere',),
'refundere': ('refundere',),
'refunderer': ('refundere',),
'refunderes': ('refundere',),
'refundert': ('refundere',),
'refunderte': ('refundere',),
'refuser': ('refusere',),
'refusere': ('refusere',),
'refuserer': ('refusere',),
'refuseres': ('refusere',),
'refusert': ('refusere',),
'refuserte': ('refusere',),
'regaler': ('regalere',),
'regalere': ('regalere',),
'regalerer': ('regalere',),
'regaleres': ('regalere',),
'regalert': ('regalere',),
'regalerte': ('regalere',),
'regenerer': ('regenerere',),
'regenerere': ('regenerere',),
'regenererer': ('regenerere',),
'regenereres': ('regenerere',),
'regenerert': ('regenerere',),
'regenererte': ('regenerere',),
'regisser': ('regissere',),
'regissere': ('regissere',),
'regisserer': ('regissere',),
'regisseres': ('regissere',),
'regissert': ('regissere',),
'regisserte': ('regissere',),
'registrer': ('registrere',),
'registrere': ('registrere',),
'registrerer': ('registrere',),
'registreres': ('registrere',),
'registrert': ('registrere',),
'registrerte': ('registrere',),
'regjer': ('regjere',),
'regjere': ('regjere',),
'regjerer': ('regjere',),
'regjeres': ('regjere',),
'regjert': ('regjere',),
'regjerte': ('regjere',),
'reglementer': ('reglementere',),
'reglementere': ('reglementere',),
'reglementerer': ('reglementere',),
'reglementeres': ('reglementere',),
'reglementert': ('reglementere',),
'reglementerte': ('reglementere',),
'regn': ('regne',),
'regna': ('regne',),
'regne': ('regne',),
'regner': ('regne',),
'regnes': ('regne',),
'regnet': ('regne',),
'regn': ('regne',),
'regna': ('regne',),
'regne': ('regne',),
'regner': ('regne',),
'regnes': ('regne',),
'regnet': ('regne',),
'regn': ('regne',),
'regna': ('regne',),
'regne': ('regne',),
'regner': ('regne',),
'regnes': ('regne',),
'regnet': ('regne',),
'regnt': ('regne',),
'regnte': ('regne',),
'regulariser': ('regularisere',),
'regularisere': ('regularisere',),
'regulariserer': ('regularisere',),
'regulariseres': ('regularisere',),
'regularisert': ('regularisere',),
'regulariserte': ('regularisere',),
'reguler': ('regulere',),
'regulere': ('regulere',),
'regulerer': ('regulere',),
'reguleres': ('regulere',),
'regulert': ('regulere',),
'regulerte': ('regulere',),
'regummier': ('regummiere',),
'regummiere': ('regummiere',),
'regummierer': ('regummiere',),
'regummieres': ('regummiere',),
'regummiert': ('regummiere',),
'regummierte': ('regummiere',),
'rehabiliter': ('rehabilitere',),
'rehabilitere': ('rehabilitere',),
'rehabiliterer': ('rehabilitere',),
'rehabiliteres': ('rehabilitere',),
'rehabilitert': ('rehabilitere',),
'rehabiliterte': ('rehabilitere',),
'rei': ('reie',),
'reid': ('reie',),
'reidd': ('reie',),
'reidde': ('reie',),
'reide': ('reie',),
'reie': ('reie',),
'reier': ('reie',),
'reies': ('reie',),
'reik': ('reike',),
'reika': ('reike',),
'reike': ('reike',),
'reiker': ('reike',),
'reikes': ('reike',),
'reiket': ('reike',),
'reikt': ('reike',),
'reikte': ('reike',),
'reindyrk': ('reindyrke',),
'reindyrka': ('reindyrke',),
'reindyrke': ('reindyrke',),
'reindyrker': ('reindyrke',),
'reindyrkes': ('reindyrke',),
'reindyrket': ('reindyrke',),
'reingjorde': ('reingjøre',),
'reingjort': ('reingjøre',),
'reingjør': ('reingjøre',),
'reingjøre': ('reingjøre',),
'reingjøres': ('reingjøre',),
'reinskreiv': ('reinskrive',),
'reinskrev': ('reinskrive',),
'reinskrevet': ('reinskrive',),
'reinskriv': ('reinskrive',),
'reinskrive': ('reinskrive',),
'reinskriver': ('reinskrive',),
'reinskrives': ('reinskrive',),
'reinvask': ('reinvaske',),
'reinvaska': ('reinvaske',),
'reinvaske': ('reinvaske',),
'reinvasker': ('reinvaske',),
'reinvaskes': ('reinvaske',),
'reinvasket': ('reinvaske',),
'reinvester': ('reinvestere',),
'reinvestere': ('reinvestere',),
'reinvesterer': ('reinvestere',),
'reinvesteres': ('reinvestere',),
'reinvestert': ('reinvestere',),
'reinvesterte': ('reinvestere',),
'reip': ('reipe',),
'reipa': ('reipe',),
'reipe': ('reipe',),
'reiper': ('reipe',),
'reipes': ('reipe',),
'reipet': ('reipe',),
'reis': ('reise',),
'reise': ('reise',),
'reiser': ('reise',),
'reises': ('reise',),
'reist': ('reise',),
'reiste': ('reise',),
'reis': ('reise',),
'reise': ('reise',),
'reiser': ('reise',),
'reises': ('reise',),
'reist': ('reise',),
'reiste': ('reise',),
'reiv': ('reive',),
'reiva': ('reive',),
'reivd': ('reive',),
'reivde': ('reive',),
'reive': ('reive',),
'reiver': ('reive',),
'reives': ('reive',),
'reivet': ('reive',),
'rejiser': ('rejisere',),
'rejisere': ('rejisere',),
'rejiserer': ('rejisere',),
'rejiseres': ('rejisere',),
'rejisert': ('rejisere',),
'rejiserte': ('rejisere',),
'rekapituler': ('rekapitulere',),
'rekapitulere': ('rekapitulere',),
'rekapitulerer': ('rekapitulere',),
'rekapituleres': ('rekapitulere',),
'rekapitulert': ('rekapitulere',),
'rekapitulerte': ('rekapitulere',),
'rak': ('reke',),
'rek': ('reke',),
'reke': ('reke',),
'reker': ('reke',),
'rekes': ('reke',),
'rekt': ('reke',),
'rekte': ('reke',),
'reklamer': ('reklamere',),
'reklamere': ('reklamere',),
'reklamerer': ('reklamere',),
'reklameres': ('reklamere',),
'reklamert': ('reklamere',),
'reklamerte': ('reklamere',),
'rekn': ('rekne',),
'rekna': ('rekne',),
'rekne': ('rekne',),
'rekner': ('rekne',),
'reknes': ('rekne',),
'reknet': ('rekne',),
'rekn': ('rekne',),
'rekna': ('rekne',),
'rekne': ('rekne',),
'rekner': ('rekne',),
'reknes': ('rekne',),
'reknet': ('rekne',),
'rekognoser': ('rekognosere',),
'rekognosere': ('rekognosere',),
'rekognoserer': ('rekognosere',),
'rekognoseres': ('rekognosere',),
'rekognosert': ('rekognosere',),
'rekognoserte': ('rekognosere',),
'rekommander': ('rekommandere',),
'rekommandere': ('rekommandere',),
'rekommanderer': ('rekommandere',),
'rekommanderes': ('rekommandere',),
'rekommandert': ('rekommandere',),
'rekommanderte': ('rekommandere',),
'rekonstruer': ('rekonstruere',),
'rekonstruere': ('rekonstruere',),
'rekonstruerer': ('rekonstruere',),
'rekonstrueres': ('rekonstruere',),
'rekonstruert': ('rekonstruere',),
'rekonstruerte': ('rekonstruere',),
'rekordforbedr': ('rekordforbedre',),
'rekordforbedra': ('rekordforbedre',),
'rekordforbedre': ('rekordforbedre',),
'rekordforbedrer': ('rekordforbedre',),
'rekordforbedres': ('rekordforbedre',),
'rekordforbedret': ('rekordforbedre',),
'rekreer': ('rekreere',),
'rekreere': ('rekreere',),
'rekreerer': ('rekreere',),
'rekreeres': ('rekreere',),
'rekreert': ('rekreere',),
'rekreerte': ('rekreere',),
'rekrutter': ('rekruttere',),
'rekruttere': ('rekruttere',),
'rekrutterer': ('rekruttere',),
'rekrutteres': ('rekruttere',),
'rekruttert': ('rekruttere',),
'rekrutterte': ('rekruttere',),
'rektifiser': ('rektifisere',),
'rektifisere': ('rektifisere',),
'rektifiserer': ('rektifisere',),
'rektifiseres': ('rektifisere',),
'rektifisert': ('rektifisere',),
'rektifiserte': ('rektifisere',),
'rekvirer': ('rekvirere',),
'rekvirere': ('rekvirere',),
'rekvirerer': ('rekvirere',),
'rekvireres': ('rekvirere',),
'rekvirert': ('rekvirere',),
'rekvirerte': ('rekvirere',),
'relater': ('relatere',),
'relatere': ('relatere',),
'relaterer': ('relatere',),
'relateres': ('relatere',),
'relatert': ('relatere',),
'relaterte': ('relatere',),
'relativiser': ('relativisere',),
'relativisere': ('relativisere',),
'relativiserer': ('relativisere',),
'relativiseres': ('relativisere',),
'relativisert': ('relativisere',),
'relativiserte': ('relativisere',),
'releger': ('relegere',),
'relegere': ('relegere',),
'relegerer': ('relegere',),
'relegeres': ('relegere',),
'relegert': ('relegere',),
'relegerte': ('relegere',),
'reloker': ('relokere',),
'relokere': ('relokere',),
'relokerer': ('relokere',),
'relokeres': ('relokere',),
'relokert': ('relokere',),
'relokerte': ('relokere',),
'remburser': ('rembursere',),
'rembursere': ('rembursere',),
'remburserer': ('rembursere',),
'remburseres': ('rembursere',),
'rembursert': ('rembursere',),
'remburserte': ('rembursere',),
'reminiser': ('reminisere',),
'reminisere': ('reminisere',),
'reminiserer': ('reminisere',),
'reminiseres': ('reminisere',),
'reminisert': ('reminisere',),
'reminiserte': ('reminisere',),
'remiser': ('remisere',),
'remisere': ('remisere',),
'remiserer': ('remisere',),
'remiseres': ('remisere',),
'remisert': ('remisere',),
'remiserte': ('remisere',),
'remitter': ('remittere',),
'remittere': ('remittere',),
'remitterer': ('remittere',),
'remitteres': ('remittere',),
'remittert': ('remittere',),
'remitterte': ('remittere',),
'remj': ('remje',),
'remja': ('remje',),
'remje': ('remje',),
'remjer': ('remje',),
'remjes': ('remje',),
'remjet': ('remje',),
'remonter': ('remontere',),
'remontere': ('remontere',),
'remonterer': ('remontere',),
'remonteres': ('remontere',),
'remontert': ('remontere',),
'remonterte': ('remontere',),
'remplasser': ('remplassere',),
'remplassere': ('remplassere',),
'remplasserer': ('remplassere',),
'remplasseres': ('remplassere',),
'remplassert': ('remplassere',),
'remplasserte': ('remplassere',),
'rems': ('remse',),
'remsa': ('remse',),
'remse': ('remse',),
'remser': ('remse',),
'remses': ('remse',),
'remset': ('remse',),
'rendyrk': ('rendyrke',),
'rendyrka': ('rendyrke',),
'rendyrke': ('rendyrke',),
'rendyrker': ('rendyrke',),
'rendyrkes': ('rendyrke',),
'rendyrket': ('rendyrke',),
'rengjorde': ('rengjøre',),
'rengjort': ('rengjøre',),
'rengjør': ('rengjøre',),
'rengjøre': ('rengjøre',),
'rengjøres': ('rengjøre',),
'renonser': ('renonsere',),
'renonsere': ('renonsere',),
'renonserer': ('renonsere',),
'renonseres': ('renonsere',),
'renonsert': ('renonsere',),
'renonserte': ('renonsere',),
'renover': ('renovere',),
'renovere': ('renovere',),
'renoverer': ('renovere',),
'renoveres': ('renovere',),
'renovert': ('renovere',),
'renoverte': ('renovere',),
'rens': ('rense',),
'rensa': ('rense',),
'rense': ('rense',),
'renser': ('rense',),
'renses': ('rense',),
'renset': ('rense',),
'rensk': ('renske',),
'renska': ('renske',),
'renske': ('renske',),
'rensker': ('renske',),
'renskes': ('renske',),
'rensket': ('renske',),
'renskreiv': ('renskrive',),
'renskrev': ('renskrive',),
'renskrevet': ('renskrive',),
'renskriv': ('renskrive',),
'renskrive': ('renskrive',),
'renskriver': ('renskrive',),
'renskrives': ('renskrive',),
'renvask': ('renvaske',),
'renvaska': ('renvaske',),
'renvaske': ('renvaske',),
'renvasker': ('renvaske',),
'renvaskes': ('renvaske',),
'renvasket': ('renvaske',),
'reorganiser': ('reorganisere',),
'reorganisere': ('reorganisere',),
'reorganiserer': ('reorganisere',),
'reorganiseres': ('reorganisere',),
'reorganisert': ('reorganisere',),
'reorganiserte': ('reorganisere',),
'reparer': ('reparere',),
'reparere': ('reparere',),
'reparerer': ('reparere',),
'repareres': ('reparere',),
'reparert': ('reparere',),
'reparerte': ('reparere',),
'repatrier': ('repatriere',),
'repatriere': ('repatriere',),
'repatrierer': ('repatriere',),
'repatrieres': ('repatriere',),
'repatriert': ('repatriere',),
'repatrierte': ('repatriere',),
'repeter': ('repetere',),
'repetere': ('repetere',),
'repeterer': ('repetere',),
'repeteres': ('repetere',),
'repetert': ('repetere',),
'repeterte': ('repetere',),
'repliser': ('replisere',),
'replisere': ('replisere',),
'repliserer': ('replisere',),
'repliseres': ('replisere',),
'replisert': ('replisere',),
'repliserte': ('replisere',),
'representer': ('representere',),
'representere': ('representere',),
'representerer': ('representere',),
'representeres': ('representere',),
'representert': ('representere',),
'representerte': ('representere',),
'reproduser': ('reprodusere',),
'reprodusere': ('reprodusere',),
'reproduserer': ('reprodusere',),
'reproduseres': ('reprodusere',),
'reprodusert': ('reprodusere',),
'reproduserte': ('reprodusere',),
'reserver': ('reservere',),
'reservere': ('reservere',),
'reserverer': ('reservere',),
'reserveres': ('reservere',),
'reservert': ('reservere',),
'reserverte': ('reservere',),
'resider': ('residere',),
'residere': ('residere',),
'residerer': ('residere',),
'resideres': ('residere',),
'residert': ('residere',),
'residerte': ('residere',),
'residiver': ('residivere',),
'residivere': ('residivere',),
'residiverer': ('residivere',),
'residiveres': ('residivere',),
'residivert': ('residivere',),
'residiverte': ('residivere',),
'resigner': ('resignere',),
'resignere': ('resignere',),
'resignerer': ('resignere',),
'resigneres': ('resignere',),
'resignert': ('resignere',),
'resignerte': ('resignere',),
'resiper': ('resipere',),
'resipere': ('resipere',),
'resiperer': ('resipere',),
'resiperes': ('resipere',),
'resipert': ('resipere',),
'resiperte': ('resipere',),
'resirkuler': ('resirkulere',),
'resirkulere': ('resirkulere',),
'resirkulerer': ('resirkulere',),
'resirkuleres': ('resirkulere',),
'resirkulert': ('resirkulere',),
'resirkulerte': ('resirkulere',),
'resister': ('resistere',),
'resistere': ('resistere',),
'resisterer': ('resistere',),
'resisteres': ('resistere',),
'resistert': ('resistere',),
'resisterte': ('resistere',),
'resiter': ('resitere',),
'resitere': ('resitere',),
'resiterer': ('resitere',),
'resiteres': ('resitere',),
'resitert': ('resitere',),
'resiterte': ('resitere',),
'resolver': ('resolvere',),
'resolvere': ('resolvere',),
'resolverer': ('resolvere',),
'resolveres': ('resolvere',),
'resolvert': ('resolvere',),
'resolverte': ('resolvere',),
'resonner': ('resonnere',),
'resonnere': ('resonnere',),
'resonnerer': ('resonnere',),
'resonneres': ('resonnere',),
'resonnert': ('resonnere',),
'resonnerte': ('resonnere',),
'resorber': ('resorbere',),
'resorbere': ('resorbere',),
'resorberer': ('resorbere',),
'resorberes': ('resorbere',),
'resorbert': ('resorbere',),
'resorberte': ('resorbere',),
'resosialiser': ('resosialisere',),
'resosialisere': ('resosialisere',),
'resosialiserer': ('resosialisere',),
'resosialiseres': ('resosialisere',),
'resosialisert': ('resosialisere',),
'resosialiserte': ('resosialisere',),
'respekter': ('respektere',),
'respektere': ('respektere',),
'respekterer': ('respektere',),
'respekteres': ('respektere',),
'respektert': ('respektere',),
'respekterte': ('respektere',),
'respirer': ('respirere',),
'respirere': ('respirere',),
'respirerer': ('respirere',),
'respireres': ('respirere',),
'respirert': ('respirere',),
'respirerte': ('respirere',),
'responder': ('respondere',),
'respondere': ('respondere',),
'responderer': ('respondere',),
'responderes': ('respondere',),
'respondert': ('respondere',),
'responderte': ('respondere',),
'restaurer': ('restaurere',),
'restaurere': ('restaurere',),
'restaurerer': ('restaurere',),
'restaureres': ('restaurere',),
'restaurert': ('restaurere',),
'restaurerte': ('restaurere',),
'rester': ('restere',),
'restere': ('restere',),
'resterer': ('restere',),
'resteres': ('restere',),
'restert': ('restere',),
'resterte': ('restere',),
'restituer': ('restituere',),
'restituere': ('restituere',),
'restituerer': ('restituere',),
'restitueres': ('restituere',),
'restituert': ('restituere',),
'restituerte': ('restituere',),
'resulter': ('resultere',),
'resultere': ('resultere',),
'resulterer': ('resultere',),
'resulteres': ('resultere',),
'resultert': ('resultere',),
'resulterte': ('resultere',),
'resymer': ('resymere',),
'resymere': ('resymere',),
'resymerer': ('resymere',),
'resymeres': ('resymere',),
'resymert': ('resymere',),
'resymerte': ('resymere',),
'retarder': ('retardere',),
'retardere': ('retardere',),
'retarderer': ('retardere',),
'retarderes': ('retardere',),
'retardert': ('retardere',),
'retarderte': ('retardere',),
'retiner': ('retinere',),
'retinere': ('retinere',),
'retinerer': ('retinere',),
'retineres': ('retinere',),
'retinert': ('retinere',),
'retinerte': ('retinere',),
'retirer': ('retirere',),
'retirere': ('retirere',),
'retirerer': ('retirere',),
'retireres': ('retirere',),
'retirert': ('retirere',),
'retirerte': ('retirere',),
'rett': ('rette',),
'retta': ('rette',),
'rette': ('rette',),
'retter': ('rette',),
'rettes': ('rette',),
'rettet': ('rette',),
'rettferdiggjorde': ('rettferdiggjøre',),
'rettferdiggjort': ('rettferdiggjøre',),
'rettferdiggjør': ('rettferdiggjøre',),
'rettferdiggjøre': ('rettferdiggjøre',),
'rettferdiggjøres': ('rettferdiggjøre',),
'rettkjenn': ('rettkjenne',),
'rettkjenne': ('rettkjenne',),
'rettkjenner': ('rettkjenne',),
'rettkjennes': ('rettkjenne',),
'rettkjent': ('rettkjenne',),
'rettkjente': ('rettkjenne',),
'rettled': ('rettlede',),
'rettleda': ('rettlede',),
'rettlede': ('rettlede',),
'rettleder': ('rettlede',),
'rettledes': ('rettlede',),
'rettledet': ('rettlede',),
'rettlei': ('rettleie',),
'rettleid': ('rettleie',),
'rettleide': ('rettleie',),
'rettleie': ('rettleie',),
'rettleier': ('rettleie',),
'rettleies': ('rettleie',),
'rettleiet': ('rettleie',),
'returner': ('returnere',),
'returnere': ('returnere',),
'returnerer': ('returnere',),
'returneres': ('returnere',),
'returnert': ('returnere',),
'returnerte': ('returnere',),
'retusjer': ('retusjere',),
'retusjere': ('retusjere',),
'retusjerer': ('retusjere',),
'retusjeres': ('retusjere',),
'retusjert': ('retusjere',),
'retusjerte': ('retusjere',),
'revaluer': ('revaluere',),
'revaluere': ('revaluere',),
'revaluerer': ('revaluere',),
'revalueres': ('revaluere',),
'revaluert': ('revaluere',),
'revaluerte': ('revaluere',),
'revansjer': ('revansjere',),
'revansjere': ('revansjere',),
'revansjerer': ('revansjere',),
'revansjeres': ('revansjere',),
'revansjert': ('revansjere',),
'revansjerte': ('revansjere',),
'rev': ('reve',),
'reva': ('reve',),
'revd': ('reve',),
'revde': ('reve',),
'reve': ('reve',),
'rever': ('reve',),
'reves': ('reve',),
'revet': ('reve',),
'reverser': ('reversere',),
'reversere': ('reversere',),
'reverserer': ('reversere',),
'reverseres': ('reversere',),
'reversert': ('reversere',),
'reverserte': ('reversere',),
'revider': ('revidere',),
'revidere': ('revidere',),
'reviderer': ('revidere',),
'revideres': ('revidere',),
'revidert': ('revidere',),
'reviderte': ('revidere',),
'revn': ('revne',),
'revna': ('revne',),
'revne': ('revne',),
'revner': ('revne',),
'revnes': ('revne',),
'revnet': ('revne',),
'revn': ('revne',),
'revna': ('revne',),
'revne': ('revne',),
'revner': ('revne',),
'revnes': ('revne',),
'revnet': ('revne',),
'revolter': ('revoltere',),
'revoltere': ('revoltere',),
'revolterer': ('revoltere',),
'revolteres': ('revoltere',),
'revoltert': ('revoltere',),
'revolterte': ('revoltere',),
'revolusjoner': ('revolusjonere',),
'revolusjonere': ('revolusjonere',),
'revolusjonerer': ('revolusjonere',),
'revolusjoneres': ('revolusjonere',),
'revolusjonert': ('revolusjonere',),
'revolusjonerte': ('revolusjonere',),
'red': ('ri',),
'rei': ('ri',),
'reid': ('ri',),
'ri': ('ri',),
'ridd': ('ri',),
'rir': ('ri',),
'ris': ('ri',),
'ribb': ('ribbe',),
'ribba': ('ribbe',),
'ribbe': ('ribbe',),
'ribber': ('ribbe',),
'ribbes': ('ribbe',),
'ribbet': ('ribbe',),
'red': ('ride',),
'rei': ('ride',),
'reid': ('ride',),
'rid': ('ride',),
'ridd': ('ride',),
'ride': ('ride',),
'rider': ('ride',),
'rides': ('ride',),
'rifl': ('rifle',),
'rifla': ('rifle',),
'rifle': ('rifle',),
'rifler': ('rifle',),
'rifles': ('rifle',),
'riflet': ('rifle',),
'rigg': ('rigge',),
'rigga': ('rigge',),
'rigge': ('rigge',),
'rigger': ('rigge',),
'rigges': ('rigge',),
'rigget': ('rigge',),
'rikk': ('rikke',),
'rikka': ('rikke',),
'rikke': ('rikke',),
'rikker': ('rikke',),
'rikkes': ('rikke',),
'rikket': ('rikke',),
'rikl': ('rikle',),
'rikla': ('rikle',),
'rikle': ('rikle',),
'rikler': ('rikle',),
'rikles': ('rikle',),
'riklet': ('rikle',),
'rikosjetter': ('rikosjettere',),
'rikosjettere': ('rikosjettere',),
'rikosjetterer': ('rikosjettere',),
'rikosjetteres': ('rikosjettere',),
'rikosjettert': ('rikosjettere',),
'rikosjetterte': ('rikosjettere',),
'riks': ('rikse',),
'riksa': ('rikse',),
'rikse': ('rikse',),
'rikser': ('rikse',),
'rikses': ('rikse',),
'rikset': ('rikse',),
'rikt': ('rikte',),
'rikta': ('rikte',),
'rikte': ('rikte',),
'rikter': ('rikte',),
'riktes': ('rikte',),
'riktet': ('rikte',),
'rim': ('rime',),
'rima': ('rime',),
'rime': ('rime',),
'rimer': ('rime',),
'rimes': ('rime',),
'rimet': ('rime',),
'rim': ('rime',),
'rima': ('rime',),
'rime': ('rime',),
'rimer': ('rime',),
'rimes': ('rime',),
'rimet': ('rime',),
'rimt': ('rime',),
'rimte': ('rime',),
'rin': ('rine',),
'rine': ('rine',),
'riner': ('rine',),
'rines': ('rine',),
'rint': ('rine',),
'rinte': ('rine',),
'ring': ('ringe',),
'ringa': ('ringe',),
'ringe': ('ringe',),
'ringer': ('ringe',),
'ringes': ('ringe',),
'ringet': ('ringe',),
'ring': ('ringe',),
'ringe': ('ringe',),
'ringer': ('ringe',),
'ringes': ('ringe',),
'ringt': ('ringe',),
'ringte': ('ringe',),
'ringeakt': ('ringeakte',),
'ringeakta': ('ringeakte',),
'ringeakte': ('ringeakte',),
'ringeakter': ('ringeakte',),
'ringeaktes': ('ringeakte',),
'ringeaktet': ('ringeakte',),
'ringl': ('ringle',),
'ringla': ('ringle',),
'ringle': ('ringle',),
'ringler': ('ringle',),
'ringles': ('ringle',),
'ringlet': ('ringle',),
'ringl': ('ringle',),
'ringla': ('ringle',),
'ringle': ('ringle',),
'ringler': ('ringle',),
'ringles': ('ringle',),
'ringlet': ('ringle',),
'ringmerk': ('ringmerke',),
'ringmerka': ('ringmerke',),
'ringmerke': ('ringmerke',),
'ringmerker': ('ringmerke',),
'ringmerkes': ('ringmerke',),
'ringmerket': ('ringmerke',),
'rant': ('rinne',),
'rinn': ('rinne',),
'rinne': ('rinne',),
'rinner': ('rinne',),
'rinnes': ('rinne',),
'runnet': ('rinne',),
'rip': ('ripe',),
'ripa': ('ripe',),
'ripe': ('ripe',),
'riper': ('ripe',),
'ripes': ('ripe',),
'ripet': ('ripe',),
'ript': ('ripe',),
'ripte': ('ripe',),
'riposter': ('ripostere',),
'ripostere': ('ripostere',),
'riposterer': ('ripostere',),
'riposteres': ('ripostere',),
'ripostert': ('ripostere',),
'riposterte': ('ripostere',),
'ripp': ('rippe',),
'rippa': ('rippe',),
'rippe': ('rippe',),
'ripper': ('rippe',),
'rippes': ('rippe',),
'rippet': ('rippe',),
'ris': ('rise',),
'rise': ('rise',),
'riser': ('rise',),
'rises': ('rise',),
'rist': ('rise',),
'riste': ('rise',),
'risiker': ('risikere',),
'risikere': ('risikere',),
'risikerer': ('risikere',),
'risikeres': ('risikere',),
'risikert': ('risikere',),
'risikerte': ('risikere',),
'risl': ('risle',),
'risla': ('risle',),
'risle': ('risle',),
'risler': ('risle',),
'risles': ('risle',),
'rislet': ('risle',),
'risp': ('rispe',),
'rispa': ('rispe',),
'rispe': ('rispe',),
'risper': ('rispe',),
'rispes': ('rispe',),
'rispet': ('rispe',),
'riss': ('risse',),
'rissa': ('risse',),
'risse': ('risse',),
'risser': ('risse',),
'risses': ('risse',),
'risset': ('risse',),
'rist': ('riste',),
'rista': ('riste',),
'riste': ('riste',),
'rister': ('riste',),
'ristes': ('riste',),
'ristet': ('riste',),
'rist': ('riste',),
'rista': ('riste',),
'riste': ('riste',),
'rister': ('riste',),
'ristes': ('riste',),
'ristet': ('riste',),
'rist': ('riste',),
'rista': ('riste',),
'riste': ('riste',),
'rister': ('riste',),
'ristes': ('riste',),
'ristet': ('riste',),
'ristorner': ('ristornere',),
'ristornere': ('ristornere',),
'ristornerer': ('ristornere',),
'ristorneres': ('ristornere',),
'ristornert': ('ristornere',),
'ristornerte': ('ristornere',),
'rit': ('rite',),
'rita': ('rite',),
'rite': ('rite',),
'riter': ('rite',),
'rites': ('rite',),
'ritet': ('rite',),
'ritualiser': ('ritualisere',),
'ritualisere': ('ritualisere',),
'ritualiserer': ('ritualisere',),
'ritualiseres': ('ritualisere',),
'ritualisert': ('ritualisere',),
'ritualiserte': ('ritualisere',),
'rivaliser': ('rivalisere',),
'rivalisere': ('rivalisere',),
'rivaliserer': ('rivalisere',),
'rivaliseres': ('rivalisere',),
'rivalisert': ('rivalisere',),
'rivaliserte': ('rivalisere',),
'reiv': ('rive',),
'rev': ('rive',),
'revet': ('rive',),
'riv': ('rive',),
'rive': ('rive',),
'river': ('rive',),
'rives': ('rive',),
'reiv': ('rive',),
'rev': ('rive',),
'revet': ('rive',),
'riv': ('rive',),
'rive': ('rive',),
'river': ('rive',),
'rives': ('rive',),
'rivn': ('rivne',),
'rivna': ('rivne',),
'rivne': ('rivne',),
'rivner': ('rivne',),
'rivnes': ('rivne',),
'rivnet': ('rivne',),
'rivn': ('rivne',),
'rivna': ('rivne',),
'rivne': ('rivne',),
'rivner': ('rivne',),
'rivnes': ('rivne',),
'rivnet': ('rivne',),
'ro': ('ro',),
'rodd': ('ro',),
'rodde': ('ro',),
'ror': ('ro',),
'ros': ('ro',),
'robb': ('robbe',),
'robba': ('robbe',),
'robbe': ('robbe',),
'robber': ('robbe',),
'robbes': ('robbe',),
'robbet': ('robbe',),
'robotiser': ('robotisere',),
'robotisere': ('robotisere',),
'robotiserer': ('robotisere',),
'robotiseres': ('robotisere',),
'robotisert': ('robotisere',),
'robotiserte': ('robotisere',),
'rock': ('rocke',),
'rocka': ('rocke',),
'rocke': ('rocke',),
'rocker': ('rocke',),
'rockes': ('rocke',),
'rocket': ('rocke',),
'ro': ('roe',),
'roa': ('roe',),
'roe': ('roe',),
'roer': ('roe',),
'roes': ('roe',),
'roet': ('roe',),
'roker': ('rokere',),
'rokere': ('rokere',),
'rokerer': ('rokere',),
'rokeres': ('rokere',),
'rokert': ('rokere',),
'rokerte': ('rokere',),
'rokk': ('rokke',),
'rokka': ('rokke',),
'rokke': ('rokke',),
'rokker': ('rokke',),
'rokkes': ('rokke',),
'rokket': ('rokke',),
'roll': ('rolle',),
'rolla': ('rolle',),
'rolle': ('rolle',),
'roller': ('rolle',),
'rolles': ('rolle',),
'rollet': ('rolle',),
'romaniser': ('romanisere',),
'romanisere': ('romanisere',),
'romaniserer': ('romanisere',),
'romaniseres': ('romanisere',),
'romanisert': ('romanisere',),
'romaniserte': ('romanisere',),
'romantiser': ('romantisere',),
'romantisere': ('romantisere',),
'romantiserer': ('romantisere',),
'romantiseres': ('romantisere',),
'romantisert': ('romantisere',),
'romantiserte': ('romantisere',),
'rom': ('romme',),
'romma': ('romme',),
'romme': ('romme',),
'rommer': ('romme',),
'rommes': ('romme',),
'rommet': ('romme',),
'romster': ('romstere',),
'romstere': ('romstere',),
'romsterer': ('romstere',),
'romsteres': ('romstere',),
'romstert': ('romstere',),
'romsterte': ('romstere',),
'rop': ('rope',),
'rope': ('rope',),
'roper': ('rope',),
'ropes': ('rope',),
'ropt': ('rope',),
'ropte': ('rope',),
'ros': ('rose',),
'rose': ('rose',),
'roser': ('rose',),
'roses': ('rose',),
'rost': ('rose',),
'roste': ('rose',),
'rosemal': ('rosemale',),
'rosemale': ('rosemale',),
'rosemaler': ('rosemale',),
'rosemales': ('rosemale',),
'rosemalt': ('rosemale',),
'rosemalte': ('rosemale',),
'rost': ('roste',),
'rosta': ('roste',),
'roste': ('roste',),
'roster': ('roste',),
'rostes': ('roste',),
'rostet': ('roste',),
'rost': ('roste',),
'rosta': ('roste',),
'roste': ('roste',),
'roster': ('roste',),
'rostes': ('roste',),
'rostet': ('roste',),
'rot': ('rote',),
'rota': ('rote',),
'rote': ('rote',),
'roter': ('rote',),
'rotes': ('rote',),
'rotet': ('rote',),
'rot': ('rote',),
'rota': ('rote',),
'rote': ('rote',),
'roter': ('rote',),
'rotes': ('rote',),
'rotet': ('rote',),
'roter': ('rotere',),
'rotere': ('rotere',),
'roterer': ('rotere',),
'roteres': ('rotere',),
'rotert': ('rotere',),
'roterte': ('rotere',),
'rotfest': ('rotfeste',),
'rotfesta': ('rotfeste',),
'rotfeste': ('rotfeste',),
'rotfester': ('rotfeste',),
'rotfestes': ('rotfeste',),
'rotfestet': ('rotfeste',),
'rotfyll': ('rotfylle',),
'rotfylle': ('rotfylle',),
'rotfyller': ('rotfylle',),
'rotfylles': ('rotfylle',),
'rotfylt': ('rotfylle',),
'rotfylte': ('rotfylle',),
'rott': ('rotte',),
'rotta': ('rotte',),
'rotte': ('rotte',),
'rotter': ('rotte',),
'rottes': ('rotte',),
'rottet': ('rotte',),
'rubb': ('rubbe',),
'rubba': ('rubbe',),
'rubbe': ('rubbe',),
'rubber': ('rubbe',),
'rubbes': ('rubbe',),
'rubbet': ('rubbe',),
'rubriser': ('rubrisere',),
'rubrisere': ('rubrisere',),
'rubriserer': ('rubrisere',),
'rubriseres': ('rubrisere',),
'rubrisert': ('rubrisere',),
'rubriserte': ('rubrisere',),
'rufs': ('rufse',),
'rufsa': ('rufse',),
'rufse': ('rufse',),
'rufser': ('rufse',),
'rufses': ('rufse',),
'rufset': ('rufse',),
'rug': ('ruge',),
'ruga': ('ruge',),
'ruge': ('ruge',),
'ruger': ('ruge',),
'ruges': ('ruge',),
'ruget': ('ruge',),
'rugg': ('rugge',),
'rugga': ('rugge',),
'rugge': ('rugge',),
'rugger': ('rugge',),
'rugges': ('rugge',),
'rugget': ('rugge',),
'rugl': ('rugle',),
'rugla': ('rugle',),
'rugle': ('rugle',),
'rugler': ('rugle',),
'rugles': ('rugle',),
'ruglet': ('rugle',),
'ruiner': ('ruinere',),
'ruinere': ('ruinere',),
'ruinerer': ('ruinere',),
'ruineres': ('ruinere',),
'ruinert': ('ruinere',),
'ruinerte': ('ruinere',),
'rukk': ('rukke',),
'rukka': ('rukke',),
'rukke': ('rukke',),
'rukker': ('rukke',),
'rukkes': ('rukke',),
'rukket': ('rukke',),
'rull': ('rulle',),
'rulla': ('rulle',),
'rulle': ('rulle',),
'ruller': ('rulle',),
'rulles': ('rulle',),
'rullet': ('rulle',),
'rullefør': ('rulleføre',),
'rulleføre': ('rulleføre',),
'rullefører': ('rulleføre',),
'rulleføres': ('rulleføre',),
'rulleført': ('rulleføre',),
'rulleførte': ('rulleføre',),
'ruller': ('rullere',),
'rullere': ('rullere',),
'rullerer': ('rullere',),
'rulleres': ('rullere',),
'rullert': ('rullere',),
'rullerte': ('rullere',),
'rult': ('rulte',),
'rulta': ('rulte',),
'rulte': ('rulte',),
'rulter': ('rulte',),
'rultes': ('rulte',),
'rultet': ('rulte',),
'ruml': ('rumle',),
'rumla': ('rumle',),
'rumle': ('rumle',),
'rumler': ('rumle',),
'rumles': ('rumle',),
'rumlet': ('rumle',),
'rund': ('runde',),
'runda': ('runde',),
'runde': ('runde',),
'runder': ('runde',),
'rundes': ('runde',),
'rundet': ('runde',),
'rundjul': ('rundjule',),
'rundjule': ('rundjule',),
'rundjuler': ('rundjule',),
'rundjules': ('rundjule',),
'rundjult': ('rundjule',),
'rundjulte': ('rundjule',),
'rundstal': ('rundstele',),
'rundstel': ('rundstele',),
'rundstele': ('rundstele',),
'rundsteler': ('rundstele',),
'rundsteles': ('rundstele',),
'rundstålet': ('rundstele',),
'rundstjal': ('rundstjele',),
'rundstjel': ('rundstjele',),
'rundstjele': ('rundstjele',),
'rundstjeler': ('rundstjele',),
'rundstjeles': ('rundstjele',),
'rundstjålet': ('rundstjele',),
'rundvask': ('rundvaske',),
'rundvaska': ('rundvaske',),
'rundvaske': ('rundvaske',),
'rundvasker': ('rundvaske',),
'rundvaskes': ('rundvaske',),
'rundvasket': ('rundvaske',),
'run': ('rune',),
'runa': ('rune',),
'rune': ('rune',),
'runer': ('rune',),
'runes': ('rune',),
'runet': ('rune',),
'rung': ('runge',),
'runga': ('runge',),
'runge': ('runge',),
'runger': ('runge',),
'runges': ('runge',),
'runget': ('runge',),
'runk': ('runke',),
'runka': ('runke',),
'runke': ('runke',),
'runker': ('runke',),
'runkes': ('runke',),
'runket': ('runke',),
'rus': ('ruse',),
'rusa': ('ruse',),
'ruse': ('ruse',),
'ruser': ('ruse',),
'ruses': ('ruse',),
'ruset': ('ruse',),
'rus': ('ruse',),
'rusa': ('ruse',),
'ruse': ('ruse',),
'ruser': ('ruse',),
'ruses': ('ruse',),
'ruset': ('ruse',),
'rust': ('ruse',),
'ruste': ('ruse',),
'rush': ('rushe',),
'rusha': ('rushe',),
'rushe': ('rushe',),
'rusher': ('rushe',),
'rushes': ('rushe',),
'rushet': ('rushe',),
'rusk': ('ruske',),
'ruska': ('ruske',),
'ruske': ('ruske',),
'rusker': ('ruske',),
'ruskes': ('ruske',),
'rusket': ('ruske',),
'rusk': ('ruske',),
'ruska': ('ruske',),
'ruske': ('ruske',),
'rusker': ('ruske',),
'ruskes': ('ruske',),
'rusket': ('ruske',),
'rusl': ('rusle',),
'rusla': ('rusle',),
'rusle': ('rusle',),
'rusler': ('rusle',),
'rusles': ('rusle',),
'ruslet': ('rusle',),
'rusl': ('rusle',),
'rusla': ('rusle',),
'rusle': ('rusle',),
'rusler': ('rusle',),
'rusles': ('rusle',),
'ruslet': ('rusle',),
'russifiser': ('russifisere',),
'russifisere': ('russifisere',),
'russifiserer': ('russifisere',),
'russifiseres': ('russifisere',),
'russifisert': ('russifisere',),
'russifiserte': ('russifisere',),
'rustbehandl': ('rustbehandle',),
'rustbehandla': ('rustbehandle',),
'rustbehandle': ('rustbehandle',),
'rustbehandler': ('rustbehandle',),
'rustbehandles': ('rustbehandle',),
'rustbehandlet': ('rustbehandle',),
'rust': ('ruste',),
'rusta': ('ruste',),
'ruste': ('ruste',),
'ruster': ('ruste',),
'rustes': ('ruste',),
'rustet': ('ruste',),
'rust': ('ruste',),
'rusta': ('ruste',),
'ruste': ('ruste',),
'ruster': ('ruste',),
'rustes': ('ruste',),
'rustet': ('ruste',),
'rustifiser': ('rustifisere',),
'rustifisere': ('rustifisere',),
'rustifiserer': ('rustifisere',),
'rustifiseres': ('rustifisere',),
'rustifisert': ('rustifisere',),
'rustifiserte': ('rustifisere',),
'rustn': ('rustne',),
'rustna': ('rustne',),
'rustne': ('rustne',),
'rustner': ('rustne',),
'rustnes': ('rustne',),
'rustnet': ('rustne',),
'rut': ('rute',),
'ruta': ('rute',),
'rute': ('rute',),
'ruter': ('rute',),
'rutes': ('rute',),
'rutet': ('rute',),
'rutl': ('rutle',),
'rutla': ('rutle',),
'rutle': ('rutle',),
'rutler': ('rutle',),
'rutles': ('rutle',),
'rutlet': ('rutle',),
'rutsj': ('rutsje',),
'rutsja': ('rutsje',),
'rutsje': ('rutsje',),
'rutsjer': ('rutsje',),
'rutsjes': ('rutsje',),
'rutsjet': ('rutsje',),
'rutt': ('rutte',),
'rutta': ('rutte',),
'rutte': ('rutte',),
'rutter': ('rutte',),
'ruttes': ('rutte',),
'ruttet': ('rutte',),
'ruv': ('ruve',),
'ruva': ('ruve',),
'ruvd': ('ruve',),
'ruvde': ('ruve',),
'ruve': ('ruve',),
'ruver': ('ruve',),
'ruves': ('ruve',),
'ruvet': ('ruve',),
'ry': ('ry',),
'rydd': ('ry',),
'rydde': ('ry',),
'ryr': ('ry',),
'rys': ('ry',),
'rydd': ('rydde',),
'rydda': ('rydde',),
'rydde': ('rydde',),
'rydder': ('rydde',),
'ryddes': ('rydde',),
'ryddet': ('rydde',),
'rygg': ('rygge',),
'rygga': ('rygge',),
'rygge': ('rygge',),
'rygger': ('rygge',),
'rygges': ('rygge',),
'rygget': ('rygge',),
'rauk': ('ryke',),
'ryk': ('ryke',),
'ryke': ('ryke',),
'ryker': ('ryke',),
'rykes': ('ryke',),
'røk': ('ryke',),
'røket': ('ryke',),
'røyk': ('ryke',),
'rykk': ('rykke',),
'rykka': ('rykke',),
'rykke': ('rykke',),
'rykker': ('rykke',),
'rykkes': ('rykke',),
'rykket': ('rykke',),
'rykt': ('rykke',),
'rykte': ('rykke',),
'ryktedes': ('ryktes',),
'ryktes': ('ryktes',),
'rynk': ('rynke',),
'rynka': ('rynke',),
'rynke': ('rynke',),
'rynker': ('rynke',),
'rynkes': ('rynke',),
'rynket': ('rynke',),
'ryst': ('ryste',),
'rysta': ('ryste',),
'ryste': ('ryste',),
'ryster': ('ryste',),
'rystes': ('ryste',),
'rystet': ('ryste',),
'raut': ('ryte',),
'ryt': ('ryte',),
'ryte': ('ryte',),
'ryter': ('ryte',),
'rytes': ('ryte',),
'rytt': ('ryte',),
'røt': ('ryte',),
'røyt': ('ryte',),
'rå': ('rå',),
'rådd': ('rå',),
'rådde': ('rå',),
'rår': ('rå',),
'rås': ('rå',),
'råd': ('råde',),
'råda': ('råde',),
'rådd': ('råde',),
'rådde': ('råde',),
'råde': ('råde',),
'råder': ('råde',),
'rådes': ('råde',),
'rådet': ('råde',),
'rådfør': ('rådføre',),
'rådføre': ('rådføre',),
'rådfører': ('rådføre',),
'rådføres': ('rådføre',),
'rådført': ('rådføre',),
'rådførte': ('rådføre',),
'rådla': ('rådlegge',),
'rådlagt': ('rådlegge',),
'rådlegg': ('rådlegge',),
'rådlegge': ('rådlegge',),
'rådlegger': ('rådlegge',),
'rådlegges': ('rådlegge',),
'rådspurt': ('rådspørre',),
'rådspurte': ('rådspørre',),
'rådspør': ('rådspørre',),
'rådspørre': ('rådspørre',),
'rådspørres': ('rådspørre',),
'råk': ('råke',),
'råka': ('råke',),
'råke': ('råke',),
'råker': ('råke',),
'råkes': ('råke',),
'råket': ('råke',),
'råkt': ('råke',),
'råkte': ('råke',),
'råkjør': ('råkjøre',),
'råkjøre': ('råkjøre',),
'råkjører': ('råkjøre',),
'råkjøres': ('råkjøre',),
'råkjørt': ('råkjøre',),
'råkjørte': ('råkjøre',),
'rål': ('råle',),
'råla': ('råle',),
'råle': ('råle',),
'råler': ('råle',),
'råles': ('råle',),
'rålet': ('råle',),
'rålt': ('råle',),
'rålte': ('råle',),
'rån': ('råne',),
'råna': ('råne',),
'råne': ('råne',),
'råner': ('råne',),
'rånes': ('råne',),
'rånet': ('råne',),
'rånt': ('råne',),
'rånte': ('råne',),
'råtn': ('råtne',),
'råtna': ('råtne',),
'råtne': ('råtne',),
'råtner': ('råtne',),
'råtnes': ('råtne',),
'råtnet': ('råtne',),
'rød': ('røde',),
'rødd': ('røde',),
'rødde': ('røde',),
'røde': ('røde',),
'røder': ('røde',),
'rødes': ('røde',),
'rødm': ('rødme',),
'rødma': ('rødme',),
'rødme': ('rødme',),
'rødmer': ('rødme',),
'rødmes': ('rødme',),
'rødmet': ('rødme',),
'rødn': ('rødne',),
'rødna': ('rødne',),
'rødne': ('rødne',),
'rødner': ('rødne',),
'rødnes': ('rødne',),
'rødnet': ('rødne',),
'røfl': ('røfle',),
'røfla': ('røfle',),
'røfle': ('røfle',),
'røfler': ('røfle',),
'røfles': ('røfle',),
'røflet': ('røfle',),
'røkla': ('røklegge',),
'røklagt': ('røklegge',),
'røklegg': ('røklegge',),
'røklegge': ('røklegge',),
'røklegger': ('røklegge',),
'røklegges': ('røklegge',),
'røkt': ('røkte',),
'røkta': ('røkte',),
'røkte': ('røkte',),
'røkter': ('røkte',),
'røktes': ('røkte',),
'røktet': ('røkte',),
'røl': ('røle',),
'røle': ('røle',),
'røler': ('røle',),
'røles': ('røle',),
'rølt': ('røle',),
'rølte': ('røle',),
'røntgenfotografer': ('røntgenfotografere',),
'røntgenfotografere': ('røntgenfotografere',),
'røntgenfotograferer': ('røntgenfotografere',),
'røntgenfotograferes': ('røntgenfotografere',),
'røntgenfotografert': ('røntgenfotografere',),
'røntgenfotograferte': ('røntgenfotografere',),
'røp': ('røpe',),
'røpa': ('røpe',),
'røpe': ('røpe',),
'røper': ('røpe',),
'røpes': ('røpe',),
'røpet': ('røpe',),
'røpt': ('røpe',),
'røpte': ('røpe',),
'rør': ('røre',),
'røre': ('røre',),
'rører': ('røre',),
'røres': ('røre',),
'rørt': ('røre',),
'rørte': ('røre',),
'røsk': ('røske',),
'røska': ('røske',),
'røske': ('røske',),
'røsker': ('røske',),
'røskes': ('røske',),
'røsket': ('røske',),
'røst': ('røste',),
'røsta': ('røste',),
'røste': ('røste',),
'røster': ('røste',),
'røstes': ('røste',),
'røstet': ('røste',),
'røv': ('røve',),
'røva': ('røve',),
'røvd': ('røve',),
'røvde': ('røve',),
'røve': ('røve',),
'røver': ('røve',),
'røves': ('røve',),
'røvet': ('røve',),
'røyk': ('røyke',),
'røyka': ('røyke',),
'røyke': ('røyke',),
'røyker': ('røyke',),
'røykes': ('røyke',),
'røyket': ('røyke',),
'røykt': ('røyke',),
'røykte': ('røyke',),
'røykla': ('røyklegge',),
'røyklagt': ('røyklegge',),
'røyklegg': ('røyklegge',),
'røyklegge': ('røyklegge',),
'røyklegger': ('røyklegge',),
'røyklegges': ('røyklegge',),
'røyn': ('røyne',),
'røyna': ('røyne',),
'røyne': ('røyne',),
'røyner': ('røyne',),
'røynes': ('røyne',),
'røynet': ('røyne',),
'røynt': ('røyne',),
'røynte': ('røyne',),
'røys': ('røyse',),
'røysa': ('røyse',),
'røyse': ('røyse',),
'røyser': ('røyse',),
'røyses': ('røyse',),
'røyset': ('røyse',),
'røyst': ('røyse',),
'røyste': ('røyse',),
'røyt': ('røyte',),
'røyta': ('røyte',),
'røyte': ('røyte',),
'røyter': ('røyte',),
'røytes': ('røyte',),
'røytet': ('røyte',),
'røytt': ('røyte',),
'røytte': ('røyte',),
'sabb': ('sabbe',),
'sabba': ('sabbe',),
'sabbe': ('sabbe',),
'sabber': ('sabbe',),
'sabbes': ('sabbe',),
'sabbet': ('sabbe',),
'sabl': ('sable',),
'sabla': ('sable',),
'sable': ('sable',),
'sabler': ('sable',),
'sables': ('sable',),
'sablet': ('sable',),
'saboter': ('sabotere',),
'sabotere': ('sabotere',),
'saboterer': ('sabotere',),
'saboteres': ('sabotere',),
'sabotert': ('sabotere',),
'saboterte': ('sabotere',),
'sadl': ('sadle',),
'sadla': ('sadle',),
'sadle': ('sadle',),
'sadler': ('sadle',),
'sadles': ('sadle',),
'sadlet': ('sadle',),
'saf': ('safe',),
'safa': ('safe',),
'safe': ('safe',),
'safer': ('safe',),
'safes': ('safe',),
'safet': ('safe',),
'saft': ('safte',),
'safta': ('safte',),
'safte': ('safte',),
'safter': ('safte',),
'saftes': ('safte',),
'saftet': ('safte',),
'sag': ('sage',),
'saga': ('sage',),
'sagd': ('sage',),
'sagde': ('sage',),
'sage': ('sage',),
'sager': ('sage',),
'sages': ('sage',),
'saget': ('sage',),
'sak': ('sake',),
'saka': ('sake',),
'sake': ('sake',),
'saker': ('sake',),
'sakes': ('sake',),
'saket': ('sake',),
'sak': ('sake',),
'saka': ('sake',),
'sake': ('sake',),
'saker': ('sake',),
'sakes': ('sake',),
'saket': ('sake',),
'sakfell': ('sakfelle',),
'sakfelle': ('sakfelle',),
'sakfeller': ('sakfelle',),
'sakfelles': ('sakfelle',),
'sakfelt': ('sakfelle',),
'sakfelte': ('sakfelle',),
'sakk': ('sakke',),
'sakka': ('sakke',),
'sakke': ('sakke',),
'sakker': ('sakke',),
'sakkes': ('sakke',),
'sakket': ('sakke',),
'sakn': ('sakne',),
'sakna': ('sakne',),
'sakne': ('sakne',),
'sakner': ('sakne',),
'saknes': ('sakne',),
'saknet': ('sakne',),
'saks': ('sakse',),
'saksa': ('sakse',),
'sakse': ('sakse',),
'sakser': ('sakse',),
'sakses': ('sakse',),
'sakset': ('sakse',),
'saksøk': ('saksøke',),
'saksøke': ('saksøke',),
'saksøker': ('saksøke',),
'saksøkes': ('saksøke',),
'saksøkt': ('saksøke',),
'saksøkte': ('saksøke',),
'sakt': ('sakte',),
'sakta': ('sakte',),
'sakte': ('sakte',),
'sakter': ('sakte',),
'saktes': ('sakte',),
'saktet': ('sakte',),
'saktn': ('saktne',),
'saktna': ('saktne',),
'saktne': ('saktne',),
'saktner': ('saktne',),
'saktnes': ('saktne',),
'saktnet': ('saktne',),
'salder': ('saldere',),
'saldere': ('saldere',),
'salderer': ('saldere',),
'salderes': ('saldere',),
'saldert': ('saldere',),
'salderte': ('saldere',),
'sal': ('sale',),
'sala': ('sale',),
'sale': ('sale',),
'saler': ('sale',),
'sales': ('sale',),
'salet': ('sale',),
'salt': ('sale',),
'salte': ('sale',),
'salt': ('salte',),
'salta': ('salte',),
'salte': ('salte',),
'salter': ('salte',),
'saltes': ('salte',),
'saltet': ('salte',),
'salutter': ('saluttere',),
'saluttere': ('saluttere',),
'salutterer': ('saluttere',),
'salutteres': ('saluttere',),
'saluttert': ('saluttere',),
'salutterte': ('saluttere',),
'salv': ('salve',),
'salva': ('salve',),
'salve': ('salve',),
'salver': ('salve',),
'salves': ('salve',),
'salvet': ('salve',),
'samarbeid': ('samarbeide',),
'samarbeida': ('samarbeide',),
'samarbeidd': ('samarbeide',),
'samarbeidde': ('samarbeide',),
'samarbeide': ('samarbeide',),
'samarbeider': ('samarbeide',),
'samarbeides': ('samarbeide',),
'samarbeidet': ('samarbeide',),
'sambeit': ('sambeite',),
'sambeita': ('sambeite',),
'sambeite': ('sambeite',),
'sambeiter': ('sambeite',),
'sambeites': ('sambeite',),
'sambeitet': ('sambeite',),
'sambeitt': ('sambeite',),
'sambeitte': ('sambeite',),
'sameksister': ('sameksistere',),
'sameksistere': ('sameksistere',),
'sameksisterer': ('sameksistere',),
'sameksisteres': ('sameksistere',),
'sameksistert': ('sameksistere',),
'sameksisterte': ('sameksistere',),
'samkjør': ('samkjøre',),
'samkjøre': ('samkjøre',),
'samkjører': ('samkjøre',),
'samkjøres': ('samkjøre',),
'samkjørt': ('samkjøre',),
'samkjørte': ('samkjøre',),
'saml': ('samle',),
'samla': ('samle',),
'samle': ('samle',),
'samler': ('samle',),
'samles': ('samle',),
'samlet': ('samle',),
'sammenfatt': ('sammenfatte',),
'sammenfatta': ('sammenfatte',),
'sammenfatte': ('sammenfatte',),
'sammenfatter': ('sammenfatte',),
'sammenfattes': ('sammenfatte',),
'sammenfattet': ('sammenfatte',),
'sammenhold': ('sammenholde',),
'sammenholde': ('sammenholde',),
'sammenholder': ('sammenholde',),
'sammenholdes': ('sammenholde',),
'sammenholdt': ('sammenholde',),
'sammenkall': ('sammenkalle',),
'sammenkalle': ('sammenkalle',),
'sammenkaller': ('sammenkalle',),
'sammenkalles': ('sammenkalle',),
'sammenkalt': ('sammenkalle',),
'sammenkalte': ('sammenkalle',),
'sammenlign': ('sammenligne',),
'sammenligna': ('sammenligne',),
'sammenligne': ('sammenligne',),
'sammenligner': ('sammenligne',),
'sammenlignes': ('sammenligne',),
'sammenlignet': ('sammenligne',),
'sammenlikn': ('sammenlikne',),
'sammenlikna': ('sammenlikne',),
'sammenlikne': ('sammenlikne',),
'sammenlikner': ('sammenlikne',),
'sammenliknes': ('sammenlikne',),
'sammenliknet': ('sammenlikne',),
'sammenstill': ('sammenstille',),
'sammenstille': ('sammenstille',),
'sammenstiller': ('sammenstille',),
'sammenstilles': ('sammenstille',),
'sammenstilt': ('sammenstille',),
'sammenstilte': ('sammenstille',),
'sammensverg': ('sammensverge',),
'sammensverga': ('sammensverge',),
'sammensverge': ('sammensverge',),
'sammensverger': ('sammensverge',),
'sammensverges': ('sammensverge',),
'sammensverget': ('sammensverge',),
'sammensvor': ('sammensverge',),
'sammensvoret': ('sammensverge',),
'sammensverj': ('sammensverje',),
'sammensverja': ('sammensverje',),
'sammensverje': ('sammensverje',),
'sammensverjer': ('sammensverje',),
'sammensverjes': ('sammensverje',),
'sammensverjet': ('sammensverje',),
'sammensvor': ('sammensverje',),
'sammensvoret': ('sammensverje',),
'samordn': ('samordne',),
'samordna': ('samordne',),
'samordne': ('samordne',),
'samordner': ('samordne',),
'samordnes': ('samordne',),
'samordnet': ('samordne',),
'sampl': ('sample',),
'sampla': ('sample',),
'sample': ('sample',),
'sampler': ('sample',),
'samples': ('sample',),
'samplet': ('sample',),
'samrå': ('samrå',),
'samrådd': ('samrå',),
'samrådde': ('samrå',),
'samrår': ('samrå',),
'samrås': ('samrå',),
'sams': ('samse',),
'samsa': ('samse',),
'samse': ('samse',),
'samser': ('samse',),
'samses': ('samse',),
'samset': ('samse',),
'samstav': ('samstave',),
'samstava': ('samstave',),
'samstave': ('samstave',),
'samstaver': ('samstave',),
'samstaves': ('samstave',),
'samstavet': ('samstave',),
'samstem': ('samstemme',),
'samstemme': ('samstemme',),
'samstemmer': ('samstemme',),
'samstemmes': ('samstemme',),
'samstemt': ('samstemme',),
'samstemte': ('samstemme',),
'samtal': ('samtale',),
'samtala': ('samtale',),
'samtale': ('samtale',),
'samtaler': ('samtale',),
'samtales': ('samtale',),
'samtalt': ('samtale',),
'samtalte': ('samtale',),
'samtykk': ('samtykke',),
'samtykka': ('samtykke',),
'samtykke': ('samtykke',),
'samtykker': ('samtykke',),
'samtykkes': ('samtykke',),
'samtykket': ('samtykke',),
'samtykt': ('samtykke',),
'samtykte': ('samtykke',),
'samvirk': ('samvirke',),
'samvirka': ('samvirke',),
'samvirke': ('samvirke',),
'samvirker': ('samvirke',),
'samvirkes': ('samvirke',),
'samvirket': ('samvirke',),
'sandblås': ('sandblåse',),
'sandblåse': ('sandblåse',),
'sandblåser': ('sandblåse',),
'sandblåses': ('sandblåse',),
'sandblåst': ('sandblåse',),
'sandblåste': ('sandblåse',),
'saner': ('sanere',),
'sanere': ('sanere',),
'sanerer': ('sanere',),
'saneres': ('sanere',),
'sanert': ('sanere',),
'sanerte': ('sanere',),
'sanforiser': ('sanforisere',),
'sanforisere': ('sanforisere',),
'sanforiserer': ('sanforisere',),
'sanforiseres': ('sanforisere',),
'sanforisert': ('sanforisere',),
'sanforiserte': ('sanforisere',),
'sangr': ('sangre',),
'sangra': ('sangre',),
'sangre': ('sangre',),
'sangrer': ('sangre',),
'sangres': ('sangre',),
'sangret': ('sangre',),
'sank': ('sanke',),
'sanka': ('sanke',),
'sanke': ('sanke',),
'sanker': ('sanke',),
'sankes': ('sanke',),
'sanket': ('sanke',),
'sanksjoner': ('sanksjonere',),
'sanksjonere': ('sanksjonere',),
'sanksjonerer': ('sanksjonere',),
'sanksjoneres': ('sanksjonere',),
'sanksjonert': ('sanksjonere',),
'sanksjonerte': ('sanksjonere',),
'sann': ('sanne',),
'sanna': ('sanne',),
'sanne': ('sanne',),
'sanner': ('sanne',),
'sannes': ('sanne',),
'sannet': ('sanne',),
'sannsynliggjorde': ('sannsynliggjøre',),
'sannsynliggjort': ('sannsynliggjøre',),
'sannsynliggjør': ('sannsynliggjøre',),
'sannsynliggjøre': ('sannsynliggjøre',),
'sannsynliggjøres': ('sannsynliggjøre',),
'sans': ('sanse',),
'sansa': ('sanse',),
'sanse': ('sanse',),
'sanser': ('sanse',),
'sanses': ('sanse',),
'sanset': ('sanse',),
'satiner': ('satinere',),
'satinere': ('satinere',),
'satinerer': ('satinere',),
'satineres': ('satinere',),
'satinert': ('satinere',),
'satinerte': ('satinere',),
'satiriser': ('satirisere',),
'satirisere': ('satirisere',),
'satiriserer': ('satirisere',),
'satiriseres': ('satirisere',),
'satirisert': ('satirisere',),
'satiriserte': ('satirisere',),
'satisfiser': ('satisfisere',),
'satisfisere': ('satisfisere',),
'satisfiserer': ('satisfisere',),
'satisfiseres': ('satisfisere',),
'satisfisert': ('satisfisere',),
'satisfiserte': ('satisfisere',),
'sats': ('satse',),
'satsa': ('satse',),
'satse': ('satse',),
'satser': ('satse',),
'satses': ('satse',),
'satset': ('satse',),
'saumfar': ('saumfare',),
'saumfare': ('saumfare',),
'saumfarer': ('saumfare',),
'saumfares': ('saumfare',),
'saumfart': ('saumfare',),
'saumfor': ('saumfare',),
'saus': ('sause',),
'sausa': ('sause',),
'sause': ('sause',),
'sauser': ('sause',),
'sauses': ('sause',),
'sauset': ('sause',),
'savl': ('savle',),
'savla': ('savle',),
'savle': ('savle',),
'savler': ('savle',),
'savles': ('savle',),
'savlet': ('savle',),
'savn': ('savne',),
'savna': ('savne',),
'savne': ('savne',),
'savner': ('savne',),
'savnes': ('savne',),
'savnet': ('savne',),
'scor': ('score',),
'scora': ('score',),
'score': ('score',),
'scorer': ('score',),
'scores': ('score',),
'scoret': ('score',),
'script': ('scripte',),
'scripta': ('scripte',),
'scripte': ('scripte',),
'scripter': ('scripte',),
'scriptes': ('scripte',),
'scriptet': ('scripte',),
'se': ('se',),
'sees': ('se',),
'ser': ('se',),
'ses': ('se',),
'sett': ('se',),
'så': ('se',),
'såg': ('se',),
'sedimenter': ('sedimentere',),
'sedimentere': ('sedimentere',),
'sedimenterer': ('sedimentere',),
'sedimenteres': ('sedimentere',),
'sedimentert': ('sedimentere',),
'sedimenterte': ('sedimentere',),
'seed': ('seede',),
'seeda': ('seede',),
'seede': ('seede',),
'seeder': ('seede',),
'seedes': ('seede',),
'seedet': ('seede',),
'sees': ('sees',),
'ses': ('sees',),
'setts': ('sees',),
'såes': ('sees',),
'sås': ('sees',),
'segl': ('segle',),
'segla': ('segle',),
'segle': ('segle',),
'segler': ('segle',),
'segles': ('segle',),
'seglet': ('segle',),
'segmenter': ('segmentere',),
'segmentere': ('segmentere',),
'segmenterer': ('segmentere',),
'segmenteres': ('segmentere',),
'segmentert': ('segmentere',),
'segmenterte': ('segmentere',),
'segn': ('segne',),
'segna': ('segne',),
'segne': ('segne',),
'segner': ('segne',),
'segnes': ('segne',),
'segnet': ('segne',),
'segreger': ('segregere',),
'segregere': ('segregere',),
'segregerer': ('segregere',),
'segregeres': ('segregere',),
'segregert': ('segregere',),
'segregerte': ('segregere',),
'seid': ('seide',),
'seida': ('seide',),
'seide': ('seide',),
'seider': ('seide',),
'seides': ('seide',),
'seidet': ('seide',),
'seigpin': ('seigpine',),
'seigpine': ('seigpine',),
'seigpiner': ('seigpine',),
'seigpines': ('seigpine',),
'seigpint': ('seigpine',),
'seigpinte': ('seigpine',),
'seink': ('seinke',),
'seinka': ('seinke',),
'seinke': ('seinke',),
'seinker': ('seinke',),
'seinkes': ('seinke',),
'seinket': ('seinke',),
'seink': ('seinke',),
'seinka': ('seinke',),
'seinke': ('seinke',),
'seinker': ('seinke',),
'seinkes': ('seinke',),
'seinket': ('seinke',),
'seip': ('seipe',),
'seipa': ('seipe',),
'seipe': ('seipe',),
'seiper': ('seipe',),
'seipes': ('seipe',),
'seipet': ('seipe',),
'seir': ('seire',),
'seira': ('seire',),
'seire': ('seire',),
'seirer': ('seire',),
'seires': ('seire',),
'seiret': ('seire',),
'seis': ('seise',),
'seisa': ('seise',),
'seise': ('seise',),
'seiser': ('seise',),
'seises': ('seise',),
'seiset': ('seise',),
'seist': ('seise',),
'seiste': ('seise',),
'seksdobl': ('seksdoble',),
'seksdobla': ('seksdoble',),
'seksdoble': ('seksdoble',),
'seksdobler': ('seksdoble',),
'seksdobles': ('seksdoble',),
'seksdoblet': ('seksdoble',),
'seksjoner': ('seksjonere',),
'seksjonere': ('seksjonere',),
'seksjonerer': ('seksjonere',),
'seksjoneres': ('seksjonere',),
'seksjonert': ('seksjonere',),
'seksjonerte': ('seksjonere',),
'sekulariser': ('sekularisere',),
'sekularisere': ('sekularisere',),
'sekulariserer': ('sekularisere',),
'sekulariseres': ('sekularisere',),
'sekularisert': ('sekularisere',),
'sekulariserte': ('sekularisere',),
'sekunder': ('sekundere',),
'sekundere': ('sekundere',),
'sekunderer': ('sekundere',),
'sekunderes': ('sekundere',),
'sekundert': ('sekundere',),
'sekunderte': ('sekundere',),
'sel': ('sele',),
'sela': ('sele',),
'sele': ('sele',),
'seler': ('sele',),
'seles': ('sele',),
'selt': ('sele',),
'selte': ('sele',),
'selekter': ('selektere',),
'selektere': ('selektere',),
'selekterer': ('selektere',),
'selekteres': ('selektere',),
'selektert': ('selektere',),
'selekterte': ('selektere',),
'selg': ('selge',),
'selge': ('selge',),
'selger': ('selge',),
'selges': ('selge',),
'solgt': ('selge',),
'solgte': ('selge',),
'selvstendiggjorde': ('selvstendiggjøre',),
'selvstendiggjort': ('selvstendiggjøre',),
'selvstendiggjør': ('selvstendiggjøre',),
'selvstendiggjøre': ('selvstendiggjøre',),
'selvstendiggjøres': ('selvstendiggjøre',),
'semaforer': ('semaforere',),
'semaforere': ('semaforere',),
'semaforerer': ('semaforere',),
'semaforeres': ('semaforere',),
'semaforert': ('semaforere',),
'semaforerte': ('semaforere',),
'sementer': ('sementere',),
'sementere': ('sementere',),
'sementerer': ('sementere',),
'sementeres': ('sementere',),
'sementert': ('sementere',),
'sementerte': ('sementere',),
'seminer': ('seminere',),
'seminere': ('seminere',),
'seminerer': ('seminere',),
'semineres': ('seminere',),
'seminert': ('seminere',),
'seminerte': ('seminere',),
'semsgarv': ('semsgarve',),
'semsgarva': ('semsgarve',),
'semsgarve': ('semsgarve',),
'semsgarver': ('semsgarve',),
'semsgarves': ('semsgarve',),
'semsgarvet': ('semsgarve',),
'semsk': ('semske',),
'semska': ('semske',),
'semske': ('semske',),
'semsker': ('semske',),
'semskes': ('semske',),
'semsket': ('semske',),
'semskgarv': ('semskgarve',),
'semskgarva': ('semskgarve',),
'semskgarve': ('semskgarve',),
'semskgarver': ('semskgarve',),
'semskgarves': ('semskgarve',),
'semskgarvet': ('semskgarve',),
'send': ('sende',),
'sende': ('sende',),
'sender': ('sende',),
'sendes': ('sende',),
'sendt': ('sende',),
'sendte': ('sende',),
'senk': ('senke',),
'senka': ('senke',),
'senke': ('senke',),
'senker': ('senke',),
'senkes': ('senke',),
'senket': ('senke',),
'sensurer': ('sensurere',),
'sensurere': ('sensurere',),
'sensurerer': ('sensurere',),
'sensureres': ('sensurere',),
'sensurert': ('sensurere',),
'sensurerte': ('sensurere',),
'sentimentaliser': ('sentimentalisere',),
'sentimentalisere': ('sentimentalisere',),
'sentimentaliserer': ('sentimentalisere',),
'sentimentaliseres': ('sentimentalisere',),
'sentimentalisert': ('sentimentalisere',),
'sentimentaliserte': ('sentimentalisere',),
'sentraliser': ('sentralisere',),
'sentralisere': ('sentralisere',),
'sentraliserer': ('sentralisere',),
'sentraliseres': ('sentralisere',),
'sentralisert': ('sentralisere',),
'sentraliserte': ('sentralisere',),
'sentr': ('sentre',),
'sentra': ('sentre',),
'sentre': ('sentre',),
'sentrer': ('sentre',),
'sentres': ('sentre',),
'sentret': ('sentre',),
'sentrer': ('sentrere',),
'sentrere': ('sentrere',),
'sentrerer': ('sentrere',),
'sentreres': ('sentrere',),
'sentrert': ('sentrere',),
'sentrerte': ('sentrere',),
'sentrifuger': ('sentrifugere',),
'sentrifugere': ('sentrifugere',),
'sentrifugerer': ('sentrifugere',),
'sentrifugeres': ('sentrifugere',),
'sentrifugert': ('sentrifugere',),
'sentrifugerte': ('sentrifugere',),
'separer': ('separere',),
'separere': ('separere',),
'separerer': ('separere',),
'separeres': ('separere',),
'separert': ('separere',),
'separerte': ('separere',),
'serrater': ('serratere',),
'serratere': ('serratere',),
'serraterer': ('serratere',),
'serrateres': ('serratere',),
'serratert': ('serratere',),
'serraterte': ('serratere',),
'sertifiser': ('sertifisere',),
'sertifisere': ('sertifisere',),
'sertifiserer': ('sertifisere',),
'sertifiseres': ('sertifisere',),
'sertifisert': ('sertifisere',),
'sertifiserte': ('sertifisere',),
'serv': ('serve',),
'serva': ('serve',),
'serve': ('serve',),
'server': ('serve',),
'serves': ('serve',),
'servet': ('serve',),
'server': ('servere',),
'servere': ('servere',),
'serverer': ('servere',),
'serveres': ('servere',),
'servert': ('servere',),
'serverte': ('servere',),
'sees': ('ses',),
'ses': ('ses',),
'setts': ('ses',),
'såes': ('ses',),
'sås': ('ses',),
'sesongdebuter': ('sesongdebutere',),
'sesongdebutere': ('sesongdebutere',),
'sesongdebuterer': ('sesongdebutere',),
'sesongdebuteres': ('sesongdebutere',),
'sesongdebutert': ('sesongdebutere',),
'sesongdebuterte': ('sesongdebutere',),
'sess': ('sesse',),
'sessa': ('sesse',),
'sesse': ('sesse',),
'sesser': ('sesse',),
'sesses': ('sesse',),
'sesset': ('sesse',),
'setr': ('setre',),
'setra': ('setre',),
'setre': ('setre',),
'setrer': ('setre',),
'setres': ('setre',),
'setret': ('setre',),
'satt': ('sette',),
'satte': ('sette',),
'sett': ('sette',),
'sette': ('sette',),
'setter': ('sette',),
'settes': ('sette',),
'settl': ('settle',),
'settla': ('settle',),
'settle': ('settle',),
'settler': ('settle',),
'settles': ('settle',),
'settlet': ('settle',),
'sexdebuter': ('sexdebutere',),
'sexdebutere': ('sexdebutere',),
'sexdebuterer': ('sexdebutere',),
'sexdebuteres': ('sexdebutere',),
'sexdebutert': ('sexdebutere',),
'sexdebuterte': ('sexdebutere',),
'shak': ('shake',),
'shaka': ('shake',),
'shake': ('shake',),
'shaker': ('shake',),
'shakes': ('shake',),
'shaket': ('shake',),
'shopp': ('shoppe',),
'shoppa': ('shoppe',),
'shoppe': ('shoppe',),
'shopper': ('shoppe',),
'shoppes': ('shoppe',),
'shoppet': ('shoppe',),
'show': ('showe',),
'showa': ('showe',),
'showe': ('showe',),
'shower': ('showe',),
'showes': ('showe',),
'showet': ('showe',),
'shunt': ('shunte',),
'shunta': ('shunte',),
'shunte': ('shunte',),
'shunter': ('shunte',),
'shuntes': ('shunte',),
'shuntet': ('shunte',),
'sa': ('si',),
'sagt': ('si',),
'si': ('si',),
'sier': ('si',),
'sies': ('si',),
'sis': ('si',),
'sideordn': ('sideordne',),
'sideordna': ('sideordne',),
'sideordne': ('sideordne',),
'sideordner': ('sideordne',),
'sideordnes': ('sideordne',),
'sideordnet': ('sideordne',),
'sidestill': ('sidestille',),
'sidestille': ('sidestille',),
'sidestiller': ('sidestille',),
'sidestilles': ('sidestille',),
'sidestilt': ('sidestille',),
'sidestilte': ('sidestille',),
'sidrakk': ('sidrikke',),
'sidrikk': ('sidrikke',),
'sidrikke': ('sidrikke',),
'sidrikker': ('sidrikke',),
'sidrikkes': ('sidrikke',),
'sidrukket': ('sidrikke',),
'sifrer': ('sifrere',),
'sifrere': ('sifrere',),
'sifrerer': ('sifrere',),
'sifreres': ('sifrere',),
'sifrert': ('sifrere',),
'sifrerte': ('sifrere',),
'seg': ('sige',),
'seget': ('sige',),
'seig': ('sige',),
'sig': ('sige',),
'sige': ('sige',),
'siger': ('sige',),
'siges': ('sige',),
'signaler': ('signalere',),
'signalere': ('signalere',),
'signalerer': ('signalere',),
'signaleres': ('signalere',),
'signalert': ('signalere',),
'signalerte': ('signalere',),
'signaliser': ('signalisere',),
'signalisere': ('signalisere',),
'signaliserer': ('signalisere',),
'signaliseres': ('signalisere',),
'signalisert': ('signalisere',),
'signaliserte': ('signalisere',),
'sign': ('signe',),
'signa': ('signe',),
'signe': ('signe',),
'signer': ('signe',),
'signes': ('signe',),
'signet': ('signe',),
'signer': ('signere',),
'signere': ('signere',),
'signerer': ('signere',),
'signeres': ('signere',),
'signert': ('signere',),
'signerte': ('signere',),
'sik': ('sike',),
'sika': ('sike',),
'sike': ('sike',),
'siker': ('sike',),
'sikes': ('sike',),
'siket': ('sike',),
'sikkerhetsklarer': ('sikkerhetsklarere',),
'sikkerhetsklarere': ('sikkerhetsklarere',),
'sikkerhetsklarerer': ('sikkerhetsklarere',),
'sikkerhetsklareres': ('sikkerhetsklarere',),
'sikkerhetsklarert': ('sikkerhetsklarere',),
'sikkerhetsklarerte': ('sikkerhetsklarere',),
'sikksakk': ('sikksakke',),
'sikksakka': ('sikksakke',),
'sikksakke': ('sikksakke',),
'sikksakker': ('sikksakke',),
'sikksakkes': ('sikksakke',),
'sikksakket': ('sikksakke',),
'sikl': ('sikle',),
'sikla': ('sikle',),
'sikle': ('sikle',),
'sikler': ('sikle',),
'sikles': ('sikle',),
'siklet': ('sikle',),
'sikl': ('sikle',),
'sikla': ('sikle',),
'sikle': ('sikle',),
'sikler': ('sikle',),
'sikles': ('sikle',),
'siklet': ('sikle',),
'sikr': ('sikre',),
'sikra': ('sikre',),
'sikre': ('sikre',),
'sikrer': ('sikre',),
'sikres': ('sikre',),
'sikret': ('sikre',),
'sikt': ('sikte',),
'sikta': ('sikte',),
'sikte': ('sikte',),
'sikter': ('sikte',),
'siktes': ('sikte',),
'siktet': ('sikte',),
'sikt': ('sikte',),
'sikta': ('sikte',),
'sikte': ('sikte',),
'sikter': ('sikte',),
'siktes': ('sikte',),
'siktet': ('sikte',),
'sikt': ('sikte',),
'sikta': ('sikte',),
'sikte': ('sikte',),
'sikter': ('sikte',),
'siktes': ('sikte',),
'siktet': ('sikte',),
'silblø': ('silblø',),
'silblødd': ('silblø',),
'silblødde': ('silblø',),
'silblør': ('silblø',),
'silbløs': ('silblø',),
'sildr': ('sildre',),
'sildra': ('sildre',),
'sildre': ('sildre',),
'sildrer': ('sildre',),
'sildres': ('sildre',),
'sildret': ('sildre',),
'sil': ('sile',),
'sile': ('sile',),
'siler': ('sile',),
'siles': ('sile',),
'silt': ('sile',),
'silte': ('sile',),
'silregn': ('silregne',),
'silregna': ('silregne',),
'silregne': ('silregne',),
'silregner': ('silregne',),
'silregnes': ('silregne',),
'silregnet': ('silregne',),
'silregnt': ('silregne',),
'silregnte': ('silregne',),
'silrann': ('silrenne',),
'silrant': ('silrenne',),
'silrenn': ('silrenne',),
'silrenne': ('silrenne',),
'silrenner': ('silrenne',),
'silrennes': ('silrenne',),
'silrent': ('silrenne',),
'simplifiser': ('simplifisere',),
'simplifisere': ('simplifisere',),
'simplifiserer': ('simplifisere',),
'simplifiseres': ('simplifisere',),
'simplifisert': ('simplifisere',),
'simplifiserte': ('simplifisere',),
'simuler': ('simulere',),
'simulere': ('simulere',),
'simulerer': ('simulere',),
'simuleres': ('simulere',),
'simulert': ('simulere',),
'simulerte': ('simulere',),
'sindr': ('sindre',),
'sindra': ('sindre',),
'sindre': ('sindre',),
'sindrer': ('sindre',),
'sindres': ('sindre',),
'sindret': ('sindre',),
'sin': ('sine',),
'sina': ('sine',),
'sine': ('sine',),
'siner': ('sine',),
'sines': ('sine',),
'sinet': ('sine',),
'singl': ('single',),
'singla': ('single',),
'single': ('single',),
'singler': ('single',),
'singles': ('single',),
'singlet': ('single',),
'singl': ('single',),
'singla': ('single',),
'single': ('single',),
'singler': ('single',),
'singles': ('single',),
'singlet': ('single',),
'sink': ('sinke',),
'sinka': ('sinke',),
'sinke': ('sinke',),
'sinker': ('sinke',),
'sinkes': ('sinke',),
'sinket': ('sinke',),
'sink': ('sinke',),
'sinka': ('sinke',),
'sinke': ('sinke',),
'sinker': ('sinke',),
'sinkes': ('sinke',),
'sinket': ('sinke',),
'sink': ('sinke',),
'sinka': ('sinke',),
'sinke': ('sinke',),
'sinker': ('sinke',),
'sinkes': ('sinke',),
'sinket': ('sinke',),
'sintr': ('sintre',),
'sintra': ('sintre',),
'sintre': ('sintre',),
'sintrer': ('sintre',),
'sintres': ('sintre',),
'sintret': ('sintre',),
'sip': ('sipe',),
'sipa': ('sipe',),
'sipe': ('sipe',),
'siper': ('sipe',),
'sipes': ('sipe',),
'sipet': ('sipe',),
'sipt': ('sipe',),
'sipte': ('sipe',),
'sipp': ('sippe',),
'sippa': ('sippe',),
'sippe': ('sippe',),
'sipper': ('sippe',),
'sippes': ('sippe',),
'sippet': ('sippe',),
'sipt': ('sippe',),
'sipte': ('sippe',),
'siregn': ('siregne',),
'siregna': ('siregne',),
'siregne': ('siregne',),
'siregner': ('siregne',),
'siregnes': ('siregne',),
'siregnet': ('siregne',),
'siregnt': ('siregne',),
'siregnte': ('siregne',),
'sirkl': ('sirkle',),
'sirkla': ('sirkle',),
'sirkle': ('sirkle',),
'sirkler': ('sirkle',),
'sirkles': ('sirkle',),
'sirklet': ('sirkle',),
'sirkuler': ('sirkulere',),
'sirkulere': ('sirkulere',),
'sirkulerer': ('sirkulere',),
'sirkuleres': ('sirkulere',),
'sirkulert': ('sirkulere',),
'sirkulerte': ('sirkulere',),
'siseler': ('siselere',),
'siselere': ('siselere',),
'siselerer': ('siselere',),
'siseleres': ('siselere',),
'siselert': ('siselere',),
'siselerte': ('siselere',),
'sisl': ('sisle',),
'sisla': ('sisle',),
'sisle': ('sisle',),
'sisler': ('sisle',),
'sisles': ('sisle',),
'sislet': ('sisle',),
'siter': ('sitere',),
'sitere': ('sitere',),
'siterer': ('sitere',),
'siteres': ('sitere',),
'sitert': ('sitere',),
'siterte': ('sitere',),
'sitr': ('sitre',),
'sitra': ('sitre',),
'sitre': ('sitre',),
'sitrer': ('sitre',),
'sitres': ('sitre',),
'sitret': ('sitre',),
'satt': ('sitte',),
'sitt': ('sitte',),
'sitte': ('sitte',),
'sitter': ('sitte',),
'sittes': ('sitte',),
'sittet': ('sitte',),
'seiv': ('sive',),
'sev': ('sive',),
'siv': ('sive',),
'siva': ('sive',),
'sivd': ('sive',),
'sivde': ('sive',),
'sive': ('sive',),
'siver': ('sive',),
'sives': ('sive',),
'sivet': ('sive',),
'siviliser': ('sivilisere',),
'sivilisere': ('sivilisere',),
'siviliserer': ('sivilisere',),
'siviliseres': ('sivilisere',),
'sivilisert': ('sivilisere',),
'siviliserte': ('sivilisere',),
'sjabb': ('sjabbe',),
'sjabba': ('sjabbe',),
'sjabbe': ('sjabbe',),
'sjabber': ('sjabbe',),
'sjabbes': ('sjabbe',),
'sjabbet': ('sjabbe',),
'sjakl': ('sjakle',),
'sjakla': ('sjakle',),
'sjakle': ('sjakle',),
'sjakler': ('sjakle',),
'sjakles': ('sjakle',),
'sjaklet': ('sjakle',),
'sjakr': ('sjakre',),
'sjakra': ('sjakre',),
'sjakre': ('sjakre',),
'sjakrer': ('sjakre',),
'sjakres': ('sjakre',),
'sjakret': ('sjakre',),
'sjalt': ('sjalte',),
'sjalta': ('sjalte',),
'sjalte': ('sjalte',),
'sjalter': ('sjalte',),
'sjaltes': ('sjalte',),
'sjaltet': ('sjalte',),
'sjamponer': ('sjamponere',),
'sjamponere': ('sjamponere',),
'sjamponerer': ('sjamponere',),
'sjamponeres': ('sjamponere',),
'sjamponert': ('sjamponere',),
'sjamponerte': ('sjamponere',),
'sjanghai': ('sjanghaie',),
'sjanghaia': ('sjanghaie',),
'sjanghaie': ('sjanghaie',),
'sjanghaier': ('sjanghaie',),
'sjanghaies': ('sjanghaie',),
'sjanghaiet': ('sjanghaie',),
'sjangl': ('sjangle',),
'sjangla': ('sjangle',),
'sjangle': ('sjangle',),
'sjangler': ('sjangle',),
'sjangles': ('sjangle',),
'sjanglet': ('sjangle',),
'sjarmantiser': ('sjarmantisere',),
'sjarmantisere': ('sjarmantisere',),
'sjarmantiserer': ('sjarmantisere',),
'sjarmantiseres': ('sjarmantisere',),
'sjarmantisert': ('sjarmantisere',),
'sjarmantiserte': ('sjarmantisere',),
'sjarmer': ('sjarmere',),
'sjarmere': ('sjarmere',),
'sjarmerer': ('sjarmere',),
'sjarmeres': ('sjarmere',),
'sjarmert': ('sjarmere',),
'sjarmerte': ('sjarmere',),
'sjask': ('sjaske',),
'sjaska': ('sjaske',),
'sjaske': ('sjaske',),
'sjasker': ('sjaske',),
'sjaskes': ('sjaske',),
'sjasket': ('sjaske',),
'sjatter': ('sjattere',),
'sjattere': ('sjattere',),
'sjatterer': ('sjattere',),
'sjatteres': ('sjattere',),
'sjattert': ('sjattere',),
'sjatterte': ('sjattere',),
'sjau': ('sjaue',),
'sjaua': ('sjaue',),
'sjaue': ('sjaue',),
'sjauer': ('sjaue',),
'sjaues': ('sjaue',),
'sjauet': ('sjaue',),
'sjef': ('sjefe',),
'sjefa': ('sjefe',),
'sjefe': ('sjefe',),
'sjefer': ('sjefe',),
'sjefes': ('sjefe',),
'sjefet': ('sjefe',),
'sjeid': ('sjeide',),
'sjeida': ('sjeide',),
'sjeide': ('sjeide',),
'sjeider': ('sjeide',),
'sjeides': ('sjeide',),
'sjeidet': ('sjeide',),
'sjekk': ('sjekke',),
'sjekka': ('sjekke',),
'sjekke': ('sjekke',),
'sjekker': ('sjekke',),
'sjekkes': ('sjekke',),
'sjekket': ('sjekke',),
'sjeleleg': ('sjelelege',),
'sjelelega': ('sjelelege',),
'sjelelege': ('sjelelege',),
'sjeleleger': ('sjelelege',),
'sjeleleges': ('sjelelege',),
'sjeleleget': ('sjelelege',),
'sjelelegt': ('sjelelege',),
'sjelelegte': ('sjelelege',),
'sjener': ('sjenere',),
'sjenere': ('sjenere',),
'sjenerer': ('sjenere',),
'sjeneres': ('sjenere',),
'sjenert': ('sjenere',),
'sjenerte': ('sjenere',),
'sjevr': ('sjevre',),
'sjevra': ('sjevre',),
'sjevre': ('sjevre',),
'sjevrer': ('sjevre',),
'sjevres': ('sjevre',),
'sjevret': ('sjevre',),
'sjikaner': ('sjikanere',),
'sjikanere': ('sjikanere',),
'sjikanerer': ('sjikanere',),
'sjikaneres': ('sjikanere',),
'sjikanert': ('sjikanere',),
'sjikanerte': ('sjikanere',),
'sjingl': ('sjingle',),
'sjingla': ('sjingle',),
'sjingle': ('sjingle',),
'sjingler': ('sjingle',),
'sjingles': ('sjingle',),
'sjinglet': ('sjingle',),
'sjofl': ('sjofle',),
'sjofla': ('sjofle',),
'sjofle': ('sjofle',),
'sjofler': ('sjofle',),
'sjofles': ('sjofle',),
'sjoflet': ('sjofle',),
'sjog': ('sjoge',),
'sjoga': ('sjoge',),
'sjoge': ('sjoge',),
'sjoger': ('sjoge',),
'sjoges': ('sjoge',),
'sjoget': ('sjoge',),
'sjogs': ('sjogse',),
'sjogsa': ('sjogse',),
'sjogse': ('sjogse',),
'sjogser': ('sjogse',),
'sjogses': ('sjogse',),
'sjogset': ('sjogse',),
'sjokk': ('sjokke',),
'sjokka': ('sjokke',),
'sjokke': ('sjokke',),
'sjokker': ('sjokke',),
'sjokkes': ('sjokke',),
'sjokket': ('sjokke',),
'sjokker': ('sjokkere',),
'sjokkere': ('sjokkere',),
'sjokkerer': ('sjokkere',),
'sjokkeres': ('sjokkere',),
'sjokkert': ('sjokkere',),
'sjokkerte': ('sjokkere',),
'sjokkåpn': ('sjokkåpne',),
'sjokkåpna': ('sjokkåpne',),
'sjokkåpne': ('sjokkåpne',),
'sjokkåpner': ('sjokkåpne',),
'sjokkåpnes': ('sjokkåpne',),
'sjokkåpnet': ('sjokkåpne',),
'sjongler': ('sjonglere',),
'sjonglere': ('sjonglere',),
'sjonglerer': ('sjonglere',),
'sjongleres': ('sjonglere',),
'sjonglert': ('sjonglere',),
'sjonglerte': ('sjonglere',),
'sjudobl': ('sjudoble',),
'sjudobla': ('sjudoble',),
'sjudoble': ('sjudoble',),
'sjudobler': ('sjudoble',),
'sjudobles': ('sjudoble',),
'sjudoblet': ('sjudoble',),
'sjukemeld': ('sjukemelde',),
'sjukemelde': ('sjukemelde',),
'sjukemelder': ('sjukemelde',),
'sjukemeldes': ('sjukemelde',),
'sjukemeldt': ('sjukemelde',),
'sjukemeldte': ('sjukemelde',),
'sjukmeld': ('sjukmelde',),
'sjukmelde': ('sjukmelde',),
'sjukmelder': ('sjukmelde',),
'sjukmeldes': ('sjukmelde',),
'sjukmeldt': ('sjukmelde',),
'sjukmeldte': ('sjukmelde',),
'sjukn': ('sjukne',),
'sjukna': ('sjukne',),
'sjukne': ('sjukne',),
'sjukner': ('sjukne',),
'sjuknes': ('sjukne',),
'sjuknet': ('sjukne',),
'sjusk': ('sjuske',),
'sjuska': ('sjuske',),
'sjuske': ('sjuske',),
'sjusker': ('sjuske',),
'sjuskes': ('sjuske',),
'sjusket': ('sjuske',),
'sjølstendiggjorde': ('sjølstendiggjøre',),
'sjølstendiggjort': ('sjølstendiggjøre',),
'sjølstendiggjør': ('sjølstendiggjøre',),
'sjølstendiggjøre': ('sjølstendiggjøre',),
'sjølstendiggjøres': ('sjølstendiggjøre',),
'sjøsatt': ('sjøsette',),
'sjøsatte': ('sjøsette',),
'sjøsett': ('sjøsette',),
'sjøsette': ('sjøsette',),
'sjøsetter': ('sjøsette',),
'sjøsettes': ('sjøsette',),
'ska': ('ska',),
'skadd': ('ska',),
'skadde': ('ska',),
'skar': ('ska',),
'skas': ('ska',),
'ska': ('ska',),
'skadd': ('ska',),
'skadde': ('ska',),
'skar': ('ska',),
'skas': ('ska',),
'skad': ('skade',),
'skada': ('skade',),
'skadd': ('skade',),
'skadde': ('skade',),
'skade': ('skade',),
'skader': ('skade',),
'skades': ('skade',),
'skadet': ('skade',),
'skad': ('skade',),
'skada': ('skade',),
'skadd': ('skade',),
'skadde': ('skade',),
'skade': ('skade',),
'skader': ('skade',),
'skades': ('skade',),
'skadet': ('skade',),
'skadeskaut': ('skadeskyte',),
'skadeskjøt': ('skadeskyte',),
'skadeskutt': ('skadeskyte',),
'skadeskyt': ('skadeskyte',),
'skadeskyte': ('skadeskyte',),
'skadeskyter': ('skadeskyte',),
'skadeskytes': ('skadeskyte',),
'skadeskøyt': ('skadeskyte',),
'skaff': ('skaffe',),
'skaffa': ('skaffe',),
'skaffe': ('skaffe',),
'skaffer': ('skaffe',),
'skaffes': ('skaffe',),
'skaffet': ('skaffe',),
'skaff': ('skaffe',),
'skaffa': ('skaffe',),
'skaffe': ('skaffe',),
'skaffer': ('skaffe',),
'skaffes': ('skaffe',),
'skaffet': ('skaffe',),
'skaft': ('skafte',),
'skafta': ('skafte',),
'skafte': ('skafte',),
'skafter': ('skafte',),
'skaftes': ('skafte',),
'skaftet': ('skafte',),
'skak': ('skake',),
'skaka': ('skake',),
'skake': ('skake',),
'skaker': ('skake',),
'skakes': ('skake',),
'skaket': ('skake',),
'skakk': ('skakke',),
'skakka': ('skakke',),
'skakke': ('skakke',),
'skakker': ('skakke',),
'skakkes': ('skakke',),
'skakket': ('skakke',),
'skaler': ('skalere',),
'skalere': ('skalere',),
'skalerer': ('skalere',),
'skaleres': ('skalere',),
'skalert': ('skalere',),
'skalerte': ('skalere',),
'skalk': ('skalke',),
'skalka': ('skalke',),
'skalke': ('skalke',),
'skalker': ('skalke',),
'skalkes': ('skalke',),
'skalket': ('skalke',),
'skall': ('skalle',),
'skalla': ('skalle',),
'skalle': ('skalle',),
'skaller': ('skalle',),
'skalles': ('skalle',),
'skallet': ('skalle',),
'skall': ('skalle',),
'skalla': ('skalle',),
'skalle': ('skalle',),
'skaller': ('skalle',),
'skalles': ('skalle',),
'skallet': ('skalle',),
'skalper': ('skalpere',),
'skalpere': ('skalpere',),
'skalperer': ('skalpere',),
'skalperes': ('skalpere',),
'skalpert': ('skalpere',),
'skalperte': ('skalpere',),
'skalt': ('skalte',),
'skalta': ('skalte',),
'skalte': ('skalte',),
'skalter': ('skalte',),
'skaltes': ('skalte',),
'skaltet': ('skalte',),
'skamfer': ('skamfere',),
'skamfere': ('skamfere',),
'skamferer': ('skamfere',),
'skamferes': ('skamfere',),
'skamfert': ('skamfere',),
'skamferte': ('skamfere',),
'skamfraus': ('skamfryse',),
'skamfrosset': ('skamfryse',),
'skamfrys': ('skamfryse',),
'skamfryse': ('skamfryse',),
'skamfryser': ('skamfryse',),
'skamfryses': ('skamfryse',),
'skamfrøs': ('skamfryse',),
'skamfrøys': ('skamfryse',),
'skamhogd': ('skamhogge',),
'skamhogde': ('skamhogge',),
'skamhogg': ('skamhogge',),
'skamhogge': ('skamhogge',),
'skamhogger': ('skamhogge',),
'skamhogges': ('skamhogge',),
'skamhogget': ('skamhogge',),
'skamhugd': ('skamhugge',),
'skamhugde': ('skamhugge',),
'skamhugg': ('skamhugge',),
'skamhugga': ('skamhugge',),
'skamhugge': ('skamhugge',),
'skamhugger': ('skamhugge',),
'skamhugges': ('skamhugge',),
'skamhugget': ('skamhugge',),
'skamkjør': ('skamkjøre',),
'skamkjøre': ('skamkjøre',),
'skamkjører': ('skamkjøre',),
'skamkjøres': ('skamkjøre',),
'skamkjørt': ('skamkjøre',),
'skamkjørte': ('skamkjøre',),
'skamklipp': ('skamklippe',),
'skamklippa': ('skamklippe',),
'skamklippe': ('skamklippe',),
'skamklipper': ('skamklippe',),
'skamklippes': ('skamklippe',),
'skamklippet': ('skamklippe',),
'skamklipt': ('skamklippe',),
'skamklipte': ('skamklippe',),
'skam': ('skamme',),
'skamma': ('skamme',),
'skamme': ('skamme',),
'skammer': ('skamme',),
'skammes': ('skamme',),
'skammet': ('skamme',),
'skamros': ('skamrose',),
'skamrose': ('skamrose',),
'skamroser': ('skamrose',),
'skamroses': ('skamrose',),
'skamrost': ('skamrose',),
'skamroste': ('skamrose',),
'skandaliser': ('skandalisere',),
'skandalisere': ('skandalisere',),
'skandaliserer': ('skandalisere',),
'skandaliseres': ('skandalisere',),
'skandalisert': ('skandalisere',),
'skandaliserte': ('skandalisere',),
'skander': ('skandere',),
'skandere': ('skandere',),
'skanderer': ('skandere',),
'skanderes': ('skandere',),
'skandert': ('skandere',),
'skanderte': ('skandere',),
'skann': ('skanne',),
'skanna': ('skanne',),
'skanne': ('skanne',),
'skanner': ('skanne',),
'skannes': ('skanne',),
'skannet': ('skanne',),
'skant': ('skante',),
'skanta': ('skante',),
'skante': ('skante',),
'skanter': ('skante',),
'skantes': ('skante',),
'skantet': ('skante',),
'skap': ('skape',),
'skapa': ('skape',),
'skape': ('skape',),
'skaper': ('skape',),
'skapes': ('skape',),
'skapt': ('skape',),
'skapte': ('skape',),
'skar': ('skare',),
'skara': ('skare',),
'skare': ('skare',),
'skarer': ('skare',),
'skares': ('skare',),
'skaret': ('skare',),
'skar': ('skare',),
'skara': ('skare',),
'skare': ('skare',),
'skarer': ('skare',),
'skares': ('skare',),
'skaret': ('skare',),
'skar': ('skare',),
'skara': ('skare',),
'skare': ('skare',),
'skarer': ('skare',),
'skares': ('skare',),
'skaret': ('skare',),
'skarifiser': ('skarifisere',),
'skarifisere': ('skarifisere',),
'skarifiserer': ('skarifisere',),
'skarifiseres': ('skarifisere',),
'skarifisert': ('skarifisere',),
'skarifiserte': ('skarifisere',),
'skarr': ('skarre',),
'skarra': ('skarre',),
'skarre': ('skarre',),
'skarrer': ('skarre',),
'skarres': ('skarre',),
'skarret': ('skarre',),
'skarv': ('skarve',),
'skarva': ('skarve',),
'skarve': ('skarve',),
'skarver': ('skarve',),
'skarves': ('skarve',),
'skarvet': ('skarve',),
'skat': ('skate',),
'skata': ('skate',),
'skate': ('skate',),
'skater': ('skate',),
'skates': ('skate',),
'skatet': ('skate',),
'skatt': ('skatte',),
'skatta': ('skatte',),
'skatte': ('skatte',),
'skatter': ('skatte',),
'skattes': ('skatte',),
'skattet': ('skatte',),
'skattla': ('skattlegge',),
'skattlagt': ('skattlegge',),
'skattlegg': ('skattlegge',),
'skattlegge': ('skattlegge',),
'skattlegger': ('skattlegge',),
'skattlegges': ('skattlegge',),
'skav': ('skave',),
'skava': ('skave',),
'skave': ('skave',),
'skaver': ('skave',),
'skaves': ('skave',),
'skavet': ('skave',),
'skavl': ('skavle',),
'skavla': ('skavle',),
'skavle': ('skavle',),
'skavler': ('skavle',),
'skavles': ('skavle',),
'skavlet': ('skavle',),
'skei': ('skeie',),
'skeia': ('skeie',),
'skeid': ('skeie',),
'skeide': ('skeie',),
'skeie': ('skeie',),
'skeier': ('skeie',),
'skeies': ('skeie',),
'skeiet': ('skeie',),
'skei': ('skeie',),
'skeia': ('skeie',),
'skeid': ('skeie',),
'skeide': ('skeie',),
'skeie': ('skeie',),
'skeier': ('skeie',),
'skeies': ('skeie',),
'skeiet': ('skeie',),
'skein': ('skeine',),
'skeine': ('skeine',),
'skeiner': ('skeine',),
'skeines': ('skeine',),
'skeint': ('skeine',),
'skeinte': ('skeine',),
'skeis': ('skeise',),
'skeisa': ('skeise',),
'skeise': ('skeise',),
'skeiser': ('skeise',),
'skeises': ('skeise',),
'skeiset': ('skeise',),
'skeist': ('skeise',),
'skeiste': ('skeise',),
'skeiv': ('skeive',),
'skeiva': ('skeive',),
'skeive': ('skeive',),
'skeiver': ('skeive',),
'skeives': ('skeive',),
'skeivet': ('skeive',),
'skeivl': ('skeivle',),
'skeivla': ('skeivle',),
'skeivle': ('skeivle',),
'skeivler': ('skeivle',),
'skeivles': ('skeivle',),
'skeivlet': ('skeivle',),
'skift': ('skifte',),
'skifta': ('skifte',),
'skifte': ('skifte',),
'skifter': ('skifte',),
'skiftes': ('skifte',),
'skiftet': ('skifte',),
'skikk': ('skikke',),
'skikka': ('skikke',),
'skikke': ('skikke',),
'skikker': ('skikke',),
'skikkes': ('skikke',),
'skikket': ('skikke',),
'skildr': ('skildre',),
'skildra': ('skildre',),
'skildre': ('skildre',),
'skildrer': ('skildre',),
'skildres': ('skildre',),
'skildret': ('skildre',),
'skill': ('skille',),
'skille': ('skille',),
'skiller': ('skille',),
'skilles': ('skille',),
'skilt': ('skille',),
'skilte': ('skille',),
'skilling': ('skillinge',),
'skillinga': ('skillinge',),
'skillinge': ('skillinge',),
'skillinger': ('skillinge',),
'skillinges': ('skillinge',),
'skillinget': ('skillinge',),
'skilt': ('skilte',),
'skilta': ('skilte',),
'skilte': ('skilte',),
'skilter': ('skilte',),
'skiltes': ('skilte',),
'skiltet': ('skilte',),
'skiml': ('skimle',),
'skimla': ('skimle',),
'skimle': ('skimle',),
'skimler': ('skimle',),
'skimles': ('skimle',),
'skimlet': ('skimle',),
'skiml': ('skimle',),
'skimla': ('skimle',),
'skimle': ('skimle',),
'skimler': ('skimle',),
'skimles': ('skimle',),
'skimlet': ('skimle',),
'skiml': ('skimle',),
'skimla': ('skimle',),
'skimle': ('skimle',),
'skimler': ('skimle',),
'skimles': ('skimle',),
'skimlet': ('skimle',),
'skimr': ('skimre',),
'skimra': ('skimre',),
'skimre': ('skimre',),
'skimrer': ('skimre',),
'skimres': ('skimre',),
'skimret': ('skimre',),
'skimt': ('skimte',),
'skimta': ('skimte',),
'skimte': ('skimte',),
'skimter': ('skimte',),
'skimtes': ('skimte',),
'skimtet': ('skimte',),
'skingr': ('skingre',),
'skingra': ('skingre',),
'skingre': ('skingre',),
'skingrer': ('skingre',),
'skingres': ('skingre',),
'skingret': ('skingre',),
'skein': ('skinne',),
'skinn': ('skinne',),
'skinne': ('skinne',),
'skinner': ('skinne',),
'skinnes': ('skinne',),
'skint': ('skinne',),
'skinte': ('skinne',),
'skip': ('skipe',),
'skipa': ('skipe',),
'skipe': ('skipe',),
'skiper': ('skipe',),
'skipes': ('skipe',),
'skipet': ('skipe',),
'skip': ('skipe',),
'skipa': ('skipe',),
'skipe': ('skipe',),
'skiper': ('skipe',),
'skipes': ('skipe',),
'skipet': ('skipe',),
'skipl': ('skiple',),
'skipla': ('skiple',),
'skiple': ('skiple',),
'skipler': ('skiple',),
'skiples': ('skiple',),
'skiplet': ('skiple',),
'skisser': ('skissere',),
'skissere': ('skissere',),
'skisserer': ('skissere',),
'skisseres': ('skissere',),
'skissert': ('skissere',),
'skisserte': ('skissere',),
'skeit': ('skite',),
'skit': ('skite',),
'skite': ('skite',),
'skiter': ('skite',),
'skites': ('skite',),
'skitt': ('skite',),
'skjet': ('skite',),
'skitn': ('skitne',),
'skitna': ('skitne',),
'skitne': ('skitne',),
'skitner': ('skitne',),
'skitnes': ('skitne',),
'skitnet': ('skitne',),
'skiv': ('skive',),
'skiva': ('skive',),
'skive': ('skive',),
'skiver': ('skive',),
'skives': ('skive',),
'skivet': ('skive',),
'skje': ('skje',),
'skjedd': ('skje',),
'skjedde': ('skje',),
'skjer': ('skje',),
'skjes': ('skje',),
'skjeft': ('skjefte',),
'skjefta': ('skjefte',),
'skjefte': ('skjefte',),
'skjefter': ('skjefte',),
'skjeftes': ('skjefte',),
'skjeftet': ('skjefte',),
'skjel': ('skjele',),
'skjele': ('skjele',),
'skjeler': ('skjele',),
'skjeles': ('skjele',),
'skjelt': ('skjele',),
'skjelte': ('skjele',),
'skjeletter': ('skjelettere',),
'skjelettere': ('skjelettere',),
'skjeletterer': ('skjelettere',),
'skjeletteres': ('skjelettere',),
'skjelettert': ('skjelettere',),
'skjeletterte': ('skjelettere',),
'skjell': ('skjelle',),
'skjelle': ('skjelle',),
'skjeller': ('skjelle',),
'skjelles': ('skjelle',),
'skjelt': ('skjelle',),
'skjelte': ('skjelle',),
'skjell': ('skjelle',),
'skjelle': ('skjelle',),
'skjeller': ('skjelle',),
'skjelles': ('skjelle',),
'skjelt': ('skjelle',),
'skjelte': ('skjelle',),
'skjelm': ('skjelme',),
'skjelma': ('skjelme',),
'skjelme': ('skjelme',),
'skjelmer': ('skjelme',),
'skjelmes': ('skjelme',),
'skjelmet': ('skjelme',),
'skjeln': ('skjelne',),
'skjelna': ('skjelne',),
'skjelne': ('skjelne',),
'skjelner': ('skjelne',),
'skjelnes': ('skjelne',),
'skjelnet': ('skjelne',),
'skalv': ('skjelve',),
'skjelv': ('skjelve',),
'skjelve': ('skjelve',),
'skjelver': ('skjelve',),
'skjelves': ('skjelve',),
'skjelvet': ('skjelve',),
'skjematiser': ('skjematisere',),
'skjematisere': ('skjematisere',),
'skjematiserer': ('skjematisere',),
'skjematiseres': ('skjematisere',),
'skjematisert': ('skjematisere',),
'skjematiserte': ('skjematisere',),
'skjem': ('skjemme',),
'skjemme': ('skjemme',),
'skjemmer': ('skjemme',),
'skjemmes': ('skjemme',),
'skjemmet': ('skjemme',),
'skjemt': ('skjemme',),
'skjemte': ('skjemme',),
'skjemmes': ('skjemmes',),
'skjems': ('skjemmes',),
'skjemtes': ('skjemmes',),
'skjemt': ('skjemte',),
'skjemta': ('skjemte',),
'skjemte': ('skjemte',),
'skjemter': ('skjemte',),
'skjemtes': ('skjemte',),
'skjemtet': ('skjemte',),
'skjend': ('skjende',),
'skjenda': ('skjende',),
'skjende': ('skjende',),
'skjender': ('skjende',),
'skjendes': ('skjende',),
'skjendet': ('skjende',),
'skjen': ('skjene',),
'skjena': ('skjene',),
'skjene': ('skjene',),
'skjener': ('skjene',),
'skjenes': ('skjene',),
'skjenet': ('skjene',),
'skjent': ('skjene',),
'skjente': ('skjene',),
'skjenk': ('skjenke',),
'skjenka': ('skjenke',),
'skjenke': ('skjenke',),
'skjenker': ('skjenke',),
'skjenkes': ('skjenke',),
'skjenket': ('skjenke',),
'skjenkt': ('skjenke',),
'skjenkte': ('skjenke',),
'skjenn': ('skjenne',),
'skjenne': ('skjenne',),
'skjenner': ('skjenne',),
'skjennes': ('skjenne',),
'skjent': ('skjenne',),
'skjente': ('skjenne',),
'skjerm': ('skjerme',),
'skjerma': ('skjerme',),
'skjerme': ('skjerme',),
'skjermer': ('skjerme',),
'skjermes': ('skjerme',),
'skjermet': ('skjerme',),
'skjerp': ('skjerpe',),
'skjerpa': ('skjerpe',),
'skjerpe': ('skjerpe',),
'skjerper': ('skjerpe',),
'skjerpes': ('skjerpe',),
'skjerpet': ('skjerpe',),
'skjerp': ('skjerpe',),
'skjerpa': ('skjerpe',),
'skjerpe': ('skjerpe',),
'skjerper': ('skjerpe',),
'skjerpes': ('skjerpe',),
'skjerpet': ('skjerpe',),
'skjold': ('skjolde',),
'skjolda': ('skjolde',),
'skjolde': ('skjolde',),
'skjolder': ('skjolde',),
'skjoldes': ('skjolde',),
'skjoldet': ('skjolde',),
'skjul': ('skjule',),
'skjule': ('skjule',),
'skjuler': ('skjule',),
'skjules': ('skjule',),
'skjult': ('skjule',),
'skjulte': ('skjule',),
'skar': ('skjære',),
'skjær': ('skjære',),
'skjære': ('skjære',),
'skjærer': ('skjære',),
'skjæres': ('skjære',),
'skåret': ('skjære',),
'skjærn': ('skjærne',),
'skjærna': ('skjærne',),
'skjærne': ('skjærne',),
'skjærner': ('skjærne',),
'skjærnes': ('skjærne',),
'skjærnet': ('skjærne',),
'skjønn': ('skjønne',),
'skjønne': ('skjønne',),
'skjønner': ('skjønne',),
'skjønnes': ('skjønne',),
'skjønt': ('skjønne',),
'skjønte': ('skjønne',),
'skjønnmal': ('skjønnmale',),
'skjønnmale': ('skjønnmale',),
'skjønnmaler': ('skjønnmale',),
'skjønnmales': ('skjønnmale',),
'skjønnmalt': ('skjønnmale',),
'skjønnmalte': ('skjønnmale',),
'skjønnslign': ('skjønnsligne',),
'skjønnsligna': ('skjønnsligne',),
'skjønnsligne': ('skjønnsligne',),
'skjønnsligner': ('skjønnsligne',),
'skjønnslignes': ('skjønnsligne',),
'skjønnslignet': ('skjønnsligne',),
'skjønnslikn': ('skjønnslikne',),
'skjønnslikna': ('skjønnslikne',),
'skjønnslikne': ('skjønnslikne',),
'skjønnslikner': ('skjønnslikne',),
'skjønnsliknes': ('skjønnslikne',),
'skjønnsliknet': ('skjønnslikne',),
'skjørn': ('skjørne',),
'skjørna': ('skjørne',),
'skjørne': ('skjørne',),
'skjørner': ('skjørne',),
'skjørnes': ('skjørne',),
'skjørnet': ('skjørne',),
'skjørn': ('skjørne',),
'skjørna': ('skjørne',),
'skjørne': ('skjørne',),
'skjørner': ('skjørne',),
'skjørnes': ('skjørne',),
'skjørnet': ('skjørne',),
'skjørt': ('skjørte',),
'skjørta': ('skjørte',),
'skjørte': ('skjørte',),
'skjørter': ('skjørte',),
'skjørtes': ('skjørte',),
'skjørtet': ('skjørte',),
'skjøt': ('skjøte',),
'skjøte': ('skjøte',),
'skjøter': ('skjøte',),
'skjøtes': ('skjøte',),
'skjøtt': ('skjøte',),
'skjøtte': ('skjøte',),
'skjøt': ('skjøte',),
'skjøta': ('skjøte',),
'skjøte': ('skjøte',),
'skjøter': ('skjøte',),
'skjøtes': ('skjøte',),
'skjøtet': ('skjøte',),
'skjøtt': ('skjøte',),
'skjøtte': ('skjøte',),
'skjøtt': ('skjøtte',),
'skjøtta': ('skjøtte',),
'skjøtte': ('skjøtte',),
'skjøtter': ('skjøtte',),
'skjøttes': ('skjøtte',),
'skjøttet': ('skjøtte',),
'skle': ('skli',),
'skled': ('skli',),
'sklei': ('skli',),
'skleid': ('skli',),
'skli': ('skli',),
'sklidd': ('skli',),
'sklidde': ('skli',),
'sklir': ('skli',),
'sklis': ('skli',),
'sko': ('sko',),
'skodd': ('sko',),
'skodde': ('sko',),
'skor': ('sko',),
'skos': ('sko',),
'skoft': ('skofte',),
'skofta': ('skofte',),
'skofte': ('skofte',),
'skofter': ('skofte',),
'skoftes': ('skofte',),
'skoftet': ('skofte',),
'skogr': ('skogre',),
'skogra': ('skogre',),
'skogre': ('skogre',),
'skogrer': ('skogre',),
'skogres': ('skogre',),
'skogret': ('skogre',),
'skol': ('skole',),
'skole': ('skole',),
'skoler': ('skole',),
'skoles': ('skole',),
'skolt': ('skole',),
'skolte': ('skole',),
'skoler': ('skolere',),
'skolere': ('skolere',),
'skolerer': ('skolere',),
'skoleres': ('skolere',),
'skolert': ('skolere',),
'skolerte': ('skolere',),
'skolm': ('skolme',),
'skolma': ('skolme',),
'skolme': ('skolme',),
'skolmer': ('skolme',),
'skolmes': ('skolme',),
'skolmet': ('skolme',),
'skord': ('skorde',),
'skorda': ('skorde',),
'skorde': ('skorde',),
'skorder': ('skorde',),
'skordes': ('skorde',),
'skordet': ('skorde',),
'skor': ('skore',),
'skora': ('skore',),
'skore': ('skore',),
'skorer': ('skore',),
'skores': ('skore',),
'skoret': ('skore',),
'skorp': ('skorpe',),
'skorpa': ('skorpe',),
'skorpe': ('skorpe',),
'skorper': ('skorpe',),
'skorpes': ('skorpe',),
'skorpet': ('skorpe',),
'skort': ('skorte',),
'skorta': ('skorte',),
'skorte': ('skorte',),
'skorter': ('skorte',),
'skortes': ('skorte',),
'skortet': ('skorte',),
'skos': ('skose',),
'skosa': ('skose',),
'skose': ('skose',),
'skoser': ('skose',),
'skoses': ('skose',),
'skoset': ('skose',),
'skost': ('skose',),
'skoste': ('skose',),
'skott': ('skotte',),
'skotta': ('skotte',),
'skotte': ('skotte',),
'skotter': ('skotte',),
'skottes': ('skotte',),
'skottet': ('skotte',),
'skov': ('skove',),
'skova': ('skove',),
'skove': ('skove',),
'skover': ('skove',),
'skoves': ('skove',),
'skovet': ('skove',),
'skovl': ('skovle',),
'skovla': ('skovle',),
'skovle': ('skovle',),
'skovler': ('skovle',),
'skovles': ('skovle',),
'skovlet': ('skovle',),
'skrakl': ('skrakle',),
'skrakla': ('skrakle',),
'skrakle': ('skrakle',),
'skrakler': ('skrakle',),
'skrakles': ('skrakle',),
'skraklet': ('skrakle',),
'skrakl': ('skrakle',),
'skrakla': ('skrakle',),
'skrakle': ('skrakle',),
'skrakler': ('skrakle',),
'skrakles': ('skrakle',),
'skraklet': ('skrakle',),
'skrall': ('skralle',),
'skralla': ('skralle',),
'skralle': ('skralle',),
'skraller': ('skralle',),
'skralles': ('skralle',),
'skrallet': ('skralle',),
'skraml': ('skramle',),
'skramla': ('skramle',),
'skramle': ('skramle',),
'skramler': ('skramle',),
'skramles': ('skramle',),
'skramlet': ('skramle',),
'skrangl': ('skrangle',),
'skrangla': ('skrangle',),
'skrangle': ('skrangle',),
'skrangler': ('skrangle',),
'skrangles': ('skrangle',),
'skranglet': ('skrangle',),
'skrant': ('skrante',),
'skranta': ('skrante',),
'skrante': ('skrante',),
'skranter': ('skrante',),
'skrantes': ('skrante',),
'skrantet': ('skrante',),
'skrap': ('skrape',),
'skrapa': ('skrape',),
'skrape': ('skrape',),
'skraper': ('skrape',),
'skrapes': ('skrape',),
'skrapet': ('skrape',),
'skrapt': ('skrape',),
'skrapte': ('skrape',),
'skrapp': ('skrappe',),
'skrappa': ('skrappe',),
'skrappe': ('skrappe',),
'skrapper': ('skrappe',),
'skrappes': ('skrappe',),
'skrappet': ('skrappe',),
'skrasl': ('skrasle',),
'skrasla': ('skrasle',),
'skrasle': ('skrasle',),
'skrasler': ('skrasle',),
'skrasles': ('skrasle',),
'skraslet': ('skrasle',),
'skratl': ('skratle',),
'skratla': ('skratle',),
'skratle': ('skratle',),
'skratler': ('skratle',),
'skratles': ('skratle',),
'skratlet': ('skratle',),
'skratt': ('skratte',),
'skratta': ('skratte',),
'skratte': ('skratte',),
'skratter': ('skratte',),
'skrattes': ('skratte',),
'skrattet': ('skratte',),
'skrattle': ('skrattle',),
'skrattledd': ('skrattle',),
'skrattler': ('skrattle',),
'skrattles': ('skrattle',),
'skrattlo': ('skrattle',),
'skraver': ('skravere',),
'skravere': ('skravere',),
'skraverer': ('skravere',),
'skraveres': ('skravere',),
'skravert': ('skravere',),
'skraverte': ('skravere',),
'skravl': ('skravle',),
'skravla': ('skravle',),
'skravle': ('skravle',),
'skravler': ('skravle',),
'skravles': ('skravle',),
'skravlet': ('skravle',),
'skre': ('skre',),
'skredd': ('skre',),
'skredde': ('skre',),
'skrer': ('skre',),
'skres': ('skre',),
'skredderer': ('skredderere',),
'skredderere': ('skredderere',),
'skreddererer': ('skredderere',),
'skreddereres': ('skredderere',),
'skredderert': ('skredderere',),
'skreddererte': ('skredderere',),
'skreddersy': ('skreddersy',),
'skreddersydd': ('skreddersy',),
'skreddersydde': ('skreddersy',),
'skreddersyr': ('skreddersy',),
'skreddersys': ('skreddersy',),
'skrall': ('skrelle',),
'skrell': ('skrelle',),
'skrelle': ('skrelle',),
'skreller': ('skrelle',),
'skrelles': ('skrelle',),
'skrelt': ('skrelle',),
'skrelte': ('skrelle',),
'skrell': ('skrelle',),
'skrella': ('skrelle',),
'skrelle': ('skrelle',),
'skreller': ('skrelle',),
'skrelles': ('skrelle',),
'skrellet': ('skrelle',),
'skrelt': ('skrelle',),
'skrelte': ('skrelle',),
'skrem': ('skremme',),
'skremme': ('skremme',),
'skremmer': ('skremme',),
'skremmes': ('skremme',),
'skremt': ('skremme',),
'skremte': ('skremme',),
'skrens': ('skrense',),
'skrensa': ('skrense',),
'skrense': ('skrense',),
'skrenser': ('skrense',),
'skrenses': ('skrense',),
'skrenset': ('skrense',),
'skrepp': ('skreppe',),
'skreppa': ('skreppe',),
'skreppe': ('skreppe',),
'skrepper': ('skreppe',),
'skreppes': ('skreppe',),
'skreppet': ('skreppe',),
'skrept': ('skreppe',),
'skrepte': ('skreppe',),
'skrev': ('skreve',),
'skreva': ('skreve',),
'skrevd': ('skreve',),
'skrevde': ('skreve',),
'skreve': ('skreve',),
'skrever': ('skreve',),
'skreves': ('skreve',),
'skrevet': ('skreve',),
'skred': ('skri',),
'skredet': ('skri',),
'skrei': ('skri',),
'skreid': ('skri',),
'skri': ('skri',),
'skrir': ('skri',),
'skris': ('skri',),
'skribl': ('skrible',),
'skribla': ('skrible',),
'skrible': ('skrible',),
'skribler': ('skrible',),
'skribles': ('skrible',),
'skriblet': ('skrible',),
'skred': ('skride',),
'skredet': ('skride',),
'skrei': ('skride',),
'skreid': ('skride',),
'skrid': ('skride',),
'skride': ('skride',),
'skrider': ('skride',),
'skrides': ('skride',),
'skrift': ('skrifte',),
'skrifta': ('skrifte',),
'skrifte': ('skrifte',),
'skrifter': ('skrifte',),
'skriftes': ('skrifte',),
'skriftet': ('skrifte',),
'skriftfest': ('skriftfeste',),
'skriftfesta': ('skriftfeste',),
'skriftfeste': ('skriftfeste',),
'skriftfester': ('skriftfeste',),
'skriftfestes': ('skriftfeste',),
'skriftfestet': ('skriftfeste',),
'skreik': ('skrike',),
'skrek': ('skrike',),
'skreket': ('skrike',),
'skrik': ('skrike',),
'skrike': ('skrike',),
'skriker': ('skrike',),
'skrikes': ('skrike',),
'skrinla': ('skrinlegge',),
'skrinlagt': ('skrinlegge',),
'skrinlegg': ('skrinlegge',),
'skrinlegge': ('skrinlegge',),
'skrinlegger': ('skrinlegge',),
'skrinlegges': ('skrinlegge',),
'skritt': ('skritte',),
'skritta': ('skritte',),
'skritte': ('skritte',),
'skritter': ('skritte',),
'skrittes': ('skritte',),
'skrittet': ('skritte',),
'skreiv': ('skrive',),
'skrev': ('skrive',),
'skrevet': ('skrive',),
'skriv': ('skrive',),
'skrive': ('skrive',),
'skriver': ('skrive',),
'skrives': ('skrive',),
'skrot': ('skrote',),
'skrota': ('skrote',),
'skrote': ('skrote',),
'skroter': ('skrote',),
'skrotes': ('skrote',),
'skrotet': ('skrote',),
'skru': ('skru',),
'skrudd': ('skru',),
'skrudde': ('skru',),
'skrur': ('skru',),
'skrus': ('skru',),
'skru': ('skru',),
'skrudd': ('skru',),
'skrudde': ('skru',),
'skrur': ('skru',),
'skrus': ('skru',),
'skru': ('skru',),
'skrudd': ('skru',),
'skrudde': ('skru',),
'skrur': ('skru',),
'skrus': ('skru',),
'skrubb': ('skrubbe',),
'skrubba': ('skrubbe',),
'skrubbe': ('skrubbe',),
'skrubber': ('skrubbe',),
'skrubbes': ('skrubbe',),
'skrubbet': ('skrubbe',),
'skru': ('skrue',),
'skrudd': ('skrue',),
'skrudde': ('skrue',),
'skrue': ('skrue',),
'skruer': ('skrue',),
'skrues': ('skrue',),
'skru': ('skrue',),
'skrudd': ('skrue',),
'skrudde': ('skrue',),
'skrue': ('skrue',),
'skruer': ('skrue',),
'skrues': ('skrue',),
'skru': ('skrue',),
'skrudd': ('skrue',),
'skrudde': ('skrue',),
'skrue': ('skrue',),
'skruer': ('skrue',),
'skrues': ('skrue',),
'skrukk': ('skrukke',),
'skrukka': ('skrukke',),
'skrukke': ('skrukke',),
'skrukker': ('skrukke',),
'skrukkes': ('skrukke',),
'skrukket': ('skrukke',),
'skrump': ('skrumpe',),
'skrumpa': ('skrumpe',),
'skrumpe': ('skrumpe',),
'skrumper': ('skrumpe',),
'skrumpes': ('skrumpe',),
'skrumpet': ('skrumpe',),
'skruv': ('skruve',),
'skruvd': ('skruve',),
'skruvde': ('skruve',),
'skruve': ('skruve',),
'skruver': ('skruve',),
'skruves': ('skruve',),
'skruv': ('skruve',),
'skruvd': ('skruve',),
'skruvde': ('skruve',),
'skruve': ('skruve',),
'skruver': ('skruve',),
'skruves': ('skruve',),
'skruv': ('skruve',),
'skruvd': ('skruve',),
'skruvde': ('skruve',),
'skruve': ('skruve',),
'skruver': ('skruve',),
'skruves': ('skruve',),
'skryt': ('skryte',),
'skryte': ('skryte',),
'skryter': ('skryte',),
'skrytes': ('skryte',),
'skrytt': ('skryte',),
'skrytte': ('skryte',),
'skrøt': ('skryte',),
'skrøyt': ('skryte',),
'skrå': ('skrå',),
'skrådd': ('skrå',),
'skrådde': ('skrå',),
'skrår': ('skrå',),
'skrås': ('skrå',),
'skrå': ('skrå',),
'skrådd': ('skrå',),
'skrådde': ('skrå',),
'skrår': ('skrå',),
'skrås': ('skrå',),
'skrål': ('skråle',),
'skråle': ('skråle',),
'skråler': ('skråle',),
'skråles': ('skråle',),
'skrålt': ('skråle',),
'skrålte': ('skråle',),
'skrån': ('skråne',),
'skråna': ('skråne',),
'skråne': ('skråne',),
'skråner': ('skråne',),
'skrånes': ('skråne',),
'skrånet': ('skråne',),
'skrånt': ('skråne',),
'skrånte': ('skråne',),
'skråsatt': ('skråsette',),
'skråsatte': ('skråsette',),
'skråsett': ('skråsette',),
'skråsette': ('skråsette',),
'skråsetter': ('skråsette',),
'skråsettes': ('skråsette',),
'skråstill': ('skråstille',),
'skråstille': ('skråstille',),
'skråstiller': ('skråstille',),
'skråstilles': ('skråstille',),
'skråstilt': ('skråstille',),
'skråstilte': ('skråstille',),
'skrø': ('skrø',),
'skrødd': ('skrø',),
'skrødde': ('skrø',),
'skrør': ('skrø',),
'skrøs': ('skrø',),
'skrøft': ('skrøfte',),
'skrøfta': ('skrøfte',),
'skrøfte': ('skrøfte',),
'skrøfter': ('skrøfte',),
'skrøftes': ('skrøfte',),
'skrøftet': ('skrøfte',),
'skrømt': ('skrømte',),
'skrømta': ('skrømte',),
'skrømte': ('skrømte',),
'skrømter': ('skrømte',),
'skrømtes': ('skrømte',),
'skrømtet': ('skrømte',),
'skrøn': ('skrøne',),
'skrøne': ('skrøne',),
'skrøner': ('skrøne',),
'skrønes': ('skrøne',),
'skrønt': ('skrøne',),
'skrønte': ('skrøne',),
'skubb': ('skubbe',),
'skubba': ('skubbe',),
'skubbe': ('skubbe',),
'skubber': ('skubbe',),
'skubbes': ('skubbe',),
'skubbet': ('skubbe',),
'sku': ('skue',),
'skua': ('skue',),
'skue': ('skue',),
'skuer': ('skue',),
'skues': ('skue',),
'skuet': ('skue',),
'skuff': ('skuffe',),
'skuffa': ('skuffe',),
'skuffe': ('skuffe',),
'skuffer': ('skuffe',),
'skuffes': ('skuffe',),
'skuffet': ('skuffe',),
'skuff': ('skuffe',),
'skuffa': ('skuffe',),
'skuffe': ('skuffe',),
'skuffer': ('skuffe',),
'skuffes': ('skuffe',),
'skuffet': ('skuffe',),
'skufl': ('skufle',),
'skufla': ('skufle',),
'skufle': ('skufle',),
'skufler': ('skufle',),
'skufles': ('skufle',),
'skuflet': ('skufle',),
'skul': ('skule',),
'skule': ('skule',),
'skuler': ('skule',),
'skules': ('skule',),
'skult': ('skule',),
'skulte': ('skule',),
'skulk': ('skulke',),
'skulka': ('skulke',),
'skulke': ('skulke',),
'skulker': ('skulke',),
'skulkes': ('skulke',),
'skulket': ('skulke',),
'skal': ('skulle',),
'skulle': ('skulle',),
'skullet': ('skulle',),
'skulpter': ('skulptere',),
'skulptere': ('skulptere',),
'skulpterer': ('skulptere',),
'skulpteres': ('skulptere',),
'skulptert': ('skulptere',),
'skulpterte': ('skulptere',),
'skuls': ('skulse',),
'skulsa': ('skulse',),
'skulse': ('skulse',),
'skulser': ('skulse',),
'skulses': ('skulse',),
'skulset': ('skulse',),
'skumkjør': ('skumkjøre',),
'skumkjøre': ('skumkjøre',),
'skumkjører': ('skumkjøre',),
'skumkjøres': ('skumkjøre',),
'skumkjørt': ('skumkjøre',),
'skumkjørte': ('skumkjøre',),
'skuml': ('skumle',),
'skumla': ('skumle',),
'skumle': ('skumle',),
'skumler': ('skumle',),
'skumles': ('skumle',),
'skumlet': ('skumle',),
'skumles': ('skumlese',),
'skumlese': ('skumlese',),
'skumleser': ('skumlese',),
'skumleses': ('skumlese',),
'skumlest': ('skumlese',),
'skumleste': ('skumlese',),
'skum': ('skumme',),
'skumma': ('skumme',),
'skumme': ('skumme',),
'skummer': ('skumme',),
'skummes': ('skumme',),
'skummet': ('skumme',),
'skump': ('skumpe',),
'skumpa': ('skumpe',),
'skumpe': ('skumpe',),
'skumper': ('skumpe',),
'skumpes': ('skumpe',),
'skumpet': ('skumpe',),
'skumpisk': ('skumpiske',),
'skumpiska': ('skumpiske',),
'skumpiske': ('skumpiske',),
'skumpisker': ('skumpiske',),
'skumpiskes': ('skumpiske',),
'skumpisket': ('skumpiske',),
'skumpl': ('skumple',),
'skumpla': ('skumple',),
'skumple': ('skumple',),
'skumpler': ('skumple',),
'skumples': ('skumple',),
'skumplet': ('skumple',),
'skumr': ('skumre',),
'skumra': ('skumre',),
'skumre': ('skumre',),
'skumrer': ('skumre',),
'skumres': ('skumre',),
'skumret': ('skumre',),
'skumtygd': ('skumtygge',),
'skumtygde': ('skumtygge',),
'skumtygg': ('skumtygge',),
'skumtygge': ('skumtygge',),
'skumtygger': ('skumtygge',),
'skumtygges': ('skumtygge',),
'skumtygget': ('skumtygge',),
'skur': ('skure',),
'skura': ('skure',),
'skure': ('skure',),
'skurer': ('skure',),
'skures': ('skure',),
'skuret': ('skure',),
'skurt': ('skure',),
'skurte': ('skure',),
'skurr': ('skurre',),
'skurra': ('skurre',),
'skurre': ('skurre',),
'skurrer': ('skurre',),
'skurres': ('skurre',),
'skurret': ('skurre',),
'skusl': ('skusle',),
'skusla': ('skusle',),
'skusle': ('skusle',),
'skusler': ('skusle',),
'skusles': ('skusle',),
'skuslet': ('skusle',),
'skutl': ('skutle',),
'skutla': ('skutle',),
'skutle': ('skutle',),
'skutler': ('skutle',),
'skutles': ('skutle',),
'skutlet': ('skutle',),
'skutt': ('skutte',),
'skutta': ('skutte',),
'skutte': ('skutte',),
'skutter': ('skutte',),
'skuttes': ('skutte',),
'skuttet': ('skutte',),
'skuv': ('skuve',),
'skuvd': ('skuve',),
'skuvde': ('skuve',),
'skuve': ('skuve',),
'skuver': ('skuve',),
'skuves': ('skuve',),
'skuv': ('skuve',),
'skuvd': ('skuve',),
'skuvde': ('skuve',),
'skuve': ('skuve',),
'skuver': ('skuve',),
'skuves': ('skuve',),
'skvadroner': ('skvadronere',),
'skvadronere': ('skvadronere',),
'skvadronerer': ('skvadronere',),
'skvadroneres': ('skvadronere',),
'skvadronert': ('skvadronere',),
'skvadronerte': ('skvadronere',),
'skvaldr': ('skvaldre',),
'skvaldra': ('skvaldre',),
'skvaldre': ('skvaldre',),
'skvaldrer': ('skvaldre',),
'skvaldres': ('skvaldre',),
'skvaldret': ('skvaldre',),
'skval': ('skvale',),
'skvala': ('skvale',),
'skvale': ('skvale',),
'skvaler': ('skvale',),
'skvales': ('skvale',),
'skvalet': ('skvale',),
'skvalt': ('skvale',),
'skvalte': ('skvale',),
'skvalp': ('skvalpe',),
'skvalpa': ('skvalpe',),
'skvalpe': ('skvalpe',),
'skvalper': ('skvalpe',),
'skvalpes': ('skvalpe',),
'skvalpet': ('skvalpe',),
'skvatr': ('skvatre',),
'skvatra': ('skvatre',),
'skvatre': ('skvatre',),
'skvatrer': ('skvatre',),
'skvatres': ('skvatre',),
'skvatret': ('skvatre',),
'skvett': ('skvette',),
'skvetta': ('skvette',),
'skvette': ('skvette',),
'skvetter': ('skvette',),
'skvettes': ('skvette',),
'skvettet': ('skvette',),
'skvatt': ('skvette',),
'skvett': ('skvette',),
'skvette': ('skvette',),
'skvetter': ('skvette',),
'skvettes': ('skvette',),
'skvettet': ('skvette',),
'skvis': ('skvise',),
'skvisa': ('skvise',),
'skvise': ('skvise',),
'skviser': ('skvise',),
'skvises': ('skvise',),
'skviset': ('skvise',),
'skvist': ('skvise',),
'skviste': ('skvise',),
'skvulp': ('skvulpe',),
'skvulpa': ('skvulpe',),
'skvulpe': ('skvulpe',),
'skvulper': ('skvulpe',),
'skvulpes': ('skvulpe',),
'skvulpet': ('skvulpe',),
'skvær': ('skvære',),
'skværa': ('skvære',),
'skvære': ('skvære',),
'skværer': ('skvære',),
'skværes': ('skvære',),
'skværet': ('skvære',),
'skvært': ('skvære',),
'skværte': ('skvære',),
'sky': ('sky',),
'skydd': ('sky',),
'skydde': ('sky',),
'skyr': ('sky',),
'skys': ('sky',),
'sky': ('skye',),
'skya': ('skye',),
'skye': ('skye',),
'skyer': ('skye',),
'skyes': ('skye',),
'skyet': ('skye',),
'skyfl': ('skyfle',),
'skyfla': ('skyfle',),
'skyfle': ('skyfle',),
'skyfler': ('skyfle',),
'skyfles': ('skyfle',),
'skyflet': ('skyfle',),
'skygd': ('skygge',),
'skygde': ('skygge',),
'skygg': ('skygge',),
'skygga': ('skygge',),
'skygge': ('skygge',),
'skygger': ('skygge',),
'skygges': ('skygge',),
'skygget': ('skygge',),
'skygd': ('skygge',),
'skygde': ('skygge',),
'skygg': ('skygge',),
'skygga': ('skygge',),
'skygge': ('skygge',),
'skygger': ('skygge',),
'skygges': ('skygge',),
'skygget': ('skygge',),
'skyggela': ('skyggelegge',),
'skyggelagt': ('skyggelegge',),
'skyggelegg': ('skyggelegge',),
'skyggelegge': ('skyggelegge',),
'skyggelegger': ('skyggelegge',),
'skyggelegges': ('skyggelegge',),
'skyld': ('skylde',),
'skylde': ('skylde',),
'skylder': ('skylde',),
'skyldes': ('skylde',),
'skyldt': ('skylde',),
'skyldte': ('skylde',),
'skyldes': ('skyldes',),
'skyldtes': ('skyldes',),
'skyldsatt': ('skyldsette',),
'skyldsatte': ('skyldsette',),
'skyldsett': ('skyldsette',),
'skyldsette': ('skyldsette',),
'skyldsetter': ('skyldsette',),
'skyldsettes': ('skyldsette',),
'skyll': ('skylle',),
'skylla': ('skylle',),
'skylle': ('skylle',),
'skyller': ('skylle',),
'skylles': ('skylle',),
'skyllet': ('skylle',),
'skylt': ('skylle',),
'skylte': ('skylle',),
'skynd': ('skynde',),
'skynda': ('skynde',),
'skynde': ('skynde',),
'skynder': ('skynde',),
'skyndes': ('skynde',),
'skyndet': ('skynde',),
'skyndt': ('skynde',),
'skyndte': ('skynde',),
'skyss': ('skysse',),
'skyssa': ('skysse',),
'skysse': ('skysse',),
'skysser': ('skysse',),
'skysses': ('skysse',),
'skysset': ('skysse',),
'skaut': ('skyte',),
'skjøt': ('skyte',),
'skutt': ('skyte',),
'skyt': ('skyte',),
'skyte': ('skyte',),
'skyter': ('skyte',),
'skytes': ('skyte',),
'skøyt': ('skyte',),
'skauv': ('skyve',),
'skjøv': ('skyve',),
'skjøvet': ('skyve',),
'skyv': ('skyve',),
'skyvd': ('skyve',),
'skyve': ('skyve',),
'skyver': ('skyve',),
'skyves': ('skyve',),
'skøyv': ('skyve',),
'skauv': ('skyve',),
'skjøv': ('skyve',),
'skjøvet': ('skyve',),
'skyv': ('skyve',),
'skyvd': ('skyve',),
'skyve': ('skyve',),
'skyver': ('skyve',),
'skyves': ('skyve',),
'skøyv': ('skyve',),
'skåld': ('skålde',),
'skålda': ('skålde',),
'skålde': ('skålde',),
'skålder': ('skålde',),
'skåldes': ('skålde',),
'skåldet': ('skålde',),
'skål': ('skåle',),
'skåle': ('skåle',),
'skåler': ('skåle',),
'skåles': ('skåle',),
'skålt': ('skåle',),
'skålte': ('skåle',),
'skån': ('skåne',),
'skåna': ('skåne',),
'skåne': ('skåne',),
'skåner': ('skåne',),
'skånes': ('skåne',),
'skånet': ('skåne',),
'skånt': ('skåne',),
'skånte': ('skåne',),
'skår': ('skåre',),
'skåra': ('skåre',),
'skåre': ('skåre',),
'skårer': ('skåre',),
'skåres': ('skåre',),
'skåret': ('skåre',),
'skår': ('skåre',),
'skåra': ('skåre',),
'skåre': ('skåre',),
'skårer': ('skåre',),
'skåres': ('skåre',),
'skåret': ('skåre',),
'skår': ('skåre',),
'skåra': ('skåre',),
'skåre': ('skåre',),
'skårer': ('skåre',),
'skåres': ('skåre',),
'skåret': ('skåre',),
'skårla': ('skårlegge',),
'skårlagt': ('skårlegge',),
'skårlegg': ('skårlegge',),
'skårlegge': ('skårlegge',),
'skårlegger': ('skårlegge',),
'skårlegges': ('skårlegge',),
'skåt': ('skåte',),
'skåta': ('skåte',),
'skåte': ('skåte',),
'skåter': ('skåte',),
'skåtes': ('skåte',),
'skåtet': ('skåte',),
'skøy': ('skøye',),
'skøya': ('skøye',),
'skøye': ('skøye',),
'skøyer': ('skøye',),
'skøyes': ('skøye',),
'skøyet': ('skøye',),
'skøyt': ('skøyte',),
'skøyta': ('skøyte',),
'skøyte': ('skøyte',),
'skøyter': ('skøyte',),
'skøytes': ('skøyte',),
'skøytet': ('skøyte',),
'slabb': ('slabbe',),
'slabba': ('slabbe',),
'slabbe': ('slabbe',),
'slabber': ('slabbe',),
'slabbes': ('slabbe',),
'slabbet': ('slabbe',),
'sladd': ('sladde',),
'sladda': ('sladde',),
'sladde': ('sladde',),
'sladder': ('sladde',),
'sladdes': ('sladde',),
'sladdet': ('sladde',),
'sladd': ('sladde',),
'sladda': ('sladde',),
'sladde': ('sladde',),
'sladder': ('sladde',),
'sladdes': ('sladde',),
'sladdet': ('sladde',),
'sladr': ('sladre',),
'sladra': ('sladre',),
'sladre': ('sladre',),
'sladrer': ('sladre',),
'sladres': ('sladre',),
'sladret': ('sladre',),
'slafs': ('slafse',),
'slafsa': ('slafse',),
'slafse': ('slafse',),
'slafser': ('slafse',),
'slafses': ('slafse',),
'slafset': ('slafse',),
'slag': ('slage',),
'slaga': ('slage',),
'slage': ('slage',),
'slager': ('slage',),
'slages': ('slage',),
'slaget': ('slage',),
'slagg': ('slagge',),
'slagga': ('slagge',),
'slagge': ('slagge',),
'slagger': ('slagge',),
'slagges': ('slagge',),
'slagget': ('slagge',),
'slakk': ('slakke',),
'slakka': ('slakke',),
'slakke': ('slakke',),
'slakker': ('slakke',),
'slakkes': ('slakke',),
'slakket': ('slakke',),
'slakn': ('slakne',),
'slakna': ('slakne',),
'slakne': ('slakne',),
'slakner': ('slakne',),
'slaknes': ('slakne',),
'slaknet': ('slakne',),
'slakt': ('slakte',),
'slakta': ('slakte',),
'slakte': ('slakte',),
'slakter': ('slakte',),
'slaktes': ('slakte',),
'slaktet': ('slakte',),
'slam': ('slamme',),
'slamma': ('slamme',),
'slamme': ('slamme',),
'slammer': ('slamme',),
'slammes': ('slamme',),
'slammet': ('slamme',),
'slamp': ('slampe',),
'slampa': ('slampe',),
'slampe': ('slampe',),
'slamper': ('slampe',),
'slampes': ('slampe',),
'slampet': ('slampe',),
'slamr': ('slamre',),
'slamra': ('slamre',),
'slamre': ('slamre',),
'slamrer': ('slamre',),
'slamres': ('slamre',),
'slamret': ('slamre',),
'slams': ('slamse',),
'slamsa': ('slamse',),
'slamse': ('slamse',),
'slamser': ('slamse',),
'slamses': ('slamse',),
'slamset': ('slamse',),
'slang': ('slange',),
'slanga': ('slange',),
'slange': ('slange',),
'slanger': ('slange',),
'slanges': ('slange',),
'slanget': ('slange',),
'slank': ('slanke',),
'slanka': ('slanke',),
'slanke': ('slanke',),
'slanker': ('slanke',),
'slankes': ('slanke',),
'slanket': ('slanke',),
'slapn': ('slapne',),
'slapna': ('slapne',),
'slapne': ('slapne',),
'slapner': ('slapne',),
'slapnes': ('slapne',),
'slapnet': ('slapne',),
'slapp': ('slappe',),
'slappa': ('slappe',),
'slappe': ('slappe',),
'slapper': ('slappe',),
'slappes': ('slappe',),
'slappet': ('slappe',),
'slark': ('slarke',),
'slarka': ('slarke',),
'slarke': ('slarke',),
'slarker': ('slarke',),
'slarkes': ('slarke',),
'slarket': ('slarke',),
'slarv': ('slarve',),
'slarva': ('slarve',),
'slarve': ('slarve',),
'slarver': ('slarve',),
'slarves': ('slarve',),
'slarvet': ('slarve',),
'slask': ('slaske',),
'slaska': ('slaske',),
'slaske': ('slaske',),
'slasker': ('slaske',),
'slaskes': ('slaske',),
'slasket': ('slaske',),
'slaur': ('slaure',),
'slaura': ('slaure',),
'slaure': ('slaure',),
'slaurer': ('slaure',),
'slaures': ('slaure',),
'slauret': ('slaure',),
'slav': ('slave',),
'slava': ('slave',),
'slave': ('slave',),
'slaver': ('slave',),
'slaves': ('slave',),
'slavet': ('slave',),
'slavebandt': ('slavebinde',),
'slavebind': ('slavebinde',),
'slavebinde': ('slavebinde',),
'slavebinder': ('slavebinde',),
'slavebindes': ('slavebinde',),
'slavebundet': ('slavebinde',),
'slegg': ('slegge',),
'slegga': ('slegge',),
'slegge': ('slegge',),
'slegger': ('slegge',),
'slegges': ('slegge',),
'slegget': ('slegge',),
'sleik': ('sleike',),
'sleika': ('sleike',),
'sleike': ('sleike',),
'sleiker': ('sleike',),
'sleikes': ('sleike',),
'sleiket': ('sleike',),
'sleikt': ('sleike',),
'sleikte': ('sleike',),
'sleiv': ('sleive',),
'sleiva': ('sleive',),
'sleivd': ('sleive',),
'sleivde': ('sleive',),
'sleive': ('sleive',),
'sleiver': ('sleive',),
'sleives': ('sleive',),
'sleivet': ('sleive',),
'slekt': ('slekte',),
'slekta': ('slekte',),
'slekte': ('slekte',),
'slekter': ('slekte',),
'slektes': ('slekte',),
'slektet': ('slekte',),
'slem': ('slemme',),
'slemma': ('slemme',),
'slemme': ('slemme',),
'slemmer': ('slemme',),
'slemmes': ('slemme',),
'slemmet': ('slemme',),
'slentr': ('slentre',),
'slentra': ('slentre',),
'slentre': ('slentre',),
'slentrer': ('slentre',),
'slentres': ('slentre',),
'slentret': ('slentre',),
'slep': ('slepe',),
'slepe': ('slepe',),
'sleper': ('slepe',),
'slepes': ('slepe',),
'slept': ('slepe',),
'slepte': ('slepe',),
'slesk': ('sleske',),
'sleska': ('sleske',),
'sleske': ('sleske',),
'slesker': ('sleske',),
'sleskes': ('sleske',),
'slesket': ('sleske',),
'sletn': ('sletne',),
'sletna': ('sletne',),
'sletne': ('sletne',),
'sletner': ('sletne',),
'sletnes': ('sletne',),
'sletnet': ('sletne',),
'slett': ('slette',),
'sletta': ('slette',),
'slette': ('slette',),
'sletter': ('slette',),
'slettes': ('slette',),
'slettet': ('slette',),
'slev': ('sleve',),
'sleva': ('sleve',),
'slevd': ('sleve',),
'slevde': ('sleve',),
'sleve': ('sleve',),
'slever': ('sleve',),
'sleves': ('sleve',),
'slevet': ('sleve',),
'slikk': ('slikke',),
'slikka': ('slikke',),
'slikke': ('slikke',),
'slikker': ('slikke',),
'slikkes': ('slikke',),
'slikket': ('slikke',),
'slim': ('slime',),
'slima': ('slime',),
'slime': ('slime',),
'slimer': ('slime',),
'slimes': ('slime',),
'slimet': ('slime',),
'slindbark': ('slindbarke',),
'slindbarka': ('slindbarke',),
'slindbarke': ('slindbarke',),
'slindbarker': ('slindbarke',),
'slindbarkes': ('slindbarke',),
'slindbarket': ('slindbarke',),
'slind': ('slinde',),
'slinda': ('slinde',),
'slinde': ('slinde',),
'slinder': ('slinde',),
'slindes': ('slinde',),
'slindet': ('slinde',),
'slindr': ('slindre',),
'slindra': ('slindre',),
'slindre': ('slindre',),
'slindrer': ('slindre',),
'slindres': ('slindre',),
'slindret': ('slindre',),
'slingr': ('slingre',),
'slingra': ('slingre',),
'slingre': ('slingre',),
'slingrer': ('slingre',),
'slingres': ('slingre',),
'slingret': ('slingre',),
'slip': ('slipe',),
'slipe': ('slipe',),
'sliper': ('slipe',),
'slipes': ('slipe',),
'slipt': ('slipe',),
'slipte': ('slipe',),
'slapp': ('slippe',),
'slipp': ('slippe',),
'slippe': ('slippe',),
'slipper': ('slippe',),
'slippes': ('slippe',),
'sluppet': ('slippe',),
'slisk': ('sliske',),
'sliska': ('sliske',),
'sliske': ('sliske',),
'slisker': ('sliske',),
'sliskes': ('sliske',),
'slisket': ('sliske',),
'sliss': ('slisse',),
'slissa': ('slisse',),
'slisse': ('slisse',),
'slisser': ('slisse',),
'slisses': ('slisse',),
'slisset': ('slisse',),
'sleit': ('slite',),
'slet': ('slite',),
'slit': ('slite',),
'slite': ('slite',),
'sliter': ('slite',),
'slites': ('slite',),
'slitt': ('slite',),
'slitn': ('slitne',),
'slitna': ('slitne',),
'slitne': ('slitne',),
'slitner': ('slitne',),
'slitnes': ('slitne',),
'slitnet': ('slitne',),
'slodd': ('slodde',),
'slodda': ('slodde',),
'slodde': ('slodde',),
'slodder': ('slodde',),
'sloddes': ('slodde',),
'sloddet': ('slodde',),
'slokk': ('slokke',),
'slokka': ('slokke',),
'slokke': ('slokke',),
'slokker': ('slokke',),
'slokkes': ('slokke',),
'slokket': ('slokke',),
'slokt': ('slokke',),
'slokte': ('slokke',),
'slokk': ('slokke',),
'slokka': ('slokke',),
'slokke': ('slokke',),
'slokker': ('slokke',),
'slokkes': ('slokke',),
'slokket': ('slokke',),
'slokt': ('slokke',),
'slokte': ('slokke',),
'slokn': ('slokne',),
'slokna': ('slokne',),
'slokne': ('slokne',),
'slokner': ('slokne',),
'sloknes': ('slokne',),
'sloknet': ('slokne',),
'slubb': ('slubbe',),
'slubba': ('slubbe',),
'slubbe': ('slubbe',),
'slubber': ('slubbe',),
'slubbes': ('slubbe',),
'slubbet': ('slubbe',),
'slubr': ('slubre',),
'slubra': ('slubre',),
'slubre': ('slubre',),
'slubrer': ('slubre',),
'slubres': ('slubre',),
'slubret': ('slubre',),
'sludd': ('sludde',),
'sludda': ('sludde',),
'sludde': ('sludde',),
'sludder': ('sludde',),
'sluddes': ('sludde',),
'sluddet': ('sludde',),
'sludr': ('sludre',),
'sludra': ('sludre',),
'sludre': ('sludre',),
'sludrer': ('sludre',),
'sludres': ('sludre',),
'sludret': ('sludre',),
'sluff': ('sluffe',),
'sluffa': ('sluffe',),
'sluffe': ('sluffe',),
'sluffer': ('sluffe',),
'sluffes': ('sluffe',),
'sluffet': ('sluffe',),
'slufs': ('slufse',),
'slufsa': ('slufse',),
'slufse': ('slufse',),
'slufser': ('slufse',),
'slufses': ('slufse',),
'slufset': ('slufse',),
'sluk': ('sluke',),
'sluke': ('sluke',),
'sluker': ('sluke',),
'slukes': ('sluke',),
'slukt': ('sluke',),
'slukte': ('sluke',),
'slukk': ('slukke',),
'slukka': ('slukke',),
'slukke': ('slukke',),
'slukker': ('slukke',),
'slukkes': ('slukke',),
'slukket': ('slukke',),
'slukt': ('slukke',),
'slukte': ('slukke',),
'slukk': ('slukke',),
'slukka': ('slukke',),
'slukke': ('slukke',),
'slukker': ('slukke',),
'slukkes': ('slukke',),
'slukket': ('slukke',),
'slukt': ('slukke',),
'slukte': ('slukke',),
'slukn': ('slukne',),
'slukna': ('slukne',),
'slukne': ('slukne',),
'slukner': ('slukne',),
'sluknes': ('slukne',),
'sluknet': ('slukne',),
'slump': ('slumpe',),
'slumpa': ('slumpe',),
'slumpe': ('slumpe',),
'slumper': ('slumpe',),
'slumpes': ('slumpe',),
'slumpet': ('slumpe',),
'slumr': ('slumre',),
'slumra': ('slumre',),
'slumre': ('slumre',),
'slumrer': ('slumre',),
'slumres': ('slumre',),
'slumret': ('slumre',),
'slums': ('slumse',),
'slumsa': ('slumse',),
'slumse': ('slumse',),
'slumser': ('slumse',),
'slumses': ('slumse',),
'slumset': ('slumse',),
'sluntr': ('sluntre',),
'sluntra': ('sluntre',),
'sluntre': ('sluntre',),
'sluntrer': ('sluntre',),
'sluntres': ('sluntre',),
'sluntret': ('sluntre',),
'slur': ('slure',),
'slura': ('slure',),
'slure': ('slure',),
'slurer': ('slure',),
'slures': ('slure',),
'sluret': ('slure',),
'slurt': ('slure',),
'slurte': ('slure',),
'slurk': ('slurke',),
'slurka': ('slurke',),
'slurke': ('slurke',),
'slurker': ('slurke',),
'slurkes': ('slurke',),
'slurket': ('slurke',),
'slurp': ('slurpe',),
'slurpa': ('slurpe',),
'slurpe': ('slurpe',),
'slurper': ('slurpe',),
'slurpes': ('slurpe',),
'slurpet': ('slurpe',),
'slurv': ('slurve',),
'slurva': ('slurve',),
'slurve': ('slurve',),
'slurver': ('slurve',),
'slurves': ('slurve',),
'slurvet': ('slurve',),
'slus': ('sluse',),
'slusa': ('sluse',),
'sluse': ('sluse',),
'sluser': ('sluse',),
'sluses': ('sluse',),
'sluset': ('sluse',),
'slusk': ('sluske',),
'sluska': ('sluske',),
'sluske': ('sluske',),
'slusker': ('sluske',),
'sluskes': ('sluske',),
'slusket': ('sluske',),
'slut': ('slute',),
'sluta': ('slute',),
'slute': ('slute',),
'sluter': ('slute',),
'slutes': ('slute',),
'slutet': ('slute',),
'slutt': ('slutte',),
'slutta': ('slutte',),
'slutte': ('slutte',),
'slutter': ('slutte',),
'sluttes': ('slutte',),
'sluttet': ('slutte',),
'sluttfør': ('sluttføre',),
'sluttføre': ('sluttføre',),
'sluttfører': ('sluttføre',),
'sluttføres': ('sluttføre',),
'sluttført': ('sluttføre',),
'sluttførte': ('sluttføre',),
'slyng': ('slynge',),
'slynga': ('slynge',),
'slynge': ('slynge',),
'slynger': ('slynge',),
'slynges': ('slynge',),
'slynget': ('slynge',),
'slyngt': ('slynge',),
'slyngte': ('slynge',),
'slo': ('slå',),
'slå': ('slå',),
'slåes': ('slå',),
'slår': ('slå',),
'slås': ('slå',),
'slått': ('slå',),
'sloss': ('slåss',),
'slåss': ('slåss',),
'sløkk': ('sløkke',),
'sløkka': ('sløkke',),
'sløkke': ('sløkke',),
'sløkker': ('sløkke',),
'sløkkes': ('sløkke',),
'sløkket': ('sløkke',),
'sløkt': ('sløkke',),
'sløkte': ('sløkke',),
'slør': ('sløre',),
'sløra': ('sløre',),
'sløre': ('sløre',),
'slører': ('sløre',),
'sløres': ('sløre',),
'sløret': ('sløre',),
'slørt': ('sløre',),
'slørte': ('sløre',),
'slør': ('sløre',),
'sløra': ('sløre',),
'sløre': ('sløre',),
'slører': ('sløre',),
'sløres': ('sløre',),
'sløret': ('sløre',),
'slørt': ('sløre',),
'slørte': ('sløre',),
'sløs': ('sløse',),
'sløse': ('sløse',),
'sløser': ('sløse',),
'sløses': ('sløse',),
'sløst': ('sløse',),
'sløste': ('sløse',),
'sløv': ('sløve',),
'sløva': ('sløve',),
'sløve': ('sløve',),
'sløver': ('sløve',),
'sløves': ('sløve',),
'sløvet': ('sløve',),
'sløvn': ('sløvne',),
'sløvna': ('sløvne',),
'sløvne': ('sløvne',),
'sløvner': ('sløvne',),
'sløvnes': ('sløvne',),
'sløvnet': ('sløvne',),
'sløyd': ('sløyde',),
'sløyda': ('sløyde',),
'sløyde': ('sløyde',),
'sløyder': ('sløyde',),
'sløydes': ('sløyde',),
'sløydet': ('sløyde',),
'sløyf': ('sløyfe',),
'sløyfa': ('sløyfe',),
'sløyfe': ('sløyfe',),
'sløyfer': ('sløyfe',),
'sløyfes': ('sløyfe',),
'sløyfet': ('sløyfe',),
'smadr': ('smadre',),
'smadra': ('smadre',),
'smadre': ('smadre',),
'smadrer': ('smadre',),
'smadres': ('smadre',),
'smadret': ('smadre',),
'smak': ('smake',),
'smaka': ('smake',),
'smake': ('smake',),
'smaker': ('smake',),
'smakes': ('smake',),
'smakt': ('smake',),
'smakte': ('smake',),
'smaksatt': ('smaksette',),
'smaksatte': ('smaksette',),
'smaksett': ('smaksette',),
'smaksette': ('smaksette',),
'smaksetter': ('smaksette',),
'smaksettes': ('smaksette',),
'smal': ('smale',),
'smala': ('smale',),
'smale': ('smale',),
'smaler': ('smale',),
'smales': ('smale',),
'smalet': ('smale',),
'smaln': ('smalne',),
'smalna': ('smalne',),
'smalne': ('smalne',),
'smalner': ('smalne',),
'smalnes': ('smalne',),
'smalnet': ('smalne',),
'smash': ('smashe',),
'smasha': ('smashe',),
'smashe': ('smashe',),
'smasher': ('smashe',),
'smashes': ('smashe',),
'smashet': ('smashe',),
'smask': ('smaske',),
'smaska': ('smaske',),
'smaske': ('smaske',),
'smasker': ('smaske',),
'smaskes': ('smaske',),
'smasket': ('smaske',),
'smatr': ('smatre',),
'smatra': ('smatre',),
'smatre': ('smatre',),
'smatrer': ('smatre',),
'smatres': ('smatre',),
'smatret': ('smatre',),
'smatt': ('smatte',),
'smatta': ('smatte',),
'smatte': ('smatte',),
'smatter': ('smatte',),
'smattes': ('smatte',),
'smattet': ('smatte',),
'smed': ('smede',),
'smeda': ('smede',),
'smede': ('smede',),
'smeder': ('smede',),
'smedes': ('smede',),
'smedet': ('smede',),
'smeik': ('smeike',),
'smeike': ('smeike',),
'smeiker': ('smeike',),
'smeikes': ('smeike',),
'smeikt': ('smeike',),
'smeikte': ('smeike',),
'smeis': ('smeise',),
'smeisa': ('smeise',),
'smeise': ('smeise',),
'smeiser': ('smeise',),
'smeises': ('smeise',),
'smeiset': ('smeise',),
'smeist': ('smeise',),
'smeiste': ('smeise',),
'smekk': ('smekke',),
'smekka': ('smekke',),
'smekke': ('smekke',),
'smekker': ('smekke',),
'smekkes': ('smekke',),
'smekket': ('smekke',),
'smekt': ('smekte',),
'smekta': ('smekte',),
'smekte': ('smekte',),
'smekter': ('smekte',),
'smektes': ('smekte',),
'smektet': ('smekte',),
'smelt': ('smelte',),
'smelta': ('smelte',),
'smelte': ('smelte',),
'smelter': ('smelte',),
'smeltes': ('smelte',),
'smeltet': ('smelte',),
'smergl': ('smergle',),
'smergla': ('smergle',),
'smergle': ('smergle',),
'smergler': ('smergle',),
'smergles': ('smergle',),
'smerglet': ('smergle',),
'smert': ('smerte',),
'smerta': ('smerte',),
'smerte': ('smerte',),
'smerter': ('smerte',),
'smertes': ('smerte',),
'smertet': ('smerte',),
'smett': ('smette',),
'smetta': ('smette',),
'smette': ('smette',),
'smetter': ('smette',),
'smettes': ('smette',),
'smettet': ('smette',),
'smatt': ('smette',),
'smett': ('smette',),
'smette': ('smette',),
'smetter': ('smette',),
'smettes': ('smette',),
'smettet': ('smette',),
'smi': ('smi',),
'smidd': ('smi',),
'smidde': ('smi',),
'smir': ('smi',),
'smis': ('smi',),
'smigr': ('smigre',),
'smigra': ('smigre',),
'smigre': ('smigre',),
'smigrer': ('smigre',),
'smigres': ('smigre',),
'smigret': ('smigre',),
'smikk': ('smikke',),
'smikka': ('smikke',),
'smikke': ('smikke',),
'smikker': ('smikke',),
'smikkes': ('smikke',),
'smikket': ('smikke',),
'smil': ('smile',),
'smile': ('smile',),
'smiler': ('smile',),
'smiles': ('smile',),
'smilt': ('smile',),
'smilte': ('smile',),
'smink': ('sminke',),
'sminka': ('sminke',),
'sminke': ('sminke',),
'sminker': ('sminke',),
'sminkes': ('sminke',),
'sminket': ('sminke',),
'smisk': ('smiske',),
'smiska': ('smiske',),
'smiske': ('smiske',),
'smisker': ('smiske',),
'smiskes': ('smiske',),
'smisket': ('smiske',),
'smitt': ('smitte',),
'smitta': ('smitte',),
'smitte': ('smitte',),
'smitter': ('smitte',),
'smittes': ('smitte',),
'smittet': ('smitte',),
'smugdrakk': ('smugdrikke',),
'smugdrikk': ('smugdrikke',),
'smugdrikke': ('smugdrikke',),
'smugdrikker': ('smugdrikke',),
'smugdrikkes': ('smugdrikke',),
'smugdrukket': ('smugdrikke',),
'smugl': ('smugle',),
'smugla': ('smugle',),
'smugle': ('smugle',),
'smugler': ('smugle',),
'smugles': ('smugle',),
'smuglet': ('smugle',),
'smuldr': ('smuldre',),
'smuldra': ('smuldre',),
'smuldre': ('smuldre',),
'smuldrer': ('smuldre',),
'smuldres': ('smuldre',),
'smuldret': ('smuldre',),
'smul': ('smule',),
'smula': ('smule',),
'smule': ('smule',),
'smuler': ('smule',),
'smules': ('smule',),
'smulet': ('smule',),
'smult': ('smule',),
'smulte': ('smule',),
'smuln': ('smulne',),
'smulna': ('smulne',),
'smulne': ('smulne',),
'smulner': ('smulne',),
'smulnes': ('smulne',),
'smulnet': ('smulne',),
'smuss': ('smusse',),
'smussa': ('smusse',),
'smusse': ('smusse',),
'smusser': ('smusse',),
'smusses': ('smusse',),
'smusset': ('smusse',),
'smutt': ('smutte',),
'smutta': ('smutte',),
'smutte': ('smutte',),
'smutter': ('smutte',),
'smuttes': ('smutte',),
'smuttet': ('smutte',),
'smaug': ('smyge',),
'smyg': ('smyge',),
'smyge': ('smyge',),
'smyger': ('smyge',),
'smyges': ('smyge',),
'smøg': ('smyge',),
'smøget': ('smyge',),
'smøyg': ('smyge',),
'smykk': ('smykke',),
'smykka': ('smykke',),
'smykke': ('smykke',),
'smykker': ('smykke',),
'smykkes': ('smykke',),
'smykket': ('smykke',),
'småløp': ('småløpe',),
'småløpe': ('småløpe',),
'småløper': ('småløpe',),
'småløpes': ('småløpe',),
'småløpet': ('småløpe',),
'småløpt': ('småløpe',),
'småprat': ('småprate',),
'småprata': ('småprate',),
'småprate': ('småprate',),
'småprater': ('småprate',),
'småprates': ('småprate',),
'småpratet': ('småprate',),
'smurt': ('smøre',),
'smurte': ('smøre',),
'smør': ('smøre',),
'smøre': ('smøre',),
'smører': ('smøre',),
'smøres': ('smøre',),
'smøy': ('smøye',),
'smøyd': ('smøye',),
'smøyde': ('smøye',),
'smøye': ('smøye',),
'smøyer': ('smøye',),
'smøyes': ('smøye',),
'snadr': ('snadre',),
'snadra': ('snadre',),
'snadre': ('snadre',),
'snadrer': ('snadre',),
'snadres': ('snadre',),
'snadret': ('snadre',),
'snafs': ('snafse',),
'snafsa': ('snafse',),
'snafse': ('snafse',),
'snafser': ('snafse',),
'snafses': ('snafse',),
'snafset': ('snafse',),
'snak': ('snake',),
'snaka': ('snake',),
'snake': ('snake',),
'snaker': ('snake',),
'snakes': ('snake',),
'snaket': ('snake',),
'snakt': ('snake',),
'snakte': ('snake',),
'snakk': ('snakke',),
'snakka': ('snakke',),
'snakke': ('snakke',),
'snakker': ('snakke',),
'snakkes': ('snakke',),
'snakket': ('snakke',),
'snapp': ('snappe',),
'snappa': ('snappe',),
'snappe': ('snappe',),
'snapper': ('snappe',),
'snappes': ('snappe',),
'snappet': ('snappe',),
'snaps': ('snapse',),
'snapsa': ('snapse',),
'snapse': ('snapse',),
'snapser': ('snapse',),
'snapses': ('snapse',),
'snapset': ('snapse',),
'snar': ('snare',),
'snara': ('snare',),
'snare': ('snare',),
'snarer': ('snare',),
'snares': ('snare',),
'snaret': ('snare',),
'snask': ('snaske',),
'snaska': ('snaske',),
'snaske': ('snaske',),
'snasker': ('snaske',),
'snaskes': ('snaske',),
'snasket': ('snaske',),
'snaublås': ('snaublåse',),
'snaublåse': ('snaublåse',),
'snaublåser': ('snaublåse',),
'snaublåses': ('snaublåse',),
'snaublåst': ('snaublåse',),
'snaublåste': ('snaublåse',),
'snau': ('snaue',),
'snaua': ('snaue',),
'snaue': ('snaue',),
'snauer': ('snaue',),
'snaues': ('snaue',),
'snauet': ('snaue',),
'snaugnag': ('snaugnage',),
'snaugnagd': ('snaugnage',),
'snaugnagde': ('snaugnage',),
'snaugnage': ('snaugnage',),
'snaugnager': ('snaugnage',),
'snaugnages': ('snaugnage',),
'snaugnaget': ('snaugnage',),
'snaugnog': ('snaugnage',),
'snauklipp': ('snauklippe',),
'snauklippa': ('snauklippe',),
'snauklippe': ('snauklippe',),
'snauklipper': ('snauklippe',),
'snauklippes': ('snauklippe',),
'snauklippet': ('snauklippe',),
'snauklipt': ('snauklippe',),
'snauklipte': ('snauklippe',),
'snausleit': ('snauslite',),
'snauslet': ('snauslite',),
'snauslit': ('snauslite',),
'snauslite': ('snauslite',),
'snausliter': ('snauslite',),
'snauslites': ('snauslite',),
'snauslitt': ('snauslite',),
'snavl': ('snavle',),
'snavla': ('snavle',),
'snavle': ('snavle',),
'snavler': ('snavle',),
'snavles': ('snavle',),
'snavlet': ('snavle',),
'snegl': ('snegle',),
'snegla': ('snegle',),
'snegle': ('snegle',),
'snegler': ('snegle',),
'snegles': ('snegle',),
'sneglet': ('snegle',),
'snei': ('sneie',),
'sneia': ('sneie',),
'sneid': ('sneie',),
'sneidd': ('sneie',),
'sneidde': ('sneie',),
'sneide': ('sneie',),
'sneie': ('sneie',),
'sneier': ('sneie',),
'sneies': ('sneie',),
'sneiet': ('sneie',),
'sneis': ('sneise',),
'sneisa': ('sneise',),
'sneise': ('sneise',),
'sneiser': ('sneise',),
'sneises': ('sneise',),
'sneiset': ('sneise',),
'sneist': ('sneise',),
'sneiste': ('sneise',),
'snek': ('sneke',),
'sneka': ('sneke',),
'sneke': ('sneke',),
'sneker': ('sneke',),
'snekes': ('sneke',),
'sneket': ('sneke',),
'snekkerer': ('snekkerere',),
'snekkerere': ('snekkerere',),
'snekkererer': ('snekkerere',),
'snekkereres': ('snekkerere',),
'snekkerert': ('snekkerere',),
'snekkererte': ('snekkerere',),
'snekr': ('snekre',),
'snekra': ('snekre',),
'snekre': ('snekre',),
'snekrer': ('snekre',),
'snekres': ('snekre',),
'snekret': ('snekre',),
'snell': ('snelle',),
'snella': ('snelle',),
'snelle': ('snelle',),
'sneller': ('snelle',),
'snelles': ('snelle',),
'snellet': ('snelle',),
'snerk': ('snerke',),
'snerka': ('snerke',),
'snerke': ('snerke',),
'snerker': ('snerke',),
'snerkes': ('snerke',),
'snerket': ('snerke',),
'snerp': ('snerpe',),
'snerpa': ('snerpe',),
'snerpe': ('snerpe',),
'snerper': ('snerpe',),
'snerpes': ('snerpe',),
'snerpet': ('snerpe',),
'snerp': ('snerpe',),
'snerpa': ('snerpe',),
'snerpe': ('snerpe',),
'snerper': ('snerpe',),
'snerpes': ('snerpe',),
'snerpet': ('snerpe',),
'snerr': ('snerre',),
'snerra': ('snerre',),
'snerre': ('snerre',),
'snerrer': ('snerre',),
'snerres': ('snerre',),
'snerret': ('snerre',),
'snert': ('snerte',),
'snerta': ('snerte',),
'snerte': ('snerte',),
'snerter': ('snerte',),
'snertes': ('snerte',),
'snertet': ('snerte',),
'snevr': ('snevre',),
'snevra': ('snevre',),
'snevre': ('snevre',),
'snevrer': ('snevre',),
'snevres': ('snevre',),
'snevret': ('snevre',),
'sniff': ('sniffe',),
'sniffa': ('sniffe',),
'sniffe': ('sniffe',),
'sniffer': ('sniffe',),
'sniffes': ('sniffe',),
'sniffet': ('sniffe',),
'snikmyrd': ('snikmyrde',),
'snikmyrda': ('snikmyrde',),
'snikmyrde': ('snikmyrde',),
'snikmyrder': ('snikmyrde',),
'snikmyrdes': ('snikmyrde',),
'snikmyrdet': ('snikmyrde',),
'snirkl': ('snirkle',),
'snirkla': ('snirkle',),
'snirkle': ('snirkle',),
'snirkler': ('snirkle',),
'snirkles': ('snirkle',),
'snirklet': ('snirkle',),
'snitt': ('snitte',),
'snitta': ('snitte',),
'snitte': ('snitte',),
'snitter': ('snitte',),
'snittes': ('snitte',),
'snittet': ('snitte',),
'sno': ('sno',),
'snodd': ('sno',),
'snodde': ('sno',),
'snor': ('sno',),
'snos': ('sno',),
'sno': ('sno',),
'snodd': ('sno',),
'snodde': ('sno',),
'snor': ('sno',),
'snos': ('sno',),
'snobb': ('snobbe',),
'snobba': ('snobbe',),
'snobbe': ('snobbe',),
'snobber': ('snobbe',),
'snobbes': ('snobbe',),
'snobbet': ('snobbe',),
'snok': ('snoke',),
'snoka': ('snoke',),
'snoke': ('snoke',),
'snoker': ('snoke',),
'snokes': ('snoke',),
'snoket': ('snoke',),
'snokt': ('snoke',),
'snokte': ('snoke',),
'snop': ('snope',),
'snopa': ('snope',),
'snope': ('snope',),
'snoper': ('snope',),
'snopes': ('snope',),
'snopet': ('snope',),
'snopt': ('snope',),
'snopte': ('snope',),
'snork': ('snorke',),
'snorka': ('snorke',),
'snorke': ('snorke',),
'snorker': ('snorke',),
'snorkes': ('snorke',),
'snorket': ('snorke',),
'snorksov': ('snorksove',),
'snorksove': ('snorksove',),
'snorksover': ('snorksove',),
'snorksoves': ('snorksove',),
'snorksovet': ('snorksove',),
'snu': ('snu',),
'snudd': ('snu',),
'snudde': ('snu',),
'snur': ('snu',),
'snus': ('snu',),
'snubb': ('snubbe',),
'snubba': ('snubbe',),
'snubbe': ('snubbe',),
'snubber': ('snubbe',),
'snubbes': ('snubbe',),
'snubbet': ('snubbe',),
'snubl': ('snuble',),
'snubla': ('snuble',),
'snuble': ('snuble',),
'snubler': ('snuble',),
'snubles': ('snuble',),
'snublet': ('snuble',),
'snufs': ('snufse',),
'snufsa': ('snufse',),
'snufse': ('snufse',),
'snufser': ('snufse',),
'snufses': ('snufse',),
'snufset': ('snufse',),
'snultr': ('snultre',),
'snultra': ('snultre',),
'snultre': ('snultre',),
'snultrer': ('snultre',),
'snultres': ('snultre',),
'snultret': ('snultre',),
'snupp': ('snuppe',),
'snuppa': ('snuppe',),
'snuppe': ('snuppe',),
'snupper': ('snuppe',),
'snuppes': ('snuppe',),
'snuppet': ('snuppe',),
'snurp': ('snurpe',),
'snurpa': ('snurpe',),
'snurpe': ('snurpe',),
'snurper': ('snurpe',),
'snurpes': ('snurpe',),
'snurpet': ('snurpe',),
'snurr': ('snurre',),
'snurra': ('snurre',),
'snurre': ('snurre',),
'snurrer': ('snurre',),
'snurres': ('snurre',),
'snurret': ('snurre',),
'snus': ('snuse',),
'snuse': ('snuse',),
'snuser': ('snuse',),
'snuses': ('snuse',),
'snust': ('snuse',),
'snuste': ('snuse',),
'snusk': ('snuske',),
'snuska': ('snuske',),
'snuske': ('snuske',),
'snusker': ('snuske',),
'snuskes': ('snuske',),
'snusket': ('snuske',),
'snusmal': ('snusmale',),
'snusmale': ('snusmale',),
'snusmaler': ('snusmale',),
'snusmales': ('snusmale',),
'snusmalt': ('snusmale',),
'snusmalte': ('snusmale',),
'snusmol': ('snusmale',),
'snylt': ('snylte',),
'snylta': ('snylte',),
'snylte': ('snylte',),
'snylter': ('snylte',),
'snyltes': ('snylte',),
'snyltet': ('snylte',),
'snyt': ('snyte',),
'snyte': ('snyte',),
'snyter': ('snyte',),
'snytes': ('snyte',),
'snytt': ('snyte',),
'snytte': ('snyte',),
'snøt': ('snyte',),
'snøyt': ('snyte',),
'snål': ('snåle',),
'snåle': ('snåle',),
'snåler': ('snåle',),
'snåles': ('snåle',),
'snålt': ('snåle',),
'snålte': ('snåle',),
'snåv': ('snåve',),
'snåva': ('snåve',),
'snåve': ('snåve',),
'snåver': ('snåve',),
'snåves': ('snåve',),
'snåvet': ('snåve',),
'snø': ('snø',),
'snødd': ('snø',),
'snødde': ('snø',),
'snør': ('snø',),
'snøs': ('snø',),
'snøfl': ('snøfle',),
'snøfla': ('snøfle',),
'snøfle': ('snøfle',),
'snøfler': ('snøfle',),
'snøfles': ('snøfle',),
'snøflet': ('snøfle',),
'snøft': ('snøfte',),
'snøfta': ('snøfte',),
'snøfte': ('snøfte',),
'snøfter': ('snøfte',),
'snøftes': ('snøfte',),
'snøftet': ('snøfte',),
'snøgg': ('snøgge',),
'snøgga': ('snøgge',),
'snøgge': ('snøgge',),
'snøgger': ('snøgge',),
'snøgges': ('snøgge',),
'snøgget': ('snøgge',),
'snør': ('snøre',),
'snøre': ('snøre',),
'snører': ('snøre',),
'snøres': ('snøre',),
'snørt': ('snøre',),
'snørte': ('snøre',),
'snørekjør': ('snørekjøre',),
'snørekjøre': ('snørekjøre',),
'snørekjører': ('snørekjøre',),
'snørekjøres': ('snørekjøre',),
'snørekjørt': ('snørekjøre',),
'snørekjørte': ('snørekjøre',),
'snøs': ('snøse',),
'snøse': ('snøse',),
'snøser': ('snøse',),
'snøses': ('snøse',),
'snøst': ('snøse',),
'snøste': ('snøse',),
'snøvl': ('snøvle',),
'snøvla': ('snøvle',),
'snøvle': ('snøvle',),
'snøvler': ('snøvle',),
'snøvles': ('snøvle',),
'snøvlet': ('snøvle',),
'snøy': ('snøye',),
'snøyd': ('snøye',),
'snøydd': ('snøye',),
'snøydde': ('snøye',),
'snøyde': ('snøye',),
'snøye': ('snøye',),
'snøyer': ('snøye',),
'snøyes': ('snøye',),
'sogn': ('sogne',),
'sogna': ('sogne',),
'sogne': ('sogne',),
'sogner': ('sogne',),
'sognes': ('sogne',),
'sognet': ('sogne',),
'sokk': ('sokke',),
'sokka': ('sokke',),
'sokke': ('sokke',),
'sokker': ('sokke',),
'sokkes': ('sokke',),
'sokket': ('sokke',),
'sokn': ('sokne',),
'sokna': ('sokne',),
'sokne': ('sokne',),
'sokner': ('sokne',),
'soknes': ('sokne',),
'soknet': ('sokne',),
'sokn': ('sokne',),
'sokna': ('sokne',),
'sokne': ('sokne',),
'sokner': ('sokne',),
'soknes': ('sokne',),
'soknet': ('sokne',),
'sol': ('sole',),
'sola': ('sole',),
'sole': ('sole',),
'soler': ('sole',),
'soles': ('sole',),
'solet': ('sole',),
'solt': ('sole',),
'solte': ('sole',),
'solidariser': ('solidarisere',),
'solidarisere': ('solidarisere',),
'solidariserer': ('solidarisere',),
'solidariseres': ('solidarisere',),
'solidarisert': ('solidarisere',),
'solidariserte': ('solidarisere',),
'sollisiter': ('sollisitere',),
'sollisitere': ('sollisitere',),
'sollisiterer': ('sollisitere',),
'sollisiteres': ('sollisitere',),
'sollisitert': ('sollisitere',),
'sollisiterte': ('sollisitere',),
'solmiser': ('solmisere',),
'solmisere': ('solmisere',),
'solmiserer': ('solmisere',),
'solmiseres': ('solmisere',),
'solmisert': ('solmisere',),
'solmiserte': ('solmisere',),
'soml': ('somle',),
'somla': ('somle',),
'somle': ('somle',),
'somler': ('somle',),
'somles': ('somle',),
'somlet': ('somle',),
'somredes': ('somres',),
'somres': ('somres',),
'sonder': ('sondere',),
'sondere': ('sondere',),
'sonderer': ('sondere',),
'sonderes': ('sondere',),
'sondert': ('sondere',),
'sonderte': ('sondere',),
'sondr': ('sondre',),
'sondra': ('sondre',),
'sondre': ('sondre',),
'sondrer': ('sondre',),
'sondres': ('sondre',),
'sondret': ('sondre',),
'son': ('sone',),
'sona': ('sone',),
'sone': ('sone',),
'soner': ('sone',),
'sones': ('sone',),
'sonet': ('sone',),
'sont': ('sone',),
'sonte': ('sone',),
'sop': ('sope',),
'sope': ('sope',),
'soper': ('sope',),
'sopes': ('sope',),
'sopt': ('sope',),
'sopte': ('sope',),
'sopp': ('soppe',),
'soppa': ('soppe',),
'soppe': ('soppe',),
'sopper': ('soppe',),
'soppes': ('soppe',),
'soppet': ('soppe',),
'sordiner': ('sordinere',),
'sordinere': ('sordinere',),
'sordinerer': ('sordinere',),
'sordineres': ('sordinere',),
'sordinert': ('sordinere',),
'sordinerte': ('sordinere',),
'sorter': ('sortere',),
'sortere': ('sortere',),
'sorterer': ('sortere',),
'sorteres': ('sortere',),
'sortert': ('sortere',),
'sorterte': ('sortere',),
'sos': ('sose',),
'sosa': ('sose',),
'sose': ('sose',),
'soser': ('sose',),
'soses': ('sose',),
'soset': ('sose',),
'sost': ('sose',),
'soste': ('sose',),
'sosialiser': ('sosialisere',),
'sosialisere': ('sosialisere',),
'sosialiserer': ('sosialisere',),
'sosialiseres': ('sosialisere',),
'sosialisert': ('sosialisere',),
'sosialiserte': ('sosialisere',),
'sot': ('sote',),
'sota': ('sote',),
'sote': ('sote',),
'soter': ('sote',),
'sotes': ('sote',),
'sotet': ('sote',),
'sov': ('sove',),
'sove': ('sove',),
'sover': ('sove',),
'soves': ('sove',),
'sovet': ('sove',),
'sovn': ('sovne',),
'sovna': ('sovne',),
'sovne': ('sovne',),
'sovner': ('sovne',),
'sovnes': ('sovne',),
'sovnet': ('sovne',),
'spa': ('spa',),
'spadd': ('spa',),
'spadde': ('spa',),
'spar': ('spa',),
'spas': ('spa',),
'spakn': ('spakne',),
'spakna': ('spakne',),
'spakne': ('spakne',),
'spakner': ('spakne',),
'spaknes': ('spakne',),
'spaknet': ('spakne',),
'spalt': ('spalte',),
'spalta': ('spalte',),
'spalte': ('spalte',),
'spalter': ('spalte',),
'spaltes': ('spalte',),
'spaltet': ('spalte',),
'spander': ('spandere',),
'spandere': ('spandere',),
'spanderer': ('spandere',),
'spanderes': ('spandere',),
'spandert': ('spandere',),
'spanderte': ('spandere',),
'span': ('spane',),
'spana': ('spane',),
'spane': ('spane',),
'spaner': ('spane',),
'spanes': ('spane',),
'spanet': ('spane',),
'spant': ('spane',),
'spante': ('spane',),
'spank': ('spanke',),
'spanka': ('spanke',),
'spanke': ('spanke',),
'spanker': ('spanke',),
'spankes': ('spanke',),
'spanket': ('spanke',),
'spankuler': ('spankulere',),
'spankulere': ('spankulere',),
'spankulerer': ('spankulere',),
'spankuleres': ('spankulere',),
'spankulert': ('spankulere',),
'spankulerte': ('spankulere',),
'spansk': ('spanske',),
'spanska': ('spanske',),
'spanske': ('spanske',),
'spansker': ('spanske',),
'spanskes': ('spanske',),
'spansket': ('spanske',),
'spant': ('spante',),
'spanta': ('spante',),
'spante': ('spante',),
'spanter': ('spante',),
'spantes': ('spante',),
'spantet': ('spante',),
'spar': ('spare',),
'spara': ('spare',),
'spare': ('spare',),
'sparer': ('spare',),
'spares': ('spare',),
'spart': ('spare',),
'sparte': ('spare',),
'spark': ('sparke',),
'sparka': ('sparke',),
'sparke': ('sparke',),
'sparker': ('sparke',),
'sparkes': ('sparke',),
'sparket': ('sparke',),
'sparkl': ('sparkle',),
'sparkla': ('sparkle',),
'sparkle': ('sparkle',),
'sparkler': ('sparkle',),
'sparkles': ('sparkle',),
'sparklet': ('sparkle',),
'sparr': ('sparre',),
'sparra': ('sparre',),
'sparre': ('sparre',),
'sparrer': ('sparre',),
'sparres': ('sparre',),
'sparret': ('sparre',),
'spas': ('spase',),
'spasa': ('spase',),
'spase': ('spase',),
'spaser': ('spase',),
'spases': ('spase',),
'spaset': ('spase',),
'spast': ('spase',),
'spaste': ('spase',),
'spaser': ('spasere',),
'spasere': ('spasere',),
'spaserer': ('spasere',),
'spaseres': ('spasere',),
'spasert': ('spasere',),
'spaserte': ('spasere',),
'spe': ('spe',),
'spedd': ('spe',),
'spedde': ('spe',),
'sper': ('spe',),
'spes': ('spe',),
'speed': ('speede',),
'speeda': ('speede',),
'speede': ('speede',),
'speeder': ('speede',),
'speedes': ('speede',),
'speedet': ('speede',),
'speid': ('speide',),
'speida': ('speide',),
'speide': ('speide',),
'speider': ('speide',),
'speides': ('speide',),
'speidet': ('speide',),
'speil': ('speile',),
'speila': ('speile',),
'speile': ('speile',),
'speiler': ('speile',),
'speiles': ('speile',),
'speilet': ('speile',),
'speilt': ('speile',),
'speilte': ('speile',),
'speilvend': ('speilvende',),
'speilvende': ('speilvende',),
'speilvender': ('speilvende',),
'speilvendes': ('speilvende',),
'speilvendt': ('speilvende',),
'speilvendte': ('speilvende',),
'spek': ('speke',),
'speka': ('speke',),
'speke': ('speke',),
'speker': ('speke',),
'spekes': ('speke',),
'speket': ('speke',),
'spekt': ('speke',),
'spekte': ('speke',),
'spekk': ('spekke',),
'spekka': ('spekke',),
'spekke': ('spekke',),
'spekker': ('spekke',),
'spekkes': ('spekke',),
'spekket': ('spekke',),
'spekkmål': ('spekkmåle',),
'spekkmåle': ('spekkmåle',),
'spekkmåler': ('spekkmåle',),
'spekkmåles': ('spekkmåle',),
'spekkmålt': ('spekkmåle',),
'spekkmålte': ('spekkmåle',),
'spekn': ('spekne',),
'spekna': ('spekne',),
'spekne': ('spekne',),
'spekner': ('spekne',),
'speknes': ('spekne',),
'speknet': ('spekne',),
'speks': ('spekse',),
'speksa': ('spekse',),
'spekse': ('spekse',),
'spekser': ('spekse',),
'spekses': ('spekse',),
'spekset': ('spekse',),
'spekuler': ('spekulere',),
'spekulere': ('spekulere',),
'spekulerer': ('spekulere',),
'spekuleres': ('spekulere',),
'spekulert': ('spekulere',),
'spekulerte': ('spekulere',),
'spell': ('spelle',),
'spelle': ('spelle',),
'speller': ('spelle',),
'spelles': ('spelle',),
'spelt': ('spelle',),
'spelte': ('spelle',),
'spenn': ('spenne',),
'spenne': ('spenne',),
'spenner': ('spenne',),
'spennes': ('spenne',),
'spent': ('spenne',),
'spente': ('spenne',),
'spenn': ('spenne',),
'spenne': ('spenne',),
'spenner': ('spenne',),
'spennes': ('spenne',),
'spent': ('spenne',),
'spente': ('spenne',),
'sperr': ('sperre',),
'sperra': ('sperre',),
'sperre': ('sperre',),
'sperrer': ('sperre',),
'sperres': ('sperre',),
'sperret': ('sperre',),
'spesialiser': ('spesialisere',),
'spesialisere': ('spesialisere',),
'spesialiserer': ('spesialisere',),
'spesialiseres': ('spesialisere',),
'spesialisert': ('spesialisere',),
'spesialiserte': ('spesialisere',),
'spesifiser': ('spesifisere',),
'spesifisere': ('spesifisere',),
'spesifiserer': ('spesifisere',),
'spesifiseres': ('spesifisere',),
'spesifisert': ('spesifisere',),
'spesifiserte': ('spesifisere',),
'spidd': ('spidde',),
'spidda': ('spidde',),
'spidde': ('spidde',),
'spidder': ('spidde',),
'spiddes': ('spidde',),
'spiddet': ('spidde',),
'spikk': ('spikke',),
'spikka': ('spikke',),
'spikke': ('spikke',),
'spikker': ('spikke',),
'spikkes': ('spikke',),
'spikket': ('spikke',),
'spikr': ('spikre',),
'spikra': ('spikre',),
'spikre': ('spikre',),
'spikrer': ('spikre',),
'spikres': ('spikre',),
'spikret': ('spikre',),
'spildr': ('spildre',),
'spildra': ('spildre',),
'spildre': ('spildre',),
'spildrer': ('spildre',),
'spildres': ('spildre',),
'spildret': ('spildre',),
'spil': ('spile',),
'spile': ('spile',),
'spiler': ('spile',),
'spiles': ('spile',),
'spilt': ('spile',),
'spilte': ('spile',),
'spill': ('spille',),
'spille': ('spille',),
'spiller': ('spille',),
'spilles': ('spille',),
'spilt': ('spille',),
'spilte': ('spille',),
'spill': ('spille',),
'spille': ('spille',),
'spiller': ('spille',),
'spilles': ('spille',),
'spilt': ('spille',),
'spilte': ('spille',),
'spink': ('spinke',),
'spinka': ('spinke',),
'spinke': ('spinke',),
'spinker': ('spinke',),
'spinkes': ('spinke',),
'spinket': ('spinke',),
'spann': ('spinne',),
'spant': ('spinne',),
'spinn': ('spinne',),
'spinne': ('spinne',),
'spinner': ('spinne',),
'spinnes': ('spinne',),
'spunnet': ('spinne',),
'spioner': ('spionere',),
'spionere': ('spionere',),
'spionerer': ('spionere',),
'spioneres': ('spionere',),
'spionert': ('spionere',),
'spionerte': ('spionere',),
'spiraliser': ('spiralisere',),
'spiralisere': ('spiralisere',),
'spiraliserer': ('spiralisere',),
'spiraliseres': ('spiralisere',),
'spiralisert': ('spiralisere',),
'spiraliserte': ('spiralisere',),
'spir': ('spire',),
'spira': ('spire',),
'spire': ('spire',),
'spirer': ('spire',),
'spires': ('spire',),
'spiret': ('spire',),
'spirt': ('spire',),
'spirte': ('spire',),
'spis': ('spise',),
'spise': ('spise',),
'spiser': ('spise',),
'spises': ('spise',),
'spist': ('spise',),
'spiste': ('spise',),
'spiss': ('spisse',),
'spissa': ('spisse',),
'spisse': ('spisse',),
'spisser': ('spisse',),
'spisses': ('spisse',),
'spisset': ('spisse',),
'spissformuler': ('spissformulere',),
'spissformulere': ('spissformulere',),
'spissformulerer': ('spissformulere',),
'spissformuleres': ('spissformulere',),
'spissformulert': ('spissformulere',),
'spissformulerte': ('spissformulere',),
'spjelk': ('spjelke',),
'spjelka': ('spjelke',),
'spjelke': ('spjelke',),
'spjelker': ('spjelke',),
'spjelkes': ('spjelke',),
'spjelket': ('spjelke',),
'spjett': ('spjette',),
'spjetta': ('spjette',),
'spjette': ('spjette',),
'spjetter': ('spjette',),
'spjettes': ('spjette',),
'spjettet': ('spjette',),
'spjåk': ('spjåke',),
'spjåka': ('spjåke',),
'spjåke': ('spjåke',),
'spjåker': ('spjåke',),
'spjåkes': ('spjåke',),
'spjåket': ('spjåke',),
'spjåkt': ('spjåke',),
'spjåkte': ('spjåke',),
'spjær': ('spjære',),
'spjæra': ('spjære',),
'spjære': ('spjære',),
'spjærer': ('spjære',),
'spjæres': ('spjære',),
'spjæret': ('spjære',),
'spjært': ('spjære',),
'spjærte': ('spjære',),
'spleis': ('spleise',),
'spleisa': ('spleise',),
'spleise': ('spleise',),
'spleiser': ('spleise',),
'spleises': ('spleise',),
'spleiset': ('spleise',),
'spleist': ('spleise',),
'spleiste': ('spleise',),
'splintr': ('splintre',),
'splintra': ('splintre',),
'splintre': ('splintre',),
'splintrer': ('splintre',),
'splintres': ('splintre',),
'splintret': ('splintre',),
'splitt': ('splitte',),
'splitta': ('splitte',),
'splitte': ('splitte',),
'splitter': ('splitte',),
'splittes': ('splitte',),
'splittet': ('splitte',),
'spol': ('spole',),
'spola': ('spole',),
'spole': ('spole',),
'spoler': ('spole',),
'spoles': ('spole',),
'spolet': ('spole',),
'spolt': ('spole',),
'spolte': ('spole',),
'spoler': ('spolere',),
'spolere': ('spolere',),
'spolerer': ('spolere',),
'spoleres': ('spolere',),
'spolert': ('spolere',),
'spolerte': ('spolere',),
'spons': ('sponse',),
'sponsa': ('sponse',),
'sponse': ('sponse',),
'sponser': ('sponse',),
'sponses': ('sponse',),
'sponset': ('sponse',),
'spor': ('spore',),
'spora': ('spore',),
'spore': ('spore',),
'sporer': ('spore',),
'spores': ('spore',),
'sporet': ('spore',),
'sport': ('spore',),
'sporte': ('spore',),
'spor': ('spore',),
'spora': ('spore',),
'spore': ('spore',),
'sporer': ('spore',),
'spores': ('spore',),
'sporet': ('spore',),
'sport': ('spore',),
'sporte': ('spore',),
'sport': ('sporte',),
'sporta': ('sporte',),
'sporte': ('sporte',),
'sporter': ('sporte',),
'sportes': ('sporte',),
'sportet': ('sporte',),
'spott': ('spotte',),
'spotta': ('spotte',),
'spotte': ('spotte',),
'spotter': ('spotte',),
'spottes': ('spotte',),
'spottet': ('spotte',),
'sprad': ('sprade',),
'sprada': ('sprade',),
'sprade': ('sprade',),
'sprader': ('sprade',),
'sprades': ('sprade',),
'spradet': ('sprade',),
'sprak': ('sprake',),
'spraka': ('sprake',),
'sprake': ('sprake',),
'spraker': ('sprake',),
'sprakes': ('sprake',),
'spraket': ('sprake',),
'sprakt': ('sprake',),
'sprakte': ('sprake',),
'spray': ('spraye',),
'spraya': ('spraye',),
'spraye': ('spraye',),
'sprayer': ('spraye',),
'sprayes': ('spraye',),
'sprayet': ('spraye',),
'spred': ('sprede',),
'spredd': ('sprede',),
'spredde': ('sprede',),
'sprede': ('sprede',),
'spreder': ('sprede',),
'spredes': ('sprede',),
'spredt': ('sprede',),
'spredte': ('sprede',),
'spred': ('sprede',),
'spredd': ('sprede',),
'spredde': ('sprede',),
'sprede': ('sprede',),
'spreder': ('sprede',),
'spredes': ('sprede',),
'spredt': ('sprede',),
'spredte': ('sprede',),
'sprei': ('spreie',),
'spreid': ('spreie',),
'spreidd': ('spreie',),
'spreidde': ('spreie',),
'spreide': ('spreie',),
'spreie': ('spreie',),
'spreier': ('spreie',),
'spreies': ('spreie',),
'sprei': ('spreie',),
'spreid': ('spreie',),
'spreidd': ('spreie',),
'spreidde': ('spreie',),
'spreide': ('spreie',),
'spreie': ('spreie',),
'spreier': ('spreie',),
'spreies': ('spreie',),
'sprakk': ('sprekke',),
'sprekk': ('sprekke',),
'sprekke': ('sprekke',),
'sprekker': ('sprekke',),
'sprekkes': ('sprekke',),
'sprukket': ('sprekke',),
'sprell': ('sprelle',),
'sprella': ('sprelle',),
'sprelle': ('sprelle',),
'spreller': ('sprelle',),
'sprelles': ('sprelle',),
'sprellet': ('sprelle',),
'sprelt': ('sprelle',),
'sprelte': ('sprelle',),
'spreng': ('sprenge',),
'sprenge': ('sprenge',),
'sprenger': ('sprenge',),
'sprenges': ('sprenge',),
'sprengt': ('sprenge',),
'sprengte': ('sprenge',),
'sprengkjør': ('sprengkjøre',),
'sprengkjøre': ('sprengkjøre',),
'sprengkjører': ('sprengkjøre',),
'sprengkjøres': ('sprengkjøre',),
'sprengkjørt': ('sprengkjøre',),
'sprengkjørte': ('sprengkjøre',),
'sprengles': ('sprenglese',),
'sprenglese': ('sprenglese',),
'sprengleser': ('sprenglese',),
'sprengleses': ('sprenglese',),
'sprenglest': ('sprenglese',),
'sprengleste': ('sprenglese',),
'sprett': ('sprette',),
'spretta': ('sprette',),
'sprette': ('sprette',),
'spretter': ('sprette',),
'sprettes': ('sprette',),
'sprettet': ('sprette',),
'spratt': ('sprette',),
'sprett': ('sprette',),
'sprette': ('sprette',),
'spretter': ('sprette',),
'sprettes': ('sprette',),
'sprettet': ('sprette',),
'spri': ('spri',),
'spridd': ('spri',),
'spridde': ('spri',),
'sprir': ('spri',),
'spris': ('spri',),
'sprik': ('sprike',),
'sprika': ('sprike',),
'sprike': ('sprike',),
'spriker': ('sprike',),
'sprikes': ('sprike',),
'spriket': ('sprike',),
'sprikt': ('sprike',),
'sprikte': ('sprike',),
'sprang': ('springe',),
'spring': ('springe',),
'springe': ('springe',),
'springer': ('springe',),
'springes': ('springe',),
'sprunget': ('springe',),
'sprint': ('sprinte',),
'sprinta': ('sprinte',),
'sprinte': ('sprinte',),
'sprinter': ('sprinte',),
'sprintes': ('sprinte',),
'sprintet': ('sprinte',),
'sprit': ('sprite',),
'sprita': ('sprite',),
'sprite': ('sprite',),
'spriter': ('sprite',),
'sprites': ('sprite',),
'spritet': ('sprite',),
'sprudl': ('sprudle',),
'sprudla': ('sprudle',),
'sprudle': ('sprudle',),
'sprudler': ('sprudle',),
'sprudles': ('sprudle',),
'sprudlet': ('sprudle',),
'sprut': ('sprute',),
'spruta': ('sprute',),
'sprute': ('sprute',),
'spruter': ('sprute',),
'sprutes': ('sprute',),
'sprutet': ('sprute',),
'sprutregn': ('sprutregne',),
'sprutregna': ('sprutregne',),
'sprutregne': ('sprutregne',),
'sprutregner': ('sprutregne',),
'sprutregnes': ('sprutregne',),
'sprutregnet': ('sprutregne',),
'sprutregnt': ('sprutregne',),
'sprutregnte': ('sprutregne',),
'sprøsteik': ('sprøsteike',),
'sprøsteike': ('sprøsteike',),
'sprøsteiker': ('sprøsteike',),
'sprøsteikes': ('sprøsteike',),
'sprøsteikt': ('sprøsteike',),
'sprøsteikte': ('sprøsteike',),
'sprøyt': ('sprøyte',),
'sprøyta': ('sprøyte',),
'sprøyte': ('sprøyte',),
'sprøyter': ('sprøyte',),
'sprøytes': ('sprøyte',),
'sprøytet': ('sprøyte',),
'sprøytelakker': ('sprøytelakkere',),
'sprøytelakkere': ('sprøytelakkere',),
'sprøytelakkerer': ('sprøytelakkere',),
'sprøytelakkeres': ('sprøytelakkere',),
'sprøytelakkert': ('sprøytelakkere',),
'sprøytelakkerte': ('sprøytelakkere',),
'spuns': ('spunse',),
'spunsa': ('spunse',),
'spunse': ('spunse',),
'spunser': ('spunse',),
'spunses': ('spunse',),
'spunset': ('spunse',),
'spurtbeseir': ('spurtbeseire',),
'spurtbeseira': ('spurtbeseire',),
'spurtbeseire': ('spurtbeseire',),
'spurtbeseirer': ('spurtbeseire',),
'spurtbeseires': ('spurtbeseire',),
'spurtbeseiret': ('spurtbeseire',),
'spurt': ('spurte',),
'spurta': ('spurte',),
'spurte': ('spurte',),
'spurter': ('spurte',),
'spurtes': ('spurte',),
'spurtet': ('spurte',),
'spy': ('spy',),
'spydd': ('spy',),
'spydde': ('spy',),
'spyr': ('spy',),
'spys': ('spy',),
'spyl': ('spyle',),
'spyle': ('spyle',),
'spyler': ('spyle',),
'spyles': ('spyle',),
'spylt': ('spyle',),
'spylte': ('spyle',),
'spytt': ('spytte',),
'spytta': ('spytte',),
'spytte': ('spytte',),
'spytter': ('spytte',),
'spyttes': ('spytte',),
'spyttet': ('spytte',),
'spå': ('spå',),
'spådd': ('spå',),
'spådde': ('spå',),
'spår': ('spå',),
'spås': ('spå',),
'spøk': ('spøke',),
'spøke': ('spøke',),
'spøker': ('spøke',),
'spøkes': ('spøke',),
'spøkt': ('spøke',),
'spøkte': ('spøke',),
'spurt': ('spørre',),
'spurte': ('spørre',),
'spør': ('spørre',),
'spørre': ('spørre',),
'spørres': ('spørre',),
'spurtes': ('spørres',),
'spurts': ('spørres',),
'spørres': ('spørres',),
'spørs': ('spørres',),
'spøt': ('spøte',),
'spøte': ('spøte',),
'spøter': ('spøte',),
'spøtes': ('spøte',),
'spøtt': ('spøte',),
'spøtte': ('spøte',),
'stabb': ('stabbe',),
'stabba': ('stabbe',),
'stabbe': ('stabbe',),
'stabber': ('stabbe',),
'stabbes': ('stabbe',),
'stabbet': ('stabbe',),
'stabiliser': ('stabilisere',),
'stabilisere': ('stabilisere',),
'stabiliserer': ('stabilisere',),
'stabiliseres': ('stabilisere',),
'stabilisert': ('stabilisere',),
'stabiliserte': ('stabilisere',),
'stabl': ('stable',),
'stabla': ('stable',),
'stable': ('stable',),
'stabler': ('stable',),
'stables': ('stable',),
'stablet': ('stable',),
'stadfest': ('stadfeste',),
'stadfesta': ('stadfeste',),
'stadfeste': ('stadfeste',),
'stadfester': ('stadfeste',),
'stadfestes': ('stadfeste',),
'stadfestet': ('stadfeste',),
'stadsleg': ('stadslege',),
'stadslega': ('stadslege',),
'stadslege': ('stadslege',),
'stadsleger': ('stadslege',),
'stadsleges': ('stadslege',),
'stadsleget': ('stadslege',),
'stadslegt': ('stadslege',),
'stadslegte': ('stadslege',),
'staffer': ('staffere',),
'staffere': ('staffere',),
'stafferer': ('staffere',),
'stafferes': ('staffere',),
'staffert': ('staffere',),
'stafferte': ('staffere',),
'stag': ('stage',),
'staga': ('stage',),
'stage': ('stage',),
'stager': ('stage',),
'stages': ('stage',),
'staget': ('stage',),
'stagg': ('stagge',),
'stagga': ('stagge',),
'stagge': ('stagge',),
'stagger': ('stagge',),
'stagges': ('stagge',),
'stagget': ('stagge',),
'stagner': ('stagnere',),
'stagnere': ('stagnere',),
'stagnerer': ('stagnere',),
'stagneres': ('stagnere',),
'stagnert': ('stagnere',),
'stagnerte': ('stagnere',),
'stagvend': ('stagvende',),
'stagvende': ('stagvende',),
'stagvender': ('stagvende',),
'stagvendes': ('stagvende',),
'stagvendt': ('stagvende',),
'stagvendte': ('stagvende',),
'stak': ('stake',),
'staka': ('stake',),
'stake': ('stake',),
'staker': ('stake',),
'stakes': ('stake',),
'staket': ('stake',),
'stakk': ('stakke',),
'stakka': ('stakke',),
'stakke': ('stakke',),
'stakker': ('stakke',),
'stakkes': ('stakke',),
'stakket': ('stakke',),
'stall': ('stalle',),
'stalla': ('stalle',),
'stalle': ('stalle',),
'staller': ('stalle',),
'stalles': ('stalle',),
'stallet': ('stalle',),
'stambokfør': ('stambokføre',),
'stambokføre': ('stambokføre',),
'stambokfører': ('stambokføre',),
'stambokføres': ('stambokføre',),
'stambokført': ('stambokføre',),
'stambokførte': ('stambokføre',),
'stam': ('stamme',),
'stamma': ('stamme',),
'stamme': ('stamme',),
'stammer': ('stamme',),
'stammes': ('stamme',),
'stammet': ('stamme',),
'stam': ('stamme',),
'stamma': ('stamme',),
'stamme': ('stamme',),
'stammer': ('stamme',),
'stammes': ('stamme',),
'stammet': ('stamme',),
'stamp': ('stampe',),
'stampa': ('stampe',),
'stampe': ('stampe',),
'stamper': ('stampe',),
'stampes': ('stampe',),
'stampet': ('stampe',),
'stamp': ('stampe',),
'stampa': ('stampe',),
'stampe': ('stampe',),
'stamper': ('stampe',),
'stampes': ('stampe',),
'stampet': ('stampe',),
'standardiser': ('standardisere',),
'standardisere': ('standardisere',),
'standardiserer': ('standardisere',),
'standardiseres': ('standardisere',),
'standardisert': ('standardisere',),
'standardiserte': ('standardisere',),
'stan': ('stane',),
'stana': ('stane',),
'stane': ('stane',),
'staner': ('stane',),
'stanes': ('stane',),
'stanet': ('stane',),
'stant': ('stane',),
'stante': ('stane',),
'stang': ('stange',),
'stanga': ('stange',),
'stange': ('stange',),
'stanger': ('stange',),
'stanges': ('stange',),
'stanget': ('stange',),
'stank': ('stanke',),
'stanka': ('stanke',),
'stanke': ('stanke',),
'stanker': ('stanke',),
'stankes': ('stanke',),
'stanket': ('stanke',),
'stank': ('stanke',),
'stanka': ('stanke',),
'stanke': ('stanke',),
'stanker': ('stanke',),
'stankes': ('stanke',),
'stanket': ('stanke',),
'stans': ('stanse',),
'stansa': ('stanse',),
'stanse': ('stanse',),
'stanser': ('stanse',),
'stanses': ('stanse',),
'stanset': ('stanse',),
'stans': ('stanse',),
'stansa': ('stanse',),
'stanse': ('stanse',),
'stanser': ('stanse',),
'stanses': ('stanse',),
'stanset': ('stanse',),
'stapl': ('staple',),
'stapla': ('staple',),
'staple': ('staple',),
'stapler': ('staple',),
'staples': ('staple',),
'staplet': ('staple',),
'stapp': ('stappe',),
'stappa': ('stappe',),
'stappe': ('stappe',),
'stapper': ('stappe',),
'stappes': ('stappe',),
'stappet': ('stappe',),
'start': ('starte',),
'starta': ('starte',),
'starte': ('starte',),
'starter': ('starte',),
'startes': ('starte',),
'startet': ('starte',),
'stas': ('stase',),
'stasa': ('stase',),
'stase': ('stase',),
'staser': ('stase',),
'stases': ('stase',),
'staset': ('stase',),
'stast': ('stase',),
'staste': ('stase',),
'stasjoner': ('stasjonere',),
'stasjonere': ('stasjonere',),
'stasjonerer': ('stasjonere',),
'stasjoneres': ('stasjonere',),
'stasjonert': ('stasjonere',),
'stasjonerte': ('stasjonere',),
'statuer': ('statuere',),
'statuere': ('statuere',),
'statuerer': ('statuere',),
'statueres': ('statuere',),
'statuert': ('statuere',),
'statuerte': ('statuere',),
'staur': ('staure',),
'staura': ('staure',),
'staure': ('staure',),
'staurer': ('staure',),
'staures': ('staure',),
'stauret': ('staure',),
'stav': ('stave',),
'stava': ('stave',),
'stave': ('stave',),
'staver': ('stave',),
'staves': ('stave',),
'stavet': ('stave',),
'stavr': ('stavre',),
'stavra': ('stavre',),
'stavre': ('stavre',),
'stavrer': ('stavre',),
'stavres': ('stavre',),
'stavret': ('stavre',),
'ste': ('ste',),
'stedd': ('ste',),
'stedde': ('ste',),
'ster': ('ste',),
'stes': ('ste',),
'sted': ('stede',),
'stede': ('stede',),
'steder': ('stede',),
'stedes': ('stede',),
'stedt': ('stede',),
'stedte': ('stede',),
'sted': ('stede',),
'stedd': ('stede',),
'stedde': ('stede',),
'stede': ('stede',),
'steder': ('stede',),
'stedes': ('stede',),
'stedfest': ('stedfeste',),
'stedfesta': ('stedfeste',),
'stedfeste': ('stedfeste',),
'stedfester': ('stedfeste',),
'stedfestes': ('stedfeste',),
'stedfestet': ('stedfeste',),
'steg': ('stege',),
'stega': ('stege',),
'stege': ('stege',),
'steger': ('stege',),
'steges': ('stege',),
'steget': ('stege',),
'steik': ('steike',),
'steike': ('steike',),
'steiker': ('steike',),
'steikes': ('steike',),
'steikt': ('steike',),
'steikte': ('steike',),
'steil': ('steile',),
'steila': ('steile',),
'steile': ('steile',),
'steiler': ('steile',),
'steiles': ('steile',),
'steilet': ('steile',),
'steilt': ('steile',),
'steilte': ('steile',),
'stein': ('steine',),
'steina': ('steine',),
'steine': ('steine',),
'steiner': ('steine',),
'steines': ('steine',),
'steinet': ('steine',),
'steinsatt': ('steinsette',),
'steinsatte': ('steinsette',),
'steinsett': ('steinsette',),
'steinsette': ('steinsette',),
'steinsetter': ('steinsette',),
'steinsettes': ('steinsette',),
'stek': ('steke',),
'steke': ('steke',),
'steker': ('steke',),
'stekes': ('steke',),
'stekt': ('steke',),
'stekte': ('steke',),
'stekk': ('stekke',),
'stekka': ('stekke',),
'stekke': ('stekke',),
'stekker': ('stekke',),
'stekkes': ('stekke',),
'stekket': ('stekke',),
'stekt': ('stekke',),
'stekte': ('stekke',),
'stal': ('stele',),
'stel': ('stele',),
'stele': ('stele',),
'steler': ('stele',),
'steles': ('stele',),
'stålet': ('stele',),
'stal': ('stele',),
'stel': ('stele',),
'stele': ('stele',),
'steler': ('stele',),
'steles': ('stele',),
'stålet': ('stele',),
'stell': ('stelle',),
'stelle': ('stelle',),
'steller': ('stelle',),
'stelles': ('stelle',),
'stelt': ('stelle',),
'stelte': ('stelle',),
'stem': ('stemme',),
'stemme': ('stemme',),
'stemmer': ('stemme',),
'stemmes': ('stemme',),
'stemt': ('stemme',),
'stemte': ('stemme',),
'stem': ('stemme',),
'stemm': ('stemme',),
'stemma': ('stemme',),
'stemme': ('stemme',),
'stemmer': ('stemme',),
'stemmes': ('stemme',),
'stemmet': ('stemme',),
'stemt': ('stemme',),
'stemte': ('stemme',),
'stiln': ('stilne',),
'stilna': ('stilne',),
'stilne': ('stilne',),
'stilner': ('stilne',),
'stilnes': ('stilne',),
'stilnet': ('stilne',),
'stiltr': ('stiltre',),
'stiltra': ('stiltre',),
'stiltre': ('stiltre',),
'stiltrer': ('stiltre',),
'stiltres': ('stiltre',),
'stiltret': ('stiltre',),
'stiml': ('stimle',),
'stimla': ('stimle',),
'stimle': ('stimle',),
'stimler': ('stimle',),
'stimles': ('stimle',),
'stimlet': ('stimle',),
'stimrens': ('stimrense',),
'stimrensa': ('stimrense',),
'stimrense': ('stimrense',),
'stimrenser': ('stimrense',),
'stimrenses': ('stimrense',),
'stimrenset': ('stimrense',),
'stimuler': ('stimulere',),
'stimulere': ('stimulere',),
'stimulerer': ('stimulere',),
'stimuleres': ('stimulere',),
'stimulert': ('stimulere',),
'stimulerte': ('stimulere',),
'sting': ('stinge',),
'stinga': ('stinge',),
'stinge': ('stinge',),
'stinger': ('stinge',),
'stinges': ('stinge',),
'stinget': ('stinge',),
'stink': ('stinke',),
'stinka': ('stinke',),
'stinke': ('stinke',),
'stinker': ('stinke',),
'stinkes': ('stinke',),
'stinket': ('stinke',),
'stipl': ('stiple',),
'stipla': ('stiple',),
'stiple': ('stiple',),
'stipler': ('stiple',),
'stiples': ('stiple',),
'stiplet': ('stiple',),
'stipuler': ('stipulere',),
'stipulere': ('stipulere',),
'stipulerer': ('stipulere',),
'stipuleres': ('stipulere',),
'stipulert': ('stipulere',),
'stipulerte': ('stipulere',),
'stirr': ('stirre',),
'stirra': ('stirre',),
'stirre': ('stirre',),
'stirrer': ('stirre',),
'stirres': ('stirre',),
'stirret': ('stirre',),
'stiv': ('stive',),
'stiva': ('stive',),
'stive': ('stive',),
'stiver': ('stive',),
'stives': ('stive',),
'stivet': ('stive',),
'stivfraus': ('stivfryse',),
'stivfrosset': ('stivfryse',),
'stivfrys': ('stivfryse',),
'stivfryse': ('stivfryse',),
'stivfryser': ('stivfryse',),
'stivfryses': ('stivfryse',),
'stivfrøs': ('stivfryse',),
'stivfrøys': ('stivfryse',),
'stivn': ('stivne',),
'stivna': ('stivne',),
'stivne': ('stivne',),
'stivner': ('stivne',),
'stivnes': ('stivne',),
'stivnet': ('stivne',),
'stivpisk': ('stivpiske',),
'stivpiska': ('stivpiske',),
'stivpiske': ('stivpiske',),
'stivpisker': ('stivpiske',),
'stivpiskes': ('stivpiske',),
'stivpisket': ('stivpiske',),
'stjal': ('stjele',),
'stjel': ('stjele',),
'stjele': ('stjele',),
'stjeler': ('stjele',),
'stjeles': ('stjele',),
'stjålet': ('stjele',),
'stoff': ('stoffe',),
'stoffa': ('stoffe',),
'stoffe': ('stoffe',),
'stoffer': ('stoffe',),
'stoffes': ('stoffe',),
'stoffet': ('stoffe',),
'stokk': ('stokke',),
'stokka': ('stokke',),
'stokke': ('stokke',),
'stokker': ('stokke',),
'stokkes': ('stokke',),
'stokket': ('stokke',),
'stol': ('stole',),
'stole': ('stole',),
'stoler': ('stole',),
'stoles': ('stole',),
'stolt': ('stole',),
'stolte': ('stole',),
'stolp': ('stolpe',),
'stolpa': ('stolpe',),
'stolpe': ('stolpe',),
'stolper': ('stolpe',),
'stolpes': ('stolpe',),
'stolpet': ('stolpe',),
'stolpr': ('stolpre',),
'stolpra': ('stolpre',),
'stolpre': ('stolpre',),
'stolprer': ('stolpre',),
'stolpres': ('stolpre',),
'stolpret': ('stolpre',),
'stoltser': ('stoltsere',),
'stoltsere': ('stoltsere',),
'stoltserer': ('stoltsere',),
'stoltseres': ('stoltsere',),
'stoltsert': ('stoltsere',),
'stoltserte': ('stoltsere',),
'stoml': ('stomle',),
'stomla': ('stomle',),
'stomle': ('stomle',),
'stomler': ('stomle',),
'stomles': ('stomle',),
'stomlet': ('stomle',),
'stopp': ('stoppe',),
'stoppa': ('stoppe',),
'stoppe': ('stoppe',),
'stopper': ('stoppe',),
'stoppes': ('stoppe',),
'stoppet': ('stoppe',),
'stopp': ('stoppe',),
'stoppa': ('stoppe',),
'stoppe': ('stoppe',),
'stopper': ('stoppe',),
'stoppes': ('stoppe',),
'stoppet': ('stoppe',),
'storskreik': ('storskrike',),
'storskrek': ('storskrike',),
'storskreket': ('storskrike',),
'storskrik': ('storskrike',),
'storskrike': ('storskrike',),
'storskriker': ('storskrike',),
'storskrikes': ('storskrike',),
'stortreivs': ('stortrives',),
'stortrivdes': ('stortrives',),
'stortrives': ('stortrives',),
'stortrivs': ('stortrives',),
'stotr': ('stotre',),
'stotra': ('stotre',),
'stotre': ('stotre',),
'stotrer': ('stotre',),
'stotres': ('stotre',),
'stotret': ('stotre',),
'straff': ('straffe',),
'straffa': ('straffe',),
'straffe': ('straffe',),
'straffer': ('straffe',),
'straffes': ('straffe',),
'straffet': ('straffe',),
'straffedøm': ('straffedømme',),
'straffedømme': ('straffedømme',),
'straffedømmer': ('straffedømme',),
'straffedømmes': ('straffedømme',),
'straffedømt': ('straffedømme',),
'straffedømte': ('straffedømme',),
'stram': ('stramme',),
'stramma': ('stramme',),
'stramme': ('stramme',),
'strammer': ('stramme',),
'strammes': ('stramme',),
'strammet': ('stramme',),
'strand': ('strande',),
'stranda': ('strande',),
'strande': ('strande',),
'strander': ('strande',),
'strandes': ('strande',),
'strandet': ('strande',),
'stranguler': ('strangulere',),
'strangulere': ('strangulere',),
'strangulerer': ('strangulere',),
'stranguleres': ('strangulere',),
'strangulert': ('strangulere',),
'strangulerte': ('strangulere',),
'strant': ('strante',),
'stranta': ('strante',),
'strante': ('strante',),
'stranter': ('strante',),
'strantes': ('strante',),
'strantet': ('strante',),
'stratifiser': ('stratifisere',),
'stratifisere': ('stratifisere',),
'stratifiserer': ('stratifisere',),
'stratifiseres': ('stratifisere',),
'stratifisert': ('stratifisere',),
'stratifiserte': ('stratifisere',),
'streb': ('strebe',),
'streba': ('strebe',),
'strebe': ('strebe',),
'streber': ('strebe',),
'strebes': ('strebe',),
'strebet': ('strebe',),
'streif': ('streife',),
'streifa': ('streife',),
'streife': ('streife',),
'streifer': ('streife',),
'streifes': ('streife',),
'streifet': ('streife',),
'streik': ('streike',),
'streika': ('streike',),
'streike': ('streike',),
'streiker': ('streike',),
'streikes': ('streike',),
'streiket': ('streike',),
'streit': ('streite',),
'streita': ('streite',),
'streite': ('streite',),
'streiter': ('streite',),
'streites': ('streite',),
'streitet': ('streite',),
'strek': ('streke',),
'streka': ('streke',),
'streke': ('streke',),
'streker': ('streke',),
'strekes': ('streke',),
'streket': ('streke',),
'strend': ('strende',),
'strenda': ('strende',),
'strende': ('strende',),
'strender': ('strende',),
'strendes': ('strende',),
'strendet': ('strende',),
'strend': ('strende',),
'strenda': ('strende',),
'strende': ('strende',),
'strender': ('strende',),
'strendes': ('strende',),
'strendet': ('strende',),
'stren': ('strene',),
'strena': ('strene',),
'strene': ('strene',),
'strener': ('strene',),
'strenes': ('strene',),
'strenet': ('strene',),
'strent': ('strene',),
'strente': ('strene',),
'streng': ('strenge',),
'strenga': ('strenge',),
'strenge': ('strenge',),
'strenger': ('strenge',),
'strenges': ('strenge',),
'strenget': ('strenge',),
'strengl': ('strengle',),
'strengla': ('strengle',),
'strengle': ('strengle',),
'strengler': ('strengle',),
'strengles': ('strengle',),
'strenglet': ('strengle',),
'stress': ('stresse',),
'stressa': ('stresse',),
'stresse': ('stresse',),
'stresser': ('stresse',),
'stresses': ('stresse',),
'stresset': ('stresse',),
'strev': ('streve',),
'streva': ('streve',),
'strevd': ('streve',),
'strevde': ('streve',),
'streve': ('streve',),
'strever': ('streve',),
'streves': ('streve',),
'strevet': ('streve',),
'stred': ('stri',),
'strei': ('stri',),
'streid': ('stri',),
'stri': ('stri',),
'stridd': ('stri',),
'stridde': ('stri',),
'strir': ('stri',),
'stris': ('stri',),
'stred': ('stride',),
'strei': ('stride',),
'streid': ('stride',),
'strid': ('stride',),
'stridd': ('stride',),
'stridde': ('stride',),
'stride': ('stride',),
'strider': ('stride',),
'strides': ('stride',),
'stridgret': ('stridgråte',),
'stridgråt': ('stridgråte',),
'stridgråte': ('stridgråte',),
'stridgråter': ('stridgråte',),
'stridgråtes': ('stridgråte',),
'stridgrått': ('stridgråte',),
'stridregn': ('stridregne',),
'stridregna': ('stridregne',),
'stridregne': ('stridregne',),
'stridregner': ('stridregne',),
'stridregnes': ('stridregne',),
'stridregnet': ('stridregne',),
'strigl': ('strigle',),
'strigla': ('strigle',),
'strigle': ('strigle',),
'strigler': ('strigle',),
'strigles': ('strigle',),
'striglet': ('strigle',),
'strigret': ('strigråte',),
'strigråt': ('strigråte',),
'strigråte': ('strigråte',),
'strigråter': ('strigråte',),
'strigråtes': ('strigråte',),
'strigrått': ('strigråte',),
'strikk': ('strikke',),
'strikka': ('strikke',),
'strikke': ('strikke',),
'strikker': ('strikke',),
'strikkes': ('strikke',),
'strikket': ('strikke',),
'striml': ('strimle',),
'strimla': ('strimle',),
'strimle': ('strimle',),
'strimler': ('strimle',),
'strimles': ('strimle',),
'strimlet': ('strimle',),
'strip': ('stripe',),
'stripa': ('stripe',),
'stripe': ('stripe',),
'striper': ('stripe',),
'stripes': ('stripe',),
'stripet': ('stripe',),
'stript': ('stripe',),
'stripte': ('stripe',),
'stripp': ('strippe',),
'strippa': ('strippe',),
'strippe': ('strippe',),
'stripper': ('strippe',),
'strippes': ('strippe',),
'strippet': ('strippe',),
'stritt': ('stritte',),
'stritta': ('stritte',),
'stritte': ('stritte',),
'stritter': ('stritte',),
'strittes': ('stritte',),
'strittet': ('stritte',),
'stropp': ('stroppe',),
'stroppa': ('stroppe',),
'stroppe': ('stroppe',),
'stropper': ('stroppe',),
'stroppes': ('stroppe',),
'stroppet': ('stroppe',),
'strukturer': ('strukturere',),
'strukturere': ('strukturere',),
'strukturerer': ('strukturere',),
'struktureres': ('strukturere',),
'strukturert': ('strukturere',),
'strukturerte': ('strukturere',),
'strup': ('strupe',),
'strupe': ('strupe',),
'struper': ('strupe',),
'strupes': ('strupe',),
'strupt': ('strupe',),
'strupte': ('strupe',),
'strutt': ('strutte',),
'strutta': ('strutte',),
'strutte': ('strutte',),
'strutter': ('strutte',),
'struttes': ('strutte',),
'struttet': ('strutte',),
'strauk': ('stryke',),
'stryk': ('stryke',),
'stryke': ('stryke',),
'stryker': ('stryke',),
'strykes': ('stryke',),
'strøk': ('stryke',),
'strøket': ('stryke',),
'strøyk': ('stryke',),
'stryp': ('strype',),
'strype': ('strype',),
'stryper': ('strype',),
'strypes': ('strype',),
'strypt': ('strype',),
'strypte': ('strype',),
'strål': ('stråle',),
'stråle': ('stråle',),
'stråler': ('stråle',),
'stråles': ('stråle',),
'strålt': ('stråle',),
'strålte': ('stråle',),
'strø': ('strø',),
'strødd': ('strø',),
'strødde': ('strø',),
'strør': ('strø',),
'strøs': ('strø',),
'strøm': ('strømme',),
'strømma': ('strømme',),
'strømme': ('strømme',),
'strømmer': ('strømme',),
'strømmes': ('strømme',),
'strømmet': ('strømme',),
'strømt': ('strømme',),
'strømte': ('strømme',),
'studer': ('studere',),
'studere': ('studere',),
'studerer': ('studere',),
'studeres': ('studere',),
'studert': ('studere',),
'studerte': ('studere',),
'stu': ('stue',),
'stua': ('stue',),
'stue': ('stue',),
'stuer': ('stue',),
'stues': ('stue',),
'stuet': ('stue',),
'stu': ('stue',),
'stua': ('stue',),
'stue': ('stue',),
'stuer': ('stue',),
'stues': ('stue',),
'stuet': ('stue',),
'stu': ('stue',),
'stua': ('stue',),
'stue': ('stue',),
'stuer': ('stue',),
'stues': ('stue',),
'stuet': ('stue',),
'stu': ('stue',),
'stua': ('stue',),
'stue': ('stue',),
'stuer': ('stue',),
'stues': ('stue',),
'stuet': ('stue',),
'stu': ('stue',),
'stua': ('stue',),
'stue': ('stue',),
'stuer': ('stue',),
'stues': ('stue',),
'stuet': ('stue',),
'stuk': ('stuke',),
'stuka': ('stuke',),
'stuke': ('stuke',),
'stuker': ('stuke',),
'stukes': ('stuke',),
'stuket': ('stuke',),
'stukt': ('stuke',),
'stukte': ('stuke',),
'stull': ('stulle',),
'stulla': ('stulle',),
'stulle': ('stulle',),
'stuller': ('stulle',),
'stulles': ('stulle',),
'stullet': ('stulle',),
'stump': ('stumpe',),
'stumpa': ('stumpe',),
'stumpe': ('stumpe',),
'stumper': ('stumpe',),
'stumpes': ('stumpe',),
'stumpet': ('stumpe',),
'stund': ('stunde',),
'stunda': ('stunde',),
'stunde': ('stunde',),
'stunder': ('stunde',),
'stundes': ('stunde',),
'stundet': ('stunde',),
'stup': ('stupe',),
'stupe': ('stupe',),
'stuper': ('stupe',),
'stupes': ('stupe',),
'stupt': ('stupe',),
'stupte': ('stupe',),
'stur': ('sture',),
'stura': ('sture',),
'sture': ('sture',),
'sturer': ('sture',),
'stures': ('sture',),
'sturet': ('sture',),
'sturt': ('sture',),
'sturte': ('sture',),
'sturt': ('sturte',),
'sturta': ('sturte',),
'sturte': ('sturte',),
'sturter': ('sturte',),
'sturtes': ('sturte',),
'sturtet': ('sturte',),
'stuss': ('stusse',),
'stussa': ('stusse',),
'stusse': ('stusse',),
'stusser': ('stusse',),
'stusses': ('stusse',),
'stusset': ('stusse',),
'stuss': ('stusse',),
'stussa': ('stusse',),
'stusse': ('stusse',),
'stusser': ('stusse',),
'stusses': ('stusse',),
'stusset': ('stusse',),
'stutn': ('stutne',),
'stutna': ('stutne',),
'stutne': ('stutne',),
'stutner': ('stutne',),
'stutnes': ('stutne',),
'stutnet': ('stutne',),
'stutt': ('stutte',),
'stutta': ('stutte',),
'stutte': ('stutte',),
'stutter': ('stutte',),
'stuttes': ('stutte',),
'stuttet': ('stutte',),
'stuv': ('stuve',),
'stuva': ('stuve',),
'stuve': ('stuve',),
'stuver': ('stuve',),
'stuves': ('stuve',),
'stuvet': ('stuve',),
'stuv': ('stuve',),
'stuva': ('stuve',),
'stuve': ('stuve',),
'stuver': ('stuve',),
'stuves': ('stuve',),
'stuvet': ('stuve',),
'stuv': ('stuve',),
'stuva': ('stuve',),
'stuve': ('stuve',),
'stuver': ('stuve',),
'stuves': ('stuve',),
'stuvet': ('stuve',),
'stuv': ('stuve',),
'stuva': ('stuve',),
'stuve': ('stuve',),
'stuver': ('stuve',),
'stuves': ('stuve',),
'stuvet': ('stuve',),
'stygdes': ('stygges',),
'stygges': ('stygges',),
'stykk': ('stykke',),
'stykka': ('stykke',),
'stykke': ('stykke',),
'stykker': ('stykke',),
'stykkes': ('stykke',),
'stykket': ('stykke',),
'stykt': ('stykke',),
'stykte': ('stykke',),
'stylt': ('stylte',),
'stylta': ('stylte',),
'stylte': ('stylte',),
'stylter': ('stylte',),
'styltes': ('stylte',),
'styltet': ('stylte',),
'styltr': ('styltre',),
'styltra': ('styltre',),
'styltre': ('styltre',),
'styltrer': ('styltre',),
'styltres': ('styltre',),
'styltret': ('styltre',),
'styr': ('styre',),
'styre': ('styre',),
'styrer': ('styre',),
'styres': ('styre',),
'styrt': ('styre',),
'styrte': ('styre',),
'styr': ('styre',),
'styra': ('styre',),
'styre': ('styre',),
'styrer': ('styre',),
'styres': ('styre',),
'styret': ('styre',),
'styrt': ('styre',),
'styrte': ('styre',),
'styrk': ('styrke',),
'styrka': ('styrke',),
'styrke': ('styrke',),
'styrker': ('styrke',),
'styrkes': ('styrke',),
'styrket': ('styrke',),
'styrkt': ('styrke',),
'styrkte': ('styrke',),
'styrtblø': ('styrtblø',),
'styrtblødd': ('styrtblø',),
'styrtblødde': ('styrtblø',),
'styrtblør': ('styrtblø',),
'styrtbløs': ('styrtblø',),
'styrt': ('styrte',),
'styrta': ('styrte',),
'styrte': ('styrte',),
'styrter': ('styrte',),
'styrtes': ('styrte',),
'styrtet': ('styrte',),
'styrtregn': ('styrtregne',),
'styrtregna': ('styrtregne',),
'styrtregne': ('styrtregne',),
'styrtregner': ('styrtregne',),
'styrtregnes': ('styrtregne',),
'styrtregnet': ('styrtregne',),
'styrtregnt': ('styrtregne',),
'styrtregnte': ('styrtregne',),
'sto': ('stå',),
'stod': ('stå',),
'stå': ('stå',),
'ståes': ('stå',),
'står': ('stå',),
'stås': ('stå',),
'stått': ('stå',),
'ståk': ('ståke',),
'ståka': ('ståke',),
'ståke': ('ståke',),
'ståker': ('ståke',),
'ståkes': ('ståke',),
'ståket': ('ståke',),
'stålsatt': ('stålsette',),
'stålsatte': ('stålsette',),
'stålsett': ('stålsette',),
'stålsette': ('stålsette',),
'stålsetter': ('stålsette',),
'stålsettes': ('stålsette',),
'stø': ('stø',),
'stødd': ('stø',),
'stødde': ('stø',),
'stør': ('stø',),
'støs': ('stø',),
'stø': ('støe',),
'stødd': ('støe',),
'stødde': ('støe',),
'støe': ('støe',),
'støedd': ('støe',),
'støedde': ('støe',),
'støer': ('støe',),
'støes': ('støe',),
'støl': ('støle',),
'støla': ('støle',),
'støle': ('støle',),
'støler': ('støle',),
'støles': ('støle',),
'stølet': ('støle',),
'stølt': ('støle',),
'stølte': ('støle',),
'støln': ('stølne',),
'stølna': ('stølne',),
'stølne': ('stølne',),
'stølner': ('stølne',),
'stølnes': ('stølne',),
'stølnet': ('stølne',),
'stønn': ('stønne',),
'stønna': ('stønne',),
'stønne': ('stønne',),
'stønner': ('stønne',),
'stønnes': ('stønne',),
'stønnet': ('stønne',),
'stønt': ('stønne',),
'stønte': ('stønne',),
'støp': ('støpe',),
'støpe': ('støpe',),
'støper': ('støpe',),
'støpes': ('støpe',),
'støpt': ('støpe',),
'støpte': ('støpe',),
'størkn': ('størkne',),
'størkna': ('størkne',),
'størkne': ('størkne',),
'størkner': ('størkne',),
'størknes': ('størkne',),
'størknet': ('størkne',),
'støt': ('støte',),
'støte': ('støte',),
'støter': ('støte',),
'støtes': ('støte',),
'støtt': ('støte',),
'støtte': ('støte',),
'støtt': ('støtte',),
'støtta': ('støtte',),
'støtte': ('støtte',),
'støtter': ('støtte',),
'støttes': ('støtte',),
'støttet': ('støtte',),
'støv': ('støve',),
'støva': ('støve',),
'støve': ('støve',),
'støver': ('støve',),
'støves': ('støve',),
'støvet': ('støve',),
'støvsug': ('støvsuge',),
'støvsuga': ('støvsuge',),
'støvsugd': ('støvsuge',),
'støvsugde': ('støvsuge',),
'støvsuge': ('støvsuge',),
'støvsuger': ('støvsuge',),
'støvsuges': ('støvsuge',),
'støvsuget': ('støvsuge',),
'støy': ('støye',),
'støya': ('støye',),
'støyd': ('støye',),
'støyde': ('støye',),
'støye': ('støye',),
'støyer': ('støye',),
'støyes': ('støye',),
'støyet': ('støye',),
'støyp': ('støype',),
'støype': ('støype',),
'støyper': ('støype',),
'støypes': ('støype',),
'støypt': ('støype',),
'støypte': ('støype',),
'støyt': ('støyte',),
'støyte': ('støyte',),
'støyter': ('støyte',),
'støytes': ('støyte',),
'støytt': ('støyte',),
'støytte': ('støyte',),
'subb': ('subbe',),
'subba': ('subbe',),
'subbe': ('subbe',),
'subber': ('subbe',),
'subbes': ('subbe',),
'subbet': ('subbe',),
'sublimer': ('sublimere',),
'sublimere': ('sublimere',),
'sublimerer': ('sublimere',),
'sublimeres': ('sublimere',),
'sublimert': ('sublimere',),
'sublimerte': ('sublimere',),
'subordiner': ('subordinere',),
'subordinere': ('subordinere',),
'subordinerer': ('subordinere',),
'subordineres': ('subordinere',),
'subordinert': ('subordinere',),
'subordinerte': ('subordinere',),
'subsidier': ('subsidiere',),
'subsidiere': ('subsidiere',),
'subsidierer': ('subsidiere',),
'subsidieres': ('subsidiere',),
'subsidiert': ('subsidiere',),
'subsidierte': ('subsidiere',),
'subskriber': ('subskribere',),
'subskribere': ('subskribere',),
'subskriberer': ('subskribere',),
'subskriberes': ('subskribere',),
'subskribert': ('subskribere',),
'subskriberte': ('subskribere',),
'substantiver': ('substantivere',),
'substantivere': ('substantivere',),
'substantiverer': ('substantivere',),
'substantiveres': ('substantivere',),
'substantivert': ('substantivere',),
'substantiverte': ('substantivere',),
'substituer': ('substituere',),
'substituere': ('substituere',),
'substituerer': ('substituere',),
'substitueres': ('substituere',),
'substituert': ('substituere',),
'substituerte': ('substituere',),
'subsumer': ('subsumere',),
'subsumere': ('subsumere',),
'subsumerer': ('subsumere',),
'subsumeres': ('subsumere',),
'subsumert': ('subsumere',),
'subsumerte': ('subsumere',),
'subtraher': ('subtrahere',),
'subtrahere': ('subtrahere',),
'subtraherer': ('subtrahere',),
'subtraheres': ('subtrahere',),
'subtrahert': ('subtrahere',),
'subtraherte': ('subtrahere',),
'subvener': ('subvenere',),
'subvenere': ('subvenere',),
'subvenerer': ('subvenere',),
'subveneres': ('subvenere',),
'subvenert': ('subvenere',),
'subvenerte': ('subvenere',),
'suffiger': ('suffigere',),
'suffigere': ('suffigere',),
'suffigerer': ('suffigere',),
'suffigeres': ('suffigere',),
'suffigert': ('suffigere',),
'suffigerte': ('suffigere',),
'suffler': ('sufflere',),
'sufflere': ('sufflere',),
'sufflerer': ('sufflere',),
'suffleres': ('sufflere',),
'sufflert': ('sufflere',),
'sufflerte': ('sufflere',),
'saug': ('suge',),
'sug': ('suge',),
'suga': ('suge',),
'sugd': ('suge',),
'sugde': ('suge',),
'suge': ('suge',),
'suger': ('suge',),
'suges': ('suge',),
'suget': ('suge',),
'suggerer': ('suggerere',),
'suggerere': ('suggerere',),
'suggererer': ('suggerere',),
'suggereres': ('suggerere',),
'suggerert': ('suggerere',),
'suggererte': ('suggerere',),
'sukk': ('sukke',),
'sukka': ('sukke',),
'sukke': ('sukke',),
'sukker': ('sukke',),
'sukkes': ('sukke',),
'sukket': ('sukke',),
'sukl': ('sukle',),
'sukla': ('sukle',),
'sukle': ('sukle',),
'sukler': ('sukle',),
'sukles': ('sukle',),
'suklet': ('sukle',),
'sukr': ('sukre',),
'sukra': ('sukre',),
'sukre': ('sukre',),
'sukrer': ('sukre',),
'sukres': ('sukre',),
'sukret': ('sukre',),
'sukseder': ('suksedere',),
'suksedere': ('suksedere',),
'suksederer': ('suksedere',),
'suksederes': ('suksedere',),
'suksedert': ('suksedere',),
'suksederte': ('suksedere',),
'sulk': ('sulke',),
'sulka': ('sulke',),
'sulke': ('sulke',),
'sulker': ('sulke',),
'sulkes': ('sulke',),
'sulket': ('sulke',),
'sull': ('sulle',),
'sulla': ('sulle',),
'sulle': ('sulle',),
'suller': ('sulle',),
'sulles': ('sulle',),
'sullet': ('sulle',),
'sull': ('sulle',),
'sulla': ('sulle',),
'sulle': ('sulle',),
'suller': ('sulle',),
'sulles': ('sulle',),
'sullet': ('sulle',),
'sult': ('sulte',),
'sulta': ('sulte',),
'sulte': ('sulte',),
'sulter': ('sulte',),
'sultes': ('sulte',),
'sultet': ('sulte',),
'sum': ('summe',),
'summa': ('summe',),
'summe': ('summe',),
'summer': ('summe',),
'summes': ('summe',),
'summet': ('summe',),
'sum': ('summe',),
'summa': ('summe',),
'summe': ('summe',),
'summer': ('summe',),
'summes': ('summe',),
'summet': ('summe',),
'summer': ('summere',),
'summere': ('summere',),
'summerer': ('summere',),
'summeres': ('summere',),
'summert': ('summere',),
'summerte': ('summere',),
'saup': ('supe',),
'sup': ('supe',),
'supe': ('supe',),
'super': ('supe',),
'supes': ('supe',),
'supt': ('supe',),
'supte': ('supe',),
'super': ('supere',),
'supere': ('supere',),
'superer': ('supere',),
'superes': ('supere',),
'supert': ('supere',),
'superte': ('supere',),
'supiner': ('supinere',),
'supinere': ('supinere',),
'supinerer': ('supinere',),
'supineres': ('supinere',),
'supinert': ('supinere',),
'supinerte': ('supinere',),
'suppler': ('supplere',),
'supplere': ('supplere',),
'supplerer': ('supplere',),
'suppleres': ('supplere',),
'supplert': ('supplere',),
'supplerte': ('supplere',),
'supplikker': ('supplikkere',),
'supplikkere': ('supplikkere',),
'supplikkerer': ('supplikkere',),
'supplikkeres': ('supplikkere',),
'supplikkert': ('supplikkere',),
'supplikkerte': ('supplikkere',),
'supponer': ('supponere',),
'supponere': ('supponere',),
'supponerer': ('supponere',),
'supponeres': ('supponere',),
'supponert': ('supponere',),
'supponerte': ('supponere',),
'supprimer': ('supprimere',),
'supprimere': ('supprimere',),
'supprimerer': ('supprimere',),
'supprimeres': ('supprimere',),
'supprimert': ('supprimere',),
'supprimerte': ('supprimere',),
'surf': ('surfe',),
'surfa': ('surfe',),
'surfe': ('surfe',),
'surfer': ('surfe',),
'surfes': ('surfe',),
'surfet': ('surfe',),
'surkl': ('surkle',),
'surkla': ('surkle',),
'surkle': ('surkle',),
'surkler': ('surkle',),
'surkles': ('surkle',),
'surklet': ('surkle',),
'surl': ('surle',),
'surla': ('surle',),
'surle': ('surle',),
'surler': ('surle',),
'surles': ('surle',),
'surlet': ('surle',),
'surmul': ('surmule',),
'surmule': ('surmule',),
'surmuler': ('surmule',),
'surmules': ('surmule',),
'surmult': ('surmule',),
'surmulte': ('surmule',),
'surn': ('surne',),
'surna': ('surne',),
'surne': ('surne',),
'surner': ('surne',),
'surnes': ('surne',),
'surnet': ('surne',),
'surr': ('surre',),
'surra': ('surre',),
'surre': ('surre',),
'surrer': ('surre',),
'surres': ('surre',),
'surret': ('surre',),
'surr': ('surre',),
'surra': ('surre',),
'surre': ('surre',),
'surrer': ('surre',),
'surres': ('surre',),
'surret': ('surre',),
'sus': ('suse',),
'suse': ('suse',),
'suser': ('suse',),
'suses': ('suse',),
'sust': ('suse',),
'suste': ('suse',),
'susl': ('susle',),
'susla': ('susle',),
'susle': ('susle',),
'susler': ('susle',),
'susles': ('susle',),
'suslet': ('susle',),
'suspender': ('suspendere',),
'suspendere': ('suspendere',),
'suspenderer': ('suspendere',),
'suspenderes': ('suspendere',),
'suspendert': ('suspendere',),
'suspenderte': ('suspendere',),
'suss': ('susse',),
'sussa': ('susse',),
'susse': ('susse',),
'susser': ('susse',),
'susses': ('susse',),
'susset': ('susse',),
'sutener': ('sutenere',),
'sutenere': ('sutenere',),
'sutenerer': ('sutenere',),
'suteneres': ('sutenere',),
'sutenert': ('sutenere',),
'sutenerte': ('sutenere',),
'sutr': ('sutre',),
'sutra': ('sutre',),
'sutre': ('sutre',),
'sutrer': ('sutre',),
'sutres': ('sutre',),
'sutret': ('sutre',),
'sutt': ('sutte',),
'sutta': ('sutte',),
'sutte': ('sutte',),
'sutter': ('sutte',),
'suttes': ('sutte',),
'suttet': ('sutte',),
'svabr': ('svabre',),
'svabra': ('svabre',),
'svabre': ('svabre',),
'svabrer': ('svabre',),
'svabres': ('svabre',),
'svabret': ('svabre',),
'svag': ('svage',),
'svaga': ('svage',),
'svage': ('svage',),
'svager': ('svage',),
'svages': ('svage',),
'svaget': ('svage',),
'svai': ('svaie',),
'svaia': ('svaie',),
'svaie': ('svaie',),
'svaier': ('svaie',),
'svaies': ('svaie',),
'svaiet': ('svaie',),
'sval': ('svale',),
'svala': ('svale',),
'svale': ('svale',),
'svaler': ('svale',),
'svales': ('svale',),
'svalet': ('svale',),
'svalt': ('svale',),
'svalte': ('svale',),
'svaln': ('svalne',),
'svalna': ('svalne',),
'svalne': ('svalne',),
'svalner': ('svalne',),
'svalnes': ('svalne',),
'svalnet': ('svalne',),
'svamp': ('svampe',),
'svampa': ('svampe',),
'svampe': ('svampe',),
'svamper': ('svampe',),
'svampes': ('svampe',),
'svampet': ('svampe',),
'svans': ('svanse',),
'svansa': ('svanse',),
'svanse': ('svanse',),
'svanser': ('svanse',),
'svanses': ('svanse',),
'svanset': ('svanse',),
'svar': ('svare',),
'svara': ('svare',),
'svare': ('svare',),
'svarer': ('svare',),
'svares': ('svare',),
'svart': ('svare',),
'svarte': ('svare',),
'svartelist': ('svarteliste',),
'svartelista': ('svarteliste',),
'svarteliste': ('svarteliste',),
'svartelister': ('svarteliste',),
'svartelistes': ('svarteliste',),
'svartelistet': ('svarteliste',),
'svartmal': ('svartmale',),
'svartmale': ('svartmale',),
'svartmaler': ('svartmale',),
'svartmales': ('svartmale',),
'svartmalt': ('svartmale',),
'svartmalte': ('svartmale',),
'svartn': ('svartne',),
'svartna': ('svartne',),
'svartne': ('svartne',),
'svartner': ('svartne',),
'svartnes': ('svartne',),
'svartnet': ('svartne',),
'svarv': ('svarve',),
'svarva': ('svarve',),
'svarve': ('svarve',),
'svarver': ('svarve',),
'svarves': ('svarve',),
'svarvet': ('svarve',),
'sveip': ('sveipe',),
'sveipa': ('sveipe',),
'sveipe': ('sveipe',),
'sveiper': ('sveipe',),
'sveipes': ('sveipe',),
'sveipet': ('sveipe',),
'sveipt': ('sveipe',),
'sveipte': ('sveipe',),
'sveiv': ('sveive',),
'sveiva': ('sveive',),
'sveivd': ('sveive',),
'sveivde': ('sveive',),
'sveive': ('sveive',),
'sveiver': ('sveive',),
'sveives': ('sveive',),
'sveivet': ('sveive',),
'svekk': ('svekke',),
'svekka': ('svekke',),
'svekke': ('svekke',),
'svekker': ('svekke',),
'svekkes': ('svekke',),
'svekket': ('svekke',),
'svekt': ('svekke',),
'svekte': ('svekke',),
'svelg': ('svelge',),
'svelga': ('svelge',),
'svelge': ('svelge',),
'svelger': ('svelge',),
'svelges': ('svelge',),
'svelget': ('svelge',),
'svelg': ('svelgje',),
'svelgd': ('svelgje',),
'svelgde': ('svelgje',),
'svelgja': ('svelgje',),
'svelgje': ('svelgje',),
'svelgjer': ('svelgje',),
'svelgjes': ('svelgje',),
'svelgjet': ('svelgje',),
'svell': ('svelle',),
'svella': ('svelle',),
'svelle': ('svelle',),
'sveller': ('svelle',),
'svelles': ('svelle',),
'svellet': ('svelle',),
'svelt': ('svelle',),
'svelte': ('svelle',),
'svelt': ('svelte',),
'svelta': ('svelte',),
'svelte': ('svelte',),
'svelter': ('svelte',),
'sveltes': ('svelte',),
'sveltet': ('svelte',),
'svalt': ('svelte',),
'svelt': ('svelte',),
'svelte': ('svelte',),
'svelter': ('svelte',),
'sveltes': ('svelte',),
'sveltet': ('svelte',),
'sverg': ('sverge',),
'sverga': ('sverge',),
'sverge': ('sverge',),
'sverger': ('sverge',),
'sverges': ('sverge',),
'sverget': ('sverge',),
'svor': ('sverge',),
'svoret': ('sverge',),
'sverj': ('sverje',),
'sverja': ('sverje',),
'sverje': ('sverje',),
'sverjer': ('sverje',),
'sverjes': ('sverje',),
'sverjet': ('sverje',),
'svor': ('sverje',),
'svoret': ('sverje',),
'sverm': ('sverme',),
'sverma': ('sverme',),
'sverme': ('sverme',),
'svermer': ('sverme',),
'svermes': ('sverme',),
'svermet': ('sverme',),
'svert': ('sverte',),
'sverta': ('sverte',),
'sverte': ('sverte',),
'sverter': ('sverte',),
'svertes': ('sverte',),
'svertet': ('sverte',),
'svett': ('svette',),
'svetta': ('svette',),
'svette': ('svette',),
'svetter': ('svette',),
'svettes': ('svette',),
'svettet': ('svette',),
'svev': ('sveve',),
'sveva': ('sveve',),
'svevd': ('sveve',),
'svevde': ('sveve',),
'sveve': ('sveve',),
'svever': ('sveve',),
'sveves': ('sveve',),
'svevet': ('sveve',),
'sveik': ('svike',),
'svek': ('svike',),
'sveket': ('svike',),
'svik': ('svike',),
'svike': ('svike',),
'sviker': ('svike',),
'svikes': ('svike',),
'svikt': ('svikte',),
'svikta': ('svikte',),
'svikte': ('svikte',),
'svikter': ('svikte',),
'sviktes': ('svikte',),
'sviktet': ('svikte',),
'svim': ('svime',),
'svima': ('svime',),
'svime': ('svime',),
'svimer': ('svime',),
'svimes': ('svime',),
'svimet': ('svime',),
'svimt': ('svime',),
'svimte': ('svime',),
'svimerk': ('svimerke',),
'svimerka': ('svimerke',),
'svimerke': ('svimerke',),
'svimerker': ('svimerke',),
'svimerkes': ('svimerke',),
'svimerket': ('svimerke',),
'svimeslo': ('svimeslå',),
'svimeslå': ('svimeslå',),
'svimeslåes': ('svimeslå',),
'svimeslår': ('svimeslå',),
'svimeslås': ('svimeslå',),
'svimeslått': ('svimeslå',),
'sviml': ('svimle',),
'svimla': ('svimle',),
'svimle': ('svimle',),
'svimler': ('svimle',),
'svimles': ('svimle',),
'svimlet': ('svimle',),
'svimr': ('svimre',),
'svimra': ('svimre',),
'svimre': ('svimre',),
'svimrer': ('svimre',),
'svimres': ('svimre',),
'svimret': ('svimre',),
'svindl': ('svindle',),
'svindla': ('svindle',),
'svindle': ('svindle',),
'svindler': ('svindle',),
'svindles': ('svindle',),
'svindlet': ('svindle',),
'svin': ('svine',),
'svina': ('svine',),
'svine': ('svine',),
'sviner': ('svine',),
'svines': ('svine',),
'svinet': ('svine',),
'svint': ('svine',),
'svinte': ('svine',),
'svinebandt': ('svinebinde',),
'svinebind': ('svinebinde',),
'svinebinde': ('svinebinde',),
'svinebinder': ('svinebinde',),
'svinebindes': ('svinebinde',),
'svinebundet': ('svinebinde',),
'sving': ('svinge',),
'svinga': ('svinge',),
'svinge': ('svinge',),
'svinger': ('svinge',),
'svinges': ('svinge',),
'svinget': ('svinge',),
'svingt': ('svinge',),
'svingte': ('svinge',),
'svang': ('svinge',),
'sving': ('svinge',),
'svinge': ('svinge',),
'svinger': ('svinge',),
'svinges': ('svinge',),
'svinget': ('svinge',),
'svingt': ('svinge',),
'svunget': ('svinge',),
'svann': ('svinne',),
'svant': ('svinne',),
'svinn': ('svinne',),
'svinne': ('svinne',),
'svinner': ('svinne',),
'svinnes': ('svinne',),
'svunnet': ('svinne',),
'svins': ('svinse',),
'svinsa': ('svinse',),
'svinse': ('svinse',),
'svinser': ('svinse',),
'svinses': ('svinse',),
'svinset': ('svinse',),
'svint': ('svinte',),
'svinta': ('svinte',),
'svinte': ('svinte',),
'svinter': ('svinte',),
'svintes': ('svinte',),
'svintet': ('svinte',),
'svipp': ('svippe',),
'svippa': ('svippe',),
'svippe': ('svippe',),
'svipper': ('svippe',),
'svippes': ('svippe',),
'svippet': ('svippe',),
'svir': ('svire',),
'svira': ('svire',),
'svire': ('svire',),
'svirer': ('svire',),
'svires': ('svire',),
'sviret': ('svire',),
'svirt': ('svire',),
'svirte': ('svire',),
'svirr': ('svirre',),
'svirra': ('svirre',),
'svirre': ('svirre',),
'svirrer': ('svirre',),
'svirres': ('svirre',),
'svirret': ('svirre',),
'sveiv': ('svive',),
'svev': ('svive',),
'sviv': ('svive',),
'sviva': ('svive',),
'svivd': ('svive',),
'svive': ('svive',),
'sviver': ('svive',),
'svives': ('svive',),
'svivet': ('svive',),
'svivørd': ('svivørde',),
'svivørde': ('svivørde',),
'svivørder': ('svivørde',),
'svivørdes': ('svivørde',),
'svivørdt': ('svivørde',),
'svivørdte': ('svivørde',),
'svivør': ('svivøre',),
'svivøre': ('svivøre',),
'svivører': ('svivøre',),
'svivøres': ('svivøre',),
'svivørt': ('svivøre',),
'svivørte': ('svivøre',),
'svolk': ('svolke',),
'svolka': ('svolke',),
'svolke': ('svolke',),
'svolker': ('svolke',),
'svolkes': ('svolke',),
'svolket': ('svolke',),
'svovl': ('svovle',),
'svovla': ('svovle',),
'svovle': ('svovle',),
'svovler': ('svovle',),
'svovles': ('svovle',),
'svovlet': ('svovle',),
'svulm': ('svulme',),
'svulma': ('svulme',),
'svulme': ('svulme',),
'svulmer': ('svulme',),
'svulmes': ('svulme',),
'svulmet': ('svulme',),
'svuln': ('svulne',),
'svulna': ('svulne',),
'svulne': ('svulne',),
'svulner': ('svulne',),
'svulnes': ('svulne',),
'svulnet': ('svulne',),
'svupp': ('svuppe',),
'svuppa': ('svuppe',),
'svuppe': ('svuppe',),
'svupper': ('svuppe',),
'svuppes': ('svuppe',),
'svuppet': ('svuppe',),
'svæv': ('svæve',),
'svævd': ('svæve',),
'svævde': ('svæve',),
'svæve': ('svæve',),
'svæver': ('svæve',),
'svæves': ('svæve',),
'svøm': ('svømme',),
'svømme': ('svømme',),
'svømmer': ('svømme',),
'svømmes': ('svømme',),
'svømt': ('svømme',),
'svømte': ('svømme',),
'svøp': ('svøpe',),
'svøpe': ('svøpe',),
'svøper': ('svøpe',),
'svøpes': ('svøpe',),
'svøpt': ('svøpe',),
'svøpte': ('svøpe',),
'sy': ('sy',),
'sydd': ('sy',),
'sydde': ('sy',),
'syes': ('sy',),
'syr': ('sy',),
'sys': ('sy',),
'syd': ('syde',),
'syda': ('syde',),
'syde': ('syde',),
'syder': ('syde',),
'sydes': ('syde',),
'sydet': ('syde',),
'sykemeld': ('sykemelde',),
'sykemelde': ('sykemelde',),
'sykemelder': ('sykemelde',),
'sykemeldes': ('sykemelde',),
'sykemeldt': ('sykemelde',),
'sykemeldte': ('sykemelde',),
'sykl': ('sykle',),
'sykla': ('sykle',),
'sykle': ('sykle',),
'sykler': ('sykle',),
'sykles': ('sykle',),
'syklet': ('sykle',),
'sykmeld': ('sykmelde',),
'sykmelde': ('sykmelde',),
'sykmelder': ('sykmelde',),
'sykmeldes': ('sykmelde',),
'sykmeldt': ('sykmelde',),
'sykmeldte': ('sykmelde',),
'sykn': ('sykne',),
'sykna': ('sykne',),
'sykne': ('sykne',),
'sykner': ('sykne',),
'syknes': ('sykne',),
'syknet': ('sykne',),
'sylt': ('sylte',),
'sylta': ('sylte',),
'sylte': ('sylte',),
'sylter': ('sylte',),
'syltes': ('sylte',),
'syltet': ('sylte',),
'symboliser': ('symbolisere',),
'symbolisere': ('symbolisere',),
'symboliserer': ('symbolisere',),
'symboliseres': ('symbolisere',),
'symbolisert': ('symbolisere',),
'symboliserte': ('symbolisere',),
'sympatiser': ('sympatisere',),
'sympatisere': ('sympatisere',),
'sympatiserer': ('sympatisere',),
'sympatiseres': ('sympatisere',),
'sympatisert': ('sympatisere',),
'sympatiserte': ('sympatisere',),
'sympatistreik': ('sympatistreike',),
'sympatistreika': ('sympatistreike',),
'sympatistreike': ('sympatistreike',),
'sympatistreiker': ('sympatistreike',),
'sympatistreikes': ('sympatistreike',),
'sympatistreiket': ('sympatistreike',),
'synd': ('synde',),
'synda': ('synde',),
'synde': ('synde',),
'synder': ('synde',),
'syndes': ('synde',),
'syndet': ('synde',),
'syn': ('syne',),
'syne': ('syne',),
'syner': ('syne',),
'synes': ('syne',),
'synt': ('syne',),
'synte': ('syne',),
'synes': ('synes',),
'syns': ('synes',),
'syntes': ('synes',),
'synfar': ('synfare',),
'synfare': ('synfare',),
'synfarer': ('synfare',),
'synfares': ('synfare',),
'synfart': ('synfare',),
'synfor': ('synfare',),
'sang': ('synge',),
'sunget': ('synge',),
'syng': ('synge',),
'synge': ('synge',),
'synger': ('synge',),
'synges': ('synge',),
'sank': ('synke',),
'sunket': ('synke',),
'synk': ('synke',),
'synke': ('synke',),
'synker': ('synke',),
'synkes': ('synke',),
'synkoper': ('synkopere',),
'synkopere': ('synkopere',),
'synkoperer': ('synkopere',),
'synkoperes': ('synkopere',),
'synkopert': ('synkopere',),
'synkoperte': ('synkopere',),
'synkroniser': ('synkronisere',),
'synkronisere': ('synkronisere',),
'synkroniserer': ('synkronisere',),
'synkroniseres': ('synkronisere',),
'synkronisert': ('synkronisere',),
'synkroniserte': ('synkronisere',),
'synkverv': ('synkverve',),
'synkverva': ('synkverve',),
'synkvervd': ('synkverve',),
'synkvervde': ('synkverve',),
'synkverve': ('synkverve',),
'synkverver': ('synkverve',),
'synkverves': ('synkverve',),
'synkvervet': ('synkverve',),
'synliggjorde': ('synliggjøre',),
'synliggjort': ('synliggjøre',),
'synliggjør': ('synliggjøre',),
'synliggjøre': ('synliggjøre',),
'synliggjøres': ('synliggjøre',),
'syns': ('synse',),
'synsa': ('synse',),
'synse': ('synse',),
'synser': ('synse',),
'synses': ('synse',),
'synset': ('synse',),
'syntetiser': ('syntetisere',),
'syntetisere': ('syntetisere',),
'syntetiserer': ('syntetisere',),
'syntetiseres': ('syntetisere',),
'syntetisert': ('syntetisere',),
'syntetiserte': ('syntetisere',),
'syr': ('syre',),
'syra': ('syre',),
'syre': ('syre',),
'syrer': ('syre',),
'syres': ('syre',),
'syret': ('syre',),
'syrt': ('syre',),
'syrte': ('syre',),
'syrn': ('syrne',),
'syrna': ('syrne',),
'syrne': ('syrne',),
'syrner': ('syrne',),
'syrnes': ('syrne',),
'syrnet': ('syrne',),
'sysl': ('sysle',),
'sysla': ('sysle',),
'sysle': ('sysle',),
'sysler': ('sysle',),
'sysles': ('sysle',),
'syslet': ('sysle',),
'sysselsatt': ('sysselsette',),
'sysselsatte': ('sysselsette',),
'sysselsett': ('sysselsette',),
'sysselsette': ('sysselsette',),
'sysselsetter': ('sysselsette',),
'sysselsettes': ('sysselsette',),
'systematiser': ('systematisere',),
'systematisere': ('systematisere',),
'systematiserer': ('systematisere',),
'systematiseres': ('systematisere',),
'systematisert': ('systematisere',),
'systematiserte': ('systematisere',),
'syt': ('syte',),
'syta': ('syte',),
'syte': ('syte',),
'syter': ('syte',),
'sytes': ('syte',),
'sytet': ('syte',),
'sytt': ('syte',),
'sytte': ('syte',),
'søyt': ('syte',),
'så': ('så',),
'sådd': ('så',),
'sådde': ('så',),
'sår': ('så',),
'sås': ('så',),
'såld': ('sålde',),
'sålda': ('sålde',),
'sålde': ('sålde',),
'sålder': ('sålde',),
'såldes': ('sålde',),
'såldet': ('sålde',),
'sål': ('såle',),
'såla': ('såle',),
'såle': ('såle',),
'såler': ('såle',),
'såles': ('såle',),
'sålet': ('såle',),
'sålt': ('såle',),
'sålte': ('såle',),
'såp': ('såpe',),
'såpa': ('såpe',),
'såpe': ('såpe',),
'såper': ('såpe',),
'såpes': ('såpe',),
'såpet': ('såpe',),
'såpt': ('såpe',),
'såpte': ('såpe',),
'sår': ('såre',),
'såra': ('såre',),
'såre': ('såre',),
'sårer': ('såre',),
'såres': ('såre',),
'såret': ('såre',),
'såt': ('såte',),
'såta': ('såte',),
'såte': ('såte',),
'såter': ('såte',),
'såtes': ('såte',),
'såtet': ('såte',),
'sæld': ('sælde',),
'sælda': ('sælde',),
'sælde': ('sælde',),
'sælder': ('sælde',),
'sældes': ('sælde',),
'sældet': ('sælde',),
'særmerk': ('særmerke',),
'særmerka': ('særmerke',),
'særmerke': ('særmerke',),
'særmerker': ('særmerke',),
'særmerkes': ('særmerke',),
'særmerket': ('særmerke',),
'særpreg': ('særprege',),
'særprega': ('særprege',),
'særprege': ('særprege',),
'særpreger': ('særprege',),
'særpreges': ('særprege',),
'særpreget': ('særprege',),
'søk': ('søke',),
'søke': ('søke',),
'søker': ('søke',),
'søkes': ('søke',),
'søkt': ('søke',),
'søkte': ('søke',),
'søl': ('søle',),
'søle': ('søle',),
'søler': ('søle',),
'søles': ('søle',),
'sølt': ('søle',),
'sølte': ('søle',),
'søm': ('sømme',),
'sømma': ('sømme',),
'sømme': ('sømme',),
'sømmer': ('sømme',),
'sømmes': ('sømme',),
'sømmet': ('sømme',),
'søm': ('sømme',),
'sømma': ('sømme',),
'sømme': ('sømme',),
'sømmer': ('sømme',),
'sømmes': ('sømme',),
'sømmet': ('sømme',),
'sømt': ('sømme',),
'sømte': ('sømme',),
'søpl': ('søple',),
'søpla': ('søple',),
'søple': ('søple',),
'søpler': ('søple',),
'søples': ('søple',),
'søplet': ('søple',),
'sørg': ('sørge',),
'sørga': ('sørge',),
'sørgd': ('sørge',),
'sørgde': ('sørge',),
'sørge': ('sørge',),
'sørger': ('sørge',),
'sørges': ('sørge',),
'sørget': ('sørge',),
'søt': ('søte',),
'søta': ('søte',),
'søte': ('søte',),
'søter': ('søte',),
'søtes': ('søte',),
'søtet': ('søte',),
'ta': ('ta',),
'taes': ('ta',),
'tar': ('ta',),
'tas': ('ta',),
'tatt': ('ta',),
'tok': ('ta',),
'tabb': ('tabbe',),
'tabba': ('tabbe',),
'tabbe': ('tabbe',),
'tabber': ('tabbe',),
'tabbes': ('tabbe',),
'tabbet': ('tabbe',),
'tabellariser': ('tabellarisere',),
'tabellarisere': ('tabellarisere',),
'tabellariserer': ('tabellarisere',),
'tabellariseres': ('tabellarisere',),
'tabellarisert': ('tabellarisere',),
'tabellariserte': ('tabellarisere',),
'tabuler': ('tabulere',),
'tabulere': ('tabulere',),
'tabulerer': ('tabulere',),
'tabuleres': ('tabulere',),
'tabulert': ('tabulere',),
'tabulerte': ('tabulere',),
'tafs': ('tafse',),
'tafsa': ('tafse',),
'tafse': ('tafse',),
'tafser': ('tafse',),
'tafses': ('tafse',),
'tafset': ('tafse',),
'tagg': ('tagge',),
'tagga': ('tagge',),
'tagge': ('tagge',),
'tagger': ('tagge',),
'tagges': ('tagge',),
'tagget': ('tagge',),
'tagn': ('tagne',),
'tagna': ('tagne',),
'tagne': ('tagne',),
'tagner': ('tagne',),
'tagnes': ('tagne',),
'tagnet': ('tagne',),
'takk': ('takke',),
'takka': ('takke',),
'takke': ('takke',),
'takker': ('takke',),
'takkes': ('takke',),
'takket': ('takke',),
'takl': ('takle',),
'takla': ('takle',),
'takle': ('takle',),
'takler': ('takle',),
'takles': ('takle',),
'taklet': ('takle',),
'taks': ('takse',),
'taksa': ('takse',),
'takse': ('takse',),
'takser': ('takse',),
'takses': ('takse',),
'takset': ('takse',),
'takser': ('taksere',),
'taksere': ('taksere',),
'takserer': ('taksere',),
'takseres': ('taksere',),
'taksert': ('taksere',),
'takserte': ('taksere',),
'takter': ('taktere',),
'taktere': ('taktere',),
'takterer': ('taktere',),
'takteres': ('taktere',),
'taktert': ('taktere',),
'takterte': ('taktere',),
'tal': ('tale',),
'tala': ('tale',),
'tale': ('tale',),
'taler': ('tale',),
'tales': ('tale',),
'talt': ('tale',),
'talte': ('tale',),
'talfest': ('talfeste',),
'talfesta': ('talfeste',),
'talfeste': ('talfeste',),
'talfester': ('talfeste',),
'talfestes': ('talfeste',),
'talfestet': ('talfeste',),
'tall': ('talle',),
'talla': ('talle',),
'talle': ('talle',),
'taller': ('talle',),
'talles': ('talle',),
'tallet': ('talle',),
'tallfest': ('tallfeste',),
'tallfesta': ('tallfeste',),
'tallfeste': ('tallfeste',),
'tallfester': ('tallfeste',),
'tallfestes': ('tallfeste',),
'tallfestet': ('tallfeste',),
'tamp': ('tampe',),
'tampa': ('tampe',),
'tampe': ('tampe',),
'tamper': ('tampe',),
'tampes': ('tampe',),
'tampet': ('tampe',),
'tams': ('tamse',),
'tamsa': ('tamse',),
'tamse': ('tamse',),
'tamser': ('tamse',),
'tamses': ('tamse',),
'tamset': ('tamse',),
'tan': ('tane',),
'tana': ('tane',),
'tane': ('tane',),
'taner': ('tane',),
'tanes': ('tane',),
'tanet': ('tane',),
'tant': ('tane',),
'tante': ('tane',),
'tanger': ('tangere',),
'tangere': ('tangere',),
'tangerer': ('tangere',),
'tangeres': ('tangere',),
'tangert': ('tangere',),
'tangerte': ('tangere',),
'tank': ('tanke',),
'tanka': ('tanke',),
'tanke': ('tanke',),
'tanker': ('tanke',),
'tankes': ('tanke',),
'tanket': ('tanke',),
'tap': ('tape',),
'tapa': ('tape',),
'tape': ('tape',),
'taper': ('tape',),
'tapes': ('tape',),
'tapet': ('tape',),
'tap': ('tape',),
'tape': ('tape',),
'taper': ('tape',),
'tapes': ('tape',),
'tapt': ('tape',),
'tapte': ('tape',),
'tapetser': ('tapetsere',),
'tapetsere': ('tapetsere',),
'tapetserer': ('tapetsere',),
'tapetseres': ('tapetsere',),
'tapetsert': ('tapetsere',),
'tapetserte': ('tapetsere',),
'tapp': ('tappe',),
'tappa': ('tappe',),
'tappe': ('tappe',),
'tapper': ('tappe',),
'tappes': ('tappe',),
'tappet': ('tappe',),
'tariff-fest': ('tariff-feste',),
'tariff-festa': ('tariff-feste',),
'tariff-feste': ('tariff-feste',),
'tariff-fester': ('tariff-feste',),
'tariff-festes': ('tariff-feste',),
'tariff-festet': ('tariff-feste',),
'tariffest': ('tariffeste',),
'tariffesta': ('tariffeste',),
'tariffeste': ('tariffeste',),
'tariffester': ('tariffeste',),
'tariffestes': ('tariffeste',),
'tariffestet': ('tariffeste',),
'tasl': ('tasle',),
'tasla': ('tasle',),
'tasle': ('tasle',),
'tasler': ('tasle',),
'tasles': ('tasle',),
'taslet': ('tasle',),
'tass': ('tasse',),
'tassa': ('tasse',),
'tasse': ('tasse',),
'tasser': ('tasse',),
'tasses': ('tasse',),
'tasset': ('tasse',),
'tast': ('taste',),
'tasta': ('taste',),
'taste': ('taste',),
'taster': ('taste',),
'tastes': ('taste',),
'tastet': ('taste',),
'tatover': ('tatovere',),
'tatovere': ('tatovere',),
'tatoverer': ('tatovere',),
'tatoveres': ('tatovere',),
'tatovert': ('tatovere',),
'tatoverte': ('tatovere',),
'tau': ('taue',),
'taua': ('taue',),
'taue': ('taue',),
'tauer': ('taue',),
'taues': ('taue',),
'tauet': ('taue',),
'tav': ('tave',),
'tava': ('tave',),
'tave': ('tave',),
'taver': ('tave',),
'taves': ('tave',),
'tavet': ('tave',),
'te': ('te',),
'tedd': ('te',),
'tedde': ('te',),
'ter': ('te',),
'tes': ('te',),
'teft': ('tefte',),
'tefta': ('tefte',),
'tefte': ('tefte',),
'tefter': ('tefte',),
'teftes': ('tefte',),
'teftet': ('tefte',),
'tegn': ('tegne',),
'tegna': ('tegne',),
'tegne': ('tegne',),
'tegner': ('tegne',),
'tegnes': ('tegne',),
'tegnet': ('tegne',),
'teip': ('teipe',),
'teipa': ('teipe',),
'teipe': ('teipe',),
'teiper': ('teipe',),
'teipes': ('teipe',),
'teipet': ('teipe',),
'teit': ('teite',),
'teita': ('teite',),
'teite': ('teite',),
'teiter': ('teite',),
'teites': ('teite',),
'teitet': ('teite',),
'tekk': ('tekke',),
'tekka': ('tekke',),
'tekke': ('tekke',),
'tekker': ('tekke',),
'tekkes': ('tekke',),
'tekket': ('tekke',),
'tekt': ('tekke',),
'tekte': ('tekke',),
'tekkes': ('tekkes',),
'tektes': ('tekkes',),
'teknifiser': ('teknifisere',),
'teknifisere': ('teknifisere',),
'teknifiserer': ('teknifisere',),
'teknifiseres': ('teknifisere',),
'teknifisert': ('teknifisere',),
'teknifiserte': ('teknifisere',),
'tekst': ('tekste',),
'teksta': ('tekste',),
'tekste': ('tekste',),
'tekster': ('tekste',),
'tekstes': ('tekste',),
'tekstet': ('tekste',),
'teksturer': ('teksturere',),
'teksturere': ('teksturere',),
'teksturerer': ('teksturere',),
'tekstureres': ('teksturere',),
'teksturert': ('teksturere',),
'teksturerte': ('teksturere',),
'tel': ('tele',),
'tela': ('tele',),
'tele': ('tele',),
'teler': ('tele',),
'teles': ('tele',),
'telet': ('tele',),
'telefoner': ('telefonere',),
'telefonere': ('telefonere',),
'telefonerer': ('telefonere',),
'telefoneres': ('telefonere',),
'telefonert': ('telefonere',),
'telefonerte': ('telefonere',),
'telegrafer': ('telegrafere',),
'telegrafere': ('telegrafere',),
'telegraferer': ('telegrafere',),
'telegraferes': ('telegrafere',),
'telegrafert': ('telegrafere',),
'telegraferte': ('telegrafere',),
'telekser': ('teleksere',),
'teleksere': ('teleksere',),
'telekserer': ('teleksere',),
'telekseres': ('teleksere',),
'teleksert': ('teleksere',),
'telekserte': ('teleksere',),
'telemetrer': ('telemetrere',),
'telemetrere': ('telemetrere',),
'telemetrerer': ('telemetrere',),
'telemetreres': ('telemetrere',),
'telemetrert': ('telemetrere',),
'telemetrerte': ('telemetrere',),
'telg': ('telgje',),
'telgd': ('telgje',),
'telgde': ('telgje',),
'telgj': ('telgje',),
'telgja': ('telgje',),
'telgje': ('telgje',),
'telgjer': ('telgje',),
'telgjes': ('telgje',),
'telgjet': ('telgje',),
'talt': ('telle',),
'talte': ('telle',),
'tell': ('telle',),
'tella': ('telle',),
'telle': ('telle',),
'teller': ('telle',),
'telles': ('telle',),
'tellet': ('telle',),
'telt': ('telle',),
'telte': ('telle',),
'teln': ('telne',),
'telna': ('telne',),
'telne': ('telne',),
'telner': ('telne',),
'telnes': ('telne',),
'telnet': ('telne',),
'telt': ('telte',),
'telta': ('telte',),
'telte': ('telte',),
'telter': ('telte',),
'teltes': ('telte',),
'teltet': ('telte',),
'tematiser': ('tematisere',),
'tematisere': ('tematisere',),
'tematiserer': ('tematisere',),
'tematiseres': ('tematisere',),
'tematisert': ('tematisere',),
'tematiserte': ('tematisere',),
'tem': ('temme',),
'temma': ('temme',),
'temme': ('temme',),
'temmer': ('temme',),
'temmes': ('temme',),
'temmet': ('temme',),
'temt': ('temme',),
'temte': ('temme',),
'temperer': ('temperere',),
'temperere': ('temperere',),
'tempererer': ('temperere',),
'tempereres': ('temperere',),
'temperert': ('temperere',),
'tempererte': ('temperere',),
'tender': ('tendere',),
'tendere': ('tendere',),
'tenderer': ('tendere',),
'tenderes': ('tendere',),
'tendert': ('tendere',),
'tenderte': ('tendere',),
'tenk': ('tenke',),
'tenke': ('tenke',),
'tenker': ('tenke',),
'tenkes': ('tenke',),
'tenkt': ('tenke',),
'tenkte': ('tenke',),
'tenn': ('tenne',),
'tenne': ('tenne',),
'tenner': ('tenne',),
'tennes': ('tenne',),
'tent': ('tenne',),
'tente': ('tenne',),
'teoretiser': ('teoretisere',),
'teoretisere': ('teoretisere',),
'teoretiserer': ('teoretisere',),
'teoretiseres': ('teoretisere',),
'teoretisert': ('teoretisere',),
'teoretiserte': ('teoretisere',),
'tepp': ('teppe',),
'teppe': ('teppe',),
'tepper': ('teppe',),
'teppes': ('teppe',),
'tept': ('teppe',),
'tepte': ('teppe',),
'teppela': ('teppelegge',),
'teppelagt': ('teppelegge',),
'teppelegg': ('teppelegge',),
'teppelegge': ('teppelegge',),
'teppelegger': ('teppelegge',),
'teppelegges': ('teppelegge',),
'terg': ('terge',),
'terga': ('terge',),
'terge': ('terge',),
'terger': ('terge',),
'terges': ('terge',),
'terget': ('terge',),
'terminfest': ('terminfeste',),
'terminfesta': ('terminfeste',),
'terminfeste': ('terminfeste',),
'terminfester': ('terminfeste',),
'terminfestes': ('terminfeste',),
'terminfestet': ('terminfeste',),
'terp': ('terpe',),
'terpa': ('terpe',),
'terpe': ('terpe',),
'terper': ('terpe',),
'terpes': ('terpe',),
'terpet': ('terpe',),
'terrasser': ('terrassere',),
'terrassere': ('terrassere',),
'terrasserer': ('terrassere',),
'terrasseres': ('terrassere',),
'terrassert': ('terrassere',),
'terrasserte': ('terrassere',),
'terroriser': ('terrorisere',),
'terrorisere': ('terrorisere',),
'terroriserer': ('terrorisere',),
'terroriseres': ('terrorisere',),
'terrorisert': ('terrorisere',),
'terroriserte': ('terrorisere',),
'tersk': ('terske',),
'terska': ('terske',),
'terske': ('terske',),
'tersker': ('terske',),
'terskes': ('terske',),
'tersket': ('terske',),
'testamenter': ('testamentere',),
'testamentere': ('testamentere',),
'testamenterer': ('testamentere',),
'testamenteres': ('testamentere',),
'testamentert': ('testamentere',),
'testamenterte': ('testamentere',),
'test': ('teste',),
'testa': ('teste',),
'teste': ('teste',),
'tester': ('teste',),
'testes': ('teste',),
'testet': ('teste',),
'tetn': ('tetne',),
'tetna': ('tetne',),
'tetne': ('tetne',),
'tetner': ('tetne',),
'tetnes': ('tetne',),
'tetnet': ('tetne',),
'tett': ('tette',),
'tetta': ('tette',),
'tette': ('tette',),
'tetter': ('tette',),
'tettes': ('tette',),
'tettet': ('tette',),
'tev': ('teve',),
'teva': ('teve',),
'teve': ('teve',),
'tever': ('teve',),
'teves': ('teve',),
'tevet': ('teve',),
'tevl': ('tevle',),
'tevla': ('tevle',),
'tevle': ('tevle',),
'tevler': ('tevle',),
'tevles': ('tevle',),
'tevlet': ('tevle',),
'tidfest': ('tidfeste',),
'tidfesta': ('tidfeste',),
'tidfeste': ('tidfeste',),
'tidfester': ('tidfeste',),
'tidfestes': ('tidfeste',),
'tidfestet': ('tidfeste',),
'tidobl': ('tidoble',),
'tidobla': ('tidoble',),
'tidoble': ('tidoble',),
'tidobler': ('tidoble',),
'tidobles': ('tidoble',),
'tidoblet': ('tidoble',),
'tidsbestem': ('tidsbestemme',),
'tidsbestemme': ('tidsbestemme',),
'tidsbestemmer': ('tidsbestemme',),
'tidsbestemmes': ('tidsbestemme',),
'tidsbestemt': ('tidsbestemme',),
'tidsbestemte': ('tidsbestemme',),
'tidsinnstill': ('tidsinnstille',),
'tidsinnstille': ('tidsinnstille',),
'tidsinnstiller': ('tidsinnstille',),
'tidsinnstilles': ('tidsinnstille',),
'tidsinnstilt': ('tidsinnstille',),
'tidsinnstilte': ('tidsinnstille',),
'tagd': ('tie',),
'tagde': ('tie',),
'ti': ('tie',),
'tia': ('tie',),
'tidd': ('tie',),
'tidde': ('tie',),
'tie': ('tie',),
'tier': ('tie',),
'ties': ('tie',),
'tiet': ('tie',),
'tagg': ('tigge',),
'tigd': ('tigge',),
'tigde': ('tigge',),
'tigg': ('tigge',),
'tigga': ('tigge',),
'tigge': ('tigge',),
'tigger': ('tigge',),
'tigges': ('tigge',),
'tigget': ('tigge',),
'tikk': ('tikke',),
'tikka': ('tikke',),
'tikke': ('tikke',),
'tikker': ('tikke',),
'tikkes': ('tikke',),
'tikket': ('tikke',),
'tikk': ('tikke',),
'tikka': ('tikke',),
'tikke': ('tikke',),
'tikker': ('tikke',),
'tikkes': ('tikke',),
'tikket': ('tikke',),
'tilbakebetal': ('tilbakebetale',),
'tilbakebetale': ('tilbakebetale',),
'tilbakebetaler': ('tilbakebetale',),
'tilbakebetales': ('tilbakebetale',),
'tilbakebetalt': ('tilbakebetale',),
'tilbakebetalte': ('tilbakebetale',),
'tilbakefør': ('tilbakeføre',),
'tilbakeføre': ('tilbakeføre',),
'tilbakefører': ('tilbakeføre',),
'tilbakeføres': ('tilbakeføre',),
'tilbakeført': ('tilbakeføre',),
'tilbakeførte': ('tilbakeføre',),
'tilbakekall': ('tilbakekalle',),
'tilbakekalle': ('tilbakekalle',),
'tilbakekaller': ('tilbakekalle',),
'tilbakekalles': ('tilbakekalle',),
'tilbakekalt': ('tilbakekalle',),
'tilbakekalte': ('tilbakekalle',),
'tilbakela': ('tilbakelegge',),
'tilbakelagt': ('tilbakelegge',),
'tilbakelegg': ('tilbakelegge',),
'tilbakelegge': ('tilbakelegge',),
'tilbakelegger': ('tilbakelegge',),
'tilbakelegges': ('tilbakelegge',),
'tilbakevis': ('tilbakevise',),
'tilbakevise': ('tilbakevise',),
'tilbakeviser': ('tilbakevise',),
'tilbakevises': ('tilbakevise',),
'tilbakevist': ('tilbakevise',),
'tilbakeviste': ('tilbakevise',),
'tilba': ('tilbe',),
'tilbad': ('tilbe',),
'tilbe': ('tilbe',),
'tilbedt': ('tilbe',),
'tilber': ('tilbe',),
'tilbes': ('tilbe',),
'tilbered': ('tilberede',),
'tilberede': ('tilberede',),
'tilbereder': ('tilberede',),
'tilberedes': ('tilberede',),
'tilberedt': ('tilberede',),
'tilberedte': ('tilberede',),
'tilbragt': ('tilbringe',),
'tilbragte': ('tilbringe',),
'tilbrakt': ('tilbringe',),
'tilbrakte': ('tilbringe',),
'tilbring': ('tilbringe',),
'tilbringe': ('tilbringe',),
'tilbringer': ('tilbringe',),
'tilbringes': ('tilbringe',),
'tildekk': ('tildekke',),
'tildekka': ('tildekke',),
'tildekke': ('tildekke',),
'tildekker': ('tildekke',),
'tildekkes': ('tildekke',),
'tildekket': ('tildekke',),
'tildekt': ('tildekke',),
'tildekte': ('tildekke',),
'tildel': ('tildele',),
'tildele': ('tildele',),
'tildeler': ('tildele',),
'tildeles': ('tildele',),
'tildelt': ('tildele',),
'tildelte': ('tildele',),
'tildøm': ('tildømme',),
'tildømme': ('tildømme',),
'tildømmer': ('tildømme',),
'tildømmes': ('tildømme',),
'tildømt': ('tildømme',),
'tildømte': ('tildømme',),
'tilegn': ('tilegne',),
'tilegna': ('tilegne',),
'tilegne': ('tilegne',),
'tilegner': ('tilegne',),
'tilegnes': ('tilegne',),
'tilegnet': ('tilegne',),
'tilendebragt': ('tilendebringe',),
'tilendebragte': ('tilendebringe',),
'tilendebrakt': ('tilendebringe',),
'tilendebrakte': ('tilendebringe',),
'tilendebring': ('tilendebringe',),
'tilendebringe': ('tilendebringe',),
'tilendebringer': ('tilendebringe',),
'tilendebringes': ('tilendebringe',),
'tilfall': ('tilfalle',),
'tilfalle': ('tilfalle',),
'tilfaller': ('tilfalle',),
'tilfalles': ('tilfalle',),
'tilfalt': ('tilfalle',),
'tilflaut': ('tilflyte',),
'tilflyt': ('tilflyte',),
'tilflyte': ('tilflyte',),
'tilflyter': ('tilflyte',),
'tilflytes': ('tilflyte',),
'tilflytt': ('tilflyte',),
'tilfløt': ('tilflyte',),
'tilfløyt': ('tilflyte',),
'tilfredsstill': ('tilfredsstille',),
'tilfredsstille': ('tilfredsstille',),
'tilfredsstiller': ('tilfredsstille',),
'tilfredsstilles': ('tilfredsstille',),
'tilfredsstilt': ('tilfredsstille',),
'tilfredsstilte': ('tilfredsstille',),
'tilfraus': ('tilfryse',),
'tilfrosset': ('tilfryse',),
'tilfrys': ('tilfryse',),
'tilfryse': ('tilfryse',),
'tilfryser': ('tilfryse',),
'tilfryses': ('tilfryse',),
'tilfrøs': ('tilfryse',),
'tilfrøys': ('tilfryse',),
'tilfauk': ('tilfyke',),
'tilfyk': ('tilfyke',),
'tilfyke': ('tilfyke',),
'tilfyker': ('tilfyke',),
'tilfykes': ('tilfyke',),
'tilføk': ('tilfyke',),
'tilføket': ('tilfyke',),
'tilføyk': ('tilfyke',),
'tilfør': ('tilføre',),
'tilføre': ('tilføre',),
'tilfører': ('tilføre',),
'tilføres': ('tilføre',),
'tilført': ('tilføre',),
'tilførte': ('tilføre',),
'tilføy': ('tilføye',),
'tilføya': ('tilføye',),
'tilføyd': ('tilføye',),
'tilføyde': ('tilføye',),
'tilføye': ('tilføye',),
'tilføyer': ('tilføye',),
'tilføyes': ('tilføye',),
'tilføyet': ('tilføye',),
'tilga': ('tilgi',),
'tilgav': ('tilgi',),
'tilgi': ('tilgi',),
'tilgies': ('tilgi',),
'tilgir': ('tilgi',),
'tilgis': ('tilgi',),
'tilgitt': ('tilgi',),
'tilgodese': ('tilgodese',),
'tilgodesees': ('tilgodese',),
'tilgodeser': ('tilgodese',),
'tilgodeses': ('tilgodese',),
'tilgodesett': ('tilgodese',),
'tilgodeså': ('tilgodese',),
'tilgodesåg': ('tilgodese',),
'tilgris': ('tilgrise',),
'tilgrisa': ('tilgrise',),
'tilgrise': ('tilgrise',),
'tilgriser': ('tilgrise',),
'tilgrises': ('tilgrise',),
'tilgriset': ('tilgrise',),
'tilgrist': ('tilgrise',),
'tilgriste': ('tilgrise',),
'tilgro': ('tilgro',),
'tilgrodd': ('tilgro',),
'tilgrodde': ('tilgro',),
'tilgror': ('tilgro',),
'tilgros': ('tilgro',),
'tilhogd': ('tilhogge',),
'tilhogde': ('tilhogge',),
'tilhogg': ('tilhogge',),
'tilhogge': ('tilhogge',),
'tilhogger': ('tilhogge',),
'tilhogges': ('tilhogge',),
'tilhogget': ('tilhogge',),
'tilhold': ('tilholde',),
'tilholde': ('tilholde',),
'tilholder': ('tilholde',),
'tilholdes': ('tilholde',),
'tilholdt': ('tilholde',),
'tilhugd': ('tilhugge',),
'tilhugde': ('tilhugge',),
'tilhugg': ('tilhugge',),
'tilhugga': ('tilhugge',),
'tilhugge': ('tilhugge',),
'tilhugger': ('tilhugge',),
'tilhugges': ('tilhugge',),
'tilhugget': ('tilhugge',),
'tilhyll': ('tilhylle',),
'tilhylla': ('tilhylle',),
'tilhylle': ('tilhylle',),
'tilhyller': ('tilhylle',),
'tilhylles': ('tilhylle',),
'tilhyllet': ('tilhylle',),
'tilhør': ('tilhøre',),
'tilhøre': ('tilhøre',),
'tilhører': ('tilhøre',),
'tilhøres': ('tilhøre',),
'tilhørt': ('tilhøre',),
'tilhørte': ('tilhøre',),
'tilintetgjorde': ('tilintetgjøre',),
'tilintetgjort': ('tilintetgjøre',),
'tilintetgjør': ('tilintetgjøre',),
'tilintetgjøre': ('tilintetgjøre',),
'tilintetgjøres': ('tilintetgjøre',),
'tiljamn': ('tiljamne',),
'tiljamna': ('tiljamne',),
'tiljamne': ('tiljamne',),
'tiljamner': ('tiljamne',),
'tiljamnes': ('tiljamne',),
'tiljamnet': ('tiljamne',),
'tiljevn': ('tiljevne',),
'tiljevna': ('tiljevne',),
'tiljevne': ('tiljevne',),
'tiljevner': ('tiljevne',),
'tiljevnes': ('tiljevne',),
'tiljevnet': ('tiljevne',),
'tiljubl': ('tiljuble',),
'tiljubla': ('tiljuble',),
'tiljuble': ('tiljuble',),
'tiljubler': ('tiljuble',),
'tiljubles': ('tiljuble',),
'tiljublet': ('tiljuble',),
'tilkall': ('tilkalle',),
'tilkalle': ('tilkalle',),
'tilkaller': ('tilkalle',),
'tilkalles': ('tilkalle',),
'tilkalt': ('tilkalle',),
'tilkalte': ('tilkalle',),
'tilkjemp': ('tilkjempe',),
'tilkjempa': ('tilkjempe',),
'tilkjempe': ('tilkjempe',),
'tilkjemper': ('tilkjempe',),
'tilkjempes': ('tilkjempe',),
'tilkjempet': ('tilkjempe',),
'tilkjenn': ('tilkjenne',),
'tilkjenne': ('tilkjenne',),
'tilkjenner': ('tilkjenne',),
'tilkjennes': ('tilkjenne',),
'tilkjent': ('tilkjenne',),
'tilkjente': ('tilkjenne',),
'tilkjennega': ('tilkjennegi',),
'tilkjennegav': ('tilkjennegi',),
'tilkjennegi': ('tilkjennegi',),
'tilkjennegies': ('tilkjennegi',),
'tilkjennegir': ('tilkjennegi',),
'tilkjennegis': ('tilkjennegi',),
'tilkjennegitt': ('tilkjennegi',),
'tilkjør': ('tilkjøre',),
'tilkjøre': ('tilkjøre',),
'tilkjører': ('tilkjøre',),
'tilkjøres': ('tilkjøre',),
'tilkjørt': ('tilkjøre',),
'tilkjørte': ('tilkjøre',),
'tilklin': ('tilkline',),
'tilkline': ('tilkline',),
'tilkliner': ('tilkline',),
'tilklines': ('tilkline',),
'tilklint': ('tilkline',),
'tilklinte': ('tilkline',),
'tilknytt': ('tilknytte',),
'tilknytta': ('tilknytte',),
'tilknytte': ('tilknytte',),
'tilknytter': ('tilknytte',),
'tilknyttes': ('tilknytte',),
'tilknyttet': ('tilknytte',),
'tilkobl': ('tilkoble',),
'tilkobla': ('tilkoble',),
'tilkoble': ('tilkoble',),
'tilkobler': ('tilkoble',),
'tilkobles': ('tilkoble',),
'tilkoblet': ('tilkoble',),
'tilkom': ('tilkomme',),
'tilkomme': ('tilkomme',),
'tilkommer': ('tilkomme',),
'tilkommes': ('tilkomme',),
'tilkommet': ('tilkomme',),
'tilkopl': ('tilkople',),
'tilkopla': ('tilkople',),
'tilkople': ('tilkople',),
'tilkopler': ('tilkople',),
'tilkoples': ('tilkople',),
'tilkoplet': ('tilkople',),
'tillag': ('tillage',),
'tillaga': ('tillage',),
'tillagd': ('tillage',),
'tillagde': ('tillage',),
'tillage': ('tillage',),
'tillager': ('tillage',),
'tillages': ('tillage',),
'tillaget': ('tillage',),
'tillat': ('tillate',),
'tillate': ('tillate',),
'tillater': ('tillate',),
'tillates': ('tillate',),
'tillatt': ('tillate',),
'tillot': ('tillate',),
'tilla': ('tillegge',),
'tillagt': ('tillegge',),
'tillegg': ('tillegge',),
'tillegge': ('tillegge',),
'tillegger': ('tillegge',),
'tillegges': ('tillegge',),
'tillemp': ('tillempe',),
'tillempa': ('tillempe',),
'tillempe': ('tillempe',),
'tillemper': ('tillempe',),
'tillempes': ('tillempe',),
'tillempet': ('tillempe',),
'tilligg': ('tilligge',),
'tilligge': ('tilligge',),
'tilligger': ('tilligge',),
'tilligges': ('tilligge',),
'tilligget': ('tilligge',),
'tillå': ('tilligge',),
'tillåg': ('tilligge',),
'tillys': ('tillyse',),
'tillyse': ('tillyse',),
'tillyser': ('tillyse',),
'tillyses': ('tillyse',),
'tillyst': ('tillyse',),
'tillyste': ('tillyse',),
'tilmål': ('tilmåle',),
'tilmåle': ('tilmåle',),
'tilmåler': ('tilmåle',),
'tilmåles': ('tilmåle',),
'tilmålt': ('tilmåle',),
'tilmålte': ('tilmåle',),
'tilnærm': ('tilnærme',),
'tilnærma': ('tilnærme',),
'tilnærme': ('tilnærme',),
'tilnærmer': ('tilnærme',),
'tilnærmes': ('tilnærme',),
'tilnærmet': ('tilnærme',),
'tilpass': ('tilpasse',),
'tilpassa': ('tilpasse',),
'tilpasse': ('tilpasse',),
'tilpasser': ('tilpasse',),
'tilpasses': ('tilpasse',),
'tilpasset': ('tilpasse',),
'tilplant': ('tilplante',),
'tilplanta': ('tilplante',),
'tilplante': ('tilplante',),
'tilplanter': ('tilplante',),
'tilplantes': ('tilplante',),
'tilplantet': ('tilplante',),
'tilran': ('tilrane',),
'tilrana': ('tilrane',),
'tilrane': ('tilrane',),
'tilraner': ('tilrane',),
'tilranes': ('tilrane',),
'tilranet': ('tilrane',),
'tilrant': ('tilrane',),
'tilrante': ('tilrane',),
'tilred': ('tilrede',),
'tilreda': ('tilrede',),
'tilrede': ('tilrede',),
'tilreder': ('tilrede',),
'tilredes': ('tilrede',),
'tilredet': ('tilrede',),
'tilrettela': ('tilrettelegge',),
'tilrettelagt': ('tilrettelegge',),
'tilrettelegg': ('tilrettelegge',),
'tilrettelegge': ('tilrettelegge',),
'tilrettelegger': ('tilrettelegge',),
'tilrettelegges': ('tilrettelegge',),
'tilrettevis': ('tilrettevise',),
'tilrettevise': ('tilrettevise',),
'tilretteviser': ('tilrettevise',),
'tilrettevises': ('tilrettevise',),
'tilrettevist': ('tilrettevise',),
'tilretteviste': ('tilrettevise',),
'tilreiv': ('tilrive',),
'tilrev': ('tilrive',),
'tilrevet': ('tilrive',),
'tilriv': ('tilrive',),
'tilrive': ('tilrive',),
'tilriver': ('tilrive',),
'tilrives': ('tilrive',),
'tilrå': ('tilrå',),
'tilrådd': ('tilrå',),
'tilrådde': ('tilrå',),
'tilrår': ('tilrå',),
'tilrås': ('tilrå',),
'tilråd': ('tilråde',),
'tilråda': ('tilråde',),
'tilrådd': ('tilråde',),
'tilrådde': ('tilråde',),
'tilråde': ('tilråde',),
'tilråder': ('tilråde',),
'tilrådes': ('tilråde',),
'tilrådet': ('tilråde',),
'tilsend': ('tilsende',),
'tilsende': ('tilsende',),
'tilsender': ('tilsende',),
'tilsendes': ('tilsende',),
'tilsendt': ('tilsende',),
'tilsendte': ('tilsende',),
'tilsatt': ('tilsette',),
'tilsatte': ('tilsette',),
'tilsett': ('tilsette',),
'tilsette': ('tilsette',),
'tilsetter': ('tilsette',),
'tilsettes': ('tilsette',),
'tilsa': ('tilsi',),
'tilsagt': ('tilsi',),
'tilsi': ('tilsi',),
'tilsier': ('tilsi',),
'tilsies': ('tilsi',),
'tilsis': ('tilsi',),
'tilsidesatt': ('tilsidesette',),
'tilsidesatte': ('tilsidesette',),
'tilsidesett': ('tilsidesette',),
'tilsidesette': ('tilsidesette',),
'tilsidesetter': ('tilsidesette',),
'tilsidesettes': ('tilsidesette',),
'tilsikt': ('tilsikte',),
'tilsikta': ('tilsikte',),
'tilsikte': ('tilsikte',),
'tilsikter': ('tilsikte',),
'tilsiktes': ('tilsikte',),
'tilsiktet': ('tilsikte',),
'tilskjøt': ('tilskjøte',),
'tilskjøta': ('tilskjøte',),
'tilskjøte': ('tilskjøte',),
'tilskjøter': ('tilskjøte',),
'tilskjøtes': ('tilskjøte',),
'tilskjøtet': ('tilskjøte',),
'tilskjøtt': ('tilskjøte',),
'tilskjøtte': ('tilskjøte',),
'tilskreiv': ('tilskrive',),
'tilskrev': ('tilskrive',),
'tilskrevet': ('tilskrive',),
'tilskriv': ('tilskrive',),
'tilskrive': ('tilskrive',),
'tilskriver': ('tilskrive',),
'tilskrives': ('tilskrive',),
'tilsky': ('tilskye',),
'tilskya': ('tilskye',),
'tilskye': ('tilskye',),
'tilskyer': ('tilskye',),
'tilskyes': ('tilskye',),
'tilskyet': ('tilskye',),
'tilskynd': ('tilskynde',),
'tilskynda': ('tilskynde',),
'tilskynde': ('tilskynde',),
'tilskynder': ('tilskynde',),
'tilskyndes': ('tilskynde',),
'tilskyndet': ('tilskynde',),
'tilskyndt': ('tilskynde',),
'tilskyndte': ('tilskynde',),
'tilslutt': ('tilslutte',),
'tilslutta': ('tilslutte',),
'tilslutte': ('tilslutte',),
'tilslutter': ('tilslutte',),
'tilsluttes': ('tilslutte',),
'tilsluttet': ('tilslutte',),
'tilslør': ('tilsløre',),
'tilsløra': ('tilsløre',),
'tilsløre': ('tilsløre',),
'tilslører': ('tilsløre',),
'tilsløres': ('tilsløre',),
'tilsløret': ('tilsløre',),
'tilslørt': ('tilsløre',),
'tilslørte': ('tilsløre',),
'tilsmuss': ('tilsmusse',),
'tilsmussa': ('tilsmusse',),
'tilsmusse': ('tilsmusse',),
'tilsmusser': ('tilsmusse',),
'tilsmusses': ('tilsmusse',),
'tilsmusset': ('tilsmusse',),
'tilsmurt': ('tilsmøre',),
'tilsmurte': ('tilsmøre',),
'tilsmør': ('tilsmøre',),
'tilsmøre': ('tilsmøre',),
'tilsmører': ('tilsmøre',),
'tilsmøres': ('tilsmøre',),
'tilsnakk': ('tilsnakke',),
'tilsnakka': ('tilsnakke',),
'tilsnakke': ('tilsnakke',),
'tilsnakker': ('tilsnakke',),
'tilsnakkes': ('tilsnakke',),
'tilsnakket': ('tilsnakke',),
'tilsneik': ('tilsnike',),
'tilsnek': ('tilsnike',),
'tilsneket': ('tilsnike',),
'tilsnik': ('tilsnike',),
'tilsnike': ('tilsnike',),
'tilsniker': ('tilsnike',),
'tilsnikes': ('tilsnike',),
'tilspiss': ('tilspisse',),
'tilspissa': ('tilspisse',),
'tilspisse': ('tilspisse',),
'tilspisser': ('tilspisse',),
'tilspisses': ('tilspisse',),
'tilspisset': ('tilspisse',),
'tilsted': ('tilstede',),
'tilstede': ('tilstede',),
'tilsteder': ('tilstede',),
'tilstedes': ('tilstede',),
'tilstedt': ('tilstede',),
'tilstedte': ('tilstede',),
'tilstill': ('tilstille',),
'tilstille': ('tilstille',),
'tilstiller': ('tilstille',),
'tilstilles': ('tilstille',),
'tilstilt': ('tilstille',),
'tilstilte': ('tilstille',),
'tilstopp': ('tilstoppe',),
'tilstoppa': ('tilstoppe',),
'tilstoppe': ('tilstoppe',),
'tilstopper': ('tilstoppe',),
'tilstoppes': ('tilstoppe',),
'tilstoppet': ('tilstoppe',),
'tilstreb': ('tilstrebe',),
'tilstreba': ('tilstrebe',),
'tilstrebe': ('tilstrebe',),
'tilstreber': ('tilstrebe',),
'tilstrebes': ('tilstrebe',),
'tilstrebet': ('tilstrebe',),
'tilsto': ('tilstå',),
'tilstod': ('tilstå',),
'tilstå': ('tilstå',),
'tilståes': ('tilstå',),
'tilstår': ('tilstå',),
'tilstås': ('tilstå',),
'tilstått': ('tilstå',),
'tilstøt': ('tilstøte',),
'tilstøte': ('tilstøte',),
'tilstøter': ('tilstøte',),
'tilstøtes': ('tilstøte',),
'tilstøtt': ('tilstøte',),
'tilstøtte': ('tilstøte',),
'tilstøyt': ('tilstøyte',),
'tilstøyte': ('tilstøyte',),
'tilstøyter': ('tilstøyte',),
'tilstøytes': ('tilstøyte',),
'tilstøytt': ('tilstøyte',),
'tilstøytte': ('tilstøyte',),
'tilsvin': ('tilsvine',),
'tilsvina': ('tilsvine',),
'tilsvine': ('tilsvine',),
'tilsviner': ('tilsvine',),
'tilsvines': ('tilsvine',),
'tilsvinet': ('tilsvine',),
'tilsvint': ('tilsvine',),
'tilsvinte': ('tilsvine',),
'tilså': ('tilså',),
'tilsådd': ('tilså',),
'tilsådde': ('tilså',),
'tilsår': ('tilså',),
'tilsås': ('tilså',),
'tilsøl': ('tilsøle',),
'tilsøle': ('tilsøle',),
'tilsøler': ('tilsøle',),
'tilsøles': ('tilsøle',),
'tilsølt': ('tilsøle',),
'tilsølte': ('tilsøle',),
'tilta': ('tilta',),
'tiltaes': ('tilta',),
'tiltar': ('tilta',),
'tiltas': ('tilta',),
'tiltatt': ('tilta',),
'tiltok': ('tilta',),
'tiltal': ('tiltale',),
'tiltala': ('tiltale',),
'tiltale': ('tiltale',),
'tiltaler': ('tiltale',),
'tiltales': ('tiltale',),
'tiltalt': ('tiltale',),
'tiltalte': ('tiltale',),
'tiltenk': ('tiltenke',),
'tiltenke': ('tiltenke',),
'tiltenker': ('tiltenke',),
'tiltenkes': ('tiltenke',),
'tiltenkt': ('tiltenke',),
'tiltenkte': ('tiltenke',),
'tiltre': ('tiltre',),
'tiltrer': ('tiltre',),
'tiltres': ('tiltre',),
'tiltrådt': ('tiltre',),
'tiltrådte': ('tiltre',),
'tiltrakk': ('tiltrekke',),
'tiltrekk': ('tiltrekke',),
'tiltrekke': ('tiltrekke',),
'tiltrekker': ('tiltrekke',),
'tiltrekkes': ('tiltrekke',),
'tiltrukket': ('tiltrekke',),
'tiltro': ('tiltro',),
'tiltrodd': ('tiltro',),
'tiltrodde': ('tiltro',),
'tiltror': ('tiltro',),
'tiltros': ('tiltro',),
'tiltvang': ('tiltvinge',),
'tiltving': ('tiltvinge',),
'tiltvinge': ('tiltvinge',),
'tiltvinger': ('tiltvinge',),
'tiltvinges': ('tiltvinge',),
'tiltvunget': ('tiltvinge',),
'tilvend': ('tilvende',),
'tilvende': ('tilvende',),
'tilvender': ('tilvende',),
'tilvendes': ('tilvende',),
'tilvendt': ('tilvende',),
'tilvendte': ('tilvende',),
'tilvenn': ('tilvenne',),
'tilvenna': ('tilvenne',),
'tilvenne': ('tilvenne',),
'tilvenner': ('tilvenne',),
'tilvennes': ('tilvenne',),
'tilvennet': ('tilvenne',),
'tilvent': ('tilvenne',),
'tilvente': ('tilvenne',),
'tilvirk': ('tilvirke',),
'tilvirka': ('tilvirke',),
'tilvirke': ('tilvirke',),
'tilvirker': ('tilvirke',),
'tilvirkes': ('tilvirke',),
'tilvirket': ('tilvirke',),
'tilvis': ('tilvise',),
'tilvise': ('tilvise',),
'tilviser': ('tilvise',),
'tilvises': ('tilvise',),
'tilvist': ('tilvise',),
'tilviste': ('tilvise',),
'tim': ('time',),
'tima': ('time',),
'time': ('time',),
'timer': ('time',),
'times': ('time',),
'timet': ('time',),
'times': ('times',),
'timtes': ('times',),
'tind': ('tinde',),
'tinda': ('tinde',),
'tinde': ('tinde',),
'tinder': ('tinde',),
'tindes': ('tinde',),
'tindet': ('tinde',),
'tindr': ('tindre',),
'tindra': ('tindre',),
'tindre': ('tindre',),
'tindrer': ('tindre',),
'tindres': ('tindre',),
'tindret': ('tindre',),
'tin': ('tine',),
'tina': ('tine',),
'tine': ('tine',),
'tiner': ('tine',),
'tines': ('tine',),
'tinet': ('tine',),
'tint': ('tine',),
'tinte': ('tine',),
'tin': ('tine',),
'tina': ('tine',),
'tine': ('tine',),
'tiner': ('tine',),
'tines': ('tine',),
'tinet': ('tine',),
'tint': ('tine',),
'tinte': ('tine',),
'ting': ('tinge',),
'tinga': ('tinge',),
'tinge': ('tinge',),
'tinger': ('tinge',),
'tinges': ('tinge',),
'tinget': ('tinge',),
'tingliggjorde': ('tingliggjøre',),
'tingliggjort': ('tingliggjøre',),
'tingliggjør': ('tingliggjøre',),
'tingliggjøre': ('tingliggjøre',),
'tingliggjøres': ('tingliggjøre',),
'tinglys': ('tinglyse',),
'tinglyse': ('tinglyse',),
'tinglyser': ('tinglyse',),
'tinglyses': ('tinglyse',),
'tinglyst': ('tinglyse',),
'tinglyste': ('tinglyse',),
'tinkl': ('tinkle',),
'tinkla': ('tinkle',),
'tinkle': ('tinkle',),
'tinkler': ('tinkle',),
'tinkles': ('tinkle',),
'tinklet': ('tinkle',),
'tipl': ('tiple',),
'tipla': ('tiple',),
'tiple': ('tiple',),
'tipler': ('tiple',),
'tiples': ('tiple',),
'tiplet': ('tiple',),
'tipp': ('tippe',),
'tippa': ('tippe',),
'tippe': ('tippe',),
'tipper': ('tippe',),
'tippes': ('tippe',),
'tippet': ('tippe',),
'tipp': ('tippe',),
'tippa': ('tippe',),
'tippe': ('tippe',),
'tipper': ('tippe',),
'tippes': ('tippe',),
'tippet': ('tippe',),
'tipp': ('tippe',),
'tippa': ('tippe',),
'tippe': ('tippe',),
'tipper': ('tippe',),
'tippes': ('tippe',),
'tippet': ('tippe',),
'tips': ('tipse',),
'tipsa': ('tipse',),
'tipse': ('tipse',),
'tipser': ('tipse',),
'tipses': ('tipse',),
'tipset': ('tipse',),
'tirr': ('tirre',),
'tirra': ('tirre',),
'tirre': ('tirre',),
'tirrer': ('tirre',),
'tirres': ('tirre',),
'tirret': ('tirre',),
'tisk': ('tiske',),
'tiska': ('tiske',),
'tiske': ('tiske',),
'tisker': ('tiske',),
'tiskes': ('tiske',),
'tisket': ('tiske',),
'tisl': ('tisle',),
'tisla': ('tisle',),
'tisle': ('tisle',),
'tisler': ('tisle',),
'tisles': ('tisle',),
'tislet': ('tisle',),
'tiss': ('tisse',),
'tissa': ('tisse',),
'tisse': ('tisse',),
'tisser': ('tisse',),
'tisses': ('tisse',),
'tisset': ('tisse',),
'titrer': ('titrere',),
'titrere': ('titrere',),
'titrerer': ('titrere',),
'titreres': ('titrere',),
'titrert': ('titrere',),
'titrerte': ('titrere',),
'titt': ('titte',),
'titta': ('titte',),
'titte': ('titte',),
'titter': ('titte',),
'tittes': ('titte',),
'tittet': ('titte',),
'tituler': ('titulere',),
'titulere': ('titulere',),
'titulerer': ('titulere',),
'tituleres': ('titulere',),
'titulert': ('titulere',),
'titulerte': ('titulere',),
'tjadr': ('tjadre',),
'tjadra': ('tjadre',),
'tjadre': ('tjadre',),
'tjadrer': ('tjadre',),
'tjadres': ('tjadre',),
'tjadret': ('tjadre',),
'tjafs': ('tjafse',),
'tjafsa': ('tjafse',),
'tjafse': ('tjafse',),
'tjafser': ('tjafse',),
'tjafses': ('tjafse',),
'tjafset': ('tjafse',),
'tjatr': ('tjatre',),
'tjatra': ('tjatre',),
'tjatre': ('tjatre',),
'tjatrer': ('tjatre',),
'tjatres': ('tjatre',),
'tjatret': ('tjatre',),
'tjatt': ('tjatte',),
'tjatta': ('tjatte',),
'tjatte': ('tjatte',),
'tjatter': ('tjatte',),
'tjattes': ('tjatte',),
'tjattet': ('tjatte',),
'tjeld': ('tjelde',),
'tjelda': ('tjelde',),
'tjelde': ('tjelde',),
'tjelder': ('tjelde',),
'tjeldes': ('tjelde',),
'tjeldet': ('tjelde',),
'tjen': ('tjene',),
'tjene': ('tjene',),
'tjener': ('tjene',),
'tjenes': ('tjene',),
'tjent': ('tjene',),
'tjente': ('tjene',),
'tjenestegjorde': ('tjenestegjøre',),
'tjenestegjort': ('tjenestegjøre',),
'tjenestegjør': ('tjenestegjøre',),
'tjenestegjøre': ('tjenestegjøre',),
'tjenestegjøres': ('tjenestegjøre',),
'tjenstgjorde': ('tjenstgjøre',),
'tjenstgjort': ('tjenstgjøre',),
'tjenstgjør': ('tjenstgjøre',),
'tjenstgjøre': ('tjenstgjøre',),
'tjenstgjøres': ('tjenstgjøre',),
'tjon': ('tjone',),
'tjona': ('tjone',),
'tjone': ('tjone',),
'tjoner': ('tjone',),
'tjones': ('tjone',),
'tjonet': ('tjone',),
'tjor': ('tjore',),
'tjora': ('tjore',),
'tjore': ('tjore',),
'tjorer': ('tjore',),
'tjores': ('tjore',),
'tjoret': ('tjore',),
'tjort': ('tjore',),
'tjorte': ('tjore',),
'tjukn': ('tjukne',),
'tjukna': ('tjukne',),
'tjukne': ('tjukne',),
'tjukner': ('tjukne',),
'tjuknes': ('tjukne',),
'tjuknet': ('tjukne',),
'tjuv': ('tjuve',),
'tjuva': ('tjuve',),
'tjuvd': ('tjuve',),
'tjuvde': ('tjuve',),
'tjuve': ('tjuve',),
'tjuver': ('tjuve',),
'tjuves': ('tjuve',),
'tjuvet': ('tjuve',),
'tjuvlytt': ('tjuvlytte',),
'tjuvlytta': ('tjuvlytte',),
'tjuvlytte': ('tjuvlytte',),
'tjuvlytter': ('tjuvlytte',),
'tjuvlyttes': ('tjuvlytte',),
'tjuvlyttet': ('tjuvlytte',),
'tjuvlån': ('tjuvlåne',),
'tjuvlåne': ('tjuvlåne',),
'tjuvlåner': ('tjuvlåne',),
'tjuvlånes': ('tjuvlåne',),
'tjuvlånt': ('tjuvlåne',),
'tjuvlånte': ('tjuvlåne',),
'tjuvslakt': ('tjuvslakte',),
'tjuvslakta': ('tjuvslakte',),
'tjuvslakte': ('tjuvslakte',),
'tjuvslakter': ('tjuvslakte',),
'tjuvslaktes': ('tjuvslakte',),
'tjuvslaktet': ('tjuvslakte',),
'tjuvstart': ('tjuvstarte',),
'tjuvstarta': ('tjuvstarte',),
'tjuvstarte': ('tjuvstarte',),
'tjuvstarter': ('tjuvstarte',),
'tjuvstartes': ('tjuvstarte',),
'tjuvstartet': ('tjuvstarte',),
'tjuvtitt': ('tju