# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

NOUNS_WORDFORMS = {
'à la carte-serveringene': ('à la carte-servering',),
'à la carte-serveringer': ('à la carte-servering',),
'à la carte-servering': ('à la carte-servering',),
'à la carte-serveringa': ('à la carte-servering',),
'à la carte-serveringen': ('à la carte-servering',),
'à la carte-serveringene': ('à la carte-servering',),
'14C-datering': ('14C-datering',),
'14C-dateringa': ('14C-datering',),
'14C-dateringen': ('14C-datering',),
'14C-dateringene': ('14C-datering',),
'14C-dateringer': ('14C-datering',),
'A': ('A',),
'A\'en': ('A',),
'A-en': ('A',),
'A-ene': ('A',),
'A-er': ('A',),
'A-dur': ('A-dur',),
'A-duren': ('A-dur',),
'A-durene': ('A-dur',),
'A-durer': ('A-dur',),
'A-egg': ('A-egg',),
'A-egga': ('A-egg',),
'A-eggene': ('A-egg',),
'A-egget': ('A-egg',),
'A-lag': ('A-lag',),
'A-laga': ('A-lag',),
'A-lagene': ('A-lag',),
'A-laget': ('A-lag',),
'A-menneska': ('A-menneske',),
'A-menneske': ('A-menneske',),
'A-menneskene': ('A-menneske',),
'A-mennesker': ('A-menneske',),
'A-mennesket': ('A-menneske',),
'A-moment': ('A-moment',),
'A-momenta': ('A-moment',),
'A-momentene': ('A-moment',),
'A-momenter': ('A-moment',),
'A-momentet': ('A-moment',),
'A-språk': ('A-språk',),
'A-språka': ('A-språk',),
'A-språkene': ('A-språk',),
'A-språket': ('A-språk',),
'A-vitamin': ('A-vitamin',),
'A-vitamina': ('A-vitamin',),
'A-vitaminene': ('A-vitamin',),
'A-vitaminer': ('A-vitamin',),
'A-vitaminet': ('A-vitamin',),
'A4-format': ('A4-format',),
'A4-formata': ('A4-format',),
'A4-formatene': ('A4-format',),
'A4-formater': ('A4-format',),
'A4-formatet': ('A4-format',),
'A5-format': ('A5-format',),
'A5-formata': ('A5-format',),
'A5-formatene': ('A5-format',),
'A5-formater': ('A5-format',),
'A5-formatet': ('A5-format',),
'ADB-operatør': ('ADB-operatør',),
'ADB-operatøren': ('ADB-operatør',),
'ADB-operatørene': ('ADB-operatør',),
'ADB-operatører': ('ADB-operatør',),
'AIDS': ('AIDS',),
'AIDSen': ('AIDS',),
'AIDSene': ('AIDS',),
'AIDSer': ('AIDS',),
'AIDS-smitte': ('AIDS-smitte',),
'AIDS-smitten': ('AIDS-smitte',),
'AIDS-smittene': ('AIDS-smitte',),
'AIDS-smitter': ('AIDS-smitte',),
'AV-middel': ('AV-middel',),
'AV-middelet': ('AV-middel',),
'AV-midla': ('AV-middel',),
'AV-midlene': ('AV-middel',),
'AV-midler': ('AV-middel',),
'AV-midlet': ('AV-middel',),
'Algol': ('Algol',),
'Ass': ('Ass',),
'Assen': ('Ass',),
'Assene': ('Ass',),
'Asser': ('Ass',),
'Ass-dur': ('Ass-dur',),
'Ass-duren': ('Ass-dur',),
'Ass-durene': ('Ass-dur',),
'Ass-durer': ('Ass-dur',),
'B': ('B',),
'B\'en': ('B',),
'B-en': ('B',),
'B-ene': ('B',),
'B-er': ('B',),
'B-dur': ('B-dur',),
'B-duren': ('B-dur',),
'B-durene': ('B-dur',),
'B-durer': ('B-dur',),
'B-film': ('B-film',),
'B-filmen': ('B-film',),
'B-filmene': ('B-film',),
'B-filmer': ('B-film',),
'B-kvalitet': ('B-kvalitet',),
'B-kvaliteten': ('B-kvalitet',),
'B-kvalitetene': ('B-kvalitet',),
'B-kvaliteter': ('B-kvalitet',),
'B-lag': ('B-lag',),
'B-laga': ('B-lag',),
'B-lagene': ('B-lag',),
'B-laget': ('B-lag',),
'B-menneska': ('B-menneske',),
'B-menneske': ('B-menneske',),
'B-menneskene': ('B-menneske',),
'B-mennesker': ('B-menneske',),
'B-mennesket': ('B-menneske',),
'B-moment': ('B-moment',),
'B-momenta': ('B-moment',),
'B-momentene': ('B-moment',),
'B-momenter': ('B-moment',),
'B-momentet': ('B-moment',),
'B-språk': ('B-språk',),
'B-språka': ('B-språk',),
'B-språkene': ('B-språk',),
'B-språket': ('B-språk',),
'B-vitamin': ('B-vitamin',),
'B-vitamina': ('B-vitamin',),
'B-vitaminene': ('B-vitamin',),
'B-vitaminer': ('B-vitamin',),
'B-vitaminet': ('B-vitamin',),
'BCG-vaksina': ('BCG-vaksine',),
'BCG-vaksine': ('BCG-vaksine',),
'BCG-vaksinen': ('BCG-vaksine',),
'BCG-vaksinene': ('BCG-vaksine',),
'BCG-vaksiner': ('BCG-vaksine',),
'BH': ('BH',),
'BHen': ('BH',),
'BHene': ('BH',),
'BHer': ('BH',),
'Basedows sjukdom': ('Basedows sjukdom',),
'Basedows sjukdommen': ('Basedows sjukdom',),
'Basedows sjukdommene': ('Basedows sjukdom',),
'Basedows sjukdommer': ('Basedows sjukdom',),
'Basedows sykdom': ('Basedows sykdom',),
'Basedows sykdommen': ('Basedows sykdom',),
'Basedows sykdommene': ('Basedows sykdom',),
'Basedows sykdommer': ('Basedows sykdom',),
'Beaufort-skala': ('Beaufort-skala',),
'Beaufort-skalaen': ('Beaufort-skala',),
'Beaufort-skalaene': ('Beaufort-skala',),
'Beaufort-skalaer': ('Beaufort-skala',),
'Blakka': ('Blakka',),
'Blakken': ('Blakken',),
'Borka': ('Borka',),
'Borken': ('Borken',),
'Bruna': ('Bruna',),
'Brunen': ('Brunen',),
'C': ('C',),
'C\'en': ('C',),
'C-en': ('C',),
'C-ene': ('C',),
'C-er': ('C',),
'C-dur': ('C-dur',),
'C-duren': ('C-dur',),
'C-durene': ('C-dur',),
'C-durer': ('C-dur',),
'C-moment': ('C-moment',),
'C-momenta': ('C-moment',),
'C-momentene': ('C-moment',),
'C-momenter': ('C-moment',),
'C-momentet': ('C-moment',),
'C-språk': ('C-språk',),
'C-språka': ('C-språk',),
'C-språkene': ('C-språk',),
'C-språket': ('C-språk',),
'C-vitamin': ('C-vitamin',),
'C-vitamina': ('C-vitamin',),
'C-vitaminene': ('C-vitamin',),
'C-vitaminer': ('C-vitamin',),
'C-vitaminet': ('C-vitamin',),
'CD': ('CD',),
'CDen': ('CD',),
'CDene': ('CD',),
'CDer': ('CD',),
'CD-plata': ('CD-plate',),
'CD-plate': ('CD-plate',),
'CD-platen': ('CD-plate',),
'CD-platene': ('CD-plate',),
'CD-plater': ('CD-plate',),
'CD-speller': ('CD-speller',),
'CD-spellere': ('CD-speller',),
'CD-spelleren': ('CD-speller',),
'CD-spellerer': ('CD-speller',),
'CD-spellerne': ('CD-speller',),
'CD-spiller': ('CD-spiller',),
'CD-spillere': ('CD-spiller',),
'CD-spilleren': ('CD-spiller',),
'CD-spillerer': ('CD-spiller',),
'CD-spillerne': ('CD-spiller',),
'Cess': ('Cess',),
'Cessen': ('Cess',),
'Cessene': ('Cess',),
'Cesser': ('Cess',),
'Ciss': ('Ciss',),
'Cissen': ('Ciss',),
'Cissene': ('Ciss',),
'Cisser': ('Ciss',),
'Ciss-dur': ('Ciss-dur',),
'Ciss-duren': ('Ciss-dur',),
'Ciss-durene': ('Ciss-dur',),
'Ciss-durer': ('Ciss-dur',),
'Cobol': ('Cobol',),
'D': ('D',),
'D\'en': ('D',),
'D-en': ('D',),
'D-ene': ('D',),
'D-er': ('D',),
'D-dag': ('D-dag',),
'D-dagen': ('D-dag',),
'D-dagene': ('D-dag',),
'D-dager': ('D-dag',),
'D-dur': ('D-dur',),
'D-duren': ('D-dur',),
'D-durene': ('D-dur',),
'D-durer': ('D-dur',),
'D-vitamin': ('D-vitamin',),
'D-vitamina': ('D-vitamin',),
'D-vitaminene': ('D-vitamin',),
'D-vitaminer': ('D-vitamin',),
'D-vitaminet': ('D-vitamin',),
'DDT': ('DDT',),
'DDTen': ('DDT',),
'DDTene': ('DDT',),
'DDTer': ('DDT',),
'DNA': ('DNA',),
'DNAa': ('DNA',),
'DNAene': ('DNA',),
'DNAet': ('DNA',),
'DNA-molekyl': ('DNA-molekyl',),
'DNA-molekyla': ('DNA-molekyl',),
'DNA-molekylene': ('DNA-molekyl',),
'DNA-molekyler': ('DNA-molekyl',),
'DNA-molekylet': ('DNA-molekyl',),
'Dess': ('Dess',),
'Dessen': ('Dess',),
'Dessene': ('Dess',),
'Desser': ('Dess',),
'Dess-dur': ('Dess-dur',),
'Dess-duren': ('Dess-dur',),
'Dess-durene': ('Dess-dur',),
'Dess-durer': ('Dess-dur',),
'Diss': ('Diss',),
'Dissen': ('Diss',),
'Dissene': ('Diss',),
'Disser': ('Diss',),
'Downs syndrom': ('Downs syndrom',),
'Downs syndroma': ('Downs syndrom',),
'Downs syndromene': ('Downs syndrom',),
'Downs syndromer': ('Downs syndrom',),
'Downs syndromet': ('Downs syndrom',),
'E': ('E',),
'E\'en': ('E',),
'E-en': ('E',),
'E-ene': ('E',),
'E-er': ('E',),
'E-dur': ('E-dur',),
'E-duren': ('E-dur',),
'E-durene': ('E-dur',),
'E-durer': ('E-dur',),
'EDB-anlegg': ('EDB-anlegg',),
'EDB-anlegga': ('EDB-anlegg',),
'EDB-anleggene': ('EDB-anlegg',),
'EDB-anlegget': ('EDB-anlegg',),
'EDB-operatør': ('EDB-operatør',),
'EDB-operatøren': ('EDB-operatør',),
'EDB-operatørene': ('EDB-operatør',),
'EDB-operatører': ('EDB-operatør',),
'EDB-senter': ('EDB-senter',),
'EDB-senteret': ('EDB-senter',),
'EDB-sentra': ('EDB-senter',),
'EDB-sentre': ('EDB-senter',),
'EDB-sentrene': ('EDB-senter',),
'EDB-sentret': ('EDB-senter',),
'EDB-sentral': ('EDB-sentral',),
'EDB-sentralen': ('EDB-sentral',),
'EDB-sentralene': ('EDB-sentral',),
'EDB-sentraler': ('EDB-sentral',),
'EDB-terminal': ('EDB-terminal',),
'EDB-terminalen': ('EDB-terminal',),
'EDB-terminalene': ('EDB-terminal',),
'EDB-terminaler': ('EDB-terminal',),
'EDB-utstyr': ('EDB-utstyr',),
'EDB-utstyra': ('EDB-utstyr',),
'EDB-utstyrene': ('EDB-utstyr',),
'EDB-utstyret': ('EDB-utstyr',),
'EF-land': ('EF-land',),
'EF-landa': ('EF-land',),
'EF-landene': ('EF-land',),
'EF-landet': ('EF-land',),
'EF-medlemskap': ('EF-medlemskap',),
'EF-medlemskapa': ('EF-medlemskap',),
'EF-medlemskapene': ('EF-medlemskap',),
'EF-medlemskapet': ('EF-medlemskap',),
'EM': ('EM',),
'EM-a': ('EM',),
'EM-ene': ('EM',),
'EM-et': ('EM',),
'EP': ('EP',),
'EPen': ('EP',),
'EPene': ('EP',),
'EPer': ('EP',),
'EP-plata': ('EP-plate',),
'EP-plate': ('EP-plate',),
'EP-platen': ('EP-plate',),
'EP-platene': ('EP-plate',),
'EP-plater': ('EP-plate',),
'Ess': ('Ess',),
'Essen': ('Ess',),
'Essene': ('Ess',),
'Esser': ('Ess',),
'Ess-dur': ('Ess-dur',),
'Ess-duren': ('Ess-dur',),
'Ess-durene': ('Ess-dur',),
'Ess-durer': ('Ess-dur',),
'EØS-avtale': ('EØS-avtale',),
'EØS-avtalen': ('EØS-avtale',),
'EØS-avtalene': ('EØS-avtale',),
'EØS-avtaler': ('EØS-avtale',),
'EØS-avtale': ('EØS-avtale',),
'EØS-avtalen': ('EØS-avtale',),
'EØS-avtalene': ('EØS-avtale',),
'EØS-avtaler': ('EØS-avtale',),
'F': ('F',),
'F\'en': ('F',),
'F-en': ('F',),
'F-ene': ('F',),
'F-er': ('F',),
'F-dur': ('F-dur',),
'F-duren': ('F-dur',),
'F-durene': ('F-dur',),
'F-durer': ('F-dur',),
'FM-band': ('FM-band',),
'FM-banda': ('FM-band',),
'FM-bandene': ('FM-band',),
'FM-bandet': ('FM-band',),
'FM-bånd': ('FM-bånd',),
'FM-bånda': ('FM-bånd',),
'FM-båndene': ('FM-bånd',),
'FM-båndet': ('FM-bånd',),
'FM-kringkasting': ('FM-kringkasting',),
'FM-kringkastinga': ('FM-kringkasting',),
'FM-kringkastingen': ('FM-kringkasting',),
'FM-kringkastingene': ('FM-kringkasting',),
'FM-kringkastinger': ('FM-kringkasting',),
'FM-sender': ('FM-sender',),
'FM-sendere': ('FM-sender',),
'FM-senderen': ('FM-sender',),
'FM-senderer': ('FM-sender',),
'FM-senderne': ('FM-sender',),
'Fess': ('Fess',),
'Fessen': ('Fess',),
'Fessene': ('Fess',),
'Fesser': ('Fess',),
'Fiss': ('Fiss',),
'Fissen': ('Fiss',),
'Fissene': ('Fiss',),
'Fisser': ('Fiss',),
'Fiss-dur': ('Fiss-dur',),
'Fiss-duren': ('Fiss-dur',),
'Fiss-durene': ('Fiss-dur',),
'Fiss-durer': ('Fiss-dur',),
'Fortran': ('Fortran',),
'G': ('G',),
'G\'en': ('G',),
'G-en': ('G',),
'G-ene': ('G',),
'G-er': ('G',),
'G-dur': ('G-dur',),
'G-duren': ('G-dur',),
'G-durene': ('G-dur',),
'G-durer': ('G-dur',),
'Gauss-kurve': ('Gauss-kurve',),
'Gauss-kurven': ('Gauss-kurve',),
'Gauss-kurvene': ('Gauss-kurve',),
'Gauss-kurver': ('Gauss-kurve',),
'Gess': ('Gess',),
'Gessen': ('Gess',),
'Gessene': ('Gess',),
'Gesser': ('Gess',),
'Gess-dur': ('Gess-dur',),
'Gess-duren': ('Gess-dur',),
'Gess-durene': ('Gess-dur',),
'Gess-durer': ('Gess-dur',),
'Giss': ('Giss',),
'Gissen': ('Giss',),
'Gissene': ('Giss',),
'Gisser': ('Giss',),
'Giss-dur': ('Giss-dur',),
'Giss-duren': ('Giss-dur',),
'Giss-durene': ('Giss-dur',),
'Giss-durer': ('Giss-dur',),
'H': ('H',),
'H\'en': ('H',),
'H-en': ('H',),
'H-ene': ('H',),
'H-er': ('H',),
'H-bjelke': ('H-bjelke',),
'H-bjelken': ('H-bjelke',),
'H-bjelkene': ('H-bjelke',),
'H-bjelker': ('H-bjelke',),
'H-dur': ('H-dur',),
'H-duren': ('H-dur',),
'H-durene': ('H-dur',),
'H-durer': ('H-dur',),
'H-melk': ('H-melk',),
'H-melka': ('H-melk',),
'H-melken': ('H-melk',),
'H-melkene': ('H-melk',),
'H-melker': ('H-melk',),
'H-melkkartong': ('H-melkkartong',),
'H-melkkartongen': ('H-melkkartong',),
'H-melkkartongene': ('H-melkkartong',),
'H-melkkartonger': ('H-melkkartong',),
'H-mjølk': ('H-mjølk',),
'H-mjølka': ('H-mjølk',),
'H-mjølken': ('H-mjølk',),
'H-mjølkene': ('H-mjølk',),
'H-mjølker': ('H-mjølk',),
'H-mjølkkartong': ('H-mjølkkartong',),
'H-mjølkkartongen': ('H-mjølkkartong',),
'H-mjølkkartongene': ('H-mjølkkartong',),
'H-mjølkkartonger': ('H-mjølkkartong',),
'HB-apparat': ('HB-apparat',),
'HB-apparata': ('HB-apparat',),
'HB-apparatene': ('HB-apparat',),
'HB-apparater': ('HB-apparat',),
'HB-apparatet': ('HB-apparat',),
'HIV': ('HIV',),
'HIV-smitte': ('HIV-smitte',),
'HIV-smitten': ('HIV-smitte',),
'HIV-smittene': ('HIV-smitte',),
'HIV-smitter': ('HIV-smitte',),
'HIV-virus': ('HIV-virus',),
'HIV-virusa': ('HIV-virus',),
'HIV-virusene': ('HIV-virus',),
'HIV-viruset': ('HIV-virus',),
'Hi-Fi': ('Hi-Fi',),
'Hi-Fien': ('Hi-Fi',),
'Hi-Fiene': ('Hi-Fi',),
'Hi-Fier': ('Hi-Fi',),
'I': ('I',),
'I\'en': ('I',),
'I-en': ('I',),
'I-ene': ('I',),
'I-er': ('I',),
'J': ('J',),
'J\'en': ('J',),
'J-en': ('J',),
'J-ene': ('J',),
'J-er': ('J',),
'Jesusbilda': ('Jesusbilde',),
'Jesusbilde': ('Jesusbilde',),
'Jesusbildene': ('Jesusbilde',),
'Jesusbilder': ('Jesusbilde',),
'Jesusbildet': ('Jesusbilde',),
'K': ('K',),
'K\'en': ('K',),
'K-en': ('K',),
'K-ene': ('K',),
'K-er': ('K',),
'KM': ('KM',),
'KM-a': ('KM',),
'KM-ene': ('KM',),
'KM-et': ('KM',),
'L': ('L',),
'L\'en': ('L',),
'L-en': ('L',),
'L-ene': ('L',),
'L-er': ('L',),
'LP': ('LP',),
'LPen': ('LP',),
'LPene': ('LP',),
'LPer': ('LP',),
'LP-plata': ('LP-plate',),
'LP-plate': ('LP-plate',),
'LP-platen': ('LP-plate',),
'LP-platene': ('LP-plate',),
'LP-plater': ('LP-plate',),
'LSD': ('LSD',),
'LSDen': ('LSD',),
'LSDene': ('LSD',),
'LSDer': ('LSD',),
'LSD-rus': ('LSD-rus',),
'LSD-rusa': ('LSD-rus',),
'LSD-rusen': ('LSD-rus',),
'LSD-rusene': ('LSD-rus',),
'LSD-ruser': ('LSD-rus',),
'LSD-ruset': ('LSD-rus',),
'M': ('M',),
'M\'en': ('M',),
'M-en': ('M',),
'M-ene': ('M',),
'M-er': ('M',),
'MS-pasient': ('MS-pasient',),
'MS-pasienten': ('MS-pasient',),
'MS-pasientene': ('MS-pasient',),
'MS-pasienter': ('MS-pasient',),
'MTB': ('MTB',),
'MTBen': ('MTB',),
'MTBene': ('MTB',),
'MTBer': ('MTB',),
'N': ('N',),
'N\'en': ('N',),
'N-en': ('N',),
'N-ene': ('N',),
'N-er': ('N',),
'NATO-land': ('NATO-land',),
'NATO-landa': ('NATO-land',),
'NATO-landene': ('NATO-land',),
'NATO-landet': ('NATO-land',),
'NM': ('NM',),
'NM-a': ('NM',),
'NM-ene': ('NM',),
'NM-et': ('NM',),
'NN-fange': ('NN-fange',),
'NN-fangen': ('NN-fange',),
'NN-fangene': ('NN-fange',),
'NN-fanger': ('NN-fange',),
'NS-medlem': ('NS-medlem',),
'NS-medlemma': ('NS-medlem',),
'NS-medlemmene': ('NS-medlem',),
'NS-medlemmer': ('NS-medlem',),
'NS-medlemmet': ('NS-medlem',),
'Nato-land': ('Nato-land',),
'Nato-landa': ('Nato-land',),
'Nato-landene': ('Nato-land',),
'Nato-landet': ('Nato-land',),
'Norden': ('Norden',),
'O': ('O',),
'O\'en': ('O',),
'O-en': ('O',),
'O-ene': ('O',),
'O-er': ('O',),
'OL': ('OL',),
'OL-a': ('OL',),
'OL-ene': ('OL',),
'OL-et': ('OL',),
'OL-pins': ('OL-pins',),
'OL-pinsen': ('OL-pins',),
'OL-pinsene': ('OL-pins',),
'OL-pinser': ('OL-pins',),
'Oksidenten': ('Oksidenten',),
'Ola': ('Ola',),
'P': ('P',),
'P\'en': ('P',),
'P-en': ('P',),
'P-ene': ('P',),
'P-er': ('P',),
'PC': ('PC',),
'PC-en': ('PC',),
'PC-ene': ('PC',),
'PC-er': ('PC',),
'PD': ('PD',),
'PDen': ('PD',),
'PDene': ('PD',),
'PDer': ('PD',),
'PD-setting': ('PD-setting',),
'PD-settinga': ('PD-setting',),
'PD-settingen': ('PD-setting',),
'PD-settingene': ('PD-setting',),
'PD-settinger': ('PD-setting',),
'PM': ('PM',),
'PMa': ('PM',),
'PMene': ('PM',),
'PMer': ('PM',),
'PMet': ('PM',),
'PR': ('PR',),
'PR-en': ('PR',),
'PR-ene': ('PR',),
'PR-er': ('PR',),
'PR-mann': ('PR-mann',),
'PR-mannen': ('PR-mann',),
'PR-menn': ('PR-mann',),
'PR-mennene': ('PR-mann',),
'PS': ('PS',),
'PSa': ('PS',),
'PSene': ('PS',),
'PSer': ('PS',),
'PSet': ('PS',),
'Parkinsons sjukdom': ('Parkinsons sjukdom',),
'Parkinsons sjukdommen': ('Parkinsons sjukdom',),
'Parkinsons sjukdommene': ('Parkinsons sjukdom',),
'Parkinsons sjukdommer': ('Parkinsons sjukdom',),
'Parkinsons sykdom': ('Parkinsons sykdom',),
'Parkinsons sykdommen': ('Parkinsons sykdom',),
'Parkinsons sykdommene': ('Parkinsons sykdom',),
'Parkinsons sykdommer': ('Parkinsons sykdom',),
'Pascal': ('Pascal',),
'Per': ('Per',),
'Peren': ('Per',),
'Perene': ('Per',),
'Perer': ('Per',),
'Q': ('Q',),
'Q\'en': ('Q',),
'Q-en': ('Q',),
'Q-ene': ('Q',),
'Q-er': ('Q',),
'Q-verdi': ('Q-verdi',),
'Q-verdien': ('Q-verdi',),
'Q-verdiene': ('Q-verdi',),
'Q-verdier': ('Q-verdi',),
'R': ('R',),
'R\'en': ('R',),
'R-en': ('R',),
'R-ene': ('R',),
'R-er': ('R',),
'Rh-faktor': ('Rh-faktor',),
'Rh-faktoren': ('Rh-faktor',),
'Rh-faktorene': ('Rh-faktor',),
'Rh-faktorer': ('Rh-faktor',),
'S': ('S',),
'S\'en': ('S',),
'S-en': ('S',),
'S-ene': ('S',),
'S-er': ('S',),
'SI-system': ('SI-system',),
'SI-systema': ('SI-system',),
'SI-systemene': ('SI-system',),
'SI-systemer': ('SI-system',),
'SI-systemet': ('SI-system',),
'SOS': ('SOS',),
'SOS-a': ('SOS',),
'SOS-ene': ('SOS',),
'SOS-et': ('SOS',),
'Sankt Elms eld': ('Sankt Elms eld',),
'Sankt Elms ild': ('Sankt Elms ild',),
'Simula': ('Simula',),
'Syden': ('Syden',),
'T': ('T',),
'T\'en': ('T',),
'T-en': ('T',),
'T-ene': ('T',),
'T-er': ('T',),
'T-bane': ('T-bane',),
'T-banen': ('T-bane',),
'T-banene': ('T-bane',),
'T-baner': ('T-bane',),
'T-beinsteik': ('T-beinsteik',),
'T-beinsteika': ('T-beinsteik',),
'T-beinsteiken': ('T-beinsteik',),
'T-beinsteikene': ('T-beinsteik',),
'T-beinsteiker': ('T-beinsteik',),
'T-beinstek': ('T-beinstek',),
'T-beinsteka': ('T-beinstek',),
'T-beinsteken': ('T-beinstek',),
'T-beinstekene': ('T-beinstek',),
'T-beinsteker': ('T-beinstek',),
'T-bensteik': ('T-bensteik',),
'T-bensteika': ('T-bensteik',),
'T-bensteiken': ('T-bensteik',),
'T-bensteikene': ('T-bensteik',),
'T-bensteiker': ('T-bensteik',),
'T-benstek': ('T-benstek',),
'T-bensteka': ('T-benstek',),
'T-bensteken': ('T-benstek',),
'T-benstekene': ('T-benstek',),
'T-bensteker': ('T-benstek',),
'T-bjelke': ('T-bjelke',),
'T-bjelken': ('T-bjelke',),
'T-bjelkene': ('T-bjelke',),
'T-bjelker': ('T-bjelke',),
'T-jern': ('T-jern',),
'T-jerna': ('T-jern',),
'T-jernene': ('T-jern',),
'T-jernet': ('T-jern',),
'T-kryss': ('T-kryss',),
'T-kryssa': ('T-kryss',),
'T-kryssene': ('T-kryss',),
'T-krysset': ('T-kryss',),
'T-skjorta': ('T-skjorte',),
'T-skjorte': ('T-skjorte',),
'T-skjorten': ('T-skjorte',),
'T-skjortene': ('T-skjorte',),
'T-skjorter': ('T-skjorte',),
'T-stål': ('T-stål',),
'T-ståla': ('T-stål',),
'T-stålene': ('T-stål',),
'T-stålet': ('T-stål',),
'TG-grammatikk': ('TG-grammatikk',),
'TG-grammatikken': ('TG-grammatikk',),
'TG-grammatikkene': ('TG-grammatikk',),
'TG-grammatikker': ('TG-grammatikk',),
'TV': ('TV',),
'TV-en': ('TV',),
'TV-ene': ('TV',),
'TV-er': ('TV',),
'TV-antenna': ('TV-antenne',),
'TV-antenne': ('TV-antenne',),
'TV-antennen': ('TV-antenne',),
'TV-antennene': ('TV-antenne',),
'TV-antenner': ('TV-antenne',),
'TV-apparat': ('TV-apparat',),
'TV-apparata': ('TV-apparat',),
'TV-apparatene': ('TV-apparat',),
'TV-apparater': ('TV-apparat',),
'TV-apparatet': ('TV-apparat',),
'TV-film': ('TV-film',),
'TV-filmen': ('TV-film',),
'TV-filmene': ('TV-film',),
'TV-filmer': ('TV-film',),
'TV-kanna': ('TV-kanne',),
'TV-kanne': ('TV-kanne',),
'TV-kannen': ('TV-kanne',),
'TV-kannene': ('TV-kanne',),
'TV-kanner': ('TV-kanne',),
'TV-kjendis': ('TV-kjendis',),
'TV-kjendisen': ('TV-kjendis',),
'TV-kjendisene': ('TV-kjendis',),
'TV-kjendiser': ('TV-kjendis',),
'TV-overføring': ('TV-overføring',),
'TV-overføringa': ('TV-overføring',),
'TV-overføringen': ('TV-overføring',),
'TV-overføringene': ('TV-overføring',),
'TV-overføringer': ('TV-overføring',),
'TV-overvåking': ('TV-overvåking',),
'TV-overvåkinga': ('TV-overvåking',),
'TV-overvåkingen': ('TV-overvåking',),
'TV-overvåkingene': ('TV-overvåking',),
'TV-overvåkinger': ('TV-overvåking',),
'TV-overvåkning': ('TV-overvåkning',),
'TV-overvåkninga': ('TV-overvåkning',),
'TV-overvåkningen': ('TV-overvåkning',),
'TV-overvåkningene': ('TV-overvåkning',),
'TV-overvåkninger': ('TV-overvåkning',),
'TV-program': ('TV-program',),
'TV-programma': ('TV-program',),
'TV-programmene': ('TV-program',),
'TV-programmer': ('TV-program',),
'TV-programmet': ('TV-program',),
'TV-skjerm': ('TV-skjerm',),
'TV-skjermen': ('TV-skjerm',),
'TV-skjermene': ('TV-skjerm',),
'TV-skjermer': ('TV-skjerm',),
'TV-vert': ('TV-vert',),
'TV-verten': ('TV-vert',),
'TV-vertene': ('TV-vert',),
'TV-verter': ('TV-vert',),
'TV-vertinna': ('TV-vertinne',),
'TV-vertinne': ('TV-vertinne',),
'TV-vertinnen': ('TV-vertinne',),
'TV-vertinnene': ('TV-vertinne',),
'TV-vertinner': ('TV-vertinne',),
'Tellus': ('Tellus',),
'Thalia': ('Thalia',),
'U': ('U',),
'U\'en': ('U',),
'U-en': ('U',),
'U-ene': ('U',),
'U-er': ('U',),
'U-dal': ('U-dal',),
'U-dalen': ('U-dal',),
'U-dalene': ('U-dal',),
'U-daler': ('U-dal',),
'U-jern': ('U-jern',),
'U-jerna': ('U-jern',),
'U-jernene': ('U-jern',),
'U-jernet': ('U-jern',),
'U-stål': ('U-stål',),
'U-ståla': ('U-stål',),
'U-stålene': ('U-stål',),
'U-stålet': ('U-stål',),
'UFO': ('UFO',),
'UFOen': ('UFO',),
'UFOene': ('UFO',),
'UFOer': ('UFO',),
'V': ('V',),
'V\'en': ('V',),
'V-en': ('V',),
'V-ene': ('V',),
'V-er': ('V',),
'V-bomba': ('V-bombe',),
'V-bombe': ('V-bombe',),
'V-bomben': ('V-bombe',),
'V-bombene': ('V-bombe',),
'V-bomber': ('V-bombe',),
'V-dag': ('V-dag',),
'V-dagen': ('V-dag',),
'V-dagene': ('V-dag',),
'V-dager': ('V-dag',),
'V-dal': ('V-dal',),
'V-dalen': ('V-dal',),
'V-dalene': ('V-dal',),
'V-daler': ('V-dal',),
'V-genser': ('V-genser',),
'V-gensere': ('V-genser',),
'V-genseren': ('V-genser',),
'V-genserer': ('V-genser',),
'V-genserne': ('V-genser',),
'V-utringning': ('V-utringning',),
'V-utringninga': ('V-utringning',),
'V-utringningen': ('V-utringning',),
'V-utringningene': ('V-utringning',),
'V-utringninger': ('V-utringning',),
'V6-kupong': ('V6-kupong',),
'V6-kupongen': ('V6-kupong',),
'V6-kupongene': ('V6-kupong',),
'V6-kuponger': ('V6-kupong',),
'V6-løp': ('V6-løp',),
'V6-løpa': ('V6-løp',),
'V6-løpene': ('V6-løp',),
'V6-løpet': ('V6-løp',),
'V6-rekka': ('V6-rekke',),
'V6-rekke': ('V6-rekke',),
'V6-rekken': ('V6-rekke',),
'V6-rekkene': ('V6-rekke',),
'V6-rekker': ('V6-rekke',),
'VIP': ('VIP',),
'VIPen': ('VIP',),
'VIPene': ('VIP',),
'VIPer': ('VIP',),
'VM': ('VM',),
'VM-a': ('VM',),
'VM-ene': ('VM',),
'VM-et': ('VM',),
'VVS-ingeniør': ('VVS-ingeniør',),
'VVS-ingeniøren': ('VVS-ingeniør',),
'VVS-ingeniørene': ('VVS-ingeniør',),
'VVS-ingeniører': ('VVS-ingeniør',),
'Vesten': ('Vesten',),
'Vårherre': ('Vårherre',),
'W': ('W',),
'W\'en': ('W',),
'W-en': ('W',),
'W-ene': ('W',),
'W-er': ('W',),
'WC': ('WC',),
'WCa': ('WC',),
'WCene': ('WC',),
'WCer': ('WC',),
'WCet': ('WC',),
'X': ('X',),
'X\'en': ('X',),
'X-en': ('X',),
'X-ene': ('X',),
'X-er': ('X',),
'Y': ('Y',),
'Y\'en': ('Y',),
'Y-en': ('Y',),
'Y-ene': ('Y',),
'Y-er': ('Y',),
'Z': ('Z',),
'Z\'en': ('Z',),
'Z-en': ('Z',),
'Z-ene': ('Z',),
'Z-er': ('Z',),
'Zodiak': ('Zodiak',),
'Zodiaken': ('Zodiak',),
'Zodiakene': ('Zodiak',),
'Zodiaker': ('Zodiak',),
'Zodiakus': ('Zodiakus',),
'Zodiakusen': ('Zodiakus',),
'Zodiakusene': ('Zodiakus',),
'Zodiakuser': ('Zodiakus',),
'a': ('a',),
'a\'en': ('a',),
'a-en': ('a',),
'a-ene': ('a',),
'a-er': ('a',),
'a': ('a',),
'a cappella-kor': ('a cappella-kor',),
'a cappella-kora': ('a cappella-kor',),
'a cappella-korene': ('a cappella-kor',),
'a cappella-koret': ('a cappella-kor',),
'a cappella-sang': ('a cappella-sang',),
'a cappella-sangen': ('a cappella-sang',),
'a cappella-sangene': ('a cappella-sang',),
'a cappella-sanger': ('a cappella-sang',),
'a konto-betaling': ('a konto-betaling',),
'a konto-betalinga': ('a konto-betaling',),
'a konto-betalingen': ('a konto-betaling',),
'a konto-betalingene': ('a konto-betaling',),
'a konto-betalinger': ('a konto-betaling',),
'a-bomba': ('a-bombe',),
'a-bombe': ('a-bombe',),
'a-bomben': ('a-bombe',),
'a-bombene': ('a-bombe',),
'a-bomber': ('a-bombe',),
'a-egg': ('a-egg',),
'a-egga': ('a-egg',),
'a-eggene': ('a-egg',),
'a-egget': ('a-egg',),
'a-endelse': ('a-endelse',),
'a-endelsen': ('a-endelse',),
'a-endelsene': ('a-endelse',),
'a-endelser': ('a-endelse',),
'a-ending': ('a-ending',),
'a-endinga': ('a-ending',),
'a-endingen': ('a-ending',),
'a-endingene': ('a-ending',),
'a-endinger': ('a-ending',),
'a-form': ('a-form',),
'a-forma': ('a-form',),
'a-formen': ('a-form',),
'a-formene': ('a-form',),
'a-former': ('a-form',),
'a-lag': ('a-lag',),
'a-laga': ('a-lag',),
'a-lagene': ('a-lag',),
'a-laget': ('a-lag',),
'a-menneska': ('a-menneske',),
'a-menneske': ('a-menneske',),
'a-menneskene': ('a-menneske',),
'a-mennesker': ('a-menneske',),
'a-mennesket': ('a-menneske',),
'a-moll': ('a-moll',),
'a-mollen': ('a-moll',),
'a-mollene': ('a-moll',),
'a-moller': ('a-moll',),
'a-mollkonsert': ('a-mollkonsert',),
'a-mollkonserten': ('a-mollkonsert',),
'a-mollkonsertene': ('a-mollkonsert',),
'a-mollkonserter': ('a-mollkonsert',),
'a-mål': ('a-mål',),
'a-måla': ('a-mål',),
'a-målene': ('a-mål',),
'a-målet': ('a-mål',),
'a-våpen': ('a-våpen',),
'a-våpenet': ('a-våpen',),
'a-våpna': ('a-våpen',),
'a-våpnene': ('a-våpen',),
'ab-kjøp': ('ab-kjøp',),
'ab-kjøpa': ('ab-kjøp',),
'ab-kjøpene': ('ab-kjøp',),
'ab-kjøpet': ('ab-kjøp',),
'ab-kontrakt': ('ab-kontrakt',),
'ab-kontrakten': ('ab-kontrakt',),
'ab-kontraktene': ('ab-kontrakt',),
'ab-kontrakter': ('ab-kontrakt',),
'abbed': ('abbed',),
'abbeden': ('abbed',),
'abbedene': ('abbed',),
'abbeder': ('abbed',),
'abbedi': ('abbedi',),
'abbedia': ('abbedi',),
'abbediene': ('abbedi',),
'abbedier': ('abbedi',),
'abbediet': ('abbedi',),
'abbedissa': ('abbedisse',),
'abbedisse': ('abbedisse',),
'abbedissen': ('abbedisse',),
'abbedissene': ('abbedisse',),
'abbedisser': ('abbedisse',),
'abbor': ('abbor',),
'abboren': ('abbor',),
'abborene': ('abbor',),
'abborer': ('abbor',),
'abbor': ('abbor',),
'abboren': ('abbor',),
'abborene': ('abbor',),
'abborer': ('abbor',),
'abbreviasjon': ('abbreviasjon',),
'abbreviasjonen': ('abbreviasjon',),
'abbreviasjonene': ('abbreviasjon',),
'abbreviasjoner': ('abbreviasjon',),
'abbreviatur': ('abbreviatur',),
'abbreviaturen': ('abbreviatur',),
'abbreviaturene': ('abbreviatur',),
'abbreviaturer': ('abbreviatur',),
'abc': ('abc',),
'abca': ('abc',),
'abcen': ('abc',),
'abcene': ('abc',),
'abcer': ('abc',),
'abc-bok': ('abc-bok',),
'abc-boka': ('abc-bok',),
'abc-boken': ('abc-bok',),
'abc-bøkene': ('abc-bok',),
'abc-bøker': ('abc-bok',),
'abc-krigføring': ('abc-krigføring',),
'abc-krigføringa': ('abc-krigføring',),
'abc-krigføringen': ('abc-krigføring',),
'abc-krigføringene': ('abc-krigføring',),
'abc-krigføringer': ('abc-krigføring',),
'abc-våpen': ('abc-våpen',),
'abc-våpenet': ('abc-våpen',),
'abc-våpna': ('abc-våpen',),
'abc-våpnene': ('abc-våpen',),
'abdikasjon': ('abdikasjon',),
'abdikasjonen': ('abdikasjon',),
'abdikasjonene': ('abdikasjon',),
'abdikasjoner': ('abdikasjon',),
'abdomen': ('abdomen',),
'abdomena': ('abdomen',),
'abdomenene': ('abdomen',),
'abdomenet': ('abdomen',),
'abdomina': ('abdomen',),
'abdominaene': ('abdomen',),
'aber': ('aber',),
'abera': ('aber',),
'abere': ('aber',),
'aberet': ('aber',),
'aberne': ('aber',),
'aberrasjon': ('aberrasjon',),
'aberrasjonen': ('aberrasjon',),
'aberrasjonene': ('aberrasjon',),
'aberrasjoner': ('aberrasjon',),
'abessinier': ('abessinier',),
'abessiniere': ('abessinier',),
'abessinieren': ('abessinier',),
'abessinierer': ('abessinier',),
'abessinierne': ('abessinier',),
'abkhaser': ('abkhaser',),
'abkhasere': ('abkhaser',),
'abkhaseren': ('abkhaser',),
'abkhaserer': ('abkhaser',),
'abkhaserne': ('abkhaser',),
'ablativ': ('ablativ',),
'ablativen': ('ablativ',),
'ablativene': ('ablativ',),
'ablativer': ('ablativ',),
'ablegøyene': ('ablegøyer',),
'ablegøyer': ('ablegøyer',),
'abnormitet': ('abnormitet',),
'abnormiteten': ('abnormitet',),
'abnormitetene': ('abnormitet',),
'abnormiteter': ('abnormitet',),
'abolisjon': ('abolisjon',),
'abolisjonen': ('abolisjon',),
'abolisjonene': ('abolisjon',),
'abolisjoner': ('abolisjon',),
'abolisjonist': ('abolisjonist',),
'abolisjonisten': ('abolisjonist',),
'abolisjonistene': ('abolisjonist',),
'abolisjonister': ('abolisjonist',),
'abonnement': ('abonnement',),
'abonnementa': ('abonnement',),
'abonnementene': ('abonnement',),
'abonnementer': ('abonnement',),
'abonnementet': ('abonnement',),
'abonnementsavgift': ('abonnementsavgift',),
'abonnementsavgifta': ('abonnementsavgift',),
'abonnementsavgiften': ('abonnementsavgift',),
'abonnementsavgiftene': ('abonnementsavgift',),
'abonnementsavgifter': ('abonnementsavgift',),
'abonnementskonsert': ('abonnementskonsert',),
'abonnementskonserten': ('abonnementskonsert',),
'abonnementskonsertene': ('abonnementskonsert',),
'abonnementskonserter': ('abonnementskonsert',),
'abonnementspris': ('abonnementspris',),
'abonnementsprisen': ('abonnementspris',),
'abonnementsprisene': ('abonnementspris',),
'abonnementspriser': ('abonnementspris',),
'abonnementssalg': ('abonnementssalg',),
'abonnementssalga': ('abonnementssalg',),
'abonnementssalgene': ('abonnementssalg',),
'abonnementssalget': ('abonnementssalg',),
'abonnent': ('abonnent',),
'abonnenten': ('abonnent',),
'abonnentene': ('abonnent',),
'abonnenter': ('abonnent',),
'aborigin': ('aborigin',),
'aboriginen': ('aborigin',),
'aboriginene': ('aborigin',),
'aboriginer': ('aborigin',),
'abort': ('abort',),
'aborten': ('abort',),
'abortene': ('abort',),
'aborter': ('abort',),
'abortiv': ('abortiv',),
'abortiva': ('abortiv',),
'abortivene': ('abortiv',),
'abortiver': ('abortiv',),
'abortivet': ('abortiv',),
'abortivkur': ('abortivkur',),
'abortivkuren': ('abortivkur',),
'abortivkurene': ('abortivkur',),
'abortivkurer': ('abortivkur',),
'abortivmiddel': ('abortivmiddel',),
'abortivmiddelet': ('abortivmiddel',),
'abortivmidla': ('abortivmiddel',),
'abortivmidlene': ('abortivmiddel',),
'abortivmidler': ('abortivmiddel',),
'abortivmidlet': ('abortivmiddel',),
'abortlov': ('abortlov',),
'abortloven': ('abortlov',),
'abortlovene': ('abortlov',),
'abortlover': ('abortlov',),
'abortsøker': ('abortsøker',),
'abortsøkere': ('abortsøker',),
'abortsøkeren': ('abortsøker',),
'abortsøkerer': ('abortsøker',),
'abortsøkerne': ('abortsøker',),
'abortus provocatus': ('abortus provocatus',),
'abrakadabra': ('abrakadabra',),
'abrakadabraa': ('abrakadabra',),
'abrakadabraene': ('abrakadabra',),
'abrakadabraet': ('abrakadabra',),
'abrodd': ('abrodd',),
'abrodden': ('abrodd',),
'abroddene': ('abrodd',),
'abrodder': ('abrodd',),
'abrot': ('abrot',),
'abroten': ('abrot',),
'abrotene': ('abrot',),
'abroter': ('abrot',),
'abscess': ('abscess',),
'abscessen': ('abscess',),
'abscessene': ('abscess',),
'abscesser': ('abscess',),
'abscisse': ('abscisse',),
'abscissen': ('abscisse',),
'abscissene': ('abscisse',),
'abscisser': ('abscisse',),
'abscisseakse': ('abscisseakse',),
'abscisseaksen': ('abscisseakse',),
'abscisseaksene': ('abscisseakse',),
'abscisseakser': ('abscisseakse',),
'absentia': ('absentia',),
'absint': ('absint',),
'absinten': ('absint',),
'absintene': ('absint',),
'absinter': ('absint',),
'absolusjon': ('absolusjon',),
'absolusjonen': ('absolusjon',),
'absolusjonene': ('absolusjon',),
'absolusjoner': ('absolusjon',),
'absolutisme': ('absolutisme',),
'absolutismen': ('absolutisme',),
'absolutismene': ('absolutisme',),
'absolutismer': ('absolutisme',),
'absolutist': ('absolutist',),
'absolutisten': ('absolutist',),
'absolutistene': ('absolutist',),
'absolutister': ('absolutist',),
'absolutt': ('absolutt',),
'absolutta': ('absolutt',),
'absoluttene': ('absolutt',),
'absolutter': ('absolutt',),
'absoluttet': ('absolutt',),
'absorbent': ('absorbent',),
'absorbenten': ('absorbent',),
'absorbentene': ('absorbent',),
'absorbenter': ('absorbent',),
'absorbering': ('absorbering',),
'absorberinga': ('absorbering',),
'absorberingen': ('absorbering',),
'absorberingene': ('absorbering',),
'absorberinger': ('absorbering',),
'absorberingsevna': ('absorberingsevne',),
'absorberingsevne': ('absorberingsevne',),
'absorberingsevnen': ('absorberingsevne',),
'absorberingsevnene': ('absorberingsevne',),
'absorberingsevner': ('absorberingsevne',),
'absorberingskoeffisient': ('absorberingskoeffisient',),
'absorberingskoeffisienten': ('absorberingskoeffisient',),
'absorberingskoeffisientene': ('absorberingskoeffisient',),
'absorberingskoeffisienter': ('absorberingskoeffisient',),
'absorpsjon': ('absorpsjon',),
'absorpsjonen': ('absorpsjon',),
'absorpsjonene': ('absorpsjon',),
'absorpsjoner': ('absorpsjon',),
'absorpsjonsevna': ('absorpsjonsevne',),
'absorpsjonsevne': ('absorpsjonsevne',),
'absorpsjonsevnen': ('absorpsjonsevne',),
'absorpsjonsevnene': ('absorpsjonsevne',),
'absorpsjonsevner': ('absorpsjonsevne',),
'absorpsjonskoeffisient': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisienten': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisientene': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisienter': ('absorpsjonskoeffisient',),
'abstinens': ('abstinens',),
'abstinensen': ('abstinens',),
'abstinensene': ('abstinens',),
'abstinenser': ('abstinens',),
'abstinenssymptom': ('abstinenssymptom',),
'abstinenssymptoma': ('abstinenssymptom',),
'abstinenssymptomene': ('abstinenssymptom',),
'abstinenssymptomer': ('abstinenssymptom',),
'abstinenssymptomet': ('abstinenssymptom',),
'abstinensvanske': ('abstinensvanske',),
'abstinensvansken': ('abstinensvanske',),
'abstinensvanskene': ('abstinensvanske',),
'abstinensvansker': ('abstinensvanske',),
'abstrahering': ('abstrahering',),
'abstraheringa': ('abstrahering',),
'abstraheringen': ('abstrahering',),
'abstraheringene': ('abstrahering',),
'abstraheringer': ('abstrahering',),
'abstraksjon': ('abstraksjon',),
'abstraksjonen': ('abstraksjon',),
'abstraksjonene': ('abstraksjon',),
'abstraksjoner': ('abstraksjon',),
'abstraksjonsevna': ('abstraksjonsevne',),
'abstraksjonsevne': ('abstraksjonsevne',),
'abstraksjonsevnen': ('abstraksjonsevne',),
'abstraksjonsevnene': ('abstraksjonsevne',),
'abstraksjonsevner': ('abstraksjonsevne',),
'abstraksjonsnivå': ('abstraksjonsnivå',),
'abstraksjonsnivåa': ('abstraksjonsnivå',),
'abstraksjonsnivåene': ('abstraksjonsnivå',),
'abstraksjonsnivåer': ('abstraksjonsnivå',),
'abstraksjonsnivået': ('abstraksjonsnivå',),
'abstrakt': ('abstrakt',),
'abstrakta': ('abstrakt',),
'abstraktene': ('abstrakt',),
'abstrakter': ('abstrakt',),
'abstraktet': ('abstrakt',),
'absurdisme': ('absurdisme',),
'absurdismen': ('absurdisme',),
'absurdismene': ('absurdisme',),
'absurdismer': ('absurdisme',),
'absurditet': ('absurditet',),
'absurditeten': ('absurditet',),
'absurditetene': ('absurditet',),
'absurditeter': ('absurditet',),
'accent aigu': ('accent aigu',),
'accent aiguen': ('accent aigu',),
'accent aiguene': ('accent aigu',),
'accent aiguer': ('accent aigu',),
'accent circonflexe': ('accent circonflexe',),
'accent circonflexen': ('accent circonflexe',),
'accent circonflexene': ('accent circonflexe',),
'accent circonflexer': ('accent circonflexe',),
'accent grave': ('accent grave',),
'accent graven': ('accent grave',),
'accent gravene': ('accent grave',),
'accent graver': ('accent grave',),
'accessoirene': ('accessoirer',),
'accessoirer': ('accessoirer',),
'acetat': ('acetat',),
'acetata': ('acetat',),
'acetatene': ('acetat',),
'acetater': ('acetat',),
'acetatet': ('acetat',),
'aceton': ('aceton',),
'acetona': ('aceton',),
'acetonene': ('aceton',),
'acetonet': ('aceton',),
'acetyl': ('acetyl',),
'acetyla': ('acetyl',),
'acetylene': ('acetyl',),
'acetylet': ('acetyl',),
'acetylen': ('acetylen',),
'acetylena': ('acetylen',),
'acetylenene': ('acetylen',),
'acetylenet': ('acetylen',),
'acetylsalisylsyra': ('acetylsalisylsyre',),
'acetylsalisylsyre': ('acetylsalisylsyre',),
'acetylsalisylsyren': ('acetylsalisylsyre',),
'acetylsalisylsyrene': ('acetylsalisylsyre',),
'acetylsalisylsyrer': ('acetylsalisylsyre',),
'acre': ('acre',),
'acren': ('acre',),
'acrene': ('acre',),
'acres': ('acre',),
'actinium': ('actinium',),
'actiniuma': ('actinium',),
'actiniumene': ('actinium',),
'actiniumet': ('actinium',),
'acyl': ('acyl',),
'acyla': ('acyl',),
'acylene': ('acyl',),
'acylet': ('acyl',),
'ad hoc-definisjon': ('ad hoc-definisjon',),
'ad hoc-definisjonen': ('ad hoc-definisjon',),
'ad hoc-definisjonene': ('ad hoc-definisjon',),
'ad hoc-definisjoner': ('ad hoc-definisjon',),
'adagio': ('adagio',),
'adagioen': ('adagio',),
'adagioene': ('adagio',),
'adagioer': ('adagio',),
'adagio': ('adagio',),
'adagioa': ('adagio',),
'adagioene': ('adagio',),
'adagioer': ('adagio',),
'adagioet': ('adagio',),
'adam': ('adam',),
'adamen': ('adam',),
'adamene': ('adam',),
'adamer': ('adam',),
'adamsdrakt': ('adamsdrakt',),
'adamsdrakta': ('adamsdrakt',),
'adamsdrakten': ('adamsdrakt',),
'adamsdraktene': ('adamsdrakt',),
'adamsdrakter': ('adamsdrakt',),
'adamsepla': ('adamseple',),
'adamseple': ('adamseple',),
'adamseplene': ('adamseple',),
'adamsepler': ('adamseple',),
'adamseplet': ('adamseple',),
'adamsnatur': ('adamsnatur',),
'adamsnaturen': ('adamsnatur',),
'adamsnaturene': ('adamsnatur',),
'adamsnaturer': ('adamsnatur',),
'adamsslekt': ('adamsslekt',),
'adamsslekta': ('adamsslekt',),
'adamsslekten': ('adamsslekt',),
'adamsslektene': ('adamsslekt',),
'adamsslekter': ('adamsslekt',),
'adapsjon': ('adapsjon',),
'adapsjonen': ('adapsjon',),
'adapsjonene': ('adapsjon',),
'adapsjoner': ('adapsjon',),
'adapsjonsevna': ('adapsjonsevne',),
'adapsjonsevne': ('adapsjonsevne',),
'adapsjonsevnen': ('adapsjonsevne',),
'adapsjonsevnene': ('adapsjonsevne',),
'adapsjonsevner': ('adapsjonsevne',),
'adaptasjon': ('adaptasjon',),
'adaptasjonen': ('adaptasjon',),
'adaptasjonene': ('adaptasjon',),
'adaptasjoner': ('adaptasjon',),
'adapter': ('adapter',),
'adaptere': ('adapter',),
'adapteren': ('adapter',),
'adapterer': ('adapter',),
'adapterne': ('adapter',),
'adb-operatør': ('adb-operatør',),
'adb-operatøren': ('adb-operatør',),
'adb-operatørene': ('adb-operatør',),
'adb-operatører': ('adb-operatør',),
'addend': ('addend',),
'addenden': ('addend',),
'addendene': ('addend',),
'addender': ('addend',),
'addering': ('addering',),
'adderinga': ('addering',),
'adderingen': ('addering',),
'adderingene': ('addering',),
'adderinger': ('addering',),
'addisjon': ('addisjon',),
'addisjonen': ('addisjon',),
'addisjonene': ('addisjon',),
'addisjoner': ('addisjon',),
'addisjonsfeil': ('addisjonsfeil',),
'addisjonsfeilen': ('addisjonsfeil',),
'addisjonsfeilene': ('addisjonsfeil',),
'addisjonsoppgava': ('addisjonsoppgave',),
'addisjonsoppgave': ('addisjonsoppgave',),
'addisjonsoppgaven': ('addisjonsoppgave',),
'addisjonsoppgavene': ('addisjonsoppgave',),
'addisjonsoppgaver': ('addisjonsoppgave',),
'addisjonsreaksjon': ('addisjonsreaksjon',),
'addisjonsreaksjonen': ('addisjonsreaksjon',),
'addisjonsreaksjonene': ('addisjonsreaksjon',),
'addisjonsreaksjoner': ('addisjonsreaksjon',),
'addisjonsstykka': ('addisjonsstykke',),
'addisjonsstykke': ('addisjonsstykke',),
'addisjonsstykkene': ('addisjonsstykke',),
'addisjonsstykker': ('addisjonsstykke',),
'addisjonsstykket': ('addisjonsstykke',),
'addisjonstegn': ('addisjonstegn',),
'addisjonstegna': ('addisjonstegn',),
'addisjonstegnene': ('addisjonstegn',),
'addisjonstegnet': ('addisjonstegn',),
'additiv': ('additiv',),
'additiva': ('additiv',),
'additivene': ('additiv',),
'additiver': ('additiv',),
'additivet': ('additiv',),
'adel': ('adel',),
'adelen': ('adel',),
'adlene': ('adel',),
'adler': ('adel',),
'adelsbrev': ('adelsbrev',),
'adelsbreva': ('adelsbrev',),
'adelsbrevene': ('adelsbrev',),
'adelsbrever': ('adelsbrev',),
'adelsbrevet': ('adelsbrev',),
'adelsdiplom': ('adelsdiplom',),
'adelsdiploma': ('adelsdiplom',),
'adelsdiplomene': ('adelsdiplom',),
'adelsdiplomer': ('adelsdiplom',),
'adelsdiplomet': ('adelsdiplom',),
'adelskalender': ('adelskalender',),
'adelskalendere': ('adelskalender',),
'adelskalenderen': ('adelskalender',),
'adelskalenderer': ('adelskalender',),
'adelskalenderne': ('adelskalender',),
'adelskalendre': ('adelskalender',),
'adelskalendrene': ('adelskalender',),
'adelskalendrer': ('adelskalender',),
'adelskap': ('adelskap',),
'adelskapa': ('adelskap',),
'adelskapen': ('adelskap',),
'adelskapene': ('adelskap',),
'adelskaper': ('adelskap',),
'adelskapet': ('adelskap',),
'adelsmann': ('adelsmann',),
'adelsmannen': ('adelsmann',),
'adelsmenn': ('adelsmann',),
'adelsmennene': ('adelsmann',),
'adelsmerka': ('adelsmerke',),
'adelsmerke': ('adelsmerke',),
'adelsmerkene': ('adelsmerke',),
'adelsmerker': ('adelsmerke',),
'adelsmerket': ('adelsmerke',),
'adelsprivileg': ('adelsprivileg',),
'adelsprivilega': ('adelsprivileg',),
'adelsprivilegene': ('adelsprivileg',),
'adelsprivileger': ('adelsprivileg',),
'adelsprivileget': ('adelsprivileg',),
'adelsprivilegia': ('adelsprivilegium',),
'adelsprivilegiene': ('adelsprivilegium',),
'adelsprivilegier': ('adelsprivilegium',),
'adelsprivilegiet': ('adelsprivilegium',),
'adelsprivilegium': ('adelsprivilegium',),
'adelsskjold': ('adelsskjold',),
'adelsskjolda': ('adelsskjold',),
'adelsskjoldene': ('adelsskjold',),
'adelsskjoldet': ('adelsskjold',),
'adelsslekt': ('adelsslekt',),
'adelsslekta': ('adelsslekt',),
'adelsslekten': ('adelsslekt',),
'adelsslektene': ('adelsslekt',),
'adelsslekter': ('adelsslekt',),
'adelsstand': ('adelsstand',),
'adelsstanden': ('adelsstand',),
'adelsstandene': ('adelsstand',),
'adelsstander': ('adelsstand',),
'adelstitlene': ('adelstittel',),
'adelstitler': ('adelstittel',),
'adelstittel': ('adelstittel',),
'adelstittelen': ('adelstittel',),
'adelsætt': ('adelsætt',),
'adelsætta': ('adelsætt',),
'adelsætten': ('adelsætt',),
'adelsættene': ('adelsætt',),
'adelsætter': ('adelsætt',),
'adenitt': ('adenitt',),
'adenitten': ('adenitt',),
'adenittene': ('adenitt',),
'adenitter': ('adenitt',),
'adept': ('adept',),
'adepten': ('adept',),
'adeptene': ('adept',),
'adepter': ('adept',),
'adgang': ('adgang',),
'adgangen': ('adgang',),
'adgangene': ('adgang',),
'adganger': ('adgang',),
'adgangsbillett': ('adgangsbillett',),
'adgangsbilletten': ('adgangsbillett',),
'adgangsbillettene': ('adgangsbillett',),
'adgangsbilletter': ('adgangsbillett',),
'adgangskort': ('adgangskort',),
'adgangskorta': ('adgangskort',),
'adgangskortene': ('adgangskort',),
'adgangskortet': ('adgangskort',),
'adgangstegn': ('adgangstegn',),
'adgangstegna': ('adgangstegn',),
'adgangstegnene': ('adgangstegn',),
'adgangstegnet': ('adgangstegn',),
'adherens': ('adherens',),
'adherensen': ('adherens',),
'adherensene': ('adherens',),
'adherenser': ('adherens',),
'adhesjon': ('adhesjon',),
'adhesjonen': ('adhesjon',),
'adhesjonene': ('adhesjon',),
'adhesjoner': ('adhesjon',),
'adiafora': ('adiaforon',),
'adiaforaene': ('adiaforon',),
'adiaforon': ('adiaforon',),
'adiaforonet': ('adiaforon',),
'adjektiv': ('adjektiv',),
'adjektiva': ('adjektiv',),
'adjektivene': ('adjektiv',),
'adjektiver': ('adjektiv',),
'adjektivet': ('adjektiv',),
'adjunkt': ('adjunkt',),
'adjunkten': ('adjunkt',),
'adjunktene': ('adjunkt',),
'adjunkter': ('adjunkt',),
'adjunkteksamen': ('adjunkteksamen',),
'adjunkteksamenen': ('adjunkteksamen',),
'adjunkteksamenene': ('adjunkteksamen',),
'adjunkteksamener': ('adjunkteksamen',),
'adjunktkompetanse': ('adjunktkompetanse',),
'adjunktkompetansen': ('adjunktkompetanse',),
'adjunktkompetansene': ('adjunktkompetanse',),
'adjunktkompetanser': ('adjunktkompetanse',),
'adjutant': ('adjutant',),
'adjutanten': ('adjutant',),
'adjutantene': ('adjutant',),
'adjutanter': ('adjutant',),
'adjutantstab': ('adjutantstab',),
'adjutantstaben': ('adjutantstab',),
'adjutantstabene': ('adjutantstab',),
'adjutantstaber': ('adjutantstab',),
'adjutantur': ('adjutantur',),
'adjutanturen': ('adjutantur',),
'adjutanturene': ('adjutantur',),
'adjutanturer': ('adjutantur',),
'adjø': ('adjø',),
'adjøa': ('adjø',),
'adjøene': ('adjø',),
'adjøer': ('adjø',),
'adjøet': ('adjø',),
'administrasjon': ('administrasjon',),
'administrasjonen': ('administrasjon',),
'administrasjonene': ('administrasjon',),
'administrasjoner': ('administrasjon',),
'administrasjonsbygning': ('administrasjonsbygning',),
'administrasjonsbygninga': ('administrasjonsbygning',),
'administrasjonsbygningen': ('administrasjonsbygning',),
'administrasjonsbygningene': ('administrasjonsbygning',),
'administrasjonsbygninger': ('administrasjonsbygning',),
'administrasjonssekretær': ('administrasjonssekretær',),
'administrasjonssekretæren': ('administrasjonssekretær',),
'administrasjonssekretærene': ('administrasjonssekretær',),
'administrasjonssekretærer': ('administrasjonssekretær',),
'administrasjonsstyra': ('administrasjonsstyre',),
'administrasjonsstyre': ('administrasjonsstyre',),
'administrasjonsstyrene': ('administrasjonsstyre',),
'administrasjonsstyrer': ('administrasjonsstyre',),
'administrasjonsstyret': ('administrasjonsstyre',),
'administrasjonstalent': ('administrasjonstalent',),
'administrasjonstalenta': ('administrasjonstalent',),
'administrasjonstalentene': ('administrasjonstalent',),
'administrasjonstalentet': ('administrasjonstalent',),
'administrasjonsutgift': ('administrasjonsutgift',),
'administrasjonsutgifta': ('administrasjonsutgift',),
'administrasjonsutgiften': ('administrasjonsutgift',),
'administrasjonsutgiftene': ('administrasjonsutgift',),
'administrasjonsutgifter': ('administrasjonsutgift',),
'administrator': ('administrator',),
'administratoren': ('administrator',),
'administratorene': ('administrator',),
'administratorer': ('administrator',),
'admiral': ('admiral',),
'admiralen': ('admiral',),
'admiralene': ('admiral',),
'admiraler': ('admiral',),
'admiralflagg': ('admiralflagg',),
'admiralflagga': ('admiralflagg',),
'admiralflaggene': ('admiralflagg',),
'admiralflagget': ('admiralflagg',),
'admiralitet': ('admiralitet',),
'admiraliteta': ('admiralitet',),
'admiralitetene': ('admiralitet',),
'admiralitetet': ('admiralitet',),
'admiralsflagg': ('admiralsflagg',),
'admiralsflagga': ('admiralsflagg',),
'admiralsflaggene': ('admiralsflagg',),
'admiralsflagget': ('admiralsflagg',),
'admiralskip': ('admiralskip',),
'admiralskipa': ('admiralskip',),
'admiralskipene': ('admiralskip',),
'admiralskipet': ('admiralskip',),
'admiralsskip': ('admiralsskip',),
'admiralsskipa': ('admiralsskip',),
'admiralsskipene': ('admiralsskip',),
'admiralsskipet': ('admiralsskip',),
'admiralsstab': ('admiralsstab',),
'admiralsstaben': ('admiralsstab',),
'admiralsstabene': ('admiralsstab',),
'admiralsstaber': ('admiralsstab',),
'admiralstab': ('admiralstab',),
'admiralstaben': ('admiralstab',),
'admiralstabene': ('admiralstab',),
'admiralstaber': ('admiralstab',),
'adonis': ('adonis',),
'adonisen': ('adonis',),
'adonisene': ('adonis',),
'adoniser': ('adonis',),
'adopsjon': ('adopsjon',),
'adopsjonen': ('adopsjon',),
'adopsjonene': ('adopsjon',),
'adopsjoner': ('adopsjon',),
'adopsjonskontor': ('adopsjonskontor',),
'adopsjonskontora': ('adopsjonskontor',),
'adopsjonskontorene': ('adopsjonskontor',),
'adopsjonskontorer': ('adopsjonskontor',),
'adopsjonskontoret': ('adopsjonskontor',),
'adopsjonstillatelse': ('adopsjonstillatelse',),
'adopsjonstillatelsen': ('adopsjonstillatelse',),
'adopsjonstillatelsene': ('adopsjonstillatelse',),
'adopsjonstillatelser': ('adopsjonstillatelse',),
'adoptant': ('adoptant',),
'adoptanten': ('adoptant',),
'adoptantene': ('adoptant',),
'adoptanter': ('adoptant',),
'adoptivbarn': ('adoptivbarn',),
'adoptivbarna': ('adoptivbarn',),
'adoptivbarnene': ('adoptivbarn',),
'adoptivbarnet': ('adoptivbarn',),
'adrenalin': ('adrenalin',),
'adrenalina': ('adrenalin',),
'adrenalinene': ('adrenalin',),
'adrenalinet': ('adrenalin',),
'adressant': ('adressant',),
'adressanten': ('adressant',),
'adressantene': ('adressant',),
'adressanter': ('adressant',),
'adressat': ('adressat',),
'adressaten': ('adressat',),
'adressatene': ('adressat',),
'adressater': ('adressat',),
'adressa': ('adresse',),
'adresse': ('adresse',),
'adressen': ('adresse',),
'adressene': ('adresse',),
'adresser': ('adresse',),
'adresseavis': ('adresseavis',),
'adresseavisa': ('adresseavis',),
'adresseavisen': ('adresseavis',),
'adresseavisene': ('adresseavis',),
'adresseaviser': ('adresseavis',),
'adresseforandring': ('adresseforandring',),
'adresseforandringa': ('adresseforandring',),
'adresseforandringen': ('adresseforandring',),
'adresseforandringene': ('adresseforandring',),
'adresseforandringer': ('adresseforandring',),
'adressekalender': ('adressekalender',),
'adressekalendere': ('adressekalender',),
'adressekalenderen': ('adressekalender',),
'adressekalenderer': ('adressekalender',),
'adressekalenderne': ('adressekalender',),
'adressekalendre': ('adressekalender',),
'adressekalendrene': ('adressekalender',),
'adressekalendrer': ('adressekalender',),
'adressekort': ('adressekort',),
'adressekorta': ('adressekort',),
'adressekortene': ('adressekort',),
'adressekortet': ('adressekort',),
'adressemegler': ('adressemegler',),
'adressemeglere': ('adressemegler',),
'adressemegleren': ('adressemegler',),
'adressemeglerer': ('adressemegler',),
'adressemeglerne': ('adressemegler',),
'adressemegling': ('adressemegling',),
'adressemeglinga': ('adressemegling',),
'adressemeglingen': ('adressemegling',),
'adressemeglingene': ('adressemegling',),
'adressemeglinger': ('adressemegling',),
'adressemekler': ('adressemekler',),
'adressemeklere': ('adressemekler',),
'adressemekleren': ('adressemekler',),
'adressemeklerer': ('adressemekler',),
'adressemeklerne': ('adressemekler',),
'adressemekling': ('adressemekling',),
'adressemeklinga': ('adressemekling',),
'adressemeklingen': ('adressemekling',),
'adressemeklingene': ('adressemekling',),
'adressemeklinger': ('adressemekling',),
'adresseringsmaskin': ('adresseringsmaskin',),
'adresseringsmaskina': ('adresseringsmaskin',),
'adresseringsmaskinen': ('adresseringsmaskin',),
'adresseringsmaskinene': ('adresseringsmaskin',),
'adresseringsmaskiner': ('adresseringsmaskin',),
'adsorpsjon': ('adsorpsjon',),
'adsorpsjonen': ('adsorpsjon',),
'adsorpsjonene': ('adsorpsjon',),
'adsorpsjoner': ('adsorpsjon',),
'advarsel': ('advarsel',),
'advarselen': ('advarsel',),
'advarslene': ('advarsel',),
'advarsler': ('advarsel',),
'advent': ('advent',),
'adventen': ('advent',),
'adventene': ('advent',),
'adventer': ('advent',),
'adventist': ('adventist',),
'adventisten': ('adventist',),
'adventistene': ('adventist',),
'adventister': ('adventist',),
'adventskalender': ('adventskalender',),
'adventskalendere': ('adventskalender',),
'adventskalenderen': ('adventskalender',),
'adventskalenderer': ('adventskalender',),
'adventskalenderne': ('adventskalender',),
'adventskalendre': ('adventskalender',),
'adventskalendrene': ('adventskalender',),
'adventskalendrer': ('adventskalender',),
'adventsstake': ('adventsstake',),
'adventsstaken': ('adventsstake',),
'adventsstakene': ('adventsstake',),
'adventsstaker': ('adventsstake',),
'adventssøndag': ('adventssøndag',),
'adventssøndagen': ('adventssøndag',),
'adventssøndagene': ('adventssøndag',),
'adventssøndager': ('adventssøndag',),
'adventstid': ('adventstid',),
'adventstida': ('adventstid',),
'adventstiden': ('adventstid',),
'adventstidene': ('adventstid',),
'adventstider': ('adventstid',),
'adverb': ('adverb',),
'adverba': ('adverb',),
'adverbene': ('adverb',),
'adverber': ('adverb',),
'adverbet': ('adverb',),
'adverb': ('adverb',),
'adverba': ('adverb',),
'adverbene': ('adverb',),
'adverber': ('adverb',),
'adverbet': ('adverb',),
'adverbial': ('adverbial',),
'adverbiala': ('adverbial',),
'adverbialene': ('adverbial',),
'adverbialer': ('adverbial',),
'adverbialet': ('adverbial',),
'adverbia': ('adverbium',),
'adverbiene': ('adverbium',),
'adverbier': ('adverbium',),
'adverbiet': ('adverbium',),
'adverbium': ('adverbium',),
'adverbia': ('adverbium',),
'adverbiene': ('adverbium',),
'adverbier': ('adverbium',),
'adverbiet': ('adverbium',),
'adverbium': ('adverbium',),
'advis': ('advis',),
'advisen': ('advis',),
'advisene': ('advis',),
'advokat': ('advokat',),
'advokaten': ('advokat',),
'advokatene': ('advokat',),
'advokater': ('advokat',),
'advokatbevilling': ('advokatbevilling',),
'advokatbevillingen': ('advokatbevilling',),
'advokatbevillingene': ('advokatbevilling',),
'advokatbevillinger': ('advokatbevilling',),
'advokatfirma': ('advokatfirma',),
'advokatfirmaene': ('advokatfirma',),
'advokatfirmaer': ('advokatfirma',),
'advokatfirmaet': ('advokatfirma',),
'advokatur': ('advokatur',),
'advokaturen': ('advokatur',),
'advokaturene': ('advokatur',),
'advokaturer': ('advokatur',),
'aerobic': ('aerobic',),
'aerobicen': ('aerobic',),
'aerobicene': ('aerobic',),
'aerobicer': ('aerobic',),
'aerodrom': ('aerodrom',),
'aerodromen': ('aerodrom',),
'aerodromene': ('aerodrom',),
'aerodromer': ('aerodrom',),
'aerodynamikk': ('aerodynamikk',),
'aerodynamikken': ('aerodynamikk',),
'aerodynamikkene': ('aerodynamikk',),
'aerodynamikker': ('aerodynamikk',),
'aerogram': ('aerogram',),
'aerogramma': ('aerogram',),
'aerogrammene': ('aerogram',),
'aerogrammer': ('aerogram',),
'aerogrammet': ('aerogram',),
'aeroklubb': ('aeroklubb',),
'aeroklubben': ('aeroklubb',),
'aeroklubbene': ('aeroklubb',),
'aeroklubber': ('aeroklubb',),
'aerolitt': ('aerolitt',),
'aerolitten': ('aerolitt',),
'aerolittene': ('aerolitt',),
'aerolitter': ('aerolitt',),
'aerologi': ('aerologi',),
'aerologien': ('aerologi',),
'aerologiene': ('aerologi',),
'aerologier': ('aerologi',),
'aeronaut': ('aeronaut',),
'aeronauten': ('aeronaut',),
'aeronautene': ('aeronaut',),
'aeronauter': ('aeronaut',),
'aeroplan': ('aeroplan',),
'aeroplana': ('aeroplan',),
'aeroplanene': ('aeroplan',),
'aeroplaner': ('aeroplan',),
'aeroplanet': ('aeroplan',),
'aerosol': ('aerosol',),
'aerosolen': ('aerosol',),
'aerosolene': ('aerosol',),
'aerosoler': ('aerosol',),
'aerosolboks': ('aerosolboks',),
'aerosolboksen': ('aerosolboks',),
'aerosolboksene': ('aerosolboks',),
'aerosolbokser': ('aerosolboks',),
'afasi': ('afasi',),
'afasien': ('afasi',),
'afasiene': ('afasi',),
'afasier': ('afasi',),
'afatiker': ('afatiker',),
'afatikere': ('afatiker',),
'afatikeren': ('afatiker',),
'afatikerer': ('afatiker',),
'afatikerne': ('afatiker',),
'affeksjon': ('affeksjon',),
'affeksjonen': ('affeksjon',),
'affeksjonene': ('affeksjon',),
'affeksjoner': ('affeksjon',),
'affeksjonsverdi': ('affeksjonsverdi',),
'affeksjonsverdien': ('affeksjonsverdi',),
'affeksjonsverdiene': ('affeksjonsverdi',),
'affeksjonsverdier': ('affeksjonsverdi',),
'affekt': ('affekt',),
'affekten': ('affekt',),
'affektene': ('affekt',),
'affekter': ('affekt',),
'affektasjon': ('affektasjon',),
'affektasjonen': ('affektasjon',),
'affektasjonene': ('affektasjon',),
'affektasjoner': ('affektasjon',),
'affiks': ('affiks',),
'affiksa': ('affiks',),
'affiksene': ('affiks',),
'affikser': ('affiks',),
'affikset': ('affiks',),
'affinitet': ('affinitet',),
'affiniteten': ('affinitet',),
'affinitetene': ('affinitet',),
'affiniteter': ('affinitet',),
'affrikat': ('affrikat',),
'affrikaten': ('affrikat',),
'affrikatene': ('affrikat',),
'affrikater': ('affrikat',),
'affutasje': ('affutasje',),
'affutasjen': ('affutasje',),
'affutasjene': ('affutasje',),
'affutasjer': ('affutasje',),
'affære': ('affære',),
'affæren': ('affære',),
'affærene': ('affære',),
'affærer': ('affære',),
'afghaner': ('afghaner',),
'afghanere': ('afghaner',),
'afghaneren': ('afghaner',),
'afghanerer': ('afghaner',),
'afghanerne': ('afghaner',),
'afghani': ('afghani',),
'afghanien': ('afghani',),
'afghaniene': ('afghani',),
'aforisme': ('aforisme',),
'aforismen': ('aforisme',),
'aforismene': ('aforisme',),
'aforismer': ('aforisme',),
'afrikaans': ('afrikaans',),
'afrikander': ('afrikander',),
'afrikandere': ('afrikander',),
'afrikanderen': ('afrikander',),
'afrikanderer': ('afrikander',),
'afrikanderne': ('afrikander',),
'afrikaner': ('afrikaner',),
'afrikanere': ('afrikaner',),
'afrikaneren': ('afrikaner',),
'afrikanerer': ('afrikaner',),
'afrikanerne': ('afrikaner',),
'afroamerikaner': ('afroamerikaner',),
'afroamerikanere': ('afroamerikaner',),
'afroamerikaneren': ('afroamerikaner',),
'afroamerikanerer': ('afroamerikaner',),
'afroamerikanerne': ('afroamerikaner',),
'afrodisi': ('afrodisi',),
'afrodisien': ('afrodisi',),
'afrodisiene': ('afrodisi',),
'afrodisier': ('afrodisi',),
'afroditt': ('afroditt',),
'afroditten': ('afroditt',),
'afrodittene': ('afroditt',),
'afroditter': ('afroditt',),
'afrofrisyre': ('afrofrisyre',),
'afrofrisyren': ('afrofrisyre',),
'afrofrisyrene': ('afrofrisyre',),
'afrofrisyrer': ('afrofrisyre',),
'aften': ('aften',),
'aftenen': ('aften',),
'aftenene': ('aften',),
'aftener': ('aften',),
'aftenantrekk': ('aftenantrekk',),
'aftenantrekka': ('aftenantrekk',),
'aftenantrekkene': ('aftenantrekk',),
'aftenantrekket': ('aftenantrekk',),
'aftenavis': ('aftenavis',),
'aftenavisa': ('aftenavis',),
'aftenavisen': ('aftenavis',),
'aftenavisene': ('aftenavis',),
'aftenaviser': ('aftenavis',),
'aftenbruk': ('aftenbruk',),
'aftenbruka': ('aftenbruk',),
'aftenbruken': ('aftenbruk',),
'aftenbrukene': ('aftenbruk',),
'aftenbruker': ('aftenbruk',),
'aftenbruket': ('aftenbruk',),
'aftenbønn': ('aftenbønn',),
'aftenbønna': ('aftenbønn',),
'aftenbønnen': ('aftenbønn',),
'aftenbønnene': ('aftenbønn',),
'aftenbønner': ('aftenbønn',),
'aftennummer': ('aftennummer',),
'aftennummeret': ('aftennummer',),
'aftennumra': ('aftennummer',),
'aftennumre': ('aftennummer',),
'aftennumrene': ('aftennummer',),
'aftenrøde': ('aftenrøde',),
'aftenrøden': ('aftenrøde',),
'aftenrødene': ('aftenrøde',),
'aftenrøder': ('aftenrøde',),
'aftens': ('aftens',),
'aftensang': ('aftensang',),
'aftensangen': ('aftensang',),
'aftensangene': ('aftensang',),
'aftensanger': ('aftensang',),
'aftensbord': ('aftensbord',),
'aftensborda': ('aftensbord',),
'aftensbordene': ('aftensbord',),
'aftensborder': ('aftensbord',),
'aftensbordet': ('aftensbord',),
'aftenskumring': ('aftenskumring',),
'aftenskumringa': ('aftenskumring',),
'aftenskumringen': ('aftenskumring',),
'aftenskumringene': ('aftenskumring',),
'aftenskumringer': ('aftenskumring',),
'aftensmat': ('aftensmat',),
'aftensmaten': ('aftensmat',),
'aftensmatene': ('aftensmat',),
'aftensmater': ('aftensmat',),
'aftenstemning': ('aftenstemning',),
'aftenstemninga': ('aftenstemning',),
'aftenstemningen': ('aftenstemning',),
'aftenstemningene': ('aftenstemning',),
'aftenstemninger': ('aftenstemning',),
'aftenstjerna': ('aftenstjerne',),
'aftenstjerne': ('aftenstjerne',),
'aftenstjernen': ('aftenstjerne',),
'aftenstjernene': ('aftenstjerne',),
'aftenstjerner': ('aftenstjerne',),
'aftentrekning': ('aftentrekning',),
'aftentrekninga': ('aftentrekning',),
'aftentrekningen': ('aftentrekning',),
'aftentrekningene': ('aftentrekning',),
'aftentrekninger': ('aftentrekning',),
'aftentur': ('aftentur',),
'aftenturen': ('aftentur',),
'aftenturene': ('aftentur',),
'aftenturer': ('aftentur',),
'agape': ('agape',),
'agapen': ('agape',),
'agapene': ('agape',),
'agaper': ('agape',),
'agat': ('agat',),
'agaten': ('agat',),
'agatene': ('agat',),
'agater': ('agat',),
'agatring': ('agatring',),
'agatringen': ('agatring',),
'agatringene': ('agatring',),
'agatringer': ('agatring',),
'agatstein': ('agatstein',),
'agatsteinen': ('agatstein',),
'agatsteinene': ('agatstein',),
'agatsteiner': ('agatstein',),
'age': ('age',),
'agen': ('age',),
'agene': ('age',),
'ager': ('age',),
'agenda': ('agenda',),
'agendaen': ('agenda',),
'agendaene': ('agenda',),
'agendaer': ('agenda',),
'agende': ('agende',),
'agenden': ('agende',),
'agendene': ('agende',),
'agender': ('agende',),
'agens': ('agens',),
'agensa': ('agens',),
'agensen': ('agens',),
'agensene': ('agens',),
'agenser': ('agens',),
'agenset': ('agens',),
'agensledd': ('agensledd',),
'agensledda': ('agensledd',),
'agensleddene': ('agensledd',),
'agensleddet': ('agensledd',),
'agent': ('agent',),
'agenten': ('agent',),
'agentene': ('agent',),
'agenter': ('agent',),
'agentfilm': ('agentfilm',),
'agentfilmen': ('agentfilm',),
'agentfilmene': ('agentfilm',),
'agentfilmer': ('agentfilm',),
'agentprovisjon': ('agentprovisjon',),
'agentprovisjonen': ('agentprovisjon',),
'agentprovisjonene': ('agentprovisjon',),
'agentprovisjoner': ('agentprovisjon',),
'agentroman': ('agentroman',),
'agentromanen': ('agentroman',),
'agentromanene': ('agentroman',),
'agentromaner': ('agentroman',),
'agentur': ('agentur',),
'agentura': ('agentur',),
'agenturene': ('agentur',),
'agenturer': ('agentur',),
'agenturet': ('agentur',),
'agenturfirma': ('agenturfirma',),
'agenturfirmaene': ('agenturfirma',),
'agenturfirmaer': ('agenturfirma',),
'agenturfirmaet': ('agenturfirma',),
'agenturforretning': ('agenturforretning',),
'agenturforretninga': ('agenturforretning',),
'agenturforretningen': ('agenturforretning',),
'agenturforretningene': ('agenturforretning',),
'agenturforretninger': ('agenturforretning',),
'agg': ('agg',),
'agga': ('agg',),
'aggene': ('agg',),
'agget': ('agg',),
'agglutinasjon': ('agglutinasjon',),
'agglutinasjonen': ('agglutinasjon',),
'agglutinasjonene': ('agglutinasjon',),
'agglutinasjoner': ('agglutinasjon',),
'agglutinering': ('agglutinering',),
'agglutineringa': ('agglutinering',),
'agglutineringen': ('agglutinering',),
'agglutineringene': ('agglutinering',),
'agglutineringer': ('agglutinering',),
'aggregat': ('aggregat',),
'aggregata': ('aggregat',),
'aggregatene': ('aggregat',),
'aggregater': ('aggregat',),
'aggregatet': ('aggregat',),
'aggregatform': ('aggregatform',),
'aggregatforma': ('aggregatform',),
'aggregatformen': ('aggregatform',),
'aggregatformene': ('aggregatform',),
'aggregatformer': ('aggregatform',),
'aggregattilstand': ('aggregattilstand',),
'aggregattilstanden': ('aggregattilstand',),
'aggregattilstandene': ('aggregattilstand',),
'aggregattilstander': ('aggregattilstand',),
'aggresjon': ('aggresjon',),
'aggresjonen': ('aggresjon',),
'aggresjonene': ('aggresjon',),
'aggresjoner': ('aggresjon',),
'aggressivitet': ('aggressivitet',),
'aggressiviteten': ('aggressivitet',),
'aggressivitetene': ('aggressivitet',),
'aggressiviteter': ('aggressivitet',),
'agio': ('agio',),
'agioen': ('agio',),
'agioene': ('agio',),
'agioer': ('agio',),
'agiotap': ('agiotap',),
'agiotapa': ('agiotap',),
'agiotapene': ('agiotap',),
'agiotapet': ('agiotap',),
'agiovinning': ('agiovinning',),
'agiovinninga': ('agiovinning',),
'agiovinningen': ('agiovinning',),
'agiovinningene': ('agiovinning',),
'agiovinninger': ('agiovinning',),
'agitasjon': ('agitasjon',),
'agitasjonen': ('agitasjon',),
'agitasjonene': ('agitasjon',),
'agitasjoner': ('agitasjon',),
'agitator': ('agitator',),
'agitatoren': ('agitator',),
'agitatorene': ('agitator',),
'agitatorer': ('agitator',),
'agn': ('agn',),
'agna': ('agn',),
'agnene': ('agn',),
'agnet': ('agn',),
'agn': ('agn',),
'agna': ('agn',),
'agnen': ('agn',),
'agnene': ('agn',),
'agner': ('agn',),
'agnat': ('agnat',),
'agnaten': ('agnat',),
'agnatene': ('agnat',),
'agnater': ('agnat',),
'agnfisk': ('agnfisk',),
'agnfisken': ('agnfisk',),
'agnfiskene': ('agnfisk',),
'agnfisker': ('agnfisk',),
'agnmakk': ('agnmakk',),
'agnmakken': ('agnmakk',),
'agnmakkene': ('agnmakk',),
'agnmakker': ('agnmakk',),
'agnmark': ('agnmark',),
'agnmarken': ('agnmark',),
'agnmarkene': ('agnmark',),
'agnmarker': ('agnmark',),
'agnor': ('agnor',),
'agnora': ('agnor',),
'agnoren': ('agnor',),
'agnorene': ('agnor',),
'agnorer': ('agnor',),
'agnostiker': ('agnostiker',),
'agnostikere': ('agnostiker',),
'agnostikeren': ('agnostiker',),
'agnostikerer': ('agnostiker',),
'agnostikerne': ('agnostiker',),
'agnostisisme': ('agnostisisme',),
'agnostisismen': ('agnostisisme',),
'agnostisismene': ('agnostisisme',),
'agnostisismer': ('agnostisisme',),
'agnsild': ('agnsild',),
'agnsilda': ('agnsild',),
'agnsilden': ('agnsild',),
'agnsildene': ('agnsild',),
'agnsilder': ('agnsild',),
'agnus Dei': ('agnus Dei',),
'agoni': ('agoni',),
'agonien': ('agoni',),
'agoniene': ('agoni',),
'agonier': ('agoni',),
'agorafobi': ('agorafobi',),
'agorafobien': ('agorafobi',),
'agorafobiene': ('agorafobi',),
'agorafobier': ('agorafobi',),
'agraff': ('agraff',),
'agraffen': ('agraff',),
'agraffene': ('agraff',),
'agraffer': ('agraff',),
'agrafi': ('agrafi',),
'agrafien': ('agrafi',),
'agrafiene': ('agrafi',),
'agrafier': ('agrafi',),
'agrar': ('agrar',),
'agraren': ('agrar',),
'agrarene': ('agrar',),
'agrarer': ('agrar',),
'agrarparti': ('agrarparti',),
'agrarpartia': ('agrarparti',),
'agrarpartiene': ('agrarparti',),
'agrarpartier': ('agrarparti',),
'agrarpartiet': ('agrarparti',),
'agrarpolitikk': ('agrarpolitikk',),
'agrarpolitikken': ('agrarpolitikk',),
'agrarpolitikkene': ('agrarpolitikk',),
'agrarpolitikker': ('agrarpolitikk',),
'agreement': ('agreement',),
'agrement': ('agrement',),
'agrementa': ('agrement',),
'agrementene': ('agrement',),
'agrementer': ('agrement',),
'agrementet': ('agrement',),
'agrikultur': ('agrikultur',),
'agrikulturen': ('agrikultur',),
'agrikulturene': ('agrikultur',),
'agrikulturer': ('agrikultur',),
'agronom': ('agronom',),
'agronomen': ('agronom',),
'agronomene': ('agronom',),
'agronomer': ('agronom',),
'agronomi': ('agronomi',),
'agronomien': ('agronomi',),
'agronomiene': ('agronomi',),
'agronomier': ('agronomi',),
'agrotekniker': ('agrotekniker',),
'agroteknikere': ('agrotekniker',),
'agroteknikeren': ('agrotekniker',),
'agroteknikerer': ('agrotekniker',),
'agroteknikerne': ('agrotekniker',),
'agurk': ('agurk',),
'agurken': ('agurk',),
'agurkene': ('agurk',),
'agurker': ('agurk',),
'agurksalat': ('agurksalat',),
'agurksalaten': ('agurksalat',),
'agurksalatene': ('agurksalat',),
'agurksalater': ('agurksalat',),
'agurktid': ('agurktid',),
'agurktida': ('agurktid',),
'agurktiden': ('agurktid',),
'agurktidene': ('agurktid',),
'agurktider': ('agurktid',),
'aha-opplevelse': ('aha-opplevelse',),
'aha-opplevelsen': ('aha-opplevelse',),
'aha-opplevelsene': ('aha-opplevelse',),
'aha-opplevelser': ('aha-opplevelse',),
'aids': ('aids',),
'aidsen': ('aids',),
'aidsene': ('aids',),
'aidser': ('aids',),
'aidssmitte': ('aidssmitte',),
'aidssmitten': ('aidssmitte',),
'aidssmittene': ('aidssmitte',),
'aidssmitter': ('aidssmitte',),
'aigu': ('aigu',),
'aiguen': ('aigu',),
'aiguene': ('aigu',),
'aiguer': ('aigu',),
'aino': ('aino',),
'ainoen': ('aino',),
'ainoene': ('aino',),
'ainoer': ('aino',),
'aino': ('aino',),
'air': ('air',),
'airen': ('air',),
'airene': ('air',),
'airer': ('air',),
'air-condition': ('air-condition',),
'air-conditionen': ('air-condition',),
'air-conditionene': ('air-condition',),
'air-conditioner': ('air-condition',),
'airbag': ('airbag',),
'airbagen': ('airbag',),
'airbagene': ('airbag',),
'airbager': ('airbag',),
'aiss': ('aiss',),
'aissen': ('aiss',),
'aissene': ('aiss',),
'aisser': ('aiss',),
'akademi': ('akademi',),
'akademia': ('akademi',),
'akademiene': ('akademi',),
'akademier': ('akademi',),
'akademiet': ('akademi',),
'akademiker': ('akademiker',),
'akademikere': ('akademiker',),
'akademikeren': ('akademiker',),
'akademikerer': ('akademiker',),
'akademikerne': ('akademiker',),
'akademisme': ('akademisme',),
'akademismen': ('akademisme',),
'akademismene': ('akademisme',),
'akademismer': ('akademisme',),
'akantus': ('akantus',),
'akantusen': ('akantus',),
'akantusene': ('akantus',),
'akantuser': ('akantus',),
'akantusblad': ('akantusblad',),
'akantusblada': ('akantusblad',),
'akantusbladene': ('akantusblad',),
'akantusblader': ('akantusblad',),
'akantusbladet': ('akantusblad',),
'akantusornament': ('akantusornament',),
'akantusornamenta': ('akantusornament',),
'akantusornamentene': ('akantusornament',),
'akantusornamenter': ('akantusornament',),
'akantusornamentet': ('akantusornament',),
'akantusplanta': ('akantusplante',),
'akantusplante': ('akantusplante',),
'akantusplanten': ('akantusplante',),
'akantusplantene': ('akantusplante',),
'akantusplanter': ('akantusplante',),
'akantusranke': ('akantusranke',),
'akantusranken': ('akantusranke',),
'akantusrankene': ('akantusranke',),
'akantusranker': ('akantusranke',),
'akasie': ('akasie',),
'akasien': ('akasie',),
'akasiene': ('akasie',),
'akasier': ('akasie',),
'akebakke': ('akebakke',),
'akebakken': ('akebakke',),
'akebakkene': ('akebakke',),
'akebakker': ('akebakke',),
'akebrett': ('akebrett',),
'akebretta': ('akebrett',),
'akebrettene': ('akebrett',),
'akebretter': ('akebrett',),
'akebrettet': ('akebrett',),
'akeføra': ('akeføre',),
'akeføre': ('akeføre',),
'akeførene': ('akeføre',),
'akefører': ('akeføre',),
'akeføret': ('akeføre',),
'akekonkurranse': ('akekonkurranse',),
'akekonkurransen': ('akekonkurranse',),
'akekonkurransene': ('akekonkurranse',),
'akekonkurranser': ('akekonkurranse',),
'akeleia': ('akeleie',),
'akeleie': ('akeleie',),
'akeleien': ('akeleie',),
'akeleiene': ('akeleie',),
'akeleier': ('akeleie',),
'aketur': ('aketur',),
'aketuren': ('aketur',),
'aketurene': ('aketur',),
'aketurer': ('aketur',),
'akevitt': ('akevitt',),
'akevitten': ('akevitt',),
'akevittene': ('akevitt',),
'akevitter': ('akevitt',),
'akevitter': ('akevitter',),
'akevittere': ('akevitter',),
'akevitteren': ('akevitter',),
'akevitterer': ('akevitter',),
'akevitterne': ('akevitter',),
'akilleshæl': ('akilleshæl',),
'akilleshælen': ('akilleshæl',),
'akilleshælene': ('akilleshæl',),
'akilleshæler': ('akilleshæl',),
'akillessena': ('akillessene',),
'akillessene': ('akillessene',),
'akillessenen': ('akillessene',),
'akillessenene': ('akillessene',),
'akillessener': ('akillessene',),
'akk': ('akk',),
'akka': ('akk',),
'akkene': ('akk',),
'akket': ('akk',),
'akkar': ('akkar',),
'akkaren': ('akkar',),
'akkarene': ('akkar',),
'akkarer': ('akkar',),
'akkedas': ('akkedas',),
'akkedasen': ('akkedas',),
'akkedasene': ('akkedas',),
'akkedaser': ('akkedas',),
'akkedering': ('akkedering',),
'akkederinga': ('akkedering',),
'akkederingen': ('akkedering',),
'akkederingene': ('akkedering',),
'akkederinger': ('akkedering',),
'akklamasjon': ('akklamasjon',),
'akklamasjonen': ('akklamasjon',),
'akklamasjonene': ('akklamasjon',),
'akklamasjoner': ('akklamasjon',),
'akkommodasjon': ('akkommodasjon',),
'akkommodasjonen': ('akkommodasjon',),
'akkommodasjonene': ('akkommodasjon',),
'akkommodasjoner': ('akkommodasjon',),
'akkompagnatør': ('akkompagnatør',),
'akkompagnatøren': ('akkompagnatør',),
'akkompagnatørene': ('akkompagnatør',),
'akkompagnatører': ('akkompagnatør',),
'akkompagnement': ('akkompagnement',),
'akkompagnementa': ('akkompagnement',),
'akkompagnementene': ('akkompagnement',),
'akkompagnementer': ('akkompagnement',),
'akkompagnementet': ('akkompagnement',),
'akkord': ('akkord',),
'akkorden': ('akkord',),
'akkordene': ('akkord',),
'akkorder': ('akkord',),
'akkordant': ('akkordant',),
'akkordanten': ('akkordant',),
'akkordantene': ('akkordant',),
'akkordanter': ('akkordant',),
'akkordarbeid': ('akkordarbeid',),
'akkordarbeida': ('akkordarbeid',),
'akkordarbeidene': ('akkordarbeid',),
'akkordarbeider': ('akkordarbeid',),
'akkordarbeidet': ('akkordarbeid',),
'akkordbetaling': ('akkordbetaling',),
'akkordbetalinga': ('akkordbetaling',),
'akkordbetalingen': ('akkordbetaling',),
'akkordbetalingene': ('akkordbetaling',),
'akkordbetalinger': ('akkordbetaling',),
'akkordbo': ('akkordbo',),
'akkordboa': ('akkordbo',),
'akkordboene': ('akkordbo',),
'akkordboet': ('akkordbo',),
'akkordbu': ('akkordbu',),
'akkordbua': ('akkordbu',),
'akkordbuene': ('akkordbu',),
'akkordbuet': ('akkordbu',),
'akkordforhandling': ('akkordforhandling',),
'akkordforhandlinga': ('akkordforhandling',),
'akkordforhandlingen': ('akkordforhandling',),
'akkordforhandlingene': ('akkordforhandling',),
'akkordforhandlinger': ('akkordforhandling',),
'akkordlønn': ('akkordlønn',),
'akkordlønna': ('akkordlønn',),
'akkordlønnen': ('akkordlønn',),
'akkordlønnene': ('akkordlønn',),
'akkordlønner': ('akkordlønn',),
'akkordstyra': ('akkordstyre',),
'akkordstyre': ('akkordstyre',),
'akkordstyrene': ('akkordstyre',),
'akkordstyrer': ('akkordstyre',),
'akkordstyret': ('akkordstyre',),
'akkordstyrer': ('akkordstyrer',),
'akkordstyrere': ('akkordstyrer',),
'akkordstyreren': ('akkordstyrer',),
'akkordstyrerer': ('akkordstyrer',),
'akkordstyrerne': ('akkordstyrer',),
'akkordtariff': ('akkordtariff',),
'akkordtariffen': ('akkordtariff',),
'akkordtariffene': ('akkordtariff',),
'akkordtariffer': ('akkordtariff',),
'akkrediteringsbrev': ('akkrediteringsbrev',),
'akkrediteringsbreva': ('akkrediteringsbrev',),
'akkrediteringsbrevene': ('akkrediteringsbrev',),
'akkrediteringsbrever': ('akkrediteringsbrev',),
'akkrediteringsbrevet': ('akkrediteringsbrev',),
'akkreditiv': ('akkreditiv',),
'akkreditiva': ('akkreditiv',),
'akkreditivene': ('akkreditiv',),
'akkreditiver': ('akkreditiv',),
'akkreditivet': ('akkreditiv',),
'akkumulasjon': ('akkumulasjon',),
'akkumulasjonen': ('akkumulasjon',),
'akkumulasjonene': ('akkumulasjon',),
'akkumulasjoner': ('akkumulasjon',),
'akkumulator': ('akkumulator',),
'akkumulatoren': ('akkumulator',),
'akkumulatorene': ('akkumulator',),
'akkumulatorer': ('akkumulator',),
'akkumulatorbatteri': ('akkumulatorbatteri',),
'akkumulatorbatteria': ('akkumulatorbatteri',),
'akkumulatorbatteriene': ('akkumulatorbatteri',),
'akkumulatorbatterier': ('akkumulatorbatteri',),
'akkumulatorbatteriet': ('akkumulatorbatteri',),
'akkumulatorcella': ('akkumulatorcelle',),
'akkumulatorcelle': ('akkumulatorcelle',),
'akkumulatorcellen': ('akkumulatorcelle',),
'akkumulatorcellene': ('akkumulatorcelle',),
'akkumulatorceller': ('akkumulatorcelle',),
'akkuratesse': ('akkuratesse',),
'akkuratessen': ('akkuratesse',),
'akkuratessene': ('akkuratesse',),
'akkuratesser': ('akkuratesse',),
'akkusativ': ('akkusativ',),
'akkusativen': ('akkusativ',),
'akkusativene': ('akkusativ',),
'akkusativer': ('akkusativ',),
'akkvisisjon': ('akkvisisjon',),
'akkvisisjonen': ('akkvisisjon',),
'akkvisisjonene': ('akkvisisjon',),
'akkvisisjoner': ('akkvisisjon',),
'akkvisitør': ('akkvisitør',),
'akkvisitøren': ('akkvisitør',),
'akkvisitørene': ('akkvisitør',),
'akkvisitører': ('akkvisitør',),
'akne': ('akne',),
'aknen': ('akne',),
'aknene': ('akne',),
'akner': ('akne',),
'akrobat': ('akrobat',),
'akrobaten': ('akrobat',),
'akrobatene': ('akrobat',),
'akrobater': ('akrobat',),
'akrobatikk': ('akrobatikk',),
'akrobatikken': ('akrobatikk',),
'akrobatikkene': ('akrobatikk',),
'akrobatikker': ('akrobatikk',),
'akrobatkunst': ('akrobatkunst',),
'akrobatkunsten': ('akrobatkunst',),
'akrobatkunstene': ('akrobatkunst',),
'akrobatkunster': ('akrobatkunst',),
'akrofobi': ('akrofobi',),
'akrofobien': ('akrofobi',),
'akrofobiene': ('akrofobi',),
'akrofobier': ('akrofobi',),
'akromegali': ('akromegali',),
'akromegalien': ('akromegali',),
'akromegaliene': ('akromegali',),
'akromegalier': ('akromegali',),
'akronym': ('akronym',),
'akronyma': ('akronym',),
'akronymene': ('akronym',),
'akronymer': ('akronym',),
'akronymet': ('akronym',),
'akrostika': ('akrostikon',),
'akrostikaene': ('akrostikon',),
'akrostikon': ('akrostikon',),
'akrostikonet': ('akrostikon',),
'akryl': ('akryl',),
'akryla': ('akryl',),
'akrylen': ('akryl',),
'akrylene': ('akryl',),
'akryler': ('akryl',),
'akrylet': ('akryl',),
'akrylfiber': ('akrylfiber',),
'akrylfibere': ('akrylfiber',),
'akrylfiberen': ('akrylfiber',),
'akrylfiberer': ('akrylfiber',),
'akrylfiberne': ('akrylfiber',),
'akrylfibre': ('akrylfiber',),
'akrylfibrene': ('akrylfiber',),
'akrylfibrer': ('akrylfiber',),
'akrylsyra': ('akrylsyre',),
'akrylsyre': ('akrylsyre',),
'akrylsyren': ('akrylsyre',),
'akrylsyrene': ('akrylsyre',),
'akrylsyrer': ('akrylsyre',),
'aks': ('aks',),
'aksa': ('aks',),
'aksene': ('aks',),
'akset': ('aks',),
'aksdannelse': ('aksdannelse',),
'aksdannelsen': ('aksdannelse',),
'aksdannelsene': ('aksdannelse',),
'aksdannelser': ('aksdannelse',),
'aksdanning': ('aksdanning',),
'aksdanninga': ('aksdanning',),
'aksdanningen': ('aksdanning',),
'aksdanningene': ('aksdanning',),
'aksdanninger': ('aksdanning',),
'akse': ('akse',),
'aksen': ('akse',),
'aksene': ('akse',),
'akser': ('akse',),
'aksel': ('aksel',),
'akselen': ('aksel',),
'akslene': ('aksel',),
'aksler': ('aksel',),
'aksel': ('aksel',),
'akselen': ('aksel',),
'aksla': ('aksel',),
'akslene': ('aksel',),
'aksler': ('aksel',),
'akselbein': ('akselbein',),
'akselbeina': ('akselbein',),
'akselbeinene': ('akselbein',),
'akselbeinet': ('akselbein',),
'akselben': ('akselben',),
'akselbena': ('akselben',),
'akselbenene': ('akselben',),
'akselbenet': ('akselben',),
'akselblad': ('akselblad',),
'akselblada': ('akselblad',),
'akselbladene': ('akselblad',),
'akselblader': ('akselblad',),
'akselbladet': ('akselblad',),
'akselerasjon': ('akselerasjon',),
'akselerasjonen': ('akselerasjon',),
'akselerasjonene': ('akselerasjon',),
'akselerasjoner': ('akselerasjon',),
'akselerasjonsevna': ('akselerasjonsevne',),
'akselerasjonsevne': ('akselerasjonsevne',),
'akselerasjonsevnen': ('akselerasjonsevne',),
'akselerasjonsevnene': ('akselerasjonsevne',),
'akselerasjonsevner': ('akselerasjonsevne',),
'akselerasjonsfelt': ('akselerasjonsfelt',),
'akselerasjonsfelta': ('akselerasjonsfelt',),
'akselerasjonsfeltene': ('akselerasjonsfelt',),
'akselerasjonsfelter': ('akselerasjonsfelt',),
'akselerasjonsfeltet': ('akselerasjonsfelt',),
'akselerator': ('akselerator',),
'akseleratoren': ('akselerator',),
'akseleratorene': ('akselerator',),
'akseleratorer': ('akselerator',),
'akselknopp': ('akselknopp',),
'akselknoppen': ('akselknopp',),
'akselknoppene': ('akselknopp',),
'akselknopper': ('akselknopp',),
'akselknupp': ('akselknupp',),
'akselknuppen': ('akselknupp',),
'akselknuppene': ('akselknupp',),
'akselknupper': ('akselknupp',),
'akselkobling': ('akselkobling',),
'akselkoblinga': ('akselkobling',),
'akselkoblingen': ('akselkobling',),
'akselkoblingene': ('akselkobling',),
'akselkoblinger': ('akselkobling',),
'akselkopling': ('akselkopling',),
'akselkoplinga': ('akselkopling',),
'akselkoplingen': ('akselkopling',),
'akselkoplingene': ('akselkopling',),
'akselkoplinger': ('akselkopling',),
'akselledning': ('akselledning',),
'akselledninga': ('akselledning',),
'akselledningen': ('akselledning',),
'akselledningene': ('akselledning',),
'akselledninger': ('akselledning',),
'akseltrykk': ('akseltrykk',),
'akseltrykka': ('akseltrykk',),
'akseltrykkene': ('akseltrykk',),
'akseltrykket': ('akseltrykk',),
'aksemakt': ('aksemakt',),
'aksemakta': ('aksemakt',),
'aksemakten': ('aksemakt',),
'aksemaktene': ('aksemakt',),
'aksemakter': ('aksemakt',),
'aksent': ('aksent',),
'aksenten': ('aksent',),
'aksentene': ('aksent',),
'aksenter': ('aksent',),
'aksenttegn': ('aksenttegn',),
'aksenttegna': ('aksenttegn',),
'aksenttegnene': ('aksenttegn',),
'aksenttegnet': ('aksenttegn',),
'aksentuasjon': ('aksentuasjon',),
'aksentuasjonen': ('aksentuasjon',),
'aksentuasjonene': ('aksentuasjon',),
'aksentuasjoner': ('aksentuasjon',),
'aksentuering': ('aksentuering',),
'aksentueringa': ('aksentuering',),
'aksentueringen': ('aksentuering',),
'aksentueringene': ('aksentuering',),
'aksentueringer': ('aksentuering',),
'aksept': ('aksept',),
'aksepten': ('aksept',),
'akseptene': ('aksept',),
'aksepter': ('aksept',),
'akseptant': ('akseptant',),
'akseptanten': ('akseptant',),
'akseptantene': ('akseptant',),
'akseptanter': ('akseptant',),
'aksesjon': ('aksesjon',),
'aksesjonen': ('aksesjon',),
'aksesjonene': ('aksesjon',),
'aksesjoner': ('aksesjon',),
'aksesjonskatalog': ('aksesjonskatalog',),
'aksesjonskatalogen': ('aksesjonskatalog',),
'aksesjonskatalogene': ('aksesjonskatalog',),
'aksesjonskataloger': ('aksesjonskatalog',),
'aksess': ('aksess',),
'aksessen': ('aksess',),
'aksessene': ('aksess',),
'aksesser': ('aksess',),
'aksessoria': ('aksessorium',),
'aksessoriene': ('aksessorium',),
'aksessorier': ('aksessorium',),
'aksessoriet': ('aksessorium',),
'aksessorium': ('aksessorium',),
'aksesstid': ('aksesstid',),
'aksesstida': ('aksesstid',),
'aksesstiden': ('aksesstid',),
'aksesstidene': ('aksesstid',),
'aksesstider': ('aksesstid',),
'aksialfjær': ('aksialfjær',),
'aksialfjæra': ('aksialfjær',),
'aksialfjæren': ('aksialfjær',),
'aksialfjærene': ('aksialfjær',),
'aksialfjærer': ('aksialfjær',),
'aksialfjør': ('aksialfjør',),
'aksialfjøra': ('aksialfjør',),
'aksialfjøren': ('aksialfjør',),
'aksialfjørene': ('aksialfjør',),
'aksialfjører': ('aksialfjør',),
'aksialkraft': ('aksialkraft',),
'aksialkrafta': ('aksialkraft',),
'aksialkraften': ('aksialkraft',),
'aksialkreftene': ('aksialkraft',),
'aksialkrefter': ('aksialkraft',),
'aksiallager': ('aksiallager',),
'aksiallageret': ('aksiallager',),
'aksiallagra': ('aksiallager',),
'aksiallagre': ('aksiallager',),
'aksiallagrene': ('aksiallager',),
'aksidens': ('aksidens',),
'aksidensen': ('aksidens',),
'aksidensene': ('aksidens',),
'aksidenser': ('aksidens',),
'aksidensarbeid': ('aksidensarbeid',),
'aksidensarbeida': ('aksidensarbeid',),
'aksidensarbeidene': ('aksidensarbeid',),
'aksidensarbeider': ('aksidensarbeid',),
'aksidensarbeidet': ('aksidensarbeid',),
'aksidenstrykkeri': ('aksidenstrykkeri',),
'aksidenstrykkeria': ('aksidenstrykkeri',),
'aksidenstrykkeriene': ('aksidenstrykkeri',),
'aksidenstrykkerier': ('aksidenstrykkeri',),
'aksidenstrykkeriet': ('aksidenstrykkeri',),
'aksiom': ('aksiom',),
'aksioma': ('aksiom',),
'aksiomene': ('aksiom',),
'aksiomer': ('aksiom',),
'aksiomet': ('aksiom',),
'aksje': ('aksje',),
'aksjen': ('aksje',),
'aksjene': ('aksje',),
'aksjer': ('aksje',),
'aksjeandel': ('aksjeandel',),
'aksjeandelen': ('aksjeandel',),
'aksjeandelene': ('aksjeandel',),
'aksjeandeler': ('aksjeandel',),
'aksjebrev': ('aksjebrev',),
'aksjebreva': ('aksjebrev',),
'aksjebrevene': ('aksjebrev',),
'aksjebrever': ('aksjebrev',),
'aksjebrevet': ('aksjebrev',),
'aksjeeier': ('aksjeeier',),
'aksjeeiere': ('aksjeeier',),
'aksjeeieren': ('aksjeeier',),
'aksjeeierer': ('aksjeeier',),
'aksjeeierne': ('aksjeeier',),
'aksjefond': ('aksjefond',),
'aksjefonda': ('aksjefond',),
'aksjefondene': ('aksjefond',),
'aksjefondet': ('aksjefond',),
'aksjekapital': ('aksjekapital',),
'aksjekapitalen': ('aksjekapital',),
'aksjekapitalene': ('aksjekapital',),
'aksjekapitaler': ('aksjekapital',),
'aksjeleilighet': ('aksjeleilighet',),
'aksjeleiligheta': ('aksjeleilighet',),
'aksjeleiligheten': ('aksjeleilighet',),
'aksjeleilighetene': ('aksjeleilighet',),
'aksjeleiligheter': ('aksjeleilighet',),
'aksjemajoritet': ('aksjemajoritet',),
'aksjemajoriteten': ('aksjemajoritet',),
'aksjemajoritetene': ('aksjemajoritet',),
'aksjemajoriteter': ('aksjemajoritet',),
'aksjemarked': ('aksjemarked',),
'aksjemarkeda': ('aksjemarked',),
'aksjemarkedene': ('aksjemarked',),
'aksjemarkeder': ('aksjemarked',),
'aksjemarkedet': ('aksjemarked',),
'aksjemarknad': ('aksjemarknad',),
'aksjemarknaden': ('aksjemarknad',),
'aksjemarknadene': ('aksjemarknad',),
'aksjemarknader': ('aksjemarknad',),
'aksjemegler': ('aksjemegler',),
'aksjemeglere': ('aksjemegler',),
'aksjemegleren': ('aksjemegler',),
'aksjemeglerer': ('aksjemegler',),
'aksjemeglerne': ('aksjemegler',),
'aksjemekler': ('aksjemekler',),
'aksjemeklere': ('aksjemekler',),
'aksjemekleren': ('aksjemekler',),
'aksjemeklerer': ('aksjemekler',),
'aksjemeklerne': ('aksjemekler',),
'aksjenotering': ('aksjenotering',),
'aksjenoteringa': ('aksjenotering',),
'aksjenoteringen': ('aksjenotering',),
'aksjenoteringene': ('aksjenotering',),
'aksjenoteringer': ('aksjenotering',),
'aksjeselskap': ('aksjeselskap',),
'aksjeselskapa': ('aksjeselskap',),
'aksjeselskapene': ('aksjeselskap',),
'aksjeselskaper': ('aksjeselskap',),
'aksjeselskapet': ('aksjeselskap',),
'aksjesum': ('aksjesum',),
'aksjesummen': ('aksjesum',),
'aksjesummene': ('aksjesum',),
'aksjesummer': ('aksjesum',),
'aksjeutbytta': ('aksjeutbytte',),
'aksjeutbytte': ('aksjeutbytte',),
'aksjeutbyttene': ('aksjeutbytte',),
'aksjeutbytter': ('aksjeutbytte',),
'aksjeutbyttet': ('aksjeutbytte',),
'aksjon': ('aksjon',),
'aksjonen': ('aksjon',),
'aksjonene': ('aksjon',),
'aksjoner': ('aksjon',),
'aksjonist': ('aksjonist',),
'aksjonisten': ('aksjonist',),
'aksjonistene': ('aksjonist',),
'aksjonister': ('aksjonist',),
'aksjonsart': ('aksjonsart',),
'aksjonsarta': ('aksjonsart',),
'aksjonsarten': ('aksjonsart',),
'aksjonsartene': ('aksjonsart',),
'aksjonsarter': ('aksjonsart',),
'aksjonsradien': ('aksjonsradius',),
'aksjonsradiene': ('aksjonsradius',),
'aksjonsradier': ('aksjonsradius',),
'aksjonsradius': ('aksjonsradius',),
'aksjonsradiusen': ('aksjonsradius',),
'aksjonstid': ('aksjonstid',),
'aksjonstida': ('aksjonstid',),
'aksjonstiden': ('aksjonstid',),
'aksjonstidene': ('aksjonstid',),
'aksjonstider': ('aksjonstid',),
'aksjonsutvalg': ('aksjonsutvalg',),
'aksjonsutvalga': ('aksjonsutvalg',),
'aksjonsutvalgene': ('aksjonsutvalg',),
'aksjonsutvalget': ('aksjonsutvalg',),
'aksjonær': ('aksjonær',),
'aksjonæren': ('aksjonær',),
'aksjonærene': ('aksjonær',),
'aksjonærer': ('aksjonær',),
'aksjonærmøta': ('aksjonærmøte',),
'aksjonærmøte': ('aksjonærmøte',),
'aksjonærmøtene': ('aksjonærmøte',),
'aksjonærmøter': ('aksjonærmøte',),
'aksjonærmøtet': ('aksjonærmøte',),
'aksling': ('aksling',),
'akslingen': ('aksling',),
'akslingene': ('aksling',),
'akslinger': ('aksling',),
'akt': ('akt',),
'akta': ('akt',),
'akten': ('akt',),
'aktene': ('akt',),
'akter': ('akt',),
'aktelse': ('aktelse',),
'aktelsen': ('aktelse',),
'aktelsene': ('aktelse',),
'aktelser': ('aktelse',),
'akterdekk': ('akterdekk',),
'akterdekka': ('akterdekk',),
'akterdekkene': ('akterdekk',),
'akterdekket': ('akterdekk',),
'akterende': ('akterende',),
'akterenden': ('akterende',),
'akterendene': ('akterende',),
'akterender': ('akterende',),
'akterkant': ('akterkant',),
'akterkanten': ('akterkant',),
'akterkantene': ('akterkant',),
'akterkanter': ('akterkant',),
'akterlanterna': ('akterlanterne',),
'akterlanterne': ('akterlanterne',),
'akterlanternen': ('akterlanterne',),
'akterlanternene': ('akterlanterne',),
'akterlanterner': ('akterlanterne',),
'akterrom': ('akterrom',),
'akterromma': ('akterrom',),
'akterrommene': ('akterrom',),
'akterrommet': ('akterrom',),
'akterskott': ('akterskott',),
'akterskotten': ('akterskott',),
'akterskottene': ('akterskott',),
'akterskotter': ('akterskott',),
'akterskott': ('akterskott',),
'akterskotta': ('akterskott',),
'akterskottene': ('akterskott',),
'akterskottet': ('akterskott',),
'akterskut': ('akterskut',),
'akterskuten': ('akterskut',),
'akterskutene': ('akterskut',),
'akterskuter': ('akterskut',),
'akterspeil': ('akterspeil',),
'akterspeila': ('akterspeil',),
'akterspeilene': ('akterspeil',),
'akterspeilet': ('akterspeil',),
'akterstamn': ('akterstamn',),
'akterstamnen': ('akterstamn',),
'akterstamnene': ('akterstamn',),
'akterstamner': ('akterstamn',),
'akterstavn': ('akterstavn',),
'akterstavnen': ('akterstavn',),
'akterstavnene': ('akterstavn',),
'akterstavner': ('akterstavn',),
'aktivasida': ('aktivaside',),
'aktivaside': ('aktivaside',),
'aktivasiden': ('aktivaside',),
'aktivasidene': ('aktivaside',),
'aktivasider': ('aktivaside',),
'aktivator': ('aktivator',),
'aktivatoren': ('aktivator',),
'aktivatorene': ('aktivator',),
'aktivatorer': ('aktivator',),
'aktivering': ('aktivering',),
'aktiveringa': ('aktivering',),
'aktiveringen': ('aktivering',),
'aktiveringene': ('aktivering',),
'aktiveringer': ('aktivering',),
'aktiveringsenergi': ('aktiveringsenergi',),
'aktiveringsenergien': ('aktiveringsenergi',),
'aktiveringsenergiene': ('aktiveringsenergi',),
'aktiveringsenergier': ('aktiveringsenergi',),
'aktivisme': ('aktivisme',),
'aktivismen': ('aktivisme',),
'aktivismene': ('aktivisme',),
'aktivismer': ('aktivisme',),
'aktivist': ('aktivist',),
'aktivisten': ('aktivist',),
'aktivistene': ('aktivist',),
'aktivister': ('aktivist',),
'aktivistgruppa': ('aktivistgruppe',),
'aktivistgruppe': ('aktivistgruppe',),
'aktivistgruppen': ('aktivistgruppe',),
'aktivistgruppene': ('aktivistgruppe',),
'aktivistgrupper': ('aktivistgruppe',),
'aktivitet': ('aktivitet',),
'aktiviteten': ('aktivitet',),
'aktivitetene': ('aktivitet',),
'aktiviteter': ('aktivitet',),
'aktivitetsleder': ('aktivitetsleder',),
'aktivitetsledere': ('aktivitetsleder',),
'aktivitetslederen': ('aktivitetsleder',),
'aktivitetslederer': ('aktivitetsleder',),
'aktivitetslederne': ('aktivitetsleder',),
'aktivitetsnivå': ('aktivitetsnivå',),
'aktivitetsnivåa': ('aktivitetsnivå',),
'aktivitetsnivåene': ('aktivitetsnivå',),
'aktivitetsnivåer': ('aktivitetsnivå',),
'aktivitetsnivået': ('aktivitetsnivå',),
'aktivitetsrom': ('aktivitetsrom',),
'aktivitetsromma': ('aktivitetsrom',),
'aktivitetsrommene': ('aktivitetsrom',),
'aktivitetsrommet': ('aktivitetsrom',),
'aktivitør': ('aktivitør',),
'aktivitøren': ('aktivitør',),
'aktivitørene': ('aktivitør',),
'aktivitører': ('aktivitør',),
'aktiva': ('aktivum',),
'aktivaene': ('aktivum',),
'aktiver': ('aktivum',),
'aktivet': ('aktivum',),
'aktivum': ('aktivum',),
'aktivuma': ('aktivum',),
'aktivumene': ('aktivum',),
'aktivumer': ('aktivum',),
'aktivumet': ('aktivum',),
'aktmaling': ('aktmaling',),
'aktmalinga': ('aktmaling',),
'aktmalingen': ('aktmaling',),
'aktmalingene': ('aktmaling',),
'aktmalinger': ('aktmaling',),
'aktmodell': ('aktmodell',),
'aktmodellen': ('aktmodell',),
'aktmodellene': ('aktmodell',),
'aktmodeller': ('aktmodell',),
'aktor': ('aktor',),
'aktoren': ('aktor',),
'aktorene': ('aktor',),
'aktorer': ('aktor',),
'aktorat': ('aktorat',),
'aktorata': ('aktorat',),
'aktoratene': ('aktorat',),
'aktorater': ('aktorat',),
'aktoratet': ('aktorat',),
'aktpågivenhet': ('aktpågivenhet',),
'aktpågivenheta': ('aktpågivenhet',),
'aktpågivenheten': ('aktpågivenhet',),
'aktpågivenhetene': ('aktpågivenhet',),
'aktpågivenheter': ('aktpågivenhet',),
'aktrisa': ('aktrise',),
'aktrise': ('aktrise',),
'aktrisen': ('aktrise',),
'aktrisene': ('aktrise',),
'aktriser': ('aktrise',),
'aktsomhet': ('aktsomhet',),
'aktsomheta': ('aktsomhet',),
'aktsomheten': ('aktsomhet',),
'aktsomhetene': ('aktsomhet',),
'aktsomheter': ('aktsomhet',),
'aktstykka': ('aktstykke',),
'aktstykke': ('aktstykke',),
'aktstykkene': ('aktstykke',),
'aktstykker': ('aktstykke',),
'aktstykket': ('aktstykke',),
'akttegning': ('akttegning',),
'akttegninga': ('akttegning',),
'akttegningen': ('akttegning',),
'akttegningene': ('akttegning',),
'akttegninger': ('akttegning',),
'aktualitet': ('aktualitet',),
'aktualiteten': ('aktualitet',),
'aktualitetene': ('aktualitet',),
'aktualiteter': ('aktualitet',),
'aktuar': ('aktuar',),
'aktuaren': ('aktuar',),
'aktuarene': ('aktuar',),
'aktuarer': ('aktuar',),
'aktuareksamen': ('aktuareksamen',),
'aktuareksamenen': ('aktuareksamen',),
'aktuareksamenene': ('aktuareksamen',),
'aktuareksamener': ('aktuareksamen',),
'aktuarembetseksamen': ('aktuarembetseksamen',),
'aktuarembetseksamenen': ('aktuarembetseksamen',),
'aktuarembetseksamenene': ('aktuarembetseksamen',),
'aktuarembetseksamener': ('aktuarembetseksamen',),
'aktør': ('aktør',),
'aktøren': ('aktør',),
'aktørene': ('aktør',),
'aktører': ('aktør',),
'akupunktur': ('akupunktur',),
'akupunkturen': ('akupunktur',),
'akupunkturene': ('akupunktur',),
'akupunkturer': ('akupunktur',),
'akupunktør': ('akupunktør',),
'akupunktøren': ('akupunktør',),
'akupunktørene': ('akupunktør',),
'akupunktører': ('akupunktør',),
'akustiker': ('akustiker',),
'akustikere': ('akustiker',),
'akustikeren': ('akustiker',),
'akustikerer': ('akustiker',),
'akustikerne': ('akustiker',),
'akustikk': ('akustikk',),
'akustikken': ('akustikk',),
'akustikkene': ('akustikk',),
'akustikker': ('akustikk',),
'akutt': ('akutt',),
'akutten': ('akutt',),
'akuttene': ('akutt',),
'akutter': ('akutt',),
'akutt-tegn': ('akutt-tegn',),
'akutt-tegna': ('akutt-tegn',),
'akutt-tegnene': ('akutt-tegn',),
'akutt-tegnet': ('akutt-tegn',),
'akuttavdeling': ('akuttavdeling',),
'akuttavdelinga': ('akuttavdeling',),
'akuttavdelingen': ('akuttavdeling',),
'akuttavdelingene': ('akuttavdeling',),
'akuttavdelinger': ('akuttavdeling',),
'akuttegn': ('akuttegn',),
'akuttegna': ('akuttegn',),
'akuttegnene': ('akuttegn',),
'akuttegnet': ('akuttegn',),
'akvakultur': ('akvakultur',),
'akvakulturen': ('akvakultur',),
'akvakulturene': ('akvakultur',),
'akvakulturer': ('akvakultur',),
'akvamarin': ('akvamarin',),
'akvamarinen': ('akvamarin',),
'akvamarinene': ('akvamarin',),
'akvamariner': ('akvamarin',),
'akvanaut': ('akvanaut',),
'akvanauten': ('akvanaut',),
'akvanautene': ('akvanaut',),
'akvanauter': ('akvanaut',),
'akvarell': ('akvarell',),
'akvarellen': ('akvarell',),
'akvarellene': ('akvarell',),
'akvareller': ('akvarell',),
'akvarellfarge': ('akvarellfarge',),
'akvarellfargen': ('akvarellfarge',),
'akvarellfargene': ('akvarellfarge',),
'akvarellfarger': ('akvarellfarge',),
'akvarellkunst': ('akvarellkunst',),
'akvarellkunsten': ('akvarellkunst',),
'akvarellkunstene': ('akvarellkunst',),
'akvarellkunster': ('akvarellkunst',),
'akvarellmaler': ('akvarellmaler',),
'akvarellmalere': ('akvarellmaler',),
'akvarellmaleren': ('akvarellmaler',),
'akvarellmalerer': ('akvarellmaler',),
'akvarellmalerne': ('akvarellmaler',),
'akvariebygning': ('akvariebygning',),
'akvariebygninga': ('akvariebygning',),
'akvariebygningen': ('akvariebygning',),
'akvariebygningene': ('akvariebygning',),
'akvariebygninger': ('akvariebygning',),
'akvariefisk': ('akvariefisk',),
'akvariefisken': ('akvariefisk',),
'akvariefiskene': ('akvariefisk',),
'akvariefisker': ('akvariefisk',),
'akvaria': ('akvarium',),
'akvariene': ('akvarium',),
'akvarier': ('akvarium',),
'akvariet': ('akvarium',),
'akvarium': ('akvarium',),
'akvedukt': ('akvedukt',),
'akvedukten': ('akvedukt',),
'akveduktene': ('akvedukt',),
'akvedukter': ('akvedukt',),
'al': ('al',),
'alen': ('al',),
'alene': ('al',),
'aler': ('al',),
'al': ('al',),
'ala': ('al',),
'alene': ('al',),
'alet': ('al',),
'alabast': ('alabast',),
'alabasten': ('alabast',),
'alabastene': ('alabast',),
'alabaster': ('alabast',),
'alabastkrukka': ('alabastkrukke',),
'alabastkrukke': ('alabastkrukke',),
'alabastkrukken': ('alabastkrukke',),
'alabastkrukkene': ('alabastkrukke',),
'alabastkrukker': ('alabastkrukke',),
'alali': ('alali',),
'alalien': ('alali',),
'alaliene': ('alali',),
'alalier': ('alali',),
'alant': ('alant',),
'alanten': ('alant',),
'alantene': ('alant',),
'alanter': ('alant',),
'alantrot': ('alantrot',),
'alantrota': ('alantrot',),
'alantroten': ('alantrot',),
'alantrøttene': ('alantrot',),
'alantrøtter': ('alantrot',),
'alarm': ('alarm',),
'alarmen': ('alarm',),
'alarmene': ('alarm',),
'alarmer': ('alarm',),
'alarmapparat': ('alarmapparat',),
'alarmapparata': ('alarmapparat',),
'alarmapparatene': ('alarmapparat',),
'alarmapparater': ('alarmapparat',),
'alarmapparatet': ('alarmapparat',),
'alarmberedskap': ('alarmberedskap',),
'alarmberedskapa': ('alarmberedskap',),
'alarmberedskapen': ('alarmberedskap',),
'alarmberedskapene': ('alarmberedskap',),
'alarmberedskaper': ('alarmberedskap',),
'alarmberedskapet': ('alarmberedskap',),
'alarmklokka': ('alarmklokke',),
'alarmklokke': ('alarmklokke',),
'alarmklokken': ('alarmklokke',),
'alarmklokkene': ('alarmklokke',),
'alarmklokker': ('alarmklokke',),
'alarmsignal': ('alarmsignal',),
'alarmsignala': ('alarmsignal',),
'alarmsignalene': ('alarmsignal',),
'alarmsignaler': ('alarmsignal',),
'alarmsignalet': ('alarmsignal',),
'alarmsystem': ('alarmsystem',),
'alarmsystema': ('alarmsystem',),
'alarmsystemene': ('alarmsystem',),
'alarmsystemer': ('alarmsystem',),
'alarmsystemet': ('alarmsystem',),
'alarmtilstand': ('alarmtilstand',),
'alarmtilstanden': ('alarmtilstand',),
'alarmtilstandene': ('alarmtilstand',),
'alarmtilstander': ('alarmtilstand',),
'alaskabjørn': ('alaskabjørn',),
'alaskabjørnen': ('alaskabjørn',),
'alaskabjørnene': ('alaskabjørn',),
'alaskabjørner': ('alaskabjørn',),
'alaskasnipa': ('alaskasnipe',),
'alaskasnipe': ('alaskasnipe',),
'alaskasnipen': ('alaskasnipe',),
'alaskasnipene': ('alaskasnipe',),
'alaskasniper': ('alaskasnipe',),
'alasker': ('alasker',),
'alaskere': ('alasker',),
'alaskeren': ('alasker',),
'alaskerer': ('alasker',),
'alaskerne': ('alasker',),
'alba': ('alba',),
'albaen': ('alba',),
'albaene': ('alba',),
'albaer': ('alba',),
'albaner': ('albaner',),
'albanere': ('albaner',),
'albaneren': ('albaner',),
'albanerer': ('albaner',),
'albanerne': ('albaner',),
'albansk': ('albansk',),
'albansken': ('albansk',),
'albanskene': ('albansk',),
'albansker': ('albansk',),
'albatross': ('albatross',),
'albatrossen': ('albatross',),
'albatrossene': ('albatross',),
'albatrosser': ('albatross',),
'albinisme': ('albinisme',),
'albinismen': ('albinisme',),
'albinismene': ('albinisme',),
'albinismer': ('albinisme',),
'albino': ('albino',),
'albinoen': ('albino',),
'albinoene': ('albino',),
'albinoer': ('albino',),
'alboge': ('alboge',),
'albogen': ('alboge',),
'albogene': ('alboge',),
'alboger': ('alboge',),
'albogeledd': ('albogeledd',),
'albogeledda': ('albogeledd',),
'albogeleddene': ('albogeledd',),
'albogeleddet': ('albogeledd',),
'albogerom': ('albogerom',),
'albogeromma': ('albogerom',),
'albogerommene': ('albogerom',),
'albogerommet': ('albogerom',),
'albogesnegl': ('albogesnegl',),
'albogesneglen': ('albogesnegl',),
'albogesneglene': ('albogesnegl',),
'albogesnegler': ('albogesnegl',),
'albogesnile': ('albogesnile',),
'albogesnilen': ('albogesnile',),
'albogesnilene': ('albogesnile',),
'albogesniler': ('albogesnile',),
'albogestøt': ('albogestøt',),
'albogestøta': ('albogestøt',),
'albogestøtene': ('albogestøt',),
'albogestøtet': ('albogestøt',),
'albogestøtta': ('albogestøtte',),
'albogestøtte': ('albogestøtte',),
'albogestøtten': ('albogestøtte',),
'albogestøttene': ('albogestøtte',),
'albogestøtter': ('albogestøtte',),
'albogestøyt': ('albogestøyt',),
'albogestøyten': ('albogestøyt',),
'albogestøytene': ('albogestøyt',),
'albogestøyter': ('albogestøyt',),
'albue': ('albue',),
'albuen': ('albue',),
'albuene': ('albue',),
'albuer': ('albue',),
'albueledd': ('albueledd',),
'albueledda': ('albueledd',),
'albueleddene': ('albueledd',),
'albueleddet': ('albueledd',),
'albuerom': ('albuerom',),
'albueromma': ('albuerom',),
'albuerommene': ('albuerom',),
'albuerommet': ('albuerom',),
'albuesnegl': ('albuesnegl',),
'albuesneglen': ('albuesnegl',),
'albuesneglene': ('albuesnegl',),
'albuesnegler': ('albuesnegl',),
'albuesnile': ('albuesnile',),
'albuesnilen': ('albuesnile',),
'albuesnilene': ('albuesnile',),
'albuesniler': ('albuesnile',),
'albuestøt': ('albuestøt',),
'albuestøta': ('albuestøt',),
'albuestøtene': ('albuestøt',),
'albuestøtet': ('albuestøt',),
'albuestøtta': ('albuestøtte',),
'albuestøtte': ('albuestøtte',),
'albuestøtten': ('albuestøtte',),
'albuestøttene': ('albuestøtte',),
'albuestøtter': ('albuestøtte',),
'albuestøyt': ('albuestøyt',),
'albuestøyten': ('albuestøyt',),
'albuestøytene': ('albuestøyt',),
'albuestøyter': ('albuestøyt',),
'albuledd': ('albuledd',),
'albuledda': ('albuledd',),
'albuleddene': ('albuledd',),
'albuleddet': ('albuledd',),
'album': ('album',),
'albuma': ('album',),
'albumene': ('album',),
'albumer': ('album',),
'albumet': ('album',),
'albumin': ('albumin',),
'albumina': ('albumin',),
'albuminene': ('albumin',),
'albuminer': ('albumin',),
'albuminet': ('albumin',),
'alburom': ('alburom',),
'alburomma': ('alburom',),
'alburommene': ('alburom',),
'alburommet': ('alburom',),
'albusnegl': ('albusnegl',),
'albusneglen': ('albusnegl',),
'albusneglene': ('albusnegl',),
'albusnegler': ('albusnegl',),
'albusnile': ('albusnile',),
'albusnilen': ('albusnile',),
'albusnilene': ('albusnile',),
'albusniler': ('albusnile',),
'albustøt': ('albustøt',),
'albustøta': ('albustøt',),
'albustøtene': ('albustøt',),
'albustøtet': ('albustøt',),
'albustøtta': ('albustøtte',),
'albustøtte': ('albustøtte',),
'albustøtten': ('albustøtte',),
'albustøttene': ('albustøtte',),
'albustøtter': ('albustøtte',),
'albustøyt': ('albustøyt',),
'albustøyten': ('albustøyt',),
'albustøytene': ('albustøyt',),
'albustøyter': ('albustøyt',),
'aldehyd': ('aldehyd',),
'aldehyda': ('aldehyd',),
'aldehydene': ('aldehyd',),
'aldehyder': ('aldehyd',),
'aldehydet': ('aldehyd',),
'alder': ('alder',),
'aldere': ('alder',),
'alderen': ('alder',),
'alderer': ('alder',),
'alderne': ('alder',),
'aldre': ('alder',),
'aldrene': ('alder',),
'aldrer': ('alder',),
'alderdom': ('alderdom',),
'alderdommen': ('alderdom',),
'alderdommene': ('alderdom',),
'alderdommer': ('alderdom',),
'alderdomssjukdom': ('alderdomssjukdom',),
'alderdomssjukdommen': ('alderdomssjukdom',),
'alderdomssjukdommene': ('alderdomssjukdom',),
'alderdomssjukdommer': ('alderdomssjukdom',),
'alderdomssløvsinn': ('alderdomssløvsinn',),
'alderdomssløvsinna': ('alderdomssløvsinn',),
'alderdomssløvsinnene': ('alderdomssløvsinn',),
'alderdomssløvsinnet': ('alderdomssløvsinn',),
'alderdomssykdom': ('alderdomssykdom',),
'alderdomssykdommen': ('alderdomssykdom',),
'alderdomssykdommene': ('alderdomssykdom',),
'alderdomssykdommer': ('alderdomssykdom',),
'alderdomstegn': ('alderdomstegn',),
'alderdomstegna': ('alderdomstegn',),
'alderdomstegnene': ('alderdomstegn',),
'alderdomstegnet': ('alderdomstegn',),
'aldersattest': ('aldersattest',),
'aldersattesten': ('aldersattest',),
'aldersattestene': ('aldersattest',),
'aldersattester': ('aldersattest',),
'aldersbolig': ('aldersbolig',),
'aldersboligen': ('aldersbolig',),
'aldersboligene': ('aldersbolig',),
'aldersboliger': ('aldersbolig',),
'aldersforskjell': ('aldersforskjell',),
'aldersforskjellen': ('aldersforskjell',),
'aldersforskjellene': ('aldersforskjell',),
'aldersforskjeller': ('aldersforskjell',),
'aldersgrensa': ('aldersgrense',),
'aldersgrense': ('aldersgrense',),
'aldersgrensen': ('aldersgrense',),
'aldersgrensene': ('aldersgrense',),
'aldersgrenser': ('aldersgrense',),
'aldersgruppa': ('aldersgruppe',),
'aldersgruppe': ('aldersgruppe',),
'aldersgruppen': ('aldersgruppe',),
'aldersgruppene': ('aldersgruppe',),
'aldersgrupper': ('aldersgruppe',),
'aldersheim': ('aldersheim',),
'aldersheimen': ('aldersheim',),
'aldersheimene': ('aldersheim',),
'aldersheimer': ('aldersheim',),
'aldershjem': ('aldershjem',),
'aldershjemma': ('aldershjem',),
'aldershjemmene': ('aldershjem',),
'aldershjemmet': ('aldershjem',),
'alderspensjon': ('alderspensjon',),
'alderspensjonen': ('alderspensjon',),
'alderspensjonene': ('alderspensjon',),
'alderspensjoner': ('alderspensjon',),
'alderspensjonist': ('alderspensjonist',),
'alderspensjonisten': ('alderspensjonist',),
'alderspensjonistene': ('alderspensjonist',),
'alderspensjonister': ('alderspensjonist',),
'alderstillegg': ('alderstillegg',),
'alderstillegga': ('alderstillegg',),
'alderstilleggene': ('alderstillegg',),
'alderstillegget': ('alderstillegg',),
'alderstrinn': ('alderstrinn',),
'alderstrinna': ('alderstrinn',),
'alderstrinnene': ('alderstrinn',),
'alderstrinnet': ('alderstrinn',),
'alderstrygd': ('alderstrygd',),
'alderstrygda': ('alderstrygd',),
'alderstrygden': ('alderstrygd',),
'alderstrygdene': ('alderstrygd',),
'alderstrygder': ('alderstrygd',),
'aldring': ('aldring',),
'aldringa': ('aldring',),
'aldringen': ('aldring',),
'aldringene': ('aldring',),
'aldringer': ('aldring',),
'aleineforelder': ('aleineforelder',),
'aleineforelderen': ('aleineforelder',),
'aleineforeldra': ('aleineforelder',),
'aleineforeldre': ('aleineforelder',),
'aleineforeldrene': ('aleineforelder',),
'aleksandriner': ('aleksandriner',),
'aleksandrinere': ('aleksandriner',),
'aleksandrineren': ('aleksandriner',),
'aleksandrinerer': ('aleksandriner',),
'aleksandrinerne': ('aleksandriner',),
'aleksi': ('aleksi',),
'aleksien': ('aleksi',),
'aleksiene': ('aleksi',),
'aleksier': ('aleksi',),
'alemanner': ('alemanner',),
'alemannere': ('alemanner',),
'alemanneren': ('alemanner',),
'alemannerer': ('alemanner',),
'alemannerne': ('alemanner',),
'alemannisk': ('alemannisk',),
'alemannisken': ('alemannisk',),
'alemanniskene': ('alemannisk',),
'alemannisker': ('alemannisk',),
'alen': ('alen',),
'alenen': ('alen',),
'alna': ('alen',),
'alnene': ('alen',),
'alner': ('alen',),
'aleneforelder': ('aleneforelder',),
'aleneforelderen': ('aleneforelder',),
'aleneforeldra': ('aleneforelder',),
'aleneforeldre': ('aleneforelder',),
'aleneforeldrene': ('aleneforelder',),
'aleut': ('aleut',),
'aleuten': ('aleut',),
'aleutene': ('aleut',),
'aleuter': ('aleut',),
'aleutisk': ('aleutisk',),
'aleutisken': ('aleutisk',),
'aleutiskene': ('aleutisk',),
'aleutisker': ('aleutisk',),
'alfa': ('alfa',),
'alfaen': ('alfa',),
'alfaene': ('alfa',),
'alfaer': ('alfa',),
'alfa': ('alfa',),
'alfaen': ('alfa',),
'alfaene': ('alfa',),
'alfaer': ('alfa',),
'alfabet': ('alfabet',),
'alfabeta': ('alfabet',),
'alfabetene': ('alfabet',),
'alfabeter': ('alfabet',),
'alfabetet': ('alfabet',),
'alfabrikk': ('alfabrikk',),
'alfabrikken': ('alfabrikk',),
'alfabrikkene': ('alfabrikk',),
'alfabrikker': ('alfabrikk',),
'alfagras': ('alfagras',),
'alfagrasa': ('alfagras',),
'alfagrasene': ('alfagras',),
'alfagraset': ('alfagras',),
'alfagress': ('alfagress',),
'alfagressa': ('alfagress',),
'alfagressene': ('alfagress',),
'alfagresset': ('alfagress',),
'alfapartikkel': ('alfapartikkel',),
'alfapartikkelen': ('alfapartikkel',),
'alfapartiklene': ('alfapartikkel',),
'alfapartikler': ('alfapartikkel',),
'alfastråle': ('alfastråle',),
'alfastrålen': ('alfastråle',),
'alfastrålene': ('alfastråle',),
'alfastråler': ('alfastråle',),
'alfons': ('alfons',),
'alfonsen': ('alfons',),
'alfonsene': ('alfons',),
'alfonser': ('alfons',),
'alfonseri': ('alfonseri',),
'alfonseria': ('alfonseri',),
'alfonseriene': ('alfonseri',),
'alfonserier': ('alfonseri',),
'alfonseriet': ('alfonseri',),
'alfuru': ('alfuru',),
'alfurua': ('alfuru',),
'alfuruen': ('alfuru',),
'alfuruene': ('alfuru',),
'alfuruer': ('alfuru',),
'alge': ('alge',),
'algen': ('alge',),
'algene': ('alge',),
'alger': ('alge',),
'algebra': ('algebra',),
'algebraen': ('algebra',),
'algebraene': ('algebra',),
'algebraer': ('algebra',),
'algemiddel': ('algemiddel',),
'algemiddelet': ('algemiddel',),
'algemidla': ('algemiddel',),
'algemidlene': ('algemiddel',),
'algemidler': ('algemiddel',),
'algemidlet': ('algemiddel',),
'algerier': ('algerier',),
'algeriere': ('algerier',),
'algerieren': ('algerier',),
'algerierer': ('algerier',),
'algerierne': ('algerier',),
'algesopp': ('algesopp',),
'algesoppen': ('algesopp',),
'algesoppene': ('algesopp',),
'algesopper': ('algesopp',),
'algevekst': ('algevekst',),
'algeveksten': ('algevekst',),
'algevekstene': ('algevekst',),
'algevekster': ('algevekst',),
'algonkin': ('algonkin',),
'algonkiner': ('algonkiner',),
'algonkinere': ('algonkiner',),
'algonkineren': ('algonkiner',),
'algonkinerer': ('algonkiner',),
'algonkinerne': ('algonkiner',),
'algoritme': ('algoritme',),
'algoritmen': ('algoritme',),
'algoritmene': ('algoritme',),
'algoritmer': ('algoritme',),
'alibi': ('alibi',),
'alibia': ('alibi',),
'alibiene': ('alibi',),
'alibier': ('alibi',),
'alibiet': ('alibi',),
'alienasjon': ('alienasjon',),
'alienasjonen': ('alienasjon',),
'alienasjonene': ('alienasjon',),
'alienasjoner': ('alienasjon',),
'alindustri': ('alindustri',),
'alindustrien': ('alindustri',),
'alindustriene': ('alindustri',),
'alindustrier': ('alindustri',),
'alkali': ('alkali',),
'alkalia': ('alkali',),
'alkaliene': ('alkali',),
'alkalier': ('alkali',),
'alkaliet': ('alkali',),
'alkalimetall': ('alkalimetall',),
'alkalimetalla': ('alkalimetall',),
'alkalimetallene': ('alkalimetall',),
'alkalimetaller': ('alkalimetall',),
'alkalimetallet': ('alkalimetall',),
'alkalimeter': ('alkalimeter',),
'alkalimeteret': ('alkalimeter',),
'alkalimetra': ('alkalimeter',),
'alkalimetre': ('alkalimeter',),
'alkalimetrene': ('alkalimeter',),
'alkalimetret': ('alkalimeter',),
'alkaloid': ('alkaloid',),
'alkaloida': ('alkaloid',),
'alkaloidene': ('alkaloid',),
'alkaloider': ('alkaloid',),
'alkaloidet': ('alkaloid',),
'alkan': ('alkan',),
'alkana': ('alkan',),
'alkanene': ('alkan',),
'alkaner': ('alkan',),
'alkanet': ('alkan',),
'alka': ('alke',),
'alke': ('alke',),
'alken': ('alke',),
'alkene': ('alke',),
'alker': ('alke',),
'alkefamilie': ('alkefamilie',),
'alkefamilien': ('alkefamilie',),
'alkefamiliene': ('alkefamilie',),
'alkefamilier': ('alkefamilie',),
'alkefugl': ('alkefugl',),
'alkefuglen': ('alkefugl',),
'alkefuglene': ('alkefugl',),
'alkefugler': ('alkefugl',),
'alkekonge': ('alkekonge',),
'alkekongen': ('alkekonge',),
'alkekongene': ('alkekonge',),
'alkekonger': ('alkekonge',),
'alken': ('alken',),
'alkena': ('alken',),
'alkenene': ('alken',),
'alkener': ('alken',),
'alkenet': ('alken',),
'alkis': ('alkis',),
'alkisen': ('alkis',),
'alkisene': ('alkis',),
'alkiser': ('alkis',),
'alkohol': ('alkohol',),
'alkoholen': ('alkohol',),
'alkoholene': ('alkohol',),
'alkoholer': ('alkohol',),
'alkoholbruk': ('alkoholbruk',),
'alkoholbruka': ('alkoholbruk',),
'alkoholbruken': ('alkoholbruk',),
'alkoholbrukene': ('alkoholbruk',),
'alkoholbruker': ('alkoholbruk',),
'alkoholbruket': ('alkoholbruk',),
'alkoholdrikk': ('alkoholdrikk',),
'alkoholdrikken': ('alkoholdrikk',),
'alkoholdrikkene': ('alkoholdrikk',),
'alkoholdrikker': ('alkoholdrikk',),
'alkoholforbruk': ('alkoholforbruk',),
'alkoholforbruka': ('alkoholforbruk',),
'alkoholforbrukene': ('alkoholforbruk',),
'alkoholforbruket': ('alkoholforbruk',),
'alkoholforbud': ('alkoholforbud',),
'alkoholforbuda': ('alkoholforbud',),
'alkoholforbudene': ('alkoholforbud',),
'alkoholforbudet': ('alkoholforbud',),
'alkoholforgiftning': ('alkoholforgiftning',),
'alkoholforgiftninga': ('alkoholforgiftning',),
'alkoholforgiftningen': ('alkoholforgiftning',),
'alkoholforgiftningene': ('alkoholforgiftning',),
'alkoholforgiftninger': ('alkoholforgiftning',),
'alkoholgjæring': ('alkoholgjæring',),
'alkoholgjæringa': ('alkoholgjæring',),
'alkoholgjæringen': ('alkoholgjæring',),
'alkoholgjæringene': ('alkoholgjæring',),
'alkoholgjæringer': ('alkoholgjæring',),
'alkoholiker': ('alkoholiker',),
'alkoholikere': ('alkoholiker',),
'alkoholikeren': ('alkoholiker',),
'alkoholikerer': ('alkoholiker',),
'alkoholikerne': ('alkoholiker',),
'alkoholiker': ('alkoholiker',),
'alkoholinnhold': ('alkoholinnhold',),
'alkoholinnholda': ('alkoholinnhold',),
'alkoholinnholdene': ('alkoholinnhold',),
'alkoholinnholdet': ('alkoholinnhold',),
'alkoholisme': ('alkoholisme',),
'alkoholismen': ('alkoholisme',),
'alkoholismene': ('alkoholisme',),
'alkoholismer': ('alkoholisme',),
'alkoholist': ('alkoholist',),
'alkoholisten': ('alkoholist',),
'alkoholistene': ('alkoholist',),
'alkoholister': ('alkoholist',),
'alkoholistheim': ('alkoholistheim',),
'alkoholistheimen': ('alkoholistheim',),
'alkoholistheimene': ('alkoholistheim',),
'alkoholistheimer': ('alkoholistheim',),
'alkoholisthjem': ('alkoholisthjem',),
'alkoholisthjemma': ('alkoholisthjem',),
'alkoholisthjemmene': ('alkoholisthjem',),
'alkoholisthjemmet': ('alkoholisthjem',),
'alkoholistomsorg': ('alkoholistomsorg',),
'alkoholistomsorga': ('alkoholistomsorg',),
'alkoholistomsorgen': ('alkoholistomsorg',),
'alkoholistomsorgene': ('alkoholistomsorg',),
'alkoholistomsorger': ('alkoholistomsorg',),
'alkoholkonsentrasjon': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjonen': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjonene': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjoner': ('alkoholkonsentrasjon',),
'alkohollovgiing': ('alkohollovgiing',),
'alkohollovgiinga': ('alkohollovgiing',),
'alkohollovgiingen': ('alkohollovgiing',),
'alkohollovgiingene': ('alkohollovgiing',),
'alkohollovgiinger': ('alkohollovgiing',),
'alkohollovgiving': ('alkohollovgiving',),
'alkohollovgivinga': ('alkohollovgiving',),
'alkohollovgivingen': ('alkohollovgiving',),
'alkohollovgivingene': ('alkohollovgiving',),
'alkohollovgivinger': ('alkohollovgiving',),
'alkohollovgivning': ('alkohollovgivning',),
'alkohollovgivninga': ('alkohollovgivning',),
'alkohollovgivningen': ('alkohollovgivning',),
'alkohollovgivningene': ('alkohollovgivning',),
'alkohollovgivninger': ('alkohollovgivning',),
'alkoholmisbruk': ('alkoholmisbruk',),
'alkoholmisbruka': ('alkoholmisbruk',),
'alkoholmisbruken': ('alkoholmisbruk',),
'alkoholmisbrukene': ('alkoholmisbruk',),
'alkoholmisbruker': ('alkoholmisbruk',),
'alkoholmisbruket': ('alkoholmisbruk',),
'alkoholnytelse': ('alkoholnytelse',),
'alkoholnytelsen': ('alkoholnytelse',),
'alkoholnytelsene': ('alkoholnytelse',),
'alkoholnytelser': ('alkoholnytelse',),
'alkoholnyting': ('alkoholnyting',),
'alkoholnytinga': ('alkoholnyting',),
'alkoholnytingen': ('alkoholnyting',),
'alkoholnytingene': ('alkoholnyting',),
'alkoholnytinger': ('alkoholnyting',),
'alkoholprosent': ('alkoholprosent',),
'alkoholprosenten': ('alkoholprosent',),
'alkoholprosentene': ('alkoholprosent',),
'alkoholprosenter': ('alkoholprosent',),
'alkoholprøva': ('alkoholprøve',),
'alkoholprøve': ('alkoholprøve',),
'alkoholprøven': ('alkoholprøve',),
'alkoholprøvene': ('alkoholprøve',),
'alkoholprøver': ('alkoholprøve',),
'alkoholskatt': ('alkoholskatt',),
'alkoholskatten': ('alkoholskatt',),
'alkoholskattene': ('alkoholskatt',),
'alkoholskatter': ('alkoholskatt',),
'alkoholtrang': ('alkoholtrang',),
'alkoholtrangen': ('alkoholtrang',),
'alkoholtrangene': ('alkoholtrang',),
'alkoholtranger': ('alkoholtrang',),
'alkotest': ('alkotest',),
'alkotesten': ('alkotest',),
'alkotestene': ('alkotest',),
'alkotester': ('alkotest',),
'alkove': ('alkove',),
'alkoven': ('alkove',),
'alkovene': ('alkove',),
'alkover': ('alkove',),
'alkyd': ('alkyd',),
'alkyda': ('alkyd',),
'alkydene': ('alkyd',),
'alkyder': ('alkyd',),
'alkydet': ('alkyd',),
'alkydharpiks': ('alkydharpiks',),
'alkydharpiksen': ('alkydharpiks',),
'alkydharpiksene': ('alkydharpiks',),
'alkydharpikser': ('alkydharpiks',),
'alkydlakk': ('alkydlakk',),
'alkydlakken': ('alkydlakk',),
'alkydlakkene': ('alkydlakk',),
'alkydlakker': ('alkydlakk',),
'alkydmaling': ('alkydmaling',),
'alkydmalinga': ('alkydmaling',),
'alkydmalingen': ('alkydmaling',),
'alkydmalingene': ('alkydmaling',),
'alkydmalinger': ('alkydmaling',),
'alkyl': ('alkyl',),
'alkyla': ('alkyl',),
'alkylene': ('alkyl',),
'alkyler': ('alkyl',),
'alkylet': ('alkyl',),
'alkymi': ('alkymi',),
'alkymien': ('alkymi',),
'alkymiene': ('alkymi',),
'alkymier': ('alkymi',),
'alkymist': ('alkymist',),
'alkymisten': ('alkymist',),
'alkymistene': ('alkymist',),
'alkymister': ('alkymist',),
'alkyn': ('alkyn',),
'alkyna': ('alkyn',),
'alkynene': ('alkyn',),
'alkyner': ('alkyn',),
'alkynet': ('alkyn',),
'all round-klassa': ('all round-klasse',),
'all round-klasse': ('all round-klasse',),
'all round-klassen': ('all round-klasse',),
'all round-klassene': ('all round-klasse',),
'all round-klasser': ('all round-klasse',),
'all round-løper': ('all round-løper',),
'all round-løpere': ('all round-løper',),
'all round-løperen': ('all round-løper',),
'all round-løperer': ('all round-løper',),
'all round-løperne': ('all round-løper',),
'all ting': ('all ting',),
'alleen': ('allé',),
'alleene': ('allé',),
'alleer': ('allé',),
'allé': ('allé',),
'alléen': ('allé',),
'alléene': ('allé',),
'alléer': ('allé',),
'alle sjelers dag': ('alle sjelers dag',),
'allegori': ('allegori',),
'allegorien': ('allegori',),
'allegoriene': ('allegori',),
'allegorier': ('allegori',),
'allegretto': ('allegretto',),
'allegrettoen': ('allegretto',),
'allegrettoene': ('allegretto',),
'allegrettoer': ('allegretto',),
'allegretto': ('allegretto',),
'allegrettoen': ('allegretto',),
'allegrettoene': ('allegretto',),
'allegrettoer': ('allegretto',),
'allegrettoet': ('allegretto',),
'allegrettosats': ('allegrettosats',),
'allegrettosatsen': ('allegrettosats',),
'allegrettosatsene': ('allegrettosats',),
'allegrettosatser': ('allegrettosats',),
'allegrettotempi': ('allegrettotempo',),
'allegrettotempiene': ('allegrettotempo',),
'allegrettotempo': ('allegrettotempo',),
'allegrettotempoa': ('allegrettotempo',),
'allegrettotempoene': ('allegrettotempo',),
'allegrettotempoer': ('allegrettotempo',),
'allegrettotempoet': ('allegrettotempo',),
'allegro': ('allegro',),
'allegroen': ('allegro',),
'allegroene': ('allegro',),
'allegroer': ('allegro',),
'allegro': ('allegro',),
'allegroen': ('allegro',),
'allegroene': ('allegro',),
'allegroer': ('allegro',),
'allegroet': ('allegro',),
'allegrosats': ('allegrosats',),
'allegrosatsen': ('allegrosats',),
'allegrosatsene': ('allegrosats',),
'allegrosatser': ('allegrosats',),
'allegrotempi': ('allegrotempo',),
'allegrotempiene': ('allegrotempo',),
'allegrotempo': ('allegrotempo',),
'allegrotempoa': ('allegrotempo',),
'allegrotempoene': ('allegrotempo',),
'allegrotempoer': ('allegrotempo',),
'allegrotempoet': ('allegrotempo',),
'allehelgensdag': ('allehelgensdag',),
'allehelgensdagen': ('allehelgensdag',),
'allehelgensdagene': ('allehelgensdag',),
'allehelgensdager': ('allehelgensdag',),
'allehånde': ('allehånde',),
'allehånden': ('allehånde',),
'allehåndene': ('allehånde',),
'allehånder': ('allehånde',),
'allel': ('allel',),
'allela': ('allel',),
'allelene': ('allel',),
'alleler': ('allel',),
'allelet': ('allel',),
'allemannseia': ('allemannseie',),
'allemannseie': ('allemannseie',),
'allemannseiene': ('allemannseie',),
'allemannseier': ('allemannseie',),
'allemannseiet': ('allemannseie',),
'allemannsvenn': ('allemannsvenn',),
'allemannsvennen': ('allemannsvenn',),
'allemannsvennene': ('allemannsvenn',),
'allemannsvenner': ('allemannsvenn',),
'allergi': ('allergi',),
'allergien': ('allergi',),
'allergiene': ('allergi',),
'allergier': ('allergi',),
'allergiker': ('allergiker',),
'allergikere': ('allergiker',),
'allergikeren': ('allergiker',),
'allergikerer': ('allergiker',),
'allergikerne': ('allergiker',),
'allfarveg': ('allfarveg',),
'allfarvegen': ('allfarveg',),
'allfarvegene': ('allfarveg',),
'allfarveger': ('allfarveg',),
'allfarvei': ('allfarvei',),
'allfarveien': ('allfarvei',),
'allfarveiene': ('allfarvei',),
'allfarveier': ('allfarvei',),
'allhær': ('allhær',),
'allhæren': ('allhær',),
'allhærene': ('allhær',),
'allhærer': ('allhær',),
'allianse': ('allianse',),
'alliansen': ('allianse',),
'alliansene': ('allianse',),
'allianser': ('allianse',),
'alligator': ('alligator',),
'alligatoren': ('alligator',),
'alligatorene': ('alligator',),
'alligatorer': ('alligator',),
'alligatorskinn': ('alligatorskinn',),
'alligatorskinna': ('alligatorskinn',),
'alligatorskinnene': ('alligatorskinn',),
'alligatorskinnet': ('alligatorskinn',),
'allitterasjon': ('allitterasjon',),
'allitterasjonen': ('allitterasjon',),
'allitterasjonene': ('allitterasjon',),
'allitterasjoner': ('allitterasjon',),
'allmakt': ('allmakt',),
'allmakta': ('allmakt',),
'allmakten': ('allmakt',),
'allmaktene': ('allmakt',),
'allmakter': ('allmakt',),
'allmaktsbud': ('allmaktsbud',),
'allmaktsbuda': ('allmaktsbud',),
'allmaktsbudene': ('allmaktsbud',),
'allmaktsbudet': ('allmaktsbud',),
'allmannamøta': ('allmannamøte',),
'allmannamøte': ('allmannamøte',),
'allmannamøtene': ('allmannamøte',),
'allmannamøter': ('allmannamøte',),
'allmannamøtet': ('allmannamøte',),
'allmenndannelse': ('allmenndannelse',),
'allmenndannelsen': ('allmenndannelse',),
'allmenndannelsene': ('allmenndannelse',),
'allmenndannelser': ('allmenndannelse',),
'allmenndanning': ('allmenndanning',),
'allmenndanninga': ('allmenndanning',),
'allmenndanningen': ('allmenndanning',),
'allmenndanningene': ('allmenndanning',),
'allmenndanninger': ('allmenndanning',),
'allmennfag': ('allmennfag',),
'allmennfaga': ('allmennfag',),
'allmennfagene': ('allmennfag',),
'allmennfaget': ('allmennfag',),
'allmennhet': ('allmennhet',),
'allmennheta': ('allmennhet',),
'allmennheten': ('allmennhet',),
'allmennhetene': ('allmennhet',),
'allmennheter': ('allmennhet',),
'allmenning': ('allmenning',),
'allmenningen': ('allmenning',),
'allmenningene': ('allmenning',),
'allmenninger': ('allmenning',),
'allmenningsrett': ('allmenningsrett',),
'allmenningsretten': ('allmenningsrett',),
'allmenningsrettene': ('allmenningsrett',),
'allmenningsretter': ('allmenningsrett',),
'allmenningsskog': ('allmenningsskog',),
'allmenningsskogen': ('allmenningsskog',),
'allmenningsskogene': ('allmenningsskog',),
'allmenningsskoger': ('allmenningsskog',),
'allmennmedisin': ('allmennmedisin',),
'allmennmedisinen': ('allmennmedisin',),
'allmennmedisinene': ('allmennmedisin',),
'allmennmedisiner': ('allmennmedisin',),
'allmennpraktiker': ('allmennpraktiker',),
'allmennpraktikere': ('allmennpraktiker',),
'allmennpraktikeren': ('allmennpraktiker',),
'allmennpraktikerer': ('allmennpraktiker',),
'allmennpraktikerne': ('allmennpraktiker',),
'allmenntilstand': ('allmenntilstand',),
'allmenntilstanden': ('allmenntilstand',),
'allmenntilstandene': ('allmenntilstand',),
'allmenntilstander': ('allmenntilstand',),
'allmennutdannelse': ('allmennutdannelse',),
'allmennutdannelsen': ('allmennutdannelse',),
'allmennutdannelsene': ('allmennutdannelse',),
'allmennutdannelser': ('allmennutdannelse',),
'allmennutdanning': ('allmennutdanning',),
'allmennutdanninga': ('allmennutdanning',),
'allmennutdanningen': ('allmennutdanning',),
'allmennutdanningene': ('allmennutdanning',),
'allmennutdanninger': ('allmennutdanning',),
'allmue': ('allmue',),
'allmuen': ('allmue',),
'allmuene': ('allmue',),
'allmuer': ('allmue',),
'allmuebibliotek': ('allmuebibliotek',),
'allmuebiblioteka': ('allmuebibliotek',),
'allmuebibliotekene': ('allmuebibliotek',),
'allmuebiblioteker': ('allmuebibliotek',),
'allmuebiblioteket': ('allmuebibliotek',),
'allmueboksamling': ('allmueboksamling',),
'allmueboksamlinga': ('allmueboksamling',),
'allmueboksamlingen': ('allmueboksamling',),
'allmueboksamlingene': ('allmueboksamling',),
'allmueboksamlinger': ('allmueboksamling',),
'allmuemål': ('allmuemål',),
'allmuemåla': ('allmuemål',),
'allmuemålene': ('allmuemål',),
'allmuemålet': ('allmuemål',),
'allmueskole': ('allmueskole',),
'allmueskolen': ('allmueskole',),
'allmueskolene': ('allmueskole',),
'allmueskoler': ('allmueskole',),
'allmuge': ('allmuge',),
'allmugen': ('allmuge',),
'allmugene': ('allmuge',),
'allmuger': ('allmuge',),
'allmugebibliotek': ('allmugebibliotek',),
'allmugebiblioteka': ('allmugebibliotek',),
'allmugebibliotekene': ('allmugebibliotek',),
'allmugebiblioteker': ('allmugebibliotek',),
'allmugebiblioteket': ('allmugebibliotek',),
'allmugeboksamling': ('allmugeboksamling',),
'allmugeboksamlinga': ('allmugeboksamling',),
'allmugeboksamlingen': ('allmugeboksamling',),
'allmugeboksamlingene': ('allmugeboksamling',),
'allmugeboksamlinger': ('allmugeboksamling',),
'allmugemål': ('allmugemål',),
'allmugemåla': ('allmugemål',),
'allmugemålene': ('allmugemål',),
'allmugemålet': ('allmugemål',),
'allmugeskole': ('allmugeskole',),
'allmugeskolen': ('allmugeskole',),
'allmugeskolene': ('allmugeskole',),
'allmugeskoler': ('allmugeskole',),
'allmøta': ('allmøte',),
'allmøte': ('allmøte',),
'allmøtene': ('allmøte',),
'allmøter': ('allmøte',),
'allmøtet': ('allmøte',),
'allnatur': ('allnatur',),
'allnaturen': ('allnatur',),
'allnaturene': ('allnatur',),
'allnaturer': ('allnatur',),
'allofon': ('allofon',),
'allofonen': ('allofon',),
'allofonene': ('allofon',),
'allofoner': ('allofon',),
'allomorf': ('allomorf',),
'allomorfen': ('allomorf',),
'allomorfene': ('allomorf',),
'allomorfer': ('allomorf',),
'allonge': ('allonge',),
'allongen': ('allonge',),
'allongene': ('allonge',),
'allonger': ('allonge',),
'allongeparykk': ('allongeparykk',),
'allongeparykken': ('allongeparykk',),
'allongeparykkene': ('allongeparykk',),
'allongeparykker': ('allongeparykk',),
'allrom': ('allrom',),
'allromma': ('allrom',),
'allrommene': ('allrom',),
'allrommet': ('allrom',),
'allrounder': ('allrounder',),
'allroundere': ('allrounder',),
'allrounderen': ('allrounder',),
'allrounderer': ('allrounder',),
'allrounderne': ('allrounder',),
'allsang': ('allsang',),
'allsangen': ('allsang',),
'allsangene': ('allsang',),
'allsanger': ('allsang',),
'allting': ('allting',),
'alltinga': ('allting',),
'alltingene': ('allting',),
'alltinget': ('allting',),
'allusjon': ('allusjon',),
'allusjonen': ('allusjon',),
'allusjonene': ('allusjon',),
'allusjoner': ('allusjon',),
'alluvialdannelse': ('alluvialdannelse',),
'alluvialdannelsen': ('alluvialdannelse',),
'alluvialdannelsene': ('alluvialdannelse',),
'alluvialdannelser': ('alluvialdannelse',),
'alluvialdanning': ('alluvialdanning',),
'alluvialdanninga': ('alluvialdanning',),
'alluvialdanningen': ('alluvialdanning',),
'alluvialdanningene': ('alluvialdanning',),
'alluvialdanninger': ('alluvialdanning',),
'alluvialtid': ('alluvialtid',),
'alluvialtida': ('alluvialtid',),
'alluvialtiden': ('alluvialtid',),
'alluvialtidene': ('alluvialtid',),
'alluvialtider': ('alluvialtid',),
'allvitenhet': ('allvitenhet',),
'allvitenheta': ('allvitenhet',),
'allvitenheten': ('allvitenhet',),
'allvitenhetene': ('allvitenhet',),
'allvitenheter': ('allvitenhet',),
'allviter': ('allviter',),
'allvitere': ('allviter',),
'allviteren': ('allviter',),
'allviterer': ('allviter',),
'allviterne': ('allviter',),
'allværsjager': ('allværsjager',),
'allværsjagere': ('allværsjager',),
'allværsjageren': ('allværsjager',),
'allværsjagerer': ('allværsjager',),
'allværsjagerne': ('allværsjager',),
'allylplast': ('allylplast',),
'allylplasten': ('allylplast',),
'allylplastene': ('allylplast',),
'allylplaster': ('allylplast',),
'alm': ('alm',),
'almen': ('alm',),
'almene': ('alm',),
'almer': ('alm',),
'alma mater': ('alma mater',),
'almanakk': ('almanakk',),
'almanakken': ('almanakk',),
'almanakkene': ('almanakk',),
'almanakker': ('almanakk',),
'alminnelighet': ('alminnelighet',),
'alminneligheta': ('alminnelighet',),
'alminneligheten': ('alminnelighet',),
'alminnelighetene': ('alminnelighet',),
'alminneligheter': ('alminnelighet',),
'almissa': ('almisse',),
'almisse': ('almisse',),
'almissen': ('almisse',),
'almissene': ('almisse',),
'almisser': ('almisse',),
'aloe': ('aloe',),
'aloen': ('aloe',),
'aloene': ('aloe',),
'aloer': ('aloe',),
'alpakka': ('alpakka',),
'alpakkaen': ('alpakka',),
'alpakkaene': ('alpakka',),
'alpakkaer': ('alpakka',),
'alpedal': ('alpedal',),
'alpedalen': ('alpedal',),
'alpedalene': ('alpedal',),
'alpedaler': ('alpedal',),
'alpefiol': ('alpefiol',),
'alpefiolen': ('alpefiol',),
'alpefiolene': ('alpefiol',),
'alpefioler': ('alpefiol',),
'alpehorn': ('alpehorn',),
'alpehorna': ('alpehorn',),
'alpehornene': ('alpehorn',),
'alpehornet': ('alpehorn',),
'alpejeger': ('alpejeger',),
'alpejegere': ('alpejeger',),
'alpejegeren': ('alpejeger',),
'alpejegerer': ('alpejeger',),
'alpejegerne': ('alpejeger',),
'alpelandskap': ('alpelandskap',),
'alpelandskapa': ('alpelandskap',),
'alpelandskapene': ('alpelandskap',),
'alpelandskaper': ('alpelandskap',),
'alpelandskapet': ('alpelandskap',),
'alpelua': ('alpelue',),
'alpelue': ('alpelue',),
'alpeluen': ('alpelue',),
'alpeluene': ('alpelue',),
'alpeluer': ('alpelue',),
'alpeluva': ('alpeluve',),
'alpeluve': ('alpeluve',),
'alpeluven': ('alpeluve',),
'alpeluvene': ('alpeluve',),
'alpeluver': ('alpeluve',),
'alperosa': ('alperose',),
'alperose': ('alperose',),
'alperosen': ('alperose',),
'alperosene': ('alperose',),
'alperoser': ('alperose',),
'alpeterreng': ('alpeterreng',),
'alpeterrenga': ('alpeterreng',),
'alpeterrengene': ('alpeterreng',),
'alpeterrenget': ('alpeterreng',),
'alpetropp': ('alpetropp',),
'alpetroppen': ('alpetropp',),
'alpetroppene': ('alpetropp',),
'alpetropper': ('alpetropp',),
'alpinanlegg': ('alpinanlegg',),
'alpinanlegga': ('alpinanlegg',),
'alpinanleggene': ('alpinanlegg',),
'alpinanlegget': ('alpinanlegg',),
'alpinbakke': ('alpinbakke',),
'alpinbakken': ('alpinbakke',),
'alpinbakkene': ('alpinbakke',),
'alpinbakker': ('alpinbakke',),
'alpinisme': ('alpinisme',),
'alpinismen': ('alpinisme',),
'alpinismene': ('alpinisme',),
'alpinismer': ('alpinisme',),
'alpinist': ('alpinist',),
'alpinisten': ('alpinist',),
'alpinistene': ('alpinist',),
'alpinister': ('alpinist',),
'alpinsenter': ('alpinsenter',),
'alpinsenteret': ('alpinsenter',),
'alpinsentra': ('alpinsenter',),
'alpinsentre': ('alpinsenter',),
'alpinsentrene': ('alpinsenter',),
'alpinsentret': ('alpinsenter',),
'alrune': ('alrune',),
'alrunen': ('alrune',),
'alrunene': ('alrune',),
'alruner': ('alrune',),
'alrunerot': ('alrunerot',),
'alrunerota': ('alrunerot',),
'alruneroten': ('alrunerot',),
'alrunerøttene': ('alrunerot',),
'alrunerøtter': ('alrunerot',),
'alsike': ('alsike',),
'alsiken': ('alsike',),
'alsikene': ('alsike',),
'alsiker': ('alsike',),
'alsikekløver': ('alsikekløver',),
'alsikekløvere': ('alsikekløver',),
'alsikekløveren': ('alsikekløver',),
'alsikekløverer': ('alsikekløver',),
'alsikekløverne': ('alsikekløver',),
'alt': ('alt',),
'alten': ('alt',),
'altene': ('alt',),
'alter': ('alt',),
'alt': ('alt',),
'alta': ('alt',),
'altene': ('alt',),
'altet': ('alt',),
'altan': ('altan',),
'altanen': ('altan',),
'altanene': ('altan',),
'altaner': ('altan',),
'altanbord': ('altanbord',),
'altanborda': ('altanbord',),
'altanbordene': ('altanbord',),
'altanborder': ('altanbord',),
'altanbordet': ('altanbord',),
'altandør': ('altandør',),
'altandøra': ('altandør',),
'altandøren': ('altandør',),
'altandørene': ('altandør',),
'altandører': ('altandør',),
'alter': ('alter',),
'altera': ('alter',),
'altere': ('alter',),
'alteret': ('alter',),
'altra': ('alter',),
'altre': ('alter',),
'altrene': ('alter',),
'altret': ('alter',),
'alter ego': ('alter ego',),
'alterasjon': ('alterasjon',),
'alterasjonen': ('alterasjon',),
'alterasjonene': ('alterasjon',),
'alterasjoner': ('alterasjon',),
'alterbilda': ('alterbilde',),
'alterbilde': ('alterbilde',),
'alterbildene': ('alterbilde',),
'alterbilder': ('alterbilde',),
'alterbildet': ('alterbilde',),
'alterbrød': ('alterbrød',),
'alterbrøda': ('alterbrød',),
'alterbrødene': ('alterbrød',),
'alterbrødet': ('alterbrød',),
'alterduk': ('alterduk',),
'alterduken': ('alterduk',),
'alterdukene': ('alterduk',),
'alterduker': ('alterduk',),
'altergang': ('altergang',),
'altergangen': ('altergang',),
'altergangene': ('altergang',),
'alterganger': ('altergang',),
'altergjest': ('altergjest',),
'altergjesten': ('altergjest',),
'altergjestene': ('altergjest',),
'altergjester': ('altergjest',),
'alterkalk': ('alterkalk',),
'alterkalken': ('alterkalk',),
'alterkalkene': ('alterkalk',),
'alterkalker': ('alterkalk',),
'alterkar': ('alterkar',),
'alterkara': ('alterkar',),
'alterkarene': ('alterkar',),
'alterkaret': ('alterkar',),
'alternasjon': ('alternasjon',),
'alternasjonen': ('alternasjon',),
'alternasjonene': ('alternasjon',),
'alternasjoner': ('alternasjon',),
'alternativ': ('alternativ',),
'alternativa': ('alternativ',),
'alternativene': ('alternativ',),
'alternativer': ('alternativ',),
'alternativet': ('alternativ',),
'alternering': ('alternering',),
'alterneringa': ('alternering',),
'alterneringen': ('alternering',),
'alterneringene': ('alternering',),
'alterneringer': ('alternering',),
'alterring': ('alterring',),
'alterringen': ('alterring',),
'alterringene': ('alterring',),
'alterringer': ('alterring',),
'altersølv': ('altersølv',),
'altersølva': ('altersølv',),
'altersølvene': ('altersølv',),
'altersølvet': ('altersølv',),
'altertavla': ('altertavle',),
'altertavle': ('altertavle',),
'altertavlen': ('altertavle',),
'altertavlene': ('altertavle',),
'altertavler': ('altertavle',),
'altertjeneste': ('altertjeneste',),
'altertjenesten': ('altertjeneste',),
'altertjenestene': ('altertjeneste',),
'altertjenester': ('altertjeneste',),
'altervin': ('altervin',),
'altervinen': ('altervin',),
'altervinene': ('altervin',),
'alterviner': ('altervin',),
'alteter': ('alteter',),
'altetere': ('alteter',),
'alteteren': ('alteter',),
'alteterer': ('alteter',),
'alteterne': ('alteter',),
'althorn': ('althorn',),
'althorna': ('althorn',),
'althornene': ('althorn',),
'althornet': ('althorn',),
'altklarinett': ('altklarinett',),
'altklarinetten': ('altklarinett',),
'altklarinettene': ('altklarinett',),
'altklarinetter': ('altklarinett',),
'altmuligmann': ('altmuligmann',),
'altmuligmannen': ('altmuligmann',),
'altmuligmenn': ('altmuligmann',),
'altmuligmennene': ('altmuligmann',),
'altnøkkel': ('altnøkkel',),
'altnøkkelen': ('altnøkkel',),
'altnøklene': ('altnøkkel',),
'altnøkler': ('altnøkkel',),
'altruisme': ('altruisme',),
'altruismen': ('altruisme',),
'altruismene': ('altruisme',),
'altruismer': ('altruisme',),
'altruist': ('altruist',),
'altruisten': ('altruist',),
'altruistene': ('altruist',),
'altruister': ('altruist',),
'altsaksofon': ('altsaksofon',),
'altsaksofonen': ('altsaksofon',),
'altsaksofonene': ('altsaksofon',),
'altsaksofoner': ('altsaksofon',),
'altsanger': ('altsanger',),
'altsangere': ('altsanger',),
'altsangeren': ('altsanger',),
'altsangerer': ('altsanger',),
'altsangerne': ('altsanger',),
'altsangerinna': ('altsangerinne',),
'altsangerinne': ('altsangerinne',),
'altsangerinnen': ('altsangerinne',),
'altsangerinnene': ('altsangerinne',),
'altsangerinner': ('altsangerinne',),
'altstemme': ('altstemme',),
'altstemmen': ('altstemme',),
'altstemmene': ('altstemme',),
'altstemmer': ('altstemme',),
'alumina': ('alumina',),
'aluminaen': ('alumina',),
'aluminaene': ('alumina',),
'aluminaer': ('alumina',),
'aluminium': ('aluminium',),
'aluminiuma': ('aluminium',),
'aluminiumen': ('aluminium',),
'aluminiumene': ('aluminium',),
'aluminiumer': ('aluminium',),
'aluminiumet': ('aluminium',),
'aluminiumfabrikk': ('aluminiumfabrikk',),
'aluminiumfabrikken': ('aluminiumfabrikk',),
'aluminiumfabrikkene': ('aluminiumfabrikk',),
'aluminiumfabrikker': ('aluminiumfabrikk',),
'aluminiumfolie': ('aluminiumfolie',),
'aluminiumfolien': ('aluminiumfolie',),
'aluminiumfoliene': ('aluminiumfolie',),
'aluminiumfolier': ('aluminiumfolie',),
'aluminiumklorid': ('aluminiumklorid',),
'aluminiumklorida': ('aluminiumklorid',),
'aluminiumkloridene': ('aluminiumklorid',),
'aluminiumklorider': ('aluminiumklorid',),
'aluminiumkloridet': ('aluminiumklorid',),
'aluminiumlegering': ('aluminiumlegering',),
'aluminiumlegeringa': ('aluminiumlegering',),
'aluminiumlegeringen': ('aluminiumlegering',),
'aluminiumlegeringene': ('aluminiumlegering',),
'aluminiumlegeringer': ('aluminiumlegering',),
'aluminiumoksid': ('aluminiumoksid',),
'aluminiumoksida': ('aluminiumoksid',),
'aluminiumoksidene': ('aluminiumoksid',),
'aluminiumoksider': ('aluminiumoksid',),
'aluminiumoksidet': ('aluminiumoksid',),
'aluminiumsfabrikk': ('aluminiumsfabrikk',),
'aluminiumsfabrikken': ('aluminiumsfabrikk',),
'aluminiumsfabrikkene': ('aluminiumsfabrikk',),
'aluminiumsfabrikker': ('aluminiumsfabrikk',),
'aluminiumsfolie': ('aluminiumsfolie',),
'aluminiumsfolien': ('aluminiumsfolie',),
'aluminiumsfoliene': ('aluminiumsfolie',),
'aluminiumsfolier': ('aluminiumsfolie',),
'aluminiumsklorid': ('aluminiumsklorid',),
'aluminiumsklorida': ('aluminiumsklorid',),
'aluminiumskloridene': ('aluminiumsklorid',),
'aluminiumsklorider': ('aluminiumsklorid',),
'aluminiumskloridet': ('aluminiumsklorid',),
'aluminiumslegering': ('aluminiumslegering',),
'aluminiumslegeringa': ('aluminiumslegering',),
'aluminiumslegeringen': ('aluminiumslegering',),
'aluminiumslegeringene': ('aluminiumslegering',),
'aluminiumslegeringer': ('aluminiumslegering',),
'aluminiumsoksid': ('aluminiumsoksid',),
'aluminiumsoksida': ('aluminiumsoksid',),
'aluminiumsoksidene': ('aluminiumsoksid',),
'aluminiumsoksider': ('aluminiumsoksid',),
'aluminiumsoksidet': ('aluminiumsoksid',),
'aluminiumsverk': ('aluminiumsverk',),
'aluminiumsverka': ('aluminiumsverk',),
'aluminiumsverkene': ('aluminiumsverk',),
'aluminiumsverker': ('aluminiumsverk',),
'aluminiumsverket': ('aluminiumsverk',),
'aluminiumverk': ('aluminiumverk',),
'aluminiumverka': ('aluminiumverk',),
'aluminiumverkene': ('aluminiumverk',),
'aluminiumverker': ('aluminiumverk',),
'aluminiumverket': ('aluminiumverk',),
'alun': ('alun',),
'aluna': ('alun',),
'alunene': ('alun',),
'aluner': ('alun',),
'alunet': ('alun',),
'alunskifer': ('alunskifer',),
'alunskifere': ('alunskifer',),
'alunskiferen': ('alunskifer',),
'alunskiferer': ('alunskifer',),
'alunskiferne': ('alunskifer',),
'alunskifre': ('alunskifer',),
'alunskifrene': ('alunskifer',),
'alunskifrer': ('alunskifer',),
'alunstein': ('alunstein',),
'alunsteinen': ('alunstein',),
'alunsteinene': ('alunstein',),
'alunsteiner': ('alunstein',),
'alv': ('alv',),
'alven': ('alv',),
'alvene': ('alv',),
'alver': ('alv',),
'alvblåst': ('alvblåst',),
'alvblåsten': ('alvblåst',),
'alvblåstene': ('alvblåst',),
'alvblåster': ('alvblåst',),
'alvblåster': ('alvblåster',),
'alvblåstere': ('alvblåster',),
'alvblåsteren': ('alvblåster',),
'alvblåsterer': ('alvblåster',),
'alvblåsterne': ('alvblåster',),
'alvblåstre': ('alvblåster',),
'alvblåstrene': ('alvblåster',),
'alvblåstrer': ('alvblåster',),
'alvedans': ('alvedans',),
'alvedansen': ('alvedans',),
'alvedansene': ('alvedans',),
'alvedanser': ('alvedans',),
'alvedronning': ('alvedronning',),
'alvedronninga': ('alvedronning',),
'alvedronningen': ('alvedronning',),
'alvedronningene': ('alvedronning',),
'alvedronninger': ('alvedronning',),
'alvekonge': ('alvekonge',),
'alvekongen': ('alvekonge',),
'alvekongene': ('alvekonge',),
'alvekonger': ('alvekonge',),
'alveland': ('alveland',),
'alvelanda': ('alveland',),
'alvelandene': ('alveland',),
'alvelandet': ('alveland',),
'alveol': ('alveol',),
'alveolen': ('alveol',),
'alveolene': ('alveol',),
'alveoler': ('alveol',),
'alveolar': ('alveolar',),
'alveolaren': ('alveolar',),
'alveolarene': ('alveolar',),
'alveolarer': ('alveolar',),
'alvnever': ('alvnever',),
'alvneveren': ('alvnever',),
'alvnevra': ('alvnever',),
'alvnevre': ('alvnever',),
'alvnevrene': ('alvnever',),
'alvnevrer': ('alvnever',),
'alvor': ('alvor',),
'alvora': ('alvor',),
'alvorene': ('alvor',),
'alvoret': ('alvor',),
'alvorsord': ('alvorsord',),
'alvorsorda': ('alvorsord',),
'alvorsordene': ('alvorsord',),
'alvorsordet': ('alvorsord',),
'alvorsstund': ('alvorsstund',),
'alvorsstunda': ('alvorsstund',),
'alvorsstunden': ('alvorsstund',),
'alvorsstundene': ('alvorsstund',),
'alvorsstunder': ('alvorsstund',),
'alvorstid': ('alvorstid',),
'alvorstida': ('alvorstid',),
'alvorstiden': ('alvorstid',),
'alvorstidene': ('alvorstid',),
'alvorstider': ('alvorstid',),
'amalgam': ('amalgam',),
'amalgama': ('amalgam',),
'amalgamene': ('amalgam',),
'amalgamer': ('amalgam',),
'amalgamet': ('amalgam',),
'amanuens': ('amanuens',),
'amanuensen': ('amanuens',),
'amanuensene': ('amanuens',),
'amanuenser': ('amanuens',),
'amanuensen': ('amanuensis',),
'amanuensene': ('amanuensis',),
'amanuenser': ('amanuensis',),
'amanuensis': ('amanuensis',),
'amaryll': ('amaryll',),
'amaryllen': ('amaryll',),
'amaryllene': ('amaryll',),
'amaryller': ('amaryll',),
'amaryllis': ('amaryllis',),
'amaryllisen': ('amaryllis',),
'amaryllisene': ('amaryllis',),
'amarylliser': ('amaryllis',),
'amasona': ('amasone',),
'amasone': ('amasone',),
'amasonen': ('amasone',),
'amasonene': ('amasone',),
'amasoner': ('amasone',),
'amatør': ('amatør',),
'amatøren': ('amatør',),
'amatørene': ('amatør',),
'amatører': ('amatør',),
'amatørbasis': ('amatørbasis',),
'amatørbasisen': ('amatørbasis',),
'amatørbasisene': ('amatørbasis',),
'amatørbasiser': ('amatørbasis',),
'amatørbilda': ('amatørbilde',),
'amatørbilde': ('amatørbilde',),
'amatørbildene': ('amatørbilde',),
'amatørbilder': ('amatørbilde',),
'amatørbildet': ('amatørbilde',),
'amatørbokser': ('amatørbokser',),
'amatørboksere': ('amatørbokser',),
'amatørbokseren': ('amatørbokser',),
'amatørbokserer': ('amatørbokser',),
'amatørbokserne': ('amatørbokser',),
'amatørfotball': ('amatørfotball',),
'amatørfotballen': ('amatørfotball',),
'amatørfotballene': ('amatørfotball',),
'amatørfotballer': ('amatørfotball',),
'amatørfotograf': ('amatørfotograf',),
'amatørfotografen': ('amatørfotograf',),
'amatørfotografene': ('amatørfotograf',),
'amatørfotografer': ('amatørfotograf',),
'amatøridrett': ('amatøridrett',),
'amatøridretten': ('amatøridrett',),
'amatøridrettene': ('amatøridrett',),
'amatøridretter': ('amatøridrett',),
'amatørisme': ('amatørisme',),
'amatørismen': ('amatørisme',),
'amatørismene': ('amatørisme',),
'amatørismer': ('amatørisme',),
'amatørskuespiller': ('amatørskuespiller',),
'amatørskuespillere': ('amatørskuespiller',),
'amatørskuespilleren': ('amatørskuespiller',),
'amatørskuespillerer': ('amatørskuespiller',),
'amatørskuespillerne': ('amatørskuespiller',),
'amatørstatus': ('amatørstatus',),
'amatørstatusen': ('amatørstatus',),
'amatørstatusene': ('amatørstatus',),
'amatørstatuser': ('amatørstatus',),
'amatørteater': ('amatørteater',),
'amatørteateret': ('amatørteater',),
'amatørteatra': ('amatørteater',),
'amatørteatre': ('amatørteater',),
'amatørteatrene': ('amatørteater',),
'amatørteatret': ('amatørteater',),
'ambar': ('ambar',),
'ambaren': ('ambar',),
'ambarene': ('ambar',),
'ambarer': ('ambar',),
'ambrene': ('ambar',),
'ambrer': ('ambar',),
'ambassade': ('ambassade',),
'ambassaden': ('ambassade',),
'ambassadene': ('ambassade',),
'ambassader': ('ambassade',),
'ambassaderåd': ('ambassaderåd',),
'ambassaderåden': ('ambassaderåd',),
'ambassaderådene': ('ambassaderåd',),
'ambassaderåder': ('ambassaderåd',),
'ambassadør': ('ambassadør',),
'ambassadøren': ('ambassadør',),
'ambassadørene': ('ambassadør',),
'ambassadører': ('ambassadør',),
'ambiguitet': ('ambiguitet',),
'ambiguiteten': ('ambiguitet',),
'ambiguitetene': ('ambiguitet',),
'ambiguiteter': ('ambiguitet',),
'ambisjon': ('ambisjon',),
'ambisjonen': ('ambisjon',),
'ambisjonene': ('ambisjon',),
'ambisjoner': ('ambisjon',),
'ambivalens': ('ambivalens',),
'ambivalensen': ('ambivalens',),
'ambivalensene': ('ambivalens',),
'ambivalenser': ('ambivalens',),
'ambolt': ('ambolt',),
'ambolten': ('ambolt',),
'amboltene': ('ambolt',),
'ambolter': ('ambolt',),
'ambra': ('ambra',),
'ambraen': ('ambra',),
'ambraene': ('ambra',),
'ambraer': ('ambra',),
'ambrosia': ('ambrosia',),
'ambrosiaen': ('ambrosia',),
'ambrosiaene': ('ambrosia',),
'ambrosiaer': ('ambrosia',),
'ambulanse': ('ambulanse',),
'ambulansen': ('ambulanse',),
'ambulansene': ('ambulanse',),
'ambulanser': ('ambulanse',),
'ambulansebil': ('ambulansebil',),
'ambulansebilen': ('ambulansebil',),
'ambulansebilene': ('ambulansebil',),
'ambulansebiler': ('ambulansebil',),
'ambulansefly': ('ambulansefly',),
'ambulanseflya': ('ambulansefly',),
'ambulanseflyene': ('ambulansefly',),
'ambulanseflyet': ('ambulansefly',),
'amen': ('amen',),
'amena': ('amen',),
'amenene': ('amen',),
'amener': ('amen',),
'amenet': ('amen',),
'amenoreen': ('amenoré',),
'amenoreene': ('amenoré',),
'amenoreer': ('amenoré',),
'amenoré': ('amenoré',),
'amenoréen': ('amenoré',),
'amenoréene': ('amenoré',),
'amenoréer': ('amenoré',),
'americium': ('americium',),
'americiuma': ('americium',),
'americiumene': ('americium',),
'americiumet': ('americium',),
'amerikabrev': ('amerikabrev',),
'amerikabreva': ('amerikabrev',),
'amerikabrevene': ('amerikabrev',),
'amerikabrever': ('amerikabrev',),
'amerikabrevet': ('amerikabrev',),
'amerikabåt': ('amerikabåt',),
'amerikabåten': ('amerikabåt',),
'amerikabåtene': ('amerikabåt',),
'amerikabåter': ('amerikabåt',),
'amerikafarer': ('amerikafarer',),
'amerikafarere': ('amerikafarer',),
'amerikafareren': ('amerikafarer',),
'amerikafarerer': ('amerikafarer',),
'amerikafarerne': ('amerikafarer',),
'amerikafeber': ('amerikafeber',),
'amerikafebere': ('amerikafeber',),
'amerikafeberen': ('amerikafeber',),
'amerikafeberne': ('amerikafeber',),
'amerikafebre': ('amerikafeber',),
'amerikafebrene': ('amerikafeber',),
'amerikafebrer': ('amerikafeber',),
'amerikaner': ('amerikaner',),
'amerikanere': ('amerikaner',),
'amerikaneren': ('amerikaner',),
'amerikanerer': ('amerikaner',),
'amerikanerne': ('amerikaner',),
'amerikanisme': ('amerikanisme',),
'amerikanismen': ('amerikanisme',),
'amerikanismene': ('amerikanisme',),
'amerikanismer': ('amerikanisme',),
'amerikanist': ('amerikanist',),
'amerikanisten': ('amerikanist',),
'amerikanistene': ('amerikanist',),
'amerikanister': ('amerikanist',),
'amerikansk': ('amerikansk',),
'amerikansken': ('amerikansk',),
'amerikanskene': ('amerikansk',),
'amerikansker': ('amerikansk',),
'amerikansk-engelsk': ('amerikansk-engelsk',),
'amerikansk-engelsken': ('amerikansk-engelsk',),
'amerikansk-engelskene': ('amerikansk-engelsk',),
'amerikansk-engelsker': ('amerikansk-engelsk',),
'amerikansk-engelsk': ('amerikansk-engelsk',),
'amerikansk-engelsken': ('amerikansk-engelsk',),
'amerikansk-engelskene': ('amerikansk-engelsk',),
'amerikansk-engelsker': ('amerikansk-engelsk',),
'ametyst': ('ametyst',),
'ametysten': ('ametyst',),
'ametystene': ('ametyst',),
'ametyster': ('ametyst',),
'amfetamin': ('amfetamin',),
'amfetamina': ('amfetamin',),
'amfetaminene': ('amfetamin',),
'amfetaminer': ('amfetamin',),
'amfetaminet': ('amfetamin',),
'amfi': ('amfi',),
'amfia': ('amfi',),
'amfiene': ('amfi',),
'amfier': ('amfi',),
'amfiet': ('amfi',),
'amfibiebil': ('amfibiebil',),
'amfibiebilen': ('amfibiebil',),
'amfibiebilene': ('amfibiebil',),
'amfibiebiler': ('amfibiebil',),
'amfibiefly': ('amfibiefly',),
'amfibieflya': ('amfibiefly',),
'amfibieflyene': ('amfibiefly',),
'amfibieflyet': ('amfibiefly',),
'amfibietank': ('amfibietank',),
'amfibietanken': ('amfibietank',),
'amfibietankene': ('amfibietank',),
'amfibietanker': ('amfibietank',),
'amfibietanks': ('amfibietanks',),
'amfibietanksen': ('amfibietanks',),
'amfibietanksene': ('amfibietanks',),
'amfibietankser': ('amfibietanks',),
'amfibia': ('amfibium',),
'amfibiene': ('amfibium',),
'amfibier': ('amfibium',),
'amfibiet': ('amfibium',),
'amfibium': ('amfibium',),
'amfiteater': ('amfiteater',),
'amfiteateret': ('amfiteater',),
'amfiteatra': ('amfiteater',),
'amfiteatre': ('amfiteater',),
'amfiteatrene': ('amfiteater',),
'amfiteatret': ('amfiteater',),
'amfolytt': ('amfolytt',),
'amfolytten': ('amfolytt',),
'amfolyttene': ('amfolytt',),
'amfolytter': ('amfolytt',),
'amfora': ('amfora',),
'amforaen': ('amfora',),
'amforaene': ('amfora',),
'amforaer': ('amfora',),
'amid': ('amid',),
'amida': ('amid',),
'amidene': ('amid',),
'amider': ('amid',),
'amidet': ('amid',),
'amin': ('amin',),
'amina': ('amin',),
'aminene': ('amin',),
'aminer': ('amin',),
'aminet': ('amin',),
'aminogruppa': ('aminogruppe',),
'aminogruppe': ('aminogruppe',),
'aminogruppen': ('aminogruppe',),
'aminogruppene': ('aminogruppe',),
'aminogrupper': ('aminogruppe',),
'aminosyra': ('aminosyre',),
'aminosyre': ('aminosyre',),
'aminosyren': ('aminosyre',),
'aminosyrene': ('aminosyre',),
'aminosyrer': ('aminosyre',),
'amma': ('amme',),
'amme': ('amme',),
'ammen': ('amme',),
'ammene': ('amme',),
'ammer': ('amme',),
'ammestuesnakk': ('ammestuesnakk',),
'ammestuesnakka': ('ammestuesnakk',),
'ammestuesnakken': ('ammestuesnakk',),
'ammestuesnakkene': ('ammestuesnakk',),
'ammestuesnakker': ('ammestuesnakk',),
'ammestuesnakket': ('ammestuesnakk',),
'ammoniakk': ('ammoniakk',),
'ammoniakken': ('ammoniakk',),
'ammoniakkene': ('ammoniakk',),
'ammoniakker': ('ammoniakk',),
'ammoniakkgass': ('ammoniakkgass',),
'ammoniakkgassen': ('ammoniakkgass',),
'ammoniakkgassene': ('ammoniakkgass',),
'ammoniakkgasser': ('ammoniakkgass',),
'ammonium': ('ammonium',),
'ammoniuma': ('ammonium',),
'ammoniumene': ('ammonium',),
'ammoniumet': ('ammonium',),
'ammoniumgjødsel': ('ammoniumgjødsel',),
'ammoniumgjødselen': ('ammoniumgjødsel',),
'ammoniumgjødsla': ('ammoniumgjødsel',),
'ammoniumgjødslene': ('ammoniumgjødsel',),
'ammoniumgjødsler': ('ammoniumgjødsel',),
'ammunisjon': ('ammunisjon',),
'ammunisjonen': ('ammunisjon',),
'ammunisjonene': ('ammunisjon',),
'ammunisjoner': ('ammunisjon',),
'ammunisjonsfabrikk': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikken': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikkene': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikker': ('ammunisjonsfabrikk',),
'ammunisjonskassa': ('ammunisjonskasse',),
'ammunisjonskasse': ('ammunisjonskasse',),
'ammunisjonskassen': ('ammunisjonskasse',),
'ammunisjonskassene': ('ammunisjonskasse',),
'ammunisjonskasser': ('ammunisjonskasse',),
'ammunisjonskista': ('ammunisjonskiste',),
'ammunisjonskiste': ('ammunisjonskiste',),
'ammunisjonskisten': ('ammunisjonskiste',),
'ammunisjonskistene': ('ammunisjonskiste',),
'ammunisjonskister': ('ammunisjonskiste',),
'ammunisjonslager': ('ammunisjonslager',),
'ammunisjonslageret': ('ammunisjonslager',),
'ammunisjonslagra': ('ammunisjonslager',),
'ammunisjonslagre': ('ammunisjonslager',),
'ammunisjonslagrene': ('ammunisjonslager',),
'ammunisjonstilførsel': ('ammunisjonstilførsel',),
'ammunisjonstilførselen': ('ammunisjonstilførsel',),
'ammunisjonstilførslene': ('ammunisjonstilførsel',),
'ammunisjonstilførsler': ('ammunisjonstilførsel',),
'amnesi': ('amnesi',),
'amnesien': ('amnesi',),
'amnesiene': ('amnesi',),
'amnesier': ('amnesi',),
'amnesti': ('amnesti',),
'amnestia': ('amnesti',),
'amnestiene': ('amnesti',),
'amnestier': ('amnesti',),
'amnestiet': ('amnesti',),
'amor': ('amor',),
'amoren': ('amor',),
'amorene': ('amor',),
'amorer': ('amor',),
'amoralitet': ('amoralitet',),
'amoraliteten': ('amoralitet',),
'amoralitetene': ('amoralitet',),
'amoraliteter': ('amoralitet',),
'amorboge': ('amorboge',),
'amorbogen': ('amorboge',),
'amorbogene': ('amorboge',),
'amorboger': ('amorboge',),
'amorbue': ('amorbue',),
'amorbuen': ('amorbue',),
'amorbuene': ('amorbue',),
'amorbuer': ('amorbue',),
'amorin': ('amorin',),
'amorinen': ('amorin',),
'amorinene': ('amorin',),
'amoriner': ('amorin',),
'amortisasjon': ('amortisasjon',),
'amortisasjonen': ('amortisasjon',),
'amortisasjonene': ('amortisasjon',),
'amortisasjoner': ('amortisasjon',),
'amortisering': ('amortisering',),
'amortiseringa': ('amortisering',),
'amortiseringen': ('amortisering',),
'amortiseringene': ('amortisering',),
'amortiseringer': ('amortisering',),
'amortiseringsfond': ('amortiseringsfond',),
'amortiseringsfonda': ('amortiseringsfond',),
'amortiseringsfondene': ('amortiseringsfond',),
'amortiseringsfondet': ('amortiseringsfond',),
'amortiseringsplan': ('amortiseringsplan',),
'amortiseringsplanen': ('amortiseringsplan',),
'amortiseringsplanene': ('amortiseringsplan',),
'amortiseringsplaner': ('amortiseringsplan',),
'ampel': ('ampel',),
'ampelen': ('ampel',),
'amplene': ('ampel',),
'ampler': ('ampel',),
'ampelplanta': ('ampelplante',),
'ampelplante': ('ampelplante',),
'ampelplanten': ('ampelplante',),
'ampelplantene': ('ampelplante',),
'ampelplanter': ('ampelplante',),
'ampere': ('ampere',),
'amperen': ('ampere',),
'amperene': ('ampere',),
'amperemeter': ('amperemeter',),
'amperemeteret': ('amperemeter',),
'amperemetra': ('amperemeter',),
'amperemetre': ('amperemeter',),
'amperemetrene': ('amperemeter',),
'amperemetret': ('amperemeter',),
'amplitude': ('amplitude',),
'amplituden': ('amplitude',),
'amplitudene': ('amplitude',),
'amplituder': ('amplitude',),
'amplitudemodulasjon': ('amplitudemodulasjon',),
'amplitudemodulasjonen': ('amplitudemodulasjon',),
'amplitudemodulasjonene': ('amplitudemodulasjon',),
'amplitudemodulasjoner': ('amplitudemodulasjon',),
'amplitudemodulering': ('amplitudemodulering',),
'amplitudemoduleringa': ('amplitudemodulering',),
'amplitudemoduleringen': ('amplitudemodulering',),
'amplitudemoduleringene': ('amplitudemodulering',),
'amplitudemoduleringer': ('amplitudemodulering',),
'ampulle': ('ampulle',),
'ampullen': ('ampulle',),
'ampullene': ('ampulle',),
'ampuller': ('ampulle',),
'amputasjon': ('amputasjon',),
'amputasjonen': ('amputasjon',),
'amputasjonene': ('amputasjon',),
'amputasjoner': ('amputasjon',),
'amputering': ('amputering',),
'amputeringa': ('amputering',),
'amputeringen': ('amputering',),
'amputeringene': ('amputering',),
'amputeringer': ('amputering',),
'amt': ('amt',),
'amta': ('amt',),
'amtene': ('amt',),
'amter': ('amt',),
'amtet': ('amt',),
'amtmann': ('amtmann',),
'amtmannen': ('amtmann',),
'amtmenn': ('amtmann',),
'amtmennene': ('amtmann',),
'amtmanninna': ('amtmanninne',),
'amtmanninne': ('amtmanninne',),
'amtmanninnen': ('amtmanninne',),
'amtmanninnene': ('amtmanninne',),
'amtmanninner': ('amtmanninne',),
'amtskasserer': ('amtskasserer',),
'amtskasserere': ('amtskasserer',),
'amtskassereren': ('amtskasserer',),
'amtskassererer': ('amtskasserer',),
'amtskassererne': ('amtskasserer',),
'amtsskole': ('amtsskole',),
'amtsskolen': ('amtsskole',),
'amtsskolene': ('amtsskole',),
'amtsskoler': ('amtsskole',),
'amulett': ('amulett',),
'amuletten': ('amulett',),
'amulettene': ('amulett',),
'amuletter': ('amulett',),
'amylase': ('amylase',),
'amylasen': ('amylase',),
'amylasene': ('amylase',),
'amylaser': ('amylase',),
'amylum': ('amylum',),
'amyluma': ('amylum',),
'amylumene': ('amylum',),
'amylumet': ('amylum',),
'amøbe': ('amøbe',),
'amøben': ('amøbe',),
'amøbene': ('amøbe',),
'amøber': ('amøbe',),
'amøbedysenteri': ('amøbedysenteri',),
'amøbedysenterien': ('amøbedysenteri',),
'amøbedysenteriene': ('amøbedysenteri',),
'amøbedysenterier': ('amøbedysenteri',),
'anabaptist': ('anabaptist',),
'anabaptisten': ('anabaptist',),
'anabaptistene': ('anabaptist',),
'anabaptister': ('anabaptist',),
'anabolisme': ('anabolisme',),
'anabolismen': ('anabolisme',),
'anabolismene': ('anabolisme',),
'anabolismer': ('anabolisme',),
'anafor': ('anafor',),
'anaforen': ('anafor',),
'anaforene': ('anafor',),
'anaforer': ('anafor',),
'anagram': ('anagram',),
'anagramma': ('anagram',),
'anagrammene': ('anagram',),
'anagrammer': ('anagram',),
'anagrammet': ('anagram',),
'anakoluti': ('anakoluti',),
'anakolutien': ('anakoluti',),
'anakolutiene': ('anakoluti',),
'anakolutier': ('anakoluti',),
'anakolutt': ('anakolutt',),
'anakolutten': ('anakolutt',),
'anakoluttene': ('anakolutt',),
'anakolutter': ('anakolutt',),
'anakonda': ('anakonda',),
'anakondaen': ('anakonda',),
'anakondaene': ('anakonda',),
'anakondaer': ('anakonda',),
'anakoret': ('anakoret',),
'anakoreten': ('anakoret',),
'anakoretene': ('anakoret',),
'anakoreter': ('anakoret',),
'anakronisme': ('anakronisme',),
'anakronismen': ('anakronisme',),
'anakronismene': ('anakronisme',),
'anakronismer': ('anakronisme',),
'analfabet': ('analfabet',),
'analfabeten': ('analfabet',),
'analfabetene': ('analfabet',),
'analfabeter': ('analfabet',),
'analfabetisme': ('analfabetisme',),
'analfabetismen': ('analfabetisme',),
'analfabetismene': ('analfabetisme',),
'analfabetismer': ('analfabetisme',),
'analogi': ('analogi',),
'analogien': ('analogi',),
'analogiene': ('analogi',),
'analogier': ('analogi',),
'analogidannelse': ('analogidannelse',),
'analogidannelsen': ('analogidannelse',),
'analogidannelsene': ('analogidannelse',),
'analogidannelser': ('analogidannelse',),
'analogidanning': ('analogidanning',),
'analogidanninga': ('analogidanning',),
'analogidanningen': ('analogidanning',),
'analogidanningene': ('analogidanning',),
'analogidanninger': ('analogidanning',),
'analogislutning': ('analogislutning',),
'analogislutninga': ('analogislutning',),
'analogislutningen': ('analogislutning',),
'analogislutningene': ('analogislutning',),
'analogislutninger': ('analogislutning',),
'analogur': ('analogur',),
'analogura': ('analogur',),
'analogurene': ('analogur',),
'analoguret': ('analogur',),
'analysand': ('analysand',),
'analysanden': ('analysand',),
'analysandene': ('analysand',),
'analysander': ('analysand',),
'analysator': ('analysator',),
'analysatoren': ('analysator',),
'analysatorene': ('analysator',),
'analysatorer': ('analysator',),
'analysa': ('analyse',),
'analyse': ('analyse',),
'analysen': ('analyse',),
'analysene': ('analyse',),
'analyser': ('analyse',),
'analytiker': ('analytiker',),
'analytikere': ('analytiker',),
'analytikeren': ('analytiker',),
'analytikerer': ('analytiker',),
'analytikerne': ('analytiker',),
'analåpning': ('analåpning',),
'analåpninga': ('analåpning',),
'analåpningen': ('analåpning',),
'analåpningene': ('analåpning',),
'analåpninger': ('analåpning',),
'ananas': ('ananas',),
'ananasen': ('ananas',),
'ananasene': ('ananas',),
'ananaser': ('ananas',),
'ananasfamilie': ('ananasfamilie',),
'ananasfamilien': ('ananasfamilie',),
'ananasfamiliene': ('ananasfamilie',),
'ananasfamilier': ('ananasfamilie',),
'ananasjordbær': ('ananasjordbær',),
'ananasjordbæra': ('ananasjordbær',),
'ananasjordbærene': ('ananasjordbær',),
'ananasjordbæret': ('ananasjordbær',),
'ananassaft': ('ananassaft',),
'ananassafta': ('ananassaft',),
'ananassaften': ('ananassaft',),
'ananassaftene': ('ananassaft',),
'ananassafter': ('ananassaft',),
'anapest': ('anapest',),
'anapesten': ('anapest',),
'anapestene': ('anapest',),
'anapester': ('anapest',),
'anarki': ('anarki',),
'anarkia': ('anarki',),
'anarkiene': ('anarki',),
'anarkier': ('anarki',),
'anarkiet': ('anarki',),
'anarkisme': ('anarkisme',),
'anarkismen': ('anarkisme',),
'anarkismene': ('anarkisme',),
'anarkismer': ('anarkisme',),
'anarkist': ('anarkist',),
'anarkisten': ('anarkist',),
'anarkistene': ('anarkist',),
'anarkister': ('anarkist',),
'anarkosyndikalisme': ('anarkosyndikalisme',),
'anarkosyndikalismen': ('anarkosyndikalisme',),
'anarkosyndikalismene': ('anarkosyndikalisme',),
'anarkosyndikalismer': ('anarkosyndikalisme',),
'anastrofe': ('anastrofe',),
'anastrofen': ('anastrofe',),
'anastrofene': ('anastrofe',),
'anastrofer': ('anastrofe',),
'anatem': ('anatem',),
'anatema': ('anatem',),
'anatemene': ('anatem',),
'anatemer': ('anatem',),
'anatemet': ('anatem',),
'anatema': ('anatema',),
'anatemaene': ('anatema',),
'anatemaer': ('anatema',),
'anatemaet': ('anatema',),
'anatom': ('anatom',),
'anatomen': ('anatom',),
'anatomene': ('anatom',),
'anatomer': ('anatom',),
'anatomi': ('anatomi',),
'anatomien': ('anatomi',),
'anatomiene': ('anatomi',),
'anatomier': ('anatomi',),
'anbefaling': ('anbefaling',),
'anbefalinga': ('anbefaling',),
'anbefalingen': ('anbefaling',),
'anbefalingene': ('anbefaling',),
'anbefalinger': ('anbefaling',),
'anbefalingsbrev': ('anbefalingsbrev',),
'anbefalingsbreva': ('anbefalingsbrev',),
'anbefalingsbrevene': ('anbefalingsbrev',),
'anbefalingsbrever': ('anbefalingsbrev',),
'anbefalingsbrevet': ('anbefalingsbrev',),
'anbefalingsskriv': ('anbefalingsskriv',),
'anbefalingsskriva': ('anbefalingsskriv',),
'anbefalingsskrivene': ('anbefalingsskriv',),
'anbefalingsskrivet': ('anbefalingsskriv',),
'anbringelse': ('anbringelse',),
'anbringelsen': ('anbringelse',),
'anbringelsene': ('anbringelse',),
'anbringelser': ('anbringelse',),
'anbud': ('anbud',),
'anbuda': ('anbud',),
'anbudene': ('anbud',),
'anbudet': ('anbud',),
'anbudsbetingelse': ('anbudsbetingelse',),
'anbudsbetingelsen': ('anbudsbetingelse',),
'anbudsbetingelsene': ('anbudsbetingelse',),
'anbudsbetingelser': ('anbudsbetingelse',),
'anbudsfrist': ('anbudsfrist',),
'anbudsfristen': ('anbudsfrist',),
'anbudsfristene': ('anbudsfrist',),
'anbudsfrister': ('anbudsfrist',),
'anbudsgiver': ('anbudsgiver',),
'anbudsgivere': ('anbudsgiver',),
'anbudsgiveren': ('anbudsgiver',),
'anbudsgiverer': ('anbudsgiver',),
'anbudsgiverne': ('anbudsgiver',),
'anbudsinnbydelse': ('anbudsinnbydelse',),
'anbudsinnbydelsen': ('anbudsinnbydelse',),
'anbudsinnbydelsene': ('anbudsinnbydelse',),
'anbudsinnbydelser': ('anbudsinnbydelse',),
'anbudspris': ('anbudspris',),
'anbudsprisen': ('anbudspris',),
'anbudsprisene': ('anbudspris',),
'anbudspriser': ('anbudspris',),
'anbyder': ('anbyder',),
'anbydere': ('anbyder',),
'anbyderen': ('anbyder',),
'anbyderer': ('anbyder',),
'anbyderne': ('anbyder',),
'and': ('and',),
'anda': ('and',),
'anden': ('and',),
'endene': ('and',),
'ender': ('and',),
'andakt': ('andakt',),
'andakta': ('andakt',),
'andakten': ('andakt',),
'andaktene': ('andakt',),
'andakter': ('andakt',),
'andaktsbok': ('andaktsbok',),
'andaktsboka': ('andaktsbok',),
'andaktsboken': ('andaktsbok',),
'andaktsbøkene': ('andaktsbok',),
'andaktsbøker': ('andaktsbok',),
'andaktsstund': ('andaktsstund',),
'andaktsstunda': ('andaktsstund',),
'andaktsstunden': ('andaktsstund',),
'andaktsstundene': ('andaktsstund',),
'andaktsstunder': ('andaktsstund',),
'andalusier': ('andalusier',),
'andalusiere': ('andalusier',),
'andalusieren': ('andalusier',),
'andalusierer': ('andalusier',),
'andalusierne': ('andalusier',),
'andante': ('andante',),
'andanten': ('andante',),
'andantene': ('andante',),
'andanter': ('andante',),
'andanta': ('andante',),
'andante': ('andante',),
'andantene': ('andante',),
'andanter': ('andante',),
'andantet': ('andante',),
'andantesats': ('andantesats',),
'andantesatsen': ('andantesats',),
'andantesatsene': ('andantesats',),
'andantesatser': ('andantesats',),
'andantetempi': ('andantetempo',),
'andantetempiene': ('andantetempo',),
'andantetempo': ('andantetempo',),
'andantetempoa': ('andantetempo',),
'andantetempoene': ('andantetempo',),
'andantetempoer': ('andantetempo',),
'andantetempoet': ('andantetempo',),
'andantino': ('andantino',),
'andantinoen': ('andantino',),
'andantinoene': ('andantino',),
'andantinoer': ('andantino',),
'andantino': ('andantino',),
'andantinoa': ('andantino',),
'andantinoene': ('andantino',),
'andantinoer': ('andantino',),
'andantinoet': ('andantino',),
'ande': ('ande',),
'anden': ('ande',),
'andene': ('ande',),
'ander': ('ande',),
'andebryst': ('andebryst',),
'andebrysta': ('andebryst',),
'andebrystene': ('andebryst',),
'andebrystet': ('andebryst',),
'andedam': ('andedam',),
'andedammen': ('andedam',),
'andedammene': ('andedam',),
'andedammer': ('andedam',),
'andedrag': ('andedrag',),
'andedraga': ('andedrag',),
'andedragene': ('andedrag',),
'andedraget': ('andedrag',),
'andedrått': ('andedrått',),
'andedråtten': ('andedrått',),
'andedråttene': ('andedrått',),
'andedråtter': ('andedrått',),
'andefamilie': ('andefamilie',),
'andefamilien': ('andefamilie',),
'andefamiliene': ('andefamilie',),
'andefamilier': ('andefamilie',),
'andefugl': ('andefugl',),
'andefuglen': ('andefugl',),
'andefuglene': ('andefugl',),
'andefugler': ('andefugl',),
'andektighet': ('andektighet',),
'andektigheta': ('andektighet',),
'andektigheten': ('andektighet',),
'andektighetene': ('andektighet',),
'andektigheter': ('andektighet',),
'andel': ('andel',),
'andelen': ('andel',),
'andelene': ('andel',),
'andeler': ('andel',),
'andelsdrift': ('andelsdrift',),
'andelsdrifta': ('andelsdrift',),
'andelsdriften': ('andelsdrift',),
'andelsdriftene': ('andelsdrift',),
'andelsdrifter': ('andelsdrift',),
'andelseia': ('andelseie',),
'andelseie': ('andelseie',),
'andelseiene': ('andelseie',),
'andelseier': ('andelseie',),
'andelseiet': ('andelseie',),
'andelsforetak': ('andelsforetak',),
'andelsforetaka': ('andelsforetak',),
'andelsforetakene': ('andelsforetak',),
'andelsforetaket': ('andelsforetak',),
'andelshaver': ('andelshaver',),
'andelshavere': ('andelshaver',),
'andelshaveren': ('andelshaver',),
'andelshaverer': ('andelshaver',),
'andelshaverne': ('andelshaver',),
'andelshytta': ('andelshytte',),
'andelshytte': ('andelshytte',),
'andelshytten': ('andelshytte',),
'andelshyttene': ('andelshytte',),
'andelshytter': ('andelshytte',),
'andelslag': ('andelslag',),
'andelslaga': ('andelslag',),
'andelslagene': ('andelslag',),
'andelslaget': ('andelslag',),
'andelsmeieri': ('andelsmeieri',),
'andelsmeieria': ('andelsmeieri',),
'andelsmeieriene': ('andelsmeieri',),
'andelsmeierier': ('andelsmeieri',),
'andelsmeieriet': ('andelsmeieri',),
'andelsslakteri': ('andelsslakteri',),
'andelsslakteria': ('andelsslakteri',),
'andelsslakteriene': ('andelsslakteri',),
'andelsslakterier': ('andelsslakteri',),
'andelsslakteriet': ('andelsslakteri',),
'andelssystem': ('andelssystem',),
'andelssystema': ('andelssystem',),
'andelssystemene': ('andelssystem',),
'andelssystemer': ('andelssystem',),
'andelssystemet': ('andelssystem',),
'andemat': ('andemat',),
'andematen': ('andemat',),
'andematene': ('andemat',),
'andemater': ('andemat',),
'andematfamilie': ('andematfamilie',),
'andematfamilien': ('andematfamilie',),
'andematfamiliene': ('andematfamilie',),
'andematfamilier': ('andematfamilie',),
'andestegg': ('andestegg',),
'andesteggen': ('andestegg',),
'andesteggene': ('andestegg',),
'andestegger': ('andestegg',),
'andesteik': ('andesteik',),
'andesteika': ('andesteik',),
'andesteiken': ('andesteik',),
'andesteikene': ('andesteik',),
'andesteiker': ('andesteik',),
'andestek': ('andestek',),
'andesteka': ('andestek',),
'andesteken': ('andestek',),
'andestekene': ('andestek',),
'andesteker': ('andestek',),
'andføtting': ('andføtting',),
'andføttingen': ('andføtting',),
'andføttingene': ('andføtting',),
'andføttinger': ('andføtting',),
'andlet': ('andlet',),
'andleta': ('andlet',),
'andletene': ('andlet',),
'andletet': ('andlet',),
'andmat': ('andmat',),
'andmaten': ('andmat',),
'andmatene': ('andmat',),
'andmater': ('andmat',),
'andmatfamilie': ('andmatfamilie',),
'andmatfamilien': ('andmatfamilie',),
'andmatfamiliene': ('andmatfamilie',),
'andmatfamilier': ('andmatfamilie',),
'andorraner': ('andorraner',),
'andorranere': ('andorraner',),
'andorraneren': ('andorraner',),
'andorranerer': ('andorraner',),
'andorranerne': ('andorraner',),
'andragende': ('andragende',),
'andragendene': ('andragende',),
'andragender': ('andragende',),
'andragendet': ('andragende',),
'andreaskors': ('andreaskors',),
'andreaskorsa': ('andreaskors',),
'andreaskorsene': ('andreaskors',),
'andreaskorset': ('andreaskors',),
'andreasmess': ('andreasmess',),
'andreasmesse': ('andreasmesse',),
'andrefiolin': ('andrefiolin',),
'andrefiolinen': ('andrefiolin',),
'andrefiolinene': ('andrefiolin',),
'andrefioliner': ('andrefiolin',),
'andregir': ('andregir',),
'andregira': ('andregir',),
'andregirene': ('andregir',),
'andregiret': ('andregir',),
'andregradsligning': ('andregradsligning',),
'andregradsligninga': ('andregradsligning',),
'andregradsligningen': ('andregradsligning',),
'andregradsligningene': ('andregradsligning',),
'andregradsligninger': ('andregradsligning',),
'andregradslikning': ('andregradslikning',),
'andregradslikninga': ('andregradslikning',),
'andregradslikningen': ('andregradslikning',),
'andregradslikningene': ('andregradslikning',),
'andregradslikninger': ('andregradslikning',),
'andrehands': ('andrehands',),
'andrehandsen': ('andrehands',),
'andrehandsene': ('andrehands',),
'andrehandser': ('andrehands',),
'andremann': ('andremann',),
'andremannen': ('andremann',),
'andremannene': ('andremann',),
'andremanner': ('andremann',),
'andremaskinist': ('andremaskinist',),
'andremaskinisten': ('andremaskinist',),
'andremaskinistene': ('andremaskinist',),
'andremaskinister': ('andremaskinist',),
'andreplass': ('andreplass',),
'andreplassen': ('andreplass',),
'andreplassene': ('andreplass',),
'andreplasser': ('andreplass',),
'andreprioritet': ('andreprioritet',),
'andreprioriteten': ('andreprioritet',),
'andreprioritetene': ('andreprioritet',),
'andreprioriteter': ('andreprioritet',),
'andresortering': ('andresortering',),
'andresorteringa': ('andresortering',),
'andresorteringen': ('andresortering',),
'andresorteringene': ('andresortering',),
'andresorteringer': ('andresortering',),
'andrestemme': ('andrestemme',),
'andrestemmen': ('andrestemme',),
'andrestemmene': ('andrestemme',),
'andrestemmer': ('andrestemme',),
'andrestyrmann': ('andrestyrmann',),
'andrestyrmannen': ('andrestyrmann',),
'andrestyrmenn': ('andrestyrmann',),
'andrestyrmennene': ('andrestyrmann',),
'andrik': ('andrik',),
'andriken': ('andrik',),
'andrikene': ('andrik',),
'andriker': ('andrik',),
'androgen': ('androgen',),
'androgena': ('androgen',),
'androgenen': ('androgen',),
'androgenene': ('androgen',),
'androgener': ('androgen',),
'androgenet': ('androgen',),
'androgyni': ('androgyni',),
'androgynien': ('androgyni',),
'androgyniene': ('androgyni',),
'androgynier': ('androgyni',),
'andror': ('andror',),
'androren': ('andror',),
'androrene': ('andror',),
'androrer': ('andror',),
'anduvingsmerka': ('anduvingsmerke',),
'anduvingsmerke': ('anduvingsmerke',),
'anduvingsmerkene': ('anduvingsmerke',),
'anduvingsmerker': ('anduvingsmerke',),
'anduvingsmerket': ('anduvingsmerke',),
'ane': ('ane',),
'anen': ('ane',),
'anene': ('ane',),
'aner': ('ane',),
'anebilda': ('anebilde',),
'anebilde': ('anebilde',),
'anebildene': ('anebilde',),
'anebilder': ('anebilde',),
'anebildet': ('anebilde',),
'anegalleri': ('anegalleri',),
'anegalleria': ('anegalleri',),
'anegalleriene': ('anegalleri',),
'anegallerier': ('anegalleri',),
'anegalleriet': ('anegalleri',),
'anekdote': ('anekdote',),
'anekdoten': ('anekdote',),
'anekdotene': ('anekdote',),
'anekdoter': ('anekdote',),
'anelse': ('anelse',),
'anelsen': ('anelse',),
'anelsene': ('anelse',),
'anelser': ('anelse',),
'anemi': ('anemi',),
'anemien': ('anemi',),
'anemiene': ('anemi',),
'anemier': ('anemi',),
'anemofili': ('anemofili',),
'anemofilien': ('anemofili',),
'anemofiliene': ('anemofili',),
'anemofilier': ('anemofili',),
'anemologi': ('anemologi',),
'anemologien': ('anemologi',),
'anemologiene': ('anemologi',),
'anemologier': ('anemologi',),
'anemometer': ('anemometer',),
'anemometeret': ('anemometer',),
'anemometra': ('anemometer',),
'anemometre': ('anemometer',),
'anemometrene': ('anemometer',),
'anemometret': ('anemometer',),
'anemone': ('anemone',),
'anemonen': ('anemone',),
'anemonene': ('anemone',),
'anemoner': ('anemone',),
'anerkjennelse': ('anerkjennelse',),
'anerkjennelsen': ('anerkjennelse',),
'anerkjennelsene': ('anerkjennelse',),
'anerkjennelser': ('anerkjennelse',),
'aneroidbarometer': ('aneroidbarometer',),
'aneroidbarometeret': ('aneroidbarometer',),
'aneroidbarometra': ('aneroidbarometer',),
'aneroidbarometre': ('aneroidbarometer',),
'aneroidbarometrene': ('aneroidbarometer',),
'aneroidbarometret': ('aneroidbarometer',),
'anestesi': ('anestesi',),
'anestesien': ('anestesi',),
'anestesiene': ('anestesi',),
'anestesier': ('anestesi',),
'anestesilege': ('anestesilege',),
'anestesilegen': ('anestesilege',),
'anestesilegene': ('anestesilege',),
'anestesileger': ('anestesilege',),
'anestesisøster': ('anestesisøster',),
'anestesisøstera': ('anestesisøster',),
'anestesisøsteren': ('anestesisøster',),
'anestesisøstre': ('anestesisøster',),
'anestesisøstrene': ('anestesisøster',),
'anestesisøstrer': ('anestesisøster',),
'anetavla': ('anetavle',),
'anetavle': ('anetavle',),
'anetavlen': ('anetavle',),
'anetavlene': ('anetavle',),
'anetavler': ('anetavle',),
'anfall': ('anfall',),
'anfalla': ('anfall',),
'anfallene': ('anfall',),
'anfallet': ('anfall',),
'anfektelse': ('anfektelse',),
'anfektelsen': ('anfektelse',),
'anfektelsene': ('anfektelse',),
'anfektelser': ('anfektelse',),
'anfordring': ('anfordring',),
'anfordringa': ('anfordring',),
'anfordringen': ('anfordring',),
'anfordringene': ('anfordring',),
'anfordringer': ('anfordring',),
'anfører': ('anfører',),
'anførere': ('anfører',),
'anføreren': ('anfører',),
'anførerer': ('anfører',),
'anførerne': ('anfører',),
'anførsel': ('anførsel',),
'anførselen': ('anførsel',),
'anførslene': ('anførsel',),
'anførsler': ('anførsel',),
'anførselstegn': ('anførselstegn',),
'anførselstegna': ('anførselstegn',),
'anførselstegnene': ('anførselstegn',),
'anførselstegnet': ('anførselstegn',),
'angakok': ('angakok',),
'angakoken': ('angakok',),
'angakokene': ('angakok',),
'angakoker': ('angakok',),
'ange': ('ange',),
'angen': ('ange',),
'angene': ('ange',),
'anger': ('ange',),
'angel': ('angel',),
'angelen': ('angel',),
'anglene': ('angel',),
'angler': ('angel',),
'angelsakser': ('angelsakser',),
'angelsaksere': ('angelsakser',),
'angelsakseren': ('angelsakser',),
'angelsakserer': ('angelsakser',),
'angelsakserne': ('angelsakser',),
'angelsaksisk': ('angelsaksisk',),
'angelsaksisken': ('angelsaksisk',),
'angelsaksiskene': ('angelsaksisk',),
'angelsaksisker': ('angelsaksisk',),
'anger': ('anger',),
'angere': ('anger',),
'angeren': ('anger',),
'angerer': ('anger',),
'angerne': ('anger',),
'angre': ('anger',),
'angrene': ('anger',),
'angrer': ('anger',),
'angina': ('angina',),
'anginaen': ('angina',),
'anginaene': ('angina',),
'anginaer': ('angina',),
'angina pectoris': ('angina pectoris',),
'angiologi': ('angiologi',),
'angiologien': ('angiologi',),
'angiologiene': ('angiologi',),
'angiologier': ('angiologi',),
'angiosperm': ('angiosperm',),
'angiospermen': ('angiosperm',),
'angiospermene': ('angiosperm',),
'angiospermer': ('angiosperm',),
'angivelse': ('angivelse',),
'angivelsen': ('angivelse',),
'angivelsene': ('angivelse',),
'angivelser': ('angivelse',),
'angiver': ('angiver',),
'angivere': ('angiver',),
'angiveren': ('angiver',),
'angiverer': ('angiver',),
'angiverne': ('angiver',),
'angiveri': ('angiveri',),
'angiveria': ('angiveri',),
'angiveriene': ('angiveri',),
'angiverier': ('angiveri',),
'angiveriet': ('angiveri',),
'anglemakk': ('anglemakk',),
'anglemakken': ('anglemakk',),
'anglemakkene': ('anglemakk',),
'anglemakker': ('anglemakk',),
'anglemark': ('anglemark',),
'anglemarken': ('anglemark',),
'anglemarkene': ('anglemark',),
'anglemarker': ('anglemark',),
'angler': ('angler',),
'anglere': ('angler',),
'angleren': ('angler',),
'anglerer': ('angler',),
'anglerne': ('angler',),
'anglikaner': ('anglikaner',),
'anglikanere': ('anglikaner',),
'anglikaneren': ('anglikaner',),
'anglikanerer': ('anglikaner',),
'anglikanerne': ('anglikaner',),
'anglisisme': ('anglisisme',),
'anglisismen': ('anglisisme',),
'anglisismene': ('anglisisme',),
'anglisismer': ('anglisisme',),
'anglist': ('anglist',),
'anglisten': ('anglist',),
'anglistene': ('anglist',),
'anglister': ('anglist',),
'angloaraber': ('angloaraber',),
'angloarabere': ('angloaraber',),
'angloaraberen': ('angloaraber',),
'angloaraberer': ('angloaraber',),
'angloaraberne': ('angloaraber',),
'anglofob': ('anglofob',),
'anglofoben': ('anglofob',),
'anglofobene': ('anglofob',),
'anglofober': ('anglofob',),
'anglofobi': ('anglofobi',),
'anglofobien': ('anglofobi',),
'anglofobiene': ('anglofobi',),
'anglofobier': ('anglofobi',),
'angloman': ('angloman',),
'anglomanen': ('angloman',),
'anglomanene': ('angloman',),
'anglomaner': ('angloman',),
'anglomani': ('anglomani',),
'anglomanien': ('anglomani',),
'anglomaniene': ('anglomani',),
'anglomanier': ('anglomani',),
'angolaner': ('angolaner',),
'angolanere': ('angolaner',),
'angolaneren': ('angolaner',),
'angolanerer': ('angolaner',),
'angolanerne': ('angolaner',),
'angora': ('angora',),
'angoraen': ('angora',),
'angoraene': ('angora',),
'angoraer': ('angora',),
'angoragarn': ('angoragarn',),
'angoragarna': ('angoragarn',),
'angoragarnene': ('angoragarn',),
'angoragarnet': ('angoragarn',),
'angorageit': ('angorageit',),
'angorageita': ('angorageit',),
'angorageiten': ('angorageit',),
'angorageitene': ('angorageit',),
'angorageiter': ('angorageit',),
'angoragenser': ('angoragenser',),
'angoragensere': ('angoragenser',),
'angoragenseren': ('angoragenser',),
'angoragenserer': ('angoragenser',),
'angoragenserne': ('angoragenser',),
'angorakanin': ('angorakanin',),
'angorakaninen': ('angorakanin',),
'angorakaninene': ('angorakanin',),
'angorakaniner': ('angorakanin',),
'angorakatt': ('angorakatt',),
'angorakatten': ('angorakatt',),
'angorakattene': ('angorakatt',),
'angorakatter': ('angorakatt',),
'angoraull': ('angoraull',),
'angoraulla': ('angoraull',),
'angoraullen': ('angoraull',),
'angoraullene': ('angoraull',),
'angorauller': ('angoraull',),
'angrefrist': ('angrefrist',),
'angrefristen': ('angrefrist',),
'angrefristene': ('angrefrist',),
'angrefrister': ('angrefrist',),
'angrep': ('angrep',),
'angrepa': ('angrep',),
'angrepene': ('angrep',),
'angrepet': ('angrep',),
'angrepsfront': ('angrepsfront',),
'angrepsfronten': ('angrepsfront',),
'angrepsfrontene': ('angrepsfront',),
'angrepsfronter': ('angrepsfront',),
'angrepshandling': ('angrepshandling',),
'angrepshandlinga': ('angrepshandling',),
'angrepshandlingen': ('angrepshandling',),
'angrepshandlingene': ('angrepshandling',),
'angrepshandlinger': ('angrepshandling',),
'angrepskrig': ('angrepskrig',),
'angrepskrigen': ('angrepskrig',),
'angrepskrigene': ('angrepskrig',),
'angrepskriger': ('angrepskrig',),
'angrepsmål': ('angrepsmål',),
'angrepsmåla': ('angrepsmål',),
'angrepsmålene': ('angrepsmål',),
'angrepsmålet': ('angrepsmål',),
'angrepsmåte': ('angrepsmåte',),
'angrepsmåten': ('angrepsmåte',),
'angrepsmåtene': ('angrepsmåte',),
'angrepsmåter': ('angrepsmåte',),
'angrepsplan': ('angrepsplan',),
'angrepsplanen': ('angrepsplan',),
'angrepsplanene': ('angrepsplan',),
'angrepsplaner': ('angrepsplan',),
'angrepspolitikk': ('angrepspolitikk',),
'angrepspolitikken': ('angrepspolitikk',),
'angrepspolitikkene': ('angrepspolitikk',),
'angrepspolitikker': ('angrepspolitikk',),
'angrepsposisjon': ('angrepsposisjon',),
'angrepsposisjonen': ('angrepsposisjon',),
'angrepsposisjonene': ('angrepsposisjon',),
'angrepsposisjoner': ('angrepsposisjon',),
'angrepspunkt': ('angrepspunkt',),
'angrepspunkta': ('angrepspunkt',),
'angrepspunktene': ('angrepspunkt',),
'angrepspunkter': ('angrepspunkt',),
'angrepspunktet': ('angrepspunkt',),
'angrepsspeller': ('angrepsspeller',),
'angrepsspellere': ('angrepsspeller',),
'angrepsspelleren': ('angrepsspeller',),
'angrepsspellerer': ('angrepsspeller',),
'angrepsspellerne': ('angrepsspeller',),
'angrepsspiller': ('angrepsspiller',),
'angrepsspillere': ('angrepsspiller',),
'angrepsspilleren': ('angrepsspiller',),
'angrepsspillerer': ('angrepsspiller',),
'angrepsspillerne': ('angrepsspiller',),
'angrepsspiss': ('angrepsspiss',),
'angrepsspissen': ('angrepsspiss',),
'angrepsspissene': ('angrepsspiss',),
'angrepsspisser': ('angrepsspiss',),
'angriper': ('angriper',),
'angripere': ('angriper',),
'angriperen': ('angriper',),
'angriperer': ('angriper',),
'angriperne': ('angriper',),
'angriperstat': ('angriperstat',),
'angriperstaten': ('angriperstat',),
'angriperstatene': ('angriperstat',),
'angriperstater': ('angriperstat',),
'angst': ('angst',),
'angsten': ('angst',),
'angstene': ('angst',),
'angster': ('angst',),
'angstbiter': ('angstbiter',),
'angstbitere': ('angstbiter',),
'angstbiteren': ('angstbiter',),
'angstbiterer': ('angstbiter',),
'angstbiterne': ('angstbiter',),
'angstfordriver': ('angstfordriver',),
'angstfordrivere': ('angstfordriver',),
'angstfordriveren': ('angstfordriver',),
'angstfordriverer': ('angstfordriver',),
'angstfordriverne': ('angstfordriver',),
'angstneurose': ('angstneurose',),
'angstneurosen': ('angstneurose',),
'angstneurosene': ('angstneurose',),
'angstneuroser': ('angstneurose',),
'angstnevrose': ('angstnevrose',),
'angstnevrosen': ('angstnevrose',),
'angstnevrosene': ('angstnevrose',),
'angstnevroser': ('angstnevrose',),
'angstrop': ('angstrop',),
'angstropa': ('angstrop',),
'angstropene': ('angstrop',),
'angstropet': ('angstrop',),
'angstskrik': ('angstskrik',),
'angstskrika': ('angstskrik',),
'angstskrikene': ('angstskrik',),
'angstskriket': ('angstskrik',),
'angstsvette': ('angstsvette',),
'angstsvetten': ('angstsvette',),
'angstsvettene': ('angstsvette',),
'angstsvetter': ('angstsvette',),
'angsttilstand': ('angsttilstand',),
'angsttilstanden': ('angsttilstand',),
'angsttilstandene': ('angsttilstand',),
'angsttilstander': ('angsttilstand',),
'anhang': ('anhang',),
'anhanga': ('anhang',),
'anhangene': ('anhang',),
'anhanget': ('anhang',),
'anheng': ('anheng',),
'anhenga': ('anheng',),
'anhengene': ('anheng',),
'anhenget': ('anheng',),
'anholdelse': ('anholdelse',),
'anholdelsen': ('anholdelse',),
'anholdelsene': ('anholdelse',),
'anholdelser': ('anholdelse',),
'anhydrid': ('anhydrid',),
'anhydrida': ('anhydrid',),
'anhydridene': ('anhydrid',),
'anhydrider': ('anhydrid',),
'anhydridet': ('anhydrid',),
'anhydritt': ('anhydritt',),
'anhydritten': ('anhydritt',),
'anhydrittene': ('anhydritt',),
'anhydritter': ('anhydritt',),
'anilin': ('anilin',),
'anilina': ('anilin',),
'anilinene': ('anilin',),
'anilinet': ('anilin',),
'anilinblått': ('anilinblått',),
'anilinfarge': ('anilinfarge',),
'anilinfargen': ('anilinfarge',),
'anilinfargene': ('anilinfarge',),
'anilinfarger': ('anilinfarge',),
'anilinsvart': ('anilinsvart',),
'anilintrykk': ('anilintrykk',),
'anilintrykka': ('anilintrykk',),
'anilintrykkene': ('anilintrykk',),
'anilintrykket': ('anilintrykk',),
'animalisme': ('animalisme',),
'animalismen': ('animalisme',),
'animalismene': ('animalisme',),
'animalismer': ('animalisme',),
'animasjon': ('animasjon',),
'animasjonen': ('animasjon',),
'animasjonene': ('animasjon',),
'animasjoner': ('animasjon',),
'animasjonsfilm': ('animasjonsfilm',),
'animasjonsfilmen': ('animasjonsfilm',),
'animasjonsfilmene': ('animasjonsfilm',),
'animasjonsfilmer': ('animasjonsfilm',),
'animatisme': ('animatisme',),
'animatismen': ('animatisme',),
'animatismene': ('animatisme',),
'animatismer': ('animatisme',),
'animatør': ('animatør',),
'animatøren': ('animatør',),
'animatørene': ('animatør',),
'animatører': ('animatør',),
'animisme': ('animisme',),
'animismen': ('animisme',),
'animismene': ('animisme',),
'animismer': ('animisme',),
'animositet': ('animositet',),
'animositeten': ('animositet',),
'animositetene': ('animositet',),
'animositeter': ('animositet',),
'aning': ('aning',),
'aninga': ('aning',),
'aningen': ('aning',),
'aningene': ('aning',),
'aninger': ('aning',),
'anion': ('anion',),
'aniona': ('anion',),
'anionene': ('anion',),
'anioner': ('anion',),
'anionet': ('anion',),
'anis': ('anis',),
'anisen': ('anis',),
'anisene': ('anis',),
'aniser': ('anis',),
'anisbrød': ('anisbrød',),
'anisbrøda': ('anisbrød',),
'anisbrødene': ('anisbrød',),
'anisbrødet': ('anisbrød',),
'anisette': ('anisette',),
'anisetten': ('anisette',),
'anisettene': ('anisette',),
'anisetter': ('anisette',),
'anisfrø': ('anisfrø',),
'anisfrøa': ('anisfrø',),
'anisfrøene': ('anisfrø',),
'anisfrøet': ('anisfrø',),
'aniskringla': ('aniskringle',),
'aniskringle': ('aniskringle',),
'aniskringlen': ('aniskringle',),
'aniskringlene': ('aniskringle',),
'aniskringler': ('aniskringle',),
'anislakris': ('anislakris',),
'anislakrisen': ('anislakris',),
'anislakrisene': ('anislakris',),
'anislakriser': ('anislakris',),
'anislikør': ('anislikør',),
'anislikøren': ('anislikør',),
'anislikørene': ('anislikør',),
'anislikører': ('anislikør',),
'ank': ('ank',),
'anken': ('ank',),
'ankene': ('ank',),
'anker': ('ank',),
'anke': ('anke',),
'anken': ('anke',),
'ankene': ('anke',),
'anker': ('anke',),
'ankedomstol': ('ankedomstol',),
'ankedomstolen': ('ankedomstol',),
'ankedomstolene': ('ankedomstol',),
'ankedomstoler': ('ankedomstol',),
'ankefrist': ('ankefrist',),
'ankefristen': ('ankefrist',),
'ankefristene': ('ankefrist',),
'ankefrister': ('ankefrist',),
'ankeinstans': ('ankeinstans',),
'ankeinstansen': ('ankeinstans',),
'ankeinstansene': ('ankeinstans',),
'ankeinstanser': ('ankeinstans',),
'ankel': ('ankel',),
'ankelen': ('ankel',),
'anklene': ('ankel',),
'ankler': ('ankel',),
'ankelknoke': ('ankelknoke',),
'ankelknoken': ('ankelknoke',),
'ankelknokene': ('ankelknoke',),
'ankelknoker': ('ankelknoke',),
'ankelknute': ('ankelknute',),
'ankelknuten': ('ankelknute',),
'ankelknutene': ('ankelknute',),
'ankelknuter': ('ankelknute',),
'ankelledd': ('ankelledd',),
'ankelledda': ('ankelledd',),
'ankelleddene': ('ankelledd',),
'ankelleddet': ('ankelledd',),
'ankemål': ('ankemål',),
'ankemåla': ('ankemål',),
'ankemålene': ('ankemål',),
'ankemålet': ('ankemål',),
'ankenemnd': ('ankenemnd',),
'ankenemnda': ('ankenemnd',),
'ankenemnden': ('ankenemnd',),
'ankenemndene': ('ankenemnd',),
'ankenemnder': ('ankenemnd',),
'ankepunkt': ('ankepunkt',),
'ankepunkta': ('ankepunkt',),
'ankepunktene': ('ankepunkt',),
'ankepunkter': ('ankepunkt',),
'ankepunktet': ('ankepunkt',),
'anker': ('anker',),
'ankera': ('anker',),
'ankere': ('anker',),
'ankeret': ('anker',),
'ankra': ('anker',),
'ankre': ('anker',),
'ankrene': ('anker',),
'ankret': ('anker',),
'anker': ('anker',),
'ankera': ('anker',),
'ankere': ('anker',),
'ankeret': ('anker',),
'ankra': ('anker',),
'ankre': ('anker',),
'ankrene': ('anker',),
'ankret': ('anker',),
'ankerbøya': ('ankerbøye',),
'ankerbøye': ('ankerbøye',),
'ankerbøyen': ('ankerbøye',),
'ankerbøyene': ('ankerbøye',),
'ankerbøyer': ('ankerbøye',),
'ankerfesta': ('ankerfeste',),
'ankerfeste': ('ankerfeste',),
'ankerfestene': ('ankerfeste',),
'ankerfester': ('ankerfeste',),
'ankerfestet': ('ankerfeste',),
'ankerfligg': ('ankerfligg',),
'ankerfliggen': ('ankerfligg',),
'ankerfliggene': ('ankerfligg',),
'ankerfligger': ('ankerfligg',),
'ankerkjetting': ('ankerkjetting',),
'ankerkjettingen': ('ankerkjetting',),
'ankerkjettingene': ('ankerkjetting',),
'ankerkjettinger': ('ankerkjetting',),
'ankerklo': ('ankerklo',),
'ankerkloa': ('ankerklo',),
'ankerkloen': ('ankerklo',),
'ankerklør': ('ankerklo',),
'ankerklørne': ('ankerklo',),
'ankerkvinna': ('ankerkvinne',),
'ankerkvinne': ('ankerkvinne',),
'ankerkvinnen': ('ankerkvinne',),
'ankerkvinnene': ('ankerkvinne',),
'ankerkvinner': ('ankerkvinne',),
'ankerlanterna': ('ankerlanterne',),
'ankerlanterne': ('ankerlanterne',),
'ankerlanternen': ('ankerlanterne',),
'ankerlanternene': ('ankerlanterne',),
'ankerlanterner': ('ankerlanterne',),
'ankermann': ('ankermann',),
'ankermannen': ('ankermann',),
'ankermenn': ('ankermann',),
'ankermennene': ('ankermann',),
'ankerplass': ('ankerplass',),
'ankerplassen': ('ankerplass',),
'ankerplassene': ('ankerplass',),
'ankerplasser': ('ankerplass',),
'ankerspill': ('ankerspill',),
'ankerspilla': ('ankerspill',),
'ankerspillene': ('ankerspill',),
'ankerspillet': ('ankerspill',),
'ankesak': ('ankesak',),
'ankesaka': ('ankesak',),
'ankesaken': ('ankesak',),
'ankesakene': ('ankesak',),
'ankesaker': ('ankesak',),
'ankesum': ('ankesum',),
'ankesummen': ('ankesum',),
'ankesummene': ('ankesum',),
'ankesummer': ('ankesum',),
'anklage': ('anklage',),
'anklagen': ('anklage',),
'anklagene': ('anklage',),
'anklager': ('anklage',),
'anklagebenk': ('anklagebenk',),
'anklagebenken': ('anklagebenk',),
'anklagebenkene': ('anklagebenk',),
'anklagebenker': ('anklagebenk',),
'anklageprinsipp': ('anklageprinsipp',),
'anklageprinsippa': ('anklageprinsipp',),
'anklageprinsippene': ('anklageprinsipp',),
'anklageprinsipper': ('anklageprinsipp',),
'anklageprinsippet': ('anklageprinsipp',),
'anklagepunkt': ('anklagepunkt',),
'anklagepunkta': ('anklagepunkt',),
'anklagepunktene': ('anklagepunkt',),
'anklagepunkter': ('anklagepunkt',),
'anklagepunktet': ('anklagepunkt',),
'anklager': ('anklager',),
'anklagere': ('anklager',),
'anklageren': ('anklager',),
'anklagerer': ('anklager',),
'anklagerne': ('anklager',),
'anklang': ('anklang',),
'anklangen': ('anklang',),
'anklangene': ('anklang',),
'anklanger': ('anklang',),
'ankomst': ('ankomst',),
'ankomsten': ('ankomst',),
'ankomstene': ('ankomst',),
'ankomster': ('ankomst',),
'ankomstdag': ('ankomstdag',),
'ankomstdagen': ('ankomstdag',),
'ankomstdagene': ('ankomstdag',),
'ankomstdager': ('ankomstdag',),
'ankomsthall': ('ankomsthall',),
'ankomsthallen': ('ankomsthall',),
'ankomsthallene': ('ankomsthall',),
'ankomsthaller': ('ankomsthall',),
'ankomsthamn': ('ankomsthamn',),
'ankomsthamna': ('ankomsthamn',),
'ankomsthamnen': ('ankomsthamn',),
'ankomsthamnene': ('ankomsthamn',),
'ankomsthamner': ('ankomsthamn',),
'ankomsthavn': ('ankomsthavn',),
'ankomsthavna': ('ankomsthavn',),
'ankomsthavnen': ('ankomsthavn',),
'ankomsthavnene': ('ankomsthavn',),
'ankomsthavner': ('ankomsthavn',),
'ankomststed': ('ankomststed',),
'ankomststedene': ('ankomststed',),
'ankomststeder': ('ankomststed',),
'ankomststedet': ('ankomststed',),
'ankomsttavla': ('ankomsttavle',),
'ankomsttavle': ('ankomsttavle',),
'ankomsttavlen': ('ankomsttavle',),
'ankomsttavlene': ('ankomsttavle',),
'ankomsttavler': ('ankomsttavle',),
'ankomsttid': ('ankomsttid',),
'ankomsttida': ('ankomsttid',),
'ankomsttiden': ('ankomsttid',),
'ankomsttidene': ('ankomsttid',),
'ankomsttider': ('ankomsttid',),
'ankring': ('ankring',),
'ankringa': ('ankring',),
'ankringen': ('ankring',),
'ankringene': ('ankring',),
'ankringer': ('ankring',),
'ankringsplass': ('ankringsplass',),
'ankringsplassen': ('ankringsplass',),
'ankringsplassene': ('ankringsplass',),
'ankringsplasser': ('ankringsplass',),
'anledning': ('anledning',),
'anledninga': ('anledning',),
'anledningen': ('anledning',),
'anledningene': ('anledning',),
'anledninger': ('anledning',),
'anlegg': ('anlegg',),
'anlegga': ('anlegg',),
'anleggene': ('anlegg',),
'anlegget': ('anlegg',),
'anleggsaktiva': ('anleggsaktivum',),
'anleggsaktivaene': ('anleggsaktivum',),
'anleggsaktivene': ('anleggsaktivum',),
'anleggsaktiver': ('anleggsaktivum',),
'anleggsaktivum': ('anleggsaktivum',),
'anleggsaktivumet': ('anleggsaktivum',),
'anleggsarbeid': ('anleggsarbeid',),
'anleggsarbeida': ('anleggsarbeid',),
'anleggsarbeidene': ('anleggsarbeid',),
'anleggsarbeider': ('anleggsarbeid',),
'anleggsarbeidet': ('anleggsarbeid',),
'anleggsarbeider': ('anleggsarbeider',),
'anleggsarbeidere': ('anleggsarbeider',),
'anleggsarbeideren': ('anleggsarbeider',),
'anleggsarbeiderer': ('anleggsarbeider',),
'anleggsarbeiderne': ('anleggsarbeider',),
'anleggsgartner': ('anleggsgartner',),
'anleggsgartnere': ('anleggsgartner',),
'anleggsgartneren': ('anleggsgartner',),
'anleggsgartnerer': ('anleggsgartner',),
'anleggsgartnerne': ('anleggsgartner',),
'anleggskapital': ('anleggskapital',),
'anleggskapitalen': ('anleggskapital',),
'anleggskapitalene': ('anleggskapital',),
'anleggskapitaler': ('anleggskapital',),
'anleggskostnad': ('anleggskostnad',),
'anleggskostnaden': ('anleggskostnad',),
'anleggskostnadene': ('anleggskostnad',),
'anleggskostnader': ('anleggskostnad',),
'anleggsmaskin': ('anleggsmaskin',),
'anleggsmaskina': ('anleggsmaskin',),
'anleggsmaskinen': ('anleggsmaskin',),
'anleggsmaskinene': ('anleggsmaskin',),
'anleggsmaskiner': ('anleggsmaskin',),
'anleggsmiddel': ('anleggsmiddel',),
'anleggsmiddelet': ('anleggsmiddel',),
'anleggsmidla': ('anleggsmiddel',),
'anleggsmidlene': ('anleggsmiddel',),
'anleggsmidler': ('anleggsmiddel',),
'anleggsmidlet': ('anleggsmiddel',),
'anleggspreg': ('anleggspreg',),
'anleggsprega': ('anleggspreg',),
'anleggspregene': ('anleggspreg',),
'anleggspreget': ('anleggspreg',),
'anleggsslusk': ('anleggsslusk',),
'anleggsslusken': ('anleggsslusk',),
'anleggssluskene': ('anleggsslusk',),
'anleggsslusker': ('anleggsslusk',),
'anleggsvirksomhet': ('anleggsvirksomhet',),
'anleggsvirksomheta': ('anleggsvirksomhet',),
'anleggsvirksomheten': ('anleggsvirksomhet',),
'anleggsvirksomhetene': ('anleggsvirksomhet',),
'anleggsvirksomheter': ('anleggsvirksomhet',),
'anliggende': ('anliggende',),
'anliggendene': ('anliggende',),
'anliggender': ('anliggende',),
'anliggendet': ('anliggende',),
'anløp': ('anløp',),
'anløpa': ('anløp',),
'anløpene': ('anløp',),
'anløpet': ('anløp',),
'anløpshamn': ('anløpshamn',),
'anløpshamna': ('anløpshamn',),
'anløpshamnen': ('anløpshamn',),
'anløpshamnene': ('anløpshamn',),
'anløpshamner': ('anløpshamn',),
'anløpshavn': ('anløpshavn',),
'anløpshavna': ('anløpshavn',),
'anløpshavnen': ('anløpshavn',),
'anløpshavnene': ('anløpshavn',),
'anløpshavner': ('anløpshavn',),
'anløpssted': ('anløpssted',),
'anløpsstedene': ('anløpssted',),
'anløpssteder': ('anløpssted',),
'anløpsstedet': ('anløpssted',),
'anløpstid': ('anløpstid',),
'anløpstida': ('anløpstid',),
'anløpstiden': ('anløpstid',),
'anløpstidene': ('anløpstid',),
'anløpstider': ('anløpstid',),
'anmarsj': ('anmarsj',),
'anmarsjen': ('anmarsj',),
'anmarsjene': ('anmarsj',),
'anmarsjer': ('anmarsj',),
'anmasselse': ('anmasselse',),
'anmasselsen': ('anmasselse',),
'anmasselsene': ('anmasselse',),
'anmasselser': ('anmasselse',),
'anmeldelse': ('anmeldelse',),
'anmeldelsen': ('anmeldelse',),
'anmeldelsene': ('anmeldelse',),
'anmeldelser': ('anmeldelse',),
'anmeldelsesfrist': ('anmeldelsesfrist',),
'anmeldelsesfristen': ('anmeldelsesfrist',),
'anmeldelsesfristene': ('anmeldelsesfrist',),
'anmeldelsesfrister': ('anmeldelsesfrist',),
'anmelder': ('anmelder',),
'anmeldere': ('anmelder',),
'anmelderen': ('anmelder',),
'anmelderer': ('anmelder',),
'anmelderne': ('anmelder',),
'anmeldereksemplar': ('anmeldereksemplar',),
'anmeldereksemplara': ('anmeldereksemplar',),
'anmeldereksemplarene': ('anmeldereksemplar',),
'anmeldereksemplarer': ('anmeldereksemplar',),
'anmeldereksemplaret': ('anmeldereksemplar',),
'anmeldervirksomhet': ('anmeldervirksomhet',),
'anmeldervirksomheta': ('anmeldervirksomhet',),
'anmeldervirksomheten': ('anmeldervirksomhet',),
'anmeldervirksomhetene': ('anmeldervirksomhet',),
'anmeldervirksomheter': ('anmeldervirksomhet',),
'anmerkning': ('anmerkning',),
'anmerkninga': ('anmerkning',),
'anmerkningen': ('anmerkning',),
'anmerkningene': ('anmerkning',),
'anmerkninger': ('anmerkning',),
'anmodning': ('anmodning',),
'anmodninga': ('anmodning',),
'anmodningen': ('anmodning',),
'anmodningene': ('anmodning',),
'anmodninger': ('anmodning',),
'annal': ('annal',),
'annalen': ('annal',),
'annalene': ('annal',),
'annaler': ('annal',),
'annalist': ('annalist',),
'annalisten': ('annalist',),
'annalistene': ('annalist',),
'annalister': ('annalist',),
'anneks': ('anneks',),
'anneksa': ('anneks',),
'anneksene': ('anneks',),
'annekser': ('anneks',),
'annekset': ('anneks',),
'anneksbygning': ('anneksbygning',),
'anneksbygninga': ('anneksbygning',),
'anneksbygningen': ('anneksbygning',),
'anneksbygningene': ('anneksbygning',),
'anneksbygninger': ('anneksbygning',),
'anneksjon': ('anneksjon',),
'anneksjonen': ('anneksjon',),
'anneksjonene': ('anneksjon',),
'anneksjoner': ('anneksjon',),
'annekskirka': ('annekskirke',),
'annekskirke': ('annekskirke',),
'annekskirken': ('annekskirke',),
'annekskirkene': ('annekskirke',),
'annekskirker': ('annekskirke',),
'annekskjerka': ('annekskjerke',),
'annekskjerke': ('annekskjerke',),
'annekskjerken': ('annekskjerke',),
'annekskjerkene': ('annekskjerke',),
'annekskjerker': ('annekskjerke',),
'annekssogn': ('annekssogn',),
'annekssogna': ('annekssogn',),
'annekssognene': ('annekssogn',),
'annekssognet': ('annekssogn',),
'annekssokn': ('annekssokn',),
'annekssokna': ('annekssokn',),
'annekssoknen': ('annekssokn',),
'annekssoknene': ('annekssokn',),
'annekssokner': ('annekssokn',),
'annekssoknet': ('annekssokn',),
'annektering': ('annektering',),
'annekteringa': ('annektering',),
'annekteringen': ('annektering',),
'annekteringene': ('annektering',),
'annekteringer': ('annektering',),
'annendag': ('annendag',),
'annendagen': ('annendag',),
'annendagene': ('annendag',),
'annendager': ('annendag',),
'annenfiolin': ('annenfiolin',),
'annenfiolinen': ('annenfiolin',),
'annenfiolinene': ('annenfiolin',),
'annenfioliner': ('annenfiolin',),
'annengradsligning': ('annengradsligning',),
'annengradsligninga': ('annengradsligning',),
'annengradsligningen': ('annengradsligning',),
'annengradsligningene': ('annengradsligning',),
'annengradsligninger': ('annengradsligning',),
'annengradslikning': ('annengradslikning',),
'annengradslikninga': ('annengradslikning',),
'annengradslikningen': ('annengradslikning',),
'annengradslikningene': ('annengradslikning',),
'annengradslikninger': ('annengradslikning',),
'annenmann': ('annenmann',),
'annenmannen': ('annenmann',),
'annenmannene': ('annenmann',),
'annenmanner': ('annenmann',),
'annenmaskinist': ('annenmaskinist',),
'annenmaskinisten': ('annenmaskinist',),
'annenmaskinistene': ('annenmaskinist',),
'annenmaskinister': ('annenmaskinist',),
'annenplass': ('annenplass',),
'annenplassen': ('annenplass',),
'annenplassene': ('annenplass',),
'annenplasser': ('annenplass',),
'annenprioritet': ('annenprioritet',),
'annenprioriteten': ('annenprioritet',),
'annenprioritetene': ('annenprioritet',),
'annenprioriteter': ('annenprioritet',),
'annensortering': ('annensortering',),
'annensorteringa': ('annensortering',),
'annensorteringen': ('annensortering',),
'annensorteringene': ('annensortering',),
'annensorteringer': ('annensortering',),
'annenstemme': ('annenstemme',),
'annenstemmen': ('annenstemme',),
'annenstemmene': ('annenstemme',),
'annenstemmer': ('annenstemme',),
'annenstyrmann': ('annenstyrmann',),
'annenstyrmannen': ('annenstyrmann',),
'annenstyrmenn': ('annenstyrmann',),
'annenstyrmennene': ('annenstyrmann',),
'annerledestroende': ('annerledestroende',),
'annerledestroende': ('annerledestroende',),
'annetgir': ('annetgir',),
'annetgira': ('annetgir',),
'annetgirene': ('annetgir',),
'annetgiret': ('annetgir',),
'annleistroende': ('annleistroende',),
'annonsa': ('annonse',),
'annonse': ('annonse',),
'annonsen': ('annonse',),
'annonsene': ('annonse',),
'annonser': ('annonse',),
'annonseakkvisitør': ('annonseakkvisitør',),
'annonseakkvisitøren': ('annonseakkvisitør',),
'annonseakkvisitørene': ('annonseakkvisitør',),
'annonseakkvisitører': ('annonseakkvisitør',),
'annonsebyrå': ('annonsebyrå',),
'annonsebyråa': ('annonsebyrå',),
'annonsebyråene': ('annonsebyrå',),
'annonsebyråer': ('annonsebyrå',),
'annonsebyrået': ('annonsebyrå',),
'annonsekampanje': ('annonsekampanje',),
'annonsekampanjen': ('annonsekampanje',),
'annonsekampanjene': ('annonsekampanje',),
'annonsekampanjer': ('annonsekampanje',),
'annonsesida': ('annonseside',),
'annonseside': ('annonseside',),
'annonsesiden': ('annonseside',),
'annonsesidene': ('annonseside',),
'annonsesider': ('annonseside',),
'annonsespalta': ('annonsespalte',),
'annonsespalte': ('annonsespalte',),
'annonsespalten': ('annonsespalte',),
'annonsespaltene': ('annonsespalte',),
'annonsespalter': ('annonsespalte',),
'annonsør': ('annonsør',),
'annonsøren': ('annonsør',),
'annonsørene': ('annonsør',),
'annonsører': ('annonsør',),
'annuitet': ('annuitet',),
'annuiteten': ('annuitet',),
'annuitetene': ('annuitet',),
'annuiteter': ('annuitet',),
'annuitetslån': ('annuitetslån',),
'annuitetslåna': ('annuitetslån',),
'annuitetslånene': ('annuitetslån',),
'annuitetslånet': ('annuitetslån',),
'annuitetsregning': ('annuitetsregning',),
'annuitetsregninga': ('annuitetsregning',),
'annuitetsregningen': ('annuitetsregning',),
'annuitetsregningene': ('annuitetsregning',),
'annuitetsregninger': ('annuitetsregning',),
'annuitetsrekning': ('annuitetsrekning',),
'annuitetsrekninga': ('annuitetsrekning',),
'annuitetsrekningen': ('annuitetsrekning',),
'annuitetsrekningene': ('annuitetsrekning',),
'annuitetsrekninger': ('annuitetsrekning',),
'annuitetstabell': ('annuitetstabell',),
'annuitetstabellen': ('annuitetstabell',),
'annuitetstabellene': ('annuitetstabell',),
'annuitetstabeller': ('annuitetstabell',),
'annua': ('annuum',),
'annuaene': ('annuum',),
'annuum': ('annuum',),
'annuumet': ('annuum',),
'anode': ('anode',),
'anoden': ('anode',),
'anodene': ('anode',),
'anoder': ('anode',),
'anodebatteri': ('anodebatteri',),
'anodebatteria': ('anodebatteri',),
'anodebatteriene': ('anodebatteri',),
'anodebatterier': ('anodebatteri',),
'anodebatteriet': ('anodebatteri',),
'anodespenning': ('anodespenning',),
'anodespenninga': ('anodespenning',),
'anodespenningen': ('anodespenning',),
'anodespenningene': ('anodespenning',),
'anodespenninger': ('anodespenning',),
'anodestrøm': ('anodestrøm',),
'anodestrømmen': ('anodestrøm',),
'anodestrømmene': ('anodestrøm',),
'anodestrømmer': ('anodestrøm',),
'anomali': ('anomali',),
'anomalien': ('anomali',),
'anomaliene': ('anomali',),
'anomalier': ('anomali',),
'anonym': ('anonym',),
'anonyma': ('anonym',),
'anonymene': ('anonym',),
'anonymer': ('anonym',),
'anonymet': ('anonym',),
'anonymitet': ('anonymitet',),
'anonymiteten': ('anonymitet',),
'anonymitetene': ('anonymitet',),
'anonymiteter': ('anonymitet',),
'anorakk': ('anorakk',),
'anorakken': ('anorakk',),
'anorakkene': ('anorakk',),
'anorakker': ('anorakk',),
'anorakkhetta': ('anorakkhette',),
'anorakkhette': ('anorakkhette',),
'anorakkhetten': ('anorakkhette',),
'anorakkhettene': ('anorakkhette',),
'anorakkhetter': ('anorakkhette',),
'anordning': ('anordning',),
'anordninga': ('anordning',),
'anordningen': ('anordning',),
'anordningene': ('anordning',),
'anordninger': ('anordning',),
'anoreksi': ('anoreksi',),
'anoreksien': ('anoreksi',),
'anoreksiene': ('anoreksi',),
'anoreksier': ('anoreksi',),
'anorektiker': ('anorektiker',),
'anorektikere': ('anorektiker',),
'anorektikeren': ('anorektiker',),
'anorektikerer': ('anorektiker',),
'anorektikerne': ('anorektiker',),
'anorexia nervosa': ('anorexia nervosa',),
'anretning': ('anretning',),
'anretninga': ('anretning',),
'anretningen': ('anretning',),
'anretningene': ('anretning',),
'anretninger': ('anretning',),
'anretningsbord': ('anretningsbord',),
'anretningsborda': ('anretningsbord',),
'anretningsbordene': ('anretningsbord',),
'anretningsborder': ('anretningsbord',),
'anretningsbordet': ('anretningsbord',),
'anretningsfat': ('anretningsfat',),
'anretningsfata': ('anretningsfat',),
'anretningsfatene': ('anretningsfat',),
'anretningsfater': ('anretningsfat',),
'anretningsfatet': ('anretningsfat',),
'anretningsrom': ('anretningsrom',),
'anretningsromma': ('anretningsrom',),
'anretningsrommene': ('anretningsrom',),
'anretningsrommet': ('anretningsrom',),
'anrettelse': ('anrettelse',),
'anrettelsen': ('anrettelse',),
'anrettelsene': ('anrettelse',),
'anrettelser': ('anrettelse',),
'anriking': ('anriking',),
'anrikinga': ('anriking',),
'anrikingen': ('anriking',),
'anrikingene': ('anriking',),
'anrikinger': ('anriking',),
'anrikning': ('anrikning',),
'anrikninga': ('anrikning',),
'anrikningen': ('anrikning',),
'anrikningene': ('anrikning',),
'anrikninger': ('anrikning',),
'anrop': ('anrop',),
'anropa': ('anrop',),
'anropene': ('anrop',),
'anropet': ('anrop',),
'ans': ('ans',),
'ansa': ('ans',),
'ansen': ('ans',),
'ansene': ('ans',),
'anser': ('ans',),
'anset': ('ans',),
'ansamling': ('ansamling',),
'ansamlinga': ('ansamling',),
'ansamlingen': ('ansamling',),
'ansamlingene': ('ansamling',),
'ansamlinger': ('ansamling',),
'ansats': ('ansats',),
'ansatsen': ('ansats',),
'ansatsene': ('ansats',),
'ansatser': ('ansats',),
'anseelse': ('anseelse',),
'anseelsen': ('anseelse',),
'anseelsene': ('anseelse',),
'anseelser': ('anseelse',),
'ansettelse': ('ansettelse',),
'ansettelsen': ('ansettelse',),
'ansettelsene': ('ansettelse',),
'ansettelser': ('ansettelse',),
'ansettelsesmyndighet': ('ansettelsesmyndighet',),
'ansettelsesmyndigheta': ('ansettelsesmyndighet',),
'ansettelsesmyndigheten': ('ansettelsesmyndighet',),
'ansettelsesmyndighetene': ('ansettelsesmyndighet',),
'ansettelsesmyndigheter': ('ansettelsesmyndighet',),
'ansettelsesrett': ('ansettelsesrett',),
'ansettelsesretten': ('ansettelsesrett',),
'ansettelsesrettene': ('ansettelsesrett',),
'ansettelsesretter': ('ansettelsesrett',),
'ansettelsesråd': ('ansettelsesråd',),
'ansettelsesråda': ('ansettelsesråd',),
'ansettelsesrådene': ('ansettelsesråd',),
'ansettelsesrådet': ('ansettelsesråd',),
'ansettelsesstopp': ('ansettelsesstopp',),
'ansettelsesstoppa': ('ansettelsesstopp',),
'ansettelsesstoppen': ('ansettelsesstopp',),
'ansettelsesstoppene': ('ansettelsesstopp',),
'ansettelsesstoppet': ('ansettelsesstopp',),
'ansettelsesvilkår': ('ansettelsesvilkår',),
'ansettelsesvilkåra': ('ansettelsesvilkår',),
'ansettelsesvilkårene': ('ansettelsesvilkår',),
'ansettelsesvilkåret': ('ansettelsesvilkår',),
'ansiennitet': ('ansiennitet',),
'ansienniteten': ('ansiennitet',),
'ansiennitetene': ('ansiennitet',),
'ansienniteter': ('ansiennitet',),
'ansikt': ('ansikt',),
'ansikta': ('ansikt',),
'ansiktene': ('ansikt',),
'ansikter': ('ansikt',),
'ansiktet': ('ansikt',),
'ansiktsbehandling': ('ansiktsbehandling',),
'ansiktsbehandlinga': ('ansiktsbehandling',),
'ansiktsbehandlingen': ('ansiktsbehandling',),
'ansiktsbehandlingene': ('ansiktsbehandling',),
'ansiktsbehandlinger': ('ansiktsbehandling',),
'ansiktsdrag': ('ansiktsdrag',),
'ansiktsdraga': ('ansiktsdrag',),
'ansiktsdragene': ('ansiktsdrag',),
'ansiktsdraget': ('ansiktsdrag',),
'ansiktsfarge': ('ansiktsfarge',),
'ansiktsfargen': ('ansiktsfarge',),
'ansiktsfargene': ('ansiktsfarge',),
'ansiktsfarger': ('ansiktsfarge',),
'ansiktsform': ('ansiktsform',),
'ansiktsforma': ('ansiktsform',),
'ansiktsformen': ('ansiktsform',),
'ansiktsformene': ('ansiktsform',),
'ansiktsformer': ('ansiktsform',),
'ansiktsløftning': ('ansiktsløftning',),
'ansiktsløftninga': ('ansiktsløftning',),
'ansiktsløftningen': ('ansiktsløftning',),
'ansiktsløftningene': ('ansiktsløftning',),
'ansiktsløftninger': ('ansiktsløftning',),
'ansiktsmaska': ('ansiktsmaske',),
'ansiktsmaske': ('ansiktsmaske',),
'ansiktsmasken': ('ansiktsmaske',),
'ansiktsmaskene': ('ansiktsmaske',),
'ansiktsmasker': ('ansiktsmaske',),
'ansiktsmassasje': ('ansiktsmassasje',),
'ansiktsmassasjen': ('ansiktsmassasje',),
'ansiktsmassasjene': ('ansiktsmassasje',),
'ansiktsmassasjer': ('ansiktsmassasje',),
'ansiktspleia': ('ansiktspleie',),
'ansiktspleie': ('ansiktspleie',),
'ansiktspleien': ('ansiktspleie',),
'ansiktspleiene': ('ansiktspleie',),
'ansiktspleier': ('ansiktspleie',),
'ansiktsprofil': ('ansiktsprofil',),
'ansiktsprofilen': ('ansiktsprofil',),
'ansiktsprofilene': ('ansiktsprofil',),
'ansiktsprofiler': ('ansiktsprofil',),
'ansiktstrekk': ('ansiktstrekk',),
'ansiktstrekka': ('ansiktstrekk',),
'ansiktstrekkene': ('ansiktstrekk',),
'ansiktstrekket': ('ansiktstrekk',),
'ansiktsuttrykk': ('ansiktsuttrykk',),
'ansiktsuttrykka': ('ansiktsuttrykk',),
'ansiktsuttrykkene': ('ansiktsuttrykk',),
'ansiktsuttrykket': ('ansiktsuttrykk',),
'ansjos': ('ansjos',),
'ansjosen': ('ansjos',),
'ansjosene': ('ansjos',),
'ansjoser': ('ansjos',),
'ansjosboks': ('ansjosboks',),
'ansjosboksen': ('ansjosboks',),
'ansjosboksene': ('ansjosboks',),
'ansjosbokser': ('ansjosboks',),
'ansjosbrisling': ('ansjosbrisling',),
'ansjosbrislingen': ('ansjosbrisling',),
'ansjosbrislingene': ('ansjosbrisling',),
'ansjosbrislinger': ('ansjosbrisling',),
'ansjosfilet': ('ansjosfilet',),
'ansjosfileten': ('ansjosfilet',),
'ansjosfiletene': ('ansjosfilet',),
'ansjosfileter': ('ansjosfilet',),
'anskaffelse': ('anskaffelse',),
'anskaffelsen': ('anskaffelse',),
'anskaffelsene': ('anskaffelse',),
'anskaffelser': ('anskaffelse',),
'anskaffelsesomkostning': ('anskaffelsesomkostning',),
'anskaffelsesomkostninga': ('anskaffelsesomkostning',),
'anskaffelsesomkostningen': ('anskaffelsesomkostning',),
'anskaffelsesomkostningene': ('anskaffelsesomkostning',),
'anskaffelsesomkostninger': ('anskaffelsesomkostning',),
'anskaffelsespris': ('anskaffelsespris',),
'anskaffelsesprisen': ('anskaffelsespris',),
'anskaffelsesprisene': ('anskaffelsespris',),
'anskaffelsespriser': ('anskaffelsespris',),
'anskaffelsesverdi': ('anskaffelsesverdi',),
'anskaffelsesverdien': ('anskaffelsesverdi',),
'anskaffelsesverdiene': ('anskaffelsesverdi',),
'anskaffelsesverdier': ('anskaffelsesverdi',),
'anskott': ('anskott',),
'anskotta': ('anskott',),
'anskottene': ('anskott',),
'anskottet': ('anskott',),
'anskrik': ('anskrik',),
'anskrika': ('anskrik',),
'anskrikene': ('anskrik',),
'anskriket': ('anskrik',),
'anskudd': ('anskudd',),
'anskudda': ('anskudd',),
'anskuddene': ('anskudd',),
'anskuddet': ('anskudd',),
'anskuelse': ('anskuelse',),
'anskuelsen': ('anskuelse',),
'anskuelsene': ('anskuelse',),
'anskuelser': ('anskuelse',),
'anskuelsesevna': ('anskuelsesevne',),
'anskuelsesevne': ('anskuelsesevne',),
'anskuelsesevnen': ('anskuelsesevne',),
'anskuelsesevnene': ('anskuelsesevne',),
'anskuelsesevner': ('anskuelsesevne',),
'anskuelsesform': ('anskuelsesform',),
'anskuelsesforma': ('anskuelsesform',),
'anskuelsesformen': ('anskuelsesform',),
'anskuelsesformene': ('anskuelsesform',),
'anskuelsesformer': ('anskuelsesform',),
'anskuelsesmåte': ('anskuelsesmåte',),
'anskuelsesmåten': ('anskuelsesmåte',),
'anskuelsesmåtene': ('anskuelsesmåte',),
'anskuelsesmåter': ('anskuelsesmåte',),
'anskuelsesundervisning': ('anskuelsesundervisning',),
'anskuelsesundervisninga': ('anskuelsesundervisning',),
'anskuelsesundervisningen': ('anskuelsesundervisning',),
'anskuelsesundervisningene': ('anskuelsesundervisning',),
'anskuelsesundervisninger': ('anskuelsesundervisning',),
'anslag': ('anslag',),
'anslaga': ('anslag',),
'anslagene': ('anslag',),
'anslaget': ('anslag',),
'anslagshastighet': ('anslagshastighet',),
'anslagshastigheta': ('anslagshastighet',),
'anslagshastigheten': ('anslagshastighet',),
'anslagshastighetene': ('anslagshastighet',),
'anslagshastigheter': ('anslagshastighet',),
'anslagskraft': ('anslagskraft',),
'anslagskrafta': ('anslagskraft',),
'anslagskraften': ('anslagskraft',),
'anslagskreftene': ('anslagskraft',),
'anslagskrefter': ('anslagskraft',),
'anspennelse': ('anspennelse',),
'anspennelsen': ('anspennelse',),
'anspennelsene': ('anspennelse',),
'anspennelser': ('anspennelse',),
'anspenthet': ('anspenthet',),
'anspentheta': ('anspenthet',),
'anspentheten': ('anspenthet',),
'anspenthetene': ('anspenthet',),
'anspentheter': ('anspenthet',),
'anstalt': ('anstalt',),
'anstalten': ('anstalt',),
'anstaltene': ('anstalt',),
'anstalter': ('anstalt',),
'anstalthusholdning': ('anstalthusholdning',),
'anstalthusholdninga': ('anstalthusholdning',),
'anstalthusholdningen': ('anstalthusholdning',),
'anstalthusholdningene': ('anstalthusholdning',),
'anstalthusholdninger': ('anstalthusholdning',),
'anstaltmaker': ('anstaltmaker',),
'anstaltmakere': ('anstaltmaker',),
'anstaltmakeren': ('anstaltmaker',),
'anstaltmakerer': ('anstaltmaker',),
'anstaltmakerne': ('anstaltmaker',),
'anstaltmakeri': ('anstaltmakeri',),
'anstaltmakeria': ('anstaltmakeri',),
'anstaltmakeriene': ('anstaltmakeri',),
'anstaltmakerier': ('anstaltmakeri',),
'anstaltmakeriet': ('anstaltmakeri',),
'anstand': ('anstand',),
'anstanden': ('anstand',),
'anstandene': ('anstand',),
'anstander': ('anstand',),
'anstendighet': ('anstendighet',),
'anstendigheta': ('anstendighet',),
'anstendigheten': ('anstendighet',),
'anstendighetene': ('anstendighet',),
'anstendigheter': ('anstendighet',),
'anstendighetsfølelse': ('anstendighetsfølelse',),
'anstendighetsfølelsen': ('anstendighetsfølelse',),
'anstendighetsfølelsene': ('anstendighetsfølelse',),
'anstendighetsfølelser': ('anstendighetsfølelse',),
'anstendighetskjensla': ('anstendighetskjensle',),
'anstendighetskjensle': ('anstendighetskjensle',),
'anstendighetskjenslen': ('anstendighetskjensle',),
'anstendighetskjenslene': ('anstendighetskjensle',),
'anstendighetskjensler': ('anstendighetskjensle',),
'anstrengelse': ('anstrengelse',),
'anstrengelsen': ('anstrengelse',),
'anstrengelsene': ('anstrengelse',),
'anstrengelser': ('anstrengelse',),
'anstrøk': ('anstrøk',),
'anstrøka': ('anstrøk',),
'anstrøkene': ('anstrøk',),
'anstrøket': ('anstrøk',),
'anstøt': ('anstøt',),
'anstøta': ('anstøt',),
'anstøtene': ('anstøt',),
'anstøtet': ('anstøt',),
'anstøtsstein': ('anstøtsstein',),
'anstøtssteinen': ('anstøtsstein',),
'anstøtssteinene': ('anstøtsstein',),
'anstøtssteiner': ('anstøtsstein',),
'ansvar': ('ansvar',),
'ansvara': ('ansvar',),
'ansvarene': ('ansvar',),
'ansvaret': ('ansvar',),
'ansvarsforhold': ('ansvarsforhold',),
'ansvarsforholda': ('ansvarsforhold',),
'ansvarsforholdene': ('ansvarsforhold',),
'ansvarsforholdet': ('ansvarsforhold',),
'ansvarsforsikring': ('ansvarsforsikring',),
'ansvarsforsikringa': ('ansvarsforsikring',),
'ansvarsforsikringen': ('ansvarsforsikring',),
'ansvarsforsikringene': ('ansvarsforsikring',),
'ansvarsforsikringer': ('ansvarsforsikring',),
'ansvarsfølelse': ('ansvarsfølelse',),
'ansvarsfølelsen': ('ansvarsfølelse',),
'ansvarsfølelsene': ('ansvarsfølelse',),
'ansvarsfølelser': ('ansvarsfølelse',),
'ansvarsområda': ('ansvarsområde',),
'ansvarsområde': ('ansvarsområde',),
'ansvarsområdene': ('ansvarsområde',),
'ansvarsområder': ('ansvarsområde',),
'ansvarsområdet': ('ansvarsområde',),
'ansøker': ('ansøker',),
'ansøkere': ('ansøker',),
'ansøkeren': ('ansøker',),
'ansøkerer': ('ansøker',),
'ansøkerne': ('ansøker',),
'ansøkning': ('ansøkning',),
'ansøkninga': ('ansøkning',),
'ansøkningen': ('ansøkning',),
'ansøkningene': ('ansøkning',),
'ansøkninger': ('ansøkning',),
'ansøkningsskjema': ('ansøkningsskjema',),
'ansøkningsskjemaene': ('ansøkningsskjema',),
'ansøkningsskjemaer': ('ansøkningsskjema',),
'ansøkningsskjemaet': ('ansøkningsskjema',),
'antabus': ('antabus',),
'antabusen': ('antabus',),
'antabusene': ('antabus',),
'antabuser': ('antabus',),
'antabuskur': ('antabuskur',),
'antabuskuren': ('antabuskur',),
'antabuskurene': ('antabuskur',),
'antabuskurer': ('antabuskur',),
'antabuspilla': ('antabuspille',),
'antabuspille': ('antabuspille',),
'antabuspillen': ('antabuspille',),
'antabuspillene': ('antabuspille',),
'antabuspiller': ('antabuspille',),
'antabustablett': ('antabustablett',),
'antabustabletten': ('antabustablett',),
'antabustablettene': ('antabustablett',),
'antabustabletter': ('antabustablett',),
'antagonisme': ('antagonisme',),
'antagonismen': ('antagonisme',),
'antagonismene': ('antagonisme',),
'antagonismer': ('antagonisme',),
'antagonist': ('antagonist',),
'antagonisten': ('antagonist',),
'antagonistene': ('antagonist',),
'antagonister': ('antagonist',),
'antakelse': ('antakelse',),
'antakelsen': ('antakelse',),
'antakelsene': ('antakelse',),
'antakelser': ('antakelse',),
'antall': ('antall',),
'antalla': ('antall',),
'antallene': ('antall',),
'antallet': ('antall',),
'antegnelse': ('antegnelse',),
'antegnelsen': ('antegnelse',),
'antegnelsene': ('antegnelse',),
'antegnelser': ('antegnelse',),
'antegning': ('antegning',),
'antegninga': ('antegning',),
'antegningen': ('antegning',),
'antegningene': ('antegning',),
'antegninger': ('antegning',),
'antemensala': ('antemensale',),
'antemensale': ('antemensale',),
'antemensalene': ('antemensale',),
'antemensaler': ('antemensale',),
'antemensalet': ('antemensale',),
'antenna': ('antenne',),
'antenne': ('antenne',),
'antennen': ('antenne',),
'antennene': ('antenne',),
'antenner': ('antenne',),
'antennekobling': ('antennekobling',),
'antennekoblinga': ('antennekobling',),
'antennekoblingen': ('antennekobling',),
'antennekoblingene': ('antennekobling',),
'antennekoblinger': ('antennekobling',),
'antennekopling': ('antennekopling',),
'antennekoplinga': ('antennekopling',),
'antennekoplingen': ('antennekopling',),
'antennekoplingene': ('antennekopling',),
'antennekoplinger': ('antennekopling',),
'antennekrets': ('antennekrets',),
'antennekretsen': ('antennekrets',),
'antennekretsene': ('antennekrets',),
'antennekretser': ('antennekrets',),
'antenneledning': ('antenneledning',),
'antenneledninga': ('antenneledning',),
'antenneledningen': ('antenneledning',),
'antenneledningene': ('antenneledning',),
'antenneledninger': ('antenneledning',),
'antennelse': ('antennelse',),
'antennelsen': ('antennelse',),
'antennelsene': ('antennelse',),
'antennelser': ('antennelse',),
'antennelsestemperatur': ('antennelsestemperatur',),
'antennelsestemperaturen': ('antennelsestemperatur',),
'antennelsestemperaturene': ('antennelsestemperatur',),
'antennelsestemperaturer': ('antennelsestemperatur',),
'antennestøy': ('antennestøy',),
'antennestøyen': ('antennestøy',),
'antennestøyene': ('antennestøy',),
'antennestøyer': ('antennestøy',),
'antenneuttak': ('antenneuttak',),
'antenneuttaka': ('antenneuttak',),
'antenneuttakene': ('antenneuttak',),
'antenneuttaket': ('antenneuttak',),
'antependia': ('antependium',),
'antependiene': ('antependium',),
'antependier': ('antependium',),
'antependiet': ('antependium',),
'antependium': ('antependium',),
'antesipasjon': ('antesipasjon',),
'antesipasjonen': ('antesipasjon',),
'antesipasjonene': ('antesipasjon',),
'antesipasjoner': ('antesipasjon',),
'antibiotika': ('antibiotikum',),
'antibiotikaene': ('antibiotikum',),
'antibiotikum': ('antibiotikum',),
'antibiotikumet': ('antibiotikum',),
'antifebrin': ('antifebrin',),
'antifebrina': ('antifebrin',),
'antifebrinene': ('antifebrin',),
'antifebrinet': ('antifebrin',),
'antigen': ('antigen',),
'antigena': ('antigen',),
'antigenene': ('antigen',),
'antigener': ('antigen',),
'antigenet': ('antigen',),
'antiguaner': ('antiguaner',),
'antiguanere': ('antiguaner',),
'antiguaneren': ('antiguaner',),
'antiguanerer': ('antiguaner',),
'antiguanerne': ('antiguaner',),
'antihelt': ('antihelt',),
'antihelten': ('antihelt',),
'antiheltene': ('antihelt',),
'antihelter': ('antihelt',),
'antiimperialisme': ('antiimperialisme',),
'antiimperialismen': ('antiimperialisme',),
'antiimperialismene': ('antiimperialisme',),
'antiimperialismer': ('antiimperialisme',),
'antikk': ('antikk',),
'antikken': ('antikk',),
'antikkene': ('antikk',),
'antikker': ('antikk',),
'antikksamling': ('antikksamling',),
'antikksamlinga': ('antikksamling',),
'antikksamlingen': ('antikksamling',),
'antikksamlingene': ('antikksamling',),
'antikksamlinger': ('antikksamling',),
'antiklimaks': ('antiklimaks',),
'antiklimaksa': ('antiklimaks',),
'antiklimaksen': ('antiklimaks',),
'antiklimaksene': ('antiklimaks',),
'antiklimakser': ('antiklimaks',),
'antiklimakset': ('antiklimaks',),
'antikommunisme': ('antikommunisme',),
'antikommunismen': ('antikommunisme',),
'antikommunismene': ('antikommunisme',),
'antikommunismer': ('antikommunisme',),
'antikommunist': ('antikommunist',),
'antikommunisten': ('antikommunist',),
'antikommunistene': ('antikommunist',),
'antikommunister': ('antikommunist',),
'antikonsepsjon': ('antikonsepsjon',),
'antikonsepsjonen': ('antikonsepsjon',),
'antikonsepsjonene': ('antikonsepsjon',),
'antikonsepsjoner': ('antikonsepsjon',),
'antikrist': ('antikrist',),
'antikristen': ('antikrist',),
'antikristene': ('antikrist',),
'antikrister': ('antikrist',),
'antikva': ('antikva',),
'antikvaen': ('antikva',),
'antikvaene': ('antikva',),
'antikvaer': ('antikva',),
'antikvar': ('antikvar',),
'antikvaren': ('antikvar',),
'antikvarene': ('antikvar',),
'antikvarer': ('antikvar',),
'antikvarbokhandel': ('antikvarbokhandel',),
'antikvarbokhandelen': ('antikvarbokhandel',),
'antikvarbokhandlene': ('antikvarbokhandel',),
'antikvarbokhandler': ('antikvarbokhandel',),
'antikvarbokhandler': ('antikvarbokhandler',),
'antikvarbokhandlere': ('antikvarbokhandler',),
'antikvarbokhandleren': ('antikvarbokhandler',),
'antikvarbokhandlerer': ('antikvarbokhandler',),
'antikvarbokhandlerne': ('antikvarbokhandler',),
'antikvariat': ('antikvariat',),
'antikvariata': ('antikvariat',),
'antikvariatene': ('antikvariat',),
'antikvariater': ('antikvariat',),
'antikvariatet': ('antikvariat',),
'antikvitet': ('antikvitet',),
'antikviteten': ('antikvitet',),
'antikvitetene': ('antikvitet',),
'antikviteter': ('antikvitet',),
'antikvitetshandel': ('antikvitetshandel',),
'antikvitetshandelen': ('antikvitetshandel',),
'antikvitetshandlene': ('antikvitetshandel',),
'antikvitetshandler': ('antikvitetshandel',),
'antikvitetshandler': ('antikvitetshandler',),
'antikvitetshandlere': ('antikvitetshandler',),
'antikvitetshandleren': ('antikvitetshandler',),
'antikvitetshandlerer': ('antikvitetshandler',),
'antikvitetshandlerne': ('antikvitetshandler',),
'antikvitetssamler': ('antikvitetssamler',),
'antikvitetssamlere': ('antikvitetssamler',),
'antikvitetssamleren': ('antikvitetssamler',),
'antikvitetssamlerer': ('antikvitetssamler',),
'antikvitetssamlerne': ('antikvitetssamler',),
'antikvitetssamling': ('antikvitetssamling',),
'antikvitetssamlinga': ('antikvitetssamling',),
'antikvitetssamlingen': ('antikvitetssamling',),
'antikvitetssamlingene': ('antikvitetssamling',),
'antikvitetssamlinger': ('antikvitetssamling',),
'antilogaritme': ('antilogaritme',),
'antilogaritmen': ('antilogaritme',),
'antilogaritmene': ('antilogaritme',),
'antilogaritmer': ('antilogaritme',),
'antilopa': ('antilope',),
'antilope': ('antilope',),
'antilopen': ('antilope',),
'antilopene': ('antilope',),
'antiloper': ('antilope',),
'antiluftskyts': ('antiluftskyts',),
'antiluftskytsa': ('antiluftskyts',),
'antiluftskytsene': ('antiluftskyts',),
'antiluftskytset': ('antiluftskyts',),
'antimakassar': ('antimakassar',),
'antimakassaren': ('antimakassar',),
'antimakassarene': ('antimakassar',),
'antimakassarer': ('antimakassar',),
'antimilitarisme': ('antimilitarisme',),
'antimilitarismen': ('antimilitarisme',),
'antimilitarismene': ('antimilitarisme',),
'antimilitarismer': ('antimilitarisme',),
'antimilitarist': ('antimilitarist',),
'antimilitaristen': ('antimilitarist',),
'antimilitaristene': ('antimilitarist',),
'antimilitarister': ('antimilitarist',),
'antimon': ('antimon',),
'antimona': ('antimon',),
'antimonene': ('antimon',),
'antimonet': ('antimon',),
'antimonblende': ('antimonblende',),
'antimonblenden': ('antimonblende',),
'antimonblendene': ('antimonblende',),
'antimonblender': ('antimonblende',),
'antimonglans': ('antimonglans',),
'antimonglansen': ('antimonglans',),
'antimonglansene': ('antimonglans',),
'antimonglanser': ('antimonglans',),
'antinomi': ('antinomi',),
'antinomien': ('antinomi',),
'antinomiene': ('antinomi',),
'antinomier': ('antinomi',),
'antipartikkel': ('antipartikkel',),
'antipartikkelen': ('antipartikkel',),
'antipartiklene': ('antipartikkel',),
'antipartikler': ('antipartikkel',),
'antipassat': ('antipassat',),
'antipassaten': ('antipassat',),
'antipassatene': ('antipassat',),
'antipassater': ('antipassat',),
'antipati': ('antipati',),
'antipatien': ('antipati',),
'antipatiene': ('antipati',),
'antipatier': ('antipati',),
'antiperspirant': ('antiperspirant',),
'antiperspiranten': ('antiperspirant',),
'antiperspirantene': ('antiperspirant',),
'antiperspiranter': ('antiperspirant',),
'antipode': ('antipode',),
'antipoden': ('antipode',),
'antipodene': ('antipode',),
'antipoder': ('antipode',),
'antipyrin': ('antipyrin',),
'antipyrina': ('antipyrin',),
'antipyrinen': ('antipyrin',),
'antipyrinene': ('antipyrin',),
'antipyriner': ('antipyrin',),
'antipyrinet': ('antipyrin',),
'antirakettvåpen': ('antirakettvåpen',),
'antirakettvåpenet': ('antirakettvåpen',),
'antirakettvåpna': ('antirakettvåpen',),
'antirakettvåpnene': ('antirakettvåpen',),
'antisemitt': ('antisemitt',),
'antisemitten': ('antisemitt',),
'antisemittene': ('antisemitt',),
'antisemitter': ('antisemitt',),
'antisemittisme': ('antisemittisme',),
'antisemittismen': ('antisemittisme',),
'antisemittismene': ('antisemittisme',),
'antisemittismer': ('antisemittisme',),
'antiseptikk': ('antiseptikk',),
'antiseptikken': ('antiseptikk',),
'antiseptikkene': ('antiseptikk',),
'antiseptikker': ('antiseptikk',),
'antiseptika': ('antiseptikum',),
'antiseptikaene': ('antiseptikum',),
'antiseptikum': ('antiseptikum',),
'antiseptikumet': ('antiseptikum',),
'antisera': ('antiserum',),
'antiseraene': ('antiserum',),
'antiserum': ('antiserum',),
'antiseruma': ('antiserum',),
'antiserumene': ('antiserum',),
'antiserumer': ('antiserum',),
'antiserumet': ('antiserum',),
'antisionisme': ('antisionisme',),
'antisionismen': ('antisionisme',),
'antisionismene': ('antisionisme',),
'antisionismer': ('antisionisme',),
'antisionist': ('antisionist',),
'antisionisten': ('antisionist',),
'antisionistene': ('antisionist',),
'antisionister': ('antisionist',),
'antistoff': ('antistoff',),
'antistoffa': ('antistoff',),
'antistoffene': ('antistoff',),
'antistoffer': ('antistoff',),
'antistoffet': ('antistoff',),
'antitankvåpen': ('antitankvåpen',),
'antitankvåpenet': ('antitankvåpen',),
'antitankvåpna': ('antitankvåpen',),
'antitankvåpnene': ('antitankvåpen',),
'antitese': ('antitese',),
'antitesen': ('antitese',),
'antitesene': ('antitese',),
'antiteser': ('antitese',),
'antitoksin': ('antitoksin',),
'antitoksina': ('antitoksin',),
'antitoksinene': ('antitoksin',),
'antitoksiner': ('antitoksin',),
'antitoksinet': ('antitoksin',),
'antiubåtkrig': ('antiubåtkrig',),
'antiubåtkrigen': ('antiubåtkrig',),
'antiubåtkrigene': ('antiubåtkrig',),
'antiubåtkriger': ('antiubåtkrig',),
'antiubåtvåpen': ('antiubåtvåpen',),
'antiubåtvåpenet': ('antiubåtvåpen',),
'antiubåtvåpna': ('antiubåtvåpen',),
'antiubåtvåpnene': ('antiubåtvåpen',),
'antiviviseksjonist': ('antiviviseksjonist',),
'antiviviseksjonisten': ('antiviviseksjonist',),
'antiviviseksjonistene': ('antiviviseksjonist',),
'antiviviseksjonister': ('antiviviseksjonist',),
'antocyan': ('antocyan',),
'antocyana': ('antocyan',),
'antocyanene': ('antocyan',),
'antocyaner': ('antocyan',),
'antocyanet': ('antocyan',),
'antologi': ('antologi',),
'antologien': ('antologi',),
'antologiene': ('antologi',),
'antologier': ('antologi',),
'antoniuseld': ('antoniuseld',),
'antoniuselden': ('antoniuseld',),
'antoniuseldene': ('antoniuseld',),
'antoniuselder': ('antoniuseld',),
'antoniusild': ('antoniusild',),
'antoniusilden': ('antoniusild',),
'antoniusildene': ('antoniusild',),
'antoniusilder': ('antoniusild',),
'antoniuskors': ('antoniuskors',),
'antoniuskorsa': ('antoniuskors',),
'antoniuskorsene': ('antoniuskors',),
'antoniuskorset': ('antoniuskors',),
'antonsmess': ('antonsmess',),
'antonsmess': ('antonsmess',),
'antonsmesse': ('antonsmesse',),
'antonym': ('antonym',),
'antonyma': ('antonym',),
'antonymene': ('antonym',),
'antonymer': ('antonym',),
'antonymet': ('antonym',),
'antonymi': ('antonymi',),
'antonymien': ('antonymi',),
'antonymiene': ('antonymi',),
'antonymier': ('antonymi',),
'antrasitt': ('antrasitt',),
'antrasitten': ('antrasitt',),
'antrasittene': ('antrasitt',),
'antrasitter': ('antrasitt',),
'antrasittkol': ('antrasittkol',),
'antrasittkola': ('antrasittkol',),
'antrasittkolene': ('antrasittkol',),
'antrasittkolet': ('antrasittkol',),
'antrasittkull': ('antrasittkull',),
'antrasittkulla': ('antrasittkull',),
'antrasittkullene': ('antrasittkull',),
'antrasittkullet': ('antrasittkull',),
'antrekk': ('antrekk',),
'antrekka': ('antrekk',),
'antrekkene': ('antrekk',),
'antrekket': ('antrekk',),
'antropofag': ('antropofag',),
'antropofagen': ('antropofag',),
'antropofagene': ('antropofag',),
'antropofager': ('antropofag',),
'antropofobi': ('antropofobi',),
'antropofobien': ('antropofobi',),
'antropofobiene': ('antropofobi',),
'antropofobier': ('antropofobi',),
'antropolog': ('antropolog',),
'antropologen': ('antropolog',),
'antropologene': ('antropolog',),
'antropologer': ('antropolog',),
'antropologi': ('antropologi',),
'antropologien': ('antropologi',),
'antropologiene': ('antropologi',),
'antropologier': ('antropologi',),
'antropomorfisme': ('antropomorfisme',),
'antropomorfismen': ('antropomorfisme',),
'antropomorfismene': ('antropomorfisme',),
'antropomorfismer': ('antropomorfisme',),
'antroposof': ('antroposof',),
'antroposofen': ('antroposof',),
'antroposofene': ('antroposof',),
'antroposofer': ('antroposof',),
'antroposofi': ('antroposofi',),
'antroposofien': ('antroposofi',),
'antroposofiene': ('antroposofi',),
'antroposofier': ('antroposofi',),
'antydning': ('antydning',),
'antydninga': ('antydning',),
'antydningen': ('antydning',),
'antydningene': ('antydning',),
'antydninger': ('antydning',),
'anus': ('anus',),
'anusen': ('anus',),
'anusene': ('anus',),
'anuser': ('anus',),
'anuskop': ('anuskop',),
'anuskopa': ('anuskop',),
'anuskopene': ('anuskop',),
'anuskoper': ('anuskop',),
'anuskopet': ('anuskop',),
'anvendelse': ('anvendelse',),
'anvendelsen': ('anvendelse',),
'anvendelsene': ('anvendelse',),
'anvendelser': ('anvendelse',),
'anvendelsesmulighet': ('anvendelsesmulighet',),
'anvendelsesmuligheta': ('anvendelsesmulighet',),
'anvendelsesmuligheten': ('anvendelsesmulighet',),
'anvendelsesmulighetene': ('anvendelsesmulighet',),
'anvendelsesmuligheter': ('anvendelsesmulighet',),
'anvendelsesområda': ('anvendelsesområde',),
'anvendelsesområde': ('anvendelsesområde',),
'anvendelsesområdene': ('anvendelsesområde',),
'anvendelsesområder': ('anvendelsesområde',),
'anvendelsesområdet': ('anvendelsesområde',),
'anviser': ('anviser',),
'anvisere': ('anviser',),
'anviseren': ('anviser',),
'anviserer': ('anviser',),
'anviserne': ('anviser',),
'anvisning': ('anvisning',),
'anvisninga': ('anvisning',),
'anvisningen': ('anvisning',),
'anvisningene': ('anvisning',),
'anvisninger': ('anvisning',),
'aorta': ('aorta',),
'ap': ('ap',),
'apen': ('ap',),
'apene': ('ap',),
'aper': ('ap',),
'ap': ('ap',),
'apa': ('ap',),
'apene': ('ap',),
'apet': ('ap',),
'apal': ('apal',),
'apalen': ('apal',),
'apalene': ('apal',),
'apaler': ('apal',),
'apanasje': ('apanasje',),
'apanasjen': ('apanasje',),
'apanasjene': ('apanasje',),
'apanasjer': ('apanasje',),
'apartheid': ('apartheid',),
'apartheiden': ('apartheid',),
'apartheidene': ('apartheid',),
'apartheider': ('apartheid',),
'apartheidlov': ('apartheidlov',),
'apartheidloven': ('apartheidlov',),
'apartheidlovene': ('apartheidlov',),
'apartheidlover': ('apartheidlov',),
'apartheidpolitikk': ('apartheidpolitikk',),
'apartheidpolitikken': ('apartheidpolitikk',),
'apartheidpolitikkene': ('apartheidpolitikk',),
'apartheidpolitikker': ('apartheidpolitikk',),
'apartheidstyra': ('apartheidstyre',),
'apartheidstyre': ('apartheidstyre',),
'apartheidstyrene': ('apartheidstyre',),
'apartheidstyrer': ('apartheidstyre',),
'apartheidstyret': ('apartheidstyre',),
'apasje': ('apasje',),
'apasjen': ('apasje',),
'apasjene': ('apasje',),
'apasjer': ('apasje',),
'apasjeindianer': ('apasjeindianer',),
'apasjeindianere': ('apasjeindianer',),
'apasjeindianeren': ('apasjeindianer',),
'apasjeindianerer': ('apasjeindianer',),
'apasjeindianerne': ('apasjeindianer',),
'apati': ('apati',),
'apatien': ('apati',),
'apatiene': ('apati',),
'apatier': ('apati',),
'apatitt': ('apatitt',),
'apatitten': ('apatitt',),
'apatittene': ('apatitt',),
'apatitter': ('apatitt',),
'apatittgruva': ('apatittgruve',),
'apatittgruve': ('apatittgruve',),
'apatittgruven': ('apatittgruve',),
'apatittgruvene': ('apatittgruve',),
'apatittgruver': ('apatittgruve',),
'apa': ('ape',),
'ape': ('ape',),
'apen': ('ape',),
'apene': ('ape',),
'aper': ('ape',),
'apebrød': ('apebrød',),
'apebrøda': ('apebrød',),
'apebrødene': ('apebrød',),
'apebrødet': ('apebrød',),
'apebrødtre': ('apebrødtre',),
'apebrødtrea': ('apebrødtre',),
'apebrødtreet': ('apebrødtre',),
'apebrødtrær': ('apebrødtre',),
'apebrødtrærne': ('apebrødtre',),
'apekatt': ('apekatt',),
'apekatten': ('apekatt',),
'apekattene': ('apekatt',),
'apekatter': ('apekatt',),
'apemenneska': ('apemenneske',),
'apemenneske': ('apemenneske',),
'apemenneskene': ('apemenneske',),
'apemennesker': ('apemenneske',),
'apemennesket': ('apemenneske',),
'aperi': ('aperi',),
'aperia': ('aperi',),
'aperiene': ('aperi',),
'aperier': ('aperi',),
'aperiet': ('aperi',),
'aperitiff': ('aperitiff',),
'aperitiffen': ('aperitiff',),
'aperitiffene': ('aperitiff',),
'aperitiffer': ('aperitiff',),
'apestrek': ('apestrek',),
'apestreken': ('apestrek',),
'apestrekene': ('apestrek',),
'apestreker': ('apestrek',),
'apikal': ('apikal',),
'apikalen': ('apikal',),
'apikalene': ('apikal',),
'apikaler': ('apikal',),
'aplomb': ('aplomb',),
'aplomben': ('aplomb',),
'aplombene': ('aplomb',),
'aplomber': ('aplomb',),
'apoge': ('apoge',),
'apogea': ('apoge',),
'apogeene': ('apoge',),
'apogeet': ('apoge',),
'apogeet': ('apogeum',),
'apogeum': ('apogeum',),
'apogeumet': ('apogeum',),
'apokalypse': ('apokalypse',),
'apokalypsen': ('apokalypse',),
'apokalypsene': ('apokalypse',),
'apokalypser': ('apokalypse',),
'apokope': ('apokope',),
'apokopen': ('apokope',),
'apokopene': ('apokope',),
'apokoper': ('apokope',),
'apokryf': ('apokryf',),
'apokryfen': ('apokryf',),
'apokryfene': ('apokryf',),
'apokryfer': ('apokryf',),
'apollo': ('apollo',),
'apolloen': ('apollo',),
'apolloene': ('apollo',),
'apolloer': ('apollo',),
'apollosommerfugl': ('apollosommerfugl',),
'apollosommerfuglen': ('apollosommerfugl',),
'apollosommerfuglene': ('apollosommerfugl',),
'apollosommerfugler': ('apollosommerfugl',),
'apologet': ('apologet',),
'apologeten': ('apologet',),
'apologetene': ('apologet',),
'apologeter': ('apologet',),
'apologi': ('apologi',),
'apologien': ('apologi',),
'apologiene': ('apologi',),
'apologier': ('apologi',),
'apopleksi': ('apopleksi',),
'apopleksien': ('apopleksi',),
'apopleksiene': ('apopleksi',),
'apopleksier': ('apopleksi',),
'apoplektiker': ('apoplektiker',),
'apoplektikere': ('apoplektiker',),
'apoplektikeren': ('apoplektiker',),
'apoplektikerer': ('apoplektiker',),
'apoplektikerne': ('apoplektiker',),
'aposiopese': ('aposiopese',),
'aposiopesen': ('aposiopese',),
'aposiopesene': ('aposiopese',),
'aposiopeser': ('aposiopese',),
'apostasi': ('apostasi',),
'apostasien': ('apostasi',),
'apostasiene': ('apostasi',),
'apostasier': ('apostasi',),
'apostat': ('apostat',),
'apostaten': ('apostat',),
'apostatene': ('apostat',),
'apostater': ('apostat',),
'apostel': ('apostel',),
'apostelen': ('apostel',),
'apostlene': ('apostel',),
'apostler': ('apostel',),
'apostelbrev': ('apostelbrev',),
'apostelbreva': ('apostelbrev',),
'apostelbrevene': ('apostelbrev',),
'apostelbrever': ('apostelbrev',),
'apostelbrevet': ('apostelbrev',),
'aposteljern': ('aposteljern',),
'aposteljerna': ('aposteljern',),
'aposteljernene': ('aposteljern',),
'aposteljernet': ('aposteljern',),
'apostrof': ('apostrof',),
'apostrofen': ('apostrof',),
'apostrofene': ('apostrof',),
'apostrofer': ('apostrof',),
'apostrofe': ('apostrofe',),
'apostrofen': ('apostrofe',),
'apostrofene': ('apostrofe',),
'apostrofer': ('apostrofe',),
'apostroftegn': ('apostroftegn',),
'apostroftegna': ('apostroftegn',),
'apostroftegnene': ('apostroftegn',),
'apostroftegnet': ('apostroftegn',),
'apotek': ('apotek',),
'apoteka': ('apotek',),
'apotekene': ('apotek',),
'apoteker': ('apotek',),
'apoteket': ('apotek',),
'apoteker': ('apoteker',),
'apotekere': ('apoteker',),
'apotekeren': ('apoteker',),
'apotekerer': ('apoteker',),
'apotekerne': ('apoteker',),
'apotekerlatin': ('apotekerlatin',),
'apotekerlatinen': ('apotekerlatin',),
'apotekerlatinene': ('apotekerlatin',),
'apotekerlatiner': ('apotekerlatin',),
'apotekervekt': ('apotekervekt',),
'apotekervekta': ('apotekervekt',),
'apotekervekten': ('apotekervekt',),
'apotekervektene': ('apotekervekt',),
'apotekervekter': ('apotekervekt',),
'apoteose': ('apoteose',),
'apoteosen': ('apoteose',),
'apoteosene': ('apoteose',),
'apoteoser': ('apoteose',),
'apparat': ('apparat',),
'apparata': ('apparat',),
'apparatene': ('apparat',),
'apparater': ('apparat',),
'apparatet': ('apparat',),
'apparatbord': ('apparatbord',),
'apparatborda': ('apparatbord',),
'apparatbordene': ('apparatbord',),
'apparatborder': ('apparatbord',),
'apparatbordet': ('apparatbord',),
'apparatsamling': ('apparatsamling',),
'apparatsamlinga': ('apparatsamling',),
'apparatsamlingen': ('apparatsamling',),
'apparatsamlingene': ('apparatsamling',),
'apparatsamlinger': ('apparatsamling',),
'apparatsjik': ('apparatsjik',),
'apparatsjiken': ('apparatsjik',),
'apparatsjikene': ('apparatsjik',),
'apparatsjiker': ('apparatsjik',),
'apparattavla': ('apparattavle',),
'apparattavle': ('apparattavle',),
'apparattavlen': ('apparattavle',),
'apparattavlene': ('apparattavle',),
'apparattavler': ('apparattavle',),
'apparatur': ('apparatur',),
'apparaturen': ('apparatur',),
'apparaturene': ('apparatur',),
'apparaturer': ('apparatur',),
'apparisjon': ('apparisjon',),
'apparisjonen': ('apparisjon',),
'apparisjonene': ('apparisjon',),
'apparisjoner': ('apparisjon',),
'appartement': ('appartement',),
'appartementa': ('appartement',),
'appartementene': ('appartement',),
'appartementer': ('appartement',),
'appartementet': ('appartement',),
'appartementshotell': ('appartementshotell',),
'appartementshotella': ('appartementshotell',),
'appartementshotellene': ('appartementshotell',),
'appartementshoteller': ('appartementshotell',),
'appartementshotellet': ('appartementshotell',),
'appartementshus': ('appartementshus',),
'appartementshusa': ('appartementshus',),
'appartementshusene': ('appartementshus',),
'appartementshuset': ('appartementshus',),
'appell': ('appell',),
'appellen': ('appell',),
'appellene': ('appell',),
'appeller': ('appell',),
'appellant': ('appellant',),
'appellanten': ('appellant',),
'appellantene': ('appellant',),
'appellanter': ('appellant',),
'appellativ': ('appellativ',),
'appellativa': ('appellativ',),
'appellativene': ('appellativ',),
'appellativer': ('appellativ',),
'appellativet': ('appellativ',),
'appelldomstol': ('appelldomstol',),
'appelldomstolen': ('appelldomstol',),
'appelldomstolene': ('appelldomstol',),
'appelldomstoler': ('appelldomstol',),
'appellfrist': ('appellfrist',),
'appellfristen': ('appellfrist',),
'appellfristene': ('appellfrist',),
'appellfrister': ('appellfrist',),
'appellinstans': ('appellinstans',),
'appellinstansen': ('appellinstans',),
'appellinstansene': ('appellinstans',),
'appellinstanser': ('appellinstans',),
'appellrett': ('appellrett',),
'appellretten': ('appellrett',),
'appellrettene': ('appellrett',),
'appellretter': ('appellrett',),
'appelsin': ('appelsin',),
'appelsinen': ('appelsin',),
'appelsinene': ('appelsin',),
'appelsiner': ('appelsin',),
'appelsinbåt': ('appelsinbåt',),
'appelsinbåten': ('appelsinbåt',),
'appelsinbåtene': ('appelsinbåt',),
'appelsinbåter': ('appelsinbåt',),
'appelsinfromasj': ('appelsinfromasj',),
'appelsinfromasjen': ('appelsinfromasj',),
'appelsinfromasjene': ('appelsinfromasj',),
'appelsinfromasjer': ('appelsinfromasj',),
'appelsinjuice': ('appelsinjuice',),
'appelsinjuicen': ('appelsinjuice',),
'appelsinjuicene': ('appelsinjuice',),
'appelsinjuicer': ('appelsinjuice',),
'appelsinjus': ('appelsinjus',),
'appelsinjusen': ('appelsinjus',),
'appelsinjusene': ('appelsinjus',),
'appelsinjuser': ('appelsinjus',),
'appelsinmarmelade': ('appelsinmarmelade',),
'appelsinmarmeladen': ('appelsinmarmelade',),
'appelsinmarmeladene': ('appelsinmarmelade',),
'appelsinmarmelader': ('appelsinmarmelade',),
'appelsinsaft': ('appelsinsaft',),
'appelsinsafta': ('appelsinsaft',),
'appelsinsaften': ('appelsinsaft',),
'appelsinsaftene': ('appelsinsaft',),
'appelsinsafter': ('appelsinsaft',),
'appelsinskal': ('appelsinskal',),
'appelsinskala': ('appelsinskal',),
'appelsinskalene': ('appelsinskal',),
'appelsinskalet': ('appelsinskal',),
'appelsinskall': ('appelsinskall',),
'appelsinskalla': ('appelsinskall',),
'appelsinskallene': ('appelsinskall',),
'appelsinskallet': ('appelsinskall',),
'appendiks': ('appendiks',),
'appendiksen': ('appendiks',),
'appendiksene': ('appendiks',),
'appendikser': ('appendiks',),
'appendiks': ('appendiks',),
'appendiksa': ('appendiks',),
'appendiksene': ('appendiks',),
'appendikser': ('appendiks',),
'appendikset': ('appendiks',),
'appetitt': ('appetitt',),
'appetitten': ('appetitt',),
'appetittene': ('appetitt',),
'appetitter': ('appetitt',),
'appetittvekker': ('appetittvekker',),
'appetittvekkere': ('appetittvekker',),
'appetittvekkeren': ('appetittvekker',),
'appetittvekkerer': ('appetittvekker',),
'appetittvekkerne': ('appetittvekker',),
'applaus': ('applaus',),
'applausen': ('applaus',),
'applausene': ('applaus',),
'applauser': ('applaus',),
'applikasjon': ('applikasjon',),
'applikasjonen': ('applikasjon',),
'applikasjonene': ('applikasjon',),
'applikasjoner': ('applikasjon',),
'applikasjonsarbeid': ('applikasjonsarbeid',),
'applikasjonsarbeida': ('applikasjonsarbeid',),
'applikasjonsarbeidene': ('applikasjonsarbeid',),
'applikasjonsarbeider': ('applikasjonsarbeid',),
'applikasjonsarbeidet': ('applikasjonsarbeid',),
'applikasjonsområda': ('applikasjonsområde',),
'applikasjonsområde': ('applikasjonsområde',),
'applikasjonsområdene': ('applikasjonsområde',),
'applikasjonsområder': ('applikasjonsområde',),
'applikasjonsområdet': ('applikasjonsområde',),
'applikasjonssøm': ('applikasjonssøm',),
'applikasjonssømmen': ('applikasjonssøm',),
'applikasjonssømmene': ('applikasjonssøm',),
'applikasjonssømmer': ('applikasjonssøm',),
'applikatur': ('applikatur',),
'applikaturen': ('applikatur',),
'applikaturene': ('applikatur',),
'applikaturer': ('applikatur',),
'apport': ('apport',),
'apporten': ('apport',),
'apportene': ('apport',),
'apporter': ('apport',),
'apposisjon': ('apposisjon',),
'apposisjonen': ('apposisjon',),
'apposisjonene': ('apposisjon',),
'apposisjoner': ('apposisjon',),
'appretur': ('appretur',),
'appreturen': ('appretur',),
'appreturene': ('appretur',),
'appreturer': ('appretur',),
'appreturmaskin': ('appreturmaskin',),
'appreturmaskina': ('appreturmaskin',),
'appreturmaskinen': ('appreturmaskin',),
'appreturmaskinene': ('appreturmaskin',),
'appreturmaskiner': ('appreturmaskin',),
'approbasjon': ('approbasjon',),
'approbasjonen': ('approbasjon',),
'approbasjonene': ('approbasjon',),
'approbasjoner': ('approbasjon',),
'approbering': ('approbering',),
'approberinga': ('approbering',),
'approberingen': ('approbering',),
'approberingene': ('approbering',),
'approberinger': ('approbering',),
'approksimasjon': ('approksimasjon',),
'approksimasjonen': ('approksimasjon',),
'approksimasjonene': ('approksimasjon',),
'approksimasjoner': ('approksimasjon',),
'appropriasjon': ('appropriasjon',),
'appropriasjonen': ('appropriasjon',),
'appropriasjonene': ('appropriasjon',),
'appropriasjoner': ('appropriasjon',),
'aprikos': ('aprikos',),
'aprikosen': ('aprikos',),
'aprikosene': ('aprikos',),
'aprikoser': ('aprikos',),
'aprikosgraut': ('aprikosgraut',),
'aprikosgrauten': ('aprikosgraut',),
'aprikosgrautene': ('aprikosgraut',),
'aprikosgrauter': ('aprikosgraut',),
'aprikosgrøt': ('aprikosgrøt',),
'aprikosgrøten': ('aprikosgrøt',),
'aprikosgrøtene': ('aprikosgrøt',),
'aprikosgrøter': ('aprikosgrøt',),
'aprikoskompott': ('aprikoskompott',),
'aprikoskompotten': ('aprikoskompott',),
'aprikoskompottene': ('aprikoskompott',),
'aprikoskompotter': ('aprikoskompott',),
'aprikosmarmelade': ('aprikosmarmelade',),
'aprikosmarmeladen': ('aprikosmarmelade',),
'aprikosmarmeladene': ('aprikosmarmelade',),
'aprikosmarmelader': ('aprikosmarmelade',),
'aprikossyltetøy': ('aprikossyltetøy',),
'aprikossyltetøya': ('aprikossyltetøy',),
'aprikossyltetøyene': ('aprikossyltetøy',),
'aprikossyltetøyet': ('aprikossyltetøy',),
'aprikostre': ('aprikostre',),
'aprikostrea': ('aprikostre',),
'aprikostreet': ('aprikostre',),
'aprikostrær': ('aprikostre',),
'aprikostrærne': ('aprikostre',),
'april': ('april',),
'aprilsnarr': ('aprilsnarr',),
'aprilsnarren': ('aprilsnarr',),
'aprilsnarrene': ('aprilsnarr',),
'aprilsnarrer': ('aprilsnarr',),
'aprilspøk': ('aprilspøk',),
'aprilspøken': ('aprilspøk',),
'aprilspøkene': ('aprilspøk',),
'aprilspøker': ('aprilspøk',),
'aprilvær': ('aprilvær',),
'aprilværa': ('aprilvær',),
'aprilværene': ('aprilvær',),
'aprilværet': ('aprilvær',),
'apropos': ('apropos',),
'aproposa': ('apropos',),
'aproposene': ('apropos',),
'aproposer': ('apropos',),
'aproposet': ('apropos',),
'apsidene': ('apsis',),
'apsider': ('apsis',),
'apsis': ('apsis',),
'apsisen': ('apsis',),
'apsisene': ('apsis',),
'apsiser': ('apsis',),
'ar': ('ar',),
'ara': ('ar',),
'arene': ('ar',),
'aret': ('ar',),
'ara': ('ara',),
'araen': ('ara',),
'araene': ('ara',),
'araer': ('ara',),
'araber': ('araber',),
'arabere': ('araber',),
'araberen': ('araber',),
'araberer': ('araber',),
'araberne': ('araber',),
'araberhest': ('araberhest',),
'araberhesten': ('araberhest',),
'araberhestene': ('araberhest',),
'araberhester': ('araberhest',),
'araberstat': ('araberstat',),
'araberstaten': ('araberstat',),
'araberstatene': ('araberstat',),
'araberstater': ('araberstat',),
'arabertal': ('arabertal',),
'arabertala': ('arabertal',),
'arabertalene': ('arabertal',),
'arabertalet': ('arabertal',),
'arabertall': ('arabertall',),
'arabertalla': ('arabertall',),
'arabertallene': ('arabertall',),
'arabertallet': ('arabertall',),
'arabesk': ('arabesk',),
'arabesken': ('arabesk',),
'arabeskene': ('arabesk',),
'arabesker': ('arabesk',),
'arabisk': ('arabisk',),
'arabisken': ('arabisk',),
'arabiskene': ('arabisk',),
'arabisker': ('arabisk',),
'arabist': ('arabist',),
'arabisten': ('arabist',),
'arabistene': ('arabist',),
'arabister': ('arabist',),
'arak': ('arak',),
'araken': ('arak',),
'arakene': ('arak',),
'araker': ('arak',),
'arakpunsj': ('arakpunsj',),
'arakpunsjen': ('arakpunsj',),
'arakpunsjene': ('arakpunsj',),
'arakpunsjer': ('arakpunsj',),
'arameer': ('arameer',),
'arameere': ('arameer',),
'arameeren': ('arameer',),
'arameerer': ('arameer',),
'arameerne': ('arameer',),
'arameisk': ('arameisk',),
'arameisken': ('arameisk',),
'arameiskene': ('arameisk',),
'arameisker': ('arameisk',),
'arbeid': ('arbeid',),
'arbeida': ('arbeid',),
'arbeidene': ('arbeid',),
'arbeider': ('arbeid',),
'arbeidet': ('arbeid',),
'arbeider': ('arbeider',),
'arbeidere': ('arbeider',),
'arbeideren': ('arbeider',),
'arbeiderer': ('arbeider',),
'arbeiderne': ('arbeider',),
'arbeiderbevegelse': ('arbeiderbevegelse',),
'arbeiderbevegelsen': ('arbeiderbevegelse',),
'arbeiderbevegelsene': ('arbeiderbevegelse',),
'arbeiderbevegelser': ('arbeiderbevegelse',),
'arbeiderbia': ('arbeiderbie',),
'arbeiderbie': ('arbeiderbie',),
'arbeiderbien': ('arbeiderbie',),
'arbeiderbiene': ('arbeiderbie',),
'arbeiderbier': ('arbeiderbie',),
'arbeiderbolig': ('arbeiderbolig',),
'arbeiderboligen': ('arbeiderbolig',),
'arbeiderboligene': ('arbeiderbolig',),
'arbeiderboliger': ('arbeiderbolig',),
'arbeiderdikter': ('arbeiderdikter',),
'arbeiderdiktere': ('arbeiderdikter',),
'arbeiderdikteren': ('arbeiderdikter',),
'arbeiderdikterer': ('arbeiderdikter',),
'arbeiderdikterne': ('arbeiderdikter',),
'arbeiderdiktning': ('arbeiderdiktning',),
'arbeiderdiktninga': ('arbeiderdiktning',),
'arbeiderdiktningen': ('arbeiderdiktning',),
'arbeiderdiktningene': ('arbeiderdiktning',),
'arbeiderdiktninger': ('arbeiderdiktning',),
'arbeiderforening': ('arbeiderforening',),
'arbeiderforeninga': ('arbeiderforening',),
'arbeiderforeningen': ('arbeiderforening',),
'arbeiderforeningene': ('arbeiderforening',),
'arbeiderforeninger': ('arbeiderforening',),
'arbeiderfører': ('arbeiderfører',),
'arbeiderførere': ('arbeiderfører',),
'arbeiderføreren': ('arbeiderfører',),
'arbeiderførerer': ('arbeiderfører',),
'arbeiderførerne': ('arbeiderfører',),
'arbeiderklassa': ('arbeiderklasse',),
'arbeiderklasse': ('arbeiderklasse',),
'arbeiderklassen': ('arbeiderklasse',),
'arbeiderklassene': ('arbeiderklasse',),
'arbeiderklasser': ('arbeiderklasse',),
'arbeiderkvarter': ('arbeiderkvarter',),
'arbeiderkvartera': ('arbeiderkvarter',),
'arbeiderkvarterene': ('arbeiderkvarter',),
'arbeiderkvarterer': ('arbeiderkvarter',),
'arbeiderkvarteret': ('arbeiderkvarter',),
'arbeiderleder': ('arbeiderleder',),
'arbeiderledere': ('arbeiderleder',),
'arbeiderlederen': ('arbeiderleder',),
'arbeiderlederer': ('arbeiderleder',),
'arbeiderlederne': ('arbeiderleder',),
'arbeidermiljø': ('arbeidermiljø',),
'arbeidermiljøa': ('arbeidermiljø',),
'arbeidermiljøene': ('arbeidermiljø',),
'arbeidermiljøer': ('arbeidermiljø',),
'arbeidermiljøet': ('arbeidermiljø',),
'arbeideroppstand': ('arbeideroppstand',),
'arbeideroppstanden': ('arbeideroppstand',),
'arbeideroppstandene': ('arbeideroppstand',),
'arbeideroppstander': ('arbeideroppstand',),
'arbeiderparti': ('arbeiderparti',),
'arbeiderpartia': ('arbeiderparti',),
'arbeiderpartiene': ('arbeiderparti',),
'arbeiderpartier': ('arbeiderparti',),
'arbeiderpartiet': ('arbeiderparti',),
'arbeiderpartifolk': ('arbeiderpartifolk',),
'arbeiderpartifolka': ('arbeiderpartifolk',),
'arbeiderpartifolkene': ('arbeiderpartifolk',),
'arbeiderpartifolket': ('arbeiderpartifolk',),
'arbeiderpressa': ('arbeiderpresse',),
'arbeiderpresse': ('arbeiderpresse',),
'arbeiderpressen': ('arbeiderpresse',),
'arbeiderpressene': ('arbeiderpresse',),
'arbeiderpresser': ('arbeiderpresse',),
'arbeiderregjering': ('arbeiderregjering',),
'arbeiderregjeringa': ('arbeiderregjering',),
'arbeiderregjeringen': ('arbeiderregjering',),
'arbeiderregjeringene': ('arbeiderregjering',),
'arbeiderregjeringer': ('arbeiderregjering',),
'arbeiderrevolusjon': ('arbeiderrevolusjon',),
'arbeiderrevolusjonen': ('arbeiderrevolusjon',),
'arbeiderrevolusjonene': ('arbeiderrevolusjon',),
'arbeiderrevolusjoner': ('arbeiderrevolusjon',),
'arbeiderråd': ('arbeiderråd',),
'arbeiderråda': ('arbeiderråd',),
'arbeiderrådene': ('arbeiderråd',),
'arbeiderrådet': ('arbeiderråd',),
'arbeiderrørsla': ('arbeiderrørsle',),
'arbeiderrørsle': ('arbeiderrørsle',),
'arbeiderrørslen': ('arbeiderrørsle',),
'arbeiderrørslene': ('arbeiderrørsle',),
'arbeiderrørsler': ('arbeiderrørsle',),
'arbeidersamfunn': ('arbeidersamfunn',),
'arbeidersamfunna': ('arbeidersamfunn',),
'arbeidersamfunnene': ('arbeidersamfunn',),
'arbeidersamfunnet': ('arbeidersamfunn',),
'arbeidersamskipnad': ('arbeidersamskipnad',),
'arbeidersamskipnaden': ('arbeidersamskipnad',),
'arbeidersamskipnadene': ('arbeidersamskipnad',),
'arbeidersamskipnader': ('arbeidersamskipnad',),
'arbeiderstrøk': ('arbeiderstrøk',),
'arbeiderstrøka': ('arbeiderstrøk',),
'arbeiderstrøkene': ('arbeiderstrøk',),
'arbeiderstrøket': ('arbeiderstrøk',),
'arbeiderstyra': ('arbeiderstyre',),
'arbeiderstyre': ('arbeiderstyre',),
'arbeiderstyrene': ('arbeiderstyre',),
'arbeiderstyrer': ('arbeiderstyre',),
'arbeiderstyret': ('arbeiderstyre',),
'arbeidervern': ('arbeidervern',),
'arbeiderverna': ('arbeidervern',),
'arbeidervernene': ('arbeidervern',),
'arbeidervernet': ('arbeidervern',),
'arbeidervernlov': ('arbeidervernlov',),
'arbeidervernloven': ('arbeidervernlov',),
'arbeidervernlovene': ('arbeidervernlov',),
'arbeidervernlover': ('arbeidervernlov',),
'arbeidsanstalt': ('arbeidsanstalt',),
'arbeidsanstalten': ('arbeidsanstalt',),
'arbeidsanstaltene': ('arbeidsanstalt',),
'arbeidsanstalter': ('arbeidsanstalt',),
'arbeidsbenk': ('arbeidsbenk',),
'arbeidsbenken': ('arbeidsbenk',),
'arbeidsbenkene': ('arbeidsbenk',),
'arbeidsbenker': ('arbeidsbenk',),
'arbeidsbeskrivelse': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelsen': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelsene': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelser': ('arbeidsbeskrivelse',),
'arbeidsbia': ('arbeidsbie',),
'arbeidsbie': ('arbeidsbie',),
'arbeidsbien': ('arbeidsbie',),
'arbeidsbiene': ('arbeidsbie',),
'arbeidsbier': ('arbeidsbie',),
'arbeidsbord': ('arbeidsbord',),
'arbeidsborda': ('arbeidsbord',),
'arbeidsbordene': ('arbeidsbord',),
'arbeidsborder': ('arbeidsbord',),
'arbeidsbordet': ('arbeidsbord',),
'arbeidsbyrde': ('arbeidsbyrde',),
'arbeidsbyrden': ('arbeidsbyrde',),
'arbeidsbyrdene': ('arbeidsbyrde',),
'arbeidsbyrder': ('arbeidsbyrde',),
'arbeidsdag': ('arbeidsdag',),
'arbeidsdagen': ('arbeidsdag',),
'arbeidsdagene': ('arbeidsdag',),
'arbeidsdager': ('arbeidsdag',),
'arbeidsdeling': ('arbeidsdeling',),
'arbeidsdelinga': ('arbeidsdeling',),
'arbeidsdelingen': ('arbeidsdeling',),
'arbeidsdelingene': ('arbeidsdeling',),
'arbeidsdelinger': ('arbeidsdeling',),
'arbeidsdokument': ('arbeidsdokument',),
'arbeidsdokumenta': ('arbeidsdokument',),
'arbeidsdokumentene': ('arbeidsdokument',),
'arbeidsdokumenter': ('arbeidsdokument',),
'arbeidsdokumentet': ('arbeidsdokument',),
'arbeidsdyr': ('arbeidsdyr',),
'arbeidsdyra': ('arbeidsdyr',),
'arbeidsdyrene': ('arbeidsdyr',),
'arbeidsdyret': ('arbeidsdyr',),
'arbeidsevna': ('arbeidsevne',),
'arbeidsevne': ('arbeidsevne',),
'arbeidsevnen': ('arbeidsevne',),
'arbeidsevnene': ('arbeidsevne',),
'arbeidsevner': ('arbeidsevne',),
'arbeidsfelt': ('arbeidsfelt',),
'arbeidsfelta': ('arbeidsfelt',),
'arbeidsfeltene': ('arbeidsfelt',),
'arbeidsfelter': ('arbeidsfelt',),
'arbeidsfeltet': ('arbeidsfelt',),
'arbeidsfolk': ('arbeidsfolk',),
'arbeidsfolka': ('arbeidsfolk',),
'arbeidsfolkene': ('arbeidsfolk',),
'arbeidsfolket': ('arbeidsfolk',),
'arbeidsforhold': ('arbeidsforhold',),
'arbeidsforholda': ('arbeidsforhold',),
'arbeidsforholdene': ('arbeidsforhold',),
'arbeidsforholdet': ('arbeidsforhold',),
'arbeidsformidling': ('arbeidsformidling',),
'arbeidsformidlinga': ('arbeidsformidling',),
'arbeidsformidlingen': ('arbeidsformidling',),
'arbeidsformidlingene': ('arbeidsformidling',),
'arbeidsformidlinger': ('arbeidsformidling',),
'arbeidsfortjenesta': ('arbeidsfortjeneste',),
'arbeidsfortjeneste': ('arbeidsfortjeneste',),
'arbeidsfortjenesten': ('arbeidsfortjeneste',),
'arbeidsfortjenestene': ('arbeidsfortjeneste',),
'arbeidsfortjenester': ('arbeidsfortjeneste',),
'arbeidsfred': ('arbeidsfred',),
'arbeidsfreden': ('arbeidsfred',),
'arbeidsfredene': ('arbeidsfred',),
'arbeidsfreder': ('arbeidsfred',),
'arbeidsfysiologi': ('arbeidsfysiologi',),
'arbeidsfysiologien': ('arbeidsfysiologi',),
'arbeidsfysiologiene': ('arbeidsfysiologi',),
'arbeidsfysiologier': ('arbeidsfysiologi',),
'arbeidsgamp': ('arbeidsgamp',),
'arbeidsgampen': ('arbeidsgamp',),
'arbeidsgampene': ('arbeidsgamp',),
'arbeidsgamper': ('arbeidsgamp',),
'arbeidsgang': ('arbeidsgang',),
'arbeidsgangen': ('arbeidsgang',),
'arbeidsgangene': ('arbeidsgang',),
'arbeidsganger': ('arbeidsgang',),
'arbeidsgiver': ('arbeidsgiver',),
'arbeidsgivere': ('arbeidsgiver',),
'arbeidsgiveren': ('arbeidsgiver',),
'arbeidsgiverer': ('arbeidsgiver',),
'arbeidsgiverne': ('arbeidsgiver',),
'arbeidsgiveransvar': ('arbeidsgiveransvar',),
'arbeidsgiveransvara': ('arbeidsgiveransvar',),
'arbeidsgiveransvarene': ('arbeidsgiveransvar',),
'arbeidsgiveransvaret': ('arbeidsgiveransvar',),
'arbeidsgiveravgift': ('arbeidsgiveravgift',),
'arbeidsgiveravgifta': ('arbeidsgiveravgift',),
'arbeidsgiveravgiften': ('arbeidsgiveravgift',),
'arbeidsgiveravgiftene': ('arbeidsgiveravgift',),
'arbeidsgiveravgifter': ('arbeidsgiveravgift',),
'arbeidsgjeng': ('arbeidsgjeng',),
'arbeidsgjengen': ('arbeidsgjeng',),
'arbeidsgjengene': ('arbeidsgjeng',),
'arbeidsgjenger': ('arbeidsgjeng',),
'arbeidsgleda': ('arbeidsglede',),
'arbeidsglede': ('arbeidsglede',),
'arbeidsgleden': ('arbeidsglede',),
'arbeidsgledene': ('arbeidsglede',),
'arbeidsgleder': ('arbeidsglede',),
'arbeidsgrunnlag': ('arbeidsgrunnlag',),
'arbeidsgrunnlaga': ('arbeidsgrunnlag',),
'arbeidsgrunnlagene': ('arbeidsgrunnlag',),
'arbeidsgrunnlaget': ('arbeidsgrunnlag',),
'arbeidsgruppa': ('arbeidsgruppe',),
'arbeidsgruppe': ('arbeidsgruppe',),
'arbeidsgruppen': ('arbeidsgruppe',),
'arbeidsgruppene': ('arbeidsgruppe',),
'arbeidsgrupper': ('arbeidsgruppe',),
'arbeidshastighet': ('arbeidshastighet',),
'arbeidshastigheta': ('arbeidshastighet',),
'arbeidshastigheten': ('arbeidshastighet',),
'arbeidshastighetene': ('arbeidshastighet',),
'arbeidshastigheter': ('arbeidshastighet',),
'arbeidshest': ('arbeidshest',),
'arbeidshesten': ('arbeidshest',),
'arbeidshestene': ('arbeidshest',),
'arbeidshester': ('arbeidshest',),
'arbeidshjelp': ('arbeidshjelp',),
'arbeidshjelpa': ('arbeidshjelp',),
'arbeidshjelpen': ('arbeidshjelp',),
'arbeidshjelpene': ('arbeidshjelp',),
'arbeidshjelper': ('arbeidshjelp',),
'arbeidshypotese': ('arbeidshypotese',),
'arbeidshypotesen': ('arbeidshypotese',),
'arbeidshypotesene': ('arbeidshypotese',),
'arbeidshypoteser': ('arbeidshypotese',),
'arbeidsinnsats': ('arbeidsinnsats',),
'arbeidsinnsatsen': ('arbeidsinnsats',),
'arbeidsinnsatsene': ('arbeidsinnsats',),
'arbeidsinnsatser': ('arbeidsinnsats',),
'arbeidsjern': ('arbeidsjern',),
'arbeidsjerna': ('arbeidsjern',),
'arbeidsjernene': ('arbeidsjern',),
'arbeidsjernet': ('arbeidsjern',),
'arbeidskamerat': ('arbeidskamerat',),
'arbeidskameraten': ('arbeidskamerat',),
'arbeidskameratene': ('arbeidskamerat',),
'arbeidskamerater': ('arbeidskamerat',),
'arbeidskar': ('arbeidskar',),
'arbeidskaren': ('arbeidskar',),
'arbeidskarene': ('arbeidskar',),
'arbeidskarer': ('arbeidskar',),
'arbeidskirka': ('arbeidskirke',),
'arbeidskirke': ('arbeidskirke',),
'arbeidskirken': ('arbeidskirke',),
'arbeidskirkene': ('arbeidskirke',),
'arbeidskirker': ('arbeidskirke',),
'arbeidskjerka': ('arbeidskjerke',),
'arbeidskjerke': ('arbeidskjerke',),
'arbeidskjerken': ('arbeidskjerke',),
'arbeidskjerkene': ('arbeidskjerke',),
'arbeidskjerker': ('arbeidskjerke',),
'arbeidskollektiv': ('arbeidskollektiv',),
'arbeidskollektiva': ('arbeidskollektiv',),
'arbeidskollektivene': ('arbeidskollektiv',),
'arbeidskollektiver': ('arbeidskollektiv',),
'arbeidskollektivet': ('arbeidskollektiv',),
'arbeidskonflikt': ('arbeidskonflikt',),
'arbeidskonflikten': ('arbeidskonflikt',),
'arbeidskonfliktene': ('arbeidskonflikt',),
'arbeidskonflikter': ('arbeidskonflikt',),
'arbeidskontor': ('arbeidskontor',),
'arbeidskontora': ('arbeidskontor',),
'arbeidskontorene': ('arbeidskontor',),
'arbeidskontorer': ('arbeidskontor',),
'arbeidskontoret': ('arbeidskontor',),
'arbeidskostnad': ('arbeidskostnad',),
'arbeidskostnaden': ('arbeidskostnad',),
'arbeidskostnadene': ('arbeidskostnad',),
'arbeidskostnader': ('arbeidskostnad',),
'arbeidskraft': ('arbeidskraft',),
'arbeidskrafta': ('arbeidskraft',),
'arbeidskraften': ('arbeidskraft',),
'arbeidskreftene': ('arbeidskraft',),
'arbeidskrefter': ('arbeidskraft',),
'arbeidskraftreserve': ('arbeidskraftreserve',),
'arbeidskraftreserven': ('arbeidskraftreserve',),
'arbeidskraftreservene': ('arbeidskraftreserve',),
'arbeidskraftreserver': ('arbeidskraftreserve',),
'arbeidslag': ('arbeidslag',),
'arbeidslaga': ('arbeidslag',),
'arbeidslagene': ('arbeidslag',),
'arbeidslaget': ('arbeidslag',),
'arbeidslampa': ('arbeidslampe',),
'arbeidslampe': ('arbeidslampe',),
'arbeidslampen': ('arbeidslampe',),
'arbeidslampene': ('arbeidslampe',),
'arbeidslamper': ('arbeidslampe',),
'arbeidsleder': ('arbeidsleder',),
'arbeidsledere': ('arbeidsleder',),
'arbeidslederen': ('arbeidsleder',),
'arbeidslederer': ('arbeidsleder',),
'arbeidslederne': ('arbeidsleder',),
'arbeidsledighet': ('arbeidsledighet',),
'arbeidsledigheta': ('arbeidsledighet',),
'arbeidsledigheten': ('arbeidsledighet',),
'arbeidsledighetene': ('arbeidsledighet',),
'arbeidsledigheter': ('arbeidsledighet',),
'arbeidsleir': ('arbeidsleir',),
'arbeidsleiren': ('arbeidsleir',),
'arbeidsleirene': ('arbeidsleir',),
'arbeidsleirer': ('arbeidsleir',),
'arbeidsliv': ('arbeidsliv',),
'arbeidsliva': ('arbeidsliv',),
'arbeidslivene': ('arbeidsliv',),
'arbeidslivet': ('arbeidsliv',),
'arbeidslyst': ('arbeidslyst',),
'arbeidslysta': ('arbeidslyst',),
'arbeidslysten': ('arbeidslyst',),
'arbeidslystene': ('arbeidslyst',),
'arbeidslyster': ('arbeidslyst',),
'arbeidslønn': ('arbeidslønn',),
'arbeidslønna': ('arbeidslønn',),
'arbeidslønnen': ('arbeidslønn',),
'arbeidslønnene': ('arbeidslønn',),
'arbeidslønner': ('arbeidslønn',),
'arbeidsløshet': ('arbeidsløshet',),
'arbeidsløsheta': ('arbeidsløshet',),
'arbeidsløsheten': ('arbeidsløshet',),
'arbeidsløshetene': ('arbeidsløshet',),
'arbeidsløsheter': ('arbeidsløshet',),
'arbeidsløshetstrygd': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygda': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygden': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygdene': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygder': ('arbeidsløshetstrygd',),
'arbeidsløysa': ('arbeidsløyse',),
'arbeidsløyse': ('arbeidsløyse',),
'arbeidsløysen': ('arbeidsløyse',),
'arbeidsløysene': ('arbeidsløyse',),
'arbeidsløyser': ('arbeidsløyse',),
'arbeidsløysetrygd': ('arbeidsløysetrygd',),
'arbeidsløysetrygda': ('arbeidsløysetrygd',),
'arbeidsløysetrygden': ('arbeidsløysetrygd',),
'arbeidsløysetrygdene': ('arbeidsløysetrygd',),
'arbeidsløysetrygder': ('arbeidsløysetrygd',),
'arbeidsløyva': ('arbeidsløyve',),
'arbeidsløyve': ('arbeidsløyve',),
'arbeidsløyvene': ('arbeidsløyve',),
'arbeidsløyver': ('arbeidsløyve',),
'arbeidsløyvet': ('arbeidsløyve',),
'arbeidsmarked': ('arbeidsmarked',),
'arbeidsmarkeda': ('arbeidsmarked',),
'arbeidsmarkedene': ('arbeidsmarked',),
'arbeidsmarkeder': ('arbeidsmarked',),
'arbeidsmarkedet': ('arbeidsmarked',),
'arbeidsmarknad': ('arbeidsmarknad',),
'arbeidsmarknaden': ('arbeidsmarknad',),
'arbeidsmarknadene': ('arbeidsmarknad',),
'arbeidsmarknader': ('arbeidsmarknad',),
'arbeidsmaur': ('arbeidsmaur',),
'arbeidsmauren': ('arbeidsmaur',),
'arbeidsmaurene': ('arbeidsmaur',),
'arbeidsmengd': ('arbeidsmengd',),
'arbeidsmengda': ('arbeidsmengd',),
'arbeidsmengden': ('arbeidsmengd',),
'arbeidsmengdene': ('arbeidsmengd',),
'arbeidsmengder': ('arbeidsmengd',),
'arbeidsmengde': ('arbeidsmengde',),
'arbeidsmengden': ('arbeidsmengde',),
'arbeidsmengdene': ('arbeidsmengde',),
'arbeidsmengder': ('arbeidsmengde',),
'arbeidsmenneska': ('arbeidsmenneske',),
'arbeidsmenneske': ('arbeidsmenneske',),
'arbeidsmenneskene': ('arbeidsmenneske',),
'arbeidsmennesker': ('arbeidsmenneske',),
'arbeidsmennesket': ('arbeidsmenneske',),
'arbeidsmiljø': ('arbeidsmiljø',),
'arbeidsmiljøa': ('arbeidsmiljø',),
'arbeidsmiljøene': ('arbeidsmiljø',),
'arbeidsmiljøer': ('arbeidsmiljø',),
'arbeidsmiljøet': ('arbeidsmiljø',),
'arbeidsmiljølov': ('arbeidsmiljølov',),
'arbeidsmiljøloven': ('arbeidsmiljølov',),
'arbeidsmiljølovene': ('arbeidsmiljølov',),
'arbeidsmiljølover': ('arbeidsmiljølov',),
'arbeidsnedleggelse': ('arbeidsnedleggelse',),
'arbeidsnedleggelsen': ('arbeidsnedleggelse',),
'arbeidsnedleggelsene': ('arbeidsnedleggelse',),
'arbeidsnedleggelser': ('arbeidsnedleggelse',),
'arbeidsnedlegging': ('arbeidsnedlegging',),
'arbeidsnedlegginga': ('arbeidsnedlegging',),
'arbeidsnedleggingen': ('arbeidsnedlegging',),
'arbeidsnedleggingene': ('arbeidsnedlegging',),
'arbeidsnedlegginger': ('arbeidsnedlegging',),
'arbeidsneve': ('arbeidsneve',),
'arbeidsneven': ('arbeidsneve',),
'arbeidsnevene': ('arbeidsneve',),
'arbeidsnever': ('arbeidsneve',),
'arbeidsområda': ('arbeidsområde',),
'arbeidsområde': ('arbeidsområde',),
'arbeidsområdene': ('arbeidsområde',),
'arbeidsområder': ('arbeidsområde',),
'arbeidsområdet': ('arbeidsområde',),
'arbeidsoperasjon': ('arbeidsoperasjon',),
'arbeidsoperasjonen': ('arbeidsoperasjon',),
'arbeidsoperasjonene': ('arbeidsoperasjon',),
'arbeidsoperasjoner': ('arbeidsoperasjon',),
'arbeidspress': ('arbeidspress',),
'arbeidspressa': ('arbeidspress',),
'arbeidspressene': ('arbeidspress',),
'arbeidspresset': ('arbeidspress',),
'arbeidsprogram': ('arbeidsprogram',),
'arbeidsprogramma': ('arbeidsprogram',),
'arbeidsprogrammene': ('arbeidsprogram',),
'arbeidsprogrammer': ('arbeidsprogram',),
'arbeidsprogrammet': ('arbeidsprogram',),
'arbeidsredskap': ('arbeidsredskap',),
'arbeidsredskapa': ('arbeidsredskap',),
'arbeidsredskapen': ('arbeidsredskap',),
'arbeidsredskapene': ('arbeidsredskap',),
'arbeidsredskaper': ('arbeidsredskap',),
'arbeidsredskapet': ('arbeidsredskap',),
'arbeidsrett': ('arbeidsrett',),
'arbeidsretten': ('arbeidsrett',),
'arbeidsrettene': ('arbeidsrett',),
'arbeidsretter': ('arbeidsrett',),
'arbeidsskole': ('arbeidsskole',),
'arbeidsskolen': ('arbeidsskole',),
'arbeidsskolene': ('arbeidsskole',),
'arbeidsskoler': ('arbeidsskole',),
'arbeidsstans': ('arbeidsstans',),
'arbeidsstansen': ('arbeidsstans',),
'arbeidsstansene': ('arbeidsstans',),
'arbeidsstanser': ('arbeidsstans',),
'arbeidsstilling': ('arbeidsstilling',),
'arbeidsstillinga': ('arbeidsstilling',),
'arbeidsstillingen': ('arbeidsstilling',),
'arbeidsstillingene': ('arbeidsstilling',),
'arbeidsstillinger': ('arbeidsstilling',),
'arbeidsstokk': ('arbeidsstokk',),
'arbeidsstokken': ('arbeidsstokk',),
'arbeidsstokkene': ('arbeidsstokk',),
'arbeidsstokker': ('arbeidsstokk',),
'arbeidsstudie': ('arbeidsstudie',),
'arbeidsstudien': ('arbeidsstudie',),
'arbeidsstudiene': ('arbeidsstudie',),
'arbeidsstudier': ('arbeidsstudie',),
'arbeidsstudietekniker': ('arbeidsstudietekniker',),
'arbeidsstudieteknikere': ('arbeidsstudietekniker',),
'arbeidsstudieteknikeren': ('arbeidsstudietekniker',),
'arbeidsstudieteknikerer': ('arbeidsstudietekniker',),
'arbeidsstudieteknikerne': ('arbeidsstudietekniker',),
'arbeidsstyrke': ('arbeidsstyrke',),
'arbeidsstyrken': ('arbeidsstyrke',),
'arbeidsstyrkene': ('arbeidsstyrke',),
'arbeidsstyrker': ('arbeidsstyrke',),
'arbeidssøker': ('arbeidssøker',),
'arbeidssøkere': ('arbeidssøker',),
'arbeidssøkeren': ('arbeidssøker',),
'arbeidssøkerer': ('arbeidssøker',),
'arbeidssøkerne': ('arbeidssøker',),
'arbeidstaker': ('arbeidstaker',),
'arbeidstakere': ('arbeidstaker',),
'arbeidstakeren': ('arbeidstaker',),
'arbeidstakerer': ('arbeidstaker',),
'arbeidstakerne': ('arbeidstaker',),
'arbeidstegning': ('arbeidstegning',),
'arbeidstegninga': ('arbeidstegning',),
'arbeidstegningen': ('arbeidstegning',),
'arbeidstegningene': ('arbeidstegning',),
'arbeidstegninger': ('arbeidstegning',),
'arbeidsteknikk': ('arbeidsteknikk',),
'arbeidsteknikken': ('arbeidsteknikk',),
'arbeidsteknikkene': ('arbeidsteknikk',),
'arbeidsteknikker': ('arbeidsteknikk',),
'arbeidstempi': ('arbeidstempo',),
'arbeidstempiene': ('arbeidstempo',),
'arbeidstempo': ('arbeidstempo',),
'arbeidstempoa': ('arbeidstempo',),
'arbeidstempoene': ('arbeidstempo',),
'arbeidstempoer': ('arbeidstempo',),
'arbeidstempoet': ('arbeidstempo',),
'arbeidsterapeut': ('arbeidsterapeut',),
'arbeidsterapeuten': ('arbeidsterapeut',),
'arbeidsterapeutene': ('arbeidsterapeut',),
'arbeidsterapeuter': ('arbeidsterapeut',),
'arbeidsterapi': ('arbeidsterapi',),
'arbeidsterapien': ('arbeidsterapi',),
'arbeidsterapiene': ('arbeidsterapi',),
'arbeidsterapier': ('arbeidsterapi',),
'arbeidstid': ('arbeidstid',),
'arbeidstida': ('arbeidstid',),
'arbeidstiden': ('arbeidstid',),
'arbeidstidene': ('arbeidstid',),
'arbeidstider': ('arbeidstid',),
'arbeidstillatelse': ('arbeidstillatelse',),
'arbeidstillatelsen': ('arbeidstillatelse',),
'arbeidstillatelsene': ('arbeidstillatelse',),
'arbeidstillatelser': ('arbeidstillatelse',),
'arbeidstilsyn': ('arbeidstilsyn',),
'arbeidstilsyna': ('arbeidstilsyn',),
'arbeidstilsynene': ('arbeidstilsyn',),
'arbeidstilsynet': ('arbeidstilsyn',),
'arbeidstitlene': ('arbeidstittel',),
'arbeidstitler': ('arbeidstittel',),
'arbeidstittel': ('arbeidstittel',),
'arbeidstittelen': ('arbeidstittel',),
'arbeidstrell': ('arbeidstrell',),
'arbeidstrellen': ('arbeidstrell',),
'arbeidstrellene': ('arbeidstrell',),
'arbeidstreller': ('arbeidstrell',),
'arbeidstvist': ('arbeidstvist',),
'arbeidstvisten': ('arbeidstvist',),
'arbeidstvistene': ('arbeidstvist',),
'arbeidstvister': ('arbeidstvist',),
'arbeidsuka': ('arbeidsuke',),
'arbeidsuke': ('arbeidsuke',),
'arbeidsuken': ('arbeidsuke',),
'arbeidsukene': ('arbeidsuke',),
'arbeidsuker': ('arbeidsuke',),
'arbeidsuka': ('arbeidsuke',),
'arbeidsuke': ('arbeidsuke',),
'arbeidsuken': ('arbeidsuke',),
'arbeidsukene': ('arbeidsuke',),
'arbeidsuker': ('arbeidsuke',),
'arbeidsulykka': ('arbeidsulykke',),
'arbeidsulykke': ('arbeidsulykke',),
'arbeidsulykken': ('arbeidsulykke',),
'arbeidsulykkene': ('arbeidsulykke',),
'arbeidsulykker': ('arbeidsulykke',),
'arbeidsutvalg': ('arbeidsutvalg',),
'arbeidsutvalga': ('arbeidsutvalg',),
'arbeidsutvalgene': ('arbeidsutvalg',),
'arbeidsutvalget': ('arbeidsutvalg',),
'arbeidsveka': ('arbeidsveke',),
'arbeidsveke': ('arbeidsveke',),
'arbeidsveken': ('arbeidsveke',),
'arbeidsvekene': ('arbeidsveke',),
'arbeidsveker': ('arbeidsveke',),
'arbeidsveka': ('arbeidsveke',),
'arbeidsveke': ('arbeidsveke',),
'arbeidsveken': ('arbeidsveke',),
'arbeidsvekene': ('arbeidsveke',),
'arbeidsveker': ('arbeidsveke',),
'arbeidsvilkår': ('arbeidsvilkår',),
'arbeidsvilkåra': ('arbeidsvilkår',),
'arbeidsvilkårene': ('arbeidsvilkår',),
'arbeidsvilkåret': ('arbeidsvilkår',),
'arbeidsår': ('arbeidsår',),
'arbeidsåra': ('arbeidsår',),
'arbeidsårene': ('arbeidsår',),
'arbeidsåret': ('arbeidsår',),
'arbeidsøkt': ('arbeidsøkt',),
'arbeidsøkta': ('arbeidsøkt',),
'arbeidsøkten': ('arbeidsøkt',),
'arbeidsøktene': ('arbeidsøkt',),
'arbeidsøkter': ('arbeidsøkt',),
'arbitrasje': ('arbitrasje',),
'arbitrasjen': ('arbitrasje',),
'arbitrasjene': ('arbitrasje',),
'arbitrasjer': ('arbitrasje',),
'arboret': ('arboret',),
'arboreta': ('arboret',),
'arboretene': ('arboret',),
'arboreter': ('arboret',),
'arboretet': ('arboret',),
'arboretum': ('arboretum',),
'arboretuma': ('arboretum',),
'arboretumene': ('arboretum',),
'arboretumer': ('arboretum',),
'arboretumet': ('arboretum',),
'ard': ('ard',),
'arden': ('ard',),
'ardene': ('ard',),
'arder': ('ard',),
'areal': ('areal',),
'areala': ('areal',),
'arealene': ('areal',),
'arealer': ('areal',),
'arealet': ('areal',),
'arealbruk': ('arealbruk',),
'arealbruka': ('arealbruk',),
'arealbruken': ('arealbruk',),
'arealbrukene': ('arealbruk',),
'arealbruker': ('arealbruk',),
'arealbruket': ('arealbruk',),
'arealdisponering': ('arealdisponering',),
'arealdisponeringa': ('arealdisponering',),
'arealdisponeringen': ('arealdisponering',),
'arealdisponeringene': ('arealdisponering',),
'arealdisponeringer': ('arealdisponering',),
'arealplan': ('arealplan',),
'arealplanen': ('arealplan',),
'arealplanene': ('arealplan',),
'arealplaner': ('arealplan',),
'arena': ('arena',),
'arenaen': ('arena',),
'arenaene': ('arena',),
'arenaer': ('arena',),
'areometer': ('areometer',),
'areometeret': ('areometer',),
'areometra': ('areometer',),
'areometre': ('areometer',),
'areometrene': ('areometer',),
'areometret': ('areometer',),
'argentiner': ('argentiner',),
'argentinere': ('argentiner',),
'argentineren': ('argentiner',),
'argentinerer': ('argentiner',),
'argentinerne': ('argentiner',),
'argon': ('argon',),
'argona': ('argon',),
'argonene': ('argon',),
'argonet': ('argon',),
'argot': ('argot',),
'argoten': ('argot',),
'argotene': ('argot',),
'argoter': ('argot',),
'argument': ('argument',),
'argumenta': ('argument',),
'argumentene': ('argument',),
'argumenter': ('argument',),
'argumentet': ('argument',),
'argumentasjon': ('argumentasjon',),
'argumentasjonen': ('argumentasjon',),
'argumentasjonene': ('argumentasjon',),
'argumentasjoner': ('argumentasjon',),
'argumentering': ('argumentering',),
'argumenteringa': ('argumentering',),
'argumenteringen': ('argumentering',),
'argumenteringene': ('argumentering',),
'argumenteringer': ('argumentering',),
'argusblikk': ('argusblikk',),
'argusblikka': ('argusblikk',),
'argusblikkene': ('argusblikk',),
'argusblikket': ('argusblikk',),
'argusøya': ('argusøye',),
'argusøye': ('argusøye',),
'argusøyene': ('argusøye',),
'argusøyer': ('argusøye',),
'argusøyet': ('argusøye',),
'argusøyne': ('argusøye',),
'argusøynene': ('argusøye',),
'ariadnetråd': ('ariadnetråd',),
'ariadnetråden': ('ariadnetråd',),
'ariadnetrådene': ('ariadnetråd',),
'ariadnetråder': ('ariadnetråd',),
'ariditet': ('ariditet',),
'ariditeten': ('ariditet',),
'ariditetene': ('ariditet',),
'ariditeter': ('ariditet',),
'arie': ('arie',),
'arien': ('arie',),
'ariene': ('arie',),
'arier': ('arie',),
'arier': ('arier',),
'ariere': ('arier',),
'arieren': ('arier',),
'arierer': ('arier',),
'arierne': ('arier',),
'arietta': ('arietta',),
'ariettaen': ('arietta',),
'ariettaene': ('arietta',),
'ariettaer': ('arietta',),
'arild': ('arild',),
'aristokrat': ('aristokrat',),
'aristokraten': ('aristokrat',),
'aristokratene': ('aristokrat',),
'aristokrater': ('aristokrat',),
'aristokrati': ('aristokrati',),
'aristokratia': ('aristokrati',),
'aristokratiene': ('aristokrati',),
'aristokratier': ('aristokrati',),
'aristokratiet': ('aristokrati',),
'aritmetiker': ('aritmetiker',),
'aritmetikere': ('aritmetiker',),
'aritmetikeren': ('aritmetiker',),
'aritmetikerer': ('aritmetiker',),
'aritmetikerne': ('aritmetiker',),
'aritmetikk': ('aritmetikk',),
'aritmetikken': ('aritmetikk',),
'aritmetikkene': ('aritmetikk',),
'aritmetikker': ('aritmetikk',),
'ark': ('ark',),
'arken': ('ark',),
'arkene': ('ark',),
'arker': ('ark',),
'ark': ('ark',),
'arken': ('ark',),
'arkene': ('ark',),
'arker': ('ark',),
'ark': ('ark',),
'arka': ('ark',),
'arkene': ('ark',),
'arket': ('ark',),
'arkade': ('arkade',),
'arkaden': ('arkade',),
'arkadene': ('arkade',),
'arkader': ('arkade',),
'arkaisme': ('arkaisme',),
'arkaismen': ('arkaisme',),
'arkaismene': ('arkaisme',),
'arkaismer': ('arkaisme',),
'arkebuse': ('arkebuse',),
'arkebusen': ('arkebuse',),
'arkebusene': ('arkebuse',),
'arkebuser': ('arkebuse',),
'arkeolog': ('arkeolog',),
'arkeologen': ('arkeolog',),
'arkeologene': ('arkeolog',),
'arkeologer': ('arkeolog',),
'arkeologi': ('arkeologi',),
'arkeologien': ('arkeologi',),
'arkeologiene': ('arkeologi',),
'arkeologier': ('arkeologi',),
'arketyp': ('arketyp',),
'arketypen': ('arketyp',),
'arketypene': ('arketyp',),
'arketyper': ('arketyp',),
'arkipel': ('arkipel',),
'arkipela': ('arkipel',),
'arkipelene': ('arkipel',),
'arkipeler': ('arkipel',),
'arkipelet': ('arkipel',),
'arkipelag': ('arkipelag',),
'arkipelaga': ('arkipelag',),
'arkipelagene': ('arkipelag',),
'arkipelager': ('arkipelag',),
'arkipelaget': ('arkipelag',),
'arkitekt': ('arkitekt',),
'arkitekten': ('arkitekt',),
'arkitektene': ('arkitekt',),
'arkitekter': ('arkitekt',),
'arkitekthøgskole': ('arkitekthøgskole',),
'arkitekthøgskolen': ('arkitekthøgskole',),
'arkitekthøgskolene': ('arkitekthøgskole',),
'arkitekthøgskoler': ('arkitekthøgskole',),
'arkitekthøyskole': ('arkitekthøyskole',),
'arkitekthøyskolen': ('arkitekthøyskole',),
'arkitekthøyskolene': ('arkitekthøyskole',),
'arkitekthøyskoler': ('arkitekthøyskole',),
'arkitektkontor': ('arkitektkontor',),
'arkitektkontora': ('arkitektkontor',),
'arkitektkontorene': ('arkitektkontor',),
'arkitektkontorer': ('arkitektkontor',),
'arkitektkontoret': ('arkitektkontor',),
'arkitektur': ('arkitektur',),
'arkitekturen': ('arkitektur',),
'arkitekturene': ('arkitektur',),
'arkitekturer': ('arkitektur',),
'arkiv': ('arkiv',),
'arkiva': ('arkiv',),
'arkivene': ('arkiv',),
'arkiver': ('arkiv',),
'arkivet': ('arkiv',),
'arkivalie': ('arkivalie',),
'arkivalien': ('arkivalie',),
'arkivaliene': ('arkivalie',),
'arkivalier': ('arkivalie',),
'arkivar': ('arkivar',),
'arkivaren': ('arkivar',),
'arkivarene': ('arkivar',),
'arkivarer': ('arkivar',),
'arkivnøkkel': ('arkivnøkkel',),
'arkivnøkkelen': ('arkivnøkkel',),
'arkivnøklene': ('arkivnøkkel',),
'arkivnøkler': ('arkivnøkkel',),
'arkivsak': ('arkivsak',),
'arkivsaka': ('arkivsak',),
'arkivsaken': ('arkivsak',),
'arkivsakene': ('arkivsak',),
'arkivsaker': ('arkivsak',),
'arkivsjef': ('arkivsjef',),
'arkivsjefen': ('arkivsjef',),
'arkivsjefene': ('arkivsjef',),
'arkivsjefer': ('arkivsjef',),
'arkivstyrer': ('arkivstyrer',),
'arkivstyrere': ('arkivstyrer',),
'arkivstyreren': ('arkivstyrer',),
'arkivstyrerer': ('arkivstyrer',),
'arkivstyrerne': ('arkivstyrer',),
'arkivsystem': ('arkivsystem',),
'arkivsystema': ('arkivsystem',),
'arkivsystemene': ('arkivsystem',),
'arkivsystemer': ('arkivsystem',),
'arkivsystemet': ('arkivsystem',),
'arkont': ('arkont',),
'arkonten': ('arkont',),
'arkontene': ('arkont',),
'arkonter': ('arkont',),
'arktikfront': ('arktikfront',),
'arktikfronten': ('arktikfront',),
'arktikfrontene': ('arktikfront',),
'arktikfronter': ('arktikfront',),
'arktikluft': ('arktikluft',),
'arktiklufta': ('arktikluft',),
'arktikluften': ('arktikluft',),
'arktikluftene': ('arktikluft',),
'arktiklufter': ('arktikluft',),
'arm': ('arm',),
'armen': ('arm',),
'armene': ('arm',),
'armer': ('arm',),
'armeen': ('armé',),
'armeene': ('armé',),
'armeer': ('armé',),
'armé': ('armé',),
'arméen': ('armé',),
'arméene': ('armé',),
'arméer': ('armé',),
'armégevær': ('armégevær',),
'armégeværa': ('armégevær',),
'armégeværene': ('armégevær',),
'armégeværer': ('armégevær',),
'armégeværet': ('armégevær',),
'armégruppa': ('armégruppe',),
'armégruppe': ('armégruppe',),
'armégruppen': ('armégruppe',),
'armégruppene': ('armégruppe',),
'armégrupper': ('armégruppe',),
'armada': ('armada',),
'armadaen': ('armada',),
'armadaene': ('armada',),
'armadaer': ('armada',),
'armatur': ('armatur',),
'armaturen': ('armatur',),
'armaturene': ('armatur',),
'armaturer': ('armatur',),
'armaturdel': ('armaturdel',),
'armaturdelen': ('armaturdel',),
'armaturdelene': ('armaturdel',),
'armaturdeler': ('armaturdel',),
'armaturfabrikk': ('armaturfabrikk',),
'armaturfabrikken': ('armaturfabrikk',),
'armaturfabrikkene': ('armaturfabrikk',),
'armaturfabrikker': ('armaturfabrikk',),
'armband': ('armband',),
'armbanda': ('armband',),
'armbandene': ('armband',),
'armbandet': ('armband',),
'armbandsur': ('armbandsur',),
'armbandsura': ('armbandsur',),
'armbandsurene': ('armbandsur',),
'armbandsuret': ('armbandsur',),
'armbind': ('armbind',),
'armbinda': ('armbind',),
'armbindene': ('armbind',),
'armbindet': ('armbind',),
'armbrott': ('armbrott',),
'armbrotta': ('armbrott',),
'armbrottene': ('armbrott',),
'armbrottet': ('armbrott',),
'armbrudd': ('armbrudd',),
'armbrudda': ('armbrudd',),
'armbruddene': ('armbrudd',),
'armbruddet': ('armbrudd',),
'armbrøst': ('armbrøst',),
'armbrøsten': ('armbrøst',),
'armbrøstene': ('armbrøst',),
'armbrøster': ('armbrøst',),
'armbånd': ('armbånd',),
'armbånda': ('armbånd',),
'armbåndene': ('armbånd',),
'armbåndet': ('armbånd',),
'armbåndsur': ('armbåndsur',),
'armbåndsura': ('armbåndsur',),
'armbåndsurene': ('armbåndsur',),
'armbåndsuret': ('armbåndsur',),
'armener': ('armener',),
'armenere': ('armener',),
'armeneren': ('armener',),
'armenerer': ('armener',),
'armenerne': ('armener',),
'armenier': ('armenier',),
'armeniere': ('armenier',),
'armenieren': ('armenier',),
'armenierer': ('armenier',),
'armenierne': ('armenier',),
'armensk': ('armensk',),
'armensken': ('armensk',),
'armenskene': ('armensk',),
'armensker': ('armensk',),
'armering': ('armering',),
'armeringa': ('armering',),
'armeringen': ('armering',),
'armeringene': ('armering',),
'armeringer': ('armering',),
'armeringsjern': ('armeringsjern',),
'armeringsjerna': ('armeringsjern',),
'armeringsjernene': ('armeringsjern',),
'armeringsjernet': ('armeringsjern',),
'armeringsstål': ('armeringsstål',),
'armeringsståla': ('armeringsstål',),
'armeringsstålene': ('armeringsstål',),
'armeringsstålet': ('armeringsstål',),
'armfoting': ('armfoting',),
'armfotingen': ('armfoting',),
'armfotingene': ('armfoting',),
'armfotinger': ('armfoting',),
'armføtting': ('armføtting',),
'armføttingen': ('armføtting',),
'armføttingene': ('armføtting',),
'armføttinger': ('armføtting',),
'armgang': ('armgang',),
'armgangen': ('armgang',),
'armgangene': ('armgang',),
'armganger': ('armgang',),
'armheving': ('armheving',),
'armhevinga': ('armheving',),
'armhevingen': ('armheving',),
'armhevingene': ('armheving',),
'armhevinger': ('armheving',),
'armhevning': ('armhevning',),
'armhevninga': ('armhevning',),
'armhevningen': ('armhevning',),
'armhevningene': ('armhevning',),
'armhevninger': ('armhevning',),
'armhola': ('armhole',),
'armhole': ('armhole',),
'armholen': ('armhole',),
'armholene': ('armhole',),
'armholer': ('armhole',),
'armhula': ('armhule',),
'armhule': ('armhule',),
'armhulen': ('armhule',),
'armhulene': ('armhule',),
'armhuler': ('armhule',),
'arming': ('arming',),
'armingen': ('arming',),
'armingene': ('arming',),
'arminger': ('arming',),
'armkrok': ('armkrok',),
'armkroken': ('armkrok',),
'armkrokene': ('armkrok',),
'armkroker': ('armkrok',),
'armlena': ('armlene',),
'armlene': ('armlene',),
'armlenene': ('armlene',),
'armlener': ('armlene',),
'armlenet': ('armlene',),
'armod': ('armod',),
'armoda': ('armod',),
'armoden': ('armod',),
'armodene': ('armod',),
'armoder': ('armod',),
'armodsdom': ('armodsdom',),
'armodsdommen': ('armodsdom',),
'armodsdommene': ('armodsdom',),
'armodsdommer': ('armodsdom',),
'armodsfolk': ('armodsfolk',),
'armodsfolka': ('armodsfolk',),
'armodsfolkene': ('armodsfolk',),
'armodsfolket': ('armodsfolk',),
'armodskrek': ('armodskrek',),
'armodskreka': ('armodskrek',),
'armodskrekene': ('armodskrek',),
'armodskreket': ('armodskrek',),
'armodskrok': ('armodskrok',),
'armodskroken': ('armodskrok',),
'armodskrokene': ('armodskrok',),
'armodskroker': ('armodskrok',),
'armodskryp': ('armodskryp',),
'armodskrypa': ('armodskryp',),
'armodskrypen': ('armodskryp',),
'armodskrypene': ('armodskryp',),
'armodskrypet': ('armodskryp',),
'armodskår': ('armodskår',),
'armodskåra': ('armodskår',),
'armodskårene': ('armodskår',),
'armodskåret': ('armodskår',),
'armring': ('armring',),
'armringen': ('armring',),
'armringene': ('armring',),
'armringer': ('armring',),
'armrom': ('armrom',),
'armromma': ('armrom',),
'armrommene': ('armrom',),
'armrommet': ('armrom',),
'armslag': ('armslag',),
'armslaga': ('armslag',),
'armslagene': ('armslag',),
'armslaget': ('armslag',),
'armsving': ('armsving',),
'armsvingen': ('armsving',),
'armsvingene': ('armsving',),
'armsvinger': ('armsving',),
'armtak': ('armtak',),
'armtaka': ('armtak',),
'armtakene': ('armtak',),
'armtaket': ('armtak',),
'arne': ('arne',),
'arnen': ('arne',),
'arnene': ('arne',),
'arner': ('arne',),
'arnested': ('arnested',),
'arnestedene': ('arnested',),
'arnesteder': ('arnested',),
'arnestedet': ('arnested',),
'aroma': ('aroma',),
'aromaen': ('aroma',),
'aromaene': ('aroma',),
'aromaer': ('aroma',),
'arr': ('arr',),
'arra': ('arr',),
'arrene': ('arr',),
'arret': ('arr',),
'arrangement': ('arrangement',),
'arrangementa': ('arrangement',),
'arrangementene': ('arrangement',),
'arrangementer': ('arrangement',),
'arrangementet': ('arrangement',),
'arrangør': ('arrangør',),
'arrangøren': ('arrangør',),
'arrangørene': ('arrangør',),
'arrangører': ('arrangør',),
'arrangørklubb': ('arrangørklubb',),
'arrangørklubben': ('arrangørklubb',),
'arrangørklubbene': ('arrangørklubb',),
'arrangørklubber': ('arrangørklubb',),
'arrest': ('arrest',),
'arresten': ('arrest',),
'arrestene': ('arrest',),
'arrester': ('arrest',),
'arrestant': ('arrestant',),
'arrestanten': ('arrestant',),
'arrestantene': ('arrestant',),
'arrestanter': ('arrestant',),
'arrestasjon': ('arrestasjon',),
'arrestasjonen': ('arrestasjon',),
'arrestasjonene': ('arrestasjon',),
'arrestasjoner': ('arrestasjon',),
'arrestering': ('arrestering',),
'arresteringa': ('arrestering',),
'arresteringen': ('arrestering',),
'arresteringene': ('arrestering',),
'arresteringer': ('arrestering',),
'arrestkrav': ('arrestkrav',),
'arrestkrava': ('arrestkrav',),
'arrestkravene': ('arrestkrav',),
'arrestkravet': ('arrestkrav',),
'arrestlokala': ('arrestlokale',),
'arrestlokale': ('arrestlokale',),
'arrestlokalene': ('arrestlokale',),
'arrestlokaler': ('arrestlokale',),
'arrestlokalet': ('arrestlokale',),
'arrestordre': ('arrestordre',),
'arrestordren': ('arrestordre',),
'arrestordrene': ('arrestordre',),
'arrestordrer': ('arrestordre',),
'arresttillatelse': ('arresttillatelse',),
'arresttillatelsen': ('arresttillatelse',),
'arresttillatelsene': ('arresttillatelse',),
'arresttillatelser': ('arresttillatelse',),
'arrighet': ('arrighet',),
'arrigheta': ('arrighet',),
'arrigheten': ('arrighet',),
'arrighetene': ('arrighet',),
'arrigheter': ('arrighet',),
'arrigskap': ('arrigskap',),
'arrigskapen': ('arrigskap',),
'arrigskapene': ('arrigskap',),
'arrigskaper': ('arrigskap',),
'arroganse': ('arroganse',),
'arrogansen': ('arroganse',),
'arrogansene': ('arroganse',),
'arroganser': ('arroganse',),
'arrondering': ('arrondering',),
'arronderinga': ('arrondering',),
'arronderingen': ('arrondering',),
'arronderingene': ('arrondering',),
'arronderinger': ('arrondering',),
'arrondissement': ('arrondissement',),
'arrondissementa': ('arrondissement',),
'arrondissementene': ('arrondissement',),
'arrondissementer': ('arrondissement',),
'arrondissementet': ('arrondissement',),
'ars': ('ars',),
'artes': ('ars',),
'arsen': ('arsen',),
'arsena': ('arsen',),
'arsenene': ('arsen',),
'arsenet': ('arsen',),
'arsenal': ('arsenal',),
'arsenala': ('arsenal',),
'arsenalene': ('arsenal',),
'arsenaler': ('arsenal',),
'arsenalet': ('arsenal',),
'arsenalforvalter': ('arsenalforvalter',),
'arsenalforvaltere': ('arsenalforvalter',),
'arsenalforvalteren': ('arsenalforvalter',),
'arsenalforvalterer': ('arsenalforvalter',),
'arsenalforvalterne': ('arsenalforvalter',),
'arsenikk': ('arsenikk',),
'arsenikken': ('arsenikk',),
'arsenikkene': ('arsenikk',),
'arsenikker': ('arsenikk',),
'arsenikkforgiftning': ('arsenikkforgiftning',),
'arsenikkforgiftninga': ('arsenikkforgiftning',),
'arsenikkforgiftningen': ('arsenikkforgiftning',),
'arsenikkforgiftningene': ('arsenikkforgiftning',),
'arsenikkforgiftninger': ('arsenikkforgiftning',),
'art': ('art',),
'arta': ('art',),
'arten': ('art',),
'artene': ('art',),
'arter': ('art',),
'art noveau': ('art noveau',),
'arterie': ('arterie',),
'arterien': ('arterie',),
'arteriene': ('arterie',),
'arterier': ('arterie',),
'arterieblod': ('arterieblod',),
'arteriebloda': ('arterieblod',),
'arterieblodene': ('arterieblod',),
'arterieblodet': ('arterieblod',),
'arterieklemma': ('arterieklemme',),
'arterieklemme': ('arterieklemme',),
'arterieklemmen': ('arterieklemme',),
'arterieklemmene': ('arterieklemme',),
'arterieklemmer': ('arterieklemme',),
'arteriosklerose': ('arteriosklerose',),
'arteriosklerosen': ('arteriosklerose',),
'arteriosklerosene': ('arteriosklerose',),
'arterioskleroser': ('arteriosklerose',),
'artianer': ('artianer',),
'artianere': ('artianer',),
'artianeren': ('artianer',),
'artianerer': ('artianer',),
'artianerne': ('artianer',),
'artighet': ('artighet',),
'artigheta': ('artighet',),
'artigheten': ('artighet',),
'artighetene': ('artighet',),
'artigheter': ('artighet',),
'artikkel': ('artikkel',),
'artikkelen': ('artikkel',),
'artiklene': ('artikkel',),
'artikler': ('artikkel',),
'artikkelforfatter': ('artikkelforfatter',),
'artikkelforfattere': ('artikkelforfatter',),
'artikkelforfatteren': ('artikkelforfatter',),
'artikkelforfatterer': ('artikkelforfatter',),
'artikkelforfatterne': ('artikkelforfatter',),
'artikkelskribent': ('artikkelskribent',),
'artikkelskribenten': ('artikkelskribent',),
'artikkelskribentene': ('artikkelskribent',),
'artikkelskribenter': ('artikkelskribent',),
'artikkelskriver': ('artikkelskriver',),
'artikkelskrivere': ('artikkelskriver',),
'artikkelskriveren': ('artikkelskriver',),
'artikkelskriverer': ('artikkelskriver',),
'artikkelskriverne': ('artikkelskriver',),
'artikulasjon': ('artikulasjon',),
'artikulasjonen': ('artikulasjon',),
'artikulasjonene': ('artikulasjon',),
'artikulasjoner': ('artikulasjon',),
'artikulasjonsorgan': ('artikulasjonsorgan',),
'artikulasjonsorgana': ('artikulasjonsorgan',),
'artikulasjonsorganene': ('artikulasjonsorgan',),
'artikulasjonsorganer': ('artikulasjonsorgan',),
'artikulasjonsorganet': ('artikulasjonsorgan',),
'artikulasjonssted': ('artikulasjonssted',),
'artikulasjonsstedene': ('artikulasjonssted',),
'artikulasjonssteder': ('artikulasjonssted',),
'artikulasjonsstedet': ('artikulasjonssted',),
'artilleri': ('artilleri',),
'artilleria': ('artilleri',),
'artilleriene': ('artilleri',),
'artillerier': ('artilleri',),
'artilleriet': ('artilleri',),
'artilleriangrep': ('artilleriangrep',),
'artilleriangrepa': ('artilleriangrep',),
'artilleriangrepene': ('artilleriangrep',),
'artilleriangrepet': ('artilleriangrep',),
'artillerield': ('artillerield',),
'artillerielden': ('artillerield',),
'artillerieldene': ('artillerield',),
'artillerielder': ('artillerield',),
'artilleriild': ('artilleriild',),
'artilleriilden': ('artilleriild',),
'artilleriildene': ('artilleriild',),
'artilleriilder': ('artilleriild',),
'artillerioffiser': ('artillerioffiser',),
'artillerioffiseren': ('artillerioffiser',),
'artillerioffiserene': ('artillerioffiser',),
'artillerioffiserer': ('artillerioffiser',),
'artilleriregiment': ('artilleriregiment',),
'artilleriregimenta': ('artilleriregiment',),
'artilleriregimentene': ('artilleriregiment',),
'artilleriregimenter': ('artilleriregiment',),
'artilleriregimentet': ('artilleriregiment',),
'artillerist': ('artillerist',),
'artilleristen': ('artillerist',),
'artilleristene': ('artillerist',),
'artillerister': ('artillerist',),
'artisjokk': ('artisjokk',),
'artisjokken': ('artisjokk',),
'artisjokkene': ('artisjokk',),
'artisjokker': ('artisjokk',),
'artiskokk': ('artiskokk',),
'artiskokken': ('artiskokk',),
'artiskokkene': ('artiskokk',),
'artiskokker': ('artiskokk',),
'artist': ('artist',),
'artisten': ('artist',),
'artistene': ('artist',),
'artister': ('artist',),
'artisteri': ('artisteri',),
'artisteria': ('artisteri',),
'artisteriene': ('artisteri',),
'artisterier': ('artisteri',),
'artisteriet': ('artisteri',),
'artistopptreden': ('artistopptreden',),
'artistopptredenen': ('artistopptreden',),
'artistopptredenene': ('artistopptreden',),
'artistopptredener': ('artistopptreden',),
'artium': ('artium',),
'artiumen': ('artium',),
'artiumene': ('artium',),
'artiumer': ('artium',),
'artiumsfag': ('artiumsfag',),
'artiumsfaga': ('artiumsfag',),
'artiumsfagene': ('artiumsfag',),
'artiumsfaget': ('artiumsfag',),
'artiumskarakter': ('artiumskarakter',),
'artiumskarakteren': ('artiumskarakter',),
'artiumskarakterene': ('artiumskarakter',),
'artiumskarakterer': ('artiumskarakter',),
'artiumskull': ('artiumskull',),
'artiumskulla': ('artiumskull',),
'artiumskullene': ('artiumskull',),
'artiumskullet': ('artiumskull',),
'artiumslinja': ('artiumslinje',),
'artiumslinje': ('artiumslinje',),
'artiumslinjen': ('artiumslinje',),
'artiumslinjene': ('artiumslinje',),
'artiumslinjer': ('artiumslinje',),
'artiumsresultat': ('artiumsresultat',),
'artiumsresultata': ('artiumsresultat',),
'artiumsresultatene': ('artiumsresultat',),
'artiumsresultater': ('artiumsresultat',),
'artiumsresultatet': ('artiumsresultat',),
'artiumsvitnesbyrd': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrda': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrdene': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrdet': ('artiumsvitnesbyrd',),
'artiumsår': ('artiumsår',),
'artiumsåra': ('artiumsår',),
'artiumsårene': ('artiumsår',),
'artiumsåret': ('artiumsår',),
'artotek': ('artotek',),
'artoteka': ('artotek',),
'artotekene': ('artotek',),
'artoteker': ('artotek',),
'artoteket': ('artotek',),
'artritt': ('artritt',),
'artritten': ('artritt',),
'artrittene': ('artritt',),
'artritter': ('artritt',),
'artsbetegnelse': ('artsbetegnelse',),
'artsbetegnelsen': ('artsbetegnelse',),
'artsbetegnelsene': ('artsbetegnelse',),
'artsbetegnelser': ('artsbetegnelse',),
'artsforskjell': ('artsforskjell',),
'artsforskjellen': ('artsforskjell',),
'artsforskjellene': ('artsforskjell',),
'artsforskjeller': ('artsforskjell',),
'artsforsøk': ('artsforsøk',),
'artsforsøka': ('artsforsøk',),
'artsforsøkene': ('artsforsøk',),
'artsforsøket': ('artsforsøk',),
'artsfredning': ('artsfredning',),
'artsfredninga': ('artsfredning',),
'artsfredningen': ('artsfredning',),
'artsfredningene': ('artsfredning',),
'artsfredninger': ('artsfredning',),
'artskarakter': ('artskarakter',),
'artskarakteren': ('artskarakter',),
'artskarakterene': ('artskarakter',),
'artskarakterer': ('artskarakter',),
'artskrysning': ('artskrysning',),
'artskrysninga': ('artskrysning',),
'artskrysningen': ('artskrysning',),
'artskrysningene': ('artskrysning',),
'artskrysninger': ('artskrysning',),
'artskrysning': ('artskrysning',),
'artskrysninga': ('artskrysning',),
'artskrysningen': ('artskrysning',),
'artskrysningene': ('artskrysning',),
'artskrysninger': ('artskrysning',),
'artskryssing': ('artskryssing',),
'artskryssinga': ('artskryssing',),
'artskryssingen': ('artskryssing',),
'artskryssingene': ('artskryssing',),
'artskryssinger': ('artskryssing',),
'artsnavn': ('artsnavn',),
'artsnavna': ('artsnavn',),
'artsnavnene': ('artsnavn',),
'artsnavnet': ('artsnavn',),
'arv': ('arv',),
'arven': ('arv',),
'arvene': ('arv',),
'arver': ('arv',),
'arve': ('arve',),
'arven': ('arve',),
'arvene': ('arve',),
'arver': ('arve',),
'arveanlegg': ('arveanlegg',),
'arveanlegga': ('arveanlegg',),
'arveanleggene': ('arveanlegg',),
'arveanlegget': ('arveanlegg',),
'arveavgift': ('arveavgift',),
'arveavgifta': ('arveavgift',),
'arveavgiften': ('arveavgift',),
'arveavgiftene': ('arveavgift',),
'arveavgifter': ('arveavgift',),
'arvefall': ('arvefall',),
'arvefalla': ('arvefall',),
'arvefallene': ('arvefall',),
'arvefallet': ('arvefall',),
'arvefesta': ('arvefeste',),
'arvefeste': ('arvefeste',),
'arvefestene': ('arvefeste',),
'arvefester': ('arvefeste',),
'arvefestet': ('arvefeste',),
'arvefiende': ('arvefiende',),
'arvefienden': ('arvefiende',),
'arvefiendene': ('arvefiende',),
'arvefiender': ('arvefiende',),
'arvefyrste': ('arvefyrste',),
'arvefyrsten': ('arvefyrste',),
'arvefyrstene': ('arvefyrste',),
'arvefyrster': ('arvefyrste',),
'arvefølga': ('arvefølge',),
'arvefølge': ('arvefølge',),
'arvefølgen': ('arvefølge',),
'arvefølgene': ('arvefølge',),
'arvefølger': ('arvefølge',),
'arvefølgelov': ('arvefølgelov',),
'arvefølgeloven': ('arvefølgelov',),
'arvefølgelovene': ('arvefølgelov',),
'arvefølgelover': ('arvefølgelov',),
'arvegods': ('arvegods',),
'arvegodsa': ('arvegods',),
'arvegodsene': ('arvegods',),
'arvegodset': ('arvegods',),
'arvehygiene': ('arvehygiene',),
'arvehygienen': ('arvehygiene',),
'arvehygienene': ('arvehygiene',),
'arvehygiener': ('arvehygiene',),
'arvekonge': ('arvekonge',),
'arvekongen': ('arvekonge',),
'arvekongene': ('arvekonge',),
'arvekonger': ('arvekonge',),
'arvekrav': ('arvekrav',),
'arvekrava': ('arvekrav',),
'arvekravene': ('arvekrav',),
'arvekravet': ('arvekrav',),
'arvelater': ('arvelater',),
'arvelatere': ('arvelater',),
'arvelateren': ('arvelater',),
'arvelaterer': ('arvelater',),
'arvelaterne': ('arvelater',),
'arvelighetsforsking': ('arvelighetsforsking',),
'arvelighetsforskinga': ('arvelighetsforsking',),
'arvelighetsforskingen': ('arvelighetsforsking',),
'arvelighetsforskingene': ('arvelighetsforsking',),
'arvelighetsforskinger': ('arvelighetsforsking',),
'arvelighetsforskning': ('arvelighetsforskning',),
'arvelighetsforskninga': ('arvelighetsforskning',),
'arvelighetsforskningen': ('arvelighetsforskning',),
'arvelighetsforskningene': ('arvelighetsforskning',),
'arvelighetsforskninger': ('arvelighetsforskning',),
'arvelodd': ('arvelodd',),
'arvelodden': ('arvelodd',),
'arveloddene': ('arvelodd',),
'arvelodder': ('arvelodd',),
'arvelott': ('arvelott',),
'arvelotten': ('arvelott',),
'arvelottene': ('arvelott',),
'arvelotter': ('arvelott',),
'arvelov': ('arvelov',),
'arveloven': ('arvelov',),
'arvelovene': ('arvelov',),
'arvelover': ('arvelov',),
'arvelæra': ('arvelære',),
'arvelære': ('arvelære',),
'arvelæren': ('arvelære',),
'arvelærene': ('arvelære',),
'arvelærer': ('arvelære',),
'arveonkel': ('arveonkel',),
'arveonkelen': ('arveonkel',),
'arveonklene': ('arveonkel',),
'arveonkler': ('arveonkel',),
'arveord': ('arveord',),
'arveorda': ('arveord',),
'arveordene': ('arveord',),
'arveordet': ('arveord',),
'arvepakt': ('arvepakt',),
'arvepakta': ('arvepakt',),
'arvepakten': ('arvepakt',),
'arvepaktene': ('arvepakt',),
'arvepakter': ('arvepakt',),
'arveprins': ('arveprins',),
'arveprinsen': ('arveprins',),
'arveprinsene': ('arveprins',),
'arveprinser': ('arveprins',),
'arverett': ('arverett',),
'arveretten': ('arverett',),
'arverettene': ('arverett',),
'arveretter': ('arverett',),
'arvesmykka': ('arvesmykke',),
'arvesmykke': ('arvesmykke',),
'arvesmykkene': ('arvesmykke',),
'arvesmykker': ('arvesmykke',),
'arvesmykket': ('arvesmykke',),
'arvestykka': ('arvestykke',),
'arvestykke': ('arvestykke',),
'arvestykkene': ('arvestykke',),
'arvestykker': ('arvestykke',),
'arvestykket': ('arvestykke',),
'arvesynd': ('arvesynd',),
'arvesynda': ('arvesynd',),
'arvesynden': ('arvesynd',),
'arvesyndene': ('arvesynd',),
'arvesynder': ('arvesynd',),
'arvesølv': ('arvesølv',),
'arvesølva': ('arvesølv',),
'arvesølvene': ('arvesølv',),
'arvesølvet': ('arvesølv',),
'arvetanta': ('arvetante',),
'arvetante': ('arvetante',),
'arvetanten': ('arvetante',),
'arvetantene': ('arvetante',),
'arvetanter': ('arvetante',),
'arvetvist': ('arvetvist',),
'arvetvisten': ('arvetvist',),
'arvetvistene': ('arvetvist',),
'arvetvister': ('arvetvist',),
'arveøl': ('arveøl',),
'arveøla': ('arveøl',),
'arveølene': ('arveøl',),
'arveølet': ('arveøl',),
'arving': ('arving',),
'arvingen': ('arving',),
'arvingene': ('arving',),
'arvinger': ('arving',),
'arvtaker': ('arvtaker',),
'arvtakere': ('arvtaker',),
'arvtakeren': ('arvtaker',),
'arvtakerer': ('arvtaker',),
'arvtakerne': ('arvtaker',),
'as': ('as',),
'asa': ('as',),
'asene': ('as',),
'aset': ('as',),
'asal': ('asal',),
'asalen': ('asal',),
'asalene': ('asal',),
'asaler': ('asal',),
'asalbær': ('asalbær',),
'asalbæra': ('asalbær',),
'asalbærene': ('asalbær',),
'asalbæret': ('asalbær',),
'asalea': ('asalea',),
'asaleaen': ('asalea',),
'asaleaene': ('asalea',),
'asaleaer': ('asalea',),
'asbest': ('asbest',),
'asbesten': ('asbest',),
'asbestene': ('asbest',),
'asbester': ('asbest',),
'asbestduk': ('asbestduk',),
'asbestduken': ('asbestduk',),
'asbestdukene': ('asbestduk',),
'asbestduker': ('asbestduk',),
'asbestose': ('asbestose',),
'asbestosen': ('asbestose',),
'asbestosene': ('asbestose',),
'asbestoser': ('asbestose',),
'asbestpapp': ('asbestpapp',),
'asbestpappen': ('asbestpapp',),
'asbestpappene': ('asbestpapp',),
'asbestpapper': ('asbestpapp',),
'asbestplata': ('asbestplate',),
'asbestplate': ('asbestplate',),
'asbestplaten': ('asbestplate',),
'asbestplatene': ('asbestplate',),
'asbestplater': ('asbestplate',),
'ascendens': ('ascendens',),
'ascendensen': ('ascendens',),
'ascendensene': ('ascendens',),
'ascendenser': ('ascendens',),
'ascendent': ('ascendent',),
'ascendenten': ('ascendent',),
'ascendentene': ('ascendent',),
'ascendenter': ('ascendent',),
'asdic': ('asdic',),
'asdicen': ('asdic',),
'asdicene': ('asdic',),
'asdicer': ('asdic',),
'asen': ('asen',),
'asena': ('asen',),
'asenene': ('asen',),
'asener': ('asen',),
'asenet': ('asen',),
'aseptikk': ('aseptikk',),
'aseptikken': ('aseptikk',),
'aseptikkene': ('aseptikk',),
'aseptikker': ('aseptikk',),
'aserbajdsjaner': ('aserbajdsjaner',),
'aserbajdsjanere': ('aserbajdsjaner',),
'aserbajdsjaneren': ('aserbajdsjaner',),
'aserbajdsjanerer': ('aserbajdsjaner',),
'aserbajdsjanerne': ('aserbajdsjaner',),
'asfalt': ('asfalt',),
'asfalten': ('asfalt',),
'asfaltene': ('asfalt',),
'asfalter': ('asfalt',),
'asfaltdekka': ('asfaltdekke',),
'asfaltdekke': ('asfaltdekke',),
'asfaltdekkene': ('asfaltdekke',),
'asfaltdekker': ('asfaltdekke',),
'asfaltdekket': ('asfaltdekke',),
'asfaltjungel': ('asfaltjungel',),
'asfaltjungelen': ('asfaltjungel',),
'asfaltjunglene': ('asfaltjungel',),
'asfaltjungler': ('asfaltjungel',),
'asfaltpapp': ('asfaltpapp',),
'asfaltpappen': ('asfaltpapp',),
'asfaltpappene': ('asfaltpapp',),
'asfaltpapper': ('asfaltpapp',),
'asfaltsliter': ('asfaltsliter',),
'asfaltslitere': ('asfaltsliter',),
'asfaltsliteren': ('asfaltsliter',),
'asfaltsliterer': ('asfaltsliter',),
'asfaltsliterne': ('asfaltsliter',),
'asfalttraver': ('asfalttraver',),
'asfalttravere': ('asfalttraver',),
'asfalttraveren': ('asfalttraver',),
'asfalttraverer': ('asfalttraver',),
'asfalttraverne': ('asfalttraver',),
'asiasjuka': ('asiasjuke',),
'asiasjuke': ('asiasjuke',),
'asiasjuken': ('asiasjuke',),
'asiasjukene': ('asiasjuke',),
'asiasjuker': ('asiasjuke',),
'asiasyka': ('asiasyke',),
'asiasyke': ('asiasyke',),
'asiasyken': ('asiasyke',),
'asiasykene': ('asiasyke',),
'asiasyker': ('asiasyke',),
'asiat': ('asiat',),
'asiaten': ('asiat',),
'asiatene': ('asiat',),
'asiater': ('asiat',),
'asimut': ('asimut',),
'asimuten': ('asimut',),
'asimutene': ('asimut',),
'asimuter': ('asimut',),
'asimutspeil': ('asimutspeil',),
'asimutspeila': ('asimutspeil',),
'asimutspeilene': ('asimutspeil',),
'asimutspeilet': ('asimutspeil',),
'asjett': ('asjett',),
'asjetten': ('asjett',),
'asjettene': ('asjett',),
'asjetter': ('asjett',),
'ask': ('ask',),
'asken': ('ask',),
'askene': ('ask',),
'asker': ('ask',),
'aska': ('aske',),
'aske': ('aske',),
'asken': ('aske',),
'askene': ('aske',),
'asker': ('aske',),
'aska': ('aske',),
'aske': ('aske',),
'asken': ('aske',),
'askene': ('aske',),
'asker': ('aske',),
'askebeger': ('askebeger',),
'askebegeret': ('askebeger',),
'askebegra': ('askebeger',),
'askebegre': ('askebeger',),
'askebegrene': ('askebeger',),
'askebeger': ('askebeger',),
'askebegeret': ('askebeger',),
'askebegra': ('askebeger',),
'askebegre': ('askebeger',),
'askebegrene': ('askebeger',),
'askeladd': ('askeladd',),
'askeladden': ('askeladd',),
'askeladdene': ('askeladd',),
'askeladder': ('askeladd',),
'askeladd': ('askeladd',),
'askeladden': ('askeladd',),
'askeladdene': ('askeladd',),
'askeladder': ('askeladd',),
'askenas': ('askenas',),
'askenasen': ('askenas',),
'askenasene': ('askenas',),
'askenaser': ('askenas',),
'askenasi': ('askenasi',),
'askenasien': ('askenasi',),
'askenasim': ('askenasi',),
'askenasimene': ('askenasi',),
'askeonsdag': ('askeonsdag',),
'askeonsdagen': ('askeonsdag',),
'askeonsdagene': ('askeonsdag',),
'askeonsdager': ('askeonsdag',),
'askeonsdag': ('askeonsdag',),
'askeonsdagen': ('askeonsdag',),
'askeonsdagene': ('askeonsdag',),
'askeonsdager': ('askeonsdag',),
'askepott': ('askepott',),
'askepotten': ('askepott',),
'askepottene': ('askepott',),
'askepotter': ('askepott',),
'askepott': ('askepott',),
'askepotten': ('askepott',),
'askepottene': ('askepott',),
'askepotter': ('askepott',),
'askese': ('askese',),
'askesen': ('askese',),
'askesene': ('askese',),
'askeser': ('askese',),
'asket': ('asket',),
'asketen': ('asket',),
'asketene': ('asket',),
'asketer': ('asket',),
'asketre': ('asketre',),
'asketrea': ('asketre',),
'asketreet': ('asketre',),
'asketrær': ('asketre',),
'asketrærne': ('asketre',),
'askeved': ('askeved',),
'askeveden': ('askeved',),
'askevedene': ('askeved',),
'askeveder': ('askeved',),
'askorbinsyra': ('askorbinsyre',),
'askorbinsyre': ('askorbinsyre',),
'askorbinsyren': ('askorbinsyre',),
'askorbinsyrene': ('askorbinsyre',),
'askorbinsyrer': ('askorbinsyre',),
'asp': ('asp',),
'aspa': ('asp',),
'aspen': ('asp',),
'aspene': ('asp',),
'asper': ('asp',),
'asparges': ('asparges',),
'aspargesen': ('asparges',),
'aspargesene': ('asparges',),
'aspargeser': ('asparges',),
'aspargesbønna': ('aspargesbønne',),
'aspargesbønne': ('aspargesbønne',),
'aspargesbønnen': ('aspargesbønne',),
'aspargesbønnene': ('aspargesbønne',),
'aspargesbønner': ('aspargesbønne',),
'aspargesplanta': ('aspargesplante',),
'aspargesplante': ('aspargesplante',),
'aspargesplanten': ('aspargesplante',),
'aspargesplantene': ('aspargesplante',),
'aspargesplanter': ('aspargesplante',),
'aspargessuppa': ('aspargessuppe',),
'aspargessuppe': ('aspargessuppe',),
'aspargessuppen': ('aspargessuppe',),
'aspargessuppene': ('aspargessuppe',),
'aspargessupper': ('aspargessuppe',),
'aspekt': ('aspekt',),
'aspekta': ('aspekt',),
'aspekten': ('aspekt',),
'aspektene': ('aspekt',),
'aspekter': ('aspekt',),
'aspektet': ('aspekt',),
'aspelauv': ('aspelauv',),
'aspelauva': ('aspelauv',),
'aspelauvene': ('aspelauv',),
'aspelauvet': ('aspelauv',),
'aspeløv': ('aspeløv',),
'aspeløva': ('aspeløv',),
'aspeløvene': ('aspeløv',),
'aspeløvet': ('aspeløv',),
'aspidistra': ('aspidistra',),
'aspidistraen': ('aspidistra',),
'aspidistraene': ('aspidistra',),
'aspidistraer': ('aspidistra',),
'aspik': ('aspik',),
'aspiken': ('aspik',),
'aspikene': ('aspik',),
'aspiker': ('aspik',),
'aspirant': ('aspirant',),
'aspiranten': ('aspirant',),
'aspirantene': ('aspirant',),
'aspiranter': ('aspirant',),
'aspirasjon': ('aspirasjon',),
'aspirasjonen': ('aspirasjon',),
'aspirasjonene': ('aspirasjon',),
'aspirasjoner': ('aspirasjon',),
'aspirasjonsnivå': ('aspirasjonsnivå',),
'aspirasjonsnivåa': ('aspirasjonsnivå',),
'aspirasjonsnivåene': ('aspirasjonsnivå',),
'aspirasjonsnivåer': ('aspirasjonsnivå',),
'aspirasjonsnivået': ('aspirasjonsnivå',),
'ass': ('ass',),
'assen': ('ass',),
'assene': ('ass',),
'asser': ('ass',),
'ass-moll': ('ass-moll',),
'ass-mollen': ('ass-moll',),
'ass-mollene': ('ass-moll',),
'ass-moller': ('ass-moll',),
'assessor': ('assessor',),
'assessoren': ('assessor',),
'assessorene': ('assessor',),
'assessorer': ('assessor',),
'assimilasjon': ('assimilasjon',),
'assimilasjonen': ('assimilasjon',),
'assimilasjonene': ('assimilasjon',),
'assimilasjoner': ('assimilasjon',),
'assimilasjonsevna': ('assimilasjonsevne',),
'assimilasjonsevne': ('assimilasjonsevne',),
'assimilasjonsevnen': ('assimilasjonsevne',),
'assimilasjonsevnene': ('assimilasjonsevne',),
'assimilasjonsevner': ('assimilasjonsevne',),
'assimilasjonsorgan': ('assimilasjonsorgan',),
'assimilasjonsorgana': ('assimilasjonsorgan',),
'assimilasjonsorganene': ('assimilasjonsorgan',),
'assimilasjonsorganer': ('assimilasjonsorgan',),
'assimilasjonsorganet': ('assimilasjonsorgan',),
'assimilering': ('assimilering',),
'assimileringa': ('assimilering',),
'assimileringen': ('assimilering',),
'assimileringene': ('assimilering',),
'assimileringer': ('assimilering',),
'assistanse': ('assistanse',),
'assistansen': ('assistanse',),
'assistansene': ('assistanse',),
'assistanser': ('assistanse',),
'assistent': ('assistent',),
'assistenten': ('assistent',),
'assistentene': ('assistent',),
'assistenter': ('assistent',),
'assistentlege': ('assistentlege',),
'assistentlegen': ('assistentlege',),
'assistentlegene': ('assistentlege',),
'assistentleger': ('assistentlege',),
'assistentstilling': ('assistentstilling',),
'assistentstillinga': ('assistentstilling',),
'assistentstillingen': ('assistentstilling',),
'assistentstillingene': ('assistentstilling',),
'assistentstillinger': ('assistentstilling',),
'assonans': ('assonans',),
'assonansen': ('assonans',),
'assonansene': ('assonans',),
'assonanser': ('assonans',),
'assortiment': ('assortiment',),
'assortimenta': ('assortiment',),
'assortimentene': ('assortiment',),
'assortimenter': ('assortiment',),
'assortimentet': ('assortiment',),
'assosiasjon': ('assosiasjon',),
'assosiasjonen': ('assosiasjon',),
'assosiasjonene': ('assosiasjon',),
'assosiasjoner': ('assosiasjon',),
'assosiasjonspsykologi': ('assosiasjonspsykologi',),
'assosiasjonspsykologien': ('assosiasjonspsykologi',),
'assosiasjonspsykologiene': ('assosiasjonspsykologi',),
'assosiasjonspsykologier': ('assosiasjonspsykologi',),
'assurandør': ('assurandør',),
'assurandøren': ('assurandør',),
'assurandørene': ('assurandør',),
'assurandører': ('assurandør',),
'assuranse': ('assuranse',),
'assuransen': ('assuranse',),
'assuransene': ('assuranse',),
'assuranser': ('assuranse',),
'assuransepremie': ('assuransepremie',),
'assuransepremien': ('assuransepremie',),
'assuransepremiene': ('assuransepremie',),
'assuransepremier': ('assuransepremie',),
'assuranseselskap': ('assuranseselskap',),
'assuranseselskapa': ('assuranseselskap',),
'assuranseselskapene': ('assuranseselskap',),
'assuranseselskaper': ('assuranseselskap',),
'assuranseselskapet': ('assuranseselskap',),
'assuransesvik': ('assuransesvik',),
'assuransesvika': ('assuransesvik',),
'assuransesvikene': ('assuransesvik',),
'assuransesviket': ('assuransesvik',),
'assyrer': ('assyrer',),
'assyrere': ('assyrer',),
'assyreren': ('assyrer',),
'assyrerer': ('assyrer',),
'assyrerne': ('assyrer',),
'assyriolog': ('assyriolog',),
'assyriologen': ('assyriolog',),
'assyriologene': ('assyriolog',),
'assyriologer': ('assyriolog',),
'assyriologi': ('assyriologi',),
'assyriologien': ('assyriologi',),
'assyriologiene': ('assyriologi',),
'assyriologier': ('assyriologi',),
'astat': ('astat',),
'astata': ('astat',),
'astatene': ('astat',),
'astatet': ('astat',),
'asteni': ('asteni',),
'astenien': ('asteni',),
'asteniene': ('asteni',),
'astenier': ('asteni',),
'asteniker': ('asteniker',),
'astenikere': ('asteniker',),
'astenikeren': ('asteniker',),
'astenikerer': ('asteniker',),
'astenikerne': ('asteniker',),
'asterisk': ('asterisk',),
'asterisken': ('asterisk',),
'asteriskene': ('asterisk',),
'asterisker': ('asterisk',),
'asteroide': ('asteroide',),
'asteroiden': ('asteroide',),
'asteroidene': ('asteroide',),
'asteroider': ('asteroide',),
'asters': ('asters',),
'astersen': ('asters',),
'astersene': ('asters',),
'asterser': ('asters',),
'astersbed': ('astersbed',),
'astersbeda': ('astersbed',),
'astersbedene': ('astersbed',),
'astersbedet': ('astersbed',),
'astersbukett': ('astersbukett',),
'astersbuketten': ('astersbukett',),
'astersbukettene': ('astersbukett',),
'astersbuketter': ('astersbukett',),
'astigmatiker': ('astigmatiker',),
'astigmatikere': ('astigmatiker',),
'astigmatikeren': ('astigmatiker',),
'astigmatikerer': ('astigmatiker',),
'astigmatikerne': ('astigmatiker',),
'astigmatisme': ('astigmatisme',),
'astigmatismen': ('astigmatisme',),
'astigmatismene': ('astigmatisme',),
'astigmatismer': ('astigmatisme',),
'astma': ('astma',),
'astmaen': ('astma',),
'astmaene': ('astma',),
'astmaer': ('astma',),
'astmabarn': ('astmabarn',),
'astmabarna': ('astmabarn',),
'astmabarnene': ('astmabarn',),
'astmabarnet': ('astmabarn',),
'astmatiker': ('astmatiker',),
'astmatikere': ('astmatiker',),
'astmatikeren': ('astmatiker',),
'astmatikerer': ('astmatiker',),
'astmatikerne': ('astmatiker',),
'astrakan': ('astrakan',),
'astrakana': ('astrakan',),
'astrakanen': ('astrakan',),
'astrakanene': ('astrakan',),
'astrakaner': ('astrakan',),
'astrakanet': ('astrakan',),
'astrakanepla': ('astrakaneple',),
'astrakaneple': ('astrakaneple',),
'astrakaneplene': ('astrakaneple',),
'astrakanepler': ('astrakaneple',),
'astrakaneplet': ('astrakaneple',),
'astrakanhua': ('astrakanhue',),
'astrakanhue': ('astrakanhue',),
'astrakanhuen': ('astrakanhue',),
'astrakanhuene': ('astrakanhue',),
'astrakanhuer': ('astrakanhue',),
'astrakanhuva': ('astrakanhuve',),
'astrakanhuve': ('astrakanhuve',),
'astrakanhuven': ('astrakanhuve',),
'astrakanhuvene': ('astrakanhuve',),
'astrakanhuver': ('astrakanhuve',),
'astrakanlua': ('astrakanlue',),
'astrakanlue': ('astrakanlue',),
'astrakanluen': ('astrakanlue',),
'astrakanluene': ('astrakanlue',),
'astrakanluer': ('astrakanlue',),
'astrakanluva': ('astrakanluve',),
'astrakanluve': ('astrakanluve',),
'astrakanluven': ('astrakanluve',),
'astrakanluvene': ('astrakanluve',),
'astrakanluver': ('astrakanluve',),
'astrakanskinn': ('astrakanskinn',),
'astrakanskinna': ('astrakanskinn',),
'astrakanskinnene': ('astrakanskinn',),
'astrakanskinnet': ('astrakanskinn',),
'astrallegema': ('astrallegeme',),
'astrallegeme': ('astrallegeme',),
'astrallegemene': ('astrallegeme',),
'astrallegemer': ('astrallegeme',),
'astrallegemet': ('astrallegeme',),
'astrofotometri': ('astrofotometri',),
'astrofotometrien': ('astrofotometri',),
'astrofotometriene': ('astrofotometri',),
'astrofotometrier': ('astrofotometri',),
'astrofysikk': ('astrofysikk',),
'astrofysikken': ('astrofysikk',),
'astrofysikkene': ('astrofysikk',),
'astrofysikker': ('astrofysikk',),
'astrolog': ('astrolog',),
'astrologen': ('astrolog',),
'astrologene': ('astrolog',),
'astrologer': ('astrolog',),
'astrologi': ('astrologi',),
'astrologien': ('astrologi',),
'astrologiene': ('astrologi',),
'astrologier': ('astrologi',),
'astrometri': ('astrometri',),
'astrometrien': ('astrometri',),
'astrometriene': ('astrometri',),
'astrometrier': ('astrometri',),
'astronaut': ('astronaut',),
'astronauten': ('astronaut',),
'astronautene': ('astronaut',),
'astronauter': ('astronaut',),
'astronautikk': ('astronautikk',),
'astronautikken': ('astronautikk',),
'astronautikkene': ('astronautikk',),
'astronautikker': ('astronautikk',),
'astronom': ('astronom',),
'astronomen': ('astronom',),
'astronomene': ('astronom',),
'astronomer': ('astronom',),
'astronomi': ('astronomi',),
'astronomien': ('astronomi',),
'astronomiene': ('astronomi',),
'astronomier': ('astronomi',),
'asur': ('asur',),
'asuren': ('asur',),
'asurene': ('asur',),
'asurer': ('asur',),
'asurblått': ('asurblått',),
'asyl': ('asyl',),
'asyla': ('asyl',),
'asylene': ('asyl',),
'asyler': ('asyl',),
'asylet': ('asyl',),
'asylrett': ('asylrett',),
'asylretten': ('asylrett',),
'asylrettene': ('asylrett',),
'asylretter': ('asylrett',),
'asymmetri': ('asymmetri',),
'asymmetrien': ('asymmetri',),
'asymmetriene': ('asymmetri',),
'asymmetrier': ('asymmetri',),
'asymptote': ('asymptote',),
'asymptoten': ('asymptote',),
'asymptotene': ('asymptote',),
'asymptoter': ('asymptote',),
'asyndese': ('asyndese',),
'asyndesen': ('asyndese',),
'asyndesene': ('asyndese',),
'asyndeser': ('asyndese',),
'asynkronmotor': ('asynkronmotor',),
'asynkronmotoren': ('asynkronmotor',),
'asynkronmotorene': ('asynkronmotor',),
'asynkronmotorer': ('asynkronmotor',),
'at-setning': ('at-setning',),
'at-setninga': ('at-setning',),
'at-setningen': ('at-setning',),
'at-setningene': ('at-setning',),
'at-setninger': ('at-setning',),
'ataraksika': ('ataraksikum',),
'ataraksikaene': ('ataraksikum',),
'ataraksikum': ('ataraksikum',),
'ataraksikumet': ('ataraksikum',),
'atavisme': ('atavisme',),
'atavismen': ('atavisme',),
'atavismene': ('atavisme',),
'atavismer': ('atavisme',),
'ateisme': ('ateisme',),
'ateismen': ('ateisme',),
'ateismene': ('ateisme',),
'ateismer': ('ateisme',),
'ateist': ('ateist',),
'ateisten': ('ateist',),
'ateistene': ('ateist',),
'ateister': ('ateist',),
'atelier': ('atelier',),
'ateliera': ('atelier',),
'atelierene': ('atelier',),
'atelierer': ('atelier',),
'atelieret': ('atelier',),
'atener': ('atener',),
'atenere': ('atener',),
'ateneren': ('atener',),
'atenerer': ('atener',),
'atenerne': ('atener',),
'ateneum': ('ateneum',),
'ateneuma': ('ateneum',),
'ateneumene': ('ateneum',),
'ateneumer': ('ateneum',),
'ateneumet': ('ateneum',),
'aterosklerose': ('aterosklerose',),
'aterosklerosen': ('aterosklerose',),
'aterosklerosene': ('aterosklerose',),
'ateroskleroser': ('aterosklerose',),
'atferd': ('atferd',),
'atferda': ('atferd',),
'atferden': ('atferd',),
'atferdene': ('atferd',),
'atferder': ('atferd',),
'atferdsforsking': ('atferdsforsking',),
'atferdsforskinga': ('atferdsforsking',),
'atferdsforskingen': ('atferdsforsking',),
'atferdsforskingene': ('atferdsforsking',),
'atferdsforskinger': ('atferdsforsking',),
'atferdsforskning': ('atferdsforskning',),
'atferdsforskninga': ('atferdsforskning',),
'atferdsforskningen': ('atferdsforskning',),
'atferdsforskningene': ('atferdsforskning',),
'atferdsforskninger': ('atferdsforskning',),
'atferdsforstyrrelse': ('atferdsforstyrrelse',),
'atferdsforstyrrelsen': ('atferdsforstyrrelse',),
'atferdsforstyrrelsene': ('atferdsforstyrrelse',),
'atferdsforstyrrelser': ('atferdsforstyrrelse',),
'atferdsmønster': ('atferdsmønster',),
'atferdsmønsteret': ('atferdsmønster',),
'atferdsmønstra': ('atferdsmønster',),
'atferdsmønstre': ('atferdsmønster',),
'atferdsmønstrene': ('atferdsmønster',),
'atferdsmønstret': ('atferdsmønster',),
'atferdsnorm': ('atferdsnorm',),
'atferdsnormen': ('atferdsnorm',),
'atferdsnormene': ('atferdsnorm',),
'atferdsnormer': ('atferdsnorm',),
'atferdspsykologi': ('atferdspsykologi',),
'atferdspsykologien': ('atferdspsykologi',),
'atferdspsykologiene': ('atferdspsykologi',),
'atferdspsykologier': ('atferdspsykologi',),
'atferdsterapi': ('atferdsterapi',),
'atferdsterapien': ('atferdsterapi',),
'atferdsterapiene': ('atferdsterapi',),
'atferdsterapier': ('atferdsterapi',),
'atferdsvanske': ('atferdsvanske',),
'atferdsvansken': ('atferdsvanske',),
'atferdsvanskene': ('atferdsvanske',),
'atferdsvansker': ('atferdsvanske',),
'atgeir': ('atgeir',),
'atgeiren': ('atgeir',),
'atgeirene': ('atgeir',),
'atgeirer': ('atgeir',),
'athener': ('athener',),
'athenere': ('athener',),
'atheneren': ('athener',),
'athenerer': ('athener',),
'athenerne': ('athener',),
'atkomst': ('atkomst',),
'atkomsten': ('atkomst',),
'atkomstene': ('atkomst',),
'atkomster': ('atkomst',),
'atkomstdokument': ('atkomstdokument',),
'atkomstdokumenta': ('atkomstdokument',),
'atkomstdokumentene': ('atkomstdokument',),
'atkomstdokumenter': ('atkomstdokument',),
'atkomstdokumentet': ('atkomstdokument',),
'atkomstmangel': ('atkomstmangel',),
'atkomstmangelen': ('atkomstmangel',),
'atkomstmanglene': ('atkomstmangel',),
'atkomstmangler': ('atkomstmangel',),
'atkomstveg': ('atkomstveg',),
'atkomstvegen': ('atkomstveg',),
'atkomstvegene': ('atkomstveg',),
'atkomstveger': ('atkomstveg',),
'atkomstvei': ('atkomstvei',),
'atkomstveien': ('atkomstvei',),
'atkomstveiene': ('atkomstvei',),
'atkomstveier': ('atkomstvei',),
'atlant': ('atlant',),
'atlanten': ('atlant',),
'atlantene': ('atlant',),
'atlanter': ('atlant',),
'atlas': ('atlas',),
'atlasa': ('atlas',),
'atlasene': ('atlas',),
'atlaser': ('atlas',),
'atlaset': ('atlas',),
'atlasbrokade': ('atlasbrokade',),
'atlasbrokaden': ('atlasbrokade',),
'atlasbrokadene': ('atlasbrokade',),
'atlasbrokader': ('atlasbrokade',),
'atlasbrokade': ('atlasbrokade',),
'atlasbrokaden': ('atlasbrokade',),
'atlasbrokadene': ('atlasbrokade',),
'atlasbrokader': ('atlasbrokade',),
'atlask': ('atlask',),
'atlasken': ('atlask',),
'atlaskene': ('atlask',),
'atlasker': ('atlask',),
'atlask': ('atlask',),
'atlasken': ('atlask',),
'atlaskene': ('atlask',),
'atlasker': ('atlask',),
'atlaskbrokade': ('atlaskbrokade',),
'atlaskbrokaden': ('atlaskbrokade',),
'atlaskbrokadene': ('atlaskbrokade',),
'atlaskbrokader': ('atlaskbrokade',),
'atlaskbrokade': ('atlaskbrokade',),
'atlaskbrokaden': ('atlaskbrokade',),
'atlaskbrokadene': ('atlaskbrokade',),
'atlaskbrokader': ('atlaskbrokade',),
'atlaskjole': ('atlaskjole',),
'atlaskjolen': ('atlaskjole',),
'atlaskjolene': ('atlaskjole',),
'atlaskjoler': ('atlaskjole',),
'atlaskkjole': ('atlaskkjole',),
'atlaskkjolen': ('atlaskkjole',),
'atlaskkjolene': ('atlaskkjole',),
'atlaskkjoler': ('atlaskkjole',),
'atlet': ('atlet',),
'atleten': ('atlet',),
'atletene': ('atlet',),
'atleter': ('atlet',),
'atmosfære': ('atmosfære',),
'atmosfæren': ('atmosfære',),
'atmosfærene': ('atmosfære',),
'atmosfærer': ('atmosfære',),
'atoll': ('atoll',),
'atollen': ('atoll',),
'atollene': ('atoll',),
'atoller': ('atoll',),
'atom': ('atom',),
'atoma': ('atom',),
'atomene': ('atom',),
'atomer': ('atom',),
'atomet': ('atom',),
'atomalder': ('atomalder',),
'atomaldere': ('atomalder',),
'atomalderen': ('atomalder',),
'atomalderer': ('atomalder',),
'atomalderne': ('atomalder',),
'atomaldre': ('atomalder',),
'atomaldrene': ('atomalder',),
'atomaldrer': ('atomalder',),
'atombomba': ('atombombe',),
'atombombe': ('atombombe',),
'atombomben': ('atombombe',),
'atombombene': ('atombombe',),
'atombomber': ('atombombe',),
'atomenergi': ('atomenergi',),
'atomenergien': ('atomenergi',),
'atomenergiene': ('atomenergi',),
'atomenergier': ('atomenergi',),
'atomforsker': ('atomforsker',),
'atomforskere': ('atomforsker',),
'atomforskeren': ('atomforsker',),
'atomforskerer': ('atomforsker',),
'atomforskerne': ('atomforsker',),
'atomforsking': ('atomforsking',),
'atomforskinga': ('atomforsking',),
'atomforskingen': ('atomforsking',),
'atomforskingene': ('atomforsking',),
'atomforskinger': ('atomforsking',),
'atomforskning': ('atomforskning',),
'atomforskninga': ('atomforskning',),
'atomforskningen': ('atomforskning',),
'atomforskningene': ('atomforskning',),
'atomforskninger': ('atomforskning',),
'atomfysikk': ('atomfysikk',),
'atomfysikken': ('atomfysikk',),
'atomfysikkene': ('atomfysikk',),
'atomfysikker': ('atomfysikk',),
'atomisme': ('atomisme',),
'atomismen': ('atomisme',),
'atomismene': ('atomisme',),
'atomismer': ('atomisme',),
'atomkjerne': ('atomkjerne',),
'atomkjernen': ('atomkjerne',),
'atomkjernene': ('atomkjerne',),
'atomkjerner': ('atomkjerne',),
'atomkraft': ('atomkraft',),
'atomkrafta': ('atomkraft',),
'atomkraften': ('atomkraft',),
'atomkreftene': ('atomkraft',),
'atomkrefter': ('atomkraft',),
'atomkraftverk': ('atomkraftverk',),
'atomkraftverka': ('atomkraftverk',),
'atomkraftverkene': ('atomkraftverk',),
'atomkraftverker': ('atomkraftverk',),
'atomkraftverket': ('atomkraftverk',),
'atomkrig': ('atomkrig',),
'atomkrigen': ('atomkrig',),
'atomkrigene': ('atomkrig',),
'atomkriger': ('atomkrig',),
'atomladning': ('atomladning',),
'atomladninga': ('atomladning',),
'atomladningen': ('atomladning',),
'atomladningene': ('atomladning',),
'atomladninger': ('atomladning',),
'atommasse': ('atommasse',),
'atommassen': ('atommasse',),
'atommassene': ('atommasse',),
'atommasser': ('atommasse',),
'atommila': ('atommile',),
'atommile': ('atommile',),
'atommilen': ('atommile',),
'atommilene': ('atommile',),
'atommiler': ('atommile',),
'atomnummer': ('atomnummer',),
'atomnummeret': ('atomnummer',),
'atomnumra': ('atomnummer',),
'atomnumre': ('atomnummer',),
'atomnumrene': ('atomnummer',),
'atomreaktor': ('atomreaktor',),
'atomreaktoren': ('atomreaktor',),
'atomreaktorene': ('atomreaktor',),
'atomreaktorer': ('atomreaktor',),
'atomspalting': ('atomspalting',),
'atomspaltinga': ('atomspalting',),
'atomspaltingen': ('atomspalting',),
'atomspaltingene': ('atomspalting',),
'atomspaltinger': ('atomspalting',),
'atomspaltning': ('atomspaltning',),
'atomspaltninga': ('atomspaltning',),
'atomspaltningen': ('atomspaltning',),
'atomspaltningene': ('atomspaltning',),
'atomspaltninger': ('atomspaltning',),
'atomteori': ('atomteori',),
'atomteorien': ('atomteori',),
'atomteoriene': ('atomteori',),
'atomteorier': ('atomteori',),
'atomur': ('atomur',),
'atomura': ('atomur',),
'atomurene': ('atomur',),
'atomuret': ('atomur',),
'atomvekt': ('atomvekt',),
'atomvekta': ('atomvekt',),
'atomvekten': ('atomvekt',),
'atomvektene': ('atomvekt',),
'atomvekter': ('atomvekt',),
'atomvåpen': ('atomvåpen',),
'atomvåpenet': ('atomvåpen',),
'atomvåpna': ('atomvåpen',),
'atomvåpnene': ('atomvåpen',),
'atonalitet': ('atonalitet',),
'atonaliteten': ('atonalitet',),
'atonalitetene': ('atonalitet',),
'atonaliteter': ('atonalitet',),
'atriehage': ('atriehage',),
'atriehagen': ('atriehage',),
'atriehagene': ('atriehage',),
'atriehager': ('atriehage',),
'atriehage': ('atriehage',),
'atriehagen': ('atriehage',),
'atriehagene': ('atriehage',),
'atriehager': ('atriehage',),
'atriehus': ('atriehus',),
'atriehusa': ('atriehus',),
'atriehusene': ('atriehus',),
'atriehuset': ('atriehus',),
'atriehus': ('atriehus',),
'atriehusa': ('atriehus',),
'atriehusene': ('atriehus',),
'atriehuset': ('atriehus',),
'atria': ('atrium',),
'atriene': ('atrium',),
'atrier': ('atrium',),
'atriet': ('atrium',),
'atrium': ('atrium',),
'atriumhage': ('atriumhage',),
'atriumhagen': ('atriumhage',),
'atriumhagene': ('atriumhage',),
'atriumhager': ('atriumhage',),
'atriumhage': ('atriumhage',),
'atriumhagen': ('atriumhage',),
'atriumhagene': ('atriumhage',),
'atriumhager': ('atriumhage',),
'atriumhus': ('atriumhus',),
'atriumhusa': ('atriumhus',),
'atriumhusene': ('atriumhus',),
'atriumhuset': ('atriumhus',),
'atriumhus': ('atriumhus',),
'atriumhusa': ('atriumhus',),
'atriumhusene': ('atriumhus',),
'atriumhuset': ('atriumhus',),
'atrofi': ('atrofi',),
'atrofien': ('atrofi',),
'atrofiene': ('atrofi',),
'atrofier': ('atrofi',),
'atropin': ('atropin',),
'atropina': ('atropin',),
'atropinene': ('atropin',),
'atropinet': ('atropin',),
'atropininjeksjon': ('atropininjeksjon',),
'atropininjeksjonen': ('atropininjeksjon',),
'atropininjeksjonene': ('atropininjeksjon',),
'atropininjeksjoner': ('atropininjeksjon',),
'atropintablett': ('atropintablett',),
'atropintabletten': ('atropintablett',),
'atropintablettene': ('atropintablett',),
'atropintabletter': ('atropintablett',),
'atskillelse': ('atskillelse',),
'atskillelsen': ('atskillelse',),
'atskillelsene': ('atskillelse',),
'atskillelser': ('atskillelse',),
'atspredelse': ('atspredelse',),
'atspredelsen': ('atspredelse',),
'atspredelsene': ('atspredelse',),
'atspredelser': ('atspredelse',),
'attacheen': ('attaché',),
'attacheene': ('attaché',),
'attacheer': ('attaché',),
'attaché': ('attaché',),
'attachéen': ('attaché',),
'attachéene': ('attaché',),
'attachéer': ('attaché',),
'attakk': ('attakk',),
'attakka': ('attakk',),
'attakkene': ('attakk',),
'attakker': ('attakk',),
'attakket': ('attakk',),
'attendel': ('attendel',),
'attendelen': ('attendel',),
'attendelene': ('attendel',),
'attendeler': ('attendel',),
'attenhundretal': ('attenhundretal',),
'attenhundretala': ('attenhundretal',),
'attenhundretalene': ('attenhundretal',),
'attenhundretalet': ('attenhundretal',),
'attenhundretall': ('attenhundretall',),
'attenhundretalla': ('attenhundretall',),
'attenhundretallene': ('attenhundretall',),
'attenhundretallet': ('attenhundretall',),
'attentat': ('attentat',),
'attentata': ('attentat',),
'attentatene': ('attentat',),
'attentater': ('attentat',),
'attentatet': ('attentat',),
'attentatforsøk': ('attentatforsøk',),
'attentatforsøka': ('attentatforsøk',),
'attentatforsøkene': ('attentatforsøk',),
'attentatforsøket': ('attentatforsøk',),
'attentatmann': ('attentatmann',),
'attentatmannen': ('attentatmann',),
'attentatmenn': ('attentatmann',),
'attentatmennene': ('attentatmann',),
'attenåring': ('attenåring',),
'attenåringen': ('attenåring',),
'attenåringene': ('attenåring',),
'attenåringer': ('attenåring',),
'attenårsalder': ('attenårsalder',),
'attenårsaldere': ('attenårsalder',),
'attenårsalderen': ('attenårsalder',),
'attenårsalderer': ('attenårsalder',),
'attenårsalderne': ('attenårsalder',),
'attenårsaldre': ('attenårsalder',),
'attenårsaldrene': ('attenårsalder',),
'attenårsaldrer': ('attenårsalder',),
'attenårsgrensa': ('attenårsgrense',),
'attenårsgrense': ('attenårsgrense',),
'attenårsgrensen': ('attenårsgrense',),
'attenårsgrensene': ('attenårsgrense',),
'attenårsgrenser': ('attenårsgrense',),
'atterbud': ('atterbud',),
'atterbuda': ('atterbud',),
'atterbudene': ('atterbud',),
'atterbudet': ('atterbud',),
'attergløyma': ('attergløyme',),
'attergløyme': ('attergløyme',),
'attergløymen': ('attergløyme',),
'attergløymene': ('attergløyme',),
'attergløymer': ('attergløyme',),
'attersting': ('attersting',),
'atterstinga': ('attersting',),
'atterstingene': ('attersting',),
'atterstinget': ('attersting',),
'attest': ('attest',),
'attesten': ('attest',),
'attestene': ('attest',),
'attester': ('attest',),
'attestant': ('attestant',),
'attestanten': ('attestant',),
'attestantene': ('attestant',),
'attestanter': ('attestant',),
'attestasjon': ('attestasjon',),
'attestasjonen': ('attestasjon',),
'attestasjonene': ('attestasjon',),
'attestasjoner': ('attestasjon',),
'attestering': ('attestering',),
'attesteringa': ('attestering',),
'attesteringen': ('attestering',),
'attesteringene': ('attestering',),
'attesteringer': ('attestering',),
'attestkopi': ('attestkopi',),
'attestkopien': ('attestkopi',),
'attestkopiene': ('attestkopi',),
'attestkopier': ('attestkopi',),
'attføring': ('attføring',),
'attføringa': ('attføring',),
'attføringen': ('attføring',),
'attføringene': ('attføring',),
'attføringer': ('attføring',),
'attføringsinstitutt': ('attføringsinstitutt',),
'attføringsinstitutta': ('attføringsinstitutt',),
'attføringsinstituttene': ('attføringsinstitutt',),
'attføringsinstitutter': ('attføringsinstitutt',),
'attføringsinstituttet': ('attføringsinstitutt',),
'attføringstrygd': ('attføringstrygd',),
'attføringstrygda': ('attføringstrygd',),
'attføringstrygden': ('attføringstrygd',),
'attføringstrygdene': ('attføringstrygd',),
'attføringstrygder': ('attføringstrygd',),
'attityde': ('attityde',),
'attityden': ('attityde',),
'attitydene': ('attityde',),
'attityder': ('attityde',),
'attpåklatt': ('attpåklatt',),
'attpåklatten': ('attpåklatt',),
'attpåklattene': ('attpåklatt',),
'attpåklatter': ('attpåklatt',),
'attpåsleng': ('attpåsleng',),
'attpåslenga': ('attpåsleng',),
'attpåslengene': ('attpåsleng',),
'attpåslenget': ('attpåsleng',),
'attraksjon': ('attraksjon',),
'attraksjonen': ('attraksjon',),
'attraksjonene': ('attraksjon',),
'attraksjoner': ('attraksjon',),
'attrapp': ('attrapp',),
'attrappen': ('attrapp',),
'attrappene': ('attrapp',),
'attrapper': ('attrapp',),
'attributt': ('attributt',),
'attributta': ('attributt',),
'attributtene': ('attributt',),
'attributter': ('attributt',),
'attributtet': ('attributt',),
'attrå': ('attrå',),
'attråen': ('attrå',),
'attråene': ('attrå',),
'attråer': ('attrå',),
'attåtarbeid': ('attåtarbeid',),
'attåtarbeida': ('attåtarbeid',),
'attåtarbeidene': ('attåtarbeid',),
'attåtarbeider': ('attåtarbeid',),
'attåtarbeidet': ('attåtarbeid',),
'attåtnæring': ('attåtnæring',),
'attåtnæringa': ('attåtnæring',),
'attåtnæringen': ('attåtnæring',),
'attåtnæringene': ('attåtnæring',),
'attåtnæringer': ('attåtnæring',),
'atypi': ('atypi',),
'atypien': ('atypi',),
'atypiene': ('atypi',),
'atypier': ('atypi',),
'au': ('au',),
'aua': ('au',),
'auene': ('au',),
'auet': ('au',),
'au pair': ('au pair',),
'au pair-arbeid': ('au pair-arbeid',),
'au pair-arbeida': ('au pair-arbeid',),
'au pair-arbeidene': ('au pair-arbeid',),
'au pair-arbeider': ('au pair-arbeid',),
'au pair-arbeidet': ('au pair-arbeid',),
'au pair-jenta': ('au pair-jente',),
'au pair-jente': ('au pair-jente',),
'au pair-jenten': ('au pair-jente',),
'au pair-jentene': ('au pair-jente',),
'au pair-jenter': ('au pair-jente',),
'aubergine': ('aubergine',),
'auberginen': ('aubergine',),
'auberginene': ('aubergine',),
'auberginer': ('aubergine',),
'audiens': ('audiens',),
'audiensen': ('audiens',),
'audiensene': ('audiens',),
'audienser': ('audiens',),
'audiensrom': ('audiensrom',),
'audiensromma': ('audiensrom',),
'audiensrommene': ('audiensrom',),
'audiensrommet': ('audiensrom',),
'audienssal': ('audienssal',),
'audienssalen': ('audienssal',),
'audienssalene': ('audienssal',),
'audienssaler': ('audienssal',),
'audiolog': ('audiolog',),
'audiologen': ('audiolog',),
'audiologene': ('audiolog',),
'audiologer': ('audiolog',),
'audiologi': ('audiologi',),
'audiologien': ('audiologi',),
'audiologiene': ('audiologi',),
'audiologier': ('audiologi',),
'audiometer': ('audiometer',),
'audiometeret': ('audiometer',),
'audiometra': ('audiometer',),
'audiometre': ('audiometer',),
'audiometrene': ('audiometer',),
'audiometret': ('audiometer',),
'auditoria': ('auditorium',),
'auditoriene': ('auditorium',),
'auditorier': ('auditorium',),
'auditoriet': ('auditorium',),
'auditorium': ('auditorium',),
'augiasstall': ('augiasstall',),
'augiasstallen': ('augiasstall',),
'augiasstallene': ('augiasstall',),
'augiasstaller': ('augiasstall',),
'augur': ('augur',),
'auguren': ('augur',),
'augurene': ('augur',),
'augurer': ('augur',),
'augursmil': ('augursmil',),
'augursmila': ('augursmil',),
'augursmilen': ('augursmil',),
'augursmilene': ('augursmil',),
'augursmilet': ('augursmil',),
'august': ('august',),
'augustiner': ('augustiner',),
'augustinere': ('augustiner',),
'augustineren': ('augustiner',),
'augustinerer': ('augustiner',),
'augustinerne': ('augustiner',),
'augustinerkloster': ('augustinerkloster',),
'augustinerklosteret': ('augustinerkloster',),
'augustinerklostra': ('augustinerkloster',),
'augustinerklostre': ('augustinerkloster',),
'augustinerklostrene': ('augustinerkloster',),
'augustinerklostret': ('augustinerkloster',),
'augustinermunk': ('augustinermunk',),
'augustinermunken': ('augustinermunk',),
'augustinermunkene': ('augustinermunk',),
'augustinermunker': ('augustinermunk',),
'augustinernonna': ('augustinernonne',),
'augustinernonne': ('augustinernonne',),
'augustinernonnen': ('augustinernonne',),
'augustinernonnene': ('augustinernonne',),
'augustinernonner': ('augustinernonne',),
'auke': ('auke',),
'auken': ('auke',),
'aukene': ('auke',),
'auker': ('auke',),
'auking': ('auking',),
'aukinga': ('auking',),
'aukingen': ('auking',),
'aukingene': ('auking',),
'aukinger': ('auking',),
'aukingsmonn': ('aukingsmonn',),
'aukingsmonna': ('aukingsmonn',),
'aukingsmonnen': ('aukingsmonn',),
'aukingsmonnene': ('aukingsmonn',),
'aukingsmonner': ('aukingsmonn',),
'aukingsmonnet': ('aukingsmonn',),
'auksjon': ('auksjon',),
'auksjonen': ('auksjon',),
'auksjonene': ('auksjon',),
'auksjoner': ('auksjon',),
'auksjonariene': ('auksjonarius',),
'auksjonarier': ('auksjonarius',),
'auksjonarius': ('auksjonarius',),
'auksjonariusen': ('auksjonarius',),
'auksjonsbord': ('auksjonsbord',),
'auksjonsborda': ('auksjonsbord',),
'auksjonsbordene': ('auksjonsbord',),
'auksjonsborder': ('auksjonsbord',),
'auksjonsbordet': ('auksjonsbord',),
'auksjonsforretning': ('auksjonsforretning',),
'auksjonsforretninga': ('auksjonsforretning',),
'auksjonsforretningen': ('auksjonsforretning',),
'auksjonsforretningene': ('auksjonsforretning',),
'auksjonsforretninger': ('auksjonsforretning',),
'auksjonsgrunnlag': ('auksjonsgrunnlag',),
'auksjonsgrunnlaga': ('auksjonsgrunnlag',),
'auksjonsgrunnlagene': ('auksjonsgrunnlag',),
'auksjonsgrunnlaget': ('auksjonsgrunnlag',),
'auksjonshammar': ('auksjonshammar',),
'auksjonshammaren': ('auksjonshammar',),
'auksjonshamrene': ('auksjonshammar',),
'auksjonshamrer': ('auksjonshammar',),
'auksjonshammer': ('auksjonshammer',),
'auksjonshammere': ('auksjonshammer',),
'auksjonshammeren': ('auksjonshammer',),
'auksjonshammerer': ('auksjonshammer',),
'auksjonshammerne': ('auksjonshammer',),
'auksjonshamrene': ('auksjonshammer',),
'auksjonshamrer': ('auksjonshammer',),
'auksjonskatalog': ('auksjonskatalog',),
'auksjonskatalogen': ('auksjonskatalog',),
'auksjonskatalogene': ('auksjonskatalog',),
'auksjonskataloger': ('auksjonskatalog',),
'auksjonslokala': ('auksjonslokale',),
'auksjonslokale': ('auksjonslokale',),
'auksjonslokalene': ('auksjonslokale',),
'auksjonslokaler': ('auksjonslokale',),
'auksjonslokalet': ('auksjonslokale',),
'aula': ('aula',),
'aulaen': ('aula',),
'aulaene': ('aula',),
'aulaer': ('aula',),
'aur': ('aur',),
'auren': ('aur',),
'aurene': ('aur',),
'aurer': ('aur',),
'aura': ('aura',),
'auraen': ('aura',),
'auraene': ('aura',),
'auraer': ('aura',),
'aurbakke': ('aurbakke',),
'aurbakken': ('aurbakke',),
'aurbakkene': ('aurbakke',),
'aurbakker': ('aurbakke',),
'aurbotn': ('aurbotn',),
'aurbotnen': ('aurbotn',),
'aurbotnene': ('aurbotn',),
'aurbotner': ('aurbotn',),
'aurbunn': ('aurbunn',),
'aurbunnen': ('aurbunn',),
'aurbunnene': ('aurbunn',),
'aurbunner': ('aurbunn',),
'aure': ('aure',),
'auren': ('aure',),
'aurene': ('aure',),
'aurer': ('aure',),
'aurikkel': ('aurikkel',),
'aurikkelen': ('aurikkel',),
'auriklene': ('aurikkel',),
'aurikler': ('aurikkel',),
'aurjord': ('aurjord',),
'aurjorda': ('aurjord',),
'aurjorden': ('aurjord',),
'aurjordene': ('aurjord',),
'aurjorder': ('aurjord',),
'aurora': ('aurora',),
'auroraen': ('aurora',),
'auroraene': ('aurora',),
'auroraer': ('aurora',),
'aurum': ('aurum',),
'ausa': ('ause',),
'ause': ('ause',),
'ausen': ('ause',),
'ausene': ('ause',),
'auser': ('ause',),
'ausefat': ('ausefat',),
'ausefata': ('ausefat',),
'ausefatene': ('ausefat',),
'ausefater': ('ausefat',),
'ausefatet': ('ausefat',),
'ausekar': ('ausekar',),
'ausekara': ('ausekar',),
'ausekarene': ('ausekar',),
'ausekaret': ('ausekar',),
'auspisiene': ('auspisier',),
'auspisier': ('auspisier',),
'aust': ('aust',),
'austasiat': ('austasiat',),
'austasiaten': ('austasiat',),
'austasiatene': ('austasiat',),
'austasiater': ('austasiat',),
'austavind': ('austavind',),
'austavinden': ('austavind',),
'austavindene': ('austavind',),
'austavinder': ('austavind',),
'austavær': ('austavær',),
'austaværa': ('austavær',),
'austaværene': ('austavær',),
'austaværet': ('austavær',),
'austblokk': ('austblokk',),
'austblokka': ('austblokk',),
'austblokken': ('austblokk',),
'austblokkene': ('austblokk',),
'austblokker': ('austblokk',),
'austblokkland': ('austblokkland',),
'austblokklanda': ('austblokkland',),
'austblokklandene': ('austblokkland',),
'austblokklandet': ('austblokkland',),
'austerveg': ('austerveg',),
'austeuropeer': ('austeuropeer',),
'austeuropeere': ('austeuropeer',),
'austeuropeeren': ('austeuropeer',),
'austeuropeerer': ('austeuropeer',),
'austeuropeerne': ('austeuropeer',),
'austfront': ('austfront',),
'austfronten': ('austfront',),
'austfrontene': ('austfront',),
'austfronter': ('austfront',),
'austgoter': ('austgoter',),
'austgotere': ('austgoter',),
'austgoteren': ('austgoter',),
'austgoterer': ('austgoter',),
'austgoterne': ('austgoter',),
'austhandel': ('austhandel',),
'austhandelen': ('austhandel',),
'austhandlene': ('austhandel',),
'austhandler': ('austhandel',),
'austhimlene': ('austhimmel',),
'austhimler': ('austhimmel',),
'austhimmel': ('austhimmel',),
'austhimmelen': ('austhimmel',),
'austkant': ('austkant',),
'austkanten': ('austkant',),
'austkantene': ('austkant',),
'austkanter': ('austkant',),
'austkyst': ('austkyst',),
'austkysten': ('austkyst',),
'austkystene': ('austkyst',),
'austkyster': ('austkyst',),
'austlandsk': ('austlandsk',),
'austlandsken': ('austlandsk',),
'austlandskene': ('austlandsk',),
'austlandsker': ('austlandsk',),
'austlandsmål': ('austlandsmål',),
'austlandsmåla': ('austlandsmål',),
'austlandsmålene': ('austlandsmål',),
'austlandsmålet': ('austlandsmål',),
'austlending': ('austlending',),
'austlendingen': ('austlending',),
'austlendingene': ('austlending',),
'austlendinger': ('austlending',),
'austmark': ('austmark',),
'austmarka': ('austmark',),
'austmarken': ('austmark',),
'austmarkene': ('austmark',),
'austmarker': ('austmark',),
'austnorsk': ('austnorsk',),
'austnorsken': ('austnorsk',),
'austnorskene': ('austnorsk',),
'austnorsker': ('austnorsk',),
'australier': ('australier',),
'australiere': ('australier',),
'australieren': ('australier',),
'australierer': ('australier',),
'australierne': ('australier',),
'australneger': ('australneger',),
'australnegeren': ('australneger',),
'australnegerene': ('australneger',),
'australnegerer': ('australneger',),
'austromarxisme': ('austromarxisme',),
'austromarxismen': ('austromarxisme',),
'austromarxismene': ('austromarxisme',),
'austromarxismer': ('austromarxisme',),
'austromarxist': ('austromarxist',),
'austromarxisten': ('austromarxist',),
'austromarxistene': ('austromarxist',),
'austromarxister': ('austromarxist',),
'austsida': ('austside',),
'austside': ('austside',),
'austsiden': ('austside',),
'austsidene': ('austside',),
'austsider': ('austside',),
'austtysker': ('austtysker',),
'austtyskere': ('austtysker',),
'austtyskeren': ('austtysker',),
'austtyskerer': ('austtysker',),
'austtyskerne': ('austtysker',),
'autark': ('autark',),
'autarken': ('autark',),
'autarkene': ('autark',),
'autarker': ('autark',),
'autarki': ('autarki',),
'autarkia': ('autarki',),
'autarkiene': ('autarki',),
'autarkier': ('autarki',),
'autarkiet': ('autarki',),
'autentisitet': ('autentisitet',),
'autentisiteten': ('autentisitet',),
'autentisitetene': ('autentisitet',),
'autentisiteter': ('autentisitet',),
'autisme': ('autisme',),
'autismen': ('autisme',),
'autismene': ('autisme',),
'autismer': ('autisme',),
'autist': ('autist',),
'autisten': ('autist',),
'autistene': ('autist',),
'autister': ('autist',),
'autjunksjon': ('autjunksjon',),
'autjunksjonen': ('autjunksjon',),
'autjunksjonene': ('autjunksjon',),
'autjunksjoner': ('autjunksjon',),
'auto': ('auto',),
'autobiografi': ('autobiografi',),
'autobiografien': ('autobiografi',),
'autobiografiene': ('autobiografi',),
'autobiografier': ('autobiografi',),
'autodafeen': ('autodafé',),
'autodafeene': ('autodafé',),
'autodafeer': ('autodafé',),
'autodafé': ('autodafé',),
'autodaféen': ('autodafé',),
'autodaféene': ('autodafé',),
'autodaféer': ('autodafé',),
'autodidakt': ('autodidakt',),
'autodidakten': ('autodidakt',),
'autodidaktene': ('autodidakt',),
'autodidakter': ('autodidakt',),
'autodiesel': ('autodiesel',),
'autodieselen': ('autodiesel',),
'autodieslene': ('autodiesel',),
'autodiesler': ('autodiesel',),
'autogenapparat': ('autogenapparat',),
'autogenapparata': ('autogenapparat',),
'autogenapparatene': ('autogenapparat',),
'autogenapparater': ('autogenapparat',),
'autogenapparatet': ('autogenapparat',),
'autogensveising': ('autogensveising',),
'autogensveisinga': ('autogensveising',),
'autogensveisingen': ('autogensveising',),
'autogensveisingene': ('autogensveising',),
'autogensveisinger': ('autogensveising',),
'autograf': ('autograf',),
'autografen': ('autograf',),
'autografene': ('autograf',),
'autografer': ('autograf',),
'autografjeger': ('autografjeger',),
'autografjegere': ('autografjeger',),
'autografjegeren': ('autografjeger',),
'autografjegerer': ('autografjeger',),
'autografjegerne': ('autografjeger',),
'autografsamler': ('autografsamler',),
'autografsamlere': ('autografsamler',),
'autografsamleren': ('autografsamler',),
'autografsamlerer': ('autografsamler',),
'autografsamlerne': ('autografsamler',),
'autoklav': ('autoklav',),
'autoklaven': ('autoklav',),
'autoklavene': ('autoklav',),
'autoklaver': ('autoklav',),
'autokrat': ('autokrat',),
'autokraten': ('autokrat',),
'autokratene': ('autokrat',),
'autokrater': ('autokrat',),
'autokrati': ('autokrati',),
'autokratia': ('autokrati',),
'autokratiene': ('autokrati',),
'autokratier': ('autokrati',),
'autokratiet': ('autokrati',),
'autolyse': ('autolyse',),
'autolysen': ('autolyse',),
'autolysene': ('autolyse',),
'autolyser': ('autolyse',),
'automasjon': ('automasjon',),
'automasjonen': ('automasjon',),
'automasjonene': ('automasjon',),
'automasjoner': ('automasjon',),
'automat': ('automat',),
'automaten': ('automat',),
'automatene': ('automat',),
'automater': ('automat',),
'automatgir': ('automatgir',),
'automatgira': ('automatgir',),
'automatgirene': ('automatgir',),
'automatgiret': ('automatgir',),
'automatikk': ('automatikk',),
'automatikken': ('automatikk',),
'automatikkene': ('automatikk',),
'automatikker': ('automatikk',),
'automatisering': ('automatisering',),
'automatiseringa': ('automatisering',),
'automatiseringen': ('automatisering',),
'automatiseringene': ('automatisering',),
'automatiseringer': ('automatisering',),
'automatsentral': ('automatsentral',),
'automatsentralen': ('automatsentral',),
'automatsentralene': ('automatsentral',),
'automatsentraler': ('automatsentral',),
'automattelefon': ('automattelefon',),
'automattelefonen': ('automattelefon',),
'automattelefonene': ('automattelefon',),
'automattelefoner': ('automattelefon',),
'automatvåpen': ('automatvåpen',),
'automatvåpenet': ('automatvåpen',),
'automatvåpna': ('automatvåpen',),
'automatvåpnene': ('automatvåpen',),
'automobil': ('automobil',),
'automobilen': ('automobil',),
'automobilene': ('automobil',),
'automobiler': ('automobil',),
'automobilklubb': ('automobilklubb',),
'automobilklubben': ('automobilklubb',),
'automobilklubbene': ('automobilklubb',),
'automobilklubber': ('automobilklubb',),
'autonomi': ('autonomi',),
'autonomien': ('autonomi',),
'autonomiene': ('autonomi',),
'autonomier': ('autonomi',),
'autopilot': ('autopilot',),
'autopiloten': ('autopilot',),
'autopilotene': ('autopilot',),
'autopiloter': ('autopilot',),
'autopsi': ('autopsi',),
'autopsien': ('autopsi',),
'autopsiene': ('autopsi',),
'autopsier': ('autopsi',),
'autor': ('autor',),
'autoren': ('autor',),
'autorene': ('autor',),
'autorer': ('autor',),
'autoreksemplar': ('autoreksemplar',),
'autoreksemplara': ('autoreksemplar',),
'autoreksemplarene': ('autoreksemplar',),
'autoreksemplarer': ('autoreksemplar',),
'autoreksemplaret': ('autoreksemplar',),
'autorhonorar': ('autorhonorar',),
'autorhonorara': ('autorhonorar',),
'autorhonorarene': ('autorhonorar',),
'autorhonorarer': ('autorhonorar',),
'autorhonoraret': ('autorhonorar',),
'autorisasjon': ('autorisasjon',),
'autorisasjonen': ('autorisasjon',),
'autorisasjonene': ('autorisasjon',),
'autorisasjoner': ('autorisasjon',),
'autorisasjonsprøva': ('autorisasjonsprøve',),
'autorisasjonsprøve': ('autorisasjonsprøve',),
'autorisasjonsprøven': ('autorisasjonsprøve',),
'autorisasjonsprøvene': ('autorisasjonsprøve',),
'autorisasjonsprøver': ('autorisasjonsprøve',),
'autoritet': ('autoritet',),
'autoriteten': ('autoritet',),
'autoritetene': ('autoritet',),
'autoriteter': ('autoritet',),
'autoritetsfrykt': ('autoritetsfrykt',),
'autoritetsfrykten': ('autoritetsfrykt',),
'autoritetsfryktene': ('autoritetsfrykt',),
'autoritetsfrykter': ('autoritetsfrykt',),
'autoritetstru': ('autoritetstru',),
'autoritetstrua': ('autoritetstru',),
'autoritetstruen': ('autoritetstru',),
'autoritetstruene': ('autoritetstru',),
'autoritetstruer': ('autoritetstru',),
'autostrada': ('autostrada',),
'autostradaen': ('autostrada',),
'autostradaene': ('autostrada',),
'autostradaer': ('autostrada',),
'autovern': ('autovern',),
'autoverna': ('autovern',),
'autovernene': ('autovern',),
'autovernet': ('autovern',),
'av-middel': ('av-middel',),
'av-middelet': ('av-middel',),
'av-midla': ('av-middel',),
'av-midlene': ('av-middel',),
'av-midler': ('av-middel',),
'av-midlet': ('av-middel',),
'aval': ('aval',),
'avalen': ('aval',),
'avalene': ('aval',),
'avaler': ('aval',),
'avalveksel': ('avalveksel',),
'avalvekselen': ('avalveksel',),
'avalvekslene': ('avalveksel',),
'avalveksler': ('avalveksel',),
'avanse': ('avanse',),
'avansen': ('avanse',),
'avansene': ('avanse',),
'avanser': ('avanse',),
'avansement': ('avansement',),
'avansementa': ('avansement',),
'avansementene': ('avansement',),
'avansementer': ('avansement',),
'avansementet': ('avansement',),
'avansementsmulighet': ('avansementsmulighet',),
'avansementsmuligheta': ('avansementsmulighet',),
'avansementsmuligheten': ('avansementsmulighet',),
'avansementsmulighetene': ('avansementsmulighet',),
'avansementsmuligheter': ('avansementsmulighet',),
'avansementsregel': ('avansementsregel',),
'avansementsregelen': ('avansementsregel',),
'avansementsreglene': ('avansementsregel',),
'avansementsregler': ('avansementsregel',),
'avansementsstilling': ('avansementsstilling',),
'avansementsstillinga': ('avansementsstilling',),
'avansementsstillingen': ('avansementsstilling',),
'avansementsstillingene': ('avansementsstilling',),
'avansementsstillinger': ('avansementsstilling',),
'avansementsvilkår': ('avansementsvilkår',),
'avansementsvilkåra': ('avansementsvilkår',),
'avansementsvilkårene': ('avansementsvilkår',),
'avansementsvilkåret': ('avansementsvilkår',),
'avansestopp': ('avansestopp',),
'avansestoppen': ('avansestopp',),
'avansestoppene': ('avansestopp',),
'avansestopper': ('avansestopp',),
'avansetap': ('avansetap',),
'avansetapa': ('avansetap',),
'avansetapene': ('avansetap',),
'avansetapet': ('avansetap',),
'avantgarde': ('avantgarde',),
'avantgarden': ('avantgarde',),
'avantgardene': ('avantgarde',),
'avantgarder': ('avantgarde',),
'avantgardist': ('avantgardist',),
'avantgardisten': ('avantgardist',),
'avantgardistene': ('avantgardist',),
'avantgardister': ('avantgardist',),
'avart': ('avart',),
'avarta': ('avart',),
'avarten': ('avart',),
'avartene': ('avart',),
'avarter': ('avart',),
'avbenyttelse': ('avbenyttelse',),
'avbenyttelsen': ('avbenyttelse',),
'avbenyttelsene': ('avbenyttelse',),
'avbenyttelser': ('avbenyttelse',),
'avbestilling': ('avbestilling',),
'avbestillinga': ('avbestilling',),
'avbestillingen': ('avbestilling',),
'avbestillingene': ('avbestilling',),
'avbestillinger': ('avbestilling',),
'avbestillingsgebyr': ('avbestillingsgebyr',),
'avbestillingsgebyra': ('avbestillingsgebyr',),
'avbestillingsgebyrene': ('avbestillingsgebyr',),
'avbestillingsgebyrer': ('avbestillingsgebyr',),
'avbestillingsgebyret': ('avbestillingsgebyr',),
'avbetaling': ('avbetaling',),
'avbetalinga': ('avbetaling',),
'avbetalingen': ('avbetaling',),
'avbetalingene': ('avbetaling',),
'avbetalinger': ('avbetaling',),
'avbetalingshandel': ('avbetalingshandel',),
'avbetalingshandelen': ('avbetalingshandel',),
'avbetalingshandlene': ('avbetalingshandel',),
'avbetalingshandler': ('avbetalingshandel',),
'avbetalingskontrakt': ('avbetalingskontrakt',),
'avbetalingskontrakten': ('avbetalingskontrakt',),
'avbetalingskontraktene': ('avbetalingskontrakt',),
'avbetalingskontrakter': ('avbetalingskontrakt',),
'avbetalingssalg': ('avbetalingssalg',),
'avbetalingssalga': ('avbetalingssalg',),
'avbetalingssalgene': ('avbetalingssalg',),
'avbetalingssalget': ('avbetalingssalg',),
'avbetalingssystem': ('avbetalingssystem',),
'avbetalingssystema': ('avbetalingssystem',),
'avbetalingssystemene': ('avbetalingssystem',),
'avbetalingssystemer': ('avbetalingssystem',),
'avbetalingssystemet': ('avbetalingssystem',),
'avbikt': ('avbikt',),
'avbikten': ('avbikt',),
'avbiktene': ('avbikt',),
'avbikter': ('avbikt',),
'avbilda': ('avbilde',),
'avbilde': ('avbilde',),
'avbildene': ('avbilde',),
'avbilder': ('avbilde',),
'avbildet': ('avbilde',),
'avbildning': ('avbildning',),
'avbildninga': ('avbildning',),
'avbildningen': ('avbildning',),
'avbildningene': ('avbildning',),
'avbildninger': ('avbildning',),
'avbiter': ('avbiter',),
'avbitere': ('avbiter',),
'avbiteren': ('avbiter',),
'avbiterer': ('avbiter',),
'avbiterne': ('avbiter',),
'avblåsning': ('avblåsning',),
'avblåsninga': ('avblåsning',),
'avblåsningen': ('avblåsning',),
'avblåsningene': ('avblåsning',),
'avblåsninger': ('avblåsning',),
'avbrekk': ('avbrekk',),
'avbrekka': ('avbrekk',),
'avbrekkene': ('avbrekk',),
'avbrekket': ('avbrekk',),
'avbrott': ('avbrott',),
'avbrotta': ('avbrott',),
'avbrottene': ('avbrott',),
'avbrottet': ('avbrott',),
'avbrottsforsikring': ('avbrottsforsikring',),
'avbrottsforsikringa': ('avbrottsforsikring',),
'avbrottsforsikringen': ('avbrottsforsikring',),
'avbrottsforsikringene': ('avbrottsforsikring',),
'avbrottsforsikringer': ('avbrottsforsikring',),
'avbrudd': ('avbrudd',),
'avbrudda': ('avbrudd',),
'avbruddene': ('avbrudd',),
'avbruddet': ('avbrudd',),
'avbruddsforsikring': ('avbruddsforsikring',),
'avbruddsforsikringa': ('avbruddsforsikring',),
'avbruddsforsikringen': ('avbruddsforsikring',),
'avbruddsforsikringene': ('avbruddsforsikring',),
'avbruddsforsikringer': ('avbruddsforsikring',),
'avbrytelse': ('avbrytelse',),
'avbrytelsen': ('avbrytelse',),
'avbrytelsene': ('avbrytelse',),
'avbrytelser': ('avbrytelse',),
'avbud': ('avbud',),
'avbuda': ('avbud',),
'avbudene': ('avbud',),
'avbudet': ('avbud',),
'avbygd': ('avbygd',),
'avbygda': ('avbygd',),
'avbygden': ('avbygd',),
'avbygdene': ('avbygd',),
'avbygder': ('avbygd',),
'avdal': ('avdal',),
'avdalen': ('avdal',),
'avdalene': ('avdal',),
'avdaler': ('avdal',),
'avdekking': ('avdekking',),
'avdekkinga': ('avdekking',),
'avdekkingen': ('avdekking',),
'avdekkingene': ('avdekking',),
'avdekkinger': ('avdekking',),
'avdekkingslag': ('avdekkingslag',),
'avdekkingslaga': ('avdekkingslag',),
'avdekkingslagene': ('avdekkingslag',),
'avdekkingslaget': ('avdekkingslag',),
'avdekkingssjikt': ('avdekkingssjikt',),
'avdekkingssjikta': ('avdekkingssjikt',),
'avdekkingssjiktene': ('avdekkingssjikt',),
'avdekkingssjiktet': ('avdekkingssjikt',),
'avdekning': ('avdekning',),
'avdekninga': ('avdekning',),
'avdekningen': ('avdekning',),
'avdekningene': ('avdekning',),
'avdekninger': ('avdekning',),
'avdekningslag': ('avdekningslag',),
'avdekningslaga': ('avdekningslag',),
'avdekningslagene': ('avdekningslag',),
'avdekningslaget': ('avdekningslag',),
'avdekningssjikt': ('avdekningssjikt',),
'avdekningssjikta': ('avdekningssjikt',),
'avdekningssjiktene': ('avdekningssjikt',),
'avdekningssjiktet': ('avdekningssjikt',),
'avdeling': ('avdeling',),
'avdelinga': ('avdeling',),
'avdelingen': ('avdeling',),
'avdelingene': ('avdeling',),
'avdelinger': ('avdeling',),
'avdelingskontor': ('avdelingskontor',),
'avdelingskontora': ('avdelingskontor',),
'avdelingskontorene': ('avdelingskontor',),
'avdelingskontorer': ('avdelingskontor',),
'avdelingskontoret': ('avdelingskontor',),
'avdelingsleder': ('avdelingsleder',),
'avdelingsledere': ('avdelingsleder',),
'avdelingslederen': ('avdelingsleder',),
'avdelingslederer': ('avdelingsleder',),
'avdelingslederne': ('avdelingsleder',),
'avdelingslege': ('avdelingslege',),
'avdelingslegen': ('avdelingslege',),
'avdelingslegene': ('avdelingslege',),
'avdelingsleger': ('avdelingslege',),
'avdelingssjef': ('avdelingssjef',),
'avdelingssjefen': ('avdelingssjef',),
'avdelingssjefene': ('avdelingssjef',),
'avdelingssjefer': ('avdelingssjef',),
'avdelingssjukepleier': ('avdelingssjukepleier',),
'avdelingssjukepleiere': ('avdelingssjukepleier',),
'avdelingssjukepleieren': ('avdelingssjukepleier',),
'avdelingssjukepleierer': ('avdelingssjukepleier',),
'avdelingssjukepleierne': ('avdelingssjukepleier',),
'avdelingssykepleier': ('avdelingssykepleier',),
'avdelingssykepleiere': ('avdelingssykepleier',),
'avdelingssykepleieren': ('avdelingssykepleier',),
'avdelingssykepleierer': ('avdelingssykepleier',),
'avdelingssykepleierne': ('avdelingssykepleier',),
'avdrag': ('avdrag',),
'avdraga': ('avdrag',),
'avdragene': ('avdrag',),
'avdraget': ('avdrag',),
'avdragsbeløp': ('avdragsbeløp',),
'avdragsbeløpa': ('avdragsbeløp',),
'avdragsbeløpene': ('avdragsbeløp',),
'avdragsbeløpet': ('avdragsbeløp',),
'avdragsordning': ('avdragsordning',),
'avdragsordninga': ('avdragsordning',),
'avdragsordningen': ('avdragsordning',),
'avdragsordningene': ('avdragsordning',),
'avdragsordninger': ('avdragsordning',),
'avdragssum': ('avdragssum',),
'avdragssummen': ('avdragssum',),
'avdragssummene': ('avdragssum',),
'avdragssummer': ('avdragssum',),
'avdragssystem': ('avdragssystem',),
'avdragssystema': ('avdragssystem',),
'avdragssystemene': ('avdragssystem',),
'avdragssystemer': ('avdragssystem',),
'avdragssystemet': ('avdragssystem',),
'avdrift': ('avdrift',),
'avdrifta': ('avdrift',),
'avdriften': ('avdrift',),
'avdriftene': ('avdrift',),
'avdrifter': ('avdrift',),
'avdriftskompas': ('avdriftskompas',),
'avdriftskompasa': ('avdriftskompas',),
'avdriftskompasen': ('avdriftskompas',),
'avdriftskompasene': ('avdriftskompas',),
'avdriftskompaser': ('avdriftskompas',),
'avdriftskompaset': ('avdriftskompas',),
'avdriftskompass': ('avdriftskompass',),
'avdriftskompassa': ('avdriftskompass',),
'avdriftskompassen': ('avdriftskompass',),
'avdriftskompassene': ('avdriftskompass',),
'avdriftskompasser': ('avdriftskompass',),
'avdriftskompasset': ('avdriftskompass',),
'avdrått': ('avdrått',),
'avdråtten': ('avdrått',),
'avdråttene': ('avdrått',),
'avdråtter': ('avdrått',),
'avdråttsevna': ('avdråttsevne',),
'avdråttsevne': ('avdråttsevne',),
'avdråttsevnen': ('avdråttsevne',),
'avdråttsevnene': ('avdråttsevne',),
'avdråttsevner': ('avdråttsevne',),
'avdråttskontroll': ('avdråttskontroll',),
'avdråttskontrollen': ('avdråttskontroll',),
'avdråttskontrollene': ('avdråttskontroll',),
'avdråttskontroller': ('avdråttskontroll',),
'avduking': ('avduking',),
'avdukinga': ('avduking',),
'avdukingen': ('avduking',),
'avdukingene': ('avduking',),
'avdukinger': ('avduking',),
'avdukingshøgtid': ('avdukingshøgtid',),
'avdukingshøgtida': ('avdukingshøgtid',),
'avdukingshøgtiden': ('avdukingshøgtid',),
'avdukingshøgtidene': ('avdukingshøgtid',),
'avdukingshøgtider': ('avdukingshøgtid',),
'avdukingshøytid': ('avdukingshøytid',),
'avdukingshøytida': ('avdukingshøytid',),
'avdukingshøytiden': ('avdukingshøytid',),
'avdukingshøytidene': ('avdukingshøytid',),
'avdukingshøytider': ('avdukingshøytid',),
'avdukingsseremoni': ('avdukingsseremoni',),
'avdukingsseremonien': ('avdukingsseremoni',),
'avdukingsseremoniene': ('avdukingsseremoni',),
'avdukingsseremonier': ('avdukingsseremoni',),
'ava': ('ave',),
'ave': ('ave',),
'avene': ('ave',),
'aver': ('ave',),
'avet': ('ave',),
'ave-maria': ('ave-maria',),
'ave-mariaene': ('ave-maria',),
'ave-mariaer': ('ave-maria',),
'ave-mariaet': ('ave-maria',),
'avec': ('avec',),
'aveny': ('aveny',),
'avenyen': ('aveny',),
'avenyene': ('aveny',),
'avenyer': ('aveny',),
'avers': ('avers',),
'aversen': ('avers',),
'aversene': ('avers',),
'averser': ('avers',),
'aversan': ('aversan',),
'aversana': ('aversan',),
'aversanene': ('aversan',),
'aversanet': ('aversan',),
'aversankur': ('aversankur',),
'aversankuren': ('aversankur',),
'aversankurene': ('aversankur',),
'aversankurer': ('aversankur',),
'aversjon': ('aversjon',),
'aversjonen': ('aversjon',),
'aversjonene': ('aversjon',),
'aversjoner': ('aversjon',),
'avertering': ('avertering',),
'averteringa': ('avertering',),
'averteringen': ('avertering',),
'averteringene': ('avertering',),
'averteringer': ('avertering',),
'avertissement': ('avertissement',),
'avertissementa': ('avertissement',),
'avertissementene': ('avertissement',),
'avertissementer': ('avertissement',),
'avertissementet': ('avertissement',),
'avfall': ('avfall',),
'avfalla': ('avfall',),
'avfallene': ('avfall',),
'avfallet': ('avfall',),
'avfallsbøtta': ('avfallsbøtte',),
'avfallsbøtte': ('avfallsbøtte',),
'avfallsbøtten': ('avfallsbøtte',),
'avfallsbøttene': ('avfallsbøtte',),
'avfallsbøtter': ('avfallsbøtte',),
'avfallsdunk': ('avfallsdunk',),
'avfallsdunken': ('avfallsdunk',),
'avfallsdunkene': ('avfallsdunk',),
'avfallsdunker': ('avfallsdunk',),
'avfallskvern': ('avfallskvern',),
'avfallskverna': ('avfallskvern',),
'avfallskvernen': ('avfallskvern',),
'avfallskvernene': ('avfallskvern',),
'avfallskverner': ('avfallskvern',),
'avfallsplass': ('avfallsplass',),
'avfallsplassen': ('avfallsplass',),
'avfallsplassene': ('avfallsplass',),
'avfallsplasser': ('avfallsplass',),
'avfallsprodukt': ('avfallsprodukt',),
'avfallsprodukta': ('avfallsprodukt',),
'avfallsproduktene': ('avfallsprodukt',),
'avfallsprodukter': ('avfallsprodukt',),
'avfallsproduktet': ('avfallsprodukt',),
'avfallssjakt': ('avfallssjakt',),
'avfallssjakta': ('avfallssjakt',),
'avfallssjakten': ('avfallssjakt',),
'avfallssjaktene': ('avfallssjakt',),
'avfallssjakter': ('avfallssjakt',),
'avfallsstoff': ('avfallsstoff',),
'avfallsstoffa': ('avfallsstoff',),
'avfallsstoffene': ('avfallsstoff',),
'avfallsstoffer': ('avfallsstoff',),
'avfallsstoffet': ('avfallsstoff',),
'avfolking': ('avfolking',),
'avfolkinga': ('avfolking',),
'avfolkingen': ('avfolking',),
'avfolkingene': ('avfolking',),
'avfolkinger': ('avfolking',),
'avfolkingstendens': ('avfolkingstendens',),
'avfolkingstendensen': ('avfolkingstendens',),
'avfolkingstendensene': ('avfolkingstendens',),
'avfolkingstendenser': ('avfolkingstendens',),
'avfolkning': ('avfolkning',),
'avfolkninga': ('avfolkning',),
'avfolkningen': ('avfolkning',),
'avfolkningene': ('avfolkning',),
'avfolkninger': ('avfolkning',),
'avfolkningstendens': ('avfolkningstendens',),
'avfolkningstendensen': ('avfolkningstendens',),
'avfolkningstendensene': ('avfolkningstendens',),
'avfolkningstendenser': ('avfolkningstendens',),
'avføring': ('avføring',),
'avføringa': ('avføring',),
'avføringen': ('avføring',),
'avføringene': ('avføring',),
'avføringer': ('avføring',),
'avføringsmiddel': ('avføringsmiddel',),
'avføringsmiddelet': ('avføringsmiddel',),
'avføringsmidla': ('avføringsmiddel',),
'avføringsmidlene': ('avføringsmiddel',),
'avføringsmidler': ('avføringsmiddel',),
'avføringsmidlet': ('avføringsmiddel',),
'avføringspilla': ('avføringspille',),
'avføringspille': ('avføringspille',),
'avføringspillen': ('avføringspille',),
'avføringspillene': ('avføringspille',),
'avføringspiller': ('avføringspille',),
'avføringsprøva': ('avføringsprøve',),
'avføringsprøve': ('avføringsprøve',),
'avføringsprøven': ('avføringsprøve',),
'avføringsprøvene': ('avføringsprøve',),
'avføringsprøver': ('avføringsprøve',),
'avgang': ('avgang',),
'avgangen': ('avgang',),
'avgangene': ('avgang',),
'avganger': ('avgang',),
'avgangseksamen': ('avgangseksamen',),
'avgangseksamenen': ('avgangseksamen',),
'avgangseksamenene': ('avgangseksamen',),
'avgangseksamener': ('avgangseksamen',),
'avgangsklassa': ('avgangsklasse',),
'avgangsklasse': ('avgangsklasse',),
'avgangsklassen': ('avgangsklasse',),
'avgangsklassene': ('avgangsklasse',),
'avgangsklasser': ('avgangsklasse',),
'avgangsprøva': ('avgangsprøve',),
'avgangsprøve': ('avgangsprøve',),
'avgangsprøven': ('avgangsprøve',),
'avgangsprøvene': ('avgangsprøve',),
'avgangsprøver': ('avgangsprøve',),
'avgangssignal': ('avgangssignal',),
'avgangssignala': ('avgangssignal',),
'avgangssignalene': ('avgangssignal',),
'avgangssignaler': ('avgangssignal',),
'avgangssignalet': ('avgangssignal',),
'avgangsstasjon': ('avgangsstasjon',),
'avgangsstasjonen': ('avgangsstasjon',),
'avgangsstasjonene': ('avgangsstasjon',),
'avgangsstasjoner': ('avgangsstasjon',),
'avgangstid': ('avgangstid',),
'avgangstida': ('avgangstid',),
'avgangstiden': ('avgangstid',),
'avgangstidene': ('avgangstid',),
'avgangstider': ('avgangstid',),
'avgangsvitnemål': ('avgangsvitnemål',),
'avgangsvitnemåla': ('avgangsvitnemål',),
'avgangsvitnemålene': ('avgangsvitnemål',),
'avgangsvitnemålet': ('avgangsvitnemål',),
'avgangsvitnesbyrd': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrda': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrdene': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrdet': ('avgangsvitnesbyrd',),
'avgass': ('avgass',),
'avgassen': ('avgass',),
'avgassene': ('avgass',),
'avgasser': ('avgass',),
'avgift': ('avgift',),
'avgifta': ('avgift',),
'avgiften': ('avgift',),
'avgiftene': ('avgift',),
'avgifter': ('avgift',),
'avgifting': ('avgifting',),
'avgiftinga': ('avgifting',),
'avgiftingen': ('avgifting',),
'avgiftingene': ('avgifting',),
'avgiftinger': ('avgifting',),
'avgiftning': ('avgiftning',),
'avgiftninga': ('avgiftning',),
'avgiftningen': ('avgiftning',),
'avgiftningene': ('avgiftning',),
'avgiftninger': ('avgiftning',),
'avgiftsplikt': ('avgiftsplikt',),
'avgiftsplikta': ('avgiftsplikt',),
'avgiftsplikten': ('avgiftsplikt',),
'avgiftspliktene': ('avgiftsplikt',),
'avgiftsplikter': ('avgiftsplikt',),
'avgjerd': ('avgjerd',),
'avgjerda': ('avgjerd',),
'avgjerden': ('avgjerd',),
'avgjerdene': ('avgjerd',),
'avgjerder': ('avgjerd',),
'avgjersla': ('avgjersle',),
'avgjersle': ('avgjersle',),
'avgjerslen': ('avgjersle',),
'avgjerslene': ('avgjersle',),
'avgjersler': ('avgjersle',),
'avgjørelse': ('avgjørelse',),
'avgjørelsen': ('avgjørelse',),
'avgjørelsene': ('avgjørelse',),
'avgjørelser': ('avgjørelse',),
'avgjørelsesprosess': ('avgjørelsesprosess',),
'avgjørelsesprosessen': ('avgjørelsesprosess',),
'avgjørelsesprosessene': ('avgjørelsesprosess',),
'avgjørelsesprosesser': ('avgjørelsesprosess',),
'avglans': ('avglans',),
'avglansen': ('avglans',),
'avglansene': ('avglans',),
'avglanser': ('avglans',),
'avgrensing': ('avgrensing',),
'avgrensinga': ('avgrensing',),
'avgrensingen': ('avgrensing',),
'avgrensingene': ('avgrensing',),
'avgrensinger': ('avgrensing',),
'avgrensingsproblem': ('avgrensingsproblem',),
'avgrensingsproblema': ('avgrensingsproblem',),
'avgrensingsproblemene': ('avgrensingsproblem',),
'avgrensingsproblemer': ('avgrensingsproblem',),
'avgrensingsproblemet': ('avgrensingsproblem',),
'avgrensning': ('avgrensning',),
'avgrensninga': ('avgrensning',),
'avgrensningen': ('avgrensning',),
'avgrensningene': ('avgrensning',),
'avgrensninger': ('avgrensning',),
'avgrensningsproblem': ('avgrensningsproblem',),
'avgrensningsproblema': ('avgrensningsproblem',),
'avgrensningsproblemene': ('avgrensningsproblem',),
'avgrensningsproblemer': ('avgrensningsproblem',),
'avgrensningsproblemet': ('avgrensningsproblem',),
'avgrunn': ('avgrunn',),
'avgrunnen': ('avgrunn',),
'avgrunnene': ('avgrunn',),
'avgrunner': ('avgrunn',),
'avgud': ('avgud',),
'avguden': ('avgud',),
'avgudene': ('avgud',),
'avguder': ('avgud',),
'avguderi': ('avguderi',),
'avguderia': ('avguderi',),
'avguderiene': ('avguderi',),
'avguderier': ('avguderi',),
'avguderiet': ('avguderi',),
'avgudsbilda': ('avgudsbilde',),
'avgudsbilde': ('avgudsbilde',),
'avgudsbildene': ('avgudsbilde',),
'avgudsbilder': ('avgudsbilde',),
'avgudsbildet': ('avgudsbilde',),
'avgudsdyrkelse': ('avgudsdyrkelse',),
'avgudsdyrkelsen': ('avgudsdyrkelse',),
'avgudsdyrkelsene': ('avgudsdyrkelse',),
'avgudsdyrkelser': ('avgudsdyrkelse',),
'avgudsdyrker': ('avgudsdyrker',),
'avgudsdyrkere': ('avgudsdyrker',),
'avgudsdyrkeren': ('avgudsdyrker',),
'avgudsdyrkerer': ('avgudsdyrker',),
'avgudsdyrkerne': ('avgudsdyrker',),
'avgudsdyrking': ('avgudsdyrking',),
'avgudsdyrkinga': ('avgudsdyrking',),
'avgudsdyrkingen': ('avgudsdyrking',),
'avgudsdyrkingene': ('avgudsdyrking',),
'avgudsdyrkinger': ('avgudsdyrking',),
'avgudstempel': ('avgudstempel',),
'avgudstempelet': ('avgudstempel',),
'avgudstempla': ('avgudstempel',),
'avgudstemplene': ('avgudstempel',),
'avgudstempler': ('avgudstempel',),
'avgudstemplet': ('avgudstempel',),
'avhandling': ('avhandling',),
'avhandlinga': ('avhandling',),
'avhandlingen': ('avhandling',),
'avhandlingene': ('avhandling',),
'avhandlinger': ('avhandling',),
'avhandlingsstil': ('avhandlingsstil',),
'avhandlingsstilen': ('avhandlingsstil',),
'avhandlingsstilene': ('avhandlingsstil',),
'avhandlingsstiler': ('avhandlingsstil',),
'avhengighet': ('avhengighet',),
'avhengigheta': ('avhengighet',),
'avhengigheten': ('avhengighet',),
'avhengighetene': ('avhengighet',),
'avhengigheter': ('avhengighet',),
'avhengighetsforhold': ('avhengighetsforhold',),
'avhengighetsforholda': ('avhengighetsforhold',),
'avhengighetsforholdene': ('avhengighetsforhold',),
'avhengighetsforholdet': ('avhengighetsforhold',),
'avhengighetsform': ('avhengighetsform',),
'avhengighetsforma': ('avhengighetsform',),
'avhengighetsformen': ('avhengighetsform',),
'avhengighetsformene': ('avhengighetsform',),
'avhengighetsformer': ('avhengighetsform',),
'avhengighetsfølelse': ('avhengighetsfølelse',),
'avhengighetsfølelsen': ('avhengighetsfølelse',),
'avhengighetsfølelsene': ('avhengighetsfølelse',),
'avhengighetsfølelser': ('avhengighetsfølelse',),
'avhol': ('avhol',),
'avhola': ('avhol',),
'avholene': ('avhol',),
'avholet': ('avhol',),
'avhold': ('avhold',),
'avholda': ('avhold',),
'avholdene': ('avhold',),
'avholdet': ('avhold',),
'avholdenhet': ('avholdenhet',),
'avholdenheta': ('avholdenhet',),
'avholdenheten': ('avholdenhet',),
'avholdenhetene': ('avholdenhet',),
'avholdenheter': ('avholdenhet',),
'avholdsarbeid': ('avholdsarbeid',),
'avholdsarbeida': ('avholdsarbeid',),
'avholdsarbeidene': ('avholdsarbeid',),
'avholdsarbeider': ('avholdsarbeid',),
'avholdsarbeidet': ('avholdsarbeid',),
'avholdsbevegelse': ('avholdsbevegelse',),
'avholdsbevegelsen': ('avholdsbevegelse',),
'avholdsbevegelsene': ('avholdsbevegelse',),
'avholdsbevegelser': ('avholdsbevegelse',),
'avholdsfolk': ('avholdsfolk',),
'avholdsfolka': ('avholdsfolk',),
'avholdsfolkene': ('avholdsfolk',),
'avholdsfolket': ('avholdsfolk',),
'avholdslosje': ('avholdslosje',),
'avholdslosjen': ('avholdslosje',),
'avholdslosjene': ('avholdslosje',),
'avholdslosjer': ('avholdslosje',),
'avholdssak': ('avholdssak',),
'avholdssaka': ('avholdssak',),
'avholdssaken': ('avholdssak',),
'avholdssakene': ('avholdssak',),
'avholdssaker': ('avholdssak',),
'avhopper': ('avhopper',),
'avhoppere': ('avhopper',),
'avhopperen': ('avhopper',),
'avhopperer': ('avhopper',),
'avhopperne': ('avhopper',),
'avhull': ('avhull',),
'avhulla': ('avhull',),
'avhullene': ('avhull',),
'avhuller': ('avhull',),
'avhullet': ('avhull',),
'avhør': ('avhør',),
'avhøra': ('avhør',),
'avhørene': ('avhør',),
'avhøret': ('avhør',),
'aviaria': ('aviarium',),
'aviariene': ('aviarium',),
'aviarier': ('aviarium',),
'aviariet': ('aviarium',),
'aviarium': ('aviarium',),
'aviatiker': ('aviatiker',),
'aviatikere': ('aviatiker',),
'aviatikeren': ('aviatiker',),
'aviatikerer': ('aviatiker',),
'aviatikerne': ('aviatiker',),
'aviatikk': ('aviatikk',),
'aviatikken': ('aviatikk',),
'aviatikkene': ('aviatikk',),
'aviatikker': ('aviatikk',),
'avind': ('avind',),
'avinden': ('avind',),
'avindene': ('avind',),
'avinder': ('avind',),
'avis': ('avis',),
'avisa': ('avis',),
'avisen': ('avis',),
'avisene': ('avis',),
'aviser': ('avis',),
'avisand': ('avisand',),
'avisanda': ('avisand',),
'avisanden': ('avisand',),
'avisendene': ('avisand',),
'avisender': ('avisand',),
'avisartikkel': ('avisartikkel',),
'avisartikkelen': ('avisartikkel',),
'avisartiklene': ('avisartikkel',),
'avisartikler': ('avisartikkel',),
'avisbud': ('avisbud',),
'avisbuda': ('avisbud',),
'avisbudene': ('avisbud',),
'avisbudet': ('avisbud',),
'avisdebatt': ('avisdebatt',),
'avisdebatten': ('avisdebatt',),
'avisdebattene': ('avisdebatt',),
'avisdebatter': ('avisdebatt',),
'avisdød': ('avisdød',),
'avisdøden': ('avisdød',),
'avisdødene': ('avisdød',),
'avisdøder': ('avisdød',),
'avisekspedisjon': ('avisekspedisjon',),
'avisekspedisjonen': ('avisekspedisjon',),
'avisekspedisjonene': ('avisekspedisjon',),
'avisekspedisjoner': ('avisekspedisjon',),
'avisfeide': ('avisfeide',),
'avisfeiden': ('avisfeide',),
'avisfeidene': ('avisfeide',),
'avisfeider': ('avisfeide',),
'avisingsanlegg': ('avisingsanlegg',),
'avisingsanlegga': ('avisingsanlegg',),
'avisingsanleggene': ('avisingsanlegg',),
'avisingsanlegget': ('avisingsanlegg',),
'avisinnlegg': ('avisinnlegg',),
'avisinnlegga': ('avisinnlegg',),
'avisinnleggene': ('avisinnlegg',),
'avisinnlegget': ('avisinnlegg',),
'aviskiosk': ('aviskiosk',),
'aviskiosken': ('aviskiosk',),
'aviskioskene': ('aviskiosk',),
'aviskiosker': ('aviskiosk',),
'avisklipp': ('avisklipp',),
'avisklippa': ('avisklipp',),
'avisklippene': ('avisklipp',),
'avisklippet': ('avisklipp',),
'avisklipparkiv': ('avisklipparkiv',),
'avisklipparkiva': ('avisklipparkiv',),
'avisklipparkivene': ('avisklipparkiv',),
'avisklipparkiver': ('avisklipparkiv',),
'avisklipparkivet': ('avisklipparkiv',),
'aviskritikk': ('aviskritikk',),
'aviskritikken': ('aviskritikk',),
'aviskritikkene': ('aviskritikk',),
'aviskritikker': ('aviskritikk',),
'avisoveksel': ('avisoveksel',),
'avisovekselen': ('avisoveksel',),
'avisovekslene': ('avisoveksel',),
'avisoveksler': ('avisoveksel',),
'avisoverskrift': ('avisoverskrift',),
'avisoverskrifta': ('avisoverskrift',),
'avisoverskriften': ('avisoverskrift',),
'avisoverskriftene': ('avisoverskrift',),
'avisoverskrifter': ('avisoverskrift',),
'avispolemikk': ('avispolemikk',),
'avispolemikken': ('avispolemikk',),
'avispolemikkene': ('avispolemikk',),
'avispolemikker': ('avispolemikk',),
'avisredaktør': ('avisredaktør',),
'avisredaktøren': ('avisredaktør',),
'avisredaktørene': ('avisredaktør',),
'avisredaktører': ('avisredaktør',),
'avisreferat': ('avisreferat',),
'avisreferata': ('avisreferat',),
'avisreferatene': ('avisreferat',),
'avisreferater': ('avisreferat',),
'avisreferatet': ('avisreferat',),
'avisskribent': ('avisskribent',),
'avisskribenten': ('avisskribent',),
'avisskribentene': ('avisskribent',),
'avisskribenter': ('avisskribent',),
'avistaveksel': ('avistaveksel',),
'avistavekselen': ('avistaveksel',),
'avistavekslene': ('avistaveksel',),
'avistaveksler': ('avistaveksel',),
'avistegner': ('avistegner',),
'avistegnere': ('avistegner',),
'avistegneren': ('avistegner',),
'avistegnerer': ('avistegner',),
'avistegnerne': ('avistegner',),
'avisutklipp': ('avisutklipp',),
'avisutklippa': ('avisutklipp',),
'avisutklippene': ('avisutklipp',),
'avisutklippet': ('avisutklipp',),
'avkall': ('avkall',),
'avkalla': ('avkall',),
'avkallene': ('avkall',),
'avkallet': ('avkall',),
'avkast': ('avkast',),
'avkasta': ('avkast',),
'avkastene': ('avkast',),
'avkastet': ('avkast',),
'avkasting': ('avkasting',),
'avkastinga': ('avkasting',),
'avkastingen': ('avkasting',),
'avkastingene': ('avkasting',),
'avkastinger': ('avkasting',),
'avkastning': ('avkastning',),
'avkastninga': ('avkastning',),
'avkastningen': ('avkastning',),
'avkastningene': ('avkastning',),
'avkastninger': ('avkastning',),
'avkjøling': ('avkjøling',),
'avkjølinga': ('avkjøling',),
'avkjølingen': ('avkjøling',),
'avkjølingene': ('avkjøling',),
'avkjølinger': ('avkjøling',),
'avkjøring': ('avkjøring',),
'avkjøringa': ('avkjøring',),
'avkjøringen': ('avkjøring',),
'avkjøringene': ('avkjøring',),
'avkjøringer': ('avkjøring',),
'avkjøringsrampa': ('avkjøringsrampe',),
'avkjøringsrampe': ('avkjøringsrampe',),
'avkjøringsrampen': ('avkjøringsrampe',),
'avkjøringsrampene': ('avkjøringsrampe',),
'avkjøringsramper': ('avkjøringsrampe',),
'avkjøringsveg': ('avkjøringsveg',),
'avkjøringsvegen': ('avkjøringsveg',),
'avkjøringsvegene': ('avkjøringsveg',),
'avkjøringsveger': ('avkjøringsveg',),
'avkjøringsvei': ('avkjøringsvei',),
'avkjøringsveien': ('avkjøringsvei',),
'avkjøringsveiene': ('avkjøringsvei',),
'avkjøringsveier': ('avkjøringsvei',),
'avkjørsel': ('avkjørsel',),
'avkjørselen': ('avkjørsel',),
'avkjørsla': ('avkjørsel',),
'avkjørslene': ('avkjørsel',),
'avkjørsler': ('avkjørsel',),
'avklaring': ('avklaring',),
'avklaringa': ('avklaring',),
'avklaringen': ('avklaring',),
'avklaringene': ('avklaring',),
'avklaringer': ('avklaring',),
'avkledingsrom': ('avkledingsrom',),
'avkledingsromma': ('avkledingsrom',),
'avkledingsrommene': ('avkledingsrom',),
'avkledingsrommet': ('avkledingsrom',),
'avkledingsscene': ('avkledingsscene',),
'avkledingsscenen': ('avkledingsscene',),
'avkledingsscenene': ('avkledingsscene',),
'avkledingsscener': ('avkledingsscene',),
'avkledningsrom': ('avkledningsrom',),
'avkledningsromma': ('avkledningsrom',),
'avkledningsrommene': ('avkledningsrom',),
'avkledningsrommet': ('avkledningsrom',),
'avkledningsscene': ('avkledningsscene',),
'avkledningsscenen': ('avkledningsscene',),
'avkledningsscenene': ('avkledningsscene',),
'avkledningsscener': ('avkledningsscene',),
'avkleingsrom': ('avkleingsrom',),
'avkleingsromma': ('avkleingsrom',),
'avkleingsrommene': ('avkleingsrom',),
'avkleingsrommet': ('avkleingsrom',),
'avkleingsscene': ('avkleingsscene',),
'avkleingsscenen': ('avkleingsscene',),
'avkleingsscenene': ('avkleingsscene',),
'avkleingsscener': ('avkleingsscene',),
'avkobling': ('avkobling',),
'avkoblinga': ('avkobling',),
'avkoblingen': ('avkobling',),
'avkoblingene': ('avkobling',),
'avkoblinger': ('avkobling',),
'avkok': ('avkok',),
'avkoka': ('avkok',),
'avkokene': ('avkok',),
'avkoket': ('avkok',),
'avkom': ('avkom',),
'avkomma': ('avkom',),
'avkommene': ('avkom',),
'avkommet': ('avkom',),
'avkomsgransking': ('avkomsgransking',),
'avkomsgranskinga': ('avkomsgransking',),
'avkomsgranskingen': ('avkomsgransking',),
'avkomsgranskingene': ('avkomsgransking',),
'avkomsgranskinger': ('avkomsgransking',),
'avkopling': ('avkopling',),
'avkoplinga': ('avkopling',),
'avkoplingen': ('avkopling',),
'avkoplingene': ('avkopling',),
'avkoplinger': ('avkopling',),
'avkorting': ('avkorting',),
'avkortinga': ('avkorting',),
'avkortingen': ('avkorting',),
'avkortingene': ('avkorting',),
'avkortinger': ('avkorting',),
'avkristning': ('avkristning',),
'avkristninga': ('avkristning',),
'avkristningen': ('avkristning',),
'avkristningene': ('avkristning',),
'avkristninger': ('avkristning',),
'avkrok': ('avkrok',),
'avkroken': ('avkrok',),
'avkrokene': ('avkrok',),
'avkroker': ('avkrok',),
'avlagring': ('avlagring',),
'avlagringa': ('avlagring',),
'avlagringen': ('avlagring',),
'avlagringene': ('avlagring',),
'avlagringer': ('avlagring',),
'avlasting': ('avlasting',),
'avlastinga': ('avlasting',),
'avlastingen': ('avlasting',),
'avlastingene': ('avlasting',),
'avlastinger': ('avlasting',),
'avlastning': ('avlastning',),
'avlastninga': ('avlastning',),
'avlastningen': ('avlastning',),
'avlastningene': ('avlastning',),
'avlastninger': ('avlastning',),
'avlat': ('avlat',),
'avlaten': ('avlat',),
'avlatene': ('avlat',),
'avlater': ('avlat',),
'avlatsbrev': ('avlatsbrev',),
'avlatsbreva': ('avlatsbrev',),
'avlatsbrevene': ('avlatsbrev',),
'avlatsbrever': ('avlatsbrev',),
'avlatsbrevet': ('avlatsbrev',),
'avlatshandel': ('avlatshandel',),
'avlatshandelen': ('avlatshandel',),
'avlatshandlene': ('avlatshandel',),
'avlatshandler': ('avlatshandel',),
'avlatspengene': ('avlatspenger',),
'avlatspenger': ('avlatspenger',),
'avledning': ('avledning',),
'avledninga': ('avledning',),
'avledningen': ('avledning',),
'avledningene': ('avledning',),
'avledninger': ('avledning',),
'avledningsendelse': ('avledningsendelse',),
'avledningsendelsen': ('avledningsendelse',),
'avledningsendelsene': ('avledningsendelse',),
'avledningsendelser': ('avledningsendelse',),
'avledningsending': ('avledningsending',),
'avledningsendinga': ('avledningsending',),
'avledningsendingen': ('avledningsending',),
'avledningsendingene': ('avledningsending',),
'avledningsendinger': ('avledningsending',),
'avledningsgrøft': ('avledningsgrøft',),
'avledningsgrøfta': ('avledningsgrøft',),
'avledningsgrøften': ('avledningsgrøft',),
'avledningsgrøftene': ('avledningsgrøft',),
'avledningsgrøfter': ('avledningsgrøft',),
'avledningsmanøver': ('avledningsmanøver',),
'avledningsmanøvere': ('avledningsmanøver',),
'avledningsmanøveren': ('avledningsmanøver',),
'avledningsmanøverne': ('avledningsmanøver',),
'avledningsmanøvre': ('avledningsmanøver',),
'avledningsmanøvrene': ('avledningsmanøver',),
'avledningsmanøvrer': ('avledningsmanøver',),
'avledningsprefiks': ('avledningsprefiks',),
'avledningsprefiksa': ('avledningsprefiks',),
'avledningsprefiksene': ('avledningsprefiks',),
'avledningsprefikser': ('avledningsprefiks',),
'avledningsprefikset': ('avledningsprefiks',),
'avledningssuffiks': ('avledningssuffiks',),
'avledningssuffiksa': ('avledningssuffiks',),
'avledningssuffiksene': ('avledningssuffiks',),
'avledningssuffikser': ('avledningssuffiks',),
'avledningssuffikset': ('avledningssuffiks',),
'avleevna': ('avleevne',),
'avleevne': ('avleevne',),
'avleevnen': ('avleevne',),
'avleevnene': ('avleevne',),
'avleevner': ('avleevne',),
'avlegger': ('avlegger',),
'avleggere': ('avlegger',),
'avleggeren': ('avlegger',),
'avleggerer': ('avlegger',),
'avleggerne': ('avlegger',),
'avleiing': ('avleiing',),
'avleiinga': ('avleiing',),
'avleiingen': ('avleiing',),
'avleiingene': ('avleiing',),
'avleiinger': ('avleiing',),
'avleiingsendelse': ('avleiingsendelse',),
'avleiingsendelsen': ('avleiingsendelse',),
'avleiingsendelsene': ('avleiingsendelse',),
'avleiingsendelser': ('avleiingsendelse',),
'avleiingsending': ('avleiingsending',),
'avleiingsendinga': ('avleiingsending',),
'avleiingsendingen': ('avleiingsending',),
'avleiingsendingene': ('avleiingsending',),
'avleiingsendinger': ('avleiingsending',),
'avleiingsgrøft': ('avleiingsgrøft',),
'avleiingsgrøfta': ('avleiingsgrøft',),
'avleiingsgrøften': ('avleiingsgrøft',),
'avleiingsgrøftene': ('avleiingsgrøft',),
'avleiingsgrøfter': ('avleiingsgrøft',),
'avleiingsmanøver': ('avleiingsmanøver',),
'avleiingsmanøvere': ('avleiingsmanøver',),
'avleiingsmanøveren': ('avleiingsmanøver',),
'avleiingsmanøverne': ('avleiingsmanøver',),
'avleiingsmanøvre': ('avleiingsmanøver',),
'avleiingsmanøvrene': ('avleiingsmanøver',),
'avleiingsmanøvrer': ('avleiingsmanøver',),
'avleiingsprefiks': ('avleiingsprefiks',),
'avleiingsprefiksa': ('avleiingsprefiks',),
'avleiingsprefiksene': ('avleiingsprefiks',),
'avleiingsprefikser': ('avleiingsprefiks',),
'avleiingsprefikset': ('avleiingsprefiks',),
'avleiingssuffiks': ('avleiingssuffiks',),
'avleiingssuffiksa': ('avleiingssuffiks',),
'avleiingssuffiksene': ('avleiingssuffiks',),
'avleiingssuffikser': ('avleiingssuffiks',),
'avleiingssuffikset': ('avleiingssuffiks',),
'avleiring': ('avleiring',),
'avleiringa': ('avleiring',),
'avleiringen': ('avleiring',),
'avleiringene': ('avleiring',),
'avleiringer': ('avleiring',),
'avlelem': ('avlelem',),
'avlelemma': ('avlelem',),
'avlelemmene': ('avlelem',),
'avlelemmer': ('avlelem',),
'avlelemmet': ('avlelem',),
'avlesing': ('avlesing',),
'avlesinga': ('avlesing',),
'avlesingen': ('avlesing',),
'avlesingene': ('avlesing',),
'avlesinger': ('avlesing',),
'avlesingsfeil': ('avlesingsfeil',),
'avlesingsfeilen': ('avlesingsfeil',),
'avlesingsfeilene': ('avlesingsfeil',),
'avlesning': ('avlesning',),
'avlesninga': ('avlesning',),
'avlesningen': ('avlesning',),
'avlesningene': ('avlesning',),
'avlesninger': ('avlesning',),
'avlesningsfeil': ('avlesningsfeil',),
'avlesningsfeilen': ('avlesningsfeil',),
'avlesningsfeilene': ('avlesningsfeil',),
'avlevering': ('avlevering',),
'avleveringa': ('avlevering',),
'avleveringen': ('avlevering',),
'avleveringene': ('avlevering',),
'avleveringer': ('avlevering',),
'avling': ('avling',),
'avlinga': ('avling',),
'avlingen': ('avling',),
'avlingene': ('avling',),
'avlinger': ('avling',),
'avlingsmengde': ('avlingsmengde',),
'avlingsmengden': ('avlingsmengde',),
'avlingsmengdene': ('avlingsmengde',),
'avlingsmengder': ('avlingsmengde',),
'avlingsskade': ('avlingsskade',),
'avlingsskaden': ('avlingsskade',),
'avlingsskadene': ('avlingsskade',),
'avlingsskader': ('avlingsskade',),
'avlingssvikt': ('avlingssvikt',),
'avlingssvikten': ('avlingssvikt',),
'avlingssviktene': ('avlingssvikt',),
'avlingssvikter': ('avlingssvikt',),
'avlsbuskap': ('avlsbuskap',),
'avlsbuskapen': ('avlsbuskap',),
'avlsbuskapene': ('avlsbuskap',),
'avlsbuskaper': ('avlsbuskap',),
'avlsdyr': ('avlsdyr',),
'avlsdyra': ('avlsdyr',),
'avlsdyrene': ('avlsdyr',),
'avlsdyret': ('avlsdyr',),
'avlsegg': ('avlsegg',),
'avlsegga': ('avlsegg',),
'avlseggene': ('avlsegg',),
'avlsegget': ('avlsegg',),
'avlsgris': ('avlsgris',),
'avlsgrisen': ('avlsgris',),
'avlsgrisene': ('avlsgris',),
'avlsgriser': ('avlsgris',),
'avlshest': ('avlshest',),
'avlshesten': ('avlshest',),
'avlshestene': ('avlshest',),
'avlshester': ('avlshest',),
'avlssenter': ('avlssenter',),
'avlssenteret': ('avlssenter',),
'avlssentra': ('avlssenter',),
'avlssentre': ('avlssenter',),
'avlssentrene': ('avlssenter',),
'avlssentret': ('avlssenter',),
'avlsstamme': ('avlsstamme',),
'avlsstammen': ('avlsstamme',),
'avlsstammene': ('avlsstamme',),
'avlsstammer': ('avlsstamme',),
'avlsutvalg': ('avlsutvalg',),
'avlsutvalga': ('avlsutvalg',),
'avlsutvalgene': ('avlsutvalg',),
'avlsutvalget': ('avlsutvalg',),
'avlsverdi': ('avlsverdi',),
'avlsverdien': ('avlsverdi',),
'avlsverdiene': ('avlsverdi',),
'avlsverdier': ('avlsverdi',),
'avlukka': ('avlukke',),
'avlukke': ('avlukke',),
'avlukkene': ('avlukke',),
'avlukker': ('avlukke',),
'avlukket': ('avlukke',),
'avlyd': ('avlyd',),
'avlyden': ('avlyd',),
'avlydene': ('avlyd',),
'avlyder': ('avlyd',),
'avlydstrinn': ('avlydstrinn',),
'avlydstrinna': ('avlydstrinn',),
'avlydstrinnene': ('avlydstrinn',),
'avlydstrinnet': ('avlydstrinn',),
'avlysing': ('avlysing',),
'avlysinga': ('avlysing',),
'avlysingen': ('avlysing',),
'avlysingene': ('avlysing',),
'avlysinger': ('avlysing',),
'avlysning': ('avlysning',),
'avlysninga': ('avlysning',),
'avlysningen': ('avlysning',),
'avlysningene': ('avlysning',),
'avlysninger': ('avlysning',),
'avløp': ('avløp',),
'avløpa': ('avløp',),
'avløpene': ('avløp',),
'avløpet': ('avløp',),
'avløpsgrøft': ('avløpsgrøft',),
'avløpsgrøfta': ('avløpsgrøft',),
'avløpsgrøften': ('avløpsgrøft',),
'avløpsgrøftene': ('avløpsgrøft',),
'avløpsgrøfter': ('avløpsgrøft',),
'avløpskanal': ('avløpskanal',),
'avløpskanalen': ('avløpskanal',),
'avløpskanalene': ('avløpskanal',),
'avløpskanaler': ('avløpskanal',),
'avløpsledning': ('avløpsledning',),
'avløpsledninga': ('avløpsledning',),
'avløpsledningen': ('avløpsledning',),
'avløpsledningene': ('avløpsledning',),
'avløpsledninger': ('avløpsledning',),
'avløpsrør': ('avløpsrør',),
'avløpsrøra': ('avløpsrør',),
'avløpsrørene': ('avløpsrør',),
'avløpsrøret': ('avløpsrør',),
'avløpsventil': ('avløpsventil',),
'avløpsventilen': ('avløpsventil',),
'avløpsventilene': ('avløpsventil',),
'avløpsventiler': ('avløpsventil',),
'avløser': ('avløser',),
'avløsere': ('avløser',),
'avløseren': ('avløser',),
'avløserer': ('avløser',),
'avløserne': ('avløser',),
'avløserord': ('avløserord',),
'avløserorda': ('avløserord',),
'avløserordene': ('avløserord',),
'avløserordet': ('avløserord',),
'avløsing': ('avløsing',),
'avløsinga': ('avløsing',),
'avløsingen': ('avløsing',),
'avløsingene': ('avløsing',),
'avløsinger': ('avløsing',),
'avløsingsfører': ('avløsingsfører',),
'avløsingsførere': ('avløsingsfører',),
'avløsingsføreren': ('avløsingsfører',),
'avløsingsførerer': ('avløsingsfører',),
'avløsingsførerne': ('avløsingsfører',),
'avløsingsmannskap': ('avløsingsmannskap',),
'avløsingsmannskapa': ('avløsingsmannskap',),
'avløsingsmannskapene': ('avløsingsmannskap',),
'avløsingsmannskaper': ('avløsingsmannskap',),
'avløsingsmannskapet': ('avløsingsmannskap',),
'avløsning': ('avløsning',),
'avløsninga': ('avløsning',),
'avløsningen': ('avløsning',),
'avløsningene': ('avløsning',),
'avløsninger': ('avløsning',),
'avløsningsfører': ('avløsningsfører',),
'avløsningsførere': ('avløsningsfører',),
'avløsningsføreren': ('avløsningsfører',),
'avløsningsførerer': ('avløsningsfører',),
'avløsningsførerne': ('avløsningsfører',),
'avløsningsmannskap': ('avløsningsmannskap',),
'avløsningsmannskapa': ('avløsningsmannskap',),
'avløsningsmannskapene': ('avløsningsmannskap',),
'avløsningsmannskaper': ('avløsningsmannskap',),
'avløsningsmannskapet': ('avløsningsmannskap',),
'avløyser': ('avløyser',),
'avløysere': ('avløyser',),
'avløyseren': ('avløyser',),
'avløyserer': ('avløyser',),
'avløyserne': ('avløyser',),
'avløyserord': ('avløyserord',),
'avløyserorda': ('avløyserord',),
'avløyserordene': ('avløyserord',),
'avløyserordet': ('avløyserord',),
'avløysing': ('avløysing',),
'avløysinga': ('avløysing',),
'avløysingen': ('avløysing',),
'avløysingene': ('avløysing',),
'avløysinger': ('avløysing',),
'avløysingsfører': ('avløysingsfører',),
'avløysingsførere': ('avløysingsfører',),
'avløysingsføreren': ('avløysingsfører',),
'avløysingsførerer': ('avløysingsfører',),
'avløysingsførerne': ('avløysingsfører',),
'avløysingsmannskap': ('avløysingsmannskap',),
'avløysingsmannskapa': ('avløysingsmannskap',),
'avløysingsmannskapene': ('avløysingsmannskap',),
'avløysingsmannskaper': ('avløysingsmannskap',),
'avløysingsmannskapet': ('avløysingsmannskap',),
'avmagring': ('avmagring',),
'avmagringa': ('avmagring',),
'avmagringen': ('avmagring',),
'avmagringene': ('avmagring',),
'avmagringer': ('avmagring',),
'avmagringskur': ('avmagringskur',),
'avmagringskuren': ('avmagringskur',),
'avmagringskurene': ('avmagringskur',),
'avmagringskurer': ('avmagringskur',),
'avmagringsmiddel': ('avmagringsmiddel',),
'avmagringsmiddelet': ('avmagringsmiddel',),
'avmagringsmidla': ('avmagringsmiddel',),
'avmagringsmidlene': ('avmagringsmiddel',),
'avmagringsmidler': ('avmagringsmiddel',),
'avmagringsmidlet': ('avmagringsmiddel',),
'avmakt': ('avmakt',),
'avmakta': ('avmakt',),
'avmakten': ('avmakt',),
'avmaktene': ('avmakt',),
'avmakter': ('avmakt',),
'avmaktsfølelse': ('avmaktsfølelse',),
'avmaktsfølelsen': ('avmaktsfølelse',),
'avmaktsfølelsene': ('avmaktsfølelse',),
'avmaktsfølelser': ('avmaktsfølelse',),
'avmaktskjensla': ('avmaktskjensle',),
'avmaktskjensle': ('avmaktskjensle',),
'avmaktskjenslen': ('avmaktskjensle',),
'avmaktskjenslene': ('avmaktskjensle',),
'avmaktskjensler': ('avmaktskjensle',),
'avmarsj': ('avmarsj',),
'avmarsjen': ('avmarsj',),
'avmarsjene': ('avmarsj',),
'avmarsjer': ('avmarsj',),
'avmytologisering': ('avmytologisering',),
'avmytologiseringa': ('avmytologisering',),
'avmytologiseringen': ('avmytologisering',),
'avmytologiseringene': ('avmytologisering',),
'avmytologiseringer': ('avmytologisering',),
'avokado': ('avokado',),
'avokadoen': ('avokado',),
'avokadoene': ('avokado',),
'avokadoer': ('avokado',),
'avokadofrukt': ('avokadofrukt',),
'avokadofrukta': ('avokadofrukt',),
'avokadofrukten': ('avokadofrukt',),
'avokadofruktene': ('avokadofrukt',),
'avokadofrukter': ('avokadofrukt',),
'avokadopæra': ('avokadopære',),
'avokadopære': ('avokadopære',),
'avokadopæren': ('avokadopære',),
'avokadopærene': ('avokadopære',),
'avokadopærer': ('avokadopære',),
'avokadotre': ('avokadotre',),
'avokadotrea': ('avokadotre',),
'avokadotreet': ('avokadotre',),
'avokadotrær': ('avokadotre',),
'avokadotrærne': ('avokadotre',),
'avregning': ('avregning',),
'avregninga': ('avregning',),
'avregningen': ('avregning',),
'avregningene': ('avregning',),
'avregninger': ('avregning',),
'avregning': ('avregning',),
'avregninga': ('avregning',),
'avregningen': ('avregning',),
'avregningene': ('avregning',),
'avregninger': ('avregning',),
'avregningskontor': ('avregningskontor',),
'avregningskontora': ('avregningskontor',),
'avregningskontorene': ('avregningskontor',),
'avregningskontorer': ('avregningskontor',),
'avregningskontoret': ('avregningskontor',),
'avregningskontor': ('avregningskontor',),
'avregningskontora': ('avregningskontor',),
'avregningskontorene': ('avregningskontor',),
'avregningskontorer': ('avregningskontor',),
'avregningskontoret': ('avregningskontor',),
'avregningsordning': ('avregningsordning',),
'avregningsordninga': ('avregningsordning',),
'avregningsordningen': ('avregningsordning',),
'avregningsordningene': ('avregningsordning',),
'avregningsordninger': ('avregningsordning',),
'avregningsordning': ('avregningsordning',),
'avregningsordninga': ('avregningsordning',),
'avregningsordningen': ('avregningsordning',),
'avregningsordningene': ('avregningsordning',),
'avregningsordninger': ('avregningsordning',),
'avreisa': ('avreise',),
'avreise': ('avreise',),
'avreisen': ('avreise',),
'avreisene': ('avreise',),
'avreiser': ('avreise',),
'avreisedato': ('avreisedato',),
'avreisedatoen': ('avreisedato',),
'avreisedatoene': ('avreisedato',),
'avreisedatoer': ('avreisedato',),
'avrekning': ('avrekning',),
'avrekninga': ('avrekning',),
'avrekningen': ('avrekning',),
'avrekningene': ('avrekning',),
'avrekninger': ('avrekning',),
'avrekning': ('avrekning',),
'avrekninga': ('avrekning',),
'avrekningen': ('avrekning',),
'avrekningene': ('avrekning',),
'avrekninger': ('avrekning',),
'avrekningskontor': ('avrekningskontor',),
'avrekningskontora': ('avrekningskontor',),
'avrekningskontorene': ('avrekningskontor',),
'avrekningskontorer': ('avrekningskontor',),
'avrekningskontoret': ('avrekningskontor',),
'avrekningskontor': ('avrekningskontor',),
'avrekningskontora': ('avrekningskontor',),
'avrekningskontorene': ('avrekningskontor',),
'avrekningskontorer': ('avrekningskontor',),
'avrekningskontoret': ('avrekningskontor',),
'avrekningsordning': ('avrekningsordning',),
'avrekningsordninga': ('avrekningsordning',),
'avrekningsordningen': ('avrekningsordning',),
'avrekningsordningene': ('avrekningsordning',),
'avrekningsordninger': ('avrekningsordning',),
'avrekningsordning': ('avrekningsordning',),
'avrekningsordninga': ('avrekningsordning',),
'avrekningsordningen': ('avrekningsordning',),
'avrekningsordningene': ('avrekningsordning',),
'avrekningsordninger': ('avrekningsordning',),
'avrettelse': ('avrettelse',),
'avrettelsen': ('avrettelse',),
'avrettelsene': ('avrettelse',),
'avrettelser': ('avrettelse',),
'avretterhøvel': ('avretterhøvel',),
'avretterhøvelen': ('avretterhøvel',),
'avretterhøvlene': ('avretterhøvel',),
'avretterhøvler': ('avretterhøvel',),
'avrettermasse': ('avrettermasse',),
'avrettermassen': ('avrettermasse',),
'avrettermassene': ('avrettermasse',),
'avrettermasser': ('avrettermasse',),
'avretting': ('avretting',),
'avrettinga': ('avretting',),
'avrettingen': ('avretting',),
'avrettingene': ('avretting',),
'avrettinger': ('avretting',),
'avriss': ('avriss',),
'avrissa': ('avriss',),
'avrissene': ('avriss',),
'avrisset': ('avriss',),
'avriving': ('avriving',),
'avrivinga': ('avriving',),
'avrivingen': ('avriving',),
'avrivingene': ('avriving',),
'avrivinger': ('avriving',),
'avriving': ('avriving',),
'avrivinga': ('avriving',),
'avrivingen': ('avriving',),
'avrivingene': ('avriving',),
'avrivinger': ('avriving',),
'avrivingsblokk': ('avrivingsblokk',),
'avrivingsblokka': ('avrivingsblokk',),
'avrivingsblokken': ('avrivingsblokk',),
'avrivingsblokkene': ('avrivingsblokk',),
'avrivingsblokker': ('avrivingsblokk',),
'avrivingskalender': ('avrivingskalender',),
'avrivingskalendere': ('avrivingskalender',),
'avrivingskalenderen': ('avrivingskalender',),
'avrivingskalenderer': ('avrivingskalender',),
'avrivingskalenderne': ('avrivingskalender',),
'avrivingskalendre': ('avrivingskalender',),
'avrivingskalendrene': ('avrivingskalender',),
'avrivingskalendrer': ('avrivingskalender',),
'avrivning': ('avrivning',),
'avrivninga': ('avrivning',),
'avrivningen': ('avrivning',),
'avrivningene': ('avrivning',),
'avrivninger': ('avrivning',),
'avrivning': ('avrivning',),
'avrivninga': ('avrivning',),
'avrivningen': ('avrivning',),
'avrivningene': ('avrivning',),
'avrivninger': ('avrivning',),
'avrivningsblokk': ('avrivningsblokk',),
'avrivningsblokka': ('avrivningsblokk',),
'avrivningsblokken': ('avrivningsblokk',),
'avrivningsblokkene': ('avrivningsblokk',),
'avrivningsblokker': ('avrivningsblokk',),
'avrivningskalender': ('avrivningskalender',),
'avrivningskalendere': ('avrivningskalender',),
'avrivningskalenderen': ('avrivningskalender',),
'avrivningskalenderer': ('avrivningskalender',),
'avrivningskalenderne': ('avrivningskalender',),
'avrivningskalendre': ('avrivningskalender',),
'avrivningskalendrene': ('avrivningskalender',),
'avrivningskalendrer': ('avrivningskalender',),
'avrusing': ('avrusing',),
'avrusinga': ('avrusing',),
'avrusingen': ('avrusing',),
'avrusingene': ('avrusing',),
'avrusinger': ('avrusing',),
'avrusingsstasjon': ('avrusingsstasjon',),
'avrusingsstasjonen': ('avrusingsstasjon',),
'avrusingsstasjonene': ('avrusingsstasjon',),
'avrusingsstasjoner': ('avrusingsstasjon',),
'avrusning': ('avrusning',),
'avrusninga': ('avrusning',),
'avrusningen': ('avrusning',),
'avrusningene': ('avrusning',),
'avrusninger': ('avrusning',),
'avrusningsstasjon': ('avrusningsstasjon',),
'avrusningsstasjonen': ('avrusningsstasjon',),
'avrusningsstasjonene': ('avrusningsstasjon',),
'avrusningsstasjoner': ('avrusningsstasjon',),
'avrusting': ('avrusting',),
'avrustinga': ('avrusting',),
'avrustingen': ('avrusting',),
'avrustingene': ('avrusting',),
'avrustinger': ('avrusting',),
'avrustingsavtale': ('avrustingsavtale',),
'avrustingsavtalen': ('avrustingsavtale',),
'avrustingsavtalene': ('avrustingsavtale',),
'avrustingsavtaler': ('avrustingsavtale',),
'avrustingsforslag': ('avrustingsforslag',),
'avrustingsforslaga': ('avrustingsforslag',),
'avrustingsforslagene': ('avrustingsforslag',),
'avrustingsforslaget': ('avrustingsforslag',),
'avrustingspolitikk': ('avrustingspolitikk',),
'avrustingspolitikken': ('avrustingspolitikk',),
'avrustingspolitikkene': ('avrustingspolitikk',),
'avrustingspolitikker': ('avrustingspolitikk',),
'avrustning': ('avrustning',),
'avrustninga': ('avrustning',),
'avrustningen': ('avrustning',),
'avrustningene': ('avrustning',),
'avrustninger': ('avrustning',),
'avrustningsavtale': ('avrustningsavtale',),
'avrustningsavtalen': ('avrustningsavtale',),
'avrustningsavtalene': ('avrustningsavtale',),
'avrustningsavtaler': ('avrustningsavtale',),
'avrustningsforslag': ('avrustningsforslag',),
'avrustningsforslaga': ('avrustningsforslag',),
'avrustningsforslagene': ('avrustningsforslag',),
'avrustningsforslaget': ('avrustningsforslag',),
'avrustningspolitikk': ('avrustningspolitikk',),
'avrustningspolitikken': ('avrustningspolitikk',),
'avrustningspolitikkene': ('avrustningspolitikk',),
'avrustningspolitikker': ('avrustningspolitikk',),
'avrøysting': ('avrøysting',),
'avrøystinga': ('avrøysting',),
'avrøystingen': ('avrøysting',),
'avrøystingene': ('avrøysting',),
'avrøystinger': ('avrøysting',),
'avsats': ('avsats',),
'avsatsen': ('avsats',),
'avsatsene': ('avsats',),
'avsatser': ('avsats',),
'avsavn': ('avsavn',),
'avsavna': ('avsavn',),
'avsavnene': ('avsavn',),
'avsavnet': ('avsavn',),
'avsavnsgodtgjørelse': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelsen': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelsene': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelser': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjøring': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringa': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringen': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringene': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringer': ('avsavnsgodtgjøring',),
'avsender': ('avsender',),
'avsendere': ('avsender',),
'avsenderen': ('avsender',),
'avsenderer': ('avsender',),
'avsenderne': ('avsender',),
'avsenderadressa': ('avsenderadresse',),
'avsenderadresse': ('avsenderadresse',),
'avsenderadressen': ('avsenderadresse',),
'avsenderadressene': ('avsenderadresse',),
'avsenderadresser': ('avsenderadresse',),
'avsetning': ('avsetning',),
'avsetninga': ('avsetning',),
'avsetningen': ('avsetning',),
'avsetningene': ('avsetning',),
'avsetninger': ('avsetning',),
'avsetningskonti': ('avsetningskonto',),
'avsetningskontiene': ('avsetningskonto',),
'avsetningskonto': ('avsetningskonto',),
'avsetningskontoen': ('avsetningskonto',),
'avsetningskontoene': ('avsetningskonto',),
'avsetningskontoer': ('avsetningskonto',),
'avsetningsmarked': ('avsetningsmarked',),
'avsetningsmarkeda': ('avsetningsmarked',),
'avsetningsmarkedene': ('avsetningsmarked',),
'avsetningsmarkeder': ('avsetningsmarked',),
'avsetningsmarkedet': ('avsetningsmarked',),
'avsetningsmarknad': ('avsetningsmarknad',),
'avsetningsmarknaden': ('avsetningsmarknad',),
'avsetningsmarknadene': ('avsetningsmarknad',),
'avsetningsmarknader': ('avsetningsmarknad',),
'avsetningsmulighet': ('avsetningsmulighet',),
'avsetningsmuligheta': ('avsetningsmulighet',),
'avsetningsmuligheten': ('avsetningsmulighet',),
'avsetningsmulighetene': ('avsetningsmulighet',),
'avsetningsmuligheter': ('avsetningsmulighet',),
'avsetningsområda': ('avsetningsområde',),
'avsetningsområde': ('avsetningsområde',),
'avsetningsområdene': ('avsetningsområde',),
'avsetningsområder': ('avsetningsområde',),
'avsetningsområdet': ('avsetningsområde',),
'avsetningsvanske': ('avsetningsvanske',),
'avsetningsvansken': ('avsetningsvanske',),
'avsetningsvanskene': ('avsetningsvanske',),
'avsetningsvansker': ('avsetningsvanske',),
'avsetningsvanskelighet': ('avsetningsvanskelighet',),
'avsetningsvanskeligheta': ('avsetningsvanskelighet',),
'avsetningsvanskeligheten': ('avsetningsvanskelighet',),
'avsetningsvanskelighetene': ('avsetningsvanskelighet',),
'avsetningsvanskeligheter': ('avsetningsvanskelighet',),
'avsettelse': ('avsettelse',),
'avsettelsen': ('avsettelse',),
'avsettelsene': ('avsettelse',),
'avsettelser': ('avsettelse',),
'avsig': ('avsig',),
'avsiga': ('avsig',),
'avsigene': ('avsig',),
'avsiget': ('avsig',),
'avsinn': ('avsinn',),
'avsinna': ('avsinn',),
'avsinnene': ('avsinn',),
'avsinnet': ('avsinn',),
'avskaffelse': ('avskaffelse',),
'avskaffelsen': ('avskaffelse',),
'avskaffelsene': ('avskaffelse',),
'avskaffelser': ('avskaffelse',),
'avskalling': ('avskalling',),
'avskallinga': ('avskalling',),
'avskallingen': ('avskalling',),
'avskallingene': ('avskalling',),
'avskallinger': ('avskalling',),
'avskiper': ('avskiper',),
'avskipere': ('avskiper',),
'avskiperen': ('avskiper',),
'avskiperer': ('avskiper',),
'avskiperne': ('avskiper',),
'avskiping': ('avskiping',),
'avskipinga': ('avskiping',),
'avskipingen': ('avskiping',),
'avskipingene': ('avskiping',),
'avskipinger': ('avskiping',),
'avskipingshamn': ('avskipingshamn',),
'avskipingshamna': ('avskipingshamn',),
'avskipingshamnen': ('avskipingshamn',),
'avskipingshamnene': ('avskipingshamn',),
'avskipingshamner': ('avskipingshamn',),
'avskipingshavn': ('avskipingshavn',),
'avskipingshavna': ('avskipingshavn',),
'avskipingshavnen': ('avskipingshavn',),
'avskipingshavnene': ('avskipingshavn',),
'avskipingshavner': ('avskipingshavn',),
'avskipning': ('avskipning',),
'avskipninga': ('avskipning',),
'avskipningen': ('avskipning',),
'avskipningene': ('avskipning',),
'avskipninger': ('avskipning',),
'avskipningshamn': ('avskipningshamn',),
'avskipningshamna': ('avskipningshamn',),
'avskipningshamnen': ('avskipningshamn',),
'avskipningshamnene': ('avskipningshamn',),
'avskipningshamner': ('avskipningshamn',),
'avskipningshavn': ('avskipningshavn',),
'avskipningshavna': ('avskipningshavn',),
'avskipningshavnen': ('avskipningshavn',),
'avskipningshavnene': ('avskipningshavn',),
'avskipningshavner': ('avskipningshavn',),
'avskjed': ('avskjed',),
'avskjeden': ('avskjed',),
'avskjedene': ('avskjed',),
'avskjeder': ('avskjed',),
'avskjedigelse': ('avskjedigelse',),
'avskjedigelsen': ('avskjedigelse',),
'avskjedigelsene': ('avskjedigelse',),
'avskjedigelser': ('avskjedigelse',),
'avskjedsfest': ('avskjedsfest',),
'avskjedsfesten': ('avskjedsfest',),
'avskjedsfestene': ('avskjedsfest',),
'avskjedsfester': ('avskjedsfest',),
'avskjedsstund': ('avskjedsstund',),
'avskjedsstunda': ('avskjedsstund',),
'avskjedsstunden': ('avskjedsstund',),
'avskjedsstundene': ('avskjedsstund',),
'avskjedsstunder': ('avskjedsstund',),
'avskjedssøknad': ('avskjedssøknad',),
'avskjedssøknaden': ('avskjedssøknad',),
'avskjedssøknadene': ('avskjedssøknad',),
'avskjedssøknader': ('avskjedssøknad',),
'avskjedsvisitt': ('avskjedsvisitt',),
'avskjedsvisitten': ('avskjedsvisitt',),
'avskjedsvisittene': ('avskjedsvisitt',),
'avskjedsvisitter': ('avskjedsvisitt',),
'avskjær': ('avskjær',),
'avskjæra': ('avskjær',),
'avskjærene': ('avskjær',),
'avskjæret': ('avskjær',),
'avskjæring': ('avskjæring',),
'avskjæringen': ('avskjæring',),
'avskjæringene': ('avskjæring',),
'avskjæringer': ('avskjæring',),
'avskjæring': ('avskjæring',),
'avskjæringa': ('avskjæring',),
'avskjæringen': ('avskjæring',),
'avskjæringene': ('avskjæring',),
'avskjæringer': ('avskjæring',),
'avskjæringsjager': ('avskjæringsjager',),
'avskjæringsjagere': ('avskjæringsjager',),
'avskjæringsjageren': ('avskjæringsjager',),
'avskjæringsjagerer': ('avskjæringsjager',),
'avskjæringsjagerne': ('avskjæringsjager',),
'avskoging': ('avskoging',),
'avskoginga': ('avskoging',),
'avskogingen': ('avskoging',),
'avskogingene': ('avskoging',),
'avskoginger': ('avskoging',),
'avskrekk': ('avskrekk',),
'avskrekken': ('avskrekk',),
'avskrekkene': ('avskrekk',),
'avskrekker': ('avskrekk',),
'avskrekkingsvåpen': ('avskrekkingsvåpen',),
'avskrekkingsvåpenet': ('avskrekkingsvåpen',),
'avskrekkingsvåpna': ('avskrekkingsvåpen',),
'avskrekkingsvåpnene': ('avskrekkingsvåpen',),
'avskrift': ('avskrift',),
'avskrifta': ('avskrift',),
'avskriften': ('avskrift',),
'avskriftene': ('avskrift',),
'avskrifter': ('avskrift',),
'avskriver': ('avskriver',),
'avskrivere': ('avskriver',),
'avskriveren': ('avskriver',),
'avskriverer': ('avskriver',),
'avskriverne': ('avskriver',),
'avskriverarbeid': ('avskriverarbeid',),
'avskriverarbeida': ('avskriverarbeid',),
'avskriverarbeidene': ('avskriverarbeid',),
'avskriverarbeider': ('avskriverarbeid',),
'avskriverarbeidet': ('avskriverarbeid',),
'avskriverfeil': ('avskriverfeil',),
'avskriverfeilen': ('avskriverfeil',),
'avskriverfeilene': ('avskriverfeil',),
'avskriving': ('avskriving',),
'avskrivinga': ('avskriving',),
'avskrivingen': ('avskriving',),
'avskrivingene': ('avskriving',),
'avskrivinger': ('avskriving',),
'avskrivingsbidrag': ('avskrivingsbidrag',),
'avskrivingsbidraga': ('avskrivingsbidrag',),
'avskrivingsbidragene': ('avskrivingsbidrag',),
'avskrivingsbidraget': ('avskrivingsbidrag',),
'avskrivingsbyrå': ('avskrivingsbyrå',),
'avskrivingsbyråa': ('avskrivingsbyrå',),
'avskrivingsbyråene': ('avskrivingsbyrå',),
'avskrivingsbyråer': ('avskrivingsbyrå',),
'avskrivingsbyrået': ('avskrivingsbyrå',),
'avskrivingskonti': ('avskrivingskonto',),
'avskrivingskontiene': ('avskrivingskonto',),
'avskrivingskonto': ('avskrivingskonto',),
'avskrivingskontoen': ('avskrivingskonto',),
'avskrivingskontoene': ('avskrivingskonto',),
'avskrivingskontoer': ('avskrivingskonto',),
'avskrivingskontor': ('avskrivingskontor',),
'avskrivingskontora': ('avskrivingskontor',),
'avskrivingskontorene': ('avskrivingskontor',),
'avskrivingskontorer': ('avskrivingskontor',),
'avskrivingskontoret': ('avskrivingskontor',),
'avskrivning': ('avskrivning',),
'avskrivninga': ('avskrivning',),
'avskrivningen': ('avskrivning',),
'avskrivningene': ('avskrivning',),
'avskrivninger': ('avskrivning',),
'avskrivningsbidrag': ('avskrivningsbidrag',),
'avskrivningsbidraga': ('avskrivningsbidrag',),
'avskrivningsbidragene': ('avskrivningsbidrag',),
'avskrivningsbidraget': ('avskrivningsbidrag',),
'avskrivningsbyrå': ('avskrivningsbyrå',),
'avskrivningsbyråa': ('avskrivningsbyrå',),
'avskrivningsbyråene': ('avskrivningsbyrå',),
'avskrivningsbyråer': ('avskrivningsbyrå',),
'avskrivningsbyrået': ('avskrivningsbyrå',),
'avskrivningskonti': ('avskrivningskonto',),
'avskrivningskontiene': ('avskrivningskonto',),
'avskrivningskonto': ('avskrivningskonto',),
'avskrivningskontoen': ('avskrivningskonto',),
'avskrivningskontoene': ('avskrivningskonto',),
'avskrivningskontoer': ('avskrivningskonto',),
'avskrivningskontor': ('avskrivningskontor',),
'avskrivningskontora': ('avskrivningskontor',),
'avskrivningskontorene': ('avskrivningskontor',),
'avskrivningskontorer': ('avskrivningskontor',),
'avskrivningskontoret': ('avskrivningskontor',),
'avskum': ('avskum',),
'avskumma': ('avskum',),
'avskummene': ('avskum',),
'avskummet': ('avskum',),
'avsky': ('avsky',),
'avskyen': ('avsky',),
'avskyene': ('avsky',),
'avskyer': ('avsky',),
'avskygning': ('avskygning',),
'avskygninga': ('avskygning',),
'avskygningen': ('avskygning',),
'avskygningene': ('avskygning',),
'avskygninger': ('avskygning',),
'avskyresolusjon': ('avskyresolusjon',),
'avskyresolusjonen': ('avskyresolusjon',),
'avskyresolusjonene': ('avskyresolusjon',),
'avskyresolusjoner': ('avskyresolusjon',),
'avslag': ('avslag',),
'avslaga': ('avslag',),
'avslagene': ('avslag',),
'avslaget': ('avslag',),
'avslapning': ('avslapning',),
'avslapninga': ('avslapning',),
'avslapningen': ('avslapning',),
'avslapningene': ('avslapning',),
'avslapninger': ('avslapning',),
'avslapningsgymnastikk': ('avslapningsgymnastikk',),
'avslapningsgymnastikken': ('avslapningsgymnastikk',),
'avslapningsgymnastikkene': ('avslapningsgymnastikk',),
'avslapningsgymnastikker': ('avslapningsgymnastikk',),
'avslapningsterapi': ('avslapningsterapi',),
'avslapningsterapien': ('avslapningsterapi',),
'avslapningsterapiene': ('avslapningsterapi',),
'avslapningsterapier': ('avslapningsterapi',),
'avslapningsøvelse': ('avslapningsøvelse',),
'avslapningsøvelsen': ('avslapningsøvelse',),
'avslapningsøvelsene': ('avslapningsøvelse',),
'avslapningsøvelser': ('avslapningsøvelse',),
'avslapningsøving': ('avslapningsøving',),
'avslapningsøvinga': ('avslapningsøving',),
'avslapningsøvingen': ('avslapningsøving',),
'avslapningsøvingene': ('avslapningsøving',),
'avslapningsøvinger': ('avslapningsøving',),
'avslapping': ('avslapping',),
'avslappinga': ('avslapping',),
'avslappingen': ('avslapping',),
'avslappingene': ('avslapping',),
'avslappinger': ('avslapping',),
'avslappingsgymnastikk': ('avslappingsgymnastikk',),
'avslappingsgymnastikken': ('avslappingsgymnastikk',),
'avslappingsgymnastikkene': ('avslappingsgymnastikk',),
'avslappingsgymnastikker': ('avslappingsgymnastikk',),
'avslappingsterapi': ('avslappingsterapi',),
'avslappingsterapien': ('avslappingsterapi',),
'avslappingsterapiene': ('avslappingsterapi',),
'avslappingsterapier': ('avslappingsterapi',),
'avslappingsøvelse': ('avslappingsøvelse',),
'avslappingsøvelsen': ('avslappingsøvelse',),
'avslappingsøvelsene': ('avslappingsøvelse',),
'avslappingsøvelser': ('avslappingsøvelse',),
'avslappingsøving': ('avslappingsøving',),
'avslappingsøvinga': ('avslappingsøving',),
'avslappingsøvingen': ('avslappingsøving',),
'avslappingsøvingene': ('avslappingsøving',),
'avslappingsøvinger': ('avslappingsøving',),
'avslutning': ('avslutning',),
'avslutninga': ('avslutning',),
'avslutningen': ('avslutning',),
'avslutningene': ('avslutning',),
'avslutninger': ('avslutning',),
'avslutningsfest': ('avslutningsfest',),
'avslutningsfesten': ('avslutningsfest',),
'avslutningsfestene': ('avslutningsfest',),
'avslutningsfester': ('avslutningsfest',),
'avslutningstale': ('avslutningstale',),
'avslutningstalen': ('avslutningstale',),
'avslutningstalene': ('avslutningstale',),
'avslutningstaler': ('avslutningstale',),
'avsløring': ('avsløring',),
'avsløringa': ('avsløring',),
'avsløringen': ('avsløring',),
'avsløringene': ('avsløring',),
'avsløringer': ('avsløring',),
'avsmak': ('avsmak',),
'avsmaken': ('avsmak',),
'avsmakene': ('avsmak',),
'avsmaker': ('avsmak',),
'avsnitt': ('avsnitt',),
'avsnitta': ('avsnitt',),
'avsnittene': ('avsnitt',),
'avsnittet': ('avsnitt',),
'avsnittsmarkering': ('avsnittsmarkering',),
'avsnittsmarkeringa': ('avsnittsmarkering',),
'avsnittsmarkeringen': ('avsnittsmarkering',),
'avsnittsmarkeringene': ('avsnittsmarkering',),
'avsnittsmarkeringer': ('avsnittsmarkering',),
'avsnittssjef': ('avsnittssjef',),
'avsnittssjefen': ('avsnittssjef',),
'avsnittssjefene': ('avsnittssjef',),
'avsnittssjefer': ('avsnittssjef',),
'avspark': ('avspark',),
'avsparka': ('avspark',),
'avsparkene': ('avspark',),
'avsparket': ('avspark',),
'avspelling': ('avspelling',),
'avspellinga': ('avspelling',),
'avspellingen': ('avspelling',),
'avspellingene': ('avspelling',),
'avspellinger': ('avspelling',),
'avspellingsrom': ('avspellingsrom',),
'avspellingsromma': ('avspellingsrom',),
'avspellingsrommene': ('avspellingsrom',),
'avspellingsrommet': ('avspellingsrom',),
'avspenning': ('avspenning',),
'avspenninga': ('avspenning',),
'avspenningen': ('avspenning',),
'avspenningene': ('avspenning',),
'avspenninger': ('avspenning',),
'avspenningsframstøt': ('avspenningsframstøt',),
'avspenningsframstøta': ('avspenningsframstøt',),
'avspenningsframstøtene': ('avspenningsframstøt',),
'avspenningsframstøtet': ('avspenningsframstøt',),
'avspenningsframstøyt': ('avspenningsframstøyt',),
'avspenningsframstøyten': ('avspenningsframstøyt',),
'avspenningsframstøytene': ('avspenningsframstøyt',),
'avspenningsframstøyter': ('avspenningsframstøyt',),
'avspenningsgymnastikk': ('avspenningsgymnastikk',),
'avspenningsgymnastikken': ('avspenningsgymnastikk',),
'avspenningsgymnastikkene': ('avspenningsgymnastikk',),
'avspenningsgymnastikker': ('avspenningsgymnastikk',),
'avspenningspolitikk': ('avspenningspolitikk',),
'avspenningspolitikken': ('avspenningspolitikk',),
'avspenningspolitikkene': ('avspenningspolitikk',),
'avspenningspolitikker': ('avspenningspolitikk',),
'avsperring': ('avsperring',),
'avsperringa': ('avsperring',),
'avsperringen': ('avsperring',),
'avsperringene': ('avsperring',),
'avsperringer': ('avsperring',),
'avspilling': ('avspilling',),
'avspillinga': ('avspilling',),
'avspillingen': ('avspilling',),
'avspillingene': ('avspilling',),
'avspillinger': ('avspilling',),
'avspillingsrom': ('avspillingsrom',),
'avspillingsromma': ('avspillingsrom',),
'avspillingsrommene': ('avspillingsrom',),
'avspillingsrommet': ('avspillingsrom',),
'avsporing': ('avsporing',),
'avsporinga': ('avsporing',),
'avsporingen': ('avsporing',),
'avsporingene': ('avsporing',),
'avsporinger': ('avsporing',),
'avstamning': ('avstamning',),
'avstamninga': ('avstamning',),
'avstamningen': ('avstamning',),
'avstamningene': ('avstamning',),
'avstamninger': ('avstamning',),
'avstamningslæra': ('avstamningslære',),
'avstamningslære': ('avstamningslære',),
'avstamningslæren': ('avstamningslære',),
'avstamningslærene': ('avstamningslære',),
'avstamningslærer': ('avstamningslære',),
'avstand': ('avstand',),
'avstanden': ('avstand',),
'avstandene': ('avstand',),
'avstander': ('avstand',),
'avstandsbedømmelse': ('avstandsbedømmelse',),
'avstandsbedømmelsen': ('avstandsbedømmelse',),
'avstandsbedømmelsene': ('avstandsbedømmelse',),
'avstandsbedømmelser': ('avstandsbedømmelse',),
'avstandsinnstilling': ('avstandsinnstilling',),
'avstandsinnstillinga': ('avstandsinnstilling',),
'avstandsinnstillingen': ('avstandsinnstilling',),
'avstandsinnstillingene': ('avstandsinnstilling',),
'avstandsinnstillinger': ('avstandsinnstilling',),
'avstandsmåler': ('avstandsmåler',),
'avstandsmålere': ('avstandsmåler',),
'avstandsmåleren': ('avstandsmåler',),
'avstandsmålerer': ('avstandsmåler',),
'avstandsmålerne': ('avstandsmåler',),
'avstandtagen': ('avstandtagen',),
'avstandtaing': ('avstandtaing',),
'avstandtainga': ('avstandtaing',),
'avstandtaingen': ('avstandtaing',),
'avstandtaingene': ('avstandtaing',),
'avstandtainger': ('avstandtaing',),
'avstandtaken': ('avstandtaken',),
'avstandtaking': ('avstandtaking',),
'avstandtakinga': ('avstandtaking',),
'avstandtakingen': ('avstandtaking',),
'avstandtakingene': ('avstandtaking',),
'avstandtakinger': ('avstandtaking',),
'avstemning': ('avstemning',),
'avstemninga': ('avstemning',),
'avstemningen': ('avstemning',),
'avstemningene': ('avstemning',),
'avstemninger': ('avstemning',),
'avstemningsmåte': ('avstemningsmåte',),
'avstemningsmåten': ('avstemningsmåte',),
'avstemningsmåtene': ('avstemningsmåte',),
'avstemningsmåter': ('avstemningsmåte',),
'avstemningsresultat': ('avstemningsresultat',),
'avstemningsresultata': ('avstemningsresultat',),
'avstemningsresultatene': ('avstemningsresultat',),
'avstemningsresultater': ('avstemningsresultat',),
'avstemningsresultatet': ('avstemningsresultat',),
'avstenging': ('avstenging',),
'avstenginga': ('avstenging',),
'avstengingen': ('avstenging',),
'avstengingene': ('avstenging',),
'avstenginger': ('avstenging',),
'avstengingskran': ('avstengingskran',),
'avstengingskrana': ('avstengingskran',),
'avstengingskranen': ('avstengingskran',),
'avstengingskranene': ('avstengingskran',),
'avstengingskraner': ('avstengingskran',),
'avstengingsventil': ('avstengingsventil',),
'avstengingsventilen': ('avstengingsventil',),
'avstengingsventilene': ('avstengingsventil',),
'avstengingsventiler': ('avstengingsventil',),
'avstengning': ('avstengning',),
'avstengninga': ('avstengning',),
'avstengningen': ('avstengning',),
'avstengningene': ('avstengning',),
'avstengninger': ('avstengning',),
'avstengningskran': ('avstengningskran',),
'avstengningskrana': ('avstengningskran',),
'avstengningskranen': ('avstengningskran',),
'avstengningskranene': ('avstengningskran',),
'avstengningskraner': ('avstengningskran',),
'avstengningsventil': ('avstengningsventil',),
'avstengningsventilen': ('avstengningsventil',),
'avstengningsventilene': ('avstengningsventil',),
'avstengningsventiler': ('avstengningsventil',),
'avstiging': ('avstiging',),
'avstiginga': ('avstiging',),
'avstigingen': ('avstiging',),
'avstigingene': ('avstiging',),
'avstiginger': ('avstiging',),
'avstigingsperrong': ('avstigingsperrong',),
'avstigingsperrongen': ('avstigingsperrong',),
'avstigingsperrongene': ('avstigingsperrong',),
'avstigingsperronger': ('avstigingsperrong',),
'avstigingstrapp': ('avstigingstrapp',),
'avstigingstrappa': ('avstigingstrapp',),
'avstigingstrappen': ('avstigingstrapp',),
'avstigingstrappene': ('avstigingstrapp',),
'avstigingstrapper': ('avstigingstrapp',),
'avstigning': ('avstigning',),
'avstigninga': ('avstigning',),
'avstigningen': ('avstigning',),
'avstigningene': ('avstigning',),
'avstigninger': ('avstigning',),
'avstigningsperrong': ('avstigningsperrong',),
'avstigningsperrongen': ('avstigningsperrong',),
'avstigningsperrongene': ('avstigningsperrong',),
'avstigningsperronger': ('avstigningsperrong',),
'avstigningstrapp': ('avstigningstrapp',),
'avstigningstrappa': ('avstigningstrapp',),
'avstigningstrappen': ('avstigningstrapp',),
'avstigningstrappene': ('avstigningstrapp',),
'avstigningstrapper': ('avstigningstrapp',),
'avstikker': ('avstikker',),
'avstikkere': ('avstikker',),
'avstikkeren': ('avstikker',),
'avstikkerer': ('avstikker',),
'avstikkerne': ('avstikker',),
'avstiver': ('avstiver',),
'avstivere': ('avstiver',),
'avstiveren': ('avstiver',),
'avstiverer': ('avstiver',),
'avstiverne': ('avstiver',),
'avstiving': ('avstiving',),
'avstivinga': ('avstiving',),
'avstivingen': ('avstiving',),
'avstivingene': ('avstiving',),
'avstivinger': ('avstiving',),
'avstivingsbjelke': ('avstivingsbjelke',),
'avstivingsbjelken': ('avstivingsbjelke',),
'avstivingsbjelkene': ('avstivingsbjelke',),
'avstivingsbjelker': ('avstivingsbjelke',),
'avstivingsplata': ('avstivingsplate',),
'avstivingsplate': ('avstivingsplate',),
'avstivingsplaten': ('avstivingsplate',),
'avstivingsplatene': ('avstivingsplate',),
'avstivingsplater': ('avstivingsplate',),
'avstivning': ('avstivning',),
'avstivninga': ('avstivning',),
'avstivningen': ('avstivning',),
'avstivningene': ('avstivning',),
'avstivninger': ('avstivning',),
'avstivningsbjelke': ('avstivningsbjelke',),
'avstivningsbjelken': ('avstivningsbjelke',),
'avstivningsbjelkene': ('avstivningsbjelke',),
'avstivningsbjelker': ('avstivningsbjelke',),
'avstivningsplata': ('avstivningsplate',),
'avstivningsplate': ('avstivningsplate',),
'avstivningsplaten': ('avstivningsplate',),
'avstivningsplatene': ('avstivningsplate',),
'avstivningsplater': ('avstivningsplate',),
'avstraffelse': ('avstraffelse',),
'avstraffelsen': ('avstraffelse',),
'avstraffelsene': ('avstraffelse',),
'avstraffelser': ('avstraffelse',),
'avstøpning': ('avstøpning',),
'avstøpninga': ('avstøpning',),
'avstøpningen': ('avstøpning',),
'avstøpningene': ('avstøpning',),
'avstøpninger': ('avstøpning',),
'avsøker': ('avsøker',),
'avsøkere': ('avsøker',),
'avsøkeren': ('avsøker',),
'avsøkerer': ('avsøker',),
'avsøkerne': ('avsøker',),
'avtak': ('avtak',),
'avtaka': ('avtak',),
'avtakene': ('avtak',),
'avtaket': ('avtak',),
'avtaker': ('avtaker',),
'avtakere': ('avtaker',),
'avtakeren': ('avtaker',),
'avtakerer': ('avtaker',),
'avtakerne': ('avtaker',),
'avtakerland': ('avtakerland',),
'avtakerlanda': ('avtakerland',),
'avtakerlandene': ('avtakerland',),
'avtakerlandet': ('avtakerland',),
'avtale': ('avtale',),
'avtalen': ('avtale',),
'avtalene': ('avtale',),
'avtaler': ('avtale',),
'avtalebrott': ('avtalebrott',),
'avtalebrotta': ('avtalebrott',),
'avtalebrottene': ('avtalebrott',),
'avtalebrottet': ('avtalebrott',),
'avtalebrudd': ('avtalebrudd',),
'avtalebrudda': ('avtalebrudd',),
'avtalebruddene': ('avtalebrudd',),
'avtalebruddet': ('avtalebrudd',),
'avtalelov': ('avtalelov',),
'avtaleloven': ('avtalelov',),
'avtalelovene': ('avtalelov',),
'avtalelover': ('avtalelov',),
'avtaleperiode': ('avtaleperiode',),
'avtaleperioden': ('avtaleperiode',),
'avtaleperiodene': ('avtaleperiode',),
'avtaleperioder': ('avtaleperiode',),
'avtaleverk': ('avtaleverk',),
'avtaleverka': ('avtaleverk',),
'avtaleverkene': ('avtaleverk',),
'avtaleverker': ('avtaleverk',),
'avtaleverket': ('avtaleverk',),
'avtegn': ('avtegn',),
'avtegna': ('avtegn',),
'avtegnene': ('avtegn',),
'avtegnet': ('avtegn',),
'avtrapning': ('avtrapning',),
'avtrapninga': ('avtrapning',),
'avtrapningen': ('avtrapning',),
'avtrapningene': ('avtrapning',),
'avtrapninger': ('avtrapning',),
'avtrapping': ('avtrapping',),
'avtrappinga': ('avtrapping',),
'avtrappingen': ('avtrapping',),
'avtrappingene': ('avtrapping',),
'avtrappinger': ('avtrapping',),
'avtreda': ('avtrede',),
'avtrede': ('avtrede',),
'avtredene': ('avtrede',),
'avtreder': ('avtrede',),
'avtredet': ('avtrede',),
'avtrekk': ('avtrekk',),
'avtrekka': ('avtrekk',),
'avtrekkene': ('avtrekk',),
'avtrekket': ('avtrekk',),
'avtrekker': ('avtrekker',),
'avtrekkere': ('avtrekker',),
'avtrekkeren': ('avtrekker',),
'avtrekkerer': ('avtrekker',),
'avtrekkerne': ('avtrekker',),
'avtrekkshastighet': ('avtrekkshastighet',),
'avtrekkshastigheta': ('avtrekkshastighet',),
'avtrekkshastigheten': ('avtrekkshastighet',),
'avtrekkshastighetene': ('avtrekkshastighet',),
'avtrekkshastigheter': ('avtrekkshastighet',),
'avtrekkshetta': ('avtrekkshette',),
'avtrekkshette': ('avtrekkshette',),
'avtrekkshetten': ('avtrekkshette',),
'avtrekkshettene': ('avtrekkshette',),
'avtrekkshetter': ('avtrekkshette',),
'avtrekkshylsa': ('avtrekkshylse',),
'avtrekkshylse': ('avtrekkshylse',),
'avtrekkshylsen': ('avtrekkshylse',),
'avtrekkshylsene': ('avtrekkshylse',),
'avtrekkshylser': ('avtrekkshylse',),
'avtrekkskanal': ('avtrekkskanal',),
'avtrekkskanalen': ('avtrekkskanal',),
'avtrekkskanalene': ('avtrekkskanal',),
'avtrekkskanaler': ('avtrekkskanal',),
'avtrekksrør': ('avtrekksrør',),
'avtrekksrøra': ('avtrekksrør',),
'avtrekksrørene': ('avtrekksrør',),
'avtrekksrøret': ('avtrekksrør',),
'avtrekksvifta': ('avtrekksvifte',),
'avtrekksvifte': ('avtrekksvifte',),
'avtrekksviften': ('avtrekksvifte',),
'avtrekksviftene': ('avtrekksvifte',),
'avtrekksvifter': ('avtrekksvifte',),
'avtrykk': ('avtrykk',),
'avtrykka': ('avtrykk',),
'avtrykkene': ('avtrykk',),
'avtrykket': ('avtrykk',),
'avund': ('avund',),
'avunden': ('avund',),
'avundene': ('avund',),
'avunder': ('avund',),
'avveg': ('avveg',),
'avvegen': ('avveg',),
'avvegene': ('avveg',),
'avveger': ('avveg',),
'avvei': ('avvei',),
'avveien': ('avvei',),
'avveiene': ('avvei',),
'avveier': ('avvei',),
'avveksling': ('avveksling',),
'avvekslinga': ('avveksling',),
'avvekslingen': ('avveksling',),
'avvekslingene': ('avveksling',),
'avvekslinger': ('avveksling',),
'avvenning': ('avvenning',),
'avvenninga': ('avvenning',),
'avvenningen': ('avvenning',),
'avvenningene': ('avvenning',),
'avvenninger': ('avvenning',),
'avvenningsalder': ('avvenningsalder',),
'avvenningsaldere': ('avvenningsalder',),
'avvenningsalderen': ('avvenningsalder',),
'avvenningsalderer': ('avvenningsalder',),
'avvenningsalderne': ('avvenningsalder',),
'avvenningsaldre': ('avvenningsalder',),
'avvenningsaldrene': ('avvenningsalder',),
'avvenningsaldrer': ('avvenningsalder',),
'avvenningskur': ('avvenningskur',),
'avvenningskuren': ('avvenningskur',),
'avvenningskurene': ('avvenningskur',),
'avvenningskurer': ('avvenningskur',),
'avverge': ('avverge',),
'avvergen': ('avverge',),
'avvergene': ('avverge',),
'avverger': ('avverge',),
'avverging': ('avverging',),
'avverginga': ('avverging',),
'avvergingen': ('avverging',),
'avvergingene': ('avverging',),
'avverginger': ('avverging',),
'avvergingsmekanisme': ('avvergingsmekanisme',),
'avvergingsmekanismen': ('avvergingsmekanisme',),
'avvergingsmekanismene': ('avvergingsmekanisme',),
'avvergingsmekanismer': ('avvergingsmekanisme',),
'avvergingsmiddel': ('avvergingsmiddel',),
'avvergingsmiddelet': ('avvergingsmiddel',),
'avvergingsmidla': ('avvergingsmiddel',),
'avvergingsmidlene': ('avvergingsmiddel',),
'avvergingsmidler': ('avvergingsmiddel',),
'avvergingsmidlet': ('avvergingsmiddel',),
'avvik': ('avvik',),
'avvika': ('avvik',),
'avvikene': ('avvik',),
'avviket': ('avvik',),
'avvikelse': ('avvikelse',),
'avvikelsen': ('avvikelse',),
'avvikelsene': ('avvikelse',),
'avvikelser': ('avvikelse',),
'avviker': ('avviker',),
'avvikere': ('avviker',),
'avvikeren': ('avviker',),
'avvikerer': ('avviker',),
'avvikerne': ('avviker',),
'avvikling': ('avvikling',),
'avviklinga': ('avvikling',),
'avviklingen': ('avvikling',),
'avviklingene': ('avvikling',),
'avviklinger': ('avvikling',),
'avviklingsstyra': ('avviklingsstyre',),
'avviklingsstyre': ('avviklingsstyre',),
'avviklingsstyrene': ('avviklingsstyre',),
'avviklingsstyrer': ('avviklingsstyre',),
'avviklingsstyret': ('avviklingsstyre',),
'avvirking': ('avvirking',),
'avvirkinga': ('avvirking',),
'avvirkingen': ('avvirking',),
'avvirkingene': ('avvirking',),
'avvirkinger': ('avvirking',),
'avvirkingskalkyle': ('avvirkingskalkyle',),
'avvirkingskalkylen': ('avvirkingskalkyle',),
'avvirkingskalkylene': ('avvirkingskalkyle',),
'avvirkingskalkyler': ('avvirkingskalkyle',),
'avvirkingsområda': ('avvirkingsområde',),
'avvirkingsområde': ('avvirkingsområde',),
'avvirkingsområdene': ('avvirkingsområde',),
'avvirkingsområder': ('avvirkingsområde',),
'avvirkingsområdet': ('avvirkingsområde',),
'avvirkingsprosent': ('avvirkingsprosent',),
'avvirkingsprosenten': ('avvirkingsprosent',),
'avvirkingsprosentene': ('avvirkingsprosent',),
'avvirkingsprosenter': ('avvirkingsprosent',),
'avvirkning': ('avvirkning',),
'avvirkninga': ('avvirkning',),
'avvirkningen': ('avvirkning',),
'avvirkningene': ('avvirkning',),
'avvirkninger': ('avvirkning',),
'avvirkningskalkyle': ('avvirkningskalkyle',),
'avvirkningskalkylen': ('avvirkningskalkyle',),
'avvirkningskalkylene': ('avvirkningskalkyle',),
'avvirkningskalkyler': ('avvirkningskalkyle',),
'avvirkningsområda': ('avvirkningsområde',),
'avvirkningsområde': ('avvirkningsområde',),
'avvirkningsområdene': ('avvirkningsområde',),
'avvirkningsområder': ('avvirkningsområde',),
'avvirkningsområdet': ('avvirkningsområde',),
'avvirkningsprosent': ('avvirkningsprosent',),
'avvirkningsprosenten': ('avvirkningsprosent',),
'avvirkningsprosentene': ('avvirkningsprosent',),
'avvirkningsprosenter': ('avvirkningsprosent',),
'avviser': ('avviser',),
'avvisere': ('avviser',),
'avviseren': ('avviser',),
'avviserer': ('avviser',),
'avviserne': ('avviser',),
'avviserstein': ('avviserstein',),
'avvisersteinen': ('avviserstein',),
'avvisersteinene': ('avviserstein',),
'avvisersteiner': ('avviserstein',),
'avviserstolpe': ('avviserstolpe',),
'avviserstolpen': ('avviserstolpe',),
'avviserstolpene': ('avviserstolpe',),
'avviserstolper': ('avviserstolpe',),
'avvising': ('avvising',),
'avvisinga': ('avvising',),
'avvisingen': ('avvising',),
'avvisingene': ('avvising',),
'avvisinger': ('avvising',),
'avvisingsreaksjon': ('avvisingsreaksjon',),
'avvisingsreaksjonen': ('avvisingsreaksjon',),
'avvisingsreaksjonene': ('avvisingsreaksjon',),
'avvisingsreaksjoner': ('avvisingsreaksjon',),
'avvisning': ('avvisning',),
'avvisninga': ('avvisning',),
'avvisningen': ('avvisning',),
'avvisningene': ('avvisning',),
'avvisninger': ('avvisning',),
'avvisningsreaksjon': ('avvisningsreaksjon',),
'avvisningsreaksjonen': ('avvisningsreaksjon',),
'avvisningsreaksjonene': ('avvisningsreaksjon',),
'avvisningsreaksjoner': ('avvisningsreaksjon',),
'ayatolla': ('ayatolla',),
'ayatollaen': ('ayatolla',),
'ayatollaene': ('ayatolla',),
'ayatollaer': ('ayatolla',),
'azteker': ('azteker',),
'aztekere': ('azteker',),
'aztekeren': ('azteker',),
'aztekerer': ('azteker',),
'aztekerne': ('azteker',),
'b': ('b',),
'b\'en': ('b',),
'b-en': ('b',),
'b-ene': ('b',),
'b-er': ('b',),
'b-film': ('b-film',),
'b-filmen': ('b-film',),
'b-filmene': ('b-film',),
'b-filmer': ('b-film',),
'b-kvalitet': ('b-kvalitet',),
'b-kvaliteten': ('b-kvalitet',),
'b-kvalitetene': ('b-kvalitet',),
'b-kvaliteter': ('b-kvalitet',),
'b-lag': ('b-lag',),
'b-laga': ('b-lag',),
'b-lagene': ('b-lag',),
'b-laget': ('b-lag',),
'b-menneska': ('b-menneske',),
'b-menneske': ('b-menneske',),
'b-menneskene': ('b-menneske',),
'b-mennesker': ('b-menneske',),
'b-mennesket': ('b-menneske',),
'b-moll': ('b-moll',),
'b-mollen': ('b-moll',),
'b-mollene': ('b-moll',),
'b-moller': ('b-moll',),
'babbel': ('babbel',),
'babbelet': ('babbel',),
'babla': ('babbel',),
'bablene': ('babbel',),
'babler': ('babbel',),
'bablet': ('babbel',),
'babel': ('babel',),
'babl': ('babl',),
'babla': ('babl',),
'bablene': ('babl',),
'bablet': ('babl',),
'babord': ('babord',),
'baby': ('baby',),
'babyen': ('baby',),
'babyene': ('baby',),
'babyer': ('baby',),
'babyklær': ('babyklær',),
'babyklærne': ('babyklær',),
'babykorg': ('babykorg',),
'babykorga': ('babykorg',),
'babykorgen': ('babykorg',),
'babykorgene': ('babykorg',),
'babykorger': ('babykorg',),
'babykurv': ('babykurv',),
'babykurva': ('babykurv',),
'babykurven': ('babykurv',),
'babykurvene': ('babykurv',),
'babykurver': ('babykurv',),
'babyloner': ('babyloner',),
'babylonere': ('babyloner',),
'babyloneren': ('babyloner',),
'babylonerer': ('babyloner',),
'babylonerne': ('babyloner',),
'babylonier': ('babylonier',),
'babyloniere': ('babylonier',),
'babylonieren': ('babylonier',),
'babylonierer': ('babylonier',),
'babylonierne': ('babylonier',),
'babypose': ('babypose',),
'babyposen': ('babypose',),
'babyposene': ('babypose',),
'babyposer': ('babypose',),
'bacalao': ('bacalao',),
'bacalaoen': ('bacalao',),
'bacalaoene': ('bacalao',),
'bacalaoer': ('bacalao',),
'back': ('back',),
'backen': ('back',),
'backene': ('back',),
'backer': ('back',),
'backfisch': ('backfisch',),
'backfischen': ('backfisch',),
'backfischene': ('backfisch',),
'backfischer': ('backfisch',),
'backhand': ('backhand',),
'backhanden': ('backhand',),
'backhandene': ('backhand',),
'backhander': ('backhand',),
'backlash': ('backlash',),
'backlashen': ('backlash',),
'backlashene': ('backlash',),
'backlasher': ('backlash',),
'bacon': ('bacon',),
'bacona': ('bacon',),
'baconene': ('bacon',),
'baconet': ('bacon',),
'bacongris': ('bacongris',),
'bacongrisen': ('bacongris',),
'bacongrisene': ('bacongris',),
'bacongriser': ('bacongris',),
'baconost': ('baconost',),
'baconosten': ('baconost',),
'baconostene': ('baconost',),
'baconoster': ('baconost',),
'bad': ('bad',),
'bada': ('bad',),
'badene': ('bad',),
'badet': ('bad',),
'badeanstalt': ('badeanstalt',),
'badeanstalten': ('badeanstalt',),
'badeanstaltene': ('badeanstalt',),
'badeanstalter': ('badeanstalt',),
'badebalja': ('badebalje',),
'badebalje': ('badebalje',),
'badebaljen': ('badebalje',),
'badebaljene': ('badebalje',),
'badebaljer': ('badebalje',),
'badeball': ('badeball',),
'badeballen': ('badeball',),
'badeballene': ('badeball',),
'badeballer': ('badeball',),
'badebuksa': ('badebukse',),
'badebukse': ('badebukse',),
'badebuksen': ('badebukse',),
'badebuksene': ('badebukse',),
'badebukser': ('badebukse',),
'badeby': ('badeby',),
'badebyen': ('badeby',),
'badebyene': ('badeby',),
'badebyer': ('badeby',),
'badedrakt': ('badedrakt',),
'badedrakta': ('badedrakt',),
'badedrakten': ('badedrakt',),
'badedraktene': ('badedrakt',),
'badedrakter': ('badedrakt',),
'badegjest': ('badegjest',),
'badegjesten': ('badegjest',),
'badegjestene': ('badegjest',),
'badegjester': ('badegjest',),
'badehandkle': ('badehandkle',),
'badehandkleet': ('badehandkle',),
'badehandklær': ('badehandkle',),
'badehandklærne': ('badehandkle',),
'badehetta': ('badehette',),
'badehette': ('badehette',),
'badehetten': ('badehette',),
'badehettene': ('badehette',),
'badehetter': ('badehette',),
'badehåndkle': ('badehåndkle',),
'badehåndkleet': ('badehåndkle',),
'badehåndklær': ('badehåndkle',),
'badehåndklærne': ('badehåndkle',),
'badekar': ('badekar',),
'badekara': ('badekar',),
'badekarene': ('badekar',),
'badekaret': ('badekar',),
'badenymfa': ('badenymfe',),
'badenymfe': ('badenymfe',),
'badenymfen': ('badenymfe',),
'badenymfene': ('badenymfe',),
'badenymfer': ('badenymfe',),
'badeomn': ('badeomn',),
'badeomnen': ('badeomn',),
'badeomnene': ('badeomn',),
'badeomner': ('badeomn',),
'badeovn': ('badeovn',),
'badeovnen': ('badeovn',),
'badeovnene': ('badeovn',),
'badeovner': ('badeovn',),
'bader': ('bader',),
'badere': ('bader',),
'baderen': ('bader',),
'baderer': ('bader',),
'baderne': ('bader',),
'baderom': ('baderom',),
'baderomma': ('baderom',),
'baderommene': ('baderom',),
'baderommet': ('baderom',),
'badesalt': ('badesalt',),
'badesalta': ('badesalt',),
'badesaltene': ('badesalt',),
'badesalter': ('badesalt',),
'badesaltet': ('badesalt',),
'badesesong': ('badesesong',),
'badesesongen': ('badesesong',),
'badesesongene': ('badesesong',),
'badesesonger': ('badesesong',),
'badested': ('badested',),
'badestedene': ('badested',),
'badesteder': ('badested',),
'badestedet': ('badested',),
'badestrand': ('badestrand',),
'badestranda': ('badestrand',),
'badestranden': ('badestrand',),
'badestrendene': ('badestrand',),
'badestrender': ('badestrand',),
'badesvamp': ('badesvamp',),
'badesvampen': ('badesvamp',),
'badesvampene': ('badesvamp',),
'badesvamper': ('badesvamp',),
'badevann': ('badevann',),
'badevanna': ('badevann',),
'badevannene': ('badevann',),
'badevannet': ('badevann',),
'badevatn': ('badevatn',),
'badevatna': ('badevatn',),
'badevatnene': ('badevatn',),
'badevatnet': ('badevatn',),
'badminton': ('badminton',),
'badmintonen': ('badminton',),
'badmintonene': ('badminton',),
'badmintoner': ('badminton',),
'badmintonball': ('badmintonball',),
'badmintonballen': ('badmintonball',),
'badmintonballene': ('badmintonball',),
'badmintonballer': ('badmintonball',),
'badmintonbane': ('badmintonbane',),
'badmintonbanen': ('badmintonbane',),
'badmintonbanene': ('badmintonbane',),
'badmintonbaner': ('badmintonbane',),
'badmintonkamp': ('badmintonkamp',),
'badmintonkampen': ('badmintonkamp',),
'badmintonkampene': ('badmintonkamp',),
'badmintonkamper': ('badmintonkamp',),
'badstubad': ('badstubad',),
'badstubada': ('badstubad',),
'badstubadene': ('badstubad',),
'badstubadet': ('badstubad',),
'badstua': ('badstue',),
'badstue': ('badstue',),
'badstuen': ('badstue',),
'badstuene': ('badstue',),
'badstuer': ('badstue',),
'badstuomn': ('badstuomn',),
'badstuomnen': ('badstuomn',),
'badstuomnene': ('badstuomn',),
'badstuomner': ('badstuomn',),
'badstuovn': ('badstuovn',),
'badstuovnen': ('badstuovn',),
'badstuovnene': ('badstuovn',),
'badstuovner': ('badstuovn',),
'bag': ('bag',),
'bagen': ('bag',),
'bagene': ('bag',),
'bager': ('bag',),
'bagasje': ('bagasje',),
'bagasjen': ('bagasje',),
'bagasjene': ('bagasje',),
'bagasjer': ('bagasje',),
'bagasjebrett': ('bagasjebrett',),
'bagasjebretta': ('bagasjebrett',),
'bagasjebrettene': ('bagasjebrett',),
'bagasjebretter': ('bagasjebrett',),
'bagasjebrettet': ('bagasjebrett',),
'bagasjebærer': ('bagasjebærer',),
'bagasjebærere': ('bagasjebærer',),
'bagasjebæreren': ('bagasjebærer',),
'bagasjebærerer': ('bagasjebærer',),
'bagasjebærerne': ('bagasjebærer',),
'bagasjeforsikring': ('bagasjeforsikring',),
'bagasjeforsikringa': ('bagasjeforsikring',),
'bagasjeforsikringen': ('bagasjeforsikring',),
'bagasjeforsikringene': ('bagasjeforsikring',),
'bagasjeforsikringer': ('bagasjeforsikring',),
'bagasjegrind': ('bagasjegrind',),
'bagasjegrinda': ('bagasjegrind',),
'bagasjegrinden': ('bagasjegrind',),
'bagasjegrindene': ('bagasjegrind',),
'bagasjegrinder': ('bagasjegrind',),
'bagasjehylla': ('bagasjehylle',),
'bagasjehylle': ('bagasjehylle',),
'bagasjehyllen': ('bagasjehylle',),
'bagasjehyllene': ('bagasjehylle',),
'bagasjehyller': ('bagasjehylle',),
'bagasjenett': ('bagasjenett',),
'bagasjenetta': ('bagasjenett',),
'bagasjenettene': ('bagasjenett',),
'bagasjenettet': ('bagasjenett',),
'bagasjerom': ('bagasjerom',),
'bagasjeromma': ('bagasjerom',),
'bagasjerommene': ('bagasjerom',),
'bagasjerommet': ('bagasjerom',),
'bagatell': ('bagatell',),
'bagatellen': ('bagatell',),
'bagatellene': ('bagatell',),
'bagateller': ('bagatell',),
'bagett': ('bagett',),
'bagetten': ('bagett',),
'bagettene': ('bagett',),
'bagetter': ('bagett',),
'bagler': ('bagler',),
'baglere': ('bagler',),
'bagleren': ('bagler',),
'baglerer': ('bagler',),
'baglerne': ('bagler',),
'baglerbisp': ('baglerbisp',),
'baglerbispen': ('baglerbisp',),
'baglerbispene': ('baglerbisp',),
'baglerbisper': ('baglerbisp',),
'baglerflokk': ('baglerflokk',),
'baglerflokken': ('baglerflokk',),
'baglerflokkene': ('baglerflokk',),
'baglerflokker': ('baglerflokk',),
'baglerhær': ('baglerhær',),
'baglerhæren': ('baglerhær',),
'baglerhærene': ('baglerhær',),
'baglerhærer': ('baglerhær',),
'baglerkonge': ('baglerkonge',),
'baglerkongen': ('baglerkonge',),
'baglerkongene': ('baglerkonge',),
'baglerkonger': ('baglerkonge',),
'bagvogn': ('bagvogn',),
'bagvogna': ('bagvogn',),
'bagvognen': ('bagvogn',),
'bagvognene': ('bagvogn',),
'bagvogner': ('bagvogn',),
'bahaimedlem': ('bahaimedlem',),
'bahaimedlemma': ('bahaimedlem',),
'bahaimedlemmene': ('bahaimedlem',),
'bahaimedlemmer': ('bahaimedlem',),
'bahaimedlemmet': ('bahaimedlem',),
'bahaisamfunn': ('bahaisamfunn',),
'bahaisamfunna': ('bahaisamfunn',),
'bahaisamfunnene': ('bahaisamfunn',),
'bahaisamfunnet': ('bahaisamfunn',),
'bahaitro': ('bahaitro',),
'bahaitroa': ('bahaitro',),
'bahaitroen': ('bahaitro',),
'bahaitroene': ('bahaitro',),
'bahaitroer': ('bahaitro',),
'bahamaner': ('bahamaner',),
'bahamanere': ('bahamaner',),
'bahamaneren': ('bahamaner',),
'bahamanerer': ('bahamaner',),
'bahamanerne': ('bahamaner',),
'bahrainer': ('bahrainer',),
'bahrainere': ('bahrainer',),
'bahraineren': ('bahrainer',),
'bahrainerer': ('bahrainer',),
'bahrainerne': ('bahrainer',),
'baisse': ('baisse',),
'baissen': ('baisse',),
'baissene': ('baisse',),
'baisser': ('baisse',),
'baissespekulant': ('baissespekulant',),
'baissespekulanten': ('baissespekulant',),
'baissespekulantene': ('baissespekulant',),
'baissespekulanter': ('baissespekulant',),
'bajas': ('bajas',),
'bajasen': ('bajas',),
'bajasene': ('bajas',),
'bajaser': ('bajas',),
'bajasfakta': ('bajasfakte',),
'bajasfakte': ('bajasfakte',),
'bajasfakten': ('bajasfakte',),
'bajasfaktene': ('bajasfakte',),
'bajasfakter': ('bajasfakte',),
'bajasfjes': ('bajasfjes',),
'bajasfjesa': ('bajasfjes',),
'bajasfjesene': ('bajasfjes',),
'bajasfjeset': ('bajasfjes',),
'bajasstrek': ('bajasstrek',),
'bajasstreken': ('bajasstrek',),
'bajasstrekene': ('bajasstrek',),
'bajasstreker': ('bajasstrek',),
'bajazzo': ('bajazzo',),
'bajazzoen': ('bajazzo',),
'bajazzoene': ('bajazzo',),
'bajazzoer': ('bajazzo',),
'bajonett': ('bajonett',),
'bajonetten': ('bajonett',),
'bajonettene': ('bajonett',),
'bajonetter': ('bajonett',),
'bajonettkamp': ('bajonettkamp',),
'bajonettkampen': ('bajonettkamp',),
'bajonettkampene': ('bajonettkamp',),
'bajonettkamper': ('bajonettkamp',),
'bajonettlås': ('bajonettlås',),
'bajonettlåsa': ('bajonettlås',),
'bajonettlåsen': ('bajonettlås',),
'bajonettlåsene': ('bajonettlås',),
'bajonettlåser': ('bajonettlås',),
'bajonettlåset': ('bajonettlås',),
'bak': ('bak',),
'baken': ('bak',),
'bakene': ('bak',),
'baker': ('bak',),
'bak': ('bak',),
'baka': ('bak',),
'baken': ('bak',),
'bakene': ('bak',),
'baker': ('bak',),
'baket': ('bak',),
'bakaksel': ('bakaksel',),
'bakakselen': ('bakaksel',),
'bakakslene': ('bakaksel',),
'bakaksler': ('bakaksel',),
'bakbein': ('bakbein',),
'bakbeina': ('bakbein',),
'bakbeinene': ('bakbein',),
'bakbeinet': ('bakbein',),
'bakben': ('bakben',),
'bakbena': ('bakben',),
'bakbenene': ('bakben',),
'bakbenet': ('bakben',),
'bakdel': ('bakdel',),
'bakdelen': ('bakdel',),
'bakdelene': ('bakdel',),
'bakdeler': ('bakdel',),
'bakdør': ('bakdør',),
'bakdøra': ('bakdør',),
'bakdøren': ('bakdør',),
'bakdørene': ('bakdør',),
'bakdører': ('bakdør',),
'bakdørspolitikk': ('bakdørspolitikk',),
'bakdørspolitikken': ('bakdørspolitikk',),
'bakdørspolitikkene': ('bakdørspolitikk',),
'bakdørspolitikker': ('bakdørspolitikk',),
'bakelitt': ('bakelitt',),
'bakelitten': ('bakelitt',),
'bakelittene': ('bakelitt',),
'bakelitter': ('bakelitt',),
'bakende': ('bakende',),
'bakenden': ('bakende',),
'bakendene': ('bakende',),
'bakender': ('bakende',),
'bakepulver': ('bakepulver',),
'bakepulvera': ('bakepulver',),
'bakepulvere': ('bakepulver',),
'bakepulveret': ('bakepulver',),
'bakepulverne': ('bakepulver',),
'baker': ('baker',),
'bakere': ('baker',),
'bakeren': ('baker',),
'bakerer': ('baker',),
'bakerne': ('baker',),
'bakerbutikk': ('bakerbutikk',),
'bakerbutikken': ('bakerbutikk',),
'bakerbutikkene': ('bakerbutikk',),
'bakerbutikker': ('bakerbutikk',),
'bakeri': ('bakeri',),
'bakeria': ('bakeri',),
'bakeriene': ('bakeri',),
'bakerier': ('bakeri',),
'bakeriet': ('bakeri',),
'bakeromn': ('bakeromn',),
'bakeromnen': ('bakeromn',),
'bakeromnene': ('bakeromn',),
'bakeromner': ('bakeromn',),
'bakerovn': ('bakerovn',),
'bakerovnen': ('bakerovn',),
'bakerovnene': ('bakerovn',),
'bakerovner': ('bakerovn',),
'bakervara': ('bakervare',),
'bakervare': ('bakervare',),
'bakervaren': ('bakervare',),
'bakervarene': ('bakervare',),
'bakervarer': ('bakervare',),
'bakevja': ('bakevje',),
'bakevje': ('bakevje',),
'bakevjen': ('bakevje',),
'bakevjene': ('bakevje',),
'bakevjer': ('bakevje',),
'bakfjel': ('bakfjel',),
'bakfjela': ('bakfjel',),
'bakfjelen': ('bakfjel',),
'bakfjelene': ('bakfjel',),
'bakfjeler': ('bakfjel',),
'bakfjøl': ('bakfjøl',),
'bakfjøla': ('bakfjøl',),
'bakfjølen': ('bakfjøl',),
'bakfjølene': ('bakfjøl',),
'bakfjøler': ('bakfjøl',),
'bakgata': ('bakgate',),
'bakgate': ('bakgate',),
'bakgaten': ('bakgate',),
'bakgatene': ('bakgate',),
'bakgater': ('bakgate',),
'bakgrunn': ('bakgrunn',),
'bakgrunnen': ('bakgrunn',),
'bakgrunnene': ('bakgrunn',),
'bakgrunner': ('bakgrunn',),
'bakgrunnsfigur': ('bakgrunnsfigur',),
'bakgrunnsfiguren': ('bakgrunnsfigur',),
'bakgrunnsfigurene': ('bakgrunnsfigur',),
'bakgrunnsfigurer': ('bakgrunnsfigur',),
'bakgrunnsmusikk': ('bakgrunnsmusikk',),
'bakgrunnsmusikken': ('bakgrunnsmusikk',),
'bakgrunnsmusikkene': ('bakgrunnsmusikk',),
'bakgrunnsmusikker': ('bakgrunnsmusikk',),
'bakgrunnsstoff': ('bakgrunnsstoff',),
'bakgrunnsstoffa': ('bakgrunnsstoff',),
'bakgrunnsstoffene': ('bakgrunnsstoff',),
'bakgrunnsstoffet': ('bakgrunnsstoff',),
'bakgård': ('bakgård',),
'bakgården': ('bakgård',),
'bakgårdene': ('bakgård',),
'bakgårder': ('bakgård',),
'bakhandsslag': ('bakhandsslag',),
'bakhandsslaga': ('bakhandsslag',),
'bakhandsslagene': ('bakhandsslag',),
'bakhandsslaget': ('bakhandsslag',),
'bakhjul': ('bakhjul',),
'bakhjula': ('bakhjul',),
'bakhjulene': ('bakhjul',),
'bakhjulet': ('bakhjul',),
'bakhjulsdrift': ('bakhjulsdrift',),
'bakhjulsdrifta': ('bakhjulsdrift',),
'bakhjulsdriften': ('bakhjulsdrift',),
'bakhjulsdriftene': ('bakhjulsdrift',),
'bakhjulsdrifter': ('bakhjulsdrift',),
'bakhoda': ('bakhode',),
'bakhode': ('bakhode',),
'bakhodene': ('bakhode',),
'bakhoder': ('bakhode',),
'bakhodet': ('bakhode',),
'bakhold': ('bakhold',),
'bakholda': ('bakhold',),
'bakholdene': ('bakhold',),
'bakholdet': ('bakhold',),
'bakholdsangrep': ('bakholdsangrep',),
'bakholdsangrepa': ('bakholdsangrep',),
'bakholdsangrepene': ('bakholdsangrep',),
'bakholdsangrepet': ('bakholdsangrep',),
'bakhun': ('bakhun',),
'bakhunen': ('bakhun',),
'bakhunene': ('bakhun',),
'bakhuner': ('bakhun',),
'bakhunved': ('bakhunved',),
'bakhunveden': ('bakhunved',),
'bakhunvedene': ('bakhunved',),
'bakhunveder': ('bakhunved',),
'bakhendene': ('bakhånd',),
'bakhender': ('bakhånd',),
'bakhånd': ('bakhånd',),
'bakhånda': ('bakhånd',),
'bakhånden': ('bakhånd',),
'bakhåndsslag': ('bakhåndsslag',),
'bakhåndsslaga': ('bakhåndsslag',),
'bakhåndsslagene': ('bakhåndsslag',),
'bakhåndsslaget': ('bakhåndsslag',),
'bakk': ('bakk',),
'bakken': ('bakk',),
'bakkene': ('bakk',),
'bakker': ('bakk',),
'bakk': ('bakk',),
'bakken': ('bakk',),
'bakkene': ('bakk',),
'bakker': ('bakk',),
'bakkanal': ('bakkanal',),
'bakkanala': ('bakkanal',),
'bakkanalene': ('bakkanal',),
'bakkanaler': ('bakkanal',),
'bakkanalet': ('bakkanal',),
'bakkant': ('bakkant',),
'bakkanten': ('bakkant',),
'bakkantene': ('bakkant',),
'bakkanter': ('bakkant',),
'bakkant': ('bakkant',),
'bakkanten': ('bakkant',),
'bakkantene': ('bakkant',),
'bakkanter': ('bakkant',),
'bakkantinna': ('bakkantinne',),
'bakkantinne': ('bakkantinne',),
'bakkantinnen': ('bakkantinne',),
'bakkantinnene': ('bakkantinne',),
'bakkantinner': ('bakkantinne',),
'bakke': ('bakke',),
'bakken': ('bakke',),
'bakkene': ('bakke',),
'bakker': ('bakke',),
'bakke': ('bakke',),
'bakken': ('bakke',),
'bakkene': ('bakke',),
'bakker': ('bakke',),
'bakkekam': ('bakkekam',),
'bakkekammen': ('bakkekam',),
'bakkekammene': ('bakkekam',),
'bakkekammer': ('bakkekam',),
'bakkeklaring': ('bakkeklaring',),
'bakkeklaringa': ('bakkeklaring',),
'bakkeklaringen': ('bakkeklaring',),
'bakkeklaringene': ('bakkeklaring',),
'bakkeklaringer': ('bakkeklaring',),
'bakkekneik': ('bakkekneik',),
'bakkekneika': ('bakkekneik',),
'bakkekneiken': ('bakkekneik',),
'bakkekneikene': ('bakkekneik',),
'bakkekneiker': ('bakkekneik',),
'bakkekontakt': ('bakkekontakt',),
'bakkekontakten': ('bakkekontakt',),
'bakkekontaktene': ('bakkekontakt',),
'bakkekontakter': ('bakkekontakt',),
'bakkelandskap': ('bakkelandskap',),
'bakkelandskapa': ('bakkelandskap',),
'bakkelandskapene': ('bakkelandskap',),
'bakkelandskaper': ('bakkelandskap',),
'bakkelandskapet': ('bakkelandskap',),
'bakkels': ('bakkels',),
'bakkelsen': ('bakkels',),
'bakkelsene': ('bakkels',),
'bakkelser': ('bakkels',),
'bakkelse': ('bakkelse',),
'bakkelsen': ('bakkelse',),
'bakkelsene': ('bakkelse',),
'bakkelser': ('bakkelse',),
'bakkeløp': ('bakkeløp',),
'bakkeløpa': ('bakkeløp',),
'bakkeløpene': ('bakkeløp',),
'bakkeløpet': ('bakkeløp',),
'bakkemannskap': ('bakkemannskap',),
'bakkemannskapa': ('bakkemannskap',),
'bakkemannskapene': ('bakkemannskap',),
'bakkemannskaper': ('bakkemannskap',),
'bakkemannskapet': ('bakkemannskap',),
'bakkenbart': ('bakkenbart',),
'bakkenbarten': ('bakkenbart',),
'bakkenbartene': ('bakkenbart',),
'bakkenbarter': ('bakkenbart',),
'bakkepersonell': ('bakkepersonell',),
'bakkepersonella': ('bakkepersonell',),
'bakkepersonellene': ('bakkepersonell',),
'bakkepersoneller': ('bakkepersonell',),
'bakkepersonellet': ('bakkepersonell',),
'bakkeplanering': ('bakkeplanering',),
'bakkeplaneringa': ('bakkeplanering',),
'bakkeplaneringen': ('bakkeplanering',),
'bakkeplaneringene': ('bakkeplanering',),
'bakkeplaneringer': ('bakkeplanering',),
'bakkerekord': ('bakkerekord',),
'bakkerekorden': ('bakkerekord',),
'bakkerekordene': ('bakkerekord',),
'bakkerekorder': ('bakkerekord',),
'bakkeskråning': ('bakkeskråning',),
'bakkeskråninga': ('bakkeskråning',),
'bakkeskråningen': ('bakkeskråning',),
'bakkeskråningene': ('bakkeskråning',),
'bakkeskråninger': ('bakkeskråning',),
'bakkestart': ('bakkestart',),
'bakkestarten': ('bakkestart',),
'bakkestartene': ('bakkestart',),
'bakkestarter': ('bakkestart',),
'bakketjeneste': ('bakketjeneste',),
'bakketjenesten': ('bakketjeneste',),
'bakketjenestene': ('bakketjeneste',),
'bakketjenester': ('bakketjeneste',),
'bakketopp': ('bakketopp',),
'bakketoppen': ('bakketopp',),
'bakketoppene': ('bakketopp',),
'bakketopper': ('bakketopp',),
'bakkropp': ('bakkropp',),
'bakkroppen': ('bakkropp',),
'bakkroppene': ('bakkropp',),
'bakkropper': ('bakkropp',),
'bakksag': ('bakksag',),
'bakksaga': ('bakksag',),
'bakksagen': ('bakksag',),
'bakksagene': ('bakksag',),
'bakksager': ('bakksag',),
'bakkusdyrker': ('bakkusdyrker',),
'bakkusdyrkere': ('bakkusdyrker',),
'bakkusdyrkeren': ('bakkusdyrker',),
'bakkusdyrkerer': ('bakkusdyrker',),
'bakkusdyrkerne': ('bakkusdyrker',),
'bakkusfest': ('bakkusfest',),
'bakkusfesten': ('bakkusfest',),
'bakkusfestene': ('bakkusfest',),
'bakkusfester': ('bakkusfest',),
'baklader': ('baklader',),
'bakladere': ('baklader',),
'bakladeren': ('baklader',),
'bakladerer': ('baklader',),
'bakladerne': ('baklader',),
'bakladning': ('bakladning',),
'bakladninga': ('bakladning',),
'bakladningen': ('bakladning',),
'bakladningene': ('bakladning',),
'bakladninger': ('bakladning',),
'bakladningsbørsa': ('bakladningsbørse',),
'bakladningsbørse': ('bakladningsbørse',),
'bakladningsbørsen': ('bakladningsbørse',),
'bakladningsbørsene': ('bakladningsbørse',),
'bakladningsbørser': ('bakladningsbørse',),
'bakladningsgevær': ('bakladningsgevær',),
'bakladningsgeværa': ('bakladningsgevær',),
'bakladningsgeværene': ('bakladningsgevær',),
'bakladningsgeværer': ('bakladningsgevær',),
'bakladningsgeværet': ('bakladningsgevær',),
'bakladningskanon': ('bakladningskanon',),
'bakladningskanonen': ('bakladningskanon',),
'bakladningskanonene': ('bakladningskanon',),
'bakladningskanoner': ('bakladningskanon',),
'bakladningsvåpen': ('bakladningsvåpen',),
'bakladningsvåpenet': ('bakladningsvåpen',),
'bakladningsvåpna': ('bakladningsvåpen',),
'bakladningsvåpnene': ('bakladningsvåpen',),
'bakleksa': ('baklekse',),
'baklekse': ('baklekse',),
'bakleksen': ('baklekse',),
'bakleksene': ('baklekse',),
'baklekser': ('baklekse',),
'baklengsmål': ('baklengsmål',),
'baklengsmåla': ('baklengsmål',),
'baklengsmålene': ('baklengsmål',),
'baklengsmålet': ('baklengsmål',),
'bakli': ('bakli',),
'baklia': ('bakli',),
'baklien': ('bakli',),
'bakliene': ('bakli',),
'baklier': ('bakli',),
'baklomma': ('baklomme',),
'baklomme': ('baklomme',),
'baklommen': ('baklomme',),
'baklommene': ('baklomme',),
'baklommer': ('baklomme',),
'baklys': ('baklys',),
'baklysa': ('baklys',),
'baklysene': ('baklys',),
'baklyset': ('baklys',),
'baklås': ('baklås',),
'baklåsa': ('baklås',),
'baklåsen': ('baklås',),
'baklåsene': ('baklås',),
'baklåser': ('baklås',),
'baklåset': ('baklås',),
'bakmann': ('bakmann',),
'bakmannen': ('bakmann',),
'bakmenn': ('bakmann',),
'bakmennene': ('bakmann',),
'bakmeis': ('bakmeis',),
'bakmeisa': ('bakmeis',),
'bakmeisen': ('bakmeis',),
'bakmeisene': ('bakmeis',),
'bakmeiser': ('bakmeis',),
'bakol': ('bakol',),
'bakolen': ('bakol',),
'bakolene': ('bakol',),
'bakoler': ('bakol',),
'bakola': ('bakole',),
'bakole': ('bakole',),
'bakolen': ('bakole',),
'bakolene': ('bakole',),
'bakoler': ('bakole',),
'bakpart': ('bakpart',),
'bakparten': ('bakpart',),
'bakpartene': ('bakpart',),
'bakparter': ('bakpart',),
'bakparti': ('bakparti',),
'bakpartia': ('bakparti',),
'bakpartiene': ('bakparti',),
'bakpartier': ('bakparti',),
'bakpartiet': ('bakparti',),
'bakrom': ('bakrom',),
'bakromma': ('bakrom',),
'bakrommene': ('bakrom',),
'bakrommet': ('bakrom',),
'bakrus': ('bakrus',),
'bakrusa': ('bakrus',),
'bakrusen': ('bakrus',),
'bakrusene': ('bakrus',),
'bakruser': ('bakrus',),
'bakruset': ('bakrus',),
'baks': ('baks',),
'baksen': ('baks',),
'baksene': ('baks',),
'bakser': ('baks',),
'bakseta': ('baksete',),
'baksete': ('baksete',),
'baksetene': ('baksete',),
'bakseter': ('baksete',),
'baksetet': ('baksete',),
'baksida': ('bakside',),
'bakside': ('bakside',),
'baksiden': ('bakside',),
'baksidene': ('bakside',),
'baksider': ('bakside',),
'bakskjerm': ('bakskjerm',),
'bakskjermen': ('bakskjerm',),
'bakskjermene': ('bakskjerm',),
'bakskjermer': ('bakskjerm',),
'bakskott': ('bakskott',),
'bakskotten': ('bakskott',),
'bakskottene': ('bakskott',),
'bakskotter': ('bakskott',),
'bakskott': ('bakskott',),
'bakskotta': ('bakskott',),
'bakskottene': ('bakskott',),
'bakskottet': ('bakskott',),
'bakskut': ('bakskut',),
'bakskuten': ('bakskut',),
'bakskutene': ('bakskut',),
'bakskuter': ('bakskut',),
'bakslag': ('bakslag',),
'bakslaga': ('bakslag',),
'bakslagene': ('bakslag',),
'bakslaget': ('bakslag',),
'baksmell': ('baksmell',),
'baksmellen': ('baksmell',),
'baksmellene': ('baksmell',),
'baksmeller': ('baksmell',),
'baksnakk': ('baksnakk',),
'baksnakka': ('baksnakk',),
'baksnakken': ('baksnakk',),
'baksnakkene': ('baksnakk',),
'baksnakker': ('baksnakk',),
'baksnakket': ('baksnakk',),
'bakspark': ('bakspark',),
'baksparka': ('bakspark',),
'baksparkene': ('bakspark',),
'baksparket': ('bakspark',),
'bakspeller': ('bakspeller',),
'bakspellere': ('bakspeller',),
'bakspelleren': ('bakspeller',),
'bakspellerer': ('bakspeller',),
'bakspellerne': ('bakspeller',),
'bakspiller': ('bakspiller',),
'bakspillere': ('bakspiller',),
'bakspilleren': ('bakspiller',),
'bakspillerer': ('bakspiller',),
'bakspillerne': ('bakspiller',),
'bakst': ('bakst',),
'baksten': ('bakst',),
'bakstene': ('bakst',),
'bakster': ('bakst',),
'bakstamn': ('bakstamn',),
'bakstamnen': ('bakstamn',),
'bakstamnene': ('bakstamn',),
'bakstamner': ('bakstamn',),
'bakstavn': ('bakstavn',),
'bakstavnen': ('bakstavn',),
'bakstavnene': ('bakstavn',),
'bakstavner': ('bakstavn',),
'bakstebord': ('bakstebord',),
'baksteborda': ('bakstebord',),
'bakstebordene': ('bakstebord',),
'baksteborder': ('bakstebord',),
'bakstebordet': ('bakstebord',),
'bakstefjel': ('bakstefjel',),
'bakstefjela': ('bakstefjel',),
'bakstefjelen': ('bakstefjel',),
'bakstefjelene': ('bakstefjel',),
'bakstefjeler': ('bakstefjel',),
'bakstefjøl': ('bakstefjøl',),
'bakstefjøla': ('bakstefjøl',),
'bakstefjølen': ('bakstefjøl',),
'bakstefjølene': ('bakstefjøl',),
'bakstefjøler': ('bakstefjøl',),
'bakstehella': ('bakstehelle',),
'bakstehelle': ('bakstehelle',),
'bakstehellen': ('bakstehelle',),
'bakstehellene': ('bakstehelle',),
'baksteheller': ('bakstehelle',),
'bakstekona': ('bakstekone',),
'bakstekone': ('bakstekone',),
'bakstekonen': ('bakstekone',),
'bakstekonene': ('bakstekone',),
'bakstekoner': ('bakstekone',),
'bakster': ('bakster',),
'baksteren': ('bakster',),
'bakstre': ('bakster',),
'bakstrene': ('bakster',),
'bakstrer': ('bakster',),
'bakstespade': ('bakstespade',),
'bakstespaden': ('bakstespade',),
'bakstespadene': ('bakstespade',),
'bakstespader': ('bakstespade',),
'bakstrev': ('bakstrev',),
'bakstreva': ('bakstrev',),
'bakstrevene': ('bakstrev',),
'bakstrevet': ('bakstrev',),
'bakstrever': ('bakstrever',),
'bakstrevere': ('bakstrever',),
'bakstreveren': ('bakstrever',),
'bakstreverer': ('bakstrever',),
'bakstreverne': ('bakstrever',),
'bakstuss': ('bakstuss',),
'bakstussen': ('bakstuss',),
'bakstussene': ('bakstuss',),
'bakstusser': ('bakstuss',),
'bakstykka': ('bakstykke',),
'bakstykke': ('bakstykke',),
'bakstykkene': ('bakstykke',),
'bakstykker': ('bakstykke',),
'bakstykket': ('bakstykke',),
'baktalelse': ('baktalelse',),
'baktalelsen': ('baktalelse',),
'baktalelsene': ('baktalelse',),
'baktalelser': ('baktalelse',),
'baktanke': ('baktanke',),
'baktanken': ('baktanke',),
'baktankene': ('baktanke',),
'baktanker': ('baktanke',),
'baktericid': ('baktericid',),
'baktericida': ('baktericid',),
'baktericidene': ('baktericid',),
'baktericider': ('baktericid',),
'baktericidet': ('baktericid',),
'bakterie': ('bakterie',),
'bakterien': ('bakterie',),
'bakteriene': ('bakterie',),
'bakterier': ('bakterie',),
'bakterieflora': ('bakterieflora',),
'bakteriefloraen': ('bakterieflora',),
'bakteriefloraene': ('bakterieflora',),
'bakteriefloraer': ('bakterieflora',),
'bakteriekoloni': ('bakteriekoloni',),
'bakteriekolonien': ('bakteriekoloni',),
'bakteriekoloniene': ('bakteriekoloni',),
'bakteriekolonier': ('bakteriekoloni',),
'bakteriekultur': ('bakteriekultur',),
'bakteriekulturen': ('bakteriekultur',),
'bakteriekulturene': ('bakteriekultur',),
'bakteriekulturer': ('bakteriekultur',),
'bakteriesjukdom': ('bakteriesjukdom',),
'bakteriesjukdommen': ('bakteriesjukdom',),
'bakteriesjukdommene': ('bakteriesjukdom',),
'bakteriesjukdommer': ('bakteriesjukdom',),
'bakteriesykdom': ('bakteriesykdom',),
'bakteriesykdommen': ('bakteriesykdom',),
'bakteriesykdommene': ('bakteriesykdom',),
'bakteriesykdommer': ('bakteriesykdom',),
'bakteriofag': ('bakteriofag',),
'bakteriofagen': ('bakteriofag',),
'bakteriofagene': ('bakteriofag',),
'bakteriofager': ('bakteriofag',),
'bakteriolog': ('bakteriolog',),
'bakteriologen': ('bakteriolog',),
'bakteriologene': ('bakteriolog',),
'bakteriologer': ('bakteriolog',),
'bakteriologi': ('bakteriologi',),
'bakteriologien': ('bakteriologi',),
'bakteriologiene': ('bakteriologi',),
'bakteriologier': ('bakteriologi',),
'baktofta': ('baktofte',),
'baktofte': ('baktofte',),
'baktoften': ('baktofte',),
'baktoftene': ('baktofte',),
'baktofter': ('baktofte',),
'baktrapp': ('baktrapp',),
'baktrappa': ('baktrapp',),
'baktrappen': ('baktrapp',),
'baktrappene': ('baktrapp',),
'baktrapper': ('baktrapp',),
'baktropp': ('baktropp',),
'baktroppen': ('baktropp',),
'baktroppene': ('baktropp',),
'baktropper': ('baktropp',),
'baktunga': ('baktunge',),
'baktunge': ('baktunge',),
'baktungen': ('baktunge',),
'baktungene': ('baktunge',),
'baktunger': ('baktunge',),
'baktungelyd': ('baktungelyd',),
'baktungelyden': ('baktungelyd',),
'baktungelydene': ('baktungelyd',),
'baktungelyder': ('baktungelyd',),
'bakvaskelse': ('bakvaskelse',),
'bakvaskelsen': ('bakvaskelse',),
'bakvaskelsene': ('bakvaskelse',),
'bakvaskelser': ('bakvaskelse',),
'bakvasking': ('bakvasking',),
'bakvaskinga': ('bakvasking',),
'bakvaskingen': ('bakvasking',),
'bakvaskingene': ('bakvasking',),
'bakvaskinger': ('bakvasking',),
'bakveg': ('bakveg',),
'bakvegen': ('bakveg',),
'bakvegene': ('bakveg',),
'bakveger': ('bakveg',),
'bakvei': ('bakvei',),
'bakveien': ('bakvei',),
'bakveiene': ('bakvei',),
'bakveier': ('bakvei',),
'bakverk': ('bakverk',),
'bakverka': ('bakverk',),
'bakverkene': ('bakverk',),
'bakverket': ('bakverk',),
'bal': ('bal',),
'bala': ('bal',),
'balene': ('bal',),
'balet': ('bal',),
'balalaika': ('balalaika',),
'balalaikaen': ('balalaika',),
'balalaikaene': ('balalaika',),
'balalaikaer': ('balalaika',),
'balalaikamusikk': ('balalaikamusikk',),
'balalaikamusikken': ('balalaikamusikk',),
'balalaikamusikkene': ('balalaikamusikk',),
'balalaikamusikker': ('balalaikamusikk',),
'balalaikaorkester': ('balalaikaorkester',),
'balalaikaorkesteret': ('balalaikaorkester',),
'balalaikaorkestra': ('balalaikaorkester',),
'balalaikaorkestre': ('balalaikaorkester',),
'balalaikaorkestrene': ('balalaikaorkester',),
'balalaikaorkestret': ('balalaikaorkester',),
'balanse': ('balanse',),
'balansen': ('balanse',),
'balansene': ('balanse',),
'balanser': ('balanse',),
'balansegang': ('balansegang',),
'balansegangen': ('balansegang',),
'balansegangene': ('balansegang',),
'balanseganger': ('balansegang',),
'balansehjul': ('balansehjul',),
'balansehjula': ('balansehjul',),
'balansehjulene': ('balansehjul',),
'balansehjulet': ('balansehjul',),
'balansekonti': ('balansekonto',),
'balansekontiene': ('balansekonto',),
'balansekonto': ('balansekonto',),
'balansekontoen': ('balansekonto',),
'balansekontoene': ('balansekonto',),
'balansekontoer': ('balansekonto',),
'balansekunst': ('balansekunst',),
'balansekunsten': ('balansekunst',),
'balansekunstene': ('balansekunst',),
'balansekunster': ('balansekunst',),
'balansekunstner': ('balansekunstner',),
'balansekunstnere': ('balansekunstner',),
'balansekunstneren': ('balansekunstner',),
'balansekunstnerer': ('balansekunstner',),
'balansekunstnerne': ('balansekunstner',),
'balansepunkt': ('balansepunkt',),
'balansepunkta': ('balansepunkt',),
'balansepunktene': ('balansepunkt',),
'balansepunkter': ('balansepunkt',),
'balansepunktet': ('balansepunkt',),
'balanseror': ('balanseror',),
'balanserora': ('balanseror',),
'balanserorene': ('balanseror',),
'balanseroret': ('balanseror',),
'balansestang': ('balansestang',),
'balansestanga': ('balansestang',),
'balansestangen': ('balansestang',),
'balansestengene': ('balansestang',),
'balansestenger': ('balansestang',),
'baldakin': ('baldakin',),
'baldakinen': ('baldakin',),
'baldakinene': ('baldakin',),
'baldakiner': ('baldakin',),
'balderbrå': ('balderbrå',),
'balderbråa': ('balderbrå',),
'balderbråen': ('balderbrå',),
'balderbråene': ('balderbrå',),
'balderbråer': ('balderbrå',),
'baldrian': ('baldrian',),
'baldrianen': ('baldrian',),
'baldrianene': ('baldrian',),
'baldrianer': ('baldrian',),
'balineser': ('balineser',),
'balinesere': ('balineser',),
'balineseren': ('balineser',),
'balineserer': ('balineser',),
'balineserne': ('balineser',),
'balja': ('balje',),
'balje': ('balje',),
'baljen': ('balje',),
'baljene': ('balje',),
'baljer': ('balje',),
'balkong': ('balkong',),
'balkongen': ('balkong',),
'balkongene': ('balkong',),
'balkonger': ('balkong',),
'balkongkassa': ('balkongkasse',),
'balkongkasse': ('balkongkasse',),
'balkongkassen': ('balkongkasse',),
'balkongkassene': ('balkongkasse',),
'balkongkasser': ('balkongkasse',),
'ball': ('ball',),
'ballen': ('ball',),
'ballene': ('ball',),
'baller': ('ball',),
'ball': ('ball',),
'balla': ('ball',),
'ballene': ('ball',),
'baller': ('ball',),
'ballet': ('ball',),
'ballade': ('ballade',),
'balladen': ('ballade',),
'balladene': ('ballade',),
'ballader': ('ballade',),
'ballade': ('ballade',),
'balladen': ('ballade',),
'balladene': ('ballade',),
'ballader': ('ballade',),
'ballast': ('ballast',),
'ballasten': ('ballast',),
'ballastene': ('ballast',),
'ballaster': ('ballast',),
'ballastjern': ('ballastjern',),
'ballastjerna': ('ballastjern',),
'ballastjernene': ('ballastjern',),
'ballastjernet': ('ballastjern',),
'ballasttank': ('ballasttank',),
'ballasttanken': ('ballasttank',),
'ballasttankene': ('ballasttank',),
'ballasttanker': ('ballasttank',),
'ballblom': ('ballblom',),
'ballblommen': ('ballblom',),
'ballblommene': ('ballblom',),
'ballblommer': ('ballblom',),
'balle': ('balle',),
'ballen': ('balle',),
'ballene': ('balle',),
'baller': ('balle',),
'ballerina': ('ballerina',),
'ballerinaen': ('ballerina',),
'ballerinaene': ('ballerina',),
'ballerinaer': ('ballerina',),
'ballett': ('ballett',),
'balletten': ('ballett',),
'ballettene': ('ballett',),
'balletter': ('ballett',),
'ballettmester': ('ballettmester',),
'ballettmestere': ('ballettmester',),
'ballettmesteren': ('ballettmester',),
'ballettmesterer': ('ballettmester',),
'ballettmesterne': ('ballettmester',),
'ballettmestre': ('ballettmester',),
'ballettmestrene': ('ballettmester',),
'ballettmestrer': ('ballettmester',),
'ballettmusikk': ('ballettmusikk',),
'ballettmusikken': ('ballettmusikk',),
'ballettmusikkene': ('ballettmusikk',),
'ballettmusikker': ('ballettmusikk',),
'ballist': ('ballist',),
'ballisten': ('ballist',),
'ballistene': ('ballist',),
'ballister': ('ballist',),
'ballistikk': ('ballistikk',),
'ballistikken': ('ballistikk',),
'ballistikkene': ('ballistikk',),
'ballistikker': ('ballistikk',),
'ballkjole': ('ballkjole',),
'ballkjolen': ('ballkjole',),
'ballkjolene': ('ballkjole',),
'ballkjoler': ('ballkjole',),
'ballong': ('ballong',),
'ballongen': ('ballong',),
'ballongene': ('ballong',),
'ballonger': ('ballong',),
'ballongbuksa': ('ballongbukse',),
'ballongbukse': ('ballongbukse',),
'ballongbuksen': ('ballongbukse',),
'ballongbuksene': ('ballongbukse',),
'ballongbukser': ('ballongbukse',),
'ballongdekk': ('ballongdekk',),
'ballongdekka': ('ballongdekk',),
'ballongdekkene': ('ballongdekk',),
'ballongdekket': ('ballongdekk',),
'ballongferd': ('ballongferd',),
'ballongferda': ('ballongferd',),
'ballongferden': ('ballongferd',),
'ballongferdene': ('ballongferd',),
'ballongferder': ('ballongferd',),
'ballongform': ('ballongform',),
'ballongforma': ('ballongform',),
'ballongformen': ('ballongform',),
'ballongformene': ('ballongform',),
'ballongformer': ('ballongform',),
'ballongkorg': ('ballongkorg',),
'ballongkorga': ('ballongkorg',),
'ballongkorgen': ('ballongkorg',),
'ballongkorgene': ('ballongkorg',),
'ballongkorger': ('ballongkorg',),
'ballongkurv': ('ballongkurv',),
'ballongkurva': ('ballongkurv',),
'ballongkurven': ('ballongkurv',),
'ballongkurvene': ('ballongkurv',),
'ballongkurver': ('ballongkurv',),
'balloptikon': ('balloptikon',),
'balloptikona': ('balloptikon',),
'balloptikonene': ('balloptikon',),
'balloptikoner': ('balloptikon',),
'balloptikonet': ('balloptikon',),
'ballsal': ('ballsal',),
'ballsalen': ('ballsal',),
'ballsalene': ('ballsal',),
'ballsaler': ('ballsal',),
'ballspell': ('ballspell',),
'ballspella': ('ballspell',),
'ballspellene': ('ballspell',),
'ballspellet': ('ballspell',),
'ballspill': ('ballspill',),
'ballspilla': ('ballspill',),
'ballspillene': ('ballspill',),
'ballspillet': ('ballspill',),
'balsa': ('balsa',),
'balsaen': ('balsa',),
'balsaene': ('balsa',),
'balsaer': ('balsa',),
'balsaflåte': ('balsaflåte',),
'balsaflåten': ('balsaflåte',),
'balsaflåtene': ('balsaflåte',),
'balsaflåter': ('balsaflåte',),
'balsam': ('balsam',),
'balsamen': ('balsam',),
'balsamene': ('balsam',),
'balsamer': ('balsam',),
'balsamduft': ('balsamduft',),
'balsamduften': ('balsamduft',),
'balsamduftene': ('balsamduft',),
'balsamdufter': ('balsamduft',),
'balsamgran': ('balsamgran',),
'balsamgrana': ('balsamgran',),
'balsamgranen': ('balsamgran',),
'balsamgranene': ('balsamgran',),
'balsamgraner': ('balsamgran',),
'balsampoplene': ('balsampoppel',),
'balsampopler': ('balsampoppel',),
'balsampoppel': ('balsampoppel',),
'balsampoppelen': ('balsampoppel',),
'balsamtre': ('balsamtre',),
'balsamtrea': ('balsamtre',),
'balsamtreet': ('balsamtre',),
'balsamtrær': ('balsamtre',),
'balsamtrærne': ('balsamtre',),
'balsatre': ('balsatre',),
'balsatrea': ('balsatre',),
'balsatreet': ('balsatre',),
'balsatrær': ('balsatre',),
'balsatrærne': ('balsatre',),
'balter': ('balter',),
'baltere': ('balter',),
'balteren': ('balter',),
'balterer': ('balter',),
'balterne': ('balter',),
'baluster': ('baluster',),
'balustere': ('baluster',),
'balusteren': ('baluster',),
'balusterne': ('baluster',),
'balustre': ('baluster',),
'balustrene': ('baluster',),
'balustrer': ('baluster',),
'balustrade': ('balustrade',),
'balustraden': ('balustrade',),
'balustradene': ('balustrade',),
'balustrader': ('balustrade',),
'bamblesjuka': ('bamblesjuke',),
'bamblesjuke': ('bamblesjuke',),
'bamblesjuken': ('bamblesjuke',),
'bamblesjukene': ('bamblesjuke',),
'bamblesjuker': ('bamblesjuke',),
'bamblesyka': ('bamblesyke',),
'bamblesyke': ('bamblesyke',),
'bamblesyken': ('bamblesyke',),
'bamblesykene': ('bamblesyke',),
'bamblesyker': ('bamblesyke',),
'bambus': ('bambus',),
'bambusen': ('bambus',),
'bambusene': ('bambus',),
'bambuser': ('bambus',),
'bambusbjørn': ('bambusbjørn',),
'bambusbjørnen': ('bambusbjørn',),
'bambusbjørnene': ('bambusbjørn',),
'bambusbjørner': ('bambusbjørn',),
'bambusrør': ('bambusrør',),
'bambusrøra': ('bambusrør',),
'bambusrørene': ('bambusrør',),
'bambusrøret': ('bambusrør',),
'bambusskott': ('bambusskott',),
'bambusskotta': ('bambusskott',),
'bambusskottene': ('bambusskott',),
'bambusskottet': ('bambusskott',),
'bambusskudd': ('bambusskudd',),
'bambusskudda': ('bambusskudd',),
'bambusskuddene': ('bambusskudd',),
'bambusskuddet': ('bambusskudd',),
'bambusteppa': ('bambusteppe',),
'bambusteppe': ('bambusteppe',),
'bambusteppene': ('bambusteppe',),
'bambustepper': ('bambusteppe',),
'bambusteppet': ('bambusteppe',),
'bamse': ('bamse',),
'bamsen': ('bamse',),
'bamsene': ('bamse',),
'bamser': ('bamse',),
'banalitet': ('banalitet',),
'banaliteten': ('banalitet',),
'banalitetene': ('banalitet',),
'banaliteter': ('banalitet',),
'banan': ('banan',),
'bananen': ('banan',),
'bananene': ('banan',),
'bananer': ('banan',),
'bananflua': ('bananflue',),
'bananflue': ('bananflue',),
'bananfluen': ('bananflue',),
'bananfluene': ('bananflue',),
'bananfluer': ('bananflue',),
'bananmodneri': ('bananmodneri',),
'bananmodneria': ('bananmodneri',),
'bananmodneriene': ('bananmodneri',),
'bananmodnerier': ('bananmodneri',),
'bananmodneriet': ('bananmodneri',),
'bananplantasje': ('bananplantasje',),
'bananplantasjen': ('bananplantasje',),
'bananplantasjene': ('bananplantasje',),
'bananplantasjer': ('bananplantasje',),
'bananplanta': ('bananplante',),
'bananplante': ('bananplante',),
'bananplanten': ('bananplante',),
'bananplantene': ('bananplante',),
'bananplanter': ('bananplante',),
'bananplugg': ('bananplugg',),
'bananpluggen': ('bananplugg',),
'bananpluggene': ('bananplugg',),
'bananplugger': ('bananplugg',),
'bananrepublikk': ('bananrepublikk',),
'bananrepublikken': ('bananrepublikk',),
'bananrepublikkene': ('bananrepublikk',),
'bananrepublikker': ('bananrepublikk',),
'bananskal': ('bananskal',),
'bananskala': ('bananskal',),
'bananskalene': ('bananskal',),
'bananskalet': ('bananskal',),
'bananskall': ('bananskall',),
'bananskalla': ('bananskall',),
'bananskallene': ('bananskall',),
'bananskallet': ('bananskall',),
'banansplitt': ('banansplitt',),
'banansplitten': ('banansplitt',),
'banansplittene': ('banansplitt',),
'banansplitter': ('banansplitt',),
'bananstikker': ('bananstikker',),
'bananstikkere': ('bananstikker',),
'bananstikkeren': ('bananstikker',),
'bananstikkerer': ('bananstikker',),
'bananstikkerne': ('bananstikker',),
'band': ('band',),
'banda': ('band',),
'bandene': ('band',),
'bandet': ('band',),
'band': ('band',),
'banda': ('band',),
'bandene': ('band',),
'bandet': ('band',),
'bandasje': ('bandasje',),
'bandasjen': ('bandasje',),
'bandasjene': ('bandasje',),
'bandasjer': ('bandasje',),
'bandasjist': ('bandasjist',),
'bandasjisten': ('bandasjist',),
'bandasjistene': ('bandasjist',),
'bandasjister': ('bandasjist',),
'bandby': ('bandby',),
'bandbyen': ('bandby',),
'bandbyene': ('bandby',),
'bandbyer': ('bandby',),
'bande': ('bande',),
'banden': ('bande',),
'bandene': ('bande',),
'bander': ('bande',),
'bandefører': ('bandefører',),
'bandeførere': ('bandefører',),
'bandeføreren': ('bandefører',),
'bandeførerer': ('bandefører',),
'bandeførerne': ('bandefører',),
'bandemedlem': ('bandemedlem',),
'bandemedlemma': ('bandemedlem',),
'bandemedlemmene': ('bandemedlem',),
'bandemedlemmer': ('bandemedlem',),
'bandemedlemmet': ('bandemedlem',),
'bandhund': ('bandhund',),
'bandhunden': ('bandhund',),
'bandhundene': ('bandhund',),
'bandhunder': ('bandhund',),
'banditt': ('banditt',),
'banditten': ('banditt',),
'bandittene': ('banditt',),
'banditter': ('banditt',),
'bandjern': ('bandjern',),
'bandjerna': ('bandjern',),
'bandjernene': ('bandjern',),
'bandjernet': ('bandjern',),
'bandkniv': ('bandkniv',),
'bandkniven': ('bandkniv',),
'bandknivene': ('bandkniv',),
'bandkniver': ('bandkniv',),
'bandolær': ('bandolær',),
'bandolæra': ('bandolær',),
'bandolærene': ('bandolær',),
'bandolærer': ('bandolær',),
'bandolæret': ('bandolær',),
'bandopptaker': ('bandopptaker',),
'bandopptakere': ('bandopptaker',),
'bandopptakeren': ('bandopptaker',),
'bandopptakerer': ('bandopptaker',),
'bandopptakerne': ('bandopptaker',),
'bandsalat': ('bandsalat',),
'bandsalaten': ('bandsalat',),
'bandsalatene': ('bandsalat',),
'bandsalater': ('bandsalat',),
'bandspeller': ('bandspeller',),
'bandspellere': ('bandspeller',),
'bandspelleren': ('bandspeller',),
'bandspellerer': ('bandspeller',),
'bandspellerne': ('bandspeller',),
'bandspiller': ('bandspiller',),
'bandspillere': ('bandspiller',),
'bandspilleren': ('bandspiller',),
'bandspillerer': ('bandspiller',),
'bandspillerne': ('bandspiller',),
'bandstokk': ('bandstokk',),
'bandstokken': ('bandstokk',),
'bandstokkene': ('bandstokk',),
'bandstokker': ('bandstokk',),
'bandstål': ('bandstål',),
'bandståla': ('bandstål',),
'bandstålene': ('bandstål',),
'bandstålet': ('bandstål',),
'bandtvang': ('bandtvang',),
'bandtvangen': ('bandtvang',),
'bandtvangene': ('bandtvang',),
'bandtvanger': ('bandtvang',),
'bandy': ('bandy',),
'bandyen': ('bandy',),
'bandyene': ('bandy',),
'bandyer': ('bandy',),
'bandyball': ('bandyball',),
'bandyballen': ('bandyball',),
'bandyballene': ('bandyball',),
'bandyballer': ('bandyball',),
'bandykølla': ('bandykølle',),
'bandykølle': ('bandykølle',),
'bandykøllen': ('bandykølle',),
'bandykøllene': ('bandykølle',),
'bandykøller': ('bandykølle',),
'bandylag': ('bandylag',),
'bandylaga': ('bandylag',),
'bandylagene': ('bandylag',),
'bandylaget': ('bandylag',),
'banebryter': ('banebryter',),
'banebrytere': ('banebryter',),
'banebryteren': ('banebryter',),
'banebryterer': ('banebryter',),
'banebryterne': ('banebryter',),
'banefunksjonær': ('banefunksjonær',),
'banefunksjonæren': ('banefunksjonær',),
'banefunksjonærene': ('banefunksjonær',),
'banefunksjonærer': ('banefunksjonær',),
'banehalvdel': ('banehalvdel',),
'banehalvdelen': ('banehalvdel',),
'banehalvdelene': ('banehalvdel',),
'banehalvdeler': ('banehalvdel',),
'banehogg': ('banehogg',),
'banehogga': ('banehogg',),
'banehoggene': ('banehogg',),
'banehogget': ('banehogg',),
'banehugg': ('banehugg',),
'banehugga': ('banehugg',),
'banehuggene': ('banehugg',),
'banehugget': ('banehugg',),
'banelegema': ('banelegeme',),
'banelegeme': ('banelegeme',),
'banelegemene': ('banelegeme',),
'banelegemer': ('banelegeme',),
'banelegemet': ('banelegeme',),
'banemann': ('banemann',),
'banemannen': ('banemann',),
'banemenn': ('banemann',),
'banemennene': ('banemann',),
'banemann': ('banemann',),
'banemannen': ('banemann',),
'banemenn': ('banemann',),
'banemennene': ('banemann',),
'banemannskap': ('banemannskap',),
'banemannskapa': ('banemannskap',),
'banemannskapene': ('banemannskap',),
'banemannskaper': ('banemannskap',),
'banemannskapet': ('banemannskap',),
'banemester': ('banemester',),
'banemestere': ('banemester',),
'banemesteren': ('banemester',),
'banemesterer': ('banemester',),
'banemesterne': ('banemester',),
'banemestre': ('banemester',),
'banemestrene': ('banemester',),
'banemestrer': ('banemester',),
'banerekord': ('banerekord',),
'banerekorden': ('banerekord',),
'banerekordene': ('banerekord',),
'banerekorder': ('banerekord',),
'banesår': ('banesår',),
'banesåra': ('banesår',),
'banesårene': ('banesår',),
'banesåret': ('banesår',),
'banevokter': ('banevokter',),
'banevoktere': ('banevokter',),
'banevokteren': ('banevokter',),
'banevokterer': ('banevokter',),
'banevokterne': ('banevokter',),
'bangladesher': ('bangladesher',),
'bangladeshere': ('bangladesher',),
'bangladesheren': ('bangladesher',),
'bangladesherer': ('bangladesher',),
'bangladesherne': ('bangladesher',),
'banjer': ('banjer',),
'banjere': ('banjer',),
'banjeren': ('banjer',),
'banjerer': ('banjer',),
'banjerne': ('banjer',),
'banjerdekk': ('banjerdekk',),
'banjerdekka': ('banjerdekk',),
'banjerdekkene': ('banjerdekk',),
'banjerdekket': ('banjerdekk',),
'banjo': ('banjo',),
'banjoen': ('banjo',),
'banjoene': ('banjo',),
'banjoer': ('banjo',),
'banjospell': ('banjospell',),
'banjospella': ('banjospell',),
'banjospellene': ('banjospell',),
'banjospellet': ('banjospell',),
'banjospeller': ('banjospeller',),
'banjospellere': ('banjospeller',),
'banjospelleren': ('banjospeller',),
'banjospellerer': ('banjospeller',),
'banjospellerne': ('banjospeller',),
'banjospill': ('banjospill',),
'banjospilla': ('banjospill',),
'banjospillene': ('banjospill',),
'banjospillet': ('banjospill',),
'banjospiller': ('banjospiller',),
'banjospillere': ('banjospiller',),
'banjospilleren': ('banjospiller',),
'banjospillerer': ('banjospiller',),
'banjospillerne': ('banjospiller',),
'bank': ('bank',),
'banka': ('bank',),
'bankene': ('bank',),
'banket': ('bank',),
'bankaksept': ('bankaksept',),
'bankaksepten': ('bankaksept',),
'bankakseptene': ('bankaksept',),
'bankaksepter': ('bankaksept',),
'bankautomat': ('bankautomat',),
'bankautomaten': ('bankautomat',),
'bankautomatene': ('bankautomat',),
'bankautomater': ('bankautomat',),
'bankboks': ('bankboks',),
'bankboksen': ('bankboks',),
'bankboksene': ('bankboks',),
'bankbokser': ('bankboks',),
'bankdireksjon': ('bankdireksjon',),
'bankdireksjonen': ('bankdireksjon',),
'bankdireksjonene': ('bankdireksjon',),
'bankdireksjoner': ('bankdireksjon',),
'bankdirektør': ('bankdirektør',),
'bankdirektøren': ('bankdirektør',),
'bankdirektørene': ('bankdirektør',),
'bankdirektører': ('bankdirektør',),
'banke': ('banke',),
'banken': ('banke',),
'bankene': ('banke',),
'banker': ('banke',),
'bankebiff': ('bankebiff',),
'bankebiffen': ('bankebiff',),
'bankebiffene': ('bankebiff',),
'bankebiffer': ('bankebiff',),
'bankefasthet': ('bankefasthet',),
'bankefastheta': ('bankefasthet',),
'bankefastheten': ('bankefasthet',),
'bankefasthetene': ('bankefasthet',),
'bankefastheter': ('bankefasthet',),
'bankefisk': ('bankefisk',),
'bankefisken': ('bankefisk',),
'bankefiskene': ('bankefisk',),
'bankefisker': ('bankefisk',),
'bankefiska': ('bankefiske',),
'bankefiske': ('bankefiske',),
'bankefiskene': ('bankefiske',),
'bankefisker': ('bankefiske',),
'bankefisket': ('bankefiske',),
'bankefisker': ('bankefisker',),
'bankefiskere': ('bankefisker',),
'bankefiskeren': ('bankefisker',),
'bankefiskerer': ('bankefisker',),
'bankefiskerne': ('bankefisker',),
'bankekjøtt': ('bankekjøtt',),
'bankekjøtta': ('bankekjøtt',),
'bankekjøttene': ('bankekjøtt',),
'bankekjøttet': ('bankekjøtt',),
'bankemat': ('bankemat',),
'bankematen': ('bankemat',),
'bankematene': ('bankemat',),
'bankemater': ('bankemat',),
'banker': ('banker',),
'bankere': ('banker',),
'bankeren': ('banker',),
'bankerer': ('banker',),
'bankerne': ('banker',),
'bankerott': ('bankerott',),
'bankerotten': ('bankerott',),
'bankerottene': ('bankerott',),
'bankerotter': ('bankerott',),
'banketre': ('banketre',),
'banketrea': ('banketre',),
'banketreet': ('banketre',),
'banketrær': ('banketre',),
'banketrærne': ('banketre',),
'bankett': ('bankett',),
'banketten': ('bankett',),
'bankettene': ('bankett',),
'banketter': ('bankett',),
'bankett': ('bankett',),
'banketten': ('bankett',),
'bankettene': ('bankett',),
'banketter': ('bankett',),
'bankfilial': ('bankfilial',),
'bankfilialen': ('bankfilial',),
'bankfilialene': ('bankfilial',),
'bankfilialer': ('bankfilial',),
'bankfiska': ('bankfiske',),
'bankfiske': ('bankfiske',),
'bankfiskene': ('bankfiske',),
'bankfisker': ('bankfiske',),
'bankfisket': ('bankfiske',),
'bankfisker': ('bankfisker',),
'bankfiskere': ('bankfisker',),
'bankfiskeren': ('bankfisker',),
'bankfiskerer': ('bankfisker',),
'bankfiskerne': ('bankfisker',),
'bankforbindelse': ('bankforbindelse',),
'bankforbindelsen': ('bankforbindelse',),
'bankforbindelsene': ('bankforbindelse',),
'bankforbindelser': ('bankforbindelse',),
'bankfunksjonær': ('bankfunksjonær',),
'bankfunksjonæren': ('bankfunksjonær',),
'bankfunksjonærene': ('bankfunksjonær',),
'bankfunksjonærer': ('bankfunksjonær',),
'bankgiro': ('bankgiro',),
'bankgiroen': ('bankgiro',),
'bankgiroene': ('bankgiro',),
'bankgiroer': ('bankgiro',),
'bankgirokonti': ('bankgirokonto',),
'bankgirokontiene': ('bankgirokonto',),
'bankgirokonto': ('bankgirokonto',),
'bankgirokontoen': ('bankgirokonto',),
'bankgirokontoene': ('bankgirokonto',),
'bankgirokontoer': ('bankgirokonto',),
'bankgjeld': ('bankgjeld',),
'bankgjelda': ('bankgjeld',),
'bankgjelden': ('bankgjeld',),
'bankgjeldene': ('bankgjeld',),
'bankgjelder': ('bankgjeld',),
'bankhvelv': ('bankhvelv',),
'bankhvelva': ('bankhvelv',),
'bankhvelvene': ('bankhvelv',),
'bankhvelvet': ('bankhvelv',),
'bankier': ('bankier',),
'bankieren': ('bankier',),
'bankierene': ('bankier',),
'bankierer': ('bankier',),
'bankierfirma': ('bankierfirma',),
'bankierfirmaene': ('bankierfirma',),
'bankierfirmaer': ('bankierfirma',),
'bankierfirmaet': ('bankierfirma',),
'bankierprovisjon': ('bankierprovisjon',),
'bankierprovisjonen': ('bankierprovisjon',),
'bankierprovisjonene': ('bankierprovisjon',),
'bankierprovisjoner': ('bankierprovisjon',),
'bankinnskott': ('bankinnskott',),
'bankinnskotta': ('bankinnskott',),
'bankinnskottene': ('bankinnskott',),
'bankinnskottet': ('bankinnskott',),
'bankinnskudd': ('bankinnskudd',),
'bankinnskudda': ('bankinnskudd',),
'bankinnskuddene': ('bankinnskudd',),
'bankinnskuddet': ('bankinnskudd',),
'bankinspeksjon': ('bankinspeksjon',),
'bankinspeksjonen': ('bankinspeksjon',),
'bankinspeksjonene': ('bankinspeksjon',),
'bankinspeksjoner': ('bankinspeksjon',),
'bankkasserer': ('bankkasserer',),
'bankkasserere': ('bankkasserer',),
'bankkassereren': ('bankkasserer',),
'bankkassererer': ('bankkasserer',),
'bankkassererne': ('bankkasserer',),
'bankkonti': ('bankkonto',),
'bankkontiene': ('bankkonto',),
'bankkonto': ('bankkonto',),
'bankkontoen': ('bankkonto',),
'bankkontoene': ('bankkonto',),
'bankkontoer': ('bankkonto',),
'bankkreditt': ('bankkreditt',),
'bankkreditten': ('bankkreditt',),
'bankkredittene': ('bankkreditt',),
'bankkreditter': ('bankkreditt',),
'bankkunde': ('bankkunde',),
'bankkunden': ('bankkunde',),
'bankkundene': ('bankkunde',),
'bankkunder': ('bankkunde',),
'banklån': ('banklån',),
'banklåna': ('banklån',),
'banklånene': ('banklån',),
'banklånet': ('banklån',),
'banko': ('banko',),
'bankoen': ('banko',),
'bankoene': ('banko',),
'bankoer': ('banko',),
'bankobrev': ('bankobrev',),
'bankobreva': ('bankobrev',),
'bankobrevene': ('bankobrev',),
'bankobrever': ('bankobrev',),
'bankobrevet': ('bankobrev',),
'bankokonvolutt': ('bankokonvolutt',),
'bankokonvolutten': ('bankokonvolutt',),
'bankokonvoluttene': ('bankokonvolutt',),
'bankokonvolutter': ('bankokonvolutt',),
'bankopost': ('bankopost',),
'bankoposten': ('bankopost',),
'bankopostene': ('bankopost',),
'bankoposter': ('bankopost',),
'bankoverføring': ('bankoverføring',),
'bankoverføringa': ('bankoverføring',),
'bankoverføringen': ('bankoverføring',),
'bankoverføringene': ('bankoverføring',),
'bankoverføringer': ('bankoverføring',),
'bankpolitikk': ('bankpolitikk',),
'bankpolitikken': ('bankpolitikk',),
'bankpolitikkene': ('bankpolitikk',),
'bankpolitikker': ('bankpolitikk',),
'bankran': ('bankran',),
'bankrana': ('bankran',),
'bankranene': ('bankran',),
'bankranet': ('bankran',),
'bankremisse': ('bankremisse',),
'bankremissen': ('bankremisse',),
'bankremissene': ('bankremisse',),
'bankremisser': ('bankremisse',),
'bankør': ('bankør',),
'bankøren': ('bankør',),
'bankørene': ('bankør',),
'bankører': ('bankør',),
'bann': ('bann',),
'banna': ('bann',),
'bannene': ('bann',),
'bannet': ('bann',),
'bannbrev': ('bannbrev',),
'bannbreva': ('bannbrev',),
'bannbrevene': ('bannbrev',),
'bannbrever': ('bannbrev',),
'bannbrevet': ('bannbrev',),
'bannbulle': ('bannbulle',),
'bannbullen': ('bannbulle',),
'bannbullene': ('bannbulle',),
'bannbuller': ('bannbulle',),
'banneord': ('banneord',),
'banneorda': ('banneord',),
'banneordene': ('banneord',),
'banneordet': ('banneord',),
'banner': ('banner',),
'bannera': ('banner',),
'bannere': ('banner',),
'banneret': ('banner',),
'bannerne': ('banner',),
'bannerbærer': ('bannerbærer',),
'bannerbærere': ('bannerbærer',),
'bannerbæreren': ('bannerbærer',),
'bannerbærerer': ('bannerbærer',),
'bannerbærerne': ('bannerbærer',),
'bannerfører': ('bannerfører',),
'bannerførere': ('bannerfører',),
'bannerføreren': ('bannerfører',),
'bannerførerer': ('bannerfører',),
'bannerførerne': ('bannerfører',),
'banning': ('banning',),
'banninga': ('banning',),
'banningen': ('banning',),
'banningene': ('banning',),
'banninger': ('banning',),
'bannlysing': ('bannlysing',),
'bannlysinga': ('bannlysing',),
'bannlysingen': ('bannlysing',),
'bannlysingene': ('bannlysing',),
'bannlysinger': ('bannlysing',),
'bannskap': ('bannskap',),
'bannskapen': ('bannskap',),
'bannskapene': ('bannskap',),
'bannskaper': ('bannskap',),
'bannstråle': ('bannstråle',),
'bannstrålen': ('bannstråle',),
'bannstrålene': ('bannstråle',),
'bannstråler': ('bannstråle',),
'bantamer': ('bantamer',),
'bantamere': ('bantamer',),
'bantameren': ('bantamer',),
'bantamerer': ('bantamer',),
'bantamerne': ('bantamer',),
'bantamhøns': ('bantamhøns',),
'bantamhønsa': ('bantamhøns',),
'bantamhønsene': ('bantamhøns',),
'bantamhønset': ('bantamhøns',),
'bantamklassa': ('bantamklasse',),
'bantamklasse': ('bantamklasse',),
'bantamklassen': ('bantamklasse',),
'bantamklassene': ('bantamklasse',),
'bantamklasser': ('bantamklasse',),
'bantamvekt': ('bantamvekt',),
'bantamvekta': ('bantamvekt',),
'bantamvekten': ('bantamvekt',),
'bantamvektene': ('bantamvekt',),
'bantamvekter': ('bantamvekt',),
'bantu': ('bantu',),
'bantuen': ('bantu',),
'bantuene': ('bantu',),
'bantuer': ('bantu',),
'bantu': ('bantu',),
'bantuneger': ('bantuneger',),
'bantunegere': ('bantuneger',),
'bantunegeren': ('bantuneger',),
'bantunegerer': ('bantuneger',),
'bantunegerne': ('bantuneger',),
'bantunegre': ('bantuneger',),
'bantunegrene': ('bantuneger',),
'bantunegrer': ('bantuneger',),
'bantuspråk': ('bantuspråk',),
'bantuspråka': ('bantuspråk',),
'bantuspråkene': ('bantuspråk',),
'bantuspråket': ('bantuspråk',),
'bantustan': ('bantustan',),
'bantustanen': ('bantustan',),
'bantustanene': ('bantustan',),
'bantustaner': ('bantustan',),
'baptisme': ('baptisme',),
'baptismen': ('baptisme',),
'baptismene': ('baptisme',),
'baptismer': ('baptisme',),
'baptist': ('baptist',),
'baptisten': ('baptist',),
'baptistene': ('baptist',),
'baptister': ('baptist',),
'baptistkirka': ('baptistkirke',),
'baptistkirke': ('baptistkirke',),
'baptistkirken': ('baptistkirke',),
'baptistkirkene': ('baptistkirke',),
'baptistkirker': ('baptistkirke',),
'baptistkjerka': ('baptistkjerke',),
'baptistkjerke': ('baptistkjerke',),
'baptistkjerken': ('baptistkjerke',),
'baptistkjerkene': ('baptistkjerke',),
'baptistkjerker': ('baptistkjerke',),
'baptistmenighet': ('baptistmenighet',),
'baptistmenigheta': ('baptistmenighet',),
'baptistmenigheten': ('baptistmenighet',),
'baptistmenighetene': ('baptistmenighet',),
'baptistmenigheter': ('baptistmenighet',),
'baptistprest': ('baptistprest',),
'baptistpresten': ('baptistprest',),
'baptistprestene': ('baptistprest',),
'baptistprester': ('baptistprest',),
'baptistsamfunn': ('baptistsamfunn',),
'baptistsamfunna': ('baptistsamfunn',),
'baptistsamfunnene': ('baptistsamfunn',),
'baptistsamfunnet': ('baptistsamfunn',),
'bar': ('bar',),
'baren': ('bar',),
'barene': ('bar',),
'barer': ('bar',),
'bar': ('bar',),
'baren': ('bar',),
'barene': ('bar',),
'barer': ('bar',),
'bar': ('bar',),
'baren': ('bar',),
'barene': ('bar',),
'bar': ('bar',),
'bara': ('bar',),
'barene': ('bar',),
'baret': ('bar',),
'bar': ('bar',),
'bara': ('bar',),
'barene': ('bar',),
'baret': ('bar',),
'barbader': ('barbader',),
'barbadere': ('barbader',),
'barbaderen': ('barbader',),
'barbaderer': ('barbader',),
'barbaderne': ('barbader',),
'barbadier': ('barbadier',),
'barbadiere': ('barbadier',),
'barbadieren': ('barbadier',),
'barbadierer': ('barbadier',),
'barbadierne': ('barbadier',),
'barbar': ('barbar',),
'barbaren': ('barbar',),
'barbarene': ('barbar',),
'barbarer': ('barbar',),
'barbari': ('barbari',),
'barbaria': ('barbari',),
'barbariene': ('barbari',),
'barbariet': ('barbari',),
'barbarisme': ('barbarisme',),
'barbarismen': ('barbarisme',),
'barbarismene': ('barbarisme',),
'barbarismer': ('barbarisme',),
'barbecue': ('barbecue',),
'barbecuen': ('barbecue',),
'barbecuene': ('barbecue',),
'barbecuer': ('barbecue',),
'barber': ('barber',),
'barberen': ('barber',),
'barberene': ('barber',),
'barberer': ('barber',),
'barberblad': ('barberblad',),
'barberblada': ('barberblad',),
'barberbladene': ('barberblad',),
'barberblader': ('barberblad',),
'barberbladet': ('barberblad',),
'barberer': ('barberer',),
'barberere': ('barberer',),
'barbereren': ('barberer',),
'barbererer': ('barberer',),
'barbererne': ('barberer',),
'barberhøvel': ('barberhøvel',),
'barberhøvelen': ('barberhøvel',),
'barberhøvlene': ('barberhøvel',),
'barberhøvler': ('barberhøvel',),
'barberkniv': ('barberkniv',),
'barberkniven': ('barberkniv',),
'barberknivene': ('barberkniv',),
'barberkniver': ('barberkniv',),
'barberkost': ('barberkost',),
'barberkosten': ('barberkost',),
'barberkostene': ('barberkost',),
'barberkoster': ('barberkost',),
'barberkrem': ('barberkrem',),
'barberkremen': ('barberkrem',),
'barberkremene': ('barberkrem',),
'barberkremer': ('barberkrem',),
'barbermaskin': ('barbermaskin',),
'barbermaskina': ('barbermaskin',),
'barbermaskinen': ('barbermaskin',),
'barbermaskinene': ('barbermaskin',),
'barbermaskiner': ('barbermaskin',),
'barbersalong': ('barbersalong',),
'barbersalongen': ('barbersalong',),
'barbersalongene': ('barbersalong',),
'barbersalonger': ('barbersalong',),
'barberskum': ('barberskum',),
'barberskumma': ('barberskum',),
'barberskummene': ('barberskum',),
'barberskummet': ('barberskum',),
'barbersåpa': ('barbersåpe',),
'barbersåpe': ('barbersåpe',),
'barbersåpen': ('barbersåpe',),
'barbersåpene': ('barbersåpe',),
'barbersåper': ('barbersåpe',),
'barde': ('barde',),
'barden': ('barde',),
'bardene': ('barde',),
'barder': ('barde',),
'bardehval': ('bardehval',),
'bardehvalen': ('bardehval',),
'bardehvalene': ('bardehval',),
'bardehvaler': ('bardehval',),
'bardekval': ('bardekval',),
'bardekvalen': ('bardekval',),
'bardekvalene': ('bardekval',),
'bardekvaler': ('bardekval',),
'bardisk': ('bardisk',),
'bardisken': ('bardisk',),
'bardiskene': ('bardisk',),
'bardisker': ('bardisk',),
'bardun': ('bardun',),
'bardunen': ('bardun',),
'bardunene': ('bardun',),
'barduner': ('bardun',),
'bardunkrok': ('bardunkrok',),
'bardunkroken': ('bardunkrok',),
'bardunkrokene': ('bardunkrok',),
'bardunkroker': ('bardunkrok',),
'bardunstreng': ('bardunstreng',),
'bardunstrengen': ('bardunstreng',),
'bardunstrengene': ('bardunstreng',),
'bardunstrenger': ('bardunstreng',),
'barett': ('barett',),
'baretten': ('barett',),
'barettene': ('barett',),
'baretter': ('barett',),
'barfotdans': ('barfotdans',),
'barfotdansen': ('barfotdans',),
'barfotdansene': ('barfotdans',),
'barfotdanser': ('barfotdans',),
'barfotlege': ('barfotlege',),
'barfotlegen': ('barfotlege',),
'barfotlegene': ('barfotlege',),
'barfotleger': ('barfotlege',),
'barfotmunk': ('barfotmunk',),
'barfotmunken': ('barfotmunk',),
'barfotmunkene': ('barfotmunk',),
'barfotmunker': ('barfotmunk',),
'barfotnonna': ('barfotnonne',),
'barfotnonne': ('barfotnonne',),
'barfotnonnen': ('barfotnonne',),
'barfotnonnene': ('barfotnonne',),
'barfotnonner': ('barfotnonne',),
'barfrost': ('barfrost',),
'barfrosten': ('barfrost',),
'barfrostene': ('barfrost',),
'barfroster': ('barfrost',),
'barhytta': ('barhytte',),
'barhytte': ('barhytte',),
'barhytten': ('barhytte',),
'barhyttene': ('barhytte',),
'barhytter': ('barhytte',),
'barium': ('barium',),
'bariuma': ('barium',),
'bariumene': ('barium',),
'bariumet': ('barium',),
'barkarole': ('barkarole',),
'barkarolen': ('barkarole',),
'barkarolene': ('barkarole',),
'barkaroler': ('barkarole',),
'barkass': ('barkass',),
'barkassen': ('barkass',),
'barkassene': ('barkass',),
'barkasser': ('barkass',),
'barkasse': ('barkasse',),
'barkassen': ('barkasse',),
'barkassene': ('barkasse',),
'barkasser': ('barkasse',),
'barkbille': ('barkbille',),
'barkbillen': ('barkbille',),
'barkbillene': ('barkbille',),
'barkbiller': ('barkbille',),
'barkbåt': ('barkbåt',),
'barkbåten': ('barkbåt',),
'barkbåtene': ('barkbåt',),
'barkbåter': ('barkbåt',),
'barkebrød': ('barkebrød',),
'barkebrøda': ('barkebrød',),
'barkebrødene': ('barkebrød',),
'barkebrødet': ('barkebrød',),
'barkebåt': ('barkebåt',),
'barkebåten': ('barkebåt',),
'barkebåtene': ('barkebåt',),
'barkebåter': ('barkebåt',),
'barkeeper': ('barkeeper',),
'barkeepere': ('barkeeper',),
'barkeeperen': ('barkeeper',),
'barkeeperer': ('barkeeper',),
'barkeeperne': ('barkeeper',),
'barkemaskin': ('barkemaskin',),
'barkemaskina': ('barkemaskin',),
'barkemaskinen': ('barkemaskin',),
'barkemaskinene': ('barkemaskin',),
'barkemaskiner': ('barkemaskin',),
'barkespade': ('barkespade',),
'barkespaden': ('barkespade',),
'barkespadene': ('barkespade',),
'barkespader': ('barkespade',),
'barkett': ('barkett',),
'barketten': ('barkett',),
'barkettene': ('barkett',),
'barketter': ('barkett',),
'barkrakk': ('barkrakk',),
'barkrakken': ('barkrakk',),
'barkrakkene': ('barkrakk',),
'barkrakker': ('barkrakk',),
'barkvist': ('barkvist',),
'barkvisten': ('barkvist',),
'barkvistene': ('barkvist',),
'barkvister': ('barkvist',),
'barlind': ('barlind',),
'barlinda': ('barlind',),
'barlinden': ('barlind',),
'barlindene': ('barlind',),
'barlinder': ('barlind',),
'barlindfamilie': ('barlindfamilie',),
'barlindfamilien': ('barlindfamilie',),
'barlindfamiliene': ('barlindfamilie',),
'barlindfamilier': ('barlindfamilie',),
'barm': ('barm',),
'barmen': ('barm',),
'barmene': ('barm',),
'barmer': ('barm',),
'barmark': ('barmark',),
'barmarka': ('barmark',),
'barmarken': ('barmark',),
'barmarkene': ('barmark',),
'barmarker': ('barmark',),
'barmarksamling': ('barmarksamling',),
'barmarksamlinga': ('barmarksamling',),
'barmarksamlingen': ('barmarksamling',),
'barmarksamlingene': ('barmarksamling',),
'barmarksamlinger': ('barmarksamling',),
'barmhjertighet': ('barmhjertighet',),
'barmhjertigheta': ('barmhjertighet',),
'barmhjertigheten': ('barmhjertighet',),
'barmhjertighetene': ('barmhjertighet',),
'barmhjertigheter': ('barmhjertighet',),
'barmhjertighetsdrap': ('barmhjertighetsdrap',),
'barmhjertighetsdrapa': ('barmhjertighetsdrap',),
'barmhjertighetsdrapene': ('barmhjertighetsdrap',),
'barmhjertighetsdrapet': ('barmhjertighetsdrap',),
'barmhjertighetsgjerning': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerninga': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerningen': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerningene': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerninger': ('barmhjertighetsgjerning',),
'barn': ('barn',),
'barna': ('barn',),
'barnene': ('barn',),
'barnet': ('barn',),
'barndom': ('barndom',),
'barndommen': ('barndom',),
'barndommene': ('barndom',),
'barndommer': ('barndom',),
'barndomsdrøm': ('barndomsdrøm',),
'barndomsdrømmen': ('barndomsdrøm',),
'barndomsdrømmene': ('barndomsdrøm',),
'barndomsdrømmer': ('barndomsdrøm',),
'barndomsheim': ('barndomsheim',),
'barndomsheimen': ('barndomsheim',),
'barndomsheimene': ('barndomsheim',),
'barndomsheimer': ('barndomsheim',),
'barndomshjem': ('barndomshjem',),
'barndomshjemma': ('barndomshjem',),
'barndomshjemmene': ('barndomshjem',),
'barndomshjemmet': ('barndomshjem',),
'barndomsminna': ('barndomsminne',),
'barndomsminne': ('barndomsminne',),
'barndomsminnene': ('barndomsminne',),
'barndomsminner': ('barndomsminne',),
'barndomsminnet': ('barndomsminne',),
'barndomstid': ('barndomstid',),
'barndomstida': ('barndomstid',),
'barndomstiden': ('barndomstid',),
'barndomstidene': ('barndomstid',),
'barndomstider': ('barndomstid',),
'barndomsvenn': ('barndomsvenn',),
'barndomsvennen': ('barndomsvenn',),
'barndomsvennene': ('barndomsvenn',),
'barndomsvenner': ('barndomsvenn',),
'barndomsvenninna': ('barndomsvenninne',),
'barndomsvenninne': ('barndomsvenninne',),
'barndomsvenninnen': ('barndomsvenninne',),
'barndomsvenninnene': ('barndomsvenninne',),
'barndomsvenninner': ('barndomsvenninne',),
'barnearbeid': ('barnearbeid',),
'barnearbeida': ('barnearbeid',),
'barnearbeidene': ('barnearbeid',),
'barnearbeider': ('barnearbeid',),
'barnearbeidet': ('barnearbeid',),
'barnebarn': ('barnebarn',),
'barnebarna': ('barnebarn',),
'barnebarnene': ('barnebarn',),
'barnebarnet': ('barnebarn',),
'barnebegrensning': ('barnebegrensning',),
'barnebegrensninga': ('barnebegrensning',),
'barnebegrensningen': ('barnebegrensning',),
'barnebegrensningene': ('barnebegrensning',),
'barnebegrensninger': ('barnebegrensning',),
'barnebidrag': ('barnebidrag',),
'barnebidraga': ('barnebidrag',),
'barnebidragene': ('barnebidrag',),
'barnebidraget': ('barnebidrag',),
'barnebillett': ('barnebillett',),
'barnebilletten': ('barnebillett',),
'barnebillettene': ('barnebillett',),
'barnebilletter': ('barnebillett',),
'barneblad': ('barneblad',),
'barneblada': ('barneblad',),
'barnebladene': ('barneblad',),
'barneblader': ('barneblad',),
'barnebladet': ('barneblad',),
'barnedåp': ('barnedåp',),
'barnedåpen': ('barnedåp',),
'barnedåpene': ('barnedåp',),
'barnedåper': ('barnedåp',),
'barnedødelighet': ('barnedødelighet',),
'barnedødeligheta': ('barnedødelighet',),
'barnedødeligheten': ('barnedødelighet',),
'barnedødelighetene': ('barnedødelighet',),
'barnedødeligheter': ('barnedødelighet',),
'barnefamilie': ('barnefamilie',),
'barnefamilien': ('barnefamilie',),
'barnefamiliene': ('barnefamilie',),
'barnefamilier': ('barnefamilie',),
'barnefarsak': ('barnefarsak',),
'barnefarsaka': ('barnefarsak',),
'barnefarsaken': ('barnefarsak',),
'barnefarsakene': ('barnefarsak',),
'barnefarsaker': ('barnefarsak',),
'barnefarssak': ('barnefarssak',),
'barnefarssaka': ('barnefarssak',),
'barnefarssaken': ('barnefarssak',),
'barnefarssakene': ('barnefarssak',),
'barnefarssaker': ('barnefarssak',),
'barneflokk': ('barneflokk',),
'barneflokken': ('barneflokk',),
'barneflokkene': ('barneflokk',),
'barneflokker': ('barneflokk',),
'barneforestilling': ('barneforestilling',),
'barneforestillinga': ('barneforestilling',),
'barneforestillingen': ('barneforestilling',),
'barneforestillingene': ('barneforestilling',),
'barneforestillinger': ('barneforestilling',),
'barnehage': ('barnehage',),
'barnehagen': ('barnehage',),
'barnehagene': ('barnehage',),
'barnehager': ('barnehage',),
'barnehagelærer': ('barnehagelærer',),
'barnehagelærere': ('barnehagelærer',),
'barnehagelæreren': ('barnehagelærer',),
'barnehagelærerer': ('barnehagelærer',),
'barnehagelærerne': ('barnehagelærer',),
'barneheim': ('barneheim',),
'barneheimen': ('barneheim',),
'barneheimene': ('barneheim',),
'barneheimer': ('barneheim',),
'barnehjem': ('barnehjem',),
'barnehjemma': ('barnehjem',),
'barnehjemmene': ('barnehjem',),
'barnehjemmet': ('barnehjem',),
'barneklær': ('barneklær',),
'barneklærne': ('barneklær',),
'barnelammelse': ('barnelammelse',),
'barnelammelsen': ('barnelammelse',),
'barnelammelsene': ('barnelammelse',),
'barnelammelser': ('barnelammelse',),
'barnelege': ('barnelege',),
'barnelegen': ('barnelege',),
'barnelegene': ('barnelege',),
'barneleger': ('barnelege',),
'barnelærdom': ('barnelærdom',),
'barnelærdommen': ('barnelærdom',),
'barnelærdommene': ('barnelærdom',),
'barnelærdommer': ('barnelærdom',),
'barnemat': ('barnemat',),
'barnematen': ('barnemat',),
'barnematene': ('barnemat',),
'barnemater': ('barnemat',),
'barnemishandling': ('barnemishandling',),
'barnemishandlinga': ('barnemishandling',),
'barnemishandlingen': ('barnemishandling',),
'barnemishandlingene': ('barnemishandling',),
'barnemishandlinger': ('barnemishandling',),
'barneombud': ('barneombud',),
'barneombuda': ('barneombud',),
'barneombudene': ('barneombud',),
'barneombudet': ('barneombud',),
'barneoppdragelse': ('barneoppdragelse',),
'barneoppdragelsen': ('barneoppdragelse',),
'barneoppdragelsene': ('barneoppdragelse',),
'barneoppdragelser': ('barneoppdragelse',),
'barnepark': ('barnepark',),
'barneparken': ('barnepark',),
'barneparkene': ('barnepark',),
'barneparker': ('barnepark',),
'barneparkering': ('barneparkering',),
'barneparkeringa': ('barneparkering',),
'barneparkeringen': ('barneparkering',),
'barneparkeringene': ('barneparkering',),
'barneparkeringer': ('barneparkering',),
'barnepika': ('barnepike',),
'barnepike': ('barnepike',),
'barnepiken': ('barnepike',),
'barnepikene': ('barnepike',),
'barnepiker': ('barnepike',),
'barnepleia': ('barnepleie',),
'barnepleie': ('barnepleie',),
'barnepleien': ('barnepleie',),
'barnepleiene': ('barnepleie',),
'barnepleier': ('barnepleie',),
'barnepleier': ('barnepleier',),
'barnepleiere': ('barnepleier',),
'barnepleieren': ('barnepleier',),
'barnepleierer': ('barnepleier',),
'barnepleierne': ('barnepleier',),
'barnepsykiatri': ('barnepsykiatri',),
'barnepsykiatrien': ('barnepsykiatri',),
'barnepsykiatriene': ('barnepsykiatri',),
'barnepsykiatrier': ('barnepsykiatri',),
'barnepsykologi': ('barnepsykologi',),
'barnepsykologien': ('barnepsykologi',),
'barnepsykologiene': ('barnepsykologi',),
'barnepsykologier': ('barnepsykologi',),
'barneregla': ('barneregle',),
'barneregle': ('barneregle',),
'barnereglen': ('barneregle',),
'barnereglene': ('barneregle',),
'barneregler': ('barneregle',),
'barnerov': ('barnerov',),
'barnerova': ('barnerov',),
'barnerovene': ('barnerov',),
'barnerovet': ('barnerov',),
'barnerumpa': ('barnerumpe',),
'barnerumpe': ('barnerumpe',),
'barnerumpen': ('barnerumpe',),
'barnerumpene': ('barnerumpe',),
'barnerumper': ('barnerumpe',),
'barnesang': ('barnesang',),
'barnesangen': ('barnesang',),
'barnesangene': ('barnesang',),
'barnesanger': ('barnesang',),
'barneselskap': ('barneselskap',),
'barneselskapa': ('barneselskap',),
'barneselskapene': ('barneselskap',),
'barneselskaper': ('barneselskap',),
'barneselskapet': ('barneselskap',),
'barnesikring': ('barnesikring',),
'barnesikringa': ('barnesikring',),
'barnesikringen': ('barnesikring',),
'barnesikringene': ('barnesikring',),
'barnesikringer': ('barnesikring',),
'barnesjukdom': ('barnesjukdom',),
'barnesjukdommen': ('barnesjukdom',),
'barnesjukdommene': ('barnesjukdom',),
'barnesjukdommer': ('barnesjukdom',),
'barneskei': ('barneskei',),
'barneskeia': ('barneskei',),
'barneskeien': ('barneskei',),
'barneskeiene': ('barneskei',),
'barneskeier': ('barneskei',),
'barneskje': ('barneskje',),
'barneskjea': ('barneskje',),
'barneskjeen': ('barneskje',),
'barneskjeene': ('barneskje',),
'barneskjeer': ('barneskje',),
'barneskole': ('barneskole',),
'barneskolen': ('barneskole',),
'barneskolene': ('barneskole',),
'barneskoler': ('barneskole',),
'barnespråk': ('barnespråk',),
'barnespråka': ('barnespråk',),
'barnespråkene': ('barnespråk',),
'barnespråket': ('barnespråk',),
'barnesull': ('barnesull',),
'barnesullen': ('barnesull',),
'barnesullene': ('barnesull',),
'barnesuller': ('barnesull',),
'barnesykdom': ('barnesykdom',),
'barnesykdommen': ('barnesykdom',),
'barnesykdommene': ('barnesykdom',),
'barnesykdommer': ('barnesykdom',),
'barnesåpa': ('barnesåpe',),
'barnesåpe': ('barnesåpe',),
'barnesåpen': ('barnesåpe',),
'barnesåpene': ('barnesåpe',),
'barnesåper': ('barnesåpe',),
'barnetall': ('barnetall',),
'barnetalla': ('barnetall',),
'barnetallene': ('barnetall',),
'barnetallet': ('barnetall',),
'barnetekka': ('barnetekke',),
'barnetekke': ('barnetekke',),
'barnetekkene': ('barnetekke',),
'barnetekker': ('barnetekke',),
'barnetekket': ('barnetekke',),
'barnetime': ('barnetime',),
'barnetimen': ('barnetime',),
'barnetimene': ('barnetime',),
'barnetimer': ('barnetime',),
'barnetog': ('barnetog',),
'barnetoga': ('barnetog',),
'barnetogene': ('barnetog',),
'barnetoget': ('barnetog',),
'barnetrinn': ('barnetrinn',),
'barnetrinna': ('barnetrinn',),
'barnetrinnene': ('barnetrinn',),
'barnetrinnet': ('barnetrinn',),
'barnetro': ('barnetro',),
'barnetroa': ('barnetro',),
'barnetroen': ('barnetro',),
'barnetroene': ('barnetro',),
'barnetroer': ('barnetro',),
'barnetrygd': ('barnetrygd',),
'barnetrygda': ('barnetrygd',),
'barnetrygden': ('barnetrygd',),
'barnetrygdene': ('barnetrygd',),
'barnetrygder': ('barnetrygd',),
'barnevakt': ('barnevakt',),
'barnevakta': ('barnevakt',),
'barnevakten': ('barnevakt',),
'barnevaktene': ('barnevakt',),
'barnevakter': ('barnevakt',),
'barnevern': ('barnevern',),
'barneverna': ('barnevern',),
'barnevernene': ('barnevern',),
'barnevernet': ('barnevern',),
'barnevernsnemnd': ('barnevernsnemnd',),
'barnevernsnemnda': ('barnevernsnemnd',),
'barnevernsnemnden': ('barnevernsnemnd',),
'barnevernsnemndene': ('barnevernsnemnd',),
'barnevernsnemnder': ('barnevernsnemnd',),
'barnevogn': ('barnevogn',),
'barnevogna': ('barnevogn',),
'barnevognen': ('barnevogn',),
'barnevognene': ('barnevogn',),
'barnevogner': ('barnevogn',),
'barneår': ('barneår',),
'barneåra': ('barneår',),
'barneårene': ('barneår',),
'barneåret': ('barneår',),
'barnsbein': ('barnsbein',),
'barnsben': ('barnsben',),
'barnsbena': ('barnsben',),
'barnsbenene': ('barnsben',),
'barnsbenet': ('barnsben',),
'barnsnød': ('barnsnød',),
'barnsnøda': ('barnsnød',),
'barnsnøden': ('barnsnød',),
'barnsnødene': ('barnsnød',),
'barnsnøder': ('barnsnød',),
'barnål': ('barnål',),
'barnåla': ('barnål',),
'barnålen': ('barnål',),
'barnålene': ('barnål',),
'barnåler': ('barnål',),
'barokk': ('barokk',),
'barokken': ('barokk',),
'barokkene': ('barokk',),
'barokker': ('barokk',),
'barokkbygning': ('barokkbygning',),
'barokkbygninga': ('barokkbygning',),
'barokkbygningen': ('barokkbygning',),
'barokkbygningene': ('barokkbygning',),
'barokkbygninger': ('barokkbygning',),
'barokkmusikk': ('barokkmusikk',),
'barokkmusikken': ('barokkmusikk',),
'barokkmusikkene': ('barokkmusikk',),
'barokkmusikker': ('barokkmusikk',),
'barokkstil': ('barokkstil',),
'barokkstilen': ('barokkstil',),
'barokkstilene': ('barokkstil',),
'barokkstiler': ('barokkstil',),
'barometer': ('barometer',),
'barometeret': ('barometer',),
'barometra': ('barometer',),
'barometre': ('barometer',),
'barometrene': ('barometer',),
'barometret': ('barometer',),
'barometerfall': ('barometerfall',),
'barometerfalla': ('barometerfall',),
'barometerfallene': ('barometerfall',),
'barometerfallet': ('barometerfall',),
'barometerstand': ('barometerstand',),
'barometerstanden': ('barometerstand',),
'barometerstandene': ('barometerstand',),
'barometerstander': ('barometerstand',),
'barometersøyla': ('barometersøyle',),
'barometersøyle': ('barometersøyle',),
'barometersøylen': ('barometersøyle',),
'barometersøylene': ('barometersøyle',),
'barometersøyler': ('barometersøyle',),
'baron': ('baron',),
'baronen': ('baron',),
'baronene': ('baron',),
'baroner': ('baron',),
'baronessa': ('baronesse',),
'baronesse': ('baronesse',),
'baronessen': ('baronesse',),
'baronessene': ('baronesse',),
'baronesser': ('baronesse',),
'baroni': ('baroni',),
'baronia': ('baroni',),
'baroniene': ('baroni',),
'baronier': ('baroni',),
'baroniet': ('baroni',),
'barontitlene': ('barontittel',),
'barontitler': ('barontittel',),
'barontittel': ('barontittel',),
'barontittelen': ('barontittel',),
'baronverdighet': ('baronverdighet',),
'baronverdigheta': ('baronverdighet',),
'baronverdigheten': ('baronverdighet',),
'baronverdighetene': ('baronverdighet',),
'baronverdigheter': ('baronverdighet',),
'barrakuda': ('barrakuda',),
'barrakudaen': ('barrakuda',),
'barrakudaene': ('barrakuda',),
'barrakudaer': ('barrakuda',),
'barre': ('barre',),
'barren': ('barre',),
'barrene': ('barre',),
'barrer': ('barre',),
'barreform': ('barreform',),
'barreforma': ('barreform',),
'barreformen': ('barreform',),
'barreformene': ('barreform',),
'barreformer': ('barreform',),
'barregull': ('barregull',),
'barregulla': ('barregull',),
'barregullene': ('barregull',),
'barregullet': ('barregull',),
'barrel': ('barrel',),
'barrelen': ('barrel',),
'barrelene': ('barrel',),
'barrels': ('barrel',),
'barriere': ('barriere',),
'barrieren': ('barriere',),
'barrierene': ('barriere',),
'barrierer': ('barriere',),
'barriererev': ('barriererev',),
'barrierereva': ('barriererev',),
'barriererevene': ('barriererev',),
'barriererevet': ('barriererev',),
'barrikade': ('barrikade',),
'barrikaden': ('barrikade',),
'barrikadene': ('barrikade',),
'barrikader': ('barrikade',),
'barrikadekjemper': ('barrikadekjemper',),
'barrikadekjempere': ('barrikadekjemper',),
'barrikadekjemperen': ('barrikadekjemper',),
'barrikadekjemperer': ('barrikadekjemper',),
'barrikadekjemperne': ('barrikadekjemper',),
'barsel': ('barsel',),
'barselet': ('barsel',),
'barsla': ('barsel',),
'barslene': ('barsel',),
'barsler': ('barsel',),
'barslet': ('barsel',),
'barselavdeling': ('barselavdeling',),
'barselavdelinga': ('barselavdeling',),
'barselavdelingen': ('barselavdeling',),
'barselavdelingene': ('barselavdeling',),
'barselavdelinger': ('barselavdeling',),
'barselfeber': ('barselfeber',),
'barselfebere': ('barselfeber',),
'barselfeberen': ('barselfeber',),
'barselfeberer': ('barselfeber',),
'barselfeberne': ('barselfeber',),
'barselfebre': ('barselfeber',),
'barselfebrene': ('barselfeber',),
'barselfebrer': ('barselfeber',),
'barselgraut': ('barselgraut',),
'barselgrauten': ('barselgraut',),
'barselgrautene': ('barselgraut',),
'barselgrauter': ('barselgraut',),
'barselgrøt': ('barselgrøt',),
'barselgrøten': ('barselgrøt',),
'barselgrøtene': ('barselgrøt',),
'barselgrøter': ('barselgrøt',),
'barselkrampe': ('barselkrampe',),
'barselkrampen': ('barselkrampe',),
'barselkrampene': ('barselkrampe',),
'barselkramper': ('barselkrampe',),
'barselpengene': ('barselpenger',),
'barselpenger': ('barselpenger',),
'barselseng': ('barselseng',),
'barselsenga': ('barselseng',),
'barselsengen': ('barselseng',),
'barselsengene': ('barselseng',),
'barselsenger': ('barselseng',),
'barselstua': ('barselstue',),
'barselstue': ('barselstue',),
'barselstuen': ('barselstue',),
'barselstuene': ('barselstue',),
'barselstuer': ('barselstue',),
'barselvisitt': ('barselvisitt',),
'barselvisitten': ('barselvisitt',),
'barselvisittene': ('barselvisitt',),
'barselvisitter': ('barselvisitt',),
'barsking': ('barsking',),
'barskingen': ('barsking',),
'barskingene': ('barsking',),
'barskinger': ('barsking',),
'barskog': ('barskog',),
'barskogen': ('barskog',),
'barskogene': ('barskog',),
'barskoger': ('barskog',),
'barskogbelta': ('barskogbelte',),
'barskogbelte': ('barskogbelte',),
'barskogbeltene': ('barskogbelte',),
'barskogbelter': ('barskogbelte',),
'barskogbeltet': ('barskogbelte',),
'barsok': ('barsok',),
'barsoken': ('barsok',),
'barsokene': ('barsok',),
'barsoker': ('barsok',),
'bart': ('bart',),
'barten': ('bart',),
'bartene': ('bart',),
'barter': ('bart',),
'bartender': ('bartender',),
'bartendere': ('bartender',),
'bartenderen': ('bartender',),
'bartenderer': ('bartender',),
'bartenderne': ('bartender',),
'bartolomeusdag': ('bartolomeusdag',),
'bartolomeusdagen': ('bartolomeusdag',),
'bartolomeusdagene': ('bartolomeusdag',),
'bartolomeusdager': ('bartolomeusdag',),
'bartolomeusmess': ('bartolomeusmess',),
'bartolomeusmesse': ('bartolomeusmesse',),
'bartolomeusnatt': ('bartolomeusnatt',),
'bartolomeusnatta': ('bartolomeusnatt',),
'bartolomeusnatten': ('bartolomeusnatt',),
'bartolomeusnettene': ('bartolomeusnatt',),
'bartolomeusnetter': ('bartolomeusnatt',),
'bartre': ('bartre',),
'bartrea': ('bartre',),
'bartreet': ('bartre',),
'bartrær': ('bartre',),
'bartrærne': ('bartre',),
'bartrevirka': ('bartrevirke',),
'bartrevirke': ('bartrevirke',),
'bartrevirkene': ('bartrevirke',),
'bartrevirker': ('bartrevirke',),
'bartrevirket': ('bartrevirke',),
'bartskjær': ('bartskjær',),
'bartskjæren': ('bartskjær',),
'bartskjærene': ('bartskjær',),
'bartskjærer': ('bartskjær',),
'baryton': ('baryton',),
'barytonen': ('baryton',),
'barytonene': ('baryton',),
'barytoner': ('baryton',),
'barytonsaksofon': ('barytonsaksofon',),
'barytonsaksofonen': ('barytonsaksofon',),
'barytonsaksofonene': ('barytonsaksofon',),
'barytonsaksofoner': ('barytonsaksofon',),
'barytonsanger': ('barytonsanger',),
'barytonsangere': ('barytonsanger',),
'barytonsangeren': ('barytonsanger',),
'barytonsangerer': ('barytonsanger',),
'barytonsangerne': ('barytonsanger',),
'barytonstemme': ('barytonstemme',),
'barytonstemmen': ('barytonstemme',),
'barytonstemmene': ('barytonstemme',),
'barytonstemmer': ('barytonstemme',),
'bas': ('bas',),
'basen': ('bas',),
'basene': ('bas',),
'baser': ('bas',),
'basalforsking': ('basalforsking',),
'basalforskinga': ('basalforsking',),
'basalforskingen': ('basalforsking',),
'basalforskingene': ('basalforsking',),
'basalforskinger': ('basalforsking',),
'basalforskning': ('basalforskning',),
'basalforskninga': ('basalforskning',),
'basalforskningen': ('basalforskning',),
'basalforskningene': ('basalforskning',),
'basalforskninger': ('basalforskning',),
'basalt': ('basalt',),
'basalten': ('basalt',),
'basaltene': ('basalt',),
'basalter': ('basalt',),
'basaltskifer': ('basaltskifer',),
'basaltskifere': ('basaltskifer',),
'basaltskiferen': ('basaltskifer',),
'basaltskiferer': ('basaltskifer',),
'basaltskiferne': ('basaltskifer',),
'basaltskifre': ('basaltskifer',),
'basaltskifrene': ('basaltskifer',),
'basaltskifrer': ('basaltskifer',),
'basar': ('basar',),
'basaren': ('basar',),
'basarene': ('basar',),
'basarer': ('basar',),
'basbåt': ('basbåt',),
'basbåten': ('basbåt',),
'basbåtene': ('basbåt',),
'basbåter': ('basbåt',),
'base': ('base',),
'basen': ('base',),
'basene': ('base',),
'baser': ('base',),
'base': ('base',),
'basen': ('base',),
'basene': ('base',),
'baser': ('base',),
'baseball': ('baseball',),
'baseballen': ('baseball',),
'baseballene': ('baseball',),
'baseballer': ('baseball',),
'basepolitikk': ('basepolitikk',),
'basepolitikken': ('basepolitikk',),
'basepolitikkene': ('basepolitikk',),
'basepolitikker': ('basepolitikk',),
'basilik': ('basilik',),
'basiliken': ('basilik',),
'basilikene': ('basilik',),
'basiliker': ('basilik',),
'basilika': ('basilika',),
'basilikaen': ('basilika',),
'basilikaene': ('basilika',),
'basilikaer': ('basilika',),
'basilikum': ('basilikum',),
'basilikumen': ('basilikum',),
'basilikumene': ('basilikum',),
'basilikumer': ('basilikum',),
'basilisk': ('basilisk',),
'basilisken': ('basilisk',),
'basiliskene': ('basilisk',),
'basilisker': ('basilisk',),
'basill': ('basill',),
'basillen': ('basill',),
'basillene': ('basill',),
'basiller': ('basill',),
'basillbærer': ('basillbærer',),
'basillbærere': ('basillbærer',),
'basillbæreren': ('basillbærer',),
'basillbærerer': ('basillbærer',),
'basillbærerne': ('basillbærer',),
'basillkultur': ('basillkultur',),
'basillkulturen': ('basillkultur',),
'basillkulturene': ('basillkultur',),
'basillkulturer': ('basillkultur',),
'basis': ('basis',),
'basisen': ('basis',),
'basisene': ('basis',),
'basiser': ('basis',),
'basisfraktur': ('basisfraktur',),
'basisfrakturen': ('basisfraktur',),
'basisfrakturene': ('basisfraktur',),
'basisfrakturer': ('basisfraktur',),
'basisgruppa': ('basisgruppe',),
'basisgruppe': ('basisgruppe',),
'basisgruppen': ('basisgruppe',),
'basisgruppene': ('basisgruppe',),
'basisgrupper': ('basisgruppe',),
'basislinja': ('basislinje',),
'basislinje': ('basislinje',),
'basislinjen': ('basislinje',),
'basislinjene': ('basislinje',),
'basislinjer': ('basislinje',),
'basispunkt': ('basispunkt',),
'basispunkta': ('basispunkt',),
'basispunktene': ('basispunkt',),
'basispunkter': ('basispunkt',),
'basispunktet': ('basispunkt',),
'basisår': ('basisår',),
'basisåra': ('basisår',),
'basisårene': ('basisår',),
'basisåret': ('basisår',),
'basker': ('basker',),
'baskere': ('basker',),
'baskeren': ('basker',),
'baskerer': ('basker',),
'baskerne': ('basker',),
'baskerhua': ('baskerhue',),
'baskerhue': ('baskerhue',),
'baskerhuen': ('baskerhue',),
'baskerhuene': ('baskerhue',),
'baskerhuer': ('baskerhue',),
'baskerhuva': ('baskerhuve',),
'baskerhuve': ('baskerhuve',),
'baskerhuven': ('baskerhuve',),
'baskerhuvene': ('baskerhuve',),
'baskerhuver': ('baskerhuve',),
'baskerlua': ('baskerlue',),
'baskerlue': ('baskerlue',),
'baskerluen': ('baskerlue',),
'baskerluene': ('baskerlue',),
'baskerluer': ('baskerlue',),
'baskerluva': ('baskerluve',),
'baskerluve': ('baskerluve',),
'baskerluven': ('baskerluve',),
'baskerluvene': ('baskerluve',),
'baskerluver': ('baskerluve',),
'basketak': ('basketak',),
'basketaka': ('basketak',),
'basketakene': ('basketak',),
'basketaket': ('basketak',),
'basketball': ('basketball',),
'basketballen': ('basketball',),
'basketballene': ('basketball',),
'basketballer': ('basketball',),
'baskisk': ('baskisk',),
'baskisken': ('baskisk',),
'baskiskene': ('baskisk',),
'baskisker': ('baskisk',),
'basrelieff': ('basrelieff',),
'basrelieffa': ('basrelieff',),
'basrelieffene': ('basrelieff',),
'basrelieffer': ('basrelieff',),
'basrelieffet': ('basrelieff',),
'bass': ('bass',),
'bassen': ('bass',),
'bassene': ('bass',),
'basser': ('bass',),
'bass': ('bass',),
'bassen': ('bass',),
'bassene': ('bass',),
'basser': ('bass',),
'bass-sanger': ('bass-sanger',),
'bass-sangere': ('bass-sanger',),
'bass-sangeren': ('bass-sanger',),
'bass-sangerer': ('bass-sanger',),
'bass-sangerne': ('bass-sanger',),
'bass-streng': ('bass-streng',),
'bass-strengen': ('bass-streng',),
'bass-strengene': ('bass-streng',),
'bass-strenger': ('bass-streng',),
'bassanger': ('bassanger',),
'bassangere': ('bassanger',),
'bassangeren': ('bassanger',),
'bassangerer': ('bassanger',),
'bassangerne': ('bassanger',),
'bassbaryton': ('bassbaryton',),
'bassbarytonen': ('bassbaryton',),
'bassbarytonene': ('bassbaryton',),
'bassbarytoner': ('bassbaryton',),
'bassbasun': ('bassbasun',),
'bassbasunen': ('bassbasun',),
'bassbasunene': ('bassbasun',),
'bassbasuner': ('bassbasun',),
'basse': ('basse',),
'bassen': ('basse',),
'bassene': ('basse',),
'basser': ('basse',),
'basseng': ('basseng',),
'bassenga': ('basseng',),
'bassengene': ('basseng',),
'bassenger': ('basseng',),
'bassenget': ('basseng',),
'bassgitar': ('bassgitar',),
'bassgitaren': ('bassgitar',),
'bassgitarene': ('bassgitar',),
'bassgitarer': ('bassgitar',),
'bassist': ('bassist',),
'bassisten': ('bassist',),
'bassistene': ('bassist',),
'bassister': ('bassist',),
'bassnote': ('bassnote',),
'bassnoten': ('bassnote',),
'bassnotene': ('bassnote',),
'bassnoter': ('bassnote',),
'bassnøkkel': ('bassnøkkel',),
'bassnøkkelen': ('bassnøkkel',),
'bassnøklene': ('bassnøkkel',),
'bassnøkler': ('bassnøkkel',),
'basstreng': ('basstreng',),
'basstrengen': ('basstreng',),
'basstrengene': ('basstreng',),
'basstrenger': ('basstreng',),
'basstuba': ('basstuba',),
'basstubaen': ('basstuba',),
'basstubaene': ('basstuba',),
'basstubaer': ('basstuba',),
'bast': ('bast',),
'basten': ('bast',),
'bastene': ('bast',),
'baster': ('bast',),
'bastard': ('bastard',),
'bastarden': ('bastard',),
'bastardene': ('bastard',),
'bastarder': ('bastard',),
'bastardart': ('bastardart',),
'bastardarta': ('bastardart',),
'bastardarten': ('bastardart',),
'bastardartene': ('bastardart',),
'bastardarter': ('bastardart',),
'bastardisering': ('bastardisering',),
'bastardiseringa': ('bastardisering',),
'bastardiseringen': ('bastardisering',),
'bastardiseringene': ('bastardisering',),
'bastardiseringer': ('bastardisering',),
'bastardplanta': ('bastardplante',),
'bastardplante': ('bastardplante',),
'bastardplanten': ('bastardplante',),
'bastardplantene': ('bastardplante',),
'bastardplanter': ('bastardplante',),
'bastion': ('bastion',),
'bastionen': ('bastion',),
'bastionene': ('bastion',),
'bastioner': ('bastion',),
'bastmatta': ('bastmatte',),
'bastmatte': ('bastmatte',),
'bastmatten': ('bastmatte',),
'bastmattene': ('bastmatte',),
'bastmatter': ('bastmatte',),
'bastsilke': ('bastsilke',),
'bastsilken': ('bastsilke',),
'bastsilkene': ('bastsilke',),
'bastsilker': ('bastsilke',),
'bastskjørt': ('bastskjørt',),
'bastskjørta': ('bastskjørt',),
'bastskjørtene': ('bastskjørt',),
'bastskjørter': ('bastskjørt',),
'bastskjørtet': ('bastskjørt',),
'basttau': ('basttau',),
'basttaua': ('basttau',),
'basttauene': ('basttau',),
'basttauet': ('basttau',),
'basun': ('basun',),
'basunen': ('basun',),
'basunene': ('basun',),
'basuner': ('basun',),
'basunengel': ('basunengel',),
'basunengelen': ('basunengel',),
'basunenglene': ('basunengel',),
'basunengler': ('basunengel',),
'basunist': ('basunist',),
'basunisten': ('basunist',),
'basunistene': ('basunist',),
'basunister': ('basunist',),
'basunrøst': ('basunrøst',),
'basunrøsta': ('basunrøst',),
'basunrøsten': ('basunrøst',),
'basunrøstene': ('basunrøst',),
'basunrøster': ('basunrøst',),
'batalje': ('batalje',),
'bataljen': ('batalje',),
'bataljene': ('batalje',),
'bataljer': ('batalje',),
'bataljon': ('bataljon',),
'bataljonen': ('bataljon',),
'bataljonene': ('bataljon',),
'bataljoner': ('bataljon',),
'bataljonssjef': ('bataljonssjef',),
'bataljonssjefen': ('bataljonssjef',),
'bataljonssjefene': ('bataljonssjef',),
'bataljonssjefer': ('bataljonssjef',),
'batate': ('batate',),
'bataten': ('batate',),
'batatene': ('batate',),
'batater': ('batate',),
'batateplanta': ('batateplante',),
'batateplante': ('batateplante',),
'batateplanten': ('batateplante',),
'batateplantene': ('batateplante',),
'batateplanter': ('batateplante',),
'bate': ('bate',),
'baten': ('bate',),
'batene': ('bate',),
'bater': ('bate',),
'batikk': ('batikk',),
'batikken': ('batikk',),
'batikkene': ('batikk',),
'batikker': ('batikk',),
'batikktrykk': ('batikktrykk',),
'batikktrykka': ('batikktrykk',),
'batikktrykkene': ('batikktrykk',),
'batikktrykket': ('batikktrykk',),
'batist': ('batist',),
'batisten': ('batist',),
'batistene': ('batist',),
'batister': ('batist',),
'batong': ('batong',),
'batongen': ('batong',),
'batongene': ('batong',),
'batonger': ('batong',),
'batteri': ('batteri',),
'batteria': ('batteri',),
'batteriene': ('batteri',),
'batterier': ('batteri',),
'batteriet': ('batteri',),
'batteribefal': ('batteribefal',),
'batteribefala': ('batteribefal',),
'batteribefalene': ('batteribefal',),
'batteribefalet': ('batteribefal',),
'batterieliminator': ('batterieliminator',),
'batterieliminatoren': ('batterieliminator',),
'batterieliminatorene': ('batterieliminator',),
'batterieliminatorer': ('batterieliminator',),
'batterilader': ('batterilader',),
'batteriladere': ('batterilader',),
'batteriladeren': ('batterilader',),
'batteriladerer': ('batterilader',),
'batteriladerne': ('batterilader',),
'batteriradio': ('batteriradio',),
'batteriradioen': ('batteriradio',),
'batteriradioene': ('batteriradio',),
'batteriradioer': ('batteriradio',),
'batterist': ('batterist',),
'batteristen': ('batterist',),
'batteristene': ('batterist',),
'batterister': ('batterist',),
'battledress': ('battledress',),
'battledressen': ('battledress',),
'battledressene': ('battledress',),
'battledresser': ('battledress',),
'baufil': ('baufil',),
'baufila': ('baufil',),
'baufilen': ('baufil',),
'baufilene': ('baufil',),
'baufiler': ('baufil',),
'baug': ('baug',),
'baugen': ('baug',),
'baugene': ('baug',),
'bauger': ('baug',),
'bauganker': ('bauganker',),
'baugankera': ('bauganker',),
'baugankere': ('bauganker',),
'baugankeret': ('bauganker',),
'baugankra': ('bauganker',),
'baugankre': ('bauganker',),
'baugankrene': ('bauganker',),
'baugankret': ('bauganker',),
'baugspryd': ('baugspryd',),
'baugspryda': ('baugspryd',),
'baugsprydene': ('baugspryd',),
'baugsprydet': ('baugspryd',),
'bauksitt': ('bauksitt',),
'bauksitten': ('bauksitt',),
'bauksittene': ('bauksitt',),
'bauksitter': ('bauksitt',),
'baumé': ('baumé',),
'baumégrad': ('baumégrad',),
'baumégraden': ('baumégrad',),
'baumégradene': ('baumégrad',),
'baumégrader': ('baumégrad',),
'bauméskala': ('bauméskala',),
'bauméskalaen': ('bauméskala',),
'bauméskalaene': ('bauméskala',),
'bauméskalaer': ('bauméskala',),
'baun': ('baun',),
'baunen': ('baun',),
'baunene': ('baun',),
'bauner': ('baun',),
'baunbluss': ('baunbluss',),
'baunblussa': ('baunbluss',),
'baunblussene': ('baunbluss',),
'baunblusset': ('baunbluss',),
'baut': ('baut',),
'bauten': ('baut',),
'bautene': ('baut',),
'bauter': ('baut',),
'bauta': ('bauta',),
'bautaen': ('bauta',),
'bautaene': ('bauta',),
'bautaer': ('bauta',),
'bautastein': ('bautastein',),
'bautasteinen': ('bautastein',),
'bautasteinene': ('bautastein',),
'bautasteiner': ('bautastein',),
'bauxitt': ('bauxitt',),
'bauxitten': ('bauxitt',),
'bauxittene': ('bauxitt',),
'bauxitter': ('bauxitt',),
'bavian': ('bavian',),
'bavianen': ('bavian',),
'bavianene': ('bavian',),
'bavianer': ('bavian',),
'baviansvakt': ('baviansvakt',),
'baviansvakta': ('baviansvakt',),
'baviansvakten': ('baviansvakt',),
'baviansvaktene': ('baviansvakt',),
'baviansvakter': ('baviansvakt',),
'bayer': ('bayer',),
'bayere': ('bayer',),
'bayeren': ('bayer',),
'bayerer': ('bayer',),
'bayerne': ('bayer',),
'bayerøl': ('bayerøl',),
'bayerøla': ('bayerøl',),
'bayerølet': ('bayerøl',),
'bayonneskinka': ('bayonneskinke',),
'bayonneskinke': ('bayonneskinke',),
'bayonneskinken': ('bayonneskinke',),
'bayonneskinkene': ('bayonneskinke',),
'bayonneskinker': ('bayonneskinke',),
'bayrer': ('bayrer',),
'bayrere': ('bayrer',),
'bayreren': ('bayrer',),
'bayrerer': ('bayrer',),
'bayrerne': ('bayrer',),
'bazooka': ('bazooka',),
'bazookaen': ('bazooka',),
'bazookaene': ('bazooka',),
'bazookaer': ('bazooka',),
'be-bop': ('be-bop',),
'be-bopen': ('be-bop',),
'be-bopene': ('be-bop',),
'be-boper': ('be-bop',),
'bearbeidelse': ('bearbeidelse',),
'bearbeidelsen': ('bearbeidelse',),
'bearbeidelsene': ('bearbeidelse',),
'bearbeidelser': ('bearbeidelse',),
'bearbeiding': ('bearbeiding',),
'bearbeidinga': ('bearbeiding',),
'bearbeidingen': ('bearbeiding',),
'bearbeidingene': ('bearbeiding',),
'bearbeidinger': ('bearbeiding',),
'bearnés': ('bearnés',),
'bearnésen': ('bearnés',),
'bearnésene': ('bearnés',),
'bearnéser': ('bearnés',),
'bearnéssaus': ('bearnéssaus',),
'bearnéssausen': ('bearnéssaus',),
'bearnéssausene': ('bearnéssaus',),
'bearnéssauser': ('bearnéssaus',),
'beat': ('beat',),
'beaten': ('beat',),
'beatene': ('beat',),
'beater': ('beat',),
'beatmusikk': ('beatmusikk',),
'beatmusikken': ('beatmusikk',),
'beatmusikkene': ('beatmusikk',),
'beatmusikker': ('beatmusikk',),
'beatnik': ('beatnik',),
'beatniken': ('beatnik',),
'beatnikene': ('beatnik',),
'beatniker': ('beatnik',),
'beaufortskala': ('beaufortskala',),
'beaufortskalaen': ('beaufortskala',),
'beaufortskalaene': ('beaufortskala',),
'beaufortskalaer': ('beaufortskala',),
'beboelseshus': ('beboelseshus',),
'beboelseshusa': ('beboelseshus',),
'beboelseshusene': ('beboelseshus',),
'beboelseshuset': ('beboelseshus',),
'beboer': ('beboer',),
'beboere': ('beboer',),
'beboeren': ('beboer',),
'beboerer': ('beboer',),
'beboerne': ('beboer',),
'bebreidelse': ('bebreidelse',),
'bebreidelsen': ('bebreidelse',),
'bebreidelsene': ('bebreidelse',),
'bebreidelser': ('bebreidelse',),
'bebudelse': ('bebudelse',),
'bebudelsen': ('bebudelse',),
'bebudelsene': ('bebudelse',),
'bebudelser': ('bebudelse',),
'bebudelsesdag': ('bebudelsesdag',),
'bebudelsesdagen': ('bebudelsesdag',),
'bebudelsesdagene': ('bebudelsesdag',),
'bebudelsesdager': ('bebudelsesdag',),
'bebyggelse': ('bebyggelse',),
'bebyggelsen': ('bebyggelse',),
'bebyggelsene': ('bebyggelse',),
'bebyggelser': ('bebyggelse',),
'becquerel': ('becquerel',),
'becquerelen': ('becquerel',),
'becquerelene': ('becquerel',),
'bed': ('bed',),
'beda': ('bed',),
'bedene': ('bed',),
'bedet': ('bed',),
'bedding': ('bedding',),
'beddingen': ('bedding',),
'beddingene': ('bedding',),
'beddinger': ('bedding',),
'bededag': ('bededag',),
'bededagen': ('bededag',),
'bededagene': ('bededag',),
'bededager': ('bededag',),
'bedehus': ('bedehus',),
'bedehusa': ('bedehus',),
'bedehusene': ('bedehus',),
'bedehuset': ('bedehus',),
'bedehuskristendom': ('bedehuskristendom',),
'bedehuskristendommen': ('bedehuskristendom',),
'bedehuskristendommene': ('bedehuskristendom',),
'bedehuskristendommer': ('bedehuskristendom',),
'bedekker': ('bedekker',),
'bedekkere': ('bedekker',),
'bedekkeren': ('bedekker',),
'bedekkerer': ('bedekker',),
'bedekkerne': ('bedekker',),
'bedekking': ('bedekking',),
'bedekkinga': ('bedekking',),
'bedekkingen': ('bedekking',),
'bedekkingene': ('bedekking',),
'bedekkinger': ('bedekking',),
'bedekning': ('bedekning',),
'bedekninga': ('bedekning',),
'bedekningen': ('bedekning',),
'bedekningene': ('bedekning',),
'bedekninger': ('bedekning',),
'bedemann': ('bedemann',),
'bedemannen': ('bedemann',),
'bedemenn': ('bedemann',),
'bedemennene': ('bedemann',),
'bedeskammel': ('bedeskammel',),
'bedeskammelen': ('bedeskammel',),
'bedeskammlene': ('bedeskammel',),
'bedeskammler': ('bedeskammel',),
'bedeteppa': ('bedeteppe',),
'bedeteppe': ('bedeteppe',),
'bedeteppene': ('bedeteppe',),
'bedetepper': ('bedeteppe',),
'bedeteppet': ('bedeteppe',),
'bedrag': ('bedrag',),
'bedraga': ('bedrag',),
'bedragene': ('bedrag',),
'bedraget': ('bedrag',),
'bedrager': ('bedrager',),
'bedragere': ('bedrager',),
'bedrageren': ('bedrager',),
'bedragerer': ('bedrager',),
'bedragerne': ('bedrager',),
'bedrageri': ('bedrageri',),
'bedrageria': ('bedrageri',),
'bedrageriene': ('bedrageri',),
'bedragerier': ('bedrageri',),
'bedrageriet': ('bedrageri',),
'bedreviten': ('bedreviten',),
'bedrevitenen': ('bedreviten',),
'bedrevitenene': ('bedreviten',),
'bedrevitener': ('bedreviten',),
'bedreviter': ('bedreviter',),
'bedrevitere': ('bedreviter',),
'bedreviteren': ('bedreviter',),
'bedreviterer': ('bedreviter',),
'bedreviterne': ('bedreviter',),
'bedrift': ('bedrift',),
'bedriften': ('bedrift',),
'bedriftene': ('bedrift',),
'bedrifter': ('bedrift',),
'bedriftsdemokrati': ('bedriftsdemokrati',),
'bedriftsdemokratia': ('bedriftsdemokrati',),
'bedriftsdemokratiene': ('bedriftsdemokrati',),
'bedriftsdemokratier': ('bedriftsdemokrati',),
'bedriftsdemokratiet': ('bedriftsdemokrati',),
'bedriftsforsamling': ('bedriftsforsamling',),
'bedriftsforsamlinga': ('bedriftsforsamling',),
'bedriftsforsamlingen': ('bedriftsforsamling',),
'bedriftsforsamlingene': ('bedriftsforsamling',),
'bedriftsforsamlinger': ('bedriftsforsamling',),
'bedriftsidrett': ('bedriftsidrett',),
'bedriftsidretten': ('bedriftsidrett',),
'bedriftsidrettene': ('bedriftsidrett',),
'bedriftsidretter': ('bedriftsidrett',),
'bedriftsklubb': ('bedriftsklubb',),
'bedriftsklubben': ('bedriftsklubb',),
'bedriftsklubbene': ('bedriftsklubb',),
'bedriftsklubber': ('bedriftsklubb',),
'bedriftsledelse': ('bedriftsledelse',),
'bedriftsledelsen': ('bedriftsledelse',),
'bedriftsledelsene': ('bedriftsledelse',),
'bedriftsledelser': ('bedriftsledelse',),
'bedriftslege': ('bedriftslege',),
'bedriftslegen': ('bedriftslege',),
'bedriftslegene': ('bedriftslege',),
'bedriftsleger': ('bedriftslege',),
'bedriftsutvalg': ('bedriftsutvalg',),
'bedriftsutvalga': ('bedriftsutvalg',),
'bedriftsutvalgene': ('bedriftsutvalg',),
'bedriftsutvalget': ('bedriftsutvalg',),
'bedriftsøkonom': ('bedriftsøkonom',),
'bedriftsøkonomen': ('bedriftsøkonom',),
'bedriftsøkonomene': ('bedriftsøkonom',),
'bedriftsøkonomer': ('bedriftsøkonom',),
'bedriftsøkonomi': ('bedriftsøkonomi',),
'bedriftsøkonomien': ('bedriftsøkonomi',),
'bedriftsøkonomiene': ('bedriftsøkonomi',),
'bedriftsøkonomier': ('bedriftsøkonomi',),
'bedring': ('bedring',),
'bedringa': ('bedring',),
'bedringen': ('bedring',),
'bedringene': ('bedring',),
'bedringer': ('bedring',),
'bedrøvelse': ('bedrøvelse',),
'bedrøvelsen': ('bedrøvelse',),
'bedrøvelsene': ('bedrøvelse',),
'bedrøvelser': ('bedrøvelse',),
'beduin': ('beduin',),
'beduinen': ('beduin',),
'beduinene': ('beduin',),
'beduiner': ('beduin',),
'bedårer': ('bedårer',),
'bedårere': ('bedårer',),
'bedåreren': ('bedårer',),
'bedårerer': ('bedårer',),
'bedårerne': ('bedårer',),
'bedømmelse': ('bedømmelse',),
'bedømmelsen': ('bedømmelse',),
'bedømmelsene': ('bedømmelse',),
'bedømmelser': ('bedømmelse',),
'bedøvelse': ('bedøvelse',),
'bedøvelsen': ('bedøvelse',),
'bedøvelsene': ('bedøvelse',),
'bedøvelser': ('bedøvelse',),
'bedøvelsesmiddel': ('bedøvelsesmiddel',),
'bedøvelsesmiddelet': ('bedøvelsesmiddel',),
'bedøvelsesmidla': ('bedøvelsesmiddel',),
'bedøvelsesmidlene': ('bedøvelsesmiddel',),
'bedøvelsesmidler': ('bedøvelsesmiddel',),
'bedøvelsesmidlet': ('bedøvelsesmiddel',),
'bedøvelsestilstand': ('bedøvelsestilstand',),
'bedøvelsestilstanden': ('bedøvelsestilstand',),
'bedøvelsestilstandene': ('bedøvelsestilstand',),
'bedøvelsestilstander': ('bedøvelsestilstand',),
'befal': ('befal',),
'befala': ('befal',),
'befalene': ('befal',),
'befalet': ('befal',),
'befalhavende': ('befalhavende',),
'befalhavenden': ('befalhavende',),
'befalhavendene': ('befalhavende',),
'befalhavender': ('befalhavende',),
'befaling': ('befaling',),
'befalinga': ('befaling',),
'befalingen': ('befaling',),
'befalingene': ('befaling',),
'befalinger': ('befaling',),
'befalingsmann': ('befalingsmann',),
'befalingsmannen': ('befalingsmann',),
'befalingsmenn': ('befalingsmann',),
'befalingsmennene': ('befalingsmann',),
'befalselev': ('befalselev',),
'befalseleven': ('befalselev',),
'befalselevene': ('befalselev',),
'befalselever': ('befalselev',),
'befalsgrad': ('befalsgrad',),
'befalsgraden': ('befalsgrad',),
'befalsgradene': ('befalsgrad',),
'befalsgrader': ('befalsgrad',),
'befalsskole': ('befalsskole',),
'befalsskolen': ('befalsskole',),
'befalsskolene': ('befalsskole',),
'befalsskoler': ('befalsskole',),
'befaring': ('befaring',),
'befaringa': ('befaring',),
'befaringen': ('befaring',),
'befaringene': ('befaring',),
'befaringer': ('befaring',),
'befatning': ('befatning',),
'befatninga': ('befatning',),
'befatningen': ('befatning',),
'befatningene': ('befatning',),
'befatninger': ('befatning',),
'befestningskunst': ('befestningskunst',),
'befestningskunsten': ('befestningskunst',),
'befestningskunstene': ('befestningskunst',),
'befestningskunster': ('befestningskunst',),
'befinnende': ('befinnende',),
'befippelse': ('befippelse',),
'befippelsen': ('befippelse',),
'befippelsene': ('befippelse',),
'befippelser': ('befippelse',),
'befolkning': ('befolkning',),
'befolkninga': ('befolkning',),
'befolkningen': ('befolkning',),
'befolkningene': ('befolkning',),
'befolkninger': ('befolkning',),
'befolkningseksplosjon': ('befolkningseksplosjon',),
'befolkningseksplosjonen': ('befolkningseksplosjon',),
'befolkningseksplosjonene': ('befolkningseksplosjon',),
'befolkningseksplosjoner': ('befolkningseksplosjon',),
'befolkningsgruppa': ('befolkningsgruppe',),
'befolkningsgruppe': ('befolkningsgruppe',),
'befolkningsgruppen': ('befolkningsgruppe',),
'befolkningsgruppene': ('befolkningsgruppe',),
'befolkningsgrupper': ('befolkningsgruppe',),
'befolkningskontroll': ('befolkningskontroll',),
'befolkningskontrollen': ('befolkningskontroll',),
'befolkningskontrollene': ('befolkningskontroll',),
'befolkningskontroller': ('befolkningskontroll',),
'befolkningspolitikk': ('befolkningspolitikk',),
'befolkningspolitikken': ('befolkningspolitikk',),
'befolkningspolitikkene': ('befolkningspolitikk',),
'befolkningspolitikker': ('befolkningspolitikk',),
'befolkningstetthet': ('befolkningstetthet',),
'befolkningstettheta': ('befolkningstetthet',),
'befolkningstettheten': ('befolkningstetthet',),
'befolkningstetthetene': ('befolkningstetthet',),
'befolkningstettheter': ('befolkningstetthet',),
'befolkningstilvekst': ('befolkningstilvekst',),
'befolkningstilveksten': ('befolkningstilvekst',),
'befolkningstilvekstene': ('befolkningstilvekst',),
'befolkningstilvekster': ('befolkningstilvekst',),
'befordring': ('befordring',),
'befordringa': ('befordring',),
'befordringen': ('befordring',),
'befordringene': ('befordring',),
'befordringer': ('befordring',),
'befordringsmiddel': ('befordringsmiddel',),
'befordringsmiddelet': ('befordringsmiddel',),
'befordringsmidla': ('befordringsmiddel',),
'befordringsmidlene': ('befordringsmiddel',),
'befordringsmidler': ('befordringsmiddel',),
'befordringsmidlet': ('befordringsmiddel',),
'befordringsmåte': ('befordringsmåte',),
'befordringsmåten': ('befordringsmåte',),
'befordringsmåtene': ('befordringsmåte',),
'befordringsmåter': ('befordringsmåte',),
'befrakter': ('befrakter',),
'befraktere': ('befrakter',),
'befrakteren': ('befrakter',),
'befrakterer': ('befrakter',),
'befrakterne': ('befrakter',),
'befraktning': ('befraktning',),
'befraktninga': ('befraktning',),
'befraktningen': ('befraktning',),
'befraktningene': ('befraktning',),
'befraktninger': ('befraktning',),
'befrielse': ('befrielse',),
'befrielsen': ('befrielse',),
'befrielsene': ('befrielse',),
'befrielser': ('befrielse',),
'befrielseskamp': ('befrielseskamp',),
'befrielseskampen': ('befrielseskamp',),
'befrielseskampene': ('befrielseskamp',),
'befrielseskamper': ('befrielseskamp',),
'befrielseskrig': ('befrielseskrig',),
'befrielseskrigen': ('befrielseskrig',),
'befrielseskrigene': ('befrielseskrig',),
'befrielseskriger': ('befrielseskrig',),
'befrier': ('befrier',),
'befriere': ('befrier',),
'befrieren': ('befrier',),
'befrierer': ('befrier',),
'befrierne': ('befrier',),
'befruktning': ('befruktning',),
'befruktninga': ('befruktning',),
'befruktningen': ('befruktning',),
'befruktningene': ('befruktning',),
'befruktninger': ('befruktning',),
'befruktningsevna': ('befruktningsevne',),
'befruktningsevne': ('befruktningsevne',),
'befruktningsevnen': ('befruktningsevne',),
'befruktningsevnene': ('befruktningsevne',),
'befruktningsevner': ('befruktningsevne',),
'befruktningsorgan': ('befruktningsorgan',),
'befruktningsorgana': ('befruktningsorgan',),
'befruktningsorganene': ('befruktningsorgan',),
'befruktningsorganer': ('befruktningsorgan',),
'befruktningsorganet': ('befruktningsorgan',),
'begavelse': ('begavelse',),
'begavelsen': ('begavelse',),
'begavelsene': ('begavelse',),
'begavelser': ('begavelse',),
'begeistring': ('begeistring',),
'begeistringa': ('begeistring',),
'begeistringen': ('begeistring',),
'begeistringene': ('begeistring',),
'begeistringer': ('begeistring',),
'begeistringsbølga': ('begeistringsbølge',),
'begeistringsbølge': ('begeistringsbølge',),
'begeistringsbølgen': ('begeistringsbølge',),
'begeistringsbølgene': ('begeistringsbølge',),
'begeistringsbølger': ('begeistringsbølge',),
'begeistringsbølgja': ('begeistringsbølgje',),
'begeistringsbølgje': ('begeistringsbølgje',),
'begeistringsbølgjen': ('begeistringsbølgje',),
'begeistringsbølgjene': ('begeistringsbølgje',),
'begeistringsbølgjer': ('begeistringsbølgje',),
'begeistringsrus': ('begeistringsrus',),
'begeistringsrusa': ('begeistringsrus',),
'begeistringsrusen': ('begeistringsrus',),
'begeistringsrusene': ('begeistringsrus',),
'begeistringsruser': ('begeistringsrus',),
'begeistringsruset': ('begeistringsrus',),
'beger': ('beger',),
'begeret': ('beger',),
'begra': ('beger',),
'begre': ('beger',),
'begrene': ('beger',),
'begerblad': ('begerblad',),
'begerblada': ('begerblad',),
'begerbladene': ('begerblad',),
'begerblader': ('begerblad',),
'begerbladet': ('begerblad',),
'begerglas': ('begerglas',),
'begerglasa': ('begerglas',),
'begerglasene': ('begerglas',),
'begerglaset': ('begerglas',),
'begerglass': ('begerglass',),
'begerglassa': ('begerglass',),
'begerglassene': ('begerglass',),
'begerglasset': ('begerglass',),
'begersvinger': ('begersvinger',),
'begersvingere': ('begersvinger',),
'begersvingeren': ('begersvinger',),
'begersvingerer': ('begersvinger',),
'begersvingerne': ('begersvinger',),
'begivenhet': ('begivenhet',),
'begivenheta': ('begivenhet',),
'begivenheten': ('begivenhet',),
'begivenhetene': ('begivenhet',),
'begivenheter': ('begivenhet',),
'begjær': ('begjær',),
'begjæra': ('begjær',),
'begjærene': ('begjær',),
'begjæret': ('begjær',),
'begjæring': ('begjæring',),
'begjæringa': ('begjæring',),
'begjæringen': ('begjæring',),
'begjæringene': ('begjæring',),
'begjæringer': ('begjæring',),
'begonia': ('begonia',),
'begoniaen': ('begonia',),
'begoniaene': ('begonia',),
'begoniaer': ('begonia',),
'begoniene': ('begonia',),
'begonier': ('begonia',),
'begravelse': ('begravelse',),
'begravelsen': ('begravelse',),
'begravelsene': ('begravelse',),
'begravelser': ('begravelse',),
'begravelsesbyrå': ('begravelsesbyrå',),
'begravelsesbyråa': ('begravelsesbyrå',),
'begravelsesbyråene': ('begravelsesbyrå',),
'begravelsesbyråer': ('begravelsesbyrå',),
'begravelsesbyrået': ('begravelsesbyrå',),
'begrensning': ('begrensning',),
'begrensninga': ('begrensning',),
'begrensningen': ('begrensning',),
'begrensningene': ('begrensning',),
'begrensninger': ('begrensning',),
'begrep': ('begrep',),
'begrepa': ('begrep',),
'begrepene': ('begrep',),
'begreper': ('begrep',),
'begrepet': ('begrep',),
'begrepsapparat': ('begrepsapparat',),
'begrepsapparata': ('begrepsapparat',),
'begrepsapparatene': ('begrepsapparat',),
'begrepsapparater': ('begrepsapparat',),
'begrepsapparatet': ('begrepsapparat',),
'begrepsforveksling': ('begrepsforveksling',),
'begrepsforvekslinga': ('begrepsforveksling',),
'begrepsforvekslingen': ('begrepsforveksling',),
'begrepsforvekslingene': ('begrepsforveksling',),
'begrepsforvekslinger': ('begrepsforveksling',),
'begrepsforvirring': ('begrepsforvirring',),
'begrepsforvirringa': ('begrepsforvirring',),
'begrepsforvirringen': ('begrepsforvirring',),
'begrepsforvirringene': ('begrepsforvirring',),
'begrepsforvirringer': ('begrepsforvirring',),
'begrepsinnhold': ('begrepsinnhold',),
'begrepsinnholda': ('begrepsinnhold',),
'begrepsinnholdene': ('begrepsinnhold',),
'begrepsinnholdet': ('begrepsinnhold',),
'begrepsnyanse': ('begrepsnyanse',),
'begrepsnyansen': ('begrepsnyanse',),
'begrepsnyansene': ('begrepsnyanse',),
'begrepsnyanser': ('begrepsnyanse',),
'begrepsomfang': ('begrepsomfang',),
'begrepsomfanga': ('begrepsomfang',),
'begrepsomfangene': ('begrepsomfang',),
'begrepsomfanget': ('begrepsomfang',),
'begroning': ('begroning',),
'begroninga': ('begroning',),
'begroningen': ('begroning',),
'begroningene': ('begroning',),
'begroninger': ('begroning',),
'begrunnelse': ('begrunnelse',),
'begrunnelsen': ('begrunnelse',),
'begrunnelsene': ('begrunnelse',),
'begrunnelser': ('begrunnelse',),
'beguine': ('beguine',),
'beguinen': ('beguine',),
'beguinene': ('beguine',),
'beguiner': ('beguine',),
'begynnelse': ('begynnelse',),
'begynnelsen': ('begynnelse',),
'begynnelsene': ('begynnelse',),
'begynnelser': ('begynnelse',),
'begynnelsesgrunnene': ('begynnelsesgrunner',),
'begynnelsesgrunner': ('begynnelsesgrunner',),
'begynnelseshastighet': ('begynnelseshastighet',),
'begynnelseshastigheta': ('begynnelseshastighet',),
'begynnelseshastigheten': ('begynnelseshastighet',),
'begynnelseshastighetene': ('begynnelseshastighet',),
'begynnelseshastigheter': ('begynnelseshastighet',),
'begynnelsesstadia': ('begynnelsesstadium',),
'begynnelsesstadiene': ('begynnelsesstadium',),
'begynnelsesstadier': ('begynnelsesstadium',),
'begynnelsesstadiet': ('begynnelsesstadium',),
'begynnelsesstadium': ('begynnelsesstadium',),
'begynner': ('begynner',),
'begynnere': ('begynner',),
'begynneren': ('begynner',),
'begynnerer': ('begynner',),
'begynnerne': ('begynner',),
'begynnerfeil': ('begynnerfeil',),
'begynnerfeilen': ('begynnerfeil',),
'begynnerfeilene': ('begynnerfeil',),
'begynnergasje': ('begynnergasje',),
'begynnergasjen': ('begynnergasje',),
'begynnergasjene': ('begynnergasje',),
'begynnergasjer': ('begynnergasje',),
'begynnerklassa': ('begynnerklasse',),
'begynnerklasse': ('begynnerklasse',),
'begynnerklassen': ('begynnerklasse',),
'begynnerklassene': ('begynnerklasse',),
'begynnerklasser': ('begynnerklasse',),
'begynnerlønn': ('begynnerlønn',),
'begynnerlønna': ('begynnerlønn',),
'begynnerlønnen': ('begynnerlønn',),
'begynnerlønnene': ('begynnerlønn',),
'begynnerlønner': ('begynnerlønn',),
'begynnerstadia': ('begynnerstadium',),
'begynnerstadiene': ('begynnerstadium',),
'begynnerstadier': ('begynnerstadium',),
'begynnerstadiet': ('begynnerstadium',),
'begynnerstadium': ('begynnerstadium',),
'begynnervanske': ('begynnervanske',),
'begynnervansken': ('begynnervanske',),
'begynnervanskene': ('begynnervanske',),
'begynnervansker': ('begynnervanske',),
'begynnervanskelighet': ('begynnervanskelighet',),
'begynnervanskeligheta': ('begynnervanskelighet',),
'begynnervanskeligheten': ('begynnervanskelighet',),
'begynnervanskelighetene': ('begynnervanskelighet',),
'begynnervanskeligheter': ('begynnervanskelighet',),
'behag': ('behag',),
'behaga': ('behag',),
'behagene': ('behag',),
'behaget': ('behag',),
'behandler': ('behandler',),
'behandlere': ('behandler',),
'behandleren': ('behandler',),
'behandlerer': ('behandler',),
'behandlerne': ('behandler',),
'behandling': ('behandling',),
'behandlinga': ('behandling',),
'behandlingen': ('behandling',),
'behandlingene': ('behandling',),
'behandlinger': ('behandling',),
'behandlingsheim': ('behandlingsheim',),
'behandlingsheimen': ('behandlingsheim',),
'behandlingsheimene': ('behandlingsheim',),
'behandlingsheimer': ('behandlingsheim',),
'behandlingshjem': ('behandlingshjem',),
'behandlingshjemma': ('behandlingshjem',),
'behandlingshjemmene': ('behandlingshjem',),
'behandlingshjemmet': ('behandlingshjem',),
'behandlingsmåte': ('behandlingsmåte',),
'behandlingsmåten': ('behandlingsmåte',),
'behandlingsmåtene': ('behandlingsmåte',),
'behandlingsmåter': ('behandlingsmåte',),
'behandlingstilbud': ('behandlingstilbud',),
'behandlingstilbuda': ('behandlingstilbud',),
'behandlingstilbudene': ('behandlingstilbud',),
'behandlingstilbudet': ('behandlingstilbud',),
'behaviorisme': ('behaviorisme',),
'behaviorismen': ('behaviorisme',),
'behaviorismene': ('behaviorisme',),
'behaviorismer': ('behaviorisme',),
'behaviorist': ('behaviorist',),
'behavioristen': ('behaviorist',),
'behavioristene': ('behaviorist',),
'behaviorister': ('behaviorist',),
'beheng': ('beheng',),
'behenga': ('beheng',),
'behengene': ('beheng',),
'behenget': ('beheng',),
'beherskelse': ('beherskelse',),
'beherskelsen': ('beherskelse',),
'beherskelsene': ('beherskelse',),
'beherskelser': ('beherskelse',),
'behold': ('behold',),
'beholder': ('beholder',),
'beholdere': ('beholder',),
'beholderen': ('beholder',),
'beholderer': ('beholder',),
'beholderne': ('beholder',),
'beholdning': ('beholdning',),
'beholdninga': ('beholdning',),
'beholdningen': ('beholdning',),
'beholdningene': ('beholdning',),
'beholdninger': ('beholdning',),
'behov': ('behov',),
'behova': ('behov',),
'behovene': ('behov',),
'behovet': ('behov',),
'behovsanalysa': ('behovsanalyse',),
'behovsanalyse': ('behovsanalyse',),
'behovsanalysen': ('behovsanalyse',),
'behovsanalysene': ('behovsanalyse',),
'behovsanalyser': ('behovsanalyse',),
'behovsprøving': ('behovsprøving',),
'behovsprøvinga': ('behovsprøving',),
'behovsprøvingen': ('behovsprøving',),
'behovsprøvingene': ('behovsprøving',),
'behovsprøvinger': ('behovsprøving',),
'behå': ('behå',),
'behåen': ('behå',),
'behåene': ('behå',),
'behåer': ('behå',),
'behåring': ('behåring',),
'behåringa': ('behåring',),
'behåringen': ('behåring',),
'behåringene': ('behåring',),
'behåringer': ('behåring',),
'beiler': ('beiler',),
'beilere': ('beiler',),
'beileren': ('beiler',),
'beilerer': ('beiler',),
'beilerne': ('beiler',),
'bein': ('bein',),
'beina': ('bein',),
'beinene': ('bein',),
'beinet': ('bein',),
'beinarbeid': ('beinarbeid',),
'beinarbeida': ('beinarbeid',),
'beinarbeidene': ('beinarbeid',),
'beinarbeider': ('beinarbeid',),
'beinarbeidet': ('beinarbeid',),
'beinbetennelse': ('beinbetennelse',),
'beinbetennelsen': ('beinbetennelse',),
'beinbetennelsene': ('beinbetennelse',),
'beinbetennelser': ('beinbetennelse',),
'beinbrudd': ('beinbrudd',),
'beinbrudda': ('beinbrudd',),
'beinbruddene': ('beinbrudd',),
'beinbruddet': ('beinbrudd',),
'beinbygning': ('beinbygning',),
'beinbygninga': ('beinbygning',),
'beinbygningen': ('beinbygning',),
'beinbygningene': ('beinbygning',),
'beinbygninger': ('beinbygning',),
'beinfisk': ('beinfisk',),
'beinfisken': ('beinfisk',),
'beinfiskene': ('beinfisk',),
'beinfisker': ('beinfisk',),
'beingrind': ('beingrind',),
'beingrinda': ('beingrind',),
'beingrinden': ('beingrind',),
'beingrindene': ('beingrind',),
'beingrinder': ('beingrind',),
'beinklær': ('beinklær',),
'beinklærne': ('beinklær',),
'beinkrok': ('beinkrok',),
'beinkroken': ('beinkrok',),
'beinkrokene': ('beinkrok',),
'beinkroker': ('beinkrok',),
'beinlim': ('beinlim',),
'beinlima': ('beinlim',),
'beinlimene': ('beinlim',),
'beinlimet': ('beinlim',),
'beinmarg': ('beinmarg',),
'beinmargen': ('beinmarg',),
'beinmargene': ('beinmarg',),
'beinmarger': ('beinmarg',),
'beinmarg': ('beinmarg',),
'beinmargen': ('beinmarg',),
'beinmargene': ('beinmarg',),
'beinmarger': ('beinmarg',),
'beinmarg': ('beinmarg',),
'beinmargen': ('beinmarg',),
'beinmargene': ('beinmarg',),
'beinmarger': ('beinmarg',),
'beinmel': ('beinmel',),
'beinmela': ('beinmel',),
'beinmelene': ('beinmel',),
'beinmelet': ('beinmel',),
'beinmerg': ('beinmerg',),
'beinmergen': ('beinmerg',),
'beinmergene': ('beinmerg',),
'beinmerger': ('beinmerg',),
'beinmerg': ('beinmerg',),
'beinmergen': ('beinmerg',),
'beinmergene': ('beinmerg',),
'beinmerger': ('beinmerg',),
'beinmerg': ('beinmerg',),
'beinmergen': ('beinmerg',),
'beinmergene': ('beinmerg',),
'beinmerger': ('beinmerg',),
'beinmjøl': ('beinmjøl',),
'beinmjøla': ('beinmjøl',),
'beinmjølene': ('beinmjøl',),
'beinmjølet': ('beinmjøl',),
'beinpipa': ('beinpipe',),
'beinpipe': ('beinpipe',),
'beinpipen': ('beinpipe',),
'beinpipene': ('beinpipe',),
'beinpiper': ('beinpipe',),
'beinrangel': ('beinrangel',),
'beinrangelet': ('beinrangel',),
'beinrangla': ('beinrangel',),
'beinranglene': ('beinrangel',),
'beinrangler': ('beinrangel',),
'beinranglet': ('beinrangel',),
'beinskurd': ('beinskurd',),
'beinskurden': ('beinskurd',),
'beinskurdene': ('beinskurd',),
'beinskurder': ('beinskurd',),
'beinsplint': ('beinsplint',),
'beinsplinten': ('beinsplint',),
'beinsplintene': ('beinsplint',),
'beinsplinter': ('beinsplint',),
'beinsubstans': ('beinsubstans',),
'beinsubstansen': ('beinsubstans',),
'beinsubstansene': ('beinsubstans',),
'beinsubstanser': ('beinsubstans',),
'beinved': ('beinved',),
'beinveden': ('beinved',),
'beinvedene': ('beinved',),
'beinveder': ('beinved',),
'beinveg': ('beinveg',),
'beinvegen': ('beinveg',),
'beinvegene': ('beinveg',),
'beinveger': ('beinveg',),
'beinvei': ('beinvei',),
'beinveien': ('beinvei',),
'beinveiene': ('beinvei',),
'beinveier': ('beinvei',),
'beinvev': ('beinvev',),
'beinveva': ('beinvev',),
'beinvevene': ('beinvev',),
'beinvevet': ('beinvev',),
'beis': ('beis',),
'beisen': ('beis',),
'beisene': ('beis',),
'beiser': ('beis',),
'beist': ('beist',),
'beista': ('beist',),
'beistene': ('beist',),
'beistet': ('beist',),
'beit': ('beit',),
'beita': ('beit',),
'beiten': ('beit',),
'beitene': ('beit',),
'beiter': ('beit',),
'beit': ('beit',),
'beita': ('beit',),
'beiten': ('beit',),
'beitene': ('beit',),
'beiter': ('beit',),
'beita': ('beite',),
'beite': ('beite',),
'beitene': ('beite',),
'beiter': ('beite',),
'beitet': ('beite',),
'beita': ('beite',),
'beite': ('beite',),
'beiten': ('beite',),
'beitene': ('beite',),
'beiter': ('beite',),
'beitebruk': ('beitebruk',),
'beitebruka': ('beitebruk',),
'beitebrukene': ('beitebruk',),
'beitebruket': ('beitebruk',),
'beitedrift': ('beitedrift',),
'beitedrifta': ('beitedrift',),
'beitedriften': ('beitedrift',),
'beitedriftene': ('beitedrift',),
'beitedrifter': ('beitedrift',),
'beitedyr': ('beitedyr',),
'beitedyra': ('beitedyr',),
'beitedyrene': ('beitedyr',),
'beitedyret': ('beitedyr',),
'beitegras': ('beitegras',),
'beitegrasa': ('beitegras',),
'beitegrasene': ('beitegras',),
'beitegraset': ('beitegras',),
'beitegress': ('beitegress',),
'beitegressa': ('beitegress',),
'beitegressene': ('beitegress',),
'beitegresset': ('beitegress',),
'beitekonsulent': ('beitekonsulent',),
'beitekonsulenten': ('beitekonsulent',),
'beitekonsulentene': ('beitekonsulent',),
'beitekonsulenter': ('beitekonsulent',),
'beitel': ('beitel',),
'beitelen': ('beitel',),
'beitlene': ('beitel',),
'beitler': ('beitel',),
'beitemakk': ('beitemakk',),
'beitemakken': ('beitemakk',),
'beitemakkene': ('beitemakk',),
'beitemakker': ('beitemakk',),
'beitemark': ('beitemark',),
'beitemarka': ('beitemark',),
'beitemarken': ('beitemark',),
'beitemarkene': ('beitemark',),
'beitemarker': ('beitemark',),
'beitemark': ('beitemark',),
'beitemarka': ('beitemark',),
'beitemarken': ('beitemark',),
'beitemarkene': ('beitemark',),
'beitemarker': ('beitemark',),
'beiteområda': ('beiteområde',),
'beiteområde': ('beiteområde',),
'beiteområdene': ('beiteområde',),
'beiteområder': ('beiteområde',),
'beiteområdet': ('beiteområde',),
'beiterett': ('beiterett',),
'beiteretten': ('beiterett',),
'beiterettene': ('beiterett',),
'beiteretter': ('beiterett',),
'beiteslepp': ('beiteslepp',),
'beitesleppa': ('beiteslepp',),
'beitesleppene': ('beiteslepp',),
'beitesleppet': ('beiteslepp',),
'beiteslipp': ('beiteslipp',),
'beiteslippa': ('beiteslipp',),
'beiteslippene': ('beiteslipp',),
'beiteslippet': ('beiteslipp',),
'bek': ('bek',),
'beka': ('bek',),
'bekene': ('bek',),
'beket': ('bek',),
'bekblende': ('bekblende',),
'bekblenden': ('bekblende',),
'bekblendene': ('bekblende',),
'bekblender': ('bekblende',),
'bekjempelse': ('bekjempelse',),
'bekjempelsen': ('bekjempelse',),
'bekjempelsene': ('bekjempelse',),
'bekjempelser': ('bekjempelse',),
'bekjemping': ('bekjemping',),
'bekjempinga': ('bekjemping',),
'bekjempingen': ('bekjemping',),
'bekjempingene': ('bekjemping',),
'bekjempinger': ('bekjemping',),
'bekjennelse': ('bekjennelse',),
'bekjennelsen': ('bekjennelse',),
'bekjennelsene': ('bekjennelse',),
'bekjennelser': ('bekjennelse',),
'bekjennelseskirka': ('bekjennelseskirke',),
'bekjennelseskirke': ('bekjennelseskirke',),
'bekjennelseskirken': ('bekjennelseskirke',),
'bekjennelseskirkene': ('bekjennelseskirke',),
'bekjennelseskirker': ('bekjennelseskirke',),
'bekjennelseskjerka': ('bekjennelseskjerke',),
'bekjennelseskjerke': ('bekjennelseskjerke',),
'bekjennelseskjerken': ('bekjennelseskjerke',),
'bekjennelseskjerkene': ('bekjennelseskjerke',),
'bekjennelseskjerker': ('bekjennelseskjerke',),
'bekjennelsesskrift': ('bekjennelsesskrift',),
'bekjennelsesskrifta': ('bekjennelsesskrift',),
'bekjennelsesskriftene': ('bekjennelsesskrift',),
'bekjennelsesskrifter': ('bekjennelsesskrift',),
'bekjennelsesskriftet': ('bekjennelsesskrift',),
'bekjentgjørelse': ('bekjentgjørelse',),
'bekjentgjørelsen': ('bekjentgjørelse',),
'bekjentgjørelsene': ('bekjentgjørelse',),
'bekjentgjørelser': ('bekjentgjørelse',),
'bekjentskap': ('bekjentskap',),
'bekjentskapa': ('bekjentskap',),
'bekjentskapene': ('bekjentskap',),
'bekjentskaper': ('bekjentskap',),
'bekjentskapet': ('bekjentskap',),
'bekjentskapskrets': ('bekjentskapskrets',),
'bekjentskapskretsen': ('bekjentskapskrets',),
'bekjentskapskretsene': ('bekjentskapskrets',),
'bekjentskapskretser': ('bekjentskapskrets',),
'bekk': ('bekk',),
'bekken': ('bekk',),
'bekkene': ('bekk',),
'bekker': ('bekk',),
'bekkasin': ('bekkasin',),
'bekkasinen': ('bekkasin',),
'bekkasinene': ('bekkasin',),
'bekkasiner': ('bekkasin',),
'bekkeblom': ('bekkeblom',),
'bekkeblommen': ('bekkeblom',),
'bekkeblommene': ('bekkeblom',),
'bekkeblommer': ('bekkeblom',),
'bekkefar': ('bekkefar',),
'bekkefara': ('bekkefar',),
'bekkefarene': ('bekkefar',),
'bekkefaret': ('bekkefar',),
'bekkekvern': ('bekkekvern',),
'bekkekverna': ('bekkekvern',),
'bekkekvernen': ('bekkekvern',),
'bekkekvernene': ('bekkekvern',),
'bekkekverner': ('bekkekvern',),
'bekken': ('bekken',),
'bekkena': ('bekken',),
'bekkenene': ('bekken',),
'bekkener': ('bekken',),
'bekkenet': ('bekken',),
'bekkenbein': ('bekkenbein',),
'bekkenbeina': ('bekkenbein',),
'bekkenbeinene': ('bekkenbein',),
'bekkenbeinet': ('bekkenbein',),
'bekkenben': ('bekkenben',),
'bekkenbena': ('bekkenben',),
'bekkenbenene': ('bekkenben',),
'bekkenbenet': ('bekkenben',),
'bekkenhola': ('bekkenhole',),
'bekkenhole': ('bekkenhole',),
'bekkenholen': ('bekkenhole',),
'bekkenholene': ('bekkenhole',),
'bekkenholer': ('bekkenhole',),
'bekkenhula': ('bekkenhule',),
'bekkenhule': ('bekkenhule',),
'bekkenhulen': ('bekkenhule',),
'bekkenhulene': ('bekkenhule',),
'bekkenhuler': ('bekkenhule',),
'bekkenløsning': ('bekkenløsning',),
'bekkenløsninga': ('bekkenløsning',),
'bekkenløsningen': ('bekkenløsning',),
'bekkenløsningene': ('bekkenløsning',),
'bekkenløsninger': ('bekkenløsning',),
'bekkenløysing': ('bekkenløysing',),
'bekkenløysinga': ('bekkenløysing',),
'bekkenløysingen': ('bekkenløysing',),
'bekkenløysingene': ('bekkenløysing',),
'bekkenløysinger': ('bekkenløysing',),
'bekkeos': ('bekkeos',),
'bekkeosa': ('bekkeos',),
'bekkeosen': ('bekkeos',),
'bekkeosene': ('bekkeos',),
'bekkeoser': ('bekkeos',),
'bekkeoset': ('bekkeos',),
'bekkesig': ('bekkesig',),
'bekkesiga': ('bekkesig',),
'bekkesigene': ('bekkesig',),
'bekkesiget': ('bekkesig',),
'bekkesilder': ('bekkesilder',),
'bekkesilderet': ('bekkesilder',),
'bekkesildra': ('bekkesilder',),
'bekkesildrene': ('bekkesilder',),
'bekkesildrer': ('bekkesilder',),
'bekkesildret': ('bekkesilder',),
'bekkesildra': ('bekkesildre',),
'bekkesildre': ('bekkesildre',),
'bekkesildren': ('bekkesildre',),
'bekkesildrene': ('bekkesildre',),
'bekkesildrer': ('bekkesildre',),
'beklagelse': ('beklagelse',),
'beklagelsen': ('beklagelse',),
'beklagelsene': ('beklagelse',),
'beklagelser': ('beklagelse',),
'bekledning': ('bekledning',),
'bekledninga': ('bekledning',),
'bekledningene': ('bekledning',),
'bekledninger': ('bekledning',),
'bekledningsgjenstand': ('bekledningsgjenstand',),
'bekledningsgjenstanden': ('bekledningsgjenstand',),
'bekledningsgjenstandene': ('bekledningsgjenstand',),
'bekledningsgjenstander': ('bekledningsgjenstand',),
'bekledningsindustri': ('bekledningsindustri',),
'bekledningsindustrien': ('bekledningsindustri',),
'bekledningsindustriene': ('bekledningsindustri',),
'bekledningsindustrier': ('bekledningsindustri',),
'beklemmelse': ('beklemmelse',),
'beklemmelsen': ('beklemmelse',),
'beklemmelsene': ('beklemmelse',),
'beklemmelser': ('beklemmelse',),
'bekmørka': ('bekmørke',),
'bekmørke': ('bekmørke',),
'bekmørkene': ('bekmørke',),
'bekmørker': ('bekmørke',),
'bekmørket': ('bekmørke',),
'beknip': ('beknip',),
'bekomst': ('bekomst',),
'bekomsten': ('bekomst',),
'bekomstene': ('bekomst',),
'bekomster': ('bekomst',),
'bekostning': ('bekostning',),
'bekostninga': ('bekostning',),
'bekostningen': ('bekostning',),
'bekostningene': ('bekostning',),
'bekostninger': ('bekostning',),
'bekransning': ('bekransning',),
'bekransninga': ('bekransning',),
'bekransningen': ('bekransning',),
'bekransningene': ('bekransning',),
'bekransninger': ('bekransning',),
'bekreftelse': ('bekreftelse',),
'bekreftelsen': ('bekreftelse',),
'bekreftelsene': ('bekreftelse',),
'bekreftelser': ('bekreftelse',),
'beksel': ('beksel',),
'bekselet': ('beksel',),
'beksla': ('beksel',),
'bekslene': ('beksel',),
'beksler': ('beksel',),
'bekslet': ('beksel',),
'bekselring': ('bekselring',),
'bekselringen': ('bekselring',),
'bekselringene': ('bekselring',),
'bekselringer': ('bekselring',),
'bekstein': ('bekstein',),
'beksteinen': ('bekstein',),
'beksteinene': ('bekstein',),
'beksteiner': ('bekstein',),
'beksøm': ('beksøm',),
'beksømmen': ('beksøm',),
'beksømmene': ('beksøm',),
'beksømmer': ('beksøm',),
'beksømsko': ('beksømsko',),
'beksømskoa': ('beksømsko',),
'beksømskoen': ('beksømsko',),
'beksømskoene': ('beksømsko',),
'beksømskor': ('beksømsko',),
'beksømskorne': ('beksømsko',),
'beksømstøvel': ('beksømstøvel',),
'beksømstøvelen': ('beksømstøvel',),
'beksømstøvlene': ('beksømstøvel',),
'beksømstøvler': ('beksømstøvel',),
'bektråd': ('bektråd',),
'bektråden': ('bektråd',),
'bektrådene': ('bektråd',),
'bektråder': ('bektråd',),
'bekvemmelighet': ('bekvemmelighet',),
'bekvemmeligheta': ('bekvemmelighet',),
'bekvemmeligheten': ('bekvemmelighet',),
'bekvemmelighetene': ('bekvemmelighet',),
'bekvemmeligheter': ('bekvemmelighet',),
'bekvemmelighetsflagg': ('bekvemmelighetsflagg',),
'bekvemmelighetsflagga': ('bekvemmelighetsflagg',),
'bekvemmelighetsflaggene': ('bekvemmelighetsflagg',),
'bekvemmelighetsflagget': ('bekvemmelighetsflagg',),
'bekvemmelighetshensyn': ('bekvemmelighetshensyn',),
'bekvemmelighetshensyna': ('bekvemmelighetshensyn',),
'bekvemmelighetshensynene': ('bekvemmelighetshensyn',),
'bekvemmelighetshensynet': ('bekvemmelighetshensyn',),
'bekymring': ('bekymring',),
'bekymringa': ('bekymring',),
'bekymringen': ('bekymring',),
'bekymringene': ('bekymring',),
'bekymringer': ('bekymring',),
'bel': ('bel',),
'belen': ('bel',),
'belene': ('bel',),
'bel canto': ('bel canto',),
'bel cantoen': ('bel canto',),
'bel cantoene': ('bel canto',),
'bel cantoer': ('bel canto',),
'belastning': ('belastning',),
'belastninga': ('belastning',),
'belastningen': ('belastning',),
'belastningene': ('belastning',),
'belastninger': ('belastning',),
'belastningsprøva': ('belastningsprøve',),
'belastningsprøve': ('belastningsprøve',),
'belastningsprøven': ('belastningsprøve',),
'belastningsprøvene': ('belastningsprøve',),
'belastningsprøver': ('belastningsprøve',),
'belastningssjukdom': ('belastningssjukdom',),
'belastningssjukdommen': ('belastningssjukdom',),
'belastningssjukdommene': ('belastningssjukdom',),
'belastningssjukdommer': ('belastningssjukdom',),
'belastningssykdom': ('belastningssykdom',),
'belastningssykdommen': ('belastningssykdom',),
'belastningssykdommene': ('belastningssykdom',),
'belastningssykdommer': ('belastningssykdom',),
'belegg': ('belegg',),
'belegga': ('belegg',),
'beleggene': ('belegg',),
'belegget': ('belegg',),
'beleggdannelse': ('beleggdannelse',),
'beleggdannelsen': ('beleggdannelse',),
'beleggdannelsene': ('beleggdannelse',),
'beleggdannelser': ('beleggdannelse',),
'beleggdanning': ('beleggdanning',),
'beleggdanninga': ('beleggdanning',),
'beleggdanningen': ('beleggdanning',),
'beleggdanningene': ('beleggdanning',),
'beleggdanninger': ('beleggdanning',),
'beleiring': ('beleiring',),
'beleiringa': ('beleiring',),
'beleiringen': ('beleiring',),
'beleiringene': ('beleiring',),
'beleiringer': ('beleiring',),
'beleiringstilstand': ('beleiringstilstand',),
'beleiringstilstanden': ('beleiringstilstand',),
'beleiringstilstandene': ('beleiringstilstand',),
'beleiringstilstander': ('beleiringstilstand',),
'belg': ('belg',),
'belgen': ('belg',),
'belgene': ('belg',),
'belger': ('belg',),
'belgetreder': ('belgetreder',),
'belgetredere': ('belgetreder',),
'belgetrederen': ('belgetreder',),
'belgetrederer': ('belgetreder',),
'belgetrederne': ('belgetreder',),
'belgfrukt': ('belgfrukt',),
'belgfrukta': ('belgfrukt',),
'belgfrukten': ('belgfrukt',),
'belgfruktene': ('belgfrukt',),
'belgfrukter': ('belgfrukt',),
'belgier': ('belgier',),
'belgiere': ('belgier',),
'belgieren': ('belgier',),
'belgierer': ('belgier',),
'belgierne': ('belgier',),
'belgkapsel': ('belgkapsel',),
'belgkapselen': ('belgkapsel',),
'belgkapslene': ('belgkapsel',),
'belgkapsler': ('belgkapsel',),
'belgmørka': ('belgmørke',),
'belgmørke': ('belgmørke',),
'belgmørkene': ('belgmørke',),
'belgmørker': ('belgmørke',),
'belgmørket': ('belgmørke',),
'belgplanta': ('belgplante',),
'belgplante': ('belgplante',),
'belgplanten': ('belgplante',),
'belgplantene': ('belgplante',),
'belgplanter': ('belgplante',),
'belgtreder': ('belgtreder',),
'belgtredere': ('belgtreder',),
'belgtrederen': ('belgtreder',),
'belgtrederer': ('belgtreder',),
'belgtrederne': ('belgtreder',),
'beliggenhet': ('beliggenhet',),
'beliggenheta': ('beliggenhet',),
'beliggenheten': ('beliggenhet',),
'beliggenhetene': ('beliggenhet',),
'beliggenheter': ('beliggenhet',),
'belizer': ('belizer',),
'belizere': ('belizer',),
'belizeren': ('belizer',),
'belizerer': ('belizer',),
'belizerne': ('belizer',),
'belj': ('belj',),
'belja': ('belj',),
'beljen': ('belj',),
'beljene': ('belj',),
'beljet': ('belj',),
'belladonna': ('belladonna',),
'belladonnaen': ('belladonna',),
'belladonnaene': ('belladonna',),
'belladonnaer': ('belladonna',),
'belladonnablad': ('belladonnablad',),
'belladonnablada': ('belladonnablad',),
'belladonnabladene': ('belladonnablad',),
'belladonnablader': ('belladonnablad',),
'belladonnabladet': ('belladonnablad',),
'belling': ('belling',),
'bellingen': ('belling',),
'bellingene': ('belling',),
'bellinger': ('belling',),
'belt': ('belt',),
'belta': ('belt',),
'beltene': ('belt',),
'belter': ('belt',),
'beltet': ('belt',),
'belta': ('belte',),
'belte': ('belte',),
'beltene': ('belte',),
'belter': ('belte',),
'beltet': ('belte',),
'beltealge': ('beltealge',),
'beltealgen': ('beltealge',),
'beltealgene': ('beltealge',),
'beltealger': ('beltealge',),
'beltebil': ('beltebil',),
'beltebilen': ('beltebil',),
'beltebilene': ('beltebil',),
'beltebiler': ('beltebil',),
'beltedyr': ('beltedyr',),
'beltedyra': ('beltedyr',),
'beltedyrene': ('beltedyr',),
'beltedyret': ('beltedyr',),
'beltehogst': ('beltehogst',),
'beltehogsten': ('beltehogst',),
'beltehogstene': ('beltehogst',),
'beltehogster': ('beltehogst',),
'beltehugst': ('beltehugst',),
'beltehugsten': ('beltehugst',),
'beltehugstene': ('beltehugst',),
'beltehugster': ('beltehugst',),
'beltested': ('beltested',),
'beltesteda': ('beltested',),
'beltestedene': ('beltested',),
'beltestedet': ('beltested',),
'beltetraktor': ('beltetraktor',),
'beltetraktoren': ('beltetraktor',),
'beltetraktorene': ('beltetraktor',),
'beltetraktorer': ('beltetraktor',),
'belysning': ('belysning',),
'belysninga': ('belysning',),
'belysningen': ('belysning',),
'belysningene': ('belysning',),
'belysninger': ('belysning',),
'belysningsstyrke': ('belysningsstyrke',),
'belysningsstyrken': ('belysningsstyrke',),
'belysningsstyrkene': ('belysningsstyrke',),
'belysningsstyrker': ('belysningsstyrke',),
'belønning': ('belønning',),
'belønninga': ('belønning',),
'belønningen': ('belønning',),
'belønningene': ('belønning',),
'belønninger': ('belønning',),
'beløp': ('beløp',),
'beløpa': ('beløp',),
'beløpene': ('beløp',),
'beløpet': ('beløp',),
'bemanning': ('bemanning',),
'bemanninga': ('bemanning',),
'bemanningen': ('bemanning',),
'bemanningene': ('bemanning',),
'bemanninger': ('bemanning',),
'bemanningsforskrift': ('bemanningsforskrift',),
'bemanningsforskrifta': ('bemanningsforskrift',),
'bemanningsforskriftene': ('bemanningsforskrift',),
'bemanningsforskrifter': ('bemanningsforskrift',),
'bemanningsforskriftet': ('bemanningsforskrift',),
'bemanningskrisa': ('bemanningskrise',),
'bemanningskrise': ('bemanningskrise',),
'bemanningskrisen': ('bemanningskrise',),
'bemanningskrisene': ('bemanningskrise',),
'bemanningskriser': ('bemanningskrise',),
'bemanningslista': ('bemanningsliste',),
'bemanningsliste': ('bemanningsliste',),
'bemanningslisten': ('bemanningsliste',),
'bemanningslistene': ('bemanningsliste',),
'bemanningslister': ('bemanningsliste',),
'bemanningssituasjon': ('bemanningssituasjon',),
'bemanningssituasjonen': ('bemanningssituasjon',),
'bemanningssituasjonene': ('bemanningssituasjon',),
'bemanningssituasjoner': ('bemanningssituasjon',),
'bemerkning': ('bemerkning',),
'bemerkninga': ('bemerkning',),
'bemerkningen': ('bemerkning',),
'bemerkningene': ('bemerkning',),
'bemerkninger': ('bemerkning',),
'bemyndigelse': ('bemyndigelse',),
'bemyndigelsen': ('bemyndigelse',),
'bemyndigelsene': ('bemyndigelse',),
'bemyndigelser': ('bemyndigelse',),
'ben': ('ben',),
'bena': ('ben',),
'benene': ('ben',),
'benet': ('ben',),
'benarbeid': ('benarbeid',),
'benarbeida': ('benarbeid',),
'benarbeidene': ('benarbeid',),
'benarbeider': ('benarbeid',),
'benarbeidet': ('benarbeid',),
'benbetennelse': ('benbetennelse',),
'benbetennelsen': ('benbetennelse',),
'benbetennelsene': ('benbetennelse',),
'benbetennelser': ('benbetennelse',),
'benbrudd': ('benbrudd',),
'benbrudda': ('benbrudd',),
'benbruddene': ('benbrudd',),
'benbruddet': ('benbrudd',),
'benbygning': ('benbygning',),
'benbygninga': ('benbygning',),
'benbygningen': ('benbygning',),
'benbygningene': ('benbygning',),
'benbygninger': ('benbygning',),
'bend': ('bend',),
'benda': ('bend',),
'bendene': ('bend',),
'bendet': ('bend',),
'bendel': ('bendel',),
'bendelen': ('bendel',),
'bendlene': ('bendel',),
'bendler': ('bendel',),
'bendelband': ('bendelband',),
'bendelbanda': ('bendelband',),
'bendelbandene': ('bendelband',),
'bendelbandet': ('bendelband',),
'bendelbånd': ('bendelbånd',),
'bendelbånda': ('bendelbånd',),
'bendelbåndene': ('bendelbånd',),
'bendelbåndet': ('bendelbånd',),
'bendelorm': ('bendelorm',),
'bendelormen': ('bendelorm',),
'bendelormene': ('bendelorm',),
'bendelormer': ('bendelorm',),
'bendsel': ('bendsel',),
'bendselet': ('bendsel',),
'bendsla': ('bendsel',),
'bendslene': ('bendsel',),
'bendsler': ('bendsel',),
'bendslet': ('bendsel',),
'benediksjon': ('benediksjon',),
'benediksjonen': ('benediksjon',),
'benediksjonene': ('benediksjon',),
'benediksjoner': ('benediksjon',),
'benediktiner': ('benediktiner',),
'benediktinere': ('benediktiner',),
'benediktineren': ('benediktiner',),
'benediktinerer': ('benediktiner',),
'benediktinerne': ('benediktiner',),
'benediktinerkloster': ('benediktinerkloster',),
'benediktinerklosteret': ('benediktinerkloster',),
'benediktinerklostra': ('benediktinerkloster',),
'benediktinerklostre': ('benediktinerkloster',),
'benediktinerklostrene': ('benediktinerkloster',),
'benediktinerklostret': ('benediktinerkloster',),
'benediktinerlikør': ('benediktinerlikør',),
'benediktinerlikøren': ('benediktinerlikør',),
'benediktinerlikørene': ('benediktinerlikør',),
'benediktinerlikører': ('benediktinerlikør',),
'benediktinermunk': ('benediktinermunk',),
'benediktinermunken': ('benediktinermunk',),
'benediktinermunkene': ('benediktinermunk',),
'benediktinermunker': ('benediktinermunk',),
'benediktinernonna': ('benediktinernonne',),
'benediktinernonne': ('benediktinernonne',),
'benediktinernonnen': ('benediktinernonne',),
'benediktinernonnene': ('benediktinernonne',),
'benediktinernonner': ('benediktinernonne',),
'benediktinerorden': ('benediktinerorden',),
'benediktinerordenen': ('benediktinerorden',),
'benediktinerordenene': ('benediktinerorden',),
'benediktinerordener': ('benediktinerorden',),
'benefice': ('benefice',),
'beneficen': ('benefice',),
'beneficene': ('benefice',),
'beneficer': ('benefice',),
'beneficeforestilling': ('beneficeforestilling',),
'beneficeforestillinga': ('beneficeforestilling',),
'beneficeforestillingen': ('beneficeforestilling',),
'beneficeforestillingene': ('beneficeforestilling',),
'beneficeforestillinger': ('beneficeforestilling',),
'benevnelse': ('benevnelse',),
'benevnelsen': ('benevnelse',),
'benevnelsene': ('benevnelse',),
'benevnelser': ('benevnelse',),
'benevning': ('benevning',),
'benevninga': ('benevning',),
'benevningen': ('benevning',),
'benevningene': ('benevning',),
'benevninger': ('benevning',),
'benfisk': ('benfisk',),
'benfisken': ('benfisk',),
'benfiskene': ('benfisk',),
'benfisker': ('benfisk',),
'bengaler': ('bengaler',),
'bengalere': ('bengaler',),
'bengaleren': ('bengaler',),
'bengalerer': ('bengaler',),
'bengalerne': ('bengaler',),
'bengali': ('bengali',),
'bengalien': ('bengali',),
'bengaliene': ('bengali',),
'bengalier': ('bengali',),
'bengel': ('bengel',),
'bengelen': ('bengel',),
'benglene': ('bengel',),
'bengler': ('bengel',),
'beniner': ('beniner',),
'beninere': ('beniner',),
'benineren': ('beniner',),
'beninerer': ('beniner',),
'beninerne': ('beniner',),
'benjamin': ('benjamin',),
'benjaminen': ('benjamin',),
'benjaminene': ('benjamin',),
'benjaminer': ('benjamin',),
'benk': ('benk',),
'benken': ('benk',),
'benkene': ('benk',),
'benker': ('benk',),
'benkboremaskin': ('benkboremaskin',),
'benkboremaskina': ('benkboremaskin',),
'benkboremaskinen': ('benkboremaskin',),
'benkboremaskinene': ('benkboremaskin',),
'benkboremaskiner': ('benkboremaskin',),
'benkebiter': ('benkebiter',),
'benkebitere': ('benkebiter',),
'benkebiteren': ('benkebiter',),
'benkebiterer': ('benkebiter',),
'benkebiterne': ('benkebiter',),
'benkeforslag': ('benkeforslag',),
'benkeforslaga': ('benkeforslag',),
'benkeforslagene': ('benkeforslag',),
'benkeforslaget': ('benkeforslag',),
'benkeframlegg': ('benkeframlegg',),
'benkeframlegga': ('benkeframlegg',),
'benkeframleggene': ('benkeframlegg',),
'benkeframlegget': ('benkeframlegg',),
'benkerad': ('benkerad',),
'benkerada': ('benkerad',),
'benkeraden': ('benkerad',),
'benkeradene': ('benkerad',),
'benkerader': ('benkerad',),
'benkesliter': ('benkesliter',),
'benkeslitere': ('benkesliter',),
'benkesliteren': ('benkesliter',),
'benkesliterer': ('benkesliter',),
'benkesliterne': ('benkesliter',),
'benklær': ('benklær',),
'benklærne': ('benklær',),
'benkrok': ('benkrok',),
'benkroken': ('benkrok',),
'benkrokene': ('benkrok',),
'benkroker': ('benkrok',),
'benlim': ('benlim',),
'benlima': ('benlim',),
'benlimene': ('benlim',),
'benlimet': ('benlim',),
'benmarg': ('benmarg',),
'benmargen': ('benmarg',),
'benmargene': ('benmarg',),
'benmarger': ('benmarg',),
'benmarg': ('benmarg',),
'benmargen': ('benmarg',),
'benmargene': ('benmarg',),
'benmarger': ('benmarg',),
'benmarg': ('benmarg',),
'benmargen': ('benmarg',),
'benmargene': ('benmarg',),
'benmarger': ('benmarg',),
'benmel': ('benmel',),
'benmela': ('benmel',),
'benmelene': ('benmel',),
'benmelet': ('benmel',),
'benmerg': ('benmerg',),
'benmergen': ('benmerg',),
'benmergene': ('benmerg',),
'benmerger': ('benmerg',),
'benmerg': ('benmerg',),
'benmergen': ('benmerg',),
'benmergene': ('benmerg',),
'benmerger': ('benmerg',),
'benmerg': ('benmerg',),
'benmergen': ('benmerg',),
'benmergene': ('benmerg',),
'benmerger': ('benmerg',),
'benmjøl': ('benmjøl',),
'benmjøla': ('benmjøl',),
'benmjølene': ('benmjøl',),
'benmjølet': ('benmjøl',),
'benpipa': ('benpipe',),
'benpipe': ('benpipe',),
'benpipen': ('benpipe',),
'benpipene': ('benpipe',),
'benpiper': ('benpipe',),
'benrangel': ('benrangel',),
'benrangelet': ('benrangel',),
'benrangla': ('benrangel',),
'benranglene': ('benrangel',),
'benrangler': ('benrangel',),
'benranglet': ('benrangel',),
'bensin': ('bensin',),
'bensinen': ('bensin',),
'bensinene': ('bensin',),
'bensiner': ('bensin',),
'bensinavgift': ('bensinavgift',),
'bensinavgifta': ('bensinavgift',),
'bensinavgiften': ('bensinavgift',),
'bensinavgiftene': ('bensinavgift',),
'bensinavgifter': ('bensinavgift',),
'bensinfat': ('bensinfat',),
'bensinfata': ('bensinfat',),
'bensinfatene': ('bensinfat',),
'bensinfater': ('bensinfat',),
'bensinfatet': ('bensinfat',),
'bensinforbruk': ('bensinforbruk',),
'bensinforbruka': ('bensinforbruk',),
'bensinforbrukene': ('bensinforbruk',),
'bensinforbruket': ('bensinforbruk',),
'bensinmotor': ('bensinmotor',),
'bensinmotoren': ('bensinmotor',),
'bensinmotorene': ('bensinmotor',),
'bensinmotorer': ('bensinmotor',),
'bensinpumpa': ('bensinpumpe',),
'bensinpumpe': ('bensinpumpe',),
'bensinpumpen': ('bensinpumpe',),
'bensinpumpene': ('bensinpumpe',),
'bensinpumper': ('bensinpumpe',),
'bensinstasjon': ('bensinstasjon',),
'bensinstasjonen': ('bensinstasjon',),
'bensinstasjonene': ('bensinstasjon',),
'bensinstasjoner': ('bensinstasjon',),
'bensinstasjonskjede': ('bensinstasjonskjede',),
'bensinstasjonskjeden': ('bensinstasjonskjede',),
'bensinstasjonskjedene': ('bensinstasjonskjede',),
'bensinstasjonskjeder': ('bensinstasjonskjede',),
'bensintank': ('bensintank',),
'bensintanken': ('bensintank',),
'bensintankene': ('bensintank',),
'bensintanker': ('bensintank',),
'bensintilførsel': ('bensintilførsel',),
'bensintilførselen': ('bensintilførsel',),
'bensintilførslene': ('bensintilførsel',),
'bensintilførsler': ('bensintilførsel',),
'benskurd': ('benskurd',),
'benskurden': ('benskurd',),
'benskurdene': ('benskurd',),
'benskurder': ('benskurd',),
'bensplint': ('bensplint',),
'bensplinten': ('bensplint',),
'bensplintene': ('bensplint',),
'bensplinter': ('bensplint',),
'bensubstans': ('bensubstans',),
'bensubstansen': ('bensubstans',),
'bensubstansene': ('bensubstans',),
'bensubstanser': ('bensubstans',),
'benved': ('benved',),
'benveden': ('benved',),
'benvedene': ('benved',),
'benveder': ('benved',),
'benveg': ('benveg',),
'benvegen': ('benveg',),
'benvegene': ('benveg',),
'benveger': ('benveg',),
'benvei': ('benvei',),
'benveien': ('benvei',),
'benveiene': ('benvei',),
'benveier': ('benvei',),
'benvev': ('benvev',),
'benveva': ('benvev',),
'benvevene': ('benvev',),
'benvevet': ('benvev',),
'benzen': ('benzen',),
'benzena': ('benzen',),
'benzenene': ('benzen',),
'benzenet': ('benzen',),
'benzensprit': ('benzensprit',),
'benzenspriten': ('benzensprit',),
'benzenspritene': ('benzensprit',),
'benzenspriter': ('benzensprit',),
'benådning': ('benådning',),
'benådninga': ('benådning',),
'benådningen': ('benådning',),
'benådningene': ('benådning',),
'benådninger': ('benådning',),
'beplantning': ('beplantning',),
'beplantninga': ('beplantning',),
'beplantningen': ('beplantning',),
'beplantningene': ('beplantning',),
'beplantninger': ('beplantning',),
'berber': ('berber',),
'berbere': ('berber',),
'berberen': ('berber',),
'berberer': ('berber',),
'berberne': ('berber',),
'berberis': ('berberis',),
'berberisen': ('berberis',),
'berberisene': ('berberis',),
'berberiser': ('berberis',),
'berberisbusk': ('berberisbusk',),
'berberisbusken': ('berberisbusk',),
'berberisbuskene': ('berberisbusk',),
'berberisbusker': ('berberisbusk',),
'berberspråk': ('berberspråk',),
'berberspråka': ('berberspråk',),
'berberspråkene': ('berberspråk',),
'berberspråket': ('berberspråk',),
'berbisk': ('berbisk',),
'berbisken': ('berbisk',),
'berbiskene': ('berbisk',),
'berbisker': ('berbisk',),
'berceuse': ('berceuse',),
'berceusen': ('berceuse',),
'berceusene': ('berceuse',),
'berceuser': ('berceuse',),
'bereder': ('bereder',),
'beredere': ('bereder',),
'berederen': ('bereder',),
'berederer': ('bereder',),
'berederne': ('bereder',),
'beredskap': ('beredskap',),
'beredskapa': ('beredskap',),
'beredskapen': ('beredskap',),
'beredskapene': ('beredskap',),
'beredskaper': ('beredskap',),
'beredskapet': ('beredskap',),
'beredskapslager': ('beredskapslager',),
'beredskapslageret': ('beredskapslager',),
'beredskapslagra': ('beredskapslager',),
'beredskapslagre': ('beredskapslager',),
'beredskapslagrene': ('beredskapslager',),
'beredskapslov': ('beredskapslov',),
'beredskapsloven': ('beredskapslov',),
'beredskapslovene': ('beredskapslov',),
'beredskapslover': ('beredskapslov',),
'beredskapstiltak': ('beredskapstiltak',),
'beredskapstiltaka': ('beredskapstiltak',),
'beredskapstiltakene': ('beredskapstiltak',),
'beredskapstiltaket': ('beredskapstiltak',),
'beregner': ('beregner',),
'beregnere': ('beregner',),
'beregneren': ('beregner',),
'beregnerer': ('beregner',),
'beregnerne': ('beregner',),
'beregning': ('beregning',),
'beregninga': ('beregning',),
'beregningen': ('beregning',),
'beregningene': ('beregning',),
'beregninger': ('beregning',),
'beregningsfeil': ('beregningsfeil',),
'beregningsfeilen': ('beregningsfeil',),
'beregningsfeilene': ('beregningsfeil',),
'beregningsgrunnlag': ('beregningsgrunnlag',),
'beregningsgrunnlaga': ('beregningsgrunnlag',),
'beregningsgrunnlagene': ('beregningsgrunnlag',),
'beregningsgrunnlaget': ('beregningsgrunnlag',),
'beregningsmåte': ('beregningsmåte',),
'beregningsmåten': ('beregningsmåte',),
'beregningsmåtene': ('beregningsmåte',),
'beregningsmåter': ('beregningsmåte',),
'beregningssum': ('beregningssum',),
'beregningssummen': ('beregningssum',),
'beregningssummene': ('beregningssum',),
'beregningssummer': ('beregningssum',),
'berekner': ('berekner',),
'bereknere': ('berekner',),
'berekneren': ('berekner',),
'bereknerer': ('berekner',),
'bereknerne': ('berekner',),
'berekning': ('berekning',),
'berekninga': ('berekning',),
'berekningen': ('berekning',),
'berekningene': ('berekning',),
'berekninger': ('berekning',),
'berekningsfeil': ('berekningsfeil',),
'berekningsfeilen': ('berekningsfeil',),
'berekningsfeilene': ('berekningsfeil',),
'berekningsgrunnlag': ('berekningsgrunnlag',),
'berekningsgrunnlaga': ('berekningsgrunnlag',),
'berekningsgrunnlagene': ('berekningsgrunnlag',),
'berekningsgrunnlaget': ('berekningsgrunnlag',),
'berekningsmåte': ('berekningsmåte',),
'berekningsmåten': ('berekningsmåte',),
'berekningsmåtene': ('berekningsmåte',),
'berekningsmåter': ('berekningsmåte',),
'berekningssum': ('berekningssum',),
'berekningssummen': ('berekningssum',),
'berekningssummene': ('berekningssum',),
'berekningssummer': ('berekningssum',),
'beret': ('beret',),
'bereten': ('beret',),
'beretene': ('beret',),
'bereter': ('beret',),
'beretning': ('beretning',),
'beretninga': ('beretning',),
'beretningen': ('beretning',),
'beretningene': ('beretning',),
'beretninger': ('beretning',),
'beretter': ('beretter',),
'berettere': ('beretter',),
'beretteren': ('beretter',),
'beretterer': ('beretter',),
'beretterne': ('beretter',),
'berettigelse': ('berettigelse',),
'berettigelsen': ('berettigelse',),
'berettigelsene': ('berettigelse',),
'berettigelser': ('berettigelse',),
'berg': ('berg',),
'berga': ('berg',),
'bergene': ('berg',),
'berget': ('berg',),
'berg-og-dal-bane': ('berg-og-dal-bane',),
'berg-og-dal-banen': ('berg-og-dal-bane',),
'berg-og-dal-banene': ('berg-og-dal-bane',),
'berg-og-dal-baner': ('berg-og-dal-bane',),
'bergamott': ('bergamott',),
'bergamotten': ('bergamott',),
'bergamottene': ('bergamott',),
'bergamotter': ('bergamott',),
'bergamottappelsin': ('bergamottappelsin',),
'bergamottappelsinen': ('bergamottappelsin',),
'bergamottappelsinene': ('bergamottappelsin',),
'bergamottappelsiner': ('bergamottappelsin',),
'bergamottolja': ('bergamottolje',),
'bergamottolje': ('bergamottolje',),
'bergamottoljen': ('bergamottolje',),
'bergamottoljene': ('bergamottolje',),
'bergamottoljer': ('bergamottolje',),
'bergamottpæra': ('bergamottpære',),
'bergamottpære': ('bergamottpære',),
'bergamottpæren': ('bergamottpære',),
'bergamottpærene': ('bergamottpære',),
'bergamottpærer': ('bergamottpære',),
'bergand': ('bergand',),
'berganda': ('bergand',),
'berganden': ('bergand',),
'bergendene': ('bergand',),
'bergender': ('bergand',),
'bergart': ('bergart',),
'bergarta': ('bergart',),
'bergarten': ('bergart',),
'bergartene': ('bergart',),
'bergarter': ('bergart',),
'bergartilleri': ('bergartilleri',),
'bergartilleria': ('bergartilleri',),
'bergartilleriene': ('bergartilleri',),
'bergartillerier': ('bergartilleri',),
'bergartilleriet': ('bergartilleri',),
'bergelønn': ('bergelønn',),
'bergelønna': ('bergelønn',),
'bergelønnen': ('bergelønn',),
'bergelønnene': ('bergelønn',),
'bergelønner': ('bergelønn',),
'bergenser': ('bergenser',),
'bergensere': ('bergenser',),
'bergenseren': ('bergenser',),
'bergenserer': ('bergenser',),
'bergenserne': ('bergenser',),
'bergfag': ('bergfag',),
'bergfaga': ('bergfag',),
'bergfagene': ('bergfag',),
'bergfaget': ('bergfag',),
'bergfletta': ('bergflette',),
'bergflette': ('bergflette',),
'bergfletten': ('bergflette',),
'bergflettene': ('bergflette',),
'bergfletter': ('bergflette',),
'bergflettefamilie': ('bergflettefamilie',),
'bergflettefamilien': ('bergflettefamilie',),
'bergflettefamiliene': ('bergflettefamilie',),
'bergflettefamilier': ('bergflettefamilie',),
'bergfrua': ('bergfrue',),
'bergfrue': ('bergfrue',),
'bergfruen': ('bergfrue',),
'bergfruene': ('bergfrue',),
'bergfruer': ('bergfrue',),
'berggylta': ('berggylte',),
'berggylte': ('berggylte',),
'berggylten': ('berggylte',),
'berggyltene': ('berggylte',),
'berggylter': ('berggylte',),
'berghammar': ('berghammar',),
'berghammaren': ('berghammar',),
'berghamrene': ('berghammar',),
'berghamrer': ('berghammar',),
'berghammer': ('berghammer',),
'berghammere': ('berghammer',),
'berghammeren': ('berghammer',),
'berghammerer': ('berghammer',),
'berghammerne': ('berghammer',),
'berghamrene': ('berghammer',),
'berghamrer': ('berghammer',),
'berghola': ('berghole',),
'berghole': ('berghole',),
'bergholen': ('berghole',),
'bergholene': ('berghole',),
'bergholer': ('berghole',),
'berghula': ('berghule',),
'berghule': ('berghule',),
'berghulen': ('berghule',),
'berghulene': ('berghule',),
'berghuler': ('berghule',),
'berghylla': ('berghylle',),
'berghylle': ('berghylle',),
'berghyllen': ('berghylle',),
'berghyllene': ('berghylle',),
'berghyller': ('berghylle',),
'berging': ('berging',),
'berginga': ('berging',),
'bergingen': ('berging',),
'bergingene': ('berging',),
'berginger': ('berging',),
'bergingeniør': ('bergingeniør',),
'bergingeniøren': ('bergingeniør',),
'bergingeniørene': ('bergingeniør',),
'bergingeniører': ('bergingeniør',),
'bergingsarbeid': ('bergingsarbeid',),
'bergingsarbeida': ('bergingsarbeid',),
'bergingsarbeidene': ('bergingsarbeid',),
'bergingsarbeider': ('bergingsarbeid',),
'bergingsarbeidet': ('bergingsarbeid',),
'bergingsbåt': ('bergingsbåt',),
'bergingsbåten': ('bergingsbåt',),
'bergingsbåtene': ('bergingsbåt',),
'bergingsbåter': ('bergingsbåt',),
'bergingsfartøy': ('bergingsfartøy',),
'bergingsfartøya': ('bergingsfartøy',),
'bergingsfartøyene': ('bergingsfartøy',),
'bergingsfartøyer': ('bergingsfartøy',),
'bergingsfartøyet': ('bergingsfartøy',),
'bergingsforsøk': ('bergingsforsøk',),
'bergingsforsøka': ('bergingsforsøk',),
'bergingsforsøkene': ('bergingsforsøk',),
'bergingsforsøket': ('bergingsforsøk',),
'bergirisk': ('bergirisk',),
'bergirisken': ('bergirisk',),
'bergiriskene': ('bergirisk',),
'bergirisker': ('bergirisk',),
'bergknapp': ('bergknapp',),
'bergknappen': ('bergknapp',),
'bergknappene': ('bergknapp',),
'bergknapper': ('bergknapp',),
'bergknaus': ('bergknaus',),
'bergknausen': ('bergknaus',),
'bergknausene': ('bergknaus',),
'bergknauser': ('bergknaus',),
'bergkrystall': ('bergkrystall',),
'bergkrystalla': ('bergkrystall',),
'bergkrystallen': ('bergkrystall',),
'bergkrystallene': ('bergkrystall',),
'bergkrystaller': ('bergkrystall',),
'bergkrystallet': ('bergkrystall',),
'bergmann': ('bergmann',),
'bergmannen': ('bergmann',),
'bergmenn': ('bergmann',),
'bergmennene': ('bergmann',),
'bergmester': ('bergmester',),
'bergmestere': ('bergmester',),
'bergmesteren': ('bergmester',),
'bergmesterer': ('bergmester',),
'bergmesterne': ('bergmester',),
'bergmestre': ('bergmester',),
'bergmestrene': ('bergmester',),
'bergmestrer': ('bergmester',),
'bergmynta': ('bergmynte',),
'bergmynte': ('bergmynte',),
'bergmynten': ('bergmynte',),
'bergmyntene': ('bergmynte',),
'bergmynter': ('bergmynte',),
'bergnabb': ('bergnabb',),
'bergnabben': ('bergnabb',),
'bergnabbene': ('bergnabb',),
'bergnabber': ('bergnabb',),
'bergnebb': ('bergnebb',),
'bergnebben': ('bergnebb',),
'bergnebbene': ('bergnebb',),
'bergnebber': ('bergnebb',),
'bergnebba': ('bergnebbe',),
'bergnebbe': ('bergnebbe',),
'bergnebben': ('bergnebbe',),
'bergnebbene': ('bergnebbe',),
'bergnebber': ('bergnebbe',),
'bergpreken': ('bergpreken',),
'bergprekenen': ('bergpreken',),
'bergprekenene': ('bergpreken',),
'bergprekener': ('bergpreken',),
'bergsildra': ('bergsildre',),
'bergsildre': ('bergsildre',),
'bergsildren': ('bergsildre',),
'bergsildrene': ('bergsildre',),
'bergsildrer': ('bergsildre',),
'bergugla': ('bergugle',),
'bergugle': ('bergugle',),
'berguglen': ('bergugle',),
'berguglene': ('bergugle',),
'bergugler': ('bergugle',),
'bergvegg': ('bergvegg',),
'bergveggen': ('bergvegg',),
'bergveggene': ('bergvegg',),
'bergvegger': ('bergvegg',),
'bergverk': ('bergverk',),
'bergverka': ('bergverk',),
'bergverkene': ('bergverk',),
'bergverker': ('bergverk',),
'bergverket': ('bergverk',),
'bergverksdrift': ('bergverksdrift',),
'bergverksdrifta': ('bergverksdrift',),
'bergverksdriften': ('bergverksdrift',),
'bergverksdriftene': ('bergverksdrift',),
'bergverksdrifter': ('bergverksdrift',),
'bergveronika': ('bergveronika',),
'bergveronikaen': ('bergveronika',),
'bergveronikaene': ('bergveronika',),
'bergveronikaer': ('bergveronika',),
'bergvesen': ('bergvesen',),
'bergvesena': ('bergvesen',),
'bergvesenene': ('bergvesen',),
'bergvesener': ('bergvesen',),
'bergvesenet': ('bergvesen',),
'beriberi': ('beriberi',),
'beriberien': ('beriberi',),
'beriberiene': ('beriberi',),
'beriberier': ('beriberi',),
'berider': ('berider',),
'beridere': ('berider',),
'berideren': ('berider',),
'beriderer': ('berider',),
'beriderne': ('berider',),
'beriderska': ('beriderske',),
'beriderske': ('beriderske',),
'beridersken': ('beriderske',),
'beriderskene': ('beriderske',),
'beridersker': ('beriderske',),
'beriktigelse': ('beriktigelse',),
'beriktigelsen': ('beriktigelse',),
'beriktigelsene': ('beriktigelse',),
'beriktigelser': ('beriktigelse',),
'berkelium': ('berkelium',),
'berkeliuma': ('berkelium',),
'berkeliumene': ('berkelium',),
'berkeliumet': ('berkelium',),
'berlinblått': ('berlinblått',),
'berliner': ('berliner',),
'berlinere': ('berliner',),
'berlineren': ('berliner',),
'berlinerer': ('berliner',),
'berlinerne': ('berliner',),
'berlinerblått': ('berlinerblått',),
'berlinerbolle': ('berlinerbolle',),
'berlinerbollen': ('berlinerbolle',),
'berlinerbollene': ('berlinerbolle',),
'berlinerboller': ('berlinerbolle',),
'berlinerkrans': ('berlinerkrans',),
'berlinerkransen': ('berlinerkrans',),
'berlinerkransene': ('berlinerkrans',),
'berlinerkranser': ('berlinerkrans',),
'berme': ('berme',),
'bermen': ('berme',),
'bermene': ('berme',),
'bermer': ('berme',),
'bermudarigg': ('bermudarigg',),
'bermudariggen': ('bermudarigg',),
'bermudariggene': ('bermudarigg',),
'bermudarigger': ('bermudarigg',),
'bermudashorts': ('bermudashorts',),
'bermudashortsen': ('bermudashorts',),
'bermudashortsene': ('bermudashorts',),
'bermudashortser': ('bermudashorts',),
'bernhardiner': ('bernhardiner',),
'bernhardinere': ('bernhardiner',),
'bernhardineren': ('bernhardiner',),
'bernhardinerer': ('bernhardiner',),
'bernhardinerne': ('bernhardiner',),
'bero': ('bero',),
'berserk': ('berserk',),
'berserken': ('berserk',),
'berserkene': ('berserk',),
'berserker': ('berserk',),
'berserkgang': ('berserkgang',),
'berserkgangen': ('berserkgang',),
'berserkgangene': ('berserkgang',),
'berserkganger': ('berserkgang',),
'berserksgang': ('berserksgang',),
'berserksgangen': ('berserksgang',),
'berserksgangene': ('berserksgang',),
'berserksganger': ('berserksgang',),
'beryll': ('beryll',),
'beryllen': ('beryll',),
'beryllene': ('beryll',),
'beryller': ('beryll',),
'beryllium': ('beryllium',),
'berylliuma': ('beryllium',),
'berylliumene': ('beryllium',),
'berylliumet': ('beryllium',),
'berømmelse': ('berømmelse',),
'berømmelsen': ('berømmelse',),
'berømmelsene': ('berømmelse',),
'berømmelser': ('berømmelse',),
'berømthet': ('berømthet',),
'berømtheta': ('berømthet',),
'berømtheten': ('berømthet',),
'berømthetene': ('berømthet',),
'berømtheter': ('berømthet',),
'berøring': ('berøring',),
'berøringa': ('berøring',),
'berøringen': ('berøring',),
'berøringene': ('berøring',),
'berøringer': ('berøring',),
'berøringsflata': ('berøringsflate',),
'berøringsflate': ('berøringsflate',),
'berøringsflaten': ('berøringsflate',),
'berøringsflatene': ('berøringsflate',),
'berøringsflater': ('berøringsflate',),
'berøringspunkt': ('berøringspunkt',),
'berøringspunkta': ('berøringspunkt',),
'berøringspunktene': ('berøringspunkt',),
'berøringspunkter': ('berøringspunkt',),
'berøringspunktet': ('berøringspunkt',),
'berøvelse': ('berøvelse',),
'berøvelsen': ('berøvelse',),
'berøvelsene': ('berøvelse',),
'berøvelser': ('berøvelse',),
'beseirer': ('beseirer',),
'beseirere': ('beseirer',),
'beseireren': ('beseirer',),
'beseirerer': ('beseirer',),
'beseirerne': ('beseirer',),
'besetning': ('besetning',),
'besetninga': ('besetning',),
'besetningen': ('besetning',),
'besetningene': ('besetning',),
'besetninger': ('besetning',),
'besetningsband': ('besetningsband',),
'besetningsbanda': ('besetningsband',),
'besetningsbandene': ('besetningsband',),
'besetningsbandet': ('besetningsband',),
'besetningsbånd': ('besetningsbånd',),
'besetningsbånda': ('besetningsbånd',),
'besetningsbåndene': ('besetningsbånd',),
'besetningsbåndet': ('besetningsbånd',),
'besettelse': ('besettelse',),
'besettelsen': ('besettelse',),
'besettelsene': ('besettelse',),
'besettelser': ('besettelse',),
'besiktelse': ('besiktelse',),
'besiktelsen': ('besiktelse',),
'besiktelsene': ('besiktelse',),
'besiktelser': ('besiktelse',),
'besiktelsesmann': ('besiktelsesmann',),
'besiktelsesmannen': ('besiktelsesmann',),
'besiktelsesmenn': ('besiktelsesmann',),
'besiktelsesmennene': ('besiktelsesmann',),
'besiktigelse': ('besiktigelse',),
'besiktigelsen': ('besiktigelse',),
'besiktigelsene': ('besiktigelse',),
'besiktigelser': ('besiktigelse',),
'besindighet': ('besindighet',),
'besindigheta': ('besindighet',),
'besindigheten': ('besindighet',),
'besindighetene': ('besindighet',),
'besindigheter': ('besindighet',),
'besinnelse': ('besinnelse',),
'besinnelsen': ('besinnelse',),
'besinnelsene': ('besinnelse',),
'besinnelser': ('besinnelse',),
'besittelse': ('besittelse',),
'besittelsen': ('besittelse',),
'besittelsene': ('besittelse',),
'besittelser': ('besittelse',),
'besjeling': ('besjeling',),
'besjelinga': ('besjeling',),
'besjelingen': ('besjeling',),
'besjelingene': ('besjeling',),
'besjelinger': ('besjeling',),
'beskaffenhet': ('beskaffenhet',),
'beskaffenheta': ('beskaffenhet',),
'beskaffenheten': ('beskaffenhet',),
'beskaffenhetene': ('beskaffenhet',),
'beskaffenheter': ('beskaffenhet',),
'beskatning': ('beskatning',),
'beskatninga': ('beskatning',),
'beskatningen': ('beskatning',),
'beskatningene': ('beskatning',),
'beskatninger': ('beskatning',),
'beskatningsregel': ('beskatningsregel',),
'beskatningsregelen': ('beskatningsregel',),
'beskatningsreglene': ('beskatningsregel',),
'beskatningsregler': ('beskatningsregel',),
'beskjed': ('beskjed',),
'beskjeden': ('beskjed',),
'beskjedene': ('beskjed',),
'beskjeder': ('beskjed',),
'beskjedenhet': ('beskjedenhet',),
'beskjedenheta': ('beskjedenhet',),
'beskjedenheten': ('beskjedenhet',),
'beskjedenhetene': ('beskjedenhet',),
'beskjedenheter': ('beskjedenhet',),
'beskjeftigelse': ('beskjeftigelse',),
'beskjeftigelsen': ('beskjeftigelse',),
'beskjeftigelsene': ('beskjeftigelse',),
'beskjeftigelser': ('beskjeftigelse',),
'beskrivelse': ('beskrivelse',),
'beskrivelsen': ('beskrivelse',),
'beskrivelsene': ('beskrivelse',),
'beskrivelser': ('beskrivelse',),
'beskuelse': ('beskuelse',),
'beskuelsen': ('beskuelse',),
'beskuelsene': ('beskuelse',),
'beskuelser': ('beskuelse',),
'beskyldning': ('beskyldning',),
'beskyldninga': ('beskyldning',),
'beskyldningen': ('beskyldning',),
'beskyldningene': ('beskyldning',),
'beskyldninger': ('beskyldning',),
'beskyttelse': ('beskyttelse',),
'beskyttelsen': ('beskyttelse',),
'beskyttelsene': ('beskyttelse',),
'beskyttelser': ('beskyttelse',),
'beskyttelsesfarge': ('beskyttelsesfarge',),
'beskyttelsesfargen': ('beskyttelsesfarge',),
'beskyttelsesfargene': ('beskyttelsesfarge',),
'beskyttelsesfarger': ('beskyttelsesfarge',),
'beskyttelseslikhet': ('beskyttelseslikhet',),
'beskyttelseslikheta': ('beskyttelseslikhet',),
'beskyttelseslikheten': ('beskyttelseslikhet',),
'beskyttelseslikhetene': ('beskyttelseslikhet',),
'beskyttelseslikheter': ('beskyttelseslikhet',),
'beskytter': ('beskytter',),
'beskyttere': ('beskytter',),
'beskytteren': ('beskytter',),
'beskytterer': ('beskytter',),
'beskytterne': ('beskytter',),
'beskøyt': ('beskøyt',),
'beskøyten': ('beskøyt',),
'beskøytene': ('beskøyt',),
'beskøyter': ('beskøyt',),
'beslag': ('beslag',),
'beslaga': ('beslag',),
'beslagene': ('beslag',),
'beslaget': ('beslag',),
'beslutning': ('beslutning',),
'beslutninga': ('beslutning',),
'beslutningen': ('beslutning',),
'beslutningene': ('beslutning',),
'beslutninger': ('beslutning',),
'beslutningsprosess': ('beslutningsprosess',),
'beslutningsprosessen': ('beslutningsprosess',),
'beslutningsprosessene': ('beslutningsprosess',),
'beslutningsprosesser': ('beslutningsprosess',),
'besluttsomhet': ('besluttsomhet',),
'besluttsomheta': ('besluttsomhet',),
'besluttsomheten': ('besluttsomhet',),
'besluttsomhetene': ('besluttsomhet',),
'besluttsomheter': ('besluttsomhet',),
'besparelse': ('besparelse',),
'besparelsen': ('besparelse',),
'besparelsene': ('besparelse',),
'besparelser': ('besparelse',),
'bespisning': ('bespisning',),
'bespisninga': ('bespisning',),
'bespisningen': ('bespisning',),
'bespisningene': ('bespisning',),
'bespisninger': ('bespisning',),
'bessemerstål': ('bessemerstål',),
'bessemerståla': ('bessemerstål',),
'bessemerstålene': ('bessemerstål',),
'bessemerstålet': ('bessemerstål',),
'besserwissen': ('besserwissen',),
'besserwisser': ('besserwisser',),
'besserwissere': ('besserwisser',),
'besserwisseren': ('besserwisser',),
'besserwisserer': ('besserwisser',),
'besserwisserne': ('besserwisser',),
'best': ('best',),
'besta': ('best',),
'bestene': ('best',),
'bestet': ('best',),
'bestalling': ('bestalling',),
'bestallingen': ('bestalling',),
'bestallingene': ('bestalling',),
'bestallinger': ('bestalling',),
'bestand': ('bestand',),
'bestanden': ('bestand',),
'bestandene': ('bestand',),
'bestander': ('bestand',),
'bestand': ('bestand',),
'bestanda': ('bestand',),
'bestandene': ('bestand',),
'bestandet': ('bestand',),
'bestanddel': ('bestanddel',),
'bestanddelen': ('bestanddel',),
'bestanddelene': ('bestanddel',),
'bestanddeler': ('bestanddel',),
'bestandighet': ('bestandighet',),
'bestandigheta': ('bestandighet',),
'bestandigheten': ('bestandighet',),
'bestandighetene': ('bestandighet',),
'bestandigheter': ('bestandighet',),
'besteborger': ('besteborger',),
'besteborgere': ('besteborger',),
'besteborgeren': ('besteborger',),
'besteborgerer': ('besteborger',),
'besteborgerne': ('besteborger',),
'bestemann': ('bestemann',),
'bestemannen': ('bestemann',),
'bestemenn': ('bestemann',),
'bestemennene': ('bestemann',),
'bestemmelse': ('bestemmelse',),
'bestemmelsen': ('bestemmelse',),
'bestemmelsene': ('bestemmelse',),
'bestemmelser': ('bestemmelse',),
'bestemmelsessted': ('bestemmelsessted',),
'bestemmelsesstedene': ('bestemmelsessted',),
'bestemmelsessteder': ('bestemmelsessted',),
'bestemmelsesstedet': ('bestemmelsessted',),
'bestemor': ('bestemor',),
'bestemora': ('bestemor',),
'bestemoren': ('bestemor',),
'bestemødre': ('bestemor',),
'bestemødrene': ('bestemor',),
'bestemødrer': ('bestemor',),
'bestemthet': ('bestemthet',),
'bestemtheta': ('bestemthet',),
'bestemtheten': ('bestemthet',),
'bestemthetene': ('bestemthet',),
'bestemtheter': ('bestemthet',),
'bestenotering': ('bestenotering',),
'bestenoteringa': ('bestenotering',),
'bestenoteringen': ('bestenotering',),
'bestenoteringene': ('bestenotering',),
'bestenoteringer': ('bestenotering',),
'bestevenn': ('bestevenn',),
'bestevennen': ('bestevenn',),
'bestevennene': ('bestevenn',),
'bestevenner': ('bestevenn',),
'bestevenninna': ('bestevenninne',),
'bestevenninne': ('bestevenninne',),
'bestevenninnen': ('bestevenninne',),
'bestevenninnene': ('bestevenninne',),
'bestevenninner': ('bestevenninne',),
'bestevilkår': ('bestevilkår',),
'bestevilkåra': ('bestevilkår',),
'bestevilkårene': ('bestevilkår',),
'bestevilkåret': ('bestevilkår',),
'bestevilkårsavtale': ('bestevilkårsavtale',),
'bestevilkårsavtalen': ('bestevilkårsavtale',),
'bestevilkårsavtalene': ('bestevilkårsavtale',),
'bestevilkårsavtaler': ('bestevilkårsavtale',),
'bestialitet': ('bestialitet',),
'bestialiteten': ('bestialitet',),
'bestialitetene': ('bestialitet',),
'bestialiteter': ('bestialitet',),
'bestigelse': ('bestigelse',),
'bestigelsen': ('bestigelse',),
'bestigelsene': ('bestigelse',),
'bestigelser': ('bestigelse',),
'bestigning': ('bestigning',),
'bestigninga': ('bestigning',),
'bestigningen': ('bestigning',),
'bestigningene': ('bestigning',),
'bestigninger': ('bestigning',),
'bestikk': ('bestikk',),
'bestikken': ('bestikk',),
'bestikkene': ('bestikk',),
'bestikker': ('bestikk',),
'bestikkelse': ('bestikkelse',),
'bestikkelsen': ('bestikkelse',),
'bestikkelsene': ('bestikkelse',),
'bestikkelser': ('bestikkelse',),
'bestikklugar': ('bestikklugar',),
'bestikklugaren': ('bestikklugar',),
'bestikklugarene': ('bestikklugar',),
'bestikklugarer': ('bestikklugar',),
'bestikkoppgjør': ('bestikkoppgjør',),
'bestikkoppgjøra': ('bestikkoppgjør',),
'bestikkoppgjørene': ('bestikkoppgjør',),
'bestikkoppgjøret': ('bestikkoppgjør',),
'bestikktabell': ('bestikktabell',),
'bestikktabellen': ('bestikktabell',),
'bestikktabellene': ('bestikktabell',),
'bestikktabeller': ('bestikktabell',),
'bestilling': ('bestilling',),
'bestillingen': ('bestilling',),
'bestillingene': ('bestilling',),
'bestillinger': ('bestilling',),
'bestilling': ('bestilling',),
'bestillinga': ('bestilling',),
'bestillingen': ('bestilling',),
'bestillingene': ('bestilling',),
'bestillinger': ('bestilling',),
'bestillingstjuveri': ('bestillingstjuveri',),
'bestillingstjuveria': ('bestillingstjuveri',),
'bestillingstjuveriene': ('bestillingstjuveri',),
'bestillingstjuverier': ('bestillingstjuveri',),
'bestillingstjuveriet': ('bestillingstjuveri',),
'bestillingstyveri': ('bestillingstyveri',),
'bestillingstyveria': ('bestillingstyveri',),
'bestillingstyveriene': ('bestillingstyveri',),
'bestillingstyverier': ('bestillingstyveri',),
'bestillingstyveriet': ('bestillingstyveri',),
'bestillingsverk': ('bestillingsverk',),
'bestillingsverka': ('bestillingsverk',),
'bestillingsverkene': ('bestillingsverk',),
'bestillingsverker': ('bestillingsverk',),
'bestillingsverket': ('bestillingsverk',),
'bestrebelse': ('bestrebelse',),
'bestrebelsen': ('bestrebelse',),
'bestrebelsene': ('bestrebelse',),
'bestrebelser': ('bestrebelse',),
'bestselger': ('bestselger',),
'bestselgere': ('bestselger',),
'bestselgeren': ('bestselger',),
'bestselgerer': ('bestselger',),
'bestselgerne': ('bestselger',),
'bestseller': ('bestseller',),
'bestsellere': ('bestseller',),
'bestselleren': ('bestseller',),
'bestsellerer': ('bestseller',),
'bestsellerne': ('bestseller',),
'bestykning': ('bestykning',),
'bestykninga': ('bestykning',),
'bestykningen': ('bestykning',),
'bestykningene': ('bestykning',),
'bestykninger': ('bestykning',),
'bestyr': ('bestyr',),
'bestyra': ('bestyr',),
'bestyrene': ('bestyr',),
'bestyret': ('bestyr',),
'bestyrer': ('bestyrer',),
'bestyrere': ('bestyrer',),
'bestyreren': ('bestyrer',),
'bestyrerer': ('bestyrer',),
'bestyrerne': ('bestyrer',),
'bestyrtelse': ('bestyrtelse',),
'bestyrtelsen': ('bestyrtelse',),
'bestyrtelsene': ('bestyrtelse',),
'bestyrtelser': ('bestyrtelse',),
'beståen': ('beståen',),
'bestøvning': ('bestøvning',),
'bestøvninga': ('bestøvning',),
'bestøvningen': ('bestøvning',),
'bestøvningene': ('bestøvning',),
'bestøvninger': ('bestøvning',),
'besvarelse': ('besvarelse',),
'besvarelsen': ('besvarelse',),
'besvarelsene': ('besvarelse',),
'besvarelser': ('besvarelse',),
'besvergelse': ('besvergelse',),
'besvergelsen': ('besvergelse',),
'besvergelsene': ('besvergelse',),
'besvergelser': ('besvergelse',),
'besvergelsesformular': ('besvergelsesformular',),
'besvergelsesformulara': ('besvergelsesformular',),
'besvergelsesformularen': ('besvergelsesformular',),
'besvergelsesformularene': ('besvergelsesformular',),
'besvergelsesformularer': ('besvergelsesformular',),
'besvergelsesformularet': ('besvergelsesformular',),
'besvergelseskunst': ('besvergelseskunst',),
'besvergelseskunsten': ('besvergelseskunst',),
'besvergelseskunstene': ('besvergelseskunst',),
'besvergelseskunster': ('besvergelseskunst',),
'besvimelse': ('besvimelse',),
'besvimelsen': ('besvimelse',),
'besvimelsene': ('besvimelse',),
'besvimelser': ('besvimelse',),
'besvimelsesanfall': ('besvimelsesanfall',),
'besvimelsesanfalla': ('besvimelsesanfall',),
'besvimelsesanfallene': ('besvimelsesanfall',),
'besvimelsesanfallet': ('besvimelsesanfall',),
'besvær': ('besvær',),
'besværa': ('besvær',),
'besværene': ('besvær',),
'besværet': ('besvær',),
'besynderlighet': ('besynderlighet',),
'besynderligheta': ('besynderlighet',),
'besynderligheten': ('besynderlighet',),
'besynderlighetene': ('besynderlighet',),
'besynderligheter': ('besynderlighet',),
'besyv': ('besyv',),
'besyva': ('besyv',),
'besyvene': ('besyv',),
'besyvet': ('besyv',),
'besøk': ('besøk',),
'besøka': ('besøk',),
'besøkene': ('besøk',),
'besøket': ('besøk',),
'besøkelsestid': ('besøkelsestid',),
'besøkelsestida': ('besøkelsestid',),
'besøkelsestiden': ('besøkelsestid',),
'besøkelsestidene': ('besøkelsestid',),
'besøkelsestider': ('besøkelsestid',),
'besøksforbud': ('besøksforbud',),
'besøksforbuda': ('besøksforbud',),
'besøksforbudene': ('besøksforbud',),
'besøksforbudet': ('besøksforbud',),
'besøksrett': ('besøksrett',),
'besøksretten': ('besøksrett',),
'besøksrettene': ('besøksrett',),
'besøksretter': ('besøksrett',),
'beta': ('beta',),
'betaen': ('beta',),
'betaene': ('beta',),
'betaer': ('beta',),
'betaler': ('betaler',),
'betalere': ('betaler',),
'betaleren': ('betaler',),
'betalerer': ('betaler',),
'betalerne': ('betaler',),
'betaling': ('betaling',),
'betalinga': ('betaling',),
'betalingen': ('betaling',),
'betalingene': ('betaling',),
'betalinger': ('betaling',),
'betalingsbalanse': ('betalingsbalanse',),
'betalingsbalansen': ('betalingsbalanse',),
'betalingsbalansene': ('betalingsbalanse',),
'betalingsbalanser': ('betalingsbalanse',),
'betalingsfrist': ('betalingsfrist',),
'betalingsfristen': ('betalingsfrist',),
'betalingsfristene': ('betalingsfrist',),
'betalingsfrister': ('betalingsfrist',),
'betalingsmiddel': ('betalingsmiddel',),
'betalingsmiddelet': ('betalingsmiddel',),
'betalingsmidla': ('betalingsmiddel',),
'betalingsmidlene': ('betalingsmiddel',),
'betalingsmidler': ('betalingsmiddel',),
'betalingsmidlet': ('betalingsmiddel',),
'betalingsmåte': ('betalingsmåte',),
'betalingsmåten': ('betalingsmåte',),
'betalingsmåtene': ('betalingsmåte',),
'betalingsmåter': ('betalingsmåte',),
'betalingsvilkår': ('betalingsvilkår',),
'betalingsvilkåra': ('betalingsvilkår',),
'betalingsvilkårene': ('betalingsvilkår',),
'betalingsvilkåret': ('betalingsvilkår',),
'betapartikkel': ('betapartikkel',),
'betapartikkelen': ('betapartikkel',),
'betapartiklene': ('betapartikkel',),
'betapartikler': ('betapartikkel',),
'betastråle': ('betastråle',),
'betastrålen': ('betastråle',),
'betastrålene': ('betastråle',),
'betastråler': ('betastråle',),
'betasuppa': ('betasuppe',),
'betasuppe': ('betasuppe',),
'betasuppen': ('betasuppe',),
'betasuppene': ('betasuppe',),
'betasupper': ('betasuppe',),
'bete': ('bete',),
'beten': ('bete',),
'betene': ('bete',),
'beter': ('bete',),
'beta': ('bete',),
'bete': ('bete',),
'beten': ('bete',),
'betene': ('bete',),
'beter': ('bete',),
'betegnelse': ('betegnelse',),
'betegnelsen': ('betegnelse',),
'betegnelsene': ('betegnelse',),
'betegnelser': ('betegnelse',),
'betel': ('betel',),
'betelen': ('betel',),
'betlene': ('betel',),
'betler': ('betel',),
'betelpalme': ('betelpalme',),
'betelpalmen': ('betelpalme',),
'betelpalmene': ('betelpalme',),
'betelpalmer': ('betelpalme',),
'betenkelighet': ('betenkelighet',),
'betenkeligheta': ('betenkelighet',),
'betenkeligheten': ('betenkelighet',),
'betenkelighetene': ('betenkelighet',),
'betenkeligheter': ('betenkelighet',),
'betenkning': ('betenkning',),
'betenkninga': ('betenkning',),
'betenkningen': ('betenkning',),
'betenkningene': ('betenkning',),
'betenkninger': ('betenkning',),
'betenkningstid': ('betenkningstid',),
'betenkningstida': ('betenkningstid',),
'betenkningstiden': ('betenkningstid',),
'betenkningstidene': ('betenkningstid',),
'betenkningstider': ('betenkningstid',),
'betennelse': ('betennelse',),
'betennelsen': ('betennelse',),
'betennelsene': ('betennelse',),
'betennelser': ('betennelse',),
'betesukker': ('betesukker',),
'betesukkera': ('betesukker',),
'betesukkere': ('betesukker',),
'betesukkerene': ('betesukker',),
'betesukkeret': ('betesukker',),
'betesukkerne': ('betesukker',),
'betingelse': ('betingelse',),
'betingelsen': ('betingelse',),
'betingelsene': ('betingelse',),
'betingelser': ('betingelse',),
'betingelseskonjunksjon': ('betingelseskonjunksjon',),
'betingelseskonjunksjonen': ('betingelseskonjunksjon',),
'betingelseskonjunksjonene': ('betingelseskonjunksjon',),
'betingelseskonjunksjoner': ('betingelseskonjunksjon',),
'betingelsessetning': ('betingelsessetning',),
'betingelsessetninga': ('betingelsessetning',),
'betingelsessetningen': ('betingelsessetning',),
'betingelsessetningene': ('betingelsessetning',),
'betingelsessetninger': ('betingelsessetning',),
'betinging': ('betinging',),
'betinginga': ('betinging',),
'betingingen': ('betinging',),
'betingingene': ('betinging',),
'betinginger': ('betinging',),
'betjening': ('betjening',),
'betjeninga': ('betjening',),
'betjeningen': ('betjening',),
'betjeningene': ('betjening',),
'betjeninger': ('betjening',),
'betjent': ('betjent',),
'betjenten': ('betjent',),
'betjentene': ('betjent',),
'betjenter': ('betjent',),
'betler': ('betler',),
'betlere': ('betler',),
'betleren': ('betler',),
'betlerer': ('betler',),
'betlerne': ('betler',),
'betleri': ('betleri',),
'betleria': ('betleri',),
'betleriene': ('betleri',),
'betlerier': ('betleri',),
'betleriet': ('betleri',),
'betlerstav': ('betlerstav',),
'betlerstaven': ('betlerstav',),
'betlerstavene': ('betlerstav',),
'betlerstaver': ('betlerstav',),
'betong': ('betong',),
'betongen': ('betong',),
'betongene': ('betong',),
'betonger': ('betong',),
'betongblander': ('betongblander',),
'betongblandere': ('betongblander',),
'betongblanderen': ('betongblander',),
'betongblanderer': ('betongblander',),
'betongblanderne': ('betongblander',),
'betongbygning': ('betongbygning',),
'betongbygninga': ('betongbygning',),
'betongbygningen': ('betongbygning',),
'betongbygningene': ('betongbygning',),
'betongbygninger': ('betongbygning',),
'betongkonstruksjon': ('betongkonstruksjon',),
'betongkonstruksjonen': ('betongkonstruksjon',),
'betongkonstruksjonene': ('betongkonstruksjon',),
'betongkonstruksjoner': ('betongkonstruksjon',),
'betongrør': ('betongrør',),
'betongrøra': ('betongrør',),
'betongrørene': ('betongrør',),
'betongrøret': ('betongrør',),
'betongstein': ('betongstein',),
'betongsteinen': ('betongstein',),
'betongsteinene': ('betongstein',),
'betongsteiner': ('betongstein',),
'betoning': ('betoning',),
'betoninga': ('betoning',),
'betoningen': ('betoning',),
'betoningene': ('betoning',),
'betoninger': ('betoning',),
'betrakter': ('betrakter',),
'betraktere': ('betrakter',),
'betrakteren': ('betrakter',),
'betrakterer': ('betrakter',),
'betrakterne': ('betrakter',),
'betraktning': ('betraktning',),
'betraktninga': ('betraktning',),
'betraktningen': ('betraktning',),
'betraktningene': ('betraktning',),
'betraktninger': ('betraktning',),
'betraktningsapparat': ('betraktningsapparat',),
'betraktningsapparata': ('betraktningsapparat',),
'betraktningsapparatene': ('betraktningsapparat',),
'betraktningsapparater': ('betraktningsapparat',),
'betraktningsapparatet': ('betraktningsapparat',),
'betraktningsmåte': ('betraktningsmåte',),
'betraktningsmåten': ('betraktningsmåte',),
'betraktningsmåtene': ('betraktningsmåte',),
'betraktningsmåter': ('betraktningsmåte',),
'betroelse': ('betroelse',),
'betroelsen': ('betroelse',),
'betroelsene': ('betroelse',),
'betroelser': ('betroelse',),
'betryggelse': ('betryggelse',),
'betryggelsen': ('betryggelse',),
'betryggelsene': ('betryggelse',),
'betryggelser': ('betryggelse',),
'betydning': ('betydning',),
'betydninga': ('betydning',),
'betydningen': ('betydning',),
'betydningene': ('betydning',),
'betydninger': ('betydning',),
'betydningsendring': ('betydningsendring',),
'betydningsendringa': ('betydningsendring',),
'betydningsendringen': ('betydningsendring',),
'betydningsendringene': ('betydningsendring',),
'betydningsendringer': ('betydningsendring',),
'betydningsforskjell': ('betydningsforskjell',),
'betydningsforskjellen': ('betydningsforskjell',),
'betydningsforskjellene': ('betydningsforskjell',),
'betydningsforskjeller': ('betydningsforskjell',),
'betydningsinnhold': ('betydningsinnhold',),
'betydningsinnholda': ('betydningsinnhold',),
'betydningsinnholdene': ('betydningsinnhold',),
'betydningsinnholdet': ('betydningsinnhold',),
'betydningsnyanse': ('betydningsnyanse',),
'betydningsnyansen': ('betydningsnyanse',),
'betydningsnyansene': ('betydningsnyanse',),
'betydningsnyanser': ('betydningsnyanse',),
'betydningsovergang': ('betydningsovergang',),
'betydningsovergangen': ('betydningsovergang',),
'betydningsovergangene': ('betydningsovergang',),
'betydningsoverganger': ('betydningsovergang',),
'beundrer': ('beundrer',),
'beundrere': ('beundrer',),
'beundreren': ('beundrer',),
'beundrerer': ('beundrer',),
'beundrerne': ('beundrer',),
'beundring': ('beundring',),
'beundringa': ('beundring',),
'beundringen': ('beundring',),
'beundringene': ('beundring',),
'beundringer': ('beundring',),
'bevegelighet': ('bevegelighet',),
'bevegeligheta': ('bevegelighet',),
'bevegeligheten': ('bevegelighet',),
'bevegelighetene': ('bevegelighet',),
'bevegeligheter': ('bevegelighet',),
'bevegelse': ('bevegelse',),
'bevegelsen': ('bevegelse',),
'bevegelsene': ('bevegelse',),
'bevegelser': ('bevegelse',),
'bevegelsesenergi': ('bevegelsesenergi',),
'bevegelsesenergien': ('bevegelsesenergi',),
'bevegelsesenergiene': ('bevegelsesenergi',),
'bevegelsesenergier': ('bevegelsesenergi',),
'bevegelsesfrihet': ('bevegelsesfrihet',),
'bevegelsesfriheta': ('bevegelsesfrihet',),
'bevegelsesfriheten': ('bevegelsesfrihet',),
'bevegelsesfrihetene': ('bevegelsesfrihet',),
'bevegelsesfriheter': ('bevegelsesfrihet',),
'bevegelseshemning': ('bevegelseshemning',),
'bevegelseshemninga': ('bevegelseshemning',),
'bevegelseshemningen': ('bevegelseshemning',),
'bevegelseshemningene': ('bevegelseshemning',),
'bevegelseshemninger': ('bevegelseshemning',),
'bevegelsesverb': ('bevegelsesverb',),
'bevegelsesverba': ('bevegelsesverb',),
'bevegelsesverbene': ('bevegelsesverb',),
'bevegelsesverber': ('bevegelsesverb',),
'bevegelsesverbet': ('bevegelsesverb',),
'bevegelsesverba': ('bevegelsesverbum',),
'bevegelsesverbene': ('bevegelsesverbum',),
'bevegelsesverber': ('bevegelsesverbum',),
'bevegelsesverbet': ('bevegelsesverbum',),
'bevegelsesverbum': ('bevegelsesverbum',),
'bevegelsesverbumet': ('bevegelsesverbum',),
'beveggrunn': ('beveggrunn',),
'beveggrunnen': ('beveggrunn',),
'beveggrunnene': ('beveggrunn',),
'beveggrunner': ('beveggrunn',),
'beven': ('beven',),
'bever': ('bever',),
'bevere': ('bever',),
'beveren': ('bever',),
'beverer': ('bever',),
'beverne': ('bever',),
'bevre': ('bever',),
'bevrene': ('bever',),
'bevrer': ('bever',),
'bevergjel': ('bevergjel',),
'bevergjela': ('bevergjel',),
'bevergjelen': ('bevergjel',),
'bevergjelene': ('bevergjel',),
'bevergjeler': ('bevergjel',),
'bevergjelet': ('bevergjel',),
'beverhytta': ('beverhytte',),
'beverhytte': ('beverhytte',),
'beverhytten': ('beverhytte',),
'beverhyttene': ('beverhytte',),
'beverhytter': ('beverhytte',),
'beverpels': ('beverpels',),
'beverpelsen': ('beverpels',),
'beverpelsene': ('beverpels',),
'beverpelser': ('beverpels',),
'beverrotta': ('beverrotte',),
'beverrotte': ('beverrotte',),
'beverrotten': ('beverrotte',),
'beverrottene': ('beverrotte',),
'beverrotter': ('beverrotte',),
'bevertning': ('bevertning',),
'bevertninga': ('bevertning',),
'bevertningen': ('bevertning',),
'bevertningene': ('bevertning',),
'bevertninger': ('bevertning',),
'bevertningssted': ('bevertningssted',),
'bevertningsstedene': ('bevertningssted',),
'bevertningssteder': ('bevertningssted',),
'bevertningsstedet': ('bevertningssted',),
'bevilgning': ('bevilgning',),
'bevilgninga': ('bevilgning',),
'bevilgningen': ('bevilgning',),
'bevilgningene': ('bevilgning',),
'bevilgninger': ('bevilgning',),
'bevilgningsreglement': ('bevilgningsreglement',),
'bevilgningsreglementa': ('bevilgningsreglement',),
'bevilgningsreglementene': ('bevilgningsreglement',),
'bevilgningsreglementer': ('bevilgningsreglement',),
'bevilgningsreglementet': ('bevilgningsreglement',),
'bevilgningsspørsmål': ('bevilgningsspørsmål',),
'bevilgningsspørsmåla': ('bevilgningsspørsmål',),
'bevilgningsspørsmålene': ('bevilgningsspørsmål',),
'bevilgningsspørsmålet': ('bevilgningsspørsmål',),
'bevilling': ('bevilling',),
'bevillingen': ('bevilling',),
'bevillingene': ('bevilling',),
'bevillinger': ('bevilling',),
'bevillingshaver': ('bevillingshaver',),
'bevillingshavere': ('bevillingshaver',),
'bevillingshaveren': ('bevillingshaver',),
'bevillingshaverer': ('bevillingshaver',),
'bevillingshaverne': ('bevillingshaver',),
'bevillingsutsteder': ('bevillingsutsteder',),
'bevillingsutstedere': ('bevillingsutsteder',),
'bevillingsutstederen': ('bevillingsutsteder',),
'bevillingsutstederer': ('bevillingsutsteder',),
'bevillingsutstederne': ('bevillingsutsteder',),
'bevis': ('bevis',),
'bevisa': ('bevis',),
'bevisene': ('bevis',),
'beviser': ('bevis',),
'beviset': ('bevis',),
'bevisbyrde': ('bevisbyrde',),
'bevisbyrden': ('bevisbyrde',),
'bevisbyrdene': ('bevisbyrde',),
'bevisbyrder': ('bevisbyrde',),
'bevisførsel': ('bevisførsel',),
'bevisførselen': ('bevisførsel',),
'bevisførslene': ('bevisførsel',),
'bevisførsler': ('bevisførsel',),
'bevisgrunn': ('bevisgrunn',),
'bevisgrunnen': ('bevisgrunn',),
'bevisgrunnene': ('bevisgrunn',),
'bevisgrunner': ('bevisgrunn',),
'bevismateriala': ('bevismateriale',),
'bevismateriale': ('bevismateriale',),
'bevismaterialene': ('bevismateriale',),
'bevismaterialer': ('bevismateriale',),
'bevismaterialet': ('bevismateriale',),
'bevissthet': ('bevissthet',),
'bevisstheta': ('bevissthet',),
'bevisstheten': ('bevissthet',),
'bevissthetene': ('bevissthet',),
'bevisstheter': ('bevissthet',),
'bevissthetsforstyrrelse': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelsen': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelsene': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelser': ('bevissthetsforstyrrelse',),
'bevissthetsterskel': ('bevissthetsterskel',),
'bevissthetsterskelen': ('bevissthetsterskel',),
'bevissthetstersklene': ('bevissthetsterskel',),
'bevissthetsterskler': ('bevissthetsterskel',),
'bevoktning': ('bevoktning',),
'bevoktninga': ('bevoktning',),
'bevoktningen': ('bevoktning',),
'bevoktningene': ('bevoktning',),
'bevoktninger': ('bevoktning',),
'bevreasp': ('bevreasp',),
'bevreaspa': ('bevreasp',),
'bevreaspen': ('bevreasp',),
'bevreaspene': ('bevreasp',),
'bevreasper': ('bevreasp',),
'bevreosp': ('bevreosp',),
'bevreospa': ('bevreosp',),
'bevreospen': ('bevreosp',),
'bevreospene': ('bevreosp',),
'bevreosper': ('bevreosp',),
'bevågenhet': ('bevågenhet',),
'bevågenheta': ('bevågenhet',),
'bevågenheten': ('bevågenhet',),
'bevågenhetene': ('bevågenhet',),
'bevågenheter': ('bevågenhet',),
'bey': ('bey',),
'beyen': ('bey',),
'beyene': ('bey',),
'beyer': ('bey',),
'bh': ('bh',),
'bh-en': ('bh',),
'bh-ene': ('bh',),
'bh-er': ('bh',),
'bhen': ('bh',),
'bhene': ('bh',),
'bher': ('bh',),
'bhutaner': ('bhutaner',),
'bhutanere': ('bhutaner',),
'bhutaneren': ('bhutaner',),
'bhutanerer': ('bhutaner',),
'bhutanerne': ('bhutaner',),
'biafraner': ('biafraner',),
'biafranere': ('biafraner',),
'biafraneren': ('biafraner',),
'biafranerer': ('biafraner',),
'biafranerne': ('biafraner',),
'bial': ('bial',),
'biala': ('bial',),
'bialene': ('bial',),
'bialet': ('bial',),
'biapparat': ('biapparat',),
'biapparata': ('biapparat',),
'biapparatene': ('biapparat',),
'biapparater': ('biapparat',),
'biapparatet': ('biapparat',),
'biarbeid': ('biarbeid',),
'biarbeida': ('biarbeid',),
'biarbeidene': ('biarbeid',),
'biarbeider': ('biarbeid',),
'biarbeidet': ('biarbeid',),
'biavl': ('biavl',),
'biavlen': ('biavl',),
'biavlene': ('biavl',),
'biavler': ('biavl',),
'bibehold': ('bibehold',),
'bibel': ('bibel',),
'bibelen': ('bibel',),
'biblene': ('bibel',),
'bibler': ('bibel',),
'bibelcamp': ('bibelcamp',),
'bibelcampen': ('bibelcamp',),
'bibelcampene': ('bibelcamp',),
'bibelcamper': ('bibelcamp',),
'bibelfortolker': ('bibelfortolker',),
'bibelfortolkere': ('bibelfortolker',),
'bibelfortolkeren': ('bibelfortolker',),
'bibelfortolkerer': ('bibelfortolker',),
'bibelfortolkerne': ('bibelfortolker',),
'bibelfortolking': ('bibelfortolking',),
'bibelfortolkinga': ('bibelfortolking',),
'bibelfortolkingen': ('bibelfortolking',),
'bibelfortolkingene': ('bibelfortolking',),
'bibelfortolkinger': ('bibelfortolking',),
'bibelfortolkning': ('bibelfortolkning',),
'bibelfortolkninga': ('bibelfortolkning',),
'bibelfortolkningen': ('bibelfortolkning',),
'bibelfortolkningene': ('bibelfortolkning',),
'bibelfortolkninger': ('bibelfortolkning',),
'bibelhandskrift': ('bibelhandskrift',),
'bibelhandskrifta': ('bibelhandskrift',),
'bibelhandskriftene': ('bibelhandskrift',),
'bibelhandskrifter': ('bibelhandskrift',),
'bibelhandskriftet': ('bibelhandskrift',),
'bibelhistoria': ('bibelhistorie',),
'bibelhistorie': ('bibelhistorie',),
'bibelhistorien': ('bibelhistorie',),
'bibelhistoriene': ('bibelhistorie',),
'bibelhistorier': ('bibelhistorie',),
'bibelhåndskrift': ('bibelhåndskrift',),
'bibelhåndskrifta': ('bibelhåndskrift',),
'bibelhåndskriftene': ('bibelhåndskrift',),
'bibelhåndskrifter': ('bibelhåndskrift',),
'bibelhåndskriftet': ('bibelhåndskrift',),
'bibelkonkordans': ('bibelkonkordans',),
'bibelkonkordansen': ('bibelkonkordans',),
'bibelkonkordansene': ('bibelkonkordans',),
'bibelkonkordanser': ('bibelkonkordans',),
'bibelkritikk': ('bibelkritikk',),
'bibelkritikken': ('bibelkritikk',),
'bibelkritikkene': ('bibelkritikk',),
'bibelkritikker': ('bibelkritikk',),
'bibelord': ('bibelord',),
'bibelorda': ('bibelord',),
'bibelordene': ('bibelord',),
'bibelordet': ('bibelord',),
'bibelordbok': ('bibelordbok',),
'bibelordboka': ('bibelordbok',),
'bibelordboken': ('bibelordbok',),
'bibelordbøkene': ('bibelordbok',),
'bibelordbøker': ('bibelordbok',),
'bibeloversettelse': ('bibeloversettelse',),
'bibeloversettelsen': ('bibeloversettelse',),
'bibeloversettelsene': ('bibeloversettelse',),
'bibeloversettelser': ('bibeloversettelse',),
'bibelselskap': ('bibelselskap',),
'bibelselskapa': ('bibelselskap',),
'bibelselskapene': ('bibelselskap',),
'bibelselskaper': ('bibelselskap',),
'bibelselskapet': ('bibelselskap',),
'bibelsitat': ('bibelsitat',),
'bibelsitata': ('bibelsitat',),
'bibelsitatene': ('bibelsitat',),
'bibelsitater': ('bibelsitat',),
'bibelsitatet': ('bibelsitat',),
'bibelskole': ('bibelskole',),
'bibelskolen': ('bibelskole',),
'bibelskolene': ('bibelskole',),
'bibelskoler': ('bibelskole',),
'bibelsmugler': ('bibelsmugler',),
'bibelsmuglere': ('bibelsmugler',),
'bibelsmugleren': ('bibelsmugler',),
'bibelsmuglerer': ('bibelsmugler',),
'bibelsmuglerne': ('bibelsmugler',),
'bibelspråk': ('bibelspråk',),
'bibelspråka': ('bibelspråk',),
'bibelspråkene': ('bibelspråk',),
'bibelspråket': ('bibelspråk',),
'bibelsted': ('bibelsted',),
'bibelstedene': ('bibelsted',),
'bibelsteder': ('bibelsted',),
'bibelstedet': ('bibelsted',),
'bibeltime': ('bibeltime',),
'bibeltimen': ('bibeltime',),
'bibeltimene': ('bibeltime',),
'bibeltimer': ('bibeltime',),
'bibelutgava': ('bibelutgave',),
'bibelutgave': ('bibelutgave',),
'bibelutgaven': ('bibelutgave',),
'bibelutgavene': ('bibelutgave',),
'bibelutgaver': ('bibelutgave',),
'bibelvitenskap': ('bibelvitenskap',),
'bibelvitenskapen': ('bibelvitenskap',),
'bibelvitenskapene': ('bibelvitenskap',),
'bibelvitenskaper': ('bibelvitenskap',),
'bibelvitskap': ('bibelvitskap',),
'bibelvitskapen': ('bibelvitskap',),
'bibelvitskapene': ('bibelvitskap',),
'bibelvitskaper': ('bibelvitskap',),
'bibetydning': ('bibetydning',),
'bibetydninga': ('bibetydning',),
'bibetydningen': ('bibetydning',),
'bibetydningene': ('bibetydning',),
'bibetydninger': ('bibetydning',),
'biblad': ('biblad',),
'biblada': ('biblad',),
'bibladene': ('biblad',),
'biblader': ('biblad',),
'bibladet': ('biblad',),
'bibliofil': ('bibliofil',),
'bibliofilen': ('bibliofil',),
'bibliofilene': ('bibliofil',),
'bibliofiler': ('bibliofil',),
'bibliofili': ('bibliofili',),
'bibliofilien': ('bibliofili',),
'bibliofiliene': ('bibliofili',),
'bibliofilier': ('bibliofili',),
'bibliofilutgava': ('bibliofilutgave',),
'bibliofilutgave': ('bibliofilutgave',),
'bibliofilutgaven': ('bibliofilutgave',),
'bibliofilutgavene': ('bibliofilutgave',),
'bibliofilutgaver': ('bibliofilutgave',),
'bibliograf': ('bibliograf',),
'bibliografen': ('bibliograf',),
'bibliografene': ('bibliograf',),
'bibliografer': ('bibliograf',),
'bibliografi': ('bibliografi',),
'bibliografien': ('bibliografi',),
'bibliografiene': ('bibliografi',),
'bibliografier': ('bibliografi',),
'bibliotek': ('bibliotek',),
'biblioteka': ('bibliotek',),
'bibliotekene': ('bibliotek',),
'biblioteker': ('bibliotek',),
'biblioteket': ('bibliotek',),
'bibliotekar': ('bibliotekar',),
'bibliotekaren': ('bibliotekar',),
'bibliotekarene': ('bibliotekar',),
'bibliotekarer': ('bibliotekar',),
'bibringe': ('bibringe',),
'bibringen': ('bibringe',),
'bibringene': ('bibringe',),
'bibringer': ('bibringe',),
'biceps': ('biceps',),
'bicepsen': ('biceps',),
'bicepsene': ('biceps',),
'bicepser': ('biceps',),
'bidea': ('bidé',),
'bideene': ('bidé',),
'bideer': ('bidé',),
'bideet': ('bidé',),
'bidé': ('bidé',),
'bidéa': ('bidé',),
'bidéene': ('bidé',),
'bidéer': ('bidé',),
'bidéet': ('bidé',),
'bidevindsegler': ('bidevindsegler',),
'bidevindseglere': ('bidevindsegler',),
'bidevindsegleren': ('bidevindsegler',),
'bidevindseglerer': ('bidevindsegler',),
'bidevindseglerne': ('bidevindsegler',),
'bidevindseiler': ('bidevindseiler',),
'bidevindseilere': ('bidevindseiler',),
'bidevindseileren': ('bidevindseiler',),
'bidevindseilerer': ('bidevindseiler',),
'bidevindseilerne': ('bidevindseiler',),
'bidevindssegler': ('bidevindssegler',),
'bidevindsseglere': ('bidevindssegler',),
'bidevindssegleren': ('bidevindssegler',),
'bidevindsseglerer': ('bidevindssegler',),
'bidevindsseglerne': ('bidevindssegler',),
'bidevindsseiler': ('bidevindsseiler',),
'bidevindsseilere': ('bidevindsseiler',),
'bidevindsseileren': ('bidevindsseiler',),
'bidevindsseilerer': ('bidevindsseiler',),
'bidevindsseilerne': ('bidevindsseiler',),
'bidrag': ('bidrag',),
'bidraga': ('bidrag',),
'bidragene': ('bidrag',),
'bidraget': ('bidrag',),
'bidragsfogd': ('bidragsfogd',),
'bidragsfogden': ('bidragsfogd',),
'bidragsfogdene': ('bidragsfogd',),
'bidragsfogder': ('bidragsfogd',),
'bidragsfut': ('bidragsfut',),
'bidragsfuten': ('bidragsfut',),
'bidragsfutene': ('bidragsfut',),
'bidragsfuter': ('bidragsfut',),
'bidragsplikt': ('bidragsplikt',),
'bidragsplikta': ('bidragsplikt',),
'bidragsplikten': ('bidragsplikt',),
'bidragspliktene': ('bidragsplikt',),
'bidragsplikter': ('bidragsplikt',),
'bidragsyter': ('bidragsyter',),
'bidragsytere': ('bidragsyter',),
'bidragsyteren': ('bidragsyter',),
'bidragsyterer': ('bidragsyter',),
'bidragsyterne': ('bidragsyter',),
'bidronning': ('bidronning',),
'bidronninga': ('bidronning',),
'bidronningen': ('bidronning',),
'bidronningene': ('bidronning',),
'bidronninger': ('bidronning',),
'bia': ('bie',),
'bie': ('bie',),
'bien': ('bie',),
'biene': ('bie',),
'bier': ('bie',),
'biedermeier': ('biedermeier',),
'biedermeieren': ('biedermeier',),
'biedermeierene': ('biedermeier',),
'biedermeierer': ('biedermeier',),
'biedermeierinteriør': ('biedermeierinteriør',),
'biedermeierinteriøra': ('biedermeierinteriør',),
'biedermeierinteriørene': ('biedermeierinteriør',),
'biedermeierinteriører': ('biedermeierinteriør',),
'biedermeierinteriøret': ('biedermeierinteriør',),
'biedermeierstil': ('biedermeierstil',),
'biedermeierstilen': ('biedermeierstil',),
'biedermeierstilene': ('biedermeierstil',),
'biedermeierstiler': ('biedermeierstil',),
'bielv': ('bielv',),
'bielva': ('bielv',),
'bielven': ('bielv',),
'bielvene': ('bielv',),
'bielver': ('bielv',),
'biennale': ('biennale',),
'biennalen': ('biennale',),
'biennalene': ('biennale',),
'biennaler': ('biennale',),
'bierverv': ('bierverv',),
'bierverva': ('bierverv',),
'biervervene': ('bierverv',),
'biervervet': ('bierverv',),
'bifag': ('bifag',),
'bifaga': ('bifag',),
'bifagene': ('bifag',),
'bifaget': ('bifag',),
'bifall': ('bifall',),
'bifalla': ('bifall',),
'bifallene': ('bifall',),
'bifallet': ('bifall',),
'bifallsklapp': ('bifallsklapp',),
'bifallsklappa': ('bifallsklapp',),
'bifallsklappen': ('bifallsklapp',),
'bifallsklappene': ('bifallsklapp',),
'bifallsklapper': ('bifallsklapp',),
'bifallsklappet': ('bifallsklapp',),
'bifallsrop': ('bifallsrop',),
'bifallsropa': ('bifallsrop',),
'bifallsropene': ('bifallsrop',),
'bifallsropet': ('bifallsrop',),
'bifallsytring': ('bifallsytring',),
'bifallsytringa': ('bifallsytring',),
'bifallsytringen': ('bifallsytring',),
'bifallsytringene': ('bifallsytring',),
'bifallsytringer': ('bifallsytring',),
'biff': ('biff',),
'biffen': ('biff',),
'biffene': ('biff',),
'biffer': ('biff',),
'bifigur': ('bifigur',),
'bifiguren': ('bifigur',),
'bifigurene': ('bifigur',),
'bifigurer': ('bifigur',),
'bifili': ('bifili',),
'bifilien': ('bifili',),
'bifiliene': ('bifili',),
'bifilier': ('bifili',),
'bifolk': ('bifolk',),
'bifolka': ('bifolk',),
'bifolkene': ('bifolk',),
'bifolket': ('bifolk',),
'bigami': ('bigami',),
'bigamia': ('bigami',),
'bigamiene': ('bigami',),
'bigamiet': ('bigami',),
'bigamist': ('bigamist',),
'bigamisten': ('bigamist',),
'bigamistene': ('bigamist',),
'bigamister': ('bigamist',),
'bigift': ('bigift',),
'bigifta': ('bigift',),
'bigiften': ('bigift',),
'bigiftene': ('bigift',),
'bigifter': ('bigift',),
'bigotteri': ('bigotteri',),
'bigotteria': ('bigotteri',),
'bigotteriene': ('bigotteri',),
'bigotterier': ('bigotteri',),
'bigotteriet': ('bigotteri',),
'bihandling': ('bihandling',),
'bihandlinga': ('bihandling',),
'bihandlingen': ('bihandling',),
'bihandlingene': ('bihandling',),
'bihandlinger': ('bihandling',),
'bihold': ('bihold',),
'biholda': ('bihold',),
'biholdene': ('bihold',),
'biholdet': ('bihold',),
'bihola': ('bihole',),
'bihole': ('bihole',),
'biholen': ('bihole',),
'biholene': ('bihole',),
'biholer': ('bihole',),
'biholebetennelse': ('biholebetennelse',),
'biholebetennelsen': ('biholebetennelse',),
'biholebetennelsene': ('biholebetennelse',),
'biholebetennelser': ('biholebetennelse',),
'bihula': ('bihule',),
'bihule': ('bihule',),
'bihulen': ('bihule',),
'bihulene': ('bihule',),
'bihuler': ('bihule',),
'bihulebetennelse': ('bihulebetennelse',),
'bihulebetennelsen': ('bihulebetennelse',),
'bihulebetennelsene': ('bihulebetennelse',),
'bihulebetennelser': ('bihulebetennelse',),
'biinntekt': ('biinntekt',),
'biinntekta': ('biinntekt',),
'biinntekten': ('biinntekt',),
'biinntektene': ('biinntekt',),
'biinntekter': ('biinntekt',),
'bijouteri': ('bijouteri',),
'bijouteria': ('bijouteri',),
'bijouteriene': ('bijouteri',),
'bijouterier': ('bijouteri',),
'bijouteriet': ('bijouteri',),
'bikini': ('bikini',),
'bikinien': ('bikini',),
'bikiniene': ('bikini',),
'bikinier': ('bikini',),
'bikk': ('bikk',),
'bikken': ('bikk',),
'bikkene': ('bikk',),
'bikker': ('bikk',),
'bikkja': ('bikkje',),
'bikkje': ('bikkje',),
'bikkjen': ('bikkje',),
'bikkjene': ('bikkje',),
'bikkjer': ('bikkje',),
'bikkjeleven': ('bikkjeleven',),
'bikkjelevena': ('bikkjeleven',),
'bikkjelevenene': ('bikkjeleven',),
'bikkjelevenet': ('bikkjeleven',),
'bikkjeslagsmål': ('bikkjeslagsmål',),
'bikkjeslagsmåla': ('bikkjeslagsmål',),
'bikkjeslagsmålene': ('bikkjeslagsmål',),
'bikkjeslagsmålet': ('bikkjeslagsmål',),
'biklang': ('biklang',),
'biklangen': ('biklang',),
'biklangene': ('biklang',),
'biklanger': ('biklang',),
'bikse': ('bikse',),
'biksen': ('bikse',),
'biksene': ('bikse',),
'bikser': ('bikse',),
'bikube': ('bikube',),
'bikuben': ('bikube',),
'bikubene': ('bikube',),
'bikuber': ('bikube',),
'bil': ('bil',),
'bilen': ('bil',),
'bilene': ('bil',),
'biler': ('bil',),
'bilabial': ('bilabial',),
'bilabialen': ('bilabial',),
'bilabialene': ('bilabial',),
'bilabialer': ('bilabial',),
'bilag': ('bilag',),
'bilaga': ('bilag',),
'bilagene': ('bilag',),
'bilaget': ('bilag',),
'bilagsrevisjon': ('bilagsrevisjon',),
'bilagsrevisjonen': ('bilagsrevisjon',),
'bilagsrevisjonene': ('bilagsrevisjon',),
'bilagsrevisjoner': ('bilagsrevisjon',),
'bilbane': ('bilbane',),
'bilbanen': ('bilbane',),
'bilbanene': ('bilbane',),
'bilbaner': ('bilbane',),
'bilbelta': ('bilbelte',),
'bilbelte': ('bilbelte',),
'bilbeltene': ('bilbelte',),
'bilbelter': ('bilbelte',),
'bilbeltet': ('bilbelte',),
'bilbrev': ('bilbrev',),
'bilbreva': ('bilbrev',),
'bilbrevene': ('bilbrev',),
'bilbrever': ('bilbrev',),
'bilbrevet': ('bilbrev',),
'bilbrukstjuveri': ('bilbrukstjuveri',),
'bilbrukstjuveria': ('bilbrukstjuveri',),
'bilbrukstjuveriene': ('bilbrukstjuveri',),
'bilbrukstjuverier': ('bilbrukstjuveri',),
'bilbrukstjuveriet': ('bilbrukstjuveri',),
'bilbrukstyveri': ('bilbrukstyveri',),
'bilbrukstyveria': ('bilbrukstyveri',),
'bilbrukstyveriene': ('bilbrukstyveri',),
'bilbrukstyverier': ('bilbrukstyveri',),
'bilbrukstyveriet': ('bilbrukstyveri',),
'bilbås': ('bilbås',),
'bilbåsen': ('bilbås',),
'bilbåsene': ('bilbås',),
'bilbåser': ('bilbås',),
'bilbølla': ('bilbølle',),
'bilbølle': ('bilbølle',),
'bilbøllen': ('bilbølle',),
'bilbøllene': ('bilbølle',),
'bilbøller': ('bilbølle',),
'bilda': ('bilde',),
'bilde': ('bilde',),
'bildene': ('bilde',),
'bilder': ('bilde',),
'bildet': ('bilde',),
'bildearkiv': ('bildearkiv',),
'bildearkiva': ('bildearkiv',),
'bildearkivene': ('bildearkiv',),
'bildearkiver': ('bildearkiv',),
'bildearkivet': ('bildearkiv',),
'bildeband': ('bildeband',),
'bildebanda': ('bildeband',),
'bildebandene': ('bildeband',),
'bildebandet': ('bildeband',),
'bildebibel': ('bildebibel',),
'bildebibelen': ('bildebibel',),
'bildebiblene': ('bildebibel',),
'bildebibler': ('bildebibel',),
'bildebånd': ('bildebånd',),
'bildebånda': ('bildebånd',),
'bildebåndene': ('bildebånd',),
'bildebåndet': ('bildebånd',),
'bildegalleri': ('bildegalleri',),
'bildegalleria': ('bildegalleri',),
'bildegalleriene': ('bildegalleri',),
'bildegallerier': ('bildegalleri',),
'bildegalleriet': ('bildegalleri',),
'bildegåta': ('bildegåte',),
'bildegåte': ('bildegåte',),
'bildegåten': ('bildegåte',),
'bildegåtene': ('bildegåte',),
'bildegåter': ('bildegåte',),
'bildehogger': ('bildehogger',),
'bildehoggere': ('bildehogger',),
'bildehoggeren': ('bildehogger',),
'bildehoggerer': ('bildehogger',),
'bildehoggerne': ('bildehogger',),
'bildehoggerkunst': ('bildehoggerkunst',),
'bildehoggerkunsten': ('bildehoggerkunst',),
'bildehoggerkunstene': ('bildehoggerkunst',),
'bildehoggerkunster': ('bildehoggerkunst',),
'bildehugger': ('bildehugger',),
'bildehuggere': ('bildehugger',),
'bildehuggeren': ('bildehugger',),
'bildehuggerer': ('bildehugger',),
'bildehuggerne': ('bildehugger',),
'bildehuggerkunst': ('bildehuggerkunst',),
'bildehuggerkunsten': ('bildehuggerkunst',),
'bildehuggerkunstene': ('bildehuggerkunst',),
'bildehuggerkunster': ('bildehuggerkunst',),
'bildekk': ('bildekk',),
'bildekka': ('bildekk',),
'bildekkene': ('bildekk',),
'bildekket': ('bildekk',),
'bildekunst': ('bildekunst',),
'bildekunsten': ('bildekunst',),
'bildekunstene': ('bildekunst',),
'bildekunster': ('bildekunst',),
'bildekunstner': ('bildekunstner',),
'bildekunstnere': ('bildekunstner',),
'bildekunstneren': ('bildekunstner',),
'bildekunstnerer': ('bildekunstner',),
'bildekunstnerne': ('bildekunstner',),
'bildereportasje': ('bildereportasje',),
'bildereportasjen': ('bildereportasje',),
'bildereportasjene': ('bildereportasje',),
'bildereportasjer': ('bildereportasje',),
'bilderør': ('bilderør',),
'bilderøra': ('bilderør',),
'bilderørene': ('bilderør',),
'bilderøret': ('bilderør',),
'bildesamband': ('bildesamband',),
'bildesambanda': ('bildesamband',),
'bildesambandene': ('bildesamband',),
'bildesambandet': ('bildesamband',),
'bildeskarphet': ('bildeskarphet',),
'bildeskarpheta': ('bildeskarphet',),
'bildeskarpheten': ('bildeskarphet',),
'bildeskarphetene': ('bildeskarphet',),
'bildeskarpheter': ('bildeskarphet',),
'bildeskjærer': ('bildeskjærer',),
'bildeskjærere': ('bildeskjærer',),
'bildeskjæreren': ('bildeskjærer',),
'bildeskjærerer': ('bildeskjærer',),
'bildeskjærerne': ('bildeskjærer',),
'bildeskjæring': ('bildeskjæring',),
'bildeskjæringa': ('bildeskjæring',),
'bildeskjæringen': ('bildeskjæring',),
'bildeskjæringene': ('bildeskjæring',),
'bildeskjæringer': ('bildeskjæring',),
'bildeskrift': ('bildeskrift',),
'bildeskrifta': ('bildeskrift',),
'bildeskriften': ('bildeskrift',),
'bildeskriftene': ('bildeskrift',),
'bildeskrifter': ('bildeskrift',),
'bildespråk': ('bildespråk',),
'bildespråka': ('bildespråk',),
'bildespråkene': ('bildespråk',),
'bildespråket': ('bildespråk',),
'bildestorm': ('bildestorm',),
'bildestormen': ('bildestorm',),
'bildestormene': ('bildestorm',),
'bildestormer': ('bildestorm',),
'bildestormer': ('bildestormer',),
'bildestormere': ('bildestormer',),
'bildestormeren': ('bildestormer',),
'bildestormerer': ('bildestormer',),
'bildestormerne': ('bildestormer',),
'bildetekst': ('bildetekst',),
'bildeteksta': ('bildetekst',),
'bildeteksten': ('bildetekst',),
'bildetekstene': ('bildetekst',),
'bildetekster': ('bildetekst',),
'bildetelegrafi': ('bildetelegrafi',),
'bildetelegrafien': ('bildetelegrafi',),
'bildetelegrafiene': ('bildetelegrafi',),
'bildetelegrafier': ('bildetelegrafi',),
'bildevev': ('bildevev',),
'bildeveven': ('bildevev',),
'bildevevene': ('bildevev',),
'bildevever': ('bildevev',),
'bildeveving': ('bildeveving',),
'bildevevinga': ('bildeveving',),
'bildevevingen': ('bildeveving',),
'bildevevingene': ('bildeveving',),
'bildevevinger': ('bildeveving',),
'bildevevning': ('bildevevning',),
'bildevevninga': ('bildevevning',),
'bildevevningen': ('bildevevning',),
'bildevevningene': ('bildevevning',),
'bildevevninger': ('bildevevning',),
'bildilla': ('bildille',),
'bildille': ('bildille',),
'bildillen': ('bildille',),
'bildillene': ('bildille',),
'bildiller': ('bildille',),
'bila': ('bile',),
'bile': ('bile',),
'bilen': ('bile',),
'bilene': ('bile',),
'biler': ('bile',),
'bileggeromn': ('bileggeromn',),
'bileggeromnen': ('bileggeromn',),
'bileggeromnene': ('bileggeromn',),
'bileggeromner': ('bileggeromn',),
'bileggerovn': ('bileggerovn',),
'bileggerovnen': ('bileggerovn',),
'bileggerovnene': ('bileggerovn',),
'bileggerovner': ('bileggerovn',),
'bileier': ('bileier',),
'bileiere': ('bileier',),
'bileieren': ('bileier',),
'bileierer': ('bileier',),
'bileierne': ('bileier',),
'bilferga': ('bilferge',),
'bilferge': ('bilferge',),
'bilfergen': ('bilferge',),
'bilfergene': ('bilferge',),
'bilferger': ('bilferge',),
'bilferja': ('bilferje',),
'bilferje': ('bilferje',),
'bilferjen': ('bilferje',),
'bilferjene': ('bilferje',),
'bilferjer': ('bilferje',),
'bilfolk': ('bilfolk',),
'bilfolka': ('bilfolk',),
'bilfolkene': ('bilfolk',),
'bilfolket': ('bilfolk',),
'bilforhandler': ('bilforhandler',),
'bilforhandlere': ('bilforhandler',),
'bilforhandleren': ('bilforhandler',),
'bilforhandlerer': ('bilforhandler',),
'bilforhandlerne': ('bilforhandler',),
'bilfører': ('bilfører',),
'bilførere': ('bilfører',),
'bilføreren': ('bilfører',),
'bilførerer': ('bilfører',),
'bilførerne': ('bilfører',),
'bilgodtgjørelse': ('bilgodtgjørelse',),
'bilgodtgjørelsen': ('bilgodtgjørelse',),
'bilgodtgjørelsene': ('bilgodtgjørelse',),
'bilgodtgjørelser': ('bilgodtgjørelse',),
'bilgodtgjøring': ('bilgodtgjøring',),
'bilgodtgjøringa': ('bilgodtgjøring',),
'bilgodtgjøringen': ('bilgodtgjøring',),
'bilgodtgjøringene': ('bilgodtgjøring',),
'bilgodtgjøringer': ('bilgodtgjøring',),
'bilgummi': ('bilgummi',),
'bilgummien': ('bilgummi',),
'bilgummiene': ('bilgummi',),
'bilgummier': ('bilgummi',),
'bilhold': ('bilhold',),
'bilholda': ('bilhold',),
'bilholdene': ('bilhold',),
'bilholdet': ('bilhold',),
'bilhorn': ('bilhorn',),
'bilhorna': ('bilhorn',),
'bilhornene': ('bilhorn',),
'bilhornet': ('bilhorn',),
'bilingvalisme': ('bilingvalisme',),
'bilingvalismen': ('bilingvalisme',),
'bilingvalismene': ('bilingvalisme',),
'bilingvalismer': ('bilingvalisme',),
'bilingvalitet': ('bilingvalitet',),
'bilingvaliteten': ('bilingvalitet',),
'bilingvalitetene': ('bilingvalitet',),
'bilingvaliteter': ('bilingvalitet',),
'bilingvisme': ('bilingvisme',),
'bilingvismen': ('bilingvisme',),
'bilingvismene': ('bilingvisme',),
'bilingvismer': ('bilingvisme',),
'bilingvitet': ('bilingvitet',),
'bilingviteten': ('bilingvitet',),
'bilingvitetene': ('bilingvitet',),
'bilingviteter': ('bilingvitet',),
'bilisme': ('bilisme',),
'bilismen': ('bilisme',),
'bilismene': ('bilisme',),
'bilismer': ('bilisme',),
'bilist': ('bilist',),
'bilisten': ('bilist',),
'bilistene': ('bilist',),
'bilister': ('bilist',),
'biljard': ('biljard',),
'biljarden': ('biljard',),
'biljardene': ('biljard',),
'biljarder': ('biljard',),
'biljardbord': ('biljardbord',),
'biljardborda': ('biljardbord',),
'biljardbordene': ('biljardbord',),
'biljardborder': ('biljardbord',),
'biljardbordet': ('biljardbord',),
'bilkart': ('bilkart',),
'bilkarta': ('bilkart',),
'bilkartene': ('bilkart',),
'bilkarter': ('bilkart',),
'bilkartet': ('bilkart',),
'bilkirkegård': ('bilkirkegård',),
'bilkirkegården': ('bilkirkegård',),
'bilkirkegårdene': ('bilkirkegård',),
'bilkirkegårder': ('bilkirkegård',),
'bilkjennemerka': ('bilkjennemerke',),
'bilkjennemerke': ('bilkjennemerke',),
'bilkjennemerkene': ('bilkjennemerke',),
'bilkjennemerker': ('bilkjennemerke',),
'bilkjennemerket': ('bilkjennemerke',),
'bilkolonne': ('bilkolonne',),
'bilkolonnen': ('bilkolonne',),
'bilkolonnene': ('bilkolonne',),
'bilkolonner': ('bilkolonne',),
'bilkonsern': ('bilkonsern',),
'bilkonserna': ('bilkonsern',),
'bilkonsernene': ('bilkonsern',),
'bilkonserner': ('bilkonsern',),
'bilkonsernet': ('bilkonsern',),
'bilkontroll': ('bilkontroll',),
'bilkontrollen': ('bilkontroll',),
'bilkontrollene': ('bilkontroll',),
'bilkontroller': ('bilkontroll',),
'bilkø': ('bilkø',),
'bilkøen': ('bilkø',),
'bilkøene': ('bilkø',),
'bilkøer': ('bilkø',),
'billass': ('billass',),
'billassa': ('billass',),
'billassene': ('billass',),
'billasset': ('billass',),
'bille': ('bille',),
'billen': ('bille',),
'billene': ('bille',),
'biller': ('bille',),
'billedarkiv': ('billedarkiv',),
'billedarkiva': ('billedarkiv',),
'billedarkivene': ('billedarkiv',),
'billedarkiver': ('billedarkiv',),
'billedarkivet': ('billedarkiv',),
'billedband': ('billedband',),
'billedbanda': ('billedband',),
'billedbandene': ('billedband',),
'billedbandet': ('billedband',),
'billedbibel': ('billedbibel',),
'billedbibelen': ('billedbibel',),
'billedbiblene': ('billedbibel',),
'billedbibler': ('billedbibel',),
'billedbånd': ('billedbånd',),
'billedbånda': ('billedbånd',),
'billedbåndene': ('billedbånd',),
'billedbåndet': ('billedbånd',),
'billedgalleri': ('billedgalleri',),
'billedgalleria': ('billedgalleri',),
'billedgalleriene': ('billedgalleri',),
'billedgallerier': ('billedgalleri',),
'billedgalleriet': ('billedgalleri',),
'billedgåta': ('billedgåte',),
'billedgåte': ('billedgåte',),
'billedgåten': ('billedgåte',),
'billedgåtene': ('billedgåte',),
'billedgåter': ('billedgåte',),
'billedhogger': ('billedhogger',),
'billedhoggere': ('billedhogger',),
'billedhoggeren': ('billedhogger',),
'billedhoggerer': ('billedhogger',),
'billedhoggerne': ('billedhogger',),
'billedhoggerkunst': ('billedhoggerkunst',),
'billedhoggerkunsten': ('billedhoggerkunst',),
'billedhoggerkunstene': ('billedhoggerkunst',),
'billedhoggerkunster': ('billedhoggerkunst',),
'billedhugger': ('billedhugger',),
'billedhuggere': ('billedhugger',),
'billedhuggeren': ('billedhugger',),
'billedhuggerer': ('billedhugger',),
'billedhuggerne': ('billedhugger',),
'billedhuggerkunst': ('billedhuggerkunst',),
'billedhuggerkunsten': ('billedhuggerkunst',),
'billedhuggerkunstene': ('billedhuggerkunst',),
'billedhuggerkunster': ('billedhuggerkunst',),
'billedkunst': ('billedkunst',),
'billedkunsten': ('billedkunst',),
'billedkunstene': ('billedkunst',),
'billedkunster': ('billedkunst',),
'billedkunstner': ('billedkunstner',),
'billedkunstnere': ('billedkunstner',),
'billedkunstneren': ('billedkunstner',),
'billedkunstnerer': ('billedkunstner',),
'billedkunstnerne': ('billedkunstner',),
'billedreportasje': ('billedreportasje',),
'billedreportasjen': ('billedreportasje',),
'billedreportasjene': ('billedreportasje',),
'billedreportasjer': ('billedreportasje',),
'billedrør': ('billedrør',),
'billedrøra': ('billedrør',),
'billedrørene': ('billedrør',),
'billedrøret': ('billedrør',),
'billedsamband': ('billedsamband',),
'billedsambanda': ('billedsamband',),
'billedsambandene': ('billedsamband',),
'billedsambandet': ('billedsamband',),
'billedskarphet': ('billedskarphet',),
'billedskarpheta': ('billedskarphet',),
'billedskarpheten': ('billedskarphet',),
'billedskarphetene': ('billedskarphet',),
'billedskarpheter': ('billedskarphet',),
'billedskjærer': ('billedskjærer',),
'billedskjærere': ('billedskjærer',),
'billedskjæreren': ('billedskjærer',),
'billedskjærerer': ('billedskjærer',),
'billedskjærerne': ('billedskjærer',),
'billedskjæring': ('billedskjæring',),
'billedskjæringa': ('billedskjæring',),
'billedskjæringen': ('billedskjæring',),
'billedskjæringene': ('billedskjæring',),
'billedskjæringer': ('billedskjæring',),
'billedskrift': ('billedskrift',),
'billedskrifta': ('billedskrift',),
'billedskriften': ('billedskrift',),
'billedskriftene': ('billedskrift',),
'billedskrifter': ('billedskrift',),
'billedspråk': ('billedspråk',),
'billedspråka': ('billedspråk',),
'billedspråkene': ('billedspråk',),
'billedspråket': ('billedspråk',),
'billedstorm': ('billedstorm',),
'billedstormen': ('billedstorm',),
'billedstormene': ('billedstorm',),
'billedstormer': ('billedstorm',),
'billedstormer': ('billedstormer',),
'billedstormere': ('billedstormer',),
'billedstormeren': ('billedstormer',),
'billedstormerer': ('billedstormer',),
'billedstormerne': ('billedstormer',),
'billedtekst': ('billedtekst',),
'billedteksta': ('billedtekst',),
'billedteksten': ('billedtekst',),
'billedtekstene': ('billedtekst',),
'billedtekster': ('billedtekst',),
'billedtelegrafi': ('billedtelegrafi',),
'billedtelegrafien': ('billedtelegrafi',),
'billedtelegrafiene': ('billedtelegrafi',),
'billedtelegrafier': ('billedtelegrafi',),
'billedvev': ('billedvev',),
'billedveven': ('billedvev',),
'billedvevene': ('billedvev',),
'billedvever': ('billedvev',),
'billedveving': ('billedveving',),
'billedvevinga': ('billedveving',),
'billedvevingen': ('billedveving',),
'billedvevingene': ('billedveving',),
'billedvevinger': ('billedveving',),
'billedvevning': ('billedvevning',),
'billedvevninga': ('billedvevning',),
'billedvevningen': ('billedvevning',),
'billedvevningene': ('billedvevning',),
'billedvevninger': ('billedvevning',),
'billett': ('billett',),
'billetten': ('billett',),
'billettene': ('billett',),
'billetter': ('billett',),
'billetthefta': ('billetthefte',),
'billetthefte': ('billetthefte',),
'billettheftene': ('billetthefte',),
'billetthefter': ('billetthefte',),
'billettheftet': ('billetthefte',),
'billettkontor': ('billettkontor',),
'billettkontora': ('billettkontor',),
'billettkontorene': ('billettkontor',),
'billettkontorer': ('billettkontor',),
'billettkontoret': ('billettkontor',),
'billettkontroll': ('billettkontroll',),
'billettkontrollen': ('billettkontroll',),
'billettkontrollene': ('billettkontroll',),
'billettkontroller': ('billettkontroll',),
'billettluka': ('billettluke',),
'billettluke': ('billettluke',),
'billettluken': ('billettluke',),
'billettlukene': ('billettluke',),
'billettluker': ('billettluke',),
'billettpris': ('billettpris',),
'billettprisen': ('billettpris',),
'billettprisene': ('billettpris',),
'billettpriser': ('billettpris',),
'billettør': ('billettør',),
'billettøren': ('billettør',),
'billettørene': ('billettør',),
'billettører': ('billettør',),
'billigbillett': ('billigbillett',),
'billigbilletten': ('billigbillett',),
'billigbillettene': ('billigbillett',),
'billigbilletter': ('billigbillett',),
'billighet': ('billighet',),
'billigheta': ('billighet',),
'billigheten': ('billighet',),
'billighetene': ('billighet',),
'billigheter': ('billighet',),
'billighetserstatning': ('billighetserstatning',),
'billighetserstatninga': ('billighetserstatning',),
'billighetserstatningen': ('billighetserstatning',),
'billighetserstatningene': ('billighetserstatning',),
'billighetserstatninger': ('billighetserstatning',),
'billigsalg': ('billigsalg',),
'billigsalga': ('billigsalg',),
'billigsalgene': ('billigsalg',),
'billigsalget': ('billigsalg',),
'billigutgava': ('billigutgave',),
'billigutgave': ('billigutgave',),
'billigutgaven': ('billigutgave',),
'billigutgavene': ('billigutgave',),
'billigutgaver': ('billigutgave',),
'billion': ('billion',),
'billionen': ('billion',),
'billionene': ('billion',),
'billioner': ('billion',),
'billiondel': ('billiondel',),
'billiondelen': ('billiondel',),
'billiondelene': ('billiondel',),
'billiondeler': ('billiondel',),
'billøp': ('billøp',),
'billøpa': ('billøp',),
'billøpene': ('billøp',),
'billøpet': ('billøp',),
'bilmekaniker': ('bilmekaniker',),
'bilmekanikere': ('bilmekaniker',),
'bilmekanikeren': ('bilmekaniker',),
'bilmekanikerer': ('bilmekaniker',),
'bilmekanikerne': ('bilmekaniker',),
'bilmerka': ('bilmerke',),
'bilmerke': ('bilmerke',),
'bilmerkene': ('bilmerke',),
'bilmerker': ('bilmerke',),
'bilmerket': ('bilmerke',),
'bilnummer': ('bilnummer',),
'bilnummeret': ('bilnummer',),
'bilnumra': ('bilnummer',),
'bilnumre': ('bilnummer',),
'bilnumrene': ('bilnummer',),
'biloppretter': ('biloppretter',),
'bilopprettere': ('biloppretter',),
'biloppretteren': ('biloppretter',),
'biloppretterer': ('biloppretter',),
'biloppretterne': ('biloppretter',),
'bilpark': ('bilpark',),
'bilparken': ('bilpark',),
'bilparkene': ('bilpark',),
'bilparker': ('bilpark',),
'bilradio': ('bilradio',),
'bilradioen': ('bilradio',),
'bilradioene': ('bilradio',),
'bilradioer': ('bilradio',),
'bilreparatør': ('bilreparatør',),
'bilreparatøren': ('bilreparatør',),
'bilreparatørene': ('bilreparatør',),
'bilreparatører': ('bilreparatør',),
'biltilsyn': ('biltilsyn',),
'biltilsyna': ('biltilsyn',),
'biltilsynene': ('biltilsyn',),
'biltilsynet': ('biltilsyn',),
'biltog': ('biltog',),
'biltoga': ('biltog',),
'biltogene': ('biltog',),
'biltoget': ('biltog',),
'biltrafikk': ('biltrafikk',),
'biltrafikken': ('biltrafikk',),
'biltrafikkene': ('biltrafikk',),
'biltrafikker': ('biltrafikk',),
'bimetall': ('bimetall',),
'bimetalla': ('bimetall',),
'bimetallene': ('bimetall',),
'bimetaller': ('bimetall',),
'bimetallet': ('bimetall',),
'bimetallisme': ('bimetallisme',),
'bimetallismen': ('bimetallisme',),
'bimetallismene': ('bimetallisme',),
'bimetallismer': ('bimetallisme',),
'bind': ('bind',),
'binda': ('bind',),
'bindene': ('bind',),
'bindet': ('bind',),
'binde-s': ('binde-s',),
'binde-s-en': ('binde-s',),
'binde-s-ene': ('binde-s',),
'binde-s-er': ('binde-s',),
'bindeledd': ('bindeledd',),
'bindeledda': ('bindeledd',),
'bindeleddene': ('bindeledd',),
'bindeleddet': ('bindeledd',),
'bindemiddel': ('bindemiddel',),
'bindemiddelet': ('bindemiddel',),
'bindemidla': ('bindemiddel',),
'bindemidlene': ('bindemiddel',),
'bindemidler': ('bindemiddel',),
'bindemidlet': ('bindemiddel',),
'bindeord': ('bindeord',),
'bindeorda': ('bindeord',),
'bindeordene': ('bindeord',),
'bindeordet': ('bindeord',),
'binder': ('binder',),
'bindere': ('binder',),
'binderen': ('binder',),
'binderer': ('binder',),
'binderne': ('binder',),
'binderi': ('binderi',),
'binderia': ('binderi',),
'binderiene': ('binderi',),
'binderier': ('binderi',),
'binderiet': ('binderi',),
'binders': ('binders',),
'bindersen': ('binders',),
'bindersene': ('binders',),
'binderser': ('binders',),
'bindestrek': ('bindestrek',),
'bindestreken': ('bindestrek',),
'bindestrekene': ('bindestrek',),
'bindestreker': ('bindestrek',),
'bindevev': ('bindevev',),
'bindeveva': ('bindevev',),
'bindevevene': ('bindevev',),
'bindevevet': ('bindevev',),
'bindevokal': ('bindevokal',),
'bindevokalen': ('bindevokal',),
'bindevokalene': ('bindevokal',),
'bindevokaler': ('bindevokal',),
'binding': ('binding',),
'bindinga': ('binding',),
'bindingen': ('binding',),
'bindingene': ('binding',),
'bindinger': ('binding',),
'bindingsverk': ('bindingsverk',),
'bindingsverka': ('bindingsverk',),
'bindingsverkene': ('bindingsverk',),
'bindingsverker': ('bindingsverk',),
'bindingsverket': ('bindingsverk',),
'bindingsverkshus': ('bindingsverkshus',),
'bindingsverkshusa': ('bindingsverkshus',),
'bindingsverkshusene': ('bindingsverkshus',),
'bindingsverkshuset': ('bindingsverkshus',),
'bindsel': ('bindsel',),
'bindselet': ('bindsel',),
'bindsla': ('bindsel',),
'bindslene': ('bindsel',),
'bindsler': ('bindsel',),
'bindslet': ('bindsel',),
'bing': ('bing',),
'bingen': ('bing',),
'bingene': ('bing',),
'binger': ('bing',),
'binge': ('binge',),
'bingen': ('binge',),
'bingene': ('binge',),
'binger': ('binge',),
'bingefjøs': ('bingefjøs',),
'bingefjøsa': ('bingefjøs',),
'bingefjøsen': ('bingefjøs',),
'bingefjøsene': ('bingefjøs',),
'bingefjøset': ('bingefjøs',),
'bingfjøs': ('bingfjøs',),
'bingfjøsa': ('bingfjøs',),
'bingfjøsen': ('bingfjøs',),
'bingfjøsene': ('bingfjøs',),
'bingfjøset': ('bingfjøs',),
'bingo': ('bingo',),
'bingoen': ('bingo',),
'bingoene': ('bingo',),
'bingoer': ('bingo',),
'bingolokala': ('bingolokale',),
'bingolokale': ('bingolokale',),
'bingolokalene': ('bingolokale',),
'bingolokaler': ('bingolokale',),
'bingolokalet': ('bingolokale',),
'binna': ('binne',),
'binne': ('binne',),
'binnen': ('binne',),
'binnene': ('binne',),
'binner': ('binne',),
'binnsåle': ('binnsåle',),
'binnsålen': ('binnsåle',),
'binnsålene': ('binnsåle',),
'binnsåler': ('binnsåle',),
'binokkel': ('binokkel',),
'binokkelen': ('binokkel',),
'binoklene': ('binokkel',),
'binokler': ('binokkel',),
'binom': ('binom',),
'binoma': ('binom',),
'binomene': ('binom',),
'binomer': ('binom',),
'binomet': ('binom',),
'binomialformel': ('binomialformel',),
'binomialformelen': ('binomialformel',),
'binomialformlene': ('binomialformel',),
'binomialformler': ('binomialformel',),
'binyra': ('binyre',),
'binyre': ('binyre',),
'binyren': ('binyre',),
'binyrene': ('binyre',),
'binyrer': ('binyre',),
'binyret': ('binyre',),
'binæring': ('binæring',),
'binæringa': ('binæring',),
'binæringen': ('binæring',),
'binæringene': ('binæring',),
'binæringer': ('binæring',),
'biocid': ('biocid',),
'biocida': ('biocid',),
'biocidene': ('biocid',),
'biocider': ('biocid',),
'biocidet': ('biocid',),
'biodynamikk': ('biodynamikk',),
'biodynamikken': ('biodynamikk',),
'biodynamikkene': ('biodynamikk',),
'biodynamikker': ('biodynamikk',),
'biofysikk': ('biofysikk',),
'biofysikken': ('biofysikk',),
'biofysikkene': ('biofysikk',),
'biofysikker': ('biofysikk',),
'biograf': ('biograf',),
'biografen': ('biograf',),
'biografene': ('biograf',),
'biografer': ('biograf',),
'biografi': ('biografi',),
'biografien': ('biografi',),
'biografiene': ('biografi',),
'biografier': ('biografi',),
'biokjemi': ('biokjemi',),
'biokjemien': ('biokjemi',),
'biokjemiene': ('biokjemi',),
'biokjemier': ('biokjemi',),
'biokjemiker': ('biokjemiker',),
'biokjemikere': ('biokjemiker',),
'biokjemikeren': ('biokjemiker',),
'biokjemikerer': ('biokjemiker',),
'biokjemikerne': ('biokjemiker',),
'biolitt': ('biolitt',),
'biolitten': ('biolitt',),
'biolittene': ('biolitt',),
'biolitter': ('biolitt',),
'biolog': ('biolog',),
'biologen': ('biolog',),
'biologene': ('biolog',),
'biologer': ('biolog',),
'biologi': ('biologi',),
'biologien': ('biologi',),
'biologiene': ('biologi',),
'biologier': ('biologi',),
'biomasse': ('biomasse',),
'biomassen': ('biomasse',),
'biomassene': ('biomasse',),
'biomasser': ('biomasse',),
'biopsi': ('biopsi',),
'biopsien': ('biopsi',),
'biopsiene': ('biopsi',),
'biopsier': ('biopsi',),
'biorytme': ('biorytme',),
'biorytmen': ('biorytme',),
'biorytmene': ('biorytme',),
'biorytmer': ('biorytme',),
'biosfære': ('biosfære',),
'biosfæren': ('biosfære',),
'biosfærene': ('biosfære',),
'biosfærer': ('biosfære',),
'bioteknikk': ('bioteknikk',),
'bioteknikken': ('bioteknikk',),
'bioteknikkene': ('bioteknikk',),
'bioteknikker': ('bioteknikk',),
'bioteknologi': ('bioteknologi',),
'bioteknologien': ('bioteknologi',),
'bioteknologiene': ('bioteknologi',),
'bioteknologier': ('bioteknologi',),
'biotop': ('biotop',),
'biotopen': ('biotop',),
'biotopene': ('biotop',),
'biotoper': ('biotop',),
'biotyp': ('biotyp',),
'biotypen': ('biotyp',),
'biotypene': ('biotyp',),
'biotyper': ('biotyp',),
'biperson': ('biperson',),
'bipersonen': ('biperson',),
'bipersonene': ('biperson',),
'bipersoner': ('biperson',),
'biprodukt': ('biprodukt',),
'biprodukta': ('biprodukt',),
'biproduktene': ('biprodukt',),
'biprodukter': ('biprodukt',),
'biproduktet': ('biprodukt',),
'birgittiner': ('birgittiner',),
'birgittinere': ('birgittiner',),
'birgittineren': ('birgittiner',),
'birgittinerer': ('birgittiner',),
'birgittinerne': ('birgittiner',),
'birgittinerkloster': ('birgittinerkloster',),
'birgittinerklosteret': ('birgittinerkloster',),
'birgittinerklostra': ('birgittinerkloster',),
'birgittinerklostre': ('birgittinerkloster',),
'birgittinerklostrene': ('birgittinerkloster',),
'birgittinerklostret': ('birgittinerkloster',),
'birgittinermunk': ('birgittinermunk',),
'birgittinermunken': ('birgittinermunk',),
'birgittinermunkene': ('birgittinermunk',),
'birgittinermunker': ('birgittinermunk',),
'birgittinernonna': ('birgittinernonne',),
'birgittinernonne': ('birgittinernonne',),
'birgittinernonnen': ('birgittinernonne',),
'birgittinernonnene': ('birgittinernonne',),
'birgittinernonner': ('birgittinernonne',),
'birgittinerorden': ('birgittinerorden',),
'birgittinerordenen': ('birgittinerorden',),
'birgittinerordenene': ('birgittinerorden',),
'birgittinerordener': ('birgittinerorden',),
'birkebeiner': ('birkebeiner',),
'birkebeinere': ('birkebeiner',),
'birkebeineren': ('birkebeiner',),
'birkebeinerer': ('birkebeiner',),
'birkebeinerne': ('birkebeiner',),
'birolla': ('birolle',),
'birolle': ('birolle',),
'birollen': ('birolle',),
'birollene': ('birolle',),
'biroller': ('birolle',),
'birøkt': ('birøkt',),
'birøkta': ('birøkt',),
'birøkten': ('birøkt',),
'birøktene': ('birøkt',),
'birøkter': ('birøkt',),
'birøkter': ('birøkter',),
'birøktere': ('birøkter',),
'birøkteren': ('birøkter',),
'birøkterer': ('birøkter',),
'birøkterne': ('birøkter',),
'bisak': ('bisak',),
'bisaka': ('bisak',),
'bisaken': ('bisak',),
'bisakene': ('bisak',),
'bisaker': ('bisak',),
'bisam': ('bisam',),
'bisamen': ('bisam',),
'bisamene': ('bisam',),
'bisamer': ('bisam',),
'bisamfunn': ('bisamfunn',),
'bisamfunna': ('bisamfunn',),
'bisamfunnene': ('bisamfunn',),
'bisamfunnet': ('bisamfunn',),
'bisamkåpa': ('bisamkåpe',),
'bisamkåpe': ('bisamkåpe',),
'bisamkåpen': ('bisamkåpe',),
'bisamkåpene': ('bisamkåpe',),
'bisamkåper': ('bisamkåpe',),
'bisamrotta': ('bisamrotte',),
'bisamrotte': ('bisamrotte',),
'bisamrotten': ('bisamrotte',),
'bisamrottene': ('bisamrotte',),
'bisamrotter': ('bisamrotte',),
'bisamskinn': ('bisamskinn',),
'bisamskinna': ('bisamskinn',),
'bisamskinnene': ('bisamskinn',),
'bisamskinnet': ('bisamskinn',),
'bisarreri': ('bisarreri',),
'bisarreria': ('bisarreri',),
'bisarreriene': ('bisarreri',),
'bisarrerier': ('bisarreri',),
'bisarreriet': ('bisarreri',),
'biscene': ('biscene',),
'biscenen': ('biscene',),
'biscenene': ('biscene',),
'biscener': ('biscene',),
'bise': ('bise',),
'bisen': ('bise',),
'bisene': ('bise',),
'biser': ('bise',),
'biseksualitet': ('biseksualitet',),
'biseksualiteten': ('biseksualitet',),
'biseksualitetene': ('biseksualitet',),
'biseksualiteter': ('biseksualitet',),
'bisetning': ('bisetning',),
'bisetninga': ('bisetning',),
'bisetningen': ('bisetning',),
'bisetningene': ('bisetning',),
'bisetninger': ('bisetning',),
'bisettelse': ('bisettelse',),
'bisettelsen': ('bisettelse',),
'bisettelsene': ('bisettelse',),
'bisettelser': ('bisettelse',),
'bisitter': ('bisitter',),
'bisittere': ('bisitter',),
'bisitteren': ('bisitter',),
'bisitterer': ('bisitter',),
'bisitterne': ('bisitter',),
'bisk': ('bisk',),
'bisken': ('bisk',),
'biskene': ('bisk',),
'bisker': ('bisk',),
'biskop': ('biskop',),
'biskopen': ('biskop',),
'biskopene': ('biskop',),
'biskoper': ('biskop',),
'biskuit': ('biskuit',),
'biskuiten': ('biskuit',),
'biskuitene': ('biskuit',),
'biskuiter': ('biskuit',),
'bislag': ('bislag',),
'bislaga': ('bislag',),
'bislagene': ('bislag',),
'bislaget': ('bislag',),
'bismak': ('bismak',),
'bismaken': ('bismak',),
'bismakene': ('bismak',),
'bismaker': ('bismak',),
'bismer': ('bismer',),
'bismere': ('bismer',),
'bismeren': ('bismer',),
'bismerer': ('bismer',),
'bismerne': ('bismer',),
'bismerkrok': ('bismerkrok',),
'bismerkroken': ('bismerkrok',),
'bismerkrokene': ('bismerkrok',),
'bismerkroker': ('bismerkrok',),
'bismerlodd': ('bismerlodd',),
'bismerlodda': ('bismerlodd',),
'bismerloddene': ('bismerlodd',),
'bismerlodder': ('bismerlodd',),
'bismerloddet': ('bismerlodd',),
'bismerpund': ('bismerpund',),
'bismerpunda': ('bismerpund',),
'bismerpundene': ('bismerpund',),
'bismerpundet': ('bismerpund',),
'bismerstang': ('bismerstang',),
'bismerstanga': ('bismerstang',),
'bismerstangen': ('bismerstang',),
'bismerstengene': ('bismerstang',),
'bismerstenger': ('bismerstang',),
'bismervekt': ('bismervekt',),
'bismervekta': ('bismervekt',),
'bismervekten': ('bismervekt',),
'bismervektene': ('bismervekt',),
'bismervekter': ('bismervekt',),
'bisol': ('bisol',),
'bisola': ('bisol',),
'bisolen': ('bisol',),
'bisolene': ('bisol',),
'bisoler': ('bisol',),
'bison': ('bison',),
'bisonen': ('bison',),
'bisonene': ('bison',),
'bisoner': ('bison',),
'bisonokse': ('bisonokse',),
'bisonoksen': ('bisonokse',),
'bisonoksene': ('bisonokse',),
'bisonokser': ('bisonokse',),
'bispedømma': ('bispedømme',),
'bispedømme': ('bispedømme',),
'bispedømmene': ('bispedømme',),
'bispedømmer': ('bispedømme',),
'bispedømmet': ('bispedømme',),
'bispedømmeråd': ('bispedømmeråd',),
'bispedømmeråda': ('bispedømmeråd',),
'bispedømmerådene': ('bispedømmeråd',),
'bispedømmerådet': ('bispedømmeråd',),
'bispeembeta': ('bispeembete',),
'bispeembete': ('bispeembete',),
'bispeembetene': ('bispeembete',),
'bispeembeter': ('bispeembete',),
'bispeembetet': ('bispeembete',),
'bispegard': ('bispegard',),
'bispegarden': ('bispegard',),
'bispegardene': ('bispegard',),
'bispegarder': ('bispegard',),
'bispegård': ('bispegård',),
'bispegården': ('bispegård',),
'bispegårdene': ('bispegård',),
'bispegårder': ('bispegård',),
'bispehua': ('bispehue',),
'bispehue': ('bispehue',),
'bispehuen': ('bispehue',),
'bispehuene': ('bispehue',),
'bispehuer': ('bispehue',),
'bispehuva': ('bispehuve',),
'bispehuve': ('bispehuve',),
'bispehuven': ('bispehuve',),
'bispehuvene': ('bispehuve',),
'bispehuver': ('bispehuve',),
'bispelua': ('bispelue',),
'bispelue': ('bispelue',),
'bispeluen': ('bispelue',),
'bispeluene': ('bispelue',),
'bispeluer': ('bispelue',),
'bispelua': ('bispelue',),
'bispelue': ('bispelue',),
'bispeluen': ('bispelue',),
'bispeluene': ('bispelue',),
'bispeluer': ('bispelue',),
'bispeluva': ('bispeluve',),
'bispeluve': ('bispeluve',),
'bispeluven': ('bispeluve',),
'bispeluvene': ('bispeluve',),
'bispeluver': ('bispeluve',),
'bispeluva': ('bispeluve',),
'bispeluve': ('bispeluve',),
'bispeluven': ('bispeluve',),
'bispeluvene': ('bispeluve',),
'bispeluver': ('bispeluve',),
'bispeordinasjon': ('bispeordinasjon',),
'bispeordinasjonen': ('bispeordinasjon',),
'bispeordinasjonene': ('bispeordinasjon',),
'bispeordinasjoner': ('bispeordinasjon',),
'bispering': ('bispering',),
'bisperingen': ('bispering',),
'bisperingene': ('bispering',),
'bisperinger': ('bispering',),
'bispeseta': ('bispesete',),
'bispesete': ('bispesete',),
'bispesetene': ('bispesete',),
'bispeseter': ('bispesete',),
'bispesetet': ('bispesete',),
'bispestol': ('bispestol',),
'bispestolen': ('bispestol',),
'bispestolene': ('bispestol',),
'bispestoler': ('bispestol',),
'bispevisitas': ('bispevisitas',),
'bispevisitasen': ('bispevisitas',),
'bispevisitasene': ('bispevisitas',),
'bispevisitaser': ('bispevisitas',),
'bissevov': ('bissevov',),
'bissevoven': ('bissevov',),
'bissevovene': ('bissevov',),
'bissevover': ('bissevov',),
'bistand': ('bistand',),
'bistanden': ('bistand',),
'bistandene': ('bistand',),
'bistander': ('bistand',),
'bistandsminister': ('bistandsminister',),
'bistandsministere': ('bistandsminister',),
'bistandsministeren': ('bistandsminister',),
'bistandsministerer': ('bistandsminister',),
'bistandsministerne': ('bistandsminister',),
'bistandsministre': ('bistandsminister',),
'bistandsministrene': ('bistandsminister',),
'bistandsministrer': ('bistandsminister',),
'bistandsplikt': ('bistandsplikt',),
'bistandsplikta': ('bistandsplikt',),
'bistandsplikten': ('bistandsplikt',),
'bistandspliktene': ('bistandsplikt',),
'bistandsplikter': ('bistandsplikt',),
'bistikk': ('bistikk',),
'bistikka': ('bistikk',),
'bistikkene': ('bistikk',),
'bistikket': ('bistikk',),
'bistilling': ('bistilling',),
'bistillinga': ('bistilling',),
'bistillingen': ('bistilling',),
'bistillingene': ('bistilling',),
'bistillinger': ('bistilling',),
'bistro': ('bistro',),
'bistroen': ('bistro',),
'bistroene': ('bistro',),
'bistroer': ('bistro',),
'bisverm': ('bisverm',),
'bisvermen': ('bisverm',),
'bisvermene': ('bisverm',),
'bisvermer': ('bisverm',),
'bit': ('bit',),
'biten': ('bit',),
'bitene': ('bit',),
'biter': ('bit',),
'bits': ('bit',),
'bit': ('bit',),
'biten': ('bit',),
'bitene': ('bit',),
'biter': ('bit',),
'bite': ('bite',),
'biten': ('bite',),
'bitene': ('bite',),
'biter': ('bite',),
'bitemunn': ('bitemunn',),
'bitemunnen': ('bitemunn',),
'bitemunnene': ('bitemunn',),
'bitemunner': ('bitemunn',),
'bitestikkel': ('bitestikkel',),
'bitestikkelen': ('bitestikkel',),
'bitestiklene': ('bitestikkel',),
'bitestikler': ('bitestikkel',),
'biteti': ('biteti',),
'bitetia': ('biteti',),
'bitetiene': ('biteti',),
'bitetiet': ('biteti',),
'biting': ('biting',),
'bitinga': ('biting',),
'bitingen': ('biting',),
'bitingene': ('biting',),
'bitjern': ('bitjern',),
'bitjerna': ('bitjern',),
'bitjernene': ('bitjern',),
'bitjernet': ('bitjern',),
'bitrykk': ('bitrykk',),
'bitrykka': ('bitrykk',),
'bitrykkene': ('bitrykk',),
'bitrykket': ('bitrykk',),
'bitt': ('bitt',),
'bitta': ('bitt',),
'bittene': ('bitt',),
'bittet': ('bitt',),
'bittekonvall': ('bittekonvall',),
'bittekonvallen': ('bittekonvall',),
'bittekonvallene': ('bittekonvall',),
'bittekonvaller': ('bittekonvall',),
'bitter': ('bitter',),
'bittere': ('bitter',),
'bitteren': ('bitter',),
'bitterer': ('bitter',),
'bitterne': ('bitter',),
'bitterhet': ('bitterhet',),
'bitterheta': ('bitterhet',),
'bitterheten': ('bitterhet',),
'bitterhetene': ('bitterhet',),
'bitterheter': ('bitterhet',),
'bitterstoff': ('bitterstoff',),
'bitterstoffa': ('bitterstoff',),
'bitterstoffene': ('bitterstoff',),
'bitterstoffer': ('bitterstoff',),
'bitterstoffet': ('bitterstoff',),
'bittervin': ('bittervin',),
'bittervinen': ('bittervin',),
'bittervinene': ('bittervin',),
'bitterviner': ('bittervin',),
'bitumen': ('bitumen',),
'bitumena': ('bitumen',),
'bitumenene': ('bitumen',),
'bitumenet': ('bitumen',),
'bivirkning': ('bivirkning',),
'bivirkninga': ('bivirkning',),
'bivirkningen': ('bivirkning',),
'bivirkningene': ('bivirkning',),
'bivirkninger': ('bivirkning',),
'bivoks': ('bivoks',),
'bivoksa': ('bivoks',),
'bivoksen': ('bivoks',),
'bivoksene': ('bivoks',),
'bivokser': ('bivoks',),
'bivokset': ('bivoks',),
'bivuakk': ('bivuakk',),
'bivuakken': ('bivuakk',),
'bivuakkene': ('bivuakk',),
'bivuakker': ('bivuakk',),
'bjeff': ('bjeff',),
'bjeffa': ('bjeff',),
'bjeffene': ('bjeff',),
'bjeffet': ('bjeff',),
'bjekso': ('bjekso',),
'bjeksoen': ('bjekso',),
'bjeksoene': ('bjekso',),
'bjeksoer': ('bjekso',),
'bjelke': ('bjelke',),
'bjelken': ('bjelke',),
'bjelkene': ('bjelke',),
'bjelker': ('bjelke',),
'bjelkeloft': ('bjelkeloft',),
'bjelkelofta': ('bjelkeloft',),
'bjelkeloftene': ('bjelkeloft',),
'bjelkeloftet': ('bjelkeloft',),
'bjelketak': ('bjelketak',),
'bjelketaka': ('bjelketak',),
'bjelketakene': ('bjelketak',),
'bjelketaket': ('bjelketak',),
'bjella': ('bjelle',),
'bjelle': ('bjelle',),
'bjellen': ('bjelle',),
'bjellene': ('bjelle',),
'bjeller': ('bjelle',),
'bjella': ('bjelle',),
'bjelle': ('bjelle',),
'bjellen': ('bjelle',),
'bjellene': ('bjelle',),
'bjeller': ('bjelle',),
'bjelleblom': ('bjelleblom',),
'bjelleblommen': ('bjelleblom',),
'bjelleblommene': ('bjelleblom',),
'bjelleblommer': ('bjelleblom',),
'bjelleblom': ('bjelleblom',),
'bjelleblommen': ('bjelleblom',),
'bjelleblommene': ('bjelleblom',),
'bjelleblommer': ('bjelleblom',),
'bjelleklang': ('bjelleklang',),
'bjelleklangen': ('bjelleklang',),
'bjelleklangene': ('bjelleklang',),
'bjelleklanger': ('bjelleklang',),
'bjelleklang': ('bjelleklang',),
'bjelleklangen': ('bjelleklang',),
'bjelleklangene': ('bjelleklang',),
'bjelleklanger': ('bjelleklang',),
'bjelleklave': ('bjelleklave',),
'bjelleklaven': ('bjelleklave',),
'bjelleklavene': ('bjelleklave',),
'bjelleklaver': ('bjelleklave',),
'bjelleklave': ('bjelleklave',),
'bjelleklaven': ('bjelleklave',),
'bjelleklavene': ('bjelleklave',),
'bjelleklaver': ('bjelleklave',),
'bjelleku': ('bjelleku',),
'bjellekua': ('bjelleku',),
'bjellekuen': ('bjelleku',),
'bjellekuene': ('bjelleku',),
'bjellekuer': ('bjelleku',),
'bjellekyr': ('bjelleku',),
'bjellekyrne': ('bjelleku',),
'bjelleku': ('bjelleku',),
'bjellekua': ('bjelleku',),
'bjellekuen': ('bjelleku',),
'bjellekuene': ('bjelleku',),
'bjellekuer': ('bjelleku',),
'bjellekyr': ('bjelleku',),
'bjellekyrne': ('bjelleku',),
'bjellesau': ('bjellesau',),
'bjellesauen': ('bjellesau',),
'bjellesauene': ('bjellesau',),
'bjellesauer': ('bjellesau',),
'bjellesau': ('bjellesau',),
'bjellesauen': ('bjellesau',),
'bjellesauene': ('bjellesau',),
'bjellesauer': ('bjellesau',),
'bjerk': ('bjerk',),
'bjerka': ('bjerk',),
'bjerken': ('bjerk',),
'bjerkene': ('bjerk',),
'bjerker': ('bjerk',),
'bjerkebelta': ('bjerkebelte',),
'bjerkebelte': ('bjerkebelte',),
'bjerkebeltene': ('bjerkebelte',),
'bjerkebelter': ('bjerkebelte',),
'bjerkebeltet': ('bjerkebelte',),
'bjerkefamilie': ('bjerkefamilie',),
'bjerkefamilien': ('bjerkefamilie',),
'bjerkefamiliene': ('bjerkefamilie',),
'bjerkefamilier': ('bjerkefamilie',),
'bjerkefink': ('bjerkefink',),
'bjerkefinken': ('bjerkefink',),
'bjerkefinkene': ('bjerkefink',),
'bjerkefinker': ('bjerkefink',),
'bjerkeli': ('bjerkeli',),
'bjerkelia': ('bjerkeli',),
'bjerkelien': ('bjerkeli',),
'bjerkeliene': ('bjerkeli',),
'bjerkelier': ('bjerkeli',),
'bjerkeris': ('bjerkeris',),
'bjerkerisa': ('bjerkeris',),
'bjerkerisene': ('bjerkeris',),
'bjerkeriset': ('bjerkeris',),
'bjerkestamme': ('bjerkestamme',),
'bjerkestammen': ('bjerkestamme',),
'bjerkestammene': ('bjerkestamme',),
'bjerkestammer': ('bjerkestamme',),
'bjerkeved': ('bjerkeved',),
'bjerkeveden': ('bjerkeved',),
'bjerkevedene': ('bjerkeved',),
'bjerkeveder': ('bjerkeved',),
'bjølla': ('bjølle',),
'bjølle': ('bjølle',),
'bjøllen': ('bjølle',),
'bjøllene': ('bjølle',),
'bjøller': ('bjølle',),
'bjølla': ('bjølle',),
'bjølle': ('bjølle',),
'bjøllen': ('bjølle',),
'bjøllene': ('bjølle',),
'bjøller': ('bjølle',),
'bjølleblom': ('bjølleblom',),
'bjølleblommen': ('bjølleblom',),
'bjølleblommene': ('bjølleblom',),
'bjølleblommer': ('bjølleblom',),
'bjølleblom': ('bjølleblom',),
'bjølleblommen': ('bjølleblom',),
'bjølleblommene': ('bjølleblom',),
'bjølleblommer': ('bjølleblom',),
'bjølleklang': ('bjølleklang',),
'bjølleklangen': ('bjølleklang',),
'bjølleklangene': ('bjølleklang',),
'bjølleklanger': ('bjølleklang',),
'bjølleklang': ('bjølleklang',),
'bjølleklangen': ('bjølleklang',),
'bjølleklangene': ('bjølleklang',),
'bjølleklanger': ('bjølleklang',),
'bjølleklave': ('bjølleklave',),
'bjølleklaven': ('bjølleklave',),
'bjølleklavene': ('bjølleklave',),
'bjølleklaver': ('bjølleklave',),
'bjølleklave': ('bjølleklave',),
'bjølleklaven': ('bjølleklave',),
'bjølleklavene': ('bjølleklave',),
'bjølleklaver': ('bjølleklave',),
'bjølleku': ('bjølleku',),
'bjøllekua': ('bjølleku',),
'bjøllekuene': ('bjølleku',),
'bjøllekuer': ('bjølleku',),
'bjøllekyr': ('bjølleku',),
'bjøllekyrne': ('bjølleku',),
'bjølleku': ('bjølleku',),
'bjøllekua': ('bjølleku',),
'bjøllekuene': ('bjølleku',),
'bjøllekuer': ('bjølleku',),
'bjøllekyr': ('bjølleku',),
'bjøllekyrne': ('bjølleku',),
'bjøllesau': ('bjøllesau',),
'bjøllesauen': ('bjøllesau',),
'bjøllesauene': ('bjøllesau',),
'bjøllesauer': ('bjøllesau',),
'bjøllesau': ('bjøllesau',),
'bjøllesauen': ('bjøllesau',),
'bjøllesauene': ('bjøllesau',),
'bjøllesauer': ('bjøllesau',),
'bjørk': ('bjørk',),
'bjørka': ('bjørk',),
'bjørken': ('bjørk',),
'bjørkene': ('bjørk',),
'bjørker': ('bjørk',),
'bjørkebelta': ('bjørkebelte',),
'bjørkebelte': ('bjørkebelte',),
'bjørkebeltene': ('bjørkebelte',),
'bjørkebelter': ('bjørkebelte',),
'bjørkebeltet': ('bjørkebelte',),
'bjørkefamilie': ('bjørkefamilie',),
'bjørkefamilien': ('bjørkefamilie',),
'bjørkefamiliene': ('bjørkefamilie',),
'bjørkefamilier': ('bjørkefamilie',),
'bjørkefink': ('bjørkefink',),
'bjørkefinken': ('bjørkefink',),
'bjørkefinkene': ('bjørkefink',),
'bjørkefinker': ('bjørkefink',),
'bjørkeli': ('bjørkeli',),
'bjørkelia': ('bjørkeli',),
'bjørkelien': ('bjørkeli',),
'bjørkeliene': ('bjørkeli',),
'bjørkelier': ('bjørkeli',),
'bjørkeris': ('bjørkeris',),
'bjørkerisa': ('bjørkeris',),
'bjørkerisene': ('bjørkeris',),
'bjørkeriset': ('bjørkeris',),
'bjørkestamme': ('bjørkestamme',),
'bjørkestammen': ('bjørkestamme',),
'bjørkestammene': ('bjørkestamme',),
'bjørkestammer': ('bjørkestamme',),
'bjørkeved': ('bjørkeved',),
'bjørkeveden': ('bjørkeved',),
'bjørkevedene': ('bjørkeved',),
'bjørkeveder': ('bjørkeved',),
'bjørn': ('bjørn',),
'bjørnen': ('bjørn',),
'bjørnene': ('bjørn',),
'bjørner': ('bjørn',),
'bjørnebinna': ('bjørnebinne',),
'bjørnebinne': ('bjørnebinne',),
'bjørnebinnen': ('bjørnebinne',),
'bjørnebinnene': ('bjørnebinne',),
'bjørnebinner': ('bjørnebinne',),
'bjørnebær': ('bjørnebær',),
'bjørnebæra': ('bjørnebær',),
'bjørnebærene': ('bjørnebær',),
'bjørnebæret': ('bjørnebær',),
'bjørnegrav': ('bjørnegrav',),
'bjørnegrava': ('bjørnegrav',),
'bjørnegraven': ('bjørnegrav',),
'bjørnegravene': ('bjørnegrav',),
'bjørnegraver': ('bjørnegrav',),
'bjørnehi': ('bjørnehi',),
'bjørnehia': ('bjørnehi',),
'bjørnehiene': ('bjørnehi',),
'bjørnehiet': ('bjørnehi',),
'bjørnekam': ('bjørnekam',),
'bjørnekammen': ('bjørnekam',),
'bjørnekammene': ('bjørnekam',),
'bjørnekammer': ('bjørnekam',),
'bjørnekjeks': ('bjørnekjeks',),
'bjørnekjeksen': ('bjørnekjeks',),
'bjørnekjeksene': ('bjørnekjeks',),
'bjørnekjekser': ('bjørnekjeks',),
'bjørneklo': ('bjørneklo',),
'bjørnekloa': ('bjørneklo',),
'bjørnekloen': ('bjørneklo',),
'bjørneklør': ('bjørneklo',),
'bjørneklørne': ('bjørneklo',),
'bjørnemose': ('bjørnemose',),
'bjørnemosen': ('bjørnemose',),
'bjørnemosene': ('bjørnemose',),
'bjørnemoser': ('bjørnemose',),
'bjørneskinn': ('bjørneskinn',),
'bjørneskinna': ('bjørneskinn',),
'bjørneskinnene': ('bjørneskinn',),
'bjørneskinnet': ('bjørneskinn',),
'bjørneskinnslua': ('bjørneskinnslue',),
'bjørneskinnslue': ('bjørneskinnslue',),
'bjørneskinnsluen': ('bjørneskinnslue',),
'bjørneskinnsluene': ('bjørneskinnslue',),
'bjørneskinnsluer': ('bjørneskinnslue',),
'bjørneskinnsluva': ('bjørneskinnsluve',),
'bjørneskinnsluve': ('bjørneskinnsluve',),
'bjørneskinnsluven': ('bjørneskinnsluve',),
'bjørneskinnsluvene': ('bjørneskinnsluve',),
'bjørneskinnsluver': ('bjørneskinnsluve',),
'bjørnestamme': ('bjørnestamme',),
'bjørnestammen': ('bjørnestamme',),
'bjørnestammene': ('bjørnestamme',),
'bjørnestammer': ('bjørnestamme',),
'bjørnetjeneste': ('bjørnetjeneste',),
'bjørnetjenesten': ('bjørnetjeneste',),
'bjørnetjenestene': ('bjørnetjeneste',),
'bjørnetjenester': ('bjørnetjeneste',),
'bjørnunge': ('bjørnunge',),
'bjørnungen': ('bjørnunge',),
'bjørnungene': ('bjørnunge',),
'bjørnunger': ('bjørnunge',),
'bla-bla': ('bla-bla',),
'bla-blaa': ('bla-bla',),
'bla-blaene': ('bla-bla',),
'bla-blaet': ('bla-bla',),
'blackout': ('blackout',),
'blackouten': ('blackout',),
'blackoutene': ('blackout',),
'blackouter': ('blackout',),
'blad': ('blad',),
'blada': ('blad',),
'bladene': ('blad',),
'blader': ('blad',),
'bladet': ('blad',),
'bladan': ('bladan',),
'bladana': ('bladan',),
'bladanene': ('bladan',),
'bladanet': ('bladan',),
'bladbille': ('bladbille',),
'bladbillen': ('bladbille',),
'bladbillene': ('bladbille',),
'bladbiller': ('bladbille',),
'bladekspedisjon': ('bladekspedisjon',),
'bladekspedisjonen': ('bladekspedisjon',),
'bladekspedisjonene': ('bladekspedisjon',),
'bladekspedisjoner': ('bladekspedisjon',),
'bladfot': ('bladfot',),
'bladfoten': ('bladfot',),
'bladføttene': ('bladfot',),
'bladføtter': ('bladfot',),
'bladgrønt': ('bladgrønt',),
'bladgull': ('bladgull',),
'bladgulla': ('bladgull',),
'bladgullene': ('bladgull',),
'bladgullet': ('bladgull',),
'bladkjeller': ('bladkjeller',),
'bladkjellere': ('bladkjeller',),
'bladkjelleren': ('bladkjeller',),
'bladkjellerer': ('bladkjeller',),
'bladkjellerne': ('bladkjeller',),
'bladkjøtt': ('bladkjøtt',),
'bladkjøtta': ('bladkjøtt',),
'bladkjøttene': ('bladkjøtt',),
'bladkjøttet': ('bladkjøtt',),
'bladlus': ('bladlus',),
'bladlusa': ('bladlus',),
'bladlusen': ('bladlus',),
'bladlusene': ('bladlus',),
'bladmage': ('bladmage',),
'bladmagen': ('bladmage',),
'bladmagene': ('bladmage',),
'bladmager': ('bladmage',),
'bladmave': ('bladmave',),
'bladmaven': ('bladmave',),
'bladmavene': ('bladmave',),
'bladmaver': ('bladmave',),
'bladmetall': ('bladmetall',),
'bladmetalla': ('bladmetall',),
'bladmetallene': ('bladmetall',),
'bladmetaller': ('bladmetall',),
'bladmetallet': ('bladmetall',),
'bladnerve': ('bladnerve',),
'bladnerven': ('bladnerve',),
'bladnervene': ('bladnerve',),
'bladnerver': ('bladnerve',),
'bladsalat': ('bladsalat',),
'bladsalaten': ('bladsalat',),
'bladsalatene': ('bladsalat',),
'bladsalater': ('bladsalat',),
'bladskjede': ('bladskjede',),
'bladskjeden': ('bladskjede',),
'bladskjedene': ('bladskjede',),
'bladskjeder': ('bladskjede',),
'bladslir': ('bladslir',),
'bladslira': ('bladslir',),
'bladsliren': ('bladslir',),
'bladslirene': ('bladslir',),
'bladslirer': ('bladslir',),
'bladslira': ('bladslire',),
'bladslire': ('bladslire',),
'bladsliren': ('bladslire',),
'bladslirene': ('bladslire',),
'bladslirer': ('bladslire',),
'bladstilk': ('bladstilk',),
'bladstilken': ('bladstilk',),
'bladstilkene': ('bladstilk',),
'bladstilker': ('bladstilk',),
'bladsølv': ('bladsølv',),
'bladsølva': ('bladsølv',),
'bladsølvene': ('bladsølv',),
'bladsølvet': ('bladsølv',),
'bladtobakk': ('bladtobakk',),
'bladtobakken': ('bladtobakk',),
'bladtobakkene': ('bladtobakk',),
'bladtobakker': ('bladtobakk',),
'bladvott': ('bladvott',),
'bladvotten': ('bladvott',),
'bladvottene': ('bladvott',),
'bladvotter': ('bladvott',),
'blaff': ('blaff',),
'blaffen': ('blaff',),
'blaffene': ('blaff',),
'blaffer': ('blaff',),
'blaff': ('blaff',),
'blaffa': ('blaff',),
'blaffene': ('blaff',),
'blaffet': ('blaff',),
'blakkert': ('blakkert',),
'blakkerten': ('blakkert',),
'blakkertene': ('blakkert',),
'blakkerter': ('blakkert',),
'blamasje': ('blamasje',),
'blamasjen': ('blamasje',),
'blamasjene': ('blamasje',),
'blamasjer': ('blamasje',),
'blanda': ('blande',),
'blande': ('blande',),
'blanden': ('blande',),
'blandene': ('blande',),
'blander': ('blande',),
'blandeapparat': ('blandeapparat',),
'blandeapparata': ('blandeapparat',),
'blandeapparatene': ('blandeapparat',),
'blandeapparater': ('blandeapparat',),
'blandeapparatet': ('blandeapparat',),
'blandebatteri': ('blandebatteri',),
'blandebatteria': ('blandebatteri',),
'blandebatteriene': ('blandebatteri',),
'blandebatterier': ('blandebatteri',),
'blandebatteriet': ('blandebatteri',),
'blandemaskin': ('blandemaskin',),
'blandemaskina': ('blandemaskin',),
'blandemaskinen': ('blandemaskin',),
'blandemaskinene': ('blandemaskin',),
'blandemaskiner': ('blandemaskin',),
'blander': ('blander',),
'blandere': ('blander',),
'blanderen': ('blander',),
'blanderer': ('blander',),
'blanderne': ('blander',),
'blandevann': ('blandevann',),
'blandevanna': ('blandevann',),
'blandevannene': ('blandevann',),
'blandevannet': ('blandevann',),
'blandevatn': ('blandevatn',),
'blandevatna': ('blandevatn',),
'blandevatnene': ('blandevatn',),
'blandevatnet': ('blandevatn',),
'blandfrø': ('blandfrø',),
'blandfrøa': ('blandfrø',),
'blandfrøene': ('blandfrø',),
'blandfrøet': ('blandfrø',),
'blanding': ('blanding',),
'blandinga': ('blanding',),
'blandingen': ('blanding',),
'blandingene': ('blanding',),
'blandinger': ('blanding',),
'blandingsdrikk': ('blandingsdrikk',),
'blandingsdrikken': ('blandingsdrikk',),
'blandingsdrikkene': ('blandingsdrikk',),
'blandingsdrikker': ('blandingsdrikk',),
'blandingsfarge': ('blandingsfarge',),
'blandingsfargen': ('blandingsfarge',),
'blandingsfargene': ('blandingsfarge',),
'blandingsfarger': ('blandingsfarge',),
'blandingsfolk': ('blandingsfolk',),
'blandingsfolka': ('blandingsfolk',),
'blandingsfolkene': ('blandingsfolk',),
'blandingsfolket': ('blandingsfolk',),
'blandingsforhold': ('blandingsforhold',),
'blandingsforholda': ('blandingsforhold',),
'blandingsforholdene': ('blandingsforhold',),
'blandingsforholdet': ('blandingsforhold',),
'blandingsføra': ('blandingsføre',),
'blandingsføre': ('blandingsføre',),
'blandingsførene': ('blandingsføre',),
'blandingsfører': ('blandingsføre',),
'blandingsføret': ('blandingsføre',),
'blandingsrase': ('blandingsrase',),
'blandingsrasen': ('blandingsrase',),
'blandingsrasene': ('blandingsrase',),
'blandingsraser': ('blandingsrase',),
'blandingsskog': ('blandingsskog',),
'blandingsskogen': ('blandingsskog',),
'blandingsskogene': ('blandingsskog',),
'blandingsskoger': ('blandingsskog',),
'blandingsspråk': ('blandingsspråk',),
'blandingsspråka': ('blandingsspråk',),
'blandingsspråkene': ('blandingsspråk',),
'blandingsspråket': ('blandingsspråk',),
'blandingsøkonomi': ('blandingsøkonomi',),
'blandingsøkonomien': ('blandingsøkonomi',),
'blandingsøkonomiene': ('blandingsøkonomi',),
'blandingsøkonomier': ('blandingsøkonomi',),
'blandkorn': ('blandkorn',),
'blandkorna': ('blandkorn',),
'blandkornene': ('blandkorn',),
'blandkornet': ('blandkorn',),
'blankett': ('blankett',),
'blanketten': ('blankett',),
'blankettene': ('blankett',),
'blanketter': ('blankett',),
'blankis': ('blankis',),
'blankisen': ('blankis',),
'blankisene': ('blankis',),
'blankiser': ('blankis',),
'blanklaks': ('blanklaks',),
'blanklaksen': ('blanklaks',),
'blanklaksene': ('blanklaks',),
'blanklakser': ('blanklaks',),
'blankoaksept': ('blankoaksept',),
'blankoaksepten': ('blankoaksept',),
'blankoakseptene': ('blankoaksept',),
'blankoaksepter': ('blankoaksept',),
'blankofullmakt': ('blankofullmakt',),
'blankofullmakta': ('blankofullmakt',),
'blankofullmakten': ('blankofullmakt',),
'blankofullmaktene': ('blankofullmakt',),
'blankofullmakter': ('blankofullmakt',),
'blankokreditt': ('blankokreditt',),
'blankokreditten': ('blankokreditt',),
'blankokredittene': ('blankokreditt',),
'blankokreditter': ('blankokreditt',),
'blankolån': ('blankolån',),
'blankolåna': ('blankolån',),
'blankolånene': ('blankolån',),
'blankolånet': ('blankolån',),
'blankoveksel': ('blankoveksel',),
'blankovekselen': ('blankoveksel',),
'blankovekslene': ('blankoveksel',),
'blankoveksler': ('blankoveksel',),
'blankvers': ('blankvers',),
'blankversa': ('blankvers',),
'blankversene': ('blankvers',),
'blankverset': ('blankvers',),
'blankål': ('blankål',),
'blankålen': ('blankål',),
'blankålene': ('blankål',),
'blankåler': ('blankål',),
'blasfemi': ('blasfemi',),
'blasfemien': ('blasfemi',),
'blasfemiene': ('blasfemi',),
'blasfemier': ('blasfemi',),
'blason': ('blason',),
'blasonen': ('blason',),
'blasonene': ('blason',),
'blasoner': ('blason',),
'blastula': ('blastula',),
'blastulaen': ('blastula',),
'blastulaene': ('blastula',),
'blastulaer': ('blastula',),
'blastulastadia': ('blastulastadium',),
'blastulastadiene': ('blastulastadium',),
'blastulastadier': ('blastulastadium',),
'blastulastadiet': ('blastulastadium',),
'blastulastadium': ('blastulastadium',),
'blautdyr': ('blautdyr',),
'blautdyra': ('blautdyr',),
'blautdyrene': ('blautdyr',),
'blautdyret': ('blautdyr',),
'blautfisk': ('blautfisk',),
'blautfisken': ('blautfisk',),
'blautfiskene': ('blautfisk',),
'blautfisker': ('blautfisk',),
'blautkaka': ('blautkake',),
'blautkake': ('blautkake',),
'blautkaken': ('blautkake',),
'blautkakene': ('blautkake',),
'blautkaker': ('blautkake',),
'blautmyr': ('blautmyr',),
'blautmyra': ('blautmyr',),
'blautmyren': ('blautmyr',),
'blautmyrene': ('blautmyr',),
'blautmyrer': ('blautmyr',),
'blautråte': ('blautråte',),
'blautråten': ('blautråte',),
'blautråtene': ('blautråte',),
'blautråter': ('blautråte',),
'blautskilpadda': ('blautskilpadde',),
'blautskilpadde': ('blautskilpadde',),
'blautskilpadden': ('blautskilpadde',),
'blautskilpaddene': ('blautskilpadde',),
'blautskilpadder': ('blautskilpadde',),
'blei': ('blei',),
'bleien': ('blei',),
'bleiene': ('blei',),
'bleier': ('blei',),
'blei': ('blei',),
'bleien': ('blei',),
'bleiene': ('blei',),
'bleier': ('blei',),
'bleia': ('bleie',),
'bleie': ('bleie',),
'bleien': ('bleie',),
'bleiene': ('bleie',),
'bleier': ('bleie',),
'bleiebarn': ('bleiebarn',),
'bleiebarna': ('bleiebarn',),
'bleiebarnene': ('bleiebarn',),
'bleiebarnet': ('bleiebarn',),
'bleievask': ('bleievask',),
'bleievasken': ('bleievask',),
'bleievaskene': ('bleievask',),
'bleievasker': ('bleievask',),
'bleig': ('bleig',),
'bleigen': ('bleig',),
'bleigene': ('bleig',),
'bleiger': ('bleig',),
'bleik': ('bleik',),
'bleika': ('bleik',),
'bleiken': ('bleik',),
'bleikene': ('bleik',),
'bleiker': ('bleik',),
'bleikansikt': ('bleikansikt',),
'bleikansikta': ('bleikansikt',),
'bleikansiktene': ('bleikansikt',),
'bleikansikter': ('bleikansikt',),
'bleikansiktet': ('bleikansikt',),
'bleika': ('bleike',),
'bleike': ('bleike',),
'bleiken': ('bleike',),
'bleikene': ('bleike',),
'bleiker': ('bleike',),
'bleikemiddel': ('bleikemiddel',),
'bleikemiddelet': ('bleikemiddel',),
'bleikemidla': ('bleikemiddel',),
'bleikemidlene': ('bleikemiddel',),
'bleikemidler': ('bleikemiddel',),
'bleikemidlet': ('bleikemiddel',),
'bleikevoll': ('bleikevoll',),
'bleikevollen': ('bleikevoll',),
'bleikevollene': ('bleikevoll',),
'bleikevoller': ('bleikevoll',),
'bleikfis': ('bleikfis',),
'bleikfisen': ('bleikfis',),
'bleikfisene': ('bleikfis',),
'bleikfiser': ('bleikfis',),
'bleikfjes': ('bleikfjes',),
'bleikfjesa': ('bleikfjes',),
'bleikfjesene': ('bleikfjes',),
'bleikfjeset': ('bleikfjes',),
'bleikjord': ('bleikjord',),
'bleikjorda': ('bleikjord',),
'bleikjorden': ('bleikjord',),
'bleikjordene': ('bleikjord',),
'bleikjorder': ('bleikjord',),
'bleiknebb': ('bleiknebb',),
'bleiknebba': ('bleiknebb',),
'bleiknebben': ('bleiknebb',),
'bleiknebbene': ('bleiknebb',),
'bleiknebbet': ('bleiknebb',),
'blekansikt': ('blekansikt',),
'blekansikta': ('blekansikt',),
'blekansiktene': ('blekansikt',),
'blekansikter': ('blekansikt',),
'blekansiktet': ('blekansikt',),
'blekemiddel': ('blekemiddel',),
'blekemiddelet': ('blekemiddel',),
'blekemidla': ('blekemiddel',),
'blekemidlene': ('blekemiddel',),
'blekemidler': ('blekemiddel',),
'blekemidlet': ('blekemiddel',),
'blekevoll': ('blekevoll',),
'blekevollen': ('blekevoll',),
'blekevollene': ('blekevoll',),
'blekevoller': ('blekevoll',),
'blekk': ('blekk',),
'blekka': ('blekk',),
'blekkene': ('blekk',),
'blekket': ('blekk',),
'blekk': ('blekk',),
'blekka': ('blekk',),
'blekkene': ('blekk',),
'blekket': ('blekk',),
'blekk': ('blekk',),
'blekka': ('blekk',),
'blekkene': ('blekk',),
'blekket': ('blekk',),
'blekk-kjertel': ('blekk-kjertel',),
'blekk-kjertelen': ('blekk-kjertel',),
'blekk-kjertlene': ('blekk-kjertel',),
'blekk-kjertler': ('blekk-kjertel',),
'blekk-klatt': ('blekk-klatt',),
'blekk-klatten': ('blekk-klatt',),
'blekk-klattene': ('blekk-klatt',),
'blekk-klatter': ('blekk-klatt',),
'blekk-kopp': ('blekk-kopp',),
'blekk-koppen': ('blekk-kopp',),
'blekk-koppene': ('blekk-kopp',),
'blekk-kopper': ('blekk-kopp',),
'blekk-kopp': ('blekk-kopp',),
'blekk-koppen': ('blekk-kopp',),
'blekk-koppene': ('blekk-kopp',),
'blekk-kopper': ('blekk-kopp',),
'blekkboks': ('blekkboks',),
'blekkboksen': ('blekkboks',),
'blekkboksene': ('blekkboks',),
'blekkbokser': ('blekkboks',),
'blekkdåse': ('blekkdåse',),
'blekkdåsen': ('blekkdåse',),
'blekkdåsene': ('blekkdåse',),
'blekkdåser': ('blekkdåse',),
'blekkdåse': ('blekkdåse',),
'blekkdåsen': ('blekkdåse',),
'blekkdåsene': ('blekkdåse',),
'blekkdåser': ('blekkdåse',),
'blekka': ('blekke',),
'blekke': ('blekke',),
'blekken': ('blekke',),
'blekkene': ('blekke',),
'blekker': ('blekke',),
'blekkflekk': ('blekkflekk',),
'blekkflekken': ('blekkflekk',),
'blekkflekkene': ('blekkflekk',),
'blekkflekker': ('blekkflekk',),
'blekkhus': ('blekkhus',),
'blekkhusa': ('blekkhus',),
'blekkhusene': ('blekkhus',),
'blekkhuset': ('blekkhus',),
'blekkjertel': ('blekkjertel',),
'blekkjertelen': ('blekkjertel',),
'blekkjertlene': ('blekkjertel',),
'blekkjertler': ('blekkjertel',),
'blekklatt': ('blekklatt',),
'blekklatten': ('blekklatt',),
'blekklattene': ('blekklatt',),
'blekklatter': ('blekklatt',),
'blekkopp': ('blekkopp',),
'blekkoppen': ('blekkopp',),
'blekkoppene': ('blekkopp',),
'blekkopper': ('blekkopp',),
'blekkopp': ('blekkopp',),
'blekkoppen': ('blekkopp',),
'blekkoppene': ('blekkopp',),
'blekkopper': ('blekkopp',),
'blekkplata': ('blekkplate',),
'blekkplate': ('blekkplate',),
'blekkplaten': ('blekkplate',),
'blekkplatene': ('blekkplate',),
'blekkplater': ('blekkplate',),
'blekkplata': ('blekkplate',),
'blekkplate': ('blekkplate',),
'blekkplaten': ('blekkplate',),
'blekkplatene': ('blekkplate',),
'blekkplater': ('blekkplate',),
'blekkslager': ('blekkslager',),
'blekkslagere': ('blekkslager',),
'blekkslageren': ('blekkslager',),
'blekkslagerer': ('blekkslager',),
'blekkslagerne': ('blekkslager',),
'blekkslager': ('blekkslager',),
'blekkslagere': ('blekkslager',),
'blekkslageren': ('blekkslager',),
'blekkslagerer': ('blekkslager',),
'blekkslagerne': ('blekkslager',),
'blekkslagerverksted': ('blekkslagerverksted',),
'blekkslagerverkstedene': ('blekkslagerverksted',),
'blekkslagerverksteder': ('blekkslagerverksted',),
'blekkslagerverkstedet': ('blekkslagerverksted',),
'blekkslagerverksted': ('blekkslagerverksted',),
'blekkslagerverkstedene': ('blekkslagerverksted',),
'blekkslagerverksteder': ('blekkslagerverksted',),
'blekkslagerverkstedet': ('blekkslagerverksted',),
'blekkspann': ('blekkspann',),
'blekkspanna': ('blekkspann',),
'blekkspannene': ('blekkspann',),
'blekkspannet': ('blekkspann',),
'blekkspann': ('blekkspann',),
'blekkspanna': ('blekkspann',),
'blekkspannene': ('blekkspann',),
'blekkspannet': ('blekkspann',),
'blekksprut': ('blekksprut',),
'blekkspruten': ('blekksprut',),
'blekksprutene': ('blekksprut',),
'blekkspruter': ('blekksprut',),
'blekkvara': ('blekkvare',),
'blekkvare': ('blekkvare',),
'blekkvaren': ('blekkvare',),
'blekkvarene': ('blekkvare',),
'blekkvarer': ('blekkvare',),
'blekkvara': ('blekkvare',),
'blekkvare': ('blekkvare',),
'blekkvaren': ('blekkvare',),
'blekkvarene': ('blekkvare',),
'blekkvarer': ('blekkvare',),
'blekkviskelær': ('blekkviskelær',),
'blekkviskelæra': ('blekkviskelær',),
'blekkviskelærene': ('blekkviskelær',),
'blekkviskelæret': ('blekkviskelær',),
'bleknebb': ('bleknebb',),
'bleknebba': ('bleknebb',),
'bleknebben': ('bleknebb',),
'bleknebbene': ('bleknebb',),
'bleknebbet': ('bleknebb',),
'blemma': ('blemme',),
'blemme': ('blemme',),
'blemmen': ('blemme',),
'blemmene': ('blemme',),
'blemmer': ('blemme',),
'blemmestål': ('blemmestål',),
'blemmeståla': ('blemmestål',),
'blemmestålene': ('blemmestål',),
'blemmestålet': ('blemmestål',),
'blende': ('blende',),
'blenden': ('blende',),
'blendene': ('blende',),
'blender': ('blende',),
'blender': ('blender',),
'blendere': ('blender',),
'blenderen': ('blender',),
'blenderer': ('blender',),
'blenderne': ('blender',),
'blendering': ('blendering',),
'blenderinga': ('blendering',),
'blenderingen': ('blendering',),
'blenderingene': ('blendering',),
'blenderinger': ('blendering',),
'blenderinnstilling': ('blenderinnstilling',),
'blenderinnstillinga': ('blenderinnstilling',),
'blenderinnstillingen': ('blenderinnstilling',),
'blenderinnstillingene': ('blenderinnstilling',),
'blenderinnstillinger': ('blenderinnstilling',),
'blenderåpning': ('blenderåpning',),
'blenderåpninga': ('blenderåpning',),
'blenderåpningen': ('blenderåpning',),
'blenderåpningene': ('blenderåpning',),
'blenderåpninger': ('blenderåpning',),
'blending': ('blending',),
'blendinga': ('blending',),
'blendingen': ('blending',),
'blendingene': ('blending',),
'blendinger': ('blending',),
'blendingsgardin': ('blendingsgardin',),
'blendingsgardina': ('blendingsgardin',),
'blendingsgardinen': ('blendingsgardin',),
'blendingsgardinene': ('blendingsgardin',),
'blendingsgardiner': ('blendingsgardin',),
'blendingsgardinet': ('blendingsgardin',),
'blendverk': ('blendverk',),
'blendverka': ('blendverk',),
'blendverkene': ('blendverk',),
'blendverket': ('blendverk',),
'bles': ('bles',),
'blesa': ('bles',),
'blesene': ('bles',),
'bleset': ('bles',),
'blesand': ('blesand',),
'blesanda': ('blesand',),
'blesanden': ('blesand',),
'blesendene': ('blesand',),
'blesender': ('blesand',),
'blest': ('blest',),
'blesten': ('blest',),
'blestene': ('blest',),
'blester': ('blest',),
'blestsjef': ('blestsjef',),
'blestsjefen': ('blestsjef',),
'blestsjefene': ('blestsjef',),
'blestsjefer': ('blestsjef',),
'blikk-kopp': ('blikk-kopp',),
'blikk-koppen': ('blikk-kopp',),
'blikk-koppene': ('blikk-kopp',),
'blikk-kopper': ('blikk-kopp',),
'blikk-kopp': ('blikk-kopp',),
'blikk-koppen': ('blikk-kopp',),
'blikk-koppene': ('blikk-kopp',),
'blikk-kopper': ('blikk-kopp',),
'blikkboks': ('blikkboks',),
'blikkboksen': ('blikkboks',),
'blikkboksene': ('blikkboks',),
'blikkbokser': ('blikkboks',),
'blikkdåsa': ('blikkdåse',),
'blikkdåse': ('blikkdåse',),
'blikkdåsen': ('blikkdåse',),
'blikkdåsene': ('blikkdåse',),
'blikkdåser': ('blikkdåse',),
'blikkdåsa': ('blikkdåse',),
'blikkdåse': ('blikkdåse',),
'blikkdåsen': ('blikkdåse',),
'blikkdåsene': ('blikkdåse',),
'blikkdåser': ('blikkdåse',),
'blikkenslager': ('blikkenslager',),
'blikkenslagere': ('blikkenslager',),
'blikkenslageren': ('blikkenslager',),
'blikkenslagerer': ('blikkenslager',),
'blikkenslagerne': ('blikkenslager',),
'blikkenslager': ('blikkenslager',),
'blikkenslagere': ('blikkenslager',),
'blikkenslageren': ('blikkenslager',),
'blikkenslagerer': ('blikkenslager',),
'blikkenslagerne': ('blikkenslager',),
'blikkenslagerverksted': ('blikkenslagerverksted',),
'blikkenslagerverkstedene': ('blikkenslagerverksted',),
'blikkenslagerverksteder': ('blikkenslagerverksted',),
'blikkenslagerverkstedet': ('blikkenslagerverksted',),
'blikkenslagerverksted': ('blikkenslagerverksted',),
'blikkenslagerverkstedene': ('blikkenslagerverksted',),
'blikkenslagerverksteder': ('blikkenslagerverksted',),
'blikkenslagerverkstedet': ('blikkenslagerverksted',),
'blikkfang': ('blikkfang',),
'blikkfanga': ('blikkfang',),
'blikkfangene': ('blikkfang',),
'blikkfanget': ('blikkfang',),
'blikkopp': ('blikkopp',),
'blikkoppen': ('blikkopp',),
'blikkoppene': ('blikkopp',),
'blikkopper': ('blikkopp',),
'blikkopp': ('blikkopp',),
'blikkoppen': ('blikkopp',),
'blikkoppene': ('blikkopp',),
'blikkopper': ('blikkopp',),
'blikkplata': ('blikkplate',),
'blikkplate': ('blikkplate',),
'blikkplaten': ('blikkplate',),
'blikkplatene': ('blikkplate',),
'blikkplater': ('blikkplate',),
'blikkplata': ('blikkplate',),
'blikkplate': ('blikkplate',),
'blikkplaten': ('blikkplate',),
'blikkplatene': ('blikkplate',),
'blikkplater': ('blikkplate',),
'blikkslager': ('blikkslager',),
'blikkslagere': ('blikkslager',),
'blikkslageren': ('blikkslager',),
'blikkslagerer': ('blikkslager',),
'blikkslagerne': ('blikkslager',),
'blikkslager': ('blikkslager',),
'blikkslagere': ('blikkslager',),
'blikkslageren': ('blikkslager',),
'blikkslagerer': ('blikkslager',),
'blikkslagerne': ('blikkslager',),
'blikkslagerverksted': ('blikkslagerverksted',),
'blikkslagerverkstedene': ('blikkslagerverksted',),
'blikkslagerverksteder': ('blikkslagerverksted',),
'blikkslagerverkstedet': ('blikkslagerverksted',),
'blikkslagerverksted': ('blikkslagerverksted',),
'blikkslagerverkstedene': ('blikkslagerverksted',),
'blikkslagerverksteder': ('blikkslagerverksted',),
'blikkslagerverkstedet': ('blikkslagerverksted',),
'blikkspann': ('blikkspann',),
'blikkspanna': ('blikkspann',),
'blikkspannene': ('blikkspann',),
'blikkspannet': ('blikkspann',),
'blikkspann': ('blikkspann',),
'blikkspanna': ('blikkspann',),
'blikkspannene': ('blikkspann',),
'blikkspannet': ('blikkspann',),
'blikkvara': ('blikkvare',),
'blikkvare': ('blikkvare',),
'blikkvaren': ('blikkvare',),
'blikkvarene': ('blikkvare',),
'blikkvarer': ('blikkvare',),
'blikkvara': ('blikkvare',),
'blikkvare': ('blikkvare',),
'blikkvaren': ('blikkvare',),
'blikkvarene': ('blikkvare',),
'blikkvarer': ('blikkvare',),
'blinda': ('blinde',),
'blinde': ('blinde',),
'blinden': ('blinde',),
'blindene': ('blinde',),
'blinder': ('blinde',),
'blindealfabet': ('blindealfabet',),
'blindealfabeta': ('blindealfabet',),
'blindealfabetene': ('blindealfabet',),
'blindealfabeter': ('blindealfabet',),
'blindealfabetet': ('blindealfabet',),
'blindebukk': ('blindebukk',),
'blindebukken': ('blindebukk',),
'blindebukkene': ('blindebukk',),
'blindebukker': ('blindebukk',),
'blindeforbund': ('blindeforbund',),
'blindeforbunda': ('blindeforbund',),
'blindeforbundene': ('blindeforbund',),
'blindeforbundet': ('blindeforbund',),
'blindeførerhund': ('blindeførerhund',),
'blindeførerhunden': ('blindeførerhund',),
'blindeførerhundene': ('blindeførerhund',),
'blindeførerhunder': ('blindeførerhund',),
'blindemann': ('blindemann',),
'blindemannen': ('blindemann',),
'blindemenn': ('blindemann',),
'blindemennene': ('blindemann',),
'blindesak': ('blindesak',),
'blindesaka': ('blindesak',),
'blindesaken': ('blindesak',),
'blindesakene': ('blindesak',),
'blindesaker': ('blindesak',),
'blindeskole': ('blindeskole',),
'blindeskolen': ('blindeskole',),
'blindeskolene': ('blindeskole',),
'blindeskoler': ('blindeskole',),
'blindeskrift': ('blindeskrift',),
'blindeskrifta': ('blindeskrift',),
'blindeskriften': ('blindeskrift',),
'blindeskriftene': ('blindeskrift',),
'blindeskrifter': ('blindeskrift',),
'blindflyging': ('blindflyging',),
'blindflyginga': ('blindflyging',),
'blindflygingen': ('blindflyging',),
'blindflygingene': ('blindflyging',),
'blindflyginger': ('blindflyging',),
'blindflying': ('blindflying',),
'blindflyinga': ('blindflying',),
'blindflyingen': ('blindflying',),
'blindflyingene': ('blindflying',),
'blindflyinger': ('blindflying',),
'blindgata': ('blindgate',),
'blindgate': ('blindgate',),
'blindgaten': ('blindgate',),
'blindgatene': ('blindgate',),
'blindgater': ('blindgate',),
'blindgjenger': ('blindgjenger',),
'blindgjengere': ('blindgjenger',),
'blindgjengeren': ('blindgjenger',),
'blindgjengerer': ('blindgjenger',),
'blindgjengerne': ('blindgjenger',),
'blindhet': ('blindhet',),
'blindheta': ('blindhet',),
'blindheten': ('blindhet',),
'blindhetene': ('blindhet',),
'blindheter': ('blindhet',),
'blinding': ('blinding',),
'blindingen': ('blinding',),
'blindingene': ('blinding',),
'blindinger': ('blinding',),
'blinding': ('blinding',),
'blindingen': ('blinding',),
'blindingene': ('blinding',),
'blindinger': ('blinding',),
'blindklegg': ('blindklegg',),
'blindkleggen': ('blindklegg',),
'blindkleggene': ('blindklegg',),
'blindklegger': ('blindklegg',),
'blindlanding': ('blindlanding',),
'blindlandinga': ('blindlanding',),
'blindlandingen': ('blindlanding',),
'blindlandingene': ('blindlanding',),
'blindlandinger': ('blindlanding',),
'blindnagle': ('blindnagle',),
'blindnaglen': ('blindnagle',),
'blindnaglene': ('blindnagle',),
'blindnagler': ('blindnagle',),
'blindpassasjer': ('blindpassasjer',),
'blindpassasjeren': ('blindpassasjer',),
'blindpassasjerene': ('blindpassasjer',),
'blindpassasjerer': ('blindpassasjer',),
'blindramma': ('blindramme',),
'blindramme': ('blindramme',),
'blindrammen': ('blindramme',),
'blindrammene': ('blindramme',),
'blindrammer': ('blindramme',),
'blindskjær': ('blindskjær',),
'blindskjæra': ('blindskjær',),
'blindskjærene': ('blindskjær',),
'blindskjæret': ('blindskjær',),
'blindspor': ('blindspor',),
'blindspora': ('blindspor',),
'blindsporene': ('blindspor',),
'blindsporet': ('blindspor',),
'blindtarm': ('blindtarm',),
'blindtarmen': ('blindtarm',),
'blindtarmene': ('blindtarm',),
'blindtarmer': ('blindtarm',),
'blindtarmsbetennelse': ('blindtarmsbetennelse',),
'blindtarmsbetennelsen': ('blindtarmsbetennelse',),
'blindtarmsbetennelsene': ('blindtarmsbetennelse',),
'blindtarmsbetennelser': ('blindtarmsbetennelse',),
'blindtarmsvedheng': ('blindtarmsvedheng',),
'blindtarmsvedhenga': ('blindtarmsvedheng',),
'blindtarmsvedhengene': ('blindtarmsvedheng',),
'blindtarmsvedhenget': ('blindtarmsvedheng',),
'blindveg': ('blindveg',),
'blindvegen': ('blindveg',),
'blindvegene': ('blindveg',),
'blindveger': ('blindveg',),
'blindvei': ('blindvei',),
'blindveien': ('blindvei',),
'blindveiene': ('blindvei',),
'blindveier': ('blindvei',),
'blings': ('blings',),
'blingsen': ('blings',),
'blingsene': ('blings',),
'blingser': ('blings',),
'blink': ('blink',),
'blinken': ('blink',),
'blinkene': ('blink',),
'blinker': ('blink',),
'blink': ('blink',),
'blinka': ('blink',),
'blinkene': ('blink',),
'blinket': ('blink',),
'blinkemerka': ('blinkemerke',),
'blinkemerke': ('blinkemerke',),
'blinkemerkene': ('blinkemerke',),
'blinkemerker': ('blinkemerke',),
'blinkemerket': ('blinkemerke',),
'blinkeøks': ('blinkeøks',),
'blinkeøksa': ('blinkeøks',),
'blinkeøksen': ('blinkeøks',),
'blinkeøksene': ('blinkeøks',),
'blinkeøkser': ('blinkeøks',),
'blinkfyr': ('blinkfyr',),
'blinkfyra': ('blinkfyr',),
'blinkfyrene': ('blinkfyr',),
'blinkfyret': ('blinkfyr',),
'blinklanterna': ('blinklanterne',),
'blinklanterne': ('blinklanterne',),
'blinklanternen': ('blinklanterne',),
'blinklanternene': ('blinklanterne',),
'blinklanterner': ('blinklanterne',),
'blinklys': ('blinklys',),
'blinklysa': ('blinklys',),
'blinklysene': ('blinklys',),
'blinklyset': ('blinklys',),
'blinkmerka': ('blinkmerke',),
'blinkmerke': ('blinkmerke',),
'blinkmerkene': ('blinkmerke',),
'blinkmerker': ('blinkmerke',),
'blinkmerket': ('blinkmerke',),
'blinkskott': ('blinkskott',),
'blinkskotta': ('blinkskott',),
'blinkskottene': ('blinkskott',),
'blinkskottet': ('blinkskott',),
'blinkskudd': ('blinkskudd',),
'blinkskudda': ('blinkskudd',),
'blinkskuddene': ('blinkskudd',),
'blinkskuddet': ('blinkskudd',),
'blinkøks': ('blinkøks',),
'blinkøksa': ('blinkøks',),
'blinkøksen': ('blinkøks',),
'blinkøksene': ('blinkøks',),
'blinkøkser': ('blinkøks',),
'blits': ('blits',),
'blitsen': ('blits',),
'blitsene': ('blits',),
'blitser': ('blits',),
'blitskrig': ('blitskrig',),
'blitskrigen': ('blitskrig',),
'blitskrigene': ('blitskrig',),
'blitskriger': ('blitskrig',),
'blitslampa': ('blitslampe',),
'blitslampe': ('blitslampe',),
'blitslampen': ('blitslampe',),
'blitslampene': ('blitslampe',),
'blitslamper': ('blitslampe',),
'blitslys': ('blitslys',),
'blitslysa': ('blitslys',),
'blitslysene': ('blitslys',),
'blitslyset': ('blitslys',),
'blod': ('blod',),
'bloda': ('blod',),
'blodene': ('blod',),
'blodet': ('blod',),
'blodansamling': ('blodansamling',),
'blodansamlinga': ('blodansamling',),
'blodansamlingen': ('blodansamling',),
'blodansamlingene': ('blodansamling',),
'blodansamlinger': ('blodansamling',),
'blodappelsin': ('blodappelsin',),
'blodappelsinen': ('blodappelsin',),
'blodappelsinene': ('blodappelsin',),
'blodappelsiner': ('blodappelsin',),
'blodbad': ('blodbad',),
'blodbada': ('blodbad',),
'blodbadene': ('blodbad',),
'blodbadet': ('blodbad',),
'blodbank': ('blodbank',),
'blodbanken': ('blodbank',),
'blodbankene': ('blodbank',),
'blodbanker': ('blodbank',),
'blodblemma': ('blodblemme',),
'blodblemme': ('blodblemme',),
'blodblemmen': ('blodblemme',),
'blodblemmene': ('blodblemme',),
'blodblemmer': ('blodblemme',),
'blodbok': ('blodbok',),
'blodboka': ('blodbok',),
'blodboken': ('blodbok',),
'blodbokene': ('blodbok',),
'blodboker': ('blodbok',),
'blodbøk': ('blodbøk',),
'blodbøken': ('blodbøk',),
'blodbøkene': ('blodbøk',),
'blodbøker': ('blodbøk',),
'blodcella': ('blodcelle',),
'blodcelle': ('blodcelle',),
'blodcellen': ('blodcelle',),
'blodcellene': ('blodcelle',),
'blodceller': ('blodcelle',),
'bloddoping': ('bloddoping',),
'bloddopinga': ('bloddoping',),
'bloddopingen': ('bloddoping',),
'bloddopingene': ('bloddoping',),
'bloddopinger': ('bloddoping',),
'bloddråpe': ('bloddråpe',),
'bloddråpen': ('bloddråpe',),
'bloddråpene': ('bloddråpe',),
'bloddråper': ('bloddråpe',),
'blodforgiftning': ('blodforgiftning',),
'blodforgiftninga': ('blodforgiftning',),
'blodforgiftningen': ('blodforgiftning',),
'blodforgiftningene': ('blodforgiftning',),
'blodforgiftninger': ('blodforgiftning',),
'blodgiver': ('blodgiver',),
'blodgivere': ('blodgiver',),
'blodgiveren': ('blodgiver',),
'blodgiverer': ('blodgiver',),
'blodgiverne': ('blodgiver',),
'blodgruppa': ('blodgruppe',),
'blodgruppe': ('blodgruppe',),
'blodgruppen': ('blodgruppe',),
'blodgruppene': ('blodgruppe',),
'blodgrupper': ('blodgruppe',),
'blodhevn': ('blodhevn',),
'blodhevnen': ('blodhevn',),
'blodhevnene': ('blodhevn',),
'blodhevner': ('blodhevn',),
'blodhund': ('blodhund',),
'blodhunden': ('blodhund',),
'blodhundene': ('blodhund',),
'blodhunder': ('blodhund',),
'blodigla': ('blodigle',),
'blodigle': ('blodigle',),
'blodiglen': ('blodigle',),
'blodiglene': ('blodigle',),
'blodigler': ('blodigle',),
'blodikte': ('blodikte',),
'blodikten': ('blodikte',),
'blodiktene': ('blodikte',),
'blodikter': ('blodikte',),
'blodkar': ('blodkar',),
'blodkara': ('blodkar',),
'blodkarene': ('blodkar',),
'blodkaret': ('blodkar',),
'blodkreft': ('blodkreft',),
'blodkreften': ('blodkreft',),
'blodkreftene': ('blodkreft',),
'blodkrefter': ('blodkreft',),
'blodlegema': ('blodlegeme',),
'blodlegeme': ('blodlegeme',),
'blodlegemene': ('blodlegeme',),
'blodlegemer': ('blodlegeme',),
'blodlegemet': ('blodlegeme',),
'blodmangel': ('blodmangel',),
'blodmangelen': ('blodmangel',),
'blodmanglene': ('blodmangel',),
'blodmangler': ('blodmangel',),
'blodmat': ('blodmat',),
'blodmaten': ('blodmat',),
'blodmatene': ('blodmat',),
'blodmater': ('blodmat',),
'blodomløp': ('blodomløp',),
'blodomløpa': ('blodomløp',),
'blodomløpene': ('blodomløp',),
'blodomløpet': ('blodomløp',),
'blodoverføring': ('blodoverføring',),
'blodoverføringa': ('blodoverføring',),
'blodoverføringen': ('blodoverføring',),
'blodoverføringene': ('blodoverføring',),
'blodoverføringer': ('blodoverføring',),
'blodpengene': ('blodpenger',),
'blodpenger': ('blodpenger',),
'blodpiss': ('blodpiss',),
'blodpissa': ('blodpiss',),
'blodpissene': ('blodpiss',),
'blodpisset': ('blodpiss',),
'blodplasma': ('blodplasma',),
'blodplasmaa': ('blodplasma',),
'blodplasmaene': ('blodplasma',),
'blodplasmaet': ('blodplasma',),
'blodplata': ('blodplate',),
'blodplate': ('blodplate',),
'blodplaten': ('blodplate',),
'blodplatene': ('blodplate',),
'blodplater': ('blodplate',),
'blodpris': ('blodpris',),
'blodprisen': ('blodpris',),
'blodprisene': ('blodpris',),
'blodpriser': ('blodpris',),
'blodpropp': ('blodpropp',),
'blodproppen': ('blodpropp',),
'blodproppene': ('blodpropp',),
'blodpropper': ('blodpropp',),
'blodprosent': ('blodprosent',),
'blodprosenten': ('blodprosent',),
'blodprosentene': ('blodprosent',),
'blodprosenter': ('blodprosent',),
'blodprøva': ('blodprøve',),
'blodprøve': ('blodprøve',),
'blodprøven': ('blodprøve',),
'blodprøvene': ('blodprøve',),
'blodprøver': ('blodprøve',),
'blodpudding': ('blodpudding',),
'blodpuddingen': ('blodpudding',),
'blodpuddingene': ('blodpudding',),
'blodpuddinger': ('blodpudding',),
'blodpøl': ('blodpøl',),
'blodpølen': ('blodpøl',),
'blodpølene': ('blodpøl',),
'blodpøler': ('blodpøl',),
'blodsband': ('blodsband',),
'blodsbanda': ('blodsband',),
'blodsbandene': ('blodsband',),
'blodsbandet': ('blodsband',),
'blodsbånd': ('blodsbånd',),
'blodsbånda': ('blodsbånd',),
'blodsbåndene': ('blodsbånd',),
'blodsbåndet': ('blodsbånd',),
'blodsdråpe': ('blodsdråpe',),
'blodsdråpen': ('blodsdråpe',),
'blodsdråpene': ('blodsdråpe',),
'blodsdråper': ('blodsdråpe',),
'blodsenkning': ('blodsenkning',),
'blodsenkninga': ('blodsenkning',),
'blodsenkningen': ('blodsenkning',),
'blodsenkningene': ('blodsenkning',),
'blodsenkninger': ('blodsenkning',),
'blodsera': ('blodserum',),
'blodseraene': ('blodserum',),
'blodserum': ('blodserum',),
'blodseruma': ('blodserum',),
'blodserumene': ('blodserum',),
'blodserumer': ('blodserum',),
'blodserumet': ('blodserum',),
'blodskam': ('blodskam',),
'blodskamma': ('blodskam',),
'blodskammen': ('blodskam',),
'blodskammene': ('blodskam',),
'blodskammer': ('blodskam',),
'blodslit': ('blodslit',),
'blodslita': ('blodslit',),
'blodslitene': ('blodslit',),
'blodslitet': ('blodslit',),
'blodsmak': ('blodsmak',),
'blodsmaken': ('blodsmak',),
'blodsmakene': ('blodsmak',),
'blodsmaker': ('blodsmak',),
'blodsprut': ('blodsprut',),
'blodspruten': ('blodsprut',),
'blodsprutene': ('blodsprut',),
'blodspruter': ('blodsprut',),
'blodstyrtning': ('blodstyrtning',),
'blodstyrtninga': ('blodstyrtning',),
'blodstyrtningen': ('blodstyrtning',),
'blodstyrtningene': ('blodstyrtning',),
'blodstyrtninger': ('blodstyrtning',),
'blodsuger': ('blodsuger',),
'blodsugere': ('blodsuger',),
'blodsugeren': ('blodsuger',),
'blodsugerer': ('blodsuger',),
'blodsugerne': ('blodsuger',),
'blodsutgytelse': ('blodsutgytelse',),
'blodsutgytelsen': ('blodsutgytelse',),
'blodsutgytelsene': ('blodsutgytelse',),
'blodsutgytelser': ('blodsutgytelse',),
'blodtap': ('blodtap',),
'blodtapa': ('blodtap',),
'blodtapene': ('blodtap',),
'blodtapet': ('blodtap',),
'blodtilførsel': ('blodtilførsel',),
'blodtilførselen': ('blodtilførsel',),
'blodtilførslene': ('blodtilførsel',),
'blodtilførsler': ('blodtilførsel',),
'blodtransfusjon': ('blodtransfusjon',),
'blodtransfusjonen': ('blodtransfusjon',),
'blodtransfusjonene': ('blodtransfusjon',),
'blodtransfusjoner': ('blodtransfusjon',),
'blodtrykk': ('blodtrykk',),
'blodtrykka': ('blodtrykk',),
'blodtrykkene': ('blodtrykk',),
'blodtrykket': ('blodtrykk',),
'blodtype': ('blodtype',),
'blodtypen': ('blodtype',),
'blodtypene': ('blodtype',),
'blodtyper': ('blodtype',),
'bloduttredelse': ('bloduttredelse',),
'bloduttredelsen': ('bloduttredelse',),
'bloduttredelsene': ('bloduttredelse',),
'bloduttredelser': ('bloduttredelse',),
'blodvitna': ('blodvitne',),
'blodvitne': ('blodvitne',),
'blodvitnene': ('blodvitne',),
'blodvitner': ('blodvitne',),
'blodvitnet': ('blodvitne',),
'blodvæska': ('blodvæske',),
'blodvæske': ('blodvæske',),
'blodvæsken': ('blodvæske',),
'blodvæskene': ('blodvæske',),
'blodvæsker': ('blodvæske',),
'blodåra': ('blodåre',),
'blodåre': ('blodåre',),
'blodåren': ('blodåre',),
'blodårene': ('blodåre',),
'blodårer': ('blodåre',),
'blokade': ('blokade',),
'blokaden': ('blokade',),
'blokadene': ('blokade',),
'blokader': ('blokade',),
'blokadebryter': ('blokadebryter',),
'blokadebrytere': ('blokadebryter',),
'blokadebryteren': ('blokadebryter',),
'blokadebryterer': ('blokadebryter',),
'blokadebryterne': ('blokadebryter',),
'blokadeskip': ('blokadeskip',),
'blokadeskipa': ('blokadeskip',),
'blokadeskipene': ('blokadeskip',),
'blokadeskipet': ('blokadeskip',),
'blokk': ('blokk',),
'blokka': ('blokk',),
'blokken': ('blokk',),
'blokkene': ('blokk',),
'blokker': ('blokk',),
'blokkboer': ('blokkboer',),
'blokkboere': ('blokkboer',),
'blokkboeren': ('blokkboer',),
'blokkboerer': ('blokkboer',),
'blokkboerne': ('blokkboer',),
'blokkbokstav': ('blokkbokstav',),
'blokkbokstaven': ('blokkbokstav',),
'blokkbokstavene': ('blokkbokstav',),
'blokkbokstaver': ('blokkbokstav',),
'blokkbuer': ('blokkbuer',),
'blokkbuere': ('blokkbuer',),
'blokkbueren': ('blokkbuer',),
'blokkbuerer': ('blokkbuer',),
'blokkbuerne': ('blokkbuer',),
'blokkebær': ('blokkebær',),
'blokkebæra': ('blokkebær',),
'blokkebærene': ('blokkebær',),
'blokkebæret': ('blokkebær',),
'blokkebær': ('blokkebær',),
'blokkebæra': ('blokkebær',),
'blokkebærene': ('blokkebær',),
'blokkebæret': ('blokkebær',),
'blokkering': ('blokkering',),
'blokkeringa': ('blokkering',),
'blokkeringen': ('blokkering',),
'blokkeringene': ('blokkering',),
'blokkeringer': ('blokkering',),
'blokkfløyta': ('blokkfløyte',),
'blokkfløyte': ('blokkfløyte',),
'blokkfløyten': ('blokkfløyte',),
'blokkfløytene': ('blokkfløyte',),
'blokkfløyter': ('blokkfløyte',),
'blokkhus': ('blokkhus',),
'blokkhusa': ('blokkhus',),
'blokkhusene': ('blokkhus',),
'blokkhuset': ('blokkhus',),
'blokkleilighet': ('blokkleilighet',),
'blokkleiligheta': ('blokkleilighet',),
'blokkleiligheten': ('blokkleilighet',),
'blokkleilighetene': ('blokkleilighet',),
'blokkleiligheter': ('blokkleilighet',),
'blokkpost': ('blokkpost',),
'blokkposten': ('blokkpost',),
'blokkpostene': ('blokkpost',),
'blokkposter': ('blokkpost',),
'blokkskiva': ('blokkskive',),
'blokkskive': ('blokkskive',),
'blokkskiven': ('blokkskive',),
'blokkskivene': ('blokkskive',),
'blokkskiver': ('blokkskive',),
'blokkskrift': ('blokkskrift',),
'blokkskrifta': ('blokkskrift',),
'blokkskriften': ('blokkskrift',),
'blokkskriftene': ('blokkskrift',),
'blokkskrifter': ('blokkskrift',),
'blomkarse': ('blomkarse',),
'blomkarsen': ('blomkarse',),
'blomkarsene': ('blomkarse',),
'blomkarser': ('blomkarse',),
'blomkål': ('blomkål',),
'blomkålen': ('blomkål',),
'blomkålene': ('blomkål',),
'blomkåler': ('blomkål',),
'blomkålhoda': ('blomkålhode',),
'blomkålhode': ('blomkålhode',),
'blomkålhodene': ('blomkålhode',),
'blomkålhoder': ('blomkålhode',),
'blomkålhodet': ('blomkålhode',),
'blomkålsopp': ('blomkålsopp',),
'blomkålsoppen': ('blomkålsopp',),
'blomkålsoppene': ('blomkålsopp',),
'blomkålsopper': ('blomkålsopp',),
'blomkålsuppa': ('blomkålsuppe',),
'blomkålsuppe': ('blomkålsuppe',),
'blomkålsuppen': ('blomkålsuppe',),
'blomkålsuppene': ('blomkålsuppe',),
'blomkålsupper': ('blomkålsuppe',),
'blomkåløra': ('blomkåløre',),
'blomkåløre': ('blomkåløre',),
'blomkålørene': ('blomkåløre',),
'blomkålører': ('blomkåløre',),
'blomkåløret': ('blomkåløre',),
'blomst': ('blomst',),
'blomsten': ('blomst',),
'blomstene': ('blomst',),
'blomster': ('blomst',),
'blomster': ('blomster',),
'blomsteren': ('blomster',),
'blomstre': ('blomster',),
'blomstrene': ('blomster',),
'blomstrer': ('blomster',),
'blomsterbarn': ('blomsterbarn',),
'blomsterbarna': ('blomsterbarn',),
'blomsterbarnene': ('blomsterbarn',),
'blomsterbarnet': ('blomsterbarn',),
'blomsterbed': ('blomsterbed',),
'blomsterbeda': ('blomsterbed',),
'blomsterbedene': ('blomsterbed',),
'blomsterbedet': ('blomsterbed',),
'blomsterbinder': ('blomsterbinder',),
'blomsterbindere': ('blomsterbinder',),
'blomsterbinderen': ('blomsterbinder',),
'blomsterbinderer': ('blomsterbinder',),
'blomsterbinderne': ('blomsterbinder',),
'blomsterbotn': ('blomsterbotn',),
'blomsterbotnen': ('blomsterbotn',),
'blomsterbotnene': ('blomsterbotn',),
'blomsterbotner': ('blomsterbotn',),
'blomsterbukett': ('blomsterbukett',),
'blomsterbuketten': ('blomsterbukett',),
'blomsterbukettene': ('blomsterbukett',),
'blomsterbuketter': ('blomsterbukett',),
'blomsterbunn': ('blomsterbunn',),
'blomsterbunnen': ('blomsterbunn',),
'blomsterbunnene': ('blomsterbunn',),
'blomsterbunner': ('blomsterbunn',),
'blomsterdekorasjon': ('blomsterdekorasjon',),
'blomsterdekorasjonen': ('blomsterdekorasjon',),
'blomsterdekorasjonene': ('blomsterdekorasjon',),
'blomsterdekorasjoner': ('blomsterdekorasjon',),
'blomsterhandel': ('blomsterhandel',),
'blomsterhandelen': ('blomsterhandel',),
'blomsterhandlene': ('blomsterhandel',),
'blomsterhandler': ('blomsterhandel',),
'blomsterhilsen': ('blomsterhilsen',),
'blomsterhilsenen': ('blomsterhilsen',),
'blomsterhilsenene': ('blomsterhilsen',),
'blomsterhilsener': ('blomsterhilsen',),
'blomsterkassa': ('blomsterkasse',),
'blomsterkasse': ('blomsterkasse',),
'blomsterkassen': ('blomsterkasse',),
'blomsterkassene': ('blomsterkasse',),
'blomsterkasser': ('blomsterkasse',),
'blomsterkrans': ('blomsterkrans',),
'blomsterkransen': ('blomsterkrans',),
'blomsterkransene': ('blomsterkrans',),
'blomsterkranser': ('blomsterkrans',),
'blomsterløk': ('blomsterløk',),
'blomsterløken': ('blomsterløk',),
'blomsterløkene': ('blomsterløk',),
'blomsterløker': ('blomsterløk',),
'blomsterlauk': ('blomsterlauk',),
'blomsterlauken': ('blomsterlauk',),
'blomsterlaukene': ('blomsterlauk',),
'blomsterlauker': ('blomsterlauk',),
'blomsterpotta': ('blomsterpotte',),
'blomsterpotte': ('blomsterpotte',),
'blomsterpotten': ('blomsterpotte',),
'blomsterpottene': ('blomsterpotte',),
'blomsterpotter': ('blomsterpotte',),
'blomsterprakt': ('blomsterprakt',),
'blomsterprakta': ('blomsterprakt',),
'blomsterprakten': ('blomsterprakt',),
'blomsterpraktene': ('blomsterprakt',),
'blomsterprakter': ('blomsterprakt',),
'blomsterrabatt': ('blomsterrabatt',),
'blomsterrabatten': ('blomsterrabatt',),
'blomsterrabattene': ('blomsterrabatt',),
'blomsterrabatter': ('blomsterrabatt',),
'blomsterskjerm': ('blomsterskjerm',),
'blomsterskjermen': ('blomsterskjerm',),
'blomsterskjermene': ('blomsterskjerm',),
'blomsterskjermer': ('blomsterskjerm',),
'blomsterstand': ('blomsterstand',),
'blomsterstanden': ('blomsterstand',),
'blomsterstandene': ('blomsterstand',),
'blomsterstander': ('blomsterstand',),
'blomstertorg': ('blomstertorg',),
'blomstertorga': ('blomstertorg',),
'blomstertorgene': ('blomstertorg',),
'blomstertorget': ('blomstertorg',),
'blomstervase': ('blomstervase',),
'blomstervasen': ('blomstervase',),
'blomstervasene': ('blomstervase',),
'blomstervaser': ('blomstervase',),
'blomstring': ('blomstring',),
'blomstringa': ('blomstring',),
'blomstringen': ('blomstring',),
'blomstringene': ('blomstring',),
'blomstringer': ('blomstring',),
'blomstringstid': ('blomstringstid',),
'blomstringstida': ('blomstringstid',),
'blomstringstiden': ('blomstringstid',),
'blomstringstidene': ('blomstringstid',),
'blomstringstider': ('blomstringstid',),
'blonde': ('blonde',),
'blonden': ('blonde',),
'blondene': ('blonde',),
'blonder': ('blonde',),
'blondeblusa': ('blondebluse',),
'blondebluse': ('blondebluse',),
'blondeblusen': ('blondebluse',),
'blondeblusene': ('blondebluse',),
'blondebluser': ('blondebluse',),
'blondekant': ('blondekant',),
'blondekanten': ('blondekant',),
'blondekantene': ('blondekant',),
'blondekanter': ('blondekant',),
'blondeslør': ('blondeslør',),
'blondesløra': ('blondeslør',),
'blondeslørene': ('blondeslør',),
'blondesløret': ('blondeslør',),
'blondestoff': ('blondestoff',),
'blondestoffa': ('blondestoff',),
'blondestoffene': ('blondestoff',),
'blondestoffer': ('blondestoff',),
'blondestoffet': ('blondestoff',),
'blondina': ('blondine',),
'blondine': ('blondine',),
'blondinen': ('blondine',),
'blondinene': ('blondine',),
'blondiner': ('blondine',),
'blot': ('blot',),
'blota': ('blot',),
'blotene': ('blot',),
'blotet': ('blot',),
'blotter': ('blotter',),
'blottere': ('blotter',),
'blotteren': ('blotter',),
'blotterer': ('blotter',),
'blotterne': ('blotter',),
'blow-out': ('blow-out',),
'blow-outen': ('blow-out',),
'blow-outene': ('blow-out',),
'blow-outer': ('blow-out',),
'blueback': ('blueback',),
'bluebacken': ('blueback',),
'bluebackene': ('blueback',),
'bluebacker': ('blueback',),
'blueline': ('blueline',),
'blues': ('blues',),
'bluesen': ('blues',),
'bluesene': ('blues',),
'bluessanger': ('bluessanger',),
'bluessangere': ('bluessanger',),
'bluessangeren': ('bluessanger',),
'bluessangerer': ('bluessanger',),
'bluessangerne': ('bluessanger',),
'bluferdighet': ('bluferdighet',),
'bluferdigheta': ('bluferdighet',),
'bluferdigheten': ('bluferdighet',),
'bluferdighetene': ('bluferdighet',),
'bluferdigheter': ('bluferdighet',),
'blund': ('blund',),
'blunden': ('blund',),
'blundene': ('blund',),
'blunder': ('blund',),
'blunder': ('blunder',),
'blundere': ('blunder',),
'blunderen': ('blunder',),
'blunderer': ('blunder',),
'blunderne': ('blunder',),
'blunk': ('blunk',),
'blunka': ('blunk',),
'blunken': ('blunk',),
'blunkene': ('blunk',),
'blunket': ('blunk',),
'blusa': ('bluse',),
'bluse': ('bluse',),
'blusen': ('bluse',),
'blusene': ('bluse',),
'bluser': ('bluse',),
'bluseliv': ('bluseliv',),
'bluseliva': ('bluseliv',),
'bluselivene': ('bluseliv',),
'bluselivet': ('bluseliv',),
'bluss': ('bluss',),
'blussa': ('bluss',),
'blussene': ('bluss',),
'blusset': ('bluss',),
'bluslene': ('blussel',),
'blusler': ('blussel',),
'blussel': ('blussel',),
'blusselen': ('blussel',),
'bly': ('bly',),
'blya': ('bly',),
'blyene': ('bly',),
'blyet': ('bly',),
'blyakkumulator': ('blyakkumulator',),
'blyakkumulatoren': ('blyakkumulator',),
'blyakkumulatorene': ('blyakkumulator',),
'blyakkumulatorer': ('blyakkumulator',),
'blyant': ('blyant',),
'blyanten': ('blyant',),
'blyantene': ('blyant',),
'blyanter': ('blyant',),
'blyantskissa': ('blyantskisse',),
'blyantskisse': ('blyantskisse',),
'blyantskissen': ('blyantskisse',),
'blyantskissene': ('blyantskisse',),
'blyantskisser': ('blyantskisse',),
'blyantspisser': ('blyantspisser',),
'blyantspissere': ('blyantspisser',),
'blyantspisseren': ('blyantspisser',),
'blyantspisserer': ('blyantspisser',),
'blyantspisserne': ('blyantspisser',),
'blyantstegning': ('blyantstegning',),
'blyantstegninga': ('blyantstegning',),
'blyantstegningen': ('blyantstegning',),
'blyantstegningene': ('blyantstegning',),
'blyantstegninger': ('blyantstegning',),
'blyantstift': ('blyantstift',),
'blyantstiften': ('blyantstift',),
'blyantstiftene': ('blyantstift',),
'blyantstifter': ('blyantstift',),
'blyanttegning': ('blyanttegning',),
'blyanttegninga': ('blyanttegning',),
'blyanttegningen': ('blyanttegning',),
'blyanttegningene': ('blyanttegning',),
'blyanttegninger': ('blyanttegning',),
'blybensin': ('blybensin',),
'blybensinen': ('blybensin',),
'blybensinene': ('blybensin',),
'blybensiner': ('blybensin',),
'blyerts': ('blyerts',),
'blyertsen': ('blyerts',),
'blyertsene': ('blyerts',),
'blyertser': ('blyerts',),
'blyfarge': ('blyfarge',),
'blyfargen': ('blyfarge',),
'blyfargene': ('blyfarge',),
'blyfarger': ('blyfarge',),
'blyforbindelse': ('blyforbindelse',),
'blyforbindelsen': ('blyforbindelse',),
'blyforbindelsene': ('blyforbindelse',),
'blyforbindelser': ('blyforbindelse',),
'blyforgiftning': ('blyforgiftning',),
'blyforgiftninga': ('blyforgiftning',),
'blyforgiftningen': ('blyforgiftning',),
'blyforgiftningene': ('blyforgiftning',),
'blyforgiftninger': ('blyforgiftning',),
'blyforkle': ('blyforkle',),
'blyforkleet': ('blyforkle',),
'blyforklær': ('blyforkle',),
'blyforklærne': ('blyforkle',),
'blyglans': ('blyglans',),
'blyglansen': ('blyglans',),
'blyglansene': ('blyglans',),
'blyglanser': ('blyglans',),
'blygsel': ('blygsel',),
'blygselen': ('blygsel',),
'blygsla': ('blygsel',),
'blygslene': ('blygsel',),
'blygsler': ('blygsel',),
'blyhagl': ('blyhagl',),
'blyhagla': ('blyhagl',),
'blyhaglene': ('blyhagl',),
'blyhaglet': ('blyhagl',),
'blyinnfatning': ('blyinnfatning',),
'blyinnfatninga': ('blyinnfatning',),
'blyinnfatningen': ('blyinnfatning',),
'blyinnfatningene': ('blyinnfatning',),
'blyinnfatninger': ('blyinnfatning',),
'blymalm': ('blymalm',),
'blymalmen': ('blymalm',),
'blymalmene': ('blymalm',),
'blymalmer': ('blymalm',),
'blyoksid': ('blyoksid',),
'blyoksida': ('blyoksid',),
'blyoksidene': ('blyoksid',),
'blyoksider': ('blyoksid',),
'blyoksidet': ('blyoksid',),
'blyregn': ('blyregn',),
'blyregna': ('blyregn',),
'blyregnene': ('blyregn',),
'blyregnet': ('blyregn',),
'blysulfid': ('blysulfid',),
'blysulfida': ('blysulfid',),
'blysulfidene': ('blysulfid',),
'blysulfider': ('blysulfid',),
'blysulfidet': ('blysulfid',),
'blyvindu': ('blyvindu',),
'blyvindua': ('blyvindu',),
'blyvinduene': ('blyvindu',),
'blyvinduer': ('blyvindu',),
'blyvinduet': ('blyvindu',),
'blåbok': ('blåbok',),
'blåboka': ('blåbok',),
'blåboken': ('blåbok',),
'blåbøkene': ('blåbok',),
'blåbøker': ('blåbok',),
'blåbær': ('blåbær',),
'blåbæra': ('blåbær',),
'blåbærene': ('blåbær',),
'blåbæret': ('blåbær',),
'blåbærpai': ('blåbærpai',),
'blåbærpaien': ('blåbærpai',),
'blåbærpaiene': ('blåbærpai',),
'blåbærpaier': ('blåbærpai',),
'blåbærsaft': ('blåbærsaft',),
'blåbærsafta': ('blåbærsaft',),
'blåbærsaften': ('blåbærsaft',),
'blåbærsaftene': ('blåbærsaft',),
'blåbærsafter': ('blåbærsaft',),
'blåbærsuppa': ('blåbærsuppe',),
'blåbærsuppe': ('blåbærsuppe',),
'blåbærsuppen': ('blåbærsuppe',),
'blåbærsuppene': ('blåbærsuppe',),
'blåbærsupper': ('blåbærsuppe',),
'blåbærsyltetøy': ('blåbærsyltetøy',),
'blåbærsyltetøya': ('blåbærsyltetøy',),
'blåbærsyltetøyene': ('blåbærsyltetøy',),
'blåbærsyltetøyer': ('blåbærsyltetøy',),
'blåbærsyltetøyet': ('blåbærsyltetøy',),
'blådress': ('blådress',),
'blådressen': ('blådress',),
'blådressene': ('blådress',),
'blådresser': ('blådress',),
'blåhval': ('blåhval',),
'blåhvalen': ('blåhval',),
'blåhvalene': ('blåhval',),
'blåhvaler': ('blåhval',),
'blåklokka': ('blåklokke',),
'blåklokke': ('blåklokke',),
'blåklokken': ('blåklokke',),
'blåklokkene': ('blåklokke',),
'blåklokker': ('blåklokke',),
'blåknapp': ('blåknapp',),
'blåknappen': ('blåknapp',),
'blåknappene': ('blåknapp',),
'blåknapper': ('blåknapp',),
'blåknute': ('blåknute',),
'blåknuten': ('blåknute',),
'blåknutene': ('blåknute',),
'blåknuter': ('blåknute',),
'blåkoll': ('blåkoll',),
'blåkollen': ('blåkoll',),
'blåkollene': ('blåkoll',),
'blåkoller': ('blåkoll',),
'blåkval': ('blåkval',),
'blåkvalen': ('blåkval',),
'blåkvalene': ('blåkval',),
'blåkvaler': ('blåkval',),
'blåkveita': ('blåkveite',),
'blåkveite': ('blåkveite',),
'blåkveiten': ('blåkveite',),
'blåkveitene': ('blåkveite',),
'blåkveiter': ('blåkveite',),
'blåleir': ('blåleir',),
'blåleira': ('blåleir',),
'blåleirene': ('blåleir',),
'blåleiret': ('blåleir',),
'blåleira': ('blåleire',),
'blåleire': ('blåleire',),
'blåleiren': ('blåleire',),
'blåleirene': ('blåleire',),
'blåleirer': ('blåleire',),
'blålys': ('blålys',),
'blålysa': ('blålys',),
'blålysene': ('blålys',),
'blålyset': ('blålys',),
'blåmandag': ('blåmandag',),
'blåmandagen': ('blåmandag',),
'blåmandagene': ('blåmandag',),
'blåmandager': ('blåmandag',),
'blåmeis': ('blåmeis',),
'blåmeisa': ('blåmeis',),
'blåmeisen': ('blåmeis',),
'blåmeisene': ('blåmeis',),
'blåmeiser': ('blåmeis',),
'blåmyr': ('blåmyr',),
'blåmyra': ('blåmyr',),
'blåmyren': ('blåmyr',),
'blåmyrene': ('blåmyr',),
'blåmyrer': ('blåmyr',),
'blåne': ('blåne',),
'blånen': ('blåne',),
'blånene': ('blåne',),
'blåner': ('blåne',),
'blåpapir': ('blåpapir',),
'blåpapira': ('blåpapir',),
'blåpapirene': ('blåpapir',),
'blåpapirer': ('blåpapir',),
'blåpapiret': ('blåpapir',),
'blår': ('blår',),
'blåregn': ('blåregn',),
'blåregnen': ('blåregn',),
'blåregnene': ('blåregn',),
'blåregner': ('blåregn',),
'blårev': ('blårev',),
'blåreven': ('blårev',),
'blårevene': ('blårev',),
'blårever': ('blårev',),
'blåruss': ('blåruss',),
'blårussen': ('blåruss',),
'blårussene': ('blåruss',),
'blås': ('blås',),
'blåsen': ('blås',),
'blåsene': ('blås',),
'blåser': ('blås',),
'blåsa': ('blåse',),
'blåse': ('blåse',),
'blåsen': ('blåse',),
'blåsene': ('blåse',),
'blåser': ('blåse',),
'blåsebelg': ('blåsebelg',),
'blåsebelgen': ('blåsebelg',),
'blåsebelgene': ('blåsebelg',),
'blåsebelger': ('blåsebelg',),
'blåseinstrument': ('blåseinstrument',),
'blåseinstrumenta': ('blåseinstrument',),
'blåseinstrumentene': ('blåseinstrument',),
'blåseinstrumenter': ('blåseinstrument',),
'blåseinstrumentet': ('blåseinstrument',),
'blåser': ('blåser',),
'blåsere': ('blåser',),
'blåseren': ('blåser',),
'blåserer': ('blåser',),
'blåserne': ('blåser',),
'blåserør': ('blåserør',),
'blåserøra': ('blåserør',),
'blåserørene': ('blåserør',),
'blåserøret': ('blåserør',),
'blåskjell': ('blåskjell',),
'blåskjella': ('blåskjell',),
'blåskjellen': ('blåskjell',),
'blåskjellene': ('blåskjell',),
'blåskjellet': ('blåskjell',),
'blåst': ('blåst',),
'blåsten': ('blåst',),
'blåstene': ('blåst',),
'blåster': ('blåst',),
'blåstrupe': ('blåstrupe',),
'blåstrupen': ('blåstrupe',),
'blåstrupene': ('blåstrupe',),
'blåstruper': ('blåstrupe',),
'blåstrømpa': ('blåstrømpe',),
'blåstrømpe': ('blåstrømpe',),
'blåstrømpen': ('blåstrømpe',),
'blåstrømpene': ('blåstrømpe',),
'blåstrømper': ('blåstrømpe',),
'blåsymra': ('blåsymre',),
'blåsymre': ('blåsymre',),
'blåsymren': ('blåsymre',),
'blåsymrene': ('blåsymre',),
'blåsymrer': ('blåsymre',),
'blåsyra': ('blåsyre',),
'blåsyre': ('blåsyre',),
'blåsyren': ('blåsyre',),
'blåsyrene': ('blåsyre',),
'blåsyrer': ('blåsyre',),
'blått': ('blått',),
'blåtøy': ('blåtøy',),
'blåtøya': ('blåtøy',),
'blåtøyene': ('blåtøy',),
'blåtøyer': ('blåtøy',),
'blåtøyet': ('blåtøy',),
'blåtøyskjole': ('blåtøyskjole',),
'blåtøyskjolen': ('blåtøyskjole',),
'blåtøyskjolene': ('blåtøyskjole',),
'blåtøyskjoler': ('blåtøyskjole',),
'blåved': ('blåved',),
'blåveden': ('blåved',),
'blåvedene': ('blåved',),
'blåveder': ('blåved',),
'blåveis': ('blåveis',),
'blåveisen': ('blåveis',),
'blåveisene': ('blåveis',),
'blåveiser': ('blåveis',),
'blæra': ('blære',),
'blære': ('blære',),
'blæren': ('blære',),
'blærene': ('blære',),
'blærer': ('blære',),
'blæra': ('blære',),
'blære': ('blære',),
'blæren': ('blære',),
'blærene': ('blære',),
'blærer': ('blære',),
'blærebetennelse': ('blærebetennelse',),
'blærebetennelsen': ('blærebetennelse',),
'blærebetennelsene': ('blærebetennelse',),
'blærebetennelser': ('blærebetennelse',),
'blærehals': ('blærehals',),
'blærehalsen': ('blærehals',),
'blærehalsene': ('blærehals',),
'blærehalser': ('blærehals',),
'blærehalskjertel': ('blærehalskjertel',),
'blærehalskjertelen': ('blærehalskjertel',),
'blærehalskjertlene': ('blærehalskjertel',),
'blærehalskjertler': ('blærehalskjertel',),
'blærekatarr': ('blærekatarr',),
'blærekatarren': ('blærekatarr',),
'blærekatarrene': ('blærekatarr',),
'blærekatarrer': ('blærekatarr',),
'blæretang': ('blæretang',),
'blæretanga': ('blæretang',),
'blæretangen': ('blæretang',),
'blæretangene': ('blæretang',),
'blæretanger': ('blæretang',),
'blæretanget': ('blæretang',),
'bløder': ('bløder',),
'blødere': ('bløder',),
'bløderen': ('bløder',),
'bløderer': ('bløder',),
'bløderne': ('bløder',),
'bløderfamilie': ('bløderfamilie',),
'bløderfamilien': ('bløderfamilie',),
'bløderfamiliene': ('bløderfamilie',),
'bløderfamilier': ('bløderfamilie',),
'blødersjukdom': ('blødersjukdom',),
'blødersjukdommen': ('blødersjukdom',),
'blødersjukdommene': ('blødersjukdom',),
'blødersjukdommer': ('blødersjukdom',),
'blødersjuka': ('blødersjuke',),
'blødersjuke': ('blødersjuke',),
'blødersjuken': ('blødersjuke',),
'blødersjukene': ('blødersjuke',),
'blødersjuker': ('blødersjuke',),
'blødersykdom': ('blødersykdom',),
'blødersykdommen': ('blødersykdom',),
'blødersykdommene': ('blødersykdom',),
'blødersykdommer': ('blødersykdom',),
'blødersyka': ('blødersyke',),
'blødersyke': ('blødersyke',),
'blødersyken': ('blødersyke',),
'blødersykene': ('blødersyke',),
'blødersyker': ('blødersyke',),
'blødme': ('blødme',),
'blødmen': ('blødme',),
'blødmene': ('blødme',),
'blødmer': ('blødme',),
'blødning': ('blødning',),
'blødninga': ('blødning',),
'blødningen': ('blødning',),
'blødningene': ('blødning',),
'blødninger': ('blødning',),
'bløff': ('bløff',),
'bløffen': ('bløff',),
'bløffene': ('bløff',),
'bløffer': ('bløff',),
'bløffmaker': ('bløffmaker',),
'bløffmakere': ('bløffmaker',),
'bløffmakeren': ('bløffmaker',),
'bløffmakerer': ('bløffmaker',),
'bløffmakerne': ('bløffmaker',),
'bløt': ('bløt',),
'bløtdyr': ('bløtdyr',),
'bløtdyra': ('bløtdyr',),
'bløtdyrene': ('bløtdyr',),
'bløtdyret': ('bløtdyr',),
'bløtjern': ('bløtjern',),
'bløtjerna': ('bløtjern',),
'bløtjernene': ('bløtjern',),
'bløtjernet': ('bløtjern',),
'bløtkaka': ('bløtkake',),
'bløtkake': ('bløtkake',),
'bløtkaken': ('bløtkake',),
'bløtkakene': ('bløtkake',),
'bløtkaker': ('bløtkake',),
'bløtskilpadda': ('bløtskilpadde',),
'bløtskilpadde': ('bløtskilpadde',),
'bløtskilpadden': ('bløtskilpadde',),
'bløtskilpaddene': ('bløtskilpadde',),
'bløtskilpadder': ('bløtskilpadde',),
'bløtstål': ('bløtstål',),
'bløtståla': ('bløtstål',),
'bløtstålene': ('bløtstål',),
'bløtstålet': ('bløtstål',),
'bløyt': ('bløyt',),
'bløyta': ('bløyte',),
'bløyte': ('bløyte',),
'bløyten': ('bløyte',),
'bløytene': ('bløyte',),
'bløyter': ('bløyte',),
'bo': ('bo',),
'boa': ('bo',),
'boene': ('bo',),
'boet': ('bo',),
'bo': ('bo',),
'boa': ('boa',),
'boaen': ('boa',),
'boaene': ('boa',),
'boaer': ('boa',),
'boardingkort': ('boardingkort',),
'boardingkorta': ('boardingkort',),
'boardingkortene': ('boardingkort',),
'boardingkortet': ('boardingkort',),
'bobby': ('bobby',),
'bobbyen': ('bobby',),
'bobbyene': ('bobby',),
'bobbyer': ('bobby',),
'bobestyrer': ('bobestyrer',),
'bobestyrere': ('bobestyrer',),
'bobestyreren': ('bobestyrer',),
'bobestyrerer': ('bobestyrer',),
'bobestyrerne': ('bobestyrer',),
'bobla': ('boble',),
'boble': ('boble',),
'boblen': ('boble',),
'boblene': ('boble',),
'bobler': ('boble',),
'boblejakka': ('boblejakke',),
'boblejakke': ('boblejakke',),
'boblejakken': ('boblejakke',),
'boblejakkene': ('boblejakke',),
'boblejakker': ('boblejakke',),
'boblestoff': ('boblestoff',),
'boblestoffa': ('boblestoff',),
'boblestoffene': ('boblestoff',),
'boblestoffer': ('boblestoff',),
'boblestoffet': ('boblestoff',),
'bobsleigh': ('bobsleigh',),
'bobsleighen': ('bobsleigh',),
'bobsleighene': ('bobsleigh',),
'bobsleigher': ('bobsleigh',),
'bobsleighbane': ('bobsleighbane',),
'bobsleighbanen': ('bobsleighbane',),
'bobsleighbanene': ('bobsleighbane',),
'bobsleighbaner': ('bobsleighbane',),
'boccia': ('boccia',),
'bocciaen': ('boccia',),
'bocciaene': ('boccia',),
'bocciaer': ('boccia',),
'bod': ('bod',),
'boden': ('bod',),
'bodene': ('bod',),
'boder': ('bod',),
'bodega': ('bodega',),
'bodegaen': ('bodega',),
'bodegaene': ('bodega',),
'bodegaer': ('bodega',),
'bodybuilding': ('bodybuilding',),
'bodybuildinga': ('bodybuilding',),
'bodybuildingen': ('bodybuilding',),
'bodybuildingene': ('bodybuilding',),
'bodybuildinger': ('bodybuilding',),
'boer': ('boer',),
'boere': ('boer',),
'boeren': ('boer',),
'boerer': ('boer',),
'boerne': ('boer',),
'bofellesskap': ('bofellesskap',),
'bofellesskapa': ('bofellesskap',),
'bofellesskapene': ('bofellesskap',),
'bofellesskaper': ('bofellesskap',),
'bofellesskapet': ('bofellesskap',),
'boflata': ('boflate',),
'boflate': ('boflate',),
'boflaten': ('boflate',),
'boflatene': ('boflate',),
'boflater': ('boflate',),
'boform': ('boform',),
'boforma': ('boform',),
'boformen': ('boform',),
'boformene': ('boform',),
'boformer': ('boform',),
'bog': ('bog',),
'bogen': ('bog',),
'bogene': ('bog',),
'boger': ('bog',),
'boge': ('boge',),
'bogen': ('boge',),
'bogene': ('boge',),
'boger': ('boge',),
'bogebro': ('bogebro',),
'bogebroa': ('bogebro',),
'bogebroen': ('bogebro',),
'bogebroene': ('bogebro',),
'bogebroer': ('bogebro',),
'bogebru': ('bogebru',),
'bogebrua': ('bogebru',),
'bogebruen': ('bogebru',),
'bogebruene': ('bogebru',),
'bogebruer': ('bogebru',),
'bogegang': ('bogegang',),
'bogegangen': ('bogegang',),
'bogegangene': ('bogegang',),
'bogeganger': ('bogegang',),
'bogegrad': ('bogegrad',),
'bogegraden': ('bogegrad',),
'bogegradene': ('bogegrad',),
'bogegrader': ('bogegrad',),
'bogeminutt': ('bogeminutt',),
'bogeminutta': ('bogeminutt',),
'bogeminuttene': ('bogeminutt',),
'bogeminutter': ('bogeminutt',),
'bogeminuttet': ('bogeminutt',),
'bogeparentes': ('bogeparentes',),
'bogeparentesen': ('bogeparentes',),
'bogeparentesene': ('bogeparentes',),
'bogeparenteser': ('bogeparentes',),
'bogesag': ('bogesag',),
'bogesaga': ('bogesag',),
'bogesagen': ('bogesag',),
'bogesagene': ('bogesag',),
'bogesager': ('bogesag',),
'bogesekund': ('bogesekund',),
'bogesekunda': ('bogesekund',),
'bogesekundene': ('bogesekund',),
'bogesekunder': ('bogesekund',),
'bogesekundet': ('bogesekund',),
'bogestreng': ('bogestreng',),
'bogestrengen': ('bogestreng',),
'bogestrengene': ('bogestreng',),
'bogestrenger': ('bogestreng',),
'bogetak': ('bogetak',),
'bogetaka': ('bogetak',),
'bogetakene': ('bogetak',),
'bogetaket': ('bogetak',),
'bogevindu': ('bogevindu',),
'bogevindua': ('bogevindu',),
'bogevinduene': ('bogevindu',),
'bogevinduer': ('bogevindu',),
'bogevinduet': ('bogevindu',),
'boggi': ('boggi',),
'boggien': ('boggi',),
'boggiene': ('boggi',),
'boggier': ('boggi',),
'boggivogn': ('boggivogn',),
'boggivogna': ('boggivogn',),
'boggivognen': ('boggivogn',),
'boggivognene': ('boggivogn',),
'boggivogner': ('boggivogn',),
'bogtre': ('bogtre',),
'bogtrea': ('bogtre',),
'bogtreet': ('bogtre',),
'bogtrær': ('bogtre',),
'bogtrærne': ('bogtre',),
'bohava': ('bohave',),
'bohave': ('bohave',),
'bohavene': ('bohave',),
'bohaver': ('bohave',),
'bohavet': ('bohave',),
'bohem': ('bohem',),
'bohemen': ('bohem',),
'bohemene': ('bohem',),
'bohemer': ('bohem',),
'bohembevegelse': ('bohembevegelse',),
'bohembevegelsen': ('bohembevegelse',),
'bohembevegelsene': ('bohembevegelse',),
'bohembevegelser': ('bohembevegelse',),
'boi': ('boi',),
'boien': ('boi',),
'boiene': ('boi',),
'boier': ('boi',),
'boikott': ('boikott',),
'boikotten': ('boikott',),
'boikottene': ('boikott',),
'boikotter': ('boikott',),
'bojar': ('bojar',),
'bojaren': ('bojar',),
'bojarene': ('bojar',),
'bojarer': ('bojar',),
'bok': ('bok',),
'boka': ('bok',),
'boken': ('bok',),
'bokene': ('bok',),
'boker': ('bok',),
'bok': ('bok',),
'boka': ('bok',),
'boken': ('bok',),
'bøkene': ('bok',),
'bøker': ('bok',),
'bokanmeldelse': ('bokanmeldelse',),
'bokanmeldelsen': ('bokanmeldelse',),
'bokanmeldelsene': ('bokanmeldelse',),
'bokanmeldelser': ('bokanmeldelse',),
'bokanmelder': ('bokanmelder',),
'bokanmeldere': ('bokanmelder',),
'bokanmelderen': ('bokanmelder',),
'bokanmelderer': ('bokanmelder',),
'bokanmelderne': ('bokanmelder',),
'bokbind': ('bokbind',),
'bokbinda': ('bokbind',),
'bokbindene': ('bokbind',),
'bokbindet': ('bokbind',),
'bokbinder': ('bokbinder',),
'bokbindere': ('bokbinder',),
'bokbinderen': ('bokbinder',),
'bokbinderer': ('bokbinder',),
'bokbinderne': ('bokbinder',),
'bokbrenning': ('bokbrenning',),
'bokbrenninga': ('bokbrenning',),
'bokbrenningen': ('bokbrenning',),
'bokbrenningene': ('bokbrenning',),
'bokbrenninger': ('bokbrenning',),
'bokbuss': ('bokbuss',),
'bokbussen': ('bokbuss',),
'bokbussene': ('bokbuss',),
'bokbusser': ('bokbuss',),
'bokbåt': ('bokbåt',),
'bokbåten': ('bokbåt',),
'bokbåtene': ('bokbåt',),
'bokbåter': ('bokbåt',),
'bokettersyn': ('bokettersyn',),
'bokettersyna': ('bokettersyn',),
'bokettersynene': ('bokettersyn',),
'bokettersynet': ('bokettersyn',),
'bokfink': ('bokfink',),
'bokfinken': ('bokfink',),
'bokfinkene': ('bokfink',),
'bokfinker': ('bokfink',),
'bokflom': ('bokflom',),
'bokflommen': ('bokflom',),
'bokflommene': ('bokflom',),
'bokflommer': ('bokflom',),
'bokform': ('bokform',),
'bokforma': ('bokform',),
'bokformen': ('bokform',),
'bokformene': ('bokform',),
'bokformer': ('bokform',),
'bokføring': ('bokføring',),
'bokføringa': ('bokføring',),
'bokføringen': ('bokføring',),
'bokføringene': ('bokføring',),
'bokføringer': ('bokføring',),
'bokhandel': ('bokhandel',),
'bokhandelen': ('bokhandel',),
'bokhandlene': ('bokhandel',),
'bokhandler': ('bokhandel',),
'bokhandler': ('bokhandler',),
'bokhandlere': ('bokhandler',),
'bokhandleren': ('bokhandler',),
'bokhandlerer': ('bokhandler',),
'bokhandlerne': ('bokhandler',),
'bokholder': ('bokholder',),
'bokholdere': ('bokholder',),
'bokholderen': ('bokholder',),
'bokholderer': ('bokholder',),
'bokholderne': ('bokholder',),
'bokholderi': ('bokholderi',),
'bokholderia': ('bokholderi',),
'bokholderiene': ('bokholderi',),
'bokholderier': ('bokholderi',),
'bokholderiet': ('bokholderi',),
'bokhvete': ('bokhvete',),
'bokhveten': ('bokhvete',),
'bokhvetene': ('bokhvete',),
'bokhveter': ('bokhvete',),
'bokhvete': ('bokhvete',),
'bokhveten': ('bokhvete',),
'bokhvetene': ('bokhvete',),
'bokhveter': ('bokhvete',),
'bokhylla': ('bokhylle',),
'bokhylle': ('bokhylle',),
'bokhyllen': ('bokhylle',),
'bokhyllene': ('bokhylle',),
'bokhyller': ('bokhylle',),
'bokhøst': ('bokhøst',),
'bokhøsten': ('bokhøst',),
'bokhøstene': ('bokhøst',),
'bokhøster': ('bokhøst',),
'bokk': ('bokk',),
'bokken': ('bokk',),
'bokkene': ('bokk',),
'bokker': ('bokk',),
'bokklubb': ('bokklubb',),
'bokklubben': ('bokklubb',),
'bokklubbene': ('bokklubb',),
'bokklubber': ('bokklubb',),
'bokkunst': ('bokkunst',),
'bokkunsten': ('bokkunst',),
'bokkunstene': ('bokkunst',),
'bokkunster': ('bokkunst',),
'bokkveite': ('bokkveite',),
'bokkveiten': ('bokkveite',),
'bokkveitene': ('bokkveite',),
'bokkveiter': ('bokkveite',),
'bokkveite': ('bokkveite',),
'bokkveiten': ('bokkveite',),
'bokkveitene': ('bokkveite',),
'bokkveiter': ('bokkveite',),
'bokkøl': ('bokkøl',),
'bokkøla': ('bokkøl',),
'bokkølet': ('bokkøl',),
'boklade': ('boklade',),
'bokladen': ('boklade',),
'bokladene': ('boklade',),
'boklader': ('boklade',),
'bokladepris': ('bokladepris',),
'bokladeprisen': ('bokladepris',),
'bokladeprisene': ('bokladepris',),
'bokladepriser': ('bokladepris',),
'bokmelder': ('bokmelder',),
'bokmeldere': ('bokmelder',),
'bokmelderen': ('bokmelder',),
'bokmelderer': ('bokmelder',),
'bokmelderne': ('bokmelder',),
'bokmelding': ('bokmelding',),
'bokmeldinga': ('bokmelding',),
'bokmeldingen': ('bokmelding',),
'bokmeldingene': ('bokmelding',),
'bokmeldinger': ('bokmelding',),
'bokmerka': ('bokmerke',),
'bokmerke': ('bokmerke',),
'bokmerkene': ('bokmerke',),
'bokmerker': ('bokmerke',),
'bokmerket': ('bokmerke',),
'bokmål': ('bokmål',),
'bokmåla': ('bokmål',),
'bokmålene': ('bokmål',),
'bokmålet': ('bokmål',),
'bokmålstekst': ('bokmålstekst',),
'bokmålsteksta': ('bokmålstekst',),
'bokmålsteksten': ('bokmålstekst',),
'bokmålstekstene': ('bokmålstekst',),
'bokmålstekster': ('bokmålstekst',),
'bokmålsutgava': ('bokmålsutgave',),
'bokmålsutgave': ('bokmålsutgave',),
'bokmålsutgaven': ('bokmålsutgave',),
'bokmålsutgavene': ('bokmålsutgave',),
'bokmålsutgaver': ('bokmålsutgave',),
'boknefisk': ('boknefisk',),
'boknefisken': ('boknefisk',),
'boknefiskene': ('boknefisk',),
'boknefisker': ('boknefisk',),
'boknesild': ('boknesild',),
'boknesilda': ('boknesild',),
'boknesildene': ('boknesild',),
'boknesilder': ('boknesild',),
'bokollektiv': ('bokollektiv',),
'bokollektiva': ('bokollektiv',),
'bokollektivene': ('bokollektiv',),
'bokollektiver': ('bokollektiv',),
'bokollektivet': ('bokollektiv',),
'bokorm': ('bokorm',),
'bokormen': ('bokorm',),
'bokormene': ('bokorm',),
'bokormer': ('bokorm',),
'bokreditt': ('bokreditt',),
'bokreditten': ('bokreditt',),
'bokredittene': ('bokreditt',),
'bokreditter': ('bokreditt',),
'bokreol': ('bokreol',),
'bokreolen': ('bokreol',),
'bokreolene': ('bokreol',),
'bokreoler': ('bokreol',),
'boks': ('boks',),
'boksen': ('boks',),
'boksene': ('boks',),
'bokser': ('boks',),
'boks': ('boks',),
'boksen': ('boks',),
'boksene': ('boks',),
'bokser': ('boks',),
'boksamler': ('boksamler',),
'boksamlere': ('boksamler',),
'boksamleren': ('boksamler',),
'boksamlerer': ('boksamler',),
'boksamlerne': ('boksamler',),
'boksamling': ('boksamling',),
'boksamlinga': ('boksamling',),
'boksamlingen': ('boksamling',),
'boksamlingene': ('boksamling',),
'boksamlinger': ('boksamling',),
'boksehanske': ('boksehanske',),
'boksehansken': ('boksehanske',),
'boksehanskene': ('boksehanske',),
'boksehansker': ('boksehanske',),
'boksekamp': ('boksekamp',),
'boksekampen': ('boksekamp',),
'boksekampene': ('boksekamp',),
'boksekamper': ('boksekamp',),
'bokser': ('bokser',),
'boksere': ('bokser',),
'bokseren': ('bokser',),
'bokserer': ('bokser',),
'bokserne': ('bokser',),
'bokser': ('bokser',),
'boksere': ('bokser',),
'bokseren': ('bokser',),
'bokserer': ('bokser',),
'bokserne': ('bokser',),
'boksering': ('boksering',),
'bokseringen': ('boksering',),
'bokseringene': ('boksering',),
'bokseringer': ('boksering',),
'boksermotor': ('boksermotor',),
'boksermotoren': ('boksermotor',),
'boksermotorene': ('boksermotor',),
'boksermotorer': ('boksermotor',),
'bokskalv': ('bokskalv',),
'bokskalven': ('bokskalv',),
'bokskalvene': ('bokskalv',),
'bokskalver': ('bokskalv',),
'bokskalvsko': ('bokskalvsko',),
'bokskalvskoa': ('bokskalvsko',),
'bokskalvskoen': ('bokskalvsko',),
'bokskalvskoene': ('bokskalvsko',),
'bokskalvskor': ('bokskalvsko',),
'bokskalvskorne': ('bokskalvsko',),
'bokskred': ('bokskred',),
'bokskreda': ('bokskred',),
'bokskredene': ('bokskred',),
'bokskredet': ('bokskred',),
'bokspråk': ('bokspråk',),
'bokspråka': ('bokspråk',),
'bokspråkene': ('bokspråk',),
'bokspråket': ('bokspråk',),
'bokstav': ('bokstav',),
'bokstaven': ('bokstav',),
'bokstavene': ('bokstav',),
'bokstaver': ('bokstav',),
'bokstavord': ('bokstavord',),
'bokstavorda': ('bokstavord',),
'bokstavordene': ('bokstavord',),
'bokstavordet': ('bokstavord',),
'bokstavregning': ('bokstavregning',),
'bokstavregninga': ('bokstavregning',),
'bokstavregningen': ('bokstavregning',),
'bokstavregningene': ('bokstavregning',),
'bokstavregninger': ('bokstavregning',),
'bokstavrekning': ('bokstavrekning',),
'bokstavrekninga': ('bokstavrekning',),
'bokstavrekningen': ('bokstavrekning',),
'bokstavrekningene': ('bokstavrekning',),
'bokstavrekninger': ('bokstavrekning',),
'bokstavrim': ('bokstavrim',),
'bokstavrima': ('bokstavrim',),
'bokstavrimene': ('bokstavrim',),
'bokstavrimet': ('bokstavrim',),
'bokstavtrelldom': ('bokstavtrelldom',),
'bokstavtrelldommen': ('bokstavtrelldom',),
'bokstavtrelldommene': ('bokstavtrelldom',),
'bokstavtrelldommer': ('bokstavtrelldom',),
'boksåpner': ('boksåpner',),
'boksåpnere': ('boksåpner',),
'boksåpneren': ('boksåpner',),
'boksåpnerer': ('boksåpner',),
'boksåpnerne': ('boksåpner',),
'boksøl': ('boksøl',),
'boksøla': ('boksøl',),
'boksølet': ('boksøl',),
'boktitlene': ('boktittel',),
'boktitler': ('boktittel',),
'boktittel': ('boktittel',),
'boktittelen': ('boktittel',),
'boktrykk': ('boktrykk',),
'boktrykka': ('boktrykk',),
'boktrykkene': ('boktrykk',),
'boktrykket': ('boktrykk',),
'boktrykker': ('boktrykker',),
'boktrykkere': ('boktrykker',),
'boktrykkeren': ('boktrykker',),
'boktrykkerer': ('boktrykker',),
'boktrykkerne': ('boktrykker',),
'boktrykkeri': ('boktrykkeri',),
'boktrykkeria': ('boktrykkeri',),
'boktrykkeriene': ('boktrykkeri',),
'boktrykkerier': ('boktrykkeri',),
'boktrykkeriet': ('boktrykkeri',),
'boktrykkerkunst': ('boktrykkerkunst',),
'boktrykkerkunsten': ('boktrykkerkunst',),
'boktrykkerkunstene': ('boktrykkerkunst',),
'boktrykkerkunster': ('boktrykkerkunst',),
'bokverden': ('bokverden',),
'bokverdenen': ('bokverden',),
'bokverdenene': ('bokverden',),
'bokverdener': ('bokverden',),
'bol': ('bol',),
'bolen': ('bol',),
'bolene': ('bol',),
'boler': ('bol',),
'bol': ('bol',),
'bola': ('bol',),
'bolene': ('bol',),
'bolet': ('bol',),
'bolero': ('bolero',),
'boleroen': ('bolero',),
'boleroene': ('bolero',),
'boleroer': ('bolero',),
'bolig': ('bolig',),
'boligen': ('bolig',),
'boligene': ('bolig',),
'boliger': ('bolig',),
'boligblokk': ('boligblokk',),
'boligblokka': ('boligblokk',),
'boligblokken': ('boligblokk',),
'boligblokkene': ('boligblokk',),
'boligblokker': ('boligblokk',),
'boligbyggelag': ('boligbyggelag',),
'boligbyggelaga': ('boligbyggelag',),
'boligbyggelagene': ('boligbyggelag',),
'boligbyggelaget': ('boligbyggelag',),
'boligbygging': ('boligbygging',),
'boligbygginga': ('boligbygging',),
'boligbyggingen': ('boligbygging',),
'boligbyggingene': ('boligbygging',),
'boligbygginger': ('boligbygging',),
'boligdekk': ('boligdekk',),
'boligdekka': ('boligdekk',),
'boligdekkene': ('boligdekk',),
'boligdekket': ('boligdekk',),
'boligfelt': ('boligfelt',),
'boligfelta': ('boligfelt',),
'boligfeltene': ('boligfelt',),
'boligfelter': ('boligfelt',),
'boligfeltet': ('boligfelt',),
'boligfinansiering': ('boligfinansiering',),
'boligfinansieringa': ('boligfinansiering',),
'boligfinansieringen': ('boligfinansiering',),
'boligfinansieringene': ('boligfinansiering',),
'boligfinansieringer': ('boligfinansiering',),
'boligforhold': ('boligforhold',),
'boligforholda': ('boligforhold',),
'boligforholdene': ('boligforhold',),
'boligforholdet': ('boligforhold',),
'boligformidling': ('boligformidling',),
'boligformidlinga': ('boligformidling',),
'boligformidlingen': ('boligformidling',),
'boligformidlingene': ('boligformidling',),
'boligformidlinger': ('boligformidling',),
'bolighai': ('bolighai',),
'bolighaien': ('bolighai',),
'bolighaiene': ('bolighai',),
'bolighaier': ('bolighai',),
'boliglån': ('boliglån',),
'boliglåna': ('boliglån',),
'boliglånene': ('boliglån',),
'boliglånet': ('boliglån',),
'boligmarked': ('boligmarked',),
'boligmarkeda': ('boligmarked',),
'boligmarkedene': ('boligmarked',),
'boligmarkeder': ('boligmarked',),
'boligmarkedet': ('boligmarked',),
'boligmarknad': ('boligmarknad',),
'boligmarknaden': ('boligmarknad',),
'boligmarknadene': ('boligmarknad',),
'boligmarknader': ('boligmarknad',),
'boligmasse': ('boligmasse',),
'boligmassen': ('boligmasse',),
'boligmassene': ('boligmasse',),
'boligmasser': ('boligmasse',),
'boligmiljø': ('boligmiljø',),
'boligmiljøa': ('boligmiljø',),
'boligmiljøene': ('boligmiljø',),
'boligmiljøer': ('boligmiljø',),
'boligmiljøet': ('boligmiljø',),
'boligområda': ('boligområde',),
'boligområde': ('boligområde',),
'boligområdene': ('boligområde',),
'boligområder': ('boligområde',),
'boligområdet': ('boligområde',),
'boligplattform': ('boligplattform',),
'boligplattforma': ('boligplattform',),
'boligplattformen': ('boligplattform',),
'boligplattformene': ('boligplattform',),
'boligplattformer': ('boligplattform',),
'boligreising': ('boligreising',),
'boligreisinga': ('boligreising',),
'boligreisingen': ('boligreising',),
'boligreisingene': ('boligreising',),
'boligreisinger': ('boligreising',),
'boligstandard': ('boligstandard',),
'boligstandarden': ('boligstandard',),
'boligstandardene': ('boligstandard',),
'boligstandarder': ('boligstandard',),
'boligtelefon': ('boligtelefon',),
'boligtelefonen': ('boligtelefon',),
'boligtelefonene': ('boligtelefon',),
'boligtelefoner': ('boligtelefon',),
'boligtomt': ('boligtomt',),
'boligtomta': ('boligtomt',),
'boligtomten': ('boligtomt',),
'boligtomtene': ('boligtomt',),
'boligtomter': ('boligtomt',),
'bolivianer': ('bolivianer',),
'bolivianere': ('bolivianer',),
'bolivianeren': ('bolivianer',),
'bolivianerer': ('bolivianer',),
'bolivianerne': ('bolivianer',),
'bolk': ('bolk',),
'bolken': ('bolk',),
'bolkene': ('bolk',),
'bolker': ('bolk',),
'bolle': ('bolle',),
'bollen': ('bolle',),
'bollene': ('bolle',),
'boller': ('bolle',),
'bolle': ('bolle',),
'bollen': ('bolle',),
'bollene': ('bolle',),
'boller': ('bolle',),
'bolleansikt': ('bolleansikt',),
'bolleansikta': ('bolleansikt',),
'bolleansiktene': ('bolleansikt',),
'bolleansikter': ('bolleansikt',),
'bolleansiktet': ('bolleansikt',),
'bolledeig': ('bolledeig',),
'bolledeigen': ('bolledeig',),
'bolledeigene': ('bolledeig',),
'bolledeiger': ('bolledeig',),
'bollekinn': ('bollekinn',),
'bollekinna': ('bollekinn',),
'bollekinnene': ('bollekinn',),
'bollekinner': ('bollekinn',),
'bollekinnet': ('bollekinn',),
'bolsjevik': ('bolsjevik',),
'bolsjeviken': ('bolsjevik',),
'bolsjevikene': ('bolsjevik',),
'bolsjeviker': ('bolsjevik',),
'bolsok': ('bolsok',),
'bolsoken': ('bolsok',),
'bolsokene': ('bolsok',),
'bolsoker': ('bolsok',),
'bolt': ('bolt',),
'bolten': ('bolt',),
'boltene': ('bolt',),
'bolter': ('bolt',),
'bolverk': ('bolverk',),
'bolverka': ('bolverk',),
'bolverkene': ('bolverk',),
'bolverker': ('bolverk',),
'bolverket': ('bolverk',),
'bomaskin': ('bomaskin',),
'bomaskina': ('bomaskin',),
'bomaskinen': ('bomaskin',),
'bomaskinene': ('bomaskin',),
'bomaskiner': ('bomaskin',),
'bombardement': ('bombardement',),
'bombardementa': ('bombardement',),
'bombardementene': ('bombardement',),
'bombardementer': ('bombardement',),
'bombardementet': ('bombardement',),
'bombasin': ('bombasin',),
'bombasina': ('bombasin',),
'bombasinen': ('bombasin',),
'bombasinene': ('bombasin',),
'bombasiner': ('bombasin',),
'bombasinet': ('bombasin',),
'bombast': ('bombast',),
'bombasten': ('bombast',),
'bombastene': ('bombast',),
'bombaster': ('bombast',),
'bomba': ('bombe',),
'bombe': ('bombe',),
'bomben': ('bombe',),
'bombene': ('bombe',),
'bomber': ('bombe',),
'bombeangrep': ('bombeangrep',),
'bombeangrepa': ('bombeangrep',),
'bombeangrepene': ('bombeangrep',),
'bombeangrepet': ('bombeangrep',),
'bombeattentat': ('bombeattentat',),
'bombeattentata': ('bombeattentat',),
'bombeattentatene': ('bombeattentat',),
'bombeattentater': ('bombeattentat',),
'bombeattentatet': ('bombeattentat',),
'bombefly': ('bombefly',),
'bombeflya': ('bombefly',),
'bombeflyene': ('bombefly',),
'bombeflyet': ('bombefly',),
'bombekaster': ('bombekaster',),
'bombekastere': ('bombekaster',),
'bombekasteren': ('bombekaster',),
'bombekasterer': ('bombekaster',),
'bombekasterne': ('bombekaster',),
'bomber': ('bomber',),
'bombere': ('bomber',),
'bomberen': ('bomber',),
'bomberer': ('bomber',),
'bomberne': ('bomber',),
'bomberegn': ('bomberegn',),
'bomberegna': ('bomberegn',),
'bomberegnene': ('bomberegn',),
'bomberegnet': ('bomberegn',),
'bomberom': ('bomberom',),
'bomberomma': ('bomberom',),
'bomberommene': ('bomberom',),
'bomberommet': ('bomberom',),
'bomkast': ('bomkast',),
'bomkasta': ('bomkast',),
'bomkastene': ('bomkast',),
'bomkastet': ('bomkast',),
'bomma': ('bomme',),
'bomme': ('bomme',),
'bommen': ('bomme',),
'bommene': ('bomme',),
'bommer': ('bomme',),
'bommer': ('bommer',),
'bommere': ('bommer',),
'bommeren': ('bommer',),
'bommerer': ('bommer',),
'bommerne': ('bommer',),
'bommert': ('bommert',),
'bommerten': ('bommert',),
'bommertene': ('bommert',),
'bommerter': ('bommert',),
'bommesi': ('bommesi',),
'bommesien': ('bommesi',),
'bommesiene': ('bommesi',),
'bommesier': ('bommesi',),
'bomolja': ('bomolje',),
'bomolje': ('bomolje',),
'bomoljen': ('bomolje',),
'bomoljene': ('bomolje',),
'bomoljer': ('bomolje',),
'bompengene': ('bompenger',),
'bompenger': ('bompenger',),
'boms': ('boms',),
'bomsen': ('boms',),
'bomsene': ('boms',),
'bomser': ('boms',),
'bomskott': ('bomskott',),
'bomskotta': ('bomskott',),
'bomskottene': ('bomskott',),
'bomskottet': ('bomskott',),
'bomskudd': ('bomskudd',),
'bomskudda': ('bomskudd',),
'bomskuddene': ('bomskudd',),
'bomskuddet': ('bomskudd',),
'bomtur': ('bomtur',),
'bomturen': ('bomtur',),
'bomturene': ('bomtur',),
'bomturer': ('bomtur',),
'bomull': ('bomull',),
'bomulla': ('bomull',),
'bomullen': ('bomull',),
'bomullene': ('bomull',),
'bomuller': ('bomull',),
'bomullsgarn': ('bomullsgarn',),
'bomullsgarna': ('bomullsgarn',),
'bomullsgarnene': ('bomullsgarn',),
'bomullsgarnet': ('bomullsgarn',),
'bomullsgenser': ('bomullsgenser',),
'bomullsgensere': ('bomullsgenser',),
'bomullsgenseren': ('bomullsgenser',),
'bomullsgenserer': ('bomullsgenser',),
'bomullsgenserne': ('bomullsgenser',),
'bomullsplantasje': ('bomullsplantasje',),
'bomullsplantasjen': ('bomullsplantasje',),
'bomullsplantasjene': ('bomullsplantasje',),
'bomullsplantasjer': ('bomullsplantasje',),
'bomullsplanta': ('bomullsplante',),
'bomullsplante': ('bomullsplante',),
'bomullsplanten': ('bomullsplante',),
'bomullsplantene': ('bomullsplante',),
'bomullsplanter': ('bomullsplante',),
'bomullsstoff': ('bomullsstoff',),
'bomullsstoffa': ('bomullsstoff',),
'bomullsstoffene': ('bomullsstoff',),
'bomullsstoffer': ('bomullsstoff',),
'bomullsstoffet': ('bomullsstoff',),
'bomvakt': ('bomvakt',),
'bomvakta': ('bomvakt',),
'bomvakten': ('bomvakt',),
'bomvaktene': ('bomvakt',),
'bomvakter': ('bomvakt',),
'bomveg': ('bomveg',),
'bomvegen': ('bomveg',),
'bomvegene': ('bomveg',),
'bomveger': ('bomveg',),
'bomvei': ('bomvei',),
'bomveien': ('bomvei',),
'bomveiene': ('bomvei',),
'bomveier': ('bomvei',),
'bonde': ('bonde',),
'bonden': ('bonde',),
'bøndene': ('bonde',),
'bønder': ('bonde',),
'bondeanger': ('bondeanger',),
'bondeangere': ('bondeanger',),
'bondeangeren': ('bondeanger',),
'bondeangerer': ('bondeanger',),
'bondeangerne': ('bondeanger',),
'bondeangre': ('bondeanger',),
'bondeangrene': ('bondeanger',),
'bondeangrer': ('bondeanger',),
'bondefanger': ('bondefanger',),
'bondefangere': ('bondefanger',),
'bondefangeren': ('bondefanger',),
'bondefangerer': ('bondefanger',),
'bondefangerne': ('bondefanger',),
'bondefangeri': ('bondefangeri',),
'bondefangeria': ('bondefangeri',),
'bondefangeriene': ('bondefangeri',),
'bondefangerier': ('bondefangeri',),
'bondefangeriet': ('bondefangeri',),
'bondefortelling': ('bondefortelling',),
'bondefortellinga': ('bondefortelling',),
'bondefortellingen': ('bondefortelling',),
'bondefortellingene': ('bondefortelling',),
'bondefortellinger': ('bondefortelling',),
'bondegard': ('bondegard',),
'bondegarden': ('bondegard',),
'bondegardene': ('bondegard',),
'bondegarder': ('bondegard',),
'bondegardsferie': ('bondegardsferie',),
'bondegardsferien': ('bondegardsferie',),
'bondegardsferiene': ('bondegardsferie',),
'bondegardsferier': ('bondegardsferie',),
'bondegård': ('bondegård',),
'bondegården': ('bondegård',),
'bondegårdene': ('bondegård',),
'bondegårder': ('bondegård',),
'bondegårdsferie': ('bondegårdsferie',),
'bondegårdsferien': ('bondegårdsferie',),
'bondegårdsferiene': ('bondegårdsferie',),
'bondegårdsferier': ('bondegårdsferie',),
'bondekultur': ('bondekultur',),
'bondekulturen': ('bondekultur',),
'bondekulturene': ('bondekultur',),
'bondekulturer': ('bondekultur',),
'bondelag': ('bondelag',),
'bondelaga': ('bondelag',),
'bondelagene': ('bondelag',),
'bondelaget': ('bondelag',),
'bondepika': ('bondepike',),
'bondepike': ('bondepike',),
'bondepiken': ('bondepike',),
'bondepikene': ('bondepike',),
'bondepiker': ('bondepike',),
'bonderomantikk': ('bonderomantikk',),
'bonderomantikken': ('bonderomantikk',),
'bonderomantikkene': ('bonderomantikk',),
'bonderomantikker': ('bonderomantikk',),
'bondevett': ('bondevett',),
'bondevetta': ('bondevett',),
'bondevettene': ('bondevett',),
'bondevettet': ('bondevett',),
'bonevoks': ('bonevoks',),
'bonevoksa': ('bonevoks',),
'bonevoksen': ('bonevoks',),
'bonevoksene': ('bonevoks',),
'bonevokser': ('bonevoks',),
'bonevokset': ('bonevoks',),
'bong': ('bong',),
'bongen': ('bong',),
'bongene': ('bong',),
'bonger': ('bong',),
'bongbong': ('bongbong',),
'bongbongen': ('bongbong',),
'bongbongene': ('bongbong',),
'bongbonger': ('bongbong',),
'bongotromma': ('bongotromme',),
'bongotromme': ('bongotromme',),
'bongotrommen': ('bongotromme',),
'bongotrommene': ('bongotromme',),
'bongotrommer': ('bongotromme',),
'bonitet': ('bonitet',),
'boniteten': ('bonitet',),
'bonitetene': ('bonitet',),
'boniteter': ('bonitet',),
'bonjour': ('bonjour',),
'bonjouren': ('bonjour',),
'bonjourene': ('bonjour',),
'bonjourer': ('bonjour',),
'bonmot': ('bonmot',),
'bonmota': ('bonmot',),
'bonmotene': ('bonmot',),
'bonmoter': ('bonmot',),
'bonmotet': ('bonmot',),
'bonus': ('bonus',),
'bonusen': ('bonus',),
'bonusene': ('bonus',),
'bonuser': ('bonus',),
'boogie-woogie': ('boogie-woogie',),
'boogie-woogien': ('boogie-woogie',),
'boogie-woogiene': ('boogie-woogie',),
'boogie-woogier': ('boogie-woogie',),
'bookmaker': ('bookmaker',),
'bookmakere': ('bookmaker',),
'bookmakeren': ('bookmaker',),
'bookmakerer': ('bookmaker',),
'bookmakerne': ('bookmaker',),
'boom': ('boom',),
'boomen': ('boom',),
'boomene': ('boom',),
'boomer': ('boom',),
'booster': ('booster',),
'boostere': ('booster',),
'boosteren': ('booster',),
'boosterer': ('booster',),
'boosterne': ('booster',),
'bop': ('bop',),
'bopen': ('bop',),
'bopene': ('bop',),
'boper': ('bop',),
'bopel': ('bopel',),
'bopelen': ('bopel',),
'bopelene': ('bopel',),
'bopeler': ('bopel',),
'boplikt': ('boplikt',),
'boplikta': ('boplikt',),
'boplikten': ('boplikt',),
'bopliktene': ('boplikt',),
'boplikter': ('boplikt',),
'bor': ('bor',),
'bora': ('bor',),
'boren': ('bor',),
'borene': ('bor',),
'boret': ('bor',),
'boraks': ('boraks',),
'boraksen': ('boraks',),
'boraksene': ('boraks',),
'borakser': ('boraks',),
'borat': ('borat',),
'borata': ('borat',),
'boratene': ('borat',),
'borater': ('borat',),
'boratet': ('borat',),
'bord': ('bord',),
'borden': ('bord',),
'bordene': ('bord',),
'border': ('bord',),
'bord': ('bord',),
'borden': ('bord',),
'bordene': ('bord',),
'border': ('bord',),
'bord': ('bord',),
'borda': ('bord',),
'bordene': ('bord',),
'border': ('bord',),
'bordet': ('bord',),
'bordbein': ('bordbein',),
'bordbeina': ('bordbein',),
'bordbeinene': ('bordbein',),
'bordbeinet': ('bordbein',),
'bordben': ('bordben',),
'bordbena': ('bordben',),
'bordbenene': ('bordben',),
'bordbenet': ('bordben',),
'bordbønn': ('bordbønn',),
'bordbønna': ('bordbønn',),
'bordbønnen': ('bordbønn',),
'bordbønnene': ('bordbønn',),
'bordbønner': ('bordbønn',),
'borddama': ('borddame',),
'borddame': ('borddame',),
'borddamen': ('borddame',),
'borddamene': ('borddame',),
'borddamer': ('borddame',),
'borddans': ('borddans',),
'borddansen': ('borddans',),
'borddansene': ('borddans',),
'borddanser': ('borddans',),
'borda': ('borde',),
'borde': ('borde',),
'borden': ('borde',),
'bordene': ('borde',),
'border': ('borde',),
'borda': ('borde',),
'borde': ('borde',),
'borden': ('borde',),
'bordene': ('borde',),
'border': ('borde',),
'bordeaux': ('bordeaux',),
'bordeauxen': ('bordeaux',),
'bordeauxene': ('bordeaux',),
'bordeauxer': ('bordeaux',),
'bordeauxvin': ('bordeauxvin',),
'bordeauxvinen': ('bordeauxvin',),
'bordeauxvinene': ('bordeauxvin',),
'bordeauxviner': ('bordeauxvin',),
'bordell': ('bordell',),
'bordella': ('bordell',),
'bordellen': ('bordell',),
'bordellene': ('bordell',),
'bordeller': ('bordell',),
'bordellet': ('bordell',),
'bordellkvarter': ('bordellkvarter',),
'bordellkvartera': ('bordellkvarter',),
'bordellkvarterene': ('bordellkvarter',),
'bordellkvarterer': ('bordellkvarter',),
'bordellkvarteret': ('bordellkvarter',),
'bordkalender': ('bordkalender',),
'bordkalendere': ('bordkalender',),
'bordkalenderen': ('bordkalender',),
'bordkalenderer': ('bordkalender',),
'bordkalenderne': ('bordkalender',),
'bordkalendre': ('bordkalender',),
'bordkalendrene': ('bordkalender',),
'bordkalendrer': ('bordkalender',),
'bordkavaler': ('bordkavaler',),
'bordkavaleren': ('bordkavaler',),
'bordkavalerene': ('bordkavaler',),
'bordkavalerer': ('bordkavaler',),
'bordkledning': ('bordkledning',),
'bordkledninga': ('bordkledning',),
'bordkledningen': ('bordkledning',),
'bordkledningene': ('bordkledning',),
'bordkledninger': ('bordkledning',),
'bordkort': ('bordkort',),
'bordkorta': ('bordkort',),
'bordkortene': ('bordkort',),
'bordkortet': ('bordkort',),
'bordpakning': ('bordpakning',),
'bordpakninga': ('bordpakning',),
'bordpakningen': ('bordpakning',),
'bordpakningene': ('bordpakning',),
'bordpakninger': ('bordpakning',),
'bordsetning': ('bordsetning',),
'bordsetninga': ('bordsetning',),
'bordsetningen': ('bordsetning',),
'bordsetningene': ('bordsetning',),
'bordsetninger': ('bordsetning',),
'bordskikk': ('bordskikk',),
'bordskikken': ('bordskikk',),
'bordskikkene': ('bordskikk',),
'bordskikker': ('bordskikk',),
'bordtale': ('bordtale',),
'bordtalen': ('bordtale',),
'bordtalene': ('bordtale',),
'bordtaler': ('bordtale',),
'bordtennis': ('bordtennis',),
'bordtennisen': ('bordtennis',),
'bordtennisene': ('bordtennis',),
'bordtenniser': ('bordtennis',),
'bordvers': ('bordvers',),
'bordversa': ('bordvers',),
'bordversene': ('bordvers',),
'bordverset': ('bordvers',),
'borebille': ('borebille',),
'borebillen': ('borebille',),
'borebillene': ('borebille',),
'borebiller': ('borebille',),
'boredekk': ('boredekk',),
'boredekka': ('boredekk',),
'boredekkene': ('boredekk',),
'boredekket': ('boredekk',),
'borefartøy': ('borefartøy',),
'borefartøya': ('borefartøy',),
'borefartøyene': ('borefartøy',),
'borefartøyer': ('borefartøy',),
'borefartøyet': ('borefartøy',),
'borehol': ('borehol',),
'borehola': ('borehol',),
'boreholene': ('borehol',),
'boreholet': ('borehol',),
'borehull': ('borehull',),
'borehulla': ('borehull',),
'borehullene': ('borehull',),
'borehuller': ('borehull',),
'borehullet': ('borehull',),
'boremusling': ('boremusling',),
'boremuslingen': ('boremusling',),
'boremuslingene': ('boremusling',),
'boremuslinger': ('boremusling',),
'boreplass': ('boreplass',),
'boreplassen': ('boreplass',),
'boreplassene': ('boreplass',),
'boreplasser': ('boreplass',),
'boreplattform': ('boreplattform',),
'boreplattforma': ('boreplattform',),
'boreplattformen': ('boreplattform',),
'boreplattformene': ('boreplattform',),
'boreplattformer': ('boreplattform',),
'borerigg': ('borerigg',),
'boreriggen': ('borerigg',),
'boreriggene': ('borerigg',),
'borerigger': ('borerigg',),
'borerør': ('borerør',),
'borerøra': ('borerør',),
'borerørene': ('borerør',),
'borerøret': ('borerør',),
'boresikringsventil': ('boresikringsventil',),
'boresikringsventilen': ('boresikringsventil',),
'boresikringsventilene': ('boresikringsventil',),
'boresikringsventiler': ('boresikringsventil',),
'boreskip': ('boreskip',),
'boreskipa': ('boreskip',),
'boreskipene': ('boreskip',),
'boreskipet': ('boreskip',),
'boreslam': ('boreslam',),
'boreslamma': ('boreslam',),
'boreslammene': ('boreslam',),
'boreslammet': ('boreslam',),
'borestart': ('borestart',),
'borestarten': ('borestart',),
'borestartene': ('borestart',),
'borestarter': ('borestart',),
'borestreng': ('borestreng',),
'borestrengen': ('borestreng',),
'borestrengene': ('borestreng',),
'borestrenger': ('borestreng',),
'borettslag': ('borettslag',),
'borettslaga': ('borettslag',),
'borettslagene': ('borettslag',),
'borettslaget': ('borettslag',),
'boretårn': ('boretårn',),
'boretårna': ('boretårn',),
'boretårnene': ('boretårn',),
'boretårnet': ('boretårn',),
'borg': ('borg',),
'borga': ('borg',),
'borgen': ('borg',),
'borgene': ('borg',),
'borger': ('borg',),
'borg': ('borg',),
'borger': ('borger',),
'borgere': ('borger',),
'borgeren': ('borger',),
'borgerer': ('borger',),
'borgerne': ('borger',),
'borgerbrev': ('borgerbrev',),
'borgerbreva': ('borgerbrev',),
'borgerbrevene': ('borgerbrev',),
'borgerbrever': ('borgerbrev',),
'borgerbrevet': ('borgerbrev',),
'borgerdåd': ('borgerdåd',),
'borgerdåden': ('borgerdåd',),
'borgerdådene': ('borgerdåd',),
'borgerdåder': ('borgerdåd',),
'borgerdådsmedalje': ('borgerdådsmedalje',),
'borgerdådsmedaljen': ('borgerdådsmedalje',),
'borgerdådsmedaljene': ('borgerdådsmedalje',),
'borgerdådsmedaljer': ('borgerdådsmedalje',),
'borgerkrig': ('borgerkrig',),
'borgerkrigen': ('borgerkrig',),
'borgerkrigene': ('borgerkrig',),
'borgerkriger': ('borgerkrig',),
'borgerkrigstilstand': ('borgerkrigstilstand',),
'borgerkrigstilstanden': ('borgerkrigstilstand',),
'borgerkrigstilstandene': ('borgerkrigstilstand',),
'borgerkrigstilstander': ('borgerkrigstilstand',),
'borgermester': ('borgermester',),
'borgermestere': ('borgermester',),
'borgermesteren': ('borgermester',),
'borgermesterer': ('borgermester',),
'borgermesterne': ('borgermester',),
'borgermestre': ('borgermester',),
'borgermestrene': ('borgermester',),
'borgermestrer': ('borgermester',),
'borgerplikt': ('borgerplikt',),
'borgerplikta': ('borgerplikt',),
'borgerplikten': ('borgerplikt',),
'borgerpliktene': ('borgerplikt',),
'borgerplikter': ('borgerplikt',),
'borgerrett': ('borgerrett',),
'borgerretten': ('borgerrett',),
'borgerrettene': ('borgerrett',),
'borgerretter': ('borgerrett',),
'borgerrettsbevegelse': ('borgerrettsbevegelse',),
'borgerrettsbevegelsen': ('borgerrettsbevegelse',),
'borgerrettsbevegelsene': ('borgerrettsbevegelse',),
'borgerrettsbevegelser': ('borgerrettsbevegelse',),
'borgerskap': ('borgerskap',),
'borgerskapa': ('borgerskap',),
'borgerskapene': ('borgerskap',),
'borgerskapet': ('borgerskap',),
'borgertog': ('borgertog',),
'borgertoga': ('borgertog',),
'borgertogene': ('borgertog',),
'borgertoget': ('borgertog',),
'borgerånd': ('borgerånd',),
'borgerånden': ('borgerånd',),
'borgeråndene': ('borgerånd',),
'borgerånder': ('borgerånd',),
'borgfred': ('borgfred',),
'borgfreden': ('borgfred',),
'borgfredene': ('borgfred',),
'borgfreder': ('borgfred',),
'borgis': ('borgis',),
'borgisen': ('borgis',),
'borgisene': ('borgis',),
'borgiser': ('borgis',),
'borgruin': ('borgruin',),
'borgruinen': ('borgruin',),
'borgruinene': ('borgruin',),
'borgruiner': ('borgruin',),
'borgstova': ('borgstove',),
'borgstove': ('borgstove',),
'borgstoven': ('borgstove',),
'borgstovene': ('borgstove',),
'borgstover': ('borgstove',),
'borgstua': ('borgstue',),
'borgstue': ('borgstue',),
'borgstuen': ('borgstue',),
'borgstuene': ('borgstue',),
'borgstuer': ('borgstue',),
'boring': ('boring',),
'boringa': ('boring',),
'boringen': ('boring',),
'boringene': ('boring',),
'boringer': ('boring',),
'bork': ('bork',),
'borken': ('bork',),
'borkene': ('bork',),
'borker': ('bork',),
'borkrona': ('borkrone',),
'borkrone': ('borkrone',),
'borkronen': ('borkrone',),
'borkronene': ('borkrone',),
'borkroner': ('borkrone',),
'borre': ('borre',),
'borren': ('borre',),
'borrene': ('borre',),
'borrer': ('borre',),
'borra': ('borre',),
'borre': ('borre',),
'borren': ('borre',),
'borrene': ('borre',),
'borrer': ('borre',),
'borrelås': ('borrelås',),
'borrelåsa': ('borrelås',),
'borrelåsen': ('borrelås',),
'borrelåsene': ('borrelås',),
'borrelåser': ('borrelås',),
'borrelåset': ('borrelås',),
'borsj': ('borsj',),
'borsjen': ('borsj',),
'borsjene': ('borsj',),
'borsjer': ('borsj',),
'borsyra': ('borsyre',),
'borsyre': ('borsyre',),
'borsyren': ('borsyre',),
'borsyrene': ('borsyre',),
'borsyrer': ('borsyre',),
'bortebane': ('bortebane',),
'bortebanen': ('bortebane',),
'bortebanene': ('bortebane',),
'bortebaner': ('bortebane',),
'borteboer': ('borteboer',),
'borteboere': ('borteboer',),
'borteboeren': ('borteboer',),
'borteboerer': ('borteboer',),
'borteboerne': ('borteboer',),
'borteboerstipend': ('borteboerstipend',),
'borteboerstipenda': ('borteboerstipend',),
'borteboerstipendene': ('borteboerstipend',),
'borteboerstipender': ('borteboerstipend',),
'borteboerstipendet': ('borteboerstipend',),
'borteboerstipendia': ('borteboerstipendium',),
'borteboerstipendiene': ('borteboerstipendium',),
'borteboerstipendier': ('borteboerstipendium',),
'borteboerstipendiet': ('borteboerstipendium',),
'borteboerstipendium': ('borteboerstipendium',),
'bortebuer': ('bortebuer',),
'bortebuere': ('bortebuer',),
'bortebueren': ('bortebuer',),
'bortebuerer': ('bortebuer',),
'bortebuerne': ('bortebuer',),
'bortebuerstipend': ('bortebuerstipend',),
'bortebuerstipenda': ('bortebuerstipend',),
'bortebuerstipendene': ('bortebuerstipend',),
'bortebuerstipender': ('bortebuerstipend',),
'bortebuerstipendet': ('bortebuerstipend',),
'bortebuerstipendia': ('bortebuerstipendium',),
'bortebuerstipendiene': ('bortebuerstipendium',),
'bortebuerstipendier': ('bortebuerstipendium',),
'bortebuerstipendiet': ('bortebuerstipendium',),
'bortebuerstipendium': ('bortebuerstipendium',),
'bortekamp': ('bortekamp',),
'bortekampen': ('bortekamp',),
'bortekampene': ('bortekamp',),
'bortekamper': ('bortekamp',),
'bortfall': ('bortfall',),
'bortfalla': ('bortfall',),
'bortfallene': ('bortfall',),
'bortfallet': ('bortfall',),
'bortgang': ('bortgang',),
'bortgangen': ('bortgang',),
'bortgangene': ('bortgang',),
'bortganger': ('bortgang',),
'bortleia': ('bortleie',),
'bortleie': ('bortleie',),
'bortleien': ('bortleie',),
'bortleiene': ('bortleie',),
'bortleier': ('bortleie',),
'borvann': ('borvann',),
'borvanna': ('borvann',),
'borvannene': ('borvann',),
'borvannet': ('borvann',),
'borvaselin': ('borvaselin',),
'borvaselinen': ('borvaselin',),
'borvaselinene': ('borvaselin',),
'borvaseliner': ('borvaselin',),
'borvatn': ('borvatn',),
'borvatna': ('borvatn',),
'borvatnene': ('borvatn',),
'borvatnet': ('borvatn',),
'borvinda': ('borvinde',),
'borvinde': ('borvinde',),
'borvinden': ('borvinde',),
'borvindene': ('borvinde',),
'borvinder': ('borvinde',),
'bosetning': ('bosetning',),
'bosetninga': ('bosetning',),
'bosetningen': ('bosetning',),
'bosetningene': ('bosetning',),
'bosetninger': ('bosetning',),
'bosetningskart': ('bosetningskart',),
'bosetningskarta': ('bosetningskart',),
'bosetningskartene': ('bosetningskart',),
'bosetningskarter': ('bosetningskart',),
'bosetningskartet': ('bosetningskart',),
'bosetningsmønster': ('bosetningsmønster',),
'bosetningsmønsteret': ('bosetningsmønster',),
'bosetningsmønstra': ('bosetningsmønster',),
'bosetningsmønstre': ('bosetningsmønster',),
'bosetningsmønstrene': ('bosetningsmønster',),
'bosetningsmønstret': ('bosetningsmønster',),
'bosetting': ('bosetting',),
'bosettinga': ('bosetting',),
'bosettingen': ('bosetting',),
'bosettingene': ('bosetting',),
'bosettinger': ('bosetting',),
'bosettingskart': ('bosettingskart',),
'bosettingskarta': ('bosettingskart',),
'bosettingskartene': ('bosettingskart',),
'bosettingskarter': ('bosettingskart',),
'bosettingskartet': ('bosettingskart',),
'bosettingsmønster': ('bosettingsmønster',),
'bosettingsmønsteret': ('bosettingsmønster',),
'bosettingsmønstra': ('bosettingsmønster',),
'bosettingsmønstre': ('bosettingsmønster',),
'bosettingsmønstrene': ('bosettingsmønster',),
'bosettingsmønstret': ('bosettingsmønster',),
'boslodd': ('boslodd',),
'boslodden': ('boslodd',),
'bosloddene': ('boslodd',),
'boslodder': ('boslodd',),
'bosnier': ('bosnier',),
'bosniere': ('bosnier',),
'bosnieren': ('bosnier',),
'bosnierer': ('bosnier',),
'bosnierne': ('bosnier',),
'boss': ('boss',),
'bossen': ('boss',),
'bossene': ('boss',),
'bosser': ('boss',),
'boss': ('boss',),
'bossa': ('boss',),
'bossene': ('boss',),
'bosset': ('boss',),
'bossa nova': ('bossa nova',),
'bossa novaen': ('bossa nova',),
'bossa novaene': ('bossa nova',),
'bossa novaer': ('bossa nova',),
'bosted': ('bosted',),
'bostedene': ('bosted',),
'bosteder': ('bosted',),
'bostedet': ('bosted',),
'bostedsadressa': ('bostedsadresse',),
'bostedsadresse': ('bostedsadresse',),
'bostedsadressen': ('bostedsadresse',),
'bostedsadressene': ('bostedsadresse',),
'bostedsadresser': ('bostedsadresse',),
'bostedskommune': ('bostedskommune',),
'bostedskommunen': ('bostedskommune',),
'bostedskommunene': ('bostedskommune',),
'bostedskommuner': ('bostedskommune',),
'boston': ('boston',),
'bostonen': ('boston',),
'bostonene': ('boston',),
'bostoner': ('boston',),
'bostyra': ('bostyre',),
'bostyre': ('bostyre',),
'bostyrene': ('bostyre',),
'bostyrer': ('bostyre',),
'bostyret': ('bostyre',),
'bostyrer': ('bostyrer',),
'bostyrere': ('bostyrer',),
'bostyreren': ('bostyrer',),
'bostyrerer': ('bostyrer',),
'bostyrerne': ('bostyrer',),
'bostøtta': ('bostøtte',),
'bostøtte': ('bostøtte',),
'bostøtten': ('bostøtte',),
'bostøttene': ('bostøtte',),
'bostøtter': ('bostøtte',),
'bot': ('bot',),
'bota': ('bot',),
'boten': ('bot',),
'bøtene': ('bot',),
'bøter': ('bot',),
'botaniker': ('botaniker',),
'botanikere': ('botaniker',),
'botanikeren': ('botaniker',),
'botanikerer': ('botaniker',),
'botanikerne': ('botaniker',),
'botanikk': ('botanikk',),
'botanikken': ('botanikk',),
'botanikkene': ('botanikk',),
'botanikker': ('botanikk',),
'botemiddel': ('botemiddel',),
'botemiddelet': ('botemiddel',),
'botemidla': ('botemiddel',),
'botemidlene': ('botemiddel',),
'botemidler': ('botemiddel',),
'botemidlet': ('botemiddel',),
'botevon': ('botevon',),
'botevona': ('botevon',),
'botevonen': ('botevon',),
'botevonene': ('botevon',),
'botevoner': ('botevon',),
'botfor': ('botfor',),
'botforen': ('botfor',),
'botforene': ('botfor',),
'botforer': ('botfor',),
'botid': ('botid',),
'botida': ('botid',),
'botiden': ('botid',),
'botidene': ('botid',),
'botider': ('botid',),
'botn': ('botn',),
'botnen': ('botn',),
'botnene': ('botn',),
'botner': ('botn',),
'botn': ('botn',),
'botnen': ('botn',),
'botnene': ('botn',),
'botner': ('botn',),
'botnband': ('botnband',),
'botnbanda': ('botnband',),
'botnbandene': ('botnband',),
'botnbandet': ('botnband',),
'botnbord': ('botnbord',),
'botnborda': ('botnbord',),
'botnbordene': ('botnbord',),
'botnborder': ('botnbord',),
'botnbordet': ('botnbord',),
'botnbånd': ('botnbånd',),
'botnbånda': ('botnbånd',),
'botnbåndene': ('botnbånd',),
'botnbåndet': ('botnbånd',),
'botnfall': ('botnfall',),
'botnfalla': ('botnfall',),
'botnfallene': ('botnfall',),
'botnfallet': ('botnfall',),
'botnfisk': ('botnfisk',),
'botnfisken': ('botnfisk',),
'botnfiskene': ('botnfisk',),
'botnfisker': ('botnfisk',),
'botnflata': ('botnflate',),
'botnflate': ('botnflate',),
'botnflaten': ('botnflate',),
'botnflatene': ('botnflate',),
'botnflater': ('botnflate',),
'botnlag': ('botnlag',),
'botnlaga': ('botnlag',),
'botnlagene': ('botnlag',),
'botnlaget': ('botnlag',),
'botnløshet': ('botnløshet',),
'botnløsheta': ('botnløshet',),
'botnløsheten': ('botnløshet',),
'botnløshetene': ('botnløshet',),
'botnløsheter': ('botnløshet',),
'botnløysa': ('botnløyse',),
'botnløyse': ('botnløyse',),
'botnløysen': ('botnløyse',),
'botnløysene': ('botnløyse',),
'botnløyser': ('botnløyse',),
'botnmorene': ('botnmorene',),
'botnmorenen': ('botnmorene',),
'botnmorenene': ('botnmorene',),
'botnmorener': ('botnmorene',),
'botnnivå': ('botnnivå',),
'botnnivåa': ('botnnivå',),
'botnnivåene': ('botnnivå',),
'botnnivåer': ('botnnivå',),
'botnnivået': ('botnnivå',),
'botnpanna': ('botnpanne',),
'botnpanne': ('botnpanne',),
'botnpannen': ('botnpanne',),
'botnpannene': ('botnpanne',),
'botnpanner': ('botnpanne',),
'botnrekord': ('botnrekord',),
'botnrekorden': ('botnrekord',),
'botnrekordene': ('botnrekord',),
'botnrekorder': ('botnrekord',),
'botnstoff': ('botnstoff',),
'botnstoffa': ('botnstoff',),
'botnstoffene': ('botnstoff',),
'botnstoffer': ('botnstoff',),
'botnstoffet': ('botnstoff',),
'botnstrid': ('botnstrid',),
'botnstriden': ('botnstrid',),
'botnstridene': ('botnstrid',),
'botnstrider': ('botnstrid',),
'botolvsmess': ('botolvsmess',),
'botolvsmess': ('botolvsmess',),
'botolvsmesse': ('botolvsmesse',),
'botsbenk': ('botsbenk',),
'botsbenken': ('botsbenk',),
'botsbenkene': ('botsbenk',),
'botsbenker': ('botsbenk',),
'botsdag': ('botsdag',),
'botsdagen': ('botsdag',),
'botsdagene': ('botsdag',),
'botsdager': ('botsdag',),
'botsfengsel': ('botsfengsel',),
'botsfengselet': ('botsfengsel',),
'botsfengsla': ('botsfengsel',),
'botsfengslene': ('botsfengsel',),
'botsfengsler': ('botsfengsel',),
'botsfengslet': ('botsfengsel',),
'botsgang': ('botsgang',),
'botsgangen': ('botsgang',),
'botsgangene': ('botsgang',),
'botsganger': ('botsgang',),
'botssakrament': ('botssakrament',),
'botssakramenta': ('botssakrament',),
'botssakramentene': ('botssakrament',),
'botssakramenter': ('botssakrament',),
'botssakramentet': ('botssakrament',),
'botssalme': ('botssalme',),
'botssalmen': ('botssalme',),
'botssalmene': ('botssalme',),
'botssalmer': ('botssalme',),
'botswaner': ('botswaner',),
'botswanere': ('botswaner',),
'botswaneren': ('botswaner',),
'botswanerer': ('botswaner',),
'botswanerne': ('botswaner',),
'botsøvelse': ('botsøvelse',),
'botsøvelsen': ('botsøvelse',),
'botsøvelsene': ('botsøvelse',),
'botsøvelser': ('botsøvelse',),
'botsøving': ('botsøving',),
'botsøvinga': ('botsøving',),
'botsøvingen': ('botsøving',),
'botsøvingene': ('botsøving',),
'botsøvinger': ('botsøving',),
'bott': ('bott',),
'bottlenose': ('bottlenose',),
'bottlenosen': ('bottlenose',),
'bottlenosene': ('bottlenose',),
'bottlenoser': ('bottlenose',),
'botulisme': ('botulisme',),
'botulismen': ('botulisme',),
'botulismene': ('botulisme',),
'botulismer': ('botulisme',),
'bouclea': ('bouclé',),
'boucleen': ('bouclé',),
'boucleene': ('bouclé',),
'boucleer': ('bouclé',),
'boucleet': ('bouclé',),
'bouclé': ('bouclé',),
'boucléen': ('bouclé',),
'boucléene': ('bouclé',),
'boucléer': ('bouclé',),
'bouclégarn': ('bouclégarn',),
'bouclégarna': ('bouclégarn',),
'bouclégarnene': ('bouclégarn',),
'bouclégarnet': ('bouclégarn',),
'boucléteppa': ('boucléteppe',),
'boucléteppe': ('boucléteppe',),
'boucléteppene': ('boucléteppe',),
'bouclétepper': ('boucléteppe',),
'boucléteppet': ('boucléteppe',),
'bouillabaisse': ('bouillabaisse',),
'bouillabaissen': ('bouillabaisse',),
'bouillabaissene': ('bouillabaisse',),
'bouillabaisser': ('bouillabaisse',),
'bouquet': ('bouquet',),
'bouqueten': ('bouquet',),
'bouquetene': ('bouquet',),
'bouqueter': ('bouquet',),
'bourgeois': ('bourgeois',),
'bourgeoisen': ('bourgeois',),
'bourgeoisene': ('bourgeois',),
'bourgeoiser': ('bourgeois',),
'bourgeoisi': ('bourgeoisi',),
'bourgeoisia': ('bourgeoisi',),
'bourgeoisiene': ('bourgeoisi',),
'bourgeoisier': ('bourgeoisi',),
'bourgeoisiet': ('bourgeoisi',),
'bouzouki': ('bouzouki',),
'bouzoukien': ('bouzouki',),
'bouzoukiene': ('bouzouki',),
'bouzoukier': ('bouzouki',),
'bovenbramsegl': ('bovenbramsegl',),
'bovenbramsegla': ('bovenbramsegl',),
'bovenbramseglene': ('bovenbramsegl',),
'bovenbramseglet': ('bovenbramsegl',),
'bovenbramseil': ('bovenbramseil',),
'bovenbramseila': ('bovenbramseil',),
'bovenbramseilene': ('bovenbramseil',),
'bovenbramseilet': ('bovenbramseil',),
'bovenvekt': ('bovenvekt',),
'bovenvekta': ('bovenvekt',),
'bovenvekten': ('bovenvekt',),
'bovenvektene': ('bovenvekt',),
'bovenvekter': ('bovenvekt',),
'bow': ('bow',),
'bowen': ('bow',),
'bowene': ('bow',),
'bower': ('bow',),
'bowl': ('bowl',),
'bowlen': ('bowl',),
'bowlene': ('bowl',),
'bowler': ('bowl',),
'bowle': ('bowle',),
'bowlen': ('bowle',),
'bowlene': ('bowle',),
'bowler': ('bowle',),
'bowler': ('bowler',),
'bowlere': ('bowler',),
'bowleren': ('bowler',),
'bowlerer': ('bowler',),
'bowlerne': ('bowler',),
'bowler': ('bowler',),
'bowlere': ('bowler',),
'bowleren': ('bowler',),
'bowlerer': ('bowler',),
'bowlerne': ('bowler',),
'bowlerhatt': ('bowlerhatt',),
'bowlerhatten': ('bowlerhatt',),
'bowlerhattene': ('bowlerhatt',),
'bowlerhatter': ('bowlerhatt',),
'bowling': ('bowling',),
'bowlinga': ('bowling',),
'bowlingen': ('bowling',),
'bowlingene': ('bowling',),
'bowlinger': ('bowling',),
'bowlingbane': ('bowlingbane',),
'bowlingbanen': ('bowlingbane',),
'bowlingbanene': ('bowlingbane',),
'bowlingbaner': ('bowlingbane',),
'bowlinghall': ('bowlinghall',),
'bowlinghallen': ('bowlinghall',),
'bowlinghallene': ('bowlinghall',),
'bowlinghaller': ('bowlinghall',),
'bowlingkula': ('bowlingkule',),
'bowlingkule': ('bowlingkule',),
'bowlingkulen': ('bowlingkule',),
'bowlingkulene': ('bowlingkule',),
'bowlingkuler': ('bowlingkule',),
'bowlingspeller': ('bowlingspeller',),
'bowlingspellere': ('bowlingspeller',),
'bowlingspelleren': ('bowlingspeller',),
'bowlingspellerer': ('bowlingspeller',),
'bowlingspellerne': ('bowlingspeller',),
'bowlingspiller': ('bowlingspiller',),
'bowlingspillere': ('bowlingspiller',),
'bowlingspilleren': ('bowlingspiller',),
'bowlingspillerer': ('bowlingspiller',),
'bowlingspillerne': ('bowlingspiller',),
'boy': ('boy',),
'boyen': ('boy',),
'boyene': ('boy',),
'boyer': ('boy',),
'boysenbær': ('boysenbær',),
'boysenbæra': ('boysenbær',),
'boysenbærene': ('boysenbær',),
'boysenbæret': ('boysenbær',),
'boysenbær': ('boysenbær',),
'boysenbæra': ('boysenbær',),
'boysenbærene': ('boysenbær',),
'boysenbæret': ('boysenbær',),
'brachiopod': ('brachiopod',),
'brachiopoden': ('brachiopod',),
'brachiopodene': ('brachiopod',),
'brachiopoder': ('brachiopod',),
'bragd': ('bragd',),
'bragda': ('bragd',),
'bragden': ('bragd',),
'bragdene': ('bragd',),
'bragder': ('bragd',),
'brageløfta': ('brageløfte',),
'brageløfte': ('brageløfte',),
'brageløftene': ('brageløfte',),
'brageløfter': ('brageløfte',),
'brageløftet': ('brageløfte',),
'brageløfta': ('brageløfte',),
'brageløfte': ('brageløfte',),
'brageløftene': ('brageløfte',),
'brageløfter': ('brageløfte',),
'brageløftet': ('brageløfte',),
'braille': ('braille',),
'braillen': ('braille',),
'braillene': ('braille',),
'brailler': ('braille',),
'brailleskrift': ('brailleskrift',),
'brailleskrifta': ('brailleskrift',),
'brailleskriften': ('brailleskrift',),
'brailleskriftene': ('brailleskrift',),
'brailleskrifter': ('brailleskrift',),
'brak': ('brak',),
'braka': ('brak',),
'brakene': ('brak',),
'braket': ('brak',),
'brakett': ('brakett',),
'braketten': ('brakett',),
'brakettene': ('brakett',),
'braketter': ('brakett',),
'brakk': ('brakk',),
'brakken': ('brakk',),
'brakkene': ('brakk',),
'brakker': ('brakk',),
'brakka': ('brakke',),
'brakke': ('brakke',),
'brakken': ('brakke',),
'brakkene': ('brakke',),
'brakker': ('brakke',),
'brakkebaron': ('brakkebaron',),
'brakkebaronen': ('brakkebaron',),
'brakkebaronene': ('brakkebaron',),
'brakkebaroner': ('brakkebaron',),
'brakkeboer': ('brakkeboer',),
'brakkeboere': ('brakkeboer',),
'brakkeboeren': ('brakkeboer',),
'brakkeboerer': ('brakkeboer',),
'brakkeboerne': ('brakkeboer',),
'brakkebuer': ('brakkebuer',),
'brakkebuere': ('brakkebuer',),
'brakkebueren': ('brakkebuer',),
'brakkebuerer': ('brakkebuer',),
'brakkebuerne': ('brakkebuer',),
'brakkeby': ('brakkeby',),
'brakkebyen': ('brakkeby',),
'brakkebyene': ('brakkeby',),
'brakkebyer': ('brakkeby',),
'brakkesjef': ('brakkesjef',),
'brakkesjefen': ('brakkesjef',),
'brakkesjefene': ('brakkesjef',),
'brakkesjefer': ('brakkesjef',),
'brakkjord': ('brakkjord',),
'brakkjorda': ('brakkjord',),
'brakkjorden': ('brakkjord',),
'brakkjordene': ('brakkjord',),
'brakkjorder': ('brakkjord',),
'brakkland': ('brakkland',),
'brakklanda': ('brakkland',),
'brakklandene': ('brakkland',),
'brakklandet': ('brakkland',),
'brakkmark': ('brakkmark',),
'brakkmarka': ('brakkmark',),
'brakkmarken': ('brakkmark',),
'brakkmarkene': ('brakkmark',),
'brakkmarker': ('brakkmark',),
'brakknesa': ('brakknese',),
'brakknese': ('brakknese',),
'brakknesen': ('brakknese',),
'brakknesene': ('brakknese',),
'brakkneser': ('brakknese',),
'brakkvann': ('brakkvann',),
'brakkvanna': ('brakkvann',),
'brakkvannene': ('brakkvann',),
'brakkvannet': ('brakkvann',),
'brakkvatn': ('brakkvatn',),
'brakkvatna': ('brakkvatn',),
'brakkvatnene': ('brakkvatn',),
'brakkvatnet': ('brakkvatn',),
'braknederlag': ('braknederlag',),
'braknederlaga': ('braknederlag',),
'braknederlagene': ('braknederlag',),
'braknederlaget': ('braknederlag',),
'brakseier': ('brakseier',),
'brakseiere': ('brakseier',),
'brakseieren': ('brakseier',),
'brakseierne': ('brakseier',),
'brakseire': ('brakseier',),
'brakseirene': ('brakseier',),
'brakseirer': ('brakseier',),
'braktap': ('braktap',),
'braktapa': ('braktap',),
'braktapene': ('braktap',),
'braktapet': ('braktap',),
'brakteat': ('brakteat',),
'brakteaten': ('brakteat',),
'brakteatene': ('brakteat',),
'brakteater': ('brakteat',),
'bram': ('bram',),
'bramaisme': ('bramaisme',),
'bramaismen': ('bramaisme',),
'bramaismene': ('bramaisme',),
'bramaismer': ('bramaisme',),
'braman': ('braman',),
'bramanen': ('braman',),
'bramanene': ('braman',),
'bramaner': ('braman',),
'bramanisme': ('bramanisme',),
'bramanismen': ('bramanisme',),
'bramanismene': ('bramanisme',),
'bramanismer': ('bramanisme',),
'bramin': ('bramin',),
'braminen': ('bramin',),
'braminene': ('bramin',),
'braminer': ('bramin',),
'bramsegl': ('bramsegl',),
'bramsegla': ('bramsegl',),
'bramseglene': ('bramsegl',),
'bramseglet': ('bramsegl',),
'bramseil': ('bramseil',),
'bramseila': ('bramseil',),
'bramseilene': ('bramseil',),
'bramseilet': ('bramseil',),
'bramstang': ('bramstang',),
'bramstanga': ('bramstang',),
'bramstangen': ('bramstang',),
'bramstengene': ('bramstang',),
'bramstenger': ('bramstang',),
'brand': ('brand',),
'branden': ('brand',),
'brandene': ('brand',),
'brander': ('brand',),
'brand': ('brand',),
'branden': ('brand',),
'brandene': ('brand',),
'brander': ('brand',),
'brande': ('brande',),
'branden': ('brande',),
'brandene': ('brande',),
'brander': ('brande',),
'brander': ('brander',),
'brandere': ('brander',),
'branderen': ('brander',),
'branderer': ('brander',),
'branderne': ('brander',),
'brandy': ('brandy',),
'brandyen': ('brandy',),
'brandyene': ('brandy',),
'brandyer': ('brandy',),
'brann': ('brann',),
'brannen': ('brann',),
'brannene': ('brann',),
'branner': ('brann',),
'brannalarm': ('brannalarm',),
'brannalarmen': ('brannalarm',),
'brannalarmene': ('brannalarm',),
'brannalarmer': ('brannalarm',),
'brannbil': ('brannbil',),
'brannbilen': ('brannbil',),
'brannbilene': ('brannbil',),
'brannbiler': ('brannbil',),
'brannbomba': ('brannbombe',),
'brannbombe': ('brannbombe',),
'brannbomben': ('brannbombe',),
'brannbombene': ('brannbombe',),
'brannbomber': ('brannbombe',),
'branndør': ('branndør',),
'branndøra': ('branndør',),
'branndøren': ('branndør',),
'branndørene': ('branndør',),
'branndører': ('branndør',),
'brannfakkel': ('brannfakkel',),
'brannfakkelen': ('brannfakkel',),
'brannfaklene': ('brannfakkel',),
'brannfakler': ('brannfakkel',),
'brannforsikring': ('brannforsikring',),
'brannforsikringa': ('brannforsikring',),
'brannforsikringen': ('brannforsikring',),
'brannforsikringene': ('brannforsikring',),
'brannforsikringer': ('brannforsikring',),
'branngata': ('branngate',),
'branngate': ('branngate',),
'branngaten': ('branngate',),
'branngatene': ('branngate',),
'branngater': ('branngate',),
'branngavl': ('branngavl',),
'branngavlen': ('branngavl',),
'branngavlene': ('branngavl',),
'branngavler': ('branngavl',),
'branngranat': ('branngranat',),
'branngranaten': ('branngranat',),
'branngranatene': ('branngranat',),
'branngranater': ('branngranat',),
'branninstruks': ('branninstruks',),
'branninstruksen': ('branninstruks',),
'branninstruksene': ('branninstruks',),
'branninstrukser': ('branninstruks',),
'brannkassa': ('brannkasse',),
'brannkasse': ('brannkasse',),
'brannkassen': ('brannkasse',),
'brannkassene': ('brannkasse',),
'brannkasser': ('brannkasse',),
'brannkorps': ('brannkorps',),
'brannkorpsa': ('brannkorps',),
'brannkorpsene': ('brannkorps',),
'brannkorpset': ('brannkorps',),
'brannlilja': ('brannlilje',),
'brannlilje': ('brannlilje',),
'brannliljen': ('brannlilje',),
'brannliljene': ('brannlilje',),
'brannliljer': ('brannlilje',),
'brannmann': ('brannmann',),
'brannmannen': ('brannmann',),
'brannmenn': ('brannmann',),
'brannmennene': ('brannmann',),
'brannmannskap': ('brannmannskap',),
'brannmannskapa': ('brannmannskap',),
'brannmannskapene': ('brannmannskap',),
'brannmannskaper': ('brannmannskap',),
'brannmannskapet': ('brannmannskap',),
'brannmannsløft': ('brannmannsløft',),
'brannmannsløfta': ('brannmannsløft',),
'brannmannsløftene': ('brannmannsløft',),
'brannmannsløftet': ('brannmannsløft',),
'brannmester': ('brannmester',),
'brannmestere': ('brannmester',),
'brannmesteren': ('brannmester',),
'brannmesterer': ('brannmester',),
'brannmesterne': ('brannmester',),
'brannmestre': ('brannmester',),
'brannmestrene': ('brannmester',),
'brannmestrer': ('brannmester',),
'brannmur': ('brannmur',),
'brannmuren': ('brannmur',),
'brannmurene': ('brannmur',),
'brannmurer': ('brannmur',),
'brannrør': ('brannrør',),
'brannrøra': ('brannrør',),
'brannrørene': ('brannrør',),
'brannrøret': ('brannrør',),
'brannsalva': ('brannsalve',),
'brannsalve': ('brannsalve',),
'brannsalven': ('brannsalve',),
'brannsalvene': ('brannsalve',),
'brannsalver': ('brannsalve',),
'brannsikring': ('brannsikring',),
'brannsikringa': ('brannsikring',),
'brannsikringen': ('brannsikring',),
'brannsikringene': ('brannsikring',),
'brannsikringer': ('brannsikring',),
'brannsirena': ('brannsirene',),
'brannsirene': ('brannsirene',),
'brannsirenen': ('brannsirene',),
'brannsirenene': ('brannsirene',),
'brannsirener': ('brannsirene',),
'brannskade': ('brannskade',),
'brannskaden': ('brannskade',),
'brannskadene': ('brannskade',),
'brannskader': ('brannskade',),
'brannskadetakst': ('brannskadetakst',),
'brannskadetaksten': ('brannskadetakst',),
'brannskadetakstene': ('brannskadetakst',),
'brannskadetakster': ('brannskadetakst',),
'brannslange': ('brannslange',),
'brannslangen': ('brannslange',),
'brannslangene': ('brannslange',),
'brannslanger': ('brannslange',),
'brannslokking': ('brannslokking',),
'brannslokkinga': ('brannslokking',),
'brannslokkingen': ('brannslokking',),
'brannslokkingene': ('brannslokking',),
'brannslokkinger': ('brannslokking',),
'brannslokkingsapparat': ('brannslokkingsapparat',),
'brannslokkingsapparata': ('brannslokkingsapparat',),
'brannslokkingsapparatene': ('brannslokkingsapparat',),
'brannslokkingsapparater': ('brannslokkingsapparat',),
'brannslokkingsapparatet': ('brannslokkingsapparat',),
'brannslokning': ('brannslokning',),
'brannslokninga': ('brannslokning',),
'brannslokningen': ('brannslokning',),
'brannslokningene': ('brannslokning',),
'brannslokninger': ('brannslokning',),
'brannslokningsapparat': ('brannslokningsapparat',),
'brannslokningsapparata': ('brannslokningsapparat',),
'brannslokningsapparatene': ('brannslokningsapparat',),
'brannslokningsapparater': ('brannslokningsapparat',),
'brannslokningsapparatet': ('brannslokningsapparat',),
'brannslukking': ('brannslukking',),
'brannslukkinga': ('brannslukking',),
'brannslukkingen': ('brannslukking',),
'brannslukkingene': ('brannslukking',),
'brannslukkinger': ('brannslukking',),
'brannslukkingsapparat': ('brannslukkingsapparat',),
'brannslukkingsapparata': ('brannslukkingsapparat',),
'brannslukkingsapparatene': ('brannslukkingsapparat',),
'brannslukkingsapparater': ('brannslukkingsapparat',),
'brannslukkingsapparatet': ('brannslukkingsapparat',),
'brannslukning': ('brannslukning',),
'brannslukninga': ('brannslukning',),
'brannslukningen': ('brannslukning',),
'brannslukningene': ('brannslukning',),
'brannslukninger': ('brannslukning',),
'brannslukningsapparat': ('brannslukningsapparat',),
'brannslukningsapparata': ('brannslukningsapparat',),
'brannslukningsapparatene': ('brannslukningsapparat',),
'brannslukningsapparater': ('brannslukningsapparat',),
'brannslukningsapparatet': ('brannslukningsapparat',),
'brannsperra': ('brannsperre',),
'brannsperre': ('brannsperre',),
'brannsperren': ('brannsperre',),
'brannsperrene': ('brannsperre',),
'brannsperrer': ('brannsperre',),
'brannsprøyta': ('brannsprøyte',),
'brannsprøyte': ('brannsprøyte',),
'brannsprøyten': ('brannsprøyte',),
'brannsprøytene': ('brannsprøyte',),
'brannsprøyter': ('brannsprøyte',),
'brannstasjon': ('brannstasjon',),
'brannstasjonen': ('brannstasjon',),
'brannstasjonene': ('brannstasjon',),
'brannstasjoner': ('brannstasjon',),
'brannsted': ('brannsted',),
'brannstedene': ('brannsted',),
'brannsteder': ('brannsted',),
'brannstedet': ('brannsted',),
'brannstifter': ('brannstifter',),
'brannstiftere': ('brannstifter',),
'brannstifteren': ('brannstifter',),
'brannstifterer': ('brannstifter',),
'brannstifterne': ('brannstifter',),
'brannstige': ('brannstige',),
'brannstigen': ('brannstige',),
'brannstigene': ('brannstige',),
'brannstiger': ('brannstige',),
'brannsår': ('brannsår',),
'brannsåra': ('brannsår',),
'brannsårene': ('brannsår',),
'brannsåret': ('brannsår',),
'branntakst': ('branntakst',),
'branntaksten': ('branntakst',),
'branntakstene': ('branntakst',),
'branntakster': ('branntakst',),
'branntau': ('branntau',),
'branntaua': ('branntau',),
'branntauene': ('branntau',),
'branntauer': ('branntau',),
'branntauet': ('branntau',),
'branntomt': ('branntomt',),
'branntomta': ('branntomt',),
'branntomten': ('branntomt',),
'branntomtene': ('branntomt',),
'branntomter': ('branntomt',),
'brannutrykning': ('brannutrykning',),
'brannutrykninga': ('brannutrykning',),
'brannutrykningen': ('brannutrykning',),
'brannutrykningene': ('brannutrykning',),
'brannutrykninger': ('brannutrykning',),
'brannvegg': ('brannvegg',),
'brannveggen': ('brannvegg',),
'brannveggene': ('brannvegg',),
'brannvegger': ('brannvegg',),
'brannvern': ('brannvern',),
'brannverna': ('brannvern',),
'brannvernene': ('brannvern',),
'brannvernet': ('brannvern',),
'brannvernforskrift': ('brannvernforskrift',),
'brannvernforskrifta': ('brannvernforskrift',),
'brannvernforskriften': ('brannvernforskrift',),
'brannvernforskriftene': ('brannvernforskrift',),
'brannvernforskrifter': ('brannvernforskrift',),
'brannvesen': ('brannvesen',),
'brannvesena': ('brannvesen',),
'brannvesenene': ('brannvesen',),
'brannvesener': ('brannvesen',),
'brannvesenet': ('brannvesen',),
'brannårsak': ('brannårsak',),
'brannårsaka': ('brannårsak',),
'brannårsaken': ('brannårsak',),
'brannårsakene': ('brannårsak',),
'brannårsaker': ('brannårsak',),
'bransje': ('bransje',),
'bransjen': ('bransje',),
'bransjene': ('bransje',),
'bransjer': ('bransje',),
'bransjeavtale': ('bransjeavtale',),
'bransjeavtalen': ('bransjeavtale',),
'bransjeavtalene': ('bransjeavtale',),
'bransjeavtaler': ('bransjeavtale',),
'bransjeforretning': ('bransjeforretning',),
'bransjeforretninga': ('bransjeforretning',),
'bransjeforretningen': ('bransjeforretning',),
'bransjeforretningene': ('bransjeforretning',),
'bransjeforretninger': ('bransjeforretning',),
'bransjekunnskap': ('bransjekunnskap',),
'bransjekunnskapen': ('bransjekunnskap',),
'bransjekunnskapene': ('bransjekunnskap',),
'bransjekunnskaper': ('bransjekunnskap',),
'bransjeråd': ('bransjeråd',),
'bransjeråda': ('bransjeråd',),
'bransjerådene': ('bransjeråd',),
'bransjerådet': ('bransjeråd',),
'bras': ('bras',),
'brasen': ('bras',),
'brasene': ('bras',),
'braser': ('bras',),
'bras': ('bras',),
'brasa': ('bras',),
'brasene': ('bras',),
'braset': ('bras',),
'brasilianer': ('brasilianer',),
'brasilianere': ('brasilianer',),
'brasilianeren': ('brasilianer',),
'brasilianerer': ('brasilianer',),
'brasilianerne': ('brasilianer',),
'brask': ('brask',),
'brasma': ('brasme',),
'brasme': ('brasme',),
'brasmen': ('brasme',),
'brasmene': ('brasme',),
'brasmer': ('brasme',),
'brass': ('brass',),
'brassen': ('brass',),
'brassene': ('brass',),
'brasser': ('brass',),
'brassband': ('brassband',),
'brassbanda': ('brassband',),
'brassbandene': ('brassband',),
'brassbandet': ('brassband',),
'brassespark': ('brassespark',),
'brassesparka': ('brassespark',),
'brassesparkene': ('brassespark',),
'brassesparket': ('brassespark',),
'brast': ('brast',),
'bratning': ('bratning',),
'bratninga': ('bratning',),
'bratningen': ('bratning',),
'bratningene': ('bratning',),
'bratninger': ('bratning',),
'bratsj': ('bratsj',),
'bratsjen': ('bratsj',),
'bratsjene': ('bratsj',),
'bratsjer': ('bratsj',),
'bratsjist': ('bratsjist',),
'bratsjisten': ('bratsjist',),
'bratsjistene': ('bratsjist',),
'bratsjister': ('bratsjist',),
'bratta': ('bratte',),
'bratte': ('bratte',),
'bratten': ('bratte',),
'brattene': ('bratte',),
'bratter': ('bratte',),
'brattheng': ('brattheng',),
'bratthenga': ('brattheng',),
'bratthengene': ('brattheng',),
'bratthenget': ('brattheng',),
'brattstup': ('brattstup',),
'brattstupa': ('brattstup',),
'brattstupene': ('brattstup',),
'brattstupet': ('brattstup',),
'brauter': ('brauter',),
'brautere': ('brauter',),
'brauteren': ('brauter',),
'brauterer': ('brauter',),
'brauterne': ('brauter',),
'bravade': ('bravade',),
'bravaden': ('bravade',),
'bravadene': ('bravade',),
'bravader': ('bravade',),
'bravo': ('bravo',),
'bravoa': ('bravo',),
'bravoene': ('bravo',),
'bravoer': ('bravo',),
'bravoet': ('bravo',),
'bravorop': ('bravorop',),
'bravoropa': ('bravorop',),
'bravoropene': ('bravorop',),
'bravoropet': ('bravorop',),
'bravur': ('bravur',),
'bravuren': ('bravur',),
'bravurene': ('bravur',),
'bravurer': ('bravur',),
'bravurnummer': ('bravurnummer',),
'bravurnummeret': ('bravurnummer',),
'bravurnumra': ('bravurnummer',),
'bravurnumre': ('bravurnummer',),
'bravurnumrene': ('bravurnummer',),
'bre': ('bre',),
'breen': ('bre',),
'breene': ('bre',),
'breer': ('bre',),
'bredd': ('bredd',),
'bredda': ('bredd',),
'bredden': ('bredd',),
'breddene': ('bredd',),
'bredder': ('bredd',),
'bredde': ('bredde',),
'bredden': ('bredde',),
'breddene': ('bredde',),
'bredder': ('bredde',),
'bredde': ('bredde',),
'bredden': ('bredde',),
'breddene': ('bredde',),
'bredder': ('bredde',),
'bredde': ('bredde',),
'bredden': ('bredde',),
'breddene': ('bredde',),
'bredder': ('bredde',),
'breddegrad': ('breddegrad',),
'breddegraden': ('breddegrad',),
'breddegradene': ('breddegrad',),
'breddegrader': ('breddegrad',),
'breddegrad': ('breddegrad',),
'breddegraden': ('breddegrad',),
'breddegradene': ('breddegrad',),
'breddegrader': ('breddegrad',),
'breddeminutt': ('breddeminutt',),
'breddeminutta': ('breddeminutt',),
'breddeminuttene': ('breddeminutt',),
'breddeminutter': ('breddeminutt',),
'breddeminuttet': ('breddeminutt',),
'breddeminutt': ('breddeminutt',),
'breddeminutta': ('breddeminutt',),
'breddeminuttene': ('breddeminutt',),
'breddeminutter': ('breddeminutt',),
'breddeminuttet': ('breddeminutt',),
'breddesekund': ('breddesekund',),
'breddesekunda': ('breddesekund',),
'breddesekundene': ('breddesekund',),
'breddesekunder': ('breddesekund',),
'breddesekundet': ('breddesekund',),
'breddesekund': ('breddesekund',),
'breddesekunda': ('breddesekund',),
'breddesekundene': ('breddesekund',),
'breddesekunder': ('breddesekund',),
'breddesekundet': ('breddesekund',),
'breddesirkel': ('breddesirkel',),
'breddesirkelen': ('breddesirkel',),
'breddesirklene': ('breddesirkel',),
'breddesirkler': ('breddesirkel',),
'breddesirkel': ('breddesirkel',),
'breddesirkelen': ('breddesirkel',),
'breddesirklene': ('breddesirkel',),
'breddesirkler': ('breddesirkel',),
'bredfilm': ('bredfilm',),
'bredfilmen': ('bredfilm',),
'bredfilmene': ('bredfilm',),
'bredfilmer': ('bredfilm',),
'bredsida': ('bredside',),
'bredside': ('bredside',),
'bredsiden': ('bredside',),
'bredsidene': ('bredside',),
'bredsider': ('bredside',),
'bregna': ('bregne',),
'bregne': ('bregne',),
'bregnen': ('bregne',),
'bregnene': ('bregne',),
'bregner': ('bregne',),
'bregnekratt': ('bregnekratt',),
'bregnekratta': ('bregnekratt',),
'bregnekrattene': ('bregnekratt',),
'bregnekrattet': ('bregnekratt',),
'breibygd': ('breibygd',),
'breibygda': ('breibygd',),
'breibygden': ('breibygd',),
'breibygdene': ('breibygd',),
'breibygder': ('breibygd',),
'breidd': ('breidd',),
'breidda': ('breidd',),
'breidden': ('breidd',),
'breiddene': ('breidd',),
'breidder': ('breidd',),
'breidd': ('breidd',),
'breidda': ('breidd',),
'breidden': ('breidd',),
'breiddene': ('breidd',),
'breidder': ('breidd',),
'breiddegrad': ('breiddegrad',),
'breiddegraden': ('breiddegrad',),
'breiddegradene': ('breiddegrad',),
'breiddegrader': ('breiddegrad',),
'breiddegrad': ('breiddegrad',),
'breiddegraden': ('breiddegrad',),
'breiddegradene': ('breiddegrad',),
'breiddegrader': ('breiddegrad',),
'breiddeminutt': ('breiddeminutt',),
'breiddeminutta': ('breiddeminutt',),
'breiddeminuttene': ('breiddeminutt',),
'breiddeminutter': ('breiddeminutt',),
'breiddeminuttet': ('breiddeminutt',),
'breiddeminutt': ('breiddeminutt',),
'breiddeminutta': ('breiddeminutt',),
'breiddeminuttene': ('breiddeminutt',),
'breiddeminutter': ('breiddeminutt',),
'breiddeminuttet': ('breiddeminutt',),
'breiddesekund': ('breiddesekund',),
'breiddesekunda': ('breiddesekund',),
'breiddesekundene': ('breiddesekund',),
'breiddesekunder': ('breiddesekund',),
'breiddesekundet': ('breiddesekund',),
'breiddesekund': ('breiddesekund',),
'breiddesekunda': ('breiddesekund',),
'breiddesekundene': ('breiddesekund',),
'breiddesekunder': ('breiddesekund',),
'breiddesekundet': ('breiddesekund',),
'breiddesirkel': ('breiddesirkel',),
'breiddesirkelen': ('breiddesirkel',),
'breiddesirklene': ('breiddesirkel',),
'breiddesirkler': ('breiddesirkel',),
'breiddesirkel': ('breiddesirkel',),
'breiddesirkelen': ('breiddesirkel',),
'breiddesirklene': ('breiddesirkel',),
'breiddesirkler': ('breiddesirkel',),
'breieriva': ('breierive',),
'breierive': ('breierive',),
'breieriven': ('breierive',),
'breierivene': ('breierive',),
'breieriver': ('breierive',),
'breievoll': ('breievoll',),
'breievollen': ('breievoll',),
'breievollene': ('breievoll',),
'breievoller': ('breievoll',),
'breifilm': ('breifilm',),
'breifilmen': ('breifilm',),
'breifilmene': ('breifilm',),
'breifilmer': ('breifilm',),
'breiflabb': ('breiflabb',),
'breiflabben': ('breiflabb',),
'breiflabbene': ('breiflabb',),
'breiflabber': ('breiflabb',),
'breifokk': ('breifokk',),
'breifokka': ('breifokk',),
'breifokken': ('breifokk',),
'breifokkene': ('breifokk',),
'breifokker': ('breifokk',),
'breis': ('breis',),
'breisen': ('breis',),
'breisene': ('breis',),
'breiser': ('breis',),
'breisida': ('breiside',),
'breiside': ('breiside',),
'breisiden': ('breiside',),
'breisidene': ('breiside',),
'breisider': ('breiside',),
'breislede': ('breislede',),
'breisleden': ('breislede',),
'breisledene': ('breislede',),
'breisleder': ('breislede',),
'breitschwans': ('breitschwans',),
'breitschwansen': ('breitschwans',),
'breitschwansene': ('breitschwans',),
'breitschwanser': ('breitschwans',),
'brejord': ('brejord',),
'brejorda': ('brejord',),
'brejorden': ('brejord',),
'brejordene': ('brejord',),
'brejorder': ('brejord',),
'brek': ('brek',),
'breka': ('brek',),
'brekene': ('brek',),
'breket': ('brek',),
'brekalv': ('brekalv',),
'brekalven': ('brekalv',),
'brekalvene': ('brekalv',),
'brekalver': ('brekalv',),
'brekk': ('brekk',),
'brekka': ('brekk',),
'brekkene': ('brekk',),
'brekket': ('brekk',),
'brekk': ('brekk',),
'brekka': ('brekk',),
'brekkene': ('brekk',),
'brekket': ('brekk',),
'brekkasje': ('brekkasje',),
'brekkasjen': ('brekkasje',),
'brekkasjene': ('brekkasje',),
'brekkasjer': ('brekkasje',),
'brekkbønna': ('brekkbønne',),
'brekkbønne': ('brekkbønne',),
'brekkbønnen': ('brekkbønne',),
'brekkbønnene': ('brekkbønne',),
'brekkbønner': ('brekkbønne',),
'brekka': ('brekke',),
'brekke': ('brekke',),
'brekken': ('brekke',),
'brekkene': ('brekke',),
'brekker': ('brekke',),
'brekkfarge': ('brekkfarge',),
'brekkfargen': ('brekkfarge',),
'brekkfargene': ('brekkfarge',),
'brekkfarger': ('brekkfarge',),
'brekkjern': ('brekkjern',),
'brekkjerna': ('brekkjern',),
'brekkjernene': ('brekkjern',),
'brekkjernet': ('brekkjern',),
'brekkmiddel': ('brekkmiddel',),
'brekkmiddelet': ('brekkmiddel',),
'brekkmidla': ('brekkmiddel',),
'brekkmidlene': ('brekkmiddel',),
'brekkmidler': ('brekkmiddel',),
'brekkmidlet': ('brekkmiddel',),
'brekkstang': ('brekkstang',),
'brekkstanga': ('brekkstang',),
'brekkstangen': ('brekkstang',),
'brekkstengene': ('brekkstang',),
'brekkstenger': ('brekkstang',),
'brekkvogn': ('brekkvogn',),
'brekkvogna': ('brekkvogn',),
'brekkvognen': ('brekkvogn',),
'brekkvognene': ('brekkvogn',),
'brekkvogner': ('brekkvogn',),
'brekning': ('brekning',),
'brekninga': ('brekning',),
'brekningen': ('brekning',),
'brekningene': ('brekning',),
'brekninger': ('brekning',),
'brekningsfornemmelse': ('brekningsfornemmelse',),
'brekningsfornemmelsen': ('brekningsfornemmelse',),
'brekningsfornemmelsene': ('brekningsfornemmelse',),
'brekningsfornemmelser': ('brekningsfornemmelse',),
'brem': ('brem',),
'bremmen': ('brem',),
'bremmene': ('brem',),
'bremmer': ('brem',),
'brems': ('brems',),
'bremsen': ('brems',),
'bremsene': ('brems',),
'bremser': ('brems',),
'brems': ('brems',),
'bremsen': ('brems',),
'bremsene': ('brems',),
'bremser': ('brems',),
'brems': ('brems',),
'bremsen': ('brems',),
'bremsene': ('brems',),
'bremser': ('brems',),
'bremsa': ('bremse',),
'bremse': ('bremse',),
'bremsen': ('bremse',),
'bremsene': ('bremse',),
'bremser': ('bremse',),
'bremseband': ('bremseband',),
'bremsebanda': ('bremseband',),
'bremsebandene': ('bremseband',),
'bremsebandet': ('bremseband',),
'bremsebånd': ('bremsebånd',),
'bremsebånda': ('bremsebånd',),
'bremsebåndene': ('bremsebånd',),
'bremsebåndet': ('bremsebånd',),
'bremseeffekt': ('bremseeffekt',),
'bremseeffekten': ('bremseeffekt',),
'bremseeffektene': ('bremseeffekt',),
'bremseeffekter': ('bremseeffekt',),
'bremseflata': ('bremseflate',),
'bremseflate': ('bremseflate',),
'bremseflaten': ('bremseflate',),
'bremseflatene': ('bremseflate',),
'bremseflater': ('bremseflate',),
'bremsehestekraft': ('bremsehestekraft',),
'bremsehestekrafta': ('bremsehestekraft',),
'bremsehestekraften': ('bremsehestekraft',),
'bremsehestekreftene': ('bremsehestekraft',),
'bremsehestekrefter': ('bremsehestekraft',),
'bremselengd': ('bremselengd',),
'bremselengda': ('bremselengd',),
'bremselengden': ('bremselengd',),
'bremselengdene': ('bremselengd',),
'bremselengder': ('bremselengd',),
'bremselengda': ('bremselengde',),
'bremselengde': ('bremselengde',),
'bremselengden': ('bremselengde',),
'bremselengdene': ('bremselengde',),
'bremselengder': ('bremselengde',),
'bremselys': ('bremselys',),
'bremselysa': ('bremselys',),
'bremselysene': ('bremselys',),
'bremselyset': ('bremselys',),
'bremsevogn': ('bremsevogn',),
'bremsevogna': ('bremsevogn',),
'bremsevognen': ('bremsevogn',),
'bremsevognene': ('bremsevogn',),
'bremsevogner': ('bremsevogn',),
'bremsevæska': ('bremsevæske',),
'bremsevæske': ('bremsevæske',),
'bremsevæsken': ('bremsevæske',),
'bremsevæskene': ('bremsevæske',),
'bremsevæsker': ('bremsevæske',),
'brenn-nesla': ('brenn-nesle',),
'brenn-nesle': ('brenn-nesle',),
'brenn-neslen': ('brenn-nesle',),
'brenn-neslene': ('brenn-nesle',),
'brenn-nesler': ('brenn-nesle',),
'brenneglas': ('brenneglas',),
'brenneglasa': ('brenneglas',),
'brenneglasene': ('brenneglas',),
'brenneglaset': ('brenneglas',),
'brenneglass': ('brenneglass',),
'brenneglassa': ('brenneglass',),
'brenneglassene': ('brenneglass',),
'brenneglasset': ('brenneglass',),
'brennemerka': ('brennemerke',),
'brennemerke': ('brennemerke',),
'brennemerkene': ('brennemerke',),
'brennemerker': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennenesla': ('brennenesle',),
'brennenesle': ('brennenesle',),
'brenneneslen': ('brennenesle',),
'brenneneslene': ('brennenesle',),
'brennenesler': ('brennenesle',),
'brenner': ('brenner',),
'brennere': ('brenner',),
'brenneren': ('brenner',),
'brennerer': ('brenner',),
'brennerne': ('brenner',),
'brenneri': ('brenneri',),
'brenneria': ('brenneri',),
'brenneriene': ('brenneri',),
'brennerier': ('brenneri',),
'brenneriet': ('brenneri',),
'brennesla': ('brennesle',),
'brennesle': ('brennesle',),
'brenneslen': ('brennesle',),
'brenneslene': ('brennesle',),
'brennesler': ('brennesle',),
'brennevin': ('brennevin',),
'brennevinene': ('brennevin',),
'brenneviner': ('brennevin',),
'brennevinet': ('brennevin',),
'brennevinsdjevel': ('brennevinsdjevel',),
'brennevinsdjevelen': ('brennevinsdjevel',),
'brennevinsdjevlene': ('brennevinsdjevel',),
'brennevinsdjevler': ('brennevinsdjevel',),
'brennevinsgauk': ('brennevinsgauk',),
'brennevinsgauken': ('brennevinsgauk',),
'brennevinsgaukene': ('brennevinsgauk',),
'brennevinsgauker': ('brennevinsgauk',),
'brennglas': ('brennglas',),
'brennglasa': ('brennglas',),
'brennglasene': ('brennglas',),
'brennglaset': ('brennglas',),
'brennglass': ('brennglass',),
'brennglassa': ('brennglass',),
'brennglassene': ('brennglass',),
'brennglasset': ('brennglass',),
'brennhast': ('brennhast',),
'brennhasten': ('brennhast',),
'brennhastene': ('brennhast',),
'brennhaster': ('brennhast',),
'brennhete': ('brennhete',),
'brennheten': ('brennhete',),
'brennhetene': ('brennhete',),
'brennheter': ('brennhete',),
'brennhår': ('brennhår',),
'brennhåra': ('brennhår',),
'brennhårene': ('brennhår',),
'brennhåret': ('brennhår',),
'brenning': ('brenning',),
'brenninga': ('brenning',),
'brenningen': ('brenning',),
'brenningene': ('brenning',),
'brenninger': ('brenning',),
'brenning': ('brenning',),
'brenninga': ('brenning',),
'brenningen': ('brenning',),
'brenningene': ('brenning',),
'brenninger': ('brenning',),
'brennkoppene': ('brennkopper',),
'brennkopper': ('brennkopper',),
'brennkulda': ('brennkulde',),
'brennkulde': ('brennkulde',),
'brennkulden': ('brennkulde',),
'brennkuldene': ('brennkulde',),
'brennkulder': ('brennkulde',),
'brennmanet': ('brennmanet',),
'brennmaneta': ('brennmanet',),
'brennmaneten': ('brennmanet',),
'brennmanetene': ('brennmanet',),
'brennmaneter': ('brennmanet',),
'brennoffer': ('brennoffer',),
'brennofferet': ('brennoffer',),
'brennofra': ('brennoffer',),
'brennofre': ('brennoffer',),
'brennofrene': ('brennoffer',),
'brennpunkt': ('brennpunkt',),
'brennpunkta': ('brennpunkt',),
'brennpunktene': ('brennpunkt',),
'brennpunkter': ('brennpunkt',),
'brennpunktet': ('brennpunkt',),
'brennstoff': ('brennstoff',),
'brennstoffa': ('brennstoff',),
'brennstoffene': ('brennstoff',),
'brennstoffer': ('brennstoff',),
'brennstoffet': ('brennstoff',),
'brennvidda': ('brennvidde',),
'brennvidde': ('brennvidde',),
'brennvidden': ('brennvidde',),
'brennviddene': ('brennvidde',),
'brennvidder': ('brennvidde',),
'brensel': ('brensel',),
'brenselet': ('brensel',),
'brensla': ('brensel',),
'brenslene': ('brensel',),
'brensler': ('brensel',),
'brenslet': ('brensel',),
'brenselcella': ('brenselcelle',),
'brenselcelle': ('brenselcelle',),
'brenselcellen': ('brenselcelle',),
'brenselcellene': ('brenselcelle',),
'brenselceller': ('brenselcelle',),
'brenselforbruk': ('brenselforbruk',),
'brenselforbruka': ('brenselforbruk',),
'brenselforbrukene': ('brenselforbruk',),
'brenselforbruket': ('brenselforbruk',),
'brenselforsyning': ('brenselforsyning',),
'brenselforsyninga': ('brenselforsyning',),
'brenselforsyningen': ('brenselforsyning',),
'brenselforsyningene': ('brenselforsyning',),
'brenselforsyninger': ('brenselforsyning',),
'brenselscella': ('brenselscelle',),
'brenselscelle': ('brenselscelle',),
'brenselscellen': ('brenselscelle',),
'brenselscellene': ('brenselscelle',),
'brenselsceller': ('brenselscelle',),
'bresje': ('bresje',),
'bresjen': ('bresje',),
'bresjene': ('bresje',),
'bresjer': ('bresje',),
'bresprekk': ('bresprekk',),
'bresprekken': ('bresprekk',),
'bresprekkene': ('bresprekk',),
'bresprekker': ('bresprekk',),
'brest': ('brest',),
'bresten': ('brest',),
'brestene': ('brest',),
'brester': ('brest',),
'brest': ('brest',),
'bresten': ('brest',),
'brestene': ('brest',),
'brester': ('brest',),
'bretagner': ('bretagner',),
'bretagnere': ('bretagner',),
'bretagneren': ('bretagner',),
'bretagnerer': ('bretagner',),
'bretagnerne': ('bretagner',),
'bretoner': ('bretoner',),
'bretonere': ('bretoner',),
'bretoneren': ('bretoner',),
'bretonerer': ('bretoner',),
'bretonerne': ('bretoner',),
'bretonner': ('bretonner',),
'bretonnere': ('bretonner',),
'bretonneren': ('bretonner',),
'bretonnerer': ('bretonner',),
'bretonnerne': ('bretonner',),
'bretonsk': ('bretonsk',),
'bretonsken': ('bretonsk',),
'bretonskene': ('bretonsk',),
'bretonsker': ('bretonsk',),
'brett': ('brett',),
'bretten': ('brett',),
'brettene': ('brett',),
'bretter': ('brett',),
'brett': ('brett',),
'bretta': ('brett',),
'brettene': ('brett',),
'bretter': ('brett',),
'brettet': ('brett',),
'brettemerka': ('brettemerke',),
'brettemerke': ('brettemerke',),
'brettemerkene': ('brettemerke',),
'brettemerker': ('brettemerke',),
'brettemerket': ('brettemerke',),
'brettemess': ('brettemess',),
'brettemesse': ('brettemesse',),
'brettmess': ('brettmess',),
'brettmesse': ('brettmesse',),
'brettsegler': ('brettsegler',),
'brettseglere': ('brettsegler',),
'brettsegleren': ('brettsegler',),
'brettseglerer': ('brettsegler',),
'brettseglerne': ('brettsegler',),
'brettsegling': ('brettsegling',),
'brettseglinga': ('brettsegling',),
'brettseglingen': ('brettsegling',),
'brettseglingene': ('brettsegling',),
'brettseglinger': ('brettsegling',),
'brettseiler': ('brettseiler',),
'brettseilere': ('brettseiler',),
'brettseileren': ('brettseiler',),
'brettseilerer': ('brettseiler',),
'brettseilerne': ('brettseiler',),
'brettseiling': ('brettseiling',),
'brettseilinga': ('brettseiling',),
'brettseilingen': ('brettseiling',),
'brettseilingene': ('brettseiling',),
'brettseilinger': ('brettseiling',),
'brettspell': ('brettspell',),
'brettspella': ('brettspell',),
'brettspellene': ('brettspell',),
'brettspellet': ('brettspell',),
'brettspill': ('brettspill',),
'brettspilla': ('brettspill',),
'brettspillene': ('brettspill',),
'brettspillet': ('brettspill',),
'brev': ('brev',),
'breva': ('brev',),
'brevene': ('brev',),
'brever': ('brev',),
'brevet': ('brev',),
'brevadel': ('brevadel',),
'brevadelen': ('brevadel',),
'brevadelene': ('brevadel',),
'brevadeler': ('brevadel',),
'brevandrer': ('brevandrer',),
'brevandrere': ('brevandrer',),
'brevandreren': ('brevandrer',),
'brevandrerer': ('brevandrer',),
'brevandrerne': ('brevandrer',),
'brevann': ('brevann',),
'brevanna': ('brevann',),
'brevannene': ('brevann',),
'brevannet': ('brevann',),
'brevatn': ('brevatn',),
'brevatna': ('brevatn',),
'brevatnene': ('brevatn',),
'brevatnet': ('brevatn',),
'brevbomba': ('brevbombe',),
'brevbombe': ('brevbombe',),
'brevbomben': ('brevbombe',),
'brevbombene': ('brevbombe',),
'brevbomber': ('brevbombe',),
'brevbrott': ('brevbrott',),
'brevbrotta': ('brevbrott',),
'brevbrottene': ('brevbrott',),
'brevbrottet': ('brevbrott',),
'brevbrudd': ('brevbrudd',),
'brevbrudda': ('brevbrudd',),
'brevbruddene': ('brevbrudd',),
'brevbruddet': ('brevbrudd',),
'brevdua': ('brevdue',),
'brevdue': ('brevdue',),
'brevduen': ('brevdue',),
'brevduene': ('brevdue',),
'brevduer': ('brevdue',),
'brevforbud': ('brevforbud',),
'brevforbuda': ('brevforbud',),
'brevforbudene': ('brevforbud',),
'brevforbudet': ('brevforbud',),
'brevhoda': ('brevhode',),
'brevhode': ('brevhode',),
'brevhodene': ('brevhode',),
'brevhoder': ('brevhode',),
'brevhodet': ('brevhode',),
'breviar': ('breviar',),
'breviara': ('breviar',),
'breviarene': ('breviar',),
'breviarer': ('breviar',),
'breviaret': ('breviar',),
'breviaria': ('breviarium',),
'breviariene': ('breviarium',),
'breviarier': ('breviarium',),
'breviariet': ('breviarium',),
'breviarium': ('breviarium',),
'brevkassa': ('brevkasse',),
'brevkasse': ('brevkasse',),
'brevkassen': ('brevkasse',),
'brevkassene': ('brevkasse',),
'brevkasser': ('brevkasse',),
'brevkort': ('brevkort',),
'brevkorta': ('brevkort',),
'brevkortene': ('brevkort',),
'brevkortet': ('brevkort',),
'brevkurs': ('brevkurs',),
'brevkursa': ('brevkurs',),
'brevkursene': ('brevkurs',),
'brevkurser': ('brevkurs',),
'brevkurset': ('brevkurs',),
'brevkursene': ('brevkursus',),
'brevkurser': ('brevkursus',),
'brevkursus': ('brevkursus',),
'brevkursuset': ('brevkursus',),
'brevporto': ('brevporto',),
'brevportoen': ('brevporto',),
'brevportoene': ('brevporto',),
'brevportoer': ('brevporto',),
'brevsending': ('brevsending',),
'brevsendinga': ('brevsending',),
'brevsendingen': ('brevsending',),
'brevsendingene': ('brevsending',),
'brevsendinger': ('brevsending',),
'brevskole': ('brevskole',),
'brevskolen': ('brevskole',),
'brevskolene': ('brevskole',),
'brevskoler': ('brevskole',),
'brevskriver': ('brevskriver',),
'brevskrivere': ('brevskriver',),
'brevskriveren': ('brevskriver',),
'brevskriverer': ('brevskriver',),
'brevskriverne': ('brevskriver',),
'brevundervisning': ('brevundervisning',),
'brevundervisninga': ('brevundervisning',),
'brevundervisningen': ('brevundervisning',),
'brevundervisningene': ('brevundervisning',),
'brevundervisninger': ('brevundervisning',),
'brevvekt': ('brevvekt',),
'brevvekta': ('brevvekt',),
'brevvekten': ('brevvekt',),
'brevvektene': ('brevvekt',),
'brevvekter': ('brevvekt',),
'brevvenn': ('brevvenn',),
'brevvennen': ('brevvenn',),
'brevvennene': ('brevvenn',),
'brevvenner': ('brevvenn',),
'bridge': ('bridge',),
'bridgen': ('bridge',),
'bridgene': ('bridge',),
'bridger': ('bridge',),
'brie': ('brie',),
'brien': ('brie',),
'briene': ('brie',),
'brier': ('brie',),
'brifing': ('brifing',),
'brifinga': ('brifing',),
'brifingen': ('brifing',),
'brifingene': ('brifing',),
'brifinger': ('brifing',),
'brigade': ('brigade',),
'brigaden': ('brigade',),
'brigadene': ('brigade',),
'brigader': ('brigade',),
'brigadegeneral': ('brigadegeneral',),
'brigadegeneralen': ('brigadegeneral',),
'brigadegeneralene': ('brigadegeneral',),
'brigadegeneraler': ('brigadegeneral',),
'brigadekommandør': ('brigadekommandør',),
'brigadekommandøren': ('brigadekommandør',),
'brigadekommandørene': ('brigadekommandør',),
'brigadekommandører': ('brigadekommandør',),
'brigadeoffiser': ('brigadeoffiser',),
'brigadeoffiseren': ('brigadeoffiser',),
'brigadeoffiserene': ('brigadeoffiser',),
'brigadeoffiserer': ('brigadeoffiser',),
'brigader': ('brigader',),
'brigaderen': ('brigader',),
'brigaderene': ('brigader',),
'brigaderer': ('brigader',),
'brikett': ('brikett',),
'briketten': ('brikett',),
'brikettene': ('brikett',),
'briketter': ('brikett',),
'brikka': ('brikke',),
'brikke': ('brikke',),
'brikken': ('brikke',),
'brikkene': ('brikke',),
'brikker': ('brikke',),
'brikkespell': ('brikkespell',),
'brikkespella': ('brikkespell',),
'brikkespellene': ('brikkespell',),
'brikkespellet': ('brikkespell',),
'brikkespill': ('brikkespill',),
'brikkespilla': ('brikkespill',),
'brikkespillene': ('brikkespill',),
'brikkespillet': ('brikkespill',),
'brikkevev': ('brikkevev',),
'brikkeveven': ('brikkevev',),
'brikkevevene': ('brikkevev',),
'brikkevever': ('brikkevev',),
'briks': ('briks',),
'briksen': ('briks',),
'briksene': ('briks',),
'brikser': ('briks',),
'briljans': ('briljans',),
'briljansen': ('briljans',),
'briljansene': ('briljans',),
'briljanser': ('briljans',),
'briljant': ('briljant',),
'briljanten': ('briljant',),
'briljantene': ('briljant',),
'briljanter': ('briljant',),
'briljantin': ('briljantin',),
'briljantinen': ('briljantin',),
'briljantinene': ('briljantin',),
'briljantiner': ('briljantin',),
'briljantine': ('briljantine',),
'briljantinen': ('briljantine',),
'briljantinene': ('briljantine',),
'briljantiner': ('briljantine',),
'briljantsmykka': ('briljantsmykke',),
'briljantsmykke': ('briljantsmykke',),
'briljantsmykkene': ('briljantsmykke',),
'briljantsmykker': ('briljantsmykke',),
'briljantsmykket': ('briljantsmykke',),
'brilla': ('brille',),
'brille': ('brille',),
'brillen': ('brille',),
'brillene': ('brille',),
'briller': ('brille',),
'brillefutteral': ('brillefutteral',),
'brillefutterala': ('brillefutteral',),
'brillefutteralene': ('brillefutteral',),
'brillefutteraler': ('brillefutteral',),
'brillefutteralet': ('brillefutteral',),
'brilleglas': ('brilleglas',),
'brilleglasa': ('brilleglas',),
'brilleglasene': ('brilleglas',),
'brilleglaset': ('brilleglas',),
'brilleglass': ('brilleglass',),
'brilleglassa': ('brilleglass',),
'brilleglassene': ('brilleglass',),
'brilleglasset': ('brilleglass',),
'brilleinnfatning': ('brilleinnfatning',),
'brilleinnfatninga': ('brilleinnfatning',),
'brilleinnfatningen': ('brilleinnfatning',),
'brilleinnfatningene': ('brilleinnfatning',),
'brilleinnfatninger': ('brilleinnfatning',),
'brilleslange': ('brilleslange',),
'brilleslangen': ('brilleslange',),
'brilleslangene': ('brilleslange',),
'brilleslanger': ('brilleslange',),
'brim': ('brim',),
'brima': ('brim',),
'brimene': ('brim',),
'brimet': ('brim',),
'brimsjø': ('brimsjø',),
'brimsjøen': ('brimsjø',),
'brimsjøene': ('brimsjø',),
'brimsjøer': ('brimsjø',),
'bringe': ('bringe',),
'bringen': ('bringe',),
'bringene': ('bringe',),
'bringer': ('bringe',),
'bringa': ('bringe',),
'bringe': ('bringe',),
'bringen': ('bringe',),
'bringene': ('bringe',),
'bringer': ('bringe',),
'bringebær': ('bringebær',),
'bringebæra': ('bringebær',),
'bringebærene': ('bringebær',),
'bringebæret': ('bringebær',),
'bringebær': ('bringebær',),
'bringebæra': ('bringebær',),
'bringebærene': ('bringebær',),
'bringebæret': ('bringebær',),
'bringebærbille': ('bringebærbille',),
'bringebærbillen': ('bringebærbille',),
'bringebærbillene': ('bringebærbille',),
'bringebærbiller': ('bringebærbille',),
'bringebærbusk': ('bringebærbusk',),
'bringebærbusken': ('bringebærbusk',),
'bringebærbuskene': ('bringebærbusk',),
'bringebærbusker': ('bringebærbusk',),
'bringebærmakk': ('bringebærmakk',),
'bringebærmakken': ('bringebærmakk',),
'bringebærmakkene': ('bringebærmakk',),
'bringebærmakker': ('bringebærmakk',),
'bringebærmark': ('bringebærmark',),
'bringebærmarken': ('bringebærmark',),
'bringebærmarkene': ('bringebærmark',),
'bringebærmarker': ('bringebærmark',),
'bringebærsaft': ('bringebærsaft',),
'bringebærsafta': ('bringebærsaft',),
'bringebærsaften': ('bringebærsaft',),
'bringebærsaftene': ('bringebærsaft',),
'bringebærsafter': ('bringebærsaft',),
'bringebærsyltetøy': ('bringebærsyltetøy',),
'bringebærsyltetøya': ('bringebærsyltetøy',),
'bringebærsyltetøyene': ('bringebærsyltetøy',),
'bringebærsyltetøyet': ('bringebærsyltetøy',),
'brink': ('brink',),
'brinken': ('brink',),
'brinkene': ('brink',),
'brinker': ('brink',),
'bris': ('bris',),
'brisen': ('bris',),
'brisene': ('bris',),
'briser': ('bris',),
'brisantammunisjon': ('brisantammunisjon',),
'brisantammunisjonen': ('brisantammunisjon',),
'brisantammunisjonene': ('brisantammunisjon',),
'brisantammunisjoner': ('brisantammunisjon',),
'brisk': ('brisk',),
'brisken': ('brisk',),
'briskene': ('brisk',),
'brisker': ('brisk',),
'brisk': ('brisk',),
'brisken': ('brisk',),
'briskene': ('brisk',),
'brisker': ('brisk',),
'briskelåg': ('briskelåg',),
'briskelågen': ('briskelåg',),
'briskelågene': ('briskelåg',),
'briskelåger': ('briskelåg',),
'briskelåg': ('briskelåg',),
'briskelågen': ('briskelåg',),
'briskelågene': ('briskelåg',),
'briskelåger': ('briskelåg',),
'brisling': ('brisling',),
'brislingen': ('brisling',),
'brislingene': ('brisling',),
'brislinger': ('brisling',),
'brislingfiska': ('brislingfiske',),
'brislingfiske': ('brislingfiske',),
'brislingfiskene': ('brislingfiske',),
'brislingfisker': ('brislingfiske',),
'brislingfisket': ('brislingfiske',),
'brislingsteng': ('brislingsteng',),
'brislingstenga': ('brislingsteng',),
'brislingstengene': ('brislingsteng',),
'brislingstenget': ('brislingsteng',),
'brislene': ('brissel',),
'brisler': ('brissel',),
'brissel': ('brissel',),
'brisselen': ('brissel',),
'brist': ('brist',),
'bristen': ('brist',),
'bristene': ('brist',),
'brister': ('brist',),
'brist': ('brist',),
'bristen': ('brist',),
'bristene': ('brist',),
'brister': ('brist',),
'bristepunkt': ('bristepunkt',),
'bristepunkta': ('bristepunkt',),
'bristepunktene': ('bristepunkt',),
'bristepunktet': ('bristepunkt',),
'brite': ('brite',),
'briten': ('brite',),
'britene': ('brite',),
'briter': ('brite',),
'britisk-engelsk': ('britisk-engelsk',),
'britisk-engelsken': ('britisk-engelsk',),
'britisk-engelskene': ('britisk-engelsk',),
'britisk-engelsker': ('britisk-engelsk',),
'britisk-engelsk': ('britisk-engelsk',),
'britisk-engelsken': ('britisk-engelsk',),
'britisk-engelskene': ('britisk-engelsk',),
'britisk-engelsker': ('britisk-engelsk',),
'bro': ('bro',),
'broa': ('bro',),
'broen': ('bro',),
'broene': ('bro',),
'broer': ('bro',),
'bro-bro-brille': ('bro-bro-brille',),
'brobygger': ('brobygger',),
'brobyggere': ('brobygger',),
'brobyggeren': ('brobygger',),
'brobyggerer': ('brobygger',),
'brobyggerne': ('brobygger',),
'brodd': ('brodd',),
'brodden': ('brodd',),
'broddene': ('brodd',),
'brodder': ('brodd',),
'broder': ('broder',),
'broderen': ('broder',),
'brødre': ('broder',),
'brødrene': ('broder',),
'broderfolk': ('broderfolk',),
'broderfolka': ('broderfolk',),
'broderfolkene': ('broderfolk',),
'broderfolket': ('broderfolk',),
'brodergarn': ('brodergarn',),
'brodergarna': ('brodergarn',),
'brodergarnene': ('brodergarn',),
'brodergarnet': ('brodergarn',),
'broderhand': ('broderhand',),
'broderhanda': ('broderhand',),
'broderhanden': ('broderhand',),
'broderhendene': ('broderhand',),
'broderhender': ('broderhand',),
'broderhendene': ('broderhånd',),
'broderhender': ('broderhånd',),
'broderhånd': ('broderhånd',),
'broderhånda': ('broderhånd',),
'broderhånden': ('broderhånd',),
'broderi': ('broderi',),
'broderia': ('broderi',),
'broderiene': ('broderi',),
'broderier': ('broderi',),
'broderiet': ('broderi',),
'broderiforretning': ('broderiforretning',),
'broderiforretninga': ('broderiforretning',),
'broderiforretningen': ('broderiforretning',),
'broderiforretningene': ('broderiforretning',),
'broderiforretninger': ('broderiforretning',),
'broderkjærlighet': ('broderkjærlighet',),
'broderkjærligheta': ('broderkjærlighet',),
'broderkjærligheten': ('broderkjærlighet',),
'broderkjærlighetene': ('broderkjærlighet',),
'broderkjærligheter': ('broderkjærlighet',),
'broderland': ('broderland',),
'broderlanda': ('broderland',),
'broderlandene': ('broderland',),
'broderlandet': ('broderland',),
'brodermord': ('brodermord',),
'brodermorda': ('brodermord',),
'brodermordene': ('brodermord',),
'brodermordet': ('brodermord',),
'broderring': ('broderring',),
'broderringen': ('broderring',),
'broderringene': ('broderring',),
'broderringer': ('broderring',),
'brodersaks': ('brodersaks',),
'brodersaksa': ('brodersaks',),
'brodersaksen': ('brodersaks',),
'brodersaksene': ('brodersaks',),
'brodersakser': ('brodersaks',),
'brodersamfunn': ('brodersamfunn',),
'brodersamfunna': ('brodersamfunn',),
'brodersamfunnene': ('brodersamfunn',),
'brodersamfunnet': ('brodersamfunn',),
'broderånd': ('broderånd',),
'broderånden': ('broderånd',),
'broderåndene': ('broderånd',),
'broderånder': ('broderånd',),
'brohoda': ('brohode',),
'brohode': ('brohode',),
'brohodene': ('brohode',),
'brohoder': ('brohode',),
'brohodet': ('brohode',),
'broiler': ('broiler',),
'broilere': ('broiler',),
'broileren': ('broiler',),
'broilerer': ('broiler',),
'broilerne': ('broiler',),
'broilerproduksjon': ('broilerproduksjon',),
'broilerproduksjonen': ('broilerproduksjon',),
'broilerproduksjonene': ('broilerproduksjon',),
'broilerproduksjoner': ('broilerproduksjon',),
'brok': ('brok',),
'broka': ('brok',),
'broken': ('brok',),
'brøkene': ('brok',),
'brøker': ('brok',),
'brok': ('brok',),
'broka': ('brok',),
'broken': ('brok',),
'brøkene': ('brok',),
'brøker': ('brok',),
'brokade': ('brokade',),
'brokaden': ('brokade',),
'brokadene': ('brokade',),
'brokader': ('brokade',),
'brokadestoff': ('brokadestoff',),
'brokadestoffa': ('brokadestoff',),
'brokadestoffene': ('brokadestoff',),
'brokadestoffer': ('brokadestoff',),
'brokadestoffet': ('brokadestoff',),
'brokar': ('brokar',),
'brokara': ('brokar',),
'brokarene': ('brokar',),
'brokaret': ('brokar',),
'brokk': ('brokk',),
'brokka': ('brokk',),
'brokken': ('brokk',),
'brokkene': ('brokk',),
'brokker': ('brokk',),
'brokket': ('brokk',),
'brokkbind': ('brokkbind',),
'brokkbinda': ('brokkbind',),
'brokkbindene': ('brokkbind',),
'brokkbindet': ('brokkbind',),
'brokke': ('brokke',),
'brokken': ('brokke',),
'brokkene': ('brokke',),
'brokker': ('brokke',),
'brokkoli': ('brokkoli',),
'brokkolien': ('brokkoli',),
'brokkoliene': ('brokkoli',),
'brokkolier': ('brokkoli',),
'brokkurt': ('brokkurt',),
'brokkurta': ('brokkurt',),
'brokkurten': ('brokkurt',),
'brokkurtene': ('brokkurt',),
'brokkurter': ('brokkurt',),
'brolegger': ('brolegger',),
'broleggere': ('brolegger',),
'broleggeren': ('brolegger',),
'broleggerer': ('brolegger',),
'broleggerne': ('brolegger',),
'brolegging': ('brolegging',),
'brolegginga': ('brolegging',),
'broleggingen': ('brolegging',),
'broleggingene': ('brolegging',),
'brolegginger': ('brolegging',),
'brolegning': ('brolegning',),
'brolegninga': ('brolegning',),
'brolegningen': ('brolegning',),
'brolegningene': ('brolegning',),
'brolegninger': ('brolegning',),
'brom': ('brom',),
'bromma': ('brom',),
'brommene': ('brom',),
'brommet': ('brom',),
'brom': ('brom',),
'bromma': ('brom',),
'brommene': ('brom',),
'brommet': ('brom',),
'bromid': ('bromid',),
'bromida': ('bromid',),
'bromidene': ('bromid',),
'bromider': ('bromid',),
'bromidet': ('bromid',),
'bromidpapir': ('bromidpapir',),
'bromidpapira': ('bromidpapir',),
'bromidpapirene': ('bromidpapir',),
'bromidpapirer': ('bromidpapir',),
'bromidpapiret': ('bromidpapir',),
'bromisme': ('bromisme',),
'bromismen': ('bromisme',),
'bromismene': ('bromisme',),
'bromismer': ('bromisme',),
'bronkie': ('bronkie',),
'bronkien': ('bronkie',),
'bronkiene': ('bronkie',),
'bronkier': ('bronkie',),
'bronkiegrein': ('bronkiegrein',),
'bronkiegreina': ('bronkiegrein',),
'bronkiegreinen': ('bronkiegrein',),
'bronkiegreinene': ('bronkiegrein',),
'bronkiegreiner': ('bronkiegrein',),
'bronkiegren': ('bronkiegren',),
'bronkiegrena': ('bronkiegren',),
'bronkiegrenen': ('bronkiegren',),
'bronkiegrenene': ('bronkiegren',),
'bronkiegrener': ('bronkiegren',),
'bronkitt': ('bronkitt',),
'bronkitten': ('bronkitt',),
'bronkittene': ('bronkitt',),
'bronkitter': ('bronkitt',),
'bronkitthoste': ('bronkitthoste',),
'bronkitthosten': ('bronkitthoste',),
'bronkitthostene': ('bronkitthoste',),
'bronkitthoster': ('bronkitthoste',),
'bronse': ('bronse',),
'bronsen': ('bronse',),
'bronsene': ('bronse',),
'bronser': ('bronse',),
'bronsealder': ('bronsealder',),
'bronsealdere': ('bronsealder',),
'bronsealderen': ('bronsealder',),
'bronsealderer': ('bronsealder',),
'bronsealderne': ('bronsealder',),
'bronsealdre': ('bronsealder',),
'bronsealdrene': ('bronsealder',),
'bronsealdrer': ('bronsealder',),
'bronsefarge': ('bronsefarge',),
'bronsefargen': ('bronsefarge',),
'bronsefargene': ('bronsefarge',),
'bronsefarger': ('bronsefarge',),
'bronsemedalje': ('bronsemedalje',),
'bronsemedaljen': ('bronsemedalje',),
'bronsemedaljene': ('bronsemedalje',),
'bronsemedaljer': ('bronsemedalje',),
'bronsemedaljevinner': ('bronsemedaljevinner',),
'bronsemedaljevinnere': ('bronsemedaljevinner',),
'bronsemedaljevinneren': ('bronsemedaljevinner',),
'bronsemedaljevinnerer': ('bronsemedaljevinner',),
'bronsemedaljevinnerne': ('bronsemedaljevinner',),
'bropilar': ('bropilar',),
'bropilaren': ('bropilar',),
'bropilarene': ('bropilar',),
'bropilarer': ('bropilar',),
'bror': ('bror',),
'broren': ('bror',),
'brødre': ('bror',),
'brødrene': ('bror',),
'brordatter': ('brordatter',),
'brordattera': ('brordatter',),
'brordatteren': ('brordatter',),
'brordøtre': ('brordatter',),
'brordøtrene': ('brordatter',),
'brordøtrer': ('brordatter',),
'brorkona': ('brorkone',),
'brorkone': ('brorkone',),
'brorkonen': ('brorkone',),
'brorkonene': ('brorkone',),
'brorkoner': ('brorkone',),
'brorpart': ('brorpart',),
'brorparten': ('brorpart',),
'brorpartene': ('brorpart',),
'brorparter': ('brorpart',),
'brorskap': ('brorskap',),
'brorskapa': ('brorskap',),
'brorskapen': ('brorskap',),
'brorskapene': ('brorskap',),
'brorskaper': ('brorskap',),
'brorskapet': ('brorskap',),
'brorsønn': ('brorsønn',),
'brorsønnen': ('brorsønn',),
'brorsønnene': ('brorsønn',),
'brorsønner': ('brorsønn',),
'brosja': ('brosje',),
'brosje': ('brosje',),
'brosjen': ('brosje',),
'brosjene': ('brosje',),
'brosjer': ('brosje',),
'brosjyre': ('brosjyre',),
'brosjyren': ('brosjyre',),
'brosjyrene': ('brosjyre',),
'brosjyrer': ('brosjyre',),
'brosma': ('brosme',),
'brosme': ('brosme',),
'brosmen': ('brosme',),
'brosmene': ('brosme',),
'brosmer': ('brosme',),
'brospenn': ('brospenn',),
'brospenna': ('brospenn',),
'brospennene': ('brospenn',),
'brospennet': ('brospenn',),
'brostein': ('brostein',),
'brosteinen': ('brostein',),
'brosteinene': ('brostein',),
'brosteiner': ('brostein',),
'brotsj': ('brotsj',),
'brotsjen': ('brotsj',),
'brotsjene': ('brotsj',),
'brotsjer': ('brotsj',),
'brott': ('brott',),
'brotta': ('brott',),
'brottene': ('brott',),
'brottet': ('brott',),
'brott': ('brott',),
'brotta': ('brott',),
'brottene': ('brott',),
'brottet': ('brott',),
'brottbelastning': ('brottbelastning',),
'brottbelastninga': ('brottbelastning',),
'brottbelastningen': ('brottbelastning',),
'brottbelastningene': ('brottbelastning',),
'brottbelastninger': ('brottbelastning',),
'brottfasthet': ('brottfasthet',),
'brottfastheta': ('brottfasthet',),
'brottfastheten': ('brottfasthet',),
'brottfasthetene': ('brottfasthet',),
'brottfastheter': ('brottfasthet',),
'brottflata': ('brottflate',),
'brottflate': ('brottflate',),
'brottflaten': ('brottflate',),
'brottflatene': ('brottflate',),
'brottflater': ('brottflate',),
'brotthella': ('brotthelle',),
'brotthelle': ('brotthelle',),
'brotthellen': ('brotthelle',),
'brotthellene': ('brotthelle',),
'brottheller': ('brotthelle',),
'brottsjø': ('brottsjø',),
'brottsjøen': ('brottsjø',),
'brottsjøene': ('brottsjø',),
'brottsjøer': ('brottsjø',),
'brottsmann': ('brottsmann',),
'brottsmannen': ('brottsmann',),
'brottsmenn': ('brottsmann',),
'brottsmennene': ('brottsmann',),
'brottstein': ('brottstein',),
'brottsteinen': ('brottstein',),
'brottsteinene': ('brottstein',),
'brottsteiner': ('brottstein',),
'brottstykka': ('brottstykke',),
'brottstykke': ('brottstykke',),
'brottstykkene': ('brottstykke',),
'brottstykker': ('brottstykke',),
'brottstykket': ('brottstykke',),
'brottstyrke': ('brottstyrke',),
'brottstyrken': ('brottstyrke',),
'brottstyrkene': ('brottstyrke',),
'brottstyrker': ('brottstyrke',),
'brottsverk': ('brottsverk',),
'brottsverka': ('brottsverk',),
'brottsverkene': ('brottsverk',),
'brottsverker': ('brottsverk',),
'brottsverket': ('brottsverk',),
'bru': ('bru',),
'brua': ('bru',),
'bruen': ('bru',),
'bruene': ('bru',),
'bruer': ('bru',),
'brubygger': ('brubygger',),
'brubyggere': ('brubygger',),
'brubyggeren': ('brubygger',),
'brubyggerer': ('brubygger',),
'brubyggerne': ('brubygger',),
'brud': ('brud',),
'bruda': ('brud',),
'bruden': ('brud',),
'brudene': ('brud',),
'bruder': ('brud',),
'brud': ('brud',),
'bruda': ('brud',),
'bruden': ('brud',),
'brudene': ('brud',),
'bruder': ('brud',),
'brudd': ('brudd',),
'brudda': ('brudd',),
'bruddene': ('brudd',),
'bruddet': ('brudd',),
'bruddbelastning': ('bruddbelastning',),
'bruddbelastninga': ('bruddbelastning',),
'bruddbelastningen': ('bruddbelastning',),
'bruddbelastningene': ('bruddbelastning',),
'bruddbelastninger': ('bruddbelastning',),
'bruddfasthet': ('bruddfasthet',),
'bruddfastheta': ('bruddfasthet',),
'bruddfastheten': ('bruddfasthet',),
'bruddfasthetene': ('bruddfasthet',),
'bruddfastheter': ('bruddfasthet',),
'bruddflata': ('bruddflate',),
'bruddflate': ('bruddflate',),
'bruddflaten': ('bruddflate',),
'bruddflatene': ('bruddflate',),
'bruddflater': ('bruddflate',),
'bruddhella': ('bruddhelle',),
'bruddhelle': ('bruddhelle',),
'bruddhellen': ('bruddhelle',),
'bruddhellene': ('bruddhelle',),
'bruddheller': ('bruddhelle',),
'bruddstein': ('bruddstein',),
'bruddsteinen': ('bruddstein',),
'bruddsteinene': ('bruddstein',),
'bruddsteiner': ('bruddstein',),
'bruddstykka': ('bruddstykke',),
'bruddstykke': ('bruddstykke',),
'bruddstykkene': ('bruddstykke',),
'bruddstykker': ('bruddstykke',),
'bruddstykket': ('bruddstykke',),
'bruddstyrke': ('bruddstyrke',),
'bruddstyrken': ('bruddstyrke',),
'bruddstyrkene': ('bruddstyrke',),
'bruddstyrker': ('bruddstyrke',),
'brudebukett': ('brudebukett',),
'brudebuketten': ('brudebukett',),
'brudebukettene': ('brudebukett',),
'brudebuketter': ('brudebukett',),
'brudebukett': ('brudebukett',),
'brudebuketten': ('brudebukett',),
'brudebukettene': ('brudebukett',),
'brudebuketter': ('brudebukett',),
'brudedans': ('brudedans',),
'brudedansen': ('brudedans',),
'brudedansene': ('brudedans',),
'brudedanser': ('brudedans',),
'brudedans': ('brudedans',),
'brudedansen': ('brudedans',),
'brudedansene': ('brudedans',),
'brudedanser': ('brudedans',),
'brudeferd': ('brudeferd',),
'brudeferda': ('brudeferd',),
'brudeferden': ('brudeferd',),
'brudeferdene': ('brudeferd',),
'brudeferder': ('brudeferd',),
'brudeferd': ('brudeferd',),
'brudeferda': ('brudeferd',),
'brudeferden': ('brudeferd',),
'brudeferdene': ('brudeferd',),
'brudeferder': ('brudeferd',),
'brudefølga': ('brudefølge',),
'brudefølge': ('brudefølge',),
'brudefølgene': ('brudefølge',),
'brudefølger': ('brudefølge',),
'brudefølget': ('brudefølge',),
'brudefølga': ('brudefølge',),
'brudefølge': ('brudefølge',),
'brudefølgene': ('brudefølge',),
'brudefølger': ('brudefølge',),
'brudefølget': ('brudefølge',),
'brudefølgja': ('brudefølgje',),
'brudefølgje': ('brudefølgje',),
'brudefølgjene': ('brudefølgje',),
'brudefølgjer': ('brudefølgje',),
'brudefølgjet': ('brudefølgje',),
'brudefølgja': ('brudefølgje',),
'brudefølgje': ('brudefølgje',),
'brudefølgjene': ('brudefølgje',),
'brudefølgjer': ('brudefølgje',),
'brudefølgjet': ('brudefølgje',),
'brudelys': ('brudelys',),
'brudelysa': ('brudelys',),
'brudelysen': ('brudelys',),
'brudelysene': ('brudelys',),
'brudelyser': ('brudelys',),
'brudelyset': ('brudelys',),
'brudelys': ('brudelys',),
'brudelysa': ('brudelys',),
'brudelysen': ('brudelys',),
'brudelysene': ('brudelys',),
'brudelyser': ('brudelys',),
'brudelyset': ('brudelys',),
'brudemarsj': ('brudemarsj',),
'brudemarsjen': ('brudemarsj',),
'brudemarsjene': ('brudemarsj',),
'brudemarsjer': ('brudemarsj',),
'brudemarsj': ('brudemarsj',),
'brudemarsjen': ('brudemarsj',),
'brudemarsjene': ('brudemarsj',),
'brudemarsjer': ('brudemarsj',),
'brudepar': ('brudepar',),
'brudepara': ('brudepar',),
'brudeparene': ('brudepar',),
'brudeparet': ('brudepar',),
'brudepar': ('brudepar',),
'brudepara': ('brudepar',),
'brudeparene': ('brudepar',),
'brudeparet': ('brudepar',),
'brudeseng': ('brudeseng',),
'brudesenga': ('brudeseng',),
'brudesengen': ('brudeseng',),
'brudesengene': ('brudeseng',),
'brudesenger': ('brudeseng',),
'brudeseng': ('brudeseng',),
'brudesenga': ('brudeseng',),
'brudesengen': ('brudeseng',),
'brudesengene': ('brudeseng',),
'brudesenger': ('brudeseng',),
'brudeslør': ('brudeslør',),
'brudesløra': ('brudeslør',),
'brudeslørene': ('brudeslør',),
'brudesløret': ('brudeslør',),
'brudeslør': ('brudeslør',),
'brudesløra': ('brudeslør',),
'brudeslørene': ('brudeslør',),
'brudesløret': ('brudeslør',),
'brudeslør': ('brudeslør',),
'brudesløra': ('brudeslør',),
'brudeslørene': ('brudeslør',),
'brudesløret': ('brudeslør',),
'brudeslør': ('brudeslør',),
'brudesløra': ('brudeslør',),
'brudeslørene': ('brudeslør',),
'brudesløret': ('brudeslør',),
'brudespore': ('brudespore',),
'brudesporen': ('brudespore',),
'brudesporene': ('brudespore',),
'brudesporer': ('brudespore',),
'brudespore': ('brudespore',),
'brudesporen': ('brudespore',),
'brudesporene': ('brudespore',),
'brudesporer': ('brudespore',),
'brudevielse': ('brudevielse',),
'brudevielsen': ('brudevielse',),
'brudevielsene': ('brudevielse',),
'brudevielser': ('brudevielse',),
'brudevielse': ('brudevielse',),
'brudevielsen': ('brudevielse',),
'brudevielsene': ('brudevielse',),
'brudevielser': ('brudevielse',),
'brudevigsel': ('brudevigsel',),
'brudevigselen': ('brudevigsel',),
'brudevigslene': ('brudevigsel',),
'brudevigsler': ('brudevigsel',),
'brudevigsel': ('brudevigsel',),
'brudevigselen': ('brudevigsel',),
'brudevigslene': ('brudevigsel',),
'brudevigsler': ('brudevigsel',),
'brudgom': ('brudgom',),
'brudgommen': ('brudgom',),
'brudgommene': ('brudgom',),
'brudgommer': ('brudgom',),
'brudgomstale': ('brudgomstale',),
'brudgomstalen': ('brudgomstale',),
'brudgomstalene': ('brudgomstale',),
'brudgomstaler': ('brudgomstale',),
'brudulje': ('brudulje',),
'bruduljen': ('brudulje',),
'bruduljene': ('brudulje',),
'bruduljer': ('brudulje',),
'brugda': ('brugde',),
'brugde': ('brugde',),
'brugden': ('brugde',),
'brugdene': ('brugde',),
'brugder': ('brugde',),
'bruhoda': ('bruhode',),
'bruhode': ('bruhode',),
'bruhodene': ('bruhode',),
'bruhoder': ('bruhode',),
'bruhodet': ('bruhode',),
'bruk': ('bruk',),
'bruka': ('bruk',),
'brukene': ('bruk',),
'bruket': ('bruk',),
'bruk': ('bruk',),
'bruka': ('bruk',),
'bruken': ('bruk',),
'brukene': ('bruk',),
'bruker': ('bruk',),
'bruket': ('bruk',),
'brukar': ('brukar',),
'brukara': ('brukar',),
'brukarene': ('brukar',),
'brukaret': ('brukar',),
'brukelighet': ('brukelighet',),
'brukeligheta': ('brukelighet',),
'brukeligheten': ('brukelighet',),
'brukelighetene': ('brukelighet',),
'brukeligheter': ('brukelighet',),
'bruker': ('bruker',),
'brukere': ('bruker',),
'brukeren': ('bruker',),
'brukerer': ('bruker',),
'brukerne': ('bruker',),
'bruksanvisning': ('bruksanvisning',),
'bruksanvisninga': ('bruksanvisning',),
'bruksanvisningen': ('bruksanvisning',),
'bruksanvisningene': ('bruksanvisning',),
'bruksanvisninger': ('bruksanvisning',),
'bruksegenskap': ('bruksegenskap',),
'bruksegenskapen': ('bruksegenskap',),
'bruksegenskapene': ('bruksegenskap',),
'bruksegenskaper': ('bruksegenskap',),
'brukseier': ('brukseier',),
'brukseiere': ('brukseier',),
'brukseieren': ('brukseier',),
'brukseierer': ('brukseier',),
'brukseierne': ('brukseier',),
'bruksendring': ('bruksendring',),
'bruksendringa': ('bruksendring',),
'bruksendringen': ('bruksendring',),
'bruksendringene': ('bruksendring',),
'bruksendringer': ('bruksendring',),
'bruksgjenstand': ('bruksgjenstand',),
'bruksgjenstanden': ('bruksgjenstand',),
'bruksgjenstandene': ('bruksgjenstand',),
'bruksgjenstander': ('bruksgjenstand',),
'brukshaver': ('brukshaver',),
'brukshavere': ('brukshaver',),
'brukshaveren': ('brukshaver',),
'brukshaverer': ('brukshaver',),
'brukshaverne': ('brukshaver',),
'brukskultur': ('brukskultur',),
'brukskulturen': ('brukskultur',),
'brukskulturene': ('brukskultur',),
'brukskulturer': ('brukskultur',),
'brukskunst': ('brukskunst',),
'brukskunsten': ('brukskunst',),
'brukskunstene': ('brukskunst',),
'brukskunster': ('brukskunst',),
'brukskunstner': ('brukskunstner',),
'brukskunstnere': ('brukskunstner',),
'brukskunstneren': ('brukskunstner',),
'brukskunstnerer': ('brukskunstner',),
'brukskunstnerne': ('brukskunstner',),
'bruksmåte': ('bruksmåte',),
'bruksmåten': ('bruksmåte',),
'bruksmåtene': ('bruksmåte',),
'bruksmåter': ('bruksmåte',),
'bruksnummer': ('bruksnummer',),
'bruksnummeret': ('bruksnummer',),
'bruksnumra': ('bruksnummer',),
'bruksnumre': ('bruksnummer',),
'bruksnumrene': ('bruksnummer',),
'bruksområda': ('bruksområde',),
'bruksområde': ('bruksområde',),
'bruksområdene': ('bruksområde',),
'bruksområder': ('bruksområde',),
'bruksområdet': ('bruksområde',),
'bruksplen': ('bruksplen',),
'bruksplenen': ('bruksplen',),
'bruksplenene': ('bruksplen',),
'bruksplener': ('bruksplen',),
'bruksplikt': ('bruksplikt',),
'bruksplikta': ('bruksplikt',),
'bruksplikten': ('bruksplikt',),
'brukspliktene': ('bruksplikt',),
'bruksplikter': ('bruksplikt',),
'bruksrett': ('bruksrett',),
'bruksretten': ('bruksrett',),
'bruksrettene': ('bruksrett',),
'bruksretter': ('bruksrett',),
'bruksskog': ('bruksskog',),
'bruksskogen': ('bruksskog',),
'bruksskogene': ('bruksskog',),
'bruksskoger': ('bruksskog',),
'brukstid': ('brukstid',),
'brukstida': ('brukstid',),
'brukstiden': ('brukstid',),
'brukstidene': ('brukstid',),
'brukstider': ('brukstid',),
'brukstjuveri': ('brukstjuveri',),
'brukstjuveria': ('brukstjuveri',),
'brukstjuveriene': ('brukstjuveri',),
'brukstjuverier': ('brukstjuveri',),
'brukstjuveriet': ('brukstjuveri',),
'brukstyveri': ('brukstyveri',),
'brukstyveria': ('brukstyveri',),
'brukstyveriene': ('brukstyveri',),
'brukstyverier': ('brukstyveri',),
'brukstyveriet': ('brukstyveri',),
'bruksverdi': ('bruksverdi',),
'bruksverdien': ('bruksverdi',),
'bruksverdiene': ('bruksverdi',),
'bruksverdier': ('bruksverdi',),
'bruktbil': ('bruktbil',),
'bruktbilen': ('bruktbil',),
'bruktbilene': ('bruktbil',),
'bruktbiler': ('bruktbil',),
'bruktbilforhandler': ('bruktbilforhandler',),
'bruktbilforhandlere': ('bruktbilforhandler',),
'bruktbilforhandleren': ('bruktbilforhandler',),
'bruktbilforhandlerer': ('bruktbilforhandler',),
'bruktbilforhandlerne': ('bruktbilforhandler',),
'bruktbilmarked': ('bruktbilmarked',),
'bruktbilmarkeda': ('bruktbilmarked',),
'bruktbilmarkedene': ('bruktbilmarked',),
'bruktbilmarkeder': ('bruktbilmarked',),
'bruktbilmarkedet': ('bruktbilmarked',),
'bruktbilmarknad': ('bruktbilmarknad',),
'bruktbilmarknaden': ('bruktbilmarknad',),
'bruktbilmarknadene': ('bruktbilmarknad',),
'bruktbilmarknader': ('bruktbilmarknad',),
'brulegger': ('brulegger',),
'bruleggere': ('brulegger',),
'bruleggeren': ('brulegger',),
'bruleggerer': ('brulegger',),
'bruleggerne': ('brulegger',),
'brulegging': ('brulegging',),
'brulegginga': ('brulegging',),
'bruleggingen': ('brulegging',),
'bruleggingene': ('brulegging',),
'brulegginger': ('brulegging',),
'brulegning': ('brulegning',),
'brulegninga': ('brulegning',),
'brulegningen': ('brulegning',),
'brulegningene': ('brulegning',),
'brulegninger': ('brulegning',),
'brum': ('brum',),
'brumma': ('brum',),
'brummene': ('brum',),
'brummet': ('brum',),
'brumlebasse': ('brumlebasse',),
'brumlebassen': ('brumlebasse',),
'brumlebassene': ('brumlebasse',),
'brumlebasser': ('brumlebasse',),
'brunalge': ('brunalge',),
'brunalgen': ('brunalge',),
'brunalgene': ('brunalge',),
'brunalger': ('brunalge',),
'brunbjørn': ('brunbjørn',),
'brunbjørnen': ('brunbjørn',),
'brunbjørnene': ('brunbjørn',),
'brunbjørner': ('brunbjørn',),
'bruneier': ('bruneier',),
'bruneiere': ('bruneier',),
'bruneieren': ('bruneier',),
'bruneierer': ('bruneier',),
'bruneierne': ('bruneier',),
'brunetta': ('brunette',),
'brunette': ('brunette',),
'brunetten': ('brunette',),
'brunettene': ('brunette',),
'brunetter': ('brunette',),
'brunfe': ('brunfe',),
'brunfea': ('brunfe',),
'brunfeene': ('brunfe',),
'brunfeet': ('brunfe',),
'brunjernstein': ('brunjernstein',),
'brunjernsteinen': ('brunjernstein',),
'brunjernsteinene': ('brunjernstein',),
'brunjernsteiner': ('brunjernstein',),
'brunkol': ('brunkol',),
'brunkola': ('brunkol',),
'brunkolene': ('brunkol',),
'brunkolet': ('brunkol',),
'brunkol': ('brunkol',),
'brunkola': ('brunkol',),
'brunkolet': ('brunkol',),
'brunkoltjæra': ('brunkoltjære',),
'brunkoltjære': ('brunkoltjære',),
'brunkoltjæren': ('brunkoltjære',),
'brunkoltjærene': ('brunkoltjære',),
'brunkoltjærer': ('brunkoltjære',),
'brunkull': ('brunkull',),
'brunkulla': ('brunkull',),
'brunkullene': ('brunkull',),
'brunkullet': ('brunkull',),
'brunkulltjæra': ('brunkulltjære',),
'brunkulltjære': ('brunkulltjære',),
'brunkulltjæren': ('brunkulltjære',),
'brunkulltjærene': ('brunkulltjære',),
'brunkulltjærer': ('brunkulltjære',),
'brunnakke': ('brunnakke',),
'brunnakken': ('brunnakke',),
'brunnakkene': ('brunnakke',),
'brunnakker': ('brunnakke',),
'brunost': ('brunost',),
'brunosten': ('brunost',),
'brunostene': ('brunost',),
'brunoster': ('brunost',),
'brunrot': ('brunrot',),
'brunrota': ('brunrot',),
'brunroten': ('brunrot',),
'brunrøttene': ('brunrot',),
'brunrøtter': ('brunrot',),
'brunsj': ('brunsj',),
'brunsjen': ('brunsj',),
'brunsjene': ('brunsj',),
'brunsjer': ('brunsj',),
'brunskjorta': ('brunskjorte',),
'brunskjorte': ('brunskjorte',),
'brunskjorten': ('brunskjorte',),
'brunskjortene': ('brunskjorte',),
'brunskjorter': ('brunskjorte',),
'brunst': ('brunst',),
'brunsten': ('brunst',),
'brunstene': ('brunst',),
'brunster': ('brunst',),
'brunstein': ('brunstein',),
'brunsteinen': ('brunstein',),
'brunsteinene': ('brunstein',),
'brunsteiner': ('brunstein',),
'brunsttid': ('brunsttid',),
'brunsttida': ('brunsttid',),
'brunsttiden': ('brunsttid',),
'brunsttidene': ('brunsttid',),
'brunsttider': ('brunsttid',),
'brunsukker': ('brunsukker',),
'brunsukkera': ('brunsukker',),
'brunsukkere': ('brunsukker',),
'brunsukkerene': ('brunsukker',),
'brunsukkeret': ('brunsukker',),
'brunsukkerne': ('brunsukker',),
'brunt': ('brunt',),
'brunvara': ('brunvare',),
'brunvare': ('brunvare',),
'brunvaren': ('brunvare',),
'brunvarene': ('brunvare',),
'brunvarer': ('brunvare',),
'brupilar': ('brupilar',),
'brupilaren': ('brupilar',),
'brupilarene': ('brupilar',),
'brupilarer': ('brupilar',),
'brur': ('brur',),
'brura': ('brur',),
'bruren': ('brur',),
'brurene': ('brur',),
'brurer': ('brur',),
'brur': ('brur',),
'brura': ('brur',),
'brurene': ('brur',),
'brurer': ('brur',),
'brurbukett': ('brurbukett',),
'brurbuketten': ('brurbukett',),
'brurbukettene': ('brurbukett',),
'brurbuketter': ('brurbukett',),
'brurbukett': ('brurbukett',),
'brurbuketten': ('brurbukett',),
'brurbukettene': ('brurbukett',),
'brurbuketter': ('brurbukett',),
'brurdans': ('brurdans',),
'brurdansen': ('brurdans',),
'brurdansene': ('brurdans',),
'brurdanser': ('brurdans',),
'brurdans': ('brurdans',),
'brurdansen': ('brurdans',),
'brurdansene': ('brurdans',),
'brurdanser': ('brurdans',),
'brurebukett': ('brurebukett',),
'brurebuketten': ('brurebukett',),
'brurebukettene': ('brurebukett',),
'brurebuketter': ('brurebukett',),
'brurebukett': ('brurebukett',),
'brurebuketten': ('brurebukett',),
'brurebukettene': ('brurebukett',),
'brurebuketter': ('brurebukett',),
'bruredans': ('bruredans',),
'bruredansen': ('bruredans',),
'bruredansene': ('bruredans',),
'bruredanser': ('bruredans',),
'bruredans': ('bruredans',),
'bruredansen': ('bruredans',),
'bruredansene': ('bruredans',),
'bruredanser': ('bruredans',),
'brureferd': ('brureferd',),
'brureferda': ('brureferd',),
'brureferden': ('brureferd',),
'brureferdene': ('brureferd',),
'brureferder': ('brureferd',),
'brureferd': ('brureferd',),
'brureferda': ('brureferd',),
'brureferden': ('brureferd',),
'brureferdene': ('brureferd',),
'brureferder': ('brureferd',),
'brurefølga': ('brurefølge',),
'brurefølge': ('brurefølge',),
'brurefølgene': ('brurefølge',),
'brurefølger': ('brurefølge',),
'brurefølget': ('brurefølge',),
'brurefølga': ('brurefølge',),
'brurefølge': ('brurefølge',),
'brurefølgene': ('brurefølge',),
'brurefølger': ('brurefølge',),
'brurefølget': ('brurefølge',),
'brurefølgja': ('brurefølgje',),
'brurefølgje': ('brurefølgje',),
'brurefølgjene': ('brurefølgje',),
'brurefølgjer': ('brurefølgje',),
'brurefølgjet': ('brurefølgje',),
'brurefølgja': ('brurefølgje',),
'brurefølgje': ('brurefølgje',),
'brurefølgjene': ('brurefølgje',),
'brurefølgjer': ('brurefølgje',),
'brurefølgjet': ('brurefølgje',),
'brurelys': ('brurelys',),
'brurelysa': ('brurelys',),
'brurelysen': ('brurelys',),
'brurelysene': ('brurelys',),
'brurelyser': ('brurelys',),
'brurelyset': ('brurelys',),
'brurelys': ('brurelys',),
'brurelysa': ('brurelys',),
'brurelysen': ('brurelys',),
'brurelysene': ('brurelys',),
'brurelyser': ('brurelys',),
'brurelyset': ('brurelys',),
'bruremarsj': ('bruremarsj',),
'bruremarsjen': ('bruremarsj',),
'bruremarsjene': ('bruremarsj',),
'bruremarsjer': ('bruremarsj',),
'bruremarsj': ('bruremarsj',),
'bruremarsjen': ('bruremarsj',),
'bruremarsjene': ('bruremarsj',),
'bruremarsjer': ('bruremarsj',),
'brurepar': ('brurepar',),
'brurepara': ('brurepar',),
'brureparene': ('brurepar',),
'brureparet': ('brurepar',),
'brurepar': ('brurepar',),
'brurepara': ('brurepar',),
'brureparene': ('brurepar',),
'brureparet': ('brurepar',),
'brureseng': ('brureseng',),
'bruresenga': ('brureseng',),
'bruresengen': ('brureseng',),
'bruresengene': ('brureseng',),
'bruresenger': ('brureseng',),
'brureseng': ('brureseng',),
'bruresenga': ('brureseng',),
'bruresengen': ('brureseng',),
'bruresengene': ('brureseng',),
'bruresenger': ('brureseng',),
'brureslør': ('brureslør',),
'bruresløra': ('brureslør',),
'brureslørene': ('brureslør',),
'bruresløret': ('brureslør',),
'brureslør': ('brureslør',),
'bruresløra': ('brureslør',),
'brureslørene': ('brureslør',),
'bruresløret': ('brureslør',),
'brureslør': ('brureslør',),
'bruresløra': ('brureslør',),
'brureslørene': ('brureslør',),
'bruresløret': ('brureslør',),
'brureslør': ('brureslør',),
'bruresløra': ('brureslør',),
'brureslørene': ('brureslør',),
'bruresløret': ('brureslør',),
'brurespore': ('brurespore',),
'bruresporen': ('brurespore',),
'bruresporene': ('brurespore',),
'bruresporer': ('brurespore',),
'brurespore': ('brurespore',),
'bruresporen': ('brurespore',),
'bruresporene': ('brurespore',),
'bruresporer': ('brurespore',),
'brurevielse': ('brurevielse',),
'brurevielsen': ('brurevielse',),
'brurevielsene': ('brurevielse',),
'brurevielser': ('brurevielse',),
'brurevielse': ('brurevielse',),
'brurevielsen': ('brurevielse',),
'brurevielsene': ('brurevielse',),
'brurevielser': ('brurevielse',),
'brurevigsel': ('brurevigsel',),
'brurevigselen': ('brurevigsel',),
'brurevigslene': ('brurevigsel',),
'brurevigsler': ('brurevigsel',),
'brurevigsel': ('brurevigsel',),
'brurevigselen': ('brurevigsel',),
'brurevigslene': ('brurevigsel',),
'brurevigsler': ('brurevigsel',),
'brurferd': ('brurferd',),
'brurferda': ('brurferd',),
'brurferden': ('brurferd',),
'brurferdene': ('brurferd',),
'brurferder': ('brurferd',),
'brurferd': ('brurferd',),
'brurferda': ('brurferd',),
'brurferden': ('brurferd',),
'brurferdene': ('brurferd',),
'brurferder': ('brurferd',),
'brurfølga': ('brurfølge',),
'brurfølge': ('brurfølge',),
'brurfølgene': ('brurfølge',),
'brurfølger': ('brurfølge',),
'brurfølget': ('brurfølge',),
'brurfølga': ('brurfølge',),
'brurfølge': ('brurfølge',),
'brurfølgene': ('brurfølge',),
'brurfølger': ('brurfølge',),
'brurfølget': ('brurfølge',),
'brurfølgja': ('brurfølgje',),
'brurfølgje': ('brurfølgje',),
'brurfølgjene': ('brurfølgje',),
'brurfølgjer': ('brurfølgje',),
'brurfølgjet': ('brurfølgje',),
'brurfølgja': ('brurfølgje',),
'brurfølgje': ('brurfølgje',),
'brurfølgjene': ('brurfølgje',),
'brurfølgjer': ('brurfølgje',),
'brurfølgjet': ('brurfølgje',),
'brurlys': ('brurlys',),
'brurlysa': ('brurlys',),
'brurlysen': ('brurlys',),
'brurlysene': ('brurlys',),
'brurlyser': ('brurlys',),
'brurlyset': ('brurlys',),
'brurlys': ('brurlys',),
'brurlysa': ('brurlys',),
'brurlysen': ('brurlys',),
'brurlysene': ('brurlys',),
'brurlyser': ('brurlys',),
'brurlyset': ('brurlys',),
'brurmarsj': ('brurmarsj',),
'brurmarsjen': ('brurmarsj',),
'brurmarsjene': ('brurmarsj',),
'brurmarsjer': ('brurmarsj',),
'brurmarsj': ('brurmarsj',),
'brurmarsjen': ('brurmarsj',),
'brurmarsjene': ('brurmarsj',),
'brurmarsjer': ('brurmarsj',),
'brurpar': ('brurpar',),
'brurpara': ('brurpar',),
'brurparene': ('brurpar',),
'brurparet': ('brurpar',),
'brurpar': ('brurpar',),
'brurpara': ('brurpar',),
'brurparene': ('brurpar',),
'brurparet': ('brurpar',),
'brurseng': ('brurseng',),
'brursenga': ('brurseng',),
'brursengen': ('brurseng',),
'brursengene': ('brurseng',),
'brursenger': ('brurseng',),
'brurseng': ('brurseng',),
'brursenga': ('brurseng',),
'brursengen': ('brurseng',),
'brursengene': ('brurseng',),
'brursenger': ('brurseng',),
'brurslør': ('brurslør',),
'brursløra': ('brurslør',),
'brurslørene': ('brurslør',),
'brursløret': ('brurslør',),
'brurslør': ('brurslør',),
'brursløra': ('brurslør',),
'brurslørene': ('brurslør',),
'brursløret': ('brurslør',),
'brurslør': ('brurslør',),
'brursløra': ('brurslør',),
'brurslørene': ('brurslør',),
'brursløret': ('brurslør',),
'brurslør': ('brurslør',),
'brursløra': ('brurslør',),
'brurslørene': ('brurslør',),
'brursløret': ('brurslør',),
'brurspore': ('brurspore',),
'brursporen': ('brurspore',),
'brursporene': ('brurspore',),
'brursporer': ('brurspore',),
'brurspore': ('brurspore',),
'brursporen': ('brurspore',),
'brursporene': ('brurspore',),
'brursporer': ('brurspore',),
'brurvielse': ('brurvielse',),
'brurvielsen': ('brurvielse',),
'brurvielsene': ('brurvielse',),
'brurvielser': ('brurvielse',),
'brurvielse': ('brurvielse',),
'brurvielsen': ('brurvielse',),
'brurvielsene': ('brurvielse',),
'brurvielser': ('brurvielse',),
'brurvigsel': ('brurvigsel',),
'brurvigselen': ('brurvigsel',),
'brurvigslene': ('brurvigsel',),
'brurvigsler': ('brurvigsel',),
'brurvigsel': ('brurvigsel',),
'brurvigselen': ('brurvigsel',),
'brurvigslene': ('brurvigsel',),
'brurvigsler': ('brurvigsel',),
'brus': ('brus',),
'brusen': ('brus',),
'brusene': ('brus',),
'brus': ('brus',),
'brusa': ('brus',),
'brusene': ('brus',),
'bruset': ('brus',),
'brushane': ('brushane',),
'brushanen': ('brushane',),
'brushanene': ('brushane',),
'brushaner': ('brushane',),
'brushoda': ('brushode',),
'brushode': ('brushode',),
'brushodene': ('brushode',),
'brushoder': ('brushode',),
'brushodet': ('brushode',),
'brusk': ('brusk',),
'brusken': ('brusk',),
'bruskene': ('brusk',),
'brusker': ('brusk',),
'bruskfisk': ('bruskfisk',),
'bruskfisken': ('bruskfisk',),
'bruskfiskene': ('bruskfisk',),
'bruskfisker': ('bruskfisk',),
'bruskplata': ('bruskplate',),
'bruskplate': ('bruskplate',),
'bruskplaten': ('bruskplate',),
'bruskplatene': ('bruskplate',),
'bruskplater': ('bruskplate',),
'bruskskiva': ('bruskskive',),
'bruskskive': ('bruskskive',),
'bruskskiven': ('bruskskive',),
'bruskskivene': ('bruskskive',),
'bruskskiver': ('bruskskive',),
'bruskskjelett': ('bruskskjelett',),
'bruskskjeletta': ('bruskskjelett',),
'bruskskjelettene': ('bruskskjelett',),
'bruskskjeletter': ('bruskskjelett',),
'bruskskjelettet': ('bruskskjelett',),
'bruskvev': ('bruskvev',),
'bruskveva': ('bruskvev',),
'bruskvevene': ('bruskvev',),
'bruskvevet': ('bruskvev',),
'bruspenn': ('bruspenn',),
'bruspenna': ('bruspenn',),
'bruspennene': ('bruspenn',),
'bruspennet': ('bruspenn',),
'bruspulver': ('bruspulver',),
'bruspulvera': ('bruspulver',),
'bruspulvere': ('bruspulver',),
'bruspulveret': ('bruspulver',),
'bruspulverne': ('bruspulver',),
'brusselknipling': ('brusselknipling',),
'brusselkniplingen': ('brusselknipling',),
'brusselkniplingene': ('brusselknipling',),
'brusselkniplinger': ('brusselknipling',),
'brusselknipling': ('brusselknipling',),
'brusselkniplingen': ('brusselknipling',),
'brusselkniplingene': ('brusselknipling',),
'brusselkniplinger': ('brusselknipling',),
'brusselteppa': ('brusselteppe',),
'brusselteppe': ('brusselteppe',),
'brusselteppene': ('brusselteppe',),
'brusseltepper': ('brusselteppe',),
'brusselteppet': ('brusselteppe',),
'brusselteppa': ('brusselteppe',),
'brusselteppe': ('brusselteppe',),
'brusselteppene': ('brusselteppe',),
'brusseltepper': ('brusselteppe',),
'brusselteppet': ('brusselteppe',),
'brustein': ('brustein',),
'brusteinen': ('brustein',),
'brusteinene': ('brustein',),
'brusteiner': ('brustein',),
'brutalitet': ('brutalitet',),
'brutaliteten': ('brutalitet',),
'brutalitetene': ('brutalitet',),
'brutaliteter': ('brutalitet',),
'brutto': ('brutto',),
'bruttoen': ('brutto',),
'bruttoene': ('brutto',),
'bruttoer': ('brutto',),
'bruttoavling': ('bruttoavling',),
'bruttoavlinga': ('bruttoavling',),
'bruttoavlingen': ('bruttoavling',),
'bruttoavlingene': ('bruttoavling',),
'bruttoavlinger': ('bruttoavling',),
'bruttobeløp': ('bruttobeløp',),
'bruttobeløpa': ('bruttobeløp',),
'bruttobeløpene': ('bruttobeløp',),
'bruttobeløpet': ('bruttobeløp',),
'bruttobudsjett': ('bruttobudsjett',),
'bruttobudsjetta': ('bruttobudsjett',),
'bruttobudsjettene': ('bruttobudsjett',),
'bruttobudsjetter': ('bruttobudsjett',),
'bruttobudsjettet': ('bruttobudsjett',),
'bruttoformue': ('bruttoformue',),
'bruttoformuen': ('bruttoformue',),
'bruttoformuene': ('bruttoformue',),
'bruttoformuer': ('bruttoformue',),
'bruttofortjenesta': ('bruttofortjeneste',),
'bruttofortjeneste': ('bruttofortjeneste',),
'bruttofortjenesten': ('bruttofortjeneste',),
'bruttofortjenestene': ('bruttofortjeneste',),
'bruttofortjenester': ('bruttofortjeneste',),
'bruttoinntekt': ('bruttoinntekt',),
'bruttoinntekta': ('bruttoinntekt',),
'bruttoinntekten': ('bruttoinntekt',),
'bruttoinntektene': ('bruttoinntekt',),
'bruttoinntekter': ('bruttoinntekt',),
'bruttonasjonalprodukt': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukta': ('bruttonasjonalprodukt',),
'bruttonasjonalproduktene': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukter': ('bruttonasjonalprodukt',),
'bruttonasjonalproduktet': ('bruttonasjonalprodukt',),
'bruttoregistertonn': ('bruttoregistertonn',),
'bruttoregistertonna': ('bruttoregistertonn',),
'bruttoregistertonnene': ('bruttoregistertonn',),
'bruttoregistertonnet': ('bruttoregistertonn',),
'bruttotonnasje': ('bruttotonnasje',),
'bruttotonnasjen': ('bruttotonnasje',),
'bruttotonnasjene': ('bruttotonnasje',),
'bruttotonnasjer': ('bruttotonnasje',),
'bruttovekt': ('bruttovekt',),
'bruttovekta': ('bruttovekt',),
'bruttovekten': ('bruttovekt',),
'bruttovektene': ('bruttovekt',),
'bruttovekter': ('bruttovekt',),
'bry': ('bry',),
'brya': ('bry',),
'bryene': ('bry',),
'bryet': ('bry',),
'bryderi': ('bryderi',),
'bryderia': ('bryderi',),
'bryderiene': ('bryderi',),
'bryderier': ('bryderi',),
'bryderiet': ('bryderi',),
'brygg': ('brygg',),
'brygga': ('brygg',),
'bryggene': ('brygg',),
'brygget': ('brygg',),
'brygga': ('brygge',),
'brygge': ('brygge',),
'bryggen': ('brygge',),
'bryggene': ('brygge',),
'brygger': ('brygge',),
'bryggearbeider': ('bryggearbeider',),
'bryggearbeidere': ('bryggearbeider',),
'bryggearbeideren': ('bryggearbeider',),
'bryggearbeiderer': ('bryggearbeider',),
'bryggearbeiderne': ('bryggearbeider',),
'bryggeavgift': ('bryggeavgift',),
'bryggeavgifta': ('bryggeavgift',),
'bryggeavgiften': ('bryggeavgift',),
'bryggeavgiftene': ('bryggeavgift',),
'bryggeavgifter': ('bryggeavgift',),
'bryggedans': ('bryggedans',),
'bryggedansen': ('bryggedans',),
'bryggedansene': ('bryggedans',),
'bryggedanser': ('bryggedans',),
'bryggekjel': ('bryggekjel',),
'bryggekjelen': ('bryggekjel',),
'bryggekjelene': ('bryggekjel',),
'bryggekjeler': ('bryggekjel',),
'bryggekjele': ('bryggekjele',),
'bryggekjelen': ('bryggekjele',),
'bryggekjelene': ('bryggekjele',),
'bryggekjeler': ('bryggekjele',),
'bryggepanna': ('bryggepanne',),
'bryggepanne': ('bryggepanne',),
'bryggepannen': ('bryggepanne',),
'bryggepannene': ('bryggepanne',),
'bryggepanner': ('bryggepanne',),
'brygger': ('brygger',),
'bryggere': ('brygger',),
'bryggeren': ('brygger',),
'bryggerer': ('brygger',),
'bryggerne': ('brygger',),
'bryggerhest': ('bryggerhest',),
'bryggerhesten': ('bryggerhest',),
'bryggerhestene': ('bryggerhest',),
'bryggerhester': ('bryggerhest',),
'bryggerhus': ('bryggerhus',),
'bryggerhusa': ('bryggerhus',),
'bryggerhusene': ('bryggerhus',),
'bryggerhuset': ('bryggerhus',),
'bryggeri': ('bryggeri',),
'bryggeria': ('bryggeri',),
'bryggeriene': ('bryggeri',),
'bryggerier': ('bryggeri',),
'bryggeriet': ('bryggeri',),
'bryggerihest': ('bryggerihest',),
'bryggerihesten': ('bryggerihest',),
'bryggerihestene': ('bryggerihest',),
'bryggerihester': ('bryggerihest',),
'bryggesjauer': ('bryggesjauer',),
'bryggesjauere': ('bryggesjauer',),
'bryggesjaueren': ('bryggesjauer',),
'bryggesjauerer': ('bryggesjauer',),
'bryggesjauerne': ('bryggesjauer',),
'bryllup': ('bryllup',),
'bryllupa': ('bryllup',),
'bryllupene': ('bryllup',),
'brylluper': ('bryllup',),
'bryllupet': ('bryllup',),
'bryllupsdag': ('bryllupsdag',),
'bryllupsdagen': ('bryllupsdag',),
'bryllupsdagene': ('bryllupsdag',),
'bryllupsdager': ('bryllupsdag',),
'bryllupsgava': ('bryllupsgave',),
'bryllupsgave': ('bryllupsgave',),
'bryllupsgaven': ('bryllupsgave',),
'bryllupsgavene': ('bryllupsgave',),
'bryllupsgaver': ('bryllupsgave',),
'bryllupsklokka': ('bryllupsklokke',),
'bryllupsklokke': ('bryllupsklokke',),
'bryllupsklokken': ('bryllupsklokke',),
'bryllupsklokkene': ('bryllupsklokke',),
'bryllupsklokker': ('bryllupsklokke',),
'bryllupsmarsj': ('bryllupsmarsj',),
'bryllupsmarsjen': ('bryllupsmarsj',),
'bryllupsmarsjene': ('bryllupsmarsj',),
'bryllupsmarsjer': ('bryllupsmarsj',),
'bryllupsnatt': ('bryllupsnatt',),
'bryllupsnatta': ('bryllupsnatt',),
'bryllupsnatten': ('bryllupsnatt',),
'bryllupsnettene': ('bryllupsnatt',),
'bryllupsnetter': ('bryllupsnatt',),
'bryllupsreisa': ('bryllupsreise',),
'bryllupsreise': ('bryllupsreise',),
'bryllupsreisen': ('bryllupsreise',),
'bryllupsreisene': ('bryllupsreise',),
'bryllupsreiser': ('bryllupsreise',),
'bryn': ('bryn',),
'bryna': ('bryn',),
'brynene': ('bryn',),
'brynet': ('bryn',),
'brynde': ('brynde',),
'brynden': ('brynde',),
'bryndene': ('brynde',),
'brynder': ('brynde',),
'bryna': ('bryne',),
'bryne': ('bryne',),
'brynene': ('bryne',),
'bryner': ('bryne',),
'brynet': ('bryne',),
'brynja': ('brynje',),
'brynje': ('brynje',),
'brynjen': ('brynje',),
'brynjene': ('brynje',),
'brynjer': ('brynje',),
'bryolog': ('bryolog',),
'bryologen': ('bryolog',),
'bryologene': ('bryolog',),
'bryologer': ('bryolog',),
'bryologi': ('bryologi',),
'bryologien': ('bryologi',),
'bryologiene': ('bryologi',),
'bryologier': ('bryologi',),
'brysselerknipling': ('brysselerknipling',),
'brysselerkniplingen': ('brysselerknipling',),
'brysselerkniplingene': ('brysselerknipling',),
'brysselerkniplinger': ('brysselerknipling',),
'brysselerknipling': ('brysselerknipling',),
'brysselerkniplingen': ('brysselerknipling',),
'brysselerkniplingene': ('brysselerknipling',),
'brysselerkniplinger': ('brysselerknipling',),
'brysselerteppa': ('brysselerteppe',),
'brysselerteppe': ('brysselerteppe',),
'brysselerteppene': ('brysselerteppe',),
'brysselertepper': ('brysselerteppe',),
'brysselerteppet': ('brysselerteppe',),
'brysselerteppa': ('brysselerteppe',),
'brysselerteppe': ('brysselerteppe',),
'brysselerteppene': ('brysselerteppe',),
'brysselertepper': ('brysselerteppe',),
'brysselerteppet': ('brysselerteppe',),
'bryst': ('bryst',),
'brysta': ('bryst',),
'brystene': ('bryst',),
'bryster': ('bryst',),
'brystet': ('bryst',),
'brystbarn': ('brystbarn',),
'brystbarna': ('brystbarn',),
'brystbarnene': ('brystbarn',),
'brystbarnet': ('brystbarn',),
'brystbilda': ('brystbilde',),
'brystbilde': ('brystbilde',),
'brystbildene': ('brystbilde',),
'brystbilder': ('brystbilde',),
'brystbildet': ('brystbilde',),
'brysthinna': ('brysthinne',),
'brysthinne': ('brysthinne',),
'brysthinnen': ('brysthinne',),
'brysthinnene': ('brysthinne',),
'brysthinner': ('brysthinne',),
'brysthinnebetennelse': ('brysthinnebetennelse',),
'brysthinnebetennelsen': ('brysthinnebetennelse',),
'brysthinnebetennelsene': ('brysthinnebetennelse',),
'brysthinnebetennelser': ('brysthinnebetennelse',),
'brystholder': ('brystholder',),
'brystholdere': ('brystholder',),
'brystholderen': ('brystholder',),
'brystholderer': ('brystholder',),
'brystholderne': ('brystholder',),
'brysthola': ('brysthole',),
'brysthole': ('brysthole',),
'brystholen': ('brysthole',),
'brystholene': ('brysthole',),
'brystholer': ('brysthole',),
'brysthula': ('brysthule',),
'brysthule': ('brysthule',),
'brysthulen': ('brysthule',),
'brysthulene': ('brysthule',),
'brysthuler': ('brysthule',),
'brysthøgd': ('brysthøgd',),
'brysthøgda': ('brysthøgd',),
'brysthøgdene': ('brysthøgd',),
'brysthøgder': ('brysthøgd',),
'brysthøyde': ('brysthøyde',),
'brysthøyden': ('brysthøyde',),
'brysthøydene': ('brysthøyde',),
'brysthøyder': ('brysthøyde',),
'brystkassa': ('brystkasse',),
'brystkasse': ('brystkasse',),
'brystkassen': ('brystkasse',),
'brystkassene': ('brystkasse',),
'brystkasser': ('brystkasse',),
'brystkreft': ('brystkreft',),
'brystkreften': ('brystkreft',),
'brystkreftene': ('brystkreft',),
'brystkrefter': ('brystkreft',),
'brystlomma': ('brystlomme',),
'brystlomme': ('brystlomme',),
'brystlommen': ('brystlomme',),
'brystlommene': ('brystlomme',),
'brystlommer': ('brystlomme',),
'brystmål': ('brystmål',),
'brystmåla': ('brystmål',),
'brystmålene': ('brystmål',),
'brystmålet': ('brystmål',),
'brystning': ('brystning',),
'brystninga': ('brystning',),
'brystningen': ('brystning',),
'brystningene': ('brystning',),
'brystninger': ('brystning',),
'brystnål': ('brystnål',),
'brystnåla': ('brystnål',),
'brystnålen': ('brystnål',),
'brystnålene': ('brystnål',),
'brystnåler': ('brystnål',),
'brystsvømming': ('brystsvømming',),
'brystsvømminga': ('brystsvømming',),
'brystsvømmingen': ('brystsvømming',),
'brystsvømmingene': ('brystsvømming',),
'brystsvømminger': ('brystsvømming',),
'brysttone': ('brysttone',),
'brysttonen': ('brysttone',),
'brysttonene': ('brysttone',),
'brysttoner': ('brysttone',),
'brystvern': ('brystvern',),
'brystverna': ('brystvern',),
'brystvernene': ('brystvern',),
'brystvernet': ('brystvern',),
'brystvirvel': ('brystvirvel',),
'brystvirvelen': ('brystvirvel',),
'brystvirvlene': ('brystvirvel',),
'brystvirvler': ('brystvirvel',),
'brystvorta': ('brystvorte',),
'brystvorte': ('brystvorte',),
'brystvorten': ('brystvorte',),
'brystvortene': ('brystvorte',),
'brystvorter': ('brystvorte',),
'brytbønna': ('brytbønne',),
'brytbønne': ('brytbønne',),
'brytbønnen': ('brytbønne',),
'brytbønnene': ('brytbønne',),
'brytbønner': ('brytbønne',),
'brytekamp': ('brytekamp',),
'brytekampen': ('brytekamp',),
'brytekampene': ('brytekamp',),
'brytekamper': ('brytekamp',),
'bryter': ('bryter',),
'brytere': ('bryter',),
'bryteren': ('bryter',),
'bryterer': ('bryter',),
'bryterne': ('bryter',),
'bryterpanel': ('bryterpanel',),
'bryterpanela': ('bryterpanel',),
'bryterpanelene': ('bryterpanel',),
'bryterpaneler': ('bryterpanel',),
'bryterpanelet': ('bryterpanel',),
'bryterskap': ('bryterskap',),
'bryterskapa': ('bryterskap',),
'bryterskapene': ('bryterskap',),
'bryterskapet': ('bryterskap',),
'brytertak': ('brytertak',),
'brytertaka': ('brytertak',),
'brytertakene': ('brytertak',),
'brytertaket': ('brytertak',),
'bryting': ('bryting',),
'brytinga': ('bryting',),
'brytingen': ('bryting',),
'brytingene': ('bryting',),
'brytinger': ('bryting',),
'brytingstid': ('brytingstid',),
'brytingstida': ('brytingstid',),
'brytingstiden': ('brytingstid',),
'brytingstidene': ('brytingstid',),
'brytingstider': ('brytingstid',),
'brytingsår': ('brytingsår',),
'brytingsåra': ('brytingsår',),
'brytingsårene': ('brytingsår',),
'brytingsåret': ('brytingsår',),
'brytning': ('brytning',),
'brytninga': ('brytning',),
'brytningen': ('brytning',),
'brytningene': ('brytning',),
'brytninger': ('brytning',),
'brytningstid': ('brytningstid',),
'brytningstida': ('brytningstid',),
'brytningstiden': ('brytningstid',),
'brytningstidene': ('brytningstid',),
'brytningstider': ('brytningstid',),
'brytningsår': ('brytningsår',),
'brytningsåra': ('brytningsår',),
'brytningsårene': ('brytningsår',),
'brytningsåret': ('brytningsår',),
'brådjup': ('brådjup',),
'brådjupa': ('brådjup',),
'brådjupene': ('brådjup',),
'brådjupet': ('brådjup',),
'brådyp': ('brådyp',),
'brådypa': ('brådyp',),
'brådypene': ('brådyp',),
'brådypet': ('brådyp',),
'bråhast': ('bråhast',),
'bråhasten': ('bråhast',),
'bråhastene': ('bråhast',),
'bråhaster': ('bråhast',),
'bråk': ('bråk',),
'bråka': ('bråk',),
'bråkene': ('bråk',),
'bråket': ('bråk',),
'bråk': ('bråk',),
'bråka': ('bråk',),
'bråken': ('bråk',),
'brækene': ('bråk',),
'bræker': ('bråk',),
'bråkast': ('bråkast',),
'bråkasta': ('bråkast',),
'bråkastene': ('bråkast',),
'bråkastet': ('bråkast',),
'bråkebøtta': ('bråkebøtte',),
'bråkebøtte': ('bråkebøtte',),
'bråkebøtten': ('bråkebøtte',),
'bråkebøttene': ('bråkebøtte',),
'bråkebøtter': ('bråkebøtte',),
'bråkmaker': ('bråkmaker',),
'bråkmakere': ('bråkmaker',),
'bråkmakeren': ('bråkmaker',),
'bråkmakerer': ('bråkmaker',),
'bråkmakerne': ('bråkmaker',),
'bråkulda': ('bråkulde',),
'bråkulde': ('bråkulde',),
'bråkulden': ('bråkulde',),
'bråkuldene': ('bråkulde',),
'bråkulder': ('bråkulde',),
'bråsinna': ('bråsinne',),
'bråsinne': ('bråsinne',),
'bråsinnene': ('bråsinne',),
'bråsinner': ('bråsinne',),
'bråsinnet': ('bråsinne',),
'bråte': ('bråte',),
'bråten': ('bråte',),
'bråtene': ('bråte',),
'bråter': ('bråte',),
'bråtebrann': ('bråtebrann',),
'bråtebrannen': ('bråtebrann',),
'bråtebrannene': ('bråtebrann',),
'bråtebranner': ('bråtebrann',),
'bråtebrenning': ('bråtebrenning',),
'bråtebrenninga': ('bråtebrenning',),
'bråtebrenningen': ('bråtebrenning',),
'bråtebrenningene': ('bråtebrenning',),
'bråtebrenninger': ('bråtebrenning',),
'bråterøyk': ('bråterøyk',),
'bråterøyken': ('bråterøyk',),
'bråterøykene': ('bråterøyk',),
'bråterøyker': ('bråterøyk',),
'brød': ('brød',),
'brøda': ('brød',),
'brødene': ('brød',),
'brødet': ('brød',),
'brødbaking': ('brødbaking',),
'brødbakinga': ('brødbaking',),
'brødbakingen': ('brødbaking',),
'brødbakingene': ('brødbaking',),
'brødbakinger': ('brødbaking',),
'brødbakning': ('brødbakning',),
'brødbakninga': ('brødbakning',),
'brødbakningen': ('brødbakning',),
'brødbakningene': ('brødbakning',),
'brødbakninger': ('brødbakning',),
'brødbille': ('brødbille',),
'brødbillen': ('brødbille',),
'brødbillene': ('brødbille',),
'brødbiller': ('brødbille',),
'brødbit': ('brødbit',),
'brødbiten': ('brødbit',),
'brødbitene': ('brødbit',),
'brødbiter': ('brødbit',),
'brødblings': ('brødblings',),
'brødblingsen': ('brødblings',),
'brødblingsene': ('brødblings',),
'brødblingser': ('brødblings',),
'brøddeig': ('brøddeig',),
'brøddeigen': ('brøddeig',),
'brøddeigene': ('brøddeig',),
'brøddeiger': ('brøddeig',),
'brøde': ('brøde',),
'brøden': ('brøde',),
'brødene': ('brøde',),
'brøder': ('brøde',),
'brødfrukt': ('brødfrukt',),
'brødfrukta': ('brødfrukt',),
'brødfrukten': ('brødfrukt',),
'brødfruktene': ('brødfrukt',),
'brødfrukter': ('brødfrukt',),
'brødfrukttre': ('brødfrukttre',),
'brødfrukttrea': ('brødfrukttre',),
'brødfrukttreet': ('brødfrukttre',),
'brødfrukttrær': ('brødfrukttre',),
'brødfrukttrærne': ('brødfrukttre',),
'brødnid': ('brødnid',),
'brødnida': ('brødnid',),
'brødnidene': ('brødnid',),
'brødnidet': ('brødnid',),
'brødremenighet': ('brødremenighet',),
'brødremenigheta': ('brødremenighet',),
'brødremenigheten': ('brødremenighet',),
'brødremenighetene': ('brødremenighet',),
'brødremenigheter': ('brødremenighet',),
'brødrister': ('brødrister',),
'brødristere': ('brødrister',),
'brødristeren': ('brødrister',),
'brødristerer': ('brødrister',),
'brødristerne': ('brødrister',),
'brødskrift': ('brødskrift',),
'brødskrifta': ('brødskrift',),
'brødskriften': ('brødskrift',),
'brødskriftene': ('brødskrift',),
'brødskrifter': ('brødskrift',),
'brøk': ('brøk',),
'brøken': ('brøk',),
'brøkene': ('brøk',),
'brøker': ('brøk',),
'brøkdel': ('brøkdel',),
'brøkdelen': ('brøkdel',),
'brøkdelene': ('brøkdel',),
'brøkdeler': ('brøkdel',),
'brøkregning': ('brøkregning',),
'brøkregninga': ('brøkregning',),
'brøkregningen': ('brøkregning',),
'brøkregningene': ('brøkregning',),
'brøkregninger': ('brøkregning',),
'brøkrekning': ('brøkrekning',),
'brøkrekninga': ('brøkrekning',),
'brøkrekningen': ('brøkrekning',),
'brøkrekningene': ('brøkrekning',),
'brøkrekninger': ('brøkrekning',),
'brøkstrek': ('brøkstrek',),
'brøkstreken': ('brøkstrek',),
'brøkstrekene': ('brøkstrek',),
'brøkstreker': ('brøkstrek',),
'brøl': ('brøl',),
'brøla': ('brøl',),
'brølene': ('brøl',),
'brølet': ('brøl',),
'brølapa': ('brølape',),
'brølape': ('brølape',),
'brølapen': ('brølape',),
'brølapene': ('brølape',),
'brølaper': ('brølape',),
'brøleapa': ('brøleape',),
'brøleape': ('brøleape',),
'brøleapen': ('brøleape',),
'brøleapene': ('brøleape',),
'brøleaper': ('brøleape',),
'brøler': ('brøler',),
'brølere': ('brøler',),
'brøleren': ('brøler',),
'brølerer': ('brøler',),
'brølerne': ('brøler',),
'brønn': ('brønn',),
'brønnen': ('brønn',),
'brønnene': ('brønn',),
'brønner': ('brønn',),
'brønnbor': ('brønnbor',),
'brønnbora': ('brønnbor',),
'brønnboren': ('brønnbor',),
'brønnborene': ('brønnbor',),
'brønnboret': ('brønnbor',),
'brønnboring': ('brønnboring',),
'brønnboringa': ('brønnboring',),
'brønnboringen': ('brønnboring',),
'brønnboringene': ('brønnboring',),
'brønnboringer': ('brønnboring',),
'brønnbåt': ('brønnbåt',),
'brønnbåten': ('brønnbåt',),
'brønnbåtene': ('brønnbåt',),
'brønnbåter': ('brønnbåt',),
'brønnhoda': ('brønnhode',),
'brønnhode': ('brønnhode',),
'brønnhodene': ('brønnhode',),
'brønnhoder': ('brønnhode',),
'brønnhodet': ('brønnhode',),
'brønnhus': ('brønnhus',),
'brønnhusa': ('brønnhus',),
'brønnhusene': ('brønnhus',),
'brønnhuset': ('brønnhus',),
'brønnkapasitet': ('brønnkapasitet',),
'brønnkapasiteten': ('brønnkapasitet',),
'brønnkapasitetene': ('brønnkapasitet',),
'brønnkapasiteter': ('brønnkapasitet',),
'brønnpisser': ('brønnpisser',),
'brønnpissere': ('brønnpisser',),
'brønnpisseren': ('brønnpisser',),
'brønnpisserer': ('brønnpisser',),
'brønnpisserne': ('brønnpisser',),
'brøst': ('brøst',),
'brøsta': ('brøst',),
'brøsten': ('brøst',),
'brøstene': ('brøst',),
'brøstet': ('brøst',),
'brøyt': ('brøyt',),
'brøyten': ('brøyt',),
'brøytene': ('brøyt',),
'brøyter': ('brøyt',),
'brøytebil': ('brøytebil',),
'brøytebilen': ('brøytebil',),
'brøytebilene': ('brøytebil',),
'brøytebiler': ('brøytebil',),
'brøytekant': ('brøytekant',),
'brøytekanten': ('brøytekant',),
'brøytekantene': ('brøytekant',),
'brøytekanter': ('brøytekant',),
'bu': ('bu',),
'bua': ('bu',),
'buene': ('bu',),
'buet': ('bu',),
'bu': ('bu',),
'bua': ('bu',),
'buen': ('bu',),
'buene': ('bu',),
'buer': ('bu',),
'bu': ('bu',),
'bua': ('bu',),
'buen': ('bu',),
'buene': ('bu',),
'buer': ('bu',),
'bubestyrer': ('bubestyrer',),
'bubestyrere': ('bubestyrer',),
'bubestyreren': ('bubestyrer',),
'bubestyrerer': ('bubestyrer',),
'bubestyrerne': ('bubestyrer',),
'bud': ('bud',),
'buda': ('bud',),
'budene': ('bud',),
'budet': ('bud',),
'budbringer': ('budbringer',),
'budbringere': ('budbringer',),
'budbringeren': ('budbringer',),
'budbringerer': ('budbringer',),
'budbringerne': ('budbringer',),
'budbærer': ('budbærer',),
'budbærere': ('budbærer',),
'budbæreren': ('budbærer',),
'budbærerer': ('budbærer',),
'budbærerne': ('budbærer',),
'buddha': ('buddha',),
'buddhaen': ('buddha',),
'buddhaene': ('buddha',),
'buddhaer': ('buddha',),
'buddhafigur': ('buddhafigur',),
'buddhafiguren': ('buddhafigur',),
'buddhafigurene': ('buddhafigur',),
'buddhafigurer': ('buddhafigur',),
'buddhatempel': ('buddhatempel',),
'buddhatempelet': ('buddhatempel',),
'buddhatempla': ('buddhatempel',),
'buddhatemplene': ('buddhatempel',),
'buddhatempler': ('buddhatempel',),
'buddhatemplet': ('buddhatempel',),
'buddhisme': ('buddhisme',),
'buddhismen': ('buddhisme',),
'buddhismene': ('buddhisme',),
'buddhismer': ('buddhisme',),
'buddhist': ('buddhist',),
'buddhisten': ('buddhist',),
'buddhistene': ('buddhist',),
'buddhister': ('buddhist',),
'buddhistmunk': ('buddhistmunk',),
'buddhistmunken': ('buddhistmunk',),
'buddhistmunkene': ('buddhistmunk',),
'buddhistmunker': ('buddhistmunk',),
'budeia': ('budeie',),
'budeie': ('budeie',),
'budeien': ('budeie',),
'budeiene': ('budeie',),
'budeier': ('budeie',),
'budoar': ('budoar',),
'budoara': ('budoar',),
'budoarene': ('budoar',),
'budoarer': ('budoar',),
'budoaret': ('budoar',),
'budrått': ('budrått',),
'budråtten': ('budrått',),
'budråttene': ('budrått',),
'budråtter': ('budrått',),
'budsjett': ('budsjett',),
'budsjetta': ('budsjett',),
'budsjettene': ('budsjett',),
'budsjetter': ('budsjett',),
'budsjettet': ('budsjett',),
'budsjett-termin': ('budsjett-termin',),
'budsjett-terminen': ('budsjett-termin',),
'budsjett-terminene': ('budsjett-termin',),
'budsjett-terminer': ('budsjett-termin',),
'budsjettbehandling': ('budsjettbehandling',),
'budsjettbehandlinga': ('budsjettbehandling',),
'budsjettbehandlingen': ('budsjettbehandling',),
'budsjettbehandlingene': ('budsjettbehandling',),
'budsjettbehandlinger': ('budsjettbehandling',),
'budsjettermin': ('budsjettermin',),
'budsjetterminen': ('budsjettermin',),
'budsjetterminene': ('budsjettermin',),
'budsjetterminer': ('budsjettermin',),
'budsjettforslag': ('budsjettforslag',),
'budsjettforslaga': ('budsjettforslag',),
'budsjettforslagene': ('budsjettforslag',),
'budsjettforslaget': ('budsjettforslag',),
'budskap': ('budskap',),
'budskapa': ('budskap',),
'budskapene': ('budskap',),
'budskaper': ('budskap',),
'budskapet': ('budskap',),
'budskapsdag': ('budskapsdag',),
'budskapsdagen': ('budskapsdag',),
'budskapsdagene': ('budskapsdag',),
'budskapsdager': ('budskapsdag',),
'budstikka': ('budstikke',),
'budstikke': ('budstikke',),
'budstikken': ('budstikke',),
'budstikkene': ('budstikke',),
'budstikker': ('budstikke',),
'bue': ('bue',),
'buen': ('bue',),
'buene': ('bue',),
'buer': ('bue',),
'buebro': ('buebro',),
'buebroa': ('buebro',),
'buebroen': ('buebro',),
'buebroene': ('buebro',),
'buebroer': ('buebro',),
'buebru': ('buebru',),
'buebrua': ('buebru',),
'buebruen': ('buebru',),
'buebruene': ('buebru',),
'buebruer': ('buebru',),
'buegang': ('buegang',),
'buegangen': ('buegang',),
'buegangene': ('buegang',),
'bueganger': ('buegang',),
'buegrad': ('buegrad',),
'buegraden': ('buegrad',),
'buegradene': ('buegrad',),
'buegrader': ('buegrad',),
'buekorps': ('buekorps',),
'buekorpsa': ('buekorps',),
'buekorpsene': ('buekorps',),
'buekorpset': ('buekorps',),
'bueminutt': ('bueminutt',),
'bueminutta': ('bueminutt',),
'bueminuttene': ('bueminutt',),
'bueminutter': ('bueminutt',),
'bueminuttet': ('bueminutt',),
'bueparentes': ('bueparentes',),
'bueparentesen': ('bueparentes',),
'bueparentesene': ('bueparentes',),
'bueparenteser': ('bueparentes',),
'buesag': ('buesag',),
'buesaga': ('buesag',),
'buesagen': ('buesag',),
'buesagene': ('buesag',),
'buesager': ('buesag',),
'buesekund': ('buesekund',),
'buesekunda': ('buesekund',),
'buesekundene': ('buesekund',),
'buesekunder': ('buesekund',),
'buesekundet': ('buesekund',),
'buestreng': ('buestreng',),
'buestrengen': ('buestreng',),
'buestrengene': ('buestreng',),
'buestrenger': ('buestreng',),
'buetak': ('buetak',),
'buetaka': ('buetak',),
'buetakene': ('buetak',),
'buetaket': ('buetak',),
'buevindu': ('buevindu',),
'buevindua': ('buevindu',),
'buevinduene': ('buevindu',),
'buevinduer': ('buevindu',),
'buevinduet': ('buevindu',),
'bufar': ('bufar',),
'bufaren': ('bufar',),
'bufarene': ('bufar',),
'bufarer': ('bufar',),
'bufardag': ('bufardag',),
'bufardagen': ('bufardag',),
'bufardagene': ('bufardag',),
'bufardager': ('bufardag',),
'bufe': ('bufe',),
'bufea': ('bufe',),
'bufeene': ('bufe',),
'bufeet': ('bufe',),
'bufellesskap': ('bufellesskap',),
'bufellesskapa': ('bufellesskap',),
'bufellesskapene': ('bufellesskap',),
'bufellesskaper': ('bufellesskap',),
'bufellesskapet': ('bufellesskap',),
'buffeen': ('buffé',),
'buffeene': ('buffé',),
'buffeer': ('buffé',),
'buffé': ('buffé',),
'bufféen': ('buffé',),
'bufféene': ('buffé',),
'bufféer': ('buffé',),
'buffer': ('buffer',),
'buffere': ('buffer',),
'bufferen': ('buffer',),
'bufferer': ('buffer',),
'bufferne': ('buffer',),
'buffersona': ('buffersone',),
'buffersone': ('buffersone',),
'buffersonen': ('buffersone',),
'buffersonene': ('buffersone',),
'buffersoner': ('buffersone',),
'bufferstat': ('bufferstat',),
'bufferstaten': ('bufferstat',),
'bufferstatene': ('bufferstat',),
'bufferstater': ('bufferstat',),
'buffo': ('buffo',),
'buffoen': ('buffo',),
'buffoene': ('buffo',),
'buffoer': ('buffo',),
'buffoopera': ('buffoopera',),
'buffooperaen': ('buffoopera',),
'buffooperaene': ('buffoopera',),
'buffooperaer': ('buffoopera',),
'buflata': ('buflate',),
'buflate': ('buflate',),
'buflaten': ('buflate',),
'buflatene': ('buflate',),
'buflater': ('buflate',),
'buform': ('buform',),
'buforma': ('buform',),
'buformen': ('buform',),
'buformene': ('buform',),
'buformer': ('buform',),
'buhund': ('buhund',),
'buhunden': ('buhund',),
'buhundene': ('buhund',),
'buhunder': ('buhund',),
'buk': ('buk',),
'buken': ('buk',),
'bukene': ('buk',),
'buker': ('buk',),
'bukeen': ('buké',),
'bukeene': ('buké',),
'bukeer': ('buké',),
'buké': ('buké',),
'bukéen': ('buké',),
'bukéene': ('buké',),
'bukéer': ('buké',),
'bukett': ('bukett',),
'buketten': ('bukett',),
'bukettene': ('bukett',),
'buketter': ('bukett',),
'bukgjord': ('bukgjord',),
'bukgjorda': ('bukgjord',),
'bukgjorden': ('bukgjord',),
'bukgjordene': ('bukgjord',),
'bukgjorder': ('bukgjord',),
'bukhinna': ('bukhinne',),
'bukhinne': ('bukhinne',),
'bukhinnen': ('bukhinne',),
'bukhinnene': ('bukhinne',),
'bukhinner': ('bukhinne',),
'bukhinnebetennelse': ('bukhinnebetennelse',),
'bukhinnebetennelsen': ('bukhinnebetennelse',),
'bukhinnebetennelsene': ('bukhinnebetennelse',),
'bukhinnebetennelser': ('bukhinnebetennelse',),
'bukhola': ('bukhole',),
'bukhole': ('bukhole',),
'bukholen': ('bukhole',),
'bukholene': ('bukhole',),
'bukholer': ('bukhole',),
'bukhula': ('bukhule',),
'bukhule': ('bukhule',),
'bukhulen': ('bukhule',),
'bukhulene': ('bukhule',),
'bukhuler': ('bukhule',),
'bukk': ('bukk',),
'bukken': ('bukk',),
'bukkene': ('bukk',),
'bukker': ('bukk',),
'bukk': ('bukk',),
'bukka': ('bukk',),
'bukkene': ('bukk',),
'bukket': ('bukk',),
'bukkebein': ('bukkebein',),
'bukkebeina': ('bukkebein',),
'bukkebeinene': ('bukkebein',),
'bukkebeinet': ('bukkebein',),
'bukkeben': ('bukkeben',),
'bukkebena': ('bukkeben',),
'bukkebenene': ('bukkeben',),
'bukkebenet': ('bukkeben',),
'bukkeblad': ('bukkeblad',),
'bukkeblada': ('bukkeblad',),
'bukkebladene': ('bukkeblad',),
'bukkeblader': ('bukkeblad',),
'bukkebladet': ('bukkeblad',),
'bukkehorn': ('bukkehorn',),
'bukkehorna': ('bukkehorn',),
'bukkehornene': ('bukkehorn',),
'bukkehornet': ('bukkehorn',),
'bukkel': ('bukkel',),
'bukkelen': ('bukkel',),
'buklene': ('bukkel',),
'bukler': ('bukkel',),
'bukkeskjegg': ('bukkeskjegg',),
'bukkeskjegga': ('bukkeskjegg',),
'bukkeskjeggene': ('bukkeskjegg',),
'bukkeskjegget': ('bukkeskjegg',),
'buklist': ('buklist',),
'buklista': ('buklist',),
'buklisten': ('buklist',),
'buklistene': ('buklist',),
'buklister': ('buklist',),
'bukollektiv': ('bukollektiv',),
'bukollektiva': ('bukollektiv',),
'bukollektivene': ('bukollektiv',),
'bukollektiver': ('bukollektiv',),
'bukollektivet': ('bukollektiv',),
'bukreditt': ('bukreditt',),
'bukreditten': ('bukreditt',),
'bukredittene': ('bukreditt',),
'bukreditter': ('bukreditt',),
'buksbom': ('buksbom',),
'buksbommen': ('buksbom',),
'buksbommene': ('buksbom',),
'buksbommer': ('buksbom',),
'buksbomhekk': ('buksbomhekk',),
'buksbomhekken': ('buksbomhekk',),
'buksbomhekkene': ('buksbomhekk',),
'buksbomhekker': ('buksbomhekk',),
'buksa': ('bukse',),
'bukse': ('bukse',),
'buksen': ('bukse',),
'buksene': ('bukse',),
'bukser': ('bukse',),
'buksebak': ('buksebak',),
'buksebaken': ('buksebak',),
'buksebakene': ('buksebak',),
'buksebaker': ('buksebak',),
'buksebein': ('buksebein',),
'buksebeina': ('buksebein',),
'buksebeinene': ('buksebein',),
'buksebeinet': ('buksebein',),
'bukseben': ('bukseben',),
'buksebena': ('bukseben',),
'buksebenene': ('bukseben',),
'buksebenet': ('bukseben',),
'buksedrakt': ('buksedrakt',),
'buksedrakta': ('buksedrakt',),
'buksedrakten': ('buksedrakt',),
'buksedraktene': ('buksedrakt',),
'buksedrakter': ('buksedrakt',),
'buksedress': ('buksedress',),
'buksedressen': ('buksedress',),
'buksedressene': ('buksedress',),
'buksedresser': ('buksedress',),
'bukselomma': ('bukselomme',),
'bukselomme': ('bukselomme',),
'bukselommen': ('bukselomme',),
'bukselommene': ('bukselomme',),
'bukselommer': ('bukselomme',),
'bukserbåt': ('bukserbåt',),
'bukserbåten': ('bukserbåt',),
'bukserbåtene': ('bukserbåt',),
'bukserbåter': ('bukserbåt',),
'buksesele': ('buksesele',),
'bukseselen': ('buksesele',),
'bukseselene': ('buksesele',),
'bukseseler': ('buksesele',),
'bukseskjørt': ('bukseskjørt',),
'bukseskjørta': ('bukseskjørt',),
'bukseskjørtene': ('bukseskjørt',),
'bukseskjørter': ('bukseskjørt',),
'bukseskjørtet': ('bukseskjørt',),
'buksesmekk': ('buksesmekk',),
'buksesmekken': ('buksesmekk',),
'buksesmekkene': ('buksesmekk',),
'buksesmekker': ('buksesmekk',),
'bukspytt': ('bukspytt',),
'bukspytta': ('bukspytt',),
'bukspyttene': ('bukspytt',),
'bukspyttet': ('bukspytt',),
'bukspyttkjertel': ('bukspyttkjertel',),
'bukspyttkjertelen': ('bukspyttkjertel',),
'bukspyttkjertlene': ('bukspyttkjertel',),
'bukspyttkjertler': ('bukspyttkjertel',),
'bukt': ('bukt',),
'bukta': ('bukt',),
'bukten': ('bukt',),
'buktene': ('bukt',),
'bukter': ('bukt',),
'buktaler': ('buktaler',),
'buktalere': ('buktaler',),
'buktaleren': ('buktaler',),
'buktalerer': ('buktaler',),
'buktalerne': ('buktaler',),
'buktning': ('buktning',),
'buktninga': ('buktning',),
'buktningen': ('buktning',),
'buktningene': ('buktning',),
'buktninger': ('buktning',),
'bukvirvel': ('bukvirvel',),
'bukvirvelen': ('bukvirvel',),
'bukvirvlene': ('bukvirvel',),
'bukvirvler': ('bukvirvel',),
'bulb': ('bulb',),
'bulben': ('bulb',),
'bulbene': ('bulb',),
'bulber': ('bulb',),
'bulder': ('bulder',),
'bulderet': ('bulder',),
'buldra': ('bulder',),
'buldre': ('bulder',),
'buldrene': ('bulder',),
'buldrer': ('bulder',),
'buldret': ('bulder',),
'buldrebasse': ('buldrebasse',),
'buldrebassen': ('buldrebasse',),
'buldrebassene': ('buldrebasse',),
'buldrebasser': ('buldrebasse',),
'bule': ('bule',),
'bulen': ('bule',),
'bulene': ('bule',),
'buler': ('bule',),
'bula': ('bule',),
'bule': ('bule',),
'bulen': ('bule',),
'bulene': ('bule',),
'buler': ('bule',),
'bulevard': ('bulevard',),
'bulevarden': ('bulevard',),
'bulevardene': ('bulevard',),
'bulevarder': ('bulevard',),
'bulevardavis': ('bulevardavis',),
'bulevardavisa': ('bulevardavis',),
'bulevardavisen': ('bulevardavis',),
'bulevardavisene': ('bulevardavis',),
'bulevardaviser': ('bulevardavis',),
'bulgarer': ('bulgarer',),
'bulgarere': ('bulgarer',),
'bulgareren': ('bulgarer',),
'bulgarerer': ('bulgarer',),
'bulgarerne': ('bulgarer',),
'bulgarsk': ('bulgarsk',),
'bulgarsken': ('bulgarsk',),
'bulgarskene': ('bulgarsk',),
'bulgarsker': ('bulgarsk',),
'bulimi': ('bulimi',),
'bulimien': ('bulimi',),
'bulimiene': ('bulimi',),
'bulimier': ('bulimi',),
'bulimiker': ('bulimiker',),
'bulimikere': ('bulimiker',),
'bulimikeren': ('bulimiker',),
'bulimikerer': ('bulimiker',),
'bulimikerne': ('bulimiker',),
'buljong': ('buljong',),
'buljongen': ('buljong',),
'buljongene': ('buljong',),
'buljonger': ('buljong',),
'buljongpar': ('buljongpar',),
'buljongpara': ('buljongpar',),
'buljongparene': ('buljongpar',),
'buljongparet': ('buljongpar',),
'buljongterning': ('buljongterning',),
'buljongterningen': ('buljongterning',),
'buljongterningene': ('buljongterning',),
'buljongterninger': ('buljongterning',),
'bulkbil': ('bulkbil',),
'bulkbilen': ('bulkbil',),
'bulkbilene': ('bulkbil',),
'bulkbiler': ('bulkbil',),
'bulkcarrier': ('bulkcarrier',),
'bulkcarriere': ('bulkcarrier',),
'bulkcarrieren': ('bulkcarrier',),
'bulkcarrierer': ('bulkcarrier',),
'bulkcarrierne': ('bulkcarrier',),
'bulklast': ('bulklast',),
'bulklasta': ('bulklast',),
'bulklasten': ('bulklast',),
'bulklastene': ('bulklast',),
'bulklaster': ('bulklast',),
'bulkskip': ('bulkskip',),
'bulkskipa': ('bulkskip',),
'bulkskipene': ('bulkskip',),
'bulkskipet': ('bulkskip',),
'bulldogg': ('bulldogg',),
'bulldoggen': ('bulldogg',),
'bulldoggene': ('bulldogg',),
'bulldogger': ('bulldogg',),
'bulldoggansikt': ('bulldoggansikt',),
'bulldoggansikta': ('bulldoggansikt',),
'bulldoggansiktene': ('bulldoggansikt',),
'bulldoggansikter': ('bulldoggansikt',),
'bulldoggansiktet': ('bulldoggansikt',),
'bulldoser': ('bulldoser',),
'bulldosere': ('bulldoser',),
'bulldoseren': ('bulldoser',),
'bulldoserer': ('bulldoser',),
'bulldoserne': ('bulldoser',),
'bulle': ('bulle',),
'bullen': ('bulle',),
'bullene': ('bulle',),
'buller': ('bulle',),
'bulletin': ('bulletin',),
'bulletinen': ('bulletin',),
'bulletinene': ('bulletin',),
'bulletiner': ('bulletin',),
'bulmeurt': ('bulmeurt',),
'bulmeurta': ('bulmeurt',),
'bulmeurten': ('bulmeurt',),
'bulmeurtene': ('bulmeurt',),
'bulmeurter': ('bulmeurt',),
'bulter': ('bulter',),
'bumaskin': ('bumaskin',),
'bumaskina': ('bumaskin',),
'bumaskinen': ('bumaskin',),
'bumaskinene': ('bumaskin',),
'bumaskiner': ('bumaskin',),
'bumerang': ('bumerang',),
'bumerangen': ('bumerang',),
'bumerangene': ('bumerang',),
'bumeranger': ('bumerang',),
'bumerka': ('bumerke',),
'bumerke': ('bumerke',),
'bumerkene': ('bumerke',),
'bumerker': ('bumerke',),
'bumerket': ('bumerke',),
'bumsa': ('bumse',),
'bumse': ('bumse',),
'bumsen': ('bumse',),
'bumsene': ('bumse',),
'bumser': ('bumse',),
'bunad': ('bunad',),
'bunaden': ('bunad',),
'bunadene': ('bunad',),
'bunader': ('bunad',),
'bunadskjorta': ('bunadskjorte',),
'bunadskjorte': ('bunadskjorte',),
'bunadskjorten': ('bunadskjorte',),
'bunadskjortene': ('bunadskjorte',),
'bunadskjorter': ('bunadskjorte',),
'bunadsko': ('bunadsko',),
'bunadskoen': ('bunadsko',),
'bunadskoene': ('bunadsko',),
'bunadskor': ('bunadsko',),
'bunadskorne': ('bunadsko',),
'bunadsskjorta': ('bunadsskjorte',),
'bunadsskjorte': ('bunadsskjorte',),
'bunadsskjorten': ('bunadsskjorte',),
'bunadsskjortene': ('bunadsskjorte',),
'bunadsskjorter': ('bunadsskjorte',),
'bunadssko': ('bunadssko',),
'bunadsskoa': ('bunadssko',),
'bunadsskoen': ('bunadssko',),
'bunadsskoene': ('bunadssko',),
'bunadsskor': ('bunadssko',),
'bunadsskorne': ('bunadssko',),
'bunadssølv': ('bunadssølv',),
'bunadssølva': ('bunadssølv',),
'bunadssølvene': ('bunadssølv',),
'bunadssølvet': ('bunadssølv',),
'bunadsølv': ('bunadsølv',),
'bunadsølva': ('bunadsølv',),
'bunadsølvene': ('bunadsølv',),
'bunadsølvet': ('bunadsølv',),
'bunding': ('bunding',),
'bundingen': ('bunding',),
'bundingene': ('bunding',),
'bundinger': ('bunding',),
'bundsforvant': ('bundsforvant',),
'bundsforvante': ('bundsforvant',),
'bundsforvanten': ('bundsforvant',),
'bundsforvantene': ('bundsforvant',),
'bungalow': ('bungalow',),
'bungalowen': ('bungalow',),
'bungalowene': ('bungalow',),
'bungalower': ('bungalow',),
'bunke': ('bunke',),
'bunken': ('bunke',),
'bunkene': ('bunke',),
'bunker': ('bunke',),
'bunke': ('bunke',),
'bunken': ('bunke',),
'bunkene': ('bunke',),
'bunker': ('bunke',),
'bunke': ('bunke',),
'bunken': ('bunke',),
'bunkene': ('bunke',),
'bunker': ('bunke',),
'bunker': ('bunker',),
'bunkere': ('bunker',),
'bunkeren': ('bunker',),
'bunkerer': ('bunker',),
'bunkerne': ('bunker',),
'bunkers': ('bunkers',),
'bunkersen': ('bunkers',),
'bunkersene': ('bunkers',),
'bunn': ('bunn',),
'bunnen': ('bunn',),
'bunnene': ('bunn',),
'bunner': ('bunn',),
'bunn-nivå': ('bunn-nivå',),
'bunn-nivåa': ('bunn-nivå',),
'bunn-nivåene': ('bunn-nivå',),
'bunn-nivåer': ('bunn-nivå',),
'bunn-nivået': ('bunn-nivå',),
'bunnband': ('bunnband',),
'bunnbanda': ('bunnband',),
'bunnbandene': ('bunnband',),
'bunnbandet': ('bunnband',),
'bunnbord': ('bunnbord',),
'bunnborda': ('bunnbord',),
'bunnbordene': ('bunnbord',),
'bunnborder': ('bunnbord',),
'bunnbordet': ('bunnbord',),
'bunnbånd': ('bunnbånd',),
'bunnbånda': ('bunnbånd',),
'bunnbåndene': ('bunnbånd',),
'bunnbåndet': ('bunnbånd',),
'bunnfall': ('bunnfall',),
'bunnfalla': ('bunnfall',),
'bunnfallene': ('bunnfall',),
'bunnfallet': ('bunnfall',),
'bunnfisk': ('bunnfisk',),
'bunnfisken': ('bunnfisk',),
'bunnfiskene': ('bunnfisk',),
'bunnfisker': ('bunnfisk',),
'bunnflata': ('bunnflate',),
'bunnflate': ('bunnflate',),
'bunnflaten': ('bunnflate',),
'bunnflatene': ('bunnflate',),
'bunnflater': ('bunnflate',),
'bunnivå': ('bunnivå',),
'bunnivåa': ('bunnivå',),
'bunnivåene': ('bunnivå',),
'bunnivåer': ('bunnivå',),
'bunnivået': ('bunnivå',),
'bunnlag': ('bunnlag',),
'bunnlaga': ('bunnlag',),
'bunnlagene': ('bunnlag',),
'bunnlaget': ('bunnlag',),
'bunnløshet': ('bunnløshet',),
'bunnløsheta': ('bunnløshet',),
'bunnløsheten': ('bunnløshet',),
'bunnløshetene': ('bunnløshet',),
'bunnløsheter': ('bunnløshet',),
'bunnløysa': ('bunnløyse',),
'bunnløyse': ('bunnløyse',),
'bunnløysen': ('bunnløyse',),
'bunnløysene': ('bunnløyse',),
'bunnløyser': ('bunnløyse',),
'bunnmorene': ('bunnmorene',),
'bunnmorenen': ('bunnmorene',),
'bunnmorenene': ('bunnmorene',),
'bunnmorener': ('bunnmorene',),
'bunnpanna': ('bunnpanne',),
'bunnpanne': ('bunnpanne',),
'bunnpannen': ('bunnpanne',),
'bunnpannene': ('bunnpanne',),
'bunnpanner': ('bunnpanne',),
'bunnrekord': ('bunnrekord',),
'bunnrekorden': ('bunnrekord',),
'bunnrekordene': ('bunnrekord',),
'bunnrekorder': ('bunnrekord',),
'bunnstoff': ('bunnstoff',),
'bunnstoffa': ('bunnstoff',),
'bunnstoffene': ('bunnstoff',),
'bunnstoffer': ('bunnstoff',),
'bunnstoffet': ('bunnstoff',),
'bunnstrid': ('bunnstrid',),
'bunnstriden': ('bunnstrid',),
'bunnstridene': ('bunnstrid',),
'bunnstrider': ('bunnstrid',),
'bunsenbrenner': ('bunsenbrenner',),
'bunsenbrennere': ('bunsenbrenner',),
'bunsenbrenneren': ('bunsenbrenner',),
'bunsenbrennerer': ('bunsenbrenner',),
'bunsenbrennerne': ('bunsenbrenner',),
'bunt': ('bunt',),
'bunten': ('bunt',),
'buntene': ('bunt',),
'bunter': ('bunt',),
'buntmaker': ('buntmaker',),
'buntmakere': ('buntmaker',),
'buntmakeren': ('buntmaker',),
'buntmakerer': ('buntmaker',),
'buntmakerne': ('buntmaker',),
'buorm': ('buorm',),
'buormen': ('buorm',),
'buormene': ('buorm',),
'buormer': ('buorm',),
'buplikt': ('buplikt',),
'buplikta': ('buplikt',),
'buplikten': ('buplikt',),
'bupliktene': ('buplikt',),
'buplikter': ('buplikt',),
'bur': ('bur',),
'bura': ('bur',),
'burene': ('bur',),
'buret': ('bur',),
'bureiser': ('bureiser',),
'bureisere': ('bureiser',),
'bureiseren': ('bureiser',),
'bureiserer': ('bureiser',),
'bureiserne': ('bureiser',),
'bureising': ('bureising',),
'bureisinga': ('bureising',),
'bureisingen': ('bureising',),
'bureisingene': ('bureising',),
'bureisinger': ('bureising',),
'burettslag': ('burettslag',),
'burettslaga': ('burettslag',),
'burettslagene': ('burettslag',),
'burettslaget': ('burettslag',),
'burfugl': ('burfugl',),
'burfuglen': ('burfugl',),
'burfuglene': ('burfugl',),
'burfugler': ('burfugl',),
'burger': ('burger',),
'burgere': ('burger',),
'burgeren': ('burger',),
'burgerer': ('burger',),
'burgerne': ('burger',),
'burgunder': ('burgunder',),
'burgundere': ('burgunder',),
'burgunderen': ('burgunder',),
'burgunderer': ('burgunder',),
'burgunderne': ('burgunder',),
'burgundervin': ('burgundervin',),
'burgundervinen': ('burgundervin',),
'burgundervinene': ('burgundervin',),
'burgunderviner': ('burgundervin',),
'burhøna': ('burhøne',),
'burhøne': ('burhøne',),
'burhønen': ('burhøne',),
'burhønene': ('burhøne',),
'burhøner': ('burhøne',),
'burjat': ('burjat',),
'burjaten': ('burjat',),
'burjatene': ('burjat',),
'burjater': ('burjat',),
'burkiner': ('burkiner',),
'burkinere': ('burkiner',),
'burkineren': ('burkiner',),
'burkinerer': ('burkiner',),
'burkinerne': ('burkiner',),
'burkne': ('burkne',),
'burknen': ('burkne',),
'burknene': ('burkne',),
'burkner': ('burkne',),
'burloft': ('burloft',),
'burlofta': ('burloft',),
'burloftene': ('burloft',),
'burloftet': ('burloft',),
'burmaner': ('burmaner',),
'burmanere': ('burmaner',),
'burmaneren': ('burmaner',),
'burmanerer': ('burmaner',),
'burmanerne': ('burmaner',),
'burnus': ('burnus',),
'burnusen': ('burnus',),
'burnusene': ('burnus',),
'burnuser': ('burnus',),
'burot': ('burot',),
'burota': ('burot',),
'buroten': ('burot',),
'burotene': ('burot',),
'bursdag': ('bursdag',),
'bursdagen': ('bursdag',),
'bursdagene': ('bursdag',),
'bursdager': ('bursdag',),
'bursjoa': ('bursjoa',),
'bursjoaen': ('bursjoa',),
'bursjoaene': ('bursjoa',),
'bursjoaer': ('bursjoa',),
'bursjoasi': ('bursjoasi',),
'bursjoasia': ('bursjoasi',),
'bursjoasiene': ('bursjoasi',),
'bursjoasier': ('bursjoasi',),
'bursjoasiet': ('bursjoasi',),
'burundier': ('burundier',),
'burundiere': ('burundier',),
'burundieren': ('burundier',),
'burundierer': ('burundier',),
'burundierne': ('burundier',),
'bus': ('bus',),
'busen': ('bus',),
'busene': ('bus',),
'buser': ('bus',),
'buse': ('buse',),
'busen': ('buse',),
'busene': ('buse',),
'buser': ('buse',),
'busemann': ('busemann',),
'busemannen': ('busemann',),
'busemenn': ('busemann',),
'busemennene': ('busemann',),
'busetning': ('busetning',),
'busetninga': ('busetning',),
'busetningen': ('busetning',),
'busetningene': ('busetning',),
'busetninger': ('busetning',),
'busetningskart': ('busetningskart',),
'busetningskarta': ('busetningskart',),
'busetningskartene': ('busetningskart',),
'busetningskarter': ('busetningskart',),
'busetningskartet': ('busetningskart',),
'busetningsmønster': ('busetningsmønster',),
'busetningsmønsteret': ('busetningsmønster',),
'busetningsmønstra': ('busetningsmønster',),
'busetningsmønstre': ('busetningsmønster',),
'busetningsmønstrene': ('busetningsmønster',),
'busetningsmønstret': ('busetningsmønster',),
'busettingskart': ('busettingskart',),
'busettingskarta': ('busettingskart',),
'busettingskartene': ('busettingskart',),
'busettingskarter': ('busettingskart',),
'busettingskartet': ('busettingskart',),
'busettingsmønster': ('busettingsmønster',),
'busettingsmønsteret': ('busettingsmønster',),
'busettingsmønstra': ('busettingsmønster',),
'busettingsmønstre': ('busettingsmønster',),
'busettingsmønstrene': ('busettingsmønster',),
'busettingsmønstret': ('busettingsmønster',),
'bush': ('bush',),
'bushen': ('bush',),
'bushene': ('bush',),
'busher': ('bush',),
'bushel': ('bushel',),
'bushelen': ('bushel',),
'bushelene': ('bushel',),
'bushels': ('bushel',),
'business': ('business',),
'businessen': ('business',),
'businessene': ('business',),
'businesser': ('business',),
'busk': ('busk',),
'busken': ('busk',),
'buskene': ('busk',),
'busker': ('busk',),
'buskagitasjon': ('buskagitasjon',),
'buskagitasjonen': ('buskagitasjon',),
'buskagitasjonene': ('buskagitasjon',),
'buskagitasjoner': ('buskagitasjon',),
'buskap': ('buskap',),
'buskapen': ('buskap',),
'buskapene': ('buskap',),
'buskaper': ('buskap',),
'buskas': ('buskas',),
'buskasa': ('buskas',),
'buskasene': ('buskas',),
'buskaser': ('buskas',),
'buskaset': ('buskas',),
'buska': ('buske',),
'buske': ('buske',),
'busken': ('buske',),
'buskene': ('buske',),
'busker': ('buske',),
'buskfuru': ('buskfuru',),
'buskfurua': ('buskfuru',),
'buskfuruen': ('buskfuru',),
'buskfuruene': ('buskfuru',),
'buskfuruer': ('buskfuru',),
'buskis': ('buskis',),
'buskisen': ('buskis',),
'buskisene': ('buskis',),
'buskiser': ('buskis',),
'buskmann': ('buskmann',),
'buskmannen': ('buskmann',),
'buskmenn': ('buskmann',),
'buskmennene': ('buskmann',),
'busknellik': ('busknellik',),
'busknelliken': ('busknellik',),
'busknellikene': ('busknellik',),
'busknelliker': ('busknellik',),
'buskskvett': ('buskskvett',),
'buskskvetten': ('buskskvett',),
'buskskvettene': ('buskskvett',),
'buskskvetter': ('buskskvett',),
'buskvekst': ('buskvekst',),
'buskveksten': ('buskvekst',),
'buskvekstene': ('buskvekst',),
'buskvekster': ('buskvekst',),
'buss': ('buss',),
'bussen': ('buss',),
'bussene': ('buss',),
'busser': ('buss',),
'buss': ('buss',),
'bussen': ('buss',),
'bussene': ('buss',),
'busser': ('buss',),
'buss-sjåfør': ('buss-sjåfør',),
'buss-sjåføren': ('buss-sjåfør',),
'buss-sjåførene': ('buss-sjåfør',),
'buss-sjåfører': ('buss-sjåfør',),
'buss-stopp': ('buss-stopp',),
'buss-stoppa': ('buss-stopp',),
'buss-stoppen': ('buss-stopp',),
'buss-stoppene': ('buss-stopp',),
'buss-stoppet': ('buss-stopp',),
'busse': ('busse',),
'bussen': ('busse',),
'bussene': ('busse',),
'busser': ('busse',),
'bussa': ('busse',),
'busse': ('busse',),
'bussen': ('busse',),
'bussene': ('busse',),
'busser': ('busse',),
'busserull': ('busserull',),
'busserullen': ('busserull',),
'busserullene': ('busserull',),
'busseruller': ('busserull',),
'bussfelt': ('bussfelt',),
'bussfelta': ('bussfelt',),
'bussfeltene': ('bussfelt',),
'bussfelter': ('bussfelt',),
'bussfeltet': ('bussfelt',),
'bussfil': ('bussfil',),
'bussfilen': ('bussfil',),
'bussfilene': ('bussfil',),
'bussfiler': ('bussfil',),
'bussforbindelse': ('bussforbindelse',),
'bussforbindelsen': ('bussforbindelse',),
'bussforbindelsene': ('bussforbindelse',),
'bussforbindelser': ('bussforbindelse',),
'bussholdeplass': ('bussholdeplass',),
'bussholdeplassen': ('bussholdeplass',),
'bussholdeplassene': ('bussholdeplass',),
'bussholdeplasser': ('bussholdeplass',),
'bussjåfør': ('bussjåfør',),
'bussjåføren': ('bussjåfør',),
'bussjåførene': ('bussjåfør',),
'bussjåfører': ('bussjåfør',),
'bussruta': ('bussrute',),
'bussrute': ('bussrute',),
'bussruten': ('bussrute',),
'bussrutene': ('bussrute',),
'bussruter': ('bussrute',),
'bussterminal': ('bussterminal',),
'bussterminalen': ('bussterminal',),
'bussterminalene': ('bussterminal',),
'bussterminaler': ('bussterminal',),
'busstopp': ('busstopp',),
'busstoppa': ('busstopp',),
'busstoppen': ('busstopp',),
'busstoppene': ('busstopp',),
'busstoppet': ('busstopp',),
'bust': ('bust',),
'busta': ('bust',),
'busten': ('bust',),
'bustene': ('bust',),
'buster': ('bust',),
'bustad': ('bustad',),
'bustaden': ('bustad',),
'bustadene': ('bustad',),
'bustader': ('bustad',),
'bustadbank': ('bustadbank',),
'bustadbanken': ('bustadbank',),
'bustadbankene': ('bustadbank',),
'bustadbanker': ('bustadbank',),
'bustadlån': ('bustadlån',),
'bustadlåna': ('bustadlån',),
'bustadlånene': ('bustadlån',),
'bustadlånet': ('bustadlån',),
'bustnellik': ('bustnellik',),
'bustnelliken': ('bustnellik',),
'bustnellikene': ('bustnellik',),
'bustnelliker': ('bustnellik',),
'bustyra': ('bustyre',),
'bustyre': ('bustyre',),
'bustyrene': ('bustyre',),
'bustyrer': ('bustyre',),
'bustyret': ('bustyre',),
'bustyrer': ('bustyrer',),
'bustyrere': ('bustyrer',),
'bustyreren': ('bustyrer',),
'bustyrerer': ('bustyrer',),
'bustyrerne': ('bustyrer',),
'bustøtta': ('bustøtte',),
'bustøtte': ('bustøtte',),
'bustøtten': ('bustøtte',),
'bustøttene': ('bustøtte',),
'bustøtter': ('bustøtte',),
'butan': ('butan',),
'butana': ('butan',),
'butanen': ('butan',),
'butanene': ('butan',),
'butaner': ('butan',),
'butanet': ('butan',),
'butid': ('butid',),
'butida': ('butid',),
'butiden': ('butid',),
'butidene': ('butid',),
'butider': ('butid',),
'butikk': ('butikk',),
'butikken': ('butikk',),
'butikkene': ('butikk',),
'butikker': ('butikk',),
'butikk-kjede': ('butikk-kjede',),
'butikk-kjeden': ('butikk-kjede',),
'butikk-kjedene': ('butikk-kjede',),
'butikk-kjeder': ('butikk-kjede',),
'butikkdød': ('butikkdød',),
'butikkdøden': ('butikkdød',),
'butikkdødene': ('butikkdød',),
'butikkdøder': ('butikkdød',),
'butikkfagskole': ('butikkfagskole',),
'butikkfagskolen': ('butikkfagskole',),
'butikkfagskolene': ('butikkfagskole',),
'butikkfagskoler': ('butikkfagskole',),
'butikkfunksjonær': ('butikkfunksjonær',),
'butikkfunksjonæren': ('butikkfunksjonær',),
'butikkfunksjonærene': ('butikkfunksjonær',),
'butikkfunksjonærer': ('butikkfunksjonær',),
'butikkjede': ('butikkjede',),
'butikkjeden': ('butikkjede',),
'butikkjedene': ('butikkjede',),
'butikkjeder': ('butikkjede',),
'butikksenter': ('butikksenter',),
'butikksenteret': ('butikksenter',),
'butikksentra': ('butikksenter',),
'butikksentre': ('butikksenter',),
'butikksentrene': ('butikksenter',),
'butikksentret': ('butikksenter',),
'butikktjuv': ('butikktjuv',),
'butikktjuven': ('butikktjuv',),
'butikktjuvene': ('butikktjuv',),
'butikktjuver': ('butikktjuv',),
'butikktjuveri': ('butikktjuveri',),
'butikktjuveria': ('butikktjuveri',),
'butikktjuveriene': ('butikktjuveri',),
'butikktjuverier': ('butikktjuveri',),
'butikktjuveriet': ('butikktjuveri',),
'butikktyv': ('butikktyv',),
'butikktyven': ('butikktyv',),
'butikktyvene': ('butikktyv',),
'butikktyver': ('butikktyv',),
'butikktyveri': ('butikktyveri',),
'butikktyveria': ('butikktyveri',),
'butikktyveriene': ('butikktyveri',),
'butikktyverier': ('butikktyveri',),
'butikktyveriet': ('butikktyveri',),
'butikkvindu': ('butikkvindu',),
'butikkvindua': ('butikkvindu',),
'butikkvinduene': ('butikkvindu',),
'butikkvinduer': ('butikkvindu',),
'butikkvinduet': ('butikkvindu',),
'butt': ('butt',),
'butten': ('butt',),
'buttene': ('butt',),
'butter': ('butt',),
'butt': ('butt',),
'butten': ('butt',),
'buttene': ('butt',),
'butter': ('butt',),
'butterdeig': ('butterdeig',),
'butterdeigen': ('butterdeig',),
'butterdeigene': ('butterdeig',),
'butterdeiger': ('butterdeig',),
'butterfly': ('butterfly',),
'butterflyen': ('butterfly',),
'butterflyene': ('butterfly',),
'butterflyer': ('butterfly',),
'buttskjøt': ('buttskjøt',),
'buttskjøten': ('buttskjøt',),
'buttskjøtene': ('buttskjøt',),
'buttskjøter': ('buttskjøt',),
'buttsveis': ('buttsveis',),
'buttsveisen': ('buttsveis',),
'buttsveisene': ('buttsveis',),
'buttsveiser': ('buttsveis',),
'by': ('by',),
'byen': ('by',),
'byene': ('by',),
'byer': ('by',),
'byantikvar': ('byantikvar',),
'byantikvaren': ('byantikvar',),
'byantikvarene': ('byantikvar',),
'byantikvarer': ('byantikvar',),
'bybefolkning': ('bybefolkning',),
'bybefolkninga': ('bybefolkning',),
'bybefolkningen': ('bybefolkning',),
'bybefolkningene': ('bybefolkning',),
'bybefolkninger': ('bybefolkning',),
'bybilda': ('bybilde',),
'bybilde': ('bybilde',),
'bybildene': ('bybilde',),
'bybilder': ('bybilde',),
'bybildet': ('bybilde',),
'bybud': ('bybud',),
'bybuda': ('bybud',),
'bybudene': ('bybud',),
'bybudet': ('bybud',),
'bydeform': ('bydeform',),
'bydeforma': ('bydeform',),
'bydeformen': ('bydeform',),
'bydeformene': ('bydeform',),
'bydeformer': ('bydeform',),
'bydel': ('bydel',),
'bydelen': ('bydel',),
'bydelene': ('bydel',),
'bydeler': ('bydel',),
'bydelsutvalg': ('bydelsutvalg',),
'bydelsutvalga': ('bydelsutvalg',),
'bydelsutvalgene': ('bydelsutvalg',),
'bydelsutvalget': ('bydelsutvalg',),
'bya': ('bye',),
'bye': ('bye',),
'byen': ('bye',),
'byene': ('bye',),
'byer': ('bye',),
'bya': ('bye',),
'bye': ('bye',),
'byen': ('bye',),
'byene': ('bye',),
'byer': ('bye',),
'byfogd': ('byfogd',),
'byfogden': ('byfogd',),
'byfogdene': ('byfogd',),
'byfogder': ('byfogd',),
'byfolk': ('byfolk',),
'byfolka': ('byfolk',),
'byfolkene': ('byfolk',),
'byfolket': ('byfolk',),
'byfornyelse': ('byfornyelse',),
'byfornyelsen': ('byfornyelse',),
'byfornyelsene': ('byfornyelse',),
'byfornyelser': ('byfornyelse',),
'byfornying': ('byfornying',),
'byfornyinga': ('byfornying',),
'byfornyingen': ('byfornying',),
'byfornyingene': ('byfornying',),
'byfornyinger': ('byfornying',),
'bygd': ('bygd',),
'bygda': ('bygd',),
'bygden': ('bygd',),
'bygdene': ('bygd',),
'bygder': ('bygd',),
'bygdeallmenning': ('bygdeallmenning',),
'bygdeallmenningen': ('bygdeallmenning',),
'bygdeallmenningene': ('bygdeallmenning',),
'bygdeallmenninger': ('bygdeallmenning',),
'bygdeborg': ('bygdeborg',),
'bygdeborga': ('bygdeborg',),
'bygdeborgen': ('bygdeborg',),
'bygdeborgene': ('bygdeborg',),
'bygdeborger': ('bygdeborg',),
'bygdeby': ('bygdeby',),
'bygdebyen': ('bygdeby',),
'bygdebyene': ('bygdeby',),
'bygdebyer': ('bygdeby',),
'bygdedans': ('bygdedans',),
'bygdedansen': ('bygdedans',),
'bygdedansene': ('bygdedans',),
'bygdedanser': ('bygdedans',),
'bygdefolk': ('bygdefolk',),
'bygdefolka': ('bygdefolk',),
'bygdefolkene': ('bygdefolk',),
'bygdefolket': ('bygdefolk',),
'bygdegeni': ('bygdegeni',),
'bygdegenia': ('bygdegeni',),
'bygdegeniene': ('bygdegeni',),
'bygdegenier': ('bygdegeni',),
'bygdegeniet': ('bygdegeni',),
'bygdekultur': ('bygdekultur',),
'bygdekulturen': ('bygdekultur',),
'bygdekulturene': ('bygdekultur',),
'bygdekulturer': ('bygdekultur',),
'bygdelag': ('bygdelag',),
'bygdelaga': ('bygdelag',),
'bygdelagene': ('bygdelag',),
'bygdelaget': ('bygdelag',),
'bygdemål': ('bygdemål',),
'bygdemåla': ('bygdemål',),
'bygdemålene': ('bygdemål',),
'bygdemålet': ('bygdemål',),
'bygdemålsdikter': ('bygdemålsdikter',),
'bygdemålsdiktere': ('bygdemålsdikter',),
'bygdemålsdikteren': ('bygdemålsdikter',),
'bygdemålsdikterer': ('bygdemålsdikter',),
'bygdemålsdikterne': ('bygdemålsdikter',),
'bygdemålslitteratur': ('bygdemålslitteratur',),
'bygdemålslitteraturen': ('bygdemålslitteratur',),
'bygdemålslitteraturene': ('bygdemålslitteratur',),
'bygdemålslitteraturer': ('bygdemålslitteratur',),
'bygdemålsvisa': ('bygdemålsvise',),
'bygdemålsvise': ('bygdemålsvise',),
'bygdemålsvisen': ('bygdemålsvise',),
'bygdemålsvisene': ('bygdemålsvise',),
'bygdemålsviser': ('bygdemålsvise',),
'bygdetun': ('bygdetun',),
'bygdetuna': ('bygdetun',),
'bygdetunene': ('bygdetun',),
'bygdetunet': ('bygdetun',),
'bygdeveg': ('bygdeveg',),
'bygdevegen': ('bygdeveg',),
'bygdevegene': ('bygdeveg',),
'bygdeveger': ('bygdeveg',),
'bygdevei': ('bygdevei',),
'bygdeveien': ('bygdevei',),
'bygdeveiene': ('bygdevei',),
'bygdeveier': ('bygdevei',),
'byga': ('byge',),
'byge': ('byge',),
'bygen': ('byge',),
'bygene': ('byge',),
'byger': ('byge',),
'byga': ('byge',),
'byge': ('byge',),
'bygen': ('byge',),
'bygene': ('byge',),
'byger': ('byge',),
'bygerilja': ('bygerilja',),
'bygeriljaen': ('bygerilja',),
'bygeriljaene': ('bygerilja',),
'bygeriljaer': ('bygerilja',),
'bygg': ('bygg',),
'bygga': ('bygg',),
'byggene': ('bygg',),
'bygget': ('bygg',),
'bygg': ('bygg',),
'bygga': ('bygg',),
'byggen': ('bygg',),
'byggene': ('bygg',),
'bygger': ('bygg',),
'bygget': ('bygg',),
'bygg-gryn': ('bygg-gryn',),
'bygg-gryna': ('bygg-gryn',),
'bygg-grynene': ('bygg-gryn',),
'bygg-grynet': ('bygg-gryn',),
'byggearbeid': ('byggearbeid',),
'byggearbeida': ('byggearbeid',),
'byggearbeidene': ('byggearbeid',),
'byggearbeider': ('byggearbeid',),
'byggearbeidet': ('byggearbeid',),
'byggeelement': ('byggeelement',),
'byggeelementa': ('byggeelement',),
'byggeelementene': ('byggeelement',),
'byggeelementer': ('byggeelement',),
'byggeelementet': ('byggeelement',),
'byggefelt': ('byggefelt',),
'byggefelta': ('byggefelt',),
'byggefeltene': ('byggefelt',),
'byggefelter': ('byggefelt',),
'byggefeltet': ('byggefelt',),
'byggeforbud': ('byggeforbud',),
'byggeforbuda': ('byggeforbud',),
'byggeforbudene': ('byggeforbud',),
'byggeforbudet': ('byggeforbud',),
'byggeforetak': ('byggeforetak',),
'byggeforetaka': ('byggeforetak',),
'byggeforetakene': ('byggeforetak',),
'byggeforetaket': ('byggeforetak',),
'byggeforskrift': ('byggeforskrift',),
'byggeforskrifta': ('byggeforskrift',),
'byggeforskriften': ('byggeforskrift',),
'byggeforskriftene': ('byggeforskrift',),
'byggeforskrifter': ('byggeforskrift',),
'byggegrensa': ('byggegrense',),
'byggegrense': ('byggegrense',),
'byggegrensen': ('byggegrense',),
'byggegrensene': ('byggegrense',),
'byggegrenser': ('byggegrense',),
'byggekloss': ('byggekloss',),
'byggeklossen': ('byggekloss',),
'byggeklossene': ('byggekloss',),
'byggeklosser': ('byggekloss',),
'byggeklossprinsipp': ('byggeklossprinsipp',),
'byggeklossprinsippa': ('byggeklossprinsipp',),
'byggeklossprinsippene': ('byggeklossprinsipp',),
'byggeklossprinsipper': ('byggeklossprinsipp',),
'byggeklossprinsippet': ('byggeklossprinsipp',),
'byggekunst': ('byggekunst',),
'byggekunsten': ('byggekunst',),
'byggekunstene': ('byggekunst',),
'byggekunster': ('byggekunst',),
'byggeleder': ('byggeleder',),
'byggeledere': ('byggeleder',),
'byggelederen': ('byggeleder',),
'byggelederer': ('byggeleder',),
'byggelederne': ('byggeleder',),
'byggelån': ('byggelån',),
'byggelåna': ('byggelån',),
'byggelånene': ('byggelån',),
'byggelånet': ('byggelån',),
'byggeløyva': ('byggeløyve',),
'byggeløyve': ('byggeløyve',),
'byggeløyvene': ('byggeløyve',),
'byggeløyver': ('byggeløyve',),
'byggeløyvet': ('byggeløyve',),
'byggemelding': ('byggemelding',),
'byggemeldinga': ('byggemelding',),
'byggemeldingen': ('byggemelding',),
'byggemeldingene': ('byggemelding',),
'byggemeldinger': ('byggemelding',),
'byggemåte': ('byggemåte',),
'byggemåten': ('byggemåte',),
'byggemåtene': ('byggemåte',),
'byggemåter': ('byggemåte',),
'byggenemnd': ('byggenemnd',),
'byggenemnda': ('byggenemnd',),
'byggenemnden': ('byggenemnd',),
'byggenemndene': ('byggenemnd',),
'byggenemnder': ('byggenemnd',),
'byggenummer': ('byggenummer',),
'byggenummeret': ('byggenummer',),
'byggenumra': ('byggenummer',),
'byggenumre': ('byggenummer',),
'byggenumrene': ('byggenummer',),
'bygger': ('bygger',),
'byggere': ('bygger',),
'byggeren': ('bygger',),
'byggerer': ('bygger',),
'byggerne': ('bygger',),
'byggesamtykka': ('byggesamtykke',),
'byggesamtykke': ('byggesamtykke',),
'byggesamtykkene': ('byggesamtykke',),
'byggesamtykker': ('byggesamtykke',),
'byggesamtykket': ('byggesamtykke',),
'byggesett': ('byggesett',),
'byggesetta': ('byggesett',),
'byggesettene': ('byggesett',),
'byggesettet': ('byggesett',),
'byggeskikk': ('byggeskikk',),
'byggeskikken': ('byggeskikk',),
'byggeskikkene': ('byggeskikk',),
'byggeskikker': ('byggeskikk',),
'byggesona': ('byggesone',),
'byggesone': ('byggesone',),
'byggesonen': ('byggesone',),
'byggesonene': ('byggesone',),
'byggesoner': ('byggesone',),
'byggestein': ('byggestein',),
'byggesteinen': ('byggestein',),
'byggesteinene': ('byggestein',),
'byggesteiner': ('byggestein',),
'byggetid': ('byggetid',),
'byggetida': ('byggetid',),
'byggetiden': ('byggetid',),
'byggetidene': ('byggetid',),
'byggetider': ('byggetid',),
'byggetillatelse': ('byggetillatelse',),
'byggetillatelsen': ('byggetillatelse',),
'byggetillatelsene': ('byggetillatelse',),
'byggetillatelser': ('byggetillatelse',),
'byggetomt': ('byggetomt',),
'byggetomta': ('byggetomt',),
'byggetomten': ('byggetomt',),
'byggetomtene': ('byggetomt',),
'byggetomter': ('byggetomt',),
'byggetrinn': ('byggetrinn',),
'byggetrinna': ('byggetrinn',),
'byggetrinnene': ('byggetrinn',),
'byggetrinnet': ('byggetrinn',),
'byggevara': ('byggevare',),
'byggevare': ('byggevare',),
'byggevaren': ('byggevare',),
'byggevarene': ('byggevare',),
'byggevarer': ('byggevare',),
'byggevirksomhet': ('byggevirksomhet',),
'byggevirksomheta': ('byggevirksomhet',),
'byggevirksomheten': ('byggevirksomhet',),
'byggevirksomhetene': ('byggevirksomhet',),
'byggevirksomheter': ('byggevirksomhet',),
'byggherre': ('byggherre',),
'byggherren': ('byggherre',),
'byggherrene': ('byggherre',),
'byggherrer': ('byggherre',),
'bygging': ('bygging',),
'bygginga': ('bygging',),
'byggingen': ('bygging',),
'byggingene': ('bygging',),
'bygginger': ('bygging',),
'byggkorn': ('byggkorn',),
'byggkorna': ('byggkorn',),
'byggkornene': ('byggkorn',),
'byggkornet': ('byggkorn',),
'byggmel': ('byggmel',),
'byggmela': ('byggmel',),
'byggmelene': ('byggmel',),
'byggmelet': ('byggmel',),
'byggmester': ('byggmester',),
'byggmestere': ('byggmester',),
'byggmesteren': ('byggmester',),
'byggmesterer': ('byggmester',),
'byggmesterne': ('byggmester',),
'byggmestre': ('byggmester',),
'byggmestrene': ('byggmester',),
'byggmestrer': ('byggmester',),
'byggmjøl': ('byggmjøl',),
'byggmjøla': ('byggmjøl',),
'byggmjølene': ('byggmjøl',),
'byggmjølet': ('byggmjøl',),
'byggryn': ('byggryn',),
'byggryna': ('byggryn',),
'byggrynene': ('byggryn',),
'byggrynet': ('byggryn',),
'byggsuppa': ('byggsuppe',),
'byggsuppe': ('byggsuppe',),
'byggsuppen': ('byggsuppe',),
'byggsuppene': ('byggsuppe',),
'byggsupper': ('byggsuppe',),
'byggverk': ('byggverk',),
'byggverka': ('byggverk',),
'byggverkene': ('byggverk',),
'byggverker': ('byggverk',),
'byggverket': ('byggverk',),
'bygning': ('bygning',),
'bygninga': ('bygning',),
'bygningen': ('bygning',),
'bygningene': ('bygning',),
'bygninger': ('bygning',),
'bygningsarbeider': ('bygningsarbeider',),
'bygningsarbeidere': ('bygningsarbeider',),
'bygningsarbeideren': ('bygningsarbeider',),
'bygningsarbeiderer': ('bygningsarbeider',),
'bygningsarbeiderne': ('bygningsarbeider',),
'bygningsartikkel': ('bygningsartikkel',),
'bygningsartikkelen': ('bygningsartikkel',),
'bygningsartiklene': ('bygningsartikkel',),
'bygningsartikler': ('bygningsartikkel',),
'bygningsattest': ('bygningsattest',),
'bygningsattesten': ('bygningsattest',),
'bygningsattestene': ('bygningsattest',),
'bygningsattester': ('bygningsattest',),
'bygningsdel': ('bygningsdel',),
'bygningsdelen': ('bygningsdel',),
'bygningsdelene': ('bygningsdel',),
'bygningsdeler': ('bygningsdel',),
'bygningsindustri': ('bygningsindustri',),
'bygningsindustrien': ('bygningsindustri',),
'bygningsindustriene': ('bygningsindustri',),
'bygningsindustrier': ('bygningsindustri',),
'bygningskontroll': ('bygningskontroll',),
'bygningskontrollen': ('bygningskontroll',),
'bygningskontrollene': ('bygningskontroll',),
'bygningskontroller': ('bygningskontroll',),
'bygningslov': ('bygningslov',),
'bygningsloven': ('bygningslov',),
'bygningslovene': ('bygningslov',),
'bygningslover': ('bygningslov',),
'bygningsnemnd': ('bygningsnemnd',),
'bygningsnemnda': ('bygningsnemnd',),
'bygningsnemnden': ('bygningsnemnd',),
'bygningsnemndene': ('bygningsnemnd',),
'bygningsnemnder': ('bygningsnemnd',),
'bygningspapp': ('bygningspapp',),
'bygningspappen': ('bygningspapp',),
'bygningspappene': ('bygningspapp',),
'bygningspapper': ('bygningspapp',),
'bygningsråd': ('bygningsråd',),
'bygningsråda': ('bygningsråd',),
'bygningsrådene': ('bygningsråd',),
'bygningsrådet': ('bygningsråd',),
'bygningssjef': ('bygningssjef',),
'bygningssjefen': ('bygningssjef',),
'bygningssjefene': ('bygningssjef',),
'bygningssjefer': ('bygningssjef',),
'bygningssnekker': ('bygningssnekker',),
'bygningssnekkere': ('bygningssnekker',),
'bygningssnekkeren': ('bygningssnekker',),
'bygningssnekkerer': ('bygningssnekker',),
'bygningssnekkerne': ('bygningssnekker',),
'bygningsvedtekt': ('bygningsvedtekt',),
'bygningsvedtekta': ('bygningsvedtekt',),
'bygningsvedtekten': ('bygningsvedtekt',),
'bygningsvedtektene': ('bygningsvedtekt',),
'bygningsvedtekter': ('bygningsvedtekt',),
'bygsel': ('bygsel',),
'bygselen': ('bygsel',),
'bygsla': ('bygsel',),
'bygslene': ('bygsel',),
'bygsler': ('bygsel',),
'bygselbrev': ('bygselbrev',),
'bygselbreva': ('bygselbrev',),
'bygselbrevene': ('bygselbrev',),
'bygselbrever': ('bygselbrev',),
'bygselbrevet': ('bygselbrev',),
'bygselrett': ('bygselrett',),
'bygselretten': ('bygselrett',),
'bygselrettene': ('bygselrett',),
'bygselretter': ('bygselrett',),
'bygård': ('bygård',),
'bygården': ('bygård',),
'bygårdene': ('bygård',),
'bygårder': ('bygård',),
'bykjerne': ('bykjerne',),
'bykjernen': ('bykjerne',),
'bykjernene': ('bykjerne',),
'bykjerner': ('bykjerne',),
'bykommune': ('bykommune',),
'bykommunen': ('bykommune',),
'bykommunene': ('bykommune',),
'bykommuner': ('bykommune',),
'byks': ('byks',),
'byksa': ('byks',),
'byksene': ('byks',),
'bykset': ('byks',),
'bykultur': ('bykultur',),
'bykulturen': ('bykultur',),
'bykulturene': ('bykultur',),
'bykulturer': ('bykultur',),
'byliv': ('byliv',),
'byliva': ('byliv',),
'bylivene': ('byliv',),
'bylivet': ('byliv',),
'byll': ('byll',),
'byllen': ('byll',),
'byllene': ('byll',),
'byller': ('byll',),
'byllepest': ('byllepest',),
'byllepesta': ('byllepest',),
'byllepesten': ('byllepest',),
'byllepestene': ('byllepest',),
'byllepester': ('byllepest',),
'bylt': ('bylt',),
'bylten': ('bylt',),
'byltene': ('bylt',),
'bylter': ('bylt',),
'bymenneska': ('bymenneske',),
'bymenneske': ('bymenneske',),
'bymenneskene': ('bymenneske',),
'bymennesker': ('bymenneske',),
'bymennesket': ('bymenneske',),
'bymiljø': ('bymiljø',),
'bymiljøa': ('bymiljø',),
'bymiljøene': ('bymiljø',),
'bymiljøer': ('bymiljø',),
'bymiljøet': ('bymiljø',),
'bymur': ('bymur',),
'bymuren': ('bymur',),
'bymurene': ('bymur',),
'bymurer': ('bymur',),
'bymål': ('bymål',),
'bymåla': ('bymål',),
'bymålene': ('bymål',),
'bymålet': ('bymål',),
'byoriginal': ('byoriginal',),
'byoriginalen': ('byoriginal',),
'byoriginalene': ('byoriginal',),
'byoriginaler': ('byoriginal',),
'byplan': ('byplan',),
'byplanen': ('byplan',),
'byplanene': ('byplan',),
'byplaner': ('byplan',),
'byplanlegging': ('byplanlegging',),
'byplanlegginga': ('byplanlegging',),
'byplanleggingen': ('byplanlegging',),
'byplanleggingene': ('byplanlegging',),
'byplanlegginger': ('byplanlegging',),
'byplanråd': ('byplanråd',),
'byplanråda': ('byplanråd',),
'byplanrådene': ('byplanråd',),
'byplanrådet': ('byplanråd',),
'byport': ('byport',),
'byporten': ('byport',),
'byportene': ('byport',),
'byporter': ('byport',),
'byrd': ('byrd',),
'byrden': ('byrd',),
'byrdene': ('byrd',),
'byrder': ('byrd',),
'byrde': ('byrde',),
'byrden': ('byrde',),
'byrdene': ('byrde',),
'byrder': ('byrde',),
'byrett': ('byrett',),
'byretten': ('byrett',),
'byrettene': ('byrett',),
'byretter': ('byrett',),
'byrette': ('byrette',),
'byretten': ('byrette',),
'byrettene': ('byrette',),
'byretter': ('byrette',),
'byrettsdom': ('byrettsdom',),
'byrettsdommen': ('byrettsdom',),
'byrettsdommene': ('byrettsdom',),
'byrettsdommer': ('byrettsdom',),
'byrettsdommer': ('byrettsdommer',),
'byrettsdommere': ('byrettsdommer',),
'byrettsdommeren': ('byrettsdommer',),
'byrettsdommerer': ('byrettsdommer',),
'byrettsdommerne': ('byrettsdommer',),
'byrettsjustitiarien': ('byrettsjustitiarius',),
'byrettsjustitiariene': ('byrettsjustitiarius',),
'byrettsjustitiarier': ('byrettsjustitiarius',),
'byrettsjustitiarius': ('byrettsjustitiarius',),
'byrå': ('byrå',),
'byråa': ('byrå',),
'byråene': ('byrå',),
'byråer': ('byrå',),
'byrået': ('byrå',),
'byråd': ('byråd',),
'byråden': ('byråd',),
'byrådene': ('byråd',),
'byråder': ('byråd',),
'byråd': ('byråd',),
'byråda': ('byråd',),
'byrådene': ('byråd',),
'byrådet': ('byråd',),
'byrådsleder': ('byrådsleder',),
'byrådsledere': ('byrådsleder',),
'byrådslederen': ('byrådsleder',),
'byrådslederer': ('byrådsleder',),
'byrådslederne': ('byrådsleder',),
'byråkrat': ('byråkrat',),
'byråkraten': ('byråkrat',),
'byråkratene': ('byråkrat',),
'byråkrater': ('byråkrat',),
'byråkrati': ('byråkrati',),
'byråkratia': ('byråkrati',),
'byråkratiene': ('byråkrati',),
'byråkratier': ('byråkrati',),
'byråkratiet': ('byråkrati',),
'byråsjef': ('byråsjef',),
'byråsjefen': ('byråsjef',),
'byråsjefene': ('byråsjef',),
'byråsjefer': ('byråsjef',),
'byråsjefsstilling': ('byråsjefsstilling',),
'byråsjefsstillinga': ('byråsjefsstilling',),
'byråsjefsstillingen': ('byråsjefsstilling',),
'byråsjefsstillingene': ('byråsjefsstilling',),
'byråsjefsstillinger': ('byråsjefsstilling',),
'byråsjefstilling': ('byråsjefstilling',),
'byråsjefstillinga': ('byråsjefstilling',),
'byråsjefstillingen': ('byråsjefstilling',),
'byråsjefstillingene': ('byråsjefstilling',),
'byråsjefstillinger': ('byråsjefstilling',),
'bysantiner': ('bysantiner',),
'bysantinere': ('bysantiner',),
'bysantineren': ('bysantiner',),
'bysantinerer': ('bysantiner',),
'bysantinerne': ('bysantiner',),
'bysbarn': ('bysbarn',),
'bysbarna': ('bysbarn',),
'bysbarnene': ('bysbarn',),
'bysbarnet': ('bysbarn',),
'byskriver': ('byskriver',),
'byskrivere': ('byskriver',),
'byskriveren': ('byskriver',),
'byskriverer': ('byskriver',),
'byskriverne': ('byskriver',),
'byssa': ('bysse',),
'bysse': ('bysse',),
'byssen': ('bysse',),
'byssene': ('bysse',),
'bysser': ('bysse',),
'byssegutt': ('byssegutt',),
'byssegutten': ('byssegutt',),
'bysseguttene': ('byssegutt',),
'byssegutter': ('byssegutt',),
'byssejenta': ('byssejente',),
'byssejente': ('byssejente',),
'byssejenten': ('byssejente',),
'byssejentene': ('byssejente',),
'byssejenter': ('byssejente',),
'byssetjeneste': ('byssetjeneste',),
'byssetjenesten': ('byssetjeneste',),
'byssetjenestene': ('byssetjeneste',),
'byssetjenester': ('byssetjeneste',),
'bysta': ('byste',),
'byste': ('byste',),
'bysten': ('byste',),
'bystene': ('byste',),
'byster': ('byste',),
'bysteholder': ('bysteholder',),
'bysteholdere': ('bysteholder',),
'bysteholderen': ('bysteholder',),
'bysteholderer': ('bysteholder',),
'bysteholderne': ('bysteholder',),
'bystyra': ('bystyre',),
'bystyre': ('bystyre',),
'bystyrene': ('bystyre',),
'bystyrer': ('bystyre',),
'bystyret': ('bystyre',),
'bystyremedlem': ('bystyremedlem',),
'bystyremedlemma': ('bystyremedlem',),
'bystyremedlemmene': ('bystyremedlem',),
'bystyremedlemmer': ('bystyremedlem',),
'bystyremedlemmet': ('bystyremedlem',),
'bystyrevalg': ('bystyrevalg',),
'bystyrevalga': ('bystyrevalg',),
'bystyrevalgene': ('bystyrevalg',),
'bystyrevalget': ('bystyrevalg',),
'bystyrevedtak': ('bystyrevedtak',),
'bystyrevedtaka': ('bystyrevedtak',),
'bystyrevedtakene': ('bystyrevedtak',),
'bystyrevedtaket': ('bystyrevedtak',),
'byte': ('byte',),
'byten': ('byte',),
'bytene': ('byte',),
'bytta': ('bytte',),
'bytte': ('bytte',),
'byttene': ('bytte',),
'bytter': ('bytte',),
'byttet': ('bytte',),
'byttearbeid': ('byttearbeid',),
'byttearbeida': ('byttearbeid',),
'byttearbeidene': ('byttearbeid',),
'byttearbeider': ('byttearbeid',),
'byttearbeidet': ('byttearbeid',),
'byttegjenstand': ('byttegjenstand',),
'byttegjenstanden': ('byttegjenstand',),
'byttegjenstandene': ('byttegjenstand',),
'byttegjenstander': ('byttegjenstand',),
'byttehandel': ('byttehandel',),
'byttehandelen': ('byttehandel',),
'byttehandlene': ('byttehandel',),
'byttehandler': ('byttehandel',),
'byttehusholdning': ('byttehusholdning',),
'byttehusholdninga': ('byttehusholdning',),
'byttehusholdningen': ('byttehusholdning',),
'byttehusholdningene': ('byttehusholdning',),
'byttehusholdninger': ('byttehusholdning',),
'byttemiddel': ('byttemiddel',),
'byttemiddelet': ('byttemiddel',),
'byttemidla': ('byttemiddel',),
'byttemidlene': ('byttemiddel',),
'byttemidler': ('byttemiddel',),
'byttemidlet': ('byttemiddel',),
'bytting': ('bytting',),
'byttingen': ('bytting',),
'byttingene': ('bytting',),
'byttinger': ('bytting',),
'byvekt': ('byvekt',),
'byvekta': ('byvekt',),
'byvekten': ('byvekt',),
'byvektene': ('byvekt',),
'byvekter': ('byvekt',),
'byvåpen': ('byvåpen',),
'byvåpenet': ('byvåpen',),
'byvåpna': ('byvåpen',),
'byvåpnene': ('byvåpen',),
'båe': ('båe',),
'båen': ('båe',),
'båene': ('båe',),
'båer': ('båe',),
'båk': ('båk',),
'båken': ('båk',),
'båkene': ('båk',),
'båker': ('båk',),
'båke': ('båke',),
'båken': ('båke',),
'båkene': ('båke',),
'båker': ('båke',),
'bål': ('bål',),
'båla': ('bål',),
'bålene': ('bål',),
'bålet': ('bål',),
'båle': ('båle',),
'bålen': ('båle',),
'bålene': ('båle',),
'båler': ('båle',),
'bålferd': ('bålferd',),
'bålferda': ('bålferd',),
'bålferden': ('bålferd',),
'bålferdene': ('bålferd',),
'bålferder': ('bålferd',),
'bånd': ('bånd',),
'bånda': ('bånd',),
'båndene': ('bånd',),
'båndet': ('bånd',),
'båndby': ('båndby',),
'båndbyen': ('båndby',),
'båndbyene': ('båndby',),
'båndbyer': ('båndby',),
'båndjern': ('båndjern',),
'båndjerna': ('båndjern',),
'båndjernene': ('båndjern',),
'båndjernet': ('båndjern',),
'båndkniv': ('båndkniv',),
'båndkniven': ('båndkniv',),
'båndknivene': ('båndkniv',),
'båndkniver': ('båndkniv',),
'båndopptaker': ('båndopptaker',),
'båndopptakere': ('båndopptaker',),
'båndopptakeren': ('båndopptaker',),
'båndopptakerer': ('båndopptaker',),
'båndopptakerne': ('båndopptaker',),
'båndsalat': ('båndsalat',),
'båndsalaten': ('båndsalat',),
'båndsalatene': ('båndsalat',),
'båndsalater': ('båndsalat',),
'båndspeller': ('båndspeller',),
'båndspellere': ('båndspeller',),
'båndspelleren': ('båndspeller',),
'båndspellerer': ('båndspeller',),
'båndspellerne': ('båndspeller',),
'båndspiller': ('båndspiller',),
'båndspillere': ('båndspiller',),
'båndspilleren': ('båndspiller',),
'båndspillerer': ('båndspiller',),
'båndspillerne': ('båndspiller',),
'båndstål': ('båndstål',),
'båndståla': ('båndstål',),
'båndstålene': ('båndstål',),
'båndstålet': ('båndstål',),
'båndtvang': ('båndtvang',),
'båndtvangen': ('båndtvang',),
'båndtvangene': ('båndtvang',),
'båndtvanger': ('båndtvang',),
'bånsull': ('bånsull',),
'bånsullen': ('bånsull',),
'bånsullene': ('bånsull',),
'bånsuller': ('bånsull',),
'bår': ('bår',),
'båra': ('bår',),
'båren': ('bår',),
'bårene': ('bår',),
'bårer': ('bår',),
'båra': ('båre',),
'båre': ('båre',),
'båren': ('båre',),
'bårene': ('båre',),
'bårer': ('båre',),
'båra': ('båre',),
'båre': ('båre',),
'båren': ('båre',),
'bårene': ('båre',),
'bårer': ('båre',),
'bårerom': ('bårerom',),
'båreromma': ('bårerom',),
'bårerommene': ('bårerom',),
'bårerommet': ('bårerom',),
'bås': ('bås',),
'båsen': ('bås',),
'båsene': ('bås',),
'båser': ('bås',),
'båsfjøs': ('båsfjøs',),
'båsfjøsa': ('båsfjøs',),
'båsfjøsen': ('båsfjøs',),
'båsfjøsene': ('båsfjøs',),
'båsfjøset': ('båsfjøs',),
'båt': ('båt',),
'båten': ('båt',),
'båtene': ('båt',),
'båter': ('båt',),
'båtbygger': ('båtbygger',),
'båtbyggere': ('båtbygger',),
'båtbyggeren': ('båtbygger',),
'båtbyggerer': ('båtbygger',),
'båtbyggerne': ('båtbygger',),
'båtbyggeri': ('båtbyggeri',),
'båtbyggeria': ('båtbyggeri',),
'båtbyggeriene': ('båtbyggeri',),
'båtbyggerier': ('båtbyggeri',),
'båtbyggeriet': ('båtbyggeri',),
'båtdekk': ('båtdekk',),
'båtdekka': ('båtdekk',),
'båtdekkene': ('båtdekk',),
'båtdekket': ('båtdekk',),
'båtfører': ('båtfører',),
'båtførere': ('båtfører',),
'båtføreren': ('båtfører',),
'båtførerer': ('båtfører',),
'båtførerne': ('båtfører',),
'båtførerbevis': ('båtførerbevis',),
'båtførerbevisa': ('båtførerbevis',),
'båtførerbevisene': ('båtførerbevis',),
'båtførerbeviser': ('båtførerbevis',),
'båtførerbeviset': ('båtførerbevis',),
'båthua': ('båthue',),
'båthue': ('båthue',),
'båthuen': ('båthue',),
'båthuene': ('båthue',),
'båthuer': ('båthue',),
'båthuva': ('båthuve',),
'båthuve': ('båthuve',),
'båthuven': ('båthuve',),
'båthuvene': ('båthuve',),
'båthuver': ('båthuve',),
'båthvelv': ('båthvelv',),
'båthvelva': ('båthvelv',),
'båthvelvene': ('båthvelv',),
'båthvelvet': ('båthvelv',),
'båtkvelv': ('båtkvelv',),
'båtkvelva': ('båtkvelv',),
'båtkvelven': ('båtkvelv',),
'båtkvelvene': ('båtkvelv',),
'båtkvelver': ('båtkvelv',),
'båtkvelvet': ('båtkvelv',),
'båtlengd': ('båtlengd',),
'båtlengda': ('båtlengd',),
'båtlengden': ('båtlengd',),
'båtlengdene': ('båtlengd',),
'båtlengder': ('båtlengd',),
'båtlengda': ('båtlengde',),
'båtlengde': ('båtlengde',),
'båtlengden': ('båtlengde',),
'båtlengdene': ('båtlengde',),
'båtlengder': ('båtlengde',),
'båtlua': ('båtlue',),
'båtlue': ('båtlue',),
'båtluen': ('båtlue',),
'båtluene': ('båtlue',),
'båtluer': ('båtlue',),
'båtluva': ('båtluve',),
'båtluve': ('båtluve',),
'båtluven': ('båtluve',),
'båtluvene': ('båtluve',),
'båtluver': ('båtluve',),
'båtmannskap': ('båtmannskap',),
'båtmannskapa': ('båtmannskap',),
'båtmannskapene': ('båtmannskap',),
'båtmannskaper': ('båtmannskap',),
'båtmannskapet': ('båtmannskap',),
'båtmotor': ('båtmotor',),
'båtmotoren': ('båtmotor',),
'båtmotorene': ('båtmotor',),
'båtmotorer': ('båtmotor',),
'båtnaust': ('båtnaust',),
'båtnausta': ('båtnaust',),
'båtnaustene': ('båtnaust',),
'båtnaustet': ('båtnaust',),
'båtrip': ('båtrip',),
'båtripa': ('båtrip',),
'båtripen': ('båtrip',),
'båtripene': ('båtrip',),
'båtriper': ('båtrip',),
'båtripa': ('båtripe',),
'båtripe': ('båtripe',),
'båtripen': ('båtripe',),
'båtripene': ('båtripe',),
'båtriper': ('båtripe',),
'båtruta': ('båtrute',),
'båtrute': ('båtrute',),
'båtruten': ('båtrute',),
'båtrutene': ('båtrute',),
'båtruter': ('båtrute',),
'båtshake': ('båtshake',),
'båtshaken': ('båtshake',),
'båtshakene': ('båtshake',),
'båtshaker': ('båtshake',),
'båtsmann': ('båtsmann',),
'båtsmannen': ('båtsmann',),
'båtsmenn': ('båtsmann',),
'båtsmennene': ('båtsmann',),
'båtsmannsknop': ('båtsmannsknop',),
'båtsmannsknopen': ('båtsmannsknop',),
'båtsmannsknopene': ('båtsmannsknop',),
'båtsmannsknoper': ('båtsmannsknop',),
'båtsmannsstol': ('båtsmannsstol',),
'båtsmannsstolen': ('båtsmannsstol',),
'båtsmannsstolene': ('båtsmannsstol',),
'båtsmannsstoler': ('båtsmannsstol',),
'båtstø': ('båtstø',),
'båtstøa': ('båtstø',),
'båtstøen': ('båtstø',),
'båtstøene': ('båtstø',),
'båtstøer': ('båtstø',),
'båttur': ('båttur',),
'båtturen': ('båttur',),
'båtturene': ('båttur',),
'båtturer': ('båttur',),
'båtvett': ('båtvett',),
'båtvetta': ('båtvett',),
'båtvettene': ('båtvett',),
'båtvettet': ('båtvett',),
'bæ': ('bæ',),
'bæa': ('bæ',),
'bæene': ('bæ',),
'bæet': ('bæ',),
'bær': ('bær',),
'bæra': ('bær',),
'bærene': ('bær',),
'bæret': ('bær',),
'bærbusk': ('bærbusk',),
'bærbusken': ('bærbusk',),
'bærbuskene': ('bærbusk',),
'bærbusker': ('bærbusk',),
'bærdyrking': ('bærdyrking',),
'bærdyrkinga': ('bærdyrking',),
'bærdyrkingen': ('bærdyrking',),
'bærdyrkingene': ('bærdyrking',),
'bærdyrkinger': ('bærdyrking',),
'bærebjelke': ('bærebjelke',),
'bærebjelken': ('bærebjelke',),
'bærebjelkene': ('bærebjelke',),
'bærebjelker': ('bærebjelke',),
'bærebølga': ('bærebølge',),
'bærebølge': ('bærebølge',),
'bærebølgen': ('bærebølge',),
'bærebølgene': ('bærebølge',),
'bærebølger': ('bærebølge',),
'bærebølgja': ('bærebølgje',),
'bærebølgje': ('bærebølgje',),
'bærebølgjen': ('bærebølgje',),
'bærebølgjene': ('bærebølgje',),
'bærebølgjer': ('bærebølgje',),
'bæreevna': ('bæreevne',),
'bæreevne': ('bæreevne',),
'bæreevnen': ('bæreevne',),
'bæreevnene': ('bæreevne',),
'bæreevner': ('bæreevne',),
'bæreplanbåt': ('bæreplanbåt',),
'bæreplanbåten': ('bæreplanbåt',),
'bæreplanbåtene': ('bæreplanbåt',),
'bæreplanbåter': ('bæreplanbåt',),
'bærepose': ('bærepose',),
'bæreposen': ('bærepose',),
'bæreposene': ('bærepose',),
'bæreposer': ('bærepose',),
'bærer': ('bærer',),
'bærere': ('bærer',),
'bæreren': ('bærer',),
'bærerer': ('bærer',),
'bærerne': ('bærer',),
'bærerakett': ('bærerakett',),
'bæreraketten': ('bærerakett',),
'bærerakettene': ('bærerakett',),
'bæreraketter': ('bærerakett',),
'bærestol': ('bærestol',),
'bærestolen': ('bærestol',),
'bærestolene': ('bærestol',),
'bærestoler': ('bærestol',),
'bærestykka': ('bærestykke',),
'bærestykke': ('bærestykke',),
'bærestykkene': ('bærestykke',),
'bærestykker': ('bærestykke',),
'bærestykket': ('bærestykke',),
'bærevegg': ('bærevegg',),
'bæreveggen': ('bærevegg',),
'bæreveggene': ('bærevegg',),
'bærevegger': ('bærevegg',),
'bærhøst': ('bærhøst',),
'bærhøsten': ('bærhøst',),
'bærhøstene': ('bærhøst',),
'bærhøster': ('bærhøst',),
'bærlyng': ('bærlyng',),
'bærlynga': ('bærlyng',),
'bærlyngen': ('bærlyng',),
'bærlyngene': ('bærlyng',),
'bærlynger': ('bærlyng',),
'bærlynget': ('bærlyng',),
'bærplukker': ('bærplukker',),
'bærplukkere': ('bærplukker',),
'bærplukkeren': ('bærplukker',),
'bærplukkerer': ('bærplukker',),
'bærplukkerne': ('bærplukker',),
'bærtua': ('bærtue',),
'bærtue': ('bærtue',),
'bærtuen': ('bærtue',),
'bærtuene': ('bærtue',),
'bærtuer': ('bærtue',),
'bærtur': ('bærtur',),
'bærturen': ('bærtur',),
'bærturene': ('bærtur',),
'bærturer': ('bærtur',),
'bærtuva': ('bærtuve',),
'bærtuve': ('bærtuve',),
'bærtuven': ('bærtuve',),
'bærtuvene': ('bærtuve',),
'bærtuver': ('bærtuve',),
'bæsj': ('bæsj',),
'bæsjen': ('bæsj',),
'bæsjene': ('bæsj',),
'bæsjer': ('bæsj',),
'bø': ('bø',),
'bøen': ('bø',),
'bøene': ('bø',),
'bøer': ('bø',),
'bø': ('bø',),
'bøa': ('bø',),
'bøene': ('bø',),
'bøet': ('bø',),
'bøddel': ('bøddel',),
'bøddelen': ('bøddel',),
'bødlene': ('bøddel',),
'bødler': ('bøddel',),
'bøddelgjerning': ('bøddelgjerning',),
'bøddelgjerninga': ('bøddelgjerning',),
'bøddelgjerningen': ('bøddelgjerning',),
'bøddelgjerningene': ('bøddelgjerning',),
'bøddelgjerninger': ('bøddelgjerning',),
'bøddeløks': ('bøddeløks',),
'bøddeløksa': ('bøddeløks',),
'bøddeløksen': ('bøddeløks',),
'bøddeløksene': ('bøddeløks',),
'bøddeløkser': ('bøddeløks',),
'bøffel': ('bøffel',),
'bøffelen': ('bøffel',),
'bøflene': ('bøffel',),
'bøfler': ('bøffel',),
'bøffelgras': ('bøffelgras',),
'bøffelgrasa': ('bøffelgras',),
'bøffelgrasene': ('bøffelgras',),
'bøffelgraset': ('bøffelgras',),
'bøffelgress': ('bøffelgress',),
'bøffelgressa': ('bøffelgress',),
'bøffelgressene': ('bøffelgress',),
'bøffelgresset': ('bøffelgress',),
'bøffelku': ('bøffelku',),
'bøffelkua': ('bøffelku',),
'bøffelkuen': ('bøffelku',),
'bøffelkuene': ('bøffelku',),
'bøffelkuer': ('bøffelku',),
'bøffelkyr': ('bøffelku',),
'bøffelkyrne': ('bøffelku',),
'bøffellær': ('bøffellær',),
'bøffellæra': ('bøffellær',),
'bøffellærene': ('bøffellær',),
'bøffellæret': ('bøffellær',),
'bøffelokse': ('bøffelokse',),
'bøffeloksen': ('bøffelokse',),
'bøffeloksene': ('bøffelokse',),
'bøffelokser': ('bøffelokse',),
'bøhmer': ('bøhmer',),
'bøhmere': ('bøhmer',),
'bøhmeren': ('bøhmer',),
'bøhmerer': ('bøhmer',),
'bøhmerne': ('bøhmer',),
'bøk': ('bøk',),
'bøken': ('bøk',),
'bøkene': ('bøk',),
'bøker': ('bøk',),
'bøkelauv': ('bøkelauv',),
'bøkelauva': ('bøkelauv',),
'bøkelauvene': ('bøkelauv',),
'bøkelauvet': ('bøkelauv',),
'bøkeløv': ('bøkeløv',),
'bøkeløva': ('bøkeløv',),
'bøkeløvene': ('bøkeløv',),
'bøkeløvet': ('bøkeløv',),
'bøkenøtt': ('bøkenøtt',),
'bøkenøtta': ('bøkenøtt',),
'bøkenøtten': ('bøkenøtt',),
'bøkenøttene': ('bøkenøtt',),
'bøkenøtter': ('bøkenøtt',),
'bøkeskog': ('bøkeskog',),
'bøkeskogen': ('bøkeskog',),
'bøkeskogene': ('bøkeskog',),
'bøkeskoger': ('bøkeskog',),
'bøkker': ('bøkker',),
'bøkkere': ('bøkker',),
'bøkkeren': ('bøkker',),
'bøkkerer': ('bøkker',),
'bøkkerne': ('bøkker',),
'bøkkerhandverk': ('bøkkerhandverk',),
'bøkkerhandverka': ('bøkkerhandverk',),
'bøkkerhandverkene': ('bøkkerhandverk',),
'bøkkerhandverket': ('bøkkerhandverk',),
'bøkkerhåndverk': ('bøkkerhåndverk',),
'bøkkerhåndverka': ('bøkkerhåndverk',),
'bøkkerhåndverkene': ('bøkkerhåndverk',),
'bøkkerhåndverket': ('bøkkerhåndverk',),
'bøkling': ('bøkling',),
'bøklingen': ('bøkling',),
'bøklingene': ('bøkling',),
'bøklinger': ('bøkling',),
'bøla': ('bøle',),
'bøle': ('bøle',),
'bølene': ('bøle',),
'bøler': ('bøle',),
'bølet': ('bøle',),
'bøla': ('bøle',),
'bøle': ('bøle',),
'bølen': ('bøle',),
'bølene': ('bøle',),
'bøler': ('bøle',),
'bølga': ('bølge',),
'bølge': ('bølge',),
'bølgen': ('bølge',),
'bølgene': ('bølge',),
'bølger': ('bølge',),
'bølgebevegelse': ('bølgebevegelse',),
'bølgebevegelsen': ('bølgebevegelse',),
'bølgebevegelsene': ('bølgebevegelse',),
'bølgebevegelser': ('bølgebevegelse',),
'bølgeblekk': ('bølgeblekk',),
'bølgeblekka': ('bølgeblekk',),
'bølgeblekkene': ('bølgeblekk',),
'bølgeblekket': ('bølgeblekk',),
'bølgeblekkplata': ('bølgeblekkplate',),
'bølgeblekkplate': ('bølgeblekkplate',),
'bølgeblekkplaten': ('bølgeblekkplate',),
'bølgeblekkplatene': ('bølgeblekkplate',),
'bølgeblekkplater': ('bølgeblekkplate',),
'bølgeblikk': ('bølgeblikk',),
'bølgeblikka': ('bølgeblikk',),
'bølgeblikkene': ('bølgeblikk',),
'bølgeblikket': ('bølgeblikk',),
'bølgeblikkplata': ('bølgeblikkplate',),
'bølgeblikkplate': ('bølgeblikkplate',),
'bølgeblikkplaten': ('bølgeblikkplate',),
'bølgeblikkplatene': ('bølgeblikkplate',),
'bølgeblikkplater': ('bølgeblikkplate',),
'bølgebryter': ('bølgebryter',),
'bølgebrytere': ('bølgebryter',),
'bølgebryteren': ('bølgebryter',),
'bølgebryterer': ('bølgebryter',),
'bølgebryterne': ('bølgebryter',),
'bølgedal': ('bølgedal',),
'bølgedalen': ('bølgedal',),
'bølgedalene': ('bølgedal',),
'bølgedaler': ('bølgedal',),
'bølgedemper': ('bølgedemper',),
'bølgedempere': ('bølgedemper',),
'bølgedemperen': ('bølgedemper',),
'bølgedemperer': ('bølgedemper',),
'bølgedemperne': ('bølgedemper',),
'bølgeenergi': ('bølgeenergi',),
'bølgeenergien': ('bølgeenergi',),
'bølgeenergiene': ('bølgeenergi',),
'bølgeenergier': ('bølgeenergi',),
'bølgefront': ('bølgefront',),
'bølgefronten': ('bølgefront',),
'bølgefrontene': ('bølgefront',),
'bølgefronter': ('bølgefront',),
'bølgegang': ('bølgegang',),
'bølgegangen': ('bølgegang',),
'bølgegangene': ('bølgegang',),
'bølgeganger': ('bølgegang',),
'bølgekam': ('bølgekam',),
'bølgekammen': ('bølgekam',),
'bølgekammene': ('bølgekam',),
'bølgekammer': ('bølgekam',),
'bølgekraftverk': ('bølgekraftverk',),
'bølgekraftverka': ('bølgekraftverk',),
'bølgekraftverkene': ('bølgekraftverk',),
'bølgekraftverker': ('bølgekraftverk',),
'bølgekraftverket': ('bølgekraftverk',),
'bølgelengda': ('bølgelengde',),
'bølgelengde': ('bølgelengde',),
'bølgelengden': ('bølgelengde',),
'bølgelengdene': ('bølgelengde',),
'bølgelengder': ('bølgelengde',),
'bølgelæra': ('bølgelære',),
'bølgelære': ('bølgelære',),
'bølgelæren': ('bølgelære',),
'bølgelærene': ('bølgelære',),
'bølgelærer': ('bølgelære',),
'bølgepapp': ('bølgepapp',),
'bølgepappen': ('bølgepapp',),
'bølgepappene': ('bølgepapp',),
'bølgepapper': ('bølgepapp',),
'bølgeplata': ('bølgeplate',),
'bølgeplate': ('bølgeplate',),
'bølgeplaten': ('bølgeplate',),
'bølgeplatene': ('bølgeplate',),
'bølgeplater': ('bølgeplate',),
'bølgerygg': ('bølgerygg',),
'bølgeryggen': ('bølgerygg',),
'bølgeryggene': ('bølgerygg',),
'bølgerygger': ('bølgerygg',),
'bølgetopp': ('bølgetopp',),
'bølgetoppen': ('bølgetopp',),
'bølgetoppene': ('bølgetopp',),
'bølgetopper': ('bølgetopp',),
'bølging': ('bølging',),
'bølginga': ('bølging',),
'bølgingen': ('bølging',),
'bølgingene': ('bølging',),
'bølginger': ('bølging',),
'bølgja': ('bølgje',),
'bølgje': ('bølgje',),
'bølgjen': ('bølgje',),
'bølgjene': ('bølgje',),
'bølgjer': ('bølgje',),
'bølgjebevegelse': ('bølgjebevegelse',),
'bølgjebevegelsen': ('bølgjebevegelse',),
'bølgjebevegelsene': ('bølgjebevegelse',),
'bølgjebevegelser': ('bølgjebevegelse',),
'bølgjeblekk': ('bølgjeblekk',),
'bølgjeblekka': ('bølgjeblekk',),
'bølgjeblekkene': ('bølgjeblekk',),
'bølgjeblekket': ('bølgjeblekk',),
'bølgjeblekkplata': ('bølgjeblekkplate',),
'bølgjeblekkplate': ('bølgjeblekkplate',),
'bølgjeblekkplaten': ('bølgjeblekkplate',),
'bølgjeblekkplatene': ('bølgjeblekkplate',),
'bølgjeblekkplater': ('bølgjeblekkplate',),
'bølgjeblikk': ('bølgjeblikk',),
'bølgjeblikka': ('bølgjeblikk',),
'bølgjeblikkene': ('bølgjeblikk',),
'bølgjeblikket': ('bølgjeblikk',),
'bølgjeblikkplata': ('bølgjeblikkplate',),
'bølgjeblikkplate': ('bølgjeblikkplate',),
'bølgjeblikkplaten': ('bølgjeblikkplate',),
'bølgjeblikkplatene': ('bølgjeblikkplate',),
'bølgjeblikkplater': ('bølgjeblikkplate',),
'bølgjebryter': ('bølgjebryter',),
'bølgjebrytere': ('bølgjebryter',),
'bølgjebryteren': ('bølgjebryter',),
'bølgjebryterer': ('bølgjebryter',),
'bølgjebryterne': ('bølgjebryter',),
'bølgjedal': ('bølgjedal',),
'bølgjedalen': ('bølgjedal',),
'bølgjedalene': ('bølgjedal',),
'bølgjedaler': ('bølgjedal',),
'bølgjedemper': ('bølgjedemper',),
'bølgjedempere': ('bølgjedemper',),
'bølgjedemperen': ('bølgjedemper',),
'bølgjedemperer': ('bølgjedemper',),
'bølgjedemperne': ('bølgjedemper',),
'bølgjeenergi': ('bølgjeenergi',),
'bølgjeenergien': ('bølgjeenergi',),
'bølgjeenergiene': ('bølgjeenergi',),
'bølgjeenergier': ('bølgjeenergi',),
'bølgjefront': ('bølgjefront',),
'bølgjefronten': ('bølgjefront',),
'bølgjefrontene': ('bølgjefront',),
'bølgjefronter': ('bølgjefront',),
'bølgjegang': ('bølgjegang',),
'bølgjegangen': ('bølgjegang',),
'bølgjegangene': ('bølgjegang',),
'bølgjeganger': ('bølgjegang',),
'bølgjekam': ('bølgjekam',),
'bølgjekammen': ('bølgjekam',),
'bølgjekammene': ('bølgjekam',),
'bølgjekammer': ('bølgjekam',),
'bølgjekraftverk': ('bølgjekraftverk',),
'bølgjekraftverka': ('bølgjekraftverk',),
'bølgjekraftverkene': ('bølgjekraftverk',),
'bølgjekraftverker': ('bølgjekraftverk',),
'bølgjekraftverket': ('bølgjekraftverk',),
'bølgjelengda': ('bølgjelengde',),
'bølgjelengde': ('bølgjelengde',),
'bølgjelengden': ('bølgjelengde',),
'bølgjelengdene': ('bølgjelengde',),
'bølgjelengder': ('bølgjelengde',),
'bølgjelæra': ('bølgjelære',),
'bølgjelære': ('bølgjelære',),
'bølgjelæren': ('bølgjelære',),
'bølgjelærene': ('bølgjelære',),
'bølgjelærer': ('bølgjelære',),
'bølgjepapp': ('bølgjepapp',),
'bølgjepappen': ('bølgjepapp',),
'bølgjepappene': ('bølgjepapp',),
'bølgjepapper': ('bølgjepapp',),
'bølgjeplata': ('bølgjeplate',),
'bølgjeplate': ('bølgjeplate',),
'bølgjeplaten': ('bølgjeplate',),
'bølgjeplatene': ('bølgjeplate',),
'bølgjeplater': ('bølgjeplate',),
'bølgjerygg': ('bølgjerygg',),
'bølgjeryggen': ('bølgjerygg',),
'bølgjeryggene': ('bølgjerygg',),
'bølgjerygger': ('bølgjerygg',),
'bølgjetopp': ('bølgjetopp',),
'bølgjetoppen': ('bølgjetopp',),
'bølgjetoppene': ('bølgjetopp',),
'bølgjetopper': ('bølgjetopp',),
'bøling': ('bøling',),
'bølingen': ('bøling',),
'bølingene': ('bøling',),
'bølinger': ('bøling',),
'bølla': ('bølle',),
'bølle': ('bølle',),
'bøllen': ('bølle',),
'bøllene': ('bølle',),
'bøller': ('bølle',),
'bøllefrø': ('bøllefrø',),
'bøllefrøa': ('bøllefrø',),
'bøllefrøene': ('bøllefrø',),
'bøllefrøet': ('bøllefrø',),
'bønn': ('bønn',),
'bønna': ('bønn',),
'bønnen': ('bønn',),
'bønnene': ('bønn',),
'bønner': ('bønn',),
'bønna': ('bønne',),
'bønne': ('bønne',),
'bønnen': ('bønne',),
'bønnene': ('bønne',),
'bønner': ('bønne',),
'bønnebok': ('bønnebok',),
'bønneboka': ('bønnebok',),
'bønneboken': ('bønnebok',),
'bønnebøkene': ('bønnebok',),
'bønnebøker': ('bønnebok',),
'bønneformular': ('bønneformular',),
'bønneformulara': ('bønneformular',),
'bønneformularen': ('bønneformular',),
'bønneformularene': ('bønneformular',),
'bønneformularer': ('bønneformular',),
'bønneformularet': ('bønneformular',),
'bønnematta': ('bønnematte',),
'bønnematte': ('bønnematte',),
'bønnematten': ('bønnematte',),
'bønnemattene': ('bønnematte',),
'bønnematter': ('bønnematte',),
'bønnemøta': ('bønnemøte',),
'bønnemøte': ('bønnemøte',),
'bønnemøtene': ('bønnemøte',),
'bønnemøter': ('bønnemøte',),
'bønnemøtet': ('bønnemøte',),
'bønnesamling': ('bønnesamling',),
'bønnesamlinga': ('bønnesamling',),
'bønnesamlingen': ('bønnesamling',),
'bønnesamlingene': ('bønnesamling',),
'bønnesamlinger': ('bønnesamling',),
'bønnestengel': ('bønnestengel',),
'bønnestengelen': ('bønnestengel',),
'bønnestenglene': ('bønnestengel',),
'bønnestengler': ('bønnestengel',),
'bønnesuppa': ('bønnesuppe',),
'bønnesuppe': ('bønnesuppe',),
'bønnesuppen': ('bønnesuppe',),
'bønnesuppene': ('bønnesuppe',),
'bønnesupper': ('bønnesuppe',),
'bønnevikka': ('bønnevikke',),
'bønnevikke': ('bønnevikke',),
'bønnevikken': ('bønnevikke',),
'bønnevikkene': ('bønnevikke',),
'bønnevikker': ('bønnevikke',),
'bønnskrift': ('bønnskrift',),
'bønnskrifta': ('bønnskrift',),
'bønnskriftene': ('bønnskrift',),
'bønnskrifter': ('bønnskrift',),
'bønnskriftet': ('bønnskrift',),
'bør': ('bør',),
'børa': ('bør',),
'børen': ('bør',),
'børene': ('bør',),
'bører': ('bør',),
'børa': ('børe',),
'børe': ('børe',),
'børen': ('børe',),
'børene': ('børe',),
'bører': ('børe',),
'børnskap': ('børnskap',),
'børnskapen': ('børnskap',),
'børnskapene': ('børnskap',),
'børnskaper': ('børnskap',),
'børs': ('børs',),
'børsen': ('børs',),
'børsene': ('børs',),
'børser': ('børs',),
'børsa': ('børse',),
'børse': ('børse',),
'børsen': ('børse',),
'børsene': ('børse',),
'børser': ('børse',),
'børsemaker': ('børsemaker',),
'børsemakere': ('børsemaker',),
'børsemakeren': ('børsemaker',),
'børsemakerer': ('børsemaker',),
'børsemakerne': ('børsemaker',),
'børsemunning': ('børsemunning',),
'børsemunninga': ('børsemunning',),
'børsemunningen': ('børsemunning',),
'børsemunningene': ('børsemunning',),
'børsemunninger': ('børsemunning',),
'børshai': ('børshai',),
'børshaien': ('børshai',),
'børshaiene': ('børshai',),
'børshaier': ('børshai',),
'børskommisær': ('børskommisær',),
'børskommisæren': ('børskommisær',),
'børskommisærene': ('børskommisær',),
'børskommisærer': ('børskommisær',),
'børskrakk': ('børskrakk',),
'børskrakka': ('børskrakk',),
'børskrakkene': ('børskrakk',),
'børskrakket': ('børskrakk',),
'børsmegler': ('børsmegler',),
'børsmeglere': ('børsmegler',),
'børsmegleren': ('børsmegler',),
'børsmeglerer': ('børsmegler',),
'børsmeglerne': ('børsmegler',),
'børsmekler': ('børsmekler',),
'børsmeklere': ('børsmekler',),
'børsmekleren': ('børsmekler',),
'børsmeklerer': ('børsmekler',),
'børsmeklerne': ('børsmekler',),
'børsnotering': ('børsnotering',),
'børsnoteringa': ('børsnotering',),
'børsnoteringen': ('børsnotering',),
'børsnoteringene': ('børsnotering',),
'børsnoteringer': ('børsnotering',),
'børspapir': ('børspapir',),
'børspapira': ('børspapir',),
'børspapirene': ('børspapir',),
'børspapirer': ('børspapir',),
'børspapiret': ('børspapir',),
'børsspekulasjon': ('børsspekulasjon',),
'børsspekulasjonen': ('børsspekulasjon',),
'børsspekulasjonene': ('børsspekulasjon',),
'børsspekulasjoner': ('børsspekulasjon',),
'børst': ('børst',),
'børsten': ('børst',),
'børstene': ('børst',),
'børster': ('børst',),
'børste': ('børste',),
'børsten': ('børste',),
'børstene': ('børste',),
'børster': ('børste',),
'børstebinder': ('børstebinder',),
'børstebindere': ('børstebinder',),
'børstebinderen': ('børstebinder',),
'børstebinderer': ('børstebinder',),
'børstebinderne': ('børstebinder',),
'børstemakk': ('børstemakk',),
'børstemakken': ('børstemakk',),
'børstemakkene': ('børstemakk',),
'børstemakker': ('børstemakk',),
'børstemark': ('børstemark',),
'børstemarken': ('børstemark',),
'børstemarkene': ('børstemark',),
'børstemarker': ('børstemark',),
'børsteorm': ('børsteorm',),
'børsteormen': ('børsteorm',),
'børsteormene': ('børsteorm',),
'børsteormer': ('børsteorm',),
'bøss': ('bøss',),
'bøssa': ('bøss',),
'bøssene': ('bøss',),
'bøsset': ('bøss',),
'bøssa': ('bøsse',),
'bøsse': ('bøsse',),
'bøssen': ('bøsse',),
'bøssene': ('bøsse',),
'bøsser': ('bøsse',),
'bøssing': ('bøssing',),
'bøssingen': ('bøssing',),
'bøssingene': ('bøssing',),
'bøssinger': ('bøssing',),
'bøteri': ('bøteri',),
'bøteria': ('bøteri',),
'bøteriene': ('bøteri',),
'bøterier': ('bøteri',),
'bøteriet': ('bøteri',),
'bøtingsvon': ('bøtingsvon',),
'bøtingsvona': ('bøtingsvon',),
'bøtingsvonen': ('bøtingsvon',),
'bøtingsvonene': ('bøtingsvon',),
'bøtingsvoner': ('bøtingsvon',),
'bøtta': ('bøtte',),
'bøtte': ('bøtte',),
'bøtten': ('bøtte',),
'bøttene': ('bøtte',),
'bøtter': ('bøtte',),
'bøtteballett': ('bøtteballett',),
'bøtteballetten': ('bøtteballett',),
'bøtteballettene': ('bøtteballett',),
'bøtteballetter': ('bøtteballett',),
'bøttekott': ('bøttekott',),
'bøttekotta': ('bøttekott',),
'bøttekottene': ('bøttekott',),
'bøttekottet': ('bøttekott',),
'bøttepapir': ('bøttepapir',),
'bøttepapira': ('bøttepapir',),
'bøttepapirene': ('bøttepapir',),
'bøttepapirer': ('bøttepapir',),
'bøttepapiret': ('bøttepapir',),
'bøy': ('bøy',),
'bøyen': ('bøy',),
'bøyene': ('bøy',),
'bøyer': ('bøy',),
'bøya': ('bøye',),
'bøye': ('bøye',),
'bøyen': ('bøye',),
'bøyene': ('bøye',),
'bøyer': ('bøye',),
'bøya': ('bøye',),
'bøye': ('bøye',),
'bøyen': ('bøye',),
'bøyene': ('bøye',),
'bøyer': ('bøye',),
'bøya': ('bøye',),
'bøye': ('bøye',),
'bøyen': ('bøye',),
'bøyene': ('bøye',),
'bøyer': ('bøye',),
'bøyemuskel': ('bøyemuskel',),
'bøyemuskelen': ('bøyemuskel',),
'bøyemusklene': ('bøyemuskel',),
'bøyemuskler': ('bøyemuskel',),
'bøyeprøva': ('bøyeprøve',),
'bøyeprøve': ('bøyeprøve',),
'bøyeprøven': ('bøyeprøve',),
'bøyeprøvene': ('bøyeprøve',),
'bøyeprøver': ('bøyeprøve',),
'bøyg': ('bøyg',),
'bøygen': ('bøyg',),
'bøygene': ('bøyg',),
'bøyger': ('bøyg',),
'bøying': ('bøying',),
'bøyinga': ('bøying',),
'bøyingen': ('bøying',),
'bøyingene': ('bøying',),
'bøyinger': ('bøying',),
'bøyingsendelse': ('bøyingsendelse',),
'bøyingsendelsen': ('bøyingsendelse',),
'bøyingsendelsene': ('bøyingsendelse',),
'bøyingsendelser': ('bøyingsendelse',),
'bøyingsending': ('bøyingsending',),
'bøyingsendinga': ('bøyingsending',),
'bøyingsendingen': ('bøyingsending',),
'bøyingsendingene': ('bøyingsending',),
'bøyingsendinger': ('bøyingsending',),
'bøyingsform': ('bøyingsform',),
'bøyingsforma': ('bøyingsform',),
'bøyingsformen': ('bøyingsform',),
'bøyingsformene': ('bøyingsform',),
'bøyingsformer': ('bøyingsform',),
'bøyingsmønster': ('bøyingsmønster',),
'bøyingsmønsteret': ('bøyingsmønster',),
'bøyingsmønstra': ('bøyingsmønster',),
'bøyingsmønstre': ('bøyingsmønster',),
'bøyingsmønstrene': ('bøyingsmønster',),
'bøyingsmønstret': ('bøyingsmønster',),
'bøyingsspråk': ('bøyingsspråk',),
'bøyingsspråka': ('bøyingsspråk',),
'bøyingsspråkene': ('bøyingsspråk',),
'bøyingsspråket': ('bøyingsspråk',),
'bøyingsverk': ('bøyingsverk',),
'bøyingsverka': ('bøyingsverk',),
'bøyingsverkene': ('bøyingsverk',),
'bøyingsverker': ('bøyingsverk',),
'bøyingsverket': ('bøyingsverk',),
'bøyle': ('bøyle',),
'bøylen': ('bøyle',),
'bøylene': ('bøyle',),
'bøyler': ('bøyle',),
'bøylehest': ('bøylehest',),
'bøylehesten': ('bøylehest',),
'bøylehestene': ('bøylehest',),
'bøylehester': ('bøylehest',),
'bøyning': ('bøyning',),
'bøyninga': ('bøyning',),
'bøyningen': ('bøyning',),
'bøyningene': ('bøyning',),
'bøyninger': ('bøyning',),
'bøyningsendelse': ('bøyningsendelse',),
'bøyningsendelsen': ('bøyningsendelse',),
'bøyningsendelsene': ('bøyningsendelse',),
'bøyningsendelser': ('bøyningsendelse',),
'bøyningsending': ('bøyningsending',),
'bøyningsendinga': ('bøyningsending',),
'bøyningsendingen': ('bøyningsending',),
'bøyningsendingene': ('bøyningsending',),
'bøyningsendinger': ('bøyningsending',),
'bøyningsform': ('bøyningsform',),
'bøyningsforma': ('bøyningsform',),
'bøyningsformen': ('bøyningsform',),
'bøyningsformene': ('bøyningsform',),
'bøyningsformer': ('bøyningsform',),
'bøyningsmønster': ('bøyningsmønster',),
'bøyningsmønsteret': ('bøyningsmønster',),
'bøyningsmønstra': ('bøyningsmønster',),
'bøyningsmønstre': ('bøyningsmønster',),
'bøyningsmønstrene': ('bøyningsmønster',),
'bøyningsmønstret': ('bøyningsmønster',),
'bøyningsspråk': ('bøyningsspråk',),
'bøyningsspråka': ('bøyningsspråk',),
'bøyningsspråkene': ('bøyningsspråk',),
'bøyningsspråket': ('bøyningsspråk',),
'bøyningsverk': ('bøyningsverk',),
'bøyningsverka': ('bøyningsverk',),
'bøyningsverkene': ('bøyningsverk',),
'bøyningsverker': ('bøyningsverk',),
'bøyningsverket': ('bøyningsverk',),
'c': ('c',),
'c\'en': ('c',),
'c-en': ('c',),
'c-ene': ('c',),
'c-er': ('c',),
'cédille': ('cédille',),
'cédillen': ('cédille',),
'cédillene': ('cédille',),
'cédiller': ('cédille',),
'c-moll': ('c-moll',),
'c-mollen': ('c-moll',),
'c-mollene': ('c-moll',),
'c-moller': ('c-moll',),
'c-nøkkel': ('c-nøkkel',),
'c-nøkkelen': ('c-nøkkel',),
'c-nøklene': ('c-nøkkel',),
'c-nøkler': ('c-nøkkel',),
'cabincruiser': ('cabincruiser',),
'cabincruisere': ('cabincruiser',),
'cabincruiseren': ('cabincruiser',),
'cabincruiserer': ('cabincruiser',),
'cabincruiserne': ('cabincruiser',),
'cabincruiser': ('cabincruiser',),
'cabincruisere': ('cabincruiser',),
'cabincruiseren': ('cabincruiser',),
'cabincruiserer': ('cabincruiser',),
'cabincruiserne': ('cabincruiser',),
'caddie': ('caddie',),
'caddien': ('caddie',),
'caddiene': ('caddie',),
'caddier': ('caddie',),
'californier': ('californier',),
'californiere': ('californier',),
'californieren': ('californier',),
'californierer': ('californier',),
'californierne': ('californier',),
'californium': ('californium',),
'californiuma': ('californium',),
'californiumene': ('californium',),
'californiumet': ('californium',),
'calling': ('calling',),
'callingen': ('calling',),
'callingene': ('calling',),
'callinger': ('calling',),
'calvados': ('calvados',),
'calvadosen': ('calvados',),
'calvadosene': ('calvados',),
'calvadoser': ('calvados',),
'calypso': ('calypso',),
'calypsoen': ('calypso',),
'calypsoene': ('calypso',),
'calypsoer': ('calypso',),
'calypsoorkester': ('calypsoorkester',),
'calypsoorkesteret': ('calypsoorkester',),
'calypsoorkestra': ('calypsoorkester',),
'calypsoorkestre': ('calypsoorkester',),
'calypsoorkestrene': ('calypsoorkester',),
'calypsoorkestret': ('calypsoorkester',),
'calypsotakt': ('calypsotakt',),
'calypsotakta': ('calypsotakt',),
'calypsotakten': ('calypsotakt',),
'calypsotaktene': ('calypsotakt',),
'calypsotakter': ('calypsotakt',),
'cambric': ('cambric',),
'cambricen': ('cambric',),
'cambricene': ('cambric',),
'cambricer': ('cambric',),
'camembert': ('camembert',),
'camemberten': ('camembert',),
'camembertene': ('camembert',),
'camemberter': ('camembert',),
'camorra': ('camorra',),
'camorraen': ('camorra',),
'camorraene': ('camorra',),
'camorraer': ('camorra',),
'camp': ('camp',),
'campen': ('camp',),
'campene': ('camp',),
'camper': ('camp',),
'camper': ('camper',),
'campere': ('camper',),
'camperen': ('camper',),
'camperer': ('camper',),
'camperne': ('camper',),
'camping': ('camping',),
'campingen': ('camping',),
'campingene': ('camping',),
'campinger': ('camping',),
'campinghytta': ('campinghytte',),
'campinghytte': ('campinghytte',),
'campinghytten': ('campinghytte',),
'campinghyttene': ('campinghytte',),
'campinghytter': ('campinghytte',),
'campingplass': ('campingplass',),
'campingplassen': ('campingplass',),
'campingplassene': ('campingplass',),
'campingplasser': ('campingplass',),
'campingutstyr': ('campingutstyr',),
'campingutstyra': ('campingutstyr',),
'campingutstyrene': ('campingutstyr',),
'campingutstyret': ('campingutstyr',),
'campingvogn': ('campingvogn',),
'campingvogna': ('campingvogn',),
'campingvognen': ('campingvogn',),
'campingvognene': ('campingvogn',),
'campingvogner': ('campingvogn',),
'campus': ('campus',),
'campusen': ('campus',),
'campusene': ('campus',),
'campuser': ('campus',),
'canadier': ('canadier',),
'canadiere': ('canadier',),
'canadieren': ('canadier',),
'canadierer': ('canadier',),
'canadierne': ('canadier',),
'canasta': ('canasta',),
'canastaen': ('canasta',),
'canastaene': ('canasta',),
'canastaer': ('canasta',),
'cancan': ('cancan',),
'cancanen': ('cancan',),
'cancanene': ('cancan',),
'cancaner': ('cancan',),
'cancer': ('cancer',),
'canceren': ('cancer',),
'cancerene': ('cancer',),
'cancerer': ('cancer',),
'cand.mag.-eksamen': ('cand.mag.-eksamen',),
'cand.mag.-eksamenen': ('cand.mag.-eksamen',),
'cand.mag.-eksamenene': ('cand.mag.-eksamen',),
'cand.mag.-eksamener': ('cand.mag.-eksamen',),
'candela': ('candela',),
'candelaen': ('candela',),
'candelaene': ('candela',),
'cannabis': ('cannabis',),
'cannabisen': ('cannabis',),
'cannabisene': ('cannabis',),
'cannabiser': ('cannabis',),
'cannabisplanta': ('cannabisplante',),
'cannabisplante': ('cannabisplante',),
'cannabisplanten': ('cannabisplante',),
'cannabisplantene': ('cannabisplante',),
'cannabisplanter': ('cannabisplante',),
'cannabisstoff': ('cannabisstoff',),
'cannabisstoffa': ('cannabisstoff',),
'cannabisstoffene': ('cannabisstoff',),
'cannabisstoffer': ('cannabisstoff',),
'cannabisstoffet': ('cannabisstoff',),
'canvass': ('canvass',),
'canvassen': ('canvass',),
'canvassene': ('canvass',),
'canvasser': ('canvass',),
'canvassing': ('canvassing',),
'canvassinga': ('canvassing',),
'canvassingen': ('canvassing',),
'canvassingene': ('canvassing',),
'canvassinger': ('canvassing',),
'canyon': ('canyon',),
'canyonen': ('canyon',),
'canyonene': ('canyon',),
'canyoner': ('canyon',),
'cape': ('cape',),
'capen': ('cape',),
'capene': ('cape',),
'caper': ('cape',),
'cappuccino': ('cappuccino',),
'cappuccinoen': ('cappuccino',),
'cappuccinoene': ('cappuccino',),
'cappuccinoer': ('cappuccino',),
'capriccio': ('capriccio',),
'capriccioen': ('capriccio',),
'capriccioene': ('capriccio',),
'capriccioer': ('capriccio',),
'caravan': ('caravan',),
'caravanen': ('caravan',),
'caravanene': ('caravan',),
'caravaner': ('caravan',),
'cardigan': ('cardigan',),
'cardiganen': ('cardigan',),
'cardiganene': ('cardigan',),
'cardiganer': ('cardigan',),
'cargo': ('cargo',),
'cargoen': ('cargo',),
'cargoene': ('cargo',),
'cargoer': ('cargo',),
'cargoliner': ('cargoliner',),
'cargolinere': ('cargoliner',),
'cargolineren': ('cargoliner',),
'cargolinerer': ('cargoliner',),
'cargolinerne': ('cargoliner',),
'carnet': ('carnet',),
'carneta': ('carnet',),
'carneten': ('carnet',),
'carnetene': ('carnet',),
'carneter': ('carnet',),
'carnetet': ('carnet',),
'carport': ('carport',),
'carporten': ('carport',),
'carportene': ('carport',),
'carporter': ('carport',),
'carrier': ('carrier',),
'carriere': ('carrier',),
'carrieren': ('carrier',),
'carrierer': ('carrier',),
'carrierne': ('carrier',),
'carte blanche': ('carte blanche',),
'casanova': ('casanova',),
'casanovaen': ('casanova',),
'casanovaene': ('casanova',),
'casanovaer': ('casanova',),
'case': ('case',),
'casen': ('case',),
'casene': ('case',),
'caser': ('case',),
'case study': ('case study',),
'cash and carry': ('cash and carry',),
'casting': ('casting',),
'castingen': ('casting',),
'castingene': ('casting',),
'castinger': ('casting',),
'catering': ('catering',),
'cateringen': ('catering',),
'cateringene': ('catering',),
'cateringer': ('catering',),
'caterpillar': ('caterpillar',),
'caterpillaren': ('caterpillar',),
'caterpillarene': ('caterpillar',),
'caterpillarer': ('caterpillar',),
'catgut': ('catgut',),
'catguten': ('catgut',),
'catgutene': ('catgut',),
'catguter': ('catgut',),
'celebritet': ('celebritet',),
'celebriteten': ('celebritet',),
'celebritetene': ('celebritet',),
'celebriteter': ('celebritet',),
'celesta': ('celesta',),
'celestaen': ('celesta',),
'celestaene': ('celesta',),
'celestaer': ('celesta',),
'cella': ('celle',),
'celle': ('celle',),
'cellen': ('celle',),
'cellene': ('celle',),
'celler': ('celle',),
'cellebiologi': ('cellebiologi',),
'cellebiologien': ('cellebiologi',),
'cellebiologiene': ('cellebiologi',),
'cellebiologier': ('cellebiologi',),
'cellebro': ('cellebro',),
'cellebroa': ('cellebro',),
'cellebroen': ('cellebro',),
'cellebroene': ('cellebro',),
'cellebroer': ('cellebro',),
'cellebru': ('cellebru',),
'cellebrua': ('cellebru',),
'cellebruen': ('cellebru',),
'cellebruene': ('cellebru',),
'cellebruer': ('cellebru',),
'celledeling': ('celledeling',),
'celledelinga': ('celledeling',),
'celledelingen': ('celledeling',),
'celledelingene': ('celledeling',),
'celledelinger': ('celledeling',),
'cellegift': ('cellegift',),
'cellegifta': ('cellegift',),
'cellegiften': ('cellegift',),
'cellegiftene': ('cellegift',),
'cellegifter': ('cellegift',),
'cellekjerne': ('cellekjerne',),
'cellekjernen': ('cellekjerne',),
'cellekjernene': ('cellekjerne',),
'cellekjerner': ('cellekjerne',),
'cellekultur': ('cellekultur',),
'cellekulturen': ('cellekultur',),
'cellekulturene': ('cellekultur',),
'cellekulturer': ('cellekultur',),
'cellelæra': ('cellelære',),
'cellelære': ('cellelære',),
'cellelæren': ('cellelære',),
'cellelærene': ('cellelære',),
'cellelærer': ('cellelære',),
'cellemembran': ('cellemembran',),
'cellemembranen': ('cellemembran',),
'cellemembranene': ('cellemembran',),
'cellemembraner': ('cellemembran',),
'cellestoff': ('cellestoff',),
'cellestoffa': ('cellestoff',),
'cellestoffene': ('cellestoff',),
'cellestoffer': ('cellestoff',),
'cellestoffet': ('cellestoff',),
'cellevev': ('cellevev',),
'celleveva': ('cellevev',),
'cellevevene': ('cellevev',),
'cellevevet': ('cellevev',),
'cellist': ('cellist',),
'cellisten': ('cellist',),
'cellistene': ('cellist',),
'cellister': ('cellist',),
'cello': ('cello',),
'celloen': ('cello',),
'celloene': ('cello',),
'celloer': ('cello',),
'cellofan': ('cellofan',),
'cellofanen': ('cellofan',),
'cellofanene': ('cellofan',),
'cellofaner': ('cellofan',),
'cellularpatologi': ('cellularpatologi',),
'cellularpatologien': ('cellularpatologi',),
'cellularpatologiene': ('cellularpatologi',),
'cellularpatologier': ('cellularpatologi',),
'cellull': ('cellull',),
'cellulla': ('cellull',),
'cellullen': ('cellull',),
'cellullene': ('cellull',),
'celluller': ('cellull',),
'celluloid': ('celluloid',),
'celluloiden': ('celluloid',),
'celluloidene': ('celluloid',),
'celluloider': ('celluloid',),
'cellulose': ('cellulose',),
'cellulosen': ('cellulose',),
'cellulosene': ('cellulose',),
'celluloser': ('cellulose',),
'cellulosefabrikk': ('cellulosefabrikk',),
'cellulosefabrikken': ('cellulosefabrikk',),
'cellulosefabrikkene': ('cellulosefabrikk',),
'cellulosefabrikker': ('cellulosefabrikk',),
'cellulosefilm': ('cellulosefilm',),
'cellulosefilmen': ('cellulosefilm',),
'cellulosefilmene': ('cellulosefilm',),
'cellulosefilmer': ('cellulosefilm',),
'celluloselakk': ('celluloselakk',),
'celluloselakken': ('celluloselakk',),
'celluloselakkene': ('celluloselakk',),
'celluloselakker': ('celluloselakk',),
'celluloselim': ('celluloselim',),
'celluloselima': ('celluloselim',),
'celluloselimene': ('celluloselim',),
'celluloselimet': ('celluloselim',),
'cellulosemasse': ('cellulosemasse',),
'cellulosemassen': ('cellulosemasse',),
'cellulosemassene': ('cellulosemasse',),
'cellulosemasser': ('cellulosemasse',),
'cellulosenitrat': ('cellulosenitrat',),
'cellulosenitrata': ('cellulosenitrat',),
'cellulosenitratene': ('cellulosenitrat',),
'cellulosenitrater': ('cellulosenitrat',),
'cellulosenitratet': ('cellulosenitrat',),
'cellulosepapp': ('cellulosepapp',),
'cellulosepappen': ('cellulosepapp',),
'cellulosepappene': ('cellulosepapp',),
'cellulosepapper': ('cellulosepapp',),
'cellulosevatt': ('cellulosevatt',),
'cellulosevatta': ('cellulosevatt',),
'cellulosevatten': ('cellulosevatt',),
'cellulosevattene': ('cellulosevatt',),
'cellulosevatter': ('cellulosevatt',),
'cellulosevattet': ('cellulosevatt',),
'celsius': ('celsius',),
'celsiusgrad': ('celsiusgrad',),
'celsiusgraden': ('celsiusgrad',),
'celsiusgradene': ('celsiusgrad',),
'celsiusgrader': ('celsiusgrad',),
'celsiusskala': ('celsiusskala',),
'celsiusskalaen': ('celsiusskala',),
'celsiusskalaene': ('celsiusskala',),
'celsiusskalaer': ('celsiusskala',),
'celsiustermometer': ('celsiustermometer',),
'celsiustermometeret': ('celsiustermometer',),
'celsiustermometra': ('celsiustermometer',),
'celsiustermometre': ('celsiustermometer',),
'celsiustermometrene': ('celsiustermometer',),
'celsiustermometret': ('celsiustermometer',),
'cembalist': ('cembalist',),
'cembalisten': ('cembalist',),
'cembalistene': ('cembalist',),
'cembalister': ('cembalist',),
'cembalo': ('cembalo',),
'cembaloen': ('cembalo',),
'cembaloene': ('cembalo',),
'cembaloer': ('cembalo',),
'cent': ('cent',),
'centen': ('cent',),
'centene': ('cent',),
'centavo': ('centavo',),
'centavoen': ('centavo',),
'centavoene': ('centavo',),
'centavos': ('centavo',),
'centesimi': ('centesimo',),
'centesimiene': ('centesimo',),
'centesimo': ('centesimo',),
'centesimoen': ('centesimo',),
'centigram': ('centigram',),
'centigramma': ('centigram',),
'centigrammene': ('centigram',),
'centigrammet': ('centigram',),
'centime': ('centime',),
'centimen': ('centime',),
'centimene': ('centime',),
'centimes': ('centime',),
'centimeter': ('centimeter',),
'centimeteren': ('centimeter',),
'centimeterne': ('centimeter',),
'centimo': ('centimo',),
'centimoen': ('centimo',),
'centimoene': ('centimo',),
'centimos': ('centimo',),
'cereal': ('cereal',),
'cereala': ('cereal',),
'cerealene': ('cereal',),
'cerealer': ('cereal',),
'cerealet': ('cereal',),
'cerebral parese': ('cerebral parese',),
'cerebral paresen': ('cerebral parese',),
'cerebral paresene': ('cerebral parese',),
'cerebral pareser': ('cerebral parese',),
'cerebral parese-pasient': ('cerebral parese-pasient',),
'cerebral parese-pasienten': ('cerebral parese-pasient',),
'cerebral parese-pasientene': ('cerebral parese-pasient',),
'cerebral parese-pasienter': ('cerebral parese-pasient',),
'cerebralparetiker': ('cerebralparetiker',),
'cerebralparetikere': ('cerebralparetiker',),
'cerebralparetikeren': ('cerebralparetiker',),
'cerebralparetikerer': ('cerebralparetiker',),
'cerebralparetikerne': ('cerebralparetiker',),
'cerise': ('cerise',),
'cerisen': ('cerise',),
'cerisene': ('cerise',),
'ceriser': ('cerise',),
'cerium': ('cerium',),
'ceriuma': ('cerium',),
'ceriumene': ('cerium',),
'ceriumet': ('cerium',),
'certeparti': ('certeparti',),
'certepartia': ('certeparti',),
'certepartiene': ('certeparti',),
'certepartier': ('certeparti',),
'certepartiet': ('certeparti',),
'cesium': ('cesium',),
'cesiuma': ('cesium',),
'cesiumene': ('cesium',),
'cesiumet': ('cesium',),
'cess': ('cess',),
'cessen': ('cess',),
'cessene': ('cess',),
'cesser': ('cess',),
'cesur': ('cesur',),
'cesuren': ('cesur',),
'cesurene': ('cesur',),
'cesurer': ('cesur',),
'ceyloner': ('ceyloner',),
'ceylonere': ('ceyloner',),
'ceyloneren': ('ceyloner',),
'ceylonerer': ('ceyloner',),
'ceylonerne': ('ceyloner',),
'cha-cha-cha': ('cha-cha-cha',),
'cha-cha-chaen': ('cha-cha-cha',),
'cha-cha-chaene': ('cha-cha-cha',),
'cha-cha-chaer': ('cha-cha-cha',),
'chablis': ('chablis',),
'chablisen': ('chablis',),
'chablisene': ('chablis',),
'chabliser': ('chablis',),
'chaconne': ('chaconne',),
'chaconnen': ('chaconne',),
'chaconnene': ('chaconne',),
'chaconner': ('chaconne',),
'chamotte': ('chamotte',),
'chamotten': ('chamotte',),
'chamottene': ('chamotte',),
'chamotter': ('chamotte',),
'chamottestein': ('chamottestein',),
'chamottesteinen': ('chamottestein',),
'chamottesteinene': ('chamottestein',),
'chamottesteiner': ('chamottestein',),
'champagne': ('champagne',),
'champagnen': ('champagne',),
'champagnene': ('champagne',),
'champagner': ('champagne',),
'champagneglas': ('champagneglas',),
'champagneglasa': ('champagneglas',),
'champagneglasene': ('champagneglas',),
'champagneglaset': ('champagneglas',),
'champagneglass': ('champagneglass',),
'champagneglassa': ('champagneglass',),
'champagneglassene': ('champagneglass',),
'champagneglasset': ('champagneglass',),
'champion': ('champion',),
'championen': ('champion',),
'championene': ('champion',),
'championer': ('champion',),
'championat': ('championat',),
'championata': ('championat',),
'championatene': ('championat',),
'championatet': ('championat',),
'chargé d\'affaires': ('chargé d\'affaires',),
'chargé d\'affairesen': ('chargé d\'affaires',),
'chargés d\'affaires': ('chargé d\'affaires',),
'charleston': ('charleston',),
'charlestonen': ('charleston',),
'charlestonene': ('charleston',),
'charlestoner': ('charleston',),
'charmeuse': ('charmeuse',),
'charmeusen': ('charmeuse',),
'charmeusene': ('charmeuse',),
'charmeuser': ('charmeuse',),
'charter': ('charter',),
'charteret': ('charter',),
'chartra': ('charter',),
'chartre': ('charter',),
'chartrene': ('charter',),
'chartret': ('charter',),
'charterfly': ('charterfly',),
'charterflya': ('charterfly',),
'charterflyene': ('charterfly',),
'charterflyet': ('charterfly',),
'charterreisa': ('charterreise',),
'charterreise': ('charterreise',),
'charterreisen': ('charterreise',),
'charterreisene': ('charterreise',),
'charterreiser': ('charterreise',),
'chartertur': ('chartertur',),
'charterturen': ('chartertur',),
'charterturene': ('chartertur',),
'charterturer': ('chartertur',),
'chartreuse': ('chartreuse',),
'chartreusen': ('chartreuse',),
'chartreusene': ('chartreuse',),
'chartreuser': ('chartreuse',),
'chassis': ('chassis',),
'chassisa': ('chassis',),
'chassisene': ('chassis',),
'chassiser': ('chassis',),
'chassiset': ('chassis',),
'chassisnummer': ('chassisnummer',),
'chassisnummeret': ('chassisnummer',),
'chassisnumra': ('chassisnummer',),
'chassisnumre': ('chassisnummer',),
'chassisnumrene': ('chassisnummer',),
'chateau': ('chateau',),
'chateaua': ('chateau',),
'chateauene': ('chateau',),
'chateauer': ('chateau',),
'chateauet': ('chateau',),
'chateaubriand': ('chateaubriand',),
'chateaubrianden': ('chateaubriand',),
'chateaubriandene': ('chateaubriand',),
'chateaubriander': ('chateaubriand',),
'chateauvin': ('chateauvin',),
'chateauvinen': ('chateauvin',),
'chateauvinene': ('chateauvin',),
'chateauviner': ('chateauvin',),
'chausseen': ('chaussé',),
'chausseene': ('chaussé',),
'chausseer': ('chaussé',),
'chaussé': ('chaussé',),
'chausséen': ('chaussé',),
'chausséene': ('chaussé',),
'chausséer': ('chaussé',),
'cheddar': ('cheddar',),
'cheddaren': ('cheddar',),
'cheddarene': ('cheddar',),
'cheddarer': ('cheddar',),
'cheddarost': ('cheddarost',),
'cheddarosten': ('cheddarost',),
'cheddarostene': ('cheddarost',),
'cheddaroster': ('cheddarost',),
'chemise': ('chemise',),
'chemisen': ('chemise',),
'chemisene': ('chemise',),
'chemiser': ('chemise',),
'chenille': ('chenille',),
'chenillen': ('chenille',),
'chenillene': ('chenille',),
'cheniller': ('chenille',),
'chenillefrynsa': ('chenillefrynse',),
'chenillefrynse': ('chenillefrynse',),
'chenillefrynsen': ('chenillefrynse',),
'chenillefrynsene': ('chenillefrynse',),
'chenillefrynser': ('chenillefrynse',),
'chenillegarn': ('chenillegarn',),
'chenillegarna': ('chenillegarn',),
'chenillegarnene': ('chenillegarn',),
'chenillegarnet': ('chenillegarn',),
'chenillegenser': ('chenillegenser',),
'chenillegensere': ('chenillegenser',),
'chenillegenseren': ('chenillegenser',),
'chenillegenserer': ('chenillegenser',),
'chenillegenserne': ('chenillegenser',),
'chianti': ('chianti',),
'chiantien': ('chianti',),
'chiantiene': ('chianti',),
'chiantier': ('chianti',),
'chief': ('chief',),
'chiefen': ('chief',),
'chiefene': ('chief',),
'chiefer': ('chief',),
'chiffer': ('chiffer',),
'chifferet': ('chiffer',),
'chifra': ('chiffer',),
'chifre': ('chiffer',),
'chifrene': ('chiffer',),
'chifferskrift': ('chifferskrift',),
'chifferskrifta': ('chifferskrift',),
'chifferskriften': ('chifferskrift',),
'chifferskriftene': ('chifferskrift',),
'chifferskrifter': ('chifferskrift',),
'chiffersystem': ('chiffersystem',),
'chiffersystema': ('chiffersystem',),
'chiffersystemene': ('chiffersystem',),
'chiffersystemer': ('chiffersystem',),
'chiffersystemet': ('chiffersystem',),
'chiffertekst': ('chiffertekst',),
'chifferteksta': ('chiffertekst',),
'chifferteksten': ('chiffertekst',),
'chiffertekstene': ('chiffertekst',),
'chiffertekster': ('chiffertekst',),
'chiffertelegram': ('chiffertelegram',),
'chiffertelegramma': ('chiffertelegram',),
'chiffertelegrammene': ('chiffertelegram',),
'chiffertelegrammer': ('chiffertelegram',),
'chiffertelegrammet': ('chiffertelegram',),
'chiffon': ('chiffon',),
'chiffonen': ('chiffon',),
'chiffonene': ('chiffon',),
'chiffoner': ('chiffon',),
'chiffonskjerf': ('chiffonskjerf',),
'chiffonskjerfa': ('chiffonskjerf',),
'chiffonskjerfene': ('chiffonskjerf',),
'chiffonskjerfet': ('chiffonskjerf',),
'chihuahua': ('chihuahua',),
'chihuahuaen': ('chihuahua',),
'chihuahuaene': ('chihuahua',),
'chihuahuaer': ('chihuahua',),
'chilener': ('chilener',),
'chilenere': ('chilener',),
'chileneren': ('chilener',),
'chilenerer': ('chilener',),
'chilenerne': ('chilener',),
'chilesalpeter': ('chilesalpeter',),
'chilesalpetere': ('chilesalpeter',),
'chilesalpeteren': ('chilesalpeter',),
'chilesalpeterer': ('chilesalpeter',),
'chilesalpeterne': ('chilesalpeter',),
'chilesalpetre': ('chilesalpeter',),
'chilesalpetrene': ('chilesalpeter',),
'chilesalpetrer': ('chilesalpeter',),
'chilipepper': ('chilipepper',),
'chilipeppere': ('chilipepper',),
'chilipepperen': ('chilipepper',),
'chilipepperer': ('chilipepper',),
'chilipepperne': ('chilipepper',),
'chilipeprene': ('chilipepper',),
'chilipeprer': ('chilipepper',),
'chinchilla': ('chinchilla',),
'chinchillaen': ('chinchilla',),
'chinchillaene': ('chinchilla',),
'chinchillaer': ('chinchilla',),
'chinchillakanin': ('chinchillakanin',),
'chinchillakaninen': ('chinchillakanin',),
'chinchillakaninene': ('chinchillakanin',),
'chinchillakaniner': ('chinchillakanin',),
'chippendale': ('chippendale',),
'chips': ('chips',),
'chipsen': ('chips',),
'chipsene': ('chips',),
'choke': ('choke',),
'choken': ('choke',),
'chokene': ('choke',),
'choker': ('choke',),
'chomageforsikring': ('chomageforsikring',),
'chomageforsikringa': ('chomageforsikring',),
'chomageforsikringen': ('chomageforsikring',),
'chomageforsikringene': ('chomageforsikring',),
'chomageforsikringer': ('chomageforsikring',),
'chow-chow': ('chow-chow',),
'chow-chowen': ('chow-chow',),
'chow-chowene': ('chow-chow',),
'chow-chower': ('chow-chow',),
'chuck': ('chuck',),
'chucken': ('chuck',),
'chuckene': ('chuck',),
'chucker': ('chuck',),
'chutney': ('chutney',),
'chutneyen': ('chutney',),
'chutneyene': ('chutney',),
'chutneyer': ('chutney',),
'cicero': ('cicero',),
'ciceroen': ('cicero',),
'ciceroene': ('cicero',),
'cicerone': ('cicerone',),
'ciceronen': ('cicerone',),
'ciceronene': ('cicerone',),
'ciceroner': ('cicerone',),
'cinemascopa': ('cinemascope',),
'cinemascope': ('cinemascope',),
'cinemascopene': ('cinemascope',),
'cinemascoper': ('cinemascope',),
'cinemascopet': ('cinemascope',),
'cinematek': ('cinematek',),
'cinemateka': ('cinematek',),
'cinematekene': ('cinematek',),
'cinemateker': ('cinematek',),
'cinemateket': ('cinematek',),
'cirkapris': ('cirkapris',),
'cirkaprisen': ('cirkapris',),
'cirkaprisene': ('cirkapris',),
'cirkapriser': ('cirkapris',),
'cirkatal': ('cirkatal',),
'cirkatala': ('cirkatal',),
'cirkatalene': ('cirkatal',),
'cirkatalet': ('cirkatal',),
'cirkatall': ('cirkatall',),
'cirkatalla': ('cirkatall',),
'cirkatallene': ('cirkatall',),
'cirkatallet': ('cirkatall',),
'cirkumfleks': ('cirkumfleks',),
'cirkumfleksen': ('cirkumfleks',),
'cirkumfleksene': ('cirkumfleks',),
'cirkumflekser': ('cirkumfleks',),
'cirrussky': ('cirrussky',),
'cirrusskya': ('cirrussky',),
'cirrusskyen': ('cirrussky',),
'cirrusskyene': ('cirrussky',),
'cirrusskyer': ('cirrussky',),
'ciss': ('ciss',),
'cissen': ('ciss',),
'cissene': ('ciss',),
'cisser': ('ciss',),
'ciss-moll': ('ciss-moll',),
'ciss-mollen': ('ciss-moll',),
'ciss-mollene': ('ciss-moll',),
'ciss-moller': ('ciss-moll',),
'cistercienser': ('cistercienser',),
'cisterciensere': ('cistercienser',),
'cistercienseren': ('cistercienser',),
'cistercienserer': ('cistercienser',),
'cistercienserne': ('cistercienser',),
'cisterciensermunk': ('cisterciensermunk',),
'cisterciensermunken': ('cisterciensermunk',),
'cisterciensermunkene': ('cisterciensermunk',),
'cisterciensermunker': ('cisterciensermunk',),
'cisterciensernonna': ('cisterciensernonne',),
'cisterciensernonne': ('cisterciensernonne',),
'cisterciensernonnen': ('cisterciensernonne',),
'cisterciensernonnene': ('cisterciensernonne',),
'cisterciensernonner': ('cisterciensernonne',),
'cistercienserorden': ('cistercienserorden',),
'cistercienserordenen': ('cistercienserorden',),
'cistercienserordenene': ('cistercienserorden',),
'cistercienserordener': ('cistercienserorden',),
'cisterna': ('cisterne',),
'cisterne': ('cisterne',),
'cisternen': ('cisterne',),
'cisternene': ('cisterne',),
'cisterner': ('cisterne',),
'citadell': ('citadell',),
'citadella': ('citadell',),
'citadellene': ('citadell',),
'citadeller': ('citadell',),
'citadellet': ('citadell',),
'citer': ('citer',),
'citere': ('citer',),
'citeren': ('citer',),
'citerer': ('citer',),
'citerne': ('citer',),
'city': ('city',),
'cityen': ('city',),
'cityene': ('city',),
'cityer': ('city',),
'clairobscur': ('clairobscur',),
'clairobscura': ('clairobscur',),
'clairobscurene': ('clairobscur',),
'clairobscuret': ('clairobscur',),
'clairvoyance': ('clairvoyance',),
'clairvoyancen': ('clairvoyance',),
'clairvoyancene': ('clairvoyance',),
'clairvoyancer': ('clairvoyance',),
'clearing': ('clearing',),
'clearingen': ('clearing',),
'clearingene': ('clearing',),
'clearinger': ('clearing',),
'clearingkonti': ('clearingkonto',),
'clearingkontiene': ('clearingkonto',),
'clearingkonto': ('clearingkonto',),
'clearingkontoen': ('clearingkonto',),
'clearingkontoene': ('clearingkonto',),
'clearingkontoer': ('clearingkonto',),
'clinch': ('clinch',),
'clinchen': ('clinch',),
'clinchene': ('clinch',),
'clincher': ('clinch',),
'close race': ('close race',),
'clou': ('clou',),
'cloua': ('clou',),
'clouen': ('clou',),
'clouene': ('clou',),
'clouet': ('clou',),
'clutch': ('clutch',),
'clutchen': ('clutch',),
'clutchene': ('clutch',),
'clutcher': ('clutch',),
'clutchpedal': ('clutchpedal',),
'clutchpedalen': ('clutchpedal',),
'clutchpedalene': ('clutchpedal',),
'clutchpedaler': ('clutchpedal',),
'cocker spaniel': ('cocker spaniel',),
'cocker spanielen': ('cocker spaniel',),
'cocker spanielene': ('cocker spaniel',),
'cocker spanieler': ('cocker spaniel',),
'cockney': ('cockney',),
'cockneyen': ('cockney',),
'cockneyene': ('cockney',),
'cockneyer': ('cockney',),
'cockpit': ('cockpit',),
'cockpiten': ('cockpit',),
'cockpitene': ('cockpit',),
'cockpiter': ('cockpit',),
'cocktail': ('cocktail',),
'cocktailen': ('cocktail',),
'cocktailene': ('cocktail',),
'cocktailer': ('cocktail',),
'cocktailbær': ('cocktailbær',),
'cocktailbæra': ('cocktailbær',),
'cocktailbærene': ('cocktailbær',),
'cocktailbæret': ('cocktailbær',),
'cocktailkjole': ('cocktailkjole',),
'cocktailkjolen': ('cocktailkjole',),
'cocktailkjolene': ('cocktailkjole',),
'cocktailkjoler': ('cocktailkjole',),
'cocktailselskap': ('cocktailselskap',),
'cocktailselskapa': ('cocktailselskap',),
'cocktailselskapene': ('cocktailselskap',),
'cocktailselskaper': ('cocktailselskap',),
'cocktailselskapet': ('cocktailselskap',),
'coil': ('coil',),
'coilen': ('coil',),
'coilene': ('coil',),
'coiler': ('coil',),
'coitus interruptus': ('coitus interruptus',),
'collage': ('collage',),
'collagen': ('collage',),
'collagene': ('collage',),
'collager': ('collage',),
'collega': ('college',),
'college': ('college',),
'collegene': ('college',),
'colleger': ('college',),
'colleget': ('college',),
'collegegenser': ('collegegenser',),
'collegegensere': ('collegegenser',),
'collegegenseren': ('collegegenser',),
'collegegenserer': ('collegegenser',),
'collegegenserne': ('collegegenser',),
'collie': ('collie',),
'collien': ('collie',),
'colliene': ('collie',),
'collier': ('collie',),
'collier': ('collier',),
'colliera': ('collier',),
'collierene': ('collier',),
'collierer': ('collier',),
'collieret': ('collier',),
'colombianer': ('colombianer',),
'colombianere': ('colombianer',),
'colombianeren': ('colombianer',),
'colombianerer': ('colombianer',),
'colombianerne': ('colombianer',),
'coloradobille': ('coloradobille',),
'coloradobillen': ('coloradobille',),
'coloradobillene': ('coloradobille',),
'coloradobiller': ('coloradobille',),
'coltpistol': ('coltpistol',),
'coltpistolen': ('coltpistol',),
'coltpistolene': ('coltpistol',),
'coltpistoler': ('coltpistol',),
'columbi egg': ('columbi egg',),
'columbi egga': ('columbi egg',),
'columbi eggene': ('columbi egg',),
'columbi egget': ('columbi egg',),
'comeback': ('comeback',),
'comebacka': ('comeback',),
'comebacken': ('comeback',),
'comebackene': ('comeback',),
'comebacket': ('comeback',),
'commando': ('commando',),
'commandoen': ('commando',),
'commandoene': ('commando',),
'commandoer': ('commando',),
'commandoløp': ('commandoløp',),
'commandoløpa': ('commandoløp',),
'commandoløpene': ('commandoløp',),
'commandoløpet': ('commandoløp',),
'commandoraid': ('commandoraid',),
'commandoraida': ('commandoraid',),
'commandoraidene': ('commandoraid',),
'commandoraidet': ('commandoraid',),
'commandosoldat': ('commandosoldat',),
'commandosoldaten': ('commandosoldat',),
'commandosoldatene': ('commandosoldat',),
'commandosoldater': ('commandosoldat',),
'commandotropp': ('commandotropp',),
'commandotroppen': ('commandotropp',),
'commandotroppene': ('commandotropp',),
'commandotropper': ('commandotropp',),
'commedia dell\'arte': ('commedia dell\'arte',),
'computertomografi': ('computertomografi',),
'computertomografien': ('computertomografi',),
'computertomografiene': ('computertomografi',),
'computertomografier': ('computertomografi',),
'conga': ('conga',),
'congaen': ('conga',),
'congaene': ('conga',),
'congaer': ('conga',),
'congatromma': ('congatromme',),
'congatromme': ('congatromme',),
'congatrommen': ('congatromme',),
'congatrommene': ('congatromme',),
'congatrommer': ('congatromme',),
'consommeen': ('consommé',),
'consommeene': ('consommé',),
'consommeer': ('consommé',),
'consommé': ('consommé',),
'consomméen': ('consommé',),
'consomméene': ('consommé',),
'consomméer': ('consommé',),
'container': ('container',),
'containere': ('container',),
'containeren': ('container',),
'containerer': ('container',),
'containerne': ('container',),
'containerhamn': ('containerhamn',),
'containerhamna': ('containerhamn',),
'containerhamnen': ('containerhamn',),
'containerhamnene': ('containerhamn',),
'containerhamner': ('containerhamn',),
'containerhavn': ('containerhavn',),
'containerhavna': ('containerhavn',),
'containerhavnen': ('containerhavn',),
'containerhavnene': ('containerhavn',),
'containerhavner': ('containerhavn',),
'containerskip': ('containerskip',),
'containerskipa': ('containerskip',),
'containerskipene': ('containerskip',),
'containerskipet': ('containerskip',),
'copyright': ('copyright',),
'copyrighten': ('copyright',),
'copyrightene': ('copyright',),
'copyrighter': ('copyright',),
'copyrightmerka': ('copyrightmerke',),
'copyrightmerke': ('copyrightmerke',),
'copyrightmerkene': ('copyrightmerke',),
'copyrightmerker': ('copyrightmerke',),
'copyrightmerket': ('copyrightmerke',),
'copyrightsida': ('copyrightside',),
'copyrightside': ('copyrightside',),
'copyrightsiden': ('copyrightside',),
'copyrightsidene': ('copyrightside',),
'copyrightsider': ('copyrightside',),
'corner': ('corner',),
'cornere': ('corner',),
'corneren': ('corner',),
'cornerer': ('corner',),
'cornerne': ('corner',),
'cornflakes': ('cornflakes',),
'cornflakesen': ('cornflakes',),
'cornflakesene': ('cornflakes',),
'cornflakeser': ('cornflakes',),
'corps de ballet': ('corps de ballet',),
'corps diplomatique': ('corps diplomatique',),
'corsicaner': ('corsicaner',),
'corsicanere': ('corsicaner',),
'corsicaneren': ('corsicaner',),
'corsicanerer': ('corsicaner',),
'corsicanerne': ('corsicaner',),
'cosinus': ('cosinus',),
'cosinusen': ('cosinus',),
'cosinusene': ('cosinus',),
'cosinuser': ('cosinus',),
'costaricaner': ('costaricaner',),
'costaricanere': ('costaricaner',),
'costaricaneren': ('costaricaner',),
'costaricanerer': ('costaricaner',),
'costaricanerne': ('costaricaner',),
'cotangens': ('cotangens',),
'cotangensen': ('cotangens',),
'cotangensene': ('cotangens',),
'cotangenser': ('cotangens',),
'cottage cheese': ('cottage cheese',),
'cottage cheese-en': ('cottage cheese',),
'cottage cheese-ene': ('cottage cheese',),
'cottage cheese-er': ('cottage cheese',),
'coulomb': ('coulomb',),
'coulomben': ('coulomb',),
'coulombene': ('coulomb',),
'coulombmeter': ('coulombmeter',),
'coulombmeteret': ('coulombmeter',),
'coulombmetra': ('coulombmeter',),
'coulombmetre': ('coulombmeter',),
'coulombmetrene': ('coulombmeter',),
'coulombmetret': ('coulombmeter',),
'coulometer': ('coulometer',),
'coulometeret': ('coulometer',),
'coulometra': ('coulometer',),
'coulometre': ('coulometer',),
'coulometrene': ('coulometer',),
'coulometret': ('coulometer',),
'country and western': ('country and western',),
'countrymusikk': ('countrymusikk',),
'countrymusikken': ('countrymusikk',),
'countrymusikkene': ('countrymusikk',),
'countrymusikker': ('countrymusikk',),
'couronne': ('couronne',),
'couronnen': ('couronne',),
'couronnene': ('couronne',),
'couronner': ('couronne',),
'couscous': ('couscous',),
'couscousen': ('couscous',),
'couscousene': ('couscous',),
'couscouser': ('couscous',),
'cover': ('cover',),
'covera': ('cover',),
'coveret': ('cover',),
'coverne': ('cover',),
'cover charge': ('cover charge',),
'cover chargen': ('cover charge',),
'cover chargene': ('cover charge',),
'cover charger': ('cover charge',),
'coverversjon': ('coverversjon',),
'coverversjonen': ('coverversjon',),
'coverversjonene': ('coverversjon',),
'coverversjoner': ('coverversjon',),
'cowboy': ('cowboy',),
'cowboyen': ('cowboy',),
'cowboyene': ('cowboy',),
'cowboyer': ('cowboy',),
'cowboyfilm': ('cowboyfilm',),
'cowboyfilmen': ('cowboyfilm',),
'cowboyfilmene': ('cowboyfilm',),
'cowboyfilmer': ('cowboyfilm',),
'cowboyhatt': ('cowboyhatt',),
'cowboyhatten': ('cowboyhatt',),
'cowboyhattene': ('cowboyhatt',),
'cowboyhatter': ('cowboyhatt',),
'cox': ('cox',),
'coxen': ('cox',),
'coxene': ('cox',),
'coxer': ('cox',),
'coyote': ('coyote',),
'coyoten': ('coyote',),
'coyotene': ('coyote',),
'coyoter': ('coyote',),
'crêpe': ('crêpe',),
'crêpen': ('crêpe',),
'crêpene': ('crêpe',),
'crêper': ('crêpe',),
'crêpe de chine': ('crêpe de chine',),
'crêpe georgette': ('crêpe georgette',),
'crêpe georgetten': ('crêpe georgette',),
'crêpe georgettene': ('crêpe georgette',),
'crêpe georgetter': ('crêpe georgette',),
'crazyfilm': ('crazyfilm',),
'crazyfilmen': ('crazyfilm',),
'crazyfilmene': ('crazyfilm',),
'crazyfilmer': ('crazyfilm',),
'crazyhumor': ('crazyhumor',),
'crazyhumoren': ('crazyhumor',),
'crazyhumorene': ('crazyhumor',),
'crazyhumorer': ('crazyhumor',),
'crazykomedie': ('crazykomedie',),
'crazykomedien': ('crazykomedie',),
'crazykomediene': ('crazykomedie',),
'crazykomedier': ('crazykomedie',),
'credo': ('credo',),
'credoa': ('credo',),
'credoene': ('credo',),
'credoet': ('credo',),
'crescendo': ('crescendo',),
'crescendoa': ('crescendo',),
'crescendoen': ('crescendo',),
'crescendoene': ('crescendo',),
'crescendoer': ('crescendo',),
'crescendoet': ('crescendo',),
'cricket': ('cricket',),
'cricketen': ('cricket',),
'cricketene': ('cricket',),
'cricketer': ('cricket',),
'crimplena': ('crimplene',),
'crimplene': ('crimplene',),
'crimplenene': ('crimplene',),
'crimplener': ('crimplene',),
'crimplenet': ('crimplene',),
'cross': ('cross',),
'crossa': ('cross',),
'crossene': ('cross',),
'crosser': ('cross',),
'crosset': ('cross',),
'crossball': ('crossball',),
'crossballen': ('crossball',),
'crossballene': ('crossball',),
'crossballer': ('crossball',),
'croupier': ('croupier',),
'croupieren': ('croupier',),
'croupierene': ('croupier',),
'croupierer': ('croupier',),
'cruisa': ('cruise',),
'cruise': ('cruise',),
'cruisene': ('cruise',),
'cruiset': ('cruise',),
'cruisefart': ('cruisefart',),
'cruisefarten': ('cruisefart',),
'cruisefartene': ('cruisefart',),
'cruisefarter': ('cruisefart',),
'cruiser': ('cruiser',),
'cruisere': ('cruiser',),
'cruiseren': ('cruiser',),
'cruiserer': ('cruiser',),
'cruiserne': ('cruiser',),
'cruiservekt': ('cruiservekt',),
'cruiservekta': ('cruiservekt',),
'cruiservekten': ('cruiservekt',),
'cruiservektene': ('cruiservekt',),
'cruiservekter': ('cruiservekt',),
'cruiseskip': ('cruiseskip',),
'cruiseskipa': ('cruiseskip',),
'cruiseskipene': ('cruiseskip',),
'cruiseskipet': ('cruiseskip',),
'cruzeiro': ('cruzeiro',),
'cruzeiroen': ('cruzeiro',),
'cruzeiroene': ('cruzeiro',),
'cruzeiros': ('cruzeiro',),
'csardas': ('csardas',),
'csardasen': ('csardas',),
'csardasene': ('csardas',),
'csardaser': ('csardas',),
'cubaner': ('cubaner',),
'cubanere': ('cubaner',),
'cubaneren': ('cubaner',),
'cubanerer': ('cubaner',),
'cubanerne': ('cubaner',),
'cup': ('cup',),
'cupen': ('cup',),
'cupene': ('cup',),
'cuper': ('cup',),
'cupfinale': ('cupfinale',),
'cupfinalen': ('cupfinale',),
'cupfinalene': ('cupfinale',),
'cupfinaler': ('cupfinale',),
'cupkamp': ('cupkamp',),
'cupkampen': ('cupkamp',),
'cupkampene': ('cupkamp',),
'cupkamper': ('cupkamp',),
'cupmester': ('cupmester',),
'cupmestere': ('cupmester',),
'cupmesteren': ('cupmester',),
'cupmesterer': ('cupmester',),
'cupmesterne': ('cupmester',),
'cupmestre': ('cupmester',),
'cupmestrene': ('cupmester',),
'cupmestrer': ('cupmester',),
'cupmesterskap': ('cupmesterskap',),
'cupmesterskapa': ('cupmesterskap',),
'cupmesterskapene': ('cupmesterskap',),
'cupmesterskaper': ('cupmesterskap',),
'cupmesterskapet': ('cupmesterskap',),
'curaçao': ('curaçao',),
'curaçaoen': ('curaçao',),
'curaçaoene': ('curaçao',),
'curaçaoer': ('curaçao',),
'curare': ('curare',),
'curaren': ('curare',),
'curarene': ('curare',),
'curarer': ('curare',),
'curie': ('curie',),
'curieen': ('curie',),
'curieene': ('curie',),
'curium': ('curium',),
'curiuma': ('curium',),
'curiumene': ('curium',),
'curiumet': ('curium',),
'curler': ('curler',),
'curlere': ('curler',),
'curleren': ('curler',),
'curlerer': ('curler',),
'curlerne': ('curler',),
'curling': ('curling',),
'curlingen': ('curling',),
'curlingene': ('curling',),
'curlinger': ('curling',),
'cyan': ('cyan',),
'cyana': ('cyan',),
'cyanene': ('cyan',),
'cyanet': ('cyan',),
'cyanamid': ('cyanamid',),
'cyanamida': ('cyanamid',),
'cyanamidene': ('cyanamid',),
'cyanamider': ('cyanamid',),
'cyanamidet': ('cyanamid',),
'cyanid': ('cyanid',),
'cyanida': ('cyanid',),
'cyanidene': ('cyanid',),
'cyanider': ('cyanid',),
'cyanidet': ('cyanid',),
'cyanin': ('cyanin',),
'cyanina': ('cyanin',),
'cyaninene': ('cyanin',),
'cyaniner': ('cyanin',),
'cyaninet': ('cyanin',),
'cyanose': ('cyanose',),
'cyanosen': ('cyanose',),
'cyanosene': ('cyanose',),
'cyanoser': ('cyanose',),
'cyclostyle': ('cyclostyle',),
'cyclostylen': ('cyclostyle',),
'cyclostylene': ('cyclostyle',),
'cyclostyler': ('cyclostyle',),
'cykel': ('cykel',),
'cykelen': ('cykel',),
'cyklene': ('cykel',),
'cykler': ('cykel',),
'cyklamat': ('cyklamat',),
'cyklamata': ('cyklamat',),
'cyklamatene': ('cyklamat',),
'cyklamatet': ('cyklamat',),
'cymbal': ('cymbal',),
'cymbalen': ('cymbal',),
'cymbalene': ('cymbal',),
'cymbaler': ('cymbal',),
'cymbel': ('cymbel',),
'cymbelen': ('cymbel',),
'cymblene': ('cymbel',),
'cymbler': ('cymbel',),
'cyste': ('cyste',),
'cysten': ('cyste',),
'cystene': ('cyste',),
'cyster': ('cyste',),
'cytolog': ('cytolog',),
'cytologen': ('cytolog',),
'cytologene': ('cytolog',),
'cytologer': ('cytolog',),
'cytologi': ('cytologi',),
'cytologien': ('cytologi',),
'cytologiene': ('cytologi',),
'cytologier': ('cytologi',),
'cytoplasma': ('cytoplasma',),
'cytoplasmaene': ('cytoplasma',),
'cytoplasmaer': ('cytoplasma',),
'cytoplasmaet': ('cytoplasma',),
'cæsarisme': ('cæsarisme',),
'cæsarismen': ('cæsarisme',),
'cæsarismene': ('cæsarisme',),
'cæsarismer': ('cæsarisme',),
'cøliaker': ('cøliaker',),
'cøliakere': ('cøliaker',),
'cøliakeren': ('cøliaker',),
'cøliakerer': ('cøliaker',),
'cøliakerne': ('cøliaker',),
'cøliaki': ('cøliaki',),
'cøliakien': ('cøliaki',),
'cøliakiene': ('cøliaki',),
'cøliakier': ('cøliaki',),
'd': ('d',),
'd\'en': ('d',),
'd-en': ('d',),
'd-ene': ('d',),
'd-er': ('d',),
'déjà vu': ('déjà vu',),
'démarche': ('démarche',),
'démarchen': ('démarche',),
'démarchene': ('démarche',),
'démarcher': ('démarche',),
'düsseldorferskole': ('düsseldorferskole',),
'düsseldorferskolen': ('düsseldorferskole',),
'düsseldorferskolene': ('düsseldorferskole',),
'düsseldorferskoler': ('düsseldorferskole',),
'düsseldorfskole': ('düsseldorfskole',),
'düsseldorfskolen': ('düsseldorfskole',),
'düsseldorfskolene': ('düsseldorfskole',),
'düsseldorfskoler': ('düsseldorfskole',),
'd-moll': ('d-moll',),
'd-mollen': ('d-moll',),
'd-mollene': ('d-moll',),
'd-moller': ('d-moll',),
'dachs': ('dachs',),
'dachsen': ('dachs',),
'dachsene': ('dachs',),
'dachser': ('dachs',),
'dachshund': ('dachshund',),
'dachshunden': ('dachshund',),
'dachshundene': ('dachshund',),
'dachshunder': ('dachshund',),
'dadaisme': ('dadaisme',),
'dadaismen': ('dadaisme',),
'dadaismene': ('dadaisme',),
'dadaismer': ('dadaisme',),
'dadaist': ('dadaist',),
'dadaisten': ('dadaist',),
'dadaistene': ('dadaist',),
'dadaister': ('dadaist',),
'dadda': ('dadda',),
'daddaen': ('dadda',),
'daddaene': ('dadda',),
'daddaer': ('dadda',),
'daddelpalme': ('daddelpalme',),
'daddelpalmen': ('daddelpalme',),
'daddelpalmene': ('daddelpalme',),
'daddelpalmer': ('daddelpalme',),
'dag': ('dag',),
'dagen': ('dag',),
'dagene': ('dag',),
'dager': ('dag',),
'dagarbeid': ('dagarbeid',),
'dagarbeida': ('dagarbeid',),
'dagarbeidene': ('dagarbeid',),
'dagarbeider': ('dagarbeid',),
'dagarbeidet': ('dagarbeid',),
'dagbarn': ('dagbarn',),
'dagbarna': ('dagbarn',),
'dagbarnene': ('dagbarn',),
'dagbarnet': ('dagbarn',),
'dagbergart': ('dagbergart',),
'dagbergarta': ('dagbergart',),
'dagbergarten': ('dagbergart',),
'dagbergartene': ('dagbergart',),
'dagbergarter': ('dagbergart',),
'dagblad': ('dagblad',),
'dagblada': ('dagblad',),
'dagbladene': ('dagblad',),
'dagblader': ('dagblad',),
'dagbladet': ('dagblad',),
'dagbok': ('dagbok',),
'dagboka': ('dagbok',),
'dagboken': ('dagbok',),
'dagbøkene': ('dagbok',),
'dagbøker': ('dagbok',),
'dagboksforfatter': ('dagboksforfatter',),
'dagboksforfattere': ('dagboksforfatter',),
'dagboksforfatteren': ('dagboksforfatter',),
'dagboksforfatterer': ('dagboksforfatter',),
'dagboksforfatterne': ('dagboksforfatter',),
'dagboksopptegnelse': ('dagboksopptegnelse',),
'dagboksopptegnelsen': ('dagboksopptegnelse',),
'dagboksopptegnelsene': ('dagboksopptegnelse',),
'dagboksopptegnelser': ('dagboksopptegnelse',),
'dagbrott': ('dagbrott',),
'dagbrotta': ('dagbrott',),
'dagbrottene': ('dagbrott',),
'dagbrottet': ('dagbrott',),
'dagbrottsdrift': ('dagbrottsdrift',),
'dagbrottsdrifta': ('dagbrottsdrift',),
'dagbrottsdriften': ('dagbrottsdrift',),
'dagbrottsdriftene': ('dagbrottsdrift',),
'dagbrottsdrifter': ('dagbrottsdrift',),
'dagbrudd': ('dagbrudd',),
'dagbrudda': ('dagbrudd',),
'dagbruddene': ('dagbrudd',),
'dagbruddet': ('dagbrudd',),
'dagbruddsdrift': ('dagbruddsdrift',),
'dagbruddsdrifta': ('dagbruddsdrift',),
'dagbruddsdriften': ('dagbruddsdrift',),
'dagbruddsdriftene': ('dagbruddsdrift',),
'dagbruddsdrifter': ('dagbruddsdrift',),
'dagdriver': ('dagdriver',),
'dagdrivere': ('dagdriver',),
'dagdriveren': ('dagdriver',),
'dagdriverer': ('dagdriver',),
'dagdriverne': ('dagdriver',),
'dagdriverliv': ('dagdriverliv',),
'dagdriverliva': ('dagdriverliv',),
'dagdriverlivene': ('dagdriverliv',),
'dagdriverlivet': ('dagdriverliv',),
'dagdrøm': ('dagdrøm',),
'dagdrømmen': ('dagdrøm',),
'dagdrømmene': ('dagdrøm',),
'dagdrømmer': ('dagdrøm',),
'daggry': ('daggry',),
'daggrya': ('daggry',),
'daggryene': ('daggry',),
'daggryet': ('daggry',),
'dagheim': ('dagheim',),
'dagheimen': ('dagheim',),
'dagheimene': ('dagheim',),
'dagheimer': ('dagheim',),
'dagheimplass': ('dagheimplass',),
'dagheimplassen': ('dagheimplass',),
'dagheimplassene': ('dagheimplass',),
'dagheimplasser': ('dagheimplass',),
'dagheimsplass': ('dagheimsplass',),
'dagheimsplassen': ('dagheimsplass',),
'dagheimsplassene': ('dagheimsplass',),
'dagheimsplasser': ('dagheimsplass',),
'daghjelp': ('daghjelp',),
'daghjelpa': ('daghjelp',),
'daghjelpen': ('daghjelp',),
'daghjelpene': ('daghjelp',),
'daghjelper': ('daghjelp',),
'daghjem': ('daghjem',),
'daghjemma': ('daghjem',),
'daghjemmene': ('daghjem',),
'daghjemmet': ('daghjem',),
'daghjemplass': ('daghjemplass',),
'daghjemplassen': ('daghjemplass',),
'daghjemplassene': ('daghjemplass',),
'daghjemplasser': ('daghjemplass',),
'daghjemsplass': ('daghjemsplass',),
'daghjemsplassen': ('daghjemsplass',),
'daghjemsplassene': ('daghjemsplass',),
'daghjemsplasser': ('daghjemsplass',),
'dagleier': ('dagleier',),
'dagleiere': ('dagleier',),
'dagleieren': ('dagleier',),
'dagleierer': ('dagleier',),
'dagleierne': ('dagleier',),
'dagligliv': ('dagligliv',),
'dagligliva': ('dagligliv',),
'dagliglivene': ('dagligliv',),
'dagliglivet': ('dagligliv',),
'dagligstova': ('dagligstove',),
'dagligstove': ('dagligstove',),
'dagligstoven': ('dagligstove',),
'dagligstovene': ('dagligstove',),
'dagligstover': ('dagligstove',),
'dagligstua': ('dagligstue',),
'dagligstue': ('dagligstue',),
'dagligstuen': ('dagligstue',),
'dagligstuene': ('dagligstue',),
'dagligstuer': ('dagligstue',),
'dagligtale': ('dagligtale',),
'dagligtalen': ('dagligtale',),
'dagligtalene': ('dagligtale',),
'dagligtaler': ('dagligtale',),
'dagligvara': ('dagligvare',),
'dagligvare': ('dagligvare',),
'dagligvaren': ('dagligvare',),
'dagligvarene': ('dagligvare',),
'dagligvarer': ('dagligvare',),
'dagligvareforretning': ('dagligvareforretning',),
'dagligvareforretninga': ('dagligvareforretning',),
'dagligvareforretningen': ('dagligvareforretning',),
'dagligvareforretningene': ('dagligvareforretning',),
'dagligvareforretninger': ('dagligvareforretning',),
'dagligvarehandel': ('dagligvarehandel',),
'dagligvarehandelen': ('dagligvarehandel',),
'dagligvarehandlene': ('dagligvarehandel',),
'dagligvarehandler': ('dagligvarehandel',),
'daglønn': ('daglønn',),
'daglønna': ('daglønn',),
'daglønnen': ('daglønn',),
'daglønnene': ('daglønn',),
'daglønner': ('daglønn',),
'daglønner': ('daglønner',),
'daglønnere': ('daglønner',),
'daglønneren': ('daglønner',),
'daglønnerer': ('daglønner',),
'daglønnerne': ('daglønner',),
'dagmamma': ('dagmamma',),
'dagmammaen': ('dagmamma',),
'dagmammaene': ('dagmamma',),
'dagmammaer': ('dagmamma',),
'dagmann': ('dagmann',),
'dagmannen': ('dagmann',),
'dagmenn': ('dagmann',),
'dagmennene': ('dagmann',),
'dagning': ('dagning',),
'dagninga': ('dagning',),
'dagningen': ('dagning',),
'dagningene': ('dagning',),
'dagninger': ('dagning',),
'dago': ('dago',),
'dagoen': ('dago',),
'dagoene': ('dago',),
'dagoer': ('dago',),
'dagpappa': ('dagpappa',),
'dagpappaen': ('dagpappa',),
'dagpappaene': ('dagpappa',),
'dagpappaer': ('dagpappa',),
'dagpendler': ('dagpendler',),
'dagpendlere': ('dagpendler',),
'dagpendleren': ('dagpendler',),
'dagpendlerer': ('dagpendler',),
'dagpendlerne': ('dagpendler',),
'dagpengene': ('dagpenger',),
'dagpenger': ('dagpenger',),
'dagsarbeid': ('dagsarbeid',),
'dagsarbeida': ('dagsarbeid',),
'dagsarbeidene': ('dagsarbeid',),
'dagsarbeider': ('dagsarbeid',),
'dagsarbeidet': ('dagsarbeid',),
'dagsavis': ('dagsavis',),
'dagsavisa': ('dagsavis',),
'dagsavisen': ('dagsavis',),
'dagsavisene': ('dagsavis',),
'dagsaviser': ('dagsavis',),
'dagsbefaling': ('dagsbefaling',),
'dagsbefalinga': ('dagsbefaling',),
'dagsbefalingen': ('dagsbefaling',),
'dagsbefalingene': ('dagsbefaling',),
'dagsbefalinger': ('dagsbefaling',),
'dagsenter': ('dagsenter',),
'dagsenteret': ('dagsenter',),
'dagsentra': ('dagsenter',),
'dagsentre': ('dagsenter',),
'dagsentrene': ('dagsenter',),
'dagsentret': ('dagsenter',),
'dagsform': ('dagsform',),
'dagsforma': ('dagsform',),
'dagsformen': ('dagsform',),
'dagsformene': ('dagsform',),
'dagsformer': ('dagsform',),
'dagsida': ('dagside',),
'dagside': ('dagside',),
'dagsiden': ('dagside',),
'dagsidene': ('dagside',),
'dagsider': ('dagside',),
'dagsjukehus': ('dagsjukehus',),
'dagsjukehusa': ('dagsjukehus',),
'dagsjukehusene': ('dagsjukehus',),
'dagsjukehuset': ('dagsjukehus',),
'dagskift': ('dagskift',),
'dagskifta': ('dagskift',),
'dagskiftene': ('dagskift',),
'dagskiftet': ('dagskift',),
'dagslys': ('dagslys',),
'dagslysa': ('dagslys',),
'dagslysene': ('dagslys',),
'dagslyset': ('dagslys',),
'dagslysskjerm': ('dagslysskjerm',),
'dagslysskjermen': ('dagslysskjerm',),
'dagslysskjermene': ('dagslysskjerm',),
'dagslysskjermer': ('dagslysskjerm',),
'dagsmarsj': ('dagsmarsj',),
'dagsmarsjen': ('dagsmarsj',),
'dagsmarsjene': ('dagsmarsj',),
'dagsmarsjer': ('dagsmarsj',),
'dagsnytt': ('dagsnytt',),
'dagsnyttsending': ('dagsnyttsending',),
'dagsnyttsendinga': ('dagsnyttsending',),
'dagsnyttsendingen': ('dagsnyttsending',),
'dagsnyttsendingene': ('dagsnyttsending',),
'dagsnyttsendinger': ('dagsnyttsending',),
'dagsommerfugl': ('dagsommerfugl',),
'dagsommerfuglen': ('dagsommerfugl',),
'dagsommerfuglene': ('dagsommerfugl',),
'dagsommerfugler': ('dagsommerfugl',),
'dagsorden': ('dagsorden',),
'dagsordenen': ('dagsorden',),
'dagsordenene': ('dagsorden',),
'dagsordener': ('dagsorden',),
'dagsordre': ('dagsordre',),
'dagsordren': ('dagsordre',),
'dagsordrene': ('dagsordre',),
'dagsordrer': ('dagsordre',),
'dagspressa': ('dagspresse',),
'dagspresse': ('dagspresse',),
'dagspressen': ('dagspresse',),
'dagspressene': ('dagspresse',),
'dagspresser': ('dagspresse',),
'dagsreisa': ('dagsreise',),
'dagsreise': ('dagsreise',),
'dagsreisen': ('dagsreise',),
'dagsreisene': ('dagsreise',),
'dagsreiser': ('dagsreise',),
'dagsrevy': ('dagsrevy',),
'dagsrevyen': ('dagsrevy',),
'dagsrevyene': ('dagsrevy',),
'dagsrevyer': ('dagsrevy',),
'dagstur': ('dagstur',),
'dagsturen': ('dagstur',),
'dagsturene': ('dagstur',),
'dagsturer': ('dagstur',),
'dagsverk': ('dagsverk',),
'dagsverka': ('dagsverk',),
'dagsverkene': ('dagsverk',),
'dagsverker': ('dagsverk',),
'dagsverket': ('dagsverk',),
'dagsvermer': ('dagsvermer',),
'dagsvermere': ('dagsvermer',),
'dagsvermeren': ('dagsvermer',),
'dagsvermerer': ('dagsvermer',),
'dagsvermerne': ('dagsvermer',),
'dagsykehus': ('dagsykehus',),
'dagsykehusa': ('dagsykehus',),
'dagsykehusene': ('dagsykehus',),
'dagsykehuset': ('dagsykehus',),
'dagtid': ('dagtid',),
'dagtida': ('dagtid',),
'dagtiden': ('dagtid',),
'dagtidene': ('dagtid',),
'dagtider': ('dagtid',),
'dagtog': ('dagtog',),
'dagtoga': ('dagtog',),
'dagtogene': ('dagtog',),
'dagtoget': ('dagtog',),
'daguerreotypi': ('daguerreotypi',),
'daguerreotypien': ('daguerreotypi',),
'daguerreotypiene': ('daguerreotypi',),
'daguerreotypier': ('daguerreotypi',),
'daguerreotypi': ('daguerreotypi',),
'daguerreotypia': ('daguerreotypi',),
'daguerreotypiene': ('daguerreotypi',),
'daguerreotypier': ('daguerreotypi',),
'daguerreotypiet': ('daguerreotypi',),
'dagvakt': ('dagvakt',),
'dagvakta': ('dagvakt',),
'dagvakten': ('dagvakt',),
'dagvaktene': ('dagvakt',),
'dagvakter': ('dagvakt',),
'dagveksel': ('dagveksel',),
'dagvekselen': ('dagveksel',),
'dagvekslene': ('dagveksel',),
'dagveksler': ('dagveksel',),
'dahlie': ('dahlie',),
'dahlien': ('dahlie',),
'dahliene': ('dahlie',),
'dahlier': ('dahlie',),
'dakapo': ('dakapo',),
'dakapoen': ('dakapo',),
'dakapoene': ('dakapo',),
'dakapoer': ('dakapo',),
'dakapo': ('dakapo',),
'dakapoa': ('dakapo',),
'dakapoene': ('dakapo',),
'dakapoer': ('dakapo',),
'dakapoet': ('dakapo',),
'dakaponummer': ('dakaponummer',),
'dakaponummeret': ('dakaponummer',),
'dakaponumra': ('dakaponummer',),
'dakaponumre': ('dakaponummer',),
'dakaponumrene': ('dakaponummer',),
'daktyl': ('daktyl',),
'daktylen': ('daktyl',),
'daktylene': ('daktyl',),
'daktyler': ('daktyl',),
'daktylene': ('daktylos',),
'daktyler': ('daktylos',),
'daktylos': ('daktylos',),
'daktylosen': ('daktylos',),
'dal': ('dal',),
'dalen': ('dal',),
'dalene': ('dal',),
'daler': ('dal',),
'dalai-lama': ('dalai-lama',),
'dalai-lamaen': ('dalai-lama',),
'dalai-lamaene': ('dalai-lama',),
'dalai-lamaer': ('dalai-lama',),
'dalasau': ('dalasau',),
'dalasauen': ('dalasau',),
'dalasauene': ('dalasau',),
'dalasauer': ('dalasau',),
'dalbotn': ('dalbotn',),
'dalbotnen': ('dalbotn',),
'dalbotnene': ('dalbotn',),
'dalbotner': ('dalbotn',),
'dalbotn': ('dalbotn',),
'dalbotnen': ('dalbotn',),
'dalbotnene': ('dalbotn',),
'dalbotner': ('dalbotn',),
'dalbu': ('dalbu',),
'dalbuen': ('dalbu',),
'dalbuene': ('dalbu',),
'dalbuer': ('dalbu',),
'dalbunn': ('dalbunn',),
'dalbunnen': ('dalbunn',),
'dalbunnene': ('dalbunn',),
'dalbunner': ('dalbunn',),
'daler': ('daler',),
'dalere': ('daler',),
'daleren': ('daler',),
'dalerer': ('daler',),
'dalerne': ('daler',),
'dalføra': ('dalføre',),
'dalføre': ('dalføre',),
'dalførene': ('dalføre',),
'dalfører': ('dalføre',),
'dalføret': ('dalføre',),
'dalgryta': ('dalgryte',),
'dalgryte': ('dalgryte',),
'dalgryten': ('dalgryte',),
'dalgrytene': ('dalgryte',),
'dalgryter': ('dalgryte',),
'dall': ('dall',),
'dallen': ('dall',),
'dallene': ('dall',),
'daller': ('dall',),
'dalmatier': ('dalmatier',),
'dalmatiere': ('dalmatier',),
'dalmatieren': ('dalmatier',),
'dalmatierer': ('dalmatier',),
'dalmatierne': ('dalmatier',),
'dalmatiner': ('dalmatiner',),
'dalmatinere': ('dalmatiner',),
'dalmatineren': ('dalmatiner',),
'dalmatinerer': ('dalmatiner',),
'dalmatinerne': ('dalmatiner',),
'dalsenkning': ('dalsenkning',),
'dalsenkninga': ('dalsenkning',),
'dalsenkningen': ('dalsenkning',),
'dalsenkningene': ('dalsenkning',),
'dalsenkninger': ('dalsenkning',),
'dalsida': ('dalside',),
'dalside': ('dalside',),
'dalsiden': ('dalside',),
'dalsidene': ('dalside',),
'dalsider': ('dalside',),
'dalstrøk': ('dalstrøk',),
'dalstrøka': ('dalstrøk',),
'dalstrøkene': ('dalstrøk',),
'dalstrøket': ('dalstrøk',),
'dalsøkk': ('dalsøkk',),
'dalsøkka': ('dalsøkk',),
'dalsøkkene': ('dalsøkk',),
'dalsøkket': ('dalsøkk',),
'dalt': ('dalt',),
'dalten': ('dalt',),
'daltene': ('dalt',),
'dalter': ('dalt',),
'dam': ('dam',),
'dammen': ('dam',),
'dammene': ('dam',),
'dammer': ('dam',),
'dam': ('dam',),
'dammen': ('dam',),
'dammene': ('dam',),
'dammer': ('dam',),
'damanlegg': ('damanlegg',),
'damanlegga': ('damanlegg',),
'damanleggene': ('damanlegg',),
'damanlegget': ('damanlegg',),
'damascenerstål': ('damascenerstål',),
'damascenerståla': ('damascenerstål',),
'damascenerstålene': ('damascenerstål',),
'damascenerstålet': ('damascenerstål',),
'damascenersverd': ('damascenersverd',),
'damascenersverda': ('damascenersverd',),
'damascenersverdene': ('damascenersverd',),
'damascenersverdet': ('damascenersverd',),
'damask': ('damask',),
'damasken': ('damask',),
'damaskene': ('damask',),
'damasker': ('damask',),
'damaskduk': ('damaskduk',),
'damaskduken': ('damaskduk',),
'damaskdukene': ('damaskduk',),
'damaskduker': ('damaskduk',),
'dambrett': ('dambrett',),
'dambretta': ('dambrett',),
'dambrettene': ('dambrett',),
'dambretter': ('dambrett',),
'dambrettet': ('dambrett',),
'dambrikka': ('dambrikke',),
'dambrikke': ('dambrikke',),
'dambrikken': ('dambrikke',),
'dambrikkene': ('dambrikke',),
'dambrikker': ('dambrikke',),
'dama': ('dame',),
'dame': ('dame',),
'damen': ('dame',),
'damene': ('dame',),
'damer': ('dame',),
'damebekjentskap': ('damebekjentskap',),
'damebekjentskapa': ('damebekjentskap',),
'damebekjentskapene': ('damebekjentskap',),
'damebekjentskaper': ('damebekjentskap',),
'damebekjentskapet': ('damebekjentskap',),
'damebind': ('damebind',),
'damebinda': ('damebind',),
'damebindene': ('damebind',),
'damebindet': ('damebind',),
'damefotball': ('damefotball',),
'damefotballen': ('damefotball',),
'damefotballene': ('damefotball',),
'damefotballer': ('damefotball',),
'damefrisør': ('damefrisør',),
'damefrisøren': ('damefrisør',),
'damefrisørene': ('damefrisør',),
'damefrisører': ('damefrisør',),
'damejeanne': ('damejeanne',),
'damejeannen': ('damejeanne',),
'damejeannene': ('damejeanne',),
'damejeanner': ('damejeanne',),
'damekor': ('damekor',),
'damekora': ('damekor',),
'damekorene': ('damekor',),
'damekoret': ('damekor',),
'damelag': ('damelag',),
'damelaga': ('damelag',),
'damelagene': ('damelag',),
'damelaget': ('damelag',),
'damemenneska': ('damemenneske',),
'damemenneske': ('damemenneske',),
'damemenneskene': ('damemenneske',),
'damemennesker': ('damemenneske',),
'damemennesket': ('damemenneske',),
'damesykkel': ('damesykkel',),
'damesykkelen': ('damesykkel',),
'damesyklene': ('damesykkel',),
'damesykler': ('damesykkel',),
'dametekka': ('dametekke',),
'dametekke': ('dametekke',),
'dametekkene': ('dametekke',),
'dametekker': ('dametekke',),
'dametekket': ('dametekke',),
'dametoalett': ('dametoalett',),
'dametoaletta': ('dametoalett',),
'dametoalettene': ('dametoalett',),
'dametoaletter': ('dametoalett',),
'dametoalettet': ('dametoalett',),
'dameur': ('dameur',),
'dameura': ('dameur',),
'dameurene': ('dameur',),
'dameuret': ('dameur',),
'damfisk': ('damfisk',),
'damfisken': ('damfisk',),
'damfiskene': ('damfisk',),
'damfisker': ('damfisk',),
'damkrona': ('damkrone',),
'damkrone': ('damkrone',),
'damkronen': ('damkrone',),
'damkronene': ('damkrone',),
'damkroner': ('damkrone',),
'damkultur': ('damkultur',),
'damkulturen': ('damkultur',),
'damkulturene': ('damkultur',),
'damkulturer': ('damkultur',),
'damluka': ('damluke',),
