#  tests for sos-notebook-0.21.10-py37_1 (this is a generated file);
print('===== testing package: sos-notebook-0.21.10-py37_1 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
# Test that sos kernel is installed

import jupyter_client

try:
    print(jupyter_client.kernelspec.get_kernel_spec('sos').to_dict())
except jupyter_client.kernelspec.NoSuchKernel:
    print('sos kernel was not installed')
    print('The following kernels are installed:')
    print('jupyter_client.kernelspec.find_kernel_specs()')
    print(jupyter_client.kernelspec.find_kernel_specs())

# Test that sos kernel is functional

import unittest

from sos_notebook.test_utils import sos_kernel
from ipykernel.tests.utils import execute, wait_for_idle, assemble_output

class TestSoSKernel(unittest.TestCase):
    def testKernel(self):
        with sos_kernel() as kc:
            execute(kc=kc, code='a = 1\nprint(a)')
            stdout, stderr = assemble_output(kc.iopub_channel)
            self.assertEqual(stdout.strip(), '1')

if __name__ == '__main__':
    unittest.main()
#  --- run_test.py (end) ---

print('===== sos-notebook-0.21.10-py37_1 OK =====');
print("import: 'sos_notebook'")
import sos_notebook

