# Copyright (c) 2013 Spotify AB
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.

import logging

from snakebite.commandlineparser import CommandLineParser

log = logging.getLogger(__name__)


class SnakebiteCli(object):
    def __init__(self):
        clparser = CommandLineParser()
        self.args = clparser.parse()
        self._setup_logging()
        clparser.init()
        clparser.execute()

    def _setup_logging(self):
        if self.args.debug:
            loglevel = logging.DEBUG
        else:
            loglevel = logging.INFO
        logging.basicConfig(level=loglevel)

SnakebiteCli()
