#The data was derived from twelve monthly electrical power demand
#time series from Italy and first used in the paper "Intelligent
#Icons: Integrating Lite-Weight Data Mining and Visualization into
#GUI Operating Systems". The classification task is to distinguish
#days from Oct to March (inclusive) from April to September.
@problemName ItalyPowerDemand
@timeStamps false

@classLabel true 1 2
@univariate true
@data
0.47297,-0.39603,-0.72191,-1.1564,-1.2107,-1.0478,-0.77622,-1.3193,-0.83053,0.25572,0.96179,1.1247,0.5816,0.20141,-0.23309,-0.34172,-0.66759,-0.72191,-0.45034,-0.015841,0.79885,2.2653,1.9394,1.2877:2
-1.0987,-1.1346,-1.6003,-1.7078,-1.6362,-1.457,-1.0271,-0.70462,0.47771,1.2301,1.2659,1.1226,0.76434,0.65685,0.51354,0.62103,0.72851,0.37023,0.40606,0.37023,0.0836,1.0151,0.62103,0.11943:2
-1.0294,-1.2402,-1.3455,-1.5562,-1.4772,-1.3455,-1.4509,-0.76605,0.2612,0.97237,1.1304,1.1831,0.76166,0.89335,0.89335,1.0777,1.1041,0.78799,0.62996,0.36656,0.050484,-0.054874,0.2612,-0.10755:2
0.29127,-0.3239,-0.88314,-1.1068,-1.2746,-0.65944,-0.88314,-0.49167,-1.1628,-0.3239,0.5709,0.62682,0.62682,-0.1002,-0.3239,-0.3239,-0.65944,-0.5476,-0.5476,0.40312,2.3605,2.0249,1.8012,0.90645:2
-0.81461,-1.2711,-1.5666,-1.6203,-1.6471,-1.4054,-1.0294,-0.46549,0.7967,1.4144,1.307,1.3338,1.0921,0.55501,0.68928,0.55501,0.52815,0.2596,0.12532,0.20589,0.23274,0.7967,0.2596,-0.33121:2
-1.1461,-1.4167,-1.5833,-1.5833,-1.625,-1.4584,-0.87538,-8.68E-4,0.39475,1.0194,0.97775,0.832,0.62379,0.37392,0.43639,0.5405,0.56132,0.64461,1.2901,1.3525,0.72789,0.47803,-0.021689,-0.54223:1
-0.97403,-1.0925,-1.2999,-1.4481,-1.4481,-1.2999,-1.3296,-0.70738,0.27036,1.2185,1.3074,1.4259,1.0407,0.80367,0.95181,1.0703,0.89256,0.80367,0.53701,-0.055553,-0.23332,-0.26295,0.092589,-0.26295:2
0.15976,-0.26043,-0.8382,-1.1008,-1.2059,-1.1533,-1.1533,-1.6261,-0.99577,-0.10286,0.47491,0.73753,0.73753,0.52743,-0.20791,-0.10286,-0.26043,-0.31296,0.10724,0.31733,0.73753,2.2082,2.1032,1.2102:2
-0.94792,-1.2676,-1.4807,-1.5606,-1.6139,-1.534,-1.1078,-0.25529,0.54389,1.2365,1.3431,1.3431,0.97012,0.57053,0.59717,0.73037,0.83692,0.51725,0.35741,0.19758,0.65045,0.46397,-0.095458,-0.49505:2
-0.78213,-1.0598,-1.2819,-1.4763,-1.4763,-1.4208,-1.4763,-0.83766,0.32859,1.0506,1.2727,1.2172,1.1061,0.80064,0.82841,1.0228,1.1061,0.85618,0.55073,0.18975,-0.1157,-0.087931,0.050908,-0.36561:2
0.591,-0.081517,-0.44834,-0.63176,-0.75403,-0.81517,-1.8545,-1.9156,-0.99858,-0.44834,0.71327,0.89669,0.83555,0.46872,-0.020379,-0.20379,-0.57062,-0.32607,-0.20379,-0.081517,0.77441,1.3246,2.3029,1.4469:2
-0.94847,-1.2804,-1.557,-1.5846,-1.6399,-1.5293,-1.2527,-0.42295,0.18554,0.95999,1.043,1.043,0.84936,0.71106,0.76638,0.93233,1.043,0.60043,0.43447,0.40682,0.76638,0.65574,0.13023,-0.31231:2
-0.42086,-0.9957,-1.4063,-1.4884,-1.4884,-1.3242,-0.9957,-1.5705,-0.010265,0.81093,1.1394,1.0573,1.3858,0.72881,0.56457,0.64669,0.48245,0.48245,0.15397,-0.092385,-0.50298,1.3858,1.0573,0.40033:2
-0.90972,-1.2692,-1.5328,-1.6287,-1.6287,-1.437,-1.2692,-0.33453,0.64809,1.0795,1.0315,1.0555,0.83982,0.36049,0.60016,0.50429,0.43239,0.28859,0.36049,1.415,0.93568,0.69602,0.12083,-0.3585:1
-0.89764,-1.2205,-1.4537,-1.4896,-1.5613,-1.3999,-1.1667,-0.82589,0.7347,1.0576,1.0935,1.0217,0.94996,0.64501,0.53739,0.62707,0.84233,1.0935,0.96789,0.75264,0.4477,0.10688,-0.28775,-0.57476:1
0.17739,-0.43881,-0.999,-1.2231,-1.2231,-1.2231,-1.5032,-0.94298,0.5135,1.7459,2.138,2.026,1.1857,0.28943,-0.046682,-0.046682,-0.046682,-0.27076,-0.27076,0.009336,-0.15872,-0.38279,0.56952,0.12137:2
-1.071,-1.3514,-1.5384,-1.5757,-1.5757,-1.501,-0.94015,-0.04284,0.55537,0.96663,1.0788,1.0414,0.87316,0.53667,0.63014,0.70492,0.83578,1.0601,1.0227,0.70492,0.38712,0.20018,-0.32325,-0.67844:1
-1.0254,-1.4202,-1.5957,-1.6615,-1.5957,-1.486,-1.0474,-0.10419,0.70738,0.97059,1.0145,0.97059,0.81705,0.57577,0.55384,0.64157,0.64157,0.57577,0.90478,0.97059,0.75124,0.4661,-0.038385,-0.58674:1
-0.55696,-0.86175,-1.2972,-1.4713,-1.689,-1.2972,-1.1665,-0.64404,-0.55696,-0.078011,0.61865,0.83635,0.87989,0.18324,-0.12155,-0.25218,-0.12155,1.0976,1.3588,1.4895,1.4459,1.2718,0.66219,0.27032:1
-0.94057,-1.3966,-1.5391,-1.6246,-1.7101,-1.4821,-1.1116,0.0,0.57004,1.3681,1.2826,1.2826,0.94057,0.42753,0.22802,0.68405,0.68405,0.51304,0.25652,0.39903,0.54154,0.54154,0.34203,-0.25652:2
-0.83105,-1.2198,-1.5188,-1.6085,-1.7281,-1.4889,-0.89085,-0.47222,0.7239,1.4416,1.3818,1.1425,0.90331,0.36506,0.48467,0.51458,0.42487,0.18565,0.15574,0.7538,1.0229,0.66409,-0.023673,-0.38251:1
-0.19044,-0.70301,-1.1729,-1.301,-1.4292,-1.301,-1.002,-0.57487,-0.70301,-0.14772,0.53571,0.57843,0.194,-0.062292,-0.27586,-0.31858,-0.40401,0.15128,1.6463,1.9026,1.6463,1.6036,1.0483,0.27942:1
-1.0085,-1.3532,-1.6183,-1.3797,-1.6979,-1.5918,-1.0351,-0.26622,0.71471,1.2449,1.298,1.1389,0.90029,0.50262,0.58215,0.6882,0.79425,0.29052,0.37006,0.2375,0.9268,0.52913,0.051919,-0.31925:2
-0.99558,-1.3813,-1.5742,-1.6385,-1.5956,-1.4885,-1.0384,0.16162,0.6545,1.1902,1.3188,1.0831,0.71879,0.41877,0.50449,0.56878,0.52592,0.54735,0.84736,0.99737,0.6545,0.18304,-0.1384,-0.52413:1
-0.35403,-1.1384,-1.4521,-1.6089,-1.5828,-1.4782,-1.6874,-0.79848,0.50872,1.1623,1.1885,1.0577,0.95317,0.58715,0.56101,0.69173,0.7963,0.66558,0.56101,0.45643,0.84859,0.32571,0.038127,-0.30175:2
-0.86863,-1.4191,-1.6345,-1.5149,-1.6824,-1.467,-1.0362,-0.006981,0.56745,1.1658,1.2855,1.1419,0.92647,0.39991,0.44778,0.37597,0.42384,0.28023,0.30417,1.3812,0.78286,0.47171,0.016954,-0.34207:1
-0.020367,-0.65583,-1.1446,-1.4379,-1.3402,-1.389,-0.80247,-0.4603,-0.50918,0.3218,0.51733,0.61509,0.46845,0.028514,-0.4603,-0.75359,-0.80247,-0.11813,1.3972,1.9349,1.7882,1.3483,1.0061,0.46845:1
-0.17491,-0.74549,-0.94926,-1.2753,-1.1938,-1.1123,-0.90851,-0.58246,-1.0715,-0.29718,0.23265,0.47718,0.43642,-0.011887,-0.33793,-0.4602,-0.41944,-0.093398,1.6591,2.1074,1.7406,1.5368,1.0478,0.39567:1
-0.63956,-0.96442,-1.2893,-1.4246,-1.5059,-1.4246,-1.6412,-0.69371,0.41622,1.1472,1.2284,1.4179,1.093,0.57865,0.79523,1.0118,1.0389,0.8223,0.55158,0.17258,-0.23349,-0.043991,-0.01692,-0.39592:2
-1.0897,-1.3974,-1.5422,-1.5603,-1.5965,-1.3793,-1.0716,-0.22096,0.7745,0.9736,1.046,0.8288,0.8469,0.44871,0.41252,0.52111,0.57541,1.1365,1.1184,1.0098,0.53921,0.37632,-0.14857,-0.60105:1
-0.79129,-1.2071,-1.4844,-1.6923,-1.7847,-1.5075,-1.184,-0.1444,0.57181,1.1494,1.1956,1.0801,0.89525,0.43319,0.36388,0.57181,0.47939,0.31767,0.61801,1.3342,0.73353,0.41008,-0.098189,-0.25991:1
-0.96184,-1.3469,-1.4967,-1.6251,-1.6892,-1.4753,-1.0688,0.12926,0.49295,1.1348,1.0064,0.94223,0.79247,0.17204,0.40738,0.62132,0.66411,0.92083,1.2417,0.74968,0.74968,0.38598,-0.084685,-0.66232:1
-0.018251,-0.60229,-0.89431,-1.1863,-1.3323,-1.235,-1.089,-0.65096,-0.55362,-0.018251,0.61446,0.66313,0.61446,0.079089,-0.35894,-0.50495,-0.50495,-0.60229,-0.21293,1.1498,2.0259,2.0259,1.4905,1.1012:1
-0.97254,-1.1832,-1.3939,-1.4642,-1.4642,-1.4642,-1.5578,-0.6682,0.43213,1.0642,1.1111,1.0408,1.0642,0.87695,0.80671,1.0174,1.0642,0.73648,0.5726,0.26825,0.080964,-0.012681,0.24484,-0.19997:2
-0.12519,-0.66174,-1.3056,-1.5202,-1.5202,-1.3056,-0.87636,-1.7348,-0.2325,0.84059,1.1625,1.1625,0.84059,0.62597,0.51866,0.30404,0.30404,0.41135,-0.017885,-0.017885,-0.66174,1.4844,1.4844,0.84059:2
-0.95305,-1.2705,-1.5284,-1.5879,-1.6077,-1.4093,-1.1713,-0.31823,0.85221,1.0704,1.1101,0.91172,0.91172,0.55464,0.57448,0.55464,0.6935,1.0506,1.0506,0.79269,0.35626,0.17772,-0.23888,-0.57613:1
-0.51602,-0.95571,-1.542,-1.6152,-1.6885,-1.542,-0.95571,-1.1023,0.21679,0.9496,1.3893,1.316,1.1694,0.72976,0.14351,0.5832,0.65648,0.36335,0.36335,0.14351,-0.29618,0.87632,0.9496,0.36335:2
-0.46629,-0.98507,-1.3556,-1.3556,-1.5409,-1.3927,-0.98507,-0.65157,0.42306,1.2012,1.3865,1.2383,0.60834,0.16366,-0.058672,-0.058672,-0.16984,-0.16984,-0.16984,1.3865,1.9794,0.90478,0.34894,-0.28101:1
-0.82049,-1.1717,-1.4958,-1.6038,-1.6579,-1.5498,-1.1717,-0.73946,0.58414,1.1514,1.4215,0.96231,0.85426,0.5031,0.69219,0.80024,0.88127,0.47609,0.36804,0.61115,0.36804,0.74621,0.15194,-0.36129:2
-0.83732,-1.1801,-1.4372,-1.5443,-1.63,-1.48,-1.1373,-0.43027,0.59809,1.2837,1.3908,1.198,1.0051,0.55524,0.51239,0.61951,0.55524,0.31958,0.49097,1.0694,0.68379,0.2553,-0.21603,-0.64451:1
-0.60117,-1.0125,-1.3605,-1.4871,-1.4871,-1.4238,-1.677,-0.91758,0.34805,1.1391,1.3289,1.1707,0.94922,0.69609,0.8543,1.1074,0.8543,0.72774,0.60117,0.22148,0.031641,-0.1582,0.22148,-0.12656:2
-0.71845,-1.0186,-1.4278,-1.5096,-1.5369,-1.4005,-1.5915,-0.71845,0.482,1.3278,1.3823,1.1368,1.0822,0.75482,0.70026,0.9458,0.83667,0.59113,0.40015,0.29102,-0.11823,-0.11823,0.3183,-0.090943:2
-0.63788,-1.0646,-1.4113,-1.4113,-1.438,-1.3847,-1.6247,-0.87791,0.32227,1.0424,1.2557,1.2024,1.1224,0.77567,0.80235,0.9357,1.0957,0.77567,0.72233,0.24226,-0.07779,-0.26448,0.055564,-0.1578:2
0.52579,0.071053,-0.61105,-0.9521,-1.1795,-0.9521,-0.38368,-1.6342,-1.5205,0.4121,1.0942,1.0942,1.2079,0.29842,-0.61105,-0.83842,-0.49737,-0.27,-0.042632,-0.042632,0.071053,2.2311,1.6626,0.86684:2
-0.95004,-1.2766,-1.4687,-1.5839,-1.6416,-1.4879,-1.1805,-0.29694,0.74034,1.0861,1.0861,1.0285,0.8748,0.58667,0.49063,0.62509,0.77876,0.77876,1.0285,0.93243,0.45221,0.18328,-0.29694,-0.48903:1
-0.94014,-1.2398,-1.5394,-1.5394,-1.6085,-1.4241,-1.2398,-0.68662,0.37356,1.1341,1.3185,1.1802,1.065,0.65013,0.58098,0.76536,0.78841,0.60403,0.55794,0.51184,0.32746,0.60403,0.12004,-0.36396:2
1.1843,0.4492,0.20418,-0.12251,-0.20418,0.040837,0.20418,-1.756,-1.511,-0.69422,-0.36753,-0.20418,-0.28586,-0.4492,-0.4492,-0.36753,-0.69422,-0.61255,-0.61255,-0.20418,0.20418,2.4094,2.1643,1.6743:2
-1.0971,-1.4084,-1.5419,-1.6086,-1.5863,-1.4307,-1.0749,-0.34099,0.50407,1.1935,1.2157,1.0378,0.9266,0.50407,0.54855,0.57079,0.48183,0.28169,0.37064,1.2157,0.88212,0.54855,-0.007413,-0.18532:1
0.88616,0.18392,-0.31768,-0.51832,-0.71896,-0.61864,-0.21736,-1.3209,-1.2206,-0.21736,0.18392,0.18392,0.18392,-0.418,-1.0199,-0.418,-0.31768,-0.31768,-0.31768,0.18392,-0.21736,3.2939,1.789,1.2874:2
-0.90001,-1.2265,-1.5279,-1.6535,-1.6786,-1.5028,-1.0256,-0.44791,0.55675,1.3102,1.1344,1.1847,0.83303,0.53163,0.50652,0.45628,0.53163,0.38093,0.25535,0.95861,1.034,0.60698,0.18,-0.49814:1
-0.52649,-0.8184,-1.2771,-1.4856,-1.6107,-1.4856,-1.2354,-0.69329,0.30755,1.225,1.3084,1.3918,1.0582,0.68287,0.59946,0.97478,1.1416,0.89138,0.72457,0.22415,-0.44308,-0.44308,-0.067766,-0.44308:2
-0.73976,-0.99916,-1.3738,-1.5468,-1.4603,-1.345,-1.4603,-0.62448,0.35547,1.1625,1.3931,1.4795,1.2201,0.73016,0.75898,0.75898,0.98955,0.73016,0.49958,0.1249,-0.1345,-0.1345,-0.048037,-0.33626:2
-0.73277,-1.1008,-1.39,-1.4688,-1.4951,-1.3637,-1.574,-0.65391,0.37132,1.1337,1.2651,1.1862,1.0285,0.76563,0.94965,0.97594,1.0022,0.71306,0.73935,0.21359,-0.075578,-0.15444,-0.023002,-0.31217:2
-0.63682,-1.1261,-1.414,-1.4715,-1.4715,-1.3276,-1.414,-0.69439,0.3418,1.2341,1.378,1.2341,1.1765,0.68719,1.0038,0.88867,0.97502,0.74476,0.48571,0.19788,-0.14751,-0.26264,0.025185,-0.40656:2
-0.98162,-1.3164,-1.5631,-1.5807,-1.5631,-1.3517,-1.1402,-0.31203,0.4809,0.9919,1.0448,1.08,0.95666,0.6571,0.46328,0.55138,0.86855,1.0624,1.0271,0.83331,0.46328,0.19897,-0.22393,-0.64683:1
-1.0574,-1.3837,-1.6633,-1.6167,-1.6167,-1.4536,-1.0574,-0.42821,0.52725,1.1332,1.1798,1.1098,0.87681,0.66707,0.64377,0.66707,0.78359,0.52725,0.38743,0.59716,0.34082,0.78359,0.31752,-0.26508:2
-0.066714,-0.60042,-0.97402,-1.1875,-1.6145,-1.2409,-1.8813,-1.2409,0.41363,1.6945,1.908,1.3209,1.1608,0.467,0.040028,0.093399,0.040028,-0.12008,-0.013343,0.25351,0.093399,0.25351,0.89397,0.30688:2
-0.76494,-1.2014,-1.5214,-1.6378,-1.6087,-1.4923,-1.1432,-0.64857,0.51522,1.3881,1.3008,1.2135,1.0971,0.74797,0.54431,0.77707,0.5734,0.48612,0.28246,0.16608,0.16608,0.74797,0.28246,-0.27034:2
-0.87292,-1.1823,-1.4353,-1.4916,-1.4916,-1.4635,-1.2947,-0.67607,0.84246,1.1799,1.3205,1.2361,1.0955,0.81434,0.58937,0.87058,0.92682,0.72997,0.3644,0.33628,-0.085535,-0.057414,-0.001172,-0.25426:2
-0.98813,-1.2604,-1.5327,-1.696,-1.6144,-1.451,-1.097,-0.3619,0.67275,1.4623,1.2173,1.1901,1.0267,0.67275,0.61829,0.67275,0.56384,0.45493,0.31879,0.29156,0.26433,0.69997,0.10097,-0.22576:2
-0.67649,-1.0202,-1.3904,-1.4698,-1.6549,-1.4962,-1.6284,-0.75582,0.40766,1.2274,1.3332,1.2274,1.0952,0.64564,0.6192,0.77786,0.77786,0.46054,0.4341,0.35477,0.19612,0.30189,0.53987,-0.3063:2
0.79402,0.59057,-0.29105,-0.42668,-0.4945,-0.96922,-1.3761,-2.3934,-0.96922,-0.22323,0.18367,0.59057,0.59057,0.45494,-0.4945,-0.35886,-0.56231,-0.42668,-0.35886,0.38712,0.59057,1.2687,2.3538,1.54:2
-0.77096,-1.3399,-1.612,-1.612,-1.6368,-1.5625,-1.241,-0.15254,0.73798,1.208,1.1338,1.1338,0.96061,0.49061,0.51535,0.6143,0.54009,0.29272,0.21851,0.26798,1.109,0.6143,0.39167,-0.30096:2
-0.98055,-1.1842,-1.5914,-1.6496,-1.7078,-1.5042,-0.86419,-0.39876,0.70662,1.3466,1.3175,1.143,1.0557,0.64845,0.61936,0.61936,0.67754,0.53209,0.15393,0.29938,0.15393,0.82298,0.066663,-0.28241:2
-0.98806,-1.2272,-1.5216,-1.6871,-1.5768,-1.4112,-1.1536,-0.32578,0.55727,1.1276,1.2012,1.1644,0.90681,0.57566,0.55727,0.63085,0.74123,0.74123,0.962,0.79642,0.50208,0.13414,-0.25219,-0.45455:1
-0.70835,-1.118,-1.374,-1.4508,-1.4764,-1.3996,-1.6557,-0.78515,0.44378,1.0326,1.2119,1.2119,1.0583,0.80222,0.72541,0.95584,0.95584,0.69981,0.72541,0.52059,-0.093877,-0.22189,0.18775,-0.24749:2
-0.38646,-1.1509,-1.3038,-1.5076,-1.5586,-1.3547,-1.6096,-1.2528,-0.08069,0.83663,1.1424,1.2953,1.1934,0.78567,0.53086,0.53086,0.4799,0.37797,0.17412,0.32701,0.12316,0.63278,1.2953,0.4799:2
-0.96239,-1.2514,-1.4959,-1.5626,-1.5626,-1.5181,-1.2514,-0.40663,0.43812,1.0606,1.1717,1.0383,0.90496,0.52704,0.50481,0.6382,0.79381,0.94942,1.0828,0.79381,0.48258,0.21582,-0.1621,-0.42886:1
-0.62617,-1.1476,-1.6076,-1.6689,-1.6996,-1.4236,-0.99421,-0.56483,0.87664,1.306,1.4594,1.2447,1.03,0.53927,0.72329,0.72329,0.72329,0.44727,0.17124,0.14057,0.04856,0.5086,0.1099,-0.31948:2
-0.90183,-1.2058,-1.5706,-1.6618,-1.6314,-1.5706,-1.1146,0.040532,0.8005,1.3477,1.2261,1.1653,0.8309,0.34452,0.43572,0.55731,0.49651,0.19253,0.10133,0.28372,1.2261,0.70931,0.19253,-0.29386:2
-1.1112,-1.3828,-1.531,-1.6051,-1.6051,-1.2841,-1.0125,-0.56801,0.46904,1.1851,1.2839,1.2592,1.111,0.51842,0.49373,0.76534,0.86411,0.56781,0.32089,0.34558,0.2962,0.71596,0.32089,-0.41739:2
-1.0649,-1.3944,-1.5591,-1.6298,-1.6533,-1.3709,-1.112,-0.005884,0.70015,1.312,1.3356,1.1944,0.98256,0.51187,0.48834,0.53541,0.53541,0.41773,0.25299,0.4648,0.48834,0.77075,0.22946,-0.4295:2
-0.34528,-0.94376,-1.266,-1.4962,-1.4502,-1.3581,-1.22,-0.71358,0.20717,0.94376,1.3581,1.3121,0.94376,0.16113,-0.023019,-0.16113,-0.2532,-0.20717,-0.20717,0.34528,1.9566,1.4041,0.80565,0.20717:2
-0.98413,-1.2033,-1.4468,-1.6172,-1.5442,-1.5685,-1.0815,-0.083195,1.0125,1.3047,1.4021,1.1343,0.76904,0.47685,0.4038,0.4525,0.2577,0.23335,0.2577,1.1343,0.89079,0.37945,-0.058845,-0.52149:1
-0.99607,-1.2325,-1.5477,-1.6528,-1.6266,-1.3639,-1.1537,-0.28678,0.50132,0.79029,1.1318,1.053,0.94791,0.36997,0.23862,0.18608,0.21235,0.55386,1.3682,1.342,0.79029,0.55386,0.10727,-0.28678:1
-0.84033,-1.1591,-1.5068,-1.4778,-1.5068,-1.3909,-1.4778,-0.7534,0.3767,1.1011,1.3619,1.246,1.0432,0.81135,0.84033,0.81135,0.89828,0.60852,0.40568,0.3767,0.3767,-0.057954,0.086931,-0.17386:2
-1.0095,-1.3793,-1.441,-1.5643,-1.5643,-1.4615,-1.0711,-0.37244,0.51115,1.066,1.0454,0.94267,0.67554,0.4084,0.32621,0.30566,0.57279,1.3125,1.2098,1.066,0.67554,0.34676,-0.10531,-0.49574:1
0.36402,-0.39823,-0.92593,-1.2191,-1.5123,-1.395,-1.8054,-1.0432,0.59856,1.5953,1.7712,1.8299,1.2435,0.12948,0.24675,0.012215,0.24675,-0.22232,0.12948,-0.10505,-0.16369,-0.33959,0.59856,0.36402:2
-0.98822,-1.3995,-1.5366,-1.4909,-1.6051,-1.4224,-1.171,-0.097109,0.72546,1.2281,1.251,1.1139,0.9311,0.63406,0.45127,0.47412,0.47412,0.29133,0.10853,1.2053,0.74831,0.58836,0.017137,-0.53124:1
-0.99981,-1.3811,-1.5002,-1.5955,-1.6432,-1.4049,-0.95215,-0.18964,0.52522,0.97797,0.95414,0.90648,0.66819,0.40608,0.31077,0.47757,0.38225,0.52522,1.4069,1.4307,0.88265,0.50139,-0.16581,-0.52324:1
-0.18641,-0.62192,-1.097,-1.295,-1.3742,-1.4533,-1.2158,-0.66151,-1.097,-0.18641,0.40747,0.76379,0.96175,0.36787,-0.226,-0.10723,-0.18641,-0.028044,0.60542,1.7536,1.9515,1.516,0.92216,0.48665:1
-0.87877,-1.2233,-1.5432,-1.5186,-1.5432,-1.5432,-1.2725,-0.58345,0.5732,1.2377,1.2377,1.2377,1.09,0.96695,0.77007,0.74546,0.77007,0.52398,0.3271,0.22866,0.007178,0.081006,0.30249,0.007178:2
1.1199,0.39545,-0.11169,-0.47393,-0.69128,-0.76373,-1.8505,-1.6331,-1.0535,-0.40149,0.39545,0.68524,0.54035,0.25055,-0.18414,-0.54638,-0.54638,-0.40149,-0.32904,-0.11169,0.39545,0.83014,2.4965,1.9893:2
-0.059532,-0.4961,-0.89298,-1.012,-1.1311,-1.0914,-1.0517,-1.0517,-1.4883,-0.77391,0.33735,0.41672,0.4961,-0.09922,0.059532,-0.059532,0.1786,-0.13891,0.57547,1.012,2.4011,1.8455,1.3692,0.65485:2
-0.75367,-1.1758,-1.3707,-1.4356,-1.533,-1.4356,-1.0784,-0.81862,0.4154,1.2597,1.2922,1.3896,1.0324,0.77261,0.77261,1.0324,1.0974,0.74014,0.38292,0.22055,-0.29903,-0.26656,0.025709,-0.26656:2
-0.91857,-1.2542,-1.4349,-1.4349,-1.4865,-1.3832,-1.5898,-0.58298,0.37216,1.1982,1.0692,1.1724,1.1466,0.63031,0.86264,0.99172,0.9659,0.7852,0.50124,0.21727,-0.015059,-0.092503,0.29472,-0.015059:2
0.11858,-0.58044,-1.1297,-1.2795,-1.3294,-1.2795,-1.9785,-1.0298,0.4681,1.4667,1.8162,1.8162,1.2171,0.4681,-0.031207,0.11858,0.31831,0.21845,-0.181,0.31831,-0.081137,-0.181,0.56796,0.16852:2
-1.1111,-1.3842,-1.5844,-1.5662,-1.6026,-1.4388,-1.1111,-0.2556,0.72736,0.964,1.0368,0.98221,0.78197,0.59994,0.59994,0.65455,0.65455,0.69096,1.1096,0.9458,0.58174,0.27229,-0.055368,-0.49224:1
-0.83474,-1.1255,-1.3369,-1.4691,-1.5219,-1.4162,-1.6012,-0.67616,0.38103,1.0946,1.3061,1.2268,1.0418,0.80391,0.83034,0.90963,0.8832,0.77748,0.59247,0.27531,-0.12114,-0.14757,0.27531,-0.14757:2
-0.89578,-1.1576,-1.5242,-1.629,-1.6028,-1.4719,-1.21,-0.84341,0.49208,1.1991,1.1991,1.0682,0.88487,0.57064,0.51827,0.51827,0.54445,0.80631,0.88487,0.78013,0.43971,0.6492,0.099289,-0.31969:2
0.20776,-0.36959,-0.84197,-1.1044,-1.1569,-1.2619,-1.0519,-1.4718,-0.78948,0.10279,0.57516,0.89008,1.1,0.26025,-0.42208,-0.054673,-0.47457,-0.26462,-0.15965,-0.002187,0.94257,2.2547,1.9923,1.1:2
-1.0649,-1.3625,-1.485,-1.5726,-1.5551,-1.415,-1.0299,-0.3822,0.40554,1.0707,1.1408,0.93071,0.79066,0.52808,0.5981,0.66812,0.82567,1.0883,1.0532,0.9132,0.52808,0.17797,-0.29467,-0.55726:1
-0.92662,-1.3079,-1.562,-1.6383,-1.5874,-1.5874,-1.1808,0.039183,0.82707,1.4879,1.1321,1.1066,0.82707,0.44583,0.36959,0.47125,0.44583,0.16626,0.11543,0.5475,1.0558,0.75082,0.064598,-0.06248:1
-0.42589,-0.72108,-1.3484,-1.496,-1.6067,-1.5329,-1.0532,-0.61038,-0.27829,0.016912,0.57041,0.64421,0.49661,0.090712,-0.31519,-0.16759,-0.13069,1.1239,1.3822,1.7512,1.5667,1.2715,0.42281,0.34901:1
0.11233,-0.52617,-1.0228,-1.0228,-1.3065,-1.1647,-1.3775,-1.1647,0.11233,1.6021,2.2406,1.9569,1.3184,0.3961,-0.1005,-0.24239,-0.17145,-0.38428,-0.17145,0.041384,-0.17145,0.53799,0.60893,-0.1005:2
-0.053806,-0.43643,-1.1538,-1.3452,-1.3452,-1.3452,-1.2495,-1.0104,-0.86688,-0.43643,0.56796,0.95058,0.71144,0.4723,-0.29295,-0.10163,-0.43643,0.4723,1.5723,1.668,1.5723,1.4289,0.52013,0.13751:1
-0.37159,-0.92323,-1.3829,-1.5668,-1.5668,-1.4749,-0.73935,-1.291,-0.27965,0.73169,1.3753,1.1914,1.2833,0.91557,0.27199,0.45587,0.73169,0.36393,0.18005,-0.18771,-0.55547,1.2833,1.0994,0.45587:2
-1.1309,-1.4048,-1.4469,-1.5734,-1.5101,-1.4891,-0.94121,-0.28798,0.53382,1.1028,1.0185,0.8499,0.63918,0.34417,0.36524,0.49168,0.59703,0.74454,1.2924,1.2924,0.91311,0.3231,-0.14048,-0.58299:1
-0.78154,-1.2111,-1.4688,-1.5547,-1.5547,-1.4402,-0.92472,-0.18017,0.87938,1.1657,1.2803,1.2803,0.79347,0.39256,0.020284,0.020284,0.27801,0.93665,1.2517,1.1371,0.62165,0.048921,-0.29472,-0.69563:1
-0.73917,-1.2326,-1.5241,-1.569,-1.6587,-1.5017,-1.1653,-0.44761,0.56162,1.1672,1.1896,1.1447,0.74104,0.49434,0.47191,0.60647,0.60647,0.47191,0.74104,1.2344,0.76346,0.3822,-0.1112,-0.62703:1
-0.97117,-1.3479,-1.574,-1.6242,-1.5991,-1.5237,-1.2977,-0.29303,0.48559,1.0381,1.0381,0.9628,0.83722,0.58605,0.43535,0.76187,0.73675,0.56094,0.48559,0.38512,1.0633,0.76187,0.48559,-0.39349:2
-0.73671,-1.0028,-1.4167,-1.3576,-1.4463,-1.4463,-1.6237,-0.73671,0.4164,1.126,1.2738,1.2443,1.126,0.74163,0.80077,1.0964,1.0373,0.65293,0.44597,0.3277,0.032031,-0.26364,0.002464,-0.2932:2
-0.98769,-1.2928,-1.5789,-1.5979,-1.5598,-1.3691,-1.0258,-0.2058,0.55702,1.0338,1.0147,1.0147,0.86214,0.46166,0.42352,0.57609,0.74772,1.0719,1.1482,1.0528,0.48073,0.19468,-0.32022,-0.70163:1
-0.78102,-1.2416,-1.5409,-1.5179,-1.564,-1.5179,-1.2646,-0.044136,0.80789,1.2915,1.2915,1.2915,1.1994,0.85394,0.71578,0.60064,0.64669,0.27825,0.18614,0.18614,0.4855,0.27825,-0.1823,-0.45863:2
-0.003226,-0.62253,-1.0483,-1.2031,-1.358,-1.2805,-0.97089,-1.5128,-1.0096,-0.041932,0.38384,0.61608,0.57737,0.19031,-0.11935,0.035481,-0.080639,-0.11935,0.42255,1.7773,1.816,1.545,1.4289,0.57737:1
0.97426,0.29057,-0.32475,-0.52986,-0.80334,-0.94007,-1.9656,-1.2819,-1.0768,-0.18801,0.63241,0.83752,0.63241,0.017092,-0.25638,-0.39312,-0.52986,-0.52986,-0.32475,0.017092,0.42731,0.90589,2.5467,1.8631:2
-0.1102,-0.68987,-1.3782,-1.7043,-1.5594,-1.5594,-1.1608,-0.1102,0.32455,1.0854,1.4839,1.2303,0.94045,0.21587,-0.14643,-0.14643,-0.1102,-0.21889,0.28833,1.5926,1.4114,0.72308,0.14341,-0.54495:1
-0.8217,-1.2345,-1.3616,-1.6156,-1.6156,-1.4251,-1.0758,-0.21833,0.73437,0.98842,1.2107,1.0837,0.70261,0.16275,-0.15481,-0.0913,0.099239,1.0837,1.2107,1.3377,0.92491,0.51207,0.035726,-0.47238:1
-0.86816,-1.2694,-1.5273,-1.5847,-1.5847,-1.47,-1.0115,-0.52424,0.65082,1.31,1.482,1.3387,1.0521,0.67948,0.5935,0.82278,0.5935,0.42154,0.24958,0.13494,-0.008359,0.62216,0.1636,-0.2663:2
-0.96976,-1.2823,-1.4907,-1.6157,-1.6365,-1.574,-1.1573,-0.032123,1.0097,1.0722,1.1139,0.94719,0.67632,0.38461,0.38461,0.50963,0.59297,0.48879,1.1972,1.0514,0.59297,0.3221,-0.21965,-0.36551:1
-0.46532,-0.91746,-1.3696,-1.5052,-1.5957,-1.5052,-1.234,-0.10361,0.30331,1.2076,1.3884,1.2528,0.66502,0.25809,-0.28447,-0.14883,-0.10361,-0.3749,0.032026,1.1172,1.7049,1.1172,0.48416,0.07724:1
-0.80506,-1.1529,-1.311,-1.5008,-1.5324,-1.4375,-0.9948,-0.26748,0.52309,0.93419,1.282,1.0607,0.68121,0.080375,-0.17261,-0.10936,-0.014494,0.58634,1.5034,1.6299,1.1239,0.58634,-0.20423,-0.48884:1
-0.13243,-0.91399,-1.2266,-1.4871,-1.5392,-1.4871,-1.0182,-0.39295,0.33651,1.4307,1.8996,1.5349,1.1181,0.70123,-0.23664,-0.18454,-0.13243,-0.34085,-0.18454,-0.028223,0.54492,1.3265,0.64913,-0.23664:2
-0.081478,-0.62235,-1.0384,-1.2464,-1.3296,-1.08,-0.91359,-1.3712,-0.83038,0.001734,0.75063,0.83384,0.75063,0.25137,-0.16469,-0.12308,-0.41432,-0.41432,-0.16469,1.7492,1.7908,1.7908,1.1667,0.70903:1
-1.0137,-1.3692,-1.5074,-1.5469,-1.6654,-1.4284,-1.0532,-0.046078,0.68458,1.0795,1.0005,0.86231,0.68458,0.36862,0.34887,0.46736,0.54635,1.119,1.2375,1.0598,0.64509,0.32913,-0.14482,-0.65825:1
0.010431,-0.61546,-0.99099,-1.6169,-1.7421,-1.2413,-0.74063,-1.8672,-0.49028,0.51114,0.7615,1.3874,1.0118,1.0118,0.26079,0.26079,0.010431,-0.11475,0.26079,0.13561,0.13561,1.7629,1.2622,0.63632:2
0.27547,-0.61929,-1.2158,-1.6632,-1.3649,-1.5141,-1.2158,-0.61929,-0.072493,-0.32104,0.32518,0.77256,0.67315,0.17605,-0.42046,-0.27133,-0.32104,0.17605,1.5182,1.717,1.6673,1.4188,0.72285,0.17605:1
-0.92038,-1.1829,-1.4857,-1.6069,-1.6877,-1.5059,-1.1627,-0.21369,0.53339,1.0785,0.9574,0.81606,0.71511,0.35166,0.43243,0.37186,0.69492,1.0785,1.2401,1.2199,0.65453,0.31128,-0.23388,-0.45599:1
-0.9983,-1.2737,-1.4114,-1.5261,-1.572,-1.4573,-1.2278,-0.58521,0.37867,1.113,1.2048,1.0671,0.81471,0.37867,0.49341,0.63111,0.83766,0.72291,0.92945,1.2048,0.67701,0.14917,-0.17212,-0.37867:1
-0.96812,-1.3995,-1.4583,-1.5956,-1.5956,-1.3995,-1.1642,-0.22303,0.58087,1.0122,1.2083,1.0514,0.87498,0.56126,0.48283,0.62008,0.58087,0.9338,1.0514,0.97302,0.50244,0.1299,-0.18382,-0.57597:1
-0.88814,-1.1495,-1.506,-1.5535,-1.5535,-1.506,-1.2208,-0.79308,0.41882,0.84655,0.82279,0.7515,0.79902,0.20495,0.22872,0.58516,0.96536,0.96536,1.1792,1.3931,0.79902,0.53763,-0.056437,-0.2703:1
-0.65173,-1.3662,-1.4427,-1.4427,-1.4938,-1.4427,-1.4938,-0.80483,0.29237,1.0068,1.1854,1.211,1.0068,0.6496,0.70063,0.70063,1.3385,0.75167,0.57305,0.34341,-0.013821,0.26686,0.26686,-0.1414:2
0.40066,-0.40583,-0.96418,-0.90214,-1.3364,-1.1503,-0.77806,-1.4605,-1.2123,0.33863,0.95901,1.0831,0.95901,0.4627,0.27659,0.58678,-0.65399,-0.77806,-0.65399,-0.28176,0.83493,1.9516,1.5794,1.1451:2
1.1751,0.23501,-0.12655,-0.48811,-0.70504,-0.70504,-1.5728,-1.9344,-1.2112,-0.27117,0.66889,0.52426,0.45195,0.1627,-0.12655,-0.4158,-0.48811,-0.56042,-0.27117,0.09039,0.45195,0.59658,2.3321,2.1874:2
-0.91421,-1.0958,-1.407,-1.407,-1.4848,-1.407,-1.5366,-0.65486,0.25287,1.1087,1.1606,1.3162,1.1606,0.74563,0.97905,0.90124,1.0828,0.7197,0.40848,0.25287,-0.084289,-0.21396,0.097256,0.019451:2
0.021728,-0.40493,-0.8316,-0.97382,-1.1634,-1.3057,-0.879,-1.4005,-0.78419,0.021728,0.4958,0.68543,0.4958,0.069135,-0.26271,-0.45234,-0.59456,-0.54716,0.21136,1.7758,2.0602,1.7758,1.3965,0.59061:1
-0.6916,-1.2853,-1.3886,-1.5951,-1.5435,-1.5176,-1.2853,-0.58834,0.52166,0.96049,0.98631,0.96049,0.67654,0.39259,0.28933,0.72817,0.49584,0.36677,1.2961,1.2186,1.167,0.44421,-0.072064,-0.53671:1
-0.42981,-0.94559,-1.2985,-1.3799,-1.4614,-1.3528,-1.4885,-0.70127,0.46601,1.2532,1.3618,1.6333,1.4704,0.79176,0.76462,0.90035,0.62889,0.57459,0.1674,0.14025,-0.37552,-0.40267,-0.022622,-0.29408:2
-0.20377,-0.70437,-1.3975,-1.4745,-1.6671,-1.59,-1.0124,-0.70437,0.48937,1.2595,1.375,0.98996,0.48937,0.1428,-0.24228,-0.24228,-0.20377,0.065784,1.298,1.6061,1.2595,0.6434,0.1428,-0.31929:1
0.9549,0.27723,-0.46205,-0.70848,-0.83169,-0.8933,-1.7558,-1.571,-0.9549,0.27723,0.83169,0.8933,0.8933,0.27723,-0.27723,-0.21562,-0.46205,-0.58526,-0.58526,-0.21562,-0.030803,0.8933,2.1254,2.1254:2
-1.1358,-1.4565,-1.5968,-1.6569,-1.5567,-1.4565,-0.91531,-0.37414,0.52781,0.96876,1.1291,0.94872,0.7082,0.46768,0.66811,0.54785,0.7082,0.76833,0.52781,1.2494,0.78837,0.50777,-0.053449,-0.31401:1
1.4048,0.79182,0.1788,-0.1715,-0.43422,-0.43422,-0.25908,-1.6603,-1.0472,-0.5218,0.003649,0.26637,0.1788,-0.083926,-0.8721,-0.43422,-0.69695,-1.1348,-0.8721,-0.34665,0.26637,1.4048,2.2806,2.193:2
-0.53438,-1.092,-1.5381,-1.6124,-1.7239,-1.5009,-1.0176,-0.7946,0.39497,1.25,1.2872,1.3615,1.1756,0.65519,0.76671,0.76671,0.76671,0.54367,0.2091,-0.088288,-0.12546,0.69237,0.13476,0.023234:2
0.8731,0.33234,-0.4112,-0.68158,-0.95196,-1.0196,-0.4112,-1.6279,-1.2899,-0.54639,0.12956,0.53513,0.53513,0.26475,-0.27601,-0.27601,-0.4788,-0.61399,-0.4788,-0.34361,0.67032,2.3602,2.0898,1.6166:2
-1.0865,-1.4192,-1.5301,-1.4377,-1.3822,-1.4377,-1.4007,-0.34729,0.61373,0.87246,0.90942,0.76157,0.59524,0.33651,0.41043,0.68765,0.8355,1.2606,1.2606,1.0573,0.72461,0.18866,-0.144,-0.32881:1
-0.1735,-0.99804,-1.2042,-1.4103,-1.534,-1.4515,-1.0393,-0.66822,0.15632,1.2282,1.3107,1.3107,0.69227,0.23877,-0.21472,-0.1735,-0.25595,-0.29718,0.19755,1.9703,1.3931,0.89841,0.28,-0.25595:1
-0.17239,-0.78358,-1.1597,-1.3948,-1.4888,-1.4888,-1.3478,-0.17239,0.48582,1.3321,1.6612,1.4261,0.86194,0.20373,-0.17239,-0.2194,-0.26642,-0.45448,-0.45448,0.39179,1.7552,1.097,0.43881,-0.078358:2
-1.1578,-1.3178,-1.4778,-1.5667,-1.5667,-1.46,-1.1222,-0.28667,0.35334,0.97557,1.0289,1.0822,0.90446,0.60223,0.60223,0.65557,0.83335,1.0289,1.0467,0.86891,0.46001,0.14,-0.16223,-0.46445:1
-0.94695,-1.2333,-1.4676,-1.5978,-1.6498,-1.4676,-1.1552,-0.42629,0.45883,0.90139,1.1097,0.90139,0.82329,0.4328,0.30263,0.589,0.40676,0.97949,1.3179,1.2138,0.69313,0.32867,-0.087861,-0.42629:1
-0.56349,-0.76279,-1.503,-1.4746,-1.503,-1.503,-1.7308,-0.73432,0.57535,1.2017,1.2017,1.3441,1.0594,0.68924,0.74618,0.91701,0.91701,0.71771,0.40453,0.20523,-0.02254,-0.1649,0.034403,-0.051011:2
1.0431,-0.034937,-0.75365,-0.39429,-0.99322,-0.75365,-0.51408,-1.2328,-0.51408,0.92334,1.5223,1.5223,1.0431,-0.034937,-0.87343,-1.4724,-0.39429,-0.75365,-0.63386,-0.39429,-0.63386,1.7618,1.2827,1.2827:2
-1.1149,-1.2295,-1.4588,-1.5505,-1.5046,-1.5275,-1.1607,-0.58752,0.37544,1.4989,1.1091,0.94863,0.6735,0.32958,0.37544,0.513,0.55886,0.44422,1.1779,1.155,0.62764,0.513,0.054453,-0.22068:1
-0.85666,-1.2035,-1.5007,-1.5255,-1.5007,-1.4264,-1.5007,-0.55941,0.65436,1.2489,1.2241,1.1993,0.95162,0.80299,1.0012,0.82776,0.82776,0.55528,0.2828,0.30757,-0.01445,-0.039221,0.23326,0.010321:2
-0.59915,-0.92596,-1.2528,-1.4979,-1.3889,-1.2528,-1.5523,-0.73532,0.62638,1.5523,1.6885,1.2528,1.0894,0.59915,0.65362,0.84426,0.92596,0.65362,0.27234,0.0,-0.27234,-0.35404,-0.13617,-0.19064:2
-0.98059,-1.2456,-1.5346,-1.7032,-1.5828,-1.5587,-1.1251,-0.18568,0.56105,1.1633,1.1873,1.1151,0.72967,0.29608,0.41652,0.48879,0.4647,0.32017,0.58514,1.2837,0.94646,0.60923,0.007026,-0.25794:1
-0.92842,-1.3455,-1.4772,-1.7187,-1.7187,-1.3455,-1.126,0.01555,0.67414,1.2669,1.1791,1.0254,0.84976,0.49851,0.38875,0.45461,0.45461,0.38875,0.73999,1.223,0.71804,0.4107,-0.16007,-0.46741:1
0.31562,-0.59701,-1.0533,-1.2815,-1.099,-1.2815,-0.55138,-1.3271,-0.59701,0.26999,0.63504,0.8632,0.68067,0.22435,-0.46012,-0.50575,-0.55138,-0.55138,-0.32322,1.7302,1.8671,1.8671,1.137,0.58941:1
-1.1355,-1.3928,-1.5907,-1.6105,-1.6105,-1.3334,-1.1553,-0.027213,0.70506,1.0811,1.1603,0.90297,0.8436,0.46757,0.44778,0.40819,0.56652,0.40819,1.1603,1.1009,0.6259,0.46757,-0.10638,-0.38345:1
-0.030968,-0.59932,-1.0802,-1.3426,-1.4737,-1.0802,-1.0802,-0.55561,-0.94908,-0.64304,0.10019,1.1057,0.97459,0.66855,-0.074688,-0.20585,-0.33701,-0.55561,0.36251,1.7178,1.8927,1.4555,1.1495,0.58111:1
0.80828,0.007698,-0.60813,-0.79288,-0.97763,-1.1008,-1.8398,-1.963,-0.85447,0.007698,0.62353,0.86986,0.80828,0.31561,-0.17705,-0.23863,-0.17705,-0.17705,-0.17705,0.25403,0.62353,0.7467,2.1631,1.8552:2
-0.81884,-1.2747,-1.3507,-1.6039,-1.6039,-1.5786,-1.1481,-0.74287,0.49806,1.0299,0.95391,0.77664,0.65001,0.16883,0.59936,0.52338,0.54871,0.42208,1.3844,1.4098,0.85261,0.54871,-0.008442,-0.23637:1
-1.1294,-1.3954,-1.5647,-1.613,-1.7098,-1.5163,-0.9118,-0.25893,0.51484,1.2886,1.1919,1.1435,0.92591,0.65992,0.70828,0.63574,0.75665,0.53902,0.29722,0.27304,0.39394,0.73246,0.15214,-0.11385:2
-0.83454,-1.4847,-1.6597,-1.6097,-1.6347,-1.3096,-1.0346,-0.58449,0.69076,1.1909,1.1659,1.0158,0.79078,0.49072,0.51573,0.54073,0.54073,0.31569,0.34069,1.1659,0.96581,0.59074,0.11565,-0.28443:1
-0.98381,-1.0872,-1.48,-1.5421,-1.5834,-1.3973,-1.2939,-0.32219,0.60821,1.1044,1.2698,1.0424,0.91834,0.40145,0.40145,0.50483,0.58753,1.0424,1.1458,0.95969,0.4428,0.17402,-0.34287,-0.5703:1
-0.96069,-1.315,-1.4095,-1.6458,-1.6694,-1.4095,-1.1261,-0.44097,0.4331,1.0473,1.1182,1.0001,0.7402,0.26773,0.22049,0.40947,0.64571,0.90557,1.2599,1.2127,0.71658,0.38585,-0.11024,-0.27561:1
-0.69378,-1.1622,-1.3751,-1.4177,-1.5029,-1.4603,-1.077,-0.73636,0.072749,0.88186,1.2225,1.6058,1.3077,0.88186,0.83927,0.92444,1.0522,0.71152,0.32826,0.11533,-0.3531,-0.52344,-0.012421,0.37084:2
-0.4298,-1.0147,-1.1742,-1.5198,-1.4135,-1.4401,-1.5464,-0.77541,0.42094,1.1653,1.4578,1.4046,1.1653,0.87289,0.92606,1.0324,0.79314,0.63362,0.23484,0.1285,-0.27029,-0.11077,-0.16394,-0.37663:2
-0.6093,-0.97358,-1.1817,-1.494,-1.546,-1.494,-1.6501,-0.55726,0.37946,1.056,1.3162,1.3682,1.0039,1.056,0.69169,0.89985,0.95189,0.4315,0.11926,-0.19298,-0.3491,0.84781,0.22334,-0.29706:2
-0.78337,-1.2859,-1.4459,-1.4687,-1.6286,-1.5601,-1.2174,-0.48639,0.58729,1.2498,1.1584,1.3183,1.1127,0.70151,0.61013,0.77004,0.72435,0.47307,0.42738,0.42738,0.61013,0.40453,-0.12088,-0.57777:2
-0.38381,-0.73509,-1.2425,-1.5547,-1.4377,-1.2815,-0.96928,-0.69606,0.43585,1.5678,1.4116,1.2165,0.90423,0.16263,-0.22768,-0.22768,-0.18865,-0.22768,-0.22768,1.6458,1.5287,0.90423,0.006505,-0.38381:1
0.37346,-0.047623,-0.52886,-0.76949,-1.0101,-1.1304,-1.7921,-1.8523,-0.70933,0.49377,0.91486,1.1555,0.91486,0.37346,0.43362,0.25315,-0.3484,-0.46871,-0.58902,-0.46871,0.31331,0.61408,1.9977,1.8773:2
0.18444,-0.36131,-0.84642,-0.9677,-1.089,-0.84642,-0.54322,-0.9677,-0.30067,0.48764,0.73019,0.73019,0.427,-0.058112,-0.48259,-0.78578,-0.90706,-0.72514,-0.6645,-0.058112,0.79083,2.3068,2.1855,1.7611:2
0.013716,-0.77635,-0.90803,-1.4347,-1.5664,-1.5006,-0.97387,-1.1055,-0.052122,1.133,1.6597,1.5938,1.4622,0.079555,-0.38132,-0.052122,-0.11796,-0.31548,-0.1838,0.27707,0.40875,1.5938,0.86962,0.27707:2
-0.42461,-0.98492,-1.2301,-1.4402,-1.6503,-1.4402,-1.0199,-0.66975,-0.73979,0.065662,0.55593,0.73103,0.69601,0.38084,-0.17947,-0.074416,-0.039397,0.55593,1.5015,1.6766,1.5715,1.2213,0.73103,0.20574:1
-0.72256,-0.94529,-1.2635,-1.5817,-1.5817,-1.6771,-1.3271,-0.7862,0.61384,1.3775,1.4411,1.3457,1.0593,0.45475,0.7093,0.58203,0.83658,0.42293,0.13656,0.10474,-0.086177,0.7093,0.2002,-0.022539:2
0.35757,0.0,-0.83433,-1.1919,-1.4899,-1.1919,-1.6687,-1.0131,0.59595,1.4303,2.0262,1.9666,1.3111,0.65555,0.059595,0.0,0.23838,0.11919,-0.17879,-0.059595,-0.59595,-0.53636,0.11919,-0.11919:2
-0.82688,-1.3632,-1.5992,-1.5563,-1.4061,-1.492,-1.213,-0.18325,0.58909,1.2971,1.1254,1.104,0.82509,0.56764,0.31019,0.28874,0.37455,0.3531,1.1254,1.2113,0.868,0.24583,-0.1618,-0.48361:1
-0.86429,-1.3307,-1.6744,-1.5516,-1.6989,-1.478,-1.3307,-0.029662,0.70678,1.1486,1.075,0.95225,0.58404,0.38765,0.33856,0.55949,0.58404,0.33856,0.55949,1.2959,0.92771,0.55949,0.019434,-0.078758:1
-0.8871,-1.2159,-1.6543,-1.5721,-1.7091,-1.4625,-1.1063,-0.33909,0.81175,1.3324,1.3598,1.168,1.031,0.53774,0.37334,0.67475,0.64735,0.40074,0.23633,0.20893,0.31854,0.78435,0.29113,-0.22948:2
-0.66198,-1.0718,-1.1033,-1.4816,-1.4185,-1.4816,-1.3555,-0.91416,0.31523,1.1979,1.3555,1.2609,1.1979,0.88264,1.0087,0.97721,0.94569,0.6935,0.53589,0.15761,-0.28371,-0.34675,-0.22066,-0.18914:2
1.0961,0.50422,-1.0742,-1.0742,-1.4031,-1.2715,-1.9292,-1.2715,0.30692,1.2934,1.6223,1.3592,1.3592,0.70153,0.043846,-0.087691,-0.087691,-0.41653,-0.35076,-0.35076,-0.285,-0.15346,0.9646,0.50422:2
-0.93615,-1.2613,-1.4387,-1.4092,-1.5274,-1.35,-1.2613,-0.49271,0.63067,1.1037,1.281,1.0741,0.9263,0.42373,0.068979,0.098542,0.21679,1.015,1.1037,1.2515,0.83761,0.33504,-0.1084,-0.5814:1
-0.85473,-1.307,-1.4933,-1.7061,-1.7061,-1.2538,-1.0676,-0.45563,0.74165,1.194,1.2206,0.9545,0.9279,0.5288,0.50219,0.50219,0.47559,0.34256,0.28934,1.2206,0.98111,0.63523,-0.16296,-0.50885:1
-0.61996,-0.88513,-1.2387,-1.3271,-1.5333,-1.5039,-1.769,-0.97352,0.3818,1.1478,1.2952,1.2952,1.0005,0.70589,0.76482,0.9416,1.0889,0.73536,0.44072,0.17555,-0.17801,-0.17801,0.20502,0.028236:2
-0.54884,-1.0943,-1.367,-1.4488,-1.4761,-1.3397,-1.6943,-0.73974,0.40567,1.0875,1.1693,1.3329,1.1693,0.67838,0.81474,0.86928,1.0875,0.78747,0.5693,0.35112,-0.057952,-0.35794,-0.057952,-0.13977:2
-0.90249,-1.375,-1.4496,-1.375,-1.549,-1.5242,-1.3252,-0.38027,0.51497,1.0621,1.1118,1.0123,0.61444,0.44036,0.39063,0.4155,0.4901,0.4155,1.3853,1.3605,0.76364,0.44036,-0.15646,-0.38027:1
-0.92785,-1.2531,-1.6,-1.6217,-1.535,-1.4482,-1.1881,-0.60261,0.65501,0.93689,1.0236,1.132,0.80679,0.63333,0.67669,0.72006,0.74174,0.69838,0.65501,1.1537,0.61164,0.30808,-0.12558,-0.45083:1
-1.0335,-1.2906,-1.4405,-1.6333,-1.5904,-1.5048,-1.2049,-0.17672,0.76577,1.1085,1.0657,0.89429,0.78719,0.35879,0.31595,0.35879,0.63725,0.87287,1.237,1.1085,0.59441,0.29453,-0.17672,-0.34808:1
-1.0388,-1.556,-1.4847,-1.5203,-1.5917,-1.5382,-1.0567,-0.21846,0.78023,1.1012,1.1191,1.0656,0.85157,0.47706,0.42355,0.54839,0.54839,0.90507,0.85157,0.94074,0.58406,0.24522,-0.05796,-0.37897:1
-0.84085,-1.1696,-1.5489,-1.6501,-1.4225,-1.4478,-1.1949,-0.23392,0.55003,1.1064,1.334,1.0305,0.90407,0.47416,0.34772,0.52474,0.47416,0.65118,1.2834,1.0305,0.65118,0.14541,-0.2845,-0.71441:1
-0.83973,-1.2349,-1.4819,-1.7041,-1.556,-1.5313,-1.1855,-0.49396,0.59275,1.2843,1.0126,1.062,0.88912,0.44456,0.49396,0.54335,0.51865,0.44456,0.74093,1.2843,0.74093,0.44456,-0.074093,-0.39517:1
-1.0449,-1.3185,-1.4279,-1.6103,-1.5739,-1.3368,-1.1908,-0.22419,0.90662,1.0708,0.97958,0.99781,0.83367,0.45065,0.46889,0.72423,0.81543,0.97958,1.1072,0.8519,0.39593,0.12235,-0.40657,-0.57072:1
-0.96701,-1.3627,-1.4791,-1.6188,-1.549,-1.5024,-1.1067,-0.26867,0.49951,1.1047,1.1047,0.94179,0.70901,0.26673,0.35984,0.38312,0.42967,0.4064,1.3841,1.3142,0.84868,0.45295,-0.035887,-0.31522:1
-0.31592,-0.81662,-1.0312,-1.2816,-1.5319,-1.3531,-1.21,-0.85239,-0.95968,-0.17286,0.50666,0.75702,0.75702,0.22055,-0.20863,-0.28016,-0.28016,0.93584,1.2935,1.6511,1.6869,1.222,0.90007,0.36361:1
-1.0615,-1.4047,-1.5763,-1.6989,-1.5518,-1.3802,-1.0369,-0.22782,0.5813,1.2188,1.1697,0.99812,0.77745,0.40967,0.53226,0.70389,0.55678,0.60582,0.65485,1.2188,0.63033,0.43419,-0.17878,-0.37493:1
-0.46343,-1.2412,-1.6301,-1.5134,-1.5523,-1.5523,-1.1634,-0.26898,0.23658,1.2477,1.5199,1.3644,1.0921,0.62547,0.85881,0.74214,0.78103,0.46991,0.1588,0.04213,-0.15232,0.66436,0.003241,-0.26898:2
-1.0508,-1.3295,-1.4888,-1.6281,-1.5684,-1.429,-1.1504,-0.21481,0.64112,1.0591,1.0392,0.9397,0.80036,0.30273,0.48188,0.46197,0.60131,1.1786,1.1388,0.9397,0.5615,0.34254,-0.035664,-0.59301:1
-1.0474,-1.3445,-1.4188,-1.6417,-1.716,-1.4931,-1.0721,-0.52729,0.61191,1.0824,1.3549,1.1567,0.93386,0.53761,0.6862,0.7605,0.7605,0.51285,0.21566,0.24043,0.042307,0.78526,0.53761,0.042307:2
-0.82081,-0.86345,-1.4604,-1.503,-1.5457,-1.503,-1.1193,-0.94872,0.11726,1.1832,1.2685,1.2685,1.2685,0.75685,0.9274,0.9274,1.0127,0.45837,0.45837,0.1599,-0.47969,0.24518,0.28782,-0.095938:2
-0.79079,-0.95582,-1.5334,-1.2859,-1.616,-1.3684,-0.87331,-1.2859,0.034382,0.94207,1.1071,1.3547,1.1896,1.0246,0.19942,0.612,0.94207,0.52949,0.034382,-0.048135,-0.62576,0.85955,1.1071,0.44697:2
-0.16402,-0.21651,-0.53144,-0.95134,-1.0563,-1.1088,-0.84636,-0.58392,-0.42646,-0.84636,-0.47895,-0.16402,0.1509,-0.16402,-0.6889,-0.53144,-0.58392,-0.059049,1.5156,1.883,2.0405,2.0929,1.1482,0.5708:1
0.18083,-0.3828,-0.66462,-1.2282,-1.341,-1.2282,-0.89007,-0.60825,-0.21371,-0.49553,0.63174,1.0263,0.63174,0.12447,-1.1155,-1.1719,-0.83371,0.068106,1.4772,1.6463,1.759,1.4208,0.91355,0.29356:1
-1.1252,-1.3811,-1.4992,-1.5583,-1.6173,-1.4796,-1.0859,-0.14107,0.54786,1.0203,1.0006,0.88248,0.68565,0.42976,0.44944,0.48881,0.62659,0.80375,1.1974,1.1777,0.70533,0.50849,-0.082015,-0.55442:1
-0.75408,-1.0642,-1.5152,-1.7689,-1.628,-1.628,-1.1206,-0.61313,0.37352,1.1065,1.1346,1.2756,1.0219,0.57085,0.59904,0.79637,0.9937,0.65542,0.37352,0.34533,0.59904,0.48628,-0.10571,-0.1339:2
-0.69499,-0.86635,-1.409,-1.6375,-1.4947,-1.4661,-1.6089,-0.58074,0.79019,1.39,1.3329,1.4185,0.79019,0.70451,0.67595,0.70451,0.933,0.5617,0.33321,0.10472,-0.038081,-0.095204,0.21897,-0.066643:2
0.48687,0.017126,-0.3939,-0.51133,-0.98108,-1.0398,-0.86364,-1.3921,-1.1572,-0.57005,0.31072,0.252,0.6043,-0.041592,-0.33518,-0.3939,-0.57005,-0.74621,-0.51133,0.42815,2.0722,1.9548,1.7199,1.6612:2
1.1711,0.66005,-0.055359,-0.15756,-0.46417,-0.36197,-0.15756,-1.895,-1.384,-0.56637,0.25125,-0.055359,-0.25976,-0.25976,-0.66857,-0.66857,-0.66857,-0.66857,-0.055359,-0.055359,0.14904,1.6821,2.3975,2.0909:2
-0.75759,-1.2642,-1.3486,-1.6301,-1.5175,-1.4049,-1.1516,-0.56057,0.50897,1.5222,1.4659,1.3533,1.1,0.6497,0.67784,0.81857,0.84672,0.2838,0.11493,0.058637,0.25566,0.36824,-0.082092,-0.30726:2
-1.1717,-1.4754,-1.5766,-1.5766,-1.5766,-1.4754,-1.0705,-0.037961,0.48843,1.0553,1.116,0.99457,0.67064,0.42769,0.42769,0.52892,0.46818,0.67064,1.3185,0.99457,0.58966,0.44794,-0.037961,-0.19993:1
-0.04318,-0.70643,-1.1624,-1.3282,-1.4111,-1.3282,-0.9966,-0.70643,-0.78933,-0.33335,0.78588,0.95169,0.95169,-0.001727,-0.16754,-0.2919,-0.49916,-0.33335,1.0346,1.7393,1.7393,1.4906,0.99314,0.4128:1
-0.8203,-1.0797,-1.5697,-1.5409,-1.6274,-1.5697,-1.2239,-0.47441,1.0533,1.4857,1.3704,1.1686,0.96683,0.41916,0.50563,0.59211,0.67858,0.36151,-0.042036,0.24621,0.18856,0.67858,0.24621,-0.013211:2
-0.66141,-1.4295,-1.5924,-1.5924,-1.6622,-1.5924,-1.0105,-0.17263,0.82821,1.1541,1.1541,0.89804,0.75839,0.33943,0.31616,0.50236,0.47908,0.40926,1.1773,1.1773,0.73511,0.24633,-0.12607,-0.33555:1
0.45373,-0.34185,-1.038,-1.038,-1.4855,-1.2369,-1.5352,-1.1374,0.80179,2.0449,1.8957,1.6471,1.1001,0.404,-0.093231,-0.14295,0.006215,-0.4413,-0.093231,-0.14295,-0.2424,0.10566,0.55317,-0.043508:2
-0.73731,-1.1184,-1.3907,-1.7174,-1.6357,-1.3635,-1.2546,-0.68286,0.70555,1.3589,1.495,1.2228,1.0595,0.46053,0.51498,0.89611,0.73277,0.43331,0.43331,0.079402,-0.056716,0.56943,0.10663,-0.11116:2
-1.1054,-1.4045,-1.5914,-1.5914,-1.5914,-1.3671,-1.0867,-0.26407,0.57722,1.0446,1.0446,0.98852,0.85765,0.53983,0.53983,0.44635,0.55853,1.0259,1.1007,0.98852,0.52114,0.29679,-0.1519,-0.37625:1
-0.91136,-1.3151,-1.4813,-1.6238,-1.5526,-1.4813,-1.1963,-0.12765,0.9173,1.131,1.1073,0.98855,0.79855,0.32358,0.29983,0.29983,0.44232,0.51357,1.2973,1.1785,0.67981,0.27608,-0.080152,-0.48388:1
-0.17079,-0.83999,-1.2164,-1.5092,-1.6765,-1.4674,-0.96546,-0.75634,-0.25444,-0.42174,0.24747,0.70754,0.83302,0.20564,-0.04531,-0.21261,-0.12896,0.83302,1.3767,1.7113,1.6695,1.2931,0.66572,0.12199:1
-1.2003,-1.3323,-1.634,-1.5397,-1.5586,-1.4454,-1.0872,-0.12569,0.70387,0.98667,1.0432,0.94896,0.77928,0.47762,0.40221,0.55304,0.57189,1.0809,1.0809,0.94896,0.51533,0.40221,-0.050276,-0.52162:1
-0.73981,-1.3472,-1.4874,-1.6276,-1.6276,-1.394,-1.0669,-0.13239,0.70866,1.3161,1.3862,1.1292,1.1993,0.35823,0.33486,0.33486,0.35823,0.26478,0.26478,1.246,0.77875,0.35823,-0.13239,-0.48283:1
-1.017,-1.3482,-1.4756,-1.6284,-1.6539,-1.501,-1.0424,-0.48195,0.61358,1.276,1.1996,1.1741,0.99574,0.66454,0.63906,0.63906,0.74097,0.48619,0.28237,0.15499,0.23142,0.91931,0.33333,-0.2017:2
0.54096,0.13269,-0.19393,-0.6022,-0.76551,-0.6022,-0.52054,-1.5004,-1.4187,-0.6022,-0.03062,0.13269,0.13269,-0.11227,-0.27558,-0.52054,-0.52054,-0.43889,-0.35724,0.051034,0.86757,2.5007,2.174,1.9291:2
-0.87289,-1.3261,-1.5024,-1.6535,-1.6786,-1.4268,-0.99878,0.033573,0.7386,1.5192,1.3933,1.3177,1.1163,0.4868,0.26019,0.58752,0.63788,0.31055,0.15947,0.083931,0.20983,0.71342,0.18465,-0.29376:2
-0.99658,-1.2337,-1.3654,-1.4971,-1.4444,-1.3127,-1.418,-0.73317,0.55756,1.2424,1.2951,1.2688,0.95268,0.71561,0.79463,0.92634,1.058,0.68927,0.42585,0.2678,-0.18,-0.12732,0.24146,-0.12732:2
-0.9542,-1.3606,-1.5232,-1.6451,-1.6451,-1.4622,-1.0355,-0.22267,0.75269,1.0981,1.1794,1.0981,0.75269,0.38693,0.30565,0.36661,0.54949,0.61045,1.1997,1.0981,0.65109,0.24469,-0.10075,-0.34459:1
-0.30273,-0.89756,-1.2375,-1.4924,-1.5774,-1.4499,-1.0675,-0.60015,-0.21775,-0.34522,0.41957,0.58952,0.6745,0.24962,-0.26024,-0.21775,-0.34522,0.6745,1.4393,1.6942,1.6942,1.2268,0.92943,0.41957:1
-0.90734,-1.2994,-1.4201,-1.5407,-1.5407,-1.4502,-1.028,-0.72637,0.23877,1.1134,1.1436,1.0833,0.99279,0.87215,0.90231,0.99279,1.1134,0.81183,0.6007,0.41974,-0.002513,-0.30412,0.26893,-0.33428:2
-0.775,-1.1173,-1.4597,-1.5453,-1.6879,-1.4311,-1.4597,-0.48973,0.50874,1.1078,1.336,1.279,0.96519,0.70844,0.79402,0.99372,0.85108,0.5658,0.33758,0.30905,-0.06181,0.023773,0.36611,-0.11887:2
-0.77764,-1.1287,-1.3334,-1.509,-1.509,-1.3627,-1.509,-0.71913,0.39247,1.2993,1.3578,1.3578,1.036,0.74351,0.685,0.83127,0.94828,0.71425,0.48023,0.24621,-0.10482,-0.16333,0.21696,-0.19258:2
0.20627,-0.17453,-0.99053,-1.2081,-1.2081,-1.3169,-0.66413,-1.1537,-0.88173,-0.22893,0.53267,0.75027,0.58707,0.20627,0.15187,-0.33773,-0.60973,-0.44653,-0.22893,0.53267,0.69587,2.4367,2.1103,1.2399:2
0.52589,-0.07774,-0.51674,-0.846,-1.0106,-1.1204,-1.8338,-1.724,-1.285,-0.13262,0.47102,0.74539,0.74539,0.25151,-0.07774,-0.022865,-0.18749,-0.29724,-0.13262,0.52589,1.0746,2.1173,1.5685,1.2393:2
-0.95006,-1.275,-1.5187,-1.6,-1.6812,-1.4375,-1.0313,-0.54386,0.53934,1.1351,1.0539,0.97262,0.78306,0.34978,0.48518,0.53934,0.4581,0.3227,0.4581,1.433,1.1622,0.64766,0.024823,-0.32722:1
-0.7955,-1.2037,-1.4235,-1.4863,-1.5491,-1.4863,-1.2351,-0.41869,0.58616,1.1514,1.2456,1.2456,0.93158,0.80597,0.83737,1.2142,0.96298,0.74317,0.39775,0.20934,-0.26168,-0.16747,0.052336,-0.35588:2
-0.50665,-0.98538,-1.4641,-1.4162,-1.512,-1.129,-1.3205,-0.31516,0.4508,1.4561,1.6955,1.3604,1.0253,0.40293,-0.075798,-0.075798,-0.17154,-0.41091,-0.31516,0.35506,1.5519,0.92953,0.49867,-0.027926:1
-0.66859,-1.0931,-1.3195,-1.3761,-1.4327,-1.2912,-1.5459,-1.0648,0.095513,1.086,1.2841,1.369,1.3124,0.85962,0.88792,0.97282,0.88792,0.68982,0.37852,0.26531,-0.15919,-0.10259,0.15211,-0.18749:2
-0.76906,-1.0395,-1.3776,-1.648,-1.5128,-1.5128,-0.90428,-1.1071,-0.29579,0.78596,1.5297,1.1916,0.98879,0.71835,0.44792,0.78596,0.78596,0.44792,0.3127,0.17748,-0.29579,1.3268,0.65074,0.3127:2
0.001894,-0.45271,-0.8164,-1.0437,-1.1801,-1.0437,-0.8164,-1.1801,-0.77094,-0.13449,0.59288,0.59288,0.41104,0.2292,-0.31633,-0.45271,-0.63456,-0.63456,-0.27087,1.9567,2.1385,1.7749,1.2748,0.77473:1
-0.91034,-1.1901,-1.3173,-1.4699,-1.5208,-1.419,-1.2155,-0.83403,0.8955,1.4551,1.4551,1.3533,1.0481,0.69203,0.71746,0.64116,0.53942,0.23421,0.056167,-0.020135,0.23421,0.64116,0.25964,-0.32535:2
0.27486,-0.49219,-0.90128,-1.3104,-1.2592,-1.157,-1.0036,-0.6456,-1.1058,-0.083097,0.4794,0.58168,0.63281,0.070313,-0.28764,-0.18537,-0.38992,-0.59446,-0.13423,0.73509,2.218,2.0646,1.5021,0.99077:1
-0.84155,-1.214,-1.4718,-1.5864,-1.5864,-1.5005,-1.2426,-0.35453,0.30439,1.1065,1.3644,1.3644,1.1065,0.70547,0.59088,0.84871,0.96331,0.56223,0.33304,0.10385,-0.039392,0.61952,0.16115,-0.29723:2
-0.81666,-1.2326,-1.3885,-1.5965,-1.6225,-1.4145,-1.5185,-0.1408,0.3271,1.0809,1.1849,1.1589,0.87298,0.74301,0.84699,1.029,1.1069,0.795,0.48307,0.17113,-0.11481,-0.06282,0.3011,-0.19279:2
-0.64889,-1.1346,-1.2864,-1.5292,-1.5596,-1.4685,-1.2864,-0.67924,0.26183,1.1725,1.2636,1.2636,0.92969,0.89933,0.68683,1.1725,1.1422,0.86898,0.41362,0.1404,-0.13281,-0.041741,-0.041741,-0.40603:2
-1.0302,-1.4011,-1.5539,-1.6194,-1.6194,-1.423,-1.0738,0.19185,0.99926,1.1957,1.2175,1.1084,0.91197,0.45371,0.3446,0.41007,0.41007,0.25732,0.27914,1.1302,0.80286,0.47553,-0.04819,-0.41916:1
-1.1442,-1.3795,-1.5424,-1.5967,-1.6148,-1.3614,-0.99937,-0.23909,0.62979,0.97372,1.0823,1.0642,0.95562,0.53928,0.53928,0.7022,0.7565,0.7565,0.97372,0.91942,0.55738,0.21345,-0.16669,-0.61923:1
-0.76228,-1.1933,-1.337,-1.5285,-1.5285,-1.5285,-1.0975,-0.6186,0.33923,1.1055,1.345,1.3929,1.2492,1.0097,0.77026,0.86604,0.67447,0.81815,0.48291,0.003991,-0.33125,-0.13968,0.24345,-0.23547:2
-0.72884,-0.98608,-1.3719,-1.5327,-1.7256,-1.4362,-1.0182,-0.053591,0.62166,1.0397,1.1361,1.0397,0.68597,0.10718,-0.15006,-0.24652,-0.1179,0.10718,1.3291,1.6185,1.2969,0.71812,0.075028,-0.40729:1
-0.66987,-1.1857,-1.3863,-1.4723,-1.5869,-1.5009,-1.5869,-0.44061,0.59107,1.2215,1.3362,1.2788,1.1356,0.73435,0.73435,0.84898,0.84898,0.50509,0.24717,0.21851,0.046569,0.1612,0.18986,-0.26867:2
-0.88848,-1.3066,-1.5575,-1.6968,-1.5575,-1.5017,-0.99998,-0.47037,0.67246,1.3414,1.3136,1.2578,0.9512,0.56096,0.58884,0.70033,0.70033,0.44947,0.36585,0.11498,0.14285,0.78396,0.33797,-0.30313:2
-1.0437,-1.3267,-1.5288,-1.5693,-1.6097,-1.5086,-1.1852,0.007581,0.65449,1.079,1.0386,0.89709,0.55341,0.35125,0.37147,0.43212,0.57363,0.93752,1.261,1.1195,0.65449,0.37147,-0.053067,-0.4776:1
-0.60179,-0.99699,-1.3563,-1.5,-1.5359,-1.4641,-1.1766,-0.70957,-0.31437,-0.27844,0.36826,0.65568,0.79939,0.40419,0.04491,-0.026946,0.008982,1.0868,1.3024,1.5898,1.482,1.1946,0.69161,0.33233:1
-1.028,-1.3236,-1.5117,-1.6461,-1.5923,-1.458,-1.1623,-0.27547,0.63828,1.122,1.2295,1.0952,0.79953,0.53078,0.55765,0.69203,0.63828,0.45015,0.31578,0.9339,0.96078,0.45015,0.12766,-0.54422:1
-0.91105,-1.3139,-1.5153,-1.6943,-1.6272,-1.4258,-0.93343,-0.12775,0.96886,1.1703,1.1479,0.9241,0.7003,0.25271,0.29747,0.23033,0.61079,1.0584,1.0808,1.0136,0.61079,0.25271,-0.15013,-0.62011:1
-0.99766,-1.3447,-1.5582,-1.6116,-1.6383,-1.4781,-1.0243,-0.30363,0.57724,0.79078,1.031,0.89756,0.87086,0.44377,0.20354,0.36369,0.41708,0.7374,1.3513,1.2713,0.81748,0.49716,0.043376,-0.35702:1
-0.54918,-0.93939,-1.4163,-1.503,-1.6331,-1.503,-1.2429,0.23124,0.6648,1.2718,1.4019,1.0984,0.57809,0.23124,-0.11562,-0.15897,-0.15897,-0.28904,0.014452,1.5753,1.3585,0.88159,0.36131,-0.15897:1
0.022959,-0.67834,-1.0791,-1.4297,-1.5299,-1.3796,-1.6802,-1.0791,0.27342,1.2753,1.9766,1.3755,1.1751,0.32352,-0.077226,-0.12732,0.022959,-0.027134,0.022959,0.47379,0.27342,1.125,0.72426,0.022959:2
-0.88936,-1.112,-1.3903,-1.5294,-1.5294,-1.4459,-1.5851,-0.69456,0.55773,1.003,1.2256,1.1978,1.0308,0.61339,0.94734,0.91951,0.80819,0.72471,0.55773,0.52991,0.056817,-0.026669,0.19596,-0.16581:2
-1.0,-1.3139,-1.5312,-1.6278,-1.6519,-1.4105,-1.0,-0.44467,0.69015,1.1731,1.2213,1.0523,0.73844,0.42455,0.40041,0.47284,0.52113,0.35212,0.42455,1.2938,0.95575,0.64186,0.08652,-0.46882:1
-0.52377,-0.83607,-1.0703,-1.6168,-1.6168,-1.5388,-0.83607,-1.3826,-0.21146,1.0378,1.1939,1.3501,1.1158,0.56931,0.72547,0.64739,0.56931,0.33508,0.17893,0.022772,-0.52377,1.5062,0.88162,0.022772:2
-0.20557,-0.98676,-1.2746,-1.439,-1.5212,-0.98676,-0.86341,-0.69895,0.90453,1.7679,1.8913,1.6446,1.0279,0.45226,0.12334,-0.2878,-0.49338,-0.32892,-0.45226,0.0,0.20557,1.1512,0.49338,-0.12334:2
-1.1625,-1.3409,-1.5193,-1.6263,-1.6263,-1.4479,-0.93061,-0.038652,0.81763,1.0139,1.0317,0.97818,0.83547,0.51436,0.49652,0.63924,0.67492,0.99602,1.0495,0.87115,0.42517,0.19326,-0.23488,-0.60951:1
-0.99752,-1.2927,-1.5289,-1.706,-1.647,-1.4403,-0.90896,-0.14145,0.62606,1.0984,1.1869,1.1574,1.1574,0.56702,0.74414,0.80318,0.6851,0.41943,0.065189,0.15375,0.80318,0.80318,-0.082409,-0.5252:2
-0.84923,-1.1929,-1.4044,-1.5365,-1.5365,-1.3779,-1.6159,-0.76993,0.47253,1.1598,1.2656,1.107,1.107,0.73688,0.68401,0.86906,0.84262,0.65758,0.41966,0.41966,0.20818,0.18174,0.28748,-0.13548:2
-0.16778,-0.80617,-1.2481,-1.4445,-1.5428,-1.5428,-1.2972,-0.16778,0.32328,1.2563,1.6983,1.3054,0.91256,0.12686,-0.11867,-0.21689,-0.3151,-0.51153,0.66703,0.12686,1.6001,1.2072,0.37239,-0.21689:2
0.74071,0.11817,-0.57355,-0.57355,-0.78106,-0.57355,-0.43521,-0.089347,-0.57355,0.25651,0.74071,0.94823,0.67154,0.048997,-0.78106,-1.1961,-1.1269,-1.1269,-1.3344,-0.85024,1.0174,2.1933,1.7783,1.5016:1
-0.78168,-1.1919,-1.3833,-1.5201,-1.5747,-1.4654,-1.6021,-0.53555,0.4763,1.2147,1.4335,1.16,0.9412,0.55834,0.74977,0.88651,0.85916,0.64038,0.4763,0.28487,0.066089,0.066089,0.36691,-0.12534:2
-1.2498,-1.414,-1.56,-1.5783,-1.6148,-1.4323,-0.86667,-0.17333,0.50176,0.92141,1.0674,0.93966,0.73895,0.48351,0.42878,0.53825,0.57474,0.9579,1.2863,1.0491,0.62948,0.33755,-0.17333,-0.39228:1
0.55361,0.090892,-0.50404,-0.63624,-0.70234,-0.76845,-1.2312,-1.4956,-1.1651,-0.50404,0.024789,0.2892,0.3553,0.090892,-0.30573,-0.37183,-0.30573,-0.30573,-0.30573,0.024789,0.61972,2.4045,2.2723,1.8757:2
-1.0468,-1.3498,-1.513,-1.6295,-1.6528,-1.4663,-1.0002,-0.37095,0.65451,1.1672,1.074,0.88757,0.65451,0.39815,0.46806,0.58459,0.53798,0.39815,0.51468,1.4236,1.0507,0.46806,0.14178,-0.39426:1
-1.0642,-1.3416,-1.5002,-1.5794,-1.5992,-1.4209,-1.1435,-0.21219,0.50115,0.85782,0.9569,0.9569,0.87764,0.52097,0.62004,0.65967,0.81819,1.0758,1.1154,0.9569,0.52097,0.26337,-0.29144,-0.54904:1
-0.39375,-0.83951,-1.4636,-1.5527,-1.6419,-1.3744,-0.92866,-1.2853,-0.3046,1.3001,1.5676,1.211,1.1218,0.67606,0.67606,0.49776,0.49776,0.40861,0.052005,0.14116,-0.3046,1.211,0.58691,0.14116:2
-0.099111,-0.65413,-1.0506,-1.2488,-1.3281,-1.1299,-0.892,-0.65413,-0.81271,-0.13876,0.41627,0.61449,0.5352,-0.059467,-0.13876,-0.49556,-0.57484,-0.57484,0.97129,1.9624,2.0417,1.6452,1.0902,0.57484:1
-0.007175,-0.52375,-1.0834,-1.1264,-1.2986,-1.2556,-0.95423,-0.43766,-0.82509,0.078922,0.55245,0.6816,0.55245,0.12197,-0.22242,-0.4807,-0.6529,-0.69595,-0.050223,1.7578,2.0161,1.973,1.1982,0.6816:1
0.32079,-0.1604,-0.83406,-1.3153,-1.4115,-1.219,-0.64159,-1.4115,-0.25663,1.3794,2.0531,1.8606,1.4756,0.70575,-0.35287,-0.1604,-0.1604,-0.25663,-0.25663,0.032079,-0.73782,-0.1604,1.0907,0.41703:2
0.94351,0.25732,-0.20014,-0.085774,-0.42887,-0.20014,0.25732,-1.2294,-0.77196,-0.20014,0.25732,0.25732,-0.085774,-0.085774,-1.5725,-0.77196,-0.88633,-0.54323,-0.54323,-0.77196,-0.085774,2.5446,2.2015,1.7441:2
-1.0126,-1.3538,-1.5488,-1.5976,-1.5001,-1.2563,-1.0126,-0.91507,0.57179,1.2055,1.3274,1.2055,1.0349,0.79117,0.64492,0.76679,0.76679,0.47429,0.42554,0.35242,0.23055,0.69367,0.084296,-0.37883:2
-0.68518,-1.1296,-1.3667,-1.4556,-1.4852,-1.4556,-1.3963,-0.65555,0.35185,1.0926,1.3,1.2704,1.063,0.85555,0.82592,1.0926,1.1222,0.82592,0.29259,0.17407,-0.21111,-0.24074,0.025926,-0.21111:2
0.16544,-0.60804,-1.1237,-1.3815,-1.4846,-1.33,-2.1034,-0.91743,0.47483,1.7124,1.7124,1.3514,1.0936,0.11387,0.11387,0.11387,0.16544,-0.092388,0.062308,0.32013,0.42326,0.42326,0.73266,0.062308:2
-1.0175,-1.3467,-1.4701,-1.6347,-1.6141,-1.429,-1.0586,-0.17401,0.7312,0.9575,1.1015,1.0398,0.7312,0.4226,0.40203,0.4226,0.46375,0.54604,1.4101,1.1221,0.6489,0.38146,-0.009429,-0.62662:1
-0.24862,-0.79771,-1.1272,-1.4932,-1.4932,-1.3102,-1.0173,-0.68789,-0.7245,-0.10219,0.4103,0.73975,0.77636,0.19066,-0.10219,-0.24862,-0.35844,-0.065586,1.4353,1.7647,1.6915,1.4353,1.0326,0.30048:1
-0.85779,-1.282,-1.5365,-1.6213,-1.7061,-1.5365,-0.91434,-0.34877,0.81066,1.348,1.348,1.2066,1.0934,0.64098,0.61271,0.64098,0.47131,0.32992,0.18852,0.2168,0.2168,0.7541,0.30164,-0.37705:2
-0.94329,-1.1154,-1.5332,-1.7053,-1.7053,-1.3366,-1.1891,-0.47625,0.43324,0.72821,0.85111,0.92486,0.94944,0.45782,0.4824,0.38408,0.62989,0.92486,1.269,1.3181,0.72821,0.40866,-0.05838,-0.42709:1
-0.89109,-1.2081,-1.5739,-1.5739,-1.6227,-1.5007,-1.2081,-0.62285,0.35257,0.84028,1.1817,1.2548,0.9866,0.8159,0.62081,0.86467,0.84028,0.84028,0.52327,0.35257,0.40135,0.62081,0.059948,-0.35461:2
-1.0733,-1.2879,-1.5294,-1.6367,-1.6635,-1.5026,-0.99276,-0.40247,0.40247,0.99276,1.1537,1.0464,0.99276,0.67078,0.8586,0.88543,0.99276,0.5098,0.40247,0.26831,0.67078,0.59029,0.080494,-0.4293:2
-0.37068,-0.84272,-1.2058,-1.3874,-1.5689,-1.5326,-1.1695,-0.80641,-0.47961,-0.26174,0.5371,0.86391,1.0455,0.35555,0.065058,-0.007565,-0.22543,0.17399,1.5538,1.6264,1.4086,1.336,0.64604,0.24661:1
-1.0155,-1.3408,-1.5441,-1.5644,-1.605,-1.4221,-1.0562,-0.080464,0.97658,1.0376,1.1189,0.93592,0.79363,0.38707,0.34642,0.46838,0.46838,0.44806,1.2002,1.1189,0.85461,0.32609,-0.30407,-0.548:1
-0.1449,-0.90565,-1.2317,-1.7751,-1.5577,-1.2317,-0.79698,-1.2317,0.18113,1.2679,0.8332,1.3766,1.1592,1.3766,0.72452,0.18113,0.28981,-0.036226,-0.36226,-0.47094,-0.25358,1.3766,0.94188,0.28981:2
-0.60359,-1.0785,-1.4348,-1.5535,-1.6722,-1.4348,-0.84107,-1.0785,0.049474,1.0588,1.415,1.415,1.3556,0.76191,0.70254,0.76191,0.64317,0.64317,0.22758,0.10884,-0.42548,0.64317,0.40569,-0.069264:2
-0.67451,-1.1463,-1.3822,-1.6771,-1.736,-1.3527,-1.0873,-0.11426,0.85881,0.97675,1.1537,1.0062,0.79983,0.15112,-0.084775,-0.20272,-0.14375,0.092147,1.3011,1.3896,1.1832,0.77035,0.15112,-0.23221:1
-1.0737,-1.3839,-1.5972,-1.6166,-1.5972,-1.4421,-0.99611,-0.10422,0.72951,1.0979,1.1173,0.98156,0.76829,0.38051,0.3999,0.55501,0.41929,0.67134,1.2142,1.0785,0.61317,0.28356,0.012118,-0.51138:1
-0.99496,-1.3813,-1.5744,-1.5986,-1.5986,-1.4296,-1.0191,-0.34305,0.71931,1.2022,1.1056,1.0573,0.81588,0.42957,0.45372,0.45372,0.45372,0.35714,0.57444,1.3229,0.88832,0.57444,-0.00503,-0.46378:1
-0.76407,-1.1501,-1.3753,-1.4718,-1.6005,-1.504,-1.0536,-0.76407,0.42627,1.2627,1.2949,1.3271,1.1019,0.84449,0.84449,0.97318,0.94101,0.71581,0.3941,0.1689,-0.21716,-0.088471,-0.024128,-0.2815:2
-0.96917,-1.3359,-1.529,-1.6255,-1.5676,-1.4324,-1.0464,-0.13914,0.63297,1.0576,1.2507,1.1542,0.84531,0.51716,0.26622,0.45925,0.57507,0.32413,1.1735,1.2121,0.49785,0.36273,-0.11984,-0.56381:1
-0.37867,-0.89664,-1.2733,-1.5559,-1.6501,-1.3675,-1.3204,-0.89664,0.65727,1.2223,1.7403,1.3636,1.034,0.51601,-0.001962,-0.19032,-0.14323,-0.19032,0.092215,0.37474,0.79854,1.0811,0.79854,0.18639:2
-0.96361,-1.2607,-1.5577,-1.5577,-1.6426,-1.388,-0.87875,-0.96361,-0.030058,0.94593,1.2005,1.243,0.94593,0.69133,0.73376,0.86106,0.86106,0.60646,0.47916,0.18211,0.054811,1.0732,0.47916,-0.11493:2
-1.0578,-1.4154,-1.5431,-1.6198,-1.6453,-1.4665,-1.2111,0.14261,0.57681,1.2664,1.1643,1.0876,0.85777,0.6279,0.52573,0.57681,0.60236,0.34694,0.21923,0.50019,0.90886,0.73006,0.19369,-0.36823:2
-0.9066,-1.3106,-1.4837,-1.5992,-1.628,-1.5415,-1.0797,-0.35831,0.68055,1.1134,1.2577,1.1711,1.0557,0.47855,0.56512,0.73826,0.7094,0.44969,0.18998,0.074548,1.0557,0.73826,-0.040881,-0.32945:2
-1.0029,-1.3557,-1.4595,-1.667,-1.667,-1.4387,-1.1067,-0.13142,0.63635,1.0929,1.1759,1.0721,0.84386,0.38734,0.24209,0.4081,0.4496,0.42885,1.1759,1.1344,0.67785,0.47035,0.076086,-0.44268:1
-0.64793,-1.0889,-1.2946,-1.5004,-1.4416,-1.4122,-1.5004,-0.67733,0.23394,1.204,1.3216,1.351,1.0864,0.79246,0.85125,1.0276,1.057,0.70427,0.29273,0.29273,-0.207,-0.38337,0.11636,-0.1776:2
-0.85908,-1.19,-1.3936,-1.5463,-1.5463,-1.4954,-1.5463,-0.4009,0.66817,1.2027,1.2282,1.1773,1.0754,0.66817,0.79544,0.87181,0.8209,0.69363,0.46454,0.18454,0.057272,0.23545,0.10818,-0.27363:2
0.019051,-0.66678,-1.2383,-1.2955,-1.5812,-1.4669,-1.2955,-0.89539,0.47627,1.5622,2.0194,1.2764,0.93349,0.30481,-0.095254,-0.095254,-0.20956,-0.15241,-0.20956,0.13336,0.076204,1.3907,0.87634,0.13336:2
-0.95666,-1.2932,-1.5577,-1.6539,-1.6779,-1.4615,-1.0047,-0.019033,0.67818,1.1831,1.1831,1.135,0.7503,0.38968,0.43776,0.38968,0.4618,0.36564,0.65414,1.3033,0.89455,0.38968,-0.091158,-0.49987:1
-1.0983,-1.4109,-1.5411,-1.6192,-1.6192,-1.5151,-1.1244,0.021706,0.59474,1.1938,1.2459,1.1157,0.85521,0.59474,0.59474,0.75102,0.67288,0.59474,0.17799,0.17799,0.77706,0.64683,0.23008,-0.3169:2
-0.82636,-1.3701,-1.5704,-1.6563,-1.6849,-1.5132,-1.227,-0.1109,0.54733,1.1197,1.2055,0.9766,0.91937,0.49009,0.60456,0.6618,0.74766,0.51871,0.26114,0.49009,1.0052,0.6618,0.11805,-0.36846:2
-0.78322,-1.2808,-1.5296,-1.6402,-1.6678,-1.5296,-1.3084,-0.258,0.87536,1.1241,1.2347,1.1241,0.82008,0.59893,0.62658,0.7095,0.65422,0.54365,0.21193,0.46072,0.79243,0.57129,0.018429,-0.36857:1
-0.40782,-0.84608,-1.333,-1.4304,-1.5765,-1.2356,-1.8687,-1.0896,0.12782,1.2478,1.3452,1.54,1.1991,0.71217,0.56608,0.46869,0.51739,0.32261,0.22522,0.22522,0.030435,0.12782,0.90695,0.22522:2
1.241,0.64362,0.046227,-0.46582,-0.63651,-0.55116,-2.002,-1.8313,-0.97787,0.13157,0.55828,0.55828,0.64362,0.13157,-0.46582,-0.63651,-0.38048,-0.46582,-0.46582,-0.29514,0.13157,0.98498,1.9237,2.1798:2
-0.94435,-1.3769,-1.485,-1.5931,-1.5931,-1.485,-1.0092,-0.014418,0.656,1.2615,1.2183,1.1318,0.91551,0.43973,0.28835,0.41811,0.46136,0.54787,0.82901,1.1101,0.72088,0.3316,-0.079296,-0.74971:1
1.0554,0.29359,-0.27772,-0.91252,-0.91252,-0.78556,-1.9917,-1.6108,-0.976,-0.15076,0.61099,0.80143,0.67447,0.23011,-0.087285,-0.15076,-0.27772,-0.3412,-0.3412,-0.27772,0.42055,0.73795,2.3884,1.8806:2
-0.98157,-1.2517,-1.5489,-1.6029,-1.657,-1.5219,-1.2247,-0.36021,0.66639,1.1257,1.2607,1.1257,0.72042,0.63937,0.66639,0.6934,0.6934,0.53131,0.28817,0.36922,0.90953,0.6934,0.072042,-0.30618:1
-1.0889,-1.3624,-1.5187,-1.5773,-1.5968,-1.4991,-1.0889,-0.09278,0.57133,1.0206,1.0206,0.84479,0.68853,0.41507,0.376,0.51273,0.57133,1.2354,1.1573,1.0206,0.64946,0.31741,-0.09278,-0.48343:1
-0.82829,-1.2592,-1.6039,-1.7475,-1.6614,-1.5177,-1.1156,-0.1963,0.78041,1.2113,1.2975,1.1251,1.0102,0.49314,0.57932,0.6655,0.63677,0.49314,0.34951,0.17715,0.40696,0.69423,0.34951,-0.33993:2
0.06079,-0.77291,-1.0855,-1.4503,-1.6066,-1.6066,-1.1898,-0.66869,0.32132,1.3113,1.3634,1.1029,0.73817,0.1129,-0.19974,-0.40816,-0.35606,-0.30395,-0.095528,1.0508,1.8324,1.155,0.63396,0.06079:1
-0.63668,-1.1503,-1.5034,-1.6318,-1.6318,-1.4392,-0.70088,-0.28356,0.48687,1.2894,1.4178,1.161,0.71158,0.19796,-0.31566,-0.18726,-0.058852,0.32636,1.2252,1.482,0.93629,0.48687,0.19796,-0.37987:1
0.10265,-0.52446,-0.9276,-1.1068,-1.3307,-1.1964,-0.61405,-1.2412,-0.65884,0.19224,0.461,0.59538,0.461,0.013065,-0.34528,-0.47966,-0.56925,-0.61405,0.013065,1.8048,2.1184,1.8048,1.2673,0.77456:1
-1.1456,-1.3193,-1.5365,-1.6016,-1.6016,-1.4713,-0.92841,0.048864,0.54836,1.0261,1.0261,0.96098,0.59179,0.37462,0.46149,0.61351,0.70038,0.70038,1.1782,1.265,0.67866,0.30947,-0.21174,-0.6678:1
-1.0556,-1.3922,-1.5605,-1.6237,-1.6026,-1.4343,-1.0135,0.038575,0.81709,1.1117,0.94334,0.94334,0.83813,0.41731,0.31211,0.41731,0.50148,0.88021,1.1537,1.0485,0.6698,0.33315,-0.15079,-0.59265:1
-0.50895,-1.0115,-1.3593,-1.5526,-1.5526,-1.282,-0.77953,-0.50895,0.72799,1.3851,1.3851,1.0372,0.76664,0.22548,-0.19971,-0.19971,-0.35433,-0.19971,-0.27702,1.617,1.5011,1.0759,0.26414,-0.19971:1
-0.9859,-1.3077,-1.5552,-1.6789,-1.6294,-1.4314,-0.9859,-0.51564,0.54864,1.0932,1.0189,0.9694,0.84565,0.32588,0.37538,0.57339,0.69714,0.57339,0.49914,1.2664,1.0437,0.64764,0.053626,-0.44139:1
-0.59638,-1.1054,-1.4348,-1.6743,-1.6145,-1.4348,-1.0755,-0.23705,0.33188,0.96069,1.2901,1.2302,1.0206,0.30193,-0.14722,-0.11728,-0.11728,0.032439,1.2002,1.4997,1.1104,0.60137,0.032439,-0.057392:1
-0.38248,-1.1318,-1.4441,-1.6314,-1.6314,-1.4441,-1.1006,-0.25759,0.24198,0.99134,1.2723,1.1162,0.77277,0.2732,-0.10148,-0.1327,-0.10148,0.085864,1.3348,1.5846,1.1787,0.61666,0.17953,-0.28881:1
-0.8066,-1.0907,-1.4559,-1.4965,-1.5371,-1.4965,-1.2936,-0.72543,0.16741,1.1008,1.3849,1.4255,1.1008,0.77616,0.69499,0.77616,0.85733,0.57324,0.32974,0.16741,-0.19784,0.69499,0.32974,-0.27901:2
-1.0509,-1.225,-1.5981,-1.6479,-1.6479,-1.3245,-1.0509,-0.3047,0.56588,1.2126,1.1628,0.98873,0.73999,0.36689,0.51613,0.49126,0.6405,0.34201,0.51613,1.3867,0.93898,0.541,-0.055966,-0.50369:1
-1.0856,-1.2619,-1.4603,-1.5925,-1.6146,-1.4603,-1.0856,-0.093678,0.45737,1.0525,1.0084,0.8982,0.72187,0.3692,0.45737,0.47941,0.45737,0.74391,1.339,1.2288,0.6337,0.65574,-0.1598,-0.68881:1
-0.91298,-1.2765,-1.6159,-1.7128,-1.6644,-1.422,-1.1069,0.032318,0.54132,1.1715,1.123,1.0261,0.80794,0.37165,0.49284,0.42013,0.51708,0.29894,0.49284,1.3654,0.92913,0.54132,-0.016159,-0.40397:1
-1.0673,-1.3821,-1.5273,-1.6,-1.6,-1.5031,-1.0673,-0.050441,0.72433,1.0391,1.1117,0.96644,0.91802,0.53064,0.48221,0.65169,0.43379,0.28852,0.50642,1.3296,0.82117,0.55485,-0.050441,-0.51046:1
-0.66086,-1.1376,-1.5508,-1.6462,-1.6462,-1.3919,-0.94693,-0.056948,0.83303,0.92838,1.1827,1.0873,0.92838,0.29269,0.29269,0.22912,0.32447,0.83303,1.3734,1.1509,0.70589,0.10198,-0.3748,-0.85157:1
-0.90469,-1.1961,-1.3904,-1.5119,-1.5119,-1.439,-1.5119,-0.83183,0.38252,0.91683,1.0868,1.1597,1.0383,0.89255,0.7954,0.89255,1.014,0.74682,0.55253,0.40681,-0.006072,0.50395,0.13965,-0.22465:2
0.53996,-0.13244,-0.68259,-0.98823,-1.2327,-0.80485,-0.86598,-1.844,-0.86598,0.1732,0.78447,0.47883,0.8456,0.05094,-0.2547,-0.13244,-0.37695,-0.49921,-0.49921,-0.010188,0.66222,2.5572,1.7625,1.3346:2
-0.38018,-0.60688,-1.1169,-1.5703,-1.5703,-1.3436,-1.0603,-1.1736,0.46992,1.2067,1.6034,1.32,1.3767,0.35657,-0.21016,-0.32351,-0.26684,-0.32351,-0.040144,0.46992,0.63994,1.4334,0.97998,0.12988:2
0.81587,0.20777,-0.33952,-0.70438,-0.94762,-0.94762,-2.0422,-1.7382,-1.1301,-0.035472,0.93749,0.87668,0.81587,0.3902,0.14696,-0.096282,-0.33952,-0.64357,-0.40033,-0.096282,0.57263,1.3632,2.1537,1.1807:2
-0.80826,-1.4079,-1.4601,-1.5122,-1.4861,-1.4079,-1.4601,-0.59967,0.52146,1.0951,1.3558,1.1733,1.0951,0.75611,0.70396,0.96469,0.88647,0.54753,0.31287,0.2868,0.0,0.13036,0.31287,0.0:2
0.72066,-0.24619,-0.89075,-1.213,-1.213,-1.213,-0.89075,-1.965,-0.46104,0.72066,1.2578,1.1504,1.2578,-0.13876,-0.35361,-0.24619,0.076094,0.076094,-0.031333,-0.031333,-0.6759,1.9024,1.4726,0.93551:2
-1.1036,-1.3432,-1.5174,-1.6046,-1.6046,-1.4521,-1.1472,-0.058084,0.5518,1.1617,1.1181,1.0092,0.83495,0.39933,0.44289,0.39933,0.48645,0.46467,1.0092,1.227,0.72605,0.48645,-0.014521,-0.47193:1
-0.98818,-1.3752,-1.541,-1.5594,-1.6331,-1.412,-1.1172,-0.28793,0.6703,0.98357,1.0757,1.0573,0.85458,0.50445,0.59659,0.63345,0.6703,0.76244,1.0757,0.96514,0.59659,0.20961,-0.14051,-0.6012:1
-0.086412,-0.565,-1.0436,-1.4158,-1.4158,-1.2563,-1.8412,-1.0968,0.60489,1.5089,1.8811,1.6684,1.243,0.44536,-0.033235,0.073118,0.073118,-0.033235,0.019941,0.28583,0.28583,0.073118,0.71124,-0.086412:2
-1.1448,-1.3366,-1.4709,-1.586,-1.6436,-1.4134,-1.068,-0.16628,0.65872,0.9465,0.96569,0.8122,0.62034,0.37093,0.44767,0.62034,0.77383,1.1384,1.1767,1.0041,0.6779,0.33256,-0.031976,-0.6843:1
-0.39933,-0.79269,-1.2933,-1.5079,-1.5794,-1.3649,-1.1861,-0.54237,-0.75693,0.24436,0.70925,0.85229,0.78077,0.2086,-0.22052,-0.22052,-0.22052,0.42317,1.4245,1.496,1.6748,1.2814,0.78077,0.2086:1
-0.91968,-1.3247,-1.5019,-1.6031,-1.6537,-1.5019,-0.945,-0.38812,0.54843,1.5356,1.4597,1.0547,0.97874,0.57375,0.62437,0.675,0.70031,0.37125,0.11812,0.0675,0.34594,0.82687,0.14344,-0.18562:2
0.087698,-0.44968,-0.98707,-1.1662,-1.3453,-1.3005,-0.8975,-0.49447,-0.8975,-0.001866,0.49073,0.53552,0.40117,-0.001866,-0.4049,-0.36012,-0.49447,-0.49447,0.17726,2.0581,2.1924,1.8342,0.89377,0.62508:1
-0.20356,-0.62839,-1.0532,-1.3081,-1.4356,-1.3081,-1.0107,-0.75584,-0.92577,-0.20356,0.47616,0.68857,0.81602,0.008851,-0.33101,-0.41598,-0.62839,0.68857,1.4108,1.7082,1.7506,1.4957,0.77354,0.39119:1
-1.044,-1.3143,-1.5576,-1.6116,-1.6657,-1.5035,-1.1251,-0.15204,0.30746,1.1994,1.3346,1.2805,1.0102,0.57775,0.57775,0.57775,0.73993,0.38855,0.2534,0.19934,0.36152,0.87507,0.38855,-0.097981:2
-0.90912,-1.3496,-1.4964,-1.5845,-1.5845,-1.4377,-1.144,-0.79166,0.089322,0.8822,0.99967,1.029,1.1171,0.67664,0.85284,0.94094,0.99967,0.79411,0.50045,0.29488,0.35362,0.76474,0.35362,-0.35117:2
-1.1775,-1.3718,-1.5272,-1.6243,-1.6243,-1.4495,-0.96388,0.18209,0.88133,0.99787,1.0756,0.90075,0.66767,0.43459,0.47344,0.37633,0.53171,1.0561,1.1338,0.92018,0.49286,0.33748,-0.070409,-0.65311:1
-0.89811,-1.2587,-1.4807,-1.5916,-1.6748,-1.5084,-1.0091,-0.45425,0.51667,1.0992,1.1824,1.2379,0.93278,0.76634,0.7386,0.90504,0.98826,0.65538,0.29475,0.1283,0.37797,0.54441,0.1283,-0.6207:2
-0.72938,-1.1679,-1.404,-1.5389,-1.6063,-1.4377,-1.1004,0.28248,0.75468,1.1932,1.3281,0.92332,0.65349,0.012648,-0.22345,-0.25718,-0.12227,0.38366,1.463,1.5304,0.82214,0.45112,0.14756,-0.35837:1
-0.98344,-1.3189,-1.5585,-1.6304,-1.6065,-1.3668,-1.0553,-0.48024,0.52617,0.64598,0.95749,1.0533,0.81371,0.57409,0.45428,0.47824,0.52617,1.1013,1.245,1.1971,0.66994,0.35843,-0.16873,-0.43232:1
-0.17613,-0.67838,-0.97135,-1.348,-1.4317,-1.1388,-0.9295,-0.3854,-0.76208,-0.13428,0.45167,0.66094,0.70279,0.15869,-0.25984,-0.34355,-0.46911,-0.55282,0.32611,2.084,2.1258,1.7073,0.91206,0.45167:1
-1.0642,-1.3655,-1.5591,-1.5591,-1.6452,-1.4085,-0.99968,-0.009862,0.63567,0.95844,1.023,0.89389,0.63567,0.37746,0.37746,0.48505,0.4205,0.70023,1.3888,1.2597,0.72175,0.44201,-0.03138,-0.67692:1
-0.78292,-1.0868,-1.2387,-1.3654,-1.416,-1.2134,-1.3147,-0.58033,0.23002,1.3189,1.4202,1.6988,1.3443,0.86311,0.81246,0.83779,0.78714,0.5339,0.33132,0.12873,-0.58033,-0.40307,0.027434,-0.35242:2
-0.66072,-1.0814,-1.4374,-1.5992,-1.6639,-1.5021,-1.0491,0.083601,0.63375,1.2163,1.2486,1.0544,0.73083,0.18069,-0.14293,-0.20765,-0.078207,0.60139,1.281,1.3781,1.0221,0.5043,-0.013484,-0.49891:1
-0.98924,-1.3697,-1.5219,-1.6234,-1.6234,-1.4965,-1.1414,-0.22829,0.35511,1.0653,1.0653,1.0146,0.71023,0.48194,0.48194,0.76096,0.76096,0.5073,0.55803,1.2936,0.83705,0.5073,0.05073,-0.45657:1
-0.97087,-1.2603,-1.5208,-1.6656,-1.6656,-1.5498,-1.2024,-0.18935,0.62112,0.79479,1.229,1.1132,0.96846,0.56323,0.59217,0.70795,0.85268,0.62112,0.38955,0.21588,0.91057,0.67901,0.21588,-0.44986:2
-0.96405,-1.2411,-1.5736,-1.6568,-1.6845,-1.3797,-1.0472,-0.46528,0.6985,1.225,1.225,1.3358,0.97559,0.53225,0.6985,0.78163,0.83705,0.3937,0.25515,0.17203,-0.077355,0.6985,0.42141,-0.16048:2
-1.1181,-1.4318,-1.5991,-1.62,-1.6409,-1.2645,-1.0553,-0.009586,0.59694,1.2035,1.078,1.0571,0.78518,0.47145,0.42962,0.55511,0.65969,0.45054,0.78518,1.1616,0.76426,0.42962,-0.13507,-0.55337:1
-0.9851,-1.339,-1.5514,-1.5986,-1.693,-1.4806,-1.0795,0.053089,0.73735,1.1857,1.0913,1.0205,0.73735,0.43061,0.40702,0.43061,0.40702,0.33623,0.73735,1.3272,0.85533,0.45421,0.029494,-0.5132:1
-0.98741,-1.3241,-1.5831,-1.6349,-1.5831,-1.4795,-1.0392,-0.39173,0.51475,0.95504,1.0586,0.87734,0.74784,0.41115,0.43705,0.51475,0.61835,0.30755,0.30755,1.4212,1.214,0.82554,0.17806,-0.36583:1
-0.65755,-1.0758,-1.3546,-1.494,-1.494,-1.4382,-1.6613,-0.54602,0.62502,1.1827,1.3499,1.2663,0.98748,0.68078,0.82019,0.98748,0.93172,0.68078,0.40196,0.20679,-0.15567,-0.18356,0.17891,-0.23932:2
-0.99643,-1.3424,-1.5459,-1.5663,-1.5867,-1.4442,-1.0575,-0.039857,0.57072,0.99813,1.2424,1.1406,0.7946,0.50966,0.4079,0.50966,0.57072,0.77425,1.1202,1.0185,0.61143,0.24508,-0.28409,-0.65044:1
-0.77133,-1.1468,-1.4067,-1.4644,-1.4644,-1.3778,-1.4067,-0.82908,0.38386,1.2502,1.2502,1.3369,1.0481,0.75929,0.84593,0.93257,0.99033,0.70153,0.44162,0.26834,-0.19373,-0.19373,0.26834,-0.22261:2
-1.1362,-1.3898,-1.5459,-1.6044,-1.5654,-1.4288,-1.0582,-0.063395,0.67784,0.95092,1.0875,0.93142,0.81438,0.52179,0.50228,0.52179,0.59981,0.67784,1.107,1.1265,0.67784,0.34623,-0.10241,-0.64858:1
0.14222,-0.058562,-0.46013,-0.92863,-0.92863,-0.92863,-2.3341,-1.6648,-1.2633,-0.32628,0.61072,0.74458,1.4139,0.40994,0.27608,0.008366,0.20915,-0.12549,0.27608,0.27608,0.40994,0.94536,2.0831,1.2131:2
-0.7627,-1.1311,-1.4144,-1.4994,-1.4994,-1.3861,-1.4428,-0.366,0.59741,1.2775,1.5042,1.4475,1.1075,0.73909,0.68242,0.79576,0.73909,0.5124,0.48407,0.22905,-0.05431,-0.082646,-0.05431,-0.42267:2
-0.75835,-1.2046,-1.3958,-1.5552,-1.5871,-1.4277,-1.4277,-0.79023,0.38914,1.0904,1.2816,1.2179,0.96288,0.77163,0.83538,0.89913,0.89913,0.70788,0.51663,0.35726,0.038515,-0.18461,0.38914,-0.025234:2
-0.75093,-1.0847,-1.4741,-1.5019,-1.5853,-1.4462,-1.5297,-0.75093,0.52843,1.1681,1.2516,1.2516,0.97343,0.69531,0.77875,0.80656,0.91781,0.69531,0.52843,0.36156,0.083437,0.0,0.27812,-0.19469:2
-0.53449,-1.2145,-1.4309,-1.5545,-1.6163,-1.4618,-1.06,-0.16357,0.60918,1.2583,1.351,1.1965,0.79464,0.20735,-0.10175,-0.039925,0.021895,1.011,1.1347,1.2892,0.70191,0.3619,-0.16357,-0.59631:1
0.098523,-0.19705,-0.78818,-0.8867,-1.1823,-1.0837,-0.73892,-0.59114,-0.34483,-1.0345,-0.6404,-0.049261,0.19705,0.0,-0.6404,-0.68966,-0.54187,0.098523,1.7734,1.9705,1.9705,1.7241,1.0345,0.54187:1
-0.84458,-1.309,-1.6095,-1.6914,-1.6368,-1.4456,-0.95385,-0.29822,0.60327,1.4774,1.3409,1.2316,0.68523,0.41205,0.68523,0.63059,0.82182,0.38473,0.22082,0.1935,0.46668,0.7945,0.24814,-0.40749:2
-1.0472,-1.3838,-1.5621,-1.6215,-1.6215,-1.4235,-1.0472,-0.15596,0.67583,0.9927,1.2106,1.0719,0.79466,0.43818,0.41837,0.51739,0.51739,0.37876,1.2106,1.0323,0.73524,0.37876,-0.076743,-0.43322:1
-1.1043,-1.4081,-1.5853,-1.6613,-1.6359,-1.5094,-1.0537,-0.16771,0.7183,1.0474,0.87018,0.97144,0.87018,0.59172,0.61704,0.74361,0.74361,0.51578,0.33858,0.49047,1.1486,0.66767,0.13606,-0.34491:2
0.15869,-0.46313,-1.0072,-1.3181,-1.4736,-1.3181,-1.0849,-1.4736,-0.46313,1.0914,1.791,1.4023,0.39188,0.31415,-0.15222,-0.22994,0.003239,-0.22994,-0.074489,0.080966,0.31415,2.0242,1.0914,0.62506:2
-0.070339,-0.36824,-0.9144,-1.3116,-1.6592,-1.4109,-0.96405,-0.56685,-0.21929,-0.26894,0.22757,1.1709,1.2206,-0.020688,-0.9144,-0.8151,-0.6165,1.022,1.2702,1.4688,1.5681,1.2206,0.77373,0.17792:1
0.093854,-0.85457,-1.0917,-1.5066,-1.5659,-1.5066,-1.0917,-1.0324,0.44951,1.4572,1.8129,1.7536,1.3979,0.44951,-0.083975,0.093854,-0.024698,-0.20253,0.093854,-0.20253,0.093854,0.74589,0.50879,0.21241:2
-0.48777,-1.1206,-1.437,-1.5635,-1.5319,-1.5002,-1.6901,-0.36122,0.36649,0.80944,1.284,1.4106,1.0942,0.87272,0.84108,0.96764,0.80944,0.6196,0.33485,0.20829,-0.1081,0.018456,0.36649,-0.20302:2
-0.92914,-1.3199,-1.5283,-1.6065,-1.6325,-1.4762,-1.0594,-0.40813,0.686,1.1549,1.1549,0.97256,0.71205,0.45155,0.50365,0.5297,0.6339,0.21709,0.21709,1.3894,0.97256,0.65995,0.13894,-0.43418:1
0.18921,-0.51717,-0.92082,-1.1226,-1.3245,-1.1226,-0.61808,-1.829,-0.81991,0.59286,0.79468,0.79468,0.9965,0.29012,-0.41626,-0.31535,-0.012614,-0.21444,0.088298,0.18921,0.29012,2.5102,1.8038,0.69377:2
-0.87999,-1.3453,-1.5262,-1.6296,-1.6296,-1.5262,-1.1902,-0.23373,0.49008,1.0846,1.2914,1.1105,0.77443,0.51593,0.51593,0.56763,0.59348,0.56763,0.33498,1.188,0.87783,0.38668,-0.052778,-0.28543:1
-0.85479,-1.1668,-1.4008,-1.5568,-1.5828,-1.5048,-1.5308,-0.38677,0.49727,1.1473,1.2773,1.3033,1.0433,0.60128,0.57528,0.83529,0.75728,0.73128,0.18526,0.34127,0.029251,0.75728,0.10725,-0.20476:2
-1.0302,-1.364,-1.5211,-1.5604,-1.6193,-1.4033,-0.9909,-0.20538,0.77652,1.0907,1.0711,0.97289,0.75688,0.44267,0.44267,0.5605,0.54086,0.63905,1.2675,1.13,0.61941,0.32484,-0.34285,-0.59814:1
-0.70703,-1.099,-1.4631,-1.5471,-1.5471,-1.4071,-1.6031,-0.42702,0.74903,1.225,1.281,1.169,1.029,0.74903,0.80503,0.91703,0.88903,0.60902,0.32901,0.32901,-0.063002,-0.23101,0.105,-0.091003:2
-0.45873,-0.9708,-1.3366,-1.556,-1.556,-1.3731,-1.0805,0.16307,0.78487,1.5164,1.4798,1.1506,0.74829,0.12649,-0.27585,-0.27585,-0.45873,-0.42215,-0.056389,1.4067,1.2969,0.8946,0.34595,-0.092965:1
-0.055424,-0.65172,-1.2021,-1.3856,-1.3397,-1.3397,-0.9728,-0.55998,-0.42237,0.35739,0.67847,0.81608,0.31152,-0.009556,-0.3765,-0.46824,-0.65172,-0.46824,1.5958,1.9628,1.4582,1.55,0.90781,0.26566:1
-0.98367,-1.2358,-1.5268,-1.6044,-1.585,-1.4104,-1.0613,-0.18833,0.93679,1.0338,1.092,0.87859,0.66521,0.35483,0.23844,0.49062,0.52942,1.2472,1.2472,1.0338,0.47122,0.21904,-0.22712,-0.6151:1
-1.1094,-1.3704,-1.511,-1.5712,-1.5511,-1.4507,-1.1495,-0.22589,0.35641,1.0793,1.019,0.85839,0.67768,0.41665,0.43673,0.53712,0.71784,0.93871,1.1997,1.1194,0.71784,0.41665,-0.00502,-0.54716:1
-0.91428,-1.1793,-1.3913,-1.5238,-1.6298,-1.5238,-1.2323,-0.56977,0.54327,1.2058,1.1263,1.1263,0.86127,0.96728,0.91428,0.86127,0.56977,0.35776,0.22526,0.51676,0.70227,0.70227,-0.092753,-0.62277:2
1.0743,0.49274,0.10501,0.008078,-0.18579,-0.28272,0.008078,-1.6398,-1.0582,-0.67046,-0.18579,-0.088856,-0.28272,-0.37966,-0.67046,-0.86432,-0.67046,-0.57352,-0.47659,-0.088856,-0.088856,2.4314,2.5283,1.559:2
-0.97106,-1.3396,-1.5665,-1.6515,-1.7082,-1.5665,-1.0278,-0.23391,0.44655,1.127,1.127,1.1837,0.98524,0.58831,0.50325,0.70172,0.70172,0.41819,0.36149,0.44655,0.95689,0.64501,0.10632,-0.23391:1
-1.0093,-1.331,-1.5042,-1.6527,-1.529,-1.43,-1.0588,-0.366,0.64849,1.1681,1.1681,0.99491,0.8217,0.4258,0.47529,0.45054,0.54952,0.22785,0.27734,1.4403,1.0197,0.62375,0.054643,-0.46498:1
-1.0517,-1.3405,-1.5523,-1.5908,-1.6293,-1.4561,-1.0325,-0.22382,0.46931,0.95065,0.87364,0.79662,0.66185,0.46931,0.45006,0.58483,0.6811,1.201,1.3165,1.1239,0.58483,0.25752,-0.069795,-0.47412:1
-0.7956,-1.0977,-1.3092,-1.3998,-1.4905,-1.3998,-1.3696,-0.82581,0.14099,1.0776,1.2589,1.2891,1.0172,0.71503,0.8963,1.1984,1.138,0.92652,0.44312,0.14099,-0.22156,-0.28198,0.11078,-0.16113:2
-0.84235,-1.0613,-1.3532,-1.5722,-1.6452,-1.5722,-0.91533,-1.1343,-0.1855,0.98224,1.2012,0.98224,1.0552,0.76329,0.61732,0.61732,0.76329,0.61732,0.32538,0.17942,-0.33147,1.2742,0.83627,0.39837:2
-0.84186,-1.3353,-1.5546,-1.6917,-1.7465,-1.3079,-1.0063,-0.51288,0.63853,1.3239,1.1868,1.1046,0.80302,0.41922,0.52887,0.50146,0.50146,0.30956,0.22731,0.88526,1.1046,0.72078,0.09024,-0.34839:1
-0.97617,-1.0813,-1.2654,-1.3706,-1.3969,-1.2917,-1.2654,-0.71323,0.39113,1.1274,1.4166,1.2325,1.0485,0.75924,1.18,0.91701,0.91701,0.78554,0.83813,0.18077,-0.37141,-0.3977,-0.10846,-0.55546:2
-1.0738,-1.3536,-1.5284,-1.5809,-1.6159,-1.4585,-1.0039,-0.12968,0.81448,0.91939,1.0068,0.88442,0.88442,0.58719,0.5697,0.76203,0.67461,1.0243,1.0068,0.88442,0.44731,0.16756,-0.16465,-0.72415:1
-0.88052,-1.2613,-1.4789,-1.642,-1.6692,-1.3973,-1.0709,-0.064594,0.72413,1.3769,1.4585,1.2681,1.0233,0.75133,0.66974,0.75133,0.72413,0.42496,0.28897,0.071393,0.016998,0.28897,0.071393,-0.44536:2
-0.67757,-1.2151,-1.3495,-1.5287,-1.6631,-1.3943,-0.99116,-0.90156,-0.050398,1.0696,1.5623,1.4279,1.2487,0.80077,0.71117,0.62157,0.80077,0.26319,0.30799,0.12879,0.17359,0.89036,-0.050398,-0.18479:2
-0.80157,-1.1825,-1.4818,-1.5363,-1.5907,-1.2642,-1.3458,-0.39342,1.1032,1.3481,1.3753,1.2936,0.91268,0.66779,0.64058,0.72221,0.77663,0.34126,0.178,-0.36621,0.014739,0.58616,0.36847,-0.36621:2
0.94223,0.011085,-0.38798,-0.92006,-0.92006,-0.65402,-0.25496,-1.8512,-0.92006,0.011085,0.67619,0.011085,0.14411,0.011085,-0.521,-0.521,-0.521,-0.38798,-0.38798,-0.25496,0.54317,2.8045,1.8734,1.4743:2
-0.27346,-0.8612,-1.253,-1.4,-1.6449,-1.6938,-1.0571,-0.077549,0.41223,1.4898,1.4898,1.1959,0.951,-0.27346,-0.077549,-0.12653,-0.12653,-0.32244,-0.22448,0.21632,1.5877,1.2938,0.7061,0.069386:2
-0.85276,-1.2858,-1.459,-1.661,-1.5456,-1.3724,-1.3146,-0.2177,0.79263,1.3122,1.37,1.2834,0.96582,0.67716,0.76376,0.73489,0.64829,0.35963,0.070963,0.2153,0.01323,0.67716,0.24416,-0.41977:2
-0.041466,-0.63857,-1.1362,-1.3352,-1.5342,-1.3352,-1.783,-1.0864,0.45612,1.7001,1.7996,1.5011,1.2025,0.45612,0.008293,0.15757,0.008293,0.008293,0.058052,0.25709,0.058052,0.20733,0.75468,0.25709:2
-0.73113,-1.3102,-1.455,-1.5419,-1.5129,-1.455,-1.2234,-0.93382,0.10858,1.122,1.2089,1.1799,1.0931,0.65874,0.77456,0.91934,0.97725,0.54292,0.31127,0.16649,0.68769,0.57187,0.13754,-0.29679:2
-0.46688,-1.0056,-1.3647,-1.4725,-1.652,-1.4725,-1.0415,-0.14366,0.32323,1.3647,1.5084,1.1852,0.68237,0.071828,-0.21548,-0.10774,-0.17957,-0.071828,1.1492,1.5084,1.1133,0.68237,0.071828,-0.46688:1
-1.012,-1.3305,-1.5429,-1.6225,-1.7818,-1.4633,-0.79965,-0.37494,0.76647,1.2443,1.4301,1.1381,0.92573,0.47448,0.55411,0.76647,0.66029,0.47448,0.26213,0.15595,0.049771,0.8461,0.3683,-0.18913:2
-0.76312,-1.2041,-1.4099,-1.5569,-1.4687,-1.4687,-1.5275,-0.49854,0.67738,1.2359,1.2359,1.4417,0.58918,0.58918,0.76557,1.0008,0.88316,0.67738,0.55979,0.3246,0.001225,-0.057571,0.23641,-0.26336:2
-0.87404,-1.2174,-1.4671,-1.4671,-1.4671,-1.4359,-1.1238,-0.5931,0.53066,1.2174,1.2486,1.2174,0.96768,0.74917,0.8116,0.90525,1.0925,0.93647,0.49945,0.28094,-0.031216,-0.28094,0.093647,-0.5931:2
-0.84554,-1.1782,-1.3294,-1.4806,-1.5109,-1.3294,-1.2084,-0.48262,0.33393,1.2412,1.3924,1.3319,1.3319,0.84806,0.84806,0.96903,0.81781,0.75733,0.33393,0.031503,-0.27092,-0.33141,0.091988,-0.36165:2
-1.0149,-1.4683,-1.5439,-1.6195,-1.5943,-1.3676,-1.1912,0.017842,0.62239,1.0002,1.2269,1.2017,1.0254,0.49644,0.44606,0.5972,0.64758,0.47125,0.47125,0.84909,0.8239,0.3453,0.16898,-0.61189:1
0.96975,0.2445,-0.15109,-0.61262,-0.74448,-0.74448,-1.7335,-1.6675,-0.94228,0.2445,0.70602,0.77195,0.83789,0.2445,-0.21703,-0.41482,-0.61262,-0.61262,-0.61262,-0.21703,0.2445,0.50823,2.3543,2.1565:2
-1.0989,-1.3406,-1.5824,-1.6044,-1.6044,-1.4945,-0.94503,0.15384,0.79119,1.2307,1.2527,0.94503,0.85712,0.48351,0.54944,0.54944,0.57142,0.48351,0.54944,1.0329,0.70328,0.37362,-0.21978,-0.63735:1
-0.90783,-1.2405,-1.4345,-1.5177,-1.5177,-1.3791,-1.3236,-0.71379,0.53361,1.2543,1.3098,1.3098,1.0048,0.69993,0.75537,0.92169,0.92169,0.58905,0.47817,0.28413,-0.07623,-0.07623,0.25641,-0.13167:2
-0.49571,-1.03,-1.4574,-1.5287,-1.5999,-1.4931,-1.0656,0.038588,0.53726,1.214,1.4634,1.1428,0.64412,0.14545,-0.24637,-0.13951,-0.17513,-0.068271,0.6085,1.6771,1.2853,0.75098,0.14545,-0.35323:1
-1.0242,-1.3848,-1.5513,-1.6068,-1.6622,-1.5513,-1.1351,-0.053173,0.69587,1.0843,1.1952,1.0565,0.91781,0.52942,0.52942,0.75136,0.69587,0.41845,0.25199,0.50168,0.86233,0.69587,0.19651,-0.41383:2
-0.52578,-1.0825,-1.3423,-1.6763,-1.6021,-1.6021,-1.0825,-0.34021,0.2165,0.36496,0.84744,0.84744,0.66187,0.25361,-0.19176,-0.0433,0.030929,0.58764,1.5897,1.7753,1.1815,0.92167,0.29073,-0.080414:1
-0.267,-0.73382,-1.0733,-1.2006,-1.2855,-1.2006,-0.90357,-0.52163,-0.86113,-0.097253,0.45444,0.32712,0.36956,-0.054815,-0.30944,-0.47919,-0.47919,-0.13969,1.5154,2.1519,1.8124,1.5154,1.091,0.36956:1
-0.983,-1.3098,-1.5773,-1.6961,-1.6664,-1.3693,-1.1019,-0.21047,0.38379,0.97805,1.2455,1.186,0.8592,0.56207,0.74035,0.74035,0.8592,0.44322,0.20551,0.23523,1.0969,0.71063,-0.032189,-0.2996:2
-0.90651,-1.2468,-1.3829,-1.451,-1.5417,-1.3829,-1.451,-0.54353,0.54542,1.0672,1.3621,1.2487,1.0899,0.79497,0.70422,0.79497,1.0445,0.84034,0.38661,0.25049,0.046318,-0.021741,0.069004,-0.31666:2
-1.0853,-1.4034,-1.497,-1.5906,-1.5719,-1.4409,-1.0666,-0.22455,0.50524,1.0292,1.1602,1.0105,0.8982,0.54267,0.52395,0.67365,0.61752,0.63623,1.0853,1.0105,0.61752,0.28069,-0.093563,-0.61752:1
-0.93176,-1.2461,-1.4706,-1.6053,-1.6502,-1.4706,-1.0216,-1.1563,0.011226,0.72969,0.95422,1.044,0.99912,0.63989,0.72969,0.7746,0.7746,0.99912,0.55008,0.28065,0.32556,1.044,0.55008,0.14594:2
-0.92451,-1.3374,-1.4476,-1.6403,-1.6403,-1.4476,-1.1172,-0.29135,0.75475,1.4154,1.3879,1.2227,0.91992,0.58957,0.50699,0.75475,0.6171,0.34181,0.25923,0.17664,0.25923,0.78227,0.20417,-0.3464:2
-1.0253,-1.2964,-1.4998,-1.6127,-1.5901,-1.4546,-1.0705,-0.076259,0.6016,1.1891,1.1439,0.98572,0.75977,0.33046,0.35305,0.35305,0.35305,0.46603,1.2569,1.2569,0.78236,0.46603,-0.14405,-0.52817:1
-0.86321,-1.1502,-1.3329,-1.3851,-1.4372,-1.4111,-1.5155,-0.49792,0.59794,1.2763,1.3807,1.0676,0.80668,0.67622,0.67622,0.96323,1.4068,0.78059,0.46748,0.23265,-0.2631,-0.2631,0.10219,-0.31528:2
-1.1697,-1.3485,-1.4602,-1.5273,-1.5496,-1.4602,-1.0132,-0.1192,0.48426,1.0877,1.1101,0.97598,0.75247,0.41721,0.30546,0.48426,0.48426,0.84187,1.4006,1.1771,0.59602,0.30546,-0.20861,-0.56622:1
0.96292,-0.008092,-0.52596,-0.91437,-0.9791,-0.84963,-0.84963,-1.5617,-1.1733,-0.52596,0.25084,0.44505,0.38031,-0.20229,-0.20229,-0.13756,-0.33176,-0.46123,-0.33176,-0.008092,1.0924,2.5165,1.9987,1.4161:2
-1.0454,-1.2125,-1.5745,-1.6859,-1.7416,-1.4631,-0.87834,-0.15432,0.82033,0.90387,0.98741,0.90387,0.82033,0.29123,0.12415,0.29123,0.54186,0.70894,1.3494,1.2659,0.70894,0.37477,0.04061,-0.3771:1
-0.67412,-1.2087,-1.462,-1.5464,-1.6308,-1.4901,-1.0399,-0.19579,1.0141,1.2674,1.2674,1.0704,0.53578,0.25441,-0.19579,-0.25206,-0.055102,0.98598,1.0423,1.2111,0.87343,0.50765,0.11372,-0.39275:1
-1.0326,-1.324,-1.5376,-1.6347,-1.557,-1.4016,-1.0715,-0.25573,0.67654,1.0844,1.0456,1.0067,0.85134,0.50174,0.40463,0.54059,0.77366,0.56001,1.1427,1.065,0.6377,0.32694,-0.10035,-0.70244:1
-1.0107,-1.3159,-1.538,-1.7322,-1.5935,-1.4547,-0.9274,0.099447,0.79327,1.3761,1.4871,1.1818,1.0708,0.51574,0.6545,0.599,0.54349,0.34922,0.071695,0.071695,0.26596,0.62675,0.18271,-0.31684:2
-0.70617,-1.0887,-1.3241,-1.5006,-1.5006,-1.4123,-1.4712,-1.0298,0.29424,1.0887,1.177,1.2947,1.1181,0.76502,0.88272,0.94157,1.0298,0.7356,0.52963,0.23539,-0.088272,-0.1177,0.20597,-0.058848:2
0.124,-0.43669,-0.73859,-1.0405,-1.0405,-1.0836,-0.69546,-1.0405,-0.69546,0.16713,0.64155,0.94346,0.16713,-0.17791,-0.52294,-0.65233,-0.65233,-0.73859,-0.39356,1.7198,2.2373,1.806,1.3747,0.72781:1
1.3042,0.76189,-0.090393,-0.24535,-0.47779,-0.55527,-0.55527,-1.64,-1.0202,-0.32283,-0.24535,0.37449,0.29701,-0.47779,-0.55527,-0.78771,-0.63275,-0.63275,-0.78771,0.064567,0.29701,1.0718,2.6214,2.234:2
-0.27109,-0.7828,-1.258,-1.3676,-1.5138,-1.5138,-1.1849,-0.67315,-1.0387,-0.12488,0.38683,0.67924,0.9351,0.35028,0.16753,-0.051781,-0.051781,0.24063,1.3372,1.6661,1.6296,1.3006,0.75234,0.38683:1
1.1183,0.36226,-0.015751,-0.46937,-0.46937,-0.46937,-1.9058,-1.679,-0.77178,-0.015751,0.43787,0.66467,0.58907,0.059852,-0.46937,-0.46937,-0.39376,-0.54497,-0.62057,-0.54497,0.28666,0.74028,2.6303,1.9499:2
-1.1573,-1.3377,-1.4923,-1.5953,-1.5953,-1.4923,-1.1058,-0.35857,0.49169,1.0843,1.0585,0.98124,0.72358,0.46593,0.54322,0.64628,0.62052,0.41439,0.36286,1.4708,0.85241,0.59475,0.10521,-0.28127:1
-1.0674,-1.3016,-1.4998,-1.5899,-1.5539,-1.4638,-1.1035,-0.31077,0.77018,0.96835,1.0584,0.98637,0.87827,0.53597,0.572,0.69812,0.84224,0.98637,1.0404,0.84224,0.3378,0.19367,-0.23871,-0.58101:1
-0.96468,-1.3032,-1.5376,-1.6678,-1.6678,-1.5376,-1.173,0.024958,0.59791,0.98856,1.0406,0.88438,0.88438,0.41561,0.67604,0.46769,0.54582,0.28539,0.41561,1.3271,0.88438,0.75417,0.10309,-0.44382:1
-1.1109,-1.3683,-1.4712,-1.6256,-1.6771,-1.5227,-1.1366,-0.1587,0.40747,0.92218,0.84497,0.81924,0.51042,0.38174,0.43321,0.61336,0.74203,0.51042,0.30453,1.3854,1.1795,0.89644,0.40747,-0.28738:1
-0.85757,-1.2819,-1.5472,-1.5472,-1.5737,-1.6798,-1.0432,-0.40668,0.70728,1.3438,1.3969,1.2377,0.89294,0.65423,0.46857,0.62771,0.60119,0.389,0.28291,0.1503,-0.008841,0.91946,0.41553,-0.14146:2
-0.71317,-0.97708,-1.3164,-1.4295,-1.4672,-1.3918,-0.97708,-0.86398,0.19165,1.285,1.4735,1.4735,1.2096,0.87026,0.83256,0.98336,0.98336,0.68176,0.26705,0.003142,-0.48697,-0.48697,0.11624,-0.26076:2
-1.0207,-1.2982,-1.4765,-1.5756,-1.5756,-1.4567,-1.2387,-0.26756,0.38647,0.74322,0.96123,0.96123,0.76304,0.56485,0.50539,0.68376,0.92159,1.2783,1.1,0.98105,0.52521,0.2081,-0.22792,-0.44593:1
-1.0311,-1.3056,-1.559,-1.559,-1.6435,-1.4534,-1.0522,-0.038711,0.57363,1.0804,1.1015,1.0382,0.6792,0.36248,0.34136,0.44694,0.48917,0.44694,1.3127,1.2071,0.76366,0.46805,-0.10206,-0.56659:1
-1.1118,-1.3635,-1.5146,-1.5817,-1.5649,-1.481,-1.0111,-0.35662,0.71743,0.90203,1.0027,0.93559,0.86846,0.53283,0.56639,0.76777,0.76777,1.0531,1.0363,0.86846,0.48248,0.21397,-0.15523,-0.57478:1
-0.96316,-1.3154,-1.4637,-1.4637,-1.5193,-1.5193,-1.4822,-0.14753,0.4642,0.85348,0.85348,0.92763,0.87202,0.63104,0.6125,0.64957,0.59396,1.1872,1.0945,1.0389,0.51981,0.29737,-0.16606,-0.55534:1
-0.78224,-1.1811,-1.409,-1.5229,-1.5514,-1.4375,-1.4944,-0.69677,0.38578,0.98403,1.2689,1.3544,0.92705,0.55671,0.75612,0.95554,1.041,0.72763,0.61368,0.47124,0.12938,0.043919,0.072407,-0.21247:2
-1.0117,-1.3137,-1.5904,-1.6408,-1.6408,-1.4898,-1.0117,0.070244,0.62381,1.2277,1.1774,1.127,0.90059,0.39735,0.47283,0.47283,0.42251,0.2967,0.2967,1.3283,0.8251,0.47283,-0.13105,-0.28202:1
-0.99784,-1.328,-1.4834,-1.5805,-1.5999,-1.4834,-1.1726,-0.1044,0.45886,1.0027,1.0415,1.0027,0.80847,0.42001,0.45886,0.55597,0.61424,1.1969,1.1386,0.98327,0.53655,0.20637,-0.1044,-0.57054:1
-0.80532,-1.2261,-1.5267,-1.6169,-1.647,-1.4065,-1.0758,-0.62497,0.69761,1.3589,1.4491,1.3288,0.90802,0.36697,0.66755,0.75773,0.57738,0.4872,0.21667,0.27679,0.42708,0.66755,0.1265,-0.3845:2
-0.65192,-1.2157,-1.4976,-1.6386,-1.4976,-1.4272,-0.93383,-0.93383,0.052858,0.96906,1.251,1.251,1.251,0.82811,0.5462,0.5462,0.47572,0.40525,-0.088097,0.052858,-0.29953,1.3919,0.82811,0.33477:2
0.27847,-0.14926,-0.63045,-1.0582,-1.2186,-1.0582,-0.84431,-1.4859,-0.79085,0.17154,0.70619,0.81312,0.75966,0.17154,-0.41659,-0.41659,-0.57698,-0.57698,-0.25619,-0.095793,0.92006,2.4171,1.8824,1.4547:2
-0.52194,-0.86798,-1.3178,-1.5255,-1.5601,-1.3524,-1.1794,-0.79877,-0.1067,0.13553,0.65459,0.79301,0.58538,0.20474,-0.24511,-0.1759,-0.1067,0.44697,1.4505,1.6927,1.6235,1.2429,0.82761,0.10093:1
-1.0002,-1.3149,-1.5877,-1.6087,-1.6087,-1.3988,-0.97918,-0.20283,0.76236,1.182,1.2659,0.99317,0.74138,0.34271,0.3637,0.40566,0.46861,0.48959,1.14,1.0981,0.76236,0.40566,-0.1189,-0.6015:1
-0.80402,-1.1367,-1.3862,-1.5803,-1.6635,-1.4417,-1.5803,-0.58222,0.47132,1.0258,1.2753,1.2476,0.97037,0.6654,0.77629,0.85947,0.91492,0.69312,0.3327,0.16635,0.083174,0.24952,0.49905,-0.05545:2
-0.45089,-1.0606,-1.4797,-1.5559,-1.5559,-1.3654,-0.94624,-0.10796,0.42549,1.1876,1.3781,0.95895,0.84463,0.19687,-0.22227,-0.18417,-0.33658,-0.14606,0.31118,1.7972,1.4543,0.95895,0.19687,-0.29848:1
-1.0152,-1.2846,-1.4503,-1.5539,-1.5539,-1.4503,-1.2224,-0.20719,0.51798,0.9738,1.1188,0.93236,0.82876,0.51798,0.55942,0.64229,0.55942,0.66301,1.1603,1.2639,0.62157,0.29007,-0.18647,-0.72517:1
-1.1305,-1.3993,-1.601,-1.601,-1.5786,-1.4441,-0.95124,-0.27912,0.54983,1.1099,1.1547,1.0875,0.9083,0.54983,0.52743,0.61705,0.50503,0.3482,0.30339,1.1771,0.88589,0.63945,0.056944,-0.43595:1
-0.77428,-1.1934,-1.4729,-1.566,-1.566,-1.5195,-1.0537,-0.96057,0.15718,1.0421,1.2284,1.2749,0.9955,0.85578,0.85578,0.90236,0.9955,0.62292,0.4832,0.017465,-0.26197,0.34348,0.4832,0.11061:2
-1.0955,-1.3845,-1.5702,-1.6115,-1.6321,-1.3638,-1.013,-0.063634,0.8238,1.154,1.0921,0.94763,0.80316,0.32849,0.32849,0.43168,0.51423,0.59678,1.1953,1.1127,0.69997,0.26657,-0.042996,-0.51767:1
-0.88808,-1.2536,-1.591,-1.6754,-1.6473,-1.5348,-1.1411,0.039835,0.79904,1.4458,1.3052,1.0521,0.77092,0.43349,0.51785,0.65844,0.65844,0.32102,0.20855,0.20855,0.43349,0.93963,0.2929,-0.35383:2
-0.79329,-1.2663,-1.6506,-1.6506,-1.6802,-1.4437,-0.91155,-0.52722,0.68489,1.217,1.4536,1.217,0.9214,0.56664,0.65533,0.68489,0.71446,0.53707,0.271,0.034491,0.15275,0.83271,0.21187,-0.23158:2
-0.85547,-1.3305,-1.4888,-1.6472,-1.6208,-1.5152,-1.1458,-0.35406,0.70153,1.2557,1.3613,1.3349,0.99182,0.54319,0.62236,0.70153,0.62236,0.41124,0.27929,0.20012,0.22651,0.72792,0.20012,-0.22211:2
0.80063,0.20481,-0.53996,-0.61444,-0.53996,-0.61444,-2.104,-1.5082,-1.0613,-0.46548,0.72615,1.0241,0.80063,0.27929,-0.093096,-0.24205,-0.31653,-0.39101,-0.61444,-0.093096,0.50272,0.5772,2.4391,1.8433:2
-0.97139,-1.2254,-1.3665,-1.4512,-1.5077,-1.3948,-1.3101,-0.80205,0.29871,1.0325,1.2019,1.2019,1.2019,0.89142,0.94787,0.91965,1.0608,0.66563,0.46806,0.21404,-0.18111,-0.12466,0.29871,-0.068209:2
-0.99866,-1.318,-1.5175,-1.6173,-1.5974,-1.4577,-1.0785,-0.040745,0.75752,1.1566,1.0768,1.1367,0.97704,0.55795,0.53799,0.45817,0.43821,0.33843,1.0569,1.0369,0.61782,0.29852,-0.22035,-0.59953:1
-1.0443,-1.3474,-1.4042,-1.5558,-1.6126,-1.4232,-1.0443,-0.30547,0.37651,1.0964,1.0964,1.0206,0.92588,0.52806,0.47123,0.52806,0.66066,1.1343,1.0964,0.96376,0.56595,0.16813,-0.26758,-0.62751:1
-0.076843,-0.50243,-1.0699,-1.3063,-1.4482,-1.2117,-1.0226,-0.45514,-0.69158,0.017733,0.49061,0.67976,0.77434,0.25417,-0.31328,-0.31328,-0.54972,-0.59701,-0.26599,1.862,1.862,1.5782,1.4837,0.82162:1
-1.0982,-1.4571,-1.6366,-1.6142,-1.5469,-1.4123,-1.1431,0.18039,0.51687,1.1674,1.1898,0.98793,0.80848,0.49443,0.44957,0.44957,0.42714,0.33741,0.49443,1.145,0.8982,0.65146,0.18039,-0.47013:1
-0.71036,-1.0106,-1.3109,-1.4443,-1.5111,-1.4443,-0.97726,0.19045,1.2247,1.3582,1.5583,1.2581,0.72426,0.25717,-0.24327,-0.31,-0.31,-0.41009,0.023632,1.5583,1.0245,0.62417,0.12372,-0.24327:1
-0.87267,-1.2165,-1.4457,-1.5603,-1.5603,-1.4744,-1.417,-0.55751,0.30203,0.98967,1.2189,1.2189,0.96102,0.84641,0.58855,1.0183,1.0183,0.84641,0.50259,0.18743,-0.041783,-0.013132,0.44529,0.01552:2
-0.57586,-1.0682,-1.3847,-1.4902,-1.4902,-1.3847,-1.033,0.021979,0.51432,0.69015,1.499,1.1825,0.61982,0.057146,-0.29452,-0.32969,-0.22419,-0.22419,1.3583,1.6748,1.2528,0.79565,0.26815,-0.43519:1
-1.1104,-1.3464,-1.518,-1.6038,-1.6468,-1.4966,-1.0674,-0.037548,0.56322,1.1854,1.164,0.97089,0.77778,0.45594,0.49885,0.52031,0.56322,0.43449,0.64905,1.1854,0.86361,0.54177,-0.037548,-0.50958:1
-0.91313,-1.2642,-1.3895,-1.5901,-1.54,-1.3394,-1.3895,-0.78776,0.41582,1.0427,1.143,1.0928,0.99253,0.71671,0.86716,0.99253,1.0678,0.74179,0.59134,0.44089,-0.010448,-0.010448,0.34059,-0.21104:2
0.81368,-0.16929,-0.89014,-0.89014,-1.0212,-1.0867,-0.89014,-1.1523,-0.49695,0.81368,0.81368,1.2069,1.1413,0.027305,-0.49695,-0.43142,-0.69354,-0.82461,-0.75907,-0.23482,0.35496,2.583,1.6001,0.68262:2
-0.46798,-0.90416,-1.2313,-1.3767,-1.5584,-1.3767,-1.2313,-0.75877,-0.83146,-0.24989,0.47707,0.91325,0.94959,0.36802,0.004544,-0.031805,0.14994,0.47707,1.2767,1.7129,1.6039,1.1677,0.69516,0.22263:1
-1.0858,-1.3644,-1.5144,-1.6001,-1.6001,-1.4287,-1.0001,0.007143,0.80004,1.1858,1.1858,1.0572,0.80004,0.39288,0.30716,0.41431,0.43574,0.37145,1.1858,1.0572,0.75718,0.32859,-0.12144,-0.57146:1
-1.1179,-1.4191,-1.5051,-1.6342,-1.6557,-1.5051,-1.0103,0.043926,0.47422,1.0336,1.0551,0.96906,0.83997,0.49573,0.40967,0.60331,0.53876,0.58179,0.81845,1.2487,0.79694,0.4527,-0.020618,-0.49394:1
-0.32031,-0.84882,-1.2812,-1.4254,-1.3773,-1.4254,-0.94491,0.40039,0.68867,1.7457,1.8898,1.6496,0.88085,0.16015,-0.27226,-0.46445,-0.32031,-0.56054,-0.32031,-0.12812,0.35234,1.2652,0.59257,0.064062:2
-0.92156,-1.2833,-1.4383,-1.5158,-1.5934,-1.5417,-1.4642,-0.68902,0.65457,1.0421,1.1713,1.1455,0.88711,0.78376,0.88711,0.86127,0.70624,0.55121,0.42202,0.42202,0.24116,0.34451,0.37035,-0.043064:2
-0.93963,-1.3514,-1.5385,-1.5385,-1.5572,-1.4449,-1.1455,-0.22847,0.78211,0.8944,1.0067,0.93183,0.74469,0.44525,0.46397,0.52011,0.65111,1.2874,1.25,0.95055,0.42654,0.18325,-0.20976,-0.58405:1
-0.49342,-1.0647,-1.2206,-1.5322,-1.4803,-1.2725,-0.96087,-0.85699,0.5973,1.2725,1.5841,1.688,1.5322,0.80505,0.54536,0.70117,0.64923,0.38954,0.12985,-0.12985,-0.64923,0.12985,0.025969,-0.38954:2
-1.0287,-1.2848,-1.4897,-1.6177,-1.5665,-1.3872,-1.1055,-0.38842,0.61038,1.225,1.1994,1.0457,0.86648,0.37988,0.4311,0.45671,0.61038,0.37988,0.25183,1.3531,0.99453,0.58477,-0.004268,-0.51647:1
-0.097203,-0.85896,-1.2874,-1.5255,-1.4779,-1.1922,-1.0494,-0.5733,0.71216,1.6644,1.9976,1.4739,0.95021,0.18846,-0.14481,-0.24003,-0.28764,-0.33525,-0.28764,-0.049594,0.37889,1.3311,0.75977,-0.049594:2
-0.13726,-0.85101,-1.4,-1.4549,-1.6197,-1.4549,-0.96081,-0.30197,0.35687,1.4549,1.6746,1.5648,1.0157,0.30197,-0.082356,-0.19216,-0.082356,-0.19216,-0.24707,-0.027452,1.5099,1.0157,0.46668,-0.35687:2
-0.976,-1.356,-1.5348,-1.5795,-1.6465,-1.4454,-1.0878,-0.081954,0.63328,1.0803,1.1027,1.0803,0.72269,0.34272,0.38742,0.40977,0.47682,0.36507,1.1921,1.2815,0.76739,0.43212,-0.059603,-0.50663:1
-1.1467,-1.3062,-1.4857,-1.5655,-1.5455,-1.386,-1.1267,-0.18945,0.60824,0.98714,1.0868,0.9672,0.688,0.38887,0.3091,0.42876,0.66806,1.1666,1.2464,1.1068,0.54841,0.3091,-0.18945,-0.56835:1
-0.70616,-1.1075,-1.4779,-1.6323,-1.6323,-1.4471,-0.79877,-0.15049,0.96084,1.1461,1.1461,0.8991,0.71388,0.09647,-0.088753,0.003859,0.12734,0.8991,1.4548,1.3622,0.92997,0.15821,-0.24311,-0.61355:1
-0.64109,-1.0392,-1.3521,-1.4374,-1.4374,-1.4374,-1.608,-0.81173,0.5534,1.1222,1.236,1.2644,1.0938,0.80936,0.80936,1.0938,0.98,0.63872,0.52496,0.269,-0.18605,-0.27137,-0.043845,-0.12917:2
-1.0489,-1.3996,-1.5103,-1.5472,-1.5842,-1.4181,-1.0858,-0.12612,0.79669,1.0366,1.092,1.1658,0.88898,0.42757,0.42757,0.51985,0.64904,0.75978,1.1658,0.85206,0.48294,0.26146,-0.12612,-0.67981:1
-1.1347,-1.3975,-1.5795,-1.6401,-1.6401,-1.4784,-0.87187,-0.063179,0.30073,0.88703,0.9679,0.86682,0.68486,0.36138,0.42204,0.58377,0.74551,1.0083,1.2712,1.0286,0.7253,0.50291,-0.083396,-0.46752:1
0.43001,0.007544,-0.53562,-0.89773,-1.0184,-0.83738,-0.53562,-0.052808,-0.53562,0.36965,0.79212,0.43001,0.007544,-0.17351,-0.53562,-0.89773,-1.0788,-1.1391,-0.83738,-0.29421,1.3353,2.4216,1.9388,1.637:1
-1.0021,-1.2392,-1.4762,-1.5553,-1.6079,-1.5026,-1.2128,-0.080122,0.78915,1.316,1.3687,1.316,0.99988,0.57842,0.55208,0.52573,0.60476,0.13061,0.13061,0.26232,0.89452,0.47305,0.13061,-0.39622:2
-1.1992,-1.4228,-1.5651,-1.6261,-1.5651,-1.4432,-1.0366,-0.020326,0.65043,1.0773,1.057,0.97565,0.79272,0.42685,0.48783,0.5488,0.52848,0.4675,1.0366,1.1383,0.73174,0.48783,-0.10163,-0.42685:1
-0.97678,-1.3215,-1.6203,-1.6893,-1.5973,-1.5054,-1.0687,0.057458,0.74695,1.0917,1.0917,1.0457,0.83889,0.42519,0.49414,0.49414,0.44817,0.47115,0.74695,1.2066,0.8159,0.37922,-0.14939,-0.42519:1
-1.0705,-1.3322,-1.5415,-1.5938,-1.5938,-1.5938,-1.088,-0.21585,0.51673,1.0574,1.0051,1.04,0.90046,0.44696,0.56906,0.67371,0.77836,0.77836,0.98767,0.90046,0.53417,0.34231,-0.07631,-0.42516:1
-0.34716,-0.92176,-1.2809,-1.3886,-1.6759,-1.4964,-1.1013,-0.70628,-0.77811,0.011971,0.76614,0.87387,0.76614,0.29927,-0.13168,-0.095767,-0.059854,1.2689,1.2689,1.5203,1.4126,1.0534,0.62249,0.11971:1
-1.0169,-1.2735,-1.498,-1.4339,-1.4659,-1.5301,-1.2414,-0.18307,0.39421,1.2922,1.4526,1.3243,0.87528,0.55457,0.65078,0.747,0.747,0.42628,0.16971,0.041426,0.84321,0.61871,0.10557,-0.6:2
-0.98044,-1.5527,-1.5748,-1.6408,-1.5968,-1.3987,-1.0025,-0.011923,0.51636,0.95659,1.0006,0.86855,0.67044,0.42831,0.36228,0.42831,0.42831,0.58239,1.3528,1.2207,0.80251,0.53837,0.12015,-0.51819:1
-0.17213,-0.65344,-0.8941,-1.215,-1.2551,-1.215,-1.0545,-1.4556,-0.85399,-0.25235,0.50972,0.79048,0.83059,0.30917,-0.051807,-0.051807,-0.25235,-0.33257,0.10863,1.6328,1.9536,1.7531,1.1515,0.67015:1
-0.7861,-1.25,-1.2758,-1.4304,-1.4047,-1.4047,-1.6109,-0.65723,0.39949,1.25,1.1727,1.25,0.73455,0.91496,0.94074,1.0438,1.0954,0.7861,0.42526,0.1933,-0.1933,-0.24485,0.14175,-0.090208:2
-0.67781,-1.2811,-1.5022,-1.6028,-1.6832,-1.5224,-1.2006,-0.25554,0.72976,1.1922,1.1922,1.1319,0.93084,0.44824,0.52868,0.56889,0.589,0.589,0.93084,0.97106,0.46835,0.22705,-0.29576,-0.47673:1
-1.0676,-1.3598,-1.5397,-1.5846,-1.6296,-1.3374,-1.0901,0.23601,0.55068,1.0227,1.0002,0.93279,0.7305,0.30344,0.30344,0.4383,0.39334,0.55068,1.4048,1.3149,0.8204,0.34839,-0.16858,-0.57316:1
-0.66183,-0.9647,-1.3349,-1.4358,-1.5368,-1.3012,-1.0993,-0.72914,0.38139,1.2227,1.4583,1.4919,1.2227,0.81888,1.0208,0.91983,0.91983,0.54966,0.38139,0.17948,-0.45992,-0.35896,-0.1907,-0.49357:2
0.52937,-0.18254,-0.40159,-1.0587,-1.1135,-1.1135,-0.94922,-1.5516,-0.78493,0.2008,0.80319,0.80319,0.6389,0.14603,-0.29207,-0.23731,-0.51112,-0.56588,-0.67541,-0.18254,0.74842,2.3365,2.008,1.4056:2
0.48236,-0.24468,-0.63616,-0.85986,-1.1954,-1.2513,-1.0276,-1.7547,-0.91579,-0.076898,0.65014,0.70606,0.76199,0.09088,-0.13282,-0.24468,-0.3006,-0.46838,-0.35653,0.31458,0.92977,2.3279,1.7687,1.4331:2
-1.0087,-1.4895,-1.5472,-1.5664,-1.5472,-1.4125,-1.0472,-0.23956,0.395,1.0103,0.99111,1.0103,0.89496,0.56806,0.54883,0.58729,0.68344,1.0488,1.068,0.97188,0.49115,0.29885,-0.047272,-0.66261:1
-0.92215,-1.2532,-1.406,-1.5843,-1.6098,-1.406,-1.075,-0.64201,0.50405,1.2681,1.4718,1.2936,1.1917,0.86061,0.68233,0.7078,0.58046,0.52952,0.19844,0.1475,0.17297,0.58046,-0.005306,-0.28545:2
-0.95392,-1.382,-1.4565,-1.4937,-1.5681,-1.5495,-1.1587,-0.28385,0.60958,1.1866,1.1307,1.1866,0.90739,0.47929,0.57235,0.66542,0.55374,0.75848,1.0377,0.90739,0.38622,0.18148,-0.22801,-0.48859:1
-0.91664,-1.3745,-1.5338,-1.494,-1.5736,-1.5338,-1.1755,-0.21983,0.45708,0.97471,1.1141,1.134,0.99462,0.57653,0.53671,0.71589,0.93489,0.75571,0.61635,0.99462,0.53671,0.31771,-0.23974,-0.5981:1
-1.099,-1.3556,-1.5389,-1.5572,-1.6305,-1.4289,-1.1356,-0.27417,0.82558,1.1188,1.0272,0.95388,0.78892,0.51398,0.60563,0.69727,0.78892,0.69727,1.0272,0.88056,0.47732,0.22071,-0.12754,-0.47579:1
-0.68329,-1.1097,-1.4704,-1.5688,-1.5688,-1.4704,-1.0113,-0.78168,0.30065,1.219,1.3174,1.4158,1.0878,0.79262,0.79262,0.85821,0.9894,0.75982,0.39904,0.23505,-0.19132,-0.25692,0.13666,-0.19132:2
-0.59339,-0.88804,-1.3464,-1.5101,-1.5756,-1.5428,-1.1172,-0.20053,0.51973,1.1418,1.4692,1.3709,0.87986,0.25782,-0.23326,-0.036831,-0.10231,-0.20053,0.78164,1.5674,1.109,0.71616,0.028646,-0.49517:1
-0.72974,-1.1081,-1.3243,-1.3514,-1.5135,-1.3514,-1.5946,-0.7838,0.24325,1.1081,1.1081,1.2703,1.1892,0.75677,0.83785,0.86488,1.2162,0.94596,0.51352,0.24325,-0.21622,-0.16216,0.054055,-0.21622:2
-0.89737,-1.3382,-1.4851,-1.758,-1.6111,-1.4851,-1.1493,-0.14169,0.61399,1.0968,1.0548,0.94985,0.86588,0.3621,0.42507,0.48804,0.48804,0.48804,1.1178,1.1598,0.80291,0.42507,-0.057725,-0.41457:1
-0.9862,-1.3011,-1.5434,-1.6161,-1.6645,-1.398,-1.0831,-0.01716,0.7823,1.291,1.3395,1.2184,0.8792,0.44313,0.37046,0.49159,0.39468,0.10397,0.20087,1.0488,0.90343,0.46736,0.10397,-0.429:1
-0.6749,-1.1546,-1.465,-1.5215,-1.6061,-1.4932,-1.5497,-0.56202,0.62316,1.3286,1.2722,1.2722,0.99,0.59494,0.62316,0.82069,0.79247,0.56672,0.25632,0.34098,0.058789,0.36919,0.34098,-0.2234:2
0.10057,-0.537,-1.2201,-1.5389,-1.5389,-1.4934,-1.0835,-0.58254,-0.44592,0.28273,0.51043,0.41935,0.6926,0.14611,-0.3093,-0.40038,-0.3093,0.14611,1.3302,1.9677,1.6945,1.4668,0.6926,0.009488:1
-0.24112,-0.76354,-1.085,-1.4467,-1.4065,-1.4065,-1.0448,-0.96447,-0.32149,-0.44205,0.32149,0.72335,0.76354,0.32149,-0.040186,-0.24112,-0.32149,-0.040186,1.4467,1.9289,1.6075,1.4467,0.84391,0.36168:1
1.7402,0.66319,0.30417,0.30417,-0.2942,-0.05485,0.54352,-1.1319,-1.0122,-0.05485,-0.2942,-0.53354,-0.05485,-0.41387,-0.77289,-0.53354,-1.3713,-0.89256,-0.89256,-0.65322,-0.2942,2.0993,2.2189,1.3812:2
-0.72621,-1.1412,-1.3783,-1.5562,-1.5858,-1.5265,-1.0523,-0.25195,0.90406,1.1708,1.2005,0.90406,0.51872,-0.044462,-0.13339,-0.16303,-0.10374,0.81513,1.1708,1.4376,1.0819,0.69657,0.25195,-0.48908:1
-0.92264,-1.3429,-1.5268,-1.6581,-1.6581,-1.448,-1.1328,-0.42356,0.54833,1.3101,1.3101,1.205,0.94234,0.54833,0.60087,0.60087,0.811,0.54833,0.18059,0.36446,0.44326,0.6534,0.25939,-0.21342:2
-1.0177,-1.3788,-1.4213,-1.5912,-1.5699,-1.4425,-1.0177,-0.019469,0.42655,0.89382,0.95754,0.8301,0.68143,0.29912,0.32036,0.36284,0.63895,1.1062,1.4673,1.3186,0.70267,0.29912,-0.21062,-0.63541:1
-0.23854,-0.6996,-1.1222,-1.3144,-1.6602,-1.4296,-1.1222,-0.6996,-0.89171,-0.23854,0.49148,0.60675,0.79886,0.41464,-0.084849,-0.16169,-0.27696,0.14568,1.2983,1.6441,1.6441,1.4905,1.0294,0.37622:1
-1.1491,-1.3924,-1.5487,-1.5661,-1.5661,-1.4271,-1.1317,-0.31496,0.74505,1.0057,1.0231,1.0057,0.81456,0.51915,0.62341,0.72767,0.84931,0.81456,1.0231,0.79718,0.51915,0.18898,-0.19332,-0.36709:1
-0.18421,-1.045,-1.4362,-1.2406,-1.4362,-1.358,-1.0058,-0.77109,0.36354,1.459,1.459,1.3025,0.79392,0.16791,-0.34072,-0.26247,-0.26247,-0.18421,0.050537,1.6938,1.4199,0.87217,0.16791,-0.22334:1
-1.1015,-1.2969,-1.5314,-1.59,-1.6291,-1.4142,-1.1015,-0.10503,0.5984,1.0087,0.95011,0.83288,0.77426,0.36392,0.38346,0.42254,0.55932,1.2627,1.2823,1.0674,0.55932,0.28577,-0.10503,-0.47628:1
-0.42238,-0.69426,-1.3157,-1.4711,-1.5487,-1.4711,-1.0438,-0.81078,-0.42238,0.31557,0.43209,0.70397,0.78165,0.27673,-0.26702,-0.18934,-0.30586,0.19905,1.3642,1.675,1.6361,1.4808,0.78165,0.31557:1
-0.82269,-1.315,-1.5741,-1.7037,-1.7037,-1.3927,-0.97816,-0.12308,0.62835,1.4316,1.4834,1.1984,0.88747,0.732,0.60244,0.62835,0.57653,0.36924,0.36924,0.13604,0.23968,0.57653,0.18786,-0.43402:2
-0.84355,-1.2736,-1.5051,-1.5713,-1.6375,-1.4059,-0.97587,-0.31426,0.7443,0.87663,1.2074,1.1413,0.81047,0.34734,0.31426,0.21502,0.21502,0.67814,1.4721,1.2074,0.81047,0.2481,-0.18194,-0.5789:1
-0.36283,-0.92144,-1.3815,-1.5458,-1.6444,-1.5458,-1.0857,-0.6257,0.42581,1.2144,1.4773,1.313,0.88584,0.39295,-0.067089,-0.099948,-0.001369,0.06435,0.22865,1.5102,1.2144,0.72155,0.22865,-0.39569:1
-0.75034,-1.1185,-1.4253,-1.3639,-1.4866,-1.3639,-1.5173,-0.68898,0.53815,1.2744,1.3665,1.4585,1.1517,0.84493,0.69154,0.66086,0.84493,0.7529,0.41544,0.10865,-0.16745,-0.22881,0.13933,-0.13677:2
-0.46711,-1.3037,-1.6105,-1.6105,-1.6384,-1.4989,-1.1364,-0.60655,0.5926,1.3456,1.2898,1.1782,1.1782,0.56472,0.53683,0.64838,0.70415,0.34162,0.20218,0.25796,0.23007,0.87148,0.23007,-0.29979:2
-0.91691,-1.2358,-1.3953,-1.6185,-1.4272,-1.4591,-1.2358,-0.85313,0.55015,1.2837,1.4112,1.3156,1.0923,0.58204,0.67772,0.70961,0.7734,0.42258,0.16744,-0.087705,0.23122,0.70961,0.3269,-0.023919:2
-1.2292,-1.3939,-1.4763,-1.5998,-1.5175,-1.291,-1.0645,-0.096933,0.78833,1.0766,1.056,1.0354,0.64422,0.39717,0.43834,0.35599,0.47952,1.0354,1.2413,1.1177,0.56187,0.23247,-0.22046,-0.57045:1
-1.1471,-1.3707,-1.4724,-1.5537,-1.635,-1.5334,-1.1471,-0.17113,0.56082,1.0691,1.0691,0.98779,0.76414,0.60149,0.70315,0.64215,0.70315,0.54049,0.45916,1.2114,0.84547,0.31684,-0.069467,-0.37445:1
0.89951,0.005729,-0.81929,-1.6443,-0.61304,-0.88805,-0.81929,-1.3006,-0.54429,0.074481,0.28074,0.48699,0.83075,0.55575,0.28074,0.005729,-0.68179,-0.68179,-1.0256,-0.75054,0.762,2.0683,1.7245,1.7933:2
-0.89837,-1.1736,-1.5635,-1.6553,-1.6553,-1.4947,-1.1736,-0.095571,0.52373,1.2348,1.2577,1.1201,0.89072,0.47785,0.38611,0.50079,0.52373,0.36317,0.66135,1.2577,0.68429,0.36317,-0.11851,-0.41669:1
-0.25295,-1.0118,-1.3747,-1.5067,-1.6386,-1.4407,-1.2097,-0.15397,0.37392,1.0668,1.3307,1.1987,0.86881,0.17596,-0.28594,-0.12097,-0.21995,-0.21995,1.1658,1.6277,1.1328,0.73684,0.17596,-0.41791:1
-0.97287,-1.2501,-1.5059,-1.6339,-1.5912,-1.442,-1.1648,-0.43979,0.54107,0.92489,0.90357,0.92489,0.81827,0.39181,0.32784,0.71166,0.77563,1.1381,1.2874,1.0528,0.4771,0.17858,0.007996,-0.46111:1
-0.41574,-0.74212,-1.3949,-1.4415,-1.628,-1.3016,-1.1151,-0.97525,0.33026,1.4493,1.7757,1.5425,0.98302,0.23701,0.003886,0.050511,0.003886,-0.18262,-0.18262,0.003886,0.70327,1.3094,0.79652,0.19039:2
-1.015,-1.3559,-1.4695,-1.6513,-1.6285,-1.4695,-1.1513,0.030298,0.68929,1.2119,1.0301,0.9847,0.9847,0.5984,0.55295,0.5984,0.64384,0.46205,0.28026,1.1438,0.80291,0.37116,-0.060597,-0.58325:1
-0.34593,-0.87029,-1.2636,-1.5257,-1.5694,-1.482,-1.0014,-0.56441,-0.34593,-0.30223,0.44061,0.79018,0.87757,0.4843,-0.30223,-0.30223,-0.34593,0.528,1.3145,1.4019,1.7515,1.3145,1.0087,0.30952:1
-0.42324,-0.91231,-1.138,-1.5142,-1.4766,-1.4014,-1.138,-0.83707,-0.5361,-0.46086,0.028216,0.47967,0.74302,0.25394,0.028216,0.10346,0.065837,1.1568,1.3826,1.6459,1.5331,1.345,0.85588,0.21632:1
-0.98115,-1.3242,-1.4957,-1.5937,-1.6427,-1.4957,-1.0547,0.1705,0.75858,1.1506,1.3712,1.1016,0.70958,0.24401,0.36653,0.51355,0.46454,0.24401,0.34203,1.3222,0.8811,0.48905,0.023482,-0.5646:1
-0.45278,-0.22949,-1.4204,-1.7181,-1.7181,-1.4204,-1.0482,-1.6436,0.21709,0.96138,1.408,1.3335,1.3335,0.66366,0.58923,0.44037,0.44037,0.14266,0.44037,0.14266,0.14266,0.96138,0.36594,0.068227:2
0.84833,0.29557,-0.53356,-0.80994,-0.90207,-0.71782,-0.62569,-1.8233,-1.547,-0.25719,0.20345,0.47982,0.57195,-0.16506,-0.44144,-0.25719,-0.44144,-0.16506,-0.25719,0.11132,0.47982,1.4011,2.2302,2.3223:2
-0.98227,-1.2963,-1.4757,-1.5879,-1.5655,-1.5206,-1.1393,-0.35422,0.54301,1.0589,1.1935,1.2608,1.014,0.6103,0.54301,0.6103,0.65516,0.40842,0.3187,1.0589,0.85703,0.38599,-0.085049,-0.51123:1
-0.98376,-1.2498,-1.4493,-1.6267,-1.5823,-1.5602,-1.0059,-0.23001,1.1667,1.2553,1.1667,1.1223,0.85629,0.56809,0.32423,0.36856,0.39073,0.36856,0.50158,1.1667,0.72327,0.36856,-0.11916,-0.54038:1
0.93961,-0.11745,-0.68122,-1.104,-1.3155,-0.9631,-0.32887,-0.9631,-0.25839,0.51679,1.0806,1.2215,0.93961,0.02349,-0.9631,-0.75169,-0.82216,-0.89263,-0.9631,-0.11745,0.58726,2.1376,1.6443,1.151:2
-1.0979,-1.2756,-1.5802,-1.6564,-1.6564,-1.5802,-1.1487,-0.13327,0.55212,1.0598,1.0344,1.0344,0.7552,0.47597,0.57751,0.57751,0.70443,0.62828,0.55212,0.7552,0.98366,0.67905,0.095193,-0.33635:2
-1.0254,-1.2037,-1.4266,-1.6495,-1.7387,-1.4712,-0.9808,-0.84706,0.35666,1.1146,1.382,1.2037,1.07,0.75789,0.53498,0.66873,0.62415,0.44582,0.4904,0.4904,0.13375,0.66873,0.40124,0.0:2
-1.1027,-1.4223,-1.5502,-1.6354,-1.6354,-1.4223,-1.0175,-0.44215,0.51673,1.0708,0.98552,0.96421,0.81505,0.45281,0.45281,0.70851,0.90029,0.66589,0.58066,1.156,0.77244,0.47412,0.047944,-0.33561:1
-0.73312,-1.0602,-1.3218,-1.4526,-1.6488,-1.3218,-0.86394,-0.86394,0.9021,1.4908,1.5562,1.36,1.1637,0.83669,0.50964,0.37883,0.50964,0.44423,0.1826,-0.27526,-0.79853,0.64046,0.37883,-0.013627:2
0.16295,-0.78513,-1.0222,-1.3777,-1.4962,-1.2592,-0.66662,-1.6147,-0.074069,0.99253,1.111,0.99253,1.111,0.16295,-0.54811,0.28146,0.7555,0.28146,-0.074069,-0.66662,-0.54811,1.7036,1.4666,1.111:2
-0.22979,-0.57021,-0.97872,-1.5915,-1.5915,-1.183,-0.50213,-1.2511,-0.43404,0.79149,1.0638,1.0638,0.85957,0.042553,-0.36596,-0.36596,-0.22979,-0.1617,-0.1617,0.11064,0.99574,2.1532,1.6766,0.85957:2
-0.83729,-1.3052,-1.6093,-1.7029,-1.7029,-1.3987,-1.118,-0.34603,0.70668,1.1044,1.1745,1.0108,0.77686,0.40256,0.40256,0.6365,0.56632,0.40256,0.49614,1.2681,0.84704,0.54292,-0.041913,-0.27585:1
1.0071,0.2962,-0.41468,-0.3357,-0.65164,-0.65164,-0.41468,-1.6785,-1.0466,-0.41468,0.05924,0.21721,-0.019747,-0.098734,-0.3357,-0.57266,-0.73063,-0.57266,-0.3357,-0.41468,0.53316,2.4289,2.2709,1.8759:2
-0.70909,-1.2182,-1.5818,-1.5576,-1.7515,-1.6303,-1.1212,-0.17576,0.57575,1.1818,1.2303,1.0848,0.8909,0.38182,0.40606,0.6,0.6,0.28485,0.47878,1.2303,0.84242,0.40606,-0.10303,-0.34545:1
-0.7434,-0.91305,-1.2523,-1.3654,-1.3937,-1.3089,-1.4503,-0.68685,0.35933,1.2076,1.3772,1.4338,1.0945,0.81173,0.92483,1.0945,1.0945,0.75518,0.41588,-0.008247,-0.31927,-0.4041,-0.23445,-0.48892:2
-0.47222,-1.2228,-1.523,-1.523,-1.523,-1.2978,-0.9976,-0.92254,-0.172,1.0289,1.3291,1.5543,1.4041,0.87876,0.50349,0.27833,0.42844,0.20327,0.12822,-0.021891,-0.24705,1.254,0.72865,0.20327:2
-0.77677,-1.3357,-1.4672,-1.5659,-1.5988,-1.533,-1.1384,-0.053429,0.43976,1.3275,1.4261,1.2289,1.0973,0.40688,0.66992,0.76855,0.76855,0.374,0.24248,-0.053429,0.73567,0.57128,-0.053429,-0.48086:2
0.74576,0.041567,-0.60394,-0.95604,-0.95604,-0.77999,-0.72131,-1.4255,-1.4255,-0.13448,0.62839,0.68708,0.74576,0.45235,-0.31053,-0.25185,-0.54526,-0.77999,-0.66262,-0.42789,1.2152,2.2128,1.802,1.4499:2
-1.1247,-1.3807,-1.5382,-1.5973,-1.5382,-1.5382,-1.046,-0.19935,0.50945,0.82448,0.84417,0.86386,0.72603,0.52914,0.48976,0.70634,0.72603,1.2183,1.1395,1.0411,0.58821,0.33225,-0.081217,-0.49469:1
-0.91257,-1.1241,-1.5001,-1.6411,-1.6646,-1.4766,-1.2181,-0.39558,0.6384,1.0144,1.2024,1.0144,0.8499,0.45041,0.37991,0.40341,0.42691,0.59141,1.2729,1.1554,0.61491,0.40341,-0.043083,-0.44258:1
-0.54186,-0.95082,-1.4416,-1.7278,-1.7687,-1.5642,-1.2371,-0.41918,0.15336,1.0939,1.2166,1.2984,1.0939,0.35783,0.15336,-0.092014,0.071567,0.11246,0.48052,0.84858,0.97126,1.1757,0.6441,0.071567:2
0.038483,-0.51567,-0.93128,-1.2084,-1.3931,-1.3469,-0.93128,-0.46949,-1.0236,-0.053876,0.31556,0.54645,0.50028,-0.10006,-0.23859,-0.42331,-0.46949,-0.33095,0.4541,1.8395,2.1166,1.9318,1.0082,0.68499:1
-0.88165,-1.2664,-1.5327,-1.5919,-1.6215,-1.4143,-1.1184,-0.79287,0.53885,1.2491,1.3675,1.2491,1.1899,0.50926,0.56845,0.56845,0.47967,0.47967,0.39088,0.45007,0.39088,0.74601,0.24292,-0.20099:2
-1.146,-1.4102,-1.5235,-1.599,-1.5801,-1.4291,-1.0327,-0.14551,0.60955,1.157,1.0437,0.9682,0.79831,0.45854,0.40191,0.47742,0.51517,1.0626,1.1003,0.94933,0.60955,0.30753,-0.10775,-0.48528:1
-0.18964,0.0,-0.88498,-1.3907,-1.3907,-1.3907,-1.5803,-1.3907,0.18964,1.0746,1.7067,1.5803,1.1378,0.37928,-0.25285,-0.063213,-0.18964,-0.31606,-0.31606,-0.12643,1.2643,1.201,0.69534,0.25285:2
-0.32615,-0.75884,-1.0342,-1.4275,-1.6242,-1.3882,-1.1129,-0.79818,-0.87685,-0.24748,0.38188,0.77523,0.81457,0.38188,-0.090143,-0.12948,-0.24748,0.42122,1.2473,1.7193,1.6799,1.4046,0.77523,0.46055:1
-0.96973,-1.3576,-1.5618,-1.4597,-1.6434,-1.378,-1.1331,-0.31644,0.56142,1.0922,1.1739,0.96973,0.68392,0.43893,0.37768,0.41852,0.56142,0.90848,1.2964,1.1126,0.60225,0.33685,-0.17353,-0.54101:1
-1.113,-1.4394,-1.5354,-1.6314,-1.5546,-1.4778,-0.97855,-0.17203,0.88413,1.0954,1.057,0.94174,0.63449,0.38486,0.50007,0.48087,0.53848,0.6921,1.249,0.99935,0.6537,0.30805,-0.056808,-0.46007:1
-1.1168,-1.3078,-1.4776,-1.605,-1.605,-1.3927,-1.0956,-0.39527,0.58097,1.1328,1.2601,1.1752,0.94176,0.5173,0.49608,0.62342,0.53852,0.43241,0.53852,1.1328,0.77197,0.38997,-0.055709,-0.48016:1
-0.6814,-1.0145,-1.2871,-1.4688,-1.5294,-1.3779,-1.5294,-0.77225,0.37855,1.4082,1.3779,1.3477,1.1357,0.77225,0.74197,0.89339,0.92367,0.59054,0.37855,0.045426,-0.19685,-0.16656,0.13628,-0.106:2
0.18995,-0.38711,-0.96417,-1.3681,-1.3681,-1.0219,-1.8298,-0.79105,0.18995,1.4018,1.9211,1.8634,1.5749,0.59389,0.24765,0.016831,0.074537,-0.040875,0.074537,-0.15629,-0.56023,-0.50252,0.6516,0.18995:2
-1.315,-1.2897,-1.2897,-1.4668,-1.5173,-1.5173,-1.2897,-0.40462,0.35404,1.138,1.315,1.2139,1.0621,0.70809,0.60693,0.6828,0.73338,0.63222,0.58164,0.53107,0.63222,0.32876,0.025289,-0.4552:2
0.95,-0.05,-0.95,-1.25,-1.65,-1.35,-0.65,-1.55,-0.15,1.25,1.65,1.75,1.55,0.45,-0.45,-0.35,-0.15,-0.35,-0.35,-0.15,-0.15,0.35,1.15,0.45:2
-0.7305,-1.1816,-1.4222,-1.4823,-1.4222,-1.4222,-1.5124,-0.76058,0.3521,1.134,1.3445,1.1039,0.92347,0.80318,0.86332,1.0137,1.0438,0.80318,0.53253,0.23181,-0.008771,-0.068915,0.20173,-0.33957:2
-0.89174,-1.1289,-1.4846,-1.4648,-1.6031,-1.5439,-1.2079,-0.33841,0.59037,1.2227,1.1635,1.0646,0.84727,0.51133,0.51133,0.61013,0.70894,0.64966,1.1832,0.92632,0.51133,0.19514,-0.29889,-0.73364:1
-0.94729,-0.8142,-1.4574,-1.5683,-1.7236,-1.6349,-1.1691,-0.54804,0.51662,1.1598,1.0711,1.2042,0.93804,0.58316,0.51662,0.5388,0.6497,0.47226,0.56098,1.2042,0.73842,0.47226,-0.17097,-0.5924:1
-0.68537,-1.1353,-1.304,-1.5289,-1.5289,-1.4445,-1.557,-0.68537,0.66428,1.1985,1.3672,1.311,1.0017,0.63616,0.83299,0.91734,0.8611,0.57993,0.41122,0.2144,-0.06678,-0.06678,0.29875,-0.29172:2
-1.0556,-1.3304,-1.5802,-1.5802,-1.7051,-1.3304,-1.0805,-0.381,0.69329,1.3678,1.2679,1.093,0.96811,0.54339,0.59336,0.74326,0.66831,0.46844,0.24359,0.21861,0.29356,0.86818,0.34352,-0.33103:2
-1.0558,-1.3658,-1.5311,-1.5931,-1.6138,-1.4691,-1.1178,-0.16706,0.59764,1.0937,1.135,0.92832,0.88698,0.41163,0.47363,0.63897,0.72164,0.78364,0.74231,1.1143,0.65964,0.39096,-0.14639,-0.51841:1
0.66029,-0.30599,-0.75692,-1.079,-1.2723,-1.2078,-1.1434,-1.5944,-1.0146,0.016105,0.85355,1.0468,1.3045,0.40262,-0.37041,-0.62808,-0.6925,-0.37041,0.66029,0.46703,0.78913,1.9487,1.4977,0.78913:2
-0.90172,-1.2029,-1.5041,-1.6331,-1.6331,-1.418,-1.0738,-0.60055,0.13087,1.1635,1.4216,1.1635,1.1635,0.64716,0.86228,0.73321,0.86228,0.56111,0.25994,0.001793,0.087842,0.77623,0.25994,-0.12728:2
-0.81358,-1.2225,-1.3588,-1.5973,-1.6655,-1.4951,-1.0521,-0.23428,0.41318,0.48133,1.0266,0.99249,0.75395,0.10649,-0.097971,0.10649,0.14057,0.58357,1.5036,1.6059,1.1288,0.75395,0.27687,-0.33651:1
-0.002616,-0.4421,-0.8188,-1.1327,-1.1327,-1.1327,-2.0117,-1.2583,0.49965,1.6298,2.0692,1.6925,1.3158,0.37408,0.24852,-0.002616,-0.37932,-0.065399,-0.065399,-0.002616,0.060167,-0.19097,0.688,0.060167:2
-1.0114,-1.3326,-1.5404,-1.6159,-1.5404,-1.427,-1.0681,-0.29359,0.76428,1.0854,1.1043,0.95319,0.76428,0.44314,0.46203,0.49981,0.68872,1.0854,1.0665,0.9343,0.55649,0.21645,-0.16136,-0.63362:1
-0.69708,-1.0926,-1.409,-1.3694,-1.5672,-1.4485,-0.93438,-0.38067,-0.22247,0.56854,0.92449,0.44989,0.68719,0.093932,-0.26202,-0.10382,-0.26202,0.33124,1.676,1.7946,1.5177,1.0431,0.52899,0.13348:1
-1.0769,-1.3977,-1.518,-1.5381,-1.5581,-1.4378,-1.0168,-0.014203,0.66754,0.98836,1.0084,0.94825,0.74774,0.34672,0.36677,0.52718,0.66754,0.98836,1.229,1.1087,0.64749,0.32667,-0.33502,-0.67589:1
-0.90774,-1.3271,-1.5368,-1.6207,-1.6207,-1.4529,-1.1594,-0.23676,0.58099,1.1262,1.231,1.21,0.97939,0.53906,0.56002,0.49712,0.47615,0.39228,0.7068,1.1052,0.66486,0.35034,-0.089988,-0.46741:1
-1.0397,-1.4139,-1.5776,-1.6711,-1.6711,-1.4139,-1.0631,0.24652,0.69085,1.182,1.2053,1.0884,0.83117,0.457,0.52715,0.48038,0.55054,0.26991,0.26991,0.99487,0.76101,0.71424,0.036053,-0.45505:1
-1.0903,-1.3827,-1.5471,-1.5654,-1.5837,-1.4375,-1.0538,-0.19492,0.51775,1.0659,0.99285,0.99285,0.77357,0.37156,0.35329,0.53602,0.62739,1.1756,1.1208,0.99285,0.59084,0.38983,-0.12182,-0.52384:1
-1.0777,-1.3439,-1.539,-1.5922,-1.5745,-1.4858,-1.0955,-0.22619,0.46569,0.94469,0.99791,1.0689,0.98017,0.71406,0.57214,0.62536,0.80276,0.80276,1.0157,0.92695,0.48343,0.2528,-0.26167,-0.45682:1
-0.33429,-1.0433,-1.4538,-1.3791,-1.4911,-1.4911,-1.1179,-0.11039,0.52398,1.4196,1.4196,1.233,0.89715,0.076188,-0.14771,-0.33429,-0.29698,-0.035761,0.44935,1.6435,1.2703,0.67325,0.1135,-0.48356:1
-0.95574,-1.3919,-1.5972,-1.5715,-1.6485,-1.4945,-1.1097,0.0449,0.68633,1.1995,1.2508,1.1738,0.91725,0.42976,0.5837,0.5837,0.50673,0.37845,0.14753,0.45542,1.0455,0.71199,0.0449,-0.39127:1
-1.0333,-1.3025,-1.4102,-1.4371,-1.491,-1.5718,-1.3025,-0.57553,0.77073,1.3092,1.2554,1.2285,1.0938,0.50148,0.52841,0.60918,0.58226,0.44763,0.25915,0.44763,0.79766,0.60918,0.070679,-0.38705:2
-0.95,-1.1627,-1.4604,-1.7157,-1.6306,-1.5881,-1.2052,-0.73731,0.19851,0.8791,1.0918,0.96418,0.8791,0.75149,0.58134,0.8791,0.92164,0.70895,0.62388,0.70895,0.32612,0.70895,0.45373,-0.22686:2
-0.94452,-1.3398,-1.5025,-1.6188,-1.642,-1.549,-1.2468,-0.08428,0.45046,0.91545,1.0085,1.055,0.91545,0.70621,0.38071,0.49696,0.70621,0.63646,0.75271,1.1712,0.79921,0.45046,-0.08428,-0.43302:1
-0.91311,-1.1593,-1.4466,-1.4877,-1.6108,-1.4877,-1.0773,-0.91311,0.071818,1.0978,1.1799,1.2209,1.0567,0.89259,0.60532,0.76948,1.0157,0.97467,0.27701,0.52324,0.071818,0.56428,0.071818,-0.29753:2
-1.032,-1.3224,-1.5298,-1.6128,-1.6128,-1.5091,-1.0112,-0.098529,0.44079,1.0838,1.0009,0.98011,0.71045,0.3993,0.31633,0.46153,0.58599,0.87639,1.312,1.1461,0.64822,0.42005,-0.14002,-0.51339:1
0.1986,-0.24041,-0.9303,-1.0557,-1.2439,-0.67943,-0.554,-1.0557,-0.49128,0.51219,0.70034,0.51219,0.32404,-0.11498,-0.554,-0.74215,-0.67943,-0.74215,-0.36585,0.13589,0.95121,2.5818,2.1428,1.3902:2
0.27332,-0.41998,-1.06,-1.1133,-1.5399,-1.4333,-2.1266,-1.0066,0.27332,1.7133,1.8199,1.4466,1.02,0.43331,0.27332,-0.046665,0.16666,-0.046665,-0.046665,0.21999,0.006666,0.16666,0.69997,0.32665:2
-0.96443,-1.3415,-1.53,-1.5719,-1.5928,-1.4462,-1.0482,-0.4617,0.62753,1.0046,1.214,1.2559,1.0884,0.54375,0.45996,0.60659,0.56469,0.5228,0.58564,1.0674,0.71132,0.37617,-0.16845,-0.5036:1
-0.98574,-1.2747,-1.4481,-1.5637,-1.6215,-1.4481,-1.1784,-0.38852,0.74814,1.0949,1.1912,1.0949,0.84446,0.49769,0.55548,0.55548,0.69034,0.97932,0.96005,0.88299,0.40136,0.15091,-0.21513,-0.52337:1
-0.99421,-1.3011,-1.4737,-1.608,-1.5888,-1.4929,-1.1093,-0.22697,0.46354,1.0006,1.1924,1.2308,1.0198,0.54026,0.55945,0.52108,0.59781,0.63617,0.94306,1.039,0.57863,0.23337,-0.22697,-0.53387:1
-0.74924,-1.2469,-1.3796,-1.5123,-1.645,-1.4128,-0.91513,0.047,0.27924,1.175,1.3077,1.0091,0.81007,0.11335,-0.35112,-0.18524,-0.11888,0.44512,1.3741,1.54,1.0423,0.61101,0.17971,-0.41747:1
-0.31033,-0.80686,-1.262,-1.3034,-1.3861,-1.3861,-1.0965,-0.80686,0.51722,1.6344,1.924,1.7585,1.3034,0.51722,0.020689,-0.062066,-0.14482,-0.26895,-0.35171,-0.22757,0.062066,1.0137,0.47584,0.1862:2
1.1546,0.21979,-0.11407,-0.38115,-0.98208,-0.78177,-1.8501,-1.9169,-0.84854,-0.18084,0.21979,0.68718,0.55364,0.15302,-0.18084,-0.38115,-0.58146,-0.58146,-0.18084,0.019475,0.55364,2.1561,1.8223,1.4216:2
-0.79375,-1.1117,-1.5164,-1.5453,-1.5742,-1.4008,-1.025,-0.5914,0.42036,1.143,1.2587,1.2587,0.82506,0.24692,0.1891,-0.12888,0.015658,0.73834,1.2876,1.2587,0.9696,0.50708,-0.013249,-0.41795:1
-1.08,-1.3517,-1.498,-1.6025,-1.5607,-1.4562,-1.0382,-0.5365,0.52953,1.0939,1.1148,1.1148,0.90578,0.50863,0.57134,0.63405,0.69675,0.52953,0.57134,1.1775,0.73856,0.50863,-0.11845,-0.45289:1
-0.99287,-1.3233,-1.5371,-1.5954,-1.5565,-1.4788,-1.0123,-0.21542,0.34823,0.89245,1.0868,0.93132,0.83414,0.5426,0.6009,0.6009,0.8147,1.1257,1.1062,0.98963,0.5426,0.19274,-0.19598,-0.70133:1
0.31993,-0.69037,-1.1955,-0.7914,-1.1955,-1.1955,-0.89243,-1.5996,-0.89243,0.31993,1.4313,1.2292,0.92611,0.2189,-0.084192,-0.48831,0.11787,-0.18522,0.2189,0.016838,-0.38728,2.1385,1.6333,1.0271:2
-0.96197,-1.3203,-1.5666,-1.6338,-1.6114,-1.4546,-1.0068,-0.2006,0.7399,1.1206,1.0086,0.7623,0.7623,0.49358,0.40401,0.40401,0.47119,0.78469,1.2997,1.2326,0.67273,0.31444,-0.223,-0.49171:1
-0.78932,-1.1653,-1.4256,-1.3967,-1.5124,-1.3099,-1.5702,-0.7604,0.54107,1.2063,1.293,1.2641,1.0038,0.80137,0.65676,0.88813,1.1195,0.65676,0.51215,0.16509,-0.12412,-0.18196,0.25186,-0.12412:2
-0.50387,-0.95788,-1.2881,-1.4944,-1.5357,-1.3706,-1.0817,-0.66897,-0.13242,-0.29751,0.32159,0.65177,0.89941,0.32159,-0.091144,-0.17369,-0.25624,0.52795,1.436,1.8074,1.5598,1.3534,0.69304,0.28031:1
-0.25358,-0.89419,-1.1745,-1.3747,-1.4948,-1.3346,-1.695,-0.93423,0.50715,1.348,1.7483,1.7083,1.1478,0.74739,0.10677,-0.053385,0.066731,0.066731,0.026692,0.22689,0.14681,0.90754,0.50715,-0.053385:2
-0.63097,-1.0185,-1.3166,-1.4358,-1.5551,-1.3464,-1.6743,-0.69059,0.2037,1.1874,1.247,1.2768,1.1278,0.77008,0.8297,1.0086,0.94893,0.85951,0.47198,0.26332,-0.15402,-0.24344,0.054651,-0.18382:2
0.01895,-0.72529,-1.0974,-1.2214,-1.2628,-1.1801,-0.93202,-1.1801,-0.68394,0.18434,0.68049,0.92857,0.63915,0.22568,-0.10509,-0.27048,-0.5599,-0.60125,-0.063743,1.7142,1.9622,1.7142,1.1353,0.68049:1
-0.82192,-1.2133,-1.3699,-1.5264,-1.5264,-1.3438,-1.5525,-0.45662,0.32616,1.2394,1.2394,1.2916,1.0046,0.84802,0.97848,0.84802,0.97848,0.69146,0.27397,0.30007,0.091325,-0.11742,-0.091325,-0.091325:2
-0.71702,-1.0964,-1.4216,-1.5571,-1.5029,-1.4487,-1.5842,-0.74412,0.39408,1.2342,1.2884,1.18,1.0716,0.71928,0.69218,0.99027,0.74638,0.74638,0.47538,0.33988,0.041779,-0.14792,0.28568,0.014679:2
-0.70034,-1.057,-1.4583,-1.592,-1.5474,-1.4583,-1.1016,-0.92326,0.28051,1.1276,1.2168,1.3951,1.2168,0.77093,0.68176,0.77093,0.94927,0.5926,0.23592,0.19134,0.32509,0.63718,0.057588,-0.61117:2
-0.6539,-1.0027,-1.288,-1.5733,-1.7319,-1.6684,-1.288,-0.6539,0.36064,1.2167,1.2801,1.3118,0.83621,0.61427,0.61427,0.89961,0.89961,0.58257,0.23382,0.075298,0.17041,0.96302,0.17041,-0.36856:2
-1.0439,-1.3208,-1.5778,-1.5976,-1.5976,-1.3999,-1.0439,-0.11453,0.75554,1.0522,1.0522,0.81487,0.67645,0.39961,0.36006,0.43915,0.53803,1.1906,1.2499,1.0324,0.5578,0.30073,-0.11453,-0.60888:1
-0.87894,-1.3678,-1.5878,-1.6611,-1.71,-1.3434,-0.90339,-0.43896,0.56322,1.1743,1.1254,1.1743,0.85654,0.46544,0.41656,0.46544,0.58766,0.48989,0.53877,1.2965,0.85654,0.441,-0.19453,-0.36563:1
-0.15083,-0.68429,-1.1034,-1.294,-1.3702,-1.3321,-1.1034,-1.0653,-0.95102,-0.18893,0.53505,0.80178,0.80178,0.26832,-0.074621,-0.18893,-0.30325,-0.22704,1.2971,1.7163,1.7163,1.4877,0.87798,0.53505:1
-0.89984,-1.2377,-1.3785,-1.5756,-1.463,-1.463,-1.463,-0.59012,0.28274,1.1274,1.1274,1.2964,1.0711,0.78956,0.81772,0.90219,1.043,0.70509,0.45168,0.3109,-0.083297,0.057487,0.22643,-0.05514:2
-0.82552,-1.2349,-1.4191,-1.6033,-1.6442,-1.4805,-1.0097,-0.10916,1.078,1.3236,1.2622,1.0575,0.85281,0.38206,0.42299,0.40253,0.23879,0.77094,1.0575,0.91421,0.50486,0.05458,-0.29337,-0.70272:1
-1.0285,-1.2823,-1.4273,-1.6085,-1.5722,-1.4454,-1.1735,-0.35795,0.72949,1.0376,1.1101,1.092,0.92885,0.53012,0.54825,0.65699,0.72949,1.0013,1.0013,0.76573,0.36701,0.20389,-0.21296,-0.59356:1
-1.0233,-1.3325,-1.5534,-1.5976,-1.6418,-1.443,-1.0013,0.080984,0.5448,1.1632,1.0528,0.8761,0.67732,0.30185,0.34602,0.36811,0.52271,0.65523,1.362,1.2074,0.78775,0.36811,-0.18405,-0.53744:1
-1.0377,-1.2864,-1.5542,-1.4968,-1.5924,-1.4585,-1.0951,-0.32996,0.7986,1.1047,1.1238,1.0281,0.89425,0.49255,0.51168,0.54994,0.72209,0.89425,1.0473,0.9325,0.41604,0.16737,-0.31083,-0.52124:1
-0.67225,-1.0071,-1.3115,-1.4028,-1.4637,-1.3724,-1.555,-0.82445,0.45408,1.276,1.3673,1.3369,1.0934,0.72806,0.84982,0.97159,1.002,0.72806,0.3932,0.088787,-0.093861,-0.30695,-0.15474,-0.1243:2
-0.99302,-1.2994,-1.4219,-1.5648,-1.667,-1.524,-1.0951,-0.38036,0.66117,1.1105,1.2126,1.0288,0.9675,0.49779,0.51821,0.62032,0.70201,0.57948,0.57948,1.1105,0.70201,0.37526,-0.15572,-0.56416:1
-0.92542,-1.2321,-1.5388,-1.4877,-1.5133,-1.5388,-1.2577,-0.18423,0.63363,1.3237,1.4004,1.2981,0.96589,0.42917,0.48028,0.58252,0.65919,0.48028,0.2247,0.42917,0.8381,0.60807,-0.13312,-0.54205:2
-0.97836,-1.3088,-1.5153,-1.5979,-1.6186,-1.4533,-1.1229,-0.17296,0.50854,1.2726,1.3553,1.3346,1.0455,0.77701,0.50854,0.63245,0.73571,0.52919,0.42594,0.38463,0.28138,0.42594,-0.007744,-0.44142:2
-1.0409,-1.3753,-1.4933,-1.6113,-1.5916,-1.4933,-1.0212,-0.077041,0.59174,0.96547,0.96547,0.84745,0.72943,0.33603,0.39504,0.49339,0.65075,1.0638,1.2015,1.1622,0.72943,0.31636,-0.096711,-0.64747:1
-0.92202,-1.2373,-1.454,-1.6511,-1.6117,-1.4738,-1.1979,-0.37029,0.3982,1.009,1.147,1.0485,0.94993,0.47702,0.59525,0.71348,0.73318,0.67407,1.0485,1.0682,0.53613,0.22086,-0.21265,-0.48851:1
-0.86434,-1.1362,-1.4353,-1.5168,-1.544,-1.4625,-1.5168,-0.67403,0.65817,1.0388,1.1475,1.1475,1.0932,0.68536,0.79411,0.98442,1.0116,0.73973,0.49504,0.25035,0.005664,0.005664,0.16879,-0.075899:2
-0.41332,-0.8694,-0.9074,-1.2875,-1.4015,-1.4775,-1.2875,-1.0214,-0.98342,-0.45133,0.15678,0.57485,0.72687,0.38481,0.15678,-0.14727,0.15678,1.1069,1.373,1.563,1.639,1.221,0.72687,0.46083:1
-0.6352,-1.1414,-1.4689,-1.588,-1.7071,-1.4689,-1.0818,-0.21835,0.49625,1.062,1.2704,1.062,0.76422,0.16872,-0.18857,-0.0397,0.049625,1.0917,1.1811,1.2704,0.9131,0.49625,0.1985,-0.48632:1
0.46616,0.0,-0.81577,-1.1654,-1.2819,-1.1071,-0.99058,-1.6315,-0.7575,0.05827,0.5827,0.99058,0.69923,0.0,-0.29135,0.05827,-0.34962,-0.29135,-0.52443,0.11654,0.64096,2.3308,1.8646,1.3985:2
-0.85345,-1.235,-1.4734,-1.4496,-1.4973,-1.4257,-1.5449,-0.66269,0.52955,1.1257,1.1257,1.3164,1.1495,0.81569,0.64878,0.83954,0.93492,0.69647,0.3388,0.12419,0.10035,0.36264,0.21957,-0.18579:2
1.2522,0.14875,-0.24071,-0.69507,-0.82489,-0.8898,-1.7985,-1.7985,-1.0196,-0.43544,0.27857,0.79785,0.4733,0.14875,-0.11089,-0.37053,-0.50034,-0.43544,-0.37053,0.083842,1.5768,1.382,1.7066,1.6417:2
-0.94394,-1.1081,-1.5596,-1.6622,-1.5801,-1.6416,-1.2312,-0.14364,0.45145,1.0055,1.1286,1.1491,1.0671,0.55405,0.57457,0.71822,0.73874,0.51301,0.73874,0.94394,0.59509,0.26677,-0.18468,-0.38989:1
-0.021442,-0.75049,-1.0936,-1.1365,-1.3938,-1.3938,-1.0936,-0.7076,-1.0507,0.10721,0.75049,0.92203,0.7076,0.064327,-0.32164,-0.36452,-0.49318,-0.27875,0.92203,1.7797,1.8655,1.4366,0.87914,0.66472:1
0.61274,-0.22759,-0.82782,-1.188,-1.308,-1.1279,-2.1483,-1.4281,0.13255,1.4531,1.6932,1.8732,1.0929,0.2526,-0.22759,0.012505,0.2526,-0.10754,0.072528,0.012505,-0.10754,0.012505,0.91285,0.31262:2
-1.0561,-1.1913,-1.3536,-1.4889,-1.543,-1.5159,-1.2184,-0.19048,0.64808,1.2161,1.4055,1.4325,1.135,0.81038,0.59398,0.56693,0.53988,0.21527,-0.001127,0.21527,0.81038,0.59398,-0.10933,-0.51508:2
-0.80378,-1.1948,-1.4033,-1.4816,-1.4555,-1.3251,-1.5598,-0.77771,0.57785,1.3078,1.3599,1.4381,0.94281,0.65605,0.7864,0.7864,0.81247,0.55178,0.3693,0.18682,0.030413,0.21289,0.26503,-0.28241:2
-0.9429,-1.2949,-1.4458,-1.4961,-1.5966,-1.5715,-1.1692,-0.54059,0.59088,1.3201,1.2446,1.2446,1.0435,0.74174,0.76689,0.81718,0.7166,0.33944,0.3143,0.13829,0.11315,0.66631,0.26401,-0.26401:2
-0.89935,-1.2424,-1.4799,-1.6646,-1.6646,-1.4799,-1.1368,-0.71464,0.41999,1.2907,1.2116,1.1324,0.94772,0.63108,0.60469,0.7894,0.71024,0.60469,0.41999,0.34083,0.28805,0.84217,0.23528,-0.18691:2
-0.90597,-1.3997,-1.5437,-1.6054,-1.6877,-1.482,-0.96769,-0.10371,0.53399,1.0483,0.96597,0.9454,0.69855,0.34885,0.43113,0.49284,0.76026,0.86312,1.2128,1.1305,0.67798,0.30771,-0.10371,-0.61798:1
-0.85705,-1.0843,-1.4253,-1.5389,-1.4821,-1.4253,-1.0275,-0.80023,0.10891,1.1317,1.5294,1.4158,1.2453,0.9044,0.73393,0.33619,0.79076,0.44983,0.27937,0.052086,-0.57294,0.84758,0.39301,-0.004735:2
0.063917,-0.46505,-0.99402,-0.99402,-1.3114,-1.0469,-0.67664,-0.35926,-1.0998,-0.83533,0.80447,0.75157,1.069,0.43419,-0.20057,-0.20057,-0.57084,-0.51795,-0.46505,0.01102,1.4392,2.4443,1.7566,0.96316:1
-1.0155,-1.2432,-1.5166,-1.5849,-1.6305,-1.471,-1.1294,-0.35494,0.62447,0.89779,0.9889,0.85224,0.71558,0.3967,0.32837,0.44225,0.51058,1.1256,1.285,1.1711,0.6928,0.44225,0.00949,-0.53716:1
1.1291,0.28227,0.09409,-0.09409,-0.09409,-0.09409,-0.09409,-1.5995,-1.2232,-0.75272,-0.09409,-0.28227,0.0,-0.47045,-0.75272,-0.75272,-0.56454,-0.56454,-0.56454,-0.18818,0.09409,2.3523,2.2582,1.9759:2
-0.91771,-1.1808,-1.5634,-1.659,-1.6351,-1.5395,-1.0612,-0.46334,0.6128,0.99543,1.1389,1.1867,0.80411,0.54106,0.51714,0.63672,0.54106,0.32583,0.42149,1.2585,0.9476,0.51714,-0.008968,-0.41551:1
-0.84107,-1.3051,-1.5661,-1.5661,-1.5081,-1.5371,-1.1311,-0.58005,0.31903,1.1311,1.2761,1.2761,1.1021,0.84107,0.69606,0.75406,0.84107,0.29002,0.029002,0.0,0.31903,0.81207,0.49304,-0.14501:2
-1.0451,-1.2187,-1.508,-1.5659,-1.7974,-1.508,-1.2477,-0.43758,0.25676,1.1826,1.2115,0.95111,0.95111,0.31463,0.6618,0.77753,0.89325,0.71966,0.40142,0.51715,0.48821,0.6618,0.37249,-0.032548:2
-0.95573,-1.3512,-1.5594,-1.5594,-1.6842,-1.4761,-1.1222,-0.20641,0.60536,1.1049,1.1257,1.0841,1.0425,0.50128,0.45965,0.5221,0.5221,0.45965,0.73024,1.1465,0.70943,0.45965,-0.16478,-0.39374:1
-0.93793,-1.3634,-1.5052,-1.5458,-1.566,-1.4039,-1.2216,-0.30983,0.80454,1.0274,1.0477,0.96663,0.80454,0.43984,0.37905,0.54114,0.70323,1.1287,1.1287,0.96663,0.48036,0.1967,-0.22878,-0.5327:1
-0.18867,-1.0665,-1.3438,-1.621,-1.6672,-1.5286,-0.97413,-0.41969,0.78162,1.2899,1.6595,1.5671,0.92023,0.31958,-0.14246,-0.050054,-0.00385,-0.14246,-0.096258,0.13476,0.73541,1.2437,0.73541,-0.14246:2
-1.0085,-1.3027,-1.4917,-1.5758,-1.5758,-1.4287,-1.1556,-0.18909,0.65133,1.1976,1.1766,1.0085,0.75638,0.42021,0.3992,0.44122,0.44122,0.42021,1.1556,1.2606,0.77739,0.31516,-0.14707,-0.54627:1
-0.94278,-1.2707,-1.5601,-1.6179,-1.5986,-1.4829,-1.1743,-0.22907,0.65826,1.1019,1.1598,1.0826,0.88974,0.40749,0.42678,0.46536,0.56181,0.73542,1.1598,0.98619,0.5811,0.23389,-0.22907,-0.3448:1
-0.97818,-1.33,-1.4942,-1.6114,-1.6583,-1.4003,-1.0016,-0.29805,0.71043,0.99187,0.92151,0.8746,0.64007,0.42899,0.26482,0.40554,0.42899,0.49935,1.3202,1.5313,0.89805,0.38209,-0.040066,-0.48567:1
-1.0744,-1.3646,-1.5511,-1.5718,-1.5926,-1.406,-1.0744,-0.39036,0.56309,1.2056,1.2264,0.97764,0.97764,0.50091,0.58382,0.58382,0.60455,0.16927,0.33509,1.2264,0.874,0.52164,0.024182,-0.34891:1
-0.96145,-1.2672,-1.5118,-1.5934,-1.5934,-1.5322,-1.1653,-0.20724,0.75082,1.1993,1.2604,1.0362,0.7712,0.36352,0.36352,0.42467,0.42467,0.62851,1.1381,1.0566,0.60813,0.32275,-0.084934,-0.43146:1
0.44638,-0.3375,-0.80783,-1.0691,-1.1736,-1.1736,-0.86009,-0.54654,-0.96461,-0.023952,0.55089,0.81218,0.65541,0.080565,-0.18073,-0.54654,-0.80783,-0.75557,-0.49428,0.34186,2.3277,2.0664,1.4915,0.96896:2
1.5222,0.64287,-0.076611,-0.31644,-0.55626,-0.31644,-1.5955,-1.9153,-1.1159,-0.31644,0.56293,0.56293,0.80275,0.083273,-0.47632,-0.39638,-1.1159,-0.55626,-0.47632,-0.15655,0.40304,0.88269,1.7621,2.1618:2
0.15446,-0.43651,-1.0812,-1.1887,-1.2424,-1.0275,-1.0275,-1.5647,-0.97376,-0.06044,0.42308,1.0678,1.014,0.36936,0.047009,0.10073,-0.32906,-0.49024,-0.22161,0.20818,1.1215,1.8736,1.8736,1.3901:2
0.72173,0.10531,-0.51112,-0.88097,-1.0043,-0.94262,-1.559,-1.744,-0.88097,-0.017979,0.47516,0.84502,1.0299,0.35188,-0.26455,-0.26455,-0.32619,-0.44948,-0.44948,-0.14126,0.78337,0.84502,2.2012,2.0779:2
-1.1569,-1.3669,-1.3669,-1.556,-1.556,-1.535,-1.0729,-0.44281,0.56533,0.83837,1.0484,1.1114,1.1114,0.54432,0.52332,0.60733,0.67034,0.67034,1.1114,1.0064,0.58633,0.29229,-0.12777,-0.50582:1
-0.91662,-1.2836,-1.5079,-1.5894,-1.6098,-1.4671,-1.1001,-0.080703,0.59211,1.0407,1.1018,1.061,0.81638,0.38823,0.32706,0.44939,0.429,0.81638,1.2853,1.163,0.65327,0.2659,-0.14187,-0.69235:1
-0.29987,-0.72074,-1.1837,-1.31,-1.4362,-1.31,-0.847,-0.847,-1.0574,-0.17361,0.4577,0.54187,0.4577,-0.13152,-0.34196,-0.25778,-0.089435,0.54187,1.3836,1.7624,1.6782,1.594,0.96274,0.62605:1
-0.73408,-1.3122,-1.5324,-1.67,-1.615,-1.3948,-1.0094,-0.48633,0.69738,1.3856,1.4406,1.2755,0.97266,0.53221,0.7249,0.7249,0.77996,0.39457,0.17434,0.11929,0.064232,0.66985,0.14682,-0.34869:2
-0.73794,-1.1571,-1.4366,-1.4715,-1.5064,-1.4366,-0.98246,-0.9126,0.37989,1.1484,1.3929,1.2881,1.1135,0.86893,0.90387,0.9388,1.0087,0.76414,0.41482,0.10043,-0.28382,-0.21396,0.10043,-0.28382:2
-0.18666,-0.59058,-1.2515,-1.7289,-1.3984,-1.5453,-1.1414,-0.0765,0.54774,1.2454,1.6493,1.3189,0.95166,-0.03978,-0.22338,-0.14994,-0.33354,-0.37026,-0.00306,1.5759,1.3189,0.73134,0.03366,-0.33354:1
-0.45496,-0.88679,-1.2569,-1.6271,-1.6888,-1.6888,-1.0102,-0.88679,0.34701,0.96391,1.334,1.3957,1.5808,0.84053,0.59377,0.59377,0.59377,0.4087,0.28532,0.10025,-0.64003,0.65546,0.34701,0.10025:2
-0.78366,-1.1715,-1.4761,-1.5038,-1.6146,-1.4484,-1.5038,-0.70056,0.51821,1.2107,1.2384,1.1553,1.0445,0.54591,0.62901,0.8229,0.8229,0.60131,0.43511,0.21352,-0.008079,0.7398,0.43511,-0.20197:2
-1.1731,-1.4537,-1.4225,-1.3914,-1.4225,-1.4537,-1.329,-0.58071,0.51055,1.2588,1.5083,1.1653,0.94706,0.60409,0.51055,0.63527,0.75998,0.41702,0.16759,0.011692,0.54173,0.85352,0.32348,0.011692:2
-1.1835,-1.3923,-1.4759,-1.6012,-1.6221,-1.6012,-0.93287,0.027847,0.57086,0.98856,0.96768,0.86325,0.69617,0.34112,0.27847,0.40378,0.54998,0.61263,1.281,1.2601,0.84237,0.50821,0.006962,-0.38986:1
-0.63849,-1.0737,-1.3223,-1.4156,-1.4156,-1.4156,-1.5088,-0.88716,0.13858,1.1021,1.2265,1.3197,1.1021,0.76024,0.88457,1.0089,1.0711,0.88457,0.60482,0.26291,-0.20333,-0.17225,0.014246,-0.32767:2
-0.073624,-0.62581,-0.73624,-1.2332,-1.5645,-1.5645,-0.84668,-0.73624,-0.18406,-0.23928,0.64421,1.1964,0.47856,0.42334,-0.9019,-0.9019,-0.79146,0.9203,1.4173,1.4173,1.7486,0.9203,0.97552,0.25768:1
-0.41058,-1.0114,-1.2117,-1.3719,-1.6924,-1.412,-1.1717,0.47066,0.711,1.3118,1.432,0.91128,0.59083,0.15021,-0.29041,-0.41058,-0.33047,-0.2103,-0.13018,1.5922,1.6724,0.83117,0.19027,-0.2103:1
-0.82683,-1.2017,-1.6234,-1.764,-1.6702,-1.4828,-1.108,-0.10055,0.6023,1.2114,1.1412,1.0474,0.90687,0.36802,0.43831,0.46173,0.50859,0.32116,0.46173,1.3286,0.78973,0.50859,-0.030262,-0.28797:1
-0.53492,-0.88827,-1.3201,-1.3594,-1.5557,-1.3987,-0.96679,-0.024538,0.52511,1.4281,1.5851,1.1533,0.91771,0.28955,-0.14232,-0.37788,-0.41714,-0.33862,-0.2601,1.6637,1.4281,0.64289,0.28955,-0.33862:1
-1.0942,-1.3465,-1.5529,-1.5759,-1.6447,-1.4612,-1.0483,-0.47496,0.48834,1.1076,1.1993,1.0847,0.92411,0.4654,0.41953,0.58008,0.60301,0.44246,0.48834,1.1993,0.87824,0.4654,0.052561,-0.19973:1
-0.89593,-1.1474,-1.5246,-1.6504,-1.7133,-1.3989,-1.1474,-0.77018,0.047154,0.67588,0.99024,1.1789,1.0531,0.80162,0.613,0.67588,0.55013,0.55013,0.29864,0.1729,-0.14146,1.1789,1.116,0.48726:2
-0.70297,-0.93134,-1.2739,-1.5594,-1.6736,-1.8163,-1.2168,-0.70297,0.32472,1.381,1.1811,1.3239,1.0384,0.72438,0.69583,0.72438,0.83856,0.66728,0.35327,0.12489,0.32472,0.41036,0.15344,-0.38895:2
-1.0444,-1.325,-1.5194,-1.5841,-1.6273,-1.5409,-1.1523,-0.18081,0.48846,1.0498,1.1577,1.1146,0.94184,0.57482,0.63958,0.66117,0.48846,0.4021,0.46687,1.093,0.83389,0.46687,0.078261,-0.48306:1
-0.80765,-1.2168,-1.447,-1.5237,-1.5492,-1.5237,-1.4725,-0.55193,0.72667,1.1103,1.3148,1.1614,0.72667,0.72667,0.88011,0.93125,0.95682,0.62439,0.41981,0.2408,-0.040489,0.061799,0.39424,-0.14278:2
-0.7156,-1.1905,-1.3751,-1.5334,-1.5862,-1.4015,-1.6126,-0.63645,0.33966,0.9992,1.1311,1.2366,1.052,0.76177,0.81453,0.94644,0.97282,0.78815,0.5771,0.26052,-0.029679,-0.056061,0.41881,-0.16159:2
-0.87503,-1.2124,-1.3811,-1.4935,-1.5216,-1.2967,-1.5779,-0.84691,0.50253,1.1772,1.1772,1.2897,1.0648,0.72743,0.72743,0.95234,0.98045,0.58687,0.33385,0.19328,0.16517,0.24951,0.24951,-0.17219:2
1.8226,0.73176,-0.031816,-0.57723,-0.46814,-0.46814,0.077266,-0.79539,-1.3408,-0.031816,-0.1409,-0.031816,-0.1409,-0.35906,-0.79539,-0.57723,-0.79539,-0.79539,-0.79539,-0.46814,-0.1409,2.1498,2.2589,1.7135:2
-0.58905,-0.66346,-1.1843,-1.4075,-1.5563,-1.5191,-1.2215,-0.51465,0.41544,1.3083,1.4571,1.1967,0.82468,0.22942,-0.32863,-0.14261,-0.10541,0.043404,0.37824,1.8292,1.2711,0.75027,0.11781,-0.58905:1
0.2828,-0.28712,-0.59799,-1.1161,-1.2197,-0.96067,-0.85705,-0.49437,-0.28712,-0.90886,-0.33893,-0.23531,0.23099,0.075558,-0.85705,-0.80524,-0.49437,-0.079876,1.7853,1.9408,1.889,1.7335,1.1636,0.43824:1
-1.0267,-1.2845,-1.4779,-1.5208,-1.6068,-1.5208,-1.2845,-0.10294,0.73491,1.1861,1.315,1.1431,0.94974,0.73491,0.62749,0.58453,0.52008,0.39118,0.30524,0.97122,0.60601,0.26228,-0.081458,-0.42519:1
-0.59779,-1.0989,-1.389,-1.389,-1.4417,-1.2308,-1.4417,-0.59779,0.40439,1.3538,1.4329,1.4593,1.2483,0.85274,0.90548,0.74724,0.85274,0.66812,0.37802,-0.043955,-0.38681,-0.41318,-0.017582,-0.25494:2
-1.0567,-1.3842,-1.5684,-1.5889,-1.6503,-1.4661,-1.0976,-0.17654,0.5194,1.1335,1.0925,1.1539,0.90831,0.5194,0.56034,0.72409,0.66268,0.5194,0.47846,0.92878,0.7855,0.47846,-0.012793,-0.46311:2
-0.97649,-1.4036,-1.4593,-1.6265,-1.5522,-1.385,-1.1251,-0.27082,0.49057,1.1034,1.2705,1.252,0.95483,0.472,0.45343,0.60199,0.6577,0.58342,1.0105,0.95483,0.49057,0.21201,-0.19654,-0.51223:1
-1.0193,-1.3402,-1.5206,-1.5407,-1.6009,-1.4805,-1.1196,-0.47792,0.56481,1.006,1.1463,1.0661,0.9057,0.54476,0.58486,0.76534,0.82549,0.62497,0.66507,1.0862,0.68513,0.20387,-0.13703,-0.43781:1
-0.77293,-1.1716,-1.3576,-1.4639,-1.5436,-1.3842,-1.7031,-0.66662,0.47616,1.114,1.1937,1.1671,1.0343,0.63562,0.7685,1.0343,1.0343,0.71535,0.34328,0.47616,0.10409,-0.10852,0.2104,-0.1351:2
-0.91741,-1.1096,-1.3841,-1.4939,-1.4665,-1.4116,-1.5488,-0.8076,0.42782,1.1142,1.1965,1.2789,1.0867,0.70236,0.89453,0.83963,0.94944,0.78472,0.51018,0.20819,-0.066346,-0.066346,0.29055,-0.011439:2
-0.42856,-0.93336,-1.2804,-1.6906,-1.5328,-1.5328,-1.0596,-0.27081,0.77035,1.3383,1.3698,1.3698,0.8019,0.13935,-0.20771,-0.27081,-0.11306,0.1709,1.1805,1.3383,0.9912,0.39175,-0.018404,-0.52321:1
-1.0336,-1.2812,-1.4717,-1.6432,-1.6623,-1.3574,-1.0145,-0.27149,0.75731,1.005,1.0431,0.89067,0.87162,0.50963,0.41437,0.58584,0.70015,1.0431,1.0812,1.024,0.54774,0.24291,-0.29054,-0.69062:1
-0.9858,-1.0503,-1.4586,-1.6734,-1.6519,-1.5875,-1.1792,-0.16922,0.56139,1.2061,1.2705,1.1416,1.0127,0.49693,0.45395,0.49693,0.58288,0.45395,0.51842,1.1416,0.69033,0.34651,-0.23369,-0.38411:1
0.97395,0.35062,-0.39737,-0.70904,-0.77137,-1.27,-2.1427,-1.457,-0.77137,0.038958,-0.023375,0.53762,0.53762,0.038958,-0.33504,-0.27271,-0.39737,-0.27271,-0.085708,0.10129,1.0363,1.3479,2.1583,1.7843:2
-0.79504,-1.2624,-1.5099,-1.6199,-1.6474,-1.4274,-1.0425,-0.71256,0.60717,1.2945,1.2395,1.1845,1.0196,0.60717,0.57967,0.66215,0.85461,0.79963,0.52468,0.41471,-0.025203,0.57967,0.11227,-0.43762:2
-0.9686,-1.2708,-1.4866,-1.5514,-1.573,-1.4219,-1.1197,-0.51533,0.56389,1.233,1.3409,1.233,1.0603,0.43438,0.45597,0.62864,0.54231,0.52072,0.36963,1.0172,0.77973,0.34805,-0.10522,-0.51533:1
-1.0304,-1.4422,-1.2363,-1.6275,-1.5658,-1.4628,-1.0922,-0.062631,0.41096,1.0699,1.0905,0.94633,0.74042,0.3286,0.34919,0.39037,0.53451,0.96692,1.4199,1.1522,0.65805,0.28742,-0.14499,-0.68036:1
0.54977,-0.2042,-0.6889,-0.95818,-1.1197,-1.1197,-1.8199,-1.766,-1.0659,0.11893,0.8729,0.8729,0.98062,0.65748,0.2805,-0.15035,-0.2042,-0.47348,-0.25806,0.01122,0.92676,1.4653,1.6807,1.4115:2
-0.89646,-1.2156,-1.5347,-1.6677,-1.6145,-1.5347,-1.1624,0.007757,0.75241,1.2843,1.2577,1.1513,0.96517,0.43327,0.38008,0.59284,0.45987,0.22051,0.3003,0.8056,0.99176,0.56625,-0.072027,-0.47095:1
-0.76047,-1.1518,-1.3474,-1.4592,-1.5151,-1.3195,-1.4872,-0.56482,0.69293,1.2519,1.2799,1.3078,1.1122,0.80472,0.91652,0.88857,0.86062,0.66498,0.38548,0.21778,-0.005823,-0.11762,-0.14557,-0.50892:2
-0.7468,-1.1036,-1.3506,-1.4879,-1.5428,-1.3506,-1.5977,-0.63701,0.37855,1.3118,1.3118,1.2569,1.0098,0.76281,0.79026,0.98239,0.92749,0.68047,0.48833,0.18641,-0.14296,-0.11551,0.13152,-0.14296:2
-0.80746,-1.1209,-1.3774,-1.4914,-1.4914,-1.2919,-1.2634,-0.60797,0.24699,1.2159,1.3014,1.5579,1.3299,0.93095,0.78846,0.75996,0.93095,0.64597,0.41798,0.075996,-0.12349,-0.23749,-0.15199,-0.23749:2
-0.97955,-1.2933,-1.5622,-1.6071,-1.6519,-1.4502,-1.1364,-0.28481,0.70128,1.2167,1.1719,1.0823,0.85816,0.52199,0.40994,0.45476,0.61164,0.40994,0.43235,1.0375,1.015,0.47717,-0.015875,-0.41928:1
-0.39885,-1.2805,-1.4694,-1.5324,-1.5954,-1.4065,-0.96563,-1.0916,0.10496,1.2385,1.2385,1.3645,1.3015,0.86067,0.60877,0.60877,0.60877,0.67174,0.23091,-0.083968,-0.33587,0.7977,0.54579,-0.020992:2
0.037116,-0.64407,-0.90606,-1.1681,-1.2205,-1.1681,-0.59167,-0.64407,-0.95846,-0.27728,0.6135,0.5087,0.40391,-0.22488,-0.015283,-0.17248,-0.38207,-0.48687,-0.32968,0.35151,2.1855,2.2903,1.8187,0.98029:2
-0.59936,-1.026,-1.3308,-1.6051,-1.6051,-1.7879,-1.0565,-0.35555,0.89397,1.0768,1.1683,1.2292,0.83301,0.31492,0.010159,0.040635,0.19302,0.43682,1.2597,1.2292,0.86349,0.40635,0.010159,-0.59936:1
-1.0021,-1.34,-1.499,-1.499,-1.5785,-1.5189,-1.1214,-0.2468,0.40912,1.0452,1.1247,1.0054,0.78677,0.46875,0.44887,0.58801,0.64764,0.92591,1.1644,1.0452,0.70727,0.25011,-0.2468,-0.56482:1
-0.64769,-1.0506,-1.3192,-1.4199,-1.6549,-1.5877,-1.1177,-0.21123,0.99741,1.2996,1.4674,1.031,0.89669,0.42666,-0.17766,-0.14409,-0.11051,0.057355,0.39309,1.6017,1.031,0.52738,0.090928,-0.3791:1
-0.29284,-1.0046,-1.227,-1.5384,-1.4494,-1.3604,-1.138,0.018534,0.24095,1.2196,1.3975,1.1306,0.81922,0.018534,-0.20388,-0.070431,-0.33733,-0.42629,-0.42629,0.46336,1.8868,1.6644,0.50784,0.1075:2
0.15635,-0.49882,-1.0349,-1.154,-1.4518,-1.4518,-1.7496,-1.0944,0.15635,1.6453,1.8836,1.6453,1.4071,0.57327,0.037225,0.27547,0.45415,0.096785,0.096785,0.096785,-0.32014,-0.20102,0.27547,0.15635:2
-0.95838,-1.3361,-1.4753,-1.5747,-1.6343,-1.4554,-1.0777,-0.18306,0.71154,1.1887,1.2085,1.1489,0.91034,0.33382,0.41334,0.41334,0.53262,0.53262,1.1489,1.0296,0.57238,0.2543,-0.1433,-0.56078:1
-1.1398,-1.3178,-1.4512,-1.6514,-1.5847,-1.3623,-0.98416,-0.094524,0.50598,1.1065,1.0398,0.90632,0.75063,0.43926,0.26133,0.41702,0.37254,0.55046,1.4401,1.3067,0.8396,0.3503,-0.11677,-0.58383:1
-0.88698,-1.3925,-1.5329,-1.5329,-1.7295,-1.4487,-0.99932,-0.38147,0.65763,1.4159,1.2755,1.2474,0.96655,0.60146,0.62955,0.76997,0.76997,0.37679,0.20829,0.26446,0.20829,0.65763,0.15212,-0.29722:2
0.99357,0.010918,-0.44765,-0.64418,-0.7752,-0.84071,-1.8889,-1.7579,-1.1028,-0.25112,0.40398,0.535,0.66602,0.14194,-0.25112,-0.18561,-0.18561,-0.1201,-0.18561,-0.054592,0.535,0.99357,2.3693,2.0417:2
-0.87992,-1.3649,-1.5266,-1.6277,-1.567,-1.5064,-1.1831,-0.17262,0.99949,1.0399,1.0197,0.91866,0.7772,0.43365,0.45386,0.45386,0.49427,0.61553,1.2218,1.0601,0.67615,0.3326,-0.21303,-0.45554:1
-1.0182,-1.3705,-1.5215,-1.597,-1.6725,-1.4712,-0.96787,-0.54004,0.54213,1.3223,1.1713,1.1713,0.89447,0.59247,0.69313,0.6428,0.76863,0.69313,0.39113,0.4918,0.038799,0.7183,0.3408,-0.31354:2
-0.985,-1.3499,-1.5121,-1.6135,-1.573,-1.4513,-1.0255,-0.07265,0.61668,1.083,1.1033,0.98162,0.73833,0.39366,0.33284,0.45449,0.51531,0.8397,1.2857,1.1844,0.61668,0.27202,-0.1943,-0.64033:1
-0.6092,-1.1017,-1.4711,-1.625,-1.6557,-1.4711,-1.1017,-0.17827,0.25266,0.99139,1.2069,1.1761,1.0222,0.37578,0.22188,-0.30139,-0.024368,0.89905,1.2376,1.33,0.83749,0.4989,-0.085929,-0.42451:1
-0.78042,-1.3015,-1.4386,-1.5757,-1.6305,-1.466,-1.274,-0.67072,0.70043,1.2215,1.3037,1.194,1.0844,0.70043,0.67301,0.81013,0.81013,0.56332,0.4262,0.28909,0.097124,0.097124,0.31651,-0.14968:2
-0.35789,-0.83712,-1.3163,-1.3901,-1.5007,-1.3532,-1.1689,-0.68966,-0.76339,0.010752,0.60057,0.71116,0.6743,0.15821,-0.099839,-0.1367,-0.24729,0.96921,1.4484,1.7434,1.559,1.2641,0.6743,0.047616:1
-0.75455,-1.1771,-1.3582,-1.4487,-1.5091,-1.328,-1.2677,-0.66401,0.63383,1.0866,1.328,1.2677,1.328,0.81492,0.72437,0.96583,0.99601,0.75455,0.54328,0.060364,-0.30182,-0.36219,-0.030182,-0.30182:2
0.050085,-0.55093,-1.0317,-1.1519,-1.2721,-0.91154,-0.43073,-1.8732,-1.1519,0.29049,0.5309,0.89151,0.6511,0.29049,-1.0317,0.41069,0.5309,0.050085,0.41069,0.050085,0.050085,2.2137,1.7329,1.2521:2
-0.71029,-1.226,-1.5293,-1.6809,-1.6203,-1.4686,-1.1956,-0.2553,0.44235,1.231,1.3827,1.14,1.0187,0.62435,0.59402,0.77601,0.74568,0.44235,-0.10364,-0.042971,0.80635,0.80635,0.19969,-0.37663:2
-1.0687,-1.2622,-1.5042,-1.6252,-1.6252,-1.5526,-1.238,-0.028229,0.60087,1.23,1.1574,1.23,0.91543,0.67346,0.67346,0.55248,0.62507,0.26213,0.14115,0.31052,0.93962,0.64927,0.21373,-0.27019:2
-0.25091,-0.92836,-1.2295,-1.38,-1.5305,-1.3047,-1.0036,-1.38,-0.025091,1.1793,1.4051,1.5556,1.5556,0.87818,0.72763,0.35127,0.42654,0.35127,-0.025091,-0.17564,-0.70254,0.95345,0.57709,-0.025091:2
-0.94885,-1.4754,-1.6597,-1.607,-1.607,-1.5544,-1.0542,-0.18538,0.60441,1.1046,1.2099,1.052,0.84135,0.57809,0.52543,0.65707,0.76237,0.36747,0.18319,0.42013,1.052,0.68339,0.15686,-0.1064:2
0.29156,-0.52796,-1.0323,-1.4736,-1.4105,-1.1584,-1.9779,-1.1584,0.0394,1.4263,1.9306,1.5524,1.1111,0.48068,0.22852,0.16548,0.16548,0.16548,0.0394,0.16548,0.0394,-0.2758,0.92195,0.29156:2
-0.98888,-1.2951,-1.5795,-1.5139,-1.5795,-1.492,-1.1639,-0.24517,0.65166,1.2641,1.1548,1.0454,0.89227,0.58604,0.38917,0.65166,0.76103,0.56417,0.52042,1.0235,0.73916,0.3673,-0.17955,-0.57328:1
-0.76695,-1.1732,-1.4271,-1.3763,-1.5794,-1.4778,-1.5794,-0.71617,0.37554,0.88331,1.1118,1.3657,1.061,0.78176,0.75637,0.88331,1.0356,0.78176,0.62943,0.37554,0.17243,-0.13223,0.14704,-0.13223:2
-0.91447,-1.1896,-1.4647,-1.4952,-1.587,-1.4952,-0.94504,-0.91447,0.33879,1.103,1.2558,1.2252,1.0113,0.82786,0.91957,1.0113,1.0418,0.73616,0.46106,0.12482,-0.02802,-0.058587,0.15538,-0.11972:2
-1.0284,-1.1061,-1.5982,-1.5982,-1.6499,-1.4428,-1.132,-0.43272,0.47373,0.68091,0.9399,0.8363,0.78451,0.47373,0.24064,0.42193,0.37013,1.1989,1.3802,1.3025,0.8363,0.21474,0.085249,-0.25143:1
-0.005819,-0.65757,-1.0766,-1.1231,-1.0766,-1.1697,-0.93689,-0.47135,-0.79723,0.087288,0.73904,0.92525,0.92525,0.22695,-0.28514,-0.61101,-0.70412,-0.84378,-0.47135,1.6236,2.0425,1.7167,1.1115,0.83214:1
-0.92025,-1.2783,-1.5261,-1.6363,-1.6913,-1.3333,-1.0304,-0.56225,0.62192,1.4481,1.393,1.035,1.035,0.48422,0.67699,0.70453,0.59438,0.31899,0.1813,0.23637,0.071142,0.86976,0.59438,-0.28686:2
-0.81773,-1.1448,-1.3827,-1.4422,-1.4124,-1.3232,-1.4719,-0.69879,0.3717,1.1448,1.2638,1.2935,1.1151,0.75826,0.90694,0.84747,1.0259,0.8772,0.66905,0.25275,-0.28249,-0.19328,-0.044603,-0.31222:2
-1.1411,-1.4226,-1.5281,-1.5633,-1.5281,-1.4226,-1.0708,-0.26165,0.47713,1.1104,1.128,1.1104,0.98723,0.56507,0.58266,0.72338,0.72338,0.67061,0.93446,0.89928,0.47713,0.24846,-0.27924,-0.41996:1
-0.81555,-1.2591,-1.5086,-1.6473,-1.675,-1.4809,-1.0928,-0.011552,0.54293,1.4301,1.4855,1.2638,1.0142,0.43203,0.57065,0.54293,0.5152,0.34886,0.23796,0.26569,0.737,0.54293,0.043896,-0.48286:2
-0.82567,-1.2447,-1.5897,-1.6883,-1.5897,-1.5158,-1.1707,0.012323,0.89961,1.0228,1.2447,1.22,0.85032,0.43132,0.40667,0.40667,0.40667,0.2095,0.25879,1.1461,0.89961,0.60385,0.13556,-0.52991:1
-0.32722,-0.75461,-1.182,-1.4491,-1.3957,-1.2354,-0.91488,-0.32722,0.15359,1.8631,1.4892,1.6495,1.0084,0.26044,-0.38064,-0.22037,-0.38064,-0.54091,-0.43407,-0.32722,1.4892,1.1686,0.58098,0.20702:2
-0.90383,-1.2475,-1.389,-1.6316,-1.6923,-1.3486,-1.1666,-0.27713,0.99649,1.2189,1.2189,0.99649,0.77411,0.43044,0.36979,0.39,0.43044,0.59216,1.1178,1.1178,0.59216,0.26871,-0.25691,-0.60059:1
-1.0006,-1.2071,-1.4912,-1.4912,-1.4912,-1.3879,-1.3362,-0.58743,0.29049,1.0909,1.2459,1.2717,0.96184,0.80691,0.83273,0.96184,1.0393,0.88438,0.47124,0.21302,-0.071008,-0.071008,0.16138,-0.09683:2
-0.15343,-0.76713,-1.2392,-1.3336,-1.5697,-1.3336,-0.95596,-0.90875,0.6019,1.5461,1.6877,1.6405,0.97956,0.27144,0.035406,-0.24784,-0.43667,-0.34226,-0.29505,0.035406,0.88515,1.5461,0.36586,-0.011802:2
-1.0616,-1.3878,-1.5328,-1.6053,-1.4784,-1.4603,-1.0616,-0.24616,0.69618,1.0224,1.1311,0.98613,0.98613,0.49684,0.6237,0.53309,0.73243,1.0767,1.0043,0.78679,0.47872,-0.028693,-0.19179,-0.49986:1
0.57649,-0.17924,-0.76057,-0.93497,-1.0512,-1.2256,-1.1094,-1.9232,-0.87684,0.16955,0.69275,1.0416,0.92528,0.40209,-0.29551,-0.29551,-0.52804,-0.64431,-0.41178,0.75089,1.216,2.0298,1.4485,0.98342:2
-0.34868,-1.0735,-1.37,-1.5018,-1.6336,-1.5347,-1.0405,-0.151,0.37613,1.1998,1.4963,1.068,0.67264,0.24435,-0.18395,-0.24984,-0.11806,-0.052164,1.2657,1.4963,1.2657,0.50791,0.079619,-0.41457:1
-0.77112,-1.1307,-1.4074,-1.4627,-1.5734,-1.435,-1.6564,-0.74346,0.5014,1.2483,1.1377,1.1653,1.0547,0.72271,0.72271,0.91636,0.94402,0.69505,0.44608,0.28009,0.031122,0.11411,0.22477,-0.024206:2
-0.75045,-1.0592,-1.2993,-1.6081,-1.6767,-1.5395,-1.1278,-0.68184,0.004288,0.004288,0.65611,0.69041,0.69041,0.34735,0.004288,0.10721,0.38166,1.1021,1.1707,1.6853,1.2736,1.0335,0.58749,0.004288:1
-1.1518,-1.4172,-1.583,-1.5167,-1.5333,-1.4006,-1.0358,-0.32268,0.44014,0.90447,1.0206,1.004,0.97081,0.62256,0.55623,0.78839,0.85472,1.0703,0.92106,0.85472,0.50648,0.17481,-0.22318,-0.5051:1
-0.68231,-1.1271,-1.433,-1.5442,-1.5164,-1.433,-1.6276,-0.71011,0.56878,1.3472,1.2638,1.236,0.93021,0.70779,0.70779,0.87461,0.87461,0.45758,0.40197,0.17955,-0.070664,0.37417,0.31857,-0.098466:2
-0.73552,-0.93312,-1.3942,-1.5259,-1.5259,-1.3942,-0.99899,-1.1307,-0.47205,0.6477,1.5698,1.504,1.4381,0.6477,0.45009,0.45009,0.77943,0.71356,0.38423,-0.010978,0.25249,0.97703,0.45009,-0.14271:2
-1.1096,-1.3358,-1.5003,-1.6031,-1.5825,-1.5208,-1.1507,-0.12252,0.67945,0.94677,1.1113,1.0907,0.88508,0.61776,0.47381,0.65888,0.63832,0.61776,0.57663,1.1113,0.78226,0.371,-0.10196,-0.53379:1
-0.83519,-1.2801,-1.444,-1.725,-1.6548,-1.6079,-1.1864,-0.085861,0.61663,1.1552,1.1552,1.1318,0.82738,0.40589,0.4293,0.45272,0.5698,0.38247,0.61663,1.2489,0.80397,0.38247,-0.062444,-0.29661:1
-1.076,-1.3437,-1.5496,-1.6114,-1.6526,-1.4879,-1.0966,-0.10811,0.55087,1.1687,1.1687,1.0863,0.4685,0.4685,0.50968,0.57146,0.59206,0.57146,0.71562,1.2716,0.7568,0.36553,0.015445,-0.35523:1
-0.91482,-1.3163,-1.5421,-1.5672,-1.6174,-1.4669,-1.0403,-0.51335,0.69108,1.2933,1.2682,1.3184,1.1678,0.66599,0.61581,0.69108,0.69108,0.46525,0.23942,0.3147,0.18924,0.59071,0.063776,-0.28752:2
-0.74071,-1.1198,-1.5622,-1.6675,-1.6675,-1.52,-1.2041,-0.19308,0.41775,1.0918,1.2392,1.176,1.0707,0.54412,0.52306,0.62838,0.56519,0.37562,0.502,1.2603,0.64944,0.24924,-0.19308,-0.42477:1
-0.97321,-1.3759,-1.537,-1.6175,-1.6444,-1.5101,-1.188,-0.060406,0.7987,1.2819,1.1209,1.0403,0.74501,0.47654,0.50338,0.61077,0.69131,0.36915,0.26176,0.55708,1.094,0.63762,0.10068,-0.38257:1
-1.0527,-1.3426,-1.521,-1.6325,-1.5656,-1.4987,-1.1196,-0.58444,0.44135,1.1103,1.2664,1.0657,1.0211,0.64205,0.66434,0.66434,0.82044,0.61975,0.44135,0.50825,0.55285,0.66434,0.062253,-0.22764:2
-0.29672,-0.79984,-0.95465,-1.2643,-1.4191,-1.4965,-1.0321,-0.64503,-0.99335,-0.14191,0.32252,0.36122,0.59343,0.24511,-0.33542,-0.29672,-0.33542,0.94175,1.4449,1.7932,1.8319,1.3288,0.78694,0.36122:1
-0.84285,-1.1722,-1.5839,-1.6937,-1.7486,-1.5565,-1.1173,0.28247,0.74907,1.3255,1.3804,1.2431,0.88631,0.5295,0.44716,0.74907,0.63928,0.25503,0.20013,0.062899,0.36482,0.63928,0.17269,-0.21157:1
-1.0917,-1.0543,-1.5401,-1.6149,-1.6336,-1.4654,-1.1103,-0.23203,0.85183,1.0948,1.0574,1.0761,0.83314,0.47808,0.38465,0.47808,0.49677,0.57152,1.1882,1.1508,0.59021,0.27252,-0.19466,-0.58709:1
-1.0026,-1.1982,-1.4916,-1.5406,-1.7117,-1.4183,-1.1493,-0.3668,0.56242,1.0026,1.3205,0.90477,0.88032,0.24453,0.31789,0.46461,0.53797,0.70914,1.2471,1.1982,0.66024,0.3668,-0.14672,-0.39125:1
-0.67615,-1.0995,-1.2124,-1.297,-1.297,-1.4381,-1.2406,-0.90193,0.39628,1.1865,1.4123,1.3276,1.1865,0.76317,0.79139,0.98895,0.96072,1.0454,0.48095,0.33984,-0.36571,-0.45038,-0.28104,-0.61971:2
0.38587,-0.085023,-1.0268,-1.2361,-1.2884,-1.1838,-0.97449,-1.3931,-0.60824,0.17659,0.38587,0.75213,0.54284,0.019621,-0.13734,-0.55592,-0.55592,-0.55592,0.071942,1.7986,2.1125,1.5893,1.1707,0.59516:2
-0.18635,-0.52389,-0.98801,-1.2412,-1.2412,-1.3677,-0.94582,-1.1568,-0.90362,0.024612,0.36215,0.40434,0.48873,0.31996,-0.35512,-0.52389,-0.31293,-0.14416,1.3326,1.8389,1.8389,1.5435,1.1216,0.61531:1
-0.050946,-0.89744,-1.1796,-1.0855,-1.1796,-0.99149,-1.4618,-1.0855,0.32527,1.2658,1.1718,1.1718,2.0183,0.98366,0.23122,-0.050946,0.32527,-0.145,-0.42717,-0.61527,-0.99149,1.3599,0.70149,0.60744:2
-0.80967,-1.4769,-1.5603,-1.7827,-1.5325,-1.4491,-1.2267,-0.003475,0.63592,1.2197,1.3587,1.1641,0.94172,0.49692,0.66372,0.63592,0.69152,0.41352,0.10772,0.24672,0.49692,0.71932,0.16332,-0.11467:1
-1.0706,-1.4155,-1.5664,-1.6526,-1.6526,-1.5233,-0.96283,-0.10059,0.65386,1.1281,1.1281,1.0634,0.78319,0.35208,0.37363,0.65386,0.56764,0.41675,0.6323,1.0634,0.89097,0.54608,0.071853,-0.38082:1
-0.71251,-1.0615,-1.4687,-1.3523,-1.7013,-1.4105,-0.94517,-1.1778,0.39261,1.2069,1.3232,1.2651,1.2069,0.97425,0.62527,0.79976,0.62527,0.45077,-0.13087,0.10179,-0.36353,0.97425,0.33445,0.043623:2
-0.89037,-1.2706,-1.5368,-1.4987,-1.6128,-1.5177,-1.3086,-0.33904,0.83967,1.1629,0.95374,0.80165,0.68758,0.30735,0.40241,0.53549,0.80165,1.0868,1.1248,0.99176,0.49747,0.28834,-0.034854,-0.47212:1
-0.8887,-1.2778,-1.4481,-1.6426,-1.5453,-1.521,-1.1562,-0.47526,0.54619,0.95964,0.93532,0.86235,0.66779,0.37595,0.61915,0.27867,0.57051,0.49755,1.3974,1.3244,0.91099,0.52187,-0.013173,-0.49958:1
-0.50696,-1.1074,-1.455,-1.5183,-1.5499,-1.4234,-1.2022,-0.19093,0.50433,1.168,1.326,1.1364,0.85196,0.2199,-0.19093,-0.25414,-0.15933,0.59914,1.2628,1.4524,1.1364,0.37792,-0.19093,-0.28574:1
-0.87003,-1.186,-1.6073,-1.6073,-1.6336,-1.581,-1.1597,-0.63305,0.57819,1.0522,1.2365,1.0522,0.89417,0.39387,0.47287,0.63085,0.94683,0.81517,0.65718,0.68352,0.44653,0.63085,-0.001097,-0.21175:2
-0.79709,-1.3033,-1.5698,-1.6763,-1.5431,-1.5165,-1.2234,-0.21093,0.61502,1.3344,1.4943,1.2278,0.98803,0.53509,0.4818,0.64167,0.61502,0.50845,0.13544,0.24201,0.21537,0.7216,0.24201,-0.15764:2
-0.45334,-0.93824,-1.211,-1.5747,-1.4838,-1.4232,-1.5747,-0.81702,0.39525,1.3045,1.3045,1.3045,1.0923,0.66801,0.75893,1.0014,1.0014,0.84985,0.33464,0.1528,-0.2715,-0.42303,-0.029044,0.031569:2
-0.20468,-0.83853,-1.4328,-1.4328,-1.512,-1.4724,-1.3931,-0.12545,0.46878,1.2611,1.4988,1.3403,0.86494,-0.006603,-0.48199,-0.046218,-0.046218,-0.16506,0.27071,1.6573,1.0234,0.86494,0.31032,-0.40276:1
-0.77651,-1.3845,-1.6183,-1.5481,-1.4078,-1.5248,-1.1273,-0.54268,0.60308,1.1175,1.0006,1.1643,0.81353,0.88368,0.41602,0.5797,0.60308,0.55632,0.64985,1.2344,0.74338,0.36926,-0.26208,-0.54268:1
-0.86003,-1.1957,-1.6511,-1.6991,-1.5313,-1.5073,-1.0758,-0.47646,0.69821,1.2736,1.0818,0.96192,0.77013,0.48246,0.29067,0.48246,0.60232,0.55438,0.50643,1.3455,0.89,0.45848,-0.044949,-0.3566:1
-0.6708,-1.1687,-1.556,-1.5007,-1.6113,-1.4453,-1.0027,-1.1134,0.38035,0.82294,1.2655,1.3209,1.0996,0.71229,0.93359,0.98891,0.65697,0.2697,0.2697,0.10373,-0.28353,0.98891,0.43567,0.10373:2
-0.84849,-1.3591,-1.5225,-1.5225,-1.5225,-1.5225,-1.1957,-0.27659,0.64254,1.2349,1.2144,1.0715,0.80594,0.51999,0.51999,0.56084,0.56084,0.56084,1.0919,1.0715,0.56084,0.091061,-0.25616,-0.48084:1
0.19842,-0.30286,-1.0548,-1.0548,-1.3054,-1.2052,-0.85427,-0.60363,-1.0047,-0.15247,0.44907,0.95035,0.90022,0.39894,-0.25273,-0.15247,-0.50337,-0.5535,-0.60363,-0.15247,1.8527,2.1033,1.7524,1.1509:1
-0.84912,-1.3155,-1.5667,-1.6026,-1.6385,-1.4232,-1.1362,-0.59797,0.40662,1.0524,1.2677,1.3036,1.1959,0.65777,0.65777,0.65777,0.87304,0.62189,0.37074,0.11959,0.011959,0.72953,0.15547,0.047838:2
-0.98033,-1.285,-1.5027,-1.6333,-1.655,-1.3939,-1.1109,-0.52326,0.71733,1.2397,1.3703,1.2397,1.0656,0.60851,0.69557,0.80439,0.71733,0.41263,0.23851,0.23851,0.21674,0.54321,0.10792,-0.1315:2
-0.78939,-1.29,-1.4481,-1.6326,-1.6589,-1.5008,-1.1846,-0.68399,0.42269,1.0551,1.3449,1.2132,1.1341,0.68619,0.50174,0.68619,0.79158,0.52809,0.44904,0.50174,0.44904,0.58079,0.1592,-0.3151:2
-1.1004,-1.3755,-1.5506,-1.6506,-1.6256,-1.5756,-1.2005,-0.20008,0.47518,1.0004,1.1504,1.0754,0.65025,0.50019,0.67526,0.72528,0.7753,0.60023,0.42516,0.47518,0.97537,0.67526,0.15006,-0.050019:2
-1.1038,-1.3687,-1.5958,-1.6147,-1.5958,-1.3687,-1.1606,-0.19553,0.95874,1.0533,1.0155,0.88305,0.76951,0.42891,0.35322,0.39106,0.54244,0.93981,1.0912,1.0155,0.6749,0.25861,-0.006308,-0.36583:1
-1.014,-1.3646,-1.5491,-1.6414,-1.6414,-1.4753,-1.1247,-0.27599,0.49894,0.96021,0.99711,0.96021,0.83106,0.64655,0.6281,0.75725,0.86796,0.7019,0.97866,0.90486,0.5912,0.29598,-0.12839,-0.40515:1
-1.0245,-1.3517,-1.5263,-1.6572,-1.5917,-1.4827,-1.0463,-0.21726,0.65542,1.1354,1.0699,0.98268,0.76451,0.30635,0.34998,0.43725,0.45907,0.54634,1.3536,1.1572,0.69905,0.32816,-0.086359,-0.2609:1
-0.47338,-0.55173,-1.061,-1.4136,-1.4528,-1.1394,-1.1786,-0.63009,-0.9435,-0.042441,0.34932,0.78026,0.78026,0.27097,-0.12079,-0.15997,-0.4342,-0.39503,0.78026,1.7988,1.7205,1.5638,1.3679,0.58438:1
-0.82161,-1.2135,-1.6055,-1.532,-1.8014,-1.4585,-1.238,-0.18474,0.55012,1.285,1.1625,0.94205,0.77058,0.6726,0.35416,0.42765,0.52563,0.28068,0.42765,1.383,0.79508,0.55012,-0.037764,-0.23373:1
-0.84128,-1.1828,-1.5029,-1.6096,-1.6096,-1.5243,-1.2468,-0.1583,0.61006,1.1436,1.0156,0.99424,0.80215,0.37529,0.50335,0.46066,0.58872,0.80215,1.229,1.1223,0.63141,0.24723,-0.32904,-0.52113:1
-0.84756,-1.3371,-1.435,-1.7288,-1.6553,-1.6309,-1.2147,-0.064255,0.59666,1.1352,1.1352,0.91487,0.74353,0.40083,0.35187,0.49874,0.5477,0.57218,0.74353,1.282,0.79248,0.44979,-0.015299,-0.2356:1
-0.15476,-0.94501,-1.3401,-1.6562,-1.5772,-1.4192,-0.86598,-1.2611,-0.075732,0.71452,1.4257,1.5048,1.3467,1.1096,0.79354,0.55647,0.63549,0.47744,0.16134,-0.23378,-0.54988,0.16134,0.87257,0.31939:2
-0.76098,-1.2409,-1.4949,-1.5514,-1.5796,-1.5231,-1.1279,-0.11174,0.67865,1.6102,1.4408,1.2714,1.0738,0.62219,0.50928,0.65042,0.65042,0.50928,-0.33756,0.057632,0.19877,0.56573,0.001176,-0.11174:2
-0.81717,-1.3187,-1.5826,-1.6882,-1.6882,-1.3187,-1.1339,-0.47402,0.37064,1.3209,1.0305,1.0305,0.81937,0.47622,0.39704,0.55541,0.50262,0.42343,0.29145,1.2945,0.97774,0.74018,0.053891,-0.26286:1
0.004461,-0.26317,-1.0125,-1.1731,-1.4943,-1.5478,-1.3337,-0.049065,0.64677,1.7173,1.6638,1.5567,1.1285,0.27209,-0.42375,-0.47727,-0.47727,-0.69138,-0.47727,-0.049065,1.3961,0.9144,0.27209,-0.10259:2
1.103,0.41641,-0.27019,-0.42276,-0.80421,-0.72792,-1.9485,-1.6434,-0.72792,-0.1939,0.18754,0.34012,0.56898,0.26383,-0.11761,-0.34648,-0.49905,-0.27019,-0.34648,-0.1939,0.26383,0.56898,2.2473,2.5525:2
-0.61584,-1.0447,-1.3746,-1.5396,-1.6716,-1.5396,-1.1767,-0.35191,0.17595,0.63783,1.0337,0.90176,0.50587,0.10997,-0.021994,-0.18695,0.14296,0.96775,1.4956,1.6936,1.1327,0.7698,0.10997,-0.15396:1
-0.74074,-1.2762,-1.5707,-1.7314,-1.6511,-1.5172,-1.1691,-0.6872,0.59795,1.187,1.1602,1.1334,0.73182,0.59795,0.73182,0.73182,0.86569,0.59795,0.35698,0.19634,0.089246,0.81214,0.41053,0.14279:2
-0.68362,-1.1989,-1.3345,-1.6057,-1.6599,-1.5243,-1.3074,-0.059888,0.40113,1.3774,1.4859,1.3232,1.2689,0.53673,0.50961,0.75368,0.50961,0.31978,0.26554,0.048588,0.69944,0.37402,-0.16836,-0.33108:2
-0.019618,-0.76511,-1.3144,-1.7068,-1.746,-1.3537,-1.2359,-0.84358,-0.29427,0.37275,1.1575,1.3144,0.76511,0.2158,-0.25504,-0.058855,-0.019618,0.92205,1.2359,1.4321,1.079,0.92205,0.41198,-0.2158:1
-0.98144,-0.95193,-1.3947,-1.2471,-1.6013,-1.5128,-1.2766,-0.62724,0.34683,1.1733,1.2914,1.439,1.2028,0.8191,0.90765,0.90765,0.93717,0.73055,0.40586,0.081172,-0.27303,-0.30255,-0.007379,-0.066414:2
-0.36838,-0.87248,-1.1439,-1.4154,-1.4929,-1.4541,-1.2215,-0.79493,-0.98882,0.019389,0.44594,0.75615,0.95004,0.36838,-0.058166,-0.13572,-0.058166,0.83371,1.3378,1.5705,1.5705,1.2603,0.6786,0.21327:1
-0.85573,-1.3823,-1.4613,-1.5403,-1.5666,-1.4087,-1.119,-0.64509,0.48711,1.435,1.119,1.119,0.90839,0.27647,0.25014,0.53977,0.5661,0.32913,0.25014,1.4613,0.90839,0.46078,0.013165,-0.14482:2
-0.60581,-0.98911,-1.3468,-1.5002,-1.5257,-1.6024,-1.6024,-0.63137,0.74848,1.4129,1.3618,1.3618,1.1062,0.59517,0.74848,0.69738,0.64627,0.49296,0.26298,0.18632,-0.14586,0.084111,0.21188,0.033006:2
-0.69291,-1.2431,-1.5181,-1.5932,-1.6432,-1.4181,-1.2931,-0.36781,0.55745,1.0326,1.1826,1.3077,1.1326,0.60747,0.7325,0.7325,0.78252,0.63247,0.3824,0.45742,0.68249,0.35739,-0.16776,-0.64289:2
-0.99315,-1.2684,-1.5437,-1.6814,-1.6355,-1.452,-1.1308,-0.16728,0.63565,1.1403,1.0945,1.0945,1.0027,0.61271,0.65859,0.63565,0.72741,0.68153,0.68153,1.0486,0.19978,0.19978,-0.2361,-0.30492:1
-0.8659,-1.3291,-1.6028,-1.5397,-1.6239,-1.5397,-1.1817,-0.15002,0.69219,1.1133,0.98697,0.86064,0.75536,0.35531,0.52375,0.46058,0.56586,0.83958,1.1975,1.1133,0.67114,0.3132,-0.12896,-0.4869:1
-0.48952,-0.86131,-0.93567,-1.2703,-1.6421,-1.419,-1.01,-0.67542,0.58867,1.3694,1.5925,1.4066,0.7002,0.14252,-0.26645,-0.22927,-0.41516,-0.30363,0.068161,1.704,1.3322,0.84892,0.25406,-0.48952:1
-0.7732,-1.2253,-1.4965,-1.5417,-1.6321,-1.3835,-1.2705,-0.728,0.17611,1.035,1.0576,1.1254,0.94461,0.53776,0.44735,0.60557,0.71858,0.67337,1.035,1.1932,0.67337,0.42474,-0.14033,-0.45676:1
-0.39086,-0.94266,-1.1935,-1.2938,-1.344,-1.344,-0.99283,-0.8925,0.26127,1.2645,1.6659,1.716,1.4652,0.9134,0.61242,0.71275,0.81307,0.66258,0.11078,-0.19021,-0.79217,-0.29053,0.060615,-0.59152:2
-0.2056,-0.63844,-1.2444,-1.5474,-1.634,-1.4175,-1.028,-0.89814,-0.81157,-0.11903,0.48694,1.0064,1.0929,0.44366,0.22724,0.010821,0.010821,-0.16231,0.27052,1.2661,1.7422,1.4825,1.2661,0.40038:1
-0.97337,-1.2421,-1.5315,-1.5315,-1.6142,-1.5522,-1.2008,-0.22913,0.76319,1.1146,1.0733,0.94925,0.68049,0.26703,0.32905,0.43242,0.55646,0.63915,1.1973,1.218,0.84588,0.30838,-0.12576,-0.37384:1
-0.47718,-0.908,-1.4106,-1.5183,-1.5901,-1.4465,-1.1593,-0.83619,0.27674,1.282,1.7846,1.3897,1.3897,0.67165,0.16903,-0.010471,-0.010471,0.20493,0.34854,0.63575,0.67165,0.70755,0.24084,-0.40538:2
-0.18081,-1.0907,-1.3357,-1.5807,-1.6857,-1.4757,-1.3007,-0.70576,0.48412,0.79909,1.0091,1.0091,0.6241,0.13415,-0.14582,-0.11082,-0.11082,1.184,1.359,1.394,0.97407,0.76409,0.30914,-0.3208:1
-0.99565,-1.243,-1.4523,-1.5664,-1.5854,-1.4523,-1.2049,-0.27269,1.021,1.1161,1.1352,1.002,0.84979,0.50734,0.46929,0.54539,0.67856,0.98297,1.021,0.84979,0.33611,0.069759,-0.27269,-0.53905:1
-0.91589,-1.3272,-1.6357,-1.6872,-1.6615,-1.4301,-1.2501,-0.067487,0.65237,1.218,1.2951,1.1666,0.88375,0.54953,0.54953,0.60095,0.57524,0.39528,0.18961,0.4467,0.85805,0.57524,0.11248,-0.093196:1
-0.92633,-1.3998,-1.5233,-1.6262,-1.585,-1.3792,-1.1733,-0.22644,1.091,1.1733,1.0293,0.88516,0.59697,0.32936,0.39112,0.4117,0.53521,0.92633,1.1939,0.94691,0.67931,0.24702,-0.22644,-0.37053:1
-0.91017,-1.285,-1.4213,-1.5577,-1.5236,-1.5577,-1.1487,-0.73978,0.31664,1.1004,1.2368,1.2027,1.0664,0.62335,0.72558,0.89597,0.93005,0.72558,0.14625,-0.024139,0.11217,0.89597,0.28257,-0.092295:2
-0.78543,-1.2277,-1.5647,-1.67,-1.6279,-1.3752,-1.1645,-0.23782,0.85739,1.0048,1.0891,1.068,0.87845,0.5204,0.28872,0.43615,0.47828,0.5204,1.2154,1.1523,0.66783,0.33084,-0.23782,-0.61693:1
-0.31543,-1.0197,-1.2661,-1.3718,-1.5478,-1.4422,-1.0901,-0.59712,0.49442,1.4803,1.5155,1.4099,0.98738,0.84654,0.81132,0.98738,0.88175,0.70569,0.35358,-0.13938,-0.66755,-0.59712,-0.2098,-0.2098:2
-0.84819,-0.95793,-1.342,-1.2323,-1.5066,-1.4518,-1.5066,-1.5066,0.44124,1.2369,1.2369,1.182,0.96251,0.60585,0.55098,0.77046,0.98994,0.82533,0.60585,0.41381,0.11203,0.22177,0.13946,0.057156:2
-1.1511,-1.4006,-1.514,-1.6501,-1.582,-1.4459,-1.0377,-0.47064,0.55002,1.0263,1.0263,1.1397,0.70879,0.4593,0.50466,0.64075,0.5727,0.43662,0.36857,1.2758,1.0036,0.59539,0.16444,-0.22114:1
-1.117,-1.4017,-1.5989,-1.7084,-1.6646,-1.4674,-1.0075,-0.37234,0.56946,1.0732,1.117,0.85419,0.65707,0.45995,0.41614,0.50375,0.54755,0.50375,0.41614,1.2922,0.94179,0.59136,0.19712,0.19712:1
-0.75546,-1.2874,-1.5091,-1.6864,-1.5756,-1.5312,-1.2653,-0.13484,0.77393,1.2172,1.0399,0.97341,0.6631,0.33063,0.26413,0.35279,0.41929,0.44145,1.2394,1.2837,0.77393,0.33063,-0.068342,-0.28999:1
-0.49762,-1.0564,-1.4405,-1.5453,-1.6151,-1.4056,-1.1262,-0.4627,0.13095,0.41032,0.96906,0.75953,0.82937,0.13095,-0.2881,-0.11349,0.026191,0.3754,1.5976,1.7373,1.3532,0.89922,0.48016,-0.14841:1
-0.80508,-1.3193,-1.5087,-1.4275,-1.5357,-1.6169,-1.3193,-0.61565,0.49387,0.71037,1.008,0.84568,0.68331,0.27738,0.41269,0.548,0.65624,0.43975,1.2516,1.4952,0.8998,0.65624,-0.020296,-0.20973:1
-0.63738,-1.1753,-1.5195,-1.7346,-1.5195,-1.5625,-1.2183,-0.25011,0.67503,1.2129,1.1699,1.0623,0.84715,0.41685,0.28776,0.39534,0.45988,0.56746,1.2344,1.0193,0.52443,0.37382,0.094128,-0.72344:1
-0.82741,-1.3117,-1.5013,-1.6697,-1.5644,-1.5223,-1.1222,-0.069316,0.75195,1.2152,1.1942,1.0678,0.77301,0.33079,0.3729,0.43608,0.56243,0.70983,1.1099,1.0468,0.58348,0.2255,-0.2799,-0.51154:1
-0.88857,-1.1999,-1.5557,-1.6002,-1.6224,-1.5335,-1.3778,-0.68844,0.33449,0.97938,1.224,1.0239,1.0239,0.69029,0.66805,0.62358,0.66805,0.71253,0.71253,0.62358,0.44568,0.62358,0.13435,-0.021311:2
-0.76232,-1.3505,-1.5053,-1.6291,-1.5982,-1.6601,-1.1648,-0.32892,0.75458,1.2809,1.0951,1.157,1.0022,0.5998,0.53788,0.66171,0.72362,0.3831,0.16639,0.13544,0.94032,0.66171,0.042566,-0.14318:2
-0.87537,-1.2047,-1.512,-1.5779,-1.5559,-1.4242,-1.1827,-0.26069,1.0784,1.2541,1.3419,1.0784,0.815,0.55157,0.37594,0.50766,0.41985,1.0345,0.83696,0.74914,0.37594,0.024697,-0.3485,-0.50217:1
-1.0977,-1.403,-1.5993,-1.6647,-1.6647,-1.4903,-1.0323,-0.15993,0.73423,1.0396,1.0614,1.0832,0.6688,0.49433,0.4071,0.62519,0.51614,0.58157,0.45072,1.1704,0.77785,0.647,0.058157,-0.20355:1
-0.33616,-0.87659,-1.2626,-1.4556,-1.4942,-1.5714,-1.1854,-0.027343,0.47448,1.3623,1.6325,1.3237,1.0149,0.12707,-0.41336,-0.25896,-0.065945,-0.065945,0.32008,1.5553,1.2851,0.39728,-0.065945,-0.41336:1
0.54116,0.15755,-0.66446,-0.88367,-1.1029,-1.1029,-0.77406,-1.8153,-0.88367,0.10275,0.59596,0.70556,0.48636,0.32196,-0.11645,-0.33566,-0.50006,-0.50006,-0.50006,-0.28086,0.76036,2.3496,2.0208,1.418:2
-0.35452,-0.88014,-1.1101,-1.5043,-1.5043,-1.6357,-1.3729,-0.15741,0.53246,1.1895,1.5509,1.2552,0.86098,0.26965,-0.09171,-0.32167,-0.25597,-0.058859,1.2223,1.4523,0.99238,0.49961,-0.09171,-0.48593:1
-0.83854,-1.2546,-1.5406,-1.5406,-1.5666,-1.4626,-1.4626,-0.50052,0.72153,1.1896,1.3196,1.0595,1.0856,0.74753,0.66953,0.85154,0.85154,0.51352,0.35752,0.14951,0.071503,0.20151,0.30551,0.071503:2
-0.33908,-0.79971,-1.0684,-1.3371,-1.529,-1.4139,-1.0684,-0.76132,-0.79971,-0.14715,0.77412,0.69734,0.77412,0.42864,-0.22392,-0.41585,-0.33908,0.12156,1.2347,1.7338,1.6186,1.4651,0.92766,0.46703:1
-0.094248,-0.65974,-1.508,-1.306,-1.3464,-1.5484,-1.2656,-0.90209,0.35006,1.3599,1.1579,0.91555,0.6732,0.06732,-0.29621,-0.25582,-0.25582,-0.25582,1.1579,1.7234,1.4406,0.75398,0.26928,-0.17503:1
-0.33967,-0.78272,-1.1372,-1.5802,-1.5802,-1.4916,-1.0485,-0.78272,-0.11815,0.059073,0.67934,0.72364,0.76795,0.19199,0.014768,-0.20676,-0.20676,0.45781,1.8756,1.9199,1.4768,0.81225,0.2806,0.014768:1
-0.95294,-1.382,-1.5108,-1.5537,-1.6395,-1.382,-1.2104,-0.26639,0.74197,1.2569,1.3856,1.0852,0.82779,0.37724,0.3987,0.33433,0.50597,0.37724,0.93506,1.0423,0.6347,0.3987,-0.094757,-0.3093:1
-0.5875,-0.90979,-1.3126,-1.2321,-1.3932,-1.2321,-0.74864,-1.0709,0.62107,1.7491,1.6685,1.5074,1.2656,1.1851,0.5405,0.45993,0.45993,0.13764,-0.18464,-0.34579,-0.90979,0.37936,0.13764,-0.18464:2
-1.0511,-1.4595,-1.6183,-1.5729,-1.5729,-1.4141,-1.1419,-0.098307,0.67302,1.1494,1.2175,1.036,0.69571,0.40079,0.33273,0.49153,0.60497,0.46885,0.67302,1.2856,0.78646,0.42348,-0.052934,-0.25711:1
-0.68168,-1.2489,-1.3086,-1.4579,-1.6967,-1.637,-1.3385,-0.80109,0.66177,1.0499,1.3186,1.4081,1.02,0.45279,0.63192,0.90061,0.75134,0.42294,0.39308,0.1841,-0.11444,0.57221,0.36323,0.15425:2
-0.81071,-1.1778,-1.5665,-1.7609,-1.6313,-1.5233,-1.2642,-0.076482,0.54977,0.98167,1.1112,0.96008,0.72253,0.4418,0.48499,0.57137,0.91689,0.65775,1.1112,1.0249,0.50658,0.24744,0.009898,-0.48679:1
-0.82797,-1.1786,-1.5585,-1.7339,-1.5878,-1.5001,-1.1494,-0.27274,0.89616,1.3345,1.3637,1.1884,0.92538,0.28249,0.51627,0.66238,0.72082,0.54549,0.077927,0.077927,0.31171,0.89616,0.22404,-0.2143:2
-0.69177,-1.2012,-1.381,-1.4709,-1.2312,-1.441,-1.7706,-0.63183,0.62683,1.3161,1.376,1.3161,1.1663,0.6568,0.6568,0.71674,0.95648,0.47699,0.20728,0.14734,-0.18231,-0.12237,0.32715,0.17731:2
-0.73427,-1.2807,-1.4173,-1.6905,-1.5767,-1.4856,-1.1896,-0.16507,0.60905,1.2921,1.4287,1.2693,0.8595,0.3586,0.33583,0.49521,0.51797,0.3586,0.51797,1.1782,0.63181,0.3586,-0.11953,-0.55213:1
0.83015,0.10419,-0.54111,-0.94442,-0.86376,-0.7831,-0.54111,-0.29912,-0.1378,0.74949,1.3948,1.2335,0.10419,-0.057136,-0.7831,-1.0251,-1.1864,-1.1057,-0.94442,-0.54111,0.18485,2.3627,1.7981,0.99148:2
-0.86165,-1.285,-1.6025,-1.666,-1.5813,-1.3696,-1.158,-0.26899,0.59884,1.1915,0.91633,1.0433,0.85283,0.51417,0.34484,0.53534,0.51417,0.72583,1.2973,1.0857,0.62,0.26017,-0.26899,-0.43832:1
0.86222,-0.19103,-0.43886,-0.87255,-0.99646,-0.9345,-1.9878,-1.8638,-0.9345,-0.005163,0.86222,1.11,1.11,0.55244,-0.067119,-0.19103,-0.3769,-0.3769,-0.62472,0.30462,0.86222,1.234,1.234,1.7296:2
0.31424,-0.45172,-0.27496,-1.2177,-1.2766,-1.2177,-2.1015,-1.0409,0.37316,1.6694,1.964,1.7283,1.3159,0.54992,-0.098199,-0.33388,0.1964,-0.03928,-0.03928,-0.03928,-0.27496,-0.45172,0.37316,0.37316:2
-1.0085,-1.2646,-1.6061,-1.6275,-1.4781,-1.4354,-1.1152,-0.1334,0.76305,1.3607,1.254,1.0405,0.86977,0.29348,0.37886,0.46423,0.44289,0.33617,1.0832,1.1046,0.57095,0.33617,-0.21878,-0.41087:1
-0.76715,-1.1723,-1.5324,-1.6225,-1.5099,-1.5999,-1.1498,-0.22696,1.0335,1.1685,1.056,1.011,0.65086,0.2232,0.13317,0.42578,0.53832,0.65086,1.2811,1.146,0.67336,0.2232,0.020632,-0.65461:1
-0.99683,-1.245,-1.5925,-1.5676,-1.5925,-1.4932,-1.1209,-0.42603,0.59148,1.1623,1.1375,0.98856,0.79002,0.34331,0.24404,0.49221,0.49221,0.4674,0.41776,1.3608,1.0382,0.76521,0.045499,-0.30195:1
-1.1453,-1.4375,-1.5418,-1.5836,-1.6045,-1.4375,-1.0409,-0.22697,0.50351,1.1296,0.98355,0.85832,0.69135,0.2948,0.39916,0.46177,0.54526,0.60787,1.3175,1.1714,0.83745,0.46177,0.065222,-0.31046:1
-0.9363,-1.3781,-1.4413,-1.5254,-1.5886,-1.4623,-1.1677,-0.24196,0.49445,1.0205,1.0836,0.95734,0.78902,0.32613,0.45237,0.49445,0.78902,1.2309,1.1257,1.0625,0.53653,0.1578,-0.26301,-0.51549:1
-0.75456,-1.3532,-1.6226,-1.6226,-1.5927,-1.5927,-1.3233,-0.12597,0.68222,1.3408,1.251,1.1312,0.95162,0.65229,0.59243,0.59243,0.62236,0.38289,0.2033,0.26316,0.38289,0.71216,0.23323,-0.006236:1
-0.78228,-1.2563,-1.5459,-1.5986,-1.6249,-1.5722,-1.1509,-0.28197,0.45533,0.69231,1.0083,0.98197,0.79764,0.61332,0.16567,0.271,0.50799,1.0873,1.3243,1.1926,0.79764,0.37633,-0.044984,-0.41363:1
-0.79105,-1.3335,-1.3335,-1.6475,-1.7046,-1.619,-1.3335,-0.16297,0.40802,1.2074,1.2645,1.1788,0.95045,0.43656,0.49366,0.77915,0.8648,0.55076,0.60786,0.35092,0.66496,0.43656,-0.10587,-0.16297:2
-0.19223,-0.69621,-0.92882,-1.1614,-1.3165,-1.3165,-1.0451,-0.69621,-0.92882,-0.15346,0.3893,0.54437,0.46683,0.001615,-0.3473,-0.42484,-0.50237,-0.075921,1.3585,1.9013,1.94,1.5523,1.0871,0.54437:1
-0.49489,-1.0307,-1.2689,-1.2986,-1.4772,-1.5368,-1.6856,-0.88187,0.57675,1.1423,1.321,1.44,1.053,0.69582,0.63629,0.93397,0.9042,0.84466,0.45768,0.070699,-0.28652,-0.22698,0.16,-0.048373:2
0.35239,-0.17291,-0.75075,-1.171,-1.171,-1.0134,-1.6963,-1.171,0.45745,2.0334,2.0859,1.5606,1.0878,0.8777,-0.015321,0.037209,-0.015321,0.037209,-0.17291,-0.067852,-0.75075,-0.69822,0.29986,0.037209:2
-0.56862,-1.0819,-1.3536,-1.6253,-1.6857,-1.565,-1.2328,-0.74977,0.48811,1.3033,1.3637,1.2731,0.94099,0.54849,0.85041,0.85041,0.85041,0.72964,0.27676,0.095608,-0.14593,0.48811,0.035224,-0.085544:2
-0.89012,-1.2233,-1.4977,-1.5761,-1.6153,-1.4977,-1.2429,-0.43934,0.83458,1.0502,1.0698,1.0306,0.81499,0.42301,0.5798,0.5798,0.67779,0.6582,1.1286,0.91298,0.71699,0.24662,-0.26295,-0.47854:1
0.20965,-0.57509,-1.1752,-1.4521,-1.6829,-1.4983,-0.99053,0.25581,0.76358,1.7791,1.7791,1.5022,0.90206,0.25581,-0.2058,-0.25196,-0.34428,-0.4366,-0.52893,-0.29812,1.0405,0.99438,0.20965,-0.25196:2
0.13,-0.78765,-1.2924,-1.43,-1.6135,-1.43,-1.1547,0.13,0.72647,1.6441,1.9194,1.5065,1.0018,0.17588,-0.65,-0.14529,-0.099412,-0.19118,-0.32882,-0.14529,0.72647,1.0476,0.40529,-0.14529:2
-0.18616,-0.59233,-1.1203,-1.4859,-1.4453,-1.4047,-1.1203,-0.83603,-0.67356,-0.22678,0.58556,0.74802,0.66679,0.05754,-0.18616,-0.10493,-0.51109,0.26062,1.4385,1.6822,1.8853,1.1542,0.95111,0.46371:1
-0.84074,-1.1956,-1.5504,-1.645,-1.716,-1.5504,-1.1483,0.15277,0.69684,1.2882,1.2172,1.099,0.88608,0.38932,0.41298,0.2947,0.43663,0.38932,0.62587,1.2172,0.72049,0.36567,-0.1784,-0.36764:1
-1.0998,-1.303,-1.5616,-1.617,-1.617,-1.4507,-1.1552,-0.23166,0.82119,1.0798,0.96895,0.91354,0.7473,0.4333,0.45177,0.54412,0.7473,0.82119,1.1537,1.0059,0.56259,0.24859,-0.15777,-0.30554:1
0.14516,-0.64663,-1.1217,-1.2801,-1.2801,-1.4384,-1.8607,-1.1745,0.46188,1.5704,1.9399,1.5704,0.98974,0.51466,0.092375,-0.065982,-0.065982,-0.065982,0.039589,0.19795,0.19795,0.40909,0.83138,0.039589:2
-0.93077,-1.3856,-1.5461,-1.7066,-1.5996,-1.5728,-0.95753,-0.2352,0.2731,1.2094,1.3432,1.1559,0.96867,0.64764,0.62089,0.7279,0.7814,0.56738,0.19284,0.2731,0.7814,0.51388,0.059079,-0.1817:2
-0.8441,-1.3437,-1.6163,-1.48,-1.5481,-1.5254,-1.1621,-0.18547,0.47315,1.2226,1.1999,1.0409,0.72297,0.29146,0.40502,0.45044,0.49586,0.60942,1.2226,1.1545,0.72297,0.33688,-0.14005,-0.50343:1
-0.48476,-0.96951,-1.385,-1.4543,-1.385,-1.2465,-0.83101,-1.2465,-0.20775,1.3158,1.108,1.3158,1.4543,1.108,1.2465,0.90026,0.96951,0.20775,0.20775,0.069251,-0.69251,-0.20775,0.277,-0.069251:2
0.16253,-0.56617,-0.95195,-1.2091,-1.3377,-1.252,-0.86622,-1.2091,-0.48044,0.16253,0.76263,0.89122,0.63404,0.16253,-0.22325,-0.5233,-0.5233,-0.60903,-0.13752,1.6628,2.0486,1.8342,1.0198,0.54831:1
0.92672,0.05792,-0.98464,-0.98464,-1.0426,-0.92672,-1.5059,-1.7376,-0.81088,0.11584,0.98464,0.92672,0.81088,0.2896,-0.23168,-0.11584,-0.11584,-0.40544,-0.46336,0.05792,0.11584,0.98464,2.201,1.8534:2
-0.79638,-1.36,-1.5394,-1.565,-1.6931,-1.5394,-1.0782,-0.41207,0.71525,1.2789,1.2789,0.99708,0.81774,0.4078,0.43342,0.58715,0.79211,0.8946,0.71525,0.61277,0.33094,0.58715,-0.002135,-0.46331:2
-0.29354,-0.48602,-1.0635,-1.3714,-1.4869,-1.3329,-1.1405,-0.717,-0.56301,-0.52452,0.20692,0.20692,0.66888,-0.02406,-0.13955,-0.13955,-0.25504,0.28391,1.4388,2.0163,1.7468,1.4388,1.0154,0.51489:1
-0.77556,-1.1663,-1.3895,-1.529,-1.5848,-1.3895,-1.6965,-0.41278,0.48022,1.2616,1.4011,1.4011,1.0383,0.59185,0.53603,0.70347,0.78719,0.53603,0.42441,0.3686,0.005814,-0.022093,0.25697,0.17325:2
0.97307,0.20486,-0.25607,-0.56335,-0.79382,-0.717,-0.56335,-1.6388,-1.3316,-0.56335,-0.025607,0.66578,0.28168,-0.025607,-0.33289,-0.40971,-0.48653,-0.40971,-0.56335,-0.17925,0.3585,2.3558,2.2022,1.8181:2
-0.38213,-1.2069,-1.4708,-1.5038,-1.6027,-1.4378,-1.0749,0.37663,0.54158,1.1024,1.5642,1.3003,0.83848,0.21168,-0.25017,0.046735,-0.21718,-0.18419,1.2344,1.2014,1.0034,0.4756,-0.019244,-0.54707:1
-1.0997,-1.4333,-1.5222,-1.5667,-1.5667,-1.4555,-1.1887,-0.61056,0.41229,0.92371,0.96819,0.7903,0.65688,0.43453,0.52347,0.72359,0.67912,0.63465,0.67912,1.3017,1.0349,0.65688,0.21217,-0.18808:1
-0.90778,-1.2777,-1.4216,-1.586,-1.6888,-1.5449,-1.1955,-0.085639,0.65428,1.0242,1.0448,0.88037,0.69539,0.40764,0.53096,0.71594,0.7776,1.1681,1.1065,0.96258,0.4282,-0.065086,-0.16785,-0.4556:1
-0.92835,-1.0959,-1.403,-1.6543,-1.6543,-1.6264,-1.2913,-0.1745,0.57935,1.417,1.417,1.1936,0.97023,0.57935,0.57935,0.52351,0.57935,0.49558,0.21638,0.16054,0.71895,0.55143,-0.0349,-0.11866:2
-0.92709,-1.2815,-1.408,-1.6865,-1.5346,-1.4587,-1.2815,-0.62333,0.46513,1.0473,1.098,0.89545,0.79419,0.38919,0.54106,0.51575,0.51575,0.51575,0.79419,1.4523,0.92076,0.56638,-0.09176,-0.21832:1
-0.10667,-0.54139,-0.97611,-1.2659,-1.2176,-1.1693,-1.121,-1.604,-0.7346,0.086542,0.85938,1.1975,1.0526,0.85938,-0.010063,-0.10667,-0.29988,-0.29988,-0.25158,0.23145,0.81108,2.1636,1.5839,0.85938:2
-0.71677,-1.4536,-1.6236,-1.567,-1.5953,-1.567,-1.2552,-0.20665,0.78526,1.2387,1.3521,1.1537,0.89862,0.50185,0.55853,0.50185,0.58688,0.50185,0.19011,0.16177,0.36015,0.89862,0.36015,-0.064946:2
-0.47846,-1.1815,-1.4451,-1.5916,-1.5037,-1.533,-1.2987,-0.91786,0.40034,1.1034,1.3084,1.4549,1.1327,0.6054,0.86904,0.86904,0.72257,0.40034,0.19529,0.19529,-0.068351,0.63469,0.25388,-0.12694:2
0.54148,-0.13951,-0.70699,-0.99074,-1.2177,-1.161,-0.76374,-0.5935,-1.2745,-0.30975,0.42798,0.76847,0.54148,0.087487,-0.30975,-0.42325,-0.48,-0.70699,-0.5935,0.20098,2.1304,2.1304,1.6764,1.1657:2
-0.30062,-0.94997,-1.2025,-1.4911,-1.6715,-1.4911,-1.1303,-0.80567,-0.481,0.31265,0.70947,0.63732,0.63732,0.3848,-0.12025,0.060125,0.0962,1.3588,1.467,1.6835,1.431,0.78162,0.2405,-0.15632:1
0.90938,-0.11367,-0.68203,-0.7957,-1.1367,-0.56836,-0.56836,-1.4777,-0.7957,0.34102,0.7957,0.34102,0.34102,0.0,-0.45469,-0.7957,-0.34102,-0.56836,-0.11367,-0.45469,0.0,2.6145,2.3871,1.1367:2
-0.75799,-1.0282,-1.0282,-1.2083,-1.4785,-1.3584,-1.6886,-0.99815,0.35273,1.2233,1.3434,1.2833,1.2833,0.71296,0.773,1.0732,1.0132,0.773,0.35273,0.082553,-0.21764,-0.42778,0.022515,-0.097563:2
-1.0087,-1.4349,-1.5414,-1.6693,-1.6266,-1.4988,-1.03,-0.028413,0.50433,1.0371,0.97314,0.8879,0.69612,0.37647,0.35516,0.33385,0.52564,0.61088,1.3141,1.2715,0.73874,0.52564,-0.071032,-0.24151:1
-0.79934,-1.1797,-1.5363,-1.6789,-1.465,-1.5838,-1.2748,-0.56162,0.5319,1.0787,1.0787,1.0311,0.67454,0.5319,0.38927,0.43681,0.50813,0.34172,1.1738,1.2451,0.81717,0.55567,0.080231,-0.39521:1
-0.6052,-1.1512,-1.5335,-1.6427,-1.6973,-1.4243,-0.82362,-0.93283,0.21387,0.97833,1.2514,1.3606,1.306,0.81452,0.81452,0.81452,0.75991,0.15926,0.15926,-0.059155,-0.11376,0.92373,0.43229,-0.00455:2
0.45181,-0.46571,-0.96618,-1.3832,-1.4666,-1.2164,-0.88277,-1.6335,-0.29889,0.86886,1.4527,1.2025,1.0357,0.034755,-0.13207,-0.29889,-0.13207,-0.21548,-0.13207,-0.048656,0.034755,2.12,1.4527,0.61863:2
-0.76995,-1.2019,-1.3699,-1.7299,-1.5859,-1.5619,-1.1059,-0.50597,0.50197,1.1259,1.0539,0.88594,0.54996,0.30998,0.33398,0.35798,0.45397,0.54996,1.4139,1.4139,0.83794,0.47797,-0.025998,-0.40997:1
-0.91944,-1.31,-1.6224,-1.4662,-1.5639,-1.4272,-1.1538,-0.27502,0.89666,1.1505,1.0529,0.95524,0.81854,0.48657,0.40846,0.54515,0.52563,1.17,1.0334,0.97477,0.44751,0.11554,-0.3336,-0.50935:1
-0.78694,-1.284,-1.4579,-1.5325,-1.5325,-1.4082,-1.5076,-0.73724,0.30649,1.0272,1.1266,1.1514,1.0023,0.7041,0.85321,0.97746,1.0272,0.75381,0.4059,0.23194,-0.066269,-0.041418,0.5053,0.28164:2
-0.80759,-1.157,-1.2735,-1.6695,-1.6462,-1.4366,-1.1337,-0.83088,0.47368,1.1493,1.1726,1.0794,0.75323,0.28731,0.42709,0.45038,0.47368,0.40379,1.2424,1.289,0.82312,0.47368,-0.062122,-0.48145:1
1.7829,0.56303,0.46919,-0.093838,0.18768,0.18768,0.18768,-1.5014,-0.84454,-0.65686,-0.46919,-0.093838,-0.65686,-0.56303,-0.56303,-0.7507,-0.84454,-0.56303,-0.37535,-0.46919,-0.84454,2.2521,1.9706,1.6891:2
0.19869,-0.72724,-0.81983,-1.0976,-1.6069,-1.6069,-1.2365,-1.0976,0.56906,1.495,1.9579,1.8191,1.2635,0.47646,0.013503,-0.17168,-0.12539,-0.26427,-0.40316,0.1061,0.013503,0.75424,0.52276,-0.032793:2
-0.19804,-0.82578,-1.3638,-1.2742,-1.6329,-1.2742,-1.0051,-1.0948,-0.018683,1.2368,1.5955,1.8645,0.96777,0.96777,0.25035,0.25035,0.16067,0.34003,-0.018683,-0.018683,-0.91546,1.0574,0.78842,0.16067:2
0.42098,-0.46776,-0.98229,-1.0758,-1.0758,-1.4968,-1.9646,-1.0291,0.56131,1.5436,2.0114,1.7307,1.3097,0.46776,-0.28065,0.0,-0.046776,0.1871,-0.28065,-0.14033,0.093552,0.046776,0.51453,-0.046776:2
-0.33852,-0.91067,-1.1777,-1.4065,-1.4447,-1.521,-1.1777,-0.87253,-1.0632,-0.10966,0.57692,0.9202,0.88206,0.46249,-0.071518,0.004768,-0.033375,0.99649,1.3779,1.4924,1.4161,1.0346,0.76763,0.19548:1
1.0926,0.51274,-0.002685,-0.45368,-0.5181,-0.58253,-1.7422,-1.6134,-0.71139,0.061743,0.57716,0.83487,0.38388,-0.067112,-0.5181,-0.64696,-0.64696,-0.77581,-0.38925,-0.32482,0.25503,0.57716,2.3811,2.3167:2
-1.0095,-1.3547,-1.5273,-1.5489,-1.6136,-1.5273,-1.0958,-0.10338,0.7596,1.1479,1.2342,0.95377,0.73802,0.26339,0.43598,0.41441,0.39283,0.22024,1.2558,1.1479,0.80275,0.37126,-0.081803,-0.27597:1
-0.73962,-1.0967,-1.4027,-1.6578,-1.6068,-1.5557,-1.0457,-0.99465,0.025504,0.84163,1.0457,1.3517,1.2497,0.89264,1.0457,0.99465,0.6376,0.53558,0.28054,0.076512,0.076512,0.6376,0.43357,-0.025504:2
-0.7477,-1.2071,-1.3422,-1.3693,-1.5044,-1.4233,-1.6125,-0.66662,0.27926,1.1711,1.1981,1.1981,1.036,0.79274,0.95489,0.90084,1.1441,0.73869,0.41439,0.30629,-0.18017,-0.23422,0.14413,0.009008:2
-0.80855,-1.091,-1.5712,-1.6277,-1.7124,-1.5712,-1.3452,-0.4131,0.97096,1.0839,1.2534,1.2252,0.91447,0.49078,0.60376,0.6885,0.54727,0.43428,0.29305,0.29305,0.40604,0.82973,0.18007,-0.074146:2
-0.9013,-1.1302,-1.5022,-1.7311,-1.6452,-1.4735,-1.3019,-0.12876,0.61517,1.3019,1.3019,1.2446,0.9013,0.41488,0.50072,0.61517,0.64378,0.35766,0.12876,0.35766,0.98713,0.64378,0.042919,-0.24321:2
-0.61864,-0.97917,-1.3725,-1.5364,-1.5364,-1.4052,-1.2741,0.56128,0.62683,1.184,1.479,1.0857,0.79071,0.069648,-0.22533,-0.19256,-0.22533,0.004097,1.0857,1.3807,1.184,0.62683,-0.15978,-0.55309:1
-0.8223,-1.2813,-1.6205,-1.6404,-1.6005,-1.4608,-1.2413,-0.2037,0.77407,1.1532,1.1133,0.87385,0.61444,0.27521,0.4548,0.43484,0.59448,0.97362,1.253,0.93371,0.57453,0.31512,-0.12388,-0.34339:1
0.58212,-0.12458,-0.88564,-1.2662,-1.4293,-0.94,-1.1031,-0.55947,-0.66819,0.092868,0.79957,1.2345,1.1801,0.69084,0.20159,-0.72256,-0.66819,-0.88564,-0.77692,-0.34202,1.017,2.1042,1.615,0.85393:2
-1.0463,-1.2716,-1.547,-1.4469,-1.547,-1.2466,-1.2716,-0.54558,0.53097,1.3822,1.257,1.257,0.85644,0.45587,0.35572,0.38076,0.53097,0.38076,0.43083,1.2821,0.85644,0.43083,-0.01982,-0.44543:1
-0.50099,-0.93298,-1.365,-1.581,-1.581,-1.509,-0.93298,-1.437,0.003,1.155,1.299,1.371,1.227,1.083,0.43499,0.21899,0.65098,0.50699,0.72298,0.43499,-0.141,0.65098,0.36299,-0.141:2
-1.2122,-1.3759,-1.5396,-1.6098,-1.6332,-1.3525,-1.0485,-0.37028,0.21438,0.75226,0.91597,0.96274,0.91597,0.40147,0.54179,0.49501,0.5184,0.75226,1.3369,1.2434,0.72888,0.5184,0.074057,-0.22997:1
-0.63648,-1.0321,-1.3363,-1.4276,-1.4885,-1.6406,-1.5798,-0.81905,0.70241,1.2197,1.4327,1.3414,0.97627,0.70241,0.76326,0.70241,0.85455,0.55026,0.24597,0.30683,0.032965,0.093823,0.21554,-0.18004:2
0.18376,-0.2832,-1.2171,-1.4247,-1.0615,-1.6841,-1.269,-1.1652,0.85825,1.8959,1.9478,1.5327,1.0139,0.33941,-0.23132,-0.17943,-0.23132,-0.23132,-0.12755,0.079988,-0.02378,0.44318,0.59883,0.23564:2
-1.1497,-1.4486,-1.5607,-1.5046,-1.6354,-1.4299,-1.0189,-0.19693,0.83054,1.1481,1.1294,1.0734,0.7745,0.40087,0.4756,0.53164,0.60637,0.60637,1.0734,0.94263,0.569,0.32615,-0.15957,-0.38375:1
-0.8838,-1.3253,-1.5355,-1.4724,-1.5985,-1.5355,-1.2412,-0.04292,0.69285,1.1553,1.2184,1.1133,0.77694,0.46161,0.41956,0.46161,0.56672,0.5457,0.94512,1.1133,0.7349,0.23037,-0.2111,-0.58949:1
-0.40285,-1.0808,-1.3166,-1.5524,-1.4935,-1.464,-1.5819,-0.84499,0.65831,1.3363,1.3657,1.2773,1.012,0.59936,0.74674,0.86464,0.95307,0.59936,0.21616,-0.019651,-0.13756,-0.019651,0.4225,-0.13756:2
-1.0102,-1.1284,-1.4832,-1.6725,-1.6488,-1.3413,-1.1284,-0.3479,0.409,1.1659,1.0476,1.0003,0.59822,0.10151,0.4563,0.4563,0.50361,0.52726,1.4497,1.3315,0.8111,0.409,-0.13502,-0.37155:1
-0.94843,-1.2693,-1.4757,-1.659,-1.5673,-1.5673,-1.2235,-0.008596,0.56447,1.0917,1.0459,0.88539,0.74786,0.26648,0.31232,0.49571,0.44986,0.65617,1.2751,1.3209,0.72493,0.35817,-0.14613,-0.32952:1
-0.9367,-1.2297,-1.425,-1.6398,-1.5812,-1.5031,-1.2883,-0.27263,0.66489,1.0555,1.1336,1.1727,0.84067,0.37191,0.37191,0.62583,0.60629,0.78208,1.0946,0.97739,0.56723,0.29379,-0.21403,-0.46794:1
-0.62538,-1.1953,-1.2496,-1.4396,-1.7924,-1.6296,-1.4396,-0.27254,0.48741,1.3016,1.4645,1.3831,1.0574,0.56883,0.62311,0.51455,0.32456,0.27028,0.18886,0.37884,0.92167,0.40599,0.02601,-0.27254:2
0.34972,-0.35665,-0.93836,-1.1046,-0.97991,-1.1046,-1.0215,-0.89681,-0.85526,-0.14889,0.51593,0.51593,0.26662,-0.19044,-0.5644,-0.6475,-0.73061,-0.3982,2.2195,1.804,1.7209,1.3469,0.84833,0.34972:1
-0.65913,-1.3158,-1.465,-1.6441,-1.4948,-1.6142,-1.3158,-0.30096,0.47507,1.3705,1.2511,1.1616,1.0123,0.53476,0.65415,0.65415,0.80339,0.47507,0.1169,-0.062182,0.89293,0.56461,0.20644,-0.30096:2
-0.99165,-1.2593,-1.4652,-1.6093,-1.5475,-1.3828,-1.2387,-0.2299,0.6142,1.1289,0.94361,1.2113,0.75832,0.51126,0.40833,0.53185,0.67597,1.1289,1.1083,0.86126,0.53185,0.22303,-0.29166,-0.62107:1
1.203,0.42502,0.079242,-0.18009,-0.18009,0.079242,0.079242,-1.5632,-0.9581,-0.43943,-0.52588,-0.007204,-0.18009,-0.69877,-0.87166,-1.0445,-0.35298,-0.26654,-0.52588,-0.35298,-0.18009,2.1539,2.6726,1.6353:2
-1.1543,-1.4552,-1.4953,-1.5756,-1.5154,-1.4151,-1.1543,-0.63274,0.53077,0.81161,1.0724,1.1326,0.99216,0.73137,0.51071,0.71131,0.65113,0.59095,0.67119,1.0523,0.75143,0.45052,-0.071047,-0.19141:2
-0.89161,-1.287,-1.5341,-1.5093,-1.5835,-1.4599,-1.4846,-0.81748,0.29446,1.2087,1.2087,0.98633,0.93691,0.51684,0.71452,0.76394,0.81336,0.51684,0.46742,0.51684,0.36859,0.56626,0.54155,0.1462:2
-0.58061,-1.1742,-1.3929,-1.3929,-1.4867,-1.6429,-1.2055,-0.20569,0.41918,1.169,1.5752,1.3252,0.82535,0.41918,-0.018225,-0.049469,0.044262,0.45043,1.2003,1.2003,0.88784,0.3567,-0.1432,-0.58061:1
-0.6322,-1.187,-1.3559,-1.5971,-1.6212,-1.5006,-1.1629,-0.55983,0.52566,1.394,1.4664,1.3217,1.1769,0.83924,0.76688,0.74275,0.52566,0.42917,0.21207,0.16383,0.019097,0.45329,-0.005025,-0.4151:2
-0.20481,-0.65167,-0.89541,-1.3017,-1.4235,-1.3423,-1.1798,-0.81417,-1.0173,-0.001693,0.60766,0.68891,0.48579,0.24205,-0.042316,-0.36731,-0.36731,-0.24544,1.2983,1.9076,1.7858,1.4608,0.85141,0.52642:1
-0.76071,-1.1124,-1.656,-1.56,-1.4961,-1.592,-1.2723,-0.76071,0.55021,1.4135,1.0618,1.2217,0.96587,0.39035,0.77403,0.74206,0.86995,0.67811,0.3264,0.1985,0.3264,0.61416,0.16653,-0.08926:2
-1.0799,-1.3906,-1.5115,-1.5633,-1.5115,-1.4597,-1.1144,-0.35468,0.4741,1.0439,1.182,1.0784,0.85396,0.6295,0.5777,0.68129,0.76763,0.95755,0.95755,0.81942,0.4741,0.14604,-0.19928,-0.45827:1
-0.41837,-1.0699,-1.2998,-1.3381,-1.4148,-1.2998,-0.80161,-0.57167,0.92297,1.6894,1.4595,1.1912,1.0379,0.30979,-0.26507,-0.45669,-0.38005,-0.38005,-0.073454,1.4978,1.1912,0.808,0.11817,-0.45669:1
-0.80092,-1.2008,-1.3341,-1.4941,-1.5208,-1.4941,-1.5474,-0.77426,0.55876,1.1986,1.2519,1.3319,1.092,0.61208,0.6654,0.85202,0.932,0.58542,0.45212,0.18551,0.02555,0.13219,0.26549,0.02555:2
-0.41979,-0.87042,-1.2889,-1.7395,-1.5786,-1.6429,-1.2245,-0.25885,0.61024,1.0931,0.93212,1.3506,1.0287,0.38492,-0.13009,-0.097906,-0.033529,0.063035,1.3828,1.3506,0.89993,0.61024,0.030847,-0.45198:1
-0.85785,-1.1353,-1.3573,-1.496,-1.5515,-1.3296,-1.607,-0.8856,0.50176,1.1954,1.2787,1.1399,0.94572,0.72374,0.86247,0.89022,1.0012,0.72374,0.19654,0.27978,0.030059,0.002312,0.36303,0.085554:2
-0.83433,-1.1733,-1.5607,-1.7544,-1.706,-1.4639,-1.1733,-0.059523,0.5458,1.1269,1.0543,0.95741,0.57001,0.23103,0.37631,0.37631,0.40052,0.49737,1.3448,1.2964,0.7395,0.27946,0.27946,-0.35008:1
-0.47787,-0.95573,-1.4898,-1.6023,-1.4898,-1.6585,-1.7147,-0.67464,0.5622,1.1806,1.3493,1.1806,1.1244,0.61842,0.50598,0.70274,0.70274,0.50598,0.36543,0.33732,0.33732,0.47787,0.19677,-0.084329:2
-0.90853,-1.2624,-1.5346,-1.5619,-1.6435,-1.5346,-1.1263,-0.44576,0.67034,1.3237,1.3509,1.242,1.0242,0.56145,0.64312,0.72479,0.72479,0.45257,0.31646,0.50701,0.18035,0.47979,0.017014,-0.20076:2
-0.58604,-1.2367,-1.6372,-1.6121,-1.5371,-1.462,-1.3118,-0.68615,0.51513,1.1908,1.341,1.2409,1.1658,0.64026,0.66529,0.74037,0.81545,0.51513,0.33994,0.46508,0.16476,0.28989,-0.035454,0.014599:2
-0.58636,-1.4079,-1.3549,-1.5139,-1.5139,-1.5404,-1.4079,-0.74537,0.50023,1.0303,1.1363,1.0568,0.81825,0.44722,0.47373,0.50023,0.55323,0.52673,0.34121,1.3218,1.0568,0.65924,0.1557,-0.50685:2
-0.28246,-1.0119,-1.3551,-1.4409,-1.398,-1.5696,-1.1406,-1.0119,-0.025028,1.0476,1.6054,1.348,1.2192,0.87599,0.79018,1.0047,0.96181,0.53275,0.27531,-0.025028,-0.5828,-0.32537,0.23241,0.27531:2
-0.79589,-1.1791,-1.522,-1.6027,-1.6632,-1.4817,-1.1388,-0.3118,0.49502,1.0396,1.1808,1.0396,0.87826,0.27314,0.43451,0.39417,0.53536,0.85809,1.2212,1.1405,0.69672,0.2328,-0.1101,-0.61436:1
0.15033,-0.32783,-0.84946,-1.0233,-0.97987,-1.0233,-0.84946,-1.4146,-1.0233,-0.11048,0.10686,0.49809,0.41115,-0.023546,-0.32783,-0.54518,-0.63212,-0.67559,1.3675,1.8891,1.8891,1.6718,1.1936,0.6285:1
-0.70155,-1.0333,-1.3927,-1.4204,-1.4757,-1.5033,-1.6692,-0.70155,0.65317,1.3167,1.2614,1.2891,0.95729,0.73611,0.76376,0.98494,0.81906,0.59788,0.40434,0.12787,-0.038015,-0.28684,0.12787,0.18316:2
-0.67511,-1.1708,-1.4186,-1.2018,-1.5735,-1.5116,-1.0469,-0.70609,0.4092,1.1217,1.4006,1.4315,1.3386,0.84292,0.81194,0.99782,0.99782,0.68802,0.16136,0.099395,-0.27237,-0.33433,-0.17943,-0.21041:2
-0.77791,-1.2289,-1.5671,-1.5446,-1.5896,-1.4995,-1.1838,-0.23676,0.82301,1.2289,1.1387,0.98085,0.64262,0.43969,0.41714,0.39459,0.43969,0.46224,1.1612,1.3191,0.71027,0.2593,-0.23676,-0.55243:1
-0.86968,-1.1785,-1.4359,-1.5131,-1.4874,-1.4616,-1.5388,-0.50937,0.44288,1.0348,0.98335,1.1635,0.98335,0.85467,0.90614,1.0863,0.98335,0.93188,0.52009,0.3142,-0.071848,-0.12332,0.082571,-0.097584:2
0.89931,-0.254,-0.47368,-1.5171,-1.2426,-0.91304,-2.1213,-1.1876,0.24027,1.5583,1.7231,1.8329,1.1739,0.51487,0.24027,0.020595,-0.089244,-0.30892,-0.254,-0.14416,-0.254,-0.254,0.67963,0.13043:2
-0.38532,-0.80887,-1.4795,-1.4795,-1.5501,-1.4795,-1.2677,-0.032355,0.3912,1.0265,1.203,1.0265,0.60297,0.17942,-0.31472,-0.24413,-0.35002,0.002941,1.556,1.6619,1.3089,0.53238,0.10883,-0.20884:1
-0.28216,-0.73362,-1.3732,-1.4861,-1.5989,-1.2979,-0.99697,-0.43265,0.43265,1.3732,1.2979,1.0346,0.65838,0.018811,-0.39503,-0.47027,-0.31978,-0.24454,1.4484,1.6742,1.2227,0.696,0.1693,-0.39503:1
-0.49148,-1.0228,-1.3416,-1.4744,-1.4744,-1.501,-1.5276,-0.70401,0.38521,1.315,1.2885,1.2885,1.0759,0.83685,0.78371,0.83685,0.96968,0.81028,0.43835,0.25238,0.03985,-0.43835,-0.11955,-0.22582:2
-0.83116,-1.3237,-1.57,-1.4879,-1.4605,-1.5426,-1.2416,-0.55753,0.56437,1.1664,1.1937,0.97482,0.94746,0.45492,0.42755,0.50964,0.48228,0.37283,0.48228,1.44,0.92009,0.48228,-0.010261,-0.39335:2
-0.81304,-1.0907,-1.2493,-1.5269,-1.5269,-1.5666,-1.1303,-0.77338,0.25779,1.1303,1.2493,1.2493,1.2097,1.0113,0.97169,0.97169,1.0113,0.57508,0.37678,0.01983,-0.33712,-0.21813,0.29746,-0.099152:2
-0.86145,-1.3195,-1.4444,-1.5693,-1.5693,-1.5693,-1.257,-0.17437,0.90829,1.1373,1.1165,1.0749,0.78337,0.32532,0.36696,0.47106,0.5127,0.47106,1.1165,1.0957,0.72091,0.34614,-0.21601,-0.46586:1
-0.088968,-0.72954,-1.0285,-1.242,-1.5836,-1.2847,-0.94306,-0.98576,-0.85765,0.039146,0.59431,0.80783,0.72242,0.33808,-0.088968,-0.25979,-0.30249,-0.3879,0.12456,1.79,1.8327,1.6192,1.1922,0.72242:1
-0.73591,-1.0518,-1.0781,-1.3676,-1.5519,-1.4992,-1.4992,-0.97281,0.71178,1.1329,1.2382,1.3172,1.2909,0.71178,0.76443,0.975,0.94868,0.63282,0.47489,0.21167,-0.13051,-0.26212,-0.051547,-0.20948:2
-0.3286,-0.94077,-1.3369,-1.4089,-1.553,-1.3729,-1.1928,-0.90476,-0.50865,-0.14854,0.39161,0.71571,1.0398,0.31959,0.24757,-0.11253,-0.18455,0.3556,1.2559,1.5439,1.616,1.3999,0.85975,0.24757:1
0.47668,-0.48672,-1.0888,-1.2695,-1.5103,-1.1491,-0.90821,-0.96842,0.23583,1.7412,1.982,1.8014,1.0186,0.11541,-0.54693,-0.30608,-0.36629,-0.48672,-0.42651,-0.005018,0.29605,1.3197,0.5369,-0.005018:2
-0.73125,-1.0638,-1.4732,-1.5755,-1.7034,-1.4732,-1.3708,-0.68008,0.44557,1.4945,1.341,1.1619,0.93165,0.49674,0.57349,0.7014,0.26649,0.77815,0.52232,0.59907,0.36882,0.49674,0.11299,-0.21959:2
-1.0055,-1.1924,-1.613,-1.613,-1.5195,-1.4961,-1.1924,-0.094422,0.67653,1.1905,1.0036,0.88679,0.67653,0.37282,0.30273,0.48963,0.58308,0.72325,1.3073,1.1905,0.65317,0.27937,-0.07106,-0.5383:1
0.55441,-0.17468,-0.72149,-1.1468,-1.2076,-1.2683,-1.0253,-1.5721,-0.72149,0.25062,0.79744,1.162,1.2835,0.31138,-0.11392,-0.053163,0.007595,-0.59998,-0.72149,-0.41771,0.37214,1.2227,2.0733,1.7088:2
0.10473,-0.50967,-0.9565,-1.3475,-1.515,-1.3475,-1.1799,-1.4592,-0.90064,0.43985,0.77497,0.94253,0.66326,0.43985,-0.3421,0.16058,-0.2304,-0.062836,0.048872,0.77497,1.3335,2.1155,1.2218,0.83083:2
-0.44324,-1.1644,-1.495,-1.3748,-1.4349,-1.4048,-1.7654,0.067613,0.72871,1.3297,1.4499,1.3297,0.99916,0.54841,0.78881,0.84891,0.93906,0.39816,0.24791,0.12771,-0.23289,-0.41319,0.037563,-0.11269:2
-1.1696,-1.4291,-1.529,-1.5689,-1.6088,-1.509,-1.0897,-0.13143,0.54736,0.98659,0.98659,1.1064,0.76698,0.44754,0.56733,0.5274,0.62722,0.54736,1.1862,1.0465,0.62722,0.42758,-0.07154,-0.29115:1
-0.98663,-1.3528,-1.5237,-1.6457,-1.719,-1.4504,-1.0599,-0.083406,0.50247,1.3813,1.3569,1.1616,0.94188,0.52688,0.60011,0.60011,0.67335,0.40482,0.1363,0.18512,0.72217,0.72217,0.063063,-0.15664:1
-0.33417,-1.058,-1.4344,-1.3765,-1.4923,-1.5792,-1.5213,-0.79743,0.50548,1.1714,1.403,1.2583,1.1135,0.70816,0.82397,0.96874,0.76607,0.73711,0.41862,0.2449,-0.10254,-0.47894,0.01327,0.042224:2
-0.4471,-1.0119,-1.3199,-1.5509,-1.4996,-1.4739,-1.5766,-0.75515,0.3487,1.2472,1.2985,1.1958,1.0161,0.7851,0.81077,0.9648,1.0675,0.81077,0.40004,0.169,-0.24173,-0.19039,0.11766,-0.16472:2
-0.64251,-0.95489,-1.6365,-1.4377,-1.4945,-1.6648,-1.2105,-0.67091,0.91939,1.5158,1.4022,1.3738,0.8626,0.69221,0.8058,0.63541,0.60701,0.35143,0.095844,-0.017749,-0.10294,0.46502,0.095844,0.010649:2
-0.56673,-1.0661,-1.3599,-1.5068,-1.5655,-1.448,-1.6537,-0.59611,0.72586,1.2546,1.3134,1.284,1.1078,0.69648,0.75523,0.96087,0.78461,0.54959,0.31458,-0.008568,-0.15545,-0.12608,0.16769,0.13832:2
-0.92931,-1.2588,-1.6089,-1.5471,-1.5677,-1.4236,-1.2794,-0.29089,0.67703,1.1301,1.0271,1.0477,0.84178,0.57406,0.49168,0.61525,0.71822,0.80059,1.1919,0.88297,0.34752,0.22396,-0.14673,-0.51743:1
-0.86758,-1.1713,-1.5303,-1.5856,-1.696,-1.4199,-1.3094,-0.64666,0.73411,1.2588,1.2036,1.0931,0.67888,0.43034,0.56841,0.51318,0.48557,0.26465,0.34749,1.1207,0.95503,0.62365,0.043724,-0.094352:2
-1.0199,-1.3105,-1.4223,-1.4447,-1.5341,-1.5341,-1.3552,-0.23752,0.50018,1.059,1.0814,0.90256,0.70137,0.23193,0.43312,0.43312,0.65666,0.88021,1.3273,1.1485,0.70137,0.43312,-0.10339,-0.52812:1
-0.83966,-1.3369,-1.3893,-1.4416,-1.3107,-1.4154,-1.4678,-0.63029,0.52124,1.2017,1.2017,1.2017,1.097,0.88764,0.80913,0.99233,1.0185,0.67827,0.57359,0.02399,-0.23772,-0.29006,0.15485,-0.002181:2
0.1187,-0.73169,-0.94428,-0.94428,-0.90177,-1.1144,-1.0718,-1.497,-0.73169,-0.008858,0.3313,0.28878,0.54389,0.16122,-0.093897,-0.34901,-0.56161,-0.60413,0.076181,1.8195,1.8195,1.862,1.4368,1.0966:1
-0.73168,-1.1713,-1.5132,-1.7086,-1.6598,-1.3423,-1.3667,-0.21879,0.41621,1.2466,1.1978,0.97794,0.68487,0.5139,0.48948,0.5139,0.46506,0.5139,0.73371,1.3443,0.85583,0.39179,-0.047829,-0.58514:1
-0.95303,-1.1541,-1.5561,-1.6455,-1.5338,-1.4668,-1.2434,-0.10424,0.76689,1.1019,1.1689,1.1466,0.92325,0.32016,0.32016,0.43184,0.49885,0.4095,1.2136,1.0573,0.72222,0.25315,-0.23826,-0.43929:1
-0.59244,-0.94717,-1.2132,-1.5088,-1.4793,-1.4201,-1.5384,-0.71069,0.61954,1.5359,1.4768,1.2403,1.2403,0.76734,0.76734,0.82646,0.85603,0.47174,0.057889,-0.001232,-0.20816,-0.23772,0.057889,-0.060353:2
-0.7596,-1.0585,-1.4117,-1.4388,-1.6018,-1.4932,-1.5203,-0.97695,0.082639,0.97921,1.0607,1.0064,0.92488,0.43583,0.87054,0.89771,1.1694,1.0879,0.54451,0.32716,0.29999,0.59885,0.16415,-0.18905:2
-0.63729,-0.94375,-1.3338,-1.5845,-1.3895,-1.4174,-1.5009,-0.86017,0.36566,1.0622,1.3408,1.3686,1.0343,0.83928,0.7557,1.0343,1.1457,0.69998,0.36566,0.17064,-0.13582,-0.38656,0.003483,0.003483:2
-0.91191,-1.2327,-1.5041,-1.5534,-1.6521,-1.4547,-1.134,-0.41843,0.5932,0.91396,1.136,0.96331,0.83994,0.34646,0.22309,0.22309,0.46983,1.1607,1.3334,1.1854,0.56853,0.34646,-0.072994,-0.36908:1
-0.85092,-1.2252,-1.3321,-1.733,-1.5994,-1.4657,-1.2519,-0.55689,0.61926,1.2875,1.3944,1.2341,0.99349,0.80637,0.85983,0.67272,0.64599,0.51234,0.32522,0.27176,0.16484,0.40541,-0.022275,-0.15593:2
0.45466,-0.067715,-0.8803,-1.1125,-1.2866,-1.1705,-0.82225,-1.1125,-0.067715,0.28053,0.57074,0.57074,0.62878,-0.067715,-0.29988,-0.35792,-0.64813,-0.76421,-0.41596,-0.24184,0.80291,2.312,2.312,1.3833:2
2.0208,-0.17043,-0.6817,-1.0469,-1.266,-1.193,-0.90082,-1.4121,0.34085,1.3634,1.7286,1.6556,1.2173,0.77909,-0.24347,-0.3165,-0.024347,-0.097386,-0.097386,-0.24347,-0.97386,-0.60866,0.34085,-0.17043:2
-0.796,-0.94206,-1.1757,-1.4386,-1.4094,-1.4679,-1.5847,-0.82521,0.46008,1.1904,1.278,1.3364,1.1319,0.81061,0.83982,0.95666,0.98588,0.86903,0.34323,0.021908,-0.35784,-0.32863,0.051119,0.051119:2
-0.93839,-1.1355,-1.6283,-1.6037,-1.6776,-1.4558,-1.1109,-0.44558,0.73716,1.23,1.23,1.0575,0.86036,0.44147,0.5154,0.41683,0.5154,0.31827,0.26899,1.3285,0.81108,0.5154,-0.026694,-0.22382:1
0.73518,-0.44111,-1.0012,-1.1133,-1.0573,-1.3933,-1.8975,-0.94523,0.34308,1.3513,1.6874,1.9115,1.7434,0.45511,0.17504,-0.049012,0.11903,0.007002,-0.16104,-0.049012,-0.44111,-0.49712,0.51112,0.007002:2
-0.87163,-1.2423,-1.3483,-1.5601,-1.4542,-1.3218,-1.4277,-0.79219,0.37292,1.1144,1.1673,1.1673,1.1408,0.77012,0.84956,1.0349,1.0084,0.84956,0.47884,0.31996,0.002207,-0.18315,0.055166,-0.13019:2
-0.19643,-0.71542,-1.0182,-1.2777,-1.3642,-1.4507,-1.0614,-0.71542,-0.93167,-0.023427,0.45232,0.66857,0.62532,0.23607,-0.28292,-0.19643,-0.54242,-0.10993,1.4471,1.8363,1.6633,1.6201,0.79832,0.53882:1
-1.0672,-1.3645,-1.5131,-1.5874,-1.5874,-1.5131,-1.0672,-0.42318,0.44382,1.0631,0.93926,0.9888,0.8154,0.39428,0.54291,0.642,0.49337,0.41905,0.91448,1.4347,0.88971,0.44382,-0.15069,-0.15069:1
-1.0329,-1.2618,-1.5593,-1.6738,-1.5822,-1.4678,-1.1473,-0.11731,0.56937,1.05,0.95848,0.86692,0.63803,0.2947,0.31759,0.36336,0.56937,0.66092,1.462,1.1416,0.84404,0.47781,0.020028,-0.39198:1
0.70788,-0.64225,-0.75476,-0.75476,-0.97978,-1.4298,-1.0923,-1.8799,-0.1922,1.3829,1.833,1.9455,1.1579,0.37035,-0.1922,-0.30471,0.70788,0.25784,-0.30471,-0.64225,-0.41722,-0.1922,1.0454,0.37035:2
-0.43483,-0.9751,-1.4585,-1.4869,-1.3732,-1.231,-1.6576,-0.8898,0.33293,1.0723,1.3566,1.4419,1.0154,0.70259,0.87321,0.95851,1.0154,0.84477,0.50355,0.16232,-0.12204,-0.23578,-0.12204,-0.29265:2
0.062451,-0.96307,-1.1208,-1.2786,-1.5153,-1.1997,-0.96307,-1.8308,-0.41087,0.53577,1.1669,1.0091,1.6402,0.53577,0.85131,0.69354,0.53577,0.22022,-0.41087,-0.17421,-0.48975,1.0091,0.77243,1.3246:2
-0.97935,-1.4245,-1.558,-1.6916,-1.6471,-1.3577,-1.0906,-0.11129,0.71225,1.0906,1.0684,0.97935,0.75677,0.28935,0.46741,0.37838,0.40064,0.35613,1.3132,1.2019,0.71225,0.37838,-0.044516,-0.20032:1
-0.98463,-1.4533,-1.5273,-1.478,-1.6506,-1.5026,-1.0586,-0.44195,0.54473,1.3587,1.1614,0.98874,0.76674,0.52007,0.3474,0.47073,0.54473,0.19939,0.32273,1.3341,0.89007,0.61873,0.15006,-0.12128:1
-0.41297,-1.1731,-1.2901,-1.524,-1.407,-1.5825,-1.7286,-0.79306,0.37643,1.2535,1.2828,1.2828,0.9027,0.75651,0.87346,0.78575,0.93193,0.6688,0.34719,0.11329,-0.032892,0.37643,0.025582,-0.032892:2
1.2373,0.75707,0.19677,-0.52361,-0.28348,-0.44357,-1.4041,-1.9644,-1.1639,-0.76374,0.11673,0.4369,0.59698,-0.1234,-0.1234,-0.20344,-0.84378,-0.60365,-0.36353,-0.043356,0.27681,0.75707,2.1178,2.3579:2
-1.006,-1.3971,-1.5274,-1.6057,-1.6317,-1.4231,-1.0581,-0.51059,0.58447,1.2102,1.3406,1.3406,1.0538,0.4541,0.63661,0.63661,0.76698,0.50625,0.21945,0.24552,0.11516,0.66268,0.34981,0.036937:2
-0.010692,-0.86605,-1.2937,-1.0371,-1.2937,-1.5076,-1.2082,-0.99436,0.41699,1.1868,1.4007,1.144,0.6736,0.20315,-0.3956,-0.43837,-0.43837,-0.48114,0.11761,1.8283,1.4862,1.144,0.33145,0.032076:2
-0.76311,-1.0625,-1.5523,-1.5251,-1.5251,-1.5795,-1.3346,-0.81754,0.40707,1.0058,1.2507,1.1963,1.0602,0.76084,0.76084,0.89691,1.033,0.57035,0.51592,0.40707,0.18936,0.35264,-0.055561,-0.19163:2
-1.2599,-1.1703,-1.5511,-1.5287,-1.5735,-1.3271,-1.1479,-0.25198,0.86793,1.2263,1.1591,1.0471,0.75594,0.28558,0.30797,0.46476,0.55435,0.50956,1.1815,1.1815,0.55435,0.33037,-0.13999,-0.47596:1
-0.75747,-1.2441,-1.3831,-1.5222,-1.6612,-1.4527,-1.1398,-0.72271,0.35484,1.1891,1.4672,1.3629,1.2238,0.66768,0.63292,0.63292,0.77196,0.45912,0.28532,-0.027518,-0.027518,0.80672,0.28532,-0.20132:2
0.91295,0.59655,0.042846,-0.58996,-0.74816,-0.66906,-1.7765,-1.9347,-0.98546,-0.19446,0.28015,0.67565,0.51745,0.12195,0.12195,-0.58996,-0.51086,-0.51086,-0.27356,0.042846,0.43835,0.51745,2.495,2.0204:2
-0.95217,-1.4082,-1.5349,-1.6362,-1.5602,-1.4082,-1.0535,-0.54681,0.59326,1.176,1.0746,0.74527,0.89727,0.41591,0.61859,0.64393,0.61859,0.36524,0.31457,1.328,1.0239,0.66926,0.010556,-0.3948:1
-0.63902,-1.3784,-1.6408,-1.6408,-1.6408,-1.4977,-1.1876,-0.18584,0.55355,1.1021,1.1498,1.1737,0.88747,0.43429,0.43429,0.43429,0.5297,0.36274,0.72051,1.2691,0.79206,0.33889,-0.18584,-0.18584:1
-0.47668,-1.0047,-1.3127,-1.4447,-1.6207,-1.3127,-1.1367,-0.65269,-0.21267,-0.52068,0.31534,0.75536,0.97537,0.35935,0.051335,-0.12467,-0.25668,0.57935,1.3714,1.4594,1.5474,1.3714,1.0194,0.27134:1
0.27403,-0.15622,-0.83234,-0.95527,-1.0167,-1.2011,-0.83234,-1.3855,-0.77087,0.3355,1.1345,1.0731,1.0731,0.27403,0.089637,-0.46355,-0.64794,-0.77087,-0.77087,-0.094759,0.3355,2.2409,1.8107,1.2575:2
0.45158,-0.48442,-0.97705,-1.6175,-1.716,-1.3219,-1.2234,-0.28737,0.69789,1.5354,1.8309,1.6339,1.1413,0.35305,-0.2381,-0.2381,-0.33663,-0.38589,-0.53368,-0.13958,0.156,1.1905,0.5501,-0.041052:2
-0.32667,-0.81262,-1.2662,-1.6225,-1.6225,-1.5578,-1.1366,-0.16468,0.61284,1.2284,1.4876,1.1636,0.83962,0.22408,-0.16468,-0.29427,-0.13229,-0.067494,1.2932,1.4876,0.90442,0.51565,-0.035097,-0.55345:1
-0.87794,-1.1167,-1.445,-1.4748,-1.6838,-1.3555,-1.1167,-0.7884,0.37555,1.3306,1.5097,1.45,1.0321,0.49493,0.55462,0.73369,0.85307,0.49493,0.13679,0.10694,0.077099,0.82322,0.077099,-0.1915:2
-0.90556,-1.2818,-1.5133,-1.6001,-1.6869,-1.5133,-0.99238,-0.76087,0.19414,1.1781,1.236,1.207,0.88868,0.30989,0.94656,0.91762,0.8308,0.54141,0.39671,0.19414,0.30989,0.77292,0.28095,0.049438:2
-0.048721,-1.1815,-1.5469,-1.5834,-1.7296,-1.4373,-0.96225,0.46285,0.71864,1.084,1.3033,1.1937,0.6821,0.024361,-0.19489,-0.30451,-0.30451,-0.085262,0.53593,1.5956,1.1571,0.75518,0.28015,-0.41413:1
0.23076,-0.34883,-0.73522,-1.3148,-1.508,-0.92842,-1.186,-1.186,-0.091232,1.7119,1.7763,1.8407,1.3899,0.23076,-0.026833,-0.41323,-0.47763,-0.60643,-0.54203,-0.28443,0.35956,1.1968,0.55276,0.35956:2
-0.46179,-0.87119,-1.2806,-1.3683,-1.4561,-1.1929,-1.4853,-0.63725,0.62019,1.1758,1.4975,1.2635,1.0588,0.94186,0.82489,0.64944,1.0881,0.70792,0.47398,-1.2806,-0.14012,-0.25709,0.064578,0.064578:2
-1.0978,-1.4147,-1.5732,-1.5732,-1.5336,-1.4345,-1.0978,-0.067681,0.70487,1.0614,1.0812,0.96239,0.78411,0.5464,0.40774,0.42755,0.46716,0.40774,1.1209,1.2199,0.80392,0.38793,-0.028063,-0.56291:1
-0.48817,-0.94291,-1.3709,-1.5046,-1.5314,-1.5046,-1.4511,-0.62192,0.44805,1.2505,1.4645,1.4913,1.2505,0.76904,0.90279,0.76904,0.68879,0.44805,0.3678,0.046811,-0.14043,-0.27418,0.07356,-0.14043:2
-0.90044,-1.2615,-1.4282,-1.6226,-1.5949,-1.5393,-1.6226,0.15509,0.65507,1.0162,1.2662,1.0439,0.90506,0.59952,0.82173,0.87729,0.82173,0.51619,0.34953,0.3773,0.071757,0.51619,0.21064,-0.23379:2
-0.67695,-1.0953,-1.4788,-1.688,-1.688,-1.5486,-0.99073,-0.46776,0.26439,0.61303,1.0314,1.0314,0.78735,0.33412,0.055202,0.055202,0.12493,1.1011,1.4149,1.38,0.96168,0.61303,0.1598,-0.29344:1
-1.0932,-1.0672,-1.5358,-1.5358,-1.5878,-1.4837,-1.2494,-0.7028,0.39045,1.0412,0.98913,0.98913,0.85898,0.46854,0.46854,0.52059,0.57265,0.46854,0.98913,1.3535,0.93707,0.49456,-0.078089,-0.20824:1
-0.34211,-0.85958,-1.2046,-1.4805,-1.722,-1.4805,-1.2391,-0.92857,-0.27311,-0.13512,0.69284,0.83083,0.72733,0.34786,-0.13512,-0.066121,-0.066121,0.83083,1.3138,1.6243,1.4173,1.1413,0.76183,0.24436:1
-0.61659,-1.1681,-1.4744,-1.5664,-1.5664,-1.5357,-1.2906,-0.67786,0.39446,1.4668,1.4055,1.3136,1.1298,0.48638,0.63956,0.63956,0.79275,0.45574,0.11872,0.057446,0.27191,0.57829,0.27191,-0.12638:2
-0.26682,-1.1113,-1.3576,-1.3224,-1.5335,-1.5335,-1.3224,-0.26682,0.22578,1.1054,1.211,0.96468,0.75356,0.12022,-0.23164,-0.30201,-0.12608,0.36652,1.5276,1.598,1.2813,0.57763,0.049846,-0.40757:1
0.43102,-0.51848,-1.1182,-1.2181,-1.368,-1.6679,-1.8178,-1.0182,0.481,1.4805,1.5804,1.6304,1.1806,0.33108,0.13118,-0.11869,-0.21864,-0.31858,-0.11869,0.13118,0.53097,0.68089,0.88079,0.031234:2
-0.61222,-1.0499,-1.3625,-1.425,-1.2375,-1.5501,-1.3,-0.67474,0.32565,1.1697,1.2948,1.2322,0.95089,0.38817,-0.20581,-0.08076,0.23186,0.63827,1.3573,1.5136,0.82584,0.29438,-0.08076,-0.64348:1
-1.2627,-1.4498,-1.5199,-1.6602,-1.707,-1.403,-1.099,-0.16368,0.65474,1.0523,1.0523,1.0289,0.91195,0.65474,0.7015,0.7015,0.74827,0.49105,0.30398,0.44429,0.5612,0.81842,0.2806,-0.1403:2
0.71432,0.62903,0.11728,-0.30918,-0.30918,-0.30918,0.031985,-1.6739,-1.5886,-0.22389,-0.1386,0.28786,-0.1386,-0.47977,-0.47977,-0.56506,-0.56506,-0.82094,-0.47977,-0.30918,0.11728,2.4202,2.1643,1.9084:2
-0.58214,-1.1312,-1.4973,-1.6803,-1.6803,-1.4668,-1.1923,-0.70417,0.57706,1.3702,1.4617,1.2482,1.0346,0.51605,0.60757,0.66858,0.63807,0.51605,0.27201,0.18049,-0.094058,0.72959,0.211,-0.002542:2
