#!/usr/bin/env python3 -u
# -*- coding: utf-8 -*-

__author__ = ["Markus Löning"]
__all__ = [
    "ShapeletTransformClassifier",
    "MrSEQLClassifier",
    "ROCKETClassifier",
    "BOSSEnsemble",
    "IndividualBOSS",
    "TemporalDictionaryEnsemble",
    "IndividualTDE",
    "KNeighborsTimeSeriesClassifier",
    "ProximityStump",
    "ProximityTree",
    "ProximityForest",
    "ElasticEnsemble",
    "TimeSeriesForestClassifier",
    "RandomIntervalSpectralForest",
    "SupervisedTimeSeriesForest",
    "ComposableTimeSeriesForestClassifier",
    "ColumnEnsembleClassifier",
    "pd",
    "np",
    "load_gunpoint",
    "load_osuleaf",
    "load_basic_motions",
    "load_arrow_head",
]

import numpy as np
import pandas as pd

from sktime.classification.compose import ColumnEnsembleClassifier
from sktime.classification.compose import ComposableTimeSeriesForestClassifier
from sktime.classification.dictionary_based import BOSSEnsemble
from sktime.classification.dictionary_based import IndividualBOSS
from sktime.classification.dictionary_based import IndividualTDE
from sktime.classification.dictionary_based import TemporalDictionaryEnsemble
from sktime.classification.distance_based import ElasticEnsemble
from sktime.classification.distance_based import KNeighborsTimeSeriesClassifier
from sktime.classification.distance_based import ProximityForest
from sktime.classification.distance_based import ProximityStump
from sktime.classification.distance_based import ProximityTree
from sktime.classification.interval_based import RandomIntervalSpectralForest
from sktime.classification.interval_based import SupervisedTimeSeriesForest
from sktime.classification.interval_based import TimeSeriesForestClassifier
from sktime.classification.shapelet_based import MrSEQLClassifier
from sktime.classification.shapelet_based import ROCKETClassifier
from sktime.classification.shapelet_based import ShapeletTransformClassifier
from sktime.datasets import load_arrow_head
from sktime.datasets import load_basic_motions
from sktime.datasets import load_gunpoint
from sktime.datasets import load_osuleaf
