# -*- coding: utf-8 -*-
import numpy as np
from numpy import testing

from sktime.datasets import load_gunpoint, load_basic_motions
from sktime.transformations.panel.catch22_features import Catch22


def test_catch22_on_gunpoint():
    # load gunpoint data
    X_train, y_train = load_gunpoint(split="train", return_X_y=True)
    indices = np.random.RandomState(0).permutation(10)

    # fit catch22
    c22 = Catch22()
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    data = c22.transform(X_train.iloc[indices])
    testing.assert_array_almost_equal(data, catch22_gunpoint_data)


def test_catch22_single_feature_on_gunpoint():
    # load gunpoint data
    X_train, y_train = load_gunpoint(split="train", return_X_y=True)
    indices = np.random.RandomState(0).permutation(10)

    # fit catch22
    c22 = Catch22()
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    data = c22._transform_single_feature(X_train.iloc[indices], 5)
    testing.assert_array_almost_equal(data, catch22_single_feature_gunpoint_data)


def test_catch22_on_basic_motions():
    # load basic motions data
    X_train, y_train = load_basic_motions(split="train", return_X_y=True)
    indices = np.random.RandomState(0).permutation(20)

    # fit catch22
    c22 = Catch22()
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    data = c22.transform(X_train.iloc[indices])
    testing.assert_array_almost_equal(data, catch22_basic_motions_data)


catch22_gunpoint_data = np.array(
    [
        [
            -0.5340330171106944,
            -0.658351857866975,
            21.0,
            53.0,
            0.7720925140620329,
            0.0004932601084433473,
            0.2214765100671141,
            50.0,
            0.0625,
            0.0,
            3.0033314093202925,
            28.0,
            1.0333333333333334,
            0.026666666666666616,
            -0.36,
            0.9891401710865735,
            34.0,
            1.253207549083096,
            0.775,
            0.85,
            0.04908738521234375,
            0.14079296494853252,
        ],
        [
            -0.00894664595908945,
            -1.0044815672237117,
            21.0,
            71.0,
            0.8515090675700044,
            0.0003505432572203997,
            0.2080536912751678,
            77.0,
            0.0625,
            47.0,
            3.527077303594841,
            32.0,
            0.6,
            -0.18666666666666665,
            0.5466666666666666,
            0.9856022754481102,
            26.0,
            1.381261770791717,
            0.15,
            0.675,
            0.04908738521234375,
            0.1345325698179698,
        ],
        [
            -0.4547738376403847,
            -0.5941172270686479,
            18.0,
            48.0,
            0.703249120873723,
            -0.00020938392521213623,
            0.21476510067114093,
            43.0,
            0.04000000000000001,
            0.0,
            3.221127401307258,
            24.0,
            0.5769230769230769,
            -0.06000000000000005,
            0.30000000000000004,
            0.9897885527534604,
            19.0,
            1.3231592758318385,
            0.2,
            0.85,
            0.04908738521234375,
            0.16124732024516114,
        ],
        [
            0.9494192545671505,
            1.0759094066125596,
            23.0,
            64.0,
            1.0589638481847423,
            8.572881147100564e-05,
            0.30201342281879195,
            71.0,
            0.0625,
            43.0,
            5.044058865830558,
            30.0,
            1.3333333333333333,
            -0.013333333333333308,
            0.4866666666666666,
            0.9830286975664765,
            35.0,
            1.2298893149751353,
            0.15,
            0.775,
            0.04908738521234375,
            0.1118327947128468,
        ],
        [
            -0.54026014618243,
            -0.6772300852134479,
            19.0,
            50.0,
            0.7535346860231789,
            -6.245951390381267e-05,
            0.2483221476510067,
            46.0,
            0.08000000000000002,
            0.0,
            3.736263979517296,
            25.0,
            0.7037037037037037,
            0.026666666666666616,
            -0.30666666666666664,
            0.9901758435566883,
            26.0,
            1.2961894780701835,
            0.775,
            0.825,
            0.04908738521234375,
            0.1431723825968347,
        ],
        [
            0.6714511354218677,
            0.7845206941507827,
            19.0,
            83.0,
            0.8168335974002958,
            0.0002665063189533517,
            0.174496644295302,
            89.0,
            0.04000000000000001,
            0.0,
            3.3890347668240883,
            25.0,
            0.9285714285714286,
            -0.020000000000000018,
            0.6333333333333333,
            0.9822094759537441,
            29.0,
            1.3507562409071998,
            0.15,
            0.7,
            0.04908738521234375,
            0.14023861551763106,
        ],
        [
            0.3323838258861809,
            0.4631720511774404,
            19.0,
            109.0,
            0.6543521253348026,
            0.0005655047147386403,
            0.16778523489932887,
            113.0,
            0.0625,
            0.0,
            3.037789486406497,
            30.0,
            0.4,
            0.18666666666666676,
            -0.7966666666666666,
            0.9748351289520993,
            14.0,
            1.4349924834415813,
            0.5,
            0.8,
            0.04908738521234375,
            0.14500151152584909,
        ],
        [
            -0.5347487132193061,
            -0.663529447594619,
            21.0,
            53.0,
            0.7919401876906285,
            0.00019436502754734738,
            0.24161073825503357,
            49.0,
            0.04000000000000001,
            0.0,
            3.9201920351475232,
            27.0,
            0.9655172413793104,
            -0.020000000000000018,
            0.33333333333333326,
            0.9894609697527139,
            33.0,
            1.2961894780701835,
            0.75,
            0.85,
            0.04908738521234375,
            0.13529921345099227,
        ],
        [
            -0.519633873986727,
            -0.6510470680387028,
            19.0,
            48.0,
            0.7484418959395501,
            -2.7381187024883296e-05,
            0.2214765100671141,
            47.0,
            0.04000000000000001,
            0.0,
            2.704902330675294,
            26.0,
            0.6428571428571429,
            0.10000000000000009,
            -0.32666666666666666,
            0.9899746184444618,
            29.0,
            1.315707261251053,
            0.15,
            0.85,
            0.04908738521234375,
            0.1473111356387668,
        ],
        [
            -0.551161112157522,
            -0.6888256451667512,
            20.0,
            50.0,
            0.7782319338279382,
            0.00031279571104342053,
            0.2751677852348993,
            49.0,
            0.04000000000000001,
            0.0,
            3.332550034216023,
            26.0,
            0.75,
            -0.053333333333333344,
            0.3533333333333333,
            0.9901900994514602,
            30.0,
            1.2532075490830958,
            0.75,
            0.85,
            0.04908738521234375,
            0.141480705380219,
        ],
    ]
)
catch22_single_feature_gunpoint_data = np.array(
    [
        0.0004932601084433473,
        0.0003505432572203997,
        -0.00020938392521213623,
        8.572881147100564e-05,
        -6.245951390381267e-05,
        0.0002665063189533517,
        0.0005655047147386403,
        0.00019436502754734738,
        -2.7381187024883296e-05,
        0.00031279571104342053,
    ]
)
catch22_basic_motions_data = np.array(
    [
        [
            0.06591964953810026,
            -0.21462620051963066,
            2.0,
            5.0,
            0.1505764057623523,
            0.14242903239181234,
            0.8514190317195326,
            12.0,
            0.003049928598859819,
            7.0,
            0.12793210770352378,
            1.0,
            1.0,
            -0.7050000000000001,
            -0.5533333333333333,
            0.17535515554684786,
            6.0,
            1.9640548467883936,
            0.7659574468085106,
            0.5957446808510638,
            0.7547185476397852,
            1.1841655126718886,
        ],
        [
            1.061005470256501,
            0.2940879824319307,
            2.0,
            6.0,
            0.04343773242417084,
            -1.9686731858266826,
            0.6260434056761269,
            79.0,
            0.012386829422098103,
            10.0,
            0.05567346784241904,
            3.0,
            0.25,
            -0.5016666666666667,
            -0.31833333333333336,
            0.6033586390812942,
            7.0,
            1.8585070669833879,
            0.1702127659574468,
            0.8723404255319149,
            0.5706408530934961,
            0.9877872419957893,
        ],
        [
            -0.11685411623918296,
            0.14434110517451404,
            2.0,
            4.0,
            0.13851203478254714,
            0.18061880979588493,
            0.8664440734557596,
            8.0,
            0.006043618427144095,
            8.0,
            0.12038754496702966,
            1.0,
            0.6666666666666666,
            -0.7541666666666667,
            -0.4866666666666667,
            0.20432410756725258,
            7.0,
            2.000483151241299,
            0.7872340425531915,
            0.6170212765957447,
            0.7363107781851562,
            1.1435121850336494,
        ],
        [
            0.7627516455778833,
            0.16999547333247822,
            2.0,
            4.0,
            0.08571444372531561,
            0.19824345765159615,
            0.8414023372287145,
            19.0,
            0.008644562847739535,
            8.0,
            0.13248529382136215,
            2.0,
            0.6666666666666666,
            -0.355,
            -0.3666666666666667,
            0.38897089672964813,
            7.0,
            1.989698618575541,
            0.7872340425531915,
            0.6170212765957447,
            0.6872233929728125,
            1.0873940100323065,
        ],
        [
            -0.07945976194260629,
            0.2134429001681899,
            2.0,
            4.0,
            0.18781364014565627,
            0.3864790246292787,
            0.8597662771285476,
            17.0,
            0.007828085149364915,
            8.0,
            0.09829996449241808,
            1.0,
            0.6666666666666666,
            -0.76,
            -0.5441666666666667,
            0.17872288886947596,
            6.0,
            1.964782809914885,
            0.7659574468085106,
            0.6170212765957447,
            0.7424467013366992,
            1.1699603896398054,
        ],
        [
            0.1616146602716324,
            -0.10909796331381583,
            2.0,
            5.0,
            0.18792684240150198,
            -0.08457778818789,
            0.8363939899833055,
            9.0,
            0.013509759854549129,
            8.0,
            0.1261738288695148,
            1.0,
            0.6666666666666666,
            -0.77,
            -0.5133333333333333,
            0.22724401794888405,
            6.0,
            1.9445651190336637,
            0.7872340425531915,
            0.6170212765957447,
            0.6994952392758984,
            1.134562764711733,
        ],
        [
            0.026269761812791836,
            -0.4303940612241195,
            2.0,
            5.0,
            0.12373665588675277,
            0.11829372379761185,
            0.7011686143572621,
            8.0,
            0.013476090671110998,
            9.0,
            0.12478282251060296,
            2.0,
            1.0,
            -0.5316666666666667,
            -0.5349999999999999,
            0.6042939319008099,
            6.0,
            1.8981774099370983,
            0.1276595744680851,
            0.3617021276595745,
            0.6135923151542969,
            1.065926906744231,
        ],
        [
            0.06304721862351492,
            -0.19175338525095387,
            2.0,
            4.0,
            0.1650466044407779,
            0.16559211507818403,
            0.8146911519198664,
            11.0,
            0.0052860617997862016,
            8.0,
            0.14088242470272264,
            2.0,
            0.6666666666666666,
            -0.7666666666666666,
            -0.4966666666666667,
            0.2653102501533685,
            6.0,
            1.9648784007602305,
            0.7659574468085106,
            0.6382978723404256,
            0.6810874698212696,
            1.0910127043407216,
        ],
        [
            -0.3100122704406385,
            0.06887942846688544,
            3.0,
            5.0,
            0.08656104594610549,
            0.3218621468915023,
            0.8130217028380634,
            26.0,
            0.01283725958290167,
            10.0,
            0.1060152839097286,
            2.0,
            0.75,
            -0.5016666666666667,
            -0.6958333333333333,
            0.7670163610815328,
            7.0,
            1.869633585242291,
            0.7872340425531915,
            0.6170212765957447,
            0.5706408530934961,
            0.9555376395147974,
        ],
        [
            -0.06533273777775017,
            0.29727009851931996,
            3.0,
            6.0,
            0.11139081561981025,
            -0.015163336936776226,
            0.8080133555926544,
            25.0,
            0.0008080604025150883,
            11.0,
            0.1654559675699543,
            2.0,
            1.0,
            -0.44666666666666666,
            -0.47,
            0.8127492326880129,
            8.0,
            1.9270623879585551,
            0.1276595744680851,
            0.6595744680851063,
            0.5338253141842383,
            0.9940984571382343,
        ],
        [
            0.5166401316600928,
            -0.09279665258824288,
            2.0,
            4.0,
            0.026815532285574675,
            0.09063233770342598,
            0.8430717863105175,
            27.0,
            0.009216938966187724,
            9.0,
            0.10336376717850575,
            2.0,
            0.6666666666666666,
            -0.41000000000000003,
            -0.6283333333333334,
            0.44965340071059845,
            6.0,
            1.9592576936772685,
            0.7872340425531915,
            0.6382978723404256,
            0.6749515466697266,
            1.0689744865330575,
        ],
        [
            0.09570262993588785,
            -0.16926704042883856,
            2.0,
            5.0,
            0.1927380987205485,
            0.18613706654280124,
            0.8397328881469115,
            9.0,
            0.008358374788515442,
            8.0,
            0.16652373676822935,
            2.0,
            0.6666666666666666,
            -0.755,
            -0.5,
            0.26470410831603924,
            6.0,
            1.963981448917039,
            0.7659574468085106,
            0.5957446808510638,
            0.6810874698212696,
            1.0944355312476486,
        ],
        [
            -0.9599686122498592,
            -0.38384661705860657,
            2.0,
            5.0,
            0.05018030946352631,
            -1.1562470865335865,
            0.8130217028380634,
            16.0,
            0.006371892965665852,
            10.0,
            0.06419466185468523,
            2.0,
            0.3333333333333333,
            -0.5616666666666666,
            -0.5433333333333333,
            0.5901080942105891,
            6.0,
            1.976512561304251,
            0.1276595744680851,
            0.8297872340425532,
            0.6013204688512109,
            1.0327364233499525,
        ],
        [
            0.2472820807864209,
            -0.10785274637480624,
            2.0,
            5.0,
            0.09625610634603701,
            0.22188836383279495,
            0.8080133555926544,
            9.0,
            0.0019275607518328657,
            9.0,
            0.19950649513477675,
            2.0,
            1.0,
            -0.5066666666666666,
            -0.43166666666666664,
            0.4863489949399831,
            7.0,
            1.9556657265785629,
            0.7872340425531915,
            0.5957446808510638,
            0.6258641614573828,
            1.0834863782144666,
        ],
        [
            0.16958388453715778,
            -0.1184655489240225,
            2.0,
            4.0,
            0.14059710925305002,
            -0.08996446419599496,
            0.8414023372287145,
            9.0,
            0.004680016497899883,
            7.0,
            0.13882714239612165,
            1.0,
            0.6666666666666666,
            -0.79,
            -0.5316666666666667,
            0.23117621098469293,
            6.0,
            1.998677525518119,
            0.7872340425531915,
            0.6170212765957447,
            0.7608544707913282,
            1.1371316259185282,
        ],
        [
            0.10081726283053727,
            -0.1685323485045085,
            2.0,
            5.0,
            0.17851570583293266,
            -0.07176236603682672,
            0.8163606010016694,
            10.0,
            0.006270885415351464,
            8.0,
            0.1513815556045357,
            1.0,
            0.6666666666666666,
            -0.74,
            -0.5133333333333333,
            0.20174479685116342,
            6.0,
            1.9358304058211273,
            0.7872340425531915,
            0.5957446808510638,
            0.6994952392758984,
            1.1327986698989456,
        ],
        [
            0.27412473785920954,
            -0.13016756454998757,
            2.0,
            5.0,
            0.062410969535769634,
            -0.10378780202313864,
            0.8414023372287145,
            17.0,
            0.005235558024629007,
            8.0,
            0.1585307659944085,
            2.0,
            0.6666666666666666,
            -0.3666666666666667,
            -0.3516666666666667,
            0.4869809850088446,
            7.0,
            2.009501537228972,
            0.1276595744680851,
            0.6382978723404256,
            0.6258641614573828,
            1.0380271502138443,
        ],
        [
            -0.4178869317804703,
            0.18746047722325265,
            2.0,
            5.0,
            0.1055506691963855,
            -0.6497496658335763,
            0.7946577629382304,
            9.0,
            0.002255835290354621,
            9.0,
            0.08438839827444163,
            2.0,
            0.6666666666666666,
            -0.5766666666666667,
            -0.42166666666666663,
            0.4792555281388093,
            7.0,
            1.952421718840799,
            0.1276595744680851,
            0.6595744680851063,
            0.6320000846089258,
            1.0951487891373046,
        ],
        [
            0.06798558960208179,
            -0.2074007591976752,
            2.0,
            4.0,
            0.17008464141656726,
            -0.01669953352456864,
            0.7979966611018364,
            8.0,
            0.005277644503926668,
            7.0,
            0.15018702778288454,
            1.0,
            0.6666666666666666,
            -0.7508333333333334,
            -0.5291666666666667,
            0.18464094910249573,
            7.0,
            1.9909316131550137,
            0.7872340425531915,
            0.6382978723404256,
            0.7485826244882422,
            1.1519272633406181,
        ],
        [
            0.12031034573768173,
            -0.16007912672496571,
            2.0,
            4.0,
            0.1537612002423231,
            -0.027069557039515912,
            0.8213689482470785,
            9.0,
            0.007482976019124097,
            7.0,
            0.1176079373503508,
            1.0,
            0.6666666666666666,
            -0.7525,
            -0.5633333333333334,
            0.16930780899913936,
            6.0,
            1.9819924040629482,
            0.7872340425531915,
            0.6382978723404256,
            0.7547185476397852,
            1.1793481396704777,
        ],
    ]
)


# def print_array(array):
#     print('[')
#     for sub_array in array:
#         print('[')
#         for value in sub_array:
#             print(value.astype(str), end='')
#             print(', ')
#         print('],')
#     print(']')
#
# if __name__ == "__main__":
#     X_train, y_train = load_gunpoint(split="train", return_X_y=True)
#     indices = np.random.RandomState(0).permutation(10)
#
#     c22_u = Catch22()
#
#     c22_u.fit(X_train.iloc[indices], y_train[indices])
#     data = c22_u.transform(X_train.iloc[indices])
#     print_array(data.to_numpy())
#
#     c22_s = Catch22()
#
#     data = c22_s._transform_single_feature(X_train.iloc[indices], 5)
#     print(data.tolist())
#
#     X_train, y_train = load_basic_motions(split="train", return_X_y=True)
#     indices = np.random.RandomState(0).permutation(20)
#
#     c22_m = Catch22()
#
#     c22_m.fit(X_train.iloc[indices], y_train[indices])
#     data = c22_m.transform(X_train.iloc[indices])
#     print_array(data.to_numpy())
