## PLAID dataset
#
#PLAID stands for the Plug Load Appliance Identification Dataset. The data are intended for load identification research. The first version of PLAID is named PLAID1, collected in summer 2013. A second version of PLAID was collected in winter 2014 and released under the name PLAID2.
#
#This dataset comes from PLAID1. It includes current and voltage measurements sampled at 30 kHz from 11 different appliance types present in more than 56 households in Pittsburgh, Pennsylvania, USA. Data collection took place during the summer of 2013. Each appliance type is represented by dozens of different instances of varying makes/models. 
#
#For each appliance, three to six measurements were collected for each state transition. These measurements were then post-processed to extract a few-second-long window containing both the steady-state operation and the startup transient )when available). 
#
#The classes correspond to 11 different appliance types: air conditioner, compact flourescent lamp, fridge, hairdryer, laptop, microwave, washing machine, bulb, vacuum, fan, heater.
#
#Train size: 537
#
#Test size: 537
#
#Missing value: No
#
#Number of classses: 11
#
#Time series length: Vary
#
#We pad NaN to the end of each time series to the length of the longest time series.
#
#Data created by Gao, Jingkun, et al. (see [1], [2], [3]). Data edited by Patrick Schafer and Ulf Leser (see [4]).
#
#[1] Gao, Jingkun, et al. "PLAID: a public dataset of high-resoultion electrical appliance measurements for load identification research: demo abstract." proceedings of the 1st ACM Conference on Embedded Systems for Energy-Efficient Buildings. ACM, 2014.
#
#[2] https://github.com/jingkungao/PLAID
#
#[3] http://www.plaidplug.com/
#
#[4] Schäfer, Patrick, and Ulf Leser. "Fast and accurate time series classification with weasel." Proceedings of the 2017 ACM on Conference on Information and Knowledge Management. ACM, 2017.
@problemName Plaid
@timeStamps false

@classLabel true 0 1 2 3 4 5 6 7 8 9 10
@univariate true
@data
0.17339,0.13045,0.13499,0.080702,0.13673,0.11869,0.10545,0.11936,0.074401,0.11462,0.11494,0.11003,0.11031,0.073908,0.12331,0.11714,0.11564,0.11208,0.07297,0.12724,0.11182,0.12298,0.10545,0.076514,0.12649,0.11488,0.11875,0.10761,0.073571,0.123,0.1166,0.1186,0.10337,0.075284,0.12459,0.10845,0.12064,0.10223,0.078385,0.12357,0.11688,0.11936,0.10376,0.075705,0.11341,0.1198,0.12347,0.10422,0.077758,0.12206,0.11228,0.12266,0.1053,0.069973,0.12593,0.11098,0.12085,0.10544,0.075105,0.1206,0.11267,0.1283,0.10452,0.078836,0.12547,0.11358,0.12639,0.10665,0.074052,0.12154,0.11132,0.12795,0.10334,0.073581,0.11587,0.11298,0.12447,0.10097,2.2074,16.781,19.269,21.898,20.075,16.916,15.818,19.446,21.81,20.224,16.804,15.858,19.241,21.713,20.243,16.678,15.806,19.07,21.606,20.314,16.705,15.886,19.08,21.653,20.376,16.637,15.774,18.896,21.613,20.473,16.738,15.811,18.853,21.508,20.422,16.743,15.756,18.774,21.422,20.385,16.73,15.69,18.66,21.288,20.396,16.699,15.533,18.524,21.29,20.414,16.64,15.534,18.523,21.159,20.302,16.636,15.461,18.324,21.01,20.337,16.586,15.381,18.297,20.886,20.208,16.546,15.231,18.083,20.78,20.164,16.527,15.208,17.962,20.665,20.104,16.464,15.125,17.857,20.608,20.086,16.447,15.062,17.752,20.485,20.038,16.39,15.025,17.652,20.376,19.945,16.359,14.971,17.516,20.282,19.825,16.353,14.82,17.416,20.125,19.801,16.278,14.792,17.286,19.928,19.667,16.182,14.635,17.155,19.784,19.585,16.142,14.54,17.013,19.58,19.45,16.032,14.424,16.852,19.436,19.371,15.946,14.344,16.71,19.241,19.225,15.858,14.235,16.556,19.143,19.148,15.769,14.144,16.374,18.93,18.993,15.664,14.04,16.208,18.836,18.852,15.637,13.931,16.086,18.656,18.725,15.467,13.842,15.867,18.505,18.543,15.459,13.658,15.786,18.292,18.496,15.297,13.582,15.581,18.133,18.298,15.251,13.502,15.424,17.962,18.139,15.24,13.308,15.333,17.768,18.118,15.106,13.204,15.22,17.546,18.006,14.93,13.127,15.04,17.412,17.94,14.886,13.157,14.951,17.268,17.764,14.73,12.993,14.725,17.147,17.681,14.716,12.956,14.636,16.977,17.549,14.627,12.799,14.531,16.869,17.465,14.636,12.671,14.413,16.729,17.296,14.663,12.549,14.25,16.686,17.159,14.663,12.572,14.05,16.6,17.09,14.529,12.604,13.936,16.441,17.085,14.356,12.517,13.953,16.189,17.046,14.378,12.294,13.906,16.21,16.896,14.509,12.333,13.682,16.197,16.821,14.302,12.444,13.603,16.003,16.903,14.258,12.259,13.671,15.914,16.713,14.427,12.188,13.409,15.974,16.634,14.289,12.354,13.399,15.731,16.746,14.292,12.106,13.442,15.752,16.548,14.431,12.209,13.201,15.724,16.666,14.256,12.202,13.305,15.514,16.608,14.438,12.055,13.179,15.672,16.554,14.387,12.264,13.106,15.486,16.674,14.358,12.041,13.171,15.499,16.453,14.492,12.177,12.957,15.497,16.639,14.369,12.172,13.128,15.345,16.482,14.55,12.091,12.895,15.464,16.506,14.407,12.253,12.979,15.181,16.516,14.605,12.058,12.897,15.386,16.449,14.542,12.278,12.824,15.117,16.576,14.605,12.05,12.897,15.231,16.405,14.657,12.258,12.678,15.093,16.602,14.583,12.114,12.872,15.118,16.415,14.76,12.224,12.604,15.106,16.511,14.581,12.187,12.791,15.033,16.417,14.867,12.216,12.573,15.086,16.422,14.687,12.298,12.695,14.893,16.43,14.935,12.184,12.548,15.019,16.379,14.802,12.347,12.59,14.789,16.481,14.963,12.166,12.549,14.897,16.334,14.864,12.374,12.473,14.753,16.567,14.994,12.235,12.561,14.842,16.298,14.962,12.39,12.363,14.743,16.499,14.969,12.284,12.52,14.72,16.22,15.1,12.433,12.304,14.709,16.414,15.023,12.371,12.46,14.616,16.202,15.247,12.45,12.254,14.701,16.373,15.11,12.421,12.421,14.519,16.22,15.355,12.433,12.224,14.632,16.315,15.135,12.464,12.379,14.402,16.291,15.422,12.439,12.239,14.56,16.295,15.171,12.58,0.0:0
0.0024414,-0.0031276,8.6429E-4,9.5645E-4,-0.003404,0.0034471,-0.0035008,8.4585E-4,3.1774E-4,-0.0028826,0.0037124,-0.0036701,0.0014735,0.0014733,-0.0029373,0.0032522,-0.0031091,0.0022146,8.1547E-4,-0.0036211,0.0032257,-0.0038263,6.9604E-4,0.0013765,-0.0028715,0.0031388,0.015334,0.17682,0.078038,0.041812,0.02523,0.028949,0.029653,0.033597,0.021938,0.023142,0.020251,0.023754,0.023316,0.015191,0.020429,0.015071,0.021929,0.023678,0.0149,0.020691,0.016071,0.023751,0.023742,0.013557,0.020399,0.015319,0.023592,0.023393,0.013285,0.021111,0.015425,0.022285,0.022619,0.013209,0.020236,0.015883,0.021636,0.022172,0.012302,0.020333,0.015338,0.02209,0.023173,0.013166,0.01911,0.016825,0.02164,0.022004,0.012922,0.018958,0.015331,0.021872,0.021545,0.012272,0.018196,0.015237,0.020931,0.020635,0.012237,0.018662,0.015155,0.021835,0.022065,0.01217,0.019229,0.01467,0.021749,0.020471,0.011659,0.019136,0.01537,0.020665,0.021323,0.011734,0.018508,0.014963,0.020447,0.021103,0.011172,0.018146,0.014373,0.021099,0.021027,0.011974,0.22227,2.4234,2.8085,3.0328,2.5194,2.188,2.3263,2.8344,3.0314,2.5573,2.1656,2.3509,2.8127,3.0113,2.5447,2.1354,2.3682,2.8148,3.0198,2.5611,2.141,2.3744,2.8059,3.0027,2.5412,2.1299,2.3838,2.8236,3.0109,2.5303,2.1165,2.3683,2.8144,3.0024,2.5227,2.1196,2.3766,2.8145,2.9857,2.4956,2.1063,2.3598,2.8104,2.9761,2.4973,2.1199,2.3694,2.802,2.9484,2.4838,2.0973,2.3477,2.8027,2.9459,2.4703,2.0961,2.3591,2.7895,2.9217,2.4553,2.0756,2.3495,2.7876,2.9102,2.4469,2.0667,2.3431,2.7705,2.8834,2.4277,2.0562,2.3435,2.766,2.8802,2.4115,2.0442,2.3361,2.7436,2.8595,2.3876,2.0408,2.3375,2.7436,2.8527,2.3639,2.0335,2.3143,2.726,2.819,2.35,2.0172,2.3123,2.7172,2.8013,2.3205,2.0083,2.2962,2.7055,2.7682,2.3037,1.9926,2.2871,2.6865,2.7452,2.2817,1.9769,2.2779,2.6718,2.7212,2.2626,1.9646,2.2702,2.6561,2.6962,2.2378,1.949,2.26,2.6384,2.6714,2.2175,1.9342,2.2481,2.6239,2.6538,2.2009,1.9227,2.2433,2.604,2.6241,2.1688,1.9086,2.2241,2.5818,2.6031,2.1446,1.8948,2.2112,2.566,2.5652,2.1227,1.8723,2.1918,2.5518,2.5715,2.1157,1.9028,2.223,2.5828,2.5547,2.1124,1.8803,2.2018,2.5597,2.5296,2.088,1.8562,2.1853,2.5212,2.4958,2.0532,1.8526,2.1711,2.5067,2.4635,2.0323,1.8336,2.1519,2.4916,2.4362,2.0214,1.8128,2.1395,2.4643,2.4098,2.0006,1.7923,2.1363,2.4471,2.3897,1.9781,1.7759,2.1156,2.4223,2.364,1.96,1.7688,2.1134,2.4182,2.3403,1.936,1.75,2.0835,2.3992,2.3151,1.924,1.7539,2.0789,2.3959,2.285,1.8979,1.7453,2.0574,2.3801,2.2733,1.8783,1.7481,2.0563,2.3562,2.2552,1.8427,1.7226,2.0548,2.3302,2.2558,1.851,1.7058,2.0698,2.3234,2.2216,1.8491,1.6918,2.0382,2.3267,2.2066,1.8328,1.7124,2.0288,2.3063,2.2029,1.7968,1.6989,2.0426,2.285,2.198,1.8049,1.6724,2.028,2.291,2.1592,1.7991,1.6953,2.0089,2.2977,2.167,1.7633,1.6897,2.0222,2.2721,2.152,1.7789,1.6632,2.0172,2.2936,2.1223,1.7704,1.686,2.0033,2.2831,2.1328,1.746,1.6696,2.0263,2.2641,2.113,1.7706,1.663,2.0157,2.2814,2.1016,1.7429,1.6823,2.0216,2.2514,2.119,1.7465,1.6571,2.0362,2.2637,2.0851,1.7477,1.6997,2.0444,2.2993,2.1518,1.7556,1.705,2.0755,2.292,2.125,1.7799,1.7085,2.0528,2.3294,2.1349,1.7535,1.7261,2.0709,2.2991,2.1224,1.7631,1.6945,2.0646,2.3329,2.1035,1.7548,1.729,2.0669,2.3147,2.1214,1.7571,1.7125,2.1009,2.3425,2.1087,1.7857,1.7435,2.0918,2.3443,2.1264,1.7587,1.7325,2.1242,2.3287,2.1084,1.782,1.7263,2.0952,2.3339,2.1035,1.7463,1.74,2.1147,2.3074,2.1102,1.7692,1.7239,2.1099,2.3391,2.094,1.746,1.7553,2.1096,2.3206,2.1158,1.7552,1.7315,2.1228,2.3558,2.0868,1.7577,1.773,2.1133,2.3485,2.1118,1.7512,1.7509,2.1451,2.3666,2.0821,1.776,1.7813,2.1345,2.388,2.1303,1.7832,1.799,2.2114,2.4167,2.1327,1.8288,1.8199,2.2007,2.4427,2.1579,1.8018,1.8293,2.2406,2.419,2.1406,1.8286,1.8167,2.2163,2.443,2.1468,1.7986,1.8441,2.2449,2.4154,2.1458,1.8176,0.0:0
-0.0039674,0.0025762,-7.4189E-4,-0.0023574,0.0015846,-0.003167,0.0024938,-7.158E-4,-0.0036252,0.0033626,-0.0047446,0.0039742,-2.8938E-4,-0.0027618,0.0020478,-0.0041361,6.3466E-4,-5.2935E-4,-8.5309E-4,0.0015268,-0.0038932,0.0018833,-0.0015531,-0.0034584,0.0033998,-0.0045981,0.0022451,-0.0010825,0.4168,0.22737,0.086203,0.11073,0.10248,0.072423,0.069025,0.050716,0.071826,0.079558,0.053421,0.048806,0.024846,0.043903,0.039449,0.032713,0.03772,0.022881,0.045048,0.044864,0.035341,0.036797,0.026733,0.041869,0.042593,0.036936,0.037176,0.024447,0.039018,0.040513,0.034592,0.035344,0.025465,0.041994,0.040178,0.03426,0.035191,0.022388,0.038281,0.040707,0.032038,0.03361,0.023981,0.03861,0.042023,0.034515,0.034121,0.024091,0.042057,0.04316,0.032643,0.036378,0.025072,0.040614,0.043006,0.034635,0.035648,0.024051,0.03955,0.042145,0.033008,0.03556,0.023624,0.03768,0.039948,0.031815,0.034031,0.024134,0.040671,0.038367,0.033265,0.033926,0.02263,0.038047,0.038332,0.032171,0.035338,0.022332,0.040908,0.039126,0.035246,0.035735,0.022634,0.039446,0.99871,6.558,5.206,5.4246,4.7941,5.4495,5.5847,4.6389,4.5005,4.9176,7.9122,6.6923,5.5696,5.9107,4.5095,4.7384,4.7412,3.9741,3.4263,3.8169,4.6667,4.7086,3.9438,3.4086,3.7625,4.5185,4.6524,3.8826,3.3569,3.7258,4.455,4.5824,3.8308,3.3033,3.6727,4.4122,4.5482,3.8007,3.281,3.643,4.3818,4.5205,3.771,3.2579,3.619,4.344,4.4873,3.7487,3.2384,3.5967,4.3187,4.4572,3.7224,3.2236,3.5744,4.2925,4.4429,3.7017,3.2057,3.553,4.2677,4.4091,3.6802,3.1953,3.5262,4.2466,4.3877,3.6599,3.1714,3.5062,4.2177,4.3521,3.6411,3.1507,3.4849,4.1853,4.3289,3.6034,3.1126,3.4484,4.1473,4.29,3.5801,3.0987,3.4295,4.1339,4.271,3.5658,3.0936,3.4242,4.123,4.2602,3.5576,3.0876,3.4218,4.1114,4.2499,3.5442,3.0778,3.4041,4.0947,4.2299,3.5269,3.0633,3.3861,4.074,4.2063,3.5136,3.0498,3.3685,4.0594,4.1817,3.4944,3.03,3.3542,4.0362,4.1622,3.48,3.0189,3.3475,4.0192,4.1511,3.4677,3.0084,3.3343,4.0077,4.1332,3.4514,2.9983,3.324,3.9903,4.1189,3.4321,2.989,3.3064,3.978,4.0973,3.4211,2.9763,3.2929,3.9559,4.0773,3.4001,2.961,3.2826,3.9399,4.0553,3.384,2.9466,3.2649,3.9238,4.0378,3.3704,2.9358,3.2536,3.9027,4.0128,3.3499,2.9235,3.2385,3.8864,3.9954,3.3345,2.9032,3.2212,3.8651,3.9733,3.3123,2.8872,3.204,3.8398,3.9537,3.2933,2.8746,3.1853,3.8205,3.9216,3.274,2.8561,3.1623,3.7926,3.8917,3.2447,2.8304,3.1381,3.7619,3.8616,3.2208,2.8056,3.1078,3.7249,3.816,3.1806,2.7738,3.0794,3.6855,3.7809,3.158,2.7485,3.055,3.6463,3.7469,3.1271,2.7278,3.0318,3.6217,3.7207,3.091,2.6945,2.9935,3.579,3.6678,3.0618,2.6735,2.9701,3.5529,3.6377,3.0394,2.6599,2.9504,3.5283,3.6172,3.0235,2.6351,2.9278,3.5067,3.5895,2.9975,2.619,2.9133,3.4826,3.5675,2.9826,2.6036,2.8942,3.4596,3.5455,2.9614,2.5883,2.8788,3.4367,3.5282,2.9502,2.5722,2.8655,3.42,3.5055,2.932,2.5581,2.8457,3.3978,3.4816,2.9092,2.541,2.8261,3.3756,3.4641,2.8924,2.5263,2.813,3.3543,3.443,2.8749,2.5117,2.7975,3.3391,3.424,2.8599,2.4983,2.7795,3.3204,3.4067,2.8444,2.4838,2.7643,3.3019,3.3881,2.8301,2.4712,2.752,3.2897,3.3758,2.8208,2.4679,2.7502,3.3177,3.4029,2.8481,2.4924,2.7647,3.315,3.396,2.8405,2.487,2.7559,3.3032,3.3827,2.8291,2.4815,2.7472,3.2941,3.3758,2.8232,2.4752,2.7412,3.2829,3.3624,2.8146,2.465,2.7384,3.2756,3.36,2.793,2.4433,2.7227,3.2531,3.3459,2.7977,2.4458,2.7218,3.2574,3.3361,2.7943,2.4391,2.7142,3.2485,3.3314,2.7918,2.4442,2.7117,3.2455,3.3319,2.7883,2.4438,2.7075,3.2376,3.3264,2.7849,2.4351,2.7049,3.2283,3.3189,2.7799,2.4272,2.697,3.2278,3.3096,2.7775,2.4229,2.6928,3.2187,3.3062,2.7741,2.4262,2.6852,3.2109,3.3051,2.7653,2.4174,2.6869,3.2107,3.304,2.7692,2.4138,2.6854,3.2068,3.2992,2.7686,2.413,2.6773,3.2034,3.2941,2.7625,2.4162,2.6727,3.203,3.2977,2.7632,2.411,2.6768,3.1992,3.294,2.7635,2.4081,2.6682,3.1961,3.2863,2.767,0.0:0
-4.9667E-6,5.44E-6,1.0037E-5,-7.94E-6,7.71E-6,-4.43E-6,-1.4667E-7,9.3767E-6,-9.8967E-6,9.91E-6,-2.61E-6,3.2E-6,1.1513E-5,-1.6433E-6,8.6733E-6,3.31E-6,3.7133E-6,8.8833E-6,-4.69E-6,1.32E-5,-4.5333E-6,-1.0967E-6,1.1373E-5,-3.0767E-6,1.2947E-5,-4.4033E-6,2.9667E-6,7.23E-6,-7.4967E-6,1.3993E-5,-5.8567E-6,5.64E-6,9.3E-6,-8.5E-6,7.59E-6,0.0012242,0.18854,0.22119,0.18382,0.15506,0.18801,0.22044,0.22248,0.18269,0.15594,0.18677,0.2201,0.22316,0.18266,0.15644,0.18613,0.21979,0.22385,0.18282,0.15662,0.18571,0.21998,0.22413,0.1833,0.15682,0.18516,0.21971,0.22451,0.18385,0.15681,0.18465,0.21941,0.22473,0.18417,0.15698,0.18424,0.21884,0.22501,0.1848,0.15679,0.18377,0.21869,0.22527,0.18515,0.15669,0.18343,0.21806,0.2257,0.18567,0.15674,0.18294,0.2177,0.22596,0.1858,0.15682,0.18256,0.2174,0.22625,0.18656,0.15672,0.18215,0.2169,0.2261,0.18673,0.15676,0.18163,0.21664,0.2264,0.18711,0.15685,0.18157,0.21641,0.22703,0.18812,0.15692,0.18097,0.2162,0.22718,0.18842,0.15687,0.18054,0.21583,0.22735,0.18886,0.15683,0.18021,0.21528,0.22731,0.18913,0.15674,0.17957,0.21472,0.22736,0.18967,0.15661,0.17898,0.2141,0.22745,0.1899,0.15666,0.17877,0.21355,0.22765,0.1902,0.15659,0.17847,0.21309,0.22774,0.19064,0.15654,0.17767,0.21258,0.22776,0.19103,0.1565,0.17713,0.21202,0.22773,0.19162,0.15671,0.17687,0.21175,0.22797,0.19184,0.15675,0.17654,0.21126,0.22809,0.19247,0.15683,0.17615,0.21087,0.228,0.19283,0.1566,0.17575,0.21008,0.22794,0.1932,0.15685,0.17543,0.20982,0.22803,0.19364,0.15676,0.17499,0.20922,0.22821,0.194,0.15683,0.17464,0.20875,0.22814,0.19432,0.15685,0.17418,0.20836,0.2284,0.1948,0.15697,0.17403,0.20782,0.22816,0.19517,0.1571,0.0:0
1.0503E-5,4.59E-6,-2.43E-6,1.6653E-5,-1.1707E-5,1.3327E-5,2.15E-6,-8.06E-6,1.135E-5,-1.1033E-5,1.0273E-5,4.9067E-6,-4.42E-6,9.9033E-6,-1.2107E-5,1.1497E-5,2.6767E-6,-1.0533E-6,1.186E-5,-7.6967E-6,8.86E-6,5.9233E-6,-3.2733E-6,1.586E-5,-1.382E-5,1.039E-5,4.41E-6,-3.33E-6,7.9867E-6,-1.072E-5,1.263E-5,3.0333E-6,-6.61E-6,1.4567E-5,-5.0233E-6,7.17E-6,5.3433E-6,-5.8E-6,1.118E-5,-1.1647E-5,1.0503E-5,2.1267E-6,-6.38E-6,1.6553E-5,-1.4137E-5,1.265E-5,4.5467E-6,-3.23E-6,1.2133E-5,-1.0137E-5,1.3057E-5,4.04E-6,-1.14E-6,1.4713E-5,-1.146E-5,1.2417E-5,5.4333E-6,-1.2867E-6,1.32E-5,-9.9333E-6,1.1363E-5,1.7833E-6,-1.0933E-6,9.7133E-6,-1.1937E-5,1.277E-5,3.4733E-6,-7.3067E-6,0.0059885,0.017254,0.019825,0.023028,0.022722,0.018539,0.017152,0.019645,0.023018,0.022786,0.018393,0.017246,0.019545,0.022991,0.0228,0.018329,0.017274,0.019521,0.022988,0.022784,0.018291,0.017262,0.019413,0.02291,0.022742,0.018237,0.017216,0.019346,0.022843,0.022685,0.018212,0.017181,0.019303,0.022774,0.022594,0.018141,0.01709,0.019201,0.022673,0.022483,0.018029,0.01701,0.0191,0.022503,0.022337,0.017941,0.0169,0.018965,0.022381,0.022184,0.017812,0.016778,0.018829,0.0222,0.022039,0.0177,0.016677,0.018694,0.022086,0.021898,0.017582,0.016574,0.018605,0.021895,0.02171,0.017409,0.016427,0.018426,0.021676,0.021465,0.017221,0.016232,0.018229,0.021355,0.021158,0.016969,0.016005,0.017955,0.021008,0.020776,0.01665,0.015728,0.017642,0.020616,0.020385,0.01632,0.015415,0.017318,0.020159,0.019892,0.0159,0.015071,0.01689,0.019658,0.019301,0.015426,0.014631,0.016388,0.019025,0.018644,0.014893,0.01412,0.015826,0.018299,0.01787,0.014259,0.013534,0.015144,0.017448,0.017039,0.013529,0.012858,0.014411,0.01651,0.016107,0.012815,0.012162,0.013599,0.015548,0.015188,0.012038,0.011427,0.012757,0.014555,0.014203,0.011226,0.010655,0.011913,0.013576,0.013322,0.010521,0.010025,0.011201,0.012784,0.0126,0.0099725,0.0095012,0.010597,0.012136,0.01202,0.009506,0.0090329,0.010098,0.011584,0.01154,0.0091562,0.0087164,0.0097425,0.011258,0.011269,0.0089516,0.0085284,0.009525,0.011034,0.011094,0.0088344,0.0083908,0.0093797,0.010889,0.010931,0.0086941,0.0082559,0.0092323,0.010725,0.010827,0.0086366,0.0081937,0.0091287,0.010664,0.010785,0.0085803,0.0081293,0.0090896,0.010585,0.010723,0.0085552,0.0080965,0.0090469,0.010534,0.010711,0.0085361,0.0080885,0.0090547,0.010559,0.010756,0.0085785,0.0081504,0.0090975,0.010586,0.01075,0.0085648,0.0081107,0.0090358,0.010535,0.010707,0.0085502,0.0080787,0.0090155,0.01054,0.010688,0.0085282,0.0080513,0.0089841,0.010483,0.010667,0.008552,0.0080682,0.0089917,0.010498,0.010678,0.0085189,0.0080106,0.0089479,0.01044,0.01063,0.0085104,0.0080114,0.0089428,0.01042,0.010656,0.0084934,0.0079899,0.0089236,0.010414,0.01064,0.0085023,0.007995,0.0089144,0.010425,0.01065,0.0085152,0.0080266,0.0089253,0.010428,0.01065,0.0085212,0.0080023,0.0088914,0.010437,0.010642,0.0085006,0.0079978,0.0088783,0.010388,0.010616,0.0085004,0.0079958,0.0088848,0.010432,0.010637,0.008508,0.0079843,0.0088788,0.0104,0.01062,0.0085147,0.0079603,0.0088643,0.010384,0.010624,0.0085216,0.0079547,0.0088736,0.010389,0.010628,0.0085266,0.0079671,0.0088647,0.010376,0.010626,0.0085385,0.0079694,0.0088545,0.010342,0.010623,0.0085185,0.0079603,0.0088538,0.010371,0.010657,0.0085253,0.0079796,0.0088526,0.010366,0.010658,0.0085367,0.0079763,0.0088452,0.010381,0.01068,0.0085478,0.0079908,0.0088554,0.010397,0.01064,0.0085547,0.0079729,0.0088197,0.010361,0.010639,0.0085557,0.0079591,0.0088345,0.010389,0.010651,0.0085602,0.007957,0.0088226,0.010351,0.010637,0.0085817,0.0079465,0.0088112,0.010351,0.010646,0.0085707,0.0079353,0.0087959,0.010317,0.010629,0.0085758,0.0079267,0.0088068,0.010321,0.010657,0.0085787,0.0079206,0.0087854,0.010314,0.010649,0.008582,0.0079555,0.0088093,0.010343,0.010667,0.0085834,0.0079419,0.0087586,0.010307,0.010655,0.0085694,0.0079391,0.0087595,0.010312,0.010655,0.0085898,0.0079534,0.0087561,0.010301,0.010642,0.008574,0.0079231,0.0087365,0.010315,0.010646,0.0085971,0.0079376,0.0087558,0.010314,0.010632,0.0086126,0.0079194,0.0087534,0.010301,0.01066,0.0086316,0.0079292,0.008766,0.01029,0.01066,0.0086372,0.0079133,0.0087578,0.010261,0.010631,0.0086234,0.0079166,0.0087451,0.010263,0.010671,0.0086145,0.0079095,0.008751,0.010268,0.010678,0.0086215,0.0079416,0.0087668,0.010296,0.010693,0.0086359,0.007938,0.0087387,0.010275,0.010666,0.0086322,0.0079404,0.0087186,0.010286,0.010657,0.0086186,0.0079184,0.0086956,0.010277,0.010662,0.0086424,0.0079379,0.0087037,0.010318,0.010683,0.0086471,0.0079378,0.0087273,0.010284,0.010642,0.008657,0.0079233,0.0087178,0.010273,0.010664,0.0086623,0.0079013,0.0087204,0.010233,0.010642,0.0086618,0.0078986,0.0087099,0.010215,0.010656,0.0086432,0.0078911,0.0087071,0.010218,0.010666,0.008648,0.0078956,0.0086937,0.01023,0.010691,0.0086751,0.0079287,0.0087022,0.010242,0.010683,0.008654,0.0079055,0.0086652,0.010246,0.010675,0.00866,0.0079336,0.0086975,0.010274,0.010681,0.0086862,0.0079124,0.00866,0.01025,0.010669,0.0086983,0.0079205,0.008695,0.010286,0.010688,0.008726,0.0079082,0.0086784,0.010269,0.010687,0.0087328,0.007922,0.0087127,0.010271,0.01069,0.0012159:0
9.7767E-6,-3.9867E-6,2.3933E-6,5.24E-6,7.4333E-7,7.7867E-6,-4.09E-6,1.75E-6,7.7367E-6,-5.3533E-6,9.5567E-6,-2.9033E-6,2.81E-6,8.69E-6,-2.6267E-6,1.0593E-5,1.1633E-6,1.7067E-6,4.41E-6,-3.3333E-6,9.8467E-6,-2.6867E-6,7.2867E-6,9.1867E-6,-5.0767E-6,5.9033E-6,-2.8267E-6,1.053E-5,7.3767E-6,-2.51E-6,1.1283E-5,-7.3967E-6,-1.3567E-6,6.3833E-6,-6.1933E-6,6.6867E-6,-4.35E-6,1.5E-6,5.2833E-6,-5.4367E-6,1.1337E-5,-7.0767E-6,2.4983E-5,0.15387,0.21833,0.16391,0.18642,0.21732,0.24417,0.21454,0.16666,0.184,0.21417,0.23919,0.21138,0.16516,0.18065,0.21408,0.24179,0.21067,0.16539,0.17983,0.21426,0.24153,0.21049,0.16597,0.17941,0.21418,0.2414,0.21055,0.16625,0.17925,0.21393,0.24122,0.21056,0.16638,0.17896,0.21397,0.2412,0.21075,0.16646,0.17898,0.21381,0.24134,0.21083,0.16647,0.17871,0.21328,0.24127,0.21092,0.16628,0.17875,0.2132,0.24126,0.2109,0.16634,0.17844,0.21298,0.24131,0.2111,0.16645,0.17833,0.21272,0.24106,0.21085,0.16645,0.17814,0.21254,0.24101,0.21076,0.1666,0.17792,0.21245,0.24092,0.21102,0.16658,0.17759,0.21228,0.24068,0.21118,0.16646,0.17756,0.21203,0.24061,0.21122,0.16641,0.17747,0.21196,0.24041,0.21154,0.16662,0.17764,0.21193,0.24045,0.21166,0.16663,0.17756,0.21162,0.24072,0.21195,0.16652,0.17751,0.21153,0.24074,0.212,0.16664,0.17763,0.21135,0.24079,0.21195,0.16667,0.17728,0.21105,0.24057,0.21197,0.16668,0.17725,0.21087,0.24064,0.21215,0.16671,0.17712,0.2108,0.24073,0.2124,0.16691,0.17684,0.21067,0.24067,0.21236,0.16703,0.1767,0.21056,0.24034,0.21236,0.16705,0.17662,0.21053,0.24028,0.21257,0.16722,0.17669,0.21049,0.24039,0.21289,0.16717,0.17649,0.21033,0.24027,0.21316,0.16704,0.17651,0.20991,0.24022,0.21309,0.16708,0.1764,0.20975,0.24011,0.2131,0.0:0
2.5473E-5,2.9123E-5,2.2557E-5,2.022E-5,2.062E-5,2.4657E-5,2.8093E-5,2.265E-5,1.944E-5,2.1437E-5,2.532E-5,2.8763E-5,2.2453E-5,2.0047E-5,2.1907E-5,2.5307E-5,2.8373E-5,2.2953E-5,2.0433E-5,2.0953E-5,2.5203E-5,2.8237E-5,2.306E-5,1.951E-5,2.063E-5,2.5667E-5,2.8543E-5,2.2467E-5,1.8713E-5,2.0993E-5,2.4857E-5,2.8217E-5,2.325E-5,1.938E-5,2.1677E-5,2.49E-5,2.873E-5,2.2527E-5,1.9977E-5,2.094E-5,2.599E-5,2.789E-5,2.302E-5,1.932E-5,2.115E-5,2.4323E-5,2.8473E-5,2.331E-5,2.039E-5,2.1057E-5,2.4273E-5,2.707E-5,2.2133E-5,1.919E-5,2.1427E-5,2.4157E-5,2.8353E-5,2.285E-5,1.9107E-5,2.0677E-5,2.5613E-5,2.9523E-5,2.3123E-5,1.9843E-5,2.0817E-5,2.4623E-5,2.82E-5,2.268E-5,1.962E-5,2.089E-5,2.4427E-5,2.8633E-5,2.2203E-5,1.8857E-5,2.0707E-5,2.4507E-5,2.7857E-5,2.3383E-5,1.9713E-5,2.0967E-5,2.4977E-5,2.8847E-5,2.306E-5,2.0017E-5,2.1183E-5,2.4093E-5,2.834E-5,2.378E-5,1.874E-5,2.1437E-5,2.459E-5,2.8917E-5,2.3413E-5,1.84E-5,2.0653E-5,2.3243E-5,2.835E-5,2.3383E-5,1.8607E-5,2.0937E-5,2.5977E-5,2.82E-5,2.2107E-5,1.8567E-5,2.062E-5,2.4847E-5,2.816E-5,2.3597E-5,1.894E-5,2.1057E-5,2.6103E-5,3.1653E-5,2.568E-5,2.0867E-5,2.2667E-5,2.6393E-5,3.2927E-5,2.5783E-5,2.2763E-5,2.3093E-5,2.7287E-5,3.2803E-5,2.678E-5,2.1443E-5,2.2933E-5,2.6643E-5,3.3767E-5,2.536E-5,2.1353E-5,2.361E-5,2.6797E-5,3.2767E-5,2.536E-5,2.1883E-5,2.2503E-5,2.7433E-5,3.2127E-5,2.6817E-5,2.1427E-5,2.3003E-5,2.74E-5,3.2E-5,2.608E-5,2.1027E-5,2.291E-5,2.646E-5,3.283E-5,2.6637E-5,2.1577E-5,2.3707E-5,2.6983E-5,3.242E-5,2.692E-5,2.1277E-5,2.3193E-5,2.6073E-5,9.8086E-4,0.0016992,0.0013129,0.0012344,0.0013557,0.0016319,0.0016535,0.0013194,0.0011932,0.001402,0.0016321,0.0016321,0.0013668,0.0011593,0.0014205,0.001622,0.0016326,0.001376,0.0011602,0.0014178,0.0016245,0.0016311,0.0013688,0.0011562,0.0014147,0.001621,0.0016248,0.0013691,0.001156,0.0014075,0.0016214,0.0016306,0.0013682,0.0011588,0.0014111,0.0016196,0.0016273,0.0013612,0.0011542,0.0014057,0.0016142,0.0016217,0.0013706,0.0011547,0.0014074,0.0016155,0.0016218,0.0013665,0.0011522,0.0014031,0.001615,0.0016213,0.0013666,0.0011466,0.0014009,0.0016081,0.0016105,0.0013693,0.0011496,0.0014,0.0016035,0.0016184,0.0013604,0.0011485,0.0014002,0.0016006,0.0016173,0.0013552,0.0011448,0.0013953,0.0015968,0.0016147,0.0013562,0.0011408,0.0013885,0.0015941,0.0016131,0.0013636,0.0011477,0.001391,0.0015938,0.0016053,0.0013577,0.00114,0.0013928,0.0015881,0.001607,0.0013566,0.0011425,0.0013837,0.0015905,0.0016066,0.001354,0.0011425,0.0013844,0.0015882,0.0016039,0.0013501,0.0011399,0.001379,0.0015825,0.0016063,0.0013553,0.0011342,0.0013758,0.0015802,0.0015966,0.0013449,0.0011315,0.0013755,0.0015732,0.0015894,0.0013426,0.0011318,0.0013696,0.0015753,0.0015904,0.0013436,0.0011286,0.0013709,0.0015698,0.001586,0.001335,0.0011276,0.0013587,0.0015666,0.0015846,0.0013324,0.0011239,0.0013596,0.001558,0.0015765,0.0013304,0.0011236,0.0013599,0.0015547,0.001579,0.0013302,0.0011195,0.0013527,0.0015505,0.0015687,0.0013255,0.0011139,0.0013493,0.0015489,0.0015625,0.0013281,0.0011126,0.0013461,0.0015431,0.0015532,0.0013237,0.0011091,0.001348,0.0015369,0.0015572,0.001315,0.0011071,0.0013396,0.0015295,0.001556,0.00131,0.0011045,0.0013342,0.0015241,0.0015437,0.0013026,0.001098,0.0013238,0.0015207,0.0015406,0.0012995,0.0010933,0.0013207,0.0015176,0.0015293,0.0012923,0.0010884,0.0013112,0.0015104,0.0015272,0.0012947,0.0010825,0.0013089,0.0015006,0.0015174,0.001284,0.0010862,0.0013076,0.0014929,0.0015149,0.0012804,0.0010769,0.0013005,0.0014861,0.0014999,0.0012787,0.0010704,0.001292,0.0014829,0.0014915,0.0012653,0.0010683,0.0012899,0.0014777,0.0014853,0.0012633,0.001063,0.0012768,0.0014674,0.0014767,0.0012554,0.0010579,0.0012741,0.0014593,0.0014729,0.0012482,0.0010533,0.0012659,0.0014505,0.0014658,0.0012408,0.0010476,0.0012571,0.0014408,0.0014602,0.0012425,0.0010413,0.0012525,0.0014348,0.0014459,0.0012283,0.0010354,0.0012398,0.0014234,0.0014435,0.0012187,0.0010304,0.0012351,0.0014135,0.0014275,0.0012073,0.0010201,0.0012333,0.0014081,0.0014177,0.0012001,0.0010137,0.0012197,0.0013994,0.0014132,0.0011965,0.0010104,0.0012155,0.0013965,0.0014023,0.0011917,0.0010064,0.0012009,0.0013861,0.0013948,0.0011838,0.0010011,0.001201,0.0013776,0.0013848,0.0011765,9.9213E-4,0.0011963,0.0013692,0.0013795,0.001174,9.9274E-4,0.0011875,0.0013622,0.0013725,0.0011643,9.8327E-4,0.0011848,0.0013525,0.0013615,0.00116,9.7825E-4,0.001179,0.0013451,0.0013586,0.0011448,9.7361E-4,0.0011695,0.0013363,0.001348,0.0011428,9.67E-4,0.0011603,0.0013297,0.001341,0.0011349,9.6156E-4,0.0011567,0.0013226,0.0013309,0.0011319,9.5116E-4,0.0011484,0.0013192,0.0013252,0.0011239,9.5219E-4,0.0011436,0.0013096,0.0013184,0.0011202,9.4388E-4,0.0011343,0.0012995,0.0013086,0.0011163,9.4281E-4,0.001131,0.0012963,0.0012996,0.0011048,9.3583E-4,0.0011283,0.0012822,0.0013006,0.0011055,9.3096E-4,0.0011169,0.0012826,0.0012954,0.0010961,9.2855E-4,0.0011182,0.0012762,0.0012858,0.0010946,9.2934E-4,0.0011093,0.0012721,0.0012847,0.0010964,9.222E-4,0.0011016,0.0012629,0.0012785,0.0010893,9.185E-4,0.0011018,0.001266,0.0012752,0.0010861,9.1738E-4,0.0011008,0.0012574,0.0012696,0.0010852,9.1419E-4,0.001093,0.0012553,0.0012657,0.0010812,9.1187E-4,0.0010868,0.0012449,0.0012675,0.0010755,9.0389E-4,0.0010869,0.0012508,0.0012582,0.0010735,9.0768E-4,0.0010836,0.0012413,0.0012616,0.0010757,9.0478E-4,0.0010773,0.0012423,0.0012603,0.0010724,9.0314E-4,0.0010741,0.0012422,0.0012562,0.0010693,9.0351E-4,0.0010756,0.0012415,0.0012488,0.001068,9.0333E-4,0.0010771,0.0012326,0.0012485,0.0010696,8.9949E-4,0.001072,0.0012355,0.0012473,0.0010683,8.9778E-4,0.0010704,0.0012339,0.0012505,0.0010676,8.9379E-4,0.0010703,0.0012304,0.0012448,0.0010665,8.9345E-4,0.0010678,0.0012248,0.0012411,0.0010619,8.9169E-4,0.0010682,0.0012233,0.0012406,0.0010662,8.9319E-4,0.0010605,0.0012201,0.0012451,0.001066,8.9249E-4,0.0010576,0.0012207,0.0012422,0.0010649,8.8833E-4,0.0010602,0.0012206,0.0012456,0.0010625,8.8873E-4,0.0010574,0.0012205,0.0012407,0.0010602,8.9233E-4,0.0010595,0.001218,0.001239,0.0010615,8.9218E-4,0.0010562,0.0012144,0.0012339,0.0010674,8.8959E-4,0.0010564,0.0012162,0.0012445,0.0010641,8.8477E-4,0.001051,0.0012141,0.001243,0.0010586,8.8687E-4,0.0:0
1.966E-5,2.518E-5,2.8087E-5,2.5987E-5,2.096E-5,1.9113E-5,2.448E-5,2.7707E-5,2.6507E-5,2.1887E-5,1.9777E-5,2.4223E-5,2.841E-5,2.728E-5,2.1343E-5,1.89E-5,2.4787E-5,2.8483E-5,2.642E-5,2.247E-5,2.0487E-5,2.6327E-5,2.799E-5,2.7433E-5,2.157E-5,1.9267E-5,2.469E-5,2.6673E-5,2.5867E-5,2.1933E-5,2.0607E-5,2.445E-5,2.665E-5,2.6233E-5,2.179E-5,1.926E-5,2.534E-5,2.8573E-5,2.6437E-5,2.1713E-5,1.8863E-5,2.5347E-5,2.6953E-5,2.6643E-5,2.1843E-5,1.9193E-5,2.5687E-5,2.7433E-5,2.617E-5,2.191E-5,1.966E-5,2.4627E-5,2.6593E-5,2.6817E-5,2.222E-5,2.0273E-5,2.4993E-5,2.6703E-5,2.6573E-5,2.161E-5,1.9063E-5,2.5183E-5,2.8483E-5,2.57E-5,2.189E-5,1.952E-5,2.4817E-5,2.731E-5,2.655E-5,2.172E-5,1.95E-5,2.4747E-5,2.707E-5,2.6823E-5,2.185E-5,2.0307E-5,2.5503E-5,3.012E-5,3.0397E-5,2.2557E-5,2.149E-5,2.634E-5,3.1093E-5,3.0887E-5,2.272E-5,2.1793E-5,2.7557E-5,3.0183E-5,2.9917E-5,2.3427E-5,2.1527E-5,2.686E-5,3.09E-5,3.0167E-5,2.3303E-5,2.235E-5,2.6937E-5,3.0493E-5,3.071E-5,2.2723E-5,2.15E-5,2.7417E-5,3.0683E-5,3.1337E-5,2.198E-5,2.1997E-5,2.719E-5,3.072E-5,3.1283E-5,2.17E-5,2.2403E-5,2.668E-5,2.931E-5,3.1037E-5,2.2093E-5,2.2277E-5,2.6287E-5,2.931E-5,3.046E-5,2.303E-5,2.1907E-5,2.67E-5,2.926E-5,0.0012509,0.0014907,0.0011906,0.0012974,0.0015361,0.0016451,0.0014599,0.0011961,0.0012565,0.0015719,0.00167,0.001415,0.0012383,0.0012335,0.0015755,0.0016716,0.001416,0.0012451,0.0012335,0.0015728,0.0016712,0.0014133,0.0012436,0.0012251,0.0015709,0.0016666,0.0014166,0.0012411,0.0012241,0.0015661,0.0016704,0.0014182,0.0012405,0.001222,0.0015663,0.0016648,0.0014136,0.0012382,0.0012221,0.0015608,0.0016629,0.0014142,0.0012373,0.0012194,0.0015661,0.0016621,0.0014171,0.0012345,0.0012173,0.0015501,0.0016575,0.0014147,0.0012392,0.0012139,0.0015533,0.0016574,0.0014143,0.0012378,0.0012112,0.0015474,0.0016577,0.0014109,0.0012362,0.0012059,0.0015445,0.00165,0.0014148,0.0012315,0.0012065,0.001543,0.0016485,0.0014107,0.001228,0.0012048,0.0015442,0.0016462,0.0014092,0.0012263,0.0012016,0.0015358,0.0016416,0.0014113,0.0012303,0.0011997,0.0015347,0.0016396,0.0014088,0.0012282,0.0011947,0.0015314,0.0016397,0.0014073,0.0012273,0.0011987,0.0015288,0.0016363,0.0014127,0.0012206,0.0011901,0.0015229,0.0016287,0.0014,0.0012277,0.0011884,0.0015172,0.0016263,0.0013993,0.001215,0.0011822,0.0015108,0.0016237,0.001398,0.0012139,0.001184,0.001506,0.001613,0.0013995,0.0012133,0.0011776,0.0014989,0.0016126,0.0013928,0.0012091,0.0011686,0.0014957,0.0016063,0.0013939,0.0012052,0.0011679,0.0014908,0.0015993,0.0013883,0.0012017,0.0011617,0.0014887,0.001606,0.0013888,0.0012017,0.00116,0.0014855,0.0015911,0.0013785,0.0011947,0.0011583,0.0014729,0.001583,0.0013761,0.0011933,0.0011544,0.0014668,0.0015796,0.0013755,0.0011945,0.0011478,0.0014605,0.0015752,0.0013695,0.0011842,0.0011404,0.0014571,0.0015712,0.0013686,0.0011804,0.0011369,0.0014481,0.0015639,0.0013554,0.0011728,0.0011366,0.0014452,0.0015504,0.0013527,0.0011732,0.0011325,0.0014352,0.0015457,0.0013523,0.0011636,0.0011222,0.0014284,0.0015403,0.0013453,0.0011585,0.0011165,0.0014235,0.0015276,0.0013358,0.0011544,0.0011134,0.0014063,0.0015211,0.001327,0.0011474,0.0011029,0.001403,0.001514,0.0013279,0.0011458,0.0010946,0.0013933,0.001507,0.0013237,0.0011402,0.0010897,0.001388,0.0014945,0.0013106,0.0011365,0.0010875,0.0013771,0.0014866,0.0013025,0.0011246,0.0010779,0.001369,0.0014798,0.0012996,0.0011272,0.0010696,0.0013621,0.0014708,0.0012926,0.0011162,0.0010697,0.0013536,0.0014651,0.0012832,0.0011124,0.0010588,0.0013463,0.0014558,0.0012814,0.0011006,0.0010533,0.0013366,0.0014423,0.001279,0.0010985,0.001048,0.0013284,0.0014378,0.0012679,0.0010944,0.0010406,0.0013159,0.0014243,0.0012582,0.0010843,0.0010317,0.0013108,0.001416,0.0012568,0.0010765,0.0010231,0.0013054,0.0014063,0.0012502,0.0010782,0.0010235,0.0012921,0.0014001,0.0012457,0.0010683,0.0010188,0.0012824,0.0013901,0.0012381,0.0010625,0.0010084,0.0012723,0.0013909,0.0012312,0.0010589,0.0010106,0.0012696,0.0013759,0.0012321,0.0010557,0.0010025,0.0012618,0.0013718,0.0012203,0.0010464,9.953E-4,0.0012544,0.0013585,0.0012185,0.001045,9.8337E-4,0.0012472,0.0013616,0.0012118,0.0010349,9.8164E-4,0.0012426,0.001348,0.0012096,0.001039,9.7646E-4,0.0012275,0.0013443,0.001203,0.0010265,9.7198E-4,0.0012295,0.0013387,0.0012009,0.0010292,9.6784E-4,0.0012236,0.001332,0.0012014,0.0010241,9.6164E-4,0.0012122,0.0013293,0.0011956,0.00102,9.6203E-4,0.0012135,0.0013212,0.0011911,0.0010235,9.5565E-4,0.0012038,0.001315,0.0011891,0.0010125,9.5015E-4,0.0011979,0.001311,0.0011869,0.0010092,9.4446E-4,0.0011937,0.0013036,0.0011825,0.001014,9.4388E-4,0.0011886,0.0013003,0.0011829,0.0010083,9.4304E-4,0.001182,0.0012952,0.0011752,0.0010013,9.3839E-4,0.0011789,0.001293,0.0011737,0.0010005,9.3259E-4,0.0011748,0.0012888,0.001176,9.9966E-4,9.2784E-4,0.0011692,0.0012825,0.0011745,9.9651E-4,9.2717E-4,0.001165,0.0012865,0.00117,9.984E-4,9.2646E-4,0.0011626,0.0012818,0.001171,0.0010003,9.268E-4,0.001157,0.0012758,0.0011728,9.9764E-4,9.1923E-4,0.001151,0.0012741,0.0011739,9.9624E-4,9.1814E-4,0.0011489,0.0012717,0.0011739,9.9412E-4,9.1588E-4,0.0011468,0.0012637,0.0011664,9.8633E-4,9.1501E-4,0.0011445,0.0012658,0.0011688,9.9879E-4,9.1561E-4,0.0011399,0.0012634,0.0011663,9.9662E-4,9.0798E-4,0.0011403,0.0012623,0.0011761,9.9272E-4,9.0872E-4,0.0011327,0.0012607,0.0011735,9.9231E-4,9.0609E-4,0.0011393,0.0012602,0.0011682,9.9033E-4,9.0425E-4,0.001136,0.001257,0.0011667,9.955E-4,9.0777E-4,0.0011308,0.0012545,0.0011681,9.9657E-4,9.011E-4,0.0011301,0.0012549,0.0011714,9.9432E-4,8.2067E-4:0
-3.0633E-6,1.213E-5,9.8433E-6,-1.0933E-5,1.9993E-5,1.8503E-5,2.0333E-7,2.323E-5,5.98E-6,1.246E-5,5.1E-6,8.5833E-6,2.2087E-5,-1.7497E-5,1.7863E-5,1.1637E-5,1.1333E-7,2.7323E-5,-3.56E-6,2.6897E-5,1.5207E-5,9.4733E-6,2.456E-5,-1.0747E-5,2.5127E-5,4.25E-6,-2.0333E-7,2.787E-5,-1.4587E-5,3.5953E-5,-4.1667E-6,0.0030954,0.1758,0.21559,0.18351,0.22703,0.27087,0.26064,0.20557,0.17956,0.21468,0.23233,0.18486,0.090142,0.030289,0.029636,0.040188,0.037598,0.02565,0.021329,0.028564,0.033766,0.034645,0.027314,0.024501,0.027409,0.035005,0.036764,0.027278,0.024429,0.028565,0.036839,0.036806,0.026687,0.0252,0.03023,0.037196,0.036367,0.027275,0.026533,0.031245,0.03722,0.03654,0.02841,0.027389,0.031495,0.038069,0.037354,0.029328,0.027905,0.03154,0.038729,0.037772,0.029765,0.027917,0.031904,0.039555,0.03787,0.030383,0.02806,0.032917,0.040271,0.038134,0.031069,0.028436,0.033623,0.041022,0.038648,0.031464,0.028687,0.033882,0.041187,0.039059,0.032125,0.028803,0.03446,0.041241,0.039374,0.032632,0.028842,0.035445,0.041199,0.039812,0.03294,0.029218,0.035846,0.041331,0.040892,0.033262,0.029323,0.036322,0.041054,0.041067,0.033293,0.029426,0.036952,0.041027,0.041711,0.033509,0.030239,0.037187,0.04127,0.042916,0.033717,0.030519,0.037486,0.040844,0.043211,0.033344,0.03087,0.037604,0.04122,0.043594,0.033423,0.03179,0.037252,0.041756,0.044327,0.033316,0.032024,0.036993,0.041618,0.044636,0.033344,0.032318,0.036708,0.042114,0.044624,0.033354,0.032765,0.036391,0.043554,0.044643,0.034055,0.03316,0.036382,0.044512,0.044658,0.03406,0.033179,0.036167,0.045033,0.04385,0.034515,0.032921,0.03632,0.045838,0.043589,0.035109,0.032815,0.036425,0.046054,0.043123,0.035306,0.032237,0.03703,0.04605,0.042667,0.035986,0.03192,0.03766,0.045986,0.043173,0.036194,0.031854,0.038131,0.04533,0.043081,0.036499,0.031513,0.038654,0.044816,0.042987,0.03678,0.031327,0.039178,0.044247,0.044234,0.03671,0.031571,0.039446,0.043407,0.044316,0.036407,0.031475,0.039493,0.042809,0.044969,0.035875,0.032125,0.039081,0.042432,0.045944,0.035596,0.032237,0.038866,0.041793,0.046005,0.034775,0.03284,0.038205,0.042522,0.046161,0.034722,0.03317,0.037669,0.042752,0.046216,0.03439,0.033379,0.036988,0.042806,0.045945,0.034346,0.033421,0.036227,0.043877,0.045218,0.034468,0.033349,0.035772,0.044787,0.044948,0.034608,0.033134,0.035302,0.045208,0.043762,0.034743,0.032681,0.035609,0.045545,0.043259,0.035549,0.032186,0.035692,0.045424,0.042748,0.035538,0.031677,0.03602,0.045081,0.041907,0.036017,0.031149,0.036716,0.044599,0.042419,0.036227,0.030961,0.036813,0.043939,0.042466,0.036295,0.030541,0.037389,0.043278,0.042244,0.036371,0.030275,0.037871,0.042404,0.043298,0.036175,0.030677,0.037737,0.041646,0.043897,0.035898,0.030411,0.037661,0.040858,0.04414,0.035056,0.030997,0.037219,0.040655,0.04502,0.03475,0.031358,0.036927,0.039839,0.045042,0.034205,0.031413,0.036176,0.040267,0.044599,0.033632,0.031813,0.035277,0.040858,0.044774,0.033544,0.031949,0.034617,0.040936,0.044444,0.033268,0.031964,0.03405,0.041527,0.0438,0.033242,0.031869,0.033601,0.042693,0.043158,0.033871,0.031653,0.033357,0.042985,0.042465,0.033744,0.031314,0.033119,0.042961,0.041569,0.034302,0.030783,0.033621,0.042948,0.041363,0.03462,0.030316,0.033497,0.042608,0.040542,0.034615,0.029635,0.033984,0.042153,0.040078,0.034737,0.029177,0.034359,0.041666,0.04067,0.0349,0.028983,0.034566,0.040986,0.040519,0.03487,0.028508,0.034778,0.04,0.040194,0.034692,0.028435,0.035108,0.039195,0.041183,0.034657,0.028965,0.034797,0.038726,0.042165,0.034437,0.028861,0.034914,0.038041,0.04241,0.033722,0.029193,0.034547,0.037961,0.042867,0.033248,0.029636,0.033974,0.037895,0.043422,0.033032,0.029667,0.033616,0.037657,0.04281,0.032298,0.03,0.032848,0.038442,0.04223,0.03221,0.03012,0.032135,0.03872,0.042232,0.031941,0.030078,0.031581,0.038702,0.041782,0.032078,0.030132,0.031108,0.039089,0.041053,0.032028,0.029803,0.030918,0.039765,0.04057,0.032647,0.029442,0.030573,0.039836,0.040095,0.03263,0.029114,0.030482,0.039894,0.039146,0.032687,0.028518,0.030904,0.026172:0
-3.6067E-6,7.1433E-6,-1.36E-6,-5.33E-6,9.08E-6,-1.0467E-6,1.3433E-5,-2.4667E-6,2.76E-6,1.058E-5,-6.5833E-6,8.36E-6,2.63E-6,2.8467E-6,4.92E-6,-2.6567E-6,9.4033E-6,-2.9333E-7,2.84E-6,1.1623E-5,-2.9733E-6,9.0767E-6,3.1467E-6,1.5233E-6,1.0867E-5,-4.92E-6,1.046E-5,2.0767E-6,1.21E-6,0.0048304,0.0072779,0.0076745,0.0090773,0.0091168,0.0074244,0.0068962,0.0076508,0.0090646,0.0090603,0.0074902,0.0068141,0.0076927,0.0090372,0.079493,0.19027,0.15747,0.16425,0.20525,0.22417,0.19264,0.1584,0.1605,0.19985,0.21295,0.17817,0.13203,0.10796,0.070644,0.031806,0.026821,0.028978,0.025541,0.024956,0.030289,0.028086,0.021545,0.023009,0.030407,0.031601,0.02658,0.021876,0.025767,0.030908,0.031058,0.02779,0.023884,0.026448,0.030204,0.032509,0.029634,0.024434,0.025919,0.030111,0.033962,0.030169,0.024227,0.025996,0.030899,0.035059,0.029889,0.024551,0.026508,0.031469,0.035884,0.030048,0.02496,0.027034,0.031421,0.036309,0.029929,0.025256,0.027064,0.031792,0.036564,0.029734,0.025911,0.026867,0.032531,0.037268,0.030053,0.026341,0.027142,0.032795,0.037534,0.030305,0.026751,0.027199,0.033311,0.037611,0.030509,0.027184,0.027063,0.034386,0.037672,0.030969,0.027472,0.027108,0.035176,0.037917,0.031267,0.027614,0.027135,0.035728,0.037172,0.031426,0.027631,0.027532,0.036307,0.03711,0.032394,0.027436,0.027732,0.036579,0.036608,0.032595,0.02718,0.028258,0.036664,0.036326,0.033107,0.026951,0.028831,0.036306,0.0368,0.033536,0.026891,0.029304,0.035825,0.036702,0.033864,0.026596,0.029634,0.03547,0.036789,0.033754,0.026545,0.029941,0.034767,0.038086,0.03369,0.026767,0.03012,0.034077,0.038263,0.033223,0.026741,0.029969,0.033817,0.039116,0.032495,0.027332,0.029578,0.033664,0.039665,0.032238,0.02729,0.029282,0.033597,0.039507,0.031375,0.027864,0.028616,0.034389,0.039491,0.031336,0.028067,0.028348,0.034403,0.039348,0.031322,0.028091,0.027759,0.034977,0.038831,0.031113,0.028267,0.02745,0.035894,0.038199,0.031665,0.028129,0.027319,0.036179,0.037653,0.031742,0.027815,0.027172,0.036535,0.036759,0.032071,0.027382,0.027674,0.036399,0.036393,0.032607,0.027035,0.027787,0.036146,0.035503,0.032754,0.026291,0.028247,0.03562,0.035656,0.032755,0.026107,0.028683,0.035119,0.035908,0.033007,0.025821,0.028836,0.034319,0.035787,0.032968,0.02551,0.029103,0.033687,0.036229,0.032516,0.025819,0.028898,0.032981,0.037367,0.032302,0.025854,0.028876,0.0323,0.037467,0.031515,0.025936,0.028429,0.032229,0.037858,0.030936,0.026354,0.027866,0.032062,0.03795,0.030506,0.026181,0.027523,0.032134,0.037586,0.029721,0.026519,0.026819,0.032916,0.037322,0.029778,0.026801,0.026417,0.032801,0.037043,0.029607,0.026517,0.025839,0.033135,0.036379,0.029426,0.026562,0.025557,0.033686,0.035712,0.029828,0.026345,0.025453,0.033928,0.035408,0.030135,0.025942,0.025254,0.033995,0.0343,0.030123,0.025415,0.02562,0.033756,0.033801,0.030559,0.025082,0.025929,0.033554,0.033559,0.030729,0.024594,0.025929,0.033247,0.032855,0.030533,0.024085,0.026463,0.032502,0.033291,0.030678,0.024078,0.02652,0.03207,0.033646,0.030494,0.023738,0.02665,0.031331,0.033486,0.030351,0.023644,0.026713,0.030797,0.033926,0.030005,0.023798,0.026465,0.030482,0.034858,0.029727,0.023969,0.026522,0.030077,0.034888,0.029327,0.02399,0.026296,0.029752,0.034889,0.028637,0.02424,0.025651,0.030008,0.035206,0.028489,0.024462,0.025333,0.029761,0.035124,0.028056,0.024418,0.025075,0.029964,0.034637,0.027536,0.024717,0.024489,0.03048,0.034537,0.027568,0.024729,0.024156,0.030671,0.034406,0.027489,0.02468,0.023844,0.030928,0.0339,0.027503,0.024622,0.023646,0.031346,0.033252,0.027623,0.0:0
-2.0633E-6,4.32E-6,7.0533E-6,-1.42E-6,6.9633E-6,-4.4967E-6,9.93E-6,5.3833E-6,1.0E-6,5.81E-6,-6.3334E-8,8.1667E-6,7.1733E-6,2.6733E-6,6.32E-6,-4.2433E-6,5.17E-6,2.61E-6,5.8333E-7,8.6333E-6,-4.9333E-7,2.1033E-6,2.73E-6,2.3467E-6,5.3333E-8,8.3333E-7,5.3533E-6,5.0633E-6,-1.5433E-6,8.0933E-6,-2.9233E-6,3.66E-6,5.4E-6,-3.0133E-6,7.93E-6,-1.54E-6,3.7067E-6,7.1533E-6,-2.4333E-7,4.3693E-4,0.005384,0.0093535,0.0090151,0.0076368,0.0066586,0.0074842,0.0088284,0.0089793,0.0076378,0.0066078,0.0075065,0.008792,0.0089693,0.007624,0.0066053,0.007478,0.0087812,0.0089485,0.0076055,0.0065826,0.0074683,0.008773,0.0089223,0.0075808,0.0065785,0.00746,0.0087535,0.0089059,0.0075743,0.0065656,0.0074353,0.0087382,0.00887,0.0075519,0.0065448,0.0074187,0.0087214,0.0088475,0.0075156,0.0065251,0.0074074,0.0086753,0.0088241,0.0074991,0.0065,0.0074011,0.0086575,0.0088082,0.0074763,0.0064922,0.0073799,0.0086486,0.0087699,0.0074489,0.0064679,0.0073416,0.0086294,0.0087362,0.007418,0.0064526,0.0073402,0.0086077,0.0087039,0.0074032,0.0064378,0.0073154,0.0085887,0.0086732,0.0073617,0.0064096,0.0073068,0.0085527,0.0086503,0.0073332,0.0063895,0.0072826,0.0085347,0.0086196,0.0073004,0.0063674,0.0072668,0.0084942,0.0085854,0.0072617,0.0063461,0.0072488,0.14682,0.21987,0.19368,0.15331,0.16167,0.19527,0.22104,0.19192,0.15171,0.15702,0.18637,0.19807,0.15027,0.082787,0.038966,0.022094,0.034598,0.033053,0.02008,0.019619,0.026749,0.031752,0.026362,0.021512,0.024309,0.026827,0.030347,0.02769,0.02361,0.024212,0.026141,0.032372,0.028747,0.023479,0.023349,0.027801,0.034211,0.028585,0.023226,0.023815,0.029421,0.034883,0.028363,0.023559,0.024634,0.029872,0.034741,0.028531,0.024248,0.024914,0.030314,0.034658,0.02882,0.024762,0.025008,0.031151,0.034679,0.029489,0.025021,0.025103,0.031694,0.034951,0.029722,0.025123,0.025087,0.032102,0.034453,0.029734,0.025038,0.025422,0.032673,0.034267,0.030369,0.025084,0.025653,0.0328,0.034176,0.030626,0.024891,0.025787,0.033063,0.033765,0.030801,0.024587,0.026477,0.032991,0.034115,0.031322,0.0247,0.026813,0.032829,0.034152,0.031661,0.02447,0.027104,0.032641,0.034129,0.031794,0.024363,0.027591,0.032346,0.034621,0.031819,0.02461,0.027714,0.03207,0.035562,0.03187,0.024526,0.028015,0.031658,0.035617,0.031401,0.024693,0.028089,0.031514,0.036537,0.03116,0.02525,0.027908,0.031368,0.037061,0.030903,0.02527,0.027808,0.031452,0.037168,0.030313,0.025914,0.027403,0.032228,0.037585,0.030519,0.02627,0.027332,0.032317,0.037599,0.030525,0.026432,0.027093,0.032857,0.03733,0.030391,0.02668,0.026782,0.033875,0.037015,0.030914,0.026814,0.026783,0.034296,0.03676,0.030977,0.026711,0.026684,0.034822,0.035984,0.031273,0.026548,0.027053,0.035081,0.035828,0.031955,0.026325,0.027194,0.035102,0.035091,0.032212,0.025669,0.027853,0.035009,0.035163,0.032525,0.025624,0.0:0
1.9467E-6,3.55E-6,3.2333E-7,-1.09E-6,5.5E-7,6.1667E-7,2.96E-6,1.9767E-6,1.0867E-6,3.5567E-6,-2.7E-7,3.4667E-6,2.19E-6,-1.1E-7,2.4767E-6,2.1567E-6,2.3367E-6,2.63E-6,-1.14E-6,2.81E-6,8.3667E-7,-1.9333E-7,1.9333E-6,1.38E-6,3.0233E-6,1.4167E-6,2.8033E-6,1.4567E-6,-1.4033E-6,8.0667E-7,1.9367E-6,2.1E-6,2.1067E-6,9.9667E-7,2.0233E-6,1.29E-6,2.63E-6,3.5533E-6,1.4867E-6,4.4E-6,4.03E-6,2.1767E-6,5.15E-6,1.1167E-6,2.0433E-6,2.4667E-6,2.9567E-6,-5.5333E-6,-2.1033E-6,2.1533E-6,1.27E-6,1.56E-6,3.9477E-4,0.0013229,0.0011317,0.0012635,0.0014797,0.0014727,0.0011879,0.0011376,0.0012672,0.0014808,0.0014734,0.0011779,0.0011193,0.0012491,0.0014668,0.0014699,0.0011919,0.0011295,0.0012558,0.0014723,0.0014741,0.029263,0.0288,0.015086,0.0054203,0.018581,0.032396,0.025276,0.0090945,0.043601,0.046069,0.037792,0.032671,0.033056,0.042398,0.045557,0.037123,0.032308,0.03134,0.04,0.04231,0.032185,0.022338,0.016006,0.0092756,0.005822,0.0057315,0.0066084,0.0052102,0.0046913,0.006523,0.005896,0.0051508,0.0044777,0.00554,0.0071468,0.0056663,0.0047308,0.0046503,0.00601,0.0072343,0.0054942,0.0047211,0.0048625,0.0062394,0.0071585,0.0054685,0.0049138,0.0049881,0.0062445,0.007182,0.0055829,0.0050693,0.0049605,0.0062967,0.007288,0.0056562,0.0051061,0.0049675,0.0063967,0.0073048,0.0057402,0.0051799,0.0049612,0.0065012,0.0073239,0.0058211,0.0052186,0.004986,0.0065904,0.0073134,0.0058938,0.0052659,0.0049944,0.0066485,0.0073203,0.0059733,0.0052765,0.0049988,0.0067413,0.0072535,0.0060382,0.0052854,0.0050375,0.0067763,0.0072559,0.0061232,0.0052703,0.0050692,0.0068045,0.0072129,0.0062281,0.0052911,0.0051059,0.0068097,0.0072181,0.0062895,0.0052449,0.0051873,0.006805,0.0072079,0.0063601,0.0052314,0.005212,0.0067365,0.0072188,0.0064177,0.0052081,0.0052584,0.0067101,0.0072556,0.0064169,0.0051731,0.0053099,0.0066707,0.0072722,0.0064675,0.0051918,0.0053399,0.0066311,0.0073086,0.0064993,0.0052295,0.0053583,0.0065464,0.0073645,0.0065163,0.0052102,0.0053582,0.0065479,0.0073886,0.0065227,0.0052393,0.0053727,0.0064803,0.007479,0.0065011,0.0052842,0.0053477,0.0064583,0.0075465,0.006466,0.0052993,0.0053198,0.0064562,0.0075586,0.0064691,0.0053417,0.0052913,0.0064485,0.0075797,0.0064345,0.0053933,0.005302,0.0064288,0.007593,0.0064203,0.0054424,0.0052284,0.0064473,0.0075645,0.0064079,0.0054929,0.0051659,0.0064712,0.0075326,0.0064128,0.0054891,0.0051307,0.0065182,0.0075037,0.0064385,0.0054897,0.0051133,0.006563,0.0074482,0.0064637,0.0055195,0.005063,0.0065669,0.0073801,0.0064912,0.0054863,0.0050589,0.0066134,0.0072974,0.0065659,0.0054798,0.0050179,0.0066361,0.007226,0.0066293,0.005448,0.0050072,0.0066506,0.0071442,0.0066643,0.0053928,0.0049894,0.0066132,0.0070696,0.0067385,0.0053685,0.0050206,0.0065471,0.0070216,0.0067513,0.0052976,0.0050451,0.006488,0.0069753,0.0067815,0.0052143,0.0050715,0.0064252,0.006945,0.0067658,0.0051789,0.0050791,0.0063068,0.0069172,0.0067919,0.0051514,0.0050967,0.0062125,0.0069351,0.0067722,0.0051283,0.0050784,0.0061453,0.0069572,0.0067677,0.0051152,0.0051115,0.006082,0.0069969,0.0067265,0.0051307,0.0050819,0.0060359,0.0070534,0.0067319,0.0051265,0.0050781,0.0060009,0.0070925,0.0066725,0.0052009,0.0050762,0.005935,0.0071492,0.0066678,0.0052118,0.0050329,0.005918,0.0071928,0.0065993,0.0052822,0.0049988,0.0059042,0.0072235,0.0065843,0.0052977,0.0049634,0.0059394,0.0072147,0.0065537,0.0053469,0.0049114,0.0059745,0.0071951,0.0065637,0.0053831,0.0048618,0.0060374,0.0071391,0.0065915,0.0054446,0.0048417,0.0061063,0.0070883,0.0066349,0.005472,0.0048101,0.0061327,0.0070884,0.0066898,0.0054851,0.0047995,0.0061937,0.0069782,0.0067666,0.0055054,0.0048089,0.0062451,0.0069303,0.0068427,0.0053395,0.0047124,0.0063079,0.0069363,0.006857,0.0053904,0.004877,0.0063014,0.0068035,0.0069957,0.0054459,0.0049266,0.006242,0.0067595,0.0070933,0.0054074,0.0049484,0.0061849,0.0067763,0.0071622,0.0053778,0.0049944,0.006158,0.0067805,0.0071907,0.0053499,0.0050491,0.0060831,0.0068405,0.007218,0.0053338,0.0051025,0.0060376,0.0068728,0.0072402,0.0053705,0.0051302,0.0059515,0.0069721,0.0072451,0.0053675,0.0051355,0.0059402,0.0070417,0.0072372,0.0053876,0.0051738,0.0059271,0.0070892,0.0071773,0.0054581,0.0051816,0.0059097,0.0071652,0.0071474,0.005538,0.0051543,0.0058765,0.0072395,0.0071502,0.0055955,0.0051237,0.0058956,0.0073134,0.0071242,0.0056682,0.0050901,0.0059154,0.007342,0.0070943,0.0057231,0.005045,0.0059749,0.0073192,0.0070999,0.0057632,0.0050043,0.0060409,0.0072702,0.0071224,0.005813,0.0049713,0.0061181,0.0072026,0.0025755:0
1.66E-6,2.3367E-6,2.7767E-6,2.49E-6,1.0533E-6,7.0E-7,5.44E-6,4.3167E-6,1.6733E-6,2.19E-6,2.2933E-6,2.4633E-6,5.16E-6,-2.0067E-6,-3.4467E-6,-1.1667E-7,6.9667E-7,1.8567E-6,4.1267E-6,1.8733E-6,2.09E-6,1.36E-6,2.73E-6,2.5367E-6,2.0233E-6,1.86E-6,2.2E-6,3.22E-6,2.58E-6,2.15E-6,7.6333E-7,2.1667E-6,2.9733E-6,0.0012737,0.0014325,0.0011905,0.0011339,0.0012526,0.0014702,0.0014717,0.0012027,0.0011295,0.0012553,0.0014773,0.00147,0.0012032,0.0011269,0.0012489,0.0014717,0.0014769,0.0012077,0.0011246,0.0045312,0.030477,0.025112,0.018589,0.028161,0.016509,0.016366,0.020401,0.035588,0.034424,0.031988,0.042333,0.045611,0.037779,0.03325,0.032127,0.041858,0.045516,0.038174,0.033084,0.032119,0.041612,0.0453,0.038497,0.032945,0.032259,0.041418,0.045291,0.038674,0.0328,0.032066,0.04135,0.045214,0.038935,0.032887,0.032004,0.041166,0.045217,0.039026,0.032836,0.031995,0.040996,0.045125,0.03912,0.032996,0.031955,0.041007,0.045162,0.039336,0.033033,0.031802,0.040877,0.045125,0.039393,0.033124,0.03164,0.040581,0.045007,0.039671,0.033145,0.031579,0.040563,0.044958,0.039608,0.033161,0.0315,0.04031,0.044942,0.039858,0.033272,0.031499,0.040185,0.044891,0.040035,0.03332,0.031329,0.040085,0.044793,0.04024,0.033445,0.031304,0.04002,0.044777,0.040421,0.033414,0.031256,0.03982,0.044791,0.040628,0.033406,0.031225,0.039715,0.044673,0.040637,0.033558,0.031168,0.039479,0.044685,0.040858,0.033543,0.0311,0.039417,0.044625,0.041,0.033677,0.031015,0.03925,0.044423,0.04104,0.033824,0.03099,0.03923,0.044352,0.041245,0.03391,0.030904,0.039032,0.044332,0.041486,0.034055,0.030975,0.038955,0.044291,0.041644,0.034064,0.030861,0.038818,0.044316,0.041853,0.034222,0.030862,0.038688,0.044263,0.041854,0.034271,0.030761,0.038537,0.044169,0.042136,0.034442,0.030755,0.038395,0.044109,0.042195,0.034462,0.030726,0.038321,0.04408,0.0:0
7.2367E-6,9.0367E-6,8.1667E-6,6.1567E-6,5.18E-6,5.1833E-6,8.6933E-6,6.3667E-6,7.89E-6,7.5667E-6,4.87E-6,6.7033E-6,9.1467E-6,6.71E-6,5.62E-6,4.2467E-6,7.4367E-6,7.9667E-6,5.45E-6,6.65E-6,6.9967E-6,9.2167E-6,5.83E-6,6.0933E-6,8.3233E-6,5.89E-6,1.0813E-5,7.93E-6,7.8333E-6,6.78E-6,4.55E-6,9.0633E-6,8.5767E-6,3.61E-6,6.5967E-6,7.41E-6,8.73E-6,5.9233E-6,7.2133E-6,6.0967E-6,0.0076851,0.015762,0.019711,0.019886,0.015744,0.014605,0.015309,0.019671,0.019861,0.015774,0.014581,0.015318,0.01956,0.01975,0.015622,0.014586,0.015286,0.019553,0.019748,0.015688,0.014577,0.015351,0.01965,0.019759,0.015729,0.014562,0.015337,0.019495,0.019791,0.015679,0.014606,0.015516,0.019671,0.019874,0.015832,0.014688,0.015542,0.019302,0.019221,0.014761,0.012679,0.011065,0.0095883,0.0063361,0.0039068,0.0036703,0.0062025,0.0079455,0.0067451,0.0038931,0.0030431,0.0039523,0.0062984,0.0068983,0.0049922,0.0042324,0.004045,0.0053595,0.0061271,0.0049813,0.0047966,0.0048337,0.0053969,0.0056496,0.0046677,0.0047411,0.0052265,0.0057855,0.005637,0.0044848,0.004548,0.005263,0.0060783,0.0058054,0.0044961,0.0044358,0.0051797,0.006127,0.0059366,0.0045955,0.0044633,0.0051528,0.0060813,0.0059479,0.004649,0.004513,0.0051995,0.0060768,0.0059687,0.0046691,0.0045665,0.0052387,0.0060687,0.0059567,0.0046736,0.0045899,0.0053026,0.0061005,0.0059783,0.0046732,0.0045946,0.005328,0.0061185,0.0060184,0.0046645,0.0045771,0.0053326,0.0061242,0.0060457,0.0046801,0.0045973,0.0053413,0.0061132,0.0060729,0.0046863,0.0046011,0.0053616,0.0061255,0.0060838,0.0047187,0.0046376,0.0053781,0.0061549,0.0061374,0.0047456,0.0046784,0.00541,0.0061598,0.0061459,0.0047288,0.0046935,0.0054448,0.006191,0.0061406,0.0047216,0.0047147,0.0054522,0.0062327,0.006195,0.0047131,0.0047495,0.0054916,0.006284,0.0062426,0.0047029,0.004751,0.0054508,0.0062656,0.0062682,0.0047267,0.004783,0.0054631,0.0062727,0.006248,0.0046996,0.0048086,0.0054743,0.0062706,0.0062477,0.0046871,0.004832,0.0054597,0.0063062,0.0062441,0.0047,0.004824,0.0054585,0.0063229,0.0062683,0.0046967,0.004839,0.005465,0.006354,0.0062495,0.0046925,0.0048574,0.0054791,0.0063706,0.006254,0.0046692,0.0048524,0.0054603,0.0063954,0.0062721,0.0046839,0.0048864,0.0054766,0.0064106,0.0062563,0.0046625,0.0048656,0.0054563,0.0064161,0.0062569,0.0046964,0.0048722,0.0054679,0.006425,0.0062453,0.0047299,0.0048625,0.0054802,0.0064507,0.0062124,0.0047223,0.0048557,0.0055152,0.006474,0.0062278,0.0047342,0.0048448,0.0055282,0.0064772,0.0062025,0.0047553,0.0048601,0.0055696,0.0064761,0.0061996,0.0047709,0.0048468,0.0055828,0.0064971,0.0062122,0.0047746,0.0048573,0.0056034,0.0064972,0.0062433,0.0048185,0.0048623,0.0056204,0.0064983,0.0062602,0.0048524,0.0048559,0.0056857,0.0065248,0.0062748,0.0048777,0.0048959,0.0057258,0.0065355,0.0062874,0.0048771,0.0048857,0.005771,0.0065482,0.0063011,0.0048841,0.0049068,0.0058249,0.0065766,0.0063587,0.004906,0.0049462,0.0058245,0.0065764,0.0064185,0.0049097,0.0049584,0.0058273,0.0065665,0.0064377,0.0049111,0.0049834,0.0058374,0.0065998,0.0064717,0.004918,0.0050135,0.0058741,0.0065866,0.0065072,0.0049317,0.0050344,0.0059009,0.0066294,0.0065523,0.0049557,0.0051198,0.0059471,0.0067094,0.0066171,0.0049904,0.0051689,0.0059891,0.0067247,0.0066706,0.0050049,0.0052065,0.005988,0.0067554,0.0066905,0.0050139,0.0052461,0.0060234,0.0068065,0.006715,0.0050169,0.0052918,0.0060613,0.0068401,0.0067372,0.0050336,0.0053294,0.0060652,0.0068921,0.006782,0.005067,0.0053598,0.00609,0.0069483,0.0067736,0.0051096,0.0053785,0.0061064,0.0070406,0.0068244,0.0051153,0.0054157,0.0061547,0.0070872,0.0068286,0.005169,0.0054669,0.0061887,0.0071342,0.0068455,0.0052334,0.0054828,0.0062145,0.0071955,0.006868,0.0052829,0.0055129,0.0062838,0.0072313,0.0068789,0.0053443,0.0055375,0.0063482,0.0073244,0.0069011,0.0053947,0.0055643,0.0063777,0.0073995,0.0069577,0.0054479,0.0055875,0.0064453,0.0074187,0.0069639,0.005496,0.0055968,0.0065204,0.0074675,0.0069839,0.0055498,0.0056163,0.006602,0.0074813,0.0070113,0.0055862,0.005643,0.0066792,0.0074749,0.0070663,0.0056166,0.0056685,0.006745,0.0075229,0.007145,0.0056223,0.0056929,0.0067721,0.0075351,0.0072104,0.0056369,0.0057052,0.0068242,0.0075049,0.0072275,0.005635,0.0057426,0.006865,0.0074731,0.0072718,0.0056437,0.0057909,0.0068876,0.007496,0.0073439,0.005642,0.005865,0.0068741,0.0075176,0.0074315,0.0056556,0.0059219,0.0069066,0.0075469,0.0074954,0.0056475,0.0059805,0.0069512,0.0075839,0.0075197,0.0056593,0.0060268,0.006938,0.0076524,0.0075349,0.0056694,0.0060584,0.0052311:0
1.2267E-5,8.4833E-6,7.49E-6,8.0167E-6,1.1023E-5,1.252E-5,7.2667E-6,7.18E-6,6.1E-6,1.2263E-5,1.4607E-5,1.0157E-5,9.2367E-6,7.0333E-6,1.3547E-5,1.1913E-5,1.005E-5,1.0137E-5,7.8133E-6,1.1757E-5,1.3663E-5,1.0123E-5,7.5733E-6,7.2767E-6,1.3493E-5,9.89E-6,7.8267E-6,6.9E-6,9.15E-6,1.2113E-5,1.2633E-5,8.7267E-6,1.1053E-5,9.0333E-6,9.9533E-6,1.085E-5,8.02E-6,2.1143E-4,0.0017299,0.0018479,0.0021692,0.0020833,0.0017416,0.0015992,0.0018781,0.0021533,0.0020894,0.0017214,0.0016268,0.0018646,0.0021553,0.002098,0.0016988,0.0016378,0.0018562,0.0021521,0.0020873,0.0016926,0.001633,0.0018496,0.0021463,0.0020846,0.0016796,0.0016203,0.00184,0.0021444,0.0020743,0.0016706,0.0016206,0.0018463,0.0021317,0.0020637,0.0016684,0.0016124,0.0018332,0.0021217,0.0020533,0.0016533,0.0016079,0.0018241,0.0021105,0.0020389,0.0016447,0.0016061,0.0018214,0.0020973,0.002023,0.0016266,0.0015888,0.0018084,0.0020887,0.0020134,0.0016199,0.0015845,0.0018002,0.002073,0.0019895,0.0016072,0.0015719,0.001793,0.0020604,0.0019797,0.0015885,0.0015572,0.0017832,0.0020466,0.0019661,0.0015749,0.0015536,0.0017702,0.0020286,0.001948,0.0015561,0.0015366,0.0017549,0.0020113,0.0019251,0.0015393,0.0015217,0.0017364,0.0019896,0.0018983,0.0015173,0.0015072,0.0017202,0.0019642,0.0018684,0.0014939,0.0014892,0.0017051,0.0019373,0.0018432,0.0014745,0.0014674,0.0016881,0.0019119,0.0018156,0.0014478,0.0014488,0.0016589,0.0018844,0.0017848,0.0014265,0.0014243,0.0016464,0.0018492,0.0017565,0.0013995,0.0014085,0.0016146,0.0018277,0.0017198,0.0013817,0.0013811,0.0015924,0.0017985,0.0016944,0.0013522,0.001354,0.0015749,0.0017614,0.0016676,0.0013225,0.0013329,0.0015499,0.0017276,0.0016359,0.0012965,0.0013056,0.0015284,0.0017,0.0016028,0.0012788,0.0012837,0.0014954,0.0016718,0.0015639,0.0012525,0.001267,0.0014648,0.0016428,0.0015339,0.0012192,0.0012573,0.0014471,0.0016118,0.0015191,0.0011964,0.0012207,0.001434,0.0015926,0.0014799,0.0011846,0.0012176,0.001399,0.0015645,0.0014637,0.0011483,0.0011864,0.0013915,0.001536,0.0014236,0.0011388,0.0011831,0.001361,0.0015091,0.001419,0.001123,0.0011558,0.0013506,0.001497,0.0013868,0.0011039,0.0011554,0.0013388,0.0014687,0.0013761,0.0011053,0.0011349,0.0013116,0.00146,0.0013686,0.0010804,0.0011114,0.0013092,0.0014558,0.0013422,0.0010594,0.0011085,0.0013074,0.0014346,0.00132,0.0010579,0.0011136,0.0012913,0.0014077,0.0013154,0.0010607,0.0011023,0.0012717,0.0013996,0.0013172,0.0010513,0.0010815,0.0012612,0.0013998,0.0013098,0.0010319,0.0010686,0.0012641,0.0013979,0.0012913,0.0010192,0.0010722,0.0012649,0.0013866,0.0012797,0.0010156,0.0010739,0.001263,0.0013715,0.0012713,0.0010179,0.0010757,0.0012549,0.0013619,0.0012672,0.0010194,0.001072,0.0012459,0.0013595,0.0012667,0.0010157,0.0010654,0.0012391,0.0013572,0.0012615,0.0010109,0.0010629,0.0012343,0.0013513,0.0012572,0.0010099,0.001059,0.0012295,0.0013508,0.0012591,0.001006,0.0010505,0.0012296,0.0013541,0.001261,9.9554E-4,0.001045,0.0012313,0.0013597,0.0012487,9.9023E-4,0.0010435,0.0012398,0.0013551,0.0012443,9.8909E-4,0.0010487,0.0012392,0.0013527,0.0012425,9.8991E-4,0.0010514,0.0012367,0.0013505,0.0012395,9.8146E-4,0.0010463,0.0012366,0.0013498,0.0012336,9.8191E-4,0.0010487,0.0012411,0.0013477,0.0012276,9.8197E-4,0.0010541,0.0012399,0.0013363,0.0012272,9.8492E-4,0.0010555,0.0012351,0.0013337,0.0012271,9.8837E-4,0.0010551,0.0012355,0.0013352,0.0012278,9.8515E-4,0.0010541,0.001235,0.0013334,0.0012234,9.8471E-4,0.0010551,0.0012349,0.0013298,0.0012242,9.9125E-4,0.0010574,0.0012302,0.0013274,0.001228,9.9426E-4,0.0010552,0.0012312,0.0013305,0.0012329,9.8978E-4,0.0010472,0.0012276,0.0013358,0.001228,9.8615E-4,0.0010527,0.0012295,0.001334,0.0012279,9.9092E-4,0.0010517,0.0012253,0.0013318,0.0012348,9.9024E-4,0.0010468,0.0012247,0.0013346,0.0012356,9.8695E-4,0.0010414,0.0012278,0.0013404,0.0012308,9.8067E-4,0.0010447,0.0012327,0.0013377,0.0012291,9.8097E-4,0.0010472,0.0012324,0.0013407,0.0012267,9.7705E-4,0.0010441,0.0012349,0.0013385,0.0012263,9.7463E-4,0.0010412,0.0012368,0.0013436,0.001221,9.6993E-4,0.0010441,0.0012438,0.0013432,0.0012159,9.7137E-4,0.0010466,0.0012427,0.0013374,0.0012139,9.7782E-4,0.0010493,0.0012421,0.0013379,0.0012152,9.7319E-4,0.0010486,0.0012451,0.0013386,0.001212,9.6984E-4,0.0010509,0.0012486,0.0013352,0.0012103,9.7117E-4,0.0010566,0.0012495,0.0013347,0.0012056,9.7452E-4,0.0010582,0.0012454,0.0013335,0.0012117,9.7692E-4,0.0010556,0.0012449,0.0013355,0.0012111,9.7303E-4,0.0010576,0.0012463,0.0013328,0.0012053,9.7229E-4,0.0010653,0.0012449,0.0013261,0.0012062,9.7654E-4,3.6147E-4:0
0.047462,0.083024,0.031024,0.10835,0.084727,0.042592,0.071548,0.030436,0.10556,0.087468,0.043753,0.069151,0.028042,0.10289,0.087641,0.040373,0.075948,0.028911,0.11018,0.082957,0.044935,0.084318,0.029303,0.11116,0.092619,0.041893,1.1689,14.272,15.415,17.922,17.837,15.126,13.065,15.481,18.019,18.014,14.903,13.274,15.38,17.964,17.953,14.76,13.347,15.4,18.094,18.006,14.692,13.308,15.377,18.052,17.99,14.663,13.354,15.364,18.015,17.923,14.631,13.367,15.405,18.016,17.862,14.569,13.348,15.396,18.003,17.818,14.49,13.291,15.385,18.019,17.749,14.38,13.276,15.442,18.025,17.63,14.366,13.309,15.443,17.967,17.638,14.31,13.244,15.431,17.946,17.5,14.249,13.254,15.393,17.926,17.451,14.127,13.24,15.415,17.88,17.428,14.069,13.21,15.431,17.866,17.357,13.991,13.207,15.399,17.834,17.227,13.921,13.169,15.353,17.803,17.104,13.873,13.096,15.353,17.716,17.017,13.742,13.066,15.338,17.633,16.874,13.677,12.995,15.308,17.528,16.763,13.53,12.962,15.228,17.446,16.624,13.418,12.895,15.183,17.368,16.489,13.285,12.84,15.105,17.231,16.296,13.135,12.739,15.005,17.077,16.093,12.969,12.631,14.891,16.902,15.864,12.816,12.509,14.737,16.732,15.609,12.594,12.378,14.595,16.517,15.343,12.428,12.216,14.409,16.256,15.068,12.21,12.03,14.23,15.96,14.754,11.971,11.804,13.993,15.681,14.41,11.692,11.594,13.737,15.333,14.051,11.373,11.388,13.412,14.933,13.726,11.058,11.067,13.114,14.554,13.255,10.738,10.821,12.716,14.127,12.895,10.425,10.459,12.313,13.741,0.0:0
0.095032,0.060171,0.10102,0.068422,0.021693,0.097898,0.055598,0.098695,0.068131,0.020734,0.095773,0.057852,0.096176,0.073544,0.012988,0.095748,0.061998,0.097303,0.06805,0.017265,0.096996,0.060417,0.099332,0.07051,0.020901,0.097005,0.061499,0.096446,0.07503,0.020728,0.092967,0.05944,0.098914,0.067709,0.020213,0.095247,0.060402,0.097177,0.070135,0.026733,0.099668,0.0545,0.10394,0.064536,0.022233,0.10015,0.060237,0.09921,0.071833,0.018042,0.092984,0.061303,0.10283,0.072548,0.024534,0.090725,0.058871,0.10066,0.067695,0.023284,0.088942,0.062344,0.10043,0.060266,0.025497,0.094893,0.059341,0.09583,0.072972,0.024633,0.099045,0.06094,0.099028,0.064018,0.024241,0.097396,0.057631,0.094535,0.072531,0.021853,0.095157,0.060781,0.096706,0.066009,0.025195,14.286,15.949,18.098,17.501,15.013,12.944,15.866,18.15,17.776,14.675,13.272,15.637,18.129,17.83,14.559,13.389,15.658,18.115,17.761,14.47,13.407,15.664,18.087,17.703,14.417,13.384,15.664,18.072,17.683,14.381,13.381,15.639,18.045,17.68,14.34,13.352,15.604,18.083,17.646,14.232,13.333,15.664,18.087,17.552,14.229,13.367,15.601,18.062,17.53,14.133,13.312,15.629,18.004,17.427,14.113,13.256,15.584,18.004,17.311,14.051,13.236,15.572,17.962,17.233,13.985,13.193,15.558,17.88,17.154,13.9,13.155,15.572,17.819,17.105,13.798,13.146,15.538,17.751,16.996,13.708,13.121,15.445,17.676,16.874,13.623,13.06,15.417,17.595,16.742,13.521,12.992,15.351,17.486,16.612,13.39,12.938,15.269,17.386,16.437,13.271,12.85,15.184,17.244,16.261,13.138,12.75,15.089,17.129,16.034,12.988,12.63,14.945,16.934,15.834,12.792,12.502,14.817,16.681,15.561,12.596,12.336,14.622,16.41,15.319,12.347,12.16,14.382,16.146,14.979,12.073,11.959,14.108,15.818,14.636,11.78,11.708,13.806,15.421,14.253,11.458,11.426,13.494,15.049,13.799,11.17,11.137,13.078,14.632,13.387,10.757,10.798,12.739,14.161,12.904,10.421,10.486,12.287,13.663,12.452,10.063,10.106,11.825,13.012,11.776,9.5716,9.6763,11.298,12.626,11.473,9.2097,9.2919,10.843,12.133,11.043,8.863,8.9954,10.479,11.776,10.693,8.5535,8.6919,10.153,11.517,10.438,8.325,8.4302,9.8245,11.238,10.148,8.1206,8.2334,9.6012,11.006,9.9186,7.9363,8.0377,9.4087,10.84,9.7893,7.8432,7.9439,9.3058,10.704,9.6493,7.7215,7.8316,9.1946,10.623,9.5707,7.6554,7.7453,9.0855,10.522,9.4424,7.5577,7.6969,9.0377,10.485,9.417,7.5207,7.651,8.9787,10.427,9.3126,7.4575,7.632,8.9645,10.434,9.2952,7.4506,7.6063,8.932,10.387,9.2227,7.4103,0.0:0
0.035439,0.10457,0.086433,0.056665,0.07519,0.026642,0.11222,0.087376,0.046184,0.076423,0.032551,0.10995,0.099163,0.053671,0.074448,0.034849,0.11056,0.092055,0.049161,0.07993,0.028861,0.10444,0.095216,0.05123,0.0781,0.07134,16.046,18.178,18.808,14.418,14.053,14.604,17.976,18.422,14.882,13.609,15.018,17.973,18.294,14.981,13.386,15.075,17.931,18.289,15.041,13.378,15.099,17.911,18.226,15.051,13.387,15.164,17.882,18.18,14.982,13.367,15.169,17.884,18.149,14.923,13.338,15.148,17.878,18.074,14.744,13.197,15.052,17.798,17.906,14.654,13.224,15.073,17.707,17.866,14.643,13.172,15.029,17.775,17.8,14.551,13.195,15.059,17.698,17.791,14.513,13.158,15.109,17.725,17.757,14.512,13.154,15.16,17.731,17.711,14.458,13.132,15.16,17.698,17.64,14.346,13.101,15.12,17.605,17.577,14.239,13.1,15.04,17.612,17.459,14.185,13.029,15.029,17.533,17.351,14.047,13.009,14.929,17.333,16.936,13.828,12.779,14.859,17.295,16.934,13.733,12.703,14.741,17.118,16.78,13.624,12.636,14.678,16.999,16.588,13.474,12.532,14.588,16.846,16.407,13.301,12.435,14.469,16.67,16.22,13.096,12.309,14.326,16.457,15.963,12.906,12.156,14.14,16.226,15.725,12.654,11.991,13.943,15.992,15.418,12.396,11.802,13.691,15.712,15.079,12.105,11.569,13.445,15.346,14.708,11.805,11.281,13.158,14.985,14.269,11.514,10.989,12.793,14.597,13.857,11.105,10.683,12.474,14.108,13.38,10.753,10.356,12.024,13.627,12.97,10.398,9.9814,11.595,13.179,12.531,9.9806,9.613,11.165,12.721,12.048,9.5899,9.2595,10.723,12.255,11.62,9.239,8.9365,10.329,11.84,11.209,8.9233,8.6519,10.004,11.498,10.857,8.6256,8.3654,9.7087,11.227,10.611,8.4125,8.1262,9.4186,10.955,10.375,8.2332,7.9793,9.2425,10.772,10.178,8.0423,7.8153,9.0675,10.629,10.057,7.9632,7.7415,8.9612,10.531,9.9263,7.8435,7.6493,8.867,10.468,9.8537,7.8077,7.6088,8.8141,10.421,9.7554,7.7222,7.5362,8.7723,10.398,9.726,7.7175,7.5364,8.7513,10.362,9.656,7.6728,7.4889,8.7441,10.343,9.648,7.6639,7.4966,8.7644,10.335,9.6137,7.6308,7.4689,8.7283,10.291,9.5774,7.6048,7.4865,8.7363,10.299,9.552,7.5795,7.4509,8.7109,10.281,9.5065,7.5551,7.4815,8.7304,10.311,9.5041,7.5605,7.4741,8.7243,10.324,9.4622,7.5405,7.4835,8.757,10.34,9.4577,7.5537,7.4882,8.7689,10.331,9.4121,7.5238,7.4841,8.8078,10.348,9.4204,7.5382,7.5004,8.8119,10.335,9.3765,7.4973,7.4943,8.8243,10.346,9.3705,7.5133,7.5069,8.8376,10.359,9.3602,7.4839,7.5043,8.8315,10.357,9.3338,7.481,7.5292,8.8536,10.39,9.3453,7.4812,7.5255,8.8675,10.383,9.2847,7.4813,7.5473,8.8912,10.397,9.2955,7.4677,7.5342,8.8853,10.373,9.2391,7.4617,7.545,8.9269,10.425,9.2604,7.4734,7.5586,8.9197,10.387,9.211,7.4401,7.5576,8.9254,10.383,9.207,7.4494,7.5659,8.95,10.399,9.1752,7.4144,7.5516,8.9498,10.412,9.1657,7.4416,7.5962,8.9763,10.431,9.1365,7.406,7.5601,8.9628,10.402,9.1059,7.4072,7.5982,9.006,10.437,9.116,7.4107,7.5846,9.0062,10.416,9.0745,7.401,7.5886,9.0304,10.441,9.0852,7.4101,7.5949,9.0325,10.41,9.0439,7.3919,7.6015,9.0399,10.429,9.0453,7.409,7.6229,9.0699,10.436,8.9964,7.3796,7.6207,9.0813,10.441,9.002,7.4007,7.6499,9.1014,10.425,8.9606,7.3694,7.6287,9.1058,10.418,8.9425,7.3637,7.6585,9.1299,10.437,8.9476,7.3568,7.6475,9.1204,10.43,8.9051,7.3586,7.6733,9.1609,10.465,8.9082,7.3552,7.68,6.8224:0
0.013197,-0.018542,0.0069523,-0.0056373,-0.01314,0.017906,-0.015586,0.016323,0.0051113,-0.0078274,0.011902,-0.015056,0.0097365,0.0053596,-0.012741,0.012263,-0.017674,0.013124,0.0058697,-0.0097025,0.010969,-0.014156,0.016138,-2.0551E-4,-0.011777,0.012911,-0.013765,139.91,282.09,273.31,217.44,204.28,233.34,281.65,272.31,217.99,203.47,233.4,281.15,271.96,218.29,202.8,233.14,280.97,271.59,218.25,202.38,232.81,280.03,271.25,218.18,201.8,232.16,279.51,270.61,217.92,201.49,231.91,279.02,270.53,217.98,201.21,231.44,278.85,270.41,217.92,201.1,231.11,278.27,270.28,217.97,200.91,230.89,278.41,271.23,219.11,202.19,231.52,278.96,270.76,218.86,201.55,231.06,279.22,272.33,219.39,201.97,231.11,279.39,272.67,219.71,201.92,230.82,279.39,272.63,219.78,201.89,230.59,279.23,272.8,219.88,201.68,230.42,278.92,272.45,219.61,201.64,230.11,278.76,272.88,220.06,201.44,229.95,278.79,272.99,220.08,201.45,229.79,278.28,272.28,219.61,200.59,228.75,276.8,270.95,218.95,199.92,228.14,275.96,270.56,218.86,199.91,227.96,276.29,271.67,219.72,200.72,228.31,277.13,272.81,220.17,200.94,228.23,277.29,273.01,220.36,201.17,228.39,277.12,273.11,220.46,200.78,227.85,276.74,272.69,220.3,200.51,227.36,276.63,272.78,220.48,200.48,226.89,276.46,272.71,220.43,200.47,226.96,275.92,272.34,220.28,199.96,226.47,275.54,271.96,220.17,199.83,226.07,274.8,271.71,219.94,199.24,225.48,274.36,271.41,219.9,199.18,225.33,273.9,271.33,219.96,198.97,224.9,273.56,271.19,219.9,198.76,224.57,272.92,271.13,0.0:0
-0.021705,0.017639,-0.011828,0.010018,0.0060137,-0.02004,0.022231,-0.0097513,0.0073241,0.0089191,-0.018628,0.018698,-0.016579,0.00821,0.013191,-0.019628,0.017599,-0.017133,0.0094121,0.0079972,-0.012599,0.021785,-0.012641,-3.6522E-4,0.0037401,-0.019002,0.022228,-0.014008,0.0039924,0.0024188,-0.023992,0.019213,-0.010021,0.0021779,4.1236,5.4161,4.297,5.601,6.155,6.053,5.0905,4.5946,5.4157,6.1862,6.1279,5.0415,4.685,5.382,6.2025,6.1575,5.0597,4.6865,5.4081,6.2008,6.1639,5.0542,4.675,5.3885,6.2126,6.1724,5.0664,4.6525,5.3628,6.1829,6.1735,5.0699,4.6577,5.3427,6.1793,6.1788,5.0757,4.6592,5.3269,6.1815,6.1865,5.0943,4.6705,5.3188,6.1971,6.1993,5.1033,4.663,5.3223,6.1953,6.2067,5.1167,4.662,5.3156,6.1682,6.2048,5.122,4.6539,5.3063,6.1574,6.1944,5.1186,4.6332,5.2859,6.1406,6.202,5.1207,4.6455,5.2854,6.1326,6.2097,5.1525,4.6666,5.2764,6.1504,6.2341,5.1677,4.649,5.2616,6.1429,6.2183,5.1669,4.6311,5.2661,6.1237,6.2076,5.1632,4.6325,5.2329,6.1184,6.2268,5.1933,4.6428,5.2266,6.1212,6.2332,5.1892,4.6437,5.2375,6.1105,6.2376,5.2045,4.6334,5.2079,6.0786,6.2137,5.1918,4.6137,5.1868,6.0834,6.2438,5.2218,4.6338,5.1786,6.0819,6.2407,5.2376,4.6391,5.1912,6.059,6.2527,5.2535,4.6306,5.168,6.0423,6.2147,5.2348,4.622,5.1401,6.0601,6.2436,5.245,4.6119,5.1589,6.0541,6.2626,5.2708,4.6331,5.1386,6.0333,6.2454,5.2581,4.6081,5.1205,6.007,6.2344,5.2692,4.6063,5.1156,6.0436,6.2337,5.2889,4.6189,5.1007,6.0262,6.2521,5.2899,4.5973,5.1004,5.9855,6.2532,5.2792,4.6028,5.082,5.9979,6.2552,5.3194,4.6109,5.0882,5.9867,6.272,5.3085,4.6076,5.0479,5.9717,6.2234,5.3184,4.5887,5.0387,5.9721,6.2475,5.3387,4.6072,5.0496,5.9853,6.238,5.3401,4.5945,5.0119,5.9605,6.2203,5.3269,4.6076,5.0116,5.9591,6.2508,5.362,4.6181,5.0272,5.9418,6.2248,5.3635,4.6073,4.9834,5.9149,6.2421,5.3786,4.5965,4.9871,5.9269,6.2688,5.3889,4.6034,4.9791,5.9224,6.2166,5.3778,4.5943,4.9651,5.8929,6.2315,5.4225,4.6073,4.9559,5.8997,6.2566,5.4185,4.5967,4.9435,5.8748,6.2193,5.4119,4.603,4.9341,5.8637,6.2582,5.4361,4.6105,4.927,5.8835,6.2065,5.4227,4.6012,4.9175,5.84,6.238,5.4405,4.6017,4.9017,5.8699,6.2188,5.4459,4.6056,4.8865,5.8164,6.2348,5.4598,4.6017,4.8897,5.8411,6.2141,5.4875,4.6071,4.8564,5.7997,6.2088,5.4741,4.5989,4.8718,5.7903,6.2269,5.4879,4.6061,4.8489,5.7869,6.1779,5.485,4.598,4.8335,5.7934,6.196,5.4988,4.6081,4.8305,5.7588,6.1992,5.4811,4.5943,4.8092,5.7466,6.2046,5.5115,4.5991,4.8171,5.7354,6.1834,5.5167,4.5927,4.7831,5.7229,6.1722,5.5271,4.5994,4.791,5.7268,6.1727,5.5371,4.5898,4.7529,5.715,6.1492,5.5539,4.6074,4.769,5.7118,6.1521,5.5435,4.5927,4.7337,5.6875,6.1347,5.5486,4.6073,4.7379,5.6904,6.1302,5.5634,4.5859,4.7139,5.657,6.1264,5.5578,4.6019,4.7175,5.6367,6.1233,5.5613,4.5814,4.6879,5.6088,6.1332,5.5505,4.5895,4.6964,5.6022,6.1057,5.5667,4.5812,4.6742,5.5732,6.1193,5.5643,4.5977,4.6559,5.5737,6.0806,5.5641,4.5737,4.6468,5.5582,6.0794,5.5855,4.5911,4.643,5.5305,6.0711,5.5754,4.5778,4.6308,5.5362,6.0756,5.5806,4.5825,4.6092,5.5145,6.039,5.586,4.5754,4.6038,5.4926,6.0668,5.5828,4.5785,4.5873,5.4771,6.0307,5.5907,4.5794,4.5825,5.4752,6.0084,5.5658,4.568,4.5606,5.4514,6.008,5.5843,4.5786,4.5492,5.4319,5.9831,5.5751,4.564,4.5457,5.4204,5.9872,5.5889,4.5698,4.5188,5.3828,5.9748,5.5794,4.5692,4.5219,5.4027,5.9542,5.5914,4.5528,4.4996,5.3476,5.9648,5.5757,4.5663,4.4937,5.3632,5.9299,5.5691,4.5518,4.4837,5.3412,5.9238,5.5823,3.0337:0
-0.0030131,-0.0073996,0.012573,-0.020778,0.01862,-0.013225,0.0023813,0.0064792,-0.021954,0.015941,-0.0027859,-4.9427E-5,0.0049705,-0.015423,0.016729,-0.0086861,0.0025804,0.012979,-0.012811,0.021004,-0.011325,0.0020091,0.0093453,-0.018096,0.019601,-0.012016,-0.0011631,0.0082361,-0.014519,0.011881,-0.0056864,0.0016273,0.008637,-0.014569,0.022267,-0.0034189,127.72,278.14,212.69,206.93,236.32,280.34,271.98,214.85,203.72,235.78,279.75,270.71,216.44,202.09,235.63,279.3,270.04,217.47,200.8,234.86,279.13,269.99,218.26,200.24,234.47,278.52,269.89,218.96,199.72,233.67,278.16,270.14,219.33,199.37,233.01,277.59,270.43,220.01,198.99,232.4,277.19,270.48,220.33,198.82,231.65,276.43,270.82,220.84,198.52,230.88,276.2,271.19,221.24,198.51,230.46,275.72,271.65,221.85,198.42,230.02,275.71,272.71,222.59,198.85,229.89,275.85,273.87,223.78,199.31,229.49,275.94,274.73,224.4,199.49,229.14,275.95,275.45,225.09,199.37,228.55,275.4,275.63,225.43,199.37,228.02,274.86,275.97,225.87,199.07,227.35,274.34,276.13,226.17,199.03,226.69,273.65,276.32,226.66,198.84,225.99,273.07,276.35,226.75,198.46,225.2,272.03,275.58,226.65,197.84,224.01,270.94,275.31,226.58,197.61,223.24,269.97,275.24,227.02,197.25,222.46,269.61,275.9,227.87,198.06,222.76,270.11,278.07,228.88,197.51,221.5,268.81,276.74,228.92,197.81,221.58,268.76,277.78,230.22,198.53,221.47,269.22,279.0,230.97,198.8,221.12,268.3,277.79,230.38,197.57,219.56,266.88,277.27,230.51,197.39,218.85,265.93,277.52,231.52,197.89,219.03,266.53,279.51,232.93,198.66,0.0:0
-0.022781,0.015506,0.0096779,-0.018395,0.032044,-0.024831,0.017295,0.0074809,-0.0069803,0.024136,-0.019435,0.020626,0.0076291,-0.016613,0.025019,-0.019228,0.020283,0.0055659,-0.009347,0.021493,-0.013146,28.576,282.57,264.39,220.22,204.91,249.9,292.29,266.27,217.69,206.8,248.42,291.41,266.88,216.03,207.47,247.74,290.6,266.63,214.87,207.53,247.14,289.99,266.37,214.29,207.55,246.89,289.54,266.07,213.75,207.4,246.61,289.19,265.76,213.44,207.36,246.54,288.95,265.54,213.28,207.36,246.56,288.98,265.95,213.63,207.91,246.93,289.87,266.64,213.9,208.16,246.98,290.09,266.6,213.81,208.15,247.05,290.04,266.51,213.66,208.18,247.04,289.77,266.2,213.48,208.07,246.98,289.64,265.94,213.15,207.81,246.83,289.18,265.36,212.85,207.62,246.71,288.79,264.81,212.55,207.32,246.44,288.35,264.27,212.15,207.14,246.3,288.13,263.98,211.92,206.93,246.17,287.75,263.57,211.61,206.8,246.08,287.52,263.24,211.34,206.6,245.99,287.19,262.93,211.15,206.52,245.88,287.06,262.74,210.94,206.44,245.87,287.01,262.81,211.13,206.79,246.14,287.76,263.54,211.71,207.34,246.56,288.36,263.75,211.74,207.31,246.5,288.23,263.68,211.57,207.16,246.39,287.98,263.4,211.38,207.09,246.28,287.87,263.3,211.27,207.08,246.37,287.82,263.05,211.08,206.96,246.2,287.51,262.82,210.86,206.78,246.07,287.19,262.38,210.61,206.51,245.85,286.7,261.83,210.23,206.25,245.63,286.41,261.51,210.01,206.09,245.5,286.2,261.17,209.81,205.91,245.39,285.93,260.81,209.71,205.73,245.23,285.53,260.38,209.34,0.0:0
0.01867,0.0038099,-0.016373,0.03103,-0.030079,0.022798,-0.0049294,-0.015971,0.028284,-0.021217,0.020703,0.0052554,-0.01078,0.019901,-0.023572,0.024504,-0.0045886,-0.010111,0.021998,-0.025098,0.023417,-0.0040139,-0.020294,0.022188,-0.023567,0.021438,-0.0013458,-0.018782,0.02446,-0.03148,0.021661,-0.0055803,188.52,242.33,195.64,232.94,279.43,280.11,235.71,199.57,228.82,278.32,281.15,233.25,201.39,226.71,277.47,281.71,232.13,202.12,225.4,276.69,281.83,231.66,202.41,224.4,275.9,281.83,231.39,202.38,223.4,275.08,281.77,231.39,202.46,222.75,274.49,281.84,231.36,202.32,222.01,273.68,281.84,231.71,202.39,221.49,273.25,282.15,232.12,202.51,221.05,272.84,282.7,232.91,203.0,221.08,272.95,284.1,234.09,203.62,221.08,272.88,284.67,234.54,203.6,220.54,272.18,284.7,234.89,203.61,219.95,271.69,284.94,235.26,203.62,219.43,271.14,285.07,235.68,203.63,218.93,270.64,285.1,236.19,203.65,218.49,270.23,285.29,236.58,203.63,217.96,269.62,285.22,237.07,203.66,217.49,269.16,285.25,237.48,203.64,217.0,268.55,285.39,237.91,203.6,216.53,267.97,285.38,238.33,203.63,216.06,267.35,285.16,238.63,203.39,215.33,266.47,284.49,238.62,203.07,214.53,265.75,284.05,238.8,202.89,213.9,264.91,283.83,239.1,202.88,213.33,264.22,283.71,239.23,202.76,212.76,263.62,283.63,239.65,202.81,212.29,263.04,283.66,240.1,202.9,211.88,262.47,283.6,240.75,203.24,211.85,262.38,284.72,242.06,203.95,212.02,262.27,285.33,242.94,204.31,211.79,261.87,285.63,243.56,204.52,211.49,261.47,285.81,244.1,204.68,0.0:0
2.6169,2.5294,2.0708,1.8942,2.2564,2.613,2.5334,2.0759,1.8944,2.2564,2.611,2.5286,2.0739,1.8935,2.2544,2.6088,2.5296,2.0732,1.8925,2.2511,2.606,2.5338,2.0794,1.8915,2.2456,2.6024,2.5348,2.0805,1.8903,2.2434,2.6009,2.535,2.0809,1.8873,2.2377,2.5942,2.5325,2.0797,1.8871,2.2357,2.5954,2.5358,2.0843,1.8857,2.2307,2.5955,2.5362,2.0774,1.8829,2.2265,2.5869,2.5321,2.0768,1.8768,2.2198,2.5785,2.5301,2.0773,1.8742,2.2171,2.5785,2.528,2.0761,1.8718,2.2109,2.5716,2.5265,2.0737,1.8677,2.2031,2.5622,2.524,2.0737,1.8652,2.1989,2.5589,2.5208,2.0761,1.8608,2.1988,2.5542,2.5228,2.0733,1.8574,2.1932,2.5506,2.517,2.073,1.8567,2.189,2.5436,2.517,2.0717,1.8545,2.1794,2.5393,2.5101,2.0638,1.848,2.1731,2.5333,2.5027,2.0591,1.8447,2.1643,2.5224,2.4971,2.0551,1.8387,2.156,2.516,2.4936,2.0505,1.8361,2.1488,2.5076,2.4814,2.0409,1.8278,2.1382,2.4959,2.4712,2.035,1.8199,2.1279,2.4838,2.4632,2.0281,1.8111,2.1158,2.4691,2.4499,2.0182,1.8006,2.1048,2.452,2.4324,2.0103,1.7899,2.0931,2.4379,2.4242,1.9975,1.7792,2.0768,2.4208,2.41,1.985,1.7665,2.0624,2.4025,2.3891,1.9693,1.756,2.0446,2.383,2.3691,1.9507,1.7393,2.0226,2.3587,2.3449,1.9333,1.725,2.0009,2.3326,2.3241,1.9143,1.7023,1.9804,2.3065,2.2945,1.892,1.6858,1.9545,2.2773,2.2684,1.87,1.6605,1.9289,2.2442,2.2364,1.8439,1.6378,1.8958,2.2108,2.2042,1.8139,1.6129,1.8645,2.171,2.1692,1.7818,1.5866,1.833,2.1342,2.1309,1.7567,1.5591,1.8012,2.0956,2.0976,1.7271,1.5293,1.7658,2.055,2.0606,1.6946,1.5035,1.7289,2.0139,2.0217,1.664,1.472,1.6916,1.9737,1.9888,1.6323,1.4464,1.6549,1.9353,1.9538,1.6044,1.418,1.6235,1.9004,1.9226,1.5799,1.3915,1.5963,1.8683,1.8942,1.5565,1.3685,1.5648,1.8371,1.8694,1.5333,1.3512,1.5398,1.8114,1.85,1.5171,1.3321,1.5178,1.7905,1.8324,1.5044,1.3212,1.5001,1.7733,1.8167,1.4955,1.3084,1.4869,1.756,1.8089,1.487,1.3006,1.4718,1.7431,1.7992,1.4807,1.2951,1.4617,1.7331,1.7936,1.4747,1.2891,1.4537,1.7238,1.7919,1.4737,1.2845,1.4467,1.7189,1.7869,1.4711,1.2805,1.4399,1.7127,1.784,1.4703,1.2797,1.4337,1.7062,1.7841,1.4727,1.2784,1.4328,1.703,1.7818,1.4732,1.2764,1.4268,1.6999,1.7842,1.4752,1.2749,1.4263,1.6981,1.7835,1.4787,1.2741,1.4238,1.6948,1.7818,1.4771,1.2716,1.4188,1.686,1.7765,1.4778,1.2708,1.4112,1.6825,1.7772,1.4758,1.2719,1.4102,1.6829,1.7778,1.4761,1.2669,1.4059,1.6741,1.7768,1.4776,1.2667,1.4028,1.6736,1.7745,1.4785,1.2656,1.3992,1.67,1.7766,1.4821,1.2659,1.3997,1.6686,1.7736,1.4816,1.2648,1.3983,1.664,1.7757,1.4844,1.266,1.3973,1.6653,1.7767,1.4862,0.13131:0
-0.0035016,-5.1056E-4,0.0066826,6.4636E-4,0.010768,-0.0038011,-0.0031795,0.0049388,6.4256E-4,0.0099443,2.5728,2.1134,1.8985,2.2117,2.5913,2.5743,2.1178,1.8957,2.2026,2.5887,2.5811,2.1204,1.8947,2.1962,2.5792,2.5784,2.1238,1.8885,2.1884,2.5724,2.5788,2.1281,1.8877,2.1778,2.561,2.5807,2.131,1.8803,2.169,2.5527,2.5818,2.1332,1.8767,2.1604,2.5477,2.5812,2.1374,1.8752,2.1546,2.543,2.5834,2.1405,1.8745,2.1463,2.5303,2.5845,2.1449,1.8732,2.1385,2.5277,2.5872,2.1484,1.8696,2.1304,2.5213,2.5839,2.1515,1.8681,2.1218,2.5141,2.5834,2.1514,1.8637,2.1112,2.5007,2.5776,2.1496,1.8602,2.0966,2.4904,2.5736,2.1477,1.8559,2.0889,2.4799,2.5675,2.1491,1.8513,2.0777,2.4699,2.5645,2.1507,1.8459,2.0678,2.4557,2.5582,2.1493,1.8416,2.0576,2.4462,2.5533,2.1429,1.8355,2.0453,2.433,2.5411,2.1404,1.828,2.0319,2.4192,2.5336,2.1393,1.8243,2.0185,2.4013,2.525,2.1318,1.8156,2.0078,2.3886,2.5112,2.1262,1.8069,1.991,2.3692,2.4976,2.1205,1.7966,1.9768,2.3508,2.4842,2.1111,1.785,1.9621,2.3335,2.4689,2.0996,1.7752,1.9451,2.3136,2.4524,2.0917,1.7636,1.9242,2.2927,2.4316,2.0781,1.7495,1.9066,2.2669,2.4126,2.0627,1.7357,1.8838,2.2387,2.3882,2.0429,1.7135,1.8579,2.2082,2.3598,2.0241,1.6957,1.8331,2.1787,2.3296,2.0042,1.6738,1.8075,2.1474,2.304,1.9798,1.6539,1.7772,2.1077,2.2675,1.9518,1.6292,1.7432,2.0686,2.2332,1.9222,1.5995,1.7083,2.0273,2.1915,1.8945,1.5709,1.6781,1.9848,2.156,1.8633,1.5414,1.6428,1.9417,2.1145,1.8305,1.5128,1.6068,1.8971,2.077,1.8019,1.4864,1.5698,1.8553,2.0406,1.7729,1.461,1.5365,1.8148,2.0033,1.745,1.4363,1.509,1.7782,1.9704,1.7226,1.4118,1.4802,1.741,1.9402,1.6981,1.3944,1.4527,1.7117,1.9163,1.6834,1.3776,1.4286,1.6838,1.8949,1.6724,1.3629,1.4097,1.6602,1.8762,1.6598,1.3534,1.3955,1.6428,1.8619,1.6497,1.3428,1.3822,1.6259,1.8507,1.6451,1.3375,1.3689,1.6127,1.8409,1.6418,1.3336,1.3599,1.6029,1.8336,1.6409,1.3316,1.3566,1.5923,1.8262,1.6434,1.3288,1.3494,1.5807,1.8233,1.6459,1.3311,1.346,1.5797,1.8205,1.6451,1.33,1.3421,1.5676,1.8185,1.6501,1.3294,1.3361,1.5616,1.8124,1.6497,1.3303,1.3318,1.5572,1.8088,1.6528,1.3312,1.3302,1.5503,1.8103,1.657,1.3337,1.3292,1.549,1.8084,1.6617,1.3364,1.3259,1.5449,0.0:0
0.0057895,0.014743,-0.001942,0.0011603,0.0055604,0.0049543,0.012848,-0.0011423,0.0014961,0.0063833,0.0046966,0.014757,-0.002961,3.5874E-5,0.0066459,0.0061817,0.013652,-0.0012485,-0.0012602,0.0063156,0.0041432,0.013767,-0.0012979,8.1919E-5,0.0054128,0.0043358,0.014243,1.0561E-4,-4.5531E-4,0.0068015,0.004056,0.011795,-0.0019832,-0.001555,0.0060588,0.0056213,0.013291,-8.2317E-4,0.0013525,0.0048092,0.0051722,0.012928,-3.5879E-4,-5.7389E-4,0.0063535,0.0035223,0.014828,-2.8676E-4,0.0019101,0.0060925,0.0055524,0.01285,-0.0022132,-5.7939E-4,0.0049942,0.0056123,0.012872,-0.0015555,-0.0011002,0.005039,0.0045915,0.01364,-2.6015E-4,-4.1107E-4,0.0058318,0.0046823,0.013502,0.0011265,-7.4269E-4,0.0051928,0.0046138,0.01323,-9.6031E-4,3.1662E-4,0.0052433,0.0044387,0.012741,9.5201E-4,-0.0021117,0.0055053,0.0035771,0.012745,-1.7858E-5,-0.0011801,0.0058413,0.0035495,0.011604,3.4189E-4,-0.0023205,0.0059737,0.0055822,0.01233,3.0433E-4,-0.0028169,0.0048332,0.0032561,0.011797,0.0015676,-6.4661E-4,0.0041429,0.0032486,0.011468,0.0011499,1.2512E-4,0.0058091,0.0040919,0.011759,0.0026488,-0.0014331,0.0044196,0.0051331,0.011843,6.3977E-4,-0.0012719,0.0063829,0.0036119,0.0094398,0.0015147,-9.9487E-4,0.0054728,0.003272,0.01175,0.0015951,-9.069E-4,0.0052958,0.0053299,0.010955,0.0017856,-9.434E-4,0.0045184,0.18727,2.7074,2.6018,2.3454,1.8242,2.1012,2.4695,2.6231,2.2632,1.9027,2.0496,2.4926,2.6325,2.2529,1.9201,2.0356,2.4928,2.6359,2.2542,1.9256,2.032,2.4863,2.6359,2.2554,1.9267,2.0291,2.4871,2.6355,2.2613,1.9265,2.0242,2.4806,2.6361,2.2638,1.9259,2.0186,2.4693,2.6348,2.2646,1.9243,2.0139,2.4657,2.6315,2.267,1.9232,2.008,2.4617,2.6314,2.2683,1.9232,2.0053,2.4571,2.6314,2.2712,1.9249,2.001,2.4511,2.6294,2.2732,1.9219,1.9943,2.4476,2.6259,2.2737,1.9217,1.9904,2.4406,2.6262,2.275,1.9199,1.9854,2.4317,2.6226,2.2794,1.92,1.9817,2.4304,2.6186,2.2782,1.9194,1.9766,2.4217,2.6157,2.278,1.9171,1.9729,2.4165,2.6131,2.2786,1.9156,1.9658,2.4106,2.6085,2.2789,1.9148,1.9585,2.4026,2.6058,2.2756,1.9149,1.954,2.395,2.5988,2.2703,1.9091,1.9476,2.387,2.5952,2.269,1.9062,1.9405,2.3768,2.5885,2.2679,1.9023,1.9345,2.3697,2.58,2.2666,1.9007,1.9293,2.3594,2.5737,2.2631,1.8934,1.9224,2.3508,2.5639,2.2615,1.8889,1.9138,2.3435,2.557,2.2563,1.885,1.9076,2.3314,2.5461,2.2482,1.8794,1.8976,2.3183,2.5359,2.2421,1.8752,1.89,2.3051,2.5252,2.2369,1.8643,1.8788,2.2922,2.5139,2.2305,1.8565,1.869,2.2782,2.5009,2.2178,1.8493,1.8575,2.2626,2.4856,2.2097,1.84,1.8415,2.2485,2.4669,2.1941,1.8275,1.8278,2.2297,2.4498,2.1811,1.8148,1.8135,2.2058,2.4288,2.1649,1.7998,1.7995,2.1865,2.4095,2.1525,1.7877,1.7843,2.1663,2.3853,2.1337,1.77,1.7611,2.1423,2.3564,2.1108,1.7505,1.7403,2.1121,2.3273,2.0851,1.7314,1.7185,2.0815,2.3012,2.0641,1.7085,1.6957,2.0545,2.269,2.0376,1.6834,1.6699,2.0211,2.2342,2.0086,1.6599,1.6428,1.9875,2.1955,1.9753,1.6314,1.6131,1.9497,2.1612,1.942,1.6038,1.5836,1.9155,2.1205,1.9102,1.5774,1.552,1.877,2.0833,1.8777,1.5484,1.5224,1.8382,2.0418,1.8489,1.5216,1.4938,1.8029,2.0053,1.8193,1.4958,1.4643,1.7652,1.9723,1.7932,1.4692,1.4381,1.7315,1.9381,1.7671,1.4521,1.4148,1.7019,1.9119,1.7453,1.4302,1.3929,1.6735,1.8866,1.7281,1.4116,1.3732,1.6485,1.863,1.7117,1.3991,1.3576,1.6278,1.8452,1.6952,1.388,1.3409,1.6107,1.8328,1.69,1.3791,1.3316,1.5946,1.8171,1.684,1.3705,1.3208,1.583,1.8074,1.6781,1.3648,1.3148,1.573,1.8016,1.674,1.3629,1.3051,1.2596:0
8.1684E-4,-7.0459E-4,6.84E-6,2.6881E-4,-0.0011824,0.0018911,-0.0013734,3.9361E-4,5.3633E-4,-6.1179E-4,0.0012195,-8.0882E-4,9.7497E-4,5.5198E-4,-4.5561E-4,0.0010459,-9.9152E-4,7.203E-4,6.1052E-4,-0.0011229,7.6944E-4,-8.0885E-4,6.0389E-4,1.6251E-4,-8.6594E-4,0.0018162,-0.0011972,5.9024E-4,3.5286E-4,-8.4294E-4,9.6694E-4,-7.0712E-4,2.3144E-4,0.050272,0.086408,0.0016644,0.031,0.013448,0.012599,0.01104,0.0081143,0.0097893,0.010916,0.0084976,0.0058388,0.006762,0.0061664,0.0083971,0.0072316,0.0055961,0.0066262,0.0057398,0.0089134,0.010299,0.0049887,0.0074792,0.0068486,0.0095321,0.010727,0.005163,0.0081231,0.0064474,0.0098659,0.010817,0.0051852,0.0080428,0.0065734,0.010002,0.0095114,0.0054801,0.0077839,0.0062352,0.0090089,0.010027,0.005111,0.0078866,0.0059618,0.0091883,0.0096664,0.0050646,0.0082454,0.0068235,0.009461,0.010911,0.0052322,0.0079214,0.0071242,0.009622,0.011003,0.005097,0.0084836,0.0068581,0.010114,0.01002,0.005104,0.0080775,0.0060538,0.0090778,0.0098887,0.0053683,0.0084003,0.0062008,0.0087583,0.0093321,0.0049555,0.0078129,0.0068236,0.0092038,0.010316,0.0051913,0.0078877,0.006661,0.0094418,0.0094517,0.0048397,0.0074518,0.0066627,0.0092462,0.0097125,0.005184,0.0079426,0.0066567,0.0094884,0.0095088,0.0053876,0.0084707,0.0069104,0.0092908,0.010028,0.0044919,0.0075897,0.006661,0.0091219,0.010231,0.0055433,0.0075806,0.006117,0.0086375,0.0093978,0.0048578,0.0074395,0.0068294,0.0095485,0.0099374,0.0049923,0.0078019,0.0065598,0.0092618,0.0098666,0.0049055,0.0080114,0.006891,0.0092341,0.010239,0.0052359,0.0077501,0.0069492,0.0095857,0.0097295,0.0050392,0.0079123,0.006866,0.0098834,0.0088525,0.0053201,0.00812,0.0069118,0.0092736,0.18948,0.98693,0.80266,0.8858,1.0387,1.1095,0.95399,0.8008,0.87944,1.0374,1.1111,0.95581,0.80728,0.88703,1.0428,1.11,0.94855,0.80091,0.88271,1.0438,1.1112,0.95214,0.80499,0.88432,1.043,1.1023,0.94505,0.80236,0.88588,1.0458,1.1006,0.93876,0.79865,0.88597,1.0501,1.1018,0.93928,0.79506,0.88532,1.048,1.0989,0.937,0.79332,0.88488,1.0458,1.0946,0.93274,0.79027,0.88586,1.045,1.0928,0.92969,0.78983,0.88843,1.0434,1.0879,0.92543,0.79275,0.88985,1.0413,1.0876,0.92677,0.79028,0.8867,1.0381,1.0892,0.91979,0.78506,0.88961,1.0422,1.0825,0.91628,0.7889,0.88773,1.0391,1.0819,0.91274,0.78357,0.88726,1.0425,1.0748,0.90937,0.78537,0.88413,1.0406,1.0743,0.90275,0.78204,0.88726,1.0382,1.0694,0.90014,0.77831,0.88903,1.039,1.0647,0.89833,0.77673,0.88843,1.0405,1.0596,0.89613,0.77508,0.88791,1.039,1.0577,0.89243,0.77417,0.8879,1.037,1.0552,0.88756,0.77129,0.88984,1.0334,1.0542,0.88183,0.77088,0.89043,1.0314,1.0502,0.87515,0.77039,0.88691,1.031,1.0443,0.87312,0.76921,0.8848,1.0321,1.0383,0.86949,0.76551,0.88614,1.0294,1.0374,0.86136,0.76631,0.88353,1.0293,1.0305,0.86114,0.76244,0.88618,1.0251,1.0273,0.85378,0.76183,0.88233,1.0263,1.0197,0.8516,0.75734,0.88262,1.0223,1.0138,0.84557,0.75615,0.88092,1.0193,1.0111,0.83997,0.75453,0.87998,1.0172,1.0054,0.83644,0.75058,0.88029,1.0145,0.99986,0.83239,0.74879,0.87962,1.0106,0.99427,0.82816,0.74706,0.87788,1.0091,0.99051,0.82255,0.74503,0.87703,1.0069,0.98527,0.81772,0.74432,0.87582,1.0038,0.98006,0.81321,0.74112,0.87541,1.0022,0.97384,0.80821,0.73898,0.87399,0.99933,0.96838,0.80394,0.73699,0.87097,0.99839,0.96429,0.79931,0.736,0.87065,0.99426,0.95967,0.79315,0.73405,0.87015,0.98928,0.95437,0.79103,0.73175,0.8706,0.98795,0.94813,0.78724,0.72988,0.86953,0.98615,0.94508,0.78275,0.72978,0.86828,0.98381,0.94162,0.77793,0.72888,0.86719,0.98198,0.93515,0.77447,0.72696,0.86379,0.97788,0.9301,0.76932,0.72559,0.8651,0.97646,0.92439,0.76714,0.72289,0.86424,0.97403,0.9215,0.76337,0.72344,0.86375,0.97222,0.91671,0.76126,0.7208,0.86338,0.97136,0.91299,0.75653,0.72214,0.86414,0.96853,0.90709,0.75467,0.71868,0.86481,0.96588,0.90556,0.74903,0.71874,0.86316,0.96491,0.89893,0.74806,0.71741,0.86232,0.9614,0.89731,0.74452,0.71665,0.86109,0.96152,0.89406,0.74005,0.71985,0.85877,0.96122,0.88721,0.73913,0.71652,0.85816,0.95748,0.88501,0.73489,0.71565,0.85945,0.95781,0.88149,0.73172,0.71618,0.85944,0.95822,0.87537,0.73391,0.71367,0.85906,0.95401,0.87197,0.73065,0.71222,0.86101,0.95047,0.87053,0.727,0.71315,0.86121,0.94924,0.86768,0.72463,0.71355,0.8627,0.94714,0.86415,0.72524,0.7131,0.86358,0.94674,0.86271,0.72182,0.0:0
0.0011706,4.5717E-4,-0.0010728,0.001198,-0.0011613,8.526E-4,6.1692E-4,-5.1353E-4,0.0014844,-9.1083E-4,9.702E-4,7.5608E-4,-4.8242E-4,0.0018787,-9.6313E-4,6.2195E-4,7.3271E-4,-0.00127,0.0019039,-9.6583E-4,5.0922E-4,4.8706E-4,-4.7664E-4,0.0016031,0.076994,0.052325,0.031497,0.0084764,0.014783,0.0084388,0.013719,0.014356,0.0050124,0.010062,0.0062186,0.0093534,0.0089556,0.0051215,0.0079249,0.0056384,0.0087591,0.0089167,0.0054073,0.0082328,0.0070342,0.010096,0.010821,0.0047006,0.008341,0.0065072,0.010811,0.010304,0.0047492,0.0085985,0.0061284,0.010216,0.010022,0.0049595,0.0081763,0.0059973,0.009577,0.0096203,0.005212,0.0079002,0.0062573,0.0094039,0.0093852,0.0046445,0.0080923,0.0061805,0.0096646,0.010514,0.0050633,0.0082169,0.0068246,0.0095679,0.0095437,0.0054582,0.0079605,0.0062773,0.0099827,0.0090974,0.0050225,0.0082367,0.0067298,0.010001,0.0089361,0.0052406,0.0077922,0.0064843,0.0096132,0.0093227,0.0049497,0.0078505,0.0067726,0.008691,0.0091584,0.0049199,0.0079117,0.0064433,0.0094682,0.0090678,0.0050075,0.0076962,0.0065847,0.0092848,0.0089397,0.005217,0.0077217,0.0062123,0.008888,0.008249,0.0050094,0.0076286,0.0062801,0.0095283,0.0088388,0.0051425,0.0076336,0.0065786,0.0090748,0.008426,0.0051122,0.0076898,0.0068248,0.0090352,0.0084041,0.0052209,0.007471,0.0069944,0.010129,0.0083072,0.0052366,0.0076133,0.0064368,0.0095085,0.0082207,0.005455,0.0080255,0.0066642,0.0092654,0.0080541,0.0052958,0.0077571,0.0067792,0.0090384,0.0082873,0.0048412,0.0073402,0.0068298,0.0094388,0.0087432,0.0049861,0.0076137,0.0067742,0.0094357,0.0082989,0.0054288,0.0080984,0.4842,1.072,1.0944,0.92275,0.79975,0.91463,1.0755,1.0953,0.92828,0.8017,0.92252,1.0748,1.0892,0.91974,0.79658,0.92288,1.0768,1.0944,0.91949,0.79665,0.92237,1.0709,1.0911,0.91643,0.79958,0.926,1.071,1.0869,0.91015,0.80197,0.93008,1.0751,1.0842,0.90361,0.80179,0.93097,1.0774,1.0823,0.89871,0.80181,0.93159,1.0803,1.0774,0.89605,0.80163,0.93062,1.081,1.0719,0.89659,0.80131,0.92864,1.0829,1.072,0.89395,0.79716,0.93065,1.0854,1.0668,0.88586,0.79634,0.93651,1.0806,1.0607,0.8866,0.79586,0.9352,1.0787,1.0609,0.8807,0.792,0.9416,1.0775,1.0533,0.87901,0.79281,0.93795,1.075,1.0544,0.86969,0.79381,0.94273,1.074,1.0516,0.86585,0.7925,0.94321,1.0724,1.0448,0.8632,0.79225,0.94106,1.0762,1.0376,0.85799,0.79224,0.93752,1.0762,1.0297,0.85506,0.79119,0.93814,1.0783,1.0238,0.85136,0.78936,0.93861,1.0752,1.0176,0.84585,0.78829,0.94223,1.0715,1.0122,0.84111,0.7867,0.94305,1.0668,1.0091,0.83611,0.78705,0.94362,1.0668,1.0016,0.83487,0.78386,0.94398,1.06,0.99877,0.82793,0.78417,0.94776,1.0574,0.99323,0.82081,0.78504,0.94382,1.0562,0.9891,0.81696,0.78394,0.94325,1.0538,0.98283,0.81133,0.78507,0.94095,1.0528,0.9748,0.80635,0.78391,0.9387,1.0545,0.96531,0.80449,0.78153,0.93884,1.0533,0.95913,0.80157,0.78097,0.94078,1.0491,0.95309,0.79609,0.78006,0.94189,1.0445,0.94878,0.79258,0.7783,0.94197,1.04,0.94476,0.78928,0.7776,0.94268,1.0352,0.9382,0.78505,0.77632,0.94182,1.032,0.93339,0.77901,0.77778,0.94069,1.0292,0.92711,0.77416,0.7777,0.93954,1.0266,0.92252,0.7703,0.7774,0.93686,1.0246,0.91459,0.76757,0.77706,0.93595,1.024,0.90725,0.76468,0.77673,0.93303,1.022,0.90011,0.76107,0.77578,0.93334,1.0187,0.89487,0.75718,0.77389,0.93449,1.0142,0.88851,0.75568,0.77193,0.93419,1.0094,0.88374,0.75137,0.77215,0.93624,1.0034,0.88002,0.74817,0.77129,0.93661,0.99973,0.87339,0.74403,0.7724,0.93376,0.99658,0.87053,0.73918,0.7735,0.93235,0.99436,0.8642,0.73722,0.77446,0.93081,0.99254,0.85972,0.73297,0.7752,0.9281,0.9924,0.85211,0.73276,0.77432,0.92721,0.98916,0.84798,0.72969,0.77446,0.92689,0.98691,0.84016,0.72922,0.77336,0.92901,0.98146,0.83802,0.72545,0.77241,0.92956,0.97731,0.83296,0.72411,0.77334,0.93128,0.97299,0.82791,0.7235,0.77318,0.93223,0.9676,0.82652,0.71829,0.77573,0.93007,0.9678,0.82189,0.71536,0.7785,0.92808,0.96383,0.81728,0.71475,0.77833,0.92712,0.96137,0.81465,0.71158,0.77941,0.92359,0.96133,0.80844,0.70909,0.7792,0.92091,0.96147,0.80206,0.71084,0.779,0.9229,0.96032,0.79786,0.71164,0.77851,0.92597,0.95537,0.79633,0.70849,0.77829,0.92886,0.95112,0.79442,0.70828,0.78029,0.92996,0.94989,0.79001,0.70735,0.77903,0.93099,0.94557,0.78651,0.70761,0.7801,0.93135,0.94215,0.78417,0.70588,0.78328,0.92992,0.0:0
-0.011151,0.0047564,-0.0041742,-0.010105,0.011399,-0.016104,0.0021029,-0.0028879,-0.010478,0.01082,-0.014184,0.0039954,-7.4203E-4,-0.012634,0.006843,-0.013896,6.0016E-4,-0.007365,-0.01448,0.0086177,1.0037,1.3317,0.78299,0.26123,0.29953,0.18157,0.23906,0.24345,0.14376,0.17978,0.13831,0.18681,0.19632,0.13561,0.17338,0.12723,0.18354,0.18139,0.1365,0.1711,0.12271,0.18369,0.17429,0.13488,0.16721,0.12112,0.17774,0.16853,0.13069,0.16847,0.12416,0.17871,0.17176,0.1322,0.16546,0.12427,0.17408,0.16619,0.1319,0.16664,0.1245,0.18344,0.16778,0.13163,0.16337,0.12225,0.18195,0.17143,0.13119,0.16836,0.12244,0.17595,0.17913,0.13186,0.16971,0.12692,0.17929,0.19601,0.13554,0.17078,0.13543,0.18476,0.18723,0.13542,0.16919,0.13796,0.18516,0.18872,0.13704,0.16875,0.13459,0.18122,0.19226,0.13267,0.16347,0.13396,0.18587,0.1957,0.1348,0.17185,0.1326,0.18071,0.19447,0.12786,0.17105,0.1315,0.18075,0.189,0.13369,0.16717,0.13563,0.18739,0.19313,0.1313,0.16813,0.1324,0.18444,0.19486,0.13053,0.16442,0.13151,12.887,22.815,20.975,17.62,17.536,20.981,23.179,21.162,17.489,17.691,20.952,23.148,21.198,17.438,17.735,20.935,23.19,21.187,17.407,17.718,20.887,23.094,21.149,17.378,17.704,20.912,23.103,21.098,17.331,17.662,20.863,23.071,21.053,17.298,17.626,20.794,23.001,21.017,17.239,17.58,20.751,22.864,20.921,17.185,17.513,20.641,22.761,20.847,17.111,17.433,20.568,22.673,20.696,17.006,17.36,20.421,22.532,20.576,16.913,17.292,20.342,22.423,20.471,16.818,17.195,20.236,22.308,20.357,16.745,17.138,20.168,22.201,20.22,16.644,17.018,20.085,22.051,20.095,16.503,0.0:0
0.013592,-0.0052387,-0.007617,0.0048629,-0.016093,0.0093163,-0.0093535,-0.0024169,0.007054,-0.017329,0.0096225,-0.011352,-0.0022875,1.0032,0.99475,0.66919,0.57268,0.48514,0.27854,0.22407,0.21641,0.21954,0.24759,0.21,0.15451,0.19263,0.18292,0.20792,0.19608,0.15259,0.17996,0.17547,0.19112,0.19263,0.14018,0.17826,0.17317,0.18798,0.18101,0.14305,0.18006,0.17448,0.18782,0.18445,0.13719,0.1746,0.16858,0.18844,0.18732,0.14079,0.17884,0.16968,0.1854,0.18897,0.14039,0.17562,0.17523,0.18254,0.17902,0.13953,0.17841,0.16397,0.18503,0.18031,0.13197,0.17743,0.17243,0.19716,0.18284,0.14362,0.1816,0.17895,0.2074,0.18748,0.14787,0.18302,0.18103,0.21153,0.19116,0.14832,0.17937,0.18442,0.21275,0.1888,0.1478,0.18162,0.18015,0.21177,0.18418,0.14743,0.18951,0.17744,0.2134,0.1827,0.1462,0.17854,0.18476,0.20571,0.18627,0.14252,0.18287,0.17581,0.20857,0.18849,0.14659,0.18001,0.18049,0.20355,0.17961,0.14347,0.18098,0.18419,0.20558,0.18052,6.2357,17.767,20.718,22.967,21.352,17.787,17.148,20.616,22.873,21.354,17.708,17.21,20.593,22.811,21.377,17.6,17.187,20.509,22.765,21.351,17.551,17.16,20.45,22.726,21.319,17.517,17.146,20.374,22.634,21.232,17.48,17.074,20.25,22.51,21.186,17.375,16.96,20.19,22.405,21.08,17.329,16.909,20.056,22.336,20.972,17.231,16.812,19.948,22.189,20.876,17.174,16.744,19.881,22.104,20.775,17.088,16.628,19.811,21.944,20.712,16.976,16.566,19.707,21.809,20.537,16.881,16.462,19.606,21.654,20.417,16.714,16.362,19.404,21.484,20.213,16.559,16.228,19.244,21.269,19.977,16.374,16.078,19.048,21.037,19.761,16.177,0.0:0
-0.014023,0.011738,-0.012913,0.0059454,-0.003049,-0.01048,0.011395,-0.017327,0.007673,-0.0023111,-0.012394,0.0045342,-0.017259,6.3466E-4,-0.0096731,-0.010792,0.010355,-0.016603,0.0070663,0.46727,1.6809,0.47347,0.48799,0.32663,0.32441,0.23242,0.20071,0.14652,0.20675,0.20487,0.16443,0.18878,0.12005,0.18966,0.18276,0.15185,0.18958,0.1172,0.18455,0.17892,0.15467,0.1883,0.11694,0.18874,0.17714,0.15381,0.18696,0.11046,0.19178,0.17673,0.14805,0.18662,0.11215,0.1894,0.17153,0.14644,0.18548,0.11045,0.19507,0.17793,0.14858,0.18785,0.11296,0.19585,0.17585,0.14674,0.19079,0.11463,0.18458,0.17388,0.14743,0.18675,0.11756,0.19404,0.18248,0.15476,0.18275,0.11457,0.19073,0.19467,0.16902,0.18513,0.12837,0.19471,0.19989,0.16057,0.18431,0.12369,0.19091,0.19988,0.16033,0.18559,0.12866,0.18996,0.18602,0.15895,0.18858,0.12905,0.19444,0.19655,0.16114,0.17823,0.12841,0.1944,0.19227,0.16499,0.18565,0.12676,0.19113,0.19256,0.15769,0.18362,0.13161,0.19571,0.19122,0.15502,0.18159,0.12135,0.20167,0.19094,0.9525,19.448,17.597,19.063,22.558,22.712,18.298,17.269,19.232,22.537,22.648,18.445,17.062,19.323,22.435,22.487,18.512,16.921,19.351,22.369,22.459,18.451,16.845,19.287,22.324,22.305,18.383,16.798,19.254,22.266,22.177,18.329,16.743,19.169,22.127,22.092,18.211,16.624,19.108,22.005,21.968,18.142,16.548,19.032,21.892,21.837,18.034,16.457,18.941,21.768,21.747,17.923,16.388,18.878,21.659,21.63,17.765,16.341,18.777,21.57,21.492,17.662,16.237,18.664,21.428,21.324,17.491,16.138,18.54,21.297,21.088,17.343,15.973,18.416,21.1,20.873,17.156,15.825,18.255,20.88,0.0:0
0.021971,-0.013873,0.017591,0.0039739,-0.0023746,0.023221,-0.011744,0.015343,0.0029122,-0.0064362,0.017784,-0.017582,0.015731,0.010761,-0.003391,0.019955,-0.011295,0.016358,0.0028618,-0.0010343,0.020937,-0.014206,0.013604,0.0036021,-0.0025976,0.020418,-0.012074,0.016291,3.987E-4,4.1507,199.37,188.13,196.34,248.25,258.79,208.09,182.48,198.32,243.96,254.05,197.46,178.12,187.62,223.66,198.45,112.41,48.233,18.511,32.89,49.338,33.952,19.382,19.317,33.916,42.149,28.259,20.552,25.91,35.135,39.414,27.623,23.116,28.686,35.539,39.216,27.929,25.015,30.19,34.98,39.318,29.297,26.852,30.64,35.439,40.064,29.752,27.558,31.26,36.275,40.875,30.56,28.186,31.37,36.998,41.564,31.216,29.069,32.169,38.153,42.302,32.111,29.994,32.58,38.924,42.537,32.36,30.3,33.053,39.654,42.565,33.158,30.942,33.207,40.14,43.184,34.166,31.128,33.181,40.943,43.879,34.674,30.995,33.461,41.545,43.793,35.392,31.685,34.101,41.758,44.332,36.41,31.921,34.602,42.068,44.852,36.974,31.615,35.346,42.365,44.6,37.2,31.974,36.449,42.466,45.325,38.196,32.279,36.697,41.943,45.454,38.26,32.054,37.028,41.947,46.358,38.11,32.078,37.575,42.401,47.336,38.204,32.09,37.821,42.865,47.43,37.524,32.352,38.093,42.094,47.517,37.953,32.979,37.992,42.814,49.111,38.193,33.174,37.492,43.487,49.524,37.461,33.375,37.453,43.496,48.791,37.452,34.427,37.691,44.401,49.153,37.507,34.736,37.547,44.143,48.099,37.477,35.086,36.79,44.454,48.109,37.716,35.128,37.051,45.867,48.512,38.2,34.875,36.951,45.648,47.582,0.0:0
0.012162,0.011695,-0.019365,0.01925,-0.01788,0.0085279,0.011285,-0.011365,0.020771,-0.017246,0.01062,0.012566,-0.015932,0.016237,-0.013129,0.013723,0.011849,-0.014007,0.022056,-0.014399,0.0082092,0.0038283,-0.014723,0.017784,-0.0075146,0.014349,0.013733,-0.0034582,0.028163,-0.011198,67.123,267.58,229.68,191.57,185.14,227.21,263.0,233.94,187.3,183.22,219.77,253.18,219.12,175.42,162.98,156.38,105.66,42.274,17.301,27.995,43.501,35.272,24.646,21.096,29.141,33.566,33.418,29.134,25.641,28.736,30.658,35.497,31.841,27.023,28.176,30.493,37.134,33.6,27.824,27.867,31.715,38.691,34.174,28.1,28.296,32.674,39.245,34.898,28.794,28.567,33.638,40.208,35.897,29.577,29.22,34.78,40.844,36.59,30.046,29.708,35.672,41.135,37.686,30.627,29.897,36.284,41.339,38.344,30.903,30.328,37.259,42.226,39.434,31.273,30.7,38.096,42.581,39.871,31.451,31.448,38.634,42.218,40.328,31.767,31.952,39.003,43.171,42.001,32.122,32.282,38.953,43.86,42.901,31.91,32.807,38.98,43.597,42.878,32.342,33.934,39.142,44.278,43.392,32.7,34.548,39.271,44.874,43.544,32.613,34.623,38.813,45.488,43.885,32.737,34.756,39.22,46.651,44.085,32.868,35.0,39.665,46.902,43.189,33.269,35.295,39.317,46.917,43.554,34.324,35.647,40.066,47.66,43.7,35.019,35.598,39.931,47.249,44.072,35.471,34.622,40.03,47.546,43.913,36.105,35.183,41.413,47.692,43.884,36.097,34.349,41.544,47.27,43.351,36.17,34.511,42.458,46.689,44.8,36.808,35.025,42.409,46.191,45.231,36.349,34.674,42.08,45.523,45.683,36.134,34.58,0.0:0
4.3994,3.607,3.1036,2.4118,3.9771,2.5646,1.9201,2.0735,2.1065,3.8151,2.5391,1.9049,2.0489,2.094,3.7775,2.5322,1.8913,2.0357,2.0846,3.7707,2.5228,1.8827,2.0302,2.0813,3.7666,2.5236,1.8801,2.0305,2.0724,3.7556,2.5323,1.8798,2.0272,2.0739,3.7487,2.534,1.8835,2.0202,2.0657,3.7402,2.5362,1.8823,2.0241,2.0725,3.7333,2.5457,1.8793,2.0184,2.0654,3.7237,2.5422,1.8697,2.0174,2.0579,3.72,2.5453,1.8699,2.0153,2.062,3.7106,2.5448,1.8723,2.0173,2.0575,3.7064,2.5504,1.8662,2.0087,2.0565,3.6992,2.563,1.8654,2.0196,2.0559,3.7002,2.5632,1.856,2.0129,2.0532,3.6894,2.5666,1.864,2.0085,2.0468,3.687,2.5704,1.8605,2.0059,2.0541,3.6779,2.5766,1.8626,2.0058,2.0525,3.6726,2.5871,1.8583,2.0031,2.049,3.6628,2.5895,1.8582,2.0022,2.0503,3.6582,2.5905,1.8523,2.003,2.0452,3.6537,2.5963,1.8565,2.0012,2.0445,3.6432,2.6096,1.8522,2.0028,2.0442,3.6491,2.6167,1.8473,1.9987,2.0451,3.639,2.6265,1.8483,1.9941,2.0412,3.6318,2.6236,1.8509,2.0001,2.0419,3.6304,2.626,1.852,1.9982,2.046,3.6235,2.6265,1.8448,1.9982,2.0406,3.6063,2.6414,1.8473,1.9993,2.0432,3.6055,2.6491,1.846,1.9964,2.0354,3.5918,2.66,1.8389,1.9903,2.0339,3.5917,2.6603,1.8411,1.9922,2.0396,3.5876,2.6651,1.85,1.9911,2.038,3.5802,2.6761,1.8425,1.9936,2.037,3.5668,2.6773,1.8412,1.9824,2.0386,3.5587,2.692,1.8401,1.9857,2.0335,3.5487,2.6842,1.8424,1.9852,2.0324,3.5495,2.697,1.84,1.9862,2.0327,3.5426,2.6987,1.8329,1.9894,2.0299,3.5369,0.0:1
-0.0082522,-0.01128,-0.023716,0.0069241,-0.028777,-0.0075435,-0.0075045,-0.029056,0.0085029,-0.021699,-0.0035718,-0.010392,-0.027476,0.0061834,-0.02645,-0.0070212,-0.013589,0.4737,3.0037,4.3846,5.4739,4.2675,3.6559,3.8691,5.2999,5.8721,4.0702,3.0694,3.1158,4.0955,4.8094,2.6741,2.0015,2.0888,2.4094,3.695,2.2677,1.9012,2.0495,2.3558,3.6795,2.2699,1.8929,2.0413,2.3355,3.6881,2.271,1.8814,2.0353,2.3167,3.6922,2.2793,1.8832,2.029,2.2975,3.6976,2.2816,1.8753,2.0323,2.2833,3.703,2.29,1.8755,2.0272,2.2635,3.7089,2.2949,1.8732,2.0263,2.2538,3.7197,2.3006,1.8698,2.0236,2.2439,3.7226,2.3068,1.8697,2.0155,2.2172,3.7269,2.3058,1.87,2.0179,2.2028,3.7378,2.323,1.8708,2.0171,2.1857,3.744,2.3309,1.8694,2.0162,2.1687,3.7567,2.3453,1.8669,2.0137,2.1479,3.7549,2.3469,1.8536,2.0171,2.1294,3.7691,2.3561,1.8662,2.0157,2.1131,3.7691,2.3584,1.8531,2.012,2.1041,3.7719,2.3715,1.8537,2.011,2.0907,3.7753,2.3843,1.8509,2.0125,2.0834,3.7844,2.3915,1.8571,2.0042,2.0703,3.788,2.3961,1.8497,2.0084,2.0662,3.7801,2.409,1.8581,2.0073,2.0579,3.7802,2.4196,1.8489,2.0051,2.0524,3.7717,2.4297,1.8556,2.0037,2.0547,3.759,2.4402,1.8529,2.0014,2.048,3.7505,2.4552,1.8457,2.0015,2.0435,3.7434,2.4595,1.8437,2.0025,2.0419,3.7386,2.463,1.844,1.9937,2.0352,3.7327,2.4764,1.837,1.9999,2.0357,3.7137,2.4894,1.8418,1.9917,2.0389,3.7092,2.493,1.8425,1.9899,2.0392,3.6963,2.5038,1.8446,1.9896,2.0372,3.6778,2.5199,1.8421,1.9917,2.0314,3.6804,2.5216,1.8369,1.9876,2.0297,0.0:1
0.0072857,-0.027462,5.226E-4,-0.014471,-0.02356,0.0089302,-0.033732,-0.0026576,-0.014379,-0.026531,0.0063314,-0.031945,0.0026908,-0.017559,-0.01825,0.0060822,-0.028353,9.0826E-4,-0.015911,-0.021364,0.0050881,3.8063,4.6538,4.4645,3.1426,3.2744,3.5173,5.9475,5.5111,3.8396,3.769,3.9674,5.6611,4.7273,3.1993,3.0914,3.2589,4.9122,4.1955,2.272,2.1339,2.1361,3.271,3.2216,2.005,2.0516,2.1048,3.2398,3.216,2.0011,2.042,2.0947,3.2249,3.2094,1.994,2.0301,2.0894,3.2127,3.2061,1.9936,2.0286,2.0827,3.1944,3.2134,1.9823,2.0185,2.0826,3.1835,3.2106,1.9853,2.0177,2.077,3.1694,3.2082,1.9949,2.0132,2.0754,3.1586,3.2182,1.9803,2.0118,2.0654,3.1471,3.2196,1.9789,2.0128,2.0603,3.1348,3.2234,1.9857,2.006,2.0671,3.124,3.2374,1.9795,2.0049,2.0578,3.111,3.235,1.9844,2.0046,2.0543,3.1101,3.2408,1.9773,1.9985,2.0556,3.0956,3.2384,1.9832,1.991,2.0515,3.0843,3.2496,1.9854,1.9913,2.0526,3.0778,3.2538,1.9929,1.9924,2.0515,3.0612,3.2619,1.986,1.9909,2.0501,3.0439,3.2631,1.9868,1.9906,2.0467,3.0351,3.2734,1.9833,1.9843,2.0418,3.0336,3.2709,1.988,1.9895,2.0443,3.0138,3.2785,1.9887,1.9866,2.0375,3.0012,3.2806,1.9893,1.9898,2.0378,2.9992,3.2884,1.992,1.9801,2.0389,2.977,3.3021,1.9969,1.9829,2.0324,2.9683,3.303,2.0034,1.977,2.0366,2.9649,3.3036,2.0008,1.9783,2.0369,2.941,3.3095,2.0098,1.9683,2.0293,2.9299,3.3197,2.0044,1.9731,2.031,2.9226,3.3326,2.0057,1.9654,2.0332,2.9088,3.3393,2.0019,1.9654,2.0278,2.8956,3.3532,2.0093,1.9683,2.0259,2.8874,3.353,2.0096,0.0:1
0.017251,-0.01747,-0.012953,0.014046,-0.031557,0.016548,-0.019049,-0.018257,0.017046,-0.037534,0.01908,-0.020246,3.1178,1.3047,1.0795,1.2646,1.7467,1.1742,0.93626,0.93104,1.1429,1.6915,1.1409,0.91615,0.91018,1.1285,1.6727,1.1223,0.89794,0.89647,1.117,1.6655,1.1065,0.89552,0.88726,1.1092,1.6535,1.0972,0.88315,0.88872,1.1045,1.6677,1.09,0.87791,0.87883,1.0907,1.6524,1.0873,0.86277,0.88047,1.0932,1.6465,1.0768,0.8726,0.87828,1.0866,1.6456,1.0733,0.86133,0.86914,1.0757,1.6428,1.0716,0.86213,0.87444,1.0742,1.6431,1.0624,0.86518,0.8629,1.0752,1.6339,1.0599,0.85294,0.86327,1.0713,1.6301,1.0613,0.85649,0.85899,1.0702,1.6248,1.0584,0.84795,0.86591,1.0667,1.6182,1.0601,0.84491,0.86291,1.0636,1.6223,1.0616,0.84576,0.85279,1.0569,1.611,1.0576,0.84003,0.86194,1.0576,1.6089,1.0558,0.8348,0.8532,1.0515,1.6225,1.0574,0.83244,0.85174,1.0586,1.6195,1.0445,0.83487,0.85281,1.0475,1.6216,1.0377,0.83902,0.84866,1.0505,1.6268,1.0328,0.83914,0.84899,1.0484,1.6178,1.0344,0.83337,0.84169,1.0518,1.6157,1.033,0.84041,0.85146,1.0517,1.6107,1.0284,0.8327,0.84492,1.0504,1.6028,1.0324,0.82798,0.85044,1.047,1.6049,1.0403,0.8265,0.85365,1.0444,1.6095,1.0326,0.82675,0.84379,1.0443,1.6058,1.0397,0.82794,0.84421,1.041,1.6066,1.033,0.83346,0.84199,1.0429,1.6074,1.0349,0.82922,0.83885,1.0415,1.6019,1.0389,0.83119,0.83852,1.0461,1.6039,1.0368,0.82276,0.83661,1.047,1.6025,1.0328,0.83075,0.84537,1.0373,1.5981,1.0263,0.82616,0.84333,1.0387,1.5996,1.0374,0.82191,0.83663,1.0354,1.5923,1.0426,0.82496,0.83783,0.0:1
-0.0084886,0.02253,-0.031066,0.024875,-0.019856,-0.0069378,0.018327,-0.043752,0.027842,-0.021307,-0.009593,0.022318,-0.041203,0.024892,-0.028021,-0.012463,0.01599,0.0034276,0.9613,2.1869,1.1872,0.84929,0.8565,0.97562,1.5775,1.0566,0.76977,0.78692,0.92962,1.5609,1.0499,0.7686,0.78538,0.92246,1.5655,1.0566,0.76445,0.79104,0.92742,1.555,1.0633,0.77171,0.79727,0.92889,1.5668,1.0614,0.76747,0.79213,0.92054,1.5684,1.0633,0.76918,0.79526,0.92054,1.5757,1.0585,0.76971,0.79705,0.92469,1.5756,1.0682,0.77296,0.78958,0.92176,1.5785,1.0645,0.77909,0.78843,0.92956,1.5839,1.0663,0.77901,0.79486,0.92327,1.573,1.0627,0.78154,0.79732,0.92642,1.5845,1.0691,0.77683,0.79446,0.92604,1.5741,1.0791,0.7796,0.79815,0.92188,1.5855,1.0811,0.77935,0.79133,0.91702,1.5823,1.0778,0.7718,0.7961,0.91725,1.5794,1.0762,0.76752,0.79749,0.91874,1.5854,1.0739,0.77825,0.80143,0.9277,1.5765,1.0742,0.77598,0.79265,0.92346,1.5865,1.0721,0.78359,0.79998,0.92012,1.5791,1.077,0.78139,0.80205,0.92571,1.5908,1.0824,0.78201,0.79719,0.9238,1.5753,1.0762,0.77648,0.80224,0.92324,1.5823,1.0801,0.77079,0.79946,0.91937,1.5873,1.085,0.7743,0.8023,0.92177,1.578,1.0864,0.78079,0.80169,0.91722,1.5817,1.0786,0.77695,0.79964,0.92114,1.5813,1.0826,0.77674,0.79904,0.92542,1.5791,1.0888,0.77637,0.80327,0.9226,1.5842,1.087,0.77952,0.80373,0.92382,1.5817,1.0908,0.78295,0.80266,0.91768,1.5832,1.0877,0.77805,0.79903,0.92187,1.5842,1.0931,0.78115,0.80214,0.92011,1.5813,1.0833,0.77925,0.80703,0.92224,1.5857,1.0802,0.78259,0.80547,0.92522,1.586,1.0853,0.78276,0.80461,0.92128,1.5905,0.0:1
-0.017552,-4.7072E-4,0.0045848,-0.011046,0.011447,-0.012251,0.0010459,0.0022808,-0.015909,0.009488,-0.021023,-0.0017984,-0.0021837,-0.017586,0.014552,-0.012159,0.002464,0.010361,-0.010219,0.016357,-0.01829,-0.007595,0.0082962,-0.01653,0.015364,-0.014704,2.3387,1.6629,1.4744,1.5076,2.0022,1.7941,1.1098,0.76189,0.80174,1.1041,1.2582,0.75577,0.70763,0.78828,1.0876,1.241,0.74637,0.70135,0.78399,1.0883,1.2223,0.72643,0.69212,0.78216,1.0967,1.217,0.71984,0.68987,0.77485,1.0942,1.1919,0.71842,0.69162,0.76734,1.0955,1.1778,0.71393,0.68785,0.76419,1.0931,1.1679,0.69689,0.67674,0.76017,1.0971,1.1573,0.69038,0.67648,0.75809,1.0931,1.1501,0.68828,0.67767,0.74591,1.1076,1.1298,0.68939,0.67255,0.74843,1.1118,1.1231,0.67432,0.66741,0.74943,1.1184,1.1088,0.67282,0.66265,0.74729,1.1219,1.1058,0.67272,0.66078,0.74509,1.132,1.0863,0.67073,0.66846,0.7451,1.1412,1.0786,0.66888,0.65873,0.74716,1.1416,1.0776,0.66094,0.66181,0.74895,1.1521,1.0677,0.65686,0.66864,0.74051,1.1519,1.0652,0.65764,0.66217,0.74001,1.1664,1.0523,0.65249,0.65798,0.73868,1.1638,1.0472,0.65706,0.66144,0.73634,1.1743,1.0409,0.64556,0.66182,0.73764,1.1857,1.0351,0.65002,0.65889,0.73584,1.1815,1.0243,0.64395,0.65781,0.73638,1.1794,1.017,0.64396,0.66642,0.73695,1.1841,1.0158,0.64445,0.66013,0.73386,1.1873,1.0099,0.63644,0.65886,0.73399,1.197,1.0035,0.64053,0.65177,0.74159,1.1971,1.0043,0.6342,0.66449,0.73913,1.2002,0.99338,0.63219,0.65162,0.73094,1.2045,0.98995,0.62936,0.65549,0.73356,1.2178,0.98505,0.62711,0.65121,0.73907,1.2156,0.98322,0.62514,0.65644,0.731,1.225,0.97265,0.61815,0.65561,0.73396,0.0:1
0.0056763,-0.014812,0.016062,-0.0091475,-0.0064511,0.011104,-0.016751,0.014518,-0.00873,-0.0037185,0.0095746,-0.015883,0.01279,-0.0060383,-0.005644,0.0075609,-0.017938,0.012219,-0.011117,-0.0012142,0.0093807,-0.01249,0.015,-0.0070336,1.8489,1.4319,0.92513,0.64118,1.3211,1.5026,0.84764,0.75293,0.85298,1.4461,0.96629,0.73353,0.73303,0.81588,1.4206,0.93671,0.72847,0.72632,0.80787,1.4089,0.92715,0.71548,0.72122,0.80151,1.4041,0.91032,0.71539,0.71217,0.79567,1.3954,0.89953,0.70223,0.71428,0.78606,1.4048,0.89669,0.69893,0.70513,0.78524,1.3877,0.88443,0.68952,0.70464,0.77816,1.3984,0.87043,0.69061,0.69484,0.77263,1.4027,0.8636,0.68945,0.69746,0.7812,1.4033,0.84244,0.68548,0.69668,0.77699,1.4022,0.84331,0.69229,0.69129,0.77215,1.402,0.83143,0.68319,0.69563,0.77239,1.3996,0.82936,0.68965,0.69444,0.76935,1.404,0.82246,0.67782,0.6928,0.76898,1.4076,0.81733,0.67493,0.69031,0.76153,1.407,0.80795,0.68618,0.69139,0.77153,1.4115,0.80173,0.67406,0.68876,0.76236,1.415,0.79023,0.68118,0.68551,0.76655,1.4138,0.78158,0.68177,0.68842,0.76127,1.4257,0.78163,0.68482,0.69485,0.76395,1.4136,0.76977,0.67514,0.68725,0.75954,1.4179,0.76976,0.67528,0.68431,0.76169,1.4165,0.76324,0.67513,0.6934,0.76736,1.4162,0.76127,0.67499,0.69164,0.77613,1.4007,0.7517,0.67959,0.6873,0.77811,1.4039,0.75211,0.67442,0.68297,0.78166,1.4006,0.74216,0.67922,0.69109,0.79193,1.3926,0.73527,0.67351,0.68666,0.80067,1.3725,0.72765,0.68431,0.68116,0.81537,1.371,0.72517,0.67559,0.67722,0.82015,1.3608,0.72602,0.67638,0.68396,0.82866,1.3638,0.71831,0.67765,0.6875,0.83758,1.3515,0.71786,0.68025,0.6887,0.84102,1.3436,0.70708,0.0:1
0.0049676,0.0054343,-0.014343,0.0088719,-0.015394,-5.4855E-4,-4.2327E-4,-0.013796,0.007315,-0.01369,-0.0046614,8.4588E-4,-0.016996,0.0082278,-0.017048,0.0047592,-0.0014272,-0.011576,0.0092015,-0.017906,0.0040222,-0.0032693,-0.014093,0.0094712,-0.017596,1.6607,1.7951,1.4274,1.4621,1.7441,1.7091,0.77155,0.66389,0.76578,0.89909,1.3055,0.71464,0.64366,0.73572,0.89157,1.2822,0.70252,0.63752,0.74105,0.89957,1.281,0.69949,0.63571,0.73497,0.8996,1.2676,0.69937,0.63107,0.7315,0.90436,1.2568,0.69595,0.62682,0.734,0.91085,1.2417,0.68714,0.62827,0.72947,0.91656,1.234,0.67981,0.62351,0.72827,0.91766,1.2297,0.67847,0.6298,0.7244,0.9279,1.2126,0.67004,0.62599,0.72699,0.9392,1.2082,0.66465,0.62692,0.71904,0.95219,1.1918,0.66832,0.62472,0.72417,0.96304,1.188,0.66704,0.6229,0.72183,0.97044,1.1786,0.66346,0.63307,0.72188,0.97984,1.1676,0.66558,0.629,0.72396,0.99082,1.1584,0.65218,0.63499,0.71867,0.99453,1.1516,0.64702,0.62726,0.72211,1.004,1.149,0.64124,0.62916,0.71948,1.0158,1.1304,0.64913,0.63255,0.71895,1.0241,1.1314,0.64584,0.62716,0.72141,1.0296,1.1161,0.64281,0.62641,0.72757,1.0425,1.1068,0.63611,0.62465,0.71995,1.0529,1.0931,0.63547,0.62814,0.72421,1.0596,1.0833,0.63487,0.62692,0.71809,1.0685,1.0822,0.63502,0.63173,0.72271,1.0732,1.0713,0.62812,0.62626,0.71927,1.0849,1.0636,0.62716,0.6285,0.72083,1.0956,1.0515,0.62374,0.62838,0.7188,1.0956,1.0434,0.62883,0.62713,0.71439,1.1073,1.0366,0.62421,0.63032,0.71423,1.1208,1.0248,0.62122,0.62143,0.71398,1.1206,1.0275,0.62203,0.63056,0.7175,1.1367,1.017,0.61948,0.62637,0.71022,1.1346,1.0118,0.61791,0.63434,0.72037,1.1451,0.0:1
0.00685,-0.01938,0.0015992,-0.0054972,-0.013381,0.01143,-0.01018,-0.0035736,-0.0092449,-0.013251,0.014495,-0.012922,0.0077342,-0.0043222,-0.0080663,0.0080109,-0.02326,-0.0023067,-0.009829,-0.010467,0.013775,-0.016851,0.0032242,-0.0071877,1.4987,1.3662,2.2727,2.3316,1.5583,1.3348,1.4188,2.1815,2.4174,1.6332,1.3838,1.4834,2.2008,2.4514,1.6501,1.3977,1.492,2.2266,2.4663,1.6681,1.4033,1.5066,2.2474,2.4922,1.6802,1.4148,1.5095,2.262,2.4879,1.6732,1.3709,1.3956,1.3285,1.7061,0.95179,0.76205,0.84858,0.8357,1.608,0.89877,0.72254,0.80231,0.80812,1.5787,0.88579,0.70846,0.78842,0.7881,1.5704,0.86311,0.69936,0.78339,0.77935,1.5488,0.85326,0.68596,0.76996,0.77169,1.55,0.85492,0.69148,0.7686,0.77055,1.5398,0.83785,0.68464,0.7675,0.76246,1.5308,0.83135,0.67798,0.76704,0.7633,1.5354,0.82744,0.67148,0.75668,0.7608,1.5313,0.8317,0.66687,0.75865,0.75221,1.528,0.82014,0.67304,0.75486,0.76158,1.5216,0.81534,0.65734,0.75168,0.7464,1.5198,0.81502,0.66837,0.74922,0.75266,1.5213,0.81571,0.66868,0.74721,0.74782,1.5215,0.808,0.65417,0.75028,0.74783,1.5205,0.80153,0.65875,0.73794,0.74696,1.5152,0.81178,0.65214,0.7464,0.73304,1.5152,0.79771,0.65778,0.74607,0.74538,1.5144,0.79807,0.65401,0.74447,0.73171,1.5117,0.79332,0.64728,0.74594,0.73139,1.5094,0.79568,0.64862,0.73688,0.73631,1.5083,0.79491,0.64588,0.74444,0.73753,1.5083,0.7904,0.65068,0.73502,0.73699,1.5038,0.79456,0.64267,0.73786,0.72134,1.5073,0.79057,0.6451,0.73154,0.73919,1.4928,0.798,0.63995,0.739,0.73104,1.4997,0.7817,0.63915,0.73097,0.7309,1.5003,0.78653,0.64601,0.73408,0.7283,1.5019,0.78719,0.63705,0.0:1
0.0011084,-0.0012358,7.4568E-4,-2.7553E-4,-0.0012388,0.0010145,-9.0064E-4,0.0010077,9.5764E-4,-3.6584E-4,0.0014873,-9.3353E-4,8.493E-4,-0.0013211,-0.0016571,8.4925E-4,-4.3381E-4,3.8197E-4,6.5376E-4,-0.001163,6.9076E-4,-9.7385E-4,0.0010543,3.0094E-4,-3.1011E-4,0.001503,0.4012,0.25694,0.13757,0.11918,0.13942,0.1766,0.21957,0.12362,0.11672,0.12862,0.17039,0.21663,0.12169,0.11678,0.12749,0.16834,0.21628,0.12016,0.11606,0.12681,0.16545,0.21723,0.12058,0.1152,0.1254,0.16503,0.21753,0.11933,0.11451,0.12518,0.1624,0.2175,0.12004,0.11433,0.12585,0.16065,0.21837,0.11871,0.11162,0.12271,0.15731,0.21528,0.11757,0.11298,0.12043,0.15376,0.21624,0.11783,0.11242,0.12133,0.15277,0.2166,0.11782,0.11119,0.12109,0.1509,0.21702,0.11773,0.11015,0.12005,0.14963,0.21738,0.11728,0.1103,0.11928,0.14772,0.21811,0.11824,0.1104,0.12044,0.14627,0.21897,0.11811,0.10971,0.11989,0.14566,0.21822,0.11802,0.10919,0.11924,0.14221,0.21951,0.11878,0.10907,0.11932,0.14198,0.22045,0.11878,0.1098,0.12002,0.1397,0.22207,0.11972,0.10877,0.1196,0.13956,0.22311,0.12024,0.10903,0.11879,0.13642,0.22275,0.122,0.10789,0.11852,0.13569,0.22308,0.12144,0.10823,0.11785,0.13567,0.22352,0.12185,0.10735,0.11841,0.13372,0.22579,0.12379,0.10868,0.11803,0.13172,0.22521,0.12292,0.10775,0.11793,0.13072,0.22576,0.12409,0.10788,0.11797,0.12853,0.22653,0.12362,0.10674,0.11846,0.12801,0.22722,0.12474,0.10583,0.11716,0.12653,0.22707,0.12509,0.10694,0.11787,0.12556,0.22878,0.12617,0.10648,0.11752,0.12328,0.23039,0.12582,0.10639,0.11683,0.12216,0.22988,0.12673,0.10576,0.11786,0.12078,0.23131,0.12805,0.10615,0.11708,0.11972,0.23044,0.12834,0.10661,0.11716,0.11756,0.22987,0.129,0.10621,0.0:1
-6.44E-6,9.0767E-6,-3.5467E-6,1.0767E-6,3.9167E-6,-1.8767E-6,6.0567E-6,1.86E-6,3.16E-6,7.6433E-6,-5.2233E-6,6.25E-6,-3.0367E-6,1.67E-6,7.48E-6,-5.8E-6,4.2233E-6,-9.6667E-7,1.6033E-6,1.5867E-6,-1.4667E-6,4.3933E-6,1.47E-6,-3.31E-6,2.6033E-6,-3.9233E-6,8.0267E-6,-6.16E-6,2.51E-6,2.95E-6,-5.4233E-6,4.2667E-6,-3.8E-6,4.3167E-6,7.4933E-6,-3.91E-6,5.74E-6,-5.76E-6,2.3367E-6,4.1133E-6,-2.9733E-6,1.1333E-6,-1.9933E-6,2.52E-6,4.55E-6,-3.1333E-7,5.1167E-6,6.8E-7,2.8567E-6,5.34E-6,-3.6867E-6,2.6633E-6,-5.8567E-6,1.2067E-6,1.95E-6,-1.8033E-6,7.13E-6,-2.08E-6,2.88E-6,2.1667E-6,-1.74E-6,3.2067E-6,1.37E-6,1.7067E-6,3.0467E-6,-1.35E-6,1.02E-5,-3.8E-6,4.1433E-6,2.07E-6,-2.8633E-6,3.9067E-6,-2.59E-6,3.39E-6,5.6233E-6,-6.31E-6,2.65E-6,-8.8E-7,3.78E-6,5.2933E-6,-5.6733E-6,4.0667E-6,-2.13E-6,3.78E-6,6.56E-6,-8.5233E-6,5.0E-6,-1.8533E-6,1.65E-6,6.4533E-6,-4.2167E-6,6.5092E-4,0.0011222,0.0011218,7.8429E-4,6.95E-4,7.262E-4,0.0010482,0.0011911,8.1503E-4,7.0379E-4,7.5667E-4,0.0010775,0.0012021,8.2199E-4,7.05E-4,7.1526E-4,8.9289E-4,8.8783E-4,3.7102E-4,3.1593E-4,3.5184E-4,3.6903E-4,6.8368E-4,3.5822E-4,3.1149E-4,3.4819E-4,3.6696E-4,6.846E-4,3.528E-4,3.0833E-4,3.4831E-4,3.6359E-4,6.7922E-4,3.5038E-4,3.0574E-4,3.4482E-4,3.6561E-4,6.8011E-4,3.4538E-4,3.063E-4,3.4785E-4,3.5879E-4,6.7648E-4,3.4973E-4,3.0376E-4,3.4004E-4,3.5982E-4,6.7237E-4,3.4581E-4,3.0519E-4,3.4086E-4,3.6445E-4,6.773E-4,3.423E-4,3.0736E-4,3.4282E-4,3.6347E-4,6.7773E-4,3.45E-4,3.0582E-4,3.422E-4,3.667E-4,6.6583E-4,3.445E-4,3.0987E-4,3.4473E-4,3.6814E-4,6.6709E-4,3.4049E-4,3.0568E-4,3.4397E-4,3.6512E-4,6.6732E-4,3.4294E-4,3.0067E-4,3.4329E-4,3.7462E-4,6.5875E-4,3.3579E-4,3.0253E-4,3.4555E-4,3.7116E-4,6.6669E-4,3.3201E-4,3.0847E-4,3.4361E-4,3.7664E-4,6.6517E-4,3.3657E-4,3.0021E-4,3.4525E-4,3.8207E-4,6.6125E-4,3.3889E-4,3.0471E-4,3.4544E-4,3.8233E-4,6.5832E-4,3.3784E-4,3.0474E-4,3.3957E-4,3.8014E-4,6.5492E-4,3.358E-4,3.0466E-4,3.4334E-4,3.8472E-4,6.5624E-4,3.3233E-4,3.0755E-4,3.4224E-4,3.8656E-4,6.5537E-4,3.3426E-4,3.0186E-4,3.4503E-4,3.8544E-4,6.49E-4,3.3002E-4,3.0307E-4,3.4343E-4,3.8827E-4,6.5386E-4,3.2881E-4,3.0916E-4,3.4305E-4,3.8566E-4,6.4509E-4,3.3059E-4,3.0841E-4,3.4322E-4,3.92E-4,6.4618E-4,3.2724E-4,3.084E-4,3.455E-4,3.9406E-4,6.3777E-4,3.3341E-4,3.0802E-4,3.4134E-4,4.0162E-4,6.3621E-4,3.3087E-4,3.041E-4,3.4596E-4,4.0608E-4,6.3798E-4,3.3424E-4,3.0347E-4,3.455E-4,3.9998E-4,6.3672E-4,3.3366E-4,3.0903E-4,3.4049E-4,4.0587E-4,6.3736E-4,3.2775E-4,3.0352E-4,3.4222E-4,4.1075E-4,6.3588E-4,3.2706E-4,3.0358E-4,3.4507E-4,4.1034E-4,6.2483E-4,3.2241E-4,3.0924E-4,3.445E-4,4.1219E-4,6.2117E-4,3.2348E-4,3.0508E-4,3.4015E-4,4.079E-4,6.1682E-4,3.2322E-4,3.0214E-4,3.4078E-4,4.1433E-4,6.138E-4,3.1968E-4,3.0562E-4,3.3652E-4,4.0969E-4,6.1139E-4,3.2641E-4,3.0032E-4,3.3817E-4,4.1995E-4,6.128E-4,3.2372E-4,2.9975E-4,3.376E-4,4.1912E-4,6.0855E-4,3.155E-4,0.0:1
-6.1267E-6,3.6967E-6,3.59E-6,-2.4067E-6,5.3633E-6,-2.7633E-6,1.3567E-6,-4.3667E-7,-3.69E-6,4.8533E-6,-3.55E-6,1.7033E-6,-3.4667E-7,-7.0E-8,5.8633E-6,-7.9667E-7,7.3433E-6,5.0933E-6,2.5333E-7,4.5267E-6,-2.8833E-6,3.24E-6,3.3933E-6,-4.7633E-6,5.53E-6,-4.71E-6,4.2833E-6,-2.7833E-6,-2.45E-6,5.07E-6,7.7333E-7,4.3133E-6,5.0467E-6,1.5233E-6,4.8767E-6,-2.19E-6,-1.4333E-7,1.2733E-6,-3.05E-6,4.4567E-6,-2.5633E-6,6.1233E-6,-1.1567E-6,-2.2133E-6,5.4233E-6,0.0014281,0.00135,0.0011106,8.3027E-4,8.1279E-4,8.6345E-4,0.0014484,0.0011351,8.4021E-4,8.3034E-4,8.7511E-4,0.0014746,0.0011295,8.265E-4,7.9665E-4,6.7445E-4,8.7051E-4,6.2855E-4,4.1646E-4,4.1524E-4,4.2645E-4,6.9656E-4,5.8419E-4,3.9282E-4,4.0511E-4,4.1511E-4,6.7647E-4,5.7784E-4,3.8284E-4,3.9919E-4,4.0913E-4,6.7543E-4,5.6826E-4,3.7466E-4,3.8989E-4,4.0213E-4,6.622E-4,5.6871E-4,3.648E-4,3.8999E-4,3.9772E-4,6.6835E-4,5.5797E-4,3.6407E-4,3.906E-4,3.9526E-4,6.5949E-4,5.5377E-4,3.6264E-4,3.8336E-4,3.9215E-4,6.5625E-4,5.4972E-4,3.5623E-4,3.7768E-4,3.8594E-4,6.5552E-4,5.4273E-4,3.5286E-4,3.7897E-4,3.8955E-4,6.4784E-4,5.4281E-4,3.5049E-4,3.7738E-4,3.8276E-4,6.5094E-4,5.4228E-4,3.4888E-4,3.7346E-4,3.8448E-4,6.5577E-4,5.3654E-4,3.4315E-4,3.7334E-4,3.8069E-4,6.4983E-4,5.3393E-4,3.4507E-4,3.7291E-4,3.7857E-4,6.5184E-4,5.3167E-4,3.4573E-4,3.7048E-4,3.802E-4,6.4755E-4,5.2998E-4,3.3882E-4,3.6933E-4,3.8344E-4,6.4515E-4,5.2692E-4,3.3468E-4,3.7022E-4,3.7622E-4,6.4042E-4,5.3369E-4,3.3814E-4,3.6798E-4,3.7531E-4,6.4126E-4,5.2419E-4,3.3827E-4,3.6853E-4,3.7553E-4,6.3913E-4,5.2339E-4,3.3608E-4,3.6497E-4,3.7536E-4,6.3303E-4,5.2648E-4,3.339E-4,3.6288E-4,3.7195E-4,6.3326E-4,5.2882E-4,3.3077E-4,3.6218E-4,3.71E-4,6.3533E-4,5.1825E-4,3.3218E-4,3.63E-4,3.7428E-4,6.3567E-4,5.2547E-4,3.3232E-4,3.6165E-4,3.7287E-4,6.3666E-4,5.1762E-4,3.3008E-4,3.6033E-4,3.6791E-4,6.3386E-4,5.2149E-4,3.2954E-4,3.6049E-4,3.6863E-4,6.347E-4,5.1301E-4,3.2531E-4,3.5748E-4,3.6596E-4,6.409E-4,5.1011E-4,3.2762E-4,3.6408E-4,3.6887E-4,6.4071E-4,5.0171E-4,3.2773E-4,3.5752E-4,3.7061E-4,6.3357E-4,5.1457E-4,3.233E-4,3.5747E-4,3.6799E-4,6.3688E-4,5.11E-4,3.2549E-4,3.5805E-4,3.6933E-4,6.3752E-4,5.0573E-4,3.2263E-4,3.6123E-4,3.6289E-4,6.4249E-4,5.0621E-4,3.2031E-4,3.5986E-4,3.6398E-4,6.3819E-4,5.0063E-4,3.219E-4,3.6173E-4,3.6344E-4,6.4092E-4,5.0083E-4,3.2314E-4,3.5577E-4,3.6854E-4,6.3877E-4,5.0262E-4,3.2127E-4,3.5243E-4,3.6758E-4,6.3318E-4,5.0705E-4,3.2063E-4,3.5298E-4,3.661E-4,6.3212E-4,5.0215E-4,3.1923E-4,3.5595E-4,3.6356E-4,3.6028E-4:1
-6.5867E-6,2.0033E-6,3.3767E-6,6.7E-7,3.0533E-6,-1.1467E-6,1.5333E-6,1.64E-6,-1.9467E-6,7.6733E-6,-4.32E-6,6.6433E-6,4.01E-6,-4.9767E-6,8.8067E-6,-3.6467E-6,8.79E-6,1.7567E-6,-7.7667E-7,4.2233E-6,-3.3667E-7,5.55E-6,5.2733E-6,-2.9433E-6,1.9E-6,-3.2667E-6,8.4067E-6,4.5433E-6,-3.1933E-6,4.69E-6,-8.4E-7,4.1167E-6,5.4667E-6,-2.63E-6,3.9067E-6,-1.7367E-6,5.7333E-7,3.1533E-6,-4.4267E-6,3.0733E-6,-1.0933E-6,8.7833E-6,3.6267E-6,-2.0667E-6,7.7233E-6,-1.87E-6,5.57E-6,5.2667E-7,-1.0517E-5,8.74E-6,-2.43E-6,9.8833E-6,1.6567E-6,5.9333E-7,3.0867E-6,-3.6933E-6,7.0033E-6,2.2833E-6,-4.9667E-6,8.0667E-6,1.1233E-6,5.2667E-6,3.2467E-6,2.4667E-7,0.0012277,0.0010167,0.0012891,9.1092E-4,7.2021E-4,7.6467E-4,9.5176E-4,0.0013534,9.5477E-4,7.338E-4,7.9562E-4,9.7466E-4,0.001369,9.6516E-4,7.3729E-4,7.9999E-4,9.5801E-4,0.0011204,6.1803E-4,4.1347E-4,3.9115E-4,3.9125E-4,7.2151E-4,4.5483E-4,3.3824E-4,3.7831E-4,3.7321E-4,7.0642E-4,4.4693E-4,3.2887E-4,3.7417E-4,3.7056E-4,7.0311E-4,4.4127E-4,3.214E-4,3.74E-4,3.6482E-4,7.1095E-4,4.3228E-4,3.2124E-4,3.7005E-4,3.6197E-4,6.9875E-4,4.3837E-4,3.2619E-4,3.6741E-4,3.6304E-4,6.9482E-4,4.2545E-4,3.1433E-4,3.6977E-4,3.64E-4,6.9848E-4,4.2865E-4,3.1554E-4,3.6446E-4,3.5965E-4,6.9667E-4,4.3E-4,3.1448E-4,3.6849E-4,3.6232E-4,6.9615E-4,4.2636E-4,3.1704E-4,3.6221E-4,3.5919E-4,6.9335E-4,4.2239E-4,3.1874E-4,3.6332E-4,3.6155E-4,6.9094E-4,4.247E-4,3.15E-4,3.6245E-4,3.5644E-4,6.9367E-4,4.247E-4,3.1109E-4,3.6095E-4,3.5936E-4,6.8721E-4,4.217E-4,3.1257E-4,3.5951E-4,3.562E-4,6.9089E-4,4.1715E-4,3.1248E-4,3.6295E-4,3.5796E-4,6.9039E-4,4.1521E-4,3.0976E-4,3.5646E-4,3.5559E-4,6.8778E-4,4.2017E-4,3.0694E-4,3.6252E-4,3.5781E-4,6.9233E-4,4.1731E-4,3.1058E-4,3.5859E-4,3.5107E-4,6.897E-4,4.1499E-4,3.0903E-4,3.5815E-4,3.5063E-4,6.8563E-4,4.1374E-4,3.1181E-4,3.5592E-4,3.5801E-4,6.9049E-4,4.0837E-4,3.153E-4,3.552E-4,3.5744E-4,6.8512E-4,4.1921E-4,3.1422E-4,3.5634E-4,3.5247E-4,6.8262E-4,4.1524E-4,3.1375E-4,3.5873E-4,3.5284E-4,6.8728E-4,4.0872E-4,3.063E-4,3.6084E-4,3.5081E-4,6.9095E-4,4.0879E-4,3.0687E-4,3.5747E-4,3.5516E-4,6.825E-4,4.1137E-4,3.0668E-4,3.5882E-4,3.5326E-4,6.8662E-4,4.0618E-4,3.0502E-4,3.5426E-4,3.5468E-4,6.8166E-4,4.1001E-4,3.051E-4,3.5622E-4,3.5369E-4,6.8315E-4,4.0708E-4,3.0863E-4,3.5467E-4,3.5322E-4,6.855E-4,4.0946E-4,3.0801E-4,3.5376E-4,3.5549E-4,6.8916E-4,4.0407E-4,3.1323E-4,3.5531E-4,3.4946E-4,6.8899E-4,4.0735E-4,3.0891E-4,3.5067E-4,3.515E-4,6.9083E-4,4.0154E-4,3.136E-4,3.5421E-4,3.5284E-4,6.8383E-4,4.0388E-4,3.0661E-4,3.5577E-4,3.5321E-4,6.8458E-4,4.0159E-4,3.1146E-4,3.5866E-4,3.5094E-4,6.8916E-4,4.016E-4,3.0572E-4,3.6163E-4,0.0:1
8.53E-6,-1.1273E-5,1.3667E-5,1.14E-6,9.26E-6,9.4867E-6,-3.3533E-6,1.032E-5,3.3333E-7,4.1433E-6,6.6633E-6,-1.1157E-5,1.347E-5,-4.9E-7,2.2367E-6,6.6767E-6,-1.1443E-5,1.871E-5,-7.4233E-6,2.4E-7,6.9333E-6,-1.0617E-5,9.13E-6,-2.83E-6,8.5033E-6,1.0403E-5,-6.2067E-6,1.207E-5,0.0026964,0.0017914,0.0013732,0.0014253,0.0013533,0.0019929,0.0010666,7.0224E-4,6.9187E-4,7.3529E-4,0.001133,0.001025,6.6213E-4,6.5035E-4,7.114E-4,0.0010755,0.0010152,6.3604E-4,6.3624E-4,6.9834E-4,0.0010725,9.9553E-4,6.3931E-4,6.403E-4,6.8814E-4,0.0010694,9.8983E-4,6.328E-4,6.2468E-4,6.8421E-4,0.0010598,9.9386E-4,6.2486E-4,6.2307E-4,6.7807E-4,0.0010497,9.7571E-4,6.1924E-4,6.1409E-4,6.7494E-4,0.0010432,9.7448E-4,6.1331E-4,6.1288E-4,6.7211E-4,0.0010385,9.7611E-4,6.1558E-4,6.1124E-4,6.7544E-4,0.0010304,9.7057E-4,6.1129E-4,6.1588E-4,6.6586E-4,0.001026,9.7106E-4,6.1185E-4,6.0488E-4,6.6618E-4,0.0010204,9.6682E-4,5.9901E-4,6.0553E-4,6.6323E-4,0.0010053,9.865E-4,5.9623E-4,6.0282E-4,6.5978E-4,0.0010157,9.743E-4,5.983E-4,5.9902E-4,6.6242E-4,0.001007,9.7702E-4,6.0085E-4,6.0073E-4,6.5419E-4,9.913E-4,9.7433E-4,5.9531E-4,5.9569E-4,6.5269E-4,9.9767E-4,9.7678E-4,5.9917E-4,5.9847E-4,6.5314E-4,9.9408E-4,9.7521E-4,5.9878E-4,5.9484E-4,6.6338E-4,9.8751E-4,9.7903E-4,5.9258E-4,5.902E-4,6.5027E-4,9.8609E-4,9.787E-4,5.8958E-4,5.9055E-4,6.5146E-4,9.8611E-4,9.7874E-4,5.9168E-4,5.927E-4,6.5325E-4,9.8249E-4,9.7197E-4,5.9195E-4,5.9347E-4,6.4767E-4,9.8114E-4,9.8466E-4,5.89E-4,5.9016E-4,6.4896E-4,9.7311E-4,9.7573E-4,5.8892E-4,5.8691E-4,6.4731E-4,9.6862E-4,9.8407E-4,5.9473E-4,5.8007E-4,6.4675E-4,9.6279E-4,9.7902E-4,5.922E-4,5.7999E-4,6.5343E-4,9.6268E-4,9.8186E-4,5.9172E-4,5.8029E-4,6.5282E-4,9.4915E-4,9.8538E-4,5.8566E-4,5.8008E-4,6.5021E-4,9.5302E-4,9.8763E-4,5.8647E-4,5.7919E-4,6.4884E-4,9.554E-4,9.8434E-4,5.8022E-4,5.8039E-4,6.4916E-4,9.4966E-4,9.881E-4,5.8787E-4,5.8342E-4,6.4437E-4,9.4136E-4,9.8911E-4,5.8714E-4,5.8411E-4,6.4348E-4,9.4645E-4,9.8733E-4,5.9369E-4,5.8202E-4,6.4186E-4,9.4064E-4,9.8657E-4,0.0:1
4.64E-6,-9.97E-6,7.32E-6,-1.2707E-5,4.9433E-6,4.3533E-6,-1.07E-6,1.2197E-5,-6.13E-6,1.015E-5,1.1087E-5,-5.8767E-6,1.7593E-5,-1.1E-5,1.1687E-5,6.9367E-6,-1.0247E-5,1.871E-5,-5.0067E-6,1.172E-5,5.67E-6,-3.46E-6,1.4317E-5,-2.4767E-6,6.8867E-6,1.1257E-5,-7.0167E-6,1.165E-5,-9.9867E-6,7.54E-6,9.03E-6,-1.0747E-5,1.3753E-5,-5.9067E-6,0.0030557,0.0018216,0.0013531,0.0015944,0.0020505,0.0023924,9.9729E-4,6.6864E-4,7.5706E-4,7.137E-4,0.0013432,8.7386E-4,6.4057E-4,7.0913E-4,7.1212E-4,0.0012995,8.5763E-4,6.3515E-4,7.0049E-4,6.9769E-4,0.0012856,8.4642E-4,6.1957E-4,6.8975E-4,6.8533E-4,0.0012829,8.2508E-4,6.129E-4,6.9295E-4,6.7611E-4,0.0012641,8.1978E-4,6.0393E-4,6.8044E-4,6.7754E-4,0.0012614,8.1193E-4,6.038E-4,6.7664E-4,6.678E-4,0.0012526,8.0525E-4,5.9436E-4,6.6819E-4,6.7153E-4,0.0012551,7.9479E-4,5.9363E-4,6.663E-4,6.6741E-4,0.0012582,7.9025E-4,5.8918E-4,6.6422E-4,6.6033E-4,0.0012484,7.822E-4,5.8765E-4,6.5909E-4,6.5749E-4,0.0012428,7.8529E-4,5.8525E-4,6.5356E-4,6.5926E-4,0.0012448,8.1029E-4,5.84E-4,6.5345E-4,6.542E-4,0.0012406,7.7391E-4,5.7745E-4,6.5522E-4,6.5265E-4,0.0012441,7.6829E-4,5.7766E-4,6.5606E-4,6.4281E-4,0.0012397,7.6461E-4,5.6722E-4,6.521E-4,6.5128E-4,0.0012453,7.5231E-4,5.6997E-4,6.5033E-4,6.4946E-4,0.001237,7.5129E-4,5.7199E-4,6.4921E-4,6.4568E-4,0.0012419,7.4336E-4,5.7743E-4,6.4771E-4,6.5081E-4,0.0012384,7.405E-4,5.7497E-4,6.4158E-4,6.4387E-4,0.001239,7.3628E-4,5.6698E-4,6.4534E-4,6.4233E-4,0.0012317,7.3623E-4,5.6533E-4,6.4842E-4,6.4254E-4,0.0012333,7.4138E-4,5.6652E-4,6.4071E-4,6.3784E-4,0.0012438,7.3116E-4,5.6607E-4,6.521E-4,6.4223E-4,0.0012387,7.3002E-4,5.6784E-4,6.4471E-4,6.4149E-4,0.0012335,7.2713E-4,5.6157E-4,6.4296E-4,6.336E-4,0.0012345,7.1507E-4,5.6676E-4,6.3974E-4,6.3702E-4,0.001239,7.2261E-4,5.6461E-4,6.3927E-4,6.3736E-4,0.0012383,7.1467E-4,5.5426E-4,6.3939E-4,6.3644E-4,0.0012383,7.1767E-4,5.6323E-4,6.3587E-4,6.3658E-4,0.0012297,7.1465E-4,5.6513E-4,6.3454E-4,6.3402E-4,0.001237,7.127E-4,5.5493E-4,6.3604E-4,6.3322E-4,0.0012288,0.0:1
-1.4993E-5,1.1617E-5,4.3667E-6,-8.5233E-6,1.3767E-5,-5.03E-6,9.4633E-6,6.64E-6,-8.7033E-6,9.39E-6,-5.4467E-6,1.2607E-5,3.5833E-6,-3.3733E-6,9.5833E-6,-9.3267E-6,1.6647E-5,-7.4333E-7,-1.5333E-7,1.2153E-5,-6.2433E-6,1.0977E-5,6.2833E-6,-4.18E-6,1.26E-5,-7.7333E-6,5.6667E-6,1.12E-6,-7.32E-6,1.0873E-5,-1.198E-5,9.8233E-6,2.7167E-6,6.0667E-7,1.0447E-5,-1.24E-5,7.8267E-6,8.7667E-7,-9.8667E-7,1.576E-5,-1.2097E-5,7.9567E-6,2.2267E-6,-9.9667E-6,1.2177E-5,-7.69E-6,1.338E-5,1.8167E-6,-8.7167E-6,7.5933E-6,-5.69E-6,8.7033E-6,3.0567E-6,-1.1633E-5,4.7667E-6,-9.1733E-6,1.3977E-5,4.3467E-6,6.6669E-9,1.3647E-5,-8.81E-6,1.2237E-5,3.9333E-6,-5.5233E-6,9.7033E-6,-1.207E-5,8.8967E-6,5.2433E-6,-3.2967E-6,1.185E-5,-7.6133E-6,1.0857E-5,-1.0167E-6,-1.8067E-6,1.047E-5,-6.8767E-6,8.1493E-4,0.0013451,8.493E-4,6.2299E-4,5.3877E-4,9.1023E-4,7.8025E-4,4.6006E-4,4.9004E-4,5.1895E-4,8.4261E-4,7.5693E-4,4.4821E-4,4.8303E-4,5.0661E-4,8.3624E-4,7.5525E-4,4.5032E-4,4.8098E-4,5.0604E-4,8.3001E-4,7.5796E-4,4.4472E-4,4.7954E-4,5.0413E-4,8.3673E-4,7.4866E-4,4.4486E-4,4.823E-4,5.046E-4,8.2571E-4,7.5461E-4,4.4383E-4,4.7568E-4,5.0269E-4,8.3989E-4,7.4309E-4,4.4753E-4,4.7609E-4,5.0017E-4,8.3222E-4,7.4423E-4,4.4983E-4,4.7542E-4,4.9957E-4,8.3514E-4,7.4895E-4,4.5075E-4,4.7902E-4,5.0527E-4,8.2473E-4,7.6474E-4,4.4248E-4,4.8042E-4,5.0035E-4,8.2591E-4,7.5841E-4,4.4449E-4,4.8297E-4,5.0234E-4,8.4191E-4,7.4965E-4,4.422E-4,4.7997E-4,4.968E-4,8.3617E-4,7.5315E-4,4.5017E-4,4.7755E-4,4.9487E-4,8.3351E-4,7.4651E-4,4.4562E-4,4.8321E-4,4.9941E-4,8.3446E-4,7.5034E-4,4.4285E-4,4.7902E-4,5.0375E-4,8.4064E-4,7.4631E-4,4.4346E-4,4.7394E-4,4.9793E-4,8.2904E-4,7.576E-4,4.44E-4,4.7683E-4,4.9684E-4,8.3332E-4,7.5524E-4,4.4664E-4,4.8221E-4,4.9704E-4,8.3014E-4,7.5911E-4,4.3771E-4,4.771E-4,5.0038E-4,8.3222E-4,7.5499E-4,4.4125E-4,4.7743E-4,5.0361E-4,8.3026E-4,7.5573E-4,4.4585E-4,4.7859E-4,5.0104E-4,8.3373E-4,7.5495E-4,4.4723E-4,4.7549E-4,5.008E-4,8.2922E-4,7.5548E-4,4.4856E-4,4.7501E-4,4.9349E-4,8.2792E-4,7.5729E-4,4.3961E-4,4.8406E-4,0.0:1
1.2833E-6,2.0E-7,3.3333E-7,1.6433E-6,-1.6667E-8,1.5867E-6,2.9E-7,2.4667E-7,2.2733E-6,-3.8667E-7,3.8348E-4,4.6114E-4,3.8631E-4,2.0409E-4,2.0266E-4,1.893E-4,2.5707E-4,3.4156E-4,1.8906E-4,1.8928E-4,1.8875E-4,2.4837E-4,3.3853E-4,1.8654E-4,1.8696E-4,1.8755E-4,2.4729E-4,3.3562E-4,1.8612E-4,1.8583E-4,1.8639E-4,2.4617E-4,3.3388E-4,1.837E-4,1.8701E-4,1.8438E-4,2.4885E-4,3.3425E-4,1.8121E-4,1.8538E-4,1.8466E-4,2.4629E-4,3.298E-4,1.8326E-4,1.8473E-4,1.8648E-4,2.4732E-4,3.3099E-4,1.8101E-4,1.846E-4,1.8429E-4,2.4945E-4,3.278E-4,1.7978E-4,1.8426E-4,1.836E-4,2.4822E-4,3.2742E-4,1.8152E-4,1.8426E-4,1.8323E-4,2.4693E-4,3.2799E-4,1.8156E-4,1.8453E-4,1.842E-4,2.4841E-4,3.2794E-4,1.81E-4,1.819E-4,1.8448E-4,2.4884E-4,3.2683E-4,1.8011E-4,1.8177E-4,1.8264E-4,2.4913E-4,3.2453E-4,1.81E-4,1.83E-4,1.8208E-4,2.497E-4,3.2372E-4,1.7808E-4,1.8308E-4,1.8294E-4,2.4967E-4,3.2534E-4,1.7769E-4,1.8187E-4,1.8249E-4,2.533E-4,3.2157E-4,1.7873E-4,1.821E-4,1.827E-4,2.5025E-4,3.2118E-4,1.7912E-4,1.8299E-4,1.8287E-4,2.5263E-4,3.191E-4,1.7641E-4,1.8167E-4,1.8212E-4,2.5106E-4,3.1934E-4,1.7588E-4,1.8274E-4,1.8147E-4,2.5361E-4,3.1593E-4,1.7615E-4,1.8387E-4,1.8216E-4,2.5377E-4,3.1664E-4,1.7751E-4,1.8248E-4,1.8182E-4,2.548E-4,3.1616E-4,1.7556E-4,1.8036E-4,1.8014E-4,2.5327E-4,3.1362E-4,1.7518E-4,1.8185E-4,1.8325E-4,2.5485E-4,3.1463E-4,1.7463E-4,1.8158E-4,1.7905E-4,2.5534E-4,3.1345E-4,1.7562E-4,1.8118E-4,1.8219E-4,2.5623E-4,3.1446E-4,1.7427E-4,1.8128E-4,1.8023E-4,2.5601E-4,3.1315E-4,1.7289E-4,1.8159E-4,1.8139E-4,2.5699E-4,3.1325E-4,1.7361E-4,1.8036E-4,1.8068E-4,2.5961E-4,3.1118E-4,1.7551E-4,1.7951E-4,1.8152E-4,2.5918E-4,3.1204E-4,1.7293E-4,1.8094E-4,1.8221E-4,2.589E-4,3.092E-4,1.7297E-4,1.8109E-4,1.8183E-4,2.5767E-4,3.1068E-4,1.7282E-4,1.8008E-4,1.8008E-4,2.5889E-4,3.0968E-4,1.718E-4,1.8227E-4,1.7962E-4,2.5814E-4,3.0669E-4,1.7086E-4,1.8058E-4,1.8003E-4,2.6085E-4,3.0743E-4,1.7234E-4,1.8053E-4,1.8081E-4,2.6042E-4,3.0788E-4,1.7157E-4,1.8074E-4,1.8057E-4,2.6182E-4,3.0431E-4,1.7262E-4,1.8048E-4,1.8067E-4,2.5975E-4,3.0605E-4,1.7155E-4,1.7968E-4,1.7947E-4,2.621E-4,3.0495E-4,1.7199E-4,1.7874E-4,1.805E-4,2.6465E-4,3.0453E-4,1.7371E-4,1.7976E-4,1.816E-4,2.6311E-4,3.0281E-4,1.7205E-4,1.8174E-4,1.809E-4,2.6247E-4,3.0242E-4,1.7069E-4,1.8058E-4,1.7793E-4,2.6395E-4,3.0319E-4,1.7039E-4,1.8013E-4,1.8037E-4,2.6486E-4,3.032E-4,1.7017E-4,1.8034E-4,1.7991E-4,2.6256E-4,3.0199E-4,1.6957E-4,1.8023E-4,1.8019E-4,2.6662E-4,3.0238E-4,1.7116E-4,1.7944E-4,1.7918E-4,2.6446E-4,3.0018E-4,1.704E-4,1.8034E-4,1.8083E-4,2.6432E-4,3.0084E-4,1.708E-4,1.8111E-4,1.7873E-4,2.6531E-4,2.9843E-4,1.7055E-4,1.7978E-4,1.7935E-4,2.6743E-4,2.9929E-4,1.6986E-4,1.8043E-4,1.7984E-4,2.6681E-4,2.9979E-4,1.6877E-4,1.8103E-4,1.7987E-4,2.6928E-4,2.9924E-4,1.6944E-4,1.8057E-4,1.8022E-4,2.6821E-4,2.9872E-4,1.6872E-4,1.8282E-4,1.8021E-4,2.6776E-4,2.9674E-4,1.6961E-4,1.8029E-4,1.7955E-4,2.7006E-4,2.9688E-4,1.6934E-4,1.8061E-4,1.7957E-4,2.6977E-4,2.9616E-4,1.6843E-4,1.7998E-4,1.8022E-4,2.7096E-4,2.9421E-4,1.6941E-4,1.8089E-4,1.7954E-4,2.6994E-4,2.9336E-4,1.6792E-4,1.8127E-4,1.7939E-4,2.7162E-4,2.9395E-4,1.6882E-4,1.8014E-4,1.7898E-4,2.7385E-4,2.9313E-4,1.6775E-4,1.8038E-4,1.7936E-4,2.7266E-4,2.9295E-4,1.691E-4,1.7972E-4,1.7922E-4,2.7254E-4,2.9189E-4,1.675E-4,1.807E-4,1.7831E-4,2.7083E-4,2.904E-4,1.6847E-4,1.7842E-4,1.7978E-4,2.7432E-4,2.8994E-4,1.6772E-4,1.8007E-4,1.7845E-4,2.7484E-4,2.9023E-4,1.6736E-4,1.7911E-4,1.7991E-4,2.7589E-4,2.9071E-4,1.6668E-4,1.7889E-4,1.8004E-4,2.7551E-4,2.899E-4,1.668E-4,1.8032E-4,1.8038E-4,2.7671E-4,2.9066E-4,1.6593E-4,1.7878E-4,1.7906E-4,2.7551E-4,2.8887E-4,1.6669E-4,1.8045E-4,1.7983E-4,2.7638E-4,2.8905E-4,1.6671E-4,1.8011E-4,1.787E-4,2.7726E-4,2.8901E-4,1.6501E-4,1.8076E-4,1.7814E-4,2.7942E-4,2.8751E-4,1.6755E-4,1.8071E-4,1.78E-4,2.7999E-4,2.8697E-4,1.6527E-4,1.8159E-4,1.7959E-4,2.7701E-4,2.8383E-4,-1.7313E-5:1
3.3E-7,2.19E-6,-2.1667E-7,5.7667E-7,-2.3667E-7,5.1E-7,3.7E-7,1.5533E-6,1.4367E-6,1.6667E-7,8.0667E-7,9.8667E-7,-1.9667E-7,1.2167E-6,-3.1E-7,3.6133E-6,1.37E-6,-1.61E-6,1.3667E-6,1.6667E-7,1.6533E-6,-3.3E-7,1.03E-6,9.8667E-7,2.1667E-7,6.8667E-7,1.2767E-6,5.3529E-4,2.9029E-4,2.7958E-4,1.9709E-4,3.2705E-4,3.0558E-4,1.801E-4,1.9455E-4,1.9344E-4,3.089E-4,2.9977E-4,1.7701E-4,1.9165E-4,1.9257E-4,3.0491E-4,2.9505E-4,1.7519E-4,1.9036E-4,1.8974E-4,3.0232E-4,2.9688E-4,1.7522E-4,1.8863E-4,1.908E-4,2.9997E-4,2.9367E-4,1.7612E-4,1.8852E-4,1.8956E-4,2.9932E-4,2.9409E-4,1.7524E-4,1.8945E-4,1.8903E-4,2.9775E-4,2.933E-4,1.753E-4,1.8754E-4,1.8761E-4,2.9834E-4,2.9427E-4,1.7301E-4,1.8846E-4,1.8958E-4,2.955E-4,2.9369E-4,1.7396E-4,1.8813E-4,1.8873E-4,2.9607E-4,2.9396E-4,1.721E-4,1.8684E-4,1.8779E-4,2.9543E-4,2.9554E-4,1.7578E-4,1.873E-4,1.8681E-4,2.9746E-4,2.948E-4,1.7169E-4,1.8745E-4,1.8916E-4,2.968E-4,2.9372E-4,1.743E-4,1.8844E-4,1.8731E-4,2.9241E-4,2.9421E-4,1.7329E-4,1.8855E-4,1.8742E-4,2.9313E-4,2.9391E-4,1.7367E-4,1.8682E-4,1.8632E-4,2.9356E-4,2.9428E-4,1.7224E-4,1.8786E-4,1.8714E-4,2.925E-4,2.9472E-4,1.7313E-4,1.8639E-4,1.8684E-4,2.9371E-4,2.9445E-4,1.7386E-4,1.8585E-4,1.8628E-4,2.9258E-4,2.9567E-4,1.7217E-4,1.8712E-4,1.8682E-4,2.9237E-4,2.9669E-4,1.7317E-4,1.8601E-4,1.8687E-4,2.9016E-4,2.962E-4,1.7358E-4,1.8688E-4,1.8542E-4,2.8979E-4,2.9657E-4,1.7504E-4,1.8766E-4,1.8693E-4,2.9145E-4,2.9642E-4,1.7399E-4,1.8591E-4,1.8633E-4,2.8808E-4,2.9643E-4,1.7343E-4,1.8769E-4,1.8527E-4,2.8867E-4,2.9704E-4,1.7386E-4,1.8488E-4,1.8554E-4,2.8744E-4,2.9792E-4,1.7216E-4,1.8587E-4,1.8579E-4,2.9041E-4,2.9578E-4,1.7451E-4,1.8511E-4,1.8715E-4,2.8757E-4,2.9846E-4,1.7277E-4,1.8799E-4,1.8616E-4,2.878E-4,2.9757E-4,1.7302E-4,1.8629E-4,1.8592E-4,2.8723E-4,2.9971E-4,1.7361E-4,1.862E-4,1.8546E-4,2.8818E-4,2.972E-4,1.7272E-4,1.8671E-4,1.8631E-4,2.8633E-4,2.9762E-4,1.7362E-4,1.8641E-4,1.8596E-4,2.8792E-4,2.9842E-4,1.7384E-4,1.8619E-4,1.8404E-4,2.8414E-4,2.9994E-4,1.735E-4,1.8702E-4,1.8601E-4,2.8657E-4,2.9999E-4,1.719E-4,1.8686E-4,1.8619E-4,2.8473E-4,2.9942E-4,1.7178E-4,1.8686E-4,1.8541E-4,2.8548E-4,2.9977E-4,1.7379E-4,1.8597E-4,1.8461E-4,2.8607E-4,2.987E-4,1.7442E-4,1.8508E-4,1.8589E-4,2.85E-4,3.0135E-4,1.7321E-4,1.8574E-4,1.8401E-4,2.8531E-4,2.9875E-4,1.7361E-4,1.848E-4,1.8589E-4,2.8629E-4,2.9905E-4,1.7338E-4,1.8625E-4,1.8505E-4,2.8553E-4,3.0004E-4,1.7408E-4,1.8468E-4,1.854E-4,2.8438E-4,2.9997E-4,1.7298E-4,1.8554E-4,1.8536E-4,2.8503E-4,3.005E-4,1.7375E-4,1.848E-4,1.8555E-4,2.8425E-4,2.9973E-4,1.7426E-4,1.859E-4,1.8495E-4,2.848E-4,3.0018E-4,1.7464E-4,1.8613E-4,1.8596E-4,2.8421E-4,2.9984E-4,1.7427E-4,1.8459E-4,1.8479E-4,2.838E-4,3.0084E-4,1.7325E-4,1.8671E-4,1.864E-4,2.8284E-4,3.0201E-4,1.7401E-4,1.8409E-4,1.8569E-4,2.8385E-4,3.0133E-4,1.7353E-4,1.8512E-4,0.0:1
-6.8333E-7,1.44E-6,4.9333E-7,1.0533E-6,9.3333E-7,-7.2333E-7,1.7167E-6,9.0E-8,1.68E-6,9.9667E-7,-2.5667E-7,3.2667E-7,-2.2333E-7,7.2667E-7,1.06E-6,-4.7E-7,1.4433E-6,-4.4E-7,1.02E-6,3.9E-7,-5.7667E-7,8.0333E-7,-4.4E-7,1.4133E-6,1.5E-7,-1.2E-6,1.21E-6,-6.6667E-7,8.8667E-7,7.9333E-7,1.5333E-7,2.1333E-7,3.0384E-4,1.5279E-4,1.7493E-4,1.0118E-4,9.744E-5,9.877E-5,1.2223E-4,1.8621E-4,1.0356E-4,9.5287E-5,1.0535E-4,1.295E-4,1.9404E-4,1.0942E-4,9.9137E-5,1.1437E-4,1.4264E-4,2.0461E-4,1.1816E-4,1.0717E-4,1.232E-4,1.6059E-4,2.1786E-4,1.2874E-4,1.1717E-4,1.371E-4,1.8247E-4,2.3789E-4,1.4644E-4,1.3166E-4,1.5244E-4,2.0866E-4,2.5811E-4,1.6633E-4,1.4773E-4,1.7102E-4,2.3616E-4,2.7908E-4,1.8525E-4,1.5577E-4,1.5167E-4,1.2999E-4,1.8565E-4,9.403E-5,8.6083E-5,9.1087E-5,9.3897E-5,1.7965E-4,9.0177E-5,8.3357E-5,9.171E-5,9.3527E-5,1.7865E-4,8.89E-5,8.2193E-5,9.0597E-5,9.0793E-5,1.7668E-4,8.7637E-5,8.1463E-5,8.9857E-5,9.1573E-5,1.7875E-4,8.712E-5,7.9747E-5,8.958E-5,8.999E-5,1.7809E-4,8.6717E-5,8.0017E-5,8.82E-5,8.7797E-5,1.7741E-4,8.6633E-5,7.8967E-5,8.7573E-5,8.8123E-5,1.7549E-4,8.556E-5,7.9167E-5,8.7803E-5,8.7393E-5,1.7582E-4,8.5287E-5,7.8233E-5,8.7087E-5,8.667E-5,1.7603E-4,8.584E-5,7.7347E-5,8.6697E-5,8.5563E-5,1.7479E-4,8.5703E-5,7.731E-5,8.5537E-5,8.4987E-5,1.7534E-4,8.3947E-5,7.738E-5,8.5143E-5,8.526E-5,1.7556E-4,8.4477E-5,7.6817E-5,8.62E-5,8.4943E-5,1.7604E-4,8.4037E-5,7.5963E-5,8.5373E-5,8.4763E-5,1.7331E-4,8.276E-5,7.6713E-5,8.4087E-5,8.5033E-5,1.7392E-4,8.2673E-5,7.6873E-5,8.5363E-5,8.4483E-5,1.7402E-4,8.439E-5,7.534E-5,8.4607E-5,8.4497E-5,1.7287E-4,8.4107E-5,7.62E-5,8.4827E-5,8.4207E-5,1.754E-4,8.5237E-5,7.5003E-5,8.495E-5,8.4917E-5,1.7373E-4,8.403E-5,7.5157E-5,8.378E-5,8.318E-5,1.7277E-4,8.3973E-5,7.621E-5,8.4363E-5,8.311E-5,1.7265E-4,8.375E-5,7.4883E-5,8.544E-5,8.4393E-5,1.7321E-4,8.2583E-5,7.548E-5,8.3303E-5,8.3967E-5,1.7226E-4,8.3677E-5,7.5447E-5,8.3323E-5,8.33E-5,1.722E-4,8.4503E-5,7.6193E-5,8.3887E-5,8.28E-5,1.7288E-4,8.3543E-5,7.4613E-5,8.286E-5,8.3273E-5,1.7233E-4,8.523E-5,7.4823E-5,8.2607E-5,8.3527E-5,1.7229E-4,8.363E-5,7.4793E-5,8.352E-5,8.4787E-5,1.7162E-4,8.4617E-5,7.524E-5,8.373E-5,8.3617E-5,1.7199E-4,8.5947E-5,7.418E-5,8.4103E-5,8.3583E-5,1.7089E-4,8.4147E-5,7.411E-5,8.2767E-5,8.3023E-5,1.6948E-4,8.491E-5,7.383E-5,8.304E-5,8.293E-5,1.7075E-4,8.5177E-5,7.2373E-5,8.4403E-5,8.266E-5,1.7016E-4,8.4097E-5,7.3037E-5,8.3063E-5,8.3117E-5,1.713E-4,8.5667E-5,7.297E-5,8.195E-5,8.3253E-5,1.7004E-4,8.383E-5,7.328E-5,8.367E-5,8.2867E-5,1.7135E-4,8.607E-5,7.2047E-5,8.2837E-5,8.292E-5,1.6798E-4,8.4363E-5,7.3953E-5,8.1213E-5,8.2363E-5,1.6842E-4,8.609E-5,7.2573E-5,8.3133E-5,8.2383E-5,1.679E-4,8.5203E-5,7.2247E-5,8.2193E-5,8.328E-5,1.6802E-4,8.6327E-5,7.206E-5,8.2693E-5,8.212E-5,1.6794E-4,8.7067E-5,7.3057E-5,8.262E-5,8.281E-5,1.6635E-4,8.5753E-5,7.2017E-5,8.203E-5,8.2047E-5,1.6832E-4,8.632E-5,7.1613E-5,8.1733E-5,8.2393E-5,1.6715E-4,8.7903E-5,7.248E-5,8.2037E-5,8.283E-5,1.6627E-4,8.768E-5,7.1363E-5,8.2057E-5,8.19E-5,1.6675E-4,8.7497E-5,7.6577E-5:1
-5.5E-7,1.0033E-6,1.2333E-7,1.1067E-6,1.2333E-7,-7.6E-7,1.3267E-6,8.9667E-7,-1.9533E-6,5.6E-7,-5.9E-7,7.9333E-7,6.2E-7,6.5667E-7,-6.0E-8,-3.8E-7,1.0833E-6,1.1867E-6,7.6667E-8,1.1167E-6,-2.3333E-8,1.4033E-6,8.2667E-7,6.0667E-7,8.7E-7,-1.3667E-7,1.05E-6,1.4233E-6,-3.3333E-7,9.2333E-7,1.0333E-7,6.6E-7,-5.5667E-7,-1.0033E-6,5.3333E-7,-3.6667E-7,1.5267E-6,1.76E-6,2.1667E-7,6.7333E-7,-1.9267E-6,1.2467E-6,1.0367E-6,-3.3333E-7,9.6667E-7,3.2E-7,1.68E-6,5.8E-7,-7.7667E-7,-2.1667E-7,1.3E-7,1.11E-6,-6.6667E-8,-7.8333E-7,1.1167E-6,-6.4333E-7,1.71E-6,7.5667E-7,-7.0667E-7,6.2E-7,-7.8333E-7,2.03E-6,2.5E-7,1.3333E-8,4.8E-7,-9.6E-7,1.2333E-7,5.8333E-7,2.2333E-7,5.2667E-7,-7.9E-7,8.9333E-7,5.5E-7,1.2067E-6,1.1133E-6,5.0667E-7,1.6E-7,8.9E-7,-1.1467E-6,7.0333E-7,-9.0667E-7,1.2367E-6,2.5333E-7,1.0667E-7,9.8E-7,-1.02E-6,8.3E-7,1.0933E-6,3.6E-7,1.3333E-7,-7.4667E-7,1.0667E-6,-1.8333E-7,-1.0967E-6,4.8E-7,-1.4433E-6,6.4667E-7,3.5667E-7,-9.6E-7,7.7333E-7,3.3667E-7,1.1067E-6,1.9567E-6,5.2333E-7,1.63E-6,-6.8E-7,1.5067E-6,1.26E-6,-7.7E-7,2.9667E-7,-1.2767E-6,1.26E-6,1.15E-6,2.4253E-14,1.1367E-6,-2.7333E-7,1.21E-6,3.2729E-4,1.777E-4,1.138E-4,1.5202E-4,1.6081E-4,2.6077E-4,1.6033E-4,1.3827E-4,1.5512E-4,1.9621E-4,2.8024E-4,1.8048E-4,1.5574E-4,1.7476E-4,2.3029E-4,3.0526E-4,2.017E-4,1.6816E-4,1.896E-4,2.4375E-4,3.0531E-4,1.9446E-4,1.5849E-4,1.6506E-4,1.3957E-4,2.1998E-4,1.0968E-4,9.5127E-5,1.0141E-4,1.0014E-4,1.9462E-4,1.0314E-4,9.037E-5,9.848E-5,9.791E-5,1.9253E-4,9.9763E-5,9.045E-5,9.5133E-5,9.5373E-5,1.8936E-4,1.0053E-4,8.756E-5,9.6967E-5,9.595E-5,1.9062E-4,1.0078E-4,8.681E-5,9.59E-5,9.529E-5,1.8691E-4,9.9807E-5,8.6433E-5,9.5443E-5,9.4697E-5,1.8893E-4,9.8923E-5,8.5137E-5,9.462E-5,9.4457E-5,1.8712E-4,1.0062E-4,8.488E-5,9.3887E-5,9.371E-5,1.8753E-4,9.7263E-5,8.456E-5,9.2853E-5,9.3377E-5,1.8516E-4,9.724E-5,8.349E-5,9.1957E-5,9.351E-5,1.8474E-4,9.6233E-5,8.4177E-5,9.2253E-5,9.3607E-5,1.8298E-4,9.7087E-5,8.3547E-5,9.127E-5,9.1117E-5,1.8377E-4,9.6567E-5,8.2123E-5,9.0553E-5,9.163E-5,1.8332E-4,9.6847E-5,8.2503E-5,9.0863E-5,9.1227E-5,1.8075E-4,9.796E-5,8.0673E-5,9.1087E-5,9.1643E-5,1.8063E-4,9.7497E-5,8.1527E-5,9.1497E-5,9.0007E-5,1.8E-4,9.857E-5,8.105E-5,9.1747E-5,8.9923E-5,1.8031E-4,9.7583E-5,8.0913E-5,9.0027E-5,9.0477E-5,1.7998E-4,9.7103E-5,8.098E-5,9.0737E-5,9.076E-5,1.7767E-4,9.7477E-5,7.9777E-5,8.889E-5,9.0203E-5,1.8027E-4,9.8307E-5,7.968E-5,8.8493E-5,9.0463E-5,1.7822E-4,9.8793E-5,7.9437E-5,8.936E-5,9.0857E-5,1.7866E-4,9.8263E-5,7.9193E-5,8.9717E-5,8.8867E-5,1.79E-4,9.877E-5,7.9523E-5,8.836E-5,8.9743E-5,1.776E-4,9.855E-5,8.0643E-5,8.7773E-5,9.0023E-5,1.7613E-4,9.9157E-5,7.9003E-5,8.8513E-5,8.942E-5,1.7555E-4,9.9433E-5,7.8803E-5,8.8663E-5,8.8763E-5,1.7564E-4,9.8353E-5,7.8703E-5,8.856E-5,8.8643E-5,1.7488E-4,9.932E-5,7.8677E-5,8.8277E-5,8.9717E-5,1.7444E-4,1.0145E-4,7.9007E-5,8.9263E-5,8.9247E-5,1.7471E-4,1.019E-4,7.7837E-5,8.6443E-5,8.9803E-5,1.7257E-4,1.0091E-4,7.7707E-5,8.7373E-5,8.905E-5,1.7368E-4,1.0096E-4,7.786E-5,8.8403E-5,8.8947E-5,1.7209E-4,9.998E-5,7.687E-5,8.7807E-5,8.7927E-5,1.727E-4,1.0239E-4,7.8543E-5,8.6947E-5,8.795E-5,1.7226E-4,1.0208E-4,7.748E-5,8.7337E-5,8.887E-5,1.7087E-4,1.0158E-4,7.6277E-5,8.7057E-5,8.9277E-5,1.7186E-4,1.0374E-4,7.811E-5,8.656E-5,8.8273E-5,1.7205E-4,1.0273E-4,7.708E-5,8.7117E-5,8.6557E-5,1.713E-4,1.0288E-4,7.8097E-5,8.7007E-5,8.859E-5,1.693E-4,1.0324E-4,7.6833E-5,8.7963E-5,8.794E-5,1.7091E-4,1.0477E-4,7.69E-5,8.8093E-5,8.7277E-5,1.689E-4,1.0574E-4,7.704E-5,8.7183E-5,8.72E-5,1.6952E-4,1.0651E-4,7.578E-5,8.7243E-5,8.828E-5,1.6864E-4,1.0493E-4,7.5533E-5,8.6233E-5,8.7857E-5,1.6891E-4,1.0709E-4,7.6073E-5,8.6537E-5,8.6997E-5,1.6834E-4,1.0546E-4,7.6013E-5,8.7083E-5,8.7927E-5,1.6578E-4,1.0771E-4,7.5517E-5,8.615E-5,8.8333E-5,1.6552E-4,1.064E-4,7.562E-5,8.549E-5,8.7083E-5,1.6698E-4,1.0856E-4,7.675E-5,8.5083E-5,8.841E-5,1.6697E-4,1.081E-4,7.6353E-5,8.607E-5,8.8177E-5,1.6665E-4,1.0752E-4,7.4993E-5,0.0:1
8.6333E-7,5.6E-7,-1.7333E-7,3.3334E-9,-3.9333E-7,5.8667E-7,1.3167E-6,-1.2E-7,1.9267E-6,-2.6333E-7,-4.8506E-14,7.1E-7,-5.2E-7,9.7667E-7,2.6E-7,4.6333E-7,1.2967E-6,-5.3667E-7,1.7133E-6,7.6667E-7,6.6667E-7,5.6E-7,-1.55E-6,1.3367E-6,-1.5667E-7,4.7E-7,1.4233E-6,1.2667E-7,7.3E-7,-7.4667E-7,1.36E-6,6.3667E-7,-8.6333E-7,1.1833E-6,-1.0E-6,1.4967E-6,-2.1333E-7,-7.5667E-7,-3.3334E-9,-2.2E-7,9.5333E-7,1.2433E-6,-8.3667E-7,6.5667E-7,-4.4333E-7,4.8E-7,1.6133E-6,-5.8667E-7,6.4E-7,-1.06E-6,1.2533E-6,1.2533E-6,4.3667E-7,1.29E-6,-2.5333E-7,2.6333E-7,5.0E-7,-6.6667E-8,9.9333E-7,-3.3667E-7,-7.0E-8,6.3333E-8,-1.0667E-7,3.0667E-7,1.8E-7,1.0833E-6,2.5667E-7,6.8333E-7,1.1567E-6,6.0E-8,1.76E-6,2.3667E-7,6.0667E-7,9.7333E-7,-3.6333E-7,4.7743E-4,1.3724E-4,1.4751E-4,1.3468E-4,2.309E-4,2.3823E-4,1.471E-4,1.5695E-4,1.6456E-4,2.6539E-4,2.7016E-4,1.7232E-4,1.7493E-4,1.8247E-4,2.8299E-4,2.7273E-4,1.6757E-4,1.6987E-4,1.714E-4,2.3072E-4,1.9636E-4,9.1993E-5,9.1233E-5,9.4147E-5,1.2616E-4,1.6735E-4,8.459E-5,8.851E-5,9.3237E-5,1.2321E-4,1.6914E-4,8.3647E-5,8.656E-5,9.06E-5,1.1788E-4,1.6754E-4,8.1963E-5,8.456E-5,9.0213E-5,1.1545E-4,1.6852E-4,8.167E-5,8.549E-5,8.812E-5,1.1265E-4,1.6973E-4,8.02E-5,8.3837E-5,8.8913E-5,1.1068E-4,1.7261E-4,8.073E-5,8.3127E-5,8.9033E-5,1.0959E-4,1.7124E-4,8.1433E-5,8.3087E-5,8.8793E-5,1.0689E-4,1.7284E-4,8.22E-5,8.436E-5,8.8833E-5,1.0265E-4,1.7588E-4,8.06E-5,8.2463E-5,8.8657E-5,9.862E-5,1.783E-4,8.1743E-5,8.224E-5,8.7283E-5,9.8437E-5,1.7952E-4,8.031E-5,8.1777E-5,8.6733E-5,9.557E-5,1.8091E-4,8.0513E-5,8.1233E-5,8.6963E-5,9.3603E-5,1.8149E-4,8.0083E-5,8.1663E-5,8.662E-5,9.1983E-5,1.8268E-4,8.1927E-5,8.303E-5,8.7197E-5,9.0833E-5,1.8351E-4,8.13E-5,8.182E-5,8.7233E-5,9.1247E-5,1.8407E-4,8.1863E-5,8.0973E-5,8.681E-5,8.978E-5,1.8489E-4,8.2127E-5,8.034E-5,8.616E-5,8.9457E-5,1.8421E-4,8.2313E-5,8.1503E-5,8.621E-5,9.1127E-5,1.8388E-4,8.1803E-5,8.0823E-5,8.601E-5,9.0763E-5,1.8411E-4,8.3143E-5,8.095E-5,8.5597E-5,8.854E-5,1.8279E-4,8.284E-5,8.103E-5,8.5423E-5,8.918E-5,1.843E-4,8.2247E-5,7.9287E-5,8.5297E-5,9.0767E-5,1.8356E-4,8.4017E-5,7.9577E-5,8.515E-5,9.0053E-5,1.8304E-4,8.559E-5,7.894E-5,8.5933E-5,9.0383E-5,1.8334E-4,8.3853E-5,7.965E-5,8.6077E-5,9.0137E-5,1.8182E-4,8.412E-5,7.9157E-5,8.4747E-5,8.9247E-5,1.8264E-4,8.5527E-5,7.982E-5,8.4313E-5,9.04E-5,1.8192E-4,8.593E-5,8.127E-5,8.376E-5,8.993E-5,1.8201E-4,8.6617E-5,7.8833E-5,8.5467E-5,8.9507E-5,1.8061E-4,8.5847E-5,7.9557E-5,8.5233E-5,8.817E-5,1.796E-4,8.788E-5,7.9343E-5,8.517E-5,8.9143E-5,1.7896E-4,8.9007E-5,7.995E-5,8.5297E-5,8.7713E-5,1.767E-4,8.9197E-5,7.946E-5,8.417E-5,8.887E-5,1.7906E-4,9.05E-5,7.859E-5,8.5E-5,8.9113E-5,1.7776E-4,8.915E-5,7.792E-5,8.4627E-5,8.8253E-5,1.7658E-4,9.0287E-5,7.847E-5,8.3723E-5,8.823E-5,1.7615E-4,9.1217E-5,7.864E-5,8.4233E-5,8.827E-5,1.7715E-4,9.198E-5,7.7213E-5,8.34E-5,8.977E-5,1.7584E-4,9.2593E-5,7.9957E-5,8.3537E-5,9.0527E-5,1.7528E-4,9.4237E-5,7.829E-5,8.3317E-5,8.8933E-5,1.736E-4,9.4693E-5,7.908E-5,8.468E-5,8.853E-5,1.738E-4,9.5333E-5,7.6847E-5,8.237E-5,8.9193E-5,1.726E-4,9.6547E-5,7.7093E-5,8.431E-5,8.8063E-5,1.7177E-4,9.8517E-5,7.7133E-5,8.3923E-5,8.8527E-5,1.6995E-4,9.8053E-5,7.7193E-5,8.492E-5,8.7963E-5,1.7024E-4,9.984E-5,7.654E-5,8.3467E-5,8.8793E-5,1.699E-4,1.0049E-4,7.659E-5,-8.2667E-7:1
8.3667E-7,6.1667E-7,3.4E-7,4.6667E-7,3.3E-7,2.3333E-7,9.2333E-7,8.1333E-7,8.8667E-7,-2.3E-7,5.7667E-7,4.0333E-7,9.1E-7,1.4733E-6,5.8E-7,5.5333E-7,-1.1667E-7,1.5367E-6,6.8667E-7,8.4E-7,2.5333E-7,4.1333E-7,9.3667E-7,5.1667E-7,-2.8E-7,7.9667E-7,4.3667E-7,6.5333E-7,7.6667E-7,9.1333E-7,8.1333E-7,2.4E-7,5.8E-7,7.5E-7,1.55E-6,-1.0333E-7,1.0433E-6,5.5E-7,8.4E-7,2.0524E-4,2.6424E-4,2.8354E-4,1.5607E-4,9.892E-5,1.0868E-4,1.0844E-4,1.9147E-4,1.4202E-4,9.226E-5,1.0438E-4,1.0382E-4,1.8653E-4,1.4134E-4,9.047E-5,1.0421E-4,1.0286E-4,1.8619E-4,1.3917E-4,8.9983E-5,1.0162E-4,1.0189E-4,1.8319E-4,1.3826E-4,8.922E-5,1.0106E-4,1.0149E-4,1.8243E-4,1.384E-4,8.8087E-5,1.0092E-4,1.0082E-4,1.8313E-4,1.372E-4,8.8433E-5,1.0024E-4,1.0016E-4,1.8138E-4,1.3695E-4,8.7703E-5,9.9907E-5,9.9827E-5,1.825E-4,1.3575E-4,8.707E-5,9.9363E-5,1.003E-4,1.8079E-4,1.3505E-4,8.6467E-5,1.002E-4,9.962E-5,1.804E-4,1.3431E-4,8.698E-5,9.9123E-5,9.8E-5,1.7863E-4,1.3472E-4,8.7307E-5,9.9473E-5,9.9453E-5,1.7944E-4,1.3421E-4,8.5983E-5,9.8817E-5,9.8403E-5,1.7973E-4,1.3316E-4,8.5817E-5,9.8773E-5,9.9147E-5,1.8103E-4,1.3296E-4,8.4697E-5,9.819E-5,9.7903E-5,1.7941E-4,1.34E-4,8.5387E-5,9.7823E-5,9.7793E-5,1.8013E-4,1.3225E-4,8.451E-5,9.8633E-5,9.7827E-5,1.7956E-4,1.3229E-4,8.6103E-5,9.7063E-5,9.7137E-5,1.7894E-4,1.3179E-4,8.4317E-5,9.6737E-5,9.772E-5,1.7775E-4,1.3202E-4,8.495E-5,9.742E-5,9.76E-5,1.782E-4,1.3197E-4,8.3967E-5,9.802E-5,9.7197E-5,1.7855E-4,1.3141E-4,8.507E-5,9.7197E-5,9.7767E-5,1.7732E-4,1.3062E-4,8.4587E-5,9.706E-5,9.791E-5,1.7724E-4,1.3068E-4,8.515E-5,9.593E-5,9.8057E-5,1.7821E-4,1.2977E-4,8.3247E-5,9.6767E-5,9.6927E-5,1.7787E-4,1.302E-4,8.3557E-5,9.7853E-5,9.81E-5,1.7734E-4,1.3013E-4,8.2747E-5,9.7013E-5,9.6797E-5,1.7722E-4,1.3026E-4,8.2627E-5,9.6487E-5,9.67E-5,1.771E-4,1.3048E-4,8.319E-5,9.631E-5,9.713E-5,1.7676E-4,1.2973E-4,8.2827E-5,9.636E-5,9.7197E-5,1.7842E-4,1.3023E-4,8.214E-5,9.4853E-5,9.6613E-5,1.7793E-4,1.297E-4,8.2603E-5,9.4183E-5,9.6407E-5,1.7616E-4,1.2971E-4,8.191E-5,9.6927E-5,9.609E-5,1.7777E-4,1.2982E-4,8.2747E-5,9.7367E-5,9.75E-5,1.7646E-4,1.2962E-4,8.303E-5,9.548E-5,9.627E-5,1.7677E-4,1.2979E-4,8.2917E-5,9.6607E-5,9.5827E-5,1.756E-4,1.2975E-4,8.1527E-5,9.5467E-5,9.7037E-5,1.7624E-4,1.2848E-4,8.1797E-5,9.4677E-5,9.551E-5,1.7739E-4,1.2811E-4,8.195E-5,9.5947E-5,9.6257E-5,1.7767E-4,1.2942E-4,8.2497E-5,9.619E-5,9.596E-5,1.7544E-4,1.2988E-4,8.2433E-5,9.6193E-5,9.6503E-5,1.773E-4,1.2949E-4,8.2187E-5,9.5817E-5,9.6273E-5,1.7768E-4,1.2862E-4,8.157E-5,9.5323E-5,9.5827E-5,1.7725E-4,1.2822E-4,8.13E-5,9.544E-5,9.6113E-5,1.7733E-4,1.2907E-4,8.157E-5,9.5353E-5,9.643E-5,1.7846E-4,1.2856E-4,8.1903E-5,9.5487E-5,9.5817E-5,1.7685E-4,1.2922E-4,8.196E-5,9.5797E-5,9.543E-5,1.7583E-4,1.2758E-4,8.1903E-5,9.4027E-5,9.534E-5,1.7596E-4,1.2731E-4,8.1487E-5,9.5493E-5,9.6097E-5,1.7684E-4,1.284E-4,8.2387E-5,9.5673E-5,9.5713E-5,1.769E-4,1.2774E-4,8.2057E-5,9.557E-5,9.6037E-5,1.7698E-4,1.281E-4,8.128E-5,9.5867E-5,9.679E-5,1.7627E-4,1.2849E-4,8.1677E-5,9.605E-5,9.603E-5,1.7468E-4,1.2827E-4,8.3063E-5,9.5197E-5,9.6117E-5,1.7768E-4,1.2818E-4,8.2023E-5,9.5053E-5,9.5407E-5,1.7552E-4,1.2756E-4,8.1653E-5,9.5343E-5,9.4593E-5,1.77E-4,1.2707E-4,8.1817E-5,9.5817E-5,9.5607E-5,1.7631E-4,1.2789E-4,8.1473E-5,9.5617E-5,9.5567E-5,1.7732E-4,1.2797E-4,8.1543E-5,9.457E-5,9.5953E-5,1.7732E-4,1.2745E-4,8.1187E-5,9.4863E-5,9.556E-5,1.7734E-4,1.2814E-4,8.2177E-5,9.547E-5,9.5877E-5,1.7611E-4,1.2835E-4,7.9717E-5,9.4643E-5,9.5073E-5,1.7687E-4,1.281E-4,8.1687E-5,9.4527E-5,9.494E-5,1.773E-4,1.2708E-4,8.1303E-5,9.4807E-5,9.4903E-5,1.7704E-4,1.2753E-4,8.152E-5,9.5643E-5,9.5127E-5,1.7932E-4,1.2707E-4,8.1223E-5,9.4977E-5,9.5393E-5,1.7781E-4,1.2679E-4,8.1717E-5,9.5137E-5,9.52E-5,1.7785E-4,1.2631E-4,8.2507E-5,9.5263E-5,9.6263E-5,1.7708E-4,1.2796E-4,8.1463E-5,9.643E-5,9.6567E-5,1.7691E-4,1.2633E-4,8.2083E-5,9.5E-5,9.5897E-5,1.7844E-4,1.2751E-4,-1.547E-5:1
1.22E-6,3.8333E-7,2.0E-8,4.5E-7,3.6667E-7,5.0333E-7,1.3433E-6,1.9E-7,1.8267E-6,1.4633E-6,1.1167E-6,1.4633E-6,1.4567E-6,8.7E-7,5.8333E-7,1.1933E-6,5.5E-7,7.2667E-7,1.7E-6,2.9E-7,6.8E-7,7.5667E-7,6.6333E-7,4.2E-7,2.1667E-7,4.2E-7,5.6E-7,8.6667E-7,1.6533E-6,1.26E-6,1.9E-7,1.69E-6,5.4E-7,7.5333E-7,6.1E-7,-1.3333E-8,8.6667E-8,9.8667E-7,8.0E-7,5.1333E-7,2.5285E-4,3.3236E-4,2.0194E-4,1.1457E-4,1.1212E-4,1.1391E-4,1.7048E-4,1.8085E-4,1.0919E-4,1.0953E-4,1.1059E-4,1.6865E-4,1.7693E-4,1.0627E-4,1.0851E-4,1.1016E-4,1.6665E-4,1.7572E-4,1.0559E-4,1.0598E-4,1.0971E-4,1.6504E-4,1.737E-4,1.0453E-4,1.0621E-4,1.0828E-4,1.6241E-4,1.7406E-4,1.0456E-4,1.0518E-4,1.0745E-4,1.6272E-4,1.7152E-4,1.0218E-4,1.0448E-4,1.0694E-4,1.6145E-4,1.7079E-4,1.0222E-4,1.0557E-4,1.0613E-4,1.6193E-4,1.7201E-4,1.0211E-4,1.0421E-4,1.0489E-4,1.6115E-4,1.6987E-4,1.0073E-4,1.0356E-4,1.0603E-4,1.6009E-4,1.7207E-4,1.0169E-4,1.0355E-4,1.0671E-4,1.6055E-4,1.6979E-4,9.9233E-5,1.0345E-4,1.057E-4,1.5995E-4,1.6951E-4,1.0174E-4,1.0409E-4,1.0387E-4,1.604E-4,1.6789E-4,9.9187E-5,1.026E-4,1.0511E-4,1.5921E-4,1.691E-4,9.899E-5,1.0224E-4,1.0456E-4,1.599E-4,1.686E-4,1.0037E-4,1.0162E-4,1.0396E-4,1.6036E-4,1.6711E-4,9.9083E-5,1.0152E-4,1.0353E-4,1.5832E-4,1.683E-4,9.9547E-5,1.0172E-4,1.0324E-4,1.5972E-4,1.6622E-4,9.8943E-5,1.0044E-4,1.0363E-4,1.5745E-4,1.6734E-4,9.814E-5,1.0198E-4,1.0294E-4,1.5828E-4,1.6616E-4,9.7397E-5,1.013E-4,1.0226E-4,1.5777E-4,1.6635E-4,9.941E-5,9.9997E-5,1.0376E-4,1.5776E-4,1.6638E-4,9.9367E-5,1.0079E-4,1.0283E-4,1.5815E-4,1.6609E-4,9.7523E-5,9.9793E-5,1.0293E-4,1.563E-4,1.6611E-4,9.773E-5,1.01E-4,1.0296E-4,1.5776E-4,1.6599E-4,9.74E-5,9.9857E-5,1.0234E-4,1.5757E-4,1.6679E-4,9.8147E-5,9.9967E-5,1.0147E-4,1.5698E-4,1.6631E-4,9.7137E-5,9.957E-5,1.0189E-4,1.5732E-4,1.6567E-4,9.6937E-5,1.0034E-4,1.0113E-4,1.5676E-4,1.6555E-4,9.5897E-5,1.0077E-4,1.0199E-4,1.5722E-4,1.6734E-4,9.7227E-5,9.931E-5,1.0165E-4,1.5647E-4,1.646E-4,9.6473E-5,9.936E-5,1.0227E-4,1.5737E-4,1.6506E-4,9.561E-5,9.9707E-5,1.015E-4,1.5681E-4,1.6537E-4,9.532E-5,1.0017E-4,1.0136E-4,1.5587E-4,1.6503E-4,9.5713E-5,9.8703E-5,1.0205E-4,1.5574E-4,1.6469E-4,9.5937E-5,9.9617E-5,1.0104E-4,1.5656E-4,1.6505E-4,9.612E-5,1.0106E-4,1.0128E-4,1.5675E-4,1.6526E-4,9.6877E-5,9.9217E-5,1.0174E-4,1.55E-4,1.6489E-4,9.6627E-5,9.9393E-5,1.0239E-4,1.5647E-4,1.646E-4,9.5743E-5,9.8483E-5,1.0115E-4,1.5618E-4,1.6306E-4,9.6137E-5,9.912E-5,1.014E-4,1.5514E-4,1.6335E-4,9.5663E-5,9.8647E-5,1.0142E-4,1.5605E-4,1.642E-4,9.6157E-5,9.8933E-5,1.005E-4,1.5614E-4,1.6383E-4,9.6573E-5,9.8943E-5,1.0239E-4,1.5638E-4,1.6327E-4,9.618E-5,9.9427E-5,1.0122E-4,1.5576E-4,1.6438E-4,9.576E-5,9.8147E-5,1.0182E-4,1.5583E-4,1.6275E-4,9.4543E-5,9.7357E-5,1.0025E-4,1.565E-4,1.632E-4,9.5077E-5,9.9187E-5,1.0175E-4,1.5704E-4,1.6361E-4,9.3907E-5,9.937E-5,1.0095E-4,1.5472E-4,1.6264E-4,9.5233E-5,9.9137E-5,1.0117E-4,1.5569E-4,1.6348E-4,9.4703E-5,9.8577E-5,1.008E-4,1.5534E-4,1.6508E-4,9.3813E-5,9.7823E-5,1.0088E-4,1.5669E-4,1.6278E-4,9.5377E-5,9.8843E-5,1.0095E-4,1.5486E-4,1.6219E-4,9.5E-5,9.802E-5,9.9333E-5,1.5603E-4,1.6222E-4,9.354E-5,9.801E-5,1.0087E-4,1.5513E-4,1.6235E-4,9.4703E-5,9.9E-5,1.011E-4,1.5464E-4,1.604E-4,9.6627E-5,9.9747E-5,1.0118E-4,1.5476E-4,1.6302E-4,9.3443E-5,9.7757E-5,9.9853E-5,1.5466E-4,1.6321E-4,9.3717E-5,9.6883E-5,1.0136E-4,1.5501E-4,1.6372E-4,9.4427E-5,9.863E-5,1.0084E-4,1.5489E-4,1.6373E-4,9.4707E-5,9.772E-5,1.0028E-4,1.5473E-4,1.626E-4,9.5207E-5,9.791E-5,1.0059E-4,1.5553E-4,1.6381E-4,9.2933E-5,9.8993E-5,1.0094E-4,1.5612E-4,1.6316E-4,9.4127E-5,9.8777E-5,9.9433E-5,1.5505E-4,1.6311E-4,9.496E-5,9.822E-5,1.0069E-4,1.5463E-4,1.6074E-4,9.433E-5,9.7777E-5,1.0041E-4,1.5579E-4,1.6244E-4,9.5137E-5,9.7703E-5,1.0006E-4,1.5536E-4,1.6192E-4,9.4363E-5,9.9193E-5,1.0036E-4,1.549E-4,1.6283E-4,9.5217E-5,9.7203E-5,1.0015E-4,1.557E-4,1.6151E-4,9.3507E-5,9.8137E-5,1.0061E-4,1.5547E-4,1.6287E-4,9.3313E-5,9.891E-5,1.0116E-4,1.5498E-4,1.6246E-4,9.4227E-5,9.79E-5,1.0123E-4,1.5575E-4,1.624E-4,9.4603E-5,9.92E-5,1.0113E-4,1.567E-4,1.604E-4,9.5043E-5,9.8807E-5,1.0075E-4,1.5701E-4,1.6153E-4,-1.2117E-5:1
-2.92E-6,-4.0267E-6,-4.9733E-6,-5.26E-6,-4.61E-6,-3.1367E-6,-4.8933E-6,-4.73E-6,-6.07E-6,-4.13E-6,-3.83E-6,-5.2067E-6,-4.86E-6,-5.7967E-6,-4.0633E-6,-2.85E-6,-4.7167E-6,1.9996E-4,3.7763E-4,3.5682E-4,3.3833E-4,4.1032E-4,2.0963E-4,1.9381E-4,1.8911E-4,2.1031E-4,3.8684E-4,2.0364E-4,1.8797E-4,1.8499E-4,2.0723E-4,3.8268E-4,2.0016E-4,1.8477E-4,1.812E-4,2.0418E-4,3.825E-4,2.0123E-4,1.8323E-4,1.8146E-4,2.0285E-4,3.7935E-4,1.9989E-4,1.8207E-4,1.8224E-4,2.0239E-4,3.783E-4,1.9863E-4,1.8139E-4,1.8162E-4,2.0461E-4,3.7845E-4,2.031E-4,1.8382E-4,1.8093E-4,2.0199E-4,3.7897E-4,2.0163E-4,1.809E-4,1.8053E-4,2.0246E-4,3.7647E-4,2.0143E-4,1.8225E-4,1.8238E-4,1.9964E-4,3.7656E-4,2.0107E-4,1.8252E-4,1.8076E-4,2.0128E-4,3.7502E-4,2.0181E-4,1.809E-4,1.8037E-4,1.9951E-4,3.7328E-4,2.0287E-4,1.8129E-4,1.7881E-4,2.0172E-4,3.7131E-4,2.0439E-4,1.8073E-4,1.8029E-4,1.9921E-4,3.7551E-4,2.0317E-4,1.7985E-4,1.7842E-4,2.0034E-4,3.7398E-4,2.0288E-4,1.8129E-4,1.7953E-4,2.0127E-4,3.7097E-4,2.034E-4,1.7877E-4,1.7801E-4,2.0043E-4,3.696E-4,2.0419E-4,1.8001E-4,1.7859E-4,1.981E-4,3.6936E-4,2.0681E-4,1.7994E-4,1.7894E-4,1.9889E-4,3.6937E-4,2.0534E-4,1.7914E-4,1.7986E-4,1.9818E-4,3.6795E-4,2.0848E-4,1.7936E-4,1.7878E-4,1.9964E-4,3.6793E-4,2.0686E-4,1.8127E-4,1.7894E-4,1.9721E-4,3.6833E-4,2.0684E-4,1.801E-4,1.7832E-4,1.9861E-4,3.682E-4,2.072E-4,1.7909E-4,1.7868E-4,1.9886E-4,3.663E-4,2.0923E-4,1.7911E-4,1.7788E-4,1.9735E-4,3.6606E-4,2.0979E-4,1.7862E-4,1.7828E-4,1.9836E-4,3.634E-4,2.1053E-4,1.7699E-4,1.7797E-4,1.9729E-4,3.6514E-4,2.1246E-4,1.7766E-4,1.7817E-4,1.9803E-4,3.6399E-4,2.129E-4,1.7977E-4,1.7798E-4,1.9781E-4,3.6242E-4,2.138E-4,1.7859E-4,1.7523E-4,1.9774E-4,3.6093E-4,2.1218E-4,1.7786E-4,1.7686E-4,1.9785E-4,3.6095E-4,2.1245E-4,1.7759E-4,1.7666E-4,1.9734E-4,3.5776E-4,2.1699E-4,1.7702E-4,1.7597E-4,1.9512E-4,3.5746E-4,2.1721E-4,1.7781E-4,1.7749E-4,1.9693E-4,3.5598E-4,2.169E-4,1.7747E-4,1.7592E-4,1.9843E-4,3.5745E-4,2.1913E-4,1.7646E-4,1.7623E-4,1.9624E-4,3.5484E-4,2.2014E-4,1.7552E-4,1.7601E-4,1.9639E-4,3.5469E-4,2.1939E-4,1.7582E-4,1.7853E-4,1.9672E-4,3.5343E-4,2.2218E-4,1.7688E-4,1.7681E-4,1.9505E-4,3.5125E-4,2.2213E-4,1.7607E-4,1.7583E-4,1.9608E-4,3.5214E-4,2.2205E-4,1.749E-4,1.7589E-4,1.9716E-4,3.5198E-4,2.2384E-4,1.7804E-4,1.7477E-4,1.9516E-4,3.4771E-4,2.2561E-4,1.7542E-4,1.7566E-4,1.9711E-4,3.4945E-4,2.2503E-4,1.7698E-4,1.756E-4,1.9403E-4,3.4434E-4,2.3007E-4,1.7563E-4,1.7474E-4,1.9514E-4,3.4419E-4,2.2826E-4,1.7607E-4,1.7647E-4,1.9731E-4,3.4508E-4,2.3147E-4,1.7551E-4,1.7525E-4,1.9598E-4,3.4409E-4,2.3275E-4,1.7549E-4,1.7334E-4,1.9789E-4,3.412E-4,2.3767E-4,1.8044E-4,1.784E-4,1.9851E-4,3.4457E-4,2.356E-4,1.7742E-4,1.7557E-4,1.9735E-4,3.4401E-4,2.3691E-4,1.7957E-4,1.7601E-4,1.9606E-4,3.409E-4,2.4018E-4,1.7975E-4,1.759E-4,1.9612E-4,3.3791E-4,2.4136E-4,1.782E-4,1.7634E-4,1.9653E-4,3.3894E-4,2.4491E-4,1.7812E-4,1.7683E-4,1.972E-4,3.3576E-4,2.4421E-4,1.78E-4,1.7492E-4,1.9806E-4,3.3509E-4,2.4668E-4,1.8042E-4,1.7758E-4,1.9687E-4,3.3315E-4,2.4805E-4,1.7942E-4,1.7506E-4,1.9747E-4,3.3081E-4,2.4966E-4,1.7904E-4,1.7505E-4,1.973E-4,3.3025E-4,2.5148E-4,1.7866E-4,1.7646E-4,1.9822E-4,3.2796E-4,2.5356E-4,1.8039E-4,1.7486E-4,1.9771E-4,3.2629E-4,2.5557E-4,1.8054E-4,1.7557E-4,1.9722E-4,3.2342E-4,2.5646E-4,1.7964E-4,1.7551E-4,1.9759E-4,3.2485E-4,2.5976E-4,1.812E-4,1.735E-4,1.9753E-4,3.2127E-4,2.6152E-4,1.7856E-4,1.7581E-4,1.9741E-4,3.1931E-4,2.5616E-4,1.7896E-4,1.7647E-4,1.9713E-4,3.1632E-4,2.6144E-4,1.7766E-4,1.7607E-4,1.9842E-4,3.1414E-4,2.5906E-4,1.7901E-4,1.7625E-4,1.966E-4,3.1012E-4,2.6663E-4,1.785E-4,1.7521E-4,1.9606E-4,3.0801E-4,2.6922E-4,1.7874E-4,1.7363E-4,1.9674E-4,3.0688E-4,2.7064E-4,1.778E-4,1.727E-4,1.9689E-4,3.0647E-4,2.7288E-4,1.7935E-4,1.7276E-4,1.9637E-4,3.0374E-4,2.7352E-4,1.7857E-4,1.7192E-4,1.9576E-4,3.0071E-4,2.7741E-4,1.778E-4,1.7424E-4,1.9501E-4,3.0179E-4,2.7649E-4,1.8002E-4,1.7367E-4,1.9517E-4,2.9857E-4,2.8065E-4,1.8029E-4,1.7247E-4,1.9531E-4,2.9536E-4,2.8143E-4,1.7938E-4,1.7332E-4,1.9653E-4,2.946E-4,2.8266E-4,1.7959E-4,1.7282E-4,1.9461E-4,2.9207E-4,2.8617E-4,1.7988E-4,1.7266E-4,1.9457E-4,2.9234E-4,2.8855E-4,1.8076E-4,1.7217E-4,1.9563E-4,2.8825E-4,2.8849E-4,1.8073E-4,1.7193E-4,1.9563E-4,2.8601E-4,2.9052E-4,1.8009E-4,1.7199E-4,0.0:1
-4.21E-6,-4.0467E-6,-3.4533E-6,-5.9067E-6,-2.29E-6,-3.6267E-6,-5.0633E-6,-3.0267E-6,-6.3E-6,-3.1267E-6,-4.0533E-6,-3.87E-6,-2.69E-6,-5.64E-6,-2.8467E-6,-4.0733E-6,-3.3033E-6,-4.4867E-6,-4.8E-6,-2.5E-6,-4.3633E-6,-3.9333E-6,-3.8967E-6,-6.1067E-6,-2.85E-6,-3.4E-6,-3.4033E-6,-4.0667E-6,-6.61E-6,-3.2867E-6,-4.4433E-6,-3.5033E-6,-4.0567E-6,-5.7033E-6,-2.36E-6,-4.5867E-6,-2.5967E-6,-4.03E-6,-5.7033E-6,-3.4133E-6,-4.3667E-6,-3.59E-6,-4.4833E-6,-5.93E-6,-3.19E-6,-4.67E-6,-3.37E-6,-4.4333E-6,-5.99E-6,1.4783E-4,5.5392E-4,6.146E-4,3.4723E-4,2.114E-4,2.1601E-4,2.2575E-4,3.8116E-4,2.11E-4,1.7352E-4,1.9881E-4,2.0502E-4,3.731E-4,2.0535E-4,1.6833E-4,1.9714E-4,2.0005E-4,3.7124E-4,2.0506E-4,1.6772E-4,1.9421E-4,1.994E-4,3.7383E-4,2.0623E-4,1.6798E-4,1.9602E-4,1.9547E-4,3.7565E-4,2.0726E-4,1.6683E-4,1.9429E-4,1.9404E-4,3.756E-4,2.076E-4,1.6804E-4,1.9578E-4,1.9447E-4,3.7585E-4,2.0825E-4,1.6622E-4,1.9365E-4,1.9335E-4,3.763E-4,2.0759E-4,1.6652E-4,1.9694E-4,1.9459E-4,3.7787E-4,2.0947E-4,1.6688E-4,1.9338E-4,1.9195E-4,3.7896E-4,2.1086E-4,1.6806E-4,1.9505E-4,1.8961E-4,3.7863E-4,2.1141E-4,1.6676E-4,1.9433E-4,1.9052E-4,3.7969E-4,2.1202E-4,1.667E-4,1.9249E-4,1.8948E-4,3.7876E-4,2.1271E-4,1.6738E-4,1.9403E-4,1.8976E-4,3.7606E-4,2.1292E-4,1.6666E-4,1.9435E-4,1.9028E-4,3.7695E-4,2.1455E-4,1.6691E-4,1.9326E-4,1.8997E-4,3.7956E-4,2.1388E-4,1.6714E-4,1.9414E-4,1.9012E-4,3.7347E-4,2.1626E-4,1.6602E-4,1.9206E-4,1.8939E-4,3.7586E-4,2.1678E-4,1.6539E-4,1.9307E-4,1.9002E-4,3.7402E-4,2.153E-4,1.67E-4,1.9286E-4,1.8893E-4,3.7486E-4,2.1497E-4,1.6702E-4,1.9335E-4,1.8724E-4,3.7324E-4,2.1736E-4,1.6551E-4,1.9326E-4,1.8624E-4,3.705E-4,2.1747E-4,1.6549E-4,1.9273E-4,1.8698E-4,3.7287E-4,2.1823E-4,1.6557E-4,1.9249E-4,1.8819E-4,3.7113E-4,2.1972E-4,1.6502E-4,1.9278E-4,1.8891E-4,3.7318E-4,2.1991E-4,1.6624E-4,1.926E-4,1.8827E-4,3.687E-4,2.218E-4,1.6488E-4,1.9064E-4,1.8741E-4,3.6587E-4,2.2123E-4,1.6422E-4,1.9191E-4,1.882E-4,3.6756E-4,2.2165E-4,1.6426E-4,1.8918E-4,1.8816E-4,3.6599E-4,2.2035E-4,1.649E-4,1.9075E-4,1.8798E-4,3.6679E-4,2.2311E-4,1.6427E-4,1.9087E-4,1.8632E-4,3.6449E-4,2.2414E-4,1.6403E-4,1.8981E-4,1.8712E-4,3.6612E-4,2.2464E-4,1.6363E-4,1.9109E-4,1.8798E-4,3.6377E-4,2.2506E-4,1.6245E-4,1.9188E-4,1.8737E-4,3.6245E-4,2.269E-4,1.6234E-4,1.9088E-4,1.87E-4,3.6325E-4,2.2641E-4,1.6272E-4,1.8956E-4,1.8803E-4,3.6212E-4,2.2654E-4,1.6282E-4,1.898E-4,1.8639E-4,3.6274E-4,2.2927E-4,1.6299E-4,1.91E-4,1.8652E-4,3.6113E-4,2.2977E-4,1.6443E-4,1.9087E-4,1.8575E-4,3.603E-4,2.3169E-4,1.6249E-4,1.8964E-4,1.871E-4,3.5845E-4,2.3162E-4,1.6203E-4,1.8978E-4,1.8589E-4,3.5571E-4,2.3131E-4,1.6287E-4,1.8934E-4,1.8608E-4,3.5664E-4,2.3498E-4,1.6238E-4,1.9102E-4,1.862E-4,3.5671E-4,2.3476E-4,1.6322E-4,1.8954E-4,1.8585E-4,3.5428E-4,2.3561E-4,1.6239E-4,1.8804E-4,1.858E-4,3.5515E-4,2.3795E-4,1.6097E-4,1.9024E-4,1.8662E-4,3.5266E-4,2.3865E-4,1.6241E-4,1.886E-4,1.8438E-4,3.5104E-4,2.3881E-4,1.6285E-4,1.8867E-4,1.8573E-4,3.5006E-4,2.4354E-4,1.6194E-4,1.8993E-4,1.8506E-4,3.4976E-4,2.4193E-4,1.6285E-4,1.8891E-4,1.8583E-4,3.4766E-4,2.437E-4,1.6268E-4,1.8901E-4,1.8641E-4,3.4719E-4,2.4598E-4,1.6186E-4,1.8895E-4,1.8645E-4,3.4447E-4,2.4653E-4,1.6168E-4,1.8977E-4,1.8555E-4,3.4496E-4,2.4827E-4,1.62E-4,1.881E-4,1.8589E-4,3.4106E-4,2.507E-4,1.6318E-4,1.8672E-4,1.8519E-4,3.4108E-4,2.5392E-4,1.6338E-4,1.8963E-4,1.8574E-4,3.3785E-4,2.5412E-4,1.6397E-4,1.8848E-4,1.8494E-4,3.3831E-4,2.5698E-4,1.6363E-4,1.8588E-4,1.8483E-4,3.3697E-4,2.5604E-4,1.6291E-4,1.8908E-4,1.8459E-4,3.3246E-4,2.5926E-4,1.6474E-4,1.8732E-4,1.8357E-4,3.3458E-4,2.6089E-4,1.6205E-4,1.9005E-4,1.8439E-4,3.3019E-4,2.6358E-4,1.6237E-4,1.8758E-4,1.8502E-4,3.2806E-4,2.646E-4,1.631E-4,1.8732E-4,1.8417E-4,3.2817E-4,2.6856E-4,1.6231E-4,1.8743E-4,1.8487E-4,3.2432E-4,2.699E-4,1.6438E-4,1.877E-4,1.8431E-4,3.2254E-4,2.7105E-4,1.6278E-4,1.8629E-4,1.8525E-4,3.2185E-4,2.7228E-4,1.6416E-4,1.89E-4,1.8593E-4,3.1858E-4,2.7569E-4,1.6378E-4,1.8773E-4,1.8429E-4,3.1649E-4,2.7837E-4,1.6381E-4,1.8778E-4,1.8474E-4,3.1318E-4,2.7971E-4,1.6375E-4,1.8615E-4,1.8527E-4,3.1281E-4,2.8109E-4,1.6742E-4,1.9085E-4,1.8749E-4,3.1341E-4,2.8498E-4,1.6356E-4,1.8904E-4,1.8683E-4,3.1215E-4,2.852E-4,1.6556E-4,1.8875E-4,1.8477E-4,3.0699E-4,2.8999E-4,1.654E-4,1.8881E-4,1.8449E-4,3.0826E-4,2.9149E-4,1.659E-4,1.8848E-4,1.8675E-4,3.055E-4,2.9305E-4,1.6503E-4,1.8783E-4,1.8548E-4,3.0301E-4,2.9233E-4,1.6676E-4,1.881E-4,1.8565E-4,3.0293E-4,2.9767E-4,1.6764E-4,1.8788E-4,1.855E-4,2.9724E-4,2.9912E-4,1.6779E-4,1.8644E-4,1.8487E-4,2.9724E-4,3.0057E-4,1.6551E-4,1.8831E-4,1.855E-4,2.9483E-4,3.0156E-4,1.681E-4,1.8597E-4,1.8487E-4,2.922E-4,3.0412E-4,1.671E-4,1.8663E-4,1.843E-4,2.897E-4,3.0618E-4,1.6828E-4,1.8828E-4,1.8581E-4,2.8983E-4,3.0609E-4,1.6723E-4,1.8626E-4,1.8442E-4,2.8835E-4,3.0821E-4,1.6807E-4,1.8684E-4,1.8396E-4,2.8461E-4,3.1132E-4,1.6851E-4,1.8701E-4,1.8486E-4,2.839E-4,3.1418E-4,1.6809E-4,1.8759E-4,1.8395E-4,2.8194E-4,3.1341E-4,1.6773E-4,1.8735E-4,0.0:1
-2.3133E-6,3.1667E-6,9.3333E-7,-3.7667E-6,5.7433E-6,-3.9533E-6,4.55E-6,-6.7667E-7,-4.3E-7,3.7933E-6,-4.4133E-6,1.26E-6,1.0533E-6,-2.6467E-6,5.1067E-6,-9.0667E-7,4.52E-6,8.1333E-7,-2.62E-6,3.17E-6,-4.54E-6,2.7333E-6,1.4633E-6,-2.94E-6,4.6267E-6,-1.15E-6,3.2767E-6,7.5E-7,-7.5667E-7,5.8067E-6,-2.25E-6,5.89E-6,-8.5E-7,-3.4867E-6,3.3033E-6,-3.6433E-6,6.8667E-6,1.6867E-6,-3.98E-6,4.47E-6,-2.29E-6,4.74E-6,5.5376E-4,4.2702E-4,4.1114E-4,4.0368E-4,7.5672E-4,4.9061E-4,3.7275E-4,3.9728E-4,4.5425E-4,7.6331E-4,5.1055E-4,3.9201E-4,4.1086E-4,4.8705E-4,7.8344E-4,5.3304E-4,4.0957E-4,4.2473E-4,5.1849E-4,8.0693E-4,5.594E-4,4.2851E-4,4.4558E-4,5.5307E-4,8.3497E-4,5.7877E-4,4.5058E-4,4.6543E-4,5.8654E-4,8.5644E-4,6.0205E-4,4.6804E-4,4.8276E-4,6.1541E-4,8.7818E-4,6.2415E-4,4.8575E-4,4.9551E-4,6.3628E-4,8.2072E-4,5.5926E-4,3.8411E-4,3.6491E-4,3.8223E-4,6.8757E-4,4.5701E-4,3.3481E-4,3.5251E-4,3.7101E-4,6.7991E-4,4.5294E-4,3.3612E-4,3.546E-4,3.6802E-4,6.7979E-4,4.5662E-4,3.3366E-4,3.4964E-4,3.684E-4,6.7285E-4,4.5776E-4,3.3184E-4,3.4724E-4,3.6583E-4,6.7201E-4,4.5683E-4,3.3282E-4,3.4729E-4,3.6383E-4,6.687E-4,4.599E-4,3.3259E-4,3.463E-4,3.6471E-4,6.6843E-4,4.5902E-4,3.3091E-4,3.4804E-4,3.6689E-4,6.6374E-4,4.6159E-4,3.3306E-4,3.4835E-4,3.6198E-4,6.6065E-4,4.6343E-4,3.3069E-4,3.4254E-4,3.6209E-4,6.5676E-4,4.6557E-4,3.3028E-4,3.464E-4,3.6334E-4,6.5467E-4,4.6457E-4,3.3201E-4,3.4353E-4,3.6001E-4,6.4984E-4,4.6536E-4,3.2967E-4,3.4381E-4,3.5978E-4,6.4897E-4,4.6748E-4,3.2991E-4,3.4325E-4,3.5742E-4,6.4891E-4,4.6928E-4,3.2912E-4,3.4195E-4,3.5964E-4,6.4365E-4,4.7131E-4,3.3013E-4,3.4144E-4,3.6116E-4,6.4137E-4,4.6923E-4,3.3205E-4,3.414E-4,3.5932E-4,6.4103E-4,4.7335E-4,3.2979E-4,3.4041E-4,3.5848E-4,6.3822E-4,4.7309E-4,3.2872E-4,3.3839E-4,3.5876E-4,6.3435E-4,4.751E-4,3.2891E-4,3.4011E-4,3.5981E-4,6.3047E-4,4.7907E-4,3.3294E-4,3.3953E-4,3.563E-4,6.3001E-4,4.7747E-4,3.3249E-4,3.3582E-4,3.5725E-4,6.2452E-4,4.7827E-4,3.3005E-4,3.3611E-4,3.5493E-4,6.2462E-4,4.8153E-4,3.2781E-4,3.3916E-4,3.5637E-4,6.2217E-4,4.8274E-4,3.2816E-4,3.3683E-4,3.5709E-4,6.1977E-4,4.8068E-4,3.2985E-4,3.3694E-4,3.5593E-4,6.175E-4,4.8117E-4,3.3156E-4,3.3766E-4,3.5472E-4,6.1613E-4,4.8358E-4,3.2843E-4,3.3397E-4,3.5548E-4,6.1289E-4,4.8427E-4,3.3131E-4,3.3388E-4,3.5441E-4,6.1087E-4,4.8794E-4,3.2843E-4,3.332E-4,3.5303E-4,6.0653E-4,4.8856E-4,3.3024E-4,3.3513E-4,3.5424E-4,6.0779E-4,4.9096E-4,3.3025E-4,3.3386E-4,3.5538E-4,6.0598E-4,4.9243E-4,3.3152E-4,3.3155E-4,3.5417E-4,6.0147E-4,4.9114E-4,3.3038E-4,3.3274E-4,3.4998E-4,5.9767E-4,4.9698E-4,3.3221E-4,3.3497E-4,3.5285E-4,5.9507E-4,4.9899E-4,3.3013E-4,3.3055E-4,3.526E-4,5.9604E-4,4.965E-4,3.3375E-4,3.3274E-4,3.5377E-4,5.9509E-4,5.0038E-4,3.2782E-4,3.3013E-4,3.5145E-4,5.9028E-4,5.0187E-4,3.3139E-4,3.3263E-4,3.5016E-4,5.8938E-4,5.0212E-4,3.3223E-4,3.319E-4,3.5108E-4,5.8381E-4,5.048E-4,3.2997E-4,3.3076E-4,3.5045E-4,5.8276E-4,5.0604E-4,3.3323E-4,3.2798E-4,3.495E-4,5.8046E-4,5.062E-4,3.3257E-4,3.3235E-4,3.5065E-4,5.7938E-4,5.0761E-4,3.3497E-4,3.2911E-4,3.4964E-4,5.7672E-4,5.0909E-4,3.3418E-4,3.289E-4,3.5115E-4,5.7609E-4,5.084E-4,3.338E-4,3.3023E-4,3.4793E-4,5.7071E-4,5.115E-4,3.3576E-4,3.3003E-4,3.4731E-4,5.711E-4,5.0935E-4,3.3518E-4,3.2854E-4,3.4769E-4,5.6837E-4,5.1399E-4,3.3534E-4,3.3137E-4,3.495E-4,5.6447E-4,5.1764E-4,3.3558E-4,3.2746E-4,3.4895E-4,5.6274E-4,5.1698E-4,3.3424E-4,3.2889E-4,3.4938E-4,5.6383E-4,5.1827E-4,3.3659E-4,3.2749E-4,3.4526E-4,5.6048E-4,5.1824E-4,3.3853E-4,3.2703E-4,3.4994E-4,5.6137E-4,5.2072E-4,3.3724E-4,3.2668E-4,3.4732E-4,5.5477E-4,5.2082E-4,3.4089E-4,3.2659E-4,3.4646E-4,5.5423E-4,5.2188E-4,3.3887E-4,3.2459E-4,3.4737E-4,5.493E-4,5.2518E-4,3.3937E-4,3.2626E-4,3.4733E-4,5.5027E-4,5.2536E-4,3.3681E-4,3.2562E-4,3.4662E-4,5.5004E-4,5.2914E-4,3.4057E-4,3.2568E-4,3.4617E-4,5.4846E-4,5.3008E-4,3.3918E-4,3.2543E-4,3.4817E-4,5.4362E-4,5.2912E-4,3.4086E-4,3.2267E-4,3.4699E-4,5.4433E-4,5.299E-4,3.3922E-4,3.2458E-4,0.0:1
3.9967E-6,1.1533E-6,-3.5733E-6,3.8967E-6,-2.3167E-6,3.8467E-6,2.1867E-6,-1.39E-6,4.2667E-6,-1.15E-6,5.1233E-6,2.97E-6,-2.6367E-6,7.4433E-6,-3.4233E-6,7.7333E-7,3.34E-6,-1.5833E-6,2.68E-6,-1.1767E-6,3.4767E-6,4.8E-6,-2.37E-6,5.892E-5,5.4636E-4,7.0131E-4,5.2634E-4,4.8743E-4,5.0518E-4,8.2477E-4,8.1181E-4,5.7122E-4,5.0768E-4,5.358E-4,8.4559E-4,8.2605E-4,5.7474E-4,5.1337E-4,5.4533E-4,8.5888E-4,8.3708E-4,5.7499E-4,5.167E-4,5.5436E-4,8.6703E-4,8.4009E-4,5.487E-4,4.2227E-4,4.3667E-4,6.4814E-4,6.2321E-4,3.8267E-4,3.485E-4,3.5969E-4,5.1642E-4,6.0876E-4,3.7653E-4,3.3642E-4,3.6246E-4,5.0664E-4,6.1093E-4,3.746E-4,3.36E-4,3.6081E-4,5.0406E-4,6.0997E-4,3.7619E-4,3.3305E-4,3.5802E-4,5.0338E-4,6.0548E-4,3.7461E-4,3.3161E-4,3.6151E-4,5.0141E-4,6.0784E-4,3.7592E-4,3.3201E-4,3.5832E-4,4.9723E-4,6.0844E-4,3.7374E-4,3.2843E-4,3.5565E-4,4.9547E-4,6.0389E-4,3.7045E-4,3.315E-4,3.5334E-4,4.8738E-4,6.0867E-4,3.716E-4,3.2746E-4,3.5124E-4,4.819E-4,6.0937E-4,3.6913E-4,3.2692E-4,3.5252E-4,4.8289E-4,6.107E-4,3.6926E-4,3.2906E-4,3.5429E-4,4.7653E-4,6.1076E-4,3.7206E-4,3.2545E-4,3.518E-4,4.7802E-4,6.1018E-4,3.731E-4,3.2617E-4,3.5096E-4,4.7623E-4,6.1054E-4,3.7513E-4,3.2626E-4,3.5037E-4,4.7193E-4,6.1531E-4,3.7265E-4,3.2693E-4,3.5134E-4,4.738E-4,6.1604E-4,3.705E-4,3.2469E-4,3.5032E-4,4.7172E-4,6.1584E-4,3.7607E-4,3.2423E-4,3.5014E-4,4.6792E-4,6.1632E-4,3.7662E-4,3.2534E-4,3.5003E-4,4.6819E-4,6.2016E-4,3.7714E-4,3.2708E-4,3.5279E-4,4.6438E-4,6.1693E-4,3.7696E-4,3.2511E-4,3.5337E-4,4.6273E-4,6.2128E-4,3.7724E-4,3.23E-4,3.4935E-4,4.6077E-4,6.2054E-4,3.7901E-4,3.2644E-4,3.5122E-4,4.603E-4,6.2217E-4,3.7795E-4,3.2338E-4,3.481E-4,4.5862E-4,6.247E-4,3.7896E-4,3.2495E-4,3.5177E-4,4.5815E-4,6.2799E-4,3.7956E-4,3.2299E-4,3.493E-4,4.534E-4,6.2905E-4,3.8231E-4,3.2387E-4,3.4937E-4,4.5052E-4,6.3183E-4,3.8039E-4,3.2568E-4,3.4943E-4,4.4995E-4,6.3213E-4,3.8285E-4,3.2246E-4,3.5076E-4,4.4593E-4,6.3662E-4,3.8451E-4,3.2429E-4,3.4767E-4,4.4786E-4,6.3149E-4,3.8457E-4,3.2229E-4,3.5126E-4,4.4481E-4,6.3673E-4,3.8229E-4,3.2389E-4,3.4906E-4,4.42E-4,6.3554E-4,3.8477E-4,3.2131E-4,3.5136E-4,4.4211E-4,6.3671E-4,3.8903E-4,3.2341E-4,3.4765E-4,4.3978E-4,6.3558E-4,3.8745E-4,3.2277E-4,3.4825E-4,4.3626E-4,6.4139E-4,3.8787E-4,3.2593E-4,3.5035E-4,4.3478E-4,6.4159E-4,3.8818E-4,3.2206E-4,3.4951E-4,4.3249E-4,6.4008E-4,3.9196E-4,3.2245E-4,3.4989E-4,4.3088E-4,6.4136E-4,3.9291E-4,3.2274E-4,3.4758E-4,4.3222E-4,6.424E-4,3.9154E-4,3.235E-4,3.4976E-4,4.2688E-4,6.4454E-4,3.9514E-4,3.2318E-4,3.4984E-4,4.2355E-4,6.4634E-4,3.92E-4,3.2038E-4,3.4897E-4,4.2312E-4,6.4585E-4,3.9443E-4,3.221E-4,3.4916E-4,4.2446E-4,6.4879E-4,3.9468E-4,3.2219E-4,3.4541E-4,4.1947E-4,6.4765E-4,3.9765E-4,3.187E-4,3.4756E-4,4.1897E-4,6.5033E-4,3.9908E-4,3.2159E-4,3.4584E-4,4.1786E-4,6.5065E-4,3.9701E-4,3.2184E-4,3.4678E-4,4.1744E-4,6.5353E-4,3.9684E-4,3.2227E-4,3.4672E-4,4.1235E-4,6.5478E-4,3.9899E-4,3.2022E-4,3.4738E-4,4.0965E-4,6.5565E-4,4.0039E-4,3.2046E-4,3.4778E-4,4.095E-4,6.5791E-4,4.011E-4,3.1983E-4,3.4742E-4,4.0436E-4,6.5836E-4,4.038E-4,3.1886E-4,3.4767E-4,4.052E-4,6.625E-4,4.0487E-4,3.1929E-4,3.4604E-4,4.0202E-4,6.6105E-4,4.0546E-4,3.2349E-4,3.46E-4,4.0004E-4,6.6547E-4,4.0531E-4,3.1988E-4,3.4609E-4,3.9808E-4,6.6382E-4,4.0849E-4,3.222E-4,3.1637E-5:1
3.4567E-6,-2.5467E-6,3.73E-6,3.3E-7,2.4667E-7,4.4333E-7,-1.2067E-6,4.6067E-6,1.1567E-6,3.2667E-7,1.2033E-6,-1.2333E-6,4.9067E-6,-2.6667E-7,-6.0333E-7,4.1167E-6,-2.5033E-6,4.7933E-6,-2.4767E-6,-2.2333E-7,1.9467E-6,-2.76E-6,6.1733E-6,8.4333E-7,-3.4E-7,1.3033E-6,-1.8067E-6,4.5067E-6,7.8333E-7,-1.4833E-6,3.8367E-6,-2.0967E-6,2.3133E-6,6.6333E-7,-8.1333E-7,3.06E-6,-4.8567E-6,6.5167E-6,-6.6E-7,6.1E-7,3.9233E-6,-3.3267E-6,4.62E-6,3.14E-6,1.35E-6,4.4967E-6,-3.18E-6,5.13E-6,1.11E-6,-5.2667E-7,3.2067E-6,-2.9933E-6,4.8767E-6,-1.7967E-6,6.7667E-7,3.2967E-6,-2.88E-6,6.51E-6,-2.7567E-6,2.5E-7,3.13E-6,-2.1167E-6,4.0067E-6,-7.2E-7,1.4E-7,1.7867E-6,-2.0533E-6,5.0067E-6,-6.1333E-7,1.42E-6,3.2067E-6,-2.7033E-6,4.1233E-6,5.6667E-7,1.6933E-6,5.1867E-6,-3.4233E-6,4.6133E-6,-1.5567E-6,-7.2333E-7,3.24E-6,-3.8367E-6,3.7667E-6,-1.6333E-7,-1.5267E-6,1.9867E-6,6.0283E-4,8.0609E-4,8.3106E-4,6.2506E-4,4.9386E-4,5.4329E-4,7.9596E-4,8.6075E-4,6.3402E-4,4.9707E-4,5.4619E-4,8.1356E-4,8.6386E-4,6.4506E-4,5.0621E-4,5.5431E-4,8.1802E-4,8.7072E-4,6.5025E-4,5.0706E-4,5.5353E-4,6.629E-4,7.789E-4,4.4935E-4,3.9001E-4,4.36E-4,4.8334E-4,6.7247E-4,4.3328E-4,3.4104E-4,3.7311E-4,4.7334E-4,6.5983E-4,4.322E-4,3.4261E-4,3.7078E-4,4.7121E-4,6.6251E-4,4.2671E-4,3.3954E-4,3.7096E-4,4.7013E-4,6.5954E-4,4.2857E-4,3.3746E-4,3.6943E-4,4.6309E-4,6.6141E-4,4.267E-4,3.3908E-4,3.6932E-4,4.6195E-4,6.6157E-4,4.2403E-4,3.3705E-4,3.6614E-4,4.637E-4,6.6281E-4,4.2397E-4,3.3711E-4,3.662E-4,4.5759E-4,6.6309E-4,4.2728E-4,3.3584E-4,3.6468E-4,4.5803E-4,6.5754E-4,4.251E-4,3.334E-4,3.6215E-4,4.5848E-4,6.5783E-4,4.2394E-4,3.3422E-4,3.6235E-4,4.5306E-4,6.5845E-4,4.2182E-4,3.312E-4,3.6387E-4,4.4945E-4,6.5429E-4,4.2223E-4,3.3122E-4,3.612E-4,4.487E-4,6.5474E-4,4.2373E-4,3.2815E-4,3.6357E-4,4.4761E-4,6.573E-4,4.2425E-4,3.3286E-4,3.6247E-4,4.4878E-4,6.5953E-4,4.2195E-4,3.3052E-4,3.6088E-4,4.4866E-4,6.5509E-4,4.2753E-4,3.313E-4,3.6032E-4,4.4602E-4,6.5952E-4,4.2238E-4,3.3086E-4,3.6032E-4,4.4711E-4,6.6143E-4,4.2357E-4,3.3077E-4,3.6102E-4,4.4391E-4,6.6188E-4,4.2341E-4,3.2852E-4,3.631E-4,4.4232E-4,6.6272E-4,4.2657E-4,3.3026E-4,3.5961E-4,4.4222E-4,6.6073E-4,4.2335E-4,3.281E-4,3.6017E-4,4.4333E-4,6.6096E-4,4.2242E-4,3.2874E-4,3.6138E-4,4.4112E-4,6.6282E-4,4.2391E-4,3.2868E-4,3.6013E-4,4.3792E-4,6.6157E-4,4.2682E-4,3.3009E-4,3.578E-4,4.3939E-4,6.6625E-4,4.235E-4,3.3039E-4,3.6026E-4,4.3706E-4,6.6438E-4,4.2496E-4,3.2839E-4,3.5873E-4,4.3559E-4,6.6276E-4,4.2431E-4,3.2997E-4,3.5789E-4,4.3636E-4,6.6479E-4,4.269E-4,3.3313E-4,3.586E-4,4.3327E-4,6.6758E-4,4.2529E-4,3.2808E-4,3.5748E-4,4.3235E-4,6.6425E-4,4.2578E-4,3.2857E-4,3.5807E-4,4.3274E-4,6.6655E-4,4.2731E-4,3.279E-4,3.5731E-4,4.2876E-4,6.6772E-4,4.3069E-4,3.2806E-4,3.5789E-4,4.2959E-4,6.7051E-4,4.2789E-4,3.2978E-4,3.5875E-4,4.2886E-4,6.6906E-4,4.2923E-4,3.2929E-4,3.5892E-4,4.2907E-4,6.7316E-4,4.2669E-4,3.2668E-4,3.6038E-4,4.2555E-4,6.6917E-4,4.3119E-4,3.2868E-4,3.5982E-4,4.2362E-4,6.7101E-4,4.3005E-4,3.2762E-4,3.586E-4,4.2587E-4,6.6988E-4,4.2727E-4,3.2915E-4,3.5713E-4,4.2513E-4,6.7377E-4,4.2972E-4,3.2565E-4,3.5792E-4,4.2332E-4,6.7366E-4,4.3049E-4,3.296E-4,3.5961E-4,4.2078E-4,6.7502E-4,4.2643E-4,3.2775E-4,3.5566E-4,4.2026E-4,6.7529E-4,4.2744E-4,3.2803E-4,3.5875E-4,4.177E-4,6.7574E-4,4.3113E-4,3.2872E-4,3.6078E-4,4.1831E-4,6.7686E-4,4.3241E-4,3.2894E-4,3.6057E-4,4.178E-4,6.7763E-4,4.3079E-4,3.2603E-4,3.5566E-4,4.1425E-4,6.7842E-4,4.3289E-4,3.2784E-4,3.5573E-4,4.1203E-4,6.8244E-4,4.3189E-4,3.2614E-4,3.5632E-4,4.1444E-4,6.7827E-4,4.329E-4,3.2779E-4,3.5758E-4,4.118E-4,6.819E-4,4.346E-4,3.273E-4,3.5806E-4,4.109E-4,6.8184E-4,4.333E-4,3.2659E-4,3.5856E-4,4.0916E-4,6.8086E-4,4.3295E-4,3.2602E-4,3.5982E-4,4.0941E-4,6.8436E-4,4.3298E-4,3.2767E-4,3.5801E-4,4.09E-4,6.8466E-4,4.362E-4,3.2607E-4,3.5818E-4,4.0755E-4,6.8627E-4,4.362E-4,3.2621E-4,3.5659E-4,4.0699E-4,6.8778E-4,4.3543E-4,3.2492E-4,3.5774E-4,4.0613E-4,6.8311E-4,4.3884E-4,3.2942E-4,3.5859E-4,4.0536E-4,6.8653E-4,4.3399E-4,3.257E-4,3.5874E-4,4.0144E-4,6.8876E-4,4.3464E-4,3.2634E-4,3.5585E-4,4.0151E-4,6.8535E-4,4.3553E-4,3.2852E-4,3.5938E-4,4.0165E-4,6.8835E-4,4.3625E-4,3.271E-4,3.5611E-4,4.001E-4,6.8753E-4,4.3789E-4,3.2672E-4,3.5772E-4,3.9841E-4,6.8868E-4,4.39E-4,3.2785E-4,3.564E-4,3.9918E-4,6.8881E-4,4.3973E-4,3.2843E-4,3.5703E-4,3.9813E-4,6.9011E-4,4.3776E-4,3.278E-4,3.575E-4,3.9404E-4,6.9344E-4,4.373E-4,3.2674E-4,3.562E-4,3.9622E-4,6.9095E-4,4.3485E-4,3.2772E-4,3.5696E-4,3.9682E-4,6.9214E-4,4.4093E-4,3.2535E-4,4.093E-4:1
-0.023244,0.012412,-0.010032,-0.015528,0.0090375,-0.020491,0.012911,-0.0072206,-0.0021194,0.014688,-0.031389,0.0098617,-0.009643,-0.016375,0.0060596,-0.020806,0.0082025,-0.010558,-0.011932,0.012017,-0.024186,0.015945,-0.011455,-0.0063948,0.016033,-0.023497,0.0085842,-0.011232,-0.014307,0.002396,-0.018717,0.018856,-0.012062,-0.0098474,0.0092666,-0.022919,0.0073477,-0.014126,-0.0050363,0.015274,-0.024817,0.0086951,-0.0094255,1.8519,1.6685,1.2999,1.6548,1.3981,0.63908,0.6282,0.64593,0.78071,1.3222,0.61536,0.61151,0.64657,0.76807,1.324,0.6068,0.60861,0.63695,0.76036,1.313,0.611,0.60611,0.63256,0.75835,1.3176,0.61239,0.60608,0.63041,0.76384,1.3084,0.59856,0.6102,0.63726,0.76131,1.3077,0.60061,0.61543,0.62934,0.76422,1.298,0.60711,0.60488,0.62938,0.7579,1.3051,0.602,0.60806,0.63,0.75337,1.3077,0.6105,0.60216,0.62705,0.7661,1.3016,0.60188,0.60394,0.63401,0.76371,1.2976,0.60042,0.60785,0.63026,0.75978,1.2978,0.59994,0.61428,0.62694,0.76584,1.3057,0.59685,0.61123,0.62933,0.76194,1.2943,0.59918,0.60251,0.62334,0.76953,1.2919,0.5974,0.60754,0.62691,0.76913,1.2893,0.59881,0.60208,0.63064,0.76581,1.2825,0.59373,0.61053,0.62729,0.76971,1.2868,0.60625,0.60952,0.62932,0.76649,1.2888,0.59284,0.60935,0.62314,0.76585,1.2876,0.59788,0.61426,0.62688,0.77374,1.294,0.59511,0.60601,0.63189,0.76737,1.289,0.59316,0.61476,0.62625,0.77872,1.2889,0.59813,0.60682,0.62894,0.77565,1.2868,0.60114,0.61089,0.62139,0.77619,1.2718,0.59204,0.61352,0.62572,0.78034,1.2789,0.60096,0.60623,0.62384,0.78061,1.2717,0.59438,0.60884,0.62844,0.78105,1.2721,0.59281,0.60657,0.61928,0.78119,1.2801,0.59891,0.61024,0.63038,0.78422,1.2793,0.58776,0.61753,0.62001,0.77716,1.2759,0.59501,0.61024,0.63018,0.78632,1.2699,0.59568,0.60323,0.62391,0.78759,1.2763,0.58826,0.61151,0.62423,0.78615,1.2684,0.59375,0.60246,0.62429,0.78592,1.2598,0.58925,0.61397,0.62311,0.79306,1.26,0.59053,0.60859,0.62048,0.78609,1.2638,0.59211,0.6057,0.63301,0.79576,1.2643,0.58878,0.60885,0.62709,0.79548,1.26,0.59303,0.61175,0.62549,0.79728,1.2671,0.58156,0.60553,0.62151,0.79925,1.2568,0.58173,0.61779,0.62973,0.79941,1.2597,0.58275,0.61916,0.62469,0.79203,1.2543,0.58565,0.61385,0.61709,0.79839,1.2649,0.57738,0.6102,0.62669,0.79617,1.2526,0.58139,0.61649,0.62362,0.79832,1.2563,0.57871,0.61324,0.62299,0.80439,1.2546,0.58043,0.62145,0.62307,0.8082,1.2526,0.58352,0.61416,0.62705,0.81003,1.2468,0.57765,0.61451,0.63009,0.80784,1.2468,0.58455,0.61018,0.62161,0.81355,1.2465,0.58394,0.60943,0.62827,0.81262,1.2482,0.58281,0.61408,0.62676,0.81861,1.2489,0.57979,0.61902,0.62042,0.81675,1.2455,0.57744,0.6173,0.61849,0.81839,1.2472,0.57768,0.61492,0.62905,0.82037,1.2342,0.5822,0.61399,0.62033,0.81655,1.2433,0.5796,0.61367,0.62673,0.82298,1.2399,0.58436,0.61528,0.625,0.82489,1.2455,0.57624,0.61472,0.62683,0.82635,1.2416,0.58066,0.61578,0.62744,0.81629,1.2388,0.57522,0.616,0.63153,0.82123,1.2373,0.57832,0.6142,0.62316,0.82694,1.2387,0.57525,0.61603,0.62591,0.82509,1.2308,0.57387,0.61218,0.62583,0.82622,1.23,0.5707,0.60985,0.62317,0.82292,1.2365,0.57497,0.61615,0.63229,0.82907,1.2345,0.5766,0.61721,0.62254,0.83043,1.2319,0.56928,0.61584,0.62555,0.84078,1.2373,0.56437,0.62052,0.62526,0.8357,1.2219,0.57052,0.61701,0.62285,0.84103,1.2271,0.57246,0.6166,0.629,0.83729,1.2225,0.57118,0.61984,0.63406,0.84003,1.2251,0.57502,0.6161,0.62795,0.84247,1.2197,0.57142,0.61905,0.62719,0.84592,1.2185,-0.10616:1
0.010625,-0.02104,0.015975,-0.0090755,-0.012439,0.011921,-0.022366,0.015649,-0.022748,-0.010952,0.013052,-0.034392,0.0090776,-0.012818,-0.014786,0.011651,-0.028898,0.010712,-0.016218,-0.013609,0.011477,-0.023527,0.0050556,-0.013374,-0.012356,0.01385,-0.024464,0.012899,-0.014713,-0.020079,0.012533,-0.018079,0.013177,-0.0096375,-0.010166,2.1202,1.9103,2.4003,1.5672,0.74825,0.73236,0.72241,1.0338,1.2764,0.6591,0.7056,0.70177,1.0202,1.2563,0.64982,0.69378,0.69744,1.0183,1.2437,0.64521,0.69252,0.69649,1.0199,1.241,0.6337,0.69514,0.69315,1.0256,1.2404,0.6334,0.69158,0.687,1.0301,1.2335,0.61962,0.69372,0.68226,1.0393,1.2187,0.6156,0.68587,0.69178,1.0413,1.197,0.60826,0.69035,0.68583,1.0488,1.1894,0.60513,0.68596,0.68378,1.0559,1.1854,0.61302,0.69496,0.68441,1.0575,1.1812,0.60566,0.68102,0.68423,1.0778,1.1644,0.60022,0.68668,0.68527,1.0761,1.1616,0.59619,0.68301,0.68198,1.0782,1.1595,0.59529,0.68739,0.683,1.0947,1.1546,0.60133,0.68814,0.6815,1.0965,1.1398,0.58867,0.68708,0.68428,1.1072,1.1297,0.59321,0.68598,0.67767,1.116,1.1245,0.59535,0.68388,0.67518,1.113,1.1205,0.59126,0.68925,0.67733,1.1249,1.0978,0.59134,0.68911,0.68524,1.1202,1.1085,0.57812,0.69016,0.6773,1.1348,1.0901,0.58354,0.68904,0.68039,1.1413,1.0926,0.57918,0.68822,0.6805,1.1452,1.0882,0.58162,0.68728,0.67441,1.1467,1.0849,0.58272,0.68534,0.67957,1.1541,1.0635,0.58239,0.6873,0.68451,1.1584,1.0616,0.5775,0.69101,0.67599,1.1681,1.0587,0.5755,0.68924,0.67264,1.1677,1.0561,0.57347,0.69654,0.67489,1.1772,1.0538,0.57579,0.69211,0.6779,1.1804,1.0466,0.57017,0.69283,0.66787,1.1858,1.045,0.57132,0.68984,0.67659,1.185,1.0305,0.56354,0.69099,0.68084,1.1929,1.0194,0.57132,0.68328,0.68774,1.2107,1.0155,0.56735,0.69097,0.68391,1.2126,1.0131,0.57125,0.68408,0.68851,1.208,1.0106,0.57646,0.69223,0.68785,1.2211,1.0021,0.5696,0.6942,0.67076,1.2197,1.0024,0.57333,0.68863,0.67801,1.2324,0.98225,0.57218,0.70071,0.68215,1.2298,0.97688,0.57374,0.69206,0.68139,1.243,0.9724,0.57224,0.69694,0.67626,1.2406,0.96774,0.56507,0.69123,0.67496,1.2543,0.94878,0.57493,0.69484,0.67863,1.2517,0.95562,0.57232,0.69661,0.68088,1.2657,0.94714,0.5699,0.69757,0.67823,1.2598,0.93741,0.57524,0.69036,0.67903,1.2692,0.93774,0.57109,0.69875,0.68176,1.2717,0.9249,0.57771,0.697,0.67996,1.2875,0.91919,0.58084,0.69666,0.68568,1.2874,0.90663,0.57489,0.69689,0.68324,1.2989,0.9002,0.58055,0.7029,0.67903,1.2996,0.90471,0.57826,0.70653,0.68356,1.3031,0.89352,0.57343,0.70269,0.67759,1.3038,0.88525,0.58096,0.6971,0.68033,1.3131,0.88272,0.57745,0.6967,0.67484,1.3115,0.88604,0.57601,0.69616,0.68566,1.3217,0.86967,0.58197,0.7044,0.68398,1.3279,0.86549,0.58128,0.70287,0.68634,1.3392,0.8497,0.58421,0.69757,0.68186,1.3311,0.8422,0.57897,0.70355,0.68219,1.3443,0.84431,0.58374,0.70052,0.68507,1.3381,0.8382,0.58766,0.70318,0.68807,1.3346,0.85791,0.57645,0.70565,0.68262,1.3529,0.82051,0.57617,0.70428,0.68888,1.3634,0.82369,0.58048,0.70718,0.68193,1.3597,0.81761,0.5883,0.70901,0.68215,1.3585,0.81327,0.57994,0.70565,0.68149,1.3704,0.80845,0.58045,0.71034,0.68361,1.3824,0.80326,0.5766,0.70615,0.68178,1.3818,0.80244,0.59145,0.7096,0.68758,1.3774,0.78854,0.584,0.70974,0.68314,1.3776,0.79578,0.58617,0.70347,0.68516,1.3854,0.77294,0.59001,0.71044,0.68418,1.3896,0.78157,0.58924,0.71383,0.68573,1.3954,0.76694,0.5832,0.71472,0.68054,1.3985,0.76359,0.58994,0.70679,0.68373,1.3993,0.76852,0.59085,0.71215,0.68763,1.4067,-0.029278:1
-0.013368,0.0046367,0.0086007,-0.018705,0.015773,-0.015791,0.0093116,0.0039253,-0.013444,0.011296,-0.014131,0.0028711,0.0023562,-0.021625,0.021583,-0.014938,0.0064497,0.0022013,-0.015617,0.021301,-0.016304,-2.1094E-5,0.0095784,-0.01678,0.017724,0.44799,0.31787,0.20644,0.20432,0.19791,0.2158,0.3468,0.12989,0.11515,0.20589,0.20074,0.35012,0.12071,0.11621,0.20273,0.19528,0.34744,0.12604,0.11352,0.19542,0.19224,0.35867,0.11158,0.11189,0.19296,0.18504,0.35476,0.13301,0.11658,0.20556,0.17883,0.35987,0.11707,0.11001,0.19748,0.17542,0.36281,0.11148,0.10658,0.19438,0.1778,0.36321,0.12892,0.1125,0.1892,0.17699,0.36595,0.12294,0.10321,0.20388,0.16861,0.37332,0.12229,0.10733,0.20109,0.16361,0.36731,0.11864,0.10755,0.19023,0.16707,0.37132,0.12325,0.10967,0.19259,0.16433,0.37138,0.12303,0.11299,0.19418,0.15532,0.37596,0.11615,0.10732,0.1921,0.15925,0.38354,0.11774,0.11615,0.1895,0.15259,0.38789,0.11917,0.10147,0.18646,0.14692,0.38741,0.13083,0.11229,0.18536,0.14474,0.39338,0.12358,0.10107,0.18484,0.13995,0.3933,0.11878,0.10052,0.18294,0.14108,0.3901,0.11837,0.10185,0.18139,0.13493,0.39559,0.11881,0.10636,0.18235,0.13182,0.39564,0.12807,0.1015,0.18857,0.13699,0.39402,0.12342,0.10182,0.18722,0.13461,0.39487,0.11832,0.10743,0.18694,0.1298,0.38694,0.12226,0.10806,0.18065,0.13426,0.39155,0.12221,0.10283,0.18199,0.13252,0.38232,0.13429,0.10607,0.18621,0.13502,0.38261,0.13307,0.10386,0.18892,0.12199,0.39311,0.13415,0.10267,0.18541,0.13309,0.38053,0.13226,0.10298,0.1835,0.12897,0.38603,0.13337,0.097903,0.18184,0.12787,0.37767,0.13989,0.10447,0.18212,0.13245,0.38812,0.13611,0.10298,0.18497,0.13001,0.37463,0.14272,0.097509,0.18654,0.13163,0.38303,0.13744,0.097969,0.18358,0.13554,0.37287,0.14262,0.095971,0.18017,0.12988,0.38072,0.14103,0.088688,0.18047,0.13051,0.37605,0.14,0.10564,0.17894,0.13145,0.3767,0.14335,0.096404,0.17943,0.12725,0.36551,0.14671,0.095045,0.1819,0.1218,0.36997,0.15058,0.10041,0.17791,0.13425,0.35894,0.15605,0.093398,0.17915,0.13043,0.36876,0.1562,0.093668,0.17946,0.12971,0.36412,0.14713,0.091525,0.18801,0.1233,0.36995,0.16054,0.085171,0.17569,0.13417,0.36655,0.15959,0.094533,0.17979,0.12614,0.36088,0.15853,0.086828,0.1733,0.1265,0.3587,0.17195,0.08597,0.17754,0.12753,0.34519,0.16885,0.083133,0.17539,0.12773,0.3499,0.17311,0.085139,0.17117,0.12852,0.35346,0.17705,0.087505,0.17115,0.13018,0.34439,0.18032,0.087633,0.17448,0.12662,0.34505,0.1763,0.071772,0.17535,0.12608,0.3355,0.17921,0.084212,0.17085,0.12367,0.34403,0.18773,0.08852,0.17715,0.11621,0.33618,0.18798,0.081576,0.16384,0.12772,0.33435,0.19719,0.078205,0.16805,0.12359,0.33229,0.19618,0.079454,0.17257,0.13132,0.32467,0.20355,0.082013,0.16077,0.12324,0.3248,0.19548,0.080904,0.16743,0.12536,0.31891,0.21153,0.08258,0.16126,0.12319,0.3187,0.21166,0.081087,0.16721,0.12493,0.3181,0.21451,0.079287,0.16702,0.11638,0.31228,0.21626,0.067297,0.16799,0.12225,0.31031,0.22798,0.076718,0.16893,0.11985,0.30618,0.21811,0.072518,0.16138,0.12775,0.3006,0.22414,0.07031,0.16337,0.1249,0.30229,0.23036,0.074695,0.16319,0.12346,0.29701,0.23681,0.074547,0.15576,0.11893,0.29194,0.23869,0.077697,0.16443,0.12117,0.30403,0.2384,0.084739,0.16383,0.12323,0.28866,0.24988,0.073995,0.1652,0.12097,0.28301,0.2566,0.074302,0.1619,0.12064,0.28567,0.26377,0.075429,0.16322,0.12482,0.28509,0.26288,0.073008,0.15557,0.12337,0.27418,0.26577,0.069178,0.16015,0.0:1
0.0098352,-0.021157,0.020736,-0.010585,-0.001809,0.012236,-0.020824,0.021158,-0.014255,-9.4414E-5,0.0084162,-0.020901,0.013131,-0.012449,0.005712,0.009101,-0.018515,0.019202,-0.014916,0.0016247,0.011589,-0.022622,0.018581,-0.0063718,0.0035234,0.0063714,-0.019111,0.01618,-0.014888,0.0036271,0.012272,-0.020174,0.020156,-0.0099825,-5.1226E-4,0.012224,-0.0232,0.022937,-0.015297,-0.0081511,0.0076089,-0.022034,0.019076,-0.013423,0.0042071,0.0078593,-0.024187,0.015653,-0.017732,-1.4452E-4,0.0068054,-0.025293,0.013429,-0.011765,0.005423,0.0089224,-0.017691,0.015513,-0.012473,-4.1382E-4,0.0084061,-0.022774,0.020814,-0.011705,0.0041505,0.0064871,-0.027336,0.017113,-0.0089532,-3.7815E-4,0.0080819,-0.020793,0.015522,-0.016978,1.0199E-4,0.012035,-0.018085,0.25919,0.28024,0.28426,0.092363,0.11055,0.18798,0.24527,0.25527,0.10016,0.10908,0.18273,0.24449,0.25817,0.093483,0.10507,0.17778,0.24642,0.27018,0.095311,0.10767,0.1758,0.22824,0.2725,0.08938,0.10128,0.17381,0.2362,0.27549,0.093674,0.10913,0.17745,0.22754,0.27682,0.083643,0.1045,0.17434,0.23084,0.27517,0.089467,0.098534,0.17257,0.22222,0.2793,0.089986,0.098343,0.17285,0.21822,0.28136,0.088861,0.099873,0.1797,0.21205,0.28804,0.08885,0.097614,0.17205,0.2078,0.29547,0.082105,0.09723,0.16852,0.20366,0.29938,0.089194,0.10122,0.17161,0.19253,0.30882,0.087637,0.098126,0.175,0.19015,0.31314,0.079381,0.09118,0.17232,0.18637,0.31396,0.090811,0.092428,0.17471,0.18272,0.32106,0.088894,0.092318,0.17439,0.17158,0.32426,0.094958,0.089578,0.16461,0.17768,0.31922,0.084007,0.087998,0.17203,0.17065,0.32917,0.085997,0.096579,0.16827,0.16765,0.33274,0.083867,0.092361,0.16968,0.15514,0.34218,0.088245,0.091545,0.17452,0.15928,0.34299,0.086893,0.086181,0.17117,0.14758,0.34994,0.088058,0.092921,0.16823,0.14702,0.34708,0.089153,0.084502,0.16166,0.13916,0.35531,0.082358,0.093802,0.16719,0.13572,0.36206,0.083714,0.085566,0.16842,0.13399,0.36698,0.092272,0.095215,0.16421,0.13072,0.36191,0.089148,0.09239,0.16302,0.1252,0.37026,0.089514,0.089676,0.16746,0.12289,0.36544,0.089769,0.08811,0.16957,0.11644,0.37023,0.086216,0.08738,0.16606,0.12072,0.3723,0.091104,0.087819,0.16706,0.12565,0.37525,0.088751,0.089562,0.16301,0.12258,0.36996,0.10308,0.084319,0.16279,0.12445,0.36717,0.09421,0.081269,0.1657,0.12671,0.3679,0.097705,0.08244,0.16427,0.11981,0.36531,0.096501,0.082568,0.16393,0.11704,0.368,0.099931,0.08745,0.16203,0.11728,0.36548,0.097154,0.082115,0.16697,0.1223,0.35987,0.09935,0.080999,0.15958,0.12006,0.36063,0.1002,0.078501,0.15871,0.11237,0.35527,0.1046,0.075597,0.16601,0.11942,0.35971,0.10568,0.08065,0.16898,0.1087,0.3593,0.10978,0.082612,0.16141,0.11615,0.35363,0.11617,0.081094,0.16281,0.11813,0.35518,0.11493,0.078034,0.16073,0.1219,0.35022,0.10824,0.07683,0.15731,0.11529,0.35643,0.11402,0.073814,0.15727,0.11892,0.35117,0.11675,0.071562,0.15975,0.11745,0.35766,0.11465,0.075108,0.15472,0.11657,0.33923,0.12424,0.080592,0.15896,0.11411,0.33809,0.11976,0.077749,0.16007,0.1125,0.33994,0.12395,0.068958,0.15705,0.11393,0.34789,0.12954,0.074164,0.15487,0.11196,0.339,0.13023,0.075762,0.16626,0.10348,0.33895,0.13913,0.072478,0.15607,0.11643,0.33674,0.13874,0.066613,0.15761,0.11939,0.34189,0.1334,0.073441,0.14936,0.11558,0.33494,0.14311,0.069568,0.14971,0.12024,0.33274,0.13991,0.070115,0.16193,0.11363,0.33021,0.14606,0.06544,0.15249,0.11285,0.32437,0.15009,0.059251,0.15456,0.11412,0.32372,0.14973,0.067609,0.15648,0.10451,0.32229,0.1464,0.069072,0.14632,0.11201,0.32035,0.16247,0.07278,0.15587,0.11141,0.3171,0.16374,0.068712,0.15517,0.11114,0.31482,0.16837,0.0678,0.14788,0.11159,0.31706,0.16459,0.054941,0.15445,0.11098,0.30823,0.17553,0.059278,0.15094,0.1044,0.30761,0.17735,0.062155,0.15432,0.10477,0.30516,0.1774,0.061282,0.1435,0.10752,0.30123,0.19356,0.062237,0.14745,0.10954,0.29804,0.18267,0.07835:1
0.02544,-0.021893,0.020201,0.0071129,-0.020476,0.03001,-0.027507,0.012471,0.011688,-0.018579,0.025298,-0.017686,0.017262,0.0014058,-0.028312,0.035365,-0.022593,3.2363,3.3529,2.6073,2.6279,3.7622,4.4378,3.0561,2.5933,2.7615,3.7724,4.504,3.0908,2.6251,2.834,3.9007,4.6003,3.1869,2.6952,2.892,4.0299,4.6792,3.2796,2.7975,2.9875,3.4318,3.6089,1.643,1.274,1.4165,1.3753,2.655,1.4827,1.2118,1.3593,1.3462,2.632,1.4726,1.21,1.3564,1.3511,2.6275,1.4674,1.1937,1.3468,1.3413,2.6195,1.4389,1.192,1.3419,1.3334,2.6173,1.4364,1.1876,1.3318,1.3194,2.6019,1.4138,1.176,1.3203,1.3165,2.6063,1.3969,1.1627,1.3169,1.2984,2.5823,1.3898,1.1712,1.3196,1.3151,2.5828,1.3883,1.165,1.3183,1.3033,2.5867,1.3695,1.1572,1.3107,1.2928,2.5994,1.3644,1.157,1.3174,1.2912,2.5566,1.3553,1.1524,1.3108,1.3066,2.5784,1.3537,1.1578,1.2992,1.2813,2.5788,1.3449,1.1519,1.306,1.2968,2.5915,1.3403,1.1552,1.3089,1.2969,2.5866,1.3376,1.1657,1.3,1.298,2.5864,1.3229,1.1591,1.2961,1.3027,2.5934,1.3228,1.1558,1.3097,1.3053,2.5931,1.3069,1.1542,1.3106,1.309,2.601,1.3141,1.1574,1.3104,1.3058,2.6019,1.2938,1.1577,1.3086,1.3139,2.6259,1.3079,1.1618,1.3222,1.3112,2.6104,1.2969,1.1663,1.3099,1.305,2.5842,1.2971,1.1707,1.3076,1.3098,2.5992,1.2739,1.1484,1.2918,1.3264,2.5975,1.2841,1.1623,1.3032,1.3252,2.5706,1.2702,1.1574,1.3098,1.3362,2.5851,1.2648,1.1609,1.3019,1.3292,2.5767,1.2697,1.1591,1.3095,1.3299,2.5832,1.2704,1.1683,1.3079,1.3395,2.5777,1.264,1.1657,1.3121,1.3471,2.578,1.2502,1.1601,1.3035,1.3503,2.5657,1.2462,1.1698,1.3125,1.3765,2.5631,1.2544,1.1615,1.3098,1.3875,2.5532,1.2562,1.17,1.3193,1.3843,2.5478,1.2531,1.1702,1.3182,1.4011,2.5261,1.2387,1.1668,1.3145,1.4189,2.5412,1.2434,1.1635,1.3083,1.3966,2.5151,1.2428,1.1629,1.3105,1.44,2.4974,1.232,1.1611,1.302,1.4612,2.4765,1.2239,1.172,1.3054,1.4805,2.4551,1.2213,1.1647,1.3113,1.4992,2.4543,1.2193,1.1678,1.3136,1.5227,2.4228,1.2115,1.1661,1.3091,1.5363,2.4103,1.2226,1.1693,1.3199,1.5397,2.3969,1.2213,1.1655,1.3134,1.567,2.4024,1.2226,1.172,1.313,1.5611,2.3775,1.2105,1.1753,1.3239,1.5982,2.3666,1.2102,1.1703,1.3139,1.6146,2.3545,1.2083,1.1671,1.3062,1.6249,2.3402,1.208,1.1738,1.3248,1.6408,2.2951,1.1989,1.1724,1.3217,1.6619,2.3039,1.1849,1.1651,1.3128,1.654,2.295,1.1914,1.1723,1.3195,1.6787,2.2796,1.1885,1.1705,1.3146,1.6927,2.2709,1.1853,1.1746,1.3194,1.7035,2.2748,1.1862,1.1771,1.3158,1.7211,2.2347,1.1841,1.1825,1.3207,1.7457,2.2263,1.1894,1.1679,1.3132,1.7596,2.2097,1.1883,1.1852,1.3244,1.775,2.2076,1.1762,1.1841,1.3217,1.7845,2.2035,1.1818,1.1856,1.3322,1.7775,2.1985,1.1808,1.1883,1.3182,1.7932,2.1699,1.1721,1.1803,1.334,1.8195,2.1653,1.1639,1.1738,1.3068,1.8229,2.1475,1.1734,1.1876,1.317,1.8402,2.1296,1.1849,1.1942,1.3296,1.8588,2.1149,1.1803,1.1854,1.3353,1.8571,2.1295,1.1703,1.1864,1.3334,1.8716,2.1155,1.1743,1.1849,1.3217,1.8777,2.1063,1.1709,1.1861,1.3234,1.89,2.0928,1.1635,1.1892,1.3289,1.9048,2.0868,1.1595,1.1956,1.3188,1.9197,2.0625,-0.20052:1
-0.022228,0.030374,-0.023104,0.020268,0.004678,-0.028845,0.03653,-0.029286,0.015514,0.0056605,-0.024422,0.029868,-0.019825,0.012744,0.010343,-0.025827,0.028616,-0.021405,0.015581,0.0042558,-0.024916,0.02327,-0.02149,0.010293,4.7662,3.228,2.9116,4.3173,4.3778,2.9887,2.7482,2.9937,4.5494,4.5029,3.1062,2.786,2.8074,4.0848,4.1777,2.8186,2.6206,2.8243,4.2198,4.0287,2.3888,1.838,1.6677,1.7777,2.7089,1.4516,1.3197,1.4713,1.7139,2.6609,1.4071,1.3043,1.4628,1.7092,2.6543,1.388,1.3057,1.454,1.7061,2.631,1.3833,1.2864,1.4492,1.6953,2.6175,1.3638,1.2822,1.438,1.7033,2.5929,1.3584,1.282,1.429,1.6939,2.575,1.3392,1.2729,1.4247,1.7149,2.549,1.332,1.27,1.419,1.7205,2.5212,1.3308,1.2684,1.4158,1.7332,2.499,1.321,1.2623,1.4104,1.7344,2.4939,1.3136,1.2578,1.4061,1.7412,2.4758,1.3065,1.2552,1.403,1.743,2.4621,1.2956,1.2451,1.3972,1.7444,2.4376,1.2867,1.2515,1.3971,1.7677,2.4351,1.2821,1.2501,1.4012,1.7841,2.415,1.2879,1.2573,1.3957,1.7941,2.3937,1.2844,1.2466,1.4035,1.8156,2.379,1.2806,1.2602,1.4066,1.8271,2.3811,1.2724,1.2556,1.3959,1.8447,2.3635,1.2745,1.257,1.4007,1.8629,2.3427,1.2695,1.2537,1.4047,1.8606,2.3264,1.2652,1.2566,1.4028,1.8851,2.3194,1.2721,1.2549,1.3959,1.8939,2.3037,1.2593,1.2534,1.3986,1.917,2.3008,1.2575,1.2557,1.3927,1.9085,2.2781,1.2588,1.2581,1.4039,1.9272,2.2853,1.2504,1.2497,1.3923,1.9547,2.2552,1.2522,1.2573,1.3964,1.96,2.25,1.2492,1.2585,1.4013,1.9695,2.2281,1.2446,1.2489,1.4003,1.9784,2.2193,1.2457,1.2525,1.3932,1.9839,2.2093,1.243,1.2529,1.4006,1.981,2.1987,1.2423,1.2571,1.402,2.0085,2.1958,1.2364,1.2567,1.4004,2.0139,2.1871,1.2358,1.2614,1.4024,2.0423,2.1648,1.2321,1.258,1.4055,2.0515,2.1574,1.2274,1.2616,1.3954,2.0579,2.1372,1.237,1.2636,1.3928,2.0725,2.1194,1.2272,1.2569,1.3995,2.0833,2.1133,1.2292,1.2666,1.403,2.1064,2.0952,1.231,1.2618,1.3952,2.1083,2.0948,1.2329,1.2612,1.4004,2.1222,2.0802,1.2192,1.2652,1.4021,2.1412,2.0541,1.226,1.2678,1.4022,2.1491,2.0448,1.2216,1.2647,1.3977,2.1611,2.0264,1.2248,1.257,1.4089,2.1686,2.0159,1.2249,1.2676,1.4041,2.1839,2.0083,1.2264,1.264,1.3973,2.1894,1.9952,1.225,1.2622,1.4018,2.2111,1.9764,1.2183,1.2616,1.399,2.2248,1.9613,1.2116,1.2696,1.3931,2.2453,1.9402,1.2173,1.2796,1.3972,2.2533,1.9389,1.2239,1.2715,1.4026,2.2587,1.9295,1.2166,1.2733,1.3986,2.2763,1.9066,1.2171,1.2708,1.3999,2.2711,1.9089,1.2262,1.2669,1.3991,2.2874,1.8914,1.2214,1.2651,1.3993,2.2919,1.8864,1.2215,1.2673,1.3976,2.3177,1.8764,1.2228,1.2682,1.4007,2.308,1.8644,1.219,1.2753,1.4087,2.3268,1.8516,1.2175,1.2724,1.4022,2.3368,1.8282,1.2254,1.2737,1.4045,2.3468,1.8232,1.2257,1.2766,1.4014,2.3543,1.8089,1.2264,1.273,1.3967,2.3602,1.8031,1.224,1.2759,1.409,2.3832,1.7882,1.228,1.2775,1.3989,2.3884,1.7766,1.227,1.2729,1.4014,2.3988,1.758,1.225,1.2803,1.4037,2.4131,1.751,1.2346,1.285,1.4055,2.4111,1.7408,1.2307,1.2779,1.4015,2.4314,1.7213,1.2342,1.2796,1.3982,2.4311,1.7113,1.23,1.2816,1.4081,2.4473,1.6984,1.2287,1.2789,1.4022,2.4572,1.689,1.2323,1.2797,1.4018,2.4648,1.6818,1.2383,1.2836,1.3991,2.4674,1.6772,1.2356,1.2855,1.4102,2.4955,1.6445,1.2363,1.295,1.4113,2.5012,1.6424,1.2373,1.286,1.4035,2.501,1.6368,1.2403,1.2846,1.4027,2.5073,1.6312,1.2425,1.2815,1.4032,2.5148,1.6095,1.2454,1.2916,1.3983,2.5203,1.6042,1.2429,1.2839,1.4026,2.5375,1.6012,1.2414,1.2969,1.4006,2.5371,0.14148:1
-0.011069,-0.010125,0.020423,-0.034176,0.027446,-0.013998,-0.0034918,0.014949,-0.032862,0.029288,-0.010923,-0.0037172,0.020431,-0.036864,0.027795,-0.01225,-0.0042387,0.014381,-0.031718,0.023948,-0.011229,-0.0037452,0.018425,-0.035883,0.024487,-0.0063253,-7.9725E-4,0.015487,-0.034706,1.6236,4.5348,3.1324,2.6141,2.8481,3.9736,4.5389,3.2275,2.7385,2.8956,4.2056,4.6555,3.341,2.7181,2.7976,3.9565,4.4167,3.0963,2.6614,2.7232,3.6242,3.6223,1.9999,1.5002,1.4545,1.5753,2.8828,1.5904,1.3828,1.4189,1.5536,2.8581,1.556,1.3669,1.4099,1.5476,2.8536,1.5429,1.3676,1.3969,1.5393,2.8425,1.5224,1.3634,1.4008,1.5357,2.8386,1.5106,1.3505,1.3922,1.5412,2.8275,1.4896,1.3482,1.3894,1.5358,2.8191,1.47,1.3465,1.3841,1.5352,2.8105,1.4595,1.3465,1.379,1.5362,2.8128,1.4579,1.3454,1.383,1.5463,2.7869,1.4446,1.3337,1.376,1.5468,2.7859,1.4294,1.3318,1.3756,1.5613,2.7597,1.4171,1.3378,1.3667,1.5759,2.748,1.4096,1.3343,1.3611,1.5796,2.736,1.3986,1.3343,1.3627,1.6003,2.7165,1.3953,1.3328,1.3619,1.6229,2.6932,1.3809,1.3298,1.3606,1.6535,2.6664,1.3858,1.3334,1.3647,1.6774,2.6457,1.3654,1.3345,1.3664,1.7107,2.6185,1.3594,1.337,1.3644,1.7394,2.6032,1.3511,1.3391,1.3637,1.743,2.5879,1.3461,1.3374,1.3709,1.7772,2.5616,1.342,1.3363,1.3657,1.8003,2.5354,1.3304,1.3331,1.3659,1.8164,2.5219,1.3351,1.3453,1.364,1.8449,2.5003,1.3216,1.3369,1.3632,1.8665,2.4756,1.3137,1.3411,1.3684,1.8872,2.4519,1.3118,1.3399,1.3606,1.9196,2.445,1.2989,1.3478,1.3585,1.9365,2.4239,1.3021,1.348,1.3641,1.9476,2.4094,1.2981,1.3434,1.3684,1.9688,2.3888,1.2894,1.3512,1.3751,1.9882,2.3756,1.2882,1.3565,1.3653,2.0051,2.3653,1.2856,1.3546,1.3716,2.0217,2.3381,1.2753,1.3531,1.3606,2.0425,2.323,1.2711,1.357,1.3631,2.0582,2.2986,1.2724,1.3534,1.365,2.0796,2.2879,1.2685,1.3503,1.3627,2.0946,2.2802,1.2595,1.3635,1.3635,2.1108,2.2586,1.2633,1.357,1.3607,2.1322,2.2415,1.252,1.3607,1.3634,2.1435,2.2281,1.2577,1.3652,1.3605,2.1727,2.1958,1.2463,1.3632,1.3744,2.1944,2.1758,1.2545,1.3618,1.3648,2.2115,2.156,1.2468,1.3661,1.3581,2.2243,2.1331,1.2444,1.3608,1.368,2.2365,2.1316,1.2427,1.3727,1.3728,2.2527,2.1163,1.2412,1.3723,1.3726,2.2643,2.0899,1.2408,1.3664,1.3743,2.2794,2.0792,1.2318,1.3724,1.3631,2.2942,2.0662,1.2319,1.3696,1.3663,2.3195,2.0409,1.2326,1.3766,1.3727,2.333,2.0251,1.2262,1.3768,1.366,2.3537,2.0115,1.2296,1.3763,1.3711,2.3673,1.9888,1.2256,1.375,1.3729,2.3809,1.9835,1.2274,1.3799,1.3757,2.3872,1.9682,1.2282,1.3756,1.3722,2.3964,1.9628,1.229,1.3821,1.3641,2.4129,1.9473,1.2211,1.3889,1.3673,2.4342,1.9225,1.2283,1.3865,1.3731,2.4491,1.9014,1.2282,1.3817,1.3703,2.463,1.8866,1.2263,1.3808,1.3706,2.471,1.8722,1.2296,1.3856,1.3727,2.4743,1.8689,1.2286,1.3898,1.3735,2.4937,1.8559,1.2286,1.3882,1.3808,2.499,1.8448,1.2275,1.3908,1.374,2.5123,1.8215,1.2178,1.3852,1.3732,2.5218,1.8149,1.2255,1.39,1.3713,2.536,1.7909,1.2323,1.4006,1.3729,2.5499,1.7845,1.2303,1.3921,1.3762,2.5615,1.7577,1.2334,1.3971,1.3729,2.5726,1.7452,1.2267,1.395,1.3746,2.5828,1.7291,1.2357,1.3855,1.3727,2.5883,1.7217,1.2399,1.3993,1.3686,2.6082,1.7095,1.227,1.3954,1.3794,2.6209,1.6962,1.2349,1.3982,1.3712,2.6182,1.6901,1.2273,1.399,1.378,2.6424,1.663,1.2394,1.4071,1.3804,2.6533,1.6585,1.2361,1.4061,1.3813,2.6643,1.6397,1.2385,1.4013,1.3793,2.6618,1.6332,1.2422,1.4014,1.2769:1
7.2333E-7,2.0E-8,9.2333E-7,-6.9667E-7,8.4333E-7,-9.3333E-8,6.2667E-7,1.01E-6,-2.5667E-7,1.2367E-6,1.4433E-6,8.6667E-8,1.9333E-7,-2.2667E-7,7.0E-8,4.6E-7,-5.9E-7,1.0367E-6,-5.9333E-7,3.4333E-7,-2.6667E-8,-2.0333E-7,8.1333E-7,1.8E-7,1.1567E-6,2.2667E-7,1.2667E-7,1.1367E-6,-6.3333E-7,1.18E-6,1.04E-6,2.2674E-4,5.944E-5,6.7387E-5,7.315E-5,1.3722E-4,8.2157E-5,6.387E-5,7.287E-5,7.899E-5,1.524E-4,9.046E-5,7.1123E-5,8.1813E-5,8.7363E-5,1.7139E-4,1.03E-4,8.0703E-5,9.4167E-5,1.0238E-4,1.9399E-4,1.1879E-4,9.1447E-5,1.1004E-4,1.2807E-4,2.1267E-4,1.3886E-4,1.0892E-4,1.2685E-4,1.5424E-4,2.316E-4,1.5488E-4,1.1495E-4,1.2859E-4,1.5102E-4,2.1944E-4,1.2923E-4,9.223E-5,1.0017E-4,7.9263E-5,1.3529E-4,7.5773E-5,5.9887E-5,6.6173E-5,6.7417E-5,1.2982E-4,7.256E-5,5.7937E-5,6.4467E-5,6.731E-5,1.2872E-4,7.199E-5,5.736E-5,6.5113E-5,6.6257E-5,1.2999E-4,7.009E-5,5.868E-5,6.437E-5,6.6633E-5,1.2951E-4,6.933E-5,5.729E-5,6.4497E-5,6.568E-5,1.2827E-4,6.97E-5,5.6357E-5,6.3053E-5,6.6E-5,1.2953E-4,7.031E-5,5.703E-5,6.237E-5,6.584E-5,1.2902E-4,6.847E-5,5.623E-5,6.395E-5,6.5063E-5,1.2845E-4,6.669E-5,5.6573E-5,6.2873E-5,6.4827E-5,1.2841E-4,6.8673E-5,5.5993E-5,6.234E-5,6.5323E-5,1.2786E-4,6.5707E-5,5.5807E-5,6.2553E-5,6.4643E-5,1.2713E-4,6.5147E-5,5.62E-5,6.2217E-5,6.3637E-5,1.2831E-4,6.4117E-5,5.6697E-5,6.3333E-5,6.371E-5,1.2878E-4,6.542E-5,5.5817E-5,6.2537E-5,6.4293E-5,1.2906E-4,6.4827E-5,5.5363E-5,6.303E-5,6.402E-5,1.2812E-4,6.441E-5,5.5347E-5,6.2517E-5,6.418E-5,1.2903E-4,6.501E-5,5.591E-5,6.1647E-5,6.4037E-5,1.2853E-4,6.399E-5,5.5823E-5,6.13E-5,6.3883E-5,1.2914E-4,6.391E-5,5.5643E-5,6.2653E-5,6.38E-5,1.292E-4,6.2777E-5,5.5217E-5,6.139E-5,6.391E-5,1.3028E-4,6.361E-5,5.58E-5,6.2117E-5,6.3827E-5,1.2873E-4,6.3777E-5,5.5463E-5,6.2693E-5,6.318E-5,1.2902E-4,6.404E-5,5.579E-5,6.2287E-5,6.3907E-5,1.2914E-4,6.2603E-5,5.4837E-5,6.2937E-5,6.3193E-5,1.2867E-4,6.327E-5,5.537E-5,6.146E-5,6.3037E-5,1.298E-4,6.3473E-5,5.5753E-5,6.165E-5,6.399E-5,0.0:1
1.3133E-6,2.6667E-8,5.6667E-7,8.6333E-7,1.6667E-8,1.2967E-6,-5.1E-7,1.3E-6,-6.1667E-7,-8.6667E-8,6.1333E-7,-7.1E-7,8.5667E-7,8.1333E-7,2.5E-7,3.3667E-7,2.1333E-7,2.6667E-8,-1.0E-7,5.0333E-7,5.3667E-7,1.9667E-7,6.6333E-7,6.6E-7,6.3E-7,5.0E-8,1.6667E-7,9.6E-7,3.6E-7,2.1667E-7,1.7667E-7,-5.5E-7,8.9667E-7,-7.6667E-8,1.4266E-4,1.0177E-4,6.564E-5,8.5937E-5,1.544E-4,8.507E-5,6.7477E-5,8.2127E-5,8.2997E-5,1.7312E-4,9.842E-5,7.758E-5,9.5193E-5,9.9487E-5,1.9533E-4,1.1666E-4,9.111E-5,1.0997E-4,1.2797E-4,2.1173E-4,1.3592E-4,1.0848E-4,1.275E-4,1.5661E-4,2.3185E-4,1.5411E-4,1.1937E-4,1.4026E-4,1.6435E-4,2.263E-4,1.3387E-4,8.3947E-5,7.7173E-5,6.8723E-5,1.345E-4,7.0697E-5,5.7063E-5,6.6313E-5,6.689E-5,1.3487E-4,6.9363E-5,5.637E-5,6.6003E-5,6.548E-5,1.326E-4,6.93E-5,5.6663E-5,6.5417E-5,6.568E-5,1.3376E-4,6.8623E-5,5.6597E-5,6.6107E-5,6.572E-5,1.329E-4,6.732E-5,5.6473E-5,6.498E-5,6.5027E-5,1.3256E-4,6.875E-5,5.6317E-5,6.5433E-5,6.577E-5,1.3436E-4,6.7713E-5,5.5857E-5,6.5423E-5,6.541E-5,1.3405E-4,6.7067E-5,5.7033E-5,6.511E-5,6.5747E-5,1.3326E-4,6.67E-5,5.5333E-5,6.4607E-5,6.4883E-5,1.3417E-4,6.723E-5,5.6057E-5,6.466E-5,6.4197E-5,1.3277E-4,6.7047E-5,5.57E-5,6.4673E-5,6.5247E-5,1.3273E-4,6.6197E-5,5.6093E-5,6.492E-5,6.5933E-5,1.3336E-4,6.575E-5,5.542E-5,6.6003E-5,6.502E-5,1.3211E-4,6.5527E-5,5.563E-5,6.5603E-5,6.3863E-5,1.3406E-4,6.666E-5,5.5153E-5,6.4653E-5,6.411E-5,1.3283E-4,6.476E-5,5.4743E-5,6.4463E-5,6.4373E-5,1.3216E-4,6.5757E-5,5.584E-5,6.527E-5,6.5417E-5,1.3345E-4,6.481E-5,5.602E-5,6.3913E-5,6.4463E-5,1.3297E-4,6.4057E-5,5.5363E-5,6.4917E-5,6.4263E-5,1.3332E-4,6.5407E-5,5.5387E-5,6.394E-5,6.4517E-5,1.328E-4,6.5203E-5,5.5787E-5,6.3963E-5,6.498E-5,1.3278E-4,6.3727E-5,5.608E-5,6.489E-5,6.4077E-5,1.3176E-4,6.5263E-5,5.554E-5,6.367E-5,6.42E-5,1.3277E-4,6.401E-5,5.5573E-5,6.551E-5,6.4327E-5,1.3329E-4,6.441E-5,5.473E-5,6.3733E-5,6.4253E-5,1.3395E-4,6.2873E-5,5.6173E-5,6.414E-5,6.4577E-5,1.3343E-4,6.275E-5,5.669E-5,6.4837E-5,6.5957E-5,1.3326E-4,6.2867E-5,5.6407E-5,6.3883E-5,6.5287E-5,1.3389E-4,6.275E-5,5.721E-5,6.4213E-5,6.5123E-5,1.332E-4,6.2893E-5,5.657E-5,6.4313E-5,6.514E-5,1.3135E-4,6.292E-5,5.789E-5,6.467E-5,6.5517E-5,1.329E-4,6.3323E-5,5.588E-5,6.49E-5,6.637E-5,1.3078E-4,6.2983E-5,5.652E-5,6.422E-5,6.6593E-5,1.3161E-4,6.205E-5,5.7387E-5,6.5377E-5,6.6203E-5,1.3218E-4,6.344E-5,0.0:1
-1.5667E-7,5.9E-7,2.8333E-7,4.0333E-7,1.2367E-6,-2.6667E-7,5.7667E-7,9.0E-8,2.8667E-7,3.5333E-7,3.3333E-8,7.2667E-7,7.5E-7,3.8E-7,1.1E-6,-1.4567E-6,5.8E-7,-1.1333E-7,2.2E-7,1.3E-6,-2.6E-7,7.5E-7,-3.4E-7,3.5667E-7,1.09E-6,2.0667E-7,7.9667E-7,-1.5E-7,-1.2333E-7,6.4333E-7,-2.5333E-7,4.0333E-7,-3.3333E-8,7.1667E-7,7.1667E-7,7.6667E-8,1.3733E-6,6.6323E-5,1.3512E-4,9.9163E-5,8.5807E-5,8.9403E-5,1.2718E-4,1.5333E-4,9.2E-5,8.3623E-5,9.079E-5,1.2761E-4,1.5335E-4,9.329E-5,8.4783E-5,9.228E-5,1.2985E-4,1.5511E-4,9.3287E-5,8.5497E-5,9.4127E-5,1.3298E-4,1.567E-4,9.6863E-5,8.669E-5,9.519E-5,1.3393E-4,1.5939E-4,9.8093E-5,8.959E-5,9.579E-5,1.3789E-4,1.6138E-4,1.0077E-4,9.2237E-5,9.9893E-5,1.4278E-4,1.6509E-4,1.056E-4,9.4587E-5,1.0219E-4,1.4924E-4,1.6835E-4,1.1073E-4,9.8937E-5,1.0514E-4,1.5457E-4,1.7514E-4,1.1587E-4,1.0361E-4,1.1166E-4,1.6415E-4,1.8512E-4,1.2585E-4,1.1239E-4,1.2146E-4,1.7983E-4,2.0029E-4,1.4289E-4,1.2778E-4,1.3818E-4,2.0741E-4,2.3478E-4,4.0393E-5,3.502E-5,4.5617E-5,5.026E-5,8.387E-5,4.1317E-5,3.903E-5,4.33E-5,5.2107E-5,8.194E-5,4.0713E-5,3.8463E-5,4.3233E-5,5.1687E-5,8.051E-5,3.9373E-5,3.8813E-5,4.2043E-5,5.234E-5,7.9757E-5,3.9937E-5,3.8973E-5,4.2213E-5,5.1303E-5,7.8187E-5,3.8203E-5,3.805E-5,4.0717E-5,5.0687E-5,7.8873E-5,3.7267E-5,3.728E-5,4.1787E-5,5.1577E-5,7.6803E-5,3.7547E-5,3.773E-5,4.0983E-5,5.138E-5,7.6393E-5,3.6773E-5,3.7067E-5,4.0747E-5,5.0913E-5,7.6173E-5,3.6393E-5,3.64E-5,4.064E-5,5.1747E-5,7.4993E-5,3.7127E-5,3.7157E-5,3.9477E-5,5.163E-5,7.4973E-5,3.586E-5,3.585E-5,3.989E-5,5.099E-5,7.3147E-5,3.6137E-5,3.6467E-5,3.9847E-5,5.2153E-5,7.313E-5,3.6667E-5,3.6427E-5,3.9893E-5,5.1763E-5,7.3603E-5,3.466E-5,3.6263E-5,3.9333E-5,5.3207E-5,7.331E-5,3.493E-5,3.611E-5,3.8917E-5,5.3763E-5,7.227E-5,3.536E-5,3.65E-5,3.9853E-5,5.3523E-5,7.2913E-5,3.41E-5,3.556E-5,3.9353E-5,5.379E-5,7.1457E-5,3.4467E-5,3.6523E-5,3.8623E-5,5.3467E-5,7.07E-5,3.289E-5,3.5157E-5,3.93E-5,5.3593E-5,7.0267E-5,3.4617E-5,3.5223E-5,3.8213E-5,5.3427E-5,7.0477E-5,3.4367E-5,3.6297E-5,3.7803E-5,5.5223E-5,6.856E-5,3.3397E-5,3.494E-5,3.872E-5,5.4303E-5,6.916E-5,3.323E-5,3.456E-5,3.8553E-5,5.3577E-5,6.973E-5,3.3107E-5,3.5007E-5,3.8143E-5,5.3527E-5,6.877E-5,3.293E-5,3.54E-5,3.8393E-5,5.398E-5,6.7767E-5,3.247E-5,3.5073E-5,3.8697E-5,5.5017E-5,6.8387E-5,3.3857E-5,3.539E-5,3.8143E-5,5.4827E-5,6.7103E-5,3.2983E-5,3.4723E-5,3.788E-5,5.474E-5,6.733E-5,3.276E-5,3.55E-5,3.8653E-5,5.5523E-5,6.6843E-5,3.264E-5,3.4323E-5,3.8297E-5,5.5833E-5,2.273E-5:1
2.6333E-7,1.07E-6,9.3E-7,-7.3667E-7,8.8333E-7,-2.2333E-7,1.0333E-7,-2.7E-7,5.6667E-8,9.7333E-7,8.2667E-7,9.2667E-7,1.42E-6,6.6667E-9,8.2667E-7,4.2333E-7,1.0E-6,9.2E-7,-6.1667E-7,7.2333E-7,3.4E-7,8.5E-7,8.6667E-8,2.9667E-7,4.6333E-7,3.0E-7,5.9667E-7,1.63E-6,2.9667E-7,5.5667E-7,-1.6E-7,1.1867E-6,2.5643E-4,1.0014E-4,9.811E-5,1.1165E-4,1.8649E-4,1.4517E-4,1.0839E-4,1.0371E-4,1.2188E-4,1.9676E-4,1.5599E-4,1.1628E-4,1.1275E-4,1.3357E-4,2.0728E-4,1.6617E-4,1.2719E-4,1.2034E-4,1.4364E-4,2.1705E-4,1.7889E-4,1.3816E-4,1.3097E-4,1.6195E-4,2.4401E-4,2.2061E-4,1.5091E-4,5.975E-5,3.783E-5,8.541E-5,5.9063E-5,4.1033E-5,4.1797E-5,4.592E-5,7.8563E-5,5.8527E-5,3.9927E-5,4.0183E-5,4.428E-5,7.6227E-5,5.774E-5,3.9137E-5,4.0897E-5,4.454E-5,7.7417E-5,5.7357E-5,3.7147E-5,3.9967E-5,4.3307E-5,7.5997E-5,5.5707E-5,3.7863E-5,3.9027E-5,4.3257E-5,7.481E-5,5.613E-5,3.653E-5,3.8997E-5,4.233E-5,7.4953E-5,5.5463E-5,3.6467E-5,3.8357E-5,4.255E-5,7.4457E-5,5.571E-5,3.5703E-5,3.813E-5,4.1557E-5,7.3003E-5,5.4047E-5,3.4663E-5,3.8053E-5,4.0937E-5,7.28E-5,5.5977E-5,3.5973E-5,3.7753E-5,4.0737E-5,7.305E-5,5.4247E-5,3.5167E-5,3.702E-5,4.108E-5,7.476E-5,5.2343E-5,3.416E-5,3.643E-5,4.1533E-5,7.349E-5,5.3017E-5,3.4093E-5,3.6387E-5,4.084E-5,7.3103E-5,5.2117E-5,3.425E-5,3.6517E-5,4.0123E-5,7.2807E-5,5.2813E-5,3.4723E-5,3.727E-5,3.9927E-5,7.1943E-5,5.3963E-5,3.3353E-5,3.7127E-5,3.7873E-5,7.183E-5,5.0953E-5,3.3293E-5,3.6957E-5,4.0803E-5,7.1927E-5,5.2863E-5,3.324E-5,3.6487E-5,3.947E-5,7.095E-5,5.2417E-5,3.2463E-5,3.673E-5,3.8807E-5,7.185E-5,5.0927E-5,3.342E-5,3.6457E-5,3.9593E-5,7.223E-5,5.1183E-5,3.3097E-5,3.633E-5,3.9753E-5,7.2587E-5,5.0173E-5,3.2317E-5,3.7157E-5,3.924E-5,7.192E-5,4.9313E-5,3.2497E-5,3.5123E-5,3.9107E-5,7.257E-5,4.9837E-5,3.2297E-5,3.702E-5,3.866E-5,7.1553E-5,5.026E-5,3.3353E-5,3.5263E-5,3.8997E-5,7.0467E-5,5.082E-5,3.173E-5,3.639E-5,3.9047E-5,7.1507E-5,5.0797E-5,3.2493E-5,3.6343E-5,3.878E-5,7.1393E-5,5.0033E-5,3.1883E-5,3.531E-5,3.8013E-5,7.171E-5,5.103E-5,3.2913E-5,3.5333E-5,3.864E-5,7.1777E-5,4.9113E-5,3.2823E-5,3.5907E-5,3.9133E-5,7.1403E-5,4.9223E-5,3.1767E-5,3.515E-5,3.8167E-5,7.23E-5,4.9307E-5,3.1513E-5,3.4907E-5,3.8107E-5,7.1663E-5,4.9197E-5,3.1853E-5,3.5947E-5,3.772E-5,7.1303E-5,4.8277E-5,3.184E-5,3.512E-5,3.7697E-5,7.1217E-5,4.8753E-5,3.192E-5,3.593E-5,3.878E-5,7.095E-5,4.9907E-5,3.0367E-5,3.6037E-5,3.775E-5,7.058E-5,4.9267E-5,3.1027E-5,3.5087E-5,3.888E-5,6.949E-5,4.9147E-5,3.065E-5,3.485E-5,3.8693E-5,7.1553E-5,4.9237E-5,3.148E-5,3.5847E-5,3.7733E-5,7.1947E-5,4.8677E-5,3.1187E-5,3.511E-5,3.767E-5,7.2003E-5,4.8637E-5,3.1033E-5,3.5723E-5,3.769E-5,7.0533E-5,4.8997E-5,3.0813E-5,3.4677E-5,3.7567E-5,7.137E-5,4.799E-5,3.1E-5,3.4807E-5,3.8547E-5,7.1157E-5,4.8157E-5,3.1253E-5,3.4773E-5,3.7727E-5,7.1103E-5,4.684E-5,2.9757E-5,3.5243E-5,3.677E-5,7.048E-5,4.7153E-5,3.0627E-5,3.407E-5,3.754E-5,7.1523E-5,4.781E-5,3.1693E-5,3.5023E-5,3.719E-5,7.0017E-5,4.8427E-5,3.1247E-5,3.432E-5,3.7317E-5,7.0563E-5,4.839E-5,3.1317E-5,3.4963E-5,3.8227E-5,7.1277E-5,4.8503E-5,3.0433E-5,3.4517E-5,3.769E-5,7.0157E-5,4.7777E-5,3.0987E-5,3.4767E-5,3.716E-5,7.0387E-5,4.7067E-5,3.015E-5,3.4587E-5,0.0:1
-2.4E-7,1.5167E-6,4.8333E-7,1.5667E-7,6.2E-7,-5.0E-8,1.01E-6,8.6E-7,-7.0E-7,8.5E-7,-3.2E-7,3.7333E-7,4.9333E-7,-7.0E-8,3.2333E-7,-1.8E-7,1.0633E-6,0.0,-3.1667E-7,9.0333E-7,6.0E-8,1.0333E-6,9.0E-8,-6.0667E-7,7.3667E-7,-3.8E-7,3.1333E-7,3.3667E-7,5.1333E-7,5.9E-7,5.6333E-7,1.24E-6,7.3E-7,-2.8667E-7,4.8E-7,-1.0533E-6,6.2667E-7,6.6667E-7,-4.0E-8,3.3333E-8,-2.0E-8,1.6667E-7,7.2E-7,1.1848E-4,1.0206E-4,1.0065E-4,1.6371E-4,1.5839E-4,1.1796E-4,9.9633E-5,1.1538E-4,1.7496E-4,1.7039E-4,1.3166E-4,1.0886E-4,1.2588E-4,1.8979E-4,1.8459E-4,1.435E-4,1.1656E-4,1.3714E-4,2.0225E-4,1.9917E-4,1.6489E-4,1.227E-4,6.322E-5,4.9253E-5,7.239E-5,3.6287E-5,3.393E-5,3.893E-5,5.3047E-5,6.803E-5,3.476E-5,3.3703E-5,3.856E-5,5.304E-5,6.8607E-5,3.529E-5,3.2967E-5,3.8257E-5,5.2537E-5,6.7627E-5,3.4003E-5,3.408E-5,3.79E-5,5.2953E-5,6.707E-5,3.493E-5,3.2687E-5,3.826E-5,5.137E-5,6.7373E-5,3.3183E-5,3.2593E-5,3.854E-5,5.1253E-5,6.612E-5,3.354E-5,3.2707E-5,3.744E-5,5.1587E-5,6.669E-5,3.2933E-5,3.221E-5,3.6583E-5,5.1097E-5,6.5787E-5,3.2387E-5,3.282E-5,3.6737E-5,5.121E-5,6.6343E-5,3.257E-5,3.208E-5,3.6493E-5,5.2297E-5,6.6293E-5,3.255E-5,3.1897E-5,3.7003E-5,5.0707E-5,6.5437E-5,3.205E-5,3.205E-5,3.6657E-5,5.192E-5,6.4863E-5,3.207E-5,3.2177E-5,0.0:1
-2.2667E-6,-5.2333E-7,-6.0667E-7,-1.9733E-6,6.4E-7,-6.6333E-7,-6.4E-7,2.5333E-7,-1.9233E-6,7.6667E-8,-1.91E-6,-7.5667E-7,-4.5333E-7,-1.8367E-6,4.7333E-7,-1.53E-6,-2.5667E-7,-2.4333E-7,-1.8967E-6,9.4E-7,-1.6467E-6,-7.2E-7,-5.1667E-7,-2.26E-6,1.4933E-6,-1.74E-6,-3.0333E-7,7.3333E-8,-1.87E-6,1.01E-6,-3.27E-6,-5.4333E-7,-1.7667E-7,-2.39E-6,9.4333E-7,-1.63E-6,-5.1333E-7,-6.7E-7,-2.2933E-6,2.385E-5,2.6737E-4,2.1809E-4,1.1968E-4,1.1329E-4,1.1377E-4,1.7776E-4,1.7398E-4,1.0562E-4,1.0944E-4,1.1064E-4,1.7549E-4,1.7572E-4,1.0514E-4,1.0904E-4,1.1016E-4,1.752E-4,1.7596E-4,1.0581E-4,1.0925E-4,1.112E-4,1.7148E-4,1.7644E-4,1.0463E-4,1.0855E-4,1.1105E-4,1.6975E-4,1.7858E-4,1.0517E-4,1.0725E-4,1.096E-4,1.6934E-4,1.7743E-4,1.0543E-4,1.0592E-4,1.0885E-4,1.6655E-4,1.7927E-4,1.0573E-4,1.0632E-4,1.1013E-4,1.6564E-4,1.8018E-4,1.0441E-4,1.0789E-4,1.0922E-4,1.6486E-4,1.7998E-4,1.0778E-4,1.0709E-4,1.0926E-4,1.6295E-4,1.8094E-4,1.0768E-4,1.0805E-4,1.0982E-4,1.6155E-4,1.8044E-4,1.0566E-4,1.0631E-4,1.0865E-4,1.6336E-4,1.8274E-4,1.0902E-4,1.0721E-4,1.0943E-4,1.6216E-4,1.8223E-4,1.0577E-4,1.0562E-4,1.0921E-4,1.611E-4,1.8598E-4,1.0863E-4,1.0634E-4,1.0918E-4,1.5667E-4,1.8459E-4,1.0934E-4,1.0768E-4,1.1201E-4,1.5836E-4,1.8471E-4,1.0819E-4,1.0774E-4,1.0882E-4,1.5669E-4,1.8762E-4,1.0749E-4,1.0781E-4,1.0774E-4,1.5796E-4,1.8735E-4,1.075E-4,1.0572E-4,1.0851E-4,1.5685E-4,1.8764E-4,1.1027E-4,1.051E-4,1.1079E-4,1.5504E-4,1.8762E-4,1.0938E-4,1.0597E-4,1.1081E-4,1.5441E-4,1.8914E-4,1.0915E-4,1.0658E-4,1.0781E-4,1.5548E-4,1.8835E-4,1.0997E-4,1.0721E-4,1.0894E-4,1.5291E-4,1.9199E-4,1.1019E-4,1.0455E-4,1.0996E-4,1.5292E-4,1.9088E-4,1.1171E-4,1.0542E-4,1.09E-4,1.5234E-4,1.9177E-4,1.1088E-4,1.0665E-4,1.0844E-4,1.4992E-4,1.9368E-4,1.0949E-4,1.0683E-4,1.0974E-4,1.4728E-4,1.9482E-4,1.1175E-4,1.0603E-4,1.1078E-4,1.4743E-4,1.9312E-4,1.1248E-4,1.0636E-4,1.1092E-4,1.4618E-4,1.9517E-4,1.1163E-4,1.0511E-4,1.1027E-4,1.4644E-4,1.9374E-4,1.134E-4,1.0394E-4,1.0849E-4,1.471E-4,1.9418E-4,1.1188E-4,1.0603E-4,1.0942E-4,1.4516E-4,1.9572E-4,1.1255E-4,1.045E-4,1.1107E-4,1.4567E-4,1.95E-4,1.1303E-4,1.0499E-4,1.0718E-4,1.4446E-4,1.9741E-4,1.1334E-4,1.0472E-4,1.0973E-4,1.426E-4,1.959E-4,1.1652E-4,1.0457E-4,1.0867E-4,1.4374E-4,1.9726E-4,1.1488E-4,1.0603E-4,1.0873E-4,1.4107E-4,1.9937E-4,1.1452E-4,1.063E-4,1.1032E-4,1.4102E-4,1.9808E-4,1.1719E-4,1.0373E-4,1.0828E-4,1.4003E-4,1.9876E-4,1.1503E-4,1.0595E-4,1.0891E-4,1.3859E-4,2.0095E-4,1.14E-4,1.0449E-4,1.0968E-4,1.3979E-4,1.9897E-4,1.1629E-4,1.0438E-4,1.0825E-4,1.3618E-4,1.9942E-4,1.1757E-4,1.0564E-4,1.0835E-4,1.3626E-4,2.0181E-4,1.1763E-4,1.0464E-4,1.0774E-4,1.3664E-4,2.0216E-4,1.1596E-4,1.053E-4,1.0935E-4,1.3471E-4,2.0205E-4,1.1697E-4,1.0457E-4,1.103E-4,1.3408E-4,2.0236E-4,1.1668E-4,1.0364E-4,1.0907E-4,1.3345E-4,9.0327E-5:1
-2.83E-6,8.8333E-7,-3.7167E-6,9.6667E-8,-4.1667E-7,-3.3733E-6,9.5667E-7,-2.1667E-6,9.0E-7,-7.0E-7,-2.6833E-6,-9.9999E-9,-2.1467E-6,5.8333E-7,-4.4667E-7,-3.14E-6,5.7667E-7,-1.83E-6,-1.5E-7,-1.4133E-6,-2.24E-6,4.6333E-7,-3.09E-6,-4.8E-7,-1.4933E-6,-1.8767E-6,1.1333E-6,-2.4567E-6,-4.4333E-7,-1.3233E-6,-2.08E-6,1.0333E-7,-1.17E-6,7.5667E-7,-1.3833E-6,-2.9567E-6,2.5667E-7,-1.36E-6,-9.0E-8,-7.8667E-7,-2.4533E-6,5.9333E-7,-3.91E-6,6.9333E-7,-9.5667E-7,-2.86E-6,2.6E-7,-1.66E-6,3.0667E-7,-5.6E-7,-1.55E-6,5.5333E-7,-1.75E-6,8.7E-7,-1.1833E-6,-2.39E-6,7.5667E-7,-2.3767E-6,3.4333E-7,-1.4067E-6,-3.1067E-6,3.4E-7,-2.1833E-6,-1.2E-7,-1.2933E-6,-3.18E-6,1.2533E-6,-2.47E-6,2.5667E-7,-1.98E-6,-2.7233E-6,3.0E-7,-2.28E-6,9.8333E-7,-1.06E-6,-2.5167E-6,1.3267E-6,-2.9667E-6,1.0667E-6,-1.0667E-6,2.2316E-4,1.8042E-4,1.0609E-4,2.0744E-4,1.4718E-4,9.967E-5,1.0248E-4,1.1317E-4,1.9165E-4,1.4855E-4,1.0141E-4,1.0096E-4,1.1228E-4,1.9141E-4,1.4823E-4,1.01E-4,1.0095E-4,1.126E-4,1.8987E-4,1.4849E-4,1.0044E-4,1.0045E-4,1.1288E-4,1.8775E-4,1.4851E-4,1.0032E-4,9.9597E-5,1.1278E-4,1.8683E-4,1.4759E-4,1.0081E-4,1.0068E-4,1.1258E-4,1.8801E-4,1.488E-4,1.0242E-4,1.0009E-4,1.118E-4,1.8752E-4,1.5025E-4,1.0145E-4,1.0028E-4,1.1217E-4,1.8619E-4,1.5057E-4,1.0247E-4,1.0054E-4,1.1075E-4,1.8614E-4,1.4876E-4,1.0077E-4,9.9897E-5,1.1014E-4,1.8465E-4,1.4991E-4,1.0037E-4,1.0086E-4,1.1093E-4,1.8387E-4,1.5316E-4,1.0235E-4,1.0034E-4,1.1082E-4,1.8486E-4,1.5329E-4,1.0111E-4,1.0186E-4,1.115E-4,1.8295E-4,1.5247E-4,1.0112E-4,9.8973E-5,1.1158E-4,1.8274E-4,1.5274E-4,1.0166E-4,1.0133E-4,1.1033E-4,1.8161E-4,1.5473E-4,1.0163E-4,1.0154E-4,1.0992E-4,1.8267E-4,1.5332E-4,1.0227E-4,9.9873E-5,1.1198E-4,1.8081E-4,1.5631E-4,1.0206E-4,1.0118E-4,1.1009E-4,1.8032E-4,1.5594E-4,1.0293E-4,1.0096E-4,1.1067E-4,1.7977E-4,1.5766E-4,1.057E-4,1.0227E-4,1.122E-4,1.796E-4,1.5834E-4,1.0543E-4,1.0228E-4,1.1247E-4,1.7893E-4,1.59E-4,1.0354E-4,1.0001E-4,1.0988E-4,1.7763E-4,1.591E-4,1.0366E-4,1.0095E-4,1.1275E-4,1.7637E-4,1.5843E-4,1.0512E-4,9.8627E-5,1.1168E-4,1.7691E-4,1.5976E-4,1.0464E-4,9.9767E-5,1.1209E-4,1.7535E-4,1.5963E-4,1.0623E-4,9.9497E-5,1.1114E-4,1.7428E-4,1.6077E-4,1.0473E-4,9.985E-5,1.113E-4,1.7446E-4,1.6054E-4,1.0599E-4,9.9133E-5,1.1182E-4,1.7345E-4,1.617E-4,1.0543E-4,1.0064E-4,1.1158E-4,1.7059E-4,1.628E-4,1.0588E-4,9.9407E-5,1.1146E-4,1.708E-4,1.618E-4,1.0752E-4,1.001E-4,1.1061E-4,1.7073E-4,1.6371E-4,1.0584E-4,1.0108E-4,1.0996E-4,1.6899E-4,1.6463E-4,1.0739E-4,9.8647E-5,1.0982E-4,1.7013E-4,1.6521E-4,1.0753E-4,9.888E-5,1.0997E-4,1.6699E-4,1.6666E-4,1.0876E-4,1.0042E-4,1.1149E-4,1.6867E-4,1.6892E-4,1.0897E-4,1.0077E-4,1.1217E-4,1.669E-4,1.6724E-4,1.0484E-4,9.8037E-5,1.0971E-4,1.6626E-4,1.6794E-4,1.0789E-4,9.9997E-5,1.1081E-4,1.6569E-4,1.6752E-4,1.0667E-4,9.838E-5,1.0823E-4,1.6495E-4,1.6828E-4,1.0915E-4,9.8527E-5,1.0812E-4,1.6242E-4,1.6899E-4,1.103E-4,9.8483E-5,1.097E-4,1.6317E-4,1.7062E-4,1.0783E-4,9.818E-5,1.1082E-4,1.6069E-4,1.7127E-4,1.0985E-4,9.8253E-5,1.0946E-4,1.6161E-4,1.7149E-4,1.1136E-4,9.8977E-5,1.1E-4,1.5968E-4,1.7356E-4,1.0969E-4,9.8317E-5,1.1196E-4,1.579E-4,1.7476E-4,1.113E-4,9.799E-5,1.1132E-4,1.569E-4,1.7441E-4,1.0988E-4,9.998E-5,1.0852E-4,1.5752E-4,1.7698E-4,1.1107E-4,9.922E-5,1.091E-4,1.5659E-4,1.7596E-4,1.1048E-4,9.7247E-5,1.0944E-4,1.5597E-4,1.7598E-4,1.1027E-4,1.0049E-4,1.1033E-4,1.5383E-4,1.7606E-4,1.1299E-4,9.8183E-5,1.1E-4,1.5162E-4,1.7709E-4,1.1124E-4,9.8457E-5,1.1003E-4,1.5236E-4,1.771E-4,1.1137E-4,9.7503E-5,1.0854E-4,1.5137E-4,1.7949E-4,1.1359E-4,9.921E-5,1.111E-4,1.5177E-4,1.7977E-4,1.1312E-4,1.0383E-4:1
-3.0447E-5,2.4897E-4,-4.0788E-4,3.669E-4,-2.6665E-4,-4.395E-5,2.0849E-4,-2.2004E-4,3.4094E-4,-2.6403E-4,-6.2327E-5,3.1124E-4,-1.8466E-4,4.961E-4,-1.9891E-4,-6.899E-5,1.437E-4,-1.486E-4,4.3332E-4,-3.8795E-4,1.2741E-4,1.7413E-4,-2.4242E-4,3.362E-4,-3.0374E-4,-7.4567E-6,0.060707,0.040302,0.041778,0.070531,0.063338,0.040941,0.044126,0.045926,0.073503,0.067153,0.043171,0.042162,0.039194,0.050493,0.039546,0.021795,0.022719,0.0239,0.03613,0.037446,0.021392,0.022188,0.023834,0.035167,0.037624,0.021257,0.021943,0.023588,0.034439,0.037831,0.021213,0.021907,0.023403,0.033781,0.038338,0.021415,0.021529,0.023418,0.033172,0.038496,0.021621,0.021621,0.023319,0.032769,0.038877,0.021685,0.02168,0.023243,0.032504,0.039205,0.021887,0.021631,0.023208,0.032119,0.039469,0.021883,0.021444,0.023198,0.03149,0.039909,0.022299,0.021626,0.023243,0.030962,0.040252,0.022446,0.021504,0.023121,0.030382,0.040756,0.022688,0.021311,0.023177,0.030133,0.041223,0.022758,0.021369,0.023096,0.029485,0.041469,0.023179,0.021407,0.023066,0.028861,0.041782,0.023297,0.0213,0.023055,0.028106,0.042526,0.023417,0.02125,0.023157,0.027536,0.04288,0.023758,0.021392,0.022906,0.026997,0.04324,0.023891,0.021396,0.02305,0.026152,0.043671,0.02425,0.021391,0.022883,0.025954,0.04418,0.024394,0.021001,0.022912,0.025423,0.044429,0.02451,0.021164,0.022876,0.02499,0.044691,0.024723,0.020918,0.022855,0.02457,0.04489,0.025128,0.021029,0.022824,0.023997,0.045219,0.025413,0.020941,0.022825,0.023741,0.045257,0.025696,0.020838,0.022776,0.023569,0.045045,0.026019,0.020863,0.022708,0.023412,0.044999,0.026329,0.02088,0.022566,0.023523,0.044889,0.026559,0.02094,0.022734,0.023352,0.044523,0.026777,0.020719,0.022499,0.023194,0.044495,0.027022,0.020688,0.022556,0.023326,0.044283,0.027351,0.020553,0.022231,0.023415,0.043758,0.027731,0.020805,0.022417,0.023541,0.0:1
-4.8395E-4,5.0196E-4,-3.8586E-4,2.9223E-5,2.4819E-4,-4.4799E-4,4.1514E-4,-2.5223E-4,-2.9707E-5,1.4672E-4,-4.256E-4,3.7959E-4,-2.5163E-4,1.2034E-4,2.9897E-4,-2.3803E-4,3.4188E-4,0.025688,0.028913,0.0165,0.018474,0.017416,0.031563,0.027787,0.016075,0.018916,0.020959,0.035678,0.032682,0.019867,0.02247,0.025343,0.043683,0.040155,0.026051,0.029332,0.032553,0.05721,0.053381,0.03506,0.038449,0.041786,0.0679,0.059657,0.038427,0.04186,0.044317,0.070218,0.061602,0.036977,0.034109,0.026267,0.036906,0.034468,0.019683,0.0209,0.022557,0.034919,0.034217,0.019577,0.020863,0.022622,0.034505,0.034639,0.019791,0.020895,0.022484,0.033893,0.035043,0.019878,0.020839,0.022374,0.033795,0.035554,0.019935,0.020883,0.022635,0.033458,0.035698,0.019743,0.020815,0.022432,0.032977,0.036207,0.019957,0.020829,0.022334,0.032508,0.036511,0.020234,0.020775,0.022306,0.032357,0.036727,0.020302,0.020536,0.022254,0.031955,0.037197,0.020459,0.020704,0.022242,0.031364,0.037453,0.020697,0.020515,0.022427,0.031214,0.037449,0.020745,0.020541,0.022462,0.030772,0.038051,0.021078,0.020346,0.022232,0.03027,0.038128,0.021078,0.020531,0.022209,0.030022,0.03858,0.021061,0.020467,0.022142,0.029513,0.038605,0.021437,0.020396,0.022057,0.028759,0.039131,0.021536,0.020402,0.022123,0.028345,0.039572,0.021869,0.020451,0.022053,0.027846,0.039759,0.021914,0.020249,0.022021,0.027311,0.040351,0.02218,0.020292,0.022098,0.027078,0.04046,0.02257,0.020307,0.021942,0.02638,0.041102,0.022514,0.020224,0.022008,0.025905,0.04122,0.022601,0.020092,0.022143,0.025307,0.041826,0.022962,0.019971,0.021847,0.025003,0.041747,0.023177,0.020081,0.021823,0.02439,0.0421,0.023296,0.020004,0.021829,0.023893,0.042536,0.023551,0.019869,0.021686,0.023716,0.042655,0.023805,0.020041,0.021636,0.023192,0.043131,0.023919,0.019988,0.021579,0.023178,0.042971,0.024117,0.0:1
-2.2127E-4,5.8137E-5,1.246E-4,-3.5319E-4,2.8693E-4,-1.0306E-4,1.4833E-5,2.034E-4,-3.1866E-4,3.5756E-4,-1.9416E-4,1.8434E-4,1.4715E-4,-2.5757E-4,3.9732E-4,-3.7784E-4,1.2287E-4,1.68E-4,-2.9752E-4,2.9795E-4,-3.4744E-4,7.98E-6,2.9689E-4,-2.9184E-4,0.033669,0.032645,0.039288,0.025087,0.023478,0.02474,0.034469,0.04706,0.030624,0.02912,0.032017,0.047624,0.058716,0.040447,0.037696,0.038357,0.056296,0.063845,0.043982,0.039372,0.041348,0.058779,0.065727,0.045365,0.035734,0.027336,0.028128,0.041046,0.023175,0.020901,0.022112,0.025928,0.040464,0.023148,0.0205,0.021961,0.025384,0.040223,0.023027,0.020467,0.021684,0.02512,0.04031,0.023043,0.020385,0.021809,0.02475,0.040609,0.02306,0.020298,0.021758,0.024583,0.040918,0.023151,0.020151,0.021553,0.024274,0.040825,0.02329,0.020143,0.021645,0.023884,0.041041,0.023514,0.020001,0.021489,0.023662,0.041084,0.023625,0.020249,0.021427,0.023447,0.041247,0.02358,0.020121,0.021381,0.023036,0.04137,0.023562,0.019905,0.021488,0.022795,0.041405,0.023774,0.019919,0.021466,0.022347,0.04124,0.023755,0.020025,0.021192,0.022035,0.041411,0.023948,0.019776,0.021127,0.022298,0.04154,0.023956,0.019798,0.021127,0.021971,0.041355,0.02425,0.019672,0.021132,0.021864,0.041272,0.024327,0.019762,0.021091,0.021639,0.041328,0.024372,0.019644,0.020942,0.021746,0.041076,0.024423,0.019484,0.021012,0.021629,0.040977,0.02446,0.019663,0.02091,0.021543,0.040858,0.024711,0.019485,0.020808,0.021613,0.040817,0.024825,0.019395,0.020838,0.021506,0.040585,0.025175,0.01941,0.02089,0.021266,0.040264,0.025223,0.019406,0.020757,0.021594,0.040137,0.02552,0.019385,0.020774,0.021473,0.040056,0.025578,0.019261,0.020696,0.021459,0.03992,0.025731,0.019441,0.020498,0.021528,0.039781,0.025913,0.019236,0.020702,0.021261,0.039488,0.026167,0.019169,0.02063,0.021419,0.039229,0.026199,0.019143,0.020686,0.0:1
-0.0014623,9.6447E-4,-1.9986E-4,-8.5965E-4,0.0017351,-0.0012707,9.4809E-4,8.4833E-6,-6.4584E-4,0.0016386,-0.0012305,9.5416E-4,-1.8648E-4,-3.0255E-4,0.0012142,-0.0011436,0.0010446,-4.3559E-4,-3.8604E-4,0.0012507,-0.0012899,0.0013415,-2.9706E-4,-7.1085E-4,0.0016447,-0.0013091,0.0016175,-1.3758E-4,-8.9957E-4,0.076392,0.1295,0.19472,0.17883,0.12467,0.12592,0.14824,0.22136,0.1899,0.13032,0.13039,0.15724,0.22645,0.1912,0.13358,0.13255,0.16273,0.22985,0.19319,0.1349,0.13422,0.154,0.22236,0.16866,0.10354,0.098317,0.10028,0.16625,0.13963,0.089989,0.09222,0.097462,0.16438,0.13804,0.089284,0.091509,0.097226,0.16434,0.1355,0.088072,0.091485,0.096241,0.16493,0.1341,0.087787,0.090909,0.095839,0.1649,0.13232,0.08768,0.090728,0.095924,0.16519,0.13213,0.086737,0.090577,0.095567,0.1671,0.13009,0.086981,0.09133,0.095685,0.16718,0.12939,0.086493,0.090546,0.095357,0.16828,0.12887,0.085857,0.091082,0.095084,0.16867,0.12745,0.085577,0.091429,0.095244,0.16989,0.12648,0.085755,0.090817,0.095878,0.17005,0.12634,0.085977,0.091305,0.095341,0.17093,0.12528,0.086182,0.091436,0.09577,0.1713,0.12478,0.085383,0.091284,0.095517,0.172,0.12335,0.085588,0.091166,0.095649,0.17329,0.12328,0.086079,0.091353,0.096121,0.1738,0.12235,0.085287,0.091134,0.094792,0.17413,0.12126,0.084787,0.090972,0.095978,0.17492,0.12046,0.08524,0.09152,0.09544,0.17614,0.11944,0.085455,0.091547,0.095811,0.17638,0.11849,0.085371,0.091782,0.095682,0.17645,0.11721,0.085136,0.091584,0.095866,0.1766,0.11695,0.085162,0.090854,0.096592,0.17691,0.11621,0.085258,0.091633,0.097311,0.17716,0.11489,0.085707,0.091606,0.097999,0.17695,0.11437,0.085532,0.091942,0.098578,0.1773,0.1133,0.085607,0.091721,0.099501,0.17724,0.11245,0.085282,0.091792,0.10036,0.17714,0.11182,0.086001,0.092385,0.0:1
-9.6762E-4,0.0010161,-7.1915E-4,3.2698E-6,9.776E-4,-0.0018962,0.001086,-4.813E-5,-1.536E-4,0.0013561,-0.0010119,0.0016056,-9.1019E-4,3.5097E-5,0.0014294,-0.0014908,8.4128E-4,-4.1107E-4,-4.1046E-4,0.001081,-0.0014339,0.0014466,-5.71E-4,-4.9627E-4,7.5197E-4,-0.0012684,0.001467,-3.2986E-4,-2.1374E-4,0.0011803,-0.0011777,0.0012521,0.37156,0.15431,0.12566,0.14953,0.21126,0.22844,0.15775,0.13431,0.14702,0.22255,0.22869,0.1586,0.13754,0.15133,0.2274,0.22955,0.16034,0.13882,0.15353,0.22823,0.21379,0.13726,0.11339,0.10784,0.15217,0.17465,0.11266,0.099008,0.1039,0.14471,0.17207,0.1098,0.097292,0.10274,0.14535,0.17092,0.10925,0.096707,0.10285,0.14559,0.16908,0.10791,0.097304,0.10258,0.14606,0.16817,0.10673,0.096779,0.10259,0.14661,0.16675,0.10628,0.096289,0.10168,0.14685,0.16611,0.1052,0.095796,0.10107,0.14804,0.16479,0.1053,0.095338,0.10124,0.14786,0.1643,0.1037,0.095106,0.10081,0.14854,0.16333,0.10284,0.095521,0.10066,0.14883,0.16319,0.10247,0.094981,0.10038,0.14917,0.16241,0.10199,0.094717,0.1006,0.14988,0.16149,0.10179,0.095124,0.10044,0.1505,0.16136,0.10129,0.095337,0.10007,0.15141,0.15977,0.10035,0.095201,0.09997,0.15183,0.15914,0.10021,0.094937,0.10022,0.15249,0.15834,0.099464,0.094683,0.10009,0.15356,0.15753,0.098655,0.094296,0.09988,0.15432,0.15656,0.098209,0.094123,0.099716,0.15499,0.15551,0.098584,0.095174,0.10036,0.15515,0.15529,0.097543,0.09473,0.099267,0.15581,0.1536,0.097392,0.094382,0.099512,0.15724,0.1532,0.096553,0.094439,0.099769,0.15821,0.1516,0.097014,0.094757,0.099351,0.15898,0.15165,0.096032,0.094629,0.099576,0.15909,0.15027,0.095805,0.094309,0.09942,0.1597,0.15029,0.094932,0.09497,0.099688,0.16104,0.14952,0.095017,0.094948,0.099107,0.16193,0.14766,0.093508,0.094476,0.0:1
-4.7442E-4,-1.2578E-4,7.0604E-4,-6.7981E-4,9.3601E-4,-6.2632E-4,5.9606E-4,8.6169E-4,-9.6925E-4,8.401E-4,-2.1531E-4,7.1273E-5,5.8509E-4,0.038787,0.057547,0.07731,0.059433,0.041238,0.043007,0.055293,0.082174,0.063252,0.042644,0.045751,0.05678,0.08332,0.064958,0.042802,0.046698,0.056591,0.083644,0.06448,0.043418,0.047364,0.058511,0.086015,0.068383,0.045752,0.049501,0.062676,0.090521,0.072204,0.048286,0.051932,0.065739,0.063768,0.026295,0.014576,0.012338,0.017329,0.028231,0.022008,0.012823,0.013435,0.017203,0.027327,0.021879,0.012637,0.013355,0.017093,0.027125,0.02206,0.012195,0.013573,0.016469,0.026827,0.022477,0.012099,0.013055,0.016905,0.026784,0.02261,0.012104,0.012975,0.016666,0.026102,0.022582,0.011481,0.013301,0.016998,0.025871,0.02236,0.011838,0.01282,0.016403,0.025729,0.022941,0.011755,0.012957,0.016579,0.025241,0.023123,0.011761,0.01279,0.01647,0.025082,0.022664,0.011698,0.013285,0.016679,0.025079,0.023481,0.011564,0.012715,0.01604,0.024471,0.023427,0.011673,0.012652,0.016408,0.025199,0.023612,0.01177,0.012396,0.016233,0.024939,0.023098,0.011541,0.012756,0.016432,0.023774,0.023571,0.011478,0.01224,0.016056,0.023912,0.024447,0.011339,0.012828,0.016648,0.023972,0.024252,0.010994,0.012834,0.016202,0.023157,0.024119,0.011645,0.012395,0.016238,0.023439,0.024443,0.010905,0.012256,0.016027,0.023028,0.024497,0.010866,0.012499,0.016103,0.0228,0.025011,0.011423,0.012441,0.016213,0.022992,0.024888,0.011402,0.012584,0.016125,0.022658,0.024744,0.010913,0.011858,0.01606,0.022188,0.025596,0.010825,0.012368,0.016162,0.022165,0.025458,0.010636,0.012576,0.016222,0.02216,0.024911,0.011163,0.012082,0.015795,0.021857,0.025714,0.011424,0.012923,0.015936,0.021249,0.026344,0.010412,0.012281,0.015923,0.020678,0.026413,0.010776,0.012614,0.015806,0.020919,0.026472,0.010814,0.012275,0.015838,0.0:1
3.0312E-4,-9.8004E-4,7.6638E-4,-6.9211E-4,5.2458E-4,3.2012E-4,-4.5458E-4,0.0010752,-1.7528E-4,3.3965E-4,3.9944E-4,-9.68E-4,9.4694E-4,-7.4929E-4,2.5574E-4,2.3961E-4,-6.5273E-4,6.9722E-4,-8.521E-4,3.293E-5,3.6435E-4,-7.5372E-4,8.4644E-4,-7.2258E-4,3.4719E-4,4.8444E-4,-5.2714E-4,8.816E-4,-3.5482E-4,1.8055E-4,4.4276E-4,-5.2565E-4,9.3699E-4,-8.2332E-4,4.0605E-4,0.084379,0.04314,0.05181,0.066164,0.079492,0.049973,0.04465,0.049947,0.067701,0.079315,0.05002,0.04509,0.050309,0.06856,0.080655,0.05122,0.045671,0.050847,0.069641,0.08069,0.051942,0.045933,0.051286,0.070829,0.08285,0.052235,0.046158,0.051861,0.071477,0.083255,0.052573,0.046687,0.052456,0.07184,0.083656,0.053146,0.047941,0.053949,0.07474,0.086409,0.056189,0.050527,0.05623,0.077569,0.090254,0.05781,0.051333,0.057836,0.080849,0.092885,0.06012,0.053385,0.058822,0.08427,0.094966,0.061775,0.05541,0.061829,0.086694,0.097162,0.064603,0.052174,0.029133,0.017863,0.043548,0.021378,0.018311,0.022687,0.020219,0.042006,0.020149,0.017367,0.02096,0.019657,0.041759,0.019726,0.017506,0.02053,0.019036,0.040678,0.019523,0.016734,0.020223,0.018856,0.040284,0.019108,0.016481,0.019997,0.019048,0.040655,0.01856,0.01661,0.020082,0.018296,0.039716,0.018761,0.015711,0.019885,0.018119,0.039535,0.018766,0.015631,0.019715,0.018541,0.039224,0.017975,0.015714,0.01931,0.018234,0.039275,0.018116,0.015537,0.018846,0.017447,0.038508,0.017646,0.015422,0.019136,0.017604,0.038187,0.01778,0.014991,0.018393,0.017814,0.038004,0.017826,0.014587,0.0191,0.017673,0.037891,0.017163,0.014638,0.018792,0.017363,0.037476,0.017657,0.014834,0.01845,0.017203,0.037657,0.017208,0.015001,0.018464,0.017158,0.037694,0.017029,0.014325,0.017949,0.016832,0.037358,0.016596,0.014704,0.018407,0.017477,0.037551,0.017081,0.014008,0.018141,0.017041,0.036887,0.017301,0.013636,0.017706,0.016626,0.037005,0.0:1
3.9083E-4,3.4569E-4,-7.4307E-4,9.3126E-4,-6.7548E-4,6.7582E-4,6.0867E-4,-8.2752E-4,7.9111E-4,-4.6652E-4,4.2352E-4,3.9966E-4,-7.7145E-4,0.0010289,-3.199E-4,3.388E-4,4.3983E-4,0.074266,0.035328,0.060768,0.062975,0.039863,0.037627,0.040305,0.05865,0.063464,0.039784,0.037719,0.041253,0.059245,0.064508,0.041053,0.038442,0.041743,0.060331,0.065648,0.041895,0.03899,0.042476,0.061578,0.066496,0.042131,0.039346,0.04291,0.061212,0.06643,0.042092,0.039581,0.04309,0.06255,0.068618,0.043641,0.040675,0.044713,0.065701,0.070648,0.044429,0.042442,0.04649,0.068629,0.072703,0.046552,0.043856,0.047761,0.070832,0.074298,0.048142,0.045732,0.049282,0.072837,0.076111,0.049519,0.042771,0.023023,0.016585,0.035372,0.017015,0.015202,0.018165,0.017878,0.034032,0.016148,0.014922,0.017651,0.017594,0.033118,0.015694,0.014658,0.017622,0.017231,0.032978,0.014855,0.014318,0.017225,0.017093,0.032439,0.015104,0.01432,0.016383,0.016895,0.032147,0.014312,0.014137,0.016461,0.016969,0.032022,0.014251,0.013952,0.016542,0.016728,0.032233,0.014156,0.013332,0.016274,0.016721,0.032172,0.014062,0.013739,0.016173,0.015926,0.031498,0.013882,0.013448,0.016324,0.016382,0.031608,0.013613,0.012898,0.015842,0.016388,0.03121,0.013497,0.013202,0.01535,0.015713,0.031018,0.013037,0.012916,0.015787,0.015705,0.030907,0.013213,0.01305,0.015736,0.015545,0.03131,0.012885,0.012473,0.014968,0.01571,0.030475,0.012429,0.012739,0.015671,0.015234,0.030304,0.013108,0.012423,0.015226,0.015287,0.030907,0.012727,0.012267,0.015363,0.014991,0.030614,0.012543,0.012178,0.015114,0.015021,0.030534,0.012063,0.012485,0.015104,0.015303,0.030669,0.01264,0.012106,0.014768,0.015005,0.030299,0.012561,0.011944,0.014938,0.015115,0.029965,0.012222,0.01215,0.014577,0.014858,0.030212,0.012086,0.012058,0.014895,0.014557,0.030438,0.011958,0.011762,0.014855,0.014394,0.0:1
5.8308E-4,-3.0503E-4,-2.9189E-4,3.1381E-4,-0.0011473,4.5811E-4,-2.4758E-4,2.8189E-4,2.2412E-4,-4.9709E-4,9.6703E-4,-4.0529E-4,2.459E-5,5.5533E-4,-6.9121E-4,0.0012029,-1.6554E-4,-6.0943E-5,6.8444E-4,-9.9096E-4,7.2156E-4,-2.7427E-4,-2.0301E-4,4.0161E-4,-5.9696E-4,0.031662,0.11984,0.1059,0.070211,0.063958,0.071091,0.091695,0.054129,0.038674,0.041236,0.046404,0.082099,0.054442,0.037662,0.039985,0.045412,0.079729,0.053703,0.037367,0.03996,0.044954,0.079259,0.05389,0.037365,0.03964,0.045318,0.078418,0.054049,0.036851,0.039977,0.044758,0.077417,0.05506,0.037047,0.039722,0.044834,0.077586,0.055491,0.036571,0.0398,0.044659,0.077059,0.055831,0.036709,0.039752,0.044622,0.076531,0.056449,0.037224,0.039895,0.044407,0.075764,0.057367,0.036624,0.039308,0.044745,0.075471,0.058243,0.03606,0.039609,0.044394,0.074496,0.058742,0.036265,0.040076,0.044039,0.074168,0.059045,0.0363,0.039564,0.044134,0.073694,0.05983,0.036508,0.039857,0.044031,0.073462,0.060857,0.03614,0.039632,0.0444,0.073144,0.061277,0.036205,0.039472,0.043895,0.072077,0.061605,0.036005,0.039441,0.043812,0.071889,0.062192,0.035609,0.039547,0.044019,0.070815,0.06329,0.036229,0.039616,0.043723,0.069782,0.063822,0.035658,0.039738,0.043819,0.069861,0.064003,0.036137,0.039409,0.044016,0.06952,0.064862,0.036204,0.039952,0.043642,0.068697,0.06541,0.035719,0.03909,0.043639,0.067857,0.066089,0.036236,0.039811,0.043767,0.06718,0.067416,0.036279,0.039666,0.043707,0.066965,0.067538,0.036731,0.039187,0.043894,0.065894,0.067907,0.036142,0.039375,0.043827,0.065534,0.068551,0.036179,0.039169,0.043643,0.064912,0.069379,0.036542,0.039081,0.04372,0.063829,0.070283,0.036284,0.039373,0.043725,0.063696,0.07071,0.036945,0.039086,0.043666,0.062485,0.071339,0.036894,0.038912,0.043502,0.062093,0.072006,0.036751,0.039208,0.043975,0.0614,0.072296,0.036999,0.039162,0.0:1
4.3812E-4,-6.6905E-4,7.8086E-4,-2.8126E-4,4.2393E-4,5.0907E-4,-8.3554E-4,5.6466E-4,-6.5539E-4,2.9649E-4,5.9178E-4,-6.7914E-4,8.9062E-4,-1.8916E-4,5.7423E-5,3.8859E-4,-5.3312E-4,4.5414E-4,0.085039,0.12992,0.076241,0.07723,0.075382,0.11149,0.094387,0.059782,0.0526,0.049291,0.07213,0.070316,0.041565,0.042634,0.046604,0.070495,0.069919,0.040907,0.042611,0.046135,0.06894,0.069843,0.040466,0.041458,0.045331,0.068058,0.069023,0.040326,0.041553,0.045416,0.067277,0.069169,0.039993,0.04123,0.045333,0.0667,0.069682,0.03943,0.04122,0.044924,0.065714,0.069698,0.039668,0.040236,0.044693,0.065154,0.070069,0.03939,0.040519,0.044445,0.064171,0.070374,0.039131,0.040082,0.044498,0.063937,0.070722,0.038998,0.040019,0.043862,0.062792,0.070462,0.038773,0.039969,0.043819,0.06215,0.071443,0.038786,0.039821,0.04354,0.061307,0.07165,0.038717,0.039653,0.043343,0.060765,0.071499,0.03874,0.03944,0.043521,0.06006,0.072386,0.038852,0.039171,0.043464,0.059784,0.072506,0.038976,0.039229,0.043073,0.0588,0.073192,0.038442,0.039081,0.042892,0.057898,0.073285,0.038819,0.038535,0.042938,0.057314,0.073252,0.038656,0.039203,0.043061,0.056828,0.074307,0.038714,0.038399,0.042676,0.056257,0.074764,0.038751,0.038601,0.042675,0.055612,0.074774,0.038713,0.038993,0.043144,0.054924,0.074949,0.03887,0.038728,0.042364,0.054014,0.075881,0.038879,0.038791,0.042653,0.053611,0.075922,0.038884,0.038564,0.042134,0.052839,0.076407,0.039414,0.038496,0.04256,0.052011,0.076897,0.039196,0.038755,0.041891,0.052115,0.077367,0.039808,0.037757,0.041726,0.050892,0.076785,0.039401,0.038202,0.041972,0.050241,0.078168,0.039698,0.037645,0.041997,0.049878,0.07821,0.039749,0.038086,0.041772,0.049158,0.078569,0.03964,0.037827,0.042171,0.04881,0.079106,0.040036,0.037963,0.04158,0.048146,0.079423,0.040166,0.037941,0.04139,0.047434,0.079895,0.0:1
-0.0028857,0.002033,-0.0025896,-5.0173E-5,8.9026E-4,-0.0034962,0.0025313,-0.0033722,-1.4545E-4,0.0013401,-0.0026783,0.0021936,-0.0019611,-5.4056E-4,0.0011868,-0.0029578,0.002029,-0.0017994,-8.122E-4,0.0011992,-0.0032602,0.0019913,-0.0025763,-2.7086E-4,0.17413,0.11585,0.063063,0.12761,0.11925,0.066544,0.072,0.08211,0.12671,0.13091,0.07542,0.081161,0.094058,0.14987,0.14571,0.088938,0.094223,0.10805,0.17525,0.16406,0.10372,0.10964,0.12269,0.19887,0.17883,0.11347,0.11372,0.12464,0.19979,0.17246,0.092812,0.065813,0.062721,0.087318,0.096435,0.050875,0.051605,0.060493,0.082881,0.094356,0.049525,0.050796,0.059868,0.081566,0.093319,0.048735,0.050637,0.059456,0.080585,0.093148,0.048006,0.050038,0.058877,0.081603,0.091576,0.047241,0.049237,0.059143,0.080874,0.091154,0.046924,0.049477,0.058673,0.08122,0.091079,0.04665,0.049048,0.05831,0.080268,0.090329,0.046438,0.049205,0.058283,0.080927,0.089864,0.046659,0.049384,0.058029,0.080982,0.089821,0.046917,0.048694,0.057497,0.080744,0.088768,0.046495,0.048838,0.057811,0.081015,0.089584,0.046018,0.048984,0.057475,0.080301,0.088399,0.046219,0.048839,0.058149,0.080751,0.088163,0.046277,0.048733,0.057228,0.081385,0.088533,0.045264,0.048403,0.057636,0.081761,0.08802,0.045889,0.047889,0.057116,0.081378,0.087095,0.046436,0.049036,0.056829,0.081738,0.087233,0.04558,0.0479,0.056717,0.081799,0.087436,0.045802,0.047939,0.056466,0.082396,0.086314,0.045178,0.048751,0.057059,0.082952,0.086872,0.045067,0.048724,0.056612,0.081737,0.086218,0.045609,0.04795,0.056894,0.082899,0.085607,0.044623,0.047872,0.056533,0.082483,0.08507,0.045614,0.048097,0.056855,0.083304,0.084568,0.045398,0.04786,0.057215,0.082776,0.084212,0.045889,0.04767,0.057106,0.082117,0.084217,0.04543,0.048477,0.056447,0.083021,0.085087,0.045559,0.048174,0.056668,0.082487,0.085279,0.044858,0.0:1
0.0011808,-0.0033312,0.0019503,-0.0024654,-7.8989E-4,0.0019333,-0.0026803,0.0021584,-0.0016278,-0.0013031,0.0014392,-0.0032197,0.0017875,-0.0020323,-0.0011031,0.001816,-0.0037781,0.0021716,-0.0016234,-4.5571E-4,0.0011553,-0.0033979,0.001918,-0.0020794,-0.0014812,0.0014807,-0.0038233,0.21368,0.18306,0.087903,0.066576,0.070154,0.076364,0.13735,0.087296,0.070464,0.07187,0.083794,0.15187,0.09599,0.077229,0.081483,0.092887,0.17104,0.10858,0.087888,0.093616,0.11663,0.21544,0.13764,0.11199,0.11972,0.14659,0.22966,0.15333,0.12338,0.13024,0.16255,0.23484,0.15358,0.12105,0.11563,0.08536,0.12257,0.075609,0.061861,0.060086,0.069055,0.11912,0.073042,0.059348,0.058038,0.066776,0.11733,0.071139,0.058321,0.057854,0.065553,0.11615,0.068955,0.057908,0.057013,0.064866,0.11522,0.068207,0.056207,0.055957,0.0654,0.11497,0.068085,0.056541,0.056548,0.063825,0.11526,0.065972,0.055355,0.05573,0.063843,0.11456,0.066246,0.05592,0.055949,0.063805,0.11401,0.064572,0.054999,0.055195,0.063882,0.11413,0.065012,0.055718,0.055232,0.063209,0.11387,0.063178,0.055161,0.054816,0.062583,0.11379,0.06342,0.054802,0.05469,0.062768,0.11393,0.062985,0.054712,0.054868,0.062995,0.114,0.062492,0.054181,0.054464,0.062272,0.11364,0.061802,0.054863,0.0545,0.061737,0.11366,0.061878,0.054279,0.054518,0.061655,0.11406,0.060762,0.054297,0.053977,0.062475,0.11378,0.059836,0.054,0.053791,0.061993,0.11283,0.059676,0.05508,0.054196,0.061049,0.11348,0.059688,0.053965,0.053806,0.061531,0.11367,0.059208,0.054334,0.054326,0.061127,0.11303,0.059659,0.053568,0.053907,0.060689,0.11383,0.059009,0.05392,0.053347,0.06129,0.11276,0.059128,0.053958,0.053483,0.060754,0.11334,0.058398,0.053644,0.052948,0.060966,0.11412,0.057758,0.053359,0.052957,0.060544,0.11398,0.057097,0.053963,0.052802,0.060695,0.11376,0.057258,0.0:1
-0.00254,0.0014954,-3.9702E-4,-0.0021225,0.0014858,-0.0029466,8.1396E-4,-7.6364E-4,-0.0014191,0.0015578,-0.0024246,8.9548E-4,-0.001238,-0.0026698,0.0021297,-0.0028497,0.001308,2.9401E-4,-0.0027477,0.0015759,0.19147,0.16683,0.10542,0.066719,0.076884,0.075494,0.13328,0.11384,0.071977,0.081562,0.083676,0.1478,0.12394,0.080409,0.091332,0.09446,0.16903,0.13819,0.090554,0.10208,0.10752,0.19465,0.15498,0.10363,0.11603,0.1213,0.21688,0.16572,0.11193,0.12114,0.12285,0.20457,0.13133,0.060765,0.064691,0.062052,0.10323,0.089024,0.054907,0.061038,0.059702,0.10049,0.086973,0.053337,0.060244,0.058974,0.10056,0.085279,0.052378,0.059706,0.058387,0.1002,0.085653,0.051073,0.058808,0.057554,0.099562,0.084043,0.050092,0.058392,0.057027,0.099453,0.082274,0.050106,0.058635,0.056662,0.099037,0.082153,0.04933,0.057817,0.055857,0.10038,0.081533,0.049597,0.057652,0.056171,0.099288,0.080301,0.048213,0.057428,0.055372,0.10085,0.079422,0.049023,0.057146,0.055962,0.10068,0.078555,0.049253,0.057142,0.055195,0.099929,0.079706,0.048905,0.057313,0.054602,0.099228,0.078765,0.048406,0.057674,0.055504,0.098896,0.078477,0.048748,0.056889,0.055061,0.099732,0.077915,0.047856,0.056817,0.054434,0.099259,0.077405,0.047322,0.056277,0.055003,0.099615,0.076182,0.047154,0.055966,0.054849,0.10003,0.076576,0.047705,0.056257,0.054446,0.099605,0.076422,0.047163,0.056196,0.054054,0.099181,0.075181,0.046993,0.056072,0.053935,0.10019,0.074492,0.046623,0.055749,0.053848,0.10018,0.074377,0.046698,0.055665,0.054375,0.10066,0.073611,0.047101,0.055793,0.054023,0.099929,0.073227,0.046237,0.056043,0.053972,0.10007,0.072505,0.04673,0.055388,0.053724,0.10002,0.073049,0.046553,0.055639,0.053791,0.099976,0.072522,0.046183,0.05499,0.054147,0.099799,0.072872,0.046422,0.054883,0.053353,0.10051,0.071517,0.046522,0.054926,0.0:1
-0.0026588,-0.012076,-0.0028921,-0.013014,-0.011116,-0.0052356,-0.0092405,-0.0030722,-0.0082222,-0.0033945,0.002229,-0.0089453,0.0029081,-0.0090976,-0.0014777,-0.0052744,-0.012747,-0.0049383,-0.0098217,-0.0047191,-0.0033837,-0.014809,2.3578E-4,-0.016167,-0.006955,-0.0035703,-0.014106,-9.951E-4,-0.005947,-0.012794,1.5492,1.1084,0.83546,1.7462,1.0262,0.83509,0.89868,0.99596,1.7764,1.1074,0.91293,0.9704,1.1415,1.9196,1.2525,1.0353,1.1056,1.3981,2.1561,1.51,1.2356,1.3268,1.8007,2.5418,1.9472,1.4851,1.6092,2.1779,2.7983,2.0492,1.5298,1.6553,2.2359,2.8509,2.0753,1.6066,1.6619,1.8752,2.2576,1.1551,0.84786,0.8789,0.93117,1.6899,1.0588,0.81183,0.85637,0.92571,1.6628,1.0542,0.8128,0.85147,0.9223,1.6632,1.0504,0.80537,0.84472,0.91054,1.6437,1.0542,0.79409,0.8281,0.90376,1.6172,1.0543,0.78441,0.82548,0.89352,1.6134,1.0615,0.77924,0.82386,0.89887,1.6106,1.0644,0.7794,0.82467,0.89587,1.5957,1.0701,0.77251,0.8171,0.88903,1.5788,1.0826,0.76886,0.81576,0.87851,1.5764,1.0906,0.7641,0.8189,0.88391,1.5631,1.0972,0.76968,0.81516,0.87898,1.5606,1.1009,0.75517,0.80357,0.88226,1.5437,1.1145,0.75826,0.80891,0.87908,1.5205,1.1225,0.75969,0.80655,0.87666,1.5159,1.1292,0.76278,0.80165,0.87246,1.5022,1.1445,0.75985,0.80112,0.87049,1.4878,1.1524,0.76496,0.80067,0.872,1.4667,1.17,0.76016,0.79409,0.86979,1.4511,1.1857,0.75506,0.79484,0.86636,1.4291,1.2013,0.75591,0.79513,0.86245,1.4108,1.2193,0.7572,0.78461,0.86373,1.3841,1.2351,0.76363,0.78261,0.86575,1.3716,1.2497,0.75852,0.78137,0.85603,1.351,1.2625,0.76573,0.78802,0.85783,1.333,1.2841,0.76169,0.78025,0.86041,1.3081,1.2938,0.0:1
-0.0094037,-0.008547,-0.0038154,-0.0073928,0.002306,-0.0045485,-0.010324,-0.0012662,-0.010048,-0.0019201,-0.0088933,-0.0087492,-0.0042707,-0.0085075,-0.0046518,-0.0040618,2.5836,1.0303,1.0595,1.4324,1.8684,1.1889,1.1118,1.2277,1.7447,2.1508,1.4602,1.3516,1.499,2.2533,2.6167,1.8772,1.6551,1.7872,2.6211,2.7737,1.8438,1.7063,1.821,2.6433,2.8046,1.9399,1.722,1.7534,2.1124,1.8347,1.0263,0.91492,0.97015,1.1982,1.716,1.0055,0.90146,0.96198,1.1825,1.7192,1.0041,0.89453,0.95909,1.1554,1.7221,1.004,0.88879,0.95201,1.1432,1.7276,0.99564,0.88579,0.93976,1.1301,1.7308,0.99582,0.8813,0.93957,1.1121,1.736,1.0026,0.87503,0.94065,1.1046,1.7549,0.99913,0.86954,0.93478,1.0858,1.7487,1.0053,0.864,0.93672,1.067,1.7501,1.0095,0.86378,0.92616,1.0533,1.7551,1.0104,0.86181,0.92315,1.0309,1.7614,1.0089,0.84636,0.92044,1.0177,1.7561,1.0084,0.84559,0.91867,0.99924,1.7568,1.0146,0.84712,0.9092,0.98148,1.7703,1.0173,0.8296,0.90702,0.96489,1.7611,1.0164,0.82592,0.89886,0.9354,1.7531,1.0114,0.8205,0.88695,0.91738,1.7524,1.0051,0.81193,0.88538,0.91923,1.7445,1.0077,0.81355,0.87697,0.9085,1.7299,1.0108,0.8154,0.88013,0.90356,1.7269,1.0163,0.79825,0.87309,0.90275,1.7186,1.0206,0.8012,0.87171,0.89728,1.7058,1.0261,0.79536,0.86436,0.90087,1.6982,1.0286,0.79174,0.86404,0.8887,1.6852,1.0428,0.78635,0.86314,0.89506,1.6833,1.0415,0.7889,0.86633,0.89136,1.6751,1.0454,0.77893,0.8558,0.89066,1.6799,1.0492,0.77736,0.85943,0.88786,1.6635,1.0586,0.77292,0.8557,0.89021,1.6543,1.0621,0.7738,0.85497,0.88767,1.6469,1.0671,0.76647,0.84875,0.88269,0.0:1
-0.0073373,0.0054053,-0.0079738,-0.0011253,0.003027,-0.0055235,0.0090637,-0.0043203,-0.0018536,-5.0632E-4,-0.0073218,0.0031596,-0.0089217,0.0013833,-0.0017754,-0.0026735,0.0060904,-0.010761,-0.001547,0.0038469,-0.005411,0.0045529,-0.007029,0.0017539,0.0049284,-0.0080859,0.10227,1.0752,3.4257,2.4641,1.8625,2.1194,2.7992,2.9878,2.2212,1.7917,1.9238,2.6255,2.7844,1.8554,1.1581,0.90114,0.7321,1.2615,0.66108,0.5373,0.63881,0.62771,1.232,0.64874,0.52843,0.63128,0.61696,1.22,0.64528,0.53303,0.62271,0.61709,1.2148,0.6339,0.53217,0.61808,0.62013,1.2203,0.62933,0.53276,0.61945,0.61522,1.2165,0.62188,0.53477,0.61557,0.62084,1.2236,0.62162,0.53297,0.62094,0.61351,1.2147,0.62596,0.52714,0.6176,0.62193,1.2132,0.61651,0.52358,0.6161,0.61269,1.211,0.61947,0.52933,0.61553,0.61038,1.2058,0.62637,0.52578,0.61926,0.60722,1.2145,0.62546,0.5242,0.61994,0.60997,1.2083,0.61961,0.52513,0.62118,0.61355,1.2089,0.61666,0.52452,0.61837,0.60682,1.2129,0.6127,0.52331,0.62357,0.61602,1.2153,0.60298,0.52901,0.61596,0.62058,1.2136,0.60425,0.52921,0.61462,0.62466,1.2131,0.60271,0.53057,0.61627,0.63258,1.2063,0.59985,0.52649,0.61605,0.63153,1.2029,0.604,0.53585,0.61828,0.63252,1.1971,0.605,0.53146,0.62046,0.63543,1.1976,0.60583,0.53268,0.62125,0.63558,1.1924,0.61071,0.52506,0.62319,0.63367,1.1968,0.60486,0.52542,0.62353,0.63945,1.1915,0.59805,0.53036,0.61998,0.64022,1.1951,0.59993,0.53183,0.61981,0.64072,1.1997,0.58558,0.53709,0.6166,0.65059,1.1927,0.59043,0.53963,0.6177,0.65618,1.187,0.58096,0.52943,0.61591,0.66226,1.1767,0.58817,0.5379,0.61682,0.66885,1.1696,0.58962,0.52857,0.62254,0.67643,1.1644,0.5952,0.0:1
0.0063654,-0.011027,0.0040663,-0.0040205,-9.4958E-4,0.0072758,-0.013822,0.0047495,-0.007242,-0.0088578,0.0073211,-0.017799,0.0099412,-0.0054696,-0.0090306,0.006347,-0.015142,0.0025003,-0.0083096,-0.0057338,0.010032,1.0749,3.245,3.083,2.1816,1.9526,1.9798,2.9509,2.8546,2.0027,1.8138,1.8671,2.7507,2.5085,1.3618,0.99193,0.7607,0.85858,1.199,0.61147,0.60802,0.62029,0.81247,1.1547,0.58847,0.59827,0.61519,0.79885,1.1418,0.58595,0.5891,0.60748,0.79636,1.1343,0.57505,0.59309,0.60474,0.79346,1.1248,0.5802,0.59183,0.60339,0.8036,1.1182,0.57874,0.59487,0.60149,0.80695,1.119,0.5736,0.58746,0.60727,0.81213,1.1162,0.57076,0.58503,0.60001,0.80891,1.1194,0.56473,0.59397,0.60758,0.81886,1.1134,0.56961,0.59039,0.60406,0.82188,1.1098,0.55729,0.59339,0.60197,0.8253,1.1102,0.56457,0.5958,0.59897,0.83784,1.1025,0.56446,0.59238,0.60457,0.84583,1.0892,0.56453,0.59624,0.6067,0.85108,1.0875,0.56509,0.58499,0.60505,0.84858,1.077,0.56369,0.58689,0.59948,0.84699,1.0747,0.55933,0.58303,0.60437,0.85518,1.0771,0.55586,0.58706,0.59967,0.85072,1.0685,0.55624,0.59035,0.59895,0.84893,1.0654,0.55097,0.58796,0.59457,0.85432,1.0559,0.54429,0.58516,0.59263,0.85556,1.0545,0.54048,0.58555,0.59506,0.8663,1.0367,0.54775,0.58457,0.59522,0.87224,1.0394,0.54443,0.58576,0.60081,0.87933,1.0285,0.54291,0.58428,0.59705,0.88555,1.0187,0.54522,0.58666,0.596,0.88896,1.0098,0.54439,0.59062,0.59297,0.8862,1.0143,0.53993,0.58288,0.59506,0.8933,1.0184,0.53421,0.58747,0.59395,0.89207,1.0165,0.53323,0.58717,0.59306,0.89843,1.0084,0.52421,0.58631,0.59062,0.90699,0.99916,0.52518,0.59386,0.58958,0.91625,0.97904,0.52868,0.0:1
-0.0088762,-0.008692,0.0090176,-0.015332,0.003279,-0.011412,-0.0096197,0.0034733,-0.011254,0.012773,-0.010126,-2.0061E-4,0.0025606,-0.013528,0.0089314,-0.0096018,-0.006898,0.0097095,-0.01256,0.0060191,-0.012535,-0.0043355,0.008236,1.1601,2.8845,3.2172,2.5411,1.8816,1.9453,2.5714,2.9722,2.3176,1.7451,1.8168,2.3657,2.6942,1.6832,0.98324,0.80778,0.74028,1.2697,0.71068,0.55788,0.5872,0.64512,1.1858,0.68361,0.54016,0.57461,0.63416,1.18,0.68057,0.53745,0.57566,0.62945,1.1667,0.66755,0.53808,0.56762,0.62817,1.1781,0.66531,0.54109,0.564,0.62762,1.168,0.65661,0.54112,0.57331,0.62846,1.1687,0.65796,0.53816,0.56684,0.63561,1.1689,0.66015,0.53818,0.57255,0.62351,1.1676,0.65803,0.53296,0.57189,0.62609,1.1666,0.65862,0.53359,0.56931,0.62751,1.1696,0.65279,0.53495,0.56996,0.62635,1.1765,0.64286,0.53495,0.56942,0.6216,1.1708,0.64023,0.53543,0.56462,0.628,1.1635,0.64192,0.53948,0.56447,0.62405,1.1698,0.63851,0.53847,0.57001,0.62239,1.1683,0.63946,0.54208,0.56455,0.62662,1.1763,0.62825,0.54339,0.5736,0.62315,1.1758,0.63155,0.54061,0.56425,0.6203,1.1721,0.63,0.54205,0.56901,0.61847,1.1719,0.62998,0.5388,0.56402,0.62119,1.1832,0.62389,0.53995,0.57265,0.61983,1.1818,0.62826,0.54073,0.56681,0.62308,1.1851,0.62123,0.54046,0.56521,0.62118,1.179,0.61598,0.54001,0.57065,0.61906,1.1824,0.6117,0.54281,0.56017,0.62195,1.1874,0.60766,0.54524,0.56564,0.61635,1.1864,0.6089,0.54116,0.57013,0.62453,1.1935,0.60416,0.54585,0.56669,0.61975,1.1891,0.60452,0.54849,0.57096,0.62496,1.1883,0.60035,0.54565,0.57021,0.62046,1.1857,0.59967,0.54518,0.56916,0.62077,1.1949,0.59356,0.54861,0.56462,0.62699,0.0:1
0.0089341,0.023719,-0.0066152,4.3756,2.1788,0.51439,0.57633,-0.040149,0.29355,0.11656,0.25982,0.1568,0.088482,0.17316,0.13774,0.22607,0.12488,0.098039,0.14385,0.14116,1.6621,3.2361,3.1142,2.6251,4.2436,2.6349,2.2035,2.2476,2.3538,4.1686,2.6402,2.1567,2.2191,2.3351,4.1179,2.6129,2.1402,2.1921,2.3062,4.0844,2.6082,2.1254,2.1781,2.2867,4.0501,2.6128,2.1173,2.1791,2.2835,4.0402,2.6099,2.1048,2.1743,2.2829,4.0209,2.6354,2.1031,2.1679,2.2719,4.0028,2.6436,2.0923,2.1665,2.2697,3.9895,2.6588,2.0975,2.1664,2.2549,3.9737,2.6568,2.0837,2.1533,2.2608,3.9263,2.6692,2.0795,2.1379,2.2392,3.9076,2.68,2.072,2.1416,2.2473,3.8941,2.6937,2.0696,2.1366,2.2293,3.8867,2.6957,2.0561,2.1164,2.2372,3.8669,2.6976,2.0581,2.1256,2.2203,3.8476,2.7231,2.0521,2.1226,2.2303,3.827,2.7299,2.0517,2.122,2.2215,3.7936,2.7497,2.0399,2.1227,2.2167,3.769,2.7749,2.043,2.1111,2.2168,3.7604,2.7903,2.0388,2.1112,2.2213,3.7278,2.8001,2.044,2.1151,2.2171,3.7299,2.8277,2.0281,2.1012,2.2124,3.6962,2.8497,2.0316,2.1031,2.2135,3.6674,2.8744,2.0242,2.1016,2.2136,3.6588,2.8838,2.0249,2.098,2.1985,3.6409,2.8965,2.0129,2.1073,2.2024,3.6021,2.9202,2.0148,2.0958,2.2145,3.5903,2.9532,2.0072,2.0973,2.1964,3.5582,2.9704,2.012,2.0894,2.1984,3.5407,2.9968,2.0043,2.0902,2.2025,3.5217,3.0103,2.0098,2.0993,2.1993,3.5132,3.0286,2.008,2.0982,2.1946,3.4768,3.0649,2.0017,2.0896,2.2006,3.4641,3.0582,2.0046,2.0817,2.2009,3.4343,3.1015,2.0048,2.0733,2.1935,3.4107,0.0:1
-0.017384,0.020504,-0.0014711,5.0874,0.88698,-0.45038,0.90307,-0.10909,0.36051,0.21442,0.049452,0.20005,0.10547,0.24218,0.11165,0.077438,0.15449,0.11098,0.19277,0.17764,1.6603,3.1447,3.7989,4.1919,2.0809,2.1188,2.2193,2.4339,4.0428,2.1507,2.0474,2.1821,2.4053,4.0607,2.1343,2.0314,2.1636,2.37,4.0496,2.134,2.0201,2.1568,2.3281,4.0574,2.1323,2.0034,2.153,2.2893,4.0548,2.1221,1.9964,2.1293,2.2621,4.0463,2.1208,1.9875,2.1394,2.2387,4.0605,2.1264,1.9962,2.1184,2.223,4.0782,2.1254,1.9971,2.1377,2.1827,4.0679,2.1334,1.98,2.119,2.1865,4.0849,2.1291,1.9793,2.1305,2.1554,4.0854,2.1265,1.9804,2.1069,2.1598,4.0959,2.1244,1.9772,2.121,2.1482,4.0892,2.1611,1.9759,2.105,2.1398,4.0809,2.1301,1.9621,2.1133,2.1405,4.0837,2.1621,1.9779,2.1098,2.1406,4.0656,2.1482,1.9666,2.1036,2.128,4.0588,2.1618,1.9568,2.102,2.1353,4.0519,2.1703,1.965,2.1124,2.1322,4.0443,2.1834,1.9603,2.0982,2.132,4.0498,2.1678,1.9514,2.1007,2.1208,4.0339,2.183,1.9642,2.0969,2.1288,4.0323,2.1823,1.9679,2.0964,2.1344,4.0308,2.205,1.9493,2.0973,2.1229,4.0216,2.2032,1.964,2.098,2.1247,4.0077,2.2207,1.9504,2.0927,2.1217,4.0058,2.2248,1.9637,2.0918,2.124,4.0079,2.2238,1.9587,2.0961,2.1219,3.9902,2.2264,1.9559,2.0854,2.1227,3.9898,2.2317,1.963,2.0895,2.1213,3.9866,2.2359,1.9557,2.0938,2.1178,3.9921,2.2441,1.955,2.0758,2.1279,3.963,2.238,1.9555,2.0836,2.1273,3.9779,2.262,1.9567,2.0833,2.1133,3.9491,2.2657,1.948,2.0745,2.1063,3.9362,2.2677,0.0:1
-0.0043223,0.0063399,0.016187,0.58859,0.29652,0.28313,0.15718,0.13352,0.10322,0.16898,0.2785,0.14929,0.12188,0.10339,0.1609,0.27175,0.14176,0.12085,0.10112,0.15903,0.26741,0.13446,0.12322,0.096187,0.16295,0.27193,0.13177,0.12016,0.095757,0.15537,0.25948,0.13065,0.11872,0.092484,0.1535,0.25927,0.13878,0.10921,0.095433,0.15818,0.24611,0.13277,0.10425,0.090077,0.15354,0.25341,0.13621,0.10648,0.086779,0.14853,0.24575,0.13292,0.1032,0.09123,0.15438,0.24011,0.13243,0.10248,0.078844,0.15517,0.24743,0.13843,0.096848,0.090839,0.15037,0.24506,0.13619,0.10532,0.085896,0.14842,0.23296,0.13203,0.099527,0.081739,0.15254,0.23571,0.13811,0.099421,0.075092,0.15012,0.23264,0.13647,0.099968,0.085006,0.14301,0.23337,0.13533,0.096811,0.079304,0.14394,0.22683,0.13297,0.095085,0.079014,0.14522,0.22629,0.14013,0.095253,0.07496,0.14415,0.22694,0.13421,0.094461,0.078438,0.14644,0.22233,0.14273,0.09098,0.077812,0.1455,0.21914,0.1388,0.092644,0.073175,0.14126,0.21512,0.14077,0.085262,0.07768,0.13983,0.22097,0.13938,0.089734,0.063707,0.14287,0.21477,0.14647,0.085836,0.07759,0.14429,0.21892,0.13694,0.091835,0.077909,0.14387,0.21424,0.14153,0.085384,0.072364,0.13668,0.21413,0.14162,0.083047,0.067704,0.14622,0.21059,0.14811,0.075618,0.071389,0.14005,0.21597,0.15004,0.075627,0.071015,0.13988,0.20473,0.14854,0.083927,0.06427,0.14127,0.20493,0.15302,0.082285,0.069555,0.14167,0.2071,0.14949,0.08589,0.069628,0.13398,0.19629,0.15565,0.084601,0.067486,0.14163,0.20755,0.14525,0.087359,0.066538,0.13629,0.19372,0.15038,0.075461,0.063615,0.13706,0.19376,0.1484,0.081769,0.066481,0.13651,0.18955,0.15653,0.076314,0.068753,0.13539,0.19143,0.15027,0.084797,0.069008,0.14017,0.0:1
-0.0082164,0.024933,-0.01109,0.79982,0.14061,0.054751,0.1652,0.10999,0.25081,0.090485,0.064179,0.13823,0.099802,0.25189,0.087829,0.068007,0.13787,0.10879,0.25565,0.094362,0.063663,0.13348,0.094293,0.25055,0.079754,0.055574,0.13692,0.10032,0.25114,0.084251,0.056372,0.13399,0.092309,0.25163,0.086536,0.054799,0.1289,0.093168,0.24788,0.086419,0.057292,0.12672,0.086649,0.2545,0.08413,0.057681,0.12667,0.086369,0.24902,0.08473,0.054988,0.12713,0.0843,0.25302,0.085338,0.052806,0.12871,0.081855,0.24704,0.078325,0.061613,0.12544,0.079337,0.2484,0.079909,0.054392,0.12457,0.080801,0.25676,0.079006,0.056233,0.12904,0.084056,0.25673,0.084124,0.050265,0.12454,0.08211,0.24886,0.08186,0.045074,0.12733,0.075575,0.25479,0.088395,0.051178,0.13229,0.075979,0.24969,0.083427,0.050205,0.12519,0.083596,0.25423,0.080415,0.048278,0.12692,0.077378,0.24691,0.078327,0.057118,0.12271,0.082079,0.24233,0.08539,0.045474,0.12222,0.083176,0.24745,0.082997,0.043692,0.12195,0.077161,0.24185,0.088226,0.042685,0.12404,0.076659,0.24354,0.082775,0.048104,0.12063,0.078038,0.25104,0.085958,0.045087,0.12423,0.077245,0.2425,0.080636,0.04641,0.12532,0.071328,0.24261,0.093307,0.045834,0.11849,0.076888,0.23916,0.091902,0.044615,0.11973,0.081518,0.23913,0.087583,0.042842,0.12102,0.07218,0.24355,0.081975,0.039779,0.11425,0.072276,0.24147,0.086983,0.046735,0.11965,0.072053,0.23864,0.085291,0.040849,0.1191,0.075871,0.2371,0.091834,0.034283,0.11288,0.0766,0.2371,0.087442,0.042318,0.1139,0.074753,0.2315,0.087824,0.041248,0.11687,0.07693,0.23378,0.095892,0.043527,0.11989,0.07346,0.23789,0.086602,0.04602,0.11168,0.072427,0.23014,0.094106,0.036216,0.11663,0.073463,0.23955,0.087124,0.046455,0.11147,0.076885,0.23819,0.093707,0.0:1
0.0034823,-0.0025347,0.022598,-0.012936,0.021578,0.0053463,-0.0059637,0.028628,-0.015397,0.025516,0.0074421,-0.0037151,0.019982,0.042213,0.28771,0.11006,0.0015943,0.073305,0.035213,0.15239,0.11785,-0.0020353,0.069509,0.036375,0.14931,0.11626,0.0023076,0.07316,0.036644,0.14608,0.11593,0.0052564,0.075825,0.039671,0.14919,0.12407,0.0025544,0.065444,0.036801,0.15393,0.12531,-0.0019665,0.07005,0.041903,0.1511,0.12266,0.007146,0.073253,0.034415,0.1535,0.13057,-0.0011173,0.077834,0.033444,0.14325,0.12203,0.0029657,0.074538,0.034858,0.14866,0.12854,0.0022543,0.070148,0.038598,0.14721,0.13243,0.013296,0.075664,0.03682,0.15129,0.13152,0.0031927,0.070217,0.032398,0.14848,0.12739,0.0056807,0.067254,0.03779,0.14146,0.12833,0.0073186,0.07315,0.033346,0.14736,0.13571,0.010767,0.069711,0.037934,0.13853,0.12118,0.011519,0.069538,0.035546,0.13847,0.13017,0.0051691,0.075694,0.044619,0.13823,0.13807,0.0090809,0.071583,0.035323,0.13848,0.13368,0.014595,0.06774,0.039965,0.13099,0.135,0.011736,0.070647,0.036979,0.1378,0.13804,0.010616,0.069156,0.039986,0.13985,0.14371,-0.0019146,0.073427,0.033965,0.14022,0.13613,0.0097346,0.076611,0.03387,0.13797,0.13565,0.0097584,0.069742,0.034279,0.13602,0.13929,0.0064361,0.071732,0.035749,0.13746,0.1427,0.0077673,0.074499,0.033438,0.13161,0.1526,0.011927,0.076783,0.04015,0.13524,0.14024,0.0065346,0.066427,0.035171,0.13129,0.14514,0.0024033,0.071,0.033832,0.13645,0.14655,0.0028439,0.074085,0.036987,0.13451,0.1523,0.0094183,0.071407,0.036803,0.12799,0.14698,0.010097,0.071563,0.039523,0.12664,0.15062,0.0095604,0.069506,0.039778,0.13238,0.15102,0.0035544,0.072853,0.035479,0.12577,0.14895,0.013196,0.073293,0.045404,0.12199,0.15363,0.008609,0.06995,0.038452,0.12755,0.15447,0.013131,0.069667,0.039042,0.12689,0.0:1
0.010038,0.012584,-0.0057728,0.019241,-0.0026126,0.010511,0.013984,4.0127,1.9651,-0.42204,0.62199,0.393,0.023859,0.27805,0.055102,0.14022,0.222,0.077574,0.13297,0.10035,0.11431,0.19826,0.080628,0.13485,1.2329,5.3186,2.007,1.4218,1.5199,1.4633,2.3965,1.3561,1.0309,1.1139,1.1118,1.9418,1.2885,0.97813,1.0678,1.0741,1.8618,1.283,0.96467,1.0505,1.0541,1.8233,1.2787,0.94684,1.0264,1.048,1.784,1.2832,0.93271,1.0076,1.0157,1.7406,1.291,0.91739,1.0049,1.0125,1.7094,1.3011,0.91463,0.99384,0.99163,1.6833,1.321,0.90774,0.98256,1.0047,1.6602,1.3162,0.89669,0.98535,0.98755,1.6303,1.3177,0.89067,0.98562,0.98779,1.5897,1.3491,0.87947,0.97012,0.98765,1.5788,1.3508,0.8846,0.97414,0.98248,1.5532,1.3837,0.87334,0.96471,0.96851,1.5253,1.4122,0.86583,0.9643,0.96721,1.4898,1.4276,0.86469,0.96209,0.96534,1.4639,1.4488,0.86544,0.94994,0.96158,1.4516,1.4561,0.86312,0.95492,0.9498,1.427,1.4809,0.85125,0.93988,0.9574,1.395,1.4881,0.84599,0.94348,0.94594,1.3841,1.5044,0.85263,0.93964,0.95722,1.3467,1.5457,0.84898,0.93776,0.9393,1.3202,1.5735,0.83733,0.93397,0.94714,1.2901,1.5848,0.84034,0.92747,0.93907,1.2695,1.6114,0.8359,0.92439,0.94117,1.2335,1.6366,0.83144,0.91855,0.93666,1.2006,1.6628,0.83089,0.91804,0.93507,1.1773,1.6926,0.83495,0.9168,0.92946,1.1545,1.717,0.8302,0.92176,0.93316,1.1231,1.7298,0.83383,0.91146,0.93574,1.1021,1.7591,0.82521,0.91372,0.92688,1.0749,1.7831,0.82409,0.91488,0.92133,1.044,1.8158,0.82352,0.92197,0.92305,1.0297,1.8235,0.82442,0.91247,0.92951,1.0012,1.8504,0.82017,0.89935,0.92833,0.0:1
-0.012297,0.014643,1.2144E-4,0.0064578,0.014872,-0.01038,0.020049,0.006725,0.0055391,0.018421,-0.011593,6.0858,1.0013,0.57701,0.050611,0.34752,0.09538,0.20267,0.22664,0.09853,0.1289,0.12941,0.14788,0.21629,0.096454,0.10442,0.13234,0.75334,3.8448,2.5031,1.8541,1.6136,2.6497,1.8311,1.2472,1.1821,1.22,1.9024,1.5666,1.082,1.0948,1.1534,1.8152,1.5351,1.0388,1.0702,1.1334,1.7379,1.5345,1.0201,1.0363,1.0963,1.7,1.5203,0.99062,1.0234,1.0936,1.6373,1.528,0.99059,1.0072,1.07,1.6152,1.5484,0.96974,1.007,1.0776,1.5654,1.5542,0.96186,0.99643,1.0532,1.5393,1.5429,0.95322,0.99355,1.0572,1.4989,1.57,0.94516,0.97923,1.0437,1.4755,1.5949,0.93505,0.97224,1.0414,1.4362,1.6264,0.94384,0.97022,1.0347,1.4259,1.6423,0.91972,0.95217,1.0287,1.3886,1.6471,0.91525,0.95855,1.0239,1.359,1.6464,0.90944,0.95798,1.0123,1.3249,1.7031,0.89592,0.94795,1.0099,1.3006,1.7247,0.89326,0.94618,1.0053,1.2672,1.7531,0.88854,0.93643,1.0009,1.249,1.761,0.87455,0.9431,0.99945,1.2031,1.7933,0.87697,0.94704,1.0011,1.1812,1.8092,0.87153,0.93802,0.99183,1.1469,1.8365,0.869,0.92962,0.98331,1.1366,1.8544,0.86785,0.93312,0.99254,1.0925,1.8887,0.86551,0.9203,0.98521,1.0876,1.8903,0.85556,0.92816,0.99229,1.0463,1.9189,0.8652,0.91731,0.98458,1.0223,1.934,0.85305,0.92003,0.99265,0.99305,1.9488,0.85194,0.90891,0.97358,0.99341,1.9474,0.85845,0.91266,0.96888,0.97073,1.9651,0.8568,0.90492,0.97394,0.98348,1.9588,0.86295,0.9084,0.9751,1.0159,2.0332,0.87508,0.88642,0.98384,0.95607,1.961,0.86938,0.89448,0.99754,0.9633,1.9495,0.89902,0.0:1
0.012591,-0.012488,0.021343,-7.9063E-4,-4.8825E-4,0.022107,-0.018681,0.01797,-0.0047128,0.002903,1.4455,-0.054329,0.059612,-0.0068475,0.01304,0.0034426,-0.023289,0.021454,-0.0068727,0.16063,0.25211,0.28781,0.38526,0.71059,0.36157,0.26543,0.30042,0.38256,0.71856,0.38016,0.26457,0.2938,0.38394,0.72305,0.37398,0.27228,0.30585,0.38829,0.7199,0.37969,0.27124,0.29852,0.39113,0.72902,0.38631,0.27298,0.30295,0.39028,0.72262,0.38528,0.27524,0.30805,0.39293,0.72221,0.38748,0.27244,0.2996,0.38488,0.71552,0.384,0.27706,0.30428,0.39473,0.71897,0.39639,0.27226,0.30268,0.39303,0.7195,0.39545,0.27408,0.30568,0.39205,0.71877,0.39192,0.27082,0.30423,0.38916,0.71844,0.39854,0.27217,0.29898,0.39831,0.71849,0.40378,0.26759,0.30715,0.38709,0.71688,0.40171,0.26945,0.30033,0.39167,0.70565,0.41098,0.2715,0.30061,0.38639,0.71424,0.40633,0.27214,0.30012,0.38809,0.71155,0.41533,0.27037,0.30162,0.39245,0.70901,0.41233,0.27068,0.30408,0.39552,0.71223,0.41426,0.26724,0.29775,0.39324,0.70844,0.4188,0.26802,0.29779,0.39101,0.70936,0.42107,0.26349,0.3002,0.38851,0.70676,0.42849,0.27225,0.3012,0.39309,0.71686,0.43238,0.27131,0.29948,0.39375,0.70947,0.43099,0.26631,0.29397,0.39291,0.70511,0.43176,0.27069,0.30053,0.39599,0.6983,0.43674,0.27201,0.30309,0.38796,0.70096,0.43207,0.27149,0.28988,0.39578,0.69679,0.44297,0.27599,0.29988,0.39025,0.69802,0.43627,0.26753,0.30109,0.39828,0.70048,0.44197,0.26588,0.30171,0.39278,0.6959,0.44852,0.26917,0.2997,0.39311,0.68957,0.45428,0.27032,0.29523,0.39118,0.69327,0.44045,0.26463,0.30288,0.39084,0.68979,0.45468,0.27124,0.2932,0.39527,0.69558,0.4528,0.27135,0.2969,0.38683,0.69024,0.45221,0.0:1
-0.0035541,0.020356,-0.016119,0.018047,0.0034076,-0.014563,0.023044,-0.013801,0.017269,0.010293,-0.011767,0.025706,-0.015577,0.021891,0.0089596,-0.0092117,0.29747,0.24921,-0.017978,0.054644,-0.017491,0.016652,-0.02176,0.020718,0.47055,0.23084,0.3458,0.32418,0.70783,0.46521,0.24678,0.3492,0.32966,0.70544,0.47847,0.23882,0.35354,0.32648,0.70481,0.47349,0.24365,0.35044,0.32921,0.70058,0.48198,0.24971,0.35059,0.3324,0.71027,0.48103,0.25602,0.34899,0.33428,0.70354,0.48661,0.25173,0.35258,0.32765,0.7054,0.4861,0.25483,0.34796,0.33795,0.7004,0.49086,0.25304,0.34997,0.33547,0.6981,0.51178,0.26276,0.35322,0.33475,0.7059,0.50192,0.25925,0.3494,0.34026,0.69037,0.50227,0.25539,0.34949,0.33607,0.68929,0.50847,0.26375,0.35592,0.33548,0.68179,0.51065,0.26426,0.35341,0.33612,0.67943,0.51632,0.26444,0.35209,0.33295,0.67928,0.52368,0.26517,0.3498,0.33366,0.68066,0.51749,0.26844,0.35114,0.33437,0.6814,0.52545,0.26749,0.35826,0.3399,0.67624,0.52895,0.27072,0.35065,0.33348,0.67234,0.52929,0.27228,0.35352,0.33462,0.66778,0.53814,0.26977,0.35159,0.33626,0.66753,0.53474,0.27467,0.34749,0.3338,0.66504,0.54482,0.27165,0.35408,0.33289,0.66321,0.5423,0.27816,0.34984,0.33478,0.6613,0.55127,0.2759,0.35195,0.33799,0.65518,0.54913,0.28232,0.34567,0.33333,0.64945,0.56159,0.27686,0.34574,0.33523,0.64861,0.55908,0.27444,0.3471,0.3415,0.64194,0.56416,0.27829,0.34666,0.3403,0.63816,0.56259,0.28021,0.35121,0.33405,0.63653,0.56506,0.27955,0.34555,0.3388,0.64178,0.57344,0.27823,0.35004,0.33804,0.6243,0.57896,0.28387,0.34753,0.33769,0.62472,0.59042,0.2769,0.35131,0.3371,0.62293,0.5919,0.28616,0.34525,0.33711,0.6134,0.59517,0.0:1
0.026676,-0.0016389,0.0063592,0.020871,-0.017312,0.021005,-0.0052579,0.0087511,0.020151,-0.018831,0.35502,0.07544,0.139,0.030466,-0.027098,0.030835,-0.011016,0.013343,0.11101,0.24458,0.36089,0.69309,0.3592,0.24649,0.28386,0.36883,0.69738,0.37096,0.24867,0.28435,0.3731,0.70277,0.37412,0.25656,0.28378,0.37444,0.69902,0.38012,0.25018,0.28378,0.37527,0.699,0.37945,0.25827,0.28672,0.37906,0.69386,0.38555,0.2518,0.29188,0.37701,0.70048,0.38491,0.25335,0.29095,0.37901,0.70129,0.39266,0.26604,0.28664,0.38123,0.70211,0.39526,0.26066,0.29102,0.38259,0.69692,0.4009,0.26318,0.29028,0.38973,0.69577,0.40251,0.26121,0.29335,0.38424,0.6911,0.40062,0.25658,0.2882,0.38404,0.69623,0.41385,0.25905,0.29352,0.38313,0.70026,0.40883,0.2621,0.28914,0.38792,0.69901,0.41827,0.26233,0.28974,0.3853,0.69606,0.40795,0.26313,0.2885,0.38686,0.70021,0.42134,0.26685,0.28519,0.38429,0.69322,0.42394,0.26549,0.29219,0.38737,0.69124,0.42376,0.26261,0.28707,0.39054,0.68939,0.4292,0.26564,0.28629,0.38539,0.69758,0.42095,0.2635,0.2976,0.38413,0.6943,0.42475,0.26878,0.29195,0.38064,0.69128,0.43149,0.26218,0.29276,0.38526,0.6887,0.4361,0.26153,0.29411,0.39022,0.69206,0.43326,0.2658,0.29262,0.38469,0.6779,0.44504,0.26486,0.2946,0.38424,0.68482,0.44049,0.26677,0.29305,0.38662,0.67743,0.45189,0.26926,0.29429,0.38988,0.67851,0.45069,0.2653,0.29507,0.38443,0.67804,0.45786,0.26566,0.29167,0.38853,0.67048,0.45781,0.26573,0.29082,0.37997,0.67342,0.45765,0.26242,0.28881,0.39127,0.67303,0.46275,0.26821,0.2947,0.39106,0.6669,0.46581,0.2686,0.29166,0.38851,0.66718,0.46272,0.26567,0.29119,0.38657,0.66334,0.46974,0.27152,0.28825,0.0:1
0.013763,0.012293,-0.0032579,0.020111,-0.0072089,0.013556,0.0026998,-0.0032996,0.019793,-0.0067638,6.508,0.8311,-0.11569,0.72095,-0.096304,0.25913,0.27667,0.089883,0.17001,0.11126,0.1526,0.23929,0.099221,0.12959,0.11043,0.13396,0.26402,1.5093,4.155,3.4753,3.9922,2.4756,1.6266,1.7137,1.6973,2.7944,2.2205,1.5607,1.645,1.6538,2.7201,2.175,1.5124,1.6004,1.6215,2.662,2.1553,1.4832,1.5874,1.6168,2.6253,2.1436,1.4804,1.5605,1.5772,2.602,2.1471,1.4569,1.5554,1.5956,2.5731,2.1228,1.461,1.5531,1.5615,2.5497,2.1303,1.4278,1.5298,1.5654,2.5339,2.1186,1.4412,1.5304,1.545,2.5322,2.1102,1.4193,1.5126,1.545,2.4965,2.118,1.4253,1.5138,1.5329,2.4912,2.1325,1.4084,1.5103,1.5348,2.4737,2.1232,1.4158,1.5041,1.5392,2.454,2.1337,1.4104,1.5032,1.5337,2.4506,2.1426,1.4143,1.4985,1.5232,2.4301,2.1489,1.3989,1.5017,1.527,2.4063,2.1609,1.4096,1.4942,1.5201,2.4182,2.1452,1.3892,1.5002,1.5183,2.3927,2.1549,1.3943,1.4805,1.5241,2.3945,2.1612,1.3771,1.482,1.5163,2.386,2.1757,1.389,1.4866,1.5077,2.3738,2.1803,1.3888,1.4786,1.5188,2.3637,2.1871,1.3866,1.4796,1.5049,2.3563,2.1794,1.3823,1.4671,1.5176,2.3523,2.198,1.3716,1.4745,1.5027,2.3349,2.2019,1.3679,1.4713,1.5153,2.3149,2.2115,1.3847,1.486,1.5031,2.3102,2.2286,1.3628,1.4699,1.5063,2.2993,2.2225,1.3738,1.4794,1.4908,2.3042,2.2269,1.3731,1.4673,1.4968,2.2937,2.2265,1.3727,1.4687,1.4951,2.2879,2.2487,1.3645,1.4594,1.51,2.2637,2.2568,1.3691,1.4632,1.4916,2.2619,2.2586,1.3685,1.4608,1.5066,0.0:1
0.021957,-0.0097135,0.01696,0.0069347,-0.010788,0.017556,-0.011134,0.024853,0.0084512,-0.0018018,8.4584,1.0704,0.097146,0.44382,0.1792,0.10379,0.17168,0.13762,0.25795,0.11667,0.1248,0.11101,0.13245,0.2398,0.088634,0.11816,0.12474,2.811,4.8874,2.7264,2.2023,1.8604,2.1266,3.0515,1.5652,1.6288,1.654,2.0087,2.9772,1.5475,1.5981,1.6164,1.9678,2.9718,1.5288,1.5802,1.6106,1.931,2.9588,1.5178,1.5641,1.587,1.9102,2.9493,1.5025,1.5629,1.5864,1.8702,2.9448,1.4992,1.5467,1.5662,1.8614,2.9401,1.4837,1.5264,1.5798,1.8394,2.9321,1.4786,1.5319,1.5525,1.8278,2.9316,1.4752,1.5265,1.559,1.8104,2.9469,1.4753,1.5178,1.5515,1.7955,2.9443,1.4652,1.5216,1.5516,1.7845,2.9378,1.4644,1.5161,1.5305,1.7727,2.947,1.4605,1.5053,1.5285,1.7664,2.9325,1.4739,1.5101,1.5225,1.748,2.9414,1.4544,1.5017,1.5292,1.7264,2.9406,1.4597,1.5109,1.5166,1.7304,2.9431,1.4499,1.4966,1.5194,1.6902,2.9514,1.4572,1.5002,1.5165,1.701,2.9636,1.4539,1.4984,1.523,1.6978,2.9333,1.4644,1.4855,1.513,1.6897,2.9558,1.4511,1.481,1.5198,1.6737,2.9457,1.4567,1.4858,1.5078,1.6731,2.9559,1.4511,1.4908,1.5107,1.6733,2.9518,1.4701,1.4771,1.4999,1.6533,2.9672,1.4428,1.477,1.5096,1.6498,2.9718,1.4506,1.4834,1.5067,1.6421,2.9655,1.4504,1.481,1.507,1.6317,2.9708,1.457,1.4712,1.5059,1.6296,2.9801,1.4504,1.4681,1.4909,1.6235,2.9842,1.4446,1.4733,1.4956,1.6119,2.9801,1.4514,1.4743,1.5,1.6026,2.9745,1.4506,1.4695,1.4971,1.5993,2.986,1.4611,1.4685,1.493,1.587,2.9981,1.4437,0.0:1
0.029143,-0.016061,0.016536,0.010355,-0.0171,0.032187,-0.017886,0.016665,0.014694,-0.021703,0.030527,-0.015328,3.0605,1.1787,0.85728,1.0549,1.1258,1.6615,1.0847,0.84871,0.97288,1.11,1.6338,1.0549,0.83119,0.95903,1.0925,1.6059,1.0346,0.81719,0.94368,1.0778,1.5929,1.035,0.80701,0.94146,1.0727,1.5767,1.0021,0.80125,0.92352,1.0612,1.5773,1.0058,0.79619,0.92211,1.0463,1.5716,0.99276,0.79512,0.92148,1.0477,1.554,0.98854,0.7775,0.91591,1.0396,1.5592,0.98338,0.77644,0.90559,1.036,1.5514,0.98243,0.77263,0.90274,1.0316,1.5362,0.96762,0.76969,0.89755,1.0377,1.53,0.9551,0.76118,0.89427,1.03,1.5252,0.96178,0.76354,0.88786,1.0301,1.5232,0.95338,0.75606,0.89659,1.0239,1.5212,0.95294,0.75644,0.89383,1.0366,1.5221,0.94937,0.76388,0.88778,1.0235,1.5142,0.95191,0.74749,0.88418,1.0276,1.5104,0.94074,0.7534,0.8803,1.0262,1.5002,0.93701,0.74739,0.87601,1.0228,1.5067,0.93857,0.74408,0.88052,1.032,1.4955,0.93827,0.74867,0.87886,1.0236,1.5031,0.9261,0.74709,0.88092,1.0226,1.4972,0.92422,0.74408,0.88119,1.025,1.4933,0.92338,0.74455,0.87069,1.0249,1.4856,0.92809,0.74501,0.87246,1.0201,1.4939,0.91453,0.74153,0.87124,1.0233,1.4834,0.91218,0.74808,0.87095,1.0244,1.4889,0.92008,0.74421,0.86744,1.0219,1.4833,0.91271,0.74206,0.86309,1.0259,1.4786,0.91078,0.73492,0.8732,1.0269,1.4777,0.91164,0.73742,0.87085,1.0328,1.4757,0.90141,0.73637,0.86812,1.0255,1.4746,0.90864,0.73579,0.86405,1.0257,1.4729,0.90053,0.73146,0.86705,1.0315,1.4709,0.90194,0.73078,0.87625,1.0228,1.4755,0.89348,0.73085,0.87054,1.0301,1.4628,0.90482,0.73049,0.0:1
-0.022097,0.031285,-0.015,-8.3322E-4,0.020533,-0.017556,0.0297,-0.004611,0.0086358,0.023924,-0.024578,0.029664,1.0346,1.636,0.8332,0.81401,0.89445,1.4825,1.1065,0.74147,0.75493,0.89909,1.4531,1.0911,0.72316,0.74729,0.88896,1.4575,1.0789,0.72106,0.74608,0.89017,1.4562,1.0792,0.7271,0.74222,0.88214,1.4484,1.0851,0.72836,0.74202,0.8841,1.4383,1.0796,0.7194,0.74334,0.88038,1.4478,1.0796,0.71973,0.74771,0.87208,1.4472,1.0663,0.72239,0.74414,0.87845,1.4465,1.0616,0.7188,0.74394,0.86948,1.4513,1.0609,0.71789,0.74403,0.86934,1.4557,1.0677,0.7199,0.74097,0.87097,1.4447,1.0649,0.7189,0.74423,0.881,1.4525,1.0813,0.71609,0.75047,0.87419,1.4583,1.0706,0.71887,0.74338,0.86726,1.4502,1.062,0.71475,0.74032,0.8654,1.4621,1.0605,0.72194,0.74664,0.86517,1.4542,1.0614,0.7142,0.74584,0.87014,1.4574,1.0572,0.70906,0.74392,0.8654,1.4485,1.06,0.71574,0.75169,0.87177,1.4473,1.0658,0.71845,0.75212,0.8697,1.4499,1.0589,0.71634,0.75034,0.86999,1.4575,1.0518,0.7228,0.75028,0.86829,1.4607,1.0442,0.71321,0.74748,0.86268,1.4677,1.0429,0.7213,0.74481,0.86588,1.466,1.0449,0.71819,0.74306,0.86627,1.4482,1.0548,0.71987,0.75305,0.86768,1.4579,1.0548,0.71652,0.75114,0.86813,1.4623,1.051,0.72506,0.74819,0.86994,1.468,1.0419,0.71966,0.74318,0.86391,1.4714,1.0378,0.71919,0.74917,0.86645,1.4691,1.0413,0.71881,0.75399,0.86253,1.476,1.0446,0.71977,0.74778,0.86682,1.465,1.0597,0.7184,0.75663,0.87007,1.4687,1.0537,0.72224,0.74829,0.86537,1.473,1.0343,0.7194,0.75142,0.86257,1.4833,1.0312,0.71918,0.75346,0.85945,1.4705,1.0374,0.71587,0.0:1
0.0076815,0.010571,-0.024077,0.030652,-0.007555,0.010942,0.020131,-0.021164,0.030149,-0.005185,0.012054,0.019176,-0.027133,0.40304,2.1919,1.4202,0.82188,0.74592,0.92083,1.4228,1.1757,0.77402,0.75292,0.89764,1.4138,1.1654,0.76093,0.75076,0.89473,1.4139,1.1576,0.76376,0.74331,0.89028,1.4082,1.1568,0.75789,0.75364,0.88361,1.4061,1.146,0.7581,0.74705,0.87893,1.3956,1.1584,0.75582,0.74455,0.88454,1.3838,1.1762,0.7492,0.74811,0.87867,1.3864,1.1558,0.75457,0.74255,0.88041,1.3856,1.1556,0.75682,0.74777,0.87089,1.3799,1.157,0.75667,0.74335,0.87665,1.38,1.1558,0.75424,0.74207,0.86635,1.3727,1.1526,0.75313,0.7374,0.87688,1.3681,1.179,0.75139,0.74698,0.87239,1.3661,1.1747,0.74728,0.73674,0.87226,1.3657,1.165,0.75049,0.73497,0.87187,1.3737,1.1604,0.75086,0.73966,0.86427,1.3603,1.16,0.74877,0.74003,0.86707,1.3659,1.1613,0.74668,0.74347,0.86249,1.3599,1.1597,0.75825,0.74239,0.87655,1.3487,1.1759,0.74325,0.74038,0.86227,1.3539,1.1841,0.74721,0.74164,0.86381,1.3559,1.1696,0.75764,0.74353,0.86683,1.3605,1.1649,0.75569,0.73785,0.86547,1.3591,1.1711,0.7462,0.74122,0.86527,1.3539,1.1663,0.75821,0.73522,0.86781,1.345,1.1726,0.75483,0.74084,0.86697,1.3438,1.1904,0.74493,0.7382,0.86194,1.3365,1.1948,0.74352,0.74016,0.86433,1.3466,1.1786,0.75417,0.73627,0.8672,1.3499,1.1778,0.75861,0.73646,0.8679,1.3452,1.1767,0.75383,0.73735,0.86106,1.343,1.1796,0.75691,0.74156,0.86234,1.3419,1.1765,0.76048,0.7368,0.86805,1.334,1.1913,0.75634,0.74319,0.86843,1.335,1.2007,0.75761,0.73814,0.8691,1.3375,1.1811,0.75566,0.73536,0.87035,1.3327,0.0:1
-5.7047E-5,-0.028438,0.017879,-0.023291,-0.0017027,-0.0022532,-0.021082,0.0090688,-0.019954,-0.0075028,-0.0013982,-0.016222,0.011463,-0.022441,1.7123,1.7852,1.5472,1.6257,2.669,2.5044,1.8283,1.5823,1.8009,2.7733,2.5961,1.8809,1.6051,1.8478,2.7499,2.6116,1.8904,1.6035,1.8586,2.7699,2.6404,1.8259,1.2567,1.4229,1.8299,1.8371,1.2229,1.0465,1.1291,1.5795,1.9024,1.2006,1.0143,1.1712,1.5812,1.9258,1.2131,1.0106,1.1593,1.5568,1.9289,1.2085,1.0061,1.1571,1.5447,1.9328,1.2193,1.0009,1.1554,1.5344,1.9394,1.215,1.0027,1.1533,1.5101,1.9443,1.2287,1.0003,1.1483,1.4922,1.9513,1.2353,0.99543,1.1518,1.4728,1.9632,1.2368,0.99001,1.149,1.4557,1.9752,1.2538,0.98738,1.1425,1.4388,1.9933,1.2528,0.98802,1.1379,1.422,2.0003,1.2484,0.98508,1.1477,1.3991,2.0071,1.2687,0.98862,1.14,1.3905,2.0256,1.2619,0.98185,1.1373,1.3659,2.0287,1.2797,0.98019,1.1369,1.3468,2.0354,1.288,0.97869,1.1305,1.3254,2.0551,1.3006,0.9765,1.1329,1.2988,2.0836,1.2946,0.96977,1.1305,1.2824,2.0894,1.3177,0.97305,1.1315,1.2553,2.0937,1.3246,0.96972,1.1261,1.2332,2.1106,1.3379,0.97072,1.1268,1.2182,2.1249,1.3378,0.96879,1.1252,1.2009,2.1313,1.3525,0.97168,1.1241,1.1905,2.1363,1.3576,0.97536,1.1216,1.1788,2.1348,1.3713,0.97492,1.1152,1.1618,2.1385,1.3879,0.97193,1.1154,1.1347,2.149,1.3961,0.97483,1.111,1.1264,2.1371,1.4154,0.96956,1.1159,1.1219,2.1422,1.42,0.96915,1.1147,1.1156,2.1262,1.4258,0.97341,1.1191,1.1285,2.1268,1.4537,0.98178,1.1134,1.1211,2.1027,1.4696,0.97926,1.1112,1.1229,2.0986,0.0:1
2.7579E-4,-0.023051,0.013318,-0.018495,-0.010147,0.0074698,-0.017923,0.016899,-0.019041,-0.0077863,0.0032568,-0.022659,0.013834,-0.021971,-0.0057335,0.0012942,-0.02379,0.015365,-0.019703,-0.016314,-5.6825E-4,-0.025772,0.012941,-0.019716,-0.003197,2.5506E-4,1.845,2.2271,2.9174,2.1355,1.6346,1.7203,2.3225,2.9083,2.2296,1.7108,1.7348,2.3697,2.9674,2.2782,1.7275,1.7495,2.3877,2.9911,2.2981,1.7169,1.7315,2.2482,2.66,1.7069,1.1942,1.1725,1.2942,2.2187,1.6003,1.1511,1.159,1.2754,2.1875,1.5985,1.1404,1.1527,1.2691,2.1723,1.6072,1.1348,1.1445,1.2614,2.1602,1.6205,1.1354,1.1486,1.2612,2.1481,1.6336,1.132,1.1402,1.2566,2.1284,1.6426,1.134,1.1373,1.2582,2.1178,1.6474,1.1318,1.1331,1.2504,2.1073,1.6557,1.1365,1.1319,1.2534,2.0864,1.6682,1.1395,1.1301,1.2529,2.0841,1.678,1.1372,1.125,1.2508,2.0596,1.6981,1.139,1.1317,1.2472,2.0517,1.7028,1.1461,1.1166,1.2435,2.0325,1.7016,1.138,1.1178,1.2418,2.0159,1.7185,1.1482,1.1125,1.242,1.9987,1.7273,1.1478,1.1213,1.2374,1.9955,1.7285,1.1541,1.1143,1.2355,1.9781,1.7405,1.1531,1.1048,1.2357,1.9625,1.7531,1.1583,1.1049,1.2354,1.953,1.7637,1.166,1.1074,1.2343,1.936,1.775,1.1663,1.1029,1.2293,1.931,1.7857,1.1689,1.1035,1.2329,1.9113,1.7937,1.1673,1.1023,1.2285,1.8948,1.8079,1.1778,1.0929,1.2266,1.8753,1.8216,1.1816,1.0936,1.2315,1.8534,1.8406,1.186,1.0891,1.2304,1.8353,1.8511,1.1929,1.086,1.2207,1.8157,1.8697,1.1991,1.0845,1.2241,1.7904,1.8847,1.2036,1.0922,1.2205,1.769,1.903,1.2089,1.0829,1.2165,1.749,1.9179,0.0:1
1.5212,1.5836,2.7382,2.0052,1.4153,1.518,1.585,2.7413,1.9964,1.4182,1.5176,1.5837,2.7562,1.9892,1.4172,1.5171,1.5832,2.7634,1.9761,1.4181,1.5119,1.5804,2.7639,1.9636,1.4204,1.5184,1.5767,2.7743,1.9509,1.4121,1.5134,1.5801,2.7791,1.949,1.413,1.5204,1.5745,2.7747,1.9369,1.4212,1.5196,1.577,2.7792,1.9299,1.4196,1.521,1.5703,2.7854,1.9155,1.4162,1.5241,1.5712,2.7903,1.9095,1.4259,1.5168,1.5729,2.7964,1.8957,1.4181,1.514,1.568,2.8052,1.8972,1.4215,1.5172,1.5715,2.8081,1.8797,1.4079,1.517,1.5751,2.8114,1.8809,1.4131,1.5185,1.5608,2.8117,1.8752,1.419,1.5209,1.5707,2.8183,1.8629,1.4114,1.5177,1.5667,2.8265,1.8504,1.408,1.5203,1.5687,2.8334,1.843,1.4124,1.5217,1.5677,2.8397,1.8434,1.4155,1.5142,1.5713,2.8427,1.8217,1.4199,1.5229,1.5658,2.8598,1.8123,1.4192,1.5209,1.5687,2.8528,1.8048,1.4117,1.5154,1.5652,2.8648,1.796,1.4134,1.5196,1.5599,2.8691,1.7937,1.42,1.5249,1.5618,2.8748,1.7853,1.4186,1.522,1.5629,2.8952,1.7677,1.4235,1.5226,1.5645,2.889,1.7625,1.4206,1.5209,1.564,2.8994,1.7529,1.4123,1.5256,1.5594,2.8939,1.7449,1.4176,1.5212,1.5626,2.9053,1.7451,1.4213,1.5247,1.5652,2.9138,1.7344,1.4254,1.5214,1.5613,2.9165,1.7309,1.4237,1.5252,1.5652,2.9202,1.719,1.4249,1.5278,1.5656,2.9264,1.7116,1.4232,1.5269,1.5646,2.9382,1.6999,1.4266,1.5253,1.5707,2.9387,1.6974,1.4246,1.5298,1.5723,2.9456,1.6851,1.4272,1.5308,1.5698,2.9469,1.6814,1.4234,1.5285,1.5691,2.9473,1.676,1.4207,0.0:1
0.0035251,0.0030763,-6.83E-4,-0.0015855,0.0085108,4.4801E-4,0.0050837,0.0012345,0.0030499,0.0026659,5.3685E-4,0.0034245,0.0041005,4.6584E-4,0.0062999,1.1351,3.1857,3.1679,1.5543,1.4689,1.6871,2.7177,2.1703,1.414,1.5162,1.6067,2.6915,2.1342,1.4093,1.5246,1.6089,2.699,2.1252,1.4028,1.5152,1.6066,2.7021,2.1049,1.4011,1.5182,1.5959,2.7152,2.0958,1.4019,1.515,1.6013,2.7333,2.0705,1.4033,1.5159,1.6052,2.7383,2.0595,1.4084,1.523,1.6019,2.7388,2.0546,1.4119,1.5237,1.5998,2.7655,2.0353,1.4088,1.5226,1.5994,2.7705,2.0228,1.4131,1.5222,1.5941,2.7775,2.0165,1.4168,1.5222,1.6079,2.7834,2.0087,1.4125,1.5254,1.5945,2.791,1.9826,1.4241,1.5194,1.6022,2.7997,1.9833,1.4211,1.5251,1.5978,2.8119,1.9553,1.4233,1.5271,1.6021,2.8223,1.9499,1.4166,1.5312,1.604,2.8302,1.9396,1.4206,1.5234,1.6033,2.8396,1.9215,1.4192,1.529,1.608,2.8546,1.9102,1.4248,1.5287,1.6017,2.8583,1.8976,1.4241,1.5273,1.6037,2.865,1.8875,1.4192,1.5322,1.6021,2.8783,1.8741,1.4338,1.5335,1.603,2.8828,1.8591,1.4267,1.5309,1.6001,2.8978,1.8519,1.4264,1.5331,1.5996,2.9019,1.8386,1.4295,1.5309,1.6037,2.9127,1.8336,1.4281,1.5344,1.6038,2.9235,1.8136,1.4311,1.5338,1.605,2.9337,1.7975,1.4384,1.5322,1.6074,2.9324,1.7972,1.4319,1.538,1.6014,2.9466,1.7843,1.4406,1.5452,1.6055,2.9598,1.7737,1.4433,1.5407,1.6076,2.9671,1.7608,1.4302,1.5435,1.6008,2.9769,1.756,1.4391,1.5435,1.6073,2.9853,1.7395,1.4467,1.5415,1.6131,2.9863,1.7357,1.4438,1.5468,1.6143,2.9883,1.7233,1.4435,1.5497,0.0:1
0.0034715,1.5174E-4,0.0058367,-7.861E-4,-0.0010272,-6.138E-4,-0.0018794,0.0085716,0.0024356,3.1503,3.0953,1.9085,2.0011,2.6811,2.4446,1.5555,1.5702,1.7098,2.6762,2.4001,1.5178,1.5825,1.6838,2.6857,2.3831,1.509,1.5833,1.679,2.6909,2.3672,1.4972,1.5759,1.6814,2.6926,2.343,1.4984,1.5778,1.6776,2.7038,2.3385,1.4937,1.5827,1.6745,2.7128,2.3222,1.4914,1.581,1.6793,2.7249,2.3142,1.4884,1.5801,1.6709,2.7297,2.2988,1.4896,1.5766,1.6816,2.7401,2.2877,1.4855,1.5812,1.6753,2.748,2.2833,1.479,1.5818,1.6697,2.7602,2.2694,1.4775,1.5827,1.6663,2.7718,2.2524,1.4835,1.5803,1.6714,2.7739,2.2558,1.4828,1.581,1.67,2.7831,2.2329,1.4844,1.5809,1.667,2.8001,2.2227,1.4831,1.5806,1.6705,2.8013,2.2159,1.4863,1.5857,1.6656,2.8167,2.2032,1.4798,1.5822,1.6685,2.824,2.1934,1.4806,1.5868,1.6686,2.8322,2.1749,1.4811,1.586,1.6696,2.8366,2.1687,1.4821,1.5825,1.6678,2.8481,2.153,1.4851,1.5836,1.6702,2.861,2.1352,1.4797,1.5923,1.6648,2.8697,2.1276,1.4849,1.5886,1.6614,2.879,2.1201,1.4828,1.5902,1.6692,2.8916,2.1084,1.4774,1.5896,1.6664,2.895,2.1055,1.4852,1.5838,1.6721,2.8963,2.0833,1.4882,1.588,1.6723,2.9079,2.0746,1.4895,1.596,1.67,2.9141,2.0671,1.492,1.5892,1.6733,2.9264,2.0573,1.4978,1.5964,1.6706,2.9365,2.0528,1.4872,1.5952,1.6688,2.9398,2.0358,1.4896,1.598,1.6689,2.9502,2.0338,1.4855,1.5943,1.6702,2.9559,2.0196,1.4997,1.6038,1.6641,2.9581,2.0113,1.4967,1.5962,1.6698,2.971,2.0038,1.4937,1.6055,1.6692,2.9873,1.9944,0.0:1
-0.0012222,0.0060194,-0.0031195,0.0077674,-0.0013515,0.0033555,0.0051929,0.0018825,0.0029927,0.0023931,0.001835,1.6554E-4,-0.0017742,5.7442E-4,0.0018083,0.002266,-0.0012947,-5.1926E-4,0.0060252,7.7357E-4,0.0037063,0.0034868,-0.0053197,0.0016587,0.0023553,0.0068825,0.0022825,-0.0051272,0.014563,-0.0046232,0.0072363,0.0020535,-0.0019573,0.0076884,-0.0045867,0.0043837,0.0022273,0.0027094,0.0063545,-0.0025562,0.0033625,0.0061378,-5.8024E-4,0.0047369,-0.0025236,0.0050104,0.0063622,0.0010601,0.0085819,-0.0048978,0.0028029,0.0040646,-0.0042282,0.011184,-0.0036124,0.012561,0.0073868,-0.0070196,0.010897,-0.0046864,0.0046215,0.006116,-0.0016984,0.0052025,-0.0051961,0.007243,0.0056648,-0.002836,0.0080589,-0.0016363,0.0024617,-0.0013097,8.8821E-4,0.0083908,-0.0044204,0.005027,0.0044589,-0.001385,0.0058184,9.5933E-5,5.839E-4,0.0032469,-0.0079384,0.0067313,-2.8081E-4,0.0077246,-0.0011288,-0.0059934,0.01032,-0.0027441,0.0081914,0.0052877,-0.0049439,0.012787,-0.012033,0.014482,0.0068143,-0.0042422,0.0066242,-0.0052222,0.0050461,0.0093204,-0.0052483,0.0082632,-0.0060293,0.0068837,0.006254,-0.0025224,0.0079285,-0.0055486,0.013841,0.007403,-0.0077317,0.01023,-0.0065581,0.0036754,7.8922E-4,-0.0029313,0.0069096,-0.0033979,0.012046,0.0073347,-0.0078649,0.0052013,6.3504E-4,0.0097151,0.0097637,-0.0041549,0.012764,-0.0074778,0.010774,0.0071282,-0.0061772,0.0071537,-0.0027372,0.0056921,0.0065287,-0.0076652,0.0086173,-0.0086177,0.0061923,9.2461E-4,-8.8208E-4,0.018147,-0.012844,0.008932,0.0029193,-0.00567,0.013015,-0.0034874,0.0069939,0.008744,-0.0080256,0.01017,-0.011581,0.013622,0.0082091,-0.0026404,0.014111,-0.0050899,0.010035,0.0077891,-0.0052015,0.012239,-0.0063682,0.014015,0.0090926,-0.0069173,0.014359,-0.010428,0.0058953,0.0057259,-0.0043855,0.011231,-0.0098,0.003326,0.0063439,-0.0052105,0.01441,-0.0073365,0.010032,0.0050735,-0.0042716,0.012763,-0.0072845,0.0057711,0.0087229,-3.5065E-4,0.015215,-0.0088828,0.0095562,0.0026174,-1.8542E-4,0.015446,-0.0060429,0.0099918,0.0055268,-0.0062342,0.012392,-0.0068841,0.011978,-0.0094466,0.018428,-0.0056732,0.016589,0.011338,-0.012229,0.01839,-0.0093027,0.013478,0.002507,-0.0054192,0.014336,-0.0029237,0.0083738,0.0046282,0.0022686,0.010601,-0.012303,0.010192,2.1025,0.21585,0.37166,0.27834,0.62135,0.35151,0.22262,0.31648,0.31348,0.65228,0.37027,0.24268,0.33796,0.33556,0.70155,0.39615,0.27322,0.36573,0.3533,0.74968,0.42935,0.28347,0.40765,0.39487,0.84355,0.49662,0.3332,0.45362,0.44554,0.93556,0.54559,0.37898,0.51165,0.5327,1.029,0.63799,0.448,0.57694,0.64573,1.1276,0.73051,0.52089,0.65757,0.7546,1.2097,0.80428,0.56932,0.69495,0.80152,1.2434,0.83106,0.57617,0.71195,0.84346,1.3092,0.90442,0.64752,0.79204,0.95457,1.3959,0.99653,0.64796,0.4204,0.24088,0.57223,0.33457,0.21313,0.29641,0.27709,0.56411,0.33097,0.20833,0.29324,0.27521,0.56184,0.32637,0.20958,0.2903,0.27447,0.56502,0.33811,0.20697,0.29354,0.26843,0.56589,0.32353,0.2041,0.29133,0.27052,0.56922,0.3283,0.20727,0.28912,0.26709,0.56453,0.32245,0.20399,0.28534,0.26441,0.56781,0.31528,0.20311,0.29325,0.2632,0.56945,0.32091,0.20644,0.29236,0.2613,0.56509,0.31338,0.20249,0.28663,0.26037,0.56078,0.31709,0.20045,0.28448,0.26002,0.56405,0.31355,0.19502,0.29558,0.26017,0.56503,0.31143,0.2009,0.28709,0.26389,0.56084,0.32117,0.19955,0.29223,0.25876,0.55667,0.31046,0.20046,0.28287,0.2622,0.55754,0.3211,0.19557,0.29016,0.26243,0.55885,0.31651,0.19682,0.28735,0.25752,0.55598,0.31612,0.19946,0.28185,0.2593,0.55577,0.31312,0.19521,0.28677,0.25536,0.56184,0.30548,0.19387,0.28402,0.25865,0.55942,0.31434,0.19851,0.27913,0.2584,0.56587,0.31237,0.19645,0.28639,0.25928,0.55601,0.31249,0.20026,0.28965,0.2652,0.56396,0.0:1
0.002981,0.0028287,-0.0051587,0.012061,-0.0030227,0.007495,0.010829,-0.0031219,0.0045509,0.0035343,-6.3663E-4,0.0094513,1.6503E-4,0.011574,0.0012488,0.0098428,0.0030732,-0.0014134,0.01528,-0.0024657,0.0064174,0.0086305,-0.0015226,0.012158,0.0030827,0.0064755,0.006979,-0.0047149,0.009496,-0.0015486,0.0060041,0.0066258,3.0961E-4,0.004737,0.0010228,0.0071796,0.0082634,-0.0023753,0.0042499,-0.0013499,0.0053822,0.007081,8.497E-5,0.0085174,-0.0036863,-0.0016709,0.0061175,-0.0051478,0.015544,-1.4475E-4,0.0079971,0.013074,-0.0096196,0.010427,-0.0024012,0.0047745,0.0041375,-0.010633,0.012505,0.0046291,0.010136,0.0091327,-0.0044264,0.0082503,-0.0015755,0.003231,0.003483,-0.0037473,0.0078294,0.0016063,0.0036319,0.0085638,-0.005516,0.0056646,-0.002446,0.0060297,0.0093962,-0.01039,0.0087019,-0.0020834,0.0094603,0.011576,-0.0031435,0.0084678,-6.9339E-4,0.0046233,0.007374,-0.0066877,0.013468,-0.0077025,0.0044922,0.0096414,-0.0055168,0.0076717,-5.7148E-4,0.0060224,0.0062864,-9.8427E-4,0.013525,0.0013605,0.0038751,0.0083687,-0.004724,0.0096064,-0.0070632,0.011766,0.00537,-0.0027486,0.006334,0.0011369,-0.0026678,0.0067691,-0.0028601,0.0061918,0.002586,0.0022638,0.0074247,-5.9604E-4,0.0085518,-0.0036414,0.012894,0.0047654,-0.0036258,0.0088165,-0.0010637,0.0036004,0.01119,-3.5673E-4,0.0084548,0.0038142,0.0096839,0.0072687,-0.0017619,0.0091685,0.0038904,0.0076096,6.4666E-4,0.0018268,0.0048473,7.2967E-4,0.0048933,0.0032177,-0.0018243,0.0049037,0.0015197,0.0115,0.0048933,0.0010791,0.0049992,0.0033163,0.0071044,4.6012E-4,7.7144E-5,0.0099046,0.0024263,0.0025537,0.0010865,8.0169E-4,0.0073749,0.0065251,0.006178,0.0017473,0.0063214,0.0013333,0.0072189,-0.0011499,0.0063463,0.0071242,0.0022157,8.7136E-4,0.0072303,0.0025175,0.0060808,0.0021728,0.0059914,0.0052796,0.0022098,-0.0010819,0.0029745,0.0065707,0.0087559,0.0035183,0.0068909,-1.3091E-4,0.0053212,0.0015041,-2.7136E-4,-7.3198E-4,0.0043488,0.0015181,0.0031401,0.0069199,0.0036141,0.005576,0.0022484,0.0039555,0.0015009,0.0015049,0.0068908,0.0018855,0.001938,-0.0021449,0.012847,-0.011691,0.014614,-0.0083184,-0.0052698,0.0091333,-0.013097,0.010862,-0.0019072,-0.0017575,0.01041,-0.0098533,0.0092678,0.0030153,0.96693,0.39466,0.28356,0.41416,0.74337,0.38304,0.34721,0.35897,0.46524,0.80135,0.41867,0.38469,0.39546,0.54152,0.85402,0.47693,0.43756,0.45791,0.65086,0.93397,0.55243,0.49287,0.52721,0.77688,1.0289,0.64589,0.57947,0.62071,0.91898,1.1486,0.75786,0.6513,0.70003,1.0292,1.2174,0.80357,0.67771,0.71565,1.044,1.2454,0.83503,0.71244,0.76158,1.12,1.3155,0.91159,0.73166,0.42074,0.30364,0.62651,0.30959,0.28839,0.27609,0.33492,0.60322,0.29547,0.2783,0.27434,0.33534,0.6031,0.29981,0.28107,0.27299,0.33217,0.60028,0.2931,0.27266,0.2655,0.33003,0.60227,0.29083,0.27696,0.26612,0.32844,0.60099,0.29311,0.27029,0.26847,0.32597,0.60337,0.28608,0.27218,0.26851,0.32672,0.60534,0.29001,0.27304,0.2674,0.32762,0.59414,0.29016,0.26984,0.26803,0.32393,0.59881,0.28936,0.26348,0.2654,0.32726,0.60146,0.28888,0.26698,0.27005,0.31873,0.594,0.28776,0.26702,0.26936,0.32248,0.59314,0.28105,0.26672,0.2645,0.3272,0.59781,0.27387,0.26946,0.26132,0.32195,0.59995,0.27739,0.26924,0.26317,0.32389,0.59745,0.27765,0.264,0.26208,0.32033,0.60242,0.27262,0.27337,0.26299,0.32034,0.59787,0.26845,0.26433,0.26402,0.31704,0.59863,0.27808,0.26596,0.26038,0.31911,0.59593,0.27542,0.26304,0.264,0.31868,0.60666,0.26436,0.26641,0.26338,0.31815,0.60114,0.26897,0.26768,0.2612,0.31659,0.59796,0.27289,0.26517,0.2648,0.31076,0.60391,0.27147,0.26121,0.26407,0.32,0.60192,0.26084,0.26304,0.26508,0.31658,0.60682,0.26609,0.2621,0.25968,0.31449,0.59884,0.2692,0.26306,0.26143,0.31425,0.0:1
0.0017351,0.0090276,0.0091591,-0.0039198,0.0090896,-7.758E-4,-0.0015366,0.0064527,-0.0055319,0.010588,0.0070407,0.0029863,0.008059,-0.0040462,0.0072386,-0.0042463,-5.8829E-4,0.0066495,-0.001697,0.0033023,-0.0023034,-1.3386E-4,0.012175,-6.941E-4,0.0083934,0.0016062,0.0057526,0.0081874,-0.0037666,0.0056284,0.0028749,0.0038659,0.0036282,-0.0018999,0.0033241,0.0025201,-4.8184E-4,0.004685,-0.0049886,0.0096586,0.0067986,-7.3739E-4,0.0068586,0.0018008,0.0040761,8.0343E-5,-1.9033E-5,0.0018975,-0.0020409,0.0060181,0.0020857,-0.0068118,0.00422,-0.0049988,0.0045134,-7.276E-4,-0.0013225,0.011578,-0.0016548,0.0037276,0.0027119,-5.2254E-4,0.0074055,-0.0060484,0.0031445,8.2869E-4,-0.0036374,0.0058805,-0.0031435,0.005731,-0.0019421,1.7552E-4,0.0039635,-0.0041668,0.0015726,-1.8856E-4,0.0010289,0.0074175,-0.0045739,0.0037696,0.0040318,0.0067475,-9.4634E-4,-0.0046738,0.0024385,0.0011317,0.0023572,0.0058077,-0.0044308,0.0026658,0.0030379,-0.0031628,0.0037094,0.0055712,0.0044449,0.0056651,6.2982E-4,0.0069488,-0.0067275,0.0047456,0.0026644,0.0050538,6.9363E-4,3.0097E-4,4.0987E-4,0.007758,0.0066323,0.0036208,0.0022462,0.0086225,7.1203E-4,0.0073061,0.0049923,0.0066169,0.0011691,0.0042068,-0.0034776,0.0034985,8.2923E-4,0.0012393,8.6643E-4,0.010352,-0.0040819,0.0014906,0.0052304,0.0069168,9.0758E-4,0.0061935,0.0030786,0.0021948,0.0010531,-0.0026317,-7.2425E-4,8.9157E-5,0.0062951,-0.0018589,-2.4346E-4,0.0046959,0.0048129,0.0041122,0.0072131,-6.4654E-4,0.0052436,-0.0017188,-3.736E-4,-0.0011107,0.0016648,0.0017503,0.0049208,0.0017,0.012035,0.0026971,-0.0025012,0.0059476,0.0058803,-1.9592E-4,0.0042508,0.0016244,0.005397,0.0016251,0.0010428,0.0084355,-3.0505E-4,5.879E-4,-0.0013836,0.0035688,0.0045091,0.0022154,0.0010475,0.0028299,-3.9807E-4,0.0029363,-2.9576E-4,0.0022326,-4.822E-5,-6.903E-5,0.0051863,-0.0032697,5.4407E-4,0.0050864,0.0046268,0.0034878,0.0041176,0.0037042,0.0019839,0.0015208,0.0023059,0.0051655,0.0037134,0.0038827,0.005717,0.0025786,0.0053101,0.0071139,-1.6923E-4,0.0098834,0.0037001,6.9932E-4,0.0018462,0.0041808,0.01615,-0.0099309,0.0073048,0.0040288,-0.014632,0.013835,-0.013979,0.01552,0.004975,-0.0083969,0.016604,-0.015718,1.1382,0.45819,0.23489,0.37567,0.34579,0.72635,0.52059,0.28482,0.40949,0.40018,0.83079,0.59089,0.34686,0.47269,0.46706,0.95477,0.6826,0.42609,0.54213,0.55407,1.0809,0.78218,0.49798,0.62922,0.64639,1.2519,0.91164,0.58739,0.72182,0.74107,1.3769,0.98611,0.63299,0.74853,0.76247,1.386,1.0093,0.65321,0.77225,0.81053,1.4551,1.0858,0.70372,0.38294,0.23139,0.53509,0.37694,0.18662,0.28176,0.26685,0.5187,0.38029,0.19627,0.2856,0.25702,0.51921,0.38103,0.19145,0.27608,0.26129,0.52152,0.38327,0.1889,0.27998,0.26076,0.52311,0.38216,0.18942,0.276,0.26224,0.51616,0.37565,0.18377,0.27833,0.26495,0.51494,0.38335,0.18045,0.2789,0.25583,0.51779,0.38337,0.19319,0.27592,0.25536,0.519,0.38347,0.18594,0.27711,0.25934,0.52179,0.38067,0.1855,0.27799,0.26194,0.51337,0.37692,0.18926,0.27852,0.26172,0.51463,0.38248,0.18551,0.27379,0.261,0.51617,0.38448,0.18367,0.27665,0.26044,0.52095,0.38538,0.18696,0.27876,0.24805,0.52005,0.38466,0.19353,0.27799,0.25887,0.51673,0.3799,0.18138,0.27911,0.2567,0.52066,0.38253,0.18864,0.2799,0.25915,0.5176,0.38546,0.18928,0.27577,0.26104,0.51781,0.38117,0.19121,0.27733,0.25549,0.51722,0.38358,0.19583,0.27487,0.25996,0.5169,0.38409,0.17879,0.27972,0.26344,0.52187,0.37617,0.18443,0.27292,0.26267,0.51575,0.38653,0.18574,0.27169,0.26254,0.51817,0.37989,0.18628,0.28144,0.26241,0.51311,0.38326,0.18799,0.2763,0.26052,0.52501,0.37749,0.18698,0.27365,0.25939,0.52466,0.37886,0.18495,0.28113,0.25742,0.51805,0.3811,0.1888,0.28219,0.25751,0.51817,0.38315,0.18817,0.0:1
0.0052135,-0.023206,0.022166,-0.02306,0.0042203,0.0031239,-0.022917,0.027605,-0.021007,0.0035738,0.011779,-0.02624,0.022983,-0.022488,0.0033558,0.0037528,-0.028133,0.021,-0.017713,0.0089195,0.006503,-0.024995,0.021485,-0.026717,-2.2672E-4,0.0016134,0.36935,0.33989,-0.10744,0.047493,0.0066635,-0.042969,0.024314,-0.035235,0.047741,0.22858,0.23715,0.38632,0.4668,0.64284,0.29732,0.25379,0.3839,0.47607,0.65419,0.2959,0.26622,0.38702,0.47771,0.65892,0.30044,0.26735,0.38833,0.47693,0.66128,0.29921,0.26615,0.38685,0.47452,0.66262,0.30284,0.26966,0.38626,0.47858,0.67583,0.30298,0.27439,0.38368,0.47814,0.6722,0.29976,0.27022,0.38714,0.47849,0.66933,0.30272,0.27385,0.38565,0.46848,0.66762,0.30428,0.274,0.39024,0.47822,0.67317,0.30631,0.27034,0.38902,0.46871,0.67477,0.30836,0.2731,0.38825,0.47256,0.67825,0.30491,0.27912,0.39161,0.466,0.67867,0.30145,0.27288,0.38761,0.46884,0.69484,0.30803,0.27341,0.38939,0.46706,0.68626,0.31385,0.27297,0.39269,0.46454,0.68354,0.30784,0.26964,0.3907,0.46248,0.68724,0.30583,0.27273,0.38959,0.46058,0.68444,0.31052,0.27055,0.39261,0.46391,0.6892,0.30476,0.2727,0.39437,0.45827,0.68661,0.30769,0.27132,0.39052,0.46203,0.68777,0.30615,0.27868,0.38505,0.45579,0.68473,0.30767,0.27025,0.38647,0.46096,0.69562,0.30668,0.27089,0.39248,0.45637,0.68961,0.30787,0.26789,0.39383,0.44827,0.69354,0.30782,0.27152,0.3852,0.45227,0.69609,0.30408,0.26856,0.38957,0.45511,0.6932,0.31098,0.2752,0.38273,0.44758,0.69121,0.3124,0.2733,0.38221,0.44784,0.69513,0.30918,0.27048,0.38718,0.44788,0.69769,0.32004,0.27725,0.38762,0.44527,0.69739,0.31806,0.27213,0.38356,0.44981,0.70493,0.31394,0.26835,0.38948,0.44581,0.7006,0.0:1
-0.0071216,-0.014548,0.019217,-0.020327,0.018878,-0.008846,-0.015834,0.021715,1.402,0.32067,0.00202,-0.0090231,0.036089,-0.036832,0.024055,-0.0033661,-0.027444,0.21736,0.29669,0.71448,0.61059,0.29511,0.38051,0.37256,0.67521,0.611,0.29127,0.3778,0.36145,0.67392,0.61546,0.30172,0.37601,0.36318,0.66712,0.61671,0.2947,0.37888,0.36511,0.66203,0.61987,0.29209,0.37117,0.35829,0.6598,0.61436,0.29126,0.37088,0.35953,0.65938,0.6188,0.29045,0.37553,0.35403,0.65697,0.62363,0.29402,0.36621,0.35707,0.64606,0.62055,0.29549,0.3656,0.35681,0.64759,0.62609,0.28878,0.36985,0.35862,0.64983,0.6205,0.29446,0.36732,0.35241,0.63923,0.6256,0.29059,0.36368,0.35624,0.64207,0.61873,0.28716,0.36661,0.35088,0.63301,0.6198,0.2933,0.37228,0.35517,0.63135,0.62093,0.2878,0.3617,0.35049,0.62977,0.62962,0.29212,0.37326,0.35374,0.62451,0.63404,0.29662,0.36323,0.34445,0.62689,0.62879,0.29006,0.36705,0.34977,0.62178,0.62531,0.29232,0.36761,0.34843,0.61847,0.63088,0.28864,0.362,0.34388,0.61223,0.63144,0.29518,0.36407,0.35119,0.6238,0.63534,0.29685,0.3612,0.35032,0.60955,0.6406,0.29502,0.36555,0.34636,0.60972,0.64119,0.29481,0.35908,0.34987,0.60596,0.64249,0.29401,0.36003,0.34425,0.60439,0.64371,0.29479,0.36049,0.3481,0.60037,0.64833,0.28806,0.36013,0.34896,0.59691,0.64766,0.30231,0.3598,0.35144,0.59234,0.65284,0.29249,0.3599,0.34659,0.5912,0.653,0.29438,0.3601,0.34389,0.59173,0.65494,0.29833,0.36132,0.34504,0.5911,0.65256,0.29153,0.35688,0.34219,0.58209,0.65628,0.30021,0.3555,0.34385,0.58092,0.66314,0.29992,0.36232,0.3456,0.57598,0.66445,0.29968,0.34994,0.34084,0.57021,0.66187,0.30004,0.35202,0.33778,0.56989,0.0:1
-0.0093539,0.0034698,0.010075,-0.015519,0.012752,-0.0066691,-0.001589,0.0082057,-0.015347,0.010754,-0.0081595,-4.9812E-4,0.015772,-0.012607,0.014541,-0.0039136,-0.0061472,0.014631,-0.021351,0.013412,-0.0089692,-0.0022392,0.014634,-0.017491,0.012982,0.80421,1.484,1.0713,1.1688,1.4839,1.8516,1.5423,1.1428,1.1547,1.5679,1.8905,1.5779,1.1702,1.1798,1.4084,1.197,0.68367,0.48054,0.47133,0.56667,0.95495,0.63357,0.45215,0.45587,0.54613,0.94264,0.62222,0.44522,0.44954,0.54027,0.93575,0.61807,0.44361,0.4528,0.53981,0.93371,0.62091,0.44583,0.45069,0.53905,0.93354,0.61187,0.43952,0.45011,0.53825,0.93353,0.61737,0.43582,0.45282,0.53644,0.93553,0.61323,0.43581,0.44837,0.53617,0.92846,0.61737,0.43206,0.4492,0.53134,0.92837,0.61471,0.43237,0.45375,0.53456,0.93129,0.61043,0.43744,0.44116,0.53492,0.93266,0.61096,0.43813,0.44592,0.53087,0.93007,0.61437,0.44109,0.44943,0.536,0.92699,0.61202,0.42761,0.4496,0.52919,0.92718,0.61352,0.43623,0.4452,0.53045,0.92867,0.61622,0.4335,0.44963,0.52495,0.92775,0.60893,0.42868,0.45121,0.52901,0.92513,0.60786,0.42658,0.4432,0.52635,0.92865,0.61338,0.4277,0.44464,0.52744,0.92833,0.61138,0.43135,0.44423,0.52872,0.92087,0.60512,0.43427,0.44797,0.52468,0.92292,0.60671,0.42639,0.44593,0.53033,0.91673,0.61022,0.42199,0.44359,0.52267,0.92615,0.60908,0.42477,0.44382,0.52695,0.91974,0.61609,0.424,0.44752,0.52213,0.91969,0.61114,0.42782,0.44596,0.52716,0.91263,0.61031,0.43257,0.44453,0.52419,0.91426,0.6151,0.42227,0.44886,0.52491,0.91308,0.6125,0.42768,0.44501,0.52226,0.91285,0.61894,0.42251,0.452,0.5156,0.91192,0.61145,0.42917,0.44441,0.52571,0.91621,0.61145,0.42782,0.44222,0.5203,0.0:1
0.0035584,0.016083,-0.019364,0.01781,-0.018658,0.002614,0.0088273,-0.01124,0.020567,-0.013958,-0.0015201,0.012789,-0.016273,0.016231,-0.0095917,0.0075433,0.0033319,-0.015956,0.0091535,1.8932,1.6075,1.2608,1.0136,1.1726,1.7406,1.6435,1.3053,1.0751,1.215,1.8249,1.7052,1.3469,1.1063,1.2556,1.8598,1.7271,1.3079,0.90583,0.85905,0.84808,0.91024,0.61669,0.51456,0.58986,0.80597,0.89166,0.60877,0.49773,0.59439,0.79116,0.88914,0.58747,0.50136,0.58126,0.79356,0.87803,0.58823,0.49174,0.57725,0.7801,0.87669,0.56985,0.48899,0.57867,0.77627,0.86827,0.57256,0.4851,0.57221,0.7735,0.86682,0.57226,0.4761,0.57112,0.76343,0.86859,0.56849,0.47615,0.56832,0.75643,0.86084,0.56849,0.4701,0.55824,0.74816,0.86871,0.55667,0.47375,0.56058,0.75545,0.86016,0.56296,0.46689,0.55257,0.74539,0.8562,0.55432,0.46142,0.54807,0.74592,0.85235,0.55341,0.46075,0.55697,0.74497,0.8628,0.55337,0.46263,0.55117,0.73782,0.8589,0.55174,0.46666,0.54509,0.73118,0.85466,0.54845,0.45969,0.55169,0.73821,0.85406,0.54566,0.46197,0.54936,0.72969,0.84916,0.54705,0.45138,0.54994,0.72812,0.86017,0.54095,0.45193,0.54256,0.72362,0.8503,0.54583,0.4565,0.54103,0.71941,0.85386,0.54201,0.45477,0.53884,0.72399,0.84884,0.54896,0.45093,0.54156,0.71864,0.85588,0.54505,0.44887,0.53335,0.71547,0.86072,0.54127,0.45532,0.53573,0.71681,0.8485,0.53747,0.44541,0.53494,0.71075,0.85018,0.53095,0.44813,0.5333,0.71675,0.84582,0.54411,0.44109,0.53942,0.70499,0.84944,0.53283,0.44399,0.53076,0.70562,0.85069,0.54327,0.43891,0.53541,0.69898,0.85908,0.53524,0.44401,0.52553,0.71238,0.85032,0.53397,0.44784,0.53201,0.69899,0.85062,0.5395,0.44379,0.52928,0.70475,0.0:1
-0.0055715,0.010483,-0.012613,0.011722,5.4329E-4,-0.0030377,0.012462,-0.015369,0.0059524,-0.0045792,-0.0084472,0.014942,-0.016186,0.013464,-0.004035,-0.0089878,0.0095116,-0.0072164,0.010621,0.0018643,-0.010977,0.012637,0.90906,1.8494,1.4049,1.0294,1.0911,1.184,1.821,1.4612,1.0833,1.1149,1.2523,1.8752,1.5016,1.1112,1.1318,1.2904,1.8851,1.4243,0.79725,0.60624,0.47917,0.9199,0.61905,0.40211,0.47824,0.46161,0.90403,0.61343,0.4094,0.47382,0.45687,0.8994,0.6251,0.39387,0.47254,0.44977,0.89268,0.60954,0.39652,0.46829,0.45601,0.88258,0.61312,0.38986,0.47546,0.44856,0.88952,0.6111,0.3968,0.4621,0.45193,0.88343,0.61276,0.39103,0.46701,0.44977,0.88045,0.60814,0.38796,0.46871,0.45152,0.87828,0.62111,0.3875,0.46185,0.44008,0.87323,0.61938,0.39455,0.46584,0.44951,0.8763,0.61244,0.39214,0.46094,0.44952,0.88463,0.61221,0.38517,0.46413,0.44201,0.87605,0.60987,0.39086,0.45877,0.45688,0.86163,0.6114,0.38341,0.46409,0.44685,0.87524,0.61255,0.39127,0.46012,0.45227,0.86817,0.6148,0.39231,0.46775,0.45185,0.87363,0.61595,0.39456,0.46453,0.44711,0.86599,0.61884,0.3948,0.4615,0.4473,0.87015,0.62591,0.3845,0.46067,0.45136,0.87029,0.61899,0.3889,0.45635,0.45204,0.86864,0.61841,0.37833,0.46023,0.45007,0.8713,0.61532,0.39702,0.45475,0.45232,0.86211,0.62472,0.39117,0.4639,0.45107,0.86603,0.62526,0.3958,0.45411,0.44591,0.8618,0.63002,0.39254,0.45343,0.4543,0.86264,0.62482,0.38803,0.45884,0.45606,0.86166,0.61989,0.39863,0.4559,0.45506,0.85356,0.62979,0.39115,0.45521,0.4486,0.86365,0.62237,0.39621,0.45819,0.45054,0.84941,0.63125,0.387,0.45883,0.45108,0.85107,0.62462,0.39526,0.45077,0.44951,0.8499,0.63379,0.0:1
5.1357E-4,1.4823E-5,-4.5532E-4,6.7014E-4,-9.0314E-4,3.1879E-4,-4.9337E-5,-6.0224E-4,9.5466E-4,-9.1606E-4,2.7643E-4,5.0447E-5,-5.226E-4,7.6169E-4,-6.8853E-4,4.9864E-4,-1.499E-5,-6.9685E-4,8.802E-4,-6.793E-4,5.5633E-4,0.035903,0.12001,0.089001,0.098499,0.11901,0.12253,0.10875,0.089048,0.099483,0.11908,0.123,0.10954,0.089637,0.099969,0.11948,0.12391,0.10975,0.089772,0.099859,0.1192,0.12353,0.1099,0.089351,0.099465,0.11941,0.1238,0.11039,0.089631,0.099513,0.11917,0.12391,0.11037,0.090061,0.099157,0.11906,0.12377,0.11021,0.089906,0.099489,0.11949,0.12448,0.11048,0.089777,0.09921,0.11893,0.12369,0.11046,0.089798,0.098873,0.11843,0.12409,0.11061,0.089813,0.09882,0.11867,0.12426,0.11025,0.089614,0.09895,0.11818,0.12398,0.11064,0.089521,0.098562,0.11808,0.12391,0.11077,0.08937,0.098143,0.11768,0.12343,0.11055,0.089169,0.09791,0.11782,0.12342,0.11032,0.08926,0.097739,0.11732,0.12357,0.11032,0.089164,0.097544,0.11727,0.12335,0.11032,0.089034,0.097143,0.11666,0.12327,0.11057,0.088511,0.09729,0.11635,0.12279,0.11027,0.08881,0.097221,0.11632,0.12267,0.10994,0.088429,0.096723,0.11557,0.12241,0.11025,0.088483,0.096086,0.11577,0.12223,0.10959,0.088265,0.096244,0.11526,0.12257,0.10939,0.087918,0.095915,0.11481,0.12197,0.10926,0.087961,0.095649,0.11454,0.12154,0.10928,0.087665,0.095292,0.11448,0.1212,0.10958,0.087466,0.09488,0.11373,0.12128,0.10957,0.087195,0.094572,0.11389,0.12077,0.10921,0.087309,0.094862,0.11422,0.12161,0.10979,0.087981,0.094839,0.11477,0.12234,0.11063,0.088907,0.095605,0.11571,0.12289,0.11109,0.08903,0.095445,0.11525,0.12317,0.111,0.088612,0.095167,0.11464,0.12216,0.11084,0.088463,0.094965,0.11441,0.12219,0.11044,0.088573,0.094526,0.11422,0.12196,0.1103,0.088206,0.094248,0.0:2
2.5531E-4,4.3552E-4,-8.2401E-4,7.7241E-4,-3.1369E-4,1.3842E-4,4.2178E-4,-8.0366E-4,7.9752E-4,-5.6147E-4,-5.629E-5,4.1718E-4,-7.3582E-4,7.4063E-4,-3.7326E-4,-1.8923E-5,6.2737E-4,-0.0010101,5.9293E-4,-5.5129E-4,1.1673E-4,0.091952,0.096181,0.092847,0.11602,0.1284,0.11012,0.093482,0.094756,0.1149,0.12794,0.11106,0.093419,0.094964,0.11485,0.1276,0.11136,0.093269,0.094849,0.11491,0.1279,0.11216,0.093607,0.095007,0.11448,0.12775,0.11197,0.094087,0.095207,0.11529,0.12783,0.11247,0.093825,0.094828,0.11525,0.12783,0.11256,0.093633,0.094651,0.11493,0.1281,0.11297,0.093909,0.09463,0.11507,0.12808,0.11304,0.094246,0.094707,0.1146,0.12766,0.11313,0.094119,0.094696,0.11398,0.12717,0.11295,0.093688,0.093912,0.11422,0.12747,0.11331,0.093936,0.093875,0.11391,0.12728,0.11359,0.093906,0.093629,0.1136,0.12704,0.11329,0.093997,0.093638,0.1135,0.1268,0.11345,0.09393,0.0933,0.113,0.12675,0.1131,0.093894,0.092859,0.11273,0.12604,0.11292,0.093656,0.092645,0.1127,0.12581,0.11274,0.093765,0.092445,0.11229,0.12565,0.1132,0.093135,0.092101,0.11152,0.12538,0.11254,0.093181,0.091591,0.11121,0.12493,0.1126,0.093067,0.091506,0.11089,0.12496,0.11231,0.093046,0.0915,0.11069,0.12407,0.11235,0.092669,0.090735,0.11049,0.12407,0.11205,0.092636,0.090523,0.10981,0.12397,0.11231,0.09274,0.090329,0.10958,0.12383,0.11183,0.09238,0.090025,0.10928,0.12295,0.11139,0.092042,0.089624,0.10885,0.12313,0.11174,0.091864,0.089175,0.1082,0.12247,0.11134,0.091619,0.088926,0.10773,0.12177,0.11089,0.091333,0.088789,0.10735,0.12161,0.11081,0.091183,0.08802,0.10695,0.12144,0.11091,0.091094,0.088096,0.10643,0.12075,0.11092,0.090949,0.088007,0.10614,0.12042,0.11016,0.090959,0.087375,0.10566,0.12006,0.11058,0.090381,0.086935,0.10502,0.0:2
3.0E-7,1.6967E-6,-2.3E-6,1.9433E-6,-1.1567E-6,7.1667E-7,1.9933E-6,-1.5933E-6,1.9833E-6,-3.6E-7,9.2333E-7,1.3467E-6,-7.3667E-7,1.56E-6,2.5333E-7,8.1E-7,9.8333E-7,-5.4333E-7,2.0333E-6,1.5667E-7,3.5667E-7,1.4833E-6,-8.7E-7,1.9833E-6,-1.0133E-6,8.4667E-7,1.9533E-6,-1.4133E-6,1.52E-6,-1.6667E-8,3.4667E-7,2.1E-6,-1.53E-6,2.42E-6,-1.21E-6,5.8333E-7,9.0333E-7,-1.7367E-6,2.0567E-6,3.1667E-7,1.4567E-6,1.3984E-4,1.4177E-4,1.2096E-4,1.5189E-4,1.6036E-4,1.6992E-4,1.4232E-4,1.2266E-4,1.5019E-4,1.6107E-4,1.7237E-4,1.4456E-4,1.2283E-4,1.5225E-4,1.6307E-4,1.733E-4,1.4377E-4,1.2315E-4,1.5128E-4,1.6127E-4,1.7379E-4,1.4439E-4,1.2317E-4,1.5216E-4,1.6245E-4,1.7398E-4,1.4408E-4,1.2509E-4,1.5114E-4,1.6259E-4,1.7583E-4,1.4558E-4,1.2542E-4,1.5002E-4,1.6184E-4,1.7497E-4,1.4545E-4,1.2418E-4,1.503E-4,1.617E-4,1.7528E-4,1.4584E-4,1.2467E-4,1.5071E-4,1.622E-4,1.7579E-4,1.4447E-4,1.255E-4,1.5112E-4,1.6255E-4,1.771E-4,1.4613E-4,1.2537E-4,1.5225E-4,1.6321E-4,1.7784E-4,1.4662E-4,1.2577E-4,1.5223E-4,1.6203E-4,1.7582E-4,1.4598E-4,1.253E-4,1.5208E-4,1.618E-4,1.7568E-4,1.4566E-4,1.2506E-4,1.5217E-4,1.6333E-4,1.7698E-4,1.4618E-4,1.2579E-4,1.5161E-4,1.6312E-4,1.7717E-4,1.4546E-4,1.2524E-4,1.5192E-4,1.629E-4,1.7623E-4,1.4702E-4,1.2554E-4,1.5162E-4,1.6368E-4,1.7814E-4,1.458E-4,1.2528E-4,1.5054E-4,1.6391E-4,1.7765E-4,1.4655E-4,1.2627E-4,1.518E-4,1.6475E-4,1.7831E-4,1.4619E-4,1.2642E-4,1.5096E-4,1.6399E-4,1.7839E-4,1.4635E-4,1.258E-4,1.5067E-4,1.6378E-4,1.7892E-4,1.4765E-4,1.264E-4,1.5139E-4,1.6433E-4,1.791E-4,1.4746E-4,1.2672E-4,1.5119E-4,1.6316E-4,1.7873E-4,1.4717E-4,1.263E-4,1.5157E-4,1.6385E-4,1.7851E-4,1.4698E-4,1.259E-4,1.5069E-4,1.6302E-4,1.7845E-4,1.4767E-4,1.2597E-4,1.5122E-4,1.6393E-4,1.7869E-4,1.4701E-4,1.254E-4,1.5158E-4,1.6348E-4,1.7962E-4,1.4761E-4,1.2638E-4,1.5131E-4,1.6282E-4,1.7971E-4,1.4747E-4,1.2612E-4,1.5111E-4,1.6178E-4,1.7921E-4,1.4732E-4,1.261E-4,1.5134E-4,1.6301E-4,1.7909E-4,1.4801E-4,1.2611E-4,1.516E-4,1.6378E-4,1.7875E-4,1.4764E-4,1.2576E-4,1.5169E-4,1.6284E-4,1.7968E-4,1.4757E-4,1.2611E-4,1.5035E-4,1.6298E-4,1.7838E-4,1.4657E-4,1.2552E-4,1.5189E-4,1.637E-4,1.7978E-4,1.4726E-4,1.2591E-4,1.5094E-4,1.6193E-4,1.7824E-4,1.4856E-4,1.2613E-4,1.5022E-4,1.6278E-4,1.7946E-4,1.4816E-4,1.2597E-4,1.5085E-4,1.627E-4,1.7827E-4,1.4782E-4,1.2646E-4,1.499E-4,1.6263E-4,1.7873E-4,1.4782E-4,1.2577E-4,1.5091E-4,1.6235E-4,1.796E-4,1.4884E-4,1.2563E-4,1.5017E-4,1.6249E-4,1.8015E-4,1.4723E-4,1.2539E-4,1.5098E-4,1.6151E-4,1.7993E-4,1.4793E-4,1.2502E-4,1.5051E-4,1.6312E-4,1.8004E-4,1.4567E-4,1.2405E-4,1.5095E-4,1.623E-4,1.7901E-4,1.4717E-4,1.2558E-4,1.5189E-4,1.6382E-4,1.8003E-4,1.4697E-4,1.2407E-4,1.4962E-4,1.622E-4,1.8043E-4,1.4829E-4,1.2507E-4,1.4984E-4,1.6172E-4,1.8047E-4,1.4904E-4,1.2523E-4,1.5056E-4,1.6201E-4,1.789E-4,1.4777E-4,1.2648E-4,1.4929E-4,1.616E-4,1.785E-4,1.4867E-4,1.2655E-4,1.4985E-4,1.6077E-4,1.7803E-4,1.4766E-4,1.258E-4,1.4998E-4,1.6134E-4,1.79E-4,1.4814E-4,1.2547E-4,1.4976E-4,1.6064E-4,1.7892E-4,1.4707E-4,1.2569E-4,1.4947E-4,1.6162E-4,1.8005E-4,1.4703E-4,1.2567E-4,1.5059E-4,1.6073E-4,1.79E-4,1.4668E-4,1.2614E-4,1.5019E-4,1.5998E-4,1.799E-4,1.4747E-4,1.2573E-4,1.5053E-4,1.6244E-4,1.7902E-4,1.4806E-4,1.2512E-4,1.4873E-4,1.6161E-4,1.7921E-4,1.4723E-4,1.2574E-4,1.4853E-4,1.6282E-4,1.7959E-4,1.4784E-4,1.2439E-4,1.4827E-4,1.6114E-4,1.8019E-4,1.4711E-4,1.2324E-4,1.4905E-4,1.6168E-4,1.7878E-4,1.4758E-4,1.2392E-4,1.4821E-4,1.6169E-4,1.8058E-4,1.4733E-4,1.2477E-4,1.4848E-4,1.6051E-4,1.7949E-4,1.4849E-4,1.2574E-4,1.4905E-4,1.6094E-4,1.7891E-4,1.4798E-4,1.2513E-4,1.4863E-4,1.6063E-4,1.784E-4,1.4728E-4,1.244E-4,1.4982E-4,1.6211E-4,1.7986E-4,1.4688E-4,1.2411E-4,1.4888E-4,1.6175E-4,1.7998E-4,1.4892E-4,1.2519E-4,1.4884E-4,1.6109E-4,1.7907E-4,1.4847E-4,1.2467E-4,1.4844E-4,1.6052E-4,1.7953E-4,1.4757E-4,1.2408E-4,1.4778E-4,1.6024E-4,1.7912E-4,1.4729E-4,1.2529E-4,1.48E-4,1.595E-4,9.2487E-5:2
1.6333E-6,9.9E-7,3.2667E-7,1.3267E-6,-1.4133E-6,1.4E-6,1.5733E-6,1.0533E-6,1.31E-6,6.0E-8,1.85E-6,5.1E-7,-1.8E-7,1.7667E-6,-5.2333E-7,1.6833E-6,2.3667E-7,-1.1333E-7,1.82E-6,-5.2333E-7,8.8667E-7,-3.6667E-8,-7.0E-8,1.1067E-6,-1.0733E-6,1.22E-6,1.0333E-6,-1.5E-7,1.2767E-6,-5.5667E-7,1.3767E-6,7.6667E-7,-1.3333E-8,1.7E-6,3.4667E-7,1.2733E-6,-4.6667E-8,2.3E-7,1.3933E-6,-9.5333E-7,1.5533E-6,6.2E-7,3.0E-7,1.7433E-6,-9.5667E-7,2.04E-6,2.861E-5,2.1216E-4,1.4068E-4,1.4169E-4,1.2482E-4,1.6233E-4,1.7536E-4,1.4979E-4,1.3137E-4,1.3158E-4,1.6004E-4,1.7486E-4,1.5187E-4,1.307E-4,1.3396E-4,1.5912E-4,1.7456E-4,1.537E-4,1.3066E-4,1.3347E-4,1.592E-4,1.7558E-4,1.5465E-4,1.3187E-4,1.3414E-4,1.5938E-4,1.7583E-4,1.5567E-4,1.3174E-4,1.3475E-4,1.5987E-4,1.7653E-4,1.5626E-4,1.32E-4,1.3471E-4,1.5878E-4,1.7662E-4,1.5566E-4,1.3116E-4,1.3484E-4,1.5992E-4,1.756E-4,1.5524E-4,1.3247E-4,1.3605E-4,1.5914E-4,1.7682E-4,1.5662E-4,1.3238E-4,1.355E-4,1.5937E-4,1.7718E-4,1.5661E-4,1.3235E-4,1.3518E-4,1.5899E-4,1.7703E-4,1.5857E-4,1.3278E-4,1.356E-4,1.5857E-4,1.7766E-4,1.5769E-4,1.3257E-4,1.3523E-4,1.5993E-4,1.7709E-4,1.5795E-4,1.3299E-4,1.3498E-4,1.5972E-4,1.7741E-4,1.5815E-4,1.3199E-4,1.3606E-4,1.593E-4,1.7727E-4,1.5801E-4,1.3202E-4,1.3512E-4,1.5974E-4,1.7783E-4,1.5807E-4,1.3289E-4,1.3501E-4,1.5997E-4,1.7672E-4,1.5861E-4,1.3217E-4,1.3567E-4,1.5964E-4,1.7713E-4,1.588E-4,1.3268E-4,1.3598E-4,1.5942E-4,1.7676E-4,1.5751E-4,1.3188E-4,1.3534E-4,1.5969E-4,1.7749E-4,1.5882E-4,1.3216E-4,1.3494E-4,1.5914E-4,1.7763E-4,1.5913E-4,1.3124E-4,1.3539E-4,1.5884E-4,1.7711E-4,1.5945E-4,1.333E-4,1.3538E-4,1.5846E-4,1.7762E-4,1.5892E-4,1.3305E-4,1.3458E-4,1.5806E-4,1.7742E-4,1.581E-4,1.3156E-4,1.3602E-4,1.5919E-4,1.7711E-4,1.5976E-4,1.3325E-4,1.3568E-4,1.5891E-4,1.7771E-4,1.5966E-4,1.3292E-4,1.3447E-4,1.6059E-4,1.7738E-4,1.5998E-4,1.3315E-4,1.3505E-4,1.5827E-4,1.7819E-4,1.5949E-4,1.3326E-4,1.3538E-4,1.5898E-4,1.7759E-4,1.6031E-4,1.3308E-4,1.3527E-4,1.5967E-4,1.7838E-4,1.6001E-4,1.329E-4,1.353E-4,1.5888E-4,1.7662E-4,1.5962E-4,1.3159E-4,1.3256E-4,1.5761E-4,1.7738E-4,1.6037E-4,1.3277E-4,1.3402E-4,1.5833E-4,1.7703E-4,1.604E-4,1.3213E-4,1.3411E-4,1.5783E-4,1.7661E-4,1.6025E-4,1.3293E-4,1.3392E-4,1.5786E-4,1.7648E-4,1.6098E-4,1.3244E-4,1.3431E-4,1.5772E-4,1.7703E-4,1.6085E-4,1.3337E-4,1.3441E-4,1.5851E-4,1.7717E-4,1.6108E-4,1.3303E-4,1.3494E-4,1.5754E-4,1.7884E-4,1.614E-4,1.3309E-4,1.3531E-4,1.5875E-4,1.7701E-4,1.6173E-4,1.3321E-4,1.349E-4,1.5856E-4,1.7779E-4,1.6074E-4,1.3268E-4,1.3578E-4,1.5851E-4,1.7651E-4,1.6093E-4,1.3347E-4,1.3384E-4,1.5805E-4,1.7615E-4,1.6146E-4,1.3293E-4,1.3402E-4,1.5839E-4,1.7577E-4,1.6128E-4,1.3251E-4,1.3444E-4,1.5792E-4,1.7707E-4,1.6079E-4,1.33E-4,1.3369E-4,1.571E-4,1.7821E-4,1.6169E-4,1.331E-4,1.34E-4,1.5821E-4,1.7708E-4,1.6191E-4,1.3246E-4,1.331E-4,1.5822E-4,1.7767E-4,1.6206E-4,1.3269E-4,1.3423E-4,1.5788E-4,1.7669E-4,1.6132E-4,1.3247E-4,1.3343E-4,1.576E-4,1.7777E-4,1.621E-4,1.3251E-4,1.3415E-4,1.5802E-4,1.7589E-4,1.6153E-4,1.3301E-4,1.3418E-4,1.5724E-4,1.7795E-4,1.6106E-4,1.3346E-4,1.3369E-4,1.5842E-4,1.7613E-4,1.6148E-4,1.3324E-4,1.3424E-4,1.5803E-4,1.7628E-4,1.6251E-4,1.3304E-4,1.3356E-4,1.5713E-4,1.7703E-4,1.6127E-4,1.3328E-4,1.3256E-4,1.5799E-4,1.7641E-4,1.6165E-4,1.3357E-4,1.3372E-4,1.5845E-4,1.7578E-4,1.6145E-4,1.3212E-4,1.3223E-4,1.5736E-4,1.7668E-4,1.621E-4,1.3205E-4,1.3313E-4,1.5757E-4,1.7518E-4,1.6316E-4,1.3272E-4,1.3274E-4,1.5666E-4,1.7612E-4,1.617E-4,1.3119E-4,1.3186E-4,1.5595E-4,1.756E-4,1.6221E-4,1.3167E-4,1.322E-4,1.5706E-4,1.7614E-4,1.6326E-4,1.3254E-4,1.3265E-4,1.5671E-4,1.7585E-4,1.6219E-4,1.3249E-4,1.3248E-4,1.5667E-4,1.7559E-4,1.6318E-4,1.3261E-4,1.3156E-4,1.5718E-4,1.754E-4,1.6271E-4,1.3297E-4,1.3193E-4,1.5555E-4,1.7594E-4,1.6331E-4,1.3305E-4,1.3104E-4,1.5609E-4,1.7504E-4,1.6233E-4,1.3272E-4,1.3128E-4,1.5522E-4,1.7527E-4,1.6308E-4,1.3316E-4,1.3185E-4,1.5552E-4,1.7481E-4,1.6322E-4,1.3286E-4,1.3142E-4,1.5565E-4,1.7485E-4,1.6321E-4,1.3217E-4,1.3105E-4,1.5517E-4,1.7622E-4,1.6345E-4,1.3221E-4,1.3168E-4,1.5562E-4,1.7624E-4,1.6348E-4,1.3339E-4,1.3034E-4,1.5479E-4,1.7395E-4,1.6424E-4,1.3435E-4,1.3018E-4,1.5444E-4,1.7363E-4,1.6382E-4,1.3243E-4,1.3136E-4,1.5442E-4,1.7405E-4,1.6445E-4,1.3306E-4,1.3098E-4,1.547E-4,1.7365E-4,1.638E-4,1.3267E-4,1.2999E-4,1.5499E-4,1.7528E-4,1.6399E-4,1.3374E-4,1.3044E-4,1.5277E-4,1.7359E-4,1.6398E-4,1.3251E-4,1.3107E-4,1.5361E-4,1.7359E-4,1.63E-4,1.3193E-4,1.3005E-4,1.5515E-4,1.7204E-4,1.6384E-4,1.3337E-4,1.3042E-4,1.5439E-4,1.7314E-4,1.6368E-4,1.3346E-4,0.0:2
6.0E-7,-6.4333E-7,1.61E-6,-2.9E-7,5.9667E-7,6.1E-7,-5.5667E-7,1.4E-6,-3.9E-7,9.6E-7,1.8767E-6,-8.1E-7,1.5933E-6,-8.3333E-8,8.6667E-8,9.9E-7,-4.8333E-7,1.2867E-6,-1.5667E-7,1.0333E-7,1.5E-6,-1.2E-6,1.4667E-6,2.2E-7,5.4667E-7,1.65E-6,-1.1733E-6,2.1233E-6,-4.1E-7,6.8333E-7,1.8567E-6,-3.9667E-7,1.6133E-6,-2.4333E-7,-4.9333E-7,1.47E-6,-9.0333E-7,7.6E-7,1.0232E-4,1.5637E-4,1.7952E-4,1.4286E-4,1.2652E-4,1.417E-4,1.5802E-4,1.771E-4,1.4967E-4,1.2412E-4,1.437E-4,1.5678E-4,1.7626E-4,1.5063E-4,1.2371E-4,1.4317E-4,1.5707E-4,1.7639E-4,1.5037E-4,1.2381E-4,1.4405E-4,1.5764E-4,1.7807E-4,1.5237E-4,1.2351E-4,1.4146E-4,1.5469E-4,1.7722E-4,1.5081E-4,1.2398E-4,1.4414E-4,1.5806E-4,1.787E-4,1.5222E-4,1.2482E-4,1.4202E-4,1.5541E-4,1.7822E-4,1.539E-4,1.2486E-4,1.4372E-4,1.5575E-4,1.7723E-4,1.5317E-4,1.2557E-4,1.4249E-4,1.5612E-4,1.7788E-4,1.5354E-4,1.255E-4,1.443E-4,1.5582E-4,1.7753E-4,1.5445E-4,1.2554E-4,1.4301E-4,1.5527E-4,1.7783E-4,1.5442E-4,1.248E-4,1.4351E-4,1.5676E-4,1.7989E-4,1.5478E-4,1.2418E-4,1.4298E-4,1.5607E-4,1.7936E-4,1.5514E-4,1.244E-4,1.4343E-4,1.5638E-4,1.7943E-4,1.5538E-4,1.2445E-4,1.4281E-4,1.5619E-4,1.7896E-4,1.557E-4,1.2457E-4,1.4305E-4,1.5622E-4,1.7967E-4,1.5545E-4,1.2505E-4,1.4331E-4,1.5622E-4,1.7883E-4,1.5623E-4,1.2478E-4,1.4264E-4,1.5455E-4,1.7848E-4,1.558E-4,1.2485E-4,1.4225E-4,1.5525E-4,1.7929E-4,1.5595E-4,1.2474E-4,1.4312E-4,1.5539E-4,1.7788E-4,1.5673E-4,1.2465E-4,1.4312E-4,1.5503E-4,1.792E-4,1.5788E-4,1.2631E-4,1.4219E-4,1.5443E-4,1.7974E-4,1.5763E-4,1.2538E-4,1.4022E-4,1.5417E-4,1.8044E-4,1.6001E-4,1.262E-4,1.4123E-4,1.5354E-4,1.7858E-4,1.5885E-4,1.2632E-4,1.414E-4,1.5422E-4,1.8015E-4,1.6041E-4,1.2599E-4,1.4215E-4,1.5388E-4,1.7836E-4,1.5889E-4,1.2636E-4,1.4233E-4,1.546E-4,1.7849E-4,1.5982E-4,1.2609E-4,1.4176E-4,1.55E-4,1.7935E-4,1.5962E-4,1.2503E-4,1.4243E-4,1.5388E-4,1.7894E-4,1.5899E-4,1.2544E-4,1.4036E-4,1.5455E-4,1.7984E-4,1.5989E-4,1.2591E-4,1.4E-4,1.53E-4,1.7966E-4,1.6019E-4,1.2527E-4,1.4059E-4,1.5305E-4,1.8082E-4,1.6041E-4,1.2637E-4,1.4137E-4,1.5339E-4,1.8007E-4,1.6116E-4,1.259E-4,1.4087E-4,1.5229E-4,1.7906E-4,1.6136E-4,1.2514E-4,1.394E-4,1.519E-4,1.8002E-4,1.6145E-4,1.2567E-4,1.3961E-4,1.5252E-4,1.7974E-4,1.6165E-4,1.2599E-4,1.3916E-4,1.5248E-4,1.7856E-4,1.6254E-4,1.2686E-4,1.4039E-4,1.5248E-4,1.7918E-4,1.6108E-4,1.2588E-4,1.3902E-4,1.5242E-4,1.7879E-4,1.6212E-4,1.2606E-4,1.4007E-4,1.5133E-4,1.7834E-4,1.6231E-4,1.2706E-4,1.3841E-4,1.517E-4,1.774E-4,1.6279E-4,1.2755E-4,1.3932E-4,1.5114E-4,1.7855E-4,1.6241E-4,1.2661E-4,1.3854E-4,1.5135E-4,1.7758E-4,1.6271E-4,1.2646E-4,1.3793E-4,1.5101E-4,1.7738E-4,1.6334E-4,1.2696E-4,1.3883E-4,1.5023E-4,1.781E-4,1.6455E-4,1.2719E-4,1.3859E-4,1.5092E-4,1.7775E-4,1.6348E-4,1.2712E-4,1.3766E-4,1.498E-4,1.7803E-4,1.6328E-4,1.2644E-4,1.3911E-4,1.49E-4,1.775E-4,1.6391E-4,1.2684E-4,1.3783E-4,1.4982E-4,1.7671E-4,1.6271E-4,1.2647E-4,1.3687E-4,1.4982E-4,1.7724E-4,1.6474E-4,1.2655E-4,1.3632E-4,1.4948E-4,1.7585E-4,1.6394E-4,1.2707E-4,1.3758E-4,1.4929E-4,1.773E-4,1.6491E-4,1.2779E-4,1.3817E-4,1.4825E-4,1.7573E-4,1.6498E-4,1.2656E-4,1.3611E-4,1.4909E-4,1.7649E-4,1.65E-4,1.2696E-4,1.3733E-4,1.484E-4,1.7602E-4,1.6629E-4,1.2679E-4,1.3665E-4,1.489E-4,1.7591E-4,1.65E-4,1.276E-4,1.3696E-4,1.4901E-4,1.7633E-4,1.6611E-4,1.2774E-4,1.3605E-4,1.4835E-4,1.7573E-4,1.6594E-4,1.2736E-4,1.3687E-4,1.475E-4,1.7379E-4,1.6596E-4,1.2876E-4,1.358E-4,1.483E-4,1.7544E-4,1.6679E-4,1.2785E-4,1.3652E-4,1.4784E-4,1.7432E-4,1.6761E-4,1.2896E-4,1.354E-4,1.4733E-4,1.7446E-4,1.6678E-4,1.2807E-4,1.3544E-4,1.4653E-4,1.743E-4,1.6643E-4,1.2856E-4,1.3495E-4,1.4691E-4,1.7536E-4,1.6673E-4,1.2863E-4,1.3474E-4,1.4773E-4,1.735E-4,1.6818E-4,1.2693E-4,1.3454E-4,1.4564E-4,1.7406E-4,1.6803E-4,1.2903E-4,1.3494E-4,1.4616E-4,1.7398E-4,1.6857E-4,1.2867E-4,1.3464E-4,1.4638E-4,1.7377E-4,1.682E-4,1.2833E-4,1.3327E-4,1.4592E-4,1.7356E-4,1.6842E-4,1.2938E-4,1.3516E-4,1.456E-4,1.7305E-4,1.6828E-4,1.2884E-4,1.3337E-4,1.4572E-4,1.7203E-4,1.6907E-4,1.2871E-4,1.3428E-4,1.4615E-4,1.7165E-4,1.685E-4,1.2857E-4,1.3382E-4,1.4673E-4,1.7171E-4,1.6905E-4,1.2999E-4,1.3391E-4,1.4514E-4,1.7202E-4,1.6912E-4,1.292E-4,1.3406E-4,1.4546E-4,1.7161E-4,7.7497E-5:2
1.0067E-6,1.0433E-6,-1.5667E-7,2.39E-6,1.3833E-6,1.0333E-6,1.1067E-6,1.3667E-7,2.9667E-6,8.8667E-7,1.9767E-6,1.65E-6,-6.8333E-7,2.0367E-6,-5.6667E-8,1.79E-6,1.8033E-6,-3.5E-7,2.8133E-6,2.1767E-6,2.3267E-6,2.8434E-4,3.1619E-4,4.0546E-4,4.439E-4,4.4148E-4,3.6157E-4,3.176E-4,4.0733E-4,4.4487E-4,4.4468E-4,3.6525E-4,3.1856E-4,4.0629E-4,4.4406E-4,4.43E-4,3.6321E-4,3.1842E-4,4.0717E-4,4.467E-4,4.4338E-4,3.6468E-4,3.1788E-4,4.0897E-4,4.4684E-4,4.44E-4,3.6263E-4,3.1739E-4,4.0638E-4,4.4602E-4,4.4319E-4,3.644E-4,3.189E-4,4.0593E-4,4.4644E-4,4.4226E-4,3.6397E-4,3.2065E-4,4.078E-4,4.485E-4,4.4601E-4,3.6616E-4,3.202E-4,4.0816E-4,4.4899E-4,4.4323E-4,3.654E-4,3.2106E-4,4.0963E-4,4.4899E-4,4.4469E-4,3.6353E-4,3.1978E-4,4.0925E-4,4.4923E-4,4.4514E-4,3.6346E-4,3.2047E-4,4.0735E-4,4.4806E-4,4.4296E-4,3.6458E-4,3.2208E-4,4.0855E-4,4.5062E-4,4.4289E-4,3.6285E-4,3.2101E-4,4.0918E-4,4.4961E-4,4.4481E-4,3.6381E-4,3.2035E-4,4.0936E-4,4.5116E-4,4.4325E-4,3.662E-4,3.1981E-4,4.0886E-4,4.5E-4,4.4611E-4,3.6598E-4,3.2176E-4,4.0898E-4,4.5072E-4,4.4304E-4,3.6366E-4,3.2083E-4,4.0994E-4,4.5071E-4,4.4022E-4,3.6312E-4,3.2243E-4,4.1012E-4,4.5132E-4,4.4378E-4,3.6451E-4,3.2234E-4,4.1153E-4,4.5011E-4,4.4396E-4,3.6302E-4,3.2193E-4,4.1128E-4,4.5135E-4,4.3951E-4,3.6284E-4,3.2077E-4,4.0948E-4,4.5083E-4,4.4088E-4,3.6091E-4,3.2174E-4,4.1066E-4,4.5276E-4,4.423E-4,3.628E-4,3.2157E-4,4.1147E-4,4.5364E-4,4.4177E-4,3.6284E-4,3.2051E-4,4.0996E-4,4.5132E-4,4.3911E-4,3.611E-4,3.2186E-4,4.0985E-4,4.513E-4,4.4101E-4,3.6332E-4,3.2107E-4,4.0981E-4,4.5253E-4,4.4436E-4,3.6292E-4,3.2077E-4,4.109E-4,4.5139E-4,4.4302E-4,3.6236E-4,3.2248E-4,4.1122E-4,4.5304E-4,4.3991E-4,3.6091E-4,3.2282E-4,4.1249E-4,4.5209E-4,4.4208E-4,3.6308E-4,3.228E-4,4.1268E-4,4.5149E-4,4.4173E-4,3.6065E-4,3.2142E-4,4.0973E-4,4.5208E-4,4.4131E-4,3.6058E-4,3.2126E-4,4.121E-4,4.526E-4,4.4132E-4,3.6051E-4,3.2252E-4,4.1319E-4,4.5209E-4,4.3964E-4,3.5897E-4,3.2312E-4,4.1037E-4,4.5021E-4,4.3896E-4,3.5988E-4,3.2162E-4,4.1044E-4,4.5193E-4,4.3987E-4,3.5782E-4,3.2009E-4,4.127E-4,4.5171E-4,4.3923E-4,3.5915E-4,3.2284E-4,4.1092E-4,4.5011E-4,4.3819E-4,3.5933E-4,3.2003E-4,4.1216E-4,4.5268E-4,4.4097E-4,3.5837E-4,3.2195E-4,4.1264E-4,4.5178E-4,4.3942E-4,3.6025E-4,3.2137E-4,4.1188E-4,4.5356E-4,4.4005E-4,3.5985E-4,3.2376E-4,4.1392E-4,4.5211E-4,4.39E-4,3.5865E-4,3.2283E-4,4.1322E-4,4.5402E-4,4.3862E-4,3.5788E-4,3.2214E-4,4.1192E-4,4.5371E-4,4.3756E-4,3.5856E-4,3.2247E-4,4.1384E-4,4.5395E-4,4.376E-4,3.5764E-4,3.2283E-4,4.1246E-4,4.5137E-4,4.3824E-4,3.5822E-4,3.2292E-4,4.1404E-4,4.554E-4,4.3786E-4,3.5719E-4,3.2367E-4,4.1144E-4,4.5103E-4,4.3879E-4,3.5404E-4,3.2121E-4,4.1223E-4,4.505E-4,4.3911E-4,3.5783E-4,3.2235E-4,4.1419E-4,4.5574E-4,4.3765E-4,3.5775E-4,3.2271E-4,4.1419E-4,4.5175E-4,4.3605E-4,3.5641E-4,3.2176E-4,4.1292E-4,4.526E-4,4.368E-4,3.5774E-4,3.2486E-4,4.1196E-4,4.54E-4,4.3657E-4,3.5675E-4,3.2414E-4,4.1328E-4,4.5115E-4,4.3909E-4,3.5718E-4,3.2486E-4,4.1597E-4,4.5275E-4,4.3827E-4,3.5614E-4,3.2381E-4,4.1175E-4,4.544E-4,4.3703E-4,3.5508E-4,3.2392E-4,4.1322E-4,4.5403E-4,4.3834E-4,3.5424E-4,3.2319E-4,4.1328E-4,4.5297E-4,4.3558E-4,3.5538E-4,3.2486E-4,4.1476E-4,4.5153E-4,4.3681E-4,3.5512E-4,3.2464E-4,4.1189E-4,4.5062E-4,4.362E-4,3.5467E-4,3.2196E-4,4.1309E-4,4.5339E-4,4.3427E-4,3.5417E-4,3.2255E-4,4.1304E-4,4.5324E-4,4.3435E-4,3.5412E-4,3.2411E-4,4.1377E-4,4.5254E-4,4.3444E-4,3.5372E-4,3.2606E-4,4.1448E-4,4.5415E-4,4.3486E-4,3.5432E-4,3.2268E-4,4.1495E-4,4.5247E-4,4.3417E-4,3.5509E-4,3.2525E-4,4.1278E-4,4.5374E-4,4.3237E-4,3.5335E-4,3.2435E-4,4.1431E-4,4.5311E-4,4.3365E-4,3.5318E-4,3.244E-4,4.1402E-4,4.5143E-4,4.3316E-4,3.5027E-4,3.2364E-4,4.13E-4,4.5072E-4,4.3391E-4,3.5224E-4,3.2472E-4,4.1555E-4,4.5288E-4,4.3163E-4,3.5173E-4,3.2302E-4,4.1388E-4,4.509E-4,4.3279E-4,3.5076E-4,3.2456E-4,4.1492E-4,4.4985E-4,4.3188E-4,3.5077E-4,3.2478E-4,4.1542E-4,4.5255E-4,4.3046E-4,3.5114E-4,3.2405E-4,4.1628E-4,4.5187E-4,4.3046E-4,3.4938E-4,3.2384E-4,4.1402E-4,4.5212E-4,4.2928E-4,3.4928E-4,3.2409E-4,4.1216E-4,4.5253E-4,4.2869E-4,3.4908E-4,3.2296E-4,4.1314E-4,4.5228E-4,4.2991E-4,3.5095E-4,3.2418E-4,4.1294E-4,4.5115E-4,4.296E-4,3.5021E-4,3.2497E-4,4.1428E-4,4.5143E-4,4.2979E-4,3.5012E-4,3.235E-4,4.1457E-4,4.5215E-4,4.2716E-4,3.498E-4,3.2224E-4,2.0976E-4:2
-1.9E-7,2.19E-6,5.8667E-7,2.06E-6,1.4467E-6,6.3333E-8,3.0733E-6,1.6667E-8,3.28E-6,1.07E-6,5.1333E-7,2.6833E-6,-5.9333E-7,2.1367E-6,8.2333E-7,8.8667E-7,2.24E-6,-1.2333E-7,2.3533E-6,2.0E-6,8.4333E-7,2.03E-6,1.1E-7,2.82E-6,1.3133E-6,1.1333E-7,2.3933E-6,3.3E-7,2.712E-4,4.6393E-4,3.4242E-4,3.4674E-4,3.7208E-4,4.5107E-4,4.5502E-4,3.5189E-4,3.3786E-4,3.7714E-4,4.4922E-4,4.5483E-4,3.5201E-4,3.3721E-4,3.7906E-4,4.4904E-4,4.5747E-4,3.5349E-4,3.4075E-4,3.7929E-4,4.4905E-4,4.5494E-4,3.5171E-4,3.363E-4,3.7903E-4,4.486E-4,4.5691E-4,3.5301E-4,3.3771E-4,3.7954E-4,4.4857E-4,4.5471E-4,3.5221E-4,3.3809E-4,3.7881E-4,4.5101E-4,4.5687E-4,3.5312E-4,3.4012E-4,3.7952E-4,4.4716E-4,4.5709E-4,3.5029E-4,3.3853E-4,3.7909E-4,4.491E-4,4.5489E-4,3.531E-4,3.3826E-4,3.791E-4,4.4769E-4,4.5337E-4,3.5226E-4,3.3842E-4,3.7907E-4,4.506E-4,4.5626E-4,3.5119E-4,3.3791E-4,3.8017E-4,4.503E-4,4.5749E-4,3.535E-4,3.3995E-4,3.8055E-4,4.5138E-4,4.5976E-4,3.5346E-4,3.418E-4,3.8198E-4,4.5334E-4,4.5897E-4,3.5306E-4,3.4034E-4,3.8118E-4,4.5137E-4,4.5969E-4,3.5169E-4,3.3921E-4,3.8147E-4,4.516E-4,4.5972E-4,3.5321E-4,3.4047E-4,3.8185E-4,4.5309E-4,4.5931E-4,3.5376E-4,3.4137E-4,3.8214E-4,4.5225E-4,4.5986E-4,3.5457E-4,3.4252E-4,3.8244E-4,4.5111E-4,4.5865E-4,3.5224E-4,3.3847E-4,3.8058E-4,4.4906E-4,4.572E-4,3.4971E-4,3.397E-4,3.7879E-4,4.5136E-4,4.5587E-4,3.4905E-4,3.3811E-4,3.8256E-4,4.5201E-4,4.5759E-4,3.5072E-4,3.371E-4,3.8085E-4,4.4906E-4,4.5664E-4,3.4904E-4,3.3883E-4,3.7927E-4,4.4937E-4,4.5707E-4,3.4978E-4,3.3835E-4,3.8035E-4,4.489E-4,4.5503E-4,3.5032E-4,3.3717E-4,3.8144E-4,4.5014E-4,4.5729E-4,3.5043E-4,3.3855E-4,3.8319E-4,4.4892E-4,4.5639E-4,3.4953E-4,3.3927E-4,3.8047E-4,4.4944E-4,4.5772E-4,3.5024E-4,3.3931E-4,3.8179E-4,4.5055E-4,4.5834E-4,3.5031E-4,3.404E-4,3.8154E-4,4.5329E-4,4.5998E-4,3.5064E-4,3.3905E-4,3.8125E-4,4.5098E-4,4.5724E-4,3.5015E-4,3.3863E-4,3.8088E-4,4.5037E-4,4.5614E-4,3.4807E-4,3.4025E-4,3.8169E-4,4.4959E-4,4.5791E-4,3.489E-4,3.363E-4,3.7935E-4,4.4819E-4,4.5639E-4,3.4793E-4,3.3687E-4,3.7946E-4,4.4976E-4,4.5383E-4,3.4502E-4,3.3783E-4,3.808E-4,4.467E-4,4.5423E-4,3.491E-4,3.3639E-4,3.7854E-4,4.4821E-4,4.5544E-4,3.4619E-4,3.3741E-4,3.7991E-4,4.4832E-4,4.5411E-4,3.4771E-4,3.3793E-4,3.8179E-4,4.4899E-4,4.5681E-4,3.5005E-4,3.3787E-4,3.8187E-4,4.5164E-4,4.5791E-4,3.4701E-4,3.3943E-4,3.8143E-4,4.4961E-4,4.5759E-4,3.4716E-4,3.3906E-4,3.8264E-4,4.4892E-4,4.5747E-4,3.4784E-4,3.3918E-4,3.817E-4,4.5014E-4,4.5691E-4,3.4683E-4,3.3658E-4,3.8028E-4,4.4799E-4,4.5611E-4,3.4567E-4,3.368E-4,3.8014E-4,4.4658E-4,4.5362E-4,3.4557E-4,3.36E-4,3.8021E-4,4.4936E-4,4.5581E-4,3.4482E-4,3.3641E-4,3.8128E-4,4.4717E-4,4.5663E-4,3.4574E-4,3.3656E-4,3.804E-4,4.4839E-4,4.5461E-4,3.4655E-4,3.3793E-4,3.8304E-4,4.478E-4,4.5689E-4,3.4495E-4,3.3982E-4,3.836E-4,4.4963E-4,4.5692E-4,3.4736E-4,3.3853E-4,3.8236E-4,4.5049E-4,4.5724E-4,3.4717E-4,3.4001E-4,3.8479E-4,4.4938E-4,4.5568E-4,3.4736E-4,3.3944E-4,3.8258E-4,4.4999E-4,4.564E-4,3.4637E-4,3.3606E-4,3.8294E-4,4.4853E-4,4.539E-4,3.4594E-4,3.3835E-4,3.7974E-4,4.4786E-4,4.5455E-4,3.4382E-4,3.3682E-4,3.8205E-4,4.4782E-4,4.5485E-4,3.4309E-4,3.3746E-4,3.8107E-4,4.4823E-4,4.534E-4,3.4323E-4,3.3679E-4,3.8225E-4,4.4829E-4,4.531E-4,3.4431E-4,3.362E-4,3.8225E-4,4.4624E-4,4.5399E-4,3.4541E-4,3.3821E-4,3.8086E-4,4.4903E-4,4.5419E-4,3.4297E-4,3.3901E-4,3.8238E-4,4.4752E-4,4.5584E-4,3.4355E-4,3.3759E-4,3.8141E-4,4.4619E-4,4.5559E-4,3.4323E-4,3.3711E-4,3.8248E-4,4.4773E-4,4.5426E-4,3.4404E-4,3.3793E-4,3.8186E-4,4.4738E-4,4.5431E-4,3.4444E-4,3.3586E-4,3.8237E-4,4.4813E-4,4.5506E-4,3.4214E-4,3.3741E-4,3.8207E-4,4.4858E-4,4.534E-4,3.4343E-4,3.3683E-4,3.8221E-4,4.4739E-4,4.5231E-4,3.4233E-4,3.3538E-4,3.8136E-4,4.4605E-4,4.5089E-4,3.416E-4,3.3571E-4,3.7971E-4,4.4798E-4,4.5179E-4,3.418E-4,3.3715E-4,3.8034E-4,4.4942E-4,4.5273E-4,3.4346E-4,3.3696E-4,3.8162E-4,4.455E-4,4.5365E-4,3.4329E-4,3.3608E-4,3.8028E-4,4.4734E-4,4.52E-4,3.4131E-4,3.3608E-4,3.8128E-4,4.4826E-4,4.5293E-4,3.4063E-4,3.1205E-4:2
-2.41E-5,-2.0273E-5,-2.3037E-5,-2.9547E-5,-3.1713E-5,-2.425E-5,-2.053E-5,-2.3637E-5,-2.7713E-5,-3.274E-5,-2.4247E-5,-2.1397E-5,-2.497E-5,-2.77E-5,-3.337E-5,-2.396E-5,-1.9987E-5,-2.263E-5,-2.982E-5,-3.2887E-5,-2.4653E-5,-2.0023E-5,-2.306E-5,-2.8047E-5,-3.2457E-5,-2.364E-5,-2.074E-5,-2.2697E-5,-2.901E-5,-3.21E-5,-2.3743E-5,-2.1087E-5,-2.2627E-5,-2.8533E-5,7.8365E-4,0.0010669,9.7352E-4,0.0012981,0.0013509,0.0011595,0.0010325,0.0010083,0.0012794,0.0013492,0.0011757,0.0010248,0.0010191,0.0012688,0.0013473,0.0011794,0.0010202,0.0010212,0.0012663,0.0013551,0.0011834,0.0010194,0.0010187,0.0012649,0.0013536,0.0011888,0.0010215,0.0010205,0.001264,0.0013509,0.0011878,0.0010197,0.0010113,0.0012585,0.0013532,0.0011898,0.0010225,0.0010136,0.0012581,0.0013506,0.0011898,0.0010248,0.001009,0.0012526,0.0013549,0.0011965,0.0010225,0.0010096,0.0012507,0.0013532,0.0011953,0.0010222,0.0010047,0.0012486,0.0013514,0.0011995,0.001025,0.0010021,0.0012449,0.0013503,0.001201,0.0010246,0.0010008,0.0012424,0.0013517,0.0012039,0.0010283,0.0010014,0.0012359,0.0013461,0.001204,0.0010269,9.9266E-4,0.0012331,0.0013481,0.0012088,0.0010287,9.9364E-4,0.001231,0.0013502,0.0012093,0.0010293,9.9429E-4,0.0012265,0.0013436,0.0012095,0.0010306,9.881E-4,0.0012257,0.0013476,0.00121,0.0010324,9.8403E-4,0.001222,0.0013435,0.0012123,0.0010301,9.8648E-4,0.0012167,0.0013425,0.0012137,0.001027,7.6587E-4,9.1123E-4,9.9721E-4,8.7198E-4,7.3054E-4,7.3531E-4,9.1136E-4,9.964E-4,8.6898E-4,7.3797E-4,7.2943E-4,9.1227E-4,9.9561E-4,8.7001E-4,7.3743E-4,7.277E-4,9.108E-4,9.9474E-4,8.6902E-4,7.4073E-4,7.2562E-4,9.0721E-4,9.9505E-4,8.721E-4,7.3992E-4,7.2631E-4,9.038E-4,9.9439E-4,8.7187E-4,7.3845E-4,7.2162E-4,9.0348E-4,9.9374E-4,8.7073E-4,7.4075E-4,7.2078E-4,8.9848E-4,9.9268E-4,8.7341E-4,7.4024E-4,7.1895E-4,8.9578E-4,9.918E-4,8.7658E-4,7.4028E-4,7.1739E-4,8.9476E-4,9.9339E-4,8.7614E-4,7.4377E-4,7.1343E-4,8.9063E-4,9.9301E-4,8.7554E-4,7.4106E-4,7.1249E-4,8.9243E-4,9.9063E-4,8.7704E-4,7.4131E-4,7.1228E-4,8.8594E-4,9.9276E-4,8.7824E-4,7.3925E-4,7.0864E-4,8.8313E-4,9.8704E-4,8.7986E-4,7.4164E-4,7.0868E-4,8.81E-4,9.8822E-4,8.8427E-4,7.4341E-4,7.0742E-4,8.7911E-4,9.8591E-4,8.8329E-4,7.4351E-4,7.0574E-4,8.7582E-4,9.9073E-4,8.8561E-4,7.4669E-4,7.0772E-4,8.7427E-4,9.8663E-4,8.8573E-4,7.4471E-4,7.0404E-4,8.7203E-4,9.8825E-4,8.871E-4,7.483E-4,7.0203E-4,8.6964E-4,9.8658E-4,8.8824E-4,7.4751E-4,7.0204E-4,8.6624E-4,9.8662E-4,8.8916E-4,7.4749E-4,7.0001E-4,8.6358E-4,9.8746E-4,8.9119E-4,7.5089E-4,6.9817E-4,8.5989E-4,9.8357E-4,8.9053E-4,7.5184E-4,6.9328E-4,8.5953E-4,9.8732E-4,8.9194E-4,7.5386E-4,6.96E-4,8.5915E-4,9.8453E-4,8.939E-4,7.5373E-4,6.9229E-4,8.5482E-4,9.8135E-4,8.9336E-4,7.5225E-4,6.917E-4,8.5362E-4,9.7733E-4,8.9257E-4,7.5556E-4,6.893E-4,8.5108E-4,9.7656E-4,8.9491E-4,7.5718E-4,6.9074E-4,8.4826E-4,9.7719E-4,8.9602E-4,7.5788E-4,6.8804E-4,8.4776E-4,9.7633E-4,8.9789E-4,7.5761E-4,6.8634E-4,8.4476E-4,9.77E-4,8.9999E-4,7.5985E-4,6.8668E-4,8.4343E-4,9.7543E-4,9.0052E-4,7.5995E-4,6.8573E-4,8.3832E-4,9.7455E-4,9.0063E-4,7.5991E-4,6.8376E-4,8.3731E-4,9.7396E-4,9.0358E-4,7.6479E-4,6.8376E-4,8.383E-4,9.7453E-4,9.0513E-4,7.6403E-4,6.814E-4,8.327E-4,9.7163E-4,9.0515E-4,7.6531E-4,6.8439E-4,8.3206E-4,9.7141E-4,9.0614E-4,7.6854E-4,6.7922E-4,8.3038E-4,9.6933E-4,9.0664E-4,7.7092E-4,6.7967E-4,8.283E-4,9.6805E-4,9.0751E-4,7.6821E-4,6.7864E-4,8.2692E-4,9.7074E-4,9.1054E-4,7.7245E-4,6.7923E-4,8.2722E-4,9.6747E-4,9.1277E-4,7.7139E-4,6.737E-4,8.2269E-4,9.6684E-4,9.1026E-4,7.7461E-4,6.7634E-4,8.196E-4,9.6661E-4,9.1336E-4,7.7558E-4,6.776E-4,8.19E-4,9.6476E-4,9.1584E-4,7.7693E-4,6.7472E-4,8.1591E-4,9.605E-4,9.1679E-4,7.7805E-4,6.7188E-4,8.1628E-4,9.6341E-4,9.1511E-4,7.8209E-4,6.7195E-4,8.1324E-4,9.5986E-4,9.1596E-4,7.8254E-4,6.7027E-4,8.1262E-4,9.5983E-4,9.2183E-4,7.8198E-4,6.7146E-4,8.1034E-4,9.5983E-4,9.182E-4,7.8657E-4,6.6979E-4,8.0776E-4,9.585E-4,9.2067E-4,7.8567E-4,6.7144E-4,8.0777E-4,9.5421E-4,9.2084E-4,7.8768E-4,6.689E-4,8.0409E-4,9.5238E-4,9.2208E-4,7.8905E-4,6.6921E-4,8.0497E-4,9.5065E-4,9.2328E-4,7.9058E-4,6.6565E-4,8.0069E-4,9.4755E-4,9.2544E-4,7.9489E-4,6.6749E-4,8.0334E-4,9.4858E-4,9.2343E-4,7.9329E-4,6.6457E-4,7.981E-4,9.4719E-4,9.2749E-4,7.9471E-4,6.6667E-4,7.9524E-4,9.4715E-4,9.2772E-4,8.0031E-4,6.6643E-4,7.968E-4,9.4404E-4,9.3028E-4,7.9961E-4,6.6739E-4,7.959E-4,9.4553E-4,9.2946E-4,7.9964E-4,6.6391E-4,7.9478E-4,9.4391E-4,9.2834E-4,8.0456E-4,6.666E-4,7.9427E-4,9.4391E-4,9.2943E-4,8.0623E-4,6.6384E-4,7.9066E-4,9.4143E-4,9.2912E-4,8.0951E-4,6.6522E-4,7.9011E-4,9.3723E-4,9.3171E-4,8.1112E-4,6.6276E-4,7.8908E-4,9.386E-4,9.3532E-4,8.1075E-4,6.6517E-4,7.8773E-4,9.349E-4,9.3682E-4,0.0:2
-3.3673E-5,-2.054E-5,-2.058E-5,-2.352E-5,-3.0093E-5,-3.475E-5,-2.0987E-5,-2.2067E-5,-2.3843E-5,-3.1327E-5,-3.308E-5,-2.0807E-5,-2.0413E-5,-2.2753E-5,-3.0743E-5,-3.381E-5,-2.1857E-5,-2.0443E-5,-2.3027E-5,-2.9487E-5,-3.393E-5,-2.174E-5,-2.049E-5,-2.2707E-5,-3.0253E-5,-3.4497E-5,-2.1023E-5,-2.0827E-5,-2.2847E-5,-2.9803E-5,-3.3793E-5,-2.196E-5,-2.0497E-5,-2.2563E-5,-3.0783E-5,-3.4697E-5,-2.271E-5,5.5017E-5,0.0013293,0.0012761,0.0011587,8.9436E-4,0.0011093,0.0012599,0.0012843,0.0011315,9.24E-4,0.0010875,0.0012623,0.0012897,0.0011285,9.274E-4,0.0010821,0.0012663,0.0012884,0.0011336,9.2825E-4,0.0010758,0.0012587,0.0012898,0.0011351,9.3195E-4,0.001076,0.0012616,0.0012924,0.0011385,9.27E-4,0.0010753,0.0012553,0.0012915,0.001136,9.2826E-4,0.001072,0.0012547,0.0012963,0.0011404,9.279E-4,0.0010671,0.0012527,0.0012954,0.0011449,9.268E-4,0.0010636,0.0012488,0.0012966,0.0011479,9.2987E-4,0.0010635,0.0012454,0.0012969,0.0011475,9.2653E-4,0.0010595,0.0012467,0.0012928,0.0011516,9.3136E-4,0.0010595,0.0012436,0.0012965,0.0011565,9.2939E-4,0.0010577,0.0012405,0.0012979,0.0011558,9.3012E-4,0.0010544,0.0012366,0.0012947,0.0011574,9.2951E-4,0.0010539,0.001232,0.0012939,0.001161,9.2647E-4,0.001046,0.0012274,0.0012967,0.0011581,9.2997E-4,0.0010486,0.0012251,0.0012986,0.0011655,9.3156E-4,0.0010446,0.0012222,0.0012975,0.0011651,9.3029E-4,0.0010412,0.0012183,0.0012977,0.0011699,9.2902E-4,0.0010412,0.0012134,0.0012972,0.0011649,9.2926E-4,0.0010358,0.0012111,0.0012943,0.001172,9.2814E-4,0.0010311,0.001206,0.001295,0.0011737,9.2457E-4,0.0010298,0.0012033,0.0012934,0.0011743,9.2801E-4,0.0010285,0.0011964,0.0012915,0.0011735,9.2501E-4,0.0010254,0.0011946,0.0012938,0.0011766,9.274E-4,0.0010235,0.0011924,0.0012958,0.0011768,9.2801E-4,0.0010195,0.001188,0.0012877,0.0011786,9.2821E-4,0.0010168,0.0011837,0.0012894,0.0011807,9.2895E-4,0.0010143,0.0011756,0.0012889,0.0011812,9.2805E-4,0.0010137,0.001173,0.0012885,0.0011818,9.2458E-4,0.0010089,0.0011665,0.0012888,0.0011794,9.265E-4,0.0010051,0.0011617,0.0012903,0.0011855,9.2996E-4,0.0010044,0.0011607,0.0012852,0.0011839,9.2872E-4,0.0010025,0.0011534,0.0012849,0.0011857,9.2773E-4,9.9676E-4,0.0011542,0.0012836,0.0011851,9.2825E-4,9.9411E-4,0.0011467,0.0012824,0.0011881,9.2943E-4,9.9288E-4,0.0011473,0.00128,0.0011869,9.2834E-4,9.9238E-4,0.0011421,0.0012805,0.0011908,9.3225E-4,9.8589E-4,0.0011417,0.0012745,0.0011922,9.3066E-4,9.8627E-4,0.0011372,0.0012783,0.001193,9.3002E-4,9.8647E-4,0.0011306,0.0012784,0.0011899,9.317E-4,9.8256E-4,0.0011279,0.0012763,0.0011912,9.3101E-4,9.8053E-4,0.0011223,0.0012755,0.0011931,9.3342E-4,9.7669E-4,0.0011161,0.0012771,0.0011956,9.3312E-4,9.7595E-4,0.0011147,0.0012758,0.0011962,9.3637E-4,9.7493E-4,0.0011122,0.0012748,0.0011957,9.3584E-4,9.685E-4,0.0011089,0.0012705,0.0011956,9.3963E-4,9.6907E-4,0.001104,0.001269,0.0011967,9.3895E-4,9.6742E-4,0.0011027,0.0012673,0.0012004,9.39E-4,9.6376E-4,0.0010991,0.0012695,0.0011986,9.4022E-4,9.6188E-4,0.0010915,0.0012665,0.0012042,9.3903E-4,9.6149E-4,0.0010888,0.0012656,0.0012059,9.4192E-4,9.5778E-4,0.0010862,0.0012625,0.0012071,9.4371E-4,9.5894E-4,0.0010774,0.0012626,0.0012074,9.4516E-4,9.5497E-4,0.0010757,0.0012614,0.0012066,9.4377E-4,9.5641E-4,0.0010754,0.0012624,0.0012084,9.4866E-4,9.552E-4,0.0010693,0.0012591,0.0012089,9.5118E-4,9.5026E-4,0.0010651,0.001259,0.0012093,9.507E-4,9.4898E-4,0.0010597,0.0012578,0.0012128,9.5329E-4,9.4885E-4,0.0010612,0.0012565,0.0012103,9.5251E-4,9.4879E-4,0.0010554,0.0012514,0.0012147,9.5777E-4,9.4498E-4,0.0010531,0.0012512,0.0012172,9.5737E-4,9.4615E-4,0.0010481,0.0012485,0.0012149,9.5942E-4,9.4432E-4,0.0010469,0.0012465,0.0012179,9.6205E-4,9.4187E-4,0.001044,0.0012494,0.0012195,9.6468E-4,9.4269E-4,0.0010361,0.0012462,0.0012185,9.6615E-4,9.4042E-4,4.7927E-4:2
-2.99E-5,-3.1593E-5,-2.72E-5,-2.2347E-5,-1.544E-5,-3.036E-5,-3.182E-5,-2.7143E-5,-2.3103E-5,-1.4633E-5,-3.055E-5,-3.1673E-5,-2.582E-5,-2.4343E-5,-1.473E-5,-2.9017E-5,-3.1873E-5,-2.8203E-5,-2.3967E-5,-1.457E-5,-2.989E-5,-3.0853E-5,-2.7977E-5,-2.4817E-5,-1.5153E-5,-2.8523E-5,-2.9983E-5,-2.8347E-5,-2.4427E-5,-1.367E-5,-3.1793E-5,-3.1397E-5,-2.7597E-5,-2.502E-5,-1.3577E-5,-2.8823E-5,-2.9943E-5,-2.752E-5,-2.4843E-5,-1.3747E-5,-2.997E-5,-3.0013E-5,-2.8293E-5,-2.455E-5,-1.5183E-5,5.1888E-4,0.0013333,9.6123E-4,0.0010397,0.0010833,0.0013201,0.0012749,9.9689E-4,0.001002,0.0011058,0.0013113,0.0012772,0.0010085,9.9591E-4,0.0011014,0.001309,0.0012773,0.0010133,9.9134E-4,0.0011003,0.0013061,0.0012804,0.0010177,9.9038E-4,0.0010981,0.0013046,0.0012812,0.0010185,9.8963E-4,0.0010918,0.0013006,0.0012852,0.0010194,9.8383E-4,0.0010852,0.0013002,0.0012869,0.0010246,9.8822E-4,0.0010841,0.0013003,0.0012915,0.00103,9.855E-4,0.0010764,0.0012989,0.0012881,0.0010318,9.8477E-4,0.0010699,0.0013009,0.0012864,0.0010356,9.8419E-4,0.0010669,0.0012961,0.0012949,0.0010399,9.841E-4,0.0010654,0.0012944,0.001288,0.0010427,9.7976E-4,0.0010617,0.0012889,0.0012895,0.0010434,9.7756E-4,0.0010551,0.0012849,0.0012894,0.0010476,9.7663E-4,0.0010496,0.0012816,0.0012963,0.0010495,9.7321E-4,0.0010497,0.00128,0.0012935,0.0010576,9.7447E-4,0.0010418,0.0012741,0.0012981,0.0010583,9.7611E-4,0.0010379,0.0012746,0.001297,0.0010632,9.7367E-4,0.0010358,0.0012666,0.0012976,0.0010656,9.7529E-4,0.0010274,0.0012671,0.0012968,0.0010692,9.7473E-4,0.001024,0.001266,0.0012997,0.0010733,9.7304E-4,0.0010239,0.0012612,0.0012959,0.0010738,9.7194E-4,0.0010181,0.0012598,0.0012956,0.0010827,9.6927E-4,0.0010163,0.0012531,0.0012972,0.001082,9.6915E-4,0.0010091,0.0012472,0.0012986,0.0010837,9.6838E-4,0.0010056,0.001245,0.0012926,0.0010875,9.6958E-4,0.0010005,0.0012402,0.0012937,0.0010898,9.7027E-4,9.9869E-4,0.0012309,0.0012968,0.0010927,9.6869E-4,9.9401E-4,0.0012315,0.0012952,0.0010976,9.6713E-4,9.8918E-4,0.0012239,0.0012949,0.0010973,9.6558E-4,9.8574E-4,0.0012225,0.0012942,0.0011026,9.6886E-4,9.8153E-4,0.0012149,0.0012914,0.0011031,9.681E-4,9.8027E-4,0.0012135,0.0012914,0.0011071,9.6711E-4,9.6963E-4,0.0012079,0.0012911,0.001111,9.6434E-4,9.7083E-4,0.001208,0.0012846,0.001113,9.6446E-4,9.6614E-4,0.0012011,0.0012853,0.0011155,9.6721E-4,9.66E-4,0.0011989,0.0012852,0.0011176,9.6517E-4,9.5952E-4,0.0011878,0.001286,0.0011201,9.6768E-4,9.539E-4,0.0011865,0.0012835,0.0011222,9.6533E-4,9.5429E-4,0.0011827,0.0012874,0.0011272,9.6697E-4,9.4981E-4,0.0011804,0.0012852,0.0011251,9.6744E-4,9.4741E-4,0.0011722,0.001283,0.0011325,9.6851E-4,9.4588E-4,0.0011685,0.0012808,0.0011324,9.6742E-4,9.4131E-4,0.0011657,0.0012782,0.0011395,9.7094E-4,9.3796E-4,0.0011591,0.0012804,0.0011401,9.7127E-4,9.3639E-4,0.0011531,0.001277,0.0011451,9.7695E-4,9.3041E-4,0.0011513,0.0012735,0.0011408,9.7592E-4,9.3134E-4,0.0011473,0.0012736,0.0011471,9.753E-4,9.2747E-4,0.0011438,0.0012733,0.0011487,9.7865E-4,9.2665E-4,0.0011384,0.0012711,0.001151,9.8007E-4,9.2121E-4,0.0011373,0.0012714,0.0011508,9.8027E-4,9.1924E-4,0.0011307,0.0012677,0.0011596,9.8509E-4,9.138E-4,0.001126,0.0012669,0.0011607,9.8608E-4,9.1239E-4,0.0011224,0.0012684,0.0011597,9.8472E-4,9.1546E-4,0.0011157,0.0012638,0.0011604,9.9126E-4,9.1129E-4,0.0011119,0.0012631,0.0011648,9.9073E-4,9.0896E-4,0.0011099,0.0012632,0.0011674,9.9516E-4,9.0642E-4,0.0011061,0.0012607,0.0011678,9.9388E-4,9.0327E-4,0.0011,0.0012582,0.0011746,9.9738E-4,8.9804E-4,0.0010981,0.0012517,0.0011717,9.9895E-4,9.0089E-4,0.0010939,0.0012535,0.0011791,0.0010019,8.9744E-4,0.0010853,0.0012539,0.0011798,0.0010029,8.9431E-4,0.0010842,0.0012496,0.0011846,0.0010046,8.9901E-4,0.00108,0.0012494,0.0011815,0.0010083,8.9373E-4,0.0010748,0.0012466,0.0011833,0.0010103,8.9078E-4,0.0010699,0.0012416,0.0011852,0.0010124,8.8914E-4,0.0010672,0.0012419,0.00119,0.0010155,8.8927E-4,0.0010672,0.0012382,0.0011916,0.0010232,8.8556E-4,0.0010633,0.0012362,0.0011952,0.0010222,8.8368E-4,0.0010588,0.0012329,0.0011978,0.0010236,8.849E-4,0.0010568,0.0012281,0.0012007,0.0010301,8.8316E-4,0.0010525,0.0012285,0.0012045,0.0010331,8.808E-4,0.0010463,0.0012257,0.0012037,0.0010325,8.8105E-4,0.0010439,0.0012185,0.0012086,0.0010404,8.8135E-4,0.0010409,0.0012231,0.0012087,0.0010394,8.8472E-4,0.0010388,0.0012204,0.0012082,0.0010434,8.8001E-4,0.0010337,0.0012166,0.0012097,0.0010481,8.7927E-4,0.0010319,0.0012152,0.0012104,0.0010522,8.7862E-4,0.0010302,0.0012086,0.0012157,1.3703E-4:2
-6.6333E-7,1.5467E-6,8.8E-7,-2.5067E-6,1.7533E-6,-2.6333E-7,6.0E-8,1.44E-6,-4.0E-8,3.01E-6,4.5E-7,8.3E-7,8.5333E-7,-1.6133E-6,2.1233E-6,-1.52E-6,9.6667E-7,7.4667E-7,-1.3033E-6,1.6833E-6,-5.8E-7,8.8333E-7,1.6567E-6,-1.73E-6,2.2767E-6,-8.8667E-7,-5.9667E-7,7.7766E-4,8.8398E-4,3.3989E-4,7.0023E-4,6.7319E-4,7.0041E-4,7.1489E-4,3.8926E-4,6.2584E-4,6.5659E-4,7.4274E-4,6.6425E-4,4.4232E-4,5.9857E-4,6.6595E-4,7.578E-4,6.5128E-4,4.6135E-4,5.8716E-4,6.6714E-4,7.6006E-4,6.4905E-4,4.6516E-4,5.831E-4,6.6869E-4,7.6447E-4,6.4828E-4,4.6989E-4,5.8089E-4,6.6491E-4,7.6191E-4,6.496E-4,4.7224E-4,5.7675E-4,6.6166E-4,7.6207E-4,6.5189E-4,4.732E-4,5.7426E-4,6.5888E-4,7.6285E-4,6.559E-4,4.7235E-4,5.7365E-4,6.5979E-4,7.6196E-4,6.5396E-4,4.7114E-4,5.6739E-4,6.5621E-4,7.6127E-4,6.5763E-4,4.7469E-4,5.6704E-4,6.5404E-4,7.5863E-4,6.579E-4,4.7467E-4,5.6049E-4,6.5121E-4,7.5816E-4,6.6087E-4,4.7769E-4,5.5757E-4,6.4716E-4,7.5757E-4,6.6157E-4,4.7731E-4,5.5477E-4,6.4436E-4,7.5231E-4,6.6152E-4,4.7988E-4,5.5361E-4,6.4183E-4,7.4844E-4,6.6666E-4,4.8039E-4,5.4777E-4,6.3787E-4,7.4744E-4,6.6624E-4,4.8074E-4,5.4751E-4,6.3678E-4,7.474E-4,6.6916E-4,4.7985E-4,5.4173E-4,6.3344E-4,7.4589E-4,6.665E-4,4.8379E-4,5.3852E-4,6.3088E-4,7.4146E-4,6.7126E-4,4.8115E-4,5.3501E-4,6.2757E-4,7.3986E-4,6.7085E-4,4.8684E-4,5.3355E-4,6.2206E-4,7.4057E-4,6.7437E-4,4.8538E-4,5.2922E-4,6.2467E-4,7.3778E-4,6.7364E-4,4.874E-4,5.2684E-4,6.1907E-4,7.3437E-4,6.7499E-4,4.8934E-4,5.2548E-4,6.1636E-4,7.3596E-4,6.7579E-4,4.8981E-4,5.2429E-4,6.1705E-4,7.3502E-4,6.7736E-4,4.9069E-4,5.2197E-4,6.143E-4,7.3134E-4,6.8194E-4,4.929E-4,5.1778E-4,6.1165E-4,7.3254E-4,6.8288E-4,4.9677E-4,5.1635E-4,6.0863E-4,7.286E-4,6.8462E-4,4.9726E-4,5.1158E-4,6.0549E-4,7.2563E-4,6.8353E-4,4.9762E-4,5.0941E-4,6.0215E-4,7.2586E-4,6.8643E-4,5.02E-4,5.1037E-4,6.006E-4,7.2055E-4,6.8823E-4,5.0618E-4,5.0855E-4,6.0051E-4,7.2383E-4,6.9006E-4,5.0698E-4,5.0685E-4,5.9459E-4,7.2091E-4,6.9131E-4,5.0745E-4,5.0128E-4,5.9483E-4,7.1997E-4,6.9391E-4,5.1074E-4,5.0222E-4,5.9218E-4,7.1729E-4,6.9603E-4,5.1202E-4,5.0213E-4,5.8942E-4,7.1763E-4,6.9593E-4,5.1512E-4,5.0101E-4,5.8626E-4,7.1376E-4,6.959E-4,5.171E-4,4.9745E-4,5.8434E-4,7.1246E-4,6.9627E-4,5.1946E-4,4.9751E-4,5.8224E-4,7.1093E-4,6.9887E-4,5.228E-4,4.9629E-4,5.7969E-4,7.1201E-4,6.9794E-4,5.2619E-4,4.9355E-4,5.7824E-4,7.0978E-4,7.0216E-4,5.2737E-4,4.9206E-4,5.7236E-4,7.093E-4,6.9996E-4,5.3086E-4,4.9081E-4,5.7047E-4,7.0504E-4,6.9827E-4,5.3098E-4,4.8978E-4,5.6954E-4,7.0529E-4,7.0218E-4,5.3551E-4,4.9008E-4,5.6776E-4,7.0277E-4,7.0434E-4,5.4011E-4,4.8822E-4,5.648E-4,6.9804E-4,7.0335E-4,5.4208E-4,4.8801E-4,5.642E-4,6.9847E-4,7.0552E-4,5.4086E-4,4.8475E-4,5.6258E-4,6.9695E-4,7.0533E-4,5.4487E-4,4.8638E-4,5.5832E-4,6.9655E-4,7.0867E-4,5.4827E-4,4.85E-4,5.5588E-4,6.9515E-4,7.0982E-4,5.5177E-4,4.8463E-4,5.5489E-4,6.9391E-4,7.1291E-4,5.5431E-4,4.853E-4,5.5309E-4,6.9334E-4,7.0864E-4,5.5854E-4,4.8433E-4,5.4977E-4,6.8977E-4,7.1082E-4,5.6044E-4,4.8501E-4,5.4863E-4,6.8696E-4,7.0856E-4,5.6593E-4,4.8151E-4,5.465E-4,6.8772E-4,7.109E-4,5.6929E-4,4.8255E-4,5.4223E-4,6.8313E-4,7.1215E-4,5.7221E-4,4.8483E-4,5.396E-4,6.8524E-4,7.0828E-4,5.7101E-4,4.8342E-4,5.3982E-4,6.8328E-4,7.104E-4,5.774E-4,4.8396E-4,5.3621E-4,6.813E-4,7.1487E-4,5.8015E-4,4.8263E-4,5.3462E-4,6.7981E-4,7.1102E-4,5.8301E-4,4.8282E-4,5.3099E-4,6.7742E-4,7.1553E-4,5.8591E-4,4.832E-4,5.2894E-4,6.7591E-4,7.1432E-4,5.9053E-4,4.8189E-4,5.2683E-4,6.7485E-4,7.1273E-4,5.9275E-4,4.8414E-4,5.2417E-4,6.7281E-4,7.1184E-4,5.9846E-4,4.846E-4,5.2192E-4,6.6977E-4,7.1285E-4,5.9878E-4,4.8419E-4,5.1988E-4,6.7188E-4,7.1381E-4,6.06E-4,4.8435E-4,5.179E-4,6.6996E-4,7.1461E-4,6.0646E-4,4.8398E-4,5.1129E-4:2
5.3333E-8,1.07E-6,-1.13E-6,1.9967E-6,-9.8333E-7,1.5633E-6,3.5667E-7,-8.9667E-7,1.45E-6,-1.1033E-6,1.3033E-6,1.9E-6,4.5333E-7,1.5667E-6,-1.7667E-7,1.8633E-6,9.3667E-7,-5.5E-7,1.5133E-6,-3.5E-7,1.6633E-6,1.0733E-6,-1.7033E-6,1.4767E-6,-1.4433E-6,1.48E-6,7.9333E-7,-1.0333E-7,1.5033E-6,-8.5E-7,1.1067E-6,-3.3334E-9,-1.9E-7,1.9067E-6,-1.5E-7,4.1E-7,1.6033E-6,-1.1367E-6,1.87E-6,-3.0333E-7,4.0669E-4,7.151E-4,7.6705E-4,5.7868E-4,5.2462E-4,5.3995E-4,7.2411E-4,7.5137E-4,5.9335E-4,5.1062E-4,5.5361E-4,7.2084E-4,7.4882E-4,6.0073E-4,5.0437E-4,5.5514E-4,7.1732E-4,7.4258E-4,6.0436E-4,5.0136E-4,5.5716E-4,7.1886E-4,7.4346E-4,6.044E-4,5.0108E-4,5.546E-4,7.1405E-4,7.4347E-4,6.0747E-4,4.9826E-4,5.5623E-4,7.1621E-4,7.4159E-4,6.0853E-4,5.0015E-4,5.5314E-4,7.1161E-4,7.4259E-4,6.0649E-4,5.0133E-4,5.5347E-4,7.0997E-4,7.4272E-4,6.0633E-4,4.9862E-4,5.5157E-4,7.0967E-4,7.4027E-4,6.0178E-4,4.982E-4,5.5518E-4,7.0967E-4,7.407E-4,6.0741E-4,4.9736E-4,5.4895E-4,7.0747E-4,7.3923E-4,6.046E-4,4.9515E-4,5.468E-4,7.0436E-4,7.3776E-4,6.0544E-4,4.9786E-4,5.4762E-4,7.0454E-4,7.3541E-4,6.0588E-4,4.9667E-4,5.4558E-4,7.0299E-4,7.3666E-4,6.006E-4,4.9327E-4,5.4242E-4,6.979E-4,7.3335E-4,6.0336E-4,4.9576E-4,5.4351E-4,6.9755E-4,7.3051E-4,6.0503E-4,4.9312E-4,5.4164E-4,6.9527E-4,7.313E-4,6.0305E-4,4.9187E-4,5.4243E-4,6.9445E-4,7.2728E-4,6.0185E-4,4.8989E-4,5.3942E-4,6.9157E-4,7.307E-4,6.029E-4,4.9156E-4,5.3918E-4,6.8958E-4,7.2893E-4,6.0243E-4,4.9087E-4,5.3749E-4,6.9176E-4,7.2668E-4,6.0321E-4,4.9043E-4,5.3503E-4,6.9065E-4,7.2396E-4,6.0459E-4,4.9113E-4,5.3447E-4,6.8875E-4,7.2751E-4,6.038E-4,4.9045E-4,5.3339E-4,6.8628E-4,7.2585E-4,6.0491E-4,4.8893E-4,5.316E-4,6.8128E-4,7.1984E-4,6.0244E-4,4.9019E-4,5.2654E-4,6.7936E-4,7.2254E-4,6.0362E-4,4.8797E-4,5.2981E-4,6.8087E-4,7.2089E-4,6.0314E-4,4.8676E-4,5.2572E-4,6.8006E-4,7.1929E-4,6.047E-4,4.8723E-4,5.2288E-4,6.7743E-4,7.1864E-4,6.039E-4,4.8655E-4,5.2645E-4,6.7641E-4,7.1607E-4,6.0494E-4,4.8664E-4,5.2458E-4,6.7746E-4,7.1828E-4,6.0383E-4,4.8594E-4,5.2211E-4,6.7469E-4,7.1772E-4,6.0647E-4,4.8766E-4,5.222E-4,6.7616E-4,7.1431E-4,6.046E-4,4.8672E-4,5.2133E-4,6.718E-4,7.1913E-4,6.0619E-4,4.8499E-4,5.2118E-4,6.7348E-4,7.1534E-4,6.0572E-4,4.8422E-4,5.2304E-4,6.7315E-4,7.1302E-4,6.0604E-4,4.8695E-4,5.1855E-4,6.7217E-4,7.1834E-4,6.0634E-4,4.8701E-4,5.2019E-4,6.6975E-4,7.1404E-4,6.0746E-4,4.8568E-4,5.1769E-4,6.6967E-4,7.1389E-4,6.078E-4,4.8594E-4,5.1883E-4,6.7034E-4,7.1457E-4,6.0964E-4,4.8712E-4,5.1418E-4,6.704E-4,7.1276E-4,6.0776E-4,4.8407E-4,5.1592E-4,6.6988E-4,7.1275E-4,6.1057E-4,4.8602E-4,5.1525E-4,6.6646E-4,7.1243E-4,6.1374E-4,4.8686E-4,5.1656E-4,6.6698E-4,7.1356E-4,6.1194E-4,4.8687E-4,5.1338E-4,6.6577E-4,7.1441E-4,6.1247E-4,4.861E-4,5.1296E-4,6.6408E-4,7.1096E-4,6.1271E-4,4.8531E-4,5.1156E-4,6.6659E-4,7.1178E-4,6.0897E-4,4.8535E-4,5.1207E-4,6.6243E-4,7.1372E-4,6.1512E-4,4.8484E-4,5.1073E-4,6.6291E-4,7.1094E-4,6.1277E-4,4.8567E-4,5.1015E-4,6.6364E-4,7.11E-4,6.1498E-4,4.8416E-4,5.0764E-4,6.6396E-4,7.1362E-4,6.1592E-4,4.8537E-4,5.1005E-4,6.6347E-4,7.0849E-4,6.1487E-4,4.8614E-4,5.1011E-4,6.5867E-4,7.0903E-4,6.1625E-4,4.8482E-4,5.0938E-4,6.6231E-4,7.1147E-4,6.1492E-4,4.8707E-4,5.0782E-4,6.614E-4,7.0969E-4,6.1403E-4,4.8427E-4,5.0403E-4,6.6059E-4,7.0843E-4,6.1855E-4,4.8542E-4,5.0423E-4,6.5987E-4,7.08E-4,6.1595E-4,4.8581E-4,5.0684E-4,6.5817E-4,7.0813E-4,1.1277E-4:2
8.55E-6,2.47E-6,2.7067E-6,9.3167E-6,-2.6267E-6,1.0953E-5,7.9933E-6,8.2267E-6,2.4103E-5,-7.3133E-6,2.011E-5,1.114E-5,3.6867E-6,4.22E-6,-8.66E-6,1.0978E-4,0.0033374,0.0039696,0.0033494,0.0017287,0.0018367,0.0021279,0.002158,0.0018312,0.0015768,0.0017988,0.0021154,0.002158,0.0018234,0.0015812,0.0017985,0.0021132,0.002163,0.0018282,0.0015778,0.0017929,0.0021022,0.0021656,0.0018155,0.0015752,0.0017882,0.0021026,0.0021609,0.0018132,0.0015711,0.0017822,0.002094,0.0021623,0.0018162,0.0015759,0.0017891,0.0020996,0.0021782,0.0018242,0.001579,0.0017807,0.0021046,0.0021767,0.0018265,0.0015831,0.0017901,0.0021094,0.0021803,0.0018327,0.0015875,0.0017933,0.0021105,0.0021809,0.0018313,0.0015885,0.0017904,0.0021064,0.0021833,0.0018326,0.0015767,0.0017797,0.0020959,0.0021686,0.0018154,0.0015721,0.0017746,0.0020812,0.0021672,0.0018189,0.0015701,0.0017676,0.0020914,0.0021773,0.0018298,0.001579,0.0017744,0.0021019,0.0021887,0.0018332,0.0015849,0.0017832,0.0020984,0.002184,0.0018395,0.0015766,0.0017645,0.0020772,0.0021662,0.001817,0.00157,0.0017505,0.0020773,0.002168,0.0018237,0.0015737,0.0017713,0.0020804,0.0021789,0.0018408,0.0015744,0.0017707,0.0020907,0.0021783,0.001828,0.0015684,0.001758,0.0020733,0.0021573,0.001825,0.0015646,0.0017546,0.0020718,0.0021729,0.0018366,0.0015723,0.0017621,0.0020808,0.0021679,0.001828,0.0015676,0.0017436,0.0020642,0.0021553,0.0018153,0.0015587,0.001743,0.0020666,0.002166,0.0018339,0.0015722,0.001754,0.0020671,0.0021624,0.0018232,0.0015554,0.0017423,0.0020493,0.0021433,0.0018206,0.0015592,0.0017401,0.0020567,0.0021676,0.0018267,0.0015565,0.0017345,0.0020369,0.0021421,0.001813,0.0015407,0.001722,0.0020352,0.0021527,0.0018295,0.0015597,0.0017321,0.0020503,0.0021438,0.0018104,0.0015446,0.0017107,0.0020226,0.0021384,0.0018192,0.0015541,0.0017297,0.0020385,0.0021485,0.0018192,0.0015412,0.0017085,0.0020186,0.0021303,0.0018197,0.0015495,0.0017216,0.002036,0.0021435,0.0018213,0.001539,0.0017018,0.0020113,0.0021269,0.0018197,0.0015423,0.0017087,0.0020311,0.0021339,0.001822,0.00154,0.001694,0.0020053,0.0021217,0.0018193,0.0015402,0.001708,0.0020242,0.0021341,0.0018192,0.0015348,0.0016854,0.0020031,0.0021177,0.0018152,0.001541,0.0017025,0.00201,0.0021261,0.0018134,0.0015291,0.0016774,0.0019939,0.0021181,0.001817,0.0015349,0.0016941,0.0019968,0.0021083,0.0018072,0.0015215,0.0016784,0.001995,0.0021137,0.001818,0.0015296,0.0016859,0.001983,0.0021067,0.0018024,0.0015215,0.0016802,0.0019995,0.00212,0.00182,0.0015262,0.0016747,0.0019809,0.0020979,0.0018035,0.0015241,0.0016737,0.0019967,0.0021146,0.0018054,0.0015128,0.0016576,0.0019754,0.0021065,0.0018134,0.0015174,0.0016686,0.0019718,0.0020951,0.0017965,0.0015149,0.0016643,0.0019862,0.002102,0.0018023,0.0015102,0.0016534,0.0019568,0.002087,0.0018071,0.0015123,0.0016595,0.001971,0.002094,0.0017933,0.0015049,0.0016538,0.001967,0.0021023,0.0018031,0.0015111,0.0016454,0.0019557,0.0020864,0.0018022,0.0015123,0.0016587,0.0019696,0.0020907,0.0017925,0.0015068,0.0016424,0.0019634,0.0020942,0.0018076,0.0015086,0.0016434,0.0019555,0.0020883,0.0018043,0.0015121,0.0016499,0.0019562,0.0020841,0.0017921,0.0014993,0.0016443,0.001954,0.0020976,0.0017997,0.0015023,0.0016417,0.0019423,0.002076,0.0017983,0.001509,0.0016414,0.0019562,0.0020774,0.0017902,0.0014954,0.0016298,0.001949,0.0020844,0.0017959,0.0014979,0.0016332,0.0019344,0.0020779,0.0018015,0.0015052,0.0016276,0.0019411,0.0020632,0.0017889,0.0014978,0.0016729,0.0021041,0.0023117,0.0020055,0.00163,0.0018147,0.0021789,0.0022865,3.4039E-4:2
1.4427E-5,5.38E-6,1.8723E-5,1.5367E-5,-7.4533E-6,1.2107E-5,5.7867E-6,1.117E-5,9.1067E-6,-3.7867E-6,1.2887E-5,3.8267E-6,4.7633E-6,1.245E-5,-2.31E-6,2.0307E-5,1.3334E-8,4.0333E-6,1.6023E-5,-5.1267E-6,1.6097E-5,0.0011563,0.0021749,0.0020274,0.0016584,0.0016292,0.0019749,0.002166,0.0020623,0.0016454,0.0016423,0.0019674,0.0021791,0.0020626,0.0016507,0.0016589,0.0019797,0.0021968,0.0020683,0.0016597,0.0016608,0.0019816,0.0021997,0.0020852,0.0016602,0.0016663,0.0019868,0.002196,0.0020788,0.0016567,0.0016626,0.0019748,0.0021799,0.0020708,0.0016425,0.0016504,0.0019655,0.0021628,0.0020531,0.0016363,0.0016393,0.0019571,0.0021592,0.0020455,0.0016283,0.0016369,0.0019609,0.0021721,0.0020587,0.0016408,0.001647,0.0019681,0.002186,0.0020638,0.001646,0.0016577,0.0019731,0.0021882,0.002063,0.0016406,0.0016483,0.0019596,0.0021678,0.0020467,0.0016328,0.0016392,0.0019593,0.0021718,0.0020503,0.0016343,0.0016478,0.0019641,0.0021839,0.0020655,0.0016435,0.0016549,0.0019725,0.0021898,0.0020619,0.0016372,0.0016449,0.0019606,0.0021708,0.0020459,0.0016225,0.0016381,0.0019532,0.002171,0.0020432,0.0016324,0.0016478,0.0019716,0.0021873,0.0020464,0.0016373,0.001656,0.0019592,0.0021714,0.0020393,0.0016253,0.0016306,0.0019493,0.0021674,0.0020449,0.0016262,0.0016434,0.0019639,0.0021764,0.00205,0.0016276,0.0016472,0.0019523,0.002166,0.0020346,0.0016225,0.0016296,0.001947,0.0021656,0.0020393,0.0016288,0.0016464,0.001959,0.0021708,0.0020367,0.0016171,0.0016318,0.0019443,0.0021614,0.0020232,0.0016148,0.0016406,0.0019512,0.0021715,0.0020337,0.0016226,0.0016381,0.001948,0.0021559,0.002017,0.0016107,0.001629,0.0019524,0.0021717,0.0020317,0.0016148,0.0016428,0.0019476,0.0021524,0.0020132,0.0016068,0.0016255,0.001932,0.0021612,0.0020308,0.0016139,0.0016271,0.00194,0.0021445,0.0020036,0.0015897,0.0016123,0.0019307,0.0021436,0.0020082,0.0016038,0.0016198,0.0019328,0.0021294,0.001995,0.0015876,0.0016021,0.0019251,0.0021353,0.0020074,0.0015968,0.0016209,0.0019212,0.0021217,0.0019832,0.0015787,0.0:2
1.357E-5,1.0857E-5,2.4833E-6,1.348E-5,4.6667E-8,1.0027E-5,1.1397E-5,-1.7033E-6,7.2567E-6,-1.5333E-7,1.1293E-5,5.0733E-6,1.1233E-5,1.6757E-5,9.7E-7,1.6063E-5,1.1583E-5,1.086E-5,6.74E-6,-5.27E-6,1.209E-5,0.0011536,0.0023323,0.0017393,0.0018755,0.0020927,0.0023766,0.0023197,0.0018231,0.0017933,0.002124,0.0023808,0.0023013,0.0018355,0.0017904,0.0021366,0.002407,0.0023284,0.0018629,0.0018573,0.0021994,0.002415,0.0023313,0.0018634,0.0018151,0.002163,0.0024534,0.002347,0.0018909,0.0018558,0.002213,0.0024154,0.0023383,0.0018727,0.001828,0.0021853,0.0024434,0.0023539,0.001876,0.0018265,0.0021834,0.0024627,0.0023771,0.0019037,0.0018642,0.0022085,0.0025075,0.0023799,0.0019106,0.0018677,0.0022254,0.0025075,0.0023895,0.0019098,0.0018692,0.0022324,0.0024956,0.0023984,0.0019227,0.0018873,0.0022418,0.0025902,0.0024611,0.0019716,0.0019431,0.0023055,0.0025773,0.0025009,0.0019957,0.0019844,0.0023332,0.0026294,0.0025067,0.0019872,0.0019592,0.0023396,0.0026615,0.0024955,0.0020111,0.0019562,0.0023335,0.0026193,0.0025463,0.002016,0.0019888,0.002381,0.0026626,0.0025561,0.0020274,0.0019874,0.0023772,0.0026434,0.0025311,0.0020072,0.0019615,0.0023517,0.0026362,0.0025272,0.002007,0.0019767,0.0023621,0.0026515,0.0025358,0.0020119,0.0019864,0.0023675,0.002642,0.0025237,0.0019938,0.0019771,0.0023594,0.0026388,0.0025272,0.0019996,0.0019847,0.0023757,0.0026473,0.0025406,0.0020127,0.0019832,0.0023669,0.0026467,0.0025163,0.0019872,0.001975,0.0023696,0.0026498,0.0025327,0.0020195,0.0019942,0.0023791,0.0026588,0.0025285,0.0020044,0.0019699,0.0023502,0.0026334,0.0025177,0.0019996,0.0019902,0.0023809,0.0026461,0.0025261,0.0019999,0.0019724,0.0023548,0.0026189,0.0025118,0.0019861,0.0019728,0.0023703,0.0026496,0.0025143,0.0019879,0.0019728,0.002356,0.0026263,0.0024892,0.0019712,0.0019758,0.0023599,0.0026469,0.0025083,0.0019868,0.0019721,0.0023505,0.0026268,0.0024846,0.0019745,0.0019607,0.002364,0.0026344,0.0024932,0.001985,0.001968,0.0023544,0.0026164,0.0024759,0.0019661,0.0019644,0.0:2
-2.8E-7,2.6467E-6,-5.7E-7,2.3733E-6,3.3333E-7,-4.6667E-8,1.3933E-6,-1.6033E-6,2.2867E-6,-3.3333E-8,7.0E-8,1.6467E-6,-1.0633E-6,2.2367E-6,-7.0E-8,-1.0733E-6,1.9933E-6,-1.8233E-6,2.1367E-6,-1.1667E-7,-1.6267E-6,5.3333E-7,-4.0333E-7,2.6533E-6,1.4733E-6,-5.3333E-8,2.1433E-6,-1.1167E-6,2.12E-6,4.8E-7,-8.5E-7,2.2933E-6,-1.2433E-6,2.1733E-6,1.7333E-7,-7.3E-7,2.0333E-6,-7.1E-7,1.9833E-6,7.5667E-7,-3.7E-7,2.2367E-6,-1.2E-6,2.34E-6,1.5567E-6,1.2E-7,1.4733E-6,-2.32E-6,2.04E-6,-2.3333E-7,8.5333E-7,1.9833E-6,-6.3E-7,1.5367E-6,3.7E-7,-4.4667E-7,1.1967E-6,-1.28E-6,1.56E-6,-2.9E-7,-7.9333E-7,1.15E-6,-2.5967E-6,2.98E-6,6.7E-7,-7.6E-7,2.4733E-6,-2.3567E-6,1.8E-6,6.9333E-7,-1.1033E-6,1.24E-6,-3.9667E-7,2.1367E-6,-5.1E-7,-2.7667E-7,2.63E-6,-8.1333E-7,1.53E-6,7.5333E-7,-4.5333E-7,5.4333E-7,-1.6967E-6,2.6233E-6,3.9333E-7,-8.8E-7,1.4367E-6,-1.3667E-6,2.3933E-6,-6.1333E-7,-1.6333E-7,1.58E-6,-1.1767E-6,2.0967E-6,4.0E-8,5.8667E-7,2.38E-6,-1.4633E-6,1.77E-6,1.8333E-7,6.5333E-7,1.0667E-6,-1.5267E-6,2.3533E-6,-2.9E-7,9.2E-7,2.05E-6,-1.0633E-6,1.9667E-6,-1.1033E-6,1.3733E-6,1.08E-6,-1.4E-6,2.1067E-6,-8.6667E-7,1.3333E-7,1.5733E-6,-1.8333E-6,2.6333E-6,-6.6663E-9,4.8896E-4,7.6323E-4,6.2639E-4,7.0288E-4,8.1936E-4,8.5336E-4,7.4894E-4,6.4652E-4,6.8924E-4,8.2811E-4,8.6019E-4,7.4966E-4,6.535E-4,6.8489E-4,8.2877E-4,8.5766E-4,7.4902E-4,6.5609E-4,6.8322E-4,8.285E-4,8.637E-4,7.4852E-4,6.5583E-4,6.8324E-4,8.295E-4,8.6129E-4,7.5199E-4,6.5418E-4,6.8116E-4,8.3126E-4,8.66E-4,7.517E-4,6.5719E-4,6.8106E-4,8.3162E-4,8.6381E-4,7.5205E-4,6.5734E-4,6.792E-4,8.2703E-4,8.6045E-4,7.5196E-4,6.566E-4,6.785E-4,8.2656E-4,8.652E-4,7.5488E-4,6.586E-4,6.7706E-4,8.2811E-4,8.6491E-4,7.5523E-4,6.5685E-4,6.7721E-4,8.2643E-4,8.643E-4,7.5843E-4,6.5817E-4,6.7748E-4,8.2686E-4,8.6389E-4,7.5643E-4,6.5653E-4,6.7633E-4,8.2666E-4,8.6411E-4,7.5967E-4,6.5844E-4,6.7705E-4,8.2315E-4,8.6418E-4,7.5944E-4,6.6055E-4,6.7518E-4,8.265E-4,8.6439E-4,7.6007E-4,6.5931E-4,6.7402E-4,8.2449E-4,8.6366E-4,7.6038E-4,6.5429E-4,6.7431E-4,8.225E-4,8.6735E-4,7.606E-4,6.5885E-4,6.6982E-4,8.2195E-4,8.6631E-4,7.5922E-4,6.5497E-4,6.6814E-4,8.2273E-4,8.6367E-4,7.6224E-4,6.5866E-4,6.6876E-4,8.1869E-4,8.6057E-4,7.6036E-4,6.5926E-4,6.6898E-4,8.1687E-4,8.6536E-4,7.64E-4,6.5983E-4,6.6599E-4,8.1526E-4,8.6675E-4,7.6555E-4,6.5961E-4,6.6649E-4,8.1754E-4,8.639E-4,7.6204E-4,6.6013E-4,6.633E-4,8.1501E-4,8.6144E-4,7.6257E-4,6.5819E-4,6.6553E-4,8.132E-4,8.5841E-4,7.6463E-4,6.5774E-4,6.6425E-4,8.1317E-4,8.5856E-4,7.6475E-4,6.5819E-4,6.5919E-4,8.1215E-4,8.5913E-4,7.625E-4,6.5525E-4,6.6349E-4,8.0796E-4,8.5646E-4,7.6501E-4,6.585E-4,6.5616E-4,8.0641E-4,8.5841E-4,7.6513E-4,6.5433E-4,6.5803E-4,8.0643E-4,8.5291E-4,7.631E-4,6.5389E-4,6.5581E-4,8.0556E-4,8.5668E-4,7.654E-4,6.5667E-4,6.5305E-4,8.047E-4,8.5358E-4,7.6543E-4,6.5433E-4,6.5289E-4,8.0082E-4,8.5241E-4,7.641E-4,6.5311E-4,6.5358E-4,7.9974E-4,8.5455E-4,7.6373E-4,6.5616E-4,6.5194E-4,8.0077E-4,8.5033E-4,7.6938E-4,6.5438E-4,6.4708E-4,8.0099E-4,8.5237E-4,7.6519E-4,6.5498E-4,6.4795E-4,7.9652E-4,8.4879E-4,7.6515E-4,6.5493E-4,6.463E-4,7.926E-4,8.5126E-4,7.6363E-4,6.5186E-4,6.4793E-4,7.9086E-4,8.4374E-4,7.6846E-4,6.5155E-4,6.444E-4,7.9186E-4,8.4729E-4,7.6704E-4,6.5392E-4,6.4351E-4,7.9045E-4,8.4608E-4,7.6687E-4,6.516E-4,6.4269E-4,7.9322E-4,8.4766E-4,7.6528E-4,6.5209E-4,6.4199E-4,7.9167E-4,8.4236E-4,7.6702E-4,6.5113E-4,6.4082E-4,7.8589E-4,8.4205E-4,7.6547E-4,6.4922E-4,6.4141E-4,7.8575E-4,8.4192E-4,7.6652E-4,6.5094E-4,6.3427E-4,7.8374E-4,8.4036E-4,7.6291E-4,6.4998E-4,6.3648E-4,7.8231E-4,8.3796E-4,7.6677E-4,6.503E-4,6.3653E-4,7.821E-4,8.3874E-4,7.642E-4,6.4764E-4,6.3426E-4,7.7592E-4,8.3905E-4,7.6462E-4,6.5048E-4,6.3123E-4,7.7843E-4,8.3705E-4,7.6505E-4,6.4707E-4,6.3022E-4,7.7507E-4,8.3654E-4,7.6306E-4,6.4888E-4,6.29E-4,7.7384E-4,8.3364E-4,7.6325E-4,6.4743E-4,6.2918E-4,7.7156E-4,8.3368E-4,7.6153E-4,6.4845E-4,6.2739E-4,7.7071E-4,8.3334E-4,7.6456E-4,6.4548E-4,6.2326E-4,7.6652E-4,8.3113E-4,7.6107E-4,6.4848E-4,6.246E-4,7.6581E-4,8.2776E-4,7.6293E-4,6.4651E-4,6.2128E-4,7.6372E-4,8.2885E-4,7.641E-4,6.4688E-4,6.2057E-4,7.6474E-4,8.2684E-4,7.6128E-4,6.4379E-4,6.2049E-4,7.6187E-4,8.2664E-4,7.616E-4,6.4479E-4,6.1788E-4,7.6041E-4,8.2425E-4,7.5944E-4,6.4523E-4,6.1566E-4,7.555E-4,8.2206E-4,7.578E-4,6.4497E-4,6.1533E-4,7.5877E-4,8.2236E-4,7.5851E-4,6.4021E-4,6.1371E-4,7.5475E-4,8.2001E-4,7.6154E-4,6.4199E-4,6.1374E-4,7.5361E-4,8.1757E-4,7.5837E-4,6.4151E-4,6.1128E-4,7.5191E-4,8.1883E-4,7.6152E-4,6.428E-4,6.107E-4,7.4866E-4,8.1726E-4,7.5708E-4,6.3857E-4,6.0911E-4,7.4614E-4,8.1331E-4,7.5792E-4,6.4115E-4,6.0512E-4,7.4343E-4,0.0:2
1.51E-6,-4.6E-7,1.6633E-6,-9.0E-7,2.68E-6,6.0667E-7,1.0E-8,9.0333E-7,-5.5333E-7,1.6267E-6,6.0667E-7,-1.23E-6,1.9233E-6,-7.7E-7,1.4E-6,8.5E-7,-3.5667E-7,1.2733E-6,-8.4E-7,2.7633E-6,-5.3333E-7,-2.1667E-7,1.65E-6,-1.32E-6,1.6167E-6,-1.0667E-6,-9.5333E-7,1.0467E-6,-7.4667E-7,2.97E-6,-1.4667E-7,5.0E-7,1.2933E-6,-7.6667E-7,6.2E-7,1.3367E-6,6.2973E-4,7.1403E-4,6.1645E-4,7.4095E-4,8.4198E-4,8.3242E-4,6.9345E-4,6.4083E-4,7.2456E-4,8.3997E-4,8.3884E-4,6.918E-4,6.4531E-4,7.2127E-4,8.4599E-4,8.4517E-4,6.9594E-4,6.4675E-4,7.1643E-4,8.4326E-4,8.4131E-4,6.9722E-4,6.4616E-4,7.1449E-4,8.4892E-4,8.432E-4,6.9984E-4,6.47E-4,7.1095E-4,8.4178E-4,8.4388E-4,7.0076E-4,6.4751E-4,7.1413E-4,8.4178E-4,8.448E-4,6.999E-4,6.498E-4,7.1013E-4,8.3991E-4,8.5015E-4,7.0481E-4,6.4736E-4,7.0826E-4,8.3789E-4,8.5023E-4,7.0781E-4,6.494E-4,7.0609E-4,8.4019E-4,8.5068E-4,7.1067E-4,6.4836E-4,7.0547E-4,8.4012E-4,8.477E-4,7.0822E-4,6.465E-4,7.0445E-4,8.3679E-4,8.5072E-4,7.1019E-4,6.4705E-4,7.0221E-4,8.3811E-4,8.4695E-4,7.1427E-4,6.4739E-4,6.9786E-4,8.3373E-4,8.5092E-4,7.1502E-4,6.4561E-4,6.9648E-4,8.3478E-4,8.4821E-4,7.1427E-4,6.4614E-4,6.9373E-4,8.3216E-4,8.5135E-4,7.1726E-4,6.489E-4,6.911E-4,8.2894E-4,8.5167E-4,7.2036E-4,6.4559E-4,6.9079E-4,8.2995E-4,8.514E-4,7.2037E-4,6.4433E-4,6.8795E-4,8.2964E-4,8.4728E-4,7.2147E-4,6.4386E-4,6.8481E-4,8.2704E-4,8.4688E-4,7.2402E-4,6.4481E-4,6.8162E-4,8.2513E-4,8.4956E-4,7.2519E-4,6.4536E-4,6.8202E-4,8.2085E-4,8.4648E-4,7.262E-4,6.4332E-4,6.7776E-4,8.2098E-4,8.5289E-4,7.2829E-4,6.4105E-4,6.7676E-4,8.1964E-4,8.4949E-4,7.3016E-4,6.4398E-4,6.723E-4,8.1816E-4,8.4984E-4,7.2996E-4,6.422E-4,6.7433E-4,8.1347E-4,8.4672E-4,7.3328E-4,6.4193E-4,6.7028E-4,8.1617E-4,8.4557E-4,7.3224E-4,6.4352E-4,6.6642E-4,8.1322E-4,8.4826E-4,7.3106E-4,6.4327E-4,6.6475E-4,8.0925E-4,8.4538E-4,7.3365E-4,6.4218E-4,6.6405E-4,8.0764E-4,8.4415E-4,7.4053E-4,6.4214E-4,6.5987E-4,8.0934E-4,8.4361E-4,7.3932E-4,6.4015E-4,6.594E-4,8.0546E-4,8.3944E-4,7.4327E-4,6.4064E-4,6.5751E-4,8.0349E-4,8.3987E-4,7.4281E-4,6.4141E-4,6.5353E-4,7.9952E-4,8.4046E-4,7.4221E-4,6.4274E-4,6.5093E-4,7.982E-4,8.4E-4,7.4431E-4,6.4183E-4,6.4943E-4,7.9617E-4,8.3799E-4,7.4518E-4,6.4354E-4,6.4713E-4,7.9503E-4,8.4007E-4,7.4771E-4,6.4055E-4,6.4492E-4,7.8851E-4,8.4098E-4,7.484E-4,6.4099E-4,6.4417E-4,7.8814E-4,8.3519E-4,7.4465E-4,6.4232E-4,6.3762E-4,7.8594E-4,8.3482E-4,7.4966E-4,6.4367E-4,6.3831E-4,7.8366E-4,8.3468E-4,7.475E-4,6.3901E-4,6.35E-4,7.8018E-4,8.3471E-4,7.4849E-4,6.4076E-4,6.3242E-4,7.7926E-4,8.3175E-4,7.5244E-4,6.4222E-4,6.3132E-4,7.7536E-4,8.3209E-4,7.512E-4,6.4194E-4,6.3074E-4,7.7586E-4,8.3059E-4,7.5191E-4,6.3996E-4,6.2713E-4,7.7055E-4,8.2613E-4,7.5466E-4,6.3859E-4,6.2528E-4,7.6965E-4,8.2399E-4,7.5277E-4,6.415E-4,6.2265E-4,7.6509E-4,8.2428E-4,7.5435E-4,6.4056E-4,6.2053E-4,7.6265E-4,8.239E-4,7.5593E-4,6.4065E-4,6.2011E-4,7.6375E-4,8.238E-4,7.5705E-4,6.4049E-4,6.1758E-4,7.5995E-4,8.2128E-4,7.5499E-4,6.4232E-4,6.1497E-4,7.5278E-4,8.1861E-4,7.5778E-4,6.4039E-4,6.1397E-4,7.5198E-4,8.1724E-4,7.5875E-4,6.3982E-4,6.1295E-4,7.4974E-4,8.1824E-4,7.5647E-4,6.4043E-4,6.0657E-4,7.4953E-4,8.1241E-4,7.5744E-4,6.4084E-4,6.0526E-4,7.4426E-4,8.1091E-4,7.5849E-4,6.4125E-4,6.0408E-4,7.4267E-4,8.1087E-4,7.6027E-4,6.413E-4,6.0224E-4,7.3992E-4,8.0993E-4,7.5802E-4,6.4099E-4,6.0057E-4,7.3804E-4,8.0436E-4,7.5888E-4,6.4196E-4,5.9838E-4,7.3271E-4,8.0427E-4,7.5798E-4,6.4148E-4,5.957E-4,7.3274E-4,8.0183E-4,7.5839E-4,6.4236E-4,5.9407E-4,7.2679E-4,7.9892E-4,7.5933E-4,6.4105E-4,5.9126E-4,7.2542E-4,8.0123E-4,7.5751E-4,6.4326E-4,5.9056E-4,7.2182E-4,7.9772E-4,7.5739E-4,6.4328E-4,5.8798E-4,7.1868E-4,7.9729E-4,7.5866E-4,6.4252E-4,5.8677E-4,7.1423E-4,7.9509E-4,7.5818E-4,6.4109E-4,5.8515E-4,7.1071E-4,7.9212E-4,7.5651E-4,6.4365E-4,5.8129E-4,7.078E-4,7.9158E-4,7.5553E-4,6.4577E-4,5.8008E-4,7.073E-4,7.894E-4,7.5459E-4,6.4299E-4,5.793E-4,7.0285E-4,7.868E-4,7.5848E-4,6.4334E-4,5.7813E-4,7.0157E-4,7.8008E-4,7.5725E-4,6.4322E-4,5.7501E-4,6.9997E-4,7.8449E-4,7.5465E-4,6.4533E-4,5.751E-4,6.9594E-4,7.7828E-4,7.5736E-4,6.4606E-4,5.7166E-4,6.9206E-4,7.7788E-4,7.5655E-4,6.4469E-4,5.7157E-4,6.9096E-4,7.7493E-4,7.5313E-4,7.0553E-5:2
1.283E-5,4.3667E-6,1.9787E-5,1.916E-5,-1.1933E-6,1.7247E-5,1.8367E-6,1.4503E-5,1.9897E-5,-1.6667E-6,1.753E-5,-1.0E-6,6.3833E-6,2.1867E-5,-3.9167E-6,2.061E-5,2.32E-6,1.5223E-5,1.922E-5,1.6433E-6,2.2947E-5,2.26E-6,1.8883E-5,2.4613E-5,-4.8333E-6,2.192E-5,-2.2167E-6,1.747E-5,1.4373E-5,-2.6666E-8,2.2067E-5,4.6433E-6,1.3293E-5,1.9763E-5,-5.1233E-6,2.132E-5,2.0933E-6,1.1067E-5,1.5737E-5,-7.3867E-6,2.2133E-5,9.8333E-7,1.6613E-5,1.986E-5,0.0072075,0.0073193,0.0074465,0.0093483,0.0097033,0.0078402,0.0071617,0.007644,0.0092824,0.0096579,0.0079798,0.0070696,0.0077199,0.0092847,0.009632,0.0079933,0.0070486,0.0077004,0.0092497,0.0096191,0.0079869,0.0070393,0.0077083,0.0092678,0.009641,0.0080201,0.0070503,0.0077287,0.0092712,0.0096571,0.0080248,0.0070414,0.0077089,0.0092347,0.0096316,0.0080139,0.0070376,0.0077227,0.0092436,0.009648,0.0080186,0.0070236,0.0076954,0.0092106,0.0096526,0.0080154,0.0070434,0.0077136,0.009222,0.0096458,0.0079921,0.0070306,0.0076842,0.0092227,0.0096604,0.0080079,0.0070311,0.0076692,0.0092125,0.0096488,0.0080093,0.0070358,0.0076487,0.009191,0.0096355,0.008002,0.00702,0.0076357,0.0091912,0.0096074,0.0080057,0.0070185,0.0076283,0.0091625,0.0096124,0.0080029,0.0070216,0.0076344,0.0091605,0.0096273,0.0080094,0.0069969,0.0076206,0.0091543,0.0096113,0.0079971,0.0069794,0.007612,0.0091405,0.0095939,0.0079822,0.006977,0.0076065,0.0091106,0.0095746,0.0079913,0.0069925,0.0075696,0.0091008,0.00958,0.0079714,0.0069657,0.0075714,0.0091108,0.0095706,0.0079764,0.0069777,0.0075645,0.0090794,0.0095758,0.0079747,0.0069565,0.0075607,0.0090845,0.0095566,0.0079717,0.0069491,0.0075436,0.0090587,0.009572,0.0079597,0.0069537,0.0075454,0.0090412,0.0095579,0.0079555,0.0069358,0.0075331,0.0090213,0.0095389,0.0079651,0.0069358,0.0075151,0.0090187,0.0095244,0.0079438,0.0069245,0.0074862,0.009007,0.0095168,0.0079394,0.0069186,0.0074564,0.0089933,0.0095096,0.0079303,0.0069048,0.0074555,0.0089857,0.0094959,0.0079384,0.0069011,0.0074469,0.0089766,0.0094813,0.0079397,0.006893,0.0074398,0.0089623,0.0094616,0.0079243,0.0068767,0.0074274,0.0089314,0.0094651,0.0079181,0.0068675,0.0074194,0.0089044,0.0094558,0.0078972,0.0068523,0.0073824,0.0088825,0.0094419,0.007899,0.0068391,0.0073735,0.0088575,0.0094447,0.0078907,0.0068378,0.0073484,0.0088366,0.0094206,0.0078628,0.0068294,0.0073308,0.0088328,0.009408,0.0078709,0.0068117,0.0073202,0.008817,0.0093869,0.0078609,0.0068025,0.0072958,0.0087904,0.0093772,0.0078433,0.0067903,0.0072725,0.0087605,0.0093526,0.0078328,0.0067737,0.0072637,0.0087435,0.0093566,0.007826,0.0067744,0.0072322,0.0087302,0.009332,0.0078176,0.0067571,0.0072164,0.0087101,0.0093157,0.0078134,0.0067457,0.0072033,0.0086932,0.0093028,0.0077979,0.0067336,0.0071819,0.0086775,0.009278,0.0077926,0.0067224,0.0071646,0.008657,0.0092712,0.0077994,0.0067001,0.0071599,0.0086292,0.0092648,0.0077954,0.0066946,0.0071506,0.0086043,0.0092441,0.007783,0.0066883,0.0071405,0.0085847,0.0092455,0.0077754,0.0066792,0.0071069,0.0085709,0.0092432,0.007776,0.0066708,0.0071023,0.008561,0.0092335,0.0077675,0.006683,0.007081,0.0085574,0.0092176,0.0077603,0.0066707,0.0070704,0.008543,0.0092061,0.0077539,0.0066597,0.0070597,0.008539,0.0091882,0.0077581,0.0066467,0.0070448,0.0085192,0.0091804,0.0077569,0.0066474,0.0070371,0.0084795,0.0091879,0.0077626,0.0066486,0.0070231,0.0084728,0.0091734,0.0077567,0.0066464,0.0070206,0.0084605,0.0091657,0.0077534,0.0066351,0.007009,0.0084513,0.0091549,0.0077512,0.0066142,0.0069729,0.0084356,0.0091419,0.0077463,0.0066094,0.0069757,0.0084147,0.0091247,0.0077461,0.0066054,0.0069611,0.0084007,0.0091283,0.0077468,0.0066081,0.0069532,0.0083872,0.0091172,0.0077386,0.0065838,0.0069493,0.0083732,0.00913,0.0077504,0.0065892,0.006937,0.0083607,0.0091262,0.0077489,0.006601,0.0069207,0.0083468,0.0091218,0.0077559,0.0065987,0.0069087,0.0083506,0.009114,0.0077489,0.0065988,0.0068964,0.0083412,0.0090991,0.0077452,0.0065952,0.0068889,0.0083302,0.009091,0.0077482,0.0065944,0.006886,0.008331,0.0090932,0.0077595,0.0065805,0.0068714,0.0083134,0.0090752,0.0077708,0.0065851,0.0068625,0.0082939,0.0090773,0.007775,0.0065707,0.0068623,0.0082653,0.0090709,0.0077762,0.0065628,0.0068556,0.0082604,0.0090625,0.0077741,0.0065732,0.0068464,0.0082602,0.009071,0.0077794,0.0065718,0.0068405,0.0082515,0.0090684,0.0077838,0.0065715,0.0068301,0.0082314,0.0090721,0.0077837,0.0065651,0.0068159,0.0082204,0.0090604,0.0077891,0.0065704,0.006813,0.0082137,0.0090491,0.0077993,0.0065667,0.006806,0.0081993,0.0090548,0.0078028,0.0065721,0.0067955,0.008202,0.0090593,0.0078064,0.0065704,0.0067933,0.0081947,0.0090633,0.0077994,0.0065768,0.0067798,0.0081996,0.009061,0.0078261,0.0065927,0.006789,0.0081986,0.0090448,0.0078257,0.0065757,0.0067719,0.0081787,0.0090356,0.0078527,0.0065941,0.0067851,0.0082053,0.0090407,0.0078684,0.0065747,0.006772,0.008163,0.0090307,0.007853,0.0065714,0.0067725,0.0081663,0.0090391,0.0078678,0.0065902,0.0067699,0.0081724,0.0090547,0.0078621,0.0065852,0.0067577,0.0081446,0.0090599,0.0078689,0.0065873,0.0067542,0.0081395,0.009063,0.0078779,0.0065913,0.0067471,0.0081214,0.0090409,0.0078741,0.006597,0.0067342,0.0081224,0.0090243,0.0078872,0.006597,0.0067313,0.0081209,0.009037,0.0078966,0.0065628,0.0066905,0.0080731,0.0089872,0.0078758,0.0065612,0.0066942,0.0080695,0.0089894,0.0078842,0.0065707,0.0066824,0.0080545,0.0089901,0.0078899,0.0065706,0.0066762,0.008066,0.0089948,0.0079038,0.0065766,0.0066817,0.0080475,0.0090017,0.0079166,0.0065987,0.0066836,0.008066,0.0089988,0.0079376,0.0066021,0.0066814,0.0080684,0.0090002,0.0079544,0.006608,0.0066904,0.0080686,0.0089967,0.0079658,0.006621,0.0066844,0.0080567,0.0090159,0.0079829,0.0066145,0.0066925,0.0080382,0.0090013,0.0079898,0.0066072,0.0066735,0.0080198,0.009014,0.0079799,0.0066137,0.0066714,0.008019,0.0090195,0.0080023,0.006624,0.0066688,0.0080205,0.0090137,0.0079921,0.006625,0.0066524,0.0080047,0.0089977,0.0079953,0.0066285,0.006638,0.0080137,0.0089877,0.008,0.0066276,0.0066335,0.0079916,0.0089864,0.0080224,0.0:2
1.0683E-5,8.6E-7,2.0067E-5,2.8147E-5,-1.9667E-6,2.0787E-5,8.77E-6,9.54E-6,3.3053E-5,9.5933E-6,1.704E-5,6.24E-6,2.63E-5,3.4353E-5,-4.3233E-6,1.6213E-5,2.3233E-6,2.439E-5,2.924E-5,4.5667E-7,2.173E-5,8.3567E-6,1.1807E-5,2.818E-5,9.2401E-4,0.0096873,0.011114,0.012611,0.013123,0.01133,0.0094775,0.010864,0.012739,0.013266,0.011185,0.0096799,0.010777,0.012753,0.013305,0.011174,0.0097109,0.010741,0.012749,0.013316,0.011149,0.0096786,0.010702,0.01271,0.013276,0.011135,0.0096806,0.010711,0.012734,0.013313,0.011186,0.0097296,0.010711,0.012754,0.013309,0.011164,0.0097022,0.010688,0.012724,0.013324,0.011182,0.009722,0.010714,0.012743,0.013303,0.011181,0.0096918,0.010678,0.01271,0.01334,0.011205,0.0097174,0.010682,0.012689,0.013328,0.011197,0.0097109,0.010696,0.0127,0.013314,0.011197,0.0097011,0.010661,0.012689,0.013342,0.011189,0.0096983,0.010655,0.012689,0.013326,0.011182,0.009681,0.01062,0.012683,0.013325,0.011197,0.0096846,0.010584,0.012663,0.013306,0.011202,0.0096652,0.010604,0.012651,0.01332,0.011187,0.0096454,0.010612,0.012633,0.013295,0.011174,0.0096545,0.010596,0.012601,0.013281,0.011193,0.0096529,0.010574,0.012568,0.013273,0.011166,0.0096298,0.010535,0.012562,0.013243,0.011147,0.0096319,0.010528,0.01254,0.013215,0.011154,0.0096318,0.010465,0.012522,0.013216,0.011112,0.0095925,0.010463,0.012514,0.013183,0.011153,0.0095918,0.010447,0.012487,0.013193,0.011133,0.0095996,0.010442,0.012453,0.013195,0.011137,0.0095634,0.010429,0.012446,0.013172,0.011143,0.0095559,0.010389,0.012401,0.013152,0.011128,0.0095544,0.010378,0.012399,0.01316,0.01112,0.0095448,0.010369,0.012385,0.013162,0.011119,0.0095319,0.010346,0.012348,0.013111,0.011094,0.0095102,0.010335,0.012313,0.013087,0.011074,0.009493,0.010283,0.012282,0.013076,0.011072,0.0094799,0.010281,0.012232,0.013062,0.011044,0.0094314,0.010227,0.012204,0.013037,0.011032,0.0094361,0.010228,0.012201,0.013023,0.011016,0.0094233,0.010185,0.012159,0.013041,0.011016,0.0094338,0.010172,0.012152,0.012991,0.010985,0.0094242,0.010146,0.012151,0.01295,0.010991,0.0093782,0.010137,0.012108,0.012933,0.010987,0.0093711,0.010118,0.012092,0.012922,0.011011,0.0093635,0.010105,0.012077,0.01292,0.010997,0.0093436,0.01009,0.012025,0.012927,0.010999,0.0093394,0.010074,0.012017,0.012908,0.010973,0.009325,0.01004,0.011982,0.012867,0.010954,0.0093099,0.010025,0.011956,0.012859,0.010924,0.0093023,0.010005,0.011944,0.012848,0.010934,0.0092757,0.0099791,0.011917,0.012827,0.010922,0.0092795,0.009983,0.011886,0.012829,0.010916,0.009261,0.009971,0.011872,0.01282,0.010902,0.0092537,0.0099408,0.011877,0.012825,0.010902,0.0092705,0.0099122,0.01184,0.012778,0.010886,0.0092434,0.0098883,0.011861,0.012797,0.010895,0.0092395,0.0098713,0.011827,0.01278,0.010907,0.0092341,0.0098784,0.011805,0.012748,0.010871,0.0092026,0.009839,0.011786,0.012732,0.010849,0.0091838,0.0098355,0.011739,0.012699,0.010847,0.0091737,0.0098217,0.011707,0.012684,0.010854,0.0091624,0.0097876,0.011681,0.012663,0.010833,0.0091467,0.0097929,0.011685,0.012662,0.010839,0.0091587,0.0097667,0.011671,0.012678,0.010831,0.0091541,0.0097637,0.011663,0.01269,0.010832,0.0091325,0.0097431,0.011635,0.012646,0.010823,0.0091316,0.0097321,0.011632,0.012643,0.01082,0.0091334,0.0097061,0.011607,0.012624,0.010818,0.0091188,0.0096864,0.011568,0.012603,0.010813,0.0091132,0.0096618,0.011585,0.012607,0.0108,0.0091004,0.0096824,0.011589,0.012611,0.010816,0.0091116,0.0096712,0.011585,0.012594,0.010828,0.0091062,0.0096447,0.011551,0.012575,0.010817,0.0090854,0.0096365,0.011534,0.012555,0.010797,0.0090909,0.009625,0.011511,0.012549,0.010824,0.0090737,0.0096378,0.011501,0.012561,0.010828,0.0090789,0.0096316,0.01148,0.012575,0.010808,0.0090677,0.0096235,0.011484,0.012586,0.010816,0.0090895,0.009603,0.011475,0.012586,0.010816,0.0090957,0.0095907,0.011486,0.012583,0.010819,0.0090934,0.0095796,0.011463,0.012557,0.010808,0.0090824,0.0095693,0.011477,0.012527,0.010825,0.0090822,0.0095567,0.011456,0.012526,0.010809,0.0090622,0.0095414,0.011405,0.012506,0.010798,0.0090508,0.0095268,0.011407,0.012507,0.010818,0.0090581,0.0095449,0.011413,0.012519,0.010799,0.0090749,0.0095312,0.011406,0.012516,0.010819,0.0090673,0.0095314,0.011407,0.012526,0.010826,0.0090485,0.00952,0.011405,0.012496,0.010815,0.0090517,0.0095254,0.011407,0.01254,0.010835,0.0090571,0.0095246,0.01139,0.01253,0.010853,0.0090709,0.0087202:2
2.3633E-5,1.3737E-5,2.7817E-5,7.6267E-6,-9.9333E-7,2.9173E-5,6.0167E-6,3.2823E-5,2.201E-5,5.4833E-6,3.4803E-5,1.372E-5,1.4407E-5,1.4113E-5,9.53E-6,2.8917E-5,1.2333E-5,3.5753E-5,2.0957E-5,1.748E-5,2.146E-5,1.4413E-5,2.2533E-5,1.5117E-5,4.0667E-6,2.2537E-5,9.3767E-6,2.3647E-5,2.2083E-5,1.2133E-6,3.2443E-5,0.011822,0.013422,0.012286,0.0097072,0.010528,0.012301,0.013554,0.012145,0.0099569,0.010378,0.012389,0.013552,0.012065,0.0099676,0.010355,0.012385,0.013476,0.012044,0.0099448,0.010331,0.012418,0.013512,0.012079,0.0099646,0.010379,0.012432,0.013523,0.012054,0.0099378,0.010346,0.012365,0.01351,0.012071,0.0099634,0.010395,0.012412,0.01355,0.012045,0.0099362,0.010352,0.012383,0.013546,0.012035,0.0099599,0.010349,0.012361,0.013506,0.012003,0.0099499,0.010361,0.012409,0.013505,0.011987,0.0099231,0.010331,0.012388,0.013531,0.011981,0.0099116,0.010328,0.012382,0.013503,0.012012,0.009924,0.010329,0.01236,0.0135,0.012007,0.0099021,0.010307,0.012348,0.013481,0.011998,0.0098926,0.010319,0.01236,0.0135,0.011965,0.0098842,0.010319,0.012363,0.013495,0.011926,0.0098794,0.010325,0.012367,0.013439,0.01192,0.0098795,0.010309,0.012328,0.013444,0.011916,0.0098816,0.010282,0.012337,0.013445,0.011911,0.00985,0.010299,0.012337,0.013405,0.011882,0.0098374,0.01028,0.012298,0.013405,0.011874,0.0098149,0.010264,0.012281,0.013387,0.011835,0.0097988,0.010247,0.012241,0.013393,0.011817,0.0097795,0.010246,0.012247,0.013374,0.011811,0.0097926,0.010235,0.012272,0.013387,0.011784,0.0097933,0.010218,0.012251,0.013357,0.01175,0.0097785,0.010224,0.012227,0.013337,0.011767,0.0097546,0.01021,0.012236,0.01333,0.011747,0.0097377,0.010194,0.012207,0.013301,0.011725,0.0097183,0.010183,0.012184,0.013275,0.01171,0.0096947,0.010183,0.012162,0.013254,0.011687,0.0096725,0.010175,0.012163,0.013259,0.01165,0.0096599,0.01015,0.012137,0.013256,0.01163,0.0096551,0.0:2
6.75E-6,-5.0E-8,5.05E-6,1.9367E-6,4.4433E-6,5.95E-6,7.9E-7,5.49E-6,1.7933E-6,5.06E-6,5.1267E-6,-3.4667E-7,5.7E-6,2.7E-6,5.8867E-6,6.0633E-6,3.6333E-7,6.0067E-6,2.1267E-6,5.6133E-6,6.4133E-6,5.8333E-7,6.6633E-6,2.1867E-6,5.5167E-6,5.6867E-6,1.2267E-6,6.4967E-6,2.28E-6,5.1633E-6,8.4167E-6,3.3733E-6,5.4833E-6,1.9E-6,5.6233E-6,6.2733E-6,-4.3667E-7,2.3179E-4,9.0173E-4,9.6399E-4,9.0727E-4,7.612E-4,7.0936E-4,8.7212E-4,9.709E-4,9.0348E-4,7.7258E-4,7.0508E-4,8.75E-4,9.6909E-4,9.0239E-4,7.755E-4,7.0266E-4,8.7621E-4,9.6865E-4,9.0298E-4,1.4915E-4,-4.7957E-5,2.8787E-5,5.8157E-4,0.0012603,0.0010063,9.4457E-4,0.0010926,0.0012701,0.0012146,0.0010332,9.1982E-4,0.0011131,0.0012616,0.0012111,0.001043,9.1787E-4,0.0011195,0.0012639,0.0012178,0.0010446,9.1591E-4,0.0011136,0.0012633,0.001215,0.0010435,9.1366E-4,0.0011148,0.0012616,0.0012152,0.0010446,9.1601E-4,0.001113,0.0012633,0.0012162,0.0010451,9.1232E-4,0.0011136,0.0012605,0.0012185,0.0010527,9.1324E-4,0.001117,0.001262,0.0012196,0.0010477,9.1462E-4,0.0011092,0.0012612,0.0012148,0.0010493,9.126E-4,0.0011085,0.0012607,0.0012191,0.0010501,9.1234E-4,0.0011114,0.0012604,0.0012166,0.0010479,9.1101E-4,0.0011094,0.0012597,0.0012193,0.0010492,9.1263E-4,0.0011096,0.0012589,0.0012143,0.0010475,9.1108E-4,0.0011053,0.0012585,0.0012158,0.00105,9.1E-4,0.0011093,0.0012551,0.0012179,0.0010527,9.1087E-4,0.0011062,0.0012595,0.0012209,0.0010493,9.1018E-4,0.0011012,0.0012554,0.0012182,0.0010509,9.1029E-4,0.0011041,0.0012557,0.0012212,0.0010517,9.0965E-4,0.0011027,0.0012561,0.0012187,0.0010482,9.0953E-4,0.0010976,0.0012475,0.0012181,0.0010507,9.072E-4,0.0011016,0.0012555,0.0012168,0.0010516,9.0881E-4,0.0011015,0.0012541,0.0012186,0.001048,9.0314E-4,0.0010965,0.0012509,0.0012191,0.0010499,9.0646E-4,0.0010979,0.0012501,0.0012192,0.0010513,9.0643E-4,0.0010936,0.0012506,0.0012165,0.0010503,9.0256E-4,0.0010952,0.0012451,0.0012169,0.0010527,9.0619E-4,0.0010954,0.0012484,0.0012164,0.0010484,9.0188E-4,0.001089,0.0012458,0.0012189,0.0010519,9.0509E-4,0.0010942,0.0012453,0.0012171,0.0010533,9.0466E-4,0.0010906,0.0012469,0.001216,0.0010498,9.0446E-4,0.0010894,0.0012423,0.0012176,0.0010544,9.0098E-4,0.0010892,0.0012404,0.0012135,0.0010512,8.9934E-4,0.0010881,0.001243,0.0012162,0.0010529,9.0015E-4,0.0010859,0.0012436,0.0012173,0.0010526,8.9869E-4,0.001087,0.0012394,0.0012178,0.0010538,9.0058E-4,0.0010851,0.0012379,0.0012193,0.001052,9.0173E-4,0.001079,0.0012428,0.0012138,0.0010516,8.9849E-4,0.0010777,0.0012408,0.0012171,0.0010526,8.9903E-4,0.0010787,0.0012339,0.0012176,0.0010521,8.9445E-4,0.001078,0.0012369,0.0012179,0.0010531,8.9649E-4,0.0010798,0.001237,0.0012168,0.0010518,8.9677E-4,0.0010759,0.001236,0.0012154,0.0010531,8.9475E-4,0.0010773,0.0012335,0.0012154,0.0010525,8.9452E-4,0.001078,0.0012334,0.0012166,0.0010562,8.9544E-4,0.0010762,0.0012328,0.0012176,0.0010543,8.9421E-4,0.001074,0.0012321,0.0012179,0.0010564,8.9347E-4,0.0010724,0.0012323,0.0012174,0.0010555,8.9246E-4,0.0010717,0.0012301,0.0012176,0.0010568,8.9337E-4,0.0010711,0.0012309,0.0012172,0.0010497,8.9382E-4,0.001067,0.0012304,0.0012172,0.0010543,8.9228E-4,0.0010701,0.001231,0.0012146,0.0010537,8.9342E-4,0.0010691,0.0012299,0.0012166,0.001056,8.9325E-4,0.0010683,0.001227,0.0012159,0.0010534,8.922E-4,0.0010646,0.0012272,0.0012161,0.0010549,8.9334E-4,0.0010648,0.0012271,0.001216,0.0010554,8.9283E-4,0.0010643,0.0012217,0.0012152,0.0010547,8.9164E-4,0.0010632,0.0012253,0.0012159,0.0010564,8.9088E-4,0.0010629,0.0012203,0.0012162,0.0010555,8.9294E-4,0.0010602,0.0012263,0.0012178,0.0010606,8.8915E-4,0.0010615,0.0012215,0.0012169,0.0010608,8.9069E-4,0.0010604,0.0012221,0.001215,0.0010561,8.9042E-4,0.0010578,0.0012224,0.0012139,0.0010583,8.9026E-4,0.0010578,0.0012233,0.0012149,0.0010572,8.8994E-4,0.0010578,0.0012223,0.0012161,0.0010601,8.8816E-4,0.0010561,0.001221,0.0012158,0.0010563,8.9077E-4,0.0010575,0.0012213,0.0012143,0.0010585,8.8889E-4,0.0010525,0.0012186,0.0012142,0.0010588,8.866E-4,0.0010566,0.0012179,0.001217,0.0010583,8.8704E-4,0.0010547,0.001217,0.0012157,0.0010601,8.856E-4,0.0010515,0.0012159,0.0012136,0.001061,8.8793E-4,0.0010529,0.0012137,0.0012141,0.0010625,8.8766E-4,0.0010507,0.0012128,0.001214,0.0010586,8.8736E-4,0.0010447,0.001205,0.0012135,5.8793E-4:2
4.7467E-6,1.68E-6,4.8367E-6,6.3667E-7,5.7833E-6,4.8933E-6,1.2867E-6,4.9767E-6,1.04E-6,4.9267E-6,4.5767E-6,1.64E-6,5.9467E-6,4.3E-7,3.7867E-6,3.5767E-6,3.5567E-6,4.6167E-6,1.16E-6,5.68E-6,4.8E-6,1.1167E-6,5.4167E-6,1.33E-6,5.7633E-6,4.86E-6,1.2133E-6,4.9967E-6,4.4E-7,5.5667E-6,3.18E-6,1.94E-6,5.8033E-6,1.6167E-6,6.14E-6,3.4567E-6,2.8233E-6,4.61E-6,-1.1667E-7,6.1333E-6,5.16E-6,1.64E-6,5.36E-6,2.5064E-4,8.9153E-4,9.385E-4,8.9437E-4,6.8972E-4,7.448E-4,8.612E-4,9.4669E-4,8.8732E-4,6.9126E-4,9.423E-5,-3.031E-5,1.2297E-5,8.5141E-4,9.9212E-4,9.1754E-4,0.0011243,0.0012398,0.0011796,9.5171E-4,9.5205E-4,0.0011046,0.0012472,0.001187,9.4339E-4,9.6105E-4,0.0011006,0.0012491,0.0011894,9.4503E-4,9.6229E-4,0.0011015,0.00125,0.0011918,9.4021E-4,9.6242E-4,0.0011001,0.0012472,0.0011909,9.4306E-4,9.6112E-4,0.0010974,0.0012543,0.0011921,9.4399E-4,9.6365E-4,0.0010996,0.0012535,0.0011918,9.4338E-4,9.6462E-4,0.0010995,0.0012523,0.0011942,9.4395E-4,9.6281E-4,0.0010968,0.0012498,0.0011953,9.4173E-4,9.5942E-4,0.0010976,0.001253,0.0011904,9.4489E-4,9.624E-4,0.0010996,0.0012551,0.0011947,9.4394E-4,9.6235E-4,0.001098,0.0012473,0.0011885,9.4382E-4,9.6323E-4,0.0010948,0.0012493,0.0011936,9.4343E-4,9.6399E-4,0.0010946,0.0012509,0.0011878,9.4224E-4,9.6023E-4,0.0010936,0.0012469,0.0011897,9.4306E-4,9.6096E-4,0.0010922,0.0012485,0.0011924,9.4184E-4,9.5663E-4,0.0010913,0.0012444,0.0011909,9.4049E-4,9.6071E-4,0.0010945,0.0012468,0.0011911,9.3934E-4,9.6119E-4,0.0010921,0.0012463,0.001189,9.4052E-4,9.569E-4,0.0010919,0.0012405,0.0011889,9.4353E-4,9.5649E-4,0.0010909,0.0012425,0.001191,9.4087E-4,9.5728E-4,0.0010911,0.0012422,0.0011852,9.4054E-4,9.5425E-4,0.0010867,0.0012424,0.0011856,9.4029E-4,9.5539E-4,0.0010877,0.001245,0.0011847,9.3832E-4,9.518E-4,0.0010895,0.0012383,0.0011867,9.3733E-4,9.5362E-4,0.0010854,0.0012428,0.0011864,9.399E-4,9.5857E-4,0.0010883,0.0012455,0.0011844,9.405E-4,9.5568E-4,0.0010869,0.0012415,0.001185,9.3809E-4,9.5457E-4,0.0010869,0.0012419,0.0011875,9.3923E-4,9.5464E-4,0.0010869,0.0012423,0.0011819,9.3729E-4,9.5292E-4,0.0010874,0.0012409,0.0011808,9.3891E-4,9.5146E-4,0.0010861,0.0012384,0.0011846,9.386E-4,9.4866E-4,0.0010837,0.0012392,0.0011844,9.3745E-4,9.5419E-4,0.0010846,0.001239,0.0011869,9.3871E-4,9.4948E-4,0.0010808,0.0012392,0.0011848,9.3812E-4,9.502E-4,0.0010813,0.0012365,0.0011845,9.3926E-4,9.4993E-4,0.001084,0.0012354,0.0011846,9.3728E-4,9.5122E-4,0.0010824,0.0012368,0.0011841,9.3632E-4,9.4831E-4,0.0010817,0.0012347,0.0011804,9.3591E-4,9.4805E-4,0.0010754,0.0012358,0.0011795,9.3928E-4,9.4912E-4,0.0010815,0.0012366,0.0011836,9.3706E-4,9.5225E-4,0.0010792,0.0012379,0.0011795,9.3363E-4,9.4942E-4,0.0010768,0.001236,0.0011856,9.3612E-4,9.4892E-4,0.0010798,0.0012351,0.0011801,9.3536E-4,9.4645E-4,0.0010792,0.0012351,0.0011803,9.3627E-4,9.5001E-4,0.0010781,0.0012316,0.0011814,9.3404E-4,9.4548E-4,0.0010754,0.0012383,0.0011811,9.3439E-4,9.4458E-4,0.0010754,0.0012303,0.0011838,9.3866E-4,9.4435E-4,0.0010781,0.0012289,0.0011784,9.3389E-4,9.4354E-4,0.0010749,0.001231,0.001181,9.3607E-4,9.4581E-4,0.001076,0.0012337,0.0011769,9.3631E-4,9.4607E-4,0.0010746,0.0012343,0.0011788,9.331E-4,9.4383E-4,0.0010709,0.0012325,0.0011781,9.337E-4,9.4438E-4,0.0010728,0.0012306,0.0011759,9.3253E-4,9.4513E-4,0.0010719,0.0012327,0.0011767,9.3275E-4,9.4611E-4,0.0010705,0.0012307,0.0011755,9.335E-4,9.4229E-4,0.0010683,0.001229,0.0011759,9.3117E-4,9.4153E-4,0.0010689,0.0012285,0.0011776,9.3363E-4,9.4439E-4,0.0010717,0.001228,0.0011771,9.3139E-4,9.426E-4,0.0010717,0.0012318,0.0011759,9.3424E-4,9.4381E-4,0.0010701,0.0012295,0.0011791,9.3239E-4,9.4172E-4,0.0010712,0.0012288,0.0011776,9.3295E-4,9.4209E-4,0.0010686,0.001227,0.0011783,9.3094E-4,9.4167E-4,0.0010682,0.0012256,0.0011768,9.3285E-4,9.4294E-4,0.0010697,0.0012235,0.0011724,9.3181E-4,9.4122E-4,0.0010651,0.0012241,0.0011776,9.3139E-4,9.374E-4,0.0010665,0.0012278,0.0011744,9.3063E-4,9.4166E-4,0.0010711,0.0012276,0.0011702,9.3158E-4,9.3786E-4,0.0010662,0.0012269,0.0011748,9.3013E-4,9.3735E-4,0.0010623,0.001225,0.0011753,9.3326E-4,9.3726E-4,0.0010651,0.0012249,0.0011744,9.3269E-4,9.3798E-4,0.0010614,0.001226,0.0011716,9.2935E-4,9.39E-4,0.0010622,0.0012248,0.0011738,9.3306E-4,9.3525E-4,0.0010619,0.0012207,0.0011742,9.3119E-4,9.3975E-4,0.0010622,0.001223,0.0011731,9.2971E-4,9.378E-4,0.0010605,0.0012223,5.51E-4:2
-1.8E-7,2.65E-6,-1.89E-6,2.2667E-6,1.7267E-6,-5.2333E-7,3.5867E-6,-1.5833E-6,1.9133E-6,1.24E-6,3.4E-7,3.9233E-6,3.1333E-7,8.4E-7,1.75E-6,-1.4567E-6,3.3667E-6,4.4E-7,3.45E-6,1.3367E-6,-3.0367E-6,1.55E-6,2.4533E-6,2.4667E-6,2.09E-6,-1.5933E-6,3.0967E-6,-4.9E-7,2.3533E-6,2.3133E-6,-1.3533E-6,3.2133E-6,5.2667E-7,1.7833E-6,1.0967E-6,1.8387E-4,5.8475E-4,7.6776E-4,8.3224E-4,7.9013E-4,6.694E-4,5.9842E-4,7.4746E-4,8.3125E-4,8.0073E-4,6.6102E-4,6.0807E-4,7.4545E-4,8.3703E-4,8.0277E-4,6.5978E-4,6.0882E-4,7.4127E-4,8.3242E-4,8.0305E-4,6.6261E-4,6.1053E-4,7.4443E-4,8.3611E-4,8.0326E-4,6.5905E-4,6.1002E-4,7.4365E-4,8.3874E-4,8.092E-4,6.6234E-4,6.1226E-4,7.4432E-4,8.3705E-4,8.1269E-4,6.6389E-4,6.1416E-4,7.433E-4,8.4192E-4,8.1182E-4,6.631E-4,6.1091E-4,7.4369E-4,8.3831E-4,8.1173E-4,6.635E-4,6.1083E-4,7.3737E-4,8.3664E-4,8.1191E-4,6.6361E-4,6.0986E-4,7.4075E-4,8.4038E-4,8.1343E-4,6.6736E-4,6.1061E-4,7.3847E-4,8.4239E-4,8.1265E-4,6.6831E-4,6.0962E-4,7.4003E-4,8.4035E-4,8.1286E-4,6.6942E-4,6.1038E-4,7.4042E-4,8.4393E-4,8.1881E-4,6.6991E-4,6.1029E-4,7.4011E-4,8.3914E-4,8.13E-4,6.6997E-4,6.1203E-4,7.3961E-4,8.4037E-4,8.1638E-4,6.7229E-4,6.1019E-4,7.4131E-4,8.3998E-4,8.1948E-4,6.7003E-4,6.0871E-4,7.3654E-4,8.3868E-4,8.1503E-4,6.7164E-4,6.0949E-4,7.3705E-4,8.3699E-4,8.1552E-4,6.698E-4,6.1031E-4,7.347E-4,8.3797E-4,8.1891E-4,6.7628E-4,6.1138E-4,7.381E-4,8.3546E-4,8.1891E-4,6.7587E-4,6.1091E-4,7.3865E-4,8.4493E-4,8.2228E-4,6.7511E-4,6.1158E-4,7.3739E-4,8.4252E-4,8.2261E-4,6.7712E-4,6.1151E-4,7.3994E-4,8.3872E-4,8.2062E-4,6.7628E-4,6.1081E-4,7.3776E-4,8.3797E-4,8.2102E-4,6.7496E-4,6.0776E-4,7.3384E-4,8.4172E-4,8.2119E-4,6.7728E-4,6.0923E-4,7.3341E-4,8.3995E-4,8.2342E-4,6.783E-4,6.0805E-4,7.3218E-4,8.3921E-4,8.2348E-4,6.7983E-4,6.109E-4,7.3197E-4,8.3705E-4,8.2062E-4,6.7626E-4,6.0974E-4,7.3284E-4,8.3662E-4,8.236E-4,6.7974E-4,6.0773E-4,7.3315E-4,8.359E-4,8.22E-4,6.7942E-4,6.0864E-4,7.3209E-4,8.3807E-4,8.2267E-4,6.8038E-4,6.0816E-4,7.3069E-4,8.3542E-4,8.2411E-4,6.7994E-4,6.0582E-4,7.2641E-4,8.3476E-4,8.2148E-4,6.7961E-4,6.0472E-4,7.29E-4,8.3766E-4,8.2296E-4,6.8043E-4,6.0661E-4,7.2612E-4,8.3534E-4,8.2619E-4,6.8283E-4,6.0386E-4,7.2757E-4,8.3808E-4,8.2252E-4,6.8237E-4,6.0586E-4,7.2637E-4,8.3359E-4,8.2074E-4,6.8113E-4,6.0288E-4,7.2452E-4,8.3299E-4,8.2451E-4,6.8546E-4,6.0519E-4,7.2556E-4,8.3424E-4,8.2414E-4,6.8282E-4,6.0307E-4,7.2134E-4,8.3373E-4,8.2473E-4,6.8356E-4,6.0251E-4,7.2069E-4,8.3276E-4,8.2218E-4,6.8405E-4,6.0302E-4,7.2527E-4,8.32E-4,8.2128E-4,6.8529E-4,6.0297E-4,7.2269E-4,8.2861E-4,8.2028E-4,6.8601E-4,6.0164E-4,7.1847E-4,8.284E-4,8.2369E-4,6.8501E-4,6.0023E-4,7.1989E-4,8.3173E-4,8.2668E-4,6.8645E-4,6.0233E-4,7.1889E-4,8.2749E-4,8.2242E-4,6.8565E-4,6.0099E-4,7.1753E-4,8.259E-4,8.241E-4,6.8164E-4,6.016E-4,7.1629E-4,8.2834E-4,8.2564E-4,6.8543E-4,6.0234E-4,7.1547E-4,8.2554E-4,8.2275E-4,6.8515E-4,5.9757E-4,7.1547E-4,8.2599E-4,8.1285E-4,6.7938E-4,5.9417E-4,7.0725E-4,8.2175E-4,8.22E-4,6.8528E-4,5.9799E-4,7.0976E-4,8.2426E-4,8.1997E-4,6.8712E-4,5.9845E-4,7.0894E-4,8.2056E-4,8.2381E-4,6.8619E-4,5.9747E-4,7.0975E-4,8.234E-4,8.198E-4,6.8736E-4,5.9491E-4,7.0829E-4,8.1915E-4,8.2089E-4,6.846E-4,5.9749E-4,7.0927E-4,8.2177E-4,8.2057E-4,6.8712E-4,5.9349E-4,7.0494E-4,8.2E-4,8.2098E-4,6.8646E-4,5.9494E-4,7.0709E-4,8.1643E-4,8.2275E-4,6.8675E-4,5.9479E-4,7.0604E-4,8.1478E-4,8.1849E-4,6.9085E-4,5.9287E-4,7.0299E-4,8.1713E-4,8.1905E-4,6.8717E-4,5.9639E-4,7.0287E-4,8.1615E-4,8.227E-4,6.8822E-4,5.931E-4,7.0233E-4,8.1349E-4,8.199E-4,6.887E-4,5.9299E-4,7.0252E-4,8.1554E-4,8.1903E-4,6.9207E-4,5.9235E-4,7.0006E-4,8.1228E-4,8.1814E-4,6.9022E-4,5.9148E-4,6.991E-4,8.1287E-4,8.2205E-4,6.9042E-4,5.9207E-4,7.0198E-4,8.1171E-4,8.1924E-4,6.9045E-4,5.8714E-4,6.9916E-4,8.1103E-4,8.1957E-4,6.9369E-4,5.9047E-4,6.9679E-4,8.0807E-4,8.1982E-4,6.9172E-4,5.8795E-4,6.9513E-4,8.1138E-4,8.1862E-4,6.9378E-4,5.8755E-4,6.9456E-4,8.1041E-4,8.1709E-4,6.9067E-4,5.8908E-4,6.918E-4,8.0669E-4,8.196E-4,6.9508E-4,5.8952E-4,6.9504E-4,8.0912E-4,8.1813E-4,6.945E-4,5.8825E-4,6.9098E-4,8.0689E-4,8.1894E-4,6.9377E-4,5.8982E-4,6.915E-4,8.0673E-4,8.2052E-4,6.9183E-4,5.8757E-4,6.9093E-4,8.0375E-4,8.1921E-4,6.9414E-4,5.879E-4,6.9076E-4,8.0538E-4,8.1719E-4,6.9415E-4,5.8694E-4,6.8784E-4,8.0378E-4,8.1834E-4,6.9579E-4,5.8769E-4,6.8742E-4,8.0266E-4,8.1952E-4,6.9455E-4,5.8484E-4,6.8731E-4,8.0007E-4,8.1664E-4,6.9615E-4,5.8641E-4,6.8698E-4,8.0274E-4,8.1966E-4,6.9788E-4,5.8625E-4,6.8207E-4,8.0136E-4,8.1896E-4,6.9932E-4,5.8467E-4,6.8793E-4,8.0342E-4,8.1644E-4,6.9715E-4,5.8406E-4,6.8411E-4,8.0151E-4,8.189E-4,7.0111E-4,5.8602E-4,6.854E-4,7.9945E-4,8.1923E-4,6.961E-4,5.8448E-4,6.8421E-4,8.0055E-4,8.2424E-4,7.0192E-4,5.8642E-4,6.8266E-4,7.9809E-4,8.1744E-4,6.9774E-4,5.8573E-4,6.8263E-4,7.9812E-4,8.1795E-4,7.0202E-4,5.834E-4,6.813E-4,7.9824E-4,8.1759E-4,7.0148E-4,5.845E-4,6.788E-4,8.0028E-4,8.1779E-4,7.0378E-4,5.8259E-4,6.8015E-4,7.9642E-4,8.1617E-4,0.0:2
3.0333E-7,3.73E-6,-7.6E-7,3.0167E-6,1.3233E-6,1.43E-6,2.1267E-6,-2.2633E-6,8.0333E-7,4.7567E-6,-7.1333E-7,2.02E-6,8.9667E-7,3.5533E-6,1.8733E-6,1.2667E-7,1.5667E-6,-1.4867E-6,2.2867E-6,1.32E-6,5.6467E-4,6.7543E-4,5.9373E-4,7.1938E-4,8.2208E-4,8.2241E-4,6.6778E-4,6.1497E-4,6.9931E-4,8.2188E-4,8.2933E-4,6.6035E-4,6.174E-4,6.9786E-4,8.2248E-4,8.3071E-4,6.6169E-4,6.2246E-4,6.9629E-4,8.2443E-4,8.3159E-4,6.655E-4,6.2158E-4,6.9999E-4,8.2492E-4,8.3257E-4,6.6713E-4,6.2339E-4,6.9805E-4,8.2293E-4,8.2957E-4,6.6124E-4,6.2175E-4,6.9881E-4,8.2644E-4,8.3091E-4,6.6109E-4,6.209E-4,6.9843E-4,8.258E-4,8.3252E-4,6.6618E-4,6.2235E-4,7.0002E-4,8.248E-4,8.3605E-4,6.6356E-4,6.2345E-4,6.9954E-4,8.2704E-4,8.3256E-4,6.6429E-4,6.2521E-4,6.9871E-4,8.2127E-4,8.3016E-4,6.6646E-4,6.2488E-4,6.9698E-4,8.2461E-4,8.3236E-4,6.6619E-4,6.2141E-4,6.9619E-4,8.2596E-4,8.3305E-4,6.671E-4,6.2212E-4,6.9501E-4,8.2649E-4,8.3148E-4,6.6295E-4,6.1921E-4,6.9548E-4,8.2615E-4,8.3488E-4,6.6535E-4,6.2227E-4,6.9574E-4,8.2466E-4,8.3175E-4,6.6515E-4,6.2195E-4,6.9786E-4,8.2508E-4,8.3116E-4,6.6407E-4,6.2068E-4,6.9565E-4,8.2196E-4,8.3277E-4,6.6449E-4,6.2155E-4,6.9646E-4,8.287E-4,8.3343E-4,6.6622E-4,6.1982E-4,6.9777E-4,8.2444E-4,8.3199E-4,6.627E-4,6.1978E-4,6.9366E-4,8.2043E-4,8.3196E-4,6.6496E-4,6.2036E-4,6.9207E-4,8.2236E-4,8.3508E-4,6.6324E-4,6.2222E-4,6.9578E-4,8.2192E-4,8.3118E-4,6.638E-4,6.1752E-4,6.9445E-4,8.2273E-4,8.3272E-4,6.6285E-4,6.1701E-4,6.9256E-4,8.2494E-4,8.3004E-4,6.6446E-4,6.1955E-4,6.911E-4,8.1918E-4,8.3194E-4,6.6212E-4,6.1788E-4,6.8987E-4,8.2378E-4,8.3183E-4,6.627E-4,6.1875E-4,6.9321E-4,8.207E-4,8.3014E-4,6.6369E-4,6.1734E-4,6.8886E-4,8.2161E-4,8.3124E-4,6.6272E-4,6.1766E-4,6.9239E-4,8.1879E-4,8.217E-4,6.5591E-4,6.1144E-4,6.8623E-4,8.172E-4,8.2682E-4,6.5995E-4,6.1606E-4,6.857E-4,8.1621E-4,8.2942E-4,6.6289E-4,6.1566E-4,6.8928E-4,8.1606E-4,8.2797E-4,6.6353E-4,6.142E-4,6.8822E-4,8.1761E-4,8.2806E-4,6.6014E-4,6.1355E-4,6.8614E-4,8.1446E-4,8.2696E-4,6.6171E-4,6.1398E-4,6.8702E-4,8.1438E-4,8.2535E-4,6.6061E-4,6.1351E-4,6.8338E-4,8.1611E-4,8.2726E-4,6.6093E-4,6.1633E-4,6.8546E-4,8.1558E-4,8.2744E-4,6.6063E-4,6.1517E-4,6.8475E-4,8.1329E-4,8.255E-4,6.6073E-4,6.1274E-4,6.852E-4,8.148E-4,8.2475E-4,6.6196E-4,6.1217E-4,6.8616E-4,8.1347E-4,8.231E-4,6.5972E-4,6.1381E-4,6.8419E-4,8.1326E-4,8.2535E-4,6.6117E-4,6.1143E-4,6.8387E-4,8.1176E-4,8.2507E-4,6.5877E-4,6.1407E-4,6.8576E-4,8.0937E-4,8.2607E-4,6.6105E-4,6.0979E-4,6.8422E-4,8.1343E-4,8.2457E-4,6.5861E-4,6.0909E-4,6.8329E-4,8.1188E-4,8.2357E-4,6.5988E-4,6.1174E-4,6.8398E-4,8.1153E-4,8.2053E-4,6.5783E-4,6.0751E-4,6.8006E-4,8.1082E-4,8.2355E-4,6.6122E-4,6.1048E-4,6.8172E-4,8.1208E-4,8.232E-4,6.5857E-4,6.1019E-4,6.8011E-4,8.1105E-4,8.2244E-4,6.587E-4,6.1122E-4,6.7973E-4,8.111E-4,8.2052E-4,6.5976E-4,6.0887E-4,6.8084E-4,8.0851E-4,8.2066E-4,6.5833E-4,6.0904E-4,6.8124E-4,8.1402E-4,8.2113E-4,6.5729E-4,6.0945E-4,6.7856E-4,8.1048E-4,8.1881E-4,6.6036E-4,6.1095E-4,6.8083E-4,8.1017E-4,8.2035E-4,6.5764E-4,6.0802E-4,6.7687E-4,8.1159E-4,8.2001E-4,6.5965E-4,6.0871E-4,6.7875E-4,8.0506E-4,8.186E-4,6.5673E-4,6.0695E-4,6.8003E-4,8.0831E-4,8.1894E-4,6.6072E-4,6.0754E-4,6.7781E-4,8.0659E-4,8.2108E-4,6.5795E-4,6.0852E-4,6.8075E-4,8.0689E-4,8.1997E-4,6.5859E-4,6.0829E-4,6.7488E-4,8.0743E-4,8.2109E-4,6.567E-4,6.0829E-4,6.7518E-4,8.0774E-4,8.2008E-4,6.5996E-4,6.0734E-4,6.7613E-4,8.095E-4,8.1896E-4,6.5767E-4,6.0694E-4,6.7751E-4,8.0775E-4,8.2367E-4,6.5721E-4,6.0651E-4,6.7624E-4,8.0688E-4,8.2087E-4,6.5728E-4,6.0673E-4,6.7711E-4,8.0624E-4,8.2094E-4,6.5544E-4,6.0596E-4,6.7334E-4,8.0813E-4,8.2065E-4,6.5708E-4,6.0754E-4,6.7568E-4,8.0767E-4,8.1755E-4,6.5733E-4,6.0478E-4,6.75E-4,8.0677E-4,8.2012E-4,6.5919E-4,6.042E-4,6.7655E-4,8.0335E-4,8.1956E-4,6.5549E-4,6.0489E-4,6.7481E-4,8.0225E-4,8.1983E-4,6.5744E-4,6.0515E-4,6.7455E-4,7.9998E-4,8.1672E-4,6.6004E-4,6.0435E-4,6.7559E-4,8.0412E-4,8.1962E-4,6.5562E-4,6.0509E-4,6.7313E-4,7.9916E-4,8.1976E-4,6.5709E-4,6.056E-4,6.7534E-4,8.04E-4,8.1798E-4,6.5691E-4,6.0423E-4,6.7054E-4,8.0271E-4,8.1697E-4,6.579E-4,6.0467E-4,6.7093E-4,8.0548E-4,8.1648E-4,6.5618E-4,6.0439E-4,6.6892E-4,8.0316E-4,8.1643E-4,6.5834E-4,6.0404E-4,6.7135E-4,8.0055E-4,8.158E-4,6.5614E-4,6.0377E-4,6.7038E-4,7.9985E-4,8.1662E-4,6.5565E-4,6.016E-4,6.6834E-4,7.992E-4,8.1738E-4,6.5968E-4,6.0232E-4,6.6966E-4,8.0008E-4,8.1618E-4,6.5632E-4,6.0264E-4,6.6903E-4,8.0074E-4,8.1783E-4,6.5925E-4,6.0123E-4,6.6886E-4,7.9809E-4,8.1461E-4,6.5558E-4,6.0497E-4,6.6948E-4,7.9886E-4,8.173E-4,6.5762E-4,6.0039E-4,6.6634E-4,7.9619E-4,8.151E-4,6.5936E-4,6.0299E-4,6.683E-4,7.9758E-4,8.1509E-4,6.5358E-4,6.0424E-4,6.6668E-4,7.9885E-4,8.1697E-4,6.5902E-4,5.9839E-4,6.6672E-4,7.9355E-4,8.1563E-4,3.6199E-4:2
2.2367E-6,1.7533E-6,-2.3667E-7,2.6267E-6,2.9333E-7,1.3233E-6,1.16E-6,-1.1967E-6,2.3233E-6,-1.41E-6,1.4167E-6,1.52E-6,5.1E-7,2.1867E-6,3.6E-7,2.9E-6,1.2767E-6,-1.8E-7,3.3867E-6,9.8667E-7,1.31E-6,1.9E-6,-8.1E-7,3.5767E-6,-1.0667E-7,1.7033E-6,5.2571E-4,6.0227E-4,6.1752E-4,7.6997E-4,8.3801E-4,7.4373E-4,6.2517E-4,6.2186E-4,7.701E-4,8.3737E-4,7.5102E-4,6.262E-4,6.2731E-4,7.6987E-4,8.3985E-4,7.5013E-4,6.286E-4,6.2699E-4,7.7193E-4,8.3562E-4,7.4975E-4,6.2601E-4,6.2826E-4,7.7314E-4,8.3817E-4,7.4738E-4,6.2777E-4,6.277E-4,7.7186E-4,8.3686E-4,7.4927E-4,6.2469E-4,6.2739E-4,7.7522E-4,8.4047E-4,7.5202E-4,6.2579E-4,6.2621E-4,7.7413E-4,8.3872E-4,7.509E-4,6.2645E-4,6.2735E-4,7.7145E-4,8.3959E-4,7.5106E-4,6.2471E-4,6.2663E-4,7.7173E-4,8.3929E-4,7.5171E-4,6.2726E-4,6.2962E-4,7.7344E-4,8.4047E-4,7.5058E-4,6.2669E-4,6.2753E-4,7.7043E-4,8.4288E-4,7.4817E-4,6.2606E-4,6.2746E-4,7.6822E-4,8.4043E-4,7.5006E-4,6.2467E-4,6.2839E-4,7.708E-4,8.4061E-4,7.5187E-4,6.2684E-4,6.2871E-4,7.721E-4,8.4275E-4,7.5481E-4,6.2737E-4,6.249E-4,7.699E-4,8.4103E-4,7.5263E-4,6.2523E-4,6.2734E-4,7.7131E-4,8.3923E-4,7.5451E-4,6.2594E-4,6.2686E-4,7.7291E-4,8.3911E-4,7.516E-4,6.2778E-4,6.2989E-4,7.7223E-4,8.3505E-4,7.5265E-4,6.2674E-4,6.2667E-4,7.7159E-4,8.3943E-4,7.5399E-4,6.2317E-4,6.2655E-4,7.7385E-4,8.4334E-4,7.5428E-4,6.2436E-4,6.301E-4,7.7291E-4,8.3958E-4,7.528E-4,6.2791E-4,6.2803E-4,7.6942E-4,8.3921E-4,7.5323E-4,6.258E-4,6.2755E-4,7.7242E-4,8.4326E-4,7.5169E-4,6.2475E-4,6.2979E-4,7.692E-4,8.3951E-4,7.4944E-4,6.2376E-4,6.2607E-4,7.7067E-4,8.4093E-4,7.5229E-4,6.2341E-4,6.2702E-4,7.7217E-4,8.3925E-4,7.5236E-4,6.2426E-4,6.2689E-4,7.681E-4,8.3783E-4,7.4923E-4,6.2142E-4,6.2737E-4,7.6749E-4,8.348E-4,7.5188E-4,6.2771E-4,6.2691E-4,7.6976E-4,8.3709E-4,7.4769E-4,6.2211E-4,6.2648E-4,7.6812E-4,8.3635E-4,7.4967E-4,6.2211E-4,6.2631E-4,7.6834E-4,8.3722E-4,7.482E-4,6.248E-4,6.26E-4,7.6673E-4,8.3612E-4,7.5028E-4,6.1924E-4,6.2484E-4,7.6861E-4,8.3491E-4,7.4718E-4,6.2288E-4,6.2361E-4,7.6648E-4,8.3623E-4,7.4734E-4,6.2161E-4,6.2274E-4,7.6541E-4,8.3249E-4,7.4819E-4,6.2342E-4,6.2205E-4,7.6811E-4,8.3714E-4,7.5099E-4,6.2298E-4,6.2359E-4,7.6519E-4,8.3627E-4,7.4674E-4,6.1851E-4,6.238E-4,7.6656E-4,8.3445E-4,7.4768E-4,6.2134E-4,6.2365E-4,7.6634E-4,8.3235E-4,7.4658E-4,6.1915E-4,6.2284E-4,7.6631E-4,8.3694E-4,7.4544E-4,6.2168E-4,6.2306E-4,7.6493E-4,8.3526E-4,7.461E-4,6.2044E-4,6.2378E-4,7.6221E-4,8.3114E-4,7.4531E-4,6.1981E-4,6.2292E-4,7.6585E-4,8.3322E-4,7.4737E-4,6.1947E-4,6.2338E-4,7.6419E-4,8.3216E-4,7.4466E-4,6.1686E-4,6.2379E-4,7.6664E-4,8.3035E-4,7.4629E-4,6.1781E-4,6.2113E-4,7.6517E-4,8.3152E-4,7.44E-4,6.1897E-4,6.2037E-4,7.6162E-4,8.3476E-4,7.4556E-4,6.198E-4,6.2074E-4,7.6173E-4,8.2211E-4,7.3552E-4,6.1089E-4,6.1529E-4,7.5493E-4,8.2823E-4,7.422E-4,6.1868E-4,6.211E-4,7.6089E-4,8.2917E-4,7.407E-4,6.1929E-4,6.2188E-4,7.6544E-4,8.3243E-4,7.4345E-4,6.1952E-4,6.2155E-4,7.6319E-4,8.2919E-4,7.4304E-4,6.1862E-4,6.2097E-4,7.6453E-4,8.3147E-4,7.4485E-4,6.1845E-4,6.2016E-4,7.6382E-4,8.3049E-4,7.4069E-4,6.1824E-4,6.1952E-4,7.6064E-4,8.3057E-4,7.4291E-4,6.1717E-4,6.1778E-4,7.6064E-4,8.2853E-4,7.4042E-4,6.1939E-4,6.1845E-4,7.6306E-4,8.2848E-4,7.4149E-4,6.1662E-4,6.1909E-4,7.6103E-4,8.2686E-4,7.4175E-4,6.1446E-4,6.1901E-4,7.6274E-4,8.2805E-4,7.4239E-4,6.1396E-4,6.1727E-4,7.6264E-4,8.2897E-4,7.4167E-4,6.1611E-4,6.1846E-4,7.5925E-4,8.2893E-4,7.4227E-4,6.1593E-4,6.1827E-4,7.5848E-4,8.2883E-4,7.4076E-4,6.151E-4,6.1766E-4,7.5728E-4,8.3164E-4,7.4142E-4,6.1184E-4,6.1714E-4,7.595E-4,8.2746E-4,7.4062E-4,6.155E-4,6.1976E-4,7.6183E-4,8.2638E-4,7.3874E-4,6.1451E-4,6.1843E-4,7.5971E-4,8.2865E-4,7.4068E-4,6.1619E-4,6.208E-4,7.595E-4,8.2675E-4,7.3865E-4,6.1218E-4,6.1593E-4,7.5761E-4,8.262E-4,7.4045E-4,6.1503E-4,6.1641E-4,7.5804E-4,8.2615E-4,7.4019E-4,6.1252E-4,6.1611E-4,7.6001E-4,8.2559E-4,7.3788E-4,6.1444E-4,6.1503E-4,7.5683E-4,8.2596E-4,7.3859E-4,6.1492E-4,6.163E-4,7.5847E-4,8.2675E-4,7.3609E-4,6.1346E-4,6.1503E-4,7.6038E-4,8.2567E-4,7.4056E-4,6.1406E-4,6.1655E-4,7.5753E-4,8.2283E-4,7.3715E-4,6.1171E-4,6.1714E-4,7.5993E-4,8.2785E-4,7.3896E-4,6.1251E-4,6.1431E-4,7.5884E-4,8.251E-4,7.3747E-4,6.1068E-4,6.1584E-4,7.5709E-4,8.2468E-4,7.3829E-4,6.1368E-4,6.1647E-4,7.5782E-4,8.2703E-4,7.3576E-4,6.141E-4,6.1473E-4,7.57E-4,8.2616E-4,7.3502E-4,6.0967E-4,6.1675E-4,7.5671E-4,8.2511E-4,7.3616E-4,6.1253E-4,6.156E-4,7.5537E-4,8.2349E-4,3.5603E-4:2
-8.4E-7,3.67E-6,8.3E-7,1.0033E-6,2.3E-6,-9.3667E-7,2.5933E-6,2.5867E-6,1.29E-6,2.68E-6,-1.3E-7,3.2767E-6,2.0267E-6,9.4667E-7,1.1433E-6,1.2333E-7,2.1433E-6,3.3333E-7,2.95E-6,2.5133E-6,-1.3933E-6,1.05E-6,-7.1667E-7,1.13E-6,2.1433E-6,2.6E-7,1.9633E-6,5.5333E-7,1.1467E-6,1.17E-6,-1.1633E-6,3.3233E-6,7.6333E-7,3.5333E-7,4.8667E-7,4.7568E-4,5.92E-4,6.4832E-4,5.771E-4,4.8847E-4,4.5431E-4,5.7939E-4,6.4716E-4,5.8303E-4,4.8488E-4,4.5743E-4,5.7718E-4,6.4702E-4,5.8903E-4,4.8591E-4,4.5861E-4,5.787E-4,6.4652E-4,5.894E-4,4.8556E-4,4.5926E-4,5.7493E-4,6.4923E-4,5.9156E-4,4.8949E-4,4.5754E-4,5.7432E-4,6.4931E-4,5.9178E-4,4.8819E-4,4.5649E-4,5.7514E-4,6.4867E-4,5.9376E-4,4.9191E-4,4.5696E-4,5.7307E-4,6.4968E-4,5.9778E-4,4.9079E-4,4.5596E-4,5.7305E-4,6.5122E-4,5.9988E-4,4.9661E-4,4.5568E-4,5.7353E-4,6.4908E-4,6.0106E-4,4.9482E-4,4.5581E-4,5.7364E-4,6.5193E-4,6.0216E-4,4.9797E-4,4.5468E-4,5.6921E-4,6.4956E-4,6.0216E-4,4.9872E-4,4.5421E-4,5.6884E-4,6.5029E-4,6.0282E-4,4.9998E-4,4.5324E-4,5.6615E-4,6.4989E-4,6.0523E-4,5.0277E-4,4.5379E-4,5.6493E-4,6.5005E-4,6.0414E-4,5.0363E-4,4.5162E-4,5.6441E-4,6.5147E-4,6.0577E-4,5.0369E-4,4.5055E-4,5.629E-4,6.4792E-4,6.0851E-4,5.0583E-4,4.4923E-4,5.6105E-4,6.4768E-4,6.1016E-4,5.0756E-4,4.4923E-4,5.6062E-4,6.4881E-4,6.1049E-4,5.1223E-4,4.5071E-4,5.5875E-4,6.4751E-4,6.1218E-4,5.1083E-4,4.4918E-4,5.5731E-4,6.4667E-4,6.1326E-4,5.1231E-4,4.475E-4,5.5371E-4,6.4407E-4,6.1352E-4,5.1397E-4,4.4757E-4,5.5428E-4,6.4335E-4,6.1121E-4,5.1891E-4,4.4557E-4,5.5418E-4,6.4439E-4,6.1112E-4,5.1521E-4,4.4404E-4,5.5178E-4,6.4297E-4,6.1104E-4,5.1941E-4,4.4296E-4,5.4991E-4,6.4099E-4,6.1173E-4,5.1865E-4,4.4482E-4,5.4894E-4,6.4045E-4,6.1354E-4,5.2128E-4,4.409E-4,5.4024E-4,6.3136E-4,6.1174E-4,5.1908E-4,4.4019E-4,5.4257E-4,6.3523E-4,6.1366E-4,5.2146E-4,4.4099E-4,5.4252E-4,6.3648E-4,6.1598E-4,5.2525E-4,4.4069E-4,5.4083E-4,6.3163E-4,6.1489E-4,5.2514E-4,4.4066E-4,5.3889E-4,6.3424E-4,6.1297E-4,5.2801E-4,4.3991E-4,5.3731E-4,6.3384E-4,6.1542E-4,5.2947E-4,4.3888E-4,5.3346E-4,6.3229E-4,6.1378E-4,5.2841E-4,4.3841E-4,5.3447E-4,6.3041E-4,6.1646E-4,5.3155E-4,4.3676E-4,5.3236E-4,6.2829E-4,6.1917E-4,5.3464E-4,4.3814E-4,5.2963E-4,6.2809E-4,6.164E-4,5.3433E-4,4.3728E-4,5.3096E-4,6.2777E-4,6.1784E-4,5.3494E-4,4.3762E-4,5.2871E-4,6.2428E-4,6.1634E-4,5.386E-4,4.3752E-4,5.2641E-4,6.2543E-4,6.181E-4,5.4052E-4,4.3833E-4,5.2592E-4,6.2616E-4,6.2008E-4,5.4204E-4,4.3467E-4,5.214E-4,6.2038E-4,6.1889E-4,5.4081E-4,4.3633E-4,5.2328E-4,6.2279E-4,6.1925E-4,5.4379E-4,4.3566E-4,5.2144E-4,6.1987E-4,6.1924E-4,5.449E-4,4.3537E-4,5.1753E-4,6.1988E-4,6.1929E-4,5.4673E-4,4.3558E-4,5.1743E-4,6.1638E-4,6.1749E-4,5.4747E-4,4.3464E-4,5.1279E-4,6.1527E-4,6.2138E-4,5.4927E-4,4.3628E-4,5.1489E-4,6.1468E-4,6.2075E-4,5.5137E-4,4.3428E-4,5.1228E-4,6.128E-4,6.1969E-4,5.5253E-4,4.3468E-4,5.1042E-4,6.0841E-4,6.2346E-4,5.5346E-4,4.3396E-4,5.0812E-4,6.0842E-4,6.2241E-4,5.5508E-4,4.3528E-4,5.06E-4,6.0984E-4,6.2324E-4,5.561E-4,4.3495E-4,5.0492E-4,6.0927E-4,6.2506E-4,5.5942E-4,4.3563E-4,5.0281E-4,6.0722E-4,6.2202E-4,5.5891E-4,4.3485E-4,5.0326E-4,6.0209E-4,6.2297E-4,5.6091E-4,4.3476E-4,5.0032E-4,5.9988E-4,6.2094E-4,5.66E-4,4.3521E-4,5.016E-4,6.0203E-4,6.2422E-4,5.6467E-4,4.3519E-4,5.0073E-4,6.0034E-4,6.272E-4,5.6689E-4,4.3514E-4,4.9732E-4,5.9713E-4,6.2604E-4,5.6731E-4,4.3556E-4,4.9594E-4,5.9779E-4,6.2634E-4,5.7197E-4,4.3579E-4,4.947E-4,5.9342E-4,6.2758E-4,5.7006E-4,4.3795E-4,4.935E-4,5.9416E-4,6.2963E-4,5.7031E-4,4.3939E-4,4.9352E-4,5.9323E-4,6.2571E-4,5.7299E-4,4.3778E-4,4.8969E-4,5.9154E-4,6.2624E-4,5.736E-4,4.3613E-4,4.9015E-4,5.8862E-4,6.2636E-4,5.7489E-4,4.3789E-4,4.8674E-4,5.8647E-4,6.2636E-4,5.7491E-4,4.3685E-4,4.843E-4,5.8333E-4,6.2499E-4,5.7708E-4,4.3879E-4,4.8432E-4,5.8295E-4,6.2546E-4,5.7773E-4,4.3767E-4,4.8219E-4,5.8168E-4,6.2485E-4,5.7953E-4,4.3986E-4,4.8137E-4,5.7907E-4,6.285E-4,5.787E-4,4.3904E-4,4.7973E-4,5.7999E-4,6.2747E-4,5.8204E-4,4.4049E-4,4.8091E-4,5.7697E-4,6.2621E-4,5.8076E-4,4.3995E-4,4.7777E-4,5.7424E-4,6.2476E-4,5.8249E-4,4.4136E-4,4.7623E-4,5.7253E-4,6.2463E-4,5.8507E-4,4.3933E-4,4.7364E-4,5.7001E-4,6.273E-4,5.8452E-4,4.4295E-4,4.7226E-4,5.6896E-4,6.262E-4,5.8555E-4,4.4243E-4,4.7191E-4,5.679E-4,6.2665E-4,5.8712E-4,4.4508E-4,4.6794E-4,5.6471E-4,3.1592E-4:2
2.21E-6,4.4367E-6,3.9933E-6,-4.8067E-6,-2.0E-8,1.92E-6,3.1E-7,2.7233E-6,2.4533E-6,2.7967E-6,1.6767E-6,-7.6333E-7,2.6267E-6,-1.3333E-7,1.8833E-6,7.46E-6,-6.3334E-8,-4.4E-7,9.5E-7,1.3367E-6,2.6667E-7,-1.1333E-6,1.9167E-6,1.8667E-6,2.4633E-6,2.1233E-6,-1.0267E-6,1.3467E-6,2.2667E-7,2.1467E-6,2.2733E-6,6.7E-7,2.8667E-6,-1.1833E-6,1.7867E-6,4.8441E-4,4.5175E-4,4.7654E-4,5.9022E-4,6.3736E-4,5.7542E-4,4.4516E-4,4.8584E-4,5.8446E-4,6.3376E-4,5.8274E-4,4.4568E-4,4.9036E-4,5.8634E-4,6.3858E-4,5.8335E-4,4.4753E-4,4.8862E-4,5.8457E-4,6.3957E-4,5.8661E-4,4.4695E-4,4.903E-4,5.8497E-4,6.3815E-4,5.8852E-4,4.4676E-4,4.8861E-4,5.8491E-4,6.4005E-4,5.8796E-4,4.5106E-4,4.8705E-4,5.8289E-4,6.4092E-4,5.913E-4,4.4962E-4,4.8906E-4,5.8256E-4,6.3958E-4,5.9082E-4,4.4982E-4,4.8774E-4,5.8473E-4,6.4364E-4,5.9009E-4,4.5187E-4,4.8705E-4,5.8342E-4,6.393E-4,5.9288E-4,4.5068E-4,4.87E-4,5.8102E-4,6.3842E-4,5.9416E-4,4.5058E-4,4.8575E-4,5.791E-4,6.395E-4,5.9382E-4,4.5099E-4,4.8522E-4,5.8104E-4,6.4124E-4,5.9536E-4,4.5294E-4,4.8457E-4,5.8094E-4,6.4048E-4,5.9805E-4,4.5405E-4,4.8372E-4,5.8082E-4,6.4103E-4,5.9682E-4,4.5337E-4,4.8545E-4,5.7935E-4,6.4165E-4,5.9785E-4,4.5653E-4,4.836E-4,5.782E-4,6.4122E-4,6.0049E-4,4.555E-4,4.824E-4,5.7742E-4,6.409E-4,5.9996E-4,4.5594E-4,4.8277E-4,5.7662E-4,6.4319E-4,6.0081E-4,4.564E-4,4.8095E-4,5.6867E-4,6.3837E-4,5.961E-4,4.5329E-4,4.7973E-4,5.7479E-4,6.4109E-4,6.0302E-4,4.559E-4,4.8094E-4,5.7426E-4,6.425E-4,6.0229E-4,4.5791E-4,4.8037E-4,5.7317E-4,6.4108E-4,6.0344E-4,4.6023E-4,4.7687E-4,5.7106E-4,6.4326E-4,6.0441E-4,4.6002E-4,4.783E-4,5.6856E-4,6.4557E-4,6.0442E-4,4.5905E-4,4.7928E-4,5.6972E-4,6.4158E-4,6.0371E-4,4.6034E-4,4.781E-4,5.6803E-4,6.424E-4,6.0496E-4,4.6072E-4,4.7498E-4,5.6789E-4,6.4215E-4,6.0375E-4,4.604E-4,4.7565E-4,5.6653E-4,6.4078E-4,6.0709E-4,4.6115E-4,4.7484E-4,5.654E-4,6.4179E-4,6.0648E-4,4.6467E-4,4.7456E-4,5.6626E-4,6.3946E-4,6.0738E-4,4.6145E-4,4.7363E-4,5.6357E-4,6.3879E-4,6.0453E-4,4.6295E-4,4.7268E-4,5.6353E-4,6.417E-4,6.0503E-4,4.6259E-4,4.721E-4,5.6211E-4,6.3741E-4,6.076E-4,4.6372E-4,4.7211E-4,5.606E-4,6.3995E-4,6.0846E-4,4.6615E-4,4.711E-4,5.5892E-4,6.4235E-4,6.0768E-4,4.6533E-4,4.7162E-4,5.6056E-4,6.4055E-4,6.0951E-4,4.6612E-4,4.6932E-4,5.5813E-4,6.3887E-4,6.0713E-4,4.664E-4,4.6971E-4,5.5663E-4,6.4004E-4,6.0822E-4,4.6575E-4,4.698E-4,5.5557E-4,6.3788E-4,6.0954E-4,4.6701E-4,4.6954E-4,5.5277E-4,6.3744E-4,6.0775E-4,4.6627E-4,4.6823E-4,5.5449E-4,6.3629E-4,6.0994E-4,4.6755E-4,4.6754E-4,5.4967E-4,6.3489E-4,6.0702E-4,4.6768E-4,4.6881E-4,5.5114E-4,6.3512E-4,6.0826E-4,4.6717E-4,4.6521E-4,5.5005E-4,6.3521E-4,6.1101E-4,4.6973E-4,4.648E-4,5.5165E-4,6.3704E-4,6.0964E-4,4.7033E-4,4.6336E-4,5.4871E-4,6.3603E-4,6.087E-4,4.6848E-4,4.634E-4,5.4715E-4,6.3222E-4,6.0885E-4,4.6999E-4,4.6153E-4,5.4402E-4,6.3012E-4,6.0832E-4,4.7084E-4,4.6418E-4,5.4513E-4,6.331E-4,6.0995E-4,4.6925E-4,4.5996E-4,5.4256E-4,6.3119E-4,6.1248E-4,4.7287E-4,4.6286E-4,5.4359E-4,6.3167E-4,6.1133E-4,4.7315E-4,4.5963E-4,5.4296E-4,6.3678E-4,6.1082E-4,4.7352E-4,4.6052E-4,5.4104E-4,6.3272E-4,6.1046E-4,4.7392E-4,4.5965E-4,5.395E-4,6.3114E-4,6.1037E-4,4.7418E-4,4.6108E-4,5.3789E-4,6.3243E-4,6.1153E-4,4.7447E-4,4.5786E-4,5.358E-4,6.3312E-4,6.1145E-4,4.7681E-4,4.5772E-4,5.3925E-4,6.3082E-4,6.109E-4,4.7576E-4,4.5685E-4,5.3638E-4,6.2925E-4,6.1055E-4,4.7742E-4,4.5728E-4,5.3302E-4,6.2898E-4,6.1186E-4,4.7834E-4,4.5413E-4,5.3328E-4,6.2786E-4,6.122E-4,4.7446E-4,4.5576E-4,5.3026E-4,6.3073E-4,6.1052E-4,4.7852E-4,4.5492E-4,5.2871E-4,6.2909E-4,6.1209E-4,4.7884E-4,4.5524E-4,5.3098E-4,6.2547E-4,6.1451E-4,4.7531E-4,4.5434E-4,5.2686E-4,6.2781E-4,6.1238E-4,4.7893E-4,4.5368E-4,5.2886E-4,6.2526E-4,6.124E-4,4.7947E-4,4.5232E-4,5.2417E-4,6.2802E-4,6.1188E-4,4.807E-4,4.5213E-4,5.2558E-4,6.2243E-4,6.1282E-4,4.8186E-4,4.5194E-4,5.2649E-4,6.2559E-4,6.1124E-4,4.7952E-4,4.5241E-4,5.2458E-4,6.225E-4,6.091E-4,4.8042E-4,4.5066E-4,5.2265E-4,6.209E-4,6.1064E-4,4.8223E-4,4.5112E-4,5.2123E-4,6.2396E-4,6.0898E-4,4.8246E-4,4.471E-4,5.1905E-4,6.1829E-4,6.1137E-4,4.8574E-4,4.4881E-4,5.1796E-4,6.1863E-4,6.1004E-4,4.8322E-4,4.4868E-4,5.189E-4,6.2022E-4,6.1139E-4,4.8445E-4,4.4712E-4,5.1722E-4,6.1897E-4,6.1011E-4,4.8495E-4,4.4554E-4,5.1567E-4,6.1635E-4,6.0942E-4,4.8279E-4,4.467E-4,5.1259E-4,6.1949E-4,6.1175E-4,4.8642E-4,4.4817E-4,5.1291E-4,6.1611E-4,6.0963E-4,4.8737E-4,4.4608E-4,5.1134E-4,6.178E-4,6.0811E-4,4.8077E-4,4.4205E-4,5.0428E-4,6.1186E-4,6.0586E-4,4.8551E-4,4.4339E-4,2.3693E-4:2
1.7333E-6,2.0667E-7,1.9167E-6,1.1E-6,3.7133E-6,-3.4767E-6,-4.2433E-6,-3.2E-7,-3.6333E-7,3.6E-7,-3.1233E-6,2.39E-6,2.2033E-6,-2.2233E-6,2.0267E-6,-6.4667E-7,5.13E-6,-2.8433E-6,-1.9267E-6,2.6933E-6,-5.6667E-7,7.2E-7,9.8E-7,-2.89E-6,7.07E-6,-3.5333E-7,5.9E-6,4.1167E-6,-4.1667E-7,6.11E-6,1.67E-6,2.7667E-7,5.5933E-6,-1.5333E-7,1.26E-6,4.129E-5,0.002078,0.0011396,0.0014609,5.9092E-4,0.0010318,9.8025E-4,0.0011748,0.0012222,7.3703E-4,9.1585E-4,0.0010187,0.0012216,0.0011586,8.074E-4,8.8178E-4,0.0010363,0.0012301,0.0011429,8.2566E-4,8.6791E-4,0.0010401,0.0012351,0.0011408,8.3114E-4,8.6594E-4,0.0010388,0.0012322,0.0011374,8.3059E-4,8.6511E-4,0.0010398,0.0012342,0.0011383,8.3396E-4,8.6494E-4,0.0010407,0.0012347,0.0011421,8.2947E-4,8.6614E-4,0.0010396,0.0012319,0.0011451,8.3302E-4,8.6716E-4,0.0010374,0.0012341,0.0011433,8.3038E-4,8.6333E-4,0.0010361,0.0012313,0.0011412,8.2982E-4,8.6456E-4,0.0010373,0.0012321,0.0011418,8.3046E-4,8.6184E-4,0.0010335,0.0012291,0.0011419,8.3049E-4,8.6539E-4,0.0010345,0.0012318,0.0011416,8.3261E-4,8.6288E-4,0.0010331,0.0012311,0.0011414,8.293E-4,8.6237E-4,0.0010342,0.0012299,0.0011432,8.32E-4,8.6185E-4,0.0010344,0.0012236,0.0011406,8.29E-4,8.6366E-4,0.0010337,0.0012257,0.0011399,8.2863E-4,8.6065E-4,0.0010356,0.0012276,0.0011391,8.3426E-4,8.6445E-4,0.0010328,0.0012308,0.0011419,8.2973E-4,8.6335E-4,0.0010299,0.0012247,0.0011414,8.3163E-4,8.6208E-4,0.0010311,0.0012269,0.0011407,8.3084E-4,8.6129E-4,0.0010321,0.0012249,0.0011419,8.363E-4,8.5813E-4,0.001029,0.0012259,0.001142,8.313E-4,8.555E-4,0.0010297,0.0012246,0.0011458,8.3108E-4,8.5945E-4,0.001029,0.0012263,0.0011398,8.2718E-4,8.6095E-4,0.0010285,0.0012195,0.0011385,8.3234E-4,8.5654E-4,0.0010245,0.001223,0.0011407,8.3227E-4,8.5701E-4,0.0010249,0.0012225,0.0011436,8.2885E-4,8.5553E-4,0.001025,0.0012188,0.0011391,8.34E-4,8.5215E-4,0.0010215,0.001224,0.0011407,8.2982E-4,8.5327E-4,0.0010251,0.0012223,0.0011393,8.3177E-4,8.5743E-4,0.0010223,0.0012202,0.0011434,8.3203E-4,8.4961E-4,0.0010253,0.0012207,0.0011391,8.3088E-4,8.5516E-4,0.0010231,0.0012168,0.0011415,8.2875E-4,8.4985E-4,0.0010207,0.001217,0.0011392,8.3343E-4,8.5094E-4,0.0010212,0.0012171,0.0011421,8.3146E-4,8.5149E-4,0.001022,0.0012172,0.001142,8.3336E-4,8.4965E-4,0.0010136,0.0012191,0.001139,8.3338E-4,8.5064E-4,0.0010177,0.0012135,0.0011407,8.3228E-4,8.4841E-4,0.001017,0.0012211,0.0011411,8.339E-4,8.4978E-4,0.0010121,0.0012093,0.00114,8.3245E-4,8.488E-4,0.0010156,0.0012156,0.0011399,8.3293E-4,8.4772E-4,0.0010147,0.0012123,0.0011392,8.3222E-4,8.4589E-4,0.0010136,0.0012149,0.0011365,8.3578E-4,8.4534E-4,0.001011,0.0012136,0.0011409,8.3336E-4,8.4367E-4,0.0010096,0.0012043,0.0011424,8.3096E-4,8.4613E-4,0.0010128,0.0012084,0.0011407,8.3643E-4,8.4514E-4,0.0010086,0.0012074,0.0011379,8.3427E-4,8.4365E-4,0.0010067,0.001208,0.0011396,8.3468E-4,8.4246E-4,0.0010046,0.0012071,0.0011361,8.3149E-4,8.4523E-4,0.0010056,0.0012065,0.0011357,8.3254E-4,8.4552E-4,0.0010083,0.0012062,0.0011393,8.3272E-4,8.3979E-4,0.0010032,0.001205,0.0011411,8.3139E-4,8.3854E-4,0.0010068,0.0012027,0.0011397,8.3582E-4,8.3961E-4,0.001004,0.0012036,0.0011431,8.3605E-4,8.3582E-4,0.0010046,0.0012031,0.0011395,8.3611E-4,8.368E-4,0.0010052,0.0012023,0.0011367,8.3642E-4,8.4224E-4,0.0010044,0.0012002,0.0011378,8.3408E-4,8.3505E-4,0.0010017,0.0012007,0.0011399,8.3492E-4,8.3318E-4,9.9864E-4,0.001199,0.0011349,8.3287E-4,8.3351E-4,9.984E-4,0.0011971,0.0011396,8.3817E-4,8.336E-4,9.9737E-4,0.0011964,0.0011388,8.3426E-4,8.3251E-4,9.9853E-4,0.0011951,0.0011377,8.3707E-4,8.2957E-4,9.9576E-4,0.0011927,0.0011343,8.369E-4,8.3132E-4,9.9448E-4,0.0011944,0.0011406,8.3957E-4,8.3039E-4,9.9136E-4,0.0011925,0.0011385,8.3773E-4,8.3338E-4,9.9591E-4,0.0011951,0.0011411,8.3905E-4,8.3278E-4,9.9104E-4,0.0011935,0.0011374,8.3818E-4,0.0:2
-2.1767E-6,9.2333E-7,-2.3333E-7,1.1433E-6,3.74E-6,1.5733E-6,3.38E-6,1.5333E-7,-1.4633E-6,3.3033E-6,-3.4233E-6,2.3467E-6,-1.3E-7,-2.3133E-6,2.3133E-6,-1.1067E-6,5.4333E-6,-2.97E-6,2.8967E-6,8.1E-7,-1.55E-6,2.0033E-6,6.5667E-7,3.0933E-6,1.5867E-6,1.1833E-6,6.1E-6,-2.5833E-6,9.7E-7,1.8917E-5,0.0017018,9.5191E-4,8.0771E-4,0.0011337,0.0013661,9.4104E-4,9.1409E-4,8.4076E-4,0.0011214,0.0012822,0.0010528,8.3257E-4,9.071E-4,0.0011132,0.0012717,0.0010879,8.124E-4,9.2235E-4,0.0011035,0.0012675,0.0011007,8.0523E-4,9.2409E-4,0.0011041,0.0012667,0.0011045,8.0755E-4,9.257E-4,0.0011014,0.001268,0.001105,8.1051E-4,9.2556E-4,0.0010973,0.0012677,0.0011142,8.0485E-4,9.1904E-4,0.0010992,0.0012652,0.0011114,8.1077E-4,9.1905E-4,0.0010949,0.0012663,0.0011114,8.15E-4,9.1775E-4,0.0010922,0.0012642,0.0011127,8.1147E-4,9.1854E-4,0.0010899,0.0012647,0.0011151,8.1607E-4,9.1375E-4,0.0010874,0.001261,0.0011158,8.1605E-4,9.0885E-4,0.0010899,0.0012569,0.0011184,8.1605E-4,9.0771E-4,0.0010819,0.001259,0.001126,8.191E-4,9.0175E-4,0.0010793,0.0012574,0.0011222,8.1534E-4,9.0124E-4,0.0010796,0.0012578,0.0011251,8.1996E-4,9.0255E-4,0.0010797,0.0012542,0.0011277,8.1988E-4,8.9705E-4,0.0010728,0.001255,0.0011286,8.2218E-4,8.9883E-4,0.0010742,0.0012505,0.0011314,8.1973E-4,8.928E-4,0.0010697,0.0012542,0.0011307,8.2495E-4,8.9441E-4,0.0010661,0.0012495,0.0011309,8.2065E-4,8.9198E-4,0.001065,0.0012476,0.0011292,8.2772E-4,8.8926E-4,0.001061,0.0012455,0.0011286,8.2549E-4,8.8561E-4,0.0010591,0.0012433,0.0011352,8.2289E-4,8.834E-4,0.0010611,0.0012468,0.0011388,8.2969E-4,8.7883E-4,0.001057,0.0012416,0.0011378,8.3143E-4,8.7791E-4,0.0010494,0.0012383,0.001139,8.2958E-4,8.7714E-4,0.0010501,0.001241,0.0011405,8.3266E-4,8.7333E-4,0.0010499,0.0012369,0.001143,8.3359E-4,8.7372E-4,0.0010496,0.0012367,0.0011453,8.3309E-4,8.6847E-4,0.001046,0.0012366,0.001149,8.3642E-4,8.6825E-4,0.0010428,0.001236,0.0011465,8.4142E-4,8.6449E-4,0.0010374,0.0012297,0.0011474,8.4174E-4,8.5851E-4,0.0010356,0.0012301,0.001148,8.4254E-4,8.6115E-4,0.0010356,0.0012285,0.0011519,8.403E-4,8.6076E-4,0.0010306,0.0012256,0.0011496,8.4307E-4,8.5703E-4,0.0010331,0.0012256,0.0011544,8.4903E-4,8.5794E-4,0.0010289,0.0012236,0.0011557,8.4927E-4,8.5167E-4,0.0010265,0.0012209,0.0011574,8.501E-4,8.5432E-4,0.0010243,0.0012194,0.0011563,8.4945E-4,8.4872E-4,0.0010203,0.0012226,0.0011596,8.5205E-4,8.5005E-4,0.001023,0.0012193,0.0011618,8.5466E-4,8.4671E-4,0.001021,0.0012186,0.001162,8.5344E-4,8.4823E-4,0.0010172,0.0012191,0.001164,8.5981E-4,8.4509E-4,0.0010139,0.0012167,0.0011628,8.6693E-4,8.4488E-4,0.0010096,0.0012158,0.001164,8.6702E-4,8.3793E-4,0.0010091,0.0012134,0.0011697,8.6514E-4,8.4035E-4,0.0010071,0.0012103,0.0011655,8.6807E-4,8.3667E-4,0.0010058,0.0012086,0.00117,8.6965E-4,8.3709E-4,0.001009,0.00121,0.0011732,8.7191E-4,8.3478E-4,0.0010003,0.0012055,0.0011663,8.727E-4,8.3319E-4,0.0010016,0.0012088,0.0011711,8.7818E-4,8.3152E-4,0.0010013,0.0012051,0.0011727,8.8098E-4,8.3069E-4,9.9922E-4,0.0012031,0.0011742,8.7901E-4,8.3188E-4,9.9335E-4,0.0012022,0.0011752,8.81E-4,8.2857E-4,9.9012E-4,0.0012023,0.0011733,8.8396E-4,8.2747E-4,9.8991E-4,0.0011992,0.001178,8.8835E-4,8.2562E-4,9.897E-4,0.0011968,0.0011824,8.9036E-4,8.2479E-4,9.847E-4,0.0011975,0.0011797,8.9198E-4,8.2468E-4,9.8402E-4,0.0011905,0.0011842,8.9478E-4,8.2416E-4,9.814E-4,0.0011966,0.0011824,8.9732E-4,8.2001E-4,9.8023E-4,0.0011949,0.0011812,8.9895E-4,8.2026E-4,9.8115E-4,0.0011892,0.0011841,9.0421E-4,8.2043E-4,9.7607E-4,0.0011923,0.0011842,9.063E-4,8.2064E-4,9.7309E-4,0.0011881,0.0011869,9.0683E-4,8.1805E-4,9.7612E-4,0.0011882,0.0011925,9.0941E-4,8.1858E-4,9.7179E-4,0.0011853,0.0011867,9.1337E-4,8.1747E-4,9.6784E-4,0.0011901,0.0011904,9.1421E-4,8.1318E-4,9.6649E-4,0.0011849,0.0011926,9.1734E-4,8.1348E-4,9.6631E-4,0.0011801,0.0011928,9.1824E-4,8.1576E-4,9.6065E-4,0.0011839,0.0011928,9.2344E-4,8.1413E-4,9.6613E-4,0.0011823,0.0011934,9.236E-4,8.1148E-4,9.5987E-4,0.001176,0.0011951,9.2788E-4,8.1127E-4,9.6121E-4,0.001178,0.0011936,9.2758E-4,8.0885E-4,9.5662E-4,0.0011796,0.0011935,9.3331E-4,8.1243E-4,9.523E-4,0.0011714,0.0:2
3.9567E-6,3.8133E-6,2.68E-6,3.3833E-6,-5.42E-6,1.8767E-6,1.3033E-6,2.35E-6,2.0933E-6,3.5067E-6,1.45E-6,7.8767E-6,4.9333E-7,2.24E-6,-3.1667E-7,9.4667E-7,2.5167E-6,4.3E-7,2.6433E-6,-1.8E-7,2.04E-6,1.1067E-6,-2.8667E-7,1.6833E-6,-6.2667E-7,8.9E-7,9.4667E-7,-2.2567E-6,2.64E-6,-7.9333E-7,6.9667E-7,4.02E-6,-1.6467E-6,2.62E-6,4.0333E-7,7.5667E-7,1.4533E-6,-1.4333E-7,0.0014043,9.8363E-4,9.8651E-4,0.0011891,0.0013615,7.4273E-4,9.5201E-4,9.609E-4,0.0012195,0.0012402,8.5518E-4,8.762E-4,0.001005,0.0012349,0.001211,8.9265E-4,8.5299E-4,0.0010163,0.0012381,0.0012055,8.9902E-4,8.48E-4,0.0010128,0.0012308,0.0012082,9.0822E-4,8.4593E-4,0.001014,0.0012318,0.0012043,9.1055E-4,8.4688E-4,0.0010098,0.0012292,0.0012111,9.0849E-4,8.4256E-4,0.0010085,0.00123,0.0012101,9.1105E-4,8.4359E-4,0.0010051,0.001229,0.0012081,9.1636E-4,8.3869E-4,0.0010055,0.0012237,0.0012085,9.1868E-4,8.3697E-4,0.0010009,0.0012245,0.0012099,9.1809E-4,8.3698E-4,9.9829E-4,0.0012211,0.001212,9.2036E-4,8.3634E-4,9.9777E-4,0.0012227,0.0012084,9.1868E-4,8.365E-4,9.9447E-4,0.0012171,0.0012106,9.2742E-4,8.35E-4,9.9303E-4,0.0012179,0.0012107,9.1905E-4,8.3257E-4,9.8772E-4,0.0012148,0.0012094,9.2239E-4,8.3377E-4,9.8441E-4,0.0012069,0.0012102,9.3066E-4,8.2612E-4,9.8345E-4,0.0012074,0.001207,9.2953E-4,8.3199E-4,9.821E-4,0.0012046,0.0012102,9.3179E-4,8.3005E-4,9.7911E-4,0.0012035,0.0012141,9.368E-4,8.2812E-4,9.7769E-4,0.0012044,0.0012155,9.3715E-4,8.2716E-4,9.7305E-4,0.0011989,0.0012123,9.3838E-4,8.2223E-4,9.7283E-4,0.0011992,0.0012108,9.4335E-4,8.221E-4,9.6676E-4,0.0011987,0.0012081,9.4319E-4,8.2248E-4,9.6795E-4,0.0011905,0.0012143,9.4312E-4,8.2433E-4,9.6503E-4,0.0011905,0.0012116,9.4528E-4,8.2155E-4,9.6072E-4,0.0011878,0.001213,9.4613E-4,8.1777E-4,9.6126E-4,0.0011903,0.0012122,9.48E-4,8.1838E-4,9.5715E-4,0.0011885,0.0012096,9.5389E-4,8.1945E-4,9.5164E-4,0.0011869,0.0012085,9.5716E-4,8.1643E-4,9.5152E-4,0.001181,0.0012092,9.5473E-4,8.1607E-4,9.4677E-4,0.0011825,0.0012094,9.5743E-4,8.1885E-4,9.4684E-4,0.0011808,0.0012138,9.5921E-4,8.1276E-4,9.4272E-4,0.0011791,0.0012083,9.576E-4,8.1573E-4,9.4103E-4,0.0011754,0.0012109,9.6639E-4,8.1553E-4,9.4041E-4,0.001173,0.001212,9.6958E-4,8.1347E-4,9.3804E-4,0.0011765,0.0012123,9.6793E-4,8.1593E-4,9.3171E-4,0.0011689,0.0012087,9.7243E-4,8.1429E-4,9.321E-4,0.0011694,0.0012097,9.7258E-4,8.1279E-4,9.2918E-4,0.0011699,0.0012129,9.7299E-4,8.1111E-4,9.2852E-4,0.0011656,0.001215,9.7718E-4,8.1238E-4,9.3215E-4,0.0011645,0.0012106,9.7478E-4,8.1337E-4,9.2616E-4,0.0011625,0.0012118,9.7869E-4,8.1273E-4,9.2379E-4,0.0011604,0.0012093,9.8478E-4,8.134E-4,9.2059E-4,0.0011621,0.0012113,9.8806E-4,8.1348E-4,9.1826E-4,0.0011613,0.0012088,9.894E-4,8.0911E-4,9.1812E-4,0.0011579,0.0012112,9.9191E-4,8.0635E-4,9.1861E-4,0.0011553,0.0012144,9.9091E-4,8.1124E-4,9.1201E-4,0.0011547,0.0012123,9.9474E-4,8.0958E-4,9.1204E-4,0.001154,0.001211,9.9365E-4,8.1165E-4,9.0666E-4,0.0011532,0.0012081,0.0010004,8.1024E-4,9.062E-4,0.0011483,0.001209,0.0010012,8.0873E-4,9.0978E-4,0.0011464,0.0012148,0.0010015,8.1221E-4,9.0511E-4,0.0011477,0.0012115,0.0010056,8.1264E-4,8.986E-4,0.0011461,0.0012123,0.0010106,8.0758E-4,8.9905E-4,0.0011472,0.0012126,0.00101,8.0989E-4,8.9839E-4,0.0011429,0.0012115,0.0010132,8.0984E-4,8.9657E-4,0.001142,0.0012096,0.001013,8.1197E-4,8.9159E-4,0.0011398,0.0012136,0.0010177,8.089E-4,8.8843E-4,0.0011407,0.0012088,0.0010189,8.0885E-4,8.8778E-4,0.0011393,0.0012118,0.0010189,8.092E-4,8.8685E-4,0.0011354,0.001211,0.0010263,8.1019E-4,8.8573E-4,0.0011337,0.0012079,0.0010284,8.0912E-4,8.849E-4,0.0011306,0.0012059,0.0010291,8.1053E-4,8.8694E-4,0.0011286,0.0012112,0.0010336,8.1483E-4,8.8328E-4,0.0011305,0.0012081,0.0010355,8.1032E-4,8.7956E-4,0.001129,0.001209,0.001036,8.0617E-4,8.7905E-4,0.0011259,0.0012099,0.0010404,8.1353E-4,8.7341E-4,0.001127,0.0012115,0.001043,8.1401E-4,8.7656E-4,0.001123,0.0012083,0.0010465,8.1356E-4,8.7195E-4,0.0011225,0.0012095,0.0010469,8.1449E-4,8.7233E-4,0.001125,0.0012068,0.001049,8.1623E-4,8.6612E-4,0.0011222,0.0012074,0.0010502,8.1453E-4,8.688E-4,0.0011186,0.001207,0.0010517,8.2029E-4,8.6342E-4,0.0011194,0.0012072,0.0010541,8.2009E-4,8.6304E-4,0.0011186,0.0012062,0.0010555,8.1804E-4,0.0:2
-0.16758,-0.18228,-0.2388,-0.29334,-0.34826,-0.1728,-0.18855,-0.24726,-0.29289,-0.3456,-0.16492,-0.18166,-0.23278,-0.28809,-0.34937,-0.171,-0.18355,-0.23926,-0.29605,-0.34758,-0.16316,-0.18248,-0.22614,-0.28758,-0.34865,-0.17307,-0.17694,-0.23792,-0.29667,-0.34506,-0.16537,-0.18705,-0.23558,-0.28681,3.6797,3.9495,4.171,4.9155,4.7439,3.6143,3.7243,4.2778,4.8775,4.6835,3.6746,3.6678,4.3004,4.881,4.683,3.695,3.6498,4.3122,4.8707,4.6636,3.6894,3.6474,4.2962,4.8589,4.6715,3.6789,3.6372,4.2862,4.8452,4.6573,3.6736,3.6329,4.2801,4.8379,4.6775,3.6678,3.6317,4.2832,4.8548,4.6929,3.6801,3.6515,4.2935,4.8706,4.6976,3.7005,3.663,4.3103,4.9041,4.7114,3.7172,3.6734,4.3078,4.898,4.7093,3.7029,3.6487,4.2916,4.8697,4.6658,3.6775,3.6253,4.2729,4.8534,4.6807,3.6831,3.6355,4.2853,4.8724,4.6833,3.7077,3.6529,4.3042,4.8861,4.6873,3.6894,3.6305,4.2739,4.8483,4.6461,3.6667,3.6084,4.2628,4.8286,4.664,3.6896,3.6293,4.2814,4.8099,4.6247,3.6403,3.5663,4.1887,4.7557,4.5585,3.5844,3.5221,4.16,4.7773,4.6219,3.6742,3.602,4.2533,4.853,4.6624,3.6822,3.6046,4.242,4.8259,4.6205,3.6506,3.5856,4.2451,4.8318,4.6449,3.6823,3.6112,4.2589,4.8451,4.6471,3.6631,3.5883,4.22,4.8157,4.6218,3.6632,3.5995,4.2594,4.8567,4.6476,3.6664,3.5866,4.2167,4.7986,4.6126,3.6535,3.5841,4.2447,4.8242,4.6504,3.6654,3.5763,4.221,4.7781,4.6063,3.6342,3.5648,4.2181,4.7948,4.6409,3.6509,3.5687,4.2001,4.7618,4.5985,3.63,3.5569,4.199,4.7933,4.6199,3.645,3.5495,4.1721,4.7603,4.5784,3.6206,3.5557,4.195,4.7978,4.5967,3.6263,3.536,4.1654,4.7583,4.5848,3.6308,3.5492,4.1863,4.7669,4.5723,3.6133,3.5141,4.1545,4.7612,4.5927,3.6336,3.5336,4.1579,4.7253,4.5576,3.5993,3.5117,4.155,4.7511,4.5791,3.6067,3.5008,4.1259,4.7049,4.5598,3.5994,3.515,4.1424,4.7097,4.5397,3.5647,3.4749,4.1222,4.7156,4.5626,3.5868,3.4838,4.0976,4.6799,4.5287,3.5831,3.4907,4.1165,4.6933,4.5196,3.5558,3.4546,4.0935,4.6937,4.5392,3.5705,3.4692,4.0751,4.653,4.5096,3.5669,3.4702,4.0901,4.6756,4.4897,3.5425,3.4471,4.0736,4.682,4.5174,3.545,3.4306,4.0507,4.6481,4.4929,3.5669,3.4474,4.0689,4.6349,4.4736,3.5438,3.4376,4.0769,4.6657,4.4743,3.5262,3.4148,4.0498,4.6407,4.4874,3.5369,3.4072,4.0338,4.6082,4.4782,3.5428,3.4188,4.0399,4.5983,4.4579,3.513,3.4143,4.0324,4.6197,4.4632,3.5018,0.0:2
-0.27547,-0.32748,-0.29442,-0.13866,-0.19847,-0.27794,-0.32498,-0.29843,-0.13364,-0.20091,-0.27743,-0.32405,-0.28863,-0.13646,-0.20308,-0.26823,-0.32095,-0.29342,-0.13611,-0.2144,-0.26037,-0.32972,-0.28986,-0.1377,-0.21211,-0.26589,-0.32396,1.5012,4.0034,4.6342,4.92,4.1932,3.5232,3.9005,4.6192,4.8826,4.2149,3.4925,3.9141,4.6162,4.9133,4.2149,3.4823,3.9163,4.6287,4.894,4.2237,3.5008,3.9356,4.6547,4.9266,4.2409,3.5141,3.9482,4.6654,4.9287,4.2364,3.5158,3.9465,4.6664,4.9257,4.2336,3.5158,3.9439,4.6552,4.9198,4.2297,3.4991,3.9396,4.6362,4.9034,4.205,3.4822,3.9216,4.6125,4.8921,4.1863,3.471,3.9222,4.6142,4.9051,4.1925,3.5021,3.949,4.6549,4.9314,4.2152,3.5186,3.9691,4.6741,4.9405,4.2097,3.5084,3.9432,4.6419,4.8999,4.172,3.4825,3.9144,4.6261,4.8949,4.1686,3.4948,3.9391,4.6538,4.9122,4.1997,3.5102,3.9513,4.673,4.8899,4.1757,3.4838,3.9224,4.6302,4.876,4.1429,3.4665,3.9238,4.6442,4.8879,4.1633,3.4891,3.9475,4.6516,4.8965,4.1485,3.4699,3.9166,4.6058,4.8509,4.1218,3.4646,3.9185,4.6386,4.8883,4.1495,3.4833,3.9388,4.6346,4.8634,4.1125,3.4523,3.9003,4.5996,4.8374,4.1274,3.4667,3.9349,4.6481,4.8704,4.1201,3.4562,3.9076,4.5979,4.8306,4.0911,3.4456,3.9192,4.6284,4.8547,4.1125,3.4481,3.9007,4.5866,4.8112,4.0649,3.418,3.9001,4.6109,4.8243,4.0961,3.4357,3.8922,4.5797,4.7809,4.0461,3.4114,3.8858,4.6026,4.8111,4.079,3.435,3.8948,4.5814,4.7745,4.0383,3.4035,3.8915,4.5982,4.8033,4.0572,3.415,3.8897,4.5507,4.7788,4.0292,3.4068,3.8951,4.6014,4.8112,4.0249,3.4038,3.8792,4.5455,4.7482,4.0183,3.4077,3.8952,4.5835,4.7591,3.9969,3.373,3.853,4.5603,4.764,4.0009,3.4004,3.8732,4.5465,4.7167,3.9609,3.3674,3.8648,4.5641,4.7461,3.9775,3.3618,3.8524,4.5185,4.7124,3.9762,3.372,3.8724,4.532,4.7139,3.9357,3.3368,3.8488,4.53,4.7288,3.9556,3.3523,3.8473,4.5006,4.701,3.9282,3.3555,3.8543,4.5237,4.691,3.8976,3.3342,3.8282,4.5287,4.7037,3.9251,3.3395,3.8184,4.484,4.6656,3.9122,3.3485,3.8369,4.5071,4.663,3.8781,3.3102,3.8283,4.5148,4.673,3.8851,3.3103,3.8084,4.4768,4.6525,3.8871,3.3229,3.8154,4.4765,4.6155,3.8549,3.305,3.8204,4.4921,4.6311,3.8318,3.2806,3.7916,4.4768,4.6269,3.8586,3.2945,3.7925,4.4516,4.6093,3.8389,3.2948,3.8082,4.4547,4.5893,3.8179,3.2727,3.8018,4.4745,4.6056,3.8058,3.2599,3.7844,4.4579,4.6053,3.8208,3.2678,3.7901,4.4278,4.5845,3.8118,3.2832,3.7964,4.4379,4.5631,3.7751,3.2593,3.7934,4.4479,4.5808,3.7586,3.2487,3.7714,4.4567,4.5916,3.7654,3.2445,3.7674,4.423,4.5635,3.7746,3.2583,3.7679,4.4083,4.5422,3.7525,3.2534,3.7819,4.4251,4.5201,3.7465,3.2384,3.7621,4.4151,4.5152,3.7238,3.2083,3.7519,4.4085,4.5274,3.7228,3.208,3.75,4.373,4.5336,3.7291,3.2199,3.7462,4.3627,4.5055,3.714,3.2226,3.7654,4.3807,4.5006,3.7011,3.2264,3.7503,4.3967,4.5068,3.6852,3.2056,3.7446,4.3961,4.5045,3.686,3.1996,3.7377,4.3961,4.4919,2.0206:2
-0.24084,-0.21981,-0.22413,-0.12501,-0.22709,-0.24331,-0.221,-0.22155,-0.12385,-0.21496,-0.24577,-0.22313,-0.21969,-0.1248,-0.21623,-0.24537,-0.22384,-0.22705,-0.12583,-0.21084,-0.23485,-0.21857,-0.22313,-0.12942,-0.21478,-0.23955,-0.22249,-0.22761,-0.12274,-0.22363,-0.24514,-0.21371,-0.22512,-0.12353,-0.22146,-0.25146,-0.222,-0.22473,0.41045,10.447,10.131,8.7604,7.2369,8.5534,9.8132,10.163,8.6005,7.4048,8.4109,9.8583,10.195,8.5863,7.4536,8.3906,9.8709,10.179,8.597,7.4467,8.3546,9.8439,10.181,8.5979,7.4513,8.3491,9.8379,10.18,8.5991,7.4556,8.3424,9.8271,10.205,8.6095,7.439,8.312,9.8149,10.188,8.6236,7.4529,8.3011,9.7948,10.19,8.6303,7.4438,8.2885,9.7875,10.184,8.6351,7.4457,8.26,9.7658,10.189,8.6325,7.4305,8.2421,9.7514,10.19,8.6469,7.4347,8.2313,9.738,10.191,8.6634,7.4358,8.2142,9.7197,10.181,8.659,7.4197,8.1963,9.7097,10.163,8.6577,7.4148,8.1705,9.6795,10.16,8.6686,7.4153,8.1593,9.6658,10.154,8.6674,7.4071,8.1388,9.6461,10.142,8.6676,7.3912,8.1174,9.6191,10.14,8.6719,7.3935,8.0909,9.6019,10.122,8.6643,7.3768,8.0745,9.5794,9.0161,6.145,5.3876,6.0812,7.2516,7.4122,6.1546,5.341,6.1021,7.205,7.4077,6.1639,5.3243,6.0914,7.1893,7.4032,6.172,5.3116,6.0777,7.1768,7.3881,6.1776,5.3089,6.0749,7.1763,7.3873,6.1743,5.3061,6.0612,7.1578,7.3845,6.1834,5.298,6.0451,7.1445,7.3788,6.1764,5.2908,6.0323,7.1321,7.377,6.1876,5.287,6.0198,7.1213,7.3614,6.1839,5.2849,6.0085,7.1124,7.3687,6.1913,5.2843,5.9941,7.0995,7.3676,6.1971,5.2711,5.9804,7.0895,7.3706,6.1979,5.2771,5.9633,7.0795,7.361,6.2085,5.2612,5.9628,7.0806,7.3572,6.2115,5.2678,5.9463,7.0656,7.3539,6.2127,5.2708,5.9445,7.056,7.3649,6.2173,5.2617,5.9245,7.0457,7.3629,6.231,5.2659,5.9161,7.0338,7.3528,6.2308,5.2545,5.899,7.0266,7.3474,6.2499,5.2519,5.8824,7.0064,7.354,6.2434,5.2542,5.8811,7.0051,7.3509,6.253,5.2523,5.8618,7.0018,7.343,6.26,5.2476,5.8524,6.9868,7.3342,6.2649,5.2469,5.8431,6.9772,7.3471,6.2862,5.2487,5.8327,6.9703,7.3424,6.2768,5.2456,5.8195,6.9552,7.346,6.2901,5.2449,5.8169,6.9437,7.3349,6.2879,5.2379,5.7977,6.9324,7.3262,6.302,5.2455,5.7893,6.919,7.3298,6.3034,5.234,5.7718,6.911,7.3316,6.308,5.2493,5.7702,6.9159,7.331,6.3242,5.2363,5.7503,6.8971,7.3234,6.3279,5.2402,5.7462,6.8882,7.3282,6.3431,5.2444,5.7467,6.8872,7.3319,6.3466,5.2349,5.718,6.8687,7.3245,6.3528,5.2441,5.7196,6.8683,7.3285,6.3662,5.2408,5.7138,6.8558,7.3241,6.3714,5.2564,5.7068,6.8545,7.3383,6.3853,5.2405,5.6909,6.8367,7.3269,6.3867,5.2514,5.6813,6.8396,7.3204,6.3958,5.2534,5.6757,6.8233,7.3264,6.4135,5.2567,5.6727,6.8202,7.3265,6.4183,5.2463,5.6611,6.8028,7.3229,6.4253,5.2621,5.6564,6.8044,7.3164,6.4267,5.2545,5.6387,6.7915,7.324,6.4437,5.2591,5.6346,6.7763,7.3221,6.4487,5.26,5.6267,6.7743,7.3332,6.4639,5.2666,5.6238,6.7623,7.3129,6.4654,5.2685,5.6048,6.7565,7.3158,6.475,5.2717,5.6037,6.7464,7.3201,6.4814,5.2702,5.5976,6.7375,7.3128,6.4946,5.2717,5.588,6.7279,7.3006,6.4892,5.2653,5.5715,6.7322,7.307,6.5155,5.2772,5.5571,6.7133,7.3122,6.5229,5.2886,5.5542,6.7039,7.3119,6.5233,5.2825,5.5536,6.7019,7.3083,6.5169,5.283,5.5384,6.6903,7.2994,6.5463,5.2874,5.5361,6.6885,0.0:2
-0.19472,-0.13283,-0.21984,-0.27424,-0.16863,-0.19121,-0.13941,-0.21729,-0.27297,-0.17304,-0.18642,-0.14107,-0.21809,-0.26883,-0.1643,-0.19004,-0.13886,-0.2266,-0.26417,-0.17385,-0.19037,-0.13477,-0.22413,-0.27066,-0.17495,-0.18253,1.9242,10.66,8.972,7.9088,7.3839,9.3565,10.089,9.1831,7.6277,7.6319,9.228,10.122,9.2558,7.595,7.6732,9.1963,10.132,9.2689,7.5946,7.6607,9.1947,10.132,9.2661,7.5928,7.6555,9.1706,10.126,9.281,7.5918,7.65,9.1617,10.107,9.2897,7.5991,7.6363,9.1361,10.118,9.2884,7.6014,7.6232,9.1223,10.095,9.3102,7.6064,7.6149,9.1041,10.106,9.3046,7.6138,7.6073,9.0967,10.108,9.3142,7.6165,7.592,9.0874,10.086,9.3214,7.6073,7.5684,9.0663,10.076,9.3175,7.6167,7.5701,9.0473,10.073,9.3281,7.6164,7.5641,9.0358,10.052,9.3386,7.6139,7.5449,9.0207,10.038,9.3351,7.6141,7.5167,8.9885,10.029,9.3387,7.6104,7.5096,8.9809,10.025,9.3466,7.6161,7.5148,8.965,10.013,9.3471,7.6191,7.494,8.9395,10.004,9.3447,7.6082,7.4865,8.9226,9.9907,7.8781,5.3612,5.6116,6.7409,7.3881,6.7365,5.4074,5.5553,6.7663,7.3729,6.7218,5.4252,5.5367,6.7546,7.3618,6.7222,5.4194,5.5225,6.7495,7.3509,6.7395,5.4284,5.5141,6.7347,7.3554,6.7369,5.4255,5.4998,6.7221,7.3549,6.7408,5.4148,5.4877,6.7072,7.3364,6.7528,5.4212,5.476,6.6959,7.3306,6.7523,5.4305,5.4709,6.6835,7.3287,6.7505,5.423,5.4569,6.673,7.318,6.7527,5.424,5.4511,6.6606,7.321,6.7542,5.4353,5.4397,6.6438,7.3092,6.7609,5.4299,5.4316,6.6356,7.2986,6.7694,5.4316,5.4139,6.6314,7.2905,6.7666,5.4355,5.4126,6.6137,7.2946,6.7715,5.4387,5.3982,6.5943,7.2897,6.7779,5.438,5.3906,6.5852,7.2747,6.7832,5.4379,5.3843,6.5796,7.273,6.8041,5.445,5.3725,6.5638,7.2667,6.7991,5.4516,5.3647,6.5617,7.2655,6.806,5.4506,5.3539,6.5412,7.2721,6.8116,5.4546,5.3566,6.5359,7.2441,6.8258,5.461,5.338,6.5273,7.2557,6.8129,5.4582,5.3459,6.5078,7.25,6.8297,5.4681,5.3363,6.51,7.2434,6.8378,5.4623,5.3302,6.4936,7.2424,6.8452,5.4708,5.3169,6.4835,7.2384,6.8518,5.474,5.3104,6.4683,7.2376,6.8557,5.4807,5.3036,6.4616,7.2265,6.8511,5.4975,5.2984,6.4494,7.2242,6.8642,5.4916,5.2894,6.4379,7.2227,6.8707,5.5009,5.2843,6.432,7.2216,6.8763,5.5145,5.2811,6.4213,7.2049,6.8847,5.5056,5.2752,6.4024,7.1892,6.896,5.5151,5.2647,6.3936,7.1991,6.8985,5.521,5.2554,6.3912,7.1944,6.9014,5.5281,5.2512,6.3823,7.1934,6.9063,5.5329,5.248,6.362,7.1809,6.9113,5.5392,5.2443,6.362,7.1831,6.9178,5.5462,5.2406,6.3536,7.1811,6.9274,5.5523,5.2403,6.3404,7.1784,6.9385,5.5583,5.2265,6.3296,7.1756,6.9423,5.5668,5.2316,6.3238,7.1648,6.9437,5.5779,5.2161,6.3082,7.1656,6.9441,5.5796,5.2219,6.2941,7.162,6.9611,5.5895,5.2148,6.285,7.1636,6.9725,5.5937,5.2186,6.2865,7.1516,6.9811,5.5982,5.2098,6.2802,7.1502,6.9813,5.6127,5.2037,6.2609,7.1443,6.9906,5.6196,5.2044,6.2513,7.1358,6.9928,5.6206,5.1929,6.2357,7.1272,7.0079,5.6274,5.193,6.2276,7.1243,6.999,5.6329,5.1824,6.2216,7.1143,7.0093,5.644,5.1724,6.2017,7.1194,7.0067,5.6517,5.1716,6.1945,7.1149,7.0024,5.6554,5.1703,6.1815,7.1082,7.0146,5.6688,5.1654,6.1751,7.0955,7.021,5.6643,5.164,6.1652,7.091,7.0279,5.6776,5.158,6.1503,7.0797,7.0332,5.6891,5.1571,6.1433,7.0873,7.0243,5.6946,0.0:2
-0.17251,-0.18415,-0.13408,-0.22412,-0.27255,-0.17281,-0.18139,-0.13924,-0.22824,-0.26255,-0.17365,-0.18072,-0.13736,-0.21835,-0.26767,-0.17994,-0.18235,-0.13629,-0.2217,-0.26854,-0.17398,-0.18312,-0.14537,-0.21903,-0.2646,-0.17559,-0.1927,-0.14214,-0.21756,-0.26602,-0.17597,-0.1905,-0.13501,-0.21608,7.9792,7.7982,7.2791,9.2504,9.9653,9.0717,7.5561,7.5054,9.101,9.9735,9.1269,7.5025,7.5598,9.066,9.9787,9.1561,7.5041,7.5432,9.0403,9.9891,9.1727,7.4973,7.5439,9.0352,9.9716,9.1947,7.5126,7.5374,9.0249,9.9859,9.2153,7.5184,7.5189,9.0021,9.9683,9.2239,7.5283,7.5167,8.9823,9.9675,9.2331,7.5348,7.493,8.9657,9.9725,9.2496,7.5414,7.4812,8.9464,9.9632,9.2583,7.5544,7.481,8.9331,9.9555,9.2653,7.5574,7.466,8.9167,9.9374,9.2737,7.5573,7.4485,8.8955,9.942,9.2928,7.5602,7.4452,8.8647,9.9211,9.2982,7.5744,7.4222,8.838,9.8996,9.3045,7.5686,7.4046,8.8126,9.8822,9.3127,7.5785,7.3836,8.7929,9.8827,9.3187,7.5701,7.3769,8.7711,9.8666,9.3257,7.5775,7.362,8.747,9.8485,9.329,7.5722,7.338,8.7211,9.8402,9.3232,7.4443,5.7585,6.5699,7.2833,6.7516,5.356,5.456,6.6063,7.2668,6.7322,5.395,5.4132,6.6091,7.2609,6.7327,5.3958,5.3999,6.5855,7.2572,6.7405,5.3998,5.3872,6.5779,7.2469,6.7531,5.406,5.3809,6.5643,7.2289,6.7584,5.4077,5.3624,6.5469,7.2427,6.7645,5.4153,5.3496,6.5372,7.2328,6.7715,5.413,5.3449,6.5176,7.2204,6.7833,5.4136,5.341,6.5052,7.2131,6.7858,5.4187,5.3163,6.4991,7.2065,6.7962,5.4252,5.3133,6.4782,7.2053,6.7997,5.4413,5.3,6.4595,7.1987,6.8126,5.4402,5.2859,6.4529,7.1854,6.8202,5.4482,5.2823,6.4278,7.1814,6.8251,5.4549,5.2774,6.4152,7.1792,6.8323,5.456,5.2645,6.3959,7.1708,6.8346,5.4635,5.2584,6.3844,7.1613,6.8534,5.4608,5.2384,6.3658,7.153,6.8486,5.4793,5.2368,6.3601,7.1431,6.8545,5.4895,5.2193,6.3374,7.1423,6.867,5.4812,5.2262,6.3336,7.1302,6.872,5.504,5.207,6.3183,7.1355,6.8754,5.5041,5.2064,6.2991,7.1238,6.8922,5.5157,5.1948,6.2893,7.117,6.907,5.5318,5.1852,6.2703,7.1113,6.9061,5.5336,5.1813,6.2555,7.1035,6.9161,5.5373,5.1783,6.2376,7.0888,6.9145,5.5464,5.1662,6.2301,7.0959,6.9334,5.5555,5.1665,6.2115,7.0852,6.9426,5.5706,5.1604,6.1984,7.073,6.9419,5.584,5.1479,6.1871,7.0655,6.9483,5.5929,5.1507,6.1762,7.0596,6.9616,5.5972,5.1479,6.1624,7.0618,6.9527,5.614,5.1291,6.1514,7.0455,6.9742,5.6171,5.1299,6.1337,7.0551,6.9707,5.6277,5.1258,6.1144,7.0412,6.9882,5.6428,5.1267,6.1109,7.0367,6.9924,5.6534,5.116,6.0959,7.0317,6.9871,5.6662,5.1103,6.0796,7.0149,7.0031,5.6725,5.107,6.0703,7.0086,7.0072,5.6828,5.104,6.0515,7.0074,7.0026,5.6996,5.0988,6.0402,7.0032,7.0133,5.7053,5.0914,6.0307,6.9887,7.0233,5.7164,5.0932,6.009,6.9794,7.0313,5.7286,5.0842,5.9991,6.9696,7.0407,5.7374,5.0885,5.9798,6.9627,7.0391,5.7439,5.0831,5.9691,6.9588,7.0516,5.7615,5.0838,5.9563,6.9549,7.0512,5.7723,5.0854,5.944,6.9392,7.0516,5.786,5.0698,5.931,6.9378,7.0679,5.7918,5.0738,5.9183,6.9262,7.0646,5.812,5.0727,5.9047,6.927,7.0646,5.8221,5.0696,5.8881,6.9131,7.0638,5.8444,5.071,5.8776,6.9094,7.0714,5.8524,5.0697,5.8603,6.8957,7.0786,5.8654,5.0695,5.845,6.8872,7.0981,5.8759,5.0646,5.8328,6.8915,7.0887,5.8999,4.355:2
-0.0017276,4.1178E-4,-0.0026079,-7.6628E-4,-2.3451E-4,-0.0034999,0.0023098,-8.5341E-4,-0.0016212,-7.8313E-4,-0.0010528,0.0012251,-0.0012659,-6.3778E-4,2.36E-4,-0.0015611,0.002818,-0.0020904,1.8563E-4,-0.0012986,6.0303E-4,1.4455E-4,-0.0013598,-0.0018325,-0.0032657,0.78874,0.93722,0.87742,1.1131,1.1905,1.0818,0.88964,0.91367,1.0998,1.1907,1.0941,0.88824,0.91942,1.0972,1.1925,1.0992,0.89112,0.92106,1.0989,1.1952,1.1056,0.89343,0.91913,1.0958,1.197,1.1082,0.8949,0.91671,1.0946,1.1979,1.1134,0.89751,0.91908,1.0928,1.2007,1.1174,0.89675,0.9174,1.0899,1.199,1.1208,0.89977,0.91613,1.0874,1.2011,1.1253,0.90266,0.9164,1.0851,1.2073,1.1254,0.9052,0.91413,1.0824,1.2056,1.1303,0.90645,0.91127,1.0803,1.2086,1.134,0.91421,0.91237,1.084,1.206,1.1372,0.91204,0.91361,1.0815,1.2093,1.1402,0.91454,0.90919,1.0762,1.2068,1.1443,0.91847,0.91073,1.077,1.208,1.2247,1.1545,1.0378,1.1777,1.2901,1.2261,0.9826,0.96816,1.1422,1.2769,1.2493,0.9848,0.96284,1.1558,1.3428,1.2878,1.0317,1.0005,1.19,1.3334,1.2823,1.0362,0.98909,1.1342,1.2605,1.2014,0.96691,0.9666,1.1439,1.2937,1.2487,1.0069,0.97262,1.162,1.3104,1.2599,1.0145,0.97002,1.1429,1.3043,1.2542,1.0026,0.95643,1.1272,1.2849,1.2425,1.0063,0.95337,1.1252,1.2863,1.2463,1.0085,0.95195,1.1222,1.279,1.2472,1.0099,0.94425,1.1149,1.2696,1.2391,1.0049,0.93952,1.1033,1.2643,1.2372,1.0054,0.93695,1.1017,1.2566,1.238,1.0054,0.93397,1.0943,1.2561,1.2336,1.0054,0.93366,1.0921,1.2595,1.2371,1.0104,0.93308,1.0921,1.2663,1.246,1.0176,0.93422,1.0881,1.267,1.2462,1.0219,0.93826,1.0904,1.2659,1.2518,1.0294,0.93981,1.0904,1.2668,1.2532,1.0308,0.93603,1.0874,1.2612,1.2531,1.0363,0.9381,1.0864,1.2701,1.2622,1.0383,0.9417,1.0844,1.2681,1.2621,1.0433,0.93968,1.0892,1.2688,1.2655,1.0469,0.94193,1.0796,1.2667,1.2656,1.0498,0.9405,1.0806,1.2662,1.2733,1.0581,0.94601,1.082,1.2668,1.2741,1.0604,0.94239,1.0794,1.2673,1.2753,1.0657,0.9401,1.0778,1.2646,1.2773,1.0656,0.94306,1.0756,1.2664,1.278,1.0721,0.94176,1.0709,1.2657,1.2825,1.0747,0.94451,1.0718,1.2635,1.2812,1.0794,0.94134,1.0715,1.2627,1.2839,1.0835,0.94191,1.0668,1.261,1.2906,1.0844,0.94216,1.0646,1.2614,1.2878,1.0899,0.94617,1.0622,1.2615,1.2891,1.0894,0.94599,1.0568,1.2581,1.2901,1.0965,0.9495,1.0597,1.2618,1.2951,1.1023,0.94955,1.0575,1.2635,1.2926,1.1081,0.95008,1.0703,1.2906,1.3269,1.1358,0.9774,1.0732,1.2742,1.2999,1.1178,0.95278,1.0524,1.2574,1.2994,1.1177,0.9479,1.0553,1.2531,1.2994,1.1212,0.95359,1.0486,1.2527,1.3019,1.1245,0.95532,1.0465,1.2504,1.3027,1.1317,0.95619,1.0592,1.259,1.3304,1.1561,0.97875,1.064,1.263,1.306,1.1393,0.95509,1.0417,1.2469,1.304,1.1385,0.95634,1.0387,1.252,1.3094,1.1564,0.96406,1.0379,1.2414,1.3011,1.1474,0.95752,1.0333,1.2444,1.3005,1.1533,0.96038,1.0296,1.2451,1.3044,1.1544,0.963,1.0316,1.2382,1.3086,1.1566,0.96455,1.0243,1.2376,1.3043,1.1612,0.96223,1.0261,1.2345,1.3063,1.1627,0.96189,1.0229,1.2335,1.3054,1.1686,0.96518,1.0226,1.235,1.3083,1.1704,0.96754,1.0189,1.2325,1.3087,1.1754,0.96728,1.0185,1.2314,1.3121,1.1784,0.9689,1.0154,1.2252,1.3063,1.1787,0.96802,1.0128,1.2236,1.3086,1.1808,0.96953,1.0119,1.2205,1.3031,1.1805,0.97062,1.0053,1.2202,1.3064,1.1876,0.97069,1.0064,1.2155,1.3032,1.1871,0.9719,1.0017,1.2154,1.3044,1.1898,0.97384,0.99987,1.2153,1.301,1.1948,0.97464,0.99828,1.2104,0.0:2
0.0010805,-0.0015714,9.1692E-4,-0.0030509,-0.0017072,-0.0011081,-0.0030972,3.8183E-5,-0.0016562,-0.0033991,-9.2774E-4,-0.0047666,0.001534,-0.0036702,-0.0019161,-1.1687E-4,-0.0047575,-8.5212E-4,0.27123,1.2388,1.0131,0.88093,0.92891,1.1133,1.186,1.0348,0.8647,0.94407,1.1114,1.1865,1.0386,0.86284,0.94378,1.1144,1.1859,1.0439,0.86343,0.94581,1.1138,1.1896,1.0464,0.86391,0.94697,1.1168,1.191,1.0504,0.86457,0.94763,1.1164,1.1938,1.051,0.86465,0.94865,1.1214,1.1929,1.0545,0.87115,0.95068,1.1225,1.1946,1.0544,0.87047,0.94991,1.1216,1.1967,1.0544,0.8735,0.94627,1.1177,1.1949,1.0549,0.8682,0.94802,1.1161,1.1959,1.0534,0.87103,0.94552,1.1184,1.1955,1.055,0.87145,0.94464,1.1189,1.1969,1.0582,0.87071,0.94657,1.1189,1.1947,1.0548,0.87376,0.94506,1.1204,1.1941,1.0594,0.87241,0.94391,1.12,1.1933,1.0578,0.87247,0.94014,1.1221,1.1911,1.0615,0.87367,0.94457,1.1195,1.192,1.0618,0.8726,0.94204,1.1196,1.1948,1.064,0.87223,0.94197,1.1201,1.1925,1.0642,0.87503,0.94368,1.1195,1.194,1.062,0.87443,0.94337,1.1205,1.1977,1.0647,0.87302,0.94408,1.1164,1.1988,1.0617,0.87522,0.94261,1.1183,1.1977,1.0643,0.87398,0.94493,1.1208,1.1963,1.0669,0.87398,0.94524,1.119,1.1963,1.0657,0.87735,0.94244,1.1208,1.1972,1.0699,0.87652,0.94397,1.1187,1.1973,1.0699,0.87704,0.94247,1.1216,1.1942,1.0708,0.87456,0.94279,1.1179,1.1975,1.0699,0.87626,0.9419,1.1181,1.1933,1.069,0.87187,0.9411,1.1161,1.1952,1.0688,0.87436,0.93901,1.115,1.1958,1.0704,0.87441,0.93775,1.1137,1.1955,1.0721,0.87494,0.93844,1.1123,1.1941,1.0706,0.87536,0.93598,1.1117,1.1917,1.0698,0.87547,0.93549,1.1121,1.1926,1.0721,0.87726,0.93641,1.1136,1.19,1.0742,0.87472,0.93458,1.1126,1.1917,1.0718,0.87452,0.93431,1.1114,1.1918,1.0706,0.87448,0.93658,1.1103,1.1949,1.0785,0.87064,0.93875,1.1118,1.1948,1.079,0.87315,0.93791,1.1103,1.1926,1.0798,0.87193,0.93956,1.109,1.1945,1.0785,0.87091,0.93778,1.1105,1.1935,1.0828,0.872,0.93465,1.1091,1.192,1.0792,0.87222,0.93382,1.1079,1.1942,1.0818,0.86952,0.93626,1.1103,1.1933,1.0807,0.87069,0.9341,1.1065,1.1898,1.0785,0.87192,0.93346,1.1068,1.1907,1.0822,0.86957,0.93245,1.1073,1.19,1.0793,0.87126,0.92951,1.105,1.191,1.0817,0.87104,0.92734,1.1044,1.1889,1.0814,0.8736,0.93021,1.1038,1.1886,1.0806,0.87035,0.92834,1.1053,1.1859,1.0804,0.87001,0.93068,1.103,1.1891,1.0808,0.87029,0.92933,1.1026,1.1879,1.0814,0.86955,0.93015,1.1034,1.1876,1.0819,0.87032,0.93083,1.1002,1.189,1.0826,0.8729,0.92939,1.1018,1.1897,1.0856,0.86996,0.92857,1.0975,1.1916,1.0798,0.87171,0.92966,1.0999,1.1892,1.0843,0.87105,0.92714,1.1017,1.1902,1.0812,0.87301,0.92871,1.1005,1.1902,1.0826,0.87225,0.92583,1.1002,1.192,1.0817,0.87614,0.92652,1.1012,1.1922,1.0847,0.87768,0.92905,1.1007,1.1896,1.086,0.87836,0.92882,1.1001,1.1911,1.083,0.87618,0.92759,1.1019,1.1921,1.0871,0.87495,0.92634,1.0962,1.1928,1.0832,0.87822,0.92713,1.1005,1.1934,1.0831,0.87904,0.92664,1.0955,1.1952,1.082,0.87848,0.92504,1.0979,1.1964,1.0826,0.87981,0.92381,1.0985,1.1918,1.0835,0.87545,0.92422,1.097,1.1917,1.0837,0.87717,0.92242,1.0977,1.1918,1.0856,0.8775,0.92501,1.094,1.1928,1.0869,0.87427,0.92524,1.0958,1.1926,1.0875,0.87634,0.9251,1.0918,1.1924,1.0867,0.87508,0.92384,1.095,1.1947,1.0875,0.87754,0.92353,1.0946,1.1914,1.0883,0.63563:2
-0.0012483,-4.5427E-5,0.002114,-0.0027176,0.0039392,-0.0011012,7.1427E-4,0.0021013,-0.0022438,0.0044763,1.2648E-4,2.8562E-4,8.1567E-4,-3.3367E-4,0.004113,-0.0011743,9.0128E-4,8.6675E-4,-0.0021997,0.001345,-0.0021163,3.5859E-4,0.0020861,-0.0032439,0.0030025,-6.7087E-5,6.0942E-4,0.0014877,-0.0022211,0.0041114,-0.0025547,0.0011979,0.0011204,-0.0014845,0.0015094,-5.307E-4,6.5391E-4,0.003308,0.067124,2.2071,2.6733,2.9703,2.8404,2.4485,2.1464,2.6304,2.9694,2.8918,2.3863,2.1973,2.6057,2.9783,2.901,2.3782,2.2107,2.6052,2.9845,2.9019,2.3761,2.2114,2.6077,2.9797,2.9014,2.3722,2.211,2.6098,2.9836,2.898,2.37,2.2115,2.6092,2.9808,2.8974,2.369,2.2092,2.613,2.98,2.8963,2.3672,2.2123,2.6179,2.9806,2.8942,2.3657,2.2111,2.6186,2.9859,2.8967,2.3629,2.2145,2.6177,2.9804,2.8894,2.358,2.2127,2.6167,2.9818,2.8861,2.3568,2.2142,2.6171,2.9904,2.8856,2.3542,2.2126,2.6193,2.984,2.8791,2.3532,2.2101,2.6184,2.9849,2.8741,2.3526,2.2115,2.6224,2.9823,2.8726,2.3494,2.2107,2.6226,2.9829,2.8691,2.3453,2.2111,2.6235,2.9782,2.8647,2.3412,2.2091,2.6233,2.9733,2.8637,2.3363,2.2075,2.6194,2.9783,2.8608,2.3333,2.2063,2.6205,2.9773,2.857,2.3296,2.2086,2.6166,2.9759,2.8544,2.3297,2.2067,2.6204,2.979,2.8498,2.3228,2.2063,2.6192,2.9756,2.8453,2.3239,2.2042,2.6186,2.9746,2.8396,2.3203,2.2027,2.6174,2.9697,2.8342,2.3136,2.2019,2.6188,2.9678,2.8327,2.3127,2.2026,2.6186,2.9649,2.8285,2.3036,2.2017,2.6092,2.9633,2.8215,2.2993,2.1973,2.609,2.957,2.8166,2.2935,2.1993,2.6074,2.9605,2.8152,2.2933,2.1985,2.6107,2.9648,2.8106,2.2876,2.1978,2.6097,2.9612,2.8035,2.2858,2.193,2.6073,2.9538,2.7988,2.2834,2.1934,2.6099,2.9578,2.7928,2.2826,2.1926,2.6105,2.9589,2.79,2.2798,2.1952,2.6126,2.9587,2.7874,2.2783,2.1943,2.616,2.9569,2.7805,2.2735,2.1887,2.6186,2.9533,2.7775,2.2703,2.1888,2.6156,2.9501,2.7737,2.266,2.1897,2.6151,2.9513,2.7686,2.2638,2.1893,2.6163,2.9477,2.764,2.2583,2.1869,2.6123,2.9495,2.761,2.2588,2.1893,2.6176,2.9553,2.7581,2.2545,2.1893,2.6158,2.9525,2.751,2.2486,2.1886,2.6122,2.9521,2.7485,2.2496,2.1894,2.6133,2.9517,2.7414,2.2454,2.1915,2.6152,2.9515,2.7384,2.2428,2.1879,2.6133,2.9508,2.7366,2.2428,2.1886,2.6166,2.9495,2.7297,2.2398,2.1872,2.6214,2.9494,2.7276,2.2328,2.1854,2.615,2.9401,2.7196,2.2287,2.1885,2.617,2.9403,2.7135,2.2261,2.1858,2.6174,2.9403,2.7139,2.2234,2.189,2.6167,2.9417,2.7084,2.2234,2.1934,2.621,2.9438,2.7057,2.2189,2.1895,2.6224,2.9439,2.6975,2.2181,2.1898,2.6221,2.9462,2.696,2.2161,2.1886,2.6217,2.9516,2.6892,2.2161,2.1937,2.6266,2.9483,2.6884,2.2138,2.1904,2.6279,2.9495,2.6881,2.2142,2.1893,2.6287,2.9471,2.6776,2.2086,2.1912,2.6284,2.9418,2.6763,2.2059,2.1917,2.628,2.9458,2.6735,2.2034,2.1882,2.632,2.9444,2.6694,2.201,2.1907,2.6302,2.9472,2.6623,2.1991,2.1913,2.6338,2.9428,2.6615,2.1976,2.1941,2.6336,2.9441,2.6589,2.1945,2.1928,2.635,2.9424,2.6597,2.1955,2.1962,2.6389,2.9452,2.6534,2.1902,2.1982,2.6351,2.9461,2.6525,2.1897,2.2015,2.6395,2.9479,2.6532,2.1902,2.2028,2.6333,2.9478,2.6417,2.1875,2.2026,2.6368,2.9487,2.6424,2.1837,2.2026,2.6372,2.951,2.6356,2.1853,2.2039,2.643,2.9472,2.6343,2.186,2.2028,2.6429,2.9458,2.6241,2.183,2.2048,2.6498,2.9462,2.6254,2.1826,2.2055,0.0:2
-2.2639E-4,0.0039408,-0.0045792,0.0034697,-0.0024149,7.3524E-4,0.0024265,-0.0024194,0.0025787,-0.0013958,-6.7722E-4,0.0019879,-0.0034422,0.003211,-9.6091E-4,0.0020671,0.0016041,-6.162E-4,0.0011596,-0.0038018,-5.5753E-4,0.0025724,-0.0034037,0.0017938,-0.0013063,0.002437,0.003391,-0.0030881,0.0039555,-6.621E-4,0.0026938,-2.5419E-4,-0.0016228,0.0017713,-0.0014473,4.1323E-4,0.0023014,-0.0012254,0.0041873,-0.0020906,0.0019768,3.4506E-4,-0.0019022,0.0035842,-7.5445E-4,0.0023047,0.0041487,-0.0030329,0.0023059,-0.0043687,0.0039908,0.0014282,-0.0015209,0.0021227,-9.1545E-4,8.1232E-4,0.0015694,-0.0027411,0.002031,-0.0023157,0.0015293,5.7367E-4,-0.0027505,0.002853,-0.0024984,0.0010848,0.0019248,-0.0017632,0.0033965,4.1024E-4,0.0012588,0.0031507,-0.002429,0.0031486,-0.0024714,7.8955E-4,0.0019905,-0.0037362,0.0017407,-0.0018766,-2.6462E-4,0.0045899,-0.0022403,1.7401,2.6917,3.0449,2.8979,2.4307,2.2323,2.6891,3.0382,2.9177,2.4016,2.2533,2.6791,3.0412,2.9201,2.3955,2.255,2.6817,3.0431,2.9185,2.3959,2.2578,2.6846,3.0386,2.9155,2.3913,2.2578,2.6897,3.0411,2.9176,2.3911,2.2595,2.6904,3.039,2.9147,2.389,2.2594,2.6942,3.0448,2.9146,2.3844,2.2624,2.6934,3.0427,2.9131,2.381,2.2614,2.6909,3.0463,2.9054,2.3776,2.2616,2.6904,3.0426,2.9015,2.3754,2.2618,2.6883,3.0466,2.896,2.3731,2.2617,2.6922,3.0447,2.8941,2.3713,2.2599,2.6915,3.0436,2.8927,2.3661,2.2583,2.6942,3.0459,2.8836,2.3641,2.2618,2.698,3.0421,2.882,2.3605,2.2615,2.6959,3.0427,2.8804,2.3589,2.2601,2.6955,3.041,2.8774,2.3521,2.2612,2.6945,3.0385,2.8691,2.3502,2.2611,2.6942,3.0361,2.8623,2.3437,2.2575,2.6962,3.0333,2.8569,2.3395,2.2579,2.6922,3.0347,2.8572,2.3367,2.2575,2.695,3.0292,2.8483,2.3321,2.254,2.6926,3.032,2.8429,2.3288,2.2531,2.6958,3.027,2.8384,2.3246,2.2545,2.6922,3.0258,2.8343,2.3224,2.2509,2.6922,3.0211,2.829,2.3163,2.2484,2.689,3.0235,2.8233,2.3155,2.2489,2.6895,3.0212,2.8177,2.3109,2.2496,2.6886,3.0195,2.8113,2.3082,2.2475,2.689,3.0175,2.8067,2.3031,2.2458,2.6892,3.0154,2.8008,2.3015,2.2465,2.6859,3.0161,2.7976,2.2956,2.2453,2.686,3.0143,2.791,2.2916,2.244,2.6878,3.0134,2.788,2.2897,2.2402,2.686,3.0111,2.7845,2.2856,2.2431,2.6853,3.0097,2.7783,2.2816,2.2404,2.6844,3.0086,2.7731,2.2814,2.2405,2.6863,3.008,2.7717,2.2748,2.2392,2.6847,3.0051,2.7645,2.2715,2.2429,2.6864,3.0024,2.7617,2.2687,2.24,2.6841,3.0056,2.7564,2.2678,2.2407,2.6833,3.0027,2.7518,2.2633,2.24,2.6816,3.0014,2.7434,2.259,2.2377,2.6834,3.0004,2.7356,2.253,2.234,2.6746,2.9944,2.7334,2.2515,2.2315,2.6776,2.9934,2.7272,2.2486,2.2329,2.678,2.9876,2.7228,2.2441,2.2323,2.6763,2.9886,2.7163,2.2412,2.2309,2.6781,2.9881,2.7175,2.2402,2.233,2.6772,2.9853,2.7101,2.2388,2.2336,2.6793,2.9843,2.7066,2.2334,2.233,2.679,2.9884,2.7027,2.2328,2.2313,2.6792,2.9855,2.6971,2.2294,2.232,2.6772,2.9833,2.6938,2.2271,2.231,2.6781,2.9841,2.6892,2.2278,2.2337,2.6796,2.9811,2.686,2.2245,2.2336,2.68,2.9803,2.6824,2.2228,2.2314,2.6804,2.9818,2.6805,2.2187,2.2335,2.6812,2.9811,2.6751,2.2193,2.2332,2.6827,2.9777,2.6698,2.2146,2.2325,2.6811,2.9769,2.6681,2.212,2.2315,2.681,2.9754,2.6622,2.2098,2.233,2.6823,2.9747,2.6578,2.2071,2.2352,2.6821,2.9776,2.6554,2.2069,2.2348,2.6819,2.9747,2.6532,2.2034,2.2364,2.6819,2.9773,2.6489,2.2048,2.2362,2.689,2.9755,2.6474,2.202,0.67518:2
0.0021268,7.0408E-4,-0.0019805,0.0032306,-0.0029229,0.0019331,-0.0014423,-0.0054512,0.0027633,-0.0036671,-6.1977E-4,4.1974E-4,-0.0042879,0.0015922,-0.0042379,0.0018957,-2.2704E-4,-0.0052658,0.0033753,-0.0023701,0.0013329,-8.747E-4,-0.0026963,0.0036873,-0.0051444,8.1337E-4,0.0026357,-0.0039452,0.0017908,-0.0037825,0.0021952,0.0018543,-0.0021075,0.00251,-7.6629E-4,0.001177,5.2592E-4,-0.0047667,3.9321E-4,-0.0039442,0.0033959,-3.0098E-4,-0.0027576,0.0033901,-0.003413,-0.0014833,0.0026909,-0.0023624,0.0028966,1.319,3.0366,3.1103,2.6138,2.2726,2.5448,2.9901,3.1116,2.6208,2.2691,2.5486,2.9889,3.1123,2.6227,2.2685,2.5473,2.9929,3.1093,2.6225,2.2697,2.5537,2.9925,3.1133,2.619,2.2699,2.5491,2.9933,3.1117,2.62,2.2685,2.5523,2.9924,3.1114,2.6168,2.2706,2.5534,2.9924,3.1123,2.614,2.2669,2.5561,2.9948,3.1085,2.6098,2.2642,2.5509,2.9923,3.1108,2.6086,2.264,2.5525,2.992,3.1073,2.6068,2.2649,2.5522,2.991,3.1073,2.6029,2.2626,2.5505,2.989,3.106,2.6007,2.2612,2.5488,2.9864,3.1019,2.5953,2.2589,2.5479,2.9861,3.1012,2.5926,2.2609,2.5462,2.9864,3.0998,2.5912,2.258,2.5449,2.9843,3.0967,2.5876,2.2527,2.5453,2.981,3.0872,2.5792,2.249,2.54,2.9759,3.0896,2.5785,2.2503,2.5412,2.978,3.0888,2.5732,2.2472,2.5427,2.9741,3.0848,2.5728,2.246,2.5399,2.9712,3.08,2.5709,2.2456,2.5381,2.9674,3.0804,2.5659,2.2442,2.5415,2.9672,3.0777,2.5639,2.241,2.5364,2.9651,3.0754,2.5589,2.2405,2.5364,2.9621,3.076,2.5554,2.2383,2.5344,2.9603,3.0682,2.5514,2.2343,2.5344,2.9582,3.0661,2.5472,2.2315,2.5301,2.9549,3.0608,2.5433,2.2275,2.5302,2.9536,3.0612,2.5402,2.2293,2.5286,2.954,3.0589,2.5378,2.2275,2.5267,2.9519,3.0571,2.5339,2.2264,2.5279,2.9499,3.0513,2.5311,2.2244,2.5268,2.9486,3.0486,2.5274,2.2225,2.5245,2.9471,3.046,2.522,2.2223,2.5242,2.9508,3.0435,2.5224,2.2209,2.5241,2.9443,3.0406,2.516,2.2191,2.522,2.9477,3.0361,2.5145,2.215,2.5219,2.9384,3.0355,2.5095,2.2153,2.52,2.9435,3.0323,2.5058,2.2127,2.5178,2.9396,3.0281,2.5052,2.2118,2.519,2.9383,3.0265,2.4982,2.2095,2.517,2.9388,3.0249,2.4975,2.2085,2.5181,2.9352,3.0251,2.4942,2.2083,2.5176,2.9345,3.0202,2.4896,2.2043,2.5159,2.9332,3.0193,2.4857,2.2039,2.5166,2.9302,3.0154,2.4811,2.2,2.5135,2.9295,3.0128,2.4822,2.1999,2.5145,2.9272,3.0091,2.477,2.1987,2.5142,2.9274,3.0028,2.477,2.1967,2.5126,2.9287,3.0015,2.4729,2.197,2.5133,2.9257,2.9994,2.4727,2.1941,2.5144,2.9263,2.9969,2.4687,2.1948,2.5108,2.9231,2.9951,2.467,2.1931,2.511,2.9207,2.9971,2.4622,2.1933,2.5125,2.9225,2.9939,2.4579,2.1919,2.5141,2.9209,2.9925,2.4571,2.1908,2.513,2.9217,2.9897,2.4546,2.1919,2.5104,2.9241,2.9845,2.4513,2.1897,2.5103,2.9247,2.9823,2.4519,2.1874,2.5085,2.923,2.9803,2.4494,2.1888,2.5087,2.9218,2.9807,2.4452,2.1878,2.5089,2.9215,2.9805,2.4478,2.1834,2.5127,2.9167,2.979,2.4444,2.1838,2.5145,2.9152,2.9787,2.4389,2.186,2.5148,2.9154,2.9767,2.4393,2.1826,2.5132,2.9147,2.9798,2.4356,2.1858,2.5118,2.9181,2.9754,2.4349,2.1847,2.5114,2.9176,2.9712,2.4307,2.1842,2.5101,2.9229,2.968,2.4319,2.1839,2.5093,2.9218,2.9662,2.4288,2.1826,2.5106,2.9194,2.9619,2.4288,2.1815,2.5142,2.9199,2.9643,2.4262,2.1786,2.5126,2.9189,2.9631,2.4264,2.1807,2.5149,2.9185,2.9617,2.4255,2.1789,2.5169,2.9153,2.9608,2.4234,2.1798,2.5153,2.9168,2.9581,2.4227,2.1784,2.5156,2.9171,2.9577,2.4213,2.1819,2.5179,0.0:2
0.0030051,0.0042128,0.0035463,0.0041195,0.0047965,0.0021825,0.0037181,0.0043101,0.0038964,0.0042874,0.0022985,0.0047409,0.0035962,0.0042323,0.0043499,0.0024199,0.004619,0.0032272,0.0044653,0.004278,0.0023999,0.0046351,0.0046384,0.0040413,0.0046542,0.0022904,0.0039739,0.004031,0.0043244,0.0049456,0.0022089,0.0044569,0.0034954,0.0047217,0.0041272,0.0026365,0.0042388,0.0037421,0.0043356,0.004671,0.30006,0.36877,0.41511,0.41324,0.35829,0.30776,0.35216,0.41673,0.41707,0.35439,0.31168,0.35092,0.41797,0.41778,0.35372,0.31122,0.35053,0.41897,0.41934,0.35471,0.31252,0.35126,0.41985,0.4196,0.3557,0.31372,0.3509,0.41878,0.42059,0.3558,0.31262,0.35139,0.41938,0.41979,0.35624,0.31373,0.35151,0.41912,0.42061,0.3564,0.31366,0.35157,0.42014,0.42057,0.35602,0.31385,0.3514,0.41928,0.42136,0.35587,0.31331,0.35111,0.41946,0.42042,0.35528,0.31308,0.35064,0.41861,0.42067,0.35584,0.31369,0.3504,0.41909,0.42103,0.35576,0.31387,0.35036,0.41967,0.42109,0.35562,0.3138,0.35034,0.41895,0.42115,0.35575,0.31374,0.34987,0.41856,0.42045,0.35617,0.31298,0.34869,0.41787,0.42025,0.35596,0.31314,0.34954,0.41809,0.42089,0.35584,0.31305,0.35029,0.41843,0.42138,0.35654,0.31353,0.3499,0.41938,0.42112,0.35674,0.31375,0.34907,0.41849,0.42041,0.35643,0.31266,0.34862,0.41794,0.42037,0.35601,0.31289,0.34856,0.4175,0.42176,0.35654,0.31298,0.34873,0.41793,0.42126,0.35576,0.31216,0.34807,0.41666,0.42019,0.35639,0.31205,0.34824,0.41699,0.42099,0.35617,0.31217,0.34805,0.41644,0.419,0.35576,0.31223,0.3463,0.41659,0.41936,0.35572,0.3121,0.34735,0.41527,0.41962,0.35561,0.31155,0.34627,0.41576,0.41943,0.35518,0.31175,0.34718,0.41501,0.41902,0.35558,0.31117,0.34631,0.41556,0.41958,0.35578,0.31095,0.34628,0.41422,0.41893,0.35561,0.31038,0.34638,0.41438,0.41878,0.35566,0.31065,0.34577,0.4137,0.41816,0.35428,0.31,0.3442,0.41287,0.41721,0.35427,0.30911,0.34472,0.41277,0.41705,0.35337,0.30914,0.344,0.4124,0.41707,0.35366,0.30924,0.34405,0.41344,0.41667,0.354,0.30952,0.34312,0.41149,0.41626,0.35391,0.30921,0.34258,0.41098,0.41608,0.35319,0.30806,0.3427,0.41117,0.41555,0.35417,0.30795,0.34234,0.41063,0.41651,0.35289,0.30793,0.34194,0.41084,0.4161,0.35329,0.3083,0.34255,0.41028,0.41509,0.35242,0.30769,0.34081,0.40982,0.4155,0.35268,0.30698,0.34153,0.40977,0.41476,0.35258,0.30713,0.34072,0.40962,0.41518,0.35166,0.30683,0.34041,0.40829,0.41389,0.35276,0.30634,0.33984,0.40869,0.41437,0.35298,0.30699,0.33966,0.40901,0.41319,0.35164,0.30689,0.33942,0.40927,0.41294,0.35214,0.30614,0.33954,0.40785,0.41294,0.3515,0.30619,0.33872,0.40823,0.41316,0.35252,0.30584,0.33881,0.40752,0.41292,0.35178,0.30642,0.33871,0.40734,0.41228,0.35102,0.30572,0.33809,0.40666,0.4123,0.3518,0.30545,0.33769,0.40566,0.41139,0.35143,0.30531,0.33789,0.40654,0.41086,0.35054,0.30461,0.33697,0.40554,0.41173,0.35126,0.30413,0.3371,0.4049,0.41052,0.35033,0.30382,0.3369,0.40531,0.41081,0.35025,0.30391,0.33584,0.40526,0.41027,0.35013,0.30404,0.33582,0.40475,0.41065,0.3504,0.30286,0.33584,0.40377,0.4104,0.35001,0.30322,0.33547,0.40383,0.4096,0.34967,0.30316,0.33563,0.40363,0.40953,0.34957,0.30256,0.33492,0.40334,0.40944,0.34891,0.30282,0.33463,0.40291,0.40938,0.34924,0.30262,0.33513,0.4032,0.40985,0.34948,0.30267,0.33502,0.40353,0.40969,0.3493,0.30222,0.33421,0.40178,0.40937,0.34891,0.30278,0.33402,0.40244,0.40919,0.3489,0.30201,0.33462,0.4028,0.40956,0.34859,0.30187,0.33414,0.40163,0.40932,0.34904,0.30217,0.33405,0.40064,0.40887,0.34784,0.30195,0.33358,0.40181,0.40815,0.34797,0.30167,0.33248,0.40053,0.40808,0.34782,0.30141,0.33207,0.40091,0.40759,0.34848,0.3014,0.33245,0.40024,0.40759,0.34759,0.30149,0.33262,0.40035,0.15938:2
0.003757,0.0042439,0.0040094,0.0029039,0.0038948,0.0033614,0.0046711,0.0039497,0.0024859,0.0043555,0.0040137,0.004541,0.0037478,0.0025175,0.0040308,0.0045115,0.004163,0.0039467,0.002549,0.0042739,0.0031354,0.0043874,0.0043256,0.0022121,0.0037185,0.0031262,0.0046232,0.0041399,0.0024392,0.0038874,0.0043993,0.0040723,0.3328,0.33373,0.31232,0.40681,0.41768,0.37279,0.31425,0.3267,0.40101,0.41806,0.37517,0.31194,0.32752,0.40006,0.41929,0.37533,0.31213,0.32799,0.40095,0.41984,0.37535,0.31336,0.32832,0.40152,0.41925,0.37608,0.31222,0.32907,0.40171,0.41996,0.37575,0.31302,0.32884,0.40291,0.42056,0.37577,0.31391,0.32963,0.40287,0.42134,0.37629,0.31403,0.33019,0.40371,0.42251,0.37676,0.31368,0.33012,0.40378,0.42297,0.37662,0.31435,0.33064,0.4039,0.42106,0.3756,0.31336,0.32999,0.40399,0.4217,0.37566,0.31314,0.32969,0.40378,0.42169,0.37509,0.31301,0.33019,0.40355,0.4213,0.37466,0.31312,0.33103,0.40315,0.42172,0.37491,0.31335,0.33093,0.40316,0.42179,0.37436,0.31295,0.3303,0.40385,0.42163,0.37379,0.3128,0.33117,0.40356,0.4218,0.37329,0.3126,0.33113,0.40427,0.42248,0.37327,0.31369,0.3314,0.40433,0.42236,0.37396,0.31284,0.33153,0.40408,0.42203,0.37289,0.31293,0.33135,0.40353,0.42084,0.37222,0.31253,0.33064,0.40414,0.42063,0.37237,0.31198,0.3314,0.4046,0.42155,0.37219,0.31181,0.33111,0.40461,0.42074,0.37171,0.31127,0.33059,0.40298,0.42011,0.37095,0.31109,0.33123,0.40412,0.42022,0.37128,0.31133,0.33065,0.40258,0.41897,0.36917,0.31071,0.33048,0.40337,0.41937,0.37012,0.31068,0.33072,0.40373,0.41994,0.36908,0.31067,0.33136,0.4023,0.41821,0.369,0.30995,0.33026,0.40298,0.41828,0.36858,0.31016,0.3309,0.40266,0.41812,0.36773,0.30932,0.3302,0.40259,0.41809,0.36829,0.31002,0.33136,0.40405,0.41874,0.36709,0.30947,0.33086,0.40269,0.41831,0.3668,0.30914,0.33171,0.40328,0.41798,0.36628,0.30902,0.33083,0.40268,0.41752,0.36498,0.30795,0.33063,0.40219,0.41721,0.36436,0.30838,0.33038,0.40313,0.41661,0.36493,0.30783,0.32988,0.40177,0.41707,0.36426,0.30727,0.33059,0.40183,0.41551,0.36234,0.30705,0.32986,0.40085,0.41522,0.3631,0.30648,0.33022,0.40115,0.41465,0.36212,0.30599,0.32939,0.40023,0.41463,0.36201,0.3063,0.32982,0.40107,0.41354,0.36032,0.30641,0.3302,0.40153,0.41433,0.36086,0.30604,0.32972,0.39992,0.4137,0.36005,0.30536,0.33011,0.40148,0.41405,0.35993,0.30545,0.33021,0.40091,0.41338,0.35979,0.30458,0.33027,0.40029,0.41381,0.35878,0.30482,0.32986,0.40034,0.41318,0.35904,0.30454,0.33015,0.40091,0.41277,0.35836,0.30493,0.33008,0.40039,0.41267,0.35773,0.30468,0.32964,0.4,0.4118,0.35687,0.30394,0.3297,0.40062,0.41239,0.35681,0.30422,0.32919,0.40036,0.41112,0.35608,0.30435,0.32985,0.39957,0.41219,0.35624,0.30395,0.32952,0.40074,0.41057,0.35652,0.30314,0.33009,0.4004,0.41051,0.35491,0.303,0.33042,0.40005,0.41142,0.35441,0.30286,0.3301,0.39967,0.41084,0.35534,0.30359,0.33068,0.40034,0.41044,0.35446,0.30258,0.33067,0.40012,0.41073,0.35287,0.30235,0.33069,0.40006,0.41015,0.3525,0.30131,0.33035,0.39963,0.40962,0.35149,0.30212,0.33024,0.39962,0.40937,0.35209,0.30124,0.3299,0.39999,0.40878,0.3509,0.30079,0.3304,0.39924,0.40866,0.35057,0.30136,0.33124,0.39956,0.4082,0.35048,0.30058,0.33098,0.39863,0.40759,0.34974,0.30117,0.33191,0.3989,0.4074,0.34952,0.30111,0.33053,0.39909,0.40894,0.34934,0.30073,0.3305,0.39949,0.40699,0.34834,0.30037,0.33119,0.39961,0.40679,0.34766,0.30045,0.33065,0.39817,0.40628,0.34764,0.30021,0.33059,0.39924,0.4067,0.34665,0.30006,0.3312,0.39895,0.4062,0.34579,0.2997,0.33133,0.39964,0.40579,0.34595,0.29926,0.33096,0.39879,0.40629,0.34562,0.037144:2
1.1333E-6,1.12E-6,-6.0E-8,2.1833E-6,-1.44E-6,1.3333E-6,5.9333E-7,-7.2E-7,2.5333E-6,-1.6667E-7,1.4833E-6,2.0E-7,-1.6333E-7,1.9933E-6,-1.75E-6,1.95E-6,5.4333E-7,-1.14E-6,2.38E-6,-1.55E-6,1.6267E-6,2.0333E-7,-9.1667E-7,2.05E-6,-1.3167E-6,2.0733E-6,3.8E-7,-7.4667E-7,1.8833E-6,-4.8667E-7,1.1E-6,7.6667E-8,4.2667E-7,1.42E-6,-1.25E-6,1.33E-6,-4.5333E-7,-7.0E-8,1.86E-6,-9.7667E-7,1.49E-6,3.0E-8,-1.18E-6,2.44E-6,-1.5433E-6,2.42E-6,2.3333E-8,-3.0E-7,1.9767E-6,-1.1067E-6,2.2967E-6,6.6667E-9,-8.8E-7,1.7767E-6,-9.8667E-7,2.07E-6,3.0667E-7,1.4118E-4,1.4302E-4,1.3315E-4,1.383E-4,1.6206E-4,1.7977E-4,1.585E-4,1.3182E-4,1.4306E-4,1.6366E-4,1.8145E-4,1.5823E-4,1.3214E-4,1.4301E-4,1.6271E-4,1.8261E-4,1.5913E-4,1.3231E-4,1.4221E-4,1.6506E-4,1.813E-4,1.5964E-4,1.3301E-4,1.4232E-4,1.6486E-4,1.8239E-4,1.6036E-4,1.3296E-4,1.4267E-4,1.6553E-4,1.8278E-4,1.6043E-4,1.3341E-4,1.4283E-4,1.6491E-4,1.8322E-4,1.6169E-4,1.3431E-4,1.4331E-4,1.6465E-4,1.8322E-4,1.6146E-4,1.3375E-4,1.4345E-4,1.6522E-4,1.8375E-4,1.6168E-4,1.3442E-4,1.4329E-4,1.6685E-4,1.8435E-4,1.6066E-4,1.344E-4,1.4259E-4,1.6597E-4,1.8391E-4,1.6065E-4,1.3318E-4,1.4322E-4,1.647E-4,1.8351E-4,1.6084E-4,1.3385E-4,1.4288E-4,1.6579E-4,1.8423E-4,1.6069E-4,1.3486E-4,1.4302E-4,1.6585E-4,1.8378E-4,1.625E-4,1.343E-4,1.4246E-4,1.6589E-4,1.8297E-4,1.6146E-4,1.3451E-4,1.4189E-4,1.654E-4,1.8321E-4,1.6107E-4,1.348E-4,1.446E-4,1.6628E-4,1.8551E-4,1.6255E-4,1.3485E-4,1.4213E-4,1.6535E-4,1.8421E-4,1.6191E-4,1.3475E-4,1.4218E-4,1.6555E-4,1.8365E-4,1.6182E-4,1.3385E-4,1.4326E-4,1.6495E-4,1.845E-4,1.6179E-4,1.3551E-4,1.4169E-4,1.6569E-4,1.852E-4,1.6243E-4,1.3552E-4,1.423E-4,1.6495E-4,1.8256E-4,1.6132E-4,1.3444E-4,1.4163E-4,1.6583E-4,1.8431E-4,1.6148E-4,1.3471E-4,1.4267E-4,1.6584E-4,1.8475E-4,1.627E-4,1.3432E-4,1.4287E-4,1.6616E-4,1.8479E-4,1.6167E-4,1.3515E-4,1.4232E-4,1.6522E-4,1.84E-4,1.6132E-4,1.3592E-4,1.4255E-4,1.6483E-4,1.8421E-4,1.6145E-4,1.3505E-4,1.42E-4,1.6547E-4,1.847E-4,1.6225E-4,1.3542E-4,1.4218E-4,1.6607E-4,1.8447E-4,1.6196E-4,1.3445E-4,1.4154E-4,1.6521E-4,1.8442E-4,1.6289E-4,1.3477E-4,1.4176E-4,1.6545E-4,1.8562E-4,1.6336E-4,1.3572E-4,1.4232E-4,1.6451E-4,1.8538E-4,1.6255E-4,1.3487E-4,1.4203E-4,1.6558E-4,1.8453E-4,1.6238E-4,1.356E-4,1.4112E-4,1.6538E-4,1.845E-4,1.6308E-4,1.3496E-4,1.4199E-4,1.6479E-4,1.842E-4,1.6287E-4,1.3535E-4,1.4232E-4,1.6467E-4,1.8432E-4,1.6227E-4,1.3518E-4,1.4262E-4,1.6464E-4,1.8486E-4,1.6329E-4,1.3469E-4,1.4275E-4,1.6608E-4,1.8539E-4,1.635E-4,1.3684E-4,1.4209E-4,1.6386E-4,1.842E-4,1.6213E-4,1.3508E-4,1.4214E-4,1.6559E-4,1.8389E-4,1.6375E-4,1.3612E-4,1.4236E-4,1.65E-4,1.8462E-4,1.6303E-4,1.3456E-4,1.4121E-4,1.6551E-4,1.8422E-4,1.63E-4,1.3413E-4,1.4112E-4,1.648E-4,1.841E-4,1.6441E-4,1.3376E-4,1.4154E-4,1.6484E-4,1.8355E-4,1.6312E-4,1.3533E-4,1.4125E-4,1.6446E-4,1.8412E-4,1.6376E-4,1.3417E-4,1.4137E-4,1.6459E-4,1.8407E-4,1.6455E-4,1.3579E-4,1.4146E-4,1.656E-4,1.8491E-4,1.6286E-4,1.35E-4,1.4113E-4,1.6507E-4,1.842E-4,1.6398E-4,1.3573E-4,1.4155E-4,1.6446E-4,1.8357E-4,1.6385E-4,1.3559E-4,1.4139E-4,1.6373E-4,1.8385E-4,1.6347E-4,1.3533E-4,1.4106E-4,1.6414E-4,1.8474E-4,1.6497E-4,1.3528E-4,1.4014E-4,1.6462E-4,1.8562E-4,1.6418E-4,1.3576E-4,1.4129E-4,1.6412E-4,1.8481E-4,1.6352E-4,1.3515E-4,1.4072E-4,1.6418E-4,1.8417E-4,1.629E-4,1.3504E-4,1.405E-4,1.6401E-4,1.8377E-4,1.6417E-4,1.3652E-4,1.4092E-4,1.6302E-4,1.8377E-4,1.6317E-4,1.3556E-4,1.4002E-4,1.6464E-4,1.8348E-4,1.6326E-4,1.3608E-4,1.4019E-4,1.6405E-4,1.8487E-4,1.6395E-4,1.3654E-4,1.4071E-4,1.6225E-4,1.8299E-4,1.6299E-4,1.3548E-4,1.3929E-4,1.6373E-4,1.8335E-4,1.6331E-4,1.3635E-4,1.3887E-4,1.6335E-4,1.8384E-4,1.6326E-4,1.3502E-4,1.4031E-4,1.6299E-4,1.8276E-4,1.6305E-4,1.3531E-4,1.3976E-4,1.6301E-4,1.84E-4,1.6306E-4,1.3527E-4,1.3989E-4,1.6276E-4,1.8449E-4,1.6377E-4,1.3514E-4,1.3999E-4,1.6235E-4,1.8397E-4,1.6169E-4,1.355E-4,1.3898E-4,1.6179E-4,1.8426E-4,1.6376E-4,1.3536E-4,1.3918E-4,1.6279E-4,1.8389E-4,1.6438E-4,1.3453E-4,1.3995E-4,1.6274E-4,1.8306E-4,1.6413E-4,1.3505E-4,1.3919E-4,1.6263E-4,1.8302E-4,1.6332E-4,1.3534E-4,1.4047E-4,1.6269E-4,1.8325E-4,1.6385E-4,1.3414E-4,1.3901E-4,1.6244E-4,1.8324E-4,1.6385E-4,1.3396E-4,1.3983E-4,1.6228E-4,1.8417E-4,1.642E-4,1.3451E-4,1.3837E-4,1.628E-4,1.8286E-4,1.6408E-4,1.3495E-4,1.3975E-4,1.6221E-4,1.8241E-4,1.6367E-4,1.3425E-4,1.3877E-4,1.6259E-4,1.8225E-4,1.6389E-4,1.3502E-4,1.3857E-4,1.5695E-4,1.8051E-4,1.6364E-4,1.3405E-4,1.3826E-4,1.6238E-4,1.8312E-4,1.6375E-4,1.3445E-4,1.3842E-4,1.6056E-4,1.8159E-4,1.6448E-4,1.3443E-4,1.3941E-4,1.6212E-4,1.8172E-4,1.6229E-4,1.3475E-4,1.3912E-4,1.6174E-4,1.8283E-4,1.6423E-4,1.342E-4,1.3805E-4,1.6138E-4,1.8406E-4,1.6354E-4,1.3332E-4,1.382E-4,1.6079E-4,1.8145E-4,1.6337E-4,1.346E-4,1.3761E-4,1.6096E-4,1.825E-4,3.811E-5:2
2.07E-6,-8.7E-7,8.9E-7,1.68E-6,-1.3767E-6,1.8367E-6,-1.0467E-6,1.0567E-6,1.3967E-6,-1.6E-7,1.7167E-6,-9.4E-7,1.9533E-6,9.9333E-7,-2.0333E-7,2.07E-6,-9.2333E-7,5.5667E-7,5.6333E-7,-7.8333E-7,1.9367E-6,-1.27E-6,1.1967E-6,5.7333E-7,-8.2667E-7,1.81E-6,-7.6667E-7,1.4733E-6,1.2633E-6,-1.6E-7,1.51E-6,-4.8E-7,1.3133E-6,6.2547E-5,2.0431E-4,1.2217E-4,1.4379E-4,1.4484E-4,1.7236E-4,1.747E-4,1.3787E-4,1.3305E-4,1.5079E-4,1.7174E-4,1.7455E-4,1.4129E-4,1.3289E-4,1.5125E-4,1.7173E-4,1.7559E-4,1.4162E-4,1.3339E-4,1.5152E-4,1.7213E-4,1.7506E-4,1.426E-4,1.3228E-4,1.5053E-4,1.7174E-4,1.7771E-4,1.4028E-4,1.3268E-4,1.5193E-4,1.7231E-4,1.773E-4,1.4259E-4,1.3403E-4,1.5138E-4,1.734E-4,1.7946E-4,1.4232E-4,1.3405E-4,1.5164E-4,1.7323E-4,1.7868E-4,1.4309E-4,1.3259E-4,1.5024E-4,1.7242E-4,1.7868E-4,1.4441E-4,1.3299E-4,1.5019E-4,1.7158E-4,1.79E-4,1.4401E-4,1.3261E-4,1.4963E-4,1.7112E-4,1.8001E-4,1.4462E-4,1.3481E-4,1.5069E-4,1.7162E-4,1.785E-4,1.4423E-4,1.3488E-4,1.5223E-4,1.7224E-4,1.7926E-4,1.4391E-4,1.36E-4,1.5114E-4,1.7359E-4,1.8062E-4,1.4444E-4,1.3428E-4,1.5081E-4,1.7247E-4,1.8134E-4,1.4442E-4,1.3378E-4,1.5033E-4,1.7264E-4,1.8109E-4,1.4522E-4,1.3376E-4,1.5136E-4,1.7265E-4,1.8189E-4,1.4552E-4,1.3507E-4,1.5083E-4,1.7387E-4,1.8273E-4,1.4468E-4,1.3381E-4,1.4983E-4,1.7221E-4,1.821E-4,1.4567E-4,1.3331E-4,1.506E-4,1.7181E-4,1.8184E-4,1.4628E-4,1.3601E-4,1.501E-4,1.7238E-4,1.8198E-4,1.4627E-4,1.3458E-4,1.4946E-4,1.7161E-4,1.8249E-4,1.4588E-4,1.3437E-4,1.4909E-4,1.7159E-4,1.8226E-4,1.4607E-4,1.3425E-4,1.5043E-4,1.7235E-4,1.8397E-4,1.4553E-4,1.3576E-4,1.4998E-4,1.7339E-4,1.8335E-4,1.4564E-4,1.3565E-4,1.4955E-4,1.7127E-4,1.8242E-4,1.4643E-4,1.3418E-4,1.5037E-4,1.7054E-4,1.8267E-4,1.4621E-4,1.3396E-4,1.494E-4,1.7092E-4,1.8295E-4,1.4687E-4,1.3492E-4,1.4992E-4,1.7126E-4,1.8183E-4,1.4757E-4,1.3455E-4,1.4918E-4,1.7236E-4,1.8367E-4,1.4724E-4,1.3418E-4,1.5052E-4,1.7128E-4,1.8271E-4,1.4666E-4,1.3476E-4,1.4905E-4,1.715E-4,1.8279E-4,1.4646E-4,1.3427E-4,1.4881E-4,1.7142E-4,1.8293E-4,1.4662E-4,1.3423E-4,1.487E-4,1.7167E-4,1.8219E-4,1.4726E-4,1.3447E-4,1.4899E-4,1.6996E-4,1.8386E-4,1.4727E-4,1.3491E-4,1.4839E-4,1.7031E-4,1.8253E-4,1.4761E-4,1.3398E-4,1.4756E-4,1.7018E-4,1.8385E-4,1.4746E-4,1.3423E-4,1.4795E-4,1.7055E-4,1.8261E-4,1.4696E-4,1.3402E-4,1.478E-4,1.7024E-4,1.8245E-4,1.467E-4,1.3466E-4,1.4797E-4,1.6992E-4,1.8323E-4,1.4743E-4,1.3418E-4,1.4801E-4,1.7096E-4,1.8333E-4,1.4776E-4,1.3373E-4,1.4773E-4,1.7033E-4,1.8188E-4,1.4466E-4,1.312E-4,1.4576E-4,1.6912E-4,1.8341E-4,1.4787E-4,1.324E-4,1.4722E-4,1.7041E-4,1.8321E-4,1.4898E-4,1.329E-4,1.4691E-4,1.6877E-4,1.8259E-4,1.4815E-4,1.3395E-4,1.4707E-4,1.6782E-4,1.8357E-4,1.4861E-4,1.3477E-4,1.4688E-4,1.6957E-4,1.8171E-4,1.479E-4,1.3448E-4,1.4673E-4,1.6916E-4,1.8164E-4,1.4726E-4,1.3289E-4,1.4661E-4,1.6921E-4,1.8401E-4,1.4816E-4,1.3293E-4,1.4648E-4,1.6885E-4,1.8219E-4,1.4876E-4,1.332E-4,1.4588E-4,1.6881E-4,1.8382E-4,1.498E-4,1.3305E-4,1.4546E-4,1.6761E-4,1.8359E-4,1.4955E-4,1.3334E-4,1.4632E-4,1.6774E-4,1.8279E-4,1.5018E-4,1.3382E-4,1.456E-4,1.6725E-4,1.8287E-4,1.4929E-4,1.33E-4,1.461E-4,1.681E-4,1.8506E-4,1.4933E-4,1.3353E-4,1.47E-4,1.6879E-4,1.8404E-4,1.4914E-4,1.3326E-4,1.4549E-4,1.6699E-4,1.8238E-4,1.4886E-4,1.3401E-4,1.4669E-4,1.6677E-4,1.8479E-4,1.4902E-4,1.3271E-4,1.4607E-4,1.6642E-4,1.8382E-4,1.4995E-4,1.3224E-4,1.4564E-4,1.6735E-4,1.8371E-4,1.4903E-4,1.3175E-4,1.4546E-4,1.6568E-4,1.8441E-4,1.5029E-4,1.3187E-4,1.4351E-4,1.6372E-4,1.8178E-4,1.493E-4,1.3351E-4,1.448E-4,1.6643E-4,1.8353E-4,1.5008E-4,1.3316E-4,1.4459E-4,1.6565E-4,1.829E-4,1.5003E-4,1.3428E-4,1.4497E-4,1.6523E-4,1.8255E-4,0.0:2
-2.4233E-6,1.98E-6,3.6E-7,-5.0667E-7,2.0733E-6,-9.9E-7,2.0733E-6,1.4533E-6,3.1E-7,1.4667E-6,-7.1667E-7,1.3E-6,2.9E-7,1.6667E-7,2.4933E-6,-2.1367E-6,1.1433E-6,9.1667E-7,-2.9333E-7,1.9433E-6,-1.4067E-6,1.7167E-6,1.35E-6,-2.0667E-7,2.17E-6,-4.4333E-7,1.72E-6,2.2E-7,2.1333E-7,2.52E-6,-5.4667E-7,2.1633E-6,9.6667E-7,8.7E-7,1.53E-6,1.1333E-7,2.5433E-6,3.0E-8,-6.2333E-7,1.0033E-6,-9.2667E-7,1.4033E-6,6.0667E-7,1.6803E-4,1.9682E-4,1.0852E-4,1.5761E-4,1.6073E-4,1.7814E-4,1.594E-4,1.2751E-4,1.4702E-4,1.6436E-4,1.8112E-4,1.5528E-4,1.3216E-4,1.4543E-4,1.6582E-4,1.8144E-4,1.548E-4,1.3247E-4,1.4528E-4,1.6577E-4,1.8115E-4,1.5639E-4,1.3262E-4,1.4532E-4,1.6596E-4,1.8185E-4,1.5478E-4,1.3328E-4,1.4536E-4,1.6759E-4,1.8267E-4,1.5508E-4,1.3259E-4,1.4474E-4,1.6774E-4,1.8337E-4,1.5622E-4,1.3253E-4,1.4554E-4,1.6692E-4,1.8273E-4,1.5684E-4,1.328E-4,1.4419E-4,1.6638E-4,1.8391E-4,1.572E-4,1.3239E-4,1.4458E-4,1.6702E-4,1.8384E-4,1.5851E-4,1.341E-4,1.4455E-4,1.6561E-4,1.8463E-4,1.5764E-4,1.3369E-4,1.4346E-4,1.6592E-4,1.8402E-4,1.5891E-4,1.3377E-4,1.4401E-4,1.6576E-4,1.8489E-4,1.589E-4,1.3375E-4,1.4435E-4,1.659E-4,1.8411E-4,1.5984E-4,1.339E-4,1.4377E-4,1.6758E-4,1.8462E-4,1.5914E-4,1.3357E-4,1.4462E-4,1.6776E-4,1.832E-4,1.5953E-4,1.3409E-4,1.4456E-4,1.6523E-4,1.8462E-4,1.5963E-4,1.3434E-4,1.4377E-4,1.667E-4,1.8396E-4,1.6096E-4,1.3399E-4,1.4416E-4,1.6551E-4,1.8375E-4,1.6092E-4,1.3417E-4,1.4401E-4,1.6537E-4,1.8402E-4,1.6159E-4,1.341E-4,1.4348E-4,1.6368E-4,1.8514E-4,1.6071E-4,1.3363E-4,1.44E-4,1.6529E-4,1.8385E-4,1.6138E-4,1.3487E-4,1.435E-4,1.647E-4,1.8393E-4,1.621E-4,1.3471E-4,1.4382E-4,1.6468E-4,1.8324E-4,1.6321E-4,1.3442E-4,1.4239E-4,1.6415E-4,1.845E-4,1.6257E-4,1.3464E-4,1.4258E-4,1.6514E-4,1.849E-4,1.6315E-4,1.3477E-4,1.4273E-4,1.6439E-4,1.8427E-4,1.6311E-4,1.3488E-4,1.4295E-4,1.6344E-4,1.8336E-4,1.6329E-4,1.3469E-4,1.4243E-4,1.6405E-4,1.8433E-4,1.6385E-4,1.3524E-4,1.4241E-4,1.6521E-4,1.8339E-4,1.6376E-4,1.3425E-4,1.4235E-4,1.6396E-4,1.8482E-4,1.6412E-4,1.3545E-4,1.4108E-4,1.628E-4,1.8395E-4,1.6369E-4,1.3445E-4,1.4072E-4,1.6276E-4,1.8357E-4,1.65E-4,1.3445E-4,1.4114E-4,1.6412E-4,1.8329E-4,1.6361E-4,1.3516E-4,1.411E-4,1.6312E-4,1.8197E-4,1.654E-4,1.3508E-4,1.4085E-4,1.6285E-4,1.8516E-4,1.6513E-4,1.3504E-4,1.4027E-4,1.6187E-4,1.8348E-4,1.6549E-4,1.3506E-4,1.4075E-4,1.6262E-4,1.8355E-4,1.6549E-4,1.3459E-4,1.416E-4,1.6241E-4,1.8184E-4,1.6708E-4,1.3589E-4,1.4109E-4,1.6259E-4,1.8266E-4,1.6689E-4,1.3551E-4,1.4116E-4,1.6218E-4,1.8309E-4,1.6729E-4,1.349E-4,1.3981E-4,1.6249E-4,1.8215E-4,1.6731E-4,1.35E-4,1.3978E-4,1.6372E-4,1.8291E-4,1.6665E-4,1.3439E-4,1.3995E-4,1.6184E-4,1.8225E-4,1.6682E-4,1.3554E-4,1.4008E-4,1.6117E-4,1.8191E-4,1.6819E-4,1.3469E-4,1.3965E-4,1.607E-4,1.8324E-4,1.6824E-4,1.3485E-4,1.4012E-4,1.6127E-4,1.8252E-4,1.6841E-4,1.3623E-4,1.3989E-4,1.6139E-4,1.8242E-4,1.694E-4,1.3615E-4,1.3926E-4,1.619E-4,1.8311E-4,1.6904E-4,1.3643E-4,1.3832E-4,1.6111E-4,1.8146E-4,1.6863E-4,1.3617E-4,1.3845E-4,1.6076E-4,1.8172E-4,1.6989E-4,1.3531E-4,1.3799E-4,1.5947E-4,1.8188E-4,1.7091E-4,1.3672E-4,1.3809E-4,1.6153E-4,1.8212E-4,1.7102E-4,1.3659E-4,1.3843E-4,1.605E-4,1.809E-4,1.6949E-4,1.3705E-4,1.3788E-4,1.6032E-4,1.8081E-4,1.7099E-4,1.3572E-4,1.3786E-4,1.6084E-4,1.8181E-4,1.7024E-4,1.3639E-4,1.3727E-4,1.5979E-4,1.8083E-4,1.7214E-4,1.3747E-4,1.3707E-4,1.5874E-4,1.7978E-4,1.7048E-4,1.3561E-4,1.3518E-4,1.6003E-4,1.8021E-4,1.7101E-4,1.3736E-4,1.3688E-4,1.6071E-4,1.8009E-4,1.7116E-4,1.3536E-4,1.3634E-4,1.5875E-4,1.7958E-4,1.7184E-4,1.3701E-4,1.3611E-4,1.5885E-4,1.7826E-4,1.7218E-4,1.3698E-4,1.3594E-4,1.5832E-4,1.7891E-4,1.7189E-4,1.369E-4,1.3598E-4,1.5752E-4,1.7891E-4,1.7286E-4,1.3685E-4,1.3617E-4,1.5858E-4,1.782E-4,1.722E-4,1.3729E-4,1.3595E-4,1.5836E-4,1.7823E-4,1.732E-4,1.3794E-4,1.3529E-4,1.5859E-4,1.7812E-4,1.7298E-4,1.375E-4,1.3483E-4,1.5748E-4,1.777E-4,1.7297E-4,1.3782E-4,1.3507E-4,1.5876E-4,1.7607E-4,1.7294E-4,1.379E-4,1.3508E-4,1.5771E-4,1.7763E-4,1.7368E-4,1.3674E-4,1.3527E-4,1.5784E-4,1.7876E-4,1.7357E-4,1.3762E-4,1.3345E-4,1.5714E-4,1.7784E-4,1.7374E-4,1.3803E-4,1.3424E-4,1.5792E-4,1.7721E-4,1.7456E-4,1.3784E-4,1.3402E-4,1.57E-4,1.776E-4,1.7352E-4,1.3757E-4,1.3398E-4,1.5678E-4,1.769E-4,1.7376E-4,1.3779E-4,1.3352E-4,1.5708E-4,1.7769E-4,1.7444E-4,1.38E-4,1.3368E-4,1.554E-4,1.7591E-4,1.7483E-4,1.3773E-4,1.3446E-4,1.5606E-4,1.7539E-4,1.7566E-4,1.3753E-4,1.3403E-4,1.5728E-4,1.7601E-4,1.7679E-4,1.3931E-4,1.3388E-4,1.565E-4,1.7547E-4,1.7587E-4,1.386E-4,1.3395E-4,1.5653E-4,1.7512E-4,1.7611E-4,1.3847E-4,1.3389E-4,1.5537E-4,1.742E-4,1.7631E-4,1.3839E-4,1.3285E-4,1.5636E-4,1.7524E-4,1.7602E-4,1.387E-4,1.3327E-4,1.5613E-4,1.7443E-4,1.7663E-4,1.3838E-4,1.322E-4,1.5604E-4,1.7482E-4,1.773E-4,1.3863E-4,1.3306E-4,1.5521E-4,1.7276E-4,1.7721E-4,1.395E-4,1.3204E-4,1.5538E-4,1.7391E-4,1.7597E-4,1.408E-4,1.3169E-4,1.5413E-4,1.725E-4,1.7666E-4,1.3919E-4,1.1895E-4:2
-2.8993E-5,-1.3E-4,2.2655E-4,-4.1404E-4,2.4532E-4,-2.9874E-4,1.3827E-4,2.4855E-4,-2.8651E-4,4.1191E-4,-1.2537E-4,1.6367E-4,3.421E-4,-3.0603E-4,2.9401E-4,-1.9515E-4,-1.6638E-4,4.2505E-4,-3.5667E-4,3.0588E-4,-6.9613E-5,2.7997E-5,2.441E-4,-2.3163E-4,3.6902E-4,-2.8474E-4,-6.647E-5,3.556E-4,-3.8758E-4,0.020386,0.13049,0.14223,0.12596,0.10386,0.11362,0.13373,0.14336,0.12401,0.10679,0.11234,0.13457,0.14378,0.12422,0.10675,0.11156,0.13359,0.14251,0.12377,0.10588,0.11084,0.13284,0.14275,0.12402,0.10628,0.11066,0.13283,0.14282,0.12412,0.1064,0.11045,0.1328,0.14305,0.1243,0.10668,0.11031,0.13295,0.14321,0.12472,0.10695,0.11014,0.13289,0.14335,0.12514,0.10706,0.1102,0.13266,0.14342,0.12566,0.10717,0.11001,0.13281,0.1433,0.12599,0.10724,0.10999,0.13276,0.14352,0.12626,0.10763,0.10988,0.13267,0.14348,0.12664,0.10759,0.10994,0.13257,0.14403,0.12719,0.10798,0.11006,0.1323,0.14413,0.12745,0.10798,0.1099,0.13239,0.14427,0.12759,0.10806,0.10955,0.13226,0.14405,0.12791,0.10804,0.10935,0.13176,0.14412,0.12794,0.1085,0.10931,0.13166,0.14405,0.12841,0.10839,0.10895,0.13141,0.14375,0.12867,0.10868,0.1088,0.13134,0.14388,0.12898,0.10883,0.10886,0.13113,0.14366,0.12921,0.10874,0.10853,0.13138,0.1438,0.12977,0.10892,0.10865,0.13094,0.14371,0.12983,0.10866,0.10817,0.13079,0.14379,0.13004,0.10898,0.10802,0.13044,0.1437,0.13,0.10924,0.10789,0.13003,0.14375,0.13022,0.10946,0.10777,0.12993,0.14336,0.13043,0.10919,0.10754,0.12972,0.14372,0.13076,0.10952,0.1072,0.12964,0.14336,0.13094,0.10962,0.10714,0.12932,0.14317,0.13104,0.10974,0.10709,0.1292,0.14303,0.13127,0.10956,0.10656,0.12872,0.14249,0.13144,0.10982,0.10672,0.12888,0.14275,0.13168,0.10997,0.10652,0.0:2
-1.2809E-4,3.4469E-4,-4.2198E-4,5.4137E-4,-1.0926E-4,1.137E-5,3.2156E-4,-2.9097E-4,1.8959E-4,1.3127E-5,-1.0384E-4,2.461E-4,-2.6219E-4,3.1039E-4,-9.2407E-5,-3.1682E-4,3.6177E-4,-2.3384E-4,1.8248E-4,5.2923E-5,-6.9417E-5,3.133E-4,-2.3648E-4,3.3354E-4,6.98E-5,-5.8823E-5,0.093351,0.11399,0.12255,0.14336,0.13998,0.11105,0.10954,0.12515,0.14257,0.13977,0.11204,0.10891,0.12564,0.14271,0.1402,0.11275,0.10859,0.12504,0.14274,0.14045,0.11307,0.10884,0.12502,0.14272,0.14091,0.11353,0.10861,0.12479,0.14291,0.14114,0.11384,0.10867,0.1244,0.14281,0.14149,0.11458,0.10858,0.12411,0.14277,0.14177,0.1147,0.10854,0.12395,0.14283,0.14207,0.11487,0.10848,0.12345,0.14277,0.14202,0.11521,0.10832,0.12345,0.14243,0.14272,0.1153,0.10831,0.12285,0.14234,0.14244,0.11579,0.10826,0.12268,0.14193,0.14272,0.11606,0.10784,0.12223,0.14188,0.14325,0.11626,0.10821,0.12186,0.14195,0.14337,0.1168,0.1082,0.12183,0.14226,0.14355,0.11683,0.10794,0.12138,0.14178,0.14384,0.11743,0.10804,0.12114,0.1418,0.14374,0.11752,0.10821,0.12061,0.14177,0.14416,0.11794,0.10775,0.1203,0.14096,0.14437,0.11806,0.10807,0.12027,0.14118,0.14434,0.11836,0.10793,0.11987,0.14076,0.14454,0.11894,0.10787,0.11931,0.14086,0.14477,0.11902,0.10793,0.11908,0.14054,0.14462,0.11941,0.10778,0.11865,0.14023,0.1448,0.11981,0.10797,0.11842,0.1403,0.14503,0.12028,0.10797,0.11813,0.13981,0.14515,0.12052,0.10783,0.1178,0.13966,0.14492,0.12069,0.10767,0.11776,0.13951,0.14555,0.12122,0.1078,0.11739,0.13948,0.1453,0.12146,0.10791,0.11704,0.13905,0.1455,0.12164,0.10776,0.11651,0.13886,0.14544,0.12217,0.10786,0.11625,0.13857,0.14575,0.12254,0.10768,0.11575,0.13837,0.14537,0.12265,0.10791,0.11563,0.13821,0.0:2
-7.1916E-4,0.0016712,-5.9798E-4,2.1338E-4,7.2869E-4,-9.7183E-4,0.0010774,-6.3425E-4,5.1835E-4,5.4172E-4,-0.0011974,0.0012401,-5.0083E-4,2.4197E-4,3.946E-4,-6.9804E-4,0.0013111,-1.9365E-4,3.1172E-4,2.7977E-5,-4.3935E-4,6.2403E-4,-8.149E-4,4.5934E-4,6.4042E-4,-9.4037E-4,9.6235E-4,0.32574,0.46287,0.45606,0.37403,0.34318,0.39828,0.46161,0.45346,0.37387,0.34106,0.39824,0.46008,0.45257,0.3739,0.34119,0.39764,0.46023,0.45179,0.37364,0.34038,0.39805,0.45979,0.45196,0.3734,0.34043,0.3981,0.4595,0.45176,0.37323,0.34024,0.39794,0.46031,0.45201,0.37355,0.34017,0.39824,0.45966,0.45128,0.37254,0.3399,0.39703,0.45894,0.45092,0.37254,0.33928,0.39679,0.45861,0.44948,0.37117,0.33827,0.39611,0.45802,0.44845,0.37089,0.33869,0.39642,0.45783,0.44904,0.37133,0.33888,0.39719,0.45891,0.44963,0.37168,0.33943,0.39781,0.459,0.44986,0.37153,0.33884,0.39644,0.45856,0.44854,0.36982,0.33824,0.39487,0.45673,0.44717,0.36931,0.33717,0.39464,0.45653,0.44749,0.36993,0.33789,0.39591,0.45689,0.44769,0.37017,0.33749,0.39586,0.45671,0.4466,0.36875,0.33668,0.39416,0.45559,0.446,0.36868,0.33664,0.39417,0.45611,0.44662,0.36945,0.33687,0.39512,0.45643,0.44706,0.36808,0.3364,0.39424,0.45401,0.44414,0.36661,0.33495,0.39289,0.45369,0.44387,0.36792,0.3364,0.39436,0.45533,0.44525,0.36753,0.33563,0.39289,0.45433,0.44244,0.36522,0.33424,0.39182,0.45299,0.44322,0.36618,0.33517,0.39302,0.45382,0.44418,0.36564,0.33478,0.39241,0.45239,0.44224,0.36436,0.33347,0.39177,0.45285,0.44244,0.36522,0.33476,0.39293,0.45252,0.44183,0.36464,0.33286,0.39122,0.45142,0.44094,0.36423,0.33429,0.39243,0.45208,0.44138,0.36408,0.33337,0.39082,0.45058,0.43963,0.36246,0.33229,0.39048,0.45131,0.44,0.0:2
-3.8634E-4,5.3122E-4,-2.0427E-4,-2.9619E-4,5.4668E-4,-4.4859E-4,5.9092E-4,-4.691E-5,1.2906E-4,5.1598E-4,-5.3742E-4,3.4093E-4,2.2155E-4,-2.942E-4,4.0172E-4,-2.7093E-4,6.8789E-4,-1.8154E-4,-1.147E-4,4.8951E-4,-6.6054E-4,3.55E-4,2.3259E-4,-1.6361E-4,2.9824E-4,0.28887,0.34303,0.38316,0.36876,0.30866,0.28206,0.33573,0.38285,0.37289,0.30332,0.28645,0.33252,0.383,0.37367,0.30334,0.28678,0.3322,0.38359,0.37498,0.30439,0.28747,0.33231,0.38377,0.37514,0.30502,0.28739,0.33162,0.38395,0.37556,0.30535,0.28697,0.33177,0.3838,0.37619,0.30587,0.28705,0.331,0.38271,0.37641,0.30565,0.28661,0.33016,0.38221,0.37629,0.30534,0.28583,0.32841,0.38209,0.37579,0.30552,0.28548,0.32755,0.38218,0.37634,0.30582,0.28605,0.32716,0.38147,0.3771,0.30701,0.28628,0.32745,0.38146,0.37784,0.30767,0.28586,0.32725,0.38124,0.37824,0.30802,0.28577,0.32651,0.38046,0.37805,0.30744,0.28525,0.32533,0.3799,0.37671,0.30734,0.28433,0.32377,0.37957,0.37717,0.30757,0.28437,0.32394,0.38001,0.37828,0.30882,0.28499,0.324,0.37954,0.37829,0.30888,0.28414,0.32229,0.37782,0.37746,0.30815,0.28311,0.32109,0.37708,0.37779,0.30848,0.28325,0.32141,0.3779,0.3785,0.30984,0.28395,0.32108,0.37669,0.37841,0.30928,0.28304,0.31927,0.37499,0.37726,0.30935,0.28244,0.31826,0.37583,0.37828,0.31054,0.28304,0.31941,0.3758,0.37887,0.3103,0.28225,0.31797,0.37342,0.37745,0.30886,0.28194,0.31626,0.37401,0.37813,0.31061,0.28192,0.31697,0.37386,0.37787,0.31067,0.28097,0.31519,0.3721,0.37722,0.3104,0.2808,0.31475,0.37267,0.37837,0.31115,0.28184,0.31489,0.37144,0.37801,0.31086,0.2797,0.31291,0.37072,0.37743,0.31139,0.28083,0.31311,0.37179,0.37803,0.31152,0.28039,0.31135,0.36969,0.37722,0.31087,0.0:2
4.957E-4,-3.4179E-4,4.4164E-4,-1.7611E-4,1.8227E-5,3.0998E-4,-3.7953E-4,5.8627E-4,-2.9047E-5,-3.1823E-5,5.7693E-4,-5.362E-4,4.6324E-4,-3.343E-4,-2.9201E-4,6.4068E-4,-5.2339E-4,5.8855E-4,-1.1374E-4,-1.218E-4,4.0145E-4,-3.6706E-4,4.985E-5,-1.792E-5,5.831E-5,5.406E-4,-2.6401E-4,3.6528E-4,3.0052E-4,-2.9401E-4,3.898E-4,-4.0292E-4,2.689E-4,1.8586E-4,0.22024,0.29593,0.24211,0.30424,0.33975,0.34114,0.28239,0.25562,0.29504,0.34314,0.34303,0.28009,0.25799,0.29315,0.34282,0.34366,0.28061,0.25809,0.29271,0.34327,0.34412,0.2812,0.25854,0.29264,0.34315,0.345,0.28183,0.25863,0.29155,0.34305,0.34543,0.28161,0.2587,0.29147,0.34267,0.34551,0.28326,0.25853,0.29158,0.34349,0.34623,0.2835,0.25923,0.29188,0.34344,0.34717,0.28395,0.25929,0.29167,0.34363,0.34762,0.28491,0.25943,0.29072,0.34303,0.34724,0.2848,0.25873,0.28956,0.34279,0.34641,0.28437,0.25823,0.28862,0.34092,0.34602,0.28432,0.25757,0.28802,0.34097,0.34632,0.28491,0.25775,0.28782,0.34112,0.34744,0.28593,0.25832,0.28811,0.34056,0.34782,0.28658,0.25828,0.28759,0.34006,0.34683,0.28613,0.25742,0.28556,0.33877,0.34629,0.28568,0.25708,0.28471,0.33813,0.34603,0.28555,0.2572,0.28504,0.33833,0.34704,0.28735,0.25785,0.28531,0.33823,0.34757,0.28687,0.2569,0.28329,0.33725,0.34677,0.28679,0.25635,0.28253,0.3364,0.34695,0.28773,0.2568,0.28274,0.33677,0.34667,0.28879,0.25666,0.2817,0.33549,0.34661,0.28788,0.25532,0.28046,0.33429,0.34636,0.2883,0.256,0.28092,0.33476,0.3471,0.28978,0.25653,0.27999,0.33456,0.34619,0.28939,0.25517,0.27847,0.33265,0.34607,0.28879,0.25575,0.27901,0.33363,0.34686,0.29067,0.25621,0.27841,0.33294,0.34595,0.28967,0.255,0.2766,0.33174,0.34628,0.2905,0.25561,0.27744,0.33236,0.34732,0.0:2
-0.023002,-0.012242,8.4535E-4,-0.022952,0.0077618,-0.017067,-0.0069031,0.0034744,-0.027227,0.014945,-0.022053,-0.01094,-0.0021379,-0.021684,0.0088057,-0.027894,3.5581,29.65,6.4878,9.8823,4.3896,8.9775,10.253,7.7018,7.5186,5.7704,8.5395,9.7549,8.5876,6.7528,6.3415,8.4369,9.657,8.9081,6.5546,6.5489,8.4054,9.6518,8.9992,6.489,6.6187,8.3826,9.6504,9.0193,6.4786,6.6046,8.3746,9.6453,9.026,6.439,6.6152,8.3658,9.6501,8.9772,6.4625,6.6131,8.3265,9.6217,8.9592,6.4345,6.5999,8.3132,9.5827,8.9569,6.4124,6.5769,8.2885,9.5556,8.9198,6.3949,6.5548,8.2566,9.524,8.8733,6.3822,6.5348,8.221,9.495,8.848,6.3836,6.5178,8.205,9.4472,8.8477,6.3444,6.5164,8.1682,9.4396,8.8223,6.3404,6.4922,8.1548,9.415,8.7981,6.3334,6.4846,8.1252,9.389,8.7761,6.3098,6.4615,8.0905,9.3808,8.7613,6.3114,6.4676,8.0739,9.358,8.7485,6.2972,6.4434,8.0411,9.3305,8.7234,6.2772,6.4345,8.0215,9.3096,8.7033,6.2766,6.428,8.0075,9.3045,8.6845,6.267,6.4183,7.9807,9.2697,8.6678,6.2517,6.4096,7.9606,9.2562,8.6526,6.2388,6.3914,7.9456,9.2427,8.6351,6.222,6.3902,7.8976,9.2207,8.6026,6.2108,6.3723,7.9044,9.202,8.6096,6.195,6.3672,7.8805,9.1928,8.5886,6.2082,6.3528,7.8766,9.1792,8.5869,6.1936,6.3496,7.8528,9.1656,8.5754,6.1846,6.3403,7.8306,9.1568,8.5612,6.1831,6.3243,7.8374,9.1454,8.5648,6.1797,6.3265,7.8269,9.1387,8.5589,6.1829,6.3244,7.8111,9.1509,8.5493,6.1977,6.313,7.816,9.1349,8.5546,6.1788,6.296,7.7994,9.1192,8.5407,6.1674,6.3214,7.7726,9.1112,8.5421,6.1594,0.0:2
-0.023594,0.014574,-0.022959,-0.014802,0.0022974,-0.029155,0.016835,-0.022436,-0.0059669,0.0028339,-0.027991,0.012856,-0.022893,-0.0070078,-8.6192E-5,-0.023849,0.012789,-0.021431,-0.0037443,0.0029407,-0.028597,0.016328,-0.02092,-0.005636,15.278,15.55,3.679,9.1907,8.6529,8.7852,9.6705,4.8662,7.7527,8.6042,9.5177,8.7026,5.7461,7.3574,8.6746,9.7153,8.3824,5.9806,7.2465,8.7463,9.7995,8.3067,6.0559,7.209,8.7432,9.8227,8.2749,6.0704,7.2111,8.7343,9.8102,8.2643,6.099,7.1995,8.7044,9.8033,8.2459,6.0605,7.1919,8.7094,9.7784,8.2095,6.0562,7.1687,8.6771,9.7547,8.1541,6.0514,7.1386,8.6442,9.7217,8.122,6.026,7.127,8.6185,9.6613,8.1003,5.9965,7.1242,8.5992,9.6464,8.0655,5.973,7.1147,8.5627,9.6207,8.0399,5.9697,7.0951,8.5486,9.5934,8.0017,5.9452,7.0909,8.515,9.5712,7.9859,5.9374,7.0895,8.487,9.5598,7.9581,5.9254,7.0729,8.4761,9.5376,7.9229,5.9148,7.0701,8.4554,9.5075,7.8964,5.9062,7.0611,8.4317,9.4975,7.8814,5.8857,7.053,8.42,9.4791,7.8552,5.8807,7.0318,8.4006,9.444,7.8172,5.8803,7.018,8.3903,9.4317,7.7888,5.8559,7.0243,8.3638,9.4158,7.7698,5.847,7.0009,8.3536,9.3948,7.7514,5.8315,6.9914,8.3212,9.3804,7.7272,5.8339,6.9877,8.3101,9.3665,7.7099,5.8089,6.9918,8.2963,9.357,7.6855,5.8168,6.9652,8.3006,9.3231,7.6823,5.7961,6.9716,8.2927,9.3155,7.6619,5.7904,6.9566,8.2749,9.309,7.6365,5.7927,6.9393,8.2689,9.2823,7.6411,5.7777,6.9476,8.2664,9.2938,7.6191,5.7718,6.9601,8.2593,9.2823,7.6067,5.7774,6.9455,8.2502,9.2811,7.5885,5.7784,6.9373,8.2557,9.2559,0.0:2
-0.029068,0.024295,-0.023762,-0.0015284,0.0033967,-0.026879,0.016192,-0.016929,-0.0092177,0.011608,-0.026455,0.019188,-0.022574,-0.0082642,0.010525,-0.024622,0.014059,0.026082,6.7481,6.2967,5.3365,5.2185,6.32,6.8812,6.4092,5.247,5.3,6.2918,6.9049,6.4255,5.2484,5.3065,6.2979,6.9055,6.4313,5.2456,5.3093,6.2946,6.8973,6.4341,5.246,5.3053,6.2974,6.9082,6.4418,5.2536,5.3147,6.2975,6.911,6.4476,5.2463,5.3187,6.2984,6.9182,6.4484,5.2532,5.3099,6.2759,6.9178,6.4379,5.2426,5.2946,6.2786,6.906,6.4396,5.2493,5.3005,6.2851,6.8937,6.4441,5.2432,5.2917,6.2793,6.9032,6.4457,5.2486,5.2979,6.2786,6.9113,6.45,5.2542,5.3003,6.2815,6.8993,6.453,5.2486,5.2982,6.2747,6.9033,6.4625,5.2538,5.3033,6.2758,6.9042,6.4462,5.2481,5.293,6.26,6.8989,6.4513,5.2403,5.2911,6.246,6.9011,6.4297,5.2441,5.2879,6.2452,6.8987,6.4398,5.2382,5.2727,6.2471,6.9063,6.4449,5.2545,5.2747,6.246,6.8933,6.4432,5.2558,5.2773,6.245,6.8947,6.4365,5.2448,5.2671,6.2405,6.8837,6.4339,5.24,5.2646,6.2366,6.8829,6.4348,5.2386,5.2569,6.2316,6.8786,6.4383,5.2313,5.262,6.2262,6.875,6.4296,5.2358,5.2515,6.2154,6.8839,6.4265,5.2221,5.2495,6.204,6.8756,6.4205,5.2206,5.2356,6.2007,6.8642,6.4208,5.2289,5.2437,6.2086,6.86,6.4116,5.2165,5.2286,6.1954,6.8373,6.4049,5.2189,5.2259,6.1809,6.8282,6.4126,5.2227,5.2247,6.1813,6.8416,6.4189,5.2176,5.2173,6.1689,6.8366,6.4057,5.2102,5.2126,6.1624,6.8316,6.4004,5.21,5.2113,6.1552,6.8242,6.4084,5.2104,5.2005,6.1305,6.8017,6.3838,0.0:2
-9.0535E-4,0.0088859,-0.035206,0.019465,-0.016349,-0.005641,0.0089091,-0.025937,0.027493,-0.018019,-1.8748E-4,0.0024681,-0.027735,0.022339,-0.017417,0.00133,0.014925,-0.028702,0.021982,-0.017282,-0.0015174,0.0072218,-0.024461,4.8566,6.1597,6.7734,6.4264,5.4378,5.0235,6.0244,6.7769,6.5142,5.357,5.1067,6.0008,6.7704,6.5371,5.3474,5.1077,5.9956,6.781,6.5613,5.3638,5.1167,5.9943,6.7699,6.5533,5.3564,5.1135,5.9822,6.7608,6.5597,5.3572,5.1103,5.9729,6.7605,6.5566,5.3558,5.0984,5.9681,6.7658,6.5632,5.3581,5.1005,5.9582,6.753,6.5746,5.3696,5.1039,5.9552,6.756,6.5726,5.372,5.1051,5.9514,6.7648,6.5797,5.3689,5.094,5.9397,6.7641,6.5677,5.3644,5.0768,5.9343,6.7531,6.5777,5.3733,5.0844,5.9337,6.7545,6.581,5.3825,5.0878,5.936,6.7374,6.5804,5.3859,5.0897,5.9165,6.7267,6.5762,5.3691,5.075,5.8984,6.73,6.5839,5.3761,5.0777,5.8992,6.7199,6.5926,5.3779,5.074,5.9001,6.7286,6.5828,5.3781,5.0667,5.8812,6.7143,6.5815,5.3712,5.0595,5.8715,6.7286,6.5743,5.3741,5.0613,5.8811,6.7157,6.5776,5.3875,5.0656,5.8845,6.712,6.5731,5.3845,5.0501,5.8617,6.6969,6.5754,5.3741,5.0458,5.8567,6.7052,6.5809,5.3818,5.052,5.8568,6.6862,6.5765,5.3743,5.0363,5.8269,6.696,6.5774,5.3742,5.0416,5.8309,6.6856,6.5758,5.384,5.0409,5.8221,6.6817,6.5728,5.3789,5.0265,5.8212,6.6715,6.5706,5.3882,5.0295,5.82,6.678,6.5688,5.3817,5.0185,5.8068,6.6546,6.5634,5.3752,5.0192,5.7962,6.6618,6.5694,5.3845,5.013,5.7815,6.6402,6.568,5.366,5.0035,5.7715,6.6295,6.5729,5.3745,5.0116,5.7669,0.0:2
-0.01146,0.014249,-0.02892,0.017363,-0.016588,-0.0068821,0.015934,-0.020473,0.018345,-0.0086791,-0.012919,0.014899,-0.027951,0.014647,-0.011072,-0.0069171,0.012853,-0.022491,0.016368,-0.011161,5.7953,5.7919,4.8428,5.647,6.484,6.6672,5.6991,4.9364,5.5726,6.5137,6.6984,5.7005,4.9601,5.5685,6.524,6.7008,5.7141,4.9659,5.5775,6.5447,6.7118,5.7262,4.9648,5.5725,6.5251,6.7073,5.7295,4.9777,5.5742,6.5264,6.711,5.7261,4.9679,5.5662,6.532,6.7112,5.7319,4.961,5.5632,6.5258,6.7122,5.7381,4.9553,5.5554,6.5216,6.7125,5.7507,4.9648,5.5599,6.5059,6.7167,5.7482,4.9696,5.5534,6.5127,6.7175,5.7412,4.9588,5.5437,6.4976,6.715,5.7402,4.9564,5.5262,6.4928,6.7061,5.7421,4.948,5.5237,6.4863,6.6979,5.7505,4.9589,5.5214,6.4935,6.6961,5.742,4.9454,5.5033,6.4743,6.6942,5.7402,4.9434,5.4988,6.4769,6.6946,5.7588,4.9409,5.5023,6.4726,6.6984,5.7595,4.9395,5.4953,6.4634,6.6929,5.7518,4.9358,5.494,6.4541,6.6928,5.7491,4.9431,5.4863,6.4475,6.693,5.7567,4.9379,5.4769,6.4408,6.6915,5.7436,4.9277,5.4641,6.4348,6.6676,5.7549,4.9363,5.4638,6.4373,6.681,5.7532,4.921,5.4575,6.425,6.668,5.7518,4.9167,5.4443,6.4074,6.6782,5.756,4.9173,5.4482,6.4109,6.6681,5.7539,4.9172,5.4302,6.4024,6.6702,5.7426,4.9054,5.4157,6.382,6.6505,5.7453,4.9029,5.4102,6.3757,6.6451,5.7369,4.895,5.4005,6.363,6.6431,5.7435,4.8994,5.3981,6.3613,6.6409,5.7365,4.8909,5.3761,6.3511,6.625,5.7372,4.8921,5.3792,6.3573,6.6216,5.7448,4.8835,5.363,6.3323,6.6166,5.7435,4.8855,5.3692,6.3286,0.0:2
0.0025097,-0.029293,0.01912,-0.024074,0.0047427,-0.0021499,-0.023003,0.020508,-0.025664,-0.0011826,-0.0056014,-0.031149,0.022248,-0.033213,-0.0032407,-0.0077033,-0.025106,0.01972,-0.024213,-0.011061,0.0071128,1.1469,4.6544,5.5336,6.2626,6.1641,5.1937,4.6293,5.3995,6.3068,6.2108,5.1612,4.678,5.3657,6.3178,6.2201,5.1613,4.685,5.3524,6.3407,6.2271,5.1891,4.6994,5.35,6.3367,6.2389,5.1977,4.6934,5.3472,6.3399,6.2431,5.2128,4.6904,5.3457,6.3402,6.2436,5.2107,4.6896,5.3352,6.3301,6.2514,5.2215,4.6847,5.3311,6.3248,6.253,5.2321,4.688,5.3078,6.3255,6.2685,5.2455,4.6838,5.3103,6.311,6.2718,5.2492,4.6874,5.2993,6.3135,6.2894,5.2625,4.6906,5.2993,6.3225,6.297,5.2762,4.6975,5.2865,6.327,6.2876,5.2729,4.6885,5.2737,6.303,6.3027,5.2824,4.6976,5.2654,6.3107,6.2961,5.294,4.687,5.2557,6.3021,6.2982,5.2941,4.6851,5.2389,6.2941,6.2959,5.3175,4.6868,5.2431,6.2888,6.313,5.3259,4.6794,5.2224,6.2817,6.3102,5.3378,4.6807,5.2259,6.2719,6.3091,5.3462,4.678,5.2152,6.2745,6.3151,5.3512,4.6769,5.1975,6.2544,6.3185,5.3572,4.6789,5.1953,6.2462,6.3281,5.3543,4.6776,5.1751,6.2441,6.3271,5.3802,4.6845,5.1707,6.2459,6.3228,5.369,4.6888,5.1552,6.2522,6.3347,5.3979,4.6816,5.1474,6.2407,6.3251,5.4078,4.6848,5.1537,6.2352,6.3359,5.4049,4.6854,5.1406,6.2215,6.3355,5.4107,4.6801,5.1248,6.2153,6.3463,5.4268,4.6758,5.1225,6.2126,6.3396,5.4363,4.6862,5.1151,6.2047,6.3401,5.4391,4.6859,5.1077,6.1899,6.3459,5.4427,4.673,5.084,6.1799,6.3411,5.4669,4.6804,5.0781,6.1783,0.0:2
-0.030399,0.014133,-0.017922,-0.016217,0.011117,-0.026457,0.010864,-0.014779,-0.0093388,0.020723,-0.029613,0.01325,-0.01615,-0.013884,0.0093833,-0.029298,0.014356,-0.004677,-0.018613,0.019121,-0.029489,0.71167,6.6493,5.9691,5.2262,4.4421,5.5136,6.225,6.0547,5.0961,4.5652,5.4335,6.2464,6.1004,5.0989,4.5917,5.4251,6.2572,6.1126,5.1173,4.5971,5.4213,6.2664,6.1257,5.1181,4.5965,5.4019,6.2447,6.1211,5.1209,4.5866,5.3799,6.2466,6.1281,5.1267,4.5816,5.3691,6.2438,6.1427,5.1387,4.5901,5.3685,6.2505,6.1497,5.1518,4.588,5.3716,6.2478,6.1612,5.1703,4.6023,5.3623,6.2517,6.1634,5.1848,4.5917,5.3464,6.248,6.1807,5.1905,4.5758,5.3339,6.2354,6.1758,5.201,4.5893,5.3347,6.2399,6.1964,5.2096,4.5972,5.3224,6.2316,6.2034,5.2057,4.5925,5.3131,6.2218,6.2142,5.225,4.6041,5.3025,6.2234,6.2188,5.2326,4.5834,5.2881,6.2037,6.2136,5.2445,4.59,5.2781,6.2333,6.2158,5.2561,4.5915,5.2789,6.2106,6.2339,5.2636,4.5915,5.2565,6.213,6.2341,5.2778,4.5899,5.255,6.1985,6.2371,5.2875,4.5855,5.2416,6.1918,6.2528,5.2939,4.5921,5.2315,6.1844,6.2535,5.3006,4.5852,5.2205,6.1788,6.2529,5.3134,4.5959,5.2143,6.1655,6.2407,5.3113,4.5849,5.1955,6.1603,6.2619,5.321,4.5843,5.1886,6.1577,6.2517,5.3339,4.5815,5.181,6.1451,6.2606,5.3426,4.5807,5.1654,6.1552,6.2636,5.3567,4.5889,5.1472,6.125,6.2779,5.3614,4.59,5.1544,6.1364,6.2664,5.3691,4.5842,5.1459,6.1338,6.2705,5.3847,4.5879,5.1344,6.1209,6.2723,5.4014,4.5891,5.1225,6.1202,6.2807,5.3952,4.59,5.1186,6.1107,6.2908,5.4174,0.0:2
12.191,12.734,10.555,9.4909,10.6,12.159,12.719,10.593,9.4917,10.644,12.125,12.707,10.589,9.4814,10.654,12.191,12.782,10.704,9.5062,10.691,12.177,12.777,10.743,9.5168,10.754,12.217,12.858,10.8,9.5209,10.784,12.15,12.844,10.83,9.5293,10.835,12.203,12.958,10.869,9.5261,10.854,12.168,12.961,10.825,9.5102,10.873,12.121,13.051,10.842,9.5556,10.864,12.137,13.122,10.857,9.5643,10.851,12.127,13.174,10.864,9.6387,10.9,12.18,13.203,10.831,9.6338,10.819,12.152,13.245,10.852,9.6921,10.821,12.181,13.293,10.847,9.7185,10.817,12.211,13.293,10.855,9.7403,10.803,12.209,13.341,10.913,9.8173,10.815,12.27,13.338,10.899,9.8037,10.786,12.278,13.354,10.896,9.823,10.755,12.303,13.38,10.899,9.8587,10.745,12.316,13.333,10.894,9.8884,10.731,12.361,13.285,10.9,9.8748,10.725,12.426,13.286,10.977,9.9029,10.715,12.396,13.214,11.008,9.8625,10.696,12.412,13.187,11.038,9.8607,10.719,12.461,13.191,11.104,9.8517,10.735,12.422,13.161,11.134,9.8132,10.737,12.41,13.179,11.174,9.7942,10.769,12.419,13.206,11.246,9.8061,10.797,12.398,13.176,11.289,9.7941,10.81,12.328,13.135,11.252,9.7267,10.82,12.376,13.224,11.34,9.7435,10.821,12.294,13.155,11.31,9.7244,10.844,12.254,13.224,11.375,9.714,10.833,12.227,13.248,11.344,9.7108,10.88,12.23,13.277,11.328,9.6786,10.82,12.172,13.361,11.327,9.7336,10.806,12.14,13.374,11.288,9.7399,10.783,12.12,13.362,11.251,9.7662,10.779,12.132,13.419,11.277,9.7682,10.713,12.098,13.44,11.281,9.8171,10.681,12.098,13.41,11.246,9.8457,10.7,12.138,13.39,11.22,9.8423,10.666,12.125,13.438,11.242,9.8802,10.623,12.13,13.407,11.233,9.8667,10.571,12.142,13.416,11.245,9.9007,10.538,12.108,13.318,11.183,9.9041,10.54,12.183,13.347,11.227,9.9161,10.507,12.177,13.258,11.199,9.9086,10.489,12.227,13.248,11.297,9.9214,10.502,12.244,13.249,11.388,9.905,10.488,12.236,13.191,11.429,9.9503,10.581,12.317,13.206,11.468,9.8835,10.57,12.299,13.26,11.602,9.9083,10.588,12.256,13.228,11.618,9.8975,10.635,12.283,13.256,11.697,9.9008,10.63,12.199,13.196,11.657,9.8579,10.631,12.224,13.268,11.768,9.8638,10.641,12.187,13.263,11.765,9.8269,10.675,12.149,13.283,11.754,9.8219,10.677,12.092,13.291,11.79,9.787,10.666,12.064,13.351,11.79,9.8228,10.677,12.054,13.357,11.752,9.8497,10.699,12.061,13.421,11.747,9.8577,10.64,12.011,13.481,11.74,9.8959,10.617,12.022,13.473,11.699,9.9338,10.607,12.058,13.511,11.715,9.956,10.547,11.998,13.491,11.705,9.9774,10.547,12.033,13.505,11.713,10.011,10.534,12.075,13.532,11.758,10.081,10.534,12.088,13.537,11.76,10.074,10.469,12.11,13.544,11.74,10.113,10.472,12.14,13.501,11.753,10.13,10.446,12.141,13.462,11.769,10.158,10.423,12.178,13.394,11.765,10.149,10.394,12.206,13.362,11.845,10.147,10.385,12.192,13.321,11.911,10.153,10.396,12.193,13.297,11.983,10.128,10.411,12.182,13.259,12.01,10.095,10.442,12.221,13.281,12.061,10.071,10.445,12.144,13.259,12.14,10.069,10.461,12.144,13.281,12.176,10.046,10.472,12.112,13.236,12.183,10.041,10.486,12.062,13.264,12.212,10.01,10.458,12.047,13.261,12.25,9.9998,10.506,12.0,13.307,12.264,9.993,10.502,11.949,13.31,12.271,10.011,10.526,11.969,13.377,12.266,9.9707,10.486,11.901,13.389,12.244,10.019,10.5,11.905,13.395,12.218,10.062,10.479,11.886,13.45,12.207,10.067,10.419,11.866,13.505,12.199,10.108,10.407,11.891,13.479,12.197,10.164,10.397,11.879,13.456,12.179,10.168,10.343,11.897,13.497,12.214,10.21,10.326,11.909,13.46,12.231,10.235,10.303,11.901,13.448,12.224,10.273,10.296,11.9,13.418,12.21,10.285,10.25,11.896,13.384,12.196,10.305,10.215,11.943,13.32,12.225,10.327,10.199,11.963,13.3,12.286,10.326,10.162,11.976,13.247,12.321,10.3,10.172,12.013,13.197,12.381,10.295,10.163,11.958,13.189,12.459,10.279,10.169,11.954,13.162,12.487,10.237,10.195,11.947,13.132,12.55,10.225,10.208,11.885,13.121,12.586,10.225,10.226,11.874,13.115,12.599,10.161,10.191,11.828,13.111,12.638,10.167,10.231,11.815,13.098,12.655,10.159,10.22,11.75,13.124,12.685,10.145,10.255,11.738,13.147,12.684,10.128,10.229,11.686,13.132,12.685,10.145,10.274,11.675,13.199,12.683,10.166,10.25,11.623,13.188,12.646,10.154,10.213,11.613,13.248,12.629,10.2,10.214,11.585,13.245,12.595,10.228,10.186,11.565,13.276,12.619,10.283,10.151,11.586,13.281,12.58,10.278,10.112,11.585,13.221,12.571,10.346,10.124,11.625,13.249,12.575,10.328,10.029,11.588,13.235,12.584,10.399,10.062,11.669,13.245,12.572,10.434,10.047,11.641,13.152,12.529,10.431,9.9925,11.669,13.194,12.654,10.539,10.052,11.728,13.171,12.663,10.536,9.9882,11.706,13.077,12.711,10.549,9.9786,11.737,13.034,12.708,10.467,9.9664,11.8,13.055,12.765,10.447,9.9227,11.703,12.967,12.874,10.496,10.02,11.721,12.938,12.851,10.4,9.9687,11.677,12.964,12.94,10.443,10.017,11.662,12.95,13.001,10.426,10.041,11.626,12.941,13.04,10.428,10.055,11.613,12.929,13.063,10.423,10.069,11.59,12.94,13.091,10.395,10.097,11.591,12.977,13.135,10.419,10.108,11.526,12.996,13.147,10.406,10.111,11.505,13.048,13.141,10.39,10.134,11.501,13.073,13.116,10.429,10.156,11.503,13.163,13.137,10.472,10.144,11.463,13.175,13.073,10.487,10.124,11.441,13.168,13.02,10.557,10.113,11.461,13.175,13.005,10.577,10.047,11.412,13.141,12.998,10.602,10.027,11.451,13.159,13.013,10.654,9.9994,11.439,13.063,12.992,10.708,10.023,11.479,13.081,12.992,10.703,9.9545,11.458,13.064,13.016,10.759,9.937,11.462,13.011,12.996,10.808,9.9644,11.522,13.015,13.026,10.815,9.8949,11.475,12.924,13.057,10.859,9.9041,11.551,12.872,13.047,10.779,9.8676,11.572,12.892,13.176,10.826,9.8588,11.513,12.821,13.224,10.811,9.8723,11.531,12.783,13.254,10.787,9.8925,11.502,12.773,13.34,10.771,9.8917,11.441,12.752,13.336,10.735,9.8981,11.403,12.713,13.366,10.738,9.9736,11.428,12.771,13.407,10.723,9.9368,11.326,12.725,13.425,10.726,9.9514,11.297,12.745,13.423,10.746,10.006,11.301,12.804,13.446,10.736,10.012,11.244,12.8,13.497,10.793,10.043,11.198,12.791,13.449,10.771,10.065,11.209,12.873,13.411,10.747,10.015,11.184,12.89,13.415,10.83,10.059,11.153,12.889,13.341,10.843,10.011,11.11,12.893,13.326,10.915,10.016,11.147,12.893,13.278,10.923,9.9709,11.155,12.893,13.314,11.042,9.9764,11.146,12.834,13.299,11.087,9.9776,11.197,12.863,13.289,11.113,9.9277,11.187,12.825,13.308,11.169,9.8871,11.128,12.739,13.291,11.232,9.9037,11.197,12.77,13.298,11.221,9.8483,11.187,12.708,13.302,11.262,9.8516,11.237,12.675,13.358,11.257,9.8165,11.197,12.587,13.363,11.263,9.8297,11.24,12.608,13.451,11.268,9.8209,11.179,12.53,13.502,11.274,9.8575,11.177,12.475,13.526,11.249,9.8867,11.185,12.527,13.564,11.218,9.89,11.134,12.517,13.578,11.232,9.9142,11.061,12.413,13.569,11.218,9.9544,11.061,12.511,13.633,11.216,9.9175,10.966,12.477,13.623,11.216,9.9648,10.972,12.486,13.594,11.236,10.01,10.961,12.511,13.611,11.183,9.9819,10.86,12.518,13.626,11.222,10.032,10.859,12.514,13.518,11.199,10.053,10.844,12.551,13.543,11.276,10.05,10.788,12.56,13.465,11.324,10.074,10.814,12.608,13.461,11.376,10.046,10.796,12.558,13.394,11.402,9.9914,10.771,12.574,13.416,11.508,9.9999,10.784,12.494,13.346,11.543,9.9903,10.832,12.528,13.341,11.561,9.9294,10.826,12.488,13.367,11.642,9.9317,10.804,12.432,13.351,11.666,9.9256,0.0:3
34.469,36.761,29.723,26.484,28.674,34.861,36.281,29.886,26.525,29.084,35.709,36.158,30.547,26.57,29.287,35.498,35.73,30.445,25.962,29.073,34.636,35.497,30.179,25.741,29.442,34.7,36.708,30.255,26.631,30.046,35.129,36.894,29.896,26.58,29.19,34.51,36.507,29.351,26.206,28.474,34.965,35.913,29.794,26.444,29.045,35.806,36.171,30.545,26.445,29.287,35.402,35.413,30.111,25.612,28.89,34.304,35.353,29.904,25.791,29.371,34.196,35.981,29.66,26.402,29.456,34.373,36.309,29.339,25.872,28.371,34.247,35.954,29.044,26.051,28.266,34.71,35.408,29.557,26.187,28.925,35.5,35.239,29.759,25.968,28.849,34.828,35.02,29.927,25.554,28.885,33.872,35.408,29.878,25.716,29.102,34.054,36.165,29.659,26.247,29.238,34.321,36.463,29.366,26.156,28.435,34.089,35.759,28.929,26.172,28.705,35.293,35.517,29.724,26.41,29.196,35.696,35.47,30.043,26.091,29.313,35.38,35.43,30.334,25.901,29.729,35.121,36.279,30.196,26.423,30.247,35.481,37.238,30.175,26.762,29.714,35.13,36.891,29.462,26.576,29.041,35.265,36.511,30.017,26.912,29.518,36.464,36.385,30.63,26.96,29.906,36.193,35.874,30.392,26.086,29.442,35.162,35.612,30.299,26.079,30.103,35.326,36.675,30.229,26.928,30.553,35.818,37.279,30.024,27.057,29.904,35.473,36.975,29.714,26.888,29.58,36.794,36.882,30.649,27.235,30.219,37.266,36.73,31.037,27.092,30.285,36.394,35.999,30.741,26.43,30.57,35.796,36.713,30.907,27.219,30.965,36.376,37.905,30.681,27.534,30.705,36.05,37.774,30.119,27.181,29.7,36.403,36.991,30.324,27.431,30.473,37.343,36.69,30.985,27.471,30.702,37.025,36.32,30.804,26.525,30.37,36.128,36.647,30.897,26.844,30.891,36.247,37.809,30.796,27.764,31.459,36.725,38.283,30.648,27.589,30.366,36.666,37.645,30.584,27.964,31.051,38.176,37.573,31.471,28.004,31.263,37.871,37.049,31.505,27.325,31.087,36.975,36.766,31.167,27.092,31.355,36.682,37.571,30.833,27.92,32.013,37.086,38.111,30.639,27.774,30.57,36.471,37.556,30.349,27.794,30.694,37.806,37.37,31.344,28.072,31.222,37.728,36.88,31.512,27.385,30.732,36.781,36.452,31.128,27.041,31.465,36.91,37.804,31.127,27.774,31.858,37.354,38.378,30.854,28.004,31.161,36.997,38.279,30.602,28.046,31.11,38.443,38.027,31.682,28.468,32.107,39.197,37.764,31.738,27.828,31.539,37.709,36.821,31.355,27.267,31.66,37.03,37.365,30.955,28.238,32.256,37.402,38.399,30.979,28.032,31.174,36.685,37.761,30.243,27.71,30.638,37.653,37.319,30.916,27.951,31.479,38.74,37.438,31.507,27.723,31.374,37.632,36.687,31.235,27.126,31.514,36.909,37.378,31.096,27.777,31.966,37.317,38.158,30.825,28.005,31.412,36.914,37.984,30.178,27.572,30.557,37.559,37.26,30.583,27.692,31.241,38.488,37.213,31.353,27.863,31.448,37.788,36.726,31.183,27.058,31.336,36.982,37.151,31.098,27.572,31.854,37.305,38.028,30.742,28.038,31.599,37.005,38.052,30.238,27.66,30.706,37.287,37.025,30.293,27.817,31.324,38.495,37.111,31.23,28.019,31.834,38.056,36.601,31.044,27.158,31.405,37.11,37.297,31.224,27.605,32.185,37.541,38.154,30.907,28.134,31.778,37.077,38.15,30.346,27.754,30.772,37.261,37.181,30.352,27.911,31.183,38.213,37.086,31.056,27.959,31.785,38.344,36.727,30.982,27.041,31.344,37.18,36.687,30.885,27.566,32.355,37.543,37.929,30.872,28.127,32.134,37.65,38.236,30.329,27.803,30.948,37.313,37.331,30.305,27.958,31.379,38.758,37.434,31.216,28.11,31.785,38.437,36.814,31.079,27.14,31.368,37.204,36.47,30.775,27.337,32.143,37.291,37.62,30.748,27.962,31.929,37.184,37.784,30.184,27.625,30.794,36.833,36.969,29.887,27.773,31.071,38.208,36.859,30.785,28.066,32.04,38.682,36.478,30.802,27.257,31.274,37.104,35.901,30.441,26.981,31.843,37.056,36.984,30.421,27.893,32.091,37.241,37.607,30.363,27.966,31.247,36.862,36.92,29.627,27.689,31.101,38.057,36.467,30.342,27.883,31.823,38.407,36.611,30.906,27.477,31.403,37.39,35.878,30.59,27.046,31.945,37.288,36.912,30.509,27.909,32.41,37.689,37.621,30.222,27.772,31.367,36.825,37.008,29.542,27.583,31.111,38.061,36.599,30.304,27.929,31.803,38.771,36.65,30.848,27.675,31.679,37.91,36.151,30.715,27.073,31.92,37.423,36.926,30.618,27.756,32.545,37.865,37.785,30.342,27.951,31.713,36.956,37.144,29.627,27.64,31.024,37.812,36.631,30.329,27.924,31.613,38.702,36.565,30.706,27.759,31.717,38.125,36.093,30.527,27.015,31.911,37.345,36.586,30.545,27.774,32.726,37.959,37.625,30.382,28.121,32.129,37.288,37.37,29.773,27.574,31.193,38.135,37.142,30.231,28.073,31.802,38.853,36.705,30.765,27.875,31.873,38.148,36.102,30.754,27.127,31.743,37.271,36.235,30.4,27.58,32.548,37.68,37.289,30.077,27.982,32.234,37.378,37.372,29.756,27.701,31.199,37.726,36.738,29.87,27.932,31.764,38.785,36.476,30.561,27.931,31.999,38.434,35.789,30.252,27.075,31.724,37.262,35.83,30.235,27.485,32.604,37.602,37.074,30.277,28.165,32.507,37.515,37.276,29.758,27.819,31.361,37.499,36.623,29.661,27.909,31.782,38.871,36.405,30.443,28.154,32.234,38.774,35.988,30.484,27.385,31.887,37.58,35.723,30.367,27.518,32.649,37.686,37.033,30.356,28.244,32.827,37.837,37.238,29.748,27.902,31.688,37.524,36.63,29.537,28.072,32.008,38.913,36.261,30.304,28.286,32.485,39.101,35.835,30.401,27.865,32.225,37.9,35.43,30.198,27.523,33.108,37.956,36.819,30.183,28.227,33.142,38.077,37.139,29.822,28.07,31.863,37.455,36.548,29.408,28.113,31.905,38.67,36.213,30.262,28.274,32.548,39.211,36.098,30.477,27.609,32.138,38.171,35.537,30.197,27.399,32.885,37.997,36.51,30.147,28.295,33.307,38.277,37.251,30.001,28.259,32.158,37.593,36.64,29.374,28.084,32.034,38.867,36.209,30.149,28.311,32.673,39.46,36.026,30.312,27.855,32.485,38.427,35.424,30.132,27.245,32.818,37.963,36.336,30.226,28.232,33.269,38.251,37.005,29.873,28.23,32.298,37.467,36.503,29.231,27.956,31.859,38.59,35.936,29.883,28.009,32.658,39.738,36.081,30.195,27.735,32.329,38.391,35.182,29.987,27.199,32.754,37.939,35.971,29.882,28.039,33.292,38.106,36.919,29.893,28.239,32.502,37.538,36.413,29.017,27.818,31.909,38.568,35.921,29.697,28.188,32.64,39.454,35.875,29.963,27.83,32.545,38.627,35.201,29.943,27.118,32.614,37.918,35.853,29.862,27.896,33.311,38.205,36.443,29.57,28.437,32.785,37.58,36.375,28.915,27.814,31.847,38.305,35.73,29.39,28.218,32.541,39.266,35.798,30.01,27.914,32.384,38.533,34.928,29.654,27.109,32.405,37.659,35.309,29.583,27.613,33.137,37.873,36.244,29.582,28.144,32.839,37.597,36.184,28.809,27.657,31.722,37.775,35.354,29.026,28.23,32.611,38.923,35.459,29.797,28.001,32.519,38.87,34.927,29.619,27.191,32.408,37.811,34.89,29.413,27.393,33.166,37.884,35.886,29.474,28.15,33.106,37.745,36.039,28.851,27.874,31.972,37.384,35.415,28.762,27.92,32.124,38.689,35.241,29.578,28.123,32.589,38.943,34.833,29.577,27.348,32.236,37.795,34.578,29.404,27.244,33.038,37.634,35.327,29.28,28.18,33.251,37.6,35.734,28.885,27.795,32.024,37.199,35.354,28.508,27.905,32.133,38.736,35.123,29.186,27.995,32.693,39.127,34.877,29.376,27.397,32.25,37.939,34.098,29.066,26.891,32.71,37.508,34.909,29.136,27.738,33.236,37.796,35.667,28.955,27.901,32.447,37.205,35.344,28.337,27.771,31.864,38.015,34.854,29.007,27.966,32.466,38.924,34.782,29.386,27.777,32.563,38.411,34.13,28.968,26.876,32.531,37.466,34.511,28.959,27.43,33.146,37.694,35.516,28.962,27.827,32.784,0.0:3
3.039E-4,2.5204E-4,2.5729E-4,3.1291E-4,3.45E-4,3.0399E-4,2.5028E-4,2.6016E-4,3.1029E-4,3.4382E-4,3.033E-4,2.5408E-4,2.5894E-4,3.1195E-4,3.4103E-4,3.018E-4,2.5053E-4,2.5938E-4,3.0763E-4,3.4313E-4,3.0165E-4,2.5273E-4,2.5719E-4,3.1145E-4,3.4376E-4,3.0535E-4,2.5237E-4,2.5759E-4,3.1117E-4,0.034478,0.053514,0.040735,0.048295,0.056217,0.060032,0.051146,0.042035,0.046712,0.055509,0.058027,0.051097,0.039654,0.045653,0.053744,0.056877,0.048079,0.038546,0.043248,0.050609,0.052103,0.043485,0.035202,0.038127,0.044338,0.04529,0.03706,0.029641,0.032467,0.037048,0.037442,0.030593,0.024158,0.025624,0.026212,0.022939,0.01612,0.011482,0.011648,0.011372,0.011065,0.0086095,0.0069244,0.0076916,0.0082079,0.0085404,0.0069056,0.005719,0.0062751,0.0069482,0.0073642,0.0060635,0.0051342,0.0057947,0.0065862,0.006987,0.005731,0.0048638,0.0054211,0.0061495,0.0065186,0.0053868,0.0046357,0.0052637,0.0060523,0.0063653,0.0052773,0.0044658,0.0050608,0.0058023,0.0061568,0.005183,0.0044151,0.0050652,0.0057879,0.0060798,0.0050683,0.0042644,0.0048797,0.0055781,0.0059003,0.0050124,0.0042345,0.0049328,0.0055741,0.0058862,0.0049504,0.004137,0.0048292,0.0054309,0.0058475,0.0049183,0.0041565,0.0048519,0.005381,0.0057776,0.0047694,0.0040611,0.0047552,0.0053322,0.0058325,0.004792,0.0041319,0.0047598,0.005308,0.0058005,0.0046891,0.004059,0.004657,0.005258,0.0057673,0.0046672,0.0040818,0.0046521,0.0052503,0.0057114,0.0046109,0.0040778,0.004639,0.0053115,0.0057295,0.0046336,0.0040693,0.0045981,0.0053012,0.005593,0.0046001,0.0040219,0.0046087,0.0053474,0.005611,0.0046543,0.0040239,0.004622,0.0053077,0.0055938,0.0046427,0.0039969,0.0046253,0.0052897,0.005559,0.0046307,0.0039553,0.0046171,0.0052314,0.0055063,0.0046489,0.0039643,0.0046918,0.0052558,0.0055685,0.004638,0.0039282,0.0046556,0.0051836,0.0055752,0.0046016,0.0039639,0.0046836,0.0051869,0.0056184,0.0045873,0.0039926,0.0046551,0.0051743,0.0056599,0.0045599,0.0040005,0.0046301,0.0051737,0.0056348,0.0:3
0.0020535,0.0023832,0.0023589,0.0019416,0.0017943,0.002056,0.0023858,0.0023555,0.0019423,0.0017944,0.0020555,0.0023831,0.0023592,0.0019392,0.0017972,0.0020622,0.0023885,0.0023517,0.001936,0.0017959,0.0020624,0.0023869,0.0023477,0.0019351,0.0017939,0.0020639,0.0023842,0.0023544,0.0019351,0.0017986,0.0020701,0.0023922,0.0023533,0.0019298,0.0017994,0.0020696,0.0023861,0.0023453,0.0019245,0.0017941,0.0020739,0.0023895,0.0023425,0.0019235,0.0017961,0.0020733,0.0023864,0.002344,0.0019204,0.0017982,0.0020741,0.002392,0.0023439,0.0019189,0.0017992,0.002081,0.0023945,0.0023428,0.0019196,0.0018037,0.0020821,0.0023882,0.002341,0.0019183,0.0018043,0.0020847,0.0023932,0.0023398,0.0019142,0.0018034,0.0020888,0.0023951,0.0023434,0.0019137,0.0018052,0.002089,0.0024051,0.0023372,0.0019145,0.0018047,0.0020933,0.0024,0.0023362,0.001907,0.0018038,0.0020957,0.0023985,0.0023348,0.0019077,0.0018031,0.0021018,0.0023982,0.0023346,0.0019066,0.001808,0.002103,0.0023926,0.0023289,0.0019007,0.0018047,0.0021055,0.0023954,0.0023219,0.0019006,0.0018055,0.0021081,0.0024003,0.0023236,0.0018961,0.0018053,0.0021073,0.0023953,0.0023223,0.0018934,0.0018081,0.0021078,0.0023959,0.0023204,0.0018907,0.001809,0.0021118,0.0023994,0.0023216,0.001893,0.0018075,0.0021125,0.002399,0.0023167,0.0018853,0.0018097,0.0021191,0.0024003,0.0023193,0.0018856,0.0018138,0.002118,0.0024004,0.0023154,0.0018883,0.0018151,0.0021225,0.0024052,0.0023181,0.0018861,0.0018137,0.0021255,0.0024041,0.041503,0.054306,0.04552,0.053665,0.063998,0.064111,0.051775,0.047193,0.052138,0.063324,0.062125,0.051832,0.045155,0.051387,0.061617,0.061785,0.049455,0.044451,0.049671,0.059443,0.058251,0.045964,0.042016,0.046049,0.05442,0.052958,0.041588,0.037486,0.040944,0.048225,0.046522,0.0366,0.03311,0.036383,0.042559,0.040608,0.03167,0.028193,0.029923,0.031076,0.026242,0.018076,0.015112,0.015646,0.015959,0.014798,0.010963,0.010004,0.010933,0.011865,0.011694,0.0090531,0.0086688,0.0096782,0.010824,0.010736,0.0082735,0.007926,0.0088583,0.010022,0.010004,0.0077757,0.0076238,0.0086056,0.0097806,0.0095782,0.0074142,0.0071983,0.0081377,0.0093475,0.0092816,0.0073321,0.0071905,0.0081663,0.0093168,0.0090553,0.0070935,0.0068695,0.0078662,0.0090506,0.0089167,0.0070875,0.0068874,0.0079374,0.0089533,0.0087569,0.0069543,0.0067363,0.0078639,0.0088712,0.0087899,0.0069768,0.0067638,0.0078533,0.0086763,0.0086278,0.0067806,0.0066675,0.0077929,0.0087127,0.0087505,0.0068015,0.0067048,0.0076885,0.008565,0.0086078,0.0066598,0.0066579,0.0077087,0.0086227,0.0086654,0.0066611,0.0066838,0.0076063,0.008565,0.0085069,0.00658,0.0066591,0.0076206,0.0086746,0.0084697,0.0066101,0.0066101,0.0075529,0.0086071,0.0083845,0.0066155,0.0066176,0.007601,0.0086487,0.0083332,0.0065951,0.0065354,0.0075875,0.0085927,0.0083009,0.0066387,0.0065795,0.0076999,0.0085991,0.0082678,0.0065719,0.0064618,0.0076088,0.0084449,0.0082794,0.0065653,0.0065462,0.0077058,0.0084559,0.0083316,0.0065231,0.0065542,0.0:3
2.7702E-4,3.0259E-4,3.6422E-4,3.6366E-4,2.9614E-4,2.7461E-4,3.0451E-4,3.641E-4,3.6233E-4,2.9559E-4,2.7565E-4,3.0273E-4,3.6737E-4,3.6219E-4,2.9644E-4,2.7444E-4,3.0293E-4,3.6692E-4,3.6236E-4,2.9693E-4,2.7453E-4,3.0346E-4,3.652E-4,3.6234E-4,2.9566E-4,2.7581E-4,3.0386E-4,3.6457E-4,3.6248E-4,2.9479E-4,2.7508E-4,3.0321E-4,3.6708E-4,3.618E-4,2.9511E-4,2.7542E-4,3.052E-4,3.6612E-4,3.619E-4,2.9379E-4,2.7639E-4,3.0402E-4,3.6616E-4,3.6222E-4,2.9305E-4,2.7437E-4,3.0506E-4,3.6634E-4,3.6192E-4,2.9369E-4,2.7432E-4,3.048E-4,3.6759E-4,3.6216E-4,2.923E-4,2.7496E-4,3.0629E-4,3.6675E-4,3.6057E-4,2.9234E-4,2.7749E-4,3.0553E-4,3.6561E-4,3.6185E-4,2.9335E-4,2.7584E-4,3.0383E-4,3.68E-4,3.6072E-4,2.935E-4,2.7659E-4,3.0659E-4,3.6724E-4,3.593E-4,2.9358E-4,2.7663E-4,3.0653E-4,3.6793E-4,3.6024E-4,2.9252E-4,2.7593E-4,3.071E-4,3.6662E-4,3.5979E-4,2.9165E-4,2.7595E-4,3.0655E-4,3.6717E-4,3.599E-4,2.9159E-4,2.7641E-4,3.0825E-4,3.6824E-4,3.5968E-4,2.9323E-4,2.7623E-4,3.0745E-4,3.6808E-4,3.6093E-4,2.9129E-4,2.7715E-4,3.0682E-4,3.6788E-4,3.6074E-4,2.911E-4,2.7647E-4,3.0749E-4,3.6922E-4,3.6126E-4,2.9094E-4,2.7606E-4,3.0781E-4,3.6805E-4,3.6046E-4,2.8959E-4,2.7655E-4,3.08E-4,3.6931E-4,3.6084E-4,2.9048E-4,2.7661E-4,3.0786E-4,3.6821E-4,3.5943E-4,0.001519,0.0012635,0.0010168,0.0010998,9.79E-4,7.3409E-4,7.6822E-4,8.4583E-4,9.6774E-4,9.1206E-4,7.2215E-4,7.4538E-4,8.4314E-4,9.6301E-4,9.0562E-4,7.2144E-4,7.4076E-4,8.3898E-4,9.5988E-4,9.0417E-4,7.1835E-4,7.3952E-4,8.3687E-4,9.5897E-4,9.0199E-4,7.206E-4,7.4169E-4,8.3818E-4,9.602E-4,8.9941E-4,7.1833E-4,7.4112E-4,8.3652E-4,9.5958E-4,9.0017E-4,7.161E-4,7.4023E-4,8.3943E-4,9.5983E-4,8.9755E-4,7.1595E-4,7.4022E-4,8.4116E-4,9.599E-4,8.9741E-4,7.1476E-4,7.41E-4,8.3967E-4,9.5828E-4,8.9329E-4,7.1654E-4,7.3904E-4,8.4111E-4,9.5821E-4,8.9397E-4,7.1334E-4,7.418E-4,8.4164E-4,9.5843E-4,8.95E-4,7.1345E-4,7.4052E-4,8.4284E-4,9.6165E-4,8.9165E-4,7.1152E-4,7.3969E-4,8.4217E-4,9.5696E-4,8.924E-4,7.1275E-4,7.4203E-4,8.4051E-4,9.5814E-4,8.8906E-4,7.107E-4,7.4198E-4,8.427E-4,9.5812E-4,8.8891E-4,7.1075E-4,7.4259E-4,8.4228E-4,9.5939E-4,8.8955E-4,7.1039E-4,7.4346E-4,8.4522E-4,9.5875E-4,8.8606E-4,7.1064E-4,7.4415E-4,8.4539E-4,9.5527E-4,8.8736E-4,7.1111E-4,7.4144E-4,8.4718E-4,9.5968E-4,8.8815E-4,7.0864E-4,7.4382E-4,8.4791E-4,9.5818E-4,8.8659E-4,7.0752E-4,7.4376E-4,8.4895E-4,9.6121E-4,8.8288E-4,7.0869E-4,7.4268E-4,8.4794E-4,9.5754E-4,8.8452E-4,7.0918E-4,7.4227E-4,8.4714E-4,9.5983E-4,8.8439E-4,7.08E-4,7.4569E-4,8.5007E-4,9.6051E-4,8.8302E-4,7.0614E-4,7.4573E-4,8.5087E-4,9.5506E-4,8.8087E-4,7.064E-4,7.4527E-4,8.5318E-4,9.5797E-4,8.8221E-4,7.065E-4,7.4627E-4,8.5023E-4,9.5885E-4,8.82E-4,7.0469E-4,7.4636E-4,8.5364E-4,9.596E-4,8.7988E-4,7.042E-4,7.4793E-4,8.5281E-4,9.5881E-4,8.7992E-4,7.0386E-4,7.4897E-4,8.5647E-4,9.5789E-4,8.7499E-4,7.0332E-4,7.4879E-4,8.5644E-4,9.5886E-4,8.7354E-4,7.0346E-4,7.4846E-4,8.5543E-4,9.5933E-4,8.7322E-4,7.0223E-4,7.4855E-4,8.5981E-4,9.5865E-4,8.723E-4,7.0362E-4,7.4954E-4,8.5837E-4,9.6003E-4,8.7294E-4,7.0107E-4,0.0:3
7.9221E-4,8.2147E-4,7.1277E-4,5.9344E-4,6.9703E-4,7.9261E-4,8.2512E-4,7.1234E-4,5.9563E-4,6.9909E-4,7.9187E-4,8.2396E-4,7.1395E-4,5.9459E-4,6.9871E-4,7.9156E-4,8.251E-4,7.1605E-4,5.9319E-4,6.9501E-4,7.9147E-4,8.2541E-4,7.1383E-4,5.9664E-4,6.9331E-4,7.9028E-4,8.2719E-4,7.1688E-4,5.9512E-4,6.9515E-4,7.8862E-4,8.2589E-4,7.1802E-4,5.9402E-4,6.9612E-4,7.8911E-4,8.2578E-4,7.1774E-4,5.9261E-4,6.9227E-4,7.8948E-4,8.2779E-4,7.2013E-4,5.965E-4,6.9314E-4,7.9073E-4,8.2615E-4,7.1907E-4,5.9718E-4,6.9315E-4,7.8836E-4,8.2625E-4,7.19E-4,5.9574E-4,6.8946E-4,7.8529E-4,8.2793E-4,7.2032E-4,5.9645E-4,6.9164E-4,7.8785E-4,8.2796E-4,7.2011E-4,5.9503E-4,6.9072E-4,7.8646E-4,8.2919E-4,7.1817E-4,5.9633E-4,6.8968E-4,7.8549E-4,8.2854E-4,7.1821E-4,5.9622E-4,6.8573E-4,7.8712E-4,8.2745E-4,7.2142E-4,5.9825E-4,6.87E-4,7.8509E-4,8.2687E-4,7.2178E-4,5.9464E-4,6.8597E-4,7.8256E-4,8.3008E-4,7.2328E-4,5.9419E-4,6.875E-4,7.8204E-4,8.2735E-4,7.238E-4,5.9547E-4,6.8822E-4,7.8179E-4,8.2723E-4,7.2471E-4,5.9382E-4,6.8617E-4,7.8208E-4,0.019476,0.022838,0.017724,0.019335,0.021999,0.02558,0.022762,0.017746,0.019266,0.022041,0.025438,0.022688,0.017744,0.019037,0.021843,0.025245,0.022609,0.017539,0.018879,0.021552,0.024946,0.022225,0.017374,0.018496,0.02102,0.024414,0.021746,0.016799,0.0179,0.020186,0.023174,0.020489,0.015577,0.016214,0.017769,0.019989,0.017266,0.012942,0.013158,0.014592,0.017139,0.01522,0.011539,0.011788,0.013305,0.01595,0.01435,0.010987,0.011184,0.012703,0.015408,0.014017,0.010694,0.010872,0.012343,0.015076,0.013767,0.010489,0.010732,0.012063,0.014893,0.013647,0.010376,0.010598,0.011969,0.014797,0.013521,0.010337,0.010511,0.011778,0.014663,0.013474,0.010287,0.010448,0.01175,0.014582,0.013429,0.010294,0.010416,0.011727,0.014531,0.013433,0.010236,0.010357,0.011635,0.014508,0.013387,0.010209,0.010324,0.011647,0.014425,0.013418,0.010214,0.0103,0.011574,0.014393,0.013357,0.010175,0.010279,0.011489,0.014343,0.013366,0.0102,0.010262,0.011478,0.014313,0.013348,0.01018,0.010261,0.011467,0.014332,0.013325,0.010225,0.010195,0.011428,0.014285,0.013341,0.010197,0.010162,0.011392,0.014268,0.013323,0.010204,0.010174,0.011362,0.014291,0.013323,0.010223,0.010143,0.011358,0.01422,0.013332,0.010192,0.010155,0.011313,0.014188,0.013332,0.010194,0.010174,0.011316,0.014173,0.013358,0.010195,0.010094,0.011271,0.014173,0.013365,0.010198,0.010098,0.011212,0.014175,0.01344,0.010259,0.010079,0.01125,0.014093,0.013354,0.010244,0.010108,0.01121,0.014139,0.013382,0.010263,0.010085,0.011189,0.014125,0.013382,0.01023,0.010075,0.011208,0.014073,0.013399,0.010291,0.010036,0.01113,0.01407,0.013384,0.010269,0.010025,0.011106,0.01406,0.013392,0.010312,0.010042,0.01106,0.014014,0.013436,0.010279,0.010037,0.011094,0.014004,0.013465,0.01031,0.010002,0.011042,0.014029,0.013417,0.010291,0.009986,0.0:3
6.5857E-4,7.1407E-4,6.3189E-4,5.1355E-4,5.7872E-4,6.5974E-4,7.1297E-4,6.3102E-4,5.1468E-4,5.7854E-4,6.5942E-4,7.1324E-4,6.3051E-4,5.1291E-4,5.7977E-4,6.631E-4,7.1423E-4,6.2832E-4,5.1278E-4,5.8247E-4,6.6168E-4,7.1295E-4,6.272E-4,5.156E-4,5.8329E-4,6.6159E-4,7.1068E-4,6.28E-4,5.1128E-4,5.8259E-4,6.6614E-4,7.1042E-4,6.2526E-4,5.1358E-4,5.8314E-4,6.6272E-4,7.1238E-4,6.2438E-4,5.1097E-4,5.8356E-4,6.6571E-4,7.1192E-4,6.2416E-4,5.1055E-4,5.8482E-4,6.6833E-4,7.1123E-4,6.2308E-4,5.101E-4,5.8603E-4,6.6718E-4,7.1246E-4,6.1962E-4,5.1114E-4,5.8665E-4,6.6711E-4,7.0939E-4,6.2085E-4,5.1101E-4,5.8594E-4,6.6823E-4,7.1137E-4,6.2001E-4,5.0965E-4,5.8819E-4,6.7062E-4,7.0923E-4,6.2006E-4,5.0991E-4,5.8883E-4,6.7088E-4,7.0869E-4,6.1877E-4,5.1046E-4,5.8942E-4,6.7163E-4,7.0968E-4,6.4975E-4,0.01763,0.02022,0.021977,0.025522,0.0225,0.017761,0.019303,0.022577,0.025418,0.022587,0.016668,0.020018,0.021623,0.025167,0.021647,0.017462,0.018381,0.021843,0.024269,0.021037,0.016511,0.017818,0.020573,0.022665,0.019331,0.014973,0.016316,0.018433,0.019922,0.016608,0.012905,0.014171,0.016032,0.017402,0.014785,0.011599,0.012891,0.014551,0.015652,0.013211,0.010257,0.011348,0.012144,0.012096,0.0094016,0.0068674,0.0073166,0.0073058,0.0072961,0.0058239,0.0044396,0.004984,0.0051113,0.0053359,0.0043772,0.0034482,0.0039885,0.0042677,0.0046006,0.003863,0.0031151,0.0035628,0.0038692,0.0041665,0.0034747,0.0028623,0.0033073,0.0036954,0.004017,0.0033597,0.0027561,0.0031492,0.0035202,0.0037899,0.0031833,0.0026803,0.0030899,0.0034964,0.0037545,0.0031341,0.0025977,0.0029933,0.0033929,0.0036227,0.0030741,0.0025802,0.002979,0.0033851,0.0035738,0.0030264,0.0025174,0.0029217,0.0033408,0.0035452,0.0030177,0.0025056,0.0029128,0.0033091,0.0035042,0.0029811,0.0024706,0.0029123,0.0032987,0.003502,0.0029584,0.0024657,0.0028991,0.0032457,0.0034736,0.0029291,0.002453,0.0028956,0.0032533,0.0034713,0.0028994,0.0024344,0.002855,0.0032249,0.0034592,0.0028886,0.002451,0.0028764,0.0032452,0.0034455,0.0028637,0.0024361,0.0028386,0.0032117,0.0034476,0.0028629,0.0024645,0.0028514,0.003254,0.0034149,0.0028425,0.0024404,0.0028376,0.0032636,0.0034195,0.0028499,0.0024399,0.0028329,0.0032718,0.003385,0.0028432,0.0024357,0.0028481,0.0032656,0.0033705,0.0028579,0.0024206,0.0028556,0.0032758,0.0033682,0.0028532,0.0024182,0.0028698,0.0032698,0.0033635,0.0028584,0.0024238,0.0028985,0.0032702,0.0033783,0.002857,0.0024221,0.0028926,0.0032595,0.0033932,0.0028401,0.0024268,0.0028921,0.0032722,0.0033984,0.0028329,0.0024399,0.0028899,0.0032737,0.0033969,0.0028232,0.002448,0.0029026,0.0032908,0.003412,0.0028182,0.0024548,0.0028911,0.0033011,0.0033896,0.002817,0.0024584,0.0029045,0.0033312,0.0033686,0.0028082,0.0024457,0.0028961,0.003356,0.0033575,0.0028336,0.0024604,0.0029115,0.0033484,0.003353,0.0028352,0.0024486,0.0029275,0.0033708,0.0033545,0.0028458,0.0024368,0.0029333,0.0033503,0.003351,0.0028392,0.0024424,0.0029613,0.0033447,0.0033542,0.002852,0.0024356,0.0029589,0.0:3
3.0133E-6,-1.6467E-6,5.06E-6,6.3333E-8,4.95E-6,2.5633E-6,-1.4367E-6,3.3733E-6,-4.3333E-7,3.0133E-6,1.4333E-6,-4.9333E-7,3.6867E-6,-2.79E-6,4.0133E-6,2.76E-6,-1.7533E-6,2.0467E-6,5.7333E-7,2.5133E-6,3.2333E-6,9.2667E-7,3.2467E-6,-1.8967E-6,2.83E-6,1.9267E-6,-2.6667E-8,3.31E-6,-1.92E-6,3.4867E-6,3.4167E-6,-1.24E-6,2.9633E-6,8.3333E-8,3.99E-6,2.0467E-6,8.7333E-7,4.9267E-6,2.4E-7,3.7E-6,3.48E-6,-1.2467E-6,9.6333E-7,4.3333E-8,3.46E-6,-1.85E-6,-1.2367E-6,3.66E-6,-1.0567E-6,5.5133E-6,2.4067E-6,-9.6667E-7,3.3467E-6,-2.7233E-6,2.3E-6,7.41E-6,-4.0233E-6,3.7533E-6,1.94E-6,7.9333E-7,3.0767E-6,-1.8367E-6,3.02E-6,-1.77E-6,3.3333E-6,7.2333E-7,-1.8767E-6,3.43E-6,-8.6333E-7,3.35E-6,3.0733E-6,-8.3333E-7,2.3033E-6,-2.1667E-7,3.9533E-6,1.3633E-6,-2.2E-7,2.7667E-6,2.8754E-4,0.0016746,0.0011131,8.5231E-4,5.3043E-4,6.4768E-4,6.6652E-4,7.2098E-4,6.7076E-4,5.1372E-4,5.7103E-4,6.596E-4,7.054E-4,6.5743E-4,5.1768E-4,5.6516E-4,6.645E-4,7.0729E-4,6.5776E-4,5.1883E-4,5.6433E-4,6.6451E-4,7.0703E-4,6.5665E-4,5.1889E-4,5.6467E-4,6.6445E-4,7.0651E-4,6.567E-4,5.1919E-4,5.6409E-4,6.6344E-4,7.0606E-4,6.5536E-4,5.1971E-4,5.6392E-4,6.6249E-4,7.065E-4,6.5399E-4,5.1913E-4,5.6437E-4,6.6302E-4,7.0849E-4,6.5337E-4,5.1802E-4,5.6427E-4,6.6418E-4,7.0652E-4,6.5261E-4,5.1843E-4,5.637E-4,6.6541E-4,7.0474E-4,6.534E-4,5.191E-4,5.6362E-4,6.6425E-4,7.08E-4,6.5117E-4,5.1912E-4,5.6581E-4,6.6515E-4,7.0773E-4,6.527E-4,5.2032E-4,5.6489E-4,6.6304E-4,7.0668E-4,6.5015E-4,5.1712E-4,5.6607E-4,6.6465E-4,7.0731E-4,6.5218E-4,5.1746E-4,5.645E-4,6.6417E-4,7.0792E-4,6.5083E-4,5.1783E-4,5.6462E-4,6.6487E-4,7.0874E-4,6.5095E-4,5.1769E-4,5.6568E-4,6.6705E-4,7.0802E-4,6.5161E-4,5.2074E-4,5.6806E-4,6.6992E-4,7.1248E-4,6.5026E-4,5.1966E-4,5.6679E-4,6.6839E-4,7.0947E-4,6.5051E-4,5.1934E-4,5.6763E-4,6.6714E-4,7.0679E-4,6.5057E-4,5.1974E-4,5.6801E-4,6.7035E-4,7.0985E-4,6.497E-4,5.2056E-4,5.6685E-4,6.699E-4,7.093E-4,6.4943E-4,5.1888E-4,5.6976E-4,6.6978E-4,7.1043E-4,6.4915E-4,5.2037E-4,5.7004E-4,6.7002E-4,7.1023E-4,6.4936E-4,5.1745E-4,5.6868E-4,6.7114E-4,7.1298E-4,6.4937E-4,5.2052E-4,5.6872E-4,6.7073E-4,7.1169E-4,6.4925E-4,5.1768E-4,5.695E-4,6.7243E-4,7.1251E-4,6.4796E-4,5.1875E-4,5.6934E-4,6.7073E-4,7.1082E-4,6.4796E-4,5.1895E-4,5.6899E-4,6.701E-4,7.1139E-4,6.4814E-4,5.1863E-4,5.6882E-4,6.7298E-4,7.1149E-4,6.48E-4,5.1777E-4,5.7133E-4,6.7505E-4,7.1164E-4,6.4527E-4,5.19E-4,5.7134E-4,6.7344E-4,7.0953E-4,6.447E-4,5.1878E-4,5.7184E-4,6.7377E-4,7.1034E-4,6.4693E-4,5.1934E-4,5.7235E-4,6.7301E-4,7.108E-4,6.4484E-4,5.1901E-4,5.725E-4,6.7366E-4,7.0806E-4,6.4545E-4,5.1795E-4,5.7375E-4,6.7512E-4,7.1239E-4,6.4361E-4,5.189E-4,5.712E-4,6.7621E-4,7.0962E-4,6.419E-4,5.1827E-4,5.7151E-4,6.7466E-4,7.1145E-4,6.4318E-4,5.1759E-4,5.7315E-4,6.7568E-4,7.0965E-4,6.4139E-4,5.1803E-4,5.7241E-4,6.7766E-4,7.1108E-4,6.4236E-4,5.1661E-4,5.7325E-4,6.7601E-4,7.089E-4,6.4199E-4,5.1653E-4,5.7492E-4,6.7597E-4,7.0968E-4,6.4002E-4,5.1707E-4,5.7442E-4,6.7838E-4,7.1121E-4,6.4125E-4,5.1733E-4,5.7682E-4,6.7786E-4,0.0:3
0.033751,-0.03074,0.013143,0.022175,-0.01875,0.032478,-0.016952,0.011128,0.011394,-0.026767,0.034622,-0.012226,-0.0010253,0.011268,-0.014777,0.037945,-0.019454,0.0071131,0.011171,-0.022872,0.024361,-0.02494,0.0071759,0.023152,-0.024449,0.032458,-0.013915,-0.0048538,0.0032797,-0.034726,0.034696,-0.020932,-0.0031908,0.015494,-0.026401,0.019143,-0.014734,0.010549,0.011527,-0.023595,0.063603,118.59,135.88,138.03,106.84,92.549,97.351,116.26,120.65,97.785,83.74,87.333,108.02,115.19,89.89,80.556,83.384,102.43,108.28,89.147,75.21,80.409,98.993,104.76,86.796,70.841,78.816,94.869,97.922,76.989,66.513,71.769,79.77,80.691,59.076,45.467,45.133,44.765,37.045,23.783,18.432,19.802,21.959,22.484,18.561,16.765,18.65,20.841,20.521,16.957,15.384,17.532,19.563,19.364,16.141,14.744,17.011,18.822,18.438,15.336,14.095,16.435,18.335,18.04,15.017,13.763,16.16,17.717,17.474,14.473,13.563,16.062,17.288,17.073,14.277,13.145,15.621,17.07,16.997,13.863,13.051,15.48,16.624,16.78,13.827,12.952,15.245,16.617,16.699,13.361,12.832,15.157,16.396,16.67,13.464,12.787,14.837,16.369,16.415,13.081,12.835,15.048,16.267,16.319,13.093,12.603,14.653,16.32,16.355,12.915,12.752,14.697,16.025,15.947,12.921,12.74,14.661,16.459,15.973,12.695,12.642,14.586,16.27,15.948,13.029,12.693,14.541,16.487,15.898,13.004,12.612,14.618,16.472,15.827,12.993,12.638,14.794,16.476,15.823,12.954,12.539,14.747,16.476,15.77,13.066,12.626,14.808,16.404,15.591,13.03,12.613,15.014,16.383,15.62,12.963,12.514,15.049,16.365,15.728,13.048,12.618,15.08,16.209,15.631,12.835,12.603,15.125,16.283,15.871,12.706,12.719,15.03,16.064,15.868,12.855,12.719,14.915,16.342,15.939,12.549,12.782,14.99,16.237,15.899,12.727,12.737,14.855,16.348,15.927,12.546,13.01,15.065,16.309,15.778,12.663,12.911,14.829,16.636,15.679,12.516,13.006,14.914,16.535,15.64,12.801,12.915,14.739,16.709,15.555,12.607,12.91,14.95,16.659,15.481,12.885,12.856,14.848,16.674,15.358,12.673,12.894,15.188,16.731,15.352,12.888,12.779,15.04,16.794,15.3,12.771,12.901,15.381,16.517,15.201,12.774,12.796,15.38,16.494,15.376,12.759,12.763,15.314,16.447,15.445,12.69,12.831,15.261,16.313,15.515,12.61,12.95,15.262,16.38,15.567,12.578,12.994,15.185,16.408,15.497,12.54,0.0:3
4.8556,5.6357,5.6855,4.7366,4.2937,4.859,5.639,5.6888,4.7261,4.2835,4.8615,5.64,5.6777,4.7265,4.2856,4.8669,5.6433,5.6843,4.7298,4.2867,4.8674,5.6459,5.6758,4.7261,4.2799,4.8721,5.6514,5.6726,4.7184,4.2785,4.8849,5.6536,5.6828,4.7218,4.2846,4.8773,5.6471,5.6623,4.7118,4.2776,4.8799,5.6458,5.6695,4.7102,4.284,4.8864,5.6494,5.6669,4.7,4.2859,4.8841,5.6562,5.6685,4.6991,4.2866,4.8962,5.6512,5.6608,4.6889,4.2802,4.8877,5.6486,5.6591,4.6841,4.2873,4.8968,5.6619,5.6576,4.6907,4.2892,4.9054,5.6649,5.6529,4.6964,4.2948,4.9043,5.6685,5.6604,4.6854,4.2885,4.9039,5.6665,5.6482,4.6812,4.2919,4.9091,5.6628,5.6449,4.6755,4.2839,4.9185,5.6607,5.645,4.676,4.287,4.9211,5.673,5.6478,4.6727,4.2909,4.9206,5.6711,5.6475,4.6736,4.2921,4.926,5.6738,5.6497,4.663,4.2896,4.9332,5.675,5.6386,4.6591,4.2956,4.9426,5.6739,5.6377,4.6645,4.3009,4.9467,3.9133,1.174,1.1419,0.73754,0.90099,1.0562,1.2101,1.0264,0.83652,0.8748,1.068,1.2179,1.0228,0.84694,0.86717,1.0753,1.2143,1.0212,0.85281,0.86671,1.0663,1.2115,1.0224,0.85707,0.87428,1.0696,1.2194,1.0113,0.85274,0.8775,1.0795,1.2131,1.0109,0.85836,0.88938,1.0735,1.2122,1.0193,0.85291,0.89568,1.0802,1.2176,1.0134,0.85407,0.88406,1.0758,1.2166,1.0093,0.84902,0.88368,1.0748,1.2128,1.009,0.85249,0.88164,1.0665,1.2169,1.0102,0.85092,0.88912,1.0867,1.215,1.0184,0.85879,0.88913,1.0825,1.2098,1.0023,0.85896,0.88544,1.0855,1.2106,1.003,0.85052,0.88863,1.0742,1.2064,0.99718,0.85238,0.89407,1.0683,1.2067,1.0027,0.84721,0.88828,1.0767,1.2122,1.0026,0.84546,0.89171,1.0784,1.2103,1.0074,0.85312,0.88923,1.0814,1.2076,0.99582,0.85787,0.89903,1.081,1.2081,1.0029,0.84609,0.89685,1.0818,1.2148,1.001,0.85051,0.90274,1.0835,1.2129,0.99753,0.8509,0.90135,1.0799,1.2086,0.98998,0.84673,0.89366,1.0725,1.2038,0.98621,0.85124,0.8908,1.0794,1.2047,0.98932,0.84369,0.8926,1.0776,1.2051,0.99601,0.85454,0.89669,1.0792,1.2043,0.99384,0.85181,0.89468,1.0869,1.2057,0.99101,0.84979,0.90553,1.0815,1.2065,0.99102,0.84783,0.9108,1.0823,1.2007,0.99779,0.85285,0.90751,1.0859,1.2064,0.98608,0.84784,0.90243,1.0718,1.2017,0.98654,0.8479,0.89606,1.0772,1.1992,0.98555,0.84155,0.90184,1.083,1.1995,0.98038,0.84325,0.90434,1.0783,1.2064,0.98599,0.84447,0.0:3
2.9235,2.2891,2.0834,2.2408,2.8665,2.915,2.3033,2.0799,2.2367,2.8738,2.902,2.3179,2.0737,2.238,2.8775,2.8897,2.3293,2.0617,2.2405,2.8817,2.8796,2.3422,2.049,2.2483,2.8743,2.8728,2.3606,2.0439,2.2618,2.8589,2.8775,2.368,2.0389,2.2706,2.8366,2.889,2.3635,2.0389,2.2706,2.8165,2.9046,2.3601,2.0437,2.2696,2.8063,2.9215,2.3561,2.051,2.261,2.796,2.9324,2.3495,2.0623,2.2487,2.7908,2.9448,2.3376,2.0736,2.2293,2.7989,2.9516,2.3286,2.0796,2.212,2.815,2.9477,2.3292,2.0845,2.2015,2.8323,2.9422,2.3452,2.0873,2.1954,2.8376,2.9245,2.3573,2.0813,2.2014,2.8444,2.9109,2.3683,2.0686,2.2022,2.849,2.9064,2.3911,2.0626,2.2085,2.8456,2.8918,2.4015,2.0501,2.2216,2.8339,2.8909,2.4169,2.0425,2.2349,2.812,0.0:3
2.12E-6,-1.0533E-6,1.4333E-6,3.6667E-7,-2.2533E-6,2.15E-6,-4.1E-7,1.0633E-6,8.8333E-7,-1.4367E-6,1.84E-6,-2.2133E-6,1.1067E-6,-2.3334E-8,-1.3133E-6,1.8533E-6,-1.7267E-6,1.6867E-6,1.0467E-6,-1.45E-6,2.29E-6,-2.2367E-6,2.04E-6,3.1E-7,-6.9E-7,1.87E-6,-2.1E-6,1.8433E-6,1.1267E-6,-5.2667E-7,1.9467E-6,-1.1667E-6,1.37E-6,6.8667E-7,-1.9733E-6,1.9567E-6,-9.4E-7,1.6433E-6,1.1133E-6,-1.5167E-6,1.76E-6,-1.4033E-6,2.0533E-6,5.8667E-7,-2.3333E-6,1.9E-6,-1.2133E-6,1.3433E-6,7.7333E-7,-6.3E-7,1.8533E-6,-1.2E-6,1.4967E-6,1.2933E-6,-2.0167E-6,1.5367E-6,-9.8667E-7,1.2633E-6,8.6667E-7,-9.9667E-7,1.9833E-6,-1.31E-6,1.8133E-6,8.3667E-7,-9.1667E-7,2.1E-6,-1.7667E-6,1.8133E-6,8.5667E-7,-2.4667E-7,2.01E-6,-1.9133E-6,1.1567E-6,9.4667E-7,-1.3567E-6,1.7367E-6,-1.49E-6,2.0433E-6,9.4E-7,-2.57E-6,1.7133E-6,-1.02E-6,1.4233E-6,8.0E-7,-1.1233E-6,1.9233E-6,-1.02E-6,1.0267E-6,9.3E-7,-1.3533E-6,1.6633E-6,-1.8433E-6,1.7867E-6,4.1333E-7,-1.3267E-6,2.2767E-6,-2.0E-6,1.73E-6,1.0667E-6,-1.7167E-6,1.41E-6,-1.0733E-6,1.3533E-6,1.0867E-6,-1.1833E-6,1.87E-6,-2.3267E-6,1.3267E-6,3.5333E-7,-1.37E-6,2.1267E-6,-1.48E-6,9.4333E-7,1.7E-7,-5.5E-7,1.9502E-4,8.7533E-6,2.1802E-4,1.8202E-4,2.1156E-4,1.074E-4,1.431E-4,1.2403E-4,1.7314E-4,1.7732E-4,1.2256E-4,1.2587E-4,1.3009E-4,1.7216E-4,1.7158E-4,1.2913E-4,1.2087E-4,1.3345E-4,1.7315E-4,1.6964E-4,1.3223E-4,1.1963E-4,1.3603E-4,1.7395E-4,1.6909E-4,1.3239E-4,1.2E-4,1.3602E-4,1.7369E-4,1.6884E-4,1.3214E-4,1.1938E-4,1.3679E-4,1.7371E-4,1.6799E-4,1.3277E-4,1.1913E-4,1.369E-4,1.7399E-4,1.6721E-4,1.3218E-4,1.1906E-4,1.3745E-4,1.7314E-4,1.6736E-4,1.3225E-4,1.2005E-4,1.3818E-4,1.7336E-4,1.6713E-4,1.3193E-4,1.1964E-4,1.376E-4,1.7239E-4,1.6725E-4,1.3084E-4,1.2068E-4,1.3745E-4,1.7145E-4,1.652E-4,1.3058E-4,1.1804E-4,1.365E-4,1.6985E-4,1.6496E-4,1.2894E-4,1.1742E-4,1.3671E-4,1.6948E-4,1.627E-4,1.2865E-4,1.1832E-4,1.3646E-4,1.6677E-4,1.6083E-4,1.2658E-4,1.1568E-4,1.3426E-4,1.6634E-4,1.6021E-4,1.2673E-4,1.1492E-4,1.3289E-4,1.6406E-4,1.5815E-4,0.0:3
5.7712E-4,5.7205E-4,4.938E-4,4.1615E-4,5.0685E-4,5.7541E-4,5.7267E-4,4.9332E-4,4.1854E-4,5.075E-4,5.815E-4,5.7287E-4,4.9358E-4,4.166E-4,5.0566E-4,5.7883E-4,5.7018E-4,4.945E-4,4.1908E-4,5.0739E-4,5.7745E-4,5.7205E-4,4.941E-4,4.1766E-4,5.0683E-4,5.7991E-4,5.7118E-4,4.9427E-4,4.1601E-4,5.0789E-4,5.806E-4,5.7011E-4,4.9195E-4,4.1857E-4,5.0795E-4,5.7734E-4,5.6969E-4,4.9287E-4,4.186E-4,5.0863E-4,5.7761E-4,5.7241E-4,4.9293E-4,4.1966E-4,5.0793E-4,5.7772E-4,5.7224E-4,4.9195E-4,4.1809E-4,5.0916E-4,5.8006E-4,5.7045E-4,4.9139E-4,4.1812E-4,5.0876E-4,5.7767E-4,5.6929E-4,4.9301E-4,4.1947E-4,5.1398E-4,5.7897E-4,5.6789E-4,4.915E-4,4.1775E-4,5.1054E-4,5.7933E-4,5.6984E-4,4.91E-4,4.1799E-4,5.1159E-4,5.8001E-4,5.7049E-4,4.913E-4,4.2029E-4,5.1088E-4,5.7918E-4,5.7062E-4,4.9178E-4,4.1788E-4,5.1181E-4,5.8197E-4,5.6771E-4,4.9046E-4,4.2051E-4,5.1249E-4,5.7987E-4,5.691E-4,4.8959E-4,4.1958E-4,5.0943E-4,5.795E-4,5.6672E-4,4.9082E-4,4.1744E-4,5.1264E-4,5.7897E-4,5.6611E-4,4.9129E-4,4.1977E-4,5.122E-4,5.8119E-4,5.6776E-4,4.8775E-4,4.2019E-4,5.1333E-4,5.8034E-4,5.6739E-4,4.8864E-4,4.2007E-4,5.1181E-4,5.818E-4,5.6873E-4,4.8986E-4,4.2054E-4,5.1306E-4,5.8082E-4,5.6627E-4,4.8758E-4,4.1968E-4,5.1519E-4,5.8051E-4,5.6725E-4,4.8939E-4,4.1865E-4,5.1301E-4,5.8105E-4,5.6734E-4,4.8815E-4,4.1948E-4,5.1548E-4,5.8286E-4,5.6595E-4,4.8792E-4,4.1708E-4,5.1358E-4,5.8093E-4,5.6838E-4,4.8768E-4,4.1966E-4,5.1392E-4,5.813E-4,5.6709E-4,4.8778E-4,4.195E-4,5.1492E-4,5.8084E-4,5.6474E-4,4.8788E-4,4.1992E-4,5.1631E-4,5.8144E-4,5.6603E-4,4.8555E-4,4.1918E-4,5.1699E-4,5.8174E-4,5.6447E-4,4.8419E-4,4.1959E-4,5.1319E-4,5.8143E-4,5.6594E-4,4.8514E-4,4.2102E-4,5.1717E-4,5.8124E-4,5.6675E-4,4.8565E-4,4.1904E-4,5.1576E-4,5.8115E-4,5.6559E-4,4.8503E-4,4.1943E-4,5.1718E-4,5.8431E-4,5.6542E-4,4.8613E-4,4.2155E-4,5.174E-4,5.8297E-4,5.6207E-4,4.8349E-4,4.2004E-4,5.1795E-4,5.814E-4,5.6366E-4,4.8227E-4,4.2029E-4,5.1942E-4,5.8267E-4,0.0079762,0.012201,0.015202,0.020286,0.022575,0.017898,0.019048,0.018211,0.019173,0.023246,0.024356,0.021274,0.016508,0.020048,0.022365,0.024238,0.020697,0.017289,0.018795,0.022689,0.023782,0.020814,0.016546,0.018822,0.021966,0.022803,0.019285,0.015493,0.017536,0.019832,0.019994,0.016653,0.012525,0.0068509,0.0045301,0.0029503,0.0018503,9.3562E-4,0.0013647,0.0017968,0.0022793,0.0021013,0.0015159,0.0017263,0.0019778,0.0023064,0.0020421,0.0014932,0.0016537,0.0018591,0.0022015,0.0019977,0.0015249,0.0017609,0.0020526,0.0023453,0.0020315,0.001499,0.0016639,0.0019333,0.0022961,0.0020673,0.0015871,0.0017959,0.0020499,0.0023378,0.0020189,0.0015068,0.0017101,0.0020194,0.0023892,0.0020957,0.0016035,0.001777,0.0020379,0.0023341,0.0020306,0.0015647,0.0017722,0.0020907,0.0024325,0.0021039,0.0015994,0.0017558,0.0020475,0.0023892,0.0020801,0.0016149,0.0018015,0.0021128,0.0024254,0.0020899,0.0016062,0.0017777,0.002111,0.0024228,0.0021195,0.0016266,0.0018105,0.0021328,0.0024066,0.002114,0.001625,0.0018194,0.0021572,0.0024369,0.002138,0.0016357,0.0018272,0.0021555,0.0024403,0.002135,0.0016335,0.0018429,0.0021698,0.0024427,0.0021482,0.0016375,0.0018497,0.0021684,0.0024528,0.0021591,0.0016408,0.0018738,0.0021829,0.0024563,0.0021631,0.0016346,0.0018708,0.0021916,0.002471,0.002184,0.0016477,0.0018939,0.0021959,0.0024901,0.002183,0.001657,0.0019086,0.0022107,0.0025129,0.0021945,0.0016644,0.0019135,0.0022138,0.0025052,0.0021899,0.0016748,0.0019306,0.0022231,0.0025329,0.0021854,0.0016756,0.0019227,0.0022374,0.002553,0.0022006,0.0016876,0.0019261,0.0022227,0.0025464,0.0021818,0.001699,0.0019318,0.0022511,0.0025628,0.0021889,0.0017004,0.0019379,0.0022622,0.0025673,0.0021966,0.0017174,0.0019414,0.0022876,0.0025616,0.0022047,0.0017225,0.0019452,0.0023138,0.0025719,0.0022166,0.0017294,0.0019496,0.0023066,0.0025665,0.0022237,0.0017258,0.0019734,0.0023185,0.0025702,0.0022263,0.0017326,0.001972,0.0023405,0.0025701,0.0022304,0.0017212,0.0019837,0.0023338,0.0025705,0.0022397,0.0017288,0.0019966,0.0023438,0.0025696,0.0022485,0.0017286,0.0020247,0.0023399,0.0025986,0.0022522,0.0017331,0.0020259,0.00234,0.0026085,0.0022425,0.0017379,0.0020194,0.0023376,0.0026226,0.0022515,0.0017417,0.0020348,0.0023571,0.0026303,0.002242,0.0017646,0.0020329,0.0023532,0.0026448,0.0022577,0.0017551,0.0020316,0.0023631,0.0026464,0.0022479,0.001761,0.0020349,0.0023819,0.0026489,0.002238,0.0017735,0.002027,0.002386,0.0026499,0.0022551,0.0017852,0.0020412,0.0024159,0.002654,0.0022616,0.00179,0.002046,0.002412,0.002654,0.002275,0.0017874,0.0020575,0.0024312,0.0026445,0.0022795,0.0017888,0.0020594,0.0024355,0.0026499,0.0022842,0.0017825,0.0020706,0.0024471,0.0026571,0.002306,0.0017822,0.0020825,0.0024486,0.0026606,0.002299,0.0017876,0.0021003,0.0024542,0.0026735,0.002308,0.0017877,0.0021155,0.0024528,0.0026912,0.0023085,0.0017926,0.0021135,0.0024481,0.0026872,0.0023084,0.0017972,0.0021196,0.0024511,0.0026988,0.0022971,0.0017989,0.0021114,0.0024545,0.0027073,0.0022973,0.0018109,0.0021264,0.0024523,0.0027187,0.002292,0.0018261,0.0021166,0.0024652,0.0027242,0.0022881,0.0018245,0.0021116,0.0024712,0.0027257,0.0023033,0.0018361,0.0021175,0.0024972,0.0027213,0.0023057,0.0018368,0.0021234,0.0025161,0.0027186,0.0023005,0.0018453,0.0021395,0.0025228,0.0027203,0.0023272,0.0018488,0.0021525,0.0025337,0.0027185,0.0023249,0.0018271,0.0021345,0.0025444,0.0027049,0.0023294,0.0018278,0.0021674,0.0025449,0.0027253,0.0023455,0.0018432,0.0021761,0.002543,0.002739,0.0023535,0.0018339,0.0021911,0.0025247,0.002721,0.0023342,0.0018356,0.002191,0.0025214,0.0027398,0.0023206,0.0018272,0.0021838,0.0025077,0.0027246,0.0023094,0.0018298,0.0021804,0.0025105,0.0027388,0.0022988,0.0018442,0.0021722,0.0025088,0.0027588,0.0023046,0.0018392,0.0021583,0.0025206,0.0027555,0.0022887,0.0018509,0.0021587,0.002547,0.0027573,0.0023058,0.0018654,0.0021672,0.0025626,0.0027546,0.0023205,0.0018571,0.0021737,0.0025687,0.0027485,0.002326,0.0018621,0.0021943,0.0025902,0.0027383,0.0023211,0.001859,0.0021922,0.0025789,0.0027357,0.0023359,0.0018564,0.0022104,0.0025849,0.0027378,0.0023242,0.0018471,0.0022211,0.0025832,0.0027427,0.0023514,0.0018523,0.0022196,0.0025799,0.0027477,0.0023584,0.0018576,0.0022427,0.0025793,0.0027713,0.0023537,0.0018594,0.0022573,0.0025805,0.0027906,0.0023386,0.0018707,0.0022395,0.0025694,0.002781,0.0023368,0.0018871,0.0022382,0.0025736,0.0027878,0.0023331,0.0018931,0.002241,0.0025939,0.0028029,0.0023262,0.0018965,0.0022307,0.0026222,0.0027995,0.0023349,0.0019057,0.0022323,0.0026428,0.0027894,0.0023349,0.0019008,0.002227,0.0026368,0.0027878,0.0023482,0.0018965,0.0022499,0.0026523,0.0027826,0.0023611,0.0019001,0.0022507,0.0026529,0.0027926,0.0023603,0.0018827,0.0022717,0.0026729,0.0027948,0.0023825,0.0018954,0.0022715,0.00266,0.0027874,0.0023779,0.0018948,0.0022977,0.0026465,0.0028055,0.0023797,0.0019004,0.0022958,0.0026429,0.0028199,0.0023783,0.0018905,0.0022889,0.0026192,0.002823,0.0023533,0.0019011,0.0022941,0.0026193,0.002828,0.0023443,0.0019059,0.0022862,0.0026481,0.002847,0.0023423,0.0019187,0.0022808,0.0026463,0.0028319,0.0023416,0.0019281,0.0022819,0.0026633,0.0028273,0.0023539,0.0019334,0.0022835,0.002677,0.0028077,0.002351,0.0019185,0.0022797,0.0026812,0.0028056,0.0023513,0.0019166,0.002277,0.0026881,0.0028068,0.0023637,0.0019129,0.002275,0.002683,0.0027852,0.0023633,0.0019082,0.0022976,0.0026825,0.0027897,0.0023738,0.0019053,0.0023189,0.0026698,0.0028026,0.0023768,0.0019008,0.0023204,0.0026726,0.002805,0.0023641,0.0019029,0.002317,0.0026619,0.0028112,0.0023644,0.0019105,0.0023308,0.0026603,0.0028312,0.0023652,0.0019054,0.0023113,0.0026632,0.0028348,0.0023602,0.0019328,0.0023164,0.0026617,0.0028558,0.0023419,0.0019363,0.002308,0.0026936,0.0028538,0.0023466,0.001939,0.0022997,0.0027022,0.0028478,0.0023528,0.0019437,0.0023073,0.0027004,0.0028102,0.0023387,0.001929,0.0023013,0.0027162,0.0028021,0.0023485,0.0019221,0.0023041,0.0027146,0.0027957,0.0023616,0.0019234,0.0023121,0.0027122,0.0027947,0.0023623,0.0019124,0.0023262,0.0027096,0.002802,0.002367,0.0019202,0.0023458,0.0027041,0.0028117,0.0023695,0.001918,0.0023334,0.0026873,0.002815,0.0023627,0.0019213,0.0023571,0.0026897,0.0028354,0.0023398,0.0019174,0.0023291,0.0026607,0.0028112,0.0023329,0.0019183,0.0023211,0.0026718,0.0028224,0.002326,0.0019231,0.0023197,0.0026734,0.0028428,0.0023227,0.0019296,0.0023202,0.002698,0.0028295,0.0023239,0.001935,0.0023249,0.0027217,0.0028082,0.0023198,0.0019293,0.0021919,0.0022341,0.0023501,0.001933,0.0015649,0.0018483,0.0022149,0.0023474,0.0019377,0.0015427,0.0018519,0.002228,0.0023288,0.0019474,0.0015391,0.0018662,0.0022293,0.0023375,0.0018064,0.0015205,0.0019123,0.0022236,0.0023083,0.0019272,0.0015027,0.0018682,0.0021698,0.0023238,0.0019277,0.0015231,0.0018712,0.0022194,0.0023732,0.0019511,0.0015266,0.0018803,0.0021771,0.0023458,0.0019249,0.001534,0.0018841,0.0021713,0.0023487,0.001912,0.0015495,0.0018595,0.0021741,0.0023592,0.0019136,0.0015593,0.0018692,0.0021947,0.0023748,0.0019119,0.0015602,0.0018654,0.0022161,0.0023577,0.0019222,0.0015657,0.0018679,0.0022243,0.0023555,0.0019254,0.0015576,0.001881,0.0022317,0.0023323,0.0019175,0.0015582,0.0018683,0.0022289,0.0023318,0.0019276,0.0015384,0.0018631,0.0022301,0.0023303,0.0019217,0.0015378,0.0018794,0.0022258,0.0022992,0.0019348,0.0015346,0.0019002,0.0022223,0.002332,0.0019345,0.0015252,0.0019052,0.0022074,0.0023408,0.0019373,0.0015471,0.0019105,0.0021966,0.0023396,0.0019275,0.001544,0.0019121,0.0022079,0.0023505,0.0019164,0.0015529,0.0018897,0.0022018,0.002366,0.0019204,0.0015654,0.0018934,0.0022006,0.0023636,0.0018952,0.0015575,0.0018797,0.0022271,0.0023689,0.0018998,0.0015682,0.0018716,0.0022279,0.0023498,0.0018989,0.0015717,0.0018824,0.0022431,0.0023355,0.0019065,0.0015544,0.0018861,0.0022654,0.0023317,0.0019082,0.001547,0.001874,0.0022443,0.0023193,0.0019259,0.0015514,0.0019016,0.0022589,0.002317,0.0019186,0.0015307,0.0019085,0.0022358,0.0023174,0.0019233,0.001527,0.0019038,0.0022127,0.0023215,0.0019168,0.0015399,0.0019142,0.0022108,0.0023309,0.0019183,0.0015341,0.0019234,0.0:3
0.0015898,0.0019449,0.0023132,0.002327,0.0019062,0.0015773,0.00194,0.002309,0.0023185,0.0019201,0.0015725,0.0019528,0.002302,0.0023112,0.0019165,0.0015628,0.0019759,0.0022838,0.0023257,0.0019151,0.0015624,0.0019677,0.0022675,0.0023304,0.001905,0.0015615,0.0019634,0.0022817,0.0023437,0.0019081,0.0015757,0.0019719,0.0022715,0.0023464,0.0018905,0.0015769,0.0019569,0.0022586,0.0023553,0.0019022,0.0015909,0.0019543,0.0022665,0.002358,0.0018825,0.0015982,0.0019446,0.0022773,0.0023526,0.0018793,0.0015929,0.001938,0.0022955,0.0023484,0.0018846,0.0015934,0.0019452,0.0022973,0.002329,0.001897,0.0015824,0.0019377,0.0023069,0.0023236,0.0018896,0.0015631,0.0019388,0.0023059,0.0023183,0.0019029,0.0015711,0.0019465,0.0023058,0.0023101,0.0019075,0.0015638,0.0019655,0.0023063,0.0023212,0.0019258,0.0015702,0.001976,0.0022807,0.0023234,0.0019188,0.0015686,0.0019784,0.0022819,0.0023294,0.0018998,0.0015733,0.0019815,0.0022634,0.002347,0.0018959,0.0015742,0.0019538,0.0022613,0.002348,0.0018909,0.0015744,0.0019632,0.0022626,0.002355,0.0018828,0.001595,0.0019514,0.0022749,0.0023557,0.0018763,0.0015914,0.0019419,0.0022963,0.002345,0.0018767,0.0015953,0.0019296,0.0022919,0.0023236,0.0018833,0.0015852,0.0019462,0.002307,0.0023341,0.0018971,0.0015799,0.0019386,0.0023113,0.0023174,0.0019,0.0015703,0.0019474,0.0023118,0.0022972,0.0018936,0.0015588,0.0019596,0.0023025,0.00231,0.0019107,0.0015579,0.0019709,0.0022906,0.0023236,0.0019066,0.0015627,0.0019767,0.0022827,0.0023262,0.0018985,0.0015616,0.0019756,0.0022759,0.0023342,0.0018943,0.0015698,0.0019775,0.0022608,0.0023451,0.0018888,0.001584,0.0019752,0.0022616,0.0023513,0.0018685,0.0015821,0.0019589,0.0022698,0.0023572,0.0018738,0.0015887,0.0019331,0.0022724,0.0023521,0.0018777,0.0015924,0.0019395,0.0022893,0.0023284,0.0018775,0.001589,0.0019373,0.0023112,0.0023269,0.0018869,0.0015769,0.0019402,0.0023,0.0023174,0.001898,0.0015875,0.0019514,0.0023075,0.0022989,0.0019043,0.0015606,0.0019516,0.002314,0.0023046,0.0019099,0.0015617,0.0019665,0.0022919,0.0023088,0.0019046,0.0015629,0.0019794,0.0022889,0.002309,0.0018883,0.0015624,0.001977,0.0022753,0.0023168,0.0019016,0.0015637,0.0019692,0.0022667,0.0023291,0.001886,0.0015753,0.0019759,0.0022687,0.0023345,0.0018807,0.0015773,0.0019638,0.0022689,0.0023571,0.0018808,0.0015828,0.001952,0.0022728,0.0023398,0.0018681,0.0015899,0.0019405,0.0022942,0.0023349,0.0018713,0.0015855,0.0019395,0.0023077,0.0023353,0.0018877,0.0015762,0.0019309,0.0023045,0.0023136,0.0018864,0.0015787,0.0019511,0.0023166,0.0022941,0.001884,0.001561,0.0019525,0.0023225,0.0023118,0.0019081,0.0015667,0.0019659,0.0023067,0.0023098,0.0019051,0.0015653,0.0019719,0.0022791,0.0023082,0.0018985,0.0015443,0.0019685,0.0022695,0.0023245,0.0018928,0.0015637,0.0019735,0.0022595,0.0023315,0.0018952,0.0015603,0.0019646,0.0022568,0.0023276,0.0018716,0.0015674,0.0019568,0.0022649,0.0023474,0.0018786,0.0015762,0.0019587,0.0022684,0.00234,0.0018632,0.0015878,0.001946,0.0022801,0.0023449,0.0018641,0.0015859,0.0019379,0.0022929,0.0023325,0.0018756,0.00158,0.0019415,0.002293,0.0023191,0.0018724,0.0015735,0.0019423,0.0023105,0.00231,0.0018833,0.0015632,0.0019362,0.002304,0.0023059,0.0018998,0.0015638,0.0019622,0.0023014,0.002296,0.0019046,0.0015604,0.0019693,0.0023033,0.0022979,0.0019016,0.0015515,0.0019733,0.0022814,0.002316,0.0019042,0.001569,0.0019844,0.0022657,0.0023236,0.0018832,0.001569,0.0019784,0.0022752,0.0023307,0.0018881,0.0015682,0.001976,0.0022615,0.0023347,0.0018716,0.0015756,0.0019644,0.002258,0.0023409,0.0018699,0.0015822,0.0017503:3
5.649E-4,5.7599E-4,5.0242E-4,4.1516E-4,4.9034E-4,5.6542E-4,5.7663E-4,5.026E-4,4.153E-4,4.9233E-4,5.6748E-4,5.7468E-4,5.0267E-4,4.1526E-4,4.8996E-4,5.6439E-4,5.7347E-4,5.0128E-4,4.1338E-4,4.8895E-4,5.6431E-4,5.7171E-4,5.0377E-4,4.1498E-4,4.9022E-4,5.6298E-4,5.7408E-4,5.0208E-4,4.1585E-4,4.9016E-4,5.6411E-4,5.7467E-4,5.0162E-4,4.1511E-4,4.9225E-4,5.6468E-4,5.7514E-4,5.0168E-4,4.1719E-4,4.8993E-4,5.6431E-4,5.7229E-4,5.0215E-4,4.1759E-4,4.8999E-4,5.6508E-4,5.7592E-4,5.0202E-4,4.1596E-4,4.9185E-4,5.6718E-4,5.7412E-4,5.0197E-4,4.1565E-4,4.9065E-4,5.6578E-4,5.7305E-4,5.0094E-4,4.139E-4,4.9061E-4,5.6625E-4,5.7588E-4,5.0239E-4,4.1558E-4,4.9181E-4,5.6669E-4,5.7358E-4,5.0108E-4,4.1551E-4,7.7961E-4,0.011523,0.017137,0.022519,0.016791,0.019002,0.021411,0.024237,0.022274,0.01703,0.018737,0.021523,0.024272,0.022112,0.017105,0.018679,0.021543,0.024229,0.021957,0.017122,0.018702,0.02151,0.02425,0.022042,0.017132,0.018583,0.02148,0.024232,0.021964,0.017091,0.01866,0.021491,0.024272,0.021997,0.017134,0.018666,0.02143,0.024236,0.021982,0.017094,0.018599,0.0215,0.024171,0.021936,0.017082,0.018585,0.02146,0.024202,0.021947,0.017073,0.018567,0.021509,0.024197,0.021846,0.017054,0.018636,0.021433,0.024195,0.021853,0.017056,0.018613,0.021445,0.024102,0.021866,0.017016,0.018603,0.021425,0.024052,0.02191,0.017047,0.018558,0.021465,0.024139,0.021812,0.017097,0.018581,0.021433,0.024142,0.0218,0.017037,0.018555,0.021508,0.024039,0.02173,0.016991,0.0185,0.021449,0.024075,0.021764,0.016978,0.018563,0.021373,0.024046,0.021706,0.017045,0.018479,0.021458,0.023963,0.021724,0.016938,0.018511,0.021385,0.024076,0.021721,0.016981,0.018484,0.021461,0.023941,0.021672,0.016896,0.018513,0.021527,0.024064,0.021614,0.016954,0.018554,0.021378,0.023971,0.021541,0.016863,0.018535,0.021446,0.02406,0.021621,0.01692,0.018494,0.021371,0.023916,0.021657,0.016907,0.018459,0.021407,0.023992,0.021509,0.016919,0.018494,0.021326,0.023901,0.021595,0.016903,0.01848,0.021404,0.023907,0.021598,0.016847,0.018502,0.021399,0.023925,0.02147,0.016819,0.018455,0.021304,0.023846,0.021524,0.016805,0.018481,0.021309,0.023859,0.021475,0.016766,0.018459,0.02137,0.02383,0.021466,0.016796,0.0184,0.02133,0.023805,0.021514,0.016819,0.018477,0.021335,0.023813,0.021473,0.016768,0.018416,0.02129,0.023887,0.021409,0.01681,0.018427,0.021367,0.023768,0.02136,0.016747,0.018389,0.021278,0.023818,0.021397,0.016739,0.018323,0.021335,0.023773,0.021343,0.016708,0.01838,0.02127,0.023684,0.021297,0.016669,0.01843,0.02126,0.023764,0.021267,0.016723,0.018445,0.021242,0.023731,0.021268,0.016628,0.018357,0.021287,0.02368,0.021257,0.016633,0.018423,0.021299,0.023708,0.021288,0.016718,0.018332,0.021296,0.023696,0.021183,0.016705,0.01834,0.021325,0.023658,0.021215,0.01662,0.018357,0.0:3
-1.5638E-4,1.4743E-4,-7.8837E-5,1.527E-4,3.958E-5,-7.4383E-5,2.2839E-4,-3.874E-5,8.75E-5,9.3303E-5,-1.1449E-4,1.698E-4,-1.183E-4,9.986E-5,1.3334E-4,-1.0729E-4,2.4012E-4,-1.8114E-4,9.316E-5,7.648E-5,-2.4182E-4,2.7041E-4,-1.088E-4,1.3314E-4,1.8739E-4,-1.4978E-4,2.7705E-4,-1.485E-4,1.0426E-4,-6.9423E-5,-8.949E-5,2.9639E-4,-1.6007E-4,1.0142E-4,-4.8313E-5,-1.7136E-4,1.7191E-4,-1.0501E-4,5.218E-5,4.5943E-5,-2.0679E-4,2.0852E-4,-3.043E-5,-1.1867E-5,5.019E-5,-1.5303E-4,2.953E-4,-1.6319E-4,6.4053E-5,1.0567E-4,-1.2658E-4,2.4848E-4,-1.8103E-4,1.1327E-4,1.3393E-5,-2.1553E-4,3.2164E-4,-1.1466E-4,8.127E-5,1.153E-4,-5.679E-5,2.1186E-4,4.2777E-5,1.6385E-4,1.8132E-4,-2.0048E-4,3.0465E-4,-1.0641E-4,1.7226E-4,-9.3967E-6,-1.2032E-4,2.2363E-4,-7.0877E-5,1.6233E-4,6.1087E-5,-1.7328E-4,2.2691E-4,-2.0959E-4,1.0641E-4,5.206E-5,0.14455,0.11615,0.074276,0.084507,0.073532,0.058177,0.050909,0.056847,0.066128,0.064717,0.056148,0.047542,0.056048,0.065067,0.064392,0.056088,0.047394,0.056009,0.065094,0.064533,0.056167,0.047237,0.056028,0.064943,0.06454,0.056402,0.04732,0.055978,0.064834,0.064474,0.056311,0.047269,0.055891,0.064734,0.064754,0.05642,0.047388,0.055767,0.064905,0.064747,0.056428,0.047301,0.055878,0.064705,0.064885,0.056622,0.047473,0.055724,0.06461,0.06489,0.056556,0.04741,0.055681,0.064888,0.065196,0.056732,0.047432,0.055561,0.064833,0.065153,0.056787,0.047475,0.055647,0.064502,0.064976,0.056748,0.047365,0.055569,0.064668,0.06518,0.056878,0.047537,0.055469,0.064551,0.065159,0.056971,0.047563,0.055608,0.064306,0.065393,0.056907,0.047441,0.055425,0.064448,0.065187,0.057084,0.047458,0.055306,0.064535,0.065207,0.057138,0.047681,0.055277,0.064462,0.065436,0.057162,0.047468,0.055187,0.06439,0.06535,0.057323,0.047611,0.055333,0.064401,0.065382,0.057434,0.047665,0.055178,0.064347,0.065584,0.057506,0.047589,0.055331,0.064374,0.065607,0.057438,0.047636,0.054956,0.064225,0.065831,0.057634,0.047626,0.05512,0.064301,0.06564,0.057684,0.047677,0.054974,0.064131,0.065859,0.057702,0.047662,0.054994,0.06418,0.065811,0.057788,0.047617,0.054871,0.064047,0.065967,0.057721,0.047812,0.054825,0.064098,0.065701,0.057976,0.047659,0.054877,0.064079,0.065813,0.058023,0.04766,0.05476,0.063836,0.065796,0.058004,0.047637,0.05486,0.063825,0.065887,0.058161,0.047733,0.054626,0.063807,0.065915,0.058101,0.047842,0.054575,0.063744,0.065934,0.058255,0.047683,0.054629,0.063524,0.065962,0.058272,0.047858,0.054583,0.063444,0.065964,0.058342,0.047712,0.054483,0.063546,0.066206,0.058447,0.047763,0.054578,0.063568,0.066354,0.058461,0.04776,0.054466,0.063309,0.066286,0.058576,0.047912,0.054323,0.063397,0.066247,0.058583,0.047795,0.054229,0.063355,0.066349,0.058815,0.04794,0.05428,0.063268,0.066249,0.058783,0.047946,0.05421,0.063191,0.066411,0.058752,0.047914,0.054198,0.063097,0.066365,0.0:3
0.41117,0.52352,0.58825,0.57062,0.45632,0.40527,0.52839,0.592,0.56409,0.45666,0.40747,0.52926,0.59046,0.57004,0.46003,0.41264,0.52661,0.59062,0.564,0.45512,0.405,0.52739,0.59301,0.55927,0.45739,0.40926,0.52588,0.5938,0.56104,0.45971,0.40673,0.52765,0.59047,0.55664,0.45611,0.41521,0.53259,0.5972,0.56451,0.45555,0.40839,0.53265,0.59423,0.55821,0.44879,0.41379,0.53541,0.59602,0.55583,0.45559,0.41145,0.53423,0.59477,0.55201,0.45093,0.41497,0.53501,0.5969,0.55286,0.45449,0.41313,0.54066,0.59529,0.55753,0.45185,0.4145,0.53902,0.59955,0.5451,0.44663,0.4195,0.53478,0.59769,0.55133,0.4494,0.41748,0.53641,0.59369,0.55216,0.44964,60.933,66.812,79.685,89.323,79.301,61.883,65.08,81.13,90.581,78.8,63.596,65.348,81.93,90.419,77.488,62.502,64.538,81.128,90.001,78.493,62.103,65.568,80.707,89.42,77.915,62.554,65.093,81.021,89.796,76.355,62.434,64.279,81.609,88.797,75.379,61.759,64.51,80.586,87.766,74.047,60.685,63.506,79.211,85.012,71.5,58.516,61.503,75.842,80.143,64.28,53.859,55.713,64.943,65.382,48.554,36.583,35.256,36.631,30.138,18.972,13.317,12.643,13.257,12.751,10.192,9.3233,10.742,12.717,13.142,11.133,10.53,11.981,13.817,13.54,10.915,10.18,11.811,13.92,14.11,11.543,10.72,12.221,14.199,14.147,11.489,10.93,12.777,15.005,14.382,11.734,10.92,12.697,14.856,14.66,12.054,11.261,12.897,14.811,14.625,12.025,11.407,13.135,15.218,14.98,11.987,11.365,13.256,15.333,15.071,12.223,11.63,13.3,15.489,15.258,12.237,11.75,13.457,15.589,15.296,12.274,11.961,13.656,15.82,15.371,12.54,12.143,13.749,16.053,15.532,12.486,12.234,13.883,16.16,15.405,12.27,12.179,13.992,16.417,15.544,12.529,12.254,13.835,16.339,15.48,12.731,12.418,14.067,16.498,15.263,12.574,12.264,14.197,16.736,15.56,12.713,12.326,14.287,16.676,15.462,12.845,12.524,14.605,16.891,15.397,12.876,12.564,14.6,16.852,15.483,12.851,12.582,14.623,16.755,15.562,12.785,12.589,14.738,16.799,15.668,12.832,12.664,14.713,16.709,15.504,12.743,12.766,14.752,16.933,15.727,12.676,12.825,14.843,17.086,15.809,12.82,13.052,14.999,17.146,15.723,12.85,13.089,14.957,17.228,15.652,12.778,13.008,14.919,17.361,15.591,12.701,13.003,14.85,17.489,15.691,12.996,13.139,14.975,17.41,15.394,12.926,0.0:3
0.057341,0.082608,0.11057,0.0052544,0.099868,0.060434,0.077631,0.11536,0.0096897,0.1082,0.058062,0.078342,0.10738,0.0078885,0.10812,0.055619,0.076073,0.10453,0.0039569,0.10418,0.058503,0.077001,0.10962,0.0064443,0.10601,0.054975,0.073699,0.11164,0.001706,0.10065,0.055303,0.077466,0.10829,0.0020052,0.10645,0.055452,0.07589,0.1095,-0.0030013,0.10577,0.059448,0.075758,0.11017,0.0047413,0.104,0.062382,0.063978,0.10796,0.0038072,0.1046,0.060327,0.070487,0.11037,0.0014451,0.10467,0.05688,0.06615,0.11064,-0.002676,0.10328,0.055515,0.068589,0.099426,0.0064272,0.10245,0.062412,0.070325,0.11238,0.0066018,0.10027,0.062159,0.066978,0.09823,0.0047515,0.10487,0.061754,0.064601,0.11008,0.0094206,0.10452,0.057975,0.062849,0.10806,0.0052583,0.10576,0.060351,0.065647,0.10511,68.48,84.499,94.293,111.83,103.85,85.377,81.63,90.283,108.02,93.885,77.257,73.015,78.41,83.485,72.911,58.734,60.176,73.693,80.296,71.801,59.723,61.056,73.692,79.973,71.208,59.974,61.663,73.954,79.893,70.684,59.795,61.634,73.881,79.023,69.625,59.205,61.026,73.235,77.627,67.875,57.597,59.217,70.737,74.411,64.706,54.247,55.491,64.997,67.186,57.725,46.839,46.638,52.274,51.796,42.952,32.93,31.465,34.689,34.701,29.937,23.751,24.1,26.998,29.919,26.666,21.845,22.122,25.265,28.366,25.023,20.825,21.031,24.878,27.828,24.7,20.64,20.878,24.767,26.719,23.731,19.627,20.343,24.784,27.018,24.298,19.58,20.301,24.058,25.984,23.442,18.973,20.236,23.881,26.461,23.551,19.21,20.683,24.138,27.015,23.497,19.505,20.503,23.432,26.254,22.353,18.955,20.104,23.721,26.297,22.126,18.826,19.686,23.523,25.775,21.908,18.647,19.647,23.766,25.651,22.248,18.822,20.035,24.044,25.47,22.269,18.709,20.64,24.626,26.159,22.762,19.005,21.506,25.772,28.754,25.616,23.415,27.06,32.308,36.842,30.216,26.822,28.348,32.744,34.491,28.375,24.728,26.459,32.436,34.31,29.684,25.474,28.655,33.812,34.377,28.112,22.952,25.457,29.672,31.98,26.418,22.705,24.937,28.64,31.219,25.093,22.4,24.587,28.898,30.915,24.804,22.221,24.198,29.299,30.363,24.707,21.641,23.649,28.552,29.144,24.499,21.294,23.746,27.521,27.928,23.409,20.377,23.459,27.097,28.613,23.222,20.413,23.138,26.549,28.455,22.651,20.614,23.152,26.786,28.177,22.214,20.52,22.783,27.371,28.192,22.794,21.259,24.022,29.517,29.724,24.695,22.318,25.736,0.0:3
0.0014339,0.0012419,-9.6302E-4,0.0021601,-0.0012147,0.0016736,9.1567E-4,-4.7547E-4,0.0021189,-0.0010117,0.0016086,0.0012517,-6.5991E-4,0.001339,-0.0012242,6.7109E-4,2.3191E-4,-7.6846E-4,0.0020607,-9.5393E-4,0.0016611,2.8931E-4,-0.0010969,0.0019212,-0.0014287,0.001839,5.9525E-4,-0.0011948,0.0017514,-0.0013653,0.0018965,5.8362E-4,-5.978E-4,0.0017658,-0.0011051,0.0011895,6.4462E-4,-4.711E-4,0.0018936,-0.0014435,0.0016893,5.7484E-4,-2.9537E-5,0.0020687,-7.9294E-4,0.0015151,2.409E-4,-0.001053,0.001319,-0.0012458,0.001576,9.7829E-4,-4.2035E-4,0.0015317,-0.001083,0.0014118,8.9134E-4,-3.7622E-4,0.0027929,-0.0014688,0.0018104,3.8926E-4,-0.0013512,0.0023475,-0.0011386,9.1316E-4,3.5742E-4,7.478E-5,0.0021753,-0.0012635,0.0013188,3.3684E-4,-5.9283E-4,0.0020703,-0.0013904,0.0021989,5.2027E-4,-6.424E-4,0.0014138,-9.4521E-4,0.0016482,6.933E-4,-0.0014549,0.0015769,-0.0016964,0.0023527,6.8603E-4,-7.6401E-4,0.002202,-6.8088E-4,0.0024752,3.8913E-4,-5.2524E-4,0.0018192,-0.0015304,0.0017577,9.0639E-4,2.7479E-4,0.001342,8.5986,7.6342,9.1439,9.7633,8.2662,6.6644,7.4445,9.2607,9.9211,8.0872,6.9004,7.3662,9.3108,9.9324,8.1037,6.7451,7.3059,9.1274,9.7763,8.2154,6.6207,7.35,9.0459,9.8319,8.0211,6.8432,7.1161,9.0938,9.7978,7.9841,6.6844,7.1964,8.9567,9.6875,7.8598,6.6961,7.0505,8.8187,9.4866,7.6774,6.5081,6.8282,8.4643,8.9067,7.0633,5.9182,6.188,7.1204,6.8374,4.9377,3.7114,3.2002,2.7022,1.85,1.0502,0.79621,0.80921,0.82456,0.74237,0.5052,0.61612,0.81482,0.98562,0.96639,0.71594,0.7821,0.92537,1.0238,0.95352,0.6751,0.73657,0.87921,0.99614,0.94381,0.67214,0.73954,0.88505,1.0146,0.97606,0.72094,0.78313,0.92978,1.0445,0.99455,0.72023,0.76839,0.91239,1.0364,0.9984,0.73007,0.77833,0.91544,1.0408,1.004,0.74897,0.79778,0.94031,1.0771,1.0344,0.76798,0.79914,0.93475,1.0697,1.0341,0.78458,0.81017,0.942,1.0815,1.0422,0.79139,0.81814,0.95337,1.0931,1.0631,0.81213,0.82437,0.95213,1.0967,1.0722,0.81922,0.83186,0.96566,1.0984,1.0813,0.82606,0.83028,0.96981,1.111,1.0959,0.84162,0.84247,0.98113,1.1177,1.1085,0.85118,0.85013,0.98452,1.1237,1.1225,0.85931,0.85739,0.99179,1.13,1.1281,0.86324,0.85975,0.99476,1.1409,1.1493,0.88692,0.86579,1.0011,1.1349,1.1436,0.88367,0.86814,1.0076,1.1467,1.162,0.89163,0.87006,1.0071,1.1437,1.1714,0.91307,0.88631,1.0145,1.1565,1.1715,0.90906,0.88255,1.0176,1.1645,1.1947,0.92571,0.89616,1.0149,1.1609,1.1874,0.92778,0.89764,1.0232,1.1701,1.1982,0.92716,0.9039,1.0226,1.1875,1.2219,0.94968,0.90814,1.023,1.1753,1.2081,0.94223,0.91856,1.0346,1.2054,1.2316,0.9514,0.91531,0.0:3
-6.4862E-4,8.2178E-4,-0.0018714,0.0011783,-8.9198E-4,-4.5578E-4,9.4832E-4,-0.001421,9.862E-4,-8.8194E-4,-7.0354E-4,2.4146E-4,-0.0016331,7.6943E-4,-7.7161E-4,-6.5086E-4,3.471E-4,-0.0013604,4.652E-4,-8.1352E-4,-7.951E-4,4.7141E-4,-0.0015564,6.6824E-4,2.439,9.2107,7.5395,6.8912,6.8548,8.4505,8.8835,7.5115,6.6307,6.7977,8.2683,8.7612,7.4854,6.5516,6.7874,8.2225,8.7523,7.504,6.5586,6.8026,8.2416,8.7698,7.4869,6.4969,6.6969,8.0964,8.6309,7.4186,6.4076,6.5379,7.8655,8.3541,7.1565,6.15,6.3021,7.6296,8.1757,7.0687,6.1108,6.2639,7.6051,8.1614,7.0701,6.1033,6.2329,7.5698,8.1426,7.0809,6.1049,6.2167,7.541,8.1268,7.0905,6.0987,6.1834,7.5023,8.0949,7.0661,6.0679,6.1351,7.4572,8.0684,7.0606,6.0665,6.1094,7.4271,8.0466,7.064,6.0539,6.086,7.4113,8.0375,7.0783,6.0575,6.0687,7.3868,8.0288,7.0846,6.0551,6.0463,7.3652,8.0127,7.0913,6.0556,6.0309,7.3365,8.0016,7.102,6.0551,6.0013,7.3162,7.9858,7.1103,6.0481,5.9853,7.2874,7.9614,7.1102,6.0427,5.9694,7.2594,7.958,7.1207,6.0497,5.9533,7.2433,7.9494,7.1255,6.0381,5.9311,7.2158,7.9334,7.1326,6.0395,5.9073,7.1871,7.9196,7.1312,6.0433,5.8926,7.1697,7.9073,7.1514,6.0469,5.8775,7.1514,7.9023,7.163,6.0506,5.8699,7.14,7.8938,7.1737,6.055,5.8481,7.1165,7.8743,7.1821,6.0583,5.8271,7.0943,7.861,7.1935,6.0556,5.8155,7.0621,7.8442,7.1978,6.0604,5.8014,7.0436,7.8353,7.2069,6.0663,5.7951,7.026,7.8249,7.2101,6.0636,5.7636,6.9955,7.7952,7.2176,6.067,5.7482,6.9739,7.7878,7.2252,6.0709,5.7376,6.9525,7.7798,7.2433,6.0815,5.7288,6.9342,0.0:4
1.1027E-4,3.978E-5,-4.7507E-4,3.8272E-4,-5.9485E-4,9.6997E-5,4.6747E-5,-4.3219E-4,3.4426E-4,-5.0074E-4,-7.8903E-5,1.9007E-5,-5.294E-4,4.9645E-4,-5.5827E-4,6.5333E-6,-1.8839E-4,-7.0567E-4,3.6147E-4,-4.6591E-4,0.31834,0.65063,0.54229,0.47973,0.54584,0.63285,0.637,0.53674,0.46125,0.53626,0.61582,0.62232,0.52488,0.45002,0.52313,0.60313,0.60974,0.51463,0.43938,0.51263,0.59019,0.59915,0.5055,0.43032,0.50085,0.57935,0.58871,0.49721,0.42235,0.49208,0.57066,0.58123,0.49019,0.41795,0.48514,0.5633,0.57528,0.48643,0.413,0.47957,0.55789,0.57055,0.48234,0.40942,0.47496,0.55296,0.56681,0.48012,0.40665,0.47142,0.54844,0.56481,0.47795,0.40475,0.46819,0.54652,0.56262,0.47621,0.40267,0.46521,0.54368,0.56046,0.47477,0.40108,0.46293,0.54072,0.55991,0.4738,0.39949,0.46087,0.53896,0.55791,0.47213,0.39907,0.45795,0.5371,0.55626,0.47306,0.39753,0.45779,0.53468,0.55564,0.47249,0.39731,0.45624,0.53406,0.55463,0.4729,0.3969,0.45485,0.53255,0.55579,0.47321,0.39664,0.45431,0.53168,0.55647,0.47363,0.39575,0.45362,0.53145,0.5559,0.47435,0.39624,0.45244,0.52966,0.55532,0.47413,0.39678,0.45262,0.52907,0.5562,0.47435,0.39622,0.45051,0.52947,0.5559,0.47504,0.39621,0.45117,0.52929,0.55605,0.47548,0.39607,0.45008,0.52854,0.55559,0.47604,0.39559,0.44869,0.52717,0.55662,0.47638,0.3969,0.44847,0.52715,0.55643,0.47684,0.39636,0.44764,0.52738,0.55644,0.47731,0.39634,0.44681,0.52606,0.55696,0.47864,0.39708,0.44776,0.5256,0.55665,0.47906,0.39642,0.44732,0.52482,0.55791,0.48062,0.39625,0.44689,0.52391,0.55705,0.48143,0.39633,0.44551,0.52352,0.55767,0.48177,0.39677,0.44488,0.52362,0.55786,0.48293,0.39676,0.44421,0.52329,0.55782,0.48395,0.39824,0.44366,0.0:4
-5.1981E-4,-0.0019287,0.0034839,-0.0036513,0.0014328,3.6475E-4,-0.0027681,0.0043061,-0.0025685,0.0028321,2.2132E-4,-0.0032443,0.0037135,-0.0039377,0.0019796,-0.0011593,2.1875,2.5931,2.4783,3.0753,3.3242,3.0083,2.4598,2.5042,2.9862,3.2996,3.0225,2.4514,2.5267,2.9867,3.2808,2.9513,2.3943,2.4808,2.94,3.2332,2.9082,2.3631,2.458,2.9144,3.1856,2.8518,2.323,2.4214,2.874,3.1393,2.7912,2.2589,2.3479,2.7957,3.0415,2.7125,2.2173,2.3328,2.7848,3.0235,2.6954,2.2001,2.3259,2.7743,3.0074,2.6725,2.1905,2.3281,2.7765,2.9965,2.6517,2.1743,2.3196,2.7676,2.9937,2.6428,2.1721,2.3266,2.7694,2.9861,2.6205,2.1579,2.3239,2.7725,2.9909,2.6113,2.1577,2.3303,2.7628,2.912,2.4745,2.0135,2.1678,2.5454,2.7029,2.3322,1.9327,2.1077,2.5006,2.6829,2.319,1.935,2.1142,2.5093,2.6832,2.3063,1.9295,2.1176,2.5201,2.6892,2.307,1.9318,2.1236,2.5184,2.6766,2.2903,1.9308,2.1295,2.5312,2.6783,2.286,1.9119,2.1159,2.5252,2.67,2.274,1.9263,2.1379,2.5408,2.6695,2.2724,1.9225,2.1396,2.5412,2.6658,2.2672,1.9254,2.1545,2.5559,2.6666,2.2611,1.9225,2.1553,2.5547,2.6662,2.2568,1.9265,2.1692,2.5646,2.6642,2.2476,1.925,2.1734,2.572,2.669,2.2472,1.9267,2.1809,2.5699,2.658,2.232,1.9241,2.1841,2.5788,2.6538,2.2263,1.924,2.1893,2.5811,2.6484,2.2203,1.9234,2.1951,2.5864,2.6474,2.2122,1.923,2.2011,2.5909,2.6495,2.2147,1.928,2.2129,2.5963,2.6432,2.2007,1.9236,2.2153,2.5933,2.6447,2.1974,1.929,2.2295,2.6019,2.653,2.1993,1.9384,2.245,2.6215,2.6552,2.1959,1.9444,2.2508,2.6226,0.0:4
-0.0027107,0.0032621,6.2658E-4,-0.0039508,0.0039678,-0.004568,0.0031172,0.0013781,-0.0027934,0.0046136,-0.0042726,0.002017,8.1042E-4,-0.0035624,0.0049846,-0.004113,0.001953,0.0015753,-0.0045092,0.0049748,-0.0045279,0.0030987,0.0013309,2.3386,2.7815,2.7836,3.5833,3.7599,3.1457,2.7739,3.0243,3.596,3.785,3.1787,2.7049,2.9781,3.5422,3.7347,3.1292,2.654,2.952,3.4916,3.6852,3.0842,2.6193,2.9187,3.4472,3.646,3.0462,2.5989,2.9062,3.4236,3.6167,3.0225,2.5819,2.8923,3.4169,3.5994,2.9926,2.5694,2.8831,3.4057,3.59,2.9777,2.5669,2.8895,3.4104,3.5738,2.956,2.5551,2.8864,3.4079,3.5771,2.9555,2.5555,2.8935,3.4084,3.5607,2.9393,2.5513,2.9026,3.4179,3.5697,2.9449,2.5566,2.9061,3.4211,3.55,2.9258,2.552,2.9244,3.4465,3.5627,2.9345,2.5639,2.9271,3.4381,3.547,2.9135,2.5609,2.9487,3.4467,3.5579,2.9137,2.5581,2.9303,3.4398,3.5462,2.909,2.5667,2.9716,3.4682,3.5581,2.9071,2.5606,2.9622,3.469,3.5563,2.907,2.5795,2.9852,3.4766,3.5441,2.8874,2.5696,2.9885,3.4893,3.559,2.9034,2.5827,3.0076,3.4975,3.5467,2.8922,2.5842,3.0117,3.5084,3.5537,2.8849,2.5902,3.0189,3.5063,3.5371,2.8772,2.5876,3.034,3.5236,3.546,2.8832,2.5919,3.0327,3.5132,3.5307,2.8731,2.5899,3.0634,3.5345,3.5421,2.8719,2.5968,3.0641,3.5273,3.5345,2.8741,2.6038,3.0796,3.5407,3.5375,2.8582,2.6079,3.0846,3.5541,3.539,2.8628,2.6195,3.1085,3.5507,3.5361,2.8474,2.6198,3.1097,3.5685,3.5323,2.8521,2.625,3.1189,3.5737,3.5148,2.846,2.6235,3.1235,3.5763,3.5133,2.8423,2.6325,3.1374,3.5936,3.5043,2.834,2.6254,0.0:4
2.4387E-5,3.8334E-4,-2.949E-4,5.0391E-4,-2.591E-4,-1.0055E-4,3.2243E-4,-4.4768E-4,3.616E-4,-1.495E-5,-3.0067E-5,2.2311E-4,-3.9668E-4,3.6671E-4,-2.8592E-4,-2.1714E-4,3.9838E-4,-2.815E-4,4.6284E-4,-2.8653E-4,-2.3739E-4,4.1044E-4,0.17681,3.1792,4.2098,4.3134,3.5449,3.2769,3.2806,4.0829,4.2468,3.5387,3.1856,3.2734,4.0156,4.2023,3.5228,3.15,3.2546,3.9862,4.1815,3.5043,3.1325,3.2384,3.9652,4.1635,3.5019,3.1187,3.2251,3.9445,4.1539,3.4891,3.1052,3.2184,3.9309,4.14,3.4791,3.1048,3.2103,3.927,4.1394,3.4799,3.0998,3.2029,3.9215,4.1342,3.4844,3.093,3.198,3.9119,4.1356,3.4785,3.0936,3.1926,3.9128,4.1241,3.4801,3.0928,3.1854,3.9032,4.1327,3.4849,3.0929,3.1842,3.9023,4.1269,3.4879,3.0912,3.1794,3.8955,4.1262,3.4862,3.0911,3.1795,3.895,4.1304,3.4918,3.0925,3.176,3.8908,4.1263,3.4925,3.094,3.1699,3.8894,4.1215,3.4951,3.0902,3.1713,3.8823,4.1223,3.495,3.0903,3.1623,3.8807,4.1239,3.4989,3.0892,3.1591,3.8748,4.1204,3.5022,3.0921,3.1563,3.8702,4.1215,3.5002,3.0906,3.1532,3.8631,4.1136,3.5062,3.0893,3.1458,3.8649,4.1166,3.5078,3.0901,3.1442,3.8648,4.1135,3.5112,3.0894,3.1436,3.8604,4.1183,3.5158,3.0905,3.1387,3.858,4.1166,3.5189,3.0915,3.1363,3.8451,4.1186,3.5204,3.0891,3.1366,3.8478,4.1075,3.524,3.0919,3.1314,3.8446,4.1093,3.5313,3.0955,3.1276,3.8425,4.1132,3.5294,3.0949,3.1197,3.8401,4.1196,3.5353,3.0932,3.1176,3.8331,4.11,3.533,3.0956,3.1161,3.8358,4.1118,3.5422,3.098,3.1189,3.8266,4.1121,3.5408,3.0959,3.1096,3.8248,4.1062,3.5451,3.0968,3.1112,3.8214,0.0:4
5.2557E-4,-3.9111E-4,1.8703E-4,-7.21E-5,-1.4854E-4,5.0848E-4,-5.4552E-4,2.5616E-4,2.6667E-4,-3.7374E-4,5.1289E-4,-2.264E-4,2.5198E-4,-1.2298E-4,-3.1108E-4,3.7471E-4,-5.4319E-4,2.4105E-4,3.8E-6,-2.1883E-4,4.0065E-4,-2.8743E-4,3.4449E-4,2.0711,4.0304,3.0155,3.4803,3.8252,4.2911,3.8842,3.0677,3.3454,3.8153,4.2378,3.8281,3.0568,3.2891,3.7894,4.2002,3.7921,3.044,3.267,3.7726,4.179,3.7736,3.0332,3.2435,3.7548,4.1627,3.7566,3.0201,3.2341,3.7436,4.1501,3.7525,3.0167,3.2294,3.7326,4.1379,3.7462,3.0119,3.2169,3.7289,4.1386,3.7365,3.0069,3.2132,3.7229,4.1326,3.7358,3.0063,3.2148,3.7228,4.1317,3.733,3.0096,3.2158,3.7235,4.1297,3.7406,3.0045,3.2101,3.7168,4.1286,3.7386,3.0025,3.2092,3.7114,4.1244,3.7299,2.9963,3.2055,3.7133,4.1245,3.7337,3.0025,3.2026,3.7091,4.1215,3.7307,2.9989,3.201,3.7068,4.1156,3.7327,3.0001,3.1965,3.7026,4.1117,3.7314,2.9968,3.1973,3.6969,4.1157,3.7282,3.0016,3.1936,3.698,4.1149,3.7265,2.996,3.1947,3.6971,4.1104,3.7279,2.9934,3.1953,3.694,4.1094,3.7328,2.9945,3.1888,3.6877,4.1133,3.726,2.9948,3.1859,3.6854,4.107,3.727,2.9922,3.1824,3.6901,4.1007,3.7293,2.9944,3.1788,3.6829,4.0942,3.7261,2.9921,3.1791,3.6772,4.0996,3.7261,2.9919,3.1813,3.6774,4.0987,3.726,2.9901,3.1808,3.6783,4.1019,3.7231,2.9901,3.18,3.6757,4.0977,3.7269,2.9942,3.1678,3.6727,4.0928,3.7255,2.9919,3.1758,3.6695,4.0924,3.7259,2.9929,3.1714,3.67,4.093,3.7251,2.9896,3.1739,3.6704,4.0997,3.7257,2.9935,3.1705,3.6707,4.0945,3.7298,2.9861,3.1672,3.6679,4.0942,3.73,0.0:4
4.9167E-6,-2.4E-6,1.0443E-5,-4.1667E-6,-1.45E-6,7.2667E-6,-8.5133E-6,1.083E-5,-2.28E-6,-1.1E-7,8.3E-6,-7.0833E-6,6.47E-6,1.88E-6,-3.35E-6,2.9167E-6,-3.5667E-6,3.2367E-6,-4.7333E-7,-4.25E-6,5.0467E-6,-3.15E-6,7.0E-6,5.5833E-6,-3.9067E-6,6.0333E-7,-4.63E-6,7.0E-6,1.88E-6,3.1167E-6,7.8567E-6,-5.3867E-6,6.6967E-6,-2.68E-6,-2.45E-6,3.6767E-6,-2.1267E-6,8.69E-6,0.048667,0.066112,0.057832,0.058004,0.056971,0.070851,0.072903,0.060117,0.053395,0.056349,0.067806,0.070264,0.058644,0.051362,0.055062,0.065779,0.068449,0.057337,0.050085,0.053902,0.064484,0.067145,0.056418,0.049279,0.053042,0.063449,0.066225,0.055804,0.04871,0.052357,0.062631,0.065502,0.055374,0.04823,0.051734,0.062054,0.06497,0.055057,0.047871,0.051254,0.061534,0.064598,0.054873,0.047615,0.050915,0.061159,0.064276,0.054732,0.047402,0.050576,0.060857,0.064098,0.054701,0.047302,0.050363,0.060498,0.063907,0.054743,0.047217,0.050145,0.060354,0.063793,0.054737,0.047113,0.04989,0.060097,0.063662,0.054771,0.047034,0.049704,0.059788,0.06356,0.054811,0.046998,0.049454,0.059686,0.063447,0.054863,0.04698,0.049329,0.059529,0.063355,0.054957,0.046915,0.049168,0.059363,0.063268,0.055071,0.04691,0.048981,0.05918,0.063239,0.0552,0.046945,0.048856,0.059022,0.06319,0.055257,0.046917,0.04868,0.058841,0.063151,0.055466,0.047002,0.048552,0.058762,0.063099,0.055568,0.047019,0.048446,0.058606,0.063088,0.055675,0.047056,0.048352,0.058474,0.062985,0.055807,0.047056,0.048142,0.058261,0.062912,0.055991,0.041632,0.046957,0.052977,0.059119,0.05298,0.031794:4
-6.3067E-6,5.4267E-6,4.68E-6,7.2933E-6,5.57E-6,-3.7433E-6,5.8367E-6,4.6333E-7,-2.0467E-6,4.51E-6,-2.2267E-6,4.0833E-6,2.4033E-6,5.17E-6,9.1467E-6,-3.51E-6,6.86E-6,-3.1E-7,3.23E-6,-6.2333E-7,-9.1133E-6,6.1167E-6,-1.4E-7,5.0633E-6,5.0E-6,-6.2767E-6,3.17E-6,-1.1467E-6,-1.5667E-7,0.032629,0.047,0.052435,0.05386,0.06677,0.061719,0.049115,0.049066,0.054373,0.065218,0.060561,0.048946,0.047954,0.053907,0.064225,0.05984,0.048439,0.047277,0.053321,0.063363,0.059379,0.04803,0.04678,0.052892,0.062825,0.058906,0.047736,0.046343,0.052469,0.062206,0.058637,0.047506,0.046032,0.052158,0.061771,0.058352,0.047252,0.045792,0.05199,0.061487,0.058154,0.047148,0.045526,0.051671,0.061152,0.057923,0.047016,0.045309,0.051392,0.060871,0.057814,0.046966,0.045088,0.051172,0.060584,0.05769,0.04684,0.044891,0.050893,0.060391,0.057736,0.046865,0.044756,0.050675,0.060196,0.057629,0.046836,0.044664,0.050542,0.060101,0.057594,0.046906,0.044558,0.05041,0.059967,0.057583,0.046901,0.044463,0.050249,0.059788,0.057544,0.046888,0.044358,0.050104,0.059723,0.057523,0.046951,0.044293,0.049951,0.059599,0.057552,0.04703,0.044209,0.04979,0.059498,0.057541,0.047059,0.044121,0.049672,0.059403,0.057571,0.047099,0.044054,0.049574,0.059319,0.057587,0.047179,0.04404,0.049485,0.059266,0.057646,0.047289,0.04401,0.04936,0.059234,0.05767,0.047355,0.043946,0.049293,0.059102,0.057707,0.047379,0.043919,0.049153,0.05905,0.057744,0.047446,0.043867,0.049067,0.058956,0.057787,0.047518,0.043856,0.048905,0.058889,0.057798,0.047644,0.043829,0.048817,0.05886,0.05783,0.047656,0.043778,0.048762,0.058837,0.057828,0.047761,0.043784,0.04868,0.058748,0.057866,0.047854,0.04376,0.048594,0.058764,0.057888,0.047908,0.043726,0.048495,0.05863,0.05795,0.048034,0.04371,0.048344,0.0586,0.057933,0.048063,0.043632,0.048312,0.058486,0.057966,0.0:4
7.62E-6,1.8E-7,-3.33E-6,1.29E-6,-6.8333E-7,6.64E-6,2.0467E-6,6.1933E-6,5.38E-6,-5.2333E-6,7.3833E-6,2.89E-6,8.3533E-6,6.9867E-6,-3.2333E-6,9.05E-6,3.8733E-6,5.6667E-8,9.5067E-6,-2.0333E-6,4.5767E-6,6.2133E-6,4.8067E-6,2.1033E-6,-3.7667E-7,8.45E-6,-4.96E-6,-3.08E-6,5.5533E-6,-2.7567E-6,4.1133E-6,-1.4367E-6,4.4367E-6,4.75E-6,-2.57E-6,5.1033E-6,8.6667E-8,-2.2667E-7,0.042344,0.047098,0.052043,0.056619,0.066412,0.059538,0.047839,0.04982,0.056397,0.065114,0.058565,0.047403,0.048935,0.055742,0.064247,0.058035,0.046927,0.048316,0.055168,0.063505,0.057528,0.04656,0.047816,0.05468,0.062916,0.057205,0.046223,0.047364,0.054361,0.062384,0.056884,0.046008,0.047032,0.053962,0.062003,0.056711,0.04582,0.046693,0.053672,0.061604,0.056491,0.045706,0.04639,0.053389,0.061387,0.056394,0.045577,0.046052,0.052897,0.061146,0.056331,0.045537,0.04601,0.052959,0.060937,0.056276,0.04542,0.045816,0.052762,0.060787,0.056209,0.045427,0.045671,0.05256,0.06062,0.056211,0.045376,0.045508,0.052407,0.060552,0.056204,0.045455,0.045442,0.052254,0.060361,0.056201,0.045396,0.045253,0.052044,0.060281,0.056203,0.045444,0.04514,0.051916,0.060125,0.056197,0.045411,0.045029,0.051758,0.060009,0.056198,0.045465,0.044927,0.051625,0.059977,0.056239,0.045476,0.044806,0.051497,0.059887,0.056231,0.045529,0.044723,0.051359,0.059831,0.05635,0.045541,0.044652,0.051223,0.059773,0.056301,0.045591,0.044555,0.051097,0.059717,0.056356,0.045603,0.044479,0.050939,0.059609,0.056412,0.045712,0.044407,0.05081,0.059586,0.056429,0.045735,0.044382,0.050709,0.059511,0.056452,0.045806,0.044292,0.050598,0.05946,0.056583,0.045852,0.044259,0.050482,0.059426,0.056611,0.045929,0.044154,0.050332,0.059373,0.056663,0.045976,0.044085,0.05022,0.059308,0.056686,0.046039,0.044081,0.05013,0.059225,0.056717,0.046119,0.044,0.050028,0.059154,0.056762,0.046208,0.0:4
1.87E-6,1.66E-6,9.1667E-7,1.95E-6,6.1333E-7,2.2067E-6,2.1333E-6,-4.1667E-7,1.1967E-6,1.2133E-6,1.83E-6,2.94E-6,3.0E-7,1.2333E-6,4.8667E-7,1.51E-6,2.8167E-6,7.9667E-7,1.69E-6,7.9E-7,2.1933E-6,1.63E-6,7.1E-7,1.51E-6,8.4667E-7,1.6533E-6,2.9033E-6,4.6667E-7,1.3433E-6,4.4E-7,0.0046225,0.0055698,0.0052393,0.0039936,0.0044236,0.0049291,0.0055589,0.0051849,0.0040326,0.0043843,0.0049285,0.0055475,0.0051603,0.0040534,0.0043526,0.0049112,0.0055124,0.0051687,0.0040485,0.0043419,0.0049075,0.0055206,0.0051509,0.0040406,0.0043266,0.0048972,0.0055055,0.0051376,0.0040312,0.0043076,0.0048838,0.0054881,0.0051559,0.0040232,0.0042819,0.0048713,0.0054963,0.0051448,0.0040307,0.0042971,0.0048575,0.0054795,0.0051459,0.0040253,0.0042999,0.0048539,0.0054506,0.0051225,0.0040304,0.0042738,0.0048382,0.005461,0.0051372,0.0040398,0.004263,0.0048225,0.0054478,0.0051366,0.0040184,0.0042583,0.0048119,0.0054444,0.0051528,0.0040339,0.0042637,0.0047916,0.0054502,0.0051521,0.0040375,0.0042488,0.0048002,0.0054312,0.0051636,0.0040136,0.0042465,0.0047888,0.0054188,0.0051563,0.0040123,0.0042441,0.0047698,0.0054298,0.0051829,0.0040219,0.0042441,0.0047576,0.00542,0.0051474,0.0040248,0.0042262,0.0047618,0.0054242,0.0051809,0.0040513,0.0042106,0.004763,0.0054232,0.0051749,0.0040293,0.0042237,0.004747,0.005418,0.005172,0.0040499,0.0042016,0.0047372,0.0054387,0.0052043,0.0040402,0.004226,0.0047421,0.005414,0.005205,0.0040488,0.0041991,0.0047405,0.0054156,0.005196,0.0040576,0.0042079,0.0047327,0.0054201,0.0052202,0.0040502,0.0042071,0.004726,0.0054076,0.0052024,0.0040479,0.0041936,0.004709,0.0054168,0.0052267,0.0040708,0.0042212,0.004705,0.0054051,0.0052136,0.0040587,0.0041904,0.0046966,0.0054146,0.005197,0.0040681,0.0041913,0.0046803,0.0054099,0.0052338,0.004073,0.0041796,0.0046702,0.0054114,0.0052191,0.0040721,0.0041717,0.0046854,0.005403,0.0052465,0.0040848,0.004174,0.0046701,0.0053928,0.005247,0.0040882,0.0041745,0.004658,0.0053868,0.0052411,0.00409,0.0041703,0.0:4
1.49E-6,9.9E-7,2.15E-6,1.66E-6,6.9E-7,2.0133E-6,9.6E-7,1.3467E-6,1.2967E-6,1.2933E-6,1.36E-6,1.3033E-6,1.7833E-6,1.7267E-6,1.4467E-6,1.8767E-6,3.8667E-7,1.67E-6,1.03E-6,1.3867E-6,1.4167E-6,7.2333E-7,1.66E-6,1.7867E-6,1.5333E-6,1.97E-6,5.5667E-7,2.1567E-6,2.0533E-6,1.5967E-6,1.83E-6,9.6E-7,2.4267E-6,1.2833E-6,1.3433E-6,0.0023593,0.0042177,0.0042588,0.0052427,0.0055443,0.0046557,0.0042061,0.0042522,0.0052367,0.0055378,0.0046504,0.0041739,0.0042567,0.0052374,0.0055176,0.0046583,0.0041759,0.0042262,0.0052184,0.0055034,0.0046385,0.0041693,0.004219,0.0051792,0.0055094,0.0046658,0.0041663,0.0042051,0.0051873,0.0054993,0.0046443,0.0041663,0.0042001,0.0051702,0.0054817,0.0046658,0.0041488,0.004164,0.00517,0.0054798,0.0046521,0.0041606,0.0041686,0.005156,0.0054747,0.0046663,0.0041475,0.004165,0.0051374,0.005476,0.0046764,0.0041385,0.0041534,0.0051353,0.0054734,0.0046816,0.0041487,0.0041433,0.0051143,0.0054576,0.0046731,0.0041569,0.0041278,0.0051039,0.0054461,0.0047006,0.0041524,0.0041226,0.0050991,0.0054407,0.0046893,0.0041532,0.004108,0.0050805,0.0054519,0.0047048,0.0041447,0.0041078,0.005096,0.0054361,0.0047125,0.0041737,0.0041136,0.0050786,0.00545,0.0047196,0.004161,0.0040866,0.0050769,0.0054555,0.0047241,0.0041465,0.004085,0.0050802,0.0054512,0.0047295,0.0041756,0.0040824,0.0050704,0.0054165,0.0047316,0.0041514,0.0040773,0.0050529,0.0054284,0.0047391,0.004154,0.0040709,0.0050483,0.0054188,0.0047482,0.0041607,0.0040548,0.0050446,0.0054178,0.0047623,0.0041491,0.0040446,0.0050268,0.0054127,0.0047737,0.004158,0.0040438,0.0050316,0.005398,0.0047754,0.0041715,0.0040378,0.0050091,0.0054104,0.0047934,0.0041783,0.0040296,0.0050089,0.0054067,0.0048004,0.0041774,0.0040226,0.0050062,0.0054004,0.0048024,0.0041806,0.0040421,0.0050105,0.0053839,0.0048118,0.0041762,0.0040098,0.0049963,0.0053945,0.0048189,0.0041732,0.0040091,0.0049789,0.0053999,0.0048198,0.0041893,0.0040022,0.0049651,0.0053955,0.0048319,0.0041654,0.0039924,0.0049596,0.0054018,0.0048411,0.004181,0.0039851,0.0049497,0.005399,0.0048533,0.004197,0.0039935,0.0049716,0.0053855,0.0048578,0.0042047,0.0039785,0.0049389,0.0053924,0.0048694,0.0042011,0.003985,0.0049504,0.0053783,0.0048734,0.0042064,0.0039749,0.0049408,0.005383,0.0048734,0.0042087,0.0039656,0.0049259,0.005377,0.0048898,0.004222,0.0039517,0.0049249,0.0053662,0.0049157,0.0042158,0.0039546,0.0049023,0.0053716,0.0049159,0.0042311,0.0039539,0.004911,0.0053708,0.0049306,0.0042257,0.0039509,0.0049161,0.0053676,0.0049376,0.0042431,0.0039481,0.0049072,0.0053607,0.0049393,0.004239,0.0039537,0.0048973,0.0053601,0.0049362,0.0042454,0.003933,0.0048783,0.0053643,0.0049586,0.0042283,0.003925,0.0048848,0.0053614,0.004962,0.0042528,0.0039337,0.0048651,0.0053453,0.0049814,0.0042536,0.0039116,0.0048725,0.0053333,0.0049812,0.0042526,0.003918,0.0024242:4
1.6133E-6,2.72E-6,2.1533E-6,7.7667E-7,2.41E-6,1.6333E-6,1.8467E-6,2.5533E-6,7.5667E-7,2.2133E-6,9.0E-7,1.81E-6,2.2867E-6,7.2667E-7,1.44E-6,1.5133E-6,1.8867E-6,1.9033E-6,1.08E-6,1.6067E-6,2.1533E-6,2.1667E-6,2.4333E-6,9.8333E-7,1.7933E-6,1.2867E-6,2.3133E-6,1.7867E-6,1.1233E-6,1.3433E-6,1.6333E-6,2.1433E-6,2.1333E-6,1.15E-6,1.32E-6,3.7163E-5,0.0046781,0.005538,0.0052522,0.0039908,0.0043711,0.0048294,0.0054745,0.0051921,0.0040554,0.0043054,0.0048306,0.0054752,0.0051781,0.0040494,0.0042906,0.0048251,0.0054456,0.0051892,0.0040456,0.0042518,0.0047988,0.0054466,0.0051871,0.004046,0.0042415,0.0047793,0.0054438,0.0051663,0.0040315,0.0042453,0.0047635,0.0054296,0.0051706,0.0040474,0.004221,0.004748,0.0054096,0.0051775,0.0040292,0.0042138,0.0047456,0.0054102,0.0051948,0.0040446,0.0042083,0.0047297,0.0054022,0.0051914,0.004047,0.0041867,0.0046996,0.0054004,0.0052032,0.0040431,0.0041952,0.0046928,0.0053903,0.0051798,0.0040543,0.0041856,0.0046884,0.0053838,0.0052079,0.0040448,0.004174,0.0046798,0.0053822,0.0051971,0.0040543,0.0041615,0.0046446,0.0053624,0.0052145,0.0040471,0.0041723,0.0046321,0.0053597,0.0052016,0.0040636,0.0041618,0.0046292,0.0053686,0.0052103,0.0040771,0.0041514,0.004627,0.0053587,0.0052194,0.0040603,0.0041424,0.0046117,0.0053608,0.0052296,0.0040859,0.004141,0.0046033,0.0053494,0.0052371,0.0040823,0.0041484,0.0046048,0.0053506,0.005255,0.0040854,0.0041354,0.0045853,0.0053556,0.0052548,0.0041002,0.0041371,0.0045671,0.0053443,0.0052546,0.0040995,0.0041153,0.0045774,0.0053401,0.0052538,0.0040951,0.004119,0.0045531,0.0053227,0.0052586,0.0041047,0.0041149,0.0045495,0.005325,0.0052668,0.0041158,0.0040995,0.0045356,0.0053398,0.00528,0.0041131,0.0041076,0.0045399,0.005328,0.0052837,0.0041304,0.0040987,0.0045254,0.0053365,0.0052847,0.0041459,0.0040972,0.0045096,0.0053249,0.0052804,0.0041252,0.0040993,0.0045061,0.0053193,0.0052958,0.0041527,0.0040991,0.00449,0.0053188,0.0053106,0.0041516,0.0041107,0.0044844,0.0053148,0.0053164,0.0041678,0.0041004,0.0044728,0.0052946,0.0053185,0.0041761,0.0040919,0.0044733,0.0053056,0.0053179,0.0041792,0.004093,0.0044463,0.0052846,0.0053303,0.0041844,0.0040961,0.0044477,0.0053004,0.0053386,0.0041932,0.0040823,0.0044456,0.0052934,0.0053343,0.0042212,0.0040846,0.0044359,0.0052878,0.0053275,0.0042139,0.0040714,0.0044248,0.0052846,0.0053467,0.0042304,0.0040767,0.0044193,0.0052814,0.0053607,0.0042398,0.0040764,0.0044021,0.0052669,0.0053606,0.0042353,0.004077,0.0043924,0.0052791,0.0053642,0.0042551,0.004069,0.0043812,0.005268,0.0053725,0.0042626,0.0040847,0.0043827,0.0052551,0.0053638,0.0042634,0.0040742,0.0043726,0.0052515,0.0053614,0.0042858,0.0040731,0.0043599,0.0052541,0.0053931,0.0042765,0.0040861,0.0043585,0.0052452,0.0053727,0.0043037,0.0040767,0.0043625,0.0052489,0.0053836,0.0043108,0.004067,0.0043388,0.0052288,0.0053719,0.0043155,0.0040703,0.0043404,0.0052449,0.0053865,0.0043354,0.0040894,0.0043255,0.0052316,0.0053843,0.0043122,0.0040849,0.0043273,0.0052292,0.0053853,0.0043396,0.004076,0.004308,0.0052075,0.0054034,0.0043499,0.0040652,0.0043086,0.0052023,0.0054142,0.004355,0.0040741,0.0043045,0.0052316,0.0053984,0.0043688,0.0040777,0.004297,0.0051963,0.0053993,0.0043881,0.0040768,0.0042777,0.0052004,0.0053973,0.0043915,0.0040849,0.0042927,0.0051925,0.0054082,0.0043981,0.0040772,0.00428,0.005185,0.0054092,0.0044015,0.0040911,0.004254,0.005179,0.0054178,0.0044074,0.0040875,0.0042421,0.0051964,0.0054267,0.0044282,0.0040739,0.0037053:4
-1.0067E-6,-2.3167E-6,-2.1233E-6,-2.4467E-6,-2.0567E-6,-2.2033E-6,-1.5833E-6,-1.7667E-6,-2.2433E-6,-2.7267E-6,-2.5467E-6,-2.18E-6,-9.5667E-7,-2.82E-6,-3.0233E-6,-2.5167E-6,-1.22E-6,-2.0833E-6,-2.4433E-6,-3.1667E-6,-1.6033E-6,-1.8633E-6,-2.24E-6,-2.79E-6,-3.53E-6,-3.7E-7,-2.2967E-6,-4.7667E-7,-2.7167E-6,-2.7933E-6,-1.5167E-6,-2.3533E-6,-9.3333E-7,-2.3767E-6,-2.7567E-6,-2.34E-6,-2.2067E-6,-1.01E-6,-2.8933E-6,-2.2733E-6,-1.71E-6,-1.2533E-6,-2.1433E-6,-2.9133E-6,-2.0167E-6,-1.1467E-6,-1.5133E-6,-1.1767E-6,-2.73E-6,-3.0367E-6,-1.8333E-6,-1.5533E-6,-1.3367E-6,-2.27E-6,-2.8933E-6,-2.06E-6,-2.6533E-6,3.0308E-4,0.0021872,0.0018512,0.002065,0.0014197,0.0022853,0.002264,0.0019435,0.0019331,0.0015151,0.0022251,0.0022614,0.0019665,0.0019116,0.0015287,0.0022136,0.0022614,0.0019728,0.0019096,0.0015393,0.0022033,0.0022662,0.0019813,0.001909,0.0015286,0.0021927,0.002251,0.0019897,0.0019131,0.0015295,0.0021891,0.0022554,0.0019886,0.001913,0.0015254,0.0021831,0.0022428,0.0019985,0.0019217,0.0015243,0.0021847,0.0022433,0.002009,0.0019277,0.0015186,0.002172,0.0022366,0.0020099,0.0019371,0.0015169,0.0021614,0.0022301,0.0020177,0.0019245,0.0015096,0.0021542,0.0022266,0.0020185,0.0019359,0.0015042,0.0021455,0.0022185,0.0020292,0.0019342,0.0015036,0.0021452,0.0022162,0.002036,0.0019472,0.0014996,0.0021431,0.0022082,0.0020392,0.0019457,0.0014925,0.0021347,0.0022013,0.0020445,0.001943,0.0014874,0.002131,0.002196,0.0020584,0.0019509,0.0014882,0.0021276,0.0021997,0.002063,0.0019563,0.00149,0.0021196,0.0021858,0.0020573,0.0019593,0.0014858,0.0021144,0.0021866,0.0020705,0.0019594,0.0014826,0.0021131,0.0021824,0.0020749,0.0019717,0.0014771,0.0021011,0.002172,0.0020783,0.0019813,0.0014816,0.002097,0.0021713,0.0020959,0.0019811,0.0014822,0.0020907,0.0021629,0.0020938,0.0019768,0.0014793,0.0020792,0.0021598,0.0020992,0.0019893,0.0014763,0.0020766,0.0021609,0.0021054,0.0019887,0.0014776,0.0020769,0.0021512,0.0021085,0.001998,0.0014723,0.0020699,0.0021439,0.0021155,0.0020029,0.0014741,0.0020634,0.0021299,0.0021143,0.0020089,0.0014703,0.0020552,0.0021332,0.0021259,0.0020114,0.0014669,0.0020524,0.0021283,0.0021343,0.0020168,0.0014639,0.0020507,0.0021214,0.0021328,0.0020299,0.001462,0.002036,0.0021178,0.0021383,0.0020297,0.0014645,0.0020392,0.0021132,0.0021424,0.0020379,0.0014644,0.0020365,0.0021049,0.0021458,0.0020439,0.0014673,0.0020287,0.0020947,0.002147,0.0020495,0.0014678,0.0020216,0.0020994,0.0021589,0.0020496,0.0014666,0.0020125,0.0020867,0.0021563,0.0020563,0.001464,0.0020169,0.0020775,0.0021669,0.0020626,0.0014626,0.0020104,0.002074,0.0021688,0.0020724,0.0014641,0.0019989,0.0020704,0.0021785,0.0020718,0.0014655,0.0019954,0.0020629,0.0021731,0.0020773,0.0014651,0.0019913,0.0020601,0.0021841,0.0020853,0.0014701,0.0019885,0.0020511,0.0021896,0.0020925,0.0014732,0.001975,0.0020507,0.002186,0.0020943,0.001467,0.0019735,0.00204,0.0021907,0.0021001,0.0014673,0.0019684,0.0020355,0.0022005,0.0021022,0.0014645,0.0019631,0.0020246,0.002201,0.0021164,0.0014704,0.0019588,0.002023,0.0022054,0.002121,0.0014683,0.0019621,0.0020239,0.0022087,0.0021214,0.0014744,0.0019528,0.0020119,0.0022147,0.0021336,0.0014731,0.0019496,0.0020072,0.0022197,0.0021351,0.0014729,0.0019378,0.0020002,0.0022215,0.0021406,0.0014786,0.0019377,0.001995,0.0022209,0.0021409,0.0014789,0.001934,0.0019917,0.0022248,0.0021539,0.0014811,0.0019265,0.0019851,0.0022281,0.0021608,0.0014858,0.0019219,0.0019832,0.0022374,0.0021597,0.0014842,0.001919,0.0019663,0.00224,0.0021662,0.0014842,0.0019163,0.001968,0.002241,0.0021734,0.0014873,0.0019157,0.0019589,0.0022384,0.0021769,0.0014935,0.0019081,0.0019523,0.0022408,0.0021817,0.001493,0.0019074,0.0019452,0.0022488,0.0021847,0.0014905,0.0019029,0.0019421,0.0022403,0.0021923,0.0014953,0.0018969,0.0019285,0.0022483,0.0021944,0.0014961,0.0018939,0.0019251,0.0022445,0.0021985,0.0014973,0.0018917,0.0019232,0.0022494,0.0022043,0.0015022,0.0018929,0.0019097,0.0022584,0.0022104,0.001504,0.0018867,0.0019137,0.0022555,0.0022169,0.0015127,0.0018816,0.0019033,0.002266,0.0022241,0.0015171,0.0018727,0.0018948,0.0022625,0.0022226,0.001519,0.0018708,0.0018856,0.0022646,0.0022251,0.0015208,0.00187,0.0018784,0.0022709,0.0022324,0.001523,0.0018654,0.0018773,0.0022677,0.0022363,0.001527,0.0018664,0.0018726,0.0022749,0.0022464,0.0015373,0.0018634,0.00187,0.0022733,0.0022443,0.001536,0.0018647,0.0018584,0.0022709,0.0022496,0.0015415,0.0018559,0.0018518,0.0022759,0.0022485,0.0015448,0.0018523,0.0018512,0.0022775,0.0022509,0.0015479,0.0018513,0.0018457,0.0022796,0.0022588,0.0015539,0.0018498,0.001832,0.0022812,0.0022523,0.0015589,0.0018485,0.0018332,0.0022823,0.0022638,0.0015603,0.0018487,0.001822,0.0022799,0.0022653,0.0015689,0.0018424,0.0018145,0.0022823,0.0022599,0.0015722,0.0018485,0.0018107,0.0022813,0.0022729,0.0015693,0.0018413,0.0018082,0.0022782,0.0022741,0.0015778,0.0018387,0.0017979,0.0022838,0.0022719,0.0015852,0.001838,0.00179,0.0022838,0.0022751,0.0015901,0.0018349,0.0017911,0.0022838,0.0022822,0.00159,0.0018302,0.0017836,0.0022812,0.002279,0.0015939,0.00183,0.0017818,0.0022887,0.0022781,0.0016048,0.0018291,0.0017715,0.0022813,0.0022817,0.0016025,0.0018254,7.9035E-4:4
-3.45E-6,-5.1667E-7,-3.4267E-6,-2.2833E-6,-2.9733E-6,-2.9133E-6,-6.9333E-7,-1.62E-6,-6.7667E-7,-3.5933E-6,-2.77E-6,-8.5E-7,-1.97E-6,-2.3567E-6,-2.34E-6,-3.03E-6,-1.0167E-6,-2.12E-6,-2.2067E-6,-2.59E-6,-3.31E-6,-5.5E-7,-2.4367E-6,-1.5567E-6,-2.6967E-6,-2.7667E-6,-8.2667E-7,-2.2067E-6,-1.36E-6,-2.6233E-6,-3.1533E-6,-6.4333E-7,-2.36E-6,-8.9333E-7,-2.4267E-6,-2.9933E-6,-7.4E-7,-2.3267E-6,-3.4E-7,-2.8467E-6,-3.0667E-6,-1.52E-6,-2.7667E-6,-1.5933E-6,0.0011147,0.0016539,0.0020151,0.0015403,0.0023396,0.0023251,0.0017711,0.0018857,0.0016159,0.0022965,0.0023263,0.001802,0.0018535,0.0016333,0.0022865,0.0023228,0.0018028,0.0018575,0.0016255,0.0022756,0.0023175,0.0018178,0.0018565,0.001613,0.0022762,0.0023227,0.0018204,0.0018579,0.0016126,0.0022697,0.0023092,0.001828,0.0018564,0.0016119,0.0022615,0.0023081,0.0018387,0.0018586,0.0016018,0.0022587,0.0023093,0.0018431,0.0018619,0.0015953,0.002253,0.0023045,0.0018549,0.0018571,0.0015874,0.0022562,0.0022991,0.0018563,0.0018546,0.0015844,0.0022487,0.002289,0.001863,0.0018594,0.0015783,0.0022432,0.0022899,0.0018746,0.0018678,0.0015739,0.00224,0.0022841,0.0018801,0.0018652,0.0015701,0.0022395,0.0022894,0.0018871,0.00187,0.0015656,0.0022262,0.0022779,0.0018899,0.0018651,0.0015592,0.0022263,0.0022722,0.0019019,0.0018713,0.0015596,0.0022199,0.0022723,0.0019046,0.0018676,0.0015488,0.0022086,0.0022647,0.0019152,0.0018768,0.0015478,0.0022128,0.0022671,0.0019201,0.0018804,0.0015458,0.0022123,0.0022642,0.0019287,0.00188,0.0015379,0.0021998,0.0022572,0.0019339,0.0018808,0.0015388,0.0021977,0.0022515,0.0019434,0.0018866,0.0015301,0.0021869,0.0022483,0.0019516,0.0018886,0.0015228,0.0021818,0.0022499,0.0019639,0.0018974,0.0015238,0.0021862,0.0022442,0.001962,0.0018985,0.0015151,0.0021858,0.0022325,0.0019706,0.0018982,0.0015132,0.002165,0.0022301,0.0019779,0.0019029,0.0015123,0.0021637,0.0022294,0.0019858,0.0019111,0.0015064,0.0021585,0.0022263,0.0019904,0.0019099,0.0015065,0.0021633,0.0022156,0.0020035,0.0019112,0.0015024,0.0021523,0.0022186,0.0020102,0.0019195,0.0015002,0.0021456,0.0022053,0.0020194,0.0019234,0.0014928,0.0021413,0.0022034,0.002014,0.0019281,0.0014925,0.0021321,0.0021971,0.0020263,0.0019353,0.0014946,0.002125,0.0021965,0.0020325,0.0019366,0.00149,0.0021237,0.0021994,0.0020372,0.0019436,0.0014863,0.0021195,0.0021844,0.0020461,0.0019534,0.0014847,0.0021119,0.0021886,0.0020537,0.0019537,0.0014814,0.0021153,0.0021841,0.0020618,0.0019595,0.0014766,0.002111,0.0021795,0.0020636,0.0019642,0.0014805,0.002097,0.002171,0.0020716,0.0019709,0.0014764,0.0020884,0.0021693,0.002079,0.00197,0.0014755,0.0020875,0.0021636,0.0020829,0.0019802,0.0014673,0.0020831,0.0021513,0.0020842,0.0019813,0.0014709,0.0020761,0.0021507,0.0020943,0.0019936,0.0014659,0.0020698,0.0021418,0.0020965,0.0019936,0.0014703,0.0020618,0.0021384,0.0021052,0.0019944,0.0014669,0.0020638,0.0021343,0.0021163,0.0020044,0.0014661,0.0020497,0.00213,0.0021176,0.002007,0.0014665,0.0020512,0.0021223,0.0021279,0.0020164,0.0014654,0.0020398,0.0021203,0.0021345,0.0020186,0.0014633,0.0020355,0.0021079,0.002139,0.0020296,0.001467,0.0020289,0.0021034,0.002139,0.0020392,0.001466,0.0020296,0.0021068,0.0021451,0.0020379,0.0014689,0.0020221,0.0020971,0.0021491,0.0020487,0.0014636,0.0020184,0.0020968,0.0021556,0.0020531,0.0014628,0.0020112,0.002086,0.0021564,0.0020609,0.0014626,0.0020062,0.0020854,0.0021636,0.0020654,0.0014637,0.0020056,0.0020717,0.0021689,0.0020746,0.0014657,0.001997,0.0020715,0.002172,0.0020762,0.0014634,0.0019955,0.0020663,0.0021768,0.0020816,0.0014679,0.0019853,0.0020577,0.0021863,0.0020859,0.0014638,0.0019901,0.0020451,0.0021815,0.0020935,0.001467,0.0019766,0.0020476,0.0021946,0.0021017,0.0014696,0.0019704,0.0020328,0.002196,0.0021073,0.0014671,0.0019642,0.0020318,0.0022047,0.0021116,0.0014675,0.0019671,0.0020291,0.0022007,0.0021101,0.0014712,0.0019587,0.0020226,0.0022127,0.0021262,0.0014731,0.0019551,0.002014,0.002217,0.0021266,0.0014732,6.9802E-4:4
1.7567E-6,3.0067E-6,3.58E-6,1.0E-6,-3.7E-7,1.9267E-6,7.0E-7,-3.3333E-8,4.9E-7,-3.7333E-7,1.8067E-6,6.0E-8,1.38E-6,2.5333E-7,-1.0167E-6,1.78E-6,-4.2667E-7,1.2333E-6,1.98E-6,3.6667E-7,2.23E-6,1.1967E-6,1.7267E-6,2.7967E-6,2.2333E-7,2.4367E-6,2.6E-7,3.0767E-6,1.3633E-6,-1.1667E-7,2.0967E-6,9.3333E-7,3.0033E-6,1.5833E-6,-2.0E-8,1.6633E-6,8.9667E-7,1.3767E-6,1.7667E-6,0.0042873,0.0059419,0.0070011,0.0080501,0.0076653,0.0065126,0.0058116,0.0070481,0.0080216,0.0076351,0.006541,0.0057863,0.0070295,0.0080016,0.007615,0.0065537,0.0057602,0.0070136,0.0079579,0.007621,0.0065419,0.0057392,0.0069825,0.0079386,0.0076143,0.006536,0.0057299,0.0069654,0.007945,0.0076135,0.0065237,0.0057001,0.0069603,0.0079049,0.0076367,0.0065323,0.0056965,0.0069298,0.0079034,0.0076255,0.006546,0.0057052,0.0069037,0.007883,0.0076242,0.0065368,0.0056992,0.0069052,0.0078867,0.0076371,0.0065307,0.0056901,0.0068826,0.007861,0.0076368,0.0065519,0.005703,0.0068869,0.0078776,0.0076396,0.0065571,0.0056886,0.0068612,0.0078811,0.0076238,0.006555,0.005677,0.0068549,0.0078647,0.0076254,0.0065524,0.0056886,0.0068341,0.0078503,0.0076461,0.006577,0.0056761,0.0068302,0.0078464,0.0076459,0.0065915,0.0056614,0.0068242,0.0078472,0.0076594,0.0065776,0.0056752,0.0067815,0.0078413,0.0076602,0.0066096,0.0056772,0.0067915,0.0078208,0.0076869,0.0066111,0.0056458,0.0067818,0.0078124,0.0076733,0.0066275,0.0056516,0.0067792,0.0077961,0.0076768,0.0066115,0.0056537,0.0067642,0.0078064,0.0076655,0.0066248,0.0056517,0.0067591,0.0078037,0.0076901,0.0066487,0.0056437,0.0067274,0.0078014,0.0076828,0.0066504,0.0056486,0.0067501,0.0077953,0.0077053,0.0066742,0.0056495,0.0067162,0.0077904,0.007693,0.0066844,0.00566,0.0067171,0.007773,0.0077108,0.0066796,0.0056512,0.0066968,0.0077701,0.0077148,0.0066938,0.0056362,0.0067167,0.007773,0.0077102,0.0066951,0.0056374,0.0066983,0.0077688,0.0077399,0.0067196,0.0056391,0.0066669,0.0077618,0.00773,0.0067146,0.0056413,0.0066421,0.0077581,0.0077334,0.0067284,0.0056402,0.006652,0.0077487,0.0077487,0.006744,0.0056281,0.0066492,0.0077406,0.0077593,0.0067567,0.0056473,0.0066428,0.0077518,0.007751,0.0067585,0.0056601,0.0066241,0.0077403,0.0077663,0.0067749,0.005638,0.0066311,0.0077238,0.0077561,0.0067761,0.0056393,0.0066384,0.0077052,0.0077532,0.0068095,0.005628,0.0066131,0.0077093,0.0077627,0.0068016,0.0056443,0.0065989,0.0077029,0.0078063,0.0068226,0.0056384,0.0066016,0.0076942,0.0077797,0.0068045,0.0056501,0.0065902,0.0076756,0.0077886,0.0068546,0.0056424,0.0065723,0.0076745,0.0077801,0.0068349,0.0056507,0.0065746,0.0076809,0.0077775,0.0068601,0.0056384,0.0065458,0.0076792,0.0078152,0.0068713,0.0056357,0.0065651,0.0076568,0.0077904,0.0068828,0.0056385,0.0065271,0.0076564,0.0078111,0.006888,0.0056443,0.0065438,0.0076509,0.0077985,0.0068928,0.0056614,0.0065401,0.0076388,0.0078208,0.0069217,0.005662,0.0065259,0.0076295,0.0078352,0.0069421,0.0056575,0.006518,0.0076229,0.0078325,0.0069416,0.0056475,0.0065003,0.0076239,0.007847,0.0069324,0.0056462,0.0064805,0.007613,0.0078396,0.0069593,0.0056738,0.0064846,0.007604,0.007851,0.0069874,0.0056558,0.006506,0.007598,0.0078501,0.0069698,0.0056627,0.0064731,0.0075916,0.0078724,0.0069807,0.0056537,0.0064661,0.0075725,0.0078734,0.0069874,0.0056854,0.0064595,0.0075727,0.0078658,0.0070226,0.0056535,0.0064461,0.0075521,0.0078708,0.0070163,0.0056802,0.0064217,0.0075654,0.0078614,0.0070278,0.0056676,0.0064269,0.0075561,0.0078839,0.0070307,0.0056791,0.0064358,0.0075468,0.007863,0.0070688,0.0056633,0.0064356,0.0075213,0.0078688,0.00706,0.0056803,0.0064162,0.0075325,0.0078823,0.0070853,0.0056813,0.006408,0.0075096,0.0034499:4
4.4667E-7,1.6267E-6,1.1067E-6,1.34E-6,1.56E-6,2.5E-7,2.49E-6,1.5933E-6,1.0367E-6,2.1433E-6,-4.9667E-7,1.9533E-6,1.1167E-6,1.0E-6,1.6E-6,9.8E-7,2.6433E-6,7.4E-7,1.4033E-6,1.54E-6,5.3667E-7,1.5067E-6,5.8667E-7,1.6733E-6,1.3767E-6,-5.9667E-7,1.5067E-6,1.4167E-6,1.5567E-6,0.0046153,0.0063569,0.0060237,0.0077471,0.0081007,0.0070745,0.0062189,0.0060785,0.0076635,0.0080818,0.0070885,0.0061726,0.0060804,0.007622,0.00808,0.0071091,0.0061528,0.0060477,0.0075834,0.0080625,0.007105,0.0061608,0.0060088,0.0075647,0.008046,0.0071114,0.0061612,0.0059843,0.007502,0.0080427,0.007126,0.006168,0.005958,0.0074896,0.0080206,0.0071535,0.006153,0.0059406,0.0074745,0.0079885,0.007144,0.0061609,0.005932,0.0074455,0.0079887,0.0071567,0.0061762,0.0058941,0.007413,0.007999,0.007198,0.0061614,0.0058813,0.0073904,0.0080026,0.0071995,0.0061772,0.0058627,0.0073638,0.0079694,0.0072309,0.0062004,0.0058477,0.0073355,0.0079801,0.0072183,0.0061884,0.0058429,0.0072887,0.0079526,0.0072303,0.006206,0.0058202,0.007291,0.0079589,0.0072538,0.0062054,0.0058137,0.007243,0.0079382,0.0072838,0.0062242,0.005808,0.0072328,0.0079246,0.007299,0.0062404,0.0057831,0.0072139,0.0079591,0.0073206,0.0062622,0.0057622,0.007199,0.0079412,0.0073371,0.0062691,0.0057678,0.0071657,0.0079267,0.0073489,0.0062536,0.0057709,0.0071437,0.0079306,0.0073896,0.0063112,0.0057519,0.0071333,0.0079204,0.0073892,0.0063095,0.005747,0.0071145,0.0079218,0.0074258,0.0063283,0.0057394,0.0070846,0.0079146,0.0074542,0.0063574,0.0057108,0.007046,0.0079241,0.0074534,0.0063604,0.0057277,0.0070501,0.0079032,0.0074665,0.0063674,0.0057042,0.0070227,0.0079219,0.0074761,0.0063931,0.005701,0.0070053,0.0078938,0.0074887,0.0064081,0.0056972,0.0069733,0.0078818,0.0075269,0.0064358,0.0056814,0.006967,0.0078856,0.0075418,0.0064594,0.0056847,0.0069388,0.0078833,0.0075425,0.0064985,0.0056772,0.0069137,0.0078567,0.0075712,0.0064927,0.0056835,0.0068948,0.0078495,0.0075992,0.0064979,0.0056722,0.0068743,0.0078258,0.007598,0.0:4
4.2667E-7,1.4133E-6,1.7467E-6,8.0333E-7,1.6367E-6,-6.4333E-7,1.84E-6,1.3833E-6,-6.0E-8,2.0967E-6,2.5E-7,1.4267E-6,1.5867E-6,9.9333E-7,1.7333E-6,1.11E-6,2.06E-6,7.1333E-7,5.3667E-7,2.4067E-6,-1.9E-7,2.38E-6,2.0967E-6,1.7E-7,1.5533E-6,-1.0467E-6,2.5133E-6,1.1067E-6,9.1333E-7,1.9633E-6,-5.8333E-7,2.3133E-6,1.4833E-6,1.6667E-7,1.9133E-6,-1.3667E-7,1.4433E-6,2.1333E-6,9.1667E-7,2.4204E-4,0.0057181,0.0067984,0.0079365,0.0079307,0.0065421,0.006011,0.0066181,0.0079632,0.0079601,0.0065092,0.0060534,0.0065312,0.0079513,0.0079256,0.0065006,0.0060646,0.0064744,0.0079371,0.0079279,0.0064948,0.0060561,0.0064508,0.007892,0.0079133,0.0065054,0.0060242,0.0064192,0.0078836,0.007904,0.0065353,0.00603,0.0064027,0.0078614,0.0079114,0.0065525,0.0060128,0.0063636,0.0078415,0.0078924,0.006561,0.0060184,0.0063231,0.0078163,0.0078929,0.00657,0.0059831,0.0063035,0.0078065,0.0079183,0.0065896,0.006007,0.0062801,0.0077883,0.0079091,0.0065946,0.0059968,0.0062413,0.0077649,0.0079058,0.006625,0.0059825,0.0062133,0.0077455,0.007926,0.0066403,0.0059993,0.0062114,0.007729,0.0079144,0.0066807,0.0060077,0.0061701,0.0077259,0.007915,0.0067026,0.0060049,0.0061685,0.0076817,0.0079234,0.0067101,0.0060201,0.0061391,0.0076843,0.0079157,0.0067423,0.0060259,0.0061138,0.0076779,0.0079255,0.0067827,0.0060246,0.0061072,0.007648,0.0079349,0.0067979,0.0060074,0.0060906,0.007647,0.0079182,0.0068229,0.0060288,0.0060645,0.0076175,0.0079342,0.0068414,0.0060179,0.0060619,0.0075866,0.0079274,0.0068762,0.0060414,0.0060374,0.0075681,0.0079425,0.0068691,0.0060211,0.0060068,0.0075649,0.0079593,0.0069029,0.0060473,0.0060043,0.0075337,0.0079693,0.0069441,0.0060691,0.0059942,0.0075246,0.0079538,0.0069556,0.0060828,0.0059934,0.0075101,0.0079588,0.006996,0.0060828,0.0059454,0.0074986,0.007944,0.0070226,0.0060731,0.0059566,0.0075057,0.0079439,0.0070434,0.0060993,0.0059209,0.0074643,0.0079422,0.0070601,0.0061124,0.0059196,0.0074618,0.0079441,0.0070852,0.006104,0.0058976,0.0074213,0.0079558,0.0070962,0.006117,0.0058934,0.007393,0.0079647,0.0071212,0.0061352,0.005893,0.0073768,0.0079495,0.0071357,0.0061316,0.0058803,0.0073599,0.0079544,0.0071409,0.0061577,0.0058823,0.0073444,0.007962,0.0071756,0.0061499,0.0058398,0.0073168,0.0079527,0.0071973,0.0061634,0.0058257,0.0072942,0.0079476,0.0072166,0.0061956,0.0058296,0.0072882,0.0079418,0.0072349,0.0062167,0.0058036,0.0072531,0.007937,0.0072586,0.0062274,0.0057762,0.0072431,0.0079115,0.0073057,0.0062382,0.0057814,0.0072335,0.0079303,0.0073085,0.0062413,0.0057943,0.0072025,0.0079144,0.0073401,0.0062585,0.0057762,0.0071782,0.007914,0.0073492,0.0062759,0.0057662,0.0071596,0.0079286,0.0073762,0.0062858,0.0057598,0.007122,0.0079303,0.0074045,0.0062999,0.0057467,0.0070951,0.0079202,0.0074171,0.0063224,0.0057502,0.0070974,0.0079214,0.0074036,0.0063559,0.0057293,0.0070601,0.007938,0.0074234,0.0063605,0.0057382,0.0070456,0.0079258,0.007454,0.0063835,0.0057171,0.0070116,0.0079032,0.007484,0.0063805,0.0057138,0.0070179,0.0079013,0.0075207,0.0064161,0.0057159,0.0069521,0.0078888,0.0075201,0.0064327,0.0056834,0.0069451,0.0078461,0.007532,0.006433,0.0056705,0.0069286,0.0078653,0.0075451,0.0064508,0.0056809,0.0069093,0.0078634,0.0075565,0.0064758,0.0056653,0.0068722,0.0078405,0.0075626,0.0064817,0.0056532,0.0068126,0.0078088,0.0075856,0.0064883,0.0056334,0.0068192,0.0078301,0.0075819,0.0065193,0.0056593,0.0068132,0.0078049,0.0076155,0.0065501,0.0056333,0.0067734,0.0078084,0.0076107,0.006565,0.0056244,0.0067555,0.0077908,0.0076249,0.0065919,0.0056384,0.0067361,0.0077587,0.0076482,0.0066072,0.0056277,0.0067502,0.0077768,0.0076446,0.0066276,0.0056095,0.0067323,0.0077478,0.0076527,0.0066308,0.0056335,0.0066892,0.0077495,0.0076968,0.0066664,0.0056003,0.0066789,0.0077489,0.007707,0.0067055,0.0056297,0.0066635,0.0077235,0.0077149,0.0067079,0.0056112,0.0066188,0.0077188,0.0077225,0.0067391,0.0056271,0.006603,0.0076851,0.0077249,0.0067617,0.0056244,0.0066027,0.0077048,0.0077587,0.0067862,0.0056098,0.0065721,0.0076842,0.0077593,0.0068105,0.0056202,0.0065428,0.0076624,0.0077577,0.0068405,0.0056233,0.0065524,0.0076374,0.007784,0.0068487,0.0056267,0.0065096,0.00761,0.0077505,0.0068733,0.0056354,0.0065101,0.0075902,0.007792,0.0068855,0.0056182,0.0064844,0.0039155:4
5.3E-7,9.9667E-7,8.6E-7,1.57E-6,2.36E-6,1.0733E-6,9.8E-7,2.0433E-6,1.2967E-6,1.8667E-6,1.4567E-6,1.0067E-6,1.3433E-6,1.6733E-6,1.8833E-6,1.61E-6,1.0267E-6,1.15E-6,1.0367E-6,1.8E-6,1.33E-6,6.3E-7,1.2E-6,1.4367E-6,2.2833E-6,6.1333E-7,0.0060786,0.0077882,0.0083297,0.0095051,0.0089553,0.006864,0.0074749,0.0084328,0.0094764,0.0088718,0.0068908,0.0073969,0.0084625,0.0094274,0.0088203,0.0068927,0.0073627,0.008458,0.0093819,0.008775,0.0068711,0.0073391,0.0084494,0.0093576,0.0087442,0.0068283,0.0073185,0.0084286,0.009351,0.0087125,0.0067966,0.0072911,0.0084218,0.0093253,0.0086743,0.0067934,0.0073064,0.0084286,0.0093167,0.0086359,0.0067541,0.0072986,0.0084379,0.009288,0.0086105,0.0067526,0.0072663,0.0083925,0.00928,0.0085747,0.006725,0.0072976,0.0084048,0.0092487,0.0085695,0.006719,0.007285,0.0084067,0.0092523,0.0085242,0.0066914,0.0073029,0.008418,0.0092435,0.0085335,0.0067129,0.0072651,0.0084284,0.0092069,0.0085149,0.0066931,0.0072673,0.0084287,0.0092402,0.0084763,0.0066633,0.0072759,0.0084241,0.0092146,0.0084723,0.0066607,0.0073004,0.0084229,0.0092268,0.0084608,0.0066589,0.0073111,0.0084251,0.0092142,0.0084602,0.006633,0.007288,0.0084437,0.0091911,0.0084318,0.006641,0.0073098,0.0084538,0.0092217,0.0083888,0.0066436,0.0073118,0.0084879,0.0091847,0.0084007,0.0066449,0.007325,0.0084567,0.0091829,0.0084149,0.0066195,0.0073086,0.0084726,0.0091734,0.0084021,0.0066155,0.0073013,0.0084774,0.0091707,0.0083276,0.0065958,0.0073394,0.0084927,0.0091842,0.0083382,0.0065723,0.007331,0.0084922,0.0091547,0.0083243,0.0065996,0.007336,0.0085155,0.0091954,0.0083234,0.0065801,0.0073553,0.0085225,0.0091512,0.0082855,0.0065735,0.0073714,0.008553,0.0091736,0.0082621,0.0065635,0.0073734,0.0085233,0.009155,0.0082635,0.0065743,0.0073408,0.0085312,0.0091371,0.0082641,0.0065478,0.0073958,0.00855,0.0091554,0.0082864,0.0065591,0.0073692,0.008575,0.0091544,0.0082269,0.006562,0.0074239,0.0085711,0.0091599,0.0082228,0.0065492,0.0074039,0.0085709,0.0091617,0.0081837,0.0065398,0.0074119,0.008593,0.0091448,0.0082003,0.0065664,0.0074374,0.0086029,0.0091418,0.0081998,0.0065295,0.0074366,0.0086014,0.0091305,0.0081607,0.006525,0.0074666,0.0086178,0.0091293,0.0081825,0.0065276,0.0074329,0.0086257,0.0090976,0.00813,0.006549,0.0074537,0.0086418,0.0091363,0.0081496,0.0065429,0.0074745,0.0086104,0.0091496,0.0081041,0.0065173,0.0074832,0.0086507,0.0091151,0.0080782,0.0065086,0.0074826,0.008666,0.0091185,0.0081022,0.0065272,0.0074724,0.0086784,0.0091117,0.0080757,0.0065081,0.007504,0.0086969,0.0091144,0.0080699,0.006507,0.0075192,0.0087028,0.0090873,0.0080543,0.0065112,0.0075148,0.0086742,0.0091,0.0080302,0.0064987,0.0075263,0.0086991,0.0091023,0.0080579,0.0064885,0.0075498,0.0087277,0.0090735,0.0080202,0.0065082,0.0075601,0.0087141,0.0090704,0.0079981,0.0065027,0.007566,0.0087229,0.0090841,0.0079799,0.0065059,0.0075464,0.0087386,0.0090683,0.0079674,0.0064864,0.0075702,0.0087389,0.0090778,0.0079799,0.0064948,0.0075808,0.008746,0.0090521,0.0079618,0.0064872,0.0075948,0.0087575,0.0090681,0.0079486,0.0064774,0.0076024,0.0087515,0.0090452,0.0078995,0.0065007,0.0076045,0.0087451,0.0090516,0.0079475,0.0064573,0.0076405,0.0087737,0.0090468,0.0079317,0.0064995,0.0076275,0.0087896,0.0090316,0.0078878,0.0064896,0.0076592,0.0087845,0.0090329,0.0078985,0.0064618,0.0076528,0.0088092,0.0090413,0.0078894,0.0065019,0.0076691,0.0087993,0.0090294,0.0078542,0.0064702,0.0076858,0.0088178,0.0090179,0.0078846,0.0064754,0.0076724,0.0088171,0.009017,0.0078421,0.0064612,0.0076777,0.0088331,0.0089988,0.0078396,0.0064722,0.0076933,0.0088557,0.0089891,0.0078527,0.0064663,0.0077099,0.0088252,0.0089759,0.0078181,0.0064498,0.007723,0.0088457,0.0089794,0.0077946,0.0064664,0.0077115,0.0088221,0.0089712,0.0077712,0.0064818,0.0077196,0.0088314,0.0089515,0.0:4
1.3767E-6,1.4533E-6,7.8E-7,8.8667E-7,1.3033E-6,1.9833E-6,7.0667E-7,5.6333E-7,5.9333E-7,1.89E-6,2.1367E-6,1.31E-6,1.8733E-6,5.8E-7,1.6367E-6,2.1633E-6,1.5033E-6,1.35E-6,1.12E-6,1.0667E-6,1.5033E-6,4.7E-7,1.3433E-6,7.7333E-7,2.5333E-7,2.34E-6,6.1667E-7,1.6E-6,9.2E-7,1.4467E-6,1.7E-6,1.1233E-6,1.3867E-6,1.5167E-6,1.41E-6,1.0067E-6,0.004347,0.0073752,0.0070966,0.0080319,0.0093639,0.0091654,0.0072651,0.0071282,0.0079775,0.0092999,0.0091395,0.0071943,0.0070863,0.007957,0.0092986,0.0090735,0.0071659,0.007129,0.0079362,0.0093002,0.0090622,0.0071284,0.0070829,0.0079215,0.0092584,0.0090277,0.0071081,0.0070563,0.007928,0.0092655,0.0089828,0.0070699,0.0070571,0.0079076,0.0092117,0.0089769,0.0070611,0.0070391,0.0079194,0.0092224,0.0089248,0.0070007,0.0070684,0.007915,0.0092021,0.0089415,0.0069667,0.0070309,0.0079002,0.0092081,0.0088759,0.0069744,0.0070038,0.0079167,0.0091902,0.0088862,0.0069671,0.0070274,0.0079185,0.009178,0.0088828,0.0069369,0.0070242,0.0079732,0.0091743,0.0088493,0.0068957,0.0070045,0.0079484,0.0091839,0.0088107,0.0069226,0.0070188,0.0079145,0.0091699,0.0088085,0.0069018,0.0070483,0.0079416,0.0091514,0.0087927,0.006882,0.0070294,0.007949,0.0091521,0.0087815,0.006868,0.007032,0.0079778,0.0091393,0.0087573,0.0068116,0.0070385,0.0079975,0.0091481,0.0087568,0.0068348,0.0070341,0.008003,0.0091478,0.0087237,0.0068342,0.0070296,0.0080185,0.0091381,0.0086926,0.0068295,0.0070512,0.0080387,0.0091388,0.0087035,0.0067964,0.0070728,0.0080927,0.0091702,0.0086973,0.0068146,0.0070475,0.0080881,0.0091518,0.0087073,0.0067974,0.0070645,0.0081216,0.0091529,0.0086893,0.0067958,0.0071198,0.0081165,0.0091537,0.0086847,0.0067673,0.0070811,0.0081203,0.0091348,0.0086652,0.0067592,0.0070744,0.0081529,0.0091605,0.008643,0.0067513,0.0071049,0.0081419,0.0091685,0.0086383,0.0067326,0.0070955,0.0081454,0.0091883,0.0085954,0.006717,0.0071335,0.0081579,0.0091529,0.0086212,0.0067329,0.0071248,0.0081788,0.0091524,0.0085899,0.0067078,0.0071304,0.0081877,0.0091595,0.0085917,0.0067377,0.0071347,0.0082192,0.0091521,0.0085958,0.006699,0.0071363,0.0082199,0.0091545,0.0085584,0.0067048,0.0071386,0.00823,0.009168,0.0085578,0.0066812,0.0071463,0.0082434,0.0091608,0.0085033,0.0066891,0.0071568,0.0082639,0.009178,0.008529,0.0066828,0.0071555,0.008266,0.0091725,0.0084949,0.0066672,0.0071593,0.0082858,0.0091538,0.0085156,0.0066557,0.0071824,0.0082795,0.0091402,0.0085091,0.006644,0.0071747,0.008298,0.0091783,0.0084827,0.0066526,0.0072004,0.0083179,0.0091732,0.0084727,0.0066441,0.0071961,0.0083319,0.009141,0.0084462,0.0066621,0.0072113,0.0083266,0.0091627,0.0084627,0.0066236,0.0072063,0.0083362,0.0091352,0.0084495,0.0065969,0.0072543,0.0083688,0.0091399,0.0084137,0.0065815,0.007235,0.0083772,0.0091489,0.008432,0.0066058,0.0072589,0.0083677,0.0091636,0.0083992,0.0065903,0.0072363,0.0083915,0.0091685,0.0083881,0.0065912,0.0072578,0.0083931,0.0091294,0.0083825,0.0065712,0.0072345,0.0084076,0.0091498,0.0083502,0.0065702,0.0072811,0.0084137,0.009134,0.0083372,0.0065975,0.0073148,0.0084251,0.0091436,0.0083308,0.0065694,0.0072963,0.0084362,0.0091578,0.0083321,0.0065549,0.0073051,0.008442,0.0091184,0.0083108,0.0065754,0.0073053,0.0084743,0.0091259,0.0082976,0.0065676,0.0073115,0.0084558,0.0091209,0.0082901,0.0065392,0.0073136,0.0084684,0.0091171,0.0082564,0.0065563,0.0073542,0.0084921,0.0091348,0.0082345,0.006549,0.0073671,0.0084874,0.00911,0.0082412,0.0065268,0.0073662,0.0085359,0.0091144,0.0082363,0.0065023,0.0073434,0.0085151,0.0091161,0.0081962,0.00652,0.0073501,0.0085292,0.0091062,0.0081932,0.0065342,0.0073779,0.0085222,0.0090986,0.0081757,0.0065506,0.0073817,0.0085321,0.0091,0.0081801,0.0065229,0.0073712,0.008571,0.0091015,0.0081475,0.0065089,0.0073846,0.0085542,0.0091057,0.0041459:4
4.4E-7,-5.7667E-7,-9.0E-8,1.6667E-7,-1.4E-7,2.4253E-14,-2.7667E-7,-2.1333E-7,2.8667E-7,2.9667E-7,8.6333E-7,-8.0E-8,2.0667E-7,-4.3333E-8,-7.9E-7,2.3333E-6,-1.1667E-7,-8.1333E-7,-7.3333E-8,-6.0E-8,8.2333E-7,-1.9667E-7,-7.6667E-8,8.7E-7,2.7E-7,-2.5E-7,0.0037307,0.0063811,0.0045627,0.0069752,0.007023,0.0064249,0.0057745,0.0051369,0.0066944,0.0070888,0.0065384,0.0056322,0.0052543,0.0066096,0.00709,0.0065823,0.0055866,0.0052691,0.0065526,0.0070756,0.0066081,0.0055835,0.0052742,0.0065183,0.0071207,0.0065868,0.0055809,0.0052387,0.0065062,0.0070788,0.0066178,0.005569,0.005254,0.0064797,0.0070323,0.0066084,0.0055906,0.0052239,0.0064547,0.0070413,0.006614,0.0055958,0.0052226,0.006438,0.0070364,0.0066299,0.0056162,0.0052103,0.0064108,0.0070188,0.0066489,0.0056032,0.0052126,0.0064129,0.0070184,0.0066645,0.0056114,0.0051838,0.0063735,0.0070132,0.0066528,0.0056414,0.0051888,0.0063592,0.0069899,0.006671,0.0056342,0.0051902,0.0063236,0.0069636,0.0066722,0.0056482,0.0051691,0.0063106,0.0069745,0.0066742,0.0056566,0.0051461,0.0062994,0.0069824,0.0067061,0.0056908,0.0051518,0.0062653,0.0069706,0.0066994,0.0056804,0.0051414,0.006254,0.0069293,0.0067193,0.0057182,0.0051497,0.0062384,0.006917,0.0067514,0.0057085,0.0051145,0.0062233,0.0069155,0.0067331,0.0057342,0.0051139,0.006216,0.00691,0.0067648,0.0057335,0.0051396,0.0061834,0.0069137,0.0067823,0.0057578,0.0051327,0.006193,0.0068921,0.006785,0.0057827,0.0051022,0.0061669,0.0069013,0.0067922,0.0058016,0.0051174,0.0061413,0.0068729,0.0067965,0.0057992,0.0051053,0.0061237,0.0068715,0.0068048,0.0058165,0.0051156,0.0061183,0.0068637,0.0068189,0.005865,0.0050966,0.0060899,0.0068686,0.006832,0.005856,0.0050936,0.0060964,0.0068434,0.0068442,0.0058618,0.0051057,0.0060648,0.0068485,0.006879,0.0058999,0.0051103,0.0060549,0.0068435,0.0068695,0.0058966,0.0051048,0.0060513,0.0068135,0.0068756,0.0059325,0.0050888,0.0060355,0.0068099,0.0068935,0.0059265,0.005106,0.0060115,0.0068003,0.006888,0.005918,0.0050935,0.0060015,0.0067898,0.0069114,0.0059688,0.0051125,0.005962,0.006775,0.0069077,0.0059771,0.0050956,0.0059522,0.0067783,0.006908,0.0059932,0.0050839,0.0059286,0.0067711,0.0069306,0.0060335,0.0051063,0.0059229,0.006743,0.006935,0.0060244,0.0050797,0.0059038,0.0067193,0.0069457,0.0060387,0.0051024,0.0059004,0.0067164,0.0069476,0.0060644,0.0050804,0.0058563,0.0067127,0.00695,0.0060661,0.0050698,0.0058572,0.0067286,0.0069782,0.0060846,0.0051041,0.0058558,0.0066924,0.0069856,0.0060936,0.0051085,0.0058468,0.0066792,0.007001,0.0061108,0.005097,0.0058163,0.0066719,0.006986,0.0061457,0.0051028,0.0057913,0.0066571,0.0070007,0.0061617,0.0051067,0.0057835,0.0066726,0.0070157,0.0061669,0.0051243,0.0057836,0.0066524,0.0070148,0.0061918,0.0051231,0.0057683,0.0066353,0.0070249,0.0062033,0.0051082,0.0057404,0.0066298,0.0070225,0.0062465,0.0051151,0.0057179,0.0065937,0.0070286,0.0062385,0.005124,0.0057248,0.0065851,0.0070397,0.0062507,0.0051145,0.0057086,0.0065841,0.0070717,0.0062875,0.0051421,0.0056772,0.0065683,0.007047,0.0063057,0.0051315,0.0056691,0.0065453,0.0070411,0.0063105,0.0051239,0.0056377,0.0065456,0.007024,0.0063278,0.0051477,0.0056326,0.0065174,0.0070831,0.0063482,0.0051536,0.0056138,0.0065045,0.0070506,0.0063842,0.005136,0.0056105,0.0064928,0.0070951,0.0063864,0.0051471,0.0055995,0.0064742,0.0070729,0.0064089,0.0051712,0.0055951,0.0064621,0.0070699,0.006425,0.0051726,0.0055762,0.0064362,0.0070893,0.0064591,0.0051874,0.0055549,0.0064434,0.0071016,0.0064502,0.0051912,0.0055662,0.0064246,0.0070788,0.0064586,0.0052047,0.0055415,0.0063877,0.0070764,0.0064958,0.0052113,0.0055072,0.0064032,0.0071105,0.006507,0.0051903,0.0054964,0.0063506,0.0070838,0.0065061,0.0052184,0.0054993,0.0063679,0.00711,0.006512,0.005239,0.0055002,0.0063427,0.0071065,0.0065676,0.0052391,0.0054605,0.0063214,0.0071232,0.0065653,0.0052244,0.0054725,0.0063071,0.0070878,0.0065776,0.005269,0.0054577,0.0062727,0.0071055,0.0066073,0.0052538,0.005442,0.0062699,0.0070944,0.0066063,0.0052739,0.0054426,0.0062424,0.0071087,0.0066282,0.005288,0.0054165,0.006239,0.0071114,0.0066387,0.0052874,0.0054394,0.0062176,0.0070999,0.0066631,0.0052915,0.0053863,0.0062115,0.0071201,0.0066685,0.0053206,0.0053914,0.0061857,0.0071071,0.0066922,0.0053121,0.0053606,0.0061736,0.0071022,0.0066991,0.0053149,0.0053754,0.0061387,0.0071177,0.0067046,0.0053434,0.0053604,0.0061158,0.0070801,0.0067311,0.0053608,0.0053482,0.0061266,0.0070972,0.0067337,0.0053872,0.0053341,0.0061035,0.0070841,0.0067529,0.0053649,0.0053313,0.0060699,0.0070865,0.0067494,0.0053891,0.0053385,0.0060574,0.0070879,0.0067624,0.0054112,0.0053204,0.0060741,0.0071131,0.0067833,0.0054071,0.0053318,0.0060333,0.0070959,0.0068175,0.0054502,0.0052978,0.0060058,0.0070714,0.0068335,0.0054418,0.005315,0.005997,0.0070839,0.0068261,0.0054689,0.0052995,0.005993,0.0070733,0.006814,0.0054852,0.0052939,0.0059744,0.0070896,0.0068494,0.0054864,0.0052883,0.0:4
2.4E-7,8.8667E-7,7.9333E-7,1.1333E-7,1.1567E-6,-9.9E-7,1.1167E-6,4.3E-7,3.1E-7,-4.3333E-8,-5.4E-7,1.0667E-6,2.8E-7,-8.6667E-8,2.0667E-7,-9.0667E-7,6.0667E-7,4.3333E-7,1.1933E-6,6.4667E-7,-2.4333E-7,1.0233E-6,3.2E-7,3.8667E-7,-1.8667E-7,-7.9667E-7,1.8833E-6,-7.0E-8,2.4667E-7,1.4233E-6,-8.0E-7,2.13E-6,-2.6E-7,5.0333E-7,3.8667E-7,-4.5333E-7,1.2767E-6,-1.5E-7,2.5667E-7,9.2E-7,-8.3E-7,2.4133E-6,6.2E-7,1.7667E-7,7.1333E-7,-1.0133E-6,2.0E-6,-1.8E-7,3.1E-7,8.1667E-7,-9.1333E-7,6.8E-7,9.4E-7,-1.1667E-7,7.0E-7,-4.4333E-7,1.5167E-6,1.0667E-6,-1.5667E-7,1.0967E-6,-2.0E-7,4.2667E-7,4.6667E-7,9.1333E-7,1.3667E-6,-6.4667E-7,1.51E-6,8.6333E-7,1.8233E-6,9.2667E-7,-9.7667E-7,5.9E-7,2.5333E-7,4.4E-7,1.77E-6,-7.5667E-7,8.9667E-7,8.8333E-7,7.4333E-7,8.9667E-7,-5.1333E-7,1.6833E-6,-6.6667E-8,1.1267E-6,7.0E-7,-1.91E-6,6.1667E-7,-1.0667E-7,8.9333E-7,3.0E-7,-1.2667E-7,1.08E-6,4.9E-7,9.1667E-7,1.2767E-6,-8.4333E-7,1.2833E-6,1.2733E-6,-2.6E-7,2.3333E-7,-8.9667E-7,1.32E-6,-8.3333E-8,1.8533E-6,1.1133E-6,-3.7E-7,1.2867E-6,4.6333E-7,3.0333E-7,3.0E-7,-5.4667E-7,1.8367E-6,9.3667E-7,5.6333E-7,3.3333E-7,-7.3E-7,1.9767E-6,3.6667E-7,4.3E-7,6.7333E-7,-1.5667E-7,5.0333E-7,-6.0E-8,0.0037081,0.006421,0.005424,0.0051431,0.0064145,0.0069335,0.0064177,0.0054282,0.0051575,0.0064025,0.0069235,0.0064352,0.0054661,0.0051494,0.0063957,0.0069191,0.006459,0.0054591,0.0051596,0.0063742,0.006914,0.0064703,0.0054771,0.0051425,0.0063435,0.0069298,0.0065016,0.0054763,0.0051303,0.0063616,0.0069065,0.0064967,0.0055039,0.0051259,0.0063333,0.006926,0.0064981,0.0055055,0.0051039,0.0062988,0.0069038,0.0065194,0.0055269,0.0051256,0.0063047,0.0068954,0.0065324,0.0055247,0.0051033,0.0062782,0.0068881,0.0065962,0.0056111,0.0051244,0.0063223,0.0069318,0.0066219,0.0056078,0.0051313,0.00631,0.0069367,0.0066471,0.0056272,0.0051499,0.0062896,0.006934,0.0066568,0.00564,0.0051377,0.0062864,0.0069341,0.0066814,0.0056456,0.0051046,0.0062551,0.0069231,0.0066714,0.0056722,0.0051148,0.0062398,0.0068993,0.0066835,0.0056608,0.0051097,0.0062125,0.0069116,0.006715,0.005683,0.005104,0.0062126,0.0068973,0.0067207,0.0057168,0.0050993,0.0061984,0.0068946,0.0067167,0.0057374,0.0051045,0.0061736,0.0068925,0.0067401,0.0057491,0.0051162,0.0061787,0.0068986,0.0067349,0.0057622,0.0050991,0.0061473,0.0068952,0.0067707,0.0057799,0.0050976,0.0061107,0.0068627,0.006779,0.0057724,0.005096,0.0060892,0.0068544,0.0067807,0.0057986,0.005091,0.0060973,0.0068287,0.0067683,0.0058226,0.0050969,0.0060702,0.0068443,0.0068049,0.0058256,0.0050752,0.0060578,0.0068363,0.0068058,0.0058434,0.0050918,0.006061,0.0068301,0.0068403,0.005863,0.0050835,0.0060259,0.0068375,0.0068529,0.0058703,0.0050898,0.0060328,0.0067943,0.0068513,0.0058938,0.0050773,0.0060174,0.0067988,0.0068518,0.0059049,0.0050755,0.0059865,0.0067666,0.0068644,0.0059081,0.0050762,0.0059754,0.0067742,0.0068702,0.0059408,0.0050665,0.0059451,0.0067672,0.0068781,0.0059724,0.0050797,0.0059446,0.0067471,0.0068679,0.0059683,0.0050777,0.0059247,0.006742,0.0068944,0.0059903,0.0050744,0.0059344,0.0067259,0.0068952,0.0059998,0.0050733,0.0058899,0.0067193,0.006906,0.0060232,0.0050791,0.0058745,0.0067223,0.0069348,0.0060226,0.0050963,0.0058736,0.0067058,0.0069421,0.0060373,0.0050675,0.0058698,0.0067064,0.0069355,0.0060593,0.005089,0.0058361,0.0066757,0.0069508,0.0060828,0.005068,0.0058373,0.0066676,0.0069583,0.0060757,0.005077,0.0058365,0.0066731,0.0069437,0.0061212,0.0050833,0.0058086,0.0066499,0.0069672,0.0061308,0.0050907,0.0057695,0.006637,0.0069863,0.0061176,0.0050764,0.0057527,0.006632,0.006986,0.0061454,0.0050861,0.0057329,0.0066154,0.0069753,0.0061646,0.0050736,0.0057278,0.0065815,0.0069933,0.00619,0.0051012,0.0057338,0.0065932,0.0069994,0.0061918,0.0051059,0.0057186,0.0065733,0.0070063,0.0062371,0.0051072,0.0057157,0.006556,0.0070045,0.0062343,0.0051102,0.0056867,0.006568,0.0070133,0.0062358,0.0051151,0.0056896,0.0065454,0.0070144,0.0062673,0.0050977,0.0056513,0.0065285,0.0070104,0.0062789,0.0051224,0.0056584,0.0065158,0.0070222,0.006281,0.0050956,0.0056305,0.0065078,0.0070283,0.0062784,0.005118,0.0056276,0.0064698,0.0070147,0.0063466,0.0051252,0.0056038,0.006499,0.007029,0.0063447,0.0051395,0.0056039,0.0064801,0.0070306,0.0063631,0.0051169,0.0055764,0.0064625,0.0070544,0.0063722,0.005135,0.0055788,0.0064482,0.0070571,0.0063875,0.0051394,0.0055709,0.0064334,0.0070606,0.0064052,0.0051467,0.0055489,0.0064145,0.0070572,0.0064208,0.0051625,0.0055431,0.0063783,0.0070596,0.0064381,0.0051678,0.0055363,0.006398,0.0070617,0.0064599,0.0051547,0.0055238,0.0063967,0.0070712,0.0064614,0.0051864,0.0055124,0.0063631,0.007051,0.006485,0.0051796,0.0054966,0.0063707,0.0070583,0.0065066,0.0051996,0.0054638,0.0063306,0.0070862,0.0065231,0.0052082,0.0054878,0.0063293,0.0070704,0.0065408,0.0052377,0.0054643,0.0063213,0.0070536,0.0065432,0.005209,0.0054473,0.0063044,0.0070621,0.006555,0.0052167,0.0054411,0.0031762:4
6.7E-7,-5.6667E-8,7.3E-7,-2.6333E-7,6.2E-7,1.0267E-6,1.1333E-7,7.7667E-7,6.4E-7,2.6E-7,7.9667E-7,-4.7667E-7,1.13E-6,2.7E-7,5.0667E-7,2.1867E-6,-2.7E-7,2.0033E-6,6.4333E-7,9.1333E-7,1.4567E-6,-6.4E-7,7.0667E-7,-2.5E-7,1.0833E-6,3.6E-7,-3.2667E-7,1.37E-6,1.0E-6,2.0333E-7,1.55E-6,-3.2333E-7,-2.5667E-7,-6.3E-7,0.0048479,0.0055723,0.0055216,0.0057978,0.007192,0.0071215,0.0057212,0.0053819,0.0058962,0.0071487,0.0070605,0.0057537,0.0053365,0.0058702,0.0071311,0.0070464,0.0057805,0.00532,0.0058673,0.0070969,0.0070773,0.0057743,0.0053176,0.005846,0.0071014,0.00706,0.0057783,0.0053137,0.0058333,0.0070873,0.0070611,0.0057907,0.0053064,0.0058236,0.0070496,0.0070612,0.0057772,0.0052774,0.0058054,0.0070533,0.0070371,0.0057682,0.0052888,0.0057864,0.0070433,0.0070658,0.005782,0.0053068,0.0057608,0.0070345,0.007051,0.0057776,0.0053663,0.0058361,0.0071525,0.0071653,0.0058707,0.0053424,0.0058573,0.007113,0.0071575,0.0059116,0.0053554,0.0058204,0.0071363,0.0071745,0.0059248,0.0053548,0.0058172,0.0071234,0.0071891,0.0059149,0.0053556,0.0058007,0.0071232,0.0071762,0.0059179,0.0053669,0.0058114,0.0071129,0.0071621,0.0059217,0.005362,0.0057945,0.0070791,0.0071574,0.0059504,0.0053489,0.0057632,0.0070924,0.0071746,0.0059612,0.0053684,0.0057782,0.0070671,0.0071951,0.0059564,0.0053629,0.0057489,0.0070621,0.0071585,0.0059583,0.0053451,0.005731,0.0070805,0.0071742,0.0059742,0.0053628,0.0057302,0.0070548,0.0072005,0.0059896,0.0053587,0.0057508,0.0070673,0.007166,0.0059838,0.0053625,0.0057045,0.0070458,0.0071772,0.006004,0.0053587,0.005701,0.0070354,0.007174,0.0059887,0.0053267,0.0056967,0.0070336,0.00717,0.0060331,0.0053556,0.0056929,0.0070249,0.0072038,0.0060433,0.0053484,0.0056946,0.0070202,0.0071977,0.0060453,0.0053568,0.0056815,0.0070238,0.0071676,0.0060672,0.0053747,0.0056785,0.0070019,0.0072016,0.0060761,0.0053515,0.0056673,0.0069966,0.0071775,0.0060679,0.0053691,0.0056518,0.0069932,0.0071846,0.0061129,0.0053622,0.0056427,0.0069807,0.0072089,0.0060922,0.0053448,0.005633,0.0069927,0.0071891,0.0061092,0.005358,0.0056396,0.0069907,0.0071979,0.0061031,0.0053578,0.0056296,0.006964,0.0072046,0.0061354,0.0053656,0.0056157,0.0069653,0.0072067,0.0061438,0.0053764,0.0056264,0.0069531,0.0072001,0.0061402,0.0053459,0.0056005,0.0069608,0.007197,0.0061341,0.0053652,0.0055899,0.0069324,0.0071941,0.0061509,0.0053655,0.0055971,0.0069557,0.0072086,0.0061698,0.0053787,0.0055919,0.0069596,0.0072026,0.0061805,0.0053812,0.0055633,0.0069394,0.0071813,0.0061954,0.0053753,0.005572,0.0069161,0.0072039,0.0062063,0.0054172,0.0055734,0.0069015,0.0071945,0.0062157,0.0054011,0.0055605,0.0069277,0.0072048,0.006217,0.0054121,0.0055547,0.006904,0.0071724,0.006221,0.005414,0.005538,0.006902,0.0072121,0.0062369,0.0054061,0.0055437,0.0069015,0.007197,0.0062143,0.0054056,0.0055235,0.0068906,0.0071917,0.0062476,0.0054064,0.0055165,0.0068957,0.0071987,0.0062503,0.0054109,0.0055178,0.006876,0.0071952,0.0063135,0.0054219,0.0054967,0.0068553,0.0071997,0.0062843,0.0054075,0.0055128,0.0068647,0.007201,0.0063287,0.0054293,0.0055008,0.006849,0.0071946,0.0063035,0.0054406,0.0054881,0.0068638,0.0071682,0.0062883,0.0054351,0.0054881,0.0068612,0.0071975,0.0063169,0.0054197,0.005466,0.0068595,0.0072191,0.0063075,0.0054437,0.0054796,0.0068325,0.0072016,0.0063485,0.0054219,0.0054847,0.0068397,0.0071819,0.0063456,0.0054206,0.0054802,0.0068203,0.0072013,0.0063598,0.0054378,0.0054754,0.0068368,0.0071994,0.0063788,0.0054372,0.0054661,0.0068253,0.0071992,0.0063645,0.0054589,0.0054525,0.0067971,0.007212,0.0063838,0.0054496,0.0054599,0.006785,0.0071908,0.0063894,0.0054482,0.0054488,0.0067851,0.0071887,0.0063638,0.0054599,0.0054388,0.0067765,0.0071828,0.0063991,0.0054655,0.0054362,0.0067844,0.0071794,0.0064002,0.0054688,0.005419,0.0067644,0.0071949,0.0064179,0.0054697,0.0054123,0.0067602,0.0071821,0.0064397,0.0054599,0.0054248,0.0067504,0.0071917,0.0064424,0.0054941,0.0054226,0.0067355,0.0071908,0.0064598,0.0054796,0.0054184,0.0067561,0.0071735,0.0064626,0.0054775,0.0054,0.0067323,0.0071827,0.0064456,0.005503,0.0054005,0.0067082,0.0071976,0.0064644,0.0054947,0.0053956,0.0067079,0.0071806,0.0064752,0.0055016,0.0053818,0.0067185,0.0071848,0.0064886,0.0054891,0.0053621,0.0067046,0.0071685,0.0065073,0.0055256,0.0053754,0.006723,0.0072001,0.0065167,0.0055413,0.0053824,0.0066914,0.007185,0.0065051,0.0055237,0.0053754,0.0066865,0.0071528,0.0065334,0.0055196,0.0053686,0.0066705,0.0071531,0.0065469,0.0055337,0.0053578,0.0066559,0.0071613,0.0065233,0.0055338,0.005356,0.006661,0.0071505,0.0065359,0.0055397,0.005334,0.0066468,0.0071608,0.0065422,0.0055546,0.0053293,0.0066454,0.0071419,0.006578,0.0055632,0.0053429,0.0066683,0.0071495,0.0065546,0.0055717,0.0053535,0.006637,0.0071541,0.0066005,0.005572,0.0053361,0.0065979,0.00716,0.0065823,0.0055623,0.0053192,0.0065898,0.0071481,0.0065731,0.0055697,0.0053199,0.006609,0.0071331,0.0066081,0.0055783,0.0053312,0.0065915,0.0071506,0.0065942,0.0055913,0.0053078,0.0065785,0.0071298,0.006628,0.0056017,0.0053141,0.006596,0.0071505,0.0066125,0.0056138,0.0052983,0.0065595,0.00713,0.006626,0.005616,0.0053127,0.0065882,0.0071536,0.0066577,0.0056132,0.0053255,0.0065636,0.0071363,0.0066558,0.0056224,0.0052886,0.0065535,0.007147,0.0066753,0.005601,0.0052873,0.0065337,0.0071192,0.0066515,0.0056237,0.005289,0.0065443,0.0071346,0.0066689,0.0037308:4
6.4467E-6,3.6367E-6,3.1267E-6,3.84E-6,-1.59E-6,4.92E-6,1.29E-6,3.75E-6,3.2433E-6,-3.74E-6,6.1E-6,6.1333E-7,3.6567E-6,5.3833E-6,-3.0833E-6,7.4467E-6,2.1E-6,4.03E-6,6.3433E-6,-1.9567E-6,5.95E-6,2.4E-6,2.6733E-6,4.1233E-6,-1.17E-6,6.52E-6,8.4667E-7,1.9833E-6,6.5567E-6,-6.3E-7,1.9201E-4,0.0067109,0.0045034,0.0037437,0.0052715,0.0024148,0.0055041,0.0047248,0.0039707,0.0047758,0.0027818,0.005255,0.0047402,0.0039956,0.0046463,0.0028352,0.0051684,0.0047082,0.0039886,0.0046082,0.0028283,0.0051323,0.0046861,0.0039674,0.0045787,0.0027983,0.0050863,0.0046392,0.0039438,0.0045602,0.002775,0.0050495,0.0046094,0.0039284,0.0045248,0.0027451,0.0050247,0.0045662,0.003909,0.0045111,0.0027223,0.0049914,0.0045309,0.0038857,0.0044906,0.0026969,0.0049568,0.0045042,0.0038642,0.0044732,0.0026819,0.0049254,0.00448,0.0038592,0.004446,0.0026583,0.0049147,0.0044489,0.0038471,0.0044509,0.0026447,0.0048734,0.0044204,0.0038295,0.0044342,0.0026229,0.0048705,0.0043954,0.0038218,0.004424,0.0026114,0.0048542,0.0043805,0.0038236,0.0044191,0.0025951,0.0048309,0.0043573,0.0038067,0.0044072,0.0025859,0.0048096,0.0043352,0.0038118,0.0043927,0.0025695,0.0047938,0.0043232,0.0038036,0.0043967,0.0025579,0.0047845,0.0043017,0.0038108,0.0043931,0.0025464,0.0047727,0.0042723,0.0038017,0.0043795,0.0025406,0.0047554,0.0042645,0.0037951,0.0043845,0.0025278,0.0047521,0.0042475,0.0038025,0.0043803,0.0025181,0.0047303,0.0042302,0.0038077,0.0043747,0.0025128,0.0047179,0.0042166,0.0038124,0.004373,0.0025049,0.0047041,0.0042025,0.0038114,0.0043757,0.002496,0.0046951,0.0041921,0.0038091,0.0043746,0.002493,0.0046835,0.0041879,0.0038111,0.0043705,0.0024889,0.0046691,0.0041635,0.0038117,0.0043766,0.0024804,0.0046651,0.0041417,0.0038185,0.0043699,0.0024708,0.0046504,0.0041379,0.0038203,0.0043783,0.0024723,0.0046449,0.0041242,0.0038238,0.0043642,0.0024679,0.0046425,0.0041175,0.0038237,0.0043858,0.0024655,0.0046357,0.0041113,0.0038268,0.0043757,0.0024598,0.0046343,0.0041065,0.0038301,0.0043825,0.002461,0.0046234,0.0041007,0.0038486,0.0043817,0.0024573,0.0046213,0.0040884,0.0038557,0.0043903,0.0024575,0.0046121,0.0040779,0.003864,0.0043827,0.0024542,0.0046096,0.0040671,0.0038671,0.0043969,0.0024475,0.0046027,0.0040656,0.0038698,0.0043921,0.0024501,0.0045963,0.004053,0.003876,0.0044018,0.0024475,0.0045973,0.0040567,0.0038851,0.004407,0.0024445,0.0045865,0.0040355,0.0038849,0.0044125,0.0024443,0.0045721,0.0040332,0.0038946,0.004408,0.0024395,0.004574,0.0040308,0.0039054,0.0044085,0.0024373,0.0045715,0.0040112,0.0039044,0.0044141,0.0024333,0.0045644,0.0040175,0.0039034,0.004424,0.0024389,0.0045553,0.0040036,0.0039193,0.0044263,0.0024374,0.0045564,0.0039932,0.0039309,0.0044351,0.0024387,0.0045582,0.0039949,0.0039335,0.0044305,0.0024303,0.0045478,0.0039816,0.0039386,0.004434,0.0024312,0.0045366,0.0039698,0.0039463,0.0044379,0.0024256,0.0045359,0.0039737,0.0039505,0.0044423,0.0024302,0.0045338,0.0039621,0.0039694,0.0044461,0.0024274,0.0045316,0.0039532,0.0039681,0.0044545,0.0024289,0.0045158,0.0039475,0.003975,0.004455,0.0024277,0.0040191:4
5.6533E-6,1.7867E-6,4.7133E-6,6.9E-7,6.99E-6,5.61E-6,2.3333E-8,5.15E-6,2.3033E-6,6.49E-6,7.3533E-6,2.59E-6,3.7267E-6,1.83E-6,8.29E-6,5.0233E-6,1.5467E-6,5.26E-6,-7.4667E-7,6.2933E-6,2.7033E-6,3.2533E-6,5.4033E-6,1.2E-7,7.7567E-6,5.65E-6,2.3767E-6,5.9333E-6,1.23E-6,0.0014955,0.0075539,0.0070253,0.0031348,0.0064479,0.003807,0.0067805,0.006704,0.0037656,0.00575,0.0041708,0.0065958,0.0066075,0.0038584,0.005562,0.0042191,0.0065021,0.0065508,0.0038636,0.0054939,0.0041952,0.0064649,0.0065147,0.0038386,0.0054699,0.0041514,0.0064274,0.0064745,0.0038096,0.0054218,0.0040992,0.0063967,0.0064242,0.0037725,0.0053992,0.004065,0.0063448,0.006394,0.0037609,0.0053615,0.0040254,0.0063143,0.0063496,0.003729,0.0053415,0.0039898,0.0062786,0.0063199,0.0037061,0.0053037,0.0039567,0.0062609,0.0062888,0.0036755,0.0052784,0.0039197,0.006232,0.0062629,0.0036625,0.00526,0.0038903,0.0062203,0.0062264,0.0036456,0.0052289,0.0038631,0.0061782,0.0062018,0.003632,0.005207,0.0038404,0.0061718,0.006187,0.0036203,0.0052034,0.0038198,0.0061437,0.0061779,0.0036078,0.0051793,0.0037948,0.0061448,0.0061532,0.0036049,0.0051726,0.0037778,0.0061194,0.0061358,0.0035996,0.0051593,0.003761,0.0061163,0.0061127,0.0035909,0.0051607,0.0037439,0.0060998,0.0061076,0.003596,0.0051408,0.0037374,0.006094,0.0060875,0.0035834,0.0051273,0.0037163,0.0060862,0.0060853,0.0035847,0.005118,0.0036983,0.0060919,0.0060711,0.0035855,0.0051289,0.0036888,0.0060812,0.0060664,0.0035837,0.0051106,0.0036796,0.0060811,0.0060575,0.003579,0.0051192,0.0036673,0.0060756,0.006044,0.0035898,0.0051027,0.0036546,0.0060659,0.0060343,0.0035855,0.005101,0.0036384,0.0060573,0.006028,0.0035886,0.0050888,0.0036255,0.0060642,0.0060159,0.003584,0.0050953,0.0036157,0.0060453,0.0060172,0.0035897,0.0050757,0.003607,0.0060599,0.0059997,0.0035912,0.0050871,0.0036008,0.0060467,0.0060085,0.0036034,0.0050806,0.0035937,0.0060661,0.0060078,0.0036072,0.0050872,0.0035829,0.0060522,0.0060091,0.003612,0.0050827,0.0035764,0.0060525,0.0060028,0.0036023,0.0050778,0.003574,0.0060597,0.0059943,0.0036155,0.0050822,0.0035611,0.0060609,0.0059852,0.003626,0.0050857,0.0035572,0.0060527,0.0059876,0.0036299,0.0050782,0.0035544,0.006058,0.0059683,0.0036298,0.0050806,0.0035443,0.0060486,0.005973,0.0036359,0.0050667,0.0035337,0.0060554,0.0059646,0.003635,0.0050642,0.0035333,0.0060394,0.0059645,0.0036456,0.0050521,0.0035218,0.0060517,0.0059499,0.0036534,0.0050716,0.003523,0.0060364,0.0059568,0.0036562,0.0050694,0.0035096,0.0060368,0.0059367,0.0036563,0.0050674,0.0035038,0.00604,0.0059416,0.0036643,0.0050663,0.0035018,0.0060467,0.0059279,0.003676,0.0050637,0.0034958,0.0060394,0.0059369,0.0036753,0.0050584,0.0034917,0.0060478,0.0059257,0.0036867,0.0050749,0.0034831,0.0060488,0.0059315,0.0037051,0.0050625,0.0034986,0.0060653,0.0059356,0.0037107,0.0050763,0.0034853,0.0060594,0.0059353,0.0037125,0.0050737,0.0034738,0.0060561,0.0059286,0.0037067,0.0050746,0.0034742,0.006055,0.0059193,0.0037298,0.0050689,0.0034685,0.0060608,0.005913,0.0037303,0.0050778,0.0034608,0.0060545,0.0059144,0.0037334,0.005086,0.0034608,0.0060705,0.0059116,0.0037429,0.0050879,0.0034571,0.0060688,0.005913,0.0037614,0.0050845,0.0034538,0.0060734,0.0059046,0.0037557,0.0050888,0.0034491,0.0060682,0.005905,0.0037661,0.0050823,0.0034402,0.0060695,0.0058985,0.0037631,0.0050812,0.0034395,0.006055,0.0058862,0.0037719,0.005074,0.0034231,0.0060671,0.0058779,0.0037774,0.0050902,0.0034224,0.0060559,0.0058789,0.003785,0.0050791,0.0034216,0.0060661,0.0058735,0.0037938,0.0050848,0.0034188,0.0060488,0.0058648,0.0038046,0.0050803,0.0034061,0.0060583,0.0058667,0.0037971,0.0050853,0.0034068,0.0060414,0.0058565,0.0038136,0.0050815,0.0034003,0.0060616,0.005858,0.003818,0.0050881,0.0034012,0.0060565,0.0058681,0.0038284,0.0050801,0.0033982,0.0060662,0.0058494,0.0038364,0.0050953,0.0033929,0.0060691,0.0020124:4
1.19E-6,4.4233E-6,4.53E-6,1.38E-6,3.1133E-6,-1.1567E-6,4.06E-6,5.01E-6,2.22E-6,3.97E-6,1.5633E-6,3.3867E-6,2.5E-6,1.3067E-6,2.7067E-6,1.0233E-6,6.31E-6,2.91E-6,4.2E-6,4.6567E-6,2.2133E-6,6.35E-6,4.11E-6,0.0063271,0.0024883,0.0062777,0.0030034,0.0062688,0.0060107,0.0033762,0.00524,0.0035792,0.0059735,0.0059182,0.0035421,0.0049905,0.003676,0.0058959,0.0058574,0.0035575,0.0049323,0.0036694,0.0058396,0.0058301,0.0035303,0.0048849,0.0036397,0.005806,0.0057784,0.0034954,0.0048598,0.0036014,0.0057609,0.0057442,0.0034688,0.0048167,0.0035672,0.0057343,0.0057043,0.0034398,0.0047914,0.0035308,0.005683,0.0056725,0.0034151,0.0047665,0.0035114,0.0056719,0.0056471,0.0033914,0.0047549,0.0034812,0.0056353,0.00562,0.0033711,0.0047242,0.0034522,0.0056156,0.005586,0.0033438,0.004708,0.0034263,0.0055791,0.0055639,0.0033288,0.0046706,0.0033999,0.0055539,0.0055291,0.0033141,0.0046764,0.003378,0.0055445,0.0055222,0.0033034,0.0046549,0.003362,0.0055314,0.0055002,0.0032838,0.0046408,0.0033451,0.0054994,0.0054793,0.003278,0.0046255,0.0033315,0.0055051,0.0054722,0.0032681,0.0046136,0.003319,0.0054831,0.0054671,0.0032594,0.004598,0.0033078,0.0054728,0.0054276,0.0032499,0.0045879,0.0032867,0.0054486,0.0054218,0.0032385,0.0045886,0.0032812,0.0054468,0.0054162,0.0032338,0.0045703,0.0032661,0.005435,0.0054101,0.0032283,0.0045635,0.0032562,0.0054389,0.0053941,0.0032283,0.0045593,0.0032479,0.0054194,0.0053931,0.0032256,0.0045501,0.003247,0.0054229,0.0053846,0.0032182,0.0045582,0.0032308,0.0054126,0.0053838,0.0032167,0.00453,0.0032206,0.0054182,0.0053508,0.003214,0.0045379,0.0032234,0.0054017,0.0053618,0.003216,0.0045345,0.0032207,0.0054017,0.0053592,0.0032111,0.0045267,0.0032127,0.0053943,0.0053593,0.0032165,0.0045311,0.0032038,0.0054054,0.0053534,0.0032138,0.0045343,0.0032026,0.0053888,0.0053384,0.0032116,0.0045166,0.0031941,0.005395,0.0053356,0.0032137,0.004522,0.0031852,0.0053889,0.0053362,0.0032142,0.0045113,0.0031836,0.0053965,0.0053278,0.0032065,0.0045252,0.0031804,0.0053858,0.0053275,0.0032107,0.0045204,0.0031776,0.0053818,0.0053215,0.0032097,0.0045161,0.0031685,0.00538,0.005318,0.0032116,0.0045077,0.0031706,0.0053902,0.0053179,0.0032167,0.0045138,0.0031672,0.0053792,0.0053227,0.0032258,0.0045154,0.0031628,0.0053832,0.0053101,0.0032117,0.0045137,0.0031586,0.0053751,0.005312,0.0032177,0.0045071,0.0031523,0.0053805,0.0053045,0.0032233,0.0045172,0.0031551,0.0053775,0.0053054,0.0032185,0.0045067,0.0031545,0.0053833,0.0053033,0.0032284,0.0045085,0.0031428,0.0053724,0.0053055,0.0032282,0.0044997,0.0031437,0.0053807,0.0052951,0.0032297,0.0045085,0.003137,0.0053761,0.0053019,0.0032268,0.0045017,0.0031381,0.0053849,0.0052837,0.0032305,0.0045023,0.003139,0.0053633,0.0052898,0.0032305,0.0044988,0.0031314,0.0053701,0.0052936,0.0032285,0.0045031,0.0031279,0.0053802,0.0052933,0.0032369,0.0045031,0.0031328,0.0053719,0.0052868,0.003238,0.0045036,0.0031132,0.0053681,0.0052902,0.0032416,0.004499,0.0031222,0.0053659,0.0052786,0.0032441,0.0044909,0.0031144,0.0053705,0.0052767,0.0032489,0.004498,0.0031254,0.0053752,0.0052802,0.0032505,0.0044999,0.0031136,0.0053637,0.0052811,0.0032503,0.0044963,0.0031136,0.0053756,0.0052817,0.0032517,0.0044942,0.0031179,0.0053751,0.0052824,0.0032557,0.0044874,0.0031085,0.0053732,0.0052531,0.0032577,0.0044938,0.0030998,0.0053678,0.0052764,0.0032578,0.0044948,0.0026675:4
-0.019417,0.023696,-0.016788,0.011433,0.010391,-0.023576,0.019859,-0.014513,0.015891,0.007183,-0.021801,0.029493,-0.015881,0.0080206,0.01745,-0.020292,0.031091,-0.015496,0.015265,0.0044773,-0.015767,0.025693,-0.011173,0.015002,0.0064536,-0.02227,0.02427,-0.012895,0.013486,0.019359,-0.021327,0.031891,12.842,81.342,80.403,62.337,62.439,64.795,80.233,80.087,63.124,61.351,65.061,79.873,79.879,63.21,61.085,64.909,79.506,79.712,63.19,60.856,64.647,79.343,79.587,63.182,60.787,64.432,79.14,79.537,63.202,60.606,64.173,78.959,79.405,63.148,60.511,63.947,78.783,79.374,63.233,60.436,63.781,78.691,79.356,63.271,60.406,63.66,78.559,79.381,63.386,60.364,63.505,78.522,79.337,63.412,60.318,63.348,78.338,79.308,63.467,60.171,63.133,78.19,79.274,63.496,60.172,63.001,78.003,79.274,63.567,60.107,62.797,77.893,79.178,63.581,60.019,62.615,77.82,79.218,63.7,60.037,62.505,77.705,79.172,63.819,60.114,62.406,77.652,79.245,63.954,60.097,62.331,77.592,79.291,64.082,60.03,62.205,77.561,79.321,64.207,60.14,62.106,77.527,79.365,64.336,60.056,62.014,77.454,79.382,64.445,60.064,61.883,77.268,79.33,64.592,60.171,61.792,77.245,79.384,64.714,60.094,61.671,77.183,79.368,64.768,60.111,61.58,77.099,79.409,64.894,60.122,61.46,76.977,79.376,65.002,60.147,61.328,76.857,79.432,65.166,60.066,61.197,76.806,79.391,65.272,60.166,61.126,76.714,79.429,65.448,60.204,61.029,76.676,79.4,65.589,60.278,60.932,76.625,79.496,65.737,60.323,60.825,76.553,79.497,65.874,60.239,60.708,76.363,79.435,65.956,60.226,60.564,76.26,79.422,66.103,60.286,60.452,76.197,79.303,66.203,60.24,60.289,76.018,79.305,66.329,60.291,60.168,75.928,79.348,66.484,60.381,60.09,75.828,79.36,66.625,60.396,60.018,75.832,79.385,66.824,60.453,59.905,75.783,79.376,66.954,60.577,59.845,75.614,79.358,67.159,60.662,59.768,75.583,79.387,67.28,60.673,59.66,75.494,79.409,67.423,60.618,59.535,75.412,79.376,67.606,60.667,59.437,75.172,79.27,67.702,60.73,59.31,75.078,79.287,67.817,60.796,59.236,74.952,79.284,68.035,60.758,59.123,74.925,79.281,68.1,60.875,59.059,74.861,79.311,68.264,60.993,58.992,74.73,79.263,68.467,61.059,58.913,74.623,79.242,68.57,61.116,58.851,74.655,79.251,68.759,61.232,58.731,74.512,79.224,68.914,61.231,58.657,74.418,79.131,69.032,61.298,58.565,74.256,79.113,69.228,61.328,58.435,74.209,79.094,69.297,61.398,58.366,74.073,79.038,69.453,61.444,58.323,73.948,79.028,69.622,61.563,58.252,73.967,79.131,69.798,61.643,58.254,73.904,79.097,69.98,61.736,58.146,73.698,79.028,70.064,61.743,58.019,73.513,78.844,70.066,61.793,57.885,73.38,78.807,70.228,61.788,57.76,73.251,78.739,70.32,61.903,57.726,73.144,78.783,70.536,61.95,57.704,73.141,78.72,70.626,62.138,57.626,73.029,78.641,70.825,62.141,57.52,72.948,78.61,70.95,62.357,57.48,72.802,78.581,71.114,62.377,57.444,72.694,78.557,71.322,62.452,57.384,72.62,78.439,71.363,62.45,57.282,72.432,78.356,71.513,62.553,57.191,72.321,78.249,71.599,62.628,57.109,72.171,78.214,71.717,62.697,57.074,72.129,78.174,71.918,62.837,57.061,72.01,78.236,72.031,62.979,57.063,71.992,78.178,72.271,63.033,56.978,71.867,78.167,72.329,63.18,56.885,71.771,78.059,72.451,63.286,56.839,71.691,78.037,72.604,63.326,56.756,71.477,77.859,72.662,63.407,56.717,71.378,77.774,72.866,63.453,56.625,71.204,77.75,72.974,63.564,56.573,71.156,77.651,73.016,63.602,56.534,71.038,77.556,0.0:4
0.0051452,0.02086,-0.021426,0.025308,-0.0087991,0.009435,0.012297,-0.022564,0.027031,-0.0076207,0.0089568,0.0099821,-0.024058,0.024735,-0.012706,0.0076271,0.022497,-0.021501,0.020866,-0.0085695,0.0084894,0.010644,-0.014829,0.028182,-0.010671,0.011005,0.018898,-0.01663,0.026716,-0.011681,0.01082,0.0074017,41.375,70.235,64.079,82.137,78.963,58.241,64.152,67.441,81.193,78.003,59.834,62.596,68.053,80.796,77.739,60.189,62.085,68.08,80.6,77.559,60.232,61.837,67.892,80.402,77.504,60.211,61.614,67.697,80.171,77.336,60.094,61.441,67.445,80.024,77.311,60.061,61.299,67.279,79.871,77.241,60.027,61.195,67.11,79.797,77.272,60.033,61.137,66.995,79.76,77.282,60.055,61.044,66.792,79.633,77.297,60.073,60.982,66.715,79.562,77.271,60.103,60.884,66.565,79.498,77.282,60.104,60.787,66.439,79.378,77.335,60.116,60.768,66.302,79.369,77.366,60.176,60.775,66.224,79.386,77.346,60.238,60.651,66.07,79.245,77.479,60.241,60.643,66.025,79.186,77.477,60.329,60.526,65.832,79.191,77.544,60.404,60.593,65.784,79.204,77.58,60.489,60.57,65.674,79.11,77.597,60.546,60.435,65.553,79.148,77.66,60.605,60.442,65.433,79.021,77.748,60.668,60.269,65.361,78.958,77.694,60.728,60.301,65.238,78.9,77.799,60.798,60.33,65.187,78.832,77.77,60.844,60.291,65.055,78.721,77.862,60.877,60.162,64.91,78.703,77.778,60.925,60.175,64.804,78.732,77.898,60.988,60.14,64.78,78.704,77.846,61.055,60.095,64.653,78.681,77.951,61.099,60.056,64.569,78.543,77.962,61.205,60.138,64.499,78.584,78.067,61.355,60.056,64.44,78.59,78.14,61.412,60.15,64.416,78.467,78.17,61.487,60.021,64.327,78.503,78.149,61.508,60.055,64.248,78.451,78.248,61.642,60.069,64.2,78.541,78.288,61.722,60.049,64.085,78.391,78.283,61.759,59.906,63.914,78.322,78.398,61.843,60.068,63.921,78.385,78.442,61.961,59.982,63.795,78.303,78.425,62.007,59.935,63.716,78.203,78.49,62.082,60.009,63.684,78.206,78.458,62.184,59.993,63.514,78.12,78.548,62.232,59.858,63.445,78.116,78.514,62.308,60.021,63.399,78.061,78.691,62.461,59.882,63.299,78.052,78.601,62.535,59.889,63.23,77.982,78.708,62.64,59.883,63.156,78.022,78.721,62.72,59.904,63.087,77.841,78.798,62.753,59.799,63.003,77.832,78.739,62.868,59.923,62.907,77.762,78.814,62.948,59.801,62.788,77.721,78.752,62.992,59.837,62.713,77.692,78.859,63.108,59.852,62.627,77.628,78.851,63.17,59.761,62.566,77.56,78.802,63.259,59.827,62.501,77.584,78.914,63.404,59.911,62.461,77.561,78.97,63.486,59.933,62.424,77.552,78.968,63.596,59.897,62.376,77.545,79.027,63.7,59.926,62.313,77.497,79.115,63.794,59.954,62.23,77.382,79.076,63.839,59.879,62.159,77.364,79.058,63.907,59.95,62.038,77.329,79.084,63.961,59.869,61.979,77.303,79.09,64.105,59.919,61.845,77.102,79.199,64.186,59.871,61.799,77.202,79.062,64.248,59.935,61.709,77.04,79.099,64.336,59.89,61.617,77.081,79.075,64.396,59.937,61.576,77.011,79.142,64.546,59.99,61.581,76.987,79.139,64.636,59.981,61.518,76.928,79.275,64.731,60.039,61.495,76.924,79.325,64.833,60.045,61.421,76.857,79.325,64.888,60.001,61.323,76.891,79.298,64.985,60.051,61.241,76.79,79.34,65.043,60.095,61.21,76.713,79.269,65.033,60.049,61.125,76.674,79.314,65.165,60.107,61.097,76.694,79.256,65.248,60.068,60.997,76.68,79.223,65.281,60.033,60.893,76.485,79.218,65.345,60.063,60.815,76.421,79.282,65.44,60.0,60.727,76.404,79.224,65.494,60.055,60.665,76.296,79.241,65.627,60.073,60.607,0.0:4
-0.0030572,0.0027149,-1.7699E-4,1.8272E-4,0.0023906,-0.0025341,0.0027479,3.6332E-4,-4.1826E-4,0.0022794,-0.0038432,0.002767,-0.0022091,4.6967E-4,0.002545,-0.0026134,-2.3274E-4,-6.4366E-4,-9.7884E-4,0.0024454,-0.0043259,0.0084289,7.3956,12.57,15.754,14.258,18.066,27.069,26.865,21.368,20.939,20.123,25.606,26.422,21.809,19.887,20.517,25.118,26.184,21.897,19.477,20.578,24.892,26.033,21.882,19.294,20.565,24.76,25.939,21.85,19.196,20.532,24.679,25.868,21.835,19.141,20.492,24.623,25.836,21.823,19.116,20.48,24.597,25.814,21.818,19.106,20.473,24.58,25.82,21.822,19.097,20.458,24.562,25.821,21.835,19.095,20.457,24.537,25.842,21.831,19.102,20.448,24.523,25.847,21.839,19.101,20.428,24.515,25.851,21.842,19.104,20.413,24.507,25.851,21.855,19.112,20.397,24.522,25.856,21.871,19.117,20.405,24.542,25.857,21.884,19.118,20.386,24.53,25.82,21.903,19.11,20.378,24.517,25.824,21.912,19.114,20.379,24.521,25.836,21.926,19.12,20.384,24.505,25.83,21.929,19.108,20.378,24.491,25.853,21.945,19.112,20.377,24.48,25.874,21.957,19.119,20.371,24.471,25.894,21.958,19.128,20.369,24.47,25.894,21.963,19.129,20.354,24.465,25.884,21.965,19.131,20.343,24.462,25.89,21.975,19.142,20.336,24.467,25.899,21.996,19.142,20.33,24.455,25.888,22.002,19.141,20.319,24.449,25.879,22.007,19.139,20.318,24.437,25.879,22.011,19.137,20.309,24.449,25.876,22.02,19.138,20.301,24.443,25.879,22.028,19.14,20.3,24.431,25.888,22.038,19.14,20.292,24.415,25.891,22.051,19.141,20.292,24.419,25.896,22.063,19.143,20.283,24.391,25.898,22.064,19.141,20.278,24.378,25.908,22.059,19.142,20.26,24.374,25.895,22.067,19.138,20.233,24.352,25.883,22.063,19.138,20.211,24.354,25.873,22.07,19.136,20.193,24.348,25.851,22.074,19.131,20.18,24.357,25.843,22.089,19.131,20.182,24.353,25.837,22.112,19.131,20.179,24.333,25.83,22.121,19.126,20.189,24.333,25.839,22.143,19.129,20.2,24.297,25.857,22.142,19.123,20.195,24.286,25.875,22.138,19.135,20.189,24.273,25.881,22.142,19.132,20.171,24.27,25.886,22.129,19.137,20.146,24.265,25.881,22.129,19.136,20.128,24.269,25.869,22.148,19.147,20.124,24.283,25.861,22.164,19.156,20.112,24.292,25.846,22.186,19.15,20.107,24.285,25.823,22.205,19.149,20.113,24.284,25.83,22.21,19.136,20.108,24.251,25.833,22.215,19.138,20.114,24.246,25.843,22.215,19.136,20.115,24.219,25.863,22.222,19.137,20.111,24.206,25.882,22.224,19.149,20.105,24.198,25.881,22.226,19.144,20.091,24.192,25.882,22.235,19.159,20.081,24.196,25.884,22.235,19.162,20.068,24.197,25.875,22.252,19.171,20.069,24.216,25.871,22.25,19.159,20.052,24.21,25.845,22.256,19.161,20.047,24.22,25.859,22.277,19.169,20.043,24.211,25.849,22.282,19.164,20.042,24.198,25.856,22.297,19.169,20.043,24.194,25.837,22.295,19.154,20.04,24.182,25.848,22.308,19.153,20.046,24.18,25.853,22.308,19.158,20.051,24.16,25.869,22.308,19.169,20.051,24.168,25.865,22.305,19.165,20.043,24.157,25.861,22.302,19.162,20.04,24.154,25.861,22.289,19.154,20.017,24.14,25.857,22.288,19.157,20.014,24.129,25.858,22.287,19.162,20.011,24.134,25.829,22.284,19.152,19.985,24.116,25.839,22.286,19.161,19.982,24.135,25.814,22.3,19.153,19.976,24.134,25.798,22.287,19.144,19.97,24.13,25.809,22.32,19.159,19.983,24.136,25.817,22.336,19.152,19.993,24.127,25.808,22.334,19.148,19.989,24.105,25.819,22.337,19.137,19.988,24.097,11.036:4
-0.0012024,0.0047024,0.0017826,0.0022213,0.0075637,2.0165E-4,0.005354,0.0043023,0.0010871,0.0043228,-0.00158,0.0022633,0.003651,0.0017336,0.0052951,-0.0015316,0.0052815,0.003671,5.7232E-4,0.005698,4.468E-4,0.0047911,0.0028083,5.792E-4,0.0053832,2.2591E-4,0.0059433,0.0021462,9.6668E-4,17.129,3.761,16.16,11.998,10.559,15.113,24.286,20.517,26.856,25.764,18.838,20.864,21.958,26.069,24.978,19.489,19.879,22.297,25.744,24.64,19.629,19.498,22.33,25.544,24.452,19.606,19.332,22.326,25.473,24.38,19.583,19.284,22.337,25.45,24.321,19.541,19.261,22.328,25.409,24.276,19.511,19.238,22.283,25.368,24.231,19.473,19.224,22.298,25.388,24.215,19.468,19.25,22.326,25.405,24.195,19.465,19.237,22.303,25.369,24.153,19.435,19.241,22.324,25.402,24.14,19.424,19.256,22.354,25.427,24.125,19.428,19.267,22.308,25.389,24.106,19.338,19.232,22.292,25.346,24.071,19.316,19.227,22.332,25.352,24.058,19.301,19.241,22.351,25.338,24.06,19.29,19.229,22.344,25.308,24.048,19.276,19.249,22.383,25.336,24.044,19.263,19.275,22.398,25.346,24.04,19.254,19.278,22.39,25.356,24.01,19.233,19.274,22.445,25.398,23.983,19.297,19.317,22.476,25.442,23.965,19.291,19.336,22.414,25.404,23.933,19.201,19.294,22.41,25.395,23.91,19.2,19.307,22.455,25.414,23.895,19.193,19.315,22.485,25.399,23.884,19.189,19.313,22.489,25.376,23.875,19.176,19.324,22.517,25.379,23.864,19.155,19.339,22.542,25.39,23.858,19.156,19.352,22.537,25.373,23.836,19.13,19.353,22.543,25.4,23.824,19.119,19.385,22.585,25.43,23.808,19.111,19.392,22.649,25.473,23.782,19.181,19.403,22.651,25.452,23.753,19.165,19.405,22.683,25.465,23.736,19.152,19.423,22.702,25.463,23.718,19.142,19.412,22.689,25.434,23.693,19.122,19.422,22.713,25.458,23.681,19.121,19.456,22.751,25.476,23.68,19.119,19.464,22.756,25.486,23.658,19.103,19.475,22.76,25.473,23.635,19.095,19.479,22.793,25.502,23.625,19.089,19.5,22.811,25.508,23.618,19.09,19.483,22.793,25.487,23.593,19.068,19.495,22.831,25.505,23.59,19.072,19.524,22.863,25.506,23.58,19.064,19.528,22.845,25.499,23.556,19.049,19.522,22.854,25.503,23.549,19.05,19.547,22.892,25.536,23.531,19.047,19.556,22.894,25.529,23.514,19.037,19.543,22.891,25.532,23.504,19.04,19.568,22.937,25.552,23.492,19.037,19.579,22.962,25.545,23.483,19.033,19.583,22.963,25.504,23.471,19.009,19.586,22.987,25.518,23.454,18.998,19.606,23.005,25.531,23.447,18.995,19.622,23.001,25.514,23.43,18.973,19.621,23.011,25.531,23.406,18.966,19.654,23.035,25.555,23.375,18.954,19.664,23.031,25.567,23.346,18.94,19.655,23.023,25.549,23.306,18.94,19.663,23.056,25.571,23.28,18.93,19.68,23.084,25.57,23.27,18.93,19.677,23.084,25.561,23.253,18.92,19.686,23.117,25.559,23.231,18.907,19.702,23.169,25.554,23.22,18.899,19.711,23.168,25.537,23.205,18.88,19.705,23.152,25.518,23.179,18.865,19.725,23.187,25.531,23.169,18.856,19.75,23.187,25.531,23.149,18.849,19.761,23.195,25.556,23.132,18.852,19.779,23.216,25.578,23.102,18.84,19.794,23.249,25.587,23.086,18.845,19.798,23.252,25.581,23.074,18.835,19.793,23.275,25.568,23.053,18.824,19.816,23.312,25.58,23.048,18.832,19.836,23.319,25.567,23.025,18.81,19.831,23.307,25.559,23.005,18.8,19.86,23.34,25.586,22.969,18.797,19.88,23.359,25.608,22.952,18.793,19.88,23.349,25.606,4.8682:4
0.0030804,0.0035972,6.7747E-4,0.0050171,0.0011622,0.0021595,0.0036868,-4.2789E-4,0.0041418,-0.0014404,0.0043571,0.0033375,0.0018589,0.004393,0.0021023,0.0023111,0.0049122,4.9154E-4,0.0041072,1.4268E-4,0.0033377,0.0033862,-0.0017667,0.0060647,-1.072E-4,0.0035164,0.0036985,5.7457E-4,15.027,5.4073,15.426,15.046,24.726,16.454,24.588,25.265,25.298,22.187,18.234,22.945,25.403,25.275,21.399,18.621,22.35,25.332,25.185,21.078,18.712,22.121,25.272,25.123,20.935,18.705,22.002,25.186,25.064,20.859,18.685,21.941,25.121,25.041,20.807,18.656,21.886,25.08,25.028,20.772,18.659,21.874,25.078,25.014,20.75,18.661,21.842,25.05,24.999,20.736,18.64,21.799,25.066,24.983,20.738,18.653,21.808,25.101,24.981,20.75,18.669,21.812,25.124,24.974,20.77,18.652,21.799,25.112,24.951,20.777,18.633,21.788,25.093,24.949,20.777,18.629,21.81,25.082,24.966,20.796,18.624,21.811,25.045,24.962,20.79,18.609,21.821,25.036,24.995,20.788,18.624,21.834,25.025,25.019,20.784,18.634,21.829,25.022,25.035,20.784,18.633,21.803,25.018,25.03,20.775,18.635,21.793,25.044,25.028,20.776,18.648,21.777,25.051,25.018,20.784,18.642,21.739,25.05,24.999,20.782,18.629,21.737,25.076,24.992,20.801,18.635,21.755,25.099,24.983,20.814,18.629,21.753,25.06,24.978,20.822,18.614,21.752,25.038,24.99,20.825,18.611,21.775,25.045,25.008,20.833,18.62,21.779,25.015,25.025,20.833,18.604,21.755,24.991,25.029,20.825,18.611,21.759,25.0,25.038,20.831,18.637,21.786,25.045,25.076,20.848,18.65,21.777,25.043,25.067,20.847,18.646,21.757,25.045,25.061,20.846,18.647,21.77,25.069,25.064,20.854,18.648,21.768,25.051,25.052,20.854,18.628,21.746,25.035,25.063,20.858,18.63,21.758,25.045,25.068,20.86,18.637,21.758,25.032,25.069,20.868,18.63,21.736,25.023,25.062,20.862,18.631,21.726,25.027,25.058,20.858,18.632,21.734,25.035,25.059,20.875,18.628,21.711,25.027,25.054,20.873,18.615,21.707,25.024,25.056,20.877,18.615,21.732,25.031,25.067,20.881,18.632,22.196,25.691,25.836,21.743,19.424,22.642,26.056,26.151,21.777,19.42,22.638,26.069,26.153,21.768,19.437,22.635,26.089,26.162,21.791,19.425,22.603,26.07,26.145,21.783,19.423,22.608,26.096,26.148,21.793,19.435,22.625,26.112,26.149,21.814,19.43,22.63,26.096,26.146,21.826,19.415,22.623,26.059,26.155,21.854,19.442,22.695,26.182,26.2,21.789,19.436,22.673,25.892,26.293,22.256,19.487,22.649,26.08,26.382,21.996,19.644,22.972,26.579,26.741,22.265,19.838,23.085,26.636,26.802,22.319,19.877,23.082,26.644,26.759,22.308,19.854,23.051,26.647,26.749,22.321,19.863,23.076,26.681,26.751,22.342,19.865,23.079,26.659,26.749,22.348,19.842,23.072,26.638,26.759,22.348,19.844,23.091,26.633,26.759,22.338,19.84,23.074,26.595,26.768,22.336,19.837,23.065,26.564,26.742,22.284,19.782,23.018,26.587,26.801,22.351,19.875,23.102,26.659,26.868,22.41,19.913,23.105,26.689,26.884,22.445,19.931,23.135,26.74,26.949,22.494,20.003,23.237,26.876,27.043,22.572,20.034,23.252,26.851,26.995,22.521,19.974,23.174,26.751,26.928,22.487,19.934,23.147,26.724,26.932,22.469,19.943,23.135,26.673,26.862,22.425,19.859,23.039,26.572,26.797,22.367,19.818,23.003,26.548,26.77,22.339,19.801,22.97,26.529,26.743,22.322,19.78,22.931,26.493,26.721,22.32,19.771,22.905,26.483,26.719,22.325,19.772,22.921,26.511,26.736,22.343,19.801,22.967,26.626,26.925,22.555,20.012,23.252,26.949,27.31,22.967,20.35,23.669,27.456,27.684,23.126,20.466,23.703,27.394,27.636,23.11,3.3654:4
1.66E-6,5.0667E-7,4.9667E-7,1.7133E-6,1.1833E-6,6.4E-7,1.8867E-6,-1.9333E-7,1.9933E-6,7.8667E-7,9.9667E-7,1.2867E-6,-8.4E-7,2.4967E-6,1.2667E-6,4.5E-7,1.41E-6,-8.3E-7,1.5033E-6,4.3333E-7,0.0029099,0.0079456,0.00556,0.0065685,0.0065127,0.0071198,0.0067294,0.0054104,0.0057478,0.0064785,0.0074912,0.0076432,0.0061378,0.0060595,0.0069418,0.0080373,0.0076648,0.006192,0.0060458,0.0069375,0.0080373,0.0076425,0.0061905,0.0060254,0.0069237,0.0080117,0.0076683,0.0062399,0.0059833,0.0068987,0.0080087,0.0077122,0.0062319,0.0059734,0.006845,0.0079922,0.0076943,0.006242,0.0059619,0.0068092,0.0079995,0.0076926,0.0062481,0.0059426,0.0067797,0.0079764,0.0077025,0.0062615,0.0059163,0.0067571,0.0079728,0.0076847,0.0062821,0.0059189,0.0067272,0.0079449,0.0077047,0.0062934,0.0058945,0.0067004,0.0079472,0.0077017,0.0063379,0.0059011,0.0066858,0.0079439,0.0077292,0.0063457,0.0058922,0.0066253,0.0079381,0.0077499,0.0063797,0.0058993,0.0066173,0.0079397,0.0077483,0.0063848,0.0058601,0.0065926,0.0079153,0.0077564,0.0063837,0.0058764,0.0065499,0.0078989,0.0077848,0.0063932,0.0058706,0.0065046,0.0079043,0.0077736,0.0064361,0.0058841,0.0065147,0.007861,0.0077883,0.0064538,0.0058543,0.0064966,0.0078537,0.0077766,0.0064744,0.0058366,0.0064688,0.0078416,0.0077945,0.0064839,0.0058635,0.0064502,0.0078581,0.0078007,0.0065132,0.0058755,0.0064073,0.0078281,0.0078431,0.0065398,0.0058562,0.0063958,0.0078074,0.00781,0.0065313,0.0058487,0.0063827,0.0077936,0.0078128,0.0065675,0.0058531,0.006357,0.0077815,0.007834,0.0066095,0.0058522,0.0063363,0.0077827,0.007857,0.0066245,0.0058326,0.0063258,0.0077619,0.0078101,0.0066736,0.005847,0.0062989,0.0077353,0.0078405,0.0066754,0.0058411,0.0062915,0.0077707,0.0078564,0.006722,0.0058389,0.0062595,0.0077354,0.0078783,0.0067499,0.0058411,0.0062185,0.0076704,0.0078396,0.0067577,0.0058455,0.00621,0.0076814,0.0078483,0.0067829,0.0058416,0.0062087,0.0076489,0.0078384,0.0068049,0.0058347,0.006203,0.0076338,0.0078231,0.0068132,0.0058662,0.0061685,0.0076037,0.0078631,0.0068492,0.005854,0.0061634,0.0075808,0.0078537,0.0069023,0.00589,0.0061467,0.0075785,0.0078669,0.0069078,0.0058749,0.0061279,0.0075811,0.0078865,0.0069254,0.0058742,0.0061026,0.0075531,0.0078614,0.0069584,0.0058843,0.0060857,0.0075445,0.0078621,0.0069785,0.0058971,0.0060901,0.007519,0.0078543,0.0070048,0.0059143,0.0060631,0.0074984,0.0078656,0.0070418,0.0059388,0.0060567,0.0075066,0.0078554,0.0070563,0.0059437,0.006028,0.0074656,0.007856,0.0070751,0.0059327,0.0060186,0.0074439,0.0078412,0.0071001,0.0059551,0.0059948,0.0074289,0.0078634,0.0070945,0.005988,0.0059962,0.0073917,0.007836,0.0071653,0.0059737,0.0059897,0.0073728,0.0078426,0.0071506,0.0059901,0.0059631,0.0073282,0.0078139,0.0072007,0.0060124,0.005956,0.0073339,0.0078605,0.0071872,0.006002,0.0059189,0.007299,0.0078557,0.0072076,0.0060418,0.0059465,0.0072548,0.0078286,0.0072568,0.0060455,0.0059349,0.0072634,0.0078426,0.0072735,0.0060677,0.0059138,0.007244,0.0078344,0.0073067,0.0060656,0.0058917,0.0072273,0.0078437,0.0073477,0.0061011,0.0058998,0.0071723,0.0078051,0.0073512,0.0061393,0.0058747,0.0071677,0.0077979,0.0073605,5.4727E-4:4
-7.3333E-8,1.3767E-6,-3.6667E-8,1.11E-6,9.7333E-7,-1.9E-7,1.3967E-6,2.8E-7,2.2433E-6,1.7333E-6,9.3333E-8,1.9467E-6,4.3E-7,1.4733E-6,1.0633E-6,7.1667E-7,0.0043071,0.0066648,0.008167,0.0068948,0.0051269,0.0061895,0.0069294,0.008124,0.0076388,0.0060477,0.006186,0.0070607,0.0080621,0.007628,0.0061064,0.0060631,0.0070556,0.0080864,0.0076243,0.0061539,0.0060934,0.0070608,0.0080535,0.0076218,0.0061364,0.0060621,0.0070298,0.0080611,0.0075958,0.0061366,0.0060349,0.0070118,0.008027,0.007596,0.0061585,0.0060306,0.0069776,0.007999,0.0076178,0.0061628,0.0060117,0.0069478,0.007999,0.0076195,0.0061547,0.0059819,0.0069431,0.0079943,0.007625,0.006178,0.0059876,0.0069081,0.0079941,0.0076487,0.0061517,0.0059844,0.0068522,0.0079878,0.0076403,0.006176,0.0059637,0.0068542,0.0079755,0.0076634,0.0061843,0.0059567,0.0068187,0.0079523,0.0076384,0.0062025,0.0059585,0.0068091,0.0079733,0.0076541,0.0061975,0.0059343,0.0068064,0.0079933,0.0076528,0.0062039,0.0059278,0.0067776,0.0079485,0.0076647,0.0062213,0.0059206,0.0067351,0.0079668,0.0076543,0.0062157,0.0059231,0.0067364,0.0079416,0.0076565,0.0062523,0.0058979,0.0066924,0.0079474,0.0076617,0.0062413,0.0059137,0.0066989,0.0079505,0.0076714,0.0062637,0.0058915,0.0066977,0.0079274,0.0076936,0.0062786,0.0058734,0.0066749,0.0079255,0.0077201,0.0062829,0.0059038,0.0066461,0.0079075,0.007711,0.0063063,0.005885,0.0066434,0.0078816,0.007722,0.0062989,0.0058614,0.0066102,0.0079319,0.0077351,0.0063148,0.0058792,0.006578,0.0079261,0.0077538,0.0063235,0.0058762,0.0065999,0.0079073,0.0077409,0.0063716,0.0058616,0.006568,0.0079246,0.0077843,0.0063942,0.0058578,0.0065643,0.0078941,0.0077572,0.0063846,0.0058722,0.0065132,0.007883,0.0077541,0.0063956,0.0058414,0.0065499,0.0078956,0.0077613,0.0064178,0.0058783,0.0065129,0.0078675,0.0077629,0.0064039,0.0058763,0.006496,0.0078614,0.0077754,0.0064336,0.0058649,0.0064834,0.0078648,0.0077747,0.0064519,0.0058465,0.0064821,0.0078595,0.0077805,0.0064597,0.0058517,0.0064659,0.0078519,0.0078014,0.00649,0.0058643,0.0064398,0.0078505,0.0078238,0.0064953,0.0058705,0.0064391,0.007846,0.0078213,0.0065177,0.0058613,0.0064102,0.0078569,0.0078161,0.0065311,0.0058379,0.0064032,0.0078299,0.0078054,0.006551,0.0058299,0.0063795,0.0078322,0.0078303,0.0065345,0.0058486,0.0063704,0.0077942,0.0078314,0.006547,0.0058537,0.006375,0.0077946,0.0078237,0.0065905,0.0058643,0.0063549,0.0078221,0.0078298,0.0065923,0.0058438,0.0063282,0.0077949,0.0078273,0.0066184,0.0058797,0.0063441,0.0077497,0.0078305,0.0066189,0.0058373,0.0063091,0.0077648,0.0078279,0.0066365,0.0058347,0.0062971,0.0077651,0.0078611,0.0066539,0.005851,0.0062953,0.0077419,0.0078636,0.0066787,0.0058309,0.0063022,0.0077514,0.0078505,0.0066972,0.0058431,0.0062709,0.0077386,0.0078278,0.0066978,0.00586,0.0062804,0.0077188,0.00785,0.0067246,0.0058217,0.0062181,0.007684,0.0078018,0.0066807,0.0058041,0.0062002,0.0076603,0.0078267,0.0067448,0.005823,0.0061823,0.0076363,0.0077942,0.0067307,0.0058208,0.0061754,0.0076483,0.0078124,0.0067296,0.0058295,0.0061511,0.0076066,0.0078002,0.0067537,0.0058468,0.0061278,0.0076098,0.0078251,0.006772,0.0058295,0.0061618,0.0040665:4
2.3567E-6,-1.1267E-6,1.1E-6,1.3733E-6,-1.17E-6,3.17E-6,5.4333E-7,1.29E-6,2.05E-6,-3.0667E-7,2.56E-6,5.2E-7,1.29E-6,1.8167E-6,-1.9E-7,2.02E-6,4.4333E-7,8.0E-7,2.1167E-6,-7.5667E-7,2.0767E-6,-4.9E-7,8.9E-7,2.3633E-6,-7.3667E-7,2.4667E-6,-2.7E-7,1.6467E-6,1.8733E-6,-5.2333E-7,1.7567E-6,-7.9E-7,8.5E-7,1.9933E-6,-1.5033E-6,2.0433E-6,-3.8667E-7,8.9333E-7,2.16E-6,-1.0367E-6,2.1167E-6,-4.7333E-7,1.48E-6,2.3033E-6,-1.05E-6,4.95E-6,0.0065346,0.0084977,0.008895,0.0074389,0.006686,0.0079917,0.0090723,0.0087913,0.0075257,0.0065565,0.0080222,0.0090335,0.0087978,0.007553,0.0065041,0.0080151,0.0089674,0.0087592,0.0075078,0.0064797,0.0079326,0.0089067,0.0087316,0.0074983,0.0064254,0.0079324,0.0088926,0.0087198,0.0075041,0.0064399,0.0078945,0.0088673,0.0086745,0.0074749,0.0063935,0.0078748,0.0088517,0.0086845,0.0074648,0.0063828,0.0078391,0.0088076,0.0086715,0.0074841,0.0063487,0.0077938,0.0088046,0.0086714,0.0074616,0.0063514,0.0077688,0.0087672,0.0086708,0.0074888,0.0063397,0.0077727,0.0087637,0.0086675,0.0074805,0.0063518,0.0077494,0.0087648,0.0086859,0.0075029,0.0063447,0.0077658,0.0087314,0.0086665,0.0075012,0.0063432,0.007738,0.0087218,0.0086866,0.0075146,0.0063078,0.0077226,0.008695,0.0087062,0.0075175,0.0063146,0.0077058,0.0087237,0.0086831,0.0075113,0.0063235,0.0076759,0.0086953,0.0086903,0.007532,0.0063026,0.0076668,0.008699,0.0087024,0.0075278,0.0063214,0.0076865,0.0086931,0.0087243,0.0075633,0.0062951,0.0076698,0.0086913,0.0087278,0.0075138,0.0062913,0.0076336,0.0086633,0.0087221,0.0075783,0.0062967,0.0076167,0.0086502,0.0087536,0.0075543,0.0063036,0.0076378,0.0086606,0.0087291,0.0075689,0.0062815,0.0076035,0.0086702,0.0087369,0.0075713,0.0062801,0.0075906,0.0086412,0.0087619,0.0076074,0.0062926,0.0075863,0.0086308,0.0087434,0.0075928,0.0062878,0.0075657,0.0086186,0.0087387,0.0076057,0.0062894,0.0075606,0.0086126,0.0087258,0.0076244,0.0063033,0.007566,0.0086,0.0087479,0.0076315,0.0062957,0.0075498,0.0086067,0.0087501,0.0076484,0.0062869,0.0075087,0.0086052,0.0087814,0.00763,0.0062964,0.0075535,0.0085973,0.0087756,0.0076595,0.0062999,0.0075214,0.0086023,0.0087632,0.0076532,0.0062809,0.0075454,0.0085679,0.0087705,0.0076737,0.0062948,0.0075038,0.0085498,0.008799,0.0076855,0.0062639,0.0074758,0.0085519,0.0087803,0.007676,0.0062946,0.0075022,0.0085523,0.0087789,0.007723,0.0062873,0.0074849,0.008525,0.0087746,0.0077067,0.006297,0.0074586,0.0085187,0.0088278,0.0077066,0.0062938,0.0074364,0.0085117,0.008848,0.0077401,0.0062921,0.0074314,0.0085185,0.0088235,0.0077578,0.0063062,0.0074273,0.0085042,0.0088109,0.0077693,0.0062918,0.0074041,0.0084747,0.0088212,0.0077704,0.0063069,0.0074142,0.0084625,0.0088246,0.0077919,0.0:4
-1.0533E-6,1.1567E-6,2.0867E-6,-4.0E-8,1.89E-6,-4.2333E-7,1.87E-6,1.8367E-6,-3.3333E-9,1.89E-6,4.2667E-7,2.4867E-6,7.6333E-7,-1.5167E-6,1.98E-6,2.6667E-7,1.28E-6,1.1567E-6,-1.8667E-7,1.6567E-6,5.2333E-7,1.4133E-6,1.7367E-6,-9.3E-7,1.59E-6,-1.6667E-6,1.8567E-6,1.54E-6,-4.7E-7,0.0051594,0.0070387,0.0075994,0.0086421,0.008222,0.0064353,0.0076973,0.0086802,0.0091436,0.0081173,0.0064597,0.0075993,0.0086699,0.0090944,0.0080541,0.0064778,0.0075504,0.008618,0.009037,0.0080262,0.006444,0.0075356,0.0086071,0.0090188,0.0079875,0.006414,0.0074855,0.0085736,0.009002,0.007933,0.0063988,0.0074716,0.0085795,0.0089544,0.0079091,0.0063821,0.0074535,0.0085415,0.0089652,0.0079041,0.0063822,0.0074697,0.0085326,0.0089595,0.0079157,0.0063538,0.0074194,0.0084892,0.0089043,0.0079122,0.0063732,0.0074366,0.0085233,0.0089063,0.0078714,0.0063702,0.0074292,0.0084969,0.0089319,0.0078872,0.006368,0.007399,0.0085048,0.0089063,0.007868,0.0063442,0.0074419,0.0084803,0.00891,0.0078704,0.006354,0.0073921,0.0085004,0.0089142,0.0078534,0.0063484,0.0074107,0.0084955,0.0088713,0.0078592,0.0063499,0.0073991,0.0084932,0.0089023,0.0078462,0.0063291,0.0074001,0.0084907,0.0088951,0.0078313,0.0063013,0.0074151,0.0084803,0.0088652,0.0078546,0.0063029,0.0074215,0.0085059,0.0088877,0.0078438,0.0063205,0.0074356,0.0084937,0.0088766,0.007806,0.0063274,0.0074066,0.0084931,0.0088536,0.0078214,0.006329,0.0074148,0.008496,0.0088543,0.007816,0.0063214,0.0073951,0.0084584,0.0088821,0.0078158,0.0063195,0.0074427,0.0084732,0.0088618,0.0078222,0.0063183,0.0074066,0.0084675,0.0088536,0.0078036,0.0063083,0.0073848,0.0084879,0.0088424,0.0078013,0.0062882,0.0074201,0.0084855,0.0088498,0.0077817,0.0063096,0.0073882,0.0084823,0.0088443,0.0078385,0.0063108,0.0074331,0.0084669,0.0088453,0.0077799,0.0063111,0.0074201,0.0084999,0.0088441,0.0078016,0.0063047,0.0074358,0.0084787,0.0088323,0.0078053,0.0062995,0.0073816,0.0084636,0.0088625,0.0078138,0.0063025,0.0074114,0.0084794,0.0088392,0.0077889,0.0063018,0.0074062,0.0084605,0.0088348,0.0077995,0.0062987,0.0073952,0.0084648,0.0088413,0.0077821,0.0063047,0.0073885,0.0084734,0.0088333,0.0077812,0.0063074,0.0074064,0.0084749,0.0088489,0.0078045,0.0062869,0.0073868,0.008459,0.0088398,0.0077691,0.0063126,0.0074106,0.0084878,0.0088173,0.0077755,0.0063067,0.007415,0.008467,0.0088304,0.0077575,0.0062965,0.007397,0.008457,0.0088196,0.0077793,0.0062956,0.0074075,0.0084654,0.0087968,0.007781,0.0062966,0.0073873,0.0084623,0.0088275,0.0077572,0.0063007,0.0074227,0.0084957,0.0088424,0.0077959,0.0062933,0.0074374,0.0084753,0.0088504,0.007791,0.0063097,0.007393,0.008456,0.0088225,0.0077774,0.0062952,0.0074289,0.0084715,0.0088363,0.0077835,0.0063035,0.0074087,0.0084924,0.008824,0.0077652,0.0062925,0.0074149,0.0085092,0.008819,0.0077586,0.006294,0.0:4
-5.1333E-7,1.65E-6,-4.6667E-7,8.3667E-7,1.63E-6,6.6666E-9,2.3967E-6,-7.1333E-7,1.0867E-6,1.4633E-6,-9.4667E-7,1.7833E-6,-5.3E-7,1.4433E-6,1.4867E-6,-1.3567E-6,2.2067E-6,-7.2333E-7,1.6567E-6,2.0867E-6,-7.2667E-7,2.05E-6,-1.0667E-7,7.8333E-7,1.9567E-6,8.3333E-8,1.53E-6,5.7E-7,2.11E-6,1.6833E-6,-3.5667E-7,2.46E-6,-2.0333E-7,1.5933E-6,1.5E-6,-1.0333E-7,1.79E-6,0.0010625,0.0077907,0.0078861,0.0075023,0.0063765,0.008023,0.0089133,0.008966,0.007788,0.0064627,0.0079135,0.0088831,0.0089224,0.0076889,0.0064552,0.0078147,0.0088392,0.0088578,0.0076632,0.0064373,0.0077549,0.008815,0.0088444,0.0076519,0.0064054,0.0077069,0.008811,0.0088712,0.0076475,0.0063687,0.0077197,0.0087624,0.0088096,0.007641,0.0063893,0.0076821,0.0087445,0.0088444,0.0076185,0.0063689,0.0076913,0.0086964,0.0087956,0.0076104,0.0063581,0.007643,0.0086875,0.0087922,0.0076137,0.0063394,0.007618,0.0086801,0.0087807,0.0076196,0.0063364,0.0076156,0.0086632,0.0087818,0.0076208,0.0063234,0.0076051,0.0086634,0.00879,0.0076073,0.0063251,0.0075767,0.0086369,0.0087797,0.0076148,0.0063108,0.0075716,0.0086058,0.0087738,0.007624,0.0063248,0.0075265,0.0086161,0.0087876,0.0076343,0.0063166,0.0075634,0.008605,0.008785,0.007646,0.0063211,0.0075252,0.0085835,0.0087863,0.0076542,0.0063185,0.0075179,0.0085927,0.0087794,0.0076659,0.0062888,0.0075237,0.0085775,0.0087945,0.0076565,0.0062956,0.0075244,0.0086052,0.0087825,0.0076744,0.0062965,0.0075161,0.0085778,0.0088046,0.0076298,0.0063021,0.0074846,0.0085578,0.0087951,0.0076596,0.0062947,0.0074717,0.0085396,0.0087941,0.0076966,0.0062932,0.0074743,0.0085473,0.0088236,0.0077105,0.0063168,0.0074811,0.0085116,0.0088014,0.0077107,0.0063034,0.0074646,0.0085103,0.0088217,0.0077286,0.0063203,0.0074576,0.0085227,0.0088231,0.0077342,0.0062877,0.0074277,0.0085318,0.0088355,0.0077306,0.0062865,0.0074293,0.0084949,0.0088183,0.0077193,0.0062764,0.0074202,0.0085006,0.0088163,0.0077386,0.0062865,0.0074283,0.0084813,0.0088049,0.0077662,0.0062967,0.0074126,0.0084909,0.0088415,0.0077797,0.006303,0.0074265,0.0084816,0.0088438,0.0077985,0.006308,0.0073896,0.0084721,0.0088265,0.0078009,0.0063167,0.0073938,0.0084393,0.0088475,0.0078254,0.0063103,0.0073744,0.0084558,0.008833,0.0078109,0.0063081,0.0073594,0.0084395,0.0088528,0.0077956,0.006329,0.0073607,0.0084237,0.008833,0.0078057,0.006293,0.0073537,0.0084468,0.0088353,0.0078177,0.0063156,0.0073234,0.0084261,0.0088576,0.0078148,0.0063171,0.0073223,0.0084248,0.0088579,0.0078311,0.0063192,0.0073309,0.0083956,0.0088277,0.007827,0.0062898,0.0073519,0.0084097,0.0088648,0.0078762,0.0063294,0.0073287,0.0083953,0.0088792,0.0079024,0.0063103,0.0073114,0.0083642,0.0088525,0.0078986,0.0063137,0.0072959,0.0084026,0.0088594,0.0078868,0.0063031,0.007291,0.0083589,0.0088694,0.0079176,0.0063247,0.0072956,0.0083674,0.0088685,0.0:4
2.0667E-7,-1.6633E-6,6.9667E-7,-8.6667E-7,-1.8667E-6,6.7667E-7,-1.3367E-6,-7.7667E-7,-7.2333E-7,-1.9833E-6,1.8333E-7,-1.56E-6,-5.8333E-7,-1.0467E-6,-2.8E-6,2.0667E-7,-1.4867E-6,-4.2333E-7,-5.5667E-7,-2.54E-6,8.5667E-7,-1.1933E-6,-3.9E-7,-7.4E-7,-1.6167E-6,-2.9667E-7,-1.3867E-6,1.2667E-7,-2.1333E-7,-1.0233E-6,6.6E-7,-1.3533E-6,-8.0333E-7,3.9667E-7,-1.7333E-6,6.5E-7,-1.0033E-6,-5.2333E-7,2.7333E-7,-2.1033E-6,-5.9E-7,-1.01E-6,3.5333E-7,-1.3333E-8,-1.9567E-6,-4.3333E-8,-1.89E-6,6.2E-7,-1.05E-6,-1.6267E-6,5.6E-7,-2.8033E-6,-2.8667E-7,-7.2E-7,-2.3867E-6,5.4E-7,-1.2233E-6,-5.3333E-7,-1.3233E-6,-1.32E-6,4.3E-7,-1.2833E-6,-3.7667E-7,-1.1767E-6,-5.7667E-7,5.6667E-7,-2.07E-6,-3.3667E-7,-1.11E-6,-2.1367E-6,0.0073544,0.0018104,0.0076159,0.0061321,0.0043914,0.0062877,0.0034086,0.0068813,0.00627,0.0047726,0.005806,0.0038447,0.0066827,0.006308,0.0048741,0.005636,0.0039785,0.0066293,0.0062882,0.0049314,0.0056208,0.0039963,0.0065854,0.006293,0.0049342,0.0055799,0.0039866,0.0065444,0.006245,0.0049414,0.0055636,0.0039798,0.0065453,0.006259,0.0049415,0.0055751,0.0039592,0.0065191,0.0062124,0.0049508,0.0055735,0.0039405,0.0065159,0.0062098,0.0049354,0.0055582,0.0039489,0.0064934,0.0062005,0.0049497,0.0055559,0.003933,0.0064943,0.0061854,0.0049559,0.0055776,0.0039226,0.0064995,0.0061695,0.0049568,0.0055899,0.0039323,0.0064697,0.0061511,0.0049723,0.0055564,0.0038997,0.0064644,0.0061397,0.004966,0.0055619,0.0038996,0.0064661,0.0061344,0.0049735,0.0055747,0.0038895,0.0064597,0.0060981,0.0049752,0.00558,0.0038934,0.006445,0.0060995,0.0049874,0.0055759,0.0038873,0.0064133,0.0061083,0.0050077,0.0055694,0.0038812,0.0064354,0.0060852,0.0050034,0.0055797,0.0038749,0.0064297,0.0060776,0.0050085,0.0055986,0.0038627,0.0063956,0.0060559,0.0050343,0.0055831,0.0038656,0.0064073,0.0060584,0.0050239,0.005593,0.0038406,0.0064073,0.006046,0.0050547,0.0056069,0.0038516,0.0063984,0.0060382,0.0050527,0.0055929,0.0038428,0.0063889,0.0060352,0.0050493,0.0056248,0.003844,0.0064073,0.0060165,0.0050726,0.0056008,0.0038304,0.0063726,0.006013,0.0050735,0.0056269,0.0038243,0.0063779,0.0060074,0.0050899,0.0055996,0.0038436,0.0063828,0.00601,0.0050967,0.0056055,0.00383,0.0063701,0.005991,0.005094,0.0056049,0.0038231,0.0063727,0.0059745,0.0051174,0.0056163,0.0038204,0.0063579,0.0059644,0.0051209,0.0056283,0.0038213,0.006355,0.0059562,0.0051277,0.0056238,0.0038259,0.0063566,0.0059429,0.0051411,0.0056167,0.0038289,0.0063415,0.0059533,0.0051638,0.0056414,0.0038082,0.0063399,0.0059465,0.0051515,0.0056612,0.0038132,0.0063342,0.0059356,0.0051799,0.0056647,0.0038026,0.006331,0.0059035,0.0051929,0.0056534,0.0037894,0.0063387,0.0059249,0.0051854,0.0056884,0.0037847,0.006303,0.0059107,0.0051982,0.0056686,0.0038032,0.0063196,0.0058895,0.0051991,0.0056708,0.0037947,0.0062964,0.0058751,0.0052526,0.0057042,0.0038094,0.0063083,0.0058838,0.0052388,0.0056946,0.0037948,0.0063078,0.0058745,0.0052558,0.0056809,0.003782,0.0062849,0.0058778,0.0052556,0.0056969,0.0037774,0.0062984,0.0058717,0.0052639,0.0057078,0.0037677,0.0062869,0.0058619,0.00528,0.0057215,0.0037779,0.0062762,0.0058355,0.0052653,0.0057058,0.0037819,0.0062624,0.0058541,0.0053128,0.005728,0.0037759,0.0062566,0.0058217,0.0053038,0.0057429,0.0037874,0.0062637,0.0058207,0.0053202,0.0057519,0.0037695,0.0062528,0.0058216,0.0053231,0.0057372,0.0037763,0.0062539,0.0058157,0.0053218,0.0057352,0.003786,0.0062419,0.0057997,0.0053255,0.0057359,0.0037718,0.0062356,0.0058071,0.0053502,0.0057557,0.0037649,0.0062396,0.0057979,0.0053401,0.0057518,0.0037719,0.0062643,0.0057977,0.0053534,0.0057709,0.0037609,0.006214,0.0057862,0.0053703,0.0057576,0.003772,0.0062177,0.0057716,0.0053539,0.0057867,0.0037456,0.0061918,0.0057474,0.0053673,0.0057962,0.0037549,0.0062102,0.0057603,0.0053852,0.0057838,0.0037616,0.0061748,0.0057425,0.0053977,0.0:4
-6.5E-7,-2.6267E-6,-1.6333E-7,-1.2233E-6,2.9333E-7,3.5333E-7,-2.02E-6,-1.5333E-7,-1.81E-6,-5.9333E-7,-2.2333E-7,-1.4833E-6,8.7667E-7,-1.1367E-6,1.0067E-6,-1.0267E-6,-2.1967E-6,8.9667E-7,-1.07E-6,-5.0333E-7,-1.06E-6,-3.32E-6,8.6667E-8,-5.6667E-7,2.2E-7,1.9E-7,-2.0067E-6,7.3333E-8,-1.82E-6,-9.8667E-7,-5.7E-7,-1.8733E-6,-6.3E-7,-1.6833E-6,1.4667E-7,-1.59E-6,-2.8267E-6,3.3333E-7,-1.1533E-6,0.0061162,0.0065321,0.0034578,0.0066626,0.0032113,0.0070385,0.0065056,0.0042405,0.0058203,0.0039033,0.0067754,0.0065399,0.0044718,0.0055736,0.0041074,0.0066976,0.0065115,0.0045343,0.0055057,0.0041631,0.0066667,0.0064867,0.0045367,0.0054596,0.0041414,0.0066356,0.0064777,0.0045519,0.0054549,0.0041577,0.006635,0.0064705,0.0045482,0.0054635,0.0041438,0.0066092,0.0064477,0.0045561,0.0054327,0.0041204,0.0066058,0.0064297,0.0045486,0.0054354,0.0041219,0.0065768,0.0064077,0.0045544,0.0054285,0.0041336,0.0065609,0.0064139,0.004548,0.0054335,0.0040966,0.006561,0.0063872,0.0045606,0.0054129,0.0040896,0.0065535,0.0063969,0.0045473,0.0054116,0.0040743,0.0065711,0.0063821,0.0045396,0.0054297,0.004065,0.0065574,0.0063658,0.0045502,0.0054405,0.0040618,0.0065344,0.0063735,0.0045589,0.0054015,0.0040477,0.006555,0.0063728,0.0045564,0.0054127,0.0040466,0.0065391,0.0063377,0.0045685,0.0054093,0.0040418,0.0065406,0.0063488,0.0045532,0.0054035,0.004018,0.0065435,0.0063483,0.0045792,0.0054013,0.0040216,0.0065211,0.006322,0.0045804,0.0054073,0.0040221,0.0065423,0.0063193,0.0045865,0.0053902,0.0040189,0.0065086,0.0063215,0.0045999,0.005434,0.004004,0.0065199,0.0063152,0.0045979,0.0054199,0.0040179,0.006516,0.0062964,0.0046213,0.0054142,0.0040124,0.0065173,0.0062994,0.0046225,0.0054157,0.0039971,0.0065058,0.0062851,0.0046133,0.0054266,0.004006,0.0065183,0.0063096,0.004634,0.0054114,0.0039883,0.0065053,0.0062928,0.0046497,0.0054171,0.0039832,0.0065165,0.0063058,0.0046481,0.005427,0.0039768,0.0065276,0.0062617,0.0046498,0.005419,0.0039736,0.0065073,0.0062608,0.004644,0.0054129,0.0039841,0.0064904,0.0062781,0.0046748,0.0054227,0.003974,0.0064908,0.0062769,0.0046769,0.0054172,0.0039568,0.0064814,0.0062698,0.0046802,0.0054537,0.003968,0.0064852,0.0062605,0.0046686,0.0054311,0.0039647,0.0065207,0.0062462,0.0046839,0.0054498,0.0039433,0.0065002,0.0062639,0.0047007,0.0054131,0.0039458,0.0065007,0.0062344,0.0047025,0.005424,0.003937,0.0064812,0.0062287,0.0047261,0.0054458,0.0039351,0.0064829,0.0062214,0.0047151,0.0054515,0.0039353,0.0064715,0.0062255,0.0047511,0.0054447,0.0039332,0.0064617,0.0:4
1.8367E-6,2.4633E-6,-2.0E-7,2.6433E-6,-3.7667E-7,2.3267E-6,1.8533E-6,3.3333E-9,2.8E-6,-6.7333E-7,1.91E-6,2.71E-6,7.1E-7,1.88E-6,-5.9667E-7,1.74E-6,1.08E-6,-9.9333E-7,1.8133E-6,-9.3333E-8,2.3267E-6,1.0467E-6,7.9333E-7,2.3433E-6,-2.0667E-7,1.9933E-6,1.5367E-6,1.1367E-6,1.7167E-6,3.2599E-4,0.0046221,0.011422,0.01293,0.003987,0.011854,0.0070858,0.010816,0.011709,0.0053141,0.010425,0.0076225,0.010583,0.011377,0.0057341,0.009967,0.007831,0.010555,0.011247,0.0059186,0.0097444,0.0078446,0.010526,0.011191,0.0059704,0.0096975,0.007809,0.010537,0.011154,0.00596,0.0096844,0.0077546,0.010593,0.011199,0.0060029,0.0095935,0.0077288,0.010607,0.011159,0.0060213,0.0096067,0.007639,0.010632,0.011152,0.0060272,0.0095767,0.007593,0.010618,0.011191,0.0060408,0.0095321,0.0075569,0.010673,0.011131,0.0060499,0.009494,0.0074744,0.010708,0.011183,0.006085,0.0094955,0.0074481,0.010705,0.011192,0.0061058,0.009502,0.0073898,0.010734,0.011144,0.0061577,0.0094591,0.0073595,0.010771,0.011141,0.0061529,0.0094262,0.0072574,0.010776,0.011139,0.0061815,0.0094402,0.0072431,0.010798,0.01116,0.0062306,0.0093917,0.0072044,0.010823,0.011177,0.0062198,0.009374,0.0071616,0.010863,0.011157,0.0062744,0.0094158,0.0071122,0.010882,0.011163,0.006297,0.0094002,0.0070592,0.010886,0.011134,0.0063147,0.0093856,0.0070313,0.010906,0.011105,0.006396,0.0093857,0.0069854,0.010945,0.011095,0.006428,0.0093437,0.0069452,0.010933,0.011095,0.0064354,0.0093711,0.0069197,0.010962,0.011073,0.0064803,0.0092941,0.0068843,0.010988,0.011085,0.0065525,0.0093391,0.0068156,0.010981,0.011044,0.0065531,0.009346,0.0067759,0.011012,0.01101,0.0066,0.0093674,0.0067594,0.011022,0.011026,0.0066473,0.0093243,0.0066873,0.011051,0.010995,0.0067034,0.0093208,0.0066689,0.011071,0.01095,0.0067457,0.0093023,0.006635,0.011057,0.010917,0.0068072,0.0093301,0.0066074,0.01109,0.010916,0.0068375,0.0093133,0.0065619,0.011093,0.01088,0.0068849,0.0093114,0.0065351,0.011056,0.010842,0.0069169,0.0093219,0.0065005,0.011052,0.010819,0.0069668,0.0093381,0.0064704,0.011093,0.010765,0.0070244,0.009317,0.0064147,0.011075,0.010769,0.0070641,0.0093206,0.0063825,0.011074,0.010749,0.0070826,0.00935,0.0063344,0.011082,0.01067,0.0071662,0.0093283,0.0063307,0.011096,0.01066,0.007212,0.0093313,0.0063044,0.011105,0.010633,0.007275,0.0093886,0.0062762,0.01111,0.010571,0.0073278,0.0094255,0.0062537,0.011117,0.010545,0.0073861,0.0094022,0.0062028,0.011106,0.010565,0.0074275,0.0094278,0.0061926,0.011121,0.010467,0.0075023,0.0094272,0.0061733,0.011073,0.010443,0.0075486,0.009439,0.0061462,0.011051,0.010393,0.0076153,0.0094509,0.0060803,0.011082,0.010368,0.007678,0.0094617,0.0060729,0.011057,0.010291,0.0077151,0.0094955,0.0060302,0.011074,0.01024,0.0077985,0.0095002,0.0060289,0.011015,0.010223,0.0077922,0.0095011,0.0060104,0.011001,0.010143,0.0078701,0.0095513,0.0060117,0.010991,0.010149,0.0079068,0.0095569,0.0059485,0.010979,0.010069,0.0080161,0.009575,0.0059596,0.010989,0.010047,0.0080358,0.0095444,0.0059332,0.010963,0.010009,0.0080818,0.009644,0.0058751,0.010923,0.0099548,0.0081517,0.0096198,0.0059026,0.010892,0.0099375,0.0082042,0.0096582,0.0058706,0.01089,0.00988,0.0082529,0.0096813,0.0058278,0.010887,0.009869,0.0083029,0.0097281,0.0058277,0.01085,0.0097878,0.0083654,0.0097342,0.0058124,0.010825,0.0097713,0.0084167,0.0097771,0.0058285,0.010802,0.0097537,0.00846,0.0097733,0.0058105,0.010771,0.0096777,0.0085146,0.0098163,0.0057815,0.010735,0.0096525,0.0085464,0.0098517,0.0057601,0.01072,0.0096031,0.0086167,0.0098828,0.0057379,0.010712,0.0095608,0.0086357,0.0099113,0.0:4
1.79E-6,1.1933E-6,1.6467E-6,1.4E-7,1.7667E-6,1.12E-6,3.2667E-7,2.1967E-6,6.1333E-7,1.3667E-6,1.6733E-6,3.9667E-7,1.54E-6,2.9667E-7,1.2733E-6,1.2067E-6,7.7333E-7,1.72E-6,2.9E-7,2.1333E-6,2.09E-6,1.7E-7,1.6567E-6,-2.2667E-7,2.0767E-6,2.0533E-6,-3.0E-7,1.5333E-6,3.9667E-7,2.8167E-6,2.3433E-6,1.1467E-6,2.0567E-6,4.6667E-7,2.0033E-6,1.9367E-6,5.1667E-7,1.2342E-4,0.0143,0.0049524,0.011892,0.012148,0.0050081,0.010978,0.0066025,0.011194,0.011515,0.005881,0.0099707,0.0070362,0.011037,0.011298,0.0061576,0.0096061,0.0071881,0.01092,0.011279,0.0062643,0.0094901,0.0071821,0.010952,0.011231,0.0062824,0.0094398,0.0071533,0.010937,0.01121,0.0063498,0.009435,0.0071212,0.010938,0.011186,0.0063775,0.0094077,0.0070323,0.010952,0.011172,0.0064339,0.0093638,0.0070176,0.010971,0.011134,0.0064513,0.0093684,0.0069466,0.010986,0.011128,0.0064769,0.0093763,0.0069111,0.010986,0.011082,0.0065257,0.0093608,0.0068404,0.011005,0.01104,0.0065741,0.0093167,0.0068154,0.011035,0.011024,0.00662,0.0093094,0.0067475,0.011034,0.011001,0.0066482,0.0093597,0.0067236,0.011026,0.010973,0.0066724,0.009333,0.0066663,0.011035,0.01095,0.0067463,0.0093412,0.0066442,0.01104,0.010912,0.006794,0.0093408,0.0066033,0.011089,0.0109,0.0068595,0.0093122,0.0065772,0.011098,0.010882,0.0068705,0.0093208,0.0065338,0.011107,0.010825,0.0069374,0.0093199,0.0064911,0.011081,0.010805,0.0069523,0.0093347,0.0064421,0.011076,0.010793,0.0069903,0.0093313,0.006422,0.01109,0.010742,0.0070714,0.009313,0.0063588,0.011097,0.010715,0.0071325,0.0093464,0.0063385,0.011099,0.010693,0.0071894,0.0093417,0.00631,0.011152,0.010655,0.0072461,0.0093888,0.0062716,0.011102,0.010635,0.0073184,0.0094008,0.0062484,0.011097,0.01055,0.0073644,0.0094031,0.0062172,0.011122,0.010573,0.0074232,0.0094289,0.0061871,0.011115,0.010504,0.0075133,0.0094452,0.0061514,0.011121,0.01047,0.0075338,0.0094863,0.0061468,0.011089,0.010388,0.0076069,0.0094641,0.0060861,0.011112,0.010364,0.0076631,0.0094623,0.0060958,0.011062,0.010305,0.00774,0.0094459,0.0060294,0.011052,0.010263,0.0077662,0.0094944,0.0060299,0.011026,0.010201,0.0078319,0.0095228,0.0060078,0.011016,0.010165,0.0078965,0.0095375,0.0059923,0.011001,0.010155,0.0079592,0.0095636,0.0059731,0.010981,0.010078,0.0080064,0.0095814,0.0059427,0.010994,0.010034,0.0080838,0.0096227,0.0058885,0.010921,0.0099889,0.0081332,0.0096672,0.0059054,0.010983,0.0099279,0.0081847,0.0096718,0.005921,0.010929,0.0098874,0.0082412,0.0096903,0.0058712,0.010889,0.0098969,0.0082891,0.0096896,0.0058438,0.010852,0.0098195,0.0083652,0.0097707,0.0058335,0.010824,0.0097587,0.0084088,0.0097667,0.005818,0.010799,0.0097465,0.008481,0.0098076,0.0058221,0.010802,0.0097002,0.0085752,0.0098546,0.0057967,0.010777,0.009677,0.0086077,0.009886,0.0057671,0.010795,0.0096048,0.0086598,0.0098918,0.0057755,0.010736,0.0095342,0.0087611,0.009954,0.0057568,0.010698,0.0095578,0.0087706,0.0099918,0.0057567,0.010666,0.0094955,0.0088162,0.0099845,0.0057406,0.010655,0.009443,0.0089345,0.010067,0.0057493,0.010609,0.0093727,0.0089441,0.010097,0.0057224,0.010562,0.009324,0.0090364,0.01014,0.0057346,0.010511,0.0093333,0.0090771,0.010203,0.0057118,0.010521,0.0092855,0.0091205,0.010229,0.0057132,0.010512,0.0092508,0.0091746,0.010271,0.0057208,0.010468,0.0091764,0.0092287,0.010305,0.0057197,0.010445,0.0091452,0.0093021,0.010321,0.0057123,0.010441,0.0091051,0.0093071,0.010352,0.0057006,0.010371,0.0090414,0.0094073,0.010402,0.0057058,0.010373,0.0089969,0.0094699,0.010424,0.005707,0.010348,0.0089476,0.0094992,0.010465,0.0057269,0.010274,0.00891,0.0095436,0.010525,0.0057266,0.010273,0.0088623,0.0095945,0.010547,0.0057089,0.010198,0.0047598:4
-4.2333E-7,2.6733E-6,1.27E-6,1.0933E-6,1.8367E-6,1.4133E-6,1.3267E-6,7.1667E-7,-4.4333E-7,1.5967E-6,5.6667E-7,1.0567E-6,9.6667E-7,1.7667E-7,2.1067E-6,-1.0333E-7,2.45E-6,1.4433E-6,6.0E-7,1.9867E-6,5.0667E-7,2.11E-6,9.9333E-7,-3.8E-7,1.5433E-6,2.3333E-7,2.2967E-6,1.2067E-6,1.45E-6,2.0467E-6,6.5E-7,1.04E-6,1.3133E-6,7.9333E-7,1.08E-6,5.7E-7,1.5833E-6,-2.5E-7,1.5967E-6,8.7E-7,1.0633E-6,2.0667E-6,2.0667E-6,5.9E-7,1.3267E-6,5.3667E-7,1.2367E-6,8.8333E-7,7.9667E-7,2.22E-6,1.6333E-7,2.7467E-6,1.9833E-6,-2.6666E-8,1.5467E-6,9.5E-7,1.7367E-6,1.9967E-6,1.1033E-6,1.7467E-6,8.1333E-7,2.59E-6,2.0167E-6,1.8267E-6,1.9167E-6,6.9667E-7,0.0024348,0.013332,0.01239,0.00501,0.011783,0.0058522,0.011917,0.011691,0.0061674,0.010279,0.006661,0.01149,0.011453,0.0065553,0.0098175,0.0069019,0.011389,0.011418,0.0067099,0.0096818,0.0069531,0.011336,0.011298,0.0067792,0.0095583,0.006927,0.011316,0.011312,0.0068047,0.0095708,0.006939,0.011278,0.011265,0.006845,0.0095557,0.0068839,0.01131,0.011228,0.0069017,0.0095465,0.0068242,0.011311,0.011149,0.0069334,0.0095284,0.006771,0.011303,0.011164,0.0069918,0.0095422,0.0067391,0.011302,0.011128,0.0070178,0.0094945,0.0067244,0.011327,0.011088,0.0070377,0.0095349,0.0066505,0.01132,0.011091,0.0070763,0.0095324,0.0066258,0.011333,0.01104,0.0071388,0.0095236,0.0065876,0.01131,0.010991,0.0071902,0.0095464,0.0065703,0.01133,0.010973,0.0072366,0.0095131,0.0065231,0.011347,0.010924,0.0072819,0.0095421,0.006508,0.01131,0.010956,0.0073232,0.009561,0.0064923,0.011343,0.010902,0.007362,0.0095683,0.0064521,0.011343,0.010879,0.007432,0.0095823,0.0064544,0.011328,0.010851,0.0075158,0.0095939,0.0063929,0.011355,0.010863,0.0075533,0.0095734,0.0063813,0.011351,0.010779,0.0075669,0.0096085,0.0063635,0.011373,0.010744,0.0076298,0.0096381,0.0063294,0.011367,0.010715,0.0077016,0.0096561,0.0063296,0.011349,0.010647,0.007784,0.0096756,0.0063036,0.011315,0.010674,0.0078193,0.0096705,0.0062748,0.011368,0.010634,0.0078551,0.009696,0.0062356,0.011296,0.010565,0.0078998,0.0097047,0.0062378,0.011336,0.010549,0.0079512,0.0097639,0.006214,0.011321,0.010518,0.0080324,0.0097315,0.0061939,0.011328,0.010461,0.0080629,0.0096971,0.0061651,0.011296,0.010459,0.0081339,0.0098279,0.0061786,0.011285,0.010394,0.0081876,0.0098184,0.0061501,0.011317,0.010377,0.008241,0.0098666,0.0061359,0.011297,0.010348,0.0083039,0.0099108,0.0061442,0.011231,0.010381,0.0083459,0.0098954,0.0061144,0.011261,0.010296,0.0084185,0.0099519,0.0061173,0.011262,0.010245,0.0084721,0.0099386,0.0060622,0.01121,0.010188,0.0084866,0.0099409,0.006045,0.01121,0.010152,0.0085472,0.0099881,0.006044,0.011186,0.010189,0.0086176,0.0099866,0.0060442,0.011211,0.010143,0.0086277,0.010066,0.0060421,0.011155,0.010118,0.0086963,0.010078,0.0060128,0.011147,0.010056,0.0087582,0.01014,0.0060214,0.011156,0.010013,0.0088017,0.010123,0.0060179,0.011121,0.0099792,0.0088694,0.01017,0.0059857,0.011096,0.0099584,0.0089143,0.010205,0.0059821,0.011099,0.0099287,0.008945,0.010227,0.0059885,0.011106,0.0098783,0.0089681,0.010251,0.0059581,0.011083,0.0098778,0.0090529,0.01028,0.0059739,0.011029,0.0098351,0.0090705,0.010288,0.0059482,0.010997,0.0097778,0.0091352,0.010346,0.0059549,0.010958,0.0097496,0.0092061,0.010407,0.0059408,0.010978,0.0097101,0.0092468,0.010412,0.0059168,0.010981,0.0096822,0.0092956,0.010424,0.0059322,0.010898,0.0096174,0.0093397,0.010509,0.0059131,0.010906,0.0095872,0.0094108,0.010522,0.0059027,0.010869,0.0095824,0.0094266,0.010549,0.0059504,0.010864,0.0095036,0.0094525,0.010551,0.0059058,0.0108,0.0094797,0.0095298,0.010612,0.0059033,0.010797,0.009447,0.0095656,0.010645,0.0058995,0.010752,0.0094252,0.0096195,0.010677,0.0058799,0.010713,0.0093805,0.0096282,0.010653,0.0059235,0.010751,0.0093251,0.0097281,0.010735,0.0058881,0.010726,0.0092878,0.0097426,0.010777,0.0059084,0.010682,0.0092561,0.0098117,0.01082,0.0059093,0.010682,0.0092525,0.0098169,0.010821,0.0059151,0.010623,0.0091874,0.0098959,0.010834,0.0059132,0.010584,0.0091338,0.0098952,0.010865,0.0059321,0.010564,0.0091331,0.0099474,0.010949,0.0059084,0.010546,0.0035889:4
1.2633E-6,1.0033E-6,1.2867E-6,6.0667E-7,1.5E-7,4.4333E-7,1.4767E-6,2.2467E-6,8.9333E-7,6.9667E-7,-2.9E-7,1.73E-6,1.4E-6,1.9667E-7,1.4967E-6,7.3667E-7,1.72E-6,1.73E-6,4.0333E-7,7.7E-7,4.4E-7,1.5433E-6,1.6767E-6,9.3333E-7,1.58E-6,5.0E-7,1.5533E-6,1.54E-6,7.0E-8,8.0667E-7,0.0058366,0.0080441,0.0096671,0.00929,0.0074999,0.0073784,0.0086361,0.009673,0.0093159,0.007373,0.0074038,0.0085292,0.0096471,0.0092774,0.0073054,0.0073978,0.0084682,0.0095975,0.009224,0.0072795,0.0073657,0.0083825,0.009548,0.0092136,0.0072516,0.0073298,0.0083623,0.0095137,0.0091847,0.0072282,0.0073231,0.0083655,0.0094917,0.0091701,0.0072442,0.0072839,0.008328,0.0094657,0.0091452,0.0072059,0.007254,0.0082935,0.0094596,0.0091181,0.0072109,0.007243,0.0082591,0.0094778,0.0091445,0.0071869,0.0072503,0.0082522,0.0094462,0.0091252,0.0072073,0.0072014,0.0082414,0.009419,0.0091357,0.0071947,0.0072164,0.0082201,0.0094238,0.0091345,0.0071816,0.0072094,0.0081873,0.0094052,0.0091242,0.0072148,0.0072197,0.0081841,0.0093975,0.0090869,0.0072415,0.0071995,0.0081905,0.0093976,0.0091173,0.0072376,0.0072229,0.0081397,0.0093876,0.0091198,0.0071964,0.0072012,0.0081618,0.0093861,0.0091329,0.0072144,0.0071702,0.0081434,0.009365,0.0091206,0.0072377,0.0071771,0.0081558,0.009383,0.0091278,0.0072257,0.0071776,0.0081071,0.0093667,0.0091338,0.0072438,0.0071765,0.0081099,0.0093773,0.0091348,0.0072438,0.0071601,0.008088,0.0093573,0.0091392,0.0072612,0.0071466,0.0080936,0.0093851,0.0091572,0.0072558,0.0071537,0.0080618,0.0093788,0.0091517,0.0072717,0.007142,0.0080727,0.0093823,0.0091285,0.0072859,0.0071576,0.0080735,0.0093655,0.0091798,0.0072862,0.00715,0.0080605,0.0093752,0.0091585,0.0073073,0.0071615,0.0080539,0.0093559,0.0091716,0.0072962,0.0071496,0.0080295,0.0093338,0.0091836,0.0073079,0.0071385,0.0080277,0.0093374,0.0091981,0.0073314,0.0071364,0.0080434,0.0093367,0.0091907,0.0073193,0.0071615,0.0080237,0.0093703,0.0091881,0.0073364,0.0071521,0.0080041,0.0093599,0.0091882,0.0073296,0.0071407,0.0080094,0.009344,0.0091947,0.0073411,0.0071179,0.0079787,0.0093458,0.0091701,0.0073377,0.0071505,0.0079847,0.0093548,0.0092087,0.0073493,0.0071498,0.0079819,0.0093564,0.0092248,0.0073604,0.0071227,0.0079866,0.0093376,0.0092239,0.007349,0.0071267,0.0079455,0.009338,0.0092248,0.0073615,0.0071152,0.0079352,0.0093193,0.0092156,0.0073742,0.0071162,0.007936,0.0093452,0.0092192,0.007371,0.0071114,0.0079171,0.0093174,0.0092361,0.0074025,0.0070895,0.0079115,0.009313,0.0092321,0.0074028,0.0071132,0.0079183,0.0093212,0.0092612,0.0074058,0.0071111,0.0079359,0.0093283,0.0092598,0.007423,0.0:4
7.1333E-7,1.1467E-6,7.5E-7,6.9667E-7,9.5333E-7,1.3967E-6,2.5867E-6,7.1333E-7,4.3667E-7,9.1667E-7,1.1633E-6,1.3633E-6,-2.0667E-7,5.2E-7,8.4667E-7,6.4E-7,1.1767E-6,6.3E-7,1.0233E-6,1.95E-6,8.4333E-7,2.35E-6,9.2E-7,0.0025687,0.0067066,0.008047,0.0088292,0.0089339,0.0071387,0.0076749,0.0089551,0.009668,0.0089398,0.0070825,0.0076585,0.0089039,0.0096261,0.0088956,0.0070303,0.0076211,0.0088487,0.0095932,0.0088737,0.0069938,0.0076058,0.008828,0.0095542,0.0088368,0.0069784,0.0075506,0.0087763,0.009519,0.0087787,0.0069591,0.0075289,0.0087446,0.0094947,0.0087612,0.0069467,0.007501,0.0087381,0.0094836,0.0087584,0.006911,0.0075051,0.0087086,0.0094434,0.0087203,0.0069003,0.0074895,0.0086869,0.0094508,0.0087174,0.0068942,0.007487,0.0086637,0.0094185,0.0087248,0.0068709,0.007462,0.0086994,0.0094349,0.0086741,0.0068752,0.0074691,0.0086757,0.009439,0.0086781,0.0068761,0.007475,0.0086629,0.0094113,0.0086795,0.0068445,0.0074438,0.0086643,0.0094162,0.0086943,0.0068723,0.007427,0.0086568,0.0093987,0.0086545,0.0068498,0.0074404,0.008658,0.0094214,0.0086808,0.0068932,0.0074844,0.0087048,0.0094547,0.0087148,0.0068803,0.0074629,0.0087165,0.0094666,0.0087015,0.0068945,0.0074961,0.0087137,0.0094349,0.0087183,0.0068927,0.0074728,0.0087041,0.0094158,0.0086998,0.006884,0.0074763,0.0087299,0.0094478,0.0087096,0.0068882,0.0074857,0.0087017,0.0094262,0.0086955,0.0068822,0.0074697,0.0086674,0.0094215,0.0087078,0.006884,0.0075066,0.0086983,0.0094412,0.0086951,0.0068763,0.0074645,0.0086669,0.0094431,0.0087265,0.0068719,0.0074856,0.0086692,0.0094496,0.0086739,0.0068941,0.0074687,0.0087107,0.0094266,0.008671,0.0068666,0.0074934,0.0086999,0.009421,0.0087067,0.0068466,0.0074463,0.0086814,0.0094382,0.0087046,0.0068643,0.00746,0.0086738,0.0094171,0.0086898,0.0069097,0.0074684,0.0087003,0.0094233,0.0086755,0.0068745,0.0074881,0.0087226,0.0094662,0.0086908,0.0068814,0.0074613,0.0086971,0.0094183,0.0087025,0.0068934,0.0074656,0.0087,0.0094053,0.0087075,0.0068689,0.0074806,0.0086912,0.009414,0.0087043,0.0068801,0.0074689,0.0087036,0.0094237,0.0086827,0.0068857,0.0074821,0.008695,0.0094231,0.0087109,0.0068791,0.0074831,0.0086737,0.0093999,0.0086937,0.0068785,0.007471,0.008708,0.0094059,0.00868,0.0068789,0.0074703,0.0086688,0.0094405,0.0086841,0.0068626,0.007463,0.0086875,0.0094107,0.0086797,0.0068762,0.0074528,0.0086978,0.0094278,0.0086883,0.0068694,0.0074539,0.0086727,0.0094381,0.0086815,0.0068586,0.0074587,0.0086947,0.0094163,0.0086875,0.0068887,0.0074876,0.0086996,0.0094255,0.0087181,0.0068553,0.0074684,0.0087186,0.0093861,0.0087064,0.006869,0.0074534,0.0086886,0.0094235,0.008697,0.0068638,0.0074673,0.0086927,0.0094222,0.0086635,0.0068558,0.0074437,0.0087121,0.0094167,0.0087058,0.0068489,0.0074811,0.0087082,0.0094123,0.0086892,0.0068524,0.0074841,0.0087267,0.0094218,0.0086823,0.0068946,0.0074872,0.0086809,0.0050256:4
-1.0633E-6,1.7467E-6,6.7333E-7,-1.6E-7,1.96E-6,-3.1E-7,1.68E-6,4.7E-7,-1.0E-7,2.9333E-6,-1.49E-6,1.4967E-6,1.61E-6,4.0E-8,1.69E-6,-5.4333E-7,2.91E-6,1.35E-6,-1.5667E-7,1.51E-6,-1.7567E-6,1.18E-6,-1.7667E-7,1.35E-6,1.8033E-6,-2.3133E-6,1.35E-6,1.1767E-6,2.1667E-7,2.16E-6,-1.5367E-6,1.6733E-6,7.6333E-7,2.0333E-7,2.3567E-6,-2.1067E-6,1.73E-6,0.0046005,0.0067618,0.0020691,0.0063481,0.0036091,0.0059653,0.0061928,0.0031113,0.0055211,0.0041152,0.0058938,0.006047,0.0034337,0.0052156,0.004294,0.0058703,0.005966,0.0035539,0.0051141,0.0043568,0.0058566,0.0059402,0.0036182,0.0050676,0.0043712,0.0058434,0.0059345,0.0036498,0.0050229,0.0043761,0.0058572,0.0059251,0.0036479,0.0049912,0.004374,0.0058302,0.0059265,0.0036549,0.0049935,0.0043559,0.005834,0.0059017,0.0036485,0.0049734,0.0043498,0.0058348,0.0059111,0.0036411,0.0049867,0.0043187,0.0058128,0.0058965,0.0036411,0.0049743,0.0043169,0.0058301,0.0059054,0.0036527,0.0049507,0.0042925,0.0058221,0.0058963,0.0036484,0.0049552,0.0042754,0.0058264,0.0059108,0.003644,0.0049352,0.0042621,0.0058465,0.0059275,0.0036317,0.0049352,0.0042643,0.0058221,0.0058984,0.0036439,0.0049405,0.004229,0.0058487,0.0058917,0.0036646,0.0049146,0.004236,0.0058229,0.0059017,0.0036675,0.0049068,0.0042202,0.0058514,0.0059087,0.0036436,0.004897,0.0042238,0.0058387,0.0058994,0.0036738,0.0049007,0.0042054,0.0058539,0.0059226,0.0036617,0.0048939,0.0041866,0.0058445,0.0059041,0.0036705,0.0048978,0.0041933,0.0058444,0.0058994,0.0036762,0.0049013,0.0041918,0.0058571,0.0059186,0.003684,0.0048975,0.0041823,0.0058703,0.0059177,0.0036812,0.0048849,0.0041727,0.0058673,0.0059165,0.0036968,0.0048725,0.0041504,0.0058577,0.0058989,0.0037003,0.0048992,0.004144,0.0058709,0.005905,0.0036964,0.0048798,0.0041368,0.0058643,0.0059158,0.0037006,0.0048677,0.0041209,0.0058774,0.0059184,0.0037114,0.0048751,0.0041124,0.0058719,0.0059194,0.0037142,0.0048625,0.0041011,0.0058893,0.0059125,0.0037171,0.0048533,0.0041034,0.0058633,0.005919,0.0037074,0.0048639,0.0040938,0.0058911,0.0059282,0.003735,0.0048728,0.0040839,0.0058813,0.0059214,0.0037236,0.0048675,0.0040819,0.0058893,0.0059266,0.0037376,0.0048728,0.0040756,0.0059057,0.0059314,0.0037446,0.0048549,0.0040788,0.0059063,0.005943,0.0037428,0.0048444,0.0040765,0.0058983,0.0059432,0.0037622,0.0048511,0.0040486,0.005905,0.0059288,0.0037667,0.004865,0.0040475,0.0059113,0.0059419,0.003775,0.0048472,0.0040267,0.0058977,0.0059457,0.0037794,0.0048457,0.0040182,0.0059386,0.0059201,0.0037828,0.0048407,0.0040198,0.0059127,0.0059204,0.0037918,0.0048492,0.0039988,0.0059026,0.0059397,0.0037998,0.0048693,0.004017,0.0059172,0.00594,0.0038202,0.0048509,0.0040007,0.0059047,0.0059338,0.0038112,0.0048505,0.0040144,0.005899,0.0059389,0.0038207,0.0048344,0.0039944,0.0059151,0.0059132,0.0038212,0.0048449,0.0039784,0.0059251,0.0059352,0.0038126,0.0048367,0.003969,0.0059167,0.0059341,0.0038303,0.0048443,0.0039701,0.0059167,0.0059424,0.003835,0.004836,0.0039457,0.0059211,0.0059207,0.0038443,0.004841,0.0039535,0.0059008,0.0059233,0.0038486,0.0048515,0.0039306,0.0059266,0.0059306,0.003859,0.0048529,0.0039411,0.0059197,0.0059353,0.0038612,0.0048299,0.0039381,0.0059196,0.0059114,0.0038837,0.0048406,0.0039175,0.0058932,0.005912,0.0038847,0.0048258,0.0039324,0.0059103,0.0058958,0.0039025,0.004846,0.0039117,0.0059213,0.0059085,0.0038998,0.0048304,0.0039085,0.0058888,0.0058868,0.0039147,0.004855,0.003906,0.0059281,0.0016623:4
2.1867E-6,1.01E-6,3.4667E-7,3.64E-6,-9.6E-7,2.6433E-6,4.6333E-7,4.0667E-7,2.6467E-6,-1.29E-6,2.16E-6,-9.7013E-14,6.3667E-7,1.9067E-6,-5.3E-7,2.0267E-6,-2.1E-7,-4.2E-7,2.8333E-6,-4.9333E-7,2.3233E-6,1.4167E-6,2.6667E-8,2.0467E-6,-9.9333E-7,2.4467E-6,8.2333E-7,3.8667E-7,3.6967E-6,-6.2333E-7,2.0833E-6,8.8333E-7,-6.3333E-8,2.1167E-6,-5.8667E-7,1.8E-6,1.82E-6,4.0667E-7,2.1733E-6,-1.1467E-6,2.5467E-6,1.1733E-6,0.0068297,0.0019111,0.0064366,0.0034883,0.0060275,0.006198,0.0031761,0.005444,0.0041436,0.005953,0.0060099,0.0035362,0.005161,0.0043369,0.0059051,0.0059837,0.0036416,0.0050663,0.004356,0.005888,0.0059444,0.0036781,0.0050236,0.0043618,0.0058792,0.0059441,0.0036764,0.0050171,0.004356,0.0058683,0.0059159,0.0036728,0.0049902,0.0043358,0.0058588,0.0059123,0.0036696,0.0049752,0.0043175,0.0058278,0.0059331,0.0036486,0.004967,0.0043265,0.0058534,0.0059042,0.0036658,0.0049625,0.0043044,0.0058489,0.0059114,0.0036568,0.0049575,0.0043065,0.0058487,0.0059039,0.0036491,0.0049683,0.0042636,0.0058467,0.0059084,0.003655,0.0049443,0.0042894,0.0058539,0.0059085,0.0036612,0.0049336,0.0042549,0.0058527,0.0058884,0.0036557,0.004932,0.0042472,0.0058537,0.0058957,0.0036749,0.0049165,0.0042274,0.0058445,0.0059036,0.0036699,0.0049135,0.0042415,0.0058676,0.0059067,0.0036527,0.0049103,0.0042289,0.0058636,0.0059109,0.0036618,0.0049138,0.0042203,0.0058503,0.0058946,0.0036475,0.0049208,0.0042215,0.0058364,0.0059092,0.0036586,0.0049219,0.0041987,0.0058268,0.0059064,0.003667,0.0049037,0.0041883,0.0058441,0.0058712,0.0036688,0.0048943,0.0041778,0.0058479,0.0059033,0.0036522,0.004873,0.0041762,0.005857,0.0058891,0.0036623,0.0048981,0.0041591,0.0058413,0.0058776,0.0036734,0.0048969,0.004159,0.0058338,0.0058956,0.0036616,0.0048847,0.004157,0.0058456,0.0059055,0.003675,0.0048796,0.0041403,0.0058476,0.0059123,0.0036823,0.0048678,0.0041312,0.0058551,0.0058962,0.0036938,0.0049007,0.0041516,0.0058364,0.0058973,0.0036882,0.0048732,0.0041432,0.0058637,0.0059007,0.0036738,0.0048483,0.0041165,0.0058475,0.0059053,0.0036872,0.0048595,0.004124,0.005879,0.0059006,0.0037095,0.0048327,0.0041052,0.0058637,0.0058986,0.00369,0.0048619,0.0041092,0.0058665,0.0059112,0.0036985,0.0048393,0.0041131,0.0058574,0.0059001,0.0036991,0.004831,0.0041048,0.0058579,0.0058772,0.0036975,0.0048483,0.0040975,0.0058584,0.0059085,0.0037241,0.0048392,0.0040899,0.0058477,0.0058993,0.0037057,0.0048473,0.0040797,0.0058775,0.0059217,0.0037181,0.0048575,0.0040929,0.0058633,0.005909,0.003734,0.0048591,0.0040739,0.0058913,0.0059264,0.0037369,0.0048272,0.0040657,0.0058734,0.0059164,0.0037382,0.0048567,0.0040685,0.0058877,0.0059207,0.0037421,0.0048431,0.0040507,0.0058767,0.0058921,0.0037373,0.0048294,0.0040399,0.0058817,0.0059141,0.0037547,0.0048466,0.0040451,0.0059084,0.0059201,0.0037525,0.0048323,0.004045,0.0059001,0.0059113,0.0037619,0.0048448,0.0040156,0.0058894,0.0059166,0.003767,0.0048342,0.0040302,0.0058987,0.0059087,0.0037542,0.0048308,0.0040169,0.0058929,0.005916,0.0037859,0.0048555,0.0040081,0.0059145,0.0059015,0.0037717,0.0048345,0.0040158,0.0058999,0.0059122,0.0037775,0.0048336,0.0040041,0.0058795,0.0059242,0.0037897,0.0048384,0.0040147,0.005919,0.0059133,0.0038027,0.0048531,0.0040029,0.0059148,0.0059239,0.003807,0.0048356,0.0039942,0.0059122,0.00592,0.0038071,0.0048192,0.003994,0.0059134,0.0059243,0.003811,0.0048542,0.0039611,0.0059164,0.0059259,0.0038378,0.004839,0.0039714,0.0059169,0.0059364,0.0038191,0.004824,0.0039786,0.0059238,0.0059277,0.0038587,0.0048587,0.0:4
2.1267E-6,-7.9E-7,3.11E-6,3.4667E-7,1.2267E-6,2.6067E-6,-1.4333E-6,2.91E-6,3.5667E-7,1.4E-7,1.7467E-6,-1.3E-6,2.7733E-6,7.5333E-7,5.5667E-7,2.68E-6,-1.1933E-6,2.4667E-6,3.3E-7,1.4233E-6,1.89E-6,-9.8667E-7,2.21E-6,-1.8333E-7,1.23E-6,2.3167E-6,-1.2E-6,2.3433E-6,9.3667E-7,-1.2E-7,2.81E-6,-2.79E-6,1.3033E-6,7.3667E-7,7.7667E-7,1.6067E-6,-2.27E-6,2.1333E-6,-4.5667E-7,1.08E-6,1.5133E-6,-4.8333E-7,1.3367E-6,1.2E-6,-9.7013E-14,2.5033E-6,0.0072723,0.0024984,0.0064923,0.0062611,0.0032014,0.0055616,0.003672,0.006156,0.006104,0.0036821,0.0051185,0.0040026,0.0060781,0.0060689,0.0038189,0.0049923,0.0040943,0.0060178,0.0060584,0.0038504,0.0049604,0.0041003,0.0060069,0.0060233,0.0038548,0.0049213,0.0041026,0.0059925,0.0060354,0.0038478,0.0049184,0.0040845,0.0059762,0.0060113,0.00384,0.0049184,0.0040871,0.005977,0.006,0.0038518,0.0048909,0.0040602,0.0059923,0.0059997,0.0038408,0.0048939,0.004055,0.0059763,0.0059779,0.0038506,0.0048809,0.0040387,0.005965,0.0059861,0.0038498,0.0048623,0.004038,0.0059702,0.0059657,0.003848,0.0048578,0.0040334,0.0059475,0.0059526,0.0038372,0.0048681,0.004019,0.0059569,0.0059728,0.0038346,0.0048517,0.0040166,0.0059461,0.0059549,0.0038367,0.0048622,0.0040041,0.005946,0.0059252,0.0038288,0.0048537,0.0040001,0.0059343,0.0059486,0.0038531,0.0048547,0.0039814,0.0059351,0.0059497,0.0038391,0.0048563,0.0039926,0.0059412,0.0059292,0.0038538,0.0048609,0.0039957,0.0059365,0.0059334,0.0038617,0.0048629,0.0039937,0.00592,0.0059502,0.0038536,0.0048585,0.0039768,0.0059283,0.0059576,0.0038541,0.0048783,0.0039716,0.0059311,0.0059137,0.0038682,0.0048663,0.0039601,0.0059341,0.0059451,0.0038676,0.0048669,0.0039734,0.0059233,0.0059278,0.0038772,0.0048544,0.0039534,0.005922,0.0059449,0.0038792,0.0048411,0.0039633,0.0059471,0.0059352,0.0038962,0.004858,0.0039533,0.0059418,0.0059359,0.0038764,0.004861,0.0039539,0.0059406,0.0059521,0.0038935,0.0048756,0.0039415,0.0059485,0.0059458,0.0038907,0.0048645,0.0039513,0.0059456,0.0059484,0.0038825,0.0048574,0.0039362,0.0059611,0.0059407,0.0039006,0.0048586,0.0039386,0.0059348,0.0059303,0.0039162,0.0048531,0.003943,0.0059447,0.0059316,0.0039121,0.0048651,0.0039176,0.0059338,0.0058966,0.00392,0.0048587,0.0039185,0.005951,0.0059203,0.0039181,0.0048399,0.0039233,0.0059127,0.0059213,0.0039223,0.0048331,0.0039095,0.0059279,0.0059194,0.0039162,0.0048436,0.0039026,0.0059633,0.0059228,0.0039397,0.0048633,0.0039122,0.0059503,0.005917,0.0039341,0.0048516,0.0039216,0.0059493,0.0059123,0.0039342,0.0048445,0.0038926,0.0059251,0.0059188,0.0039232,0.0048215,0.0038905,0.0059232,0.0059031,0.0039336,0.0048505,0.0039014,0.0059203,0.0059149,0.0039523,0.0048551,0.0039069,0.0059439,0.0059147,0.0039295,0.0048321,0.003889,0.0059165,0.0059208,0.0039747,0.0048761,0.0038915,0.00593,0.0059099,0.0039708,0.0048382,0.0038898,0.0059253,0.0058932,0.0039665,0.0048468,0.0038686,0.0059345,0.005899,0.0039842,0.0048434,0.0038782,0.0059372,0.0059114,0.003976,0.0048542,0.0038843,0.0059472,0.0059089,0.0039754,0.00483,0.0038668,0.0059237,0.0059134,0.0039819,0.0048288,0.0038567,0.0059109,0.0058984,0.0039927,0.0048381,0.0038636,0.0059257,0.0058863,0.0039766,0.0048426,0.0038561,0.0059535,0.0058947,0.0039874,0.0048402,0.003853,0.005916,0.0059024,0.0040049,0.004852,0.0038401,0.005916,0.0058781,0.004007,0.004867,0.0038476,0.0059354,0.0058875,0.004009,0.0048534,0.0038353,0.005931,0.0058869,0.0040155,0.0048534,0.0038435,0.0059324,0.005861,0.004021,0.0048471,0.0038242,0.0059381,0.0058893,0.0040285,0.0048505,0.0038163,0.005945,0.0058511,0.0040324,0.0048433,0.0038207,0.0059257,0.0058409,0.0040496,0.0048515,0.0038243,0.0059261,0.0058699,0.0040308,0.0048533,0.0037995,0.0059277,0.0058676,0.0040582,0.0048612,0.003817,0.0059083,0.0058485,0.0040633,0.0040974:4
-4.8745E-4,-5.7971E-4,0.0013752,-0.0013043,9.9648E-4,-4.764E-4,-9.1342E-4,0.0013571,-9.6427E-4,7.2255E-4,8.8207E-5,-5.517E-4,8.9102E-4,-0.001625,9.9502E-4,-5.7757E-5,-5.1347E-4,0.0014256,-0.0014787,5.0933E-4,2.4632E-4,-5.3257E-4,0.0012249,-0.0013117,4.6677E-4,-6.4288E-4,-2.0552E-4,7.7758,11.822,12.516,15.026,14.935,11.997,11.207,12.398,14.627,14.547,11.792,10.946,12.27,14.402,14.315,11.647,10.797,12.164,14.259,14.181,11.555,10.719,12.103,14.185,14.105,11.494,10.671,12.062,14.126,14.045,11.446,10.635,12.021,14.088,13.99,11.411,10.605,12.0,14.057,13.96,11.384,10.592,11.987,14.044,13.942,11.368,10.58,11.974,14.034,13.922,11.353,10.572,11.966,14.019,13.911,11.343,10.565,11.964,14.014,13.903,11.329,10.559,11.957,14.004,13.892,11.33,10.559,11.953,13.994,13.893,11.309,10.546,11.943,13.983,13.876,11.303,10.54,11.934,13.976,13.865,11.293,10.541,11.923,13.98,13.854,11.285,10.533,11.926,13.978,13.851,11.286,10.532,11.926,13.973,13.838,11.28,10.524,11.918,13.961,13.826,11.277,10.514,11.923,13.956,13.819,11.269,10.513,11.917,13.955,13.816,11.264,10.507,11.925,13.952,13.816,11.26,10.51,11.918,13.938,13.814,11.252,10.506,11.912,13.938,13.814,11.241,10.509,11.918,13.933,13.811,11.229,10.501,11.905,13.93,13.801,11.229,10.503,11.905,13.92,13.793,11.229,10.506,11.904,13.936,13.78,11.226,10.503,11.9,13.939,13.777,11.217,10.497,11.898,13.944,13.77,11.225,10.496,11.908,13.936,13.76,11.222,10.489,11.91,13.942,13.762,11.224,10.496,11.913,13.926,13.759,11.213,10.486,11.908,0.0:4
-0.0057885,0.0029287,-0.0031287,-0.0047492,0.006596,-0.0093255,0.0036685,-0.0029253,-0.0031721,0.0034213,-0.0079906,0.0032162,-0.0036216,0.00108,0.0027783,-0.0054276,0.0040601,-0.0022427,-0.0012718,0.00368,-0.0057521,0.002997,-0.0030386,-0.0027631,0.0041369,-0.0077755,0.0021094,-0.0034489,52.577,80.856,65.597,78.507,88.271,90.877,76.963,66.887,76.108,88.071,89.859,75.486,66.963,75.162,87.608,89.057,74.686,66.668,74.59,87.167,88.558,74.333,66.535,74.454,87.028,88.447,74.191,66.378,74.386,86.945,88.311,74.165,66.357,74.308,86.773,88.337,74.051,66.413,74.377,86.875,88.348,74.033,66.398,74.352,86.895,88.302,74.035,66.4,74.365,86.857,88.268,74.042,66.493,74.497,87.007,88.404,74.149,66.545,74.355,86.942,88.467,74.153,66.529,74.469,87.1,88.465,74.257,66.606,74.458,87.118,88.476,74.24,66.616,74.588,87.216,88.636,74.368,66.672,74.643,87.233,88.579,74.401,66.673,74.649,87.295,88.78,74.483,66.684,74.647,87.268,88.687,74.547,66.754,74.655,87.233,88.796,74.573,66.719,74.652,87.231,88.792,74.541,66.741,74.606,87.159,88.684,74.488,66.658,74.582,87.252,88.813,74.594,66.761,74.728,87.356,88.998,74.756,66.862,74.751,87.454,88.94,74.748,66.917,74.828,87.48,89.127,74.822,66.958,74.864,87.549,89.084,74.821,66.965,74.87,87.51,89.088,74.904,67.065,74.911,87.653,89.252,75.048,67.02,74.898,87.543,89.233,74.996,67.005,74.857,87.547,89.297,75.005,67.125,75.065,87.63,89.377,75.127,67.09,74.932,87.588,89.437,75.16,67.207,75.109,87.728,89.472,75.226,67.221,75.108,87.803,89.511,75.3,0.0:4
7.9333E-5,7.6273E-4,-9.872E-4,0.0014131,3.167E-5,-1.9785E-4,8.9083E-4,-9.9227E-4,6.3783E-4,-4.2397E-4,2.194E-5,9.0218E-4,-0.0011881,0.72696,9.884,10.669,9.2146,7.7079,8.6337,10.127,10.679,9.0533,7.8601,8.4539,10.137,10.659,9.0103,7.8899,8.3727,10.1,10.628,8.9894,7.8756,8.3136,10.051,10.605,8.9845,7.865,8.272,10.026,10.598,8.9929,7.866,8.2403,9.9841,10.585,9.0015,7.8559,8.2159,9.9571,10.588,9.021,7.86,8.1923,9.9339,10.595,9.0436,7.8649,8.1697,9.9072,10.591,9.0594,7.8578,8.1395,9.875,10.575,9.071,7.857,8.1117,9.8567,10.572,9.0917,7.8655,8.0962,9.8354,10.576,9.116,7.8709,8.0796,9.8101,10.581,9.1396,7.8757,8.0675,9.7972,10.588,9.1639,7.8792,8.0505,9.7764,10.578,9.1896,7.8854,8.0305,9.748,10.596,9.2127,7.8978,8.0141,9.7353,10.599,9.2436,7.9158,8.0057,9.7226,10.605,9.2702,7.9201,7.9818,9.6982,10.597,9.2997,7.9324,7.97,9.6744,10.611,9.3269,7.9518,7.9577,9.663,10.606,9.3553,7.9693,7.9431,9.6447,10.609,9.3802,7.9754,7.9328,9.6234,10.606,9.406,7.984,7.9099,9.5982,10.591,9.4269,7.9888,7.8914,9.5729,10.59,9.4512,8.0027,7.8846,9.5483,10.591,9.4792,8.0161,7.8704,9.535,10.596,9.5096,8.0319,7.8565,9.5152,10.591,9.533,8.0431,7.8318,9.4928,10.59,9.5542,8.0563,7.8275,9.4741,10.586,9.5846,8.0803,7.8146,9.4545,10.578,9.6061,8.0914,7.8085,9.4372,10.574,9.6348,8.1087,7.791,9.4222,10.565,9.6637,8.1211,7.7841,9.4017,10.559,9.6923,8.1337,7.7687,9.3815,10.547,9.7146,8.1519,7.7651,9.3559,10.536,9.7374,8.1647,7.7487,9.3336,0.0:4
7.2201E-4,3.5394E-4,-7.2286E-4,0.0012533,-0.0014312,8.8804E-4,2.2266E-4,-0.0010489,0.0012739,-0.0013849,5.9192E-4,3.5103E-4,-9.0067E-4,0.0013927,-0.0011049,6.8854E-4,5.7805E-4,-0.0010006,0.001577,-8.821E-4,6.6323E-4,6.0191E-4,-6.6607E-4,9.4925E-4,-6.3587E-4,6.6488E-4,-4.218E-5,-7.9142E-4,0.0014927,0.58634,10.892,12.126,10.783,8.5282,9.7932,11.175,12.104,10.619,8.7104,9.5947,11.187,12.056,10.549,8.7383,9.4876,11.145,12.017,10.533,8.7212,9.4125,11.084,11.988,10.528,8.709,9.3707,11.038,11.969,10.534,8.6984,9.3343,10.999,11.949,10.539,8.6958,9.2954,10.944,11.92,10.545,8.6938,9.2594,10.908,11.903,10.556,8.6942,9.2344,10.871,11.897,10.571,8.6958,9.2029,10.829,11.883,10.593,8.7001,9.186,10.81,11.885,10.612,8.6976,9.1624,10.781,11.89,10.641,8.7157,9.1447,10.751,11.88,10.653,8.7141,9.1189,10.715,11.871,10.682,8.7254,9.1037,10.686,11.879,10.71,8.734,9.0827,10.662,11.86,10.731,8.7489,9.0698,10.643,11.864,10.757,8.7545,9.0511,10.614,11.861,10.786,8.776,9.0443,10.595,11.861,10.815,8.7936,9.0277,10.568,11.864,10.84,8.8092,9.0078,10.541,11.852,10.876,8.8252,8.999,10.524,11.855,10.895,8.8331,8.9777,10.483,11.825,10.903,8.8459,8.9571,10.442,11.822,10.934,8.8525,8.936,10.426,11.812,10.961,8.8686,8.9265,10.401,11.828,10.993,8.902,8.9223,10.387,11.82,11.021,8.9067,8.9127,10.357,11.816,11.043,8.9293,8.8949,10.325,11.79,11.059,8.9421,8.8768,10.294,11.793,11.092,8.9642,8.8678,10.272,11.791,11.107,8.9801,8.8612,10.251,11.773,11.137,8.9975,8.854,10.223,11.776,11.158,9.0134,8.8336,0.0:4
0.0011167,-0.0013999,0.0016248,-6.5544E-4,-7.4227E-5,0.0010686,-0.0011766,9.5637E-4,-6.8806E-4,-1.0114E-4,0.0010711,-9.2407E-4,0.0011036,-4.8051E-4,1.7593E-4,9.567E-4,-0.0010543,9.7489E-4,-6.735E-4,-4.4873E-4,7.8984,9.8618,9.0471,11.543,12.465,11.069,9.5216,9.2419,11.346,12.448,11.114,9.427,9.2576,11.251,12.396,11.093,9.3696,9.2154,11.158,12.354,11.092,9.3512,9.1816,11.111,12.312,11.093,9.333,9.1445,11.058,12.27,11.08,9.3209,9.1132,11.012,12.246,11.088,9.3156,9.0818,10.964,12.229,11.11,9.3178,9.0507,10.939,12.211,11.115,9.3279,9.0326,10.908,12.194,11.133,9.3366,9.0228,10.886,12.182,11.154,9.3444,9.0028,10.854,12.178,11.16,9.3508,8.9743,10.827,12.159,11.197,9.3643,8.9722,10.803,12.16,11.219,9.3767,8.9539,10.772,12.139,11.232,9.3862,8.9371,10.744,12.117,11.254,9.4017,8.9236,10.718,12.116,11.265,9.409,8.9098,10.688,12.106,11.296,9.4304,8.9066,10.681,12.094,11.319,9.4349,8.8906,10.654,12.09,11.345,9.4575,8.8736,10.629,12.075,11.359,9.4702,8.8628,10.6,12.062,11.372,9.4889,8.8563,10.579,12.044,11.397,9.4989,8.8358,10.554,12.028,11.417,9.519,8.8374,10.537,12.037,11.443,9.5336,8.8201,10.505,12.012,11.464,9.5526,8.8229,10.493,12.009,11.491,9.5765,8.8169,10.477,12.01,11.508,9.5926,8.8119,10.45,11.987,11.53,9.6148,8.7962,10.427,11.981,11.538,9.6182,8.7746,10.394,11.96,11.559,9.6432,8.7828,10.376,11.953,11.58,9.6643,8.7746,10.354,11.93,11.594,9.673,8.7552,10.319,11.906,11.603,9.6969,8.7575,10.3,11.899,11.637,9.7159,8.7536,10.279,11.893,0.0:4
3.7882E-4,0.0013322,-0.001412,0.0016176,-6.8814E-4,7.7208E-4,8.6857E-4,-0.0011752,0.0010715,-0.0010966,9.3469E-4,9.0688E-4,-3.4151E-4,0.0013512,-6.6108E-4,8.7648E-4,8.1411E-4,-0.0011594,0.0016574,-1.3153E-4,5.9493E-4,4.8702E-4,-4.5565E-4,0.0014133,-7.0477E-4,1.8267E-4,4.6156E-4,-7.3088E-4,11.243,14.972,16.312,16.836,14.558,12.154,14.406,16.481,16.853,14.344,12.306,14.214,16.491,16.826,14.271,12.329,14.144,16.831,18.214,17.894,16.88,18.634,21.792,21.516,17.524,14.46,16.237,18.917,19.331,16.238,14.021,15.979,18.669,19.139,16.217,14.047,16.026,18.698,19.172,16.239,14.054,16.009,18.691,19.191,16.238,14.055,16.0,18.683,19.188,16.238,14.053,15.978,18.662,19.163,16.222,14.035,15.951,18.659,19.171,16.242,14.046,15.941,18.645,19.157,16.233,14.019,15.912,18.624,19.161,16.237,14.028,15.928,18.613,19.154,16.243,14.014,15.906,18.608,19.167,16.255,14.023,15.906,18.601,19.158,16.249,14.013,15.884,18.585,19.156,16.249,14.014,15.884,18.576,19.168,16.265,14.023,15.876,18.591,19.178,16.276,14.03,15.87,18.583,19.184,16.281,14.034,15.872,18.587,19.198,16.299,14.036,15.856,18.583,19.192,16.317,14.037,15.862,18.576,19.189,16.332,14.034,15.871,18.577,19.211,16.34,14.047,15.861,18.565,19.224,16.346,14.043,15.855,18.55,19.235,16.333,14.032,15.819,18.53,19.219,16.334,14.039,15.814,18.521,19.222,16.337,14.035,15.8,18.521,19.214,16.349,14.039,15.8,18.522,19.22,16.355,14.025,15.781,18.501,19.211,16.351,14.023,15.767,18.495,19.209,16.373,14.031,15.763,18.487,19.222,16.373,14.018,15.751,0.0:4
-0.019017,0.0044569,-0.018321,-0.010664,8.8886E-4,-0.018907,0.0070092,-0.011051,-0.0071175,-0.0049616,-0.025565,0.0059973,-0.015924,-0.0088208,0.0023568,0.98354,21.28,9.6784,16.856,18.155,8.1169,16.268,11.998,16.465,17.328,9.224,15.341,12.465,16.321,17.12,9.437,15.083,12.525,16.296,17.045,9.475,14.987,12.519,16.235,16.999,9.4623,14.956,12.496,16.207,16.995,9.448,14.933,12.477,16.208,16.975,9.4407,14.923,12.446,16.206,16.985,9.4434,14.902,12.414,16.225,16.959,9.438,14.886,12.385,16.229,16.953,9.4372,14.877,12.372,16.226,16.947,9.4401,14.85,12.352,16.219,16.94,9.4253,14.843,12.335,16.228,16.947,9.429,14.833,12.323,16.217,16.938,9.4254,14.824,12.302,16.211,16.936,9.4112,14.813,12.288,16.23,16.935,9.4313,14.815,12.288,16.222,16.933,9.4312,14.798,12.269,16.226,16.932,9.433,14.801,12.263,16.239,16.95,9.4295,14.796,12.238,16.26,16.937,9.4412,14.786,12.242,16.261,16.939,9.44,14.781,12.227,16.259,16.938,9.4435,14.77,12.222,16.266,16.937,9.4465,14.748,12.213,16.252,16.94,9.4524,14.751,12.204,16.245,16.946,9.4449,14.757,12.188,16.275,16.964,9.4506,14.754,12.177,16.298,16.966,9.4599,14.751,12.148,16.321,16.957,9.4702,14.743,12.161,16.329,16.973,9.4688,14.756,12.15,16.325,16.967,9.4717,14.741,12.138,16.328,16.992,9.4827,14.735,12.134,16.351,16.98,9.483,14.737,12.118,16.353,16.971,9.4931,14.716,12.11,16.331,16.976,9.4822,14.72,12.098,16.344,16.982,9.4819,14.717,12.111,16.349,16.996,9.4952,14.716,12.094,16.363,16.999,0.0:4
9.8551E-4,-0.019245,0.011007,-0.012846,-0.0033333,0.0060886,-0.015529,0.0066782,-0.008306,-0.01476,-0.0026022,-0.019893,0.0086134,-0.018456,-0.00703,14.699,3.9018,19.647,11.438,15.96,17.766,8.2733,16.352,12.928,15.849,16.994,9.1339,15.656,13.265,15.749,16.826,9.2978,15.479,13.276,15.73,16.742,9.3076,15.401,13.274,15.671,16.707,9.2987,15.369,13.27,15.645,16.676,9.2842,15.36,13.235,15.628,16.655,9.2675,15.357,13.22,15.63,16.625,9.2627,15.35,13.226,15.598,16.602,9.2424,15.334,13.226,15.574,16.593,9.2477,15.332,13.229,15.551,16.59,9.2417,15.324,13.224,15.541,16.581,9.2368,15.327,13.231,15.543,16.574,9.2277,15.332,13.231,15.532,16.558,9.2269,15.324,13.233,15.527,16.555,9.2149,15.325,13.241,15.511,16.543,9.2229,15.321,13.232,15.507,16.536,9.2137,15.316,13.242,15.493,16.529,9.2145,15.336,13.247,15.482,16.523,9.2157,15.335,13.236,15.485,16.507,9.2098,15.331,13.258,15.477,16.507,9.2037,15.339,13.265,15.455,16.493,9.21,15.328,13.266,15.436,16.495,9.2033,15.334,13.271,15.442,16.488,9.2031,15.341,13.279,15.452,16.501,9.2119,15.344,13.29,15.436,16.49,9.2048,15.359,13.309,15.423,16.474,9.2015,15.351,13.305,15.421,16.47,9.1954,15.349,13.321,15.397,16.452,9.186,15.331,13.292,15.373,16.455,9.1809,15.34,13.294,15.377,16.441,9.1848,15.345,13.283,15.387,16.435,9.1845,15.35,13.297,15.375,16.432,9.1792,15.357,13.329,15.372,16.429,9.1885,15.373,13.355,15.353,16.436,9.1885,15.377,13.366,15.349,16.433,9.1874,15.394,13.374,15.345,0.0:4
-0.020785,-0.0019151,-0.0085789,-0.011947,0.0046833,-0.015244,-0.0019008,-0.0078402,-0.019742,0.0073226,-0.015019,-0.0014828,-0.010472,-0.015075,0.0081128,-0.019922,-0.0011849,-0.010072,-0.01114,0.0084428,-0.022246,0.0029583,-0.0050216,-0.018204,0.0031699,-0.016166,12.495,15.158,11.145,17.543,7.744,18.363,16.026,12.343,15.51,9.3526,17.435,16.139,12.566,15.045,9.6723,17.244,16.173,12.561,14.951,9.7253,17.169,16.148,12.511,14.881,9.7187,17.146,16.116,12.506,14.863,9.712,17.095,16.093,12.47,14.824,9.6971,17.079,16.09,12.44,14.81,9.689,17.067,16.071,12.433,14.782,9.6861,17.044,16.086,12.386,14.783,9.6859,17.041,16.079,12.379,14.789,9.6896,17.043,16.084,12.377,14.77,9.6892,17.049,16.084,12.356,14.761,9.6919,17.038,16.078,12.354,14.747,9.6952,17.032,16.093,12.325,14.745,9.6935,17.033,16.094,12.306,14.739,9.7,17.045,16.107,12.304,14.738,9.7046,17.052,16.117,12.303,14.724,9.7028,17.06,16.119,12.278,14.727,9.706,17.045,16.135,12.264,14.714,9.7057,17.058,16.125,12.262,14.721,9.7124,17.067,16.139,12.253,14.713,9.7163,17.051,16.141,12.252,14.713,9.7173,17.06,16.157,12.222,14.709,9.7331,17.065,16.147,12.23,14.687,9.7332,17.059,16.148,12.217,14.689,9.7305,17.051,16.166,12.191,14.682,9.73,17.052,16.173,12.184,14.673,9.7368,17.064,16.189,12.173,14.69,9.744,17.076,16.209,12.155,14.7,9.7545,17.094,16.202,12.16,14.682,9.7509,17.082,16.211,12.146,14.661,9.7558,17.069,16.189,12.132,14.65,9.7623,17.078,16.212,12.109,14.648,9.7655,17.075,16.217,12.105,14.657,0.0:4
4.587E-4,0.0012397,-0.0017391,0.0021035,-5.6556E-4,1.6333E-4,0.0026337,-0.0021082,0.0024901,-0.0015525,-4.1776E-4,0.0019364,-0.0023809,0.0027659,-0.0019995,5.1567,9.0719,7.2653,7.1241,8.1522,9.4224,8.9247,7.3508,6.9457,8.1799,9.339,8.8492,7.3452,6.8802,8.1685,9.2965,8.7945,7.3134,6.835,8.1415,9.2541,8.7597,7.2884,6.8091,8.1236,9.216,8.7319,7.2564,6.7864,8.1089,9.1835,8.7103,7.2366,6.778,8.0988,9.1609,8.6984,7.2071,6.7654,8.0762,9.1403,8.6713,7.1824,6.7605,8.0563,9.1358,8.6578,7.1647,6.7532,8.0419,9.1367,8.6365,7.152,6.7499,8.0305,9.1341,8.6168,7.1424,6.7419,8.0215,9.1328,8.5948,7.1366,6.7338,8.0226,9.136,8.5804,7.1346,6.7262,8.0256,9.1307,8.5659,7.1306,6.7207,8.0298,9.1185,8.5589,7.1277,6.7165,8.0348,9.1032,8.56,7.122,6.7144,8.0509,9.0929,8.559,7.1161,6.7126,8.0494,9.0819,8.5522,7.1009,6.7137,8.0444,9.0798,8.5473,7.0873,6.7176,8.0365,9.0821,8.5424,7.0777,6.721,8.0331,9.0831,8.5334,7.0738,6.7237,8.0263,9.0896,8.5189,7.0682,6.7214,8.0167,9.0909,8.507,7.0644,6.7217,8.0222,9.0982,8.4939,7.0628,6.7155,8.0295,9.1033,8.4852,7.0623,6.7146,8.0356,9.0929,8.4724,7.0611,6.7067,8.0441,9.0846,8.4781,7.0574,6.7037,8.0529,9.0803,8.4728,7.0491,6.7086,8.0571,9.0704,8.4728,7.0414,6.7084,8.0559,9.0642,8.4727,7.0358,6.7145,8.0568,9.0704,8.4704,7.0269,6.7198,8.0529,9.0735,8.4663,7.025,6.7274,8.0523,9.073,8.4534,7.0219,6.7306,8.0514,9.0923,8.4512,7.0246,6.7314,8.0524,9.0928,8.4403,7.0224,6.7292,8.0542,9.0936,8.4232,7.0161,6.7233,8.0566,0.0:4
0.0036181,-0.0033961,0.0015204,1.8221E-4,-0.0021191,0.0034336,-0.0037677,0.0012174,-3.6391E-4,-0.002416,0.0035042,-0.0025828,9.0645E-4,2.2284E-5,-0.0019736,0.0037653,-0.0031177,0.0020107,0.0013614,-0.0018076,8.1974,10.5,11.744,12.761,11.202,9.1576,10.138,11.798,12.694,11.065,9.1889,10.011,11.745,12.632,10.998,9.1711,9.9531,11.694,12.592,10.941,9.1425,9.8987,11.655,12.557,10.897,9.1166,9.8569,11.623,12.529,10.866,9.0976,9.8218,11.594,12.488,10.837,9.0753,9.7875,11.569,12.442,10.812,9.0502,9.7555,11.553,12.412,10.801,9.0374,9.7365,11.536,12.393,10.796,9.026,9.7309,11.513,12.377,10.789,9.0078,9.7133,11.492,12.35,10.772,8.9908,9.7014,11.481,12.344,10.771,8.9818,9.7029,11.464,12.351,10.765,8.9757,9.6906,11.44,12.34,10.76,8.9755,9.689,11.434,12.351,10.755,8.9774,9.6868,11.44,12.353,10.759,8.981,9.6822,11.439,12.353,10.753,8.9798,9.6713,11.437,12.347,10.754,8.9835,9.6661,11.438,12.343,10.753,8.982,9.658,11.423,12.339,10.753,8.9845,9.6521,11.435,12.326,10.756,8.9826,9.6503,11.435,12.317,10.761,8.9792,9.6447,11.43,12.321,10.766,8.978,9.6502,11.425,12.32,10.775,8.9813,9.6569,11.419,12.333,10.781,8.9756,9.6569,11.413,12.333,10.784,8.9701,9.6567,11.4,12.338,10.775,8.9645,9.6413,11.375,12.32,10.758,8.9609,9.6294,11.367,12.331,10.761,8.964,9.6217,11.366,12.344,10.761,8.9783,9.6181,11.377,12.335,10.762,8.9793,9.6034,11.371,12.316,10.765,8.976,9.5915,11.374,12.3,10.768,8.974,9.5844,11.373,12.297,10.784,8.9782,9.5895,11.373,12.299,10.797,0.0:4
0.013603,-0.011084,0.02708,-2.3336E-4,0.012994,0.019538,-0.014088,0.030075,-0.0046855,0.0063934,0.021283,-0.01094,0.029655,-0.0034795,0.01404,0.022239,-0.01402,0.024967,-0.0010576,0.0077207,0.027856,-0.012194,0.03199,-0.0084255,0.016505,0.020246,-0.012384,0.021687,0.0053136,0.007109,0.026383,-0.012168,0.034218,0.0048118,0.013514,0.020909,-0.0092724,0.028124,2.5806E-4,0.0078939,0.022526,-0.017485,0.024539,-0.0036533,0.014198,0.019247,-0.0087935,0.024358,-0.0016212,0.013084,0.020801,-0.013267,0.026105,-0.0047725,0.012025,0.015704,-0.0072,0.026197,0.0020232,0.013102,0.01351,-0.012972,0.022167,-2.73E-4,41.058,52.341,95.681,30.39,93.89,75.573,61.813,78.889,44.176,85.68,77.046,64.069,74.366,47.769,83.442,77.386,64.613,73.152,48.603,82.885,77.256,64.776,72.952,48.736,82.505,77.174,64.827,72.721,48.649,82.42,76.881,64.81,72.769,48.568,82.255,76.882,64.929,72.69,48.522,82.163,76.626,64.933,72.645,48.413,82.001,76.551,65.007,72.728,48.376,82.04,76.482,65.083,72.776,48.293,81.827,76.3,65.091,72.641,48.188,81.816,76.197,65.209,72.844,48.199,81.77,76.192,65.277,72.81,48.132,81.741,75.992,65.304,72.851,48.086,81.662,76.01,65.489,72.944,48.069,81.68,75.887,65.57,72.974,48.018,81.552,75.803,65.685,72.98,47.981,81.582,75.68,65.705,73.054,47.929,81.39,75.591,65.817,73.123,47.922,81.528,75.565,65.957,73.217,47.915,81.448,75.564,66.112,73.227,47.898,81.487,75.446,66.166,73.27,47.835,81.326,75.367,66.293,73.341,47.816,81.337,75.277,66.391,73.414,47.781,81.251,75.252,66.481,73.395,47.76,81.288,75.103,66.559,73.527,47.728,81.173,75.109,0.0:4
-0.011988,0.027135,0.01298,0.0021355,0.031543,-0.0090166,0.032924,0.015274,-7.1709E-4,0.026242,-0.014976,0.030216,0.011058,6.4573E-4,0.021542,-0.010468,0.033859,0.0098685,-5.311E-5,0.026412,-0.011166,0.02514,0.011507,0.0047174,0.031288,-0.011881,0.023588,0.015471,6.6061E-4,0.029023,-0.013588,0.023239,0.012909,0.0049812,0.021084,104.51,38.753,88.592,89.009,41.436,79.026,53.015,83.937,85.388,47.734,72.644,56.658,82.772,84.331,49.351,70.945,57.411,82.373,84.098,49.703,70.454,57.542,82.294,84.01,49.8,70.275,57.43,82.201,83.824,49.789,70.143,57.298,82.173,83.808,49.783,70.08,57.143,82.155,83.826,49.811,69.921,57.031,82.178,83.791,49.849,69.95,56.904,82.188,83.768,49.863,69.833,56.811,82.165,83.686,49.894,69.778,56.673,82.129,83.735,49.892,69.674,56.584,82.188,83.641,49.937,69.732,56.476,82.181,83.705,49.987,69.574,56.358,82.12,83.712,50.042,69.62,56.301,82.215,83.642,50.039,69.472,56.197,82.21,83.688,50.133,69.544,56.114,82.265,83.712,50.166,69.429,56.043,82.352,83.681,50.233,69.533,55.936,82.342,83.71,50.299,69.472,55.872,82.433,83.679,50.333,69.518,55.826,82.484,83.742,50.422,69.46,55.769,82.481,83.715,50.479,69.425,55.66,82.45,83.659,50.502,69.38,55.576,82.477,83.615,50.548,69.273,55.449,82.489,83.67,50.631,69.257,55.417,82.511,83.671,50.702,69.331,55.34,82.469,83.645,50.762,69.279,55.262,82.595,83.641,50.844,69.238,55.09,82.591,83.294,50.896,69.142,54.977,82.554,83.306,50.933,69.213,54.952,82.654,83.41,51.027,69.196,54.928,82.609,83.638,51.084,0.0:4
-0.0067089,0.030401,0.008773,0.0090805,0.016192,-0.0085166,0.028214,-3.3334E-4,0.010564,0.022826,-0.012532,11.665,101.73,85.189,45.21,70.16,38.205,80.178,76.049,46.364,74.976,47.108,86.639,83.482,53.97,71.785,51.332,84.606,83.073,55.102,70.274,52.252,83.956,82.944,55.356,69.73,52.406,83.801,82.814,55.443,69.623,52.366,83.72,82.709,55.459,69.613,52.311,83.634,82.582,55.51,69.546,52.217,83.555,82.466,55.502,69.509,52.122,83.525,82.36,55.592,69.566,52.055,83.481,82.368,55.613,69.511,52.001,83.536,82.303,55.722,69.525,51.911,83.465,82.164,55.747,69.54,51.846,83.427,82.133,55.804,69.447,51.763,83.304,82.081,55.867,69.51,51.76,83.432,81.997,56.001,69.537,51.718,83.447,82.042,56.103,69.491,51.672,83.401,81.9,56.15,69.526,51.608,83.4,81.83,56.163,69.385,51.511,83.346,81.702,56.261,69.537,51.507,83.347,81.833,56.367,69.595,51.502,83.362,81.747,56.444,69.541,51.447,83.351,81.713,56.5,69.601,51.42,83.353,81.607,56.569,69.643,51.365,83.322,81.608,56.631,69.636,51.327,83.297,81.473,56.679,69.673,51.282,83.236,81.425,56.777,69.639,51.255,83.296,81.425,56.893,69.691,51.215,83.268,81.33,56.928,69.669,51.161,83.284,81.228,56.99,69.663,51.099,83.319,81.347,57.132,69.719,51.094,83.346,81.203,57.207,69.762,51.041,83.272,81.22,57.298,69.768,51.027,83.311,81.074,57.375,69.742,50.952,83.219,81.001,57.403,69.774,50.913,83.203,80.934,57.543,69.807,50.866,83.206,80.935,57.612,69.822,50.843,83.216,80.799,57.725,0.0:4
0.0021548,-0.025493,0.019901,-0.020566,-0.001772,0.0034701,-0.023287,0.015515,-0.024061,3.2369E-4,0.0060561,-0.024438,0.017138,-0.020741,0.0019592,0.0065113,-0.022424,0.015892,-0.021865,-0.010258,0.0046866,-0.022434,0.018247,-0.019142,-0.0032514,25.517,35.375,29.915,38.732,41.901,40.172,33.609,31.198,37.786,41.977,40.219,33.152,31.347,37.437,41.882,40.134,32.974,31.289,37.234,41.768,40.024,32.877,31.219,37.113,41.678,39.908,32.808,31.113,37.008,41.563,39.837,32.733,31.026,36.911,41.447,39.769,32.695,30.939,36.868,41.36,39.737,32.659,30.925,36.813,41.319,39.71,32.625,30.89,36.793,41.297,39.692,32.625,30.866,36.781,41.271,39.672,32.609,30.848,36.71,41.192,39.687,32.564,30.813,36.666,41.183,39.692,32.556,30.821,36.61,41.2,39.656,32.542,30.787,36.556,41.19,39.654,32.554,30.796,36.539,41.178,39.614,32.554,30.764,36.507,41.146,39.617,32.561,30.738,36.537,41.186,39.619,32.6,30.746,36.512,41.166,39.618,32.592,30.725,36.507,41.122,39.619,32.598,30.698,36.496,41.094,39.64,32.588,30.67,36.436,41.075,39.644,32.589,30.659,36.416,41.012,39.654,32.572,30.675,36.422,41.039,39.702,32.58,30.685,36.383,41.035,39.676,32.575,30.652,36.329,41.042,39.671,32.611,30.658,36.334,41.064,39.694,32.644,30.633,36.337,41.058,39.699,32.634,30.619,36.341,41.018,39.718,32.657,30.637,36.315,41.031,39.745,32.661,30.626,36.276,41.011,39.706,32.678,30.622,36.271,41.033,39.721,32.688,30.585,36.251,40.97,39.733,32.686,30.591,36.254,40.933,39.772,32.707,30.602,36.252,40.946,0.0:4
-0.028269,0.0088314,-0.0097163,-0.019338,0.019287,-0.023366,0.014395,-0.0055072,-0.018435,0.013482,-0.021622,0.013436,-0.0090359,-0.020946,0.014713,-0.02519,0.014364,-0.0034093,-0.011802,0.012482,-0.024591,0.010189,1.5914E-4,-0.016413,30.165,33.948,36.876,42.575,40.593,32.348,32.336,37.513,42.223,40.247,32.585,31.911,37.545,42.09,40.087,32.549,31.743,37.451,41.937,39.945,32.457,31.61,37.335,41.885,39.883,32.453,31.533,37.264,41.766,39.829,32.409,31.471,37.2,41.674,39.792,32.344,31.405,37.137,41.609,39.774,32.301,31.379,37.046,41.563,39.703,32.276,31.337,36.977,41.491,39.689,32.253,31.286,36.936,41.487,39.693,32.257,31.275,36.926,41.471,39.721,32.252,31.242,36.844,41.41,39.707,32.229,31.227,36.774,41.424,39.657,32.227,31.188,36.749,41.417,39.634,32.231,31.151,36.742,41.391,39.667,32.282,31.154,36.755,41.385,39.67,32.27,31.129,36.726,41.293,39.679,32.258,31.109,36.715,41.325,39.757,32.285,31.13,36.681,41.323,39.759,32.295,31.118,36.628,41.303,39.756,32.289,31.092,36.577,41.295,39.74,32.294,31.076,36.558,41.305,39.776,32.323,31.066,36.529,41.288,39.769,32.343,31.039,36.519,41.284,39.77,32.356,31.038,36.522,41.304,39.769,32.382,31.009,36.494,41.262,39.808,32.416,31.01,36.49,41.206,39.857,32.418,31.004,36.477,41.19,39.877,32.411,31.012,36.442,41.189,39.922,32.43,31.008,36.375,41.2,39.903,32.441,30.989,36.3,41.21,39.885,32.469,30.979,36.335,41.205,39.879,32.486,30.968,36.308,41.218,39.93,32.5,30.958,36.308,41.204,39.974,32.526,0.0:4
0.0032476,-0.007042,-0.012042,0.008888,-0.018681,-4.8196E-4,-0.0078577,-0.012953,0.0088133,-0.018831,-8.0463E-4,-0.007345,-0.0078277,0.0058936,-0.016609,0.001041,-0.0086884,-0.01586,0.0060955,-0.022438,2.2664E-4,-0.0055457,20.661,24.913,25.634,30.966,33.062,29.235,24.432,25.601,30.661,32.833,29.079,24.234,25.451,30.491,32.683,28.95,24.11,25.365,30.351,32.607,28.858,24.047,25.31,30.295,32.552,28.805,23.999,25.272,30.242,32.479,28.763,23.983,25.244,30.232,32.453,28.723,23.951,25.227,30.203,32.446,28.726,23.945,25.209,30.179,32.424,28.704,23.943,25.187,30.158,32.401,28.673,23.928,25.178,30.166,32.396,28.672,23.934,25.179,30.161,32.383,28.69,23.915,25.17,30.142,32.375,28.666,23.91,25.169,30.119,32.37,28.672,23.9,25.166,30.131,32.368,28.682,23.913,25.159,30.112,32.383,28.671,23.908,25.164,30.121,32.366,28.691,23.911,25.166,30.128,32.396,28.681,23.918,25.166,30.122,32.376,28.694,23.921,25.154,30.129,32.383,28.694,23.928,25.15,30.11,32.383,28.699,23.921,25.156,30.128,32.373,28.712,23.926,25.162,30.11,32.381,28.698,23.919,25.148,30.106,32.378,28.695,23.913,25.14,30.105,32.367,28.708,23.921,25.134,30.108,32.382,28.719,23.926,25.164,30.12,32.378,28.714,23.933,25.159,30.125,32.393,28.734,23.95,25.159,30.103,32.396,28.705,23.926,25.147,30.111,32.376,28.721,23.922,25.139,30.118,32.37,28.71,23.923,25.131,30.085,32.4,28.704,23.922,25.136,30.089,32.371,28.725,23.932,25.131,30.099,32.372,28.718,23.936,25.136,30.081,32.383,28.739,23.931,25.142,0.0:4
-0.024996,0.011014,-0.018325,0.0010822,-0.0033557,-0.018193,0.009432,-0.019878,1.9951E-4,-0.0044851,-0.016386,0.0078629,-0.022786,-0.0044965,-0.0097183,-0.013581,0.009534,-0.016019,-0.0039956,-0.0071914,-0.01866,0.0044145,-0.018459,-9.4309E-4,-0.0072908,21.811,25.468,25.817,32.008,32.792,27.727,24.227,26.269,31.462,32.482,27.772,23.899,26.257,31.243,32.353,27.66,23.782,26.173,31.12,32.254,27.587,23.688,26.105,31.012,32.174,27.548,23.654,26.044,30.958,32.117,27.49,23.592,25.989,30.876,32.097,27.474,23.593,25.968,30.886,32.096,27.479,23.579,25.966,30.856,32.084,27.473,23.565,25.944,30.857,32.069,27.47,23.573,25.935,30.856,32.055,27.484,23.576,25.92,30.834,32.086,27.489,23.565,25.896,30.827,32.062,27.492,23.572,25.9,30.813,32.076,27.507,23.574,25.887,30.827,32.07,27.522,23.578,25.87,30.81,32.075,27.514,23.573,25.873,30.798,32.062,27.524,23.57,25.848,30.768,32.062,27.522,23.559,25.85,30.784,32.042,27.548,23.555,25.835,30.765,32.071,27.545,23.559,25.86,30.769,32.073,27.553,23.559,25.834,30.754,32.099,27.562,23.568,25.848,30.721,32.096,27.56,23.56,25.813,30.739,32.078,27.567,23.572,25.814,30.71,32.104,27.563,23.574,25.793,30.733,32.09,27.575,23.588,25.795,30.743,32.106,27.573,23.591,25.787,30.73,32.09,27.604,23.587,25.78,30.76,32.097,27.628,23.603,25.788,30.737,32.101,27.635,23.586,25.793,30.726,32.093,27.65,23.578,25.78,30.726,32.124,27.65,23.591,25.785,30.697,32.116,27.682,23.592,25.774,30.699,32.145,27.682,23.598,25.772,30.701,32.157,0.0:4
-0.0028443,2.7911E-4,-0.017256,0.0049178,-0.018532,-0.001546,-0.0042515,-0.016462,0.0086949,-0.015959,-0.0074653,-0.008612,-0.013951,0.013644,-0.017461,-0.0059389,-0.0055204,-0.018738,21.667,28.565,31.715,32.284,27.476,23.653,27.325,31.785,32.094,27.095,23.765,27.036,31.708,32.029,26.983,23.729,26.9,31.592,31.951,26.886,23.661,26.8,31.508,31.909,26.873,23.612,26.708,31.435,31.851,26.842,23.578,26.651,31.4,31.853,26.862,23.552,26.603,31.327,31.846,26.868,23.553,26.563,31.306,31.836,26.864,23.534,26.516,31.289,31.842,26.869,23.538,26.489,31.277,31.813,26.91,23.536,26.469,31.221,31.843,26.937,23.525,26.441,31.221,31.847,26.95,23.517,26.428,31.2,31.854,26.994,23.523,26.401,31.167,31.895,27.01,23.523,26.377,31.165,31.897,27.045,23.531,26.356,31.117,31.93,27.064,23.529,26.327,31.112,31.915,27.077,23.537,26.292,31.085,31.933,27.097,23.53,26.265,31.084,31.918,27.106,23.528,26.228,31.072,31.94,27.146,23.525,26.211,31.078,31.93,27.173,23.537,26.189,31.033,31.955,27.221,23.537,26.187,31.043,31.96,27.242,23.539,26.171,31.004,31.988,27.276,23.532,26.151,30.989,31.996,27.301,23.539,26.134,30.958,32.019,27.316,23.543,26.12,30.957,32.024,27.344,23.552,26.09,30.924,32.061,27.352,23.562,26.055,30.939,32.041,27.388,23.57,26.039,30.907,32.066,27.396,23.573,26.007,30.912,32.045,27.448,23.578,25.986,30.878,32.084,27.463,23.573,25.965,30.875,32.071,27.499,23.577,25.952,30.857,32.074,27.514,23.571,25.927,30.826,32.064,27.534,23.572,25.904,0.0:4
-0.011958,0.0094133,-0.017009,-0.0038284,0.0042747,-0.0092548,0.0081025,-0.0082013,-0.0013847,0.0013077,-0.014487,0.013785,-0.016753,-0.0058075,0.0017684,-0.011204,0.01229,-0.014641,-0.0032157,0.0081076,-0.007563,0.015446,-0.0099047,-0.0022932,0.0053566,-0.012087,0.44209,32.654,40.78,39.884,31.588,30.631,34.276,39.89,39.194,31.921,29.733,34.354,39.43,38.819,31.77,29.397,34.171,39.125,38.54,31.59,29.18,33.973,38.917,38.382,31.43,29.03,33.852,38.749,38.212,31.294,28.913,33.736,38.609,38.061,31.176,28.814,33.631,38.496,37.984,31.111,28.766,33.543,38.401,37.907,31.034,28.721,33.475,38.349,37.836,30.99,28.674,33.427,38.314,37.785,30.959,28.654,33.4,38.274,37.752,30.941,28.616,33.374,38.236,37.722,30.892,28.596,33.353,38.209,37.699,30.871,28.575,33.335,38.178,37.673,30.861,28.553,33.321,38.167,37.659,30.855,28.559,33.307,38.148,37.636,30.845,28.542,33.302,38.159,37.651,30.838,28.547,33.305,38.186,37.654,30.841,28.567,33.324,38.167,37.654,30.842,28.56,33.315,38.159,37.64,30.823,28.544,33.313,38.157,37.637,30.823,28.551,33.302,38.152,37.636,30.815,28.532,33.277,38.108,37.604,30.809,28.529,33.28,38.111,37.624,30.801,28.529,33.277,38.129,37.605,30.806,28.53,33.271,38.134,37.604,30.814,28.531,33.279,38.129,37.6,30.8,28.522,33.278,38.122,37.601,30.805,28.513,33.275,38.118,37.607,30.803,28.523,33.284,38.135,37.603,30.79,28.521,33.283,38.116,37.592,30.783,28.503,33.27,38.105,37.591,30.788,28.509,33.26,38.099,37.568,30.789,28.504,33.244,38.101,37.571,0.0:4
-0.0065145,-0.0063909,0.011241,-0.018075,0.010201,-0.010091,-0.0095196,0.012938,-0.015142,0.0096407,-0.003047,-0.0052713,0.013005,-0.012184,0.0078224,-0.0028056,-0.0048232,0.011726,-0.014269,0.0033395,-0.0093019,-0.0087783,26.211,32.909,34.763,40.786,39.05,30.96,30.87,35.333,40.132,38.471,31.055,30.245,35.186,39.77,38.13,30.896,29.939,34.961,39.523,37.915,30.738,29.756,34.783,39.361,37.746,30.596,29.623,34.619,39.194,37.605,30.498,29.521,34.515,39.073,37.489,30.413,29.428,34.402,38.971,37.419,30.361,29.378,34.316,38.881,37.362,30.31,29.315,34.279,38.827,37.33,30.265,29.278,34.234,38.777,37.289,30.232,29.242,34.182,38.743,37.278,30.226,29.233,34.162,38.723,37.276,30.208,29.212,34.134,38.705,37.246,30.19,29.189,34.121,38.68,37.243,30.197,29.188,34.1,38.685,37.245,30.203,29.177,34.086,38.677,37.268,30.204,29.152,34.065,38.637,37.247,30.222,29.148,34.045,38.627,37.258,30.22,29.127,34.002,38.624,37.251,30.201,29.121,34.013,38.59,37.238,30.199,29.095,33.968,38.588,37.257,30.202,29.085,33.945,38.587,37.248,30.225,29.092,33.949,38.558,37.265,30.225,29.077,33.92,38.563,37.279,30.212,29.069,33.921,38.566,37.287,30.235,29.078,33.914,38.553,37.289,30.253,29.075,33.906,38.544,37.301,30.258,29.051,33.878,38.568,37.313,30.259,29.037,33.864,38.539,37.341,30.268,29.031,33.838,38.52,37.345,30.282,29.026,33.839,38.551,37.352,30.307,29.035,33.822,38.506,37.383,30.307,29.024,33.791,38.517,37.39,30.31,29.003,33.792,38.499,37.406,30.335,29.02,33.776,0.0:4
0.016817,-0.010986,0.0084143,0.006504,-0.0074049,0.01618,-0.010605,0.014136,0.0036953,-0.015085,0.015743,-0.0093071,0.009931,0.0050735,-0.011798,0.016025,-0.00264,0.0090407,0.0071504,-0.0097749,105.04,157.29,172.29,181.45,154.61,129.53,150.12,171.2,178.18,149.85,129.13,146.74,169.26,175.61,147.17,128.05,144.96,167.77,173.75,145.34,127.05,143.69,166.35,172.19,144.0,126.17,142.85,165.34,171.1,143.05,125.51,142.16,164.64,170.3,142.35,124.97,141.74,164.12,169.61,141.71,124.61,141.42,163.63,169.08,141.22,124.32,141.17,163.38,168.63,140.75,123.98,140.88,163.12,168.26,140.41,123.79,140.77,162.84,167.95,140.14,123.59,140.59,162.68,167.59,139.81,123.37,140.44,162.48,167.18,139.5,123.19,140.37,162.37,167.0,139.27,123.14,140.35,162.21,166.78,139.07,123.04,140.36,162.24,166.6,138.86,122.89,140.24,162.08,166.37,138.66,122.84,140.32,161.93,166.36,138.44,122.71,140.19,161.82,166.03,138.2,122.57,140.1,161.72,165.81,138.07,122.53,140.1,161.75,165.77,137.9,122.5,140.11,161.73,165.62,137.85,122.47,140.09,161.66,165.52,137.62,122.41,140.17,161.76,165.48,137.58,122.4,140.26,161.76,165.32,137.37,122.32,140.03,161.65,165.13,137.28,122.29,140.09,161.64,165.03,137.06,122.23,140.12,161.58,164.94,136.93,122.14,140.07,161.51,164.75,136.82,122.06,140.14,161.54,164.69,136.72,122.13,140.21,161.62,164.68,136.65,122.12,140.23,161.67,164.58,136.58,122.13,140.29,161.6,164.51,136.5,122.14,140.44,161.72,164.35,136.35,122.08,140.42,161.67,164.31,136.21,0.0:4
-0.012505,0.015087,-0.010368,2.8165E-4,0.012144,-0.013654,0.016549,-0.0047436,0.0089053,0.0063386,-0.012552,0.017825,-0.0081483,0.0044776,0.0099298,22.094,132.83,163.4,180.41,170.41,141.29,133.32,158.33,177.22,167.74,137.73,131.99,155.6,174.7,165.4,135.57,130.68,153.87,172.9,163.75,134.23,129.55,152.56,171.44,162.37,133.24,128.68,151.67,170.4,161.48,132.57,128.11,151.04,169.67,160.79,132.03,127.53,150.39,168.92,160.24,131.54,127.07,149.98,168.37,159.79,131.25,126.77,149.56,168.1,159.37,130.94,126.4,149.19,167.63,159.13,130.78,126.18,148.93,167.37,158.89,130.6,126.03,148.76,167.17,158.77,130.37,125.81,148.44,166.94,158.71,130.33,125.7,148.3,166.58,158.52,130.29,125.67,148.25,166.53,158.31,130.08,125.41,147.94,166.3,158.21,129.96,125.27,147.82,166.16,158.16,129.87,125.2,147.74,166.11,158.04,129.83,125.02,147.53,165.93,158.03,129.82,125.04,147.5,165.89,158.02,129.82,125.03,147.43,165.9,158.07,129.82,124.97,147.45,165.87,157.9,129.72,124.87,147.37,165.72,157.96,129.69,124.73,147.11,165.56,157.91,129.74,124.76,147.18,165.57,157.99,129.7,124.76,147.17,165.45,157.96,129.73,124.69,147.01,165.37,157.94,129.81,124.69,147.0,165.46,158.04,129.87,124.7,146.98,165.46,157.98,129.78,124.57,146.92,165.46,158.07,129.87,124.54,146.83,165.34,158.11,129.81,124.44,146.65,165.21,157.99,129.73,124.37,146.55,165.2,158.0,129.77,124.36,146.57,165.16,158.02,129.81,124.27,146.48,164.98,157.96,129.73,124.16,146.39,164.96,158.05,0.0:4
-0.017552,0.022715,-0.006932,0.0051137,0.0062633,-0.010794,0.019513,-0.0061387,0.0070198,0.011283,-0.012001,0.017819,-0.0090999,0.0082359,0.010833,-0.0076641,0.018192,-0.010968,0.0040445,0.010739,-0.011215,0.022577,-0.0053453,0.0020314,0.0075541,-0.0061649,0.013496,-0.0053747,0.0065347,0.011892,-0.0060679,0.01713,-0.0075997,0.010031,96.527,153.7,127.02,155.63,173.68,175.46,146.0,128.78,150.72,171.52,172.69,142.59,127.88,148.05,169.44,170.47,140.52,126.85,146.44,167.92,168.81,139.17,125.82,145.31,166.63,167.7,138.31,125.06,144.46,165.68,166.84,137.61,124.47,143.89,165.08,166.15,137.19,124.08,143.38,164.44,165.65,136.74,123.66,142.98,164.0,165.22,136.51,123.37,142.67,163.63,164.91,136.16,123.06,142.26,163.16,164.57,135.93,122.86,141.99,162.91,164.38,135.82,122.74,141.89,162.76,164.29,135.73,122.64,141.7,162.58,164.18,135.62,122.5,141.58,162.45,164.14,135.61,122.49,141.46,162.39,163.96,135.57,122.33,141.26,162.22,163.92,135.54,122.29,141.21,162.13,163.78,135.47,122.2,141.11,162.09,163.86,135.49,122.15,141.02,162.01,163.75,135.45,122.02,140.84,161.73,163.71,135.37,121.95,140.76,161.64,163.66,135.36,121.87,140.63,161.55,163.62,135.32,121.84,140.56,161.49,163.63,135.43,121.87,140.62,161.55,163.69,135.48,121.89,140.54,161.49,163.54,135.35,121.73,140.38,161.32,163.57,135.4,121.71,140.27,161.22,163.5,135.37,121.64,140.23,161.11,163.44,135.4,121.64,140.1,161.09,163.53,135.48,121.57,140.03,161.01,163.61,135.49,121.53,139.95,160.91,163.52,135.49,121.51,139.89,160.8,163.54,0.0:4
0.014757,-0.011387,0.019683,2.1869E-5,0.0013499,0.0093297,-0.0094086,0.011367,0.0040554,0.0012615,0.011544,-0.011443,0.012574,0.006514,0.0015272,0.0062929,-0.016383,0.016638,0.0018728,0.010436,0.0058172,-0.0083645,0.009904,0.0014054,-1.3009E-4,0.014354,-0.010363,0.023536,-0.0020966,0.010591,0.01459,-0.0084415,0.018994,0.001234,0.010128,0.0079127,2.6299,2.483,19.88,14.978,10.727,15.389,8.3044,16.875,15.086,11.498,13.995,9.1135,16.189,14.931,11.585,13.67,9.1471,15.956,14.8,11.531,13.523,9.0491,15.808,14.62,11.505,13.476,8.95,15.708,14.495,11.482,13.4,8.8668,15.604,14.37,11.45,13.343,8.7861,15.478,14.265,11.45,13.304,8.7172,15.403,14.177,11.441,13.297,8.666,15.359,14.097,11.462,13.29,8.612,15.333,14.038,11.526,13.315,8.5902,15.309,13.956,11.569,13.303,8.548,15.238,13.886,11.589,13.296,8.5072,15.175,13.802,11.619,13.292,8.4672,15.15,13.769,11.65,13.317,8.4624,15.12,13.728,11.708,13.332,8.4291,15.077,13.666,11.753,13.352,8.4156,15.059,13.629,11.789,13.388,8.3918,15.029,13.593,11.847,13.414,8.3645,15.01,13.532,11.902,13.444,8.3434,14.985,13.463,11.973,13.464,8.3373,14.975,13.432,12.029,13.488,8.3297,14.934,13.395,12.065,13.508,8.3013,14.874,13.346,12.085,13.534,8.2829,14.88,13.323,12.167,13.596,8.274,14.862,13.259,12.24,13.633,8.2667,14.781,13.166,12.275,13.596,8.2268,14.718,13.117,12.314,13.627,8.2114,14.678,13.056,12.346,13.65,8.1962,14.645,13.027,12.391,13.675,8.1833,14.625,12.971,12.448,13.716,8.1794,14.598,12.948,12.498,13.76,8.1661,14.568,12.926,0.0:4
0.018487,-0.0021096,-0.0018356,0.0093112,-0.0067383,0.0082265,0.0066926,0.0033551,0.0081933,-0.0095919,0.014308,-0.0017372,0.0036905,0.012391,-0.0087887,0.012911,0.0038604,0.0041564,0.010723,-0.0074449,0.0073767,5.2031E-4,-0.0015438,0.018045,-0.0045711,0.020597,-2.7255E-4,0.002184,0.013693,-0.010756,0.014195,-7.7023E-4,0.0045494,0.014212,-0.01091,0.014642,0.13143,16.362,8.1954,16.974,8.1381,17.429,16.164,10.295,14.289,9.6803,16.582,15.975,10.586,13.723,9.8366,16.329,15.797,10.579,13.537,9.7418,16.164,15.617,10.536,13.417,9.6389,16.047,15.475,10.491,13.324,9.5329,15.938,15.346,10.46,13.261,9.4449,15.868,15.281,10.436,13.24,9.376,15.852,15.22,10.445,13.202,9.322,15.786,15.106,10.456,13.157,9.2687,15.724,15.05,10.456,13.132,9.2138,15.694,14.999,10.478,13.132,9.1879,15.679,14.994,10.491,13.145,9.1445,15.704,14.953,10.531,13.15,9.1078,15.7,14.874,10.605,13.136,9.0702,15.667,14.803,10.628,13.108,9.045,15.613,14.742,10.662,13.089,9.0187,15.589,14.749,10.667,13.107,9.0074,15.599,14.734,10.715,13.133,8.9849,15.594,14.693,10.751,13.125,8.9391,15.584,14.625,10.802,13.133,8.9134,15.585,14.604,10.852,13.152,8.8941,15.582,14.598,10.884,13.177,8.8981,15.604,14.571,10.956,13.192,8.8757,15.6,14.531,10.999,13.183,8.8636,15.564,14.475,11.027,13.181,8.8428,15.532,14.441,11.059,13.197,8.8144,15.534,14.446,11.087,13.239,8.7877,15.567,14.425,11.161,13.268,8.7893,15.557,14.374,11.199,13.246,8.7671,15.508,14.305,11.242,13.23,8.7458,15.458,14.286,11.257,13.249,8.7221,15.473,14.293,11.285,13.269,0.0:4
-0.01101,-0.011205,0.011779,-0.021283,0.0083947,-0.011162,-0.014966,0.012994,-0.024157,0.0042835,-0.0070739,-0.012622,0.013585,-0.025243,0.010235,-0.012031,-0.010618,0.013469,-0.023267,0.010956,-0.0068799,-0.01223,0.0093554,31.35,45.114,48.664,46.337,38.77,36.544,43.778,48.902,46.653,38.373,36.841,43.41,48.858,46.802,38.333,36.807,43.197,48.777,46.884,38.379,36.738,43.064,48.703,46.974,38.437,36.674,42.895,48.612,47.058,38.496,36.61,42.711,48.543,47.133,38.579,36.529,42.544,48.486,47.2,38.648,36.478,42.421,48.452,47.276,38.741,36.425,42.297,48.389,47.35,38.842,36.364,42.133,48.321,47.422,38.926,36.308,41.984,48.236,47.493,39.025,36.244,41.843,48.163,47.57,39.14,36.205,41.722,48.088,47.653,39.241,36.155,41.586,48.007,47.728,39.341,36.124,41.469,47.935,47.842,39.456,36.11,41.318,47.876,47.903,39.567,36.09,41.204,47.834,47.981,39.688,36.074,41.082,47.771,48.051,39.815,36.052,40.968,47.699,48.141,39.941,36.036,40.871,47.602,48.198,40.065,36.028,40.735,47.521,48.293,40.174,36.031,40.602,47.456,48.349,40.301,36.021,40.457,47.39,48.399,40.41,36.02,40.323,47.324,48.441,40.559,36.025,40.222,47.265,48.51,40.704,36.04,40.119,47.21,48.556,40.839,36.048,40.006,47.095,48.596,40.981,36.031,39.883,47.024,48.654,41.117,36.048,39.781,46.928,48.712,41.257,36.07,39.659,46.826,48.766,41.39,36.09,39.538,46.742,48.795,41.497,36.116,39.403,46.696,48.806,41.631,36.14,39.272,46.612,48.814,41.8,36.156,39.15,46.51,48.813,41.945,36.164,39.053,0.0:4
0.020521,-0.018871,-3.9311E-4,0.0016611,-0.017746,0.018211,-0.018246,0.013799,-3.6057E-4,-0.037747,0.025568,-0.024519,0.0066596,-0.0026498,-0.018868,0.018667,-0.012221,45.954,48.647,42.161,35.136,40.933,46.977,48.706,41.55,35.782,40.437,47.105,48.724,41.447,35.891,40.274,47.088,48.65,41.392,35.868,40.195,47.039,48.659,41.413,35.83,40.111,46.89,48.597,41.379,35.756,40.02,46.814,48.602,41.409,35.762,39.976,46.76,48.595,41.382,35.746,39.906,46.713,48.575,41.391,35.72,39.83,46.671,48.553,41.413,35.731,39.778,46.612,48.542,41.437,35.731,39.729,46.63,48.552,41.457,35.726,39.671,46.611,48.49,41.478,35.695,39.603,46.523,48.46,41.538,35.668,39.591,46.514,48.466,41.574,35.669,39.575,46.446,48.5,41.63,35.671,39.554,46.387,48.5,41.636,35.66,39.504,46.324,48.555,41.668,35.669,39.457,46.287,48.552,41.692,35.696,39.411,46.304,48.606,41.727,35.71,39.36,46.273,48.549,41.732,35.696,39.28,46.28,48.546,41.804,35.744,39.254,46.317,48.52,41.881,35.746,39.223,46.256,48.519,41.94,35.718,39.225,46.209,48.558,42.019,35.726,39.227,46.137,48.638,42.049,35.759,39.207,46.092,48.666,42.056,35.771,39.137,46.072,48.675,42.082,35.792,39.085,46.062,48.657,42.16,35.822,39.024,46.031,48.609,42.19,35.813,39.008,46.052,48.616,42.244,35.795,38.981,45.986,48.627,42.285,35.812,38.956,45.994,48.646,42.377,35.836,38.912,45.906,48.665,42.404,35.857,38.899,45.914,48.67,42.426,35.872,38.862,45.884,48.697,42.47,35.867,38.813,45.878,48.673,42.517,0.0:4
0.015055,-0.014309,-0.012264,0.018052,-0.028058,0.010546,-0.011165,-0.012246,0.010565,-0.027485,0.010737,-0.01358,-0.0073833,0.013996,-0.028272,0.014823,-0.0095332,-0.010248,0.0098861,-0.025368,0.011249,-0.0093814,-0.015067,0.020678,-0.025864,0.010796,-0.016389,-0.016566,0.017875,29.58,40.955,45.062,43.583,36.383,33.269,39.486,44.798,43.34,35.692,33.212,38.846,44.444,43.036,35.37,32.964,38.455,44.138,42.781,35.156,32.775,38.184,43.851,42.641,35.037,32.583,37.952,43.692,42.508,34.955,32.518,37.774,43.521,42.445,34.922,32.393,37.634,43.461,42.4,34.895,32.352,37.506,43.34,42.372,34.867,32.281,37.36,43.311,42.329,34.918,32.233,37.305,43.231,42.369,34.947,32.162,37.195,43.22,42.366,34.985,32.183,37.165,43.133,42.412,35.028,32.144,37.086,43.128,42.425,35.074,32.154,37.043,43.075,42.502,35.149,32.1,36.94,43.047,42.524,35.186,32.118,36.91,42.995,42.567,35.23,32.077,36.839,42.975,42.558,35.223,32.063,36.766,42.905,42.673,35.341,32.111,36.743,42.996,42.703,35.374,32.125,36.673,42.943,42.709,35.446,32.087,36.601,42.966,42.715,35.493,32.084,36.566,42.898,42.74,35.556,32.06,36.504,42.854,42.772,35.585,32.05,36.445,42.804,42.808,35.669,32.032,36.387,42.792,42.845,35.692,32.006,36.341,42.724,42.868,35.762,32.025,36.29,42.725,42.904,35.811,32.048,36.253,42.674,42.96,35.868,32.038,36.177,42.619,42.955,35.865,32.004,36.085,42.585,42.971,35.914,32.015,36.022,42.565,42.984,35.964,31.984,35.922,42.489,42.969,36.045,31.982,35.895,42.553,42.998,36.115,32.001,0.0:4
0.020128,-0.021967,0.0073246,-0.0091798,-0.022617,0.016484,-0.028313,0.010265,-0.0088132,-0.012434,0.020417,-0.025241,0.0072479,-0.0080009,-0.013513,0.014267,31.147,42.985,45.627,41.346,34.699,34.275,41.621,45.188,41.173,33.973,34.176,41.026,44.812,40.939,33.637,33.919,40.636,44.543,40.73,33.445,33.742,40.356,44.304,40.605,33.311,33.523,40.176,44.153,40.476,33.245,33.427,40.023,44.032,40.443,33.181,33.315,39.931,43.93,40.393,33.144,33.254,39.813,43.842,40.425,33.089,33.175,39.678,43.82,40.379,33.097,33.128,39.599,43.771,40.403,33.097,33.044,39.509,43.73,40.379,33.109,33.021,39.431,43.723,40.438,33.129,32.98,39.422,43.688,40.448,33.148,32.958,39.386,43.657,40.505,33.166,32.924,39.334,43.671,40.538,33.187,32.908,39.262,43.645,40.566,33.206,32.866,39.247,43.665,40.573,33.195,32.81,39.137,43.575,40.638,33.236,32.827,39.199,43.613,40.669,33.265,32.825,39.126,43.588,40.717,33.307,32.811,39.089,43.624,40.785,33.326,32.796,39.024,43.629,40.812,33.366,32.753,38.982,43.633,40.81,33.382,32.753,38.94,43.595,40.866,33.426,32.697,38.886,43.588,40.888,33.44,32.684,38.847,43.576,40.933,33.458,32.655,38.835,43.559,40.97,33.511,32.648,38.771,43.569,40.951,33.519,32.63,38.752,43.545,41.048,33.572,32.606,38.727,43.526,41.092,33.581,32.583,38.672,43.491,41.089,33.571,32.533,38.592,43.458,41.146,33.612,32.545,38.57,43.471,41.171,33.661,32.541,38.498,43.465,41.193,33.671,32.521,38.464,43.493,41.223,33.712,32.518,38.451,43.484,41.276,0.0:4
-0.0067773,0.0064412,-0.027927,0.01067,-0.011029,-0.022398,0.0088611,-0.023827,0.013143,-0.008085,-0.011166,0.014798,-0.022252,0.015574,-0.010467,-0.014242,0.01697,-0.023895,6.759,44.536,43.696,37.055,32.823,39.519,44.718,43.497,35.984,33.115,38.819,44.445,43.126,35.488,32.955,38.433,44.14,42.802,35.211,32.786,38.227,43.987,42.573,34.989,32.661,38.089,43.767,42.418,34.826,32.531,37.989,43.711,42.245,34.699,32.487,37.943,43.566,42.102,34.607,32.415,37.885,43.521,42.031,34.514,32.353,37.897,43.425,41.978,34.436,32.357,37.857,43.422,41.9,34.343,32.325,37.889,43.379,41.862,34.32,32.316,37.888,43.41,41.81,34.274,32.35,37.939,43.384,41.762,34.245,32.322,37.93,43.375,41.72,34.182,32.323,37.969,43.331,41.676,34.155,32.355,37.997,43.389,41.68,34.092,32.36,38.032,43.388,41.587,34.048,32.319,38.012,43.369,41.573,34.061,32.406,38.124,43.438,41.555,34.052,32.382,38.105,43.455,41.516,33.998,32.406,38.185,43.413,41.508,33.977,32.409,38.231,43.456,41.478,33.927,32.414,38.249,43.426,41.428,33.904,32.422,38.27,43.46,41.401,33.859,32.436,38.317,43.421,41.393,33.836,32.446,38.385,43.486,41.384,33.837,32.51,38.451,43.486,41.36,33.813,32.518,38.435,43.493,41.302,33.753,32.543,38.46,43.5,41.275,33.73,32.544,38.436,43.559,41.229,33.687,32.546,38.532,43.557,41.158,33.685,32.561,38.569,43.553,41.121,33.664,32.556,38.623,43.528,41.12,33.641,32.581,38.649,43.556,41.07,33.594,32.6,38.713,43.543,41.05,33.578,32.608,38.735,43.569,0.0:4
0.009072,-0.0010447,-3.0867E-4,-0.0028833,1.9562E-4,0.0026606,-0.0043132,-0.0013959,0.004622,-0.0105,0.0036362,-7.1221E-4,0.009953,1.5471E-4,0.0051916,0.0078982,-0.0056231,0.0052445,-0.0027914,-4.693E-5,0.0021543,-0.004084,0.0086542,13.313,29.564,28.358,31.654,35.013,39.256,37.064,29.721,30.074,35.518,38.906,36.579,29.79,29.651,35.466,38.678,36.318,29.689,29.436,35.296,38.462,36.099,29.521,29.292,35.152,38.307,35.964,29.396,29.223,35.074,38.229,35.86,29.327,29.226,35.032,38.219,35.749,29.266,29.186,35.018,38.19,35.663,29.241,29.151,35.046,38.157,35.628,29.245,29.137,35.095,38.088,35.611,29.169,29.14,35.087,37.998,35.616,29.11,29.196,35.061,38.05,35.603,29.102,29.26,35.093,38.133,35.52,29.082,29.248,35.039,38.137,35.443,29.052,29.215,35.051,38.063,35.345,29.038,29.228,35.103,38.099,35.37,29.031,29.278,35.154,38.153,35.345,29.029,29.281,35.162,38.114,35.309,29.013,29.284,35.194,38.123,35.282,29.006,29.292,35.231,38.076,35.245,28.963,29.289,35.264,38.045,35.219,28.925,29.327,35.255,38.082,35.201,28.938,29.389,35.31,38.155,35.155,28.93,29.388,35.316,38.109,35.116,28.899,29.377,35.303,38.034,35.064,28.834,29.386,35.3,38.013,35.027,28.815,29.443,35.314,38.121,34.992,28.816,29.488,35.355,38.161,34.898,28.823,29.458,35.364,38.117,34.849,28.793,29.417,35.393,37.962,34.754,28.72,29.379,35.358,37.894,34.774,28.684,29.423,35.388,37.926,34.74,28.664,29.475,35.367,37.938,34.693,28.638,29.473,35.37,37.956,34.634,28.633,29.502,35.404,37.969,34.616,0.0:4
-0.0069043,0.01041,-0.0057385,0.006046,-0.0016506,-0.0070241,0.011987,-0.0020339,0.008781,0.0064305,-0.0085946,0.020545,-0.0043929,0.0090841,0.0023821,-0.007431,0.0086088,6.9954E-4,7.1315,12.957,22.352,32.604,31.322,39.106,38.8,31.215,29.447,32.839,38.283,38.345,31.587,28.692,32.87,37.893,38.022,31.551,28.392,32.74,37.598,37.824,31.487,28.22,32.585,37.391,37.792,31.439,28.161,32.492,37.322,37.813,31.402,28.129,32.358,37.248,37.74,31.387,28.075,32.231,37.201,37.676,31.377,28.021,32.126,37.107,37.646,31.438,27.983,32.09,37.069,37.649,31.457,27.992,32.055,37.105,37.703,31.525,27.983,32.003,37.057,37.63,31.53,27.937,31.917,36.952,37.626,31.571,27.891,31.827,36.854,37.637,31.613,27.889,31.78,36.821,37.68,31.615,27.907,31.726,36.854,37.695,31.661,27.921,31.679,36.903,37.662,31.723,27.906,31.609,36.874,37.602,31.781,27.86,31.553,36.761,37.598,31.824,27.816,31.517,36.691,37.66,31.85,27.85,31.496,36.685,37.717,31.926,27.884,31.467,36.709,37.706,31.979,27.887,31.414,36.702,37.666,32.051,27.857,31.36,36.594,37.685,32.062,27.837,31.326,36.553,37.75,32.077,27.871,31.272,36.567,37.816,32.157,27.906,31.256,36.609,37.814,32.238,27.917,31.176,36.582,37.755,32.299,27.893,31.118,36.51,37.755,32.353,27.894,31.09,36.539,37.762,32.438,27.928,31.079,36.584,37.803,32.534,27.942,31.068,36.558,37.795,32.625,27.93,31.053,36.466,37.797,32.653,27.897,31.017,36.304,37.844,32.68,27.902,30.932,36.236,37.92,32.682,27.954,30.875,36.294,37.931,0.0:4
5.08E-6,-9.0E-8,5.3533E-6,3.5067E-6,3.8833E-6,3.82E-6,-1.5667E-7,4.3867E-6,3.81E-6,4.3667E-6,5.0367E-6,-7.6333E-7,5.29E-6,2.8433E-6,3.4033E-6,4.3633E-6,-2.3333E-8,6.1633E-6,3.24E-6,4.0467E-6,6.01E-6,-3.7E-7,4.7E-6,3.53E-6,3.7467E-6,4.6767E-6,-1.8333E-7,4.5E-6,3.7767E-6,4.93E-6,5.6233E-6,3.0E-7,5.1167E-6,2.2667E-6,4.1567E-6,4.47E-6,6.0E-8,5.55E-6,3.1267E-6,4.75E-6,4.4633E-6,-5.3333E-8,4.6533E-6,2.8933E-6,4.3233E-6,4.3933E-6,-4.4E-7,4.5167E-6,2.7133E-6,5.1967E-6,4.7833E-6,-1.9333E-7,4.8967E-6,4.2733E-6,3.4633E-6,4.99E-6,-5.4333E-7,4.8167E-6,2.4033E-6,5.1433E-6,5.5933E-6,-8.2667E-7,5.0167E-6,3.5133E-6,4.0667E-6,5.59E-6,9.5333E-7,5.12E-6,3.1367E-6,4.6633E-6,5.5633E-6,9.3333E-8,4.88E-6,2.63E-6,5.0933E-6,5.1733E-6,1.0E-7,4.99E-6,3.0567E-6,4.7767E-6,4.6733E-6,-5.4E-7,4.8967E-6,2.51E-6,4.2367E-6,4.9033E-6,2.3E-7,4.9667E-6,3.24E-6,4.9567E-6,5.2033E-6,6.0E-8,5.1133E-6,2.9667E-6,4.0533E-6,5.7467E-6,3.2E-7,4.3067E-6,1.99E-6,5.0167E-6,4.9733E-6,-8.8333E-7,4.39E-6,3.7E-6,5.0867E-6,5.29E-6,-8.9667E-7,4.33E-6,2.5367E-6,4.39E-6,4.74E-6,-4.4E-7,4.3367E-6,4.3333E-6,3.99E-6,5.2467E-6,-4.9333E-7,4.6333E-6,0.0018325,0.017824,0.018284,0.016098,0.012964,0.016258,0.017905,0.018361,0.015835,0.013186,0.016042,0.017994,0.01842,0.015761,0.013283,0.015979,0.017997,0.018389,0.01588,0.013269,0.015907,0.017979,0.018409,0.01584,0.013297,0.015911,0.01795,0.018435,0.015829,0.013275,0.015834,0.017901,0.018487,0.015868,0.013291,0.015818,0.017857,0.018476,0.01586,0.01323,0.015788,0.017934,0.018407,0.015874,0.013284,0.015735,0.017849,0.018452,0.015879,0.01324,0.015765,0.01781,0.018485,0.015922,0.013245,0.015678,0.017821,0.018501,0.015932,0.013261,0.015662,0.017735,0.018475,0.016017,0.013276,0.015677,0.017658,0.018478,0.016022,0.013215,0.015628,0.017697,0.018491,0.016007,0.013242,0.015587,0.017635,0.01851,0.016029,0.013219,0.015554,0.017663,0.018523,0.016087,0.013249,0.015561,0.017654,0.018501,0.01609,0.013243,0.015546,0.017604,0.018547,0.016095,0.013227,0.015514,0.017509,0.018539,0.016125,0.013207,0.015482,0.017564,0.018515,0.016152,0.01325,0.015435,0.017488,0.018526,0.01618,0.013222,0.015429,0.017466,0.018532,0.016204,0.013241,0.015342,0.017488,0.018525,0.016241,0.013224,0.015386,0.017441,0.018539,0.016197,0.013223,0.015331,0.017328,0.018533,0.016288,0.013214,0.015298,0.017421,0.018484,0.016291,0.013258,0.015198,0.017391,0.01855,0.016281,0.01321,0.015237,0.017358,0.018475,0.016328,0.013257,0.015149,0.017277,0.018443,0.016318,0.013222,0.015158,0.017206,0.018479,0.016339,0.013313,0.015148,0.017257,0.018506,0.016472,0.013239,0.015083,0.017276,0.018487,0.016402,0.013235,0.015089,0.017205,0.018508,0.016522,0.013307,0.014984,0.0171,0.018516,0.016528,0.013267,0.014974,0.017084,0.018471,0.01653,0.013239,0.014942,0.017066,0.0:5
6.1167E-6,4.8933E-6,9.7533E-6,8.02E-6,2.1133E-6,6.47E-6,3.64E-6,8.4667E-6,7.8067E-6,2.2433E-6,6.19E-6,3.96E-6,8.2467E-6,7.4E-6,1.5E-6,5.8867E-6,4.2467E-6,8.4133E-6,7.5033E-6,2.0633E-6,5.6333E-6,3.8567E-6,7.8533E-6,6.98E-6,9.0333E-7,5.87E-6,4.0E-6,7.7567E-6,7.5067E-6,2.0033E-6,5.7767E-6,3.88E-6,8.33E-6,7.0267E-6,1.8567E-6,5.13E-6,3.8E-6,7.59E-6,5.5967E-6,8.7333E-7,5.1533E-6,2.7667E-6,7.7167E-6,6.1733E-6,1.29E-6,5.3767E-6,3.4333E-6,7.62E-6,7.4933E-6,6.9E-7,5.0167E-6,3.3967E-6,7.7933E-6,7.14E-6,1.4167E-6,6.0033E-6,3.57E-6,6.9933E-6,7.1167E-6,1.0833E-6,5.6567E-6,3.5567E-6,7.2567E-6,7.5067E-6,1.03E-6,5.1033E-6,3.65E-6,7.3567E-6,6.63E-6,1.01E-6,5.9767E-6,4.3867E-6,6.31E-6,6.4033E-6,1.8733E-6,5.4533E-6,4.03E-6,6.9833E-6,6.4133E-6,-2.0E-7,5.44E-6,2.9033E-6,7.7367E-6,6.4433E-6,8.4333E-7,5.4767E-6,3.4533E-6,7.1767E-6,0.0089327,0.017399,0.01298,0.015245,0.016768,0.018668,0.017035,0.013338,0.014952,0.016881,0.01857,0.016922,0.013399,0.014901,0.016956,0.018608,0.016866,0.013496,0.014802,0.016997,0.018547,0.016799,0.01344,0.014874,0.016965,0.018562,0.016757,0.013401,0.014905,0.016935,0.01857,0.016732,0.013346,0.014915,0.0171,0.018527,0.016689,0.013329,0.014891,0.017038,0.018519,0.016628,0.013328,0.014919,0.017077,0.018512,0.016568,0.013352,0.014987,0.017094,0.018521,0.016592,0.013308,0.015006,0.01712,0.018522,0.016514,0.013309,0.014957,0.017103,0.01848,0.016539,0.013326,0.014999,0.017105,0.018486,0.016501,0.013275,0.014985,0.01711,0.018473,0.016435,0.0133,0.01497,0.017095,0.018514,0.016418,0.013231,0.015043,0.017183,0.018526,0.016419,0.013257,0.015067,0.017177,0.018494,0.016324,0.01326,0.015113,0.017204,0.018441,0.016356,0.013211,0.015115,0.01722,0.01848,0.016283,0.013263,0.015138,0.017274,0.018426,0.016257,0.013204,0.015082,0.017195,0.018496,0.016233,0.013253,0.015165,0.017322,0.018484,0.016176,0.0:5
7.2033E-6,4.42E-6,9.85E-6,8.89E-6,5.8767E-6,7.8033E-6,4.2733E-6,9.0233E-6,7.9867E-6,5.73E-6,7.2833E-6,3.6233E-6,9.49E-6,8.12E-6,5.51E-6,5.9033E-6,2.9733E-6,8.6167E-6,7.99E-6,4.3567E-6,7.4867E-6,2.5233E-6,8.5633E-6,7.4433E-6,4.5533E-6,5.9167E-6,3.1467E-6,8.69E-6,7.6567E-6,4.6433E-6,6.49E-6,2.9033E-6,8.3033E-6,7.1367E-6,3.8233E-6,6.39E-6,3.3567E-6,8.0067E-6,7.42E-6,4.5433E-6,5.8433E-6,3.3033E-6,7.9833E-6,6.9033E-6,2.73E-6,6.2333E-6,3.2233E-6,7.3E-6,6.92E-6,3.3167E-6,0.012183,0.014835,0.014843,0.018506,0.0187,0.014675,0.014346,0.015172,0.018357,0.018574,0.014756,0.014182,0.015332,0.0183,0.018618,0.014738,0.014153,0.015376,0.018308,0.018544,0.014648,0.014164,0.015423,0.018354,0.01851,0.014651,0.014154,0.015483,0.018314,0.018468,0.014621,0.014158,0.015495,0.018378,0.018445,0.01464,0.014112,0.015464,0.018403,0.018442,0.014542,0.014193,0.015519,0.018368,0.018311,0.014549,0.014118,0.015538,0.018363,0.01833,0.014501,0.014164,0.015548,0.018388,0.018252,0.01447,0.01408,0.015593,0.018398,0.0183,0.014445,0.014088,0.01562,0.0184,0.018244,0.014399,0.014122,0.015647,0.01838,0.018175,0.014388,0.014111,0.015677,0.018366,0.018203,0.014318,0.014167,0.015722,0.018363,0.018118,0.014249,0.014174,0.015808,0.018374,0.018131,0.014275,0.014121,0.015774,0.018367,0.018028,0.014221,0.014218,0.015812,0.018404,0.018012,0.014154,0.014171,0.015807,0.018407,0.018011,0.01411,0.014128,0.015873,0.018393,0.01803,0.014126,0.0142,0.01588,0.018349,0.01792,0.014096,0.014184,0.015884,0.018427,0.017919,0.014037,0.014186,0.015957,0.018397,0.017893,0.013996,0.014243,0.015972,0.018462,0.01784,0.013987,0.014197,0.016034,0.018421,0.017767,0.013951,0.014256,0.016063,0.018487,0.017802,0.013912,0.014255,0.016067,0.018427,0.017748,0.013914,0.01427,0.016071,0.018408,0.017711,0.013896,0.014294,0.016048,0.0184,0.017662,0.0:5
1.0667E-6,1.0767E-6,2.07E-6,-6.4333E-7,1.8133E-6,1.5133E-6,1.42E-6,1.8467E-6,6.6E-7,1.42E-6,8.5E-7,1.4133E-6,1.02E-6,7.3333E-7,1.32E-6,1.2967E-6,1.1533E-6,1.4167E-6,1.05E-6,2.11E-6,5.3E-7,1.1267E-6,1.4167E-6,-3.4667E-7,2.05E-6,1.2533E-6,1.4967E-6,1.28E-6,2.5333E-7,1.5367E-6,1.2033E-6,9.3E-7,1.9067E-6,-3.3333E-8,1.14E-6,1.8967E-6,7.4667E-7,1.5867E-6,1.4E-7,2.3533E-6,7.0667E-7,9.3667E-7,1.5867E-6,-6.9667E-7,1.63E-6,3.6E-7,0.0058093,0.0060099,0.0053598,0.0056166,0.0068766,0.0071283,0.0059617,0.0053991,0.0055703,0.0068927,0.0071532,0.0059673,0.0054276,0.0055785,0.00691,0.0071228,0.005953,0.0054219,0.0018307,0.0099594,0.010736,0.0092662,0.0079017,0.008583,0.010385,0.010773,0.0091567,0.008098,0.0084651,0.010418,0.010839,0.0090803,0.0081421,0.0084123,0.010411,0.010792,0.0090584,0.0081785,0.008408,0.010463,0.010791,0.0090497,0.0081877,0.0084209,0.010449,0.010787,0.0090313,0.0081829,0.0083983,0.010438,0.010794,0.0090571,0.0081995,0.0083952,0.010466,0.010817,0.0090713,0.0081965,0.0083992,0.010435,0.010815,0.0090883,0.0082255,0.0084064,0.010446,0.010799,0.0090391,0.008195,0.0084194,0.01044,0.010809,0.0090902,0.0081773,0.0084058,0.010449,0.010795,0.0091318,0.0081809,0.0084045,0.010446,0.010811,0.0090921,0.0082206,0.0084035,0.010447,0.010804,0.0091295,0.0081747,0.0083929,0.010414,0.010809,0.0090512,0.0082066,0.0083807,0.01045,0.010794,0.0090818,0.0082292,0.0083733,0.010442,0.010813,0.0090947,0.008205,0.0083703,0.010432,0.010811,0.0091079,0.0081991,0.0084087,0.01044,0.01081,0.0091302,0.0082382,0.0084344,0.010471,0.010893,0.0091197,0.0082429,0.0084452,0.010484,0.010842,0.0091235,0.0082255,0.0084219,0.010441,0.010878,0.0091009,0.008237,0.0084173,0.010451,0.010849,0.0091589,0.0082318,0.0084098,0.010503,0.010869,0.0091129,0.0082291,0.0084067,0.010468,0.010799,0.0091366,0.0082307,0.0084548,0.010476,0.010884,0.0091541,0.0082153,0.0084166,0.010458,0.010828,0.009155,0.0082482,0.0084093,0.010468,0.01087,0.0091534,0.0082264,0.0084293,0.01045,0.010872,0.0091299,0.0082553,0.008405,0.010462,0.010844,0.0091163,0.0082206,0.0083965,0.010473,0.010864,0.0091333,0.0082323,0.00842,0.010438,0.010847,0.00913,0.0082391,0.0084221,0.010484,0.010876,0.0091202,0.0082221,0.0084043,0.010474,0.01083,0.0091851,0.0082556,0.0084247,0.010463,0.010851,0.0091545,0.0082268,0.0084184,0.010481,0.010861,0.0091117,0.0082525,0.0084067,0.010497,0.010898,0.0091297,0.0082534,0.00841,0.010454,0.010851,0.0091497,0.0082234,0.0083969,0.010457,0.010885,0.0091227,0.0082381,0.0083971,0.010461,0.010892,0.0091343,0.0082396,0.0083753,0.010482,0.01084,0.0091734,0.0082421,0.0083901,0.010459,0.010849,0.0091628,0.0082201,0.008412,0.01047,0.010841,0.0091384,0.0082593,0.008372,0.010457,0.01085,0.0091544,0.0082399,0.0083435,0.010452,0.010837,0.0091365,0.0082476,0.0083816,0.010442,0.010852,0.0091667,0.0082411,0.00838,0.010456,0.010849,0.0091556,0.0082354,0.0083965,0.010439,0.010842,0.0091734,0.0082603,0.0083838,0.010449,0.010851,0.0091756,0.0082385,0.0083514,0.010441,0.010842,0.0091779,0.0082208,0.0083679,0.010437,0.010853,0.0091704,0.0082281,0.0083853,0.010432,0.010872,0.0091951,0.0082423,0.0083735,0.010421,0.010863,0.0091963,0.0082529,0.008381,0.010447,0.010847,0.0092002,0.0082308,0.0083736,0.010437,0.010844,0.0091943,0.0082239,0.0083757,0.010456,0.010873,0.0091922,0.0082483,0.0083506,0.010428,0.010858,0.0091875,0.0082484,0.0083621,0.010483,0.010886,0.0092094,0.0082598,0.0083802,0.010427,0.010829,0.009223,0.008237,0.0083741,0.010438,0.010872,0.0092293,0.008269,0.0083853,0.010448,0.010834,0.009258,0.0082597,0.0083626,0.010434,0.010884,0.0092304,0.0082529,0.0083696,0.010414,0.01085,0.0092467,0.0082444,0.0083413,0.010434,0.010885,0.009215,0.0082843,0.0083455,0.010445,0.010896,0.0092208,0.0082887,0.0083517,0.010426,0.010864,0.0092239,0.0082733,0.0083708,0.010425,0.010869,0.0092348,0.0082511,0.008374,0.010421,0.010857,0.0092768,0.008261,0.0083515,0.010441,0.010864,0.0092423,0.0082656,0.0083322,0.010406,0.0109,0.0092413,0.0082929,0.0083428,0.010437,0.010884,0.0092572,0.0082491,0.008314,0.010433,0.010878,0.0092605,0.0082744,0.0083524,0.010415,0.010902,0.0092538,0.0082551,0.0083314,0.0104,0.010848,0.0093011,0.0082686,0.0083499,0.010388,0.010832,0.0092782,0.0083037,0.0083261,0.0104,0.01087,0.009271,0.0082599,0.008306,0.010411,0.010868,0.0092877,0.0082521,0.0083262,0.010427,0.010873,0.0092801,0.0082453,0.0083319,0.010434,0.010868,0.0092788,0.0082709,0.0083234,0.010434,0.010858,0.0093046,0.0082883,0.008319,0.010406,0.010855,0.0092854,0.0083019,0.0083262,0.01042,0.010859,0.0092823,0.0082741,0.0083182,0.010397,0.010862,0.0092916,0.0082655,0.0083033,0.010414,0.010908,0.0092926,0.0082944,0.0083244,0.010405,0.010867,0.0092805,0.0082559,0.0083136,0.010378,0.010888,0.0092823,0.0082798,0.0083056,0.010406,0.010859,0.0093208,0.0082716,0.0083056,0.01038,0.01087,0.0092891,0.0082884,0.0083108,0.010401,0.010869,0.0092823,0.0082863,0.008304,0.010352,0.010869,0.0093326,0.0082582,0.0082938,0.010429,0.01087,0.0093496,0.0083164,0.0082772,0.010391,0.010893,0.0093423,0.0082793,0.008277,0.01039,0.010883,0.0093676,0.008268,0.008322,0.010388,0.010889,0.0093062,0.0082784,0.0082996,0.0104,0.01088,0.0093621,0.0082818,0.0082689,0.010367,0.010885,0.0093713,8.5805E-4:5
4.5E-7,1.7033E-6,1.2033E-6,1.3667E-6,2.34E-6,-2.9333E-7,9.6E-7,1.5033E-6,1.3133E-6,1.4033E-6,2.0E-7,1.0033E-6,1.1933E-6,9.5333E-7,1.58E-6,1.6667E-7,1.7E-6,8.8667E-7,6.9667E-7,1.7367E-6,5.6667E-7,1.6133E-6,1.0833E-6,2.18E-6,2.1767E-6,-5.7667E-7,1.2567E-6,2.18E-6,1.7933E-6,1.4E-6,2.8E-7,7.1E-7,1.1867E-6,1.7467E-6,1.0833E-6,4.0E-7,0.003571,0.0067994,0.0072043,0.0063054,0.0055573,0.0053879,0.0067924,0.0072045,0.0063384,0.0055563,0.0054029,0.0068048,0.007209,0.0063102,0.0055452,0.0053938,0.0068138,0.0072046,0.0063208,0.0055288,0.0053816,0.0068158,0.0072123,0.0062992,0.0054667,0.0060525,0.010188,0.01087,0.0096551,0.0083245,0.0082282,0.01025,0.010906,0.0095881,0.0083702,0.0081679,0.010291,0.010895,0.0096048,0.0083656,0.0081894,0.010285,0.010891,0.0096066,0.008374,0.00819,0.010281,0.010888,0.0095746,0.0083712,0.008189,0.010278,0.010882,0.0095748,0.0083774,0.0081799,0.010285,0.010893,0.0095667,0.0083312,0.0081583,0.010256,0.010889,0.0095845,0.0083696,0.0081545,0.010275,0.010921,0.0096033,0.008372,0.0081625,0.010296,0.010892,0.0095841,0.0083905,0.008151,0.010285,0.010864,0.0095772,0.0083715,0.0081631,0.010285,0.010916,0.0096017,0.0083848,0.0081505,0.010281,0.010907,0.0095899,0.0083812,0.0081364,0.010311,0.010899,0.0095999,0.0083568,0.0081893,0.010291,0.010889,0.0096013,0.0083879,0.0081845,0.010305,0.010918,0.0095812,0.0083899,0.0081587,0.010301,0.010875,0.0096145,0.0083852,0.0081616,0.010279,0.010901,0.0096246,0.0083766,0.0081682,0.010286,0.010893,0.0096135,0.0084027,0.0081551,0.010286,0.010891,0.0096188,0.0084018,0.0081763,0.010259,0.010912,0.0096162,0.0084204,0.0081787,0.010224,0.01088,0.0096045,0.008367,0.0081221,0.010268,0.010871,0.0095902,0.0083725,0.0081144,0.010243,0.01086,0.009568,0.0083851,0.008158,0.01026,0.010875,0.0096134,0.0083542,0.0081259,0.010278,0.010862,0.0095827,0.0083539,0.0081459,0.010223,0.010872,0.0096093,0.0083486,0.0081211,0.010248,0.010886,0.0096015,0.00837,0.0081195,0.010252,0.010864,0.0096137,0.0083862,0.0081537,0.010249,0.010846,0.0095946,0.008385,0.0081488,0.010247,0.010876,0.0095613,0.0083714,0.0081279,0.010238,0.010844,0.0095919,0.0083781,0.0081507,0.010245,0.010857,0.0095985,0.0083561,0.008151,0.010276,0.010887,0.0095956,0.0083601,0.0081291,0.010256,0.01091,0.0096011,0.008367,0.0081459,0.010266,0.010846,0.0095956,0.0083789,0.0081304,0.010263,0.010865,0.0095892,0.0083474,0.0081226,0.010222,0.010857,0.0096202,0.0083771,0.0080963,0.010219,0.010855,0.0096055,0.0083865,0.0081403,0.010266,0.01087,0.0095907,0.008367,0.0081452,0.01025,0.010857,0.0096212,0.0083632,0.0081414,0.010254,0.010867,0.0096253,0.0084097,0.008105,0.010261,0.010867,0.0096273,0.0083849,0.0080979,0.010218,0.010872,0.0096381,0.0083759,0.0081083,0.010256,0.010851,0.009677,0.0083696,0.0081543,0.010247,0.010861,0.0096179,0.0083652,0.0081159,0.010235,0.010887,0.0096227,0.008387,0.008142,0.010259,0.010887,0.0096122,0.0083678,0.0081189,0.010242,0.010843,0.009635,0.0083947,0.0081098,0.010231,0.010881,0.0096381,0.0083714,0.0081576,0.010232,0.01089,0.0096042,0.0083777,0.008097,0.01022,0.010878,0.0096174,0.0083656,0.0081177,0.010243,0.010856,0.0096067,0.008382,0.0080597,0.010234,0.010894,0.0096111,0.0083644,0.0081284,0.010253,0.010862,0.009625,0.0083812,0.0081297,0.010256,0.010868,0.0096401,0.0084001,0.0081015,0.010231,0.010868,0.0096151,0.0083824,0.0080984,0.010231,0.010861,0.009622,0.0084084,0.0081031,0.010221,0.010871,0.0096216,0.0083804,0.0081198,0.010213,0.010867,0.0096043,0.008387,0.0081157,0.010212,0.010868,0.0096402,0.00838,0.0081127,0.010224,0.010851,0.0096297,0.0083736,0.0080988,0.010218,0.010876,0.0096607,0.0083872,0.0081155,0.010224,0.010871,0.009636,0.0083895,0.008098,0.010205,0.010825,0.0096407,0.0083658,0.0081141,0.010205,0.010869,0.0096517,0.0083913,0.0080846,0.010221,0.010841,0.0096474,0.0083516,0.0081136,0.010216,0.010872,0.0096361,0.0083686,0.0080969,0.010203,0.010865,0.0096716,0.0083974,0.0080905,0.010179,0.010857,0.009676,0.0083849,0.0080661,0.010218,0.010884,0.0096207,0.0083768,0.0080651,0.01021,0.010866,0.0096328,0.0084008,0.0080874,0.010188,0.010865,0.009644,0.0083914,0.0080869,0.010196,0.01087,0.0096553,0.0083808,0.0081015,0.010199,0.010877,0.0096485,0.0083669,0.0081043,0.010184,0.01086,0.0096486,0.0083669,0.0080864,0.010224,0.010876,0.0096551,0.0084155,0.0081087,0.01023,0.010863,0.0096905,0.0083857,0.0080852,0.010203,0.010871,0.0096651,0.0083658,0.0080884,0.010226,0.010859,0.0096605,0.0083923,0.0081068,0.010196,0.010826,0.0096574,0.00838,0.0081117,0.010188,0.010862,0.0096544,0.0083842,0.0081173,0.010191,0.010851,0.0096522,0.0083952,0.0080864,0.0102,0.01087,0.0096808,0.008411,0.0080885,0.010202,0.010853,0.0096537,0.0083972,0.0080681,0.010165,0.01083,0.0096433,0.0083919,0.0080442,0.010171,0.010823,0.0096355,0.0083936,0.0080512,0.010154,0.010849,0.0096314,0.0083762,0.0080606,0.010153,0.010859,0.0096682,0.0083826,0.0080505,0.010153,0.010814,0.0096399,0.0083871,0.0080546,0.010148,0.010831,0.00965,0.0083727,0.0080399,0.010178,0.010817,0.0096811,0.0083782,0.0080441,0.010132,0.010829,0.0096174,0.0083752,0.0080377,0.010163,0.010831,0.0096518,0.0083588,0.0080632,0.010133,0.010845,0.0096495,0.0083863,0.0080243,0.010135,0.010857,0.0096393,0.0083618,0.0080605,0.010173,0.010833,0.0096739,0.0083849,0.0080298,0.010131,0.010837,0.0096353,0.0083682,0.0080577,0.010172,0.01082,0.0096747,0.0083842,0.0080459,0.010145,0.010795,0.0096728,0.0083768,0.0080517,0.010125,0.010819,0.0097069,0.0083845,0.0080569,0.010118,0.010828,0.0096988,0.0083913,0.0080706,0.010129,0.010821,0.0096431,0.0084015,0.0080235,0.010137,0.010797,0.0096815,0.008411,0.0080408,0.010128,0.01083,0.0096566,0.0083891,0.008028,0.010144,0.010828,0.0097043,0.0083962,0.0080283,0.010116,0.0048121:5
1.1667E-7,1.5633E-6,-7.2667E-7,1.81E-6,-1.4667E-7,1.2533E-6,3.4E-7,-1.2667E-6,1.7967E-6,3.1667E-7,8.6667E-7,1.8733E-6,-1.1667E-6,1.8767E-6,7.1E-7,-1.55E-6,2.33E-6,-1.1333E-7,2.4033E-6,9.5333E-7,-5.8333E-7,9.8E-7,-6.3333E-7,1.9367E-6,-5.3667E-7,2.2219E-4,5.1822E-4,3.3416E-4,3.8808E-4,4.2106E-4,4.9106E-4,4.6386E-4,3.6824E-4,3.6573E-4,4.321E-4,4.9644E-4,4.5923E-4,0.0031972,0.0042437,0.0050427,0.0052833,0.0043832,0.0039494,0.0042094,0.005143,0.0053684,0.0044343,0.004048,0.0042486,0.0052188,0.0054363,0.0044871,0.0040967,0.009056,0.01161,0.01195,0.0096709,0.009089,0.0093493,0.011639,0.011989,0.0098411,0.0090983,0.0095013,0.01175,0.012166,0.0099851,0.0091924,0.0095895,0.011857,0.012292,0.010058,0.0092507,0.0097055,0.011992,0.012375,0.010161,0.0093736,0.009812,0.012135,0.012531,0.010245,0.0094668,0.0098962,0.012237,0.012667,0.01038,0.0095374,0.010022,0.012357,0.012746,0.010426,0.0096249,0.010078,0.012435,0.012862,0.010525,0.0097449,0.010161,0.012546,0.012976,0.010622,0.0097691,0.010277,0.012662,0.013022,0.010682,0.009866,0.010329,0.012755,0.01318,0.010778,0.0099374,0.01045,0.012835,0.013267,0.010874,0.010018,0.010492,0.012938,0.013379,0.010885,0.010083,0.010603,0.01307,0.013445,0.011015,0.010174,0.010635,0.013159,0.013579,0.011051,0.01027,0.010712,0.013222,0.013658,0.011165,0.010313,0.010773,0.013296,0.01375,0.011229,0.01036,0.0109,0.013383,0.013806,0.011319,0.010469,0.010919,0.013493,0.013904,0.011344,0.010545,0.011044,0.013585,0.013974,0.011432,0.010564,0.011041,0.013644,0.014104,0.011519,0.010639,0.011139,0.013731,0.014106,0.01156,0.010695,0.011185,0.013825,0.014263,0.011622,0.010757,0.011266,0.013922,0.014333,0.011694,0.010841,0.011347,0.013957,0.014407,0.011775,0.010893,0.011371,0.014015,0.014503,0.011848,0.010951,0.011454,0.014152,0.014611,0.011897,0.011,0.011539,0.014187,0.014659,0.012034,0.011091,0.011606,0.014299,0.014777,0.012039,0.011157,0.011658,0.014385,0.014766,0.012112,0.011212,0.011709,0.014474,0.0149,0.012176,0.011238,0.01177,0.0145,0.014942,0.012241,0.011321,0.011857,0.014629,0.015043,0.012281,0.011362,0.011911,0.014662,0.015093,0.012372,0.011404,0.011951,0.014771,0.015192,0.012406,0.011501,0.012052,0.01479,0.015265,0.012487,0.011518,0.012133,0.014886,0.015324,0.012541,0.011608,0.012133,0.01494,0.015385,0.012576,0.011675,0.012176,0.015032,0.015505,0.012667,0.011683,0.012257,0.015112,0.015552,0.012707,0.011756,0.012269,0.015163,0.015615,0.012762,0.011803,0.012367,0.015278,0.015624,0.012791,0.011879,0.012411,0.015275,0.015727,0.012843,0.011868,0.012479,0.015341,0.015761,0.012914,0.011933,0.012527,0.015395,0.015909,0.012967,0.012009,0.012579,0.015504,0.015947,0.013025,0.01207,0.012621,0.015529,0.015943,0.013063,0.012089,0.01267,0.015627,0.016048,0.013133,0.012155,0.01276,0.015699,0.016121,0.013162,0.012191,0.012807,0.015701,0.01619,0.013229,0.012254,0.012832,0.015765,0.016253,0.013282,0.012308,0.012906,0.015878,0.016322,0.013349,0.012329,0.012941,0.01594,0.01634,0.013387,0.012345,0.013012,0.015992,0.016438,0.013448,0.012406,0.013039,0.015963,0.016461,0.013467,0.012456,0.013117,0.016076,0.016491,0.013532,0.012487,0.013098,0.01613,0.016591,0.013577,0.01254,0.01317,0.016199,0.016633,0.013635,0.0126,0.013192,0.016258,0.016703,0.013631,0.012663,0.013316,0.016327,0.016752,0.013679,0.012703,0.013364,0.016381,0.016851,0.013773,0.012726,0.01337,0.016369,0.01688,0.013856,0.012763,0.013381,0.016455,0.016904,0.013789,0.012808,0.013481,0.016552,0.017016,0.013877,0.012891,0.013492,0.016554,0.017074,0.013897,0.012856,0.013522,0.016643,0.017081,0.014008,0.012962,0.013584,0.016706,0.017193,0.01409,0.012988,0.013629,0.016715,0.017178,0.014079,0.013011,0.013666,0.016786,0.017275,0.014113,0.013068,0.013691,0.016867,0.017371,0.014243,0.013155,0.013767,0.016975,0.017429,0.014208,0.013154,0.013838,0.016952,0.017488,0.014294,0.013219,0.013862,0.016982,0.017526,0.014288,0.013236,0.013917,0.017071,0.017545,0.014378,0.013313,0.013927,0.017103,0.017545,0.014427,0.013307,0.013977,0.017149,0.017676,0.014461,0.013389,0.014009,0.017227,0.017678,0.014499,0.013364,0.014019,0.01725,0.017759,0.014567,0.013469,0.014068,0.01734,0.017812,0.014513,0.01347,0.014116,0.017369,0.017831,0.014626,0.013547,0.014163,0.017363,0.017932,0.014637,0.013595,0.01417,0.017446,0.017973,0.014692,0.013595,0.014232,0.017507,0.018003,0.014737,0.01365,0.014243,0.017521,0.018023,0.014793,0.013658,0.01427,0.017581,0.018074,0.014796,0.013728,0.014353,0.01765,0.018167,0.014862,0.013711,0.014316,0.017669,0.018193,0.014902,0.013786,0.014415,0.017734,0.018196,0.014954,0.013793,0.014401,0.017743,0.018318,0.015003,0.013823,0.014469,0.017777,0.018371,0.014985,0.013858,0.014498,0.017855,0.018377,0.015077,0.013915,0.014548,0.017923,0.018429,0.015142,0.014011,0.014578,0.017936,0.018488,0.015143,0.013979,0.014616,0.01796,0.018506,0.01511,0.014051,0.014653,0.017995,0.018542,0.015198,0.014037,0.01466,0.018056,0.018558,0.015249,0.014102,0.014705,0.018094,0.018647,0.015254,0.014076,0.014757,0.018094,0.018666,0.015305,0.014103,0.014757,0.018217,0.018749,0.015316,0.014177,0.014802,0.018234,0.018704,0.015343,0.014186,0.01479,0.018282,0.018743,0.015403,0.014212,0.014861,0.018305,0.018806,0.015415,0.014239,0.014866,0.018371,0.018814,0.015464,0.014277,0.014918,0.018368,0.018865,0.01551,0.014262,0.014935,0.018381,0.018971,0.015479,0.014336,0.014978,0.018438,0.018988,0.015547,0.014381,0.014953,0.018476,0.019004,0.015579,0.014374,0.01498,0.018486,0.019026,0.015638,0.014463,0.015045,0.018507,0.01906,0.015668,0.01443,0.015091,0.018538,0.019127,0.015683,0.014474,0.015105,0.018572,0.019125,0.015667,0.014481,0.015137,0.018654,0.019233,0.015804,0.014562,0.015145,0.01873,0.019203,0.015742,0.01458,0.015164,0.018742,0.019274,0.015835,0.014603,0.015232,0.018763,0.019266,0.015844,0.014571,0.015214,0.018802,0.019322,0.015869,0.014675,0.01528,0.018742,0.019424,0.015845,0.014642,0.015317,0.018894,0.019385,0.01594,0.014725,0.015347,0.018859,0.019504,0.015959,0.014753,0.01535,0.018935,0.019423,0.0086863:5
-7.9E-7,2.1133E-6,-1.1667E-6,1.9167E-6,2.5E-7,6.8E-7,2.08E-6,-5.5333E-7,1.94E-6,5.0667E-7,4.8333E-7,1.09E-6,2.8667E-7,2.49E-6,-2.9667E-7,-9.3333E-8,1.6967E-6,-1.61E-6,1.9967E-6,4.7667E-7,1.9667E-7,1.8767E-6,-1.0567E-6,2.2267E-6,1.2933E-6,-1.6967E-6,1.0733E-6,-1.8167E-6,2.2533E-6,-4.0E-7,2.6667E-8,1.4333E-6,-4.0333E-7,4.119E-4,4.3944E-4,4.9529E-4,4.4746E-4,3.9197E-4,3.4308E-4,4.3086E-4,4.8531E-4,4.5818E-4,3.7969E-4,3.5243E-4,4.2486E-4,0.0047982,0.007072,0.0059816,0.0065047,0.0078405,0.0082935,0.0069815,0.0062467,0.0064664,0.0080143,0.0084085,0.012913,0.013707,0.013388,0.017078,0.017748,0.014764,0.013525,0.013658,0.017122,0.017885,0.014969,0.013583,0.013884,0.017264,0.018047,0.015086,0.013674,0.013931,0.017411,0.018159,0.015242,0.013821,0.014076,0.017564,0.018361,0.015361,0.013904,0.014174,0.017668,0.018432,0.015448,0.014048,0.014334,0.017842,0.018661,0.015599,0.014086,0.014435,0.017948,0.018685,0.015724,0.014178,0.014459,0.018077,0.018871,0.015844,0.014333,0.014578,0.018153,0.018999,0.015947,0.014416,0.014685,0.018268,0.019107,0.016077,0.014473,0.014753,0.018379,0.019156,0.016096,0.014573,0.014809,0.018449,0.01932,0.016166,0.014652,0.014923,0.018565,0.019417,0.016327,0.014728,0.014926,0.018608,0.01949,0.016341,0.014777,0.014986,0.01873,0.019555,0.016471,0.014868,0.015076,0.018813,0.019762,0.016519,0.014945,0.01517,0.01889,0.019785,0.016619,0.015032,0.015184,0.019004,0.019886,0.016682,0.015099,0.015301,0.01905,0.019948,0.01681,0.015155,0.015358,0.019162,0.020037,0.016893,0.015184,0.015449,0.019199,0.020137,0.016996,0.015247,0.015448,0.019345,0.020198,0.017038,0.015314,0.015527,0.019391,0.020228,0.017095,0.015353,0.015622,0.01937,0.020304,0.017104,0.01546,0.015609,0.019468,0.0204,0.017201,0.015467,0.015692,0.019607,0.020462,0.017291,0.015567,0.015681,0.019618,0.020511,0.0173,0.015661,0.015715,0.019694,0.020601,0.017395,0.015699,0.01583,0.019714,0.020651,0.017472,0.015684,0.015865,0.019826,0.020704,0.017448,0.015739,0.015824,0.0198,0.020777,0.017529,0.015788,0.015936,0.019821,0.020807,0.017536,0.015733,0.015978,0.019871,0.020824,0.017582,0.015849,0.015955,0.019933,0.020915,0.017665,0.015824,0.015995,0.019903,0.020823,0.017637,0.015819,0.016017,0.019999,0.020955,0.017701,0.015875,0.016071,0.02,0.020994,0.017782,0.01592,0.016032,0.020083,0.021033,0.017775,0.015968,0.016105,0.020113,0.021105,0.017811,0.015975,0.016102,0.02011,0.021083,0.017842,0.015989,0.016168,0.020163,0.021107,0.017875,0.015974,0.016099,0.020188,0.021185,0.017893,0.01607,0.016135,0.020175,0.021209,0.017946,0.016058,0.016174,0.020178,0.021128,0.017966,0.016119,0.016178,0.020249,0.02121,0.01802,0.016194,0.016187,0.020305,0.021338,0.018045,0.016187,0.016222,0.020317,0.021294,0.018061,0.016162,0.016262,0.020338,0.021378,0.018166,0.016255,0.016267,0.020402,0.02142,0.018177,0.016247,0.016296,0.020379,0.021407,0.018154,0.016246,0.016354,0.020401,0.02147,0.018222,0.016327,0.016332,0.020421,0.02151,0.018234,0.016304,0.016321,0.020488,0.021445,0.018233,0.016331,0.016387,0.020493,0.021545,0.018303,0.016359,0.016409,0.020517,0.021548,0.018337,0.01637,0.01633,0.020516,0.02155,0.018345,0.016379,0.016416,0.020502,0.021537,0.018408,0.016437,0.016435,0.020604,0.021604,0.018382,0.0164,0.016417,0.020594,0.021545,0.018495,0.016428,0.016449,0.020577,0.021617,0.018468,0.016433,0.01644,0.020597,0.021605,0.018521,0.016423,0.016466,0.020636,0.021631,0.018507,0.01645,0.016419,0.020662,0.021621,0.018534,0.016452,0.016492,0.020619,0.021689,0.018458,0.016537,0.016468,0.020589,0.021743,0.018531,0.016507,0.016491,0.020611,0.021762,0.018578,0.016537,0.016462,0.020606,0.021731,0.018569,0.016558,0.016456,0.020657,0.021697,0.018542,0.016483,0.01651,0.020657,0.021717,0.018648,0.01656,0.016466,0.020647,0.02178,0.018575,0.016537,0.016506,0.020661,0.021787,0.01867,0.016529,0.016478,0.020705,0.021791,0.018687,0.016535,0.016493,0.02065,0.021755,0.018668,0.016619,0.016511,0.02068,0.021761,0.01867,0.016546,0.016542,0.020704,0.021786,0.01872,0.016597,0.0164,0.020719,0.021726,0.018661,0.016596,0.016494,0.020743,0.021765,0.018723,0.01661,0.016484,0.020659,0.021822,0.018654,0.016646,0.016493,0.020708,0.021791,0.018769,0.016628,0.016488,0.020682,0.021807,0.01876,0.016631,0.016545,0.020682,0.021804,0.018761,0.016637,0.016509,0.020694,0.021862,0.018741,0.016623,0.016509,0.020673,0.021777,0.018757,0.01663,0.016501,0.020678,0.021814,0.018781,0.016638,0.016476,0.020655,0.021858,0.0096098:5
1.79E-6,3.1333E-7,1.2667E-6,1.21E-6,-1.5333E-6,1.4733E-6,7.5333E-7,1.7767E-6,6.7333E-7,-3.15E-6,2.6433E-6,-1.4533E-6,5.4667E-7,2.22E-6,-5.4333E-7,1.58E-6,1.6667E-7,1.0067E-6,1.2967E-6,-5.5333E-7,2.85E-6,-1.6533E-6,1.5033E-6,1.31E-6,-1.4E-6,1.07E-6,-2.9E-7,7.522E-5,5.7243E-4,4.3739E-4,3.7545E-4,3.5345E-4,4.1335E-4,4.935E-4,4.5276E-4,3.5996E-4,3.6779E-4,0.0036353,0.0094878,0.0081558,0.0069475,0.007795,0.0091592,0.0095748,0.0083888,0.0068874,0.0079636,0.009206,0.0096776,0.01713,0.014431,0.01635,0.019023,0.019753,0.017531,0.01425,0.016544,0.019076,0.019949,0.017692,0.014367,0.016678,0.019217,0.020164,0.017921,0.014396,0.016787,0.019302,0.02027,0.018054,0.014459,0.016862,0.019416,0.02041,0.018144,0.014529,0.016938,0.019496,0.020408,0.018288,0.014689,0.016999,0.019571,0.020614,0.018345,0.014752,0.017024,0.019614,0.02068,0.018443,0.014817,0.017149,0.019705,0.020887,0.018606,0.014861,0.017177,0.019805,0.02094,0.018759,0.015,0.017256,0.019873,0.021066,0.01881,0.015011,0.017314,0.019914,0.021095,0.018908,0.015148,0.017367,0.019983,0.021207,0.019051,0.015141,0.01743,0.020035,0.021204,0.019085,0.015212,0.01748,0.020052,0.021312,0.019228,0.015317,0.017544,0.020066,0.021431,0.01929,0.015358,0.017492,0.020173,0.021556,0.019336,0.015401,0.017522,0.020184,0.021608,0.019446,0.015449,0.017575,0.020214,0.021666,0.019544,0.015494,0.017659,0.020184,0.021641,0.019611,0.015581,0.017669,0.020254,0.021767,0.019705,0.015581,0.017675,0.020343,0.021789,0.019742,0.015598,0.017664,0.020307,0.021811,0.019751,0.015687,0.017715,0.020375,0.021864,0.019896,0.015733,0.017746,0.020296,0.021927,0.019911,0.015764,0.01772,0.020292,0.021974,0.019963,0.015765,0.017722,0.020311,0.021949,0.019973,0.015786,0.017641,0.02029,0.022011,0.020063,0.015791,0.017665,0.020402,0.022043,0.02015,0.015837,0.017754,0.020375,0.022103,0.020203,0.015879,0.017711,0.02028,0.022065,0.020171,0.015913,0.017672,0.02031,0.022081,0.020233,0.015975,0.017697,0.020277,0.022123,0.020386,0.015996,0.017744,0.020354,0.022168,0.020394,0.015976,0.017669,0.020247,0.022164,0.020369,0.015997,0.017676,0.020314,0.022185,0.020428,0.015973,0.017682,0.020223,0.022179,0.020459,0.01601,0.017655,0.020221,0.022101,0.02046,0.016019,0.017641,0.02021,0.022222,0.020498,0.016046,0.017617,0.020152,0.022103,0.020529,0.016118,0.017614,0.020154,0.02217,0.020649,0.016155,0.017616,0.020147,0.022207,0.020636,0.016128,0.01755,0.020098,0.02232,0.020663,0.016187,0.017643,0.02016,0.022238,0.020703,0.016127,0.017529,0.020124,0.022369,0.020726,0.016181,0.017578,0.020115,0.022271,0.020725,0.016188,0.017503,0.020022,0.02231,0.020739,0.016128,0.01751,0.019986,0.022282,0.020785,0.016245,0.017496,0.019992,0.022275,0.02084,0.016224,0.017524,0.019973,0.022227,0.020873,0.016239,0.017425,0.019886,0.022207,0.020887,0.016231,0.017473,0.019913,0.022261,0.020947,0.016279,0.01737,0.019792,0.022317,0.02092,0.016254,0.017406,0.019805,0.022214,0.020911,0.016311,0.017404,0.019744,0.022123,0.020953,0.016282,0.017375,0.019853,0.022131,0.020897,0.016296,0.017408,0.019744,0.022235,0.020967,0.01634,0.017312,0.019724,0.022199,0.020993,0.016321,0.017297,0.019712,0.022171,0.021013,0.016318,0.017242,0.019616,0.022129,0.021041,0.016365,0.017258,0.019578,0.022163,0.020966,0.016295,0.017239,0.019546,0.02217,0.02109,0.016361,0.017153,0.01946,0.022043,0.021075,0.016356,0.017119,0.019387,0.022073,0.020978,0.016419,0.017114,0.019418,0.022088,0.021092,0.016449,0.017147,0.019402,0.022075,0.021121,0.01642,0.017104,0.019328,0.022051,0.021113,0.016428,0.017099,0.019329,0.022,0.021107,0.016432,0.017085,0.01926,0.022009,0.021122,0.016476,0.017092,0.019297,0.021983,0.021167,0.016439,0.01705,0.019193,0.022051,0.02116,0.016442,0.016959,0.019154,0.022005,0.021206,0.01645,0.016952,0.019145,0.021955,0.021181,0.016426,0.016995,0.019088,0.021898,0.021216,0.016485,0.016999,0.019049,0.021946,0.021221,0.016509,0.016901,0.018955,0.021947,0.021191,0.016537,0.016836,0.018916,0.021896,0.021202,0.016582,0.01692,0.018895,0.02189,0.021206,0.016546,0.016849,0.018806,0.021838,0.021279,0.016541,0.016823,0.018848,0.021803,0.021231,0.016624,0.016792,0.018771,0.021865,0.021198,0.016643,0.016799,0.018768,0.021845,0.02124,0.016723,0.016742,0.018674,0.021808,0.021279,0.01663,0.016775,0.018611,0.021742,0.021285,0.016663,0.016719,0.018651,0.021748,0.021208,0.016633,0.016705,0.018583,0.021736,0.021241,0.016702,0.016694,0.018495,0.021679,0.021255,0.016646,0.016661,0.018431,0.021658,0.021327,0.016741,0.016633,0.018415,0.021611,0.021288,0.016687,0.016689,0.018341,0.021641,0.021308,0.016739,0.01661,0.018353,0.021627,0.021281,0.016717,0.016615,0.018279,0.021594,0.021238,0.016684,0.016543,0.018223,0.021541,0.021329,0.01677,0.016595,0.018144,0.021557,0.021271,0.016801,0.016518,0.018157,0.021556,0.021329,0.016787,0.016541,0.018066,0.021534,0.021329,0.016855,0.016477,0.01809,0.021516,0.021236,0.016897,0.016454,0.018063,0.021447,0.021324,0.016892,0.016455,0.018026,0.011397:5
0.0091531,0.0090648,0.010757,0.011835,0.011256,0.008968,0.009245,0.010674,0.011861,0.011326,0.0089269,0.0093229,0.01062,0.011858,0.011317,0.0089113,0.0093027,0.010607,0.011817,0.011348,0.008922,0.0092777,0.01061,0.011869,0.011358,0.0089379,0.0092831,0.010534,0.011861,0.011335,0.0089309,0.0092968,0.010558,0.011871,0.011369,0.0089207,0.00928,0.010538,0.011866,0.011395,0.0089526,0.0092672,0.010538,0.011887,0.011364,0.0089252,0.0092678,0.010492,0.011845,0.011365,0.0089546,0.0092584,0.010536,0.01188,0.011364,0.0089472,0.0092573,0.010506,0.01183,0.011407,0.0090095,0.0092452,0.010466,0.011844,0.011423,0.0089813,0.0092993,0.010513,0.011904,0.011437,0.0089636,0.0092539,0.010456,0.01185,0.011435,0.0090057,0.0092476,0.010475,0.011884,0.011452,0.0090021,0.0092483,0.010492,0.011832,0.01145,0.0090306,0.0092388,0.010451,0.01186,0.011465,0.0090232,0.0092455,0.010436,0.011881,0.011478,0.0090305,0.0092506,0.010447,0.011848,0.011461,0.0090476,0.0092337,0.010436,0.01191,0.011467,0.0090497,0.0092404,0.01043,0.011876,0.011463,0.0090647,0.0092268,0.010404,0.011877,0.011461,0.0090734,0.0092504,0.010403,0.011883,0.011514,0.0090966,0.0092402,0.010392,0.011876,0.011513,0.0090861,0.0092011,0.010366,0.011851,0.011493,0.0090844,0.0092153,0.010358,0.011835,0.01153,0.009099,0.0092234,0.010337,0.011848,0.011493,0.0091298,0.0092262,0.010337,0.011835,0.011516,0.0090828,0.009193,0.01029,0.011855,0.011479,0.0091195,0.0091866,0.010319,0.011913,0.011506,0.009136,0.0091952,0.010325,0.011842,0.011533,0.0091461,0.009157,0.010241,0.011855,0.011525,0.0091673,0.0091822,0.010289,0.011866,0.011529,0.0091285,0.009184,0.010258,0.011852,0.011535,0.0091471,0.0091485,0.010276,0.01181,0.011547,0.0091689,0.0091907,0.010272,0.011823,0.01156,0.0091399,0.009168,0.010258,0.01181,0.011573,0.0091825,0.0091606,0.010212,0.011816,0.011572,0.0092075,0.0091681,0.010238,0.011823,0.011591,0.0091945,0.009161,0.01022,0.01187,0.011591,0.0092284,0.0091534,0.010203,0.011799,0.011615,0.009213,0.0091679,0.010159,0.011805,0.01156,0.0092306,0.009137,0.010199,0.011825,0.011585,0.0092492,0.0091573,0.010169,0.011835,0.011601,0.0092315,0.0091355,0.010169,0.011787,0.011599,0.0092721,0.0091236,0.010132,0.011869,0.01159,0.0092373,0.0091362,0.010165,0.011801,0.011616,0.0092613,0.0091379,0.010135,0.011822,0.011621,0.0092667,0.009142,0.010135,0.011901,0.011657,0.0:5
-7.3667E-7,5.29E-6,2.9933E-6,2.1033E-6,6.17E-6,3.3333E-8,5.8067E-6,3.43E-6,3.23E-6,6.4367E-6,-8.8E-7,5.2667E-6,2.4033E-6,3.9467E-6,5.38E-6,1.85E-6,6.0867E-6,1.7733E-6,3.4533E-6,5.6233E-6,-2.8667E-7,6.1567E-6,3.0733E-6,1.1733E-6,4.35E-6,-9.6333E-7,5.9867E-6,4.28E-6,0.0065562,0.010345,0.0088046,0.009951,0.011663,0.012014,0.010146,0.009126,0.0097414,0.011801,0.01208,0.01009,0.0092142,0.0096389,0.011816,0.012089,0.010087,0.0092125,0.0096404,0.011818,0.012081,0.010093,0.0092355,0.0096071,0.011788,0.012108,0.010096,0.0092593,0.0095853,0.011809,0.012049,0.010105,0.009243,0.0096018,0.01183,0.012071,0.010105,0.0092358,0.0096135,0.011796,0.012072,0.010131,0.0092419,0.009558,0.011798,0.012099,0.010136,0.0092418,0.0095723,0.011773,0.012094,0.010161,0.0092382,0.0095558,0.011793,0.012116,0.010185,0.0092396,0.0095659,0.011752,0.012095,0.010209,0.0092387,0.0095673,0.01175,0.01211,0.01016,0.009237,0.0095414,0.011763,0.012116,0.010188,0.0092387,0.0095033,0.011751,0.012067,0.010221,0.0092259,0.0095411,0.011766,0.012098,0.01021,0.0092699,0.0095095,0.011732,0.012095,0.010204,0.0092426,0.0094677,0.01175,0.012096,0.010268,0.0092524,0.009472,0.011745,0.012149,0.010257,0.0092911,0.0094617,0.011745,0.012125,0.010304,0.0092836,0.0094707,0.011693,0.01214,0.010305,0.0092622,0.0094575,0.011713,0.012141,0.010299,0.0092591,0.0094543,0.011742,0.012133,0.010353,0.0092827,0.0094716,0.011718,0.012142,0.010374,0.009305,0.0094391,0.011706,0.012132,0.010351,0.0093074,0.0094248,0.011717,0.01213,0.010386,0.0093174,0.0093874,0.01172,0.012146,0.010386,0.0093313,0.0093843,0.011697,0.012127,0.010365,0.0093314,0.0094056,0.011665,0.012141,0.010403,0.0093063,0.0093986,0.01168,0.012138,0.010394,0.0093365,0.0093566,0.011648,0.01212,0.010416,0.0093269,0.0093868,0.011697,0.012143,0.010444,0.0093289,0.0093992,0.01164,0.012133,0.010458,0.0093365,0.0093192,0.011632,0.012142,0.010476,0.0093441,0.0093313,0.011625,0.012132,0.010468,0.0093265,0.0093367,0.011636,0.012159,0.01051,0.0093109,0.0093141,0.011626,0.01212,0.010497,0.0093393,0.0092949,0.011619,0.01214,0.010527,0.0093263,0.009318,0.011612,0.012131,0.010566,0.0093486,0.0093238,0.011566,0.012097,0.010536,0.0093686,0.009283,0.011613,0.012137,0.01052,0.0093396,0.0092679,0.011579,0.012092,0.010567,0.0093689,0.0092671,0.011593,0.012144,0.010568,0.0093455,0.0092532,0.011584,0.012132,0.010598,0.0093639,0.0092335,0.011575,0.012134,0.010634,0.0093462,0.0092341,0.011575,0.012097,0.010595,0.0093663,0.00923,0.011586,0.012139,0.010619,0.0093643,0.0092356,0.01158,0.012108,0.010665,0.0093735,0.0092028,0.011546,0.012113,0.010645,0.0093671,0.009202,0.011554,0.012111,0.010656,0.0094075,0.009209,0.011539,0.012137,0.010674,0.0093977,0.0092039,0.011531,0.012118,0.010665,0.0093991,0.0091776,0.01149,0.012103,0.010707,0.0093714,0.009177,0.011491,0.012122,0.0107,0.0094013,0.0091738,0.011528,0.012127,0.010736,0.0094297,0.009151,0.011478,0.012097,0.010738,0.0094191,0.0091101,0.011449,0.012133,0.010755,0.0094064,0.0091241,0.011481,0.012114,0.010706,0.009419,0.0091029,0.011426,0.012101,0.010751,0.0094207,0.0082112:5
0.015931,0.017569,0.020067,0.018968,0.014782,0.015692,0.017616,0.019934,0.019055,0.014827,0.015653,0.017499,0.020029,0.019057,0.014878,0.015623,0.017469,0.020095,0.018995,0.014978,0.015538,0.017556,0.019988,0.019009,0.01499,0.0155,0.017613,0.01992,0.019142,0.015,0.015531,0.017523,0.019938,0.019114,0.014996,0.015583,0.017431,0.019938,0.01911,0.014986,0.015519,0.017408,0.020032,0.019147,0.015105,0.01543,0.017395,0.01992,0.019203,0.015022,0.015487,0.017349,0.019875,0.019229,0.015015,0.015512,0.017255,0.019971,0.019133,0.015065,0.015472,0.017243,0.020013,0.019143,0.015174,0.015344,0.017247,0.019931,0.019187,0.015148,0.015426,0.017219,0.019912,0.019293,0.015158,0.015403,0.014058,4.3281E-4,2.7778E-4,-4.0872E-4,0.012015,0.017216,0.019929,0.019253,0.015348,0.015334,0.017089,0.01992,0.019262,0.015258,0.015348,0.017157,0.019829,0.019415,0.015249,0.015332,0.017052,0.019833,0.019386,0.015264,0.015376,0.016956,0.019909,0.019372,0.015287,0.015419,0.016954,0.019917,0.019268,0.015343,0.015305,0.016933,0.019919,0.019366,0.015385,0.015326,0.016892,0.019872,0.019451,0.015355,0.015374,0.016841,0.019996,0.019347,0.01547,0.01532,0.016772,0.019931,0.019433,0.015488,0.015238,0.016866,0.019849,0.019439,0.015499,0.015196,0.016899,0.019785,0.019529,0.015492,0.015302,0.016752,0.019799,0.019589,0.015467,0.015295,0.016682,0.019807,0.019504,0.015598,0.015307,0.016687,0.019864,0.019439,0.015665,0.015239,0.016675,0.019885,0.019576,0.015626,0.015291,0.016587,0.019821,0.01957,0.015566,0.015313,0.016567,0.019884,0.01956,0.015646,0.015226,0.016497,0.019809,0.019476,0.015794,0.015158,0.016526,0.019728,0.019558,0.015679,0.015183,0.016494,0.019665,0.019629,0.015742,0.015227,0.016456,0.019713,0.019672,0.015791,0.015239,0.016427,0.01978,0.019592,0.015771,0.015226,0.016464,0.019669,0.019656,0.01588,0.0:5
-8.9137E-5,2.9132E-4,-2.3066E-4,1.7795E-4,-2.8763E-5,-1.667E-5,5.795E-5,-3.85E-5,4.7913E-5,2.88E-6,-7.8733E-6,4.964E-4,0.013214,0.018444,0.01944,0.019007,0.016928,0.013977,0.017795,0.019564,0.019146,0.01672,0.014199,0.017583,0.019723,0.019121,0.016766,0.014164,0.017502,0.019647,0.019064,0.016774,0.014161,0.017556,0.019643,0.019213,0.016771,0.014217,0.017395,0.019636,0.019219,0.016754,0.014175,0.017429,0.01965,0.019088,0.016834,0.014157,0.017455,0.019534,0.01916,0.016884,0.014155,0.017438,0.019501,0.019261,0.016783,0.014119,0.017349,0.019597,0.019205,0.016841,0.014182,0.017356,0.019583,0.01926,0.016926,0.014169,0.017394,0.019413,0.01936,0.016901,0.014145,0.017336,0.019425,0.019344,0.016866,0.01418,0.017206,0.019542,0.019294,0.016973,0.01417,0.017227,0.019438,0.019275,0.017044,0.014146,0.017237,0.019446,0.019394,0.016912,0.014138,0.017165,0.019451,0.019402,0.017005,0.014174,0.017147,0.019481,0.019269,0.017076,0.014063,0.01721,0.019349,0.019388,0.017097,0.014108,0.017141,0.019273,0.019518,0.017095,0.014159,0.017095,0.019373,0.019439,0.017161,0.014159,0.017063,0.019361,0.019404,0.017163,0.014099,0.017088,0.01928,0.019609,0.017154,0.014186,0.017002,0.019288,0.019486,0.017141,0.014149,0.016963,0.019314,0.019423,0.017281,0.014143,0.017021,0.019317,0.019491,0.017248,0.014156,0.016964,0.019235,0.019519,0.017182,0.014117,0.01688,0.019299,0.019515,0.017291,0.014104,0.016841,0.019317,0.019506,0.017443,0.014068,0.01692,0.019171,0.019594,0.017374,0.014145,0.01687,0.019118,0.019661,0.017332,0.014145,0.016836,0.019196,0.01962,0.017361,0.014164,0.016781,0.019131,0.019562,0.017444,0.014119,0.016837,0.019003,0.019683,0.017466,0.014167,0.016714,0.019128,0.019668,0.017447,0.014169,0.016631,0.019117,0.019597,0.017556,0.014149,0.016684,0.019041,0.01955,0.017527,0.014171,0.016694,0.019009,0.0:5
-2.1517E-5,-7.8133E-6,-1.9187E-5,-2.1617E-5,-2.072E-5,-2.221E-5,-9.2833E-6,-1.8907E-5,-2.158E-5,-1.9883E-5,-2.261E-5,-9.24E-6,-2.059E-5,-2.1063E-5,-2.039E-5,-2.2463E-5,-8.8833E-6,-1.9633E-5,-2.2103E-5,-2.077E-5,-2.2817E-5,-9.1033E-6,-1.8413E-5,-2.103E-5,-1.9413E-5,-2.2533E-5,-8.4267E-6,-2.0297E-5,-2.2017E-5,-2.048E-5,-2.2217E-5,-8.5533E-6,-1.8547E-5,-2.1083E-5,-2.0747E-5,-2.3087E-5,-9.7567E-6,-1.97E-5,-2.1457E-5,-1.9363E-5,-2.2813E-5,-9.2167E-6,-1.9447E-5,-2.2097E-5,-1.9627E-5,-2.275E-5,-8.6067E-6,-1.901E-5,-2.0523E-5,-1.9953E-5,-2.2593E-5,-8.86E-6,-1.9727E-5,-2.0933E-5,-2.033E-5,-2.175E-5,-8.51E-6,0.0025664,0.020493,0.017341,0.016036,0.015109,0.019417,0.020276,0.017504,0.015765,0.015263,0.019232,0.020383,0.017462,0.015716,0.01526,0.019342,0.02032,0.017575,0.015649,0.015268,0.0193,0.020291,0.017608,0.015665,0.015297,0.019214,0.020348,0.017612,0.015603,0.015226,0.019278,0.020271,0.017608,0.015585,0.015246,0.019211,0.020248,0.017674,0.015578,0.015319,0.019143,0.020368,0.017591,0.015649,0.015187,0.019184,0.020302,0.017628,0.015659,0.01523,0.019209,0.02021,0.017567,0.015611,0.015241,0.019156,0.020327,0.017533,0.015675,0.015127,0.01916,0.02021,0.017577,0.015602,0.015185,0.019251,0.020145,0.017641,0.015581,0.015221,0.019136,0.020255,0.017571,0.015639,0.01508,0.019139,0.020264,0.017625,0.01567,0.01514,0.019181,0.020124,0.017641,0.015571,0.015187,0.019073,0.02028,0.01757,0.015623,0.015119,0.019011,0.020291,0.017572,0.015654,0.015144,0.01915,0.020212,0.01766,0.015555,0.015198,0.019016,0.020296,0.017603,0.015557,0.015106,0.019033,0.020243,0.01751,0.015666,0.015119,0.019085,0.020168,0.017606,0.015614,0.015154,0.019036,0.020173,0.017649,0.015672,0.015162,0.019042,0.020239,0.017504,0.015633,0.015047,0.019157,0.020166,0.017588,0.015599,0.01517,0.019083,0.020129,0.017646,0.015613,0.015152,0.018999,0.020271,0.017591,0.015624,0.015081,0.019105,0.020182,0.017677,0.0:5
-1.61E-5,-3.0433E-5,-3.617E-5,-1.4737E-5,-1.3297E-5,-1.7213E-5,-3.1813E-5,-3.635E-5,-1.475E-5,-1.3923E-5,-1.5743E-5,-3.263E-5,-3.657E-5,-1.514E-5,-1.3237E-5,-1.7097E-5,-3.1633E-5,-3.6543E-5,-1.5253E-5,-1.318E-5,-1.5603E-5,-3.2133E-5,-3.693E-5,-1.5613E-5,-1.3443E-5,-1.583E-5,-3.171E-5,-3.6157E-5,-1.5353E-5,-1.2493E-5,-1.631E-5,-3.1517E-5,-3.594E-5,-1.5787E-5,-1.3547E-5,-1.6393E-5,-3.3243E-5,-3.6837E-5,-1.5883E-5,-1.3303E-5,-1.5413E-5,-3.2557E-5,-3.6353E-5,-1.5883E-5,-1.2853E-5,-1.6657E-5,-3.1617E-5,-3.685E-5,-1.639E-5,-1.295E-5,-1.616E-5,-3.2223E-5,-3.6183E-5,-1.6043E-5,-1.3813E-5,-1.5893E-5,-3.1873E-5,-3.6583E-5,5.0147E-4,2.9833E-4,0.0015879,0.0042159,0.0035184,0.0031034,0.0036393,0.0042361,0.0042791,0.003629,0.0030876,0.003726,0.0042937,0.0052539,0.0072429,0.0062162,0.0074175,0.0086068,0.0086791,0.0073722,0.006301,0.0075461,0.0087295,0.0088428,0.0074939,0.0063805,0.0076549,0.0088239,0.0089691,0.0076489,0.0064936,0.0077855,0.0089712,0.009088,0.00771,0.0065825,0.0078943,0.0090972,0.0092197,0.0078007,0.0066423,0.0079976,0.0091912,0.0093504,0.0079287,0.0067478,0.008072,0.0092864,0.0094605,0.0080279,0.0068147,0.0081639,0.0094222,0.0095646,0.0081523,0.006902,0.0082452,0.0095029,0.0096849,0.0082214,0.0069641,0.0083595,0.009617,0.0098061,0.0083216,0.0070612,0.0084404,0.0097222,0.0099045,0.0084037,0.0071352,0.0085207,0.0098285,0.010042,0.0085243,0.0071956,0.0085895,0.009883,0.010115,0.0086291,0.0072625,0.0087036,0.0099939,0.010209,0.0087278,0.0073536,0.0087284,0.010098,0.010334,0.0087937,0.0074245,0.0088475,0.010162,0.010425,0.0088615,0.0074971,0.0089296,0.010317,0.010549,0.0089418,0.0075526,0.0089932,0.010356,0.010614,0.0090852,0.0076316,0.0090629,0.010434,0.010722,0.0091532,0.0076729,0.0090999,0.01052,0.010819,0.0092146,0.0077763,0.0091761,0.010611,0.010899,0.0092885,0.0078001,0.0092536,0.010639,0.011009,0.0093874,0.0078862,0.0092895,0.01071,0.01108,0.0094282,0.0079086,0.0093755,0.010813,0.011156,0.0095415,0.007981,0.0094164,0.010872,0.011267,0.0096466,0.0080584,0.0094749,0.010952,0.011331,0.0096935,0.0080895,0.0095476,0.01104,0.011414,0.0097628,0.0081614,0.0096207,0.011068,0.011513,0.0098356,0.0081886,0.0096787,0.011168,0.011556,0.0098669,0.0082742,0.009701,0.011202,0.011659,0.0099677,0.0083092,0.0098146,0.011268,0.011745,0.010023,0.0083668,0.00983,0.011327,0.011805,0.010135,0.0084045,0.0098799,0.011391,0.011853,0.010134,0.008442,0.0099546,0.011466,0.011905,0.010214,0.0085017,0.0099635,0.011517,0.011987,0.010276,0.008534,0.0099982,0.011494,0.012053,0.01033,0.0085813,0.010065,0.011618,0.012097,0.010443,0.0086233,0.010128,0.011656,0.012201,0.01048,0.0086935,0.010151,0.011709,0.01224,0.01053,0.0087365,0.010187,0.011766,0.012323,0.010574,0.0087674,0.010208,0.011836,0.012403,0.010672,0.0088331,0.010269,0.011871,0.012473,0.010724,0.0088662,0.010313,0.011891,0.012463,0.010778,0.0088801,0.010338,0.011954,0.012557,0.010797,0.0089445,0.010401,0.011984,0.012682,0.010856,0.0090171,0.010535,0.012157,0.012803,0.011063,0.00915,0.010642,0.012283,0.0129,0.011154,0.0091732,0.010652,0.012256,0.012963,0.0112,0.009208,0.010711,0.012259,0.013009,0.01119,0.0092469,0.010695,0.012356,0.013083,0.011283,0.0092807,0.010766,0.012396,0.013135,0.011337,0.009329,0.010826,0.012462,0.013191,0.011372,0.0093593,0.010804,0.012462,0.013238,0.01145,0.0093663,0.010805,0.012487,0.013236,0.01145,0.0093715,0.010795,0.01247,0.013258,0.011474,0.0094067,0.010875,0.012519,0.013328,0.011508,0.0094523,0.010896,0.01255,0.013401,0.01156,0.0094655,0.010907,0.01256,0.013457,0.01163,0.0095305,0.01095,0.012647,0.013452,0.011688,0.0095486,0.010984,0.012655,0.013521,0.011754,0.0095928,0.010976,0.012685,0.013569,0.01177,0.0096286,0.010978,0.012711,0.013622,0.011831,0.0096629,0.011052,0.012746,0.013721,0.011903,0.0096932,0.011097,0.012747,0.013711,0.011924,0.00975,0.011103,0.012833,0.013735,0.012009,0.0097696,0.01114,0.012869,0.013836,0.012041,0.0097846,0.011153,0.012917,0.013875,0.012055,0.0098259,0.01116,0.012903,0.013911,0.01212,0.009854,0.01123,0.012943,0.013982,0.012152,0.0098707,0.011216,0.01296,0.013981,0.012214,0.0098782,0.011289,0.012945,0.014005,0.012245,0.0099334,0.011262,0.012979,0.014042,0.012314,0.0099329,0.011275,0.012961,0.01409,0.012291,0.0099766,0.011329,0.013037,0.014102,0.012366,0.010006,0.011297,0.013091,0.014176,0.01241,0.010036,0.011333,0.013087,0.014169,0.012452,0.010036,0.011368,0.01313,0.014265,0.012474,0.010099,0.01134,0.013124,0.014259,0.012513,0.010106,0.011404,0.013143,0.014296,0.012538,0.010119,0.011422,0.013132,0.014306,0.012559,0.010154,0.011428,0.013164,0.014373,0.012632,0.010175,0.011463,0.013242,0.014363,0.012699,0.010219,0.01146,0.013221,0.014442,0.012713,0.010226,0.01147,0.01323,0.014455,0.012764,0.010269,0.011507,0.013234,0.014521,0.012801,0.01029,0.011543,0.013255,0.014569,0.012826,0.01028,0.011543,0.013289,0.014619,0.012895,0.01032,0.011526,0.013281,0.014598,0.012914,0.01037,0.01156,0.013314,0.014617,0.012946,0.010389,0.011554,0.013357,0.014665,0.012967,0.010387,0.01157,0.013353,0.01472,0.013048,0.010456,0.01165,0.013379,0.014792,0.013088,0.010453,0.011573,0.013352,0.0148,0.013133,0.010499,0.011635,0.013391,0.014793,0.013166,9.9483E-4:5
-3.5147E-5,-2.1473E-5,-6.7E-6,-2.3457E-5,-2.8343E-5,-3.5393E-5,-2.156E-5,-6.3833E-6,-2.211E-5,-2.733E-5,-3.5263E-5,-2.2677E-5,-6.4167E-6,-2.4377E-5,-2.837E-5,-3.574E-5,-2.255E-5,-6.27E-6,-2.274E-5,-2.92E-5,-3.5913E-5,-2.237E-5,-7.0267E-6,-2.2723E-5,-2.737E-5,-3.6133E-5,-2.2353E-5,-5.9367E-6,-2.209E-5,-2.699E-5,-3.7223E-5,-2.374E-5,-7.2767E-6,-2.1637E-5,-2.703E-5,-3.67E-5,-2.2523E-5,-6.9867E-6,-2.1047E-5,-2.6397E-5,-3.7187E-5,-2.34E-5,-6.2433E-6,-2.2227E-5,-2.7257E-5,-3.792E-5,-2.4533E-5,-6.4333E-6,-2.095E-5,-2.5403E-5,-3.8493E-5,-2.4807E-5,-6.3067E-6,-2.0787E-5,-2.6207E-5,-3.8237E-5,-2.407E-5,-6.15E-6,-2.1027E-5,-2.6373E-5,-3.786E-5,3.7469E-4,4.251E-4,0.0041365,0.0044195,0.0037196,0.0032314,0.0035357,0.0042914,0.0045333,0.0037026,0.0034022,0.0035313,0.0043768,0.0085955,0.0074016,0.0067815,0.0070774,0.0087709,0.0092619,0.0075392,0.0069083,0.0071349,0.0088683,0.0093875,0.0076609,0.0070132,0.0071837,0.0089296,0.0094936,0.0077907,0.0071432,0.0072567,0.0090711,0.0096718,0.007914,0.0072378,0.0073598,0.0092003,0.0097636,0.0080492,0.0073335,0.0074018,0.0092818,0.0099143,0.0081499,0.0074366,0.0074922,0.0093738,0.010015,0.0082951,0.0075026,0.0075665,0.0094611,0.010114,0.0084243,0.0076276,0.0076107,0.0095579,0.010249,0.008579,0.0077303,0.0077,0.0096249,0.010378,0.0086639,0.0078038,0.0077656,0.0097316,0.010481,0.0087866,0.0078479,0.0078135,0.0097892,0.010613,0.0089309,0.0079583,0.0078609,0.0098704,0.010669,0.0090428,0.0080502,0.0079297,0.0099525,0.010778,0.0091522,0.0081388,0.0079672,0.010003,0.010891,0.009258,0.0082323,0.0080575,0.010055,0.010972,0.0094084,0.0083,0.0080935,0.010143,0.011078,0.0095111,0.0083728,0.0081825,0.010193,0.011158,0.0096447,0.0084792,0.0082021,0.010264,0.01127,0.0097384,0.0085172,0.0082369,0.010299,0.011364,0.0098264,0.0086116,0.0082682,0.010387,0.011416,0.0099541,0.0086813,0.0083223,0.01044,0.011521,0.010066,0.008808,0.00837,0.010497,0.011571,0.010151,0.008862,0.0084177,0.010592,0.011646,0.010296,0.0089409,0.0084517,0.010611,0.011702,0.010361,0.0090148,0.0085103,0.010639,0.011814,0.010441,0.0090549,0.0085447,0.010652,0.011839,0.010586,0.0091726,0.008584,0.010691,0.011906,0.010707,0.0092295,0.0086516,0.010728,0.012015,0.010786,0.0092919,0.0086677,0.010782,0.012056,0.010906,0.0093811,0.0087199,0.010859,0.012131,0.010999,0.0094188,0.0087282,0.010914,0.012177,0.011101,0.0095079,0.0087983,0.010925,0.012247,0.011154,0.0095665,0.0088472,0.010965,0.012317,0.011304,0.0096732,0.0088501,0.011007,0.012378,0.011372,0.0097206,0.0088996,0.011049,0.012439,0.011479,0.0097971,0.00893,0.011102,0.012465,0.011594,0.0098461,0.0089589,0.01107,0.012514,0.011692,0.0099031,0.0090107,0.01115,0.012579,0.011759,0.0099993,0.0090371,0.011124,0.012608,0.011865,0.010125,0.0090997,0.011197,0.012652,0.011986,0.010145,0.0091048,0.011176,0.012718,0.012051,0.010225,0.009168,0.011266,0.012752,0.012117,0.010309,0.0091919,0.011299,0.012845,0.012249,0.010371,0.0092179,0.011347,0.012873,0.012351,0.010445,0.0092615,0.011345,0.012929,0.012419,0.010516,0.0093011,0.011363,0.01296,0.012547,0.01059,0.0093361,0.01138,0.012958,0.012593,0.010673,0.009372,0.011395,0.013011,0.012656,0.010699,0.0093903,0.011385,0.013057,0.012735,0.010785,0.0094148,0.011434,0.013083,0.012832,0.010892,0.0094584,0.011445,0.013089,0.012904,0.010935,0.0094542,0.011473,0.013155,0.012965,0.011006,0.0095065,0.011497,0.013161,0.013078,0.011037,0.009546,0.011499,0.01319,0.013122,0.01113,0.009563,0.0115,0.013197,0.013195,0.011158,0.0095873,0.01152,0.013231,0.013277,0.011245,0.0096388,0.011537,0.013214,0.01333,0.0113,0.009637,0.011534,0.013247,0.013424,0.011363,0.0097079,0.011507,0.013262,0.013457,0.011456,0.0097026,0.011509,0.013308,0.013542,0.011481,0.0097402,0.011554,0.013347,0.013595,0.01156,0.0097697,0.011552,0.013323,0.013654,0.011641,0.0098121,0.011598,0.013373,0.013725,0.011751,0.0098143,0.011638,0.013363,0.013821,0.011798,0.0098833,0.011574,0.013385,0.013862,0.011825,0.0099033,0.011597,0.013371,0.013879,0.011892,0.0099125,0.011579,0.013365,0.013891,0.011975,0.0099626,0.011604,0.013382,0.013988,0.011999,0.0099501,0.01157,0.013371,0.014015,0.012055,0.009999,0.011586,0.013343,0.014076,0.012121,0.0099927,0.011589,0.013328,0.014112,0.012191,0.010009,0.011532,0.013362,0.014168,0.012254,0.010067,0.011606,0.013377,0.014262,0.012282,0.010097,0.011574,0.0133,0.014279,0.012398,0.010124,0.011573,0.013382,0.014329,0.012436,0.01019,0.011547,0.013365,0.014362,0.012468,0.010216,0.011589,0.013332,0.014399,0.012556,0.01022,0.011603,0.013349,0.014472,0.012653,0.010251,0.011577,0.013326,0.014498,0.012695,0.010281,0.011576,0.013368,0.01452,0.012794,0.010311,0.011557,0.013302,0.014585,0.012831,0.010375,0.01162,0.013378,0.014692,0.012892,0.010379,0.011555,0.013313,0.01465,0.012941,0.010442,0.011584,0.013354,0.014736,0.013081,0.010469,0.011601,0.01335,0.01474,0.013109,0.010507,0.011638,0.013307,0.014769,0.013178,0.010505,0.011589,0.013299,0.014811,0.013236,0.01056,0.011635,0.013319,0.014829,0.013317,0.01056,0.011565,0.013309,0.01484,0.013386,0.010622,0.011621,0.013274,0.014888,0.013436,0.010686,0.011567,0.013316,0.015006,0.013532,0.010703,0.011573,0.013272,0.015,0.013595,0.010738,0.011587,0.013263,0.014991,0.013628,0.010812,0.011624,0.013251,0.014985,0.013698,0.010843,0.011604,0.013253,0.015033,0.013791,0.010878,0.01162,0.013227,0.015033,0.013854,0.010888,0.011606,0.013202,0.015087,0.013923,0.010943,0.011598,0.013226,0.015177,0.014005,0.010984,0.011573,0.013168,0.015165,0.014031,0.011045,0.011655,0.013201,0.015177,0.014137,0.011057,0.011604,0.01318,0.01521,0.01423,0.011156,0.011618,0.013122,0.015202,0.014264,0.011153,0.011581,0.013138,0.015206,0.014361,0.011198,0.011659,0.013136,0.015233,0.014382,0.011246,0.011618,0.013126,0.015293,0.014452,0.011276,0.01164,0.013111,0.015272,0.014521,0.011345,0.011684,0.013054,0.015341,0.014556,0.011396,0.01169,0.013128,0.015355,0.014616,0.011429,0.011698,0.01301,0.015319,0.014689,0.01149,0.011675,0.013059,0.015377,0.014762,0.011541,0.011696,0.013013,0.015338,0.014834,0.011558,0.011729,0.012999,0.015405,0.014881,0.011629,0.011656,0.013,0.015428,0.014954,0.011684,0.011723,0.013001,0.01542,0.015053,0.011748,0.0023875:5
-3.315E-4,-2.0125E-4,4.6891E-4,-8.2987E-4,5.7063E-4,-4.3871E-4,-5.885E-5,5.0093E-4,-8.8899E-4,7.5336E-4,-4.9485E-4,-2.3002E-4,6.1149E-4,-9.4202E-4,7.1904E-4,-1.7593E-4,-9.9543E-5,6.8546E-4,-6.0919E-4,6.5511E-4,1.5682,5.7453,4.7177,4.3844,4.4774,5.5262,5.7233,4.796,4.2958,4.5327,5.4906,5.7206,4.8231,4.2727,4.5431,5.4785,5.7201,4.8274,4.2667,4.5386,5.4673,5.7153,4.8267,4.2606,4.5298,5.4553,5.7123,4.8333,4.2618,4.5207,5.4482,5.7092,4.8354,4.254,4.5115,5.4378,5.7052,4.8366,4.2544,4.5046,5.4299,5.706,4.842,4.2548,4.496,5.4296,5.7134,4.853,4.2584,4.4961,5.4179,5.7089,4.8587,4.2556,4.481,5.4085,5.7091,4.86,4.2556,4.4756,5.4051,5.7069,4.868,4.2554,4.4719,5.4007,5.7085,4.8672,4.2559,4.4644,5.3951,5.709,4.8736,4.2559,4.4555,5.3868,5.7065,4.8781,4.2598,4.4474,5.3769,5.7051,4.8814,4.2579,4.4376,5.3675,5.7021,4.888,4.2555,4.4342,5.3662,5.7052,4.8968,4.255,4.4254,5.3609,5.7038,4.8992,4.2579,4.4234,5.3527,5.7037,4.9079,4.2576,4.4205,5.3474,5.7057,4.9114,4.2618,4.4125,5.3399,5.7027,4.9189,4.2592,4.408,5.3357,5.7024,4.9244,4.2608,4.399,5.3296,5.7032,4.9281,4.2635,4.3877,5.3219,5.7,4.9332,4.2621,4.3839,5.3088,5.6963,4.9418,4.2615,4.3785,5.3069,5.6962,4.9436,4.2629,4.374,5.3003,5.6958,4.9452,4.2615,4.3686,5.2904,5.6899,4.9518,4.2635,4.3591,5.2824,5.6915,4.9616,4.2655,4.3545,5.2748,5.6876,4.9603,4.2634,4.3458,5.2707,5.6873,4.9662,4.2649,4.3388,5.2568,5.6851,4.969,4.2658,4.3341,5.2545,5.6819,4.9734,4.2661,4.3259,5.2452,5.6795,4.975,4.2635,4.3178,0.0:5
7.0124E-4,-7.9913E-4,4.2019E-4,-4.283E-5,-4.1522E-4,7.3603E-4,-6.1186E-4,6.9377E-4,-5.5797E-5,-4.0183E-4,7.0746E-4,-7.7018E-4,7.4016E-4,-7.53E-5,-5.3536E-4,4.9875E-4,-8.4674E-4,3.3575E-4,3.3533E-5,-2.5983E-4,6.5766E-4,-5.2957E-4,5.0873E-4,1.8974E-4,-3.6556E-4,3.9553,4.3748,4.7314,5.5954,5.3347,4.2529,4.2472,4.8065,5.5726,5.314,4.2831,4.2117,4.8281,5.568,5.3056,4.2871,4.2028,4.8284,5.5585,5.2994,4.2821,4.1951,4.8284,5.5552,5.2919,4.2789,4.1943,4.826,5.5544,5.2864,4.276,4.196,4.8277,5.5553,5.287,4.2789,4.1936,4.8296,5.5519,5.2809,4.2735,4.1914,4.8277,5.5477,5.2748,4.2681,4.1905,4.818,5.5395,5.2644,4.2615,4.187,4.8196,5.5388,5.2655,4.2561,4.185,4.8245,5.5394,5.262,4.2598,4.1873,4.8189,5.5395,5.2606,4.2522,4.1827,4.8206,5.5363,5.2575,4.2523,4.1846,4.8191,5.5327,5.2551,4.2476,4.1799,4.8208,5.5316,5.2549,4.2467,4.1764,4.8157,5.53,5.2489,4.2431,4.1768,4.8173,5.5285,5.2447,4.2388,4.1764,4.8197,5.5283,5.2403,4.2375,4.177,4.8156,5.5235,5.2386,4.2369,4.1768,4.8149,5.5239,5.2413,4.2349,4.1727,4.816,5.5215,5.2338,4.2348,4.1747,4.8165,5.5227,5.2356,4.2293,4.1771,4.8151,5.5226,5.2299,4.2303,4.1724,4.8155,5.5169,5.2247,4.2239,4.1708,4.8143,5.5163,5.2204,4.2215,4.1706,4.8162,5.5132,5.2176,4.2201,4.1693,4.8164,5.5122,5.2142,4.216,4.1705,4.8174,5.5144,5.2106,4.2114,4.1695,4.8153,5.5082,5.2074,4.2085,4.1716,4.8134,5.5092,5.2005,4.2053,4.1657,4.8128,5.502,5.2001,4.2041,4.1694,4.8101,5.5039,5.1933,4.1971,4.1643,4.8119,5.4967,5.1893,4.1961,4.1624,4.8104,5.4978,5.1855,0.0:5
-4.1643E-4,1.5736E-4,3.5697E-4,-6.2865E-4,7.5212E-4,-4.1275E-4,2.3749E-4,3.086E-4,-4.7847E-4,0.0010106,-6.9232E-4,2.4813E-4,1.4108E-4,-4.4945E-4,4.6024E-4,-5.7409E-4,3.0524E-4,3.6761E-4,-4.9432E-4,5.354E-4,-5.235E-4,1.0915E-4,3.5972E-4,-5.69E-4,8.7344E-4,-6.7948E-4,1.2856,5.6652,4.7089,4.231,4.5736,5.4787,5.6332,4.7909,4.1422,4.6417,5.4552,5.6301,4.8092,4.1207,4.6582,5.4457,5.6202,4.81,4.1062,4.6562,5.4358,5.6147,4.805,4.0985,4.6526,5.4288,5.6057,4.8082,4.0966,4.6498,5.4268,5.608,4.805,4.0943,4.6439,5.4216,5.6017,4.802,4.0938,4.6411,5.4202,5.6038,4.8001,4.0916,4.6428,5.4166,5.6015,4.7942,4.0864,4.6336,5.4124,5.5969,4.7928,4.0852,4.6348,5.4117,5.5938,4.7931,4.0875,4.6352,5.41,5.5947,4.7901,4.0834,4.6354,5.4121,5.5933,4.7866,4.0801,4.6319,5.4087,5.5886,4.7851,4.0804,4.632,5.4055,5.5874,4.7865,4.0804,4.6297,5.4034,5.5836,4.7803,4.0761,4.6248,5.4029,5.5808,4.7808,4.0763,4.6205,5.3967,5.5726,4.7743,4.074,4.6227,5.3907,5.5754,4.7762,4.0714,4.6174,5.3943,5.5742,4.7727,4.0686,4.6197,5.3892,5.5688,4.7676,4.0646,4.6167,5.3886,5.5686,4.7655,4.063,4.6117,5.3871,5.5639,4.7635,4.0632,4.6109,5.3848,5.5584,4.761,4.0598,4.6109,5.3854,5.5579,4.7595,4.0597,4.6086,5.3817,5.5552,4.7569,4.0579,4.609,5.3844,5.5544,4.7545,4.055,4.6035,5.3806,5.5507,4.7523,4.0511,4.6032,5.3703,5.5477,4.7477,4.0525,4.6045,5.3761,5.5519,4.7496,4.0514,4.6014,5.3717,5.5416,4.7472,4.0509,4.5991,5.3745,5.544,4.7479,4.0478,4.602,5.3689,5.5462,4.7461,4.0525,4.5968,5.3674,5.5396,4.7451,4.0487,0.0:5
0.0010544,-0.0011769,0.0017607,-0.0017543,7.4843E-5,0.0014235,-0.0019785,0.0017182,-0.0010775,1.4207E-4,6.0522E-4,-0.0019202,0.0017712,-9.5441E-4,8.0121E-4,9.598E-4,-0.0013691,0.0020051,-0.0018199,1.9276E-4,0.0014121,-0.0015657,0.002031,-7.4272E-4,8.8895E-4,2.6244,1.5877,1.0098,1.1305,1.1077,0.96266,0.78407,0.70984,0.84873,0.95378,0.88026,0.72828,0.6872,0.81997,0.93483,0.8712,0.72309,0.68277,0.82894,0.94874,0.88694,0.73466,0.69408,0.82562,0.94634,0.88843,0.73744,0.6931,0.82206,0.94365,0.8887,0.73758,0.69332,0.82211,0.94741,0.89762,0.74568,0.69849,0.83196,0.96188,0.9109,0.75419,0.70081,0.82805,0.94532,0.8973,0.73266,0.66734,0.78505,0.89827,0.85681,0.70575,0.65347,0.76719,0.88253,0.84368,0.69637,0.64572,0.76011,0.87912,0.84179,0.6983,0.64432,0.7579,0.87791,0.8443,0.69837,0.64352,0.75568,0.87604,0.84476,0.69926,0.64241,0.75383,0.8743,0.84659,0.70122,0.64148,0.75115,0.87378,0.84764,0.70344,0.64223,0.7511,0.8733,0.8506,0.70489,0.64114,0.74956,0.87239,0.85238,0.7066,0.64058,0.74857,0.87195,0.85368,0.7095,0.64143,0.74722,0.87181,0.85476,0.7098,0.64139,0.74486,0.87081,0.85602,0.71135,0.64028,0.74256,0.86904,0.858,0.71311,0.63994,0.74045,0.86852,0.85959,0.71489,0.63946,0.73945,0.86639,0.86042,0.71644,0.64014,0.73739,0.86613,0.86173,0.71806,0.63981,0.73542,0.86425,0.86409,0.72085,0.63885,0.73509,0.86495,0.86575,0.72237,0.6408,0.73339,0.86337,0.8664,0.72373,0.63997,0.73304,0.86215,0.8682,0.72612,0.64049,0.73133,0.86087,0.86911,0.72835,0.64119,0.72835,0.86028,0.86966,0.73017,0.63968,0.72775,0.85856,0.87091,0.73183,0.63988,0.7263,0.85771,0.87302,0.73315,0.64054,0.72438,0.85627,0.87388,0.73526,0.64032,0.72334,0.85401,0.0:6
-0.001241,8.2973E-4,0.0013793,-0.0024713,0.0025972,1.5613E-4,3.1567E-4,0.0014542,-0.0032242,0.0035975,-0.001654,9.9398E-4,-9.872E-5,-0.0019551,0.0021612,-0.0017716,-2.4065E-6,0.0023501,-0.001842,0.0027387,-0.0017975,-5.9301E-4,0.0013982,-0.0028243,0.002014,-0.0013266,-1.0781E-4,0.0017009,2.8484,3.7718,3.4015,2.0384,1.661,1.2117,1.1415,1.2846,1.4212,1.2861,1.0213,0.97884,1.1575,1.3039,1.2207,0.99293,0.97042,1.143,1.3055,1.2284,0.9949,0.95721,1.1378,1.2958,1.2157,0.99159,0.95304,1.1261,1.2827,1.2029,0.98313,0.94117,1.1193,1.2756,1.2029,0.98282,0.94177,1.114,1.2766,1.2039,0.98308,0.9402,1.1127,1.2734,1.2037,0.98338,0.94016,1.1123,1.2728,1.2143,0.99105,0.94472,1.1339,1.2792,1.2615,1.0231,0.97189,1.1684,1.3083,1.2816,1.0401,0.97953,1.1689,1.3106,1.2848,1.0432,0.97675,1.172,1.3126,1.2901,1.0535,0.97749,1.1601,1.3015,1.2845,1.0424,0.97535,1.1584,1.3057,1.2867,1.0447,0.97466,1.1631,1.3039,1.2948,1.0511,0.97512,1.1626,1.3117,1.2975,1.0551,0.97943,1.1665,1.3062,1.2978,1.0571,0.97385,1.1611,1.3003,1.302,1.0491,0.97281,1.1573,1.296,1.3076,1.0583,0.97446,1.1651,1.3035,1.3152,1.0673,0.97602,1.1621,1.2979,1.3187,1.0679,0.9733,1.158,1.3039,1.3248,1.0669,0.97157,1.1536,1.2996,1.3261,1.0727,0.97323,1.1602,1.2992,1.332,1.0766,0.97476,1.1527,1.2915,1.3317,1.0818,0.97301,1.1495,1.2961,1.3396,1.0924,0.97974,1.1725,1.3075,1.3504,1.104,0.98663,1.1632,1.3058,1.3528,1.1003,0.98341,1.1638,1.3008,1.3545,1.106,0.97954,1.1609,1.2868,1.3425,1.103,0.97908,1.1415,1.2935,1.3553,1.0814,0.97468,1.1517,1.2917,1.3527,1.1037,0.97022,0.0:6
2.3667E-7,2.8667E-7,1.4067E-6,-6.2333E-7,1.8033E-6,-3.3667E-7,1.3133E-6,7.4E-7,-8.6333E-7,9.8667E-7,5.6333E-7,1.0067E-6,9.7E-7,-6.8333E-7,1.1E-6,-3.5333E-7,1.0267E-6,1.2467E-6,-7.0E-7,7.7667E-7,-2.8E-7,6.3333E-7,1.3667E-6,1.8E-7,1.0267E-6,-4.7333E-7,7.9333E-7,1.7267E-6,7.6981E-4,9.2933E-4,7.2293E-4,6.3738E-4,5.1743E-4,4.1301E-4,3.8452E-4,4.6513E-4,4.9447E-4,4.4478E-4,3.8083E-4,3.6385E-4,4.5261E-4,4.8667E-4,4.3966E-4,3.764E-4,3.6335E-4,4.5268E-4,4.8689E-4,4.3771E-4,3.7626E-4,3.649E-4,4.5268E-4,4.8713E-4,4.3719E-4,3.791E-4,3.6455E-4,4.5499E-4,4.867E-4,4.3378E-4,3.748E-4,3.67E-4,4.5439E-4,4.8953E-4,4.3493E-4,3.7705E-4,3.6668E-4,4.5788E-4,4.8898E-4,4.3449E-4,3.7534E-4,3.6864E-4,4.5595E-4,4.9074E-4,4.3264E-4,3.7342E-4,3.7035E-4,4.5799E-4,4.9159E-4,4.3045E-4,3.7394E-4,3.6903E-4,4.5769E-4,4.914E-4,4.2917E-4,3.7409E-4,3.724E-4,4.5958E-4,4.9108E-4,4.289E-4,3.7385E-4,3.7197E-4,4.6162E-4,4.9194E-4,4.2665E-4,3.7524E-4,3.7363E-4,4.6218E-4,4.9163E-4,4.2651E-4,3.7483E-4,3.7431E-4,4.637E-4,4.9254E-4,4.2376E-4,3.7332E-4,3.7481E-4,4.6265E-4,4.9213E-4,4.2271E-4,3.7337E-4,3.7637E-4,4.6448E-4,4.9034E-4,4.2259E-4,3.7166E-4,3.7732E-4,4.6525E-4,4.9064E-4,4.1862E-4,3.7224E-4,3.7709E-4,4.6566E-4,4.925E-4,4.1765E-4,3.7167E-4,3.791E-4,4.6776E-4,4.9372E-4,4.1642E-4,3.7066E-4,3.8009E-4,4.679E-4,4.9388E-4,4.1595E-4,3.7133E-4,3.8107E-4,4.6866E-4,4.961E-4,4.1448E-4,3.7206E-4,3.8231E-4,4.6993E-4,4.9269E-4,4.1397E-4,3.7019E-4,3.818E-4,4.6975E-4,4.943E-4,4.097E-4,3.701E-4,3.8537E-4,4.707E-4,4.9421E-4,4.1148E-4,3.6795E-4,3.8377E-4,4.7035E-4,4.9602E-4,4.0946E-4,3.6919E-4,3.8508E-4,4.7166E-4,4.9546E-4,4.066E-4,3.7067E-4,3.8791E-4,4.7353E-4,4.9316E-4,4.0723E-4,3.7017E-4,3.8832E-4,4.7296E-4,4.9294E-4,4.0614E-4,3.71E-4,3.8974E-4,4.727E-4,4.947E-4,4.0248E-4,3.6979E-4,3.9101E-4,4.7423E-4,4.9195E-4,4.034E-4,3.7015E-4,3.9022E-4,4.7427E-4,4.9268E-4,4.0174E-4,3.6973E-4,3.9284E-4,4.7616E-4,4.9312E-4,4.0012E-4,3.6947E-4,3.9212E-4,4.7733E-4,4.9202E-4,3.98E-4,3.694E-4,3.9671E-4,4.7695E-4,4.9158E-4,3.9568E-4,3.6939E-4,3.9597E-4,4.7979E-4,4.924E-4,3.9457E-4,3.6925E-4,3.9706E-4,4.7939E-4,4.9261E-4,3.9501E-4,3.6884E-4,3.9855E-4,4.7824E-4,4.9188E-4,3.9346E-4,3.7034E-4,4.0127E-4,4.8001E-4,4.9149E-4,3.9295E-4,3.7038E-4,4.0031E-4,4.7955E-4,4.906E-4,3.9131E-4,3.693E-4,4.013E-4,4.8E-4,4.8999E-4,3.9043E-4,3.7016E-4,4.0448E-4,4.8251E-4,4.9148E-4,3.8883E-4,3.7056E-4,4.0528E-4,4.815E-4,4.8868E-4,3.8763E-4,3.7042E-4,4.0592E-4,4.8124E-4,4.8842E-4,3.8577E-4,3.7124E-4,4.0706E-4,4.8361E-4,4.897E-4,3.8528E-4,3.7108E-4,4.0662E-4,4.8252E-4,4.8773E-4,3.8286E-4,3.7044E-4,4.0766E-4,4.8283E-4,4.8489E-4,3.8208E-4,3.7176E-4,4.0921E-4,4.8518E-4,4.8712E-4,3.814E-4,3.7119E-4,4.1119E-4,4.8468E-4,4.8369E-4,3.8138E-4,3.7194E-4,4.1253E-4,4.8499E-4,4.8604E-4,3.8012E-4,3.7153E-4,4.1493E-4,4.8413E-4,4.8433E-4,3.7858E-4,3.7221E-4,4.1391E-4,4.8601E-4,4.8114E-4,3.7719E-4,3.7198E-4,4.145E-4,4.8624E-4,4.8318E-4,3.7698E-4,3.734E-4,4.1791E-4,4.8674E-4,4.8231E-4,3.764E-4,3.75E-4,4.1657E-4,4.881E-4,4.7988E-4,3.7371E-4,3.7503E-4,4.1765E-4,4.8716E-4,2.25E-4:6
5.2667E-7,2.0333E-7,-1.61E-6,4.8667E-7,-3.7667E-7,8.7667E-7,1.5667E-7,-2.4667E-7,5.3E-7,1.9667E-7,1.3267E-6,-2.8333E-7,1.02E-6,3.9667E-7,-3.9667E-7,3.9E-7,-3.3333E-8,-3.9667E-7,8.4333E-7,-1.2833E-6,1.3367E-6,6.0333E-7,1.0333E-7,1.1267E-6,-5.8667E-7,7.0667E-7,9.6667E-7,4.3333E-7,1.1033E-6,-4.7333E-7,7.4333E-7,-3.8E-7,1.3333E-8,5.6667E-7,-1.5667E-7,1.3267E-6,-6.9333E-7,5.6E-7,1.2667E-6,-4.4333E-7,1.1367E-6,1.2633E-6,0.0015518,7.0687E-4,5.1196E-4,5.0164E-4,5.4163E-4,5.3276E-4,4.0678E-4,3.8504E-4,4.0843E-4,4.8701E-4,4.9962E-4,3.9127E-4,3.7323E-4,4.0655E-4,4.8477E-4,4.976E-4,3.9032E-4,3.7464E-4,4.076E-4,4.8404E-4,4.9653E-4,3.8914E-4,3.7551E-4,4.0866E-4,4.8284E-4,4.9482E-4,3.8804E-4,3.7549E-4,4.0937E-4,4.8555E-4,4.9411E-4,3.8801E-4,3.7469E-4,4.1081E-4,4.8616E-4,4.9173E-4,3.8744E-4,3.764E-4,4.1096E-4,4.8616E-4,4.9311E-4,3.8653E-4,3.7475E-4,4.1159E-4,4.8887E-4,4.9277E-4,3.8579E-4,3.7513E-4,4.1458E-4,4.8619E-4,4.9238E-4,3.8419E-4,3.7497E-4,4.145E-4,4.8637E-4,4.8994E-4,3.8256E-4,3.7508E-4,4.1514E-4,4.865E-4,4.8877E-4,3.8196E-4,3.7523E-4,4.1674E-4,4.8966E-4,4.8931E-4,3.8171E-4,3.7486E-4,4.1687E-4,4.9002E-4,4.8987E-4,3.7899E-4,3.7671E-4,4.1857E-4,4.9006E-4,4.8759E-4,3.779E-4,3.7781E-4,4.2037E-4,4.9103E-4,4.8649E-4,3.7749E-4,3.7739E-4,4.206E-4,4.9081E-4,4.8463E-4,3.7696E-4,3.7677E-4,4.2262E-4,4.8907E-4,4.8575E-4,3.7719E-4,3.7768E-4,4.2346E-4,4.9308E-4,4.8466E-4,3.7542E-4,3.7778E-4,4.2488E-4,4.9229E-4,4.8269E-4,3.7404E-4,3.7955E-4,4.251E-4,4.9168E-4,4.8297E-4,3.7253E-4,3.7676E-4,4.2504E-4,4.9017E-4,4.8024E-4,3.7155E-4,3.7921E-4,4.2589E-4,4.9306E-4,4.8061E-4,3.7074E-4,3.7974E-4,4.2682E-4,4.9144E-4,4.8022E-4,3.7039E-4,3.8113E-4,4.2884E-4,4.9156E-4,4.7937E-4,3.7158E-4,3.7843E-4,4.2907E-4,4.9258E-4,4.7835E-4,3.703E-4,3.814E-4,4.3112E-4,4.918E-4,4.7602E-4,3.6985E-4,3.8131E-4,4.3133E-4,4.9396E-4,4.7651E-4,3.6732E-4,3.8189E-4,4.3297E-4,4.9326E-4,4.7498E-4,3.6797E-4,3.8133E-4,4.3367E-4,4.9315E-4,4.7238E-4,3.6717E-4,3.843E-4,4.3401E-4,4.9275E-4,4.7269E-4,3.6702E-4,3.8209E-4,4.3526E-4,4.9649E-4,4.7218E-4,3.6636E-4,3.8411E-4,4.3795E-4,4.9388E-4,4.6966E-4,3.6522E-4,3.8468E-4,4.384E-4,4.9557E-4,4.7038E-4,3.6548E-4,3.8605E-4,4.3855E-4,4.963E-4,4.6758E-4,3.6421E-4,3.8549E-4,4.3996E-4,4.9549E-4,4.6799E-4,3.631E-4,3.8625E-4,4.3977E-4,4.9346E-4,4.6612E-4,3.6228E-4,3.866E-4,4.427E-4,4.9346E-4,4.6639E-4,3.6113E-4,3.8742E-4,4.4312E-4,4.9537E-4,4.6485E-4,3.6164E-4,3.8884E-4,4.4511E-4,4.9543E-4,4.6187E-4,3.6018E-4,3.8754E-4,4.4316E-4,4.9551E-4,4.6068E-4,3.6242E-4,3.8838E-4,4.4609E-4,4.9527E-4,4.6142E-4,3.6129E-4,3.9019E-4,4.4799E-4,4.9607E-4,4.5902E-4,3.6051E-4,3.9081E-4,4.4713E-4,4.941E-4,4.5743E-4,3.5855E-4,3.9144E-4,4.4945E-4,4.9603E-4,4.5633E-4,3.6028E-4,3.9191E-4,4.4806E-4,4.9389E-4,4.5517E-4,3.5903E-4,3.9183E-4,4.5135E-4,4.9586E-4,4.539E-4,3.581E-4,3.9272E-4,4.5143E-4,4.9383E-4,4.5434E-4,3.571E-4,3.9503E-4,4.5175E-4,4.9606E-4,4.5215E-4,3.57E-4,3.9565E-4,4.5355E-4,4.9406E-4,4.5049E-4,3.5558E-4,3.9496E-4,4.5396E-4,4.9521E-4,4.4995E-4,3.5691E-4,3.9548E-4,4.5606E-4,4.9423E-4,4.4748E-4,3.5518E-4,3.9939E-4,4.5599E-4,4.9387E-4,4.4743E-4,3.5572E-4,3.9775E-4,4.5567E-4,4.9471E-4,4.4655E-4,3.5478E-4,3.9924E-4,4.5676E-4,4.9297E-4,4.4416E-4,3.545E-4,3.9982E-4,4.583E-4,4.95E-4,4.4229E-4,3.537E-4,4.0005E-4,4.6105E-4,4.9573E-4,4.4368E-4,3.5507E-4,4.0037E-4,4.6187E-4,4.9351E-4,4.4186E-4,3.5298E-4,4.0026E-4,4.611E-4,4.9337E-4,4.4028E-4,3.5347E-4,4.0324E-4,4.6152E-4,4.9154E-4,4.3955E-4,3.5266E-4,4.0259E-4,4.6369E-4,4.9453E-4,4.3832E-4,3.5162E-4,4.0394E-4,0.0:6
8.6667E-8,6.5333E-7,7.2E-7,-7.8667E-7,7.6667E-7,-1.3E-7,-2.9667E-7,1.2033E-6,3.3333E-8,1.0633E-6,-9.9667E-7,6.3333E-7,6.5E-7,-9.6E-7,4.4E-7,4.3333E-8,6.5333E-7,6.1667E-7,-2.3333E-7,1.37E-6,9.0E-8,1.0133E-6,7.9333E-7,-3.0E-8,6.4667E-7,-1.5667E-7,8.6333E-7,1.2733E-6,-1.3833E-6,6.0333E-7,-2.3333E-8,8.7E-7,1.2267E-6,5.4584E-4,0.0010029,7.3077E-4,6.2766E-4,5.7972E-4,4.7832E-4,3.656E-4,4.2323E-4,4.7502E-4,4.905E-4,4.3134E-4,3.4741E-4,4.0664E-4,4.6259E-4,4.8357E-4,4.2508E-4,3.4848E-4,4.059E-4,4.6357E-4,4.845E-4,4.2598E-4,3.4698E-4,4.0819E-4,4.6495E-4,4.8387E-4,4.2585E-4,3.4727E-4,4.0894E-4,4.6548E-4,4.8451E-4,4.2403E-4,3.4688E-4,4.101E-4,4.6969E-4,4.8518E-4,4.2258E-4,3.4758E-4,4.108E-4,4.6705E-4,4.8571E-4,4.2245E-4,3.4705E-4,4.1236E-4,4.6761E-4,4.8552E-4,4.2044E-4,3.4856E-4,4.1401E-4,4.7018E-4,4.85E-4,4.1962E-4,3.4879E-4,4.1357E-4,4.7217E-4,4.8446E-4,4.1966E-4,3.486E-4,4.1615E-4,4.7146E-4,4.843E-4,4.1976E-4,3.4971E-4,4.1461E-4,4.7254E-4,4.8474E-4,4.1963E-4,3.4883E-4,4.1829E-4,4.7403E-4,4.8374E-4,4.1708E-4,3.4924E-4,4.1821E-4,4.7312E-4,4.8474E-4,4.1896E-4,3.4777E-4,4.1882E-4,4.7423E-4,4.8329E-4,4.1553E-4,3.476E-4,4.2035E-4,4.7571E-4,4.8294E-4,4.132E-4,3.482E-4,4.1961E-4,4.7518E-4,4.8165E-4,4.1341E-4,3.4975E-4,4.2075E-4,4.7612E-4,4.8278E-4,4.1246E-4,3.5007E-4,4.2163E-4,4.7708E-4,4.8015E-4,4.106E-4,3.4879E-4,4.2414E-4,4.785E-4,4.8195E-4,4.0842E-4,3.4911E-4,4.2512E-4,4.7934E-4,4.7914E-4,4.086E-4,3.4981E-4,4.2503E-4,4.7896E-4,4.7977E-4,4.0851E-4,3.506E-4,4.2529E-4,4.7985E-4,4.7839E-4,4.0697E-4,3.4944E-4,4.2665E-4,4.8042E-4,4.7861E-4,4.0576E-4,3.4958E-4,4.2634E-4,4.8132E-4,4.7858E-4,4.0639E-4,3.5154E-4,4.2873E-4,4.8208E-4,4.768E-4,4.0565E-4,3.5002E-4,4.2773E-4,4.8224E-4,4.7501E-4,4.051E-4,3.5226E-4,4.2895E-4,4.8362E-4,4.7731E-4,4.0412E-4,3.5242E-4,4.297E-4,4.8418E-4,4.7505E-4,4.0217E-4,3.5202E-4,4.3399E-4,4.8376E-4,4.7485E-4,4.0117E-4,3.5173E-4,4.3402E-4,4.8701E-4,4.7333E-4,4.012E-4,3.5391E-4,4.3366E-4,4.867E-4,4.7103E-4,3.9977E-4,3.5279E-4,4.346E-4,4.8541E-4,4.7315E-4,3.9896E-4,3.5298E-4,4.3568E-4,4.8764E-4,4.7068E-4,3.9825E-4,3.5409E-4,4.3697E-4,4.8658E-4,4.6833E-4,3.9849E-4,3.538E-4,4.3721E-4,4.8747E-4,4.6878E-4,3.9678E-4,3.5483E-4,4.3779E-4,4.8779E-4,4.6783E-4,3.9554E-4,3.5547E-4,4.381E-4,4.8824E-4,4.6631E-4,3.9507E-4,3.5464E-4,4.3841E-4,4.8984E-4,4.6741E-4,3.9619E-4,3.5617E-4,4.4097E-4,4.8901E-4,4.6608E-4,3.9311E-4,3.5643E-4,4.4317E-4,4.9113E-4,4.6343E-4,3.9318E-4,3.5535E-4,4.4044E-4,4.8823E-4,4.6287E-4,3.9367E-4,3.5675E-4,4.4271E-4,4.8979E-4,4.6264E-4,3.9221E-4,3.5791E-4,4.4155E-4,4.8981E-4,4.6184E-4,3.9268E-4,3.5715E-4,4.4388E-4,4.8977E-4,4.5984E-4,3.8899E-4,3.582E-4,4.4466E-4,4.9187E-4,4.5853E-4,3.9003E-4,3.5926E-4,4.4626E-4,4.9208E-4,4.5784E-4,3.8885E-4,3.5935E-4,4.4674E-4,4.9228E-4,4.5673E-4,3.9095E-4,3.5975E-4,4.4795E-4,4.9072E-4,4.5608E-4,3.8874E-4,3.5905E-4,4.5072E-4,4.9305E-4,4.5362E-4,3.8747E-4,3.5998E-4,4.5137E-4,4.9201E-4,4.5492E-4,3.8602E-4,3.619E-4,4.5074E-4,4.9243E-4,4.5203E-4,3.8674E-4,3.6263E-4,4.5038E-4,4.9423E-4,4.5176E-4,3.4167E-5:6
2.3213E-4,2.2252E-4,2.5183E-4,3.0047E-4,2.8465E-4,2.3119E-4,2.2241E-4,2.5241E-4,3.0058E-4,2.8373E-4,2.3129E-4,2.2197E-4,2.5422E-4,3.0098E-4,2.8435E-4,2.3104E-4,2.2328E-4,2.54E-4,3.0037E-4,2.8436E-4,2.3037E-4,2.2347E-4,2.5518E-4,3.006E-4,2.8464E-4,2.3011E-4,2.2366E-4,2.5365E-4,3.0168E-4,2.8473E-4,2.3009E-4,2.2393E-4,2.5582E-4,3.0154E-4,2.8466E-4,2.3022E-4,2.2395E-4,2.5648E-4,3.0116E-4,2.8605E-4,2.2979E-4,2.237E-4,2.5659E-4,3.0088E-4,2.8486E-4,2.3031E-4,2.2428E-4,2.5717E-4,3.0079E-4,2.8596E-4,2.2893E-4,2.2374E-4,2.5563E-4,3.0337E-4,2.8538E-4,2.2903E-4,2.241E-4,2.5747E-4,3.0105E-4,2.85E-4,2.2986E-4,2.2465E-4,2.5812E-4,3.014E-4,2.8573E-4,2.2896E-4,2.2478E-4,2.5748E-4,3.037E-4,2.8441E-4,2.2826E-4,2.2607E-4,2.573E-4,3.0336E-4,2.8593E-4,2.2805E-4,2.246E-4,2.5716E-4,3.0265E-4,2.842E-4,2.284E-4,2.2571E-4,2.5695E-4,3.0262E-4,2.8448E-4,2.2768E-4,2.2544E-4,2.5869E-4,3.009E-4,2.8557E-4,2.2793E-4,2.2677E-4,2.5989E-4,3.0209E-4,2.8417E-4,2.2808E-4,2.2607E-4,2.593E-4,3.0398E-4,2.8508E-4,2.2828E-4,2.2644E-4,2.5933E-4,3.0437E-4,2.8456E-4,2.2783E-4,2.2693E-4,2.6023E-4,3.025E-4,2.8479E-4,2.2871E-4,2.259E-4,2.605E-4,3.0317E-4,2.8671E-4,2.271E-4,2.2809E-4,2.6096E-4,3.0265E-4,2.8551E-4,2.2693E-4,2.2682E-4,2.617E-4,3.0233E-4,2.8415E-4,2.2674E-4,2.268E-4,2.6234E-4,3.0352E-4,2.8452E-4,2.2768E-4,2.2706E-4,2.6274E-4,3.0481E-4,2.8437E-4,2.2532E-4,2.2748E-4,2.6197E-4,3.029E-4,2.8476E-4,2.2579E-4,2.2688E-4,2.63E-4,3.027E-4,2.8356E-4,2.2579E-4,2.2802E-4,2.6196E-4,3.0379E-4,2.8495E-4,2.2542E-4,2.2791E-4,2.6202E-4,3.0265E-4,2.8534E-4,2.2476E-4,2.2711E-4,2.6225E-4,3.0302E-4,2.8478E-4,2.2498E-4,2.285E-4,2.6252E-4,3.0316E-4,2.8403E-4,2.2377E-4,2.2917E-4,2.6486E-4,3.0488E-4,2.841E-4,2.2545E-4,2.2909E-4,2.6319E-4,3.0502E-4,2.84E-4,2.2467E-4,2.2749E-4,2.6359E-4,3.0369E-4,2.8342E-4,2.2477E-4,2.2941E-4,2.6471E-4,3.0481E-4,2.8414E-4,2.2445E-4,2.2835E-4,2.6305E-4,3.0382E-4,2.8446E-4,2.2355E-4,2.2962E-4,2.6587E-4,3.0523E-4,2.8264E-4,2.237E-4,2.2892E-4,2.6547E-4,3.0424E-4,2.8124E-4,0.0:6
-2.0E-8,1.33E-6,-1.0267E-6,1.6333E-7,2.7667E-7,-2.2E-7,1.1733E-6,-1.8333E-7,6.2E-7,5.4333E-7,-2.2667E-7,1.2633E-6,-5.3333E-7,4.2333E-7,1.09E-6,-6.5667E-7,6.8E-7,-1.47E-6,9.9E-7,4.3667E-7,-2.1667E-7,1.36E-6,-1.5467E-6,9.4E-7,8.3E-7,1.7667E-7,1.2E-6,-3.3E-7,-7.4667E-7,1.16E-6,-1.7933E-6,6.5E-7,7.0667E-7,5.7667E-7,7.4333E-7,-3.1333E-7,6.8667E-7,8.3E-7,1.05E-6,6.8E-7,-2.9333E-7,1.2067E-6,1.4667E-7,1.0E-7,6.3333E-7,-8.3E-7,1.4033E-6,8.1E-7,3.9333E-7,1.1267E-6,6.3667E-7,1.47E-6,-2.2667E-7,-6.0E-8,5.7667E-7,-7.1E-7,7.5667E-7,-7.8667E-7,1.04E-6,1.7433E-6,-5.0333E-7,1.19E-6,-3.5E-7,1.4067E-6,5.4333E-7,-6.7333E-7,1.25E-6,-1.6333E-7,6.8E-7,1.5667E-6,-6.1333E-7,1.9067E-6,-3.9333E-7,1.0767E-6,2.1667E-7,-1.8667E-7,1.5767E-6,2.1333E-7,1.39E-6,5.2667E-7,3.0667E-7,1.2233E-6,5.8333E-7,7.5667E-7,1.2833E-6,-9.6333E-7,1.3867E-6,-1.08E-6,7.6667E-7,9.9E-7,1.4667E-7,1.9033E-6,1.0655E-4,8.843E-4,4.611E-4,3.4798E-4,2.1801E-4,2.937E-4,3.0521E-4,2.7597E-4,2.436E-4,2.0698E-4,2.5762E-4,2.9312E-4,2.7287E-4,2.4003E-4,2.0841E-4,2.5752E-4,2.9303E-4,2.7329E-4,2.3864E-4,2.0802E-4,2.5711E-4,2.9426E-4,2.7518E-4,2.3861E-4,2.0877E-4,2.5821E-4,2.9333E-4,2.7405E-4,2.3965E-4,2.0982E-4,2.5961E-4,2.9454E-4,2.7475E-4,2.3888E-4,2.0941E-4,2.6031E-4,2.958E-4,2.7519E-4,2.3858E-4,2.0966E-4,2.6093E-4,2.9435E-4,2.767E-4,2.391E-4,2.112E-4,2.5989E-4,2.9618E-4,2.7608E-4,2.3721E-4,2.1178E-4,2.6024E-4,2.9638E-4,2.7633E-4,2.3803E-4,2.1227E-4,2.615E-4,2.9686E-4,2.7755E-4,2.3723E-4,2.1173E-4,2.6202E-4,2.9773E-4,2.7632E-4,2.3832E-4,2.122E-4,2.6174E-4,2.9819E-4,2.7826E-4,2.3764E-4,2.124E-4,2.6348E-4,2.9723E-4,2.7684E-4,2.3823E-4,2.1381E-4,2.6421E-4,2.9808E-4,2.7622E-4,2.3803E-4,2.1285E-4,2.6358E-4,2.9747E-4,2.7616E-4,2.3877E-4,2.1365E-4,2.6492E-4,2.9878E-4,2.7804E-4,2.3788E-4,2.1362E-4,2.6517E-4,2.9948E-4,2.7619E-4,2.3617E-4,2.1437E-4,2.6453E-4,2.9935E-4,2.7699E-4,2.3691E-4,2.1398E-4,2.6594E-4,2.9844E-4,2.7612E-4,2.3815E-4,2.1348E-4,2.6688E-4,3.0025E-4,2.764E-4,2.3552E-4,2.1522E-4,2.663E-4,2.9952E-4,2.7586E-4,2.3748E-4,2.1592E-4,2.6605E-4,2.9826E-4,2.7511E-4,2.354E-4,2.1547E-4,2.6711E-4,2.9994E-4,2.7564E-4,2.3578E-4,2.1596E-4,2.6646E-4,2.9987E-4,2.7604E-4,2.3466E-4,2.1503E-4,2.6828E-4,3.001E-4,2.7557E-4,2.3565E-4,2.1598E-4,2.6926E-4,3.0002E-4,2.7412E-4,2.3414E-4,2.1592E-4,2.7058E-4,3.0065E-4,2.7574E-4,2.3417E-4,2.1656E-4,2.6953E-4,3.0224E-4,2.7566E-4,2.3511E-4,2.1796E-4,2.7052E-4,2.9987E-4,2.7354E-4,2.3515E-4,2.1727E-4,2.6906E-4,3.0144E-4,2.7463E-4,2.3572E-4,2.1799E-4,2.6978E-4,3.001E-4,2.7511E-4,2.3361E-4,2.1723E-4,2.7061E-4,3.011E-4,2.7403E-4,2.3469E-4,2.1549E-4,2.7211E-4,3.0113E-4,2.7416E-4,2.3502E-4,2.163E-4,2.7246E-4,3.0193E-4,2.7409E-4,2.3396E-4,2.1762E-4,2.7161E-4,3.0157E-4,2.7421E-4,2.3314E-4,2.1686E-4,2.7115E-4,3.0274E-4,2.7281E-4,2.3387E-4,2.1747E-4,2.7111E-4,3.0185E-4,2.7339E-4,2.3402E-4,2.1897E-4,2.716E-4,3.0137E-4,2.7377E-4,2.3271E-4,2.1873E-4,2.7212E-4,3.0102E-4,2.7268E-4,2.3251E-4,2.1858E-4,2.7328E-4,3.0149E-4,2.7207E-4,2.3188E-4,2.1791E-4,2.7179E-4,3.014E-4,2.7204E-4,2.326E-4,2.2042E-4,2.7391E-4,3.0153E-4,2.7303E-4,2.3314E-4,2.2018E-4,2.7417E-4,3.0251E-4,2.7236E-4,2.3162E-4,2.1896E-4,2.7404E-4,3.0136E-4,2.7122E-4,2.3275E-4,2.188E-4,2.7465E-4,3.0189E-4,2.7184E-4,2.3207E-4,2.1928E-4,2.7441E-4,3.0195E-4,2.7058E-4,2.3228E-4,2.1968E-4,2.7421E-4,3.0235E-4,2.7127E-4,2.3204E-4,2.1993E-4,2.7539E-4,3.017E-4,2.6941E-4,2.3139E-4,2.2025E-4,2.757E-4,3.0315E-4,2.7046E-4,2.3127E-4,2.2094E-4,2.7746E-4,3.0291E-4,2.693E-4,2.3005E-4,2.2128E-4,2.7672E-4,3.038E-4,2.7029E-4,2.3136E-4,2.201E-4,2.7687E-4,3.0197E-4,2.702E-4,2.325E-4,2.2134E-4,2.7744E-4,3.0333E-4,2.6942E-4,2.318E-4,2.2147E-4,2.7754E-4,3.0273E-4,2.6966E-4,2.3129E-4,2.2047E-4,2.7727E-4,3.0332E-4,2.6898E-4,2.3092E-4,2.2219E-4,2.7726E-4,3.0289E-4,2.6818E-4,2.2907E-4,2.2187E-4,2.772E-4,3.0326E-4,2.6901E-4,2.324E-4,2.217E-4,2.781E-4,3.0408E-4,2.6845E-4,2.3157E-4,2.2187E-4,2.7734E-4,3.0293E-4,2.6886E-4,2.314E-4,2.228E-4,2.7937E-4,3.0344E-4,2.6958E-4,2.2955E-4,2.2244E-4,2.7908E-4,3.0207E-4,2.6922E-4,2.301E-4,2.2319E-4,2.7858E-4,3.0433E-4,2.6604E-4,2.2972E-4,2.226E-4,2.7887E-4,3.0364E-4,2.6699E-4,2.3052E-4,2.2298E-4,2.7957E-4,3.0302E-4,2.6638E-4,2.2934E-4,2.2412E-4,2.7948E-4,3.03E-4,2.6773E-4,2.2973E-4,2.229E-4,2.8053E-4,3.0455E-4,2.6652E-4,2.2911E-4,2.2458E-4,2.8099E-4,3.0335E-4,2.664E-4,2.2859E-4,2.2413E-4,2.8137E-4,3.0324E-4,2.6502E-4,2.2831E-4,2.2421E-4,2.8115E-4,3.044E-4,2.6503E-4,2.2958E-4,2.2474E-4,2.8018E-4,3.0372E-4,2.6512E-4,2.2994E-4,2.2555E-4,2.8104E-4,3.0269E-4,2.6532E-4,2.2958E-4,2.0679E-4:6
-3.49E-6,2.95E-6,1.1E-7,1.1767E-6,3.15E-6,-2.02E-6,4.2633E-6,5.1333E-7,3.7E-6,2.7467E-6,-2.7133E-6,4.9433E-6,-1.4433E-6,6.8E-7,4.4667E-6,-2.4E-7,1.4833E-6,-1.34E-6,1.5067E-6,2.8367E-6,-2.1967E-6,3.85E-6,1.3167E-6,-1.3333E-8,1.53E-6,-1.3E-6,8.4667E-7,2.17E-6,6.8E-7,2.0667E-6,0.0047446,0.0032475,0.0021808,0.0023669,0.0019505,0.0013762,0.0014284,0.0015329,0.001714,0.0015678,0.0012653,0.0012316,0.0014523,0.0016177,0.0015038,0.001251,0.0011929,0.0014354,0.0016011,0.0014971,0.001246,0.0011843,0.0014302,0.0015931,0.0014991,0.0012482,0.0011827,0.0014244,0.0015882,0.0014996,0.0012495,0.0011744,0.0014215,0.0015898,0.0015063,0.0012496,0.0011783,0.0014182,0.0015914,0.0015069,0.0012517,0.0011744,0.0014152,0.0015848,0.0015063,0.001255,0.0011705,0.0014102,0.0015854,0.0015059,0.0012561,0.0011728,0.0014109,0.0015854,0.0015137,0.0012574,0.0011692,0.0014042,0.0015817,0.0015155,0.0012611,0.0011689,0.0014025,0.0015819,0.0015176,0.0012631,0.0011698,0.0014024,0.001582,0.001521,0.0012663,0.001169,0.0013968,0.0015833,0.0015215,0.0012723,0.0011671,0.0013965,0.0015772,0.001524,0.0012708,0.001161,0.0013876,0.0015785,0.0015259,0.001273,0.0011635,0.0013888,0.0015775,0.0015297,0.0012789,0.0011633,0.0013855,0.0015736,0.0015345,0.0012789,0.0011619,0.0013832,0.0015735,0.0015333,0.001282,0.00116,0.0013827,0.0015733,0.0015404,0.0012854,0.0011589,0.0013765,0.0015683,0.0015418,0.0012881,0.0011572,0.0013737,0.0015657,0.0015396,0.0012863,0.0011553,0.0013691,0.0015652,0.0015435,0.0012908,0.0011592,0.0013652,0.0015658,0.0015486,0.0013,0.0011604,0.0013634,0.0015631,0.0015468,0.0012943,0.0011568,0.0013573,0.0015589,0.0015525,0.0013005,0.0011525,0.001357,0.0015609,0.0015514,0.0013049,0.0011535,0.0013588,0.0015567,0.0015548,0.0013039,0.0011515,0.0013506,0.0015547,0.0015551,0.0013098,0.0011528,0.0013472,0.0015542,0.0015588,0.0013128,0.0011541,0.0013429,0.0015535,0.0015621,0.0013181,0.0011533,0.0013403,0.0015503,0.0015613,0.001319,0.0011501,0.0013387,0.0015463,0.0015636,0.0013219,0.0011517,0.0013372,0.0015451,0.0015666,0.0013269,0.0011517,0.0013336,0.0015438,0.0015659,0.0013268,0.0011508,0.0013275,0.0015399,0.0015698,0.0013317,0.0011501,0.0013276,0.0015401,0.0015743,0.0013328,0.001151,0.0013268,0.0015358,0.001573,0.001341,0.0011514,0.0013203,0.0015336,0.0015737,0.0013436,0.00115,0.0013196,0.0015324,0.001576,0.0013454,0.0011548,0.0013185,0.0015347,0.0015796,0.0013521,0.0011511,0.0013143,0.0015282,0.0015773,0.0013497,0.0011503,0.0013075,0.0015255,0.0015786,0.0013564,0.0011507,0.0013104,0.0015261,0.0015789,0.0013606,0.0011513,0.0013053,0.0015251,0.0015845,0.0013653,0.0011547,0.0013012,7.9814E-4:6
3.3167E-6,-1.79E-6,2.48E-6,6.6333E-7,-8.0333E-7,2.8467E-6,-1.9833E-6,4.15E-6,2.6833E-6,2.1E-6,3.1133E-6,-4.7E-7,1.3333E-8,1.8E-7,2.5333E-7,1.55E-6,1.9833E-6,4.7533E-6,3.0667E-7,-6.4333E-7,1.58E-6,-2.05E-6,3.27E-6,2.8833E-6,1.07E-6,3.37E-6,2.2633E-6,-3.2567E-6,-7.3334E-8,-8.5E-7,3.5833E-6,-1.2733E-6,0.0013063,0.0043502,0.0023956,0.0018289,0.0012035,0.0015689,0.001546,0.0014281,0.0011657,0.0010519,0.0012423,0.0013802,0.0013358,0.001073,0.0010302,0.0011865,0.0013477,0.0013142,0.0010572,0.0010207,0.0011724,0.0013394,0.0013122,0.0010559,0.0010184,0.0011714,0.001342,0.0013137,0.001058,0.0010191,0.0011696,0.0013394,0.0013183,0.00106,0.0010186,0.0011636,0.0013361,0.0013179,0.0010619,0.0010144,0.0011604,0.0013389,0.0013223,0.0010681,0.0010137,0.0011603,0.0013368,0.0013199,0.0010665,0.0010174,0.0011556,0.0013355,0.001325,0.0010685,0.0010143,0.0011512,0.0013364,0.0013256,0.0010722,0.0010149,0.0011501,0.0013333,0.0013269,0.0010749,0.001015,0.0011477,0.0013349,0.0013312,0.0010776,0.0010128,0.0011453,0.0013322,0.0013293,0.001079,0.0010118,0.0011415,0.0013332,0.0013367,0.0010847,0.0010145,0.0011382,0.0013318,0.0013376,0.0010881,0.0010108,0.0011357,0.0013276,0.001339,0.0010879,0.00101,0.0011348,0.0013299,0.0013384,0.001093,0.0010153,0.0011323,0.0013279,0.0013406,0.0010947,0.0010114,0.0011311,0.0013255,0.0013453,0.0010973,0.0010122,0.0011253,0.0013231,0.0013445,0.0011005,0.0010093,0.0011257,0.0013239,0.0013483,0.0011012,0.001011,0.0011218,0.0013236,0.0013454,0.0011068,0.0010111,0.0011206,0.001321,0.0013477,0.0011082,0.0010114,0.0011135,0.0013189,0.0013498,0.0011092,0.0010144,0.0011157,0.0013202,0.0013535,0.0011162,0.0010162,0.0011127,0.0013204,0.0013576,0.0011171,0.0010115,0.00111,0.0013161,0.0013532,0.00112,0.0010123,0.0011091,0.001315,0.0013572,0.0011224,0.0010123,0.0011085,0.0013126,0.0013563,0.0011261,0.0010127,0.0011042,0.0013108,0.0013567,0.0011272,0.0010131,0.0011022,0.0013067,0.001359,0.00113,0.0010142,0.0010988,0.0013093,0.0013611,0.0011331,0.001014,0.0010976,0.0013107,0.0013624,0.0011353,0.0010137,0.0010948,0.0013051,0.0013607,0.0011403,0.0010173,0.0010931,0.0013067,0.0013656,0.0011452,0.0010152,0.0010881,0.0013044,0.0013644,0.0011485,0.0010157,0.0010866,0.0013016,0.0013633,0.0011468,0.0010145,0.001083,0.0013044,0.0013657,0.0011495,0.0010166,0.0010849,0.0013003,0.0013671,0.0011566,0.0010181,0.0010827,0.0012982,0.0013642,0.0011577,0.0010154,0.001079,0.001298,0.0013666,0.0011638,0.0010187,0.0010787,0.001298,0.0013671,0.0011663,0.0010193,0.0010742,0.0012941,0.0013684,0.0011676,0.001021,0.0010722,0.0012907,0.0013667,0.0011704,0.0010201,0.0010689,0.0012905,0.0013712,0.0011709,0.0010239,0.0010693,0.0012933,0.001372,0.0011738,0.0010198,0.0010647,0.0012875,0.0013678,0.001177,0.0010223,0.0010624,0.0012869,0.001371,0.0011817,0.0010234,0.0010641,0.0012843,0.0013706,0.0011851,0.0010255,0.0010627,0.0012788,0.0013699,0.0011854,0.0010231,0.0010554,0.0012763,0.0013708,0.0011863,0.0010269,0.0010541,0.0012787,0.0013715,0.0011935,0.0010294,0.0010554,0.0012781,0.0013722,0.0011944,0.0010271,0.0010509,0.0012751,0.0013713,0.0011982,0.0010279,0.001049,0.0012735,0.0013704,0.001203,0.0010311,0.0010508,0.0012733,0.0013722,0.0012059,0.001028,0.0010466,0.001271,0.0013691,0.0012063,0.0010295,0.0010453,0.0012717,0.0013716,0.0012083,0.0010334,0.0010443,0.0012694,0.0013728,0.0012136,0.0010358,0.0010416,0.0012658,0.001373,0.0012155,0.0010325,0.0010389,0.0012602,0.0013719,0.0012184,0.0010347,0.0010382,0.0012607,0.0013718,0.0012212,0.0010379,0.0010373,0.0012615,0.0013727,0.0012238,0.0010387,0.0010356,0.0012564,0.0013679,0.0012269,0.0010365,0.0010317,0.0012538,0.0013709,0.0012291,0.0010425,0.0010334,0.0012617,0.0013787,0.0:6
1.5567E-5,1.3883E-5,1.8613E-5,1.2643E-5,1.2033E-6,2.208E-5,1.7657E-5,1.3947E-5,1.2133E-5,1.5557E-5,1.9857E-5,2.6027E-5,1.594E-5,1.767E-5,9.2867E-6,1.9107E-5,7.9333E-6,1.444E-5,1.8493E-5,1.257E-5,2.1967E-5,1.879E-5,1.2813E-5,1.9277E-5,1.6633E-6,1.557E-5,1.8073E-5,1.2373E-5,2.0603E-5,7.87E-6,1.8923E-5,1.9683E-5,1.3357E-5,1.4737E-5,0.0026937,0.0050956,0.0035748,0.002697,0.0020124,0.0018042,0.0021167,0.0023497,0.0021614,0.0018142,0.0016695,0.0020403,0.0023015,0.0021518,0.0018056,0.0016791,0.0020417,0.0023104,0.0021439,0.0018067,0.0016778,0.0020431,0.0023124,0.0021485,0.0018064,0.0016706,0.0020462,0.0023081,0.0021502,0.0018122,0.0016759,0.0020429,0.0023226,0.0021591,0.0018105,0.0016823,0.0020411,0.0023135,0.0021685,0.001816,0.0016792,0.0020468,0.0023214,0.002168,0.001814,0.0016835,0.0020563,0.0023303,0.0021661,0.001817,0.0016875,0.0020451,0.002328,0.0021657,0.0018206,0.0016846,0.0020526,0.0023298,0.0021661,0.0018217,0.0016864,0.0020525,0.0023305,0.0021681,0.0018295,0.0016863,0.0020495,0.0023342,0.0021682,0.0018124,0.0016898,0.0020587,0.0023277,0.0021768,0.0018234,0.0016785,0.0020557,0.0023277,0.0021734,0.0018186,0.0016886,0.0020559,0.0023292,0.0021724,0.0018167,0.0016887,0.0020458,0.0023279,0.0021758,0.0018134,0.0016873,0.0020486,0.0023332,0.002185,0.0018191,0.0016892,0.0020466,0.002339,0.0021848,0.0018214,0.0016973,0.0020504,0.0023381,0.0021871,0.0018192,0.0016923,0.0020523,0.0023322,0.0021801,0.0018279,0.0016811,0.0020523,0.0023299,0.0021785,0.001827,0.001697,0.0020578,0.0023411,0.0021872,0.0018265,0.0016951,0.0020504,0.0023355,0.0021911,0.0018259,0.0016872,0.0020558,0.0023326,0.0021957,0.0018176,0.0016934,0.0020557,0.0023446,0.0022027,0.0018316,0.0016908,0.0020549,0.0023398,0.0021908,0.0018185,0.0016953,0.0020649,0.0023413,0.0021893,0.0018242,0.0016979,0.0020557,0.0023474,0.0021946,0.0018319,0.0016873,0.0020558,0.0023416,0.0021929,0.0018252,0.0016959,0.0020566,0.0023322,0.0022001,0.0018225,0.001695,0.0020499,0.0023413,0.0021921,0.0018283,0.0017022,0.0020479,0.0023423,0.0022017,0.0018235,0.001693,0.0020564,0.0023372,0.002201,0.0018193,0.0016943,0.0020594,0.002338,0.0021991,0.0018338,0.0016916,0.0020636,0.0023465,0.0021924,0.0018272,0.0016932,0.0020661,0.0023486,0.0021889,0.0018286,0.0016859,0.0020575,0.0023489,0.0022009,0.0018269,0.0016964,0.0020669,0.0023491,0.0021968,0.0018338,0.0017105,0.0020599,0.0023368,0.0022087,0.0018261,0.0017056,0.0020612,0.002344,0.002207,0.0018284,0.0016978,0.0020581,0.0023513,0.0022064,0.0018284,0.0017011,0.0020492,0.0023546,0.0022013,0.0018348,0.0016944,0.0020504,0.0023403,0.0021916,0.0018311,0.001696,0.0020528,0.0023481,0.0022015,0.0018246,0.0016891,0.0020511,0.0023417,0.0022037,0.0018376,0.001694,0.0020574,0.0023372,0.0022037,0.0018265,0.0016991,0.0020581,0.0023394,0.0022111,0.0018314,0.0017026,0.0020548,0.0023465,0.0022065,0.001832,0.0016922,0.0020572,0.0023417,0.0022044,0.0018283,0.0016905,0.0020565,0.0023417,0.0022069,1.5446E-4:6
1.5183E-5,2.503E-5,2.4667E-6,1.313E-5,3.3767E-6,1.06E-5,1.8013E-5,2.25E-6,2.2257E-5,9.1533E-6,2.2117E-5,1.9657E-5,-4.14E-6,4.2267E-6,8.3033E-6,1.86E-5,2.5133E-5,8.2367E-6,1.795E-5,5.2467E-6,1.8077E-5,3.3613E-5,6.0933E-6,1.0733E-5,6.83E-6,2.685E-5,2.738E-5,1.1037E-5,1.495E-5,8.49E-6,1.552E-5,2.8563E-5,-2.8033E-6,1.812E-5,4.13E-6,0.0036812,0.0051996,0.0027316,0.0023751,0.0018958,0.0024379,0.0023874,0.0019431,0.0017246,0.0017985,0.0022196,0.0022929,0.0019363,0.0016929,0.0018007,0.0022206,0.0022813,0.0019237,0.0016919,0.0018149,0.0022109,0.0023007,0.0019386,0.0016985,0.001812,0.0022108,0.0023124,0.0019347,0.0017016,0.0018191,0.0022215,0.0023137,0.0019348,0.0017062,0.0018203,0.0022126,0.0023094,0.0019397,0.0017055,0.0018253,0.0022238,0.0023144,0.0019399,0.0017022,0.0018238,0.0022288,0.0023209,0.0019373,0.0017097,0.0018283,0.0022398,0.0023142,0.0019394,0.0017025,0.0018408,0.0022278,0.0023213,0.0019294,0.0017144,0.0018275,0.0022369,0.0023202,0.0019332,0.0017174,0.0018321,0.0022381,0.0023248,0.0019308,0.0017105,0.0018416,0.0022393,0.0023257,0.0019353,0.001714,0.0018318,0.0022435,0.0023263,0.001933,0.001714,0.0018448,0.0022424,0.0023233,0.0019394,0.0017133,0.0018435,0.0022506,0.0023239,0.0019376,0.0017126,0.0018356,0.0022468,0.0023254,0.0019465,0.0017187,0.0018481,0.0022439,0.0023321,0.0019262,0.0017044,0.0018511,0.0022436,0.0023324,0.0019319,0.0017248,0.001858,0.0022549,0.0023376,0.0019292,0.001678,0.0018135,0.0022193,0.002295,0.0018912,0.0016862,0.0018342,0.0022298,0.0023003,0.0019034,0.0017019,0.001832,0.0022232,0.002294,0.0018942,0.0016913,0.0018375,0.0022355,0.0022972,0.0018956,0.0016969,0.0018402,0.0022291,0.0023017,0.0019039,0.0016914,0.0018431,0.0022343,0.0023091,0.0019021,0.0016991,0.0018434,0.0022225,0.002299,0.0019047,0.0017023,0.0018565,0.0022351,0.0023135,0.0018974,0.0016954,0.0018489,0.0022402,0.0023075,0.0018958,0.0016958,0.0018507,0.0022441,0.0023156,0.0018982,0.001701,0.0018565,0.0022427,0.0023107,0.0018988,0.0016956,0.0018583,0.0022477,0.0023163,0.0019024,0.0017121,0.0018672,0.0022645,0.0023283,0.0019069,0.0017166,0.0018663,0.0022647,0.0023279,0.00191,0.0017163,0.0018773,0.0022705,0.0023242,0.00191,0.0017151,0.001874,0.0022663,0.002336,0.0018996,0.0017174,0.0018775,0.0022739,0.0023395,0.0018954,0.0017218,0.0018799,0.002275,0.0023336,0.0019025,0.0017139,0.001874,0.0022734,0.002328,0.0019041,0.0017214,0.0018918,0.0022778,0.0023278,0.0019005,0.00171,0.0018837,0.0022781,0.0023359,0.0019086,0.0017096,0.0018878,0.0022686,0.0023276,0.0019024,0.0017123,0.0018952,0.0022736,0.0023402,0.0018995,0.0017173,0.001897,0.0022754,0.0023403,0.0019018,0.0017218,0.001899,0.0022708,0.0023349,0.0018904,0.0017209,0.0018925,0.0022817,0.0023311,0.001893,0.001717,0.001889,0.0022883,0.0023211,0.001892,0.0017229,0.0018943,0.0022812,0.0023313,0.0018932,0.001713,0.0018944,0.0022836,0.0023253,0.0018939,0.0017228,0.0018933,0.0022859,0.0023283,0.0018936,2.4746E-4:6
1.2773E-5,2.001E-5,9.1E-7,2.387E-5,1.6103E-5,1.075E-5,1.6933E-5,9.73E-6,2.324E-5,1.292E-5,1.751E-5,1.1547E-5,2.5E-6,1.7257E-5,1.7193E-5,6.4033E-6,1.9853E-5,-4.1333E-7,1.8463E-5,5.2633E-6,8.2467E-6,1.7403E-5,-2.0667E-7,1.45E-5,1.024E-5,1.5847E-5,1.9273E-5,4.6833E-6,1.5633E-5,1.6783E-5,0.0067543,0.0032894,0.0021847,0.002427,0.0024511,0.002285,0.0018501,0.0016515,0.0019842,0.0022302,0.0021702,0.0017961,0.0016416,0.0019774,0.0022287,0.0021764,0.0018022,0.0016355,0.0019805,0.0022398,0.0021748,0.0018017,0.0016476,0.001985,0.0022447,0.0021754,0.0017998,0.0016371,0.0020034,0.002244,0.0021844,0.0018001,0.0016489,0.002004,0.0022439,0.0021816,0.0018048,0.0016536,0.0020038,0.0022589,0.0021897,0.0018107,0.0016516,0.0020001,0.0022579,0.0021934,0.001804,0.0016535,0.002014,0.0022548,0.0021906,0.0018092,0.0016488,0.0020108,0.002262,0.0021924,0.00181,0.0016514,0.0020105,0.0022617,0.0021899,0.0018096,0.0016582,0.0020125,0.0022684,0.0022,0.0018034,0.0016637,0.0020172,0.002264,0.0021907,0.0017977,0.0016605,0.0020149,0.0022706,0.0021929,0.0018059,0.0016651,0.002016,0.0022814,0.0021933,0.0018063,0.0016715,0.0020245,0.0022885,0.0021972,0.0018027,0.0016708,0.0020249,0.0022907,0.0021918,0.0018055,0.001666,0.0020317,0.0022918,0.0021862,0.0018084,0.0016766,0.0020307,0.0022858,0.0021922,0.0018142,0.0016684,0.0020406,0.0022793,0.0021899,0.0018038,0.0016744,0.002033,0.0022839,0.0022004,0.0018009,0.0016778,0.0020411,0.0023022,0.0021852,0.0018046,0.0016731,0.0020463,0.0022873,0.0021875,0.0017977,0.0016754,0.002038,0.0022844,0.0021863,0.0017999,0.0016817,0.0020391,0.0022987,0.0021839,0.0018003,0.0016817,0.0020479,0.0022964,0.0021838,0.0018051,0.0016854,0.0020539,0.0023057,0.0021821,0.0018023,0.0016871,0.0020561,0.0022992,0.0021875,0.0017969,0.0016821,0.0020497,0.0022996,0.0021844,0.0018058,0.001683,0.0020594,0.0023027,0.0021909,0.001799,0.0016885,0.002054,0.0023148,0.0021768,0.0017956,0.0016926,0.0020674,0.0023089,0.0021787,0.0018034,0.0016881,0.002064,0.0023035,0.0021822,0.0017943,0.0016918,0.0020734,0.0023099,0.0021821,0.0018006,0.0016911,0.0020674,0.0023015,0.0021781,0.0017942,0.0016868,0.0020798,0.0023005,0.0021754,0.0017917,0.0016849,0.0020703,0.0023138,0.0021729,0.0017846,0.0016997,0.0020674,0.0023027,0.0021775,0.0017857,0.0016983,0.0020702,0.0023228,0.00217,0.0017857,0.001706,0.0020686,0.0023224,0.0021707,0.0017827,0.0016982,0.0020728,0.0023207,0.0021623,0.0017871,0.0016937,0.0020715,0.0023242,0.0021548,0.0017872,0.0016955,0.0020924,0.0023168,0.002149,0.0017912,0.0016984,0.0020837,0.0023189,0.0021564,0.0017765,0.0017022,0.0020851,0.0023134,0.0021585,0.0017848,0.0017022,0.0020871,0.0023103,0.0021583,0.0017853,0.0017005,0.0020902,0.0023207,0.0021658,0.0017738,0.0017076,0.0020811,0.0023172,0.0021664,0.0017785,0.0017025,0.0020896,0.0023254,0.0021569,0.0017837,0.0017164,0.0020843,0.0023197,0.0021529,0.0017765,0.0017062,0.0020982,0.0023246,0.0021498,0.0017699,0.0017052,0.002101,0.002315,0.0021542,0.0017862,0.0017045,0.0021035,0.0023217,0.0021544,0.0017777,0.0017093,0.0020969,0.0023234,0.0021456,0.0017771,0.0017118,0.0021081,0.0023299,0.0021354,0.0017764,0.0017115,0.0021082,0.0023283,0.0021433,0.0017791,0.0017149,0.0021072,0.0023321,0.0021406,0.0017799,0.0017127,0.002113,0.0023253,0.0021373,0.0017779,0.0017118,0.0021196,0.0023341,0.0021438,0.0017771,0.0017157,0.0021116,0.0023207,0.0021365,0.0017757,0.0017204,0.0021183,0.0023249,0.0021321,0.0017747,0.0017266,0.002114,0.0023289,0.002135,0.001762,0.0017175,0.0021153,0.0023313,0.002131,0.0017708,0.0017212,0.0021123,0.0023398,0.0021399,0.0017696,0.001728,0.0021201,0.0023357,0.0021336,0.0017651,0.0017261,0.0021196,0.0023374,0.0021281,0.0017711,0.0017194,0.0021279,0.0023349,0.0021251,0.0017686,0.001724,0.002131,0.0023324,0.0021147,0.0017712,0.0017232,0.0021227,0.0023344,0.002118,0.0017678,0.0017271,0.0021285,0.0023277,0.0021161,0.0017625,0.0017211,0.0021247,0.002332,0.0021157,0.0017575,0.0017254,0.0021337,0.002338,0.0021077,0.0017626,0.0017269,0.0021317,0.002345,0.0021146,0.0017569,0.00173,0.0021386,0.0023437,0.0021255,0.0017635,0.0017325,0.002137,0.0023355,0.0021157,0.0017569,0.0017341,0.0021425,0.0023434,0.0021094,0.0017651,0.0017335,0.0021467,0.0023379,0.0021109,0.0017542,0.0017435,0.0021379,0.0023396,0.0021135,0.0017596,0.0017342,0.0021462,0.0023459,0.0021033,0.001749,0.0017486,0.0021428,0.0023431,0.0020948,0.0017576,0.0017422,0.0021505,0.0023415,0.0020965,0.0017551,0.001744,0.0021569,0.0023371,0.0020851,0.0017575,0.0017471,0.0021602,0.0023417,0.0020863,0.001752,0.0017439,0.0021683,0.0023356,0.0020863,0.0017423,0.0017476,0.0021643,0.0023439,0.0021019,0.0017494,0.0017514,0.002157,0.0023338,0.0020854,0.0017365,0.0017509,0.0021609,0.0023465,0.0020874,0.001743,0.0017551,0.0011448:6
-7.2333E-7,2.34E-6,-1.3667E-7,2.33E-6,1.8267E-6,-1.7E-7,8.1667E-7,-2.8333E-7,1.82E-6,1.4733E-6,-1.3667E-7,1.6633E-6,-9.5333E-7,1.1833E-6,1.5767E-6,3.1E-7,1.4267E-6,-8.9E-7,2.1467E-6,2.0867E-6,-3.9333E-7,1.4967E-6,-4.5E-7,1.9533E-6,8.5E-7,-1.6667E-7,7.2333E-7,1.2667E-7,2.0E-6,1.7533E-6,-1.9167E-6,1.5667E-6,0.0014033,0.0011051,7.9908E-4,6.3572E-4,4.985E-4,4.4169E-4,5.2576E-4,5.601E-4,5.2244E-4,4.1166E-4,4.2116E-4,4.8774E-4,5.4601E-4,5.1184E-4,4.0642E-4,4.1867E-4,4.8166E-4,5.4539E-4,5.1001E-4,4.0492E-4,4.1809E-4,4.8191E-4,5.4612E-4,5.0976E-4,4.0604E-4,4.1769E-4,4.8295E-4,5.4624E-4,5.1086E-4,4.0781E-4,4.1845E-4,4.8383E-4,5.4425E-4,5.1118E-4,4.089E-4,4.1968E-4,4.8401E-4,5.4507E-4,5.1274E-4,4.0749E-4,4.1873E-4,4.849E-4,5.4728E-4,5.1559E-4,4.0962E-4,4.2057E-4,4.8501E-4,5.4803E-4,5.1396E-4,4.1046E-4,4.1932E-4,4.8423E-4,5.479E-4,5.1618E-4,4.103E-4,4.1896E-4,4.8362E-4,5.4763E-4,5.1379E-4,4.1087E-4,4.1806E-4,4.8335E-4,5.459E-4,5.1507E-4,4.0829E-4,4.1827E-4,4.8361E-4,5.4526E-4,5.1771E-4,4.0977E-4,4.1823E-4,4.8351E-4,5.4375E-4,5.174E-4,4.0893E-4,4.2068E-4,4.8276E-4,5.459E-4,5.1694E-4,4.1058E-4,4.1862E-4,4.8154E-4,5.4715E-4,5.1681E-4,4.1091E-4,4.1976E-4,4.819E-4,5.5053E-4,5.1738E-4,4.1314E-4,4.1939E-4,4.7979E-4,5.486E-4,5.1696E-4,4.1171E-4,4.1736E-4,4.8225E-4,5.4691E-4,5.1819E-4,4.1283E-4,4.1865E-4,4.8349E-4,5.4473E-4,5.1869E-4,4.1265E-4,4.1898E-4,4.8247E-4,5.463E-4,5.2089E-4,4.1241E-4,4.1944E-4,4.8195E-4,5.4634E-4,5.204E-4,4.115E-4,4.1853E-4,4.7858E-4,5.4848E-4,5.2028E-4,4.1156E-4,4.181E-4,4.7889E-4,5.499E-4,5.1954E-4,4.1304E-4,4.168E-4,4.8218E-4,5.4902E-4,5.1835E-4,4.1312E-4,4.1782E-4,4.8068E-4,5.4788E-4,5.1892E-4,4.1385E-4,4.188E-4,4.8108E-4,5.4638E-4,5.2199E-4,4.1541E-4,4.1739E-4,4.7929E-4,5.484E-4,5.2132E-4,4.1173E-4,4.1689E-4,4.806E-4,5.4763E-4,5.1931E-4,4.1481E-4,4.185E-4,4.7843E-4,5.4867E-4,5.2214E-4,4.1375E-4,4.184E-4,4.7874E-4,5.4979E-4,5.2242E-4,4.1381E-4,4.1767E-4,4.7856E-4,5.5087E-4,5.2176E-4,4.1515E-4,4.1676E-4,4.7935E-4,5.4892E-4,5.2344E-4,4.1524E-4,4.187E-4,4.8094E-4,5.4939E-4,5.2352E-4,4.1445E-4,4.1972E-4,4.7998E-4,5.5035E-4,5.2127E-4,4.1351E-4,4.2048E-4,4.7854E-4,5.498E-4,5.2298E-4,4.1462E-4,4.2192E-4,4.7531E-4,5.5359E-4,5.222E-4,4.1487E-4,4.1836E-4,4.7653E-4,5.5009E-4,5.2036E-4,4.1831E-4,4.1746E-4,4.7607E-4,5.5028E-4,5.2182E-4,4.1802E-4,4.1605E-4,4.7961E-4,5.4884E-4,5.1975E-4,4.1843E-4,4.1817E-4,4.7834E-4,5.4793E-4,5.2158E-4,4.1861E-4,4.174E-4,4.7989E-4,5.4985E-4,5.2418E-4,4.1554E-4,4.1516E-4,4.7754E-4,5.4638E-4,5.231E-4,4.1551E-4,4.1763E-4,4.7557E-4,5.4819E-4,5.2496E-4,4.1607E-4,4.1794E-4,4.7777E-4,5.4855E-4,5.2346E-4,4.1589E-4,4.1855E-4,4.7422E-4,5.4972E-4,5.2495E-4,4.172E-4,4.1688E-4,4.751E-4,5.493E-4,5.2451E-4,4.1567E-4,4.185E-4,4.7406E-4,5.481E-4,5.2414E-4,4.1443E-4,4.1673E-4,4.7309E-4,5.4723E-4,5.2599E-4,4.1683E-4,4.1731E-4,4.737E-4,5.516E-4,5.2542E-4,4.1652E-4,4.1664E-4,4.7342E-4,5.524E-4,5.2643E-4,4.1968E-4,4.1715E-4,4.7434E-4,5.4953E-4,5.2396E-4,4.2115E-4,4.1542E-4,4.7588E-4,5.5094E-4,5.2493E-4,4.2047E-4,4.1514E-4,4.7565E-4,5.4701E-4,5.2687E-4,4.1878E-4,4.1583E-4,4.7404E-4,5.4639E-4,5.2913E-4,4.185E-4,4.1528E-4,4.7268E-4,5.4727E-4,5.2794E-4,4.1707E-4,4.1558E-4,4.7314E-4,5.4828E-4,0.0:6
1.0E-7,1.1867E-6,1.3667E-7,2.1767E-6,1.74E-6,-7.7E-7,1.3833E-6,-8.3333E-7,1.27E-6,-4.2E-7,-8.2E-7,1.88E-6,-6.0333E-7,2.6467E-6,6.0333E-7,-3.6667E-8,1.6333E-6,-1.0633E-6,1.7E-6,8.2E-7,-9.0E-8,2.2867E-6,-1.4233E-6,2.2167E-6,-9.0667E-7,6.0667E-7,2.6633E-6,3.4E-7,3.33E-6,1.32E-6,-3.5E-7,1.84E-6,-8.6E-7,1.6033E-6,1.6867E-6,1.8167E-6,0.0011975,0.0010678,7.1328E-4,7.5491E-4,6.5374E-4,4.7021E-4,4.5586E-4,4.8298E-4,5.6454E-4,5.5339E-4,4.3406E-4,4.2231E-4,4.6844E-4,5.4821E-4,5.4688E-4,4.3281E-4,4.1809E-4,4.6598E-4,5.4851E-4,5.4432E-4,4.3006E-4,4.1787E-4,4.6366E-4,5.4773E-4,5.42E-4,4.317E-4,4.1853E-4,4.6505E-4,5.4667E-4,5.4311E-4,4.3095E-4,4.1891E-4,4.6533E-4,5.481E-4,5.4209E-4,4.3202E-4,4.1799E-4,4.6594E-4,5.4683E-4,5.4537E-4,4.3146E-4,4.1836E-4,4.6552E-4,5.4713E-4,5.4483E-4,4.3119E-4,4.1866E-4,4.6622E-4,5.4709E-4,5.4396E-4,4.3153E-4,4.1827E-4,4.6673E-4,5.5132E-4,5.4424E-4,4.3272E-4,4.2009E-4,4.6477E-4,5.5221E-4,5.4073E-4,4.3317E-4,4.1885E-4,4.6553E-4,5.5146E-4,5.4091E-4,4.3483E-4,4.1803E-4,4.6748E-4,5.4982E-4,5.4258E-4,4.3258E-4,4.1848E-4,4.6839E-4,5.4954E-4,5.4428E-4,4.3305E-4,4.1698E-4,4.6846E-4,5.489E-4,5.4472E-4,4.326E-4,4.1743E-4,4.6729E-4,5.4894E-4,5.4675E-4,4.3291E-4,4.198E-4,4.6777E-4,5.5106E-4,5.4432E-4,4.3078E-4,4.1969E-4,4.6584E-4,5.514E-4,5.4403E-4,4.3192E-4,4.1899E-4,4.6645E-4,5.5202E-4,5.4455E-4,4.342E-4,4.175E-4,4.685E-4,5.5217E-4,5.4207E-4,4.3275E-4,4.1874E-4,4.6636E-4,5.5152E-4,5.4207E-4,4.331E-4,4.1917E-4,4.6701E-4,5.4996E-4,5.4302E-4,4.3425E-4,4.1905E-4,4.6779E-4,5.5198E-4,5.4435E-4,4.3269E-4,4.1901E-4,4.6783E-4,5.5057E-4,5.4124E-4,4.3114E-4,4.177E-4,4.6527E-4,5.5094E-4,5.4126E-4,4.3322E-4,4.184E-4,4.6565E-4,5.5003E-4,5.4053E-4,4.3256E-4,4.1758E-4,4.6694E-4,5.5003E-4,5.4213E-4,4.3161E-4,4.1706E-4,4.6845E-4,5.498E-4,5.4472E-4,4.3338E-4,4.1848E-4,4.6776E-4,5.4909E-4,5.4442E-4,4.3291E-4,4.1953E-4,4.6664E-4,5.4982E-4,5.4534E-4,4.3074E-4,4.2058E-4,4.6589E-4,5.5471E-4,5.4149E-4,4.3364E-4,4.2206E-4,4.6537E-4,5.5251E-4,5.4097E-4,4.333E-4,4.1803E-4,4.6623E-4,5.5314E-4,5.4181E-4,4.3224E-4,4.1843E-4,4.6789E-4,5.5454E-4,5.4119E-4,4.3445E-4,4.1806E-4,4.6733E-4,5.5196E-4,5.4196E-4,4.3434E-4,4.1814E-4,4.6872E-4,5.4952E-4,5.4415E-4,4.3257E-4,4.1957E-4,4.6734E-4,5.5032E-4,5.4482E-4,4.3382E-4,4.1779E-4,4.6655E-4,5.5112E-4,5.423E-4,4.3167E-4,4.1873E-4,4.6738E-4,5.5397E-4,5.4463E-4,4.3346E-4,4.1894E-4,4.6609E-4,5.5047E-4,5.433E-4,4.348E-4,4.1952E-4,4.6729E-4,5.5266E-4,5.4452E-4,4.3402E-4,4.1868E-4,4.6691E-4,5.5221E-4,5.4296E-4,4.3176E-4,4.2031E-4,4.6601E-4,5.5055E-4,5.4455E-4,4.3313E-4,4.2048E-4,4.6634E-4,5.5292E-4,5.4318E-4,4.3302E-4,4.1828E-4,4.6404E-4,5.5343E-4,5.4304E-4,4.3313E-4,4.1963E-4,4.6482E-4,5.537E-4,5.4017E-4,4.3363E-4,4.1927E-4,4.663E-4,5.5424E-4,5.4309E-4,4.3578E-4,4.1736E-4,4.6873E-4,5.4981E-4,5.4404E-4,4.3262E-4,4.1753E-4,4.6902E-4,5.5176E-4,5.4301E-4,4.3306E-4,4.1816E-4,4.6758E-4,5.4998E-4,5.4411E-4,4.3283E-4,4.2022E-4,4.6632E-4,5.5342E-4,5.4265E-4,4.3244E-4,4.2026E-4,4.6723E-4,5.5172E-4,5.4314E-4,4.3355E-4,4.1972E-4,4.668E-4,5.5254E-4,5.4237E-4,4.3422E-4,4.196E-4,4.6846E-4,5.5296E-4,5.4106E-4,4.348E-4,4.1819E-4,4.6796E-4,5.5228E-4,5.4227E-4,4.3498E-4,4.1954E-4,4.6753E-4,5.5254E-4,5.4428E-4,4.336E-4,4.1902E-4,4.6644E-4,5.51E-4,5.4389E-4,4.3357E-4,4.1894E-4,4.6567E-4,5.5341E-4,5.4537E-4,4.3464E-4,4.2002E-4,4.6643E-4,5.5256E-4,5.4424E-4,4.3311E-4,4.1879E-4,4.6597E-4,5.5342E-4,5.4221E-4,4.3498E-4,4.188E-4,4.6739E-4,5.4989E-4,5.4275E-4,4.3545E-4,4.1723E-4,4.6802E-4,5.5083E-4,5.4337E-4,4.3408E-4,4.1849E-4,4.6663E-4,5.5011E-4,5.4604E-4,4.3222E-4,4.1898E-4,4.6649E-4,5.5212E-4,0.0:6
-2.6167E-6,1.0433E-6,1.5433E-6,-4.3333E-8,4.3867E-6,-2.3267E-6,1.6667E-8,2.2333E-7,-1.0467E-6,1.81E-6,-2.1333E-7,2.59E-6,3.7367E-6,-3.3267E-6,2.2067E-6,1.7667E-6,2.7067E-6,4.9033E-6,0.0040846,0.00168,0.0013567,0.0013809,0.001387,0.0012283,9.4901E-4,9.4274E-4,0.0010952,0.0011892,0.001115,8.888E-4,9.0211E-4,0.0010662,0.0011707,0.0011003,8.8451E-4,9.0184E-4,0.0010683,0.0011696,0.0010971,8.8169E-4,8.9778E-4,0.0010674,0.00117,0.0010992,8.7962E-4,9.0222E-4,0.0010692,0.0011655,0.001093,8.7659E-4,9.0388E-4,0.0010718,0.0011708,0.0010887,8.7586E-4,9.0162E-4,0.0010727,0.0011697,0.0010861,8.744E-4,9.0338E-4,0.0010738,0.0011655,0.0010842,8.7399E-4,9.039E-4,0.0010759,0.0011666,0.0010854,8.7115E-4,9.0765E-4,0.0010779,0.0011654,0.0010796,8.7125E-4,9.101E-4,0.0010818,0.0011683,0.0010818,8.6636E-4,9.0568E-4,0.0010812,0.0011668,0.0010797,8.6859E-4,9.1037E-4,0.0010818,0.0011673,0.001075,8.6538E-4,9.1033E-4,0.0010853,0.0011645,0.0010729,8.6111E-4,9.1364E-4,0.0010863,0.0011686,0.0010701,8.6499E-4,9.1593E-4,0.0010899,0.001163,0.0010705,8.6057E-4,9.1618E-4,0.0010912,0.0011655,0.0010684,8.618E-4,9.1653E-4,0.001092,0.001164,0.0010655,8.6167E-4,9.172E-4,0.0010971,0.0011673,0.0010653,8.6239E-4,9.1947E-4,0.0010939,0.0011632,0.0010627,8.584E-4,9.2205E-4,0.0010955,0.0011628,0.0010618,8.5852E-4,9.2096E-4,0.0010983,0.001166,0.0010551,8.586E-4,9.2227E-4,0.0011025,0.0011625,0.001056,8.5543E-4,9.3013E-4,0.0011046,0.0011652,0.001056,8.5593E-4,9.2697E-4,0.0011063,0.0011637,0.0010542,8.5681E-4,9.2719E-4,0.0011085,0.0011634,0.0010506,8.5468E-4,9.3029E-4,0.0011101,0.0011654,0.0010447,8.5475E-4,9.3334E-4,0.0011086,0.0011625,0.0010455,8.5194E-4,9.3443E-4,0.0011134,0.0011611,0.001041,8.5282E-4,9.3375E-4,0.001113,0.001161,0.0010387,8.5165E-4,9.3838E-4,0.0011144,0.0011588,0.0010394,8.5165E-4,9.3862E-4,0.0011163,0.0011674,0.0010373,8.5018E-4,9.3859E-4,0.0011192,0.0011601,0.0010333,8.4941E-4,9.4359E-4,0.0011211,0.0011586,0.0010336,8.4936E-4,9.4372E-4,0.0011225,0.0011603,0.0010299,8.4812E-4,9.4468E-4,0.0011225,0.0011595,0.0010275,8.5005E-4,9.456E-4,0.0011224,0.0011602,0.0010245,8.4648E-4,9.4856E-4,0.0011251,0.0011606,0.0010251,8.467E-4,9.5183E-4,0.0011268,0.0011564,0.0010232,8.4771E-4,0.0:6
3.8033E-6,6.2E-7,1.9167E-6,1.2267E-6,-3.4267E-6,2.5767E-6,1.3333E-8,4.7133E-6,2.4567E-6,-2.3067E-6,-1.1E-7,-1.8067E-6,2.89E-6,-1.8233E-6,2.89E-6,1.9267E-6,1.13E-6,3.68E-6,2.51E-6,-5.0E-7,8.5E-7,-1.5333E-6,-1.1333E-7,1.88E-6,3.2936E-4,0.0031581,0.0020154,0.0015636,0.0015378,0.0012996,9.3978E-4,0.0010101,0.0011399,0.001209,0.0011056,8.7777E-4,9.296E-4,0.0010997,0.0011743,0.001084,8.6944E-4,9.2619E-4,0.0010999,0.0011719,0.0010773,8.6914E-4,9.2333E-4,0.0011012,0.0011741,0.0010787,8.6534E-4,9.2196E-4,0.0010983,0.0011692,0.001074,8.6541E-4,9.2535E-4,0.0010996,0.0011687,0.0010682,8.6434E-4,9.2391E-4,0.0011015,0.0011656,0.0010669,8.6101E-4,9.255E-4,0.0011037,0.0011667,0.0010656,8.597E-4,9.2704E-4,0.0011022,0.0011684,0.0010625,8.6305E-4,9.2813E-4,0.0011087,0.0011671,0.0010612,8.5878E-4,9.2833E-4,0.001106,0.0011668,0.0010556,8.5612E-4,9.2898E-4,0.001107,0.0011676,0.0010567,8.6002E-4,9.3109E-4,0.0011096,0.0011678,0.0010523,8.5617E-4,9.3318E-4,0.0011119,0.0011668,0.0010524,8.5418E-4,9.3464E-4,0.0011144,0.0011664,0.0010505,8.5573E-4,9.3853E-4,0.0011146,0.0011651,0.0010491,8.525E-4,9.3624E-4,0.0011192,0.0011648,0.0010495,8.5566E-4,9.4172E-4,0.001119,0.0011626,0.0010414,8.541E-4,9.3839E-4,0.0011224,0.0011661,0.0010412,8.5221E-4,9.3968E-4,0.0011194,0.0011632,0.0010419,8.5185E-4,9.4357E-4,0.001123,0.001164,0.0010362,8.5031E-4,9.4364E-4,0.0011236,0.0011648,0.0010364,8.5185E-4,9.462E-4,0.0011235,0.0011645,0.0010336,8.4982E-4,9.5115E-4,0.0011241,0.0011635,0.0010332,8.4907E-4,9.5056E-4,0.001128,0.0011612,0.0010328,8.4865E-4,9.5414E-4,0.001132,0.0011602,0.0010247,8.4775E-4,9.5321E-4,0.0011307,0.0011595,0.0010288,8.4773E-4,9.5702E-4,0.0011309,0.0011606,0.0010247,8.4927E-4,9.5771E-4,0.00113,0.0011618,0.0010226,8.4844E-4,9.5699E-4,0.0011336,0.0011599,0.0010223,8.475E-4,9.5816E-4,0.001135,0.0011582,0.0010186,8.489E-4,9.6219E-4,0.0011391,0.0011588,0.0010173,8.4885E-4,9.6056E-4,0.0011382,0.0011584,0.0010141,8.5036E-4,9.6513E-4,0.0011388,0.0011549,0.0010127,8.4553E-4,9.6216E-4,0.0011396,0.0011598,0.0010115,8.4549E-4,9.674E-4,0.0011402,0.0011525,0.0010092,8.454E-4,9.6887E-4,0.0011425,0.0011558,0.0010061,8.4592E-4,9.6903E-4,0.0011448,0.0011568,0.0010064,8.4541E-4,9.7604E-4,0.0011439,0.0011517,0.001003,8.4656E-4,9.7529E-4,0.0011455,0.0011552,0.0010018,8.4417E-4,9.7439E-4,0.0011468,0.0011529,9.9989E-4,8.4798E-4,9.7408E-4,0.0011441,0.0011509,9.9869E-4,8.4511E-4,9.7876E-4,0.0011486,0.001152,9.9787E-4,8.4586E-4,9.8177E-4,0.0011474,0.0011513,9.9317E-4,8.4705E-4,9.8349E-4,0.0011488,0.0011504,9.9171E-4,8.4396E-4,9.8606E-4,0.0011495,0.001149,9.8831E-4,8.4638E-4,9.8584E-4,0.0011527,0.0011478,9.8975E-4,8.4469E-4,9.867E-4,0.0011521,0.0011475,9.8711E-4,8.4526E-4,9.8964E-4,0.0011516,0.0011459,9.8719E-4,8.4589E-4,9.9309E-4,0.0011555,0.0011446,9.8297E-4,8.4802E-4,9.9525E-4,0.0011551,0.0011456,9.8367E-4,8.4624E-4,9.932E-4,0.0011555,0.0011436,9.8313E-4,8.4669E-4,9.9704E-4,0.0011581,0.0011446,9.7874E-4,8.4685E-4,9.9513E-4,0.0011582,0.001144,9.7787E-4,8.4615E-4,9.9942E-4,0.0011587,0.0011401,9.7591E-4,8.4569E-4,0.0010034,0.0011585,0.0011401,9.7723E-4,8.4521E-4,9.9935E-4,0.0011585,0.001138,9.7661E-4,8.4684E-4,0.0010029,0.0011608,0.001135,9.7208E-4,8.4602E-4,0.0010058,0.0011607,0.0011372,9.7043E-4,8.4763E-4,0.0010081,0.0011632,0.0011367,9.7016E-4,8.4799E-4,0.0010098,0.001166,0.0011379,9.6545E-4,8.4521E-4,0.0010111,0.001163,0.0011374,9.6764E-4,0.0:6
-9.4333E-7,1.68E-6,8.6667E-7,5.0667E-7,-4.0333E-7,-3.6467E-6,3.8833E-6,1.85E-6,1.87E-6,6.09E-6,-3.4333E-7,-1.4067E-6,4.22E-6,-4.36E-6,-3.0433E-6,3.9667E-7,4.2933E-6,3.01E-6,-4.5333E-7,-1.4333E-6,-2.08E-6,-2.5033E-6,1.1533E-6,-4.9E-7,2.91E-6,1.6167E-6,1.6667E-7,0.0027676,0.0025259,0.0012266,0.0013825,0.0012652,0.0013431,0.0011981,9.0443E-4,9.6608E-4,0.0011018,0.0011868,0.0010982,8.7614E-4,9.1731E-4,0.0010902,0.0011737,0.001089,8.7463E-4,9.1533E-4,0.0010875,0.0011733,0.0010883,8.7387E-4,9.1568E-4,0.0010868,0.0011718,0.001085,8.7016E-4,9.1545E-4,0.0010894,0.0011736,0.0010818,8.6953E-4,9.1573E-4,0.0010919,0.0011712,0.0010802,8.6514E-4,9.1887E-4,0.0010929,0.0011693,0.00108,8.6574E-4,9.1799E-4,0.0010922,0.0011686,0.0010756,8.6828E-4,9.1903E-4,0.0010923,0.0011675,0.0010755,8.666E-4,9.1872E-4,0.0010955,0.0011705,0.0010728,8.6321E-4,9.2104E-4,0.0010923,0.0011701,0.001069,8.6748E-4,9.1867E-4,0.0010959,0.0011729,0.0010702,8.6349E-4,9.2193E-4,0.0010963,0.0011695,0.0010704,8.6567E-4,9.2177E-4,0.0010964,0.0011692,0.0010681,8.6284E-4,9.2117E-4,0.0011002,0.001167,0.0010683,8.6394E-4,9.2542E-4,0.0011028,0.0011705,0.0010646,8.6187E-4,9.2653E-4,0.0011008,0.0011714,0.0010661,8.6122E-4,9.2406E-4,0.0011016,0.0011736,0.0010662,8.6206E-4,9.2627E-4,0.0011046,0.0011696,0.00106,8.5996E-4,9.2622E-4,0.0011053,0.0011686,0.0010631,8.5836E-4,9.2707E-4,0.0011073,0.0011687,0.0010633,8.6075E-4,9.3011E-4,0.0011067,0.0011683,0.0010589,8.5897E-4,9.2963E-4,0.0011107,0.0011707,0.0010583,8.6184E-4,9.3129E-4,0.0011088,0.0011683,0.001057,8.5804E-4,9.3147E-4,0.0011091,0.0011709,0.0010579,8.578E-4,9.3167E-4,0.0011102,0.001165,0.0010584,8.5762E-4,9.3463E-4,0.001112,0.0011701,0.0010546,8.5934E-4,9.3484E-4,0.0011139,0.0011714,0.0010534,8.5797E-4,9.334E-4,0.0011138,0.0011654,0.0010514,8.5764E-4,9.3556E-4,0.0011167,0.0011682,0.0010481,8.5495E-4,9.3535E-4,0.001116,0.001172,0.0010486,8.5421E-4,9.4067E-4,0.0011181,0.0011687,0.0010465,8.5828E-4,9.3956E-4,0.0011167,0.0011655,0.0010457,8.5881E-4,9.4006E-4,0.0011174,0.0011686,0.001046,8.5503E-4,9.4259E-4,0.0011184,0.001167,0.0010442,8.5265E-4,9.4319E-4,0.0011225,0.0011699,0.0010438,8.5117E-4,9.4387E-4,0.0011212,0.0011664,0.0010396,8.5352E-4,9.4766E-4,0.0011222,0.0011678,0.0010403,8.5477E-4,9.4571E-4,0.001124,0.0011664,0.0010404,8.5328E-4,9.4822E-4,0.0011218,0.0011666,0.001036,8.5309E-4,9.466E-4,0.0011283,0.0011676,0.0010356,8.5211E-4,9.509E-4,0.0011269,0.0011675,0.0010328,8.529E-4,9.5241E-4,0.0011295,0.0011676,0.0010339,8.5166E-4,9.5224E-4,0.0011268,0.001167,0.001032,8.5489E-4,9.5344E-4,0.0011313,0.0011623,0.0010321,8.4972E-4,9.5531E-4,0.0011307,0.001167,0.0010274,8.4712E-4,9.5534E-4,0.0011297,0.0011665,0.0010285,8.5034E-4,9.5822E-4,0.0011336,0.0011652,0.0010257,8.4704E-4,9.5952E-4,0.0011353,0.0011647,0.0010253,8.4945E-4,9.6153E-4,0.0011372,0.001165,0.0010203,8.4823E-4,9.599E-4,0.0011335,0.0011619,0.0010215,8.4856E-4,9.5973E-4,0.0011346,0.0011596,0.0010201,8.494E-4,9.6401E-4,0.0011376,0.0011601,0.0010201,8.4653E-4,9.6503E-4,0.0011386,0.001161,0.0010174,8.5048E-4,9.67E-4,0.0011403,0.0011621,0.0010143,8.4885E-4,9.6497E-4,0.0011424,0.0011595,0.0010145,8.5131E-4,9.6814E-4,0.0011422,0.0011605,0.0010138,8.4892E-4,9.6766E-4,0.0011422,0.0011555,0.0010107,8.4956E-4,9.7039E-4,0.0011424,0.0011605,0.0010124,8.456E-4,9.7113E-4,0.0011433,0.0011589,0.0010063,8.4595E-4,9.7594E-4,0.0011429,0.0011601,0.0010046,8.4742E-4,9.716E-4,0.0011471,0.0011546,0.0010059,8.4744E-4,9.7527E-4,0.0011449,0.0011556,0.0010047,8.4537E-4,9.7752E-4,0.0011479,0.0011573,0.0010023,8.4906E-4,9.7653E-4,0.0011455,0.0011591,9.9919E-4,8.4852E-4,9.7644E-4,0.001151,0.0011547,0.0010011,8.4742E-4,9.7655E-4,0.0011493,0.001156,9.995E-4,8.4798E-4,9.7963E-4,0.0011485,0.0011526,9.978E-4,8.4604E-4,9.834E-4,7.2897E-4:6
0.014204,-0.033243,0.034099,-0.027734,0.0083994,0.012318,-0.040785,0.041001,-0.027734,0.0096506,0.0093683,-0.033359,0.031751,-0.02781,0.006778,0.010817,-0.03589,0.03403,-0.025398,0.010796,0.013875,-0.034409,0.033948,-0.022175,0.0089308,0.0079814,-0.034963,0.035824,-0.023948,0.01584,0.012918,-0.030448,0.034152,-0.024011,0.018569,0.011719,-0.033028,0.043971,-0.030603,0.0034891,8.688E-4,-0.035975,0.036784,-0.026533,0.0062843,0.018396,-0.035825,0.037539,-0.028265,0.0088431,0.015798,-0.033902,0.033132,-0.032557,0.0080295,0.008126,-0.037043,0.038729,-0.0302,0.014822,0.011322,-0.04206,0.026991,-0.026406,0.018835,0.011376,-0.033541,0.03202,-0.027149,0.012848,0.016227,-0.033404,0.042148,-0.0204,0.015663,0.019251,-0.032783,0.03335,-0.021036,0.0069971,0.0069663,-0.040961,0.034957,-0.018674,0.013587,15.113,11.84,6.0044,8.0037,7.22,6.5066,5.3935,4.5806,5.5436,6.1573,5.8425,4.8033,4.5129,5.2587,6.0363,5.7903,4.7394,4.5133,5.2272,6.0204,5.7719,4.7149,4.506,5.2126,6.0258,5.7736,4.7175,4.4987,5.212,6.0206,5.7948,4.7259,4.5115,5.2277,6.0423,5.796,4.7364,4.5131,5.223,6.0325,5.7939,4.7311,4.5112,5.241,6.0268,5.8042,4.7324,4.5053,5.2263,6.0148,5.7864,4.725,4.5059,5.2199,6.0228,5.7965,4.7376,4.5217,5.2269,6.0187,5.8021,4.724,4.5222,5.2308,6.0503,5.8063,4.7342,4.5217,5.2346,6.0362,5.8059,4.7359,4.5225,5.2328,6.0465,5.8087,4.7269,4.5291,5.2322,6.0517,5.799,4.7346,4.5182,5.2206,6.0442,5.8086,4.7294,4.518,5.2372,6.0386,5.8031,4.7353,4.5198,5.218,6.0362,5.8047,4.7371,4.5187,5.2222,6.0308,5.7932,4.7321,4.5262,5.2216,6.0407,5.8142,4.7311,4.5161,5.2255,6.0369,5.8084,4.7379,4.515,5.2227,6.0381,5.8069,4.739,4.5165,5.2234,6.028,5.8008,4.734,4.5092,5.2275,6.0331,5.8178,4.7339,4.5164,5.2316,6.0281,5.8166,4.7411,4.5134,5.2264,6.0292,5.8071,4.7296,4.5166,5.2169,6.0334,5.809,4.7288,4.5098,5.2191,6.0307,5.7979,4.7364,4.517,5.2125,6.0294,5.799,4.7258,4.505,5.2063,6.0186,5.8012,4.7256,4.5035,5.2146,6.0289,5.7999,4.7288,4.5097,5.2116,6.0174,5.7971,4.7248,4.4981,5.2112,6.018,5.8002,4.7249,4.5011,5.2178,6.0128,5.7947,4.7301,4.5067,5.2083,6.0106,5.8131,4.7301,4.5116,5.2148,6.0228,5.8049,4.7331,4.5144,5.2109,6.0241,5.8022,4.7286,4.505,5.2066,6.0217,5.7973,4.7258,4.5049,5.2001,6.021,5.8013,4.7297,4.5007,5.2023,6.0149,5.8021,4.731,4.5044,5.199,6.0155,5.8081,4.7306,4.51,5.2017,6.0123,5.8,4.7297,4.5038,5.2041,6.0144,5.8025,4.7359,4.5067,5.2087,6.0204,5.8129,4.7281,4.508,5.1941,6.0135,5.813,4.7378,4.5044,5.2037,6.0183,5.8088,4.7359,4.5066,5.1976,6.0249,5.8104,4.7413,4.5054,5.1969,6.0246,5.8072,4.7391,4.5039,5.2009,6.0248,5.8118,4.7412,4.5017,5.2073,6.0187,5.8136,4.7434,4.502,5.2014,6.0185,5.8228,4.7337,4.5064,5.1975,6.0032,5.8096,4.7364,4.5009,5.1926,6.0062,5.8247,4.7351,4.5078,5.1936,6.0218,5.8223,4.7417,4.5096,5.1895,6.0328,5.8219,4.7441,4.5117,5.1903,6.0255,5.8179,4.7442,4.5059,5.1969,6.0219,5.8129,4.7475,4.506,5.1913,6.0175,5.8132,4.7511,4.5071,5.1983,6.0203,5.8181,4.7479,4.5033,5.1983,6.0134,5.8188,4.7482,4.501,5.1893,6.0168,5.824,4.748,4.5052,5.1947,6.0201,5.8224,4.7442,4.5085,5.1865,6.0145,5.8206,4.7395,4.5053,5.187,6.0167,5.8103,4.7397,4.4996,5.1897,6.011,5.8218,4.7448,4.4943,5.19,6.0101,5.8191,4.752,4.4976,5.1888,6.0092,5.8191,4.7436,4.4989,5.1826,6.0137,5.8222,4.7404,4.4967,5.1799,5.9985,5.8154,4.7454,4.4965,5.1735,6.0083,5.822,4.7443,4.4942,5.1801,6.0079,5.8213,4.7487,4.4934,5.1703,6.0111,0.0:6
0.032956,-0.028465,0.017926,0.011665,-0.030092,0.029038,-0.022065,0.013802,0.012084,-0.028903,0.031299,-0.023495,0.0095301,0.0081595,-0.030652,0.028106,-0.013255,0.012356,0.013425,-0.028214,0.033665,-0.01964,0.011871,0.0067159,-0.025614,0.027387,-0.016166,0.014198,0.010506,-0.031124,0.034532,-0.014213,0.0046624,0.0082787,-0.028989,0.021978,-0.018306,0.016517,0.010693,-0.027029,0.030357,-0.02109,0.0069563,0.011795,-0.02604,0.02815,-0.028127,0.015111,0.0070206,-0.027771,0.032456,-0.015684,0.017003,0.0072598,-0.028954,0.028159,-0.021495,0.0083784,0.0072906,-0.030259,0.032835,-0.020232,0.0059588,0.0089145,-0.033491,0.032545,-0.021328,0.0072449,0.017491,-0.028495,0.030787,-0.02577,0.0033889,0.012876,-0.034604,0.030633,-0.016998,0.018095,0.010695,-0.032414,0.030001,-0.022469,0.0073012,0.0078498,-0.032931,16.077,12.036,8.7832,7.2771,5.9967,4.7514,5.9187,6.3343,5.9089,4.8573,4.5365,5.342,6.0771,5.7644,4.7137,4.5299,5.2711,6.0597,5.7466,4.6958,4.5097,5.2493,6.055,5.7606,4.6988,4.5089,5.2556,6.0412,5.7335,4.6871,4.501,5.2295,6.0138,5.7285,4.6857,4.4983,5.2308,6.019,5.7557,4.7004,4.5072,5.2395,6.0187,5.7604,4.6994,4.5063,5.2339,6.0172,5.7519,4.6961,4.5054,5.2383,6.0219,5.76,4.701,4.5027,5.216,6.0148,5.7555,4.7012,4.4962,5.2174,6.0169,5.761,4.702,4.4936,5.2149,6.0151,5.7558,4.6959,4.4968,5.2122,6.0064,5.763,4.704,4.4912,5.1971,5.9979,5.7576,4.6974,4.4872,5.1961,6.0024,5.7569,4.6984,4.4815,5.1829,5.9916,5.7527,4.6959,4.4807,5.1832,5.9917,5.7654,4.7074,4.4864,5.1857,5.9979,5.7692,4.7107,4.4815,5.1773,6.0002,5.7665,4.6992,4.4752,5.1729,5.9868,5.7668,4.7066,4.4765,5.1719,5.9923,5.7636,4.7081,4.4754,5.1689,5.9816,5.7645,4.7156,4.4661,5.1719,5.9781,5.7703,4.7208,4.4675,5.167,5.9738,5.7696,4.7168,4.4683,5.1619,5.981,5.7801,4.7107,4.4668,5.1579,5.9807,5.784,4.7195,4.4658,5.1476,5.9728,5.7812,4.7224,4.4689,5.1473,5.9797,5.7834,4.7262,4.4699,5.1446,5.9856,5.786,4.7327,4.466,5.1501,5.9743,5.7864,4.7334,4.4681,5.1387,5.9725,5.788,4.7389,4.4618,5.1454,5.9702,5.7902,4.7377,4.4623,5.1447,5.9704,5.7978,4.7412,4.4581,5.1345,5.965,5.7888,4.7385,4.4649,5.1275,5.9717,5.7997,4.744,4.4543,5.1268,5.9757,5.7845,4.747,4.4518,5.1245,5.9667,5.7932,4.7526,4.4562,5.1201,5.9657,5.7967,4.7494,4.4478,5.1203,5.9613,5.7953,4.7551,4.4527,5.1209,5.9631,5.8029,4.7533,4.452,5.1258,5.9594,5.8043,4.7551,4.4502,5.1158,5.9617,5.8038,4.7621,4.4561,5.1154,5.9608,5.8022,4.7598,4.4544,5.11,5.9591,5.8093,4.7603,4.4489,5.1106,5.9601,5.8055,4.7614,4.4533,5.106,5.9563,5.8108,4.7691,4.4537,5.1058,5.9551,5.8134,4.7729,4.4484,5.1059,5.9471,5.8233,4.7864,4.4499,5.0993,5.9492,5.8193,4.7736,4.4519,5.0991,5.9475,5.827,4.7737,4.449,5.098,5.9556,5.8241,4.7804,4.4413,5.0914,5.9524,5.8311,4.7813,4.4475,5.0852,5.9569,5.8202,4.7818,4.4474,5.0816,5.9534,5.8172,4.7949,4.442,5.0823,5.9426,5.8318,4.7937,4.4404,5.0788,5.9458,5.8242,4.7907,4.436,5.0747,5.9358,5.8354,4.7844,4.4402,5.069,5.9389,5.835,4.7939,4.4425,5.073,5.9408,5.8318,4.7965,4.443,5.072,5.9444,5.8363,4.7993,4.4434,5.0713,5.9452,5.8295,4.8056,4.4442,5.0697,5.9413,5.8387,4.8132,4.4389,5.0675,5.9431,5.8333,4.8099,4.436,5.0615,5.9369,5.835,4.81,4.4301,5.0577,5.9356,5.8422,4.8165,4.4388,5.0642,5.9418,5.8441,4.8155,4.4395,5.0583,5.9382,5.8474,4.8209,4.4343,5.0516,5.9366,5.8476,4.8167,4.4373,5.0457,5.9417,5.8488,4.8227,4.4456,5.0556,5.9375,5.8563,4.8191,4.4287,5.0484,5.9351,5.8543,4.8253,0.0:6
0.0010147,2.1441E-4,-0.0028385,0.002889,-0.001228,0.0019181,-0.0010548,-0.0025382,0.0023971,-0.0024394,5.034E-5,0.001927,-0.0017371,0.0014302,-0.0011663,0.0014391,0.0014209,-0.0017973,0.0017687,-0.0022454,0.0016806,-8.5387E-5,-0.001696,0.0015755,-0.0027887,0.0011487,-2.1369E-4,-0.0030289,0.002142,-0.002226,-4.95E-5,0.0015623,4.0376,4.408,3.313,3.0904,2.5627,1.9466,1.8598,2.1285,2.3414,2.1755,1.7876,1.7285,2.0586,2.2889,2.1485,1.7743,1.709,2.0464,2.28,2.145,1.7732,1.7014,2.0348,2.2715,2.1439,1.7721,1.6951,2.0317,2.2702,2.1479,1.774,1.695,2.0255,2.2664,2.1476,1.7736,1.6914,2.0204,2.2612,2.1478,1.7749,1.6871,2.0142,2.2579,2.1485,1.7759,1.6867,2.0086,2.2591,2.1509,1.7771,1.6845,2.0052,2.2563,2.1557,1.7803,1.682,2.0048,2.2568,2.1609,1.7856,1.6824,2.0009,2.254,2.1641,1.7895,1.6811,1.9989,2.2552,2.1632,1.7893,1.6805,1.9937,2.2534,2.1733,1.794,1.6751,1.9935,2.2509,2.174,1.7961,1.6773,1.988,2.249,2.1787,1.8003,1.6737,1.9858,2.2503,2.1831,1.8008,1.6743,1.9797,2.2485,2.1818,1.8013,1.6683,1.9755,2.2403,2.1844,1.8044,1.6697,1.9731,2.2428,2.1874,1.8092,1.6669,1.9695,2.2437,2.1872,1.8085,1.6654,1.9649,2.2368,2.1895,1.8129,1.6613,1.9584,2.234,2.1875,1.8132,1.6633,1.9569,2.2351,2.1922,1.8162,1.659,1.9548,2.228,2.1934,1.8179,1.6589,1.9487,2.2273,2.1962,1.8201,1.6575,1.9447,2.2228,2.1965,1.8222,1.6556,1.9402,2.22,2.1959,1.8226,1.6527,1.9357,2.2192,2.197,1.8248,1.6535,1.9329,2.2182,2.1987,1.8292,1.6528,1.929,2.2178,2.2032,1.8315,1.6512,1.9257,2.2152,2.2018,1.8274,1.6428,1.9143,2.2037,2.1958,1.8299,1.6441,1.9097,2.2004,2.1973,1.8338,1.6407,1.9111,2.2047,2.207,1.8432,1.6471,1.9123,2.2063,2.2072,1.8444,1.6438,1.9092,2.2021,2.2092,1.8514,1.6456,1.9081,2.2023,2.2146,1.8511,1.6435,1.9029,2.2024,2.2175,1.8558,1.6458,1.9005,2.1988,2.22,1.8567,1.6481,1.8976,2.1986,2.2192,1.8615,1.6462,1.892,2.1953,2.2236,1.8651,1.645,1.8899,2.1939,2.2206,1.8699,1.6454,1.8873,2.1896,2.2254,1.8733,1.6441,1.8837,2.1917,2.2252,1.877,1.6442,1.8792,2.1884,2.2291,1.8794,1.6456,1.8799,2.1871,2.2262,1.8852,1.6446,1.875,2.1832,2.2334,1.8876,1.6452,1.8732,2.1824,2.2335,1.8907,1.6442,1.8686,2.18,2.2352,1.8939,1.6414,1.8643,2.1806,2.2345,1.8955,1.6439,1.8634,2.1737,2.2369,1.898,1.6432,1.8575,2.1744,2.2346,1.9021,1.6447,1.8567,2.1715,2.2371,1.9022,1.6437,1.8531,2.1701,2.2354,1.9082,1.6458,1.8507,2.1692,2.2399,1.9116,1.6438,1.8491,2.1679,2.242,1.9148,1.6447,1.8471,2.1627,2.2417,1.9181,1.6438,1.8437,2.1625,2.242,1.9215,1.6446,1.8403,2.158,2.2445,1.9234,1.6436,1.8394,2.1582,2.2443,1.9231,1.6443,1.8355,2.1532,2.2453,1.9276,1.6465,1.834,2.1535,2.246,1.93,1.6461,1.8292,2.1513,2.2493,1.9337,1.6448,1.8272,2.1494,2.2459,1.9366,1.6481,1.8268,2.1466,2.2463,1.9393,1.6458,1.8224,2.1445,2.2461,1.9428,1.6487,1.8188,2.1435,2.2467,1.9447,1.6485,1.8166,2.1428,2.2467,1.9485,1.6488,1.8126,2.1366,2.2492,1.9517,1.6459,1.8114,2.1372,2.2483,1.9542,1.6502,1.8085,2.1336,2.2496,1.9581,1.6482,1.8074,2.132,2.2493,1.9588,1.6499,1.8042,2.1318,2.2557,1.9656,1.6539,1.8038,2.1305,2.2529,1.9696,1.6546,1.8005,2.1283,2.2556,1.9745,1.6552,1.7979,2.1262,2.2551,1.977,1.657,1.7967,2.1262,2.2558,1.9813,1.6556,1.7943,2.123,2.2539,1.9846,1.6585,1.7916,2.1215,2.2554,1.9879,1.6552,1.7899,0.0:6
0.0037073,-0.0029181,9.157E-5,0.0028963,-0.0044514,0.0035698,-0.0023381,-5.5819E-4,0.0018864,-0.0046201,0.002138,-0.0023827,3.0783E-4,0.0025087,-0.0028227,0.0033021,-0.0032081,8.8688E-4,0.0015428,-0.0032653,0.0040409,-0.0026925,2.3926E-4,0.0019521,-0.0040948,0.0024819,-0.00238,0.0011695,9.7787E-4,-0.0031872,0.0023573,-0.0019418,-2.9742E-4,6.0549E-4,-0.0042665,0.0028127,5.7696,4.5459,3.2108,2.1404,1.9971,2.0461,2.3088,2.1921,1.757,1.6227,1.8716,2.1351,2.0843,1.7202,1.5793,1.8536,2.1095,2.0738,1.7139,1.5681,1.8466,2.1045,2.0694,1.7165,1.5697,1.8439,2.103,2.0724,1.7165,1.5684,1.8441,2.1033,2.0734,1.7201,1.567,1.8431,2.1038,2.0762,1.7177,1.5666,1.841,2.1027,2.0771,1.7225,1.5677,1.8376,2.1023,2.0802,1.7223,1.5685,1.8382,2.1019,2.0768,1.7229,1.566,1.8369,2.1028,2.0826,1.7257,1.5666,1.8359,2.1026,2.0791,1.729,1.567,1.8348,2.1013,2.0815,1.7291,1.5664,1.8345,2.1021,2.0793,1.7304,1.5654,1.8325,2.1,2.0834,1.7311,1.5659,1.8315,2.1017,2.0827,1.7336,1.5648,1.8292,2.0974,2.087,1.7351,1.5651,1.8297,2.0978,2.0875,1.7367,1.5652,1.8272,2.0964,2.0891,1.7382,1.5676,1.8253,2.0958,2.089,1.7398,1.5659,1.8231,2.0965,2.0924,1.7398,1.5632,1.8223,2.0959,2.092,1.7403,1.564,1.8177,2.0944,2.0935,1.7422,1.5649,1.8192,2.0957,2.0937,1.7455,1.5641,1.8161,2.095,2.0959,1.7452,1.5635,1.8175,2.0942,2.0936,1.7497,1.5631,1.816,2.0933,2.0948,1.7505,1.563,1.8153,2.0929,2.0986,1.752,1.563,1.8137,2.0897,2.0984,1.7518,1.5619,1.8136,2.0898,2.099,1.7545,1.5643,1.8109,2.0905,2.1016,1.7551,1.5616,1.8099,2.0894,2.1042,1.7564,1.5629,1.8063,2.091,2.104,1.7564,1.5625,1.8067,2.0896,2.1041,1.758,1.5608,1.8037,2.0894,2.1028,1.7588,1.5596,1.8066,2.089,2.1051,1.7638,1.5637,1.8021,2.0882,2.1057,1.7648,1.5613,1.8037,2.0872,2.1037,1.7657,1.5623,1.8011,2.0859,2.1076,1.7679,1.5614,1.8008,2.0864,2.1094,1.7679,1.5621,1.7964,2.0827,2.1101,1.7676,1.5609,1.7984,2.0825,2.1099,1.77,1.5621,1.7942,2.0822,2.1102,1.7711,1.562,1.7927,2.0792,2.1131,1.7747,1.562,1.7889,2.0805,2.1129,1.7759,1.5612,1.7898,2.0805,2.1122,1.7791,1.5613,1.7867,2.0786,2.1158,1.7811,1.5595,1.7865,2.0784,2.1128,1.7833,1.5619,1.7851,2.0777,2.1164,1.7861,1.5595,1.7853,2.076,2.1179,1.7875,1.5622,1.7837,2.075,2.119,1.7873,1.5596,1.7825,2.0732,2.1177,1.791,1.5614,1.7795,2.0735,2.1201,1.791,1.5612,1.781,2.074,2.1209,1.7919,1.5607,1.7783,2.071,2.1215,1.7933,1.5625,1.7784,2.0719,2.1214,1.798,1.5628,1.7759,2.0712,2.1235,1.7978,1.5604,1.7738,2.0703,2.1228,1.8008,1.5634,1.7742,2.0694,2.1238,1.8012,1.5589,1.7722,2.0702,2.1252,1.8072,1.5635,1.7721,2.0669,2.1295,1.805,1.563,1.7678,2.064,2.1262,1.8065,1.5612,1.7676,2.0647,2.1293,1.8047,1.562,1.7656,2.0626,2.1271,1.8091,1.5619,1.7648,2.0577,2.1291,1.8055,1.5597,1.7631,2.0638,2.1278,1.8125,1.5641,1.7631,2.0601,2.1299,1.8113,1.5627,1.7607,2.061,2.1289,1.8155,1.5629,1.7596,2.0583,2.1308,1.8165,1.563,1.7598,2.0605,2.1294,1.8216,1.5654,1.7589,2.059,2.132,1.8207,1.5626,1.7612,2.0622,2.1331,1.8224,1.5647,1.7576,2.0571,2.1336,1.8244,1.5647,1.7577,2.0571,2.136,1.8244,1.5635,1.7557,2.0567,2.1355,1.8263,1.5647,1.7549,2.0574,2.134,1.8285,0.0:6
0.0013181,-0.003177,0.0045288,-0.0026134,0.001119,4.5065E-4,0.96497,1.6078,1.7167,2.0295,2.1829,1.9433,1.6107,1.7162,2.03,2.185,1.9457,1.6123,1.7127,2.0313,2.1864,1.9454,1.6112,1.7146,2.0298,2.1831,1.9455,1.6107,1.7133,2.0313,2.1845,1.9468,1.6123,1.7146,2.0271,2.182,1.9502,1.6132,1.7111,2.0283,2.1826,1.9495,1.6112,1.7119,2.0273,2.184,1.9508,1.6124,1.7109,2.0279,2.1838,1.9525,1.6115,1.7119,2.0271,2.1859,1.9544,1.6128,1.7096,2.0257,2.1849,1.9538,1.6133,1.7123,2.0232,2.186,1.9555,1.6145,1.7088,2.0251,2.1866,1.9568,1.6141,1.7094,2.0237,2.1872,1.9563,1.614,1.7063,2.0235,2.1855,1.9543,1.614,1.706,2.0231,2.1841,1.9577,1.6177,1.7053,2.0225,2.1855,1.9591,1.6161,1.7063,2.0235,2.1856,1.9612,1.6159,1.7058,2.0214,2.1837,1.9599,1.6156,1.7059,2.0213,2.1827,1.9614,1.6149,1.7025,2.019,2.1834,1.9621,1.6161,1.708,2.0186,2.1852,1.9638,1.6191,1.7033,2.0212,2.1878,1.9627,1.6151,1.7054,2.0191,2.1868,1.9638,1.6185,1.7021,2.0168,2.1887,1.9649,1.6183,1.7032,2.0159,2.1856,1.9659,1.6173,1.6987,2.0172,2.1867,1.9677,1.6207,1.7031,2.0187,2.1867,1.971,1.6188,1.6995,2.0177,2.1848,1.9671,1.6188,1.6998,2.0148,2.1825,1.9726,1.6212,1.6966,2.0142,2.1858,1.9727,1.6174,1.6976,2.0139,2.185,1.974,1.6194,1.6965,2.012,2.1866,1.9744,1.6207,1.699,2.007,2.1861,1.9758,1.6198,1.6957,2.0097,2.1855,1.9733,1.6189,1.6955,2.0066,2.1832,1.9754,1.6235,1.6924,2.0077,2.1861,1.974,1.622,1.6918,2.0075,2.1813,1.9765,1.6233,1.6888,2.0065,2.1849,1.9756,1.6225,1.6908,2.0066,2.1829,1.98,1.6229,1.6881,2.0047,2.1822,1.9809,1.6251,1.6897,2.0042,2.1841,1.9835,1.6239,1.6903,2.0047,2.1854,1.9831,1.6248,1.6905,2.0045,2.1843,1.9866,1.6262,1.6898,2.0015,2.186,1.984,1.6261,1.69,2.0029,2.1848,1.9867,1.626,1.6904,2.0003,2.1854,1.9877,1.6281,1.6895,2.0005,2.1842,1.9878,1.6274,1.6876,1.9993,2.1868,1.9872,1.6309,1.6882,2.0001,2.1842,1.9905,1.6301,1.6858,1.9982,2.1871,1.9888,1.6307,1.6865,1.9994,2.1842,1.9929,1.6278,1.6856,1.9938,2.1852,1.9934,1.629,1.6864,1.995,2.1859,1.9947,1.6282,1.6846,1.9973,2.1868,1.9964,1.6324,1.6851,1.9955,2.1851,1.9957,1.6327,1.6844,1.9933,2.1866,1.9949,1.631,1.6833,1.9942,2.1843,1.9985,1.6329,1.6812,1.9917,2.1875,1.9995,1.6349,1.6826,1.9938,2.1876,2.0004,1.6351,1.6821,1.9913,2.1874,2.0011,1.6367,1.6831,1.9919,2.186,2.0026,1.6365,1.6818,1.9932,2.1878,2.0065,1.6385,1.6833,1.9932,2.1871,2.0099,1.6381,1.6831,1.9945,2.192,2.0115,1.6409,1.6845,1.9926,2.1902,2.0128,1.6407,1.6848,1.9933,2.1926,2.012,1.6418,1.6858,1.9934,2.1921,0.98319:6
-0.01422,0.010927,-0.0012987,-0.008967,0.017907,-0.017981,0.026491,-6.8093E-4,-0.0084264,0.021153,-0.016207,0.021233,0.0030609,-0.016625,0.019987,-0.018572,0.018897,0.0067222,-0.013619,0.022091,-0.019551,0.017792,-0.0035278,-0.0090039,0.020472,-0.020867,0.0175,-0.0073136,-0.0053771,0.021155,-0.016275,0.0089596,-3.9083E-4,-0.0056368,0.022318,-0.019939,0.01973,-0.0039233,-0.0076963,0.02267,-0.02219,0.013189,0.0035918,-0.0082099,0.01641,-0.023402,0.018248,-0.0034343,-0.00906,0.018766,-0.015923,0.014116,-6.3853E-4,-0.010546,0.0183,-0.016543,0.013812,-0.0063682,-0.00479,0.01674,-0.019109,0.010787,0.0012355,-0.015598,0.021159,-0.019402,0.013115,-0.0017807,-0.016047,0.021064,-0.019716,0.014466,-0.0024542,-0.0065458,0.018892,-0.021204,0.020105,-6.9867E-5,-0.010327,0.021802,-0.020368,0.0095771,6.7674E-4,-0.0086308,0.019734,-0.022406,0.018745,0.0018292,-0.0060694,0.021459,-0.017309,0.016878,-0.0034876,-0.0055694,0.025732,-0.025377,0.01833,-7.2834E-4,-0.0084305,0.023603,-0.019254,0.016268,-4.8886E-4,-0.010713,0.022981,-0.019497,0.022497,3.5954E-4,-0.0056894,0.021504,-0.020762,0.017366,-0.003122,-0.011048,0.018582,-0.019221,0.019508,-3.5773E-4,-0.011037,0.016625,-0.017333,6.5834,10.125,5.9791,4.3969,3.4753,4.122,4.2639,3.8426,3.1725,2.9597,3.5636,3.909,3.6575,3.055,2.8968,3.5091,3.877,3.6493,3.045,2.9012,3.4972,3.8809,3.6555,3.0394,2.8985,3.4987,3.8799,3.6577,3.0463,2.8983,3.4988,3.8878,3.6588,3.0495,2.8993,3.4951,3.8845,3.6662,3.0512,2.9035,3.4951,3.8883,3.6732,3.0494,2.9032,3.4884,3.8882,3.6753,3.054,2.9031,3.4904,3.8821,3.6756,3.0532,2.9037,3.4909,3.8935,3.6823,3.0568,2.9042,3.4855,3.895,3.6821,3.0569,2.9006,3.4881,3.8996,3.6824,3.0612,2.9003,3.4887,3.8919,3.6849,3.0604,2.9007,3.4877,3.8937,3.6906,3.0594,2.9002,3.4835,3.889,3.6961,3.0619,2.8994,3.4857,3.8811,3.7,3.0573,2.9015,3.4796,3.8926,3.6959,3.0676,2.8968,3.4756,3.9038,3.7023,3.0657,2.9042,3.4776,3.8989,3.697,3.0755,2.9021,3.4755,3.8911,3.7041,3.072,2.903,3.4798,3.8966,3.7056,3.0734,2.8998,3.4742,3.8967,3.7065,3.0704,2.9023,3.4724,3.8947,3.7115,3.0804,2.8995,3.4714,3.8919,3.7129,3.0814,2.8923,3.4724,3.8937,3.7173,3.0767,2.9033,3.4708,3.8884,3.7202,3.0838,2.8968,3.4643,3.8911,3.7168,3.0817,2.8996,3.4695,3.8916,3.7227,3.0808,2.895,3.4639,3.8975,3.7197,3.0895,2.8993,3.4592,3.8887,3.7273,3.0808,2.8982,3.4612,3.8878,3.726,3.0889,2.8972,3.4587,3.8879,3.7352,3.087,2.8911,3.4584,3.8916,3.7269,3.0887,2.8886,3.4675,3.8921,3.7318,3.0931,2.8945,3.4547,3.8868,3.737,3.0916,2.8979,3.4577,3.886,3.7404,3.0958,2.8937,3.4486,3.8901,3.7331,3.094,2.8984,3.4533,3.8933,3.7359,3.1022,2.8965,3.4495,3.8913,3.7392,3.1033,2.8956,3.4519,3.887,3.743,3.0998,2.8973,3.4489,3.8867,3.7436,3.1048,2.8902,3.4488,3.8891,3.7465,3.0981,2.8912,3.4477,3.8867,3.7437,3.1073,2.8893,3.4518,3.8949,3.7465,3.1103,2.897,3.4408,3.8867,3.7495,3.1057,2.8879,3.4448,3.8898,3.747,3.1014,2.894,3.4386,3.8887,3.7541,3.1073,2.8872,3.4416,3.8818,3.7553,3.1097,2.889,3.4555,3.8855,3.7531,3.1092,2.8869,3.4357,3.8811,3.7561,3.1129,2.8888,3.4407,3.8862,3.7534,3.1157,2.887,3.4379,3.8866,3.7609,3.1177,2.892,3.4342,3.8871,3.7577,3.1204,2.8895,3.4352,3.8849,3.7617,3.1178,2.884,3.4333,3.8844,3.7633,3.1213,2.8875,3.4325,3.8875,3.7658,3.1227,2.8858,3.4306,3.8838,3.7705,3.1253,2.887,3.4394,3.8904,3.7704,3.1259,2.8832,3.4312,3.8857,3.7719,3.1267,2.8857,3.4315,3.8841,3.7702,3.1261,2.887,3.4293,3.8848,3.7736,3.1311,2.8843,3.4322,3.8848,3.7722,3.1319,2.8856,3.4291,3.8889,3.7703,3.1343,2.8854,3.4285,3.8802,3.7785,3.1339,2.8868,3.4203,3.8875,3.7768,3.1281,2.8831,2.8174:6
0.013846,0.0078646,-0.015851,0.015742,-0.015191,0.0047241,0.0093446,-0.013419,0.018231,-0.017798,0.012757,0.0084684,-0.015472,0.020991,-0.016612,0.012517,0.0087899,-0.014138,0.019409,-0.021524,0.0061489,0.0089327,-0.016928,0.028067,-0.018318,0.011756,0.0040722,-0.014655,0.02443,-0.020176,0.0054862,0.0087653,-0.018855,0.01963,-0.02148,0.011567,0.0073512,-0.0097852,0.023904,-0.019226,0.016084,0.0069071,-0.01475,0.020484,-0.024434,0.0088715,0.0017244,-0.015336,0.023577,-0.016021,0.0054253,0.008386,-0.015501,0.019453,-0.020013,0.012626,0.0029519,-0.012296,0.020516,-0.021514,0.016984,0.0027237,-0.013946,0.01859,-0.018338,0.010302,0.0035153,-0.0087104,0.018576,-0.015851,0.010706,0.003964,-0.010766,0.02392,-0.014172,0.010629,0.003625,-0.016364,0.017838,-0.01805,0.006193,0.004282,-0.014393,0.025618,-0.016458,0.0055093,0.0097774,-0.01412,0.018578,-0.012477,0.014323,0.0037382,-0.011416,0.022545,-0.01715,4.6919,11.276,5.2497,4.6511,3.7502,4.5238,4.2847,3.4146,3.0572,3.2522,3.8577,3.9021,3.2813,2.9062,3.2002,3.7899,3.8573,3.2715,2.8876,3.2017,3.7893,3.8589,3.2724,2.8863,3.2038,3.7903,3.8649,3.2751,2.8936,3.1998,3.7859,3.8656,3.2718,2.8885,3.204,3.7834,3.8692,3.2783,2.8879,3.2007,3.7902,3.8735,3.2784,2.892,3.1959,3.7885,3.8763,3.2829,2.8909,3.206,3.7904,3.8834,3.2895,2.8848,3.202,3.7812,3.8863,3.2823,2.8921,3.1996,3.7835,3.8847,3.2851,2.9015,3.203,3.7854,3.8836,3.294,2.8987,3.2007,3.7912,3.8919,3.2935,2.9008,3.1996,3.7906,3.8885,3.2974,2.8967,3.1951,3.7857,3.8854,3.2948,2.8989,3.1951,3.7912,3.8933,3.3041,2.9011,3.1943,3.7855,3.8994,3.2988,2.9003,3.1979,3.7873,3.8983,3.3077,2.9018,3.2016,3.7835,3.9042,3.3035,2.9003,3.1901,3.7942,3.9045,3.2975,2.9005,3.1925,3.7882,3.8992,3.3009,2.9013,3.1852,3.7917,3.9006,3.3106,2.9037,3.1953,3.7877,3.8994,3.3172,2.9018,3.19,3.7901,3.9002,3.3139,2.9022,3.1902,3.7765,3.903,3.3172,2.9021,3.1873,3.7846,3.9001,3.3177,2.9067,3.1906,3.7839,3.9008,3.316,2.9049,3.1882,3.7845,3.9038,3.3196,2.9064,3.187,3.7881,3.9095,3.3191,2.9039,3.1862,3.7865,3.9105,3.3222,2.9057,3.184,3.7905,3.9105,3.3209,2.9027,3.1859,3.7886,3.9134,3.3279,2.9087,3.1837,3.7824,3.9123,3.3249,2.9087,3.1794,3.7813,3.9102,3.3285,2.9063,3.1759,3.7797,3.9086,3.3229,2.9067,3.1764,3.787,3.9134,3.3282,2.9111,3.1791,3.7776,3.9142,3.3373,2.9037,3.1797,3.7801,3.9163,3.3326,2.9086,3.1813,3.7795,3.9204,3.3328,2.9107,3.1763,3.7817,3.9124,3.334,2.9045,3.1768,3.7818,3.9147,3.3389,2.9046,3.1775,3.7873,3.9122,3.3427,2.9039,3.1738,3.7836,3.9146,3.3457,2.9047,3.1757,3.7822,3.9241,3.3465,2.9093,3.1795,3.7753,3.9163,3.3443,2.9129,3.1774,3.7763,3.9271,3.3395,2.9104,3.1753,3.7765,3.9246,3.3439,2.908,3.1721,3.7695,3.9242,3.3426,2.9064,3.1678,3.7754,3.9201,3.3448,2.9116,3.165,3.7766,3.9292,3.347,2.9117,3.1669,3.7836,3.9214,3.3586,2.908,3.17,3.7763,3.9284,3.3575,2.9149,3.1681,3.7734,3.9235,3.3551,2.9136,3.1668,3.7738,3.9271,3.357,2.9107,3.1639,3.7779,3.9267,3.3555,2.9118,3.1621,3.7718,3.9287,3.3587,2.9145,3.1648,3.7696,3.9304,3.3565,2.9147,3.1602,3.7655,3.9304,3.356,2.9138,3.1641,3.7663,3.9314,3.3568,2.9139,3.1616,3.773,3.9324,3.3673,2.9161,3.1572,3.7709,3.9309,3.3616,2.9142,3.155,3.7673,3.9309,3.3665,2.9137,3.1583,3.7718,3.9239,3.3672,2.9147,3.1564,3.772,3.9251,3.3724,2.9125,3.1549,3.7651,3.9274,3.3769,2.9137,3.1578,3.762,3.9356,3.3724,2.9201,3.1586,3.7663,3.9345,3.3701,2.9144,3.1569,3.7638,3.9362,3.3712,0.35515:6
-0.0021072,0.0010768,-0.0023683,0.0015891,0.0020502,-0.0033948,0.0018746,-0.0057754,-7.7379E-4,-0.004665,-8.1674E-4,0.0028688,-0.0036774,1.2171E-4,-9.4023E-4,-0.0042369,0.003485,-0.0046536,0.001293,-0.0010413,-2.5022E-4,0.0013603,-0.0021666,0.0017638,-6.1468E-4,-0.0023238,0.0031319,-0.0039074,-1.8887E-4,-0.0015711,-0.0023927,0.0021383,-0.0025733,4.06E-5,-9.9078E-4,-0.0010866,0.0022712,0.039325,4.7577,3.3749,2.421,1.5365,1.5704,1.3994,1.72,1.6649,1.2996,1.214,1.3159,1.5578,1.5688,1.2699,1.1638,1.305,1.5335,1.5548,1.2634,1.1537,1.3039,1.534,1.5481,1.2614,1.1518,1.3036,1.5324,1.546,1.2627,1.1547,1.3074,1.5336,1.5453,1.2621,1.152,1.31,1.532,1.5467,1.2585,1.151,1.3105,1.534,1.5462,1.2594,1.1507,1.3144,1.5308,1.5457,1.2581,1.1506,1.3126,1.5309,1.5489,1.2562,1.1513,1.3152,1.532,1.5448,1.253,1.1536,1.3172,1.5353,1.5472,1.2525,1.1553,1.3173,1.5327,1.5418,1.2502,1.1535,1.3165,1.5353,1.543,1.2468,1.1551,1.3184,1.5382,1.5404,1.2485,1.1538,1.3202,1.5407,1.5408,1.2496,1.155,1.3209,1.5421,1.5375,1.247,1.1529,1.326,1.5423,1.537,1.2453,1.155,1.3257,1.54,1.5343,1.2456,1.153,1.3269,1.5404,1.5352,1.241,1.1529,1.3271,1.5397,1.5331,1.2379,1.1543,1.3289,1.5408,1.5342,1.2391,1.1558,1.3297,1.5392,1.5327,1.2351,1.1552,1.3292,1.5427,1.5312,1.2353,1.1573,1.3326,1.5444,1.5322,1.2332,1.1584,1.3305,1.5469,1.5291,1.2328,1.1564,1.3323,1.5474,1.5289,1.2304,1.1579,1.3347,1.5492,1.5253,1.2324,1.1588,1.338,1.5489,1.5245,1.2289,1.1583,1.3396,1.5465,1.5253,1.2282,1.1567,1.3439,1.5453,1.5243,1.2277,1.1579,1.3422,1.5461,1.526,1.2256,1.16,1.3445,1.5491,1.5233,1.2237,1.1583,1.3428,1.5441,1.5205,1.2187,1.1591,1.3396,1.5497,1.5183,1.219,1.1605,1.3415,1.5474,1.5175,1.2176,1.1592,1.3403,1.5516,1.5145,1.2163,1.1586,1.346,1.5507,1.5136,1.2171,1.1595,1.3432,1.5507,1.5077,1.217,1.1579,1.3447,1.548,1.5091,1.2151,1.1603,1.3462,1.5481,1.5081,1.2129,1.1588,1.3516,1.5453,1.5084,1.2138,1.161,1.3486,1.5468,1.5066,1.2119,1.1606,1.3502,1.5463,1.506,1.2091,1.1612,1.3497,1.5474,1.5025,1.2064,1.1621,1.3512,1.5507,1.501,1.2093,1.1613,1.3542,1.5491,1.5,1.2057,1.1617,1.3542,1.5506,1.4959,1.2051,1.1622,1.3554,1.5505,1.4988,1.2031,1.1619,1.3563,1.5525,1.4977,1.2039,1.1619,1.3593,1.5514,1.496,1.2022,1.1636,1.3594,1.5501,1.4938,1.201,1.1628,1.3631,1.5516,1.4926,1.2022,1.1639,1.3626,1.5516,1.4928,1.199,1.1648,1.3618,1.5527,1.4879,1.1991,1.165,1.3635,1.5498,1.4895,1.1963,1.1657,1.3649,1.5552,1.4871,1.1957,1.1656,1.3689,1.5546,1.4886,1.1964,1.1684,1.3684,1.5588,1.4867,1.1971,1.1694,1.3703,1.5547,1.4846,1.1941,1.17,1.3724,1.5544,1.4835,1.1952,1.1698,1.3721,1.555,1.4825,1.1921,1.1727,1.3744,1.559,1.4811,1.1925,1.1707,1.3751,1.5578,1.4792,1.1913,1.1711,1.3741,1.558,1.4791,1.1911,1.1724,1.3769,1.5594,1.478,1.1891,1.172,1.3787,1.5577,1.4771,1.1859,1.173,1.3795,1.5566,1.4747,1.1875,1.1736,1.3807,1.5566,1.4742,1.1853,1.1736,1.3802,1.558,1.4713,1.1844,1.1773,1.384,1.5575,1.4722,1.1816,1.1785,1.3863,1.5612,1.4707,1.1822,1.1772,1.3883,1.5579,1.4693,1.1825,1.1778,1.3875,1.5608,1.4695,1.1811,1.1797,1.3884,1.5626,1.467,1.1813,1.1807,1.3897,1.5615,1.4673,1.1824,1.1822,1.3922,1.5637,1.4662,1.1808,1.1833,1.396,1.5616,1.4613,1.1773,1.183,1.3952,1.5651,1.4604,1.1803,1.1832,1.3981,1.5608,1.4604,1.1782,1.1826,1.3971,1.562,1.4588,1.1778,1.183,1.4013,1.5605,1.4587,1.1746,1.1843,0.70172:6
-7.1778E-4,0.0016092,6.7703E-4,-0.0013162,0.0030006,-0.0010065,6.8177E-4,0.002075,-0.0020641,0.003346,-0.0026821,7.1592E-4,0.001594,-0.0023203,0.0040504,-3.1628E-4,5.5717E-4,0.0022438,-0.0019537,0.002621,-0.0022369,0.0013784,0.0038463,-0.0026949,0.0030249,-4.1209E-4,6.1288,2.5485,1.9456,1.517,1.8351,1.7973,1.5114,1.2591,1.2579,1.5068,1.6015,1.4083,1.1789,1.2154,1.4627,1.5697,1.3928,1.165,1.2117,1.4549,1.5671,1.3875,1.163,1.2111,1.4564,1.5657,1.3882,1.1629,1.2138,1.4584,1.5669,1.3889,1.1632,1.2145,1.4597,1.5693,1.3889,1.1631,1.2169,1.4605,1.5715,1.3875,1.164,1.2172,1.4615,1.5722,1.3862,1.1636,1.2176,1.4633,1.5709,1.3851,1.1628,1.2188,1.4592,1.569,1.3834,1.1628,1.2188,1.4615,1.5718,1.3823,1.1638,1.2209,1.462,1.5744,1.3822,1.1624,1.2184,1.4644,1.5721,1.382,1.1602,1.2236,1.4657,1.5754,1.3799,1.1628,1.2215,1.4677,1.5701,1.3801,1.1612,1.2229,1.4658,1.5724,1.3786,1.1637,1.2232,1.4682,1.5755,1.3766,1.1626,1.2246,1.4698,1.5744,1.3768,1.1619,1.2244,1.4715,1.5732,1.3758,1.1618,1.2248,1.4712,1.5742,1.3749,1.1615,1.2258,1.4726,1.5724,1.3715,1.1612,1.2268,1.472,1.5723,1.3729,1.1594,1.2287,1.4721,1.5735,1.3715,1.16,1.2284,1.4728,1.573,1.3723,1.1577,1.2286,1.4738,1.575,1.368,1.1616,1.2282,1.4741,1.5731,1.3643,1.1588,1.2297,1.4734,1.5745,1.3643,1.1602,1.2329,1.4772,1.5755,1.3639,1.1594,1.2309,1.4761,1.5748,1.3629,1.1591,1.2305,1.4765,1.5728,1.3607,1.1584,1.23,1.4794,1.5734,1.3613,1.1564,1.2351,1.4771,1.5732,1.3617,1.1577,1.2325,1.4775,1.5712,1.3597,1.1568,1.2344,1.4759,1.5749,1.357,1.1569,1.2353,1.4801,1.5748,1.3569,1.1558,1.2385,1.4762,1.5761,1.3554,1.1565,1.2376,1.4781,1.5778,1.3522,1.1549,1.2362,1.4789,1.5782,1.3506,1.1564,1.2377,1.4801,1.5758,1.3523,1.1564,1.2386,1.4817,1.5744,1.3501,1.1548,1.2396,1.4854,1.5728,1.3471,1.1574,1.2388,1.4843,1.571,1.3488,1.1545,1.2404,1.4841,1.5706,1.3506,1.1544,1.2398,1.485,1.5712,1.3474,1.1539,1.2447,1.4864,1.5721,1.3454,1.1533,1.2434,1.4828,1.5729,1.3443,1.1522,1.2451,1.4849,1.5757,1.3403,1.153,1.2438,1.4854,1.5754,1.3391,1.1548,1.2453,1.4869,1.5744,1.3372,1.155,1.2461,1.4866,1.5714,1.3369,1.1533,1.2433,1.4927,1.5725,1.3362,1.1531,1.2461,1.4917,1.5714,1.3351,1.1529,1.2458,1.4917,1.5695,1.3352,1.152,1.2484,1.4934,1.5714,1.3354,1.1542,1.252,1.4964,1.5725,1.3325,1.1523,1.2522,1.4944,1.5711,1.3302,1.1543,1.2524,1.4956,1.5748,1.33,1.1535,1.2553,1.4967,1.5758,1.3279,1.154,1.2541,1.4964,1.5739,1.3277,1.1546,1.2539,1.4967,1.5709,1.3244,1.152,1.2551,1.5003,1.5743,1.322,1.1536,1.2534,1.4988,1.5681,1.3228,1.1509,1.2562,1.4988,1.5698,1.3219,1.1525,1.257,1.4986,1.5698,1.3207,1.1489,1.2606,1.4987,1.5705,1.3176,1.1516,1.2606,1.4983,1.5693,1.32,1.1507,1.2602,1.4996,1.5712,1.3166,1.1514,1.2605,1.5012,1.5701,1.3146,1.1498,1.2603,1.501,1.5693,1.3155,1.1498,1.2608,1.5018,1.5692,1.315,1.1502,1.2614,1.5014,1.5693,1.3148,1.151,1.2674,1.5054,1.5687,1.3122,1.1537,1.2653,1.5055,1.5662,1.3104,1.1499,1.2659,1.5018,1.5682,1.3088,1.1491,1.2686,1.5053,1.566,1.3056,1.1505,1.2683,1.5054,1.5669,1.3065,1.1491,1.2673,1.5075,1.5652,1.3055,1.1495,1.269,1.5079,1.5664,1.3046,1.1485,1.2715,1.5134,1.5618,1.3043,1.1491,1.2715,1.5116,1.5627,1.306,1.1512,1.2729,1.5138,1.5639,1.3018,1.1525,1.2743,1.513,1.5604,1.3044,1.1506,1.2786,1.5121,1.5642,1.3016,1.1507,1.2768,1.5116,1.5628,1.3011,1.1484,1.2781,1.5098,1.564,1.2979,1.1504,1.2767,0.0:6
-4.3045E-4,0.0024967,-0.0032271,0.0011942,-0.0023635,-0.001437,0.0025299,-0.0044614,0.0018943,-0.0012129,-0.0018722,0.0050008,-0.0034938,0.0021573,-0.0015806,-0.0024784,0.0011829,-0.0029474,0.0020179,3.1148E-4,-0.001828,0.0010026,-0.0035627,0.0026667,-0.0017769,-0.0027207,0.001629,-0.0031715,9.5072E-4,-0.0013129,3.8723,3.2629,1.9026,2.1671,2.013,1.7455,1.3844,1.267,1.4936,1.638,1.5217,1.2289,1.1971,1.4166,1.5866,1.4888,1.2064,1.1885,1.4034,1.5776,1.4796,1.2024,1.1855,1.4026,1.573,1.4781,1.2029,1.1845,1.4061,1.5754,1.4799,1.1983,1.1881,1.4064,1.5762,1.4786,1.199,1.1891,1.4051,1.5732,1.4772,1.1968,1.1894,1.4064,1.5771,1.4761,1.1966,1.1909,1.4084,1.5789,1.4781,1.1948,1.193,1.4083,1.5797,1.4754,1.1941,1.1917,1.4077,1.578,1.4739,1.1924,1.1926,1.4071,1.5827,1.47,1.1937,1.1912,1.41,1.5781,1.4681,1.1908,1.1904,1.4055,1.5761,1.468,1.1907,1.191,1.4087,1.5738,1.4646,1.1881,1.1922,1.4125,1.5755,1.4635,1.1864,1.1922,1.4091,1.5728,1.4648,1.1866,1.1911,1.4099,1.5705,1.4624,1.1828,1.1934,1.4115,1.573,1.4609,1.1831,1.193,1.4156,1.575,1.4621,1.182,1.1955,1.4134,1.5766,1.4606,1.1838,1.1943,1.4141,1.5736,1.4585,1.1803,1.194,1.4151,1.5769,1.457,1.1814,1.1963,1.4161,1.5767,1.455,1.18,1.1979,1.4156,1.5774,1.4531,1.1799,1.1966,1.418,1.5746,1.4517,1.1803,1.1974,1.4187,1.575,1.4511,1.1771,1.1961,1.4212,1.5739,1.4483,1.1806,1.1977,1.4246,1.5743,1.4525,1.1792,1.2003,1.4248,1.5752,1.4471,1.1776,1.1993,1.4272,1.5713,1.4489,1.1765,1.2,1.4241,1.5744,1.445,1.175,1.202,1.4264,1.5749,1.4438,1.1755,1.202,1.4264,1.5769,1.4418,1.1736,1.2042,1.4272,1.5792,1.44,1.174,1.2031,1.4292,1.5783,1.4386,1.1736,1.2029,1.431,1.5785,1.4372,1.1731,1.2024,1.4329,1.5743,1.4369,1.1725,1.2045,1.4359,1.578,1.4375,1.1717,1.2052,1.4384,1.5753,1.4383,1.1735,1.2059,1.4371,1.5747,1.4353,1.1714,1.2061,1.4384,1.5767,1.4345,1.1694,1.2088,1.4359,1.5773,1.4334,1.1708,1.2098,1.4373,1.5793,1.4338,1.1723,1.2113,1.4343,1.58,1.4272,1.1677,1.2109,1.4357,1.5826,1.4289,1.168,1.2105,1.4366,1.5806,1.426,1.1686,1.2118,1.4369,1.5817,1.4256,1.1696,1.2122,1.4398,1.583,1.4251,1.1656,1.2133,1.4419,1.5805,1.423,1.1692,1.2123,1.4463,1.5758,1.4245,1.1657,1.2141,1.4454,1.5788,1.4199,1.167,1.2145,1.4457,1.5772,1.4221,1.1636,1.2157,1.4445,1.5785,1.4197,1.163,1.2181,1.4458,1.5786,1.418,1.1631,1.2194,1.446,1.5793,1.4157,1.1608,1.2204,1.446,1.5811,1.4128,1.1624,1.2215,1.4491,1.578,1.4108,1.1585,1.2191,1.4468,1.581,1.4084,1.1601,1.2197,1.451,1.5776,1.4086,1.1606,1.2213,1.4506,1.5783,1.4062,1.1588,1.22,1.4554,1.5742,1.4059,1.1595,1.2221,1.4574,1.5739,1.4046,1.158,1.223,1.4577,1.5718,1.4028,1.1565,1.2261,1.4556,1.5744,1.4009,1.1553,1.225,1.4566,1.5759,1.3962,1.1546,1.2256,1.456,1.5757,1.3967,1.1548,1.2277,1.4568,1.576,1.3929,1.1549,1.2276,1.4586,1.5771,1.3939,1.1535,1.2274,1.4585,1.5762,1.3909,1.1572,1.2293,1.4613,1.5758,1.391,1.154,1.2294,1.4636,1.5746,1.3869,1.1535,1.2294,1.4657,1.5737,1.3868,1.1522,1.2309,1.4656,1.573,1.3857,1.1532,1.2326,1.4659,1.5748,1.3834,1.1515,1.2356,1.4676,1.5771,1.3804,1.1519,1.2357,1.4673,1.5792,1.3806,1.1535,1.2342,1.4683,1.5778,1.3794,1.1515,1.2388,1.4713,1.581,1.3772,1.1528,1.2389,1.4737,1.5777,1.3764,1.1532,1.2402,1.4726,1.5798,1.3758,1.1519,1.2386,1.4746,1.577,1.3737,1.1509,1.2432,1.4758,1.5758,1.3712,1.1502,1.2441,1.4797,1.5774,1.3714,0.90117:6
0.0040156,0.0019812,0.0043713,0.0046206,0.0037707,0.0036522,0.0019345,0.0043269,0.0048511,0.0029753,0.0040721,0.0023311,0.0044137,0.0039957,0.0033733,0.0043575,0.0025889,0.0037557,0.0040723,0.0035436,0.003979,0.0027229,0.0038277,0.0044581,0.0033276,0.0045983,0.52995,0.45757,0.31022,0.25544,0.21395,0.17453,0.2232,0.23828,0.22375,0.18464,0.17572,0.21437,0.23715,0.22456,0.18422,0.1768,0.21365,0.23752,0.22546,0.18434,0.17756,0.21391,0.23726,0.22588,0.18451,0.17809,0.21348,0.23781,0.22614,0.18503,0.1778,0.21402,0.23921,0.22681,0.18491,0.17827,0.21453,0.23824,0.22787,0.18626,0.17783,0.21465,0.23955,0.22769,0.1856,0.17838,0.21455,0.23948,0.2285,0.18607,0.17777,0.2148,0.23935,0.22857,0.18641,0.17802,0.21506,0.23952,0.22885,0.18676,0.17885,0.21428,0.23976,0.22942,0.18747,0.17843,0.21467,0.24028,0.22855,0.18686,0.17966,0.21497,0.24019,0.2287,0.18698,0.17855,0.21468,0.24033,0.22958,0.18762,0.17927,0.21476,0.24104,0.2294,0.18774,0.17944,0.21518,0.24061,0.22925,0.18736,0.17875,0.21562,0.24018,0.22994,0.18746,0.17906,0.215,0.24077,0.23025,0.18735,0.17944,0.21525,0.24081,0.22987,0.18814,0.17933,0.21426,0.24174,0.23083,0.1883,0.17994,0.21496,0.24069,0.23002,0.18826,0.17858,0.21565,0.24119,0.23038,0.18813,0.17872,0.21494,0.24112,0.23077,0.18829,0.17891,0.21515,0.24147,0.23137,0.18892,0.17898,0.21486,0.24112,0.23063,0.18879,0.17911,0.21504,0.24197,0.23107,0.18856,0.17963,0.21487,0.24222,0.23127,0.18804,0.17941,0.21446,0.24116,0.23228,0.18854,0.1794,0.21474,0.24198,0.23176,0.18955,0.17955,0.21482,0.24161,0.2316,0.18904,0.17902,0.21434,0.24121,0.2311,0.18878,0.17972,0.21446,0.24189,0.23232,0.18977,0.17881,0.2143,0.24209,0.23287,0.18878,0.17943,0.21432,0.24148,0.23182,0.189,0.17954,0.21448,0.24245,0.23225,0.18993,0.17884,0.21457,0.2423,0.23322,0.18988,0.17941,0.21486,0.24257,0.23377,0.18931,0.1792,0.21437,0.2425,0.23272,0.18967,0.17999,0.21427,0.24238,0.23311,0.18954,0.18021,0.21413,0.24294,0.23339,0.19006,0.17927,0.21393,0.24224,0.2335,0.19016,0.17953,0.21425,0.24344,0.23261,0.19031,0.17949,0.21373,0.24224,0.2331,0.19006,0.18006,0.2145,0.24224,0.23247,0.19102,0.17937,0.21436,0.24239,0.23345,0.1907,0.17938,0.21362,0.24195,0.2336,0.1911,0.17955,0.21409,0.24243,0.23448,0.19058,0.17976,0.21415,0.24293,0.23458,0.19117,0.1797,0.21405,0.24237,0.23402,0.19075,0.17914,0.21432,0.24286,0.23445,0.19065,0.17934,0.2137,0.2428,0.23443,0.19118,0.17885,0.21411,0.24282,0.23491,0.19146,0.17955,0.21426,0.24345,0.23437,0.19099,0.17943,0.21314,0.243,0.23482,0.19195,0.1795,0.21353,0.24352,0.23485,0.19199,0.17903,0.21322,0.24304,0.23467,0.19136,0.17921,0.21343,0.24316,0.2353,0.19205,0.17947,0.21316,0.24319,0.23546,0.19146,0.17968,0.21338,0.24299,0.23496,0.19229,0.17955,0.21337,0.24304,0.23542,0.19219,0.1799,0.21323,0.24313,0.23472,0.19217,0.17987,0.21311,0.24283,0.23542,0.19191,0.17959,0.21227,0.24336,0.23512,0.19226,0.17914,0.2134,0.24267,0.23517,0.19254,0.17919,0.21213,0.24237,0.23578,0.19221,0.1787,0.21298,0.24301,0.23569,0.19316,0.17901,0.21296,0.24272,0.23607,0.19271,0.17945,0.21226,0.24306,0.23573,0.19278,0.1792,0.21319,0.24299,0.23587,0.1926,0.17925,0.21183,0.24256,0.23528,0.19275,0.17933,0.21269,0.24308,0.2363,0.19314,0.17911,0.21314,0.24243,0.23553,0.19277,0.17897,0.21173,0.24317,0.23601,0.19279,0.17998,0.21226,0.24277,0.23633,0.19251,0.17948,0.21214,0.24257,0.23572,0.19388,0.17907,0.2123,0.2438,0.23607,0.19329,0.17993,0.21158,0.24327,0.23661,0.19325,0.17897,0.21182,0.24375,0.23639,0.19385,0.17898,0.21213,0.24344,0.23617,0.19305,0.17903,0.2119,0.2432,0.23691,0.19388,0.179,0.21234,0.24294,0.23661,0.19421,0.17924,0.21197,0.12457:6
0.0033279,0.0024017,0.0012928,0.0026833,0.0017309,0.0028582,0.0033883,0.0010607,0.0033261,0.0014343,0.0025842,0.0032095,0.0010533,0.0035838,9.8999E-4,0.0031542,0.0041336,4.6813E-4,0.0028561,0.0017242,0.0024725,0.0026368,6.9185E-4,0.0035639,0.0019697,0.0021708,0.036632,0.56903,0.37109,0.27787,0.16982,6.1463E-4,0.003333,0.003461,0.0028772,0.09399,0.19365,0.24997,0.20909,0.24853,0.25198,0.21874,0.18148,0.18521,0.22479,0.24118,0.21347,0.17802,0.18457,0.22381,0.2407,0.21389,0.1785,0.18428,0.22447,0.24055,0.21536,0.17858,0.18459,0.22414,0.24112,0.21514,0.17846,0.18503,0.22421,0.24204,0.21611,0.17832,0.18506,0.22334,0.24179,0.21601,0.17919,0.18511,0.22379,0.24217,0.21728,0.17932,0.18476,0.22423,0.2418,0.21689,0.17945,0.18475,0.22372,0.24202,0.21774,0.17921,0.18499,0.22455,0.24242,0.21793,0.1799,0.18482,0.224,0.2425,0.21825,0.17992,0.18483,0.22463,0.24295,0.21837,0.18005,0.18521,0.22421,0.24286,0.2187,0.1807,0.18505,0.22439,0.24256,0.21913,0.18104,0.18502,0.22502,0.24247,0.21912,0.18125,0.18498,0.22436,0.24408,0.21952,0.18141,0.18583,0.22431,0.24283,0.21978,0.1818,0.1848,0.22481,0.24362,0.21971,0.18084,0.18431,0.22418,0.24317,0.22056,0.18117,0.18488,0.22357,0.24309,0.21967,0.18066,0.18486,0.22482,0.24349,0.22058,0.18166,0.18466,0.22438,0.244,0.22147,0.1817,0.18562,0.22415,0.24485,0.22144,0.18203,0.18419,0.22412,0.24429,0.22113,0.18193,0.18499,0.22447,0.24417,0.22207,0.18272,0.18495,0.22452,0.24373,0.22191,0.18276,0.18464,0.2236,0.24411,0.22179,0.18237,0.18509,0.22377,0.24456,0.22236,0.1823,0.1848,0.22386,0.24504,0.22223,0.18231,0.18449,0.22443,0.24508,0.22276,0.18291,0.18505,0.22389,0.24493,0.22285,0.18296,0.18451,0.224,0.24484,0.22367,0.18327,0.18509,0.224,0.24444,0.22302,0.1834,0.18469,0.22308,0.24449,0.22319,0.18312,0.1849,0.22422,0.24509,0.22353,0.18339,0.1849,0.22425,0.24514,0.22475,0.18415,0.18518,0.22336,0.24463,0.22509,0.18369,0.18453,0.22287,0.24454,0.22491,0.18303,0.18456,0.22338,0.24498,0.22496,0.18349,0.18499,0.22295,0.24433,0.22468,0.1843,0.18525,0.22326,0.2451,0.22559,0.18491,0.18406,0.22285,0.24499,0.22496,0.18455,0.1846,0.22309,0.24562,0.22658,0.1842,0.18449,0.22375,0.24568,0.22529,0.18411,0.18521,0.22245,0.24572,0.22565,0.18425,0.18415,0.22248,0.24519,0.2256,0.18489,0.18393,0.22265,0.24518,0.22666,0.18521,0.18454,0.22297,0.24511,0.22624,0.18501,0.18432,0.22144,0.24587,0.22651,0.18495,0.18382,0.22194,0.2463,0.22605,0.18511,0.184,0.2228,0.24448,0.22622,0.18538,0.18393,0.22227,0.24575,0.22649,0.18552,0.18454,0.22273,0.24551,0.22652,0.18543,0.18447,0.22175,0.2451,0.22731,0.18541,0.18435,0.22158,0.24581,0.22682,0.18503,0.18365,0.22195,0.24571,0.22785,0.18568,0.18402,0.22169,0.24654,0.22814,0.18645,0.18426,0.22147,0.24567,0.22757,0.18656,0.18396,0.22112,0.2457,0.22863,0.18595,0.18346,0.22098,0.24539,0.22889,0.18625,0.18331,0.2212,0.24523,0.22923,0.18701,0.18298,0.22052,0.24566,0.22874,0.18635,0.18323,0.22008,0.24529,0.2291,0.18621,0.18339,0.22074,0.24455,0.22908,0.1873,0.18309,0.22058,0.24573,0.22978,0.18694,0.18393,0.22014,0.24519,0.22907,0.18718,0.18372,0.2201,0.24569,0.22918,0.18741,0.18289,0.21951,0.24574,0.22996,0.18781,0.18307,0.21912,0.24597,0.23094,0.1875,0.18286,0.21912,0.24605,0.22978,0.18742,0.18257,0.21916,0.24604,0.2312,0.18738,0.18275,0.21912,0.2461,0.23131,0.18785,0.18262,0.21866,0.24595,0.23048,0.18819,0.1831,0.219,0.24512,0.23103,0.18814,0.18242,0.21872,0.24611,0.2308,0.18732,0.18231,0.21816,0.24637,0.23102,0.18865,0.18179,0.21869,0.24552,0.23097,0.18859,0.18237,0.2175,0.2455,0.23144,0.18902,0.1825,0.2188,0.24564,0.23214,0.18918,0.1823,0.21804,0.2454,0.23147,0.18829,0.18204,0.21811,0.2459,0.2319,0.18961,0.18163,0.21753,0.24682,0.23173,0.18925,0.18235,0.21753,0.24552,0.10957:6
-5.0E-7,5.0E-8,1.0033E-6,-1.7133E-6,9.1667E-7,-2.0E-7,2.6E-7,8.3667E-7,-9.1E-7,1.0367E-6,-6.5667E-7,3.2667E-7,1.1267E-6,-3.0333E-7,7.7E-7,-7.9E-7,-3.3333E-9,1.0567E-6,-1.48E-6,7.3667E-7,-6.3667E-7,1.1E-7,1.6267E-6,-1.0467E-6,8.1667E-7,1.0667E-7,-2.2667E-7,8.8E-7,-5.2667E-7,7.0E-7,-1.0E-8,2.0667E-7,1.3933E-6,-1.3933E-6,1.4356E-4,0.0012818,8.3653E-4,5.8992E-4,3.7841E-4,4.276E-4,4.5731E-4,4.8202E-4,4.2094E-4,3.5395E-4,3.5978E-4,4.4047E-4,4.6383E-4,4.0902E-4,3.5345E-4,3.5398E-4,4.4191E-4,4.6415E-4,4.1144E-4,3.4902E-4,3.5213E-4,4.4107E-4,4.6307E-4,3.7372E-4,3.4524E-4,3.6371E-4,4.46E-4,4.6748E-4,4.0994E-4,3.5616E-4,3.5428E-4,4.3964E-4,4.6249E-4,4.0842E-4,3.547E-4,3.5131E-4,4.3991E-4,4.6389E-4,4.075E-4,3.5466E-4,3.5123E-4,4.3811E-4,4.6198E-4,4.0971E-4,3.5477E-4,3.5124E-4,4.3682E-4,4.6549E-4,4.1069E-4,3.5476E-4,3.5023E-4,4.0068E-4,4.7093E-4,4.1381E-4,3.5968E-4,3.5233E-4,3.9894E-4,4.1525E-4,4.2172E-4,3.6216E-4,3.4205E-4,4.1776E-4,4.6963E-4,4.1269E-4,3.611E-4,3.4951E-4,4.3983E-4,4.66E-4,4.1043E-4,3.5464E-4,3.5054E-4,4.4052E-4,4.6564E-4,4.1133E-4,3.5572E-4,3.4772E-4,4.3925E-4,4.6673E-4,4.1223E-4,3.5578E-4,3.175E-4,4.3235E-4,4.7275E-4,4.1731E-4,3.5874E-4,3.5115E-4,4.3745E-4,4.6357E-4,4.1464E-4,3.5513E-4,3.4977E-4,4.3855E-4,4.6448E-4,4.1196E-4,3.5742E-4,3.4999E-4,4.374E-4,4.6332E-4,4.1271E-4,3.5745E-4,3.4795E-4,4.2515E-4,4.7209E-4,4.1702E-4,3.5759E-4,3.5061E-4,4.3904E-4,4.6714E-4,4.1518E-4,3.5714E-4,3.484E-4,4.3749E-4,4.6684E-4,4.1547E-4,3.5649E-4,3.4859E-4,4.3558E-4,4.6728E-4,4.1607E-4,3.5594E-4,3.4809E-4,4.3635E-4,4.6598E-4,4.1638E-4,3.5901E-4,3.4983E-4,4.3536E-4,4.6587E-4,4.1603E-4,3.5904E-4,3.4796E-4,4.3468E-4,4.6549E-4,4.1684E-4,3.5846E-4,3.4774E-4,4.3288E-4,4.6482E-4,4.0742E-4,3.5845E-4,3.447E-4,4.3715E-4,4.6442E-4,4.1598E-4,3.5855E-4,3.4451E-4,4.3365E-4,4.683E-4,4.1873E-4,3.5965E-4,3.4593E-4,4.3172E-4,4.642E-4,4.1702E-4,3.6107E-4,3.4642E-4,4.3356E-4,4.6493E-4,4.1721E-4,3.5867E-4,3.4551E-4,4.3076E-4,4.5018E-4,3.9591E-4,3.669E-4,3.4594E-4,4.3648E-4,4.6694E-4,4.1946E-4,3.6117E-4,3.454E-4,4.3477E-4,4.668E-4,3.7531E-4,3.5134E-4,3.5263E-4,4.3121E-4,4.6733E-4,4.2193E-4,3.5976E-4,3.4384E-4,4.3106E-4,4.6529E-4,4.2151E-4,3.5823E-4,3.3587E-4,4.3382E-4,4.6487E-4,4.2034E-4,3.5882E-4,3.4397E-4,4.3222E-4,4.6518E-4,4.2286E-4,3.6098E-4,3.4359E-4,4.3212E-4,4.6482E-4,4.1997E-4,3.6078E-4,3.425E-4,4.3085E-4,4.6558E-4,4.2132E-4,3.6083E-4,3.4334E-4,4.296E-4,4.647E-4,4.2349E-4,3.6175E-4,3.4383E-4,4.295E-4,4.654E-4,4.2301E-4,3.6129E-4,3.4269E-4,4.2775E-4,4.6393E-4,4.2326E-4,3.6335E-4,3.4416E-4,4.2876E-4,4.6502E-4,4.244E-4,3.624E-4,3.4246E-4,4.2658E-4,4.6831E-4,4.2546E-4,3.6102E-4,3.4165E-4,4.2913E-4,4.6504E-4,4.2531E-4,3.6265E-4,3.4315E-4,4.2693E-4,4.6713E-4,4.2518E-4,3.6238E-4,3.4156E-4,4.2873E-4,4.6547E-4,4.2377E-4,3.6239E-4,3.4117E-4,4.2886E-4,4.6701E-4,4.2772E-4,3.617E-4,3.3954E-4,4.2581E-4,4.6646E-4,4.2784E-4,3.6407E-4,3.407E-4,4.2466E-4,4.6411E-4,4.2834E-4,3.6442E-4,3.4001E-4,4.2427E-4,4.6306E-4,4.2718E-4,3.6596E-4,3.4097E-4,4.2435E-4,4.629E-4,4.2632E-4,3.6376E-4,3.3995E-4,4.2348E-4,4.6361E-4,4.2827E-4,3.6341E-4,3.389E-4,4.2419E-4,4.6435E-4,4.3027E-4,3.6424E-4,3.4056E-4,4.2376E-4,4.6601E-4,4.2963E-4,3.6617E-4,3.3659E-4,4.2189E-4,4.6426E-4,4.2974E-4,3.6708E-4,3.3904E-4,4.2137E-4,4.639E-4,4.3088E-4,3.6744E-4,3.3951E-4,4.1819E-4,4.6314E-4,4.3176E-4,3.6576E-4,3.368E-4,4.2205E-4,4.6404E-4,4.3138E-4,3.6611E-4,3.383E-4,4.2209E-4,4.649E-4,4.3369E-4,3.6721E-4,3.3833E-4,4.2071E-4,4.6477E-4,4.322E-4,3.6735E-4,3.3768E-4,4.1991E-4,4.6621E-4,4.3336E-4,3.6774E-4,3.3743E-4,4.1923E-4,2.5526E-4:6
-5.6667E-7,1.5033E-6,1.6E-7,-4.1333E-7,8.8667E-7,-7.8E-7,1.6833E-6,-2.3E-7,6.6E-7,1.52E-6,-1.0333E-7,1.3267E-6,-6.6667E-9,8.3333E-7,4.9667E-7,9.3333E-8,1.0933E-6,-8.4E-7,2.9667E-7,1.3267E-6,-6.2E-7,8.6E-7,1.12E-6,-1.4333E-7,5.3E-7,-1.1833E-6,1.4267E-6,6.2E-7,1.2433E-6,1.4833E-6,-9.1667E-7,1.5433E-6,7.6667E-8,8.1667E-7,8.7333E-7,-1.0667E-6,1.4167E-6,-4.7333E-7,-6.0E-7,3.6667E-8,-9.9E-7,1.2467E-6,-6.7E-7,1.2333E-7,-5.1667E-7,-1.18E-6,4.3667E-7,2.7E-7,3.4E-7,3.7333E-7,9.0E-8,1.5933E-6,7.6667E-8,3.0E-7,1.1933E-6,-7.7667E-7,1.18E-6,-4.8E-7,-6.6667E-9,5.9E-7,-1.5167E-6,7.7333E-7,-1.0233E-6,4.6667E-7,0.0010047,8.2661E-4,4.4388E-4,6.3039E-4,5.4853E-4,4.6243E-4,4.0843E-4,3.4029E-4,4.4004E-4,4.7687E-4,4.2926E-4,3.4176E-4,2.9909E-4,4.2895E-4,4.8118E-4,4.3618E-4,3.7522E-4,3.4134E-4,4.2657E-4,4.7347E-4,4.3267E-4,3.7471E-4,3.4041E-4,4.2366E-4,4.6855E-4,4.3192E-4,3.7409E-4,3.3913E-4,4.2263E-4,4.6847E-4,4.3221E-4,3.7097E-4,3.3779E-4,4.2147E-4,4.6768E-4,4.3207E-4,3.7352E-4,3.3698E-4,4.2032E-4,4.6693E-4,4.306E-4,3.7258E-4,3.3746E-4,4.2197E-4,4.6587E-4,4.3348E-4,3.7365E-4,3.3711E-4,4.2065E-4,4.6764E-4,4.3407E-4,3.7358E-4,3.3571E-4,4.2003E-4,4.6626E-4,4.3198E-4,3.7427E-4,3.3672E-4,4.2069E-4,4.6616E-4,4.334E-4,3.7426E-4,3.3569E-4,4.1862E-4,4.6768E-4,4.3502E-4,3.7408E-4,3.3449E-4,4.1743E-4,4.6531E-4,4.3595E-4,3.7347E-4,3.3549E-4,4.16E-4,4.6559E-4,4.3509E-4,3.7384E-4,3.3296E-4,4.1443E-4,4.6512E-4,4.3605E-4,3.6999E-4,3.3216E-4,4.168E-4,4.6556E-4,4.0694E-4,3.6112E-4,3.4453E-4,4.1496E-4,4.1862E-4,4.1923E-4,3.857E-4,3.391E-4,4.1891E-4,4.6792E-4,4.4124E-4,3.7728E-4,3.3302E-4,4.1452E-4,4.6602E-4,4.4069E-4,3.7858E-4,3.348E-4,4.1192E-4,4.6462E-4,4.4207E-4,3.8013E-4,3.3318E-4,4.1432E-4,4.6574E-4,4.4148E-4,3.8148E-4,3.3343E-4,4.116E-4,4.643E-4,4.4264E-4,3.7955E-4,3.3277E-4,4.111E-4,4.6411E-4,4.4313E-4,3.7898E-4,3.3076E-4,4.1083E-4,4.63E-4,4.435E-4,3.8063E-4,3.3305E-4,4.0674E-4,4.6303E-4,4.4507E-4,3.7996E-4,3.3276E-4,4.1098E-4,4.6078E-4,4.4505E-4,3.8208E-4,3.3227E-4,4.1176E-4,4.6433E-4,4.4541E-4,3.8265E-4,3.3326E-4,4.0977E-4,4.6263E-4,4.4576E-4,3.8442E-4,3.324E-4,4.0822E-4,4.4558E-4,4.3058E-4,3.9031E-4,3.3182E-4,4.0964E-4,4.6288E-4,4.388E-4,3.8514E-4,3.3376E-4,4.0819E-4,4.6264E-4,4.4691E-4,3.8578E-4,3.3238E-4,4.0693E-4,4.6239E-4,4.4861E-4,3.871E-4,3.3086E-4,4.0596E-4,4.6054E-4,4.4793E-4,3.8534E-4,3.322E-4,4.051E-4,4.6017E-4,4.5131E-4,3.8819E-4,3.3167E-4,4.032E-4,4.6062E-4,4.5E-4,3.8862E-4,3.3199E-4,4.0258E-4,4.6167E-4,4.5065E-4,3.89E-4,3.3217E-4,4.0226E-4,4.5853E-4,4.4989E-4,3.8986E-4,3.3209E-4,4.0163E-4,4.6115E-4,4.4989E-4,3.8978E-4,3.3148E-4,4.0277E-4,4.5829E-4,4.5133E-4,3.9152E-4,3.3069E-4,4.0055E-4,4.5752E-4,4.5143E-4,3.913E-4,3.3186E-4,4.0175E-4,4.5829E-4,4.5239E-4,3.8578E-4,3.3046E-4,4.0068E-4,4.5754E-4,4.5416E-4,3.9225E-4,3.3116E-4,3.9873E-4,4.5698E-4,4.542E-4,3.9178E-4,3.3077E-4,3.9897E-4,4.5727E-4,4.532E-4,3.9323E-4,3.308E-4,3.9572E-4,4.5631E-4,4.4383E-4,3.9841E-4,3.3071E-4,4.0015E-4,4.5695E-4,4.5555E-4,3.9575E-4,3.3081E-4,3.9739E-4,4.5358E-4,4.5581E-4,3.9877E-4,3.3143E-4,3.9775E-4,4.5541E-4,4.5398E-4,3.9785E-4,3.3204E-4,3.9529E-4,4.546E-4,4.568E-4,3.9756E-4,3.2932E-4,3.9546E-4,4.5082E-4,4.5725E-4,3.9777E-4,3.3142E-4,3.9311E-4,4.5411E-4,4.5703E-4,3.9943E-4,3.3106E-4,3.9628E-4,4.5447E-4,4.5777E-4,4.0032E-4,3.304E-4,3.9527E-4,2.321E-4:6
1.2567E-6,1.0133E-6,-6.1333E-7,8.0E-7,-5.9E-7,5.8667E-7,4.5333E-7,-1.79E-6,1.5667E-6,-2.2333E-7,-3.3333E-8,1.17E-6,-9.3333E-8,8.8E-7,-7.2667E-7,1.3667E-7,1.1367E-6,-8.5E-7,1.0467E-6,-1.9367E-6,9.4E-7,5.2333E-7,-7.6667E-7,1.31E-6,-6.2667E-7,1.2467E-6,1.3533E-6,-6.7E-7,1.78E-6,-3.8E-7,1.0233E-6,2.8325E-4,0.0011301,6.1506E-4,5.6794E-4,5.6249E-4,5.0698E-4,4.1675E-4,3.4522E-4,4.1097E-4,4.6534E-4,4.5373E-4,3.9267E-4,3.3035E-4,4.056E-4,4.6119E-4,4.5134E-4,3.9092E-4,3.3114E-4,4.0178E-4,4.5838E-4,4.5134E-4,3.9202E-4,3.3167E-4,3.9912E-4,4.58E-4,4.5082E-4,3.911E-4,3.3209E-4,3.9808E-4,4.5683E-4,4.4856E-4,3.9387E-4,3.3241E-4,4.0127E-4,4.5642E-4,4.5198E-4,3.9263E-4,3.3097E-4,3.9936E-4,4.5573E-4,4.5083E-4,3.9476E-4,3.3037E-4,3.9845E-4,4.5577E-4,4.5176E-4,3.9133E-4,3.3101E-4,4.0084E-4,4.5564E-4,4.527E-4,3.9421E-4,3.3166E-4,3.9835E-4,4.5695E-4,4.5293E-4,3.9137E-4,3.313E-4,3.9735E-4,4.3698E-4,4.4853E-4,3.9738E-4,3.3045E-4,4.0025E-4,4.5489E-4,4.5303E-4,3.9517E-4,3.3161E-4,3.9743E-4,4.5502E-4,4.5335E-4,3.9457E-4,3.3154E-4,3.9804E-4,4.5404E-4,4.5562E-4,3.9472E-4,3.2985E-4,3.9724E-4,4.539E-4,4.5388E-4,3.9601E-4,3.3064E-4,3.9631E-4,4.536E-4,4.5287E-4,3.9449E-4,3.3008E-4,3.9671E-4,4.5421E-4,4.5559E-4,3.9464E-4,3.3105E-4,3.9532E-4,4.529E-4,4.5454E-4,3.9433E-4,3.2943E-4,3.959E-4,4.5415E-4,4.5402E-4,3.9398E-4,3.2963E-4,3.9383E-4,4.5187E-4,4.5452E-4,3.9567E-4,3.2995E-4,3.9677E-4,4.5398E-4,4.5418E-4,3.9592E-4,3.2897E-4,3.949E-4,4.5281E-4,4.538E-4,3.6187E-4,3.1845E-4,4.058E-4,4.563E-4,4.5748E-4,3.9773E-4,3.2927E-4,3.9416E-4,4.5163E-4,4.5755E-4,3.9719E-4,3.2958E-4,3.9328E-4,4.5075E-4,4.5414E-4,3.9598E-4,3.2923E-4,3.9032E-4,4.5496E-4,4.6002E-4,4.0019E-4,3.303E-4,3.9248E-4,4.5253E-4,4.5676E-4,3.9906E-4,3.3029E-4,3.9496E-4,4.5234E-4,4.574E-4,3.9737E-4,3.3106E-4,3.9357E-4,4.5285E-4,4.5516E-4,3.9867E-4,3.3018E-4,3.925E-4,4.5225E-4,4.5725E-4,3.9878E-4,3.3057E-4,3.9315E-4,4.5195E-4,4.5758E-4,3.9836E-4,3.3121E-4,3.9455E-4,4.5145E-4,4.5701E-4,4.0107E-4,3.3012E-4,3.8749E-4,4.4708E-4,4.5612E-4,3.9991E-4,3.3115E-4,3.9084E-4,4.5077E-4,4.5585E-4,3.9984E-4,3.2993E-4,3.8446E-4,4.5525E-4,4.5736E-4,4.0102E-4,3.2942E-4,3.9042E-4,4.5425E-4,4.5997E-4,4.0306E-4,3.3307E-4,3.914E-4,4.5039E-4,4.5964E-4,4.0389E-4,3.3126E-4,3.9153E-4,4.4939E-4,4.5835E-4,4.0256E-4,3.3053E-4,3.9008E-4,4.4983E-4,4.5911E-4,4.0111E-4,3.3052E-4,3.8947E-4,4.4855E-4,4.5901E-4,4.0201E-4,3.2931E-4,3.8878E-4,4.5018E-4,4.5266E-4,4.0316E-4,3.283E-4,3.8855E-4,4.5034E-4,4.593E-4,4.0201E-4,3.2987E-4,3.8761E-4,4.4674E-4,4.572E-4,4.0545E-4,3.3061E-4,3.8795E-4,4.4816E-4,4.574E-4,4.0324E-4,3.2958E-4,3.8656E-4,4.4902E-4,4.5892E-4,4.0397E-4,3.3142E-4,3.8695E-4,4.4781E-4,4.5864E-4,4.0519E-4,3.3063E-4,3.8732E-4,4.4886E-4,4.5963E-4,4.0434E-4,3.3065E-4,3.8853E-4,4.4879E-4,4.5857E-4,4.0413E-4,3.303E-4,3.857E-4,4.4725E-4,4.5983E-4,4.049E-4,3.3177E-4,3.8621E-4,4.4644E-4,4.608E-4,4.06E-4,3.3117E-4,3.8647E-4,0.0:6
-2.2467E-6,-4.3333E-8,-2.3767E-6,-6.2667E-7,-1.19E-6,-1.3533E-6,4.1667E-7,-1.5433E-6,-1.24E-6,-1.3533E-6,-1.8633E-6,1.2933E-6,-7.1E-7,-9.9667E-7,-9.7333E-7,-2.4167E-6,1.5667E-7,-2.65E-6,-9.8667E-7,-3.2E-7,-2.0267E-6,8.5333E-7,-1.8067E-6,-1.16E-6,-6.6333E-7,-2.3067E-6,-4.3E-7,-1.41E-6,-9.3333E-7,-8.7667E-7,-2.0333E-6,-5.3333E-7,-1.2333E-6,-4.4667E-7,-4.7333E-7,-1.6467E-6,3.3667E-7,-1.5433E-6,-9.9333E-7,-1.2433E-6,-1.9633E-6,5.6333E-7,-2.3233E-6,-1.0333E-7,-1.4667E-7,-3.0133E-6,2.2333E-7,-1.3467E-6,-6.5E-7,-2.02E-6,-2.0967E-6,4.9E-7,0.0015313,0.0019161,0.0012695,9.3437E-4,6.8006E-4,8.0057E-4,8.4903E-4,8.0961E-4,6.8641E-4,5.6999E-4,6.8867E-4,7.7525E-4,7.6024E-4,6.5393E-4,5.5486E-4,6.7027E-4,7.5827E-4,7.56E-4,6.5399E-4,5.5147E-4,6.6632E-4,7.5716E-4,7.5473E-4,6.5096E-4,5.5445E-4,6.6479E-4,7.5408E-4,7.5427E-4,6.5073E-4,5.515E-4,6.6142E-4,7.5772E-4,7.5609E-4,6.5219E-4,5.5275E-4,6.6136E-4,7.5673E-4,7.551E-4,6.5635E-4,5.5055E-4,6.6003E-4,7.5552E-4,7.573E-4,6.5474E-4,5.5077E-4,6.5864E-4,7.563E-4,7.5795E-4,6.5529E-4,5.5188E-4,6.5561E-4,7.5751E-4,7.5801E-4,6.5846E-4,5.5034E-4,6.5794E-4,7.5218E-4,7.5762E-4,6.5973E-4,5.5015E-4,6.5496E-4,7.5301E-4,7.6042E-4,6.6085E-4,5.5382E-4,6.5639E-4,7.5339E-4,7.6131E-4,6.639E-4,5.5183E-4,6.5271E-4,7.5085E-4,7.6053E-4,6.6277E-4,5.5173E-4,6.5148E-4,7.489E-4,7.5981E-4,6.6457E-4,5.4997E-4,6.4868E-4,7.4849E-4,7.5805E-4,6.661E-4,5.503E-4,6.5011E-4,7.496E-4,7.6332E-4,6.6699E-4,5.5009E-4,6.498E-4,7.4891E-4,7.6227E-4,6.6826E-4,5.4833E-4,6.4892E-4,7.4815E-4,7.6357E-4,6.7004E-4,5.4972E-4,6.4661E-4,7.4501E-4,7.643E-4,6.7168E-4,5.4951E-4,6.4639E-4,7.4497E-4,7.6556E-4,6.736E-4,5.5048E-4,6.4269E-4,7.4123E-4,7.6695E-4,6.7263E-4,5.5235E-4,6.4313E-4,7.4099E-4,7.6475E-4,6.7458E-4,5.5015E-4,6.4062E-4,7.4064E-4,7.6688E-4,6.7499E-4,5.5015E-4,6.4002E-4,7.4112E-4,7.6776E-4,6.7784E-4,5.5277E-4,6.3935E-4,7.4012E-4,7.6699E-4,6.7751E-4,5.5105E-4,6.3988E-4,7.389E-4,7.6916E-4,6.8068E-4,5.4987E-4,6.3833E-4,7.3581E-4,7.682E-4,6.8242E-4,5.5121E-4,6.3758E-4,7.365E-4,7.692E-4,6.8063E-4,5.5133E-4,6.3246E-4,7.3462E-4,7.662E-4,6.8213E-4,5.5167E-4,6.353E-4,7.3612E-4,7.7024E-4,6.8675E-4,5.5081E-4,6.333E-4,7.3136E-4,7.7067E-4,6.8683E-4,5.5478E-4,6.3028E-4,7.3222E-4,7.6983E-4,6.8915E-4,5.5284E-4,6.303E-4,7.3303E-4,7.7014E-4,6.8623E-4,5.5176E-4,6.3117E-4,7.2938E-4,7.7046E-4,6.8826E-4,5.5258E-4,6.3045E-4,7.276E-4,7.7297E-4,6.8993E-4,5.5502E-4,6.3028E-4,7.2986E-4,7.7041E-4,6.897E-4,5.556E-4,6.2733E-4,7.2696E-4,7.6894E-4,6.925E-4,5.5273E-4,6.2628E-4,7.2584E-4,7.7402E-4,6.9262E-4,5.543E-4,6.2452E-4,7.2695E-4,7.7113E-4,6.9726E-4,5.574E-4,6.2794E-4,7.2421E-4,7.7402E-4,6.9542E-4,5.5621E-4,6.2403E-4,7.2315E-4,7.75E-4,6.9996E-4,5.5786E-4,6.2194E-4,7.2116E-4,7.7246E-4,6.9835E-4,5.5572E-4,6.2158E-4,7.1962E-4,7.7369E-4,7.018E-4,5.5679E-4,6.1994E-4,7.1824E-4,7.7396E-4,7.0179E-4,5.5547E-4,6.2211E-4,7.202E-4,7.7434E-4,7.0429E-4,5.587E-4,6.214E-4,7.1972E-4,7.7089E-4,7.0203E-4,5.5843E-4,6.1744E-4,7.1664E-4,7.7212E-4,7.0592E-4,5.59E-4,6.1709E-4,7.1392E-4,7.7482E-4,7.0608E-4,5.6039E-4,6.1575E-4,7.1399E-4,7.7142E-4,7.1E-4,5.595E-4,6.1727E-4,7.1103E-4,7.7524E-4,7.102E-4,5.6018E-4,6.1428E-4,7.105E-4,7.7335E-4,7.0963E-4,5.6046E-4,6.1371E-4,7.0792E-4,7.7472E-4,7.1295E-4,5.5997E-4,6.1268E-4,7.0946E-4,7.7584E-4,7.1325E-4,5.6126E-4,6.1131E-4,7.0864E-4,7.773E-4,7.1686E-4,5.6261E-4,6.1273E-4,3.59E-4:6
2.5667E-7,-1.36E-6,-7.7E-7,-8.5E-7,-8.9333E-7,7.0E-7,-1.4533E-6,-2.7633E-6,2.5667E-7,-1.66E-6,7.0667E-7,-9.1E-7,-2.0967E-6,-1.2667E-7,-1.0833E-6,1.0667E-7,-1.51E-6,-1.5767E-6,-3.3333E-8,-1.72E-6,-3.5333E-7,-1.02E-6,-5.7333E-7,2.1333E-7,-2.2233E-6,-6.0333E-7,-7.1333E-7,-4.4E-7,-6.6667E-8,-1.54E-6,7.6667E-8,-1.2433E-6,-1.5033E-6,1.3E-7,-2.3967E-6,-5.8E-7,-3.5667E-7,-6.4E-7,-6.2333E-7,-2.8E-7,3.8667E-7,-7.0E-7,-3.7667E-7,-2.8333E-7,-1.4933E-6,0.0012775,0.0019975,0.0013272,9.3689E-4,7.4797E-4,6.9442E-4,8.2507E-4,8.314E-4,7.0081E-4,6.08E-4,6.0395E-4,7.4859E-4,7.7884E-4,6.7274E-4,5.9048E-4,5.8868E-4,7.3391E-4,7.7393E-4,6.6741E-4,5.8839E-4,5.8548E-4,7.3055E-4,7.7267E-4,6.6777E-4,5.8861E-4,5.8556E-4,7.3046E-4,7.7166E-4,6.7005E-4,5.8526E-4,5.8295E-4,7.2906E-4,7.7126E-4,6.7164E-4,5.8713E-4,5.8448E-4,7.2792E-4,7.7156E-4,6.7216E-4,5.8962E-4,5.8363E-4,7.2918E-4,7.6932E-4,6.7204E-4,5.8789E-4,5.8221E-4,7.2913E-4,7.7268E-4,6.756E-4,5.8951E-4,5.8149E-4,7.262E-4,7.7129E-4,6.7798E-4,5.9053E-4,5.8011E-4,7.2733E-4,7.715E-4,6.7574E-4,5.9147E-4,5.7999E-4,7.2726E-4,7.7352E-4,6.7809E-4,5.9266E-4,5.809E-4,7.2365E-4,7.7534E-4,6.8032E-4,5.9067E-4,5.8082E-4,7.2644E-4,7.7463E-4,6.8219E-4,5.9376E-4,5.7941E-4,7.234E-4,7.7198E-4,6.836E-4,5.9146E-4,5.7558E-4,7.2118E-4,7.7418E-4,6.8267E-4,5.9631E-4,5.7996E-4,7.2292E-4,7.7596E-4,6.8173E-4,5.9424E-4,5.7408E-4,7.2306E-4,7.718E-4,6.8459E-4,5.9527E-4,5.7469E-4,7.2258E-4,7.7383E-4,6.8453E-4,5.9332E-4,5.7224E-4,7.2166E-4,7.7298E-4,6.8449E-4,5.9645E-4,5.7672E-4,7.2194E-4,7.7404E-4,6.8896E-4,5.9652E-4,5.734E-4,7.188E-4,7.7259E-4,6.8721E-4,5.9389E-4,5.7369E-4,7.1814E-4,7.7244E-4,6.8645E-4,5.9641E-4,5.7033E-4,7.1775E-4,7.7559E-4,6.8967E-4,5.959E-4,5.7242E-4,7.1631E-4,7.7276E-4,6.914E-4,5.9645E-4,5.6983E-4,7.1666E-4,7.7351E-4,6.9129E-4,5.9778E-4,5.7115E-4,7.143E-4,7.737E-4,6.9244E-4,5.9863E-4,5.6984E-4,7.1523E-4,7.7251E-4,6.9276E-4,5.99E-4,5.6925E-4,7.1452E-4,7.7541E-4,6.9522E-4,6.0177E-4,5.705E-4,7.11E-4,7.7426E-4,6.9551E-4,6.0106E-4,5.6852E-4,7.1258E-4,7.7453E-4,6.9709E-4,5.9932E-4,5.6911E-4,7.1137E-4,7.6981E-4,6.9791E-4,6.011E-4,5.656E-4,7.0971E-4,7.7109E-4,6.9681E-4,6.0244E-4,5.6669E-4,7.0946E-4,7.6927E-4,7.0074E-4,6.0289E-4,5.6381E-4,7.1177E-4,7.7397E-4,7.0087E-4,6.0275E-4,5.6597E-4,7.115E-4,7.7253E-4,7.0476E-4,6.0282E-4,5.6536E-4,7.0616E-4,7.71E-4,7.0078E-4,6.0386E-4,5.6504E-4,7.0775E-4,7.7047E-4,7.0466E-4,6.0459E-4,5.6589E-4,7.0779E-4,7.6914E-4,7.0587E-4,6.0518E-4,5.6412E-4,7.0636E-4,7.7313E-4,7.0683E-4,6.0679E-4,5.6225E-4,7.0715E-4,7.7125E-4,7.07E-4,6.0892E-4,5.6351E-4,7.0451E-4,7.7068E-4,7.0758E-4,6.0597E-4,5.6437E-4,7.0505E-4,7.7103E-4,7.1015E-4,6.0697E-4,5.634E-4,7.0367E-4,7.7192E-4,7.0976E-4,6.0877E-4,5.6046E-4,7.0288E-4,7.6975E-4,7.1079E-4,6.0948E-4,5.6037E-4,7.0045E-4,7.7551E-4,7.133E-4,6.0739E-4,5.5946E-4,7.0139E-4,7.702E-4,7.1265E-4,6.1017E-4,5.5845E-4,7.0021E-4,7.7258E-4,7.1444E-4,6.0896E-4,5.6133E-4,6.9975E-4,7.7217E-4,7.1539E-4,6.1273E-4,5.6031E-4,6.9843E-4,7.6898E-4,7.1577E-4,6.1072E-4,0.0:6
5.6E-7,1.4333E-6,2.4633E-6,2.0E-7,8.8E-7,4.9667E-7,1.3667E-6,1.0E-6,9.7E-7,9.8667E-7,1.2433E-6,1.6267E-6,1.25E-6,-1.3333E-8,9.4333E-7,1.8533E-6,3.5E-7,7.4667E-7,2.7333E-7,9.0333E-7,1.95E-6,8.8333E-7,2.7E-7,4.6667E-8,6.4333E-7,6.0667E-7,1.2267E-6,0.0013397,9.3678E-4,5.7839E-4,4.8481E-4,5.1504E-4,5.5605E-4,5.3189E-4,4.123E-4,4.024E-4,4.5257E-4,5.1824E-4,5.1066E-4,4.021E-4,3.9861E-4,4.4768E-4,5.1447E-4,5.0986E-4,4.0128E-4,3.9538E-4,4.4726E-4,5.1453E-4,5.1164E-4,4.0365E-4,3.9494E-4,4.4627E-4,5.1753E-4,5.1113E-4,4.0261E-4,3.9641E-4,4.4539E-4,5.1593E-4,5.1237E-4,4.0467E-4,3.9558E-4,4.4578E-4,5.1474E-4,5.1286E-4,4.036E-4,3.9704E-4,4.4612E-4,5.1633E-4,5.1013E-4,4.0392E-4,3.9746E-4,4.4704E-4,5.1759E-4,5.1212E-4,4.0362E-4,3.9671E-4,4.4545E-4,5.1833E-4,5.1165E-4,4.0546E-4,3.9649E-4,4.4713E-4,5.1836E-4,5.1158E-4,4.0487E-4,3.9581E-4,4.4471E-4,5.1882E-4,5.1206E-4,4.0512E-4,3.958E-4,4.4614E-4,5.1851E-4,5.1371E-4,4.0575E-4,3.9768E-4,4.4484E-4,5.1854E-4,5.1299E-4,4.06E-4,3.9643E-4,4.4502E-4,5.1801E-4,5.1274E-4,4.0708E-4,3.976E-4,4.4549E-4,5.2114E-4,5.1384E-4,4.0729E-4,3.9546E-4,4.4479E-4,5.1924E-4,5.1431E-4,4.0979E-4,3.9773E-4,4.4502E-4,5.188E-4,5.1205E-4,4.0743E-4,3.9722E-4,4.4355E-4,5.2029E-4,5.1536E-4,4.0863E-4,3.978E-4,4.4477E-4,5.203E-4,5.1586E-4,4.0864E-4,3.9696E-4,4.4445E-4,5.1947E-4,5.1466E-4,4.0827E-4,3.9724E-4,4.4465E-4,5.1895E-4,5.1698E-4,4.1022E-4,3.9774E-4,4.4347E-4,5.1855E-4,5.1562E-4,4.0882E-4,3.9674E-4,4.4476E-4,5.1981E-4,5.1685E-4,4.0941E-4,3.9828E-4,4.4303E-4,5.1974E-4,5.1714E-4,4.0929E-4,3.9608E-4,4.4326E-4,5.2127E-4,5.1633E-4,4.1047E-4,3.9824E-4,4.4225E-4,5.2058E-4,5.1524E-4,4.1056E-4,3.982E-4,4.4221E-4,5.1924E-4,5.1714E-4,4.1122E-4,3.9815E-4,4.4307E-4,5.2117E-4,5.1496E-4,4.1017E-4,3.9723E-4,4.4366E-4,5.1977E-4,5.1595E-4,4.115E-4,3.9817E-4,4.4278E-4,5.2004E-4,5.1714E-4,4.1182E-4,3.9775E-4,4.4215E-4,5.2117E-4,5.1879E-4,4.1116E-4,3.9707E-4,4.4297E-4,5.1999E-4,5.1759E-4,4.1373E-4,3.9767E-4,4.4152E-4,5.1964E-4,5.1847E-4,4.1291E-4,3.9691E-4,4.4086E-4,5.2132E-4,5.1582E-4,4.136E-4,3.9651E-4,4.4309E-4,5.2185E-4,5.1747E-4,4.1306E-4,3.971E-4,4.4111E-4,5.2114E-4,5.1895E-4,4.1462E-4,3.966E-4,4.4016E-4,5.2272E-4,5.1997E-4,4.135E-4,3.974E-4,4.4087E-4,5.2098E-4,5.1894E-4,4.1454E-4,3.9665E-4,4.3938E-4,5.197E-4,5.1919E-4,4.1214E-4,3.9892E-4,4.3896E-4,5.2193E-4,5.1952E-4,4.1305E-4,3.9801E-4,4.3912E-4,5.2275E-4,5.2004E-4,4.1484E-4,3.9818E-4,4.4E-4,5.1973E-4,5.2007E-4,4.1548E-4,3.987E-4,4.378E-4,5.2086E-4,5.193E-4,4.1688E-4,3.9668E-4,4.3876E-4,5.2179E-4,5.2016E-4,4.1697E-4,3.9911E-4,3.6664E-4:6
1.0067E-6,7.6667E-7,6.1667E-7,-6.5E-7,1.1367E-6,5.7333E-7,5.8333E-7,1.6733E-6,1.9E-7,2.2933E-6,1.2433E-6,1.1733E-6,1.0267E-6,1.6967E-6,1.81E-6,9.6E-7,7.2667E-7,1.8433E-6,1.6E-7,1.2267E-6,8.9E-7,5.8333E-7,1.6333E-7,9.2667E-7,1.4167E-6,7.2667E-7,6.2667E-7,8.1333E-7,3.9667E-7,1.4E-6,4.5E-7,7.4333E-7,9.8333E-7,6.1768E-4,0.0012237,6.8594E-4,5.6337E-4,4.3551E-4,5.5873E-4,5.4481E-4,4.8277E-4,3.9009E-4,4.1376E-4,4.905E-4,5.1763E-4,4.7426E-4,3.7774E-4,4.1507E-4,4.852E-4,5.162E-4,4.7647E-4,3.7634E-4,4.1457E-4,4.8495E-4,5.1568E-4,4.7944E-4,3.7978E-4,4.1362E-4,4.8404E-4,5.1617E-4,4.7866E-4,3.7779E-4,4.1481E-4,4.8417E-4,5.1605E-4,4.8214E-4,3.7752E-4,4.1523E-4,4.83E-4,5.1604E-4,4.819E-4,3.7936E-4,4.1426E-4,4.8305E-4,5.1873E-4,4.8254E-4,3.787E-4,4.1382E-4,4.8323E-4,5.1758E-4,4.8385E-4,3.7909E-4,4.1333E-4,4.8281E-4,5.1861E-4,4.843E-4,3.8006E-4,4.1451E-4,4.8199E-4,5.1819E-4,4.8474E-4,3.8046E-4,4.1308E-4,4.8154E-4,5.2101E-4,4.8488E-4,3.7973E-4,4.1271E-4,4.8039E-4,5.1996E-4,4.8626E-4,3.8084E-4,4.121E-4,4.8003E-4,5.2144E-4,4.8664E-4,3.8211E-4,4.1227E-4,4.7968E-4,5.2119E-4,4.8726E-4,3.831E-4,4.1131E-4,4.811E-4,5.2154E-4,4.8922E-4,3.8245E-4,4.1118E-4,4.8038E-4,5.2021E-4,4.8843E-4,3.8358E-4,4.1116E-4,4.7924E-4,5.206E-4,4.892E-4,3.8181E-4,4.1003E-4,4.7917E-4,5.2223E-4,4.9023E-4,3.8361E-4,4.1146E-4,4.7765E-4,5.2229E-4,4.9008E-4,3.8585E-4,4.1065E-4,4.7761E-4,5.2058E-4,4.9235E-4,3.8561E-4,4.0992E-4,4.7501E-4,5.2299E-4,4.9351E-4,3.8566E-4,4.1083E-4,4.7641E-4,5.2281E-4,4.9366E-4,3.8627E-4,4.086E-4,4.741E-4,5.2369E-4,4.9246E-4,3.8711E-4,4.0858E-4,4.7572E-4,5.2229E-4,4.9393E-4,3.8784E-4,4.0995E-4,4.7302E-4,5.2294E-4,4.957E-4,3.8817E-4,4.082E-4,4.7323E-4,5.2154E-4,4.9547E-4,3.8915E-4,4.0668E-4,4.7166E-4,5.229E-4,4.9576E-4,3.8949E-4,4.0893E-4,4.7127E-4,5.2172E-4,4.9609E-4,3.8851E-4,4.0698E-4,4.7144E-4,5.2311E-4,4.9799E-4,3.8973E-4,4.0557E-4,4.7068E-4,5.238E-4,4.9925E-4,3.893E-4,4.0841E-4,4.7075E-4,5.2292E-4,4.9856E-4,3.8948E-4,4.0607E-4,4.6845E-4,5.2299E-4,4.9825E-4,3.9194E-4,4.0753E-4,4.6885E-4,5.2305E-4,4.9831E-4,3.915E-4,4.0716E-4,4.6644E-4,5.2248E-4,5.0292E-4,3.9044E-4,4.0749E-4,4.6761E-4,5.2372E-4,4.9947E-4,3.9225E-4,4.0555E-4,4.6789E-4,5.2527E-4,5.0148E-4,3.9396E-4,4.0558E-4,4.682E-4,5.2312E-4,5.0224E-4,3.9394E-4,4.0693E-4,4.653E-4,5.2495E-4,5.0323E-4,3.9397E-4,4.0527E-4,4.6736E-4,5.2406E-4,5.0412E-4,3.9402E-4,4.0423E-4,4.6448E-4,5.2483E-4,5.0359E-4,3.9368E-4,4.0385E-4,4.6348E-4,5.2544E-4,5.0404E-4,3.954E-4,4.0432E-4,4.6454E-4,5.259E-4,5.0426E-4,3.9632E-4,4.0495E-4,4.6194E-4,5.2338E-4,5.0487E-4,3.9689E-4,4.0336E-4,4.6241E-4,5.2342E-4,5.0677E-4,3.9709E-4,4.0216E-4,4.5948E-4,5.2399E-4,5.0576E-4,3.9728E-4,4.0405E-4,4.609E-4,5.2579E-4,5.0577E-4,3.9804E-4,4.0428E-4,4.6052E-4,5.2365E-4,5.0803E-4,3.9824E-4,4.0164E-4,4.6013E-4,5.2495E-4,5.0861E-4,3.9778E-4,4.027E-4,4.5844E-4,5.2363E-4,5.0725E-4,2.5558E-4:6
1.3133E-6,5.9E-7,2.2267E-6,2.8E-7,7.4E-7,1.38E-6,8.0667E-7,2.0667E-7,1.3967E-6,5.5667E-7,8.2E-7,1.1833E-6,3.5333E-7,1.03E-6,9.5E-7,1.87E-6,6.6667E-7,1.2333E-6,7.2333E-7,8.9667E-7,7.3E-7,1.11E-6,1.44E-6,0.0010667,9.9423E-4,4.9475E-4,6.0353E-4,5.7175E-4,5.6018E-4,4.6249E-4,3.9289E-4,4.3166E-4,5.1047E-4,5.2038E-4,4.327E-4,3.9237E-4,4.1773E-4,5.0692E-4,5.1994E-4,4.2988E-4,3.9156E-4,4.1301E-4,5.077E-4,5.1897E-4,4.3055E-4,3.9244E-4,4.1471E-4,5.0663E-4,5.1881E-4,4.3185E-4,3.937E-4,4.1408E-4,5.0912E-4,5.1958E-4,4.3203E-4,3.9468E-4,4.1376E-4,5.0814E-4,5.1923E-4,4.3376E-4,3.94E-4,4.1378E-4,5.0806E-4,5.1948E-4,4.3408E-4,3.9223E-4,4.1124E-4,5.0812E-4,5.2265E-4,4.3537E-4,3.9394E-4,4.1048E-4,5.0737E-4,5.2105E-4,4.3712E-4,3.9301E-4,4.1115E-4,5.0953E-4,5.221E-4,4.3903E-4,3.9332E-4,4.1152E-4,5.0888E-4,5.227E-4,4.3798E-4,3.9413E-4,4.1123E-4,5.0723E-4,5.2179E-4,4.3908E-4,3.9635E-4,4.1062E-4,5.0779E-4,5.2395E-4,4.4012E-4,3.9449E-4,4.0872E-4,5.0833E-4,5.244E-4,4.4219E-4,3.9651E-4,4.0961E-4,5.0739E-4,5.2496E-4,4.4259E-4,3.9765E-4,4.0857E-4,5.0701E-4,5.2373E-4,4.4461E-4,3.9724E-4,4.0802E-4,5.074E-4,5.2401E-4,4.459E-4,3.9713E-4,4.0719E-4,5.0661E-4,5.2398E-4,4.4471E-4,3.9917E-4,4.0645E-4,5.0512E-4,5.2355E-4,4.4787E-4,3.9813E-4,4.07E-4,5.0658E-4,5.2564E-4,4.4791E-4,3.9611E-4,4.0829E-4,5.0676E-4,5.2625E-4,4.4877E-4,3.9853E-4,4.0667E-4,5.0722E-4,5.2747E-4,4.4847E-4,3.9884E-4,4.0543E-4,5.0576E-4,5.2707E-4,4.4996E-4,3.985E-4,4.0484E-4,5.0652E-4,5.2621E-4,4.5234E-4,4.0021E-4,4.0471E-4,5.0581E-4,5.2559E-4,4.5094E-4,3.9871E-4,4.0347E-4,5.0416E-4,5.2487E-4,4.5195E-4,4.0069E-4,4.0242E-4,5.062E-4,5.2599E-4,4.554E-4,3.9986E-4,4.0381E-4,5.0471E-4,5.2649E-4,4.5339E-4,3.9889E-4,4.0291E-4,5.0413E-4,5.2641E-4,4.549E-4,3.9916E-4,4.015E-4,5.0175E-4,5.2582E-4,4.5559E-4,4.0002E-4,4.0041E-4,5.0368E-4,5.2683E-4,4.5735E-4,4.0101E-4,4.0135E-4,5.038E-4,5.2655E-4,4.5859E-4,4.0165E-4,4.0063E-4,5.0194E-4,5.2706E-4,4.5714E-4,3.9913E-4,4.0157E-4,5.0161E-4,5.2773E-4,4.5932E-4,4.0155E-4,4.0084E-4,5.0171E-4,5.2611E-4,4.6001E-4,4.0167E-4,4.016E-4,5.0144E-4,5.2637E-4,4.6078E-4,4.024E-4,3.9912E-4,5.0068E-4,5.279E-4,4.6008E-4,4.0238E-4,3.9773E-4,5.0051E-4,5.2692E-4,4.6178E-4,4.0051E-4,3.9804E-4,4.9979E-4,5.2573E-4,4.6124E-4,4.0223E-4,3.9727E-4,5.0096E-4,5.2791E-4,4.6252E-4,4.0378E-4,3.9701E-4,5.0021E-4,5.2635E-4,4.6302E-4,4.0354E-4,3.9701E-4,4.9812E-4,5.2635E-4,4.6491E-4,4.0515E-4,3.9578E-4,4.9776E-4,5.2586E-4,4.6552E-4,4.0557E-4,3.9556E-4,4.9809E-4,5.2461E-4,4.6488E-4,0.0:6
1.8833E-6,8.3667E-7,1.0067E-6,1.1E-7,5.8667E-7,1.1967E-6,6.1333E-7,5.4E-7,5.5333E-7,1.41E-6,1.48E-6,7.4667E-7,8.0667E-7,1.0333E-6,1.19E-6,1.2533E-6,8.3667E-7,6.3333E-7,5.6333E-7,7.9667E-7,9.2E-7,9.6333E-7,9.4333E-7,7.7E-7,7.6333E-7,8.1333E-7,-3.7333E-7,5.8667E-7,-2.0E-8,-4.3E-7,1.14E-6,8.2E-7,7.0333E-7,1.3233E-6,7.8333E-7,7.0935E-4,5.3329E-4,2.6231E-4,3.4626E-4,3.2506E-4,2.9016E-4,2.5107E-4,2.0632E-4,2.5694E-4,2.9077E-4,2.7242E-4,2.3732E-4,2.0519E-4,2.5127E-4,2.8771E-4,2.7229E-4,2.3773E-4,2.0575E-4,2.5138E-4,2.88E-4,2.7324E-4,2.3908E-4,2.0539E-4,2.5033E-4,2.8722E-4,2.7269E-4,2.3914E-4,2.0572E-4,2.4932E-4,2.8815E-4,2.7327E-4,2.4015E-4,2.0469E-4,2.4978E-4,2.8526E-4,2.7509E-4,2.4034E-4,2.053E-4,2.4816E-4,2.8657E-4,2.7549E-4,2.4002E-4,2.0529E-4,2.4874E-4,2.8635E-4,2.7708E-4,2.4012E-4,2.0691E-4,2.4893E-4,2.8661E-4,2.7779E-4,2.4264E-4,2.0499E-4,2.4928E-4,2.8657E-4,2.7855E-4,2.4368E-4,2.0635E-4,2.4799E-4,2.8528E-4,2.7917E-4,2.4504E-4,2.0622E-4,2.4757E-4,2.868E-4,2.8024E-4,2.4403E-4,2.0546E-4,2.4812E-4,2.8506E-4,2.8096E-4,2.4513E-4,2.051E-4,2.476E-4,2.8389E-4,2.8035E-4,2.4598E-4,2.0517E-4,2.4643E-4,2.8489E-4,2.8134E-4,2.4694E-4,2.0586E-4,2.4591E-4,2.8572E-4,2.8058E-4,2.475E-4,2.0556E-4,2.4576E-4,2.8472E-4,2.8242E-4,2.4684E-4,2.0604E-4,2.4478E-4,2.8393E-4,2.8199E-4,2.4865E-4,2.051E-4,2.4529E-4,2.8258E-4,2.8248E-4,2.4918E-4,2.0565E-4,2.4436E-4,2.8242E-4,2.8375E-4,2.5109E-4,2.0603E-4,2.4472E-4,2.8359E-4,2.825E-4,2.505E-4,2.0696E-4,2.4343E-4,2.8171E-4,2.8506E-4,2.5242E-4,2.0712E-4,2.4214E-4,2.816E-4,2.8478E-4,2.513E-4,2.0641E-4,2.4249E-4,2.797E-4,2.8588E-4,2.5079E-4,2.0694E-4,2.409E-4,2.8049E-4,2.8696E-4,2.5145E-4,2.0689E-4,2.4176E-4,2.8045E-4,2.8623E-4,2.5424E-4,2.0695E-4,2.4194E-4,2.7976E-4,2.8775E-4,2.5444E-4,2.0751E-4,2.4084E-4,2.8073E-4,2.8781E-4,2.5497E-4,2.0774E-4,2.3951E-4,2.7882E-4,2.8697E-4,2.5741E-4,2.0794E-4,2.4025E-4,2.7908E-4,2.8948E-4,2.5715E-4,2.0778E-4,2.3861E-4,2.782E-4,2.8806E-4,2.5842E-4,2.0885E-4,2.3915E-4,2.7729E-4,2.8943E-4,2.5807E-4,2.0735E-4,2.3725E-4,2.773E-4,2.8892E-4,2.5859E-4,2.0763E-4,2.3691E-4,2.7706E-4,2.8804E-4,2.5917E-4,2.0938E-4,2.369E-4,2.7749E-4,2.8932E-4,2.5877E-4,2.0882E-4,2.3573E-4,2.7593E-4,2.8942E-4,2.6105E-4,2.0946E-4,2.3565E-4,2.7541E-4,2.8909E-4,2.6176E-4,2.0858E-4,2.3598E-4,2.7439E-4,2.8951E-4,2.6233E-4,2.0919E-4,2.3549E-4,2.7471E-4,2.8976E-4,2.6346E-4,2.1041E-4,2.3626E-4,2.7408E-4,2.9234E-4,2.6457E-4,2.1074E-4,2.3504E-4,2.7232E-4,2.9028E-4,2.6509E-4,2.1079E-4,2.3448E-4,2.7217E-4,2.9172E-4,2.6654E-4,2.107E-4,2.3449E-4,2.7159E-4,2.9109E-4,2.6596E-4,2.1065E-4,2.3293E-4,2.726E-4,2.916E-4,2.6797E-4,2.1136E-4,2.3343E-4,2.701E-4,2.9187E-4,2.6964E-4,2.1106E-4,2.3293E-4,2.695E-4,2.9117E-4,2.6925E-4,2.1118E-4,2.3188E-4,2.6937E-4,2.9123E-4,2.7108E-4,2.1208E-4,2.3062E-4,2.6884E-4,2.9304E-4,2.7083E-4,2.1292E-4,2.3052E-4,2.6746E-4,2.9147E-4,2.7114E-4,2.1214E-4,2.3036E-4,2.6827E-4,2.9244E-4,2.7241E-4,2.1278E-4,2.299E-4,2.6754E-4,2.9099E-4,2.7294E-4,2.1319E-4,2.302E-4,2.6664E-4,2.9123E-4,2.7303E-4,2.1434E-4,2.293E-4,2.6588E-4,2.9279E-4,2.7446E-4,2.1373E-4,2.2824E-4,2.6504E-4,2.9278E-4,2.7597E-4,2.1353E-4,2.2809E-4,2.6482E-4,2.9147E-4,2.7488E-4,2.1388E-4,2.2929E-4,2.6469E-4,2.92E-4,2.7657E-4,2.1405E-4,2.2665E-4,2.6405E-4,2.914E-4,2.7706E-4,2.1539E-4,2.284E-4,2.6356E-4,2.9222E-4,2.7678E-4,2.1423E-4,2.2712E-4,2.6221E-4,2.9114E-4,1.3264E-4:6
5.6E-7,9.0333E-7,-3.6667E-8,1.29E-6,1.1067E-6,1.9E-7,6.9E-7,-7.3333E-8,1.0733E-6,-9.0E-8,4.3333E-7,1.7533E-6,3.4E-7,1.0633E-6,4.6333E-7,6.1667E-7,1.3833E-6,-6.7667E-7,1.0733E-6,-5.0667E-7,1.5833E-6,8.9667E-7,1.5E-7,1.0067E-6,-3.0E-8,1.1867E-6,4.2333E-7,4.498E-5,6.8591E-4,5.6521E-4,4.0214E-4,2.9557E-4,2.6118E-4,2.1881E-4,2.8147E-4,3.0063E-4,2.516E-4,2.247E-4,2.1547E-4,2.6872E-4,2.9376E-4,2.5297E-4,2.2256E-4,2.1513E-4,2.6702E-4,2.9523E-4,2.5393E-4,2.2272E-4,2.1411E-4,2.6592E-4,2.9389E-4,2.5524E-4,2.2435E-4,2.1321E-4,2.6584E-4,2.931E-4,2.5615E-4,2.2441E-4,2.1443E-4,2.6498E-4,2.9475E-4,2.5777E-4,2.2482E-4,2.1449E-4,2.6459E-4,2.9329E-4,2.583E-4,2.2559E-4,2.1325E-4,2.6426E-4,2.9336E-4,2.61E-4,2.2564E-4,2.1342E-4,2.6417E-4,2.9472E-4,2.6099E-4,2.2646E-4,2.1264E-4,2.6339E-4,2.9503E-4,2.6212E-4,2.2764E-4,2.1193E-4,2.6435E-4,2.9325E-4,2.6178E-4,2.2883E-4,2.1227E-4,2.636E-4,2.9407E-4,2.6422E-4,2.2875E-4,2.1024E-4,2.6298E-4,2.9459E-4,2.6566E-4,2.3014E-4,2.1135E-4,2.6205E-4,2.9351E-4,2.6684E-4,2.3082E-4,2.1106E-4,2.624E-4,2.9454E-4,2.6736E-4,2.2925E-4,2.1083E-4,2.6139E-4,2.9314E-4,2.6842E-4,2.2995E-4,2.0937E-4,2.6078E-4,2.9289E-4,2.7064E-4,2.318E-4,2.0944E-4,2.6091E-4,2.9348E-4,2.7021E-4,2.3353E-4,2.097E-4,2.5952E-4,2.9217E-4,2.7113E-4,2.3392E-4,2.093E-4,2.5856E-4,2.9264E-4,2.7065E-4,2.3441E-4,2.097E-4,2.5878E-4,2.9089E-4,2.7172E-4,2.3443E-4,2.094E-4,2.5745E-4,2.9219E-4,2.7385E-4,2.3495E-4,2.1E-4,2.5682E-4,2.9125E-4,2.7471E-4,2.3534E-4,2.0905E-4,2.5734E-4,2.9309E-4,2.7409E-4,2.3681E-4,2.0945E-4,2.5731E-4,2.9108E-4,2.7645E-4,2.3783E-4,2.0823E-4,2.5536E-4,2.9001E-4,2.7728E-4,2.3683E-4,2.084E-4,2.5589E-4,2.8993E-4,2.7748E-4,2.386E-4,2.0786E-4,2.5306E-4,2.9094E-4,2.7975E-4,2.3971E-4,2.0767E-4,2.5333E-4,2.8965E-4,2.7838E-4,2.4074E-4,2.0833E-4,2.5056E-4,2.89E-4,2.803E-4,2.4271E-4,2.0704E-4,2.5077E-4,2.8844E-4,2.7966E-4,2.4287E-4,2.0711E-4,2.5049E-4,2.8883E-4,2.8233E-4,2.4265E-4,2.0816E-4,2.4996E-4,2.8853E-4,2.8107E-4,2.4424E-4,2.0749E-4,2.503E-4,2.8759E-4,2.8277E-4,2.4452E-4,2.0803E-4,2.4922E-4,2.8622E-4,2.8359E-4,2.4578E-4,2.0756E-4,2.4774E-4,2.8613E-4,2.8448E-4,2.4657E-4,2.0656E-4,2.4772E-4,2.856E-4,2.8525E-4,2.4733E-4,2.0845E-4,2.4648E-4,2.8513E-4,2.8551E-4,2.4973E-4,2.072E-4,2.4606E-4,2.8504E-4,2.856E-4,2.4907E-4,2.0915E-4,2.4596E-4,2.8399E-4,2.8697E-4,2.5074E-4,2.0767E-4,2.449E-4,2.8448E-4,2.8683E-4,2.5063E-4,2.0798E-4,2.443E-4,2.8282E-4,2.8783E-4,2.5269E-4,2.072E-4,2.4222E-4,2.8173E-4,2.8783E-4,2.516E-4,2.082E-4,2.4285E-4,2.8262E-4,2.8937E-4,2.5465E-4,2.0858E-4,2.4226E-4,2.824E-4,2.9047E-4,2.5517E-4,2.0856E-4,2.4075E-4,2.8111E-4,2.8942E-4,2.5556E-4,2.0799E-4,2.4002E-4,2.7971E-4,1.4474E-4:6
2.7927E-5,-0.0028497,0.0014761,-0.0023236,-9.2456E-4,0.0013044,-0.0021407,0.002804,-0.00265,1.1232E-6,0.0010514,-0.0034622,0.0026295,-0.0024229,2.5424E-4,1.8717E-4,-0.0034889,0.0029681,-0.0027096,1.1915,1.6426,0.80594,0.82403,1.0769,1.1274,0.97336,0.74212,0.72332,0.82198,0.92574,0.8328,0.65493,0.63304,0.75025,0.78744,0.71222,0.56442,0.54322,0.64608,0.72862,0.68101,0.55796,0.54016,0.64455,0.72731,0.67767,0.55575,0.53892,0.64289,0.72575,0.67558,0.55422,0.5387,0.64121,0.72559,0.67195,0.55252,0.53688,0.6392,0.72299,0.66977,0.54947,0.53374,0.63574,0.71868,0.66471,0.54838,0.53181,0.63655,0.71818,0.66355,0.54677,0.53222,0.63709,0.71735,0.66185,0.54659,0.53281,0.63658,0.71668,0.662,0.54542,0.53201,0.63753,0.71562,0.66165,0.54504,0.53344,0.63657,0.71561,0.66071,0.54436,0.53273,0.63734,0.71618,0.65932,0.54399,0.53354,0.63761,0.71608,0.65767,0.5429,0.53244,0.63598,0.71533,0.65719,0.54192,0.53276,0.63717,0.71586,0.65554,0.54111,0.53271,0.63671,0.71556,0.65447,0.54083,0.53297,0.6381,0.71557,0.65421,0.54005,0.5325,0.6381,0.71427,0.65394,0.54067,0.53274,0.63788,0.71519,0.65225,0.53954,0.53266,0.63835,0.71433,0.65235,0.53861,0.53321,0.6392,0.71502,0.65073,0.53868,0.53305,0.63825,0.71453,0.65019,0.53773,0.53348,0.63963,0.71315,0.65008,0.53747,0.5341,0.63926,0.71442,0.64832,0.53656,0.53351,0.63913,0.71514,0.64846,0.53574,0.53418,0.63998,0.71403,0.64818,0.5363,0.53414,0.64113,0.71478,0.64701,0.53521,0.53484,0.64077,0.71414,0.64625,0.53567,0.53535,0.6412,0.71424,0.64594,0.53535,0.53547,0.64151,0.71556,0.64418,0.53543,0.53498,0.64138,0.71589,0.64383,0.53482,0.53499,0.64196,0.7129,0.64289,0.53475,0.53482,0.64307,0.71421,0.0:6
-0.0026636,0.0023348,-0.0011652,-9.4554E-4,0.0015396,-0.0031483,0.0011215,-0.0022811,-0.0011191,0.0010594,-0.0029825,0.0017017,-0.0015096,-0.0012349,0.0010272,-0.0028069,0.0016714,-0.001956,1.8652,1.4714,0.75076,1.0429,1.0724,1.0256,0.82503,0.65235,0.71637,0.81043,0.82244,0.6904,0.5873,0.63898,0.75768,0.79572,0.67438,0.574,0.62461,0.74286,0.77395,0.65507,0.56661,0.61962,0.73781,0.7693,0.65115,0.56437,0.61788,0.73729,0.768,0.64862,0.56383,0.61925,0.73654,0.76718,0.64699,0.56387,0.61945,0.73767,0.76723,0.64572,0.56426,0.62117,0.73962,0.76658,0.64375,0.56372,0.62246,0.73975,0.76568,0.64132,0.56293,0.62304,0.74021,0.76568,0.6406,0.56212,0.62449,0.74121,0.76415,0.63884,0.56261,0.6234,0.74127,0.76262,0.63665,0.56137,0.62538,0.74155,0.76052,0.63541,0.56072,0.62556,0.74176,0.76063,0.63347,0.56091,0.62715,0.74269,0.75958,0.63239,0.55979,0.6282,0.74318,0.75818,0.63001,0.55977,0.62841,0.74258,0.75768,0.62807,0.55978,0.62837,0.7432,0.75626,0.62674,0.55962,0.62998,0.74395,0.75583,0.62498,0.55947,0.6302,0.74353,0.75506,0.62371,0.55942,0.63126,0.7447,0.75351,0.62242,0.55936,0.63305,0.74635,0.75164,0.62047,0.55852,0.63311,0.74728,0.75122,0.61957,0.55866,0.63453,0.74696,0.75043,0.61695,0.55923,0.63612,0.74811,0.74965,0.61592,0.55987,0.63756,0.74795,0.74785,0.61443,0.55974,0.63771,0.7483,0.74737,0.61316,0.55877,0.63865,0.74819,0.74651,0.61172,0.56001,0.64055,0.75124,0.74642,0.6116,0.55892,0.6422,0.75155,0.74587,0.60991,0.55976,0.64359,0.75187,0.74387,0.60825,0.56075,0.6447,0.75239,0.74319,0.60653,0.56071,0.64542,0.75351,0.74207,0.60646,0.56133,0.64608,0.75439,0.74104,0.60498,0.56106,0.64762,0.75333,0.73802,0.60323,0.0:6
-0.0029819,0.0019057,-8.1836E-4,-0.0027573,0.0023145,-0.0036694,0.0011366,-2.7572E-4,-0.0021064,0.0015777,-0.0037455,0.0022338,-0.0016373,-2.9197E-5,0.0022986,-0.0032858,0.0016831,-0.0025378,1.6936,1.5902,0.88802,0.97791,0.92871,0.83278,0.65961,0.57289,0.66485,0.75021,0.71601,0.58375,0.53965,0.62713,0.72335,0.69682,0.56941,0.53242,0.62017,0.71677,0.68987,0.56374,0.53096,0.61957,0.71598,0.68634,0.56129,0.53021,0.6199,0.71479,0.68302,0.55828,0.52906,0.62188,0.71465,0.68115,0.5572,0.52998,0.62249,0.71444,0.6794,0.5541,0.52971,0.62414,0.71413,0.67735,0.55281,0.52992,0.62565,0.71432,0.67528,0.55099,0.53124,0.62648,0.71383,0.67428,0.54865,0.53139,0.62723,0.71376,0.67081,0.54698,0.53192,0.62785,0.71436,0.66839,0.54483,0.53276,0.62916,0.71427,0.6666,0.54331,0.53324,0.63047,0.71458,0.66413,0.54225,0.53242,0.63218,0.71388,0.66083,0.54037,0.53265,0.63339,0.71268,0.6592,0.53916,0.53385,0.63514,0.71396,0.65766,0.53743,0.53366,0.637,0.71359,0.65542,0.53518,0.53591,0.63756,0.71311,0.65283,0.53389,0.53724,0.63823,0.713,0.6512,0.53211,0.53775,0.63928,0.71334,0.64878,0.53028,0.53782,0.64028,0.71319,0.64544,0.52896,0.53812,0.64146,0.71306,0.64368,0.52807,0.53933,0.6443,0.71274,0.64098,0.52734,0.5413,0.64495,0.71269,0.63808,0.52595,0.54192,0.64694,0.71197,0.6358,0.52528,0.54259,0.64799,0.7127,0.63364,0.52423,0.54354,0.64993,0.71053,0.63068,0.52258,0.54438,0.65087,0.7105,0.62792,0.52069,0.54561,0.65137,0.71105,0.62607,0.5206,0.54743,0.65336,0.70906,0.62397,0.51968,0.54802,0.65452,0.70978,0.62091,0.51889,0.54924,0.65636,0.70964,0.61914,0.51735,0.5508,0.65685,0.70783,0.61649,0.5176,0.55195,0.65798,0.70831,0.61369,0.51555,0.0:6
0.012942,-0.015435,-0.0041986,0.0079427,-0.017783,0.0085234,10.662,8.234,5.5379,3.6179,3.6151,3.8235,4.1023,3.6679,2.9129,2.9454,3.4362,3.7943,3.4894,2.8417,2.8723,3.3994,3.7635,3.4802,2.8411,2.8629,3.3934,3.7522,3.4822,2.8469,2.8579,3.3969,3.744,3.4944,2.8413,2.8559,3.3904,3.7419,3.5089,2.8386,2.8595,3.3838,3.74,3.5112,2.8475,2.8633,3.3692,3.7531,3.5205,2.845,2.8575,3.3706,3.7558,3.5136,2.8492,2.8565,3.3578,3.7613,3.5118,2.8554,2.8499,3.3537,3.7691,3.5181,2.8633,2.8499,3.3494,3.7757,3.5257,2.8676,2.8443,3.3515,3.7655,3.5247,2.8776,2.8373,3.3561,3.7657,3.5324,2.8776,2.8368,3.3482,3.753,3.5404,2.8851,2.8303,3.3447,3.7454,3.5553,2.8876,2.8352,3.3396,3.7388,3.5621,2.8842,2.8327,3.3306,3.745,3.5651,2.888,2.8329,3.3311,3.749,3.5647,2.891,2.8343,3.3111,3.7659,3.5712,2.8911,2.8305,3.3121,3.7661,3.5753,2.8949,2.8306,3.3089,3.7691,3.5745,2.9085,2.8228,3.3072,3.7697,3.5746,2.9133,2.8123,3.3129,3.7611,3.5775,2.9162,2.8162,3.3068,3.7532,3.5862,2.9221,2.8125,3.3106,3.752,3.5967,2.918,2.8136,3.3032,3.7471,3.6035,2.9285,2.8189,3.3008,3.7429,3.6085,2.9254,2.8199,3.295,3.7464,3.6133,2.9304,2.8145,3.2761,3.7503,3.6151,2.9338,2.8102,3.2733,3.7531,3.6123,2.9362,2.8116,3.2699,3.7567,3.6129,2.9426,2.8037,3.2699,3.7538,3.6211,2.95,2.8034,3.2656,3.7528,3.6162,2.9643,2.8023,3.2619,3.7487,3.6282,2.9584,2.7992,3.2655,3.7352,3.637,2.9655,2.7994,3.2598,3.7334,3.6427,2.9678,2.7954,3.2518,3.7326,3.6492,2.974,0.0:6
-0.0035981,-0.014476,0.010904,-0.01833,0.0042756,-0.0029787,-0.016058,0.011272,-0.019495,0.0074177,0.002365,-0.014855,0.013096,-0.02054,-0.0018468,-0.0039588,-0.011686,0.010111,-0.024147,0.0061182,5.3524E-4,-0.012553,0.013322,-0.016439,10.113,8.3448,5.1791,3.7287,3.7154,4.1012,4.072,3.4308,2.8708,3.0668,3.6328,3.7571,3.2665,2.7782,2.9929,3.5906,3.7221,3.2507,2.7737,2.9801,3.5868,3.712,3.2494,2.7688,2.9773,3.5925,3.7097,3.2575,2.7682,2.9859,3.5925,3.7109,3.2582,2.7696,2.9873,3.5951,3.717,3.2587,2.7651,2.993,3.5858,3.7206,3.2624,2.7622,2.995,3.5816,3.7312,3.2654,2.7614,2.99,3.5766,3.7332,3.2591,2.7652,2.9946,3.582,3.7456,3.2534,2.7755,2.9928,3.5818,3.7408,3.2528,2.7747,2.9823,3.5862,3.7444,3.2506,2.7748,2.9796,3.5857,3.7425,3.2492,2.7795,2.9797,3.5945,3.7355,3.2595,2.7848,2.9853,3.5883,3.7284,3.2592,2.7813,2.9856,3.5942,3.7311,3.2671,2.7781,2.988,3.5922,3.7339,3.2761,2.7757,2.989,3.5792,3.7349,3.2723,2.7743,2.9964,3.5766,3.7429,3.2669,2.7785,2.993,3.573,3.7493,3.2608,2.7759,2.9918,3.5708,3.7502,3.2615,2.775,2.9843,3.5826,3.7546,3.2619,2.78,2.9799,3.5773,3.7542,3.2575,2.7868,2.9806,3.5863,3.7483,3.2674,2.7805,2.9785,3.5979,3.7435,3.2725,2.7827,2.9784,3.5937,3.7375,3.276,2.7819,2.9802,3.5908,3.7395,3.2799,2.7796,2.981,3.5916,3.7457,3.2841,2.7779,2.9936,3.579,3.7457,3.2814,2.7741,2.9924,3.5721,3.7555,3.2765,2.7757,2.9901,3.5659,3.7602,3.2686,2.7785,2.9849,3.5737,3.7649,3.2692,2.7856,2.9828,3.5769,3.771,3.2761,2.7892,2.9768,3.5838,0.0:6
0.021289,-7.5606E-4,-0.0040222,0.022833,-0.015681,0.024613,0.0020849,6.6153E-4,0.022536,-0.020382,0.02954,0.0014722,13.327,13.69,7.6291,9.1248,8.3372,7.4827,5.9076,5.1384,6.0721,6.5793,6.3441,5.1382,4.7388,5.5954,6.2521,6.1315,5.0023,4.6382,5.4904,6.1759,6.0796,4.9804,4.6211,5.47,6.1684,6.1007,4.9911,4.6163,5.4595,6.167,6.1032,5.0145,4.6079,5.4441,6.1575,6.1096,5.0205,4.6049,5.4354,6.1443,6.1219,5.0401,4.6008,5.422,6.1489,6.1307,5.0481,4.6018,5.4124,6.1426,6.1419,5.0619,4.5961,5.3952,6.1506,6.1527,5.0749,4.5945,5.3817,6.1308,6.1639,5.0858,4.5937,5.3768,6.138,6.1669,5.0942,4.5934,5.361,6.1326,6.1833,5.1066,4.5909,5.3479,6.1313,6.1887,5.1264,4.5938,5.3347,6.114,6.2,5.1325,4.5882,5.3246,6.1146,6.2032,5.1464,4.587,5.3135,6.1085,6.2118,5.1671,4.5838,5.2992,6.0949,6.2221,5.1785,4.5847,5.2872,6.099,6.2402,5.196,4.5796,5.2809,6.0837,6.2308,5.2056,4.5765,5.2625,6.0793,6.2424,5.224,4.5782,5.2515,6.0698,6.2417,5.2346,4.5832,5.2484,6.064,6.249,5.2539,4.5848,5.2284,6.0572,6.2516,5.2611,4.5822,5.227,6.0596,6.2677,5.2858,4.5848,5.2159,6.0546,6.2589,5.299,4.5914,5.2017,6.0375,6.2793,5.3168,4.5891,5.1908,6.039,6.268,5.3367,4.5942,5.1819,6.0275,6.2745,5.3531,4.5955,5.1688,6.0218,6.2844,5.3651,4.5969,5.1616,6.0235,6.2878,5.3782,4.6038,5.1374,6.0031,6.2866,5.3985,4.6065,5.1267,5.9955,6.2911,5.4208,4.6032,5.1152,5.9933,6.2926,5.4304,4.6117,5.1045,5.9777,6.2923,5.4472,4.6144,5.0952,5.9797,6.2969,5.459,4.6159,0.0:6
0.028449,-0.01265,0.01434,23.815,11.92,8.087,7.871,8.1671,7.6828,6.1091,5.1929,5.6526,6.4917,6.5391,5.4473,4.7586,5.2815,6.187,6.3249,5.3225,4.677,5.1877,6.1172,6.2811,5.3025,4.6479,5.1595,6.0948,6.2652,5.3116,4.6603,5.1426,6.0808,6.2722,5.3261,4.6456,5.1289,6.0692,6.2767,5.3359,4.6544,5.1091,6.08,6.2806,5.3578,4.6567,5.102,6.0632,6.2803,5.3675,4.6554,5.087,6.0557,6.2885,5.3842,4.6621,5.0798,6.0483,6.2817,5.4027,4.6662,5.0713,6.0427,6.2951,5.4155,4.6707,5.0666,6.0343,6.2914,5.4409,4.6756,5.0532,6.0198,6.3023,5.4467,4.6742,5.0481,6.0165,6.2991,5.4642,4.6798,5.027,6.0083,6.3015,5.469,4.6756,5.0274,6.0044,6.3031,5.495,4.6917,5.0142,5.9962,6.3013,5.5136,4.6832,5.0056,5.9845,6.3014,5.522,4.6968,4.994,5.9778,6.3061,5.5442,4.6852,4.9849,5.9647,6.3091,5.559,4.6993,4.9834,5.9708,6.3191,5.5705,4.7021,4.9713,5.9563,6.3056,5.5899,4.711,4.9608,5.9486,6.3154,5.61,4.715,4.949,5.9419,6.3153,5.613,4.7165,4.9383,5.932,6.311,5.6358,4.7234,4.9338,5.929,6.3077,5.6511,4.7298,4.9234,5.9112,6.3155,5.6606,4.7305,4.9149,5.9061,6.3081,5.6774,4.7393,4.9094,5.8977,6.3121,5.6843,4.746,4.8909,5.8863,6.3152,5.7109,4.7502,4.8917,5.8843,6.32,5.7193,4.7529,4.8816,5.8712,6.3081,5.733,4.7544,4.872,5.8581,6.3152,5.7481,4.7676,4.8643,5.847,6.3084,5.7667,4.7731,4.8564,5.8358,6.3065,5.7681,4.7767,4.8484,5.831,6.3118,5.7869,4.7942,4.8387,5.8221,6.3111,5.7959,4.7956,4.8381,5.7999,6.3026,5.8084,0.0:6
0.0043404,0.020623,-0.013155,0.019566,-0.0062176,0.0047411,0.01253,-0.016916,2.787,21.875,13.582,9.7997,5.8753,7.075,6.99,7.2792,6.2839,4.9591,5.3848,6.1797,6.5213,5.7863,4.743,5.1095,5.9954,6.369,5.7026,4.7081,5.0373,5.9472,6.3366,5.6993,4.6941,5.0232,5.9194,6.3355,5.7036,4.7006,5.0082,5.9098,6.3403,5.7182,4.7012,4.9983,5.9027,6.3323,5.735,4.7049,4.9874,5.8944,6.3453,5.7447,4.719,4.9775,5.8746,6.3416,5.769,4.7214,4.9743,5.8664,6.3418,5.7832,4.7317,4.9555,5.8549,6.3394,5.8022,4.7367,4.9481,5.8458,6.3401,5.8107,4.7409,4.9416,5.8326,6.3457,5.834,4.7479,4.9317,5.8275,6.3374,5.8386,4.7541,4.923,5.8212,6.3418,5.8565,4.7697,4.9108,5.7993,6.3449,5.8628,4.7618,4.9066,5.7915,6.3436,5.8862,4.7771,4.8963,5.7858,6.341,5.8971,4.7872,4.884,5.7689,6.3338,5.9039,4.7902,4.8813,5.7562,6.3385,5.9194,4.7947,4.8724,5.7393,6.345,5.9342,4.8143,4.8616,5.7365,6.3401,5.9425,4.8124,4.8628,5.723,6.332,5.963,4.8252,4.8484,5.7126,6.3368,5.9757,4.8338,4.844,5.7004,6.3356,5.9864,4.8433,4.8323,5.6936,6.3435,5.9948,4.8496,4.824,5.6702,6.3302,6.0143,4.8535,4.8152,5.6607,6.3285,6.0231,4.8615,4.8146,5.6501,6.3288,6.036,4.8672,4.8054,5.642,6.3242,6.0418,4.8786,4.803,5.627,6.3232,6.0636,4.8938,4.795,5.619,6.3225,6.0775,4.9007,4.7887,5.6038,6.3125,6.0873,4.902,4.786,5.5922,6.3108,6.0933,4.9129,4.7754,5.5804,6.305,6.1029,4.921,4.7684,5.5675,6.309,6.121,4.9276,4.7593,5.5571,6.3083,6.1286,4.9471,4.7598,5.5437,0.0:6
-0.0090892,0.025733,-0.015882,0.019812,0.0029602,-0.0092756,0.029786,-0.019503,6.8298,4.3662,3.0083,2.0135,2.1556,2.4068,2.4607,2.1697,1.8316,1.8882,2.314,2.3966,2.1527,1.8281,1.8843,2.3136,2.4061,2.1545,1.8328,1.8715,2.3049,2.4129,2.1734,1.8398,1.8681,2.3043,2.4225,2.1831,1.8437,1.8677,2.3041,2.4213,2.1956,1.8376,1.8634,2.2955,2.4256,2.2038,1.8597,1.8552,2.2971,2.4316,2.2169,1.8558,1.8502,2.2953,2.4238,2.2185,1.8632,1.8515,2.29,2.4309,2.2335,1.8711,1.8467,2.2825,2.4307,2.2403,1.8731,1.8477,2.2845,2.4417,2.2483,1.8745,1.8373,2.2795,2.4379,2.2591,1.8834,1.8414,2.2721,2.4388,2.2686,1.8908,1.8358,2.2625,2.4405,2.2785,1.8917,1.8374,2.2556,2.4383,2.2813,1.89,1.8315,2.2519,2.4456,2.2912,1.9012,1.8261,2.2504,2.4455,2.3096,1.9006,1.8216,2.2462,2.442,2.3133,1.9119,1.813,2.2378,2.4468,2.3191,1.9133,1.8205,2.2382,2.4466,2.3239,1.9213,1.8189,2.2285,2.4408,2.3354,1.9286,1.8195,2.2276,2.4485,2.3396,1.9368,1.816,2.2222,2.4471,2.3573,1.9386,1.8085,2.2145,2.4378,2.3633,1.9439,1.8074,2.2073,2.4421,2.3686,1.9476,1.8058,2.2,2.4393,2.3802,1.9573,1.7946,2.1947,2.4411,2.3833,1.9654,1.8029,2.1917,2.4329,2.3886,1.9682,1.7983,2.1811,2.4345,2.3969,1.9724,1.7933,2.1808,2.4342,2.4067,1.9831,1.7934,2.1775,2.4279,2.3973,1.9863,1.7924,2.1664,2.4347,2.4189,1.9968,1.7853,2.1649,2.4234,2.4153,2.0029,1.788,2.1602,2.4253,2.4195,2.0089,1.7825,2.1528,2.4239,2.4212,2.0149,1.7874,2.1454,2.4269,2.4263,2.0248,1.7822,2.1389,2.4189,0.0:6
0.025938,-0.0012269,0.0052618,0.025825,-0.020186,0.029526,-0.007813,0.008849,0.017202,-0.019275,2.3461,6.0603,3.834,2.7941,1.9029,2.2581,2.4431,2.4367,2.159,1.7528,2.0364,2.3538,2.3895,2.1476,1.7493,2.0206,2.3462,2.3958,2.1538,1.7536,2.0164,2.3383,2.3977,2.1699,1.7574,2.0092,2.342,2.4042,2.1755,1.7604,2.0092,2.3346,2.411,2.1909,1.7659,2.0058,2.326,2.411,2.2012,1.7745,1.9918,2.3314,2.4219,2.2131,1.7779,1.9773,2.3164,2.4244,2.2204,1.7781,1.9806,2.3109,2.433,2.2376,1.784,1.9698,2.3074,2.4323,2.2458,1.7844,1.9718,2.2995,2.4345,2.2521,1.7954,1.9562,2.2986,2.4356,2.2622,1.7954,1.9607,2.2844,2.4407,2.2731,1.802,1.9453,2.2724,2.4419,2.2853,1.8072,1.9477,2.2704,2.4487,2.2928,1.8128,1.9389,2.2692,2.4555,2.3107,1.8215,1.9334,2.2574,2.4545,2.3178,1.8201,1.9245,2.2434,2.455,2.3217,1.826,1.9271,2.2458,2.459,2.328,1.835,1.9267,2.2307,2.4597,2.3402,1.8403,1.9133,2.22,2.4598,2.355,1.847,1.9162,2.2149,2.4587,2.3638,1.8573,1.906,2.1986,2.4603,2.3707,1.8549,1.9037,2.195,2.462,2.3755,1.8656,1.8994,2.1907,2.4693,2.3843,1.8729,1.8912,2.1868,2.4629,2.3995,1.8801,1.8894,2.1753,2.4629,2.4042,1.8883,1.8856,2.169,2.4584,2.4087,1.8971,1.8838,2.1579,2.4563,2.4192,1.9041,1.8773,2.1604,2.4584,2.4238,1.9031,1.877,2.1415,2.4591,2.4397,1.9081,1.8674,2.139,2.4555,2.4413,1.9216,1.8664,2.1318,2.4575,2.4476,1.9245,1.864,2.1239,2.4464,2.4559,1.9394,1.8605,2.1105,2.4533,2.4565,1.9444,1.8681,2.1048,2.4553,2.4588,1.9556,0.0:6
0.0049516,-0.018848,0.0069506,-0.0095026,-0.010785,8.8775E-4,-0.014465,0.0028759,-0.011545,-0.016691,-6.514E-4,-0.017183,0.0015616,-0.013337,-0.015525,0.0089967,-0.020764,0.0011374,-0.0074422,-0.014288,-4.5053E-4,-0.015632,0.004624,-0.0084272,-0.014833,0.0021252,-0.018922,0.0038535,-0.008077,-0.011174,2.3935,5.5652,4.5735,3.7354,2.9179,2.2658,1.9802,2.3516,2.4394,2.1949,1.8107,1.7143,2.0913,2.2582,2.0783,1.7303,1.6564,2.0443,2.2162,2.0575,1.712,1.6534,2.0305,2.2137,2.0498,1.7125,1.6508,2.0359,2.2158,2.0561,1.7151,1.6457,2.0258,2.2223,2.0571,1.7156,1.6536,2.0267,2.2249,2.0624,1.7161,1.6544,2.0236,2.2259,2.0623,1.7181,1.6568,2.0284,2.2253,2.0621,1.7165,1.6507,2.0271,2.2232,2.0588,1.7139,1.6521,2.0329,2.2272,2.0669,1.7214,1.6588,2.0329,2.2299,2.0684,1.7179,1.6615,2.0403,2.2378,2.0615,1.7191,1.6565,2.035,2.2353,2.0748,1.7184,1.6622,2.0423,2.235,2.0751,1.723,1.6606,2.0357,2.2344,2.0712,1.7243,1.6642,2.0403,2.2396,2.0704,1.7217,1.6625,2.0431,2.2414,2.074,1.7242,1.6648,2.042,2.2469,2.075,1.7256,1.6649,2.038,2.2414,2.0831,1.7239,1.6623,2.046,2.2437,2.0727,1.7237,1.6617,2.045,2.2463,2.0768,1.7251,1.6661,2.0471,2.2462,2.079,1.7251,1.6681,2.0459,2.2485,2.0841,1.7281,1.6656,2.0449,2.2467,2.0801,1.729,1.6681,2.0434,2.2472,2.0808,1.7274,1.668,2.0377,2.2498,2.085,1.731,1.6691,2.0406,2.2541,2.0847,1.7227,1.6659,2.0446,2.2532,2.0837,1.7309,1.6701,2.0462,2.2474,2.0788,1.7307,1.6698,2.044,2.2464,2.085,1.7264,1.6734,2.0489,2.2516,2.0848,1.7352,1.678,2.0456,2.2562,2.0921,0.0:6
-0.018523,0.0061674,-0.019019,-0.0010855,-0.0033011,-0.016769,0.0094467,-0.021666,0.0018063,-0.0089163,-0.025683,0.0058998,-0.017046,-8.2513E-4,-0.0075508,-0.023778,0.0014984,6.3074,5.5925,4.0164,2.5671,2.2916,2.2288,2.5223,2.4639,1.9062,1.7529,1.9168,2.2121,2.2496,1.7911,1.6597,1.8513,2.1551,2.2071,1.7725,1.6493,1.8403,2.1522,2.2046,1.7612,1.6511,1.8376,2.1517,2.2094,1.7636,1.6509,1.8412,2.1543,2.2041,1.7643,1.6478,1.8527,2.1559,2.1988,1.7662,1.6464,1.8598,2.1588,2.2026,1.764,1.6544,1.8565,2.1649,2.2043,1.7565,1.6552,1.8633,2.1665,2.2118,1.7623,1.6583,1.8608,2.1741,2.2064,1.7652,1.6565,1.8664,2.1763,2.2067,1.76,1.6545,1.8804,2.1791,2.2091,1.7617,1.6592,1.8784,2.174,2.2028,1.7602,1.6592,1.8814,2.1846,2.2113,1.7656,1.6659,1.8848,2.1874,2.2031,1.7614,1.6624,1.8879,2.1888,2.2097,1.7566,1.6672,1.8886,2.1897,2.2076,1.7645,1.6672,1.8972,2.1937,2.2053,1.7506,1.661,1.8946,2.1965,2.2002,1.7597,1.6675,1.9019,2.1955,2.1995,1.7537,1.6626,1.9098,2.1967,2.1988,1.7538,1.6681,1.9074,2.1944,2.2065,1.7495,1.6711,1.9132,2.1989,2.1961,1.751,1.677,1.9135,2.2008,2.1941,1.7503,1.6722,1.9178,2.2026,2.1971,1.7506,1.6697,1.9198,2.2012,2.1962,1.7437,1.6714,1.9252,2.2127,2.1938,1.7481,1.6761,1.9195,2.2003,2.1857,1.7458,1.6767,1.9282,2.2038,2.1935,1.7373,1.6759,1.9248,2.2099,2.1929,1.7398,1.6751,1.9366,2.2124,2.1849,1.7391,1.6779,1.9403,2.2159,2.1922,1.7395,1.6747,1.9435,2.2103,2.1911,1.7364,1.6803,1.946,2.2122,2.1903,1.7359,1.6821,1.9462,2.2163,2.1909,0.0:6
0.006233,-0.018535,-0.0074028,0.0051761,-0.029793,0.0080546,-0.015324,-0.0089984,0.0012716,-0.021438,0.011581,-0.017843,-0.0050365,-0.0027996,-0.01936,0.0024092,-0.018175,-0.0086179,-0.0011988,-0.015399,8.9406E-4,-0.015657,-0.0058729,-0.0076571,1.3001,5.4738,4.8049,3.7513,2.8486,2.211,2.0507,2.3796,2.4261,2.1836,1.7352,1.7834,2.1056,2.2447,2.0697,1.6656,1.7335,2.0625,2.2058,2.0492,1.651,1.7197,2.0459,2.2056,2.0499,1.6499,1.7212,2.0503,2.1993,2.0475,1.651,1.7161,2.0523,2.2117,2.0502,1.6525,1.7185,2.055,2.2128,2.0507,1.6519,1.7163,2.044,2.2175,2.057,1.6607,1.7193,2.0507,2.218,2.0612,1.6606,1.7193,2.0471,2.2242,2.0706,1.6551,1.7209,2.0379,2.2248,2.0534,1.662,1.7198,2.0395,2.2224,2.058,1.6624,1.7193,2.0478,2.225,2.0632,1.6631,1.7169,2.0472,2.2196,2.0605,1.6703,1.7156,2.0443,2.2226,2.0682,1.6661,1.715,2.0439,2.2304,2.0705,1.6713,1.7198,2.0365,2.2324,2.0678,1.6745,1.7161,2.0389,2.2302,2.0711,1.6716,1.7169,2.0411,2.2407,2.0788,1.6741,1.7145,2.0376,2.231,2.0832,1.6795,1.7155,2.0423,2.232,2.0818,1.6774,1.7156,2.0326,2.236,2.0769,1.6814,1.7089,2.0409,2.2324,2.0856,1.6801,1.7164,2.0411,2.2316,2.0839,1.6803,1.7119,2.0415,2.2344,2.085,1.6807,1.7128,2.0327,2.2376,2.0881,1.6826,1.7144,2.0311,2.2407,2.0811,1.685,1.7089,2.0381,2.2412,2.0917,1.6862,1.7065,2.0316,2.2424,2.0908,1.6853,1.7069,2.0308,2.2367,2.096,1.6895,1.7118,2.0268,2.233,2.0945,1.6888,1.7058,2.0294,2.2379,2.1009,1.6881,1.7082,2.0249,2.243,2.1031,1.6947,1.7111,2.0279,2.2415,2.1036,1.6909,0.0:6
-0.0027218,-0.017472,0.010209,-0.022711,5.5239E-4,-0.010027,-0.017862,0.011739,-0.021271,-4.1437E-6,-0.012779,-0.019892,0.0095694,-0.022701,0.0010926,-0.0090081,-0.014477,0.0085243,-0.024936,0.0034722,9.3667,8.5386,3.9495,4.9471,4.4688,4.6398,4.0196,3.1427,3.4252,4.0202,4.1929,3.7391,3.1065,3.3133,3.9901,4.1716,3.7087,3.1125,3.3,3.9922,4.1737,3.704,3.1048,3.2983,3.9958,4.1734,3.7056,3.1107,3.3004,3.9992,4.1763,3.7024,3.1078,3.3017,3.9969,4.1753,3.7015,3.1105,3.3006,4.0017,4.1897,3.7004,3.1152,3.306,3.9976,4.1924,3.6928,3.1125,3.3053,4.0139,4.1937,3.6979,3.1094,3.311,4.0131,4.1884,3.6964,3.1197,3.3155,4.0101,4.198,3.6957,3.1167,3.3121,4.0105,4.198,3.6902,3.1181,3.3183,4.0216,4.2074,3.6812,3.1191,3.3179,4.0194,4.1966,3.6837,3.1201,3.3146,4.0176,4.1969,3.6838,3.1192,3.3212,4.0279,4.2024,3.6831,3.1168,3.3247,4.0237,4.209,3.6786,3.1195,3.3322,4.024,4.2054,3.6804,3.1189,3.3331,4.0303,4.205,3.6832,3.1145,3.3368,4.0356,4.2138,3.6742,3.1189,3.3376,4.0387,4.2133,3.6803,3.1179,3.3398,4.04,4.2148,3.6702,3.1201,3.3413,4.0362,4.2172,3.6664,3.1159,3.3434,4.0379,4.2118,3.6699,3.1197,3.3427,4.0443,4.2157,3.6646,3.1243,3.347,4.0496,4.2212,3.6588,3.1192,3.346,4.0498,4.2072,3.6553,3.1155,3.3479,4.0489,4.2142,3.6643,3.1153,3.3551,4.0507,4.2116,3.6542,3.1143,3.3628,4.0582,4.212,3.6559,3.115,3.3609,4.0525,4.2123,3.6503,3.1184,3.3657,4.0555,4.2202,3.6491,3.112,3.3649,4.0575,4.2199,3.6444,3.1181,3.3677,4.0564,4.2185,3.6484,3.1146,3.3654,4.0646,0.0:6
-0.014483,0.011116,-0.02173,9.7874E-5,-0.016055,-0.014167,0.0069547,-0.0253,0.0067427,-0.013263,-0.0089814,0.014304,-0.027676,0.0092344,11.085,7.9681,4.7981,3.9847,4.293,4.5811,4.2389,3.4178,3.166,3.7503,4.2055,4.0241,3.319,3.1114,3.7213,4.1845,4.0152,3.3083,3.1089,3.7197,4.193,4.0072,3.3039,3.0992,3.7252,4.184,4.0028,3.3015,3.1109,3.7193,4.1903,3.9927,3.2957,3.1106,3.7255,4.1952,3.9984,3.2955,3.1111,3.7231,4.1997,4.0044,3.2964,3.1177,3.7366,4.2055,3.9961,3.2866,3.1199,3.7374,4.2034,3.983,3.2918,3.1246,3.7418,4.2044,3.9818,3.2829,3.1253,3.7434,4.2063,3.9816,3.283,3.122,3.748,4.2072,3.9771,3.2798,3.1236,3.7585,4.2101,3.9772,3.2764,3.1323,3.7627,4.2154,3.973,3.2739,3.1386,3.7725,4.2144,3.9688,3.2765,3.1308,3.7717,4.2231,3.9655,3.2648,3.1396,3.7734,4.213,3.9658,3.2683,3.1429,3.7805,4.2235,3.9654,3.2599,3.1441,3.7817,4.2188,3.9584,3.2585,3.1537,3.7836,4.2253,3.961,3.2591,3.1524,3.7932,4.231,3.9531,3.2523,3.1536,3.797,4.2361,3.9511,3.2521,3.1471,3.8031,4.237,3.9446,3.2452,3.1497,3.7977,4.2268,3.9405,3.2434,3.1541,3.8066,4.231,3.9389,3.2469,3.1633,3.812,4.2288,3.9325,3.244,3.1538,3.8161,4.2344,3.9299,3.2386,3.165,3.827,4.2297,3.9256,3.2358,3.1614,3.8226,4.2316,3.9279,3.233,3.174,3.824,4.2352,3.9154,3.2316,3.1731,3.8372,4.2383,3.9166,3.2286,3.1721,3.8337,4.244,3.9065,3.2286,3.1763,3.8401,4.2349,3.9077,3.2253,3.18,3.8503,4.2407,3.902,3.2245,3.1889,3.8509,4.2372,3.8925,3.2166,3.1855,3.8573,4.2491,0.0:6
-0.018535,-0.0043428,0.008253,-0.026399,0.01744,-0.02095,-0.0030169,0.0049814,-0.031943,0.016037,12.0,7.5094,5.4062,3.4384,3.6711,3.7021,4.1996,3.9246,3.0751,3.0816,3.5673,4.0147,3.8336,3.077,3.0318,3.5613,4.0058,3.8174,3.0828,3.0249,3.557,4.0013,3.8314,3.0893,3.0237,3.5547,4.0027,3.8289,3.0893,3.0299,3.5589,4.0141,3.846,3.1029,3.0327,3.5596,4.016,3.8507,3.1039,3.0315,3.5598,4.0165,3.8557,3.1092,3.0316,3.5492,4.035,3.8543,3.1193,3.0292,3.545,4.029,3.8604,3.1267,3.0299,3.543,4.0293,3.8525,3.1194,3.0231,3.5405,4.0252,3.8603,3.125,3.026,3.5332,4.0287,3.8652,3.1391,3.023,3.5393,4.0243,3.8768,3.1339,3.0268,3.5304,4.0299,3.8763,3.1366,3.0191,3.5271,4.0244,3.8763,3.1499,3.0241,3.5191,4.0368,3.8868,3.1506,3.0151,3.5225,4.0291,3.8808,3.1547,3.0184,3.5018,4.0226,3.8878,3.155,3.0084,3.5058,4.0252,3.8902,3.1611,3.0144,3.5089,4.0266,3.8831,3.1665,3.0103,3.5005,4.029,3.895,3.1659,3.0024,3.4994,4.0241,3.8955,3.1673,3.0049,3.4939,4.0239,3.8974,3.1796,3.0125,3.4893,4.0202,3.9053,3.1727,3.0049,3.4846,4.0314,3.9088,3.1903,3.0122,3.4924,4.0375,3.9182,3.1871,3.0099,3.4796,4.0297,3.9183,3.1951,3.0088,3.4782,4.0293,3.922,3.1915,3.0102,3.4811,4.0399,3.9251,3.2095,3.0117,3.4768,4.0197,3.9211,3.1909,3.0024,3.469,4.0289,3.9383,3.2118,2.9984,3.4635,4.0203,3.9323,3.2061,3.0028,3.4542,4.0226,3.9406,3.221,3.0004,3.4532,4.024,3.9326,3.2229,3.0039,3.4552,4.0213,3.9438,3.2292,3.0058,3.4391,4.0235,3.9459,3.2383,3.0093,0.0:6
0.0013285,-0.015546,0.013655,-0.017075,-0.0081478,0.0048271,-0.023526,0.015933,-0.023535,-0.010608,0.0020522,-0.025356,0.019393,-0.017955,-0.010169,0.010776,-0.024743,0.017246,-0.022483,-0.0082781,-0.002158,3.5112,9.1589,6.8538,5.3951,4.1517,3.3665,3.2977,3.9304,4.0541,3.6024,2.9602,3.1471,3.77,3.978,3.5632,2.9417,3.1408,3.7474,3.9816,3.5641,2.9357,3.1432,3.7661,3.9859,3.5709,2.9429,3.1477,3.767,3.9937,3.5787,2.9464,3.1558,3.7756,4.0026,3.5787,2.9514,3.1592,3.7756,4.0077,3.5852,2.9525,3.1656,3.7813,4.0172,3.5876,2.9592,3.1632,3.7808,4.0154,3.5889,2.9533,3.1632,3.7834,4.0128,3.5817,2.9595,3.1654,3.7831,4.0179,3.5878,2.9572,3.1695,3.7821,4.0219,3.5875,2.9586,3.1635,3.7841,4.0239,3.5863,2.956,3.1614,3.7858,4.0208,3.5864,2.9596,3.1758,3.7936,4.0283,3.5888,2.9631,3.1714,3.7821,4.0224,3.5803,2.9572,3.1709,3.7969,4.0311,3.5821,2.9593,3.1735,3.7878,4.0338,3.5846,2.968,3.1692,3.7925,4.0385,3.596,2.9472,3.1732,3.7969,4.0235,3.5859,2.9673,3.1782,3.7933,4.0361,3.5846,2.9592,3.1714,3.794,4.0343,3.5884,2.9671,3.18,3.7954,4.0323,3.5772,2.9627,3.1688,3.7987,4.0328,3.5886,2.9668,3.1786,3.8091,4.0441,3.5844,2.9728,3.1786,3.8053,4.0372,3.5889,2.9663,3.1797,3.7869,4.0473,3.5854,2.9632,3.1827,3.8036,4.0444,3.5919,2.9737,3.1814,3.8019,4.0512,3.5897,2.9662,3.1819,3.8064,4.0445,3.5861,2.9683,3.1881,3.7982,4.0404,3.5904,2.9672,3.1835,3.8054,4.0484,3.5841,2.9685,3.1821,3.8032,4.0408,3.5788,2.964,3.179,3.8104,4.0442,3.5781,2.973,3.1863,3.8157,4.0476,0.0:6
-0.0014945,-0.017832,0.016747,-0.026795,0.0046523,-0.007022,-0.020538,0.015421,-0.029141,0.016477,-0.011628,-0.020694,0.016757,-0.026245,0.008415,-0.011338,-0.014802,0.01115,-0.021704,0.0053989,-0.0019948,-0.018267,9.8888,7.3606,4.7492,5.2268,4.3918,3.1203,3.3376,3.7275,4.0912,3.7699,3.0601,3.0517,3.703,4.0245,3.7303,3.0694,3.0356,3.7072,4.0165,3.7205,3.0657,3.0271,3.707,4.011,3.7226,3.0748,3.032,3.7066,4.0212,3.7183,3.0755,3.0352,3.7034,4.0181,3.7223,3.078,3.0367,3.7091,4.0138,3.7154,3.0761,3.0285,3.7085,4.0262,3.7201,3.0749,3.0324,3.71,4.0316,3.711,3.0725,3.0315,3.7092,4.0312,3.7258,3.0754,3.0369,3.7122,4.0288,3.7236,3.0724,3.0468,3.7131,4.0401,3.7272,3.0775,3.0454,3.7196,4.0415,3.7274,3.0769,3.0425,3.7168,4.0423,3.7193,3.0777,3.0434,3.7164,4.0404,3.7199,3.08,3.0488,3.7185,4.0365,3.722,3.0802,3.0438,3.7209,4.031,3.7191,3.076,3.0535,3.7144,4.0411,3.7139,3.0754,3.0439,3.7203,4.049,3.7239,3.0785,3.0516,3.7158,4.0417,3.7168,3.0822,3.0451,3.7211,4.0492,3.7211,3.081,3.0538,3.7195,4.0464,3.727,3.0825,3.0471,3.7303,4.0471,3.7295,3.0794,3.052,3.7265,4.0498,3.729,3.0781,3.0598,3.727,4.047,3.7237,3.0816,3.0582,3.7205,4.0553,3.726,3.0809,3.0481,3.7192,4.0497,3.7161,3.0793,3.0523,3.7201,4.0487,3.7236,3.0737,3.0531,3.7269,4.0474,3.7157,3.0799,3.0508,3.7225,4.0453,3.7187,3.0726,3.0462,3.7215,4.0455,3.7184,3.0747,3.0549,3.7185,4.0509,3.7273,3.0787,3.0627,3.7276,4.0554,3.7163,3.0776,3.0634,3.7237,4.0513,3.7212,3.0716,3.0604,3.7272,0.0:6
1.9477,2.2405,3.4168,3.3748,2.0056,2.1123,2.5731,3.121,3.3148,1.8696,1.9314,2.0812,2.9412,3.1532,1.8726,1.9588,2.0908,2.9126,3.2084,1.8351,1.9517,2.048,2.9783,3.0956,1.8424,1.9395,2.0887,2.9278,3.1121,1.8056,1.8601,2.0015,2.9111,2.9393,1.8015,1.8257,1.9734,2.7717,3.0143,1.7987,1.8301,1.967,2.8189,3.01,1.7499,1.8397,1.9519,2.8219,3.0048,1.7585,1.8267,1.9425,3.1792,3.4336,1.8126,1.8104,1.9965,2.8401,2.9403,1.8417,1.8279,1.9707,2.9848,3.4083,2.2555,2.3355,2.0815,2.5474,2.0914,0.95882,0.82103,0.98041,1.3199,1.8778,0.83175,0.85088,0.96856,0.93567,1.8165,0.81683,0.85547,1.0705,1.0395,1.7295,0.7855,0.86365,0.954,0.94969,1.7872,0.78026,0.83749,0.91588,0.98264,1.703,0.80753,0.82313,0.93897,0.85299,1.7225,0.7852,0.83137,0.94609,1.0563,1.6845,0.81929,0.79285,0.86744,1.0497,1.6932,0.85455,0.83959,0.94303,1.1256,1.6701,0.86949,0.83237,0.99276,0.95809,1.675,0.85127,0.76385,1.008,1.1811,1.6812,0.81396,0.89301,0.94908,1.0615,1.7118,0.79485,0.83774,0.94025,1.1398,1.6328,1.0343,1.6636,1.9435,3.0907,2.7092,1.9502,2.3298,2.5773,4.4414,3.3425,2.4056,2.5329,2.6993,3.1731,2.5278,1.3888,1.6908,1.882,2.5698,2.3396,1.8717,1.6181,1.5442,2.3742,2.7094,1.4801,1.3911,1.5899,2.7904,2.2895,1.36,1.9056,2.0345,2.8804,2.2796,1.4999,1.6364,1.8355,2.5826,2.234,1.7712,1.6957,1.5536,2.1707,2.4622,1.3935,1.2991,1.4707,2.556,2.2293,1.3205,1.2332,1.2582,2.9596,2.0792,1.2488,1.8629,2.0284,2.7795,2.2151,1.7388,1.6711,1.5512,2.3972,2.4693,1.572,0.0:7
0.73758,0.88879,0.81852,1.8967,0.85841,0.77647,0.85063,0.8289,1.8586,0.81039,0.78145,0.95799,0.87125,1.7122,0.86737,0.83673,0.9118,0.85662,1.8982,0.81801,0.82664,0.94344,0.94484,1.8609,0.93653,0.89807,0.86255,0.90948,1.9444,0.78654,0.8145,0.89312,0.85845,1.7324,0.75604,0.94683,0.93291,0.86653,1.8779,0.77372,0.88739,0.91655,0.94391,1.8629,0.83945,0.91182,1.0132,2.176,4.0082,2.3135,2.4298,2.6856,2.8347,2.9386,1.2769,1.4363,1.3096,2.3503,3.2348,1.2175,1.2784,2.0083,1.7102,2.6738,1.5372,1.6142,1.4289,1.4603,3.0468,1.5633,1.3728,1.3357,1.8288,3.4651,1.4251,1.4472,1.63,2.1361,2.9132,1.2889,1.4099,1.8499,1.687,2.7183,1.4401,1.5577,1.5258,1.4729,3.0067,1.4505,1.3375,1.4377,1.8886,2.8243,1.1539,1.5119,1.3813,2.1273,3.6241,1.4634,1.4561,1.8314,1.7796,2.8449,1.5523,1.6371,1.6061,1.6246,3.2391,1.4659,1.3505,1.4709,1.9622,2.723,1.1864,1.4514,1.2639,2.0463,2.9363,1.1632,1.1629,1.8903,1.7756,3.3451,1.7208,1.6514,1.5759,1.7769,3.3723,1.6622,1.3408,1.4368,1.971,2.8321,1.1737,1.4039,1.278,2.0265,2.9119,1.0973,1.1955,1.9274,1.8214,3.467,1.4301,1.5857,1.5915,1.583,3.6263,1.8591,1.4584,1.5583,2.3669,2.7415,1.3676,1.5785,1.2596,2.2217,3.1365,1.2249,1.3176,1.9888,1.7362,2.6047,1.3399,1.6585,1.5369,1.6647,3.0878,1.6497,1.467,1.402,1.9362,3.4917,1.6085,1.3992,1.6359,2.4688,2.6244,1.0583,1.2287,2.0575,1.677,2.5051,1.3163,1.48,1.437,1.5901,3.1194,1.5245,1.3619,1.346,1.8216,3.0691,1.172,1.2326,1.138,2.0536,3.6582,1.4383,0.0:7
0.073049,0.091661,0.049793,0.12689,0.047106,0.063117,0.07651,0.082118,0.12885,0.049944,0.043882,0.053695,0.060184,0.1478,0.044628,0.046954,0.069191,0.069966,0.11871,0.05435,0.053827,0.064189,0.055033,0.13071,0.048196,0.063309,0.061346,0.051009,0.13942,0.050314,0.057333,0.056345,0.058726,0.1435,0.047168,0.056095,0.064367,0.078129,0.10822,0.061186,0.083966,0.065883,0.042948,0.12708,0.053726,0.055813,0.057556,0.053226,0.11915,0.058568,0.051062,0.070966,0.053101,0.14012,0.046388,0.041829,0.065437,0.054438,0.13981,0.051763,0.055544,0.064115,0.053659,0.1249,0.054273,0.060988,0.056319,0.048428,0.12032,0.055262,0.053443,0.054741,0.053178,0.14925,0.044205,0.043878,0.064962,0.047708,0.13789,0.051942,0.049274,0.06991,0.062324,0.11325,0.059422,0.069965,0.058159,0.053446,0.15443,0.04435,0.041638,0.051205,0.059718,0.13655,0.042372,0.042595,0.071176,0.05093,0.13334,0.053701,0.046383,0.071377,0.060643,0.13485,0.052352,0.078048,0.077334,0.051778,0.14172,0.064362,0.053445,0.057151,0.063498,0.14131,0.044753,0.052745,0.066687,0.069745,0.11049,0.048434,0.050555,0.064979,0.057638,0.11811,0.062316,0.074412,0.062041,0.051956,0.18067,0.054167,0.046817,0.055583,0.063661,0.13737,0.045673,0.042266,0.06384,0.05499,0.13399,0.051194,0.059481,0.079693,0.062302,0.13255,0.073339,0.052509,0.053203,0.053045,0.11115,0.063706,0.05376,0.064307,0.04941,0.13267,0.055087,0.041163,0.066343,0.061375,0.12929,0.064573,0.054046,0.070582,0.051993,0.10221,0.073225,0.057935,0.055276,0.05277,0.14576,0.047239,0.042255,0.057746,0.057415,0.13608,0.058181,0.041152,0.066394,0.069594,0.10786,0.066876,0.049784,0.066579,0.056299,0.11182,0.064475,0.06479,0.057998,0.052352,0.13285,0.086677,0.061662,0.05441,0.067617,0.12999,0.056573,0.04259,0.071812,0.060491,0.12225,0.07063,0.0:7
0.044322,0.093002,0.033462,0.040753,0.047915,0.042815,0.097441,0.037368,0.038118,0.042809,0.04365,0.096228,0.035382,0.048653,0.050156,0.043593,0.092127,0.038095,0.039957,0.039346,0.042609,0.098884,0.030991,0.038752,0.050642,0.059844,0.12241,0.04928,0.069151,0.075025,0.068101,0.11957,0.050819,0.056535,0.054385,0.073929,0.13491,0.051976,0.07704,0.058932,0.050841,0.13635,0.060773,0.057679,0.069824,0.085607,0.13846,0.038056,0.053026,0.058448,0.064966,0.12454,0.041327,0.060067,0.072041,0.067437,0.12822,0.050177,0.060278,0.055579,0.051305,0.12797,0.059159,0.068119,0.053554,0.055253,0.16974,0.04387,0.045918,0.066244,0.050683,0.13241,0.059335,0.050166,0.066898,0.069147,0.11736,0.055843,0.049574,0.061794,0.069611,0.16319,0.041596,0.051372,0.049716,0.063265,0.13826,0.03917,0.064579,0.062308,0.088092,0.11485,0.03905,0.062887,0.072186,0.063733,0.13585,0.046534,0.06887,0.061728,0.06078,0.14874,0.069197,0.07695,0.062188,0.07506,0.1804,0.046662,0.044347,0.06158,0.058421,0.13969,0.055145,0.06781,0.074109,0.06386,0.12421,0.048644,0.061898,0.052628,0.048678,0.15007,0.039539,0.047639,0.06273,0.058394,0.15382,0.045964,0.046552,0.060458,0.052694,0.14096,0.044004,0.064954,0.080042,0.06095,0.12402,0.064494,0.06273,0.059017,0.056307,0.1355,0.058186,0.061913,0.073525,0.086499,0.13983,0.048922,0.051864,0.065867,0.076603,0.12566,0.043155,0.066392,0.076214,0.082986,0.14049,0.05505,0.080391,0.064406,0.056649,0.13191,0.059091,0.062796,0.062379,0.064166,0.13472,0.042279,0.064762,0.060318,0.079855,0.1132,0.053646,0.053515,0.063671,0.06398,0.1137,0.059036,0.064493,0.056378,0.06151,0.17275,0.055488,0.052445,0.057292,0.058674,0.16564,0.046548,0.059704,0.06661,0.080465,0.10829,0.050031,0.062196,0.056926,0.075862,0.1233,0.064739,0.0667,0.06955,0.0:7
0.090649,0.03281,0.042937,0.045453,0.036334,0.098989,0.030472,0.034745,0.045911,0.043804,0.09227,0.031917,0.040762,0.045454,0.038717,0.10549,0.03046,0.035071,0.046693,0.045504,0.092792,0.032833,0.035999,0.050995,0.037433,0.10022,0.038295,0.033381,0.044594,0.04081,0.093883,0.037499,0.036835,0.05602,0.044739,0.12911,0.048825,0.080008,0.07786,0.08319,0.13595,0.046382,0.06198,0.077253,0.06865,0.14282,0.060392,0.057359,0.055422,0.060386,0.15828,0.045593,0.042965,0.054037,0.066135,0.13433,0.042376,0.061005,0.063692,0.087404,0.13717,0.063257,0.057174,0.079649,0.067635,0.1111,0.067263,0.067561,0.060386,0.056027,0.15518,0.043916,0.039994,0.053489,0.071636,0.14166,0.04448,0.046322,0.095495,0.080837,0.11166,0.049833,0.049323,0.056889,0.079317,0.11855,0.063686,0.064729,0.06894,0.05091,0.17405,0.05229,0.04029,0.053667,0.059492,0.15006,0.046445,0.055247,0.069094,0.07631,0.10734,0.048816,0.050982,0.063774,0.058141,0.11249,0.059474,0.069021,0.069064,0.055756,0.15279,0.056574,0.046166,0.058116,0.059232,0.15163,0.047683,0.041644,0.068686,0.065132,0.12754,0.049589,0.054814,0.069017,0.055152,0.11833,0.056684,0.055046,0.066463,0.057256,0.12413,0.06936,0.050757,0.055132,0.060204,0.15053,0.054334,0.049009,0.058167,0.084961,0.12879,0.063993,0.058187,0.076666,0.059095,0.10578,0.072987,0.076368,0.066735,0.058458,0.14988,0.075546,0.058135,0.072336,0.065009,0.13246,0.05594,0.043873,0.059256,0.055067,0.13519,0.058877,0.062621,0.069094,0.058177,0.099762,0.059348,0.063066,0.066936,0.059761,0.15827,0.055545,0.044239,0.055438,0.069249,0.12848,0.0577,0.049255,0.067341,0.068377,0.13919,0.062717,0.049202,0.068889,0.062639,0.12785,0.047892,0.055845,0.066991,0.05266,0.12556,0.074684,0.047544,0.051977,0.068163,0.12961,0.060593,0.064789,0.063107,0.069512,0.0:7
0.26289,0.2682,0.31546,0.51652,0.29066,0.29989,0.27358,0.29777,0.53203,0.26315,0.26661,0.28657,0.32414,0.54548,0.26876,0.27452,0.28107,0.33665,0.57685,0.2699,0.25761,0.25852,0.27911,0.53917,0.39599,0.3426,0.31446,0.37276,0.56914,0.29128,0.28324,0.39557,0.35567,0.63284,0.30523,0.38331,0.35594,0.35432,0.61253,0.37322,0.44161,0.3644,0.32893,0.71067,0.36041,0.32893,0.31598,0.47492,0.68403,0.3473,0.30152,0.31377,0.49873,0.70799,0.3325,0.36176,0.40836,0.41381,0.57905,0.38199,0.36547,0.49087,0.45529,0.65228,0.38097,0.5174,0.38895,0.34004,0.60819,0.50435,0.35303,0.31126,0.39835,0.82488,0.40636,0.4113,0.44588,0.60174,1.2094,0.40291,0.29869,0.29945,0.7269,1.2524,0.73042,0.6656,0.7359,0.90954,1.5453,0.87847,0.7687,0.86114,0.86884,1.4147,0.77384,1.001,0.37037,0.34691,0.66801,0.68181,0.40994,0.36019,0.37703,0.66077,0.6413,0.4795,0.3815,0.38885,0.77348,0.495,0.31068,0.3153,0.38718,0.76259,0.44163,0.32048,0.34458,0.48492,0.53247,0.44955,0.29857,0.39276,0.42103,0.53433,0.47596,0.3747,0.41347,0.39061,0.47195,0.44343,0.37035,0.31253,0.38412,0.50853,0.57418,0.31231,0.31361,0.34353,0.57244,0.51612,0.30984,0.29633,0.30001,0.6742,0.50537,0.30029,0.28956,0.35678,0.59728,0.45211,0.26997,0.30314,0.42362,0.45711,0.47936,0.2795,0.39686,0.32285,0.3579,0.46688,0.3809,0.31515,0.29763,0.3947,0.53582,0.38027,0.31844,0.28233,0.40107,0.63814,0.32907,0.26146,0.30208,0.51339,0.51341,0.28239,0.27465,0.3161,0.49263,0.57644,0.30171,0.31253,0.50351,0.86176,0.56072,0.27876,0.47028,0.42464,0.36424,0.59261,0.56284,0.70372,0.69059,1.0338,1.0133,0.69164,0.69276,0.74048,0.94084,0.97791,0.0:7
0.17019,0.38892,0.17704,0.18031,0.21866,0.21598,0.35013,0.17536,0.17772,0.18092,0.16981,0.3277,0.17301,0.16792,0.18088,0.16953,0.32442,0.17536,0.15101,0.16695,0.16745,0.33812,0.18017,0.14914,0.22783,0.21092,0.3921,0.19424,0.18252,0.32172,0.22672,0.34879,0.31669,0.3167,0.31283,0.29927,0.653,0.45551,0.43155,0.42575,0.30564,0.44046,0.33036,0.1938,0.18127,0.18657,0.3237,0.24889,0.24605,0.24505,0.21772,0.31219,0.2134,0.18344,0.23038,0.2209,0.42325,0.34851,0.42064,0.48584,0.43346,0.82773,0.34006,0.29619,0.25472,0.226,0.32727,0.23019,0.22101,0.23403,0.23113,0.33806,0.28613,0.21727,0.20751,0.19269,0.32702,0.28307,0.17622,0.19931,0.19694,0.38853,0.27473,0.1619,0.17977,0.18342,0.38182,0.24998,0.18122,0.20129,0.25808,0.46477,0.3662,0.28428,0.44976,0.44651,0.76442,0.47188,0.40685,0.47237,0.36506,0.50102,0.28201,0.32885,0.27348,0.27598,0.36251,0.43431,0.22769,0.2469,0.22782,0.33885,0.34873,0.21833,0.23827,0.23582,0.45716,0.30778,0.17646,0.23824,0.25057,0.36622,0.31014,0.18404,0.21685,0.2728,0.31611,0.30455,0.20142,0.30186,0.23663,0.28143,0.31089,0.22688,0.25933,0.24393,0.59768,0.53009,0.36582,0.47069,0.49067,0.83041,0.67371,0.39951,0.47542,0.38137,0.50026,0.35594,0.17648,0.254,0.2035,0.33082,0.33574,0.19517,0.20426,0.23746,0.31083,0.36777,0.17546,0.22825,0.27262,0.28345,0.44245,0.28601,0.31873,0.30603,0.67022,0.79005,0.37487,0.3928,0.24338,0.23602,0.49667,0.24242,0.17891,0.20076,0.33093,0.4024,0.23192,0.29727,0.20977,0.34663,0.36277,0.17467,0.19083,0.22269,0.32977,0.3754,0.19392,0.25848,0.25965,0.24823,0.34488,0.1749,0.24636,0.20739,0.22441,0.34721,0.2072,0.23764,0.0:7
-1.066E-5,-2.426E-5,-6.5833E-6,-2.14E-5,-2.37E-5,-1.1527E-5,-2.4673E-5,-6.4133E-6,-2.181E-5,-2.795E-5,-8.3467E-6,-2.5673E-5,-5.2633E-6,-2.0977E-5,-2.7463E-5,-1.2033E-5,-2.3007E-5,-7.98E-6,-2.2893E-5,-2.573E-5,-1.1113E-5,-2.7863E-5,-8.01E-6,-2.1443E-5,-2.5843E-5,-9.7033E-6,-2.6363E-5,-6.4333E-6,-2.0693E-5,-2.442E-5,-1.1437E-5,-2.4763E-5,-5.66E-6,-1.781E-5,-2.535E-5,-1.009E-5,-2.3223E-5,-5.0167E-6,-1.888E-5,-2.5977E-5,-1.4853E-5,-2.3597E-5,-8.6333E-6,-2.2187E-5,-2.5157E-5,-1.2453E-5,-2.38E-5,-8.5733E-6,-1.789E-5,-2.823E-5,-1.29E-5,-2.6783E-5,-6.01E-6,-2.0357E-5,-3.1537E-5,-1.1087E-5,-2.695E-5,-1.1857E-5,-2.2127E-5,-1.38E-6,-1.2847E-5,-2.406E-5,-9.0667E-6,-2.0023E-5,-3.219E-5,-1.2407E-5,-2.7447E-5,-1.024E-5,-2.6363E-5,-2.855E-5,-1.5133E-5,-2.8793E-5,-1.091E-5,-2.5133E-5,-3.1313E-5,-1.3473E-5,-1.7793E-5,6.02E-6,-1.9343E-5,-2.515E-5,-1.0697E-5,-2.532E-5,-7.78E-6,-2.172E-5,-3.017E-5,-9.68E-6,-2.6763E-5,-7.9067E-6,-2.245E-5,-2.8367E-5,-1.204E-5,-2.4427E-5,-1.1583E-5,-2.0127E-5,-2.2147E-5,-1.0447E-5,-2.487E-5,-6.5167E-6,-2.2763E-5,-2.88E-5,-9.7133E-6,-2.4657E-5,-4.0667E-6,-2.2433E-5,-2.8167E-5,-1.0863E-5,-2.5583E-5,-5.72E-6,-2.0803E-5,-2.6463E-5,-1.2277E-5,-2.4137E-5,-7.8967E-6,-1.8237E-5,-3.2277E-5,-1.1173E-5,-2.4157E-5,-6.8867E-6,-1.784E-5,-2.604E-5,-1.178E-5,-2.44E-5,-6.9667E-6,-2.1907E-5,-3.0417E-5,-1.162E-5,-2.2277E-5,-4.28E-6,-2.0673E-5,-2.6497E-5,-1.24E-5,-2.262E-5,-2.6033E-6,-2.265E-5,-2.5553E-5,-1.0697E-5,-2.5503E-5,-2.7067E-6,-2.1233E-5,-3.074E-5,-7.2767E-6,-3.0037E-5,-4.6867E-6,-2.075E-5,-2.6753E-5,-6.9733E-6,-2.5983E-5,-5.03E-6,-1.915E-5,-2.5763E-5,-7.3633E-6,-2.3177E-5,-7.6567E-6,-2.0573E-5,-2.4873E-5,-8.1967E-6,-2.7647E-5,-7.6567E-6,-1.915E-5,-2.7827E-5,-1.1843E-5,-2.699E-5,-7.4667E-6,-1.91E-5,-2.4037E-5,-1.2367E-5,-2.419E-5,-6.0667E-6,-2.0887E-5,-2.5037E-5,-9.2033E-6,-2.3163E-5,-7.6467E-6,-2.1607E-5,-2.448E-5,-1.2273E-5,-2.7297E-5,-5.4867E-6,-6.9233E-6,3.1976E-4,4.1147E-4,3.8967E-4,4.3358E-4,8.3618E-4,4.2816E-4,3.9557E-4,4.0823E-4,4.3466E-4,8.1712E-4,3.8733E-4,3.8629E-4,4.087E-4,4.24E-4,8.6941E-4,3.837E-4,3.8652E-4,3.9949E-4,4.2023E-4,8.2542E-4,3.94E-4,3.8474E-4,4.0369E-4,4.1928E-4,8.5575E-4,4.0598E-4,3.9798E-4,4.1498E-4,4.3202E-4,8.1407E-4,3.9136E-4,4.2253E-4,4.1216E-4,4.1839E-4,8.682E-4,3.8501E-4,3.8071E-4,4.0765E-4,4.2013E-4,8.1553E-4,3.8417E-4,3.9496E-4,4.0206E-4,4.2148E-4,8.2042E-4,4.0978E-4,4.241E-4,4.5506E-4,4.5615E-4,0.0010005,4.7664E-4,4.4005E-4,4.495E-4,4.5037E-4,9.3217E-4,6.092E-4,5.2339E-4,5.5704E-4,5.561E-4,0.0010599,6.3185E-4,5.2131E-4,5.5066E-4,5.4262E-4,0.001039,5.7179E-4,4.8648E-4,5.0025E-4,5.3054E-4,0.0010877,4.652E-4,4.7579E-4,5.0208E-4,4.7117E-4,0.0010024,4.7559E-4,4.7689E-4,5.2058E-4,4.8943E-4,9.58E-4,4.7237E-4,4.351E-4,5.1147E-4,5.0024E-4,9.4399E-4,4.9363E-4,5.4298E-4,6.9744E-4,0.0013514,0.0023573,5.0938E-4,4.1706E-4,4.5718E-4,4.3148E-4,8.3124E-4,3.9136E-4,4.3621E-4,4.2058E-4,4.2901E-4,8.6112E-4,3.8762E-4,4.09E-4,4.0875E-4,4.144E-4,8.3391E-4,3.8495E-4,4.3085E-4,4.272E-4,4.2258E-4,8.5867E-4,3.9859E-4,4.1445E-4,4.1472E-4,4.2634E-4,8.2599E-4,3.8297E-4,4.004E-4,4.3021E-4,4.2761E-4,8.4639E-4,4.0021E-4,3.8253E-4,3.9942E-4,4.2586E-4,8.2598E-4,3.7889E-4,3.9618E-4,4.5048E-4,4.4111E-4,8.3518E-4,3.9123E-4,4.1868E-4,4.3973E-4,6.0687E-4,8.441E-4,3.7509E-4,3.7825E-4,4.3986E-4,4.4125E-4,8.3566E-4,3.9131E-4,4.028E-4,4.1453E-4,4.3079E-4,8.3724E-4,3.7571E-4,3.7497E-4,4.2647E-4,4.5164E-4,8.5523E-4,3.7893E-4,4.181E-4,5.5505E-4,4.4937E-4,8.144E-4,3.8614E-4,3.8613E-4,4.1349E-4,4.4477E-4,8.6035E-4,3.8081E-4,4.0107E-4,4.0976E-4,4.1878E-4,8.2346E-4,3.8022E-4,3.8518E-4,3.9153E-4,4.4668E-4,8.5441E-4,3.958E-4,3.8681E-4,4.004E-4,4.2343E-4,8.311E-4,3.7963E-4,3.8086E-4,4.0615E-4,4.6684E-4,8.4679E-4,3.8779E-4,3.8714E-4,4.044E-4,4.1024E-4,8.0734E-4,3.8209E-4,3.7623E-4,3.934E-4,4.5433E-4,8.6716E-4,3.8155E-4,3.9716E-4,4.1644E-4,4.3136E-4,8.3888E-4,3.6085E-4,3.8031E-4,4.0798E-4,4.4062E-4,8.8473E-4,3.8264E-4,3.9684E-4,4.0581E-4,4.138E-4,8.2619E-4,3.6344E-4,3.7331E-4,4.0878E-4,4.1912E-4,8.8125E-4,3.8495E-4,3.9604E-4,3.9629E-4,4.1265E-4,8.2954E-4,3.5972E-4,3.9397E-4,3.9987E-4,4.0745E-4,8.941E-4,3.752E-4,3.9733E-4,3.9899E-4,4.2515E-4,8.1918E-4,3.5912E-4,3.9111E-4,4.1095E-4,4.2472E-4,8.9749E-4,3.7688E-4,4.044E-4,4.0388E-4,4.2848E-4,8.1038E-4,3.668E-4,3.8074E-4,3.955E-4,4.1982E-4,8.629E-4,3.8234E-4,4.0105E-4,3.949E-4,4.2959E-4,8.2131E-4,3.7788E-4,3.7782E-4,3.7758E-4,4.193E-4,8.9378E-4,3.8613E-4,3.9238E-4,4.0663E-4,4.265E-4,8.0681E-4,3.7011E-4,3.7436E-4,3.9426E-4,4.1547E-4,8.702E-4,3.953E-4,3.9699E-4,4.0903E-4,4.272E-4,8.316E-4,3.7143E-4,3.8967E-4,3.9534E-4,4.1939E-4,8.4634E-4,4.0662E-4,4.1429E-4,3.9831E-4,4.2235E-4,8.6271E-4,3.5485E-4,3.8196E-4,3.9607E-4,4.3138E-4,8.3635E-4,3.9808E-4,4.1346E-4,3.9576E-4,4.2401E-4,8.3038E-4,3.7097E-4,3.8119E-4,3.8799E-4,4.1546E-4,0.001244,5.5689E-4,5.843E-4,5.9467E-4,6.2705E-4,0.0011988,5.5319E-4,5.627E-4,5.9037E-4,6.2149E-4,0.0011903,5.6359E-4,5.8879E-4,5.9988E-4,6.1525E-4,0.0011935,5.4614E-4,5.6499E-4,5.8977E-4,6.1944E-4,0.0011951,5.7393E-4,5.6899E-4,4.589E-4,4.3427E-4,8.5366E-4,3.7061E-4,4.0459E-4,4.0552E-4,4.1695E-4,8.4661E-4,3.7316E-4,4.1829E-4,4.2334E-4,4.2508E-4,8.2167E-4,3.676E-4,3.8761E-4,4.0765E-4,4.3056E-4,8.497E-4,3.5978E-4,4.3216E-4,4.5577E-4,4.325E-4,8.2955E-4,3.7405E-4,3.9345E-4,3.9897E-4,4.2135E-4,8.3913E-4,3.5901E-4,3.9883E-4,4.3771E-4,4.4027E-4,8.373E-4,3.752E-4,3.9423E-4,3.9145E-4,4.2242E-4,8.6117E-4,3.6698E-4,3.9739E-4,4.3721E-4,4.517E-4,8.2516E-4,3.627E-4,3.836E-4,3.8824E-4,4.2861E-4,8.3462E-4,3.7041E-4,3.9139E-4,4.1747E-4,4.5318E-4,8.1796E-4,3.6748E-4,3.8621E-4,3.8959E-4,4.2903E-4,8.3911E-4,3.8634E-4,3.9102E-4,4.1331E-4,4.5494E-4,8.4442E-4,3.6334E-4,3.7968E-4,4.0858E-4,4.3301E-4,8.4468E-4,3.5163E-4,3.7693E-4,4.1399E-4,4.6412E-4,8.4221E-4,3.65E-4,3.837E-4,4.0347E-4,4.1031E-4,8.2242E-4,3.6091E-4,3.9289E-4,4.1437E-4,5.2549E-4,8.6263E-4,3.5703E-4,3.9054E-4,3.8514E-4,4.089E-4,8.6635E-4,3.5583E-4,3.8641E-4,4.1018E-4,4.5005E-4,8.471E-4,3.6199E-4,3.8716E-4,3.9465E-4,4.1892E-4,8.5393E-4,3.5494E-4,3.9011E-4,3.9544E-4,4.4427E-4,8.6816E-4,3.6011E-4,3.9227E-4,3.8393E-4,4.1177E-4,8.4753E-4,3.608E-4,3.808E-4,4.0008E-4,4.391E-4,8.6935E-4,3.5896E-4,3.8377E-4,3.891E-4,4.1858E-4,8.2779E-4,3.6159E-4,4.0359E-4,4.1261E-4,4.2165E-4,3.925E-4:7
-1.0773E-5,-2.7467E-5,-1.165E-5,-2.0807E-5,-3.11E-5,-1.4573E-5,-2.3963E-5,-1.5567E-5,-2.6603E-5,-2.966E-5,-9.34E-6,-2.844E-5,-1.4803E-5,-2.42E-5,-3.81E-5,-1.269E-5,-2.9117E-5,-1.1957E-5,-2.224E-5,-3.2433E-5,-1.033E-5,-2.744E-5,-1.1487E-5,-2.425E-5,-3.3393E-5,-1.0647E-5,-2.5737E-5,-1.5603E-5,-2.4077E-5,-3.499E-5,-1.187E-5,-2.9843E-5,-1.3873E-5,-2.1367E-5,-3.1763E-5,-1.119E-5,-2.7507E-5,-1.1113E-5,-2.0787E-5,-3.3483E-5,-9.0667E-6,-2.779E-5,-1.5027E-5,-2.1897E-5,-3.8557E-5,-1.0567E-5,-2.5233E-5,-1.2417E-5,-2.133E-5,-3.4837E-5,-8.75E-6,-2.7487E-5,-1.304E-5,-2.3317E-5,-3.411E-5,-1.18E-5,-2.5323E-5,-1.233E-5,-2.5803E-5,-3.452E-5,-1.14E-5,-2.5927E-5,-1.4477E-5,-2.6183E-5,-3.5087E-5,-1.0787E-5,-2.8363E-5,-1.5757E-5,-2.2653E-5,-3.075E-5,-1.0493E-5,-3.1403E-5,-1.4233E-5,-2.2943E-5,-3.4573E-5,-1.2697E-5,-3.0707E-5,-1.0363E-5,-2.3397E-5,-3.3407E-5,-1.491E-5,-2.6713E-5,-1.4453E-5,-2.1967E-5,-3.5623E-5,-1.2553E-5,-2.5737E-5,-1.433E-5,-2.268E-5,-3.328E-5,-1.2357E-5,-2.613E-5,-1.7747E-5,-1.876E-5,-3.6057E-5,-1.2213E-5,-2.4953E-5,-1.353E-5,-2.52E-5,-3.6677E-5,-1.2443E-5,-2.673E-5,-1.3487E-5,-2.3357E-5,-3.3937E-5,-1.247E-5,-2.8683E-5,-1.543E-5,9.8937E-4,0.0010183,-1.7503E-5,-1.2443E-5,-1.085E-5,-2.2423E-5,-3.3413E-5,-1.434E-5,-2.6047E-5,-1.2537E-5,-2.6663E-5,-3.6267E-5,-8.3333E-6,-2.2853E-5,-1.2383E-5,-2.6333E-5,-3.707E-5,-1.162E-5,-2.6447E-5,-1.13E-5,-2.4867E-5,-3.6943E-5,-9.62E-6,-2.7277E-5,-1.14E-5,-2.324E-5,-3.7223E-5,-1.209E-5,-3.1437E-5,-1.309E-5,-2.861E-5,-3.6483E-5,-1.322E-5,-3.0177E-5,-1.345E-5,-2.4917E-5,-3.6543E-5,-1.1083E-5,-2.8283E-5,-1.4967E-5,-2.3287E-5,-3.6463E-5,-1.3973E-5,-2.6873E-5,-1.351E-5,-2.1963E-5,-3.4417E-5,-1.275E-5,-2.915E-5,-1.407E-5,-2.59E-5,-3.28E-5,-1.0503E-5,-2.408E-5,-1.373E-5,-2.3043E-5,-3.2687E-5,-1.2073E-5,-2.5947E-5,-1.6373E-5,-2.449E-5,-3.4823E-5,-1.174E-5,4.479E-5,3.9396E-4,8.3014E-4,3.4516E-4,4.1155E-4,4.0741E-4,4.2988E-4,8.5745E-4,3.8587E-4,4.1816E-4,3.9839E-4,4.3054E-4,8.3569E-4,3.5759E-4,3.9183E-4,3.9665E-4,4.3273E-4,8.286E-4,3.848E-4,4.3254E-4,4.0848E-4,4.252E-4,8.3299E-4,3.6068E-4,3.9176E-4,4.0761E-4,4.2558E-4,8.354E-4,3.6056E-4,4.2591E-4,4.2081E-4,4.2504E-4,8.4144E-4,3.5208E-4,4.0177E-4,4.1276E-4,4.1676E-4,9.9133E-4,3.9311E-4,4.5894E-4,4.9018E-4,5.3962E-4,0.0010099,4.3666E-4,4.2965E-4,5.1068E-4,5.2677E-4,9.8156E-4,3.793E-4,4.8258E-4,5.0005E-4,5.0393E-4,0.0010193,4.1568E-4,5.4789E-4,5.2355E-4,5.733E-4,0.0010431,4.5148E-4,4.928E-4,5.5832E-4,5.4146E-4,9.7967E-4,5.0419E-4,4.7481E-4,5.0293E-4,5.2179E-4,0.0010759,5.1048E-4,4.9138E-4,5.5489E-4,5.266E-4,0.0010234,4.8297E-4,6.1159E-4,9.3939E-4,0.0018498,0.0014479,4.9095E-4,4.5383E-4,4.5315E-4,5.0998E-4,9.2163E-4,4.483E-4,4.0439E-4,3.9929E-4,4.4194E-4,8.8745E-4,3.7933E-4,4.0318E-4,4.0528E-4,4.6699E-4,8.5561E-4,3.648E-4,3.9086E-4,4.2915E-4,4.2721E-4,8.3755E-4,3.7734E-4,3.9267E-4,4.0543E-4,4.6146E-4,8.9431E-4,3.5144E-4,4.0357E-4,4.1877E-4,4.1983E-4,8.7541E-4,3.8138E-4,4.1151E-4,3.944E-4,4.4686E-4,8.9046E-4,3.6216E-4,4.0117E-4,4.0776E-4,4.1958E-4,8.3179E-4,3.7375E-4,3.9426E-4,3.9508E-4,4.3728E-4,8.8595E-4,3.713E-4,3.9928E-4,4.1704E-4,4.3123E-4,8.4177E-4,3.7288E-4,3.9756E-4,3.8355E-4,4.3107E-4,8.9368E-4,3.6973E-4,3.8043E-4,3.9662E-4,4.2094E-4,8.331E-4,3.6524E-4,3.9167E-4,3.8544E-4,4.1922E-4,9.3212E-4,4.1757E-4,3.9433E-4,5.5052E-4,6.1477E-4,9.0403E-4,3.6541E-4,3.9836E-4,4.0035E-4,4.161E-4,9.0383E-4,3.4982E-4,4.1998E-4,4.2048E-4,4.3191E-4,8.3403E-4,3.6397E-4,3.9795E-4,3.9799E-4,4.3313E-4,9.0134E-4,3.7849E-4,3.8389E-4,4.0194E-4,4.2207E-4,8.4224E-4,3.8037E-4,4.1064E-4,3.9399E-4,4.1253E-4,8.9349E-4,3.6321E-4,4.0479E-4,4.1304E-4,4.2883E-4,8.3599E-4,3.6266E-4,3.9567E-4,3.8512E-4,4.243E-4,8.7576E-4,3.7655E-4,3.9559E-4,4.035E-4,4.2032E-4,8.2771E-4,3.671E-4,3.9956E-4,3.8117E-4,4.2858E-4,8.4828E-4,3.9744E-4,3.9644E-4,3.8712E-4,4.3342E-4,8.1625E-4,3.6477E-4,3.92E-4,3.8583E-4,4.3586E-4,8.397E-4,3.918E-4,4.3214E-4,4.0798E-4,4.3099E-4,8.4989E-4,3.6521E-4,3.8883E-4,3.9747E-4,4.2457E-4,8.5254E-4,3.75E-4,4.0638E-4,4.066E-4,4.2044E-4,8.3602E-4,3.6707E-4,3.8687E-4,3.9019E-4,4.1717E-4,8.3271E-4,3.6922E-4,5.4876E-4,4.7513E-4,4.131E-4,8.5655E-4,3.6817E-4,4.0197E-4,3.9644E-4,4.1727E-4,8.5478E-4,3.5588E-4,4.2936E-4,4.1337E-4,4.1849E-4,8.4763E-4,4.8494E-4,4.2922E-4,3.8348E-4,4.2027E-4,8.3447E-4,3.5948E-4,4.3342E-4,4.2677E-4,5.9633E-4,8.4045E-4,3.7512E-4,4.0595E-4,3.9603E-4,4.2839E-4,8.4073E-4,3.5571E-4,4.3176E-4,4.3359E-4,4.4028E-4,8.1446E-4,3.6648E-4,3.9408E-4,3.8857E-4,4.2592E-4,8.2883E-4,3.5554E-4,3.9556E-4,4.2707E-4,4.3549E-4,8.4759E-4,3.8364E-4,3.9213E-4,3.9806E-4,4.29E-4,8.4541E-4,3.5191E-4,3.8432E-4,4.3063E-4,4.4052E-4,0.0012976,5.3258E-4,5.6834E-4,5.8711E-4,6.1758E-4,0.0012056,5.398E-4,5.649E-4,6.1515E-4,6.5104E-4,0.0012122,5.4999E-4,5.6517E-4,5.848E-4,6.1972E-4,0.0012073,5.3853E-4,5.7047E-4,6.0227E-4,6.5252E-4,0.0012058,5.4107E-4,5.6626E-4,5.8745E-4,6.2106E-4,0.0011998,5.4699E-4,5.6959E-4,5.957E-4,6.4957E-4,0.0012156,5.4943E-4,5.6549E-4,5.8757E-4,6.175E-4,0.0012118,5.4724E-4,5.678E-4,5.9345E-4,6.4528E-4,0.0012243,5.4594E-4,5.6692E-4,5.849E-4,6.197E-4,0.0011999,5.4594E-4,5.6757E-4,5.957E-4,6.2831E-4,0.0012288,5.4718E-4,5.6504E-4,5.9071E-4,6.1185E-4,0.0012163,5.3848E-4,5.6341E-4,5.9337E-4,6.2184E-4,0.0012385,5.4688E-4,5.6606E-4,5.896E-4,6.1446E-4,0.001211,5.4522E-4,5.6471E-4,5.9287E-4,6.1891E-4,0.0012389,5.4937E-4,5.6953E-4,5.9175E-4,6.1166E-4,0.00121,5.4667E-4,5.6467E-4,5.9373E-4,6.1799E-4,0.0012485,5.4702E-4,5.6179E-4,5.9678E-4,6.1015E-4,0.0012026,5.4506E-4,5.6135E-4,5.9093E-4,6.1669E-4,0.0012414,5.5482E-4,5.6237E-4,5.8818E-4,6.1304E-4,0.0012049,5.4452E-4,5.6867E-4,6.1073E-4:7
-5.9733E-6,-2.4747E-5,-2.294E-5,-2.0357E-5,-3.1323E-5,-7.2E-6,-2.8533E-5,-1.8083E-5,-1.8753E-5,-3.52E-5,-1.007E-5,-2.655E-5,-2.1323E-5,-2.3717E-5,-3.4513E-5,-3.33E-6,-2.5987E-5,-1.9043E-5,-2.347E-5,-3.4843E-5,-7.56E-6,-2.5977E-5,-2.181E-5,-2.2047E-5,-3.5287E-5,-7.9767E-6,-2.428E-5,-1.968E-5,-2.1753E-5,-3.3357E-5,-9.1933E-6,-2.617E-5,-1.851E-5,-2.1327E-5,-3.132E-5,-4.5867E-6,-2.4653E-5,-2.058E-5,-2.0343E-5,-3.302E-5,-1.0587E-5,-2.6967E-5,-1.9927E-5,-2.1717E-5,-3.3217E-5,-8.5833E-6,-2.7887E-5,-1.7477E-5,-2.2253E-5,-3.5547E-5,-8.63E-6,-2.5647E-5,-2.2483E-5,-2.0757E-5,-3.6947E-5,-8.91E-6,-2.6833E-5,-2.1617E-5,-2.1683E-5,-3.608E-5,-7.3767E-6,-2.8073E-5,-2.2273E-5,-1.964E-5,-3.6887E-5,-7.41E-6,-2.7933E-5,-1.733E-5,-2.0593E-5,-3.2413E-5,-8.4867E-6,-2.4167E-5,-2.436E-5,-2.0633E-5,-3.4767E-5,-8.37E-6,-2.8657E-5,-1.71E-5,-2.4177E-5,-3.397E-5,-8.8E-6,-2.732E-5,-2.2897E-5,-1.797E-5,-3.5097E-5,-8.4233E-6,-2.546E-5,-2.2123E-5,-1.9623E-5,-3.4087E-5,-7.8267E-6,-2.443E-5,-2.312E-5,-2.439E-5,-3.258E-5,-1.1333E-5,-2.4803E-5,-2.3497E-5,-2.2907E-5,-3.3727E-5,-8.4967E-6,-2.493E-5,-2.2177E-5,-2.252E-5,-3.3793E-5,-1.056E-5,-2.7357E-5,-1.9643E-5,-2.2747E-5,-3.726E-5,-5.4433E-6,-2.8003E-5,-2.136E-5,-2.1347E-5,-3.2173E-5,-6.17E-6,-2.5367E-5,-1.9383E-5,-2.1067E-5,-2.7927E-5,8.2333E-6,-1.2317E-5,-2.9867E-6,1.1277E-5,-2.2797E-5,1.0803E-5,-1.4267E-5,2.8933E-6,-7.5067E-6,-3.0607E-5,-3.1833E-6,-2.3557E-5,-1.7823E-5,-1.5577E-5,-3.0363E-5,-2.43E-6,-2.3363E-5,-1.859E-5,-1.265E-5,-3.0823E-5,-3.7067E-6,-2.371E-5,-1.9073E-5,-1.3973E-5,-3.0677E-5,-6.3033E-6,-2.3193E-5,-1.4203E-5,-1.232E-5,-3.0573E-5,-5.9033E-6,-1.927E-5,-1.503E-5,-1.9377E-5,-2.8883E-5,-4.5733E-6,-1.922E-5,-2.0277E-5,-1.6077E-5,-3.0593E-5,-3.79E-6,-2.4273E-5,-1.7033E-5,-1.3E-5,-3.007E-5,-1.51E-6,-2.3057E-5,-1.6667E-5,-1.362E-5,-3.0033E-5,-3.83E-6,-2.3013E-5,-1.8297E-5,-1.507E-5,-3.0813E-5,-4.66E-6,-2.2383E-5,0.0022989,0.0060142,9.493E-5,-1.5787E-5,-1.6917E-5,-1.942E-5,-2.0737E-5,-3.1123E-5,-7.25E-6,-2.4297E-5,-1.8543E-5,-2.3637E-5,-3.7473E-5,-9.6267E-6,-2.2283E-5,-2.4693E-5,-2.208E-5,-3.722E-5,-5.87E-6,-2.6717E-5,-2.2087E-5,-2.075E-5,-3.3013E-5,-7.6567E-6,-2.249E-5,-2.0987E-5,-2.2813E-5,-3.2527E-5,-6.5933E-6,-2.3697E-5,-2.2133E-5,-2.141E-5,-3.2187E-5,-7.2433E-6,-2.416E-5,-2.0313E-5,-2.4483E-5,-3.336E-5,-6.38E-6,-2.642E-5,-1.887E-5,-1.955E-5,-3.3877E-5,-7.9633E-6,-2.4647E-5,-1.978E-5,-2.6023E-5,-3.653E-5,-4.6433E-6,-2.6427E-5,-1.9383E-5,-2.194E-5,-3.2093E-5,-9.1567E-6,-2.7263E-5,2.5067E-6,3.9837E-4,3.8181E-4,4.021E-4,4.1268E-4,8.9797E-4,4.3804E-4,3.9358E-4,4.0471E-4,4.0411E-4,7.9648E-4,4.0424E-4,3.4972E-4,4.0683E-4,4.1483E-4,7.9576E-4,4.4046E-4,4.1159E-4,4.1504E-4,4.1282E-4,7.8151E-4,4.2454E-4,3.5974E-4,4.1178E-4,4.1547E-4,7.7241E-4,4.2445E-4,4.0576E-4,4.2475E-4,4.0442E-4,7.7691E-4,4.0992E-4,3.5702E-4,4.1442E-4,4.0994E-4,7.9613E-4,4.872E-4,4.2697E-4,5.3414E-4,5.1723E-4,9.9198E-4,5.4757E-4,4.4347E-4,4.7192E-4,5.7098E-4,0.0010032,5.273E-4,4.6303E-4,4.9243E-4,5.7246E-4,8.9615E-4,5.6906E-4,4.4609E-4,5.5418E-4,5.4521E-4,9.3528E-4,5.2168E-4,4.4717E-4,5.4943E-4,5.1251E-4,9.6333E-4,4.9355E-4,4.5595E-4,4.8081E-4,5.3979E-4,0.0010407,4.7639E-4,5.1245E-4,5.5175E-4,5.5278E-4,0.0010186,4.812E-4,4.9344E-4,6.056E-4,9.0571E-4,0.0024955,7.1822E-4,5.3176E-4,6.2875E-4,6.2421E-4,0.0011592,6.1432E-4,5.4634E-4,5.9796E-4,6.1181E-4,0.0011519,6.094E-4,5.3766E-4,5.9906E-4,6.3738E-4,0.0011574,6.0694E-4,5.4047E-4,5.9468E-4,6.0913E-4,0.0011474,6.0663E-4,5.4372E-4,5.9143E-4,6.3879E-4,0.0011641,6.0218E-4,5.4263E-4,5.8976E-4,6.0584E-4,0.0011471,6.0393E-4,5.4152E-4,5.8759E-4,6.2895E-4,0.0011718,6.039E-4,5.4392E-4,5.9459E-4,6.02E-4,0.0011553,6.4844E-4,5.7066E-4,6.1567E-4,6.3125E-4,0.0012115,6.3783E-4,5.6995E-4,6.2712E-4,6.291E-4,0.001199,6.3019E-4,5.6311E-4,6.208E-4,6.281E-4,0.0012154,6.3553E-4,5.6276E-4,6.2465E-4,6.2263E-4,0.0012062,6.2899E-4,5.6249E-4,5.9871E-4,6.0102E-4,0.0011964,6.0263E-4,5.412E-4,5.9458E-4,5.975E-4,0.0011512,6.0482E-4,5.3985E-4,5.8988E-4,6.0042E-4,0.0012036,5.9593E-4,5.4194E-4,5.9093E-4,6.0497E-4,0.0011435,5.9804E-4,5.3894E-4,5.9103E-4,6.0554E-4,0.0011838,6.0653E-4,5.3937E-4,5.855E-4,6.0773E-4,0.0011494,5.9746E-4,5.4467E-4,5.8587E-4,5.9953E-4,0.0011873,6.1113E-4,5.3924E-4,5.8946E-4,6.0016E-4,0.001155,5.9694E-4,5.3877E-4,6.5404E-4,6.4974E-4,0.0013506,7.0636E-4,5.8233E-4,6.3043E-4,6.5076E-4,0.00133,6.9186E-4,6.0778E-4,6.6197E-4,6.687E-4,0.0013092,6.9286E-4,6.1034E-4,6.5687E-4,6.6376E-4,0.0012639,6.5634E-4,5.8115E-4,6.4069E-4,6.4597E-4,0.0012497,6.6561E-4,6.174E-4,5.2895E-4,5.105E-4,9.1177E-4,4.8904E-4,4.4411E-4,4.7204E-4,4.7977E-4,9.6833E-4,5.6543E-4,5.1613E-4,6.3099E-4,6.0052E-4,9.2305E-4,4.8313E-4,4.1633E-4,4.5982E-4,4.9897E-4,9.003E-4,4.8662E-4,4.5335E-4,4.5991E-4,4.5581E-4,8.636E-4,4.5729E-4,3.9877E-4,4.4067E-4,5.2362E-4,8.8687E-4,4.7012E-4,4.385E-4,4.6021E-4,4.5437E-4,8.6185E-4,4.2252E-4,3.8042E-4,4.3773E-4,4.1874E-4,8.1644E-4,4.323E-4,4.0409E-4,4.3421E-4,4.3342E-4,8.2473E-4,4.2891E-4,3.7185E-4,4.278E-4,4.1556E-4,8.3242E-4,4.3084E-4,3.9755E-4,4.3873E-4,4.29E-4,8.1588E-4,4.2212E-4,3.9358E-4,4.2706E-4,5.6531E-4,8.6413E-4,4.2747E-4,4.0294E-4,4.4439E-4,4.2105E-4,7.9606E-4,4.2787E-4,3.9652E-4,4.241E-4,4.236E-4,8.4055E-4,4.2129E-4,3.7633E-4,4.5235E-4,4.482E-4,0.0010799,4.3809E-4,3.628E-4,4.1449E-4,4.1206E-4,8.3544E-4,4.3445E-4,3.7483E-4,4.4606E-4,4.5175E-4,7.9375E-4,4.2451E-4,3.7338E-4,4.1213E-4,4.1621E-4,8.0952E-4,4.1578E-4,3.6752E-4,4.2321E-4,4.5862E-4,8.325E-4,4.0786E-4,3.7762E-4,4.1553E-4,4.0898E-4,8.4336E-4,3.9694E-4,3.6503E-4,4.2307E-4,4.6493E-4,8.2657E-4,3.979E-4,3.8823E-4,4.2102E-4,4.0986E-4,8.0965E-4,4.0122E-4,3.6531E-4,4.1139E-4,4.6078E-4,8.3437E-4,3.9688E-4,3.7427E-4,4.1791E-4,4.1975E-4,8.2398E-4,3.9522E-4,3.8852E-4,4.1125E-4,4.5568E-4,8.372E-4,4.02E-4,3.7637E-4,4.2239E-4,4.1059E-4,8.4907E-4,4.0869E-4,3.7939E-4,4.1721E-4,4.4003E-4,8.3596E-4,3.9997E-4,3.7244E-4,4.2592E-4,4.0335E-4,8.1558E-4,4.2033E-4,3.5415E-4,4.0122E-4,4.2804E-4,8.6091E-4,4.0147E-4,3.7069E-4,4.0583E-4,4.1457E-4,8.3095E-4,3.9715E-4,3.5807E-4,4.0823E-4,4.2675E-4,8.4986E-4,3.9819E-4,3.8381E-4,4.1289E-4,4.1737E-4,8.1099E-4,4.0493E-4,3.64E-4,4.1772E-4,4.3039E-4,8.6117E-4,3.8773E-4,3.8912E-4,4.2654E-4,4.2124E-4,8.2926E-4,3.953E-4,3.6195E-4,4.2069E-4,4.1432E-4,8.6623E-4,4.2397E-4,3.7171E-4,4.4007E-4,4.0807E-4,8.4052E-4,4.1611E-4,3.7376E-4,4.1852E-4,3.9005E-4:7
5.1185E-4,4.358E-4,3.0874E-4,3.0472E-4,3.3262E-4,5.1663E-4,4.4356E-4,3.0702E-4,3.0206E-4,3.2388E-4,5.1097E-4,4.4362E-4,3.1339E-4,2.9801E-4,3.2854E-4,4.9879E-4,4.1329E-4,2.9743E-4,2.935E-4,3.229E-4,5.0709E-4,4.1124E-4,3.0917E-4,2.9956E-4,3.1974E-4,5.0635E-4,3.9838E-4,2.9688E-4,2.9487E-4,3.257E-4,5.0929E-4,4.066E-4,2.9907E-4,2.9936E-4,3.2852E-4,5.0514E-4,4.0229E-4,3.1223E-4,2.9333E-4,3.2197E-4,5.2638E-4,3.9532E-4,3.0075E-4,2.9329E-4,3.2008E-4,5.4969E-4,3.8338E-4,2.9993E-4,2.9278E-4,3.2422E-4,5.4206E-4,3.862E-4,3.0814E-4,3.0267E-4,3.265E-4,5.2374E-4,3.7791E-4,2.9896E-4,2.9382E-4,3.2204E-4,5.4721E-4,3.9088E-4,3.047E-4,2.9251E-4,3.2603E-4,7.0445E-4,5.3965E-4,4.5429E-4,4.4061E-4,4.674E-4,5.714E-4,3.7972E-4,3.0221E-4,2.9939E-4,3.2529E-4,5.4993E-4,3.6351E-4,3.0192E-4,2.9628E-4,3.253E-4,5.4885E-4,3.6253E-4,3.0023E-4,2.9757E-4,4.1582E-4,8.1621E-4,3.8056E-4,2.9983E-4,2.9905E-4,3.2304E-4,5.5704E-4,3.659E-4,3.0088E-4,2.9244E-4,3.3803E-4,5.7593E-4,3.6669E-4,3.0509E-4,2.8968E-4,3.2264E-4,5.6383E-4,3.5797E-4,3.0013E-4,2.9536E-4,3.2997E-4,5.6726E-4,3.8001E-4,3.0526E-4,2.981E-4,3.2012E-4,5.5891E-4,3.5944E-4,3.0348E-4,2.8927E-4,3.2871E-4,5.6196E-4,3.3919E-4,2.9872E-4,2.9244E-4,3.2025E-4,5.7044E-4,3.4408E-4,3.0266E-4,2.9576E-4,3.2445E-4,5.6216E-4,3.3077E-4,3.0063E-4,2.9553E-4,3.2269E-4,5.8719E-4,3.3646E-4,3.0816E-4,3.0857E-4,3.3516E-4,5.8787E-4,3.395E-4,3.1053E-4,2.9436E-4,3.1866E-4,5.7901E-4,3.2432E-4,3.0669E-4,2.9328E-4,3.2578E-4,5.7499E-4,3.4901E-4,3.0884E-4,2.9361E-4,3.2E-4,5.8092E-4,3.2575E-4,3.2748E-4,3.0347E-4,3.268E-4,5.77E-4,3.1917E-4,3.0002E-4,2.9463E-4,3.2018E-4,5.9032E-4,3.3117E-4,3.0445E-4,2.9254E-4,3.2092E-4,5.8229E-4,3.1707E-4,2.9692E-4,2.9313E-4,3.2761E-4,8.7432E-4,4.6338E-4,4.6356E-4,4.5865E-4,3.8283E-4,6.223E-4,3.1939E-4,3.0289E-4,3.0366E-4,3.1914E-4,5.9639E-4,3.1166E-4,3.0707E-4,3.0145E-4,3.2334E-4,5.8797E-4,3.1984E-4,3.0477E-4,2.9793E-4,3.2139E-4,6.0056E-4,3.0936E-4,3.019E-4,2.9342E-4,3.3511E-4,6.1575E-4,3.1661E-4,3.0201E-4,2.9397E-4,3.2957E-4,6.0904E-4,2.9607E-4,3.0628E-4,3.0276E-4,3.2313E-4,5.9938E-4,3.3868E-4,3.0876E-4,2.9486E-4,3.2701E-4,6.0723E-4,3.0472E-4,3.032E-4,2.9826E-4,3.2442E-4,6.1028E-4,2.9916E-4,3.0073E-4,2.9291E-4,3.1807E-4,6.0628E-4,2.9485E-4,3.0333E-4,2.9921E-4,3.238E-4,6.2356E-4,2.904E-4,3.0144E-4,2.9685E-4,3.2263E-4,6.1408E-4,2.9264E-4,3.0057E-4,2.9922E-4,3.2451E-4,6.0191E-4,2.9567E-4,3.1494E-4,2.9875E-4,3.1881E-4,6.0703E-4,2.9838E-4,3.0471E-4,2.9553E-4,3.2246E-4,6.0979E-4,2.8332E-4,3.3336E-4,3.1092E-4,3.2185E-4,6.2322E-4,2.8577E-4,3.2634E-4,3.1101E-4,3.583E-4,6.1249E-4,2.8258E-4,3.0076E-4,2.9644E-4,3.2817E-4,6.1606E-4,2.9355E-4,3.0648E-4,2.9994E-4,3.1657E-4,6.1459E-4,2.8144E-4,3.0272E-4,2.9512E-4,3.2155E-4,6.2689E-4,2.8364E-4,3.1913E-4,3.0721E-4,4.3185E-4,9.1381E-4,4.292E-4,4.7279E-4,3.8759E-4,3.3019E-4,6.3284E-4,2.841E-4,3.0725E-4,3.0581E-4,3.2368E-4,6.1837E-4,2.8687E-4,3.1241E-4,3.0215E-4,3.2363E-4,6.1899E-4,2.9E-4,3.0906E-4,1.2853E-5:7
3.1271E-4,3.026E-4,3.5185E-4,6.0682E-4,3.0246E-4,3.0453E-4,2.9934E-4,3.2256E-4,5.953E-4,3.0625E-4,3.1017E-4,3.0322E-4,3.1956E-4,6.1969E-4,3.0635E-4,3.0947E-4,2.9999E-4,3.2322E-4,6.0723E-4,2.9824E-4,3.0591E-4,2.9651E-4,3.2254E-4,6.0719E-4,2.9524E-4,3.0572E-4,2.9508E-4,3.3121E-4,6.1174E-4,2.9504E-4,3.1029E-4,3.0339E-4,3.2603E-4,6.0493E-4,3.2569E-4,3.1347E-4,3.0865E-4,3.685E-4,6.0847E-4,2.9184E-4,3.0689E-4,3.0082E-4,3.2275E-4,6.1192E-4,2.9395E-4,3.0694E-4,2.9694E-4,3.2446E-4,6.3367E-4,2.8799E-4,3.1933E-4,3.0051E-4,3.2518E-4,6.181E-4,2.9207E-4,3.069E-4,2.9817E-4,3.2664E-4,8.5689E-4,4.3123E-4,4.5528E-4,4.4303E-4,4.2457E-4,6.326E-4,2.9141E-4,3.1014E-4,3.0316E-4,3.2359E-4,6.1279E-4,2.87E-4,3.0313E-4,2.9924E-4,3.3865E-4,6.1857E-4,2.8216E-4,3.0189E-4,2.9633E-4,3.212E-4,6.2711E-4,2.8687E-4,3.2157E-4,3.0232E-4,3.2379E-4,6.1801E-4,2.8529E-4,3.0734E-4,2.9945E-4,3.1997E-4,6.1168E-4,2.8517E-4,3.1114E-4,3.1933E-4,3.3836E-4,6.4173E-4,2.8387E-4,3.065E-4,3.1153E-4,3.2601E-4,6.1983E-4,2.7737E-4,3.074E-4,3.0679E-4,3.3182E-4,6.5972E-4,2.7897E-4,3.0417E-4,3.0181E-4,3.2309E-4,6.1592E-4,2.8165E-4,3.0818E-4,3.0027E-4,3.2071E-4,6.263E-4,2.7496E-4,3.0739E-4,3.1356E-4,3.2333E-4,6.2539E-4,2.7934E-4,3.0719E-4,2.985E-4,3.249E-4,6.4156E-4,2.9481E-4,3.1179E-4,2.9726E-4,3.2817E-4,6.2615E-4,2.7553E-4,3.0879E-4,3.0004E-4,3.2741E-4,6.2028E-4,3.0118E-4,3.1388E-4,3.0796E-4,3.2381E-4,6.2419E-4,2.7368E-4,3.0599E-4,2.9836E-4,3.2267E-4,6.2719E-4,2.7588E-4,3.1102E-4,2.9966E-4,3.2431E-4,6.5065E-4,2.7296E-4,3.0949E-4,3.0311E-4,3.2507E-4,6.2755E-4,2.7424E-4,3.0567E-4,3.0368E-4,3.2676E-4,6.1985E-4,2.7525E-4,3.1079E-4,3.0199E-4,4.3587E-4,8.5493E-4,4.2211E-4,4.6466E-4,4.2827E-4,3.4874E-4,6.2376E-4,2.7524E-4,3.1114E-4,3.0284E-4,4.0485E-4,6.4251E-4,2.7476E-4,3.0721E-4,2.9886E-4,3.3876E-4,6.3321E-4,2.7152E-4,3.1198E-4,2.9976E-4,3.3159E-4,6.1099E-4,2.7602E-4,3.1205E-4,3.0166E-4,3.2912E-4,6.1193E-4,2.7208E-4,3.1369E-4,3.0213E-4,3.3497E-4,6.2019E-4,2.7633E-4,3.0751E-4,2.9908E-4,3.3532E-4,6.0369E-4,2.6892E-4,3.1942E-4,3.0186E-4,3.4745E-4,5.9836E-4,2.9482E-4,3.1697E-4,3.0615E-4,3.4133E-4,5.9755E-4,2.7516E-4,3.136E-4,3.0529E-4,3.4542E-4,5.9334E-4,2.6776E-4,3.0843E-4,3.2036E-4,3.5699E-4,5.8953E-4,2.7488E-4,3.1369E-4,3.0192E-4,3.588E-4,5.8409E-4,2.6655E-4,3.0501E-4,2.9703E-4,3.6965E-4,5.829E-4,2.7157E-4,3.0821E-4,3.0359E-4,3.7053E-4,5.7314E-4,3.1432E-4,4.3672E-4,3.6671E-4,4.5944E-4,6.0392E-4,2.8544E-4,3.2129E-4,3.1624E-4,3.897E-4,5.7585E-4,2.8254E-4,3.167E-4,3.0378E-4,3.8913E-4,6.0173E-4,2.8061E-4,3.1662E-4,3.1029E-4,4.1024E-4,5.669E-4,2.8881E-4,3.2546E-4,3.0488E-4,3.9973E-4,5.4958E-4,2.8119E-4,3.1952E-4,3.1368E-4,4.2651E-4,5.4775E-4,2.7698E-4,3.2005E-4,3.2334E-4,6.7877E-4,7.3645E-4,4.2402E-4,0.0:7
2.366E-4,2.4114E-4,2.5813E-4,9.9223E-5,9.2797E-5,1.5541E-4,2.3851E-4,2.7953E-4,2.7906E-4,2.896E-4,2.4568E-4,1.9888E-4,1.3064E-4,1.837E-4,2.7324E-4,4.5797E-4,3.5928E-4,1.7607E-4,1.4688E-4,2.0618E-4,2.9439E-4,4.074E-4,2.6342E-4,2.4724E-4,2.9881E-4,3.9386E-4,3.9036E-4,2.9526E-4,2.975E-4,2.7692E-4,2.3053E-4,1.9282E-4,2.4556E-4,3.3004E-4,3.2513E-4,3.1441E-4,3.1996E-4,3.0798E-4,5.2857E-5,-9.4867E-6,-3.8533E-6,-7.0167E-6,-8.7667E-6,1.8533E-4,2.162E-4,4.0751E-4,1.573E-4,1.9153E-4,2.1687E-4,1.8647E-4,4.4336E-4,1.982E-4,1.8016E-4,1.9914E-4,1.9706E-4,3.6395E-4,1.8066E-4,1.7629E-4,1.7831E-4,2.034E-4,4.1379E-4,1.8615E-4,2.8011E-4,0.0015296,0.0014189,4.0468E-4,3.8832E-4,3.1008E-4,3.677E-4,2.8494E-4,3.7463E-4,5.5165E-4,4.8858E-4,5.0832E-4,4.967E-4,3.981E-4,3.2425E-4,3.1143E-4,3.9967E-4,5.4115E-4,6.548E-4,5.3327E-4,3.7006E-4,3.4828E-4,3.4011E-4,4.5392E-4,4.8815E-4,4.3047E-4,4.8367E-4,5.15E-4,5.7026E-4,4.3965E-4,2.6056E-4,3.1833E-4,4.4282E-4,4.8167E-4,2.8504E-4,1.8522E-4,1.8403E-4,3.588E-4,7.2758E-4,6.4275E-4,4.0161E-4,3.8078E-4,3.5404E-4,4.1701E-4,4.3567E-4,3.7588E-4,4.6444E-4,5.5661E-4,6.0034E-4,3.9956E-4,3.0012E-4,4.0947E-4,5.5988E-4,6.5516E-4,4.6763E-4,2.5768E-4,3.0123E-4,4.0987E-4,6.506E-4,5.2156E-4,2.6373E-4,2.6195E-4,3.885E-4,5.0318E-4,4.5059E-4,3.356E-4,3.5658E-4,4.0145E-4,4.9874E-4,4.3636E-4,3.28E-4,3.5602E-4,4.219E-4,5.0455E-4,4.4005E-4,3.3043E-4,3.3906E-4,4.1642E-4,5.7172E-4,4.6111E-4,2.9072E-4,2.8523E-4,3.5618E-4,4.7521E-4,4.8775E-4,4.8007E-4,5.4761E-4,5.5821E-4,6.2377E-4,5.6845E-4,4.3943E-4,4.855E-4,5.4524E-4,6.3662E-4,5.7551E-4,4.5901E-4,4.6986E-4,5.3556E-4,6.7457E-4,6.3325E-4,4.7065E-4,4.5706E-4,5.1929E-4,6.9344E-4,6.0106E-4,4.5089E-4,4.6158E-4,5.25E-4,6.5486E-4,5.9476E-4,4.3779E-4,4.6693E-4,5.2874E-4,6.4344E-4,6.0651E-4,4.6E-4,4.7554E-4,5.3076E-4,6.3996E-4,5.8594E-4,4.9157E-4,4.9945E-4,5.2634E-4,6.3112E-4,6.0143E-4,4.4439E-4,4.6319E-4,5.2334E-4,6.4038E-4,6.0288E-4,4.4183E-4,4.6238E-4,5.2366E-4,6.4724E-4,5.9732E-4,4.6027E-4,4.628E-4,5.3926E-4,6.5366E-4,5.8328E-4,4.39E-4,4.9265E-4,5.3231E-4,6.4232E-4,5.9722E-4,4.4081E-4,4.6958E-4,5.2866E-4,7.1564E-4,6.6733E-4,4.4244E-4,4.5582E-4,5.4655E-4,8.2545E-4,8.0828E-4,5.7185E-4,5.5189E-4,5.6331E-4,7.2988E-4,5.9899E-4,4.412E-4,4.6793E-4,5.1735E-4,6.3152E-4,6.1185E-4,4.4117E-4,4.2744E-4,3.8704E-4,4.1122E-4,4.2915E-4,3.3621E-4,3.5973E-4,4.1107E-4,5.0353E-4,4.3998E-4,3.3133E-4,3.5825E-4,4.1566E-4,4.7142E-4,4.641E-4,3.4758E-4,3.3597E-4,4.3376E-4,5.6251E-4,5.1547E-4,4.214E-4,4.1625E-4,3.9536E-4,5.012E-4,4.3869E-4,3.5534E-4,3.8661E-4,4.5821E-4,5.4799E-4,5.528E-4,3.3505E-4,3.1347E-4,4.1802E-4,5.95E-4,5.4406E-4,3.5883E-4,3.4401E-4,3.7313E-4,4.8029E-4,4.977E-4,3.3847E-4,3.4598E-4,4.7237E-4,7.045E-4,6.0714E-4,4.1843E-4,4.2193E-4,4.8818E-4,6.2424E-4,6.0177E-4,3.965E-4,3.2153E-4,3.821E-4,4.8502E-4,5.2782E-4,4.9876E-4,5.1288E-4,5.041E-4,6.0174E-4,5.5729E-4,3.4418E-4,3.2086E-4,3.9656E-4,5.4599E-4,5.3076E-4,3.767E-4,3.4977E-4,3.2934E-4,4.2292E-4,4.4323E-4,3.2289E-4,3.3981E-4,3.6713E-4,0.0:7
3.2297E-4,4.2032E-4,5.016E-4,3.9353E-4,3.0236E-4,4.4478E-4,5.2009E-4,4.9005E-4,2.8433E-4,1.6875E-4,1.8681E-4,2.2321E-4,2.7131E-4,2.1613E-4,1.673E-4,3.4158E-4,4.8939E-4,3.8309E-4,1.8066E-4,9.5793E-5,1.1052E-4,1.863E-4,2.7758E-4,2.4751E-4,2.5316E-4,3.6637E-4,4.9657E-4,6.9225E-4,3.1943E-4,1.061E-4,7.879E-5,1.1294E-4,2.1266E-4,4.1024E-4,4.3099E-4,4.1822E-4,3.021E-4,1.8334E-4,3.685E-4,4.9381E-4,4.5948E-4,4.0424E-4,3.6226E-4,3.277E-4,3.127E-4,3.7579E-4,4.2081E-4,4.6943E-4,3.8225E-4,3.1044E-4,4.8474E-4,5.4348E-4,5.0997E-4,3.5418E-4,2.7596E-4,3.2981E-4,4.0157E-4,4.7083E-4,4.0358E-4,3.2426E-4,4.763E-4,5.2411E-4,4.9905E-4,3.4752E-4,2.6969E-4,3.3574E-4,4.1944E-4,4.904E-4,3.9908E-4,3.0478E-4,4.4952E-4,5.1888E-4,5.2043E-4,3.5069E-4,2.5944E-4,3.2975E-4,4.1214E-4,4.8845E-4,4.0455E-4,2.9326E-4,2.6884E-4,2.6787E-4,5.1239E-4,4.2025E-4,2.0172E-4,1.4873E-4,2.5695E-4,4.8432E-4,3.18E-4,1.3945E-4,1.3227E-4,2.4843E-4,4.895E-4,3.7682E-4,2.3808E-4,1.8656E-4,1.5933E-4,1.7057E-4,2.1277E-4,2.6076E-4,2.6266E-4,2.7558E-4,4.5444E-4,3.7922E-4,1.8013E-4,1.3347E-4,1.4307E-4,2.5808E-4,3.8012E-4,2.2084E-4,1.9036E-4,2.1466E-4,4.5171E-4,3.8773E-4,1.9212E-4,1.9557E-4,3.2446E-4,5.3134E-4,4.6697E-4,2.4026E-4,1.4349E-4,1.7491E-4,4.0879E-4,6.9899E-4,4.8788E-4,3.7064E-4,3.2191E-4,3.5501E-4,4.1358E-4,3.4451E-4,3.5532E-4,3.7845E-4,4.5663E-4,5.4581E-4,4.3846E-4,4.0831E-4,3.2755E-4,1.9556E-4,1.3058E-4,1.1714E-4,1.9017E-4,3.1287E-4,4.4712E-4,3.8639E-4,2.673E-4,3.2125E-4,4.8691E-4,5.7989E-4,3.9273E-4,2.4275E-4,2.7337E-4,3.7354E-4,4.8868E-4,4.3396E-4,3.1162E-4,4.2535E-4,5.0295E-4,5.2012E-4,4.0103E-4,3.0131E-4,3.3239E-4,3.8137E-4,4.5796E-4,4.1827E-4,3.2221E-4,4.6042E-4,5.2075E-4,5.2761E-4,3.542E-4,2.4846E-4,3.0692E-4,3.8944E-4,4.9753E-4,4.3227E-4,3.0926E-4,4.3498E-4,5.0111E-4,5.2168E-4,3.6379E-4,2.59E-4,3.1614E-4,3.8879E-4,5.0249E-4,4.3408E-4,3.058E-4,4.3931E-4,5.5088E-4,5.2229E-4,3.5536E-4,2.497E-4,2.5873E-4,2.3586E-4,2.2857E-4,1.736E-4,1.5561E-4,3.2794E-4,4.2314E-4,3.5986E-4,2.5522E-4,1.7748E-4,1.8356E-4,2.0416E-4,2.3868E-4,2.1566E-4,1.6123E-4,3.1909E-4,4.4063E-4,3.6367E-4,1.7078E-4,8.8567E-5,9.4323E-5,1.389E-4,2.5476E-4,2.8809E-4,1.9145E-4,1.7662E-4,1.981E-4,4.4605E-4,3.9814E-4,1.8076E-4,1.2464E-4,1.3017E-4,1.5782E-4,1.8939E-4,1.6881E-4,1.907E-4,2.1395E-4,2.4731E-4,3.7368E-4,3.5013E-4,2.7151E-4,1.9611E-4,1.6212E-4,1.5373E-4,1.4084E-4,1.7472E-4,2.1659E-4,2.586E-4,1.9861E-4,1.5032E-4,3.1177E-4,4.1307E-4,3.5497E-4,1.8193E-4,8.558E-5,8.7953E-5,1.3063E-4,2.1645E-4,2.7361E-4,2.0684E-4,3.454E-4,4.4015E-4,4.5064E-4,2.1463E-4,9.475E-5,8.8907E-5,1.2704E-4,2.1008E-4,2.6946E-4,2.197E-4,3.7466E-4,4.3745E-4,3.3775E-4,1.7576E-4,1.016E-4,1.1211E-4,1.6473E-4,2.5027E-4,2.3979E-4,1.5601E-4,1.4179E-4,1.874E-4,4.8858E-4,4.3574E-4,1.7137E-4,1.0938E-4,1.0646E-4,1.2696E-4,1.5297E-4,1.6146E-4,1.9587E-4,2.1849E-4,2.4224E-4,2.7194E-4,4.1783E-5,-1.6873E-5,3.4567E-6,-7.3133E-6,-8.7533E-6,-9.5867E-6,5.505E-5,1.4305E-4,2.978E-4,1.4755E-4,1.7796E-4,3.1005E-4,2.5261E-4,3.232E-4,2.3384E-4,2.0856E-4,2.2865E-4,2.3779E-4,5.3871E-4,3.0775E-4,0.0013374,0.0015311,2.8183E-4:7
3.8668E-4,3.5608E-4,2.2993E-4,1.2102E-4,1.2176E-4,1.6882E-4,2.576E-4,4.9276E-4,3.5841E-4,2.2306E-4,2.1582E-4,3.8493E-4,3.985E-4,1.8541E-4,1.2523E-4,1.3267E-4,2.827E-4,4.9266E-4,4.5588E-4,5.4011E-4,4.3841E-4,2.3801E-4,9.9583E-5,7.378E-5,1.1111E-4,2.1606E-4,3.3151E-4,2.6114E-4,1.3657E-4,1.2921E-4,2.6281E-4,6.6966E-4,5.6239E-4,2.8932E-4,2.5062E-4,3.0504E-4,4.9938E-4,5.1703E-4,2.6631E-4,1.5546E-4,1.3384E-4,1.7556E-4,4.2481E-4,3.6813E-4,2.6885E-4,1.9223E-4,2.3804E-4,5.3351E-4,5.314E-4,4.7132E-4,4.5501E-4,4.9386E-4,5.2242E-4,4.0606E-4,4.1303E-4,3.8014E-4,3.8434E-4,3.2408E-4,1.8245E-4,1.4771E-4,2.1768E-4,3.7793E-4,5.6846E-4,3.7531E-4,2.3635E-4,1.5521E-4,1.2216E-4,1.091E-4,1.048E-4,1.696E-4,2.4084E-4,2.7938E-4,2.0437E-4,1.9664E-4,3.5682E-4,3.6039E-4,2.7048E-4,1.587E-4,1.0537E-4,1.2788E-4,2.1842E-4,3.2619E-4,2.9953E-4,1.6098E-4,1.2954E-4,2.2079E-4,4.8723E-4,3.5159E-4,1.3691E-4,1.0346E-4,1.1972E-4,1.5762E-4,1.9233E-4,1.7706E-4,2.0011E-4,2.2492E-4,2.8877E-4,4.3778E-4,2.9844E-4,1.9736E-4,1.5077E-4,1.3395E-4,1.253E-4,1.1225E-4,1.6811E-4,2.3244E-4,3.0045E-4,4.7217E-4,3.5171E-4,2.0675E-4,1.4047E-4,1.1831E-4,1.2976E-4,1.6812E-4,2.7824E-4,3.2209E-4,3.0733E-4,2.2707E-4,1.9502E-4,3.8073E-4,4.23E-4,3.0061E-4,1.3636E-4,6.536E-5,7.821E-5,1.4542E-4,2.8384E-4,3.0189E-4,2.5522E-4,3.6047E-4,3.5547E-4,2.4955E-4,1.3274E-4,7.7647E-5,9.4523E-5,1.4659E-4,2.6231E-4,2.7547E-4,1.644E-4,1.7173E-4,3.85E-4,7.332E-4,4.3069E-4,2.4032E-4,2.3861E-4,3.3135E-4,4.7897E-4,4.5213E-4,3.0001E-4,2.9281E-4,3.2669E-4,4.5595E-4,6.1811E-4,4.2399E-4,3.1955E-4,2.8827E-4,3.5593E-4,4.2032E-4,3.3305E-4,2.548E-4,2.848E-4,5.5912E-4,3.7485E-4,1.231E-4,8.479E-5,1.0388E-4,1.7955E-4,2.6908E-4,2.0306E-4,1.8001E-4,1.6123E-4,2.0162E-4,4.2063E-4,3.5741E-4,2.1798E-4,1.5076E-4,1.4169E-4,1.2622E-4,1.0465E-4,1.4867E-4,2.1049E-4,3.0875E-4,2.9781E-4,2.2685E-4,3.5493E-4,3.3951E-4,2.4252E-4,1.3639E-4,7.5923E-5,9.2343E-5,1.434E-4,2.4952E-4,2.6662E-4,1.6977E-4,1.4046E-4,2.2229E-4,5.1021E-4,3.9337E-4,1.5379E-4,4.7693E-5,1.7133E-6,-6.4667E-6,-8.9167E-6,-1.0023E-5,1.6512E-4,2.5067E-4,5.4277E-4,0.0018849,8.6838E-4,5.9263E-5,4.6205E-4,4.2017E-4,2.5998E-4,2.3969E-4,1.0245E-4,1.2321E-4,2.5986E-4,7.2004E-4,6.107E-4,3.4761E-4,2.6628E-4,3.1887E-4,4.1867E-4,2.9209E-4,2.3152E-4,2.2173E-4,3.6879E-4,7.0785E-4,5.87E-4,3.9967E-4,2.9699E-4,3.1683E-4,4.0049E-4,3.6296E-4,3.4779E-4,3.5196E-4,4.2355E-4,4.4555E-4,4.1208E-4,5.0883E-4,4.5026E-4,4.3162E-4,3.7154E-4,3.1804E-4,3.3006E-4,3.6305E-4,4.5324E-4,4.4405E-4,3.9596E-4,5.1572E-4,5.4276E-4,4.7012E-4,3.5894E-4,2.785E-4,3.2552E-4,3.6694E-4,4.6482E-4,4.5485E-4,3.2161E-4,3.1549E-4,4.0945E-4,6.4578E-4,5.0537E-4,3.3481E-4,3.1993E-4,3.8505E-4,5.7326E-4,5.5878E-4,3.2494E-4,2.6611E-4,3.7183E-4,6.954E-4,5.6698E-4,2.9881E-4,2.5296E-4,3.2893E-4,5.1393E-4,5.355E-4,3.2457E-4,2.6903E-4,3.7922E-4,6.1135E-4,5.1819E-4,2.9693E-4,2.5207E-4,3.047E-4,4.4026E-4,4.863E-4,3.4565E-4,3.0668E-4,3.8248E-4,6.3088E-4,4.9609E-4,3.1398E-4,2.9852E-4,3.2479E-4,4.1534E-4,4.4231E-4,2.8176E-4,1.7361E-4,2.2115E-4,4.8609E-4,4.2198E-4,1.7647E-4,1.1788E-4,1.384E-4,2.0231E-4,2.6564E-4,1.9543E-4,1.5237E-4,2.2221E-4,4.9904E-4,4.3545E-4,2.2857E-4,1.6953E-4,1.9367E-4,2.9925E-4,3.3632E-4,2.646E-4,2.5489E-4,3.4182E-4,5.1721E-4,3.0989E-4,1.1597E-4,7.376E-5,9.3907E-5,1.7554E-4,2.7868E-4,2.3108E-4,1.801E-4,1.5925E-4,1.8698E-4,2.0657E-4,2.5045E-4,4.2601E-4,4.0146E-4,3.0576E-4,1.7703E-4,1.0072E-4,8.8187E-5,1.221E-4,2.1333E-4,2.7324E-4,1.9392E-4,1.4619E-4,2.3213E-4,3.8024E-4:7
2.207E-4,3.9322E-4,1.8161E-4,2.3212E-4,2.6197E-4,3.4486E-4,6.377E-4,2.9209E-4,3.2676E-4,3.5075E-4,3.7274E-4,6.999E-4,3.3535E-4,3.4775E-4,3.4622E-4,3.8183E-4,7.1749E-4,3.6822E-4,3.6057E-4,3.5202E-4,3.917E-4,7.248E-4,3.2992E-4,3.5227E-4,3.5776E-4,3.8371E-4,7.1522E-4,3.2822E-4,3.5667E-4,3.6329E-4,3.9203E-4,7.2082E-4,3.3381E-4,3.5485E-4,3.5838E-4,3.9756E-4,7.1566E-4,3.447E-4,3.6341E-4,3.5673E-4,3.9771E-4,7.2331E-4,3.4445E-4,3.5962E-4,3.5777E-4,3.7741E-4,7.1393E-4,3.2861E-4,3.5196E-4,3.5516E-4,4.3607E-4,7.1512E-4,3.269E-4,3.4519E-4,3.5112E-4,3.8064E-4,7.0657E-4,3.2744E-4,3.5259E-4,3.7466E-4,3.8265E-4,7.0874E-4,3.256E-4,3.5496E-4,3.5495E-4,3.8182E-4,7.0213E-4,3.2171E-4,2.6035E-4,2.3505E-4,2.5912E-4,4.7176E-4,1.9756E-4,2.0853E-4,1.9392E-4,2.0932E-4,3.83E-4,1.8388E-4,1.9175E-4,2.0492E-4,2.2319E-4,3.8977E-4,2.2734E-4,2.513E-4,2.0957E-4,2.445E-4,4.279E-4,1.8871E-4,1.9922E-4,2.028E-4,2.4133E-4,4.2105E-4,1.879E-4,2.0516E-4,2.1E-4,2.5159E-4,4.8642E-4,3.3578E-4,4.1983E-4,4.0566E-4,4.5556E-4,7.7569E-4,2.6427E-4,3.3104E-4,2.8379E-4,2.9721E-4,4.6463E-4,1.9208E-4,2.2897E-4,2.2152E-4,2.3351E-4,4.7798E-4,2.5088E-4,2.3955E-4,2.3947E-4,2.6361E-4,4.4586E-4,1.7905E-4,2.1511E-4,2.0842E-4,2.3869E-4,4.2806E-4,1.8378E-4,2.8388E-4,2.6157E-4,2.7713E-4,4.5326E-4,1.8536E-4,1.9053E-4,2.019E-4,2.102E-4,3.8823E-4,1.7878E-4,2.2475E-4,2.5066E-4,2.711E-4,5.7456E-4,3.258E-4,3.3296E-4,2.8109E-4,2.9867E-4,4.56E-4,2.0735E-4,2.0848E-4,2.1051E-4,2.292E-4,4.4686E-4,1.8426E-4,2.0137E-4,2.0403E-4,2.2895E-4,4.0994E-4,1.7827E-4,1.9647E-4,2.0272E-4,2.1899E-4,3.8996E-4,1.8502E-4,2.0329E-4,2.0341E-4,2.14E-4,3.9559E-4,1.755E-4,1.9229E-4,1.9755E-4,2.1432E-4,3.9105E-4,1.6997E-4,1.9356E-4,1.9536E-4,2.0549E-4,3.802E-4,1.6849E-4,1.8925E-4,1.9124E-4,2.0696E-4,3.7569E-4,1.6482E-4,1.8742E-4,1.8934E-4,2.0842E-4,3.9158E-4,1.639E-4,2.0366E-4,2.0499E-4,2.0499E-4,3.8424E-4,1.6659E-4,1.9214E-4,1.9804E-4,2.1397E-4,3.8006E-4,1.704E-4,1.9465E-4,1.9128E-4,2.3252E-4,5.2211E-4,2.4356E-4,2.538E-4,2.547E-4,3.5317E-4,6.2198E-4,3.0787E-4,3.4638E-4,3.3785E-4,3.7603E-4,6.2117E-4,2.8695E-4,3.084E-4,2.7959E-4,3.3437E-4,5.4306E-4,2.0628E-4,2.4493E-4,2.351E-4,2.3276E-4,4.6164E-4,1.8064E-4,2.2751E-4,2.3603E-4,2.7408E-4,4.2947E-4,1.8312E-4,2.1748E-4,2.1169E-4,2.3388E-4,4.5058E-4,1.7705E-4,2.1067E-4,2.1309E-4,2.1808E-4,4.0485E-4,1.7072E-4,1.938E-4,1.953E-4,2.1284E-4,3.9137E-4,1.6694E-4,1.9548E-4,1.9243E-4,2.5833E-4,4.9895E-4,2.2055E-4,2.5538E-4,2.2284E-4,2.6466E-4,5.1807E-4,1.8571E-4,2.5309E-4,2.3536E-4,2.7376E-4,4.4361E-4,1.6852E-4,2.229E-4,2.3496E-4,2.5501E-4,4.5065E-4,1.8609E-4,2.2179E-4,2.1231E-4,2.2122E-4,4.4244E-4,1.7753E-4,2.1659E-4,2.1142E-4,2.2371E-4,4.3164E-4,1.9407E-4,2.201E-4,2.0844E-4,2.3771E-4,4.3147E-4,1.6699E-4,2.1194E-4,2.2033E-4,2.4552E-4,4.3942E-4,1.7557E-4,2.2553E-4,2.2735E-4,2.3329E-4,4.625E-4,1.7541E-4,2.1595E-4,2.4429E-4,2.368E-4,4.4506E-4,1.8436E-4,2.1434E-4,2.1424E-4,2.315E-4,4.2518E-4,1.8316E-4,2.1037E-4,2.0817E-4,2.3142E-4,4.2762E-4,1.908E-4,2.1571E-4,2.199E-4,2.3019E-4,4.1336E-4,1.7675E-4,-3.0133E-6:7
3.434E-4,3.3572E-4,1.9197E-4,2.1814E-4,2.1632E-4,2.8455E-4,3.0751E-4,1.701E-4,2.0E-4,2.1307E-4,3.6858E-4,3.6671E-4,1.9067E-4,2.4824E-4,2.4415E-4,4.0121E-4,4.4636E-4,2.9516E-4,3.7798E-4,3.5285E-4,6.196E-4,5.2247E-4,3.3789E-4,3.6913E-4,3.7425E-4,4.956E-4,3.6256E-4,2.2025E-4,2.6115E-4,3.7799E-4,4.7154E-4,4.4671E-4,2.7382E-4,2.6123E-4,2.3104E-4,3.7165E-4,3.8549E-4,2.0548E-4,2.1611E-4,2.083E-4,3.0182E-4,3.0979E-4,1.7912E-4,2.0956E-4,2.0547E-4,2.9246E-4,3.0499E-4,1.8093E-4,2.0554E-4,2.0166E-4,2.7633E-4,3.0794E-4,1.7363E-4,2.006E-4,1.9667E-4,2.8053E-4,3.031E-4,1.7132E-4,2.0057E-4,1.9306E-4,2.7652E-4,3.0285E-4,1.7256E-4,2.2548E-4,2.3684E-4,3.584E-4,3.4722E-4,1.9516E-4,2.2844E-4,2.1274E-4,2.9062E-4,3.057E-4,1.772E-4,2.0697E-4,2.1178E-4,3.4916E-4,3.3293E-4,1.8492E-4,2.0173E-4,2.0184E-4,2.8335E-4,2.9757E-4,1.78E-4,2.0567E-4,1.9831E-4,2.9342E-4,3.011E-4,1.7491E-4,2.0237E-4,1.9372E-4,2.8488E-4,2.9988E-4,1.7204E-4,1.9967E-4,1.9689E-4,2.8561E-4,2.9212E-4,1.7416E-4,1.9868E-4,2.0907E-4,2.8487E-4,2.918E-4,1.689E-4,1.9879E-4,1.9636E-4,2.9564E-4,3.0097E-4,1.7568E-4,2.0066E-4,1.9647E-4,2.8791E-4,2.9683E-4,1.7039E-4,2.0142E-4,1.9345E-4,2.8371E-4,2.9349E-4,1.7296E-4,2.1757E-4,1.9955E-4,2.9409E-4,2.8663E-4,1.7333E-4,2.0127E-4,1.9414E-4,2.9935E-4,2.8509E-4,1.7246E-4,2.0596E-4,2.4144E-4,3.4173E-4,2.8535E-4,1.7326E-4,2.111E-4,2.2144E-4,3.0404E-4,2.9361E-4,1.7452E-4,2.0948E-4,1.9702E-4,2.9523E-4,2.8959E-4,1.7249E-4,2.015E-4,1.9333E-4,2.9444E-4,2.8879E-4,1.7945E-4,2.1497E-4,1.9979E-4,2.9092E-4,2.8159E-4,1.7363E-4,1.9908E-4,1.9396E-4,2.9272E-4,2.781E-4,1.6921E-4,2.0271E-4,1.9629E-4,2.9957E-4,2.8051E-4,1.6815E-4,2.0223E-4,1.9845E-4,2.9801E-4,2.769E-4,1.7721E-4,2.1547E-4,2.0397E-4,2.9878E-4,2.8714E-4,1.7772E-4,2.0685E-4,1.9691E-4,2.9927E-4,2.774E-4,1.705E-4,2.0535E-4,1.9727E-4,3.0045E-4,2.7563E-4,1.7138E-4,1.9959E-4,2.1029E-4,3.0879E-4,2.7501E-4,1.7393E-4,2.0892E-4,2.4527E-4,4.3772E-4,4.1617E-4,2.9242E-4,3.3737E-4,3.2641E-4,5.5132E-4,3.9715E-4,2.2019E-4,2.4657E-4,2.4034E-4,3.8757E-4,3.1468E-4,1.9229E-4,2.1429E-4,2.1536E-4,4.9815E-4,3.4595E-4,2.1497E-4,2.6044E-4,2.4072E-4,3.6818E-4,3.2254E-4,2.3089E-4,2.6901E-4,2.1977E-4,3.73E-4,2.8699E-4,1.9551E-4,2.2639E-4,2.1926E-4,3.8964E-4,3.1124E-4,1.7885E-4,2.1566E-4,1.9983E-4,3.2059E-4,2.7689E-4,1.7314E-4,2.0914E-4,2.3239E-4,4.7084E-4,3.5131E-4,2.4648E-4,3.4653E-4,2.9577E-4,3.5882E-4,2.9511E-4,2.1624E-4,2.5057E-4,2.2878E-4,3.5432E-4,3.0403E-4,2.0982E-4,2.2746E-4,2.0945E-4,3.6864E-4,2.8553E-4,1.8707E-4,2.2537E-4,2.15E-4,0.0:7
1.5672E-4,1.629E-4,1.7689E-4,3.5589E-4,1.6226E-4,1.7049E-4,1.8687E-4,1.901E-4,3.6518E-4,1.6906E-4,1.7921E-4,1.7365E-4,1.8496E-4,3.6371E-4,1.7219E-4,1.7069E-4,1.6948E-4,1.9138E-4,3.9065E-4,1.8241E-4,1.8729E-4,1.7816E-4,1.7961E-4,3.5984E-4,1.5984E-4,1.8045E-4,1.9796E-4,2.132E-4,3.5776E-4,1.6284E-4,1.614E-4,1.656E-4,1.8221E-4,3.4062E-4,1.5982E-4,1.5755E-4,1.667E-4,1.8026E-4,3.3254E-4,1.6583E-4,1.6241E-4,1.7457E-4,1.7724E-4,3.2178E-4,1.6117E-4,1.552E-4,1.5737E-4,1.739E-4,3.258E-4,1.6607E-4,1.5856E-4,1.6248E-4,1.8859E-4,3.7054E-4,2.0494E-4,2.0167E-4,1.8887E-4,1.9668E-4,3.6274E-4,1.7781E-4,1.6813E-4,1.7731E-4,1.8621E-4,3.4573E-4,1.777E-4,1.6909E-4,1.7689E-4,1.8973E-4,3.5551E-4,1.9812E-4,1.6953E-4,1.7122E-4,1.8283E-4,3.3985E-4,1.8256E-4,1.6457E-4,1.6357E-4,1.7747E-4,3.2934E-4,1.7471E-4,1.6291E-4,1.6411E-4,1.9171E-4,3.8457E-4,1.8981E-4,1.6781E-4,1.764E-4,1.9888E-4,3.4635E-4,1.8234E-4,1.6308E-4,1.6617E-4,1.7912E-4,3.363E-4,1.8603E-4,1.6331E-4,1.6641E-4,1.7871E-4,3.2682E-4,1.8583E-4,1.6269E-4,1.6407E-4,1.7584E-4,3.2759E-4,1.916E-4,1.6833E-4,1.6755E-4,1.7759E-4,3.3186E-4,1.9035E-4,1.6211E-4,1.7625E-4,1.9373E-4,3.3327E-4,1.8936E-4,1.6335E-4,1.6358E-4,1.7335E-4,3.0953E-4,1.9886E-4,1.7591E-4,1.8415E-4,2.0015E-4,3.4987E-4,1.9951E-4,1.629E-4,1.6247E-4,1.7584E-4,3.1446E-4,1.905E-4,1.5895E-4,1.6756E-4,1.7526E-4,3.1318E-4,1.9782E-4,1.5669E-4,1.6337E-4,1.7553E-4,3.0216E-4,2.0124E-4,1.6215E-4,1.7309E-4,1.7706E-4,2.9405E-4,1.9478E-4,1.5169E-4,1.5565E-4,1.7333E-4,2.9406E-4,2.0308E-4,1.5697E-4,1.6258E-4,1.7277E-4,3.1603E-4,2.2192E-4,1.8799E-4,2.3466E-4,2.0727E-4,3.1471E-4,2.206E-4,1.7449E-4,1.6861E-4,1.8713E-4,3.0884E-4,2.1725E-4,1.6508E-4,1.682E-4,1.8387E-4,3.0617E-4,2.2198E-4,1.7947E-4,1.9133E-4,2.1561E-4,3.5231E-4,2.3835E-4,1.7907E-4,1.7442E-4,1.837E-4,2.9918E-4,2.2917E-4,1.7159E-4,1.6947E-4,1.8196E-4,3.031E-4,2.4034E-4,1.6975E-4,1.7153E-4,1.9116E-4,3.1334E-4,2.5302E-4,1.8661E-4,1.767E-4,1.815E-4,2.6863E-4,2.2616E-4,1.5214E-4,1.5707E-4,1.7064E-4,2.8191E-4,2.3862E-4,1.5679E-4,1.5702E-4,1.7625E-4,2.6742E-4,2.3574E-4,1.5058E-4,1.5381E-4,1.6477E-4,2.6385E-4,2.3212E-4,1.5968E-4,1.573E-4,1.7097E-4,2.5112E-4,2.3702E-4,1.495E-4,1.58E-4,1.7029E-4,2.5367E-4,2.4319E-4,1.5998E-4,1.6264E-4,1.8975E-4,2.9383E-4,2.9692E-4,1.7509E-4,1.6666E-4,1.8187E-4,2.5614E-4,2.6297E-4,1.5844E-4,1.5349E-4,1.6957E-4,2.5416E-4,2.4686E-4,1.4985E-4,1.5944E-4,1.7162E-4,2.4717E-4,2.5031E-4,1.5552E-4,1.6043E-4,1.7441E-4,2.3691E-4,2.5938E-4,1.5461E-4,1.557E-4,1.8564E-4,2.597E-4,2.5548E-4,1.5064E-4,1.562E-4,1.7351E-4,2.3941E-4,2.7378E-4,1.6503E-4,1.6058E-4,1.6976E-4,2.2499E-4,2.6404E-4,1.5117E-4,1.4952E-4,1.6985E-4,2.2499E-4,2.658E-4,1.469E-4,1.5084E-4,1.6847E-4,2.1392E-4,2.6795E-4,1.5488E-4,1.5503E-4,1.6878E-4,2.5535E-4,3.0134E-4,1.7371E-4,1.6726E-4,1.6824E-4,2.198E-4,2.7954E-4,1.5475E-4,1.5372E-4,1.654E-4,2.0346E-4,2.9804E-4,1.5539E-4,1.5081E-4,1.6923E-4,2.0471E-4,2.8378E-4,1.4758E-4,1.4953E-4,1.6561E-4,1.9767E-4,2.8484E-4,1.5178E-4,1.4798E-4,1.6752E-4,2.0667E-4,2.9447E-4,1.4744E-4,1.4995E-4,1.7112E-4,1.9766E-4,2.917E-4,1.4549E-4,1.543E-4,1.6814E-4,1.8912E-4,2.9329E-4,1.4466E-4,1.494E-4,1.669E-4,1.8086E-4,2.9888E-4,1.4508E-4,1.4505E-4,1.7358E-4,1.8841E-4,2.9819E-4,1.4577E-4,1.5151E-4,1.7667E-4,2.0347E-4,3.4387E-4,1.7024E-4,1.734E-4,1.9827E-4,2.0567E-4,3.1129E-4,1.4865E-4,1.4989E-4,1.6479E-4,1.8245E-4,3.1475E-4,1.4709E-4,1.4908E-4,1.6629E-4,1.7185E-4,3.1344E-4,1.4718E-4,1.4971E-4,1.6872E-4,1.6912E-4,3.179E-4,1.4476E-4,1.4717E-4,1.6453E-4,1.6601E-4,3.1486E-4,1.4282E-4,1.4497E-4,1.6336E-4,1.7121E-4,3.4069E-4,1.531E-4,1.6037E-4,1.8682E-4,1.7325E-4,3.184E-4,1.4405E-4,1.4639E-4,1.6575E-4,1.6447E-4,3.1825E-4,1.3965E-4,1.4532E-4,1.7035E-4,1.6642E-4,3.225E-4,1.4271E-4,1.4623E-4,1.6028E-4,1.5818E-4,3.4952E-4,1.6544E-4,1.6748E-4,1.8562E-4,1.7377E-4,3.2479E-4,1.4614E-4,1.4464E-4,1.6148E-4,1.5795E-4,3.2537E-4,1.4547E-4,1.4674E-4,1.6184E-4,1.596E-4,3.3912E-4,1.4304E-4,1.4331E-4,1.6092E-4,1.5703E-4,3.2122E-4,1.4106E-4,1.4456E-4,1.6497E-4,1.5619E-4,3.3896E-4,1.4395E-4,1.4351E-4,1.6026E-4,1.5653E-4,3.2633E-4,1.4163E-4,1.426E-4,1.595E-4,1.5588E-4,3.2429E-4,1.4227E-4,1.4312E-4,1.6132E-4,1.5988E-4,3.2024E-4,1.4197E-4,1.4547E-4,1.6722E-4,1.5789E-4,3.3095E-4,1.4682E-4,1.4552E-4,1.6643E-4,1.6109E-4,3.3323E-4,1.5812E-4,1.654E-4,1.9286E-4,1.875E-4,3.9138E-4,1.512E-4,1.4569E-4,1.629E-4,1.6001E-4,3.2714E-4,1.5037E-4,1.4576E-4,1.6174E-4,1.5999E-4,3.3151E-4,1.5098E-4,1.4455E-4,1.6241E-4,1.689E-4:7
1.6758E-4,1.759E-4,2.7858E-4,2.1136E-4,1.5569E-4,1.5928E-4,1.7693E-4,2.717E-4,2.1998E-4,1.5161E-4,1.6266E-4,1.7375E-4,3.0836E-4,2.436E-4,1.6184E-4,1.8621E-4,1.9595E-4,3.2005E-4,2.4331E-4,1.626E-4,1.629E-4,1.8534E-4,2.7976E-4,2.4188E-4,1.596E-4,1.6789E-4,1.7972E-4,2.7044E-4,2.4106E-4,1.8008E-4,1.8848E-4,2.105E-4,3.7991E-4,2.5663E-4,1.6614E-4,1.8683E-4,1.871E-4,2.6342E-4,2.5467E-4,1.7004E-4,1.6846E-4,1.846E-4,2.8923E-4,2.9279E-4,1.6295E-4,1.5903E-4,1.8481E-4,2.4221E-4,2.5065E-4,1.527E-4,1.6822E-4,1.7921E-4,2.6219E-4,2.7234E-4,1.6368E-4,1.5974E-4,1.7648E-4,2.4113E-4,2.5453E-4,1.5486E-4,1.6021E-4,1.7405E-4,2.3722E-4,2.6135E-4,1.5417E-4,1.6303E-4,1.7451E-4,2.1337E-4,2.6867E-4,1.5184E-4,1.5381E-4,1.7938E-4,2.2838E-4,2.7909E-4,1.5545E-4,1.5259E-4,1.7801E-4,2.3385E-4,2.8387E-4,1.7189E-4,1.7183E-4,2.0568E-4,2.9734E-4,3.1051E-4,1.7098E-4,1.7155E-4,1.8254E-4,2.6355E-4,3.0241E-4,1.6146E-4,1.6305E-4,1.8542E-4,2.2085E-4,2.9447E-4,1.5776E-4,1.6623E-4,1.8397E-4,2.2704E-4,3.1188E-4,1.5825E-4,1.6134E-4,1.8544E-4,2.0977E-4,3.0582E-4,1.6796E-4,1.6697E-4,1.9081E-4,2.1622E-4,3.2222E-4,1.6619E-4,1.758E-4,2.1046E-4,2.2217E-4,3.3086E-4,1.6462E-4,1.6351E-4,1.8569E-4,1.9838E-4,3.1545E-4,1.5722E-4,1.5727E-4,1.7815E-4,2.1165E-4,3.4281E-4,1.7102E-4,1.7331E-4,1.8628E-4,1.9423E-4,3.2817E-4,1.567E-4,1.6523E-4,2.1498E-4,2.37E-4,4.075E-4,1.954E-4,1.7059E-4,2.038E-4,2.1052E-4,3.4829E-4,1.6179E-4,1.652E-4,1.856E-4,1.8077E-4,3.4668E-4,1.5786E-4,1.6003E-4,1.7795E-4,1.8094E-4,3.4584E-4,1.6164E-4,1.6295E-4,1.8043E-4,1.8072E-4,3.5807E-4,1.7216E-4,1.7483E-4,1.9606E-4,2.0351E-4,3.8023E-4,1.5514E-4,1.5872E-4,1.7824E-4,1.7561E-4,3.6359E-4,1.662E-4,1.6119E-4,1.7615E-4,1.6712E-4,3.4556E-4,1.5967E-4,1.5365E-4,1.7838E-4,1.705E-4,3.4569E-4,1.5813E-4,1.5623E-4,1.7388E-4,1.6712E-4,3.511E-4,1.5954E-4,1.5287E-4,1.7406E-4,1.6752E-4,3.7973E-4,1.802E-4,1.85E-4,1.9197E-4,1.7223E-4,3.5782E-4,1.6272E-4,1.5515E-4,1.7059E-4,1.682E-4,3.4968E-4,1.5871E-4,1.626E-4,1.731E-4,1.6746E-4,3.4894E-4,1.6106E-4,1.6972E-4,1.7326E-4,1.7564E-4,3.505E-4,1.6255E-4,1.5695E-4,1.8126E-4,1.6508E-4,3.3673E-4,1.587E-4,1.556E-4,1.7148E-4,1.621E-4,3.3684E-4,1.5709E-4,1.4692E-4,1.6545E-4,1.6386E-4,3.365E-4,1.5181E-4,1.5087E-4,1.7592E-4,1.6632E-4,3.498E-4,1.638E-4,1.4971E-4,1.7215E-4,1.647E-4,3.3544E-4,1.5665E-4,1.5869E-4,1.7378E-4,1.6852E-4,3.3097E-4,1.7392E-4,1.7004E-4,1.9607E-4,1.9437E-4,3.7381E-4,1.8643E-4,1.6466E-4,1.8676E-4,1.8193E-4,3.3818E-4,1.6449E-4,1.5648E-4,1.7508E-4,1.6633E-4,3.4865E-4,1.6931E-4,1.5307E-4,1.747E-4,1.7271E-4,3.4487E-4,1.693E-4,1.6595E-4,1.9298E-4,1.8117E-4,3.526E-4,1.7126E-4,1.5973E-4,1.7848E-4,1.7372E-4,3.4176E-4,1.7888E-4,1.5283E-4,1.6932E-4,1.6875E-4,3.3114E-4,1.6996E-4,1.484E-4,1.6671E-4,1.6287E-4,3.2649E-4,1.7349E-4,1.4737E-4,1.7118E-4,1.6278E-4,3.2247E-4,1.8217E-4,1.5077E-4,1.7437E-4,1.649E-4,3.5063E-4,1.944E-4,1.6857E-4,2.0171E-4,1.9748E-4,3.4295E-4,1.9861E-4,1.6679E-4,1.9291E-4,1.7336E-4,3.2119E-4,1.9338E-4,1.6333E-4,1.7399E-4,1.776E-4,3.3984E-4,1.9354E-4,1.6019E-4,1.8465E-4,1.6765E-4,3.2864E-4,1.8158E-4,1.4436E-4,1.6817E-4,1.7197E-4,3.2538E-4,1.8494E-4,1.4416E-4,1.7417E-4,1.7471E-4,3.6852E-4,2.36E-4,1.703E-4,1.8001E-4,1.6332E-4,3.513E-4,1.9276E-4,1.5472E-4,1.7015E-4,1.6175E-4,3.113E-4,1.9161E-4,1.4372E-4,1.6221E-4,1.6294E-4,3.1707E-4,2.0441E-4,1.678E-4,2.0239E-4,2.06E-4,3.3794E-4,2.0141E-4,1.5332E-4,1.9158E-4,2.0311E-4,3.9951E-4,2.1568E-4,1.5124E-4,1.7414E-4,1.812E-4,3.0867E-4,2.3139E-4,1.5391E-4,1.6962E-4,1.7326E-4,3.0174E-4,2.1032E-4,1.5178E-4,1.6974E-4,1.6651E-4,3.0226E-4,2.2685E-4,1.6204E-4,1.8218E-4,1.8152E-4,3.5881E-4,2.938E-4,1.9933E-4,1.9543E-4,1.7961E-4,3.4358E-4,2.481E-4,1.5828E-4,1.8532E-4,1.6956E-4,2.8182E-4,2.2562E-4,1.4052E-4,1.6142E-4,1.629E-4,2.9501E-4,2.2373E-4,1.4207E-4,1.6835E-4,1.7732E-4,2.7425E-4,2.3047E-4,1.4837E-4,1.6967E-4,1.7585E-4,2.8153E-4,2.3091E-4,1.4739E-4,1.7539E-4,1.8956E-4,3.5697E-4,2.7196E-4,1.5118E-4,1.9459E-4,1.9529E-4,2.698E-4,2.4099E-4,1.4334E-4,1.6214E-4,1.6218E-4,2.5443E-4,2.5758E-4,1.5232E-4,1.6767E-4,1.7805E-4,2.6128E-4,2.5351E-4,1.4274E-4,1.6272E-4,1.6126E-4,2.4848E-4,2.6725E-4,1.4898E-4,1.7552E-4,1.6586E-4,2.5234E-4,2.6443E-4,1.6452E-4,1.9403E-4,1.7016E-4,2.6824E-4,2.7882E-4,1.6815E-4,1.8106E-4,1.6954E-4,2.42E-4,2.6002E-4,1.4348E-4,1.7157E-4,1.6818E-4,2.4875E-4,2.7185E-4,1.4831E-4,1.6878E-4,1.6481E-4,2.3346E-4,2.7993E-4,1.4601E-4,1.7187E-4,1.6711E-4,2.6771E-4,3.1189E-4,1.6138E-4,1.8831E-4,1.7514E-4,2.528E-4,2.9041E-4,1.4351E-4,1.6504E-4,1.6424E-4,2.1366E-4,2.7578E-4,1.3948E-4,1.6095E-4,1.5669E-4,2.1813E-4,2.9179E-4,1.4191E-4,1.6345E-4,1.5771E-4,2.3914E-4,3.0771E-4,1.355E-4,1.6032E-4,1.621E-4,2.0479E-4,2.978E-4,1.3807E-4,1.5846E-4,1.5723E-4,1.9305E-4,2.992E-4,1.3489E-4,1.5488E-4,1.5882E-4,2.0399E-4,3.05E-4,1.3508E-4,1.5618E-4,1.561E-4,2.059E-4,3.1718E-4,1.4966E-4,1.7162E-4,1.6286E-4,1.9798E-4,3.0687E-4,1.4544E-4,1.7739E-4,1.8311E-4,2.102E-4,3.3773E-4,1.6166E-4,1.8493E-4,1.7189E-4,1.8487E-4,3.1067E-4,1.361E-4,1.6413E-4,1.635E-4,1.913E-4,3.2742E-4,1.4536E-4,1.6762E-4,1.5799E-4,1.8273E-4,3.3034E-4,1.4502E-4,1.6879E-4,1.5999E-4,1.8441E-4,3.2746E-4,1.3148E-4,1.686E-4,1.5972E-4,1.7633E-4,3.3688E-4,1.3624E-4,1.6223E-4,1.6168E-4,1.7151E-4,3.2248E-4,1.3201E-4,1.5641E-4,1.5948E-4,1.8056E-4,3.4213E-4,1.3466E-4,1.5171E-4,1.5293E-4,1.6444E-4,3.3863E-4,1.3393E-4,1.6583E-4,1.6725E-4,2.0263E-4,3.5568E-4,1.4568E-4,1.6436E-4,1.6437E-4,1.7701E-4,3.4428E-4,1.5303E-4,1.8726E-4,1.8631E-4,2.0157E-4,3.6271E-4,1.4412E-4,1.6749E-4,1.6301E-4,1.7047E-4,3.3776E-4,1.384E-4,1.5827E-4,1.5729E-4,1.7245E-4,3.3359E-4,1.3663E-4,1.9131E-4:7
1.6823E-4,2.1863E-4,2.5251E-4,3.979E-4,1.8338E-4,1.6538E-4,1.6767E-4,1.917E-4,3.5233E-4,1.8283E-4,1.6715E-4,1.7185E-4,1.8789E-4,3.5115E-4,1.8501E-4,1.8105E-4,1.8252E-4,1.8941E-4,3.3794E-4,1.7871E-4,1.5608E-4,1.5813E-4,1.7642E-4,3.1633E-4,1.8911E-4,1.5741E-4,1.7448E-4,1.8189E-4,3.0158E-4,1.7946E-4,1.5243E-4,1.5655E-4,1.73E-4,3.1144E-4,1.9261E-4,1.556E-4,1.5335E-4,1.7894E-4,2.934E-4,2.0491E-4,1.586E-4,1.5995E-4,1.9071E-4,3.1956E-4,1.9611E-4,1.6512E-4,1.8267E-4,2.0223E-4,3.4235E-4,2.051E-4,1.5536E-4,1.6792E-4,1.8042E-4,2.9754E-4,2.244E-4,1.6695E-4,1.6551E-4,1.8534E-4,3.0793E-4,2.0936E-4,1.6139E-4,1.6405E-4,1.7201E-4,2.8954E-4,2.2268E-4,1.5541E-4,1.5962E-4,1.7896E-4,2.8662E-4,2.1583E-4,1.6098E-4,1.5786E-4,1.7199E-4,2.771E-4,2.249E-4,1.5741E-4,1.6021E-4,1.8615E-4,2.8905E-4,2.3195E-4,1.5276E-4,1.5572E-4,1.8802E-4,2.6859E-4,2.2105E-4,1.6006E-4,1.5755E-4,1.7378E-4,2.5524E-4,2.301E-4,1.4912E-4,1.5054E-4,1.6757E-4,2.5395E-4,2.3816E-4,1.5362E-4,1.504E-4,1.821E-4,2.8592E-4,2.8691E-4,1.6847E-4,1.5353E-4,1.9443E-4,3.5305E-4,3.2066E-4,2.0449E-4,1.7996E-4,1.8823E-4,2.8686E-4,2.5162E-4,1.5623E-4,1.5658E-4,1.7553E-4,2.4628E-4,2.6015E-4,1.5607E-4,1.5289E-4,1.7163E-4,2.4237E-4,2.6372E-4,1.4944E-4,1.573E-4,1.7789E-4,2.4132E-4,2.638E-4,1.5798E-4,1.5934E-4,1.8178E-4,2.2461E-4,2.8043E-4,1.5021E-4,1.5351E-4,1.7885E-4,2.2491E-4,2.7214E-4,1.4425E-4,1.5429E-4,1.7092E-4,2.0822E-4,2.7776E-4,1.4493E-4,1.5678E-4,1.8894E-4,2.0869E-4,2.7956E-4,1.5505E-4,1.4853E-4,1.7598E-4,2.4104E-4,3.3207E-4,1.7324E-4,1.7348E-4,1.9413E-4,2.5095E-4,3.5797E-4,1.5752E-4,1.5112E-4,1.759E-4,1.9959E-4,3.0791E-4,1.4904E-4,1.522E-4,1.7542E-4,2.0314E-4,3.1363E-4,1.4727E-4,1.546E-4,1.8381E-4,1.9484E-4,3.3143E-4,1.6028E-4,1.5889E-4,1.7453E-4,1.8597E-4,3.2618E-4,1.4729E-4,1.5252E-4,1.7012E-4,1.693E-4,3.2047E-4,1.5469E-4,1.5847E-4,1.809E-4,1.888E-4,3.3143E-4,1.4422E-4,1.462E-4,1.6622E-4,1.6385E-4,3.2874E-4,1.4605E-4,1.4863E-4,1.6655E-4,1.7883E-4,3.4746E-4,1.4945E-4,1.6324E-4,1.9473E-4,1.8349E-4,3.7537E-4,1.7283E-4,2.1092E-4,2.0566E-4,1.7199E-4,4.1416E-4,1.5618E-4,1.5732E-4,1.8373E-4,1.8029E-4,3.6782E-4,1.5319E-4,1.5294E-4,1.7064E-4,1.6187E-4,3.4545E-4,1.5065E-4,1.5E-4,1.681E-4,1.6783E-4,3.4452E-4,1.5501E-4,1.5446E-4,1.8148E-4,1.7491E-4,3.7228E-4,1.649E-4,1.7248E-4,2.1178E-4,1.934E-4,3.863E-4,1.5229E-4,1.4819E-4,1.6879E-4,1.6408E-4,3.4536E-4,1.661E-4,1.5212E-4,1.7109E-4,1.7555E-4,3.4375E-4,1.5406E-4,1.4943E-4,1.6528E-4,1.7112E-4,3.6452E-4,1.658E-4,1.5682E-4,1.7325E-4,1.6071E-4,3.4909E-4,1.7904E-4,1.7201E-4,2.041E-4,1.8483E-4,3.6234E-4,1.9524E-4,1.72E-4,1.7865E-4,1.7833E-4,3.7606E-4,2.056E-4,2.0439E-4,2.1422E-4,1.9186E-4,3.9272E-4,1.7286E-4,1.51E-4,1.7873E-4,1.6733E-4,3.3808E-4,1.6642E-4,1.6294E-4,1.7617E-4,1.6913E-4,3.3591E-4,1.6507E-4,1.4877E-4,1.706E-4,1.6449E-4,3.6552E-4,1.6218E-4,1.3879E-4,1.7067E-4,1.6576E-4,3.3693E-4,1.6812E-4,1.4512E-4,1.6626E-4,1.7541E-4,3.4041E-4,1.7473E-4,1.5879E-4,1.722E-4,1.7057E-4,3.1628E-4,1.6695E-4,1.482E-4,1.677E-4,1.7029E-4,3.1808E-4,1.7562E-4,1.6106E-4,1.972E-4,1.8776E-4,3.6286E-4,2.0003E-4,1.9552E-4,1.8212E-4,1.5522E-4,3.2072E-4,1.7783E-4,1.4141E-4,1.7965E-4,1.7408E-4,3.2047E-4,1.9003E-4,1.4305E-4,1.6923E-4,1.6628E-4,3.0268E-4,1.7753E-4,1.4679E-4,1.7721E-4,1.7181E-4,3.3782E-4,2.1064E-4,1.6074E-4,1.8333E-4,1.7232E-4,2.9731E-4,1.9498E-4,1.5006E-4,1.6447E-4,1.7227E-4,3.1666E-4,1.8796E-4,1.4752E-4,1.7665E-4,1.8162E-4,3.4943E-4,2.2293E-4,1.7108E-4,1.7996E-4,1.8331E-4,3.332E-4,2.3009E-4,1.5879E-4,1.8099E-4,1.8613E-4,3.2746E-4,2.3897E-4,1.665E-4,1.9724E-4,2.071E-4,3.7819E-4,2.3443E-4,1.6649E-4,1.9746E-4,1.9258E-4,3.4426E-4,2.3814E-4,1.606E-4,1.8849E-4,1.8468E-4,3.2022E-4,2.3499E-4,1.5603E-4,1.908E-4,1.9305E-4,3.2181E-4,2.378E-4,1.6002E-4,1.9114E-4,1.8409E-4,3.2703E-4,2.3914E-4,1.596E-4,1.9372E-4,1.8187E-4,3.059E-4,2.4313E-4,1.6147E-4,1.7269E-4,1.8058E-4,2.9832E-4,2.4102E-4,1.5702E-4,1.8412E-4,1.7307E-4,2.8943E-4,2.4461E-4,1.5147E-4,1.7031E-4,1.7408E-4,2.7633E-4,2.5191E-4,1.5593E-4,1.7534E-4,1.7393E-4,2.8874E-4,2.5361E-4,1.5185E-4,1.6936E-4,1.8363E-4,3.1665E-4,2.9217E-4,1.7246E-4,2.056E-4,1.8856E-4,3.2926E-4,2.8404E-4,1.5487E-4,1.8465E-4,1.8667E-4,3.0172E-4,2.7982E-4,1.5688E-4,1.825E-4,1.8293E-4,2.7799E-4,2.8594E-4,1.5358E-4,1.8156E-4,1.9473E-4,2.722E-4,2.8769E-4,1.5744E-4,1.8918E-4,1.8672E-4,2.7278E-4,3.1721E-4,1.6133E-4,1.902E-4,1.8572E-4,2.6014E-4,2.9906E-4,1.5384E-4,1.867E-4,1.8518E-4,2.5941E-4,3.0655E-4,1.6453E-4,1.851E-4,1.8007E-4,2.5344E-4,3.2728E-4,1.726E-4,2.1285E-4,2.0851E-4,2.6706E-4,3.3999E-4,1.7593E-4,1.8803E-4,1.8107E-4,2.7681E-4,3.8144E-4,1.6614E-4,1.8407E-4,1.9043E-4,2.2825E-4,3.2368E-4,1.4717E-4,1.7396E-4,1.8465E-4,2.1746E-4,3.2241E-4,1.4754E-4,1.7751E-4,1.762E-4,2.2495E-4,3.4656E-4,1.6163E-4,1.8119E-4,1.813E-4,2.2791E-4,3.4814E-4,1.5653E-4,1.8197E-4,1.835E-4,2.2913E-4,3.5314E-4,1.575E-4,1.7809E-4,1.8181E-4,2.2153E-4,3.5761E-4,1.4235E-4,1.7895E-4,1.8923E-4,2.1599E-4,3.5804E-4,1.5778E-4,1.8073E-4,1.8632E-4,2.143E-4,3.6616E-4,1.573E-4,1.825E-4,1.8355E-4,1.9927E-4,3.692E-4,1.5644E-4,1.7971E-4,1.8534E-4,2.1079E-4,3.9068E-4,1.7446E-4,1.9774E-4,1.9503E-4,2.2306E-4,3.7863E-4,1.5597E-4,1.8015E-4,1.7784E-4,1.991E-4,3.6824E-4,1.4947E-4,1.7398E-4,1.753E-4,1.8075E-4,3.9259E-4,1.5274E-4,1.9606E-4,2.0176E-4,2.0556E-4,3.9706E-4,1.5494E-4,1.7884E-4,1.8759E-4,2.1116E-4,3.9688E-4,1.5412E-4,1.8051E-4,1.8413E-4,1.9159E-4,3.9646E-4,1.5323E-4,1.7895E-4,1.8891E-4,2.0399E-4,3.9185E-4,1.5935E-4,1.8095E-4,1.8692E-4,1.9353E-4,3.8489E-4,1.5719E-4,1.8699E-4,1.8032E-4,1.9829E-4,3.8487E-4,1.6345E-4,1.7781E-4,1.805E-4,1.9736E-4,3.7988E-4,1.6801E-4,1.9875E-4,2.0059E-4,2.1237E-4,3.8501E-4,1.9087E-4,2.0555E-4,1.8976E-4,2.0512E-4,3.8994E-4,-1.4457E-5:7
0.0013848,0.0012801,9.7371E-4,9.9436E-4,0.0011758,0.0014566,0.0013078,9.2225E-4,9.9508E-4,0.0012226,0.0014828,0.0013564,0.0010785,0.0010065,0.0013061,0.0015156,0.0013093,0.0010679,0.0011159,0.0011966,0.0014411,0.0014575,9.5195E-4,9.5679E-4,0.001223,0.0014657,0.0013523,0.0011115,0.0010928,0.0013289,0.0014479,0.0017184,0.0011536,9.4882E-4,0.0011811,0.0016049,0.0013007,9.1438E-4,0.0011167,0.0011856,0.0013856,0.0013307,0.0010546,9.5952E-4,0.0011514,0.0015111,0.001363,0.0010038,0.0010492,0.0011646,0.0013845,0.0014068,9.6637E-4,9.4002E-4,0.001211,0.0014733,0.0012728,9.8829E-4,0.0011082,0.0012433,0.0013304,0.0014004,0.0010077,9.7456E-4,0.001171,0.0015017,0.0013091,9.4637E-4,0.0010723,0.0012036,0.0013316,0.0013862,0.0010409,0.0010136,0.0011524,0.0014954,0.0013163,9.3237E-4,0.0010533,0.0012101,0.0013346,0.0013908,0.0010525,9.5453E-4,0.001233,0.0015275,0.0012423,0.001024,0.0010782,0.0011476,0.0013673,0.0014316,0.0010141,9.1781E-4,0.0011572,0.0014837,0.0012947,9.7658E-4,0.001064,0.0011824,0.0013357,0.0014377,0.0010189,9.1862E-4,0.001164,0.0014974,0.001304,9.4644E-4,0.0010618,0.0012045,0.0013309,0.0014103,0.0010536,9.3408E-4,0.0011179,0.0015042,0.0013914,0.0010093,0.0010344,0.0011008,0.0013765,0.0014436,9.6197E-4,9.2549E-4,0.0012108,0.00145,0.0012781,0.0010159,0.0010656,0.0011151,0.0013421,0.0014474,0.0010005,9.1219E-4,0.0011464,0.0014908,0.0012999,9.581E-4,0.0010682,0.0011833,0.0013143,0.0014463,0.0010351,9.11E-4,0.0011187,0.0015036,0.0013447,9.3196E-4,0.0010463,0.0011988,0.0013092,0.0014065,0.001074,9.5214E-4,0.0011619,0.0014503,0.0013094,0.0010407,0.0010538,0.0011252,0.0013538,0.0014598,9.7494E-4,9.0132E-4,0.0011417,0.0014815,0.0013118,9.9721E-4,0.0010611,0.00115,0.001336,0.0014631,0.0010485,9.1503E-4,0.0011124,0.0014808,0.001345,9.7479E-4,0.0010562,0.0011585,0.0013004,0.0014546,0.0010567,9.0583E-4,0.001111,0.0014932,0.0013632,9.4906E-4,0.0010335,0.0011915,0.0013947,0.0014559,9.8106E-4,9.0504E-4,0.0011649,0.0014572,0.0013215,0.0010299,0.0010599,0.0011279,0.0013454,0.0014674,0.0010005,9.1424E-4,0.0011245,0.0014686,0.0013336,9.9858E-4,0.0010939,0.0012393,0.0013377,0.0015076,0.0012281,0.0010298,0.0010465,0.0013831,0.0014495,0.0010979,0.0010122,0.0011434,0.0015324,0.0014759,0.0011185,9.6223E-4,0.00123,0.001545,0.0013647,0.0011487,0.0011066,0.0010976,0.0:7
0.0010181,0.0011495,0.0014594,0.0012903,9.3455E-4,0.0010426,0.0011698,0.0014266,0.0013612,9.5169E-4,9.8773E-4,0.0011892,0.0014323,0.0012771,0.001031,0.0010605,0.00105,0.0014336,0.0014094,9.5028E-4,9.5298E-4,0.0011855,0.0014986,0.0012399,0.0010042,0.001183,0.0012526,0.001478,0.001465,9.8918E-4,9.6089E-4,0.0012103,0.0015278,0.001254,0.0010522,0.0011343,0.0010744,0.0013897,0.0014578,9.6115E-4,9.6183E-4,0.0010664,0.0014481,0.0013559,9.6625E-4,0.0010559,0.0010535,0.0014111,0.0014321,9.3579E-4,9.6835E-4,0.0011854,0.0014558,0.001284,0.0010378,0.0010681,0.0010423,0.00139,0.0014414,9.6893E-4,9.5584E-4,0.0011589,0.0014746,0.0012544,0.0010055,0.0011068,0.0010773,0.0013546,0.0014368,0.0010149,9.6341E-4,0.0011089,0.0014861,0.0012779,9.6975E-4,0.0011022,0.0011077,0.0013987,0.001435,9.3369E-4,9.7917E-4,0.0011837,0.0014396,0.0012725,0.0010473,0.0010724,0.001021,0.0013947,0.0014429,9.4375E-4,0.0010011,0.001159,0.0014323,0.0012987,9.6605E-4,0.0010614,0.0011753,0.0014623,0.0014216,0.0010198,9.8128E-4,0.0012323,0.0015913,0.0012894,0.0010625,0.0011615,0.0011365,0.0013883,0.0015082,0.001011,9.5789E-4,0.0011386,0.0015553,0.0013739,0.0010755,0.0010835,0.0010084,0.0014762,0.0014725,9.2913E-4,0.001023,0.0012143,0.0014171,0.0012912,9.9496E-4,0.0010526,0.0010731,0.0014388,0.0014896,9.3974E-4,9.486E-4,0.0010916,0.0015819,0.0014009,9.6469E-4,0.0010872,0.0010431,0.001349,0.0014728,0.0010549,9.9416E-4,0.0010616,0.0014558,0.0013094,9.9376E-4,0.0011066,0.0010839,0.0013332,0.0014611,0.0010587,0.0010289,0.0011174,0.0014229,0.0013386,0.0010541,0.0010675,0.0010102,0.0013918,0.0014892,9.6239E-4,9.7479E-4,0.001141,0.0014592,0.0013134,0.0010403,0.0010969,0.0010371,0.0013583,0.0015714,0.0010724,9.4849E-4,0.0010936,0.0014711,0.0013119,0.0010125,0.0011111,0.0011133,0.0013315,0.001463,0.0010398,9.6918E-4,0.0010606,0.0014873,0.0013769,0.0010392,0.0010454,9.8957E-4,0.0014189,0.0014668,9.4065E-4,0.0010289,0.0011518,0.0014106,0.0013178,0.001069,0.0010812,0.0010262,0.0013789,0.0016248,0.0010935,9.6266E-4,0.0011649,0.0015421,0.0013107,0.0011181,0.00110