# -*- coding: utf-8 -*-
"""Catch22 test code."""
import numpy as np
from numpy import testing

from sktime.datasets import load_basic_motions, load_unit_test
from sktime.transformations.panel.catch22 import Catch22


def test_catch22_on_unit_test():
    """Test of Catch22 on unit test data."""
    # load unit test data
    X_train, y_train = load_unit_test(split="train")
    indices = np.random.RandomState(0).choice(len(y_train), 5, replace=False)

    # fit catch22
    c22 = Catch22(outlier_norm=True)
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    data = np.nan_to_num(c22.transform(X_train.iloc[indices]), False, 0, 0, 0)
    testing.assert_array_almost_equal(data, catch22_unit_test_data)


def test_catch22_single_feature_on_unit_test():
    """Test of Catch22 on unit test data."""
    # load unit test data
    X_train, y_train = load_unit_test(split="train")
    indices = np.random.RandomState(0).choice(len(y_train), 2, replace=False)

    # fit catch22
    c22 = Catch22(outlier_norm=True)
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    results = catch22_unit_test_data.transpose()
    for i in range(22):
        data = np.nan_to_num(
            c22.transform_single_feature(X_train.iloc[indices], i), False, 0, 0, 0
        )
        testing.assert_array_almost_equal(data, results[i][:2])


def test_catch22_on_basic_motions():
    """Test of Catch22 on basic motions data."""
    # load basic motions data
    X_train, y_train = load_basic_motions(split="train")
    indices = np.random.RandomState(4).choice(len(y_train), 5, replace=False)

    # fit catch22
    c22 = Catch22()
    c22.fit(X_train.iloc[indices], y_train[indices])

    # assert transformed data is the same
    data = np.nan_to_num(c22.transform(X_train.iloc[indices]), False, 0, 0, 0)
    testing.assert_array_almost_equal(data, catch22_basic_motions_data)


catch22_unit_test_data = np.array(
    [
        [
            125.0,
            64.0,
            12.0,
            0.4166666666666666,
            -0.5,
            5.0,
            12.0,
            201809.1796094523,
            0.19634954084936207,
            290.41157230783676,
            10158389.695652174,
            0.6890092384766584,
            6.0,
            1.0,
            4.0,
            1.4836116549664229,
            1.1428571428571428,
            0.33206729175825095,
            0.0,
            0.0,
            0.1111111111111111,
            6.0,
        ],
        [
            162.39999389648438,
            93.69999694824219,
            12.0,
            0.37499999999999994,
            -0.45833333333333337,
            5.0,
            10.0,
            215833.29634416648,
            0.19634954084936207,
            311.8028073602811,
            6178823.478260869,
            0.6040399169957669,
            5.0,
            0.9565217391304348,
            5.0,
            1.601149361627198,
            0.5714285714285714,
            0.33199585882480837,
            0.0,
            0.0,
            0.1111111111111111,
            0.0,
        ],
        [
            132.89999389648438,
            74.94999694824219,
            12.0,
            0.37499999999999994,
            -0.5416666666666667,
            5.0,
            11.0,
            133274.21287765825,
            0.19634954084936207,
            259.5532704990584,
            2922963.4782608696,
            0.8020096485829413,
            5.0,
            1.0,
            5.0,
            1.4836116549664229,
            0.42857142857142855,
            0.33170445599629694,
            0.0,
            0.0,
            0.1111111111111111,
            5.0,
        ],
        [
            215.1999969482422,
            122.0999984741211,
            12.0,
            0.5416666666666666,
            -0.45833333333333337,
            6.0,
            16.0,
            404807.2927517244,
            0.19634954084936207,
            331.0570128841759,
            10323049.43478261,
            0.6251819918197027,
            7.0,
            1.0,
            6.0,
            1.714203171343286,
            0.375,
            0.2487030955256314,
            0.0,
            0.0,
            0.16666666666666666,
            0.0,
        ],
        [
            155.10000610351562,
            82.55000305175781,
            11.0,
            0.37499999999999994,
            -0.5208333333333334,
            5.0,
            12.0,
            276289.15137908916,
            0.19634954084936207,
            317.8343938909621,
            11863211.826086957,
            0.7449158910995153,
            6.0,
            1.0,
            4.0,
            1.4836116549664229,
            1.0,
            0.3320445278536131,
            0.0,
            0.0,
            0.1111111111111111,
            0.0,
        ],
    ]
)
catch22_basic_motions_data = np.array(
    [
        [
            0.8918032050132751,
            1.2091199159622192,
            7.0,
            -0.19999999999999998,
            0.04000000000000002,
            2.0,
            3.0,
            0.4157941078326768,
            0.9326603190344698,
            1.3955907271090915,
            0.9845623800592634,
            0.09564687341141452,
            1.0,
            0.9191919191919192,
            4.0,
            2.082170319125244,
            0.5,
            0.06163061709513441,
            0.2,
            0.37142857142857144,
            0.010828821324448144,
            13.0,
            -1.885130763053894,
            -3.4694998264312744,
            8.0,
            -0.5599999999999999,
            0.02000000000000002,
            3.0,
            6.0,
            10.62560771783014,
            0.4908738521234052,
            3.4816255495999884,
            -0.9327721496094612,
            0.2864509867727193,
            2.0,
            0.9191919191919192,
            8.0,
            1.8188361150030001,
            0.75,
            0.09336671474356913,
            0.17142857142857143,
            0.2857142857142857,
            0.016782407407407406,
            11.0,
            0.06499199569225311,
            0.29016080498695374,
            9.0,
            -0.78,
            -0.33999999999999997,
            2.0,
            5.0,
            0.3405754433657383,
            0.6381360077604268,
            0.9140443628010739,
            0.11538091119207523,
            0.13425498741199637,
            2.0,
            0.8484848484848485,
            8.0,
            1.99824822952715,
            0.3333333333333333,
            0.09666072557516261,
            0.6857142857142857,
            0.3142857142857143,
            0.0033670033670033673,
            10.0,
            0.02157360315322876,
            0.02157360315322876,
            10.0,
            -0.38,
            0.060000000000000026,
            2.0,
            7.0,
            0.19382684006732848,
            0.6381360077604268,
            0.7083128598594379,
            -0.08481055964484287,
            0.11586578507496163,
            2.0,
            0.898989898989899,
            5.0,
            2.023628496700834,
            0.3333333333333333,
            0.15491926773681503,
            0.17142857142857143,
            0.3142857142857143,
            0.0052035506580961136,
            12.0,
            0.3028254210948944,
            0.1961572915315628,
            10.0,
            0.03000000000000002,
            0.35000000000000003,
            2.0,
            7.0,
            0.1221410884765176,
            0.4908738521234052,
            0.4555341144251315,
            0.019899082500338953,
            0.15641979090238425,
            2.0,
            0.8282828282828283,
            8.0,
            1.9427595746295994,
            0.6666666666666666,
            0.5965434387868841,
            0.8,
            0.22857142857142856,
            0.0036730945821854917,
            13.0,
            0.5643685460090637,
            0.9088757634162903,
            8.0,
            -0.10999999999999999,
            -0.72,
            3.0,
            6.0,
            1.718140977735782,
            0.4908738521234052,
            1.406352518608061,
            -0.4162277441530886,
            0.19136412045734105,
            2.0,
            0.9090909090909091,
            8.0,
            1.8063728349845416,
            1.0,
            0.10715327274583623,
            0.7428571428571429,
            0.2,
            0.012549739822467097,
            11.0,
        ],
        [
            0.14669835567474365,
            1.7613779306411743,
            9.0,
            -0.15,
            0.03000000000000002,
            2.0,
            8.0,
            32.28497075442002,
            0.4908738521234052,
            7.054625316380145,
            159.5298195140038,
            0.1970946863662482,
            4.0,
            0.9090909090909091,
            8.0,
            1.9656035130794418,
            0.3333333333333333,
            0.10116304389895676,
            0.17142857142857143,
            0.6571428571428571,
            0.009114583333333332,
            3.0,
            -1.030956506729126,
            0.5692375898361206,
            13.0,
            0.2,
            -0.37,
            2.0,
            3.0,
            18.302896760399534,
            0.7363107781851077,
            7.403209645459385,
            -298.4340786545918,
            0.10077708465940147,
            3.0,
            0.9090909090909091,
            7.0,
            2.045121926807475,
            0.3333333333333333,
            0.09919324376547187,
            0.3142857142857143,
            0.2,
            0.0015304560759106215,
            8.0,
            0.17208588123321533,
            -1.3777118921279907,
            12.0,
            -0.22999999999999998,
            -0.03999999999999998,
            2.0,
            3.0,
            14.393847548206798,
            0.7853981633974483,
            6.470008428295701,
            91.0107452584993,
            0.15602495939728658,
            3.0,
            0.9090909090909091,
            5.0,
            2.019894751131832,
            0.3333333333333333,
            0.13030597478275818,
            0.7428571428571429,
            0.5428571428571428,
            0.01071319253137435,
            13.0,
            -0.21573293209075928,
            -1.7152117490768433,
            13.0,
            0.15000000000000002,
            -0.18,
            2.0,
            5.0,
            7.140703520416698,
            0.6872233929727672,
            4.225230407314073,
            4.1152594706221945,
            0.099161829639298,
            2.0,
            0.898989898989899,
            6.0,
            1.9989023294729955,
            0.3333333333333333,
            0.10466548428494883,
            0.6571428571428571,
            0.22857142857142856,
            0.002448729721456994,
            14.0,
            0.6855520009994507,
            -0.11772105097770691,
            14.0,
            0.18000000000000002,
            0.30000000000000004,
            2.0,
            4.0,
            1.6007411385366714,
            0.8344855486097889,
            2.9956662805419616,
            3.219177199529011,
            0.07087902201644689,
            1.0,
            0.8686868686868687,
            5.0,
            2.029434458920892,
            0.3333333333333333,
            0.06395337309877179,
            0.7428571428571429,
            0.8285714285714286,
            0.006121824303642486,
            6.0,
            -1.5436909198760986,
            0.09721297025680542,
            8.0,
            -0.13999999999999999,
            0.10000000000000002,
            2.0,
            5.0,
            7.30763195092243,
            0.6872233929727672,
            5.167140170915735,
            119.50486637158377,
            0.02916540215720636,
            2.0,
            0.8888888888888888,
            5.0,
            1.985020211058056,
            0.3333333333333333,
            0.13065174390325549,
            0.22857142857142856,
            0.2,
            0.00704009794918886,
            8.0,
        ],
        [
            -0.21764549612998962,
            -0.2520149350166321,
            7.0,
            -0.12999999999999998,
            0.02000000000000002,
            1.0,
            6.0,
            0.008072202808200962,
            0.8835729338221293,
            0.15059656563739415,
            -0.0018351152670482611,
            0.05694620080063944,
            2.0,
            0.696969696969697,
            5.0,
            2.149409833486172,
            0.3333333333333333,
            1.632146840191609,
            0.6,
            0.2,
            0.002448729721456994,
            19.0,
            0.2537215054035187,
            0.3413819670677185,
            8.0,
            -0.11999999999999998,
            -0.01999999999999998,
            2.0,
            5.0,
            0.1288345223696304,
            0.5890486225480862,
            0.45449491669422204,
            0.023447774729658165,
            0.21303632326770555,
            2.0,
            0.8585858585858586,
            7.0,
            1.9397728196794972,
            1.0,
            0.5715081189534341,
            0.8285714285714286,
            0.2,
            0.01071319253137435,
            10.0,
            -0.04504929482936859,
            -0.0048898495733737946,
            9.0,
            -0.91,
            -0.21999999999999997,
            2.0,
            3.0,
            0.0036809403198692333,
            0.9326603190344698,
            0.14807998759532848,
            -0.0013092440913292152,
            0.04279457758751967,
            1.0,
            0.6161616161616161,
            6.0,
            2.084842812789739,
            1.0,
            1.2418887993003067,
            0.6,
            0.17142857142857143,
            0.00041649312786339065,
            0.0,
            -0.03675450012087822,
            -0.017578249797225,
            11.0,
            -0.39,
            -0.07999999999999999,
            2.0,
            5.0,
            0.004074913925442205,
            0.5890486225480862,
            0.07700253732075672,
            -2.876183472570848e-05,
            0.1781926299113456,
            2.0,
            0.3939393939393939,
            7.0,
            1.978641920148271,
            0.25,
            3.9759961437337634,
            0.7428571428571429,
            0.2571428571428571,
            0.029513888888888888,
            0.0,
            0.01997550018131733,
            0.004394750110805035,
            8.0,
            -0.059999999999999984,
            0.050000000000000024,
            2.0,
            5.0,
            0.0013068652451353473,
            0.5890486225480862,
            0.04667723207175015,
            -1.3120858261862348e-05,
            0.06145220255682738,
            2.0,
            0.24242424242424243,
            7.0,
            2.0340981981783077,
            0.3333333333333333,
            6.849703179692024,
            0.7428571428571429,
            0.2,
            0.0033670033670033673,
            0.0,
            -0.09135379642248154,
            -0.12584449350833893,
            11.0,
            -0.15499999999999997,
            0.12500000000000003,
            2.0,
            5.0,
            0.0212040936539578,
            0.5890486225480862,
            0.1719479513148908,
            0.00010179347533284903,
            0.10252057373355115,
            2.0,
            0.7070707070707071,
            7.0,
            1.8809298286523062,
            1.0,
            3.141567661590354,
            0.8,
            0.2,
            0.002448729721456994,
            10.0,
        ],
        [
            14.7529616355896,
            12.611507415771484,
            8.0,
            -0.00999999999999998,
            -0.16999999999999998,
            2.0,
            5.0,
            8.318622387800366,
            0.7363107781851077,
            15.168047762147923,
            611.2310948749061,
            0.28365605782932746,
            1.0,
            0.8484848484848485,
            5.0,
            2.058033070068309,
            1.0,
            0.1722694421830499,
            0.2571428571428571,
            0.22857142857142856,
            0.004581424406497292,
            7.0,
            -8.747762680053711,
            -11.041603088378906,
            5.0,
            0.09000000000000002,
            0.010000000000000021,
            2.0,
            4.0,
            5.301622652377208,
            0.7363107781851077,
            16.035941633179107,
            -666.9228361468672,
            0.23576064858527976,
            1.0,
            0.8585858585858586,
            4.0,
            2.0047829156878914,
            1.0,
            0.12217810667775668,
            0.8285714285714286,
            0.17142857142857143,
            0.004997917534360683,
            7.0,
            -1.1495373249053955,
            -3.2478394508361816,
            8.0,
            0.13000000000000003,
            -0.07999999999999999,
            1.0,
            2.0,
            1.7626606212765765,
            1.4726215563702154,
            3.327018140109667,
            3.93262437098413,
            0.09502937699128317,
            2.0,
            0.8585858585858586,
            5.0,
            2.1461714969301795,
            0.5,
            0.08412591763895415,
            0.6,
            0.7714285714285715,
            0.001249479383590171,
            3.0,
            0.09455001354217529,
            -1.7291944026947021,
            5.0,
            0.060000000000000026,
            0.12000000000000002,
            1.0,
            3.0,
            0.5924214943974812,
            0.8835729338221293,
            2.807108705482139,
            13.924405178263722,
            0.13175006076929208,
            1.0,
            0.8585858585858586,
            7.0,
            2.1384035366118392,
            0.5,
            0.06077800751796398,
            0.8285714285714286,
            0.22857142857142856,
            0.012355962793280575,
            8.0,
            -0.24130192399024963,
            -0.7284327745437622,
            6.0,
            -0.04999999999999998,
            -0.10999999999999999,
            2.0,
            4.0,
            0.20857329960050977,
            0.7363107781851077,
            2.8862798870017943,
            -0.31401398041920364,
            0.16821769426829922,
            1.0,
            0.8383838383838383,
            6.0,
            2.069296686149424,
            0.5,
            0.04980541214544212,
            0.8285714285714286,
            0.17142857142857143,
            0.016520894071914476,
            8.0,
            -0.2210599184036255,
            0.9036822319030762,
            6.0,
            0.010000000000000021,
            0.04000000000000002,
            2.0,
            4.0,
            1.3956807551988657,
            0.7363107781851077,
            7.008488855825391,
            -63.8967279754948,
            0.2978750325486375,
            1.0,
            0.8585858585858586,
            5.0,
            1.930446332244209,
            0.6666666666666666,
            0.08484837147603179,
            0.8285714285714286,
            0.17142857142857143,
            0.016222834404652588,
            8.0,
        ],
        [
            -0.061873406171798706,
            0.19905470311641693,
            6.0,
            0.03000000000000002,
            0.13000000000000003,
            2.0,
            4.0,
            0.5010200558195357,
            0.8835729338221293,
            1.5209195142765164,
            1.2447131072202249,
            0.19205545891857195,
            1.0,
            0.898989898989899,
            6.0,
            2.048095330620426,
            0.3333333333333333,
            0.07177804257905915,
            0.17142857142857143,
            0.2,
            0.00918273645546373,
            6.0,
            -3.017563581466675,
            -3.523517608642578,
            9.0,
            2.0816681711721685e-17,
            0.10000000000000002,
            3.0,
            7.0,
            7.638503051922684,
            0.44178646691106466,
            2.496075719404429,
            -1.222706449268504,
            0.3018668542029954,
            2.0,
            0.9090909090909091,
            8.0,
            1.777081182361326,
            1.0,
            0.0990031637556529,
            0.17142857142857143,
            0.3142857142857143,
            0.008101851851851851,
            13.0,
            -0.5190370082855225,
            -0.6648595929145813,
            14.0,
            -0.12999999999999998,
            0.19000000000000003,
            3.0,
            6.0,
            0.30963323030346973,
            0.44178646691106466,
            0.6655059035440576,
            -0.008610657091702733,
            0.2147610682444855,
            2.0,
            0.8383838383838383,
            6.0,
            1.8776822467319911,
            0.5,
            0.42674435952874934,
            0.6571428571428571,
            0.2,
            0.013310185185185184,
            13.0,
            -0.2996295094490051,
            -0.09548195451498032,
            8.0,
            0.18000000000000002,
            0.22000000000000003,
            3.0,
            8.0,
            0.37897741148145286,
            0.44178646691106466,
            0.7076375014406678,
            -0.13875299485236925,
            0.21148547128335846,
            2.0,
            0.8383838383838383,
            7.0,
            1.9194916843159386,
            0.5,
            0.25533627410316456,
            0.17142857142857143,
            0.2857142857142857,
            0.00636574074074074,
            14.0,
            -0.3872542083263397,
            0.4293355792760849,
            9.0,
            0.11000000000000003,
            0.35000000000000003,
            3.0,
            7.0,
            0.27189583271693224,
            0.44178646691106466,
            0.4774453914679649,
            0.006508950604157761,
            0.23774099486653397,
            3.0,
            0.8080808080808081,
            7.0,
            1.7774697785906677,
            1.0,
            0.6829363537871337,
            0.17142857142857143,
            0.2571428571428571,
            0.009837962962962962,
            13.0,
            -0.9867794513702393,
            -1.4515380263328552,
            9.0,
            -0.03999999999999998,
            0.08000000000000002,
            3.0,
            7.0,
            1.5658165369200059,
            0.44178646691106466,
            1.1243609493963882,
            -0.047503710587904174,
            0.2510749948327187,
            3.0,
            0.8686868686868687,
            8.0,
            1.7647129694643358,
            1.0,
            0.3430167503549635,
            0.17142857142857143,
            0.2857142857142857,
            0.016782407407407406,
            13.0,
        ],
    ]
)
