#﻿# PLAID dataset
#
#PLAID stands for the Plug Load Appliance Identification Dataset. The data are  intended for load identification research. The first version of PLAID is named PLAID1, collected in summer 2013. A second version of PLAID was collected in winter 2014 and released under the name PLAID2.
#This dataset comes from PLAID1. It includes current and voltage measurements sampled at 30 kHz from 11 different appliance types present in more than 56 households in Pittsburgh, Pennsylvania, USA. Data collection took place during the summer of 2013. Each appliance type is represented by dozens of different instances of varying makes/models.
#For each appliance, three to six measurements were collected for each state transition. These measurements were then post-processed to extract a few-second-long window containing both the steady-state operation and the startup transient )when available).
#The classes correspond to 11 different appliance types: % air
#conditioner (class 0), compact flourescent lamp, fan, fridge,
#hairdryer , heater, incandescent light bulb, laptop, microwave,
#vacuum,washing machine (class 10)%
#Train size: 537
#Test size: 537
#Missing value: No
#Number of classses: 11
#
#Time series length: Vary
#Data created by Gao, Jingkun, et al. (see [1], [2], [3]). Data edited by Patrick Schafer and Ulf Leser (see [4]).
#[1] Gao, Jingkun, et al. "PLAID: a public dataset of high-resolution electrical appliance measurements for load identification research: demo abstract." proceedings of the 1st ACM Conference on Embedded Systems for Energy-Efficient Buildings. ACM, 2014.
#[2] https://github.com/jingkungao/PLAID
#[3] http://www.plaidplug.com/
#[4] Schäfer, Patrick, and Ulf Leser. "Fast and accurate time series classification with weasel." Proceedings of the 2017 ACM on Conference on Information and Knowledge Management. ACM, 2017.
@problemName PLAID
@timeStamps false
@missing false
@univariate true
@equalLength false
@classLabel true 0 1 2 3 4 5 6 7 8 9 10
@data
-0.021696,0.0087359,-0.019571,-0.0030201,-0.0067161,-0.022311,0.018057,-0.02187,1.0295E-4,-0.0046773,-0.026946,0.011379,-0.026074,-0.002195,0.0035179,-0.022612,0.0058618,-0.021499,-0.0052213,2.351E-4,1.068,1.1277,0.15044,0.40116,0.26701,0.067654,0.16456,0.10035,0.14587,0.15063,0.065254,0.1265,0.089655,0.12397,0.12215,0.068655,0.1151,0.089864,0.12794,0.13011,0.070138,0.11789,0.087966,0.13298,0.1266,0.072963,0.11416,0.090972,0.12714,0.12453,0.073542,0.11357,0.086363,0.12973,0.12985,0.069211,0.11762,0.087322,0.12819,0.12725,0.070977,0.12324,0.087778,0.13203,0.1268,0.072408,0.11396,0.089161,0.12576,0.13125,0.073639,0.11328,0.08895,0.13141,0.12404,0.067099,0.11889,0.087793,0.12931,0.12631,0.071516,0.11355,0.089945,0.13024,0.12966,0.070724,0.1151,0.086424,0.12482,0.12745,0.069113,0.12415,0.089009,0.13127,0.13238,0.074632,0.11518,0.08904,0.12928,0.12923,0.068295,0.11521,0.086305,0.12816,13.432,19.675,15.678,16.637,19.397,21.79,19.869,15.871,16.651,19.59,21.917,19.756,15.995,16.476,19.59,21.944,19.79,16.062,16.373,19.457,21.769,19.669,16.072,16.354,19.494,21.852,19.697,16.031,16.258,19.405,21.789,19.681,16.03,16.197,19.337,21.848,19.783,16.079,16.142,19.236,21.706,19.711,16.056,16.093,19.246,21.735,19.649,15.99,16.042,19.183,21.495,19.57,16.027,16.02,19.035,21.411,19.591,15.94,15.914,19.031,21.358,19.518,15.935,15.825,18.827,21.283,19.5,15.88,15.834,18.806,21.183,19.423,15.803,15.704,18.641,21.07,19.384,15.793,15.696,18.591,20.992,19.26,15.71,15.536,18.459,20.932,19.265,15.684,15.507,18.382,20.754,19.1,15.543,15.423,18.214,20.696,19.018,15.522,15.253,18.098,20.434,18.861,15.396,15.168,17.989,20.331,18.802,15.292,15.043,17.855,20.096,18.647,15.217,14.921,17.742,20.024,18.616,15.152,14.852,17.596,19.794,18.447,15.012,14.739,17.467,19.691,18.377,14.897,14.623,17.259,19.474,18.223,14.815,14.545,17.169,19.412,18.056,14.712,14.355,16.969,19.189,17.945,14.604,14.342,16.838,19.075,17.736,14.531,14.102,16.703,18.864,17.708,14.371,14.067,16.534,18.698,17.448,14.262,13.873,16.372,18.55,17.407,14.287,13.721,16.314,18.311,17.334,14.061,13.626,16.215,18.179,17.268,13.94,13.578,15.993,18.0,17.089,13.813,13.528,15.855,17.92,16.996,13.747,13.443,15.65,17.752,16.804,13.628,13.34,15.524,17.664,16.779,13.59,13.258,15.417,17.525,16.672,13.479,13.141,15.402,17.404,16.653,13.462,12.967,15.319,17.247,16.532,13.486,12.824,15.267,17.211,16.384,13.512,12.741,15.026,17.15,16.263,13.399,12.853,14.945,17.051,16.289,13.164,12.752,14.916,16.82,16.318,13.221,12.565,14.938,16.784,16.128,13.298,12.534,14.675,16.829,16.094,13.114,12.646,14.631,16.599,16.166,13.092,12.442,14.712,16.622,16.031,13.237,12.407,14.438,16.643,15.971,13.066,12.519,14.5,16.462,16.063,13.093,12.232,14.473,16.495,15.905,13.203,12.393,14.313,16.482,16.005,12.957,12.278,14.46,16.326,15.979,13.184,12.171,14.255,16.429,15.88,12.989,12.36,14.319,16.252,16.037,13.058,12.097,14.265,16.303,15.821,13.086,12.284,14.115,16.209,15.999,12.969,12.125,14.26,16.202,15.884,13.198,12.199,14.039,16.241,15.942,12.957,12.178,14.162,16.099,15.952,13.173,12.063,13.952,16.218,15.915,13.003,12.202,14.038,16.06,16.007,13.139,11.974,13.992,16.206,15.844,13.07,12.19,13.954,16.051,16.026,13.118,11.965,13.999,16.128,15.824,13.153,12.162,13.828,15.988,16.012,13.072,11.956,13.975,16.037,15.892,13.277,12.118,13.747,15.977,16.026,13.073,11.966,13.929,15.962,15.925,13.308,12.019,13.638,15.946,15.992,13.043,11.972,13.872,15.882,15.973,13.322,11.952,13.618,15.974,16.002,13.097,12.06,13.849,15.893,16.022,13.344,11.905,13.567,15.935,15.967,13.168,12.091,13.772,15.845,16.026,13.374,11.861,13.534,15.967,16.005,13.29,12.102,13.693,15.802,16.087,13.392,11.81,13.531,15.913:0
-3.8077E-5,-5.6978E-4,3.6725E-4,-8.6174E-4,6.4331E-4,-1.9001E-4,-6.1188E-4,8.3294E-4,-0.001213,5.0622E-4,-3.6559E-4,-6.1216E-4,4.1828E-4,-8.3466E-4,9.2445E-4,5.8103E-5,-5.3415E-4,7.0114E-4,-8.0705E-4,0.0011261,-3.127E-4,4.221E-5,9.3451E-4,-5.9191E-4,0.082361,0.05282,0.028264,0.013292,0.013067,0.012883,0.015806,0.015353,0.010813,0.0091782,0.0095753,0.01033,0.0093256,0.0081374,0.0057584,0.0081821,0.0089513,0.008402,0.00772,0.0063775,0.0092099,0.0093002,0.0086033,0.0080437,0.0061131,0.0089214,0.0096224,0.0082775,0.0075413,0.0059455,0.0087858,0.0089318,0.0078982,0.0072751,0.0057246,0.0087111,0.008927,0.007313,0.0072437,0.0053078,0.0083222,0.0085056,0.0073587,0.0073624,0.0054496,0.0085755,0.0081964,0.0072658,0.0072227,0.0055762,0.0078119,0.0084607,0.0070426,0.0072898,0.0055265,0.0084378,0.0084017,0.0071405,0.0069192,0.0051593,0.0084127,0.0081955,0.006571,0.0072335,0.0048608,0.0084921,0.0083277,0.0063864,0.0066243,0.0049636,0.0078843,0.0086996,0.0065834,0.0071334,0.0052737,0.0080254,0.0083682,0.0065867,0.0067184,0.0051234,0.0081847,0.0081284,0.0068699,0.0070042,0.35679,0.83131,0.99172,1.0096,0.84083,0.74218,0.82754,0.99699,1.011,0.83632,0.74556,0.82628,0.99552,1.0077,0.83239,0.7431,0.82548,0.99609,1.0062,0.83029,0.74226,0.82444,0.99423,1.0035,0.8282,0.74186,0.82546,0.99229,1.0006,0.82559,0.7402,0.82613,0.9924,0.99731,0.82189,0.73848,0.82524,0.99083,0.99504,0.81853,0.7374,0.82534,0.98839,0.99249,0.81574,0.73558,0.82365,0.9873,0.98842,0.81299,0.73403,0.82207,0.98607,0.98646,0.80779,0.73169,0.82114,0.98507,0.98074,0.80492,0.7307,0.81994,0.98047,0.9776,0.80141,0.72653,0.81895,0.97887,0.97151,0.79658,0.7256,0.81685,0.97631,0.96898,0.79208,0.72232,0.81674,0.97315,0.96606,0.78847,0.7195,0.81506,0.97163,0.96136,0.78529,0.71898,0.8145,0.96825,0.95779,0.78199,0.71699,0.81365,0.96728,0.95288,0.77766,0.71492,0.81304,0.96484,0.94972,0.77398,0.71303,0.81221,0.96375,0.94631,0.77081,0.71238,0.81128,0.9629,0.94128,0.76804,0.71026,0.81093,0.95888,0.93852,0.76359,0.70749,0.81009,0.95608,0.93372,0.75844,0.70584,0.80875,0.95443,0.92919,0.75423,0.70407,0.80754,0.95052,0.923,0.75006,0.70227,0.80634,0.94657,0.91912,0.74514,0.69933,0.8036,0.94305,0.91343,0.7406,0.69618,0.8017,0.94006,0.90769,0.73615,0.69451,0.80011,0.93653,0.90202,0.73094,0.69203,0.79837,0.93233,0.89618,0.72584,0.68842,0.79555,0.92847,0.89014,0.72048,0.68553,0.79352,0.92367,0.88393,0.71542,0.68266,0.7905,0.9196,0.87721,0.70987,0.6799,0.78757,0.91496,0.8719,0.70511,0.67685,0.78569,0.91089,0.86536,0.70077,0.67332,0.78362,0.90635,0.85905,0.69575,0.66977,0.7799,0.90036,0.85244,0.69026,0.66608,0.77699,0.89516,0.84717,0.68501,0.66312,0.77414,0.89023,0.84089,0.68029,0.66061,0.77148,0.88583,0.83423,0.67459,0.65772,0.76955,0.88171,0.8289,0.67056,0.65463,0.76596,0.87616,0.82269,0.66538,0.65187,0.76272,0.87191,0.81707,0.66094,0.64924,0.76067,0.86866,0.81069,0.658,0.64574,0.75795,0.86395,0.80641,0.65304,0.6429,0.75622,0.85941,0.80095,0.64815,0.64091,0.75386,0.85505,0.79655,0.64502,0.63892,0.75104,0.85194,0.79084,0.64149,0.63759,0.74899,0.84934,0.78629,0.63766,0.63532,0.74751,0.8457,0.78163,0.635,0.63313,0.74643,0.84387,0.7777,0.63246,0.63126,0.74503,0.84027,0.77448,0.62903,0.62955,0.74287,0.83738,0.76971,0.62585,0.62867,0.742,0.83376,0.76553,0.62205,0.62619,0.74084,0.83096,0.76064,0.61937,0.62521,0.7392,0.8283,0.75729,0.61647,0.62429,0.73767,0.82669,0.7545,0.61399,0.62389,0.73726,0.82498,0.75204,0.61226,0.62256,0.73591,0.82279,0.74928,0.60972,0.6219,0.73516,0.82052,0.74593,0.60729,0.62003,0.73575,0.81793,0.74426,0.60472,0.61885,0.73452,0.81507,0.74101,0.60346,0.61764,0.73439,0.81393,0.73725,0.60299,0.6181,0.73366,0.81253,0.73463,0.6002,0.61775,0.7327,0.81166,0.73219,0.59872,0.6187,0.73243,0.81004,0.73084,0.5963,0.61729,0.73331,0.80902,0.72917,0.59552,0.61679,0.73315,0.80842,0.72705,0.59539,0.61649,0.73272,0.80612,0.72463,0.5944,0.61674,0.73333,0.80563,0.72203,0.59167,0.61683,0.73314,0.80516,0.72036,0.58986,0.61661,0.73276,0.80227,0.71879,0.58843,0.61581,0.73203,0.80166,0.71633,0.58888,0.61571,0.7322,0.80034,0.71421,0.58735,0.61589,0.73141,0.79955,0.71339,0.5863,0.61532,0.73207,0.79756,0.71183,0.58453,0.61571,0.73286,0.79736,0.71039,0.58464,0.61498,0.73306:0
0.0017036,-0.0023612,0.0024412,-6.765E-4,-0.0011858,0.0019808,-0.0026109,7.7814E-4,1.5133E-4,-0.0015041,0.0023758,-0.0030763,0.0012574,-0.0016716,-8.782E-4,0.0029283,-0.0032151,0.0013885,4.8614E-4,-5.0825E-4,0.0024931,-0.0025027,0.0018621,-0.0027742,0.023441,0.26212,0.17081,0.053175,0.057465,0.051811,0.025283,0.030227,0.031266,0.035461,0.033276,0.02046,0.016916,0.023579,0.022604,0.022328,0.017989,0.01447,0.021288,0.022707,0.022059,0.01939,0.015341,0.024214,0.023783,0.022904,0.018745,0.014717,0.021678,0.024057,0.02256,0.019888,0.014665,0.023257,0.023706,0.021559,0.020596,0.013247,0.022677,0.023299,0.021659,0.019681,0.013964,0.022877,0.023185,0.021734,0.018973,0.013088,0.02477,0.021201,0.021498,0.018597,0.014125,0.023122,0.022747,0.020244,0.0194,0.013035,0.023352,0.021625,0.021212,0.018835,0.013516,0.022178,0.021322,0.021247,0.019808,0.012584,0.022955,0.021876,0.020984,0.019591,0.012448,0.02172,0.021657,0.021401,0.018048,0.013927,0.023261,0.020774,0.020571,0.019268,0.012373,0.021857,0.020258,1.8235,2.8604,2.2458,2.4871,2.9159,3.1853,2.8462,2.2786,2.4584,2.9287,3.2012,2.8268,2.3175,2.4343,2.9403,3.1959,2.8143,2.3269,2.4182,2.94,3.2015,2.8149,2.3336,2.4142,2.9365,3.2012,2.8195,2.3387,2.4166,2.9338,3.1999,2.8138,2.3358,2.4084,2.9282,3.193,2.8169,2.3356,2.4047,2.9221,3.1905,2.8167,2.3345,2.4024,2.9172,3.1886,2.814,2.3355,2.3939,2.9086,3.1872,2.8189,2.3342,2.39,2.9013,3.18,2.8115,2.3256,2.3784,2.8939,3.1688,2.8055,2.3179,2.37,2.8741,3.1581,2.8041,2.316,2.359,2.8668,3.1529,2.7973,2.3129,2.3569,2.8537,3.1466,2.7953,2.307,2.3491,2.8524,3.1355,2.7897,2.3041,2.3365,2.8396,3.1312,2.7872,2.3001,2.331,2.8314,3.1212,2.78,2.2968,2.3252,2.8191,3.1146,2.7767,2.2906,2.3182,2.813,3.1031,2.7737,2.2857,2.3113,2.8033,3.0986,2.7663,2.2776,2.3032,2.7875,3.0879,2.7629,2.2747,2.2966,2.7773,3.0763,2.7538,2.2706,2.2909,2.7752,3.0675,2.7509,2.2639,2.2805,2.7576,3.061,2.7436,2.2575,2.2693,2.7495,3.0449,2.7373,2.2527,2.2626,2.7363,3.0354,2.7291,2.2454,2.2561,2.7259,3.0312,2.7252,2.2433,2.2511,2.7174,3.0237,2.722,2.2396,2.2394,2.7086,3.0098,2.7112,2.2308,2.2276,2.6908,2.9958,2.6985,2.2251,2.2186,2.6799,2.9858,2.6894,2.2161,2.2103,2.668,2.9725,2.684,2.2088,2.2013,2.6583,2.9579,2.6744,2.2,2.1896,2.6465,2.9459,2.6671,2.192,2.1802,2.6273,2.9299,2.6527,2.1793,2.1686,2.6112,2.9179,2.6429,2.1716,2.1608,2.5996,2.9004,2.6317,2.1609,2.1439,2.5839,2.8845,2.6175,2.1543,2.1326,2.5694,2.8738,2.6102,2.1453,2.1229,2.5587,2.8615,2.6042,2.1379,2.1155,2.5455,2.8507,2.5942,2.1323,2.1078,2.5336,2.8381,2.5883,2.1234,2.0965,2.5213,2.824,2.5766,2.1156,2.0883,2.5037,2.8092,2.5671,2.1081,2.0773,2.4916,2.7953,2.556,2.1011,2.0665,2.4787,2.7844,2.5477,2.0914,2.0559,2.4642,2.7717,2.5392,2.0833,2.0456,2.4541,2.7577,2.5303,2.0756,2.0365,2.4402,2.7456,2.5207,2.0659,2.0268,2.4267,2.7324,2.511,2.0601,2.0175,2.4156,2.7208,2.503,2.0551,2.0124,2.4056,2.714,2.4987,2.0521,2.0027,2.3959,2.7047,2.4949,2.0482,1.9966,2.3866,2.6986,2.4911,2.0447,1.9902,2.3804,2.6887,2.4892,2.042,1.9837,2.3751,2.6826,2.4876,2.039,1.975,2.3673,2.6754,2.4819,2.0365,1.9703,2.3553,2.6678,2.4756,2.0349,1.9656,2.3458,2.66,2.4725,2.0311,1.9616,2.3366,2.6524,2.4711,2.026,1.9565,2.3251,2.6402,2.4603,2.0184,1.9466,2.3134,2.632,2.459,2.0145,1.9394,2.3091,2.6253,2.4588,2.0139,1.9331,2.2995,2.618,2.4556,2.0136,1.9265,2.2917,2.6151,2.4507,2.0114,1.9248,2.2816,2.6268,2.4659,2.0227,1.9346,2.2954,2.6207,2.4655,2.0199,1.9268,2.2875,2.6145,2.4643,2.0213,1.9241,2.2834,2.6117,2.463,2.022,1.9195,2.2716,2.6075,2.4586,2.0151,1.916,2.2628,2.5958,2.4589,2.0115,1.9086,2.2602,2.5902,2.4605,2.014,1.9052,2.2516,2.588,2.4527,2.0149,1.9023,2.2464,2.5845,2.4531,2.0121,1.9014,2.2399,2.5792,2.4537,2.0116,1.8986,2.2369,2.5752,2.4564,2.0166,1.8936,2.2294,2.5724:0
-1.07E-6,5.89E-6,-9.43E-6,1.0703E-5,-8.9E-7,3.38E-6,4.3E-6,-5.8367E-6,1.1107E-5,9.2E-7,1.4567E-6,1.0167E-5,-5.8033E-6,1.27E-5,-1.2367E-6,5.0867E-6,1.0907E-5,-8.01E-6,7.6567E-6,-5.06E-6,9.0667E-7,1.1207E-5,-4.8633E-6,9.6133E-6,1.8767E-6,-4.22E-6,7.23E-6,-1.206E-5,1.4623E-5,-3.3E-7,-4.8333E-7,1.242E-5,-6.67E-6,1.1847E-5,-5.5967E-6,2.2967E-6,1.1437E-5,-5.1667E-6,1.5437E-5,-2.5E-7,7.0333E-7,1.636E-5,-1.1783E-5,1.126E-5,-1.1133E-6,2.8667E-6,1.3297E-5,-5.1567E-6,1.0627E-5,-1.5867E-6,-4.5E-7,7.5833E-6,-2.47E-6,9.2867E-6,0.037671,0.23267,0.21515,0.18626,0.15421,0.19932,0.22768,0.21822,0.18138,0.15765,0.19703,0.22757,0.21925,0.17981,0.15878,0.19603,0.22733,0.21999,0.17926,0.15925,0.19574,0.22717,0.22029,0.17917,0.15951,0.19536,0.22693,0.22056,0.17899,0.15956,0.19525,0.22695,0.22045,0.17926,0.15967,0.19508,0.22697,0.22089,0.17928,0.15957,0.19481,0.22666,0.22082,0.1792,0.15968,0.19461,0.22656,0.22094,0.17929,0.15946,0.19409,0.22614,0.22093,0.17926,0.15944,0.19377,0.22622,0.22109,0.1793,0.15931,0.19366,0.22609,0.22113,0.17917,0.15925,0.19343,0.22575,0.22099,0.17917,0.15909,0.19322,0.22532,0.2211,0.17933,0.15898,0.19299,0.22531,0.22086,0.17912,0.15889,0.1928,0.22507,0.22116,0.17932,0.15885,0.1927,0.22526,0.22125,0.17927,0.15879,0.19259,0.22492,0.22113,0.17945,0.15878,0.19247,0.22487,0.2212,0.17939,0.15876,0.19218,0.22482,0.22118,0.17962,0.1587,0.19214,0.22483,0.22122,0.17949,0.15866,0.19197,0.22466,0.22132,0.17985,0.15847,0.19184,0.22447,0.22121,0.17991,0.15845,0.19182,0.22411,0.22154,0.18006,0.15837,0.19163,0.22394,0.22136,0.17986,0.1583,0.19136,0.22356,0.22143,0.17986,0.15825,0.19088,0.22332,0.22147,0.1798,0.15823,0.19075,0.22348,0.22119,0.17985,0.15811,0.19037:0
1.405E-5,-3.7567E-6,2.87E-6,1.1793E-5,-7.1133E-6,1.3777E-5,-5.8933E-6,1.7933E-6,9.0433E-6,-6.62E-6,1.54E-5,-2.4767E-6,2.5267E-6,1.4937E-5,-9.01E-6,1.0963E-5,-8.5933E-6,-1.9033E-6,1.0003E-5,-8.4133E-6,1.0273E-5,7.8E-7,3.0233E-6,1.0387E-5,-7.2967E-6,9.4067E-6,-7.16E-6,3.53E-6,1.018E-5,-1.1773E-5,1.369E-5,4.0667E-7,-5.3333E-8,1.0203E-5,-6.9133E-6,8.5733E-6,-2.0567E-6,7.0E-8,1.0553E-5,-9.7333E-6,1.3947E-5,1.48E-6,6.3667E-7,1.045E-5,-8.8467E-6,7.3233E-6,-4.5633E-6,2.4867E-6,1.2643E-5,-8.1067E-6,1.3137E-5,-2.0E-6,1.1E-6,7.3867E-6,-9.77E-6,1.3593E-5,-2.3467E-6,3.4667E-7,7.79E-6,-9.66E-6,1.5377E-5,-3.01E-6,2.97E-6,9.3933E-6,-8.41E-6,1.392E-5,2.38E-6,-4.6533E-6,1.3797E-5,-1.7367E-6,1.3977E-5,-8.31E-6,2.0333E-7,8.5333E-6,-8.0267E-6,1.158E-5,2.5033E-6,1.83E-6,1.0737E-5,-1.0377E-5,1.448E-5,-2.65E-6,2.4667E-6,8.9533E-6,-6.25E-6,1.074E-5,-3.4133E-6,-5.3E-7,9.1167E-6,-7.79E-6,8.7033E-6,-4.8833E-6,4.47E-6,0.001932,0.17149,0.17181,0.19579,0.23077,0.2238,0.17466,0.16564,0.1979,0.23046,0.222,0.17723,0.16368,0.19868,0.23047,0.22143,0.17806,0.16271,0.19856,0.2304,0.22105,0.17852,0.16253,0.19868,0.23031,0.2211,0.17882,0.1622,0.19875,0.22999,0.22094,0.17886,0.16186,0.19841,0.22964,0.22132,0.17912,0.16166,0.19819,0.22938,0.22123,0.17883,0.16101,0.19663,0.22635,0.2185,0.17662,0.15926,0.19231,0.22039,0.21304,0.17184,0.14878,0.1745,0.19378,0.15614,0.094241,0.056499,0.051437,0.062723,0.068488,0.053971,0.040248,0.047647,0.059702,0.062436,0.049679,0.040831,0.050382,0.058536,0.05911,0.047027,0.040313,0.050986,0.057735,0.058725,0.04695,0.041181,0.051873,0.058482,0.060342,0.047585,0.042496,0.052601,0.058281,0.060618,0.047709,0.0434,0.052431,0.058068,0.061196,0.047861,0.044377,0.052725,0.058858,0.061535,0.047882,0.04505,0.053173,0.060119,0.062168,0.048405,0.045996,0.053883,0.061961,0.063013,0.049111,0.046773,0.054079,0.062926,0.062141,0.0496,0.046717,0.053633,0.063365,0.061092,0.049917,0.046221,0.053882,0.064241,0.060965,0.050875,0.046095,0.055086,0.065018,0.060863,0.051339,0.045632,0.055787,0.065009,0.061054,0.0521,0.04554,0.057232,0.065031,0.062288,0.053102,0.045991,0.058249,0.06465,0.063984,0.053715,0.046455,0.059364,0.063707,0.065548,0.053766,0.047211,0.058145,0.061231,0.064495,0.051381,0.046975,0.056803,0.060786,0.064976,0.050254,0.047634,0.056626,0.062544,0.066465,0.051311,0.048865,0.055402,0.063763,0.066163,0.051186,0.048756,0.055062,0.065768,0.065167,0.051371,0.048699,0.055033,0.066681,0.063934,0.052639,0.048206,0.055323,0.067905,0.063642,0.054163,0.047708,0.057191,0.068165,0.063721,0.05478,0.046928,0.058596,0.067029,0.063821,0.054916,0.046894,0.060195,0.065717,0.065525,0.055247,0.047609,0.061125,0.065189,0.067827,0.055039,0.048493,0.059838,0.063475,0.067911,0.053467,0.049368,0.058408,0.063595,0.06901,0.053196,0.050289,0.057949,0.065678,0.069157,0.053751,0.051939,0.058069,0.068677,0.06918,0.055096,0.052046,0.058072,0.071227,0.068186,0.056593,0.051588,0.059713,0.072259,0.067136,0.057606,0.050425,0.06068,0.071788,0.067125,0.058306,0.049468,0.062338,0.070013,0.067808,0.05851,0.049631,0.063515,0.068177,0.069606,0.058373,0.05094,0.063868,0.067581,0.072302,0.057644,0.052075,0.062488,0.067769,0.07338,0.056736,0.053456,0.06209,0.069566,0.073495,0.056527,0.054081,0.060644,0.071134,0.072604,0.057515,0.054182,0.059854,0.073246,0.070619,0.058492,0.052803,0.059746,0.073315,0.06922,0.059697,0.051656,0.061624,0.073722,0.069599,0.060671,0.051011,0.063662,0.072305,0.070584,0.061036,0.051067,0.06485,0.070036,0.072151,0.060218,0.051567,0.06459,0.069024,0.074242,0.059085,0.052949,0.064031,0.069875,0.075888,0.057993,0.053836,0.062293,0.070796,0.075007,0.057504,0.054757,0.061412,0.072453,0.072704,0.057749,0.054639,0.060897,0.074276,0.071145,0.059869,0.053844,0.061429,0.07461,0.069609,0.060312,0.051765,0.062349,0.073339,0.069486,0.061195,0.051255,0.063355,0.07096,0.0706,0.061049,0.05064,0.064072,0.068856,0.071779,0.05942,0.051125,0.064096,0.068266,0.073914,0.05886,0.053218,0.063562,0.069601,0.076347,0.058945,0.055141,0.062551,0.07192,0.075811,0.058395,0.055036,0.061071,0.073775,0.074147,0.059394,0.05478,0.061039,0.076207,0.072386,0.061037,0.053074,0.060944,0.074959,0.070858,0.062055,0.05226,0.063273,0.074167,0.071644,0.063074,0.051661,0.064204,0.071164,0.071583,0.061426,0.051497,0.065473,0.069569,0.073684,0.060723,0.053198,0.064627,0.068461,0.075103,0.058982,0.053561,0.062354,0.069158,0.07624,0.058676,0.0548,0.061342,0.071228,0.07483,0.058514,0.054674,0.059711,0.073089,0.072738,0.058927,0.053283,0.059627,0.074946,0.071122,0.060534,0.052286,0.060719,0.074115,0.070331,0.062161,0.051698,0.062911,0.073035,0.070791,0.062688,0.051388,0.064353,0.070646,0.072013,0.06201,0.051719,0.064509,0.068218,0.073868,0.060635,0.05254,0.063126,0.067928,0.075731,0.059466,0.05381,0.062189,0.069303,0.076465,0.059055,0.054913,0.060473,0.070876,0.074798,0.058795,0.054597,0.059475,0.073379,0.072854,0.059634,0.054129,0.060418,0.074877,0.071284,0.061744,0.052913,0.061126,0.074237,0.070538,0.062624,0.051589,0.062728,0.072671,0.070997,0.062676,0.050978,0.063898,0.0699,0.072262,0.06202,0.051148,0.063806,0.06822,0.074352,0.060782,0.052502,0.063224,0.068279,0.076451,0.059698,0.053776,0.061672,0.069347,0.07631,0.058621,0.054046,0.059878,0.070987,0.07478,0.058651,0.054042,0.058978,0.073182,0.072772,0.059829,0.05351,0.059397,0.074391,0.071577,0.061743,0.052368,0.061038,0.0745,0.070569,0.062155,0.051058,0.06254,0.072226,0.070613,0.062615,0.050697,0.063403,0.069657,0.071906,0.061574,0.050596,0.063075,0.067159,0.073053,0.059939,0.051553,0.061661,0.066043,0.074083,0.058499,0.052498,0.059982,0.067083,0.074609,0.05759,0.052883,0.058344,0.068117,0.072694,0.05712,0.052634,0.056907,0.070143,0.071133,0.058026,0.052118,0.057358,0.071952,0.06934,0.059165,0.050689,0.057758,0.070875,0.067626,0.059783,0.048847,0.05787,0.068862,0.067555,0.060338,0.048275,0.059538,0.067747,0.069265,0.060802,0.048946,0.061185,0.066563,0.028542:0
2.354E-5,1.8707E-5,1.7957E-5,1.5657E-5,2.218E-5,2.357E-5,1.8903E-5,1.7977E-5,1.5533E-5,2.1483E-5,2.293E-5,1.8567E-5,1.734E-5,1.4863E-5,2.1047E-5,2.378E-5,1.9803E-5,1.824E-5,1.627E-5,2.2213E-5,2.375E-5,1.914E-5,1.778E-5,1.5423E-5,2.1843E-5,2.4053E-5,1.847E-5,1.779E-5,1.523E-5,2.2667E-5,2.3427E-5,1.94E-5,1.8143E-5,1.604E-5,2.138E-5,2.4097E-5,1.908E-5,1.8273E-5,1.5393E-5,2.1507E-5,2.373E-5,1.99E-5,1.725E-5,1.6603E-5,2.135E-5,2.3343E-5,1.938E-5,1.8027E-5,1.651E-5,2.1207E-5,2.2307E-5,1.935E-5,1.7333E-5,1.5673E-5,2.183E-5,2.4237E-5,2.1057E-5,1.9163E-5,1.6003E-5,2.3597E-5,2.6453E-5,2.266E-5,1.9007E-5,1.8407E-5,2.36E-5,2.728E-5,2.287E-5,1.9057E-5,1.8093E-5,2.405E-5,2.6927E-5,2.2687E-5,1.9653E-5,1.7367E-5,2.4287E-5,2.6337E-5,2.18E-5,1.9587E-5,1.702E-5,2.3397E-5,2.7557E-5,2.2177E-5,1.9187E-5,1.6693E-5,2.3887E-5,2.623E-5,2.4023E-5,1.9553E-5,1.862E-5,2.4397E-5,2.644E-5,2.2883E-5,1.886E-5,1.6917E-5,2.358E-5,2.5393E-5,2.3507E-5,1.8847E-5,1.8657E-5,2.407E-5,2.7177E-5,2.2883E-5,1.855E-5,1.8703E-5,0.0013766,0.001675,0.0017349,0.00134,0.0012979,0.0012581,0.0016427,0.0017056,0.0013736,0.0012699,0.0012821,0.0016416,0.0017035,0.0013935,0.0012576,0.0012852,0.0016331,0.0017042,0.0013922,0.0012606,0.0012839,0.0016361,0.0017059,0.0013956,0.001259,0.0012865,0.0016355,0.0017026,0.0014029,0.0012564,0.0012851,0.0016411,0.0016995,0.001397,0.0012591,0.0012861,0.0016256,0.0017093,0.0013997,0.001257,0.0012781,0.0016325,0.001707,0.0014047,0.0012555,0.0012757,0.0016281,0.0017035,0.0014078,0.0012642,0.0012816,0.00163,0.0016923,0.0014083,0.0012541,0.0012755,0.001628,0.0016992,0.0014095,0.0012615,0.0012693,0.0016297,0.0016986,0.0014077,0.0012541,0.0012714,0.0016257,0.0016973,0.0014091,0.0012612,0.0012614,0.0016185,0.0016965,0.001407,0.0012491,0.0012666,0.0016174,0.0016969,0.0014093,0.0012558,0.0012636,0.0016143,0.0016921,0.0014102,0.0012547,0.0012631,0.0016146,0.0016919,0.0014116,0.0012557,0.001258,0.0016101,0.0016925,0.0014099,0.0012529,0.0012585,0.0016111,0.0016836,0.0014087,0.0012521,0.0012594,0.001607,0.0016923,0.0014135,0.0012545,0.0012482,0.0016053,0.0016875,0.0014133,0.0012493,0.0012536,0.0015999,0.0016902,0.0014111,0.0012471,0.0012514,0.001599,0.0016875,0.0014121,0.0012478,0.001247,0.0015995,0.0016825,0.0014165,0.0012521,0.0012456,0.0015894,0.0016748,0.0014157,0.0012481,0.0012416,0.0015908,0.0016808,0.0014065,0.0012463,0.0012392,0.001589,0.0016799,0.0014158,0.0012481,0.0012319,0.001581,0.0016685,0.0014099,0.0012407,0.0012345,0.0015873,0.0016754,0.0014113,0.0012425,0.0012314,0.0015812,0.0016718,0.0014111,0.0012446,0.0012389,0.0015789,0.0016718,0.0014033,0.0012364,0.0012262,0.0015757,0.0016665,0.0014037,0.0012374,0.0012251,0.001571,0.0016617,0.0014012,0.0012378,0.0012225,0.0015707,0.0016602,0.0013993,0.0012348,0.0012242,0.0015706,0.0016571,0.0013988,0.0012338,0.0012125,0.0015603,0.0016567,0.0013997,0.0012299,0.00122,0.0015632,0.0016505,0.0013958,0.0012305,0.0012194,0.0015583,0.0016485,0.0014001,0.0012229,0.0012091,0.0015485,0.0016473,0.0013965,0.0012268,0.0012106,0.0015462,0.001641,0.0013886,0.0012217,0.0012095,0.0015454,0.0016327,0.0013849,0.0012213,0.0012047,0.0015379,0.0016346,0.0013836,0.0012194,0.0011979,0.001538,0.0016287,0.0013831,0.0012203,0.0012007,0.0015334,0.0016276,0.001377,0.0012149,0.0011975,0.0015345,0.0016254,0.0013775,0.0012128,0.0011942,0.0015232,0.0016138,0.0013744,0.001209,0.0011897,0.0015217,0.0016153,0.0013709,0.0012017,0.0011896,0.0015144,0.0016047,0.0013692,0.0012016,0.0011818,0.0015112,0.0016034,0.00136,0.0011972,0.0011817,0.001507,0.0015961,0.0013617,0.0011894,0.001177,0.001498,0.0015873,0.001354,0.0011878,0.00117,0.0014916,0.0015848,0.0013505,0.0011873,0.0011688,0.0014909,0.0015769,0.0013447,0.0011816,0.0011628,0.0014755,0.0015727,0.0013398,0.0011747,0.0011585,0.0014723,0.0015606,0.0013302,0.0011704,0.0011492,0.0014666,0.0015589,0.0013259,0.0011634,0.0011458,0.0014534,0.0015526,0.0013269,0.0011642,0.0011408,0.0014524,0.0015425,0.001315,0.0011568,0.0011339,0.0014443,0.0015317,0.0013075,0.0011457,0.001129,0.0014343,0.001527,0.0013049,0.0011433,0.0011262,0.0014288,0.0015169,0.0012932,0.0011374,0.0011183,0.0014178,0.0015091,0.0012878,0.0011289,0.0011146,0.0014062,0.0015021,0.0012827,0.0011256,0.0011072,0.0014035,0.0014902,0.0012775,0.0011179,0.0011019,0.0013968,0.0014846,0.001269,0.0011105,0.0010954,0.0013897,0.0014774,0.001263,0.0011089,0.0010843,0.0013834,0.0014615,0.0012593,0.0010992,0.0010806,0.0013766,0.0014573,0.0012493,0.0010951,0.0010738,0.0013636,0.001456,0.0012436,0.0010913,0.0010655,0.001352,0.0014382,0.0012352,0.0010801,0.0010617,0.001346,0.0014301,0.0012279,0.0010705,0.0010575,0.0013431,0.0014276,0.0012157,0.0010718,0.0010475,0.0013292,0.0014156,0.0012094,0.0010643,0.001047,0.0013284,0.0014081,0.0012053,0.0010629,0.001038,0.0013175,0.001395,0.0012028,0.0010508,0.0010306,0.0013095,0.0013893,0.0012022,0.001049,0.0010253,0.0013018,0.0013824,0.0011854,0.0010426,0.0010206,0.0012923,0.0013697,0.0011824,0.0010378,0.0010076,0.001289,0.0013685,0.0011792,0.0010288,0.0010083,0.0012837,0.0013614,0.0011745,0.0010269,0.001002,0.0012718,0.0013573,0.0011683,0.0010229,0.0010004,0.0012683,0.0013478,0.00116,0.0010182,9.9444E-4,0.001258,0.0013407,0.0011568,0.0010167,9.8936E-4,0.0012553,0.0013372,0.0011518,0.0010087,9.8641E-4,0.0012482,0.00133,0.0011485,0.0010055,9.8208E-4,0.0012452,0.0013297,0.0011483,0.0010036,9.7753E-4,0.0012386,0.0013242,0.0011407,9.9333E-4,9.7728E-4,0.0012371,0.0013188,0.001138,9.9139E-4,9.7361E-4,0.0012286,0.0013131,0.0011367,9.9372E-4,9.653E-4,0.0012265,0.0013091,0.0011359,9.8467E-4,9.6638E-4,0.0012225,0.0013044,0.0011308,9.8453E-4,9.6252E-4,0.0012173,0.001303,0.0011265,9.8553E-4,9.609E-4,0.0012127,0.0012987,0.0011294,9.8196E-4,9.5689E-4,0.0012086,0.0012918,0.0011227,9.7701E-4,9.5249E-4,0.0012082,0.0012876,0.0011242,9.7571E-4,9.5238E-4,0.0012031,0.0012872,0.0011174,9.7285E-4,9.4996E-4,0.0011983,0.0012858,0.0011169,9.7903E-4,9.4753E-4,0.0011977,0.0012824,0.00112,9.6924E-4,9.4388E-4,0.0011984,0.0012858,0.0011172,9.6817E-4,9.4349E-4,0.0011963,6.4235E-4:0
1.9953E-5,2.564E-5,2.798E-5,1.9157E-5,2.064E-5,2.164E-5,2.5883E-5,2.9547E-5,1.984E-5,2.045E-5,2.0807E-5,2.577E-5,2.7867E-5,1.95E-5,2.109E-5,2.2247E-5,2.524E-5,2.9797E-5,1.939E-5,2.058E-5,2.0197E-5,2.617E-5,2.7887E-5,1.873E-5,1.947E-5,2.026E-5,2.5337E-5,2.9747E-5,1.822E-5,2.0603E-5,2.0643E-5,2.5883E-5,2.8807E-5,1.9613E-5,2.1453E-5,2.174E-5,2.708E-5,3.3317E-5,2.111E-5,2.205E-5,2.215E-5,2.8497E-5,3.4237E-5,2.0177E-5,2.1783E-5,2.3037E-5,2.7593E-5,3.3567E-5,1.991E-5,2.267E-5,2.3247E-5,2.6673E-5,3.307E-5,2.1633E-5,2.2723E-5,2.2743E-5,2.8183E-5,3.2443E-5,2.0813E-5,2.2333E-5,2.2997E-5,2.9203E-5,3.3307E-5,2.1083E-5,2.2123E-5,2.399E-5,2.7883E-5,3.423E-5,1.9877E-5,2.287E-5,2.2857E-5,2.779E-5,3.2993E-5,2.1193E-5,2.3037E-5,2.2567E-5,2.7623E-5,3.348E-5,2.094E-5,2.2277E-5,2.247E-5,0.0011195,0.0017177,0.0015878,0.0012016,0.00128,0.0014442,0.0016872,0.0015744,0.0012233,0.0012717,0.001451,0.0016911,0.0015777,0.0012208,0.0012707,0.0014478,0.0016899,0.0015674,0.0012116,0.001268,0.0014461,0.0016842,0.0015633,0.0012126,0.0012675,0.0014475,0.0016809,0.0015761,0.0012113,0.0012648,0.0014445,0.0016835,0.0015753,0.0012139,0.0012696,0.0014456,0.0016855,0.0015683,0.0012116,0.0012628,0.0014364,0.0016784,0.001567,0.0012087,0.0012601,0.001442,0.001671,0.0015678,0.0012132,0.0012643,0.0014348,0.0016807,0.0015621,0.0012062,0.0012589,0.0014351,0.0016739,0.00156,0.0012065,0.0012536,0.0014249,0.0016693,0.0015576,0.0012113,0.0012514,0.0014258,0.0016674,0.0015594,0.0012036,0.0012552,0.0014283,0.0016635,0.0015577,0.0012012,0.0012506,0.0014245,0.0016645,0.0015543,0.0012056,0.0012551,0.0014262,0.0016623,0.0015557,0.0011968,0.0012485,0.0014183,0.0016577,0.0015478,0.0011999,0.0012483,0.0014198,0.0016548,0.0015484,0.0012034,0.0012455,0.0014182,0.0016516,0.0015458,0.0011905,0.0012436,0.0014156,0.001648,0.0015366,0.0011909,0.0012405,0.0014131,0.0016417,0.00154,0.0011956,0.0012414,0.0014111,0.0016381,0.0015326,0.0011838,0.0012402,0.0014073,0.0016396,0.0015283,0.0011803,0.001239,0.0014064,0.001633,0.0015289,0.0011832,0.0012297,0.0013998,0.0016317,0.0015256,0.0011746,0.0012332,0.0014051,0.0016255,0.0015214,0.0011791,0.0012314,0.0014004,0.0016243,0.001512,0.0011759,0.0012295,0.0013988,0.0016216,0.001511,0.0011687,0.0012227,0.001394,0.0016155,0.0015065,0.0011656,0.001219,0.0013872,0.0016072,0.0015011,0.0011637,0.0012185,0.0013862,0.0015999,0.0014978,0.0011574,0.0012134,0.001384,0.0015992,0.0014882,0.001156,0.0012075,0.0013744,0.00159,0.0014836,0.0011501,0.0012029,0.0013631,0.0015798,0.0014773,0.0011448,0.0011962,0.0013633,0.001577,0.0014715,0.0011427,0.001197,0.0013584,0.0015715,0.0014602,0.0011402,0.0011943,0.0013567,0.0015624,0.0014623,0.0011321,0.0011867,0.0013491,0.0015613,0.0014601,0.0011275,0.0011828,0.001346,0.0015493,0.0014431,0.0011209,0.0011809,0.0013371,0.0015461,0.0014429,0.0011179,0.0011677,0.0013283,0.0015341,0.0014319,0.0011148,0.0011648,0.0013317,0.0015303,0.0014288,0.0011017,0.0011618,0.0013231,0.0015242,0.0014213,0.0010968,0.0011578,0.0013127,0.0015166,0.0014106,0.0010952,0.0011527,0.0013155,0.0015073,0.0013997,0.0010865,0.001144,0.0013017,0.0014979,0.0013911,0.0010796,0.001137,0.0012972,0.0014876,0.0013859,0.0010755,0.001135,0.0012899,0.0014768,0.0013769,0.0010655,0.0011252,0.0012866,0.0014703,0.0013721,0.0010612,0.0011192,0.0012735,0.0014558,0.0013605,0.0010576,0.001115,0.0012702,0.0014524,0.001353,0.0010515,0.0011111,0.0012599,0.001445,0.0013448,0.001042,0.001104,0.0012554,0.0014332,0.00134,0.0010346,0.0010942,0.0012484,0.0014243,0.0013287,0.0010311,0.0010894,0.0012408,0.0014237,0.001319,0.0010218,0.0010854,0.0012322,0.0014155,0.0013172,0.0010146,0.0010783,0.0012309,0.0014037,0.0013065,0.0010167,0.0010737,0.0012226,0.0013939,0.0013014,0.0010033,0.0010656,0.001222,0.00139,0.0012916,0.0010064,0.0010618,0.001205,0.0013848,0.0012844,9.956E-4,0.0010526,0.0012001,0.0013698,0.0012729,9.9229E-4,0.0010473,0.0011979,0.0013627,0.0012711,9.8296E-4,0.001042,0.0011907,0.0013579,0.0012654,9.8255E-4,0.0010396,0.0011818,0.0013551,0.0012599,9.7463E-4,0.0010341,0.0011814,0.0013465,0.0012551,9.7597E-4,0.0010311,0.0011727,0.0013374,0.0012513,9.7314E-4,0.0010256,0.00117,0.0013346,0.0012426,9.6701E-4,0.0010179,0.0011656,0.0013275,0.0012345,9.637E-4,0.0010192,0.0011618,0.001326,0.0012359,9.5894E-4,0.0010144,0.0011568,0.0013174,0.001237,9.5323E-4,0.0010097,0.0011593,0.0013208,0.0012272,9.5466E-4,0.0010102,0.00115,0.0013085,0.0012233,9.5219E-4,0.0010042,0.0011437,0.001305,0.0012171,9.4474E-4,9.9843E-4,0.0011409,0.0013016,0.001214,9.4136E-4,9.9971E-4,0.0011422,0.0013003,0.0012056,9.4132E-4,9.968E-4,0.001133,0.0012991,0.0012105,9.3939E-4,9.8971E-4,0.0011296,0.0012947,0.0012072,9.3711E-4,9.9128E-4,0.0011275,0.0012923,0.0012016,9.4065E-4,9.8763E-4,0.0011305,0.0012847,0.0012014,9.3568E-4,9.8925E-4,0.0011222,0.0012821,0.0012027,9.3574E-4,9.8378E-4,0.0011198,0.0012787,0.0011996,9.3123E-4,9.8288E-4,0.0011175,0.0012795,0.0012002,9.2518E-4,9.7943E-4,0.0011169,0.0012779,0.0011952,9.2507E-4,9.7843E-4,0.0011148,0.0012742,0.0011897,9.2712E-4,9.812E-4,0.0011157,0.0012746,0.0011958,9.2967E-4,9.768E-4,0.0011131,0.001276,0.0011929,9.244E-4,9.762E-4,0.001108,0.0012749,0.001196,9.2526E-4,9.704E-4,0.0011093,0.0012702,0.0011912,9.2306E-4,9.7684E-4,0.0011078,0.001267,0.0011906,9.2503E-4,9.756E-4,0.0011063,0.0012723,0.0011862,9.2715E-4,9.6874E-4,0.0011043,0.0012676,0.0011921,9.301E-4,9.7205E-4,0.0011041,0.0012656,0.0011924,9.2151E-4,9.6834E-4,0.0011071,0.0012675,0.0011884,9.247E-4,9.7127E-4,0.0011021,0.001262,0.0011865,9.2369E-4,9.7171E-4,0.0011037,0.0012669,0.0011881,9.2252E-4,9.6703E-4,0.0011007,0.0012627,0.0011908,9.1782E-4,9.6653E-4,0.0010975,0.0012686,0.0011921,9.2188E-4,9.6762E-4,0.0011015,0.0012674,0.0011871,9.2075E-4,9.6872E-4,0.001101,0.0012632,0.0011865,9.2304E-4,9.6718E-4,0.0010965,0.0012587,0.0011878,9.1959E-4,9.7303E-4,0.0011004,0.0012602,0.0011851,9.2627E-4,9.6891E-4,0.0010968,0.0012583,0.001195,9.2508E-4,9.6173E-4,0.0010933,0.0012615,0.0011919,9.2136E-4,9.6571E-4,0.0010929,0.0012613,0.0011894,9.1821E-4,9.6729E-4,0.0010921,0.0012629,0.0011908,9.2204E-4,9.6752E-4,0.0010923,0.0012577,0.0011873,9.2198E-4,9.6524E-4,0.0010902,0.0012598,0.001191,9.2526E-4,9.6658E-4,0.0010922,0.0012576,0.0011934,9.2416E-4,9.606E-4,8.4357E-4:0
2.072E-5,2.1267E-5,1.9437E-5,2.492E-5,2.8603E-5,1.983E-5,1.9743E-5,2.0297E-5,2.5147E-5,2.9E-5,1.8797E-5,2.0583E-5,2.033E-5,2.4853E-5,2.9873E-5,2.0083E-5,1.9873E-5,1.9553E-5,2.5643E-5,2.913E-5,2.0037E-5,2.062E-5,2.0547E-5,2.4883E-5,2.9003E-5,2.057E-5,2.0513E-5,2.0203E-5,2.5457E-5,2.843E-5,2.0523E-5,2.0893E-5,1.9087E-5,2.5083E-5,2.8743E-5,1.999E-5,2.039E-5,1.9663E-5,2.5503E-5,2.848E-5,1.9477E-5,2.0197E-5,2.0173E-5,2.482E-5,2.9273E-5,1.9283E-5,2.0823E-5,2.0463E-5,2.467E-5,2.8603E-5,1.9987E-5,2.11E-5,1.9397E-5,2.493E-5,2.998E-5,2.142E-5,2.2283E-5,2.2327E-5,2.724E-5,3.2067E-5,2.343E-5,2.1983E-5,2.205E-5,2.7737E-5,3.3887E-5,2.28E-5,2.295E-5,2.2133E-5,2.6733E-5,3.276E-5,2.2393E-5,2.297E-5,2.2057E-5,2.746E-5,3.414E-5,2.2517E-5,2.2693E-5,2.1853E-5,2.6727E-5,3.269E-5,2.2497E-5,2.2387E-5,2.075E-5,2.6593E-5,3.2933E-5,2.3563E-5,2.2127E-5,2.21E-5,2.7777E-5,3.2113E-5,2.3033E-5,2.2877E-5,2.15E-5,2.773E-5,3.338E-5,2.2953E-5,2.3003E-5,2.1107E-5,2.716E-5,3.2097E-5,2.32E-5,2.2193E-5,0.0014733,0.0014278,0.0016819,0.0015662,0.0013337,0.0011673,0.0014135,0.001658,0.0016119,0.0012743,0.0012319,0.0013766,0.0016654,0.001618,0.0012627,0.0012441,0.0013725,0.0016673,0.0016282,0.0012715,0.0012429,0.0013731,0.0016659,0.001625,0.001266,0.0012397,0.0013699,0.0016627,0.0016227,0.0012679,0.0012377,0.0013631,0.0016595,0.0016206,0.0012708,0.0012373,0.0013556,0.0016518,0.0016266,0.0012681,0.0012338,0.0013551,0.0016515,0.0016269,0.0012652,0.0012368,0.0013564,0.0016526,0.0016218,0.0012684,0.0012308,0.0013505,0.0016446,0.0016231,0.001266,0.0012361,0.0013495,0.0016439,0.0016133,0.0012668,0.0012282,0.0013409,0.0016453,0.0016152,0.0012708,0.0012316,0.0013359,0.0016383,0.0016194,0.0012684,0.0012236,0.0013333,0.0016315,0.0016158,0.0012714,0.0012279,0.0013325,0.0016344,0.0016166,0.0012658,0.0012251,0.0013321,0.0016266,0.0016095,0.001269,0.0012213,0.0013254,0.001626,0.0016138,0.0012669,0.0012187,0.0013195,0.0016258,0.0016103,0.0012703,0.0012179,0.0013184,0.0016231,0.0016113,0.0012654,0.0012139,0.0013147,0.0016186,0.0016118,0.0012657,0.0012173,0.0013137,0.0016111,0.0016082,0.0012681,0.0012114,0.0013074,0.0016112,0.0015997,0.001265,0.0012092,0.0013084,0.0016079,0.0016023,0.0012676,0.0012068,0.0012981,0.0015968,0.0015894,0.0012618,0.0012083,0.0012952,0.0015965,0.0015969,0.0012607,0.0011985,0.0012945,0.0015931,0.0016006,0.0012566,0.0011987,0.0012904,0.0015939,0.0015877,0.0012562,0.0011983,0.0012875,0.0015832,0.0015816,0.0012522,0.0011864,0.0012853,0.0015762,0.0015817,0.0012477,0.0011885,0.0012762,0.0015732,0.0015778,0.0012505,0.0011857,0.001271,0.0015738,0.0015731,0.0012481,0.0011837,0.0012632,0.001561,0.0015628,0.0012428,0.0011762,0.001262,0.0015592,0.0015647,0.0012395,0.0011735,0.001261,0.0015517,0.0015582,0.00124,0.0011705,0.0012574,0.0015433,0.0015501,0.0012316,0.0011696,0.0012434,0.0015369,0.0015451,0.0012249,0.0011585,0.0012367,0.0015269,0.0015334,0.0012236,0.0011591,0.0012375,0.0015192,0.0015349,0.001217,0.001156,0.0012261,0.0015171,0.0015247,0.0012145,0.0011456,0.001222,0.0015063,0.0015189,0.0012102,0.0011484,0.0012124,0.0014954,0.0015163,0.001206,0.0011351,0.0012082,0.0014881,0.0015031,0.0012028,0.0011274,0.0012049,0.0014838,0.0014952,0.0011945,0.0011255,0.0011983,0.0014723,0.0014913,0.0011961,0.0011197,0.0011881,0.00147,0.0014815,0.0011838,0.0011149,0.0011813,0.0014612,0.0014709,0.0011758,0.0011122,0.0011744,0.0014552,0.001466,0.0011748,0.0010995,0.0011698,0.0014454,0.0014543,0.0011657,0.0010953,0.0011665,0.0014319,0.0014557,0.0011589,0.0010905,0.0011558,0.0014227,0.0014448,0.0011599,0.0010818,0.0011442,0.0014146,0.0014322,0.0011519,0.0010791,0.0011357,0.0014094,0.0014267,0.0011428,0.0010759,0.0011305,0.0013974,0.0014206,0.0011385,0.0010659,0.001123,0.0013898,0.0014066,0.0011348,0.0010574,0.0011136,0.001379,0.0014019,0.0011273,0.0010575,0.0011119,0.0013696,0.0013956,0.0011218,0.0010454,0.001102,0.0013667,0.0013849,0.0011167,0.0010462,0.0010969,0.0013524,0.0013781,0.0011133,0.0010369,0.0010885,0.0013491,0.00137,0.00111,0.0010329,0.0010812,0.0013396,0.0013643,0.0011024,0.0010273,0.0010789,0.0013353,0.0013635,0.0011021,0.0010198,0.0010646,0.0013233,0.0013504,0.0010941,0.001016,0.0010627,0.0013151,0.0013479,0.0010918,0.0010144,0.0010547,0.0013089,0.0013405,0.0010859,0.0010048,0.0010541,0.0013081,0.0013331,0.0010822,0.0010015,0.0010477,0.0012976,0.0013277,0.0010798,9.993E-4,0.0010385,0.0012924,0.0013269,0.0010731,9.9223E-4,0.0010384,0.0012838,0.001318,0.001073,9.9225E-4,0.0010271,0.0012833,0.0013164,0.001071,9.8343E-4,0.0010271,0.0012765,0.0013104,0.001066,9.8389E-4,0.0010223,0.0012746,0.0013075,0.0010675,9.8071E-4,0.0010162,0.0012636,0.0013021,0.0010645,9.772E-4,0.0010156,0.0012623,0.0013005,0.0010598,9.7264E-4,0.0010106,0.0012572,0.0012888,0.0010591,9.7136E-4,0.0010058,0.0012522,0.001294,0.0010598,9.6726E-4,9.9888E-4,0.0012515,0.0012888,0.0010618,9.6311E-4,9.9601E-4,0.0012451,0.0012868,0.0010536,9.6167E-4,9.9286E-4,0.0012439,0.0012807,0.0010551,9.591E-4,9.9064E-4,0.0012376,0.0012845,0.0010572,9.6013E-4,9.8676E-4,0.0012367,0.0012786,0.0010549,9.6233E-4,9.8242E-4,0.0012322,0.0012782,0.0010524,9.6033E-4,9.8369E-4,0.0012322,0.0012663,0.0010519,9.5509E-4,9.7905E-4,0.0012238,0.0012719,0.0010522,9.5903E-4,9.7533E-4,0.0012232,0.0012745,0.0010535,9.5097E-4,9.723E-4,0.0012213,0.0012722,0.0010527,9.522E-4,9.708E-4,0.0012229,0.0012736,0.001054,9.5184E-4,9.7048E-4,0.0012198,0.0012693,0.0010522,9.5262E-4,9.7571E-4,0.0012156,0.0012637,0.0010586,9.4838E-4,9.6408E-4,0.0012154,0.0012694,0.0010592,9.5225E-4,9.6289E-4,0.0012126,0.0012704,0.001055,9.4801E-4,9.6132E-4,0.0012167,0.0012681,0.0010557,9.5111E-4,9.6248E-4,0.0012103,0.0012669,0.0010611,9.4891E-4,9.63E-4,0.0012099,0.0012646,0.0010637,9.5313E-4,9.6115E-4,0.001208,0.0012666,0.0010609,9.4794E-4,9.5632E-4,0.001203,0.001269,0.001063,9.4814E-4,9.5201E-4,0.0012028,0.0012635,0.001062,9.47E-4,9.5664E-4,0.0012036:0
-2.57E-6,7.6067E-6,4.7067E-6,-1.34E-6,1.1537E-5,-3.67E-6,8.52E-6,7.85E-6,-4.4333E-7,8.2133E-6,-1.2333E-6,1.15E-5,3.52E-6,-3.76E-6,1.3217E-5,-6.3433E-6,7.31E-6,7.0067E-6,-7.6633E-6,1.5033E-5,-5.35E-6,1.1097E-5,9.9433E-6,-3.5867E-6,1.4403E-5,-3.7733E-6,4.0633E-6,3.3133E-6,-5.39E-6,1.119E-5,-5.3133E-6,1.3047E-5,7.09E-6,-4.0167E-6,7.2267E-6,-3.7233E-6,0.0019284,0.11889,0.22941,0.17127,0.17162,0.19495,0.23557,0.22681,0.17495,0.17091,0.19569,0.23728,0.22674,0.17698,0.17043,0.19653,0.23777,0.22656,0.17772,0.16995,0.19628,0.23784,0.2264,0.17804,0.16947,0.19606,0.2377,0.22634,0.17858,0.16949,0.19619,0.23781,0.22636,0.17862,0.16919,0.1961,0.23763,0.22661,0.17883,0.16912,0.19597,0.23744,0.22655,0.17896,0.16888,0.19552,0.23729,0.22682,0.17921,0.16891,0.19548,0.23718,0.2271,0.17924,0.16898,0.19536,0.23722,0.22742,0.17929,0.16888,0.19494,0.237,0.22719,0.17938,0.1684,0.19416,0.23616,0.22625,0.17911,0.1679,0.1938,0.23555,0.22615,0.17927,0.16773,0.19361,0.23528,0.22628,0.17909,0.16773,0.19331,0.23517,0.22608,0.17921,0.16745,0.19306,0.23486,0.22655,0.17944,0.1675,0.19275,0.2344,0.22653,0.17952,0.16746,0.19288,0.23493,0.2272,0.18024,0.16814,0.19288,0.23553,0.22785,0.18048,0.16822,0.19294,0.23587,0.22793,0.18093,0.16834,0.19283,0.23561,0.22821,0.18096,0.1684,0.19289,0.23574,0.22851,0.18116,0.16829,0.19281,0.23528,0.22848,0.18109,0.1682,0.19265,0.23498,0.22789,0.18046,0.1675,0.19174,0.23385,0.22712,0.18016,0.16712,0.19102,0.23351,0.22687,0.18027,0.16699,0.19099,0.23316,0.22689,0.18058,0.16695,0.19096,0.23351,0.22766,0.18109,0.1675,0.19123,0.23405,0.22869,0.18183,0.16811,0.19174,0.2344,0.22923,0.18212,0.16819,0.19167,0.23454,0.22974,0.1827:0
-7.2367E-6,9.22E-6,1.7733E-6,-1.4633E-6,8.3967E-6,-4.8267E-6,1.081E-5,4.82E-6,-1.79E-6,1.3847E-5,-2.9533E-6,1.0087E-5,1.1767E-6,-3.2567E-6,6.97E-6,-4.05E-6,9.8133E-6,4.13E-6,2.5333E-6,9.22E-6,-9.1333E-7,1.019E-5,7.1733E-6,1.1033E-6,1.015E-5,-2.8E-6,7.4467E-6,-4.0001E-8,-5.8333E-7,8.4967E-6,-7.1667E-6,9.84E-6,9.9667E-7,1.3633E-6,8.3233E-6,-6.6933E-6,1.03E-5,3.3167E-6,4.2667E-6,1.0423E-5,-6.7067E-6,6.7767E-6,4.58E-6,-3.86E-6,7.5694E-4,0.01915,0.17402,0.21647,0.22737,0.18285,0.16207,0.1692,0.2152,0.22584,0.18312,0.16102,0.17018,0.21533,0.22586,0.18384,0.16057,0.17112,0.21571,0.22585,0.1845,0.16099,0.17203,0.21672,0.22655,0.18481,0.161,0.17216,0.21672,0.22611,0.18449,0.16068,0.17234,0.21697,0.22605,0.18431,0.16039,0.17246,0.21695,0.22545,0.18402,0.16026,0.17269,0.21685,0.22522,0.18393,0.15997,0.17238,0.21684,0.22503,0.1837,0.15974,0.1727,0.21657,0.22479,0.18328,0.1597,0.17268,0.21649,0.22464,0.18285,0.15965,0.1728,0.21658,0.22454,0.18269,0.1597,0.17258,0.21667,0.22414,0.18238,0.1594,0.17242,0.21642,0.22346,0.18181,0.1588,0.17214,0.2161,0.22264,0.18099,0.15861,0.17226,0.21593,0.22234,0.18094,0.15843,0.17233,0.21603,0.2228,0.18119,0.15897,0.17325,0.21693,0.22385,0.18177,0.15964,0.1734,0.21722,0.22384,0.18143,0.15912,0.17317,0.21698,0.22339,0.18116,0.15932,0.17318,0.2169,0.22275,0.18048,0.15856,0.1729,0.2165,0.22201,0.17994,0.15831,0.17269,0.2163,0.22153,0.17977,0.15814,0.17278,0.21599,0.22154,0.17947,0.15803,0.17271,0.2161,0.22107,0.17915,0.15779,0.17287,0.21597,0.22135,0.17927,0.15824,0.17343,0.21681,0.22173,0.1791,0.15848,0.1737,0.21698,0.22195,0.17945,0.15881,0.17386,0.21732,0.22193,0.17915,0.15871,0.17418,0.21748,0.22159,0.17888:0
1.86E-6,-1.6867E-6,4.1633E-6,3.2733E-6,-8.6333E-7,4.94E-6,-6.7667E-7,2.82E-6,1.38E-6,7.3E-7,4.2267E-6,-1.0233E-6,2.08E-6,2.82E-6,1.1667E-6,1.9367E-6,1.6333E-7,1.1133E-6,2.12E-6,1.0E-8,3.6567E-6,-1.4633E-6,2.5133E-6,1.8633E-6,-4.7667E-7,3.9033E-6,-2.1033E-6,3.4133E-6,2.3867E-6,-8.8E-7,4.0167E-6,1.2667E-6,2.2733E-6,1.9333E-6,1.1467E-6,4.1467E-6,4.8506E-14,4.44E-6,2.2567E-6,-8.8667E-7,3.5767E-6,1.4333E-7,4.5933E-6,3.29E-6,0.0010671,0.0012453,0.0010549,0.0014415,0.001494,0.0013095,0.0011808,0.0011173,0.0014146,0.0015023,0.0013365,0.001155,0.0011324,0.0014047,0.0015029,0.0013448,0.0011527,0.0011439,0.0014027,0.021135,0.037166,0.033511,0.032093,0.038672,0.030494,0.021261,0.012537,0.028333,0.023575,0.030378,0.014171,0.021619,0.027479,0.036254,0.040072,0.027072,0.014839,0.004978,0.0029469,0.006521,0.0070773,0.0040368,0.0023598,0.0045516,0.006084,0.0052282,0.0038884,0.0036891,0.0047016,0.0055658,0.0054952,0.0042853,0.0037658,0.004672,0.0056505,0.0055875,0.0044269,0.0038593,0.0046403,0.0057044,0.0057368,0.0044846,0.0037984,0.0047224,0.0057903,0.0057902,0.0044824,0.0038536,0.0047855,0.0058016,0.0058317,0.0045457,0.0038688,0.0048445,0.0057907,0.0058937,0.0045946,0.0038907,0.0048829,0.005858,0.0059485,0.0045969,0.0039418,0.0049325,0.0058379,0.0060181,0.0046541,0.0040007,0.0049739,0.0058729,0.0060739,0.0046893,0.0040269,0.0050306,0.0058727,0.0061709,0.0047149,0.004079,0.0050553,0.0058827,0.0062258,0.0047584,0.0041313,0.0050986,0.0059125,0.0063341,0.0047758,0.0041616,0.0051186,0.0059444,0.0063893,0.0047623,0.0042186,0.0051479,0.005934,0.0064205,0.0047814,0.0042789,0.0051344,0.0059545,0.0064449,0.0047625,0.0043188,0.0051459,0.0059682,0.0065343,0.0048073,0.0043568,0.0051002,0.0060094,0.0065654,0.0048143,0.0044238,0.0051136,0.0060256,0.00658,0.0048494,0.0044555,0.0050687,0.0060844,0.0066594,0.0049088,0.0044432,0.0050455,0.0061357,0.0066849,0.0049113,0.0044909,0.005047,0.0062109,0.0066887,0.0049185,0.0045197,0.0050634,0.0062358,0.0066998,0.0049584,0.0045371,0.0050384,0.006285,0.0066917,0.0049913,0.0045387,0.0050501,0.0062965,0.0066799,0.0050284,0.0045665,0.0050103,0.0063329,0.0066939,0.0050768,0.0045415,0.0050093,0.0063409,0.0064416,0.0050824,0.0046018,0.0050386,0.0062482,0.0066577,0.0052257,0.0044777,0.0049859,0.0064281,0.0066354,0.0051611,0.0044783,0.0050796,0.006387,0.0065664,0.0052395,0.0044485,0.0051096,0.0063821,0.0065569,0.005266,0.0044665,0.0051291,0.0063333,0.0066053,0.0053267,0.0044311,0.0051683,0.0063291,0.0066166,0.0053517,0.0044249,0.0051952,0.0062953,0.0066425,0.0053988,0.004426,0.0052307,0.0062808,0.0066848,0.0054034,0.0044255,0.0052793,0.0062084,0.0066962,0.0054105,0.0044421,0.0052925,0.0061626,0.0067582,0.0054217,0.0044485,0.0052736,0.0060859,0.0067979,0.0054339,0.0044241,0.005249,0.006099,0.0068467,0.0054059,0.0044562,0.0052561,0.0060508,0.0068546,0.0053672,0.0044907,0.0052555,0.0059918,0.0068908,0.0053688,0.0045138,0.0052135,0.0059809,0.0069424,0.0052984,0.0045383,0.0051744,0.0059287,0.0069585,0.0052896,0.0045438,0.0051211,0.0059267,0.0069593,0.0052774,0.0045558,0.0050566,0.0059514,0.0069487,0.0052455,0.0046017,0.0050124,0.0059527,0.0069623,0.0052507,0.0046462,0.0049705,0.005995,0.006936,0.0052875,0.0046515,0.00495,0.0060022,0.0069178,0.0052975,0.004656,0.0049143,0.0060665,0.0069026,0.0053548,0.0046695,0.0048757,0.0061051,0.006873,0.0053829,0.0046623,0.0048638,0.0061548,0.0068565,0.0054273,0.0046523,0.0048555,0.0061942,0.0067884,0.005473,0.0046512,0.004883,0.0062265,0.0067673,0.0055528,0.0046527,0.0048897,0.0062484,0.0067407,0.0056047,0.0046177,0.0048851,0.0062407,0.006701,0.005656,0.0045769,0.004956,0.0062253,0.0067023,0.0056994,0.0045662,0.0050172,0.0061898,0.0066849,0.0057705,0.0045497,0.005045,0.006142,0.0067077,0.0058017,0.0045439,0.0050816,0.0061069,0.0067511,0.0058624,0.0045511,0.0051208,0.0060664,0.0067991,0.0059038,0.0045484,0.0051356,0.0060537,0.0068566,0.0059151,0.0045363,0.0051712,0.0059975,0.0069041,0.0059189,0.0045746,0.005166,0.0059689,0.0069613,0.0059036,0.0045881,0.0051851,0.0059282,0.0070093,0.0058897,0.0046412,0.0051924,0.0058598,0.0070445,0.0058979,0.0046895,0.0051379,0.0058449,0.0071129,0.0059126,0.0047184,0.0051007,0.005863,0.0071673,0.0058549,0.0047371,0.0051034,0.0058646,0.007177,0.0058476,0.0047966,0.00505,0.0058927,0.0071719,0.0058361,0.004818,0.005019,0.0059374,0.0071632,0.0058513,0.0048878,0.0049651,0.0059694,0.0071113,0.0058861,0.004894,0.0049508,0.0060162,0.0071018,0.0059577,0.0049282,0.004915,0.0060775,0.0070518,0.0060096,0.0049268,0.0049315,0.0061195,0.0070158,0.0060376,0.0049496,0.0049343,0.0061442,0.0069392:0
1.3E-6,1.0433E-6,1.3967E-6,3.0033E-6,2.0633E-6,1.8267E-6,3.0E-7,1.5667E-7,2.3033E-6,8.1667E-7,4.0333E-7,1.41E-6,1.4E-6,1.6633E-6,3.0567E-6,4.9667E-7,-4.8E-7,1.08E-6,1.51E-6,2.26E-6,1.3467E-6,6.0E-7,1.3333E-6,1.3133E-6,1.9533E-6,2.5233E-6,1.8467E-6,9.8667E-7,2.39E-6,1.62E-6,2.5367E-6,2.8733E-6,-1.4833E-6,2.6467E-6,2.0767E-6,2.4567E-6,1.2367E-6,7.2667E-7,8.1333E-7,2.8833E-6,2.6E-6,1.6667E-6,4.4433E-6,1.6333E-6,6.1667E-7,1.45E-6,2.52E-6,1.31E-6,2.2967E-6,2.59E-6,2.5733E-6,8.2E-7,1.2533E-6,6.5333E-7,1.95E-6,1.29E-6,1.0767E-6,1.6633E-6,3.5667E-6,1.8367E-6,4.2667E-7,1.63E-6,1.9933E-6,2.01E-6,1.8533E-6,2.62E-6,1.05E-6,7.2667E-7,1.8667E-6,1.5433E-6,1.2067E-6,1.6633E-6,5.5967E-6,0.0013643,0.0014702,0.0014892,0.0012134,0.0011135,0.0012425,0.0014638,0.0014793,0.0012473,0.001089,0.001265,0.0014515,0.0014746,0.0012575,0.0010834,0.0012671,0.0014534,0.0014749,0.0012571,0.0010796,0.0012618,0.0014604,0.0014758,0.001264,0.0010825,0.0012582,0.0014566,0.0014793,0.001267,0.027831,0.035999,0.040774,0.046095,0.040531,0.030873,0.034818,0.040478,0.045877,0.040333,0.031197,0.034415,0.0404,0.045858,0.040168,0.031313,0.034132,0.040359,0.046016,0.040256,0.031344,0.034142,0.040085,0.045898,0.040335,0.031542,0.034115,0.040179,0.046092,0.040547,0.03147,0.033939,0.040047,0.046158,0.040435,0.031611,0.033911,0.039985,0.046052,0.040507,0.031617,0.033715,0.039894,0.045969,0.040574,0.031742,0.033636,0.039537,0.045714,0.040625,0.031804,0.033512,0.039543,0.04586,0.040863,0.031762,0.033545,0.039491,0.045819,0.04094,0.031823,0.033513,0.03928,0.045821,0.040972,0.031838,0.033418,0.039284,0.045715,0.040924,0.031898,0.033392,0.039155,0.045832,0.041135,0.031995,0.033345,0.038898,0.045814,0.041284,0.032017,0.033488,0.038976,0.045794,0.041281,0.032075,0.03328,0.03882,0.045813,0.041396,0.032203,0.033159,0.038716,0.045715,0.041497,0.032263,0.033238,0.038534,0.045591,0.041441,0.032107,0.032959,0.038468,0.045488,0.041687,0.03227,0.033045,0.038397,0.045253,0.041588,0.032354,0.033025,0.038293,0.045231,0.041917,0.032369,0.033028,0.038241,0.045418,0.041944,0.03248,0.032997,0.038114,0.045395,0.042067,0.032617,0.032976,0.037874,0.045482,0.042134,0.032602,0.032807,0.037906,0.045336,0.042144,0.032518,0.032847,0.0377,0.045182,0.042336,0.032772,0.032805,0.037561,0.045167,0.042325,0.032785,0.03273,0.037351,0.045279,0.042431,0.032858,0.032712,0.037481,0.04517,0.042468,0.032893,0.032651,0.037205,0.045004,0.042704,0.033016,0.032649,0.037147,0.044936,0.042631,0.033077,0.032533,0.036989,0.044864,0.042927,0.033283,0.032473,0.036539,0.044394,0.042473,0.033018,0.032428,0.036654,0.04472,0.042881,0.033241,0.032396,0.036565,0.044594,0.042733,0.033267,0.032326,0.036374,0.044606,0.042962,0.033394,0.032234,0.036379,0.044521,0.043173,0.033455,0.032299,0.036304,0.044492,0.043073,0.03358,0.032149,0.035957,0.044398,0.043332,0.033665,0.032263,0.036102,0.044297,0.043289,0.033733,0.032313,0.035797,0.044355,0.043505,0.033741,0.032372,0.035804,0.044269,0.0434,0.033833,0.032181,0.035668,0.044177,0.043515,0.033995,0.032196,0.035399,0.044088,0.043595,0.033945,0.032104,0.035319,0.04407,0.043705,0.034179,0.032272,0.035362,0.043863,0.043761,0.034282,0.032156,0.03515,0.043941,0.04375,0.03445,0.032096,0.035077,0.043767,0.043803,0.034553,0.032128,0.035009,0.043656,0.043864,0.03451,0.032002,0.034839,0.043647,0.043921,0.034661,0.032118,0.03477,0.043614,0.043958,0.034804,0.03205,0.034682,0.043547,0.044121,0.03483,0.031952,0.029392,0.017796,0.04671,0.033387,0.034049,0.03362,0.043649,0.04489,0.034346,0.032886,0.033852,0.043533,0.044564,0.034705,0.032539,0.034011,0.043392,0.044338,0.035095,0.032371,0.033977,0.043231,0.044414,0.035277,0.032229,0.033976,0.043099,0.044496,0.035374,0.032083,0.033902,0.043117,0.044398,0.035584,0.032137,0.033789,0.043027,0.044537,0.035764,0.032097,0.033856,0.04294,0.044504,0.035803,0.032044,0.033738,0.042843,0.044582,0.035936,0.031986,0.033499,0.042695,0.044643,0.036094,0.032083,0.033564,0.042741,0.044559,0.036101,0.032009,0.033301,0.042559,0.044593,0.036263,0.032081,0.033418,0.04251,0.044768,0.036308,0.032147,0.033375,0.042664,0.044844,0.036529,0.032194,0.03318,0.042442,0.04473,0.036642,0.032119,0.03306,0.042274,0.044722,0.036718,0.032224,0.032981,0.042297,0.044801,0.036889,0.0321,0.03293,0.042325,0.044859,0.036952,0.032297,0.032924,0.04221,0.044933,0.0371,0.001985:0
6.6E-6,1.0447E-5,8.84E-6,1.21E-5,1.244E-5,6.5067E-6,8.4567E-6,9.2133E-6,1.269E-5,1.159E-5,6.6733E-6,9.6967E-6,7.4333E-6,1.293E-5,1.1717E-5,7.3733E-6,7.26E-6,8.56E-6,1.1953E-5,1.0293E-5,4.9067E-6,8.4E-6,1.0473E-5,1.1957E-5,1.1307E-5,5.7067E-6,9.37E-6,1.0633E-5,1.1633E-5,1.154E-5,5.0433E-6,1.0713E-5,1.0843E-5,0.0011725,0.0020238,0.0017951,0.0015488,0.0016514,0.0020447,0.0020576,0.0017763,0.0015003,0.0017135,0.001996,0.0020459,0.0017704,0.0014886,0.00171,0.0019896,0.0020391,0.0017547,0.0014807,0.0016985,0.0019752,0.0020059,0.0017394,0.0014638,0.0016918,0.0019584,0.0019945,0.0017187,0.0014492,0.001675,0.0019385,0.0019726,0.0016978,0.0014312,0.00166,0.0019185,0.0019487,0.0016729,0.0014163,0.0016465,0.0018938,0.0019194,0.0016472,0.0014006,0.0016275,0.0018761,0.001892,0.0016245,0.0013801,0.0016083,0.0018514,0.001862,0.0015911,0.0013662,0.0015839,0.0018267,0.0018358,0.001569,0.0013375,0.0015725,0.0018022,0.0018077,0.0015375,0.0013213,0.0015428,0.0017737,0.0017737,0.0015164,0.0013006,0.0015167,0.0017533,0.0017415,0.0014891,0.0012702,0.001498,0.0017255,0.0017095,0.0014616,0.0012503,0.0014802,0.0016998,0.0016804,0.001431,0.0012263,0.0014528,0.0016753,0.0016421,0.0014056,0.0012032,0.0014268,0.0016448,0.0016097,0.0013774,0.0011939,0.0014026,0.0016131,0.0015852,0.0013357,0.0011739,0.0013928,0.001578,0.0015592,0.0013181,0.0011409,0.0013703,0.0015674,0.0015203,0.0012953,0.0011353,0.0013438,0.0015384,0.0015072,0.0012663,0.0011091,0.0013388,0.0015161,0.0014668,0.0012549,0.0011088,0.0013115,0.0014917,0.0014597,0.0012309,0.001078,0.0013029,0.0014739,0.0014304,0.0012134,0.001079,0.0012875,0.0014485,0.0014156,0.0012092,0.0010566,0.00126,0.0014408,0.0014066,0.0011758,0.0010383,0.0012606,0.0014355,0.0013791,0.0011548,0.0010407,0.0012562,0.0014102,0.0013607,0.0011589,0.001043,0.0012371,0.001392,0.0013557,0.0011553,0.0010231,0.0012218,0.0013928,0.0013538,0.0011351,0.0010081,0.0012207,0.0013894,0.0013376,0.0011159,0.001005,0.0012215,0.001382,0.0013206,0.0011102,0.0010081,0.0012225,0.0013693,0.0013122,0.0011101,0.0010131,0.0012157,0.001357,0.0013059,0.0011124,0.0010081,0.0012004,0.0013504,0.0013007,0.0011094,9.9311E-4,0.0011932,0.0013546,0.0013053,0.0010984,9.8162E-4,0.0011889,0.0013547,0.0012991,0.001086,9.7936E-4,0.0011954,0.0013519,0.0012904,0.0010804,9.8057E-4,0.0011989,0.0013481,0.0012829,0.0010768,9.8183E-4,0.0011963,0.0013457,0.0012794,0.0010721,9.8171E-4,0.0011983,0.001343,0.0012738,0.0010649,9.7867E-4,0.0012006,0.001343,0.0012657,0.0010682,9.8794E-4,0.0012005,0.0013342,0.0012607,0.0010746,9.9243E-4,0.0011925,0.00133,0.0012664,0.0010731,9.8761E-4,0.0011921,0.001327,0.0012663,0.0010693,9.8486E-4,0.0011886,0.0013315,0.0012651,0.0010673,9.8401E-4,0.0011884,0.001334,0.001264,0.00107,9.8348E-4,0.0011854,0.0013313,0.0012674,0.0010687,9.7912E-4,0.0011862,0.001338,0.0012684,0.0010614,9.7339E-4,0.0011898,0.0013396,0.0012673,0.0010523,9.766E-4,0.001201,0.0013411,0.0012552,0.0010495,9.7883E-4,0.0011998,0.00134,0.0012564,0.0010488,9.7774E-4,0.0012001,0.0013398,0.0012556,0.0010469,9.7762E-4,0.0012072,0.0013424,0.0012502,0.0010405,9.7897E-4,0.001209,0.0013374,0.0012413,0.0010429,9.8675E-4,0.0012148,0.001332,0.0012426,0.0010495,9.8902E-4,0.001208,0.0013333,0.001241,0.0010499,9.886E-4,0.0012065,0.0013302,0.0012409,0.0010462,9.8965E-4,0.0012113,0.0013315,0.0012394,0.0010462,9.9301E-4,0.0012121,0.0013271,0.0012413,0.0010542,9.9797E-4,0.0012061,0.0013262,0.0012416,0.0010568,9.9073E-4,0.0012019,0.0013323,0.0012477,0.0010521,9.8866E-4,0.0012055,0.0013359,0.0012445,0.0010472,9.9034E-4,0.0012067,0.001337,0.0012448,0.0010456,9.8844E-4,0.0012044,0.0013363,0.0012409,0.001046,9.842E-4,0.0012061,0.0013423,0.001248,0.0010385,9.8356E-4,0.0012137,0.0013469,0.0012407,0.0010301,9.8604E-4,0.00122,0.001344,0.0012352,0.0010321,9.8935E-4,0.0012247,0.001342,0.0012335,0.001032,9.894E-4,0.0012231,0.0013435,0.0012295,0.0010315,9.9049E-4,0.0012261,0.001343,0.0012278,0.0010289,9.9434E-4,0.0012295,0.0013388,0.0012203,0.0010305,0.001002,0.0012313,0.0013346,0.0012169,0.0010325,0.0010037,0.0012276,0.0013278,0.001223,0.0010377,0.0010022,0.0012249,6.2112E-4:0
8.4233E-6,1.221E-5,1.2977E-5,6.9933E-6,8.7567E-6,9.4467E-6,1.2277E-5,1.2023E-5,6.6967E-6,8.8333E-6,1.102E-5,1.2077E-5,1.11E-5,6.6733E-6,9.8433E-6,1.014E-5,1.304E-5,1.3267E-5,6.19E-6,8.69E-6,7.8933E-6,1.2767E-5,1.097E-5,6.0033E-6,8.5833E-6,9.8633E-6,1.2883E-5,7.78E-6,6.9E-6,1.056E-5,7.65E-6,1.0507E-5,9.02E-6,7.7067E-6,8.5333E-6,9.9833E-6,1.205E-5,1.0697E-5,6.9967E-6,1.0603E-5,8.3767E-6,9.36E-6,1.3027E-5,6.17E-6,9.7433E-6,8.5233E-6,1.2047E-5,1.1987E-5,4.86E-6,7.2133E-6,1.036E-5,1.3283E-5,1.1267E-5,7.1967E-6,1.011E-5,9.8967E-6,1.2993E-5,1.224E-5,8.7533E-6,9.9467E-6,8.7567E-6,1.308E-5,1.123E-5,6.4833E-6,8.0933E-6,8.0933E-6,1.1093E-5,1.068E-5,6.8833E-6,9.46E-6,1.07E-5,1.344E-5,1.1477E-5,8.5533E-6,1.008E-5,1.0017E-5,1.4597E-5,9.0033E-6,6.7533E-6,8.3667E-6,1.091E-5,1.2737E-5,1.13E-5,7.3133E-6,8.85E-6,8.0167E-6,1.2803E-5,1.1567E-5,4.2733E-6,1.0027E-5,1.088E-5,1.322E-5,9.3633E-6,4.1433E-6,9.5033E-6,1.0223E-5,1.324E-5,8.9E-6,8.2833E-6,7.7633E-6,8.3667E-6,1.344E-5,1.0977E-5,5.8267E-6,8.2167E-6,8.9833E-6,1.216E-5,1.254E-5,7.41E-6,9.44E-6,9.3367E-6,1.117E-5,1.207E-5,7.9433E-6,1.007E-5,8.9933E-6,1.4203E-5,1.252E-5,7.2E-6,1.003E-5,1.0687E-5,1.22E-5,1.1253E-5,4.8933E-6,1.11E-5,2.2588E-4,0.0022388,0.0021194,0.0018578,0.00153,0.0018664,0.0021003,0.0021147,0.001858,0.0015299,0.0018599,0.0020984,0.00212,0.001827,0.0015601,0.001834,0.0021097,0.0021168,0.0018148,0.0015568,0.0018277,0.0020997,0.0021175,0.001806,0.0015427,0.0018179,0.0021002,0.0020993,0.0017876,0.0015418,0.0018214,0.0020888,0.0020925,0.0017849,0.0015332,0.0018095,0.0020805,0.0020776,0.0017768,0.0015317,0.0018009,0.0020706,0.0020697,0.001765,0.0015233,0.0017943,0.0020659,0.0020555,0.0017489,0.0015143,0.0017815,0.0020506,0.0020418,0.0017407,0.0015051,0.0017756,0.0020398,0.0020269,0.0017252,0.0014921,0.0017675,0.0020205,0.0020107,0.001705,0.001483,0.0017553,0.0020114,0.0019843,0.0016935,0.00147,0.0017461,0.0019949,0.0019708,0.0016709,0.0014516,0.0017301,0.0019742,0.0019475,0.0016504,0.0014408,0.0017139,0.0019513,0.0019207,0.001632,0.0014273,0.0016949,0.0019315,0.0018917,0.0016028,0.001406,0.0016776,0.001908,0.0018676,0.001582,0.0013891,0.0016572,0.0018899,0.0018396,0.0015602,0.0013742,0.0016409,0.0018616,0.0018189,0.0015359,0.0013497,0.0016178,0.0018339,0.0017824,0.0015059,0.0013347,0.0015953,0.0018027,0.001751,0.0014765,0.001317,0.0015704,0.0017817,0.001719,0.0014573,0.0012904,0.0015453,0.0017539,0.0016908,0.0014288,0.0012653,0.0015239,0.0017208,0.0016601,0.0014017,0.0012438,0.0015003,0.0017011,0.0016279,0.0013834,0.0012268,0.0014733,0.0016733,0.0015962,0.0013541,0.0012148,0.0014493,0.0016449,0.0015717,0.0013192,0.001196,0.0014378,0.0016132,0.0015531,0.0013036,0.0011627,0.0014183,0.0015977,0.0015169,0.001288,0.0011569,0.0013871,0.0015728,0.0015038,0.0012497,0.0011361,0.0013877,0.0015487,0.0014691,0.0012523,0.001122,0.001356,0.001539,0.0014566,0.0012124,0.0011089,0.0013575,0.0015159,0.0014244,0.001211,0.0011057,0.0013306,0.0014885,0.0014195,0.0011958,0.0010843,0.0013186,0.0014843,0.0013991,0.001175,0.0010818,0.0013192,0.0014663,0.0013864,0.0011786,0.0010738,0.0012951,0.0014529,0.0013833,0.0011624,0.0010518,0.0012861,0.0014527,0.0013713,0.0011391,0.0010508,0.0012945,0.0014417,0.0013442,0.0011339,0.0010577,0.0012858,0.0014164,0.0013348,0.0011418,0.001051,0.0012649,0.0014085,0.0013419,0.001133,0.0010322,0.0012532,0.0014104,0.0013391,0.001112,0.0010231,0.0012574,0.0014156,0.0013229,0.0010995,0.0010255,0.0012611,0.0014068,0.0013038,0.0010976,0.0010317,0.0012637,0.0013876,0.0012988,0.0011049,0.0010321,0.0012455,0.001384,0.0013017,0.001108,0.0010275,0.0012345,0.0013813,0.0013046,0.0011002,0.001013,0.0012395,0.0013849,0.0012999,0.0010881,0.0010073,0.0012386,0.0013909,0.0012917,0.0010845,0.0010086,0.0012434,0.0013854,0.0012844,0.0010743,0.0010091,0.0012412,0.0013797,0.001282,0.0010736,0.0010111,0.0012409,0.0013718,0.0012749,0.0010703,0.0010132,0.0012433,0.0013673,0.0012654,0.0010715,0.0010153,0.0012393,0.0013578,0.001266,0.001077,0.0010148,0.0012309,0.0013543,0.0012708,0.0010791,0.0010101,0.0012231,0.0013591,0.0012737,0.0010744,0.0010019,0.0012263,0.0013634,0.0012715,0.001063,0.0010006,0.0012276,0.0013644,0.0012689,0.0010637,0.0010029,0.00123,0.0013654,0.0012649,0.001058,0.0010014,0.0012332,0.0013635,0.0012658,0.0010538,9.9629E-4,0.0012345,0.0013679,0.0012577,0.0010478,0.001001,0.0012375,0.0013636,0.0012456,0.0010489,0.0010071,0.001241,0.0013577,0.0012471,0.0010543,0.0010122,0.0012362,0.0013534,0.0012462,0.0010532,0.0010074,0.0012297,0.0013521,0.0012473,0.0010509,0.0010076,0.0012311,0.0013508,0.0012413,0.0010532,0.0010128,0.0012325,0.0013442,0.0012441,0.0010587,0.0010139,0.0012272,0.0013485,0.0012455,0.0010592,0.0010049,0.0012247,0.0013502,0.0012495,0.0010533,9.9746E-4,0.0012251,0.0013509,0.0012445,0.0010464,9.9467E-4,0.001229,0.0013507,0.0012378,0.001044,9.9677E-4,0.0012285,0.0013518,0.0012408,0.0010416,9.9425E-4,0.0012254,0.0013531,0.0012418,0.0010361,9.8997E-4,0.0012317,0.0013619,0.0012386,0.0010323,9.9365E-4,0.0012383,0.0013568,0.0012299,0.0010339,0.0010036,0.0012404,0.0013522,0.0012277,0.0010364,0.0010045,0.0012412,0.0013525,0.0012338,0.0010346,0.0010056,0.0012434,0.001355,0.0012276,0.00103,0.0010097,0.0012434,0.0013529,0.0012218,0.001039,0.0010141,0.0012477,0.0013482,0.0012204,0.0010396,0.0010171,0.0012405,0.0013439,0.0012264,0.001044,0.0010153,0.0012401,0.0013483,0.0012246,0.0010429,0.0010147,0.0012399,0.0013493,0.0012257,0.0010406,0.0010161,0.0012409,0.0013475,0.0012237,9.1693E-5:0
9.7033E-6,6.7033E-6,7.44E-6,1.01E-5,8.2167E-6,9.42E-6,4.8167E-6,7.4567E-6,8.4233E-6,9.9333E-6,1.0013E-5,7.0933E-6,7.3467E-6,6.1033E-6,1.0013E-5,8.98E-6,5.8733E-6,6.8133E-6,9.3433E-6,8.6833E-6,6.3067E-6,7.1667E-6,6.0433E-6,7.31E-6,7.9E-6,7.6067E-6,7.5333E-6,6.9167E-6,6.7267E-6,6.75E-6,1.0383E-5,4.5667E-6,7.08E-6,9.4333E-6,1.143E-5,8.2633E-6,6.6833E-6,1.0057E-5,8.11E-6,8.6067E-6,8.6633E-6,4.6833E-6,6.9767E-6,9.1467E-6,9.88E-6,9.48E-6,7.31E-6,9.6467E-6,0.0018617,0.0020739,0.002183,0.0018161,0.0016378,0.0017216,0.0020902,0.0021598,0.0018435,0.001597,0.0017641,0.0020799,0.002149,0.001863,0.001565,0.0017831,0.0020675,0.0021411,0.001866,0.0015595,0.0017682,0.0020556,0.0021407,0.0018552,0.0015462,0.0017652,0.0020566,0.0021301,0.0018477,0.0015395,0.0017643,0.0020519,0.0021167,0.0018362,0.0015326,0.0017516,0.0020445,0.0021053,0.0018319,0.0015296,0.0017462,0.0020311,0.0020914,0.0018208,0.0015222,0.0017325,0.0020159,0.0020789,0.0018011,0.0015142,0.0017317,0.0020115,0.0020649,0.001791,0.0015022,0.0017114,0.0020028,0.0020516,0.0017809,0.0014908,0.0017066,0.0019848,0.0020393,0.0017639,0.0014736,0.0016967,0.0019691,0.0020193,0.0017501,0.0014654,0.0016822,0.00195,0.0019965,0.0017292,0.0014501,0.0016747,0.0019305,0.0019784,0.0017044,0.0014307,0.0016547,0.0019143,0.0019527,0.0016919,0.0014161,0.0016345,0.001894,0.0019289,0.0016617,0.0014005,0.0016193,0.0018681,0.001899,0.0016433,0.0013814,0.0015972,0.0018445,0.0018691,0.001611,0.0013654,0.0015721,0.0018171,0.0018504,0.00159,0.0013382,0.0015551,0.0017925,0.0018157,0.0015535,0.0013214,0.0015321,0.001766,0.0017821,0.0015366,0.0012991,0.0015035,0.0017431,0.0017475,0.001509,0.0012707,0.0014822,0.0017147,0.0017169,0.0014806,0.001246,0.0014621,0.001687,0.0016854,0.0014539,0.001221,0.0014344,0.0016638,0.0016499,0.0014224,0.0012069,0.001404,0.001627,0.0016187,0.0013879,0.0011945,0.0013829,0.0015958,0.0015983,0.001361,0.0011613,0.0013731,0.0015679,0.0015668,0.0013535,0.0011394,0.0013446,0.001549,0.0015348,0.0013144,0.0011341,0.0013257,0.0015129,0.0015205,0.0013062,0.0011081,0.0013036,0.0015031,0.0014933,0.0012763,0.0011014,0.0012913,0.0014714,0.0014722,0.0012718,0.0010731,0.0012642,0.0014651,0.0014617,0.0012368,0.0010582,0.0012633,0.001445,0.0014274,0.0012267,0.0010577,0.0012469,0.0014226,0.0014202,0.0012171,0.0010416,0.0012273,0.0014158,0.0014089,0.0011946,0.0010284,0.0012243,0.0014067,0.0013879,0.0011826,0.0010254,0.0012156,0.0013874,0.0013721,0.0011785,0.0010212,0.0012024,0.0013749,0.0013684,0.0011747,0.0010115,0.0011887,0.001368,0.0013635,0.0011665,9.99E-4,0.001182,0.0013684,0.0013564,0.0011494,9.9209E-4,0.0011781,0.0013628,0.0013484,0.0011429,9.8855E-4,0.0011777,0.0013578,0.0013377,0.0011376,9.865E-4,0.001177,0.0013539,0.0013283,0.001131,9.8726E-4,0.0011761,0.0013451,0.0013161,0.0011299,9.9051E-4,0.0011747,0.0013341,0.0013156,0.0011326,9.9059E-4,0.0011643,0.0013275,0.0013194,0.0011362,9.8193E-4,0.0011551,0.0013263,0.0013182,0.0011291,9.7257E-4,0.0011547,0.0013304,0.0013197,0.0011247,9.7014E-4,0.0011538,0.0013298,0.0013123,0.0011182,9.661E-4,0.0011499,0.0013283,0.0013158,0.0011154,9.6381E-4,0.0011484,0.0013288,0.0013106,0.0011087,9.5896E-4,0.0011514,0.0013333,0.0013078,0.0011017,9.6058E-4,0.0011574,0.0013316,0.0013031,0.0010989,9.655E-4,0.0011566,0.0013261,0.0012983,0.0011013,9.6728E-4,0.001157,0.0013257,0.0012984,0.0011014,9.653E-4,0.0011567,0.0013305,0.0012944,0.0010964,9.6718E-4,0.0011619,0.001323,0.0012923,0.0010971,9.6874E-4,0.0011622,0.0013179,0.0012918,0.0011016,9.7531E-4,0.0011539,0.0013156,0.0012886,0.0011074,9.7261E-4,0.0011514,0.0013127,0.0012914,0.0011007,9.6829E-4,0.0011522,0.0013156,0.0012898,0.0011039,9.7411E-4,0.0011502,0.0013121,0.0012885,0.0011061,9.7421E-4,0.0011424,0.0013134,0.0012902,0.0011057,9.6842E-4,0.001142,0.0013159,0.0012926,0.0011053,9.6378E-4,0.0011466,0.0013162,0.0012929,0.0011014,9.6456E-4,0.0011493,0.0013186,0.0012978,0.0011032,9.6702E-4,0.001144,0.0013164,0.0012994,0.0011053,9.5988E-4,0.0011441,0.0013197,0.0012992,0.0010981,9.5496E-4,0.0011476,0.001324,0.0012994,0.0010914,9.5697E-4,0.0011505,0.0013261,0.0012942,0.0010886,9.5958E-4,0.0011531,0.0013237,0.001293,0.0010927,9.6021E-4,0.0011498,0.0013258,0.0012937,0.0010894,9.5552E-4,0.0011533,0.0013303,0.0012938,0.0010831,9.5877E-4,0.0011556,0.0013263,0.001287,0.0010856,9.6672E-4,0.0011632,0.0013259,0.0012867,0.0010881,9.6614E-4,0.001158,0.0013238,0.001286,0.0010854,9.6307E-4,0.0011588,0.0013264,0.0012834,0.0010814,9.6655E-4,0.0011657,0.0013278,0.0012799,0.0010851,9.6927E-4,0.0011672,0.0013205,0.0012796,0.0010882,9.7243E-4,0.0011627,0.0013177,0.0012801,0.0010935,9.7077E-4,0.0011624,0.0013196,0.0012797,6.5611E-4:0
0.080181,0.0581,0.069897,0.024399,0.10707,0.075412,0.067415,0.070006,0.0299,0.10184,0.078978,0.061238,0.067679,0.022607,0.10105,0.090524,0.057315,14.366,14.03,13.981,17.568,18.553,15.122,13.605,14.269,17.452,18.413,15.448,13.401,14.5,17.414,18.305,15.44,13.276,14.569,17.438,18.35,15.452,13.216,14.543,17.406,18.333,15.418,13.212,14.522,17.379,18.298,15.383,13.192,14.533,17.387,18.267,15.335,13.15,14.552,17.408,18.197,15.261,13.166,14.597,17.374,18.139,15.268,13.164,14.549,17.332,18.143,15.169,13.09,14.558,17.298,18.023,15.146,13.088,14.494,17.287,18.003,15.023,13.08,14.495,17.237,17.999,14.976,13.056,14.505,17.224,17.935,14.897,13.02,14.465,17.188,17.843,14.827,12.973,14.403,17.168,17.735,14.79,12.894,14.414,17.115,17.668,14.689,12.827,14.397,17.02,17.556,14.596,12.779,14.34,16.954,17.46,14.463,12.733,14.259,16.867,17.325,14.346,12.639,14.209,16.777,17.179,14.192,12.551,14.11,16.662,17.058,14.04,12.467,14.019,16.542,16.879,13.861,12.346,13.911,16.351,16.664,13.688,12.182,13.758,16.188,16.401,13.455,12.028,13.609,15.941,16.122,13.24,11.817,13.405,15.663,15.849,12.944,11.614,13.208,15.36,15.529,12.655,11.386,12.962,15.056,15.15,12.366,11.116,12.667,14.712,14.764,12.009,10.885,12.313,14.304,14.396,11.622,10.535,12.016,13.905,13.89,11.228,10.256,11.621,13.422,13.441,10.861,9.8872,11.198,12.981,13.024,10.48,9.5219,10.777,12.498,12.578,10.082,9.1778,10.387,12.043,12.124,9.7026,8.8587,10.035:0
0.096728,0.064267,0.10552,0.065689,0.024593,0.095362,0.057212,0.097074,0.067116,0.026337,0.093172,0.057498,0.10109,0.065576,0.025329,0.10023,0.071957,0.10032,0.064708,0.022849,3.4199,16.31,18.245,17.816,14.003,13.684,15.695,18.301,17.736,14.195,13.515,15.765,18.249,17.64,14.251,13.493,15.821,18.23,17.555,14.233,13.487,15.833,18.215,17.52,14.19,13.47,15.832,18.209,17.484,14.105,13.412,15.842,18.23,17.39,14.018,13.431,15.884,18.164,17.31,14.041,13.434,15.837,18.161,17.283,13.932,13.417,15.876,18.098,17.22,13.894,13.364,15.842,18.085,17.111,13.842,13.349,15.814,18.072,17.021,13.793,13.331,15.815,18.004,16.951,13.717,13.294,15.809,17.936,16.903,13.625,13.263,15.773,17.837,16.786,13.532,13.254,15.682,17.803,16.628,13.46,13.169,15.682,17.692,16.512,13.364,13.139,15.594,17.589,16.392,13.213,13.082,15.495,17.461,16.206,13.089,13.0,15.398,17.327,16.029,12.955,12.874,15.314,17.168,15.823,12.825,12.767,15.179,16.994,15.579,12.653,12.649,15.029,16.759,15.353,12.446,12.483,14.817,16.508,15.061,12.202,12.291,14.613,16.215,14.724,11.976,12.088,14.346,15.881,14.398,11.706,11.883,14.041,15.576,14.042,11.389,11.648,13.719,15.141,13.67,11.067,11.313,13.381,14.742,13.167,10.734,11.025,12.947,14.274,12.771,10.379,10.612,12.506,13.818,12.288,9.9558,10.242,12.1,13.319,11.796,9.5716,9.8815,11.636,12.822,11.347,9.1905,9.5003,11.188,12.37,10.951,8.851,9.1463,10.743,11.995,10.609,8.5944,8.8567,10.367,11.617,10.257,8.3183,8.6224,10.103,11.371,9.9874,8.0914,8.3617,9.8301,11.162,9.7892,7.9508,8.212,9.6386,10.953,9.5953,7.7996,8.0492,9.5168,10.839,9.4604,45.626,248.63,320.15,352.73,303.12,251.65,249.63,315.74,348.5,301.71,248.25,242.89,309.29,338.84,291.33,228.79,221.27,233.78,176.33,80.079,24.608,30.088,72.265,73.627,37.491,24.41,34.517,63.19,63.082,38.574,31.522,38.992,59.318,58.822,40.962,36.306,41.277,56.267,56.883,42.705,38.537,41.945,54.953,56.285,44.31,40.152,42.551,54.743,56.54,45.91,41.019,43.062,55.236,56.867,46.624,41.489,43.722,55.441,57.153,47.1,41.692,44.348,55.71,57.616,47.778,41.658,44.822,56.044,57.8,48.343,41.87,45.484,56.628,58.217,48.657,41.749,46.059,57.445,58.821,49.33,42.128,47.127,58.058,59.442,49.801,42.477,48.122,58.542,60.187,50.282,42.944,48.873,58.924,61.146,50.64,43.298,49.641,59.421,62.089,50.969,43.815,50.244,59.376,62.807,51.437,44.336,50.739,59.561,63.748,51.62,44.946,51.354,59.732,64.506,51.459,45.683,51.459,60.499,65.386,51.114,46.297,51.882,61.286,65.9,5.3746:0
31.439,27.274,21.645,22.083,25.709,32.431,27.93,22.159,22.606,26.301,33.12,28.251,22.613,23.04,26.594,33.707,28.531,22.899,23.348,27.147,34.225,28.537,23.309,23.668,27.322,34.461,28.782,23.677,23.708,27.896,34.891,28.862,24.09,24.057,28.419,35.266,29.206,24.448,24.244,28.956,35.598,29.505,24.924,24.36,29.398,35.907,29.74,25.106,24.535,30.05,35.915,29.83,25.47,24.839,30.541,36.277,30.411,25.72,24.906,31.165,36.307,30.442,25.928,25.203,31.522,36.49,31.2,26.28,25.564,32.266,36.673,31.535,26.466,25.945,32.837,36.959,32.135,26.438,26.315,33.325,37.11,32.726,26.75,27.138,33.684,37.404,33.128,26.699,27.605,33.823,37.653,33.619,26.923,28.294,33.767,37.989,34.062,27.023,28.758,33.907,38.476,34.294,27.097,29.252,33.932,38.964,34.596,27.465,29.785,33.91,39.51,34.681,27.553,29.914,33.78,40.369,34.807,27.997,30.521,34.132,40.877,34.77,28.472,30.621,34.339,41.597,34.886,28.878,30.543,34.67,42.061,34.817,29.502,30.607,35.093,42.351,34.925,29.888,30.342,35.91,42.7,35.0,30.395,30.516,36.508,42.795,35.321,30.709,30.426,37.236,42.62,35.64,31.146,30.656,37.948,42.559,35.994,31.048,30.552,38.739,42.54,36.637,31.374,31.006,39.171,42.286,37.214,31.192,31.449,39.485,42.257,37.677,30.898,32.178,39.522,42.424,38.43,30.805,32.767,39.379,42.708,38.711,30.802,33.439,39.06,43.201,39.051,30.787,33.875,38.969,43.848,39.127,31.05,34.488,38.836,44.786,39.191,31.312,34.696,38.691,45.668,38.892,31.643,34.67,38.804,46.319,38.542,32.209,34.553,39.133,46.94,38.338,33.001,34.461,39.635,47.133,38.483,33.527,33.98,40.707,47.273,38.586,34.177,34.117,41.738,47.103,39.078,34.505,34.175,42.845,46.899,39.552,34.644,34.222,43.593,46.6,40.453,34.626,34.647,44.375,46.539,41.381,34.337,35.42,44.268,46.339,42.284,34.102,36.3,43.809,46.511,42.775,33.863,37.073,43.462,47.357,43.11,33.708,37.743,43.167,48.311,43.162,34.056,38.441,42.748,49.518,43.229,34.548,38.483,42.672,50.698,42.538,35.268,38.441,42.863,51.419,42.061,35.914,37.716,43.63,51.769,41.728,36.88,37.549,44.664,51.624,41.826,37.346,37.118,45.692,51.033,42.171,37.628,36.92,46.866,50.488,42.693,37.299,36.836,47.408,49.596,43.481,37.02,37.503,47.571,49.121,44.667,36.426,38.279,47.297,49.121,45.053,35.883,39.36,46.53,49.253,45.635,35.805,39.995,45.596,50.162,45.364,35.604,40.5,44.765,51.38,44.949,35.9,40.523,44.329,52.518,44.309,36.628,39.943,44.22,53.433,43.471,37.162,39.169,45.045,53.53,42.767,37.836,38.402,45.692,52.829,42.709,38.319,37.656,46.764,52.167,42.8,38.227,37.435,47.96,51.144,43.514,38.017,37.465,48.538,50.298,44.571,37.576,38.171,48.633,49.86,45.568,36.689,39.017,48.148,49.65,45.887,36.143,40.15,46.876,49.903,46.347,35.957,40.512,45.867,50.92,45.861,35.896,41.014,45.004,52.059,45.433,36.415,40.749,44.59,53.318,44.46,37.187,40.218,44.744,54.121,43.735,37.873,39.382,45.586,54.099,43.329,38.591,38.651,46.795,53.566,43.07,38.844,38.171,47.896,52.518,43.628,39.039,38.03,49.166,51.753,44.616,38.512,38.287,49.721,50.831,45.637,37.989,39.374,49.285,50.413,46.767,37.187,40.357,48.616,50.753,47.2,36.951,41.487,47.632,51.467,47.42,36.815,41.875,46.622,52.686,46.688,36.975,41.99,45.704,53.964,46.027,37.721,41.409,45.612,55.223,44.956,38.424,40.521,46.147,55.326,44.276,39.168,39.665,47.382,54.736,43.733,39.523,12.262:0
0.015338,-0.011717,0.002291,5.8737E-4,-0.0083884,0.013947,-0.01434,0.0125,-0.00166,-0.014477,0.01209,-0.021014,0.012757,0.0027457,-0.015717,0.016762,-0.019202,0.014344,0.0048101,-0.017224,0.011955,-0.016773,0.0029448,0.0027341,-0.014831,0.019284,-0.017801,0.0070654,0.0032566,-0.0082568,0.014688,-0.015369,0.0089262,-0.0015692,-0.015946,0.01814,-0.014935,0.011666,-6.7037E-4,-0.0074703,0.018172,-0.019875,5.8346,6.3152,5.7613,4.5802,4.9505,5.7885,6.2855,5.7049,4.7056,4.9017,5.8231,6.2844,5.6868,4.726,4.9109,5.8738,6.3297,5.7073,4.7392,4.9041,5.8855,6.38,5.7454,4.7632,4.9186,5.8806,6.3651,5.7506,4.7674,4.9047,5.8494,6.3366,5.7505,4.786,4.9129,5.8734,6.383,5.787,4.7916,4.9153,5.8765,6.3618,5.7945,4.7941,4.8902,5.8448,6.3705,5.799,4.8067,4.9075,5.8653,6.3845,5.8105,4.8017,4.8799,5.8313,6.3542,5.8107,4.7972,4.8975,5.8436,6.3724,5.8114,4.7969,4.8587,5.8024,6.3579,5.8185,4.8078,4.8758,5.7873,6.3386,5.7996,4.7903,4.8497,5.7903,6.3579,5.8213,4.7973,4.8462,5.7787,6.3566,5.8352,4.8103,4.8479,5.7976,6.3405,5.8447,4.8091,4.8549,5.799,6.3644,5.8388,4.8188,4.8444,5.8024,6.3585,5.859,4.8179,4.8402,5.7765,6.3678,5.8558,4.8148,4.8199,5.7736,6.3394,5.8584,4.8135,4.8049,5.7429,6.3307,5.8687,4.8162,4.8063,5.7435,6.3309,5.8728,4.8237,4.8026,5.7502,6.3437,5.8797,4.8375,4.8034,5.7491,6.3508,5.885,4.8173,4.8001,5.733,6.3292,5.8808,4.815,4.7937,5.7132,6.3083,5.8803,4.8284,4.7902,5.6844,6.3057,5.8951,4.8525,4.7828,5.6908,6.3378,5.9112,4.8485,4.7772,5.7101,6.3345,5.9211,4.8538,4.7816,5.6981,6.2948,5.919,4.8496,4.752,5.654,6.2872,5.9153,4.8435,4.7374,5.6554,6.2896,5.9286,4.8577,4.7721,5.6477,6.3099,5.9559,4.8658,4.7523,5.6507,6.2426,5.8985,4.8342,4.7155,5.5935,6.2728,5.937,4.856,4.7126,5.6091,6.2598,5.9393,4.8733,4.7446,5.6145,6.2822,5.9512,4.8774,4.7337,5.6086,6.2407,5.9604,4.8765,4.705,5.5698,6.2458,5.944,4.8541,4.7047,5.591,6.2697,5.9536,4.8806,4.7138,5.5738,6.2774,5.9818,4.8756,4.6992,5.5682,6.2196,5.9701,4.8825,4.6793,5.563,6.22,5.9765,4.8952,4.6831,5.5697,6.2369,5.9766,4.891,4.6898,5.5477,6.2289,5.9794,4.8699,4.6774,5.5158,6.2376,5.9698,4.8984,4.6807,5.5377,6.2375,5.9892,4.9113,4.6818,5.5188,6.2053,5.9851,4.8807,4.6615,5.4877,6.2141,5.998,4.8939,4.6652,5.4916,6.2155,6.0105,4.9033,4.6556,5.4808,6.1792,5.9872,4.9006,4.636,5.4738,6.1703,5.9986,4.9317,4.6403,5.4703,6.1863,6.0186,4.9167,4.6214,5.4571,6.1731,5.9891,4.9055,4.6258,5.451,6.1819,6.0143,4.9281,4.6362,5.4502,6.1542,6.0055,4.9398,4.6109,5.4224,6.1482,6.0301,4.9318,4.617,5.434,6.1757,6.0141,4.9298,4.6054,5.4124,6.1299,6.0053,4.9271,4.6029,5.3981,6.1625,6.0177,4.9483,4.6067,5.4145,6.1332,6.0216,4.9461,4.5897,5.3765,6.1323,6.0142,4.9506,4.5993,5.3883,6.1208,6.0418,4.9547,4.5888,5.3526,6.1153,6.012,4.9472,4.5841,5.3639,6.1115,6.0482,4.9625,4.5746,5.3551,6.098,6.0043,4.9521,4.5664,5.3201,6.1034,6.0318,4.9691,4.5692,5.3397,6.0707,6.0238,4.957,4.5423,5.3121,6.0779,6.0258,4.9746,4.5621,5.3156,6.0984,6.0171,4.9568,4.5457,5.2874,6.0647,6.01,4.9701,4.542,5.3053,6.0426,6.0491,4.9691,4.5377,5.2727,6.0437,6.0334,4.9659,3.9703:0
-0.02219,0.012109,6.0349E-4,-0.011561,0.013485,-0.015638,0.016559,-4.873E-4,-0.0097014,0.016727,-0.016911,0.016148,-0.0089166,-0.0095957,0.012716,-0.01872,0.01442,-0.0053475,-0.011645,0.012608,-0.013536,0.021594,-0.005163,-0.009289,0.018191,-0.020091,0.015376,-0.0051304,-0.0082142,208.07,212.38,214.78,271.47,285.13,233.99,202.67,211.27,252.84,252.6,165.46,107.49,46.905,24.376,33.064,29.533,23.286,15.605,23.631,33.321,24.865,18.858,19.448,26.537,31.821,23.888,20.203,21.96,25.955,31.668,25.24,21.493,22.086,26.282,32.622,26.126,22.118,22.437,27.21,33.469,26.74,22.634,22.82,27.937,33.986,27.269,23.202,23.206,28.45,34.358,27.723,23.606,23.476,29.108,34.67,28.166,24.061,23.739,29.628,34.908,29.01,24.796,24.421,30.767,35.612,29.939,25.332,24.936,31.39,35.781,30.613,25.647,25.226,31.721,35.949,31.211,25.827,25.665,32.209,36.19,31.93,25.973,26.17,32.517,36.524,32.58,26.227,26.802,32.616,36.913,33.328,26.476,27.404,32.772,37.258,33.961,26.784,28.0,32.798,37.748,34.479,26.974,28.495,32.928,38.343,34.901,27.281,29.025,32.966,38.919,35.277,27.661,29.27,32.772,39.59,35.619,28.057,29.479,32.862,40.174,35.807,28.551,29.585,33.134,40.945,35.919,29.086,29.61,33.335,41.265,35.789,29.597,29.489,33.632,41.457,36.096,30.085,29.25,34.128,41.453,36.348,30.657,29.226,34.96,41.581,36.954,31.337,29.381,35.769,41.622,37.655,31.657,29.439,36.532,41.524,38.125,31.984,29.686,36.948,41.256,38.932,31.897,29.69,37.318,41.077,39.634,31.908,30.273,37.238,40.914,40.715,31.767,30.69,37.147,41.206,41.302,31.63,31.361,36.655,41.392,41.882,31.625,31.695,36.526,41.894,41.947,31.803,32.159,36.103,42.409,42.207,31.977,32.295,35.941,43.347,42.234,32.573,32.758,35.853,44.253,42.506,33.238,32.66,36.164,45.294,42.503,34.229,32.694,36.497,45.39,42.184,34.664,32.064,36.944,45.04,42.074,35.174,31.849,37.561,44.604,42.248,35.485,31.56,38.293,44.363,42.757,35.985,31.655,38.842,43.678,43.596,36.09,31.643,39.373,43.353,44.273,36.005,32.116,39.287,42.833,45.575,35.672,32.492,39.141,42.871,46.369,35.392,33.219,38.548,43.05,46.867,35.187,33.855,38.165,43.71,46.94,35.323,34.184,37.508,44.427,46.959,35.408,34.125,37.0,45.327,46.353,35.807,34.355,36.658,45.866,46.048,36.497,34.101,36.837,46.531,45.638,37.431,33.891,37.4,46.705,45.629,38.383,33.337,38.074,46.199,45.472,38.732,33.048,38.821,45.484,45.811,39.189,32.676,39.396,44.544,46.347,39.478,32.958,39.789,43.864,47.552,39.327,33.058,39.951,43.358,48.439,38.837,33.633,39.591,43.109,49.315,38.44,34.24,38.972,43.407,49.65,37.965,34.903,38.105,43.931,49.704,37.959,35.161,37.456,44.666,49.201,38.139,35.423,36.949,45.46,48.773,38.608,35.214,36.704,46.397,47.804,39.283,35.028,36.757,46.63,47.454,40.299,34.478,37.364,46.536,46.965,41.249,34.157,38.209,45.907,47.318,42.012,33.759,38.989,45.1,47.682,42.203,33.729,39.669,44.109,48.545,42.179,33.584,39.688,43.371,49.474,41.879,34.029,39.555,42.966,50.567,41.299,34.552,39.078,42.97,51.101,40.786,35.429,38.273,43.326,51.157,40.426,35.834,37.489,44.019,50.693,40.699,36.373,36.845,44.961,50.197,41.037,36.441,36.555,45.952,49.344,41.724,36.425,36.493,46.316,48.666,42.778,35.745,36.829,46.47,48.023,43.751,35.251,37.683,45.584,47.727,44.519,34.699,38.439,44.778,48.003,44.936,34.526,38.82,43.491,48.783,44.956,34.353,38.974,42.814,49.887,44.329,25.843:0
-0.02345,0.016346,0.0059241,-0.021753,0.029705,-0.021511,0.0056072,0.0089691,-0.025175,0.032164,-0.022465,0.010458,3.8667E-4,-0.019233,0.028667,-0.018308,0.0047522,0.0048891,-0.027736,0.025662,-0.026427,0.012717,-0.0030833,-0.02323,0.024893,-0.018681,0.0081228,0.015396,128.88,208.6,215.92,264.51,290.05,247.96,201.21,211.43,247.09,246.71,168.52,84.768,32.999,24.041,36.118,31.017,19.696,15.987,25.413,32.757,24.598,17.8,20.919,25.592,29.864,25.003,20.452,21.995,24.326,30.919,26.571,20.968,21.588,24.808,31.893,26.84,20.933,22.067,25.404,32.46,27.057,21.281,22.612,25.847,32.807,27.267,21.789,23.148,26.09,33.297,27.608,22.213,23.349,26.457,33.915,27.902,22.582,23.56,26.801,34.307,28.065,22.851,23.677,27.177,34.692,28.228,23.196,23.846,27.621,35.101,28.431,23.573,24.061,28.084,35.343,28.621,24.006,24.222,28.376,35.554,28.956,24.33,24.268,28.82,35.758,29.108,24.575,24.35,29.294,35.826,29.282,24.764,24.367,29.676,35.868,29.542,24.971,24.476,30.079,35.853,29.716,25.114,24.589,30.513,35.763,29.903,25.229,24.749,30.824,35.703,30.144,25.284,24.96,31.261,35.749,30.514,25.315,25.203,31.586,35.676,30.784,25.332,25.501,31.776,35.793,31.312,25.392,25.867,32.145,36.183,31.904,25.512,26.306,32.181,36.3,32.103,25.387,26.616,32.19,36.595,32.425,25.443,27.151,32.071,36.661,32.604,25.488,27.335,31.809,36.999,32.844,25.544,27.712,31.701,37.323,32.986,25.572,27.964,31.596,37.607,32.952,25.592,28.102,31.439,37.736,32.862,25.681,28.381,31.307,38.088,32.732,25.847,28.623,31.276,38.45,32.641,26.122,28.519,31.185,38.952,32.744,26.45,28.481,31.417,39.439,32.635,26.722,28.519,31.772,39.809,32.63,27.088,28.386,32.258,40.087,32.725,27.606,28.377,32.476,40.302,32.85,27.851,28.135,32.928,40.182,32.748,28.065,28.074,33.407,40.119,32.938,28.291,27.986,33.794,39.978,33.24,28.532,27.971,34.413,39.87,33.492,28.586,27.924,34.847,39.673,33.693,28.534,28.002,35.108,39.389,33.96,28.424,28.147,35.131,38.991,34.229,28.188,28.182,35.125,38.808,34.442,27.849,28.433,35.076,38.779,34.758,27.668,28.836,34.936,38.777,35.032,27.639,29.213,34.728,39.055,35.398,27.536,29.68,34.41,39.34,35.583,27.474,30.016,34.253,39.735,35.695,27.48,30.394,34.046,40.085,35.718,27.579,30.695,33.755,40.571,35.589,27.602,30.782,33.588,40.855,35.321,27.806,30.785,33.515,41.404,35.064,28.072,30.75,33.555,41.771,34.793,28.454,30.554,33.754,41.948,34.63,28.853,30.268,33.972,42.219,34.633,29.282,30.01,34.213,42.314,34.482,29.491,29.694,34.723,42.15,34.481,29.754,29.456,35.225,41.902,34.516,29.862,29.267,35.71,41.638,34.758,29.973,29.261,36.232,41.313,34.992,30.047,29.318,36.652,41.058,35.456,30.017,29.452,36.849,40.74,35.81,29.788,29.694,37.032,40.522,36.345,29.561,30.091,36.991,40.462,36.816,29.321,30.48,36.92,40.606,37.191,29.128,31.051,36.688,40.819,37.522,28.979,31.493,36.263,41.085,37.692,28.925,31.915,35.881,41.453,37.685,28.878,32.218,35.634,41.955,37.622,28.963,32.388,35.405,42.499,37.347,29.081,32.466,35.151,42.945,37.037,29.404,32.398,35.1,43.521,36.636,29.712,32.128,27.127:0
-0.018368,0.0093316,0.0022791,-0.024445,0.025489,-0.015919,0.0039506,0.011885,-0.028597,0.025947,-0.031184,0.0061481,0.0067415,-0.024433,0.02378,-0.011685,0.0037638,0.013793,-0.031537,0.023239,-0.019388,0.005754,0.0090839,-0.02253,0.025998,4.2463,6.4303,6.2837,5.0662,4.8934,5.6817,6.44,6.2986,5.0903,4.8981,5.6885,6.4693,6.3015,5.1015,4.9086,5.6859,6.478,6.3121,5.1076,4.9113,5.6847,6.4844,6.3158,5.1147,4.9063,5.6892,6.4769,6.3266,5.1185,4.9031,5.6884,6.474,6.3251,5.1206,4.9081,5.6756,6.4766,6.3202,5.1235,4.8958,5.6757,6.4722,6.3227,5.1308,4.8947,5.6694,6.477,6.3315,5.1349,4.889,5.6699,6.4761,6.3239,5.1357,4.9027,5.6629,6.4814,6.3358,5.1382,4.8997,5.6585,6.4732,6.3413,5.1321,4.8924,5.6606,6.4724,6.3397,5.1444,4.8955,5.647,6.4673,6.3499,5.1389,4.8954,5.6524,6.475,6.3416,5.146,4.8855,5.6489,6.4649,6.3479,5.1408,4.8871,5.6454,6.4712,6.3541,5.1478,4.8927,5.6467,6.4693,6.3625,5.1527,4.8957,5.6431,6.465,6.3574,5.1497,4.8876,5.6432,6.4607,6.3512,5.1566,4.8906,5.6365,6.458,6.3422,5.1563,4.8706,5.6253,6.4492,6.3497,5.1564,4.872,5.6248,6.4492,6.3535,5.1567,4.8751,5.6271,6.4522,6.3432,5.1526,4.8701,5.6255,6.4387,6.3433,5.1579,4.8615,5.6098,6.4455,6.3609,5.1568,4.8607,5.6046,6.4337,6.3428,5.1547,4.8486,5.5898,6.4233,6.3391,5.1452,4.8498,5.5919,6.4258,6.3442,5.1491,4.8548,5.5826,6.4197,6.3404,5.1469,4.8477,5.5726,6.4108,6.3343,5.142,4.8365,5.5731,6.4082,6.3275,5.1506,4.8436,5.5666,6.4114,6.3442,5.154,4.8377,5.5622,6.4001,6.3334,5.1503,4.8415,5.5545,6.3956,6.3241,5.1491,4.825,5.5499,6.3881,6.3381,5.147,4.8266,5.5448,6.3875,6.3409,5.1574,4.8256,5.5455,6.3878,6.3338,5.1507,4.8277,5.5376,6.3848,6.3277,5.1575,4.8244,5.5325,6.3731,6.3372,5.1575,4.8151,5.5303,6.3757,6.3322,5.1665,4.8143,5.5202,6.3666,6.3389,5.1565,4.8206,5.5101,6.3598,6.3376,5.1649,4.8055,5.5141,6.353,6.3445,5.1645,4.8079,5.5067,6.3548,6.3423,5.1701,4.7989,5.5047,6.3515,6.3533,5.1729,4.8025,5.4883,6.3544,6.3382,5.172,4.8009,5.4933,6.3464,6.3405,5.1752,4.7949,5.4789,6.3483,6.3292,5.1757,4.7882,5.4856,6.3367,6.333,5.1735,4.7893,5.4735,6.3392,6.3329,5.1815,4.7846,5.4674,6.3273,6.3242,5.1819,4.7829,5.46,6.3314,6.3306,5.1916,4.7834,5.454,6.3227,6.3357,5.1752,4.7799,5.4536,6.3187,6.3334,5.1865,4.7763,5.4567,6.3167,6.347,5.1903,4.7826,5.4445,6.3196,6.3374,5.1864,4.7761,5.4462,6.3169,6.3324,5.1872,4.7742,5.4412,6.3062,6.3421,5.1932,4.7714,5.4332,6.2976,6.3446,5.1897,4.7665,5.4243,6.3038,6.3337,5.1963,4.7613,5.4217,6.2985,6.3391,5.1891,4.7516,5.4124,6.2877,6.3399,5.1986,4.7578,5.41,6.2912,6.3347,5.2019,4.7582,5.4072,6.2814,6.3354,5.2019,4.7496,5.3965,6.279,6.349,5.2011,4.761,5.3909,6.2826,6.3395,5.2039,4.7537,5.3953,6.2719,6.335,5.2045,4.7548,5.3857,6.2727,6.3352,5.2075,4.7474,5.3835,6.2613,6.3283,5.2056,4.7432,5.3719,6.268,6.3332,5.2139,4.7392,5.3759,6.2523,6.3368,5.2105,4.7396,5.365,6.2484,6.3342,5.2206,4.7301,5.36,6.2432,6.3296,5.2143,4.7297,5.345,6.2315,6.3203,5.2228,4.7319,5.3441,6.238,6.3382,5.2137,4.7252,5.3356,6.227,6.3172,5.2178,4.7218,5.3406,6.2255,6.3288,5.2212,4.7208,5.3249,6.2201,6.3229,5.2179,4.7176,5.3329,6.2128,6.3293,5.2238,4.72,5.3233,6.2192,6.3168,5.2172,4.7108,5.3137,3.9391:0
5.3535,6.2768,6.4767,5.4168,4.8004,5.3385,6.2745,6.4809,5.4311,4.8117,5.3247,6.2535,6.478,5.4419,4.8029,5.3236,6.2472,6.4923,5.4628,4.8041,5.2976,6.2531,6.491,5.4806,4.8031,5.2989,6.2323,6.4939,5.4941,4.8089,5.2767,6.2288,6.4872,5.5013,4.8,5.2611,6.2075,6.4851,5.5115,4.8039,5.2509,6.2002,6.4894,5.53,4.8051,5.2361,6.1861,6.4987,5.552,4.8045,5.2253,6.1811,6.5103,5.5541,4.7936,5.2051,6.1652,6.497,5.5735,4.805,5.2039,6.158,6.5044,5.5843,4.7959,5.19,6.1417,6.5096,5.6024,4.8064,5.1719,6.1365,6.5051,5.6105,4.7991,5.157,6.11,6.5057,5.6167,4.8046,5.1486,6.1092,6.5066,5.6352,4.8151,5.1287,6.0911,6.4964,5.6572,4.8094,5.1073,6.08,6.5014,5.6555,4.8113,5.1017,6.0703,6.4921,5.6847,4.8149,5.0908,6.0619,6.499,5.694,4.816,5.0775,6.0468,6.4951,5.699,4.8186,5.066,6.0357,6.4857,5.7144,4.8209,5.0506,6.024,6.4903,5.7351,4.8233,5.0367,5.9988,6.4753,5.7479,4.8156,5.0287,5.9839,6.4789,5.7485,4.8308,5.0107,5.9722,6.4682,5.7722,4.8342,5.0081,5.9551,6.4715,5.7798,4.8304,4.9873,5.946,6.4648,5.7879,4.8478,4.9744,5.9391,6.4662,5.8151,4.8489,4.9703,5.9231,6.4676,5.8226,4.8538,4.9592,5.9127,6.4692,5.8342,4.85,4.9549,5.9021,6.4603,5.8588,4.8687,4.9379,5.8938,6.4511,5.8703,4.8649,4.9246,5.873,6.4532,5.8874,4.869,4.9204,5.8719,6.4551,5.8926,4.8755,4.9113,5.8522,6.438,5.8982,4.8807,4.9012,5.839,6.4302,5.9233,4.8889,4.8795,5.8164,6.4304,5.9266,4.8873,4.8666,5.8028,6.4238,5.9301,4.8967,4.8674,5.7914,6.415,5.9522,4.8913,4.8521,5.7818,6.4127,5.9478,4.9042,4.8495,5.7768,6.4122,5.972,4.9149,4.8296,5.761,6.3946,5.9902,4.9112,4.8275,5.7494,6.3959,5.9894,4.9282,4.8207,5.7393,6.3905,6.0143,4.923,4.8178,5.7213,6.3819,6.0215,4.9331,4.8057,5.7106,6.3763,6.0273,4.9325,4.8048,5.6952,6.3649,6.0208,4.9482,4.7916,5.6813,6.3601,6.0446,4.9512,4.7819,5.6698,6.3578,6.0594,4.9553,4.7721,5.6553,6.3465,6.0638,4.969,4.7628,5.6525,6.3474,6.0727,4.9706,4.753,5.6331,6.3269,6.0764,4.9787,4.7481,5.6217,6.3144,6.0901,4.9875,4.7331,5.6011,6.3005,6.0937,5.001,4.7284,5.5791,6.3073,6.1051,5.0035,4.7178,5.5726,6.2879,6.1087,5.0107,4.715,5.5518,6.2865,6.1096,5.0186,4.7036,5.54,6.2732,6.1192,5.0243,4.688,5.522,6.2611,6.1248,5.0264,4.6853,5.5073,6.2463,6.1305,5.0302,4.6761,5.4953,6.2473,6.1204,5.0453,4.6666,5.4812,6.2368,6.1268,5.053,4.661,5.4591,6.2274,6.1403,5.0703,4.6584,5.4567,6.2239,6.1461,5.0698,4.647,5.4365,6.2006,6.1543,5.066,4.6463,5.4281,6.1812,6.1629,5.0711,4.634,5.3992,6.1743,6.1499,5.0896,4.625,5.3929,6.1552,6.1614,5.0855,4.6195,5.3647,6.1574,6.1507,5.0905,4.6113,5.352,6.1384,6.1551,5.0953,4.5981,5.3269,6.1258,6.147,5.104,4.5926,5.3204,6.1046,6.1569,5.1221,4.5835,5.2989,6.0962,6.1546,5.121,4.5751,5.2894,6.0782,6.1678,5.1176,4.5729,5.2677,6.0685,6.1493,5.1336,4.5572,5.2472,6.0557,6.1555,5.1255,4.5656,5.2363,6.0326,6.1515,5.1328,4.5489,5.2132,6.0206,6.1669,5.1421,4.5496,5.1931,6.0132,6.1481,5.1514,4.5275,5.1846,5.9843,6.1481,5.1555,4.5343,5.1641,5.9794,6.1443,5.1682,4.5194,5.1469,5.9579,6.1411,5.1715,4.5105,5.13,5.9451,6.1351,5.1796,4.5123,5.1145,5.9233,6.1325,5.1802,4.5017,5.093,5.9213,6.1343,5.191,4.5009,5.0775,5.8919,6.1349,5.1993,4.4992,5.0573,5.8866,2.4091:0
0.0061117,0.0022486,0.0071776,0.0088249,-0.0016166,0.0041248,0.0034697,0.0060648,0.0076938,-0.0022937,0.0057214,0.0028954,0.0062356,0.010101,-0.0023251,0.0058141,0.0041105,0.0054706,0.0098885,-0.0033895,0.0053926,0.0032758,0.0062633,0.010248,-0.0038909,0.005742,0.0028894,0.0063554,0.011628,-0.0033265,0.0068199,0.0022637,0.0046944,0.011014,-0.0037955,0.0049505,0.0035541,0.0068173,0.01072,-0.0033493,0.0050416,0.0041642,0.0054251,0.010515,-0.0028763,0.0054603,0.0033739,0.0060092,0.010344,-0.0026697,0.0049734,0.00367,0.0064272,0.010827,-0.0030689,0.0044255,0.0026761,0.0062269,0.011127,-0.0024002,0.0055634,0.0029502,0.0065805,0.01298,-0.0029559,0.0061852,0.0025043,0.0057951,0.012308,-0.0026004,0.0055508,0.0041181,0.0056941,0.01127,-0.00299,0.0055828,0.0032231,0.0073541,0.012791,-0.0018876,0.0042523,0.0034628,0.0077775,0.011604,-0.0043259,0.0066583,0.0024803,0.0068928,0.011972,-0.0031972,0.0054638,0.0027878,0.0082614,0.01176,-0.0052275,0.0060622,0.0012426,0.0087507,0.012365,-0.0026517,0.006616,0.0024298,0.007953,0.01172,-0.0044778,0.006559,0.0027686,0.0065813,0.01499,-0.0039105,0.0044158,0.0042623,0.0058586,0.010966,-0.0040223,0.006457,0.0024994,0.0092097,0.010848,-0.0039891,0.003356,0.0037316,0.0064758,0.012306,-0.0020194,0.004754,0.0022949,0.0073921,0.012584,-0.0045799,0.0051241,0.0025512,0.0079616,2.3973,2.4816,2.0703,1.9509,2.2958,2.6812,2.5406,2.053,1.9659,2.2863,2.687,2.549,2.0594,1.9687,2.2786,2.6846,2.5566,2.0606,1.9701,2.2764,2.6837,2.5587,2.0623,1.9645,2.2694,2.6734,2.5573,2.0637,1.9581,2.2617,2.6717,2.561,2.0667,1.9561,2.2509,2.6655,2.5598,2.0686,1.9543,2.2438,2.6607,2.5592,2.0674,1.9481,2.2374,2.6559,2.5631,2.0699,1.9446,2.2292,2.6526,2.5633,2.07,1.9415,2.2247,2.647,2.5645,2.0765,1.9394,2.2168,2.6445,2.5664,2.0769,1.9359,2.2103,2.6373,2.5662,2.0785,1.935,2.2066,2.6359,2.568,2.0848,1.9333,2.1991,2.6298,2.5671,2.0873,1.9336,2.1949,2.6259,2.5716,2.0881,1.929,2.189,2.6196,2.5719,2.093,1.9258,2.1793,2.6163,2.5713,2.0903,1.9223,2.1725,2.6078,2.5694,2.0947,1.917,2.161,2.5983,2.5665,2.0946,1.9127,2.1535,2.5898,2.5653,2.0942,1.9089,2.1477,2.5847,2.5638,2.094,1.9063,2.1382,2.5762,2.5589,2.0946,1.9002,2.129,2.5654,2.556,2.095,1.897,2.1218,2.5593,2.5554,2.0957,1.8956,2.1142,2.5534,2.5532,2.0951,1.8903,2.1069,2.546,2.5524,2.0966,1.8863,2.0974,2.5375,2.5465,2.0942,1.8792,2.0915,2.5263,2.542,2.0901,1.8745,2.0815,2.518,2.5379,2.0917,1.8721,2.0743,2.51,2.5305,2.086,1.8659,2.0659,2.4988,2.5246,2.0838,1.8587,2.0559,2.4896,2.5184,2.0804,1.8542,2.044,2.4729,2.5085,2.0768,1.8462,2.0311,2.4633,2.4955,2.0691,1.8353,2.0182,2.4458,2.4832,2.0606,1.8246,2.0031,2.4285,2.4704,2.0536,1.8168,1.9895,2.4129,2.4582,2.044,1.8039,1.9737,2.394,2.4397,2.0304,1.7909,1.956,2.3727,2.4226,2.0187,1.7794,1.939,2.3532,2.4059,2.0043,1.7644,1.9216,2.3304,2.3844,1.9917,1.7469,1.9008,2.3034,2.3586,1.971,1.7281,1.8796,2.2751,2.3337,1.954,1.7104,1.8526,2.2451,2.3064,1.9315,1.6877,1.8267,2.2131,2.2752,1.9071,1.6646,1.7989,2.1773,2.241,1.8807,1.6376,1.77,2.1371,2.2084,1.8541,1.608,1.737,2.099,2.1706,1.826,1.5835,1.7044,2.0631,2.1378,1.795,1.5598,1.6691,2.0226,2.1014,1.7662,1.5254,1.6375,1.9797,2.0607,1.7336,1.4969,1.599,1.9369,2.023,1.7033,1.4698,1.5646,1.8956,1.9866,1.6789,1.4428,1.5329,1.8596,1.9568,1.6538,1.4221,1.5065,1.8252,1.9264,1.6337,1.3985,1.4761,1.7948,1.9019,1.6128,1.3769,1.4531,1.7643,1.8809,1.5975,1.0763:0
0.0053238,0.015257,5.1621E-4,-0.0024334,0.0047201,0.0030925,0.013835,-0.0014108,-0.0020431,0.0054356,0.0026136,0.014127,0.001611,1.8204E-4,0.0060869,0.0023115,0.014052,2.5364E-4,-0.0012945,0.0054551,0.003703,0.011124,0.0013534,-0.0010782,0.0062911,0.0020355,0.01227,0.0010191,-0.0014928,0.0077519,0.0033117,0.011639,0.0028703,-0.0022901,0.0051976,0.0019969,0.012271,0.0020561,-0.0021236,0.0062631,0.0029641,0.011252,0.0017722,-0.0020004,0.0053921,0.0043757,0.01207,0.0029631,-0.001465,0.0060807,0.0050274,0.01081,0.0013095,-0.0033598,0.0050455,0.0027799,0.0099054,0.0044869,-0.0024657,0.0058513,0.0030118,0.010931,0.0050314,1.5479,1.9747,1.9057,2.4091,2.5879,2.2086,1.8817,1.9693,2.3816,2.5762,2.2377,1.857,1.9813,2.3704,2.5782,2.2464,1.8555,1.9761,2.3653,2.578,2.2531,1.8538,1.9739,2.3553,2.5752,2.2545,1.8527,1.967,2.3504,2.5705,2.2539,1.8543,1.96,2.3441,2.5703,2.2582,1.8568,1.9542,2.3358,2.5709,2.2658,1.8579,1.9504,2.3291,2.5698,2.2654,1.8563,1.944,2.3198,2.564,2.2678,1.8573,1.9413,2.3133,2.5644,2.2698,1.8551,1.9368,2.3052,2.562,2.2771,1.859,1.9305,2.2973,2.561,2.2786,1.86,1.924,2.2909,2.5557,2.2787,1.8601,1.9176,2.2806,2.5523,2.28,1.8593,1.9131,2.2725,2.5499,2.2861,1.8575,1.9083,2.2657,2.546,2.2857,1.8573,1.9012,2.2584,2.542,2.2863,1.8575,1.8973,2.2472,2.538,2.2887,1.8567,1.8927,2.2383,2.53,2.2905,1.8575,1.885,2.2343,2.5285,2.2864,1.8562,1.8807,2.2241,2.5193,2.2888,1.8528,1.8714,2.213,2.5134,2.286,1.8526,1.8629,2.202,2.5087,2.2822,1.849,1.8592,2.1933,2.4968,2.2792,1.8462,1.8457,2.1809,2.4878,2.2737,1.8406,1.8407,2.1702,2.4767,2.2695,1.8353,1.8303,2.1537,2.4664,2.2643,1.8299,1.8221,2.1463,2.4491,2.2563,1.8252,1.8128,2.1298,2.4393,2.2492,1.8173,1.8051,2.1182,2.4237,2.2393,1.8104,1.79,2.0943,2.4067,2.2306,1.7999,1.7741,2.082,2.3884,2.2154,1.7916,1.7632,2.0641,2.3698,2.2049,1.7808,1.7466,2.0453,2.3536,2.1906,1.7679,1.7318,2.025,2.33,2.1692,1.7539,1.7138,2.001,2.3018,2.1527,1.7385,1.6942,1.9748,2.2797,2.1331,1.7186,1.675,1.95,2.2522,2.1099,1.6994,1.6541,1.9246,2.219,2.0815,1.6836,1.6306,1.895,2.1874,2.0583,1.6607,1.6044,1.8625,2.1491,2.0228,1.6322,1.5726,1.8238,2.1115,1.9923,1.6031,1.5469,1.788,2.074,1.9623,1.5783,1.5197,1.7531,2.0383,1.9313,1.5523,1.4885,1.7144,1.9995,1.9011,1.5281,1.4614,1.6769,1.9621,1.8683,1.5028,1.4302,1.6424,1.9211,1.837,1.4779,1.4069,1.6085,1.8876,1.8108,1.457,1.3817,1.5825,1.8606,1.7913,1.4383,1.3595,1.5541,1.8334,1.7733,1.4254,1.3434,1.5318,1.8087,1.7544,1.4123,1.3271,1.5131,1.7904,1.7439,1.4018,1.3136,1.4916,1.7726,1.7304,1.3943,1.3029,1.4788,1.762,1.7261,1.3897,1.2942,1.466,1.7487,1.7177,1.3853,1.2851,1.4519,1.7366,1.7094,1.3806,1.2791,1.4427,1.7283,0.57975:0
7.4917E-4,-8.2373E-4,0.0015627,-2.6834E-4,2.5692E-4,0.0012276,-0.0012224,9.4291E-4,-4.2711E-4,1.3731E-4,0.0012529,-8.3157E-4,5.2623E-4,-6.437E-4,0.051777,0.066932,0.0080822,0.01781,0.012864,0.01283,0.012566,0.0062169,0.012414,0.010063,0.010797,0.0097467,0.004955,0.0096575,0.0077994,0.0085112,0.0082758,0.0047954,0.0090526,0.0081654,0.011142,0.0085798,0.0057569,0.010447,0.0084446,0.012137,0.0071735,0.0052527,0.0096147,0.0084851,0.011831,0.0083594,0.0054296,0.0099224,0.0091156,0.0098335,0.0084412,0.0052641,0.009184,0.0081445,0.010458,0.0084036,0.005337,0.01027,0.0084985,0.010541,0.0085491,0.0061707,0.0093087,0.0082599,0.011864,0.0081893,0.0058273,0.010303,0.0095431,0.011116,0.0080905,0.0060786,0.0099141,0.0089454,0.011811,0.0082465,0.0056044,0.0091584,0.0091812,0.010214,0.0075579,0.0058003,0.0093927,0.0086212,0.010956,0.0084225,0.0058396,0.0098407,0.0089934,0.011419,0.0080702,0.0053954,0.0098514,0.0088626,0.01061,0.0085155,0.0051289,0.0098604,0.00797,0.010223,0.0088787,0.0055493,0.009359,0.0087501,0.010084,0.0087374,0.0053396,0.0092713,0.0088457,0.010681,0.008247,0.005865,0.010274,0.0081629,0.01065,0.0080855,0.0056995,0.0090848,0.0083694,0.010199,0.0080936,0.00607,0.0098412,0.0088508,0.010572,0.0084692,0.0055771,0.0089707,0.0089092,0.010279,0.0080013,0.0057365,0.0093431,0.0089244,0.010408,0.0072419,0.0053425,0.0092366,0.0082188,0.010685,0.0080073,0.0052927,0.0095301,0.0081654,0.010851,0.0074372,0.0056577,0.0096282,0.0089011,0.011282,1.0619,0.97472,0.91878,1.13,1.2535,1.1352,0.95735,0.92094,1.1199,1.2454,1.1315,0.94702,0.91866,1.1072,1.2367,1.1207,0.9347,0.91293,1.1016,1.2303,1.12,0.9364,0.91541,1.1066,1.2286,1.1166,0.93006,0.90534,1.0978,1.2171,1.1103,0.92841,0.90825,1.1017,1.2163,1.1052,0.91823,0.89984,1.0917,1.2116,1.106,0.91917,0.90242,1.0908,1.2028,1.1,0.91583,0.90387,1.0892,1.2012,1.0925,0.90854,0.90124,1.087,1.2029,1.0879,0.90636,0.89766,1.0829,1.2015,1.0818,0.90355,0.89738,1.0825,1.198,1.0772,0.90232,0.89564,1.0779,1.193,1.0738,0.9007,0.89164,1.0751,1.1868,1.0736,0.89725,0.88542,1.0745,1.188,1.0699,0.89195,0.88557,1.0757,1.1802,1.0638,0.89212,0.8846,1.0697,1.179,1.0634,0.88557,0.88348,1.071,1.1748,1.0581,0.88501,0.88261,1.0642,1.1743,1.0531,0.8779,0.88169,1.0625,1.1685,1.0496,0.87485,0.87736,1.0608,1.1647,1.043,0.8736,0.87507,1.0581,1.1633,1.0387,0.87239,0.87285,1.0559,1.1604,1.0333,0.8701,0.87198,1.0582,1.158,1.0321,0.86756,0.8703,1.0572,1.1536,1.0294,0.86242,0.86778,1.0551,1.1482,1.0245,0.85749,0.86873,1.0501,1.1456,1.0194,0.85563,0.86915,1.046,1.1447,1.0155,0.85459,0.86592,1.045,1.1385,1.0149,0.84707,0.86656,1.0428,1.1398,1.0055,0.84759,0.86248,1.0384,1.1342,1.0023,0.84351,0.86084,1.0345,1.1322,0.99282,0.84214,0.85686,1.035,1.1253,0.99005,0.8354,0.85447,1.0325,1.1205,0.98634,0.83394,0.85034,1.0311,1.1145,0.98028,0.83159,0.84706,1.0303,1.1098,0.97809,0.82737,0.84655,1.0262,1.1039,0.97486,0.82214,0.84584,1.021,1.0997,0.97006,0.81725,0.84467,1.0169,1.0961,0.96607,0.81259,0.84343,1.0126,1.0945,0.95902,0.80971,0.84061,1.0087,1.0916,0.9542,0.80932,0.83894,1.0061,1.0894,0.94763,0.80678,0.83549,1.0047,1.0859,0.94358,0.80435,0.83326,1.0044,1.0815,0.93803,0.80108,0.82915,1.0025,1.0765,0.9361,0.79835,0.82785,1.0033,1.0688,0.93323,0.79431,0.82563,0.99838,1.0644,0.92947,0.79216,0.82502,0.99523,1.0626,0.92581,0.78887,0.82661,0.99258,1.0587,0.9234,0.78481,0.82466,0.98916,1.0574,0.91743,0.78233,0.82268,0.98458,1.0574,0.91384,0.78087,0.82173,0.98219,1.0538,0.90825,0.77849,0.81863,0.9794,1.0533,0.90422,0.77647,0.81662,0.97978,1.0474,0.90199,0.77523,0.81513,0.97989,1.0449,0.89846,0.77288,0.81296,0.97949,1.0388,0.89162,0.77022,0.80968,0.9773,1.0332,0.88957,0.76553,0.81011,0.97563,1.0305,0.88616,0.76476,0.80901,0.97335,1.0268,0.88502,0.75988,0.80953,0.97007,1.0258,0.88143,0.75858,0.80926,0.96861,1.0231,0.8779,0.75833,0.80744,0.96645,1.0214,0.87668,0.75415,0.80784,0.96197,1.0215,0.87117,0.75339,0.80776,0.96149,1.0203,0.86747,0.75313,0.80527,0.96235,1.0153,0.86679,0.75088,0.80245,0.96252,1.0134,0.86309,0.74928,0.80352,0.96111,1.0121,0.85976,0.74955,0.80285,0.96091,1.009,0.85617,0.74832,0.80098,0.96089,1.0046:0
4.1674E-4,-3.2668E-4,-0.0013206,0.0010145,-0.0015473,1.0093E-4,-3.909E-4,-8.7336E-4,0.0010007,-9.9234E-4,8.2924E-4,1.9762E-4,-7.7473E-4,7.817E-4,-0.0015074,3.9549E-4,1.8939E-4,-0.0011406,0.051123,0.032502,0.015495,0.015904,0.0081856,0.011549,0.0071123,0.012264,0.013069,0.0071512,0.0096616,0.0056823,0.0096489,0.0093908,0.0060791,0.0081224,0.0054202,0.0088253,0.009581,0.0065925,0.0089226,0.0068206,0.011082,0.01252,0.0063964,0.0091219,0.0070038,0.010238,0.011473,0.0060851,0.0091103,0.0068003,0.010376,0.012011,0.0057553,0.0082242,0.0065794,0.0099076,0.010623,0.0063193,0.0082567,0.005871,0.010005,0.0097239,0.0057408,0.0082106,0.0060577,0.0098897,0.011599,0.0057033,0.0086537,0.0061672,0.0099732,0.011206,0.0055772,0.0084852,0.0064528,0.0096537,0.011048,0.0057059,0.0088458,0.0067748,0.0094834,0.010837,0.0053748,0.0078353,0.0062137,0.0093593,0.010153,0.0051869,0.0083306,0.0059416,0.0092695,0.010002,0.005698,0.0080859,0.0060213,0.0093988,0.0099569,0.0049177,0.0078412,0.0056749,0.0097485,0.0099455,0.0044763,0.0075909,0.0059786,0.0095905,0.010076,0.0050172,0.0083445,0.005731,0.0095673,0.0099345,0.0052543,0.0079974,0.0056816,0.0092507,0.0095162,0.0050429,0.0075545,0.006028,0.0087249,0.0090988,0.004801,0.0081237,0.0060102,0.0091457,0.0099084,0.0047751,0.0079697,0.0058971,0.0088196,0.010199,0.0049097,0.0076091,0.0062396,0.0093482,0.0097076,0.0050328,0.0080287,0.0058727,0.0094169,0.0096865,0.0054315,0.0080218,0.0062308,0.0092977,0.009778,0.0050314,0.0075708,0.0060191,0.0090745,0.0091308,0.0041579,0.040873,0.87665,1.0411,1.131,0.9676,0.84068,0.84404,1.0338,1.1247,0.98448,0.83016,0.86161,1.0316,1.1195,0.98171,0.81705,0.86728,1.0316,1.1221,0.98715,0.81599,0.86903,1.0286,1.1183,0.98443,0.81567,0.87487,1.0298,1.1147,0.97762,0.81327,0.87701,1.0322,1.1146,0.97442,0.81081,0.87808,1.0334,1.1137,0.96903,0.80939,0.87785,1.0342,1.1119,0.96545,0.81006,0.87817,1.0328,1.1093,0.9646,0.80801,0.87598,1.0343,1.1094,0.96238,0.80272,0.87586,1.0373,1.1089,0.95431,0.80021,0.8791,1.0381,1.1007,0.9528,0.80036,0.87594,1.0356,1.1015,0.94778,0.7948,0.87978,1.0378,1.0958,0.94539,0.79606,0.87783,1.0336,1.0964,0.93737,0.79299,0.88134,1.0318,1.0948,0.9347,0.7892,0.88034,1.0323,1.0877,0.93002,0.78698,0.8774,1.0346,1.0834,0.92481,0.78737,0.87657,1.0351,1.0798,0.91918,0.7832,0.87636,1.0349,1.0735,0.91603,0.78163,0.87734,1.0352,1.07,0.91195,0.7776,0.87874,1.031,1.0677,0.90662,0.77563,0.88074,1.0292,1.0639,0.8998,0.77631,0.87892,1.0288,1.0601,0.89789,0.77198,0.87951,1.0274,1.0578,0.89147,0.76959,0.88268,1.0237,1.0556,0.88473,0.7709,0.87852,1.0248,1.0486,0.88123,0.76667,0.87842,1.0226,1.0443,0.87359,0.7667,0.87494,1.0255,1.0387,0.86765,0.76468,0.87401,1.0256,1.031,0.86593,0.76086,0.87701,1.0225,1.0266,0.86146,0.75828,0.87581,1.0204,1.0217,0.85516,0.75466,0.87525,1.0168,1.0165,0.85071,0.75312,0.87607,1.0142,1.011,0.84562,0.7519,0.8765,1.0111,1.0089,0.8405,0.74926,0.87731,1.0085,1.006,0.83437,0.7482,0.87454,1.0046,1.0006,0.82893,0.74684,0.87214,1.003,0.99467,0.82186,0.74534,0.87078,1.002,0.988,0.8186,0.74426,0.87041,1.0033,0.98105,0.81352,0.74117,0.86812,1.004,0.97463,0.81007,0.73965,0.86725,1.0014,0.96926,0.80484,0.73674,0.86808,0.99789,0.96406,0.80267,0.73514,0.86924,0.99489,0.95874,0.79882,0.73253,0.87036,0.98976,0.95602,0.793,0.73172,0.87126,0.98607,0.95296,0.78981,0.72981,0.87104,0.9853,0.94944,0.78433,0.73072,0.86902,0.98367,0.94558,0.78078,0.72929,0.86757,0.9834,0.93887,0.77478,0.73032,0.86578,0.98328,0.93455,0.77297,0.72871,0.86551,0.98224,0.92789,0.76839,0.72839,0.86539,0.98296,0.92069,0.76705,0.72552,0.867,0.97988,0.91767,0.76271,0.72705,0.86752,0.9791,0.91189,0.75964,0.72386,0.86882,0.97403,0.90861,0.75632,0.72218,0.87125,0.97144,0.9062,0.75071,0.72301,0.87034,0.96903,0.90057,0.7495,0.72189,0.87027,0.9659,0.89767,0.74526,0.72218,0.87051,0.96573,0.89408,0.74059,0.72521,0.86938,0.96796,0.8886,0.73958,0.72593,0.86917,0.96822,0.88475,0.73914,0.72492,0.87169,0.96745,0.88366,0.73559,0.72526,0.87306,0.96751,0.87795,0.73345,0.7275,0.87384,0.96738,0.87284,0.73136,0.72858,0.87584,0.96701,0.86919,0.73259,0.72772,0.87983,0.96544,0.86774,0.73051,0.72742,0.88261,0.96355,0.86766,0.7285,0.72892,0.88346,0.96207,0.86475,0.72552,0.73281,0.88397:0
-0.0027076,0.0039915,-0.0020152,6.7851E-4,0.0017682,-0.0022327,0.0038452,-0.0018941,1.8435E-4,0.0019207,-0.0022985,0.0027445,-0.0016901,4.1097E-4,0.0016421,-0.0023167,0.0021039,-0.0016376,8.368E-4,0.0021552,-0.0026338,0.0027804,-7.9773E-4,6.9528E-4,7.845,9.8314,8.7541,11.055,12.174,11.246,9.4548,8.9723,10.85,12.162,11.204,9.3214,8.9768,10.736,12.12,11.133,9.2575,8.9453,10.678,12.082,11.071,9.2187,8.9038,10.65,12.041,11.012,9.1962,8.8627,10.628,11.996,10.977,9.1676,8.8287,10.625,11.947,10.956,9.1432,8.8045,10.618,11.893,10.938,9.114,8.7961,10.612,11.858,10.933,9.0857,8.7866,10.592,11.833,10.918,9.0501,8.789,10.569,11.826,10.91,9.0356,8.8,10.55,11.839,10.89,9.0128,8.8015,10.523,11.859,10.854,9.0074,8.8055,10.504,11.878,10.824,9.0065,8.794,10.497,11.887,10.796,9.0134,8.7777,10.515,11.886,10.775,9.0869,8.8519,10.547,11.834,10.719,8.9697,8.6789,10.464,11.707,10.647,8.9042,8.6326,10.442,11.629,10.619,8.8676,8.6136,10.434,11.584,10.619,8.8374,8.6113,10.414,11.564,10.612,8.8089,8.6199,10.384,11.561,10.6,8.785,8.6296,10.353,11.574,10.573,8.7681,8.6386,10.326,11.596,10.547,8.762,8.6401,10.313,11.617,10.507,8.7628,8.6213,10.309,11.629,10.48,8.77,8.6119,10.322,11.625,10.446,8.7725,8.5908,10.34,11.594,10.442,8.7728,8.5789,10.36,11.563,10.441,8.7627,8.5642,10.375,11.523,10.442,8.7493,8.5642,10.387,11.502,10.453,8.7288,8.5737,10.378,11.479,10.455,8.7103,8.5856,10.362,11.486,10.454,8.69,8.6033,10.342,11.506,10.432,8.6782,8.6106,10.316,11.528,10.412:0
0.0073733,-0.016589,0.0056322,-0.0021128,-0.012675,0.0079646,-0.013011,0.0066059,-0.0052849,-0.0069821,0.015953,-0.013191,0.0026273,0.0025367,-0.014104,0.010377,-0.0080623,1.3203,1.0266,0.56583,0.27782,0.26482,0.27295,0.26412,0.16834,0.19338,0.14251,0.20818,0.20176,0.14339,0.18134,0.13019,0.19331,0.18534,0.13735,0.18111,0.12624,0.18575,0.18567,0.13723,0.18395,0.12172,0.18446,0.18096,0.13386,0.17674,0.11809,0.19025,0.18205,0.13195,0.17897,0.12814,0.18632,0.18262,0.12971,0.17752,0.12681,0.18367,0.18709,0.13808,0.17424,0.12668,0.18733,0.18256,0.13271,0.17466,0.12531,0.18698,0.18489,0.13777,0.1783,0.12541,0.18789,0.19813,0.14053,0.17912,0.13961,0.1883,0.2049,0.15028,0.17962,0.13904,0.19033,0.21112,0.13881,0.18194,0.13734,0.19142,0.20796,0.14589,0.17868,0.13797,0.19104,0.21081,0.14529,0.18178,0.14227,0.19753,0.20263,0.13896,0.17647,0.13814,0.19539,0.20625,0.14075,0.18058,0.13177,0.19268,0.20525,0.1392,0.18051,0.1374,0.19731,0.20222,0.14091,0.17831,0.14194,0.19557,14.764,21.69,17.035,17.999,20.459,23.068,21.605,17.27,17.791,20.6,23.093,21.483,17.418,17.613,20.614,23.004,21.371,17.463,17.479,20.579,22.925,21.336,17.464,17.438,20.548,22.88,21.265,17.391,17.389,20.487,22.806,21.124,17.294,17.326,20.363,22.642,21.073,17.237,17.209,20.303,22.565,20.951,17.149,17.145,20.157,22.43,20.822,17.044,17.053,20.043,22.327,20.727,16.971,16.982,19.957,22.204,20.592,16.882,16.868,19.898,22.088,20.491,16.754,16.794,19.759,21.937,20.328,16.663,16.667,19.666,21.719,20.157,16.496,16.55,19.514,21.526,19.967,16.327,16.394,19.328,21.289,19.766:0
0.010433,-0.0082212,-0.011011,0.015801,-0.020745,0.014822,-0.0064049,-0.0034015,0.010842,-0.02056,0.015134,-0.010717,-0.0081815,0.015854,-0.017759,0.013514,-0.012163,0.83471,1.1677,0.57938,0.57471,0.43516,0.35741,0.2773,0.16286,0.24166,0.22022,0.22314,0.21305,0.13755,0.20273,0.19271,0.19104,0.19795,0.12844,0.19953,0.18331,0.17875,0.19486,0.12672,0.18847,0.18386,0.16864,0.19694,0.12841,0.19242,0.17633,0.16665,0.19793,0.11908,0.19524,0.17358,0.17594,0.19247,0.11747,0.19013,0.17149,0.16856,0.19252,0.12158,0.19468,0.17855,0.16897,0.19282,0.12395,0.19104,0.17511,0.17217,0.18404,0.12507,0.19293,0.18181,0.18222,0.18662,0.12864,0.20119,0.18997,0.19168,0.19543,0.14012,0.1941,0.19691,0.19475,0.19243,0.14062,0.1989,0.19119,0.18995,0.18793,0.13708,0.19795,0.20209,0.188,0.18612,0.1346,0.19603,0.19027,0.19135,0.19114,0.13308,0.19671,0.19525,0.19155,0.19412,0.12922,0.19732,0.19138,0.18697,0.18384,0.13145,0.19694,0.18666,0.18967,0.18342,0.13541,0.19398,0.19063,0.1911,6.316,17.269,18.692,21.897,23.023,19.795,16.864,18.639,21.885,22.987,19.73,16.908,18.564,21.892,22.954,19.634,16.902,18.5,21.82,22.86,19.587,16.859,18.463,21.711,22.823,19.524,16.787,18.394,21.639,22.761,19.389,16.71,18.338,21.561,22.627,19.263,16.648,18.201,21.475,22.522,19.152,16.586,18.145,21.371,22.398,19.05,16.47,18.047,21.245,22.256,18.959,16.404,17.983,21.181,22.111,18.857,16.278,17.903,21.052,21.995,18.707,16.207,17.832,20.93,21.829,18.552,16.061,17.734,20.783,21.655,18.342,15.935,17.578,20.609,21.433,18.144,15.782,17.428,20.405,21.193,17.925,15.598:0
0.0076393,0.0022294,0.020015,-0.019162,0.020969,-2.9726E-4,-9.2668E-4,0.017192,-0.0079513,0.01918,0.0075458,-0.0047206,0.016403,-0.010964,0.014523,0.0021441,0.002041,0.021237,-0.011438,0.014313,0.0039835,-2.2623E-4,0.011795,160.01,198.17,238.71,261.73,219.87,184.59,190.33,234.16,246.33,214.43,165.59,160.43,146.13,82.341,29.568,15.164,35.251,42.319,29.222,19.951,22.224,32.642,29.608,30.257,26.149,26.407,27.552,27.8,34.733,28.571,25.53,26.251,28.995,36.525,29.699,25.809,26.425,30.991,38.009,30.087,26.052,27.26,32.308,38.911,30.784,26.788,27.845,33.507,39.747,31.412,27.528,28.645,34.624,40.418,31.935,28.03,29.124,35.596,40.858,32.78,28.904,29.892,36.523,41.372,33.604,29.191,30.201,37.312,41.638,34.584,29.98,30.845,37.897,41.767,34.901,30.03,31.502,39.282,42.316,35.625,30.29,32.093,40.084,42.753,36.526,30.555,32.442,40.009,42.831,37.228,30.721,33.047,40.128,43.412,38.102,30.825,34.102,40.811,44.097,38.434,30.769,34.734,41.032,44.155,38.48,31.118,35.319,40.438,44.782,39.335,31.694,35.955,40.602,45.696,39.791,32.165,35.91,39.901,46.036,39.954,32.138,35.658,40.176,46.722,39.822,32.849,36.486,40.839,47.175,39.52,33.374,36.729,40.717,47.157,39.749,33.917,35.967,40.718,47.792,40.226,34.94,36.049,41.141,47.803,40.506,35.039,35.098,41.474,47.884,39.89,35.005,35.315,42.367,47.65,40.421,35.984,35.587,42.951,47.268,41.392,35.985,34.903,42.917,47.416,41.375,34.966,35.043,43.731,46.794,42.088,35.586,35.9,43.751,46.123,42.952,35.877,35.702:0
0.0095456,-0.012695,0.017982,-0.0087254,0.012237,0.010653,-0.013384,0.02412,-0.011182,0.0048192,0.013721,-0.016097,0.02487,-0.0059091,0.0094474,0.011604,-0.012131,0.021376,-0.0085731,0.013816,0.012366,-0.0099667,0.018722,-0.0091839,0.0051361,0.016783,-0.018137,0.022009,-0.0090002,0.011589,0.011498,-0.017168,0.018242,-0.011289,208.88,259.47,220.32,178.72,197.4,239.22,257.3,214.02,167.64,193.77,219.82,215.11,139.36,62.254,22.219,26.985,44.792,37.323,21.458,15.39,29.922,40.364,29.004,19.958,21.691,33.597,37.492,26.642,21.994,25.988,33.647,36.298,27.646,24.224,27.403,33.183,36.615,29.422,25.487,27.839,33.635,37.326,30.693,26.064,28.79,34.79,38.212,31.575,26.407,29.637,35.776,39.014,32.385,27.0,30.8,36.539,39.877,33.313,27.565,31.697,37.01,40.72,33.778,28.1,32.593,37.246,41.749,34.611,28.546,32.853,37.199,42.393,35.14,29.304,33.856,37.802,43.385,35.681,29.645,33.978,37.818,43.664,35.558,30.014,34.644,38.557,44.655,36.043,30.627,35.016,39.628,45.802,36.221,30.9,34.808,40.263,46.367,36.224,31.471,35.044,40.3,46.052,36.605,32.369,35.058,41.19,46.832,37.275,32.96,34.865,41.717,46.665,37.192,32.959,34.707,42.343,46.574,37.501,33.257,35.392,43.706,46.791,37.941,33.357,36.004,44.083,45.841,37.888,33.215,36.012,43.94,45.443,38.988,34.095,36.919,43.873,45.41,40.243,34.386,36.837,42.841,45.865,41.087,33.515,36.887,43.052,46.669,41.921,33.543,37.599,42.962,47.399,41.937,32.656,37.376,42.923,47.12,41.289,32.644,38.337,42.708,48.37,41.951,33.206,38.416,42.486:0
-0.021678,0.022824,-0.0046136,0.0022682,0.015971,-0.012574,0.024656,-0.0030932,0.01026,0.013658,-0.015417,0.014827,-0.0053668,0.0077258,0.02031,-0.018145,0.018848,-0.0045513,0.01213,0.019354,-0.016338,0.022033,0.0030012,0.0042761,0.01495,-0.009374,0.023097,50.049,260.65,244.77,202.61,178.68,214.77,256.58,247.33,198.53,175.51,208.48,244.56,233.83,181.08,149.43,135.7,84.34,37.561,20.656,32.104,42.759,28.852,27.493,24.697,30.977,32.082,29.471,33.211,27.907,28.588,29.525,32.641,35.808,28.513,27.672,29.247,34.804,37.349,28.8,27.394,30.807,37.102,37.636,28.812,27.809,31.348,38.083,38.542,29.607,28.236,32.72,39.449,38.632,29.961,28.879,33.733,40.359,39.221,30.866,29.547,34.637,40.958,40.089,31.752,29.559,34.664,41.176,40.718,32.632,29.683,35.634,41.808,40.92,33.134,30.306,37.185,42.252,41.484,33.49,30.837,37.87,41.953,42.336,33.793,30.575,37.782,42.047,43.332,34.279,31.31,38.589,42.26,43.608,34.438,31.746,39.084,42.262,44.416,34.895,31.959,38.888,42.364,45.467,34.995,32.863,39.519,42.984,46.36,34.986,33.113,38.705,43.069,46.607,34.615,33.532,38.873,43.352,46.821,35.428,34.792,38.949,43.415,46.906,35.87,35.143,38.162,43.8,46.942,35.653,34.856,37.907,45.382,48.064,36.289,34.604,37.453,45.974,48.103,36.106,33.744,37.841,46.858,46.666,36.227,34.394,38.868,47.637,47.089,36.953,34.155,39.557,47.44,46.139,37.292,34.407,39.808,46.142,46.386,38.372,34.147,40.625,46.786,46.566,38.649,33.929,40.603,45.687,46.455,38.636,33.156,40.779,45.591,47.116:0
-0.031994,-0.0021839,-0.015974,-0.024745,0.0029085,-0.02825,-0.0021271,-0.010895,-0.025824,0.0027127,-0.033216,-0.004478,-0.01958,-0.016859,0.0086724,-0.031792,-0.0038586,-0.021554,-0.021435,0.009794,-0.022555,-0.009005,8.5698,3.8283,3.9637,4.7147,6.0426,3.9192,2.5847,2.3301,2.2164,3.8606,2.8212,1.9812,2.109,2.1415,3.7411,2.7658,1.9523,2.0796,2.1237,3.7041,2.764,1.9411,2.0706,2.119,3.6873,2.7647,1.9345,2.0599,2.1094,3.6687,2.768,1.9301,2.0575,2.1041,3.6639,2.7746,1.925,2.0507,2.1022,3.6445,2.7853,1.9171,2.0527,2.0985,3.6279,2.7946,1.9135,2.0442,2.0916,3.6122,2.7958,1.9101,2.0409,2.089,3.5984,2.8079,1.9035,2.0407,2.093,3.5896,2.8213,1.9017,2.0343,2.0905,3.5759,2.825,1.8957,2.0301,2.0815,3.5555,2.8297,1.8943,2.0342,2.0842,3.5458,2.8421,1.9007,2.0272,2.0786,3.5251,2.8596,1.8955,2.0196,2.0826,3.5224,2.8553,1.8948,2.0249,2.0713,3.5045,2.8755,1.8902,2.0176,2.072,3.4911,2.8845,1.8967,2.0189,2.0697,3.4827,2.8987,1.8838,2.0163,2.0684,3.4663,2.8933,1.884,2.0167,2.066,3.4477,2.9132,1.8851,2.0149,2.0608,3.4374,2.9341,1.8903,2.0145,2.0658,3.4312,2.9344,1.8889,2.0115,2.0656,3.4105,2.938,1.8834,2.0123,2.0593,3.3986,2.9491,1.8855,2.006,2.0618,3.3852,2.9576,1.8883,2.0009,2.0537,3.3807,2.9647,1.8912,2.0038,2.0581,3.3615,2.9801,1.895,2.0011,2.0552,3.3513,2.982,1.8851,1.9947,2.0534,3.3399,3.0034,1.8952,2.0016,2.0448,3.3188,3.0099,1.8811,1.9931,2.0485,3.304,3.027,1.8904,1.9916,2.0441,3.294,3.0324,1.8901,1.9968,2.0452,3.2703,3.0413,1.8913,1.9959:1
-0.0085352,-0.0060669,-0.020655,0.011825,-0.02808,-0.0031931,-0.0031446,-0.025957,0.0096202,-0.028626,-0.0071123,-0.013426,-0.025176,0.011984,-0.024546,6.5545,4.6881,3.8193,4.0528,5.2432,6.2741,4.3812,3.1025,3.2051,3.2623,4.0482,2.5573,2.0003,2.136,2.2633,3.8928,2.4581,1.9725,2.1008,2.2374,3.8748,2.4526,1.9525,2.0955,2.2143,3.8681,2.448,1.9428,2.0912,2.2031,3.867,2.4327,1.9422,2.0828,2.1889,3.8594,2.4402,1.9387,2.0747,2.1754,3.8701,2.4277,1.9255,2.0744,2.1626,3.8648,2.438,1.922,2.0689,2.1521,3.8568,2.4393,1.922,2.0649,2.1415,3.8582,2.4345,1.9189,2.06,2.1404,3.8504,2.4329,1.9234,2.0605,2.1303,3.8508,2.4362,1.9121,2.0559,2.1298,3.8527,2.4387,1.9135,2.0526,2.1207,3.8545,2.4386,1.9129,2.0509,2.1136,3.8489,2.4386,1.9086,2.0514,2.1074,3.8441,2.442,1.9044,2.0517,2.105,3.8416,2.4507,1.9005,2.0476,2.0997,3.8397,2.444,1.9037,2.0444,2.0953,3.8411,2.4509,1.9016,2.0459,2.0918,3.8377,2.4491,1.8944,2.0431,2.0879,3.8349,2.4518,1.898,2.0397,2.0883,3.8317,2.4514,1.8915,2.0371,2.0758,3.8253,2.4578,1.8909,2.0358,2.0851,3.8255,2.4608,1.8904,2.0369,2.0765,3.8175,2.4646,1.8904,2.037,2.0784,3.8083,2.4761,1.8925,2.037,2.0799,3.8095,2.4668,1.8864,2.032,2.0678,3.8006,2.4779,1.8809,2.0278,2.0636,3.7937,2.4781,1.8824,2.031,2.0682,3.7944,2.4789,1.8742,2.0337,2.0662,3.7897,2.4757,1.875,2.0224,2.0574,3.7842,2.4801,1.8734,2.022,2.0626,3.7816,2.483,1.8834,2.0276,2.06,3.7766,2.4824,1.8711,2.0231,2.063,3.7792,2.49,1.881,2.0199,2.0616:1
0.0051125,1.435E-4,-0.035591,0.027386,-0.034906,-9.5963E-4,-0.0023059,-0.029302,0.028673,-0.029874,0.0018344,-0.0029989,1.9488,0.924,1.8557,1.848,1.1883,0.93603,1.04,1.2007,1.6947,1.1216,0.89034,1.0134,1.1772,1.6729,1.1047,0.86838,1.0025,1.162,1.6648,1.0993,0.8598,0.99574,1.1476,1.664,1.0876,0.85555,0.99857,1.1312,1.6624,1.0776,0.8476,0.97985,1.1281,1.6599,1.0665,0.84445,0.9825,1.1217,1.6573,1.0604,0.83784,0.97367,1.1178,1.6458,1.0504,0.84138,0.97365,1.1172,1.6425,1.0526,0.82933,0.96764,1.1105,1.6377,1.043,0.83364,0.97068,1.1125,1.6336,1.0431,0.82116,0.96114,1.1042,1.6311,1.0372,0.82385,0.96415,1.1006,1.6289,1.0292,0.82055,0.96144,1.0971,1.6278,1.0368,0.82262,0.96317,1.0928,1.6297,1.0284,0.81774,0.95672,1.0921,1.6253,1.033,0.81757,0.95207,1.0826,1.6239,1.0285,0.81393,0.95829,1.0873,1.6286,1.0274,0.81507,0.95968,1.0815,1.6235,1.0292,0.80931,0.94656,1.0843,1.6364,1.025,0.80948,0.94752,1.0708,1.6298,1.0276,0.80947,0.94674,1.0751,1.6314,1.0179,0.80394,0.94292,1.0707,1.6301,1.0271,0.80971,0.94519,1.0807,1.6222,1.0164,0.80965,0.93899,1.0779,1.6207,1.0231,0.80443,0.94079,1.0757,1.6122,1.0226,0.80224,0.94882,1.0749,1.6219,1.0214,0.80638,0.94271,1.0667,1.6147,1.0258,0.80192,0.94658,1.0642,1.6224,1.0218,0.79948,0.94052,1.0601,1.6198,1.0235,0.79431,0.94509,1.0621,1.6233,1.0145,0.80225,0.9357,1.0551,1.6192,1.0082,0.80465,0.93792,1.0598,1.6245,1.0035,0.80093,0.93166,1.0628,1.6187,1.0148,0.80456,0.93481,1.059,1.6237,1.0095,0.79666,0.93534,1.066,1.6108,1.0057,0.79985,0.94256,1.0625:1
0.0031832,-0.0032471,-0.035376,0.028266,-0.029073,-6.078E-4,-4.3195E-4,-0.036387,0.033679,-0.033184,0.0014529,-1.8406E-4,-0.041556,0.034913,-0.035505,0.0038947,1.2481,1.4615,1.3845,1.4727,1.6741,1.1007,0.91115,1.0199,1.2952,1.5826,1.0556,0.87997,0.9993,1.2759,1.5658,1.0417,0.86982,0.99381,1.2607,1.57,1.0315,0.86101,0.99299,1.2568,1.5663,1.0193,0.84341,0.98593,1.241,1.5616,1.0154,0.85004,0.97734,1.2341,1.5574,1.0079,0.83931,0.97544,1.224,1.5577,1.001,0.84254,0.96982,1.2214,1.5678,0.99604,0.8401,0.96625,1.2181,1.5653,0.99743,0.83707,0.96088,1.2068,1.5647,0.9924,0.83573,0.95591,1.2038,1.561,0.99137,0.83246,0.96449,1.1949,1.5626,0.98573,0.83859,0.95695,1.1936,1.5555,0.98703,0.82686,0.95208,1.1872,1.5511,0.98413,0.82254,0.95307,1.1879,1.5516,0.98931,0.82194,0.95377,1.1836,1.5581,0.98482,0.82433,0.9535,1.1692,1.5547,0.98822,0.81496,0.95548,1.1692,1.5557,0.99087,0.81284,0.94619,1.1561,1.5595,0.98616,0.81213,0.95061,1.1566,1.5675,0.98129,0.81519,0.94322,1.157,1.5663,0.97448,0.81815,0.93796,1.149,1.5648,0.97807,0.81924,0.9394,1.1432,1.5589,0.96954,0.8161,0.94015,1.1506,1.561,0.97396,0.82088,0.93817,1.1464,1.5564,0.98156,0.80891,0.93937,1.1423,1.5527,0.98528,0.81041,0.93976,1.1282,1.5554,0.98424,0.80689,0.93669,1.1199,1.5677,0.98763,0.79518,0.94374,1.1178,1.5595,0.99818,0.79704,0.94012,1.1177,1.574,0.99502,0.79895,0.93386,1.1136,1.5693,0.98627,0.80373,0.93282,1.106,1.573,0.98408,0.80309,0.93319,1.116,1.5744,0.98023,0.80418,0.92922,1.1107,1.5758,0.98014,0.80119,0.93458,1.1067,1.5686,0.98915,0.80655,0.93513,1.1086:1
-0.030518,0.020984,-0.0074247,-0.02123,0.023629,-0.033896,0.017001,-0.0094859,-0.012985,0.021981,-0.030021,0.018795,-0.0054967,-0.014863,0.019171,-0.033474,0.014023,-0.0093259,-0.016766,0.01684,-0.038073,0.023076,-0.0059437,-0.017585,0.020793,1.5467,2.213,1.7059,1.0761,1.0327,0.98284,1.5534,1.4592,0.97966,0.95881,0.94246,1.5171,1.4387,0.9634,0.94904,0.93711,1.5027,1.431,0.94903,0.93892,0.92828,1.5008,1.4168,0.9447,0.93142,0.92333,1.4861,1.413,0.93855,0.92575,0.91578,1.4783,1.4125,0.93,0.92208,0.90898,1.4773,1.4052,0.92265,0.91772,0.90706,1.468,1.397,0.92195,0.91015,0.9032,1.4709,1.3985,0.92143,0.90974,0.90136,1.4653,1.3881,0.91214,0.90695,0.89755,1.4617,1.3914,0.91258,0.90584,0.89195,1.4521,1.3886,0.91538,0.89987,0.8973,1.4497,1.3877,0.90622,0.90402,0.8916,1.4474,1.3859,0.91071,0.89902,0.88937,1.4377,1.3942,0.89682,0.89625,0.89103,1.4386,1.395,0.90285,0.90031,0.87579,1.4336,1.3952,0.8984,0.90004,0.88229,1.4216,1.3914,0.89658,0.89804,0.88557,1.4323,1.3918,0.89608,0.89959,0.88411,1.4335,1.3784,0.88943,0.89177,0.88344,1.4282,1.3713,0.90309,0.88725,0.88524,1.433,1.3693,0.90115,0.8811,0.8828,1.4292,1.3674,0.89817,0.87992,0.88252,1.422,1.3726,0.90706,0.88011,0.87902,1.4186,1.3732,0.89686,0.88538,0.87896,1.4126,1.3872,0.89187,0.88658,0.8745,1.4112,1.3935,0.89294,0.89058,0.87411,1.4128,1.3839,0.88735,0.88604,0.87594,1.4005,1.3848,0.8914,0.88251,0.87868,1.4116,1.3775,0.89387,0.88435,0.87451,1.4065,1.3765,0.90118,0.87588,0.87394,1.4032,1.382,0.89323,0.87253,0.87222,1.4023,1.3747,0.89853,0.87575,0.88088,1.3902,1.3796,0.8929,0.87296:1
-0.0035308,-0.012993,0.014557,-0.018151,0.0021397,-0.0024712,-0.014062,0.016757,-0.015293,0.0043246,-0.001684,-0.014727,0.012364,-0.022458,0.010117,3.472E-4,-0.010743,0.016168,-0.020647,-0.0022066,-0.0076101,-0.012365,0.011772,-0.016554,-0.0015711,-0.004234,-0.01344,0.011628,1.9377,2.7009,1.3569,1.0336,1.2377,1.3123,1.5276,0.7563,0.60246,0.71652,0.6875,1.4028,0.73299,0.58982,0.70749,0.68273,1.4043,0.72645,0.59032,0.70742,0.6815,1.3938,0.71913,0.58326,0.70196,0.67636,1.3933,0.7148,0.5852,0.69974,0.67875,1.3857,0.7173,0.58491,0.70156,0.66924,1.3829,0.70552,0.58466,0.698,0.67372,1.3782,0.71018,0.58142,0.69562,0.6727,1.3786,0.69886,0.58036,0.69622,0.66805,1.3683,0.70256,0.57927,0.69669,0.67252,1.3629,0.69972,0.58629,0.69488,0.67585,1.3706,0.70531,0.58104,0.68674,0.6779,1.3665,0.69796,0.58796,0.69384,0.68726,1.3607,0.69103,0.58173,0.69254,0.68743,1.3561,0.69521,0.57954,0.6948,0.68735,1.3527,0.69816,0.58189,0.68912,0.69955,1.3542,0.69014,0.5833,0.69189,0.70149,1.3476,0.69064,0.58454,0.6939,0.70533,1.3502,0.68537,0.57994,0.69375,0.71224,1.3402,0.67872,0.58846,0.69127,0.72151,1.3407,0.67852,0.58739,0.68955,0.7293,1.3328,0.6802,0.59125,0.69671,0.72829,1.3312,0.67967,0.58913,0.68954,0.72749,1.3238,0.68155,0.59104,0.69379,0.73162,1.3315,0.67718,0.58839,0.69231,0.73032,1.3231,0.67943,0.58771,0.68902,0.73352,1.3128,0.67262,0.58423,0.69379,0.74246,1.325,0.66902,0.59253,0.6919,0.74837,1.3088,0.66406,0.58664,0.69293,0.75529,1.3071,0.66067,0.59352,0.6858,0.76022,1.3046,0.66803,0.59119,0.70191,0.7584,1.3016,0.66744,0.59083,0.68627,0.75897,1.2922,0.66925,0.591,0.69626,0.76882,1.2923:1
-0.015824,0.0043299,-0.001241,-0.016965,0.012257,-0.023722,0.0095546,-0.0062634,-0.011479,0.010192,-0.019569,0.0050803,-0.004431,-0.014791,0.0075785,-0.022434,0.0042949,-0.0011298,-0.015135,0.012449,-0.020529,0.0036689,-0.0075893,-0.014953,0.011122,-0.018665,0.0031479,-0.0014077,-0.011349,0.0062286,1.3894,2.8045,1.5631,1.0519,1.1657,0.90792,1.3616,0.92466,0.58132,0.69707,0.6734,1.2782,0.90762,0.5771,0.69334,0.67255,1.2825,0.89361,0.56963,0.68114,0.66463,1.2814,0.88131,0.56309,0.68626,0.66952,1.2785,0.87254,0.57144,0.68444,0.65945,1.2799,0.86877,0.57043,0.68573,0.66458,1.2855,0.86541,0.56642,0.6875,0.66547,1.2841,0.86528,0.56613,0.6897,0.65745,1.2958,0.85224,0.56322,0.68613,0.666,1.2958,0.84332,0.56527,0.67805,0.66184,1.2917,0.83931,0.56516,0.68532,0.66245,1.3094,0.83672,0.5659,0.68966,0.66349,1.2982,0.82657,0.57213,0.68982,0.66346,1.3112,0.82236,0.56709,0.68849,0.66768,1.3046,0.82021,0.57577,0.69188,0.66396,1.3106,0.81002,0.571,0.69055,0.66854,1.3201,0.81059,0.57506,0.68957,0.66701,1.3267,0.80097,0.57086,0.68925,0.6629,1.3351,0.79559,0.58054,0.68809,0.66632,1.3307,0.79394,0.57103,0.68512,0.66541,1.3418,0.78568,0.57618,0.68305,0.66812,1.3346,0.77759,0.57716,0.6867,0.66589,1.3392,0.77566,0.58275,0.68117,0.66681,1.3451,0.76784,0.5811,0.68916,0.66872,1.3548,0.77073,0.58196,0.68768,0.67035,1.3547,0.76895,0.58386,0.69303,0.66472,1.3566,0.75591,0.57998,0.6888,0.66955,1.3612,0.75437,0.58357,0.68812,0.66547,1.3585,0.75384,0.58461,0.68895,0.67101,1.3626,0.74876,0.58378,0.68707,0.66959,1.3627,0.74399,0.58349,0.69676,0.66642,1.3697,0.74176,0.58333,0.69138,0.66368,1.3662,0.73938,0.58924,0.6916:1
0.012594,-0.016872,-0.0038985,0.0035054,-0.012061,0.0079174,-0.023157,-0.0023523,8.7553E-4,-0.013566,0.0072707,-0.012944,-0.0023646,-0.0021823,-0.026009,0.011935,-0.013441,0.0026122,-0.001509,0.057741,1.0976,2.2784,2.1602,1.3438,1.324,1.5393,2.303,2.1698,1.3508,1.3455,1.5691,2.3381,2.1853,1.3689,1.3613,1.5889,2.3523,2.2071,1.3908,1.3676,1.614,2.3684,2.2303,1.3936,1.3907,1.6266,2.3624,1.9774,1.1422,1.022,0.99913,1.1112,1.3203,0.68499,0.67259,0.76286,1.0322,1.2779,0.64586,0.64003,0.73716,1.0022,1.2606,0.63285,0.63489,0.72463,0.98637,1.2525,0.62466,0.62109,0.71996,0.97652,1.2435,0.62096,0.62187,0.71388,0.97445,1.246,0.60759,0.62175,0.70777,0.97571,1.2271,0.60244,0.61585,0.7099,0.96595,1.2374,0.59392,0.618,0.69648,0.96589,1.2267,0.60933,0.61169,0.70592,0.96136,1.2225,0.60509,0.61234,0.70947,0.97298,1.2195,0.58709,0.60552,0.7011,0.97062,1.22,0.59532,0.6163,0.70679,0.9669,1.2209,0.5934,0.60944,0.70131,0.96701,1.2103,0.59226,0.60201,0.70503,0.97406,1.2137,0.58841,0.60282,0.69986,0.9721,1.2045,0.58957,0.60468,0.70714,0.9768,1.2011,0.58793,0.60828,0.70998,0.98168,1.2038,0.58737,0.60387,0.69955,0.97716,1.2019,0.59048,0.60309,0.69851,0.96914,1.1947,0.57779,0.60058,0.70385,0.97959,1.1879,0.58651,0.60027,0.70118,0.98661,1.1947,0.58909,0.60466,0.69751,0.98469,1.1888,0.58553,0.60234,0.69969,0.98524,1.1856,0.5815,0.59963,0.69699,0.99024,1.1784,0.57709,0.60439,0.69296,0.98798,1.1832,0.57656,0.60964,0.69318,0.98712,1.1865,0.57994,0.60936,0.70154,0.99218,1.1799,0.58308,0.60468,0.70525,1.0059,1.1757,0.57318,0.60336,0.69976,0.98805,1.176,0.58236,0.60906:1
-9.3782E-4,0.0013977,-5.4827E-4,-0.0010342,0.001624,-0.0014792,-2.6607E-5,6.6003E-4,-0.0017198,0.0023906,-0.0015419,0.0013824,4.9009E-4,-0.0016405,0.0019694,-0.0012538,0.0012713,7.4523E-4,-9.4798E-4,0.0016711,0.43861,0.34168,0.18468,0.14129,0.14496,0.14333,0.26772,0.16053,0.12783,0.13995,0.13963,0.26482,0.1561,0.12535,0.13651,0.13632,0.26028,0.15535,0.12317,0.13546,0.13443,0.25754,0.15406,0.12404,0.13551,0.13372,0.25664,0.15311,0.12033,0.13491,0.12939,0.25347,0.1592,0.12611,0.14099,0.13823,0.26615,0.16148,0.12482,0.13781,0.13666,0.25884,0.15934,0.12277,0.13486,0.13596,0.25741,0.1568,0.12202,0.13308,0.13423,0.2578,0.15834,0.12189,0.13268,0.13298,0.25351,0.15676,0.12051,0.13378,0.13479,0.25272,0.15703,0.12109,0.13152,0.1331,0.25108,0.15761,0.1203,0.13246,0.13232,0.25022,0.15797,0.11962,0.13149,0.13222,0.24848,0.15782,0.11874,0.1301,0.13211,0.24739,0.15841,0.11782,0.13038,0.13083,0.24658,0.15836,0.118,0.12974,0.1297,0.2436,0.15921,0.11689,0.12957,0.13035,0.24284,0.15887,0.11688,0.128,0.12994,0.24074,0.15969,0.11544,0.12755,0.12923,0.23921,0.16043,0.11498,0.12762,0.12918,0.23774,0.16127,0.11549,0.12679,0.12955,0.23631,0.16097,0.11402,0.12649,0.12903,0.23587,0.16243,0.11544,0.12609,0.12728,0.23415,0.16316,0.11369,0.12586,0.12844,0.23344,0.16284,0.11446,0.12474,0.12797,0.23292,0.16376,0.11463,0.12581,0.12733,0.23023,0.16516,0.11396,0.12589,0.12658,0.22931,0.1654,0.11343,0.12535,0.12781,0.22867,0.16659,0.11267,0.12438,0.12614,0.22827,0.16721,0.11264,0.12509,0.12668,0.22656,0.16827,0.11341,0.12482,0.12732,0.22582,0.16915,0.11226,0.12516,0.12677,0.22562,0.16896,0.11194,0.12363,0.12621,0.22316,0.17031,0.11241,0.12591:1
-2.7333E-6,6.65E-6,-2.3233E-6,2.8033E-6,-8.2667E-7,5.0333E-7,7.5267E-6,-6.7333E-7,8.0E-6,-6.1333E-7,1.4E-7,6.8967E-6,-3.3733E-6,6.7967E-6,1.4667E-6,-1.2033E-6,6.3167E-6,-1.47E-6,3.7667E-6,1.46E-6,1.8067E-6,2.44E-6,-6.37E-6,7.6133E-6,-1.2333E-7,-2.0367E-6,5.08E-6,-6.83E-6,4.3767E-6,-2.0E-8,-2.7167E-6,6.3233E-6,-1.8267E-6,4.5367E-6,3.52E-6,-4.9167E-6,8.1367E-6,-3.53E-6,6.35E-6,4.9733E-6,-4.4533E-6,6.78E-6,-3.16E-6,7.1233E-6,9.0829E-4,6.1984E-4,3.5279E-4,4.5384E-4,5.2185E-4,7.8525E-4,4.9381E-4,4.3473E-4,4.9932E-4,7.0457E-4,9.233E-4,6.2072E-4,5.6254E-4,6.4053E-4,9.4655E-4,0.0011182,8.0166E-4,6.8703E-4,7.3351E-4,0.00106,0.0011509,7.966E-4,6.9515E-4,7.499E-4,0.0010898,0.0011649,8.0108E-4,6.8819E-4,6.7803E-4,7.4358E-4,7.6083E-4,3.6797E-4,3.3282E-4,3.4994E-4,4.0293E-4,6.795E-4,3.5282E-4,3.2269E-4,3.4274E-4,3.9882E-4,6.7104E-4,3.4591E-4,3.1896E-4,3.3983E-4,3.9899E-4,6.6425E-4,3.4257E-4,3.2377E-4,3.3843E-4,4.0208E-4,6.5542E-4,3.4033E-4,3.1999E-4,3.3954E-4,4.0453E-4,6.4956E-4,3.4531E-4,3.2219E-4,3.353E-4,4.0931E-4,6.4474E-4,3.3854E-4,3.1622E-4,3.3125E-4,4.0849E-4,6.3782E-4,3.3541E-4,3.1636E-4,3.3234E-4,4.1607E-4,6.2926E-4,3.3433E-4,3.1368E-4,3.3546E-4,4.1565E-4,6.3321E-4,3.3163E-4,3.1717E-4,3.3474E-4,4.2104E-4,6.2813E-4,3.2593E-4,3.1181E-4,3.3029E-4,4.21E-4,6.274E-4,3.2739E-4,3.117E-4,3.3464E-4,4.2622E-4,6.1769E-4,3.2512E-4,3.1357E-4,3.313E-4,4.3196E-4,6.1396E-4,3.2833E-4,3.1508E-4,3.3493E-4,4.3369E-4,6.1015E-4,3.2833E-4,3.1808E-4,3.3481E-4,4.3748E-4,6.0598E-4,3.2406E-4,3.1312E-4,3.3527E-4,4.3886E-4,5.9958E-4,3.2602E-4,3.1469E-4,3.3141E-4,4.459E-4,5.9923E-4,3.198E-4,3.1373E-4,3.3004E-4,4.466E-4,5.9743E-4,3.2056E-4,3.1332E-4,3.2686E-4,4.5208E-4,5.9219E-4,3.1668E-4,3.1084E-4,3.3139E-4,4.4559E-4,5.8588E-4,3.1263E-4,3.1111E-4,3.2513E-4,4.4603E-4,5.7787E-4,3.1582E-4,3.1011E-4,3.2423E-4,4.4684E-4,5.8005E-4,3.1046E-4,3.1334E-4,3.2457E-4,4.5135E-4,5.7452E-4,3.1087E-4,3.1058E-4,3.2761E-4,4.5268E-4,5.7486E-4,3.0893E-4,3.1091E-4,3.28E-4,4.5974E-4,5.6461E-4,3.077E-4,3.098E-4,3.3191E-4,4.6068E-4,5.6416E-4,3.0898E-4,3.114E-4,3.2588E-4,4.6081E-4,5.6392E-4,3.1192E-4,3.1114E-4,3.2564E-4,4.635E-4,5.5799E-4,3.0847E-4,3.1295E-4,3.2613E-4,4.6964E-4,5.5813E-4,3.037E-4,3.1081E-4,3.2049E-4,4.7342E-4,5.4984E-4,3.0179E-4,3.0976E-4,3.2328E-4,4.7274E-4,5.5668E-4,3.0303E-4,3.1171E-4,3.251E-4,4.7921E-4,5.4887E-4,3.0457E-4,3.1173E-4,3.2413E-4,4.7841E-4,5.4766E-4,3.0221E-4,3.0869E-4,3.2525E-4,4.8477E-4,5.4828E-4,3.0577E-4,3.1686E-4,3.2133E-4,4.8483E-4,5.3595E-4,2.9572E-4,3.0626E-4,3.2296E-4,4.8552E-4,5.3964E-4,2.9955E-4,3.1482E-4,3.2358E-4,4.9132E-4,5.3251E-4,3.0093E-4,3.1072E-4,3.3044E-4,4.9441E-4,5.314E-4,2.9849E-4,3.1044E-4,3.218E-4,4.9494E-4,5.3496E-4,2.9694E-4,3.1054E-4,3.2527E-4,5.0004E-4,5.2768E-4,3.0046E-4,3.1079E-4,3.2125E-4,5.0367E-4,5.213E-4,2.9938E-4,3.156E-4,3.2181E-4,5.0532E-4,5.2375E-4,2.9209E-4,3.1156E-4,3.2543E-4,5.0631E-4,5.1747E-4,2.9193E-4,3.1064E-4,3.2277E-4,5.1013E-4,5.1209E-4,2.9502E-4,3.1251E-4,3.2396E-4,5.1312E-4,5.1124E-4,2.9472E-4,3.1174E-4,3.2519E-4,5.1895E-4,5.0739E-4,2.9569E-4,3.1181E-4,3.2354E-4,5.2164E-4,5.0894E-4,2.9423E-4,3.1495E-4,3.2371E-4,5.2211E-4,5.0373E-4,2.9405E-4,3.1595E-4,3.251E-4,5.2345E-4,5.0375E-4,2.9133E-4,3.1348E-4,3.2393E-4,5.2884E-4,5.0267E-4,2.9484E-4,3.155E-4,3.2484E-4,5.2529E-4,4.9782E-4,2.8969E-4,3.145E-4,3.2735E-4,5.3388E-4,4.9632E-4,2.9104E-4,3.1554E-4,3.222E-4,5.3439E-4,4.9331E-4,2.8972E-4,3.1318E-4,3.2788E-4,5.3383E-4,4.9174E-4,2.8838E-4,3.1397E-4,3.2096E-4,5.341E-4,4.9085E-4,2.8567E-4,3.1297E-4,3.2084E-4,5.3692E-4,4.8154E-4,2.8577E-4,3.5906E-4:1
-5.93E-6,8.76E-6,2.5033E-6,-3.2333E-6,5.6167E-6,-5.2967E-6,2.7633E-6,-2.1E-6,-1.1233E-6,4.9867E-6,-2.5267E-6,3.42E-6,1.5967E-6,3.9733E-6,1.85E-6,-1.1133E-5,5.6867E-6,5.47E-6,2.2433E-6,3.91E-6,-3.71E-6,5.8533E-6,-2.5467E-6,-8.9E-7,1.0733E-6,-8.12E-6,8.0567E-6,-1.48E-6,1.2067E-6,1.8567E-6,-6.2767E-6,6.94E-6,-3.4167E-6,2.5433E-6,5.2033E-6,-1.43E-6,4.3067E-6,-4.74E-6,8.7E-7,2.1067E-6,-1.9367E-6,5.61E-6,-3.8667E-6,-6.4033E-6,0.0010428,9.4559E-4,8.4724E-4,0.0012777,9.1017E-4,6.8037E-4,7.5888E-4,9.3832E-4,0.0012744,9.1482E-4,6.599E-4,7.0732E-4,6.6596E-4,7.4335E-4,4.2739E-4,3.1613E-4,3.3847E-4,3.6468E-4,6.6583E-4,4.1756E-4,3.1171E-4,3.3291E-4,3.6447E-4,6.5979E-4,4.1018E-4,3.1005E-4,3.308E-4,3.6176E-4,6.5797E-4,4.0758E-4,3.0936E-4,3.337E-4,3.6383E-4,6.5839E-4,3.9792E-4,3.0693E-4,3.3044E-4,3.5863E-4,6.5662E-4,4.0634E-4,3.0726E-4,3.3165E-4,3.5535E-4,6.5576E-4,3.9955E-4,3.0487E-4,3.2915E-4,3.5674E-4,6.525E-4,4.0292E-4,3.0369E-4,3.3349E-4,3.5756E-4,6.6609E-4,3.9618E-4,3.0741E-4,3.249E-4,3.5768E-4,6.6043E-4,3.9653E-4,3.0981E-4,3.2709E-4,3.5771E-4,6.5475E-4,3.9216E-4,3.0869E-4,3.309E-4,3.5423E-4,6.6139E-4,3.9606E-4,3.0846E-4,3.279E-4,3.5354E-4,6.6202E-4,3.8737E-4,3.1264E-4,3.2779E-4,3.5342E-4,6.6008E-4,3.9056E-4,3.0502E-4,3.295E-4,3.555E-4,6.6016E-4,3.8817E-4,3.0741E-4,3.3139E-4,3.535E-4,6.6285E-4,3.8694E-4,3.053E-4,3.2811E-4,3.5617E-4,6.6256E-4,3.8624E-4,3.0873E-4,3.3158E-4,3.5307E-4,6.6622E-4,3.8648E-4,3.0656E-4,3.3235E-4,3.5741E-4,6.6566E-4,3.8358E-4,3.0604E-4,3.3148E-4,3.5403E-4,6.5807E-4,3.7922E-4,3.0809E-4,3.2695E-4,3.5699E-4,6.6496E-4,3.7906E-4,3.0525E-4,3.3205E-4,3.5257E-4,6.6402E-4,3.7884E-4,3.0374E-4,3.3088E-4,3.4946E-4,6.7111E-4,3.773E-4,3.1231E-4,3.3309E-4,3.4925E-4,6.681E-4,3.7603E-4,3.013E-4,3.3142E-4,3.5549E-4,6.7031E-4,3.7316E-4,3.0616E-4,3.3174E-4,3.5239E-4,6.7146E-4,3.7612E-4,3.036E-4,3.3087E-4,3.4588E-4:1
-3.6367E-6,4.0567E-6,6.5833E-6,-3.98E-6,4.1167E-6,-1.5667E-6,5.58E-6,5.6267E-6,-2.8233E-6,6.7267E-6,-3.8367E-6,6.1967E-6,3.2067E-6,-3.8667E-6,5.8233E-6,-4.72E-6,4.5333E-6,2.0067E-6,-2.2733E-6,6.1567E-6,-3.1833E-6,2.7467E-6,7.9E-7,-3.74E-6,5.9667E-6,1.0167E-6,-9.0E-7,6.0567E-6,-4.32E-6,5.1433E-6,-1.1967E-6,5.6933E-6,5.8567E-6,1.0133E-6,6.6433E-6,-1.0133E-6,2.86E-6,7.6733E-6,-1.9E-6,4.1167E-6,-8.4E-7,2.94E-6,1.8067E-6,0.0017784,7.5521E-4,8.1946E-4,0.0014129,0.0010494,7.7062E-4,7.9925E-4,8.2878E-4,0.0014427,0.0010737,7.7898E-4,8.0454E-4,8.3467E-4,0.001463,0.0010603,6.7062E-4,5.68E-4,4.6003E-4,6.9214E-4,5.8317E-4,3.7826E-4,4.0152E-4,4.1033E-4,6.8153E-4,5.5587E-4,3.7132E-4,3.9428E-4,3.9735E-4,6.686E-4,5.6205E-4,3.6182E-4,3.9439E-4,3.9145E-4,6.647E-4,5.5868E-4,3.602E-4,3.8734E-4,3.9027E-4,6.5897E-4,5.4808E-4,3.5686E-4,3.7895E-4,3.9329E-4,6.5794E-4,5.3629E-4,3.4935E-4,3.8094E-4,3.8774E-4,6.4913E-4,5.3713E-4,3.4601E-4,3.7555E-4,3.8364E-4,6.5477E-4,5.3168E-4,3.4493E-4,3.7754E-4,3.816E-4,6.5458E-4,5.3325E-4,3.3992E-4,3.7575E-4,3.8065E-4,6.5659E-4,5.1857E-4,3.4196E-4,3.7505E-4,3.756E-4,6.5489E-4,5.2818E-4,3.4015E-4,3.7368E-4,3.67E-4,6.4833E-4,5.2066E-4,3.3239E-4,3.7268E-4,3.7416E-4,6.3435E-4,5.237E-4,3.3616E-4,3.7298E-4,3.7271E-4,6.4714E-4,5.2245E-4,3.3509E-4,3.6978E-4,3.7261E-4,6.4942E-4,5.138E-4,3.3165E-4,3.7081E-4,3.7049E-4,6.5194E-4,5.1003E-4,3.3455E-4,3.6788E-4,3.7028E-4,6.4154E-4,5.0996E-4,3.2997E-4,3.654E-4,3.6806E-4,6.4221E-4,5.055E-4,3.2674E-4,3.6188E-4,3.659E-4,6.3854E-4,5.1366E-4,3.2599E-4,3.5981E-4,3.6903E-4,6.4575E-4,5.0322E-4,3.2541E-4,3.6197E-4:1
1.359E-5,-1.0167E-6,5.5833E-6,2.6567E-6,-4.6033E-6,1.2027E-5,-8.8333E-7,3.09E-6,9.27E-6,-3.51E-6,1.5307E-5,-4.7333E-6,4.2433E-6,3.22E-6,-4.1133E-6,8.7733E-6,-5.2467E-6,6.26E-6,9.1233E-6,-7.1367E-6,6.6367E-6,-8.0033E-6,4.0967E-6,1.0337E-5,-4.7067E-6,7.8867E-6,-7.3533E-6,-2.0333E-7,5.83E-6,-6.83E-6,8.0733E-6,-2.2367E-6,3.7467E-6,7.77E-6,-7.0433E-6,1.077E-5,-1.6233E-6,9.5333E-6,6.03E-6,-8.5667E-6,9.7567E-6,-8.6733E-6,4.2E-6,9.2033E-6,-5.33E-6,1.1867E-5,-8.1467E-6,-2.1167E-6,6.72E-6,-7.2E-6,1.062E-5,-5.5867E-6,9.8E-7,8.3233E-6,-6.6667E-6,1.099E-5,-3.11E-6,5.0E-6,7.9533E-6,-6.82E-6,1.1243E-5,3.01E-6,3.5067E-6,5.22E-6,-1.95E-6,1.3017E-5,-4.7067E-6,2.4533E-6,7.1767E-6,-6.74E-6,1.1057E-5,-6.9E-6,8.2733E-6,3.3567E-6,-5.8333E-6,1.007E-5,-2.6433E-6,7.6533E-6,7.0933E-6,-1.051E-5,7.6233E-6,2.9767E-6,6.88E-6,9.0367E-6,-3.98E-6,1.0633E-5,-5.8E-6,5.9967E-6,4.4233E-6,-2.0067E-6,0.0010454,0.0015265,0.0014553,8.9492E-4,7.614E-4,7.785E-4,6.0411E-4,9.0554E-4,5.3734E-4,4.4848E-4,4.8222E-4,5.1753E-4,8.9743E-4,5.2709E-4,4.3566E-4,4.7809E-4,5.1025E-4,8.927E-4,5.136E-4,4.3051E-4,4.7454E-4,4.9781E-4,8.8372E-4,5.0762E-4,4.2771E-4,4.6957E-4,4.8334E-4,8.8033E-4,5.0405E-4,4.1496E-4,4.6513E-4,4.8125E-4,8.7652E-4,5.0315E-4,4.1728E-4,4.6415E-4,4.7244E-4,8.802E-4,4.9404E-4,4.1385E-4,4.6019E-4,4.7166E-4,8.7903E-4,4.9914E-4,4.1176E-4,4.6049E-4,4.6698E-4,8.7412E-4,4.8904E-4,4.0771E-4,4.5773E-4,4.6437E-4,8.7474E-4,4.9475E-4,4.0508E-4,4.5386E-4,4.612E-4,8.7585E-4,4.9183E-4,4.1177E-4,4.53E-4,4.6196E-4,8.7568E-4,4.9675E-4,4.0721E-4,4.5438E-4,4.5764E-4,8.7118E-4,4.9282E-4,4.0212E-4,4.5277E-4,4.5192E-4,8.7295E-4,4.9009E-4,3.9644E-4,4.5354E-4,4.4974E-4,8.7075E-4,4.8814E-4,3.9676E-4,4.5013E-4,4.4745E-4,8.6954E-4,4.9452E-4,3.936E-4,4.4813E-4,4.4508E-4,8.6946E-4,4.9585E-4,3.9841E-4,4.4716E-4,4.4324E-4,8.6405E-4,4.9193E-4,3.952E-4,4.4467E-4,4.481E-4,8.7055E-4,4.8405E-4,3.9537E-4,4.4908E-4,4.4462E-4,8.637E-4,4.8847E-4,4.0006E-4,4.4155E-4,4.3822E-4,8.6352E-4,4.91E-4,3.887E-4:1
1.2583E-5,-3.7633E-6,1.186E-5,-1.037E-5,7.3233E-6,3.0933E-6,7.5E-7,1.137E-5,-1.3177E-5,8.12E-6,5.8267E-6,-6.2567E-6,8.9167E-6,-1.114E-5,1.247E-5,7.03E-6,-9.7667E-7,1.5273E-5,-1.0463E-5,8.2967E-6,4.8533E-6,-4.6133E-6,1.6827E-5,-7.7533E-6,1.1397E-5,4.0267E-6,-4.5233E-6,1.1923E-5,-3.1167E-6,6.9767E-6,6.2033E-6,-6.8033E-6,1.132E-5,-3.8767E-6,1.1747E-5,7.0467E-6,-1.0543E-5,1.225E-5,-2.9633E-6,1.126E-5,6.52E-6,-7.44E-6,1.118E-5,-2.5067E-6,6.1667E-6,1.6233E-6,-1.1407E-5,1.264E-5,-9.25E-6,1.04E-5,2.89E-6,-6.5333E-6,1.704E-5,-6.0067E-6,8.3033E-6,8.59E-6,-5.4767E-6,1.5077E-5,-1.3893E-5,1.0227E-5,-9.3667E-7,-2.9833E-6,1.3387E-5,-6.3E-6,1.364E-5,1.2923E-5,-8.7267E-6,1.372E-5,-9.3233E-6,1.0437E-5,6.6333E-7,-2.79E-6,1.3813E-5,9.1E-7,7.24E-6,6.3333E-6,-1.2407E-5,1.584E-5,-6.8167E-6,1.471E-5,4.1533E-6,7.7333E-7,1.394E-5,-1.14E-5,4.56E-6,8.6367E-6,-6.9167E-6,1.5133E-5,-7.0E-7,1.0447E-5,3.9367E-6,-1.589E-5,1.1463E-5,-5.6033E-6,9.99E-6,3.1067E-6,-8.4667E-6,1.143E-5,0.001134,0.0024908,0.0018088,0.0013355,0.0010999,6.9317E-4,0.0011825,8.2371E-4,5.4238E-4,6.1808E-4,6.2696E-4,0.0011482,8.2433E-4,5.3622E-4,6.125E-4,6.1772E-4,0.0011395,8.1593E-4,5.266E-4,6.1164E-4,6.1268E-4,0.0011413,8.1079E-4,5.3077E-4,6.0589E-4,6.0712E-4,0.0011285,8.2645E-4,5.3215E-4,6.0314E-4,6.1569E-4,0.0011254,8.2795E-4,5.1754E-4,6.0765E-4,6.096E-4,0.001123,8.197E-4,5.2262E-4,6.0881E-4,6.0431E-4,0.0011239,8.1698E-4,5.2448E-4,6.0769E-4,6.1002E-4,0.001122,8.2366E-4,5.2856E-4,6.0446E-4,6.1216E-4,0.0011211,8.2554E-4,5.1852E-4,6.0686E-4,6.1054E-4,0.0011154,8.2629E-4,5.2433E-4,6.0568E-4,6.1298E-4,0.0011225,8.1997E-4,5.2347E-4,6.1074E-4,6.1198E-4,0.0011144,8.351E-4,5.322E-4,6.0709E-4,6.0906E-4,0.0011156,8.3173E-4,5.2967E-4,6.0385E-4,6.0649E-4,0.0011201,8.2744E-4,5.2533E-4,6.1305E-4,6.1039E-4,0.0011249,8.244E-4,5.2775E-4,6.1125E-4,6.0544E-4,0.0011203,8.2364E-4,5.284E-4,6.0194E-4,6.1584E-4,0.0011165,8.2795E-4,5.3625E-4,6.0364E-4,6.1183E-4,0.0011081,8.3003E-4,5.2378E-4,6.0424E-4,6.143E-4,0.0011134,8.3388E-4,5.2773E-4,6.0719E-4,6.1752E-4,0.0011174,8.3668E-4,5.2461E-4,6.0679E-4,6.1332E-4,0.0011137,8.3268E-4,5.2772E-4,6.1428E-4,6.1095E-4,0.0011091,8.287E-4,5.248E-4,6.0853E-4,6.1084E-4,0.0011112,8.3157E-4,5.2591E-4,6.0668E-4,6.1235E-4,0.0011105,8.2306E-4,5.2377E-4,5.9967E-4,6.1084E-4,0.0011078,8.283E-4,5.1993E-4,6.0302E-4,6.0571E-4,0.0011006,8.4005E-4,5.2628E-4,6.0205E-4,6.1182E-4,0.0010998,8.3297E-4,5.3174E-4,6.0425E-4,6.0588E-4,0.0010989,8.4565E-4,5.3033E-4,6.0493E-4,6.1105E-4,0.0011073,8.3623E-4,5.3516E-4,6.0548E-4,6.1349E-4,0.0010988,8.4117E-4,5.2791E-4,6.0972E-4,6.0887E-4,0.0011025,8.3661E-4,5.2179E-4,6.0524E-4,6.0874E-4,0.001103,8.4681E-4,5.2665E-4,5.9707E-4,6.1196E-4,0.0010927,8.3668E-4,5.2342E-4,6.0915E-4,6.1E-4,0.0010965,8.482E-4,5.3057E-4,5.9986E-4,6.0953E-4,0.0011039,8.4322E-4,5.3496E-4,6.0546E-4,6.0828E-4,0.0010957,8.4655E-4,5.2959E-4,6.0529E-4,6.1298E-4,0.0010903,8.4073E-4,5.2557E-4,6.0094E-4,6.1663E-4,0.0010985,8.5012E-4,5.325E-4,6.1247E-4,6.1902E-4,0.0010965,8.4298E-4,5.2722E-4,6.1524E-4,6.1057E-4,0.0010972,8.3792E-4,5.2845E-4,6.1173E-4,6.0649E-4,0.0010953,8.4074E-4,5.2955E-4,6.0203E-4,6.1134E-4,0.0010858,8.3703E-4,5.3188E-4,6.0424E-4,6.1509E-4,0.0010959,8.4511E-4,5.259E-4,5.9767E-4,6.1127E-4,0.0010825,8.4694E-4,5.3093E-4,6.0459E-4,6.1008E-4,0.0010958,8.422E-4,5.3412E-4,6.0425E-4,5.9932E-4,0.0010891,8.4648E-4,5.3739E-4,5.9861E-4,6.1116E-4,0.0010871,8.4883E-4,5.3029E-4,6.0636E-4,6.0408E-4,0.0010827,8.5204E-4,5.2698E-4,6.0258E-4,6.0577E-4,0.0010835,8.4482E-4,5.3425E-4,6.0222E-4,6.0023E-4,0.0010851,8.4918E-4,5.3359E-4,6.0491E-4,6.0648E-4,0.0010941,8.4807E-4,5.3511E-4,6.0092E-4,6.1026E-4,0.001089,8.4713E-4,5.3183E-4,5.9889E-4,6.1083E-4,0.0010837,8.5331E-4,5.3583E-4,5.9768E-4,6.0924E-4,0.0010732,8.5035E-4,5.3203E-4,5.9699E-4,6.1196E-4,0.0010809,8.5133E-4,5.3001E-4,5.9528E-4,6.0231E-4,0.001069,8.575E-4,5.2998E-4,6.0191E-4,6.0391E-4,0.0010817,8.513E-4,5.3089E-4,5.9826E-4,6.0223E-4,0.0010823,8.5459E-4,5.3346E-4,5.9996E-4,6.133E-4,0.0010784,8.5321E-4,5.3217E-4,6.0258E-4,6.0604E-4,0.0010842,8.4874E-4,5.3593E-4,6.0055E-4,6.0689E-4,0.0010866,8.4014E-4,5.3503E-4,5.9303E-4,6.0243E-4,0.0010787,8.5196E-4,5.2625E-4,5.9216E-4,6.0855E-4,0.001055,8.7282E-4,5.2482E-4,5.9862E-4,6.0431E-4,0.0010581,8.7039E-4,5.3089E-4,5.9716E-4,6.0932E-4,0.0010781,8.5482E-4,5.3082E-4,6.0134E-4,6.0465E-4,0.0010626,8.569E-4,5.304E-4,5.9401E-4,5.968E-4,0.0010704,8.5456E-4,5.3116E-4,5.97E-4,6.0629E-4,0.0010649,8.6358E-4,5.3347E-4,5.9759E-4,6.1219E-4,0.001069,8.5578E-4,5.3935E-4,6.0001E-4,4.5732E-4:1
6.4467E-6,-4.2833E-6,1.351E-5,-2.06E-6,8.86E-6,1.0607E-5,-8.2733E-6,1.6943E-5,-5.1067E-6,4.1667E-6,1.538E-5,-8.4467E-6,1.4763E-5,-1.2773E-5,5.2033E-6,8.8333E-6,-6.3367E-6,1.412E-5,-8.7233E-6,4.3967E-6,1.1433E-5,-9.1833E-6,1.0047E-5,-5.84E-6,5.2233E-6,9.5667E-6,-1.243E-5,1.765E-5,-6.37E-6,1.0747E-5,1.1083E-5,-1.229E-5,1.56E-5,-9.1267E-6,8.6833E-6,8.01E-6,-1.2493E-5,9.5567E-6,-3.65E-6,1.46E-6,1.396E-5,-1.489E-5,1.53E-5,-6.26E-6,1.3087E-5,7.65E-6,-9.9833E-6,1.1923E-5,-3.9E-6,5.81E-6,9.7667E-7,-8.1333E-6,1.262E-5,-5.89E-6,6.2633E-6,2.55E-6,-6.3433E-6,1.0033E-5,-3.2333E-7,1.7467E-6,6.6433E-6,-8.57E-6,1.398E-5,-1.8967E-6,-2.31E-6,5.1333E-6,-4.9733E-6,1.4027E-5,-2.1233E-6,2.98E-6,1.0707E-5,-6.7367E-6,1.228E-5,-1.036E-5,8.4E-6,1.5067E-5,-8.9267E-6,1.199E-5,-5.3867E-6,3.3533E-6,1.5247E-5,-1.1403E-5,7.8067E-6,-6.1333E-6,4.5867E-6,3.0633E-6,-6.55E-6,1.245E-5,0.0011003,0.0018109,0.0017221,0.0012394,0.0011307,0.0015526,0.0011243,6.4499E-4,5.99E-4,6.7455E-4,9.0016E-4,0.0010649,6.253E-4,5.7965E-4,6.5494E-4,8.826E-4,0.0010563,6.1526E-4,5.7351E-4,6.4522E-4,8.7236E-4,0.0010563,6.1697E-4,5.7551E-4,6.4471E-4,8.7098E-4,0.0010613,6.1019E-4,5.7832E-4,6.3905E-4,8.6911E-4,0.0010636,6.0291E-4,5.7415E-4,6.3922E-4,8.7291E-4,0.001053,6.0009E-4,5.739E-4,6.349E-4,8.6756E-4,0.0010453,5.9157E-4,5.6196E-4,6.3496E-4,8.6795E-4,0.0010421,5.9513E-4,5.6469E-4,6.3218E-4,8.6203E-4,0.0010414,5.9117E-4,5.6752E-4,6.3666E-4,8.6742E-4,0.0010398,5.8987E-4,5.6541E-4,6.2953E-4,8.6335E-4,0.0010498,5.9473E-4,5.6189E-4,6.3301E-4,8.5973E-4,0.0010437,5.8798E-4,5.6402E-4,6.3252E-4,8.6123E-4,0.0010416,5.841E-4,5.6431E-4,6.3109E-4,8.6153E-4,0.00104,5.9405E-4,5.6652E-4,6.3491E-4,8.6262E-4,0.001044,5.8231E-4,5.64E-4,6.3617E-4,8.6913E-4,0.0010458,5.847E-4,5.6172E-4,6.2853E-4,8.7162E-4,0.0010402,5.9327E-4,5.6504E-4,6.3689E-4,8.5287E-4,0.0010362,5.9199E-4,5.6241E-4,6.2852E-4,8.6002E-4,0.0010421,5.8403E-4,5.6097E-4,6.345E-4,8.5975E-4,0.0010369,5.849E-4,5.6249E-4,6.2887E-4,8.5189E-4,0.0010398:1
4.5667E-7,-3.3333E-9,4.3667E-7,6.8E-7,1.35E-6,1.07E-6,6.6667E-8,6.3667E-7,-3.6E-7,1.71E-6,8.4E-7,-2.2333E-7,1.09E-6,9.3333E-8,1.56E-6,1.2133E-6,5.7333E-7,1.8833E-6,2.9E-7,1.5167E-6,1.8733E-6,-7.9333E-7,1.2333E-6,3.4667E-7,4.8333E-7,1.19E-6,4.0E-8,5.7E-7,3.0667E-7,7.9E-7,4.9667E-7,2.4333E-7,1.0733E-6,-9.4333E-7,6.9858E-4,3.8321E-4,2.2532E-4,1.9804E-4,2.1496E-4,3.697E-4,2.3E-4,1.9197E-4,1.8937E-4,2.0654E-4,3.6469E-4,2.2383E-4,1.8921E-4,1.8726E-4,2.0432E-4,3.625E-4,2.2258E-4,1.8576E-4,1.8707E-4,2.0292E-4,3.6275E-4,2.1995E-4,1.8545E-4,1.8568E-4,2.0107E-4,3.6284E-4,2.1754E-4,1.852E-4,1.845E-4,2.0119E-4,3.6248E-4,2.1415E-4,1.8389E-4,1.8378E-4,2.008E-4,3.6046E-4,2.1282E-4,1.8229E-4,1.8243E-4,1.9873E-4,3.6023E-4,2.1064E-4,1.8244E-4,1.8109E-4,1.9815E-4,3.6076E-4,2.0933E-4,1.8339E-4,1.8105E-4,1.9792E-4,3.6074E-4,2.0784E-4,1.8127E-4,1.8206E-4,1.9668E-4,3.5937E-4,2.0689E-4,1.8096E-4,1.8251E-4,1.9779E-4,3.6147E-4,2.0379E-4,1.8197E-4,1.8194E-4,1.9686E-4,3.6035E-4,2.0293E-4,1.8117E-4,1.8079E-4,1.9517E-4,3.5988E-4,2.0187E-4,1.8059E-4,1.8023E-4,1.9523E-4,3.6081E-4,2.0117E-4,1.7945E-4,1.8028E-4,1.9487E-4,3.6169E-4,1.9871E-4,1.8085E-4,1.8047E-4,1.9761E-4,3.6113E-4,1.9653E-4,1.8047E-4,1.8082E-4,1.9583E-4,3.5883E-4,1.9476E-4,1.8058E-4,1.806E-4,1.9424E-4,3.6125E-4,1.9795E-4,1.7931E-4,1.7945E-4,1.9496E-4,3.6133E-4,1.9202E-4,1.7978E-4,1.7975E-4,1.9782E-4,3.5897E-4,1.9302E-4,1.7855E-4,1.7877E-4,1.9968E-4,3.5627E-4,1.922E-4,1.7893E-4,1.7913E-4,1.9896E-4,3.5541E-4,1.9072E-4,1.793E-4,1.7849E-4,2.0138E-4,3.5295E-4,1.8904E-4,1.7932E-4,1.8036E-4,2.0282E-4,3.5239E-4,1.8787E-4,1.7862E-4,1.7863E-4,2.0549E-4,3.5054E-4,1.8748E-4,1.7915E-4,1.7851E-4,2.0927E-4,3.4967E-4,1.8663E-4,1.7797E-4,1.7893E-4,2.0982E-4,3.4798E-4,1.8541E-4,1.8025E-4,1.794E-4,2.1173E-4,3.4623E-4,1.8382E-4,1.791E-4,1.7828E-4,2.1461E-4,3.4228E-4,1.8442E-4,1.7935E-4,1.784E-4,2.1716E-4,3.4164E-4,1.8365E-4,1.7829E-4,1.7908E-4,2.2134E-4,3.3743E-4,1.8251E-4,1.7996E-4,1.7839E-4,2.2101E-4,3.368E-4,1.7929E-4,1.8044E-4,1.7822E-4,2.2409E-4,3.3435E-4,1.7898E-4,1.804E-4,1.7802E-4,2.2704E-4,3.3339E-4,1.7967E-4,1.7967E-4,1.7896E-4,2.2895E-4,3.2847E-4,1.7894E-4,1.7909E-4,1.7749E-4,2.3203E-4,3.2663E-4,1.775E-4,1.78E-4,1.7707E-4,2.3406E-4,3.2608E-4,1.7759E-4,1.7904E-4,1.7748E-4,2.3515E-4,3.2454E-4,1.763E-4,1.7892E-4,1.7808E-4,2.3768E-4,3.2371E-4,1.7308E-4,1.7923E-4,1.7746E-4,2.3902E-4,3.194E-4,1.7482E-4,1.796E-4,1.7725E-4,2.4191E-4,3.156E-4,1.727E-4,1.7853E-4,1.7759E-4,2.4426E-4,3.1324E-4,1.7352E-4,1.78E-4,1.7746E-4,2.471E-4,3.1379E-4,1.7111E-4,1.8025E-4,1.776E-4,2.5033E-4,3.1193E-4,1.7029E-4,1.8042E-4,1.7757E-4,2.5091E-4,3.0715E-4,1.7038E-4,1.7947E-4,1.7882E-4,2.5385E-4,3.0574E-4,1.7004E-4,1.7913E-4,1.7798E-4,2.568E-4,3.0428E-4,1.6896E-4,1.7839E-4,1.7855E-4,2.5726E-4,2.9977E-4,1.6844E-4,1.7855E-4,1.7819E-4,2.6213E-4,2.9894E-4,1.688E-4,1.8078E-4,1.7878E-4,2.6468E-4,2.9487E-4,1.6758E-4,1.7975E-4,1.7781E-4,2.6796E-4,2.9274E-4,1.6617E-4,1.7931E-4,1.7701E-4,2.6972E-4,2.9144E-4,1.6566E-4,1.7998E-4,1.7848E-4,2.729E-4,2.8993E-4,1.652E-4,1.8028E-4,1.7772E-4,2.7536E-4,2.8752E-4,1.6473E-4,1.7976E-4,1.7824E-4,2.7811E-4,2.8342E-4,1.6389E-4,1.8057E-4,1.7763E-4,2.7912E-4,2.833E-4,1.6438E-4,1.8046E-4,1.7763E-4,2.8298E-4,2.7703E-4,1.6524E-4,1.7999E-4,1.7822E-4,2.8239E-4,2.763E-4,1.6285E-4,1.7999E-4,1.7808E-4,2.8706E-4,2.7499E-4,1.6234E-4,1.7981E-4,1.7946E-4,2.8948E-4,2.7047E-4,1.6264E-4,1.8067E-4,1.7789E-4,2.9118E-4,2.7087E-4,1.6333E-4,1.8023E-4,1.7902E-4,2.9281E-4,2.6847E-4,1.6145E-4,1.8098E-4,1.7734E-4,2.944E-4,2.6584E-4,1.6198E-4,2.0126E-4:1
1.7833E-6,8.8667E-7,2.05E-6,1.1833E-6,-2.0333E-6,1.48E-6,-3.0333E-7,6.6E-7,1.8167E-6,-1.3E-6,1.31E-6,8.2E-7,8.0667E-7,5.8E-7,3.3334E-9,8.6333E-7,6.6E-7,8.9333E-7,8.8333E-7,-7.8E-7,1.1933E-6,5.0E-8,1.89E-6,1.2567E-6,3.7333E-7,1.1533E-6,8.4667E-7,8.7E-7,1.25E-6,-2.1667E-7,1.05E-6,5.0E-8,8.6333E-7,1.9733E-6,-1.9E-7,1.0333E-6,6.4E-7,2.6667E-7,1.4067E-6,-1.0E-8,1.41E-6,3.2333E-7,1.2167E-6,1.4133E-6,4.3333E-7,1.8367E-6,3.9333E-7,6.2333E-7,8.7333E-7,4.2E-7,1.1567E-6,-3.8E-7,1.3767E-6,8.7667E-7,-4.1E-7,1.3933E-6,1.01E-6,3.9E-7,1.48E-6,1.3933E-6,6.8333E-7,-1.4633E-6,8.6E-7,1.9333E-6,-4.7667E-7,5.2E-7,2.8208E-4,3.5732E-4,2.4591E-4,2.3028E-4,1.8696E-4,3.2903E-4,2.8313E-4,1.7268E-4,1.9354E-4,1.9015E-4,3.2089E-4,2.8118E-4,1.7092E-4,1.8881E-4,1.9006E-4,3.1168E-4,2.7791E-4,1.6992E-4,1.857E-4,1.8521E-4,3.0897E-4,2.7595E-4,1.6694E-4,1.8574E-4,1.8674E-4,3.0864E-4,2.7716E-4,1.6803E-4,1.8639E-4,1.8576E-4,3.0862E-4,2.7665E-4,1.6885E-4,1.8422E-4,1.8637E-4,3.0874E-4,2.7513E-4,1.6565E-4,1.8516E-4,1.8694E-4,3.0886E-4,2.7528E-4,1.6849E-4,1.8512E-4,1.8349E-4,3.0756E-4,2.7404E-4,1.6833E-4,1.8659E-4,1.8486E-4,3.0983E-4,2.7517E-4,1.696E-4,1.8578E-4,1.8607E-4,3.0673E-4,2.7644E-4,1.6666E-4,1.856E-4,1.8351E-4,3.0685E-4,2.7407E-4,1.6608E-4,1.8576E-4,1.8431E-4,3.0964E-4,2.7422E-4,1.6825E-4,1.8382E-4,1.8533E-4,3.087E-4,2.7506E-4,1.6689E-4,1.8417E-4,1.8489E-4,3.0635E-4,2.7324E-4,1.658E-4,1.8521E-4,1.8475E-4,3.0746E-4,2.747E-4,1.6811E-4,1.8444E-4,1.8576E-4,3.0742E-4,2.7447E-4,1.6678E-4,1.8478E-4,1.8336E-4,3.0824E-4,2.7237E-4,1.6586E-4,1.8328E-4,1.8305E-4,3.0699E-4,2.7328E-4,1.659E-4,1.8417E-4,1.8369E-4,3.0662E-4,2.733E-4,1.6642E-4,1.8396E-4,1.8332E-4,3.0536E-4,2.7423E-4,1.6745E-4,1.8603E-4,1.8372E-4,3.0683E-4,2.7245E-4,1.6628E-4,1.8504E-4,1.8357E-4,3.0611E-4,2.7174E-4,1.6656E-4,1.8439E-4,1.8259E-4,3.0561E-4,2.731E-4,1.6638E-4,1.8305E-4,1.8372E-4,3.0477E-4,2.7241E-4,1.6638E-4,1.8384E-4,1.8353E-4,3.0531E-4,2.7435E-4,1.6519E-4,1.8557E-4,1.8251E-4,3.0583E-4,2.7362E-4,1.6678E-4,1.856E-4,1.8303E-4,3.0586E-4,2.7234E-4,1.6558E-4,1.8461E-4,1.8405E-4,3.0547E-4,2.732E-4,1.6724E-4,1.8486E-4,1.8076E-4,3.0645E-4,2.7205E-4,1.6711E-4,1.8624E-4,1.837E-4,3.0553E-4,2.7212E-4,1.6716E-4,1.8448E-4,1.8349E-4,3.0562E-4,2.7209E-4,1.6533E-4,1.8442E-4,1.8311E-4,3.0394E-4,2.7358E-4,1.6627E-4,1.84E-4,1.8299E-4,3.0518E-4,2.7257E-4,1.6509E-4,1.8412E-4,1.8345E-4,3.0433E-4,2.7375E-4,1.6746E-4,1.8337E-4,1.8274E-4,3.0521E-4,2.742E-4,1.6633E-4,1.8347E-4,1.8363E-4,3.0449E-4,2.7255E-4,1.6561E-4,1.8333E-4,1.8316E-4,3.0618E-4,2.7354E-4,1.6641E-4,1.8322E-4,1.8482E-4,3.0614E-4,2.7202E-4,1.6635E-4,1.8407E-4,1.8284E-4,3.0461E-4,2.7244E-4,1.6565E-4,1.8514E-4,1.8309E-4,3.0393E-4,2.7322E-4,1.6421E-4,1.8332E-4,1.8358E-4,3.048E-4,2.7356E-4,1.6397E-4,1.832E-4,1.8386E-4,3.0333E-4,2.7227E-4,1.6554E-4,1.8544E-4,1.8151E-4,3.0498E-4,2.7164E-4,1.6631E-4,1.8405E-4,1.8238E-4,3.0485E-4,2.7409E-4,1.6629E-4,1.8417E-4,1.8412E-4,3.0382E-4,2.729E-4,1.6543E-4,1.833E-4,1.814E-4,3.0371E-4,2.7284E-4,1.6601E-4,1.8392E-4,1.825E-4,3.0423E-4,2.7188E-4,1.6588E-4,1.8428E-4,1.8263E-4,3.0324E-4,2.7285E-4,1.6529E-4,1.8217E-4,1.8144E-4,3.0411E-4,2.7172E-4,1.6585E-4,1.8514E-4,1.8313E-4,3.047E-4,2.7351E-4,1.6575E-4,1.8556E-4,1.8286E-4,3.0499E-4,2.7247E-4,1.664E-4,1.8513E-4,1.8264E-4,3.0448E-4,2.7233E-4,1.6523E-4,1.823E-4,1.8154E-4,3.0355E-4,2.7173E-4,1.6517E-4,1.848E-4,1.8205E-4,3.0418E-4,2.7045E-4,1.6562E-4,1.8385E-4,1.83E-4,3.0434E-4,2.7185E-4,1.6624E-4,1.8432E-4,1.8291E-4,3.0498E-4,2.733E-4,1.669E-4,1.8426E-4,1.8254E-4,3.0349E-4,2.7148E-4,1.6458E-4,1.8426E-4,1.8283E-4,3.0528E-4,2.719E-4,1.6478E-4,1.845E-4,1.824E-4,3.0531E-4,2.712E-4,1.6522E-4,1.8197E-4,1.8149E-4,3.0506E-4,2.7144E-4,1.6454E-4,1.8327E-4,1.8082E-4,3.0349E-4,2.7286E-4,1.6396E-4,1.8414E-4,1.8322E-4,3.0625E-4,2.7115E-4,1.6466E-4,1.8516E-4,1.8324E-4,3.0431E-4,2.7306E-4,1.6536E-4,1.8365E-4,1.8223E-4,3.0574E-4,2.711E-4,1.6501E-4,1.8358E-4,1.8124E-4,3.0556E-4,2.7258E-4,1.6438E-4,1.8544E-4,1.8348E-4,3.0607E-4,2.7192E-4,1.6426E-4,1.8297E-4,1.8226E-4,3.054E-4,2.717E-4,1.6515E-4,1.8439E-4,1.8156E-4,3.0726E-4,2.7069E-4,1.6583E-4,1.8485E-4,1.8263E-4,3.0405E-4,2.7083E-4,1.6474E-4,1.8364E-4,1.8294E-4,3.0555E-4,2.7114E-4,1.6516E-4,1.8243E-4,1.8336E-4,3.0696E-4,2.7164E-4,1.6639E-4,1.8492E-4,1.8157E-4,3.0545E-4,2.7169E-4,1.6472E-4,1.8477E-4,1.8323E-4,3.0637E-4,2.7073E-4,1.6476E-4,1.827E-4,1.8219E-4,3.0671E-4,2.7173E-4,1.6597E-4,1.8468E-4,1.8416E-4,3.0507E-4,2.7066E-4,1.6449E-4,1.841E-4,1.8295E-4,3.059E-4,2.7248E-4,1.6495E-4,1.8408E-4,1.837E-4,3.0615E-4,2.7082E-4,1.658E-4,1.8466E-4:1
5.0667E-7,8.0E-7,1.2033E-6,8.0E-7,-1.7333E-7,9.4667E-7,1.2333E-7,3.3333E-7,1.14E-6,5.2667E-7,3.9E-7,6.5E-7,2.2667E-7,1.0833E-6,6.3333E-7,3.2333E-7,2.8667E-7,7.7667E-7,4.1333E-7,5.8815E-4,2.6463E-4,4.8443E-4,3.7229E-4,2.036E-4,2.1134E-4,2.054E-4,3.1472E-4,3.253E-4,1.9596E-4,2.0448E-4,2.0232E-4,3.0978E-4,3.2051E-4,1.9259E-4,2.0406E-4,2.0035E-4,3.0875E-4,3.1894E-4,1.9191E-4,2.0228E-4,1.9983E-4,3.06E-4,3.1973E-4,1.9081E-4,2.0092E-4,2.002E-4,3.0363E-4,3.1629E-4,1.8945E-4,2.0065E-4,1.9802E-4,3.0467E-4,3.1745E-4,1.8833E-4,2.0086E-4,1.9598E-4,3.0331E-4,3.1449E-4,1.8754E-4,1.9821E-4,1.9594E-4,3.0441E-4,3.155E-4,1.859E-4,1.9919E-4,1.9755E-4,3.021E-4,3.135E-4,1.859E-4,1.9871E-4,1.9558E-4,3.044E-4,3.1301E-4,1.8494E-4,1.9912E-4,1.9652E-4,3.028E-4,3.1153E-4,1.8694E-4,1.9609E-4,1.9576E-4,3.0123E-4,3.0961E-4,1.8555E-4,1.9681E-4,1.9513E-4,3.0342E-4,3.1205E-4,1.8583E-4,1.9749E-4,1.9699E-4,2.9933E-4,3.091E-4,1.8421E-4,1.949E-4,1.9584E-4,3.0061E-4,3.1053E-4,1.8344E-4,1.9615E-4,1.9506E-4,3.0288E-4,3.1153E-4,1.8284E-4,1.9628E-4,1.9447E-4,3.0172E-4,3.1041E-4,1.8372E-4,1.9664E-4,1.9524E-4,3.0166E-4,3.0929E-4,1.8163E-4,1.9751E-4,1.9512E-4,3.0033E-4,3.0926E-4,1.8229E-4,1.959E-4,1.948E-4,3.0069E-4,3.091E-4,1.8302E-4,1.9578E-4,1.9511E-4,3.0128E-4,3.0881E-4,1.8267E-4,1.9683E-4,1.9285E-4,3.0102E-4,3.097E-4,1.8255E-4,1.9327E-4,1.9258E-4,3.0168E-4,3.0841E-4,1.8226E-4,1.9526E-4,1.9405E-4,3.0042E-4,3.094E-4,1.8246E-4,1.967E-4,1.9413E-4,2.9975E-4,3.0629E-4,1.8308E-4,1.9514E-4,1.9365E-4,2.9904E-4,3.0779E-4,1.8113E-4,1.9442E-4,1.9301E-4,3.0142E-4,3.0685E-4,1.8162E-4,1.9476E-4,1.9478E-4,3.0073E-4,3.0459E-4,1.8028E-4,1.9382E-4,1.9329E-4,3.0061E-4,3.0763E-4,1.8123E-4,1.9371E-4,1.9188E-4,3.0102E-4,3.0737E-4,1.8213E-4,1.9272E-4,1.9325E-4,3.0143E-4,3.0661E-4,1.798E-4,1.9459E-4,1.9219E-4,3.0131E-4,3.0611E-4,1.7978E-4,1.9222E-4,1.9176E-4,2.9996E-4,3.0508E-4,1.7971E-4,1.9407E-4,1.9231E-4,3.0191E-4,3.0654E-4,1.8194E-4,1.9517E-4,1.9207E-4,3.001E-4,3.0535E-4,1.8054E-4,1.9711E-4,1.9186E-4,3.016E-4,3.0491E-4,1.8008E-4,1.946E-4,1.9217E-4,3.0137E-4,3.0391E-4,1.8103E-4,1.9427E-4,1.9249E-4,3.0063E-4,3.0511E-4,1.8148E-4,1.9286E-4,1.9299E-4,3.0113E-4,3.053E-4,1.7938E-4,1.9411E-4,1.9215E-4,3.0275E-4,3.0473E-4,1.7994E-4,1.9445E-4,1.9222E-4,3.0237E-4,3.0438E-4,1.8003E-4,1.9309E-4,1.9208E-4,3.0028E-4,3.0479E-4,1.8015E-4,1.9519E-4,1.9248E-4,3.0103E-4,3.0281E-4,1.7914E-4,1.9265E-4,1.9072E-4,3.0025E-4,3.0192E-4,1.7856E-4,1.9358E-4,1.9094E-4,3.0256E-4,3.0181E-4,1.7683E-4,1.9215E-4,1.9201E-4,3.0161E-4,3.0258E-4,1.8013E-4,1.9287E-4,1.9101E-4,3.0142E-4,3.0045E-4,1.7987E-4,1.9371E-4,1.9226E-4,3.018E-4,3.0203E-4,1.7791E-4,1.9262E-4,1.9029E-4,3.0085E-4,3.0155E-4,1.7815E-4,1.9326E-4,1.931E-4,3.0148E-4,3.028E-4,1.7904E-4,1.9162E-4,1.9135E-4,3.0022E-4,2.9972E-4,1.7903E-4,1.9431E-4,1.9159E-4,3.0019E-4,3.0147E-4,1.7807E-4,1.9217E-4,1.9146E-4,3.025E-4,3.0004E-4,1.788E-4,1.934E-4,1.9206E-4,3.007E-4,3.005E-4,1.7945E-4,1.9189E-4,1.9081E-4,3.0043E-4,3.0061E-4,1.7859E-4,1.9311E-4,1.9067E-4,3.0089E-4,3.0037E-4,1.765E-4,1.9398E-4,1.9247E-4,3.0233E-4,3.0016E-4,1.7757E-4,1.9336E-4,1.915E-4,3.0245E-4,2.995E-4,1.7777E-4,1.9375E-4,1.9105E-4,3.0361E-4,2.9868E-4,1.7749E-4,1.9354E-4,1.9347E-4,3.0269E-4,2.9838E-4,1.7925E-4,1.925E-4,1.9195E-4,3.0273E-4,2.9936E-4,1.7754E-4,1.9203E-4,1.9145E-4,3.0193E-4,2.977E-4,-1.7207E-5:1
-1.4833E-6,6.1667E-7,1.0167E-6,-1.0667E-6,1.0333E-6,-4.1333E-7,6.6667E-8,7.3E-7,-5.8667E-7,6.2333E-7,3.4E-7,8.9667E-7,8.1667E-7,-1.3E-6,4.2E-7,1.2E-7,8.6E-7,1.5867E-6,-9.9E-7,1.09E-6,-1.8E-7,1.28E-6,3.5667E-7,-7.0333E-7,9.6667E-7,-1.1867E-6,6.0333E-7,6.9333E-7,-8.0667E-7,6.7E-7,-5.3333E-8,-2.4333E-7,9.0667E-7,8.8E-7,1.6767E-6,1.0044E-4,2.3679E-4,1.5004E-4,1.243E-4,1.1797E-4,1.3884E-4,2.6264E-4,1.389E-4,1.2854E-4,1.4016E-4,1.7191E-4,2.8922E-4,1.6597E-4,1.527E-4,1.6202E-4,2.0738E-4,3.1678E-4,1.8761E-4,1.6787E-4,1.7498E-4,2.158E-4,3.1151E-4,1.7113E-4,1.3443E-4,1.0312E-4,9.608E-5,1.8244E-4,8.2507E-5,7.6263E-5,8.352E-5,8.5607E-5,1.7555E-4,7.93E-5,7.4433E-5,8.15E-5,8.3397E-5,1.7357E-4,8.0187E-5,7.4383E-5,8.12E-5,8.476E-5,1.7282E-4,8.0713E-5,7.548E-5,8.1423E-5,8.4243E-5,1.721E-4,8.3297E-5,7.368E-5,8.145E-5,8.384E-5,1.7145E-4,8.14E-5,7.2193E-5,7.9837E-5,8.2957E-5,1.719E-4,8.091E-5,7.3467E-5,7.957E-5,8.308E-5,1.7058E-4,8.062E-5,7.367E-5,8.0907E-5,8.4093E-5,1.6888E-4,8.1447E-5,7.194E-5,7.9003E-5,8.3357E-5,1.7001E-4,7.9437E-5,7.185E-5,7.9793E-5,8.229E-5,1.6892E-4,8.084E-5,7.2103E-5,8.0047E-5,8.242E-5,1.6924E-4,8.0203E-5,7.2263E-5,7.9033E-5,8.2333E-5,1.6891E-4,7.9043E-5,7.3127E-5,7.956E-5,8.2143E-5,1.688E-4,8.1477E-5,7.286E-5,7.922E-5,8.3757E-5,1.6859E-4,8.1307E-5,7.3773E-5,7.8403E-5,8.301E-5,1.6601E-4,8.2433E-5,7.294E-5,7.9407E-5,8.266E-5,1.6693E-4,8.33E-5,7.196E-5,7.9437E-5,8.277E-5,1.6663E-4,8.2037E-5,7.2917E-5,7.835E-5,8.3127E-5,1.6775E-4,8.3353E-5,7.1377E-5,7.9457E-5,8.2577E-5,1.6685E-4,8.4033E-5,7.211E-5,7.9213E-5,8.2147E-5,1.6591E-4,8.5527E-5,7.1843E-5,7.8657E-5,8.3247E-5,1.6661E-4,8.41E-5,7.1967E-5,7.945E-5,8.3773E-5,1.665E-4,8.4827E-5,7.2283E-5,7.8773E-5,8.317E-5,1.6555E-4,8.4047E-5,7.253E-5,7.8577E-5,8.247E-5,1.6658E-4,8.5053E-5,7.3733E-5,7.8027E-5,8.199E-5,1.6456E-4,8.5397E-5,7.281E-5,7.866E-5,8.3263E-5,1.6493E-4,8.4707E-5,7.358E-5,7.8767E-5,8.22E-5,1.6456E-4,8.4087E-5,7.235E-5,7.879E-5,8.2313E-5,1.6471E-4,8.49E-5,7.2407E-5,7.7917E-5,8.152E-5,1.6452E-4,8.5593E-5,7.2727E-5,7.8997E-5,8.2907E-5,1.629E-4,8.7453E-5,7.2697E-5,7.8287E-5,8.128E-5,1.6502E-4,8.6553E-5,7.2707E-5,7.914E-5,8.285E-5,1.6323E-4,8.954E-5,7.2553E-5,7.8353E-5,8.274E-5,1.6373E-4,9.086E-5,7.137E-5,7.754E-5,8.4433E-5,1.6212E-4,8.959E-5,7.2617E-5,7.818E-5,8.319E-5,1.6166E-4,9.0617E-5,7.2207E-5,7.896E-5,8.3213E-5,1.621E-4,8.9307E-5,7.1487E-5,7.7983E-5,8.2317E-5,1.6145E-4,9.0367E-5,7.2807E-5,7.787E-5,8.3367E-5,1.6208E-4,8.944E-5,7.1847E-5,7.7427E-5,8.29E-5,1.6121E-4,9.077E-5,7.1727E-5,7.7543E-5,8.287E-5,1.6099E-4,9.2647E-5,7.0653E-5,7.7797E-5,8.3007E-5,1.6097E-4,9.279E-5,7.0453E-5,7.787E-5,8.296E-5,1.5955E-4,9.212E-5,7.0897E-5,7.7583E-5,8.34E-5,1.6085E-4,9.29E-5,7.2067E-5,7.7447E-5,8.266E-5,1.6009E-4,9.3773E-5,7.194E-5,7.8613E-5,8.2833E-5,1.5819E-4,9.545E-5,7.2477E-5,7.685E-5,8.375E-5,1.602E-4,9.6093E-5,-1.274E-5:1
-1.11E-6,1.1067E-6,8.0667E-7,2.8E-7,3.7667E-7,-7.5333E-7,5.8333E-7,-3.2667E-7,1.12E-6,4.6333E-7,-7.2667E-7,3.8E-7,-2.7667E-7,1.7933E-6,1.65E-6,-7.1333E-7,9.4667E-7,6.9667E-7,1.3667E-7,6.7333E-7,-1.8E-7,1.1533E-6,-1.2E-6,1.04E-6,1.18E-6,-2.8333E-7,1.0433E-6,-1.0533E-6,8.4667E-7,8.2667E-7,-3.3667E-7,9.7E-7,-5.3E-7,6.0E-7,1.0767E-6,-8.1333E-7,9.7E-7,-3.7667E-7,5.4E-7,7.4667E-7,-1.1E-7,1.16E-6,-4.5E-7,1.3667E-7,3.4333E-7,1.9634E-4,1.8486E-4,1.3104E-4,2.7613E-4,1.504E-4,1.3558E-4,1.511E-4,1.8398E-4,3.0303E-4,1.7917E-4,1.6241E-4,1.7022E-4,2.1641E-4,3.2779E-4,1.9692E-4,1.7213E-4,1.7069E-4,2.1042E-4,3.1467E-4,1.7058E-4,1.2823E-4,1.0899E-4,1.0516E-4,1.9537E-4,9.6487E-5,8.556E-5,9.0907E-5,9.48E-5,1.8439E-4,9.2947E-5,8.3167E-5,8.8263E-5,9.2067E-5,1.8138E-4,9.2657E-5,8.1443E-5,8.62E-5,9.2683E-5,1.8096E-4,9.2567E-5,8.1057E-5,8.7077E-5,9.231E-5,1.8121E-4,9.158E-5,8.162E-5,8.6653E-5,9.178E-5,1.79E-4,9.1827E-5,8.0653E-5,8.75E-5,9.1617E-5,1.7925E-4,9.208E-5,8.0237E-5,8.742E-5,9.1337E-5,1.7792E-4,9.3653E-5,8.1427E-5,8.4123E-5,8.983E-5,1.7903E-4,9.4237E-5,7.936E-5,8.5563E-5,8.9353E-5,1.7822E-4,9.379E-5,7.797E-5,8.4323E-5,9.1313E-5,1.7541E-4,9.3863E-5,7.95E-5,8.524E-5,8.8747E-5,1.7543E-4,9.5227E-5,7.7967E-5,8.472E-5,8.9023E-5,1.7548E-4,9.565E-5,7.9273E-5,8.492E-5,8.8227E-5,1.7567E-4,9.4483E-5,7.9913E-5,8.4177E-5,8.9783E-5,1.7387E-4,9.3707E-5,7.977E-5,8.436E-5,8.903E-5,1.7396E-4,9.443E-5,7.8223E-5,8.515E-5,8.8797E-5,1.7409E-4,9.5647E-5,7.85E-5,8.2813E-5,8.9053E-5,1.7208E-4,9.6203E-5,7.75E-5,8.284E-5,8.9773E-5,1.7059E-4,9.7357E-5,7.7867E-5,8.4027E-5,8.922E-5,1.7039E-4,9.6207E-5,7.8373E-5,8.3433E-5,8.7987E-5,1.6988E-4,9.8047E-5,7.672E-5,8.317E-5,8.785E-5,1.6854E-4,9.8867E-5,7.766E-5,8.4127E-5,8.933E-5,1.6769E-4,9.9E-5,7.564E-5,8.282E-5,8.881E-5,1.6835E-4,9.982E-5,7.7143E-5,8.3137E-5,8.7923E-5,1.6744E-4,9.9737E-5,7.7727E-5,8.1787E-5,8.814E-5,1.6752E-4,1.0014E-4,7.738E-5,8.2973E-5,8.831E-5,1.6561E-4,1.0065E-4,7.6747E-5,8.285E-5,8.8127E-5,1.6581E-4,1.0121E-4,7.649E-5,8.3353E-5,8.6273E-5,1.6595E-4,1.0186E-4,7.7227E-5,8.2023E-5,8.7563E-5,1.6455E-4,1.0243E-4,7.5943E-5,8.1993E-5,8.8323E-5,1.6407E-4,1.0308E-4,7.6E-5,8.2273E-5,8.899E-5,1.6339E-4,1.05E-4,7.5747E-5,8.2733E-5,8.7873E-5,1.6251E-4,1.0626E-4,7.4997E-5,8.1587E-5,8.8187E-5,1.6183E-4,1.0778E-4,7.6083E-5,8.1257E-5,8.6767E-5,1.6052E-4,1.0723E-4,7.5603E-5,8.168E-5,8.8183E-5,1.5997E-4,1.0906E-4,7.418E-5,8.1637E-5,8.7917E-5,1.6037E-4,1.081E-4,7.6033E-5,8.1967E-5,8.7403E-5,1.5793E-4,1.1083E-4,7.5313E-5,8.106E-5,8.7037E-5,1.5785E-4,1.1144E-4,7.643E-5,8.131E-5,8.7347E-5,1.5667E-4,1.1198E-4,7.701E-5,8.072E-5,8.7953E-5,1.5647E-4,1.1197E-4,7.55E-5,8.12E-5,8.736E-5,1.5415E-4,1.1409E-4,7.6093E-5,8.0883E-5,8.721E-5,1.5259E-4,1.1501E-4,7.5757E-5,8.074E-5,8.849E-5,1.5057E-4,1.1497E-4,7.6017E-5,8.0753E-5,8.7773E-5,1.4969E-4,1.1779E-4,7.4313E-5,8.0197E-5,8.7227E-5,1.4939E-4,1.1916E-4,7.606E-5,8.05E-5,8.7723E-5,1.4854E-4,1.1993E-4,7.4833E-5,8.1317E-5,8.744E-5,1.4718E-4,1.2E-4,7.5227E-5,8.085E-5,8.6163E-5,1.4507E-4,1.2067E-4,7.643E-5,8.0427E-5,8.7083E-5,1.4651E-4,1.2336E-4,7.6553E-5,8.0047E-5,8.6257E-5,1.4338E-4,1.2502E-4,7.7397E-5,8.031E-5,8.7017E-5,9.7867E-5:1
1.5567E-6,1.22E-6,1.49E-6,1.12E-6,1.9E-7,5.2333E-7,1.79E-6,8.5333E-7,1.5167E-6,1.0967E-6,3.8E-7,-6.3333E-8,6.8E-7,9.9E-7,5.3333E-7,6.3333E-7,1.4567E-6,6.2667E-7,7.8E-7,1.3533E-6,8.8333E-7,8.4E-7,4.2E-7,1.888E-4,2.057E-4,1.6836E-4,2.0107E-4,1.3734E-4,8.7037E-5,9.8003E-5,9.9337E-5,1.7398E-4,1.3174E-4,8.381E-5,9.4797E-5,9.731E-5,1.7352E-4,1.3138E-4,8.243E-5,9.3543E-5,9.526E-5,1.7013E-4,1.2889E-4,8.1373E-5,9.391E-5,9.444E-5,1.7066E-4,1.3163E-4,8.086E-5,9.3023E-5,9.5287E-5,1.6865E-4,1.2949E-4,8.2097E-5,9.2683E-5,9.4483E-5,1.6797E-4,1.3066E-4,8.149E-5,9.2447E-5,9.379E-5,1.6808E-4,1.298E-4,8.0793E-5,9.3513E-5,9.4507E-5,1.6852E-4,1.2877E-4,8.0813E-5,9.2513E-5,9.4413E-5,1.6769E-4,1.2859E-4,8.0743E-5,9.143E-5,9.4377E-5,1.6686E-4,1.2873E-4,8.0883E-5,9.2323E-5,9.3633E-5,1.6642E-4,1.2862E-4,8.0223E-5,9.1567E-5,9.4E-5,1.6609E-4,1.291E-4,8.005E-5,9.1737E-5,9.3597E-5,1.66E-4,1.2791E-4,7.9677E-5,9.1323E-5,9.3577E-5,1.6628E-4,1.2791E-4,7.99E-5,9.1437E-5,9.2583E-5,1.6748E-4,1.2819E-4,8.0347E-5,9.039E-5,9.2637E-5,1.6534E-4,1.2821E-4,8.0957E-5,9.1373E-5,9.23E-5,1.6395E-4,1.2907E-4,7.9983E-5,9.04E-5,9.261E-5,1.6592E-4,1.2753E-4,7.9273E-5,9.0867E-5,9.3307E-5,1.6617E-4,1.284E-4,7.979E-5,9.0033E-5,9.215E-5,1.647E-4,1.2783E-4,7.925E-5,9.1537E-5,9.1477E-5,1.6658E-4,1.278E-4,7.907E-5,9.1103E-5,9.2747E-5,1.6581E-4,1.2773E-4,7.906E-5,9.14E-5,9.2743E-5,1.6492E-4,1.2717E-4,7.921E-5,9.099E-5,9.2233E-5,1.6378E-4,1.2817E-4,7.8383E-5,9.1037E-5,9.1553E-5,1.6529E-4,1.2761E-4,7.9247E-5,9.0383E-5,9.2847E-5,1.6547E-4,1.2646E-4,7.833E-5,8.9397E-5,9.055E-5,1.6548E-4,1.2746E-4,7.8937E-5,8.914E-5,9.2143E-5,1.6518E-4,1.2756E-4,7.9437E-5,9.0657E-5,9.2833E-5,1.6589E-4,1.2729E-4,7.8657E-5,9.169E-5,9.2983E-5,1.6555E-4,1.264E-4,7.9007E-5,9.0007E-5,9.2127E-5,1.6462E-4,1.264E-4,7.8797E-5,9.081E-5,9.1627E-5,1.666E-4,1.2645E-4,7.9777E-5,9.11E-5,9.1647E-5,1.668E-4,1.2611E-4,7.878E-5,8.9987E-5,9.1093E-5,1.6511E-4,1.27E-4,7.9487E-5,9.0743E-5,9.1377E-5,1.6581E-4,1.2699E-4,7.85E-5,8.9497E-5,9.1767E-5,1.6609E-4,1.2798E-4,7.875E-5,8.9507E-5,9.301E-5,1.6481E-4,1.2604E-4,7.9727E-5,9.058E-5,9.264E-5,1.638E-4,1.2669E-4,7.8773E-5,9.043E-5,9.185E-5,1.6435E-4,1.2778E-4,7.9063E-5,8.97E-5,9.2413E-5,1.6585E-4,1.2608E-4,7.8777E-5,9.0273E-5,9.182E-5,1.656E-4,1.2638E-4,7.9123E-5,8.9273E-5,9.1887E-5,1.6443E-4,1.263E-4,7.7783E-5,8.9687E-5,9.166E-5,1.6518E-4,1.2629E-4,7.759E-5,9.1373E-5,9.1813E-5,1.6409E-4,1.2569E-4,7.8363E-5,9.0827E-5,9.193E-5,1.6613E-4,1.2646E-4,7.885E-5,9.049E-5,9.159E-5,1.6471E-4,1.2482E-4,7.7537E-5,9.0577E-5,9.1433E-5,1.6585E-4,1.2628E-4,7.9523E-5,8.9847E-5,9.1867E-5,1.6508E-4,1.2541E-4,7.826E-5,8.963E-5,9.163E-5,1.6484E-4,1.2517E-4,7.786E-5,9.011E-5,9.0623E-5,1.6691E-4,1.2597E-4,7.8833E-5,8.9983E-5,9.175E-5,1.6552E-4,1.2641E-4,7.8267E-5,9.0667E-5,9.1553E-5,1.6679E-4,1.2612E-4,7.78E-5,9.1023E-5,9.272E-5,1.6662E-4,1.2488E-4,7.7873E-5,9.0397E-5,9.1733E-5,1.6655E-4,1.2536E-4,7.8657E-5,8.9673E-5,9.1663E-5,1.6663E-4,1.2614E-4,7.9287E-5,9.0453E-5,9.2743E-5,1.6735E-4,1.2548E-4,7.782E-5,8.8413E-5,9.0273E-5,1.6612E-4,1.2616E-4,7.84E-5,9.0827E-5,9.1063E-5,1.6542E-4,1.2596E-4,7.787E-5,9.1107E-5,9.111E-5,1.6581E-4,1.2464E-4,7.756E-5,9.089E-5,9.1737E-5,1.672E-4,1.2593E-4,7.894E-5,9.155E-5,9.0963E-5,1.6807E-4,1.2676E-4,7.9383E-5,9.1327E-5,9.196E-5,1.6684E-4,1.2511E-4,7.8687E-5,8.993E-5,9.1877E-5,1.6613E-4,1.2478E-4,7.906E-5,9.094E-5,9.074E-5,1.6618E-4,1.2532E-4,7.674E-5,9.085E-5,9.244E-5,1.6791E-4,1.2484E-4,7.8533E-5,9.0233E-5,9.2287E-5,1.6762E-4,1.2402E-4,7.8327E-5,9.0463E-5,9.1193E-5,1.6685E-4,1.2487E-4,7.8693E-5,9.041E-5,9.1637E-5,1.6735E-4,1.2563E-4,7.716E-5,9.0693E-5,9.1747E-5,1.6667E-4,1.2453E-4,7.8373E-5,9.032E-5,9.2167E-5,1.6776E-4,1.2432E-4,7.7967E-5,9.04E-5,9.214E-5,1.6667E-4,1.2575E-4,7.8713E-5,9.122E-5,9.237E-5,1.6612E-4,1.2698E-4,7.7723E-5,9.0647E-5,9.2263E-5,1.6832E-4,1.2564E-4,7.8257E-5,9.0827E-5,9.213E-5,1.6773E-4,1.252E-4,7.8507E-5,8.9957E-5,9.2707E-5,1.6831E-4,1.2549E-4,7.7673E-5,8.9853E-5,9.2233E-5,1.6765E-4,1.2433E-4,7.937E-5,8.986E-5,9.167E-5,1.6806E-4,1.2508E-4,7.81E-5,9.094E-5,9.22E-5,9.2553E-5:1
4.5333E-7,8.8E-7,1.4733E-6,8.2667E-7,5.0667E-7,2.4E-7,1.3667E-6,8.0667E-7,7.2333E-7,2.0E-7,8.6333E-7,8.8333E-7,5.7E-7,8.8667E-7,1.0667E-7,5.6667E-7,9.6667E-8,6.9E-7,1.6533E-6,3.9E-7,1.2033E-6,2.17E-6,5.6667E-7,3.9667E-7,2.1667E-7,5.0333E-7,4.2955E-4,2.3595E-4,9.4797E-5,9.6567E-5,1.05E-4,1.8255E-4,1.3802E-4,8.806E-5,1.0003E-4,1.0125E-4,1.8226E-4,1.3621E-4,8.5617E-5,9.894E-5,9.9997E-5,1.7962E-4,1.3559E-4,8.5707E-5,9.9153E-5,9.895E-5,1.793E-4,1.339E-4,8.642E-5,9.795E-5,9.9467E-5,1.7818E-4,1.3379E-4,8.473E-5,9.8953E-5,9.938E-5,1.7824E-4,1.334E-4,8.499E-5,9.7463E-5,9.8727E-5,1.7777E-4,1.3386E-4,8.465E-5,9.82E-5,9.8587E-5,1.7835E-4,1.3304E-4,8.4983E-5,9.6333E-5,9.8673E-5,1.7808E-4,1.3411E-4,8.421E-5,9.729E-5,9.8463E-5,1.7733E-4,1.3268E-4,8.4927E-5,9.797E-5,9.8217E-5,1.7613E-4,1.339E-4,8.363E-5,9.6183E-5,9.8487E-5,1.7762E-4,1.3356E-4,8.475E-5,9.778E-5,9.7213E-5,1.7542E-4,1.3262E-4,8.3403E-5,9.6963E-5,9.7337E-5,1.7774E-4,1.3327E-4,8.444E-5,9.6313E-5,9.7837E-5,1.7702E-4,1.3242E-4,8.3817E-5,9.6887E-5,9.7713E-5,1.7561E-4,1.3288E-4,8.4123E-5,9.653E-5,9.735E-5,1.7639E-4,1.3248E-4,8.282E-5,9.7593E-5,9.757E-5,1.7775E-4,1.3162E-4,8.3573E-5,9.7063E-5,9.726E-5,1.76E-4,1.3202E-4,8.28E-5,9.6843E-5,9.739E-5,1.7467E-4,1.3255E-4,8.289E-5,9.6433E-5,9.6287E-5,1.7595E-4,1.3282E-4,8.378E-5,9.594E-5,9.5967E-5,1.7647E-4,1.3155E-4,8.4103E-5,9.5733E-5,9.6777E-5,1.7604E-4,1.3196E-4,8.3717E-5,9.6423E-5,9.8267E-5,1.743E-4,1.3259E-4,8.279E-5,9.5083E-5,9.702E-5,1.7511E-4,1.3248E-4,8.2403E-5,9.626E-5,9.695E-5,1.7525E-4,1.3235E-4,8.342E-5,9.5677E-5,9.6627E-5,1.7521E-4,1.3222E-4,8.3063E-5,9.6307E-5,9.6363E-5,1.7623E-4,1.3224E-4,8.3157E-5,9.7413E-5,9.7277E-5,1.7623E-4,1.3123E-4,8.3427E-5,9.6167E-5,9.602E-5,1.7551E-4,1.3243E-4,8.272E-5,9.6633E-5,9.8033E-5,1.7486E-4,1.3332E-4,8.352E-5,9.595E-5,9.7387E-5,1.7471E-4,1.332E-4,8.2867E-5,9.5707E-5,9.601E-5,1.7347E-4,1.3274E-4,8.2727E-5,9.6253E-5,9.6397E-5,1.7375E-4,1.3214E-4,8.2767E-5,9.5857E-5,9.6753E-5,1.748E-4,1.3323E-4,8.3497E-5,9.5643E-5,9.627E-5,1.7389E-4,1.3234E-4,8.3763E-5,9.6027E-5,9.6177E-5,1.7463E-4,1.3347E-4,8.2177E-5,9.5377E-5,9.6513E-5,1.7338E-4,1.316E-4,8.294E-5,9.603E-5,9.7023E-5,1.7406E-4,1.3318E-4,8.2587E-5,9.6217E-5,9.6233E-5,1.7488E-4,1.3341E-4,8.3897E-5,9.6373E-5,9.6897E-5,1.7448E-4,1.3411E-4,8.34E-5,9.599E-5,9.74E-5,1.728E-4,1.3399E-4,8.3127E-5,9.576E-5,9.6537E-5,1.7461E-4,1.3127E-4,8.4067E-5,9.7053E-5,9.7423E-5,1.7639E-4,1.3249E-4,8.269E-5,9.4943E-5,9.6163E-5,1.7627E-4,1.3253E-4,8.339E-5,9.453E-5,9.7143E-5,1.7492E-4,1.326E-4,8.3653E-5,9.544E-5,9.6213E-5,1.7412E-4,1.3316E-4,8.3723E-5,9.5907E-5,9.7557E-5,1.7382E-4,1.334E-4,8.3197E-5,9.6623E-5,9.5457E-5,1.7469E-4,1.3372E-4,8.295E-5,9.505E-5,9.573E-5,1.74E-4,1.3441E-4,8.3373E-5,9.6827E-5,9.6563E-5,1.7393E-4,1.3318E-4,8.322E-5,9.6273E-5,9.612E-5,1.7461E-4,1.3269E-4,8.322E-5,9.68E-5,9.6417E-5,1.7364E-4,1.3562E-4,8.251E-5,9.5517E-5,9.696E-5,1.7264E-4,1.3428E-4,8.3517E-5,9.5353E-5,9.7293E-5,1.7377E-4,1.3394E-4,8.3953E-5,9.692E-5,9.6637E-5,1.7393E-4,1.3459E-4,8.305E-5,9.6633E-5,9.6547E-5,1.7402E-4,1.3477E-4,8.364E-5,9.4693E-5,9.682E-5,1.7396E-4,1.3383E-4,8.342E-5,9.5493E-5,9.621E-5,1.7337E-4,1.3486E-4,8.3927E-5,9.54E-5,9.6213E-5,1.7253E-4,1.3403E-4,8.383E-5,9.563E-5,9.6863E-5,1.7331E-4,1.3345E-4,-1.509E-5:1
4.0333E-7,1.5967E-6,6.8667E-7,1.2833E-6,2.1333E-7,3.9E-7,-1.3333E-8,1.85E-6,4.1E-7,6.8333E-7,4.8667E-7,1.2133E-6,7.1667E-7,1.7633E-6,1.0233E-6,5.0333E-7,1.0533E-6,1.5267E-6,-3.7333E-7,2.7E-7,1.3967E-6,6.1333E-7,7.0E-8,-7.0E-8,6.3667E-7,6.1E-7,1.2E-7,4.0667E-7,3.4333E-7,1.2433E-6,1.5067E-6,6.8E-7,-2.6E-7,5.3E-7,3.3333E-7,7.0667E-7,8.8E-7,9.6667E-7,1.25E-6,2.8E-7,1.0067E-6,8.0E-8,6.8333E-7,7.0333E-7,8.8333E-7,1.9667E-7,8.9667E-7,6.7E-7,3.0667E-7,4.7667E-7,2.9667E-7,5.3667E-7,9.0E-7,9.9333E-7,1.0633E-6,1.1333E-6,1.2967E-6,2.0333E-7,1.2533E-6,1.2433E-6,1.9667E-7,4.6635E-4,2.2671E-4,1.0202E-4,1.22E-4,1.1197E-4,2.0823E-4,1.4667E-4,9.7053E-5,1.1027E-4,1.1E-4,2.0515E-4,1.432E-4,9.4573E-5,1.0958E-4,1.1052E-4,2.0384E-4,1.3986E-4,9.4883E-5,1.0953E-4,1.0954E-4,2.0247E-4,1.3892E-4,9.2187E-5,1.0898E-4,1.0832E-4,2.0087E-4,1.3801E-4,9.1373E-5,1.0764E-4,1.0725E-4,2.0129E-4,1.3591E-4,9.1E-5,1.0726E-4,1.0731E-4,1.9906E-4,1.3516E-4,9.154E-5,1.0603E-4,1.0703E-4,1.9933E-4,1.3447E-4,9.102E-5,1.064E-4,1.0583E-4,1.9876E-4,1.3404E-4,8.9613E-5,1.0588E-4,1.0689E-4,1.9776E-4,1.3364E-4,9.0043E-5,1.0712E-4,1.0595E-4,1.975E-4,1.328E-4,8.94E-5,1.0556E-4,1.0541E-4,1.9819E-4,1.3156E-4,8.978E-5,1.0543E-4,1.0471E-4,1.989E-4,1.295E-4,8.9223E-5,1.042E-4,1.0586E-4,1.9734E-4,1.3128E-4,8.8037E-5,1.0432E-4,1.0495E-4,1.9642E-4,1.2908E-4,8.8497E-5,1.0377E-4,1.0434E-4,1.9835E-4,1.2872E-4,8.9047E-5,1.0331E-4,1.0453E-4,1.9747E-4,1.2909E-4,8.8253E-5,1.0463E-4,1.0395E-4,1.9754E-4,1.287E-4,8.9273E-5,1.0452E-4,1.0465E-4,1.9722E-4,1.2935E-4,8.9147E-5,1.0421E-4,1.0419E-4,1.9685E-4,1.2781E-4,8.8497E-5,1.0404E-4,1.0457E-4,1.9739E-4,1.2698E-4,8.8157E-5,1.0433E-4,1.0289E-4,1.9847E-4,1.2648E-4,8.774E-5,1.0489E-4,1.0448E-4,1.9733E-4,1.271E-4,8.7923E-5,1.0249E-4,1.04E-4,1.9776E-4,1.2528E-4,8.8493E-5,1.0184E-4,1.0407E-4,1.9757E-4,1.2596E-4,8.777E-5,1.011E-4,1.0369E-4,1.9727E-4,1.2516E-4,8.791E-5,1.0295E-4,1.0348E-4,1.9815E-4,1.2431E-4,8.824E-5,1.0306E-4,1.0286E-4,1.9848E-4,1.2459E-4,8.788E-5,1.0408E-4,1.022E-4,1.9769E-4,1.2359E-4,8.8457E-5,1.0367E-4,1.0245E-4,1.9799E-4,1.2274E-4,8.8003E-5,1.027E-4,1.0272E-4,1.9764E-4,1.2332E-4,8.775E-5,1.035E-4,1.0265E-4,1.9728E-4,1.227E-4,8.6607E-5,1.0294E-4,1.0307E-4,1.9659E-4,1.2206E-4,8.7887E-5,1.0324E-4,1.0289E-4,1.9733E-4,1.2288E-4,8.814E-5,1.0244E-4,1.0363E-4,1.9812E-4,1.2154E-4,8.7817E-5,1.0171E-4,1.0397E-4,1.9764E-4,1.2124E-4,8.887E-5,1.0244E-4,1.0497E-4,1.9611E-4,1.2001E-4,8.6233E-5,1.0251E-4,1.0368E-4,1.9614E-4,1.2029E-4,8.8127E-5,1.0211E-4,1.0452E-4,1.9616E-4,1.2024E-4,8.72E-5,1.0274E-4,1.0481E-4,1.9467E-4,1.1948E-4,8.726E-5,1.025E-4,1.053E-4,1.9513E-4,1.1954E-4,8.7687E-5,1.0225E-4,1.0675E-4,1.9647E-4,1.1799E-4,8.704E-5,1.0259E-4,1.0689E-4,1.9538E-4,1.1972E-4,8.7587E-5,1.0229E-4,1.0647E-4,1.9277E-4,1.1897E-4,8.638E-5,1.0285E-4,1.0835E-4,1.9644E-4,1.1964E-4,8.693E-5,1.0293E-4,1.0832E-4,1.9288E-4,1.1805E-4,8.7613E-5,1.0241E-4,1.0789E-4,1.9299E-4,1.1725E-4,8.8247E-5,1.0308E-4,1.0859E-4,1.9202E-4,1.1735E-4,8.7657E-5,1.0269E-4,1.1093E-4,1.9138E-4,1.1771E-4,8.8047E-5,1.0334E-4,1.1097E-4,1.9162E-4,1.1752E-4,8.8643E-5,1.0176E-4,1.1066E-4,1.8968E-4,1.1641E-4,8.7557E-5,1.0296E-4,1.1179E-4,1.8898E-4,1.1751E-4,8.7103E-5,1.0232E-4,1.135E-4,1.8854E-4,1.1679E-4,8.8727E-5,1.019E-4,1.1361E-4,1.8932E-4,1.1602E-4,8.8303E-5,1.0331E-4,1.136E-4,1.8841E-4,1.1717E-4,8.5593E-5,1.0321E-4,1.1454E-4,1.8843E-4,1.1566E-4,8.9027E-5,1.0313E-4,1.1543E-4,1.874E-4,1.1497E-4,8.842E-5,1.0311E-4,1.1538E-4,1.8635E-4,1.1505E-4,8.7717E-5,1.0207E-4,1.1613E-4,1.8794E-4,1.1499E-4,8.8523E-5,1.0235E-4,1.1631E-4,1.8714E-4,1.161E-4,8.75E-5,1.0356E-4,1.1583E-4,1.8788E-4,1.1454E-4,8.92E-5,1.0237E-4,1.1744E-4,1.8488E-4,1.1565E-4,8.831E-5,1.026E-4,1.1848E-4,1.8442E-4,1.141E-4,8.8593E-5,1.0313E-4,1.1795E-4,1.8774E-4,1.145E-4,8.8023E-5,1.0227E-4,1.1835E-4,1.8616E-4,1.1308E-4,8.8973E-5,1.032E-4,1.1962E-4,1.8604E-4,1.1518E-4,8.957E-5,1.0322E-4,1.1989E-4,1.8388E-4,1.1275E-4,8.919E-5,1.0195E-4,1.2084E-4,1.8397E-4,1.1353E-4,8.853E-5,1.0229E-4,1.1985E-4,1.8423E-4,1.1408E-4,8.8887E-5,1.0319E-4,1.1961E-4,1.8292E-4,1.1359E-4,8.8173E-5,1.0325E-4,1.2052E-4,8.2227E-5:1
-4.8867E-6,-3.77E-6,-3.8867E-6,-4.49E-6,-5.4E-6,-5.28E-6,-3.6033E-6,-3.3267E-6,-4.44E-6,-4.86E-6,-4.3933E-6,-4.2867E-6,-2.6367E-6,-3.5133E-6,-5.6167E-6,-4.91E-6,-4.5867E-6,-3.0433E-6,-4.62E-6,-6.0033E-6,-3.8033E-6,-3.96E-6,9.1153E-5,5.8604E-4,3.6835E-4,3.6261E-4,3.3894E-4,4.0544E-4,3.563E-4,1.8781E-4,1.963E-4,1.925E-4,2.7392E-4,3.4246E-4,1.786E-4,1.8907E-4,1.8594E-4,2.6165E-4,3.376E-4,1.7611E-4,1.8639E-4,1.8593E-4,2.5493E-4,3.3931E-4,1.7644E-4,1.8604E-4,1.8452E-4,2.5395E-4,3.4048E-4,1.7593E-4,1.8504E-4,1.8367E-4,2.5124E-4,3.4336E-4,1.742E-4,1.8503E-4,1.8179E-4,2.4942E-4,3.4231E-4,1.7578E-4,1.8453E-4,1.8373E-4,2.4665E-4,3.4528E-4,1.7535E-4,1.8481E-4,1.829E-4,2.4603E-4,3.4676E-4,1.8016E-4,1.8941E-4,1.8481E-4,2.4628E-4,3.5033E-4,1.7848E-4,1.8466E-4,1.8589E-4,2.4461E-4,3.5313E-4,1.79E-4,1.8483E-4,1.8475E-4,2.408E-4,3.5569E-4,1.7907E-4,1.8559E-4,1.8458E-4,2.3772E-4,3.5466E-4,1.8095E-4,1.8319E-4,1.8396E-4,2.3684E-4,3.5921E-4,1.801E-4,1.8453E-4,1.8431E-4,2.3436E-4,3.6022E-4,1.8037E-4,1.8522E-4,1.8296E-4,2.3214E-4,3.6279E-4,1.7919E-4,1.8319E-4,1.8531E-4,2.3016E-4,3.6192E-4,1.8004E-4,1.8348E-4,1.8331E-4,2.2969E-4,3.6325E-4,1.8196E-4,1.8341E-4,1.8194E-4,2.2774E-4,3.6446E-4,1.8057E-4,1.8534E-4,1.8373E-4,2.2544E-4,3.6418E-4,1.8378E-4,1.8469E-4,1.8148E-4,2.2371E-4,3.6634E-4,1.8345E-4,1.8481E-4,1.8299E-4,2.2162E-4,3.6988E-4,1.823E-4,1.8382E-4,1.8314E-4,2.216E-4,3.6832E-4,1.8493E-4,1.8518E-4,1.826E-4,2.1763E-4,3.6931E-4,1.8552E-4,1.8465E-4,1.8111E-4,2.2092E-4,3.7262E-4,1.8717E-4,1.837E-4,1.849E-4,2.1755E-4,3.7303E-4,1.8464E-4,1.83E-4,1.8422E-4,2.1404E-4,3.7322E-4,1.8533E-4,1.8376E-4,1.8286E-4,2.1519E-4,3.7613E-4,1.8805E-4,1.85E-4,1.8391E-4,2.1326E-4,3.7783E-4,1.8658E-4,1.8515E-4,1.8235E-4,2.1039E-4,3.7639E-4,1.8604E-4,1.8374E-4,1.8291E-4,2.0982E-4,3.7653E-4,1.8699E-4,1.8351E-4,1.813E-4,2.0813E-4,3.7942E-4,1.8942E-4,1.8275E-4,1.8169E-4,2.0778E-4,3.7867E-4,1.8959E-4,1.8423E-4,1.8385E-4,2.0691E-4,3.8018E-4,1.906E-4,1.8284E-4,1.8305E-4,2.0414E-4,3.7803E-4,1.8872E-4,1.8228E-4,1.8332E-4,2.0506E-4,3.8049E-4,1.9044E-4,1.8342E-4,1.8157E-4,2.038E-4,3.8002E-4,1.914E-4,1.8278E-4,1.8153E-4,2.0307E-4,3.8001E-4,1.9237E-4,1.8154E-4,1.8118E-4,2.0449E-4,3.8148E-4,1.9254E-4,1.8197E-4,1.8229E-4,2.02E-4,3.7999E-4,1.9364E-4,1.8149E-4,1.7958E-4,2.0157E-4,3.7956E-4,1.9507E-4,1.8246E-4,1.8139E-4,2.0007E-4,3.814E-4,1.9381E-4,1.8115E-4,1.8127E-4,1.9903E-4,3.8096E-4,1.9569E-4,1.8146E-4,1.8175E-4,2.0161E-4,3.7895E-4,1.9512E-4,1.8306E-4,1.8061E-4,2.0193E-4,3.7907E-4,1.942E-4,1.8197E-4,1.8053E-4,2.0112E-4,3.7899E-4,1.9786E-4,1.8266E-4,1.7975E-4,2.0162E-4,3.7799E-4,1.9653E-4,1.8226E-4,1.8036E-4,2.0229E-4,3.7795E-4,1.9767E-4,1.7943E-4,1.8055E-4,2.0118E-4,3.7761E-4,1.994E-4,1.8043E-4,1.8067E-4,2.0019E-4,3.7717E-4,2.006E-4,1.816E-4,1.8048E-4,1.9893E-4,3.7492E-4,1.9922E-4,1.825E-4,1.7981E-4,1.9963E-4,3.762E-4,2.0066E-4,1.8215E-4,1.8041E-4,1.9938E-4,3.7614E-4,2.0238E-4,1.8115E-4,1.7916E-4,2.0117E-4,3.7234E-4,2.0098E-4,1.8205E-4,1.8024E-4,2.0125E-4,3.7328E-4,2.0329E-4,1.7948E-4,1.7995E-4,2.0141E-4,3.7201E-4,2.0464E-4,1.8226E-4,1.797E-4,2.0103E-4,3.7474E-4,2.0507E-4,1.8137E-4,1.8025E-4,2.0057E-4,3.7265E-4,2.0572E-4,1.8104E-4,1.7892E-4,2.0037E-4,3.7368E-4,2.0449E-4,1.8091E-4,1.8038E-4,1.9894E-4,3.7119E-4,2.0767E-4,1.7904E-4,1.7874E-4,1.9903E-4,3.6976E-4,2.0671E-4,1.7942E-4,1.7947E-4,2.0158E-4,3.6825E-4,2.1006E-4,1.805E-4,1.7891E-4,2.0007E-4,3.6997E-4,2.101E-4,1.8019E-4,1.7844E-4,1.9986E-4,3.6869E-4,2.0965E-4,1.8023E-4,1.7952E-4,1.9978E-4,3.6721E-4,2.1236E-4,1.8101E-4,1.7852E-4,1.9847E-4,3.6655E-4,2.1205E-4,1.7983E-4,1.7919E-4,1.9997E-4,3.6658E-4,2.1329E-4,1.7982E-4,1.7775E-4,1.9845E-4,3.6663E-4,2.1439E-4,1.8069E-4,1.7954E-4,2.0034E-4,3.6387E-4,2.1446E-4,1.798E-4,1.7644E-4,1.99E-4,3.6427E-4,2.1725E-4,1.7933E-4,1.7799E-4,1.9948E-4,3.6283E-4,2.1944E-4,1.8006E-4,1.792E-4,2.0047E-4,3.6182E-4,2.2065E-4,1.8051E-4,1.7849E-4,1.999E-4,3.6014E-4,2.2024E-4,1.7965E-4,1.7831E-4,1.9908E-4,3.5922E-4,2.2075E-4,1.7962E-4,1.7836E-4,1.9938E-4,3.5972E-4,2.2257E-4,1.7937E-4,1.7837E-4,1.9917E-4,3.587E-4,2.2365E-4,1.7864E-4,1.7803E-4,1.9952E-4,3.5798E-4,2.2614E-4,1.784E-4,1.7842E-4,1.9893E-4,3.5531E-4,2.2794E-4,1.809E-4,1.805E-4,1.9861E-4,3.4448E-4,2.2633E-4,1.7654E-4,1.7526E-4,1.9611E-4,3.4819E-4,2.289E-4,1.751E-4,1.7719E-4,1.9713E-4,3.4786E-4,2.2986E-4,1.7778E-4,1.7685E-4,1.965E-4,3.4579E-4,2.3147E-4,1.77E-4,1.7424E-4,1.975E-4,3.4414E-4,2.3006E-4:1
-3.4567E-6,-4.5067E-6,-3.19E-6,-5.9E-6,-5.45E-6,-3.64E-6,-3.3933E-6,-4.87E-6,-5.1067E-6,-4.89E-6,-4.1533E-6,-3.04E-6,-4.3367E-6,-4.33E-6,-5.2767E-6,-3.3767E-6,-3.64E-6,-3.9733E-6,-5.9333E-6,-5.25E-6,-3.28E-6,-3.7633E-6,-3.99E-6,-5.64E-6,-5.0533E-6,-3.9533E-6,-3.16E-6,-4.01E-6,-4.8967E-6,-5.48E-6,1.5315E-4,6.5171E-4,5.2175E-4,3.4499E-4,2.5824E-4,2.3259E-4,3.0915E-4,3.2526E-4,1.9503E-4,1.7916E-4,2.0581E-4,2.8442E-4,3.1639E-4,1.8938E-4,1.7604E-4,2.0136E-4,2.7746E-4,3.1694E-4,1.8877E-4,1.7403E-4,1.9938E-4,2.7253E-4,3.1912E-4,1.8877E-4,1.7468E-4,1.9908E-4,2.6859E-4,3.2268E-4,1.902E-4,1.7399E-4,1.9838E-4,2.6654E-4,3.2409E-4,1.896E-4,1.7375E-4,1.9775E-4,2.6201E-4,3.2501E-4,1.8924E-4,1.7413E-4,1.977E-4,2.5837E-4,3.2876E-4,1.9037E-4,1.7555E-4,1.9719E-4,2.5596E-4,3.3205E-4,1.9126E-4,1.7351E-4,1.9708E-4,2.5253E-4,3.3258E-4,1.918E-4,1.7232E-4,1.9774E-4,2.5021E-4,3.3762E-4,1.9215E-4,1.7253E-4,1.9819E-4,2.4839E-4,3.3835E-4,1.9164E-4,1.718E-4,1.9838E-4,2.4441E-4,3.421E-4,1.946E-4,1.7202E-4,1.9795E-4,2.4372E-4,3.4511E-4,1.94E-4,1.7295E-4,1.9519E-4,2.3997E-4,3.4512E-4,1.9291E-4,1.7249E-4,1.9747E-4,2.3706E-4,3.4811E-4,1.9559E-4,1.7154E-4,1.9772E-4,2.3299E-4,3.5214E-4,1.9717E-4,1.7179E-4,1.9742E-4,2.2963E-4,3.5354E-4,1.9604E-4,1.728E-4,1.9676E-4,2.2708E-4,3.5379E-4,1.9769E-4,1.7106E-4,1.9794E-4,2.2582E-4,3.5808E-4,1.9733E-4,1.6909E-4,1.9515E-4,2.2227E-4,3.6153E-4,1.9869E-4,1.7159E-4,1.956E-4,2.1998E-4,3.6246E-4,1.9774E-4,1.7128E-4,1.9622E-4,2.1641E-4,3.6369E-4,2.022E-4,1.707E-4,1.956E-4,2.1528E-4,3.6627E-4,2.0004E-4,1.7149E-4,1.9511E-4,2.1423E-4,3.6736E-4,2.0114E-4,1.7057E-4,1.956E-4,2.114E-4,3.6656E-4,2.0218E-4,1.7052E-4,1.9656E-4,2.0956E-4,3.6948E-4,2.0098E-4,1.6919E-4,1.9627E-4,2.0719E-4,3.7144E-4,2.0226E-4,1.6978E-4,1.9413E-4,2.05E-4,3.7062E-4,2.0229E-4,1.6631E-4,1.9261E-4,2.0094E-4,3.7267E-4,2.0267E-4,1.6885E-4,1.9427E-4,2.0199E-4,3.7112E-4,2.0443E-4,1.687E-4,1.9459E-4,1.9757E-4,3.7173E-4,2.0433E-4,1.686E-4,1.9456E-4,1.9694E-4,3.7577E-4,2.064E-4,1.6856E-4,1.9274E-4,1.9632E-4,3.7531E-4,2.0648E-4,1.6702E-4,1.9285E-4,1.9452E-4,3.7354E-4,2.0808E-4,1.658E-4,1.9182E-4,1.9373E-4,3.7558E-4,2.0889E-4,1.6868E-4,1.9315E-4,1.9142E-4,3.7695E-4,2.103E-4,1.6921E-4,1.9327E-4,1.899E-4,3.7865E-4,2.0927E-4,1.6796E-4,1.9225E-4,1.8984E-4,3.774E-4,2.1029E-4,1.6733E-4,1.9355E-4,1.9008E-4,3.748E-4,2.1195E-4,1.6596E-4,1.9336E-4,1.8889E-4,3.7766E-4,2.1256E-4,1.6738E-4,1.916E-4,1.8931E-4,3.7562E-4,2.1263E-4,1.6632E-4,1.9197E-4,1.8844E-4,3.7454E-4,2.1271E-4,1.6602E-4,1.9266E-4,1.875E-4,3.7309E-4,2.1623E-4,1.6576E-4,1.9123E-4,1.9001E-4,3.7319E-4,2.1721E-4,1.6552E-4,1.9029E-4,1.8899E-4,3.7234E-4,2.1787E-4,1.6411E-4,1.9227E-4,1.8834E-4,3.7129E-4,2.1717E-4,1.6667E-4,1.9126E-4,1.8935E-4,3.7018E-4,2.2005E-4,1.6436E-4,1.8985E-4,1.875E-4,3.697E-4,2.2033E-4,1.654E-4,1.9159E-4,1.8823E-4,3.692E-4,2.2217E-4,1.6413E-4,1.8973E-4,1.8651E-4,3.6774E-4,2.2264E-4,1.6517E-4,1.9159E-4,1.8769E-4,3.6801E-4,2.2223E-4,1.6432E-4,1.8854E-4,1.8797E-4,3.6484E-4,2.244E-4,1.6411E-4,1.9245E-4,1.8845E-4,3.6613E-4,2.2608E-4,1.6459E-4,1.8822E-4,1.8767E-4,3.642E-4,2.2855E-4,1.6491E-4,1.8997E-4,1.8874E-4,3.6554E-4,2.2784E-4,1.6415E-4,1.8992E-4,1.8808E-4,3.6183E-4,2.3082E-4,1.6341E-4,1.9164E-4,1.8982E-4,3.6318E-4,2.3138E-4,1.6307E-4,1.9067E-4,1.8819E-4,3.602E-4,2.326E-4,1.6526E-4,1.8995E-4,1.8693E-4,3.5963E-4,2.3357E-4,1.6311E-4,1.8938E-4,1.8741E-4,3.5869E-4,2.3611E-4,1.637E-4,1.8936E-4,1.8886E-4,3.5682E-4,2.3809E-4,1.6392E-4,1.9117E-4,1.8639E-4,3.5683E-4,2.3873E-4,1.6307E-4,1.8971E-4,1.8794E-4,3.5472E-4,2.4149E-4,1.6279E-4,1.8912E-4,1.8693E-4,3.5361E-4,2.4338E-4,1.6337E-4,1.8959E-4,1.8748E-4,3.4889E-4,2.438E-4,1.6237E-4,1.8971E-4,1.8678E-4,3.4766E-4,2.4635E-4,1.6221E-4,1.9013E-4,1.868E-4,3.4344E-4,2.4799E-4,1.6333E-4,1.9034E-4,1.8631E-4,3.4401E-4,2.5043E-4,1.6327E-4,1.8701E-4,1.8671E-4,3.4394E-4,2.5171E-4,1.634E-4,1.9025E-4,1.8625E-4,3.4111E-4,2.5459E-4,1.6155E-4,1.8869E-4,1.8688E-4,3.3809E-4,2.5529E-4,1.6122E-4,1.8775E-4,1.8727E-4,3.3635E-4,2.5985E-4,1.6247E-4,1.8847E-4,1.8466E-4,3.3487E-4,2.6029E-4,1.6205E-4,1.8881E-4,1.8552E-4,3.3107E-4,2.6614E-4,1.6311E-4,1.8831E-4,1.8531E-4,3.3176E-4,2.6661E-4,1.64E-4,1.8696E-4,1.8604E-4,3.2822E-4,2.6877E-4,1.6383E-4,1.8665E-4,1.8598E-4,3.2598E-4,2.7045E-4,1.6242E-4,1.8875E-4,1.8576E-4,3.2339E-4,2.7516E-4,1.618E-4,1.8721E-4,1.8604E-4,3.2087E-4,2.7617E-4,1.65E-4,1.8813E-4,1.8574E-4,3.1828E-4,2.7845E-4,1.6453E-4,1.8692E-4,1.8638E-4,3.1652E-4,2.7944E-4,1.6701E-4,1.8771E-4,1.8551E-4,3.1481E-4,2.8168E-4,1.6496E-4,1.8546E-4,1.8426E-4,3.1022E-4,2.8371E-4,1.651E-4,1.8857E-4,1.8613E-4,3.097E-4,2.8796E-4,1.6573E-4,1.8521E-4,1.8549E-4,3.0683E-4,2.8727E-4,1.6533E-4,1.8651E-4,1.8588E-4,3.0486E-4,2.9005E-4,1.6724E-4,1.8804E-4,1.8449E-4,3.0164E-4,2.9237E-4,1.6467E-4,1.8576E-4,1.8628E-4,3.0019E-4,2.954E-4,1.6377E-4:1
5.7667E-7,2.8667E-6,-3.15E-6,5.1667E-6,2.0733E-6,-3.8333E-6,6.0533E-6,-3.3233E-6,4.7667E-6,5.3E-7,-1.2567E-6,5.0067E-6,-1.72E-6,5.19E-6,1.1933E-6,3.0E-8,3.3367E-6,-3.2033E-6,4.2867E-6,9.6666E-8,-2.82E-6,3.03E-6,-3.0E-8,2.6867E-6,-6.2333E-7,-2.5267E-6,3.3367E-6,-4.06E-6,3.0767E-6,1.29E-6,-1.94E-6,3.7467E-6,-3.54E-6,9.4692E-4,5.9989E-4,4.6102E-4,5.0922E-4,5.7233E-4,9.0144E-4,6.5643E-4,5.1143E-4,5.2032E-4,6.4156E-4,9.3324E-4,6.9083E-4,5.3945E-4,5.3027E-4,5.3822E-4,7.2818E-4,6.2986E-4,4.2213E-4,4.3533E-4,5.4209E-4,7.1288E-4,6.4695E-4,4.1608E-4,4.2352E-4,5.2278E-4,6.9096E-4,6.5319E-4,4.1678E-4,4.1996E-4,5.2283E-4,6.7427E-4,6.4809E-4,4.1243E-4,4.0771E-4,4.7949E-4,6.9714E-4,5.2537E-4,3.7461E-4,3.6599E-4,3.9265E-4,6.7653E-4,5.1018E-4,3.6485E-4,3.6869E-4,3.8844E-4,6.6884E-4,5.141E-4,3.6495E-4,3.6847E-4,3.8666E-4,6.7059E-4,5.111E-4,3.623E-4,3.6587E-4,3.8382E-4,6.6762E-4,5.1304E-4,3.6396E-4,3.6405E-4,3.8394E-4,6.6054E-4,5.1518E-4,3.5878E-4,3.633E-4,3.8254E-4,6.5618E-4,5.1749E-4,3.5965E-4,3.6119E-4,3.8005E-4,6.5331E-4,5.1579E-4,3.5858E-4,3.605E-4,3.7827E-4,6.5035E-4,5.1595E-4,3.5737E-4,3.5892E-4,3.789E-4,6.4532E-4,5.1702E-4,3.5637E-4,3.6005E-4,3.7613E-4,6.3933E-4,5.189E-4,3.5795E-4,3.5875E-4,3.7698E-4,6.39E-4,5.2005E-4,3.566E-4,3.5447E-4,3.7669E-4,6.3269E-4,5.187E-4,3.5621E-4,3.5399E-4,3.7201E-4,6.2884E-4,5.1894E-4,3.5457E-4,3.5371E-4,3.7259E-4,6.2578E-4,5.2021E-4,3.5527E-4,3.5159E-4,3.7123E-4,6.1991E-4,5.2304E-4,3.5531E-4,3.523E-4,3.715E-4,6.2069E-4,5.2243E-4,3.5689E-4,3.5088E-4,3.7074E-4,6.164E-4,5.2246E-4,3.5414E-4,3.5192E-4,3.707E-4,6.1153E-4,5.2391E-4,3.5588E-4,3.4911E-4,3.7038E-4,6.108E-4,5.2707E-4,3.5673E-4,3.4811E-4,3.6908E-4,6.071E-4,5.2777E-4,3.5842E-4,3.4856E-4,3.7048E-4,6.0631E-4,5.3101E-4,3.5619E-4,3.4843E-4,3.694E-4,6.0244E-4,5.3252E-4,3.5547E-4,3.4867E-4,3.6768E-4,6.0021E-4,5.3443E-4,3.5622E-4,3.4736E-4,3.6704E-4,5.9569E-4,5.337E-4,3.5959E-4,3.4729E-4,3.6774E-4,5.9412E-4,5.363E-4,3.5554E-4,3.4671E-4,3.6735E-4,5.9124E-4,5.3729E-4,3.5678E-4,3.4514E-4,3.685E-4,5.8761E-4,5.4047E-4,3.576E-4,3.4292E-4,3.6724E-4,5.8844E-4,5.3736E-4,3.5685E-4,3.4284E-4,3.6557E-4,5.8727E-4,5.4125E-4,3.5854E-4,3.4406E-4,3.682E-4,5.8132E-4,5.428E-4,3.6054E-4,3.4268E-4,3.6463E-4,5.8074E-4,5.4613E-4,3.563E-4,3.4336E-4,3.6523E-4,5.7783E-4,5.4417E-4,3.5809E-4,3.4213E-4,3.6529E-4,5.7681E-4,5.4528E-4,3.6032E-4,3.4025E-4,3.6303E-4,5.7339E-4,5.4956E-4,3.5886E-4,3.426E-4,3.6407E-4,5.7642E-4,5.4892E-4,3.6116E-4,3.4172E-4,3.6337E-4,5.7021E-4,5.5002E-4,3.601E-4,3.4108E-4,3.6274E-4,5.6916E-4,5.5362E-4,3.6087E-4,3.4024E-4,3.6188E-4,5.6606E-4,5.5549E-4,3.5744E-4,3.4051E-4,3.6416E-4,5.6698E-4,5.5243E-4,3.608E-4,3.4169E-4,3.6388E-4,5.6273E-4,5.5694E-4,3.6412E-4,3.4071E-4,3.6421E-4,5.6165E-4,5.5623E-4,3.6453E-4,3.3903E-4,3.6286E-4,5.6019E-4,5.5708E-4,3.6188E-4,3.3921E-4,3.6389E-4,5.5692E-4,5.5567E-4,3.6248E-4,3.3724E-4,3.613E-4,5.5728E-4,5.5957E-4,3.6654E-4,3.3628E-4,3.5867E-4,5.5573E-4,5.6105E-4,3.6526E-4,3.3882E-4,3.6211E-4,5.4915E-4,5.6326E-4:1
3.65E-6,-1.2667E-6,2.26E-6,1.9167E-6,-3.88E-6,4.4967E-6,1.2867E-6,6.7667E-7,2.9333E-6,-4.39E-6,3.8133E-6,-1.8333E-6,2.6133E-6,2.9067E-6,-2.6933E-6,3.6767E-6,-3.7567E-6,2.7133E-6,2.78E-6,-2.38E-6,4.11E-6,-9.5E-7,2.1667E-6,4.6533E-6,-2.71E-6,5.07E-6,-5.0667E-7,3.1867E-6,3.6967E-6,-3.0767E-6,5.28E-6,-1.4033E-6,2.8533E-6,1.57E-6,5.3119E-4,4.9404E-4,8.9705E-4,7.2914E-4,5.1703E-4,5.3167E-4,5.8682E-4,9.128E-4,7.7824E-4,5.3737E-4,5.4315E-4,5.9847E-4,9.1873E-4,7.7693E-4,5.4714E-4,5.4749E-4,6.2882E-4,9.2097E-4,7.892E-4,5.5416E-4,5.4971E-4,6.3334E-4,9.1761E-4,6.5305E-4,4.615E-4,4.1268E-4,4.2275E-4,7.6135E-4,5.6941E-4,3.8488E-4,3.8797E-4,3.881E-4,6.364E-4,5.7624E-4,3.7918E-4,3.7906E-4,3.9357E-4,6.2778E-4,5.746E-4,3.8086E-4,3.7207E-4,3.8992E-4,6.1792E-4,5.7317E-4,3.7705E-4,3.6939E-4,3.8493E-4,6.1626E-4,5.7181E-4,3.7271E-4,3.6505E-4,3.8516E-4,6.1408E-4,5.6932E-4,3.755E-4,3.6451E-4,3.8406E-4,6.1243E-4,5.7204E-4,3.7365E-4,3.6498E-4,3.7943E-4,6.1E-4,5.6889E-4,3.6931E-4,3.6175E-4,3.8189E-4,6.0249E-4,5.6958E-4,3.6904E-4,3.6223E-4,3.8137E-4,5.9985E-4,5.6633E-4,3.6714E-4,3.5978E-4,3.7864E-4,5.9569E-4,5.7249E-4,3.6575E-4,3.595E-4,3.7886E-4,5.9637E-4,5.7207E-4,3.6239E-4,3.5947E-4,3.7802E-4,5.9017E-4,5.6998E-4,3.6385E-4,3.5482E-4,3.7775E-4,5.9088E-4,5.7292E-4,3.6559E-4,3.5494E-4,3.7601E-4,5.8973E-4,5.717E-4,3.658E-4,3.5871E-4,3.771E-4,5.8857E-4,5.7188E-4,3.6326E-4,3.5607E-4,3.74E-4,5.854E-4,5.7275E-4,3.6402E-4,3.5147E-4,3.7479E-4,5.8371E-4,5.7288E-4,3.6464E-4,3.5428E-4,3.7435E-4,5.8375E-4,5.7166E-4,3.6494E-4,3.5563E-4,3.7377E-4,5.8066E-4,5.7571E-4,3.6295E-4,3.5468E-4,3.7525E-4,5.7894E-4,5.7507E-4,3.6486E-4,3.5271E-4,3.7138E-4,5.7948E-4,5.749E-4,3.6393E-4,3.5312E-4,3.7238E-4,5.745E-4,5.78E-4,3.6722E-4,3.52E-4,3.7332E-4,5.7416E-4,5.7543E-4,3.6272E-4,3.5402E-4,3.7344E-4,5.6985E-4,5.7881E-4,3.6589E-4,3.5055E-4,3.7258E-4,5.7127E-4,5.747E-4,3.6364E-4,3.5181E-4,3.7167E-4,5.674E-4,5.7777E-4,3.666E-4,3.4886E-4,3.693E-4,5.682E-4,5.7713E-4,3.655E-4,3.4937E-4,3.7184E-4,5.6277E-4,5.8054E-4,3.6263E-4,3.4775E-4,3.7095E-4,5.6408E-4,5.8321E-4,3.6735E-4,3.4994E-4,3.7255E-4,5.6089E-4,5.7937E-4,3.6882E-4,3.4855E-4,3.7118E-4,5.6141E-4,5.859E-4,3.6611E-4,3.4958E-4,3.6977E-4,5.5625E-4,5.8426E-4,3.6839E-4,3.4932E-4,3.7078E-4,5.5475E-4,5.803E-4,3.6456E-4,3.4853E-4,3.7169E-4,5.542E-4,5.8454E-4,3.6581E-4,3.4859E-4,3.7019E-4,5.5122E-4,5.85E-4,3.6814E-4,3.4595E-4,3.6899E-4,5.5117E-4,5.8943E-4,3.6659E-4,3.4532E-4,3.6855E-4,5.5307E-4,5.8463E-4,3.6679E-4,3.4756E-4,3.6874E-4,5.4999E-4,5.8623E-4,3.6893E-4,3.4885E-4,3.6722E-4,5.4825E-4,5.8749E-4,3.6783E-4,3.4733E-4,3.6748E-4,5.4559E-4,5.8982E-4,3.6795E-4,3.4522E-4,3.6851E-4,5.4347E-4,5.9012E-4,3.709E-4,3.4686E-4,3.6681E-4,5.4256E-4,5.9275E-4,3.686E-4,3.4376E-4,3.6797E-4,5.4094E-4,5.9258E-4,3.6978E-4,3.4386E-4,3.681E-4,5.354E-4,5.9307E-4,3.7023E-4,3.4218E-4,3.6553E-4,5.3961E-4,5.9595E-4,3.7141E-4,3.4504E-4,3.6692E-4,5.3721E-4,5.9599E-4,3.7005E-4,3.4316E-4,3.6466E-4,5.357E-4,5.9767E-4,3.6959E-4,3.4578E-4,3.6527E-4,5.3304E-4,5.9649E-4,3.6996E-4,3.4217E-4,3.6522E-4,5.3056E-4,5.9665E-4,3.7101E-4,3.4511E-4,3.6448E-4,5.2924E-4,5.962E-4,3.7095E-4,3.4361E-4,3.6293E-4,5.2722E-4,5.9928E-4,3.7126E-4,3.4339E-4,3.6694E-4,5.2642E-4,6.0269E-4,3.7205E-4,3.4375E-4,3.6364E-4,5.2274E-4,6.0476E-4,3.736E-4,3.4353E-4,3.6385E-4,5.2299E-4,6.0327E-4,3.7407E-4,3.4347E-4,3.6385E-4,5.1941E-4,6.0534E-4,3.7258E-4,3.409E-4,3.6234E-4,5.1899E-4,6.0532E-4,3.7226E-4,3.4225E-4,3.6477E-4,5.1723E-4,6.0359E-4,3.7528E-4,3.426E-4,3.6447E-4,5.1421E-4,6.0877E-4,3.7454E-4,3.4093E-4,3.6019E-4,5.1359E-4,6.073E-4,3.7551E-4,3.4171E-4,3.6465E-4,5.1085E-4,6.1185E-4,3.7637E-4,3.4043E-4,3.6258E-4,5.1026E-4,6.112E-4,3.737E-4,3.3945E-4,3.627E-4,5.0807E-4,6.1259E-4,3.7667E-4,3.3924E-4,3.608E-4,5.0639E-4,6.1496E-4,3.776E-4,3.3822E-4,3.6286E-4,5.0268E-4,6.1488E-4,-1.672E-5:1
-4.6479E-4,-0.02317,0.020959,-0.021694,0.005926,-0.0016379,-0.019821,0.019778,-0.020521,0.012266,0.0089816,-0.027417,0.02502,-0.021713,0.0051997,-0.0067272,-0.020754,0.024066,-0.028405,0.0061863,0.0022319,-0.021209,0.016012,-0.02302,0.01383,-5.9712E-4,-0.0229,0.025083,-0.026679,0.0070246,-0.01191,-0.023796,0.017614,-0.017632,1.7823E-4,-0.0041684,-0.026842,0.018683,-0.018787,0.010221,-4.8426E-4,-0.027281,0.017255,-0.016349,-0.0074416,0.0038421,-0.025121,0.02197,-0.027999,0.0031121,0.0052533,-0.026389,0.011694,-0.019128,0.005909,-0.013181,-0.023816,0.021538,-0.022872,0.0017573,-4.6436E-4,-0.017776,0.022091,-0.022734,0.013745,-9.8192E-4,-0.027617,0.015559,-0.031085,0.0029857,0.0025082,-0.026512,0.016526,-0.019651,0.0014726,0.0013655,-0.02459,0.017782,-0.018309,2.1946E-4,0.0052884,-0.03266,0.021477,-0.0155,0.0033994,-0.0049559,-0.017435,0.022356,-0.028681,0.0017661,-0.002872,-0.024449,0.01803,-0.024223,0.019593,-0.0038496,-0.023681,0.023586,-0.02193,0.0031693,-0.0012396,-0.017017,0.019287,-0.02078,0.004888,0.0033166,-0.025886,0.017742,-0.026415,0.0042032,0.0041927,-0.028114,0.021814,-0.029244,0.0078158,0.0039814,0.91141,1.7794,2.3057,2.2448,0.75417,0.57631,0.73524,0.71808,1.3661,0.63317,0.54978,0.68685,0.69043,1.3379,0.64659,0.5572,0.67794,0.68217,1.3399,0.62245,0.55232,0.67427,0.68675,1.314,0.63084,0.56004,0.67601,0.68706,1.3172,0.62217,0.55666,0.67294,0.69043,1.3015,0.62365,0.5518,0.6703,0.69392,1.3021,0.61309,0.55116,0.67646,0.70173,1.2997,0.60684,0.55141,0.67331,0.70195,1.2823,0.59977,0.55238,0.67276,0.70791,1.2817,0.60541,0.55419,0.66814,0.72384,1.2676,0.60115,0.5517,0.66851,0.72787,1.2553,0.61175,0.55741,0.67354,0.74112,1.258,0.6026,0.55104,0.67408,0.73789,1.2438,0.60171,0.54947,0.66667,0.74652,1.2553,0.59057,0.55877,0.67719,0.7559,1.2433,0.58634,0.55079,0.6643,0.75778,1.2462,0.57415,0.5561,0.66995,0.76673,1.2287,0.57613,0.55851,0.66542,0.77067,1.2295,0.57699,0.54864,0.66667,0.78097,1.2176,0.58553,0.5553,0.67275,0.79459,1.2107,0.58277,0.55457,0.67506,0.79824,1.2001,0.57515,0.55736,0.66754,0.8062,1.2037,0.57253,0.55499,0.67577,0.81481,1.186,0.57009,0.55944,0.67191,0.81298,1.1865,0.56181,0.55538,0.67046,0.83016,1.173,0.55993,0.55589,0.66856,0.84225,1.1616,0.56344,0.56199,0.67125,0.85065,1.1567,0.56872,0.55108,0.66672,0.85807,1.1542,0.5541,0.5576,0.67165,0.86119,1.13,0.5604,0.5616,0.67144,0.87673,1.1278,0.55525,0.55615,0.66609,0.88479,1.1247,0.55556,0.56178,0.66832,0.889,1.1123,0.55362,0.56407,0.66848,0.89817,1.1001,0.55218,0.56645,0.67378,0.90168,1.0971,0.55346,0.55895,0.66732,0.90895,1.094,0.55544,0.56398,0.67643,0.92,1.0844,0.55382,0.55972,0.67035,0.92606,1.0793,0.55313,0.56017,0.67071,0.92889,1.0704,0.54432,0.56571,0.67273,0.9371,1.078,0.55281,0.56945,0.67138,0.95155,1.0631,0.54258,0.56323,0.66718,0.94732,1.0666,0.54342,0.5649,0.66502,0.95948,1.0476,0.53463,0.56962,0.67571,0.97242,1.032,0.54502,0.56433,0.66899,0.96659,1.0326,0.54428,0.56537,0.66506,0.97436,1.0332,0.54738,0.56601,0.67429,0.98843,1.0227,0.53414,0.56667,0.67463,0.99382,1.0239,0.54343,0.57125,0.67058,0.99402,1.0141,0.53961,0.57224,0.67551,0.99181,1.0153,0.54328,0.56571,0.66512,0.99583,1.001,0.53615,0.57043,0.67335,1.0116,0.99488,0.53885,0.57074,0.67117,1.0185,0.98981,0.53879,0.56702,0.66744,1.0278,0.9804,0.53962,0.57684,0.67303,1.022,0.97884,0.53754,0.56987,0.67266,1.0309,0.96424,0.54005,0.57032,0.67285,1.0362,0.97203,0.54266,0.5785,0.67245,1.0431,0.9667,0.53817,0.57661,0.6716,1.0512,0.96721,0.53344,0.57394,0.67154,1.0491,0.95554,0.54442,0.57521,0.67035,0.73622:1
0.012585,-0.021885,0.016886,-0.017498,0.0048863,0.0019538,-0.014227,0.023893,-0.020168,-0.0018556,0.0096029,-0.016937,0.016808,-0.018721,0.0079527,0.0020047,-0.022642,0.020609,-0.0219,0.0035946,0.0066907,-0.024546,0.013037,-0.015415,0.0094722,0.0055087,-0.019287,0.014231,-0.01959,-0.0025944,0.0081791,-0.023047,0.012884,-0.010622,-0.0027339,0.0032169,2.2948,1.696,1.3132,1.3502,0.72321,0.71443,0.79577,1.086,1.2599,0.68791,0.68354,0.77201,1.0663,1.2391,0.66836,0.68001,0.76515,1.0651,1.233,0.66595,0.67519,0.76224,1.0771,1.221,0.66324,0.6751,0.76237,1.0767,1.2165,0.665,0.66743,0.76151,1.0575,1.2073,0.65667,0.66258,0.75855,1.0718,1.1997,0.65624,0.66127,0.75771,1.0704,1.1908,0.65054,0.66048,0.75896,1.0724,1.1837,0.6442,0.66472,0.75379,1.0717,1.1896,0.64448,0.66438,0.75218,1.0799,1.1831,0.63223,0.66274,0.7473,1.0784,1.1803,0.6434,0.65491,0.74906,1.0842,1.1685,0.63568,0.65741,0.75838,1.0893,1.1547,0.64049,0.65006,0.74613,1.0947,1.1517,0.64246,0.65111,0.75674,1.1007,1.1497,0.63325,0.65765,0.751,1.0955,1.1425,0.62955,0.64786,0.74171,1.0964,1.1485,0.61822,0.65291,0.73515,1.094,1.1359,0.62949,0.65686,0.74665,1.0993,1.1305,0.62717,0.65536,0.74545,1.1049,1.1338,0.62267,0.65272,0.74672,1.1074,1.1259,0.62345,0.64497,0.741,1.1018,1.1261,0.6242,0.65066,0.74229,1.1085,1.1191,0.61864,0.64529,0.74243,1.1109,1.1081,0.6185,0.643,0.74718,1.1058,1.1064,0.6136,0.64784,0.73077,1.1166,1.1109,0.60969,0.65268,0.74047,1.1178,1.0876,0.62931,0.6387,0.73935,1.1249,1.1014,0.61397,0.65061,0.74888,1.1229,1.0856,0.61801,0.64522,0.73473,1.1169,1.0955,0.61598,0.64313,0.73741,1.1286,1.0787,0.60579,0.64424,0.73301,1.1093,1.0816,0.60554,0.64715,0.73137,1.1149,1.0703,0.61169,0.64311,0.72627,1.1223,1.0756,0.60093,0.64065,0.72768,1.1182,1.0619,0.59957,0.63318,0.72654,1.1242,1.063,0.60212,0.63607,0.73222,1.1352,1.047,0.60277,0.63543,0.73391,1.1314,1.0492,0.60231,0.62904,0.7312,1.1386,1.0412,0.60382,0.63555,0.72794,1.1323,1.0239,0.59745,0.63883,0.7255,1.1296,1.0385,0.59038,0.63439,0.72689,1.1357,1.0338,0.59143,0.627,0.72517,1.1415,1.0257,0.59115,0.63179,0.72089,1.1466,1.0186,0.58661,0.63504,0.72263,1.1536,1.0175,0.58888,0.63605,0.72918,1.1461,1.0206,0.59388,0.6401,0.72903,1.1538,1.0141,0.59869,0.63206,0.71815,1.1623,0.99403,0.59359,0.64002,0.72858,1.1621,0.99485,0.59539,0.63256,0.72251,1.168,0.995,0.59744,0.63661,0.72679,1.1713,0.9854,0.59642,0.63117,0.71723,1.174,0.98377,0.59023,0.62931,0.71946,1.1788,0.98321,0.59653,0.62869,0.72547,1.1819,0.98087,0.59649,0.63126,0.71723,1.1781,0.98286,0.59488,0.64161,0.71594,1.1828,0.97889,0.58999,0.63552,0.72381,1.1771,0.97212,0.59222,0.63597,0.71567,1.1894,0.97191,0.58662,0.6357,0.72237,1.1926,0.95186,0.58797,0.63484,0.72243,1.1991,0.95606,0.59376,0.63317,0.71775,1.205,0.9384,0.59237,0.63738,0.72076,1.1976,0.94238,0.58921,0.63685,0.72387,1.2053,0.93965,0.59462,0.6326,0.72481,1.2021,0.94453,0.59227,0.63795,0.72089,1.2084,0.93752,0.59928,0.64008,0.7189,1.2107,0.94103,0.59359,0.63685,0.7267,1.2128,0.93043,0.58615,0.63112,0.72356,1.2155,0.90894,0.60691,0.63071,0.72147,1.2244,0.9157,0.60565,0.62878,0.7206,1.2271,0.90512,0.59859,0.6379,0.7222,1.2299,0.90363,0.6,0.63987,0.71417,1.2369,0.90868,0.59487,0.64131,0.72566,1.2339,0.89697,0.59543,0.64082,0.72138,0.76975:1
0.015563,-0.0022609,-0.0096357,0.020156,-0.023081,0.013611,-0.0079108,-0.0070642,0.01721,-0.020283,0.012819,-0.0058072,-0.011611,0.019679,-0.019185,0.015605,0.0024819,-0.0067798,0.013349,-0.019632,0.015037,-0.012145,-0.011787,0.016864,-0.016813,0.016726,-0.0029462,-0.01138,0.017148,-0.030693,0.014694,-0.0093908,-0.015687,0.016667,-0.016837,0.015172,-0.014285,-0.0078668,0.013332,-0.016136,0.012467,-0.010393,0.15544,0.2462,0.029864,0.1947,0.21212,0.017015,0.11539,0.073119,0.20073,0.24509,0.026991,0.12538,0.074742,0.2052,0.2428,0.025043,0.11961,0.077976,0.20662,0.25145,0.031959,0.12597,0.0797,0.20191,0.25914,0.030797,0.12082,0.076386,0.19875,0.26424,0.038008,0.11719,0.08019,0.19665,0.25318,0.040875,0.11832,0.087507,0.19278,0.26088,0.034652,0.1221,0.07866,0.19707,0.27052,0.036076,0.11953,0.085814,0.19586,0.27562,0.033469,0.11866,0.080705,0.18929,0.27613,0.033378,0.12287,0.089905,0.18637,0.27884,0.035448,0.12552,0.084526,0.18554,0.27146,0.040162,0.11507,0.076064,0.17881,0.28933,0.02931,0.11832,0.087612,0.18081,0.28531,0.032578,0.11543,0.084685,0.17757,0.28695,0.03102,0.11404,0.084681,0.17106,0.29431,0.035978,0.11878,0.083166,0.17162,0.2936,0.040479,0.1213,0.083077,0.17059,0.29692,0.044502,0.11254,0.080635,0.16301,0.30033,0.040476,0.11839,0.082757,0.16367,0.30104,0.037246,0.11918,0.081144,0.15951,0.29783,0.044319,0.11547,0.078983,0.15537,0.30542,0.040141,0.11624,0.08013,0.15715,0.31226,0.043287,0.11349,0.081813,0.15495,0.30543,0.047548,0.11682,0.084723,0.14802,0.29747,0.042929,0.11416,0.078204,0.15466,0.31153,0.046499,0.10617,0.084331,0.14735,0.30677,0.049264,0.11146,0.080692,0.15805,0.31194,0.043916,0.10884,0.078306,0.15272,0.30723,0.049518,0.10748,0.081163,0.14942,0.31058,0.04236,0.11127,0.081021,0.15472,0.30545,0.050584,0.11081,0.076227,0.14518,0.30473,0.044121,0.1084,0.079621,0.14596,0.30184,0.049468,0.11048,0.083012,0.15552,0.31037,0.053691,0.11382,0.077879,0.15352,0.30059,0.050284,0.10091,0.085998,0.14902,0.30396,0.060692,0.11405,0.083605,0.15219,0.29752,0.051137,0.10895,0.082218,0.15018,0.302,0.055025,0.10574,0.077812,0.14298,0.3085,0.059395,0.10737,0.081138,0.14657,0.29376,0.065094,0.10217,0.077219,0.15392,0.2964,0.057675,0.095552,0.080644,0.15084,0.29448,0.058658,0.10146,0.077718,0.1433,0.28994,0.064653,0.099466,0.076094,0.14699,0.29799,0.056151,0.10446,0.077207,0.14795,0.29424,0.074152,0.10109,0.079587,0.14912,0.29024,0.067778,0.099002,0.079686,0.15199,0.29719,0.073419,0.098136,0.077148,0.15006,0.29797,0.067753,0.10345,0.081541,0.15109,0.29418,0.07371,0.098245,0.081907,0.14967,0.29092,0.074535,0.092521,0.081444,0.148,0.2932,0.076334,0.092673,0.080091,0.14826,0.29625,0.077234,0.10438,0.079948,0.14892,0.29404,0.076811,0.098796,0.080345,0.14506,0.29156,0.080472,0.093027,0.082104,0.14876,0.28208,0.07913,0.10117,0.083321,0.14872,0.28582,0.085392,0.090515,0.079888,0.14532,0.29116,0.087276,0.096707,0.078287,0.14733,0.27717,0.08924,0.088383,0.085134,0.14918,0.28389,0.083988,0.09115,0.080334,0.14845,0.27789,0.085255,0.092098,0.081845,0.14826,0.28336,0.096598,0.093615,0.077329,0.15006,0.27779,0.097248,0.087637,0.081772,0.14573,0.2848,0.098957,0.091342,0.079422,0.1469,0.27063,0.10572,0.08894,0.077799,0.14684,0.27854,0.10355,0.085672,0.074931,0.14927,0.2632,0.10301,0.086517,0.074974,0.14902,0.26719,0.10488,0.085524,0.077197,0.15323,0.26856,0.11314,0.079786,0.069272,0.14458,0.26831,0.10426,0.083184,0.071065,0.15143,0.26427,0.12097,0.086029,0.076156,0.15273,0.2668,0.11989,0.083364,0.075735,0.15353,0.26108,0.1223,0.083069,0.078892,0.14987,0.26214,0.11928,0.085456,0.073706,0.15376,0.26474,0.1267,0.081924,0.076042,0.1554,0.2532,0.12524,-0.073448:1
0.0015202,-0.016073,0.018406,-0.021723,0.0061042,0.0026831,-0.018155,0.01629,-0.022011,0.0038044,0.0083488,-0.011282,0.018901,-0.01645,-0.0023832,0.0051693,-0.020086,0.017057,-0.019305,0.006484,0.0040215,-0.019485,0.015672,-0.015286,0.0024378,0.0020167,-0.023092,0.020101,-0.023369,0.0080368,-7.5423E-4,-0.012271,0.018391,-0.018052,0.012729,0.0027586,-0.022616,0.013667,-0.019229,1.2051,0.24808,0.17732,0.29371,0.21921,0.5216,0.22958,0.17773,0.25233,0.21407,0.49299,0.20896,0.16722,0.23862,0.20381,0.46763,0.19853,0.15767,0.23748,0.19909,0.46279,0.19557,0.15391,0.22656,0.18547,0.45287,0.19204,0.14722,0.21565,0.18372,0.44505,0.18409,0.1384,0.21989,0.17302,0.42776,0.1851,0.13284,0.21446,0.16896,0.42527,0.18123,0.13089,0.2097,0.16601,0.41783,0.1829,0.1268,0.20897,0.16601,0.4228,0.17464,0.13101,0.20052,0.16368,0.4129,0.16663,0.12165,0.20229,0.16659,0.40972,0.17691,0.12469,0.19101,0.15304,0.40018,0.17329,0.11722,0.19361,0.15273,0.39943,0.18684,0.11289,0.1865,0.15299,0.40206,0.17598,0.11333,0.19353,0.15537,0.39377,0.1734,0.11496,0.19335,0.14364,0.38651,0.1808,0.11134,0.18617,0.14836,0.38165,0.18767,0.10605,0.19539,0.14739,0.37365,0.18257,0.10713,0.18756,0.14289,0.37818,0.17922,0.10877,0.18704,0.15245,0.37182,0.19148,0.1028,0.19084,0.14083,0.368,0.19754,0.10245,0.17815,0.14073,0.36769,0.19105,0.099468,0.17831,0.14587,0.35712,0.20298,0.10452,0.18289,0.14764,0.35543,0.19433,0.10409,0.17629,0.14479,0.35315,0.2136,0.091716,0.17571,0.13861,0.34988,0.20527,0.10027,0.17472,0.138,0.33443,0.21323,0.088268,0.17374,0.13937,0.33861,0.22593,0.08782,0.17276,0.13741,0.32779,0.21246,0.080356,0.17284,0.13743,0.32719,0.21985,0.085476,0.17162,0.13765,0.32519,0.22455,0.084132,0.16936,0.13726,0.33264,0.23326,0.088949,0.17036,0.13194,0.31562,0.23379,0.083917,0.1706,0.13042,0.31708,0.23858,0.079354,0.16359,0.13013,0.30821,0.24211,0.082083,0.16354,0.12498,0.309,0.24828,0.080763,0.1653,0.13015,0.30458,0.25642,0.076113,0.16444,0.13275,0.29878,0.25001,0.084978,0.16478,0.12662,0.29672,0.26232,0.084138,0.1612,0.12939,0.28347,0.26884,0.077072,0.16374,0.12466,0.28366,0.27433,0.080138,0.15919,0.13139,0.28434,0.27415,0.077704,0.1587,0.12603,0.27738,0.27388,0.072076,0.1558,0.11967,0.27075,0.27689,0.075004,0.16113,0.13177,0.27353,0.28101,0.077079,0.1595,0.12882,0.26306,0.29254,0.070145,0.15653,0.12757,0.26316,0.29342,0.075729,0.155,0.12675,0.25815,0.30189,0.071491,0.15428,0.12164,0.25245,0.29757,0.080947,0.1588,0.12849,0.24163,0.30352,0.079965,0.1549,0.12116,0.24643,0.31224,0.076733,0.15105,0.11803,0.2369,0.31379,0.074288,0.1543,0.12474,0.22885,0.31951,0.073511,0.15013,0.1174,0.22688,0.32054,0.069957,0.14862,0.11685,0.21679,0.32213,0.079545,0.14127,0.11917,0.21349,0.33152,0.065969,0.14043,0.11784,0.21896,0.32589,0.06838,0.14356,0.11741,0.20337,0.33336,0.074508,0.14938,0.11541,0.20822,0.33604,0.073939,0.13836,0.11573,0.20173,0.34881,0.071561,0.1455,0.11312,0.19125,0.34876,0.081127,0.13981,0.12258,0.1897,0.35247,0.084957,0.138,0.11458,0.18915,0.3556,0.080932,0.13745,0.11877,0.1795,0.35024,0.091372,0.13668,0.11241,0.17979,0.35716,0.083801,0.12781,0.1143,0.17486,0.35366,0.081194,0.13196,0.1199,0.17817,0.36378,0.086553,0.13903,0.11992,0.17552,0.36156,0.090981,0.12872,0.11333,0.17758,0.35594,0.088739,0.13428,0.11107,0.17346,0.35839,0.089725,0.1396,0.11358,0.18403,0.35202,0.099127,0.1309,0.10747,0.17699,0.34498,0.10008,0.12824,0.10898,0.17689,0.35117,0.099662,0.12757,0.11398,0.17778,0.3478,0.10393,0.12339,0.11445,0.17581,0.35208,0.10343,0.12377,0.11353,0.17746,0.34251,0.1071,0.12568,0.10994,0.17863,0.34112,0.10967,0.12198,0.11486,0.17485,0.33506,0.11568,0.12125,0.10916,0.1778,0.34133,0.11512,0.12465,0.11009,0.17419,0.32846,-0.053468:1
0.011442,-0.021873,0.019263,-0.011802,-0.01239,0.015391,-0.027834,0.022119,-0.0087708,-0.0051673,0.013869,-0.028757,0.013437,-0.016245,-2.4182E-4,0.01368,-0.020263,0.022015,-0.012652,-0.0039367,0.006116,0.26163,0.42829,0.29489,0.1092,0.099611,0.07873,0.15714,0.29907,0.10569,0.10806,0.087648,0.15596,0.29794,0.10651,0.10059,0.087577,0.16192,0.29857,0.11578,0.097114,0.094337,0.16151,0.29014,0.1122,0.096733,0.090066,0.16026,0.29146,0.11883,0.10383,0.087339,0.16114,0.29038,0.11539,0.093815,0.094575,0.15905,0.28552,0.12045,0.091397,0.084046,0.16426,0.27995,0.12905,0.086559,0.074874,0.16313,0.27749,0.12519,0.084173,0.08116,0.16149,0.28015,0.13637,0.090787,0.07987,0.16271,0.27326,0.14047,0.092216,0.088386,0.16412,0.2697,0.14675,0.089277,0.087303,0.16111,0.26137,0.14855,0.093653,0.086512,0.15849,0.26084,0.15441,0.088905,0.079698,0.15671,0.2653,0.16324,0.076855,0.083954,0.15994,0.25772,0.16253,0.083314,0.084503,0.16559,0.2664,0.17153,0.082697,0.076346,0.15986,0.25351,0.17542,0.082678,0.080046,0.15687,0.24916,0.17451,0.078016,0.077204,0.16336,0.24684,0.18217,0.082136,0.08665,0.15447,0.24122,0.18498,0.066348,0.078851,0.16337,0.23683,0.18928,0.076513,0.082355,0.15606,0.2294,0.18448,0.07378,0.073524,0.15205,0.23141,0.19702,0.075764,0.077244,0.15346,0.23077,0.20169,0.070731,0.078646,0.16492,0.2225,0.21134,0.065408,0.075873,0.15624,0.22151,0.21075,0.062278,0.079832,0.15648,0.21988,0.21389,0.071838,0.078154,0.15748,0.20773,0.21953,0.062604,0.073268,0.15473,0.21312,0.23379,0.067225,0.074524,0.15595,0.2057,0.23349,0.060498,0.075208,0.15492,0.20377,0.2319,0.068215,0.073739,0.15815,0.19704,0.24216,0.065955,0.073818,0.1575,0.19348,0.24751,0.06318,0.074203,0.15274,0.18553,0.25877,0.058557,0.076779,0.15472,0.18073,0.25556,0.05318,0.072813,0.16071,0.18172,0.25983,0.066829,0.072542,0.1508,0.17084,0.26594,0.062006,0.073718,0.15344,0.17315,0.27123,0.059773,0.080258,0.15267,0.1736,0.28677,0.056856,0.072288,0.15264,0.16552,0.28335,0.067419,0.068045,0.14948,0.16097,0.28868,0.059275,0.072882,0.16107,0.14735,0.29506,0.059628,0.066783,0.15666,0.14313,0.29173,0.061803,0.072338,0.16134,0.14497,0.30288,0.05523,0.073063,0.14609,0.14836,0.30258,0.064669,0.057097,0.1557,0.13108,0.31021,0.055207,0.072216,0.14854,0.1292,0.3126,0.058108,0.065054,0.15014,0.13714,0.32633,0.054799,0.077955,0.14936,0.12848,0.32493,0.061421,0.070256,0.15526,0.12026,0.32793,0.058762,0.068015,0.14923,0.11496,0.32704,0.069292,0.061553,0.15588,0.11517,0.33639,0.059621,0.065801,0.14786,0.1094,0.33347,0.064951,0.073191,0.15052,0.10531,0.34227,0.069372,0.068567,0.15216,0.1047,0.33167,0.068509,0.069527,0.14438,0.10235,0.33067,0.070079,0.062614,0.15077,0.10096,0.34069,0.075804,0.059548,0.1452,0.10377,0.33722,0.064273,0.063771,0.14731,0.10759,0.33627,0.071847,0.070235,0.14552,0.10403,0.34454,0.068618,0.067863,0.14409,0.094909,0.3452,0.069438,0.06152,0.14635,0.10078,0.33663,0.077674,0.058961,0.1528,0.09005,0.34324,0.071154,0.058033,0.14874,0.099238,0.33901,0.072162,0.056611,0.14897,0.095248,0.3407,0.080181,0.059293,0.15058,0.10107,0.33727,0.084103,0.051895,0.15046,0.10152,0.3288,0.084255,0.06841,0.14717,0.098684,0.33571,0.087516,0.059632,0.14613,0.097261,0.33869,0.085132,0.056831,0.14109,0.097083,0.3385,0.093255,0.059812,0.14301,0.09447,0.32656,0.10008,0.052618,0.1493,0.096722,0.32762,0.09699,0.053484,0.14954,0.093554,0.33752,0.10056,0.054836,0.14392,0.1037,0.32849,0.10135,0.052793,0.14294,0.10653,0.32971,0.097627,0.06146,0.13394,0.10359,0.31824,0.10371,0.049152,0.14116,0.099127,0.31609,0.10132,0.1336:1
-0.034024,0.031141,-0.018539,-3.3184E-4,0.0074667,-0.033105,0.02896,-0.017421,0.0051818,0.0092013,-0.040614,0.029276,-0.020385,0.0096088,0.013925,-0.030093,0.029792,-0.02027,0.010138,0.011212,-0.039808,0.038468,-0.023991,0.0060147,0.021218,-0.028885,0.031682,-0.028292,0.004664,0.012138,-0.028872,0.032075,-0.015634,-0.0048595,3.8001,3.147,3.4988,4.6383,3.5322,2.6876,2.7573,3.5662,4.8018,3.649,2.7607,2.8813,3.7439,4.9625,3.6608,2.5831,2.5705,3.1859,4.5802,3.3379,2.4392,2.4009,2.1929,2.8451,1.8995,1.3304,1.3644,1.5029,2.544,1.836,1.3035,1.3434,1.4728,2.5264,1.8148,1.2993,1.3384,1.4708,2.5279,1.7991,1.286,1.321,1.4639,2.516,1.7628,1.2767,1.3121,1.456,2.5039,1.7489,1.2721,1.3076,1.4431,2.4811,1.7397,1.2638,1.2979,1.4357,2.4748,1.7178,1.2621,1.2918,1.4266,2.4885,1.6964,1.2566,1.2964,1.4176,2.4737,1.6906,1.2525,1.2885,1.4166,2.4655,1.6841,1.2428,1.2757,1.4016,2.4638,1.6639,1.2388,1.2787,1.408,2.4573,1.6603,1.2397,1.28,1.4027,2.472,1.6403,1.2297,1.277,1.4011,2.4663,1.6352,1.2326,1.2764,1.3964,2.4804,1.6238,1.233,1.2733,1.3997,2.4736,1.6194,1.236,1.2773,1.3978,2.4874,1.612,1.2308,1.2727,1.3949,2.4915,1.5916,1.2343,1.2777,1.3945,2.5016,1.5846,1.235,1.2632,1.3948,2.4992,1.5687,1.2311,1.2689,1.3965,2.4985,1.5574,1.2357,1.266,1.395,2.5158,1.5587,1.2435,1.2776,1.3996,2.5133,1.5379,1.2399,1.263,1.3924,2.5217,1.5402,1.2329,1.2712,1.3918,2.5183,1.5392,1.2296,1.2767,1.3926,2.5208,1.5247,1.2348,1.268,1.3838,2.5371,1.5147,1.2363,1.2669,1.3864,2.5429,1.4947,1.2394,1.2675,1.3877,2.5481,1.496,1.2408,1.2638,1.3867,2.5396,1.4992,1.2348,1.2653,1.3895,2.5517,1.4886,1.2416,1.2644,1.3864,2.5477,1.4973,1.2411,1.2654,1.3854,2.5643,1.4729,1.2359,1.2659,1.3861,2.5738,1.4712,1.2341,1.2708,1.3892,2.5705,1.4573,1.241,1.2661,1.3925,2.5829,1.4551,1.2407,1.2678,1.3861,2.5861,1.4436,1.2463,1.2683,1.3879,2.5837,1.4357,1.2382,1.2651,1.3935,2.5907,1.4424,1.2357,1.2692,1.3849,2.5842,1.4317,1.2452,1.268,1.3838,2.6085,1.4208,1.2384,1.2672,1.3844,2.6023,1.4226,1.2419,1.2695,1.3856,2.6072,1.4002,1.2416,1.2636,1.3811,2.6134,1.3966,1.2404,1.2689,1.3809,2.6104,1.3917,1.2486,1.2756,1.3869,2.6134,1.3976,1.2488,1.2762,1.3915,2.6165,1.3846,1.2475,1.276,1.3885,2.6219,1.38,1.2524,1.2735,1.3903,2.6309,1.3739,1.2447,1.2688,1.3862,2.6302,1.3728,1.2487,1.2799,1.3905,2.6362,1.3597,1.2419,1.2788,1.3884,2.6355,1.3574,1.2468,1.2757,1.3949,2.6439,1.3478,1.2484,1.2759,1.3981,2.6403,1.3467,1.2502,1.2744,1.397,2.6401,1.3499,1.2489,1.2773,1.4009,2.6421,1.3407,1.2478,1.2783,1.403,2.6375,1.3366,1.2513,1.2865,1.4079,2.6367,1.3233,1.259,1.2797,1.4047,2.6419,1.3231,1.2565,1.2805,1.4137,2.629,1.326,1.2452,1.2774,1.4127,2.6347,1.3086,1.2604,1.2785,1.4233,2.627,1.308,1.2557,1.281,1.4282,2.625,1.3026,1.2544,1.2757,1.4383,2.6178,1.3064,1.2625,1.2808,1.4439,2.6197,1.2969,1.2519,1.2791,1.4594,2.6171,1.3,1.2564,1.2804,1.4599,2.6159,1.2929,1.2628,1.2804,1.473,2.6059,1.2796,1.2577,1.2785,1.4851,2.6008,1.2804,1.2539,1.272,1.4978,2.5941,1.2758,1.2609,1.2812,1.5097,2.5687,1.2672,1.2605,1.2774,1.5405,2.5298,1.2743,1.2652,1.2793,1.5588,2.5283,1.2518,1.2679,1.2812,1.5808,2.5091,1.2501,1.2682,1.2814,1.603,2.4968,1.2495,1.2625,1.2808,1.6081,2.4805,1.2447,1.2645,1.2879,1.6216,2.4738,1.2405,1.2649,1.2772,1.6459,2.4525,1.2486,1.2604,1.287,1.6499,2.4425,1.2476,1.2642,1.2854,1.6684,2.4348,1.2411,1.27,1.2838,1.6919,2.4032,-0.12215:1
0.020256,0.0049451,-0.020933,0.026747,-0.033239,0.01886,-0.001806,-0.021208,0.032638,-0.031157,0.024024,0.0017703,-0.02646,0.029672,-0.032225,0.025116,7.6253E-4,-0.021307,0.028951,-0.030292,0.022368,0.0018778,-0.021577,0.02761,-0.029774,0.028388,-3.9446E-4,-0.024385,0.033388,-0.033615,0.018323,2.9681,2.7532,2.9339,3.2876,4.8753,3.5316,2.6758,2.9496,3.6227,4.9876,3.6823,2.6661,2.7082,3.2263,4.6902,3.365,2.5897,2.7988,3.334,4.4264,2.7758,1.9306,1.8465,1.5832,2.7238,1.843,1.2944,1.4502,1.4471,2.6681,1.8157,1.2874,1.4553,1.4538,2.7037,1.7784,1.2793,1.4383,1.4369,2.6842,1.7552,1.2679,1.4358,1.4244,2.6675,1.7287,1.2691,1.4247,1.4077,2.674,1.7024,1.26,1.4243,1.4131,2.6746,1.689,1.2561,1.4199,1.4013,2.6815,1.6649,1.258,1.4175,1.3978,2.6796,1.6557,1.2484,1.4149,1.4002,2.6749,1.6315,1.2451,1.4093,1.3917,2.6714,1.6315,1.2455,1.403,1.3852,2.6766,1.6041,1.2408,1.4058,1.3775,2.6825,1.5895,1.238,1.3987,1.375,2.6957,1.5699,1.2176,1.3731,1.3579,2.6909,1.5587,1.2348,1.3915,1.3586,2.6738,1.5334,1.228,1.3984,1.3735,2.6935,1.5307,1.2251,1.3955,1.3708,2.6984,1.5157,1.2289,1.3913,1.3684,2.6985,1.5158,1.2287,1.3906,1.3618,2.7064,1.5089,1.2342,1.3921,1.3625,2.7197,1.4965,1.2251,1.3961,1.3647,2.7217,1.4751,1.2301,1.3961,1.3679,2.7164,1.4752,1.2239,1.3973,1.3687,2.7345,1.4576,1.2286,1.3965,1.3674,2.7214,1.4587,1.2222,1.3929,1.3777,2.7362,1.4471,1.2321,1.3961,1.3693,2.7289,1.4427,1.2344,1.3948,1.3817,2.7409,1.4269,1.2354,1.3962,1.3852,2.7382,1.4184,1.2324,1.3964,1.3837,2.7387,1.4052,1.2299,1.4009,1.3857,2.7539,1.4105,1.2307,1.3974,1.3955,2.7462,1.3897,1.2333,1.3974,1.3993,2.7436,1.3871,1.2282,1.3987,1.4131,2.7351,1.3854,1.2388,1.3935,1.4268,2.7307,1.3701,1.2349,1.3945,1.4345,2.7182,1.3601,1.237,1.405,1.4479,2.7076,1.3591,1.2349,1.3996,1.4644,2.6926,1.3609,1.2415,1.3985,1.4831,2.6901,1.3484,1.2366,1.4013,1.5072,2.6665,1.345,1.2376,1.4022,1.5436,2.6334,1.3414,1.2367,1.3984,1.5687,2.6043,1.3401,1.2389,1.4015,1.5952,2.5771,1.3339,1.2439,1.3974,1.6257,2.5537,1.3263,1.2457,1.402,1.6497,2.542,1.3289,1.2421,1.3992,1.6749,2.5062,1.3165,1.2419,1.4078,1.7054,2.4965,1.3093,1.2424,1.4102,1.7238,2.4698,1.3011,1.2463,1.4118,1.7481,2.4552,1.3001,1.2476,1.4104,1.7669,2.4318,1.3043,1.2475,1.4019,1.7918,2.4135,1.2831,1.248,1.4109,1.8164,2.3865,1.2872,1.2486,1.4045,1.841,2.3723,1.2846,1.2537,1.4104,1.8577,2.3559,1.2806,1.2497,1.4097,1.8695,2.3385,1.2681,1.2469,1.4101,1.8822,2.3334,1.2712,1.2531,1.4083,1.9007,2.3159,1.2694,1.2574,1.4081,1.9162,2.3092,1.2624,1.2609,1.4107,1.9487,2.2761,1.2633,1.2564,1.4093,1.9647,2.2529,1.2567,1.256,1.4037,1.9863,2.231,1.2589,1.2571,1.4057,1.9965,2.2185,1.2604,1.2618,1.4113,2.0211,2.2021,1.2622,1.2594,1.4189,2.0324,2.1931,1.2523,1.2575,1.4168,2.0392,2.1839,1.2556,1.2592,1.4184,2.0547,2.1699,1.2467,1.27,1.4145,2.0671,2.164,1.248,1.2647,1.4111,2.0959,2.1335,1.246,1.2672,1.417,2.1001,2.1175,1.2463,1.2637,1.4076,2.1347,2.0966,1.2443,1.2725,1.4176,2.1386,2.0853,1.2368,1.2671,1.4176,2.1524,2.0804,1.2377,1.2697,1.4103,2.1733,2.0596,1.2467,1.269,1.4149,2.1899,2.0466,1.2392,1.271,1.42,2.1997,2.0299,1.2359,1.2756,1.4103,2.2088,2.0167,1.2357,1.2731,1.4157,2.2339,1.9915,1.2366,1.2758,1.4207,2.2482,1.9777,1.2329,1.2789,1.4154,2.257,1.967,1.2317,1.2796,1.4177,2.2666,1.9577,1.2379,1.2772,1.4178,2.2807,1.9438,1.2294,1.2786,1.4214,2.2852:1
1.8333E-7,-8.0E-8,-1.5333E-7,-4.3333E-7,1.3433E-6,-3.2E-7,1.0767E-6,1.5067E-6,2.9E-7,5.4333E-7,-6.6667E-7,7.7667E-7,4.7333E-7,-9.3333E-7,3.6E-7,-6.6E-7,9.8E-7,6.5333E-7,-7.1667E-7,6.8333E-7,5.9333E-7,1.08E-6,4.5E-7,5.5E-7,4.6667E-7,4.3E-7,5.6333E-7,1.3333E-8,1.7E-7,8.8E-7,-3.6667E-8,3.6667E-8,4.3333E-8,-6.5333E-7,-3.3333E-8,5.1333E-7,-2.0667E-7,4.1333E-7,-4.0E-7,7.1667E-7,-1.5667E-7,2.4E-7,9.3667E-7,-2.0E-8,1.1167E-6,-4.7667E-7,6.1333E-7,8.5667E-7,-1.1267E-6,6.3667E-7,1.7E-7,5.2667E-7,6.0333E-7,-4.2333E-7,8.2E-7,4.9E-7,1.0267E-6,1.631E-4,7.4867E-5,4.9973E-5,6.3107E-5,1.1509E-4,5.705E-5,4.8613E-5,5.432E-5,5.7617E-5,1.1708E-4,5.8023E-5,4.9177E-5,5.5833E-5,5.9163E-5,1.1819E-4,5.9157E-5,4.94E-5,5.6997E-5,5.98E-5,1.2172E-4,6.0057E-5,5.1593E-5,5.905E-5,6.164E-5,1.2531E-4,6.282E-5,5.4393E-5,6.016E-5,6.417E-5,1.2819E-4,6.4407E-5,5.64E-5,6.1847E-5,6.728E-5,1.3637E-4,6.8773E-5,5.8913E-5,6.623E-5,7.1923E-5,1.441E-4,7.3293E-5,6.473E-5,7.152E-5,7.7053E-5,1.5342E-4,7.987E-5,7.059E-5,7.6837E-5,8.295E-5,1.6723E-4,8.8087E-5,7.7657E-5,8.49E-5,9.3297E-5,1.8541E-4,9.8487E-5,8.8073E-5,9.4713E-5,1.095E-4,2.0108E-4,1.1143E-4,9.9047E-5,1.0663E-4,1.3255E-4,2.1465E-4,1.2592E-4,1.1368E-4,1.1886E-4,1.4955E-4,2.2823E-4,1.3508E-4,1.1828E-4,7.1553E-5,5.775E-5,1.218E-4,6.112E-5,5.4093E-5,5.738E-5,6.1337E-5,1.2024E-4,6.0453E-5,5.3027E-5,5.693E-5,6.1593E-5,1.1986E-4,6.053E-5,5.3023E-5,5.734E-5,6.0633E-5,1.2183E-4,5.9457E-5,5.3913E-5,5.735E-5,6.163E-5,1.2232E-4,5.771E-5,5.21E-5,5.7163E-5,6.1163E-5,1.2186E-4,5.8903E-5,5.3963E-5,5.759E-5,6.013E-5,1.2323E-4,5.7693E-5,5.329E-5,5.7097E-5,6.029E-5,1.2224E-4,5.809E-5,5.435E-5,5.7387E-5,6.1713E-5,1.2227E-4,5.7147E-5,5.338E-5,5.68E-5,6.1307E-5,1.2182E-4,5.7377E-5,5.324E-5,5.8337E-5,5.9447E-5,1.2234E-4,5.678E-5,5.2603E-5,5.64E-5,6.1017E-5,1.2319E-4,5.83E-5,5.2463E-5,5.7487E-5,6.0553E-5,1.2391E-4,5.7173E-5,5.262E-5,5.674E-5,6.1217E-5,1.2253E-4,5.6927E-5,5.294E-5,5.808E-5,6.1037E-5,1.2298E-4,5.6397E-5,5.44E-5,5.721E-5,6.05E-5,1.2214E-4,5.6777E-5,5.3147E-5,5.7903E-5,6.0457E-5,1.23E-4,5.5443E-5,5.28E-5,5.7097E-5,6.0767E-5,1.2347E-4,5.5893E-5,5.3057E-5,5.7417E-5,6.0157E-5,1.2203E-4,5.6263E-5,5.2547E-5,5.786E-5,6.0357E-5,1.2287E-4,5.4563E-5,5.388E-5,5.745E-5,6.046E-5,1.2246E-4,5.5977E-5,5.358E-5,5.762E-5,5.947E-5,1.2284E-4,5.5483E-5,5.2467E-5,5.7967E-5,5.95E-5,1.2431E-4,5.4503E-5,5.274E-5,5.727E-5,6.0557E-5,1.2418E-4,5.443E-5,5.3147E-5,5.6883E-5,6.035E-5,1.2427E-4,5.441E-5,5.3173E-5,5.7023E-5,6.036E-5,1.242E-4,5.4463E-5,5.3133E-5,5.6437E-5,6.07E-5,1.2394E-4,5.411E-5,5.3533E-5,5.7577E-5,6.0617E-5,1.24E-4,5.3603E-5,5.3117E-5,5.7633E-5,5.9383E-5,1.2366E-4,5.33E-5,5.395E-5,5.6903E-5,6.05E-5,1.2535E-4,5.361E-5,5.3497E-5,5.725E-5,6.0703E-5,1.2435E-4,5.595E-5,5.3183E-5,5.7627E-5,6.1253E-5,1.2477E-4,5.3417E-5,5.311E-5,5.7327E-5,6.0583E-5,1.2443E-4,5.3427E-5,5.37E-5,5.6823E-5,6.0637E-5,1.2429E-4,5.2697E-5,5.3117E-5,5.7287E-5,6.0847E-5,1.2544E-4,5.3657E-5,5.47E-5,5.7513E-5,6.1943E-5,1.2515E-4,5.3667E-5,5.375E-5,5.7317E-5,6.0837E-5,1.2548E-4,5.427E-5,5.3227E-5,5.7537E-5,6.1583E-5,1.2535E-4,5.1803E-5,5.4083E-5,5.8023E-5,6.1453E-5,1.2431E-4,5.251E-5,5.376E-5,5.6847E-5,6.157E-5,1.2329E-4,5.258E-5,5.272E-5,5.7647E-5,6.2353E-5,1.2475E-4,5.245E-5,5.462E-5,5.7583E-5,6.1237E-5,1.2367E-4,5.159E-5,5.4043E-5,5.773E-5,6.235E-5,1.2327E-4,5.2507E-5,5.4043E-5,5.874E-5,6.2523E-5,1.2195E-4,5.2117E-5,5.326E-5,5.8247E-5:1
-4.3667E-7,3.6E-7,6.2667E-7,4.2E-7,2.6333E-7,1.0233E-6,-1.25E-6,8.0E-8,-3.3333E-7,4.9667E-7,1.38E-6,-3.4333E-7,2.8333E-7,3.6667E-7,2.6E-7,1.4133E-6,-2.7667E-7,1.02E-6,-5.2667E-7,9.3333E-7,2.025E-4,1.1688E-4,6.3033E-5,1.0008E-4,1.5732E-4,7.664E-5,7.1263E-5,7.9483E-5,8.7443E-5,1.7123E-4,8.5047E-5,8.0793E-5,8.9837E-5,1.0958E-4,1.8555E-4,1.0005E-4,9.5317E-5,1.0267E-4,1.3359E-4,2.0378E-4,1.1622E-4,1.1093E-4,1.1937E-4,1.6221E-4,2.2447E-4,1.3576E-4,1.2611E-4,1.3318E-4,1.8453E-4,2.2794E-4,1.3282E-4,1.2083E-4,1.1437E-4,1.1157E-4,1.4783E-4,6.517E-5,6.343E-5,6.6847E-5,6.953E-5,1.4185E-4,6.5117E-5,6.0783E-5,6.531E-5,6.8493E-5,1.3937E-4,6.2903E-5,6.0943E-5,6.5317E-5,6.7507E-5,1.3825E-4,6.1543E-5,6.081E-5,6.509E-5,6.7263E-5,1.3586E-4,6.1253E-5,5.9923E-5,6.5897E-5,6.68E-5,1.378E-4,6.151E-5,6.0117E-5,6.4853E-5,6.8057E-5,1.3691E-4,6.1457E-5,6.0157E-5,6.4883E-5,6.7253E-5,1.3726E-4,6.2147E-5,5.95E-5,6.5327E-5,6.7867E-5,1.3663E-4,6.1547E-5,5.9983E-5,6.4233E-5,6.682E-5,1.3562E-4,6.1517E-5,5.9513E-5,6.4183E-5,6.819E-5,1.3467E-4,5.9877E-5,6.0003E-5,6.4183E-5,6.7347E-5,1.3595E-4,6.002E-5,5.932E-5,6.2243E-5,6.7297E-5,1.3501E-4,5.9477E-5,5.981E-5,6.3637E-5,6.6957E-5,1.3468E-4,5.872E-5,6.0107E-5,6.4317E-5,6.7413E-5,1.3322E-4,5.9687E-5,6.0417E-5,6.3007E-5,6.7033E-5,1.3358E-4,5.839E-5,5.9557E-5,6.41E-5,6.7233E-5,1.3464E-4,5.869E-5,5.9553E-5,6.2977E-5,6.837E-5,1.3334E-4,5.9263E-5,5.8933E-5,6.3733E-5,6.8823E-5,1.3257E-4,5.9173E-5,5.9123E-5,6.388E-5,6.967E-5,1.3235E-4,5.8213E-5,5.9507E-5,6.335E-5,7.0703E-5,1.3166E-4,5.9503E-5,5.928E-5,6.3467E-5,6.9277E-5,1.3221E-4,5.802E-5,5.828E-5,6.42E-5,7.1017E-5,1.3071E-4,5.8593E-5,5.9377E-5,6.3733E-5,7.1553E-5,1.3056E-4,5.7783E-5,6.009E-5,6.3323E-5,7.1377E-5,1.2952E-4,5.7307E-5,5.951E-5,6.326E-5,7.3117E-5,1.2956E-4,5.6403E-5,5.8743E-5,6.2547E-5,7.3277E-5,1.2917E-4,5.7757E-5,5.9337E-5,6.3467E-5,7.473E-5,1.2738E-4,5.844E-5,5.9323E-5,6.3903E-5,7.4087E-5,1.2764E-4,5.7517E-5,6.0727E-5,6.4113E-5,7.5417E-5,1.2685E-4:1
9.5333E-7,-3.4333E-7,1.0667E-6,1.75E-6,-1.3533E-6,-9.3333E-8,2.0E-8,1.2467E-6,-2.6667E-8,-4.1E-7,8.7E-7,-4.3E-7,1.3767E-6,5.1333E-7,-2.6333E-7,3.5667E-7,8.3333E-8,7.6E-7,4.7667E-7,7.2E-7,7.8E-7,-3.9667E-7,3.2333E-7,1.1067E-6,1.4667E-7,6.5333E-7,-2.5333E-7,1.1333E-7,4.4333E-7,-4.9E-7,4.9333E-7,-2.6667E-7,3.1333E-7,1.0667E-7,-8.0E-7,1.3E-6,-4.8333E-7,2.2166E-4,1.2598E-4,7.4963E-5,9.6893E-5,8.717E-5,1.8026E-4,1.0296E-4,9.103E-5,9.5493E-5,1.0423E-4,1.9954E-4,1.1448E-4,1.0312E-4,1.0635E-4,1.2707E-4,2.1524E-4,1.2817E-4,1.1732E-4,1.2104E-4,1.5646E-4,2.3335E-4,1.4702E-4,1.319E-4,1.3599E-4,1.7944E-4,2.4971E-4,1.5581E-4,1.3222E-4,1.316E-4,1.5307E-4,1.9537E-4,8.9057E-5,7.6113E-5,7.6743E-5,8.1097E-5,1.4975E-4,8.0773E-5,7.191E-5,7.2627E-5,7.8137E-5,1.4772E-4,7.8363E-5,7.178E-5,7.1807E-5,7.8273E-5,1.4704E-4,7.7003E-5,7.135E-5,7.3147E-5,7.736E-5,1.4643E-4,7.6123E-5,6.9793E-5,7.121E-5,7.7113E-5,1.4662E-4,7.5433E-5,6.9383E-5,7.1527E-5,7.6123E-5,1.4587E-4,7.4393E-5,7.038E-5,7.0883E-5,7.5207E-5,1.4596E-4,7.4237E-5,6.792E-5,7.0553E-5,7.5243E-5,1.4514E-4,7.2207E-5,6.8593E-5,7.0047E-5,7.5517E-5,1.4428E-4,7.2843E-5,6.8343E-5,7.0003E-5,7.4167E-5,1.4422E-4,7.1747E-5,6.836E-5,6.9487E-5,7.3897E-5,1.4522E-4,7.0763E-5,6.6987E-5,6.9623E-5,7.4663E-5,1.4369E-4,6.9833E-5,6.6817E-5,6.935E-5,7.2717E-5,1.4422E-4,6.9933E-5,6.6907E-5,6.885E-5,7.2987E-5,1.4298E-4,6.9627E-5,6.748E-5,6.7833E-5,7.2397E-5,1.4197E-4,6.959E-5,6.7447E-5,6.911E-5,7.2607E-5,1.4285E-4,6.9337E-5,6.5967E-5,6.7807E-5,7.2427E-5,1.4407E-4,6.8123E-5,6.5827E-5,6.769E-5,7.2413E-5,1.4281E-4,6.7483E-5,6.627E-5,6.7353E-5,7.3037E-5,1.4391E-4,6.638E-5,6.5617E-5,6.8723E-5,7.3693E-5,1.4179E-4,6.6737E-5,6.6387E-5,6.8917E-5,7.2707E-5,1.4174E-4,6.6117E-5,6.5453E-5,6.8047E-5,7.304E-5,1.4276E-4,6.7127E-5,6.5843E-5,6.744E-5,7.3503E-5,1.4225E-4,6.6537E-5,6.5777E-5,6.765E-5,7.3333E-5,1.4207E-4,6.635E-5,6.5147E-5,6.8087E-5,7.4363E-5,1.4164E-4,6.5013E-5,6.4367E-5,6.717E-5,7.353E-5,1.4173E-4,6.5077E-5,6.5147E-5,6.7593E-5,7.4583E-5,1.403E-4,6.538E-5,6.4583E-5,6.7507E-5,7.3933E-5,1.4032E-4,6.532E-5,6.57E-5,6.787E-5,7.6657E-5,1.3856E-4,6.4747E-5,6.534E-5,6.8123E-5,7.552E-5,1.3938E-4,6.4487E-5,6.5743E-5,6.7693E-5,7.626E-5,1.3712E-4,6.3673E-5,6.5327E-5,6.7607E-5,7.683E-5,1.3565E-4,6.264E-5,6.487E-5,6.864E-5,7.859E-5,1.3684E-4,6.3553E-5,6.536E-5,6.695E-5,7.9027E-5,1.3473E-4,6.4113E-5,6.5683E-5,6.7263E-5,7.9883E-5,1.3508E-4,6.3947E-5,6.4783E-5,6.712E-5,8.0563E-5,1.3346E-4,6.342E-5,6.5193E-5:1
-8.5E-7,1.1433E-6,8.2333E-7,3.7667E-7,8.2333E-7,-5.7E-7,1.4267E-6,7.8E-7,6.3E-7,1.0867E-6,1.1667E-7,1.1E-6,6.8333E-7,7.4E-7,8.6667E-7,3.0E-7,9.3333E-7,-3.1667E-7,-1.1E-7,1.08E-6,5.7667E-7,6.8667E-7,1.0667E-7,-2.3333E-8,4.5667E-7,-2.3667E-7,3.9333E-7,6.2667E-7,2.3162E-4,9.0513E-5,1.0922E-4,1.362E-4,1.7883E-4,1.4098E-4,9.9587E-5,1.1453E-4,1.4832E-4,1.888E-4,1.5194E-4,1.0785E-4,1.2376E-4,1.618E-4,2.0326E-4,1.6529E-4,1.1598E-4,1.3396E-4,1.7357E-4,2.1315E-4,1.7921E-4,1.2933E-4,1.5379E-4,2.0219E-4,2.6189E-4,7.607E-5,3.6477E-5,5.047E-5,4.2567E-5,8.5743E-5,5.048E-5,3.7143E-5,4.2673E-5,4.4143E-5,8.3127E-5,4.7797E-5,3.6713E-5,4.188E-5,4.3523E-5,8.1673E-5,4.6893E-5,3.6523E-5,4.0693E-5,4.2963E-5,8.1833E-5,4.6803E-5,3.5017E-5,3.9667E-5,4.203E-5,8.1773E-5,4.4823E-5,3.475E-5,3.9547E-5,4.2123E-5,8.073E-5,4.5043E-5,3.5883E-5,3.937E-5,4.0697E-5,8.0713E-5,4.4413E-5,3.444E-5,4.0033E-5,4.1427E-5,8.0143E-5,4.432E-5,3.5203E-5,3.8213E-5,4.181E-5,8.0357E-5,4.4247E-5,3.3897E-5,3.8397E-5,4.1947E-5,8.164E-5,4.3503E-5,3.336E-5,3.851E-5,4.1197E-5,8.0557E-5,4.2937E-5,3.45E-5,3.8773E-5,4.0463E-5,8.1017E-5,4.3703E-5,3.2563E-5,3.9493E-5,4.0277E-5,8.0753E-5,4.2377E-5,3.371E-5,3.8437E-5,4.016E-5,7.93E-5,4.192E-5,3.3957E-5,3.899E-5,3.9443E-5,7.9963E-5,4.1347E-5,3.3357E-5,3.817E-5,4.0603E-5,7.8947E-5,4.2087E-5,3.286E-5,3.7743E-5,3.9027E-5,7.99E-5,4.111E-5,3.3523E-5,3.8813E-5,4.0087E-5,7.9553E-5,4.062E-5,3.3043E-5,3.7983E-5,3.9487E-5,7.989E-5,4.1703E-5,3.275E-5,3.8357E-5,3.968E-5,7.9357E-5,3.9797E-5,3.25E-5,3.7873E-5,3.9393E-5,7.995E-5,3.9587E-5,3.2223E-5,3.786E-5,3.9713E-5,8.032E-5,3.9097E-5,3.1467E-5,3.7087E-5,3.9717E-5,7.978E-5,3.9397E-5,3.2097E-5,3.7553E-5,3.929E-5,7.9623E-5,3.818E-5,3.2553E-5,3.734E-5,3.9283E-5,8.0387E-5,3.9413E-5,3.2227E-5,3.7743E-5,3.959E-5,7.872E-5,3.901E-5,3.2493E-5,3.629E-5,3.9903E-5,7.8693E-5,3.9027E-5,3.3007E-5,3.7327E-5,3.8737E-5,7.9177E-5,3.8147E-5,3.3537E-5,3.6503E-5,3.868E-5,7.834E-5,3.7523E-5,3.2337E-5,3.566E-5,3.9043E-5,7.9273E-5,3.8417E-5,3.16E-5,3.723E-5,3.882E-5,7.8277E-5,3.764E-5,3.2573E-5,3.7877E-5,3.8273E-5,7.8733E-5,3.739E-5,3.2137E-5,3.6347E-5,3.921E-5,7.8803E-5,3.739E-5,3.256E-5,3.6447E-5,3.8813E-5,7.8443E-5,3.765E-5,3.1643E-5,3.6777E-5,3.8777E-5,7.838E-5,3.5667E-5,3.2493E-5,3.74E-5,3.852E-5,7.825E-5,3.6857E-5,3.2283E-5,3.6587E-5,3.8583E-5,7.8633E-5,3.6617E-5,3.1937E-5,3.7483E-5,3.862E-5,7.9143E-5,3.578E-5,3.1967E-5,3.668E-5,3.836E-5,7.9047E-5,3.665E-5,3.229E-5,3.5677E-5,3.8173E-5,7.7917E-5,-5.7133E-6:1
6.9667E-7,7.4333E-7,3.7667E-7,3.0E-8,6.2333E-7,-4.2333E-7,1.1733E-6,-1.6E-7,-3.4E-7,1.5967E-6,-2.8667E-7,9.1E-7,6.9E-7,-9.7333E-7,6.5333E-7,-6.6667E-9,4.6E-7,9.7333E-7,5.5E-7,6.9333E-7,-6.2667E-7,6.1E-7,9.7E-7,-8.4E-7,2.2667E-7,-1.7333E-7,1.1533E-6,1.0E-7,-4.4667E-7,2.2E-7,-5.9667E-7,2.0583E-4,1.431E-4,1.0722E-4,1.0045E-4,1.0875E-4,1.8549E-4,1.5118E-4,1.1263E-4,1.0507E-4,1.169E-4,1.9514E-4,1.5852E-4,1.2205E-4,1.1183E-4,1.2397E-4,2.0776E-4,1.6869E-4,1.3145E-4,1.1902E-4,1.3189E-4,2.1792E-4,1.8008E-4,1.4405E-4,1.3001E-4,1.5112E-4,2.433E-4,2.2301E-4,1.4391E-4,4.907E-5,3.891E-5,7.4003E-5,6.513E-5,4.1377E-5,4.18E-5,4.437E-5,6.9977E-5,6.5863E-5,3.9443E-5,4.0513E-5,4.345E-5,6.993E-5,6.5793E-5,3.899E-5,3.9803E-5,4.2467E-5,6.8947E-5,6.3633E-5,3.7827E-5,4.0027E-5,4.265E-5,6.8173E-5,6.211E-5,3.7103E-5,3.8833E-5,4.1247E-5,6.7377E-5,6.4213E-5,3.6197E-5,3.78E-5,4.0613E-5,6.78E-5,6.3087E-5,3.6297E-5,3.849E-5,4.1047E-5,6.6553E-5,6.225E-5,3.6627E-5,3.8227E-5,4.097E-5,6.5897E-5,6.2873E-5,3.606E-5,3.6617E-5,4.0863E-5,6.6197E-5,6.2487E-5,3.632E-5,3.626E-5,4.0727E-5,6.4437E-5,6.1507E-5,3.5237E-5,3.703E-5,4.09E-5,6.4883E-5,6.184E-5,3.5433E-5,3.6117E-5,4.0143E-5,6.3297E-5,6.1797E-5,3.44E-5,3.634E-5,4.012E-5,6.308E-5,6.0587E-5,3.5393E-5,3.5737E-5,3.96E-5,6.2913E-5,6.1543E-5,3.3843E-5,3.5877E-5,3.979E-5,6.2623E-5,6.085E-5,3.3613E-5,3.539E-5,3.9613E-5,6.1533E-5,6.07E-5,3.44E-5,3.5473E-5,3.8707E-5,6.217E-5,6.2187E-5,3.4067E-5,3.519E-5,3.949E-5,6.12E-5,6.216E-5,3.3957E-5,3.4907E-5,3.8987E-5,6.239E-5,6.1787E-5,3.2387E-5,3.4563E-5,3.874E-5,6.169E-5,6.13E-5,3.3493E-5,3.4277E-5,3.897E-5,6.107E-5,6.1207E-5,3.4093E-5,3.4947E-5,3.8317E-5,6.1703E-5,6.118E-5,3.3223E-5,3.4637E-5,3.831E-5,6.0233E-5,6.148E-5,3.2757E-5,3.4457E-5,3.835E-5,6.051E-5,5.9737E-5,3.171E-5,3.4873E-5,3.7213E-5,5.946E-5,6.003E-5,3.2807E-5,3.438E-5,3.783E-5,5.9343E-5,5.9767E-5,3.347E-5,3.409E-5,3.7253E-5,5.899E-5,6.1157E-5,3.2993E-5,3.3043E-5,3.721E-5,5.8753E-5,6.0347E-5,3.2247E-5,3.392E-5,3.7057E-5,5.965E-5,6.1583E-5,3.331E-5,3.375E-5,3.762E-5,5.82E-5,6.1497E-5,3.3383E-5,3.4573E-5,3.8137E-5,5.8747E-5,6.195E-5,3.276E-5,3.3197E-5,3.7503E-5,5.7257E-5,6.2733E-5,3.212E-5,3.3327E-5,3.808E-5,5.715E-5,6.138E-5,3.1983E-5,3.3227E-5,3.6883E-5,5.778E-5,6.1547E-5,3.1967E-5,3.376E-5,3.8123E-5,5.7267E-5,6.1693E-5,3.272E-5,3.338E-5,3.675E-5,5.691E-5,6.2427E-5,3.24E-5,3.3743E-5,3.8377E-5,5.6817E-5,6.2317E-5,3.156E-5,3.3087E-5,3.6543E-5,5.6167E-5,6.2953E-5,3.176E-5,3.292E-5,3.8003E-5,5.6507E-5,6.2683E-5,3.2543E-5,3.2857E-5,3.76E-5,5.53E-5,6.1167E-5,3.263E-5,3.3127E-5,3.663E-5,5.5497E-5,6.1263E-5,3.1697E-5,3.3843E-5,3.7417E-5,5.6037E-5,6.208E-5,3.283E-5,3.2333E-5,3.7543E-5,5.5173E-5,6.2323E-5,3.184E-5,3.3043E-5,3.6877E-5,5.5857E-5,6.2603E-5,3.209E-5,3.2647E-5,3.7547E-5,5.4917E-5,6.2603E-5,3.246E-5,3.2317E-5,3.7293E-5,5.5063E-5,6.1977E-5,3.1577E-5,3.1817E-5,3.578E-5,5.4253E-5,6.161E-5,3.228E-5,3.2093E-5,3.5563E-5,5.491E-5,6.17E-5,3.2307E-5,3.2857E-5,3.7557E-5,5.4877E-5,6.2267E-5,3.237E-5,3.2787E-5,3.6507E-5,5.3573E-5,6.313E-5,3.1653E-5,3.285E-5,3.6133E-5,5.3777E-5,6.1523E-5,3.166E-5,3.211E-5,3.6093E-5,5.3483E-5,6.1543E-5,3.2523E-5,3.215E-5,3.739E-5,5.4243E-5,6.2777E-5,3.1787E-5,3.243E-5,3.6267E-5,5.4017E-5,6.325E-5,3.231E-5,3.2527E-5,3.5857E-5,3.608E-5:1
-1.04E-6,-1.4433E-6,-2.0667E-7,-8.7667E-7,-1.0067E-6,-5.4E-7,-1.07E-6,-5.1333E-7,-1.3167E-6,-8.2E-7,-1.2667E-6,-1.6467E-6,-5.7E-7,5.0E-8,-6.6333E-7,-3.3E-7,-1.79E-6,-3.4E-7,-7.3E-7,-1.5367E-6,-3.6E-7,-2.4E-6,-9.4E-7,-7.4667E-7,-1.3433E-6,1.3333E-8,-1.1E-6,-9.3E-7,-2.1233E-6,-1.5367E-6,-3.9E-7,-1.3367E-6,-6.0333E-7,-7.6333E-7,-1.6067E-6,-1.49E-6,-1.81E-6,2.729E-5,3.1983E-4,2.1043E-4,1.0526E-4,1.0643E-4,1.0661E-4,1.7663E-4,1.6362E-4,9.563E-5,1.0604E-4,1.0234E-4,1.7628E-4,1.6412E-4,9.5427E-5,1.0403E-4,1.0554E-4,1.739E-4,1.6527E-4,9.463E-5,1.0437E-4,1.0404E-4,1.7108E-4,1.6498E-4,9.5317E-5,1.0569E-4,1.0418E-4,1.7017E-4,1.6548E-4,9.7013E-5,1.0421E-4,1.0307E-4,1.6934E-4,1.6639E-4,9.5533E-5,1.0341E-4,1.0339E-4,1.6745E-4,1.6453E-4,9.6537E-5,1.0359E-4,1.0442E-4,1.6632E-4,1.6579E-4,9.7877E-5,1.0414E-4,1.0284E-4,1.6791E-4,1.6719E-4,9.7363E-5,1.0453E-4,1.0315E-4,1.6491E-4,1.6925E-4,9.8277E-5,1.0398E-4,1.0374E-4,1.6597E-4,1.6887E-4,9.9867E-5,1.0381E-4,1.0485E-4,1.6499E-4,1.7145E-4,9.8813E-5,1.0405E-4,1.0414E-4,1.6175E-4,1.7084E-4,9.8977E-5,1.0283E-4,1.0345E-4,1.6173E-4,1.7095E-4,9.7727E-5,1.0383E-4,1.034E-4,1.6107E-4,1.7094E-4,1.0021E-4,1.0349E-4,1.0483E-4,1.6171E-4,1.7204E-4,9.9593E-5,1.0335E-4,1.0489E-4,1.6007E-4,1.7137E-4,9.9407E-5,1.0418E-4,1.0535E-4,1.5853E-4,1.7312E-4,1.0141E-4,1.0328E-4,1.0422E-4,1.591E-4,1.757E-4,1.015E-4,1.0437E-4,1.0442E-4,1.583E-4,1.7612E-4,1.0074E-4,1.0404E-4,1.0396E-4,1.5561E-4,1.7684E-4,1.0097E-4,1.0291E-4,1.026E-4,1.5497E-4,1.7648E-4,1.0142E-4,1.0358E-4,1.0249E-4,1.5471E-4,1.7844E-4,1.0343E-4,1.0392E-4,1.0492E-4,1.5411E-4,1.7924E-4,1.0221E-4,1.0359E-4,1.0401E-4,1.5534E-4,1.788E-4,1.0288E-4,1.0449E-4,1.0459E-4,1.5207E-4,1.8114E-4,1.0279E-4,1.0294E-4,1.046E-4,1.5091E-4,1.8223E-4,1.0398E-4,1.0096E-4,1.0464E-4,1.5071E-4,1.8194E-4,1.0401E-4,1.0318E-4,1.0429E-4,1.5013E-4,1.8234E-4,1.0407E-4,1.0397E-4,1.0542E-4,1.4707E-4,1.8426E-4,1.0597E-4,1.0236E-4,1.0471E-4,1.487E-4,1.827E-4,1.0519E-4,1.0327E-4,1.0611E-4,1.4698E-4,1.8459E-4,1.0452E-4,1.0316E-4,1.0382E-4,1.4771E-4,1.8506E-4,1.0644E-4,1.037E-4,1.04E-4,1.4689E-4,1.8645E-4,1.072E-4,1.0147E-4,1.0516E-4,1.4498E-4,1.8884E-4,1.0606E-4,1.0354E-4,1.0408E-4,1.4444E-4,1.8959E-4,1.0647E-4,1.0154E-4,1.0547E-4,1.4577E-4,1.8791E-4,1.0646E-4,1.0226E-4,1.0435E-4,1.4338E-4,1.8764E-4,1.0811E-4,1.027E-4,1.0494E-4,1.4104E-4,1.8732E-4,1.0793E-4,1.0251E-4,1.0488E-4,1.4004E-4,1.89E-4,1.0966E-4,1.0221E-4,1.0316E-4,1.403E-4,1.8936E-4,1.1036E-4,1.0261E-4,1.045E-4,1.3851E-4,1.9104E-4,1.1007E-4,1.0328E-4,1.0316E-4,1.3818E-4,1.9069E-4,1.1088E-4,1.0331E-4,1.0521E-4,1.3948E-4,1.924E-4,1.1074E-4,1.0216E-4,1.05E-4,1.3906E-4,1.9374E-4,1.1058E-4,1.0154E-4,1.0339E-4,1.3543E-4,1.9248E-4,1.1144E-4,1.017E-4,1.0346E-4,1.3558E-4,1.9356E-4,1.1057E-4,1.0182E-4,1.0418E-4,1.3707E-4,1.9257E-4,1.1238E-4,1.0164E-4,1.0415E-4,1.3501E-4,1.9347E-4,1.1275E-4,1.0167E-4,1.0446E-4,1.3355E-4,1.9381E-4,1.1201E-4,1.0196E-4,1.0428E-4,1.3435E-4,1.9539E-4,1.125E-4,1.0236E-4,1.0475E-4,1.3049E-4,1.9771E-4,1.1307E-4,1.0189E-4,1.0512E-4,1.3244E-4,1.9726E-4,1.1356E-4,1.0161E-4,1.0379E-4,1.3149E-4,1.9783E-4,1.131E-4,1.0349E-4,1.0409E-4,1.3036E-4,1.9822E-4,1.1596E-4,1.0155E-4,1.0355E-4,1.2896E-4,1.9915E-4,1.1462E-4,1.0228E-4,1.0451E-4,1.2799E-4,1.9749E-4,1.1459E-4,1.018E-4,1.0451E-4,1.2904E-4,1.9925E-4,1.1619E-4,1.0084E-4,1.0338E-4,1.2661E-4,2.0076E-4,1.1605E-4,1.0062E-4,1.0366E-4,1.2652E-4,1.9946E-4,1.1706E-4,1.0092E-4,1.0416E-4,1.1096E-4:1
-2.3967E-6,5.6333E-7,-1.3433E-6,-7.7667E-7,2.7E-7,-2.5733E-6,-1.8333E-7,-1.0933E-6,-1.0767E-6,4.6667E-8,-1.5867E-6,5.6667E-8,-2.0967E-6,-2.17E-6,-7.1333E-7,-2.74E-6,8.4667E-7,-1.0233E-6,-8.5667E-7,-6.0667E-7,-2.1933E-6,6.9333E-7,-8.0333E-7,-9.2333E-7,-1.7333E-7,-2.6967E-6,6.6667E-7,-1.7933E-6,3.5367E-4,1.2373E-4,1.0063E-4,1.3482E-4,1.9749E-4,1.3121E-4,9.788E-5,1.0884E-4,1.248E-4,2.0095E-4,1.3068E-4,9.616E-5,1.098E-4,1.2318E-4,2.0155E-4,1.314E-4,9.5357E-5,1.0843E-4,1.2077E-4,2.017E-4,1.2992E-4,9.4897E-5,1.0896E-4,1.1976E-4,2.0325E-4,1.3174E-4,9.496E-5,1.0922E-4,1.1797E-4,2.0291E-4,1.3101E-4,9.5237E-5,1.1017E-4,1.1749E-4,2.0452E-4,1.3079E-4,9.514E-5,1.0997E-4,1.1544E-4,2.0382E-4,1.322E-4,9.4713E-5,1.0796E-4,1.1569E-4,2.0617E-4,1.3242E-4,9.449E-5,1.0932E-4,1.1354E-4,2.0655E-4,1.3486E-4,9.3907E-5,1.0786E-4,1.1264E-4,2.0511E-4,1.3384E-4,9.3887E-5,1.095E-4,1.1424E-4,2.0805E-4,1.3401E-4,9.5067E-5,1.0899E-4,1.1192E-4,2.0784E-4,1.3702E-4,9.493E-5,1.0699E-4,1.1049E-4,2.0814E-4,1.3589E-4,9.5983E-5,1.0851E-4,1.1048E-4,2.0738E-4,1.3584E-4,9.5403E-5,1.089E-4,1.114E-4,2.0792E-4,1.3694E-4,9.474E-5,1.0769E-4,1.1277E-4,2.0626E-4,1.3647E-4,9.492E-5,1.0834E-4,1.1002E-4,2.0535E-4,1.3893E-4,9.4713E-5,1.0785E-4,1.1214E-4,2.0619E-4,1.3754E-4,9.3243E-5,1.0761E-4,1.1166E-4,2.0766E-4,1.3955E-4,9.5773E-5,1.0989E-4,1.1213E-4,2.0703E-4,1.4061E-4,9.4583E-5,1.1015E-4,1.1153E-4,2.063E-4,1.3908E-4,9.3453E-5,1.0906E-4,1.1142E-4,2.0571E-4,1.4214E-4,9.219E-5,1.0793E-4,1.1276E-4,2.0663E-4,1.3997E-4,9.3863E-5,1.0933E-4,1.0979E-4,2.0809E-4,1.4142E-4,9.4553E-5,1.0801E-4,1.1005E-4,2.0415E-4,1.4201E-4,9.4297E-5,1.0769E-4,1.1218E-4,2.0153E-4,1.4284E-4,9.231E-5,1.0882E-4,1.1112E-4,2.0338E-4,1.443E-4,9.2647E-5,1.0936E-4,1.1148E-4,2.029E-4,1.4413E-4,9.3603E-5,1.0736E-4,1.109E-4,2.0352E-4,1.431E-4,9.3727E-5,1.0871E-4,1.1031E-4,2.0245E-4,1.4538E-4,9.3237E-5,1.085E-4,1.1042E-4,2.0107E-4,1.4338E-4,9.383E-5,1.0791E-4,1.0905E-4,2.0357E-4,1.4479E-4,9.38E-5,1.0697E-4,1.0984E-4,2.0089E-4,1.4504E-4,9.31E-5,1.0848E-4,1.1037E-4,1.9997E-4,1.4844E-4,9.3557E-5,1.0758E-4,1.1118E-4,2.0015E-4,1.4752E-4,9.229E-5,1.0742E-4,1.0995E-4,2.0151E-4,1.4949E-4,9.308E-5,1.0806E-4,1.1111E-4,1.9908E-4,1.4701E-4,9.2657E-5,1.08E-4,1.0976E-4,1.9819E-4,1.493E-4,9.345E-5,1.0876E-4,1.0949E-4,1.9733E-4,1.487E-4,9.379E-5,1.0858E-4,1.1003E-4,1.9688E-4,1.5066E-4,9.452E-5,1.0972E-4,1.0857E-4,1.9536E-4,1.4989E-4,9.4393E-5,1.0923E-4,1.0976E-4,1.9519E-4,1.515E-4,9.4223E-5,1.0684E-4,1.1088E-4,1.962E-4,1.5017E-4,9.337E-5,1.0918E-4,1.098E-4,1.9578E-4,1.5073E-4,9.4703E-5,1.0647E-4,1.1151E-4,1.9289E-4,1.5231E-4,9.5293E-5,1.0599E-4,1.1107E-4,1.9376E-4,1.5361E-4,9.4057E-5,1.0638E-4,1.0977E-4,1.9334E-4,1.5406E-4,9.3407E-5,1.0632E-4,1.1195E-4,1.9169E-4,1.5428E-4,9.5347E-5,1.0721E-4,1.0964E-4,1.9265E-4,1.5419E-4,9.5207E-5,1.081E-4,1.1E-4,1.9037E-4,3.1207E-5:1
-1.86E-6,-6.9E-7,-1.0567E-6,-2.57E-6,-7.8E-7,-2.04E-6,-1.9067E-6,1.6003E-4,2.4025E-4,1.5638E-4,1.9738E-4,1.3379E-4,1.0123E-4,9.68E-5,1.1597E-4,1.9848E-4,1.3185E-4,9.8747E-5,9.7913E-5,1.1295E-4,1.9889E-4,1.32E-4,9.9053E-5,9.9047E-5,1.1396E-4,1.9611E-4,1.3163E-4,9.8997E-5,9.8127E-5,1.1216E-4,1.9514E-4,1.3155E-4,9.7873E-5,9.8293E-5,1.1201E-4,1.9335E-4,1.3215E-4,9.7747E-5,9.84E-5,1.1249E-4,1.9579E-4,1.3157E-4,9.7413E-5,9.7653E-5,1.118E-4,1.9386E-4,1.3154E-4,9.6913E-5,9.752E-5,1.1306E-4,1.9433E-4,1.342E-4,9.8193E-5,9.7223E-5,1.12E-4,1.9335E-4,1.3292E-4,9.7823E-5,9.7407E-5,1.118E-4,1.9272E-4,1.3292E-4,9.8243E-5,9.7733E-5,1.1136E-4,1.9354E-4,1.3317E-4,9.6633E-5,9.7847E-5,1.1152E-4,1.915E-4,1.3554E-4,9.7037E-5,9.8137E-5,1.1105E-4,1.9105E-4,1.3607E-4,9.8473E-5,9.8257E-5,1.1233E-4,1.9066E-4,1.3574E-4,9.788E-5,9.6903E-5,1.1263E-4,1.9145E-4,1.3645E-4,9.8037E-5,9.7223E-5,1.1094E-4,1.9117E-4,1.375E-4,9.9043E-5,9.7567E-5,1.1174E-4,1.9108E-4,1.3574E-4,9.809E-5,9.746E-5,1.1088E-4,1.8948E-4,1.3817E-4,9.8933E-5,9.7997E-5,1.1213E-4,1.8954E-4,1.3857E-4,9.8817E-5,9.7413E-5,1.1225E-4,1.8895E-4,1.4151E-4,9.8483E-5,9.7543E-5,1.1209E-4,1.8843E-4,1.397E-4,9.9207E-5,9.758E-5,1.0973E-4,1.8694E-4,1.3987E-4,9.9183E-5,9.7843E-5,1.1001E-4,1.8688E-4,1.4187E-4,9.912E-5,9.6753E-5,1.1199E-4,1.8846E-4,1.4036E-4,9.9023E-5,9.769E-5,1.1111E-4,1.8666E-4,1.4167E-4,9.9887E-5,9.737E-5,1.1109E-4,1.8661E-4,1.4211E-4,9.9863E-5,9.7787E-5,1.1305E-4,1.8516E-4,1.4332E-4,1.0034E-4,9.7803E-5,1.103E-4,1.8511E-4,1.4357E-4,9.9097E-5,9.7137E-5,1.1081E-4,1.8428E-4,1.438E-4,1.0072E-4,9.9313E-5,1.0987E-4,1.8393E-4,1.4478E-4,1.0081E-4,9.7943E-5,1.1109E-4,1.8324E-4,1.4652E-4,9.9553E-5,9.7003E-5,1.1111E-4,1.8524E-4,1.4589E-4,1.0003E-4,9.7527E-5,1.1165E-4,1.8214E-4,1.4672E-4,9.974E-5,9.8007E-5,1.1158E-4,1.8231E-4,1.4461E-4,1.0114E-4,9.8E-5,1.107E-4,1.8057E-4,1.4812E-4,1.0084E-4,9.7787E-5,1.1154E-4,1.8193E-4,1.4697E-4,9.9633E-5,9.778E-5,1.1247E-4,1.8137E-4,1.4914E-4,1.0008E-4,9.7187E-5,1.1135E-4,1.8026E-4,1.4978E-4,1.015E-4,9.5897E-5,1.1295E-4,1.7885E-4,1.4878E-4,1.0161E-4,9.7173E-5,1.1302E-4,1.8002E-4,1.5006E-4,1.0096E-4,9.724E-5,1.1209E-4,1.7786E-4,1.5052E-4,1.0038E-4,9.8617E-5,1.1139E-4,1.7795E-4,1.5119E-4,1.0206E-4,9.6527E-5,1.1101E-4,1.7841E-4,1.5216E-4,1.0243E-4,9.8657E-5,1.1162E-4,1.7808E-4,1.529E-4,1.0194E-4,9.6593E-5,1.1156E-4,1.7613E-4,1.5161E-4,1.035E-4,9.6587E-5,1.1151E-4,1.7731E-4,1.5235E-4,1.0252E-4,9.854E-5,1.1288E-4,1.7605E-4,1.5303E-4,1.0227E-4,9.792E-5,1.1033E-4,1.762E-4,1.5372E-4,1.0225E-4,9.7323E-5,1.1176E-4,1.7536E-4,1.5279E-4,1.031E-4,9.7963E-5,1.1013E-4,1.734E-4,1.5448E-4,1.0385E-4,9.752E-5,1.1073E-4,1.7375E-4,1.5518E-4,1.0341E-4,9.9247E-5,1.1219E-4,1.7315E-4,1.5577E-4,1.03E-4,9.7817E-5,1.1145E-4,1.7182E-4,1.57E-4,1.0376E-4,9.658E-5,1.1151E-4,1.7235E-4,1.576E-4,1.0269E-4,9.7797E-5,1.116E-4,1.7107E-4,1.5854E-4,1.0374E-4,9.693E-5,1.097E-4,1.7067E-4,1.5846E-4,1.0508E-4,9.7947E-5,1.1091E-4,1.7118E-4,1.5844E-4,1.0405E-4,9.6357E-5,1.1166E-4,1.6828E-4,1.5914E-4,1.0449E-4,9.6117E-5,1.1073E-4,1.6957E-4,1.5959E-4,1.0543E-4,9.645E-5,1.12E-4,1.6913E-4,1.5946E-4,1.0491E-4,9.687E-5,1.126E-4,1.672E-4,1.619E-4,1.0586E-4,9.6993E-5,1.1048E-4,1.6866E-4,1.6099E-4,1.0545E-4,9.6857E-5,1.1135E-4,1.6773E-4,1.6106E-4,1.0356E-4,9.7447E-5,1.1091E-4,1.6654E-4,1.6209E-4,1.0575E-4,9.7263E-5,1.1157E-4,1.6676E-4,1.6218E-4,1.055E-4,9.6673E-5,1.1005E-4,1.6505E-4,1.6305E-4,1.0551E-4,9.6077E-5,1.1135E-4,1.6491E-4,1.6324E-4,1.0543E-4,9.677E-5,1.1133E-4,1.6373E-4,1.6441E-4,1.0742E-4,9.804E-5,1.1179E-4,1.6568E-4,1.6495E-4,1.0732E-4,9.642E-5,1.1164E-4,1.6286E-4,1.6509E-4,1.0672E-4,-6.45E-6:1
5.1879E-4,-3.9724E-4,2.5632E-4,6.2513E-5,-1.8633E-6,4.8742E-4,-5.2029E-4,2.7431E-4,1.1953E-4,-1.6593E-4,4.6563E-4,-3.5697E-4,3.176E-4,3.9807E-5,-3.3286E-4,3.1817E-4,-4.4818E-4,3.5397E-4,0.046591,0.018701,0.017422,0.021327,0.031455,0.035254,0.020904,0.021789,0.024651,0.039119,0.042069,0.026988,0.027266,0.031115,0.051299,0.053064,0.037759,0.036871,0.041361,0.065965,0.062669,0.044595,0.042136,0.046437,0.069846,0.06664,0.045747,0.041763,0.044523,0.050662,0.040402,0.023282,0.021819,0.023763,0.033607,0.038209,0.022448,0.021473,0.023294,0.033195,0.038733,0.022926,0.021474,0.023305,0.032813,0.038957,0.023,0.021563,0.023121,0.032369,0.039039,0.023075,0.021435,0.023119,0.032059,0.039486,0.02321,0.021147,0.023067,0.031499,0.039537,0.023614,0.021484,0.023023,0.031192,0.040183,0.023797,0.021257,0.023098,0.030615,0.040378,0.023913,0.021241,0.023144,0.029981,0.040819,0.024139,0.021142,0.023211,0.029598,0.041509,0.024338,0.021076,0.023055,0.028866,0.041631,0.024486,0.021081,0.022887,0.028014,0.042298,0.024802,0.020904,0.022944,0.027604,0.042628,0.025182,0.020929,0.023076,0.027161,0.042979,0.025334,0.020705,0.022901,0.026861,0.043388,0.025607,0.02089,0.022811,0.026255,0.043489,0.025544,0.020747,0.022864,0.025646,0.043861,0.025955,0.020368,0.022688,0.024952,0.044235,0.026068,0.020783,0.022568,0.024837,0.04429,0.026533,0.020598,0.022656,0.02424,0.044782,0.026724,0.020628,0.022704,0.0241,0.044831,0.026913,0.020522,0.022473,0.023943,0.044615,0.027142,0.020556,0.022383,0.023943,0.044418,0.027464,0.020383,0.022272,0.023919,0.044161,0.027791,0.020121,0.022463,0.023873,0.044066,0.028092,0.020209,0.022497,0.023811,0.043743,0.028234,0.020061,0.022284,0.023706,0.04344,0.02867,0.020061,0.022374,0.023751,0.043222,0.028967,0.020006,0.022425,0.023768,0.042898,0.029308,0.02,0.022397,0.023797,0.042737,0.030099:1
-2.7912E-4,4.7366E-4,-2.7732E-4,2.1062E-4,1.2309E-4,-1.9487E-4,4.265E-4,-4.1622E-4,1.982E-4,-3.466E-5,-3.0872E-4,3.8072E-4,-1.6395E-4,6.6157E-5,7.497E-5,-2.1686E-4,3.3889E-4,-2.3721E-4,3.3267E-4,7.9483E-5,-7.8273E-5,3.2181E-4,-2.6108E-4,0.028655,0.02154,0.013622,0.017549,0.016027,0.031432,0.023514,0.015985,0.017924,0.019127,0.035507,0.027149,0.019194,0.021175,0.023343,0.042826,0.033408,0.024929,0.027024,0.031281,0.056158,0.045008,0.033006,0.034461,0.041007,0.063673,0.050918,0.03612,0.036638,0.043507,0.065497,0.050632,0.0315,0.023238,0.021531,0.036397,0.02851,0.018445,0.019556,0.020813,0.035341,0.028939,0.018958,0.019773,0.020855,0.034559,0.029317,0.018875,0.01985,0.020858,0.034304,0.02984,0.018922,0.019619,0.020706,0.033974,0.030224,0.018954,0.019727,0.020703,0.03375,0.030444,0.018942,0.019732,0.020906,0.0333,0.030779,0.019028,0.019654,0.020584,0.033001,0.031081,0.018985,0.019434,0.020747,0.032611,0.031504,0.0192,0.019614,0.020781,0.032392,0.031499,0.019171,0.019269,0.020445,0.031624,0.031636,0.01914,0.019156,0.020485,0.031244,0.031978,0.019298,0.01917,0.020367,0.030712,0.032223,0.01939,0.019086,0.020322,0.030261,0.03249,0.019619,0.019259,0.020366,0.030372,0.033275,0.019826,0.019236,0.020445,0.030514,0.033744,0.020014,0.019589,0.020524,0.030239,0.034239,0.020284,0.019488,0.020807,0.029868,0.034086,0.020294,0.019423,0.020675,0.029558,0.034258,0.020343,0.019195,0.020721,0.02899,0.034461,0.020452,0.019031,0.020488,0.028824,0.034548,0.020521,0.01903,0.020567,0.028502,0.034695,0.020773,0.019053,0.020364,0.028056,0.034796,0.020876,0.019017,0.020447,0.027586,0.035354,0.02087,0.018854,0.020456,0.027233,0.03544,0.021137,0.018838,0.020312,0.026789,0.035814,0.021121,0.018854,0.020314,0.026285,0.036224,0.021324,0.018863,0.020173,0.025668,0.036528,0.021574,0.01869,0.020265,0.02532,0.03668:1
-0.0016052,0.0019377,-8.0762E-4,8.864E-5,0.0015088,-0.0023367,0.0018895,-5.2568E-4,-5.3308E-4,7.9715E-4,-0.0017798,0.0015757,-3.594E-4,-9.8866E-6,0.0015365,-0.0011755,0.0011431,-4.6399E-4,-4.4146E-4,0.0014587,-0.0015917,0.0014372,-6.4587E-4,-4.2996E-4,0.0012954,-0.0015458,0.0017903,-6.3533E-4,-4.651E-4,0.2731,0.14675,0.21779,0.2132,0.15077,0.13846,0.14363,0.23072,0.21958,0.15338,0.13863,0.14408,0.23152,0.21384,0.14669,0.13415,0.13994,0.20608,0.17118,0.10871,0.099051,0.103,0.15369,0.16759,0.10658,0.098637,0.10215,0.15083,0.16508,0.10393,0.096722,0.10154,0.15009,0.16427,0.10238,0.095545,0.10023,0.14893,0.16241,0.10063,0.094866,0.099787,0.14851,0.16153,0.10014,0.095014,0.099545,0.1484,0.15972,0.099188,0.094543,0.099238,0.14823,0.15927,0.098607,0.093743,0.098634,0.14812,0.15804,0.097554,0.093287,0.098336,0.14902,0.15804,0.097143,0.093137,0.098501,0.14946,0.15636,0.096601,0.093551,0.097744,0.15002,0.15613,0.095329,0.092881,0.097844,0.14974,0.15546,0.09558,0.093392,0.097618,0.15082,0.15463,0.095114,0.092301,0.09767,0.15132,0.153,0.094977,0.093011,0.097066,0.1516,0.15272,0.094321,0.092321,0.097422,0.15211,0.15211,0.093758,0.093092,0.09677,0.15306,0.15097,0.093212,0.092211,0.096851,0.15383,0.15006,0.093164,0.09256,0.096776,0.15404,0.14895,0.092148,0.092506,0.096532,0.15451,0.14862,0.092488,0.093092,0.097064,0.15582,0.14716,0.091624,0.091549,0.096731,0.15614,0.14665,0.091372,0.092249,0.09691,0.15658,0.14656,0.091034,0.091747,0.096876,0.15786,0.14487,0.090888,0.092615,0.09667,0.1578,0.14377,0.091216,0.09236,0.096921,0.15869,0.14327,0.090697,0.092267,0.096105,0.15948,0.14337,0.090256,0.092426,0.095982,0.1608,0.14168,0.090089,0.092169,0.096537,0.16051,0.1409,0.090337,0.092492,0.096468,0.16149,0.14009,0.08962,0.091979:1
0.0010951,-0.0012512,0.0010737,-6.7791E-4,-0.0010611,0.001454,-0.0013432,0.0019284,-3.4862E-4,-8.9689E-4,0.0011435,-0.0011769,0.0017657,2.1244E-4,8.4733E-6,0.0011656,-0.00187,0.0013777,-4.334E-4,-8.056E-4,0.0015458,-0.001645,0.0015059,-2.47E-4,-6.1791E-4,0.0010098,0.035572,0.15154,0.1939,0.13326,0.1261,0.1442,0.21982,0.20125,0.13535,0.13021,0.15025,0.22526,0.2033,0.13984,0.13298,0.15712,0.22818,0.2045,0.14154,0.13417,0.14931,0.22162,0.17586,0.10578,0.10019,0.10179,0.15955,0.1513,0.096795,0.093526,0.099165,0.15678,0.14893,0.095993,0.093745,0.09953,0.15767,0.14842,0.094929,0.093042,0.098891,0.15847,0.14732,0.094851,0.093279,0.098586,0.15918,0.14535,0.093599,0.093071,0.098404,0.16045,0.14488,0.092874,0.093074,0.098222,0.16087,0.14332,0.093205,0.093047,0.098494,0.16121,0.14285,0.091772,0.093099,0.097617,0.16279,0.14099,0.092464,0.092933,0.098147,0.16344,0.14051,0.091478,0.092794,0.097754,0.16418,0.13925,0.091529,0.092817,0.098252,0.16509,0.13859,0.090731,0.09284,0.097975,0.16565,0.13779,0.091303,0.092986,0.097632,0.16658,0.13631,0.090669,0.09306,0.098025,0.16768,0.13476,0.090434,0.093317,0.097622,0.16807,0.13378,0.089413,0.093273,0.097484,0.16987,0.13318,0.089525,0.092697,0.097414,0.17062,0.13267,0.089404,0.093083,0.097503,0.17135,0.13217,0.089235,0.093532,0.09739,0.1715,0.13056,0.089046,0.093244,0.09722,0.17294,0.12991,0.088654,0.093018,0.096988,0.17345,0.12937,0.088621,0.092882,0.097437,0.17329,0.12704,0.088097,0.093495,0.097883,0.17488,0.12629,0.089021,0.09358,0.097614,0.17533,0.12583,0.087807,0.093312,0.097466,0.1775,0.12457,0.088321,0.093649,0.097594,0.17754,0.12312,0.087976,0.093455,0.097246,0.17837,0.12293,0.087907,0.093891,0.097504,0.1792,0.12161,0.087774,0.093615,0.097807,0.17925,0.12165,0.087194:1
-4.4575E-4,-5.898E-5,0.0014453,-0.0013586,0.001553,-9.9235E-4,-3.8734E-4,0.0010829,-0.0015026,9.6714E-4,-6.451E-4,2.4059E-4,9.7627E-4,-0.001513,8.8481E-4,-3.9614E-4,1.9127E-4,0.0013806,-0.0010755,0.0020389,-6.7319E-4,-6.2463E-5,8.2982E-4,-0.0010356,0.0013123,-4.4871E-4,-6.28E-4,8.3896E-4,-0.0011798,0.001282,-4.6343E-4,1.0772E-4,0.0010744,-0.0013884,0.0013431,-9.2583E-4,-6.7875E-4,0.0010412,0.0031395,0.14297,0.18801,0.13956,0.12409,0.13083,0.21041,0.20514,0.1458,0.12715,0.13939,0.21622,0.21189,0.14858,0.12883,0.14421,0.21899,0.21282,0.14932,0.13056,0.13736,0.20678,0.16978,0.10566,0.093202,0.095816,0.14084,0.15691,0.098444,0.088495,0.093744,0.13919,0.15497,0.097037,0.088233,0.094529,0.13932,0.1542,0.096382,0.087999,0.09404,0.14059,0.15459,0.09657,0.087452,0.094459,0.14146,0.15413,0.096347,0.088371,0.093796,0.14167,0.15278,0.095915,0.088965,0.094353,0.14244,0.15233,0.09515,0.088988,0.09458,0.14363,0.15195,0.094721,0.088526,0.09444,0.14505,0.1519,0.093658,0.088659,0.094455,0.14555,0.1514,0.094,0.089021,0.095164,0.14656,0.15098,0.092907,0.089043,0.094798,0.14704,0.14949,0.093115,0.08939,0.094988,0.14719,0.14987,0.093002,0.089617,0.09453,0.14877,0.14847,0.092794,0.088825,0.09491,0.14914,0.1488,0.092755,0.089962,0.095463,0.15025,0.14724,0.091451,0.090276,0.094565,0.1512,0.1472,0.091113,0.089782,0.095107,0.15203,0.14618,0.091704,0.089448,0.095004,0.15175,0.14554,0.091334,0.090126,0.094985,0.15346,0.14497,0.090897,0.090275,0.094946,0.15452,0.14443,0.090523,0.09025,0.095286,0.15436,0.14343,0.091022,0.090112,0.095383,0.15599,0.14324,0.090171,0.090195,0.095664,0.15586,0.14268,0.08898,0.090605,0.094833,0.15704,0.14158,0.089685,0.090867,0.09497,0.15772,0.14049,0.089571,0.090548,0.095324,0.15927,0.14041,0.088839,0.090632,0.095164,0.1599:1
-1.1318E-4,-2.747E-4,8.6691E-4,-0.0010345,8.3693E-4,-2.775E-5,-4.9756E-4,9.7732E-4,-7.2867E-4,5.75E-4,-6.376E-5,-1.4531E-4,9.5382E-4,-6.4434E-4,4.7932E-4,1.6436E-4,-8.2667E-5,6.78E-4,-6.807E-4,3.6987E-4,2.446E-4,-4.4886E-4,9.001E-4,-9.0754E-4,6.9155E-4,1.1992E-4,-4.181E-4,3.0132E-4,-8.7794E-4,7.0617E-4,-3.1581E-4,0.070119,0.043938,0.050641,0.072933,0.072915,0.047127,0.045946,0.047441,0.07484,0.072974,0.047374,0.046503,0.047826,0.074906,0.073475,0.04735,0.046506,0.047864,0.076675,0.07459,0.048334,0.047192,0.04857,0.076928,0.075207,0.048013,0.048011,0.04928,0.077828,0.075903,0.048755,0.047846,0.049292,0.077774,0.076768,0.049813,0.048258,0.049967,0.079248,0.079636,0.052302,0.050286,0.052155,0.083759,0.082269,0.054227,0.051613,0.054381,0.086372,0.083643,0.055598,0.053735,0.055849,0.088995,0.08671,0.057705,0.055702,0.05734,0.091294,0.088483,0.059528,0.056193,0.059505,0.093249,0.091201,0.059146,0.02423,0.017044,0.025948,0.039706,0.019686,0.020548,0.019151,0.024555,0.040005,0.01964,0.01994,0.019063,0.023776,0.039355,0.018859,0.019436,0.0188,0.023031,0.038349,0.018171,0.019339,0.018131,0.022287,0.038144,0.017976,0.018521,0.018435,0.022217,0.038075,0.017012,0.018614,0.017975,0.022676,0.038117,0.017211,0.017694,0.017462,0.022094,0.037673,0.016909,0.018089,0.017165,0.020725,0.038366,0.016763,0.017648,0.017605,0.020597,0.038644,0.01641,0.017432,0.016722,0.02047,0.037613,0.016419,0.017432,0.016466,0.020386,0.038021,0.016191,0.016895,0.016579,0.020356,0.037787,0.016342,0.017076,0.016894,0.02034,0.037147,0.01582,0.017136,0.016497,0.019588,0.037699,0.015755,0.016988,0.016336,0.018929,0.037229,0.015995,0.016241,0.016019,0.019943,0.036672,0.015785,0.016699,0.016597,0.019093,0.037231,0.01591,0.016464,0.015873,0.018787,0.036843,0.015498,0.016705,0.016421,0.0189,0.036003,0.015886,0.016314,0.016181,0.019386:1
-9.3528E-4,0.0010307,-3.9414E-4,-2.5999E-4,7.5483E-4,-6.7529E-4,6.0722E-4,-5.1048E-4,3.8474E-4,7.6199E-4,-8.8564E-4,4.2552E-4,-4.08E-4,-8.635E-5,2.9376E-4,-9.9027E-4,0.0012231,-7.4907E-5,-2.0623E-4,8.2142E-4,-8.4305E-4,9.5743E-4,-5.1209E-4,-4.1965E-4,4.4774E-4,-0.0010364,0.001043,0.045551,0.049946,0.032491,0.038667,0.04739,0.068396,0.045913,0.034786,0.037618,0.049901,0.069815,0.047839,0.035783,0.038793,0.051474,0.071122,0.04973,0.037167,0.040112,0.053338,0.072953,0.051032,0.038166,0.041032,0.054291,0.074133,0.052586,0.038669,0.041361,0.054272,0.075021,0.05341,0.03993,0.042749,0.05756,0.078352,0.056897,0.041553,0.045439,0.060837,0.081238,0.058999,0.043774,0.04788,0.063544,0.083468,0.061987,0.045666,0.049243,0.066412,0.086118,0.064496,0.046848,0.048561,0.026507,0.030139,0.019547,0.01474,0.014329,0.017894,0.031108,0.018754,0.013763,0.01453,0.017131,0.030711,0.018837,0.0136,0.014233,0.016872,0.030469,0.018312,0.013406,0.014072,0.016681,0.029634,0.018054,0.012874,0.013281,0.017045,0.029625,0.018133,0.012837,0.013758,0.017114,0.030427,0.018207,0.012565,0.014037,0.017039,0.029692,0.018563,0.012637,0.013577,0.016537,0.029645,0.018446,0.013161,0.013829,0.016514,0.029,0.018349,0.012833,0.013553,0.016474,0.029176,0.018444,0.012357,0.013313,0.016347,0.029131,0.018603,0.01263,0.013474,0.016294,0.029192,0.018477,0.012639,0.01321,0.016236,0.02926,0.01831,0.012679,0.012924,0.016575,0.029247,0.018572,0.012593,0.013483,0.016336,0.028491,0.018806,0.012044,0.013159,0.01597,0.028789,0.018244,0.012447,0.013257,0.016298,0.029029,0.018765,0.011877,0.0131,0.016135,0.028883,0.018476,0.012155,0.013382,0.016233,0.02838,0.018675,0.012188,0.012971,0.015992,0.028298,0.018942,0.011979,0.013178,0.016034,0.027562,0.01871,0.012404,0.012967,0.016036,0.027775,0.01883,0.011558,0.013306,0.015772,0.027618,0.018855,0.011529:1
-3.1365E-4,-2.3045E-4,6.8307E-4,-7.1912E-4,7.8151E-4,-1.437E-4,-2.809E-4,6.0912E-4,-0.0010582,9.2801E-4,-4.4249E-4,-7.6727E-5,5.2912E-4,-0.0012103,0.001045,-7.7864E-4,-4.3477E-4,9.5818E-4,-7.7095E-4,0.0012656,-3.4186E-4,-2.997E-4,9.7157E-4,-7.819E-4,0.0010629,-3.0363E-5,1.773E-4,9.0447E-4,0.041305,0.12304,0.15521,0.1009,0.082831,0.089676,0.10977,0.13188,0.078026,0.059823,0.051552,0.053365,0.10203,0.055885,0.046792,0.049003,0.052268,0.099157,0.056581,0.04632,0.048499,0.052241,0.097748,0.055954,0.045847,0.048207,0.051617,0.097347,0.056193,0.045335,0.047679,0.051779,0.096844,0.056838,0.045032,0.048143,0.051233,0.096194,0.057144,0.04498,0.047792,0.05117,0.095056,0.058172,0.044666,0.047467,0.051141,0.094057,0.057968,0.044696,0.046911,0.050825,0.094122,0.058624,0.044282,0.047373,0.050787,0.09277,0.059465,0.043907,0.04697,0.05028,0.09272,0.059918,0.044076,0.04692,0.050669,0.091544,0.060446,0.044233,0.046891,0.050627,0.090881,0.061259,0.04332,0.046807,0.050374,0.089735,0.061678,0.043129,0.046329,0.05051,0.088974,0.063236,0.043073,0.046315,0.050172,0.087965,0.063357,0.043393,0.046502,0.050107,0.088181,0.064602,0.042808,0.046049,0.050311,0.086434,0.064977,0.042734,0.046338,0.049989,0.085309,0.066345,0.042585,0.045981,0.050124,0.085031,0.06737,0.042506,0.046132,0.049634,0.083573,0.068707,0.042038,0.045903,0.049451,0.082628,0.069247,0.04224,0.045726,0.049685,0.081609,0.070097,0.0422,0.045621,0.050075,0.080681,0.071036,0.041833,0.045613,0.049343,0.07958,0.072034,0.042082,0.045122,0.049631,0.078621,0.073358,0.041985,0.04562,0.049401,0.077779,0.074212,0.041591,0.045458,0.049387,0.077353,0.074979,0.042494,0.045197,0.049611,0.07569,0.075612,0.041917,0.045078,0.049485,0.074756,0.076121,0.042183,0.044949,0.049267,0.074183,0.077641,0.042204,0.044949,0.049832,0.072641,0.078607,0.042482,0.045016,0.049272:1
-8.4441E-4,0.0010814,-7.2844E-4,3.6642E-4,6.1242E-4,-8.1448E-4,6.8926E-4,-6.9058E-4,-1.284E-4,7.0678E-4,-7.8061E-4,0.0010637,-2.1541E-4,2.3924E-4,8.2599E-4,-7.8922E-4,0.0011833,-7.4105E-4,3.253E-5,3.751E-4,-9.9296E-4,0.0010609,0.2034,0.13007,0.081331,0.081282,0.087346,0.11731,0.1012,0.063923,0.056185,0.053186,0.073748,0.078449,0.044837,0.04601,0.049255,0.07188,0.07745,0.044498,0.045553,0.048407,0.07061,0.07778,0.043879,0.045245,0.048751,0.069103,0.078149,0.043945,0.044795,0.048287,0.06844,0.078814,0.043627,0.044822,0.048705,0.066913,0.079253,0.043865,0.044318,0.048263,0.066521,0.079844,0.043598,0.044224,0.047745,0.065511,0.080192,0.043408,0.043976,0.047735,0.06434,0.080736,0.043488,0.04404,0.047282,0.063765,0.081004,0.043181,0.04338,0.047313,0.062571,0.081483,0.042898,0.043643,0.04731,0.062131,0.081958,0.043305,0.043474,0.046908,0.061124,0.082722,0.043279,0.042647,0.046966,0.059817,0.082681,0.043512,0.042924,0.047163,0.059496,0.08296,0.043581,0.042214,0.046282,0.058609,0.08417,0.043852,0.042726,0.046492,0.058149,0.083962,0.043598,0.042518,0.04615,0.056718,0.084583,0.044338,0.041988,0.046758,0.055621,0.085339,0.043641,0.042596,0.046068,0.055569,0.085499,0.044481,0.042509,0.046274,0.054469,0.085969,0.043969,0.042016,0.0464,0.053782,0.086156,0.044551,0.042294,0.046017,0.053142,0.087265,0.044649,0.041752,0.046422,0.052034,0.087252,0.044666,0.041418,0.045998,0.051538,0.088109,0.045075,0.041719,0.045706,0.050218,0.088554,0.045595,0.041912,0.0456,0.05016,0.088773,0.045047,0.041638,0.045675,0.04909,0.08934,0.046178,0.041214,0.045719,0.048356,0.089652,0.046345,0.041413,0.045635,0.047276,0.089961,0.04584,0.041154,0.045106,0.046815,0.090283,0.046752,0.041085,0.045248,0.04613,0.090392,0.046946,0.041326,0.045313,0.045503,0.090739,0.047172,0.041069,0.044904,0.04565,0.090391,0.04699:1
-9.7902E-4,8.0621E-4,-5.524E-4,3.2552E-4,5.2484E-4,-7.5113E-4,8.4704E-4,-4.4341E-4,6.8793E-4,6.1192E-4,-4.6365E-4,0.0012007,-4.2321E-4,1.1182E-4,4.3268E-4,-6.6866E-4,8.1566E-4,-5.768E-4,2.11E-6,5.1972E-4,-8.7703E-4,8.9911E-4,-7.3119E-4,5.0947E-4,2.7908E-4,-7.8343E-4,9.3467E-4,-7.3325E-4,1.5219E-4,0.12817,0.074443,0.082718,0.10339,0.08984,0.048656,0.047378,0.051602,0.073769,0.079972,0.044935,0.046438,0.049848,0.071249,0.079898,0.044069,0.045294,0.049128,0.069841,0.080384,0.043566,0.045063,0.048776,0.069124,0.080181,0.04326,0.044462,0.048798,0.0681,0.080555,0.043343,0.044451,0.048249,0.067286,0.080143,0.043136,0.044652,0.048035,0.066581,0.080668,0.043308,0.04423,0.048147,0.066541,0.081114,0.043183,0.043979,0.047437,0.064798,0.081044,0.042934,0.044241,0.047633,0.064677,0.081851,0.042855,0.043674,0.047225,0.063995,0.081337,0.04274,0.043596,0.04714,0.063316,0.081836,0.04317,0.043194,0.046924,0.062572,0.082327,0.043068,0.042955,0.047201,0.061707,0.082902,0.043176,0.043302,0.046923,0.060838,0.08285,0.042691,0.043024,0.047162,0.060969,0.08314,0.042955,0.042682,0.047235,0.060054,0.083728,0.043078,0.042724,0.046566,0.059728,0.084268,0.043097,0.042491,0.047058,0.058738,0.083969,0.043259,0.042461,0.046941,0.058317,0.084638,0.043505,0.04226,0.047022,0.057567,0.084899,0.043894,0.042173,0.04658,0.056558,0.085282,0.043439,0.0423,0.046337,0.056234,0.085548,0.043454,0.042229,0.046503,0.056084,0.085716,0.043617,0.042685,0.046649,0.055417,0.086461,0.043601,0.042093,0.046789,0.054605,0.086792,0.044115,0.04203,0.046608,0.054551,0.0872,0.044128,0.04213,0.046163,0.053877,0.087338,0.044032,0.041914,0.0462,0.052909,0.087597,0.044515,0.041706,0.045928,0.05245,0.088029,0.044582,0.041473,0.045789,0.051703,0.088644,0.045278,0.041824,0.045577,0.051556,0.088335,0.044874,0.04161,0.046017,0.050979,0.089381,0.045111:1
-0.002912,5.3973E-4,-3.8852E-4,-0.0027848,0.0023305,-0.0027707,7.7709E-4,-7.1685E-7,-0.0027312,0.0025589,-0.0029421,4.9341E-4,-4.0293E-5,-0.0025357,0.0026067,-0.0039993,8.5567E-4,2.0176E-4,-0.0034228,0.11583,0.12698,0.12896,0.084699,0.063046,0.071545,0.07491,0.1478,0.089971,0.068477,0.082715,0.082862,0.16843,0.10346,0.078661,0.096424,0.097905,0.19542,0.12012,0.094891,0.11039,0.11903,0.22023,0.13972,0.10973,0.12604,0.14234,0.23458,0.15286,0.11696,0.12934,0.14139,0.218,0.088629,0.0541,0.06203,0.058011,0.11558,0.067583,0.048682,0.059415,0.056722,0.1126,0.065698,0.047688,0.058868,0.055756,0.11233,0.065357,0.04755,0.058328,0.055714,0.11233,0.064796,0.047388,0.057564,0.055045,0.11182,0.064801,0.04764,0.057827,0.055016,0.11189,0.063897,0.046454,0.058017,0.054714,0.11173,0.063239,0.046651,0.057674,0.054841,0.11193,0.062101,0.046926,0.057797,0.054921,0.11128,0.06297,0.047226,0.05735,0.054942,0.11132,0.063549,0.046379,0.057787,0.054334,0.11165,0.062409,0.046934,0.05753,0.054157,0.11147,0.063138,0.046626,0.057333,0.055001,0.11206,0.062416,0.046595,0.057903,0.053871,0.11155,0.061842,0.046552,0.057293,0.054126,0.11222,0.061896,0.0464,0.057389,0.054696,0.11198,0.061702,0.046088,0.057156,0.054521,0.11149,0.060498,0.046233,0.05695,0.053986,0.11198,0.061288,0.046405,0.057518,0.054204,0.11128,0.061845,0.046623,0.057265,0.053919,0.11187,0.061989,0.047196,0.057537,0.054144,0.1122,0.061536,0.046401,0.057396,0.053986,0.11233,0.060565,0.045921,0.05735,0.05439,0.11233,0.060677,0.046986,0.056775,0.054562,0.11252,0.060317,0.046711,0.05699,0.054644,0.11223,0.060041,0.046866,0.057151,0.054042,0.11171,0.059907,0.046876,0.057173,0.053955,0.11192,0.059861,0.046621,0.057361,0.054051,0.11218,0.060087,0.046326,0.057201,0.054031,0.11155,0.060468,0.04599,0.056925:1
0.0026202,-0.0022615,3.8138E-4,2.4105E-4,-0.003683,0.0020997,-0.0021159,5.8293E-4,8.5741E-4,-0.0030739,0.0025416,-0.0030674,3.6223E-4,6.9502E-4,-0.0019572,0.0034517,-0.0023692,1.0997E-5,0.13856,0.10584,0.057836,0.082203,0.14697,0.071496,0.061151,0.077611,0.073028,0.16208,0.082251,0.070938,0.086642,0.090365,0.17273,0.090051,0.079697,0.095566,0.10917,0.18689,0.10521,0.12015,0.14518,0.17824,0.26117,0.15546,0.1379,0.15304,0.18197,0.25009,0.15204,0.132,0.14638,0.17931,0.21911,0.096241,0.069128,0.074603,0.067859,0.14155,0.069498,0.058158,0.070836,0.065057,0.13928,0.06733,0.056915,0.069784,0.063703,0.13737,0.066243,0.056777,0.069554,0.06365,0.13705,0.066071,0.055942,0.069158,0.063526,0.137,0.064778,0.055286,0.06881,0.063633,0.13598,0.064525,0.055577,0.068955,0.06338,0.13596,0.063532,0.055737,0.067972,0.062972,0.13551,0.063788,0.055805,0.067935,0.062928,0.13579,0.064786,0.055008,0.067722,0.061617,0.13517,0.064826,0.054811,0.068011,0.062408,0.13496,0.062448,0.054946,0.067496,0.062261,0.1351,0.063458,0.054937,0.06682,0.062176,0.1343,0.062312,0.054968,0.067346,0.062629,0.13494,0.061779,0.055624,0.067029,0.062299,0.13453,0.062075,0.054551,0.06648,0.062683,0.13477,0.060986,0.055295,0.066794,0.062536,0.13454,0.061018,0.05491,0.06686,0.060942,0.13492,0.062213,0.054526,0.066772,0.062258,0.13452,0.061439,0.054018,0.066897,0.060911,0.13473,0.061938,0.055162,0.066541,0.060987,0.13457,0.061318,0.054636,0.066879,0.062097,0.13443,0.059992,0.054133,0.06653,0.062288,0.13412,0.059998,0.05452,0.066227,0.061956,0.13377,0.061283,0.055024,0.066058,0.061645,0.13374,0.05954,0.055096,0.065937,0.061615,0.13502,0.059835,0.055163,0.066427,0.061341,0.13361,0.060952,0.05525,0.066641,0.060842,0.13361,0.059224,0.054555,0.066329,0.06168,0.13407,0.060766,0.05459:1
0.70111,0.71809,0.79812,1.1891,1.2438,0.69758,0.72305,0.79005,1.1822,1.2514,0.70438,0.71567,0.79238,1.1588,1.2671,0.70298,0.72273,0.78842,1.1461,1.2778,0.71258,0.71851,0.79411,1.1345,1.297,0.7171,0.71118,0.79165,1.1174,1.301,0.71298,0.70865,0.78865,1.1044,1.3143,0.72012,0.71233,0.79012,1.0845,1.3321,0.72075,0.70874,0.78786,1.0768,1.3486,0.72651,0.71071,0.78697,1.0603,1.3539,0.73141,0.71042,0.78226,1.0469,1.3658,0.73238,0.70938,0.78314,1.0296,1.3774,0.73375,0.70144,0.79038,1.0135,1.3843,0.73743,0.70705,0.78311,1.0009,1.3984,0.74415,0.70967,0.79106,0.99438,1.4108,0.74841,0.70078,0.78944,0.97029,1.4198,0.7591,0.69819,0.78708,0.95394,1.4319,0.76221,0.69487,0.78856,0.9456,1.4412,0.76521,0.69973,0.78252,0.92688,1.4561,0.77536,0.69576,0.77969,0.90983,1.464,0.76985,0.69451,0.78357,0.89797,1.4755,0.78135,0.69777,0.78014,0.8849,1.4914,0.78432,0.69064,0.77897,0.87137,1.5024,0.78941,0.69384,0.77025,0.85559,1.512,0.78995,0.68949,0.78207,0.84975,1.525,0.80072,0.6907,0.77984,0.83001,1.5368,0.80419,0.69802,0.7757,0.81507,1.5353,0.81018,0.68489,0.77551,0.804,1.5389,0.81963,0.68963,0.77767,0.79998,1.5484,0.82506,0.68497,0.77178,0.78858,1.5619,0.83353,0.68788,0.77385,0.78792,1.5611,0.83372,0.68286,0.77686,0.78394,1.5504,0.83792,0.67842,0.77457,0.78384,1.5464,0.84437,0.67846,0.7736,0.7836,1.5461,0.85528,0.67924,0.7669,0.78077,1.5447,0.8632,0.67677,0.77174,0.78392,1.5394,0.86351,0.67869,0.76937,0.7783,1.5344,0.8732,0.67554,0.76611,0.77595,1.5298,0.88145,0.67817,0.77018,0.78002,1.5297,0.89418,0.68245,0.7759,0.77694,1.5258:1
-0.0033194,-0.011166,-0.0021249,-0.010019,-0.011416,-0.0014664,-0.0088674,-5.4254E-4,-0.011762,-0.012473,-0.0036657,-0.0044215,-2.1199E-4,-0.010094,-0.0063114,-6.2181E-4,-0.0141,-0.0010977,-0.011478,-0.0076527,-0.0058447,-0.013929,4.9854E-4,2.177,1.3324,0.84617,1.0643,0.95915,1.8387,1.3733,0.94446,1.0481,1.1449,2.0918,1.6271,1.161,1.2804,1.4041,2.5755,2.0581,1.5294,1.5766,1.8411,2.9604,2.2631,1.6261,1.6975,1.9338,2.9946,2.329,1.655,1.7017,1.9238,2.801,1.6537,0.86006,0.89194,0.93316,1.5965,1.2549,0.81867,0.86849,0.92851,1.5818,1.2486,0.81447,0.87202,0.92437,1.5668,1.2656,0.81252,0.85803,0.92104,1.5431,1.272,0.81167,0.86206,0.91517,1.5222,1.283,0.8087,0.86108,0.91479,1.5122,1.3001,0.81457,0.85505,0.90975,1.494,1.3117,0.82013,0.84803,0.90862,1.4898,1.3208,0.82214,0.84927,0.90457,1.4538,1.3348,0.81123,0.84354,0.90278,1.4307,1.3511,0.81715,0.84285,0.896,1.4123,1.3632,0.8144,0.84113,0.89723,1.3941,1.3689,0.81086,0.8327,0.88467,1.3483,1.3677,0.80515,0.82136,0.88463,1.3391,1.3796,0.79971,0.81977,0.87579,1.3184,1.3948,0.79494,0.81341,0.87196,1.295,1.4036,0.80749,0.81871,0.86583,1.266,1.4077,0.80235,0.79943,0.86439,1.2452,1.4108,0.80192,0.80048,0.86317,1.2257,1.4294,0.80135,0.7935,0.86065,1.2045,1.4303,0.80445,0.79289,0.84698,1.1843,1.4361,0.80237,0.78627,0.85704,1.1774,1.453,0.80684,0.78502,0.84516,1.1737,1.4606,0.8147,0.79154,0.84527,1.1431,1.4725,0.81372,0.78023,0.85521,1.1299,1.4772,0.81416,0.7817,0.84731,1.1132,1.4885,0.82775,0.78007,0.84049,1.1081,1.5005,0.8245,0.77901,0.83999,1.0904,1.5047,0.82747,0.77817,0.84242,1.0725,1.5171:1
-0.0075682,-0.003204,-0.011062,0.0017557,-0.017322,-0.0092884,0.0030763,-0.01741,0.010374,-0.009484,-0.0046607,-0.0016081,-0.01135,0.0059583,-0.015827,-0.0037032,-0.0014453,-0.012028,0.0076502,-0.016489,3.294,0.94843,0.90591,0.83419,1.1119,1.5935,0.90911,0.82544,0.94215,1.1928,1.7093,1.0197,0.92325,1.0502,1.3965,1.9042,1.2197,1.0941,1.2507,1.7382,2.2165,1.5373,1.3773,1.5697,2.29,2.6414,1.8522,1.588,1.7568,2.4978,2.7423,1.8476,1.6297,1.7875,2.5024,2.7177,1.7506,1.3634,1.131,1.1104,1.7074,0.97365,0.84234,0.93378,1.0794,1.7075,0.97979,0.83392,0.93419,1.0666,1.7116,0.97857,0.83207,0.9303,1.0542,1.7266,0.97698,0.82756,0.92632,1.0394,1.7277,0.98325,0.83017,0.92995,1.0289,1.735,0.98787,0.82624,0.92742,1.0185,1.7404,0.99359,0.82001,0.92938,1.0035,1.7492,0.99697,0.8161,0.92259,0.98429,1.7594,0.99536,0.81217,0.92377,0.9731,1.7613,1.0017,0.81318,0.91899,0.9475,1.7732,1.0096,0.80394,0.90276,0.92056,1.7631,0.99467,0.79639,0.89865,0.90782,1.7584,0.99889,0.79148,0.88955,0.88671,1.7481,0.99505,0.78404,0.88804,0.88335,1.7341,0.99396,0.78233,0.87948,0.88219,1.722,0.99986,0.77642,0.87511,0.87301,1.7152,1.0055,0.77107,0.87811,0.87592,1.7021,1.0044,0.77011,0.87495,0.87174,1.6981,1.0155,0.75968,0.87058,0.87112,1.6902,1.0224,0.76421,0.87399,0.86353,1.6834,1.026,0.7581,0.86278,0.8633,1.676,1.0285,0.75143,0.86933,0.87254,1.6724,1.0379,0.75324,0.85601,0.86002,1.6565,1.0426,0.74638,0.85586,0.86148,1.6526,1.0538,0.75155,0.85063,0.86091,1.6458,1.0602,0.75088,0.85751,0.86096,1.6311,1.0647,0.75017,0.8512,0.85384,1.627,1.0751,0.74436,0.84845,0.85776:1
0.0019296,-0.013784,0.0078699,-0.0069212,0.0038805,-0.0021444,-0.0079189,0.0078899,-0.0083819,-7.2863E-4,0.0024896,-0.0072185,0.0093338,-0.014762,-7.4471E-4,-0.0016542,-0.017911,0.0092995,-0.0080174,-5.8222E-4,6.3296E-4,-0.0088769,0.0061428,-0.012638,0.0016507,-0.0035107,-0.014227,0.0050095,-0.010891,-0.0023127,0.0014139,-0.0093149,0.0095681,-0.012847,0.002957,-0.0020074,-0.0092793,0.0065823,2.7885,3.4324,2.5883,1.9091,2.0919,2.6932,3.041,2.3362,1.8006,1.9266,2.5453,2.8785,2.0138,1.2529,1.0365,0.77445,1.3663,0.80705,0.59438,0.68887,0.67125,1.2864,0.76877,0.58401,0.67744,0.66715,1.2741,0.75641,0.58053,0.66813,0.65685,1.277,0.74276,0.58454,0.67083,0.65902,1.274,0.73908,0.58784,0.65858,0.65239,1.2628,0.72482,0.58366,0.65686,0.64623,1.2574,0.72759,0.57914,0.65794,0.6515,1.2541,0.72285,0.57396,0.65677,0.64844,1.2494,0.72394,0.56626,0.65461,0.64465,1.2495,0.72748,0.56624,0.65105,0.63435,1.2423,0.72828,0.5638,0.65091,0.63336,1.2486,0.71968,0.55973,0.65151,0.6334,1.244,0.71587,0.5578,0.65634,0.63436,1.2505,0.71256,0.56226,0.6454,0.63672,1.2461,0.70774,0.56063,0.64678,0.63552,1.2491,0.69738,0.56589,0.64504,0.64045,1.2451,0.69155,0.56675,0.64146,0.64049,1.2472,0.6903,0.56655,0.63818,0.63156,1.2473,0.6927,0.5626,0.63902,0.63186,1.2456,0.6946,0.56726,0.64171,0.62468,1.238,0.69581,0.55978,0.64283,0.6252,1.2458,0.68763,0.55262,0.64507,0.62493,1.2377,0.69412,0.55609,0.64116,0.62566,1.2442,0.69197,0.55683,0.64351,0.62621,1.2483,0.68742,0.55921,0.63874,0.62399,1.2433,0.67497,0.56352,0.63727,0.62589,1.2442,0.66716,0.56296,0.63495,0.62373,1.2517,0.67433,0.5625,0.63688,0.62558,1.2437,0.66351,0.56626,0.6338,0.6221,1.2452:1
-0.009004,0.0045844,-0.0093767,-0.0015002,0.0058955,-0.0094943,0.003546,-0.010431,-0.0052536,0.0062469,-0.014092,0.0092137,-0.011945,-0.0034854,0.0016772,-0.013255,0.0066318,-0.0084295,-0.00173,0.003464,-0.016877,0.0093325,-0.008596,-0.004666,0.0059187,-0.011503,0.0076453,1.1212,2.41,1.9411,2.0661,2.5936,3.1313,2.5143,1.7978,1.8794,2.3949,2.9451,2.3233,1.6365,1.558,1.4828,1.7933,0.92865,0.63286,0.62572,0.7041,1.184,0.77106,0.56574,0.58284,0.66052,1.163,0.75802,0.55576,0.57762,0.65147,1.1569,0.74177,0.54649,0.57616,0.65639,1.154,0.72819,0.55041,0.56418,0.65104,1.1418,0.72495,0.54953,0.56881,0.64984,1.1537,0.7223,0.55226,0.56191,0.64836,1.1425,0.71418,0.54647,0.56727,0.63947,1.1478,0.71884,0.54794,0.56346,0.6438,1.1433,0.71342,0.5488,0.57069,0.64251,1.1535,0.70667,0.54637,0.5667,0.64511,1.1468,0.69967,0.55019,0.56467,0.64624,1.1538,0.70023,0.54814,0.57533,0.64313,1.1528,0.69646,0.54759,0.57048,0.64181,1.1567,0.69103,0.54693,0.56549,0.63935,1.1558,0.69333,0.54995,0.57009,0.64091,1.157,0.68077,0.54848,0.57093,0.64088,1.1562,0.68496,0.55352,0.57703,0.64132,1.1634,0.67691,0.55006,0.57009,0.64101,1.1577,0.67767,0.55208,0.56794,0.63773,1.1641,0.66649,0.55211,0.57081,0.63843,1.1644,0.66954,0.5551,0.57194,0.63442,1.1685,0.66811,0.54502,0.56595,0.63238,1.1692,0.66998,0.54843,0.5706,0.6302,1.1715,0.6671,0.5445,0.56811,0.63039,1.1703,0.66126,0.54244,0.57317,0.63547,1.1781,0.65806,0.54466,0.57137,0.63758,1.1755,0.65277,0.55067,0.57233,0.63509,1.1724,0.65171,0.55316,0.57018,0.63747,1.1725,0.6453,0.55728,0.56472,0.63775,1.1826,0.64562,0.56017,0.56922,0.63438,1.1769,0.64482,0.55365:1
0.015411,0.015432,-0.014642,0.021168,-0.011876,9.4281,0.97391,0.50399,-0.096018,0.37261,0.075397,0.31058,0.15191,0.11754,0.1576,0.13221,0.27841,0.10411,0.12284,0.13295,0.12839,0.72764,3.9932,3.3327,3.0683,3.8478,3.2616,2.1113,2.2513,2.2555,3.5935,3.2218,2.0774,2.2115,2.2427,3.5372,3.24,2.0571,2.1922,2.2424,3.5155,3.2484,2.0461,2.1723,2.2171,3.4712,3.2484,2.0434,2.1832,2.2187,3.4343,3.2657,2.0499,2.1629,2.2203,3.4323,3.2779,2.0357,2.1568,2.2096,3.4087,3.2788,2.0398,2.1469,2.1919,3.3786,3.2954,2.0219,2.1487,2.1999,3.3585,3.2999,2.0437,2.1485,2.1855,3.3476,3.3059,2.0213,2.1395,2.1971,3.3166,3.3355,2.0276,2.1391,2.1865,3.2833,3.3541,2.0229,2.147,2.1803,3.2646,3.3617,2.0444,2.1328,2.1785,3.25,3.3612,2.011,2.1268,2.1848,3.2295,3.3739,2.015,2.1336,2.1748,3.1955,3.4037,2.0226,2.1221,2.1786,3.1719,3.4311,2.0139,2.1209,2.1695,3.1555,3.4258,2.0261,2.1107,2.1683,3.144,3.4522,2.0341,2.1211,2.1753,3.1199,3.4608,2.0297,2.1119,2.1692,3.0875,3.4922,2.0371,2.1105,2.1648,3.0737,3.5172,2.0362,2.103,2.1702,3.0578,3.5266,2.0415,2.11,2.1534,3.0314,3.5442,2.0313,2.1015,2.1616,2.9666,3.5572,2.0298,2.1022,2.1485,2.9668,3.5706,2.032,2.1053,2.1386,2.922,3.5931,2.0486,2.0922,2.1467,2.9101,3.6024,2.0382,2.097,2.1541,2.8852,3.623,2.0488,2.0964,2.1395,2.849,3.6578,2.0508,2.0955,2.137,2.8222,3.6815,2.0707,2.0862,2.1482,2.7947,3.7007,2.0622,2.0969,2.1428,2.7739,3.7045,2.0741,2.087,2.1409,2.7608,3.7294,2.0654,2.0799,2.1421:1
0.017396,-0.014631,0.026006,-0.022861,0.013275,9.4125,0.11476,0.64219,0.0033699,0.25206,0.29042,0.098877,0.1872,0.105,0.15757,0.25863,0.098641,0.15208,0.10693,0.13708,0.23793,0.19276,2.9122,3.2769,4.7083,3.0317,2.0712,2.1619,2.2045,3.682,2.9416,2.0084,2.1461,2.1909,3.6314,2.9231,1.9919,2.1329,2.1564,3.6226,2.9073,1.987,2.1221,2.1644,3.5926,2.9151,1.9765,2.1269,2.1779,3.5669,2.9225,1.9786,2.1222,2.1559,3.5572,2.9211,1.9651,2.1018,2.1492,3.5546,2.9218,1.965,2.1061,2.1483,3.521,2.9341,1.9658,2.1052,2.1259,3.5068,2.9302,1.9536,2.1003,2.1198,3.4821,2.9477,1.9505,2.0823,2.1224,3.4672,2.9248,1.9412,2.0826,2.1175,3.4435,2.9559,1.9348,2.0688,2.105,3.4378,2.9421,1.9245,2.094,2.1057,3.4275,2.9726,1.9411,2.0908,2.1093,3.4274,2.9673,1.9236,2.0733,2.1091,3.3913,2.9839,1.9263,2.0743,2.1004,3.3872,2.9878,1.9223,2.0668,2.1007,3.3694,2.9996,1.9209,2.0668,2.0984,3.3639,3.0137,1.912,2.0606,2.0943,3.3479,3.0181,1.9247,2.0665,2.0789,3.3345,3.0119,1.9199,2.0728,2.0982,3.3138,3.0282,1.9287,2.0635,2.0841,3.32,3.0329,1.9146,2.0518,2.095,3.3066,3.0602,1.9102,2.0571,2.0963,3.2919,3.0704,1.9091,2.0605,2.0887,3.2797,3.0788,1.9,2.0418,2.1085,3.2565,3.1094,1.9078,2.0564,2.0771,3.2472,3.1104,1.9057,2.045,2.0724,3.2401,3.0937,1.9045,2.0388,2.0691,3.2296,3.115,1.8974,2.0462,2.0714,3.2062,3.1155,1.9001,2.038,2.0788,3.1987,3.1325,1.9074,2.0396,2.0681,3.1862,3.132,1.887,2.0338,2.0773,3.1693,3.1553,1.8921,2.0353,2.0686,3.1603:1
-0.010652,0.021078,-0.0010051,-0.0051717,0.022458,-0.014988,0.022481,-0.0027162,-0.0074493,0.021895,3.9244,1.7685,0.023283,0.33244,0.35239,-0.046466,0.24476,0.098588,0.21888,0.11885,0.077471,0.12636,0.11594,0.18032,0.075828,0.078614,0.13555,4.6384,3.4239,2.5273,2.2213,2.251,4.0119,2.4924,2.0361,2.1354,2.2339,3.9928,2.4814,2.0288,2.1386,2.2273,3.9674,2.4768,2.0177,2.1176,2.2037,3.9278,2.4872,2.0186,2.1094,2.191,3.9117,2.4727,1.9886,2.0817,2.1744,3.8829,2.468,1.9945,2.0846,2.1678,3.8653,2.4715,1.9778,2.0923,2.1694,3.8454,2.4816,1.9944,2.077,2.1714,3.8516,2.4898,1.9737,2.073,2.1689,3.8311,2.5061,1.9664,2.0712,2.1629,3.8261,2.5217,1.971,2.0797,2.1589,3.8005,2.5178,1.986,2.0635,2.1515,3.7944,2.5208,1.9634,2.0749,2.1579,3.7782,2.5564,1.9607,2.0538,2.143,3.781,2.5489,1.9613,2.0668,2.1464,3.7647,2.5593,1.9579,2.0617,2.1499,3.7544,2.5658,1.9581,2.0673,2.1504,3.7203,2.5815,1.9596,2.0445,2.1425,3.7293,2.5975,1.9511,2.0599,2.1465,3.7065,2.6191,1.9557,2.0494,2.1394,3.7096,2.6239,1.9479,2.0433,2.1398,3.6775,2.634,1.9509,2.0519,2.1366,3.6823,2.6334,1.951,2.0485,2.1451,3.6593,2.6526,1.9565,2.0513,2.135,3.6562,2.6448,1.9555,2.0493,2.1271,3.6516,2.6792,1.9459,2.0384,2.143,3.6416,2.6824,1.9458,2.0464,2.1326,3.6153,2.7017,1.9428,2.046,2.1362,3.6245,2.7158,1.9345,2.0377,2.1359,3.5855,2.723,1.9493,2.0411,2.1246,3.5826,2.7451,1.9423,2.0484,2.126,3.5545,2.7602,1.9433,2.0316,2.1289,3.5493,2.778,1.9341,2.0511,2.1314,3.5386,2.7919,1.9394:1
0.011942,-0.013644,0.025386,-0.0064946,0.011087,0.012837,-0.017566,0.030999,-0.019672,0.010734,0.2426,0.15781,0.13181,0.19723,0.19033,0.093536,0.07142,0.14896,0.17582,0.18575,0.08947,0.074478,0.14802,0.18082,0.18935,0.091562,0.066713,0.14677,0.17409,0.18342,0.088494,0.065909,0.14521,0.1764,0.18623,0.087928,0.06625,0.14482,0.17219,0.18702,0.093368,0.058285,0.13777,0.16711,0.18921,0.089265,0.06255,0.14054,0.17362,0.18132,0.090083,0.064007,0.14719,0.16243,0.19096,0.083487,0.071913,0.13955,0.16032,0.18637,0.083344,0.067176,0.13855,0.15618,0.1908,0.093451,0.068769,0.13484,0.16095,0.18821,0.080718,0.061186,0.13471,0.1541,0.18996,0.080056,0.064342,0.1318,0.1505,0.19008,0.08047,0.060396,0.13376,0.15381,0.19481,0.078004,0.063778,0.13578,0.14355,0.19393,0.086634,0.061148,0.13671,0.14594,0.20081,0.088735,0.056802,0.13085,0.14145,0.19669,0.083126,0.056541,0.13,0.14014,0.20248,0.077232,0.06625,0.12692,0.13849,0.2027,0.071577,0.058082,0.1343,0.13342,0.19697,0.079617,0.059387,0.13195,0.13352,0.20829,0.07394,0.053731,0.13566,0.12474,0.20941,0.079528,0.054968,0.12713,0.1294,0.21659,0.081442,0.059852,0.13291,0.1289,0.2088,0.083635,0.05739,0.12699,0.12154,0.21426,0.078681,0.05776,0.12889,0.11941,0.2145,0.08007,0.053457,0.127,0.1168,0.22357,0.076422,0.047628,0.1201,0.11655,0.21776,0.068439,0.051907,0.13054,0.11146,0.22247,0.067476,0.05867,0.12694,0.11138,0.22255,0.074959,0.057189,0.12958,0.10382,0.23061,0.072768,0.059635,0.12276,0.10169,0.22806,0.071947,0.052181,0.12295,0.10449,0.23169,0.076985,0.058567,0.12541,0.10492,0.23301,0.073417,0.049738,0.12634,0.098997,0.23365,0.076056,0.050778,0.12689,0.095277,0.24262,0.065725,0.051648,0.12364,0.088249,0.23997:1
0.028105,-0.01939,0.027152,-0.0078757,0.0012471,0.017672,-0.016303,0.027516,-0.0052055,0.0033352,0.022331,-0.015518,0.028588,0.35965,0.045367,0.059397,0.035525,0.10403,0.17175,0.054709,0.052017,0.035667,0.10648,0.17477,0.058193,0.052849,0.036626,0.10684,0.17767,0.063292,0.049794,0.036414,0.10622,0.1666,0.061491,0.051371,0.031544,0.10483,0.17336,0.057647,0.051081,0.029395,0.10838,0.17188,0.066697,0.05412,0.036864,0.10803,0.16937,0.065488,0.05256,0.035596,0.10001,0.179,0.069443,0.051053,0.04083,0.10866,0.16797,0.069166,0.055398,0.032841,0.10855,0.17806,0.068291,0.050383,0.035733,0.11044,0.16882,0.073659,0.046973,0.036882,0.10454,0.17435,0.073114,0.047512,0.036626,0.10724,0.16812,0.070441,0.041295,0.042233,0.10525,0.1728,0.066667,0.048243,0.033368,0.10508,0.17652,0.066887,0.050796,0.035125,0.10615,0.1743,0.069988,0.046304,0.03618,0.10525,0.17077,0.080636,0.053197,0.034793,0.10837,0.17299,0.076063,0.043944,0.033482,0.10431,0.17381,0.071616,0.045592,0.032837,0.10951,0.17441,0.084433,0.046584,0.033545,0.10406,0.17578,0.073888,0.049346,0.035131,0.10082,0.17312,0.083874,0.043985,0.03019,0.10229,0.17263,0.088668,0.046745,0.034453,0.10566,0.16662,0.086778,0.040188,0.039087,0.099856,0.1723,0.084359,0.045588,0.039217,0.10049,0.16504,0.091669,0.042879,0.037582,0.10628,0.165,0.082468,0.036829,0.034504,0.10414,0.16505,0.0869,0.041635,0.035121,0.10322,0.16578,0.090667,0.037208,0.035186,0.10093,0.16005,0.091444,0.040441,0.035417,0.10523,0.15525,0.099242,0.04224,0.031546,0.1031,0.17082,0.084482,0.042587,0.027642,0.10253,0.15126,0.097819,0.033866,0.037445,0.10116,0.16694,0.089262,0.039641,0.03297,0.10202,0.16133,0.097356,0.038917,0.034485,0.1003,0.15918,0.098443,0.042463,0.039149,0.10254,0.15244,0.10394:1
-0.0069194,0.0214,-0.0080674,0.019286,0.0059296,0.0011664,0.01312,-0.006016,0.019203,0.0043728,-0.0061725,0.019604,-0.0034622,0.016919,0.0079068,9.5603E-4,0.020249,-0.010875,0.0212,0.0060123,-0.0076294,0.017431,-0.0059527,0.017852,0.003003,6.1518E-4,0.015711,-0.013188,0.0091755,0.0035589,-0.0030513,0.022537,-0.010585,0.017134,0.0038501,7.3712E-4,0.015712,-0.0095446,0.014839,0.01596,-0.0087243,0.021026,-0.0050153,0.018686,0.0092991,-8.0982E-4,0.026389,-0.0092586,0.017879,0.0076557,-0.0036121,0.023242,-0.0080412,0.014781,0.0086821,-0.0027502,0.017079,-0.010912,0.018997,0.013769,-0.0074664,0.016143,-0.0095861,0.017659,0.0073298,4.0213E-4,0.013425,-0.0054861,0.017359,0.0093452,-0.0066062,0.018499,-0.0078457,0.012364,0.011459,-0.0027798,0.015589,-0.0072087,0.015942,0.014992,-0.0023108,0.01899,-0.0041353,0.016355,0.0096567,-2.892E-4,0.017053,-0.0050731,0.021589,0.0085909,0.0034544,0.017728,-0.0084583,0.014417,0.015268,-0.00309,0.019668,-0.0093026,0.013826,0.01009,0.0018593,0.014,-0.0092395,0.0088559,0.013339,-0.0020796,0.018491,-0.0085628,0.013292,0.0046653,-0.0016232,0.011433,-0.0054016,0.014641,0.0039975,-0.0015519,0.017528,-0.0059329,0.015226,0.0072479,0.0017836,0.013918,-0.001448,0.013465,0.0029763,0.0071187,0.016395,-0.0066534,0.014558,0.012726,0.003941,0.016444,-0.0040376,0.014119,0.0021647,0.0038469,0.0088271,-0.0020361,0.015111,0.0034562,0.0023617,0.010901,-0.0073975,0.01593,0.0067702,0.0093503,0.013384,-0.0042429,0.014333,0.0073383,0.0050707,0.013107,-0.01241,0.021624,5.8424E-4,-0.0018122,0.011395,-0.0038218,0.017895,0.001964,0.0025535,0.0166,-0.010355,0.0139,1.3582E-4,0.0037893,0.011217,-0.0065769,0.019121,0.0054871,0.0045545,0.013587,-0.0056405,0.016165,-8.5601E-4,-0.0039318,0.022413,-0.0081473,0.019603,0.0035254,-1.4504E-4,0.014674,-0.0074103,0.015152,0.0086753,0.0010257,0.014693,-0.009958,0.017121,9.0622E-4,0.0047148,0.013371,-0.0090907,0.019384,0.002997,-0.0020452,0.020358,-0.0095369,0.017004,0.0023599,0.018863,0.0087484,2.1003E-4,0.020534,-0.014943,0.019789,-0.0025106,4.5344,1.3404,-0.45129,0.61636,0.10746,0.22463,0.18128,0.050946,0.13998,0.12644,0.19955,0.10517,0.090485,0.11628,0.11756,0.17419,0.15434,1.6208,2.4333,3.7798,1.7024,1.4422,1.4291,1.5064,2.6478,1.5052,1.1667,1.089,1.1192,1.991,1.236,1.0172,1.0591,1.0824,1.9213,1.2399,0.99872,1.0245,1.0702,1.8995,1.2254,0.98853,1.0233,1.0667,1.8451,1.2546,0.97971,1.0023,1.0516,1.8303,1.2395,0.96116,1.0002,1.0381,1.7883,1.2532,0.95972,0.98972,1.022,1.7796,1.2518,0.94589,0.98349,1.0229,1.7405,1.2689,0.94234,0.96641,1.0217,1.7198,1.2681,0.93202,0.97659,1.0106,1.6827,1.2969,0.92914,0.96595,1.0096,1.6913,1.2944,0.91886,0.96732,1.0032,1.6534,1.3124,0.92679,0.94995,0.99472,1.6249,1.3189,0.91123,0.96229,1.0065,1.6027,1.3508,0.9137,0.95145,0.99948,1.5981,1.3483,0.90393,0.94721,0.99333,1.563,1.3759,0.89194,0.94319,0.99819,1.5495,1.38,0.89384,0.94268,0.98364,1.5212,1.3981,0.88926,0.93235,0.98439,1.4954,1.4073,0.88145,0.94006,0.99009,1.4779,1.4449,0.87347,0.92996,0.98286,1.4593,1.4447,0.88071,0.93358,0.96943,1.4209,1.486,0.86687,0.92784,0.97093,1.418,1.4835,0.87323,0.91998,0.96284,1.3785,1.5168,0.85628,0.91743,0.96723,1.3616,1.528,0.86135,0.91972,0.97248,1.3292,1.5739,0.85565,0.9065,0.97052,1.3241,1.5693,0.85434,0.9141,0.96812,1.2905,1.6028,0.85956,0.91613,0.96343,1.278,1.6112,0.84729,0.92161,0.96172,1.2501,1.6437,0.84472,0.91324,0.96708,1.2146,1.6594,0.83683,0.89182,0.95647,1.1882,1.711,0.84452,0.90412,0.96448,1.1646,1.7284,0.84313,0.9066:1
-0.0084152,0.035224,-0.0096515,0.0098598,0.012992,4.4899,1.5885,-0.26036,0.5014,0.40091,0.063597,0.22424,0.073913,0.14095,0.21478,0.083253,0.14769,0.096313,0.11063,0.20845,0.077146,0.1481,1.3893,5.5893,2.1989,1.4239,1.5037,1.4443,2.1693,1.5163,1.0197,1.0932,1.1053,1.7755,1.459,0.9685,1.0608,1.0599,1.7083,1.4694,0.95351,1.0441,1.0376,1.6564,1.4651,0.94025,1.0246,1.015,1.607,1.4633,0.91539,1.005,1.0201,1.5748,1.4739,0.90636,1.0029,0.99824,1.5301,1.5122,0.90029,0.98184,1.0083,1.493,1.5023,0.89457,0.98593,1.0016,1.4551,1.5304,0.87766,0.97197,0.98649,1.4353,1.5467,0.89622,0.96899,0.98552,1.4099,1.5535,0.87176,0.9687,0.9827,1.3887,1.5711,0.87027,0.9626,0.9714,1.361,1.5924,0.8635,0.95257,0.96874,1.3355,1.6108,0.86457,0.94446,0.95892,1.2844,1.6426,0.8532,0.94353,0.95821,1.2877,1.6448,0.8533,0.94211,0.96514,1.2481,1.696,0.84851,0.93789,0.95282,1.2141,1.7102,0.85185,0.93994,0.94616,1.1823,1.73,0.84426,0.93513,0.94832,1.1599,1.7453,0.84432,0.93208,0.94378,1.1221,1.7797,0.83579,0.92359,0.95544,1.109,1.7917,0.8362,0.93022,0.94015,1.0787,1.8174,0.837,0.92581,0.93384,1.0518,1.8494,0.83088,0.91885,0.93189,1.0394,1.8619,0.83213,0.91724,0.93012,1.0067,1.8708,0.83912,0.91425,0.94098,0.98549,1.8889,0.85093,0.91359,0.94235,0.98258,1.9029,0.84277,0.91772,0.94018,0.96536,1.9044,0.84254,0.9019,0.92779,0.95387,1.9033,0.85152,0.90684,0.92196,0.94863,1.897,0.84486,0.90078,0.92999,0.94241,1.8895,0.85156,0.88697,0.92504,0.94891,1.8969,0.86204,0.90135,0.9196,0.95079,1.8918,0.86283,0.90235,0.9118,0.94887,1.8761:1
0.026289,-0.02048,0.021871,0.010721,-0.0062916,0.019183,-0.013232,7.203,1.6165,0.28891,0.27337,0.21158,0.21251,0.30706,0.090904,0.12397,0.10622,0.15211,0.23697,0.084827,0.12767,0.096421,0.13906,0.31727,2.683,3.6172,2.4913,1.9029,2.8936,1.3588,1.3308,1.2502,1.2248,2.2729,1.0618,1.1064,1.0973,1.1621,2.1924,1.0426,1.0679,1.0752,1.1266,2.1544,1.02,1.0552,1.0535,1.1085,2.1108,1.0194,1.0411,1.0308,1.0924,2.0877,1.0044,1.0265,1.0321,1.0704,2.0729,1.0007,1.0183,1.0133,1.0743,2.0551,0.9879,1.014,1.0031,1.0584,2.0309,0.99725,1.0015,0.99883,1.0499,2.0063,0.9897,0.99042,0.98624,1.0551,2.01,0.98807,0.99274,0.98426,1.0437,1.9869,0.98786,0.98033,0.98406,1.0398,1.9704,0.99062,0.97384,0.96468,1.0514,1.9592,0.98981,0.9687,0.96152,1.0336,1.9441,0.99785,0.95906,0.95865,1.0298,1.9301,0.99453,0.9583,0.95243,1.027,1.92,0.98934,0.95052,0.94948,1.0137,1.909,0.99609,0.95707,0.95326,1.0164,1.8966,1.0047,0.94973,0.95089,1.0177,1.8913,1.0042,0.93984,0.94905,1.0028,1.8794,1.019,0.93103,0.92945,1.0138,1.8511,1.0187,0.92664,0.93518,1.0073,1.8446,1.0253,0.92923,0.93352,1.0045,1.8399,1.0351,0.93431,0.91135,0.99226,1.8224,1.0268,0.92324,0.92842,1.0036,1.8231,1.0279,0.86213,0.97154,1.0198,1.813,1.0417,0.92491,0.93019,0.99616,1.8153,1.0474,0.92465,0.92993,0.98943,1.7855,1.0639,0.91994,0.92148,0.98609,1.7971,1.0744,0.91011,0.92454,0.98964,1.7579,1.0808,0.91313,0.9248,0.99258,1.754,1.0936,0.92596,0.91971,0.9975,1.7523,1.1012,0.89492,0.91007,1.0022,1.7345,1.1117,0.89652,0.91832,0.99095,1.7193,1.1155:1
-0.011402,0.022962,-0.019341,0.022964,0.0054615,-0.0035188,0.026391,-0.018649,0.019845,-4.1941E-4,-0.014919,0.022267,-0.019006,0.0189,0.0071143,-0.0091351,0.019121,-0.019684,0.016549,0.003037,-0.0034857,0.026062,-0.017678,0.01601,9.6226E-4,-0.0033927,0.6528,0.18218,0.0082349,0.047771,-0.010685,0.021298,-0.017393,0.02999,0.60245,0.38062,0.43065,0.41621,0.7914,0.61856,0.35254,0.44139,0.40431,0.7906,0.62049,0.35886,0.44012,0.40041,0.78042,0.62257,0.35097,0.43932,0.4037,0.76996,0.62516,0.34644,0.43452,0.39399,0.76288,0.6224,0.34858,0.43139,0.39707,0.75658,0.63154,0.34739,0.43234,0.39324,0.74988,0.63045,0.35258,0.4266,0.395,0.74831,0.64046,0.34688,0.43104,0.39356,0.73709,0.6361,0.35463,0.41976,0.39267,0.73161,0.63846,0.348,0.42059,0.38945,0.72764,0.64197,0.34823,0.41763,0.38894,0.716,0.65402,0.3464,0.41877,0.39071,0.70926,0.65438,0.3456,0.41459,0.39301,0.70584,0.66157,0.34982,0.41141,0.38773,0.69736,0.66156,0.3586,0.41022,0.38819,0.68762,0.67216,0.35387,0.40912,0.38961,0.67823,0.67388,0.35434,0.40915,0.38518,0.67584,0.67811,0.35737,0.40672,0.38819,0.66791,0.68377,0.35505,0.40259,0.38133,0.66063,0.6938,0.35623,0.40859,0.38575,0.64897,0.69497,0.35486,0.40483,0.37991,0.64166,0.7073,0.35473,0.39696,0.38216,0.63816,0.7076,0.36394,0.40203,0.37845,0.62319,0.70565,0.36159,0.39368,0.379,0.61953,0.71398,0.36092,0.38998,0.38154,0.61174,0.71595,0.35219,0.39029,0.37877,0.60726,0.71857,0.36713,0.38759,0.37293,0.60497,0.72385,0.37094,0.38746,0.37767,0.60259,0.72653,0.36633,0.38857,0.37612,0.60245,0.72861,0.37387,0.38996,0.375,0.58163,0.7385,0.37819,0.38766,0.36959,0.58171,0.7333,0.38019,0.38403,0.37227,0.58022,0.73585:1
-0.0098985,0.031136,-0.017331,0.017722,0.0099676,-0.011726,0.024849,-0.0078084,0.017841,0.018367,-0.012921,0.02308,-0.019088,0.017231,0.011881,-0.010023,0.030938,-0.016089,0.52826,-0.0059915,-0.025826,0.050348,-0.01917,0.015096,0.0086827,-0.031507,0.10102,0.25899,0.73232,0.38753,0.21699,0.3513,0.31689,0.72817,0.39668,0.22969,0.34825,0.32982,0.72551,0.40644,0.21772,0.34736,0.32661,0.7346,0.40821,0.22601,0.35272,0.32914,0.73227,0.41391,0.22893,0.34923,0.32575,0.73927,0.41909,0.22804,0.35501,0.32974,0.73359,0.41759,0.23574,0.35465,0.33625,0.73938,0.42137,0.23821,0.35799,0.33038,0.74027,0.42235,0.23457,0.35342,0.33724,0.73315,0.42873,0.23344,0.36015,0.33251,0.74252,0.43263,0.23899,0.35617,0.33715,0.73082,0.43103,0.2359,0.36071,0.33427,0.73258,0.43662,0.23436,0.35525,0.33544,0.72993,0.43861,0.23773,0.36077,0.32853,0.7348,0.44108,0.23929,0.35797,0.33189,0.72964,0.44891,0.23672,0.36001,0.33794,0.7298,0.4533,0.23889,0.35783,0.33134,0.72652,0.44775,0.24557,0.35666,0.33633,0.72866,0.45916,0.24392,0.35804,0.33656,0.73329,0.45578,0.23966,0.35579,0.33895,0.72514,0.46181,0.23769,0.35138,0.33187,0.71824,0.46193,0.24197,0.354,0.34092,0.71656,0.46678,0.24265,0.35495,0.33503,0.71994,0.46555,0.24977,0.35624,0.33976,0.71431,0.47242,0.24581,0.35416,0.34192,0.7064,0.47217,0.25099,0.35001,0.33952,0.71622,0.47686,0.23833,0.35894,0.33617,0.71514,0.47563,0.25508,0.35428,0.33464,0.70536,0.48014,0.24698,0.35351,0.33931,0.70951,0.47837,0.25401,0.35289,0.34348,0.71174,0.48455,0.25502,0.3535,0.33672,0.70071,0.48459,0.2508,0.35356,0.33782,0.70267,0.48497,0.26084,0.35516,0.34218,0.69816,0.48781,0.2512,0.3459,0.3342,0.6975,0.48516:1
0.019564,0.012125,-0.0089066,0.025184,-0.014589,0.027317,0.0067448,-0.0041281,0.019926,-0.013171,0.026835,0.0083346,4.8176,1.6412,-0.4399,0.65482,0.23568,0.10538,0.21934,0.074573,0.17676,0.23226,0.1303,0.1349,0.10283,0.12871,0.22639,0.10842,0.12889,1.1709,5.564,3.679,2.0892,1.8204,1.7465,2.03,2.9867,1.6013,1.5921,1.6351,1.9362,2.9458,1.5672,1.5522,1.5994,1.8845,2.9174,1.5538,1.5421,1.5905,1.8546,2.9182,1.5285,1.5235,1.5642,1.8162,2.9161,1.5171,1.5259,1.5579,1.7909,2.9115,1.5243,1.5167,1.5504,1.78,2.9226,1.5028,1.5071,1.5444,1.7446,2.9122,1.5138,1.5032,1.5411,1.7279,2.9237,1.5142,1.493,1.5415,1.6987,2.9184,1.5128,1.4929,1.532,1.6826,2.9358,1.5242,1.4854,1.5246,1.6667,2.9334,1.4986,1.4786,1.522,1.6485,2.933,1.502,1.4735,1.5224,1.6344,2.9262,1.4998,1.4793,1.524,1.6216,2.9349,1.5037,1.4682,1.5181,1.6014,2.9388,1.5034,1.468,1.5053,1.592,2.9452,1.4979,1.458,1.5055,1.579,2.9507,1.5099,1.4603,1.497,1.5753,2.9422,1.4961,1.4554,1.5169,1.5702,2.942,1.5043,1.4682,1.4856,1.5577,2.9561,1.5116,1.4418,1.4967,1.5481,2.9596,1.5106,1.4484,1.4866,1.5492,2.9461,1.5062,1.4449,1.5034,1.5371,2.9458,1.5131,1.4594,1.4867,1.5392,2.9511,1.5141,1.4488,1.4893,1.5346,2.9513,1.5117,1.4487,1.478,1.5226,2.9347,1.5199,1.4336,1.4839,1.5363,2.9284,1.5154,1.436,1.4704,1.5241,2.9428,1.5264,1.4368,1.4855,1.5355,2.9299,1.5098,1.4441,1.4789,1.5311,2.919,1.5166,1.4391,1.4736,1.5282,2.9128,1.5171,1.4222,1.4646,1.5289,2.9169,1.5233,1.438,1.4815:1
0.018099,-0.013918,0.01706,-5.5016E-4,0.018952,0.016581,-0.0080281,0.023355,0.0018049,5.417,1.2222,-0.54955,0.88264,-0.051657,0.33318,0.208,0.042451,0.20419,0.10237,0.25305,0.12855,0.082306,0.14775,0.11558,0.2141,0.1405,1.6538,4.2276,4.8919,3.0738,1.6937,1.5809,1.6886,2.4269,2.447,1.4768,1.5277,1.6326,2.3511,2.429,1.438,1.4937,1.6004,2.2968,2.4222,1.431,1.4828,1.5854,2.2656,2.438,1.4132,1.4775,1.5804,2.2441,2.4133,1.4161,1.4628,1.5665,2.221,2.4301,1.4005,1.4562,1.5615,2.2026,2.4241,1.3922,1.4438,1.5672,2.1669,2.4417,1.3832,1.4408,1.5567,2.1544,2.4288,1.3876,1.4424,1.5458,2.1445,2.4447,1.3809,1.4335,1.551,2.1301,2.4566,1.3814,1.4334,1.5449,2.1151,2.4707,1.3674,1.4319,1.5436,2.0916,2.4805,1.3719,1.4268,1.5287,2.0767,2.4948,1.3699,1.429,1.5339,2.0617,2.4852,1.3671,1.4223,1.5273,2.0568,2.4917,1.3599,1.4229,1.5293,2.0359,2.5047,1.3611,1.4134,1.5313,2.0277,2.5243,1.3633,1.4253,1.5307,2.0089,2.5382,1.3703,1.417,1.5274,2.0112,2.5372,1.3554,1.4108,1.5246,1.9862,2.5426,1.3637,1.4229,1.5215,1.978,2.5564,1.3587,1.4148,1.5259,1.9657,2.5716,1.3699,1.413,1.5171,1.9461,2.5859,1.357,1.4225,1.5243,1.9343,2.5899,1.3563,1.3814,1.5062,1.9272,2.5864,1.3509,1.4035,1.5159,1.9181,2.612,1.3576,1.4103,1.5064,1.8886,2.6302,1.3582,1.4063,1.5125,1.8966,2.6339,1.3532,1.406,1.5148,1.8807,2.64,1.3495,1.4165,1.5079,1.8653,2.6464,1.3615,1.4099,1.5089,1.8444,2.6662,1.3545,1.3967,1.5134,1.8302,2.6771,1.3741,1.4038,1.5114,1.8119,2.6829:1
0.013537,-0.0041901,0.022525,-0.0099388,0.017404,0.0061507,-0.0050323,0.014183,-0.0074346,0.016019,0.008693,6.7788E-4,0.017711,-0.0039114,0.01317,0.01213,-0.0034223,0.018658,-0.0075328,0.021659,8.6426,0.99372,-0.27356,0.66092,0.0051873,0.32726,0.17895,0.096931,0.16669,0.13139,0.26537,0.11177,0.1222,0.11309,0.13763,0.22743,0.10873,1.1282,3.7175,5.0191,3.341,1.783,1.756,1.7392,2.4498,2.6502,1.5376,1.6303,1.6455,2.3666,2.6219,1.4995,1.603,1.6144,2.3032,2.6121,1.4894,1.5775,1.6019,2.2969,2.5987,1.4717,1.5748,1.5917,2.2477,2.6009,1.4681,1.5648,1.5714,2.2311,2.5931,1.449,1.5604,1.573,2.2161,2.5919,1.4419,1.5392,1.5665,2.1906,2.5763,1.4351,1.5453,1.5566,2.1783,2.5907,1.4302,1.526,1.5618,2.1588,2.5933,1.4257,1.5347,1.5424,2.1451,2.5992,1.4191,1.5171,1.5389,2.115,2.5896,1.4069,1.5133,1.5358,2.1078,2.596,1.4087,1.514,1.5366,2.1001,2.6061,1.4034,1.5155,1.531,2.0925,2.6085,1.4065,1.5062,1.5285,2.0779,2.6138,1.3995,1.5009,1.5161,2.0686,2.6192,1.392,1.5119,1.5207,2.0565,2.6128,1.4021,1.5038,1.5209,2.0305,2.6327,1.3986,1.4961,1.5125,2.0428,2.6377,1.3946,1.4891,1.5152,2.0121,2.6494,1.3844,1.4883,1.5152,2.014,2.6449,1.393,1.4903,1.5064,1.9964,2.6445,1.3851,1.4875,1.5065,1.9812,2.6561,1.3897,1.4987,1.5027,1.9614,2.686,1.398,1.4833,1.5065,1.9691,2.664,1.3827,1.4994,1.5157,1.9433,2.6776,1.3849,1.4732,1.4983,1.9498,2.6757,1.3888,1.4853,1.4979,1.932,2.6952,1.388,1.4696,1.4984,1.9261,2.7023,1.3832,1.471,1.5007,1.9073,2.6925,1.3915,1.4807,1.5042,1.909:1
-0.021055,0.023339,0.012362,-0.019375,0.029023,-0.014986,0.020274,0.01445,-0.016528,0.028347,1.2804,1.6627,1.2994,0.93632,0.95148,1.0081,1.7641,1.2137,0.86906,0.9723,0.97629,1.7502,1.2012,0.84446,0.96421,0.95166,1.7248,1.1838,0.82924,0.94735,0.93685,1.7013,1.1776,0.82155,0.93975,0.92366,1.6972,1.1631,0.81419,0.93063,0.90865,1.6927,1.1404,0.79591,0.92668,0.90076,1.6835,1.1387,0.79181,0.91872,0.89518,1.6724,1.1271,0.78796,0.91801,0.88828,1.6672,1.1213,0.78326,0.91068,0.8869,1.6566,1.1196,0.7821,0.90548,0.88414,1.6508,1.1119,0.77417,0.90131,0.88715,1.6505,1.1127,0.76968,0.90165,0.88181,1.6475,1.089,0.7707,0.89684,0.87543,1.638,1.094,0.76573,0.88598,0.87244,1.6424,1.0866,0.76347,0.89127,0.8716,1.6383,1.0821,0.76328,0.88492,0.87357,1.6347,1.0882,0.75468,0.88647,0.8643,1.6319,1.0759,0.75765,0.88419,0.86473,1.6259,1.0778,0.75398,0.88158,0.86252,1.6268,1.0688,0.75326,0.8816,0.86455,1.6272,1.0721,0.75418,0.87746,0.85581,1.618,1.0679,0.7446,0.87674,0.85502,1.6152,1.0647,0.74567,0.87648,0.85671,1.6174,1.072,0.74319,0.88047,0.85678,1.6206,1.063,0.73934,0.87446,0.85407,1.6126,1.0581,0.73482,0.8705,0.84743,1.616,1.0495,0.73995,0.86695,0.85606,1.6128,1.0465,0.73434,0.87309,0.85257,1.6136,1.0443,0.73507,0.86997,0.8467,1.6074,1.0619,0.73765,0.86934,0.8453,1.6093,1.0567,0.73371,0.87,0.84627,1.6077,1.0603,0.73043,0.86699,0.8465,1.6048,1.0484,0.73205,0.87045,0.83873,1.6081,1.0423,0.73284,0.85745,0.84232,1.5971,1.0325,0.73223,0.8624,0.84233,1.5978,1.03,0.73166,0.86431,0.84747,1.5999,1.0432,0.72949,0.86163:1
-0.0098033,0.010203,0.010804,-0.019352,0.026818,-0.012892,0.014311,0.019386,-0.021834,0.027037,-0.0090012,3.1784,1.2198,0.86956,1.1034,1.596,1.401,0.95061,0.90878,1.0292,1.5888,1.3583,0.9164,0.88908,1.0062,1.5684,1.3339,0.90751,0.87679,0.99341,1.5505,1.3178,0.89315,0.8668,0.98643,1.5385,1.3052,0.88537,0.85549,0.9808,1.5289,1.303,0.86719,0.86042,0.97288,1.5144,1.3113,0.8712,0.84881,0.96842,1.5045,1.2991,0.86361,0.83989,0.95946,1.5088,1.273,0.8564,0.8324,0.94807,1.5073,1.2636,0.85287,0.83609,0.94898,1.4992,1.2641,0.84209,0.83877,0.94459,1.4989,1.2577,0.84492,0.8253,0.94581,1.4853,1.2593,0.84015,0.82662,0.94103,1.472,1.2571,0.83825,0.82428,0.9413,1.4812,1.2512,0.82833,0.82168,0.93566,1.4846,1.2287,0.82301,0.81642,0.93182,1.4828,1.2303,0.82562,0.81217,0.92704,1.4831,1.2235,0.81602,0.81265,0.92773,1.4793,1.2197,0.81457,0.81272,0.92134,1.4731,1.2388,0.81385,0.8111,0.92391,1.4636,1.2369,0.81687,0.80806,0.91864,1.4662,1.2219,0.81184,0.80161,0.91772,1.4756,1.2144,0.80395,0.79967,0.92123,1.4678,1.2097,0.80343,0.79771,0.9193,1.4637,1.2136,0.7978,0.80176,0.91895,1.4679,1.2104,0.79853,0.79998,0.91358,1.4579,1.2217,0.80084,0.79972,0.91817,1.4552,1.2192,0.79681,0.80108,0.91646,1.4627,1.2008,0.79573,0.79562,0.91542,1.465,1.2072,0.79284,0.79592,0.90904,1.4639,1.194,0.7939,0.79223,0.90839,1.4618,1.1924,0.79069,0.79341,0.9064,1.461,1.1907,0.7876,0.79331,0.90996,1.4478,1.2059,0.79344,0.79735,0.90692,1.4567,1.2046,0.78339,0.79762,0.90796,1.462,1.1826,0.78436,0.78853,0.90896,1.4603,1.1809,0.78279,0.79349,0.89895:1
-0.022554,0.016528,-0.026249,0.0022548,0.0068291,-0.02051,0.014208,-0.021049,-0.0065792,-0.0050133,-0.028258,0.01886,-0.024007,6.411E-4,4.7215E-4,-0.026377,0.0086428,-0.022156,-0.0070642,-0.0026293,-0.029942,1.6438,2.2409,2.4051,1.719,1.5376,1.9361,2.8482,2.4658,1.8174,1.5381,1.9417,2.8664,2.4904,1.7429,1.6227,1.9784,2.8946,1.9755,1.3806,1.1961,1.1847,1.8445,1.7481,1.1304,1.0287,1.1717,1.7624,1.7375,1.1171,1.0172,1.1744,1.7477,1.7503,1.1216,1.014,1.1678,1.728,1.76,1.1217,1.0124,1.1638,1.7096,1.7695,1.126,1.0091,1.1684,1.6836,1.791,1.1181,1.0053,1.1581,1.6686,1.8041,1.124,1.0009,1.1548,1.6571,1.8134,1.1273,0.98732,1.1335,1.6247,1.8039,1.1259,0.98736,1.1447,1.6061,1.815,1.1269,0.99158,1.1432,1.5866,1.8391,1.1348,0.98845,1.1406,1.5721,1.8556,1.1371,0.98737,1.14,1.5647,1.8648,1.1369,0.97957,1.137,1.5466,1.8683,1.1467,0.98285,1.1444,1.5315,1.8836,1.1543,0.98346,1.133,1.5188,1.887,1.1541,0.98004,1.1346,1.5039,1.896,1.1583,0.98048,1.1262,1.5032,1.8949,1.1721,0.97576,1.1264,1.4844,1.9022,1.1752,0.97924,1.1316,1.4658,1.9195,1.1791,0.97329,1.1266,1.4531,1.9208,1.1852,0.9665,1.1227,1.4377,1.9318,1.1908,0.96513,1.128,1.4271,1.9373,1.2009,0.96413,1.117,1.4083,1.9508,1.1973,0.96573,1.1121,1.3831,1.9704,1.2077,0.96427,1.1208,1.3609,1.9894,1.215,0.96274,1.115,1.3539,1.9928,1.2185,0.95969,1.1142,1.3299,2.0105,1.2315,0.95626,1.1148,1.3203,2.0052,1.242,0.95965,1.108,1.3016,2.0221,1.259,0.95056,1.1087,1.2764,2.0365,1.2576,0.95554,1.1131,1.2581,2.0588,1.2701:1
0.010719,-0.026507,0.0056171,-0.0029061,-0.015461,0.011268,-0.02758,0.0058894,-0.0098428,-0.021662,0.013502,-0.029166,0.010917,-0.012931,-0.018748,0.01271,-0.02588,0.0048203,-0.0061831,-0.017928,0.48924,1.7803,2.7112,2.173,1.5349,1.6624,2.0996,2.8694,2.2825,1.6028,1.7403,2.1507,2.9409,2.3103,1.6346,1.7706,2.1805,2.9706,2.3507,1.6548,1.7811,2.1513,2.618,1.9909,1.088,1.2142,1.3619,2.0438,1.5991,1.041,1.1271,1.1608,2.0822,1.599,1.0465,1.1418,1.1516,2.0715,1.6038,1.0382,1.1257,1.1481,2.0472,1.6017,1.0328,1.1279,1.1342,2.0343,1.6148,1.0287,1.1247,1.1413,1.9991,1.6129,1.0189,1.1113,1.1234,2.0011,1.6181,1.0262,1.1048,1.1194,1.9984,1.6352,1.031,1.1151,1.1307,1.9929,1.6376,1.0462,1.104,1.1276,1.9826,1.6424,1.0468,1.109,1.1294,1.9688,1.6519,1.0544,1.1033,1.1287,1.9649,1.6694,1.0537,1.1091,1.121,1.9495,1.6733,1.0502,1.1022,1.1206,1.9447,1.6811,1.0556,1.1016,1.124,1.9149,1.6923,1.0628,1.0937,1.1248,1.9097,1.7054,1.0605,1.0938,1.1263,1.8951,1.7096,1.0717,1.0889,1.1233,1.8852,1.7301,1.0712,1.0918,1.1159,1.8682,1.7367,1.0787,1.0853,1.112,1.8541,1.7507,1.0821,1.0816,1.1124,1.8405,1.7646,1.0891,1.0835,1.1106,1.8136,1.7836,1.0936,1.0806,1.1166,1.7981,1.801,1.0977,1.0833,1.109,1.7756,1.8106,1.1051,1.0803,1.1078,1.7591,1.8197,1.1086,1.0879,1.1098,1.7453,1.8348,1.1134,1.0754,1.1065,1.7328,1.8394,1.1301,1.0726,1.1027,1.7123,1.8651,1.1368,1.0719,1.0998,1.6956,1.8692,1.1415,1.071,1.1035,1.6803,1.8847,1.1441,1.0632,1.0938,1.6664,1.8892,1.1564:1
-0.022966,-0.0023377,1.7379E-4,-0.029042,0.015566,-0.019708,-0.00546,-7.6504E-4,-0.028849,0.016855,-0.020476,-0.001747,0.0065373,-0.024354,0.016003,-0.020109,5.7194E-4,1.985,1.4442,1.6081,2.7231,2.4219,1.7798,1.6388,2.055,2.9212,2.4732,1.8168,1.6797,2.083,2.9613,2.5078,1.842,1.691,2.1062,2.9969,2.5074,1.807,1.6311,1.7621,2.4354,1.9205,1.2446,1.1381,1.3023,1.9901,1.8368,1.213,1.1253,1.2733,1.959,1.8132,1.2053,1.1166,1.2653,1.9367,1.8222,1.2044,1.1057,1.2602,1.9306,1.8317,1.203,1.1099,1.2522,1.909,1.8456,1.1954,1.1056,1.2531,1.8909,1.8455,1.1972,1.0957,1.2499,1.8746,1.8697,1.2036,1.0909,1.2473,1.8485,1.8746,1.1986,1.0784,1.2255,1.8264,1.867,1.2011,1.0817,1.2375,1.8168,1.8862,1.202,1.0869,1.231,1.8133,1.8888,1.2159,1.0833,1.233,1.78,1.9117,1.2139,1.0762,1.2358,1.7698,1.9185,1.2222,1.071,1.2279,1.7488,1.9371,1.2196,1.077,1.2362,1.7378,1.9623,1.2302,1.0757,1.2328,1.7254,1.9707,1.2335,1.0713,1.2307,1.7057,1.9738,1.2403,1.0774,1.2308,1.69,1.9818,1.2484,1.0727,1.223,1.6759,1.9969,1.2492,1.067,1.2243,1.6639,1.995,1.2646,1.0646,1.2249,1.6553,1.9976,1.2657,1.0711,1.2213,1.6388,2.0114,1.2751,1.0614,1.2251,1.6257,2.0214,1.2744,1.0666,1.2234,1.6095,2.0162,1.2696,1.0491,1.2058,1.5917,2.0192,1.2754,1.0581,1.2073,1.5836,2.0285,1.2865,1.0551,1.2112,1.5607,2.0422,1.2863,1.0502,1.2037,1.5501,2.0472,1.299,1.047,1.1981,1.5336,2.062,1.3014,1.0451,1.199,1.5152,2.068,1.32,1.0474,1.2085,1.4987,2.0901,1.3294,1.0434,1.2031:1
0.0036969,0.0098858,-0.0085028,0.015489,-0.0091994,0.0071,0.0059485,-0.011252,0.016237,1.9292,2.9023,3.0099,2.0382,1.5119,1.9876,2.8907,1.6484,1.4816,1.5638,1.8302,2.8824,1.6287,1.4565,1.5701,1.839,2.8633,1.6195,1.4608,1.5771,1.8485,2.8525,1.6044,1.448,1.5699,1.8445,2.8413,1.5963,1.4411,1.5612,1.8579,2.829,1.5944,1.4531,1.5683,1.868,2.824,1.5815,1.4492,1.5666,1.8788,2.8105,1.5761,1.4526,1.5653,1.8889,2.7987,1.5656,1.4512,1.5656,1.9016,2.7926,1.5541,1.4584,1.5633,1.9146,2.7799,1.5607,1.4531,1.5634,1.9231,2.774,1.5466,1.4517,1.5672,1.9306,2.7674,1.5459,1.4573,1.5604,1.9556,2.75,1.5358,1.4491,1.5662,1.9638,2.745,1.5262,1.4554,1.5601,1.9749,2.7399,1.5215,1.4603,1.5606,1.9864,2.7295,1.5242,1.4604,1.5609,1.9976,2.7186,1.52,1.4566,1.5595,2.0081,2.6999,1.5087,1.4576,1.5672,2.0243,2.689,1.5049,1.4571,1.5619,2.0495,2.6689,1.5011,1.4545,1.5632,2.058,2.662,1.4883,1.4519,1.5637,2.0761,2.6424,1.4863,1.4564,1.5689,2.095,2.6327,1.48,1.4627,1.5595,2.1139,2.6122,1.4794,1.455,1.5639,2.128,2.5927,1.4682,1.4602,1.5599,2.1421,2.5808,1.4693,1.4603,1.5656,2.1626,2.5612,1.4652,1.4603,1.5631,2.1792,2.5435,1.4595,1.4637,1.566,2.1988,2.5285,1.4623,1.4606,1.5628,2.2238,2.5131,1.4563,1.4617,1.563,2.2399,2.4906,1.4467,1.468,1.5697,2.251,2.4802,1.4453,1.4637,1.5742,2.2722,2.4666,1.4443,1.4666,1.5722,2.2967,2.4439,1.4415,1.4676,1.5742,2.3082,2.4274,1.4388,1.4648,1.5678,2.3276,2.4059,1.4354,1.4684,1.5703,2.3474:1
0.0031646,-0.0054241,0.0086478,-0.0011126,-6.3338E-4,0.0042539,-0.011447,0.01417,0.0046184,0.0017398,0.010969,-0.0048559,0.010251,0.0025352,-8.2452E-4,0.0098257,-0.006439,0.01503,3.7837E-4,-0.0018735,0.0038743,-0.0052543,0.0059147,-0.0015365,-0.0010657,0.0090991,-0.0065402,0.0029025,0.0025669,4.7981,2.4383,2.4147,2.5028,3.0744,1.8372,1.6981,1.6712,2.0647,3.0631,1.7893,1.6346,1.6841,2.0369,3.0373,1.7624,1.6121,1.6745,2.0248,3.0175,1.7546,1.6098,1.6715,2.0358,2.9986,1.7389,1.606,1.6545,2.0397,2.978,1.726,1.5991,1.6609,2.0398,2.9648,1.7091,1.5896,1.6562,2.0554,2.9548,1.7008,1.5894,1.6516,2.0642,2.941,1.6896,1.5812,1.6508,2.065,2.9315,1.6814,1.5915,1.6479,2.0693,2.9265,1.6742,1.5763,1.6469,2.0809,2.9182,1.6646,1.5831,1.6426,2.0887,2.8991,1.6579,1.5787,1.6428,2.0936,2.9057,1.644,1.5829,1.6336,2.1021,2.8804,1.6384,1.5784,1.6404,2.1123,2.8766,1.6293,1.5751,1.637,2.1223,2.8636,1.6282,1.5741,1.6397,2.1348,2.8552,1.6136,1.5706,1.6341,2.1399,2.8363,1.6108,1.5751,1.636,2.1618,2.8339,1.6081,1.5705,1.6334,2.169,2.8073,1.5954,1.5665,1.6267,2.1824,2.7895,1.5873,1.5692,1.6315,2.2041,2.7821,1.5847,1.5718,1.6309,2.2193,2.7619,1.583,1.5703,1.6321,2.2323,2.7499,1.5801,1.5703,1.6334,2.2389,2.7341,1.5706,1.5683,1.6339,2.2689,2.7241,1.5677,1.5746,1.6294,2.2711,2.7182,1.5611,1.568,1.6262,2.2962,2.6949,1.5594,1.5709,1.6248,2.3082,2.6708,1.5537,1.5709,1.6243,2.3286,2.6612,1.5469,1.5737,1.6263,2.3484,2.6479,1.5413,1.5756,1.625,2.3634,2.6312,1.5385,1.5722,1.6255,2.3789,2.6198,1.5305:1
0.0049285,-0.0016197,0.0089054,0.0057556,0.0038776,-0.0015007,-0.0020937,0.011113,-0.002906,-7.6828E-4,0.0098584,-0.0093263,0.0064159,-0.001512,0.0074557,0.0034731,-0.0062631,0.0061799,0.001853,0.0010234,6.3534E-4,-0.0042873,2.311,4.9862,2.556,1.5241,1.6866,1.6795,2.7866,2.3636,1.507,1.6035,1.6976,2.7715,2.3402,1.5038,1.6011,1.701,2.766,2.3303,1.5008,1.5948,1.6918,2.7804,2.312,1.4961,1.5919,1.6914,2.7922,2.2931,1.4924,1.5987,1.6899,2.7956,2.2881,1.4871,1.5882,1.6873,2.803,2.278,1.4822,1.5934,1.6869,2.8224,2.2572,1.4866,1.5983,1.6894,2.8164,2.2548,1.4913,1.5987,1.6967,2.8316,2.2378,1.4892,1.5868,1.6905,2.826,2.2254,1.4955,1.5973,1.6908,2.8392,2.2165,1.4807,1.5994,1.68,2.8564,2.2109,1.4879,1.5994,1.6865,2.8759,2.1988,1.4855,1.5981,1.6869,2.8692,2.1809,1.4936,1.595,1.6848,2.8797,2.173,1.4958,1.5991,1.6832,2.8871,2.1535,1.4906,1.5935,1.6766,2.895,2.1406,1.4959,1.6035,1.68,2.9007,2.1334,1.4997,1.6039,1.6848,2.909,2.1269,1.4946,1.5995,1.6793,2.9246,2.113,1.4994,1.6029,1.6819,2.924,2.1091,1.4962,1.6102,1.6813,2.9402,2.096,1.4929,1.6136,1.6866,2.9442,2.0817,1.4999,1.6073,1.682,2.9569,2.0731,1.5022,1.6034,1.6845,2.9581,2.065,1.5012,1.6119,1.6909,2.9675,2.0511,1.5047,1.6101,1.6884,2.9711,2.0374,1.5104,1.6065,1.687,2.9908,2.0221,1.5012,1.6077,1.6941,2.9972,2.0247,1.5091,1.6131,1.6867,3.0065,2.0118,1.5097,1.6129,1.6862,3.0061,2.0039,1.5103,1.6098,1.6806,3.0118,2.0005,1.5127,1.6124,1.6911,3.023,1.9832,1.5168,1.6191,1.6842,3.0276,1.9748:1
0.0057238,0.0062595,0.0041109,0.0040635,0.0022485,0.0016858,0.0057095,0.0012964,0.0021081,-7.1884E-4,0.002578,0.0035112,0.0076856,0.002923,0.0018762,3.4112E-4,0.0020189,-0.0064097,0.0070579,0.0055856,-0.0023777,0.0016113,0.006059,4.5068E-4,0.0017683,1.669E-4,0.0044679,0.0054605,0.0031088,0.0027007,0.0057463,0.0030256,0.0068696,0.0046596,2.8046E-4,0.0019561,-3.9863E-4,0.0084444,0.0035132,0.0029184,0.0077455,0.00317,0.0030565,-1.2306E-4,0.0015775,0.0016887,-0.0016173,0.0035062,0.0068885,0.0039562,0.0045255,0.0028096,0.0068678,0.0021437,-0.0040612,0.0047852,0.0068302,0.0050815,0.010212,-3.4329E-4,0.0034945,0.0042962,0.0041062,0.0042213,0.0011412,0.0021882,0.0069957,0.0044339,0.0036851,0.0037051,0.0049058,0.0063003,0.0066193,-5.4109E-4,0.0021306,0.006722,0.0046333,0.0020335,-0.002052,-0.0026847,0.0028356,-2.7643E-5,0.003815,5.1662E-4,-0.0027764,0.0011026,0.001171,0.0031748,-0.0035791,0.003211,0.0060941,-0.0015969,0.0030382,0.0061276,7.4386E-4,0.006668,-0.0033648,0.0045989,0.002124,0.0012769,0.0014586,1.9535E-4,0.0089293,-0.0015731,-0.0011034,0.0065168,0.0013846,0.0050774,0.0086969,-7.4157E-4,2.9459E-4,0.001935,0.0046756,4.5586E-4,-0.0015156,0.0017611,0.0083154,0.0050394,-3.9949E-4,0.0018977,0.0073279,0.0032987,0.0066465,0.0025322,-0.0034895,0.0056943,0.0012173,0.0014174,0.0029437,0.0011108,0.0062429,0.0076145,0.0041081,0.002235,0.0011283,0.004981,0.0022368,0.011092,-0.0029864,-0.0024286,0.0017523,0.005095,0.0040429,0.0034129,0.0010878,0.0027478,0.0041133,0.010138,0.0074841,-0.0019266,0.0033496,-0.0014738,0.0037886,0.0039892,0.0027475,-4.841E-4,0.0055125,0.0055929,0.0038915,0.0028235,0.0081243,0.0031716,0.0068945,0.0080047,0.0020701,0.0021141,0.0026454,0.0040741,0.0032593,-0.0032628,0.0011293,0.0042117,0.0044284,0.002309,4.2974E-4,0.0054494,0.0072268,0.006663,0.002471,0.0033448,0.0055709,0.0028773,0.0091019,-2.2593E-5,-0.0020561,6.3137E-4,-0.003001,0.0069049,9.2537E-4,0.0029642,0.001626,0.0042837,0.0022407,2.5789E-4,0.0017571,0.0010172,9.2492E-4,0.0063534,-2.1443E-4,0.0018143,0.0055245,-0.0060816,0.014759,-0.0061201,0.0086245,0.0058681,-0.0036722,0.010314,-0.0086961,0.0096294,0.0083819,-0.0032957,0.16606,0.55161,0.66485,0.3461,0.17697,0.27185,0.2533,0.52261,0.35152,0.18263,0.27672,0.2613,0.53484,0.36878,0.18344,0.27985,0.2714,0.55637,0.37191,0.19293,0.29388,0.28582,0.57326,0.39117,0.20293,0.30661,0.29357,0.60625,0.41335,0.2199,0.31864,0.31107,0.62748,0.43329,0.23366,0.33854,0.3349,0.67676,0.46027,0.26017,0.3685,0.35872,0.73373,0.49362,0.28158,0.4032,0.39863,0.81198,0.55585,0.32788,0.44676,0.44391,0.8947,0.61153,0.37502,0.49842,0.50398,0.97705,0.67829,0.42321,0.54296,0.55251,1.0956,0.75582,0.47822,0.60457,0.61216,1.1759,0.81051,0.51984,0.63992,0.64532,1.2131,0.83168,0.52682,0.64561,0.66927,1.2619,0.89477,0.57582,0.70582,0.74688,1.3434,0.9792,0.63966,0.77075,0.82985,1.4404,1.0539,0.70229,0.84001,0.93464,1.527,0.51509,0.20193,0.30364,0.26112,0.52906,0.38646,0.20893,0.28897,0.27557,0.52866,0.38535,0.21176,0.28611,0.27372,0.52195,0.38511,0.21099,0.28719,0.27586,0.52277,0.37896,0.2071,0.28207,0.27268,0.52747,0.38171,0.20545,0.28243,0.26464,0.52727,0.38242,0.20106,0.28401,0.27,0.53278,0.37272,0.20301,0.28476,0.26737,0.53479,0.37456,0.19806,0.27768,0.26382,0.53291,0.37951,0.19262,0.2823,0.27262,0.52791,0.37462,0.2026,0.28679,0.26625,0.52575,0.36921,0.19932,0.28235,0.26513,0.52019,0.37281,0.19385,0.27932,0.26224,0.52602,0.37391,0.19462,0.27914,0.27051,0.52778,0.37467,0.19595,0.28148,0.27021,0.5233,0.3757,0.19388,0.28429,0.27138,0.52561,0.36572,0.19736,0.2784,0.26795,0.52435,0.37381,0.20251,0.2814,0.26687,0.52855,0.37112,0.19635,0.27455,0.26174,0.52439:1
0.0040556,-6.2995E-4,1.1465E-4,6.9873E-4,0.006714,0.0074401,0.0023911,0.0014744,0.0030632,5.3245E-4,0.0050392,0.0064589,0.0045328,-0.0026335,0.0092471,-6.2649E-4,-0.0025546,0.0012914,0.0029025,0.003104,0.0096824,-0.01145,-2.9472E-4,0.0043289,0.002079,0.0031858,-0.0042751,0.0065002,0.0046999,0.0053937,0.001982,0.0014719,0.0090244,0.0039527,0.0047243,0.0049557,0.0025747,0.0050938,0.0014238,0.0067508,0.008242,-3.3758E-4,0.0032015,-6.7589E-4,0.0033987,5.0745E-4,0.0033327,0.0054089,0.0027778,0.0060886,0.0085957,-0.0011151,0.0019524,-0.0051804,0.0050103,0.0070142,0.0013524,0.0091792,-0.001788,0.0028911,0.0023229,-0.0015723,0.0092893,0.0048438,0.0044481,0.0055369,-0.0050506,0.0055226,0.0027489,0.011232,0.0049186,0.0011392,0.0095262,-0.0070518,0.0054687,0.01122,-0.0056598,0.01354,-0.0042668,0.0095379,0.0088931,-0.0020663,0.0093615,4.976E-4,0.0098197,0.0082907,0.0015366,0.0085954,0.0017867,0.012153,0.0093116,-9.7634E-4,0.01101,-0.0029755,0.014074,0.0031679,-0.0046115,0.013052,-0.0015194,0.0032839,0.0036418,0.0039678,0.0067221,-6.4379E-4,0.012228,9.5238E-4,-0.0037815,0.011885,-0.0060291,0.0051152,0.0067628,9.7761E-4,0.012134,-0.0028699,0.013315,0.0065887,-0.0043739,0.0096208,-0.0057413,0.010941,0.0042094,-0.005523,0.0093519,-0.0051298,0.0076276,0.0089861,-0.0027961,0.012106,-0.0020769,5.5504E-4,-2.6372E-4,-0.0035025,0.012356,-0.0072368,0.0039514,-1.0201E-4,-0.0026491,0.0033082,-9.0649E-4,0.0084478,0.0076421,-0.0036878,0.012066,-0.0054053,0.0098773,0.0039082,-0.0055409,0.014728,-0.0048233,0.0089219,-0.0022009,-0.0027069,0.013212,3.281E-5,0.0090542,0.0029297,-0.0048123,0.010361,-0.005714,0.0024876,0.013563,-0.002166,0.0065318,-0.0025609,0.01181,0.0028774,-0.0029892,0.010454,-0.0056208,0.0031037,0.0046758,0.0033074,0.0072495,-0.0026782,0.0067794,0.010342,-0.0036119,0.0092056,-0.0031057,0.011103,0.010032,-1.774E-4,0.019022,-0.0023411,0.0063487,0.0080051,-6.4031E-4,0.011829,-0.010615,0.012615,0.0022999,-0.0079292,0.011372,-0.0041923,0.011387,0.0055323,-0.0023659,0.0077439,-0.0022785,0.0076721,0.0024336,-0.013539,0.012013,-0.0089322,0.013747,0.0061507,-0.0092058,0.018133,5.2765E-4,0.0047755,0.013077,-0.012911,0.020211,-0.0054565,1.04,0.32291,0.27132,0.36502,0.58432,0.5141,0.29219,0.31001,0.39292,0.6442,0.55887,0.32504,0.34769,0.43383,0.71959,0.61857,0.36634,0.40196,0.49208,0.82785,0.69973,0.43052,0.45104,0.57582,0.93013,0.80055,0.51211,0.53169,0.65255,1.0812,0.9128,0.59863,0.612,0.74479,1.2148,1.0123,0.65256,0.66297,0.77725,1.2529,1.0306,0.66369,0.66914,0.79859,1.3027,1.1022,0.72854,0.7387,0.86695,1.4149,0.63595,0.22473,0.2553,0.30231,0.44019,0.45082,0.22482,0.24201,0.30608,0.43955,0.45381,0.22506,0.23643,0.3044,0.43777,0.45453,0.22379,0.23856,0.30592,0.43927,0.4538,0.21886,0.23917,0.30703,0.43832,0.4495,0.21908,0.2392,0.30542,0.44403,0.44695,0.22237,0.24277,0.30177,0.43588,0.4501,0.21945,0.2382,0.3056,0.43602,0.45152,0.22188,0.23041,0.30542,0.43979,0.44932,0.22244,0.23898,0.29948,0.40992,0.45889,0.21564,0.22954,0.30046,0.42555,0.45606,0.20962,0.22714,0.29477,0.4309,0.44496,0.21858,0.23411,0.29581,0.43449,0.44409,0.21492,0.23183,0.30285,0.42989,0.44889,0.21517,0.23433,0.3045,0.43105,0.44402,0.22449,0.23444,0.30819,0.43724,0.45108,0.21698,0.23351,0.30682,0.43206,0.45071,0.21665,0.23276,0.30725,0.43352,0.45125,0.22183,0.23192,0.30801,0.43428,0.45601,0.21834,0.23134,0.30627,0.43137,0.4551,0.22244,0.23594,0.29997,0.43309,0.45293,0.22341,0.23984,0.30261,0.42781,0.45469,0.21891,0.23447,0.30069,0.43176,0.45457,0.21374,0.23711,0.30146,0.4342,0.45501,0.2162,0.23446,0.29931,0.43527,0.45276,0.21728,0.23271,0.30021,0.43614,0.45242,0.21303,0.2339,0.29839,0.43129,0.4626:1
-0.019734,0.026355,-0.027385,0.013899,-0.01177,-0.011885,0.021298,-0.029373,0.012972,-0.0070121,-0.015745,0.023825,-0.026139,1.5896,0.079877,-0.012473,0.016659,-0.034116,0.022983,-0.0033213,-0.030456,0.012347,0.14903,0.66446,0.75824,0.39873,0.44855,0.42331,0.70869,0.7535,0.39321,0.43974,0.41587,0.69257,0.74648,0.38757,0.43146,0.41444,0.68391,0.74787,0.38239,0.4292,0.40598,0.66898,0.74399,0.37445,0.42382,0.40378,0.66617,0.73332,0.37306,0.4213,0.39592,0.65923,0.73613,0.36965,0.41915,0.3923,0.64669,0.73644,0.36095,0.41364,0.38846,0.64489,0.73585,0.35909,0.41496,0.38835,0.63757,0.72356,0.36123,0.41204,0.38624,0.64055,0.73003,0.35527,0.40243,0.3844,0.63246,0.73104,0.36167,0.40473,0.38265,0.62155,0.72652,0.35653,0.39953,0.38127,0.61421,0.73086,0.3521,0.3965,0.37744,0.60892,0.72898,0.35128,0.39713,0.38066,0.6002,0.7363,0.35,0.39353,0.37105,0.59927,0.73281,0.34787,0.39243,0.37461,0.59666,0.73833,0.34303,0.39402,0.36418,0.592,0.73658,0.35044,0.38095,0.37271,0.5865,0.73881,0.35026,0.38483,0.37096,0.58255,0.73612,0.34921,0.38689,0.36986,0.57775,0.74121,0.35102,0.38587,0.36717,0.57018,0.74629,0.34496,0.38301,0.36351,0.56434,0.74054,0.34717,0.38325,0.36518,0.57396,0.75139,0.3503,0.38534,0.36638,0.55791,0.74585,0.34777,0.38054,0.3591,0.55992,0.74752,0.35276,0.36917,0.36085,0.55261,0.74348,0.35071,0.37313,0.3662,0.54237,0.75002,0.35447,0.36834,0.36868,0.54362,0.7487,0.35079,0.36414,0.36556,0.54452,0.7461,0.35539,0.36911,0.36153,0.54204,0.75362,0.3483,0.36673,0.36208,0.52777,0.75315,0.3497,0.36641,0.35168,0.52417,0.75838,0.34981,0.36721,0.36032,0.52048,0.76442,0.3549,0.3715,0.3552,0.51471,0.76244:1
-6.6106E-4,-0.011495,0.022366,-0.025365,0.012317,-0.0033549,-0.007679,0.021639,-0.024796,0.017581,1.6967,-0.0032598,0.049975,-0.026824,0.030075,0.0076316,-0.028827,0.013145,-0.029801,0.44893,0.62983,0.37413,0.46267,0.41404,0.76877,0.68296,0.37553,0.45509,0.41694,0.75926,0.68151,0.37401,0.44321,0.41293,0.73978,0.67689,0.36672,0.43294,0.41122,0.73158,0.67275,0.35718,0.43272,0.40458,0.72298,0.67447,0.35946,0.42862,0.40498,0.7216,0.67294,0.35248,0.41781,0.4048,0.71478,0.6726,0.34766,0.424,0.39731,0.71032,0.66881,0.34489,0.41668,0.39892,0.70595,0.67135,0.35061,0.41425,0.39539,0.69261,0.66787,0.34692,0.41739,0.39512,0.69426,0.66839,0.33939,0.40698,0.38918,0.68622,0.67517,0.33527,0.40586,0.38593,0.67931,0.67798,0.34509,0.40602,0.38696,0.6741,0.67628,0.33252,0.40468,0.38487,0.66941,0.67229,0.33678,0.39814,0.3851,0.66656,0.68011,0.33412,0.39454,0.38527,0.65717,0.67662,0.34571,0.39707,0.38619,0.64697,0.67397,0.33541,0.39759,0.37601,0.64046,0.68398,0.33993,0.39292,0.38371,0.63594,0.68563,0.33907,0.39295,0.37013,0.63603,0.69263,0.33631,0.39304,0.37199,0.62811,0.69438,0.33843,0.38979,0.36457,0.62141,0.6934,0.33744,0.38763,0.37366,0.61891,0.69602,0.33141,0.38964,0.37389,0.61623,0.69547,0.33682,0.38585,0.37432,0.60666,0.6966,0.33667,0.37923,0.37005,0.59724,0.7062,0.33764,0.38721,0.36609,0.59937,0.70543,0.3355,0.38313,0.36553,0.59135,0.713,0.33252,0.37694,0.36603,0.58955,0.71632,0.33867,0.3742,0.36311,0.58592,0.71216,0.34077,0.38288,0.36257,0.58161,0.7184,0.33928,0.37759,0.36544,0.5677,0.7239,0.34291,0.3815,0.36601,0.56375,0.71888,0.33739,0.37567,0.3619,0.56058,0.72351,0.34166,0.37219,0.3624,0.55511:1
0.026385,-0.028099,0.0081821,0.012397,-0.02341,0.025342,-0.01677,0.0052922,0.010525,-0.029698,0.026548,-0.02149,0.0016571,0.015018,-0.021773,0.026189,-0.024833,0.0032248,0.011034,-0.024046,0.022589,1.2492,0.43326,-0.0097554,-0.041728,0.026093,-0.035465,0.0048837,4.2012E-4,-0.041267,0.079285,0.3722,0.61408,0.26217,0.23206,0.38555,0.47143,0.63235,0.27578,0.25133,0.38339,0.47823,0.62943,0.28432,0.24858,0.39115,0.47376,0.63938,0.27685,0.24975,0.38508,0.47446,0.6474,0.2825,0.25066,0.38768,0.47321,0.64785,0.28377,0.25604,0.38655,0.4658,0.65134,0.28324,0.25502,0.38502,0.4703,0.65095,0.2812,0.25443,0.3843,0.46806,0.65863,0.29866,0.26336,0.38344,0.46668,0.65857,0.29319,0.25935,0.38532,0.46363,0.66126,0.29221,0.25725,0.38688,0.46435,0.66564,0.29317,0.25699,0.39047,0.46213,0.66952,0.28267,0.25671,0.39002,0.45632,0.66961,0.29121,0.25622,0.38264,0.45954,0.66716,0.29073,0.26204,0.38997,0.45389,0.67387,0.29409,0.25966,0.38269,0.45775,0.67006,0.29639,0.25881,0.37983,0.45806,0.67462,0.30054,0.26096,0.38301,0.45312,0.67622,0.29483,0.26222,0.38191,0.44692,0.6851,0.29073,0.26632,0.37921,0.44663,0.68662,0.29915,0.26768,0.38454,0.44368,0.68466,0.30021,0.2611,0.38046,0.44425,0.68248,0.29631,0.25545,0.38082,0.44666,0.69093,0.30105,0.2584,0.38946,0.43673,0.69096,0.30497,0.25726,0.3827,0.43477,0.69345,0.30401,0.25968,0.38591,0.43739,0.69651,0.30395,0.26301,0.38507,0.43303,0.69484,0.30043,0.26113,0.38572,0.43101,0.69641,0.29667,0.26176,0.38142,0.42889,0.69883,0.30502,0.26523,0.38244,0.42588,0.70187,0.30847,0.26058,0.37963,0.4243,0.69859,0.30945,0.26566,0.38031,0.42076,0.70223,0.30949,0.25885,0.38408,0.4215,0.70925,0.30156,0.26169:1
-0.0057211,0.018326,-0.01208,0.0077648,0.0010486,-0.010973,0.013041,-0.018855,1.2336,1.5055,1.0357,1.1737,1.4849,1.8183,1.498,1.0748,1.1952,1.5655,1.8598,1.5431,1.101,1.2363,1.613,1.9054,1.5697,1.1226,1.2114,1.394,1.3132,0.79001,0.53986,0.61589,0.6254,1.0954,0.73733,0.51998,0.60126,0.61624,1.0861,0.73266,0.50857,0.60964,0.6022,1.0798,0.72438,0.49949,0.60186,0.58948,1.0821,0.71979,0.49081,0.58605,0.58464,1.074,0.70375,0.48419,0.58454,0.576,1.0691,0.69768,0.49416,0.57926,0.57107,1.0701,0.69955,0.47764,0.57734,0.56067,1.0632,0.69003,0.48002,0.57008,0.55673,1.0487,0.68861,0.46941,0.57195,0.54895,1.0536,0.68595,0.47002,0.56532,0.54668,1.0501,0.67821,0.47724,0.55968,0.54752,1.0472,0.67888,0.45893,0.55956,0.54543,1.0447,0.68121,0.46204,0.55738,0.53962,1.0366,0.67962,0.45322,0.55312,0.53157,1.0412,0.66626,0.45633,0.55674,0.5316,1.0348,0.67584,0.44823,0.55548,0.53041,1.0315,0.66403,0.45508,0.54571,0.53223,1.0257,0.66859,0.44462,0.54893,0.52435,1.0295,0.66529,0.44769,0.54346,0.52872,1.0227,0.66463,0.4499,0.53979,0.52829,1.0229,0.66169,0.44884,0.53809,0.51974,1.0184,0.65653,0.44757,0.5393,0.52416,1.0095,0.6726,0.44205,0.54284,0.51973,1.0157,0.66056,0.44425,0.53791,0.52387,1.0058,0.66613,0.43977,0.53431,0.51468,1.0081,0.66192,0.44595,0.53307,0.5219,1.0013,0.66277,0.44173,0.53671,0.51906,0.99997,0.66538,0.4422,0.53184,0.51776,0.99644,0.656,0.43941,0.52755,0.51528,0.99078,0.65829,0.43146,0.53031,0.5162,0.99771,0.65624,0.44175,0.53283,0.51924,0.98788,0.65807,0.43694,0.52313,0.51515,0.98948,0.65877,0.44254,0.51731,0.5156,0.98452,0.66442:1
0.011037,-0.011606,0.013056,-0.0073805,0.0011523,-6.4331E-4,-0.010758,0.010944,-0.0089303,-0.0019331,0.010339,-0.018277,0.013146,1.925,1.4858,1.1102,1.0066,1.2181,1.8173,1.5292,1.151,1.0684,1.2831,1.8788,1.5675,1.1806,1.1134,1.3268,1.9201,1.5977,1.1653,0.89008,0.7615,0.93237,0.72931,0.49617,0.46824,0.56061,0.87835,0.71938,0.48822,0.45781,0.54794,0.8705,0.71274,0.48511,0.44742,0.54357,0.86302,0.70265,0.47337,0.45264,0.5288,0.85832,0.68864,0.47456,0.44508,0.53565,0.85064,0.69602,0.46162,0.44479,0.53041,0.85362,0.69567,0.46902,0.44382,0.53035,0.84979,0.69665,0.45855,0.44483,0.53173,0.84511,0.6871,0.45863,0.44224,0.52688,0.84784,0.6878,0.4636,0.43975,0.53399,0.8404,0.69323,0.45568,0.43866,0.52609,0.84062,0.6895,0.46098,0.43772,0.52974,0.83559,0.69473,0.4486,0.43362,0.52472,0.8435,0.68702,0.45394,0.42954,0.52701,0.83651,0.68626,0.45814,0.43637,0.52538,0.83495,0.68329,0.44921,0.43144,0.52741,0.83075,0.68483,0.45182,0.42967,0.52327,0.83775,0.68676,0.44711,0.43599,0.52296,0.83236,0.68135,0.45723,0.4329,0.52366,0.83101,0.68314,0.44517,0.43764,0.52316,0.83901,0.68243,0.45093,0.42737,0.53106,0.82589,0.68894,0.44368,0.4319,0.5179,0.8371,0.6797,0.45283,0.42959,0.5223,0.82464,0.67921,0.45361,0.42774,0.51592,0.83,0.67726,0.45481,0.42833,0.51655,0.83319,0.67723,0.45188,0.4291,0.52488,0.8223,0.68502,0.44749,0.42132,0.51224,0.82648,0.67863,0.4483,0.42142,0.51635,0.82097,0.67575,0.43981,0.42934,0.51611,0.82735,0.67406,0.45092,0.42953,0.52128,0.8233,0.67099,0.44973,0.42249,0.51949,0.82805,0.67431,0.45011,0.42274,0.51456,0.8204,0.67675,0.45042,0.4275,0.51351,0.81716,0.68:1
-2.5558E-4,-3.9001E-4,4.377E-4,-8.5815E-4,5.9856E-4,-1.171E-4,-4.8722E-4,6.1754E-4,-7.3721E-4,3.3218E-4,-2.394E-4,-4.7972E-4,6.443E-4,-8.9144E-4,5.6655E-4,-8.9897E-5,0.08238,0.10007,0.088766,0.11612,0.12369,0.11927,0.095121,0.093975,0.11389,0.12557,0.12013,0.095172,0.09507,0.11374,0.12581,0.12034,0.095105,0.095139,0.11355,0.1258,0.12062,0.095229,0.095327,0.11389,0.12592,0.12081,0.094805,0.095207,0.11373,0.12634,0.12101,0.095135,0.095302,0.11361,0.12622,0.12079,0.09507,0.095231,0.11346,0.12624,0.1209,0.095042,0.095129,0.11354,0.12607,0.12062,0.095051,0.095017,0.11326,0.12666,0.12085,0.094992,0.095118,0.1132,0.1264,0.12055,0.095037,0.094893,0.11305,0.12581,0.12084,0.094827,0.094642,0.11318,0.12577,0.1203,0.094596,0.094599,0.11278,0.12604,0.1204,0.094044,0.094528,0.11281,0.12551,0.12019,0.094305,0.094199,0.11264,0.12538,0.11989,0.094152,0.094162,0.11218,0.12495,0.11947,0.094103,0.094018,0.11235,0.1248,0.11927,0.093886,0.093707,0.11174,0.12507,0.11937,0.093649,0.093596,0.11141,0.12463,0.11887,0.093496,0.093348,0.11135,0.12421,0.11865,0.09313,0.093191,0.11085,0.1242,0.11827,0.093155,0.092615,0.11073,0.12368,0.11855,0.092699,0.092812,0.11008,0.12394,0.1182,0.092809,0.092288,0.11033,0.123,0.11757,0.092533,0.091904,0.10984,0.12282,0.11744,0.092271,0.092062,0.1096,0.12245,0.11734,0.092025,0.09185,0.10946,0.12246,0.11693,0.092019,0.091851,0.10913,0.12172,0.11686,0.091553,0.091116,0.10869,0.12169,0.11622,0.091368,0.090663,0.10832,0.12121,0.11561,0.09112,0.09047,0.10789,0.12105,0.11566,0.09064,0.090253,0.10764,0.12053,0.11478,0.09056,0.090065,0.10755,0.11992,0.1146,0.090172,0.08971,0.10722,0.12036,0.11421,0.089922,0.089172,0.10671,0.11982,0.1144,0.089703,0.089287,0.10636:2
1.423E-4,-8.2227E-4,9.4333E-4,-6.1981E-4,3.0763E-4,2.3089E-4,-5.621E-4,9.1525E-4,-6.4876E-4,5.3506E-4,3.5247E-4,-7.1455E-4,6.3212E-4,-6.4282E-4,1.8452E-4,2.6886E-4,-4.2094E-4,7.4527E-4,-7.0979E-4,3.1336E-4,-5.5357E-5,-6.49E-4,7.6307E-4,-3.7898E-4,4.6287E-4,1.292E-4,-4.9271E-4,0.048103,0.10258,0.11888,0.12082,0.10302,0.087862,0.10083,0.1193,0.12111,0.10341,0.08807,0.10109,0.11981,0.12207,0.1043,0.088092,0.10174,0.11972,0.12217,0.10436,0.088264,0.10155,0.11984,0.12216,0.105,0.088425,0.10139,0.11979,0.12221,0.10463,0.088395,0.10148,0.11999,0.12248,0.10479,0.088414,0.10133,0.1199,0.12279,0.10503,0.08845,0.10134,0.12,0.12271,0.10526,0.088496,0.10138,0.11976,0.12265,0.10516,0.088293,0.10071,0.11943,0.12265,0.10548,0.08841,0.10088,0.11938,0.12272,0.1054,0.087986,0.10071,0.11912,0.12232,0.10567,0.087947,0.10028,0.11891,0.12214,0.10536,0.087953,0.09989,0.11846,0.12267,0.10502,0.087998,0.099588,0.11843,0.12188,0.10527,0.087719,0.099881,0.11801,0.12181,0.10521,0.087516,0.099346,0.11795,0.12172,0.10515,0.087594,0.099184,0.11739,0.12163,0.10532,0.087347,0.098447,0.11753,0.12148,0.10548,0.087232,0.098191,0.11743,0.12114,0.10503,0.087003,0.098023,0.11682,0.12078,0.10485,0.086829,0.097741,0.11633,0.12064,0.10497,0.086489,0.097306,0.11583,0.12043,0.10435,0.086398,0.096829,0.11561,0.12022,0.10419,0.08619,0.09675,0.11542,0.12015,0.10364,0.086118,0.095962,0.11517,0.11958,0.1038,0.085865,0.095587,0.11474,0.1193,0.10342,0.085868,0.095054,0.11431,0.11855,0.1032,0.085258,0.095252,0.11371,0.11858,0.10302,0.084995,0.09469,0.11361,0.11806,0.10299,0.08482,0.094424,0.11343,0.11782,0.10285,0.084588,0.093879,0.11268,0.11747,0.10238,0.084257,0.093692,0.11235,0.11716,0.10237,0.083742,0.0933,0.11169:2
3.2589E-4,3.5826E-4,-6.1862E-4,6.1495E-4,-3.582E-4,1.817E-5,5.4093E-4,-5.5255E-4,8.8997E-4,-6.8364E-4,3.3255E-4,4.8559E-4,-4.9414E-4,6.178E-4,-2.6193E-4,4.8167E-5,4.9716E-4,-8.446E-4,8.8278E-4,-4.8333E-4,2.3797E-5,0.12577,0.096608,0.094193,0.11527,0.12911,0.11555,0.096478,0.094923,0.11524,0.12966,0.11621,0.096253,0.095247,0.11518,0.12957,0.11651,0.09695,0.09498,0.1153,0.12954,0.11728,0.09686,0.095215,0.11517,0.12967,0.11729,0.097189,0.095093,0.11538,0.12985,0.11711,0.096868,0.095157,0.11559,0.12991,0.11755,0.097086,0.095001,0.11522,0.12973,0.11803,0.096908,0.094963,0.11485,0.1297,0.11779,0.097565,0.094861,0.11525,0.12936,0.11755,0.097189,0.094825,0.11451,0.12913,0.11794,0.097303,0.094231,0.11473,0.12953,0.1181,0.097321,0.094219,0.11405,0.12889,0.11817,0.097267,0.093806,0.11423,0.12874,0.11768,0.097338,0.094103,0.11414,0.12881,0.11792,0.097338,0.093616,0.11337,0.12875,0.11744,0.097382,0.093393,0.11319,0.12831,0.11773,0.096979,0.093495,0.11268,0.12811,0.11744,0.09683,0.092836,0.11303,0.12805,0.11788,0.096899,0.092424,0.11249,0.12694,0.11767,0.096566,0.092569,0.11204,0.1271,0.11714,0.096372,0.092184,0.11195,0.12644,0.11729,0.096364,0.091808,0.11112,0.12646,0.11678,0.096221,0.091567,0.11078,0.1262,0.1165,0.095964,0.091249,0.11051,0.12562,0.11642,0.09599,0.091115,0.11051,0.12567,0.11666,0.095534,0.090751,0.10981,0.12519,0.11622,0.095236,0.090671,0.10941,0.12498,0.11581,0.095037,0.090507,0.10873,0.12423,0.1158,0.095067,0.089935,0.10882,0.12383,0.11548,0.094817,0.089436,0.10825,0.12366,0.11516,0.094774,0.08928,0.10786,0.12334,0.11489,0.094064,0.088983,0.10731,0.12281,0.11444,0.094254,0.088589,0.107,0.12237,0.11418,0.093968,0.088347,0.10667,0.12199,0.11437,0.093631,0.087697,0.10607:2
6.9E-7,8.3667E-7,-1.25E-6,1.6767E-6,-2.4333E-7,1.1333E-6,1.8367E-6,-1.03E-6,1.5667E-6,-4.4E-7,1.2E-7,1.19E-6,-9.3E-7,1.1533E-6,-7.5E-7,3.2667E-7,1.9033E-6,-8.0333E-7,2.0367E-6,-5.1667E-7,7.2E-7,6.3E-7,-8.7E-7,1.17E-6,-1.8E-7,5.9333E-7,1.32E-6,-1.6967E-6,1.0467E-6,-3.8333E-7,1.72E-6,1.5467E-6,-1.3167E-6,1.5467E-6,-3.9E-7,-1.1667E-7,9.2333E-7,-8.7667E-7,1.4367E-6,-1.7667E-7,8.6333E-7,1.7133E-6,-5.7333E-7,1.6333E-6,-1.7233E-6,1.5633E-6,2.0567E-6,-4.2667E-7,1.3767E-6,-1.57E-6,4.1E-7,1.1967E-6,-4.3667E-7,2.2933E-6,-1.4367E-6,4.7333E-7,1.14E-6,-8.4E-7,1.6633E-6,-1.3167E-6,1.1433E-6,1.23E-6,-1.8E-7,1.4433E-6,-6.6667E-8,2.5333E-7,1.8367E-6,-8.8333E-7,1.63E-6,-4.1667E-7,1.0867E-6,6.9333E-7,-8.2667E-7,1.7067E-6,-9.0E-7,7.2E-7,1.09E-6,-1.4267E-6,2.4833E-6,-6.3E-7,4.5333E-7,1.32E-6,-6.0667E-7,1.74E-6,1.5333E-7,1.244E-4,1.7315E-4,1.633E-4,1.1956E-4,1.429E-4,1.5389E-4,1.775E-4,1.5689E-4,1.2404E-4,1.4034E-4,1.5486E-4,1.7899E-4,1.5687E-4,1.2508E-4,1.4007E-4,1.5495E-4,1.7789E-4,1.5734E-4,1.2605E-4,1.4158E-4,1.5557E-4,1.787E-4,1.5825E-4,1.2684E-4,1.4133E-4,1.5477E-4,1.7848E-4,1.5751E-4,1.2709E-4,1.4242E-4,1.5573E-4,1.7856E-4,1.5767E-4,1.2735E-4,1.4175E-4,1.556E-4,1.7854E-4,1.5838E-4,1.2631E-4,1.4105E-4,1.5586E-4,1.7952E-4,1.5962E-4,1.2695E-4,1.4175E-4,1.5464E-4,1.798E-4,1.6133E-4,1.2643E-4,1.4196E-4,1.5471E-4,1.7998E-4,1.6004E-4,1.2656E-4,1.4167E-4,1.5416E-4,1.8099E-4,1.5956E-4,1.2708E-4,1.4222E-4,1.5428E-4,1.8081E-4,1.602E-4,1.2635E-4,1.4215E-4,1.5467E-4,1.801E-4,1.5973E-4,1.2725E-4,1.4128E-4,1.5416E-4,1.7973E-4,1.6143E-4,1.2762E-4,1.4255E-4,1.5435E-4,1.7999E-4,1.6166E-4,1.2724E-4,1.422E-4,1.5503E-4,1.7977E-4,1.6176E-4,1.2643E-4,1.4198E-4,1.55E-4,1.7982E-4,1.6324E-4,1.2758E-4,1.4142E-4,1.5448E-4,1.8029E-4,1.6154E-4,1.2688E-4,1.4178E-4,1.5341E-4,1.7994E-4,1.6318E-4,1.2643E-4,1.419E-4,1.5397E-4,1.792E-4,1.6345E-4,1.2698E-4,1.4175E-4,1.5322E-4,1.8002E-4,1.613E-4,1.273E-4,1.4241E-4,1.5417E-4,1.7953E-4,1.6249E-4,1.2766E-4,1.4131E-4,1.524E-4,1.8018E-4,1.624E-4,1.2756E-4,1.4032E-4,1.5355E-4,1.7979E-4,1.6254E-4,1.2718E-4,1.4115E-4,1.5371E-4,1.7897E-4,1.6167E-4,1.2765E-4,1.4071E-4,1.5258E-4,1.7952E-4,1.6251E-4,1.2815E-4,1.4088E-4,1.5342E-4,1.7937E-4,1.6316E-4,1.2783E-4,1.4084E-4,1.5354E-4,1.7944E-4,1.6285E-4,1.2849E-4,1.3963E-4,1.5247E-4,1.7904E-4,1.6317E-4,1.2851E-4,1.4093E-4,1.5328E-4,1.8039E-4,1.6342E-4,1.2737E-4,1.4162E-4,1.5389E-4,1.7938E-4,1.6317E-4,1.2772E-4,1.4024E-4,1.5291E-4,1.7968E-4,1.6436E-4,1.2764E-4,1.4072E-4,1.5338E-4,1.7972E-4,1.6359E-4,1.2642E-4,1.4057E-4,1.5305E-4,1.7885E-4,1.6383E-4,1.2772E-4,1.4126E-4,1.5289E-4,1.7949E-4,1.6367E-4,1.2768E-4,1.4044E-4,1.5354E-4,1.795E-4,1.6393E-4,1.2717E-4,1.4083E-4,1.5212E-4,1.7988E-4,1.6329E-4,1.2707E-4,1.4115E-4,1.5281E-4,1.8031E-4,1.6445E-4,1.2645E-4,1.3954E-4,1.5334E-4,1.8129E-4,1.6393E-4,1.2683E-4,1.3973E-4,1.5242E-4,1.8066E-4,1.6578E-4,1.2845E-4,1.4007E-4,1.5182E-4,1.8057E-4,1.6502E-4,1.2788E-4,1.3977E-4,1.5158E-4,1.7936E-4,1.6249E-4,1.2605E-4,1.3866E-4,1.5163E-4,1.8002E-4,1.6376E-4,1.2667E-4,1.4035E-4,1.5194E-4,1.8046E-4,1.6479E-4,1.2712E-4,1.3988E-4,1.5133E-4,1.799E-4,1.6434E-4,1.2776E-4,1.391E-4,1.5037E-4,1.7758E-4,1.6528E-4,1.2868E-4,1.4041E-4,1.5152E-4,1.7841E-4,1.6307E-4,1.2778E-4,1.3997E-4,1.5066E-4,1.791E-4,1.6451E-4,1.2643E-4,1.3875E-4,1.5175E-4,1.7932E-4,1.647E-4,1.2749E-4,1.3893E-4,1.4974E-4,1.7927E-4,1.6589E-4,1.2788E-4,1.3875E-4,1.4944E-4,1.7819E-4,1.6449E-4,1.2711E-4,1.3864E-4,1.499E-4,1.7912E-4,1.6567E-4,1.2643E-4,1.3937E-4,1.5053E-4,1.7814E-4,1.6502E-4,1.2774E-4,1.3832E-4,1.5052E-4,1.7719E-4,1.6546E-4,1.2745E-4,1.3901E-4,1.5005E-4,1.785E-4,1.6524E-4,1.2775E-4,1.3962E-4,1.5048E-4,1.7801E-4,1.6559E-4,1.2798E-4,1.3878E-4,1.5024E-4,1.7804E-4,1.6561E-4,1.2701E-4,1.3877E-4,1.5002E-4,1.7804E-4,1.6537E-4,1.2807E-4,1.3793E-4,1.4966E-4,1.7842E-4,1.6522E-4,1.2742E-4,1.3797E-4,1.4903E-4,1.7795E-4,1.6564E-4,1.2786E-4,1.3787E-4,1.4921E-4,1.7761E-4,1.6604E-4,1.2761E-4,1.3835E-4,1.5075E-4,1.7656E-4,1.6543E-4,1.2805E-4,1.382E-4,1.5015E-4,1.7848E-4,1.6416E-4,1.2687E-4,1.3759E-4,1.4889E-4,1.7691E-4,1.6314E-4,1.2757E-4,1.3816E-4,1.5012E-4,1.7797E-4,1.6431E-4,1.269E-4,1.3798E-4,1.4943E-4,1.7843E-4,1.6617E-4,1.2724E-4,1.3648E-4,1.483E-4,1.7747E-4,1.6517E-4,1.2704E-4,1.3775E-4,1.4819E-4,1.7689E-4,1.661E-4,1.2695E-4,1.3777E-4,1.49E-4,1.7697E-4,1.6574E-4,1.2794E-4,1.3803E-4,1.4804E-4,1.7608E-4,1.6593E-4,1.2881E-4,1.374E-4,1.4835E-4,1.7642E-4,1.655E-4,1.2697E-4,1.3732E-4,1.4867E-4,1.7564E-4,1.6576E-4,1.2726E-4,1.3668E-4,1.4821E-4,1.7712E-4,1.6547E-4,1.2782E-4,1.3739E-4,1.4803E-4,1.753E-4,1.6584E-4,1.2802E-4,1.3686E-4,1.4734E-4,1.769E-4,1.6597E-4,1.2672E-4,1.3716E-4,1.4812E-4,1.7747E-4,1.6512E-4,1.2698E-4,1.3663E-4,1.4856E-4,1.7718E-4,1.6571E-4,1.2771E-4,1.3681E-4,1.4819E-4,1.7711E-4,1.6648E-4,1.2829E-4,1.3711E-4,1.4736E-4,1.7599E-4,1.6578E-4,1.2665E-4,1.3658E-4,1.4761E-4,1.7623E-4,1.661E-4,1.2764E-4,1.3607E-4,1.4779E-4,1.7639E-4,1.6613E-4,1.2758E-4,1.3669E-4,1.4664E-4,1.7635E-4,1.6585E-4,1.2738E-4,1.3564E-4,1.4667E-4,1.7535E-4,1.6661E-4,1.2703E-4,1.3552E-4,1.4687E-4,1.0381E-4:2
1.8467E-6,-1.12E-6,1.16E-6,1.5E-6,-1.05E-6,1.7167E-6,-7.8333E-7,1.1933E-6,7.1E-7,-1.1067E-6,1.2267E-6,-5.5E-7,1.59E-6,2.1233E-6,-5.3E-7,1.62E-6,-4.2333E-7,1.21E-6,1.03E-6,-5.1333E-7,2.01E-6,-6.6E-7,6.8E-7,1.0367E-6,-3.8E-7,2.2E-6,1.1333E-7,8.9667E-7,1.05E-6,-3.3667E-7,1.16E-6,-1.93E-6,9.0E-7,9.1667E-7,-1.05E-6,1.4667E-6,-1.09E-6,9.0333E-7,1.08E-6,-1.1733E-6,8.1333E-7,-5.1E-7,4.3333E-8,1.2867E-6,-1.1333E-7,1.7033E-6,-6.5E-7,9.5667E-7,3.8833E-5,1.8302E-4,1.1406E-4,1.4425E-4,1.4674E-4,1.7228E-4,1.6339E-4,1.266E-4,1.3696E-4,1.5031E-4,1.7321E-4,1.6242E-4,1.2815E-4,1.3534E-4,1.4975E-4,1.7294E-4,1.6329E-4,1.2911E-4,1.3703E-4,1.5107E-4,1.7359E-4,1.6405E-4,1.2964E-4,1.3709E-4,1.5132E-4,1.7453E-4,1.6493E-4,1.2891E-4,1.3632E-4,1.5116E-4,1.7497E-4,1.6594E-4,1.296E-4,1.3591E-4,1.5048E-4,1.7468E-4,1.6699E-4,1.2914E-4,1.3634E-4,1.5066E-4,1.7549E-4,1.6707E-4,1.3002E-4,1.3514E-4,1.4945E-4,1.7537E-4,1.6817E-4,1.3085E-4,1.3628E-4,1.5106E-4,1.7461E-4,1.6745E-4,1.3074E-4,1.351E-4,1.4978E-4,1.753E-4,1.68E-4,1.3117E-4,1.3648E-4,1.4923E-4,1.7565E-4,1.6815E-4,1.3026E-4,1.3556E-4,1.5013E-4,1.7559E-4,1.6941E-4,1.3153E-4,1.3645E-4,1.497E-4,1.748E-4,1.694E-4,1.3146E-4,1.3619E-4,1.4882E-4,1.7501E-4,1.6855E-4,1.3121E-4,1.3561E-4,1.4981E-4,1.754E-4,1.6973E-4,1.3187E-4,1.3618E-4,1.4917E-4,1.73E-4,1.6898E-4,1.3204E-4,1.3624E-4,1.4939E-4,1.7419E-4,1.6878E-4,1.3165E-4,1.3505E-4,1.4922E-4,1.7429E-4,1.6996E-4,1.325E-4,1.368E-4,1.502E-4,1.7513E-4,1.6979E-4,1.3255E-4,1.3674E-4,1.4878E-4,1.7341E-4,1.7028E-4,1.3218E-4,1.355E-4,1.4893E-4,1.7469E-4,1.6969E-4,1.3196E-4,1.3494E-4,1.4973E-4,1.7363E-4,1.7021E-4,1.3211E-4,1.3667E-4,1.4995E-4,1.7476E-4,1.7126E-4,1.3222E-4,1.3598E-4,1.495E-4,1.7553E-4,1.7157E-4,1.3254E-4,1.3484E-4,1.4708E-4,1.7441E-4,1.719E-4,1.3293E-4,1.3473E-4,1.4786E-4,1.735E-4,1.7177E-4,1.3269E-4,1.3459E-4,1.4787E-4,1.7374E-4,1.7165E-4,1.3255E-4,1.3562E-4,1.4748E-4,1.7354E-4,1.7297E-4,1.3381E-4,1.3602E-4,1.4755E-4,1.7391E-4,1.72E-4,1.3367E-4,1.3434E-4,1.4748E-4,1.7261E-4,1.7228E-4,1.3416E-4,1.3395E-4,1.4834E-4,1.7227E-4,1.7197E-4,1.3321E-4,1.3624E-4,1.4788E-4,1.7264E-4,1.7206E-4,1.3361E-4,1.3476E-4,1.4791E-4,1.7367E-4,1.7201E-4,1.3344E-4,1.3499E-4,1.4789E-4,1.7355E-4,1.7182E-4,1.3391E-4,1.3496E-4,1.477E-4,1.7311E-4,1.7247E-4,1.3265E-4,1.3407E-4,1.4661E-4,1.7327E-4,1.7182E-4,1.3324E-4,1.3426E-4,1.4742E-4,1.7383E-4,1.7222E-4,1.3166E-4,1.334E-4,1.4675E-4,1.7331E-4,1.7303E-4,1.3305E-4,1.3393E-4,1.4799E-4,1.7147E-4,1.7426E-4,1.3447E-4,1.3396E-4,1.4746E-4,1.7175E-4,1.7428E-4,1.3385E-4,1.3386E-4,1.4561E-4,1.7192E-4,1.7457E-4,1.3484E-4,1.334E-4,1.4617E-4,1.7123E-4,1.7381E-4,1.3519E-4,1.3368E-4,1.4652E-4,1.7145E-4,1.7296E-4,1.3427E-4,1.3442E-4,1.4562E-4,1.7233E-4,1.7526E-4,1.351E-4,1.344E-4,1.4638E-4,1.7185E-4,1.7361E-4,1.3466E-4,1.3362E-4,1.4699E-4,1.7056E-4,1.7321E-4,1.3446E-4,1.3502E-4,1.4651E-4,1.7093E-4,1.7253E-4,1.3483E-4,1.3347E-4,1.4565E-4,1.706E-4,1.7296E-4,1.356E-4,1.3414E-4,1.4632E-4,1.6993E-4,1.7442E-4,1.3538E-4,1.3426E-4,1.4566E-4,1.7018E-4,1.7411E-4,1.3546E-4,1.3448E-4,1.4505E-4,1.7186E-4,1.732E-4,1.3485E-4,1.3343E-4,1.4641E-4,1.7061E-4,1.7347E-4,1.3349E-4,1.3214E-4,1.4527E-4,1.7231E-4,1.7588E-4,1.3549E-4,1.333E-4,1.435E-4,1.7004E-4,1.7579E-4,1.3656E-4,1.3289E-4,1.4474E-4,1.6887E-4,1.7562E-4,1.364E-4,1.3395E-4,1.4569E-4,1.6968E-4,1.7506E-4,1.3629E-4,1.346E-4,1.4429E-4,1.6874E-4,1.7508E-4,1.3561E-4,1.3265E-4,1.4498E-4,1.6874E-4,1.7445E-4,1.3704E-4,1.327E-4,1.459E-4,1.6887E-4,1.7531E-4,1.3618E-4,1.34E-4,1.4525E-4,1.6926E-4,1.75E-4,1.3677E-4,1.3273E-4,1.445E-4,1.6834E-4,1.7549E-4,1.3658E-4,1.3289E-4,1.4397E-4,1.69E-4,1.7545E-4,1.3713E-4,1.3228E-4,1.453E-4,1.6903E-4,1.7493E-4,1.3739E-4,1.3331E-4,1.4389E-4,1.6822E-4,1.7595E-4,1.3735E-4,1.3237E-4,1.4378E-4,1.6856E-4,1.7725E-4,1.3679E-4,1.3216E-4,1.4392E-4,1.6749E-4,1.7499E-4,1.3786E-4,1.3185E-4,1.4384E-4,1.6687E-4,1.7496E-4,1.372E-4,1.3206E-4,1.4275E-4,1.6726E-4,1.7561E-4,1.3693E-4,1.1462E-4:2
3.0267E-6,1.5E-6,-2.9667E-7,2.8833E-6,6.6666E-9,2.2167E-6,9.5667E-7,-7.7667E-7,2.5233E-6,7.7667E-7,2.0433E-6,1.8433E-6,-7.6667E-8,2.4333E-6,9.1667E-7,9.4667E-7,2.1733E-6,-8.4333E-7,2.9933E-6,5.8667E-7,2.26E-6,1.8133E-6,-5.2333E-7,2.59E-6,4.9E-7,2.4467E-6,1.4967E-6,-1.1733E-6,3.0067E-6,8.1E-7,1.8467E-6,1.2067E-6,-7.7667E-7,2.4367E-6,1.1567E-6,1.6967E-6,2.14E-6,2.7143E-4,3.9839E-4,4.3248E-4,4.5298E-4,4.0535E-4,3.1294E-4,3.8821E-4,4.3698E-4,4.5844E-4,4.0405E-4,3.149E-4,3.8704E-4,4.3874E-4,4.5906E-4,4.0513E-4,3.1904E-4,3.882E-4,4.4034E-4,4.5868E-4,4.0429E-4,3.1794E-4,3.889E-4,4.3816E-4,4.5833E-4,4.0428E-4,3.18E-4,3.8903E-4,4.4E-4,4.5884E-4,4.0517E-4,3.1865E-4,3.8878E-4,4.3996E-4,4.6E-4,4.0479E-4,3.1889E-4,3.8911E-4,4.424E-4,4.6214E-4,4.0609E-4,3.1891E-4,3.8838E-4,4.4335E-4,4.6236E-4,4.039E-4,3.2085E-4,3.9013E-4,4.4225E-4,4.5984E-4,4.0423E-4,3.2015E-4,3.8963E-4,4.4323E-4,4.6168E-4,4.0501E-4,3.1914E-4,3.9015E-4,4.4463E-4,4.6221E-4,4.0551E-4,3.2182E-4,3.905E-4,4.4412E-4,4.6291E-4,4.0526E-4,3.1894E-4,3.9182E-4,4.4126E-4,4.6222E-4,4.0471E-4,3.1816E-4,3.9166E-4,4.4367E-4,4.6143E-4,4.0725E-4,3.1898E-4,3.9172E-4,4.4508E-4,4.6192E-4,4.0569E-4,3.1927E-4,3.9295E-4,4.4502E-4,4.6134E-4,4.0634E-4,3.205E-4,3.9301E-4,4.4478E-4,4.6344E-4,4.0413E-4,3.2036E-4,3.93E-4,4.4589E-4,4.6334E-4,4.0519E-4,3.2206E-4,3.934E-4,4.459E-4,4.629E-4,4.0464E-4,3.1904E-4,3.9064E-4,4.4556E-4,4.6095E-4,4.0474E-4,3.2123E-4,3.9174E-4,4.4341E-4,4.6045E-4,4.0447E-4,3.1931E-4,3.9208E-4,4.4661E-4,4.6334E-4,4.0368E-4,3.1999E-4,3.9178E-4,4.4555E-4,4.6248E-4,4.0383E-4,3.2133E-4,3.9406E-4,4.4558E-4,4.6204E-4,4.0373E-4,3.212E-4,3.941E-4,4.4702E-4,4.6255E-4,4.0452E-4,3.2052E-4,3.9296E-4,4.4547E-4,4.6015E-4,4.0328E-4,3.2033E-4,3.9401E-4,4.4759E-4,4.6218E-4,4.0073E-4,3.225E-4,3.9122E-4,4.475E-4,4.6014E-4,4.0318E-4,3.1909E-4,3.9539E-4,4.475E-4,4.6119E-4,4.0168E-4,3.2056E-4,3.911E-4,4.4744E-4,4.6119E-4,4.0291E-4,3.1897E-4,3.9258E-4,4.4474E-4,4.613E-4,4.0102E-4,3.2003E-4,3.933E-4,4.4552E-4,4.604E-4,4.0067E-4,3.1944E-4,3.9292E-4,4.4514E-4,4.6136E-4,4.0105E-4,3.2069E-4,3.9416E-4,4.4709E-4,4.6048E-4,4.0126E-4,3.1974E-4,3.9482E-4,4.4395E-4,4.5902E-4,4.0234E-4,3.2017E-4,3.9496E-4,4.4743E-4,4.608E-4,4.0026E-4,3.2065E-4,3.9484E-4,4.4702E-4,4.6074E-4,4.0125E-4,3.195E-4,3.9507E-4,4.4591E-4,4.6111E-4,4.003E-4,3.2136E-4,3.9291E-4,4.4641E-4,4.6154E-4,3.9886E-4,3.1954E-4,3.928E-4,4.4575E-4,4.594E-4,3.9931E-4,3.1959E-4,3.9254E-4,4.4721E-4,4.6315E-4,3.9843E-4,3.196E-4,3.9554E-4,4.462E-4,4.6064E-4,3.9627E-4,3.1829E-4,3.9365E-4,4.4535E-4,4.5667E-4,3.9772E-4,3.1961E-4,3.9187E-4,4.4623E-4,4.5926E-4,3.9678E-4,3.1916E-4,3.9484E-4,4.4618E-4,4.601E-4,3.9582E-4,3.1959E-4,3.9343E-4,4.4692E-4,4.5796E-4,3.9696E-4,3.1838E-4,3.9421E-4,4.464E-4,4.5938E-4,3.9605E-4,3.1887E-4,3.9404E-4,4.4734E-4,4.5844E-4,3.959E-4,3.1953E-4,3.9457E-4,4.4533E-4,4.5862E-4,3.9637E-4,3.1646E-4,3.9379E-4,4.4576E-4,4.5824E-4,3.9613E-4,3.1769E-4,3.9494E-4,4.4627E-4,4.5849E-4,3.9557E-4,3.1753E-4,3.9385E-4,4.4808E-4,4.5939E-4,3.9432E-4,3.1723E-4,3.9448E-4,4.4617E-4,4.5737E-4,3.9375E-4,3.1861E-4,3.9375E-4,4.4694E-4,4.6072E-4,3.9097E-4,3.1711E-4,3.9364E-4,4.4628E-4,4.5707E-4,3.9372E-4,3.1722E-4,3.9467E-4,4.4471E-4,4.579E-4,3.9303E-4,3.1706E-4,3.9336E-4,4.4493E-4,4.5572E-4,3.9297E-4,3.1725E-4,3.9401E-4,4.4645E-4,4.5593E-4,3.895E-4,3.172E-4,3.9492E-4,4.4652E-4,4.5633E-4,3.9313E-4,3.19E-4,3.9224E-4,4.4681E-4,4.5564E-4,3.9127E-4,3.1641E-4,3.9392E-4,4.4662E-4,4.5519E-4,3.9175E-4,3.1742E-4,3.9192E-4,4.4641E-4,4.541E-4,3.9265E-4,3.1765E-4,3.9319E-4,4.4454E-4,4.5514E-4,3.88E-4,3.1661E-4,3.9479E-4,4.4476E-4,4.5551E-4,3.9195E-4,3.1593E-4,3.9344E-4,4.4395E-4,4.5549E-4,3.8995E-4,3.169E-4,3.9305E-4,4.451E-4,4.5376E-4,3.8795E-4,3.173E-4,3.9196E-4,4.4185E-4,4.5234E-4,3.8586E-4,3.1403E-4,3.8994E-4,4.4187E-4,4.5104E-4,3.8736E-4,3.1445E-4,3.9088E-4,4.4414E-4,4.5151E-4,3.8575E-4,3.1614E-4,3.9032E-4,4.4147E-4,4.5187E-4,3.8463E-4,3.1418E-4,3.9273E-4,4.4199E-4,4.5378E-4,3.867E-4,3.1462E-4,3.9181E-4,4.4265E-4,4.4993E-4,3.8588E-4,3.1389E-4,3.9155E-4,4.4356E-4,4.5147E-4,3.8688E-4,3.1623E-4,3.9177E-4,4.4381E-4,4.5303E-4,3.8677E-4,3.1521E-4,3.9217E-4,4.4373E-4,4.5434E-4,3.8711E-4,3.1718E-4,3.9317E-4,4.433E-4,4.5111E-4,3.8499E-4,3.1468E-4,3.9207E-4,4.4369E-4,4.5025E-4,3.8475E-4,3.1539E-4,3.917E-4,4.4131E-4,4.5243E-4,3.8329E-4,3.1241E-4,3.905E-4,4.3924E-4,4.5023E-4,3.8202E-4,3.1328E-4,3.8991E-4,4.3818E-4,4.4899E-4,3.8141E-4,3.1292E-4,3.8966E-4,4.3947E-4,4.4956E-4,3.8389E-4,3.1452E-4,3.9203E-4,4.3891E-4,4.4845E-4,3.8197E-4,3.1328E-4,3.8994E-4,4.4062E-4,4.4864E-4,3.8362E-4,3.1336E-4,3.9E-4,4.4108E-4,4.477E-4,3.8161E-4,3.1218E-4,3.908E-4,4.3964E-4,4.4807E-4,3.8184E-4,3.1428E-4,3.9176E-4,4.3961E-4,4.4705E-4,3.8144E-4,3.1179E-4,3.904E-4,4.3935E-4,4.489E-4,3.8027E-4,3.1422E-4,3.8917E-4,4.3995E-4,4.4709E-4,3.8017E-4,3.1222E-4,3.8973E-4,4.3963E-4,4.4697E-4,2.0845E-4:2
4.3E-7,2.3533E-6,-1.4667E-7,1.8133E-6,9.7667E-7,9.8667E-7,1.7467E-6,3.1333E-7,2.49E-6,4.3E-7,1.6167E-6,2.2533E-6,-8.6667E-8,2.4367E-6,1.1567E-6,8.5E-7,1.63E-6,-7.0E-8,3.57E-6,1.55E-6,2.7333E-7,3.2457E-4,3.5819E-4,4.3316E-4,4.5336E-4,3.9562E-4,3.3444E-4,3.5433E-4,4.3923E-4,4.5571E-4,3.9575E-4,3.3733E-4,3.5082E-4,4.3799E-4,4.5589E-4,3.9269E-4,3.3908E-4,3.5266E-4,4.4081E-4,4.5805E-4,3.9391E-4,3.375E-4,3.5351E-4,4.3957E-4,4.5874E-4,3.9449E-4,3.3888E-4,3.5371E-4,4.3903E-4,4.5732E-4,3.9431E-4,3.3698E-4,3.518E-4,4.3923E-4,4.5719E-4,3.9099E-4,3.3658E-4,3.5325E-4,4.3797E-4,4.5673E-4,3.8907E-4,3.3549E-4,3.5277E-4,4.3856E-4,4.571E-4,3.9261E-4,3.3797E-4,3.5344E-4,4.374E-4,4.5765E-4,3.9069E-4,3.3809E-4,3.5198E-4,4.3966E-4,4.5711E-4,3.9037E-4,3.3808E-4,3.5556E-4,4.428E-4,4.599E-4,3.8976E-4,3.3937E-4,3.5638E-4,4.4046E-4,4.6196E-4,3.9225E-4,3.383E-4,3.5662E-4,4.4366E-4,4.6029E-4,3.9273E-4,3.404E-4,3.5501E-4,4.4057E-4,4.5767E-4,3.8344E-4,3.3727E-4,3.5482E-4,4.3942E-4,4.5597E-4,3.8673E-4,3.3645E-4,3.5486E-4,4.3891E-4,4.5797E-4,3.8755E-4,3.3751E-4,3.5517E-4,4.4012E-4,4.6113E-4,3.876E-4,3.3793E-4,3.5727E-4,4.4371E-4,4.6224E-4,3.9038E-4,3.3884E-4,3.5759E-4,4.4452E-4,4.6214E-4,3.879E-4,3.3858E-4,3.5711E-4,4.4305E-4,4.6184E-4,3.898E-4,3.3846E-4,3.5714E-4,4.4288E-4,4.6186E-4,3.8746E-4,3.3881E-4,3.5854E-4,4.4352E-4,4.6144E-4,3.8774E-4,3.3965E-4,3.602E-4,4.4447E-4,4.6092E-4,3.8622E-4,3.3912E-4,3.5829E-4,4.4321E-4,4.6076E-4,3.8751E-4,3.388E-4,3.588E-4,4.4566E-4,4.6215E-4,3.8472E-4,3.4038E-4,3.5942E-4,4.4322E-4,4.6313E-4,3.866E-4,3.392E-4,3.592E-4,4.4396E-4,4.6237E-4,3.8592E-4,3.3931E-4,3.5733E-4,4.4413E-4,4.628E-4,3.8585E-4,3.3709E-4,3.5995E-4,4.4439E-4,4.6181E-4,3.8629E-4,3.3862E-4,3.5721E-4,4.4254E-4,4.6095E-4,3.8205E-4,3.3854E-4,3.6023E-4,4.4143E-4,4.6103E-4,3.8547E-4,3.4034E-4,3.5911E-4,4.4348E-4,4.6358E-4,3.8395E-4,3.382E-4,3.6033E-4,4.4348E-4,4.6139E-4,3.8247E-4,3.392E-4,3.5844E-4,4.4455E-4,4.6249E-4,3.8316E-4,3.3849E-4,3.5971E-4,4.4328E-4,4.6203E-4,3.8345E-4,3.3869E-4,3.597E-4,4.4474E-4,4.5938E-4,3.8058E-4,3.3788E-4,3.6042E-4,4.4396E-4,4.6135E-4,3.8089E-4,3.3763E-4,3.5971E-4,4.4472E-4,4.5958E-4,3.7951E-4,3.3851E-4,3.6069E-4,4.4227E-4,4.6199E-4,3.7964E-4,3.3773E-4,3.6136E-4,4.4516E-4,4.6121E-4,3.8034E-4,3.3742E-4,3.615E-4,4.4345E-4,4.6032E-4,3.8098E-4,3.3693E-4,3.5901E-4,4.4042E-4,4.5915E-4,3.7697E-4,3.3569E-4,3.5819E-4,4.3915E-4,4.5763E-4,3.7676E-4,3.3571E-4,3.578E-4,4.3976E-4,4.569E-4,3.7686E-4,3.345E-4,3.5969E-4,4.4024E-4,4.5837E-4,3.7568E-4,3.3715E-4,3.5868E-4,4.4035E-4,4.5572E-4,3.7514E-4,3.3665E-4,3.5742E-4,4.4153E-4,4.5615E-4,3.7638E-4,3.3563E-4,3.5903E-4,4.4297E-4,4.5715E-4,3.7503E-4,3.3629E-4,3.5825E-4,4.4124E-4,4.5582E-4,3.7568E-4,3.3536E-4,3.581E-4,4.417E-4,4.5575E-4,3.7378E-4,3.3532E-4,3.5997E-4,4.4151E-4,4.5568E-4,3.7349E-4,3.3487E-4,3.5663E-4,4.4055E-4,4.5649E-4,3.728E-4,3.3551E-4,3.577E-4,4.4082E-4,4.5694E-4,3.7288E-4,3.3343E-4,3.6094E-4,4.3992E-4,4.5533E-4,3.7293E-4,3.3397E-4,3.5837E-4,4.3805E-4,4.5534E-4,3.7137E-4,3.3528E-4,3.5943E-4,4.3844E-4,4.5519E-4,3.7048E-4,3.323E-4,3.5785E-4,4.3831E-4,4.5509E-4,3.6976E-4,3.3388E-4,3.5824E-4,4.3848E-4,4.5566E-4,3.6991E-4,3.3296E-4,3.5822E-4,4.3738E-4,4.5333E-4,3.6974E-4,3.3227E-4,3.5901E-4,4.3939E-4,4.5311E-4,3.7054E-4,3.3349E-4,3.5735E-4,4.3807E-4,4.5601E-4,3.6791E-4,3.3338E-4,3.592E-4,4.4048E-4,4.5407E-4,3.7034E-4,3.3315E-4,3.5849E-4,4.3927E-4,4.5358E-4,3.6904E-4,3.3435E-4,3.5921E-4,4.4102E-4,4.5611E-4,3.7018E-4,3.3063E-4,3.5879E-4,4.3635E-4,4.5403E-4,3.6767E-4,3.3422E-4,3.6008E-4,4.3941E-4,4.5476E-4,3.6736E-4,3.3332E-4,3.5918E-4,4.3976E-4,4.525E-4,3.6644E-4,3.3359E-4,3.5956E-4,4.3846E-4,4.5338E-4,3.6789E-4,3.312E-4,3.575E-4,4.3849E-4,4.5003E-4,3.6778E-4,3.3229E-4,3.5917E-4,4.4023E-4,4.5227E-4,3.6681E-4,3.3243E-4,3.5931E-4,4.3765E-4,4.5208E-4,3.6595E-4,3.3169E-4,3.5834E-4,4.3835E-4,4.5312E-4,3.6616E-4,3.3041E-4,3.5909E-4,4.3619E-4,4.5193E-4,3.6466E-4,3.3132E-4,3.6063E-4,4.3752E-4,4.5305E-4,3.6462E-4,3.3157E-4,3.5957E-4,4.3828E-4,4.5289E-4,3.6393E-4,3.3008E-4,3.6138E-4,4.3774E-4,4.5115E-4,3.6391E-4,3.3158E-4,3.5942E-4,4.3742E-4,4.5207E-4,3.6503E-4,3.304E-4,3.6108E-4,4.3578E-4,4.5068E-4,3.6429E-4,3.3239E-4,3.5863E-4,4.3631E-4,4.5273E-4,3.6398E-4,3.3199E-4,3.5876E-4,4.3854E-4,4.5282E-4,3.6192E-4,3.2977E-4,3.5879E-4,4.3703E-4,4.5047E-4,3.6345E-4,3.3103E-4,3.5934E-4,4.3845E-4,4.5265E-4,3.6282E-4,3.3122E-4,3.5776E-4,4.3584E-4,4.5179E-4:2
2.0E-7,1.7133E-6,7.3E-7,2.19E-6,1.1833E-6,3.1667E-7,2.5767E-6,5.6E-7,2.7567E-6,1.83E-6,-1.3333E-7,2.2533E-6,6.3333E-7,2.0133E-6,1.33E-6,-4.1333E-7,1.6033E-6,-1.2333E-7,1.88E-6,6.6667E-7,4.1667E-7,3.3331E-4,4.05E-4,4.5146E-4,4.3539E-4,3.2763E-4,3.3934E-4,3.9806E-4,4.5305E-4,4.416E-4,3.2645E-4,3.4412E-4,3.9661E-4,4.5272E-4,4.4295E-4,3.2514E-4,3.4625E-4,3.9948E-4,4.5415E-4,4.4378E-4,3.2618E-4,3.4365E-4,3.9738E-4,4.5254E-4,4.3874E-4,3.2449E-4,3.4427E-4,3.9975E-4,4.5247E-4,4.4185E-4,3.2612E-4,3.4494E-4,3.9804E-4,4.5095E-4,4.4164E-4,3.26E-4,3.4498E-4,3.9777E-4,4.5397E-4,4.4169E-4,3.2477E-4,3.453E-4,3.9797E-4,4.5324E-4,4.4263E-4,3.2532E-4,3.4528E-4,3.9947E-4,4.5534E-4,4.4118E-4,3.2559E-4,3.47E-4,4.0149E-4,4.5476E-4,4.4318E-4,3.2395E-4,3.4646E-4,3.9909E-4,4.5406E-4,4.4667E-4,3.2579E-4,3.4828E-4,4.0122E-4,4.5432E-4,4.414E-4,3.2474E-4,3.4928E-4,3.9947E-4,4.5361E-4,4.428E-4,3.2312E-4,3.4678E-4,4.0056E-4,4.5416E-4,4.4265E-4,3.2367E-4,3.4663E-4,4.0161E-4,4.5623E-4,4.4294E-4,3.2538E-4,3.4728E-4,4.0088E-4,4.5469E-4,4.456E-4,3.272E-4,3.4926E-4,4.0174E-4,4.533E-4,4.4187E-4,3.2318E-4,3.4608E-4,3.9841E-4,4.5349E-4,4.4109E-4,3.2463E-4,3.4496E-4,3.9982E-4,4.531E-4,4.3792E-4,3.2203E-4,3.4709E-4,4.0111E-4,4.5334E-4,4.4092E-4,3.2433E-4,3.4762E-4,4.0197E-4,4.5213E-4,4.4017E-4,3.2261E-4,3.4817E-4,4.0058E-4,4.5342E-4,4.402E-4,3.2218E-4,3.4772E-4,4.0041E-4,4.5369E-4,4.4032E-4,3.2336E-4,3.4776E-4,4.0135E-4,4.5181E-4,4.4178E-4,3.2416E-4,3.4702E-4,4.0215E-4,4.5119E-4,4.3925E-4,3.2207E-4,3.474E-4,4.02E-4,4.5287E-4,4.4058E-4,3.2248E-4,3.4821E-4,4.0072E-4,4.5308E-4,4.4102E-4,3.2192E-4,3.482E-4,4.0104E-4,4.538E-4,4.414E-4,3.221E-4,3.461E-4,4.0258E-4,4.5411E-4,4.4045E-4,3.2164E-4,3.4553E-4,3.9992E-4,4.5079E-4,4.3918E-4,3.2078E-4,3.4557E-4,4.0E-4,4.5182E-4,4.4045E-4,3.2117E-4,3.472E-4,4.0307E-4,4.54E-4,4.3933E-4,3.2129E-4,3.4552E-4,4.0025E-4,4.5174E-4,4.3826E-4,3.2094E-4,3.4665E-4,4.0008E-4,4.5292E-4,4.3951E-4,3.212E-4,3.4477E-4,4.0018E-4,4.5242E-4,4.3939E-4,3.2017E-4,3.4757E-4,4.005E-4,4.5226E-4,4.37E-4,3.2051E-4,3.473E-4,4.0159E-4,4.522E-4,4.3748E-4,3.2151E-4,3.4591E-4,4.0241E-4,4.5182E-4,4.3961E-4,3.2088E-4,3.4603E-4,4.0114E-4,4.4873E-4,4.3778E-4,3.1883E-4,3.4717E-4,4.0286E-4,4.4996E-4,4.3689E-4,3.1866E-4,3.4587E-4,4.0299E-4,4.5095E-4,4.3666E-4,3.2003E-4,3.4541E-4,4.0169E-4,4.5079E-4,4.377E-4,3.1972E-4,3.4645E-4,4.024E-4,4.5103E-4,4.352E-4,3.1873E-4,3.4515E-4,4.025E-4,4.502E-4,4.359E-4,3.1973E-4,3.4616E-4,4.0229E-4,4.5084E-4,4.3499E-4,3.1946E-4,3.4615E-4,3.9988E-4,4.5199E-4,4.3548E-4,3.1808E-4,3.4394E-4,4.0313E-4,4.4856E-4,4.3674E-4,3.1955E-4,3.4618E-4,4.0139E-4,4.4875E-4,4.3581E-4,3.1673E-4,3.4601E-4,4.007E-4,4.5074E-4,4.3507E-4,3.1761E-4,3.4808E-4,4.0184E-4,4.5098E-4,4.3314E-4,3.1809E-4,3.4756E-4,4.0118E-4,4.4837E-4,4.3362E-4,3.1633E-4,3.4588E-4,4.0223E-4,4.49E-4,4.3504E-4,3.164E-4,3.464E-4,4.0275E-4,4.4945E-4,4.3403E-4,3.1779E-4,3.467E-4,4.0202E-4,4.4908E-4,4.3305E-4,3.1639E-4,3.4825E-4,4.0044E-4,4.4682E-4,4.336E-4,3.15E-4,3.4569E-4,4.0062E-4,4.5046E-4,4.337E-4,3.166E-4,3.4666E-4,4.0394E-4,4.4845E-4,4.3317E-4,3.1565E-4,3.4701E-4,4.0153E-4,4.4831E-4,4.3261E-4,3.1503E-4,3.4695E-4,4.0199E-4,4.5084E-4,4.3231E-4,3.1501E-4,3.4624E-4,4.0248E-4,4.4777E-4,4.3359E-4,3.153E-4,3.4715E-4,4.0343E-4,4.479E-4,4.3149E-4,3.148E-4,3.4526E-4,4.0193E-4,4.4724E-4,4.2945E-4,3.1492E-4,3.4676E-4,4.026E-4,4.4841E-4,4.3092E-4,3.1353E-4,3.4788E-4,4.0226E-4,4.4723E-4,4.3013E-4,3.129E-4,3.4735E-4,4.022E-4,4.4788E-4,4.2888E-4,3.1375E-4,3.457E-4,4.0149E-4,4.4758E-4,4.2703E-4,3.1312E-4,3.4719E-4,4.016E-4,4.4776E-4,4.2923E-4,3.1494E-4,3.4697E-4,4.0213E-4,4.4862E-4,4.2859E-4,3.1322E-4,3.4705E-4,4.0245E-4,4.4726E-4,4.3E-4,3.1289E-4,3.4439E-4,4.0233E-4,4.4633E-4,4.267E-4,3.1412E-4,3.4572E-4,4.0147E-4,4.4681E-4,4.2754E-4,3.1298E-4,3.451E-4,4.0271E-4,4.4659E-4,4.2775E-4,3.1232E-4,3.4582E-4,4.0232E-4,4.4946E-4,4.2913E-4,3.1261E-4,3.4678E-4,4.0293E-4,4.4787E-4,4.2631E-4,3.1126E-4,3.4766E-4,4.0185E-4,4.4868E-4,4.2728E-4,3.1184E-4,3.4556E-4,4.0229E-4,4.4526E-4,4.2643E-4,3.1137E-4,3.4759E-4,4.0077E-4,4.4556E-4,4.2746E-4,3.1096E-4,3.4683E-4,4.0184E-4,4.4486E-4,4.2693E-4,3.117E-4,3.4672E-4,4.035E-4,4.463E-4,4.2731E-4,3.1162E-4,3.455E-4,4.0139E-4,4.4776E-4,4.2499E-4,3.1117E-4,3.331E-4:2
-1.9367E-5,-2.7637E-5,-3.349E-5,-2.999E-5,-1.9633E-5,-1.9863E-5,-2.7023E-5,-3.1717E-5,-2.955E-5,-2.0377E-5,-1.9383E-5,-2.7717E-5,-3.21E-5,-2.946E-5,-1.9323E-5,-1.818E-5,-2.7013E-5,-3.116E-5,-3.01E-5,-1.947E-5,-1.7183E-5,-2.7127E-5,-3.11E-5,-3.0517E-5,-1.9777E-5,-1.9203E-5,-2.744E-5,-3.0573E-5,-3.0317E-5,1.3427E-5,0.0012079,0.0013314,0.0012489,0.0010184,9.7568E-4,0.0011512,0.0013256,0.0012367,0.0010376,9.6072E-4,0.0011653,0.0013213,0.0012335,0.0010432,9.5566E-4,0.0011626,0.0013207,0.0012341,0.0010462,9.5222E-4,0.0011617,0.0013181,0.0012361,0.0010486,9.477E-4,0.0011614,0.0013174,0.001243,0.0010505,9.4888E-4,0.0011582,0.0013187,0.00124,0.0010496,9.4597E-4,0.0011564,0.0013189,0.0012408,0.001048,9.497E-4,0.0011523,0.0013163,0.0012422,0.0010531,9.508E-4,0.0011512,0.0013137,0.0012463,0.0010543,9.5016E-4,0.0011492,0.001312,0.0012439,0.0010518,9.4672E-4,0.0011443,0.0013107,0.0012441,0.0010568,9.4575E-4,0.0011414,0.0013138,0.0012476,0.0010557,9.4254E-4,0.00114,0.0013091,0.0012473,0.0010572,9.404E-4,0.0011365,0.001309,0.0012468,0.0010582,9.4106E-4,0.0011363,0.0013063,0.0012477,0.0010591,9.3827E-4,0.0011325,0.0013033,0.0012485,0.0010632,9.3521E-4,0.0011297,0.0012987,0.0012496,0.0010613,9.3439E-4,0.0011264,0.0013004,0.0012472,0.0010614,9.3627E-4,0.0011251,0.0012989,0.0012509,0.0010631,9.3392E-4,0.0011208,0.0012956,0.0012486,0.0010634,9.3084E-4,0.0011168,0.0012929,0.0012491,0.0010624,9.2788E-4,0.0011151,0.0012909,0.0012491,0.0010638,9.3263E-4,0.0011121,0.0012856,0.0012504,0.0010656,9.2979E-4,0.0011085,0.001286,0.0012472,0.0010651,9.2604E-4,0.0011091,0.0012814,0.0012484,0.0010679,9.2381E-4,0.0011031,0.0012804,0.0012504,0.0010677,9.2353E-4,0.0011027,0.0012809,0.0012514,0.0010682,9.2125E-4,0.0010956,0.0012745,0.0012446,0.0010694,9.2091E-4,0.0010946,0.001275,0.0012471,0.0010672,9.164E-4,0.0010935,0.0012726,0.001246,0.0010681,9.1824E-4,0.0010903,0.0012702,0.0012471,0.0010711,9.1583E-4,0.0010861,0.0012665,0.0012486,0.0010718,9.1512E-4,0.0010834,0.0012658,0.0012457,0.0010713,9.0862E-4,0.0010817,0.0012576,0.0012503,0.0010716,9.1123E-4,0.0010795,0.0012602,0.0012468,0.0010751,9.0749E-4,0.0010756,0.0012572,0.0012476,0.0010746,9.0672E-4,0.0010735,0.001253,0.0012523,0.001076,9.0786E-4,0.0010709,0.0012541,0.0012456,0.0010763,9.0595E-4,0.0010711,0.0012504,0.0012511,0.0010786,9.0322E-4,0.0010639,0.0012494,0.0012478,0.0010766,9.055E-4,0.0010611,0.0012403,0.0012469,0.0010799,9.0052E-4,0.001059,0.0012427,0.0012468,0.0010791,9.0034E-4,0.0010548,0.0012362,0.0012458,0.0010799,8.9823E-4,0.0010569,0.0012355,0.001246,0.00108,8.9763E-4,0.0010512,0.001232,0.0012487,0.0010802,8.9837E-4,0.0010502,0.0012302,0.0012436,0.0010798,8.9583E-4,0.0010456,0.0012254,0.0012442,0.0010827,8.9634E-4,0.0010419,0.0012237,0.0012455,0.0010859,8.9923E-4,0.0010453,0.0012248,0.0012461,0.0010855,8.9423E-4,0.0010426,0.0012255,0.0012451,0.001088,8.9426E-4,0.0010394,0.0012189,0.0012469,0.0010874,8.9098E-4,0.0010349,0.0012154,0.0012482,0.0010894,8.9414E-4,0.0010347,0.0012121,0.0012462,0.001091,8.9462E-4,0.0010337,0.00121,0.0012492,0.0010917,8.9068E-4,0.0010285,0.0012078,0.0012427,0.0010944,8.9052E-4,0.0010282,0.0012083,0.0012491,0.0010931,8.8996E-4,0.0010254,0.0012021,0.0012473,0.0010969,8.9217E-4,0.0010183,0.0012055,0.0012436,0.001096,8.8867E-4,0.0010207,0.0011988,0.0012467,0.0010966,8.8916E-4,0.0010158,0.001195,0.0012489,0.0010966,8.8747E-4,0.0010173,0.0011927,0.0012454,0.0010994,8.8755E-4,0.0010154,0.0011894,0.0012461,0.0011022,8.8853E-4,0.001014,0.0011855,0.0012473,0.0011063,8.8838E-4,0.0010102,0.0011824,0.0012449,0.0011053,8.9088E-4,0.001008,0.0011817,0.0012482,0.0011074,8.885E-4,0.0010059,0.0011799,0.0012479,0.0011096,8.8754E-4,0.0010068,0.0011768,0.0012502,0.001111,8.8848E-4,0.001004,0.0011744,0.0012462,0.0011126,8.8884E-4,0.0010015,0.0011704,0.0012502,0.0011158,8.8868E-4,9.9891E-4,0.0011702,0.0012463,0.0011178,8.9032E-4,9.9776E-4,0.0011673,0.0012491,0.0011187,8.8983E-4,9.9675E-4,0.0011658,0.0012506,0.0011212,8.8947E-4,9.9552E-4,0.0011586,0.0012505,0.0011217,8.9019E-4,9.973E-4,0.0011575,0.0012491,0.0011247,8.9082E-4,9.9198E-4,0.0011558,0.0012461,0.0011229,8.9252E-4,9.9133E-4,0.0011518,0.0012461,0.0011248,8.9003E-4,9.8573E-4,0.0011527,0.0012473,0.0011249,8.9052E-4,9.8366E-4,0.001147,0.0012484,0.0011278,8.9077E-4,9.811E-4,8.1452E-4:2
-1.4547E-5,-2.5023E-5,-2.985E-5,-3.105E-5,-2.9123E-5,-1.5097E-5,-2.456E-5,-2.8137E-5,-3.2007E-5,-2.9897E-5,-1.528E-5,-2.5017E-5,-2.7353E-5,-3.1317E-5,-3.0053E-5,-1.4677E-5,-2.483E-5,-2.8023E-5,-3.151E-5,-2.9287E-5,-1.464E-5,-2.543E-5,-2.9413E-5,-3.1867E-5,-2.8767E-5,-1.499E-5,-2.3977E-5,-2.853E-5,-3.1473E-5,-2.9323E-5,-1.5547E-5,-2.3943E-5,0.001165,0.0011369,9.8239E-4,0.0010063,0.0012347,0.0013147,0.0011408,9.8852E-4,9.988E-4,0.0012377,0.0013186,0.001146,9.9407E-4,9.9758E-4,0.001237,0.001319,0.0011454,9.9665E-4,9.9307E-4,0.0012341,0.0013218,0.0011512,9.9389E-4,9.9261E-4,0.0012313,0.0013193,0.0011549,9.9657E-4,9.8924E-4,0.0012257,0.0013203,0.0011574,9.9533E-4,9.8504E-4,0.0012233,0.0013241,0.0011595,9.9886E-4,9.8466E-4,0.0012201,0.0013198,0.001165,9.9865E-4,9.8104E-4,0.0012207,0.0013191,0.0011699,0.0010035,9.7813E-4,0.0012127,0.0013184,0.0011701,0.0010009,9.781E-4,0.0012068,0.0013173,0.0011691,0.0010005,9.7363E-4,0.0012043,0.0013178,0.0011769,0.0010042,9.7276E-4,0.001201,0.0013163,0.0011781,0.0010072,9.71E-4,0.0011986,0.0013182,0.0011818,0.0010092,9.6519E-4,0.0011926,0.0013121,0.0011799,0.0010068,9.6307E-4,0.0011921,0.0013096,0.0011816,0.001007,9.6075E-4,0.001187,0.0013137,0.0011872,0.0010116,9.588E-4,0.0011797,0.001309,0.0011884,0.001013,9.5294E-4,0.0011773,0.0013106,0.0011924,0.0010112,9.5365E-4,0.0011721,0.0013067,0.0011938,0.0010142,9.4953E-4,0.0011675,0.0013067,0.0011945,0.0010162,9.4896E-4,0.001164,0.0013065,0.0011949,0.0010178,9.419E-4,0.0011598,0.001303,0.0011975,0.001018,9.4369E-4,0.0011574,0.0013014,0.0012001,0.0010197,9.3796E-4,0.001151,0.0012995,0.0011979,0.0010203,9.4041E-4,0.0011479,0.0012932,0.0012045,0.0010213,9.3541E-4,0.0011461,0.0012981,0.0012082,0.0010235,9.3239E-4,0.0011406,0.0012904,0.0012104,0.0010235,9.2961E-4,0.0011361,0.0012936,0.00121,0.0010248,9.2788E-4,0.0011296,0.0012905,0.0012119,0.0010284,9.2756E-4,0.0011258,0.0012916,0.0012106,0.0010299,9.2563E-4,0.0011199,0.001287,0.0012144,0.0010331,9.2456E-4,0.0011196,0.0012858,0.0012143,0.001032,9.2387E-4,0.0011132,0.001281,0.0012113,0.0010377,9.2045E-4,0.0011093,0.001278,0.0012205,0.001034,9.2013E-4,0.0011068,0.001278,0.0012158,0.0010381,9.158E-4,0.0011055,0.0012715,0.0012193,0.0010402,9.1274E-4,0.0010975,0.0012676,0.0012227,0.0010431,9.0804E-4,0.0010934,0.0012658,0.0012223,0.00104,9.0819E-4,0.0010899,0.0012628,0.0012203,0.0010464,9.0607E-4,0.0010856,0.0012618,0.0012227,0.0010473,9.0288E-4,0.0010812,0.0012568,0.0012247,0.0010495,9.0268E-4,0.0010795,0.0012575,0.0012204,0.0010523,9.0353E-4,0.001073,0.0012533,0.0012244,0.0010561,8.9941E-4,0.00107,0.0012508,0.001225,0.0010585,8.9876E-4,0.0010662,0.0012439,0.0012269,0.0010596,8.9931E-4,0.0010611,0.0012443,0.0012286,0.0010599,8.9642E-4,0.0010585,0.0012368,0.0012265,0.0010629,8.9737E-4,0.001054,0.001233,0.0012297,0.0010627,8.9477E-4,0.0010518,0.0012317,0.0012321,0.0010633,8.9418E-4,0.0010476,0.0012307,0.0012285,0.0010708,8.9166E-4,0.0010454,0.0012238,0.0012336,0.0010699,8.8867E-4,0.0010421,0.0012224,0.0012322,0.0010729,8.872E-4,0.0010358,0.0012153,0.0012331,0.0010746,8.9194E-4,0.0010323,0.0012175,0.0012346,0.0010763,8.878E-4,0.001029,0.0012129,0.0012321,0.0010819,8.8729E-4,0.0010275,0.0012075,0.0012347,0.0010832,8.8649E-4,0.0010263,0.0012067,0.0012368,0.0010903,8.8453E-4,0.0010206,0.0011987,0.0012356,0.0010887,8.8699E-4,0.0010177,0.0011989,0.0012382,0.0010905,8.8499E-4,0.0010178,0.0011936,0.0012391,0.0010966,8.8721E-4,0.0010126,0.0011919,0.0012431,0.0010982,8.8709E-4,0.0010108,0.0011891,0.0012421,0.0011007,8.8421E-4,0.0010067,0.0011865,0.0012425,0.0011028,8.864E-4,0.0010056,0.0011813,0.0012409,0.0011073,8.8806E-4,0.0010021,0.0011761,0.0012415,0.0011108,8.8763E-4,9.1813E-4:2
2.52E-6,6.5667E-7,-5.0E-7,1.0E-6,-2.3667E-6,2.3867E-6,2.0867E-6,4.3E-7,2.69E-6,-1.1067E-6,1.6767E-6,-1.7667E-7,-2.4667E-7,1.2833E-6,-1.5733E-6,1.7E-6,9.8333E-7,-1.1833E-6,1.1667E-6,-2.37E-6,2.3433E-6,-2.9E-7,9.3333E-7,1.41E-6,-1.6067E-6,1.39E-6,-9.3E-7,1.2933E-6,1.4967E-6,-2.01E-6,1.35E-6,-7.6E-7,7.2667E-7,5.9E-7,-2.1867E-6,1.5533E-6,-2.3667E-7,4.0E-7,1.2467E-6,-8.4667E-7,2.4967E-6,-5.0E-7,-1.82E-6,1.05E-6,-6.3E-7,2.3767E-6,2.9667E-7,-6.9333E-7,2.0567E-6,-1.32E-6,1.7433E-6,-6.9667E-7,9.7333E-7,1.1967E-6,-8.7E-7,1.66E-6,1.2366E-4,0.0016053,6.7108E-4,8.1359E-4,3.2789E-4,6.9513E-4,6.9325E-4,7.0561E-4,6.7825E-4,4.0827E-4,6.3604E-4,6.8383E-4,7.412E-4,6.3582E-4,4.4483E-4,6.1934E-4,6.8639E-4,7.5507E-4,6.2441E-4,4.5544E-4,6.0813E-4,6.8493E-4,7.5909E-4,6.1886E-4,4.6261E-4,6.0378E-4,6.7841E-4,7.6042E-4,6.2301E-4,4.6355E-4,6.0367E-4,6.8E-4,7.6198E-4,6.2379E-4,4.6647E-4,6.0251E-4,6.8113E-4,7.6207E-4,6.2469E-4,4.6606E-4,5.9756E-4,6.7882E-4,7.6162E-4,6.2842E-4,4.6678E-4,5.9444E-4,6.7482E-4,7.6349E-4,6.2752E-4,4.6557E-4,5.9383E-4,6.7097E-4,7.5827E-4,6.321E-4,4.6571E-4,5.875E-4,6.7137E-4,7.6009E-4,6.3321E-4,4.6587E-4,5.8757E-4,6.6786E-4,7.5418E-4,6.3426E-4,4.6588E-4,5.8224E-4,6.6468E-4,7.5618E-4,6.366E-4,4.6682E-4,5.8032E-4,6.6261E-4,7.5668E-4,6.3756E-4,4.6747E-4,5.7663E-4,6.5843E-4,7.552E-4,6.3646E-4,4.6753E-4,5.7477E-4,6.5896E-4,7.5324E-4,6.4124E-4,4.6826E-4,5.7141E-4,6.5652E-4,7.5337E-4,6.4071E-4,4.6876E-4,5.6805E-4,6.5462E-4,7.5111E-4,6.4097E-4,4.6983E-4,5.6464E-4,6.4992E-4,7.5054E-4,6.446E-4,4.6683E-4,5.6224E-4,6.4842E-4,7.503E-4,6.4588E-4,4.6886E-4,5.575E-4,6.4486E-4,7.4774E-4,6.4515E-4,4.6942E-4,5.5708E-4,6.4415E-4,7.4471E-4,6.4669E-4,4.6854E-4,5.5486E-4,6.4153E-4,7.4437E-4,6.485E-4,4.6938E-4,5.5245E-4,6.4256E-4,7.4409E-4,6.5388E-4,4.6984E-4,5.4929E-4,6.3752E-4,7.4428E-4,6.5269E-4,4.6861E-4,5.4633E-4,6.3334E-4,7.4173E-4,6.5646E-4,4.721E-4,5.4577E-4,6.2936E-4,7.4015E-4,6.5703E-4,4.708E-4,5.3913E-4,6.3316E-4,7.3895E-4,6.6197E-4,4.7526E-4,5.3847E-4,6.297E-4,7.3662E-4,6.6122E-4,4.7772E-4,5.3754E-4,6.2832E-4,7.3787E-4,6.6157E-4,4.7686E-4,5.3424E-4,6.2263E-4,7.3451E-4,6.63E-4,4.7413E-4,5.2936E-4,6.2254E-4,7.3537E-4,6.6543E-4,4.7763E-4,5.2767E-4,6.2053E-4,7.3507E-4,6.6685E-4,4.7922E-4,5.3089E-4,6.171E-4,7.3225E-4,6.6868E-4,4.828E-4,5.2369E-4,6.1655E-4,7.3182E-4,6.695E-4,4.8621E-4,5.2224E-4,6.1584E-4,7.2779E-4,6.7074E-4,4.8505E-4,5.248E-4,6.1235E-4,7.2869E-4,6.7363E-4,4.8664E-4,5.201E-4,6.1135E-4,7.2726E-4,6.7345E-4,4.9047E-4,5.1628E-4,6.0635E-4,7.2664E-4,6.7449E-4,4.9052E-4,5.1576E-4,6.0791E-4,7.2523E-4,6.7862E-4,4.9325E-4,5.1434E-4,6.047E-4,7.2556E-4,6.7779E-4,4.9385E-4,5.146E-4,6.0137E-4,7.2399E-4,6.8087E-4,4.9642E-4,5.0957E-4,6.0036E-4,7.2308E-4,6.8133E-4,4.9714E-4,5.1135E-4,5.9986E-4,7.2417E-4,6.8671E-4,4.9983E-4,5.0945E-4,5.9951E-4,7.2093E-4,6.8906E-4,4.9956E-4,5.0752E-4,5.9782E-4,7.22E-4,6.886E-4,5.038E-4,5.0651E-4,5.9757E-4,7.1977E-4,6.9247E-4,5.0542E-4,5.0426E-4,5.9483E-4,7.1849E-4,6.9372E-4,5.0812E-4,5.0404E-4,5.8966E-4,7.1615E-4,6.9374E-4,5.0995E-4,4.9965E-4,5.8715E-4,7.166E-4,6.9287E-4,5.1099E-4,5.0123E-4,5.8784E-4,7.163E-4,6.9576E-4,5.1371E-4,4.9954E-4,5.8587E-4,7.1439E-4,6.9704E-4,5.201E-4,4.991E-4,5.8524E-4,7.1257E-4,6.9726E-4,5.1856E-4,4.8592E-4:2
-1.68E-6,1.5E-6,-7.8333E-7,3.0767E-6,1.2E-7,-1.04E-6,1.67E-6,-1.2533E-6,1.92E-6,8.2333E-7,-1.2333E-7,2.6667E-6,-1.5467E-6,2.8333E-6,8.6667E-8,-6.4333E-7,1.0367E-6,-9.5333E-7,1.7767E-6,9.3667E-7,-6.1333E-7,8.3667E-7,-2.3667E-7,1.3867E-6,9.7333E-7,-6.9E-7,2.2867E-6,-1.67E-6,1.5433E-6,1.3967E-6,-4.8667E-7,1.08E-6,-7.0E-8,1.1733E-6,4.3667E-7,-1.24E-6,7.9667E-7,-4.6E-7,2.64E-6,4.6333E-7,-6.2667E-7,1.4367E-6,-1.45E-6,2.0533E-6,9.0667E-7,-1.6933E-6,2.06E-6,-1.2567E-6,2.9367E-6,4.1E-7,-3.7E-7,2.5867E-6,-2.3167E-6,1.6367E-6,1.0333E-6,-1.3067E-6,1.3967E-6,-1.2067E-6,3.1267E-6,5.0667E-7,-1.0667E-6,1.0333E-6,-2.82E-6,1.7467E-6,-8.0E-8,-7.9E-7,1.1533E-6,-1.0067E-6,1.88E-6,4.3667E-7,-2.4333E-7,1.8467E-6,-1.2E-6,3.08E-6,1.4E-6,-9.5333E-7,1.7833E-6,-1.92E-6,1.2933E-6,-1.3467E-6,9.3E-7,1.408E-5,8.0011E-4,5.0915E-4,6.5171E-4,6.8772E-4,7.7881E-4,4.7003E-4,5.2476E-4,6.3275E-4,7.059E-4,7.3423E-4,5.1773E-4,4.9786E-4,6.4814E-4,7.1729E-4,7.2074E-4,5.3476E-4,4.8473E-4,6.5557E-4,7.1945E-4,7.1415E-4,5.4376E-4,4.8243E-4,6.5595E-4,7.1792E-4,7.1382E-4,5.4689E-4,4.8111E-4,6.5385E-4,7.2044E-4,7.1506E-4,5.4391E-4,4.8E-4,6.5201E-4,7.1767E-4,7.1408E-4,5.4917E-4,4.7977E-4,6.5058E-4,7.1668E-4,7.1641E-4,5.5221E-4,4.7801E-4,6.4902E-4,7.1527E-4,7.1991E-4,5.4964E-4,4.766E-4,6.4713E-4,7.1221E-4,7.1972E-4,5.5019E-4,4.752E-4,6.421E-4,7.1084E-4,7.206E-4,5.5088E-4,4.7442E-4,6.4209E-4,7.0957E-4,7.2312E-4,5.5099E-4,4.745E-4,6.4027E-4,7.0613E-4,7.199E-4,5.5225E-4,4.6867E-4,6.3623E-4,7.0424E-4,7.1869E-4,5.5373E-4,4.7173E-4,6.3182E-4,7.0182E-4,7.1887E-4,5.5542E-4,4.7E-4,6.2937E-4,7.0014E-4,7.1512E-4,5.5516E-4,4.6631E-4,6.2828E-4,6.9643E-4,7.1844E-4,5.5302E-4,4.6477E-4,6.2579E-4,6.9659E-4,7.1403E-4,5.5812E-4,4.6407E-4,6.2511E-4,6.9291E-4,7.1548E-4,5.544E-4,4.621E-4,6.2538E-4,6.8883E-4,7.1658E-4,5.5759E-4,4.6195E-4,6.1798E-4,6.8719E-4,7.1685E-4,5.5841E-4,4.6113E-4,6.1699E-4,6.8498E-4,7.1715E-4,5.5806E-4,4.5757E-4,6.141E-4,6.8493E-4,7.1525E-4,5.6086E-4,4.585E-4,6.1529E-4,6.8415E-4,7.1562E-4,5.5875E-4,4.5674E-4,6.1115E-4,6.8084E-4,7.171E-4,5.6105E-4,4.5466E-4,6.1114E-4,6.7836E-4,7.1482E-4,5.6335E-4,4.5275E-4,6.0826E-4,6.7892E-4,7.168E-4,5.6206E-4,4.5238E-4,6.0941E-4,6.7553E-4,7.1681E-4,5.6683E-4,4.5384E-4,6.0425E-4,6.7463E-4,7.1898E-4,5.6568E-4,4.5663E-4,6.0168E-4,6.7261E-4,7.1746E-4,5.6868E-4,4.5352E-4,5.9933E-4,6.7197E-4,7.2132E-4,5.657E-4,4.5476E-4,5.9967E-4,6.7178E-4,7.1767E-4,5.7073E-4,4.5372E-4,5.95E-4,6.6883E-4,7.1957E-4,5.7115E-4,4.5333E-4,5.9742E-4,6.6952E-4,7.2008E-4,5.7316E-4,4.5251E-4,5.9408E-4,6.6754E-4,7.2255E-4,5.7456E-4,4.5104E-4,5.9284E-4,6.6615E-4,7.1853E-4,5.731E-4,4.5206E-4,5.9462E-4,6.6409E-4,7.215E-4,5.7724E-4,4.4948E-4,5.8759E-4,6.611E-4,7.1961E-4,5.7991E-4,4.4839E-4,5.8776E-4,6.6037E-4,7.2267E-4,5.7934E-4,4.4869E-4,5.8546E-4,6.5773E-4,7.2177E-4,5.8074E-4,4.5256E-4,5.8481E-4,6.5616E-4,7.2112E-4,5.814E-4,4.5006E-4,5.8399E-4,6.5454E-4,7.2474E-4,5.8335E-4,4.5031E-4,5.8183E-4,6.5642E-4,7.2285E-4,5.86E-4,4.4923E-4,5.799E-4,6.5576E-4,7.2373E-4,5.8642E-4,4.4963E-4,5.7772E-4,6.5188E-4,7.2371E-4,5.8878E-4,4.4863E-4,5.774E-4,6.5409E-4,7.2443E-4,5.8686E-4,4.4754E-4,5.745E-4,6.4995E-4,7.2514E-4,5.891E-4,4.4917E-4,5.744E-4,6.471E-4,7.2321E-4,5.8932E-4,4.4707E-4,5.716E-4,6.4697E-4,7.2448E-4,5.9253E-4,4.4813E-4,5.7073E-4,6.4827E-4,7.2233E-4,5.9494E-4,4.4785E-4,5.7054E-4,6.4625E-4,7.2538E-4,5.9343E-4,4.4937E-4,5.7071E-4,6.4417E-4,7.2356E-4,5.9778E-4,4.4889E-4,5.6478E-4,6.4356E-4,7.2238E-4,5.9518E-4,4.4862E-4,5.6561E-4,6.409E-4,7.2149E-4,5.9822E-4,4.48E-4,5.6205E-4,6.4292E-4,7.2498E-4,6.0181E-4,4.4747E-4,5.6213E-4,6.4225E-4,7.243E-4,6.0065E-4,4.4759E-4,5.6234E-4,6.3621E-4,7.2482E-4,6.0305E-4,4.4941E-4,5.6227E-4,6.4031E-4,7.2422E-4,6.0508E-4,4.4947E-4,5.5727E-4,6.3709E-4,7.2382E-4,6.0644E-4,4.4855E-4,5.5973E-4,6.3723E-4,7.2581E-4,6.0738E-4,4.4778E-4,5.5661E-4,6.3709E-4,7.2808E-4,6.0629E-4,4.4852E-4,5.5409E-4,6.3542E-4,7.2311E-4,6.0694E-4,4.5006E-4,5.5683E-4,6.3382E-4,7.2375E-4,6.0945E-4,4.4824E-4,5.5581E-4,6.3428E-4,7.2407E-4,6.1143E-4,4.5143E-4,5.5452E-4,6.3307E-4,3.5888E-4:2
1.3067E-6,1.6733E-6,-1.4333E-7,1.4333E-6,-1.9367E-6,9.8667E-7,6.0E-7,-1.39E-6,1.6567E-6,-1.8433E-6,1.7267E-6,4.7667E-7,1.4533E-6,1.56E-6,-2.2067E-6,1.85E-6,-3.2E-7,1.4767E-6,1.56E-6,3.3E-7,2.7333E-6,9.6667E-7,8.8333E-7,1.4767E-6,-1.3567E-6,1.5867E-6,9.0333E-7,-5.4333E-7,1.6E-6,-1.0333E-7,1.4E-6,9.4333E-7,6.6333E-7,2.1033E-6,-1.61E-6,2.2733E-6,-1.2733E-6,8.0667E-7,6.7E-7,-7.4E-7,1.29E-6,3.4E-7,2.2667E-7,1.4533E-6,-2.4867E-6,2.37E-6,-6.8333E-7,2.6333E-7,0.0011904,8.066E-4,3.1758E-4,7.5219E-4,7.5258E-4,6.4425E-4,6.7103E-4,3.8487E-4,6.7699E-4,7.1184E-4,7.0326E-4,6.0097E-4,4.4359E-4,6.562E-4,7.1005E-4,7.2422E-4,5.7777E-4,4.6287E-4,6.4895E-4,7.1179E-4,7.3133E-4,5.7307E-4,4.6804E-4,6.4365E-4,7.0871E-4,7.3569E-4,5.7117E-4,4.6937E-4,6.4244E-4,7.0962E-4,7.3356E-4,5.7086E-4,4.7184E-4,6.4428E-4,7.08E-4,7.3408E-4,5.6971E-4,4.6921E-4,6.4143E-4,7.0984E-4,7.3396E-4,5.7139E-4,4.7054E-4,6.4217E-4,7.0685E-4,7.3587E-4,5.6918E-4,4.704E-4,6.4011E-4,7.066E-4,7.3334E-4,5.6877E-4,4.7036E-4,6.4109E-4,7.0524E-4,7.3184E-4,5.6696E-4,4.6963E-4,6.3806E-4,7.0435E-4,7.2983E-4,5.6361E-4,4.6957E-4,6.3756E-4,7.0307E-4,7.3068E-4,5.6717E-4,4.662E-4,6.3227E-4,6.9979E-4,7.2467E-4,5.634E-4,4.6569E-4,6.3207E-4,6.9929E-4,7.2743E-4,5.642E-4,4.6412E-4,6.3237E-4,6.9549E-4,7.2449E-4,5.639E-4,4.6706E-4,6.279E-4,6.957E-4,7.2258E-4,5.6046E-4,4.6215E-4,6.2708E-4,6.9171E-4,7.189E-4,5.6035E-4,4.6405E-4,6.2608E-4,6.915E-4,7.1903E-4,5.5728E-4,4.6181E-4,6.2609E-4,6.8892E-4,7.1881E-4,5.5839E-4,4.606E-4,6.2378E-4,6.8766E-4,7.1766E-4,5.5801E-4,4.6128E-4,6.2197E-4,6.8939E-4,7.1723E-4,5.585E-4,4.6187E-4,6.1971E-4,6.8618E-4,7.1833E-4,5.5723E-4,4.5946E-4,6.205E-4,6.8652E-4,7.1312E-4,5.5866E-4,4.601E-4,6.1917E-4,6.8474E-4,7.1785E-4,5.5597E-4,4.5867E-4,6.1751E-4,6.8605E-4,7.1492E-4,5.5457E-4,4.5741E-4,6.1666E-4,6.8421E-4,7.1194E-4,5.5451E-4,4.5722E-4,6.1727E-4,6.8158E-4,7.14E-4,5.5593E-4,4.5921E-4,6.1667E-4,6.838E-4,7.1418E-4,5.5166E-4,4.5786E-4,6.1387E-4,6.7895E-4,7.0868E-4,5.5164E-4,4.6247E-4,6.151E-4,6.7965E-4,7.1146E-4,5.5477E-4,4.5746E-4,6.1569E-4,6.7774E-4,7.1108E-4,5.5257E-4,4.5492E-4,6.1538E-4,6.771E-4,7.0777E-4,5.5543E-4,4.5501E-4,6.1267E-4,6.774E-4,7.1035E-4,5.5315E-4,4.5633E-4,6.1225E-4,6.7544E-4,7.1256E-4,5.5301E-4,4.5457E-4,6.1195E-4,6.7467E-4,7.1029E-4,5.5274E-4,4.5528E-4,6.1101E-4,6.7595E-4,7.1069E-4,5.5192E-4,4.5371E-4,6.1117E-4,6.7442E-4,7.0907E-4,5.5128E-4,4.532E-4,6.1011E-4,6.7208E-4,7.1032E-4,5.4977E-4,4.533E-4,6.0886E-4,6.718E-4,7.0772E-4,5.5175E-4,4.5259E-4,6.0863E-4,6.7492E-4,7.0742E-4,5.5059E-4,4.5332E-4,6.0609E-4,6.7177E-4,7.0837E-4,5.4943E-4,4.5449E-4,6.0525E-4,6.7088E-4,7.0526E-4,5.5269E-4,4.5055E-4,6.0657E-4,6.7211E-4,7.0491E-4,5.4954E-4,4.5255E-4,6.0619E-4,6.7088E-4,7.0776E-4,5.4938E-4,4.5201E-4,6.0865E-4,6.706E-4,7.0338E-4,5.4797E-4,4.5097E-4,6.0556E-4,6.697E-4,7.0541E-4,5.5249E-4,4.4901E-4,6.0865E-4,6.6939E-4,7.0629E-4,5.5106E-4,4.5268E-4,6.0492E-4,6.6718E-4,7.066E-4,5.5224E-4,4.5089E-4,6.057E-4,6.7137E-4,7.0547E-4,5.5173E-4,4.5209E-4,6.0623E-4,6.7227E-4,7.072E-4,5.4909E-4,4.4923E-4,6.0614E-4,6.6668E-4,7.0994E-4,5.486E-4,4.4996E-4,6.014E-4,6.7161E-4,7.0467E-4,5.4838E-4,4.5094E-4,6.0458E-4,6.6956E-4,7.0613E-4,5.5138E-4,4.5249E-4,6.0672E-4,6.6924E-4,7.0718E-4,5.5356E-4,4.502E-4,6.0574E-4,6.6868E-4,7.0702E-4,5.5336E-4,4.5195E-4,6.0764E-4,6.6703E-4,7.0883E-4,5.4976E-4,4.5123E-4,6.014E-4,6.7114E-4,7.0446E-4,5.5078E-4,4.4974E-4,6.0291E-4,6.7032E-4,7.0864E-4,5.5274E-4,4.4996E-4,6.0046E-4,6.6883E-4,7.0771E-4,5.5122E-4:2
1.7713E-5,-1.0867E-6,9.3E-6,1.2837E-5,-2.4167E-6,9.3E-6,-9.0E-7,9.0033E-6,1.5147E-5,-1.77E-6,1.8033E-5,5.9967E-6,1.2577E-5,1.1823E-5,-5.0333E-7,1.2533E-5,7.7433E-6,5.6033E-6,6.7033E-6,-2.6433E-6,1.1587E-5,-4.1333E-6,1.439E-5,9.7033E-6,2.2333E-7,1.4677E-5,7.675E-4,0.0022526,0.0019941,0.0016972,0.0016418,0.0020086,0.0022108,0.0020661,0.0016424,0.001682,0.0019873,0.0022078,0.0020741,0.0016483,0.0016854,0.0019898,0.0022089,0.0020709,0.0016357,0.0016819,0.001973,0.002193,0.002066,0.0016334,0.0016729,0.0019667,0.0021923,0.0020536,0.0016285,0.0016672,0.0019607,0.0021883,0.0020511,0.001621,0.0016589,0.0019507,0.0021846,0.0020501,0.0016278,0.0016639,0.0019622,0.0021955,0.0020597,0.00163,0.001678,0.0019684,0.0021957,0.0020732,0.001638,0.0016751,0.0019619,0.0021975,0.0020671,0.001627,0.0016831,0.0019613,0.0021935,0.0020616,0.0016248,0.0016585,0.0019513,0.0021763,0.0020445,0.0016194,0.0016542,0.0019466,0.002182,0.0020554,0.0016227,0.0016562,0.0019482,0.002191,0.0020659,0.0016305,0.0016659,0.0019527,0.0021941,0.0020602,0.0016279,0.0016587,0.00194,0.0021814,0.0020463,0.0016156,0.0016538,0.0019347,0.0021722,0.0020502,0.001622,0.0016584,0.0019454,0.0021895,0.0020596,0.0016263,0.0016642,0.0019462,0.0021894,0.0020505,0.0016135,0.0016432,0.0019346,0.0021624,0.0020482,0.0016191,0.0016525,0.0019437,0.0021791,0.0020606,0.0016314,0.0016657,0.0019489,0.0021969,0.0020543,0.0016161,0.0016483,0.0019251,0.0021679,0.0020418,0.0016176,0.0016479,0.0019338,0.002176,0.0020586,0.001623,0.0016581,0.0019378,0.0021741,0.0020429,0.0016081,0.0016477,0.0019183,0.0021727,0.0020433,0.0016115,0.0016509,0.0019333,0.0021757,0.0020483,0.0016076,0.0016417,0.0019201,0.002164,0.002028,0.0016016,0.0016437,0.0019262,0.0021693,0.0020381,0.0016084,0.0016383,0.0019125,0.0021582,0.0020195,0.0015984,0.0016341,0.0019159,0.0021609,0.0020414,0.001607,0.001637,0.0019198,0.0021524,0.0020207,0.0015913,0.0016275,0.0019026,0.0021582,0.0020396,0.0016042,0.0016344,0.001908,0.0021536,0.002013,0.0015883,0.0016166,0.0018947,0.0021464,0.002034,0.0015946,0.0016353,0.0019013,0.0021413,0.0020124,0.0015854,0.0016178,0.0018957,0.0021506,0.0020296,0.0015945,0.0016259,0.0018909,0.0021353,0.002004,0.0015846,0.001618,0.0018937,0.0021504,0.0020177,0.0015961,0.0016178,0.0018871,0.0021405,0.0020049,0.0015847,0.0016181,0.0018921,0.0021507,0.0020208,0.0015841,0.0016093,0.0018838,0.0021316,0.002011,0.0015831,0.0016242,0.0018919,0.002135,0.0020049,0.0015731,0.0016027,0.0018757,0.0021337,0.0020095,0.0015845,0.0016138,0.0018838,0.0021247,0.0019945,0.0015675,0.0015989,0.0018832,0.002134,0.0020039,0.0015773,0.0016068,0.0018702,0.0021135,0.0019986,0.0015714,0.0016081,0.0018763,0.0021321,0.0020103,0.0015635,0.0016042,0.0018723,0.0021275,0.0020081,0.0015858,0.0016122,0.0018783,0.0021188,0.0020017,0.0015635,0.0016101,0.0018869,0.0022552,0.0021543,0.0017145,0.0017073,0.0020334,0.0022661,0.0021466,0.0017124,0.0017288,0.0020719,0.0023122,0.0021794,0.0017282,0.0017229,0.0020731,0.002316,0.0021887,0.0017371,0.0017315,0.0020665,0.0022956,0.0021779,0.0017229,0.0017347,0.002071,0.0023133,0.0021711,0.0017229,0.0017123,0.0020518,0.0022986,0.00217,0.0017263,0.001723,0.0020561,0.0022804,0.0021637,0.0017171,0.0017275,0.0020625,0.0022939,0.0021657,0.0017198,0.0017115,0.002048,0.0022944,0.0021677,0.0017193,0.0017248,0.002045,0.0022806,0.0021543,0.0017113,0.0017135,0.0020594,0.0022927,0.0021562,0.0017066,0.0017091,0.002043,0.0022885,0.0021604,0.0017145,0.0017121,0.0020407,0.0022729,0.0021508,0.0017109,0.0017138,0.0020455,0.0022864,0.0021474,0.001696,0.0016974,0.0020357,0.0022822,0.0021503,0.0017105,0.0017104,0.0020238,0.0022605,0.0021527,0.0017052,0.0017095,0.0020365,0.0022739,0.002139,0.0016987,0.0016995,0.002032,0.0022868,0.0021449,0.001706,0.001695,0.0020262,0.0022624,0.0021433,0.0017016,0.0017054,0.0020303,0.0022563,0.0021268,0.0016901,0.0016986,0.0020291,0.0022687,0.0021381,0.0016921,0.0016939,0.0020171,0.0022639,0.0021476,0.0016971,0.0016933,0.0020092,0.0022493,0.0021244,0.0016949,0.0017,0.0020232,0.0022581,0.0021289,0.0016762,0.0016878,0.0020164,0.0022664,0.0021085,0.001656,0.0016539,0.0019618,0.0021947,0.0020687,0.0016471,0.0016197,0.0019368,0.0021795,0.0020423,0.0016264:2
6.66E-6,-2.9667E-7,3.6833E-6,7.35E-6,-7.6333E-7,1.2307E-5,2.1433E-6,-1.6067E-6,4.9633E-6,1.6133E-6,1.4583E-5,-1.0333E-6,1.1933E-6,1.2307E-5,-5.1733E-6,2.195E-5,1.1697E-5,4.9867E-6,1.2233E-6,-9.2167E-6,2.9713E-5,1.7463E-5,7.9333E-6,1.5527E-5,5.759E-5,0.0022932,0.0027036,0.0029063,0.0024233,0.0021116,0.0021786,0.0022763,0.0023857,0.0020589,0.0017148,0.0018378,0.0021855,0.0023638,0.0020602,0.0017106,0.0018533,0.0022005,0.0023616,0.002058,0.0017028,0.0018429,0.0021829,0.0023553,0.0020444,0.0016987,0.0018382,0.0021774,0.0023527,0.0020428,0.0017018,0.0018474,0.0021808,0.0023597,0.0020403,0.0017022,0.0018498,0.0021865,0.0023593,0.0020486,0.001709,0.0018518,0.0021949,0.0023529,0.0020449,0.0017092,0.0018486,0.0021946,0.0023598,0.0020426,0.0017065,0.0018486,0.0021883,0.0023479,0.0020439,0.0016921,0.0018366,0.0021772,0.0023314,0.0020272,0.0016859,0.0018306,0.0021594,0.002322,0.002009,0.0016842,0.001829,0.0021747,0.0023329,0.0020193,0.0016815,0.0018398,0.0021814,0.0023395,0.0020166,0.0016821,0.0018375,0.0021654,0.0023199,0.0019984,0.0016677,0.0018132,0.0021452,0.0022993,0.0019773,0.0016565,0.0018153,0.0021535,0.002307,0.0019968,0.0016682,0.0018273,0.0021662,0.0023122,0.0019921,0.0016698,0.0018207,0.0021446,0.0022873,0.0019575,0.0016326,0.0017215,0.0019948,0.0021285,0.0018325,0.0015384,0.0016896,0.0019981,0.0021424,0.0018378,0.001544,0.0016865,0.0019967,0.002126,0.0018245,0.0015283,0.0016704,0.0019877,0.0021214,0.0018211,0.0015403,0.0016833,0.002,0.0021294,0.0018278,0.0015344,0.00168,0.0019901,0.0021105,0.0018107,0.0015197,0.00167,0.0019844,0.0021149,0.0018211,0.0015331,0.0016898,0.0019884,0.0021213,0.0018112,0.0015219,0.0016662,0.001971,0.0021043,0.0018078,0.0015238,0.0016827,0.0019905,0.0021179,0.0018057,0.0015257,0.001676,0.0019761,0.0020995,0.0017986,0.0015216,0.0016729,0.0019802,0.0021129,0.0018049,0.0015235,0.0016813,0.0019776,0.0020996,0.0017852,0.0015139,0.0016696,0.0019674,0.0021076,0.0017972,0.0015157,0.0016856,0.0019742,0.0020934,0.0017782,0.0015047:2
-1.6E-7,2.28E-6,-1.2267E-6,2.5E-6,1.0367E-6,-4.1667E-7,2.1E-6,-3.5E-7,5.2667E-7,4.9E-7,4.3E-7,2.2733E-6,-1.0733E-6,1.2333E-6,1.6667E-8,-8.0667E-7,1.5333E-6,-2.2167E-6,1.1967E-6,-2.6667E-7,-1.3667E-7,2.0733E-6,-1.1433E-6,1.9667E-6,-1.6333E-7,-1.7133E-6,2.5267E-6,-1.1567E-6,2.4533E-6,4.8667E-7,-3.8E-7,2.2333E-6,-7.4E-7,3.14E-6,1.04E-6,-1.9967E-6,1.6567E-6,-1.1533E-6,2.08E-6,1.8833E-6,-1.5933E-6,1.6233E-6,-1.0E-6,2.2867E-6,6.5E-7,-1.3567E-6,2.01E-6,-6.5E-7,2.5467E-6,1.8E-6,-9.9333E-7,2.73E-6,-2.5933E-6,2.5E-6,1.0267E-6,-9.6667E-8,6.7879E-4,6.7551E-4,7.3728E-4,8.644E-4,8.5762E-4,6.6413E-4,6.7146E-4,7.4406E-4,8.6404E-4,8.4768E-4,6.7542E-4,6.673E-4,7.4769E-4,8.635E-4,8.5128E-4,6.7187E-4,6.6473E-4,7.499E-4,8.6205E-4,8.4891E-4,6.7665E-4,6.6691E-4,7.4721E-4,8.599E-4,8.4775E-4,6.7466E-4,6.653E-4,7.4926E-4,8.6003E-4,8.4558E-4,6.723E-4,6.6301E-4,7.4953E-4,8.6397E-4,8.4533E-4,6.7363E-4,6.6451E-4,7.5153E-4,8.6236E-4,8.4474E-4,6.7358E-4,6.659E-4,7.4933E-4,8.6194E-4,8.4139E-4,6.718E-4,6.6425E-4,7.4957E-4,8.6028E-4,8.4319E-4,6.723E-4,6.6453E-4,7.5065E-4,8.6256E-4,8.4368E-4,6.7223E-4,6.6362E-4,7.4947E-4,8.6003E-4,8.4282E-4,6.6799E-4,6.617E-4,7.4712E-4,8.5776E-4,8.3916E-4,6.6729E-4,6.6019E-4,7.4753E-4,8.5831E-4,8.3896E-4,6.6709E-4,6.6136E-4,7.489E-4,8.5867E-4,8.3755E-4,6.6683E-4,6.6167E-4,7.5069E-4,8.564E-4,8.3778E-4,6.6527E-4,6.6117E-4,7.4806E-4,8.5818E-4,8.3669E-4,6.6492E-4,6.5878E-4,7.4651E-4,8.5859E-4,8.358E-4,6.6255E-4,6.6011E-4,7.4988E-4,8.5629E-4,8.3369E-4,6.6517E-4,6.5768E-4,7.4899E-4,8.5732E-4,8.3148E-4,6.6259E-4,6.5999E-4,7.4917E-4,8.5254E-4,8.3069E-4,6.5944E-4,6.5937E-4,7.4921E-4,8.5265E-4,8.3083E-4,6.61E-4,6.568E-4,7.4945E-4,8.5293E-4,8.3144E-4,6.5776E-4,6.5787E-4,7.4807E-4,8.5409E-4,8.2896E-4,6.6002E-4,6.5951E-4,7.4799E-4,8.5272E-4,8.3024E-4,6.5967E-4,6.568E-4,7.5027E-4,8.5353E-4,8.2583E-4,6.6018E-4,6.5696E-4,7.4814E-4,8.5279E-4,8.2807E-4,6.5864E-4,6.5682E-4,7.4911E-4,8.5067E-4,8.2491E-4,6.5715E-4,6.5688E-4,7.4553E-4,8.5125E-4,8.2503E-4,6.5492E-4,6.5956E-4,7.4564E-4,8.4856E-4,8.2264E-4,6.5409E-4,6.559E-4,7.4491E-4,8.4816E-4,8.2394E-4,6.5076E-4,6.5587E-4,7.471E-4,8.478E-4,8.2259E-4,6.5062E-4,6.5437E-4,7.4546E-4,8.4624E-4,8.1814E-4,6.4873E-4,6.5246E-4,7.461E-4,8.4597E-4,8.1863E-4,6.4941E-4,6.5363E-4,7.4475E-4,8.4517E-4,8.1493E-4,6.4673E-4,6.5105E-4,7.462E-4,8.4736E-4,8.1506E-4,6.4715E-4,6.5482E-4,7.4293E-4,8.4536E-4,8.1128E-4,6.46E-4,6.485E-4,7.4457E-4,8.4124E-4,8.106E-4,6.4728E-4,6.5113E-4,7.412E-4,8.4025E-4,8.1231E-4,6.4515E-4,6.5191E-4,7.4163E-4,8.4211E-4,8.0925E-4,6.4192E-4,6.5083E-4,7.4159E-4,8.3951E-4,8.0633E-4,6.4216E-4,6.4755E-4,7.4217E-4,8.3879E-4,8.0587E-4,6.4184E-4,6.487E-4,7.4136E-4,8.3753E-4,8.0588E-4,6.3989E-4,6.4675E-4,7.4154E-4,8.3798E-4,8.0524E-4,6.3742E-4,6.4829E-4,7.3889E-4,8.3743E-4,8.0437E-4,6.3725E-4,6.4665E-4,7.3966E-4,8.3247E-4,8.0246E-4,6.3783E-4,6.4979E-4,7.3998E-4,8.3612E-4,8.0078E-4,6.3334E-4,6.4476E-4,7.4233E-4,8.3169E-4,7.9851E-4,6.3494E-4,6.4493E-4,7.3747E-4,8.3287E-4,7.9481E-4,6.319E-4,6.4505E-4,7.3979E-4,8.304E-4,7.9481E-4,6.316E-4,6.4208E-4,7.3846E-4,8.276E-4,7.9278E-4,6.2842E-4,6.413E-4,7.3826E-4,8.2459E-4,7.9232E-4,6.2796E-4,6.4176E-4,7.3693E-4,8.2618E-4,7.8806E-4,6.2581E-4,6.3983E-4,7.3602E-4,8.2437E-4,7.8589E-4,6.2396E-4,6.3703E-4,7.3409E-4,8.2234E-4,7.8472E-4,6.2294E-4,6.3774E-4,7.347E-4,8.1949E-4,7.8421E-4,4.1596E-4:2
3.04E-6,9.6667E-7,-1.0467E-6,2.2167E-6,-4.8333E-7,2.0367E-6,-6.3333E-8,4.0667E-7,1.8067E-6,-1.0167E-6,1.59E-6,2.9667E-7,4.5333E-7,1.38E-6,-7.7667E-7,1.0633E-6,5.8333E-7,8.3333E-8,5.2333E-7,-3.1333E-7,1.88E-6,5.4E-7,7.2E-7,1.9433E-6,-1.8E-7,1.08E-6,-4.0E-7,-2.5667E-7,2.0767E-6,-4.1E-7,1.34E-6,2.9333E-7,-3.6667E-7,1.93E-6,-2.8667E-7,1.34E-6,3.9333E-7,2.0E-7,1.9467E-6,-1.2833E-6,2.1E-6,5.3333E-7,-2.6567E-6,1.9733E-6,-1.9967E-6,1.25E-6,2.2E-7,-5.6667E-8,1.55E-6,-1.8633E-6,1.6067E-6,4.8E-7,-4.4667E-7,2.1567E-6,-1.4933E-6,2.1833E-6,6.0E-8,-1.5667E-7,1.4533E-6,-9.7E-7,1.7733E-6,1.6667E-7,3.0667E-7,1.92E-6,-8.1E-7,2.2567E-6,-2.1333E-7,4.1333E-7,8.3333E-7,-9.7E-7,6.2E-7,2.14E-6,-5.6667E-7,1.77E-6,-1.5167E-6,2.64E-6,8.3E-7,-8.0667E-7,9.1333E-7,-9.9333E-7,1.6967E-6,-5.5E-7,3.0333E-7,1.8833E-6,-1.4367E-6,1.66E-6,1.9167E-6,6.1333E-7,8.1E-7,-2.3633E-6,1.45E-6,2.22E-6,-1.5E-7,2.0033E-6,-2.5433E-6,9.4167E-5,8.9996E-4,8.2831E-4,7.2571E-4,6.1305E-4,7.3727E-4,8.3459E-4,8.3844E-4,7.0163E-4,6.4083E-4,7.1951E-4,8.3998E-4,8.4825E-4,6.9689E-4,6.4814E-4,7.1318E-4,8.4008E-4,8.4571E-4,7.0102E-4,6.5001E-4,7.1408E-4,8.4274E-4,8.4942E-4,7.0148E-4,6.5033E-4,7.1401E-4,8.4044E-4,8.4781E-4,7.0052E-4,6.4853E-4,7.0964E-4,8.4262E-4,8.489E-4,7.0095E-4,6.4981E-4,7.1136E-4,8.4029E-4,8.5146E-4,7.0469E-4,6.502E-4,7.0899E-4,8.4054E-4,8.4937E-4,7.0359E-4,6.4703E-4,7.0712E-4,8.3751E-4,8.4975E-4,7.057E-4,6.4821E-4,7.0316E-4,8.4031E-4,8.5371E-4,7.074E-4,6.4695E-4,7.012E-4,8.3926E-4,8.5512E-4,7.0859E-4,6.4358E-4,7.0218E-4,8.36E-4,8.5268E-4,7.0689E-4,6.4467E-4,7.0137E-4,8.3576E-4,8.5205E-4,7.1258E-4,6.4747E-4,6.9656E-4,8.3363E-4,8.5331E-4,7.1327E-4,6.4368E-4,6.9612E-4,8.3252E-4,8.4919E-4,7.1241E-4,6.4566E-4,6.9507E-4,8.3303E-4,8.5194E-4,7.1299E-4,6.4434E-4,6.9342E-4,8.3085E-4,8.4882E-4,7.1508E-4,6.451E-4,6.9067E-4,8.2876E-4,8.5008E-4,7.153E-4,6.4364E-4,6.8704E-4,8.2829E-4,8.5135E-4,7.1903E-4,6.4219E-4,6.8538E-4,8.2667E-4,8.4947E-4,7.184E-4,6.4427E-4,6.8619E-4,8.225E-4,8.4896E-4,7.1801E-4,6.4136E-4,6.8128E-4,8.239E-4,8.4507E-4,7.1943E-4,6.4173E-4,6.8292E-4,8.2051E-4,8.48E-4,7.1926E-4,6.4117E-4,6.773E-4,8.1998E-4,8.4812E-4,7.1994E-4,6.4007E-4,6.7513E-4,8.1961E-4,8.4622E-4,7.211E-4,6.4022E-4,6.7453E-4,8.1636E-4,8.4636E-4,7.2177E-4,6.3847E-4,6.7281E-4,8.1246E-4,8.4101E-4,7.2275E-4,6.3809E-4,6.7114E-4,8.1169E-4,8.4545E-4,7.2441E-4,6.403E-4,6.6926E-4,8.1E-4,8.4227E-4,7.2349E-4,6.3819E-4,6.6675E-4,8.0884E-4,8.429E-4,7.2505E-4,6.3705E-4,6.6712E-4,8.0721E-4,8.3846E-4,7.2445E-4,6.3646E-4,6.6222E-4,8.0702E-4,8.3811E-4,7.2752E-4,6.3666E-4,6.6184E-4,8.0662E-4,8.3861E-4,7.3034E-4,6.3653E-4,6.5852E-4,8.0257E-4,8.3948E-4,7.2845E-4,6.3745E-4,6.5902E-4,8.026E-4,8.4077E-4,7.3247E-4,6.3589E-4,6.5607E-4,8.0505E-4,8.3543E-4,7.2955E-4,6.3607E-4,6.5357E-4,7.9531E-4,8.377E-4,7.3071E-4,6.3552E-4,6.5227E-4,7.9809E-4,8.3556E-4,7.3269E-4,6.3486E-4,6.4988E-4,7.9317E-4,8.3307E-4,7.3118E-4,6.3484E-4,6.4737E-4,7.9253E-4,8.355E-4,7.3377E-4,6.361E-4,6.4677E-4,7.8826E-4,8.3181E-4,7.3118E-4,6.3355E-4,6.4151E-4,7.8613E-4,8.3002E-4,7.335E-4,6.3297E-4,6.4208E-4,7.8591E-4,8.3092E-4,7.3408E-4,6.3538E-4,6.3942E-4,7.8509E-4,8.2489E-4,7.3265E-4,6.3383E-4,6.3997E-4,7.8115E-4,8.2769E-4,7.3451E-4,6.3311E-4,6.3276E-4,7.7817E-4,8.2817E-4,7.3364E-4,6.3068E-4,6.3247E-4,7.7741E-4,8.2449E-4,7.3292E-4,6.3171E-4,6.3074E-4,7.7433E-4,8.2152E-4,7.3506E-4,6.3036E-4,6.2899E-4,7.7096E-4,8.2034E-4,7.344E-4,6.2995E-4,6.2436E-4,7.6762E-4,8.1613E-4,7.3447E-4,6.2961E-4,6.2228E-4,7.6443E-4,8.1631E-4,7.3493E-4,6.276E-4,6.2487E-4,7.6657E-4,8.1713E-4,7.3596E-4,6.2948E-4,6.2002E-4,7.6259E-4,8.1406E-4,7.3624E-4,6.2698E-4,6.1765E-4,7.6081E-4,8.1603E-4,7.3561E-4,6.2746E-4,6.1732E-4,7.5938E-4,8.1115E-4,7.3638E-4,6.2558E-4,6.1267E-4,7.5726E-4,8.115E-4,7.3524E-4,6.266E-4,6.1298E-4,7.5502E-4,8.0919E-4,7.3853E-4,6.2588E-4,6.1027E-4,7.5046E-4,8.0709E-4,7.3588E-4,6.2626E-4,6.0584E-4,7.4724E-4,8.0723E-4,7.3746E-4,6.237E-4,6.0819E-4,7.4341E-4,8.0415E-4,7.3698E-4,6.2447E-4,6.0503E-4,7.412E-4,8.0057E-4,7.3697E-4,6.242E-4,5.9852E-4,7.3841E-4,7.977E-4,7.3561E-4,6.2533E-4,5.9832E-4,7.367E-4,7.9848E-4,1.9531E-4:2
9.1333E-7,1.1967E-6,-9.0667E-7,2.3733E-6,-2.5667E-7,6.6E-7,1.53E-6,-1.1267E-6,2.2833E-6,-1.2033E-6,1.64E-6,1.7733E-6,-1.47E-6,1.77E-6,5.2333E-7,5.6667E-7,1.4633E-6,-1.76E-6,2.21E-6,-8.4333E-7,4.5E-7,1.7233E-6,-2.69E-6,1.28E-6,-4.1667E-7,-4.3333E-8,1.8233E-6,-5.9333E-7,2.4233E-6,-1.3367E-6,1.7133E-6,9.5333E-7,-1.0867E-6,2.1267E-6,-5.6333E-7,1.5733E-6,1.9233E-6,-5.8E-7,2.7233E-6,-5.1333E-7,3.0333E-7,2.38E-6,-2.6E-7,1.8667E-6,4.2667E-7,1.7967E-6,1.5867E-6,-1.5667E-6,2.4733E-6,-6.6667E-7,2.0667E-6,1.73E-6,-6.4E-7,2.6367E-6,-4.1667E-7,6.1333E-7,1.3133E-6,-1.5667E-6,2.6333E-6,6.0E-8,1.13E-6,1.8233E-6,-1.7233E-6,2.6567E-6,-1.2367E-6,6.0E-7,1.4E-6,-2.4833E-6,2.5833E-6,-5.4E-7,7.4E-7,5.6E-7,-1.5867E-6,2.7533E-6,1.3667E-7,3.6667E-8,8.9333E-7,-1.21E-6,2.38E-6,-6.0E-7,8.9E-7,1.7667E-6,-1.1433E-6,1.39E-6,-7.4667E-7,1.51E-6,2.16E-6,-1.1367E-6,2.0E-6,7.1333E-7,3.2333E-7,1.1833E-6,-1.37E-6,2.4367E-6,1.1771E-4,9.0141E-4,8.0367E-4,7.2897E-4,6.0128E-4,7.7851E-4,8.5008E-4,8.131E-4,7.0334E-4,6.2049E-4,7.6357E-4,8.5046E-4,8.2307E-4,6.9986E-4,6.2399E-4,7.6092E-4,8.5095E-4,8.2364E-4,7.0158E-4,6.2724E-4,7.5934E-4,8.497E-4,8.2452E-4,7.0331E-4,6.2493E-4,7.597E-4,8.4984E-4,8.2176E-4,7.0544E-4,6.2546E-4,7.5717E-4,8.5168E-4,8.2872E-4,7.0561E-4,6.2583E-4,7.5242E-4,8.4739E-4,8.2828E-4,7.0866E-4,6.2575E-4,7.5593E-4,8.498E-4,8.2958E-4,7.0818E-4,6.2306E-4,7.5156E-4,8.5068E-4,8.287E-4,7.0895E-4,6.241E-4,7.4847E-4,8.4774E-4,8.3187E-4,7.1253E-4,6.2122E-4,7.4826E-4,8.4543E-4,8.3389E-4,7.1407E-4,6.2426E-4,7.4705E-4,8.439E-4,8.3026E-4,7.1419E-4,6.2161E-4,7.4502E-4,8.4567E-4,8.3195E-4,7.1662E-4,6.2264E-4,7.4284E-4,8.4092E-4,8.3255E-4,7.1464E-4,6.214E-4,7.3943E-4,8.417E-4,8.3355E-4,7.1506E-4,6.2194E-4,7.3994E-4,8.3887E-4,8.3208E-4,7.1804E-4,6.1984E-4,7.3814E-4,8.4051E-4,8.3389E-4,7.1637E-4,6.189E-4,7.3698E-4,8.396E-4,8.345E-4,7.1832E-4,6.1659E-4,7.3686E-4,8.3851E-4,8.3059E-4,7.1862E-4,6.1913E-4,7.3308E-4,8.3184E-4,8.3172E-4,7.2026E-4,6.1697E-4,7.2984E-4,8.3655E-4,8.3038E-4,7.2263E-4,6.1679E-4,7.3134E-4,8.335E-4,8.3239E-4,7.2363E-4,6.1256E-4,7.2878E-4,8.3121E-4,8.3394E-4,7.2198E-4,6.1548E-4,7.2636E-4,8.2997E-4,8.3374E-4,7.2364E-4,6.1531E-4,7.2358E-4,8.3122E-4,8.3322E-4,7.2248E-4,6.1114E-4,7.219E-4,8.2447E-4,8.3291E-4,7.2218E-4,6.1026E-4,7.1823E-4,8.2699E-4,8.3038E-4,7.2397E-4,6.1253E-4,7.1531E-4,8.2231E-4,8.3312E-4,7.236E-4,6.1203E-4,7.1509E-4,8.2043E-4,8.3258E-4,7.2445E-4,6.1012E-4,7.1682E-4,8.2238E-4,8.2844E-4,7.2422E-4,6.086E-4,7.1052E-4,8.1691E-4,8.2893E-4,7.2449E-4,6.0796E-4,7.1139E-4,8.149E-4,8.2879E-4,7.2766E-4,6.0708E-4,7.0627E-4,8.1591E-4,8.2814E-4,7.2634E-4,6.1146E-4,7.0531E-4,8.1554E-4,8.3208E-4,7.2903E-4,6.0595E-4,7.0158E-4,8.136E-4,8.2862E-4,7.2904E-4,6.0271E-4,7.0269E-4,8.0997E-4,8.3035E-4,7.2955E-4,6.0719E-4,7.0148E-4,8.0958E-4,8.2573E-4,7.3181E-4,6.0452E-4,7.0123E-4,8.0713E-4,8.2884E-4,7.2958E-4,6.0362E-4,6.9923E-4,8.0449E-4,8.2861E-4,7.2965E-4,6.0344E-4,6.9612E-4,8.0272E-4,8.2717E-4,7.2889E-4,6.0357E-4,6.9496E-4,8.0109E-4,8.2733E-4,7.2974E-4,6.0235E-4,6.9156E-4,8.0068E-4,8.2385E-4,7.299E-4,6.0324E-4,6.9032E-4,7.9697E-4,8.2531E-4,7.2851E-4,6.0225E-4,6.8609E-4,7.9653E-4,8.2524E-4,7.3054E-4,5.9981E-4,6.8443E-4,7.9123E-4,8.2105E-4,7.3139E-4,5.9961E-4,6.8316E-4,7.9231E-4,8.2043E-4,7.3339E-4,6.0082E-4,6.8096E-4,7.8981E-4,8.2126E-4,7.3135E-4,6.0034E-4,6.8102E-4,7.8755E-4,8.2266E-4,7.3512E-4,5.9795E-4,6.793E-4,7.8646E-4,8.2061E-4,7.3382E-4,5.9916E-4,6.7522E-4,7.8277E-4,8.1894E-4,7.3532E-4,5.9686E-4,6.7635E-4,7.8338E-4,8.195E-4,7.3501E-4,5.9714E-4,6.7208E-4,7.7887E-4,8.1932E-4,7.3566E-4,5.9628E-4,6.6966E-4,7.7804E-4,8.1397E-4,7.3497E-4,5.9807E-4,6.6923E-4,7.7737E-4,8.1652E-4,7.3648E-4,5.9464E-4,6.6661E-4,7.7366E-4,8.148E-4,7.3658E-4,5.9548E-4,6.627E-4,7.7185E-4,8.1635E-4,7.3471E-4,5.9544E-4,6.6159E-4,7.7136E-4,8.115E-4,7.3608E-4,5.9369E-4,6.5977E-4,7.6949E-4,8.108E-4,7.3487E-4,5.9198E-4,6.5516E-4,7.673E-4,8.0869E-4,7.3536E-4,5.9253E-4,6.5383E-4,7.6252E-4,8.0665E-4,7.3355E-4,5.9211E-4,6.5344E-4,7.6326E-4,8.0472E-4,7.3473E-4,5.9032E-4,6.5117E-4,7.5812E-4,8.0574E-4,7.337E-4,5.8999E-4,6.4863E-4,7.5742E-4,8.0341E-4,7.3633E-4,5.9117E-4,6.4592E-4,7.5512E-4,8.0434E-4,7.3378E-4,5.8775E-4,6.4345E-4,7.5142E-4,8.0032E-4,7.3251E-4,5.8844E-4,6.4197E-4,7.4898E-4,7.9854E-4,7.3344E-4,5.8554E-4,6.4152E-4,7.4673E-4,7.9816E-4,7.3214E-4,5.8808E-4,6.3925E-4,7.4474E-4,7.9753E-4,7.3475E-4,5.8727E-4,6.3568E-4,7.428E-4,7.9545E-4,7.3097E-4,5.8474E-4,6.3554E-4,7.4024E-4,7.924E-4,7.3312E-4,5.825E-4,6.3206E-4,7.3678E-4,7.9188E-4,7.3152E-4,5.8468E-4,6.3051E-4,7.3474E-4,7.8993E-4,7.3204E-4,5.8096E-4,6.2939E-4,7.3383E-4,7.868E-4,7.3409E-4,5.8304E-4,6.2698E-4,7.2993E-4,7.8529E-4,7.3172E-4,5.8178E-4,6.2328E-4,7.2738E-4,7.8402E-4,7.3039E-4,5.5857E-5:2
3.6857E-5,-2.02E-6,2.8593E-5,4.39E-6,1.1063E-5,3.229E-5,-3.01E-6,2.1397E-5,3.17E-6,2.4917E-5,2.856E-5,-5.8833E-6,2.2927E-5,2.4867E-6,2.128E-5,2.6067E-5,9.5E-7,3.8367E-5,6.8333E-6,2.9203E-5,2.2113E-5,-4.9733E-6,3.6967E-5,-2.13E-6,2.3483E-5,3.3903E-5,5.3667E-6,3.4043E-5,-2.6767E-6,3.0493E-5,4.2893E-5,1.4628E-4,0.011312,0.012108,0.013832,0.014791,0.012955,0.010514,0.011794,0.013796,0.014783,0.01273,0.010689,0.011647,0.013767,0.014756,0.012708,0.010639,0.011521,0.013637,0.014613,0.012553,0.010571,0.011344,0.013496,0.014472,0.012481,0.010526,0.011274,0.013464,0.01452,0.012527,0.01056,0.011246,0.013427,0.014467,0.012516,0.010555,0.011218,0.013418,0.014477,0.012514,0.010536,0.011155,0.01338,0.014448,0.012574,0.010543,0.011144,0.013353,0.014442,0.012608,0.010555,0.011122,0.013322,0.014413,0.012614,0.010545,0.011117,0.013271,0.014386,0.012624,0.010529,0.011085,0.013226,0.014386,0.012634,0.010529,0.011066,0.013185,0.014389,0.012653,0.010537,0.011026,0.013167,0.014404,0.012685,0.01054,0.010999,0.013137,0.014428,0.012689,0.010539,0.010972,0.013123,0.014402,0.01268,0.010537,0.010945,0.013094,0.014355,0.012725,0.010551,0.010914,0.013047,0.014371,0.012732,0.010538,0.010885,0.013036,0.014348,0.012724,0.010538,0.010845,0.012973,0.014301,0.012727,0.010524,0.010832,0.01295,0.014296,0.012754,0.010545,0.010789,0.012908,0.014293,0.012721,0.010524,0.010781,0.012871,0.014268,0.012791,0.010514,0.010747,0.012862,0.014228,0.012783,0.010506,0.010712,0.012813,0.014182,0.012806,0.010501,0.010682,0.012763,0.014181,0.012807,0.010503,0.010668,0.012696,0.014174,0.012799,0.010506,0.010646,0.012655,0.014181,0.0128,0.010485,0.010609,0.012625,0.014135,0.012801,0.010509,0.01058,0.012586,0.014132,0.01283,0.010508,0.010518,0.01256,0.014075,0.012843,0.010489,0.010494,0.01252,0.014048,0.012846,0.010474,0.010483,0.012478:2
1.9553E-5,7.19E-6,2.4717E-5,2.8297E-5,1.88E-6,2.6333E-5,3.1667E-6,1.5157E-5,2.5587E-5,1.309E-5,2.639E-5,7.0567E-6,1.4957E-5,2.8367E-5,-2.52E-6,3.466E-5,1.5957E-5,2.0647E-5,3.2227E-5,-4.7433E-6,1.7193E-5,5.54E-6,2.0037E-5,3.2203E-5,4.67E-6,2.2987E-5,1.3363E-5,2.4397E-5,2.7033E-5,1.2187E-5,2.902E-5,9.8267E-6,1.2467E-5,1.9357E-5,-3.22E-6,2.4767E-5,6.01E-6,2.527E-5,3.3507E-5,1.0943E-5,2.797E-5,0.0021999,0.013203,0.013517,0.01196,0.009732,0.010823,0.012733,0.013642,0.011795,0.0099403,0.010701,0.012801,0.01365,0.011763,0.0099597,0.010687,0.012813,0.013684,0.011794,0.0099993,0.010715,0.012827,0.01368,0.011769,0.0099846,0.010701,0.012786,0.013683,0.011725,0.0099617,0.010693,0.012803,0.013707,0.011759,0.0099877,0.010707,0.012834,0.013694,0.011727,0.0099629,0.010689,0.01281,0.013675,0.011732,0.009982,0.010702,0.012811,0.013662,0.011712,0.0099487,0.010699,0.01283,0.013685,0.011709,0.0099439,0.010663,0.012773,0.01365,0.011698,0.0099516,0.010685,0.012767,0.013648,0.011671,0.0099362,0.010677,0.012773,0.013629,0.01164,0.0099352,0.010668,0.012794,0.013642,0.011608,0.0099056,0.010658,0.012799,0.013583,0.011593,0.0099048,0.010642,0.012751,0.013569,0.011588,0.0098975,0.010647,0.012746,0.013554,0.011586,0.009873,0.010634,0.012715,0.013549,0.011572,0.0098577,0.010608,0.012699,0.013551,0.011561,0.0098345,0.010613,0.012658,0.013501,0.011489,0.009823,0.010599,0.012622,0.013494,0.011486,0.0098148,0.010567,0.012646,0.013507,0.011435,0.0097932,0.010573,0.012632,0.013478,0.011442,0.0097911,0.010529,0.012636,0.013464,0.011406,0.0097708,0.010536,0.012595,0.013429,0.011394,0.0097402,0.010516,0.012592,0.013377,0.011353,0.0097307,0.010491,0.012595,0.013377,0.011343,0.0097286,0.010501,0.012556,0.013365,0.011333,0.009706,0.010497,0.012543,0.013364,0.011316,0.0096958,0.010512,0.012531,0.013375,0.011314,0.0096768,0.010485,0.012545,0.013325,0.011304:2
5.33E-6,7.1667E-7,5.7767E-6,4.9167E-6,2.5767E-6,5.5133E-6,1.4233E-6,5.6733E-6,3.4633E-6,2.3933E-6,5.5667E-6,1.8667E-7,5.3633E-6,4.4033E-6,2.0833E-6,6.06E-6,3.5667E-7,6.13E-6,3.34E-6,4.3833E-6,4.67E-6,1.7667E-7,4.1767E-6,3.6233E-6,2.4533E-6,4.9667E-6,2.7E-7,4.5167E-6,4.0816E-4,9.9747E-4,7.2495E-4,7.7019E-4,8.1945E-4,9.7551E-4,9.4732E-4,7.4643E-4,7.4279E-4,8.3132E-4,9.7264E-4,9.4618E-4,7.5125E-4,7.3973E-4,8.3435E-4,9.7457E-4,9.4696E-4,7.5593E-4,7.3632E-4,8.3105E-4,9.7247E-4,9.4823E-4,1.6598E-4,-6.0093E-5,3.294E-5,-8.6267E-6,3.7467E-6,6.1267E-6,2.3333E-7,5.3267E-6,3.5167E-6,3.5833E-6,4.9533E-6,-1.7333E-7,3.3627E-5,0.0013273,0.001238,0.0010643,9.313E-4,0.0010709,0.0012627,0.0012594,0.0010359,9.6332E-4,0.0010532,0.0012679,0.0012624,0.0010291,9.6943E-4,0.0010493,0.0012672,0.0012628,0.001031,9.6913E-4,0.0010513,0.0012689,0.0012616,0.0010323,9.7009E-4,0.0010462,0.0012673,0.0012659,0.0010332,9.6917E-4,0.0010441,0.0012677,0.0012651,0.0010321,9.7108E-4,0.0010426,0.0012664,0.0012671,0.0010352,9.7129E-4,0.0010439,0.0012671,0.001267,0.0010332,9.6867E-4,0.0010425,0.0012635,0.0012625,0.0010372,9.6775E-4,0.0010384,0.0012613,0.0012662,0.0010361,9.685E-4,0.0010372,0.0012603,0.0012637,0.0010378,9.6982E-4,0.0010376,0.0012647,0.0012626,0.0010394,9.688E-4,0.0010333,0.00126,0.0012638,0.0010386,9.6594E-4,0.0010326,0.00126,0.0012697,0.0010371,9.6788E-4,0.0010312,0.0012629,0.0012668,0.0010435,9.6869E-4,0.0010309,0.0012617,0.00127,0.001043,9.6694E-4,0.0010296,0.0012599,0.0012653,0.0010429,9.6843E-4,0.0010269,0.0012559,0.0012633,0.0010459,9.6758E-4,0.0010284,0.0012514,0.0012668,0.0010433,9.6551E-4,0.0010242,0.0012551,0.0012627,0.0010472,9.6557E-4,0.0010227,0.001255,0.0012651,0.0010473,9.6472E-4,0.0010241,0.0012503,0.0012673,0.0010478,9.6175E-4,0.0010203,0.0012466,0.001265,0.0010447,9.6253E-4,0.0010201,0.0012485,0.0012648,0.0010473,9.6241E-4,0.0010174,0.0012496,0.0012617,0.0010497,9.6038E-4,0.0010174,0.0012467,0.0012636,0.0010491,9.6126E-4,0.0010133,0.0012464,0.0012661,0.0010508,9.6242E-4,0.001013,0.001245,0.0012658,0.0010542,9.6276E-4,0.0010105,0.0012431,0.0012637,0.0010563,9.6441E-4,0.0010072,0.0012419,0.0012644,0.0010516,9.6265E-4,0.0010071,0.001243,0.0012656,0.0010537,9.5817E-4,0.001008,0.0012408,0.0012623,0.0010569,9.6201E-4,0.001003,0.001239,0.0012612,0.001054,9.592E-4,0.0010038,0.0012383,0.0012603,0.0010546,9.5923E-4,0.0010012,0.0012335,0.0012656,0.0010555,9.5884E-4,0.0010003,0.0012358,0.0012628,0.001055,9.5768E-4,0.0010011,0.0012341,0.0012625,0.0010598,9.5826E-4,9.9579E-4,0.0012354,0.001257,0.0010595,9.5736E-4,9.9818E-4,0.001232,0.0012628,0.0010613,9.597E-4,9.9309E-4,0.0012289,0.0012641,0.0010608,9.5595E-4,9.9159E-4,0.0012299,0.0012605,0.0010571,9.5866E-4,9.896E-4,0.0012286,0.0012635,0.0010607,9.5768E-4,9.908E-4,0.0012256,0.0012586,0.001064,9.5918E-4,9.8683E-4,0.0012268,0.0012636,0.001065,9.5894E-4,9.8891E-4,0.0012253,0.0012591,0.0010628,9.5652E-4,9.8655E-4,0.0012263,0.0012592,0.0010669,9.5634E-4,9.8682E-4,0.0012237,0.0012596,0.001067,9.5567E-4,9.8446E-4,0.0012225,0.0012591,0.0010653,9.5831E-4,9.8192E-4,0.0012209,0.0012555,0.0010677,9.5756E-4,9.7913E-4,0.001222,0.001262,0.0010718,9.5939E-4,9.8165E-4,0.0012172,0.0012593,0.001071,9.5743E-4,9.7787E-4,0.001219,0.001257,0.0010693,9.5991E-4,9.7798E-4,0.0012179,0.0012567,0.001073,9.5702E-4,9.7908E-4,0.0012149,0.0012615,0.0010744,9.5876E-4,9.7488E-4,0.0012147,0.0012601,0.0010753,9.5779E-4,9.7199E-4,0.0012122,0.0012604,0.0010741,9.5669E-4,9.7461E-4,0.0012108,0.0012618,0.0010741,9.5824E-4,9.7279E-4,0.0012083,0.0012569,0.0010767,9.5554E-4,9.7311E-4,0.0012113,0.0012586,0.0010766,9.5451E-4,9.7087E-4,0.0012119,0.00126,0.0010786,9.5563E-4,9.6852E-4,0.0012099,0.0012581,0.0010769,9.5523E-4,9.6804E-4,0.0012072,0.0012564,0.0010797,9.5855E-4,9.6646E-4,0.0012025,0.0012564,0.0010787,9.5711E-4,9.6545E-4,0.0012017,0.0012595,0.001079,9.5661E-4,9.6271E-4,0.0012037,0.0012578,0.0010812,9.5787E-4,9.6407E-4,0.0012024,0.0012542,0.00108,9.5844E-4,9.6229E-4,0.0011997,0.0012556,0.0010819,9.5784E-4,9.6255E-4,0.0011986,0.0012525,0.001081,9.6106E-4,9.6072E-4,0.0011963,0.0012557,0.0010834,9.5534E-4,9.5618E-4,0.0011999,0.0012549,0.0010864,9.5823E-4,9.5804E-4,0.0011988,0.0012532,0.001086,9.5706E-4,9.5405E-4,0.0011927,0.0012556,0.0010851,9.5965E-4,9.5619E-4,0.0011933,0.0012567:2
4.6E-6,1.4033E-6,5.65E-6,2.6E-7,5.8967E-6,5.0533E-6,1.6367E-6,5.7933E-6,1.6333E-6,5.88E-6,4.75E-6,2.3567E-6,5.8667E-6,5.0E-7,4.7267E-6,4.45E-6,2.0233E-6,6.0067E-6,1.18E-6,5.75E-6,4.2867E-6,2.5833E-6,6.5772E-4,8.3771E-4,8.9497E-4,9.335E-4,8.5928E-4,6.6571E-4,7.8541E-4,9.0828E-4,9.3711E-4,8.4831E-4,6.7749E-4,7.7769E-4,9.1414E-4,9.3756E-4,8.4756E-4,6.7986E-4,7.7697E-4,9.1195E-4,9.3895E-4,8.452E-4,7.4507E-5,-4.6787E-5,1.9827E-5,3.9333E-7,0.0011475,9.4611E-4,9.7108E-4,0.0011771,0.0012499,0.0011318,9.1966E-4,9.9391E-4,0.001168,0.0012505,0.0011423,9.1113E-4,0.0010005,0.0011656,0.0012542,0.0011406,9.0862E-4,9.9899E-4,0.0011578,0.0012521,0.001143,9.1211E-4,0.0010005,0.0011633,0.0012534,0.0011429,9.118E-4,0.0010015,0.0011663,0.0012522,0.0011431,9.16E-4,9.9807E-4,0.0011663,0.0012484,0.0011417,9.0994E-4,0.0010004,0.0011638,0.0012516,0.0011434,9.104E-4,9.9743E-4,0.0011624,0.0012521,0.0011485,9.1338E-4,9.981E-4,0.0011625,0.0012472,0.0011467,9.1224E-4,9.9709E-4,0.0011654,0.0012482,0.00114,9.117E-4,9.946E-4,0.0011589,0.0012483,0.0011439,9.1217E-4,9.9634E-4,0.0011567,0.0012507,0.0011456,9.1148E-4,9.9611E-4,0.001162,0.0012491,0.0011468,9.1472E-4,9.9581E-4,0.0011574,0.0012471,0.0011443,9.0839E-4,9.9179E-4,0.0011536,0.0012485,0.0011467,9.1413E-4,9.9462E-4,0.0011596,0.0012485,0.0011449,9.1168E-4,9.9169E-4,0.0011575,0.0012449,0.0011439,9.1074E-4,9.9156E-4,0.0011511,0.0012465,0.001145,9.0998E-4,9.9005E-4,0.001157,0.0012484,0.0011477,9.1027E-4,9.9163E-4,0.0011519,0.0012499,0.0011429,9.1027E-4,9.9044E-4,0.001151,0.001242,0.0011452,9.1035E-4,9.9106E-4,0.0011538,0.0012439,0.0011495,9.137E-4,9.8939E-4,0.0011522,0.0012484,0.0011471,9.1294E-4,9.8448E-4,0.0011475,0.0012431,0.0011466,9.112E-4,9.8738E-4,0.0011491,0.0012415,0.0011466,9.0908E-4,9.8761E-4,0.001146,0.0012451,0.0011427,9.0999E-4,9.8845E-4,0.0011479,0.0012436,0.0011431,9.0731E-4,9.843E-4,0.0011433,0.0012408,0.0011443,9.0788E-4,9.8374E-4,0.0011453,0.0012416,0.0011458,9.0891E-4,9.8438E-4,0.0011457,0.0012453,0.0011469,9.0791E-4,9.8147E-4,0.0011433,0.001245,0.0011461,9.0886E-4,9.8207E-4,0.0011427,0.0012411,0.0011441,9.1024E-4,9.7965E-4,0.0011447,0.0012431,0.0011453,9.1154E-4,9.7984E-4,0.001142,0.0012406,0.0011464,9.0809E-4,9.8177E-4,0.0011431,0.0012395,0.0011457,9.0649E-4,9.7887E-4,0.0011393,0.0012397,0.0011443,9.0841E-4,9.8133E-4,0.0011402,0.0012423,0.0011425,9.0883E-4,9.7674E-4,0.0011382,0.0012396,0.001145,9.0769E-4,9.7922E-4,0.0011408,0.0012342,0.0011438,9.0587E-4,9.7964E-4,0.0011353,0.001237,0.0011419,9.067E-4,9.7781E-4,0.0011365,0.0012375,0.0011446,9.0779E-4,9.7633E-4,0.0011342,0.0012376,0.0011454,9.0624E-4,9.7671E-4,0.001134,0.0012367,0.0011456,9.0947E-4,9.7524E-4,0.0011303,0.0012389,0.001144,9.0801E-4,9.7451E-4,0.0011328,0.0012346,0.0011457,9.0865E-4,9.7241E-4,0.0011298,0.0012334,0.0011457,9.0551E-4,9.6998E-4,0.0011279,0.0012364,0.0011429,9.0554E-4,9.7225E-4,0.0011297,0.0012383,0.0011488,9.0573E-4,9.7024E-4,0.0011267,0.0012331,0.001147,9.0928E-4,9.6952E-4,0.0011294,0.0012306,0.0011404,9.0757E-4,9.6789E-4,0.0011279,0.0012317,0.0011454,9.0476E-4,9.694E-4,0.0011232,0.0012326,0.0011421,9.0544E-4,9.6859E-4,0.001124,0.0012327,0.0011451,9.0613E-4,9.6784E-4,0.0011249,0.0012312,0.0011441,9.0404E-4,9.7015E-4,0.0011252,0.001229,0.0011442,9.0423E-4,9.6682E-4,0.0011176,0.0012309,0.0011415,9.0775E-4,9.6724E-4,0.0011226,0.0012323,0.0011429,9.0767E-4,9.6533E-4,0.001123,0.0012306,0.0011436,9.0753E-4,9.6609E-4,0.0011191,0.0012276,0.0011462,9.0263E-4,9.6686E-4,0.0011168,0.0012336,0.0011434,9.0669E-4,9.6673E-4,0.001121,0.0012282,0.0011422,9.0696E-4,9.6149E-4,0.0011136,0.0012321,0.0011425,9.0603E-4,9.6226E-4,0.0011136,0.0012301,0.001144,9.0509E-4,9.6214E-4,0.0011165,0.0012273,0.0011453,9.0268E-4,9.6046E-4,0.0011142,0.0012315,0.0011436,9.057E-4,9.5938E-4,0.0011157,0.0012273,0.0011435,9.0498E-4,9.5967E-4,0.0011145,0.0012317,0.0011433,9.0867E-4,9.6046E-4,0.001112,0.0012271,0.0011421,9.0667E-4,9.5789E-4,0.0011134,0.0012271,0.001144,9.0654E-4,9.5994E-4,0.0011129,0.001228,0.0011441,9.0633E-4,9.608E-4,0.0011139,0.0012257,0.0011456,9.05E-4,9.6023E-4,0.00111,0.0012299,0.0011446,9.0462E-4,9.6021E-4,0.0011118,0.0012297,0.0011466,9.067E-4,9.5755E-4,0.0011102,0.0012286,0.001147,9.0636E-4,9.5693E-4,0.0011105,0.001227,0.0011429,9.0679E-4,9.6129E-4,0.0011087:2
3.59E-6,3.19E-6,5.1E-6,5.2333E-7,5.7267E-6,5.06E-6,1.7133E-6,5.4933E-6,2.6667E-7,5.7967E-6,3.69E-6,1.8267E-6,5.1067E-6,1.0E-6,4.84E-6,5.0467E-6,4.28E-6,4.6067E-6,4.5E-7,5.53E-6,3.65E-6,2.56E-6,5.3567E-6,6.1667E-7,5.23E-6,3.6333E-6,3.7433E-6,5.5E-6,-3.2E-7,5.0033E-6,3.6833E-6,3.5067E-6,4.9633E-6,1.17E-6,6.27E-6,3.0167E-6,3.2433E-6,4.3967E-6,1.98E-6,5.2933E-6,4.9433E-6,3.6533E-6,4.2067E-6,9.2667E-7,5.52E-6,4.6767E-6,3.0433E-6,4.1933E-6,1.1167E-6,5.3867E-6,3.19E-6,3.3033E-6,4.51E-6,-8.4667E-7,5.0267E-6,4.1733E-6,2.6033E-6,4.7467E-6,1.3333E-8,5.0967E-6,5.2E-6,1.4033E-6,5.3467E-6,8.3667E-7,5.6067E-6,3.1133E-6,2.28E-6,5.21E-6,1.9067E-6,4.9533E-6,3.5467E-6,2.27E-6,4.5367E-6,1.9033E-6,6.02E-6,3.9433E-6,2.6933E-6,5.27E-6,7.3667E-7,5.4433E-6,4.5467E-6,1.9633E-6,4.9933E-6,1.2833E-6,4.2367E-6,3.21E-6,3.67E-6,4.7967E-6,4.2E-7,5.1667E-6,5.3033E-6,1.9233E-6,4.2633E-6,8.4E-7,4.66E-6,3.9433E-6,3.15E-6,4.71E-6,1.39E-6,5.3067E-6,3.7367E-6,2.7867E-6,5.4633E-6,1.3133E-6,5.8267E-6,6.2867E-6,2.9333E-6,5.64E-6,9.5E-7,5.2667E-6,4.26E-6,3.3867E-6,6.8533E-6,3.7E-7,5.9E-7,4.3633E-6,2.0367E-6,4.7733E-6,1.13E-6,5.42E-6,3.74E-6,2.7767E-6,5.0167E-6,8.9E-7,4.3E-6,4.3467E-6,2.9667E-7,4.8733E-6,-7.7667E-7,4.9467E-6,4.6033E-6,1.0767E-6,5.3833E-6,2.3667E-6,5.2667E-6,4.1533E-6,3.15E-6,6.4167E-6,7.5333E-7,4.3467E-6,4.7867E-6,4.1567E-6,3.9167E-6,1.1667E-6,5.9E-6,3.5433E-6,2.2533E-6,5.0467E-6,1.3733E-6,4.8367E-6,4.0933E-6,4.04E-6,4.88E-6,1.1833E-6,4.7867E-6,4.0267E-6,2.6333E-6,5.1933E-6,1.1267E-6,5.7467E-6,4.03E-6,3.5633E-6,5.37E-6,5.4667E-7,6.4433E-6,2.8367E-6,3.36E-6,5.41E-6,6.5667E-7,5.6333E-6,3.7933E-6,2.0733E-6,4.7667E-6,2.6333E-7,6.5867E-6,4.64E-6,3.0267E-6,5.37E-6,5.9333E-7,4.6867E-6,3.7433E-6,4.0867E-6,4.26E-6,1.17E-6,6.4733E-6,2.77E-6,3.6233E-6,5.6367E-6,1.8333E-7,5.38E-6,3.9933E-6,2.8467E-6,5.3E-6,1.3767E-6,5.9333E-6,5.08E-6,3.7467E-6,3.8967E-6,4.1233E-6,5.8433E-6,4.52E-6,4.4467E-6,5.63E-6,2.2E-6,5.72E-6,4.8167E-6,4.78E-6,5.8167E-6,5.4667E-7,7.45E-6,4.4633E-6,2.5967E-6,8.6233E-6,2.81E-6,5.8E-6,2.13E-6,4.3933E-6,4.9367E-6,-8.3333E-8,5.24E-6,6.55E-6,4.8633E-6,7.34E-6,1.22E-6,2.8567E-6,5.08E-6,1.5767E-6,4.2067E-6,-3.2E-7,6.3533E-6,4.1467E-6,3.14E-6,4.2367E-6,6.6E-7,4.49E-6,2.6433E-6,3.41E-6,5.7333E-6,1.5533E-6,5.07E-6,3.27E-6,1.9367E-6,5.1067E-6,1.24E-6,5.5367E-6,2.5333E-6,2.79E-6,5.3567E-6,2.0E-7,5.8867E-6,3.8033E-6,3.0133E-6,4.7533E-6,2.23E-6,4.56E-6,3.2E-6,2.09E-6,5.0567E-6,-4.0333E-7,6.0067E-6,4.4867E-6,8.8667E-7,6.53E-6,7.2333E-7,5.3433E-6,3.54E-6,2.3E-6,6.1033E-6,2.8E-7,5.1533E-6,3.6133E-6,3.6733E-6,4.4667E-6,1.64E-6,6.51E-6,3.87E-6,2.8567E-6,4.7633E-6,1.3033E-6,5.1567E-6,5.2E-6,4.0633E-6,3.9033E-6,1.3E-6,5.2933E-6,4.3433E-6,3.1967E-6,4.82E-6,7.3667E-7,4.5767E-6,4.5933E-6,2.3833E-6,5.5367E-6,7.7E-7,4.9867E-6,3.2533E-6,2.1233E-6,4.0E-6,6.5667E-7,5.0233E-6,3.8967E-6,2.4E-6,4.9733E-6,8.3333E-7,6.6833E-6,2.7133E-6,3.29E-6,5.2767E-6,8.0E-7,5.8967E-6,4.0933E-6,2.86E-6,5.0467E-6,1.0467E-6,5.45E-6,3.43E-6,3.0633E-6,5.1267E-6,4.0E-8,4.9667E-6,3.8033E-6,2.7867E-6,4.62E-6,4.4E-7,5.2767E-6,2.95E-6,1.66E-6,4.9E-6,9.4333E-7,5.83E-6,1.64E-6,1.7E-6,4.74E-6,1.7733E-6,5.1233E-6,3.3967E-6,2.4133E-6,4.35E-6,-2.1E-7,5.91E-6,4.4733E-6,2.06E-6,5.3867E-6,1.51E-6,4.8419E-4,9.4196E-4,8.8566E-4,7.1923E-4,7.1302E-4,8.5277E-4,9.4084E-4,8.9859E-4,7.0732E-4,7.2461E-4,8.4648E-4,4.5351E-4,-6.7333E-6,8.43E-6,-9.1667E-7,8.0553E-4,0.0012421,0.001204,9.5617E-4,9.5058E-4,0.0010649,0.001244,0.0012076,9.5961E-4,9.5129E-4,0.0010671,0.0012458,0.0012108,9.5984E-4,9.516E-4,0.0010675,0.001243,0.0012064,9.5739E-4,9.5381E-4,0.0010689,0.0012447,0.0012096,9.6153E-4,9.566E-4,0.0010727,0.0012459,0.0012099,9.6418E-4,9.5462E-4,0.0010713,0.0012477,0.0012113,9.5968E-4,9.5597E-4,0.0010737,0.0012481,0.0012129,9.6368E-4,9.5537E-4,0.0010693,0.0012478,0.001211,9.6355E-4,9.5777E-4,0.0010722,0.0012504,0.001212,9.6345E-4,9.5211E-4,0.0010666,0.0012468,0.0012093,9.6332E-4,9.5075E-4,0.0010688,0.0012484,0.0012091,9.6068E-4,9.5202E-4,0.0010686,0.0012464,0.0012087,9.6546E-4,9.4972E-4,0.0010663,0.0012437,0.0012071,9.6592E-4,9.516E-4,0.0010676,0.0012436,0.0012115,9.6649E-4,9.476E-4,0.0010687,0.0012458,0.0012074,9.6597E-4,9.5034E-4,0.0010661,0.0012453,0.001209,9.6444E-4,9.5391E-4,0.0010663,0.0012451,0.0012107,9.6514E-4,9.5213E-4,0.0010662,0.0012449,0.0012098,9.6324E-4,9.4698E-4,0.0010659,0.0012454,0.001207,9.6162E-4,9.4971E-4,0.0010623,0.0012465,0.0012106,9.6405E-4,9.4876E-4,0.0010582,0.0012435,0.0012134,9.612E-4,9.499E-4,0.0010637,0.0012362,0.0012058,9.6321E-4,9.474E-4,0.001061,0.001243,0.0012048,9.6098E-4,9.4754E-4,0.001058,0.001241,0.0012041,9.6141E-4,9.4635E-4,0.0010602,0.0012403,0.0012074,9.6221E-4,9.4861E-4,0.0010605,0.0012418,0.001208,9.6177E-4,9.4907E-4,0.0010597,0.0012423,0.0012054,9.6045E-4,9.431E-4,0.0010582,0.0012414,0.0012047,9.6337E-4,9.4649E-4,0.0010578,0.0012425,0.0012039,9.664E-4,9.4215E-4,0.0010559,0.0012398,0.001205,9.6382E-4,9.4278E-4,0.0010549,0.0012387,0.0012065,9.634E-4,9.439E-4,0.0010562,0.0012365,0.0012044,9.6454E-4,9.4096E-4,0.0010515,0.0012403,0.0012051,9.6189E-4,9.4336E-4,0.0010576,0.0012352,0.0012056,9.6435E-4,9.4179E-4,0.0010512,0.0012344,0.0012058,9.6244E-4,9.3896E-4,0.0010527,0.0012396,0.0012055,9.6369E-4,9.4252E-4,0.0010521,0.0012354,0.0012053,9.656E-4,9.4563E-4,0.0010507,0.0012348,0.0011971,9.6379E-4,9.3975E-4,0.0010466,0.00123,0.0012047,9.6117E-4,9.4242E-4,0.001047,0.001229,0.0011989,9.6081E-4,9.4069E-4,0.001043,0.0012328,0.0011988,9.6286E-4,9.3976E-4,0.00105,0.0012316,0.0011994,9.6142E-4,9.3974E-4,0.0010461,0.0012306,0.0012034,9.6025E-4,9.3512E-4,0.0010447,0.001233,0.0012002,9.6474E-4,9.3994E-4,0.0010447,0.0012273,0.0012029,9.6368E-4,9.3512E-4,0.0010444,0.0012268,0.0012012,9.6112E-4,9.3497E-4,0.0010429,0.0012259,0.0012017,9.6257E-4,9.3536E-4,0.0010396,0.0012302,0.001201,9.5992E-4,9.3675E-4,0.0010404,0.0012274,0.0012002,9.6221E-4,9.3417E-4,0.0010387,0.0012244,0.0012021,9.5978E-4,9.3477E-4,0.0010381,0.0012252,0.0012012,9.624E-4,9.3593E-4,0.0010374,0.0012234,0.0011973,9.5815E-4,9.3366E-4,0.0010352,0.0012271,0.0011971,9.5978E-4,9.3391E-4,0.0010359,0.0012257,0.0011997,9.5817E-4,9.3682E-4,0.0010354,0.001221,0.0011986,9.6296E-4,9.3432E-4,0.0010327,0.0012222,0.0011975,9.591E-4,9.3045E-4,0.0010284,0.0012208,0.0011957,9.5891E-4,9.2774E-4,0.0010307,0.0012205,0.0011926,9.5938E-4,9.285E-4,0.0010317,0.001217,0.0011968,9.5932E-4,9.2903E-4,0.0010309,0.0012168,0.0011946,9.5762E-4,9.3118E-4,0.0010242,0.0012184,0.0011957,9.5969E-4,9.2896E-4,0.0010293,0.0012185,0.0011944,9.5742E-4,9.279E-4,0.0010278,0.0012179,0.0012008,9.606E-4,9.2853E-4,0.0010268,0.0012158,0.0011976,9.6053E-4,9.2705E-4,0.0010256,0.0012193,0.0011934,9.6101E-4,9.2705E-4,0.0010265,0.0012112,0.0011944,9.6208E-4,9.2634E-4,0.0010276,0.0012175,0.001197,9.6376E-4,9.2677E-4,0.0010278,0.001216,0.0011927,9.5782E-4,9.2547E-4,0.0010249,0.0012153,0.0011953,9.5911E-4,9.2505E-4,0.0010247,0.001217,0.0011957,9.6E-4,9.2521E-4,0.0010249,0.0012159,0.0011957,9.6011E-4,9.2655E-4,0.0010198,0.0012166,0.001194,9.5931E-4,9.2875E-4,0.0010198,0.0012186,0.0011987,9.6196E-4,9.253E-4,0.0010187,0.0012146,0.0011947,9.6043E-4,9.257E-4,0.0010197,0.0012132,0.0011905,9.5895E-4,9.2295E-4,0.001022,0.0012146,0.0011938,9.6142E-4,9.2359E-4,0.001019,0.0012117,0.0011967,9.6024E-4,9.2279E-4,0.0010163,0.0012153,0.0011937,9.6081E-4,9.2275E-4,0.0010169,0.0012126,0.0011917,9.6348E-4,9.2258E-4,0.001017,0.0012103,0.0011939,9.6059E-4,9.2496E-4,0.0010122,0.0012111,0.0011945,9.6194E-4,9.2043E-4,0.0010153,0.0012096,0.0011915,9.5836E-4,9.2263E-4,0.0010151,0.001207,0.001194,9.604E-4,9.2004E-4,0.0010158,0.0012085,0.0011905,9.5921E-4,9.2299E-4,0.0010131,0.0012098,0.0011922,9.6038E-4,9.2241E-4,0.0010135,0.0012062,0.001192,9.604E-4,9.2038E-4,0.0010138,0.0012066,0.001192,9.6124E-4,9.2041E-4,0.0010111,0.0012073,0.0011918,9.6086E-4,9.2061E-4,0.0010129,0.0012078,0.0011934,9.5859E-4,9.2087E-4,0.0010055,0.001206,0.0011927,9.6013E-4,9.2059E-4,0.0010097,0.0012061,0.0011913,9.6255E-4,9.2138E-4,0.0010086,0.0012064,0.0011926,9.6392E-4,9.1836E-4,0.0010052,0.0012039,0.0011942,9.6521E-4,9.1785E-4,0.0010045,0.0012056,0.0011889,9.6317E-4,1.6201E-4:2
4.7E-7,2.4167E-6,5.4E-7,3.69E-6,1.6667E-6,2.3233E-6,2.3467E-6,-1.6E-6,-6.0E-8,-3.0967E-6,-5.0533E-6,1.31E-6,3.0667E-7,2.3833E-6,-1.3E-7,-1.02E-6,3.9833E-6,-5.6667E-7,1.0967E-6,4.22E-6,1.6099E-4,6.5212E-4,6.6022E-4,7.2634E-4,8.3157E-4,8.0792E-4,6.0936E-4,6.4363E-4,7.4021E-4,8.3074E-4,7.9739E-4,6.1536E-4,6.4011E-4,7.416E-4,8.3328E-4,8.0356E-4,6.148E-4,6.3861E-4,7.405E-4,8.3209E-4,8.0344E-4,6.2022E-4,6.3962E-4,7.4406E-4,8.3455E-4,8.031E-4,6.1994E-4,6.3651E-4,7.4552E-4,8.3436E-4,8.0211E-4,6.1878E-4,6.3711E-4,7.4153E-4,8.3464E-4,8.0183E-4,6.1711E-4,6.3578E-4,7.4342E-4,8.3543E-4,8.0556E-4,6.1966E-4,6.3516E-4,7.4185E-4,8.3457E-4,8.0736E-4,6.2426E-4,6.3766E-4,7.4487E-4,8.3466E-4,8.0725E-4,6.2056E-4,6.3833E-4,7.4064E-4,8.3567E-4,8.0701E-4,6.2182E-4,6.3926E-4,7.4107E-4,8.3252E-4,8.0539E-4,6.2355E-4,6.3698E-4,7.4037E-4,8.3731E-4,8.0885E-4,6.2239E-4,6.3873E-4,7.411E-4,8.3838E-4,8.0768E-4,6.2471E-4,6.3828E-4,7.3921E-4,8.3513E-4,8.0654E-4,6.2354E-4,6.3669E-4,7.3895E-4,8.3348E-4,8.0862E-4,6.2306E-4,6.3539E-4,7.3844E-4,8.3698E-4,8.0977E-4,6.259E-4,6.4142E-4,7.4057E-4,8.3863E-4,8.0878E-4,6.2157E-4,6.3761E-4,7.3917E-4,8.3662E-4,8.0816E-4,6.2006E-4,6.3455E-4,7.3915E-4,8.353E-4,8.0593E-4,6.2319E-4,6.3703E-4,7.3792E-4,8.3463E-4,8.094E-4,6.2415E-4,6.3526E-4,7.3593E-4,8.3691E-4,8.0951E-4,6.2325E-4,6.3496E-4,7.3688E-4,8.3597E-4,8.0797E-4,6.2288E-4,6.3893E-4,7.3823E-4,8.362E-4,8.1155E-4,6.2523E-4,6.3592E-4,7.3702E-4,8.3598E-4,8.1141E-4,6.2461E-4,6.3359E-4,7.3647E-4,8.3564E-4,8.0963E-4,6.2493E-4,6.3538E-4,7.3882E-4,8.3784E-4,8.0952E-4,6.2662E-4,6.3507E-4,7.3357E-4,8.3306E-4,8.086E-4,6.2204E-4,6.3458E-4,7.3626E-4,8.369E-4,8.0843E-4,6.2535E-4,6.3634E-4,7.364E-4,8.341E-4,8.0903E-4,6.2577E-4,6.323E-4,7.3556E-4,8.3457E-4,8.0747E-4,6.2509E-4,6.3616E-4,7.3701E-4,8.3222E-4,8.1343E-4,6.2547E-4,6.3379E-4,7.3633E-4,8.3328E-4,8.1062E-4,6.2564E-4,6.3494E-4,7.3187E-4,8.3233E-4,8.1257E-4,6.2079E-4,6.3497E-4,7.349E-4,8.3665E-4,8.11E-4,6.2441E-4,6.3383E-4,7.312E-4,8.3258E-4,8.0909E-4,6.2289E-4,6.3323E-4,7.3354E-4,8.3114E-4,8.1111E-4,6.2446E-4,6.3062E-4,7.3208E-4,8.318E-4,8.0584E-4,6.24E-4,6.3147E-4,7.2909E-4,8.3147E-4,8.0864E-4,6.2296E-4,6.344E-4,7.3006E-4,8.3187E-4,8.1118E-4,6.2227E-4,6.3174E-4,7.2926E-4,8.3022E-4,8.0512E-4,6.2346E-4,6.3003E-4,7.3055E-4,8.3234E-4,8.0888E-4,6.2085E-4,6.3029E-4,7.3013E-4,8.2704E-4,8.0716E-4,6.2221E-4,6.2845E-4,7.2936E-4,8.2742E-4,8.0938E-4,6.2403E-4,6.3066E-4,7.3025E-4,8.2748E-4,8.0381E-4,6.204E-4,6.29E-4,7.2592E-4,8.2759E-4,8.0727E-4,6.2045E-4,6.2783E-4,7.2617E-4,8.2684E-4,8.0822E-4,6.2124E-4,6.2829E-4,7.2415E-4,8.2409E-4,8.0703E-4,6.2011E-4,6.2724E-4,7.2628E-4,8.2625E-4,8.0854E-4,6.2164E-4,6.2772E-4,7.2347E-4,8.2622E-4,8.0131E-4,6.2173E-4,6.2732E-4,7.2561E-4,8.2862E-4,8.0534E-4,6.2365E-4,6.248E-4,7.2277E-4,8.2452E-4,8.0389E-4,6.2211E-4,6.269E-4,7.2329E-4,8.2751E-4,8.0654E-4,6.2261E-4,6.2639E-4,7.2371E-4,8.2585E-4,8.0304E-4,6.2085E-4,6.2469E-4,7.2185E-4,8.2862E-4,8.0514E-4,6.2217E-4,6.2285E-4,7.2111E-4,8.2406E-4,8.0329E-4,6.2126E-4,6.2242E-4,7.2007E-4,8.2545E-4,8.0423E-4,6.2328E-4,6.2056E-4,7.0924E-4,8.1248E-4,7.9656E-4,6.1717E-4,6.1868E-4,7.1856E-4,8.2262E-4,8.0171E-4,6.1852E-4,6.1948E-4,7.1609E-4,8.2066E-4,8.0003E-4,6.1911E-4,6.1884E-4,7.174E-4,8.2024E-4,8.0042E-4,6.1816E-4,6.1957E-4,7.1696E-4,8.2193E-4,8.0082E-4,6.1767E-4,6.1982E-4,7.1608E-4,8.1831E-4,8.0325E-4,6.1831E-4,6.2119E-4,7.1393E-4,8.1721E-4,8.0255E-4,6.1709E-4,6.2054E-4,7.1414E-4,8.1956E-4,8.012E-4,6.1819E-4,6.2015E-4,7.1184E-4,8.1875E-4,8.0053E-4,6.1928E-4,6.182E-4,7.1439E-4,8.1857E-4,7.9864E-4,6.1839E-4,6.1627E-4,7.1354E-4,8.1982E-4,8.0331E-4,6.2029E-4,6.1826E-4,7.1145E-4,8.1562E-4,7.9525E-4,6.1907E-4,6.1735E-4,7.1183E-4,8.1667E-4,8.0104E-4,6.1879E-4,6.1794E-4,7.0964E-4,8.1434E-4,7.9915E-4,6.196E-4,6.1664E-4,7.1379E-4,8.1607E-4,8.0115E-4,6.1857E-4,6.1664E-4,7.0995E-4,8.1399E-4,8.0021E-4,6.1786E-4,6.179E-4,7.1137E-4,8.1725E-4,8.003E-4,6.1808E-4,6.1836E-4,7.0999E-4,8.1635E-4,8.0061E-4,3.8696E-4:2
6.3333E-8,1.8167E-6,-7.8667E-7,3.0233E-6,-4.8333E-7,2.1167E-6,3.7633E-6,-8.6E-7,4.2133E-6,1.7E-6,-1.61E-6,1.6833E-6,-3.4333E-7,2.39E-6,1.9E-7,7.4733E-6,1.0E-8,-4.09E-6,2.6833E-6,7.0E-8,-4.8333E-7,1.73E-6,-2.0E-7,3.0333E-6,3.5947E-4,8.5706E-4,6.855E-4,6.4594E-4,6.3891E-4,8.0718E-4,8.3839E-4,7.0643E-4,6.2115E-4,6.5328E-4,7.9977E-4,8.3296E-4,7.1005E-4,6.1585E-4,6.5752E-4,7.9895E-4,8.358E-4,7.0993E-4,6.1759E-4,6.5713E-4,7.9886E-4,8.3945E-4,7.107E-4,6.1521E-4,6.582E-4,8.0499E-4,8.3744E-4,7.1226E-4,6.1815E-4,6.5835E-4,8.0458E-4,8.4004E-4,7.1422E-4,6.1539E-4,6.5787E-4,8.0256E-4,8.3912E-4,7.1451E-4,6.1884E-4,6.5547E-4,8.0107E-4,8.3697E-4,7.1266E-4,6.1667E-4,6.5962E-4,8.003E-4,8.3927E-4,7.1826E-4,6.1955E-4,6.5676E-4,8.0068E-4,8.4237E-4,7.1621E-4,6.208E-4,6.5848E-4,8.002E-4,8.4074E-4,7.145E-4,6.2019E-4,6.5449E-4,7.9907E-4,8.4098E-4,7.1689E-4,6.1992E-4,6.5636E-4,7.9959E-4,8.4126E-4,7.1499E-4,6.2026E-4,6.5727E-4,8.009E-4,8.4143E-4,7.2089E-4,6.2025E-4,6.5561E-4,7.9922E-4,8.4115E-4,7.1563E-4,6.1695E-4,6.5359E-4,7.9817E-4,8.425E-4,7.1611E-4,6.2083E-4,6.5599E-4,8.0007E-4,8.4382E-4,7.1752E-4,6.198E-4,6.561E-4,8.0198E-4,8.4072E-4,7.1582E-4,6.1947E-4,6.553E-4,8.0151E-4,8.398E-4,7.1696E-4,6.2016E-4,6.5473E-4,7.9858E-4,8.4346E-4,7.1679E-4,6.1998E-4,6.5445E-4,7.9804E-4,8.4131E-4,7.1957E-4,6.1788E-4,6.5373E-4,7.996E-4,8.4099E-4,7.1591E-4,6.1813E-4,6.5401E-4,7.9514E-4,8.3843E-4,7.1812E-4,6.1892E-4,6.549E-4,7.9595E-4,8.4335E-4,7.1777E-4,6.1538E-4,6.5254E-4,7.9525E-4,8.3929E-4,7.1723E-4,6.1656E-4,6.5159E-4,7.9704E-4,8.3615E-4,7.2051E-4,6.1835E-4,6.5232E-4,7.9389E-4,8.4208E-4,7.1787E-4,6.1568E-4,6.5163E-4,7.9452E-4,8.3715E-4,7.1553E-4,6.1715E-4,6.5098E-4,7.9453E-4,8.3912E-4,7.078E-4,6.1166E-4,6.4442E-4,7.879E-4,8.3779E-4,7.1369E-4,6.1384E-4,6.4766E-4,7.9309E-4,8.357E-4,7.1683E-4,6.125E-4,6.4831E-4,7.9413E-4,8.3922E-4,7.1674E-4,6.1588E-4,6.4788E-4,7.8954E-4,8.3421E-4,7.1524E-4,6.1366E-4,6.4677E-4,7.902E-4,8.3511E-4,7.1898E-4,6.157E-4,6.4717E-4,7.92E-4,8.3476E-4,7.1561E-4,6.141E-4,6.4518E-4,7.9034E-4,8.3275E-4,7.1659E-4,6.1316E-4,6.4424E-4,7.8936E-4,8.3262E-4,7.1757E-4,6.1415E-4,6.4433E-4,7.871E-4,8.3451E-4,7.144E-4,6.1173E-4,6.4444E-4,7.8328E-4,8.3315E-4,7.1865E-4,6.1344E-4,6.4563E-4,7.8577E-4,8.3407E-4,7.1509E-4,6.1265E-4,6.4387E-4,7.8389E-4,8.3649E-4,7.1477E-4,6.1525E-4,6.4192E-4,7.8628E-4,8.3441E-4,7.1584E-4,6.1265E-4,6.4565E-4,7.8453E-4,8.2985E-4,7.1482E-4,6.1211E-4,6.4325E-4,7.8813E-4,8.355E-4,7.1481E-4,6.131E-4,6.397E-4,7.8455E-4,8.2904E-4,7.1452E-4,6.1313E-4,6.4001E-4,7.8468E-4,8.3519E-4,7.1674E-4,6.1317E-4,6.3973E-4,7.8492E-4,8.3014E-4,7.1538E-4,6.0967E-4,6.3811E-4,7.8072E-4,8.2909E-4,7.1656E-4,6.1252E-4,6.3995E-4,7.8473E-4,8.2869E-4,7.1782E-4,6.0953E-4,6.3778E-4,7.816E-4,8.2919E-4,7.1665E-4,6.1014E-4,6.3958E-4,7.8318E-4,8.2729E-4,7.1436E-4,6.0721E-4,6.3706E-4,7.8049E-4,8.2879E-4,7.1631E-4,6.1084E-4,6.3946E-4,7.7976E-4,8.2669E-4,7.1551E-4,6.0774E-4,6.3883E-4,7.8028E-4,8.2958E-4,7.1675E-4,6.0953E-4,6.3603E-4,7.7908E-4,8.2886E-4,7.168E-4,6.0746E-4,6.3544E-4,7.8204E-4,8.2917E-4,7.1646E-4,6.1108E-4,6.343E-4,7.8084E-4,8.2831E-4,7.1444E-4,6.0676E-4,6.3508E-4,7.788E-4,8.2416E-4,7.1755E-4,6.078E-4,6.3601E-4,7.767E-4,8.2936E-4,7.1574E-4,6.0683E-4,6.3449E-4,7.7863E-4,8.294E-4,7.2028E-4,6.1017E-4,6.3609E-4,7.7873E-4,8.2673E-4,7.1424E-4,6.1002E-4,6.3596E-4,7.8071E-4,8.3183E-4,7.1681E-4,6.1093E-4,6.3605E-4,7.7623E-4,8.2835E-4,7.1707E-4,6.1097E-4,6.3403E-4,7.7889E-4,8.2578E-4,7.1654E-4,6.0842E-4,6.3553E-4,7.7678E-4,8.2718E-4,7.1667E-4,6.0838E-4,6.3526E-4,7.7792E-4,8.2768E-4,7.1942E-4,6.0658E-4,6.3424E-4,7.7575E-4,8.2718E-4,7.1559E-4,6.077E-4,6.3569E-4,7.761E-4,8.2776E-4,7.1775E-4,6.0638E-4,6.3295E-4,7.7326E-4,8.2662E-4,7.1574E-4,6.071E-4,6.3307E-4,7.7551E-4,8.265E-4,7.1555E-4,6.0538E-4,6.3238E-4,7.751E-4,8.2365E-4,7.1683E-4,6.0899E-4,6.335E-4,7.723E-4,8.2732E-4,7.1491E-4,6.0642E-4,6.3268E-4,7.7441E-4,8.2471E-4,7.1576E-4,6.082E-4,6.3031E-4,7.7331E-4,8.227E-4,7.162E-4,6.0587E-4,6.3041E-4,7.7334E-4,8.2459E-4,7.1864E-4,6.0521E-4,6.2894E-4,7.7297E-4,8.2547E-4,7.1522E-4,6.0835E-4,6.3103E-4,7.7099E-4,8.23E-4,7.1522E-4,6.071E-4,6.2778E-4,7.7344E-4,8.2325E-4,7.1755E-4,6.0569E-4,6.3071E-4,7.7157E-4,8.2383E-4,7.1492E-4,6.0567E-4,6.3084E-4,7.7056E-4,8.2597E-4,7.1651E-4,6.0691E-4,6.2725E-4,7.6892E-4,8.2169E-4,7.13E-4,6.0502E-4,6.2732E-4,7.7055E-4,8.2387E-4,7.1215E-4,6.0818E-4,6.2676E-4,7.6935E-4,8.231E-4,7.1413E-4,6.0471E-4,6.2647E-4,7.7122E-4,8.216E-4,7.151E-4,6.041E-4,6.2585E-4,7.7148E-4,8.2336E-4,7.1475E-4,6.0443E-4,6.2637E-4,7.714E-4,8.2239E-4,7.1477E-4,6.0403E-4,6.2729E-4,7.6837E-4,8.1945E-4,7.1528E-4,6.0357E-4,6.2416E-4,7.674E-4,8.1976E-4,7.1526E-4,6.0536E-4,6.2539E-4,7.7066E-4,8.205E-4,7.1235E-4,5.9543E-4,6.1782E-4,7.5703E-4,8.1886E-4,3.5394E-4:2
2.4667E-6,-3.6E-7,3.5367E-6,3.8E-7,2.6667E-7,1.7167E-6,-5.1333E-7,2.26E-6,1.3367E-6,3.05E-6,2.0567E-6,-7.0E-7,2.0067E-6,-1.3E-7,1.0E-7,1.4267E-6,1.3333E-8,3.0033E-6,1.15E-6,1.38E-6,4.6927E-4,4.5592E-4,5.6152E-4,6.4372E-4,6.1721E-4,5.0628E-4,4.5361E-4,5.6518E-4,6.4009E-4,6.1585E-4,5.0983E-4,4.5058E-4,5.6624E-4,6.4448E-4,6.1996E-4,5.1534E-4,4.5238E-4,5.6314E-4,6.4431E-4,6.2306E-4,5.1464E-4,4.5316E-4,5.6345E-4,6.4437E-4,6.2391E-4,5.2117E-4,4.5217E-4,5.63E-4,6.4659E-4,6.2553E-4,5.2E-4,4.52E-4,5.5598E-4,6.4125E-4,6.2301E-4,5.2051E-4,4.4872E-4,5.5474E-4,6.3796E-4,6.2084E-4,5.2231E-4,4.4826E-4,5.5089E-4,6.4075E-4,6.2467E-4,5.2595E-4,4.4939E-4,5.4823E-4,6.4163E-4,6.2549E-4,5.2736E-4,4.4859E-4,5.4834E-4,6.4134E-4,6.2622E-4,5.2932E-4,4.4765E-4,5.4773E-4,6.4105E-4,6.2583E-4,5.3231E-4,4.4779E-4,5.4609E-4,6.4017E-4,6.2846E-4,5.3615E-4,4.4743E-4,5.4313E-4,6.3608E-4,6.2314E-4,5.3136E-4,4.4411E-4,5.378E-4,6.3347E-4,6.2909E-4,5.3769E-4,4.4548E-4,5.3886E-4,6.3391E-4,6.2924E-4,5.4036E-4,4.4626E-4,5.3904E-4,6.3494E-4,6.2905E-4,5.4142E-4,4.4276E-4,5.3408E-4,6.3313E-4,6.3155E-4,5.4507E-4,4.4279E-4,5.3359E-4,6.3158E-4,6.326E-4,5.4674E-4,4.4486E-4,5.3403E-4,6.3152E-4,6.3372E-4,5.4775E-4,4.4389E-4,5.3188E-4,6.2967E-4,6.3427E-4,5.514E-4,4.4451E-4,5.2973E-4,6.2956E-4,6.3655E-4,5.5415E-4,4.4498E-4,5.2644E-4,6.2932E-4,6.3628E-4,5.591E-4,4.4796E-4,5.2954E-4,6.2935E-4,6.3899E-4,5.6311E-4,4.4856E-4,5.329E-4,6.2917E-4,6.4384E-4,5.639E-4,4.4862E-4,5.288E-4,6.2908E-4,6.4149E-4,5.6741E-4,4.4873E-4,5.2721E-4,6.2814E-4,6.4381E-4,5.6967E-4,4.4781E-4,5.2587E-4,6.2699E-4,6.4532E-4,5.6831E-4,4.4919E-4,5.2446E-4,6.2605E-4,6.4672E-4,5.7328E-4,4.5013E-4,5.2274E-4,6.2453E-4,6.4814E-4,5.7186E-4,4.4993E-4,5.2068E-4,6.2476E-4,6.4728E-4,5.7767E-4,4.5222E-4,5.1916E-4,6.2145E-4,6.4823E-4,5.8145E-4,4.5208E-4,5.1676E-4,6.1952E-4,6.4938E-4,5.8217E-4,4.5174E-4,5.151E-4,6.1964E-4,6.5068E-4,5.8407E-4,4.5428E-4,5.1416E-4,6.1668E-4,6.4868E-4,5.8521E-4,4.5338E-4,5.1358E-4,6.183E-4,6.5013E-4,5.8729E-4,4.517E-4,5.1406E-4,6.1258E-4,6.5224E-4,5.8985E-4,4.5417E-4,5.0844E-4,6.1183E-4,6.5072E-4,5.9016E-4,4.553E-4,5.0988E-4,6.0969E-4,6.504E-4,5.9208E-4,4.5313E-4,5.0816E-4,6.0725E-4,6.5108E-4,5.9453E-4,4.5618E-4,5.0509E-4,6.0487E-4,6.5099E-4,5.9621E-4,4.552E-4,5.0365E-4,6.0356E-4,6.5246E-4,5.972E-4,4.5562E-4,5.0292E-4,6.0198E-4,6.5226E-4,5.976E-4,4.569E-4,4.9908E-4,6.0095E-4,6.5301E-4,5.9841E-4,4.5701E-4,4.9925E-4,5.9939E-4,6.5264E-4,6.0094E-4,4.577E-4,5.0016E-4,5.9831E-4,6.5457E-4,6.0317E-4,4.5944E-4,5.0039E-4,5.9644E-4,6.5369E-4,6.0481E-4,4.6009E-4,4.9688E-4,5.9476E-4,6.5489E-4,6.0631E-4,4.6241E-4,4.9418E-4,5.926E-4,6.5553E-4,6.0523E-4,4.6211E-4,4.9461E-4,5.9214E-4,6.5691E-4,6.0836E-4,4.6374E-4,4.9327E-4,5.9069E-4,6.5507E-4,6.0977E-4,4.6392E-4,4.9141E-4,5.8645E-4,6.5405E-4,6.1002E-4,4.6377E-4,4.8922E-4,5.8673E-4,6.5604E-4,6.1236E-4,4.6529E-4,4.8846E-4,5.8519E-4,6.5146E-4,6.1426E-4,4.6753E-4,4.8833E-4,5.8185E-4,6.5537E-4,6.1169E-4,4.6756E-4,4.872E-4,5.7929E-4,6.5382E-4,6.1604E-4,4.6863E-4,4.8409E-4,5.7876E-4,6.5225E-4,6.1609E-4,4.7053E-4,4.8438E-4,5.7509E-4,6.5237E-4,6.1506E-4,4.7036E-4,4.804E-4,5.7383E-4,6.5452E-4,6.1765E-4,4.7286E-4,4.8008E-4,5.7073E-4,6.5463E-4,6.1911E-4,4.7245E-4,4.8021E-4,5.7052E-4,6.5151E-4,6.202E-4,4.7624E-4,4.793E-4,5.6716E-4,6.5196E-4,6.1985E-4,4.7743E-4,4.7791E-4,5.6242E-4,6.5094E-4,6.1894E-4,4.7711E-4,4.7774E-4,5.6529E-4,6.5189E-4,6.2207E-4,4.7831E-4,4.7534E-4,5.6175E-4,6.5095E-4,6.2011E-4,4.8026E-4,4.7482E-4,5.621E-4,6.4724E-4,6.2351E-4,4.8134E-4,4.735E-4,5.5792E-4,6.4848E-4,6.2624E-4,4.8397E-4,4.7384E-4,5.5553E-4,6.4893E-4,6.2748E-4,4.8651E-4,4.7275E-4,2.7597E-4:2
2.86E-6,2.7667E-7,1.2567E-6,2.6167E-6,-1.0333E-7,2.7833E-6,1.7367E-6,1.8567E-6,1.43E-6,-8.8E-7,2.25E-6,1.9667E-6,1.34E-6,3.9633E-6,1.2133E-6,2.5733E-6,6.9333E-7,1.2767E-6,6.6666E-9,-8.2333E-7,1.9033E-6,9.9E-7,1.5067E-6,1.49E-6,-7.0E-8,2.41E-6,4.2333E-7,1.2233E-6,3.3833E-6,-1.0E-7,1.0856E-4,6.7959E-4,5.7466E-4,4.9837E-4,4.3659E-4,5.6807E-4,6.4279E-4,5.8402E-4,4.9049E-4,4.4604E-4,5.6333E-4,6.4558E-4,5.9023E-4,4.9106E-4,4.4994E-4,5.6435E-4,6.4593E-4,5.9035E-4,4.9459E-4,4.4729E-4,5.636E-4,6.442E-4,5.9369E-4,4.9675E-4,4.4699E-4,5.6384E-4,6.4497E-4,5.9651E-4,5.0059E-4,4.4858E-4,5.6371E-4,6.4522E-4,6.0187E-4,5.029E-4,4.4855E-4,5.595E-4,6.4724E-4,6.0227E-4,5.0139E-4,4.4718E-4,5.5889E-4,6.4309E-4,6.0129E-4,5.0548E-4,4.4636E-4,5.5885E-4,6.4662E-4,6.051E-4,5.0531E-4,4.4597E-4,5.5441E-4,6.4685E-4,6.0561E-4,5.0821E-4,4.4687E-4,5.5456E-4,6.4649E-4,6.0866E-4,5.1086E-4,4.4627E-4,5.5438E-4,6.4313E-4,6.072E-4,5.1416E-4,4.4698E-4,5.5232E-4,6.47E-4,6.1055E-4,5.144E-4,4.4525E-4,5.5195E-4,6.448E-4,6.1038E-4,5.1726E-4,4.4338E-4,5.4942E-4,6.4181E-4,6.1307E-4,5.1793E-4,4.4462E-4,5.4808E-4,6.426E-4,6.1355E-4,5.2347E-4,4.464E-4,5.4672E-4,6.4389E-4,6.1606E-4,5.2326E-4,4.4198E-4,5.4694E-4,6.4012E-4,6.1632E-4,5.2566E-4,4.4266E-4,5.4242E-4,6.3911E-4,6.1525E-4,5.2533E-4,4.43E-4,5.3852E-4,6.3243E-4,6.1227E-4,5.2434E-4,4.3772E-4,5.3875E-4,6.3416E-4,6.1687E-4,5.3064E-4,4.4084E-4,5.3612E-4,6.3601E-4,6.1617E-4,5.2959E-4,4.393E-4,5.3541E-4,6.3459E-4,6.2081E-4,5.3323E-4,4.3818E-4,5.324E-4,6.3457E-4,6.1777E-4,5.3358E-4,4.387E-4,5.3165E-4,6.3169E-4,6.1878E-4,5.3614E-4,4.3969E-4,5.3063E-4,6.2969E-4,6.2161E-4,5.398E-4,4.3778E-4,5.2956E-4,6.2821E-4,6.1861E-4,5.4108E-4,4.3957E-4,5.2783E-4,6.2998E-4,6.1755E-4,5.4166E-4,4.373E-4,5.2563E-4,6.2623E-4,6.1917E-4,5.437E-4,4.3844E-4,5.2257E-4,6.2297E-4,6.2162E-4,5.458E-4,4.3888E-4,5.2193E-4,6.2453E-4,6.2107E-4,5.4924E-4,4.3689E-4,5.1978E-4,6.2191E-4,6.2126E-4,5.4963E-4,4.363E-4,5.2016E-4,6.2139E-4,6.2538E-4,5.4719E-4,4.3691E-4,5.1516E-4,6.1867E-4,6.2483E-4,5.5294E-4,4.3722E-4,5.1444E-4,6.1792E-4,6.2241E-4,5.5542E-4,4.3745E-4,5.1487E-4,6.1741E-4,6.2519E-4,5.553E-4,4.3613E-4,5.1129E-4,6.146E-4,6.2292E-4,5.5758E-4,4.3689E-4,5.0906E-4,6.1467E-4,6.2476E-4,5.5758E-4,4.386E-4,5.0998E-4,6.1223E-4,6.2592E-4,5.5939E-4,4.3569E-4,5.0486E-4,6.0819E-4,6.2408E-4,5.6192E-4,4.3614E-4,5.0662E-4,6.1025E-4,6.2268E-4,5.6322E-4,4.3685E-4,5.0223E-4,6.0627E-4,6.2644E-4,5.6279E-4,4.3525E-4,5.0191E-4,6.0446E-4,6.2688E-4,5.678E-4,4.3685E-4,5.0248E-4,6.038E-4,6.2589E-4,5.6845E-4,4.3619E-4,4.9943E-4,6.0034E-4,6.267E-4,5.7083E-4,4.3885E-4,4.9556E-4,5.9981E-4,6.2616E-4,5.6818E-4,4.3893E-4,4.9747E-4,5.9813E-4,6.28E-4,5.7286E-4,4.3877E-4,4.962E-4,5.9578E-4,6.3171E-4,5.7205E-4,4.3926E-4,4.9236E-4,5.9521E-4,6.3183E-4,5.7327E-4,4.3972E-4,4.9374E-4,5.9378E-4,6.296E-4,5.759E-4,4.4053E-4,4.9075E-4,5.9218E-4,6.3056E-4,5.7882E-4,4.4157E-4,4.9099E-4,5.894E-4,6.2763E-4,5.7858E-4,4.389E-4,4.8661E-4,5.8882E-4,6.3032E-4,5.7961E-4,4.4084E-4,4.848E-4,5.8428E-4,6.2702E-4,5.7874E-4,4.4131E-4,4.8569E-4,5.8611E-4,6.2779E-4,5.8376E-4,4.4207E-4,4.8361E-4,5.8424E-4,6.2814E-4,5.8633E-4,4.4231E-4,4.8243E-4,5.82E-4,6.3099E-4,5.8443E-4,4.4318E-4,4.8132E-4,5.809E-4,6.3036E-4,5.857E-4,4.4246E-4,4.8122E-4,5.7652E-4,6.3135E-4,5.8969E-4,4.4217E-4,4.7772E-4,5.7537E-4,6.288E-4,5.9012E-4,4.4494E-4,4.7712E-4,5.743E-4,6.3182E-4,5.8857E-4,4.4655E-4,4.7564E-4,5.7109E-4,6.2989E-4,5.8963E-4,4.4537E-4,4.7693E-4,5.7191E-4,6.2984E-4,5.9052E-4,4.4682E-4,4.7452E-4,5.679E-4,6.301E-4,5.9009E-4,4.4613E-4,4.7218E-4,5.6654E-4,6.3072E-4,5.9192E-4,4.4816E-4,4.7196E-4,5.6592E-4,6.2868E-4,5.9184E-4,4.471E-4,4.6876E-4,5.6149E-4,6.2778E-4,5.9289E-4,4.498E-4,4.6772E-4,5.605E-4,6.2649E-4,5.9274E-4,4.4982E-4,4.6815E-4,5.59E-4,6.2918E-4,5.9289E-4,4.497E-4:2
2.09E-6,1.0967E-6,3.2233E-6,-1.3E-7,1.81E-6,5.3E-7,1.5167E-6,9.5667E-7,-8.7E-7,2.4833E-6,4.8333E-7,6.8333E-7,1.06E-6,-1.3433E-6,2.5367E-6,1.45E-6,2.1167E-6,1.8133E-6,-6.5E-7,7.1E-7,5.1667E-7,8.4E-7,1.1233E-6,-8.8667E-7,3.16E-6,1.9E-7,1.8767E-6,-1.9333E-7,-2.7E-7,2.43E-6,2.5833E-6,3.3767E-6,5.4E-7,-2.0E-7,2.8E-6,-1.3E-7,-7.3333E-8,1.0433E-6,-2.9333E-7,3.4633E-6,1.41E-6,4.0546E-4,5.4827E-4,4.0696E-4,5.5066E-4,6.1371E-4,6.0993E-4,5.2844E-4,4.2835E-4,5.3156E-4,6.1982E-4,6.1144E-4,5.2626E-4,4.328E-4,5.2993E-4,6.2057E-4,6.1476E-4,5.2846E-4,4.3493E-4,5.2913E-4,6.234E-4,6.1494E-4,5.2858E-4,4.3693E-4,5.3144E-4,6.2394E-4,6.1557E-4,5.3115E-4,4.3628E-4,5.3184E-4,6.2809E-4,6.2022E-4,5.3315E-4,4.3557E-4,5.3047E-4,6.2593E-4,6.1615E-4,5.3385E-4,4.3648E-4,5.3147E-4,6.2655E-4,6.1557E-4,5.3128E-4,4.3785E-4,5.2841E-4,6.2672E-4,6.1933E-4,5.3399E-4,4.3849E-4,5.291E-4,6.2863E-4,6.2106E-4,5.3592E-4,4.4116E-4,5.2925E-4,6.2979E-4,6.2124E-4,5.386E-4,4.3729E-4,5.293E-4,6.3137E-4,6.2209E-4,5.3729E-4,4.4175E-4,5.3058E-4,6.3094E-4,6.2048E-4,5.391E-4,4.3728E-4,5.2942E-4,6.3031E-4,6.2636E-4,5.3987E-4,4.39E-4,5.2726E-4,6.2718E-4,6.2596E-4,5.4158E-4,4.4089E-4,5.2851E-4,6.2815E-4,6.2408E-4,5.407E-4,4.402E-4,5.2978E-4,6.2644E-4,6.2349E-4,5.4192E-4,4.3938E-4,5.2563E-4,6.2591E-4,6.2545E-4,5.427E-4,4.4077E-4,5.2678E-4,6.2585E-4,6.2375E-4,5.4103E-4,4.3824E-4,5.2698E-4,6.2625E-4,6.2488E-4,5.4187E-4,4.3938E-4,5.2569E-4,6.2547E-4,6.2451E-4,5.4217E-4,4.3913E-4,5.2555E-4,6.2645E-4,6.2497E-4,5.4237E-4,4.3914E-4,5.2403E-4,6.2591E-4,6.232E-4,5.4539E-4,4.3961E-4,5.2596E-4,6.251E-4,6.2356E-4,5.4473E-4,4.3909E-4,5.2213E-4,6.2571E-4,6.2584E-4,5.4626E-4,4.366E-4,5.2233E-4,6.2467E-4,6.2492E-4,5.4447E-4,4.3937E-4,5.2312E-4,6.2431E-4,6.216E-4,5.4703E-4,4.3876E-4,5.2187E-4,6.2281E-4,6.2608E-4,5.4556E-4,4.3779E-4,5.2103E-4,6.2275E-4,6.2217E-4,5.4739E-4,4.3796E-4,5.2221E-4,6.2099E-4,6.2537E-4,5.4658E-4,4.372E-4,5.1763E-4,6.2145E-4,6.2394E-4,5.4785E-4,4.3856E-4,5.1883E-4,6.1815E-4,6.2347E-4,5.5023E-4,4.3803E-4,5.1846E-4,6.2412E-4,6.2285E-4,5.4811E-4,4.3802E-4,5.1691E-4,6.1808E-4,6.2313E-4,5.4856E-4,4.3719E-4,5.1812E-4,6.1941E-4,6.2376E-4,5.4891E-4,4.3703E-4,5.1607E-4,6.18E-4,6.248E-4,5.4958E-4,4.3459E-4,5.1338E-4,6.1772E-4,6.2577E-4,5.4959E-4,4.3702E-4,5.1538E-4,6.1922E-4,6.2064E-4,5.4916E-4,4.3477E-4,5.142E-4,6.1708E-4,6.2249E-4,5.5006E-4,4.355E-4,5.1454E-4,6.1585E-4,6.234E-4,5.4426E-4,4.3083E-4,5.0678E-4,6.0501E-4,6.1929E-4,5.4768E-4,4.3312E-4,5.117E-4,6.1039E-4,6.1996E-4,5.506E-4,4.3307E-4,5.0843E-4,6.1049E-4,6.22E-4,5.497E-4,4.3388E-4,5.0973E-4,6.1313E-4,6.2532E-4,5.5072E-4,4.3383E-4,5.0748E-4,6.1228E-4,6.2312E-4,5.5027E-4,4.3511E-4,5.0944E-4,6.1206E-4,6.2121E-4,5.506E-4,4.3311E-4,5.0674E-4,6.0799E-4,6.2095E-4,5.4896E-4,4.3212E-4,5.0824E-4,6.098E-4,6.1971E-4,5.4788E-4,4.3459E-4,5.104E-4,6.1046E-4,6.1984E-4,5.4967E-4,4.3423E-4,5.0555E-4,6.0839E-4,6.2157E-4,5.5205E-4,4.342E-4,5.0468E-4,6.0882E-4,6.1981E-4,5.5095E-4,4.3229E-4,5.0346E-4,6.1066E-4,6.1854E-4,5.5101E-4,4.3087E-4,5.0271E-4,6.0399E-4,6.197E-4,5.5182E-4,4.2999E-4,5.0408E-4,6.042E-4,6.2005E-4,5.5174E-4,4.2952E-4,5.0495E-4,6.0302E-4,6.2019E-4,5.5261E-4,4.3007E-4,5.0359E-4,6.039E-4,6.2223E-4,5.5391E-4,4.3043E-4,5.0312E-4,6.0311E-4,6.2042E-4,5.5358E-4,4.3002E-4,5.0177E-4,6.0238E-4,6.1956E-4,5.5389E-4,4.2997E-4,5.0084E-4,6.0004E-4,6.1988E-4,5.5158E-4,4.3132E-4,5.0064E-4,6.0054E-4,6.1849E-4,5.5105E-4,4.296E-4,4.9927E-4,6.0152E-4,6.1884E-4,5.5458E-4,4.312E-4,4.9793E-4,5.9942E-4,6.2067E-4,5.5233E-4,4.3085E-4,4.9794E-4,6.0174E-4,6.1896E-4,5.5238E-4,4.2845E-4,4.962E-4,5.9944E-4,6.1953E-4,5.5351E-4,4.3086E-4,4.9814E-4,5.9689E-4,6.2016E-4,5.524E-4,4.3063E-4,4.962E-4,6.0089E-4,6.156E-4,5.5452E-4,4.2854E-4,4.9824E-4,5.9584E-4,6.1994E-4,5.5328E-4,4.2922E-4,4.9554E-4,5.9843E-4,6.1859E-4,5.5536E-4,4.2865E-4,4.9469E-4,5.967E-4,6.1911E-4,5.5581E-4,4.2953E-4,4.9415E-4,5.9573E-4,6.1592E-4,5.5447E-4,4.288E-4,4.9544E-4,5.9584E-4,6.1684E-4,5.535E-4,4.275E-4,4.9319E-4,5.942E-4,6.1891E-4,5.5373E-4,4.2747E-4,4.9314E-4,5.9538E-4,6.1575E-4,5.5648E-4,4.2953E-4,4.9285E-4,5.9357E-4,6.1768E-4,5.5367E-4,4.2564E-4,4.8957E-4,5.9173E-4,6.1877E-4,5.5387E-4,4.2802E-4,4.9094E-4,5.9176E-4,6.1444E-4,5.5142E-4,4.2544E-4,4.905E-4,5.8928E-4,6.1623E-4,5.527E-4,4.2679E-4,4.8811E-4,5.9058E-4,6.1714E-4,5.5341E-4,4.2497E-4,4.8566E-4,5.8729E-4,6.1257E-4,5.5231E-4,4.2617E-4,4.8555E-4,5.8887E-4,6.1444E-4,5.5275E-4,4.2608E-4,4.8487E-4,5.891E-4,6.1364E-4,5.5068E-4,4.2712E-4,4.8629E-4,5.8767E-4,6.1365E-4,5.5375E-4,4.269E-4,4.8641E-4,5.8714E-4,6.1436E-4,5.5256E-4,4.2675E-4,4.8436E-4,5.8611E-4,6.1487E-4,5.5558E-4,4.2426E-4,4.8604E-4,5.8709E-4,6.1515E-4,5.5478E-4,4.2426E-4,4.8401E-4,5.8205E-4,6.1275E-4,5.5407E-4,4.2458E-4,4.8512E-4,5.8388E-4,6.1218E-4,5.5419E-4,4.2305E-4,4.8381E-4,5.8215E-4,6.1227E-4,5.5465E-4,4.2247E-4,4.8299E-4,5.8055E-4,3.0348E-4:2
9.6333E-7,2.33E-6,2.1933E-6,-2.06E-6,-3.3633E-6,-1.9933E-6,6.98E-6,1.96E-6,-3.5733E-6,3.72E-6,-9.9333E-7,4.4267E-6,1.1333E-6,-3.0433E-6,-1.72E-6,-1.9033E-6,3.9133E-6,1.9833E-6,-8.9E-7,2.58E-6,-1.4133E-6,4.22E-6,5.3333E-7,-7.5167E-6,1.53E-6,-4.3333E-7,2.3333E-6,2.0E-6,-1.2433E-6,2.9567E-6,4.7667E-7,-6.0233E-6,4.6129E-4,0.0018765,8.4276E-4,0.0010308,8.4108E-4,0.001193,0.001324,8.9605E-4,9.0214E-4,9.03E-4,0.0012064,0.0012649,9.7976E-4,8.4742E-4,9.3843E-4,0.0012044,0.0012425,0.0010017,8.3624E-4,9.4699E-4,0.0012007,0.0012455,0.001007,8.3327E-4,9.4718E-4,0.0012029,0.0012405,0.0010109,8.2964E-4,9.4519E-4,0.0012018,0.0012408,0.0010091,8.3155E-4,9.4723E-4,0.0011985,0.0012431,0.00101,8.3009E-4,9.4406E-4,0.0011961,0.0012419,0.0010106,8.2868E-4,9.4369E-4,0.0011931,0.0012397,0.0010145,8.3091E-4,9.3935E-4,0.0011931,0.0012402,0.0010147,8.2918E-4,9.3871E-4,0.0011897,0.0012416,0.0010196,8.2853E-4,9.3737E-4,0.0011928,0.0012415,0.0010183,8.2949E-4,9.3847E-4,0.0011895,0.0012418,0.0010187,8.2644E-4,9.3451E-4,0.0011877,0.0012441,0.0010194,8.3127E-4,9.3324E-4,0.0011881,0.001242,0.0010229,8.2825E-4,9.2946E-4,0.0011855,0.0012434,0.0010212,8.3038E-4,9.2626E-4,0.0011825,0.0012399,0.0010222,8.2715E-4,9.2686E-4,0.0011779,0.0012384,0.001027,8.2977E-4,9.2234E-4,0.0011773,0.0012425,0.0010305,8.2419E-4,9.2266E-4,0.0011747,0.0012362,0.0010266,8.2339E-4,9.1638E-4,0.001173,0.0012349,0.0010266,8.2391E-4,9.1747E-4,0.0011683,0.0012355,0.0010317,8.2097E-4,9.1104E-4,0.0011691,0.0012301,0.0010319,8.2625E-4,9.1269E-4,0.0011637,0.0012331,0.0010323,8.2346E-4,9.1085E-4,0.0011626,0.0012314,0.0010338,8.1925E-4,9.1115E-4,0.0011662,0.0012284,0.0010385,8.2052E-4,9.0643E-4,0.0011616,0.0012298,0.0010364,8.25E-4,9.0616E-4,0.0011574,0.001233,0.0010382,8.2438E-4,9.0393E-4,0.001159,0.0012293,0.0010397,8.2481E-4,9.0073E-4,0.0011581,0.001229,0.0010436,8.2206E-4,8.9759E-4,0.0011543,0.0012279,0.0010442,8.2282E-4,8.9605E-4,0.0011539,0.0012246,0.0010475,8.2259E-4,8.9346E-4,0.0011542,0.0012247,0.0010434,8.1872E-4,8.9214E-4,0.0011499,0.0012256,0.0010466,8.23E-4,8.9132E-4,0.0011499,0.0012252,0.0010488,8.1983E-4,8.8543E-4,0.0011491,0.0012238,0.001052,8.2336E-4,8.8716E-4,0.0011473,0.0012241,0.0010526,8.2474E-4,8.8736E-4,0.0011468,0.001223,0.0010529,8.2337E-4,8.8241E-4,0.0011398,0.0012175,0.0010513,8.2136E-4,8.8378E-4,0.0011405,0.0012176,0.001055,8.2417E-4,8.8119E-4,0.0011399,0.0012165,0.0010569,8.2556E-4,8.8327E-4,0.0011381,0.0012211,0.0010602,8.2491E-4,8.7764E-4,0.0011361,0.0012152,0.0010616,8.2168E-4,8.7745E-4,0.0011358,0.0012169,0.0010607,8.2419E-4,8.7376E-4,0.0011305,0.0012183,0.0010642,8.263E-4,8.7128E-4,0.0011325,0.0012171,0.0010672,8.214E-4,8.6847E-4,0.0011298,0.001215,0.0010676,8.2218E-4,8.6901E-4,0.0011299,0.0012128,0.0010662,8.2597E-4,8.6893E-4,0.0011254,0.0012157,0.0010674,8.2468E-4,8.6508E-4,0.001126,0.0012129,0.0010685,8.2497E-4,8.6301E-4,0.0011235,0.0012124,0.0010742,8.2561E-4,8.6019E-4,0.0011293,0.0012106,0.0010708,8.2711E-4,8.6214E-4,0.0011262,0.0012089,0.0010766,8.2309E-4,8.6217E-4,0.0011179,0.001215,0.0010749,8.2981E-4,8.5934E-4,0.0011194,0.0012117,0.0010777,8.2576E-4,8.5791E-4,0.0011176,0.0012067,0.0010806,8.2641E-4,8.5048E-4,0.0011196,0.0012083,0.0010837,8.2623E-4,8.5275E-4,0.001116,0.0012082,0.0010854,8.2863E-4,8.5133E-4,0.0011133,0.0012098,0.0010853,8.3211E-4,8.5006E-4,0.0011122,0.0012094,0.001087,8.3255E-4,8.4959E-4,0.0011146,0.0012082,0.0010916,8.2867E-4,8.4923E-4,0.001109,0.0012062,0.0010942,8.334E-4,8.4465E-4,0.0011075,0.0012069,0.0010904,8.337E-4,8.4609E-4,0.0011076,6.0654E-4:2
8.2333E-7,3.4367E-6,-1.32E-6,9.3333E-8,2.4E-6,-1.4367E-6,2.0933E-6,-3.8667E-6,3.01E-6,-1.3667E-7,-1.7667E-7,1.4267E-6,-2.18E-6,3.6633E-6,-3.14E-6,3.3E-7,1.8267E-6,-1.5633E-6,2.16E-6,1.01E-6,4.0E-7,4.01E-6,-9.8E-7,2.4067E-6,2.5567E-6,8.1E-7,8.7233E-6,-1.48E-6,4.2167E-6,-3.0667E-7,-2.8767E-6,3.1167E-6,-1.5267E-6,-7.4E-7,-3.4367E-6,-1.12E-6,-5.1533E-6,-4.1667E-7,6.2167E-6,2.0467E-6,6.9E-7,3.5333E-6,-1.5267E-6,2.2467E-6,7.7333E-7,0.0016576,0.0027545,4.9827E-4,0.0011441,9.6413E-4,0.0011136,0.0013449,6.9942E-4,9.12E-4,0.0010252,0.0011721,0.0012291,8.3829E-4,8.4118E-4,0.001078,0.0012,0.001202,8.8443E-4,8.1866E-4,0.0010856,0.0012083,0.0011932,8.9154E-4,8.13E-4,0.0010859,0.0012065,0.0011911,8.9402E-4,8.1269E-4,0.0010873,0.0012063,0.001191,8.9974E-4,8.1093E-4,0.001087,0.0012042,0.00119,9.0081E-4,8.0729E-4,0.0010831,0.0012042,0.0011977,9.0194E-4,8.0885E-4,0.0010797,0.0011995,0.001195,9.0437E-4,8.0856E-4,0.0010747,0.0012033,0.0012008,9.0866E-4,8.055E-4,0.0010794,0.0011986,0.0011959,9.0434E-4,8.0536E-4,0.0010733,0.0012007,0.0011976,9.0842E-4,8.0755E-4,0.0010699,0.0011976,0.0011955,9.094E-4,8.0456E-4,0.0010681,0.0011938,0.0011999,9.099E-4,8.0333E-4,0.0010678,0.0011935,0.0012016,9.1074E-4,8.0101E-4,0.0010663,0.0011937,0.0012013,9.1448E-4,8.0315E-4,0.0010659,0.0011893,0.0012017,9.1333E-4,7.9904E-4,0.0010665,0.0011919,0.0012028,9.1333E-4,7.9826E-4,0.001063,0.001187,0.0012044,9.1436E-4,7.9433E-4,0.0010551,0.0011799,0.0012,9.1526E-4,7.9161E-4,0.0010567,0.0011807,0.0012032,9.1598E-4,7.9455E-4,0.0010531,0.0011821,0.001205,9.1727E-4,7.9304E-4,0.0010523,0.0011804,0.0012005,9.2373E-4,7.899E-4,0.0010491,0.0011774,0.0012067,9.1953E-4,7.8752E-4,0.0010476,0.0011765,0.0012035,9.1774E-4,7.9044E-4,0.0010458,0.0011746,0.0012069,9.2469E-4,7.8726E-4,0.0010441,0.0011722,0.0012098,9.213E-4,7.8421E-4,0.0010452,0.0011751,0.0012083,9.2833E-4,7.8481E-4,0.0010407,0.0011751,0.0012058,9.2471E-4,7.8739E-4,0.0010358,0.0011653,0.001204,9.2771E-4,7.8487E-4,0.0010348,0.0011659,0.0012052,9.3056E-4,7.8431E-4,0.0010339,0.0011658,0.0012089,9.2866E-4,7.8207E-4,0.0010306,0.0011649,0.0012083,9.2892E-4,7.826E-4,0.0010303,0.0011653,0.0012106,9.3319E-4,7.8284E-4,0.0010271,0.0011635,0.0012092,9.3021E-4,7.8131E-4,0.0010247,0.0011605,0.0012106,9.3587E-4,7.7778E-4,0.0010243,0.0011597,0.0012113,9.3568E-4,7.7827E-4,0.0010205,0.0011527,0.001208,9.3875E-4,7.7911E-4,0.0010203,0.0011543,0.0012076,9.4428E-4,7.7472E-4,0.0010216,0.0011536,0.0012124,9.4091E-4,7.7646E-4,0.0010177,0.0011523,0.0012134,9.4211E-4,7.7525E-4,0.0010177,0.0011535,0.0012143,9.4615E-4,7.7157E-4,0.0010169,0.0011497,0.0012155,9.4729E-4,7.7485E-4,0.0010149,0.0011446,0.001217,9.4706E-4,7.7299E-4,0.0010154,0.0011453,0.0012164,9.4574E-4,7.7409E-4,0.0010097,0.0011428,0.0012157,9.5579E-4,7.7315E-4,0.0010047,0.0011448,0.0012153,9.5451E-4,7.705E-4,0.0010057,0.0011405,0.0012181,9.5274E-4,7.7017E-4,0.0010074,0.0011438,0.0012172,9.5499E-4,7.7203E-4,0.0010081,0.0011402,0.0012155,9.5574E-4,7.7049E-4,0.0010002,0.0011368,0.0012193,9.5876E-4,7.6835E-4,0.0010033,0.0011338,0.0012209,9.6066E-4,7.6867E-4,9.9966E-4,0.0011344,0.0012162,9.6029E-4,7.6691E-4,9.9469E-4,0.0011301,0.0012184,9.6321E-4,7.6757E-4,9.9286E-4,0.001129,0.0012204,9.5971E-4,7.6777E-4,9.9518E-4,0.0011327,0.0012196,9.6287E-4,7.681E-4,9.9309E-4,0.0011297,0.0012185,9.6688E-4,7.6689E-4,9.8961E-4,0.0011319,0.0012201,9.6626E-4,7.6442E-4,9.9327E-4,0.0011274,0.0012232,9.6948E-4,7.6919E-4,9.8868E-4,0.0011245,0.0012229,9.6721E-4,7.6632E-4,9.8414E-4,0.001125,0.0012234,9.7187E-4,7.6799E-4,9.817E-4,0.0011282,0.0012212,9.749E-4,7.6321E-4,9.8342E-4,0.0011221,0.0012227,9.7231E-4,7.6787E-4,9.8059E-4,0.0011206,0.0012231,9.7759E-4,7.6343E-4,9.7689E-4,0.0011215,0.0012206,9.7939E-4,7.6558E-4,9.7613E-4,0.0011202,0.0012258,9.8207E-4,7.6438E-4,9.7407E-4,0.0011182,0.0012274,9.8238E-4,7.6557E-4,9.7804E-4,0.0011171,0.0012254,9.836E-4,7.6577E-4,9.7751E-4,0.0011165,0.0012251,9.8508E-4,7.6391E-4,9.7361E-4,0.0011175,0.001225,9.8731E-4,7.6684E-4,9.7271E-4,0.0011137,0.0012306,9.8736E-4,7.6453E-4,9.7121E-4,0.0011144,5.7509E-4:2
-0.20112,-0.17795,-0.21284,-0.27353,-0.36447,-0.2127,-0.17914,-0.20742,-0.26786,-0.37017,-0.20953,-0.17567,-0.20874,-0.27742,-0.37384,-0.21395,-0.17784,-0.20716,-0.28151,-0.36844,-0.20626,-0.18308,-0.21129,-0.27107,-0.36793,-0.21188,-0.17849,-0.19889,-0.27885,-0.3644,-0.21078,-0.18012,-0.21042,-0.28041,-0.36871,-0.20739,-0.17653,-0.20413,0.45721,4.7211,3.5719,4.0065,4.7541,4.8431,3.9643,3.5499,4.056,4.7593,4.8524,3.9689,3.545,4.0524,4.7664,4.8503,3.9753,3.5396,4.0519,4.7714,4.862,3.9771,3.5549,4.055,4.7833,4.8597,3.9782,3.5477,4.0523,4.7653,4.8517,3.9647,3.5253,4.0448,4.755,4.8399,3.9597,3.5185,4.0369,4.733,4.8329,3.9524,3.5117,4.0377,4.7427,4.8276,3.9591,3.5307,4.0406,4.7585,4.8551,3.976,3.5452,4.0603,4.7855,4.8626,3.98,3.5533,4.064,4.7839,4.8517,3.9711,3.5328,4.0439,4.743,4.8207,3.9399,3.5165,4.0311,4.7387,4.8319,3.9583,3.5298,4.0504,4.7786,4.851,3.9736,3.5446,4.0498,4.7667,4.8435,3.9566,3.5159,4.0037,4.7297,4.8028,3.9252,3.5137,4.0212,4.7523,4.8248,3.9509,3.5357,4.0441,4.7662,4.8284,3.9448,3.5139,4.0174,4.7323,4.7967,3.9313,3.5055,4.018,4.7545,4.8192,3.9686,3.5278,4.0435,4.747,4.7994,3.9286,3.4863,4.0048,4.7174,4.7919,3.9355,3.5081,4.0355,4.7553,4.8281,3.9212,3.5025,4.0006,4.7007,4.7854,3.9061,3.4971,4.014,4.7501,4.8084,3.919,3.5064,4.001,4.7065,4.7596,3.8913,3.4837,4.0018,4.7332,4.7803,3.9216,3.4988,4.0029,4.7158,4.744,3.8816,3.4602,3.9955,4.7166,4.7713,3.911,3.4798,3.988,4.6807,4.7324,3.8711,3.4536,3.9924,4.6997,4.7655,3.8735,3.455,3.9646,4.6571,4.7179,3.846,3.4514,3.9754,4.7029,4.7441,3.8539,3.4397,3.9448,4.6441,4.7049,3.856,3.4519,3.981,4.662,4.6991,3.8229,3.4122,3.9391,4.6513,4.7155,3.8477,3.4425,3.9484,4.6308,4.6797,3.8195,3.4248,3.9524,4.6631,4.7105,3.8058,3.4054,3.9314,4.6222,4.6883,3.8192,3.4353,3.9454,4.6391,4.6685,3.7891,3.3937,3.9335,4.6482,4.6703,3.7926,3.4004,3.9055,4.609,4.6406,3.7919,3.4112,3.928,4.6168,4.6303,3.7602,3.3774,3.9179,4.6206,4.6463,3.7677,3.3711,3.8962,4.5758,4.6287,3.7767,3.3911,3.9145,4.5784,4.606,3.7377,3.3626,3.9137,4.5966,4.6185,3.7287,3.3571,3.8756,4.5831,4.6155,3.7415,3.3653,3.8807,4.551,4.587,3.7212,3.3684,3.8952,4.5706,4.5716,3.7028,3.3399,3.8804,4.5815,4.587,3.7044:2
-0.22766,-0.28185,-0.3358,-0.26533,-0.13399,-0.22712,-0.28572,-0.3337,-0.27455,-0.13468,-0.21847,-0.28683,-0.32976,-0.27257,-0.12428,-0.23207,-0.2813,-0.32553,-0.26715,-0.13435,-0.22371,-0.27709,-0.33733,-0.27099,-0.13204,-0.22261,-0.28461,-0.33218,-0.27705,-0.13027,-0.2234,-0.28229,-0.32986,-0.27372,-0.13356,-0.22652,-0.28108,-0.33128,-0.27278,-0.13193,-0.21793,-0.28445,-0.32988,-0.28079,4.3896,4.8884,5.0466,4.0397,3.6491,3.9716,4.7633,4.9578,4.1256,3.5546,4.0504,4.7372,4.9525,4.1624,3.5457,4.0568,4.7324,4.9563,4.1509,3.5313,4.0528,4.7182,4.9592,4.1519,3.5197,4.0359,4.7115,4.9464,4.1515,3.5128,4.0239,4.6866,4.9478,4.1345,3.512,4.0042,4.6948,4.9228,4.1477,3.5055,4.0044,4.6925,4.9328,4.1659,3.5221,4.0114,4.7125,4.9564,4.1786,3.5316,4.0288,4.7249,4.9631,4.2038,3.5391,4.0255,4.7187,4.9644,4.1885,3.5146,3.9997,4.6716,4.9364,4.1675,3.4993,3.9723,4.663,4.9375,4.1732,3.5032,3.977,4.694,4.9594,4.2088,3.5375,4.0001,4.7154,4.9669,4.2052,3.5167,3.9659,4.6753,4.9369,4.1748,3.4924,3.9511,4.6485,4.906,4.1948,3.5147,3.9722,4.6877,4.9497,4.2182,3.5134,3.9629,4.6567,4.9122,4.1985,3.4881,3.9288,4.6306,4.9152,4.1969,3.5005,3.9551,4.6683,4.9413,4.2222,3.5098,3.9385,4.6325,4.9033,4.1789,3.4747,3.9185,4.615,4.9195,4.2107,3.4969,3.9438,4.6439,4.9113,4.2003,3.4825,3.888,4.5964,4.8748,4.181,3.4836,3.9129,4.6188,4.9137,4.216,3.4752,3.8995,4.5807,4.8741,4.1878,3.4587,3.8875,4.6019,4.9008,4.2173,3.4787,3.8871,4.5796,4.8577,4.1729,3.4378,3.8653,4.5798,4.8763,4.2125,3.4707,3.8741,4.565,4.8415,4.176,3.4379,3.8525,4.5741,4.8531,4.2151,3.4591,3.8589,4.5552,4.8386,4.1899,3.4289,3.8563,4.5682,4.8728,4.2111,3.4403,3.8367,4.5063,4.8392,4.1849,3.429,3.8473,4.5423,4.8703,4.1889,3.4294,3.8118,4.5003,4.8291,4.1839,3.4359,3.8232,4.5233,4.8336,4.1533,3.4055,3.7951,4.4997,4.8365,4.1857,3.4306,3.7998,4.5022,4.7916,4.1634,3.403,3.7938,4.511,4.816,4.1811,3.3978,3.7646,4.4632,4.7841,4.1792,3.4135,3.7883,4.4754,4.7703,4.1539,3.3815,3.7564,4.4669,4.8092,4.1751,3.3855,3.7564,4.4224,4.7676,4.1737,3.3896,3.767,4.4406,4.7654,4.1304,3.3636,3.7366,4.4415,4.79,4.1506,3.3728,3.7151,4.4073,4.7478,4.1571,3.3807,3.7211,4.4204,4.7207,4.1316,3.3518,3.7146,4.4243,4.7478,4.1415,3.3385,3.6874,4.3775,4.7402,4.1397,3.3453,3.6896,4.3581,4.6997,4.1123,3.3386,3.6914,4.3765,4.7019,4.1003,3.3183,3.662,4.3652,4.7167,4.1161,3.3101,3.6434,4.3389,4.6965,4.1272,3.3294,3.6575,4.3287,4.6581,4.0977,3.3198,3.6534,4.3443,4.6635,4.0849,3.2907,3.6391,4.3379,4.6874,4.1049,3.2857,3.6228,4.2998,4.676,4.1072,0.26419:2
-0.30941,-0.33417,-0.16903,-0.17011,-0.24908,-0.31125,-0.33741,-0.15369,-0.18112,-0.25437,-0.30018,-0.34,-0.15706,-0.17998,-0.24432,-0.30665,-0.33842,-0.15318,-0.18017,-0.25794,-0.30467,-0.33689,-0.15475,-0.17473,-0.24963,-0.30222,-0.33953,-0.16137,-0.17546,-0.25705,-0.30477,-0.33873,-0.15566,-0.18214,-0.26055,-0.29851,-0.33456,-0.1509,-0.18458,-0.25485,-0.30611,-0.34101,-0.15819,-0.17582,-0.25669,3.6475,3.9038,3.5496,4.5557,4.9606,4.5191,3.6872,3.6949,4.4599,4.9322,4.5691,3.6334,3.7438,4.4591,4.9323,4.5836,3.6204,3.756,4.4524,4.9438,4.5826,3.6294,3.7594,4.4572,4.952,4.5676,3.6179,3.7569,4.4436,4.9445,4.559,3.6065,3.7369,4.4277,4.9199,4.5497,3.5839,3.7355,4.4152,4.9156,4.5296,3.5805,3.7363,4.4126,4.9102,4.544,3.5813,3.7391,4.4424,4.9249,4.552,3.6009,3.757,4.4519,4.9517,4.5678,3.6131,3.7666,4.4551,4.9416,4.5454,3.5854,3.7422,4.4325,4.9102,4.5143,3.5675,3.7315,4.416,4.8971,4.5063,3.5785,3.7404,4.4531,4.9382,4.5469,3.5907,3.7578,4.4669,4.9416,4.5274,3.5743,3.7356,4.43,4.9044,4.4966,3.5483,3.7237,4.4193,4.8897,4.5023,3.5669,3.7547,4.4643,4.9337,4.5208,3.5682,3.7566,4.4353,4.9087,4.4761,3.5336,3.7325,4.4062,4.8938,4.4825,3.5539,3.7482,4.4553,4.9318,4.4872,3.5548,3.7381,4.4155,4.8785,4.4433,3.5257,3.7026,4.4263,4.8951,4.4611,3.5617,3.7362,4.4543,4.8762,4.4384,3.5211,3.7003,4.4074,4.858,4.429,3.5327,3.722,4.4559,4.8915,4.4479,3.5231,3.7066,4.3926,4.8486,4.4001,3.508,3.7127,4.4231,4.8764,4.4315,3.5214,3.7055,4.4019,4.8401,4.386,3.4931,3.6964,4.4205,4.86,4.4131,3.5061,3.7006,4.4025,4.8195,4.3651,3.4701,3.6925,4.4131,4.8537,4.3836,3.4884,3.6902,4.386,4.8032,4.3461,3.4701,3.698,4.4193,4.8441,4.3702,3.4686,3.6854,4.3681,4.7949,4.3416,3.4722,3.6949,4.4129,4.832,4.3404,3.4425,3.6669,4.3749,4.7996,4.3392,3.4686,3.6968,4.3883,4.7902,4.3078,3.4322,3.6673,4.3983,4.8029,4.3245,3.4448,3.6676,4.3712,4.7682,4.2929,3.4344,3.6736,4.4005,4.7858,4.2913,3.4125,3.6601,4.3541,4.784,4.2943,3.428,3.6761,4.36,4.7613,4.2537,3.4004,3.6675,4.3666,4.7837,4.2541,3.3925,3.6438,4.3386,4.7698,4.2546,3.4149,3.658,4.3516,4.7379,4.2172,3.3876,3.651,4.3739,4.7601,4.2205,3.3752,3.6273,4.3345,4.7426,4.227,3.3941,3.6357,4.335,4.7015,4.1982,3.372,3.6458,4.36,4.7215,4.1897,3.3512,3.6246,4.3425,4.7224,4.2078,3.3545,3.6302,4.3105,4.6879,4.1799,3.3516,3.6433,4.313,4.6887,4.1568,3.3278,3.6184,4.3268,4.7085,4.1425,3.3149,3.5968,4.2962,4.69,4.152,3.321,3.6016,4.2906,4.6565,4.1281,3.3228,3.615,4.3093,4.653,4.1053,3.3013,3.5979,4.3095,4.6671,4.102,3.2831,3.5861,4.2812,4.6591,4.1185,3.2935,3.5898,4.2703,4.6293,4.098,3.298,3.6018,4.2814,4.6153,4.067,3.2856,3.5973,4.3029,4.6284,4.0562,3.2628,3.5758,4.2891,4.6388,4.0583,3.2645,3.5654,4.2783,4.6267,4.0641,3.2765,3.576,4.2578,4.6054,4.0493,3.2741,3.5885,4.2699,4.5809,4.0303,3.2452,3.5836,2.2956:2
-0.18877,-0.24341,-0.25886,-0.12306,-0.18531,-0.18036,-0.23633,-0.25648,-0.12999,-0.18613,-0.18592,-0.23896,-0.25696,-0.12647,-0.18492,-0.18499,-0.23552,-0.26032,-0.12799,-0.18341,-0.17383,-0.23614,-0.26554,-0.1345,-0.18613,-0.18354,-0.23323,7.5789,7.8907,8.3944,10.136,9.8651,7.9038,7.5726,8.6244,10.054,9.8453,8.0189,7.4756,8.6638,10.03,9.8644,8.059,7.469,8.6658,10.027,9.8548,8.0799,7.4629,8.6518,10.026,9.8807,8.0858,7.4564,8.6355,10.011,9.8859,8.1004,7.4414,8.6141,9.9897,9.8979,8.1044,7.4509,8.6033,9.9933,9.9085,8.1208,7.4376,8.5836,9.9799,9.923,8.1297,7.4232,8.5636,9.9607,9.9252,8.14,7.4273,8.538,9.9444,9.91,8.1473,7.4193,8.5228,9.9383,9.9189,8.1549,7.4003,8.497,9.9239,9.9085,8.1699,7.3918,8.4777,9.9097,9.9105,8.1754,7.3884,8.4603,9.8832,9.9171,8.179,7.3643,8.4236,9.8638,9.9199,8.18,7.355,8.413,9.8474,9.9132,8.1992,7.3582,8.3927,9.8306,9.9208,8.2093,7.3493,8.3619,9.8111,9.9085,8.206,7.3323,8.3412,9.7966,9.9164,8.2104,7.156,6.6403,7.2935,7.1843,5.88,5.3109,6.3481,7.3236,7.2016,5.8399,5.3457,6.297,7.3099,7.1899,5.839,5.3354,6.2787,7.3056,7.2021,5.846,5.3318,6.2612,7.2896,7.2017,5.8481,5.3239,6.2478,7.2819,7.1971,5.845,5.3159,6.2299,7.2631,7.2035,5.862,5.3104,6.2089,7.2546,7.197,5.8645,5.3003,6.1906,7.2415,7.198,5.8712,5.2894,6.1767,7.2411,7.2031,5.8829,5.2964,6.1749,7.2405,7.2021,5.8882,5.2816,6.1578,7.2273,7.2113,5.9011,5.2832,6.1418,7.2188,7.2089,5.8976,5.2757,6.1204,7.1977,7.1973,5.9056,5.2624,6.105,7.1979,7.2103,5.9213,5.2586,6.095,7.1836,7.2084,5.9412,5.2547,6.0857,7.1764,7.2242,5.943,5.2553,6.0711,7.1571,7.224,5.9456,5.2427,6.0487,7.1584,7.2234,5.9576,5.2458,6.0272,7.1317,7.2227,5.9621,5.247,6.0191,7.137,7.2368,5.9783,5.2424,5.9959,7.1239,7.23,5.9893,5.2463,5.9911,7.129,7.2244,6.0016,5.2414,5.9774,7.1292,7.2346,6.0129,5.2422,5.9684,7.1133,7.2394,6.0233,5.2299,5.9517,7.0985,7.2432,6.0363,5.2348,5.9497,7.084,7.2389,6.0362,5.2311,5.9316,7.0791,7.2482,6.0512,5.2253,5.9148,7.0718,7.2535,6.0617,5.2205,5.9043,7.0582,7.2494,6.0824,5.232,5.8872,7.0513,7.2434,6.0919,5.2308,5.8776,7.0437,7.2562,6.0987,5.2262,5.8661,7.0355,7.2471,6.113,5.2219,5.8518,7.0256,7.2523,6.1287,5.2221,5.8477,7.0142,7.2527,6.1391,5.2239,5.8214,7.0038,7.2512,6.1434,5.2233,5.8203,6.9973,7.2519,6.1527,5.2183,5.8068,6.9912,7.2478,6.1631,5.2157,5.7848,6.9763,7.2684,6.17,5.2191,5.7695,6.9719,7.2543,6.1891,5.2195,5.7625,6.9571,7.2722,6.2063,5.2165,5.7588,6.9551,7.2705,6.2192,5.22,5.7358,6.9411,7.2668,6.2348,5.217,5.7212,6.9386,7.2643,6.2408,5.2305,5.7105,6.9208,7.2672,6.2597,5.2304,5.7026,6.9075,7.2677,6.2752,5.2281,5.6995,6.9087,7.2666,6.2762,5.2303,5.6884,6.8997,7.276,6.2918,5.231,5.6767,6.884,7.2655,6.3042,5.234,5.6651,6.8847,7.2752,6.3142,5.2391,5.6534,6.8778,7.2685,6.3354,5.2398,5.6478,6.8673,7.2673,6.3427,5.2352,5.6298:2
-0.15838,-0.18083,-0.15176,-0.22844,-0.2745,-0.16536,-0.18771,-0.14085,-0.22486,-0.27501,-0.15946,-0.17801,-0.14767,-0.2217,-0.26533,-0.16633,-0.17863,-0.14601,-0.2212,-0.26733,-0.1676,-0.1783,-0.1488,-0.21898,-0.2667,-0.16677,0.99486,9.7492,10.075,9.0733,7.2189,7.9827,9.3043,10.08,8.9462,7.386,7.8419,9.3517,10.082,8.9447,7.4138,7.8132,9.351,10.091,8.9458,7.4323,7.7983,9.3427,10.085,8.966,7.4352,7.7949,9.3344,10.09,8.9777,7.4517,7.7877,9.33,10.086,8.9959,7.4466,7.7691,9.3137,10.094,9.0103,7.4562,7.7576,9.3069,10.072,9.0167,7.4588,7.7489,9.2882,10.074,9.0299,7.4506,7.73,9.2768,10.089,9.0325,7.4615,7.7161,9.2593,10.069,9.0381,7.4481,7.6994,9.2231,10.057,9.0511,7.4509,7.6884,9.2184,10.061,9.0533,7.4516,7.6751,9.1998,10.039,9.0554,7.4528,7.649,9.173,10.03,9.0614,7.4601,7.6413,9.1596,10.022,9.0767,7.4519,7.6154,9.1367,10.017,9.0616,7.4503,7.5989,9.1169,9.9987,9.0762,7.4489,7.593,9.1003,9.9888,9.0774,7.4476,7.5737,9.0783,9.0773,6.4876,5.3887,5.6043,6.9285,7.3407,6.4874,5.3408,5.64,6.8867,7.3427,6.5041,5.3238,5.632,6.8729,7.3423,6.5115,5.3294,5.6295,6.8581,7.3411,6.5054,5.3226,5.6158,6.8473,7.3277,6.5239,5.3191,5.616,6.8337,7.3258,6.5288,5.3256,5.6015,6.828,7.3229,6.5332,5.321,5.5846,6.8153,7.3146,6.544,5.3201,5.5667,6.8031,7.3092,6.5449,5.322,5.566,6.7974,7.3075,6.5545,5.3233,5.5515,6.7816,7.3017,6.5596,5.3169,5.5542,6.7819,7.3074,6.5615,5.3215,5.5389,6.7636,7.298,6.5745,5.3184,5.5254,6.7468,7.2995,6.577,5.3274,5.5163,6.7456,7.2932,6.5829,5.3212,5.5188,6.7246,7.2913,6.5882,5.3235,5.4974,6.715,7.2756,6.5824,5.3192,5.4885,6.7095,7.2724,6.5947,5.3323,5.4857,6.6998,7.2731,6.6062,5.3232,5.4655,6.6908,7.2677,6.6086,5.327,5.471,6.6804,7.2666,6.6106,5.3326,5.4547,6.6716,7.2584,6.61,5.3321,5.4415,6.6556,7.2512,6.6211,5.3275,5.4333,6.6541,7.2543,6.639,5.3387,5.4241,6.6356,7.2462,6.6375,5.337,5.4185,6.6279,7.2534,6.649,5.3396,5.4125,6.6163,7.2451,6.6549,5.3469,5.3998,6.6069,7.2326,6.6737,5.3486,5.3902,6.5997,7.237,6.672,5.3531,5.3909,6.5848,7.2299,6.6839,5.3567,5.3848,6.5787,7.2355,6.6852,5.3629,5.3751,6.5638,7.2286,6.6995,5.3695,5.3598,6.5614,7.226,6.704,5.3689,5.3568,6.5445,7.2227,6.7089,5.3782,5.3475,6.5419,7.2275,6.7237,5.384,5.3388,6.5279,7.2214,6.7239,5.3881,5.3318,6.5195,7.2136,6.7306,5.3974,5.3271,6.5055,7.2032,6.7445,5.3935,5.3167,6.5007,7.2088,6.7507,5.3947,5.3081,6.4886,7.1934,6.7593,5.3973,5.3012,6.4783,7.1916,6.7624,5.4005,5.2996,6.4664,7.2041,6.7602,5.415,5.2896,6.4518,7.185,6.7769,5.4176,5.2792,6.4423,7.183,6.7896,5.4127,5.2723,6.4369,7.178,6.7976,5.4245,5.2804,6.4222,7.1864,6.7946,5.4441,5.2642,6.421,7.1825,6.8068,5.4329,5.2616,6.4065,7.1797,6.8119,5.4499,5.2545,6.3968,7.1786,6.8312,5.4537,5.2525,6.3922,7.1756,6.8291,5.4634,5.2497,6.3843,7.1677,6.8413,5.4654,5.2439,6.3612,7.1734,6.8436,5.482,5.2322,6.3601,7.1566,6.8657,5.4824,5.2331,6.3444,7.1581,6.8522,5.4931,5.2172,6.3381,7.1591,6.8702,5.4958,5.2203,6.3292,7.1505,6.8627,5.5123,5.2124,6.3192,7.1472,6.8832,5.5097,5.2109,6.3075,7.1441,6.8876,5.5211,5.2091,6.2975,7.1273,6.8932,5.5205,5.1977,6.294,7.1191,6.9073,5.5394,5.1954,6.2788,7.1276,6.9168,5.5501,4.8002:2
0.0037596,-0.0030554,0.0013505,0.0021614,-0.0034263,0.0030075,-8.3898E-4,-0.0018248,0.0026482,-0.0045545,0.0015576,-0.0011788,-0.002376,0.0013668,-0.0056865,0.0016713,-0.0021701,-0.0021674,0.0016295,-0.0030801,0.0018035,-4.7716E-4,-7.0485E-4,0.0013971,-0.0055797,0.002645,0.39475,1.2249,0.94644,0.88106,0.99609,1.1485,1.1811,0.98133,0.85615,1.012,1.1475,1.1784,0.98726,0.85359,1.0133,1.1488,1.1825,0.99136,0.8554,1.0112,1.1465,1.1821,0.99465,0.85524,1.011,1.146,1.1865,0.99751,0.86139,1.0099,1.1561,1.1907,0.99989,0.86455,1.0095,1.1575,1.1944,1.0032,0.86734,1.0096,1.1566,1.1943,1.0084,0.8674,1.008,1.1611,1.1965,1.0106,0.86751,1.0094,1.1582,1.2004,1.0149,0.86802,1.0052,1.1574,1.2007,1.0162,0.8663,1.0065,1.1575,1.2014,1.019,0.86781,1.0024,1.1548,1.2012,1.0206,0.8663,0.99827,1.1499,1.1993,1.0187,0.86467,0.99743,1.1514,1.2035,1.0209,0.86669,0.99273,1.1506,1.1999,1.0243,0.86545,0.99372,1.1483,1.2023,1.0276,0.86824,0.99111,1.15,1.2026,1.0318,0.86738,0.99047,1.149,1.2022,1.0329,0.86698,0.98778,1.1465,1.2008,1.0321,0.86741,0.98406,1.1445,1.1995,1.0393,0.86243,0.97978,1.1421,1.2035,1.0399,0.86784,0.9798,1.1436,1.2038,1.046,0.86703,0.97982,1.1395,1.2062,1.048,0.86826,0.98059,1.139,1.2031,1.0494,0.86634,0.97563,1.1376,1.2049,1.0507,0.86769,0.97388,1.1343,1.2039,1.0532,0.86949,0.97367,1.1382,1.206,1.0574,0.86716,0.97068,1.1328,1.2058,1.0567,0.86901,0.96726,1.1321,1.2061,1.0603,0.86959,0.96511,1.1296,1.2052,1.0617,0.87102,0.96582,1.1311,1.2083,1.0657,0.87246,0.96356,1.1307,1.2064,1.0683,0.8714,0.95885,1.1255,1.2069,1.0661,0.87137,0.95767,1.1226,1.2033,1.0708,0.87212,0.95717,1.1232,1.2053,1.0722,0.87268,0.95242,1.1186,1.2032,1.0735,0.87176,0.9515,1.1163,1.2047,1.0758,0.87352,0.94937,1.1144,1.2041,1.0762,0.87345,0.94974,1.114,1.2023,1.0822,0.87441,0.94675,1.1113,1.2043,1.0827,0.87262,0.94719,1.1101,1.2038,1.0861,0.87631,0.94207,1.1095,1.2037,1.088,0.8773,0.94268,1.1076,1.2042,1.0891,0.87484,0.93757,1.1052,1.2022,1.0958,0.87924,0.93924,1.1051,1.2037,1.0957,0.87888,0.93623,1.1029,1.2012,1.0951,0.87827,0.93179,1.0971,1.2017,1.0986,0.87843,0.93173,1.0974,1.2053,1.0995,0.88241,0.9298,1.0937,1.1985,1.1024,0.88211,0.92781,1.0898,1.2036,1.1037,0.88463,0.92676,1.0903,1.2062,1.1087,0.88485,0.92859,1.0889,1.2065,1.1094,0.88687,0.92607,1.0865,1.2041,1.1129,0.88761,0.92215,1.0852,1.2017,1.1138,0.88783,0.92278,1.0835,1.2019,1.1138,0.89061,0.91872,1.0828,1.2028,1.1189,0.89167,0.9189,1.0811,1.205,1.1223,0.89256,0.91694,1.0767,1.2017,1.1233,0.89185,0.91705,1.0762,1.2027,1.1255,0.89418,0.91961,1.0748,1.2067,1.1257,0.89851,0.914,1.0719,1.2051,1.1307,0.89985,0.91376,1.0708,1.2112,1.1315,0.90409,0.91604,1.0702,1.2075,1.1321,0.90478,0.91295,1.0668,1.206,1.1348,0.9058,0.91125,1.0644,1.2039,1.1342,0.90652,0.90973,1.0631,1.2011,1.1398,0.90624,0.90888,1.06,1.202,1.1367,0.90994,0.90505,1.0586,1.1969,1.1414,0.90803,0.90379,1.0542,1.1975,1.1423,0.90995,0.90102,1.0488,1.1982,1.142,0.91317,0.89995,1.049,1.1938,1.1405,0.91174,0.89603,1.0444,1.1938,1.143,0.9155,0.89418,1.044,1.1948,1.1428,0.91767,0.8919,1.0408,1.1924,1.145,0.91724,0.89177,1.0386,1.1904,1.1484,0.91943,0.8907,1.0377,1.1909,1.1478,0.91842,0.89387,1.0341,1.1938,1.1511,0.92689,0.89323,1.0343,1.1949,1.1548,0.92776,0.89124,1.0304,1.1925,1.1562,0.93094,0.89074,1.0278,1.1893,1.1545,0.92984,0.88774,1.0263,1.1892,1.1543,0.93155,0.88576,1.0211,1.1856,1.1588,0.93265,0.88337,0.84305:2
-4.2316E-4,-9.796E-4,-0.0025775,-1.9997E-4,-0.0012294,-3.3452E-4,-0.0013837,-6.4103E-4,-0.0013917,-0.0021602,0.0010493,-0.0020897,-2.439E-4,-0.0027367,-8.6278E-4,-9.8573E-5,-7.8786E-4,-5.488E-4,-1.4738E-4,-9.9873E-4,5.8547E-4,-0.0012611,3.145E-4,-9.2034E-4,-0.0014041,-0.001254,0.0019434,-0.0012834,2.7583E-4,-0.0013789,-0.0014528,-0.0012818,0.34098,1.171,0.90137,0.87145,0.91997,1.1184,1.1265,0.94229,0.84071,0.93876,1.111,1.1281,0.95187,0.84027,0.94035,1.1123,1.1291,0.95784,0.83865,0.9391,1.1114,1.1316,0.95938,0.83934,0.93981,1.1139,1.1347,0.96151,0.84041,0.93705,1.1136,1.1349,0.96603,0.84236,0.93486,1.1134,1.1353,0.97042,0.84261,0.93249,1.1133,1.138,0.97222,0.84187,0.93403,1.1119,1.1416,0.97382,0.84482,0.93171,1.1091,1.1437,0.97664,0.82691,0.90348,1.0783,1.1124,0.9547,0.82177,0.90216,1.0752,1.111,0.95932,0.82504,0.90101,1.0821,1.1172,0.97212,0.83546,0.91631,1.1032,1.1397,0.98755,0.84523,0.92111,1.104,1.1428,0.99291,0.84466,0.91903,1.1012,1.1434,0.9961,0.8449,0.92167,1.0998,1.1515,0.99538,0.84509,0.91829,1.0992,1.1499,0.99952,0.84626,0.91799,1.0971,1.1506,1.0029,0.84681,0.91472,1.0979,1.1504,1.0068,0.8457,0.91495,1.0939,1.1524,1.0086,0.85,0.91034,1.0962,1.1506,1.01,0.85075,0.90902,1.0927,1.1486,1.0125,0.85021,0.90638,1.0932,1.1488,1.0152,0.85166,0.90267,1.0918,1.1479,1.0187,0.85298,0.90308,1.0888,1.152,1.0229,0.85194,0.90194,1.0876,1.1502,1.024,0.85313,0.89988,1.0832,1.1512,1.0241,0.85483,0.897,1.0789,1.1493,1.0294,0.85402,0.8964,1.0789,1.1533,1.0312,0.85578,0.89304,1.0797,1.1526,1.0336,0.85684,0.89372,1.0776,1.1526,1.0363,0.85633,0.8921,1.0737,1.1499,1.0376,0.85779,0.8889,1.075,1.1487,1.0422,0.85638,0.88811,1.0742,1.1518,1.0436,0.85975,0.88599,1.0713,1.1483,1.0475,0.86042,0.88397,1.07,1.1464,1.0502,0.86028,0.88307,1.0663,1.1496,1.0501,0.86214,0.88021,1.0644,1.1504,1.0543,0.86361,0.87802,1.063,1.1504,1.0541,0.86591,0.8751,1.0596,1.1493,1.0576,0.86506,0.87484,1.0565,1.15,1.0603,0.86755,0.87423,1.0581,1.1504,1.0603,0.86935,0.86981,1.0547,1.1513,1.0633,0.86979,0.87157,1.0505,1.1492,1.0674,0.86979,0.8699,1.0505,1.1483,1.0688,0.87205,0.86756,1.0461,1.1486,1.0699,0.87219,0.86478,1.0467,1.1465,1.0722,0.87372,0.86746,1.0441,1.1481,1.0739,0.87589,0.86355,1.0424,1.1456,1.078,0.87465,0.86206,1.0424,1.1439,1.0811,0.87891,0.86069,1.038,1.1472,1.0799,0.88055,0.85873,1.038,1.1441,1.0829,0.87892,0.85854,1.035,1.1473,1.0841,0.88147,0.85599,1.0324,1.1448,1.0846,0.88651,0.85433,1.0294,1.1409,1.0882,0.88507,0.85494,1.0288,1.1455,1.0876,0.88952,0.85336,1.0264,1.1409,1.0898,0.88834,0.85125,1.0265,1.1426,1.0908,0.89229,0.85005,1.0246,1.143,1.094,0.89258,0.84854,1.0219,1.14,1.0944,0.89133,0.84932,1.018,1.1429,1.0991,0.89538,0.84709,1.0176,1.14,1.0997,0.89465,0.8474,1.0127,1.1387,1.0993,0.89874,0.84545,1.0136,1.1358,1.1028,0.8998,0.8444,1.0095,1.1405,1.1025,0.90149,0.84492,1.0094,1.1369,1.1063,0.90467,0.8439,1.0086,1.1368,1.1083,0.90466,0.8432,1.0035,1.1353,1.109,0.90843,0.84099,1.0038,1.1337,1.1091,0.90949,0.83936,0.99954,1.1345,1.1111,0.91216,0.83961,0.99881,1.1325,1.1141,0.91444,0.83818,0.99549,1.1344,1.1128,0.91463,0.83878,0.99558,1.1303,1.1159,0.9184,0.83853,0.99298,1.1316,1.1189,0.91948,0.83902,0.99074,1.1304,1.1172,0.92077,0.83698,0.99005,1.1299,1.1213:2
-0.0014528,-3.6085E-4,-0.0034913,0.0014351,-0.00357,-0.0025138,9.8829E-4,-0.0031331,0.0015073,-0.003516,-4.5908E-4,0.0016956,-0.0037835,0.0027212,-0.0034041,-0.0013516,-0.0012155,-0.0041599,7.4667E-4,0.60778,1.1258,0.90305,0.84626,0.94053,1.1124,1.1133,0.9251,0.83031,0.9527,1.1136,1.1117,0.92826,0.8278,0.95833,1.1146,1.1143,0.93122,0.82929,0.95697,1.1141,1.1166,0.93304,0.83026,0.9553,1.1159,1.121,0.93474,0.83183,0.95752,1.1148,1.1241,0.9342,0.83284,0.95678,1.1144,1.1261,0.93566,0.83063,0.95722,1.1171,1.1265,0.93594,0.83534,0.95538,1.1207,1.1263,0.93743,0.83422,0.95647,1.1173,1.1301,0.93959,0.83448,0.95557,1.1204,1.1274,0.94146,0.8372,0.95815,1.1203,1.1303,0.94559,0.83668,0.95848,1.1179,1.1329,0.94473,0.83524,0.95619,1.1187,1.1298,0.94593,0.83364,0.95455,1.1165,1.1326,0.94676,0.83445,0.9534,1.1174,1.1322,0.94622,0.83531,0.9537,1.116,1.1327,0.9437,0.8344,0.95315,1.1161,1.1328,0.94807,0.83649,0.95192,1.1149,1.1318,0.94851,0.83647,0.95424,1.1167,1.1348,0.94994,0.83561,0.95119,1.118,1.1331,0.9497,0.83484,0.94973,1.1135,1.1327,0.94987,0.83662,0.94875,1.1158,1.1342,0.94942,0.83652,0.94862,1.1132,1.1372,0.94888,0.83497,0.94721,1.1147,1.1381,0.95067,0.8353,0.94517,1.1153,1.1348,0.95058,0.83501,0.94608,1.1134,1.1344,0.95266,0.83428,0.94231,1.1127,1.1346,0.95324,0.83593,0.94504,1.1133,1.1356,0.95299,0.83475,0.94449,1.1145,1.1363,0.95591,0.83357,0.94471,1.1124,1.1359,0.95863,0.83248,0.94401,1.1091,1.1365,0.95788,0.83263,0.94517,1.1084,1.1381,0.95625,0.83528,0.94197,1.1079,1.1394,0.95557,0.83564,0.93835,1.1073,1.1346,0.95626,0.8345,0.93872,1.1066,1.1344,0.95696,0.8342,0.93774,1.11,1.1371,0.95729,0.83326,0.93757,1.1107,1.136,0.95869,0.83325,0.93171,1.0777,1.0972,0.93267,0.80807,0.90651,1.0745,1.0985,0.93517,0.80646,0.90674,1.0723,1.0981,0.93463,0.80738,0.90661,1.0714,1.0973,0.93444,0.80697,0.90597,1.0704,1.102,0.94084,0.81127,0.91337,1.0806,1.1184,0.95652,0.8273,0.93039,1.0998,1.1323,0.96194,0.82925,0.93108,1.102,1.1367,0.96333,0.83207,0.93191,1.103,1.1345,0.96318,0.82971,0.93261,1.1005,1.1361,0.96649,0.82959,0.93046,1.1005,1.1326,0.96528,0.83003,0.93047,1.1028,1.1337,0.96614,0.82974,0.9301,1.1016,1.1348,0.96662,0.82856,0.92535,1.0983,1.1329,0.96764,0.83056,0.92774,1.0979,1.1316,0.96557,0.82997,0.9243,1.0974,1.1324,0.96819,0.82814,0.92371,1.0997,1.1331,0.96865,0.83073,0.92435,1.0975,1.1316,0.96928,0.8297,0.92482,1.0978,1.1297,0.97056,0.82889,0.92318,1.0969,1.1321,0.97152,0.82911,0.92205,1.097,1.1332,0.9722,0.82975,0.92241,1.0964,1.1319,0.97017,0.82948,0.92139,1.0963,1.1306,0.97237,0.82979,0.92119,1.093,1.1339,0.9737,0.82999,0.92001,1.0935,1.1356,0.97259,0.82989,0.92047,1.0917,1.1349,0.97524,0.83295,0.91884,1.093,1.1355,0.97721,0.83073,0.91864,1.0929,1.1362,0.97828,0.83137,0.92014,1.0913,1.1362,0.9765,0.83064,0.91746,1.0927,1.1358,0.98051,0.8326,0.91791,1.0921,1.1349,0.98017,0.82957,0.91652,1.094,1.1346,0.98107,0.83181,0.91726,1.0931,1.1362,0.98239,0.83046,0.91497,1.0909,1.132,0.97958,0.83161,0.91503,1.0942,1.1336,0.98238,0.83057,0.91501,1.0928,1.1348,0.984,0.83281,0.91487,1.0896,1.1335,0.98664,0.83141,0.91428,1.0916,1.1357,0.98496,0.83316,0.91194,1.0916,1.1319,0.98408,0.83129,0.91179,1.0888,1.1339,0.98734,0.83148,0.91069,1.0878,1.1349,0.98624,0.83291,0.91012,1.0869,1.1367,0.98679,0.83309,0.9098,1.0851,1.1359,0.98699,0.83123,0.90784,1.084:2
0.0025101,-0.0018499,1.7991E-4,0.0032823,-0.0017321,0.0034415,-5.9187E-4,-1.7503E-5,0.002154,-0.0028359,0.0022705,0.0010583,-0.0012886,0.0019048,-0.0023439,0.003899,-7.5701E-4,0.0023002,0.003018,-0.0024794,0.0032099,-0.0021524,-9.523E-4,0.0031342,-0.0039652,0.0035768,-0.0017449,-5.5433E-4,0.0051766,-0.0024806,0.0022799,-0.0011307,-9.5659E-4,0.0035711,-0.0029223,0.0036563,-4.3464E-6,-1.2455E-4,0.0015007,-0.0018704,0.0029311,0.0023549,-3.9763E-5,0.0023563,-0.0022841,0.0037392,8.6145E-4,-1.4765E-4,0.0046338,-0.0038321,0.0034861,-0.0015054,-3.6525E-4,0.0025027,-0.0037402,0.0034803,-2.0542E-4,-0.0038702,0.0028435,-0.0028011,0.0028375,-0.0019819,-0.0012084,0.0028606,-0.0018359,0.0021657,-1.4912E-4,-0.0020001,0.0042668,-0.0034519,0.0021594,7.638E-4,-7.6224E-4,0.0032349,-0.0024019,0.0033317,9.9829E-4,-0.0014868,0.0018833,-0.0014383,0.0040097,8.7794E-4,-0.0019543,0.0024546,-0.0022606,0.004454,4.5556E-4,9.2647E-4,0.0016335,-0.0014483,0.001834,0.0014768,-0.0019325,0.003316,-0.0039697,0.0020653,-3.4763E-4,-5.3009E-4,0.0016668,-0.0031888,0.002901,3.8407E-4,4.2437E-4,0.0012517,-4.1529E-4,0.0026333,-5.0319E-4,6.4563E-4,2.2135,2.2919,2.3019,2.895,3.0169,2.4675,2.2359,2.371,2.8743,2.9991,2.504,2.2062,2.3995,2.8686,2.9983,2.5081,2.2023,2.4056,2.8706,2.9951,2.5039,2.1989,2.4105,2.8704,2.9955,2.4987,2.1978,2.4096,2.875,2.9935,2.4953,2.197,2.4131,2.8749,2.9868,2.4892,2.1983,2.4144,2.8806,2.9875,2.4841,2.1956,2.4157,2.8839,2.987,2.4832,2.1962,2.4205,2.8827,2.9833,2.4784,2.1951,2.4212,2.8845,2.9772,2.4733,2.1907,2.4226,2.8834,2.9774,2.4677,2.1904,2.4246,2.8861,2.9709,2.4635,2.1877,2.4277,2.8811,2.9699,2.4566,2.1859,2.4285,2.8796,2.9636,2.4501,2.185,2.4278,2.8781,2.9622,2.4452,2.1817,2.4295,2.8804,2.9609,2.4365,2.1815,2.4294,2.8815,2.9556,2.4315,2.1794,2.4338,2.8793,2.9515,2.4263,2.1825,2.4351,2.8809,2.9488,2.4219,2.1797,2.4352,2.8825,2.9421,2.4146,2.1798,2.4362,2.8821,2.9395,2.4094,2.1754,2.4386,2.885,2.9369,2.404,2.1768,2.4395,2.8848,2.932,2.3977,2.1753,2.4437,2.8861,2.9267,2.3947,2.1719,2.443,2.8828,2.923,2.3873,2.1681,2.4415,2.8803,2.9158,2.3805,2.1662,2.445,2.878,2.9137,2.3738,2.1645,2.4451,2.8771,2.9098,2.3684,2.1634,2.4477,2.8759,2.9064,2.3628,2.1638,2.4477,2.875,2.8978,2.3561,2.1604,2.447,2.8749,2.893,2.3502,2.1589,2.4485,2.8771,2.8846,2.3429,2.1577,2.4505,2.8764,2.8825,2.3401,2.1592,2.4519,2.8763,2.8766,2.3319,2.1585,2.4506,2.8762,2.8707,2.3248,2.1556,2.4522,2.8742,2.8667,2.3202,2.1546,2.4514,2.8781,2.8607,2.3155,2.1526,2.4558,2.8725,2.8548,2.3075,2.1511,2.4582,2.8732,2.8519,2.3022,2.1508,2.4575,2.8732,2.8453,2.298,2.1516,2.4586,2.8719,2.8399,2.2909,2.1491,2.4562,2.8725,2.8367,2.288,2.1479,2.4578,2.871,2.831,2.2829,2.1473,2.4619,2.8733,2.8256,2.2764,2.1465,2.4636,2.8705,2.8189,2.2744,2.1462,2.4659,2.8715,2.8171,2.2657,2.145,2.4637,2.8681,2.81,2.2603,2.1424,2.4642,2.8632,2.8036,2.2543,2.1435,2.4665,2.8676,2.7995,2.2516,2.1436,2.4691,2.8695,2.7965,2.249,2.1418,2.472,2.8665,2.7893,2.2455,2.1425,2.472,2.8663,2.7828,2.2383,2.1414,2.4745,2.868,2.78,2.2353,2.1377,2.4733,2.8669,2.7748,2.2312,2.1408,2.4747,2.868,2.7672,2.2254,2.1393,2.4787,2.8659,2.7646,2.2217,2.1395,2.4778,2.8656,2.7606,2.2155,2.1406,2.4762,2.8658,2.7508,2.2105,2.14,2.4829,2.8678,2.747,2.2083,2.143,2.4834,2.8727,2.7399,2.2052,2.1413,2.4846,2.8689,2.734,2.1998,2.1412,2.4878,2.87,2.7291,2.1957,2.1403,2.4887,2.8687,2.7195,2.1901,2.1424,2.4906,2.8688,2.7155,2.1858,2.1428,2.4972,1.6381:2
7.0761E-4,0.0027211,-0.0034749,0.00268,-0.0010321,-9.7136E-6,0.0043806,-0.0028825,0.0039931,-7.3429E-4,2.9818E-4,5.0933E-4,-0.0021589,0.0026379,4.0682E-4,-0.0018896,0.0047189,-0.0016223,0.0035549,-0.0018189,-0.0010145,0.0042222,-0.0017975,8.1119E-4,-0.0011019,-5.1858E-4,0.0020194,-0.0029013,0.002441,4.3746E-4,0.0018658,0.0035846,-0.0019301,0.0060332,-0.0015529,-8.2893E-5,0.0025515,-0.0011388,0.0021171,-7.2182E-4,-0.0010693,0.0036034,-0.0023654,0.0040971,-6.218E-4,0.0021297,0.0021469,-0.0020885,0.0019116,-9.6095E-4,8.1985E-4,0.0018927,-0.0030692,0.0037375,-0.0018771,7.1764E-4,0.0044029,-0.0013279,0.0030799,-1.6343E-5,1.4063,2.9537,2.1667,2.4359,2.7322,3.0797,2.8237,2.2851,2.3425,2.7904,3.0822,2.7961,2.3161,2.3228,2.8083,3.0843,2.7911,2.3267,2.3228,2.8115,3.0853,2.7899,2.3293,2.3244,2.8155,3.0874,2.7917,2.3274,2.3267,2.8131,3.0857,2.7893,2.3263,2.3275,2.8126,3.0842,2.7885,2.3135,2.3238,2.8109,3.0832,2.7847,2.3145,2.3251,2.8104,3.0818,2.7812,2.3107,2.3285,2.8085,3.0831,2.7791,2.3093,2.3295,2.8147,3.0832,2.7731,2.3146,2.3274,2.8155,3.08,2.7729,2.3124,2.3284,2.815,3.0834,2.7657,2.3117,2.3264,2.8174,3.0799,2.7624,2.3087,2.3282,2.8169,3.0811,2.7585,2.3055,2.3255,2.8147,3.0775,2.7539,2.301,2.3277,2.8148,3.0726,2.7488,2.3012,2.3203,2.8124,3.0719,2.7463,2.2983,2.3201,2.815,3.07,2.745,2.298,2.3215,2.8102,3.0694,2.7386,2.2943,2.3192,2.8118,3.066,2.7449,2.2975,2.3272,2.8159,3.0721,2.7363,2.2926,2.3234,2.8168,3.0691,2.7349,2.2896,2.3246,2.811,3.066,2.7319,2.2894,2.3233,2.8107,3.0666,2.7255,2.2802,2.3237,2.804,3.0641,2.7224,2.2809,2.3201,2.7992,3.0604,2.7165,2.2768,2.3179,2.8036,3.0561,2.7132,2.2753,2.32,2.8011,3.0588,2.7085,2.2729,2.315,2.7996,3.0549,2.7053,2.2721,2.314,2.796,3.0517,2.6981,2.2692,2.3143,2.7977,3.0488,2.697,2.2657,2.3115,2.7964,3.0419,2.6959,2.2626,2.3086,2.7974,3.0419,2.6887,2.2602,2.3106,2.7959,3.0362,2.6845,2.2566,2.3099,2.7968,3.038,2.684,2.2545,2.3089,2.7942,3.0313,2.6809,2.2517,2.3095,2.7911,3.0329,2.6775,2.2492,2.3077,2.788,3.0301,2.6707,2.2476,2.3064,2.7824,3.0329,2.6664,2.2434,2.3049,2.7836,3.0294,2.6625,2.2415,2.3044,2.7815,3.0263,2.6551,2.2409,2.3009,2.7826,3.0235,2.652,2.2388,2.2988,2.7838,3.0213,2.6508,2.2378,2.2999,2.7832,3.0188,2.6457,2.2353,2.2979,2.7856,3.0147,2.6459,2.2323,2.3014,2.7817,3.0136,2.6435,2.2304,2.3008,2.7793,3.0123,2.6385,2.2264,2.2989,2.7765,3.0117,2.6373,2.2271,2.3005,2.7712,3.0125,2.6296,2.2244,2.2988,2.773,3.0099,2.6281,2.22,2.2986,2.7689,3.0096,2.6247,2.2228,2.2981,2.772,3.0195,2.6204,2.2201,2.3069,2.7785,3.0169,2.6173,2.2176,2.3029,2.775,3.0141,2.6169,2.2136,2.3074,2.777,3.0098,2.6139,2.2132,2.3059,2.7776,3.0092,2.6118,2.2118,2.3076,2.7778,3.0096,2.609,2.2091,2.3094,2.7765,3.0092,2.6037,2.2079,2.3077,2.776,3.0097,2.6007,2.207,2.3084,2.7758,3.0079,2.5959,2.2055,2.3063,2.7744,3.0037,2.593,2.2027,2.3082,2.7761,3.0054,2.5901,2.2024,2.3077,2.7759,3.0023,2.5874,2.202,2.3068,2.7766,3.0023,2.5832,2.1985,2.3071,2.775,3.0007,2.5789,2.1968,2.3084,2.7745,2.9994,2.5776,2.1937,2.3068,2.7746,2.9997,2.574,2.1969,2.3103,2.7757,2.9979,2.5692,2.1944,2.3103,2.7784,2.9984,2.5669,2.1929,2.3084,2.7776,2.9968,2.5675,2.1914,2.3078,2.7786,2.9967,2.5629,2.1928,0.80839:2
0.0046724,0.0011766,0.0046967,0.0031267,0.0014561,0.0042054,0.0012498,0.0044822,0.0034552,0.0022,0.0043026,9.4583E-4,0.0044055,0.0034491,0.0030148,0.0037206,0.0013692,0.0043518,0.0031297,0.0022457,0.0044959,0.00137,0.0045721,0.0033822,0.0018918,0.0035056,0.010657,0.40196,0.42928,0.40283,0.30674,0.33851,0.39674,0.42505,0.39301,0.31521,0.33236,0.39993,0.42622,0.39228,0.31682,0.33295,0.40084,0.4268,0.39338,0.31651,0.3331,0.40059,0.42806,0.39271,0.31692,0.33412,0.40157,0.42884,0.39323,0.31814,0.33433,0.40125,0.42812,0.39405,0.3177,0.33379,0.40198,0.42931,0.39318,0.31806,0.3344,0.40298,0.42941,0.3941,0.31757,0.33443,0.40281,0.42832,0.39281,0.31761,0.33485,0.40255,0.42913,0.39369,0.3171,0.33419,0.4026,0.42942,0.39336,0.3181,0.33548,0.40344,0.43055,0.39342,0.31877,0.33446,0.40367,0.43073,0.39307,0.31839,0.33584,0.40244,0.42965,0.39322,0.31773,0.3346,0.40236,0.42976,0.39189,0.31711,0.33469,0.40301,0.42898,0.39243,0.31668,0.33413,0.40378,0.43019,0.39188,0.31657,0.33498,0.40319,0.42922,0.39146,0.31695,0.33465,0.40282,0.42959,0.39164,0.31626,0.33435,0.40204,0.42854,0.39074,0.31622,0.33494,0.40245,0.42859,0.3901,0.31606,0.33477,0.4035,0.42857,0.38981,0.31527,0.33512,0.40273,0.42813,0.39052,0.31528,0.33475,0.40265,0.42917,0.39032,0.31579,0.33486,0.4026,0.42781,0.38967,0.31463,0.33482,0.40267,0.42779,0.38763,0.31535,0.33443,0.40183,0.42711,0.38796,0.31472,0.33457,0.40148,0.42713,0.38762,0.31451,0.33414,0.40205,0.42598,0.38734,0.31427,0.33418,0.4024,0.42723,0.38734,0.31414,0.33405,0.40164,0.42593,0.38611,0.31332,0.33329,0.40172,0.4254,0.38624,0.31339,0.33446,0.40202,0.42577,0.38568,0.31274,0.33369,0.40186,0.42593,0.38463,0.31316,0.33353,0.40154,0.42508,0.38519,0.31208,0.33344,0.40057,0.42443,0.38507,0.31323,0.33325,0.40134,0.42456,0.38459,0.31174,0.33355,0.40107,0.42407,0.38348,0.31178,0.33296,0.40027,0.42356,0.3828,0.31057,0.33309,0.4004,0.42303,0.38183,0.3111,0.33298,0.40054,0.42303,0.38126,0.31093,0.33269,0.39919,0.4223,0.3809,0.31032,0.33224,0.39901,0.42181,0.38114,0.31,0.33134,0.3988,0.42076,0.37967,0.30967,0.33168,0.39875,0.4207,0.37982,0.30884,0.33148,0.39958,0.42039,0.37895,0.30912,0.33224,0.39854,0.42043,0.37847,0.30786,0.33155,0.3985,0.42077,0.37838,0.30839,0.33163,0.39787,0.4205,0.37738,0.30742,0.33138,0.39849,0.42037,0.37767,0.3077,0.33127,0.39839,0.41934,0.37707,0.30768,0.3308,0.39856,0.41904,0.3757,0.30642,0.33074,0.39734,0.4186,0.37583,0.30678,0.33122,0.39721,0.41772,0.37549,0.30635,0.33089,0.3974,0.41709,0.37477,0.30553,0.33011,0.39716,0.4172,0.37414,0.30605,0.33089,0.39741,0.41737,0.3733,0.30489,0.33027,0.39639,0.41705,0.37314,0.30477,0.32938,0.39668,0.41645,0.37227,0.30476,0.33021,0.39642,0.41549,0.37207,0.30438,0.33002,0.39669,0.41667,0.37178,0.30419,0.33019,0.39592,0.41553,0.37237,0.30451,0.33079,0.39597,0.41423,0.37058,0.30362,0.32925,0.39564,0.41517,0.37079,0.30369,0.32881,0.39565,0.41424,0.36962,0.30313,0.33008,0.39544,0.41383,0.36922,0.30265,0.32887,0.39521,0.41472,0.3686,0.30278,0.32964,0.39552,0.41457,0.36845,0.30275,0.33013,0.39519,0.41395,0.36855,0.30236,0.3293,0.39602,0.41359,0.36833,0.30221,0.32924,0.3956,0.41348,0.36732,0.30199,0.33016,0.3958,0.41337,0.36635,0.30232,0.32996,0.39599,0.4126,0.36633,0.30062,0.32926,0.39544,0.41249,0.36712,0.30119,0.32892,0.39533,0.4121,0.36651,0.30099,0.32985,0.39559,0.41201,0.36546,0.30066,0.32977,0.39531,0.41211,0.36505,0.30021,0.33003,0.39506,0.41172,0.36534,0.30068,0.32937,0.39534,0.41177,0.36459,0.30048,0.32901,0.39527,0.41121,0.3639,0.29998,0.32889,0.39642,0.41168,0.36364,0.29985,0.29912:2
0.0032303,0.0014436,0.0033116,0.0032371,0.001792,0.0029335,0.0011324,0.003527,0.0037241,0.0017161,0.0031012,0.0011864,0.0040462,0.003348,0.001241,0.0033291,0.0011299,0.0033789,0.0026015,0.0025931,0.0030001,0.056939,0.4349,0.39524,0.34902,0.29966,0.37541,0.41797,0.4062,0.33717,0.3098,0.37018,0.41917,0.4075,0.33555,0.31069,0.37003,0.42017,0.40815,0.33652,0.31137,0.37107,0.42086,0.40827,0.33745,0.31161,0.37088,0.4217,0.40834,0.33776,0.31155,0.37015,0.42205,0.40864,0.33655,0.31225,0.37161,0.42318,0.40982,0.33742,0.31236,0.37286,0.42309,0.41036,0.33762,0.31312,0.37209,0.42387,0.41,0.33873,0.31254,0.37283,0.42345,0.41001,0.33781,0.31267,0.37207,0.42353,0.40864,0.33706,0.312,0.37205,0.42284,0.40922,0.33745,0.31216,0.37237,0.42307,0.40911,0.33703,0.31136,0.37175,0.42261,0.40867,0.33716,0.31216,0.37241,0.42304,0.40952,0.33672,0.31215,0.37246,0.42339,0.40865,0.33628,0.31272,0.37318,0.42295,0.4088,0.33612,0.31243,0.37265,0.42276,0.40851,0.33593,0.31175,0.37259,0.4235,0.40906,0.33658,0.31224,0.37214,0.42349,0.40797,0.33631,0.31222,0.37226,0.42292,0.40834,0.33633,0.31233,0.37359,0.42254,0.40788,0.3353,0.31215,0.37189,0.42276,0.4086,0.33545,0.31267,0.373,0.42306,0.40777,0.33597,0.31197,0.37212,0.42287,0.40764,0.33497,0.3119,0.37179,0.42236,0.40797,0.33461,0.31188,0.37163,0.4223,0.40713,0.33416,0.31137,0.37109,0.4218,0.40657,0.33375,0.31091,0.37096,0.4221,0.40655,0.33442,0.311,0.37097,0.42184,0.40578,0.333,0.31089,0.37072,0.42122,0.40563,0.33336,0.31088,0.37117,0.42136,0.40596,0.33363,0.31137,0.37076,0.42128,0.40477,0.33242,0.31058,0.37043,0.42029,0.4047,0.33295,0.31078,0.37043,0.42081,0.40467,0.3323,0.30957,0.3699,0.41953,0.40347,0.33208,0.30981,0.37041,0.42036,0.40396,0.33206,0.30969,0.37064,0.41953,0.40369,0.33123,0.30866,0.36926,0.41923,0.40301,0.33046,0.30895,0.37003,0.41835,0.4023,0.33055,0.30877,0.36969,0.41834,0.40169,0.32968,0.30853,0.3692,0.41791,0.40126,0.3303,0.30825,0.36981,0.41829,0.40163,0.33024,0.30893,0.36935,0.41765,0.40075,0.32943,0.30878,0.36925,0.41882,0.40084,0.32846,0.30859,0.36945,0.41807,0.40062,0.32896,0.30874,0.3705,0.41818,0.40031,0.32787,0.30773,0.36853,0.41767,0.39919,0.32792,0.30841,0.37015,0.41709,0.39944,0.32743,0.30757,0.36933,0.41741,0.39977,0.3273,0.30781,0.36872,0.41694,0.39758,0.32687,0.30738,0.36945,0.41736,0.39853,0.32666,0.30717,0.36835,0.41547,0.39716,0.32522,0.30717,0.36852,0.41665,0.39657,0.32529,0.30697,0.3688,0.41507,0.39661,0.32435,0.30717,0.36893,0.41562,0.39616,0.32469,0.30656,0.36878,0.41533,0.39575,0.32523,0.30658,0.36835,0.41489,0.39518,0.3234,0.30743,0.36835,0.41538,0.39466,0.32307,0.30655,0.36805,0.41503,0.39522,0.32414,0.30667,0.3682,0.41379,0.39434,0.32325,0.30628,0.36895,0.41494,0.39512,0.32339,0.30699,0.36751,0.41404,0.39417,0.3223,0.30628,0.36889,0.41379,0.39414,0.3217,0.30626,0.36918,0.41412,0.39344,0.32149,0.30566,0.36816,0.41317,0.39271,0.32112,0.30603,0.36823,0.41379,0.39224,0.32091,0.30614,0.36771,0.41333,0.39264,0.32043,0.30576,0.36842,0.41304,0.39131,0.32105,0.30635,0.36882,0.41404,0.39162,0.32038,0.30561,0.3687,0.41288,0.39106,0.31954,0.30535,0.36708,0.4126,0.39112,0.31984,0.30597,0.36885,0.41293,0.39049,0.31945,0.30504,0.36904,0.41254,0.39055,0.31842,0.30464,0.36789,0.41187,0.38923,0.31804,0.30505,0.36841,0.41118,0.38885,0.31704,0.30468,0.36793,0.4121,0.38803,0.31767,0.30395,0.36833,0.41122,0.3882,0.31758,0.30596,0.36772,0.41145,0.38727,0.31681,0.30463,0.36836,0.41037,0.38774,0.31597,0.30447,0.36827,0.41063,0.38679,0.31642,0.3041,0.36891,0.41025,0.38708,0.31621,0.30442,0.36858,0.40953,0.38597,0.31592,0.30424,0.36849,0.41045,0.10674:2
0.0037763,8.1979E-4,0.0041068,0.0030751,0.0033035,0.0044716,9.7571E-4,0.0039867,0.0029218,0.0028613,0.0044291,0.0016111,0.0040382,0.0026005,0.0030572,0.0049808,0.0020644,0.004017,0.0024402,0.0030881,0.0050079,0.002189,0.0041252,0.0026242,0.0037163,0.0042448,0.0015325,0.0039414,0.0025397,0.0032335,0.0041939,0.0010743,0.0034554,0.0031636,0.0031379,0.0049123,0.0016749,0.0038609,0.002642,0.0031097,0.0044342,0.0010751,0.0042774,0.0023261,0.0033955,0.0040601,0.0013781,0.0041679,0.0029164,0.0039715,0.0043905,0.0015036,0.004525,0.0027393,0.0035998,0.0039673,0.0015076,0.0045024,0.0027266,0.0030369,0.0042882,9.9668E-4,0.0044201,0.0016975,0.0033203,0.0041093,0.0018653,0.0035456,0.0022384,0.0032815,0.0043935,0.0012138,0.0038008,0.0020138,0.0032746,0.0035548,0.0011112,0.0037324,0.0024417,0.0029104,0.0045162,0.0011687,0.0038575,0.0030428,0.0031336,0.0043003,0.0016761,0.0038452,0.0021301,0.0030782,0.0037754,0.0012658,0.0037519,0.0025355,0.0031332,0.0045728,0.0015683,0.0034637,0.0022664,0.0035257,0.0038206,8.0969E-4,0.0038216,0.0032502,0.0034553,0.003479,0.0010942,0.0036752,0.0023349,0.0030924,0.0039891,0.0010046,0.0033391,0.0022323,0.0026514,0.0033745,0.0016123,0.0038303,0.0027459,0.0028054,0.0036764,0.001062,0.0035534,0.0017813,0.002252,0.0040444,0.0020327,0.0038247,0.001849,0.0033029,0.011664,0.31255,0.35336,0.39647,0.4172,0.37245,0.30728,0.33497,0.40315,0.41977,0.37055,0.31099,0.33356,0.40458,0.41956,0.3683,0.31039,0.33349,0.40479,0.41898,0.36842,0.31035,0.33438,0.40531,0.42001,0.36768,0.3105,0.33516,0.40583,0.42016,0.36667,0.31081,0.33558,0.40653,0.41993,0.36704,0.31012,0.33628,0.40715,0.42046,0.3657,0.31037,0.33637,0.40773,0.42045,0.3666,0.31031,0.33676,0.40867,0.42063,0.36589,0.31109,0.33762,0.40852,0.42114,0.3655,0.31135,0.33881,0.41038,0.42138,0.36513,0.31109,0.33824,0.40999,0.42111,0.36352,0.31166,0.33898,0.40966,0.42139,0.3632,0.31095,0.33938,0.41006,0.42089,0.36247,0.31096,0.3401,0.41119,0.42066,0.36113,0.31106,0.33993,0.41118,0.4202,0.3609,0.31032,0.34017,0.41148,0.42019,0.35998,0.31064,0.34089,0.41116,0.42036,0.35974,0.31021,0.3417,0.41153,0.41968,0.3599,0.31012,0.34152,0.41246,0.41932,0.35871,0.30967,0.34247,0.41199,0.41962,0.35864,0.31044,0.34343,0.41232,0.41995,0.35811,0.31057,0.34327,0.41231,0.41976,0.35648,0.30994,0.34353,0.41283,0.41962,0.35554,0.31012,0.34467,0.41311,0.41978,0.3547,0.30971,0.34483,0.41183,0.41875,0.35317,0.30924,0.34406,0.41357,0.41754,0.35312,0.30992,0.34474,0.41279,0.41732,0.35195,0.30893,0.34482,0.41283,0.41698,0.35101,0.30849,0.34487,0.4125,0.41659,0.35157,0.3089,0.346,0.41361,0.4162,0.34984,0.30878,0.3455,0.41261,0.41447,0.34889,0.30871,0.3463,0.41291,0.41477,0.34926,0.30786,0.34554,0.41203,0.41466,0.3471,0.30717,0.34652,0.41361,0.41403,0.347,0.30767,0.34698,0.41376,0.41468,0.34611,0.30781,0.34737,0.4132,0.41406,0.34559,0.30803,0.34759,0.41418,0.41475,0.34512,0.30738,0.34802,0.41356,0.4133,0.34383,0.30786,0.34799,0.41419,0.41239,0.34302,0.30643,0.34784,0.41342,0.41173,0.34229,0.30722,0.34937,0.41302,0.41131,0.34129,0.30656,0.34876,0.41221,0.41067,0.34051,0.30671,0.34921,0.41266,0.40936,0.33921,0.3062,0.34887,0.41251,0.40894,0.33813,0.30656,0.3504,0.4127,0.40835,0.33727,0.30651,0.35042,0.41315,0.40913,0.33681,0.30654,0.34977,0.41377,0.40817,0.33656,0.30715,0.3518,0.41322,0.40857,0.3356,0.30699,0.35213,0.4129,0.40699,0.33419,0.30675,0.35274,0.41299,0.40704,0.33459,0.306,0.35193,0.41279,0.40589,0.3325,0.3058,0.35294,0.4125,0.40479,0.33232,0.3058,0.35335,0.41289,0.40384,0.33094,0.30446,0.35383,0.41191,0.404,0.33001,0.30523,0.35342,0.4128,0.40257,0.32948,0.305,0.35346,0.41238,0.40244,0.32893,0.30593,0.35514,0.41237,0.40249,0.32801,0.30564,0.35422,0.4126,0.40224,0.32838,0.30569,0.35499,0.41216,0.4015,0.327,0.30601,0.35555,0.41157,0.40036:2
1.9733E-6,4.6333E-7,-5.6667E-8,1.7633E-6,-1.3167E-6,2.05E-6,-4.0333E-7,2.0333E-7,1.1867E-6,-1.24E-6,1.78E-6,5.4667E-7,-1.6667E-8,3.4767E-6,-1.32E-6,2.2867E-6,-4.1667E-7,-4.6E-7,1.1167E-6,-1.5633E-6,2.5267E-6,-1.7667E-7,8.3333E-8,1.2633E-6,-8.4E-7,2.1767E-6,5.5667E-7,-1.1667E-7,1.3033E-6,-1.08E-6,2.3E-6,-4.2E-7,-3.0333E-7,1.6767E-6,-1.27E-6,2.2667E-6,4.3333E-8,-1.2E-7,1.87E-6,-1.4433E-6,1.99E-6,-4.0333E-7,3.3E-7,1.9267E-6,-7.4333E-7,2.1967E-6,-2.1667E-7,-5.5333E-7,2.3E-6,-1.0633E-6,2.0033E-6,-3.9667E-7,6.677E-5,2.0149E-4,1.3126E-4,1.3898E-4,1.4639E-4,1.6964E-4,1.8576E-4,1.3737E-4,1.3488E-4,1.5033E-4,1.7094E-4,1.8281E-4,1.3809E-4,1.3416E-4,1.5058E-4,1.7036E-4,1.8423E-4,1.4013E-4,1.349E-4,1.5142E-4,1.7088E-4,1.8379E-4,1.3984E-4,1.3496E-4,1.523E-4,1.6956E-4,1.8379E-4,1.3947E-4,1.3407E-4,1.537E-4,1.6977E-4,1.8338E-4,1.4145E-4,1.3362E-4,1.5373E-4,1.7057E-4,1.8229E-4,1.4063E-4,1.3323E-4,1.529E-4,1.7183E-4,1.831E-4,1.414E-4,1.3318E-4,1.5318E-4,1.7092E-4,1.8407E-4,1.4199E-4,1.3336E-4,1.535E-4,1.713E-4,1.8442E-4,1.4118E-4,1.3352E-4,1.5257E-4,1.7124E-4,1.8452E-4,1.4214E-4,1.3375E-4,1.5259E-4,1.7133E-4,1.8332E-4,1.4333E-4,1.3375E-4,1.533E-4,1.7041E-4,1.8236E-4,1.4182E-4,1.3349E-4,1.5454E-4,1.7076E-4,1.8348E-4,1.419E-4,1.3367E-4,1.5317E-4,1.7144E-4,1.846E-4,1.4375E-4,1.3393E-4,1.5466E-4,1.713E-4,1.8541E-4,1.4411E-4,1.3365E-4,1.5453E-4,1.7145E-4,1.8472E-4,1.4387E-4,1.3285E-4,1.5339E-4,1.7022E-4,1.8616E-4,1.432E-4,1.3247E-4,1.5401E-4,1.7132E-4,1.8476E-4,1.4377E-4,1.3259E-4,1.5303E-4,1.7101E-4,1.818E-4,1.4303E-4,1.3176E-4,1.541E-4,1.7062E-4,1.8352E-4,1.4332E-4,1.3181E-4,1.5355E-4,1.7003E-4,1.8362E-4,1.4273E-4,1.3212E-4,1.5367E-4,1.7078E-4,1.8428E-4,1.4337E-4,1.3157E-4,1.544E-4,1.7082E-4,1.8503E-4,1.4463E-4,1.3176E-4,1.5241E-4,1.6995E-4,1.8472E-4,1.446E-4,1.3093E-4,1.5259E-4,1.7018E-4,1.8515E-4,1.4504E-4,1.3288E-4,1.5424E-4,1.6852E-4,1.8484E-4,1.4496E-4,1.3169E-4,1.5343E-4,1.703E-4,1.8318E-4,1.4403E-4,1.3256E-4,1.5353E-4,1.7049E-4,1.8446E-4,1.4439E-4,1.317E-4,1.5373E-4,1.7003E-4,1.8584E-4,1.451E-4,1.3138E-4,1.5357E-4,1.6944E-4,1.8469E-4,1.433E-4,1.311E-4,1.5264E-4,1.6993E-4,1.8463E-4,1.4494E-4,1.3177E-4,1.5397E-4,1.6931E-4,1.8521E-4,1.4546E-4,1.3228E-4,1.5337E-4,1.7015E-4,1.8503E-4,1.4495E-4,1.3176E-4,1.5375E-4,1.6832E-4,1.8457E-4,1.4439E-4,1.3185E-4,1.5291E-4,1.6578E-4,1.8355E-4,1.4466E-4,1.319E-4,1.5206E-4,1.6936E-4,1.8444E-4,1.4535E-4,1.3072E-4,1.5318E-4,1.6804E-4,1.8375E-4,1.4486E-4,1.3154E-4,1.5352E-4,1.6867E-4,1.8405E-4,1.4338E-4,1.3138E-4,1.526E-4,1.6907E-4,1.8451E-4,1.4578E-4,1.2988E-4,1.5147E-4,1.6784E-4,1.8478E-4,1.4524E-4,1.3125E-4,1.5178E-4,1.6681E-4,1.8446E-4,1.447E-4,1.3126E-4,1.5318E-4,1.6695E-4,1.8287E-4,1.4562E-4,1.3133E-4,1.5241E-4,1.667E-4,1.8455E-4,1.4465E-4,1.2979E-4,1.5362E-4,1.6741E-4,1.8257E-4,1.4436E-4,1.3036E-4,1.5165E-4,1.6737E-4,1.8389E-4,1.4468E-4,1.2973E-4,1.512E-4,1.6788E-4,1.84E-4,1.445E-4,1.3064E-4,1.5164E-4,1.6721E-4,1.8402E-4,1.4468E-4,1.297E-4,1.5168E-4,1.6759E-4,1.8365E-4,1.4517E-4,1.2932E-4,1.5231E-4,1.6735E-4,1.8533E-4,1.4637E-4,1.2998E-4,1.5143E-4,1.6778E-4,1.841E-4,1.4589E-4,1.2975E-4,1.519E-4,1.6719E-4,1.8555E-4,1.4522E-4,1.3048E-4,1.5164E-4,1.6679E-4,1.8496E-4,1.4559E-4,1.2936E-4,1.5127E-4,1.672E-4,1.8551E-4,1.4576E-4,1.3106E-4,1.5023E-4,1.6631E-4,1.849E-4,1.4553E-4,1.2907E-4,1.5144E-4,1.6624E-4,1.8398E-4,1.4503E-4,1.2966E-4,1.511E-4,1.66E-4,1.8449E-4,1.4629E-4:2
1.5533E-6,-1.28E-6,1.8867E-6,2.6667E-7,6.9E-7,1.2167E-6,-1.4067E-6,2.2E-6,-9.1333E-7,1.5333E-7,9.9333E-7,-7.3333E-7,1.7933E-6,-1.3E-7,6.3E-7,1.9E-7,-8.6E-7,1.8833E-6,7.0E-8,-8.3333E-7,1.06E-6,-1.5233E-6,1.8033E-6,-1.7333E-7,1.2633E-6,1.0767E-6,-1.5967E-6,1.8533E-6,-6.4667E-7,2.4333E-7,1.15E-6,-6.7667E-7,1.71E-6,-6.6667E-8,4.7333E-7,1.1E-6,-9.3E-7,1.64E-6,1.8333E-7,5.1E-7,2.1633E-6,1.3446E-4,1.3925E-4,1.3538E-4,1.6119E-4,1.8647E-4,1.4043E-4,1.3239E-4,1.4246E-4,1.647E-4,1.8323E-4,1.4585E-4,1.3069E-4,1.4564E-4,1.6389E-4,1.8353E-4,1.471E-4,1.3063E-4,1.447E-4,1.6455E-4,1.8422E-4,1.4798E-4,1.3171E-4,1.4566E-4,1.6476E-4,1.8412E-4,1.4919E-4,1.3003E-4,1.4434E-4,1.6335E-4,1.8174E-4,1.4921E-4,1.2985E-4,1.4471E-4,1.6379E-4,1.8421E-4,1.5001E-4,1.3097E-4,1.47E-4,1.6401E-4,1.8498E-4,1.5071E-4,1.3056E-4,1.4656E-4,1.6369E-4,1.8584E-4,1.51E-4,1.3036E-4,1.4696E-4,1.6329E-4,1.8406E-4,1.5156E-4,1.2991E-4,1.468E-4,1.6471E-4,1.8439E-4,1.5167E-4,1.2965E-4,1.4653E-4,1.6306E-4,1.8576E-4,1.5344E-4,1.2969E-4,1.4694E-4,1.6368E-4,1.8653E-4,1.5341E-4,1.2987E-4,1.4569E-4,1.6159E-4,1.8605E-4,1.5471E-4,1.295E-4,1.4684E-4,1.6242E-4,1.8619E-4,1.5346E-4,1.2966E-4,1.4645E-4,1.6263E-4,1.8434E-4,1.549E-4,1.2952E-4,1.4773E-4,1.6232E-4,1.8605E-4,1.5567E-4,1.2983E-4,1.4666E-4,1.6204E-4,1.8672E-4,1.5465E-4,1.2896E-4,1.466E-4,1.6166E-4,1.8515E-4,1.5517E-4,1.2945E-4,1.4584E-4,1.635E-4,1.8652E-4,1.5553E-4,1.2961E-4,1.4481E-4,1.622E-4,1.8541E-4,1.5641E-4,1.2949E-4,1.455E-4,1.6124E-4,1.8623E-4,1.5606E-4,1.2918E-4,1.4579E-4,1.6136E-4,1.8702E-4,1.553E-4,1.2969E-4,1.4558E-4,1.6035E-4,1.8474E-4,1.5816E-4,1.2943E-4,1.4446E-4,1.6064E-4,1.8621E-4,1.5866E-4,1.2983E-4,1.4523E-4,1.6074E-4,1.8561E-4,1.5807E-4,1.293E-4,1.4468E-4,1.596E-4,1.8679E-4,1.5884E-4,1.2998E-4,1.4516E-4,1.5923E-4,1.8703E-4,1.5811E-4,1.295E-4,1.4553E-4,1.6048E-4,1.8683E-4,1.5804E-4,1.3005E-4,1.4489E-4,1.5975E-4,1.8572E-4,1.5898E-4,1.295E-4,1.4377E-4,1.5988E-4,1.8562E-4,1.5896E-4,1.2922E-4,1.4443E-4,1.594E-4,1.8508E-4,1.5973E-4,1.292E-4,1.4522E-4,1.5906E-4,1.855E-4,1.5975E-4,1.2883E-4,1.4503E-4,1.5991E-4,1.8511E-4,1.6023E-4,1.298E-4,1.4521E-4,1.5908E-4,1.8588E-4,1.6003E-4,1.2978E-4,1.4246E-4,1.5832E-4,1.8518E-4,1.5958E-4,1.296E-4,1.4426E-4,1.5955E-4,1.8434E-4,1.5921E-4,1.3043E-4,1.4505E-4,1.5947E-4,1.8429E-4,1.6059E-4,1.3022E-4,1.4495E-4,1.5727E-4,1.8348E-4,1.5963E-4,1.3031E-4,1.4319E-4,1.5837E-4,1.8575E-4,1.614E-4,1.2976E-4,1.4436E-4,1.5751E-4,1.8444E-4,1.6044E-4,1.2951E-4,1.4292E-4,1.569E-4,1.8375E-4,1.6052E-4,1.2866E-4,1.4416E-4,1.567E-4,1.8461E-4,1.6207E-4,1.2856E-4,1.4299E-4,1.5685E-4,1.8371E-4,1.6243E-4,1.2927E-4,1.4323E-4,1.568E-4,1.8389E-4,1.6311E-4,1.3031E-4,1.4324E-4,1.5647E-4,1.8419E-4,1.6146E-4,1.2882E-4,1.421E-4,1.5604E-4,1.8284E-4,1.615E-4,1.2946E-4,1.43E-4,1.5547E-4,1.8369E-4,1.6302E-4,1.2897E-4,1.4237E-4,1.5622E-4,1.8298E-4,1.6207E-4,1.2896E-4,1.4211E-4,1.5711E-4,1.845E-4,1.6285E-4,1.2979E-4,1.4245E-4,1.5548E-4,1.8388E-4,1.6357E-4,1.2859E-4,1.4271E-4,1.5659E-4,1.8353E-4,1.6216E-4,1.2995E-4,1.4252E-4,1.5556E-4,1.8386E-4,1.6358E-4,1.3057E-4,1.4297E-4,1.5552E-4,1.841E-4,1.6419E-4,1.3077E-4,1.4158E-4,1.5525E-4,1.83E-4,1.6327E-4,1.2982E-4,1.4189E-4,1.5644E-4,1.8311E-4,1.6473E-4,1.3079E-4,1.4129E-4,1.5478E-4,1.8345E-4,1.6437E-4,1.2908E-4,1.4142E-4,1.5522E-4,1.8368E-4,1.6502E-4,1.3015E-4,1.4073E-4,1.5534E-4,1.8346E-4,1.6611E-4,1.3024E-4,1.3962E-4,1.542E-4,1.8338E-4,1.6641E-4,1.2972E-4,1.4073E-4,1.5504E-4,1.83E-4,1.669E-4,1.3044E-4,1.4002E-4,1.5482E-4,1.8287E-4,1.6637E-4,1.2994E-4,1.3949E-4,1.5319E-4,1.8121E-4,1.6664E-4,1.3082E-4,1.4006E-4,1.5378E-4,1.8137E-4,1.6666E-4,1.3089E-4,1.4032E-4,1.5417E-4,1.8166E-4,1.6734E-4,1.3114E-4,1.3958E-4,1.5316E-4,1.8202E-4,1.6644E-4,1.3057E-4,1.4028E-4,1.5246E-4,1.8136E-4,1.6849E-4,1.3016E-4,1.3875E-4,1.5378E-4,1.7997E-4,1.672E-4,1.3146E-4,1.4037E-4,1.5266E-4,1.8012E-4,1.6792E-4,1.302E-4,1.3992E-4,1.5282E-4,1.807E-4,1.6686E-4,1.3109E-4,1.3987E-4,1.525E-4,1.8091E-4,1.6783E-4,1.3085E-4,1.3875E-4,1.5269E-4,1.7948E-4,1.6708E-4,1.3115E-4,3.3687E-5:2
-3.0065E-4,4.5419E-4,-4.545E-5,-3.177E-5,1.7061E-4,-2.5531E-4,4.3189E-4,-2.158E-4,6.02E-6,1.6714E-4,-3.6796E-4,4.1387E-4,-4.8494E-4,-6.0763E-5,1.9696E-4,-5.0098E-4,4.5885E-4,-1.6652E-4,3.022E-5,1.7888E-4,-3.2701E-4,4.4309E-4,-2.575E-4,2.0347E-4,4.329E-4,-2.473E-4,3.9657E-4,-5.3183E-4,4.369E-5,7.969E-5,-1.3853E-4,0.077919,0.12921,0.13947,0.13321,0.11206,0.10405,0.12552,0.14048,0.13425,0.11196,0.10474,0.12537,0.14067,0.13482,0.11207,0.10462,0.12512,0.14062,0.1345,0.11225,0.10466,0.12493,0.14079,0.13488,0.11264,0.10455,0.12511,0.14099,0.13527,0.11299,0.10439,0.12477,0.1409,0.13559,0.11305,0.10431,0.12426,0.14074,0.13584,0.11337,0.1041,0.1245,0.14076,0.13634,0.11338,0.10439,0.12408,0.14044,0.13601,0.11354,0.10412,0.12383,0.14033,0.13649,0.11378,0.10395,0.12358,0.14043,0.13652,0.11388,0.10389,0.12333,0.14014,0.13664,0.11398,0.10412,0.12315,0.14005,0.13697,0.114,0.10376,0.12278,0.14003,0.13684,0.11417,0.10342,0.12255,0.14013,0.13736,0.11468,0.1036,0.12251,0.13985,0.13731,0.11457,0.10331,0.12212,0.13951,0.13717,0.1151,0.10336,0.12212,0.1394,0.13776,0.11529,0.10327,0.1217,0.1391,0.13756,0.1154,0.103,0.1215,0.13889,0.13788,0.11552,0.10299,0.1213,0.13866,0.13799,0.11582,0.10273,0.12082,0.13842,0.13796,0.11601,0.10298,0.12069,0.1385,0.13809,0.11613,0.10291,0.11997,0.13843,0.13834,0.11632,0.10277,0.12024,0.13821,0.1383,0.11637,0.10272,0.11975,0.1381,0.13848,0.11651,0.10278,0.11974,0.13817,0.13869,0.11673,0.10253,0.11897,0.13754,0.13859,0.11698,0.10266,0.11919,0.13747,0.13907,0.11698,0.10235,0.11882,0.13722,0.13874,0.11719,0.10227,0.11854,0.13711,0.13904,0.1177,0.10211,0.11808,0.1367,0.1391,0.11782,0.10237,0.11817,0.13668,0.13888:2
1.9933E-4,-3.2588E-4,3.882E-4,-3.6347E-4,7.6193E-5,-2.4753E-5,-2.8963E-4,3.3502E-4,-9.5033E-5,2.7358E-4,1.3019E-4,-3.5408E-4,2.8764E-4,-2.4576E-4,5.7533E-5,2.5908E-4,-2.1968E-4,3.8598E-4,-8.5683E-5,6.3653E-5,5.8613E-5,-2.0919E-4,2.9714E-4,-3.1877E-4,2.7861E-4,1.1466E-4,-2.2776E-4,2.3592E-4,-2.6603E-4,9.8947E-5,2.1159E-4,-2.7471E-4,0.094882,0.12522,0.13868,0.14006,0.12169,0.10346,0.1217,0.13998,0.1409,0.12072,0.10434,0.12093,0.14,0.14124,0.12086,0.10438,0.12068,0.13987,0.1417,0.12141,0.10449,0.12028,0.13952,0.14183,0.12145,0.10469,0.12016,0.13949,0.1419,0.12216,0.10469,0.12037,0.13941,0.14227,0.12236,0.1048,0.11982,0.13938,0.14232,0.12293,0.1048,0.11967,0.1391,0.14251,0.12304,0.10488,0.11948,0.13926,0.14307,0.1231,0.1046,0.11911,0.13884,0.14308,0.12342,0.10456,0.11889,0.13859,0.14302,0.12368,0.10462,0.11861,0.13855,0.14323,0.12391,0.10479,0.11838,0.13815,0.1434,0.12431,0.1048,0.11825,0.13784,0.1437,0.12452,0.10471,0.11803,0.13763,0.14365,0.12483,0.10485,0.11755,0.1375,0.14363,0.1251,0.105,0.11729,0.13721,0.14405,0.12542,0.1052,0.11699,0.13699,0.14408,0.12585,0.10506,0.11705,0.13695,0.14402,0.12608,0.10514,0.11658,0.13653,0.14391,0.12628,0.10498,0.11644,0.13644,0.14419,0.12673,0.10521,0.11614,0.13629,0.1444,0.12719,0.10531,0.11614,0.13609,0.14407,0.12717,0.10529,0.11565,0.13538,0.1442,0.12756,0.10521,0.11549,0.13514,0.14412,0.12778,0.10535,0.11518,0.13503,0.14436,0.1279,0.10551,0.11486,0.13473,0.14397,0.12822,0.10569,0.11461,0.13456,0.14411,0.12847,0.10574,0.11432,0.13432,0.14435,0.12885,0.10596,0.11407,0.13415,0.14419,0.12905,0.1057,0.11383,0.13379,0.14411,0.12929,0.10598,0.11376,0.13345,0.14404,0.12981,0.10606,0.11321,0.13314:2
-2.0923E-5,-3.0993E-5,4.1711E-4,-3.5007E-4,2.3625E-4,7.4297E-5,-2.9437E-4,3.5164E-4,-4.2962E-4,1.9892E-4,-1.0223E-5,-4.9357E-5,2.588E-4,-2.2528E-4,1.749E-4,6.419E-5,-4.0173E-5,3.6808E-4,-2.253E-4,2.6683E-4,8.0867E-6,-1.2638E-4,3.0561E-4,-3.6299E-4,2.2816E-4,9.177E-5,-1.7831E-4,4.8948E-4,-1.6264E-4,0.031084,0.14915,0.12935,0.11193,0.1099,0.13358,0.14569,0.1334,0.10893,0.11245,0.13259,0.14576,0.13433,0.10915,0.11275,0.13281,0.14625,0.13465,0.10921,0.11256,0.1327,0.14607,0.13515,0.10964,0.1126,0.13259,0.14632,0.13565,0.1096,0.1124,0.13233,0.14597,0.13575,0.11004,0.11248,0.13183,0.14601,0.13576,0.11004,0.1119,0.13161,0.14599,0.13617,0.11045,0.11173,0.1314,0.14607,0.1368,0.11033,0.11166,0.13103,0.14611,0.13719,0.11076,0.11128,0.13092,0.1463,0.13754,0.11097,0.1115,0.13054,0.14604,0.13757,0.11112,0.11138,0.1305,0.14597,0.13794,0.11124,0.11113,0.13016,0.14578,0.13807,0.11157,0.11102,0.1297,0.14599,0.13838,0.11149,0.11074,0.12936,0.14567,0.13854,0.11184,0.11076,0.1291,0.1456,0.13894,0.1122,0.11068,0.12931,0.14554,0.13953,0.11236,0.11054,0.12899,0.14563,0.13946,0.11264,0.11032,0.12847,0.1455,0.13982,0.11263,0.11022,0.12814,0.14527,0.13995,0.11308,0.11024,0.12788,0.14533,0.14059,0.11314,0.11014,0.12768,0.14551,0.14057,0.11358,0.10973,0.12724,0.14516,0.14094,0.11347,0.10966,0.12701,0.14504,0.1409,0.11391,0.10981,0.12696,0.1449,0.1411,0.11432,0.1096,0.12665,0.1447,0.14143,0.11461,0.10955,0.12627,0.14467,0.14135,0.1147,0.10931,0.12571,0.14453,0.14153,0.11502,0.10928,0.1255,0.14413,0.14184,0.1152,0.10929,0.12501,0.14404,0.1419,0.11529,0.10884,0.1248,0.14385,0.14228,0.11529,0.1089,0.12445,0.14398,0.14226,0.11533,0.10904,0.12425:2
-4.7715E-4,-3.2533E-4,3.8726E-4,-6.136E-4,0.0011338,-4.9147E-4,-8.652E-5,6.8491E-4,-8.6294E-4,0.0013404,-3.2535E-4,1.0029E-4,5.3384E-4,-7.2377E-4,5.982E-4,-5.1629E-4,3.4861E-4,6.2735E-4,-5.023E-4,5.7321E-4,-8.1064E-4,3.1157E-4,3.2455E-4,-6.5687E-4,8.9639E-4,-4.716E-4,9.5153E-5,7.4143E-4,0.36208,0.38675,0.41742,0.49046,0.46168,0.36894,0.36792,0.42987,0.48753,0.45841,0.37542,0.36266,0.43302,0.48803,0.45849,0.37727,0.3628,0.43341,0.48902,0.46034,0.37858,0.3634,0.4334,0.48972,0.4605,0.37878,0.36265,0.43307,0.4899,0.46127,0.37908,0.36333,0.43288,0.48923,0.46204,0.3805,0.36305,0.43286,0.48906,0.46298,0.38025,0.36232,0.43159,0.48876,0.46161,0.38017,0.36177,0.43093,0.48755,0.46207,0.37995,0.3606,0.42898,0.48696,0.46122,0.37926,0.36007,0.42851,0.48616,0.46258,0.37963,0.35964,0.42811,0.48606,0.46237,0.3805,0.36002,0.42866,0.48744,0.46332,0.38135,0.36057,0.42846,0.48765,0.46377,0.38188,0.35947,0.42677,0.48566,0.46295,0.38108,0.358,0.42477,0.48407,0.46179,0.38025,0.35746,0.42435,0.4841,0.46351,0.38174,0.35859,0.42615,0.48567,0.46449,0.3827,0.35849,0.42534,0.48445,0.4637,0.38185,0.35731,0.42298,0.48332,0.46275,0.38136,0.35666,0.42216,0.48289,0.46378,0.3821,0.35679,0.42292,0.48293,0.46553,0.383,0.35665,0.42101,0.48208,0.46308,0.38125,0.35544,0.42034,0.48055,0.46421,0.38201,0.35561,0.42038,0.48121,0.46509,0.38314,0.35589,0.41967,0.48082,0.46356,0.38166,0.3538,0.41733,0.47983,0.46399,0.38162,0.35431,0.41835,0.47957,0.46489,0.38359,0.35382,0.41723,0.47906,0.46417,0.38197,0.35299,0.41533,0.47771,0.4646,0.38295,0.3533,0.41568,0.47875,0.46511,0.38378,0.35227,0.41418,0.47653,0.46324,0.38176,0.35185,0.41317,0.47698,0.46494,0.38328,0.35221:2
-3.0896E-4,7.2378E-4,-4.3146E-4,3.6415E-4,5.5959E-4,-6.0447E-4,6.4991E-4,-7.0234E-4,1.7162E-4,3.4959E-4,-3.1276E-4,7.3362E-4,-4.3922E-4,1.5036E-4,3.261E-4,-5.314E-4,7.901E-4,-3.3145E-4,1.2759E-4,3.8443E-4,-4.1333E-4,7.2905E-4,-7.946E-5,2.2067E-4,-6.658E-5,-4.9042E-4,6.1294E-4,-5.7343E-4,4.0077E-4,1.6535E-4,-2.7626E-4,5.6692E-4,-4.673E-4,3.7867E-4,3.1093E-4,0.2034,0.27339,0.30994,0.36474,0.37511,0.31542,0.27489,0.31063,0.36442,0.37493,0.31664,0.27448,0.31134,0.36461,0.37546,0.31728,0.27438,0.31076,0.36429,0.3762,0.31792,0.2745,0.31003,0.36337,0.37567,0.31803,0.27441,0.30934,0.36281,0.37585,0.31858,0.27354,0.3082,0.36256,0.3748,0.31833,0.27312,0.30745,0.3612,0.375,0.31875,0.2729,0.30699,0.36063,0.37566,0.31901,0.27382,0.30618,0.36063,0.37526,0.3196,0.27344,0.30599,0.36031,0.3761,0.3214,0.27398,0.30627,0.36062,0.37644,0.32188,0.27471,0.3056,0.36036,0.37672,0.32214,0.2742,0.30485,0.35858,0.37686,0.32188,0.27344,0.30342,0.35786,0.37554,0.32217,0.27318,0.30219,0.35715,0.37621,0.3225,0.27387,0.30294,0.35835,0.37698,0.32414,0.27405,0.30269,0.35737,0.37694,0.32423,0.27355,0.30186,0.35545,0.37516,0.32355,0.2726,0.29995,0.35461,0.37554,0.32451,0.27241,0.3,0.35483,0.37639,0.32586,0.27393,0.29989,0.35486,0.37659,0.32591,0.27328,0.29882,0.35335,0.3751,0.32515,0.27286,0.2978,0.3515,0.37515,0.32706,0.27317,0.29803,0.35237,0.37615,0.32747,0.27302,0.29703,0.35095,0.37515,0.3263,0.27245,0.29602,0.34979,0.37478,0.3278,0.27311,0.29603,0.35011,0.37522,0.32864,0.27298,0.29523,0.34952,0.37443,0.3279,0.27189,0.29422,0.34842,0.37445,0.3296,0.27313,0.29424,0.34883,0.37525,0.32938,0.2724,0.29284,0.34628,0.374,0.32916,0.27208,0.29273,0.34712,0.37479:2
-0.0077429,-0.01054,-0.010746,0.013904,-0.018794,-0.0027556,-0.0061786,-0.023404,0.0081111,-0.02636,-0.0058553,-0.0048916,-0.024442,0.0072657,-0.031266,-0.0054692,0.0015973,-0.020967,0.012878,-0.023103,-0.0033348,8.4185,21.797,4.4911,8.9407,6.9233,8.9411,10.688,5.8385,7.0194,7.4992,9.2405,9.8021,6.7836,6.4359,7.8282,9.3534,9.6159,7.0555,6.2491,7.9067,9.3881,9.5475,7.1759,6.2362,7.9215,9.3728,9.5568,7.1894,6.2226,7.9201,9.3788,9.5647,7.1805,6.2147,7.9124,9.3706,9.5078,7.18,6.2226,7.8877,9.3281,9.5203,7.1644,6.1957,7.8842,9.3003,9.4962,7.1475,6.1757,7.8474,9.2644,9.4583,7.1346,6.1583,7.8218,9.2322,9.4335,7.1113,6.1432,7.7768,9.2026,9.3992,7.0991,6.1271,7.752,9.181,9.3647,7.1025,6.1007,7.7409,9.137,9.3545,7.0868,6.0862,7.6978,9.1146,9.3343,7.0848,6.0893,7.6874,9.0922,9.3157,7.0767,6.0711,7.6709,9.0688,9.3039,7.0725,6.0555,7.6432,9.0463,9.29,7.0684,6.0504,7.6318,9.0214,9.2661,7.0629,6.0406,7.5929,8.9975,9.2404,7.0478,6.0239,7.5693,8.9626,9.2284,7.038,6.0103,7.543,8.9514,9.218,7.0348,5.995,7.5255,8.9245,9.2065,7.0299,5.995,7.4978,8.8902,9.1833,7.0171,5.9846,7.4744,8.8797,9.1535,7.0227,5.9657,7.4643,8.8605,9.1646,7.0051,5.966,7.4393,8.8473,9.1357,7.0079,5.944,7.4255,8.8125,9.1333,7.0034,5.9395,7.4025,8.7911,9.1189,7.0034,5.9282,7.3848,8.7813,9.1173,7.0023,5.9166,7.3723,8.7733,9.1169,6.9962,5.9317,7.3479,8.771,9.1062,7.0145,5.9117,7.3529,8.7435,9.103,7.0091,5.8958,7.3449,8.7304,9.0982,7.0124,5.8991,7.3355,8.7219,9.1027,7.0106,5.898:2
0.0048069,-0.026727,0.011408,-0.014578,-0.0065106,-3.0806E-4,-0.026628,0.0080005,-0.019417,-0.013331,0.0090362,-0.029291,0.012856,-0.022449,-0.0078323,0.0045635,-0.029585,0.019656,16.892,9.0012,12.238,6.0262,7.7674,6.1891,8.7706,10.285,7.2973,6.5813,6.9234,8.8883,9.9478,7.9583,6.2248,7.2277,8.889,9.8737,8.0932,6.0939,7.3303,8.8656,9.8384,8.128,6.0853,7.3284,8.8501,9.8293,8.1305,6.0963,7.2939,8.8372,9.8287,8.138,6.072,7.2805,8.8431,9.8019,8.1195,6.0849,7.2684,8.7993,9.7836,8.0912,6.0614,7.2512,8.7654,9.7462,8.0713,6.0443,7.2376,8.7343,9.7188,8.0469,6.0378,7.1952,8.7017,9.6808,8.0333,6.0052,7.1742,8.6825,9.658,8.0179,5.9868,7.1758,8.6435,9.6373,7.9835,5.9711,7.1249,8.6061,9.5938,7.9696,5.9599,7.1092,8.5673,9.5775,7.9567,5.9529,7.1098,8.5584,9.568,7.9528,5.9436,7.0928,8.5262,9.5537,7.9302,5.9368,7.0773,8.5082,9.5258,7.9119,5.921,7.0521,8.4722,9.4982,7.9018,5.9081,7.0375,8.4614,9.467,7.8879,5.92,7.0105,8.4386,9.4582,7.8653,5.8876,7.006,8.3952,9.4519,7.8661,5.8831,6.9792,8.3817,9.4256,7.8479,5.8792,6.9641,8.364,9.4057,7.8359,5.8698,6.9463,8.3368,9.3997,7.8121,5.8573,6.952,8.3202,9.3764,7.8151,5.8508,6.9192,8.3051,9.3636,7.8109,5.8371,6.9263,8.2856,9.3519,7.7823,5.8512,6.8989,8.274,9.3293,7.7955,5.8332,6.8837,8.2557,9.3344,7.7799,5.8193,6.8888,8.244,9.3235,7.7715,5.8317,6.871,8.2266,9.3085,7.7806,5.8213,6.8519,8.2309,9.289,7.7827,5.813,6.8516,8.2138,9.2996,7.7824,5.7911,6.8473,8.1984,9.2872,7.7676,5.8242,6.8339,8.1916:2
0.013561,-0.024328,-0.0051393,0.0049593,-0.027093,0.011575,-0.025893,-0.011717,0.0048236,-0.026504,0.014567,-0.026935,-0.0014525,1.5016E-4,29.364,11.287,4.0541,9.5273,10.877,7.02,8.175,5.3182,8.6211,9.9044,8.3006,6.9537,6.237,8.5099,9.7539,8.8091,6.57,6.532,8.4599,9.7267,8.9169,6.4924,6.6576,8.4401,9.6947,8.9432,6.4459,6.6883,8.4393,9.6927,8.9536,6.405,6.6916,8.4212,9.708,8.8942,6.3845,6.7183,8.4065,9.6702,8.8792,6.3555,6.6906,8.4072,9.647,8.8361,6.3259,6.6787,8.3812,9.602,8.7971,6.2974,6.6785,8.3615,9.5787,8.7498,6.2698,6.6733,8.3218,9.5599,8.7009,6.2479,6.6586,8.2982,9.5353,8.667,6.2237,6.6488,8.2848,9.5249,8.6335,6.2004,6.6514,8.2654,9.4973,8.601,6.1806,6.6493,8.2444,9.4907,8.5826,6.1702,6.65,8.2279,9.458,8.5432,6.1493,6.6492,8.2051,9.4419,8.5103,6.1285,6.6414,8.181,9.4332,8.4806,6.1091,6.6422,8.1657,9.4265,8.4603,6.0948,6.6346,8.1504,9.3933,8.424,6.0918,6.6228,8.1443,9.3887,8.3837,6.0565,6.6275,8.1078,9.3787,8.3691,6.0485,6.6067,8.104,9.3522,8.3418,6.0183,6.617,8.0822,9.3397,8.3098,6.0186,6.6035,8.0657,9.3328,8.2863,5.9862,6.6038,8.0499,9.3194,8.2498,5.9864,6.5976,8.055,9.2896,8.2458,5.9724,6.6041,8.0351,9.2906,8.2097,5.9503,6.5959,8.0229,9.2833,8.1763,5.9556,6.5899,8.0287,9.2647,8.1767,5.9335,6.5951,8.0183,9.2759,8.1459,5.9111,6.6093,8.0093,9.2586,8.1239,5.9132,6.6065,8.0026,9.2667,8.0988,5.9137,6.6015,8.0115,9.233,8.0959,5.8915,6.6043,8.0194,9.2308,8.0744,5.8731,6.6105,8.0137,9.2388,8.0591:2
-0.033048,0.018051,-0.018455,-0.0022979,0.0057718,-0.023441,0.020869,-0.016518,5.0081E-4,0.0096114,-0.026709,0.022871,-0.020509,-0.0060176,0.0086519,-0.027666,0.024748,-0.019949,-0.0092445,-8.1959E-4,-0.029873,4.7683,6.4505,6.8193,6.2286,5.3369,5.0881,6.2101,6.7822,6.385,5.224,5.2045,6.1643,6.8161,6.4115,5.216,5.2061,6.1557,6.8171,6.4164,5.2257,5.2192,6.1668,6.8318,6.4271,5.2281,5.2084,6.1602,6.8135,6.4309,5.2334,5.2073,6.1598,6.8042,6.4356,5.231,5.204,6.1515,6.806,6.4418,5.2271,5.2042,6.1238,6.8023,6.4455,5.2343,5.2082,6.1241,6.8041,6.4348,5.23,5.1991,6.1295,6.8265,6.4562,5.2414,5.2003,6.133,6.8208,6.4607,5.2542,5.1966,6.1249,6.819,6.4564,5.2533,5.1893,6.1181,6.8115,6.4543,5.2535,5.1891,6.1171,6.817,6.4701,5.2611,5.1892,6.1143,6.8109,6.4791,5.2689,5.1922,6.1168,6.809,6.486,5.2625,5.1783,6.1023,6.7997,6.4848,5.2614,5.1717,6.0767,6.8131,6.484,5.2686,5.1723,6.0772,6.8056,6.49,5.2855,5.1664,6.0741,6.8068,6.4881,5.2739,5.153,6.0506,6.7955,6.4923,5.2772,5.1457,6.0636,6.7944,6.5042,5.2781,5.1475,6.059,6.7799,6.4988,5.2757,5.1422,6.0285,6.7756,6.4954,5.2738,5.1297,6.0166,6.779,6.5105,5.2797,5.1339,6.0199,6.7672,6.5023,5.2823,5.1174,5.99,6.7504,6.4982,5.2712,5.1081,5.988,6.7554,6.4908,5.2864,5.1117,5.9806,6.7403,6.4951,5.2694,5.0858,5.9714,6.7399,6.4903,5.2819,5.0919,5.9669,6.7339,6.4995,5.2738,5.0866,5.945,6.715,6.4906,5.2739,5.0809,5.9384,6.7167,6.4829,5.2786,5.0827,5.9306,6.7107,6.4864,5.2722,5.061,5.9139,6.7067,6.4873:2
0.01986,-0.033079,0.022444,-0.017207,-0.0089405,0.013108,-0.029492,0.018588,-0.0089975,-0.0060806,0.01787,-0.029016,0.019999,5.8099,6.6871,5.9335,4.9225,5.5152,6.4428,6.7168,5.8925,4.9745,5.4954,6.4671,6.7461,5.8993,4.9845,5.49,6.4646,6.7518,5.9137,4.9987,5.4902,6.4717,6.7503,5.9078,4.998,5.4938,6.4815,6.7654,5.9121,4.9975,5.4795,6.4746,6.7691,5.9181,4.994,5.4744,6.4624,6.7648,5.9289,4.9886,5.4657,6.4416,6.7709,5.9284,5.0045,5.4705,6.4551,6.7652,5.9363,5.0088,5.4636,6.4502,6.7787,5.9251,4.9994,5.4463,6.4346,6.7578,5.9274,4.9933,5.4488,6.4325,6.7592,5.9354,5.0041,5.4472,6.4303,6.7563,5.939,5.0034,5.4345,6.4307,6.7489,5.9359,4.9928,5.4209,6.4164,6.7463,5.932,4.9817,5.4122,6.411,6.7458,5.9434,4.9797,5.4271,6.4083,6.7505,5.9303,4.9786,5.4171,6.3886,6.7484,5.9307,4.9787,5.3995,6.3794,6.7446,5.9331,4.9799,5.3982,6.3877,6.7456,5.9364,4.9756,5.3932,6.3745,6.7318,5.926,4.9857,5.3798,6.3684,6.7448,5.9322,4.9814,5.3778,6.3659,6.7327,5.9287,4.9789,5.3644,6.3559,6.7192,5.9272,4.9676,5.364,6.3672,6.7158,5.9477,4.9733,5.3679,6.3486,6.7132,5.9358,4.9601,5.3557,6.3306,6.7176,5.9456,4.9616,5.3603,6.3346,6.7279,5.933,4.9654,5.3493,6.3057,6.704,5.9209,4.9544,5.3267,6.3159,6.6961,5.9305,4.9512,5.3111,6.2957,6.6838,5.9193,4.9397,5.3034,6.2809,6.6778,5.9189,4.9502,5.297,6.271,6.6733,5.9155,4.9346,5.2825,6.2681,6.6691,5.919,4.938,5.2807,6.2625,6.6596,5.9221,4.9212,5.2685,6.2523,6.6523,5.9221,4.9308,5.2752,6.2496,6.6551:2
-0.0028219,-0.023584,0.019893,-0.031008,0.0042871,0.00462,-0.028665,0.02226,-0.036082,0.006165,-0.0099321,-0.025126,0.018305,-0.0327,0.004646,0.0015325,2.0699,4.6916,5.3861,6.3018,6.1614,5.1698,4.6533,5.3619,6.3166,6.1912,5.172,4.6753,5.3485,6.3353,6.2149,5.1866,4.6848,5.3449,6.3381,6.2205,5.1951,4.6842,5.3334,6.3369,6.224,5.2153,4.6876,5.3408,6.3342,6.243,5.2277,4.689,5.3362,6.3286,6.2635,5.2323,4.6974,5.3245,6.3207,6.263,5.2427,4.6897,5.3172,6.3269,6.2711,5.2493,4.6934,5.3097,6.3301,6.2716,5.2604,4.6911,5.3049,6.3261,6.2888,5.2562,4.692,5.2963,6.3222,6.2831,5.2735,4.6964,5.2925,6.3235,6.2909,5.2748,4.6932,5.2796,6.3162,6.2847,5.2761,4.6874,5.2719,6.3147,6.2912,5.2918,4.6902,5.2724,6.306,6.29,5.3011,4.6912,5.2638,6.3115,6.2938,5.3045,4.6925,5.258,6.3025,6.2994,5.319,4.6823,5.2486,6.2856,6.3196,5.318,4.6863,5.2405,6.2885,6.3175,5.3339,4.6808,5.2305,6.296,6.3093,5.3318,4.6874,5.2293,6.2811,6.3273,5.343,4.6931,5.2268,6.2929,6.3158,5.3431,4.6906,5.2134,6.2786,6.3381,5.3585,4.6988,5.2022,6.279,6.3258,5.3635,4.6925,5.1968,6.2712,6.327,5.3697,4.6914,5.1818,6.2628,6.3277,5.3695,4.6884,5.177,6.2535,6.3277,5.3779,4.6905,5.1599,6.2478,6.3251,5.3925,4.6846,5.162,6.2354,6.3369,5.4005,4.6876,5.1505,6.2409,6.3317,5.4129,4.6849,5.1503,6.2266,6.3375,5.4099,4.6821,5.1353,6.2241,6.332,5.4243,4.6832,5.1395,6.2163,6.3406,5.4227,4.6797,5.1278,6.2119,6.3426,5.438,4.6822,5.1255,6.2119,6.3436,5.4361,4.6864,5.1154,6.2079:2
0.0046503,-0.028755,0.022164,-0.022196,-0.012315,0.0053866,-0.032397,0.021486,-0.020713,-0.0029467,0.0061202,-0.034737,0.01898,-0.020348,-0.0018989,0.0010871,0.37825,4.7407,5.9623,6.328,5.7796,4.8608,4.7219,5.7753,6.3272,5.8505,4.7929,4.7904,5.7399,6.3528,5.8802,4.7911,4.794,5.7343,6.3685,5.8885,4.8082,4.7853,5.724,6.3677,5.8948,4.8078,4.7889,5.7167,6.3606,5.9118,4.8261,4.7827,5.7126,6.3727,5.9239,4.8281,4.7835,5.7038,6.3694,5.9421,4.844,4.7832,5.6994,6.3774,5.9561,4.8466,4.7771,5.6862,6.3809,5.9632,4.8627,4.7743,5.6691,6.3816,5.9714,4.8527,4.7698,5.6668,6.3836,5.9771,4.879,4.7663,5.6505,6.3989,5.9872,4.8778,4.7688,5.6513,6.391,6.0046,4.8905,4.75,5.6427,6.3872,5.9939,4.8982,4.7509,5.6352,6.392,6.0063,4.9111,4.7485,5.6182,6.3793,6.0106,4.9044,4.7339,5.6138,6.37,6.0156,4.914,4.7325,5.5862,6.3661,6.0354,4.9312,4.7322,5.5987,6.3551,6.0416,4.9313,4.7203,5.5772,6.3718,6.0556,4.9492,4.7315,5.5767,6.3662,6.0598,4.9436,4.7268,5.5552,6.3709,6.0646,4.9513,4.7144,5.5438,6.3553,6.0725,4.9609,4.7149,5.5237,6.3734,6.0687,4.9672,4.696,5.5128,6.3601,6.0782,4.9799,4.6987,5.5025,6.3756,6.0809,4.9834,4.6938,5.499,6.3535,6.0999,4.9973,4.6899,5.4694,6.3439,6.0747,4.9957,4.6877,5.4693,6.335,6.087,5.0027,4.6735,5.4544,6.3294,6.1034,5.0099,4.6679,5.4435,6.3259,6.1176,5.0288,4.6758,5.4437,6.3373,6.1302,5.0374,4.6779,5.4283,6.3453,6.1313,5.0447,4.678,5.4172,6.331,6.1446,5.0491,4.6717,5.4018,6.3276,6.1394,5.0627,4.6645,5.392,6.3079:2
-0.011003,0.014668,-0.026453,0.022196,-0.018397,-0.015808,0.010212,-0.030939,0.015455,-0.015885,-0.012316,0.0084414,-0.030197,0.024026,-0.021804,-0.013754,4.4341,4.9816,4.9552,6.2473,6.2132,5.1728,4.6231,5.1786,6.1568,6.1919,5.2371,4.5742,5.2085,6.1608,6.2062,5.2624,4.5767,5.2056,6.1578,6.2192,5.2788,4.5719,5.1967,6.1573,6.2125,5.2887,4.5714,5.196,6.1461,6.234,5.3172,4.5763,5.192,6.1461,6.2405,5.3184,4.5812,5.1899,6.1375,6.2494,5.3369,4.5768,5.1796,6.1382,6.2597,5.3465,4.5863,5.1666,6.133,6.2687,5.3531,4.5856,5.1564,6.1298,6.2732,5.3594,4.5815,5.1452,6.1252,6.2717,5.3743,4.5876,5.1369,6.1218,6.2804,5.3893,4.5943,5.1384,6.1206,6.2907,5.4044,4.5949,5.1246,6.1148,6.2888,5.4042,4.6033,5.1143,6.1087,6.2861,5.4199,4.5989,5.1087,6.1003,6.295,5.4396,4.5968,5.0911,6.0791,6.2842,5.4442,4.586,5.0779,6.0686,6.3059,5.4565,4.6004,5.0774,6.0698,6.3087,5.4628,4.6007,5.0603,6.0597,6.2962,5.4081,4.5885,5.0656,6.0706,6.3091,5.4743,4.6144,5.0392,6.0526,6.3172,5.4875,4.6014,5.0389,6.0403,6.3141,5.5107,4.6142,5.0213,6.0337,6.3214,5.5035,4.6204,5.0267,6.0452,6.3352,5.5211,4.6266,5.0146,6.0167,6.3198,5.5208,4.6199,5.0016,6.0114,6.3206,5.5288,4.6198,4.993,5.9932,6.3083,5.5634,4.6277,4.991,5.9951,6.3115,5.5619,4.6215,4.9808,5.9883,6.323,5.5662,4.6257,4.9755,5.9818,6.3246,5.5837,4.6335,4.9624,5.9758,6.3227,5.5889,4.628,4.9562,5.962,6.3348,5.605,4.6361,4.9471,5.955,6.3313,5.6101,4.6409,4.9427,5.9478,6.3247,5.6052,4.6422,4.9332,5.9407:2
1.0444,0.91585,1.0089,1.1708,1.2614,1.0456,0.91179,1.0095,1.1616,1.2562,1.0508,0.91187,1.0204,1.1662,1.2542,1.0499,0.89854,1.0174,1.1573,1.2531,1.0602,0.90243,1.029,1.1558,1.2494,1.0539,0.89551,1.032,1.1499,1.2669,1.0585,0.89836,1.0308,1.1476,1.2627,1.0438,0.90327,1.0305,1.1483,1.2822,1.0473,0.90696,1.0285,1.1458,1.27,1.0253,0.90282,1.0247,1.1572,1.2912,1.0333,0.91643,1.02,1.1523,1.2765,1.0177,0.91792,1.019,1.1668,1.2836,1.0191,0.91709,1.0097,1.1684,1.2731,1.0238,0.92781,1.0227,1.174,1.2638,1.0248,0.91002,1.014,1.1746,1.2626,1.0362,0.91661,1.0245,1.1719,1.2532,1.0308,0.90487,1.028,1.1772,1.2614,1.0413,0.90689,1.0337,1.1659,1.2465,1.0351,0.89802,1.0403,1.17,1.2598,1.0457,0.89967,1.0425,1.1484,1.2593,1.0326,0.89657,1.0475,1.1604,1.2745,1.03,0.90346,1.0385,1.1466,1.2734,1.0259,0.90776,1.0442,1.1604,1.2816,1.0178,0.90842,1.0323,1.1525,1.2823,1.0178,0.92021,1.041,1.1654,1.2836,1.0044,0.91469,1.0246,1.1636,1.2838,1.0102,0.92901,1.0345,1.1766,1.267,0.99711,0.91619,1.0264,1.1806,1.2744,1.0169,0.91939,1.0272,1.1759,1.2538,1.0109,0.91619,1.0366,1.1828,1.2621,1.0186,0.90989,1.0364,1.1779,1.2573,1.0197,0.90937,1.0466,1.1781,1.2548,1.0245,0.90022,1.0473,1.1732,1.2506,1.0268,0.90369,1.0578,1.1658,1.2591,1.02,0.89648,1.0547,1.1633,1.2686,1.0201,0.90398,1.0509,1.1518,1.2622,1.0081,0.90534,1.0523,1.1623,1.2821,1.0094,0.91279,1.0518,1.1561,1.2755,0.99765,0.9181,1.0517,1.1712,1.2876,0.99525,0.92185,1.0388,1.1645,1.2786,0.98788,0.92558,1.0397,1.1816,1.2749,0.98802,0.92373,1.0382,1.1831,1.2646,0.99697,0.92276,1.0426,1.1946,1.2537,0.99342,0.91553,1.0418,1.1907,1.2554,1.0069,0.91295,1.0472,1.1882,1.2486,1.0048,0.91035,1.0583,1.1842,1.2483,1.0143,0.90339,1.064,1.1796,1.2441,1.0132,0.90538,1.073,1.1713,1.2543,1.0066,0.90035,1.0725,1.1651,1.2659,1.0025,0.9092,1.0711,1.1545,1.2632,0.99338,0.91115,1.0673,1.1649,1.2782,0.99408,0.92109,1.0678,1.1612,1.2732,0.98081,0.91746,1.06,1.1722,1.2779,0.98104,0.92543,1.052,1.17,1.2681,0.9792,0.93265,1.0578,1.1947,1.2643,0.97562,0.92286,1.0441,1.1842,1.251,0.98433,0.92486,1.0563,1.2004,1.2462,0.98706,0.91874,1.0557,1.1915,1.2445,0.99152,0.91985,1.0686,1.1945,1.2411,0.98595,0.91367,1.072,1.19,1.2466,0.99914,0.91354,1.0745,1.1745,1.2301,0.99034,0.90983,1.0852,1.1748,1.245,0.99256,0.90877,1.0867,1.1725,1.2496,0.98439,0.91284,1.0815,1.1713,1.2554,0.98434,0.91771,1.0775,1.17,1.2505,0.97542,0.92231,1.0792,1.1738,1.2591,0.97408,0.92205,1.0702,1.1773,1.2574,0.96893,0.93071,1.0724,1.1816,1.2532,0.96224,0.92837,1.0675,1.1925,1.2511,0.96633,0.93307,1.0709,1.192,1.2409,0.968,0.92991,1.0696,1.201,1.2395,0.96896,0.92534,1.0692,1.1912,1.2326,0.9738,0.92708,1.0793,1.1998,1.2352,0.97419,0.92098,1.0809,1.1933,1.226,0.98305,0.92275,1.0913,1.1986,1.2226,0.97962,0.91417,1.0925,1.1881,1.2255,0.98203,0.91279,1.0951,1.1833,1.2301,0.97648,0.91694,1.0964,1.1793,1.2355,0.97496,0.92364,1.0972,1.1807,1.2348,0.96466,0.92479,1.0983,1.1803,1.2396:3
22.909,22.268,17.464,15.233,16.711,20.39,20.285,15.868,13.9,15.17,18.882,19.199,15.045,13.185,14.124,17.879,18.351,14.484,12.665,13.462,17.327,17.636,14.094,12.173,12.829,16.71,17.083,13.83,11.816,12.566,16.366,16.654,13.596,11.434,12.216,15.914,16.245,13.48,11.219,12.071,15.473,15.99,13.367,10.96,11.885,15.097,15.955,13.219,10.857,11.671,14.63,15.807,13.094,10.754,11.56,14.526,15.849,12.871,10.62,11.256,14.264,15.585,12.59,10.6,11.016,14.028,15.6,12.574,10.57,10.819,14.083,15.535,12.652,10.631,10.746,14.182,15.355,12.671,10.48,10.632,14.017,15.17,12.804,10.389,10.461,13.922,15.005,12.737,10.285,10.555,13.785,14.963,12.813,10.169,10.585,13.535,15.004,12.949,10.224,10.6,13.44,15.101,12.874,10.139,10.532,13.334,15.132,12.679,10.169,10.504,13.252,15.216,12.731,10.336,10.404,13.204,15.146,12.466,10.264,10.298,13.167,15.187,12.552,10.378,10.133,13.249,15.027,12.681,10.312,10.015,13.245,14.848,12.73,10.246,10.021,13.246,14.727,12.79,10.218,10.128,13.107,14.652,12.926,10.144,10.153,12.873,14.707,12.998,9.8883,10.115,12.781,14.835,12.951,10.071,10.106,12.569,14.874,12.841,10.14,10.119,12.562,14.96,12.77,10.199,10.004,12.406,14.815,12.778,10.199,9.8227,12.476,14.897,12.738,10.34,9.7179,12.569,14.771,12.85,10.357,9.7114,12.702,14.719,12.942,10.296,9.71,12.667,14.558,13.055,10.336,9.8136,12.519,14.409,13.169,10.221,9.8686,12.345,14.409,13.258,10.126,9.8431,12.158,14.583,13.282,10.207,9.851,12.055,14.667,13.134,10.227,9.8024,12.01,14.725,13.079,10.337,9.7732,11.987,14.79,12.969,10.417,9.6525,11.964,14.73,12.933,10.523,9.5682,12.054,14.666,13.083,10.511,9.4816,12.042,14.41,13.048,10.406,9.4796,12.008,14.34,13.228,10.46,9.6024,11.975,14.27,13.364,10.366,9.6543,11.786,14.248,13.499,10.355,9.6681,11.535,14.247,13.364,10.307,9.6689,11.481,14.46,13.322,10.281,9.5546,11.411,14.471,13.207,10.441,9.5218,11.331,14.487,13.172,10.583,9.4276,11.35,14.434,13.118,10.678,9.3095,11.43,14.26,13.222,10.686,9.3084,11.583,14.143,13.251,10.632,9.2989,11.429,13.996,13.391,10.615,9.4053,11.447,13.929,13.503,10.525,9.4402,11.22,13.812,13.592,10.555,9.4931,10.977,13.927,13.656,10.541,9.5124,10.93,14.058,13.544,10.661,9.5143,10.85,14.029,13.456,10.69,9.4393,10.866,14.142,13.416,10.796,9.3496,10.859,14.0,13.248,10.952,9.3827,10.92,13.864,13.408,10.98,9.2247,11.051,13.81,13.522,10.908,9.2201,10.975,13.678,13.638,10.897,9.2861,10.956,13.607,13.781,10.872,9.4077,10.809,13.527,13.918,10.788,9.4396,10.575,13.555,13.896,10.825,9.5131,10.6,13.713,13.778,10.848,9.4685,10.56,13.827,13.685,10.922,9.3866,10.467,13.737,13.612,11.097,9.4039,10.445,13.716,13.557,11.133,9.2442,10.575,13.616,13.678,11.288,9.1846,10.641,13.457,13.754,11.221,9.1993,10.618,13.33,13.814,11.217,9.2861,10.548,13.208,14.007,11.214,9.4079,10.464,13.136,14.111,11.16,9.4437,10.237,13.172,14.158,11.19,9.5318,10.174,13.257,14.057,11.193,9.4787,10.138,13.405,13.942,11.277,9.4531,10.165,13.428,13.889,11.419,9.4426,10.162,13.378,13.809,11.531,9.329,10.202,13.179,13.833,11.654,9.2841,10.296,13.06,13.961,11.611,9.2815,10.309,12.958,14.076,11.575,9.3289,10.177,12.776,14.152,11.508,9.4107,10.129,12.715,14.277,11.51,9.4919,9.9286,12.728,14.288,11.44,9.549,9.741,12.85,14.315,11.585,9.4752,9.7177,12.931,14.113,11.596,9.5092,9.8499,12.93,13.978,11.74,9.5219,9.8757,12.924,13.915,11.816,9.4017,9.8981,12.795,13.97,11.901,9.3126,10.037,12.625,14.054,11.969,9.348,9.9694,12.497,14.177,11.889,9.3941,9.9268,12.357,14.213,11.83,9.4993,9.8867,12.348,14.379,11.881,9.5922,9.6705,12.284,14.43,11.825,9.6724,9.6011,12.395,14.309,11.84,9.6828,9.5592,12.509,14.193,11.9,9.6523,9.5781,12.49,14.073,12.017,9.636,9.5449,12.445,14.011,12.144,9.5441,9.6381,12.303,14.0,12.314,9.5121,9.612,12.177,14.246,12.422,9.4277,9.701,12.045,14.252,12.287,9.5905,9.7499,11.978,14.295,12.223,9.6454,9.6605,11.89,14.407,12.121,9.7377,9.5359,11.815,14.405,12.132,9.8075,9.3049,11.873,14.282,12.125,9.8316,9.3488,12.04,14.147,12.191,9.7812,9.3128,11.967,14.002,12.319,9.8244,9.3777,11.963,13.956,12.471,9.7443,9.4165,11.826,13.895,12.583,9.6683,9.4741,11.669,13.991,12.657,9.6405,9.5373,11.586,14.124,12.569,9.6844,9.4673,11.476,14.202,12.496,9.7554,9.4196,11.418,14.25,12.509,9.9007,9.3258,11.273,14.233,12.386,9.9634,9.2147,11.406,14.221,12.417,10.031,9.1862,11.594,14.108,12.509,10.049,9.2331,11.58,13.919,12.637,10.063,9.2568,11.537,13.821,12.78,10.02,9.2273,11.311,13.753,12.92,9.9665,9.3329,11.219,13.789,12.964,9.887,9.3311,11.073,13.956,12.954,9.9508,9.3581,11.015,14.017,12.831,10.038,9.3485,10.949,14.052,12.799,10.166,9.274,10.932,14.139,12.733,10.249,9.1735,10.958,14.051,12.706,10.318,9.0687,11.071,13.924,12.821,10.359,9.0306,11.092,13.807,12.914,10.347,9.1486,11.088,13.638,12.998,10.272,9.123,10.983,13.6,13.191,10.269,9.2245,10.724,13.497,13.297,10.255,9.263,10.655,13.648,13.256,10.254,9.3125,10.594,13.811,13.136,10.322,9.3104,10.549,13.791,13.129,10.454,9.0618,10.476,14.014,13.148,10.476,9.0421,10.453,13.828,13.045,10.651,9.0049,10.617,13.715,13.11,10.705,9.0665,10.698,13.485,13.135,10.653,9.0625,10.661,13.437,13.334,10.676,9.126,10.62,13.384,13.511,10.65,9.1992,10.466,13.328,13.645,10.574,9.2391,10.324,13.388,13.586,10.575,9.3259,10.248,13.472,13.483,10.639,9.2894,10.172,13.505,13.378,10.742,9.2594,10.119,13.542,13.208,10.797,9.227,10.156,13.477,13.281,10.97,8.9308,10.213,13.522,13.416,10.986,8.9913,10.292,13.207,13.458,11.064,9.0719,10.245,13.03,13.488,10.97,9.0959,10.212,12.953,13.67,10.971,9.2788,10.156,12.826,13.72,10.942,9.2938,10.005,12.937,13.844,10.926,9.3418,9.8974,13.111,13.749,10.976,9.3353,9.8544,13.165,13.654,11.075,9.284,9.8007,13.145,13.594,11.191,9.2283,9.8034,13.121,13.518,11.318,9.1737,9.9032,13.014,13.545,11.427,9.1302,9.9801,12.784,13.582,11.484,9.183,9.9959,12.673,13.752,11.43,9.1659,9.9111,12.589,13.89,11.4,9.2529,9.8437,12.5,14.0,11.359,9.3372,9.6988,12.499,14.065,11.299,9.4111,9.5646,12.574,13.972,11.362,9.4498,9.5259,12.704,13.836,11.451,9.4324,9.5404,12.688,13.766,11.551,9.397,9.5038,12.692,13.734,11.71,9.3304,9.5548,12.564,13.668,11.803,9.2278,9.6357,12.366,13.703,11.828,9.2248,9.6838,12.27,13.807,11.745,9.2378,9.6487,12.143,13.92,11.754,9.3512,9.5988,12.096,14.107,11.744,9.4354,9.4728,12.041,14.043,11.59,9.551,9.4728,12.125,14.061,11.673,9.5802,9.3247,12.27,13.978,11.769,9.4991,9.2601,12.303,13.85,11.888,9.5361,9.2721,12.195,13.785,12.055,9.4882,9.2711,12.066,13.709,12.168,9.4046,9.358,11.94,13.714,12.207,9.4099,9.4524,11.795,13.843,12.19,9.3994,9.4381,11.721,13.946,12.154,9.4975,9.3585,11.568,13.995,12.103,9.5966,9.3198,11.6,14.138,12.061,9.7071,9.1986,11.486,14.076,12.068,9.7842,9.0958,11.695,13.915,12.101,9.8436,9.0879,11.721,13.801,12.267,9.7958,9.0784,11.693,13.709,12.354,9.7626,9.1319,11.642,13.644,12.505,9.7143,9.187,11.45,13.637,12.64,9.6245,9.2233,11.36,13.764,12.658,9.6728,9.2822,11.21,13.856,12.566,9.7013,9.1462,11.117,13.978,12.566,9.8006,9.162,11.134,14.053,12.513,9.9195,9.0472,11.061,14.023,12.45,10.004,8.9662,11.176,13.887,12.48:3
0.002222,0.0024063,0.0022142,0.0018395,0.0018323,0.002225,0.002403,0.002206,0.0018362,0.0018372,0.0022282,0.0024095,0.0022019,0.0018296,0.0018387,0.0022319,0.0024108,0.002197,0.001828,0.0018434,0.0022384,0.0024058,0.0021917,0.0018291,0.001844,0.0022408,0.0024075,0.0021829,0.001825,0.0018489,0.002242,0.0024117,0.0021807,0.001821,0.0018542,0.0022507,0.0024085,0.0021708,0.0018132,0.0018584,0.0022607,0.002413,0.0021666,0.001813,0.0018541,0.002253,0.0024082,0.002162,0.0018101,0.0018619,0.0022657,0.0024087,0.0021569,0.0018115,0.0018629,0.0022659,0.002411,0.0021528,0.0018107,0.0018702,0.0022661,0.0024114,0.0021486,0.0018072,0.001877,0.0022746,0.0024052,0.0021394,0.0018047,0.0018806,0.0022777,0.0024123,0.0021322,0.0018069,0.0018837,0.0022772,0.0024137,0.0021294,0.0018016,0.0018878,0.002278,0.0024137,0.0021217,0.0018011,0.0018931,0.0022867,0.0024125,0.0021126,0.001805,0.0018971,0.0022913,0.0024091,0.0021116,0.0017958,0.0019006,0.0022966,0.0024116,0.0021022,0.0017954,0.0019076,0.002293,0.0024129,0.0020972,0.0017962,0.0019088,0.0023033,0.0024114,0.0020929,0.0017957,0.0019179,0.0023081,0.0024104,0.0020945,0.0017946,0.0019181,0.021885,0.065941,0.057537,0.049363,0.047174,0.059487,0.064724,0.057208,0.047636,0.046664,0.058118,0.063351,0.055042,0.046322,0.045195,0.056071,0.060732,0.052198,0.043401,0.042254,0.051489,0.054718,0.046474,0.037656,0.036592,0.043896,0.045216,0.037483,0.029729,0.028127,0.030926,0.028234,0.02071,0.015082,0.014016,0.014898,0.014583,0.011652,0.009428,0.0095419,0.010835,0.01133,0.0095446,0.0081035,0.0083347,0.0098424,0.010197,0.0086636,0.007318,0.0076168,0.0091109,0.0096216,0.0083123,0.0071016,0.0074824,0.0088556,0.0092489,0.0079125,0.0067153,0.0071563,0.0085673,0.0090643,0.0077965,0.0066631,0.0071386,0.008379,0.0087671,0.007546,0.0064286,0.0069962,0.0082439,0.0087927,0.0075164,0.0064483,0.0070093,0.0081147,0.0086025,0.0072442,0.0062809,0.0069041,0.008091,0.0086896,0.0072493,0.0063352,0.0068392,0.0079508,0.0085565,0.0070819,0.0062632,0.0068198,0.0080262,0.008618,0.0070424,0.0062421,0.0067146,0.0078991,0.0084208,0.0069209,0.0062336,0.0067353,0.0079978,0.0084515,0.0068945,0.0061673,0.0066344,0.0079156,0.0082728,0.0068483,0.0061478,0.0066824,0.0079546,0.0082274,0.006802,0.0060249,0.0065745,0.0077784,0.0081155,0.0067638,0.0060118,0.0066289,0.0078079,0.0080588,0.0067162,0.0059311,0.0066061,0.0077448,0.0080604,0.0067606,0.0059956,0.0067161,0.0077482,0.0080929,0.0066918,0.005935,0.0066836,0.0077152,0.0081319,0.0066592,0.0059674,0.006695,0.0076909,0.0081101,0.0065694,0.0059653,0.0066797,0.0077111,0.0082023,0.0065663,0.0060102,0.0066738,0.0077102,0.0081573,0.0065003,0.006014,0.0066766,0.0077698,0.0081942,0.0065008,0.0060474,0.0066574,0.00778,0.008106,0.0064646,0.0060377,0.0066883,0.0079041,0.0081008,0.0065212,0.0060398,0.006724,0.0078879,0.0080906,0.0065519,0.0060591,0.0067908,0.0079435,0.0081024,0.0065614,0.0060479,0.0068301,0.0079689,0.008106,0.0066045,0.0060615,0.0069266:3
2.3033E-4,2.6744E-4,2.8518E-4,2.511E-4,2.0442E-4,2.302E-4,2.6677E-4,2.8673E-4,2.506E-4,2.0501E-4,2.3105E-4,2.6661E-4,2.8577E-4,2.5116E-4,2.0364E-4,2.2946E-4,2.6568E-4,2.8582E-4,2.5249E-4,2.0427E-4,2.2915E-4,2.6561E-4,2.856E-4,2.5254E-4,2.0475E-4,2.2787E-4,2.6397E-4,2.8474E-4,2.537E-4,2.056E-4,2.2805E-4,2.6521E-4,2.8685E-4,2.5382E-4,2.0446E-4,2.2811E-4,2.6364E-4,2.8625E-4,2.5466E-4,2.064E-4,2.2742E-4,0.002427,0.014468,0.013437,0.011084,0.010225,0.011641,0.014221,0.013777,0.010888,0.010112,0.011615,0.013925,0.013343,0.010566,0.010328,0.010971,0.013523,0.012788,0.0098839,0.009404,0.0101,0.011836,0.011045,0.0083817,0.0079117,0.0084219,0.010017,0.0097721,0.0076742,0.0073744,0.0081113,0.0098958,0.0097535,0.0077258,0.0074097,0.0081444,0.0099412,0.0098401,0.0077837,0.0074447,0.0081258,0.0099013,0.0098508,0.007804,0.0074505,0.0081766,0.0099863,0.0099022,0.0078832,0.0074807,0.0081606,0.0099869,0.0099558,0.0078786,0.0074866,0.0080982,0.0099347,0.0099696,0.0078835,0.0074726,0.0081052,0.0099664,0.0099632,0.0079253,0.0074399,0.008076,0.0099302,0.0099506,0.0079278,0.0074277,0.0080341,0.0099079,0.0099402,0.0079194,0.0074042,0.0080286,0.0098518,0.0099129,0.0078802,0.0073503,0.007848,0.0097164,0.0098677,0.0078321,0.0073357,0.0078356,0.0096951,0.0096955,0.00773,0.0071733,0.0076617,0.0094202,0.0095241,0.0075894,0.0069518,0.007437,0.0091032,0.0091669,0.0072708,0.0067212,0.0070804,0.0085845,0.0085464,0.0066641,0.0060342,0.0063313,0.0074636,0.0072734,0.0053932,0.0046222,0.0044064,0.00455,0.0040801,0.0028992,0.0025222,0.0025535,0.0028602,0.0028683,0.002168,0.0019559,0.0019981,0.0023689,0.00249,0.0019549,0.0017909,0.0018236,0.0021975,0.002296,0.0018225,0.0016707,0.0017068,0.0021045,0.0022287,0.0017654,0.0015991,0.0016421,0.0020128,0.0021517,0.0017342,0.0015707,0.0016151,0.0019669,0.0021148,0.0016944,0.0015203,0.0015748,0.0019249,0.0020969,0.0016757,0.0015157,0.0015611,0.0018855,0.0020661,0.0016504,0.0014975,0.0015445,0.0018692,0.0020482,0.0016317,0.001487,0.0015178,0.0018449,0.0020501,0.0016239,0.0014758,0.0015046,0.0018253,0.0020303,0.0016158,0.0014829,0.0014904,0.0018199,0.0020366,0.0016147,0.0014676,0.0014656,0.0018242,0.0020316,0.001617,0.0014757,0.0014615,0.0018059,0.0020135,0.0016174,0.0014694,0.0014679,0.001832,0.0020022,0.0016243,0.0014604,0.0014504,0.0018189,0.001999,0.0016283,0.0014642,0.0014598,0.0018044,0.0019741,0.0016251,0.0014535,0.0014479,0.0018197,0.0019978,0.0016476,0.0014425,0.0014526,0.0017928,0.0019744,0.001661,0.0014587,0.0014662,0.0017815,0.0019844,0.0016541,0.0014401,0.0014549,0.0017789,0.0020013,0.0016631,0.0014537,0.00146,0.0017554,0.0019942,0.0016496,0.0014583,0.0014636,0.0017807,0.0020108,0.0016511,0.001457,0.0014433,0.0017638,0.0020051,0.0016582,0.0014619,0.001436,0.0017551,0.0020042,0.0016498,0.0014635,0.0014329,0.0017591,0.0020286,0.0016659,0.0014694,0.0014211,0.001772,0.002007,0.001666,0.0014848,0.0014186,0.0017672,0.001998,0.001671,0.0014764,0.0014239,0.0017813,0.0019852,0.0016792:3
7.1977E-4,7.4698E-4,8.4563E-4,9.6748E-4,8.9999E-4,7.1853E-4,7.4574E-4,8.4784E-4,9.6417E-4,8.97E-4,7.1694E-4,7.4875E-4,8.5126E-4,9.6832E-4,8.9354E-4,7.1575E-4,7.4846E-4,8.5348E-4,9.6928E-4,8.9226E-4,7.1089E-4,7.5087E-4,8.55E-4,9.6896E-4,8.9218E-4,7.1323E-4,7.5419E-4,8.5742E-4,9.6795E-4,8.8993E-4,7.1362E-4,7.5462E-4,8.6119E-4,9.6983E-4,8.8586E-4,7.0986E-4,7.5544E-4,8.6438E-4,9.6679E-4,8.8315E-4,7.0803E-4,7.5717E-4,8.6273E-4,9.6886E-4,8.8326E-4,7.0549E-4,7.557E-4,8.6337E-4,9.6842E-4,8.8011E-4,7.0588E-4,7.5836E-4,8.6622E-4,9.6929E-4,8.7553E-4,7.0712E-4,7.5931E-4,8.6906E-4,9.6855E-4,8.7275E-4,7.0272E-4,7.5924E-4,8.7115E-4,9.6849E-4,8.7422E-4,7.0224E-4,7.6162E-4,8.7183E-4,9.6855E-4,8.6931E-4,7.0145E-4,7.6446E-4,8.7413E-4,9.6628E-4,8.6571E-4,7.0283E-4,7.6555E-4,8.7764E-4,9.65E-4,8.6574E-4,7.0098E-4,7.6944E-4,8.7901E-4,9.6818E-4,8.6504E-4,6.989E-4,7.6969E-4,8.8114E-4,9.6886E-4,8.6087E-4,6.9875E-4,7.6792E-4,8.8048E-4,9.6582E-4,8.5577E-4,6.9757E-4,0.017891,0.024304,0.028568,0.025804,0.020488,0.021057,0.02404,0.028628,0.025927,0.020157,0.02064,0.024032,0.028236,0.024788,0.019998,0.020551,0.023285,0.027606,0.024246,0.01934,0.019692,0.022718,0.026097,0.022962,0.017908,0.018437,0.02095,0.023589,0.020216,0.015509,0.016122,0.017858,0.019627,0.016576,0.012722,0.01329,0.014662,0.015419,0.012525,0.009093,0.0092376,0.0093824,0.0094075,0.0075865,0.0055805,0.0059649,0.0061532,0.0065004,0.0054689,0.0042287,0.0047115,0.0050293,0.0054555,0.0046711,0.0036502,0.0040779,0.0044365,0.0048771,0.004226,0.0033707,0.0038042,0.0042113,0.0046361,0.0039956,0.003189,0.0036142,0.0040032,0.0044429,0.0038261,0.0031075,0.0035348,0.0039354,0.0043705,0.0037121,0.0030231,0.0034388,0.0038618,0.0043025,0.0036567,0.0030121,0.003421,0.0038246,0.0042267,0.0035581,0.002949,0.0033604,0.0038064,0.0041763,0.0035325,0.0029382,0.0033107,0.0037605,0.0041044,0.0034696,0.0029154,0.0033103,0.0037925,0.0040775,0.003448,0.0028691,0.0032703,0.0037529,0.0040416,0.0034505,0.0028727,0.0032985,0.0037652,0.0040231,0.0034112,0.0028288,0.0032526,0.0037366,0.0039876,0.0034184,0.0028336,0.0032741,0.0037086,0.0039642,0.0033827,0.0028216,0.0032802,0.0037194,0.0039721,0.0033664,0.0028055,0.0032897,0.0037043,0.0039626,0.0033496,0.002805,0.0032813,0.0037142,0.0039732,0.0033266,0.002808,0.0032703,0.0037014,0.0039743,0.0033011,0.0028191,0.0032822,0.0037169,0.0039665,0.0032892,0.0028122,0.0032754,0.0037251,0.0039449,0.0032703,0.0028216,0.0032672,0.003747,0.0039072,0.0032623,0.0028184,0.0032762,0.0037848,0.0039095,0.0032619,0.0027927,0.0032775,0.0037597,0.0038873,0.0032595,0.0027983,0.0032957,0.0037856,0.003869,0.0032658,0.0028067,0.003313,0.0038078,0.0038757,0.0032825,0.0028001,0.0033273,0.0037965,0.0038741,0.0032798,0.0027977,0.0033409,0.0037751,0.0038659,0.0032653,0.002796,0.0033483,0.0037804,0.0038901,0.0032445,0.0028147,0.0033581,0.0037809,0.003884,0.0032308,0.0028232,0.0033442,0.0038281,0.0038961,0.0032189,0.0028407,0.0033513,0.0038215,0.0038891,0.0032183:3
5.4663E-4,6.1411E-4,7.1342E-4,6.7794E-4,5.3936E-4,5.4807E-4,6.1174E-4,7.1231E-4,6.7675E-4,5.3662E-4,5.477E-4,6.121E-4,7.1141E-4,6.7978E-4,5.3803E-4,5.4725E-4,6.132E-4,7.1353E-4,6.8022E-4,5.4025E-4,5.4551E-4,6.1153E-4,7.1202E-4,6.7775E-4,5.3982E-4,5.4589E-4,6.0961E-4,7.1048E-4,6.7938E-4,5.3974E-4,5.4436E-4,6.0827E-4,7.1124E-4,6.8048E-4,5.4246E-4,5.4439E-4,6.0974E-4,7.0985E-4,6.8087E-4,5.4392E-4,5.4624E-4,6.0903E-4,7.09E-4,6.8006E-4,5.4261E-4,5.4552E-4,6.0798E-4,7.108E-4,6.8147E-4,5.4402E-4,5.4444E-4,6.0906E-4,7.0648E-4,6.8442E-4,5.4406E-4,5.4614E-4,6.0647E-4,7.0832E-4,6.8494E-4,5.4546E-4,5.4361E-4,6.0602E-4,7.0759E-4,6.8534E-4,5.4585E-4,5.4581E-4,6.0757E-4,7.105E-4,6.8507E-4,5.4328E-4,5.4478E-4,6.0563E-4,7.0723E-4,6.8611E-4,5.4558E-4,5.453E-4,6.0348E-4,7.0888E-4,6.8541E-4,5.4617E-4,5.4114E-4,6.0574E-4,7.0865E-4,6.8778E-4,5.4615E-4,5.4355E-4,6.0447E-4,7.0739E-4,6.8715E-4,5.4636E-4,5.4356E-4,6.0466E-4,7.0755E-4,6.8842E-4,5.471E-4,5.4263E-4,6.0256E-4,7.0812E-4,6.8758E-4,5.4752E-4,5.4152E-4,6.0108E-4,7.0629E-4,6.8865E-4,5.4772E-4,5.4244E-4,6.0329E-4,7.0674E-4,6.8796E-4,5.4805E-4,5.431E-4,5.9835E-4,7.0554E-4,6.8882E-4,5.4728E-4,5.399E-4,5.9909E-4,7.0831E-4,6.8899E-4,5.486E-4,5.4169E-4,5.991E-4,7.068E-4,6.9092E-4,5.5105E-4,5.4169E-4,5.9891E-4,7.0468E-4,6.9118E-4,5.5132E-4,5.4091E-4,5.9747E-4,7.0574E-4,6.9009E-4,5.5175E-4,5.4083E-4,5.9879E-4,7.0541E-4,6.9113E-4,5.5019E-4,5.4104E-4,5.9821E-4,7.0383E-4,6.9336E-4,5.527E-4,5.3964E-4,5.946E-4,7.0402E-4,6.9342E-4,5.5297E-4,5.4116E-4,5.9608E-4,7.0822E-4,6.9553E-4,5.5169E-4,5.4236E-4,5.94E-4,7.0266E-4,6.9179E-4,5.5388E-4,5.4013E-4,5.9178E-4,7.0269E-4,6.9379E-4,5.5472E-4,5.3928E-4,5.9209E-4,7.0216E-4,6.931E-4,5.552E-4,5.4164E-4,5.9249E-4,7.0112E-4,6.9626E-4,5.5753E-4,5.4077E-4,5.9165E-4,7.024E-4,6.9236E-4,5.5671E-4,5.3943E-4,5.9116E-4,7.0283E-4,6.963E-4,5.5653E-4,5.3909E-4,5.9038E-4,7.0148E-4,6.9588E-4,5.5768E-4,5.4079E-4,5.9067E-4,7.0288E-4,6.9713E-4,5.588E-4,5.4026E-4,5.9064E-4,7.0291E-4,6.9884E-4,5.591E-4,5.4074E-4,5.8777E-4,7.0205E-4,6.9734E-4,5.5971E-4,5.3807E-4,5.8915E-4,7.0172E-4,7.0045E-4,5.607E-4,5.3799E-4,5.8935E-4,7.029E-4,6.9859E-4,5.6003E-4,5.4043E-4,5.8874E-4,7.0213E-4,6.9959E-4,5.6197E-4,5.3924E-4,5.8593E-4,7.0243E-4,6.9975E-4,5.6283E-4,5.3864E-4,5.8797E-4,6.9874E-4,6.9948E-4,5.6255E-4,5.382E-4,5.8709E-4,7.0002E-4,7.0125E-4,5.6452E-4,5.396E-4,5.8528E-4,7.0079E-4,7.0166E-4,5.6546E-4,5.395E-4,5.8448E-4,7.0142E-4,7.0082E-4,5.6273E-4,5.3882E-4,5.8463E-4,6.9983E-4,7.0097E-4,5.6432E-4,5.3797E-4,5.8336E-4,6.9962E-4,7.0269E-4,5.664E-4,5.404E-4,5.8201E-4,6.9937E-4,7.0056E-4,5.6439E-4,5.3741E-4,5.8257E-4,6.9821E-4,7.039E-4,5.6616E-4,5.3932E-4,5.809E-4,6.9987E-4,7.0296E-4,5.6594E-4,5.3898E-4,5.803E-4,6.9913E-4,7.0309E-4,5.679E-4,5.3817E-4,5.822E-4,6.9795E-4,7.0158E-4,5.6826E-4,5.3801E-4,5.8118E-4,6.9904E-4,7.0213E-4,5.6835E-4,5.3692E-4,5.8093E-4,6.9651E-4,7.0348E-4,5.6812E-4,5.3786E-4,5.7884E-4,6.9665E-4,7.0385E-4,5.6799E-4,5.3777E-4,5.797E-4,6.9644E-4,7.0456E-4,5.6905E-4:3
4.1933E-6,-2.0333E-6,1.9267E-6,3.59E-6,-1.82E-6,4.6867E-6,-1.3167E-6,2.7933E-6,2.1133E-6,-4.5333E-7,4.57E-6,-1.2333E-7,2.6567E-6,2.0633E-6,-2.79E-6,3.88E-6,-1.3333E-6,8.5E-7,3.43E-6,-2.5733E-6,4.1633E-6,5.0E-8,2.55E-6,1.96E-6,-1.59E-6,4.01E-6,-9.9667E-7,1.2033E-6,3.3567E-6,-1.41E-6,4.5167E-6,-2.7333E-7,2.17E-6,3.5833E-6,-8.5E-7,3.7E-6,1.8667E-7,2.6067E-6,2.71E-6,-5.6333E-7,4.8867E-6,1.2667E-7,1.7467E-6,2.7067E-6,-7.9E-7,3.6067E-6,-1.3667E-6,2.3E-6,1.82E-6,-1.2933E-6,3.88E-6,2.1333E-7,2.39E-6,3.49E-6,-3.4833E-6,4.7733E-6,-2.22E-6,8.3667E-7,2.8233E-6,-1.9433E-6,3.27E-6,-1.14E-6,4.7667E-6,6.46E-6,7.7E-7,1.8633E-6,-1.3867E-6,6.8167E-6,2.9467E-6,-7.6667E-7,5.2267E-6,3.6E-7,3.1167E-6,3.3133E-6,-1.6233E-6,3.16E-6,9.9E-7,6.5333E-7,2.33E-6,1.2667E-7,3.4867E-6,4.3667E-7,2.2067E-6,1.94E-6,-1.5867E-6,4.53E-6,-2.7733E-6,5.4867E-6,1.9433E-6,-1.5533E-6,3.2467E-6,-1.3333E-6,1.4833E-6,3.05E-6,-2.1833E-6,3.6867E-6,-1.0633E-6,1.4667E-6,2.7233E-6,-1.9533E-6,5.09E-6,-3.2667E-7,1.8633E-6,3.6767E-6,-3.1833E-6,3.8167E-6,-5.8333E-7,2.0467E-6,1.2067E-6,-2.1333E-6,4.6667E-6,-1.9633E-6,-4.54E-6,2.4167E-6,-2.5E-7,7.7993E-5,0.013571,0.015071,0.017117,0.014023,0.011516,0.012244,0.014864,0.016892,0.014298,0.011303,0.012338,0.014722,0.016774,0.014327,0.01119,0.01233,0.014664,0.016723,0.014351,0.011145,0.012264,0.014579,0.016669,0.014397,0.011127,0.01223,0.014519,0.016625,0.014412,0.011124,0.012199,0.014461,0.016643,0.014416,0.011088,0.012222,0.014407,0.016634,0.014418,0.011063,0.012206,0.014327,0.016628,0.014433,0.011102,0.012177,0.01432,0.016589,0.01444,0.011087,0.012105,0.014272,0.01661,0.014492,0.01115,0.012058,0.014236,0.016583,0.01449,0.011102,0.012031,0.014204,0.016596,0.014471,0.011079,0.012029,0.014141,0.016525,0.01452,0.011134,0.011957,0.014116,0.016544,0.014552,0.011101,0.012007,0.014091,0.016561,0.01458,0.011139,0.011974,0.014043,0.016516,0.014592,0.011121,0.011954,0.01401,0.016482,0.014605,0.011137,0.01191,0.013959,0.016477,0.014614,0.011143,0.011915,0.013913,0.016449,0.014695,0.011152,0.011866,0.01388,0.016441,0.014647,0.011118,0.01187,0.013849,0.016482,0.014715,0.011164,0.011819,0.01382,0.016444,0.014743,0.011167,0.011825,0.013763,0.016452,0.014743,0.011191,0.011819,0.013746,0.016458,0.014766,0.011229,0.011801,0.013724,0.016447,0.014764,0.0112,0.011769,0.013697,0.016407,0.014794,0.011262,0.011762,0.013636,0.016418,0.014803,0.011273,0.011741,0.013619,0.016392,0.014859,0.011249,0.011714,0.013558,0.016384,0.014826,0.01126,0.011708,0.013517,0.016371,0.01487,0.011317,0.011694,0.013517,0.016355,0.014961,0.011294,0.011669,0.013457,0.016327,0.014857,0.011314,0.011674,0.013426,0.016329,0.014906,0.011323,0.011638,0.013382,0.016323,0.014955,0.011385,0.011617,0.01338,0.016329,0.01494,0.011381,0.011638,0.013339,0.016301,0.015002:3
1.0444,1.1471,1.0578,0.79277,0.91545,1.0458,1.1549,1.0594,0.78582,0.90612,1.0448,1.1537,1.0551,0.78816,0.91854,1.039,1.1424,1.0627,0.79338,0.90502,1.0412,1.1497,1.0523,0.78719,0.90967,1.0415,1.1463,1.059,0.78321,0.90586,1.0321,1.1536,1.0533,0.78303,0.91204,1.0473,1.1469,1.0552,0.78647,0.90825,1.053,1.1485,1.058,0.788,0.91691,1.0423,1.1479,1.0598,0.78579,0.90549,1.0474,1.1531,1.0481,0.78928,0.9189,1.0492,1.1468,1.0513,0.78836,0.91189,1.043,1.1454,1.0547,0.79429,13.203,9.6657,7.3912,5.0882,4.9376,5.1449,5.8975,5.7207,4.6719,4.3156,4.979,5.6561,5.5782,4.6427,4.2588,4.9651,5.6408,5.569,4.6451,4.2591,4.9679,5.6432,5.5633,4.6452,4.2503,4.9714,5.6499,5.5656,4.6359,4.2495,4.9702,5.6429,5.5764,4.6334,4.2566,4.9777,5.6447,5.5677,4.6327,4.2591,4.9827,5.6461,5.5648,4.6347,4.2594,4.9872,5.6459,5.5628,4.6277,4.2556,4.9878,5.6486,5.5592,4.6352,4.255,4.9855,5.6631,5.566,4.6301,4.256,4.993,5.6621,5.5507,4.6211,4.2614,4.9969,5.6621,5.5574,4.6251,4.2597,5.0041,5.6583,5.5572,4.625,4.2615,5.0115,5.6663,5.5521,4.62,4.2662,5.013,5.6578,5.5444,4.6141,4.2581,5.0211,5.6695,5.5446,4.6179,4.2625,5.0134,5.6681,5.5488,4.617,4.2651,5.0118,5.675,5.5334,4.6096,4.2638,5.0161,5.6697,5.5434,4.6048,4.2694,5.0166,5.6724,5.535,4.6056,4.2668,5.0249,5.6704,5.5413,4.6069,4.2728,5.0255,5.6758,5.532,4.6,4.2723,5.0283,5.6759,5.5255,4.6,4.2712,5.0374,5.6749,5.5247,4.5945,4.2716,5.0311,5.6782,5.526,4.5982,4.2763,5.0455,5.6822,5.5373,4.5922,4.2763,5.0472,5.6828,5.5251,4.5974,4.2647,5.0307,5.6659,5.5156,4.5842,4.2694,5.0336,5.6725,5.5139,4.5795,4.2709,5.0293,5.6682,5.5048,4.5743,4.2694,5.0401,5.6709,5.506,4.5718,4.27,5.0321,5.6736,5.5047,4.5748,4.2717,5.042,5.6867,5.4944,4.5731,4.2709,5.0387,5.6802,5.4995,4.5724,4.2738,5.0507,5.6791,5.4939,4.5632,4.273,5.05,5.675,5.4934,4.5595,4.2788,5.052,5.6747,5.4851,4.5552,4.274,5.0463,5.6754,5.4919,4.5611,4.2737,5.0509,5.6814,5.4857,4.5627,4.2752,5.0531,5.6768,5.4923,4.5533,4.2794,5.0485,5.6831,5.4895,4.5452,4.2758,5.0704,5.6764,5.4797,4.5527,4.2827,5.0544,5.6889,5.4812,4.5386,4.2845,5.0707,5.674,5.471,4.5473,4.2845,5.0682,5.6884,5.4729,4.5503,4.2816,5.0788:3
87.39,71.649,75.142,90.616,101.21,86.497,70.749,74.716,90.629,101.63,87.132,71.057,75.014,91.197,102.68,87.136,70.506,74.172,90.541,101.56,86.945,71.155,74.824,90.695,101.9,86.989,70.869,74.936,90.984,101.69,86.869,71.043,74.949,90.785,101.8,86.784,70.754,74.918,91.046,101.65,86.786,71.165,75.297,91.535,102.71,87.542,71.475,75.571,91.326,101.19,86.02,70.822,75.247,91.286,102.02,86.678,70.893,75.625,92.355,102.55,87.145,71.242,75.34,91.125,101.52,86.278,70.584,75.182,91.435,101.89,86.421,70.855,75.261,91.27,101.61,86.059,70.645,75.227,91.522,101.96,86.578,71.423,76.045,92.283,102.44,86.509,71.143,75.922,92.562,102.75,86.802,71.571,76.331,92.687,102.58,86.857,71.538,76.109,92.726,102.68,86.355,71.067,75.733,91.609,101.18,85.463,70.67,75.564,92.377,101.64,84.649,69.876,75.231,91.523,101.16,85.322,70.381,75.407,92.329,101.76,84.635,69.69,75.171,91.487,101.14,85.117,70.247,75.417,92.253,101.53,84.342,69.603,75.324,91.585,101.03,84.842,70.267,75.573,92.313,101.0,83.818,69.725,75.454,91.616,100.96,84.64,70.447,75.72,91.931,100.09,83.95,69.957,75.596,91.846,101.01,84.954,70.349,75.242,90.712,100.14,84.041,70.275,75.29,92.34,100.35,83.192,68.996,74.973,91.331,99.912,83.629,68.587,74.241,90.295,99.442,82.378,68.434,73.519,89.283,99.139,81.18,67.676,73.975,88.884,97.8,78.583,67.046,73.029,86.902,92.28,76.81,64.673,67.216,80.106,85.802,65.114,53.058,57.744,62.932,56.748,39.308,29.053,27.574,24.877,21.147,15.329,13.091,15.515,17.438,17.913,14.26,12.908,15.261,17.119,17.97,14.382,13.057,14.974,16.65,17.539,14.245,13.417,15.455,17.005,17.456,13.828,13.119,15.197,17.226,17.637,13.943,13.352,15.104,16.986,17.205,14.063,13.2,14.978,17.431,17.347,13.961,13.111,15.015,17.088,17.169,14.319,13.083,14.984,17.162,17.018,14.152,12.961,15.196,17.241,17.065,14.178,12.884,15.101,17.05,16.959,14.341,12.999,15.428,16.885,16.831,14.098,12.826,15.498,16.95,17.052,13.889,12.823,15.304,16.671,17.189,14.144,12.949,15.12,16.651,17.211,13.766,13.015,15.323,16.656,17.201,13.823,12.854,14.919,16.754,17.324,13.658,13.043,15.069,16.569,17.211,13.735,13.101,14.955,16.909,17.078:3
2.3273,2.6991,2.267,1.8244,1.921,2.3344,2.7118,2.2655,1.8353,1.9082,2.3436,2.7029,2.2597,1.8409,1.8981,2.3499,2.6919,2.2582,1.8433,1.899,2.3596,2.6795,2.2606,1.8369,1.8935,2.3608,2.6694,2.2677,1.835,1.896,2.3632,2.6614,2.2815,1.8311,1.8998,2.3702,2.6582,2.2973,1.8277,1.9014,2.3646,2.6471,2.3099,1.8227,1.91,2.3537,2.6332,2.3117,1.8127,1.9186,2.3475,2.6369,2.3203,1.8071,1.9294,2.3392,2.6484,2.3253,1.8051,1.9317,2.3238,2.661,2.3262,1.8101,1.9373,2.3172,2.6723,2.3169,1.8057,1.9265,2.3033,2.6775,2.3107,1.8114,1.9253,2.3012,2.6914,2.3111,1.8214,1.9217,2.2927,2.6917,2.302,1.8308,1.9168,2.2977,2.7009,2.2883,1.8358,1.9021,2.3017,2.7027,2.2868,1.8451,1.8943,2.3103,2.6911,2.2768,1.8492,1.8884,2.3297,2.6883,2.2858,1.8512,1.8785,2.3356,2.6779,2.2952,1.8524,1.8792,2.3384,2.667,2.3072,1.8479,1.8776,2.3323,2.6492,2.3174,1.8438,1.886,2.338,2.646,2.3298,1.8386,1.8935,2.3381,2.6328,2.3306,1.8235,1.9007,2.3351,2.64,2.3461,1.8183,1.9085,2.3232,2.6367,2.3521,1.8119,1.9169,2.3107,2.6562,2.3564,1.8143,1.9151,2.289,2.6596,2.3503,1.8248,1.9271,2.2874,2.6714,2.339,1.8197,1.9162,2.2784,2.6821,2.3417,1.8294,1.9089,2.2689,2.6856,2.3331,1.838,1.9073,2.2748,2.6931,2.3248,1.847,1.8973,2.2776,2.699,2.3161,1.8499,1.8798,2.2782,2.6938,2.3117,1.8627,1.8772,2.2915,2.6819,2.3056,1.8628,1.8726,2.3075,2.6816,2.3172,1.8587,1.8654,2.308,2.6731,2.3339,1.8678,1.8694,2.3048,2.6574,2.3344,1.8583,1.874,2.3119,2.6555,2.3468,1.8511,1.8712,2.3066,2.6414,2.3553,1.8461,1.8816,2.3023,2.6345,2.3643,1.8345,1.8857,2.2948,2.6358,2.3753,1.8324,1.8967,2.2822,2.6418,2.3814,1.8268,1.9014,2.2626,2.6526,2.384,1.8324,1.9064,2.2528,2.6581,2.3734,1.832,1.904,2.2512,2.6679,2.3717,1.8345,1.8968,2.244,2.6713,2.3616,1.8409,1.8953,2.249,2.6813,2.3593,1.845,1.8805,2.2373,2.6901,2.3556,1.8631,1.8798,2.2451,2.6894,2.3427,1.8654,1.8668,2.2546,2.6905,2.3419,1.8753,1.8581,2.2659,2.6791,2.3448,1.8811,1.8558,2.2742,2.6653,2.3486,1.8771,1.8553,2.284,2.6654,2.3626,1.8718,1.851,2.2727,2.6502,2.3727,1.8746,1.8616,2.2789,2.6398,2.3757,1.8647,1.8616,2.2783,2.6338,2.39,1.8615,1.863,2.2683,2.6292,2.4043,1.861,1.8796:3
2.0029,2.1678,1.8046,1.4222,1.5659,1.9898,2.165,1.8161,1.4151,1.5786,1.9734,2.1737,1.8201,1.4115,1.5841,1.9574,2.1937,1.82,1.4161,1.5836,1.9446,2.2069,1.8131,1.4205,1.5757,1.9263,2.2127,1.8059,1.4246,1.5685,1.9212,2.2252,1.7969,1.4362,1.5599,1.9195,2.2361,1.7851,1.4461,1.543,1.9239,2.2436,1.7787,1.4541,1.5295,1.9382,2.2362,1.7796,1.4603,1.5126,1.9515,2.2284,1.7887,1.4621,1.5112,1.9638,2.2129,1.7988,1.4546,1.5107,1.9664,2.1969,1.812,1.4518,1.5133,1.9709,2.1854,1.8247,1.4425,1.519,1.9712,2.1731,1.8387,1.435,1.5287,1.9635,2.1722,1.8553,1.4279,1.5437,1.9436,2.1778,1.8613,1.4212,1.5494,1.9241,2.1935,1.8603,1.4237,1.5513,1.9059,2.21,1.8565,1.4265,1.5448,1.8937,2.2212,1.8492,1.4351,1.5403,1.889,2.2345,1.8438,1.447,1.5313,1.887,2.2455,1.8347,1.457,1.5165,1.8916,2.2564,1.8233,1.4678,1.503,1.9075,2.2524,1.8236,1.4768,1.4902,1.922,2.238,1.8312,1.4793,1.4868,1.9301,2.2167,1.8424,1.4745,1.4855,1.9322,2.2035,1.8554,1.469,1.489,1.9382,2.1944,1.8733,1.4603,1.494,1.9346,2.1798,1.8856,1.4509,1.5063,1.9306,2.1804,1.9006,1.4427,1.5165,1.9116,2.1812,1.9074,1.4386,1.5272,1.8956,2.1967,1.908,1.4377,1.5279,1.8744,2.2163,1.9066,1.4451,1.5282,1.8651,2.2295,1.8965,1.4531,1.5204,1.8578,2.2389,1.8884,1.4627,1.513,1.8557,2.2454,1.8777,1.4745,1.5012,1.8601,2.2528,1.8686,1.4866,1.4855,1.8699,2.2519,1.8674,1.4953,1.4731,1.8823,2.2341,1.869,1.4967,1.4688,1.8929,2.2224,1.8843,1.4989,1.4695,1.8966,2.2097,1.8982,1.4877,1.4705,1.8953,2.1943,1.9132,1.4805,1.4775,1.8909,2.186,1.9281,1.4736,1.4901,1.8854,2.1789,1.9422,1.4676,1.5013,1.8669,2.1815,1.9519,1.4607,1.5111,1.8508,2.1951,1.9497,1.4579,1.5132,1.8357,2.2177,1.9496,1.4692,1.5113,1.8196,2.2262,1.9382,1.4738,1.5064,1.8122,2.2293,1.9314,1.4815,1.4968,1.8164,2.2406,1.9247,1.4951,1.482,1.8146,2.2445,1.9139,1.5055,1.4672,1.8247,2.2438,1.9117,1.515,1.4572,1.8386,2.2313,1.9149,1.5174,1.4495,1.85,2.2192,1.9297,1.517,1.4496,1.8472,2.2007,1.9433,1.5127,1.4568,1.8502,2.1875,1.9537,1.5057,1.4572,1.8453,2.1765,1.9676,1.4991,1.4686,1.8398,2.1693,1.982,1.4909,1.4817,1.8246,2.1647,1.991,1.4823,1.4911,1.8059,2.1766,1.9918,1.4812,1.4938,1.7908,2.1922,1.9868,1.4852,1.4906,1.7774,2.2084,1.9826,1.4955,1.4875,1.7732,2.2176,1.9781,1.5038,1.4779,1.7693,2.2268,1.9722,1.5167,1.4699,1.7636,2.2303,1.9574,1.5291,1.4588,1.7737,2.2327,1.9533,1.5385,1.4465,1.7891,2.2229,1.9511,1.5421,1.4374,1.7987,2.2067,1.9673,1.5461,1.4407,1.8016,2.1944,1.9836,1.5407,1.4455,1.8,2.1752,1.9926,1.5347,1.4479,1.8007,2.1639,2.0141,1.5292,1.4526,1.794,2.1553,2.0282,1.5235,1.4636,1.7774,2.1513,2.0395,1.5167,1.4775,1.7633,2.1621,2.045,1.5129,1.4781,1.7441,2.1819,2.0419,1.515,1.4778,1.7278,2.1929,2.0361,1.5228,1.4734,1.7238,2.2006,2.028,1.5339,1.4668,1.7185,2.2093,2.0193,1.5424,1.4568,1.7134,2.2164,2.0083,1.5593,1.446,1.72,2.2142,1.9975,1.5689,1.4366,1.7362,2.2046,1.9988,1.5781,1.4278,1.7445,2.1886,2.0117,1.584,1.4289,1.7477,2.1707,2.0253,1.5787,1.4304,1.7482,2.1574,2.045,1.5766,1.4357,1.7458,2.1437,2.0591,1.5696,1.4405,1.7374,2.132,2.0706,1.561,1.4516,1.7244,2.1259,2.0871,1.5521,1.4658,1.7078,2.1327,2.0904,1.5461,1.47,1.6872,2.1534,2.085,1.5486,1.4715,1.671,2.1668,2.0783,1.5581,1.4654,1.6601,2.1767,2.0709,1.5685,1.4579,1.6535,2.181,2.0607,1.5823,1.4533,1.6563,2.1901,2.0483,1.5925,1.442,1.6593,2.1914,2.0407,1.606,1.4281,1.6762,2.179,2.0411,1.6182,1.4187,1.6881,2.1599,2.0491,1.6226,1.4173,1.6922,2.1397,2.0651,1.6199,1.4202,1.6931,2.1266,2.0819,1.6153,1.423,1.6856,2.1098,2.0977,1.6086,1.4316,1.6846,2.1022,2.1096,1.6004,1.4422,1.6721,2.101,2.1283,1.5944,1.4543,1.6516,2.1013,2.1295,1.59,1.4638,1.6349,2.1219,2.1281,1.5937,1.4658,1.6187,2.1355,2.1217,1.6033,1.4633,1.612,2.1426,2.1095,1.6146,1.4594,1.6093,2.1477,2.1011,1.6264,1.4499,1.6076,2.1534,2.0902,1.6399,1.4387,1.6111,2.1579,2.0835,1.6546,1.4261,1.621,2.1448,2.0791,1.6682,1.4177,1.633,2.1262,2.0853,1.6722,1.4139,1.6377,2.1036,2.1007,1.6679,1.4187,1.6396,2.0901,2.1199,1.6663,1.4233,1.6347,2.0743,2.131,1.661,1.4329,1.6306,2.0664,2.1468,1.6563,1.4397,1.6143,2.0605,2.1602,1.6484,1.4528,1.5965,2.0681,2.1724,1.6445,1.4661,1.5817,2.082,2.1677,1.6469,1.4691,1.566,2.0939,2.1593,1.6513,1.4615,1.5565,2.0998,2.1493,1.6641,1.4572,1.56,2.1021,2.1384,1.6774,1.4496,1.5557,2.1062,2.1269,1.6914,1.4422,1.5623,2.1092,2.1151,1.706,1.431,1.5726,2.101,2.1119,1.7188,1.4221,1.5847,2.0839,2.1157,1.7233,1.4177,1.5906,2.0598,2.131,1.7209,1.4167,1.5865,2.0447,2.1466,1.7244,1.4256,1.5833,2.0276,2.1558,1.7183,1.4346,1.5766,2.0183,2.168,1.7137,1.4452,1.5677,2.018,2.1823,1.7071,1.4535,1.5514,2.0194,2.1922,1.6989,1.4605,1.5316,2.0326,2.1929,1.7035,1.4696,1.5213,2.0457,2.1811,1.7098,1.4699,1.5132,2.0533,2.1722,1.719,1.467,1.5109,2.0541,2.1584,1.7303,1.4596,1.5106,2.0576,2.1483,1.747,1.4554,1.514,2.0557,2.1353,1.7587,1.4453,1.5222,2.0511,2.1295,1.7749,1.4345,1.5306,2.0329,2.1282,1.7835,1.4289,1.5374,2.0126,2.1428,1.7891,1.4295,1.5395,1.9973,2.1576,1.785,1.436,1.5372,1.9812,2.1692,1.7817,1.4424,1.5311,1.9773,2.184,1.7764,1.4471,1.5238,1.9702,2.1985,1.7721,1.4594,1.5096,1.9643,2.2099,1.7677,1.4727,1.4959,1.9733,2.2068,1.7631,1.4806,1.4817,1.99,2.2001,1.7656,1.481,1.4732,2.0014,2.1838,1.7761,1.4802,1.4731,2.0053,2.1747,1.7887,1.4746,1.4704,2.0037,2.1568,1.8024,1.4652,1.4714,2.0044,2.1436,1.8172,1.4581,1.4796,2.0037,2.1365,1.8372,1.4527,1.4899,1.9862,2.1362,1.8516,1.4459,1.5005,1.9639,2.1422,1.8533,1.4415,1.4992,1.942,2.1578,1.8525,1.4478,1.5016,1.9263,2.1729,1.8493,1.4561,1.496,1.9194,2.1862,1.8448,1.4617,1.484,1.9102,2.1988,1.8421,1.4786,1.4756,1.9109,2.2053,1.8319,1.4856,1.4589,1.919,2.2101,1.8291,1.4992,1.4464,1.9321,2.1977,1.8305,1.5029,1.4381,1.9442,2.1837,1.8396,1.5029,1.4328,1.9461,2.1703,1.8567,1.5011,1.4375,1.9462,2.1558,1.8699,1.4931,1.4363,1.9407,2.1416,1.8861,1.4866,1.4446,1.9393,2.1332,1.9022,1.4804,1.4551,1.9244,2.1291,1.9144,1.4733,1.4658,1.9061,2.1354,1.9234,1.4715,1.4722,1.8923,2.149,1.9222,1.4708,1.4724,1.8736,2.1645,1.9187,1.4758,1.4668,1.8571,2.1724,1.912,1.4836,1.4591,1.8515,2.1796,1.9071,1.4932,1.4502,1.8478,2.1923,1.8992,1.5071,1.4379,1.8524,2.1958,1.8921,1.5172,1.4234,1.8642,2.1891,1.8931,1.5257,1.4097,1.8734,2.1763,1.9004,1.5315,1.4101,1.8775,2.1561,1.9148,1.5277,1.4083,1.8819,2.1425,1.9312,1.5228,1.4085,1.8809,2.1253,1.9534,1.5226,1.4184,1.8757,2.1145,1.9655,1.5128,1.4267,1.8685,2.106,1.9819,1.5055,1.4352,1.8447,2.1046,1.9899,1.5,1.4466,1.8315,2.1245,1.993,1.4988,1.4441,1.8113,2.1404,1.9926,1.5074,1.4409,1.7948,2.1493,1.9839,1.5154,1.4396,1.7909,2.1581,1.9753,1.527,1.4298,1.7864,2.1673,1.9687,1.5399:3
0.0092225,0.0093485,0.0072639,0.006799,0.0071031,0.0091813,0.0093648,0.0072587,0.0067982,0.0070991,0.0091614,0.0093756,0.0072611,0.006799,0.0071404,0.0091957,0.0093667,0.0072508,0.0067902,0.0071098,0.0092395,0.009335,0.0072707,0.0068363,0.0071187,0.0092282,0.0093643,0.0072343,0.0067781,0.0071051,0.0092063,0.0093416,0.0072147,0.0067924,0.0071397,0.0092132,0.0093389,0.0072396,0.0068092,0.0071043,0.0092029,0.0093485,0.0072153,0.006772,0.0071295,0.0092163,0.0093276,0.0072062,0.0067969,0.0070898,0.009213,0.0093332,0.0071948,0.0068063,0.0071374,0.0091956,0.0093735,0.0071617,0.006763,0.0071473,0.0091893,0.0093124,0.0071608,0.0067862,0.0071346,0.0092312,0.0093159,0.00715,0.0067906,0.0071625,0.0092216,0.0093111,0.0071748,0.0067943,0.0071312,0.0092454,0.0092938,0.0071748,0.0067943,0.0071816,0.009227,0.0092636,0.0071479,0.0067934,0.0071919,0.0092794,0.0093157,0.0071657,0.0067879,0.007223,0.0092601,0.0093271,0.0071591,0.0067795,0.0072121,0.0092529,0.0092924,0.0071257,0.006806,0.0072242,0.0092718,0.0092905,0.0071356,0.0067777,0.0072154,0.0092468,0.0092865,0.0071205,0.0067953,0.0072029,0.009238,0.0093152,0.0070921,0.0067614,0.0072115,0.0092516,0.0092747,0.0071026,0.0068014,0.0072464,0.009234,0.0092453,0.0070925,0.0067653,0.0072219,0.0092538,0.0093085,0.0071179,0.0067784,0.007253,0.0092991,0.0092921,0.0071045,0.0067671,0.0072453,0.0092437,0.0093056,0.0070476,0.0068098,0.0072221,0.0092844,0.0092831,0.0070638,0.0067881,0.0072687,0.009301,0.0092799,0.0070773,0.0067967,0.0072514,0.0093231,0.0092683,0.0070438,0.0067878,0.007273,0.0092878,0.0092595,0.0070375,0.0068147,0.0073125,0.0092976,0.0092856,0.007036,0.0067929,0.0072656,0.0092804,0.0092525,0.0070082,0.0068062,0.0072823,0.0092958,0.009228,0.007021,0.0068143,0.0072751,0.0093169,0.0092293,0.0070424,0.0067891,0.0072734,0.0092752,0.009219,0.0070231,0.0067989,0.0072553,0.0092677,0.0092279,0.0069995,0.0067946,0.0073317,0.0092918,0.009213,0.006971,0.0067879,0.0073168,0.0092833,0.0092104,0.0069809,0.0067949,0.007326,0.009286,0.0091797,0.0069895,0.0068013,0.0072839,0.0092568,0.0091894,0.0069612,0.0067758,0.0073009,0.0092674,0.0091956,0.006931,0.0067753,0.0073176,0.009292,0.0091946,0.006954,0.0067891,0.0073717,0.0092754,0.0091647,0.0069374,0.0068052,0.0073486,0.0093131,0.0091213,0.0068959,0.0068061,0.0073201,0.0093026,0.0091419,0.0068982,0.006817,0.0073665,0.0093377,0.0091297,0.0068871,0.0067798,0.0073197,0.009314,0.0091426,0.006921,0.0068002,0.0073699,0.0093104,0.0091437,0.0068895,0.0068099,0.0073697,0.0092765,0.0091357,0.0068689,0.0067593,0.0073982,0.0093066,0.0091491,0.0068758,0.0068019,0.0073968,0.0093191,0.0091438,0.0068656,0.0068154,0.0073788,0.0093335,0.009104,0.0068687,0.0068059,0.0074027,0.0093379,0.0090721,0.006852,0.0068208,0.0074152,0.0093517,0.0090709,0.0068161,0.0067989,0.0073858,0.0093045,0.0090828,0.0068478,0.0067803,0.0074242,0.0093048,0.0090645,0.0068209,0.0068019,0.0074216,0.0093499,0.0090451,0.0067781,0.0067882,0.0074015,0.0093124,0.0090612,0.0067921,0.0068243,0.0074382:3
6.119E-5,7.1513E-5,7.9133E-5,7.3137E-5,5.456E-5,6.1403E-5,7.175E-5,7.9997E-5,7.3487E-5,5.4613E-5,6.2093E-5,7.1857E-5,7.9007E-5,7.313E-5,5.421E-5,6.1873E-5,7.1877E-5,7.912E-5,7.308E-5,5.473E-5,6.2113E-5,7.156E-5,7.9803E-5,7.3087E-5,5.4457E-5,6.2277E-5,7.0613E-5,7.9507E-5,7.2553E-5,5.454E-5,6.198E-5,7.1913E-5,7.8753E-5,7.3437E-5,5.495E-5,6.2E-5,7.1903E-5,7.9357E-5,7.3317E-5,5.4253E-5,6.306E-5,7.1563E-5,7.811E-5,7.2137E-5,5.3627E-5,6.2183E-5,7.1883E-5,7.909E-5,7.2477E-5,5.404E-5,6.2537E-5,7.2057E-5,7.8827E-5,7.1213E-5,5.3797E-5,6.261E-5,7.2257E-5,7.8723E-5,7.188E-5,5.4907E-5,6.247E-5,7.2693E-5,7.8537E-5,7.175E-5,5.401E-5,6.214E-5,7.3147E-5,7.8037E-5,7.1533E-5,5.4057E-5,6.2E-5,7.296E-5,7.8587E-5,7.1377E-5,5.3807E-5,6.3133E-5,7.2463E-5,7.9007E-5,7.1057E-5,5.3357E-5,6.3533E-5,7.3557E-5,7.809E-5,7.0837E-5,5.3897E-5,6.2587E-5,7.2907E-5,7.8637E-5,7.084E-5,5.3173E-5,6.323E-5,7.3723E-5,7.86E-5,7.0143E-5,5.381E-5,6.4123E-5,7.2683E-5,7.771E-5,7.114E-5,5.4083E-5,6.2537E-5,7.337E-5,7.8353E-5,7.137E-5,5.384E-5,6.283E-5,7.3117E-5,7.861E-5,7.0717E-5,5.288E-5,6.3907E-5,7.3753E-5,7.8743E-5,7.016E-5,5.3843E-5,6.3703E-5,7.419E-5,7.8333E-5,6.9837E-5,5.391E-5,6.4713E-5,7.367E-5,7.8397E-5,7.0657E-5,5.309E-5,6.4293E-5,7.4147E-5,7.76E-5,6.984E-5,5.3403E-5,6.4047E-5,7.4387E-5,7.8043E-5,6.8973E-5,5.4653E-5,6.4167E-5,7.47E-5,7.8247E-5,6.9403E-5,5.331E-5,6.3233E-5,7.4297E-5,7.6617E-5,6.923E-5,5.3547E-5,6.451E-5,7.343E-5,7.815E-5,6.912E-5,5.361E-5,6.4257E-5,7.4383E-5,7.762E-5,7.0027E-5,5.3967E-5,6.482E-5,7.468E-5,7.6707E-5,6.9193E-5,5.254E-5,6.4263E-5,7.515E-5,7.8733E-5,6.7097E-5,5.2623E-5,6.5127E-5,7.551E-5,7.6893E-5,6.843E-5,5.281E-5,6.5023E-5,7.4423E-5,7.7057E-5,6.83E-5,5.2967E-5,6.5137E-5,7.494E-5,7.756E-5,6.7567E-5,5.2623E-5,6.53E-5,7.5127E-5,7.8113E-5,6.8173E-5,5.3623E-5,6.4923E-5,7.5793E-5,7.793E-5,6.7837E-5,5.3463E-5,6.5957E-5,7.505E-5,7.7783E-5,6.7423E-5,5.2843E-5,6.6237E-5,7.5287E-5,7.713E-5,6.7057E-5,5.2623E-5,6.5187E-5,7.5833E-5,7.7363E-5,6.6707E-5,5.2713E-5,6.5677E-5,7.576E-5,7.664E-5,6.5953E-5,5.3237E-5,6.474E-5,7.4923E-5,7.6937E-5,6.7007E-5,5.284E-5,6.5853E-5,7.634E-5,7.7063E-5,6.595E-5,5.2707E-5,6.664E-5,7.7023E-5,7.6743E-5,6.6577E-5,5.3377E-5,6.7273E-5,7.526E-5,7.6167E-5,6.6977E-5,5.262E-5,6.5423E-5,7.6477E-5,7.703E-5,6.5247E-5,5.2757E-5,6.6663E-5,7.629E-5,7.5673E-5,6.46E-5,5.2797E-5,6.7453E-5,7.608E-5,7.5757E-5,6.483E-5,5.345E-5,6.74E-5,7.6303E-5,7.567E-5,6.5127E-5,5.3123E-5,6.7457E-5,7.6073E-5,7.6607E-5,6.569E-5,5.389E-5,6.6367E-5,7.6187E-5,7.627E-5,6.5827E-5,5.302E-5,6.7403E-5,7.6297E-5,7.5277E-5,6.3027E-5,5.2863E-5,6.7293E-5,7.627E-5,7.5623E-5,6.4233E-5,5.351E-5,6.7533E-5,7.6073E-5,7.6617E-5,6.419E-5,5.2873E-5,6.7653E-5,7.739E-5,7.7537E-5,6.3823E-5,5.3693E-5,6.7853E-5,7.7627E-5,7.5657E-5,6.4413E-5,5.378E-5,6.89E-5,7.6947E-5,7.676E-5,6.3973E-5,5.3773E-5,6.9373E-5,7.8103E-5,7.561E-5,6.3907E-5,5.469E-5,6.9017E-5,7.7347E-5,7.514E-5,6.3617E-5,5.4173E-5,6.8407E-5,7.8203E-5,7.5297E-5,6.372E-5,5.3627E-5,6.8777E-5,7.8383E-5,7.528E-5,6.2797E-5,5.3683E-5,6.811E-5,7.8007E-5,7.4853E-5,6.4227E-5,5.3733E-5,6.882E-5,7.8343E-5,7.566E-5,6.352E-5,5.404E-5,6.9107E-5,7.8527E-5,7.5E-5,6.3517E-5,5.399E-5,7.002E-5,7.865E-5,7.5697E-5,6.2707E-5,5.3783E-5,6.863E-5,7.8607E-5,7.457E-5,6.2487E-5,5.497E-5,7.028E-5,7.8337E-5,7.4723E-5,6.3007E-5,5.4163E-5,7.0087E-5,7.8793E-5,7.4803E-5,6.22E-5,5.4523E-5,6.926E-5,7.7663E-5,7.472E-5,6.3193E-5,5.428E-5,6.9293E-5,7.928E-5,7.484E-5,6.2233E-5,5.4427E-5,7.0913E-5,0.0025383,0.013144,0.018456,0.017465,0.018469,0.018213,0.017264,0.021686,0.01748,0.020098,0.022657,0.024575,0.021474,0.017173,0.019023,0.022522,0.024417,0.021029,0.016779,0.01934,0.022011,0.024057,0.020738,0.016934,0.018857,0.021821,0.023456,0.019866,0.015919,0.017996,0.02061,0.021238,0.017797,0.013968,0.014562,0.0077491,0.0055679,0.0029025,0.0017575,0.0014409,0.0019461,0.0023785,0.0021506,0.0016945,0.0017892,0.0020951,0.002349,0.0020559,0.0015603,0.0017059,0.0020407,0.0023425,0.0020901,0.0015936,0.0017883,0.0021093,0.0023755,0.0020933,0.0015726,0.0017587,0.002083,0.0023786,0.0021277,0.0016266,0.0018353,0.0021178,0.0023943,0.0020996,0.0015812,0.0017998,0.0021272,0.002439,0.0021377,0.0016389,0.0018462,0.0021403,0.0024216,0.0021047,0.0016217,0.0018573,0.0021782,0.0024715,0.0021325,0.0016342,0.0018528,0.0021732,0.0024664,0.0021241,0.0016491,0.0018851,0.0021992,0.0024752,0.0021136,0.0016549,0.0018787,0.0022156,0.0025121,0.0021357,0.0016675,0.001875,0.0022165,0.0024871,0.0021147,0.001671,0.0019062,0.0022648,0.0025082,0.0021288,0.0016923,0.0019088,0.002273,0.0025046,0.0021313,0.0016832,0.0019211,0.0022899,0.0025067,0.0021359,0.0016829,0.0019406,0.0023116,0.0025139,0.0021368,0.0016797,0.001939,0.0023239,0.0025095,0.0021412,0.0016842,0.0019695,0.0023433,0.0024988,0.0021444,0.0016825,0.00198,0.0023448,0.0025191,0.0021578,0.0016924,0.0019965,0.0023446,0.0025276,0.0021665,0.0017021,0.0020018,0.0023451,0.0025301,0.0021488,0.0016958,0.0020317,0.0023556,0.0025456,0.0021573,0.0017076,0.0020384,0.0023575,0.0025546,0.0021507,0.0017138,0.0020445,0.0023793,0.0025603,0.0021255,0.0017158,0.0020493,0.0023818,0.0025674,0.0021362,0.0017267,0.0020458,0.0023818,0.0025783,0.0021279,0.0017415,0.0020594,0.0024049,0.0025795,0.0021089,0.0017414,0.002064,0.0024269,0.0025846,0.0021359,0.001764,0.002066,0.0024536,0.0025756,0.0021256,0.0017548,0.0020809,0.0024585,0.0025694,0.0021286,0.0017637,0.0021056,0.0024865,0.0025799,0.0021305,0.0017604,0.0021107,0.0024905,0.0025618,0.0021411,0.0017609,0.0021232,0.0025023,0.0025701,0.0021414,0.0017608,0.0021455,0.0025239,0.0025732,0.0021487,0.0017672,0.0021557,0.0025192,0.0025687,0.0021462,0.0017671,0.0021772,0.0025113,0.0025909,0.0021478,0.0017659,0.0021894,0.0025138,0.0025967,0.0021506,0.0017768,0.0022026,0.0025216,0.0025836,0.0021266,0.0017777,0.0022059,0.0025246,0.0026048,0.00213,0.0017911,0.0022152,0.0025364,0.0026082,0.0021201,0.0018004,0.0022273,0.0025444,0.0026216,0.0021066,0.0018108,0.0022244,0.0025725,0.0026239,0.0021178,0.0018221,0.0022125,0.0025805,0.0026225,0.0021172,0.0018315,0.0022378,0.0025964,0.002596,0.0021134,0.0018266,0.0022544,0.0026279,0.0026018,0.0021256,0.001829,0.0022714,0.0026366,0.0025988,0.0020705,0.0018777,0.0023023,0.0026548,0.0025918,0.0021285,0.0018209,0.0023016,0.0026658,0.0025857,0.0021354,0.0018339,0.0023187,0.0026652,0.0025794,0.0021394,0.0018235,0.0023208,0.0026466,0.0022931,0.0017374,0.0014568,0.0018537,0.0021523,0.0021714,0.0017549,0.0014682,0.0018782,0.0021564,0.0021759,0.0017464,0.0014659,0.0018837,0.0021546,0.0021685,0.0017285,0.0014751,0.0018871,0.002168,0.0021865,0.0017228,0.0014754,0.0018862,0.0021645,0.0021969,0.0017195,0.0015032,0.0018902,0.0021999,0.0021822,0.0017237,0.001503,0.0018837,0.0022195,0.0021847,0.0017316,0.0015172,0.001904,0.0022325,0.0021656,0.0017215,0.0015093,0.0019131,0.0022388,0.0021506,0.0017315,0.001506,0.0019124,0.002238,0.0021488,0.0017488,0.0015159,0.0019414,0.0022608,0.0021381,0.0017382,0.0014972,0.0019451,0.0022675,0.0021502,0.0017448,0.0014938,0.0019623,0.0022657,0.0021317,0.00174,0.0014917,0.0019845,0.0022422,0.0021322,0.0017425,0.0015038,0.0019825,0.0022546,0.0021426,0.0017353,0.0015147,0.0019987,0.0022406,0.002132,0.0017247,0.001513,0.0019949,0.0022439,0.0021486,0.0017145,0.0015207,0.002001,0.0022448,0.0021426,0.00171,0.0015255,0.0019874,0.0022578,0.0021366,0.0016956,0.0015345,0.0019826,0.0022629,0.0021266,0.0016943,0.0015353,0.0019879,0.0022672,0.0021229,0.0016867,0.0015405,0.0019921,0.0022973,0.0021192,0.0017037,0.0015295,0.0019964,0.0022864,0.002096,0.001706,0.0015492,0.0020059,0.0023119,0.0020786,0.0016952,0.0015325,0.002015,0.0023153,0.0020808,0.0017089,0.0015234,0.0020356,0.0023059,0.0020673,0.0017131,0.001526,0.0020564,0.0023027,0.00208,0.0017109,0.0015376,0.0020617,0.0022932,0.0020827,0.0017115,0.0015405,0.0020718,0.0022892,0.002071,0.0016899,0.0015356,0.0020785,0.0022805,0.0020857,0.0016904,0.0015516,0.0020816,0.0023018,0.0020854,0.001681,0.0015643,0.0020726,0.0022959,0.0020857,0.0016716,0.0015816,0.0020722,0.0023141,0.0020976,0.001684,0.0015845,0.0020713,0.0023366,0.0020758,0.0016819,0.0016011,0.00208,0.0023369,0.0020591,0.0016849,0.0015944,0.0020794,0.0023456,0.002047,0.0016884,0.001597,0.002071,0.0023455,0.0020279,0.0016764,0.0015749,0.0020771,0.002355,0.002013,0.0016848,0.0015762,0.0021041,0.0023495,0.0020099,0.0016931,0.0015687,0.0021284,0.0023538,0.0020098,0.0016893,0.0015862,0.0021406,0.0023351,0.0020184,0.0016836,0.0015842,0.0021343,0.0023252,0.0020227,0.0016732,0.0015774,0.0021438,0.0023094,0.0020139,0.0016856,0.001593,0.002149,0.0023217,0.0020216,0.0016651,0.0016065,0.002149,0.0023269,0.0020201,0.0016621,0.0016317,0.0021409,0.0023391,0.0020259,0.0016653,0.0016361,0.0021393,0.0023433,0.0020039,0.00166,0.0016355,0.0021364,0.0023573,0.0019865,0.0016711,0.0016323,0.0021433,0.0023655,0.0019828,0.0016629,0.0016295,0.0021354,0.0023778,0.0019693,0.0016784,0.0016242,0.0021384,0.0023857,0.0019602,0.0016771,0.0016194,0.0021591,0.002359,0.0019426,0.0016766,0.0016214,0.0021713,0.0023541,0.001944,0.0016762,0.0016179,0.0021859,0.0023547,0.0019481,0.0016772,0.0016353,0.0021933,0.002337,0.0019412,0.0016584,0.0016222,0.0022109,0.002334,0.001957,0.0016592,0.0016381,0.0022138,0.0023326,0.001953,0.0016534,0.001662,0.0022094,0.0023328,0.0019576,0.0016569,0.0016716,0.002192,0.0023532,0.0019602,0.0016538,0.0016814,0.0021923,0.0023435,0.0019391,0.0016472,0.0016736,0.0021773,0.0023625,0.0019254,0.0016488,0.0016815,0.0021806,0.0023666,0.0019171,0.001663,0.0016867,0.0021911,0.0023877,0.0019102,0.0016815,0.001681,0.0022063,0.002401,0.0018957,0.0016813,0.0016794,0.0022317,0.0023933,0.0019014,0.0016885,0.0016724,0.0022382,0.0023789,0.0018944,0.001689,0.0016909,0.0022697,0.0023672,0.0019015,0.0016797,0.0017009,0.0022714,0.0023716,0.0019068,0.0016758,0.0016922,0.0022688,0.0023524,0.0019016,0.0016717,0.0017161,0.0022755,0.00235,0.0018947,0.0016448,0.0016939:3
4.1653E-4,5.0707E-4,5.7593E-4,5.6743E-4,4.8648E-4,4.1534E-4,5.037E-4,5.7594E-4,5.6681E-4,4.8752E-4,4.1664E-4,5.0282E-4,5.732E-4,5.6652E-4,4.8885E-4,4.1671E-4,5.0458E-4,5.7278E-4,5.6693E-4,4.886E-4,4.1301E-4,5.0314E-4,5.735E-4,5.6826E-4,4.9028E-4,4.1622E-4,5.0195E-4,5.7145E-4,5.6893E-4,4.8914E-4,4.1608E-4,4.9933E-4,5.7139E-4,5.6877E-4,4.9112E-4,4.1565E-4,5.0054E-4,5.727E-4,5.698E-4,4.9194E-4,4.1657E-4,4.9895E-4,0.0063675,0.013089,0.019486,0.017597,0.018713,0.018401,0.019188,0.022318,0.016713,0.019303,0.021874,0.024428,0.021954,0.017093,0.019003,0.021961,0.02431,0.021842,0.017184,0.018931,0.021881,0.024418,0.021842,0.017178,0.018844,0.021843,0.02435,0.0219,0.017304,0.018841,0.021827,0.024412,0.021929,0.017165,0.018795,0.021796,0.024315,0.02196,0.017164,0.018845,0.021646,0.024338,0.021948,0.017188,0.018699,0.021627,0.024386,0.021948,0.017271,0.018718,0.021609,0.024353,0.021967,0.017212,0.018666,0.021583,0.024239,0.022085,0.017185,0.018592,0.021554,0.024272,0.022118,0.017273,0.018563,0.021503,0.024226,0.022134,0.017288,0.018547,0.021449,0.024277,0.022134,0.017194,0.018517,0.02147,0.024282,0.022116,0.017294,0.01851,0.021367,0.024213,0.02217,0.017311,0.01846,0.021336,0.024234,0.022243,0.017332,0.018479,0.021244,0.02422,0.022196,0.017344,0.018441,0.021245,0.024138,0.022171,0.017265,0.018379,0.021165,0.024282,0.022279,0.017328,0.018308,0.021086,0.024085,0.022216,0.017352,0.018272,0.021121,0.024093,0.022189,0.017308,0.018205,0.020986,0.024017,0.022202,0.017248,0.018183,0.020895,0.023968,0.022309,0.017286,0.018135,0.020807,0.024003,0.022284,0.017259,0.018155,0.020802,0.02398,0.022305,0.017293,0.018064,0.020759,0.023985,0.022367,0.017318,0.018046,0.020694,0.023899,0.02237,0.017384,0.01805,0.020677,0.023955,0.022382,0.017347,0.01801,0.020533,0.023919,0.022483,0.01735,0.01795,0.020583,0.023898,0.022411,0.017444,0.017954,0.020463,0.0239,0.022422,0.017381,0.017896,0.020504,0.023753,0.022471,0.017384,0.01794,0.020431,0.023821,0.022508,0.017406,0.017835,0.020363,0.0237,0.022521,0.017451,0.017885,0.020383,0.023764,0.02255,0.017518,0.017868,0.020275,0.023754,0.022563,0.017465,0.017867,0.020221,0.023679,0.022528,0.017531,0.017824,0.020209,0.023681,0.022554,0.01752,0.017819,0.020214,0.023661,0.022692,0.017569,0.017776,0.020087,0.023664,0.022669,0.0176,0.017746,0.020104,0.023722,0.022744,0.017545,0.017718,0.019972,0.02359,0.022565,0.017569,0.017706,0.019935,0.023591,0.022724,0.01761,0.017715,0.020002,0.023518,0.022754,0.017626,0.017628,0.01991,0.023538,0.02271,0.017711,0.01763,0.019905,0.023537,0.022709,0.017687,0.017614,0.019786,0.023419,0.022698,0.017713,0.017594,0.019726,0.023412,0.022704,0.017733,0.017551,0.01977,0.023439,0.022781,0.017756,0.017552,0.019662,0.023336,0.022807:3
0.011592,0.002927,-0.0034062,0.010272,-0.0025368,0.0038726,0.0062519,-8.1865E-4,0.014609,-0.0044447,0.010304,0.0072543,-0.0067047,0.012651,-0.0062649,0.010704,0.0064394,-0.0072925,0.01452,-0.004488,0.010866,0.0044765,-0.0050875,0.011866,-0.0030438,0.005783,0.0063855,-0.0086378,0.005907,-0.007135,0.0068709,0.0046941,-0.0093524,0.0095347,-0.013042,0.0075946,0.0049735,-0.0068283,0.012758,-0.0035162,0.0058833,0.0025478,-0.0025134,0.012921,-0.0057156,0.012204,0.0045062,-0.002413,0.0071356,-0.0070011,0.007702,0.0043941,-0.0050682,0.0088556,-0.0088239,0.0023965,0.0013155,-0.0013339,0.0090773,-0.0087816,0.005825,0.004073,-0.0026395,0.0095866,-0.011731,0.0061727,0.0036876,-0.0046551,0.0082847,-0.0051196,0.0020677,0.0098908,-0.0051034,0.011054,-0.0023065,0.0082417,0.0068777,-0.0096505,0.007583,-0.0065798,0.010964,0.0053274,-0.0084894,0.0091633,-0.0095816,0.0078839,-0.0010456,-0.0084613,0.0071845,-0.0086569,0.0050582,0.0070183,-0.0088069,0.010798,-0.0062113,0.0088025,0.00887,4.1575E-4,0.0081827,-0.0068035,0.010398,0.008118,-0.0013966,0.011275,-0.0031222,0.0053925,0.0044061,-0.0097608,0.0096877,-0.0014756,8.3307E-4,0.0058605,-0.0063459,0.010778,-0.0017448,0.0082137,0.0093246,-0.0030794,0.011502,-1.7292E-4,0.0083472,0.0081622,-0.0032968,0.012522,-0.0066033,0.0018738,-0.0018352,-0.011172,0.0072135,-0.01492,0.0074368,0.0077857,-0.0072015,0.015949,-0.0062116,0.0053435,8.9626,8.0211,3.3717,5.0509,4.3389,4.24,3.6004,2.8765,3.4138,3.8918,3.8946,3.2935,2.8982,3.2884,3.8586,3.884,3.2693,2.9009,3.2893,3.8749,3.8877,3.2631,2.903,3.2914,3.8828,3.8815,3.2592,2.9126,3.3099,3.8845,3.8786,3.2531,2.9085,3.305,3.8891,3.8734,3.2492,2.91,3.304,3.8933,3.8743,3.2508,2.9127,3.3171,3.8922,3.872,3.2491,2.9165,3.3238,3.8973,3.8763,3.2438,2.9121,3.3227,3.8968,3.866,3.2303,2.9173,3.3341,3.9127,3.8642,3.2303,2.9222,3.3395,3.9095,3.8641,3.2303,2.9195,3.352,3.9171,3.8619,3.2227,2.9248,3.3503,3.9197,3.8599,3.2147,2.918,3.3581,3.9248,3.8546,3.215,2.9227,3.3669,3.9312,3.8548,3.2085,2.9196,3.375,3.9282,3.8508,3.2022,2.9189,3.3765,3.9314,3.8485,3.1978,2.9268,3.3792,3.9362,3.8453,3.1921,2.9254,3.3881,3.9377,3.8443,3.1833,2.9273,3.3934,3.9447,3.8381,3.1818,2.9323,3.403,3.95,3.832,3.1762,2.9317,3.4009,3.9507,3.8261,3.1728,2.936,3.4137,3.9493,3.8289,3.1705,2.9375,3.4175,3.9491,3.8267,3.1636,2.939,3.4235,3.9617,3.8175,3.1627,2.9388,3.4404,3.9621,3.8144,3.1518,2.9434,3.4309,3.9617,3.8027,3.1466,2.9476,3.441,3.9718,3.8048,3.1435,2.9457,3.451,3.9729,3.8072,3.1436,2.9508,3.4557,3.9751,3.8008,3.1386,2.9538,3.4558:3
15.611,13.839,15.732,20.201,19.808,15.662,13.861,15.779,20.332,19.669,15.691,13.72,15.752,20.481,19.608,15.795,13.613,15.86,20.405,19.469,15.843,13.515,16.056,20.23,19.473,15.773,13.514,16.196,20.111,19.601,15.719,13.572,16.13,20.067,19.776,15.638,13.663,16.078,19.981,19.813,15.452,13.781,16.061,20.198,19.845,15.4,13.829,15.983,20.398,19.681,15.524,13.899,16.005,20.532,19.571,15.595,13.815,16.048,20.699,19.483,15.679,13.677,16.142,20.65,19.391,15.738,13.584,16.339,20.515,19.505,15.724,13.644,16.491,20.4,19.561,15.644,13.668,16.459,20.302,19.682,15.525,13.739,16.354,20.211,19.795,15.406,13.884,16.276,20.203,19.553,15.327,13.888,16.147,20.522,19.538,15.357,13.844,16.181,20.67,19.37,15.376,13.743,16.221,20.723,19.164,15.493,13.792,16.37,20.634,19.114,15.559,13.573,16.547,20.506,19.21,15.534,13.587,16.611,20.372,19.226,15.422,13.598,16.58,20.345,19.407,15.226,13.673,16.512,20.258,19.533,15.133,13.837,16.424,20.372,19.436,15.088,13.884,16.325,20.577,19.301,15.184,13.858,16.307,20.758,19.273,15.269,13.76,16.396,20.866,19.053,15.333,13.666,16.543,20.791,18.992,15.425,13.636,16.776,20.646,19.308,15.498,13.617,16.866,20.571,19.25,15.385,13.782,16.892,20.519,19.415,15.224,13.879,16.86,20.52,19.488,15.085,13.985,16.738,20.638,19.416,15.09,14.087,16.765,20.889,19.241,15.158,14.013,16.675,21.022,19.195,15.27,13.909,16.712,21.095,19.007,15.332,13.796,17.006,20.958,18.9,15.396,13.769,17.166,20.875,19.062,15.297,13.792,17.245,20.747,19.169,15.25,13.877,17.189,20.633,19.274,15.139,14.052,17.012,20.603,19.406,14.997,14.08,16.993,20.885,19.293,15.006,14.121,16.995,21.069,19.099,15.027,14.061,17.038,21.247,18.97,15.11,13.93,16.987,21.224,18.858,15.234,13.807,17.154,21.017,18.827,15.27,13.837,17.369,20.9,18.947,15.143,13.823,17.455,20.85,19.044,15.098,13.955,17.431,20.693,19.125,14.908,14.062,17.319,20.742,19.203,14.842,14.16,17.135,20.981,19.174,14.951,14.23,17.031,21.17,19.059,15.03,14.115,17.127,21.297,18.833,15.031,13.953,17.28,21.299,18.659,15.102,13.875,17.46,20.915,18.519,15.155,13.887,17.599,20.891,18.708,14.986,13.899,17.646,20.834,18.848:3
-0.010511,0.0095914,-0.01129,0.0063312,5.5672E-4,-0.004115,0.014346,-0.014776,0.0068948,0.0029707,-0.011287,0.011873,-0.011714,0.0084289,0.0012475,-0.010567,0.015073,-0.012534,0.0072238,0.0027969,-0.00443,0.0085819,-0.0099453,0.007935,0.0055279,-0.010648,0.01336,-0.0096398,0.0085984,0.0083158,-0.0085321,0.013526,-0.0093396,0.0086163,0.0057774,-0.0088022,0.011085,-0.010372,0.0079597,-0.0021916,-0.012952,0.011788,-0.016381,0.0071027,-0.0024251,-0.010233,0.0072579,-0.0071767,0.0077712,0.0028247,-0.010655,0.017646,-0.012703,0.0049115,-0.0041053,-0.0045883,0.012199,-0.010292,0.0058379,0.0037783,-0.010549,0.014888,-0.0082624,0.010539,0.0010607,-0.0064559,0.010499,-0.0075234,0.0032522,6.6643E-4,-0.0078743,0.010468,-0.0098567,0.0092011,1.9714E-4,-0.011852,0.019204,-0.011908,0.0090203,0.0046079,-0.010467,0.011455,-0.015707,0.0043272,0.0024267,-0.010355,0.010939,-0.0098596,0.0079835,-0.0039943,-0.0099461,0.01102,-0.011305,0.0039646,0.00745,-0.010071,0.010473,-0.014346,0.0057844,94.159,120.05,96.39,95.955,114.32,132.19,119.02,96.827,94.649,113.26,129.28,117.2,94.503,92.999,111.08,125.65,112.03,89.256,86.583,102.59,114.36,99.927,79.478,76.705,90.198,102.03,90.414,72.988,71.732,85.743,98.42,88.365,72.271,71.556,86.092,98.52,88.513,72.117,71.733,86.207,98.621,88.661,72.415,72.021,86.306,98.884,88.397,72.204,71.842,86.571,98.861,88.424,72.322,72.079,86.749,98.411,88.103,71.875,72.032,86.476,98.38,87.719,71.643,71.738,85.708,97.399,86.508,70.847,70.789,84.938,96.013,85.188,69.473,69.408,82.938,92.945,82.276,66.741,66.846,79.368,88.1,76.536,61.497,61.21,70.979,75.722,62.01,46.638,43.106,43.559,39.228,28.977,21.366,21.049,22.183,22.257,18.251,14.956,15.789,17.477,18.638,15.664,12.939,13.537,15.409,16.433,14.19,11.826,12.753,14.674,15.69,13.439,11.094,12.025,13.735,14.915,12.908,10.827,11.97,13.56,14.776,12.433,10.449,11.44,12.985,14.479,12.117,10.439,11.422,13.014,14.444,11.806,10.183,11.032,12.76,14.323,11.72,10.313,11.126,12.808,14.04,11.373,10.103,10.846,12.776,14.021,11.514,10.253,10.85,12.816,13.711,11.335,10.02,10.776,12.89,13.793,11.549,9.9914,10.738,12.667,13.534,11.368,9.8564,10.934,12.823,13.524,11.468,9.8508,10.89,12.593,13.458,11.378,9.7519,10.868,12.522,13.619,11.281,9.7243,10.87,12.362,13.508,11.136,9.8718,10.845,12.495,13.724,11.015,9.7362,10.602,12.348,13.618,10.964,9.8629,10.664,12.5,13.619,10.894,9.8523,10.524,12.52,13.46:3
2.5784,2.8939,3.4444,3.1692,2.5197,2.5776,2.8952,3.4461,3.1843,2.5387,2.5662,2.8722,3.4575,3.1985,2.5463,2.5649,2.8886,3.4487,3.1912,2.5641,2.5547,2.8682,3.4435,3.1979,2.5685,2.5456,2.8829,3.4376,3.2089,2.5798,2.5238,2.8591,3.4176,3.2057,2.5895,2.5188,2.8686,3.4136,3.2162,2.6072,2.5132,2.8724,3.3994,3.2351,2.6259,2.5063,2.8739,3.3803,3.2408,2.6211,2.4928,2.8525,3.3553,3.2509,2.6342,2.4979,2.8498,3.3448,3.2805,2.638,2.5002,2.8437,3.3307,3.3038,2.6373,2.5029,2.8366,3.324,3.3251,2.6426,2.5032,2.8253,3.3256,3.3486,2.6428,2.5055,2.8129,3.2966,3.3562,2.6416,2.5039,2.7955,3.287,3.3789,2.6294,2.5126,2.7858,3.2798,3.3797,2.6408,2.5177,2.752,3.2857,3.3949,2.636,2.524,2.7511,3.2909,3.3962,2.6508,2.5155,2.7399,3.3066,3.3955,2.6722,2.5183,2.7294,3.2899,3.3874,2.6797,2.5011,2.7151,3.2917,3.3831,2.6832,2.4979,2.7247,3.2967,3.3947,2.7208,2.4908,2.7165,3.2903,3.3918,2.7226,2.4858,2.7264,3.2753,3.3946,2.7461,2.4783,2.714,3.2573,3.3917,2.748,2.4646,2.7196,3.2329,3.3981,2.7737,2.455,2.7029,3.2215,3.4074,2.778,2.4515,2.7219,3.1958,3.4285,2.7957,2.4544,2.7137,3.1872,3.4483,2.8029,2.4624,2.7076,3.177,3.4616,2.8045,2.4706,2.6938,3.1697,3.473,2.7922,2.4714,2.6936,3.1587,3.4737,2.8054,2.475,2.6831,3.1561,3.4869,2.8001,2.4783,2.6638,3.1389,3.4946,2.8076,2.4812,2.644,3.1395,3.5051,2.8099,2.4955,2.6391,3.1434,3.5057,2.8256,2.501,2.6204,3.1498,3.4961,2.8191,2.5003,2.6052,3.1423,3.482,2.8454,2.5061,2.5946,3.143,3.4794,2.8484,2.4936,2.5869,3.1373,3.4896,2.8819,2.4912,2.5982,3.1441,3.4654,2.8949,2.497,2.6006,3.1156,3.4514,2.9115,2.4903,2.5886,3.1165,3.4538,2.9244,2.4869,2.5938,3.1001,3.4453,2.9543,2.4825,2.5875,3.0783,3.4323,2.9604,2.4795,2.6019,3.0788,3.4353,2.9976,2.4808,2.6025,3.0531,3.4502,3.0015,2.4815,2.6006,3.0341,3.4548,3.0121,2.482,2.5915,3.0046,3.4711,3.0097,2.4888,2.5931,3.0089,3.473,3.0285,2.5014,2.571,3.0176,3.4879,3.0282,2.5091,2.5741,3.0063,3.479,3.0371,2.5204,2.5502,3.0011,3.4809,3.0366,2.5248,2.543,2.9796,3.4694,3.041,2.5359,2.5315,2.9834,3.4586,3.0389,2.5434,2.5125,2.984,3.4494,3.0555,2.5575,2.5017,2.9896,3.4351,3.0636,2.5636,2.5027,2.9962,3.4205,3.0955:3
0.057677,0.10551,0.10487,0.025165,0.092252,0.045436,0.10365,0.1111,0.016585,0.093293,0.045086,0.096895,0.10798,0.023561,0.10036,0.052428,0.10276,0.1148,0.01761,0.097288,0.049619,0.10048,0.1046,0.026229,0.090237,0.048049,0.10635,0.11479,0.018687,0.095739,0.052675,0.097864,0.108,0.019483,0.09208,0.05476,0.092426,0.10926,0.022268,0.091198,0.052069,0.09995,0.11121,0.021096,0.092561,0.051536,0.099891,0.1077,0.022359,0.091113,0.056211,0.094966,0.11001,0.014895,0.096674,0.055546,0.096898,0.1092,0.015186,0.089936,0.052069,0.095488,0.11233,0.016639,0.097649,0.055089,0.10073,0.10765,0.020539,0.090527,0.048204,0.090493,77.071,134.8,101.34,112.07,130.87,146.95,130.45,104.53,108.01,131.68,146.0,131.13,100.77,111.37,128.04,145.62,126.58,104.57,109.69,130.34,145.44,125.82,102.9,105.98,126.91,140.45,120.59,96.44,100.6,119.63,128.31,109.81,88.972,91.27,106.57,115.12,99.441,80.64,84.992,101.68,110.87,96.528,78.438,83.328,99.248,109.34,95.41,77.911,83.445,99.551,108.79,93.441,76.408,80.961,96.003,103.93,88.665,72.425,77.119,90.67,94.369,78.492,62.096,63.393,66.729,61.27,45.163,33.308,34.067,35.296,36.026,28.866,23.765,25.782,28.547,30.706,25.353,21.712,23.857,26.949,28.95,23.53,20.118,22.0,25.521,27.522,22.816,19.918,22.016,25.915,27.188,22.598,19.543,21.661,25.401,26.585,22.415,19.358,21.77,25.267,26.373,22.121,18.811,21.329,24.498,26.135,21.802,18.991,21.697,24.877,26.731,21.725,19.094,21.379,24.296,26.271,21.114,18.849,21.038,24.467,26.288,21.069,18.849,20.928,24.597,25.722,21.028,18.833,21.288,25.185,26.033,21.323,18.627,20.966,24.147,25.067,20.738,18.239,21.189,24.41,25.749,20.923,18.602,21.28,24.196,25.832,20.575,18.711,21.206,24.308,25.94,20.402,18.534,20.654,24.107,25.318,20.21,18.545,20.84,24.852,25.436,20.683,18.687,21.124,24.656,24.985,20.429,18.185,20.944,24.248,24.956,20.409,18.112,21.184,23.961,25.165,20.125,18.371,21.341,24.264,25.616,20.12,18.464,21.027,23.879,25.102,19.604,18.289,20.685,24.25,24.94,19.852,18.488,21.034,24.698,24.798,20.016,18.329,21.059,24.472,24.65,19.98,17.965,20.874,23.869,24.271,19.635,17.851,21.109,23.912,24.841,19.703,18.292,21.181,23.947,24.807,19.428,18.165,20.792,23.79,24.637,19.218,18.16,20.608,24.119,24.364,19.363,18.256:3
-3.9478E-4,3.7157E-4,-7.1256E-4,1.1743E-4,-2.0757E-4,-3.8856E-4,3.4928E-4,-7.1446E-4,1.2026E-4,-3.7317E-5,-5.1925E-4,2.5668E-4,-6.3979E-4,1.7936E-4,-1.4877E-4,-3.3866E-4,4.7174E-4,-6.0405E-4,-8.338E-5,-2.3502E-4,0.43762,0.55713,0.50493,0.64522,0.68519,0.62024,0.51093,0.51731,0.61187,0.6715,0.61171,0.49077,0.509,0.59301,0.65832,0.6005,0.47815,0.49829,0.57843,0.64539,0.58963,0.46928,0.4882,0.56568,0.63335,0.58039,0.46052,0.47867,0.55545,0.62379,0.57294,0.45471,0.47121,0.54685,0.61708,0.56782,0.44981,0.46572,0.54018,0.61084,0.56363,0.44619,0.4605,0.53514,0.60596,0.56053,0.44392,0.4572,0.53079,0.60186,0.55828,0.44095,0.45353,0.52635,0.59952,0.55644,0.43969,0.4507,0.5225,0.59617,0.55543,0.43779,0.4487,0.51993,0.59325,0.55351,0.43703,0.446,0.51668,0.59145,0.55375,0.43633,0.44406,0.51339,0.58928,0.55275,0.43546,0.44165,0.51055,0.5881,0.55243,0.43478,0.44115,0.51012,0.58749,0.55284,0.43532,0.44008,0.50923,0.58588,0.55379,0.43756,0.43958,0.508,0.58536,0.55482,0.43684,0.4389,0.50619,0.58509,0.55495,0.43681,0.43745,0.50446,0.58423,0.55525,0.43759,0.43728,0.50385,0.5838,0.55663,0.43815,0.43642,0.5019,0.58244,0.55696,0.4386,0.43594,0.50088,0.58302,0.558,0.43876,0.43574,0.49985,0.58172,0.55861,0.43967,0.4355,0.49821,0.58214,0.55952,0.44081,0.43504,0.49809,0.58146,0.5605,0.44152,0.43415,0.49728,0.58151,0.56089,0.44232,0.43471,0.49632,0.5814,0.56179,0.44347,0.43413,0.496,0.57974,0.56265,0.4437,0.43401,0.49446,0.57989,0.56308,0.44491,0.4335,0.49332,0.57917,0.56471,0.4452,0.43344,0.49183,0.57952,0.56424,0.44602,0.43287,0.49118,0.57803,0.56586,0.44587,0.43299,0.49003,0.57821,0.56681,0.44692,0.43319,0.48901,0.57789:4
-0.0041689,0.001893,-4.143E-4,-0.0036433,0.0050624,-0.0041926,0.0033298,-7.1617E-4,-0.0021215,0.0037017,-0.0044196,0.0029937,-3.5146E-4,-0.0027451,0.0034375,-0.0056998,0.0024177,-1.5644E-4,-0.0026077,0.0033836,-0.003561,0.002363,5.7846E-4,-0.0034483,0.0039119,-0.0033468,0.002576,-3.7935E-4,-0.0026302,0.0040633,-0.0035926,0.0021084,7.7966E-4,-0.0027406,0.0036243,-0.0030685,0.002613,1.3355E-4,1.0132,2.8193,2.9472,3.4152,3.7316,3.3418,2.7101,2.8328,3.3246,3.6339,3.2393,2.6396,2.7652,3.2588,3.5611,3.1619,2.5829,2.7108,3.2026,3.4929,3.0956,2.5311,2.6758,3.1648,3.4454,3.0436,2.4968,2.653,3.1426,3.4194,3.0101,2.4768,2.639,3.1285,3.3937,3.0699,2.5364,2.738,3.2256,3.5577,3.0794,2.5442,2.7364,3.2344,3.5102,3.0501,2.5168,2.719,3.2199,3.4761,3.0344,2.5096,2.7265,3.2177,3.4688,2.9977,2.4521,2.6781,3.1526,3.4274,2.9479,2.442,2.6901,3.1468,3.4181,2.9238,2.4322,2.6862,3.1448,3.4217,2.9157,2.443,2.6982,3.1501,3.419,2.9062,2.4346,2.6828,3.1336,3.3962,2.8567,2.3639,2.52,2.9645,3.1442,2.6594,2.2523,2.4865,2.9431,3.1194,2.6387,2.2396,2.4738,2.9416,3.0965,2.6314,2.234,2.4807,2.9461,3.0792,2.6156,2.2197,2.4797,2.941,3.0676,2.612,2.2192,2.4857,2.9414,3.0583,2.593,2.2081,2.4868,2.93,3.0564,2.5869,2.2052,2.4926,2.9316,3.0491,2.5696,2.2042,2.5007,2.9291,3.0542,2.5644,2.2001,2.4989,2.928,3.0377,2.542,2.1968,2.5032,2.9325,3.0395,2.5343,2.1956,2.5009,2.9358,3.0289,2.5228,2.1973,2.5106,2.9476,3.0254,2.5144,2.1924,2.5072,2.9465,3.0116,2.5054,2.1945,2.5162,2.9522,3.0058,2.4979,2.1885,2.515,2.9542,2.9972,2.4929,2.1909:4
-0.0032377,0.0032614,-0.0017562,3.9274E-4,0.0017847,-0.0030225,0.0033265,-0.00225,-3.7816E-4,0.001481,-0.0032355,0.0033119,-0.0028428,-7.4799E-4,0.0014959,-0.003147,1.688,2.7518,2.971,2.7357,2.2711,2.1619,2.6173,2.8796,2.6503,2.1808,2.0989,2.5372,2.7971,2.5781,2.1297,2.0628,2.495,2.7525,2.518,2.0784,2.0231,2.4515,2.7087,2.4735,2.0464,1.999,2.4234,2.6697,2.4282,2.0117,1.9748,2.3991,2.6453,2.4026,1.9942,1.9605,2.3841,2.6216,2.3668,1.9697,1.9473,2.3757,2.6124,2.3527,1.9584,1.9376,2.3673,2.5929,2.3266,1.9443,1.9314,2.3665,2.59,2.3222,1.9396,1.9325,2.3638,2.5771,2.3003,1.9246,1.9301,2.3658,2.5794,2.2965,1.921,1.9312,2.3572,2.5654,2.282,1.9135,1.9351,2.3642,2.5652,2.2705,1.9012,1.9306,2.3541,2.5622,2.2582,1.8997,1.9382,2.3602,2.5625,2.2413,1.8893,1.9288,2.3523,2.5567,2.2301,1.8874,1.9331,2.3555,2.5524,2.2142,1.8813,1.9333,2.3633,2.5576,2.21,1.8815,1.9343,2.3629,2.547,2.2025,1.8822,1.9437,2.3785,2.5523,2.1916,1.871,1.9363,2.3695,2.5433,2.192,1.8809,1.96,2.3934,2.5517,2.176,1.8625,1.9446,2.3765,2.5411,2.1753,1.8724,1.9645,2.3921,2.543,2.1554,1.8563,1.9541,2.3778,2.5393,2.1565,1.8735,1.9879,2.4145,2.5612,2.1551,1.8684,1.9832,2.4111,2.563,2.1546,1.8726,1.9919,2.4149,2.5554,2.1364,1.8658,1.9925,2.4181,2.5594,2.1378,1.8717,1.9968,2.4156,2.5456,2.1188,1.8606,1.9945,2.4204,2.5469,2.1161,1.8609,1.9959,2.4188,2.534,2.1029,1.8584,2.0061,2.4313,2.5396,2.0997,1.855,2.0022,2.4214,2.5245,2.0902,1.852,2.0094,2.4271,2.5183,2.0755:4
-9.9597E-5,2.4785E-4,-4.5733E-4,3.1002E-4,-3.1515E-4,-8.9887E-5,3.8365E-4,-4.2091E-4,4.0305E-4,-1.0237E-5,-2.6723E-4,4.4877E-4,-4.549E-4,2.9713E-4,-2.5524E-4,-9.838E-5,2.6652E-4,-3.3784E-4,1.239E-4,-2.0726E-4,-2.6313E-5,5.1192E-4,-4.9731E-4,3.2374E-4,-2.3169E-4,-7.6247E-5,3.5762E-4,-6.1277E-4,3.6162E-4,2.7177E-5,-1.6925E-4,2.6611E-4,-5.7726E-4,2.5496E-4,-5.7627E-5,-1.4238E-4,2.7847,3.4611,3.4382,4.2816,4.253,3.3673,3.2597,3.4704,4.1986,4.188,3.3713,3.1812,3.4573,4.1422,4.1479,3.3488,3.1434,3.4315,4.1116,4.1243,3.336,3.1325,3.4197,4.0943,4.1071,3.3311,3.1173,3.4072,4.0839,4.1039,3.3152,3.1119,3.4023,4.0722,4.0929,3.3179,3.1058,3.3915,4.064,4.0936,3.3187,3.1014,3.3906,4.0582,4.0794,3.3136,3.0981,3.3769,4.0441,4.0859,3.3103,3.0946,3.3767,4.0498,4.077,3.3104,3.0945,3.3698,4.0375,4.0837,3.3173,3.0948,3.361,4.0413,4.0766,3.315,3.0872,3.3624,4.0407,4.0773,3.3172,3.0887,3.3594,4.0362,4.0772,3.319,3.0898,3.3577,4.0374,4.0818,3.3206,3.0863,3.3541,4.0291,4.077,3.3225,3.089,3.3492,4.0256,4.0828,3.3184,3.0781,3.3436,4.0223,4.0752,3.3284,3.0793,3.3387,4.0222,4.0819,3.327,3.0792,3.3383,4.0182,4.0766,3.3233,3.0762,3.334,4.0219,4.0806,3.3284,3.0798,3.3303,4.0084,4.0777,3.3277,3.0783,3.3252,4.0124,4.0769,3.3267,3.074,3.3264,4.0009,4.0765,3.328,3.0755,3.3164,4.0037,4.0757,3.3297,3.0712,3.316,3.9941,4.0726,3.3316,3.0753,3.3101,3.9955,4.073,3.332,3.0689,3.3144,3.9965,4.0771,3.3312,3.073,3.3063,3.987,4.0727,3.3319,3.0692,3.2964,3.9866,4.0685,3.3377,3.066,3.2908,3.9833,4.0711,3.3297,3.0658,3.293,3.9818:4
1.7927E-4,6.2553E-5,-5.1435E-4,5.0258E-4,-4.6091E-4,4.1813E-4,1.1436E-4,-2.4362E-4,2.2808E-4,-5.91E-4,1.7118E-4,1.1317E-4,-2.8183E-4,5.4846E-4,-3.074E-4,2.1984E-4,9.0913E-5,-3.4305E-4,5.4899E-4,-3.8517E-4,9.6503E-5,2.1696E-4,-3.7627E-4,4.3846E-4,-5.486E-4,2.8074E-4,2.5613E-5,-2.4351E-4,0.0039043,3.1934,4.1105,4.2779,3.7092,3.1506,3.3396,3.977,4.229,3.7072,3.0558,3.3419,3.9136,4.1854,3.687,3.0184,3.3259,3.871,4.1583,3.6726,2.9985,3.3145,3.852,4.1447,3.6626,2.9842,3.2993,3.8392,4.1263,3.6547,2.9778,3.2894,3.8245,4.1238,3.6492,2.9697,3.2841,3.8224,4.1123,3.647,2.9633,3.2788,3.8072,4.1152,3.643,2.9664,3.2723,3.8003,4.1049,3.6458,2.9685,3.2705,3.8006,4.113,3.6446,2.9694,3.2622,3.7986,4.11,3.6427,2.9628,3.2611,3.7918,4.1064,3.6485,2.9639,3.259,3.7859,4.1014,3.6478,2.96,3.2572,3.7911,4.1047,3.6531,2.9645,3.2532,3.7811,4.1018,3.6509,2.9609,3.2512,3.7788,4.1038,3.65,2.9626,3.2473,3.7716,4.0994,3.6505,2.9616,3.2459,3.7688,4.0992,3.6547,2.9608,3.2405,3.7655,4.102,3.6539,2.9596,3.2427,3.7597,4.0992,3.6615,2.9621,3.2358,3.757,4.0946,3.6539,2.9585,3.2321,3.7574,4.0988,3.6637,2.9635,3.226,3.7518,4.0956,3.6594,2.9653,3.2267,3.752,4.0936,3.6648,2.9621,3.2256,3.7441,4.0902,3.6636,2.9609,3.2215,3.7406,4.09,3.6666,2.9637,3.2172,3.7349,4.0868,3.6632,2.9607,3.2145,3.7291,4.0882,3.6699,2.9602,3.2131,3.7302,4.0911,3.6706,2.9671,3.2132,3.7289,4.0945,3.6706,2.9654,3.2074,3.7274,4.0878,3.6725,2.9679,3.2042,3.7235,4.0826,3.674,2.9635,3.2103,3.7243,4.0886,3.6775,2.9627,3.2033:4
1.7962E-4,-2.7798E-4,4.2261E-4,-4.0291E-4,2.426E-4,-2.3127E-5,-2.8688E-4,5.6028E-4,-4.4178E-4,2.3525E-4,-1.6788E-4,-4.6203E-4,6.5644E-4,-3.2813E-4,3.1264,4.3212,3.852,3.0976,3.3831,3.9117,4.2511,3.7954,3.059,3.338,3.8694,4.2128,3.7484,3.0351,3.3093,3.8415,4.1807,3.7267,3.0183,3.2891,3.8226,4.1613,3.7067,3.0047,3.2787,3.8105,4.1482,3.7012,2.9982,3.2749,3.8068,4.1377,3.6886,2.991,3.2657,3.798,4.1321,3.6786,2.9847,3.2602,3.7918,4.1225,3.6723,2.9809,3.2615,3.7897,4.1168,3.6731,2.9822,3.2633,3.7886,4.1188,3.6664,2.9736,3.2587,3.7853,4.1173,3.6633,2.9701,3.2575,3.7874,4.1194,3.6645,2.9695,3.2584,3.786,4.1126,3.6614,2.975,3.2559,3.7848,4.108,3.6563,2.9671,3.2549,3.7791,4.103,3.6527,2.9621,3.2507,3.7769,4.0989,3.6511,2.9604,3.2508,3.779,4.1056,3.6447,2.9593,3.2579,3.7796,4.1024,3.6443,2.9608,3.2543,3.7811,4.0999,3.6492,2.9598,3.2563,3.786,4.1042,3.6391,2.9487,3.2529,3.7839,4.1009,3.6393,2.9582,3.2557,3.7868,4.0954,3.6376,2.954,3.2529,3.7851,4.0957,3.6417,2.9512,3.2554,3.7815,4.0956,3.64,2.9551,3.2555,3.7809,4.0952,3.6369,2.9475,3.2543,3.7778,4.0918,3.6323,2.95,3.2581,3.7818,4.0936,3.6331,2.9506,3.2536,3.7787,4.0892,3.6221,2.9457,3.2542,3.7805,4.0906,3.623,2.945,3.2569,3.7728,4.0818,3.6208,2.9449,3.2509,3.7794,4.0818,3.6208,2.9458,3.2531,3.7798,4.0812,3.6173,2.9449,3.2515,3.7819,4.0819,3.6196,2.9393,3.2515,3.7761,4.0821,3.6188,2.945,3.2575,3.7851,4.0876,3.6104,2.9455,3.2581,3.7848,4.0857,3.611,2.9397,3.2513,3.7795:4
2.3867E-6,8.1233E-6,2.7767E-6,-3.2033E-6,7.4767E-6,6.8667E-7,3.0367E-6,2.28E-6,-4.4233E-6,7.4033E-6,-1.1233E-6,-1.6167E-6,8.62E-6,-4.7933E-6,9.4E-6,-2.6167E-6,3.6467E-6,7.4367E-6,-2.68E-6,6.9767E-6,2.8067E-6,2.5133E-6,6.18E-6,-5.4933E-6,7.7367E-6,-3.3334E-9,-7.6667E-8,6.4633E-6,-7.03E-6,7.13E-6,-2.7233E-6,1.5533E-6,9.5733E-6,0.016937,0.053134,0.050435,0.06681,0.063714,0.052442,0.048744,0.051647,0.064617,0.062795,0.052287,0.047407,0.051258,0.063429,0.062037,0.051886,0.046708,0.050702,0.062587,0.06144,0.051475,0.046247,0.050169,0.061821,0.061,0.051197,0.04585,0.049709,0.061234,0.060648,0.051002,0.04557,0.049363,0.060731,0.060354,0.050802,0.045295,0.04899,0.060241,0.060108,0.050747,0.045098,0.048678,0.059898,0.059946,0.050709,0.044896,0.048431,0.059488,0.059822,0.050654,0.044693,0.048159,0.059274,0.059675,0.050683,0.044667,0.047971,0.058987,0.059606,0.050737,0.044551,0.04779,0.05875,0.059474,0.050802,0.04451,0.047571,0.058537,0.059466,0.050873,0.044417,0.047393,0.058349,0.059378,0.050951,0.0444,0.047214,0.058172,0.059335,0.050986,0.044331,0.047031,0.057935,0.0592,0.051122,0.044322,0.046879,0.057766,0.059224,0.051264,0.044254,0.046684,0.057589,0.059175,0.051336,0.04425,0.046584,0.057439,0.059101,0.051477,0.044243,0.046492,0.057394,0.05916,0.051573,0.044271,0.046321,0.057114,0.059178,0.051787,0.044299,0.046202,0.057103,0.059065,0.051863,0.044302,0.046106,0.056926,0.05902,0.052061,0.044306,0.045946,0.056865,0.05902,0.052207,0.044371,0.045861,0.056679,0.058956,0.052356,0.044356,0.045714,0.056544,0.058873,0.052477,0.044384,0.04543,0.056099,0.058871,0.052725,0.044496,0.04548,0.056285,0.058864,0.052783,0.044504,0.045439,0.056158,0.058803,0.052884,0.044515,0.045283,0.055997,0.05877,0.053029,0.044609,0.045223,0.055961,0.05884,0.053257,0.044664,0.045103,0.05574,0.058636,0.053329,0.04469,0.045009,0.055601,0.058666,0.053473,0.044751,0.044889,0.055481,0.058591,0.053596,0.044835,0.044778,0.055288,0.058481,0.053787,0.044805,0.044619,0.05515,0.05844,0.053931,0.044884,0.044522,0.054977,0.058363,0.013375:4
7.7567E-6,8.3833E-6,-7.5967E-6,5.93E-6,-6.3667E-6,3.9533E-6,9.9733E-6,-1.5467E-6,5.8133E-6,-4.0667E-7,1.94E-6,8.2533E-6,-1.9667E-7,5.84E-6,-2.4967E-6,4.21E-6,3.4633E-6,-4.3467E-6,1.067E-5,-4.6233E-6,-1.4333E-7,7.8433E-6,-2.3333E-8,5.4833E-6,-6.9667E-6,9.53E-6,0.058643,0.04734,0.051792,0.055003,0.066433,0.060679,0.048425,0.049173,0.055052,0.065033,0.059727,0.048115,0.048096,0.054526,0.064059,0.059053,0.047669,0.047536,0.053967,0.063323,0.058546,0.047296,0.047025,0.053481,0.062756,0.05822,0.047,0.046602,0.053066,0.062279,0.057905,0.046787,0.046309,0.052725,0.061857,0.057664,0.046597,0.046031,0.052386,0.061485,0.057467,0.046485,0.045767,0.052137,0.061148,0.057375,0.04638,0.045536,0.051925,0.060952,0.057309,0.046328,0.045302,0.051686,0.060701,0.057144,0.046273,0.045058,0.051476,0.060475,0.057084,0.046239,0.044942,0.051319,0.060277,0.057102,0.04626,0.044849,0.051134,0.060187,0.057089,0.046247,0.044701,0.050918,0.059995,0.057063,0.046257,0.044691,0.050796,0.059869,0.057101,0.04631,0.044548,0.050646,0.059818,0.057082,0.046345,0.044469,0.050453,0.059739,0.05714,0.046421,0.04441,0.050356,0.059658,0.05714,0.046507,0.044331,0.050256,0.059587,0.057195,0.046548,0.044233,0.050087,0.059517,0.057225,0.046598,0.044149,0.049967,0.059391,0.057282,0.046676,0.044082,0.049872,0.059378,0.057233,0.046715,0.044031,0.049708,0.059247,0.057297,0.0468,0.044035,0.049559,0.059236,0.057324,0.046882,0.043955,0.049505,0.059172,0.057379,0.046924,0.043881,0.049376,0.059105,0.057411,0.047022,0.043877,0.049277,0.059069,0.026484:4
1.5233E-6,-3.83E-6,9.2433E-6,-5.6333E-7,-6.4067E-6,3.2E-6,-8.1E-7,7.9767E-6,2.08E-6,3.6867E-6,5.7267E-6,-4.1333E-6,5.27E-6,1.9967E-6,2.5267E-6,5.01E-6,-1.9167E-6,6.1767E-6,6.6E-7,-9.4667E-7,7.01E-6,-1.55E-6,3.2233E-6,5.6933E-6,1.1467E-6,3.5733E-6,-1.9833E-6,8.44E-6,-1.5167E-6,2.8033E-6,6.16E-6,2.3933E-6,5.3233E-6,6.9E-7,3.1E-6,1.5667E-6,0.032541,0.056941,0.054858,0.074283,0.065865,0.056341,0.053195,0.065414,0.071143,0.06412,0.053277,0.052285,0.063104,0.068983,0.06237,0.051661,0.051093,0.061584,0.067436,0.061089,0.050616,0.050094,0.060408,0.066203,0.060231,0.049908,0.049415,0.059602,0.065302,0.059593,0.04937,0.048816,0.058878,0.064674,0.059113,0.048903,0.048355,0.058346,0.064083,0.058743,0.048624,0.047972,0.057791,0.063701,0.058481,0.048454,0.047647,0.057533,0.063354,0.058365,0.048316,0.047444,0.057243,0.063179,0.058237,0.048278,0.047235,0.056992,0.063018,0.058291,0.048213,0.047084,0.056774,0.062832,0.058247,0.048177,0.046899,0.056573,0.06264,0.058237,0.048176,0.046769,0.056393,0.062581,0.058318,0.048188,0.046669,0.056283,0.062456,0.058398,0.04827,0.046537,0.056074,0.062384,0.058391,0.048241,0.046504,0.05599,0.062316,0.058506,0.048287,0.046389,0.055705,0.062257,0.058525,0.048337,0.046327,0.02752:4
1.63E-6,1.0467E-6,1.98E-6,2.1767E-6,-2.8333E-7,1.8933E-6,1.8633E-6,1.3233E-6,1.8433E-6,7.0E-7,1.1733E-6,9.0333E-7,2.9133E-6,1.7667E-6,1.0167E-6,2.41E-6,1.5767E-6,1.7633E-6,2.1467E-6,8.2E-7,2.0E-6,2.02E-6,2.17E-6,2.5967E-6,6.8667E-7,9.6E-7,7.8333E-7,0.0046219,0.0053058,0.0045532,0.0039208,0.0048546,0.0053829,0.0053061,0.0045163,0.0039306,0.0048175,0.0053833,0.0053084,0.0045111,0.0039278,0.0047903,0.0053671,0.0052937,0.0045076,0.0039128,0.0047718,0.0053442,0.0052869,0.0044945,0.0039118,0.004762,0.0053417,0.0052856,0.0044926,0.0038983,0.0047433,0.0053205,0.0052842,0.0044775,0.0038913,0.0047207,0.0053124,0.0052667,0.0044799,0.0038654,0.0047071,0.0052972,0.0052875,0.0044886,0.0038807,0.0047073,0.0052928,0.0052829,0.0044903,0.0038636,0.0046917,0.0052741,0.005284,0.004487,0.0038714,0.004697,0.0052673,0.0052972,0.004493,0.0038571,0.0046796,0.0052601,0.0052887,0.0044902,0.0038555,0.0046718,0.0052546,0.0052732,0.0044951,0.003846,0.0046456,0.0052437,0.0052872,0.0045082,0.0038421,0.0046613,0.0052273,0.0052952,0.0044806,0.0038429,0.0046238,0.0052443,0.0052888,0.0045039,0.0038485,0.0046397,0.0052257,0.0052926,0.0045292,0.0038443,0.0046313,0.0052201,0.0053041,0.0045209,0.0038392,0.0046263,0.005216,0.0053074,0.0045195,0.0038347,0.0046244,0.0052136,0.0053109,0.00452,0.0038403,0.0045997,0.0052169,0.0053119,0.0045363,0.0038355,0.0046045,0.0051926,0.0053079,0.0045453,0.0038526,0.0046005,0.0051889,0.005322,0.0045603,0.0038189,0.0045927,0.0051821,0.0053279,0.0045601,0.0038323,0.0045793,0.0051835,0.0053167,0.0045534,0.0038231,0.0045699,0.0051825,0.0053237,0.0045783,0.0038262,0.0045681,0.0051599,0.0053325,0.0045695,0.0038372,0.0045563,0.0051598,0.0053422,0.0045592,0.003824,0.0045623,0.0051521,0.0053319,0.00459,0.0038238,0.004553,0.0051396,0.0053212,0.004581,0.0038321,0.0045442,0.0051529,0.005333,0.0045941,0.0038219,0.0045461,0.0051326,0.0053307,0.0045876,0.003833,0.0045311,0.0051339,0.0053471,0.004627,0.0038153,0.004518,0.005127,0.0053389,0.0046175,0.0038231,0.0045062,0.0051219,0.0053497,0.004617,0.0038261,0.0045018,0.0051013,0.0053517,0.004618,0.0038336,0.0045079,0.0051111,0.0053653,0.004621,0.0038316,0.0044976,0.0051085,0.0053601,0.0046471,0.0038078,0.0045036,0.0050903,0.0053593,0.0046392,0.0038359,0.0044838,0.0050818,0.0053672,0.00465,0.0038242,0.004481,0.0050847,0.0053669,0.0046685,0.0038402,0.0044754,0.0050698,0.0053664,0.0046637,0.003817,0.0044801,0.0050764,0.0053692,0.0046774,0.0038273,0.0044628,0.0050724,0.0053668,0.004687,0.0038334,0.0044607,0.005062,0.0053759,0.0046965,0.0038313,0.0044591,0.0050668,0.0053656,0.0047177,0.0038342,0.0044502,0.005061,0.0053779,0.0047237,0.0038357,0.0044513,0.0050495,0.0053749,0.0047129,0.0038253,0.0044515,0.0050558,0.0053802,0.0047271,0.003846,0.0044258,0.0050375,0.005365,0.0047392:4
2.58E-6,1.6533E-6,1.8633E-6,-1.2E-7,2.5167E-6,2.0967E-6,1.23E-6,1.2767E-6,1.25E-6,1.9267E-6,2.0167E-6,1.4533E-6,1.4967E-6,1.6067E-6,2.2767E-6,2.2133E-6,1.18E-6,2.07E-6,1.5767E-6,1.7933E-6,1.8733E-6,7.5E-7,1.44E-6,-3.1667E-7,2.4267E-6,2.6067E-6,3.0667E-7,1.29E-6,5.5667E-7,1.97E-6,2.2733E-6,1.8567E-6,1.5933E-6,8.2E-7,1.93E-6,2.3533E-6,-1.9333E-7,1.66E-6,1.4467E-6,2.65E-6,1.64E-6,9.0333E-7,1.4367E-6,1.29E-6,1.2133E-6,2.85E-6,1.4267E-6,1.0767E-6,1.1867E-6,1.5433E-6,2.2E-6,1.4133E-6,8.8667E-7,3.3667E-7,2.1133E-6,2.67E-6,1.85E-6,1.5433E-6,9.2667E-7,2.4167E-6,2.6867E-6,4.4667E-7,1.2767E-6,1.9233E-6,2.2933E-6,2.4233E-6,1.6833E-6,0.003533,0.0044869,0.0045951,0.0055153,0.0053767,0.0041265,0.004266,0.0046775,0.0054613,0.0053338,0.0041506,0.0042248,0.0046789,0.0054547,0.0053243,0.0041614,0.004199,0.0046646,0.0054395,0.0053397,0.0041615,0.0041833,0.0046479,0.0054277,0.0053285,0.0041626,0.0041688,0.0046227,0.0053892,0.0053157,0.0041597,0.0041674,0.0046005,0.0053976,0.0053142,0.0041616,0.0041492,0.0045988,0.0053673,0.0053207,0.0041646,0.0041484,0.004581,0.0053751,0.0053303,0.0041764,0.0041419,0.0045622,0.0053684,0.0053231,0.0041692,0.0041274,0.0045553,0.0053683,0.0053361,0.0041695,0.0041197,0.0045378,0.0053446,0.0053222,0.0041853,0.0041204,0.0045259,0.0053539,0.0053279,0.0041753,0.0041205,0.0045058,0.0053391,0.0053485,0.0042014,0.0041091,0.0045141,0.0053396,0.0053369,0.0041925,0.0041071,0.0044841,0.0053374,0.0053513,0.0042013,0.0041143,0.0044742,0.005308,0.0053568,0.0042168,0.0041077,0.0044536,0.0052917,0.005354,0.0042252,0.0040865,0.0044503,0.0053006,0.0053656,0.0042472,0.0040978,0.0044271,0.0053005,0.0053623,0.0042491,0.0040964,0.004429,0.0053104,0.0053683,0.0042519,0.0041017,0.0043996,0.0052843,0.0053877,0.0042726,0.0040818,0.0044,0.0052897,0.0053843,0.004264,0.0040834,0.0043867,0.0052786,0.0053923,0.0042752,0.0040973,0.0043782,0.0052645,0.0053869,0.0042853,0.0040761,0.0043738,0.0052497,0.0053945,0.0043027,0.0040831,0.0043702,0.0052373,0.0053877,0.0043013,0.0040877,0.0043581,0.0052448,0.0054001,0.0043135,0.0040817,0.004354,0.0052396,0.0053951,0.0043334,0.0040639,0.0043324,0.0052183,0.0054048,0.0043467,0.004061,0.0043226,0.005221,0.0054076,0.0043564,0.0040827,0.00433,0.0052316,0.0054124,0.0043579,0.004079,0.0042999,0.0052216,0.0054159,0.0043788,0.0040659,0.0042923,0.0052216,0.005419,0.0043905,0.0040921,0.004293,0.0052051,0.0053939,0.0043955,0.0040759,0.0042673,0.005188,0.005405,0.0044075,0.0040759,0.00427,0.0051878,0.0054236,0.0044274,0.0040855,0.0042473,0.0051943,0.0054208,0.0044431,0.0040783,0.0042409,0.0051783,0.0054205,0.0044447,0.0040758,0.0042355,0.0051646,0.0054183,0.0044493,0.0040841,0.0042215,0.0051712,0.0054128,0.0044614,0.0040845,0.0042118,0.0051645,0.005416,0.0044679,0.0040821,0.0042076,0.0051577,0.005435,0.0044823,0.0040864,0.004192,0.0051547,0.0054137,0.0045104,0.0040844,0.0041832,0.0051328,0.005428,0.0045181,0.0040768,0.0041783,0.0051485,0.0054405,0.0045311,0.0041058,0.0041733,0.0051318,0.005425,0.004542,0.0040955,0.0041593,0.005137,0.0054165,0.0045521,0.0041063,0.0041482,0.0051304,0.0054406,0.0045625,0.004098,0.0041537,0.0051041,0.0054352,0.0045642,0.0041059,0.0041305,0.0051109,0.0054237,0.004588,0.004104,0.0041244,0.0051004,0.0054103,0.0046041,0.0041196,0.0041086,0.0050861,0.0054078,0.0046158,0.0041133,0.004115,0.0050873,0.0026904:4
-1.5633E-6,-3.47E-6,-1.5833E-6,-8.9333E-7,-2.1767E-6,-2.7133E-6,-3.15E-6,-1.8867E-6,-1.8533E-6,-2.6467E-6,-1.21E-6,-2.8067E-6,-1.63E-6,-1.9233E-6,-1.8033E-6,-2.3467E-6,-3.19E-6,-1.1733E-6,-6.4667E-7,-2.05E-6,-1.8967E-6,-2.7767E-6,-1.41E-6,-2.0433E-6,-1.1567E-6,-1.1433E-6,-3.83E-6,-1.7633E-6,-2.4E-6,-1.9833E-6,-2.72E-6,-2.4333E-6,-1.6667E-6,-9.8333E-7,-2.1667E-6,-2.4833E-6,-1.7367E-6,-1.96E-6,-2.01E-6,-1.32E-6,-1.5933E-6,-2.8967E-6,-1.5533E-6,-1.4133E-6,-1.9433E-6,-1.0933E-6,-3.2E-6,-2.7167E-6,-1.19E-6,-2.0867E-6,-1.4233E-6,-3.0933E-6,-1.37E-6,-1.7367E-6,-1.7167E-6,-1.3733E-6,-2.4867E-6,-2.49E-6,-1.2033E-6,-1.2733E-6,-2.3567E-6,-2.8033E-6,-1.5767E-6,-1.84E-6,-1.95E-6,-1.9567E-6,-2.89E-6,-2.34E-6,-1.48E-6,-1.5733E-6,-1.0333E-6,-2.7833E-6,-2.42E-6,-1.19E-6,-8.7E-7,-1.24E-6,-3.1333E-6,-1.68E-6,-2.69E-6,-2.15E-6,-1.6767E-6,-2.9133E-6,-1.94E-6,-1.7567E-6,-1.88E-6,8.1263E-4,0.0023927,0.0012619,0.0021432,0.0018942,0.0022908,0.0022503,0.0014571,0.0019861,0.0019604,0.0022745,0.0022178,0.0015003,0.0019443,0.0019651,0.0022689,0.0022245,0.001514,0.0019349,0.0019664,0.0022703,0.0022138,0.001511,0.001927,0.0019609,0.0022807,0.0022212,0.0015083,0.0019213,0.0019485,0.0022773,0.0022259,0.0015138,0.0019232,0.0019522,0.0022694,0.002223,0.0015188,0.0019057,0.0019404,0.0022829,0.0022266,0.0015209,0.0019055,0.0019392,0.0022805,0.0022301,0.0015196,0.0019068,0.0019215,0.0022819,0.0022398,0.0015313,0.0019051,0.001921,0.0022802,0.0022447,0.0015325,0.0018959,0.0019121,0.0022878,0.0022419,0.0015301,0.0018893,0.0019016,0.0022823,0.0022474,0.0015347,0.001892,0.0019066,0.0022923,0.0022512,0.0015429,0.0018857,0.0018957,0.0022827,0.002255,0.0015437,0.0018836,0.001886,0.0022827,0.002254,0.0015428,0.0018779,0.0018779,0.0022881,0.0022526,0.0015489,0.0018753,0.0018698,0.0022884,0.0022671,0.0015477,0.0018691,0.0018643,0.0022877,0.0022573,0.0015521,0.0018686,0.0018614,0.0022925,0.002265,0.0015546,0.0018612,0.0018527,0.0022856,0.0022709,0.0015614,0.0018583,0.0018488,0.0022975,0.0022736,0.0015637,0.0018633,0.0018383,0.0022905,0.0022748,0.0015673,0.001858,0.0018306,0.0022899,0.0022852,0.0015716,0.0018518,0.0018239,0.0022901,0.0022762,0.0015741,0.0018528,0.0018251,0.0022929,0.002284,0.0015829,0.0018511,0.0018149,0.0022936,0.0022802,0.001584,0.0018463,0.0018101,0.0022954,0.0022796,0.0015825,0.0018487,0.001804,0.0022967,0.0022855,0.0015921,0.0018488,0.001794,0.0022916,0.0022834,0.0016001,0.0018391,0.0017868,0.0022952,0.0022892,0.0015963,0.0018357,0.0017836,0.0022921,0.0022914,0.0016063,0.0018306,0.0017781,0.0022963,0.0022917,0.0016127,0.0018354,0.0017704,0.0022956,0.0023011,0.0016117,0.0018297,0.0017681,0.0022939,0.002291,0.0016249,0.0018357,0.0017608,0.0022853,0.0022966,0.0016245,0.0018298,0.0017553,0.0022934,0.0022949,0.0016292,0.0018357,0.0017475,0.0022898,0.0022983,0.0016426,0.0018298,0.0017441,0.0022918,0.0023027,0.0016447,0.0018295,0.0017369,0.0022941,0.0023024,0.0016474,0.001829,0.0017287,0.0022874,0.002306,0.0016496,0.0018281,0.0017196,0.002288,0.0023055,0.0016572,0.0018276,0.0017186,0.0022869,0.0023098,0.0016666,0.0018269,0.0017148,0.0022859,0.0023086,0.0016795,0.001827,0.0017057,0.0022881,0.0023082,0.0016779,0.0018274,0.0017051,0.0022778,0.0023062,0.0016827,0.0018296,0.0016939,0.0022825,0.0023093,0.0016879,0.0018303,0.0016908,0.0022887,0.0023083,0.0016968,0.0018228,0.0016857,0.0022802,0.0023057,0.0017046,0.0018295,0.0016784,0.0022785,0.0023095,0.00171,0.0018275,0.0016779,0.0022826,0.0023115,0.0017186,0.0018184,0.0016735,0.0022786,0.0023138,0.0017156,0.0018256,0.001668,0.0022824,0.0023112,0.0017253,0.0018271,0.0016527,0.0022714,0.0023058,0.0017409,0.0018235,0.0016489,0.0022674,0.0023107,0.0017427,0.0018262,0.0016457,0.002269,0.002303,0.0017501,0.0018291,0.0016468,0.00227,0.0022994,0.0017649,0.0018241,0.0016352,0.0022613,0.0023036,0.0017598,0.0018298,0.0016342,0.0022627,0.0022973,0.001772,0.0018314,0.001628,0.0022599,0.0022977,0.001779,0.0018282,0.0016164,0.0022576,0.0022988,0.0017882,0.001836,0.001616,0.0022544,0.0023013,0.0017967,0.0018316,0.0016054,0.0022527,0.0022955,0.0018025,0.0018343,0.0016084,0.0022562,0.0022953,0.0018117,0.0018374,0.0016024,0.0022504,0.0022937,0.001819,0.0018415,0.0015898,0.0022455,0.0022879,0.0018234,0.0018398,0.0015847,0.0022481,0.0022857,0.0018309,0.001846,0.0015805,0.0022353,0.0022758,0.0018389,0.0018414,0.0015819,0.0022312,0.0022813,0.0018466,0.0018451,0.0015775,0.0022334,0.0022724,0.0018585,0.0018494,0.0015688,0.0022348,0.0022807,0.0018656,0.0018499,0.001561,0.0022279,0.002272,0.0018747,0.0018557,0.0015632,0.0022318,0.0022723,0.001888,0.0018616,0.0015559,0.0022166,0.0022687,0.0018889,0.0018552,0.0015559,0.0022202,0.0022671,0.0019029,0.0018638,0.0015457,0.0022128,0.0022588,0.0019063,0.0018642,0.0015427,0.0022094,0.0022597,0.001911,0.0018719,0.0015459,0.0021954,0.0022531,0.0019203,0.001877,0.0015377,0.0021982,0.0022508,0.0019343,0.0018789,0.0015279,0.0021967,0.0022488,0.0019347,0.0018802,0.0015217,0.0021853,0.002248,0.0019425,1.4622E-4:4
-1.53E-6,-1.91E-6,-2.3533E-6,-2.75E-6,-1.1267E-6,-3.2733E-6,-2.55E-6,-2.41E-6,-3.2567E-6,-4.9667E-7,-2.9133E-6,-2.0933E-6,-2.6467E-6,-1.7567E-6,-7.5E-7,-2.4967E-6,-1.61E-6,-3.2633E-6,-2.6067E-6,-1.8333E-6,-1.6033E-6,-1.2067E-6,-2.9533E-6,-2.5367E-6,-8.5E-7,-3.5867E-6,-2.3267E-6,-2.9533E-6,-2.5233E-6,-1.2767E-6,-2.13E-6,-2.32E-6,-2.54E-6,-3.1233E-6,-4.0333E-7,-1.8867E-6,-2.59E-6,-2.7467E-6,-2.9633E-6,-4.9667E-7,-2.7E-6,6.8434E-4,0.002376,0.0012909,0.0021134,0.001903,0.0022861,0.0022439,0.0014726,0.0019698,0.0019562,0.0022763,0.0022159,0.0015023,0.001937,0.0019624,0.0022715,0.0022157,0.0015104,0.0019209,0.0019592,0.0022774,0.0022105,0.001515,0.0019181,0.0019554,0.0022766,0.002218,0.001519,0.0019183,0.0019429,0.002271,0.0022319,0.0015179,0.0019066,0.0019362,0.0022698,0.0022219,0.001521,0.0019049,0.0019341,0.0022816,0.0022242,0.0015184,0.0018986,0.0019266,0.0022765,0.0022313,0.0015184,0.0018974,0.0019269,0.0022778,0.0022324,0.001527,0.0018947,0.0019146,0.0022779,0.0022316,0.0015262,0.0018943,0.0019072,0.0022803,0.0022328,0.0015304,0.0018908,0.0018991,0.0022785,0.002242,0.0015404,0.0018757,0.0018943,0.0022781,0.0022455,0.0015387,0.0018796,0.0018885,0.0022787,0.0022464,0.001545,0.0018739,0.0018805,0.002281,0.0022551,0.0015418,0.0018729,0.001881,0.0022833,0.0022521,0.0015444,0.001865,0.001867,0.0022826,0.0022521,0.0015501,0.0018675,0.0018643,0.0022878,0.0022563,0.0015522,0.0018679,0.0018579,0.0022875,0.0022568,0.0015518,0.0018596,0.0018555,0.0022902,0.0022638,0.0015593,0.0018551,0.0018449,0.0022886,0.0022609,0.0015612,0.0018548,0.001838,0.0022891,0.0022683,0.0015626,0.0018464,0.0018304,0.0022837,0.0022682,0.0015725,0.0018514,0.0018261,0.0022871,0.0022685,0.0015782,0.001851,0.0018216,0.0022863,0.0022749,0.0015808,0.0018468,0.0018147,0.0022925,0.0022827,0.0015825,0.0018485,0.0018113,0.0022909,0.002281,0.0015831,0.0018437,0.0018032,0.0022937,0.0022825,0.0015867,0.0018438,0.0017943,0.0022843,0.0022805,0.001591,0.0018446,0.0017906,0.002286,0.0022898,0.0015985,0.0018419,0.0017846,0.0022893,0.0022838,0.0016007,0.0018334,0.0017802,0.0022904,0.002288,0.0016111,0.0018302,0.0017759,0.0022919,0.0022965,0.0016086,0.0018356,0.0017683,0.0022972,0.0022908,0.0016096,0.0018322,0.0017682,0.0022917,0.0023033,0.0016169,0.0018346,0.0017494,0.0022878,0.002292,0.0016239,0.0018312,0.0017533,0.0022936,0.0022971,0.0016295,0.0018212,0.0017458,0.0022862,0.0022963,0.0016359,0.0018269,0.0017399,0.0022953,0.0022987,0.0016381,0.001828,0.0017327,0.002285,0.0023022,0.0016422,0.0018278,0.0017234,0.0022886,0.0023075,0.0016527,0.0018225,0.0017256,0.0022857,0.0022964,0.001658,0.0018183,0.0017148,0.002284,0.0023022,0.0016618,0.0018241,0.0017124,0.0022841,0.0022941,0.0016685,0.0018201,0.001712,0.0022815,0.0022981,0.001676,0.0018225,0.0017038,0.002281,0.0022988,0.0016809,0.0018193,0.001694,0.0022732,0.0023076,0.0016801,0.0018185,0.0016895,0.0022808,0.0023056,0.0016904,0.0018165,0.0016849,0.0022763,0.0023036,0.0016963,0.0018236,0.0016849,0.0022781,0.0023063,0.0017063,0.0018187,0.0016718,0.0022722,0.0023021,0.0017083,0.0018217,0.0016703,0.0022802,0.002301,0.0017129,0.0018204,0.0016639,0.0022746,0.0023044,0.0017225,0.0018242,0.0016592,0.002273,0.0022981,0.0017258,0.0018217,0.0016528,0.0022735,0.0023048,0.0017324,0.0018181,0.0016476,0.0022706,0.0023016,0.001742,0.001826,0.0016456,0.0022578,0.0022999,0.0017466,0.0018232,0.0016391,0.0022638,0.0023015,0.0017537,0.0018234,0.0016364,0.0022678,0.0022999,0.0017643,0.0018288,0.0016332,0.0022608,0.0023086,0.0017622,0.0018325,0.0016254,0.0022538,0.0023012,0.0017703,0.0018294,0.0016196,0.0022577,0.002291,0.0017792,0.0018327,0.0016144,0.0022519,0.0022955,0.0017871,0.0018319,0.0016069,0.0022481,0.0022924,0.0017901,0.0018307,0.0016033,0.0022557,0.0022961,0.0018012,0.0018375,0.0015962,0.0022445,0.0022948,0.0018073,0.0018392,0.0015967,0.0022436,0.0022912,0.001813,0.0018328,0.0015841,0.0022429,0.0022876,0.0018164,0.0018361,0.0015879,0.0022483,0.0022865,0.0018314,0.0018351,0.001583,0.0022377,0.0022826,0.0018337,0.0018414,0.0015742,0.0022294,0.0022788,0.0018421,0.0018483,0.0015699,0.002231,0.0022793,0.0018509,0.0018479,0.0015717,0.0022239,0.0022762,0.0018612,0.0018462,0.0015591,0.0022254,0.002275,0.0018681,0.0018493,0.0015613,0.0022256,0.0022732,0.0018716,0.0018529,0.0015583,0.002215,0.0022745,0.0018752,0.0018604,0.0015519,0.0022175,0.0022614,0.0018847,0.0018616,0.0015504,0.0022123,0.0022618,0.0018989,0.0018614,0.0015474,0.0022056,0.0022568,0.0019018,0.0018636,0.0015417,0.0022052,0.002261,0.0019128,0.0018658,0.0015373,0.0022035,0.0022549,0.001919,0.0018673,0.0015387,0.0021949,0.0022554,0.001922,0.0018772,0.0015351,0.0022013,0.0022492,0.0019325,0.0018796,0.001526,0.0021937,0.0022437,0.0019435,0.0018848,0.0015228,0.0021875,0.0022528,0.0019416,0.0018852,0.0015261,0.0017376:4
-2.0467E-6,-2.74E-6,-1.3E-7,-2.0533E-6,-3.14E-6,-6.4E-7,-3.5133E-6,-7.6667E-8,-3.0033E-6,-2.89E-6,-1.3833E-6,-2.6267E-6,-1.5667E-7,-2.19E-6,-2.57E-6,-1.8333E-7,-3.9133E-6,-4.3667E-7,-3.2433E-6,-2.0E-6,-6.6E-7,-2.53E-6,-5.9667E-7,-2.9467E-6,-2.76E-6,-9.5E-7,1.8283E-5,0.0022573,0.0021518,0.002095,0.0020341,0.0014381,0.0017104,1.5127E-4,3.56E-5,-1.3149E-4,1.1166E-4,-7.1313E-5,2.3223E-5,5.9533E-6,-2.0337E-5,1.6577E-5,-6.09E-6,-7.3333E-8,-1.6167E-6,-2.13E-6,-2.6367E-6,-1.1E-7,-3.3067E-6,-1.9367E-6,-1.3867E-6,9.1624E-4,0.0023748,0.0020796,0.0021198,0.0021101,0.0014153,0.0021296,0.0021532,0.0021318,0.002039,0.0014719,0.0020973,0.0021626,0.0021378,0.0020322,0.0014788,0.0020781,0.0021518,0.0021458,0.0020391,0.0014835,0.0020719,0.0021427,0.0021492,0.0020339,0.0014841,0.0020618,0.0021352,0.0021535,0.002043,0.0014792,0.0020595,0.002134,0.0021577,0.0020461,0.00148,0.0020509,0.0021243,0.0021549,0.0020548,0.0014768,0.0020505,0.0021171,0.0021614,0.0020517,0.001473,0.0020417,0.0021146,0.0021648,0.0020605,0.0014694,0.0020293,0.0021048,0.0021687,0.0020608,0.0014742,0.0020353,0.0020989,0.0021683,0.002065,0.0014741,0.002023,0.0020942,0.0021783,0.0020701,0.0014761,0.0020089,0.0020876,0.0021847,0.0020821,0.0014715,0.002017,0.0020878,0.0021838,0.0020806,0.0014722,0.002006,0.0020816,0.0021863,0.0020875,0.0014763,0.0019986,0.0020689,0.0021922,0.0020981,0.0014786,0.0019991,0.0020648,0.0021984,0.0020954,0.0014692,0.0019911,0.0020602,0.0022009,0.0020996,0.0014727,0.0019842,0.0020524,0.002204,0.0021093,0.0014758,0.0019873,0.0020524,0.0022071,0.0021173,0.0014757,0.0019792,0.00204,0.0022035,0.0021177,0.0014743,0.0019763,0.0020367,0.0022116,0.0021203,0.0014807,0.0019676,0.0020324,0.0022126,0.0021266,0.0014762,0.0019615,0.0020265,0.0022207,0.0021333,0.0014796,0.0019574,0.0020224,0.0022238,0.002136,0.0014808,0.0019575,0.0020132,0.002222,0.0021393,0.0014775,0.0019493,0.0020067,0.0022209,0.002147,0.0014796,0.0019469,0.0020025,0.0022308,0.0021516,0.0014831,0.0019386,0.0019923,0.0022311,0.002157,0.0014857,0.0019337,0.0019946,0.0022355,0.0021639,0.0014853,0.0019307,0.0019829,0.0022356,0.0021671,0.0014857,0.0019224,0.0019735,0.0022417,0.0021733,0.0014855,0.0019228,0.0019678,0.0022372,0.0021786,0.0014919,0.0019169,0.0019696,0.0022442,0.0021825,0.0014886,0.0019098,0.0019599,0.0022442,0.0021807,0.0014978,0.0019092,0.00195,0.0022534,0.0021908,0.0014979,0.0019127,0.0019422,0.0022499,0.002193,0.0014952,0.001903,0.001942,0.0022494,0.0022012,0.001501,0.0018994,0.0019378,0.0022545,0.0022062,0.0015064,0.0018992,0.0019299,0.0022548,0.0022047,0.0015036,0.0018987,0.001921,0.0022637,0.0022098,0.0015152,0.00189,0.0019124,0.0022658,0.0022171,0.0015158,0.0018814,0.0019097,0.0022609,0.0022209,0.0015141,0.0018845,0.0019002,0.0022635,0.0022201,0.0015144,0.0018735,0.0018987,0.0022698,0.0022275,0.0015206,0.0018742,0.0018959,0.0022776,0.0022287,0.0015234,0.0018727,0.0018884,0.0022681,0.0022354,0.0015292,0.0018702,0.0018802,0.0022761,0.0022403,0.0015338,0.0018715,0.0018747,0.002272,0.0022406,0.0015333,0.0018611,0.0018726,0.002274,0.002241,0.0015342,0.001864,0.0018639,0.0022747,0.0022496,0.001534,0.0018628,0.0018554,0.0022776,0.0022531,0.0015418,0.0018558,0.001847,0.0022725,0.0022548,0.0015435,0.001854,0.0018411,0.002276,0.002251,0.0015521,0.0018536,0.0018374,0.002279,0.0022605,0.0015577,0.0018511,0.0018284,0.0022811,0.0022612,0.001559,0.0018486,0.0018332,0.0022767,0.002267,0.0015646,0.0018484,0.0018194,0.0022802,0.0022707,0.0015698,0.0018465,0.0018114,0.0022907,0.0022687,0.0015774,0.0018456,0.0018073,0.0022853,0.0022664,0.0015804,0.0018419,0.0018068,0.0022907,0.0022751,0.0015812,0.0018316,0.0017979,0.0022836,0.002277,0.0015879,0.0018364,0.0017918,0.0022892,0.0022809,0.0015919,0.0018325,0.0017861,0.002287,0.0022828,0.0015947,0.0018368,0.0017853,0.0022965,0.0022907,0.0016018,0.0018302,0.0017773,0.0022854,0.002289,0.0016016,0.0018307,0.0017683,0.0022841,0.002289,0.0016076,0.0018281,0.001754,0.0022838,0.0022938,0.0016113,0.0018267,0.0017545,0.0022839,0.0022896,0.0016199,0.0018351,0.0017559,0.0022842,0.0022948,0.0016257,0.0018295,0.0017462,0.0022903,0.0022973,0.0016273,0.0018309,0.00174,0.0022842,0.0022984,0.0016358,0.0018264,0.0017338,0.0022872,0.0022963,0.0016448,0.0018261,0.0017258,0.0022837,0.0022986,9.6078E-4:4
1.48E-6,1.49E-6,2.06E-6,1.0467E-6,1.55E-6,9.7667E-7,1.2533E-6,1.04E-6,5.2E-7,2.8067E-6,1.5067E-6,1.3267E-6,1.1633E-6,7.0667E-7,1.2767E-6,2.55E-6,-4.5333E-7,1.6E-6,1.57E-6,1.1733E-6,1.95E-6,1.9333E-7,8.6667E-7,4.8667E-7,1.56E-6,3.4533E-6,-5.0333E-7,1.0333E-6,-1.09E-6,2.56E-6,2.35E-6,4.7E-7,1.6067E-6,-4.2667E-7,1.6033E-6,1.7367E-6,6.6667E-8,1.2133E-6,8.9667E-7,2.03E-6,2.65E-6,2.72E-6,2.3133E-6,-1.3667E-6,0.0016166,0.0079663,0.0075595,0.006214,0.0060856,0.0071977,0.0080684,0.0076436,0.0060574,0.0061856,0.0070786,0.0080638,0.0076511,0.0060476,0.0062024,0.0070464,0.0080472,0.0076532,0.0060336,0.0061763,0.0069959,0.0080249,0.0076631,0.0060296,0.0061504,0.0069664,0.0080299,0.0076467,0.0060175,0.0061436,0.0069424,0.0079935,0.0076489,0.0060309,0.0061093,0.0069045,0.0079957,0.00768,0.006064,0.0061081,0.0068822,0.0079854,0.0076883,0.0060398,0.0061114,0.0068541,0.0079765,0.0076511,0.0060449,0.0061004,0.0068284,0.0079802,0.0077252,0.0060689,0.0060863,0.0068004,0.0079609,0.007704,0.0060852,0.0060974,0.0067762,0.0079677,0.0077117,0.0061056,0.0060737,0.0067703,0.0079664,0.0077192,0.0061075,0.0060639,0.0067233,0.0079605,0.0077269,0.0061467,0.0060447,0.0067335,0.0079541,0.0077146,0.0061478,0.0060468,0.0066881,0.0079553,0.007743,0.0061622,0.0060388,0.0066808,0.0079441,0.0077646,0.0061833,0.0060419,0.0066529,0.0079338,0.007763,0.006211,0.0060335,0.0066447,0.0079303,0.0077605,0.0062168,0.0060322,0.006616,0.0079214,0.007777,0.0062245,0.0060138,0.0065832,0.0079126,0.0077879,0.0062472,0.0060331,0.0065872,0.0079191,0.0077925,0.0062671,0.0060068,0.0065405,0.0079151,0.0077962,0.0062748,0.0060094,0.0065432,0.0079086,0.0078156,0.0062992,0.0060016,0.0065068,0.0079159,0.0078381,0.0063322,0.0060144,0.0064848,0.0078837,0.0078173,0.0063666,0.0059974,0.0064774,0.0079143,0.0078268,0.0063712,0.0060146,0.006456,0.0078765,0.0078402,0.0063824,0.005998,0.0064431,0.0078681,0.0078503,0.0064038,0.0060061,0.0064088,0.0078656,0.007883,0.0064381,0.006001,0.0063904,0.0078402,0.0078597,0.0064487,0.0060015,0.0063619,0.0078482,0.0078885,0.0064676,0.006002,0.0063505,0.007827,0.0078882,0.0064803,0.0059922,0.0063392,0.0078269,0.0078702,0.0065011,0.0059906,0.0063208,0.0078104,0.0078905,0.0065155,0.0060035,0.0062889,0.0078273,0.007897,0.0065376,0.0060078,0.0062644,0.0077957,0.0078882,0.0065679,0.0059968,0.0062577,0.0077939,0.0079174,0.0065823,0.0060002,0.0062652,0.0077891,0.0078941,0.0066146,0.0059891,0.0062355,0.0077371,0.0079199,0.0066452,0.0059987,0.0062104,0.0077543,0.0079227,0.0066696,0.0059993,0.0062046,0.0077385,0.0079256,0.0066837,0.0059978,0.0061912,0.0077197,0.0079524,0.0066887,0.006006,0.0061741,0.0077101,0.0079633,0.0067171,0.0060202,0.0061487,0.0077087,0.0079511,0.0067543,0.0060143,0.0061367,0.0077075,0.0079595,0.006738,0.0060193,0.0061165,0.0076885,0.0079535,0.0067857,0.0060217,0.0061015,0.0076675,0.00795,0.0067995,0.0060082,0.0061042,0.0076871,0.0079457,0.0068359,0.0060393,0.006092,0.0076695,0.007945,0.0068652,0.0060403,0.0060981,0.0076372,0.0079632,0.0068545,0.0060288,0.0060672,0.0076307,0.0079664,0.0068815,0.0060492,0.0060357,0.007597,0.0079698,0.0069147,0.0060679,0.0060402,0.0075732,0.0079651,0.0069236,0.0060552,0.0060157,0.0075855,0.0079598,0.0069437,5.5562E-4:4
2.5033E-6,8.9E-7,3.2667E-7,1.4533E-6,-2.8333E-7,2.0233E-6,1.4767E-6,7.4E-7,2.4933E-6,9.1E-7,2.7533E-6,1.9033E-6,4.0E-7,1.4967E-6,8.8667E-7,1.8767E-6,1.3867E-6,2.2267E-6,1.6233E-6,2.7333E-7,1.7833E-6,2.1567E-6,1.6667E-7,2.2867E-6,3.2E-7,1.8833E-6,1.1733E-6,2.7E-7,2.5233E-6,-9.6667E-8,2.34E-6,2.2633E-6,4.8E-7,1.57E-6,-3.4333E-7,1.76E-6,8.5E-7,9.6333E-7,2.1E-6,-2.6667E-8,2.0133E-6,2.2167E-6,-2.3667E-7,1.77E-6,-5.3333E-8,1.71E-6,1.26E-6,1.8233E-6,1.3267E-6,8.1E-7,2.5067E-6,0.0023204,0.0081011,0.0065177,0.0063657,0.0062368,0.0079734,0.0080589,0.0066614,0.0061505,0.0063111,0.0079097,0.0080465,0.0066998,0.0061095,0.0063096,0.0078539,0.0080022,0.0067139,0.0060655,0.0062723,0.0078167,0.0079915,0.0067358,0.0060388,0.0062462,0.0077956,0.00798,0.0067579,0.0060657,0.0062029,0.007776,0.007967,0.0067415,0.0060407,0.0061906,0.0077313,0.0079656,0.0067646,0.0060322,0.006148,0.0077205,0.0079389,0.0067827,0.0060325,0.0061425,0.0076928,0.0079457,0.0068057,0.0060409,0.0061212,0.0076925,0.007949,0.0068114,0.0060348,0.0061003,0.0076517,0.0079483,0.0068558,0.0060386,0.006101,0.0076067,0.007951,0.0068787,0.0060303,0.0060735,0.007601,0.0079582,0.0068771,0.0060405,0.0060546,0.0076005,0.0079687,0.0068942,0.0060364,0.0060306,0.007587,0.0079621,0.0069191,0.0060599,0.0060273,0.0075821,0.0079589,0.0069512,0.0060668,0.006011,0.0075454,0.0079668,0.0069747,0.0060781,0.0059783,0.0075323,0.0079537,0.0069959,0.0060688,0.0059549,0.0075392,0.0079599,0.0069975,0.0060865,0.0059624,0.0074692,0.0079381,0.0070255,0.0060762,0.0059436,0.0074736,0.0079446,0.0070459,0.0060976,0.0059533,0.0074532,0.007962,0.0070756,0.0060953,0.0059134,0.0074072,0.0079352,0.0071019,0.0061074,0.0059053,0.0074177,0.0079647,0.0071174,0.0061272,0.0058924,0.0073716,0.007955,0.0071444,0.0061472,0.0058991,0.0073834,0.0079582,0.0071661,0.0061514,0.0058701,0.0073543,0.0079728,0.0071844,0.0061496,0.0058583,0.0073362,0.0079414,0.007211,0.0061595,0.0058346,0.0073084,0.0079489,0.0072224,0.0061718,0.005823,0.007304,0.007943,0.0072447,0.0061973,0.0058099,0.0072708,0.0079468,0.0072762,0.0062018,0.0057927,0.007239,0.0079502,0.0072741,0.0062401,0.0058098,0.0072213,0.007943,0.0073084,0.0062209,0.0057781,0.007193,0.0079399,0.0073337,0.0062615,0.0057787,0.0071704,0.0079545,0.0073534,0.006294,0.0057591,0.0071454,0.0079192,0.0073628,0.006287,0.0057602,0.0071224,0.0079211,0.0073971,0.0063111,0.0057475,0.0070911,0.0079114,0.0074378,0.0063182,0.0057429,0.0070712,0.0079171,0.0074251,0.0063518,0.0057269,0.0070755,0.0078937,0.0074411,0.0063708,0.005725,0.0070377,0.0079079,0.0074623,0.0063877,0.0057057,0.0070243,0.007894,0.0075108,0.0063894,0.0056977,0.0069736,0.007896,0.007504,0.0064043,0.0056896,0.0069576,0.007885,0.0075228,0.0064354,0.0056992,0.0069323,0.0078746,0.0075365,0.0064361,0.0056775,0.0069047,0.0078585,0.0075543,0.0064778,0.0056836,0.0068977,0.0078871,0.0075881,0.0064955,0.0056778,0.0068902,0.0078523,0.0075833,0.0064811,0.0056638,0.0068636,0.0078613,0.0075797,0.0065475,0.0056687,0.0068503,0.0078434,0.0076056,0.0065626,0.0056767,0.0068251,0.0078154,0.0076436,0.0065712,0.0056473,0.0068125,0.007814,0.0076575,0.0066069,0.0056607,0.0067978,0.0078129,0.0076697,0.0066289,0.0056463,0.0067664,0.0078049,0.007662,0.0066393,0.0056449,0.006735,0.0077959,0.0076954,0.0066636,0.0056532,0.0067108,0.0077818,0.0076852,0.0066821,0.0056551,0.0066866,0.0077736,0.0077329,0.0067046,0.005653,0.0066616,0.0077655,0.0077008,0.0067207,0.0056548,0.0066649,0.0077604,0.0077407,0.0067627,0.0056457,0.0066412,0.0077328,0.007752,0.0067698,0.0056476,0.0058718:4
1.2633E-6,1.5567E-6,5.5E-7,8.6333E-7,9.2333E-7,1.2633E-6,1.4333E-6,4.8667E-7,1.1E-6,9.9667E-7,1.7933E-6,1.66E-6,5.6E-7,1.0933E-6,1.2433E-6,9.0333E-7,5.3E-7,3.6667E-8,8.8E-7,8.6E-7,9.5333E-7,1.0833E-6,7.9667E-7,8.1E-7,1.1867E-6,7.4E-7,1.7933E-6,7.0667E-7,9.1333E-7,9.4667E-7,1.1367E-6,1.6567E-6,0.0063646,0.0071697,0.0075654,0.009158,0.0094134,0.0081839,0.0068355,0.0077731,0.0090803,0.0093591,0.0082219,0.0067349,0.0078381,0.0090142,0.0093299,0.0081907,0.0067015,0.0078311,0.0089865,0.0093005,0.0081514,0.0066602,0.007829,0.0089815,0.0092665,0.008099,0.0066481,0.0078068,0.0089812,0.0092264,0.0080789,0.0066066,0.0077897,0.0089771,0.00922,0.0080388,0.0066103,0.0077958,0.0089429,0.0091817,0.0080322,0.0065782,0.0078041,0.0089344,0.0091687,0.00799,0.0065641,0.007809,0.0089413,0.0091518,0.0079726,0.0065628,0.0077776,0.0089657,0.0091384,0.007962,0.0065515,0.0077882,0.0089554,0.0090796,0.0079201,0.0065317,0.0078103,0.0089156,0.0091218,0.0079221,0.0065594,0.0078281,0.0089978,0.0090889,0.0079036,0.0065914,0.0078798,0.0089944,0.0091006,0.0078892,0.0065695,0.007844,0.0089732,0.009086,0.0078589,0.0065597,0.0078683,0.0089827,0.0090506,0.0078588,0.0065733,0.0078668,0.0089982,0.0090363,0.0078461,0.0065455,0.0078707,0.0090266,0.0090455,0.0078178,0.0065459,0.0078889,0.0090038,0.0089982,0.0077993,0.0065704,0.0079135,0.0090066,0.0089928,0.0077898,0.0065657,0.0079208,0.0089992,0.0090235,0.0077608,0.0065673,0.0078847,0.0090138,0.0089846,0.0077462,0.0065616,0.0079368,0.009019,0.0089701,0.0077399,0.0065472,0.0079479,0.0090203,0.0089885,0.0077272,0.0065486,0.0079457,0.0090641,0.0089685,0.0076963,0.0065487,0.0079641,0.0090415,0.0089302,0.0077021,0.0065571,0.0079921,0.0090625,0.0089378,0.0076759,0.0065612,0.0079883,0.0090342,0.0089175,0.0076504,0.0065335,0.0080019,0.0090452,0.008926,0.0076224,0.0065462,0.0079895,0.0090571,0.0089299,0.0076427,0.0065825,0.0080315,0.0090692,0.0089028,0.0076134,0.0065765,0.0080425,0.0090911,0.0088871,0.0076201,0.0065465,0.0080773,0.0090923,0.0088707,0.0076089,0.0065811,0.0080873,0.0091083,0.0088804,0.0075969,0.006587,0.0080879,0.009108,0.0088682,0.0075567,0.0065687,0.0080799,0.009128,0.0088561,0.0075657,0.006579,0.0080936,0.0091133,0.0088302,0.0075677,0.0066053,0.0081422,0.0091126,0.0088306,0.0075354,0.0065779,0.0081231,0.0091229,0.008809,0.0075108,0.0066154,0.0081378,0.0091338,0.0088003,0.0074999,0.0065904,0.0081586,0.0091253,0.0087707,0.0074823,0.0066035,0.0081734,0.0091564,0.0088068,0.0074942,0.0065888,0.008171,0.0091352,0.0087789,0.0074643,0.0065936,0.0081767,0.0091656,0.0087269,0.0074742,0.0066181,0.0082241,0.0091255,0.0087118,0.0074796,0.0065922,0.0082409,0.0091493,0.0087323,0.0074526,0.0066031,0.0082185,0.0091469,0.0087157,0.0074133,0.006604,0.0082391,0.0091682,0.0087093,0.007424,0.0066283,0.008247,0.0091841,0.0087063,0.0074119,0.0066143,0.008254,0.009169,0.0086903,0.0073778,0.0066449,0.0082556,0.009192,0.0086808,0.0074027,0.0066269,0.0082602,0.0091764,0.0086457,0.0073781,0.0066242,0.0083067,0.009193,0.0086607,0.0073847,0.0066451,0.0082963,0.0091839,0.0086152,0.0073733,0.0066085,0.0083083,0.009201,0.0086117,0.0073329,0.0066274,0.0082974,0.0091919,0.0086033,0.007342,0.0066396,0.0083306,0.0091692,0.0086221,0.007341,0.0066494,0.0083223,0.0091751,0.0085496,0.0073507,0.0066552,0.008348,0.0091997,0.0085515,0.0073331,0.0066495,0.008363,0.009198,0.0085454,0.0073223,0.0066777,0.0083788,0.0091776,0.0085543,0.0072902,0.0066756,0.0083884,0.0092117,0.0085243,0.0072831,0.0066801,0.0083786,0.0091946,0.0085418,0.0072766,0.0066773,0.008408,0.0092162,0.0085044,0.0072672,0.0066852,0.0084069,0.009206,0.0084994,0.0072902,0.0067056,0.0084289,0.0092312,0.0084917,0.0072689,0.0067035,0.0084254,0.0092068,0.0084703,0.0072675,0.0067281,0.0084447,0.009223,0.0041459:4
7.1667E-7,1.0667E-6,1.2667E-6,1.7267E-6,1.61E-6,7.1333E-7,1.51E-6,2.5967E-6,1.1933E-6,6.4333E-7,1.31E-6,1.5833E-6,1.3667E-6,1.3367E-6,1.2233E-6,7.7667E-7,1.0067E-6,1.5467E-6,0.0058474,0.0076214,0.0068636,0.0082651,0.0093367,0.0091068,0.007329,0.007125,0.0080847,0.0093592,0.0091061,0.0072503,0.0071406,0.0080316,0.0093432,0.0090758,0.0071627,0.0071378,0.0080148,0.0093301,0.0090423,0.00714,0.0071125,0.0080063,0.0093121,0.0090341,0.007097,0.0071109,0.0079995,0.0092831,0.0089977,0.0070542,0.0071206,0.0079775,0.009258,0.0089763,0.0070454,0.0070729,0.0079694,0.0092567,0.0089301,0.0070297,0.0070917,0.007974,0.0092531,0.0089073,0.0069947,0.0070733,0.0079911,0.00922,0.0088986,0.006992,0.0070598,0.0079892,0.00921,0.0088525,0.006945,0.0070658,0.0080235,0.0092109,0.0088434,0.0069327,0.0070549,0.0080141,0.0091995,0.0088245,0.0069247,0.0070448,0.0080533,0.0091948,0.0087982,0.0068733,0.0070532,0.0080212,0.0091962,0.0087942,0.0068589,0.0070757,0.0080119,0.0091827,0.0087874,0.0068561,0.0070514,0.0080531,0.009213,0.0087901,0.0068624,0.0070475,0.0080541,0.0091752,0.0087407,0.0068538,0.0070535,0.0080695,0.0091779,0.0087097,0.0068137,0.0070765,0.0080664,0.0091999,0.0087299,0.0068192,0.007047,0.0080904,0.0091797,0.0087361,0.0068035,0.0070773,0.008099,0.0091705,0.008674,0.0067703,0.0070883,0.0081226,0.0091892,0.0086781,0.0067655,0.0071173,0.0081095,0.0092056,0.00869,0.0067837,0.0070846,0.0081296,0.0092007,0.0086899,0.0067425,0.0071245,0.008166,0.0091743,0.0086552,0.0067515,0.0071128,0.0081329,0.0091436,0.0086299,0.0067314,0.0070979,0.0081887,0.0091584,0.0086267,0.0067063,0.0071255,0.0081879,0.0091729,0.0086113,0.0067304,0.0071197,0.008196,0.0091768,0.008588,0.0067368,0.0071462,0.0082295,0.0091385,0.0085762,0.0067026,0.0071416,0.0082208,0.0091951,0.0085617,0.0066883,0.0071407,0.0082253,0.0091491,0.0085604,0.0066983,0.0071669,0.0082381,0.0091478,0.0085495,0.0066887,0.0071785,0.0082217,0.0091696,0.008529,0.006688,0.0071736,0.0082601,0.0091546,0.0085077,0.0066744,0.0071831,0.0082737,0.0091478,0.0085086,0.0066543,0.0071948,0.0083138,0.009145,0.0085216,0.006652,0.0072001,0.0082992,0.0091278,0.0084813,0.006636,0.0071991,0.0083169,0.0091543,0.008455,0.006635,0.0072258,0.0083278,0.0091617,0.0084471,0.0066183,0.0071987,0.0083237,0.0091322,0.0084358,0.006601,0.0072222,0.008345,0.0091431,0.0084043,0.0066092,0.0072331,0.0083824,0.0091471,0.0084096,0.0066201,0.0072251,0.0083701,0.0091435,0.008389,0.0065952,0.0072675,0.0083943,0.0091204,0.008376,0.006586,0.0072529,0.0083959,0.0091486,0.0083622,0.006585,0.0072658,0.0084202,0.0091331,0.0083366,0.0065856,0.0072782,0.0084427,0.0091398,0.0083468,0.00658,0.0072774,0.0084417,0.0091417,0.0083178,0.0065896,0.0072899,0.008468,0.0091322,0.0083032,0.0065739,0.0073187,0.0084358,0.00912,0.0082774,0.0065312,0.0073136,0.0084743,0.0091199,0.0082692,0.0065611,0.0073196,0.008487,0.0091347,0.0082495,0.0065546,0.0073259,0.0084932,0.0091294,0.0082247,0.0065327,0.0073315,0.0084846,0.0091162,0.0082519,0.0065494,0.0073816,0.008535,0.0091338,0.0082122,0.0065543,0.0073509,0.008539,0.0091194,0.0081851,0.0065121,0.0073767,0.0085456,0.0091378,0.0082036,0.0065306,0.0073744,0.0085401,0.0090919,0.0081743,0.0065131,0.007403,0.0085634,0.0091008,0.0081671,0.0065086,0.007387,0.0085789,0.009112,0.0081365,0.0065136,0.0074317,0.0085764,0.0091048,0.0081222,0.0065121,0.0074469,0.0085975,0.0091034,0.0081364,0.0064974,0.0074644,0.0086067,0.0090879,0.0081032,0.0065121,0.0074608,0.0086135,0.0091115,0.0080724,0.0065019,0.0074716,0.0086272,0.0090994,0.0080948,0.0064853,0.0074631,0.0086214,0.0090709,0.0080679,0.0064757:4
3.0E-7,1.4167E-6,6.4E-7,1.7333E-6,9.1667E-7,1.1267E-6,8.6E-7,1.1167E-6,1.3267E-6,1.8433E-6,7.2E-7,1.21E-6,6.6E-7,0.0041676,0.009146,0.007523,0.0069414,0.007314,0.0089762,0.0091593,0.0075026,0.0068886,0.0073161,0.0089936,0.0091046,0.0074679,0.0069234,0.0073461,0.0089778,0.0091445,0.0074702,0.0068995,0.0073055,0.0089492,0.0091404,0.0074473,0.0069222,0.0073614,0.0089827,0.0091282,0.0074251,0.006889,0.0073724,0.0089662,0.0091203,0.0074293,0.0068932,0.0073398,0.0089668,0.0090879,0.0074077,0.0069105,0.0073449,0.0089792,0.0091061,0.0073883,0.0069165,0.0073737,0.0089925,0.009095,0.0073675,0.0069164,0.0073878,0.0089684,0.0090656,0.0073744,0.0069046,0.0073809,0.008994,0.0090817,0.0073682,0.006914,0.0074081,0.0089772,0.0090706,0.0073728,0.0068853,0.0073971,0.0089763,0.0090729,0.0073472,0.0068972,0.0074367,0.0090127,0.0090642,0.0073166,0.0069085,0.0074013,0.0089956,0.0090842,0.0073369,0.0068773,0.0074613,0.0090062,0.009073,0.0073345,0.0068996,0.0074348,0.0090045,0.0090575,0.0072898,0.0068867,0.0074713,0.0089934,0.0090701,0.0073058,0.0068935,0.0074497,0.0090111,0.0090715,0.0072761,0.0069053,0.0074654,0.0089983,0.0090453,0.0072752,0.0069011,0.0074892,0.0090117,0.0090222,0.0072446,0.0069176,0.007487,0.0090106,0.0090487,0.0072236,0.00689,0.0074763,0.0090328,0.0090137,0.0072251,0.0068677,0.0075172,0.0090254,0.0090066,0.007217,0.0069041,0.0074899,0.0090226,0.0090473,0.0072017,0.0068863,0.0075175,0.0090411,0.0090126,0.007191,0.0069018,0.0075253,0.0090398,0.0090075,0.0072016,0.0069009,0.0075391,0.0090274,0.0090424,0.0071806,0.006902,0.0075694,0.0090466,0.0089724,0.0071627,0.0068923,0.0075546,0.0090288,0.0089777,0.0071647,0.0069162,0.0075805,0.0090401,0.0090009,0.0071451,0.0069226,0.0075642,0.0090535,0.0089748,0.0071361,0.0069168,0.0075809,0.0090624,0.0089817,0.0071295,0.0068978,0.0075716,0.0090554,0.0089992,0.0071392,0.0069394,0.0076024,0.009056,0.0089603,0.0071338,0.0069145,0.0076146,0.0090558,0.0089848,0.0070918,0.0069279,0.0076176,0.0090877,0.0089686,0.0071024,0.0069098,0.0076436,0.0090663,0.0089431,0.0070762,0.0069123,0.0076632,0.0090418,0.0089312,0.0070794,0.0069265,0.0076507,0.0090617,0.0089459,0.0070883,0.0069158,0.007678,0.0090554,0.0089496,0.0070706,0.006968,0.0076724,0.0090762,0.008912,0.0070603,0.0069227,0.0076689,0.0090857,0.008924,0.0070381,0.0069328,0.0076958,0.0090843,0.0089021,0.0070233,0.0069176,0.0077001,0.009069,0.0089084,0.0070411,0.0069216,0.0077033,0.0090566,0.0088885,0.0070186,0.0069554,0.0077145,0.0091003,0.0088857,0.0070198,0.0069287,0.007739,0.0090757,0.0088716,0.0069698,0.0069357,0.0076884,0.009066,0.0088867,0.0070021,0.0068965,0.0077248,0.0090794,0.0088738,0.0069753,0.0069176,0.0077182,0.0090683,0.008852,0.0069643,0.0069432,0.0077156,0.0090645,0.0088641,0.0069468,0.0069273,0.0077421,0.0090485,0.0088518,0.0069469,0.0069441,0.0077164,0.0090733,0.0088263,0.006943,0.006938,0.0077363,0.0090839,0.0088414,0.0069533,0.0069406,0.007763,0.0090729,0.0088256,0.0069441,0.0069408,0.0077693,0.0090808,0.0088283,0.0069195,0.0069383,0.0077543,0.0090765,0.0088279,0.0069407,0.0069383,0.0077886,0.0090678,0.0088222,0.0068895,0.0069427,0.0077969,0.0090543,0.0088156,0.0068982,0.0069249,0.0078146,0.0090949,0.0087837,0.0068813,0.0069456,0.0077948,0.0090921,0.0088028,0.0068805,0.0069384,0.0078308,0.0090959,0.0087648,0.0068737,0.006957,0.0078276,0.0090911,0.0087787,0.0068798,0.0069429,0.0078494,0.0090759,0.0087714,0.0068887,0.0069353,0.0078326,0.0090536,0.0087401,0.0068202,0.0069451,0.0078534,0.0090667,0.0087554,0.0068118,0.0069375,0.0078432,0.0090457,0.0087228,0.0068154,0.0069508,0.0078345,0.0090512,0.008723,0.0068135,0.0069557,0.0078243,0.0090461,0.0086886,0.0068328,0.0069492,0.0078523,0.0090693,0.0087119,0.0068016,0.0069426,0.0078583,0.0090372,0.0086833,0.0068162,0.0069333,0.0078752,0.0090353,0.0086699,0.0067901,0.0069764,0.0078871,0.0090476,0.0086924,0.0067795,0.0069558,0.0079147,0.0090732,0.008698,0.0067558,0.0069487,0.0078842,0.0090607,0.0087135,0.0067878,0.0069586,0.0079217,0.0090388,0.008661,0.0067664,0.0069698,0.0079151,0.0090339,0.008668,0.0067476,0.006374:4
1.8333E-7,-1.6333E-7,1.4E-6,-1.0067E-6,6.0333E-7,5.3333E-8,-8.9667E-7,1.7567E-6,1.7667E-7,7.9333E-7,5.5E-7,-4.6E-7,1.4233E-6,-1.0E-7,1.2467E-6,6.2E-7,-6.3333E-7,2.0167E-6,9.0E-8,1.5933E-6,1.4467E-6,-4.3333E-7,1.3E-7,-2.8333E-7,1.5067E-6,2.4333E-7,0.0022383,0.0044826,0.0069275,0.0069808,0.0065169,0.0058135,0.005097,0.0065869,0.0070682,0.0066367,0.0056678,0.0052265,0.006509,0.0070827,0.0066504,0.0056408,0.005226,0.0064507,0.0070621,0.0066726,0.0056307,0.0052266,0.0064387,0.007037,0.0066764,0.0056606,0.005214,0.0063924,0.0070229,0.006707,0.0056625,0.0051873,0.0063757,0.0070233,0.0066929,0.0056708,0.0051997,0.0063589,0.006999,0.0066874,0.0056937,0.0051754,0.0063144,0.0069721,0.0067142,0.0056887,0.005179,0.0062968,0.0069702,0.0067231,0.005703,0.0051636,0.0062701,0.0069488,0.0067313,0.0057246,0.0051475,0.0062492,0.0069594,0.0067409,0.0057148,0.0051567,0.0062227,0.006939,0.0067516,0.0057226,0.0051154,0.0062033,0.0069116,0.0067542,0.0057562,0.0051077,0.0061839,0.0068899,0.0067513,0.0056808,0.0050421,0.0060521,0.0067938,0.0066738,0.0056826,0.005032,0.0060339,0.0067607,0.0066988,0.0056862,0.0050048,0.0060225,0.0067481,0.0066979,0.0057045,0.0050199,0.0059995,0.0067204,0.0067074,0.0057273,0.0050126,0.0059665,0.0067207,0.0067078,0.0057555,0.0050046,0.0059813,0.0067234,0.0067194,0.0057823,0.0050006,0.0059158,0.006696,0.0067225,0.0057909,0.0050034,0.0059312,0.006694,0.0067323,0.0058211,0.0049923,0.0059012,0.0066811,0.0067705,0.0058285,0.004989,0.0058838,0.0066557,0.0067721,0.0058664,0.0050013,0.0058834,0.006658,0.0067717,0.0058643,0.0050018,0.0058648,0.0066358,0.0067817,0.0058831,0.0049856,0.0058355,0.0066238,0.0067967,0.0058961,0.005008,0.0058332,0.0066236,0.0068068,0.0059166,0.0050009,0.0058054,0.0066097,0.0068182,0.0059524,0.004984,0.0057791,0.0066109,0.0068181,0.0059562,0.0049775,0.0057535,0.006587,0.0068112,0.0059692,0.0050132,0.0057306,0.0065793,0.0068424,0.0059967,0.0049938,0.005739,0.0065567,0.006822,0.0060109,0.0049883,0.0057075,0.0065626,0.0068559,0.0060354,0.0050164,0.005684,0.0065463,0.0068505,0.0060456,0.0049912,0.0056498,0.0065052,0.0068647,0.0060617,0.0050128,0.0056529,0.0064926,0.0068852,0.0060821,0.0050147,0.0056413,0.0064817,0.0068844,0.0061165,0.0050131,0.005619,0.0064897,0.0068988,0.0061449,0.0050316,0.0056262,0.0064534,0.0069019,0.0061522,0.0050231,0.0055966,0.0064577,0.0069286,0.0061706,0.0050442,0.0055841,0.0064383,0.006922,0.0062021,0.0050424,0.0055672,0.0064351,0.006894,0.0062023,0.0050516,0.0055566,0.0064074,0.0069331,0.0062318,0.0050475,0.0055285,0.0063903,0.0069287,0.0062166,0.0050372,0.0055195,0.0063806,0.0069137,0.0062578,0.0050512,0.0054991,0.0063698,0.0069436,0.0062598,0.0050704,0.0054773,0.0063365,0.0069521,0.006296,0.005064,0.0054859,0.0063335,0.0069363,0.0063113,0.0050816,0.005461,0.0063121,0.0069487,0.0063145,0.0050784,0.0054416,0.006302,0.0069606,0.0063732,0.0050861,0.0054276,0.0062908,0.0069267,0.0063564,0.0050899,0.0054206,0.0062701,0.006943,0.0063772,0.0051159,0.0054059,0.006257,0.0069673,0.0064162,0.0051176,0.0053824,0.0062435,0.0069776,0.0064035,0.0051433,0.0054082,0.0062282,0.0069561,0.0064439,0.0051332,0.0053856,0.0062193,0.0069893,0.0064661,0.0051426,0.005358,0.006172,0.0069649,0.0064543,0.0051409,0.0053613,0.0061639,0.0069676,0.0064721,0.0051669,0.0053453,0.0061533,0.006948,0.006507,0.005163,0.0053063,0.0061578,0.0069899,0.0065166,0.005182,0.0053069,0.0061225,0.0069485,0.0065169,0.0052056,0.0053063,0.0060989,0.0069769,0.0065631,0.0052002,0.0053283,0.0060844,0.0069911,0.0065602,0.0052334,0.0052927,0.0060832,0.0069712,0.0065808,0.0052103,0.0052855,0.006063,0.0069776,0.0066057,0.0052363,0.0052776,0.006052,0.0069841,0.0066027,0.0052474,0.0052595,0.0060305,0.006985,0.0066466,0.0052886,0.0052444,0.0060107,0.0069609,0.003073:4
5.3333E-7,-4.2E-7,1.7333E-7,1.33E-6,-9.2E-7,1.5633E-6,-7.4333E-7,1.0167E-6,1.2167E-6,-3.6667E-8,5.2E-7,-1.5E-7,3.4E-7,4.7333E-7,-7.2333E-7,1.42E-6,1.3267E-6,5.4333E-7,2.3267E-6,-1.0733E-6,2.5067E-6,8.2333E-7,5.0333E-7,2.03E-6,-4.9667E-7,9.9E-7,-8.7333E-7,4.1E-7,1.17E-6,-5.3667E-7,9.9333E-7,9.3333E-7,2.6667E-7,1.2267E-6,-9.1E-7,2.05E-6,3.5333E-7,-2.3667E-7,1.59E-6,-4.6667E-7,6.4333E-7,3.0E-8,6.7667E-7,6.3667E-7,-9.6667E-7,2.5667E-7,1.18E-6,-8.0E-8,2.0833E-6,-3.3333E-7,1.26E-6,3.1E-7,3.5333E-7,1.3367E-6,-1.1E-6,1.27E-6,5.0E-8,9.4333E-7,1.2967E-6,-6.3333E-7,1.37E-6,-8.4667E-7,-1.6333E-7,1.3833E-6,-5.3333E-7,9.2333E-7,4.2667E-7,-2.2667E-7,1.28E-6,-4.8333E-7,1.2167E-6,-6.0E-8,3.6667E-8,-5.1667E-7,-7.8333E-7,8.8667E-7,2.0333E-7,2.0E-7,5.3333E-7,-9.5333E-7,7.1333E-7,6.2E-7,1.2667E-7,1.6633E-6,-1.4333E-7,5.3333E-7,1.2867E-6,3.0667E-7,1.1833E-6,-7.7667E-7,1.1E-6,4.6667E-8,-8.3333E-8,3.9333E-7,-2.1333E-7,1.57E-6,4.3667E-7,-1.6333E-7,2.5633E-6,-2.9E-7,2.13E-6,1.0767E-6,8.8E-7,1.26E-6,2.3333E-8,7.9E-7,5.3333E-7,6.3667E-7,1.17E-6,-1.3933E-6,1.5133E-6,1.12E-6,7.0E-7,8.8333E-7,-1.1733E-6,1.7E-7,-2.0E-8,1.1933E-6,1.0967E-6,-1.4867E-6,8.4E-7,-1.7667E-7,0.002235,0.0048979,0.0057124,0.0056934,0.0071721,0.0068397,0.0053257,0.005348,0.0058399,0.0069941,0.0067883,0.0054295,0.0052445,0.0058559,0.0069776,0.0067734,0.0054285,0.0052007,0.0058612,0.0069234,0.0067684,0.0054351,0.0051852,0.0058228,0.0069387,0.0067602,0.0054434,0.0051754,0.0058207,0.0069332,0.0067515,0.0054348,0.0051824,0.0058127,0.0069357,0.0067454,0.0054578,0.0051658,0.0058028,0.0069148,0.0067333,0.0054466,0.0051693,0.0057809,0.0069555,0.00684,0.0055416,0.0052554,0.0058787,0.0070473,0.0068979,0.0055621,0.0052408,0.0058753,0.0070513,0.0068957,0.0055426,0.0052623,0.0058865,0.0070259,0.0068875,0.0055678,0.0052461,0.0058421,0.0070001,0.0069038,0.0055581,0.0052354,0.0058363,0.0070164,0.0068707,0.005559,0.0052362,0.0058149,0.0070162,0.0068774,0.0055865,0.0052413,0.005799,0.0070069,0.0069041,0.0055985,0.0052178,0.0058051,0.0070162,0.0069257,0.0056057,0.0052436,0.0057887,0.0070077,0.0068842,0.0056319,0.0052299,0.0057958,0.0070022,0.0069149,0.0055994,0.0052082,0.0057794,0.0069687,0.0069029,0.0056177,0.0052281,0.0057626,0.0070641,0.0069808,0.0057007,0.0052809,0.0058258,0.0070399,0.0070011,0.0056882,0.0052869,0.0058025,0.0070525,0.0069994,0.0056892,0.0052646,0.0058081,0.0070593,0.0069986,0.0056967,0.0052878,0.0057898,0.0070187,0.0069996,0.0057074,0.0052566,0.0057573,0.0070387,0.0070243,0.0057305,0.0052744,0.0057707,0.0070189,0.0070103,0.0057469,0.0052629,0.0057619,0.0070125,0.00702,0.0057648,0.0052476,0.0057563,0.0070236,0.0070069,0.0057605,0.0052703,0.005753,0.0070145,0.0070202,0.0057446,0.0052714,0.0057373,0.0070071,0.0070253,0.0057752,0.0052798,0.0057049,0.0070033,0.0070312,0.0057743,0.0052606,0.0057149,0.0069986,0.0070437,0.0058022,0.0052903,0.0057188,0.0069946,0.0070439,0.0057844,0.0052546,0.0056882,0.0069945,0.0070249,0.0058108,0.0052606,0.0056834,0.0069898,0.0070161,0.0058175,0.0052676,0.0056724,0.0069743,0.0070391,0.0058513,0.0052487,0.0056564,0.0069751,0.0070293,0.0058321,0.0052517,0.0056661,0.0069473,0.0070557,0.0058553,0.0052612,0.0056529,0.0069343,0.0070489,0.0058649,0.0052712,0.0056421,0.0069422,0.0070438,0.0058694,0.0052651,0.0056344,0.0069516,0.0070364,0.0058678,0.0052589,0.005638,0.0069305,0.0070648,0.005894,0.0052745,0.0056237,0.0069292,0.007074,0.005903,0.005265,0.00559,0.0069319,0.0070655,0.0059053,0.0052718,0.0055897,0.0069163,0.0070555,0.0059237,0.0052602,0.0055907,0.0069141,0.0070637,0.0059292,0.0052706,0.0055886,0.0068992,0.0070549,0.0059456,0.0052846,0.0055781,0.0069132,0.0070645,0.005965,0.0052781,0.0055871,0.006912,0.0070866,0.0059505,0.0052701,0.0055595,0.0068846,0.0070768,0.0059728,0.0052847,0.0055682,0.0068878,0.00708,0.0059887,0.0052811,0.0055264,0.0068645,0.0070695,0.0060098,0.0052629,0.0055228,0.0068681,0.0070805,0.0060247,0.0052983,0.005525,0.0068778,0.0070766,0.0060005,0.0052952,0.0055179,0.0068544,0.0070755,0.006033,0.0052844,0.0055073,0.0068454,0.0070686,0.006044,0.0052876,0.005493,0.0068602,0.0070842,0.0060419,0.005286,0.0054839,0.0068576,0.0070692,0.006068,0.0053039,0.0054831,0.0068095,0.0070865,0.0060672,0.0052923,0.0054754,0.0068316,0.0070826,0.0060936,0.0053129,0.0054647,0.0067997,0.0070817,0.0060835,0.0052925,0.0054684,0.0068105,0.0070885,0.0061059,0.005316,0.0054536,0.0067947,0.007062,0.0061145,0.0053262,0.0054378,0.0067857,0.0071038,0.0061437,0.0053213,0.0054221,0.0067665,0.007073,0.0061424,0.0053166,0.0054203,0.0067938,0.0070877,0.006148,0.0053396,0.0054128,0.0067609,0.0070757,0.0061564,0.0053399,0.0054064,0.0067506,0.0070704,0.0061736,0.0053286,0.0054003,0.0067585,0.0070756,0.0061795,0.0053471,0.0054265,0.0067573,0.0070781,0.0062067,0.0053386,0.0053933,0.0067485,0.0071368,0.0062572,0.0053941,0.0054676,0.0067957,0.0071702,0.0063251,0.0054482,0.0054917,0.0068517,0.0072017,0.0063444,0.005451,0.0054648,0.006832,0.0071802,0.0063356,0.0054394,0.0054709,0.0068099,0.0072059,0.0063449,0.0054594,0.0054417,0.0068143,0.0071904,0.00637,0.0054462,0.0054372,0.0068181,0.0071843,0.006381,0.0054561,0.0054575,0.0067828,0.0071837,0.0063768,0.0054695,0.0054324,0.0067849,0.0071911,0.0064081,0.0054471,0.0054211,0.0067781,0.0071855,0.0064201,0.005475,0.0054208,0.0067809,0.007203,0.0064246,0.0054765,0.0054135,0.0067657,0.0072012,0.0064403,0.0054826,0.0053977,0.0067476,0.0071701,0.0064479,0.0054858,0.0054012,0.0067542,0.0071972,0.0064733,0.0054908,0.0054036,0.0067372,0.0071865,0.0064814,0.0055046,0.0053851,0.0067106,0.0071837,0.0064739,0.0055113,0.0053809,0.00671,0.0071828,0.0015676:4
7.5E-7,5.2667E-7,1.7367E-6,-5.1333E-7,5.3667E-7,5.5667E-7,-1.1667E-7,9.4667E-7,-6.8333E-7,3.3333E-7,-6.7667E-7,1.3267E-6,-3.0E-7,-3.6E-7,3.1667E-7,1.4633E-6,-4.5333E-7,6.6333E-7,-1.9733E-6,7.1E-7,1.4667E-7,1.2133E-6,6.4333E-7,-8.9667E-7,1.0767E-6,5.1E-7,2.9667E-7,3.3334E-9,-4.3333E-8,1.8367E-6,4.6667E-7,0.005331,0.005371,0.0056951,0.0062653,0.0073838,0.0069794,0.005547,0.0055687,0.0063112,0.0073647,0.0069819,0.0055657,0.0055099,0.0063169,0.007331,0.006982,0.0055695,0.005494,0.006315,0.007321,0.0069466,0.0055747,0.0054974,0.0062717,0.0073189,0.006959,0.00556,0.0055027,0.0062808,0.0073046,0.0069551,0.0055638,0.0054667,0.0062631,0.0073013,0.0069621,0.0055508,0.0054395,0.0062452,0.0072785,0.0069638,0.005556,0.0054668,0.0062296,0.0072536,0.0069438,0.005571,0.0054412,0.0062194,0.0072689,0.0069336,0.0055496,0.0054453,0.0062112,0.0072547,0.0069587,0.0055472,0.0054249,0.0061915,0.0072359,0.0069413,0.0055596,0.0054176,0.0061767,0.0072506,0.0069514,0.0055701,0.0054111,0.0061775,0.0072444,0.0069331,0.0055539,0.0054256,0.0061641,0.0072045,0.0069381,0.0055466,0.0053759,0.0061195,0.0071208,0.0068521,0.0054728,0.0053364,0.0060347,0.0071411,0.0068482,0.0054818,0.0053216,0.0060207,0.0070967,0.0068549,0.00548,0.0053001,0.0060119,0.0071208,0.0068566,0.0054925,0.0053193,0.0060117,0.0071034,0.0068542,0.005488,0.0053016,0.0060021,0.0071192,0.0068432,0.0055006,0.005295,0.0060051,0.0070994,0.0068635,0.0054942,0.0053066,0.0060011,0.0070997,0.0068663,0.0055251,0.0053029,0.0059882,0.0071024,0.0068762,0.0055273,0.0052993,0.0059757,0.0071134,0.0068724,0.0055103,0.0052941,0.0059657,0.00707,0.0068853,0.005512,0.0053056,0.0059594,0.0070737,0.006882,0.0055178,0.0053013,0.005939,0.0070793,0.0068902,0.0055332,0.0052848,0.005933,0.0070805,0.0068998,0.0055192,0.0052898,0.0059337,0.0070829,0.0068938,0.0055297,0.0052912,0.0059368,0.0070649,0.0069053,0.0055664,0.0052772,0.005933,0.0070867,0.0069045,0.0055762,0.0052857,0.0059329,0.0070456,0.0068995,0.0055475,0.0052712,0.0059135,0.0070703,0.0069169,0.0055663,0.0052878,0.0059176,0.0070791,0.0069057,0.0055746,0.0052814,0.0058977,0.0070673,0.0069293,0.0055734,0.0052705,0.0058927,0.0070548,0.0069124,0.0055661,0.0052844,0.0059049,0.0070514,0.0069183,0.0055758,0.005257,0.0059001,0.0070729,0.0069269,0.0055886,0.0052853,0.0058932,0.0070628,0.006924,0.0056029,0.0052816,0.0059086,0.0070756,0.0069331,0.0056088,0.005277,0.0058722,0.0070656,0.0069483,0.0056081,0.0052597,0.0058653,0.0070564,0.0069282,0.0056056,0.0052847,0.0058668,0.0070544,0.0069385,0.0056229,0.0052677,0.005829,0.0070463,0.0069368,0.0056255,0.005273,0.0058539,0.0070705,0.0069615,0.005646,0.0052928,0.0058417,0.007053,0.0069686,0.005646,0.0052705,0.0058398,0.0070499,0.0069541,0.0056548,0.0052567,0.0058141,0.0070383,0.0069794,0.0056654,0.0052689,0.0058356,0.0070358,0.0069872,0.0056655,0.0052691,0.0058113,0.0070478,0.0069583,0.0056663,0.0052627,0.0058096,0.0070243,0.0069908,0.005678,0.0052698,0.0058105,0.0070238,0.0069761,0.005672,0.0052702,0.0057998,0.0070282,0.0069776,0.0056839,0.0052686,0.0057926,0.0070333,0.0069999,0.0056982,0.0052758,0.0057681,0.0070231,0.0070045,0.0057326,0.0052613,0.0057858,0.007025,0.0069929,0.005711,0.0052658,0.0057754,0.0070306,0.0069797,0.0057261,0.0052533,0.0057977,0.0070341,0.0070011,0.0057379,0.0052495,0.0057455,0.0069967,0.0070262,0.0057398,0.0052413,0.005763,0.0070035,0.0070198,0.0057499,0.0052627,0.0057411,0.0070064,0.0069859,0.0057465,0.0052625,0.0057432,0.0070021,0.0070026,0.0057665,0.0052576,0.0057324,0.0070179,0.0070215,0.0057743,0.0052465,0.0057471,0.0070244,0.0070149,0.0057631,0.0052519,0.0057196,0.0069954,0.0070274,0.005768,0.0052523,0.0057211,0.0070143,0.0070294,0.0057659,0.0052525,0.0057214,0.0069922,0.0070122,0.0057827,0.0052568,0.0057179,0.0069865,0.0070238,0.0057975,0.0052281,0.0057154,0.0069699,0.0070163,0.0057821,0.005249,0.0057001,0.0069861,0.007035,0.0057994,0.0052477,0.0057196,0.0069753,0.0070271,0.0058088,0.0052705,0.0056815,0.0069649,0.0070328,0.005803,0.0052598,0.0056779,0.0069689,0.0070484,0.0058158,0.0052331,0.0056873,0.006956,0.0070271,0.0058237,0.0052519,0.0056739,0.0069454,0.0070418,0.0058267,0.0052698,0.005647,0.0069667,0.007015,0.0058352,0.0052576,0.0056767,0.0069432,0.0070422,0.0058574,0.0052822,0.0056459,0.0069619,0.0070307,0.0058366,0.0052564,0.0056341,0.0069447,0.0070588,0.005846,0.0052598,0.0056587,0.0069508,0.0070464,0.0058672,0.0052602,0.0056306,0.0069409,0.0070479,0.0058721,0.0052504,0.0056421,0.0069435,0.0070479,0.0058767,0.0052496,0.0056057,0.006943,0.0070447,0.0058852,0.0052634,0.0056176,0.0069256,0.0070489,0.0058991,0.0052537,0.0055911,0.0069152,0.0070513,0.0059051,0.005286,0.0056253,0.0069435,0.0070496,0.0059189,0.0052789,0.0055871,0.0069154,0.0070739,0.0059402,0.0052749,0.0056156,0.0070283,0.0071705,0.0060264,0.0053518,0.0057104,0.0070462,0.0071724,0.0060022,6.0974E-4:4
4.5967E-6,-2.3633E-6,8.4133E-6,2.4533E-6,1.1E-6,4.7533E-6,-2.1367E-6,9.5733E-6,3.8933E-6,2.8667E-7,8.23E-6,-1.3633E-6,6.87E-6,3.46E-6,2.66E-6,6.5733E-6,8.3E-7,5.3633E-6,1.54E-6,3.84E-6,5.3367E-6,-1.7267E-6,7.32E-6,-1.41E-6,3.1367E-6,5.6167E-6,-1.5067E-6,7.78E-6,-2.0133E-6,2.23E-6,5.9367E-6,-2.0833E-6,9.5067E-6,2.3233E-6,3.28E-6,4.1367E-6,0.004918,0.001637,0.0069427,0.0057764,0.0035772,0.0055852,0.0031027,0.0061524,0.0057419,0.0038824,0.0051084,0.0033723,0.00598,0.0057121,0.0039219,0.004986,0.0034092,0.005915,0.0056725,0.003904,0.0049431,0.003378,0.0058604,0.0056168,0.0038866,0.0049043,0.0033431,0.005828,0.0055802,0.0038599,0.0048782,0.0033148,0.0057883,0.0055359,0.0038387,0.0048515,0.0032811,0.0057611,0.0055116,0.0038034,0.0048277,0.0032502,0.0057172,0.0054737,0.0037743,0.0048024,0.0032271,0.0056985,0.0054371,0.0037685,0.0047846,0.0031948,0.0056642,0.0054101,0.0037459,0.0047612,0.0031723,0.0056445,0.0053665,0.0037312,0.0047441,0.0031414,0.0056062,0.005346,0.0037171,0.0047323,0.0031242,0.0056029,0.0053201,0.0037,0.0047135,0.0031059,0.0055576,0.0052986,0.0036972,0.0047082,0.0030851,0.0055587,0.0052738,0.0036878,0.004689,0.0030676,0.0055337,0.0052576,0.0036851,0.0046749,0.0030554,0.0055253,0.005234,0.0036804,0.0046658,0.0030427,0.0055087,0.0052262,0.0036821,0.004663,0.0030324,0.0055001,0.0051991,0.0036696,0.0046617,0.0030221,0.0054847,0.0051735,0.0036686,0.0046409,0.0030046,0.0054759,0.0051627,0.0036607,0.0046429,0.0029908,0.0054673,0.0051578,0.0036685,0.0046304,0.002984,0.0054678,0.0051461,0.003667,0.0046318,0.0029802,0.0054554,0.005137,0.0036766,0.0046347,0.0029729,0.0054461,0.0051267,0.0036747,0.0046341,0.0029663,0.0054419,0.0051193,0.0036827,0.004627,0.0029587,0.0054421,0.0051056,0.0036792,0.0046303,0.0029454,0.0054289,0.0051017,0.0036831,0.0046219,0.0029407,0.0054291,0.0050917,0.0036843,0.0046175,0.0029351,0.0054094,0.0050836,0.0036996,0.0046195,0.0029302,0.0054189,0.0050767,0.0036939,0.0046318,0.0029262,0.005423,0.0050719,0.0037097,0.0046307,0.0029185,0.0054178,0.0050554,0.0037128,0.0046293,0.0029185,0.005405,0.0050601,0.0037228,0.0046323,0.0029155,0.0054108,0.0050444,0.0037255,0.0046237,0.0029069,0.0054074,0.0050364,0.0037296,0.0046367,0.0029106,0.0054053,0.0050337,0.0037415,0.0046396,0.002905,0.0053979,0.0050289,0.0037512,0.0046378,0.0028979,0.0054043,0.0050146,0.003751,0.0046385,0.0028996,0.005394,0.005009,0.0037619,0.0046381,0.0028881,0.00539,0.0050027,0.0037657,0.0046522,0.002888,0.0053844,0.0050019,0.0037776,0.0046461,0.0028871,0.005384,0.0049942,0.0037778,0.0046525,0.0028798,0.0053741,0.0049853,0.0037898,0.00465,0.0028723,0.0053801,0.0049808,0.0037903,0.0046589,0.0028755,0.0053687,0.0049721,0.0038063,0.0046422,0.0028685,0.005368,0.0049612,0.0038095,0.0046585,0.0028648,0.0053627,0.0049468,0.0038216,0.0046596,0.0028566,0.0053667,0.0049491,0.0038256,0.0046639,0.0028651,0.0053601,0.0049375,0.0038402,0.0046651,0.0028563,0.0053588,0.0049363,0.003841,0.0046717,0.0028543,0.0053525,0.004929,0.00386,0.0046712,0.0028499,0.0053506,0.0049263,0.0038569,0.0046771,0.0028483,0.0053404,0.0049113,0.0038697,0.0046684,0.002843,0.0053544,0.0048971,0.0038748,0.0046826,0.002836,0.0053452,0.0048969,0.0038856,0.0046793,0.0028371,0.0053392,0.0048856,0.003897,0.00469,0.0028318,0.0053292,0.0048778,0.0039034,0.004684,0.0028255,0.005333,0.0048746,0.0039105,0.0046992,0.0028258,0.0053286,0.0048679,0.0039284,0.0047,0.002822,0.0053313,0.0048592,0.0039344,0.0046998,0.0028226,0.0053114,0.0048518:4
-2.89E-6,1.5233E-6,5.3467E-6,-3.5333E-7,8.4133E-6,2.9167E-6,7.88E-6,8.91E-6,-9.3333E-7,4.93E-6,1.1233E-6,4.8833E-6,4.9667E-6,-2.5333E-7,6.1967E-6,7.3333E-7,8.3633E-6,5.6567E-6,-1.0333E-7,6.1033E-6,1.9133E-6,6.2167E-6,7.7367E-6,2.0733E-6,5.7333E-6,5.7E-7,7.3333E-6,5.9333E-6,-4.1E-7,4.9433E-6,4.9E-7,5.1067E-6,2.2233E-6,9.6667E-7,4.8833E-6,2.5433E-6,3.7733E-6,4.49E-6,0.0082515,0.00185,0.00774,0.0054935,0.0055359,0.0066992,0.0032761,0.006753,0.0057422,0.0056181,0.0063356,0.0035539,0.0065212,0.0057742,0.0055946,0.0062306,0.0035835,0.0064313,0.0057462,0.0055606,0.0061549,0.0035571,0.0064005,0.0056942,0.0055158,0.0061285,0.0035272,0.0063545,0.005665,0.0054666,0.0060916,0.0034954,0.0063055,0.005609,0.0054471,0.006071,0.0034718,0.0062675,0.005581,0.00541,0.0060258,0.0034342,0.006243,0.0055305,0.0053849,0.0060082,0.0034076,0.006201,0.005503,0.0053625,0.0059781,0.0033915,0.0061742,0.0054627,0.0053295,0.0059681,0.0033669,0.0061396,0.0054305,0.0053154,0.0059228,0.0033417,0.0061054,0.0054054,0.0052865,0.0059253,0.0033165,0.006088,0.005382,0.0052749,0.0058991,0.0033081,0.0060652,0.0053618,0.005256,0.0058929,0.0032846,0.0060414,0.0053218,0.0052425,0.005854,0.0032656,0.006028,0.0053123,0.0052239,0.0058649,0.0032553,0.0060037,0.0052869,0.0052164,0.0058417,0.0032434,0.005991,0.0052644,0.0052086,0.005844,0.0032312,0.0059717,0.0052521,0.0052008,0.0058262,0.0032234,0.0059616,0.0052232,0.0051936,0.0058186,0.0032164,0.0059443,0.0052195,0.0051912,0.0058059,0.003205,0.0059315,0.0052059,0.0051727,0.0058116,0.0032055,0.0059162,0.0051924,0.0051785,0.0058011,0.0031933,0.0059142,0.0051714,0.0051703,0.0058049,0.0031848,0.0058955,0.0051654,0.0051729,0.0057861,0.0031718,0.0058929,0.0051525,0.0051736,0.0057893,0.0031723,0.0058759,0.00514,0.0051672,0.0057817,0.0031647,0.0058771,0.0051324,0.0051669,0.005798,0.0031696,0.0058718,0.0051292,0.00518,0.0057837,0.0031658,0.0058621,0.0051209,0.0051663,0.0057975,0.0031624,0.0058452,0.0051179,0.0051669,0.0057875,0.003156,0.0058508,0.005089,0.0051664,0.0057857,0.0031514,0.0058285,0.0050935,0.0051633,0.0057885,0.0031485,0.0058394,0.0050799,0.0051793,0.0057891,0.0031431,0.0058236,0.0050806,0.0051885,0.0057841,0.0031509,0.0058224,0.0050623,0.0051907,0.0057973,0.0031477,0.0058197,0.0050569,0.0052001,0.0057935,0.0031438,0.0058173,0.0050447,0.0051864,0.0057956,0.0031374,0.0057963,0.0050439,0.0051937,0.0057814,0.0031378,0.0057978,0.0050342,0.0052057,0.0057991,0.0031381,0.005787,0.0050269,0.0052096,0.0057952,0.0031429,0.0057985,0.0050241,0.0052172,0.005803,0.003139,0.0057773,0.0050195,0.0052197,0.0058097,0.0031393,0.0057955,0.0050278,0.0052289,0.0058235,0.0031419,0.0057917,0.0050281,0.0052309,0.0058137,0.0031433,0.0057955,0.0050161,0.0052353,0.0058252,0.0031445,0.0057805,0.0050099,0.0052502,0.0058193,0.0031411,0.0057841,0.0050106,0.0052463,0.0058366,0.0031385,0.0057731,0.0049986,0.0052602,0.005829,0.0031414,0.0057799,0.0049837,0.0052574,0.0058469,0.0031417,0.0057604,0.0049935,0.0052731,0.0058389,0.0031416,0.005773,0.0049878,0.0052703,0.005849,0.0031431,0.0057566,0.0049842,0.0052821,0.0058488,0.0031444,0.0057601,0.0049764,0.0052756,0.005862,0.0031412,0.0057637,0.0049753,0.0052953,0.0058464,0.0031412,0.0057526,0.0049593,0.0052968,0.0058626,0.0031409,0.0057499,0.0049616,0.0053008,0.0058585,0.0031423,0.0057515,0.0049475,0.0053006,0.0058697,0.003138,0.0057368,0.0049469,0.0053041,0.0058586,0.0031413,0.0057346,0.0049447,0.0052999,0.00587,0.0031401,0.0057285,0.0049378,0.0053144,0.0058664,0.003141:4
-0.022812,0.024599,0.0015928,-0.0039341,0.016951,-0.023688,0.020926,0.0022118,-0.0027938,0.01949,-0.02106,0.023687,-1.5115E-4,-0.0041982,0.022994,-0.024804,0.026779,-0.0040755,-0.0057863,0.013728,-0.021199,0.026676,-0.0089909,0.0033816,0.018385,-0.023523,0.023058,-0.0028733,-5.4148E-4,0.01878,-0.0245,0.02993,-0.0064021,-0.0063999,27.56,49.969,73.195,74.337,78.843,71.268,55.605,69.305,75.58,79.032,70.156,56.708,68.267,75.785,79.012,69.888,56.91,67.774,75.585,78.92,69.716,56.808,67.527,75.403,78.746,69.642,56.697,67.245,75.18,78.706,69.625,56.626,67.11,74.986,78.637,69.633,56.534,66.869,74.8,78.617,69.617,56.487,66.763,74.652,78.523,69.695,56.451,66.612,74.563,78.571,69.723,56.397,66.509,74.4,78.564,69.803,56.409,66.386,74.323,78.605,69.868,56.366,66.302,74.196,78.643,69.985,56.389,66.19,74.09,78.668,70.025,56.331,66.05,73.995,78.67,70.144,56.362,65.987,73.861,78.711,70.183,56.364,65.884,73.762,78.683,70.279,56.368,65.645,73.612,78.677,70.286,56.313,65.552,73.522,78.672,70.304,56.263,65.456,73.374,78.626,70.427,56.292,65.377,73.242,78.676,70.492,56.285,65.2,73.159,78.615,70.552,56.253,65.217,73.047,78.623,70.665,56.359,65.132,72.965,78.71,70.708,56.33,65.056,72.891,78.749,70.777,56.328,64.908,72.746,78.777,70.887,56.348,64.846,72.714,78.819,70.988,56.393,64.707,72.552,78.897,71.075,56.378,64.74,72.456,78.83,71.264,56.424,64.517,72.36,78.895,71.259,56.447,64.479,72.272,78.902,71.388,56.488,64.353,72.181,78.982,71.509,56.472,64.34,72.067,78.962,71.65,56.523,64.17,71.909,78.896,71.585,56.466,64.103,71.802,78.934,71.76,56.536,63.908,71.721,79.086,71.835,56.577,63.903,71.624,79.016,71.971,56.633,63.872,71.582,79.103,72.025,56.661,63.842,71.469,79.115,72.146,56.68,63.629,71.27,79.151,72.26,56.713,63.542,71.213,79.078,72.374,56.748,63.457,71.108,79.113,72.428,56.778,63.421,71.019,79.167,72.487,56.831,63.32,70.966,79.314,72.628,56.873,63.3,70.927,79.213,72.695,56.89,63.21,70.736,79.21,72.753,56.902,63.072,70.596,79.214,72.863,56.933,62.95,70.483,79.232,72.903,56.943,62.953,70.441,79.15,73.07,57.022,62.901,70.29,79.217,73.096,57.051,62.764,70.215,79.247,73.241,57.135,62.721,70.141,79.26,73.448,57.201,62.712,70.102,79.313,73.538,57.283,62.669,70.025,79.434,73.58,57.32,62.553,69.904,79.435,73.712,57.373,62.489,69.757,79.391,73.679,57.363,62.413,69.659,79.283,73.836,57.41,62.344,69.566,79.35,73.921,57.428,62.245,69.462,79.309,74.061,57.529,62.167,69.354,79.268,74.061,57.549,62.186,69.27,79.357,74.186,57.603,62.038,69.17,79.344,74.296,57.673,62.041,69.093,79.352,74.403,57.735,61.965,69.07,79.382,74.472,57.816,62.004,68.957,79.399,74.574,57.883,61.946,68.868,79.406,74.645,57.897,61.86,68.77,79.372,74.779,57.971,61.722,68.661,79.368,74.841,57.995,61.788,68.585,79.371,74.899,58.073,61.632,68.499,79.413,74.997,58.111,61.581,68.37,79.315,75.109,58.187,61.572,68.306,79.383,75.209,58.238,61.515,68.178,79.36,75.246,58.332,61.381,68.042,79.357,75.283,58.341,61.396,67.969,79.259,75.396,58.432,61.308,67.875,79.27,75.428,58.493,61.307,67.779,79.281,75.593,58.569,61.186,67.686,79.32,75.653,58.599,61.159,67.61,79.329,75.771,58.681,61.12,67.491,79.232,75.846,58.741,61.036,67.381,79.262,75.946,58.825,60.98,67.279,79.184,75.945,58.861,60.937,67.123,79.123,76.007,58.855,60.888,67.039,41.176:4
0.014722,0.012308,-0.014686,0.023668,-0.021152,0.0077411,0.0073026,-0.017182,0.023414,-0.016255,0.012974,0.0032623,-0.016245,0.020053,-0.014079,0.0094587,0.0090974,-0.02472,0.026362,-0.016214,0.011379,0.011609,-0.017992,0.021068,-0.017986,0.015777,0.010105,-0.017602,0.025141,-0.015365,0.014461,0.0071505,-0.020508,0.026884,-0.011579,0.014463,0.0068352,-0.014573,0.026925,-0.016797,0.015949,0.016357,-0.017708,0.02817,-0.018603,0.0076121,0.01152,-0.01535,0.028433,-0.014784,0.011071,0.0050119,-0.020508,0.022775,-0.01007,0.0083696,0.022246,-0.012536,0.023944,-0.019032,0.013419,0.01497,-0.012574,0.027966,-0.019601,0.014566,0.0012104,-0.014368,0.025627,-0.011999,0.012943,0.011521,-0.014745,0.024707,-0.01435,0.0108,0.0081965,-0.017389,0.029954,-0.016346,0.010727,0.0064013,-0.015951,0.029397,-0.015649,0.014761,0.0061529,-0.011017,0.023939,-0.014555,0.016699,0.0075843,-0.018935,0.027142,-0.013719,0.011548,0.0071659,-0.016352,0.025746,-0.012671,0.0096948,0.0042531,-0.014243,0.021755,-0.01357,0.017079,-5.0163E-4,-0.012318,0.021605,-0.015718,0.014898,0.0080241,-0.01926,0.022601,-0.01757,0.010778,0.0076018,-0.022722,0.017476,-0.015021,0.011935,0.0092152,-0.016213,0.022662,-0.01159,0.016207,0.0071146,-0.017457,0.021326,-0.0098298,0.020388,0.012519,-0.019135,0.024391,-0.019131,0.014781,0.012707,-0.018379,0.01841,-0.021154,0.014997,0.012513,-0.018987,0.026038,-0.015617,0.024557,0.0016147,-0.0064296,0.024841,-0.01805,0.013652,0.0078722,-0.017295,0.01743,-0.021675,0.015457,0.011563,-0.015592,0.024773,-0.013049,0.016405,0.0067956,-0.01453,0.021553,-0.016497,0.015522,0.0085633,-0.016977,0.022561,-0.017335,0.016515,0.012283,-0.020105,0.024129,-0.019038,0.019997,0.0078281,-0.013632,0.029721,50.231,82.433,81.03,65.726,65.11,58.882,78.608,80.96,67.688,62.582,60.608,77.539,80.869,68.152,61.851,60.898,77.066,80.744,68.305,61.633,60.846,76.86,80.635,68.302,61.522,60.671,76.554,80.462,68.25,61.357,60.456,76.321,80.188,68.249,61.32,60.209,76.126,80.14,68.247,61.273,60.125,75.98,80.079,68.324,61.278,59.956,75.839,79.987,68.371,61.258,59.872,75.719,79.921,68.422,61.271,59.694,75.597,79.871,68.505,61.238,59.625,75.449,79.745,68.544,61.254,59.439,75.278,79.696,68.58,61.253,59.347,75.204,79.662,68.733,61.252,59.237,75.074,79.627,68.833,61.316,59.208,74.961,79.544,68.975,61.383,59.109,74.859,79.564,69.001,61.366,59.029,74.769,79.573,69.101,61.487,58.938,74.654,79.504,69.274,61.407,58.845,74.631,79.366,69.309,61.536,58.753,74.553,79.36,69.401,61.577,58.675,74.396,79.386,69.487,61.627,58.587,74.332,79.31,69.56,61.557,58.501,74.208,79.242,69.672,61.664,58.419,74.106,79.188,69.737,61.585,58.321,74.018,79.099,69.818,61.708,58.322,73.877,79.128,69.924,61.705,58.239,73.791,79.007,70.065,61.81,58.166,73.723,79.056,70.154,61.812,58.126,73.652,79.017,70.213,61.867,58.034,73.59,78.985,70.346,61.89,57.951,73.509,78.913,70.377,61.962,57.865,73.351,78.861,70.498,62.003,57.813,73.386,78.788,70.614,62.035,57.76,73.266,78.75,70.718,62.066,57.717,73.203,78.758,70.841,62.178,57.683,73.052,78.817,70.915,62.197,57.619,73.045,78.67,70.985,62.284,57.6,72.876,78.631,71.131,62.326,57.507,72.807,78.536,71.204,62.387,57.423,72.651,78.482,71.329,62.438,57.41,72.638,78.53,71.402,62.513,57.354,72.523,78.45,71.535,62.577,57.295,72.495,78.409,71.698,62.724,57.249,72.442,78.376,71.767,62.654,57.206,72.348,78.429,71.953,62.789,57.139,72.252,78.437,72.057,62.882,57.165,72.181,78.411,72.145,63.07,57.111,72.083,78.3,72.188,62.939,57.001,71.963,78.129,72.289,63.085,56.955,71.848,78.148,72.374,63.17,56.912,71.86,78.107,72.501,63.223,56.891,71.701,78.117,72.591,63.253,56.824,71.629,77.992,72.692,63.402,56.807,71.687,77.948,72.812,63.421,56.763:4
7.4973E-4,0.014294,-0.022845,0.022384,-0.0044289,-0.0039385,0.023636,-0.018269,0.026518,-0.0045031,2.9711E-4,0.019082,-0.02157,0.019787,0.0015152,-4.4157E-4,0.023943,-0.013906,0.031652,-0.0019162,6.668E-4,0.015642,-0.017938,0.022224,0.0029618,-0.0078648,0.018181,-0.014403,0.021454,-6.6236E-5,-0.0021741,0.010719,-0.0159,0.021584,0.0013489,4.8131E-4,0.022569,-0.023639,0.022771,-0.0057916,0.0021161,0.015238,-0.02357,0.026861,-0.0089842,-0.0060989,0.018449,-0.023094,0.028115,-0.007481,-0.0019153,0.021181,-0.020366,0.017359,-0.0085217,0.0016267,0.013697,-0.01695,0.020518,0.0085559,-0.0027146,0.01998,-0.012365,0.023454,-0.0055312,-0.0015425,0.010665,-0.015051,0.023014,-3.4362E-4,0.003096,0.017745,-0.017136,0.024291,-0.0032415,0.002242,0.013747,-0.026695,0.026444,-0.013717,-0.001266,0.010847,-0.025119,0.012513,-0.0072969,-8.6751E-4,0.023473,-0.018468,0.019093,-0.0034249,0.004616,0.017987,-0.018032,0.029329,-0.0081969,-0.0029235,0.010921,-0.021194,0.023586,-0.011724,-5.2156E-4,0.016564,-0.023474,0.019814,-0.0043205,7.2169E-4,0.012631,-0.018906,0.021891,-0.0034073,-0.00604,0.022724,-0.018656,0.027522,-0.0035033,-0.0023821,0.019056,-0.020451,0.025684,-0.0017781,-0.0051032,0.01755,-0.017892,0.01987,-2.3517E-4,7.7625E-4,0.020153,-0.021345,0.02381,-0.01041,-0.0014596,0.012645,22.768,72.559,73.417,79.624,72.272,55.717,68.554,74.913,79.646,71.149,56.844,67.479,75.111,79.501,70.762,56.977,67.039,74.899,79.378,70.578,56.922,66.845,74.732,79.252,70.492,56.802,66.57,74.532,79.085,70.423,56.728,66.487,74.4,79.024,70.422,56.677,66.308,74.263,79.014,70.378,56.618,66.239,74.119,78.945,70.383,56.544,66.066,74.035,78.839,70.347,56.517,65.974,73.916,78.817,70.366,56.437,65.852,73.78,78.784,70.328,56.389,65.723,73.646,78.666,70.34,56.374,65.58,73.535,78.703,70.378,56.347,65.629,73.496,78.72,70.495,56.365,65.549,73.424,78.767,70.441,56.306,65.495,73.325,78.696,70.581,56.339,65.469,73.341,78.8,70.581,56.37,65.415,73.279,78.738,70.575,56.349,65.273,73.137,78.737,70.614,56.312,65.184,73.023,78.664,70.623,56.296,65.126,72.971,78.665,70.555,56.243,65.065,72.886,78.607,70.702,56.246,64.936,72.798,78.669,70.658,56.269,64.972,72.761,78.647,70.721,56.255,64.824,72.713,78.666,70.745,56.272,64.757,72.587,78.599,70.866,56.241,64.648,72.533,78.649,70.791,56.226,64.647,72.462,78.597,70.871,56.206,64.61,72.435,78.669,70.906,56.263,64.519,72.338,78.642,70.995,56.26,64.512,72.321,78.77,71.025,56.312,64.496,72.255,78.798,71.172,56.331,64.401,72.22,78.787,71.219,56.364,64.381,72.157,78.823,71.313,56.407,64.404,72.194,78.824,71.221,56.361,64.243,71.987,78.714,71.321,56.336,64.089,71.952,78.783,71.314,56.36,64.104,71.901,78.844,71.585,56.431,64.132,71.893,78.859,71.537,56.466,64.168,71.775,78.908,71.626,56.483,64.091,71.777,78.955,71.591,56.487,63.997,71.671,78.915,71.702,56.499,63.906,71.626,79.017,71.757,56.502,63.925,71.585,78.985,71.805,56.513,63.929,71.503,78.932,71.826,56.527,63.758,71.366,78.894,71.907,56.526,63.631,71.321,78.874,71.844,56.531,63.567,71.279,78.924,72.025,56.539,63.5,71.266,78.903,71.971,56.553,63.533,71.222,78.975,72.141,56.606,63.484,71.206,78.984,72.256,56.682,63.506,71.134,79.022,72.281,56.656,63.419,71.036,79.062,72.269,56.669,63.373,70.958,78.916,72.351,56.631,63.296,70.909,78.969,72.311,56.682,63.224,70.838,78.92,72.369,56.706,63.187,70.737,79.023,72.508,56.733,63.072,70.711,79.008,72.535,56.758,63.065,70.651,79.022,72.646,56.788,63.057,70.621,79.148,72.772,56.873,63.039,70.621,79.175,72.706,56.856,62.987,70.513,79.062,72.867,56.908,62.885,70.427,79.147,72.954,56.935,62.858,70.348,79.13,72.981,56.966,62.909,70.322:4
0.002406,0.0010751,-0.0024622,0.0028193,-0.0019422,0.0036141,-1.0793E-5,-0.002003,0.0031977,-0.0015948,9.3697E-4,0.0024072,-8.9807E-4,0.0013809,-0.0027363,6.3628E-4,0.0019285,-0.0015606,0.0023044,-0.0017433,0.0025171,-1.7567E-4,2.4084E-4,17.045,4.3525,16.237,13.718,26.222,16.705,23.454,23.515,26.673,24.112,18.482,21.506,24.022,26.359,23.391,18.895,20.846,24.066,26.191,23.083,18.98,20.579,24.042,26.06,22.909,18.97,20.434,24.009,25.98,22.839,18.958,20.371,24.002,25.912,22.799,18.931,20.337,23.996,25.877,22.78,18.913,20.332,23.991,25.846,22.774,18.904,20.344,23.98,25.849,22.766,18.89,20.353,23.972,25.852,22.754,18.879,20.364,23.946,25.874,22.738,18.88,20.37,23.951,25.887,22.723,18.882,20.379,23.945,25.913,22.726,18.904,20.395,23.986,25.94,22.707,18.914,20.392,24.005,25.93,22.711,18.918,20.388,24.02,25.913,22.711,18.908,20.374,24.033,25.895,22.711,18.901,20.386,24.042,25.872,22.714,18.903,20.395,24.046,25.88,22.713,18.897,20.408,24.052,25.889,22.711,18.892,20.422,24.049,25.894,22.706,18.896,20.424,24.041,25.905,22.698,18.901,20.441,24.054,25.923,22.699,18.841,20.437,23.982,25.902,22.685,18.834,20.435,23.984,25.895,22.687,18.83,20.43,23.982,25.893,22.671,18.825,20.43,23.989,25.897,22.667,18.821,20.427,23.978,25.876,22.65,18.821,20.425,23.982,25.874,22.639,18.815,20.426,23.989,25.865,22.635,18.819,20.43,24.005,25.859,22.619,18.812,20.426,24.024,25.862,22.635,18.823,20.431,24.036,25.843,22.635,18.809,20.44,24.049,25.843,22.627,18.805,20.449,24.051,25.844,22.637,18.797,20.472,24.057,25.871,22.639,18.803,20.489,24.049,25.877,22.634,18.804,20.508,24.048,25.886,22.621,18.803,20.514,24.039,25.907,22.61,18.812,20.516,24.045,25.916,22.588,18.808,20.51,24.035,25.901,22.557,18.806,20.492,24.049,25.897,22.55,18.812,20.495,24.073,25.895,22.56,18.826,20.492,24.109,25.882,22.563,18.818,20.496,24.119,25.858,22.567,18.818,20.508,24.139,25.847,22.571,18.801,20.514,24.143,25.843,22.576,18.801,20.537,24.137,25.852,22.584,18.801,20.556,24.126,25.865,22.575,18.8,20.57,24.112,25.89,22.564,18.805,20.583,24.12,25.913,22.556,18.818,20.595,24.13,25.936,22.537,18.821,20.588,24.141,25.93,22.543,18.831,20.587,24.166,25.938,22.542,18.839,20.579,24.197,25.909,22.535,18.83,20.579,24.209,25.9,22.539,18.824,20.571,24.204,25.887,22.54,18.811,20.59,24.212,25.876,22.547,18.813,20.611,24.206,25.875,22.536,18.801,20.617,24.182,25.874,22.524,18.792,20.62,24.211,25.9,22.524,18.813,20.663,24.196,25.925,22.509,18.815,20.661,24.208,25.933,22.487,18.813,20.653,24.22,25.938,22.481,18.825,20.657,24.237,25.937,22.485,18.827,20.67,24.263,25.92,22.471,18.82,20.668,24.276,25.906,22.468,18.819,20.678,24.28,25.907,22.465,18.812,20.684,24.27,25.898,22.455,18.812,20.689,24.289,25.905,22.456,18.818,20.705,24.291,25.899,22.445,18.813,20.712,24.301,25.901,22.444,18.806,20.706,24.285,25.88,22.427,18.795,20.704,24.299,25.881,22.413,18.789,20.71,24.295,25.881,22.421,18.795,20.723,24.306,25.882,22.407,18.785,20.725,24.296,25.879,22.391,18.778,20.733,24.292,25.891,22.389,18.781,20.734,24.282,25.9,22.372,18.787,20.737,24.289,25.888,22.358,18.787,20.734,24.294,25.878,22.351,18.79,20.729,24.31,25.87,22.341,18.794,20.721:4
0.0032129,0.0060159,1.1318E-4,0.0037232,0.0034013,7.2493E-4,0.0030919,-0.0012241,0.0042676,0.0018069,7.702E-4,0.0047729,5.3669E-4,0.0056647,0.0049387,0.0019687,0.0047572,-8.344E-4,0.0044245,0.0021828,0.0018696,0.0041647,7.8109E-4,0.0035449,0.0021548,-1.0536E-4,0.0042896,-6.2561E-4,0.0043982,0.0019375,0.0023727,0.0051366,-2.5966E-4,0.0035352,0.0025235,0.0015945,0.022505,0.70588,17.368,12.031,9.5292,14.002,23.958,21.062,26.595,25.084,18.442,20.798,22.262,25.93,24.281,19.055,19.902,22.538,25.663,23.951,19.172,19.556,22.578,25.487,23.785,19.161,19.388,22.533,25.363,23.685,19.111,19.32,22.504,25.318,23.625,19.081,19.314,22.5,25.309,23.593,19.06,19.306,22.476,25.286,23.555,19.03,19.299,22.458,25.292,23.533,19.029,19.309,22.491,25.328,23.501,19.014,19.317,22.502,25.325,23.487,19.019,19.303,22.503,25.312,23.465,19.007,19.297,22.524,25.314,23.464,19.006,19.323,22.573,25.314,23.477,19.005,19.327,22.561,25.271,23.445,18.977,19.323,22.568,25.286,23.441,18.967,19.351,22.586,25.317,23.429,18.966,19.37,22.589,25.342,23.419,18.964,19.374,22.586,25.337,23.395,18.959,19.38,22.633,25.414,23.41,18.993,19.439,22.676,25.423,23.412,18.993,19.423,22.681,25.396,23.396,18.981,19.434,22.728,25.408,23.394,18.977,19.454,22.762,25.414,23.397,18.991,19.471,22.784,25.422,23.397,18.983,19.485,22.793,25.426,23.388,18.977,19.511,22.825,25.464,23.382,18.981,19.533,22.827,25.459,23.363,18.971,19.529,22.832,25.466,23.347,18.964,19.548,22.864,25.484,23.325,18.964,19.566,22.892,25.491,23.322,18.961,19.574,22.899,25.488,23.323,18.95,19.58,22.919,25.496,23.32,18.94,19.618,22.959,25.514,23.31,18.953,19.623,22.949,25.51,23.281,18.932,19.615,22.955,25.525,23.272,18.938,19.642,22.989,25.544,23.261,18.941,19.658,23.006,25.544,23.24,18.939,19.641,22.991,25.523,23.221,18.926,19.641,23.022,25.539,23.207,18.925,19.661,23.053,25.534,23.209,18.918,19.656,23.042,25.507,23.203,18.905,19.662,23.072,25.536,23.201,18.904,19.697,23.093,25.538,23.19,18.903,19.706,23.074,25.543,23.168,18.884,19.697,23.069,25.53,23.151,18.877,19.708,23.087,25.55,23.14,18.881,19.724,23.098,25.548,23.136,18.874,19.711,23.092,25.54,23.121,18.876,19.733,23.139,25.577,23.114,18.877,19.75,23.153,25.575,23.094,18.874,19.748,23.135,25.556,23.085,18.859,19.745,23.15,25.573,23.082,18.862,19.768,23.191,25.587,23.072,18.873,19.782,23.19,25.577,23.046,18.85,19.764,23.177,25.559,23.036,18.845,19.789,23.211,25.58,23.02,18.849,19.794,23.218,25.588,23.011,18.851,19.8,23.217,25.581,23.012,18.844,19.801,23.246,25.589,22.997,18.837,19.822,23.27,25.593,22.997,18.838,19.817,23.254,25.552,22.978,18.817,19.817,23.279,25.563,22.978,18.82,19.849,23.31,25.574,23.04,18.818,19.886,23.358,25.612,23.033,18.82,19.887,23.356,25.602,23.014,18.81,19.896,23.358,25.623,22.997,18.814,19.913,23.383,25.643,22.991,18.823,19.907,23.371,25.624,22.974,18.811,19.908,23.395,25.631,22.968,18.813,19.934,23.434,25.644,22.962,18.816,19.937,23.444,25.615,22.955,18.796,19.924,23.443,25.601,22.946,18.795,19.944,23.476,25.62,22.934,18.788,19.968,23.476,25.623,22.933,18.78,19.955,23.442,25.602,22.9,18.769,19.971,23.464,25.638,22.891,18.776,19.988,23.48,25.65,22.882,18.785,19.994,23.481,25.652,22.863,18.78,19.988,23.48,25.651,22.856,18.779,20.01,23.518,25.667,22.847,18.787,20.012,23.516,25.641,22.835,18.767,19.993,12.23:4
1.8633E-6,4.6E-7,1.9633E-6,1.6E-7,1.4233E-6,1.5167E-6,6.9333E-7,1.5567E-6,7.2333E-7,1.79E-6,1.5767E-6,5.9E-7,1.2567E-6,1.4667E-7,1.05E-6,8.4667E-7,-4.1667E-7,2.1E-6,-9.3333E-8,1.9433E-6,1.6533E-6,9.8333E-7,2.4033E-6,6.2667E-7,2.7167E-6,1.4533E-6,-9.3667E-7,1.5833E-6,-4.6333E-7,1.4267E-6,1.44E-6,-3.3667E-7,1.4467E-6,2.3667E-7,2.8067E-6,1.5E-6,-5.1667E-7,1.5333E-6,-5.2E-7,2.2333E-6,1.7267E-6,2.0667E-7,2.6667E-6,5.5667E-7,1.73E-6,2.42E-6,-5.2333E-7,1.6067E-6,3.5E-7,2.3133E-6,1.7367E-6,3.1333E-7,1.7767E-6,4.3667E-7,2.14E-6,2.1167E-6,-1.2667E-7,1.78E-6,-3.8E-7,2.1833E-6,1.6167E-6,5.5667E-7,2.1E-6,-1.5333E-7,2.2633E-6,2.2767E-6,8.1E-7,2.2933E-6,1.0833E-6,2.21E-6,1.6667E-6,-2.3E-7,1.1933E-6,5.2333E-7,1.3967E-6,1.62E-6,-2.1E-7,1.7833E-6,4.7E-7,2.13E-6,1.58E-6,7.4667E-7,2.1667E-6,-1.0667E-7,1.7433E-6,2.02E-6,9.7667E-7,2.1267E-6,7.2333E-7,1.9E-6,1.1867E-6,-5.5667E-7,2.0733E-6,-5.8333E-7,2.13E-6,1.1533E-6,-9.9333E-7,1.8067E-6,-1.6E-7,2.3033E-6,1.58E-6,-3.1667E-7,1.8933E-6,1.3E-7,1.8167E-6,1.9467E-6,-8.0E-8,0.006172,0.005848,0.0074112,0.0079443,0.0075182,0.0063021,0.005977,0.0073082,0.0079462,0.0075362,0.0062548,0.0059788,0.0072423,0.0079394,0.0075401,0.0062669,0.0059794,0.0072241,0.0079569,0.0075405,0.0062887,0.0059529,0.0071666,0.00791,0.0075796,0.0063108,0.0059548,0.0071339,0.0079145,0.0075483,0.0063115,0.0059353,0.007116,0.0078533,0.0075709,0.0063167,0.0059073,0.0070263,0.0078617,0.0075812,0.0063666,0.0058935,0.007024,0.0078391,0.0076074,0.0063747,0.0058812,0.007005,0.0078173,0.0076263,0.0063734,0.0058434,0.0069627,0.0077957,0.0076052,0.0063693,0.0058622,0.0069025,0.0078039,0.0076164,0.0064182,0.005848,0.0068746,0.0077878,0.007629,0.006448,0.0058474,0.0068344,0.0078074,0.007673,0.0064845,0.0058294,0.0068163,0.0078127,0.0076587,0.0064914,0.005815,0.0067937,0.0077479,0.0076564,0.0064958,0.0058433,0.0067977,0.0077478,0.0076851,0.0065112,0.0058346,0.0067695,0.007709,0.0077391,0.0065668,0.005792,0.006725,0.0077148,0.0077254,0.0065563,0.0057918,0.0066997,0.0077135,0.007725,0.0065798,0.0058097,0.0066574,0.0076844,0.0077347,0.0066251,0.0058054,0.0066272,0.0076837,0.0077326,0.0066379,0.005777,0.0066273,0.0076686,0.007757,0.0066799,0.0057765,0.0065914,0.0076453,0.0077757,0.0067134,0.005806,0.0065671,0.007621,0.0077731,0.0067411,0.0057902,0.0065427,0.0076156,0.0078132,0.0067753,0.0057721,0.0065062,0.0075973,0.0077819,0.0067897,0.0057755,0.0064733,0.007543,0.0078414,0.0068133,0.0057849,0.0064393,0.0075393,0.0078209,0.0068447,0.0057951,0.0064423,0.0075432,0.0078139,0.0068599,0.0057853,0.0064176,0.0075336,0.0078203,0.0069041,0.0057975,0.0063889,0.0074893,0.0078517,0.0069342,0.0057964,0.0063855,0.0075023,0.007858,0.0069536,0.0058083,0.0063702,0.007458,0.0078578,0.0069929,0.0057958,0.0063365,0.0074535,0.0078515,0.0070167,0.0058111,0.0062901,0.0074217,0.0078848,0.0070168,0.005829,0.0062805,0.0073947,0.0078796,0.0070329,0.0058156,0.0062581,0.0073742,0.0078917,0.0070765,0.0058341,0.0062623,0.0073568,0.0078971,0.0071159,0.0058578,0.0062384,0.0073289,0.0079228,0.007134,0.0058589,0.0062088,0.0073194,0.0078916,0.0071556,0.0058745,0.0061684,0.0072993,0.0078906,0.0071827,0.0058635,0.0061829,0.0072612,0.0078947,0.0071933,0.0058899,0.0061393,0.0072353,0.00789,0.007252,0.0058952,0.0061188,0.0072097,0.0079167,0.0072542,0.0059062,0.0061295,0.0071638,0.0079421,0.007305,0.0059077,0.0061181,0.0071643,0.0079541,0.0073052,0.0059176,0.0060831,0.0071501,0.0079408,0.0072982,0.0059423,0.0060897,0.0071139,0.0079304,0.0073926,0.0059403,0.0060698,0.0070789,0.0079283,0.0073744,0.0059466,0.0060397,0.007063,0.0079413,0.0074037,0.0059773,0.0060124,0.0070518,0.0079021,0.0074003,0.0059949,0.0060067,0.0070166,0.0079435,0.0074416,0.0060103,0.005986,0.0070214,0.0079337,0.0074535,0.0060133,0.0059886,0.0069946,0.007932,0.0074571,0.0060453,0.0059887,0.0069382,0.0079287,0.0075119,0.0060571,0.006004:4
1.6533E-6,-5.4667E-7,2.0133E-6,5.1E-7,1.7233E-6,1.66E-6,1.4333E-7,1.1533E-6,-1.6E-7,1.8867E-6,1.3933E-6,-7.4667E-7,2.0533E-6,5.0E-7,1.4267E-6,7.0E-7,-6.5E-7,1.6067E-6,9.5667E-7,1.76E-6,2.0067E-6,-1.8E-7,1.66E-6,2.0E-8,1.2367E-6,1.3767E-6,-1.4667E-7,1.7033E-6,-3.9667E-7,1.5067E-6,7.4E-7,-5.6E-7,1.5233E-6,-1.9333E-7,2.3333E-6,1.53E-6,1.6333E-7,1.5567E-6,3.1E-7,1.9667E-6,9.3E-7,4.7E-7,1.5E-6,4.0333E-7,2.11E-6,9.0667E-7,-1.5667E-7,1.6667E-6,-1.8E-7,2.0767E-6,1.3733E-6,6.0333E-7,1.6467E-6,1.1667E-7,2.3467E-6,1.8867E-6,2.1E-7,1.34E-6,6.4333E-7,1.7233E-6,1.7833E-6,-8.3333E-8,1.2567E-6,-7.1667E-7,2.78E-6,1.2933E-6,-6.9333E-7,1.6E-6,-3.2333E-7,1.3733E-6,8.8333E-7,-9.2667E-7,1.2333E-6,3.0333E-7,2.0E-6,1.87E-6,1.8667E-7,1.3667E-6,1.3333E-7,1.6433E-6,1.8967E-6,-6.3333E-8,1.5133E-6,1.7333E-7,1.38E-6,1.6633E-6,1.34E-6,1.6967E-6,5.3333E-7,1.48E-6,1.4633E-6,2.7667E-7,1.7867E-6,2.7E-7,1.65E-6,7.4333E-7,-1.8667E-7,1.09E-6,7.7E-7,1.3267E-6,9.6333E-7,2.1333E-7,1.35E-6,-4.6333E-7,1.1367E-6,1.3333E-7,1.9333E-7,1.3133E-6,-1.5E-7,2.6467E-6,5.9E-7,-3.3334E-9,1.6567E-6,-1.0333E-7,1.7367E-6,1.2767E-6,-2.3E-7,1.75E-6,8.2333E-7,2.3467E-6,1.4567E-6,1.1333E-7,1.9167E-6,-5.8E-7,2.4033E-6,3.8E-7,1.1067E-6,1.82E-6,6.6667E-8,1.7733E-6,8.4E-7,-5.1E-7,3.5706E-4,0.0049812,0.0079159,0.0078868,0.0072738,0.0064393,0.0058263,0.0075358,0.0079919,0.0074264,0.0062827,0.0059931,0.0074231,0.007965,0.0074602,0.0062319,0.0060354,0.0073649,0.0079684,0.0074768,0.0061988,0.0060045,0.0073463,0.0079691,0.0074796,0.0061908,0.0059641,0.0072744,0.0079249,0.0074892,0.0062137,0.0059804,0.0072552,0.0079319,0.0074666,0.0062289,0.0059498,0.0072128,0.0078923,0.0075049,0.0062479,0.0059534,0.0071801,0.0078887,0.0074714,0.0062354,0.0059275,0.0071569,0.0079062,0.0075101,0.0062704,0.0059399,0.0071583,0.007877,0.0075115,0.0062607,0.0059055,0.007114,0.0078755,0.0075363,0.0062896,0.0059035,0.0070891,0.0078556,0.0075208,0.0063148,0.0059015,0.0070868,0.0078485,0.0075508,0.0063247,0.0058707,0.0070483,0.0078421,0.0075536,0.0063266,0.0058673,0.0070107,0.0078386,0.0075392,0.0063309,0.0058732,0.0070235,0.0078274,0.0075887,0.0063527,0.0058469,0.0069775,0.0078431,0.0075914,0.0063704,0.0058635,0.0069661,0.0078561,0.0076019,0.0063828,0.005859,0.0069553,0.007838,0.0076023,0.006407,0.0058542,0.0068995,0.0078141,0.0076392,0.0064318,0.0058286,0.0068777,0.0078021,0.007641,0.0064344,0.0058229,0.006874,0.0077844,0.0076415,0.0064449,0.0058285,0.0068728,0.0077426,0.0076764,0.0064523,0.0058291,0.0068578,0.0077422,0.0076679,0.0064623,0.0058238,0.0068332,0.0077553,0.0076987,0.0064994,0.0058158,0.0068326,0.0077549,0.0076985,0.0065212,0.0057967,0.0067755,0.0077396,0.0077107,0.0065373,0.0058054,0.0067576,0.0077118,0.0076955,0.0065562,0.0057879,0.0067285,0.0077248,0.007721,0.006588,0.0057951,0.0067034,0.0077426,0.0077332,0.0065745,0.005809,0.0066984,0.0077373,0.0077031,0.0066092,0.0057977,0.0066751,0.0077005,0.0077419,0.0066272,0.005786,0.0066614,0.0076858,0.007765,0.0066368,0.0057658,0.0066738,0.0076811,0.0077858,0.0066744,0.0057554,0.00666,0.0076704,0.007736,0.0066563,0.0057672,0.006619,0.0076381,0.0077691,0.0066723,0.0057763,0.0066155,0.0076311,0.0077935,0.006721,0.0057784,0.0065894,0.0076224,0.00781,0.0067189,0.0057763,0.0065377,0.0076061,0.0077756,0.0067227,0.005788,0.0065293,0.0075954,0.0077658,0.0067547,0.0057607,0.0065351,0.0076118,0.0078052,0.0067888,0.0057889,0.0065134,0.0075949,0.0078057,0.0068084,0.0057849,0.0064849,0.007584,0.0078086,0.0067973,0.0058041,0.0064825,0.0075521,0.007846,0.0068248,0.0057851,0.0064637,0.0075432,0.0077956,0.0068386,0.0058027,0.0064284,0.0075311,0.00786,0.0068717,0.005788,0.0064291,0.0075283,0.0078324,0.0068841,0.0057805,0.0064071,0.0074977,0.0078493,0.0068965,0.0058059,0.0064101,0.0074887,0.0078615,0.0069382,0.0058087,0.0064074,0.0074869,0.0078815,0.0069305,0.0057911,0.0063654,0.0074736,0.007873,0.0069655,0.0058035,0.0063592,0.00746,0.0079034,0.006975,0.0058151,0.0063597,0.0074694,0.0078813,0.0070027,0.0057968,0.0063674,0.0074349,0.0078773,0.0070334,0.0058225,0.0063241,0.0074371,0.0079138,0.0070317,0.0058182,0.0063281,0.0074034,0.0078734,0.0070844,0.0058131,0.0063135,0.0074106,0.0079159,0.0070829,0.0058163,0.0062896,0.0073968,0.0078735,0.0071008,0.0058223,0.0062871,0.0073829,0.007911,0.0071561,0.0058419,0.0062904,0.0073711,0.0079246,0.0071527,0.0058456,0.0062765,0.0073652,0.007941,0.0071565,0.0058648,0.0062337,0.0073055,0.0079543,0.00718,0.0058682,0.0062322,0.0072963,0.0079088,0.0071741,0.0058667,0.0062085,0.0073125,0.0079359,0.0072298,0.0058784,0.0061802,0.0072718,0.0079252,0.007234,0.005883,0.0061676,0.0072424,0.0079001,0.0072163,0.005873,0.0061504,0.0072317,0.0079204,0.0072579,0.0058965,0.0061614,0.0072169,0.0079442,0.0072855,0.0058901,0.0061693,0.0072127,0.0079397,0.0072877,0.0058919,0.0061342,0.0071847,0.0079059,0.0073248,0.0058964,0.0061152,0.0071498,0.0079337,0.0073321,5.4153E-4:4
2.3567E-6,1.4733E-6,-3.5667E-7,1.5367E-6,7.1667E-7,1.6367E-6,2.4967E-6,-4.2667E-7,1.95E-6,5.6E-7,1.5867E-6,1.4633E-6,-1.3333E-8,1.8367E-6,1.36E-6,1.9233E-6,1.4467E-6,-6.9667E-7,2.4933E-6,1.0267E-6,7.6667E-7,2.2067E-6,-7.1333E-7,1.99E-6,3.5333E-7,1.5033E-6,1.39E-6,4.0E-8,1.7433E-6,1.3E-6,1.9267E-6,1.5867E-6,-9.4333E-7,1.4067E-6,3.9667E-7,2.07E-6,1.13E-6,0.0039661,0.0066886,0.0059785,0.0081554,0.0080107,0.006568,0.006118,0.006351,0.0079673,0.0079891,0.0067089,0.0059883,0.0064149,0.0079286,0.0079397,0.0067345,0.0059581,0.0064437,0.0078873,0.0079403,0.0067576,0.005907,0.0064089,0.0078667,0.0079284,0.0067375,0.0059262,0.0063989,0.0078633,0.0079263,0.0067652,0.0058939,0.0063556,0.0078279,0.0079274,0.0067642,0.0059101,0.0063317,0.0077966,0.0079219,0.0067558,0.0058937,0.0063307,0.007791,0.0079165,0.0067498,0.005894,0.006311,0.0077925,0.0079122,0.0067648,0.0059139,0.0063165,0.0077921,0.0079115,0.0067603,0.0059157,0.006288,0.0077749,0.0079024,0.0067633,0.0058911,0.0062721,0.0077846,0.0079,0.0067828,0.0059183,0.0062494,0.0077434,0.0079131,0.0068176,0.0059158,0.006244,0.0077353,0.0078694,0.0067984,0.0058861,0.0062278,0.0077395,0.0078891,0.0068366,0.005875,0.0061963,0.0077039,0.0078963,0.0068367,0.0058973,0.0062299,0.0076956,0.0079154,0.0068581,0.0059021,0.0062122,0.0076663,0.0078835,0.0068789,0.0058935,0.0061881,0.0076773,0.0079135,0.0068777,0.0059065,0.0061942,0.0076646,0.0079268,0.0068907,0.00591,0.0061751,0.0076471,0.0079012,0.0068918,0.0059128,0.0061497,0.0076534,0.0078996,0.006913,0.0059302,0.0061634,0.0076152,0.0078963,0.0069048,0.0059126,0.0061452,0.0076052,0.0079076,0.0069434,0.0059233,0.0061321,0.0075644,0.0078852,0.0069637,0.0059124,0.0061278,0.0075967,0.0078853,0.0069684,0.0059205,0.0061055,0.007565,0.0079143,0.0069858,0.0059106,0.006096,0.0075872,0.0078782,0.0069925,0.0059196,0.0060893,0.0075372,0.0078988,0.0070116,0.0059231,0.0060665,0.0075695,0.0079065,0.0070023,0.0059292,0.0060905,0.0075357,0.0078582,0.0070321,0.0059136,0.0060299,0.0075095,0.0078569,0.0070132,0.0059418,0.0060362,0.0074805,0.0078763,0.0070622,0.0059415,0.0060296,0.0074962,0.0079075,0.0070588,0.0059599,0.0060544,0.0074787,0.0078696,0.0070724,0.0059525,0.0060161,0.0074659,0.0078428,0.0070763,0.0059359,0.0060084,0.0074365,0.0078248,0.0070645,0.0059545,0.0060241,0.0074326,0.0078357,0.007122,0.0059649,0.0059944,0.0073936,0.0078483,0.0071245,0.0059717,0.006006,0.0073927,0.0078427,0.0071369,0.0059905,0.0059694,0.0073739,0.007845,0.0071477,0.0059983,0.0059511,0.0073644,0.0078593,0.007157,0.0060077,0.0059601,0.007376,0.0078612,0.0071634,0.0060045,0.0059434,0.0073617,0.0078456,0.0071866,0.0060257,0.0059595,0.0073398,0.0078589,0.0071813,0.0060262,0.005941,0.0073509,0.0078424,0.0072227,0.0060539,0.0059345,0.0073107,0.0078561,0.0072449,0.0060538,0.0059434,0.0073269,0.0078485,0.0072543,0.0060546,0.005928,0.0073021,0.0078607,0.0072621,0.0060701,0.0059145,0.0072925,0.0078314,0.0072535,0.0060761,0.0059233,0.0072542,0.0078386,0.0072786,0.0061003,0.0059186,0.0072548,0.0078358,0.0073003,0.0060892,0.0058979,0.0072571,0.0078715,0.0073132,0.0060943,0.0058987,0.0072174,0.0078416,0.0073132,0.0061339,0.0058802,0.0072328,0.0078629,0.0073322,0.0061238,0.0059011,0.0072014,0.0078331,0.007361,0.0061487,0.0058774,0.0072197,0.0078251,0.0073832,0.0061431,0.0058642,0.0071692,0.0078355,0.0073744,0.0061259,0.0058601,0.007152,0.0078409,0.0073792,0.0061398,0.0058612,0.0071553,0.0078352,0.0073936,0.0061748,0.0058488,0.0071026,0.0078228,0.0074065,0.0061812,0.005861,0.0071227,0.0077989,0.007405,0.0062116,0.0058502,0.0071214,0.0078157,0.007444,0.0062157,0.0058569,0.0070705,0.0078296,0.0074354,0.0062328,0.0058685,0.0070656,0.0078041,0.0074569,0.0062204,0.0058309,0.0070593,0.0078249,0.0074772,0.0062657,0.0058529,0.0070484,0.0078169,0.0074872,0.0062291,0.0058391,0.0070355,0.0078003,0.0074871,0.0062759,0.0058277,0.0070033,0.0077921,0.0075239,0.0062928,0.0058331,0.0070184,0.007784,0.0075079,0.0062802,0.0058205,0.006982,0.0077936,0.0075379,0.0062908,0.0058544:4
-1.1E-7,1.0533E-6,2.1933E-6,-1.0967E-6,1.8733E-6,-5.5333E-7,1.0733E-6,6.6E-7,-1.1667E-6,1.7733E-6,5.7E-7,1.3567E-6,1.2333E-6,-6.8333E-7,2.0133E-6,-2.8333E-7,1.2E-6,1.2467E-6,-1.4E-6,2.2767E-6,9.6667E-8,9.6E-7,2.7033E-6,-1.7667E-7,1.9967E-6,1.4E-7,1.4033E-6,1.26E-6,5.3333E-7,2.4467E-6,-3.4667E-7,0.0032629,0.007782,0.0063174,0.0060733,0.0071565,0.008108,0.0077109,0.0065437,0.0058765,0.0076284,0.0091264,0.0086442,0.0073756,0.0065609,0.008173,0.0090403,0.0086143,0.0073791,0.0065319,0.0081239,0.0090072,0.0085901,0.0073496,0.0064964,0.0080845,0.0090064,0.0085591,0.007358,0.0064804,0.0080716,0.0089588,0.0085459,0.007327,0.0064436,0.0080403,0.0089354,0.0085054,0.0073118,0.0064097,0.0080121,0.0089276,0.0084823,0.0072866,0.0064288,0.007986,0.0088965,0.0085163,0.0072975,0.0063999,0.0079717,0.0088801,0.0084772,0.00727,0.0064022,0.0079838,0.0088608,0.0084911,0.0072836,0.0064068,0.007943,0.0088455,0.008484,0.0072735,0.0063768,0.0079511,0.0088669,0.0084677,0.0073042,0.0063874,0.007931,0.008839,0.0085175,0.0072707,0.0063597,0.0079363,0.0088394,0.0084976,0.0072815,0.0063898,0.0079292,0.0088506,0.0084777,0.0072785,0.0063716,0.0079353,0.0088359,0.0084774,0.007281,0.0063729,0.0079157,0.0088319,0.0085058,0.0073037,0.0063662,0.0079074,0.0088337,0.0085129,0.0072915,0.0063731,0.0078837,0.0088125,0.0085133,0.0072837,0.0063664,0.0078899,0.0088265,0.0085089,0.0072999,0.0063717,0.0078907,0.0088469,0.0084996,0.0072964,0.0063498,0.0079002,0.0088333,0.0084975,0.0072992,0.0063428,0.0078698,0.0088152,0.0085024,0.0072824,0.0063575,0.0078771,0.008798,0.0085314,0.0072989,0.0063547,0.0078912,0.0087826,0.0085093,0.0073039,0.0063559,0.0078629,0.0088108,0.008504,0.0073133,0.0063477,0.0078497,0.0088121,0.0085327,0.0073217,0.0063398,0.0078854,0.0088095,0.008531,0.007288,0.0063459,0.0078498,0.0087979,0.0085241,0.0073106,0.0063294,0.0078439,0.0088113,0.0085167,0.0073296,0.0063645,0.0078467,0.0087929,0.0085339,0.0073201,0.0063272,0.007836,0.008802,0.008497,0.0073491,0.0063059,0.0078481,0.0087879,0.0085213,0.0073148,0.0063141,0.0078166,0.0087598,0.0085261,0.0073015,0.00631,0.0077945,0.008788,0.0085212,0.0073418,0.006331,0.0078143,0.0087731,0.0085396,0.0073284,0.0063342,0.0078422,0.0087982,0.0085358,0.0073105,0.0063493,0.0077974,0.0087677,0.008503,0.0073425,0.006317,0.0078109,0.0087632,0.0085444,0.0073432,0.0063091,0.0078159,0.0087594,0.0085541,0.0073361,0.0063099,0.0078242,0.0087643,0.0085412,0.0073238,0.0063179,0.0078032,0.0087625,0.0085422,0.0073476,0.0062989,0.0077757,0.0087598,0.0085674,0.0073205,0.0063187,0.0077818,0.0087788,0.0085279,0.0073418,0.0063117,0.0078021,0.0087779,0.0085554,0.0073419,0.0063329,0.0077778,0.0087705,0.0085587,0.0073517,0.0063143,0.0077866,0.0087286,0.0085807,0.0073496,0.0063078,0.0077641,0.008756,0.0085541,0.0073689,0.006326,0.0077668,0.0087435,0.0085576,0.0073539,0.0063165,0.0077612,0.0087353,0.0085701,0.0073589,0.0062793,0.007749,0.0087621,0.0085773,0.0073932,0.0063319,0.007759,0.0087399,0.0085917,0.0073655,0.0063061,0.0077488,0.0087367,0.0086135,0.0073652,0.006304,0.0077713,0.0087459,0.0085869,0.0073925,0.0063057,0.0077732,0.0087253,0.0085769,7.7144E-4:4
-6.3333E-8,1.3467E-6,1.9067E-6,3.8667E-7,1.74E-6,-1.1333E-7,1.63E-6,1.4967E-6,-6.8667E-7,1.7167E-6,3.0667E-7,2.16E-6,1.99E-6,8.0E-8,2.0933E-6,3.2667E-7,1.8133E-6,1.1033E-6,-1.02E-6,2.0833E-6,4.7E-7,1.3067E-6,1.29E-6,4.0E-7,1.8967E-6,0.0020236,0.0074397,0.0081394,0.0073881,0.0056936,0.0073958,0.0085845,0.0091474,0.0082452,0.0065178,0.0074373,0.0085496,0.0091044,0.0082022,0.0065142,0.0073893,0.0085042,0.0090683,0.0081222,0.0064695,0.0073779,0.0084468,0.00902,0.0081331,0.006457,0.00734,0.0084201,0.0090118,0.0081145,0.0064316,0.0073466,0.0084174,0.0089672,0.0080862,0.0064169,0.0072913,0.008373,0.0089651,0.0080385,0.0063974,0.0072909,0.0083846,0.0089489,0.0080491,0.00639,0.0072616,0.0083424,0.008939,0.0080603,0.0063864,0.0072434,0.0083313,0.0089245,0.0080317,0.0063893,0.007272,0.0083172,0.0089158,0.0080427,0.0063812,0.0072416,0.0083343,0.0089243,0.008045,0.0063464,0.0072537,0.0083098,0.0089132,0.0080515,0.0063699,0.0072278,0.0082861,0.0089132,0.008064,0.0063787,0.0072412,0.0083165,0.0088959,0.0080149,0.0063721,0.0072158,0.008296,0.0088995,0.0080413,0.0063652,0.0072331,0.0082791,0.0089174,0.0080553,0.0063507,0.0072172,0.0082728,0.0088952,0.0080142,0.0063772,0.0071682,0.0082372,0.008857,0.0080312,0.006359,0.0071979,0.0082605,0.008882,0.0080093,0.0063665,0.0072182,0.0082543,0.0088997,0.008027,0.0063692,0.0071753,0.0082589,0.0088979,0.0080361,0.0063393,0.00722,0.0082643,0.0088787,0.0080725,0.006368,0.0071861,0.0082665,0.0088762,0.0080103,0.0063663,0.0071909,0.0082365,0.0088689,0.0080513,0.0063578,0.0071859,0.0082395,0.008866,0.0080298,0.0063624,0.0071766,0.0082548,0.008864,0.0080626,0.006361,0.0071981,0.0082429,0.0088951,0.0080571,0.0063683,0.0071481,0.0082261,0.0088883,0.0080416,0.0063609,0.007179,0.0082418,0.0088956,0.0080439,0.0063683,0.0071796,0.0082381,0.0088917,0.0080623,0.0063745,0.0071858,0.0082303,0.008874,0.0080706,0.0063698,0.0071852,0.008231,0.0088764,0.0081023,0.0063675,0.0071646,0.008233,0.0088861,0.0080686,0.0063643,0.0071598,0.0082216,0.0088969,0.0080538,0.0063625,0.0071627,0.0082207,0.0088837,0.0080794,0.0063673,0.0071716,0.0082413,0.0089118,0.0080542,0.0063925,0.0071686,0.0082214,0.0089007,0.0080787,0.0063578,0.0071527,0.0082112,0.008875,0.0080995,0.0063663,0.0071608,0.0082038,0.0088847,0.0080919,0.0063492,0.0071661,0.0081771,0.0089061,0.0080876,0.0063696,0.0071398,0.0082009,0.0088924,0.008078,0.0063701,0.0071106,0.0082158,0.0088808,0.0080806,0.0063674,0.0071332,0.0082149,0.0088939,0.0080977,0.0063704,0.0071546,0.0081984,0.0088905,0.0081064,0.0063701,0.0071248,0.0081965,0.0088905,0.0080926,0.0063839,0.0071486,0.0081751,0.0089029,0.0081103,0.0063779,0.0071538,0.0081792,0.0088879,0.0080879,0.0063816,0.0071367,0.0081779,0.0089061,0.0081262,0.0063737,0.0071136,0.0081763,0.0088592,0.0080963,0.0063792,0.0071211,0.0081836,0.0088806,0.0080845,0.0063876,0.007121,0.0057715:4
-3.6667E-7,-2.3333E-8,-2.0467E-6,4.8506E-14,-1.8033E-6,-1.0767E-6,-3.5333E-7,-2.3233E-6,-2.5E-7,-2.9433E-6,-1.8233E-6,-9.1667E-7,-1.6767E-6,7.1E-7,-1.29E-6,-2.3E-7,-9.5333E-7,-2.58E-6,-1.1267E-6,-1.6533E-6,-9.8667E-7,-5.0333E-7,-1.7067E-6,6.1E-7,-1.4933E-6,-1.41E-6,-9.2E-7,-2.4467E-6,1.1967E-6,-3.31E-6,4.1333E-7,-8.3333E-7,-2.5567E-6,1.3667E-7,-1.69E-6,-4.5333E-7,-3.1667E-7,-1.7367E-6,2.7667E-7,-2.0433E-6,-6.6667E-8,-1.2133E-6,-1.9333E-6,3.3667E-7,-2.0067E-6,3.8E-7,-1.2933E-6,-2.3333E-6,7.5333E-7,-3.0233E-6,8.3333E-8,-1.19E-6,-1.8367E-6,-1.4333E-7,-1.02E-6,-2.0333E-7,-1.07E-6,-2.5E-6,-2.1E-7,-1.7167E-6,3.9E-7,-2.9333E-7,-1.79E-6,4.5E-7,-2.3867E-6,4.9E-7,-1.67E-6,-2.7033E-6,0.0063172,0.0017265,0.0076693,0.0062285,0.004177,0.0062599,0.0034186,0.0069044,0.0063589,0.004621,0.0057196,0.0038786,0.0066802,0.0063501,0.0047551,0.0055988,0.0039892,0.0066125,0.0063326,0.004789,0.0055403,0.004017,0.0066005,0.0063267,0.0048254,0.0055321,0.0040253,0.0065903,0.0063009,0.0048466,0.0055271,0.0039909,0.0065411,0.0062928,0.0048549,0.0055156,0.0040008,0.0065242,0.0062716,0.0048426,0.0055173,0.0039786,0.0065327,0.0062328,0.0048574,0.0055375,0.0039746,0.0065122,0.0062506,0.0048636,0.0055158,0.0039677,0.0065136,0.0062252,0.0048546,0.0055329,0.0039522,0.006493,0.0062133,0.0048764,0.0055381,0.0039409,0.0065094,0.0061968,0.0048865,0.005531,0.0039337,0.0065086,0.0061835,0.0049062,0.0055295,0.0039105,0.0064585,0.006179,0.0048952,0.0055286,0.0039084,0.0064545,0.0061467,0.0049132,0.005541,0.0039025,0.0064351,0.0061399,0.0049061,0.00554,0.0038894,0.0064412,0.0061031,0.0049348,0.005545,0.0038783,0.0064229,0.0061039,0.0049538,0.0055388,0.0038717,0.0064077,0.0060825,0.0049527,0.005538,0.0038541,0.006406,0.0060867,0.0049692,0.0055307,0.0038604,0.0064092,0.0060639,0.0049867,0.005547,0.0038524,0.0064057,0.0060586,0.0049819,0.0055516,0.0038474,0.0064049,0.0060479,0.0050093,0.0055745,0.0038426,0.0064051,0.0060312,0.0050187,0.0055765,0.003858,0.0063756,0.006021,0.0050422,0.0055895,0.0038303,0.0063885,0.0060077,0.0050485,0.0055803,0.0038247,0.006372,0.0060114,0.0050543,0.0055974,0.0038278,0.0063722,0.0059758,0.0050905,0.0056274,0.0038171,0.0063709,0.0059856,0.0051149,0.0056052,0.0038222,0.0063333,0.0059806,0.0051042,0.0056209,0.0038224,0.0063455,0.0059603,0.0051327,0.0056276,0.0038088,0.0063369,0.0059366,0.0051496,0.0056423,0.0038244,0.0063294,0.0059579,0.0051731,0.0056266,0.0038074,0.0063223,0.0059317,0.0051669,0.0056491,0.0038043,0.0063205,0.0058981,0.005197,0.0056609,0.003795,0.0063098,0.0058922,0.0051939,0.005675,0.003786,0.0062946,0.0058717,0.0052183,0.0056867,0.0037956,0.0062903,0.0058581,0.0052333,0.0056815,0.0037913,0.0062826,0.0058823,0.005236,0.0056886,0.0037731,0.0062789,0.0058622,0.0052435,0.00571,0.0037783,0.0062787,0.0058477,0.0052802,0.005711,0.0037597,0.0062473,0.0058228,0.0052683,0.0057261,0.003766,0.0062522,0.0058151,0.0053057,0.0057181,0.0037676,0.0062509,0.0058088,0.0052976,0.005753,0.0037732,0.0062413,0.0058035,0.0053291,0.0057537,0.003752,0.0062122,0.0057863,0.0053323,0.0057509,0.0037586,0.006221,0.0057835,0.0053534,0.0057539,0.0037635,0.006198,0.0057557,0.0053634,0.0057828,0.003756,0.0061992,0.0057658,0.0053629,0.0057814,0.0037464,0.0061847,0.0057394,0.0053776,0.0057678,0.0037443,0.0061874,0.0057125,0.0053921,0.0058023,0.003752,0.0061826,0.0057201,0.0054072,0.0057861,0.0037507,0.0061804,0.0057019,0.0054093,0.005819,0.0037427,0.0061516,0.0056761,0.0054379,0.005814,0.00374,0.006151,0.0056724,0.0054449,0.0058146,0.0037342,0.0061373,0.0056505,0.0054503,0.0058176,0.0037172,0.0061076,0.0056619,0.0054546,0.0058402,0.0037332,0.0061053,0.0056302,0.0054838,0.0058211,0.0037136,0.006095,0.0056331,0.0054843,0.0058729,0.0037223,0.0061006,0.0056271,0.0055074,0.0058692,0.003741,0.0060694,0.0056173,0.0055313,0.0058881,0.0037215,0.0060962,0.0055897,0.005538,0.0058833,0.0037252,0.0060918,0.005584,0.0055463,0.0059237,0.0037229,0.0060735,0.0055734,0.0055593,0.005925,0.0037293,0.0060563,0.0055619,0.0055932,0.0059329,0.003727,0.0060378,0.0055556,0.0055791,0.0059365,0.0037028,0.0060281,0.0055335,0.0055906,0.0059416,0.0037167,0.0060396,0.0055454,0.0055917,0.0059324,0.0037095,0.0060179,0.0029267:4
-1.0733E-6,-4.9667E-7,1.6467E-6,-1.5067E-6,-4.7333E-7,1.3333E-8,-2.65E-6,9.6667E-7,-8.0333E-7,-5.9667E-7,-1.4667E-7,-2.1767E-6,-1.4E-7,-9.6E-7,-2.4667E-7,-2.3E-7,-2.0533E-6,2.8333E-7,-5.4333E-7,-5.2E-7,8.9333E-7,-1.8067E-6,1.03E-6,-5.1E-7,-1.1767E-6,-1.5667E-7,-1.7833E-6,1.51E-6,-5.8667E-7,-5.5333E-7,3.4667E-7,-1.7633E-6,9.9E-7,-9.5333E-7,-9.0667E-7,9.5E-7,-1.97E-6,5.0333E-7,-5.7333E-7,-4.2333E-7,3.1236E-4,5.6146E-4,0.0081013,0.0040113,0.0061997,0.0069622,0.0030295,0.0064248,0.0048864,0.0061834,0.0065384,0.0036119,0.0059988,0.0050947,0.0061725,0.0064157,0.0037801,0.0058408,0.005159,0.0061495,0.0063783,0.003835,0.0057974,0.0051723,0.0061642,0.0063551,0.003851,0.0057768,0.0051622,0.0061725,0.0063486,0.0038393,0.0057465,0.0051282,0.0061589,0.0063578,0.0038287,0.0057608,0.0051242,0.0061325,0.0063344,0.0038213,0.0057489,0.0051156,0.0061487,0.0063547,0.0038195,0.0057406,0.0050991,0.0061528,0.0063443,0.0037984,0.0057294,0.0050957,0.0061427,0.0063445,0.003804,0.0057006,0.0050662,0.0061147,0.0063401,0.0038003,0.0056782,0.0050691,0.0061371,0.0063104,0.0038118,0.0056904,0.005058,0.0061195,0.0063258,0.0038002,0.0056895,0.0050553,0.0061222,0.006329,0.0037894,0.0056842,0.0050364,0.0061395,0.0063269,0.0038051,0.005652,0.0050232,0.0061431,0.0063266,0.0037909,0.0056818,0.0050025,0.0061355,0.0063341,0.0037988,0.0056508,0.0050341,0.0061388,0.0063393,0.0037908,0.0056586,0.0049906,0.0061413,0.0063359,0.0037901,0.0056473,0.0050068,0.0061414,0.0063513,0.0037963,0.0056286,0.0050008,0.0061554,0.0063288,0.0037939,0.0056471,0.0049822,0.0061523,0.0063394,0.0037865,0.005629,0.0049759,0.0061518,0.0063771,0.0038079,0.0056354,0.0049672,0.0061643,0.0063363,0.0038041,0.0056265,0.0049523,0.0061586,0.0063801,0.0037973,0.0056042,0.0049594,0.0061677,0.0063692,0.0038059,0.0056398,0.0049466,0.0061777,0.0063434,0.0038083,0.0056173,0.0049439,0.0061695,0.0063699,0.0037906,0.0056273,0.0049398,0.0061866,0.0063744,0.0037939,0.0056058,0.0049207,0.0061823,0.0063688,0.0037965,0.0056099,0.0049093,0.0061976:4
-1.4833E-6,-1.72E-6,-4.1667E-7,-3.36E-6,-1.3667E-7,-8.8E-7,-7.7667E-7,-1.0367E-6,-1.84E-6,1.05E-6,-8.5333E-7,-1.7633E-6,4.4E-7,-2.3267E-6,5.6333E-7,-1.0633E-6,-1.66E-6,-7.3333E-8,-2.5967E-6,7.8333E-7,-4.8E-7,4.9667E-7,1.0333E-7,-2.4567E-6,-1.3333E-7,-2.4933E-6,-5.9333E-7,4.4E-7,-1.2233E-6,7.3333E-8,-1.6567E-6,-1.81E-6,3.4E-7,-1.8833E-6,6.6667E-7,-3.5333E-7,-4.3333E-7,-6.6667E-8,-3.3033E-6,1.9333E-7,-1.3033E-6,-1.6267E-6,2.3667E-7,-1.0467E-6,1.4E-7,7.0E-8,-1.7233E-6,-6.9333E-7,-1.2167E-6,1.5E-7,-2.1333E-7,-2.5467E-6,-7.6E-7,-2.0033E-6,1.5333E-7,-1.0433E-6,-2.0933E-6,0.0078992,0.0017206,0.007391,0.0048428,0.0057559,0.0066242,0.003221,0.006397,0.0053057,0.0058583,0.0063152,0.0036375,0.0061221,0.0054141,0.0059133,0.0062003,0.0037653,0.0060387,0.0054461,0.0059058,0.0061754,0.0037952,0.0059773,0.0054614,0.0059127,0.0061866,0.0037915,0.0059715,0.0054257,0.0058879,0.0061783,0.0037825,0.0059653,0.0054106,0.005897,0.0061589,0.0037763,0.0059383,0.0054019,0.0058848,0.0061736,0.0037748,0.0059365,0.0053648,0.0058641,0.0061458,0.0037552,0.0058988,0.0053754,0.0058772,0.0061321,0.0037595,0.0059011,0.0053649,0.0058979,0.0061389,0.0037752,0.0058735,0.0053252,0.0058941,0.0061545,0.0037537,0.0058535,0.005319,0.005884,0.0061492,0.0037658,0.005882,0.0053129,0.0058915,0.006143,0.0037495,0.0058598,0.005312,0.0058667,0.0061385,0.003754,0.0058501,0.0052775,0.0058929,0.0061402,0.0037319,0.0058212,0.0052852,0.0058812,0.0061485,0.0037429,0.0058178,0.0052511,0.0058981,0.0061428,0.0037448,0.0058081,0.005271,0.005905,0.0061619,0.0037283,0.0058054,0.0052305,0.0059051,0.0061545,0.0037239,0.0058115,0.0052427,0.0059224,0.0061522,0.0037299,0.0057919,0.0052325,0.0059208,0.0061662,0.0037269,0.0057958,0.0052261,0.0059109,0.0061685,0.003751,0.0058256,0.0052202,0.0059397,0.0061764,0.0037495,0.0058127,0.0051994,0.0059219,0.0061725,0.0037456,0.0057767,0.0051982,0.0059468,0.0061914,0.0037469,0.0057639,0.0051902,0.0059536,0.0061816,0.0037592,0.0057833,0.0051881,0.0059458,0.0061972,0.0037417,0.0057321,0.0051792,0.0059521,0.0061635,0.0037392,0.0057336,0.0051649,0.0059538,0.0061793,0.0037325,0.0057411,0.0051755,0.0059781,0.006195,0.0037504,0.0057501,0.0051619,0.0059836,0.0062125,0.0037364,0.0057414,0.0051512,0.005973,0.0062015,0.0037501,0.0057413,0.0051461,0.0059839,0.0062071,0.0037436,0.0057425,0.0051408,0.0059756,0.0061917,0.003741,0.0057186,0.0051249,0.0059875,0.0062096,0.0037558,0.0057227,0.0051161,0.0060074,0.0062189,0.003751,0.0057039,0.0051217,0.0060241,0.0062329,0.0037516,0.0057232,0.0051032,0.0060303,0.0062332,0.0037493,0.0056972,0.0051098,0.0060276,0.0062097,0.0037563,0.0056988,0.0050928,0.0060235,0.0062306,0.0037462,0.0056977,0.0050776,0.0060233,0.0062463,0.0037454,0.005679,0.0050669,0.0060348,0.0062585,0.0037575,0.0056772,0.0050604,0.0060305,0.0062522,0.0037425,0.0056948,0.0050519,0.0060427,0.0062754,0.0037555,0.0056798,0.0050442,0.0060605,0.0062776,0.0037528,0.0056668,0.0050368,0.0060589,0.006299,0.0037528,0.0056614,0.0050243,0.00609,0.0062714,0.0037605,0.0056561,0.0050113,0.0060775,0.0062741,0.0037598,0.0056404,0.0050107,0.0039018:4
1.3333E-6,1.9033E-6,2.4E-6,-7.5E-7,2.06E-6,8.6333E-7,2.0167E-6,1.4167E-6,-2.4667E-7,2.8E-6,1.12E-6,1.36E-6,2.2333E-6,-8.8667E-7,1.6133E-6,8.0E-8,6.2333E-7,1.7033E-6,-3.8333E-7,2.7067E-6,9.0E-8,1.6867E-6,2.0967E-6,-1.0E-8,2.0467E-6,8.8667E-7,1.7233E-6,1.73E-6,3.4E-7,2.1033E-6,4.6333E-7,1.1533E-6,1.28E-6,7.3333E-8,2.02E-6,3.9333E-7,1.2167E-6,2.4167E-6,1.0333E-6,2.2033E-6,6.3333E-7,2.39E-6,1.2367E-6,0.014179,0.0024949,0.013203,0.0087696,0.0088931,0.011385,0.0047635,0.011514,0.009151,0.0090679,0.01064,0.0054202,0.010879,0.0092754,0.0091418,0.010413,0.0056503,0.010621,0.0092749,0.0092165,0.010352,0.0056998,0.010568,0.0092048,0.0092629,0.010332,0.0057052,0.010493,0.0091248,0.00928,0.010343,0.0056965,0.010428,0.009088,0.0093274,0.010353,0.0057019,0.010367,0.0090533,0.0093733,0.010413,0.0056848,0.010318,0.0089684,0.0094297,0.010393,0.005693,0.010286,0.008935,0.0094392,0.010429,0.0056947,0.010231,0.0088766,0.0094908,0.010424,0.0056698,0.010213,0.0087938,0.0095141,0.010494,0.0056647,0.010182,0.0087535,0.0095779,0.010514,0.0056837,0.010106,0.0086739,0.0095906,0.010555,0.0056688,0.010095,0.0086404,0.0096456,0.010576,0.0056754,0.010065,0.0085908,0.0096714,0.010621,0.0056776,0.010044,0.0085402,0.0097239,0.010601,0.0056737,0.010009,0.0084941,0.0097637,0.010653,0.0056781,0.0099804,0.0084137,0.0098212,0.010736,0.0056803,0.0099471,0.0083953,0.0098993,0.010717,0.0056748,0.0099199,0.0083369,0.0099154,0.010745,0.0057167,0.009861,0.0082767,0.0099368,0.010742,0.0057115,0.009825,0.0082333,0.010028,0.010793,0.0057438,0.0098127,0.008201,0.010031,0.010819,0.0057572,0.0097665,0.0081315,0.010105,0.010876,0.0057639,0.0097644,0.0080813,0.010153,0.01087,0.005778,0.0097157,0.0080477,0.010171,0.010916,0.0057919,0.0097289,0.0079656,0.010209,0.010946,0.0058176,0.0096703,0.0079425,0.010225,0.010921,0.005809,0.0096505,0.0078841,0.010302,0.011003,0.005868,0.0096404,0.0078392,0.010325,0.01099,0.0058347,0.0095387,0.0077588,0.010377,0.011009,0.0059013,0.0096157,0.0077166,0.010432,0.011045,0.005902,0.009541,0.0076547,0.010448,0.011041,0.0059222,0.0095026,0.0076218,0.010487,0.011069,0.0059131,0.0094984,0.0075603,0.010497,0.011075,0.0059566,0.0094778,0.0075305,0.010512,0.011061,0.0059773,0.0094441,0.0074762,0.010561,0.011075,0.0060098,0.0094454,0.0074419,0.010594,0.011104,0.0060206,0.0094316,0.0073724,0.01062,0.011118,0.006041,0.0093901,0.0073557,0.010625,0.011091,0.0060796,0.0093998,0.0073083,0.010708,0.011091,0.0061334,0.0093822,0.0072369,0.010739,0.011101,0.0061319,0.0093684,0.0071642,0.010745,0.011069,0.0061628,0.0093913,0.0071479,0.010788,0.011076,0.0062171,0.0093273,0.0070858,0.010815,0.011093,0.0062357,0.0093439,0.0070481,0.010821,0.011104,0.0062866,0.0093438,0.0070043,0.01086,0.011066,0.0063309,0.009307,0.0069708,0.010876,0.011069,0.0063708,0.0093078,0.0069002,0.010879,0.011049,0.0063849,0.0092665,0.0068738,0.010906,0.011036,0.006446,0.0093093,0.006804,0.010921,0.01104,0.0064896,0.0093194,0.0067993,0.01094,0.011001,0.0065,0.0093067,0.0067244,0.010997,0.010977,0.0065734,0.0092968,0.0067313,0.010963,0.010948,0.0066183,0.0093025,0.0066359,0.010974,0.010928,0.0066731,0.0093121,0.0066346,0.010986,0.0109,0.0067242,0.0092941,0.0065764,0.010972,0.010869,0.0067285,0.0092925,0.0065173,0.011025,0.010871,0.0068122,0.0093033,0.0064909,0.011016,0.010817,0.0068708,0.0093219,0.0064516,0.011049,0.010767,0.0069086,0.0092801,0.0064336,0.011031,0.01072,0.0069724,0.0092977,0.0063635,0.011036,0.010732,0.0070566,0.0093022,0.006346,0.011066,0.010691,0.0070837,0.009305,0.006319,0.011031,0.010664,0.0071264,0.0093098,0.0063029,0.011079,0.010627,0.0071843,0.0093477,0.0062517,0.011061,0.01056,0.0072364,0.0093404,0.0062368,0.011056,0.010544,0.0073471,0.0093736,0.0062072,0.01109,0.010476,0.0073839,0.0093412,0.0061699,0.011042,0.010408,0.0074362,0.0093586,0.0061252,0.011034,0.010393,0.0075168,0.0093899,0.0061092,0.011058,0.010357,0.0075444,0.0094401,0.0060672,0.011043,0.010309,0.0076345,0.009421,0.0060666,0.011017,0.010257,0.0077051,0.0094744,0.0060244,0.011008,0.010227,0.0077516,0.0095,0.0060206,0.011009,0.010194,0.0078201,0.0095195,0.0059819,0.011015,0.010173,0.0078501:4
1.88E-6,1.63E-6,1.4933E-6,1.3E-6,5.5333E-7,1.2267E-6,3.4333E-7,2.75E-6,1.3567E-6,1.07E-6,1.0633E-6,3.6667E-8,1.1467E-6,2.1167E-6,8.3E-7,2.4633E-6,3.5E-7,1.8733E-6,5.4333E-7,9.5667E-7,1.55E-6,4.0E-7,2.4933E-6,8.3E-7,-3.7333E-7,1.3033E-6,4.6667E-8,1.9667E-6,3.7E-7,5.0E-7,1.28E-6,-9.3333E-8,2.1767E-6,1.5833E-6,0.013053,0.0037517,0.012764,0.0055771,0.011915,0.01193,0.0056572,0.010628,0.0066933,0.011401,0.011549,0.0062038,0.0098997,0.0070325,0.011201,0.011418,0.0064136,0.0096675,0.0070976,0.011176,0.011371,0.0065039,0.0095656,0.0071121,0.011192,0.011315,0.0065475,0.0095253,0.0070519,0.011177,0.011262,0.0066077,0.0094926,0.007,0.011174,0.01124,0.0066603,0.0094872,0.0069468,0.011186,0.011226,0.0067045,0.0094835,0.0068798,0.011196,0.011177,0.0067504,0.0094849,0.0068506,0.011211,0.011144,0.0067741,0.0094656,0.0067962,0.01121,0.011144,0.0068085,0.0094674,0.0067548,0.011215,0.011113,0.0068941,0.009474,0.0067054,0.011224,0.011122,0.0069362,0.0094891,0.0066886,0.011263,0.011058,0.0069803,0.0094784,0.0066404,0.011272,0.011004,0.0070496,0.0094727,0.0065716,0.01122,0.010981,0.007094,0.0094787,0.0065518,0.011245,0.01094,0.0071412,0.0094723,0.0065017,0.011265,0.010886,0.0071902,0.0094507,0.0064762,0.011265,0.010866,0.0072518,0.0094893,0.0064324,0.011261,0.010827,0.0073086,0.0095113,0.0064173,0.011249,0.010801,0.0073601,0.0094814,0.0063694,0.01127,0.010767,0.0074374,0.0095269,0.0063628,0.011286,0.010692,0.0075135,0.0095461,0.0063219,0.011229,0.010694,0.0075737,0.0095554,0.0063108,0.011285,0.010648,0.0076545,0.0095948,0.0062787,0.011232,0.010605,0.0077202,0.0095642,0.0062359,0.011259,0.010553,0.00779,0.0096218,0.0062045,0.011211,0.010497,0.0077908,0.0096028,0.0061999,0.0112,0.010469,0.0078783,0.0096336,0.0061365,0.011173,0.010383,0.0079024,0.0096757,0.0061483,0.011183,0.010331,0.0080232,0.0096853,0.0060943,0.011211,0.010328,0.0080455,0.0097142,0.0060782,0.011181,0.010296,0.0081214,0.0097257,0.0060905,0.011129,0.01024,0.0081742,0.0097535,0.0060296,0.011139,0.010203,0.0082645,0.0097937,0.0059915,0.011146,0.010128,0.008303,0.0098116,0.0059985,0.011117,0.010082,0.0083902,0.0098475,0.0059635,0.011098,0.010053,0.0084281,0.0098752,0.0059638,0.011057,0.0099907,0.0084852,0.009907,0.0059569,0.011059,0.0099656,0.0085681,0.00994,0.0059524,0.011026,0.0099306,0.0086103,0.010035,0.0059209,0.011004,0.0098631,0.0086369,0.010001,0.0058824,0.010966,0.0098221,0.0087224,0.010035,0.0058846,0.010896,0.0098179,0.0087812,0.010089,0.0058635,0.010918,0.0097485,0.0088353,0.010123,0.0058741,0.010828,0.0096796,0.0088911,0.010093,0.0058772,0.010833,0.0096784,0.0089939,0.010177,0.0058311,0.010788,0.0096303,0.0089733,0.010211,0.0058212,0.01077,0.0095401,0.0090545,0.010225,0.0058436,0.010741,0.0095456,0.0090857,0.010265,0.0058168,0.010731,0.0094907,0.0091676,0.010305,0.0058201,0.010668,0.0094247,0.009209,0.010333,0.0058055,0.010628,0.0093618,0.0092806,0.010374,0.0057898,0.010625,0.0093318,0.0093061,0.010392,0.0058241,0.010584,0.0092587,0.009387,0.010426,0.0058015,0.010549,0.009205,0.0094237,0.010464,0.0057656,0.01053,0.0091666,0.0094864,0.010492,0.0058069,0.010486,0.0091312,0.0095165,0.010512,0.0057848,0.010435,0.0090779,0.0095898,0.010553,0.0057815,0.010397,0.0090092,0.0096046,0.010605,0.005797,0.010358,0.0089739,0.009659,0.010609,0.0057766,0.010323,0.0089162,0.0096923,0.010655,0.0057585,0.010299,0.008909,0.0097617,0.010688,0.0057869,0.010273,0.0088529,0.0098,0.010687,0.0057768,0.010244,0.008762,0.0098154,0.010737,0.0057975,0.010242,0.0087375,0.0098639,0.010734,0.0057918,0.010185,0.0086573,0.0099169,0.010821,0.0057898,0.010152,0.0086661,0.0099638,0.010805,0.0058303,0.0101,0.0085892,0.010012,0.010858,0.0058313,0.010049,0.0085162,0.010068,0.010856,0.005827,0.010037,0.0084536,0.010077,0.010901,0.0058333,0.0099867,0.00845,0.010161,0.010963,0.0058474,0.0099606,0.0084199,0.010181,0.010963,0.00589,0.009981,0.0083343,0.010239,0.011,0.0058694,0.0099538,0.0082799,0.010249,0.01104,0.0058966,0.0099232,0.0082424,0.010308,0.01109,0.0058948,0.0098727,0.0081836,0.010346,0.011095,0.0059291,0.0098837,0.0081625,0.01039,0.011078,0.0059247,0.0098451,0.0081087,0.010447,0.011163,0.0059263,0.0098286,0.0080685,0.010482,0.01114,0.0059615,0.00976,0.0080302,0.010502,0.011192,0.0059853,0.0097401,0.0079365,0.010536,0.011193,0.0060052,0.0097103,0.0078972,0.010618,0.011206,0.0059783,0.0097333,0.0078418,0.010631,0.011244,0.0060399,0.0096805,0.0077989,0.010664,0.011239,0.0060649,0.0096853,0.0077387,0.010661,0.004446:4
1.35E-6,1.44E-6,1.98E-6,8.7E-7,6.7667E-7,1.79E-6,2.28E-6,2.46E-6,1.1767E-6,9.0E-7,1.2567E-6,2.2733E-6,2.0633E-6,5.2E-7,1.1833E-6,2.35E-6,1.43E-6,1.7E-6,6.3E-7,1.11E-6,1.5833E-6,2.12E-6,1.4833E-6,1.3133E-6,1.5267E-6,1.97E-6,1.8333E-6,1.8167E-6,8.3333E-8,1.0767E-6,1.9733E-6,1.3133E-6,1.6833E-6,9.7333E-7,7.0333E-7,1.1933E-6,1.6267E-6,3.2133E-6,1.8E-6,7.0333E-7,1.1167E-6,1.9533E-6,1.8433E-6,1.02E-6,9.8667E-7,1.4267E-6,0.0035153,0.0091552,0.0081393,0.007162,0.0083728,0.0096042,0.00957,0.0081991,0.0070335,0.0083741,0.0095702,0.0095203,0.0081874,0.0069776,0.0083463,0.0095039,0.0094716,0.0081633,0.0069487,0.0083294,0.0094761,0.0094309,0.0081388,0.0068931,0.0082798,0.009435,0.0094084,0.0080803,0.0068636,0.0082536,0.0093775,0.009344,0.0081151,0.0068835,0.0082027,0.0093652,0.0093544,0.0080534,0.0068494,0.0081891,0.0093348,0.009338,0.008035,0.0068422,0.0081762,0.0093523,0.0093086,0.0080419,0.0068254,0.0081571,0.009324,0.0093342,0.0080424,0.0068016,0.0081505,0.0092936,0.0092951,0.0080028,0.0068162,0.008125,0.0092854,0.0092921,0.0080206,0.0067997,0.008151,0.0092861,0.0093065,0.0080167,0.0068018,0.0081198,0.0092861,0.0092886,0.0080052,0.0067871,0.0081263,0.0092549,0.0092661,0.0079827,0.0067838,0.0080912,0.0092608,0.0092805,0.0079992,0.0067861,0.0080737,0.0092695,0.0092793,0.0080236,0.0067621,0.0080913,0.0092435,0.009265,0.0080034,0.0067732,0.008071,0.0092721,0.0092652,0.0080001,0.0067678,0.0080759,0.009257,0.009265,0.0079886,0.0067847,0.0080652,0.0092576,0.0092645,0.0079911,0.006782,0.0080777,0.009221,0.0092609,0.0079898,0.0067658,0.0080864,0.0092509,0.0092728,0.0080168,0.00675,0.0080851,0.0092046,0.0092456,0.0080133,0.0067531,0.0080792,0.0092466,0.00926,0.0080155,0.0067626,0.0080462,0.0092255,0.0092565,0.0079982,0.0067494,0.0080707,0.0092536,0.009244,0.0080025,0.0067882,0.0080802,0.0092394,0.0092762,0.0080273,0.0067749,0.0080766,0.0092172,0.0092938,0.0080456,0.0067555,0.0080805,0.0092318,0.0092338,0.0079984,0.0067413,0.0080657,0.0092172,0.0092681,0.0080096,0.0067745,0.0080831,0.0092064,0.0092716,0.0080085,0.0067475,0.0080546,0.0092147,0.009267,0.0080113,0.0067615,0.0080537,0.0092131,0.0092759,0.008022,0.0067543,0.008073,0.0092302,0.0092734,0.0080077,0.0067339,0.0080688,0.0092321,0.0092656,0.0080057,0.0067499,0.0080591,0.0092089,0.0092785,0.0079991,0.0067516,0.008065,0.0092168,0.0092483,0.0079982,0.0067516,0.0080457,0.0092007,0.0092754,0.008006,0.0067611,0.0080513,0.0092247,0.0092621,0.0080224,0.0067729,0.0080617,0.0092295,0.0092646,0.0080037,0.00675,0.0080358,0.0092188,0.0092783,0.0079994,0.0067504,0.0080528,0.0092045,0.0092597,0.0079847,0.0067389,0.00804,0.0092271,0.0092459,0.0079811,0.0067408,0.0080478,0.0091903,0.0092842,0.0079962,0.0067503,0.0080466,0.0091929,0.0092624,0.0080073,0.006749,0.0080354,0.0091987,0.0092607,0.0080371,0.0067522,0.008058,0.0092011,0.009257,0.0080171,0.0067387,0.00803,0.0092053,0.0092627,0.0079997,0.0067222,0.0080244,0.0091868,0.0092766,0.0080055,0.0067498:4
5.4333E-7,1.55E-6,9.5667E-7,1.05E-6,2.4833E-6,1.9633E-6,1.3633E-6,7.8E-7,8.3E-7,1.9033E-6,7.8667E-7,1.77E-6,9.3E-7,1.4167E-6,1.64E-6,1.5067E-6,2.2333E-6,1.7867E-6,7.3667E-7,2.0833E-6,2.4233E-6,1.2233E-6,1.62E-6,9.0E-7,1.0767E-6,1.0033E-6,1.42E-6,1.5967E-6,1.04E-6,1.69E-6,1.7767E-6,1.52E-6,1.2167E-6,0.0056702,0.0081118,0.0095455,0.009354,0.0081542,0.0069254,0.0087622,0.0096557,0.0093337,0.0080082,0.0069995,0.0086286,0.0096235,0.009297,0.0079463,0.0069889,0.0085973,0.0095782,0.009261,0.0079163,0.0069809,0.0085449,0.0095195,0.0092276,0.0078781,0.0069196,0.0085112,0.0095022,0.0091984,0.0078524,0.0069222,0.0084646,0.0094886,0.0091749,0.0078516,0.0068996,0.008442,0.009445,0.009161,0.007815,0.0068524,0.0084424,0.0094191,0.0091213,0.0078129,0.0068712,0.0084021,0.0094298,0.0091131,0.0077911,0.0068256,0.0084007,0.0093856,0.0091209,0.0077957,0.0068319,0.0083674,0.009399,0.0091009,0.0077723,0.0068159,0.0083863,0.0093857,0.0091089,0.0077937,0.0068378,0.0083538,0.0093783,0.0091059,0.0077828,0.0068204,0.0083299,0.009346,0.0091179,0.0077594,0.0068104,0.008309,0.0093809,0.0091141,0.0077893,0.0068022,0.0083442,0.0093823,0.0091163,0.0077786,0.0067905,0.0083354,0.0093627,0.0091302,0.0077681,0.0068006,0.0083016,0.00932,0.0091183,0.0077925,0.0068133,0.0082696,0.0093597,0.0091136,0.0077964,0.0067984,0.0082908,0.0093452,0.0091242,0.007778,0.0068132,0.0082852,0.0093425,0.0091291,0.007807,0.0068022,0.0082731,0.009335,0.0091433,0.00781,0.0067755,0.0082691,0.0093399,0.0091172,0.0078071,0.0067893,0.0082871,0.0093379,0.0091399,0.0077895,0.0068033,0.0082688,0.0093446,0.0091339,0.0078126,0.0067885,0.0082788,0.0093129,0.0091474,0.0078299,0.0067876,0.0082511,0.0093406,0.0091269,0.0077963,0.0067953,0.0082519,0.0093299,0.0091629,0.0078098,0.006771,0.008248,0.0093093,0.0091547,0.0078341,0.0067836,0.0082498,0.0093281,0.0091139,0.0078268,0.0067631,0.0082665,0.0093223,0.0091263,0.0078213,0.0067559,0.0082337,0.0093073,0.0091515,0.0078342,0.006777,0.0082261,0.0093118,0.0091659,0.0078362,0.0067869,0.0082026,0.0092455,0.0090991,0.0077652,0.0067436,0.0081469,0.0092287,0.0091009,0.0077983,0.0067336,0.0081312,0.0092278,0.009104,0.0077875,0.0067252,0.0081602,0.0092412,0.0091212,0.0077923,0.0067123,0.0081543,0.009242,0.0090974,0.0077901,0.0067388,0.0081593,0.0092423,0.0091229,0.0078125,0.0067237,0.0081449,0.0092382,0.009098,0.0078189,0.006737,0.0081349,0.0092302,0.0091148,0.0078015,0.0067286,0.0081492,0.0092248,0.0090873,0.00782,0.0067206,0.008139,0.0091957,0.0091144,0.0078051,0.0067133,0.0081153,0.0092192,0.0091106,0.0078181,0.0067125,0.0081252,0.0092186,0.0091187,0.0078293,0.0067138,0.0081022,0.009224,0.0091343,0.0078151,0.0067148,0.0081072,0.0092021,0.0091036,0.0078311,0.006736,0.0081164,0.0092147,0.0091201,0.0078468,0.0067174,0.0080659,0.0091954,0.0091207,0.0078655,0.0067185,0.0080994,0.0092248,0.0091167,0.007858,0.0067142,0.0080839,0.0092007,0.0091361,0.007851,0.0067082,0.0080931,0.0091908,0.0091558,0.0078545,0.0067131,0.0080901,0.0091831,0.0091161,0.0078696,0.0067005,0.0080669,0.0091977,0.0091351,0.0078594,0.0066974,0.0080366,0.0091942,0.0091608,0.0078737,0.0066913,0.00806,0.0091991,0.0091823,0.0078904,0.0067059,0.0080736,0.0091886,0.0091489,0.0078986,0.0067264,0.0080401,0.0091709,0.0091638,0.007881,0.0067052,0.0080792,0.0091821,0.0091691,0.0078828,0.0067229,0.0080439,0.0091785,0.0091845,0.0078949,0.0066889,0.0080717,0.0091898,0.0091769,0.0078877,0.0010852:4
1.1567E-6,9.7333E-7,1.5767E-6,1.8667E-6,1.17E-6,2.2967E-6,2.35E-6,1.8167E-6,1.3033E-6,1.22E-6,1.4867E-6,1.2767E-6,6.7E-7,1.6333E-6,1.1633E-6,1.66E-6,1.4467E-6,1.4767E-6,7.0667E-7,4.8333E-7,7.5333E-7,2.4333E-6,1.54E-6,1.66E-6,6.4667E-7,1.38E-6,2.8167E-6,1.8967E-6,2.0933E-6,8.7333E-7,1.3333E-6,1.4467E-6,2.1067E-6,3.3667E-7,0.0061897,0.0072974,0.0093123,0.010006,0.0085434,0.007482,0.0078739,0.0095902,0.0099806,0.0084341,0.0075092,0.0077884,0.0095652,0.009906,0.0083682,0.0074662,0.0076928,0.0094772,0.0098488,0.0083355,0.0074348,0.007663,0.0094614,0.0098325,0.0082952,0.007399,0.0076184,0.0093992,0.0097782,0.0082801,0.0074034,0.0076179,0.0093911,0.009734,0.0082415,0.0073586,0.0075923,0.0093439,0.0097327,0.0082544,0.0073461,0.0075335,0.0093181,0.0096922,0.008262,0.0073198,0.0075398,0.0093242,0.0096938,0.0082286,0.007327,0.0075253,0.0092801,0.0097096,0.0082062,0.0072941,0.0074756,0.0092964,0.0096601,0.0082144,0.007326,0.0074882,0.0092814,0.0096423,0.0082137,0.0073014,0.0074837,0.0092648,0.0096452,0.0082022,0.0072758,0.007466,0.0092804,0.0096381,0.0082186,0.0072791,0.0074684,0.0092628,0.0096368,0.0081886,0.0072883,0.0074609,0.009242,0.0096764,0.0082129,0.0072787,0.0074348,0.0092417,0.0096314,0.0082112,0.0072588,0.0074369,0.0092304,0.0096748,0.0082115,0.0072728,0.007456,0.0092384,0.0096326,0.0082248,0.0072879,0.0074496,0.0091894,0.0096408,0.008213,0.0072708,0.0074158,0.0092261,0.0096243,0.0082197,0.007277,0.0074081,0.0091947,0.0096292,0.0082174,0.0072737,0.0073871,0.0092018,0.0096012,0.0082274,0.0072755,0.0074083,0.0091978,0.009631,0.008228,0.007259,0.0073708,0.0091951,0.0096111,0.0082486,0.0072949,0.0073768,0.0091936,0.0096301,0.0082537,0.007265,0.0073907,0.0091676,0.0096276,0.0082678,0.0072648,0.0073873,0.0091815,0.0096396,0.0082344,0.0072776,0.0073727,0.0091818,0.0095946,0.0082541,0.007278,0.0073596,0.0091546,0.0096092,0.0082527,0.0072578,0.0073783,0.0091622,0.0095945,0.008264,0.0072599,0.0073562,0.0091816,0.0096157,0.0082592,0.0072632,0.0073676,0.0091541,0.0096089,0.0082781,0.0072617,0.0073428,0.0091568,0.0096023,0.0082845,0.0073096,0.0073419,0.0091464,0.0096092,0.0082926,0.0072876,0.007352,0.0091287,0.0096168,0.0082784,0.0072485,0.0073514,0.0091331,0.0096134,0.0082907,0.0072727,0.0073408,0.0091352,0.0096225,0.0082776,0.0072775,0.0073503,0.0091253,0.009599,0.0082849,0.007274,0.0073249,0.0091107,0.0095803,0.0082837,0.0072694,0.0073307,0.0091048,0.0095829,0.0082939,0.0072841,0.0072924,0.0091089,0.00958,0.0083106,0.007277,0.0072942,0.0091123,0.0095849,0.0083088,0.0072703,0.007316,0.0091217,0.0095704,0.0083369,0.0072812,0.0073306,0.0091073,0.0095927,0.0083178,0.0072693,0.0072894,0.0091103,0.009585,0.0082848,0.0072693,0.0072765,0.009116,0.0095699,0.0083063,0.0072701,0.0072906,0.0090981,0.0095725,0.0083232,0.0072634,0.0072989,0.0091033,0.0095713,0.0082815,0.0072756,0.0072834,0.0090865,0.009578,0.0083126,0.0072423,0.0072618,0.0090994,0.0095547,0.0083258,0.0072694,0.0072759,0.0090858,0.0095822,0.0083264,0.0072486:4
-4.3667E-7,2.57E-6,-1.47E-6,2.6667E-6,7.0333E-7,1.12E-6,3.1633E-6,-5.6E-7,2.9467E-6,8.9667E-7,5.4333E-7,1.9E-6,-2.5333E-7,2.5933E-6,6.4E-7,1.1867E-6,2.8533E-6,-7.1E-7,2.5733E-6,9.2333E-7,2.2333E-7,1.3467E-6,-1.5067E-6,2.5733E-6,1.2367E-6,-4.0E-8,2.43E-6,-9.8E-7,1.9133E-6,7.5E-7,3.8E-7,2.9033E-6,-1.1833E-6,1.4333E-6,4.0E-7,-7.3333E-8,1.0333E-6,0.0070418,0.0027983,0.0061922,0.0063124,0.002937,0.0056551,0.0038883,0.0059938,0.0060857,0.0034822,0.0051766,0.0041905,0.0059482,0.0060003,0.0036395,0.0050409,0.0042403,0.0059084,0.0059634,0.0036849,0.0049656,0.0042704,0.0059003,0.0059636,0.0036956,0.004949,0.004271,0.0058755,0.0059302,0.0037076,0.0049507,0.0042505,0.0058902,0.0059233,0.0037088,0.0049444,0.004222,0.0058747,0.005923,0.0037133,0.0049209,0.0042136,0.0058731,0.0059124,0.0036946,0.0049019,0.0042102,0.005869,0.0059175,0.0036939,0.0048828,0.0041731,0.0058588,0.0058939,0.0037009,0.0048814,0.0041771,0.0058708,0.005913,0.0036887,0.0048874,0.0041567,0.0058635,0.0059301,0.0037013,0.0048821,0.004148,0.0058779,0.0059155,0.0037063,0.0048709,0.0041461,0.0058735,0.0058906,0.0036991,0.0048642,0.0041274,0.0058693,0.0059066,0.0037141,0.0048582,0.0041266,0.0058782,0.0059004,0.0036991,0.0048473,0.004118,0.0058774,0.0059147,0.0037026,0.0048657,0.0041009,0.0058686,0.0059092,0.0037256,0.0048574,0.004091,0.0058717,0.0059093,0.0037269,0.0048427,0.0040705,0.0058789,0.0059229,0.003723,0.0048318,0.0040469,0.0058604,0.0058893,0.0037499,0.0048468,0.004056,0.005877,0.0059034,0.0037367,0.004857,0.0040287,0.0058864,0.0058968,0.0037436,0.0048413,0.0040336,0.0058625,0.0058968,0.0037533,0.0048237,0.0040341,0.005879,0.0059108,0.0037624,0.0048455,0.0040224,0.005878,0.0058969,0.0037704,0.0048235,0.0040207,0.0058867,0.0058984,0.0037599,0.004819,0.0040063,0.0058917,0.0058801,0.0037715,0.0048293,0.0039992,0.0058905,0.0058836,0.0037911,0.0048137,0.0039784,0.0058902,0.0058798,0.0038043,0.0048202,0.0039715,0.0058695,0.0058897,0.0037924,0.0048237,0.0039868,0.0058896,0.0059025,0.0038092,0.0048525,0.0039598,0.0058896,0.0059109,0.0038157,0.0048221,0.0039511,0.0058984,0.0058989,0.0038187,0.0048367,0.0039491,0.0059045,0.005912,0.0038438,0.0048238,0.0039519,0.0058781,0.005897,0.0038317,0.0048253,0.0039375,0.0058994,0.0058826,0.0038561,0.0047973,0.0039198,0.00588,0.0059113,0.0038583,0.0048049,0.0039227,0.0059114,0.0058866,0.0038797,0.0048242,0.0039073,0.0059035,0.0058906,0.0038841,0.0048128,0.0039015,0.0058961,0.0058781,0.0038948,0.004803,0.0039033,0.0058798,0.0058993,0.0039021,0.0048058,0.0038946,0.005882,0.0058824,0.0039029,0.0048158,0.0038845,0.0058999,0.0058807,0.0038931,0.004803,0.0038795,0.0059093,0.0058752,0.0039199,0.0048241,0.0038777,0.0058963,0.0058804,0.0039372,0.0048322,0.0038531,0.0058989,0.0058848,0.0039356,0.0048125,0.0038524,0.0058913,0.0058634,0.0039551,0.0048373,0.0038675,0.0059014,0.0058566,0.003965,0.004826,0.0038358,0.0058782,0.0058664,0.0039646,0.0048051,0.003831,0.0059077,0.0058494,0.0039733,0.0048241,0.0038229,0.0058906,0.0058351,0.0039957,0.0048212,0.0038079,0.0058932,0.0058538,0.0040134,0.0048148,0.0038048,0.0058949,0.0058575,0.0040225,0.0048227,0.0038064,0.0058893,0.0058251,0.0040218,0.0048202,0.0037866,0.0058928,0.0058468,0.0040412,0.0048491,0.0038037,0.0058885,0.0058159,0.002298:4
3.4667E-6,-4.4333E-7,2.08E-6,2.0067E-6,-1.2E-7,2.6633E-6,3.0E-7,2.1067E-6,1.8733E-6,-1.3333E-6,3.1733E-6,-9.3667E-7,2.1767E-6,1.92E-6,-1.1033E-6,2.2767E-6,-8.6E-7,2.6533E-6,1.36E-6,-1.0733E-6,3.09E-6,-7.7667E-7,1.9067E-6,1.6267E-6,-1.0233E-6,2.0367E-6,-1.1533E-6,3.1767E-6,1.1133E-6,-8.2667E-7,2.4533E-6,-4.2333E-7,1.6833E-6,1.35E-6,-1.0267E-6,3.27E-6,-7.2667E-7,1.3033E-6,1.3567E-6,-9.3E-7,2.9333E-6,7.6667E-8,1.4267E-6,1.33E-6,-7.6667E-8,2.4833E-6,-5.2E-7,1.6967E-6,1.7267E-6,-5.4333E-7,2.2433E-6,-2.3667E-7,1.7467E-6,1.36E-6,-7.4667E-7,2.5533E-6,-6.5E-7,1.4533E-6,1.8967E-6,-1.0E-6,2.3067E-6,-1.0633E-6,1.6833E-6,1.6333E-6,-5.7667E-7,8.6567E-5,0.007483,0.0045895,0.0047023,0.0060992,0.0027185,0.0061414,0.0051077,0.0049634,0.0055735,0.0033132,0.0057862,0.0052257,0.0050551,0.0054066,0.0034821,0.0056877,0.0052765,0.0050788,0.0053616,0.0035257,0.0056326,0.0052623,0.0050842,0.0053571,0.0035305,0.005618,0.0052688,0.0050647,0.0053451,0.0035258,0.0055906,0.0052481,0.0050879,0.0053331,0.0035152,0.0055846,0.0052199,0.0050649,0.0053474,0.0035153,0.0055656,0.0052027,0.0050638,0.0053244,0.0034996,0.0055537,0.0051933,0.0050536,0.0053332,0.0034957,0.0055562,0.0051912,0.0050768,0.0053191,0.0034903,0.0055458,0.0051864,0.0050698,0.0053287,0.0034883,0.0055416,0.0051914,0.0050716,0.0053208,0.0035027,0.0055366,0.0051731,0.0050818,0.0053323,0.0035047,0.005516,0.0051581,0.0050791,0.0053237,0.0034712,0.0054915,0.0051455,0.005079,0.0053232,0.003482,0.0055272,0.0051441,0.0050771,0.0053403,0.0034719,0.0054865,0.0051167,0.0051037,0.0053519,0.0034785,0.0055066,0.0051167,0.005087,0.0053514,0.0034901,0.0054839,0.0051197,0.0050894,0.0053433,0.0034652,0.0054901,0.0051018,0.0050966,0.0053458,0.0034717,0.0054846,0.0051031,0.0051048,0.0053491,0.0034758,0.0054885,0.0051057,0.0051114,0.0053629,0.0034635,0.005461,0.0050789,0.0051291,0.0053513,0.0034656,0.0054627,0.0050736,0.0051295,0.0053729,0.0034661,0.0054516,0.0050813,0.0051147,0.0053557,0.0034618,0.0054713,0.0050757,0.0051377,0.0053743,0.0034551,0.0054355,0.0050662,0.0051607,0.0053828,0.0034694,0.0054502,0.0050659,0.005124,0.0053645,0.0034673,0.0054491,0.0050581,0.0051645,0.0054047,0.0034531,0.0054398,0.0050519,0.0051626,0.0053855,0.0034746,0.0054433,0.0050258,0.0051614,0.005391,0.0034803,0.0054105,0.0050464,0.0051652,0.0053959,0.00346,0.0054339,0.0050486,0.0051699,0.0053801,0.0034668,0.0054238,0.005028,0.005159,0.0053946,0.0034542,0.0054094,0.0050097,0.0051774,0.0053818,0.0034643,0.0054049,0.0050133,0.0051912,0.0054058,0.0034689,0.0054037,0.0050036,0.0051978,0.0053994,0.0034733,0.0053827,0.0050118,0.0052145,0.0054175,0.003463,0.0053883,0.0050002,0.0052111,0.0054176,0.0034476,0.0054009,0.0050013,0.0052233,0.0054323,0.0034552,0.0053812,0.0049945,0.0052265,0.0054168,0.0034527,0.005393,0.0049949,0.0052132,0.0054318,0.0034611,0.0053806,0.00498,0.0052386,0.0054515,0.0034787,0.005382,0.0049593,0.0052453,0.0054276,0.0034533,0.0053725,0.0049543,0.0052267,0.0054478,0.0034619,0.0053771,0.0049653,0.0052493,0.0054621,0.0034868,0.0053668,0.0049516,0.0052372,0.0054634,0.0034636,0.005361,0.0049585,0.005251,0.0054513,0.0034749,0.0053671,0.0049388,0.0052626,0.0054641,0.0034654,0.0053416,0.0049398,0.0052791,0.0054495,0.0034688,0.0053502,0.0049401,0.0052923,0.005461,0.0034883,0.0053469,0.004929,0.0052741,0.0054672,0.0034751,0.0053322,0.0049075,0.0052844,0.0054887,0.0034462,0.0053614,0.0049424,0.0052954,0.0054899,0.0034684,0.0053205,0.0049223,0.0052934,0.005477,0.0034625,0.0053501,0.0048956,0.0053039,0.0054855,0.0034687,0.0053103,0.0049045,0.0053042,0.0055045,0.0034551,0.0053095,0.0049063,0.0053035,0.0054826,0.0034695,0.0052983,0.0048724,0.0053224,0.0054928,0.0034656,0.0053083,0.0048845,0.0053177,0.0054927,0.0034576,0.0052901,0.0048725,0.0053201,0.0055025,0.0034511,0.0052945,0.0048504,0.005331,0.0055171,0.0034668,0.0052829,0.0048462,0.0053333,0.0055167,0.0034653,0.0052958,0.0048453,0.0053432,0.005526,0.0034603,0.0052857,0.0048497,0.0053355,0.0054943,0.0034692,0.0052793,0.0048303,0.005364,0.0055223,0.0034635,0.0052686,0.0048319,0.0053354,0.0055192,0.0034704,0.005271,0.0048309,0.0053701,0.0055312,0.0034761,0.005256,0.0048412,0.0053661,0.0055388,0.0034704,0.0052639,0.0048254,0.0053726,0.0055404,0.003487,0.005266,0.0048192,0.0053731,0.0055485,0.0034727,0.0052467,0.0048106,0.0053603,0.0055514,0.0034751,0.0052384,0.004798,0.0053755,0.0055502,0.0034572,0.0052494,0.0048232,0.0053968,0.005532,0.0034796,0.00524,0.0047918,0.0053952,0.0055689,0.0034553,0.00524,0.0047913,0.0053941,0.0055588,0.003457,0.0052141,0.0047822,0.005409,0.0055604,0.0034774,0.0052299,0.0047796,0.0054098,0.0055685,0.0034608,0.0052356,0.0047695,0.0028304:4
-7.1237E-4,2.8042E-4,-4.9973E-4,5.0286E-4,-1.2771E-4,-7.6201E-4,9.2835E-4,-6.9257E-4,6.152E-4,2.2633E-5,-4.6856E-4,7.4721E-4,-5.5118E-4,4.9423E-4,1.3394E-4,-6.0777E-4,7.4002E-4,-6.8806E-4,5.742E-4,-6.8857E-5,-5.2902E-4,0.001184,-6.9651E-4,5.6214E-4,-2.3195E-4,-3.8212E-4,6.2226,7.3124,7.7863,9.1064,8.5493,6.6879,6.8813,7.7599,8.8782,8.2956,6.62,6.698,7.683,8.7389,8.1706,6.5594,6.615,7.6292,8.663,8.0906,6.5188,6.5656,7.5904,8.6105,8.0494,6.4796,6.5329,7.5636,8.5819,8.0174,6.4635,6.5122,7.5424,8.5561,7.9859,6.4442,6.4991,7.5308,8.539,7.9666,6.4379,6.4874,7.5204,8.5268,7.9546,6.4324,6.485,7.5151,8.5144,7.9443,6.4229,6.4704,7.5124,8.4955,7.9447,6.4211,6.4667,7.5116,8.4949,7.9407,6.4126,6.4651,7.508,8.4867,7.9419,6.4044,6.4687,7.5054,8.4848,7.9359,6.3963,6.4658,7.4964,8.4901,7.9303,6.3933,6.4594,7.4846,8.4807,7.9207,6.3902,6.4628,7.4812,8.4856,7.9179,6.3826,6.4559,7.4806,8.4848,7.9082,6.3924,6.4555,7.4809,8.4805,7.9042,6.383,6.4505,7.4732,8.4739,7.8973,6.3959,6.4464,7.4765,8.4698,7.8923,6.3877,6.4368,7.477,8.4667,7.8972,6.3854,6.4428,7.4804,8.4656,7.899,6.3839,6.4413,7.4721,8.4529,7.8956,6.3777,6.4426,7.4713,8.4501,7.8972,6.3705,6.4395,7.4653,8.4506,7.8905,6.3693,6.4369,7.466,8.4516,7.8929,6.3642,6.4313,7.4623,8.4548,7.8854,6.3633,6.4339,7.4572,8.4479,7.8916,6.3624,6.434,7.4525,8.4399,7.8806,6.3593,6.4248,7.455,8.4474,7.8768,6.3621,6.424,7.4493,8.4411,7.8776,6.3647,6.4223,7.4559,8.438,7.878,6.3688,6.421,7.4554,8.4357,7.8804,6.3638,6.4232,7.4625,8.4285:4
-0.011992,0.0069813,0.0022831,-0.0083814,0.009022,-0.009319,0.0038914,-7.0177E-5,-0.0051147,0.0076585,-0.010574,0.0016591,0.0020741,-0.005259,0.0065288,-0.0065003,0.0023255,0.0018486,-0.0066046,0.0065747,-0.010523,0.0011771,0.0024596,-0.0062011,0.0050039,4.8478,90.92,102.37,93.046,72.708,81.303,91.444,100.37,89.918,73.276,79.074,91.444,99.482,88.705,73.287,78.499,91.56,99.323,88.433,73.513,78.665,92.001,99.587,88.598,73.831,79.097,92.44,100.01,88.953,74.179,79.488,92.995,100.52,89.266,74.518,79.862,93.366,100.84,89.421,74.789,80.197,93.845,101.17,89.58,74.944,80.368,94.128,101.3,89.676,75.089,80.538,94.498,101.48,89.887,75.293,80.82,94.781,101.64,90.065,75.42,81.042,95.012,101.81,90.179,75.521,81.275,95.319,102.03,90.354,75.645,81.578,95.54,102.28,90.551,75.822,81.838,95.785,102.55,90.75,75.973,82.158,96.096,102.83,90.864,76.12,82.363,96.343,103.03,90.998,76.266,82.619,96.653,103.36,91.205,76.545,82.881,96.894,103.54,91.219,76.684,83.069,97.158,103.75,91.379,76.821,83.236,97.429,103.89,91.509,76.942,83.479,97.671,104.01,91.612,76.987,83.641,97.839,104.14,91.737,77.152,83.881,98.165,104.4,91.919,77.268,84.162,98.389,104.59,92.039,77.418,84.351,98.557,104.78,92.203,77.61,84.661,98.897,105.14,92.398,77.837,84.951,99.271,105.44,92.642,78.054,85.288,99.663,105.74,92.877,78.335,85.641,100.06,106.1,93.25,78.653,86.066,100.55,106.64,93.647,79.056,86.587,101.28,107.25,94.227,79.512,87.122,101.85,107.81,94.645,79.89,87.599,102.31,108.22,94.983,80.133:4
0.0036009,0.0013473,-0.0056588,0.0049704,-0.0066903,0.0012478,0.0024061,-0.0052442,0.0019087,-0.0045695,0.0025091,-5.8348E-4,-0.0083517,0.0044619,-0.0053313,-8.0031E-4,0.0024983,-0.0044802,0.0049168,-0.0047466,0.0032873,-0.0022672,0.28508,60.105,73.73,80.225,86.764,76.291,62.004,70.11,79.996,85.328,74.201,62.025,68.585,79.455,84.296,73.236,61.855,67.983,79.151,83.871,72.775,61.617,67.602,78.954,83.586,72.688,61.568,67.469,78.929,83.502,72.706,61.586,67.452,78.938,83.483,72.741,61.58,67.43,78.931,83.46,72.802,61.672,67.467,79.03,83.546,72.95,61.726,67.563,79.116,83.588,73.071,61.803,67.632,79.083,83.846,73.296,61.949,67.689,79.105,83.843,73.295,61.982,67.715,79.186,84.014,73.467,62.108,67.766,79.326,84.287,73.609,62.222,67.831,79.496,84.393,73.786,62.371,67.953,79.674,84.6,74.004,62.594,68.095,79.856,84.755,74.271,62.741,68.237,80.046,84.979,74.534,62.937,68.373,80.315,85.363,75.031,63.357,68.884,80.878,85.961,75.621,63.795,69.319,81.33,86.537,76.27,64.371,69.977,82.195,87.605,77.13,65.041,70.595,82.942,88.485,77.999,65.772,71.417,83.817,89.296,78.767,66.405,71.979,84.524,90.199,79.63,67.161,72.753,85.451,91.167,80.602,67.984,73.54,86.449,92.337,81.631,68.851,74.405,87.478,93.387,82.564,69.607,75.164,88.412,94.342,83.558,70.432,75.916,89.226,95.33,84.336,70.991,76.493,89.871,96.034,85.131,71.607,77.1,90.56,96.784,85.698,72.142,77.673,91.117,97.44,86.509,72.701,78.107,91.732,98.105,87.039,73.142,78.56,92.27,98.755,87.582,73.669,79.045:4
-0.0012188,0.0012523,-3.4462E-4,1.5914E-4,8.5258E-4,-0.0010694,8.6888E-4,-5.0924E-4,3.5899E-4,5.4654E-4,-0.001029,0.0010726,-2.2203E-4,-1.4152E-4,7.3419E-4,-9.6848E-4,7.231E-4,-3.2499E-4,-4.8267E-5,7.5675E-4,-0.0010902,0.0011211,-3.7159E-4,2.2194E-4,4.376E-4,-7.5146E-4,7.4287,10.61,11.235,9.7737,8.5958,8.366,10.362,11.227,9.8538,8.4621,8.4071,10.256,11.206,9.8787,8.4195,8.3836,10.179,11.155,9.8803,8.3881,8.3398,10.117,11.123,9.8935,8.3814,8.2984,10.062,11.084,9.8853,8.3671,8.2527,10.005,11.052,9.8922,8.3703,8.2239,9.9673,11.039,9.9244,8.3722,8.2001,9.936,11.027,9.9513,8.3803,8.1782,9.8973,11.012,9.9657,8.3917,8.1555,9.8679,11.0,9.9972,8.4046,8.1302,9.835,10.992,10.019,8.4203,8.1171,9.8016,10.979,10.042,8.435,8.0925,9.7701,10.961,10.076,8.4501,8.0732,9.7363,10.948,10.102,8.4641,8.0514,9.7143,10.931,10.117,8.4854,8.0422,9.675,10.921,10.158,8.5055,8.022,9.6493,10.914,10.175,8.5184,8.0053,9.626,10.902,10.211,8.5478,8.0006,9.5932,10.897,10.247,8.5531,7.9836,9.5566,10.876,10.264,8.5798,7.9648,9.5357,10.865,10.29,8.6012,7.959,9.5035,10.85,10.317,8.627,7.9535,9.4851,10.844,10.345,8.6553,7.9435,9.4581,10.838,10.373,8.6832,7.9393,9.4385,10.825,10.409,8.6973,7.9367,9.4103,10.801,10.435,8.7222,7.92,9.3848,10.797,10.452,8.7397,7.9125,9.3543,10.776,10.48,8.7651,7.9101,9.3236,10.766,10.5,8.799,7.9078,9.2947,10.744,10.531,8.8179,7.8953,9.2656,10.729,10.544,8.8439,7.8876,9.2432,10.721,10.572,8.8713,7.8816,9.2138,10.69,10.579,8.8947,7.8791,9.1916,10.667,10.608:4
0.0013965,-0.0014412,0.0010007,2.7211E-4,-0.0012454,8.5346E-4,-0.0010296,8.5422E-4,1.6635E-4,-3.122E-4,0.0012685,-0.0014084,8.5306E-4,2.351E-4,-3.071E-4,0.0014636,-0.0013713,8.0575E-4,2.3497E-4,-8.6238E-4,0.0014706,-0.0010687,8.8226E-4,3.8823E-5,-6.5377E-4,7.9283,10.041,10.812,12.435,11.353,8.9851,9.5773,10.971,12.344,11.249,9.0797,9.4219,10.956,12.297,11.22,9.0953,9.3488,10.919,12.253,11.207,9.0855,9.2857,10.853,12.191,11.172,9.0563,9.231,10.789,12.15,11.162,9.0523,9.1964,10.739,12.117,11.163,9.0466,9.1661,10.694,12.097,11.164,9.0489,9.1423,10.661,12.082,11.177,9.0491,9.1096,10.629,12.059,11.188,9.0666,9.0998,10.598,12.047,11.211,9.0765,9.0774,10.571,12.035,11.23,9.0838,9.0644,10.535,12.02,11.244,9.0971,9.0527,10.515,12.007,11.272,9.1023,9.0357,10.482,12.003,11.281,9.1156,9.0179,10.449,11.987,11.304,9.1314,9.0115,10.424,11.987,11.325,9.1535,9.0051,10.408,11.981,11.338,9.162,8.9734,10.365,11.952,11.347,9.1701,8.9627,10.344,11.953,11.377,9.1958,8.9683,10.333,11.944,11.396,9.2065,8.9492,10.304,11.938,11.42,9.2278,8.9495,10.279,11.923,11.445,9.2509,8.9494,10.271,11.931,11.47,9.2749,8.9421,10.249,11.92,11.488,9.2858,8.9273,10.215,11.902,11.493,9.3076,8.9219,10.195,11.898,11.516,9.3181,8.911,10.169,11.882,11.545,9.3445,8.9088,10.146,11.875,11.548,9.3533,8.8938,10.124,11.864,11.576,9.3815,8.8944,10.106,11.856,11.6,9.4056,8.8964,10.085,11.853,11.625,9.4233,8.8824,10.059,11.832,11.626,9.4436,8.8823,10.028,11.813,11.645,9.4592,8.8753,10.011,11.811,11.657:4
13.647,13.285,15.39,17.643,16.831,13.626,13.254,15.351,17.586,16.804,13.605,13.229,15.302,17.54,16.771,13.57,13.19,15.238,17.504,16.737,13.546,13.151,15.19,17.449,16.704,13.527,13.112,15.141,17.417,16.689,13.52,13.09,15.119,17.383,16.661,13.511,13.058,15.09,17.358,16.654,13.506,13.048,15.074,17.334,16.648,13.498,13.022,15.042,17.301,16.648,13.484,13.007,15.013,17.283,16.632,13.474,12.994,14.986,17.257,16.625,13.462,12.985,14.953,17.247,16.618,13.466,12.962,14.928,17.23,16.606,13.47,12.962,14.919,17.226,16.608,13.47,12.94,14.901,17.209,16.595,13.469,12.918,14.87,17.173,16.585,13.466,12.899,14.86,17.148,16.586,13.463,12.885,14.842,17.126,16.585,13.45,12.877,14.809,17.106,16.588,13.446,12.872,14.788,17.102,16.588,13.448,12.856,14.75,17.088,16.592,13.454,12.857,14.746,17.088,16.592,13.468,12.847,14.724,17.089,16.589,13.467,12.835,14.703,17.075,16.582,13.482,12.819,14.703,17.052,16.582,13.486,12.806,14.689,17.021,16.583,13.488,12.795,14.673,17.009,16.579,13.485,12.791,14.649,16.989,16.596,13.484,12.787,14.622,16.976,16.594,13.475,12.774,14.591,16.964,16.589,13.473,12.756,14.556,16.942,16.566,13.472,12.734,14.535,16.925,16.569,13.487,12.73,14.528,16.918,16.568,13.493,12.715,14.509,16.896,16.573,13.494,12.703,14.49,16.88,16.576,13.503,12.702,14.482,16.875,16.585,13.506,12.698,14.469,16.862,16.59,13.513,12.695,14.457,16.852,16.595,13.518,12.691,14.437,16.847,16.595:4
-5.7752E-4,0.0010362,6.6525E-4,-0.0014444,0.001673,-6.9199E-4,6.6865E-6,7.2496E-4,-0.0016417,0.0020677,-0.001655,1.809E-4,0.0012023,-0.0017714,0.001736,-0.0011722,8.2667,17.322,13.781,13.717,15.678,18.11,17.12,14.069,13.387,15.805,18.007,17.036,14.132,13.263,15.799,17.939,17.503,16.819,15.773,18.888,21.178,19.932,16.757,15.621,18.049,20.464,19.373,16.105,14.986,18.033,20.599,19.535,16.246,15.123,18.011,20.496,19.456,16.177,15.036,17.938,20.468,19.461,16.181,15.023,17.924,20.443,19.47,16.172,15.015,17.895,20.422,19.481,16.188,15.008,17.877,20.411,19.487,16.195,15.009,17.858,20.421,19.503,16.211,14.999,17.835,20.42,19.516,16.223,14.983,17.82,20.412,19.518,16.248,14.985,17.815,20.4,19.543,16.259,14.976,17.809,20.384,19.558,16.274,14.972,17.801,20.372,19.587,16.303,14.972,17.795,20.361,19.592,16.3,14.959,17.78,20.349,19.615,16.301,14.967,17.759,20.347,19.632,16.313,14.962,17.737,20.339,19.64,16.324,14.967,17.71,20.349,19.658,16.347,14.966,17.704,20.363,19.656,16.372,14.96,17.708,20.373,19.679,16.398,14.951,17.716,20.355,19.688,16.409,14.94,17.711,20.327,19.699,16.41,14.933,17.7,20.316,19.729,16.422,14.94,17.672,20.275,19.735,16.419,14.934,17.645,20.292,19.755,16.429,14.941,17.633,20.305,19.768,16.449,14.951,17.622,20.314,19.779,16.468,14.942,17.608,20.314,19.775,16.498,14.931,17.603,20.306,19.809,16.519,14.928,17.604,20.293,19.817,16.539,14.923,17.599,20.27,19.834,16.558,14.935,17.598,20.277,19.864,16.564,14.938:4
0.0063415,-0.015636,-0.014101,-0.0045104,-0.014941,0.0081658,-0.016648,-0.0082788,0.0054946,-0.016801,0.0069876,-0.018007,-0.010357,0.0040998,-0.018572,0.0051737,-0.018621,-0.012003,0.0043084,0.18647,21.269,10.082,16.617,18.11,7.9911,16.414,12.328,16.221,17.238,9.1424,15.454,12.786,16.115,16.993,9.3601,15.222,12.875,16.018,16.923,9.3872,15.171,12.855,16.029,16.897,9.3802,15.147,12.838,15.993,16.876,9.3649,15.122,12.81,15.978,16.85,9.3491,15.105,12.809,15.959,16.818,9.3364,15.093,12.797,15.917,16.818,9.326,15.065,12.807,15.907,16.787,9.3172,15.071,12.785,15.915,16.777,9.3111,15.073,12.777,15.912,16.78,9.3076,15.068,12.78,15.899,16.764,9.3063,15.057,12.778,15.897,16.756,9.3068,15.058,12.791,15.868,16.745,9.3031,15.061,12.799,15.85,16.771,9.293,15.061,12.783,15.866,16.764,9.2987,15.065,12.798,15.841,16.749,9.2879,15.057,12.78,15.847,16.736,9.2952,15.051,12.79,15.853,16.737,9.2891,15.064,12.808,15.829,16.734,9.2836,15.067,12.808,15.843,16.727,9.2882,15.072,12.813,15.826,16.728,9.2875,15.08,12.804,15.829,16.723,9.2791,15.077,12.816,15.82,16.722,9.2826,15.056,12.807,15.814,16.719,9.2801,15.072,12.827,15.805,16.711,9.2816,15.072,12.847,15.79,16.724,9.279,15.081,12.844,15.785,16.724,9.2667,15.083,12.838,15.802,16.713,9.2728,15.081,12.835,15.802,16.703,9.2697,15.092,12.832,15.81,16.703,9.2667,15.077,12.841,15.778,16.698,9.2718,15.077,12.842,15.77,16.679,9.2585,15.088,12.853,15.776,16.698,9.2711,15.083,12.851,15.777,16.688,9.2641:4
-0.024901,0.0023108,-0.0079662,-0.0096477,0.007108,-0.018883,0.0071816,-0.012946,-0.0091635,0.0049828,-0.018931,0.0013127,-0.0095602,-0.0084183,0.0059557,-0.01667,0.0039808,-0.0095516,-0.012355,0.0048129,-0.014524,0.0035294,11.553,13.303,18.583,6.7538,18.217,14.442,13.966,16.36,8.8302,16.916,14.89,14.079,15.843,9.2436,16.602,14.969,14.073,15.721,9.3171,16.527,14.971,14.031,15.652,9.3263,16.484,14.949,13.984,15.629,9.3096,16.47,14.955,13.952,15.594,9.3,16.453,14.937,13.922,15.564,9.2911,16.443,14.931,13.897,15.535,9.2811,16.438,14.917,13.872,15.523,9.2776,16.43,14.945,13.832,15.502,9.2819,16.422,14.947,13.814,15.487,9.2799,16.439,14.955,13.795,15.475,9.2767,16.439,14.963,13.761,15.458,9.2773,16.437,14.959,13.764,15.441,9.2795,16.438,14.967,13.747,15.434,9.2766,16.441,14.978,13.72,15.43,9.2765,16.44,14.989,13.719,15.41,9.2725,16.45,14.983,13.702,15.414,9.2801,16.457,14.998,13.697,15.392,9.2766,16.449,15.018,13.674,15.382,9.282,16.46,14.997,13.677,15.375,9.2789,16.472,15.051,13.628,15.378,9.2916,16.476,15.057,13.635,15.375,9.2912,16.482,15.056,13.613,15.353,9.2909,16.501,15.059,13.617,15.345,9.2918,16.502,15.067,13.602,15.346,9.2947,16.508,15.087,13.578,15.326,9.2981,16.489,15.095,13.551,15.323,9.3056,16.516,15.111,13.549,15.315,9.3048,16.508,15.118,13.544,15.309,9.3001,16.522,15.105,13.541,15.302,9.3027,16.53,15.123,13.526,15.286,9.3051,16.538,15.13,13.503,15.287,9.3057,16.545,15.161,13.483,15.287,9.3114,16.543,15.171,13.466,15.28:4
0.0014406,-0.0014151,0.0028568,-0.0016669,9.128E-4,4.7088E-4,-0.0018644,0.003285,-0.0018386,8.839E-4,0.0016862,-0.0025146,0.0023632,-0.001461,5.0967E-4,0.0022087,-0.0019929,0.0023803,-0.0025119,-0.0010325,0.0017583,-0.0012483,7.1935,9.5544,10.39,10.035,8.4763,7.6221,9.2354,10.417,10.018,8.3174,7.6748,9.1109,10.402,9.9567,8.2477,7.6588,9.0493,10.379,9.9,8.2091,7.6295,9.0105,10.355,9.8456,8.183,7.5918,8.9837,10.311,9.8053,8.1668,7.5641,8.9772,10.274,9.783,8.148,7.533,8.9619,10.231,9.7587,8.1216,7.5158,8.9547,10.195,9.7491,8.1026,7.5025,8.9503,10.169,9.7424,8.0807,7.4966,8.9273,10.145,9.7305,8.0529,7.4876,8.9029,10.14,9.7215,8.0367,7.4858,8.8848,10.139,9.6975,8.0243,7.4828,8.8716,10.153,9.6794,8.0197,7.4789,8.8654,10.153,9.666,8.018,7.4694,8.8621,10.15,9.6475,8.0169,7.4627,8.8641,10.138,9.6485,8.0169,7.4542,8.874,10.131,9.648,8.0125,7.451,8.8733,10.107,9.6387,8.0018,7.4442,8.8679,10.1,9.6371,7.989,7.443,8.8624,10.089,9.6348,7.979,7.4458,8.8516,10.084,9.6275,7.9706,7.4379,8.8427,10.095,9.6183,7.9685,7.4422,8.8341,10.102,9.6088,7.9674,7.4368,8.8332,10.099,9.5868,7.9576,7.4263,8.8305,10.096,9.5776,7.9631,7.4197,8.8335,10.079,9.5712,7.9588,7.4168,8.8467,10.065,9.5757,7.952,7.4151,8.8476,10.05,9.5825,7.9433,7.4173,8.8482,10.045,9.5846,7.9309,7.4216,8.8422,10.051,9.5822,7.9241,7.4328,8.8322,10.057,9.5758,7.9149,7.431,8.82,10.083,9.5629,7.915,7.4331,8.82,10.093,9.5418,7.9162,7.4287,8.8217,10.102,9.5195,7.9186,7.4193,8.8301,10.091:4
3.9353E-4,0.0021634,-0.0017049,0.0023731,-0.00172,4.7572E-4,8.1057E-4,-0.0017741,0.002641,-0.0018246,0.0011272,0.0015159,-0.0018553,0.0022384,-0.0014115,0.0012504,4.033E-4,-0.0014396,0.0016226,-0.0014584,3.7432E-4,8.6492E-4,-0.0010996,0.078694,7.6598,9.4691,9.3292,7.6382,7.0335,7.9467,9.3073,9.2414,7.6915,6.8933,7.9706,9.2269,9.1827,7.6728,6.8317,7.946,9.176,9.141,7.6429,6.7988,7.9161,9.1425,9.1074,7.6092,6.7724,7.8892,9.11,9.0738,7.5808,6.7492,7.8672,9.0959,9.0601,7.5653,6.738,7.8414,9.0739,9.0337,7.5453,6.7192,7.8251,9.056,9.0172,7.5296,6.7107,7.8086,9.0456,8.9987,7.5132,6.6998,7.8015,9.0401,8.9879,7.5086,6.6924,7.7916,9.0315,8.9765,7.5009,6.6897,7.7886,9.032,8.9701,7.4979,6.6805,7.7829,9.0226,8.9649,7.4974,6.682,7.7894,9.0157,8.96,7.4926,6.673,7.7899,9.0113,8.9609,7.4956,6.6727,7.7893,9.003,8.9592,7.4882,6.667,7.7876,8.9948,8.952,7.4812,6.6659,7.7871,8.9974,8.9612,7.4757,6.6662,7.7766,8.9881,8.9565,7.4695,6.6664,7.7722,8.9892,8.9518,7.4596,6.6653,7.7658,8.9849,8.9432,7.4584,6.6654,7.7591,8.9918,8.9358,7.4547,6.6623,7.7574,9.0004,8.9353,7.4612,6.6625,7.7585,9.011,8.9376,7.4748,6.6673,7.7703,9.0184,8.9343,7.4782,6.6669,7.7812,9.0175,8.9345,7.4786,6.6618,7.7903,9.0079,8.9386,7.4826,6.663,7.7932,9.0004,8.951,7.484,6.6682,7.7972,8.9962,8.9493,7.4765,6.6675,7.8023,8.9942,8.9631,7.4745,6.674,7.7975,8.9898,8.9617,7.4665,6.6716,7.7844,8.9905,8.9666,7.4621,6.681,7.7906,9.0026,8.9521,7.4569,6.6812,7.7816,9.0195,8.9498,7.46,6.6778,7.7824:4
0.0025394,-0.0016566,-0.0015014,0.0015501,-0.0026501,0.0031536,-0.0019661,-4.9532E-4,0.0034017,-0.0018424,0.0039112,-0.0033705,1.0463E-4,0.00322,-0.0026907,0.0036287,-0.0022049,-2.7462E-4,0.0014175,-0.0036993,0.0030162,-0.0020986,1.3818E-4,7.9523,10.478,9.1507,11.775,12.88,11.72,9.9687,9.4647,11.485,12.857,11.716,9.8187,9.4851,11.376,12.807,11.675,9.7609,9.4418,11.312,12.742,11.634,9.7271,9.401,11.28,12.678,11.62,9.7014,9.3574,11.252,12.613,11.616,9.6772,9.3335,11.23,12.575,11.614,9.6551,9.3257,11.196,12.549,11.62,9.6246,9.3102,11.158,12.538,11.619,9.6134,9.3184,11.122,12.545,11.615,9.604,9.3089,11.084,12.542,11.592,9.5962,9.2967,11.055,12.554,11.58,9.6069,9.2764,11.047,12.563,11.576,9.6199,9.267,11.051,12.566,11.572,9.6344,9.2416,11.05,12.541,11.575,9.6451,9.2284,11.057,12.508,11.587,9.6446,9.2109,11.055,12.471,11.602,9.6408,9.2138,11.055,12.453,11.63,9.6334,9.207,11.034,12.439,11.639,9.6261,9.2186,11.006,12.449,11.657,9.6241,9.2254,10.983,12.47,11.663,9.6265,9.2285,10.96,12.485,11.651,9.6299,9.2199,10.943,12.506,11.648,9.6485,9.2071,10.936,12.51,11.638,9.6645,9.1937,10.939,12.5,11.646,9.6814,9.1789,10.95,12.482,11.658,9.6983,9.169,10.963,12.458,11.681,9.6979,9.1582,10.952,12.427,11.703,9.6969,9.1577,10.947,12.412,11.731,9.7018,9.1726,10.939,12.423,11.751,9.7042,9.1882,10.928,12.448,11.773,9.705,9.1931,10.899,12.457,11.768,9.7119,9.192,10.878,12.469,11.76,9.7184,9.1813,10.859,12.476,11.747,9.7308,9.1693,10.864,12.484,11.756,9.7524:4
0.010859,0.028406,-0.014046,0.033778,0.0049467,0.0090842,0.020196,-0.010442,0.027982,0.0030324,0.0092078,0.026103,-0.013688,8.6766,103.86,81.332,49.511,83.441,41.756,88.766,81.42,56.263,73.752,48.851,85.19,81.38,57.996,71.157,50.619,84.151,81.252,58.395,70.538,50.957,83.838,81.067,58.58,70.355,50.956,83.66,80.95,58.601,70.348,50.858,83.552,80.825,58.676,70.22,50.724,83.419,80.636,58.726,70.262,50.641,83.38,80.484,58.809,70.199,50.531,83.291,80.37,58.872,70.197,50.453,83.282,80.264,58.97,70.226,50.359,83.137,80.162,59.09,70.277,50.332,83.148,80.12,59.227,70.265,50.253,83.136,79.928,59.299,70.302,50.201,83.061,79.883,59.417,70.303,50.107,83.024,79.762,59.482,70.32,50.055,83.013,79.647,59.641,70.376,49.987,83.019,79.641,59.767,70.417,49.951,82.982,79.419,59.806,70.356,49.858,82.836,79.323,59.913,70.396,49.787,82.773,79.23,60.02,70.326,49.677,82.694,79.104,60.123,70.472,49.667,82.654,79.058,60.267,70.502,49.624,82.707,78.982,60.357,70.529,49.573,82.729,78.909,60.458,70.554,49.488,82.668,78.864,60.567,70.605,49.48,82.59,78.735,60.66,70.589,49.404,82.662,78.657,60.789,70.744,49.41,82.59,78.603,60.949,70.724,49.323,82.506,78.428,61.009,70.77,49.276,82.504,78.474,61.143,70.829,49.265,82.507,78.383,61.219,70.798,49.202,82.438,78.261,61.349,70.958,49.157,82.458,78.254,61.48,70.972,49.109,82.384,78.127,61.606,70.939,49.048,82.433,78.122,61.707,71.106,49.063,82.39,78.0,61.853,71.113,48.979,82.386:4
0.022888,0.017738,-0.01617,0.029375,-0.0046535,0.017322,0.015526,-0.011115,0.03007,-0.0052875,0.025159,0.015254,-0.0064788,0.028414,-0.0040714,53.296,67.637,93.517,31.066,90.013,67.492,70.839,81.101,42.863,81.801,70.332,71.632,77.839,45.941,79.568,70.982,71.731,77.021,46.642,78.947,71.002,71.818,76.77,46.742,78.725,70.895,71.771,76.754,46.697,78.477,70.759,71.798,76.636,46.628,78.389,70.579,71.768,76.651,46.583,78.257,70.477,71.819,76.673,46.529,78.207,70.415,71.839,76.675,46.497,78.075,70.218,71.852,76.722,46.446,78.005,70.193,71.933,76.739,46.435,77.9,70.08,71.975,76.734,46.389,77.871,69.935,71.998,76.834,46.372,77.767,69.865,72.074,76.842,46.359,77.8,69.817,72.168,76.902,46.358,77.708,69.715,72.271,76.991,46.344,77.645,69.682,72.315,77.013,46.34,77.593,69.453,72.309,76.969,46.171,77.56,69.139,72.379,77.11,46.187,77.316,69.038,72.424,77.08,46.179,77.384,68.978,72.506,77.149,46.189,77.198,69.064,72.611,77.076,46.248,77.202,69.053,72.723,77.197,46.265,77.165,69.004,72.884,77.3,46.271,77.152,68.984,72.895,77.47,46.289,76.929,68.858,73.002,77.467,46.261,76.876,68.718,73.075,77.621,46.273,76.788,68.631,73.187,77.656,46.227,76.873,68.43,73.189,77.692,46.235,76.81,68.361,73.299,77.795,46.219,76.76,68.323,73.46,77.834,46.257,76.716,68.332,73.53,77.747,46.264,76.616,68.241,73.54,77.677,46.232,76.588,68.171,73.646,77.771,46.243,76.535,68.063,73.593,77.976,46.277,76.406,68.022,73.749,78.052,46.276,76.374:4
0.013166,-0.0047349,-0.015022,0.015728,-0.031765,0.009732,-0.0031076,-0.018176,0.017713,-0.020008,0.011953,-0.0073683,-0.018985,0.020606,-0.021362,0.0090779,-0.001027,-0.020165,0.022964,0.86694,36.263,43.109,40.619,31.689,33.144,38.004,42.626,40.101,32.341,32.37,38.173,42.344,39.931,32.385,32.135,38.054,42.229,39.87,32.389,32.027,37.923,42.137,39.797,32.361,31.903,37.781,42.046,39.726,32.312,31.769,37.633,41.961,39.687,32.314,31.696,37.561,41.868,39.695,32.306,31.613,37.46,41.792,39.661,32.272,31.556,37.358,41.722,39.721,32.279,31.498,37.26,41.649,39.7,32.25,31.397,37.129,41.572,39.676,32.282,31.394,37.144,41.595,39.756,32.298,31.364,37.065,41.562,39.759,32.314,31.319,36.979,41.472,39.794,32.306,31.302,36.927,41.462,39.791,32.342,31.261,36.853,41.541,39.832,32.377,31.223,36.814,41.506,39.831,32.425,31.226,36.776,41.465,39.891,32.452,31.173,36.714,41.419,39.894,32.455,31.167,36.672,41.421,39.952,32.505,31.15,36.592,41.402,39.985,32.526,31.12,36.556,41.373,40.005,32.576,31.1,36.549,41.376,40.056,32.606,31.087,36.503,41.301,40.109,32.635,31.057,36.415,41.286,40.129,32.657,31.058,36.376,41.292,40.168,32.693,31.038,36.326,41.271,40.16,32.728,31.002,36.258,41.303,40.218,32.79,31.005,36.228,41.258,40.264,32.808,30.981,36.186,41.205,40.279,32.808,30.957,36.112,41.157,40.285,32.882,30.962,36.061,41.259,40.341,32.943,30.94,35.832,41.032,40.204,32.874,30.788,35.832,41.001,40.263,32.901,30.758,35.791,40.926,40.3,32.904,30.717:4
-0.018005,-0.0053864,0.011136,-0.022419,0.016183,-0.014177,-2.9507E-4,0.0025609,-0.023998,0.019432,-0.020404,-0.0041351,0.0086953,-0.023797,0.015155,-0.01284,-0.0092988,26.853,34.194,31.072,39.584,42.448,39.128,32.779,31.947,38.9,42.391,39.152,32.413,32.041,38.609,42.249,39.074,32.263,31.985,38.49,42.158,38.988,32.165,31.922,38.396,42.084,38.9,32.102,31.831,38.305,41.984,38.822,32.028,31.743,38.235,41.868,38.768,31.983,31.702,38.156,41.822,38.756,31.935,31.669,38.105,41.751,38.719,31.888,31.632,38.043,41.779,38.709,31.882,31.593,37.991,41.755,38.675,31.865,31.564,37.958,41.712,38.651,31.864,31.55,37.959,41.695,38.659,31.843,31.524,37.929,41.605,38.622,31.816,31.479,37.837,41.634,38.59,31.818,31.462,37.834,41.604,38.596,31.808,31.417,37.825,41.553,38.588,31.8,31.39,37.818,41.533,38.617,31.808,31.402,37.79,41.531,38.615,31.793,31.425,37.779,41.525,38.604,31.797,31.42,37.752,41.599,38.606,31.796,31.396,37.74,41.594,38.617,31.791,31.359,37.707,41.553,38.61,31.807,31.365,37.736,41.544,38.625,31.804,31.349,37.714,41.511,38.647,31.81,31.33,37.69,41.51,38.647,31.819,31.344,37.704,41.493,38.657,31.817,31.346,37.697,41.504,38.687,31.822,31.353,37.72,41.504,38.703,31.84,31.364,37.682,41.557,38.713,31.86,31.376,37.649,41.565,38.719,31.853,31.353,37.65,41.549,38.707,31.87,31.317,37.615,41.541,38.706,31.865,31.299,37.618,41.533,38.754,31.863,31.28,37.65,41.532,38.775,31.899,31.318,37.643,41.529,38.749,31.891,31.273:4
-0.010872,0.019959,-0.027888,0.013852,-0.017317,-0.016892,0.013546,-0.027807,0.012276,-0.012602,-0.010448,0.0073372,-0.027416,0.01624,24.362,41.845,34.06,31.75,35.801,41.617,41.626,34.249,31.352,35.744,41.437,41.51,34.218,31.22,35.603,41.355,41.457,34.178,31.141,35.448,41.247,41.351,34.15,31.036,35.29,41.113,41.271,34.13,30.965,35.234,41.032,41.244,34.143,30.907,35.121,40.966,41.194,34.129,30.847,35.02,40.865,41.181,34.158,30.817,34.933,40.809,41.151,34.182,30.761,34.856,40.748,41.143,34.194,30.747,34.797,40.676,41.219,34.283,30.767,34.771,40.652,41.257,34.296,30.761,34.675,40.604,41.214,34.303,30.73,34.596,40.581,41.218,34.327,30.685,34.501,40.557,41.169,34.356,30.669,34.402,40.461,41.169,34.387,30.65,34.353,40.375,41.134,34.412,30.63,34.289,40.381,41.164,34.457,30.6,34.207,40.333,41.158,34.537,30.616,34.178,40.349,41.18,34.606,30.617,34.148,40.267,41.199,34.666,30.604,34.109,40.263,41.261,34.717,30.61,34.063,40.19,41.282,34.742,30.632,33.991,40.171,41.305,34.799,30.646,33.927,40.181,41.292,34.833,30.616,33.843,40.136,41.27,34.917,30.615,33.801,40.109,41.287,34.99,30.622,33.777,40.05,41.301,35.013,30.602,33.696,39.974,41.288,35.059,30.594,33.645,39.961,41.327,35.134,30.595,33.577,39.89,41.327,35.186,30.604,33.532,39.841,41.347,35.256,30.611,33.5,39.809,41.397,35.304,30.628,33.437,39.785,41.411,35.379,30.641,33.341,39.776,41.421,35.446,30.684,33.321,39.769,41.398,35.51,30.676,33.257,39.731:4
0.0012824,-0.022894,0.0095359,-0.013996,-0.0074667,0.0037714,-0.024782,0.010905,-0.015808,-0.010942,-0.0010311,-0.019086,0.010731,-0.015912,-0.0089704,3.246E-4,-0.023955,0.0068823,-0.015609,-0.00846,0.0020259,-0.018453,22.432,30.982,33.051,30.014,25.275,24.692,30.026,32.892,29.966,24.843,24.722,29.726,32.702,29.89,24.717,24.624,29.539,32.596,29.816,24.651,24.538,29.452,32.5,29.804,24.617,24.472,29.35,32.441,29.745,24.591,24.413,29.292,32.387,29.794,24.558,24.369,29.219,32.373,29.805,24.573,24.356,29.186,32.348,29.823,24.574,24.33,29.151,32.356,29.829,24.596,24.31,29.09,32.314,29.867,24.611,24.277,29.055,32.329,29.89,24.631,24.261,29.039,32.323,29.924,24.66,24.248,29.001,32.322,29.949,24.683,24.238,28.938,32.186,29.852,24.611,24.107,28.818,32.18,29.895,24.642,24.121,28.858,32.264,30.034,24.73,24.178,28.887,32.304,30.051,24.753,24.168,28.852,32.269,30.105,24.765,24.148,28.829,32.271,30.101,24.782,24.138,28.789,32.29,30.147,24.801,24.122,28.767,32.26,30.176,24.837,24.11,28.723,32.28,30.207,24.861,24.089,28.709,32.28,30.246,24.89,24.083,28.671,32.287,30.25,24.915,24.077,28.659,32.264,30.296,24.932,24.051,28.632,32.248,30.291,24.953,24.03,28.586,32.242,30.342,24.965,24.035,28.583,32.232,30.372,25.003,24.024,28.538,32.253,30.407,25.015,24.015,28.516,32.222,30.435,25.032,23.982,28.477,32.218,30.421,25.043,23.969,28.437,32.214,30.451,25.057,23.958,28.418,32.2,30.476,25.093,23.952,28.388,32.221,30.511,25.122,23.939,28.384,32.198:4
0.002921,-0.023511,-0.0086996,-0.0057112,-0.023815,0.010719,-0.020762,0.0041205,-0.011637,-0.01837,0.0075395,-0.020147,9.5841,33.188,28.582,25.02,25.523,31.245,32.896,28.712,24.306,25.686,30.859,32.748,28.651,24.094,25.623,30.671,32.611,28.575,23.971,25.541,30.536,32.489,28.483,23.893,25.47,30.445,32.443,28.439,23.856,25.435,30.408,32.421,28.402,23.858,25.398,30.382,32.418,28.402,23.841,25.374,30.363,32.384,28.379,23.834,25.337,30.33,32.333,28.367,23.819,25.319,30.309,32.322,28.382,23.814,25.295,30.285,32.303,28.382,23.801,25.271,30.286,32.284,28.412,23.817,25.273,30.255,32.305,28.419,23.801,25.272,30.272,32.283,28.416,23.807,25.263,30.223,32.29,28.43,23.786,25.253,30.22,32.296,28.419,23.81,25.261,30.201,32.327,28.438,23.812,25.234,30.219,32.316,28.456,23.831,25.24,30.203,32.325,28.477,23.824,25.229,30.221,32.298,28.482,23.84,25.222,30.187,32.3,28.502,23.827,25.214,30.209,32.299,28.523,23.842,25.203,30.165,32.303,28.495,23.817,25.196,30.159,32.279,28.525,23.824,25.198,30.149,32.329,28.531,23.832,25.207,30.139,32.317,28.539,23.841,25.184,30.13,32.333,28.514,23.831,25.164,30.115,32.334,28.54,23.843,25.15,30.125,32.327,28.568,23.88,25.16,30.156,32.346,28.594,23.873,25.163,30.16,32.294,28.625,23.884,25.152,30.132,32.327,28.608,23.864,25.147,30.125,32.298,28.64,23.87,25.142,30.085,32.305,28.598,23.85,25.137,30.058,32.307,28.631,23.843,25.115,30.058,32.306,28.621,23.855,25.107,30.035,32.324,28.627:4
36.448,39.079,34.364,28.773,30.79,36.421,39.03,34.338,28.743,30.75,36.362,39.004,34.322,28.716,30.73,36.354,38.989,34.313,28.707,30.707,36.335,38.974,34.311,28.691,30.693,36.314,38.969,34.317,28.689,30.676,36.281,38.945,34.308,28.676,30.663,36.268,38.924,34.279,28.661,30.634,36.251,38.921,34.298,28.679,30.628,36.252,38.928,34.307,28.669,30.62,36.235,38.903,34.311,28.671,30.608,36.213,38.896,34.316,28.663,30.603,36.199,38.894,34.305,28.664,30.586,36.194,38.888,34.306,28.659,30.557,36.178,38.865,34.331,28.653,30.56,36.183,38.862,34.332,28.661,30.554,36.165,38.868,34.336,28.662,30.543,36.136,38.859,34.339,28.661,30.526,36.117,38.835,34.35,28.638,30.497,36.095,38.84,34.354,28.633,30.493,36.076,38.826,34.358,28.648,30.481,36.071,38.838,34.363,28.651,30.467,36.061,38.83,34.384,28.658,30.464,36.071,38.822,34.398,28.647,30.456,36.03,38.804,34.386,28.662,30.435,36.012,38.812,34.387,28.583,30.329,35.929,38.701,34.364,28.605,30.335,35.914,38.764,34.41,28.644,30.353,35.945,38.739,34.411,28.622,30.314,35.91,38.724,34.429,28.618,30.33,35.926,38.709,34.365,28.608,30.319,35.911,38.711,34.395,28.621,30.307,35.911,38.742,34.408,28.619,30.314,35.906,38.715,34.423,28.627,30.304,35.903,38.73,34.438,28.626,30.312,35.899,38.722,34.436,28.636,30.295,35.908,38.744,34.485,28.653,30.307,35.898,38.749,34.488,28.653,30.301,35.887,38.738,34.501,28.656,30.289,35.883,38.738,34.513,28.652,30.296:4
-0.007648,0.0034143,-0.0066694,0.0010819,0.0036654,-0.0077933,2.1833E-4,-0.0013662,-0.0071436,0.011444,-0.014061,0.0035062,-0.0043663,-0.0041107,0.011689,-0.013852,0.0022395,-0.0065675,-0.0049408,0.012046,-0.011726,6.6461,40.101,38.203,32.726,29.793,36.586,40.298,38.352,31.472,30.287,35.855,40.033,38.133,31.012,30.207,35.49,39.825,37.899,30.746,30.052,35.251,39.604,37.694,30.572,29.898,35.055,39.428,37.547,30.435,29.796,34.923,39.317,37.411,30.33,29.685,34.82,39.193,37.303,30.243,29.615,34.716,39.114,37.222,30.19,29.564,34.653,39.056,37.176,30.143,29.511,34.602,38.974,37.118,30.105,29.469,34.572,38.949,37.082,30.074,29.447,34.541,38.92,37.067,30.067,29.436,34.515,38.893,37.053,30.042,29.415,34.51,38.859,37.04,30.026,29.415,34.47,38.862,37.0,30.027,29.372,34.428,38.803,36.985,30.009,29.349,34.412,38.791,36.963,30.003,29.338,34.411,38.78,36.947,29.981,29.33,34.386,38.737,36.947,29.972,29.315,34.386,38.749,36.941,29.968,29.307,34.345,38.722,36.941,29.952,29.301,34.36,38.744,36.92,29.955,29.289,34.353,38.725,36.953,29.968,29.303,34.385,38.735,36.958,29.949,29.309,34.373,38.765,36.928,29.963,29.303,34.385,38.751,36.941,29.954,29.31,34.359,38.746,36.947,29.969,29.317,34.371,38.746,36.942,29.948,29.303,34.383,38.732,36.916,29.944,29.291,34.343,38.718,36.9,29.937,29.287,34.333,38.704,36.91,29.924,29.271,34.34,38.691,36.897,29.921,29.274,34.318,38.696,36.881,29.924,29.28,34.318,38.696,36.886,29.909,29.253,34.307,38.66,36.874,29.92:4
-0.013105,0.016146,-0.015565,0.0098057,0.0028468,-0.011697,0.01673,-0.018241,0.0019668,-0.0050145,-0.0073201,0.012949,-0.014957,0.006053,0.0020847,-0.0078498,0.011218,-0.017589,0.0073412,0.0035655,-0.013853,0.014024,-0.021095,0.0099783,0.0031804,-0.0077329,0.010511,-0.014518,0.0011126,0.0022565,-0.0080065,0.018853,-0.011129,0.0049307,0.0033963,-0.0073335,0.014253,30.492,40.157,40.851,33.769,30.484,32.705,39.046,40.392,33.988,29.665,32.783,38.568,40.055,33.792,29.323,32.601,38.258,39.759,33.606,29.107,32.42,38.02,39.576,33.467,28.975,32.282,37.863,39.447,33.344,28.872,32.144,37.72,39.298,33.227,28.764,32.029,37.594,39.225,33.149,28.675,31.96,37.504,39.134,33.103,28.636,31.87,37.453,39.088,33.075,28.608,31.835,37.374,39.017,33.029,28.562,31.76,37.302,38.975,32.998,28.533,31.713,37.252,38.942,32.996,28.505,31.678,37.245,38.942,32.991,28.505,31.663,37.233,38.927,32.984,28.497,31.662,37.219,38.925,32.987,28.49,31.644,37.187,38.905,32.993,28.486,31.615,37.152,38.9,32.98,28.456,31.594,37.138,38.868,32.995,28.453,31.576,37.127,38.872,32.994,28.455,31.548,37.122,38.885,33.021,28.453,31.542,37.089,38.849,33.026,28.454,31.519,37.059,38.873,33.048,28.44,31.504,37.066,38.889,33.022,28.457,31.471,37.062,38.873,33.078,28.477,31.504,37.051,38.895,33.079,28.461,31.47,37.055,38.889,33.071,28.449,31.451,37.028,38.863,33.08,28.433,31.413,37.001,38.858,33.073,28.431,31.395,36.981,38.849,33.082,28.435,31.4,36.963,38.837,33.093,28.42,31.359,36.939,38.809,33.082,28.404,31.354,36.917,38.806:4
-0.010034,0.012441,0.0078136,-0.013828,0.015751,-0.0079789,0.0067624,0.0077244,-0.013067,0.021835,-0.012684,0.011124,0.0071515,-0.010788,0.016295,-0.014007,0.0066527,0.0066933,-0.0079554,0.015469,134.32,173.99,182.57,154.78,135.3,140.35,167.61,178.79,153.67,130.78,139.93,164.55,176.1,151.81,128.54,138.68,162.53,174.09,150.55,127.12,137.6,161.1,172.67,149.48,126.19,136.76,160.1,171.71,148.74,125.53,136.06,159.29,170.8,148.01,125.01,135.49,158.7,170.14,147.65,124.57,135.01,158.15,169.58,147.23,124.25,134.63,157.7,169.23,146.97,123.97,134.35,157.35,168.94,146.74,123.76,133.99,156.91,168.59,146.6,123.62,133.8,156.66,168.27,146.39,123.37,133.53,156.42,168.12,146.35,123.36,133.32,156.27,168.01,146.26,123.25,133.21,156.15,167.9,146.36,123.26,133.14,156.02,167.87,146.35,123.19,132.96,156.02,167.75,146.42,123.16,132.83,155.73,167.71,146.37,123.1,132.73,155.66,167.57,146.37,123.06,132.55,155.52,167.53,146.4,123.03,132.46,155.41,167.35,146.42,123.04,132.33,155.23,167.43,146.53,123.02,132.31,155.21,167.34,146.59,123.05,132.2,155.03,167.3,146.58,122.98,132.02,154.82,167.23,146.62,123.0,131.95,154.75,167.22,146.7,123.02,131.81,154.66,167.07,146.66,122.98,131.72,154.6,167.05,146.75,122.95,131.59,154.48,167.07,146.79,123.01,131.53,154.33,166.86,146.79,122.86,131.36,154.22,166.82,146.96,122.95,131.3,154.17,166.83,146.95,122.96,131.28,154.09,166.89,147.04,122.98,131.22,154.06,166.89,147.23,122.99,131.15,153.92,166.8,147.27,123.04:4
0.011686,-0.012394,0.014178,0.0076077,-0.0048724,0.020018,-0.012251,0.011853,0.006575,-0.0050775,0.017253,-0.010298,0.0094649,0.0085514,-0.0096493,0.01572,-0.0071334,0.014624,0.0032255,-0.0074805,0.017313,-0.010017,0.0077736,0.002593,-0.010172,0.013685,-0.0094945,0.011506,0.0066525,-0.0048788,0.010788,18.057,160.01,183.09,166.88,131.53,141.72,161.41,179.13,161.62,131.44,137.54,159.95,176.37,158.83,130.31,135.4,158.42,174.19,156.84,129.14,134.11,157.21,172.64,155.41,128.09,133.09,156.15,171.45,154.46,127.37,132.35,155.33,170.57,153.7,126.81,131.85,154.86,169.87,153.08,126.36,131.42,154.35,169.3,152.7,126.01,131.03,153.87,168.78,152.28,125.71,130.68,153.56,168.51,152.02,125.49,130.54,153.35,168.24,151.84,125.32,130.35,153.2,168.02,151.63,125.15,130.17,152.85,167.82,151.52,125.09,130.04,152.74,167.74,151.3,124.99,130.02,152.68,167.67,151.26,124.96,129.86,152.58,167.41,151.14,124.89,129.81,152.5,167.36,151.12,124.8,129.74,152.38,167.24,150.96,124.71,129.67,152.34,167.24,150.94,124.62,129.55,152.24,167.19,150.87,124.56,129.52,152.15,167.06,150.78,124.54,129.52,152.16,167.02,150.76,124.46,129.41,152.12,166.86,150.66,124.4,129.36,151.97,166.91,150.67,124.37,129.34,152.02,166.79,150.57,124.4,129.36,152.03,166.91,150.51,124.32,129.32,151.91,166.71,150.49,124.33,129.27,151.93,166.76,150.48,124.33,129.31,151.93,166.67,150.47,124.25,129.17,151.81,166.58,150.39,124.24,129.18,151.82,166.68,150.43,124.25,129.18,151.81,166.65,150.45,124.25,129.18,151.82,166.56,150.47:4
0.008259,0.012583,-0.011316,0.015953,-0.0037753,0.0094977,0.011935,-0.008758,0.017142,-0.0057448,0.0023902,0.01388,-0.011427,0.019607,-0.006452,0.010814,0.0096809,-0.0045072,0.011149,-0.0023277,0.0028022,0.019378,-0.0047918,0.017635,-0.0038856,3.8263,11.854,18.068,6.0133,17.575,13.595,12.914,15.102,8.3373,15.935,13.814,13.067,14.475,8.6764,15.496,13.734,13.013,14.284,8.6198,15.232,13.569,12.93,14.193,8.5346,15.083,13.407,12.909,14.171,8.4522,14.996,13.273,12.91,14.138,8.4035,14.899,13.159,12.928,14.133,8.3502,14.806,13.063,12.922,14.116,8.3186,14.701,12.96,12.935,14.121,8.2759,14.609,12.869,12.958,14.134,8.2327,14.557,12.778,13.001,14.152,8.2101,14.488,12.708,13.046,14.175,8.194,14.446,12.663,13.073,14.203,8.1761,14.373,12.58,13.107,14.234,8.1634,14.329,12.495,13.171,14.276,8.1554,14.302,12.402,13.253,14.29,8.158,14.231,12.35,13.291,14.321,8.1431,14.18,12.317,13.324,14.361,8.1489,14.116,12.266,13.375,14.405,8.1343,14.08,12.216,13.416,14.462,8.1471,14.053,12.138,13.483,14.507,8.1492,14.029,12.088,13.541,14.543,8.1421,13.978,12.026,13.595,14.58,8.1538,13.937,11.979,13.643,14.625,8.1657,13.969,11.961,13.777,14.746,8.1908,13.942,11.904,13.855,14.765,8.2045,13.898,11.856,13.897,14.809,8.2198,13.84,11.799,13.932,14.836,8.2277,13.787,11.742,13.948,14.861,8.2329,13.739,11.68,13.984,14.9,8.2268,13.694,11.595,14.04,14.918,8.2382,13.642,11.551,14.08,14.954,8.2443,13.606,11.49,14.123,14.985,8.2581,13.551,11.442,14.152,15.022,8.2693,13.546:4
0.0070569,-0.0065838,0.02971,-0.0095123,0.02223,0.0039687,-0.0019715,0.014009,-0.013211,0.018493,0.0014939,0.0011128,0.023139,-0.014033,0.014659,0.0035885,-0.0033295,0.018943,-0.014774,0.019207,0.004861,-0.003574,0.013634,-0.014567,0.016554,0.0026698,-0.0081054,0.02202,-0.019134,0.017231,-0.004122,-0.0011287,0.010422,-0.012262,0.011004,-7.4989E-4,-0.01114,0.014749,-0.0097996,0.018107,0.56678,17.924,6.2794,16.756,9.2512,16.443,16.509,8.9186,14.135,10.549,15.895,16.167,9.2955,13.549,10.62,15.672,15.953,9.2763,13.344,10.493,15.549,15.807,9.2081,13.222,10.367,15.441,15.69,9.1446,13.117,10.251,15.373,15.621,9.1049,13.076,10.162,15.345,15.567,9.0857,13.018,10.077,15.312,15.494,9.074,12.973,10.012,15.255,15.424,9.0639,12.907,9.9692,15.203,15.402,9.0493,12.906,9.9227,15.205,15.402,9.0514,12.889,9.8637,15.22,15.384,9.076,12.876,9.8229,15.188,15.323,9.0842,12.813,9.7661,15.171,15.278,9.0998,12.786,9.7434,15.147,15.269,9.1125,12.79,9.7059,15.172,15.286,9.1231,12.803,9.6686,15.206,15.28,9.1481,12.791,9.61,15.226,15.228,9.1892,12.78,9.5904,15.22,15.205,9.2235,12.756,9.5586,15.201,15.182,9.2502,12.75,9.5556,15.204,15.177,9.2784,12.76,9.5235,15.23,15.174,9.3174,12.754,9.4939,15.236,15.148,9.3381,12.746,9.4657,15.216,15.118,9.3683,12.744,9.4218,15.233,15.121,9.4043,12.759,9.411,15.276,15.117,9.4433,12.767,9.3936,15.279,15.104,9.4951,12.769,9.3618,15.279,15.054,9.529,12.736,9.3324,15.249,15.028,9.5542,12.738,9.3017,15.249,15.013,9.5784,12.746,9.2701,15.287,14.994,9.6311,12.77,9.2241:4
-0.0058993,-0.014418,0.018639,-0.022551,0.0053282,-0.0069123,-0.022892,0.013546,-0.025034,0.0084278,-0.0043241,-0.022153,0.017852,-0.028391,0.0069994,-0.0028018,-0.021428,0.0146,-0.02499,0.0050543,17.943,44.949,36.184,38.926,45.266,49.353,44.617,36.712,38.412,45.283,49.246,44.633,36.832,38.217,45.175,49.233,44.696,36.877,38.06,45.027,49.208,44.783,36.935,37.943,44.936,49.155,44.856,36.973,37.825,44.819,49.108,44.973,37.034,37.736,44.718,49.044,45.076,37.062,37.613,44.572,48.983,45.184,37.093,37.527,44.422,48.941,45.294,37.138,37.433,44.273,48.911,45.366,37.186,37.332,44.15,48.87,45.468,37.26,37.241,44.032,48.829,45.586,37.328,37.172,43.928,48.793,45.705,37.395,37.093,43.812,48.773,45.809,37.46,37.032,43.679,48.758,45.902,37.536,36.96,43.543,48.722,45.997,37.612,36.884,43.434,48.706,46.094,37.692,36.814,43.319,48.679,46.211,37.781,36.748,43.245,48.651,46.319,37.886,36.685,43.151,48.55,46.43,37.964,36.623,43.032,48.486,46.564,38.035,36.572,42.922,48.462,46.664,38.119,36.536,42.768,48.44,46.766,38.205,36.509,42.627,48.442,46.847,38.289,36.441,42.495,48.412,46.906,38.395,36.402,42.386,48.387,47.006,38.497,36.354,42.3,48.324,47.112,38.61,36.308,42.181,48.26,47.207,38.696,36.266,42.081,48.214,47.278,38.79,36.227,41.947,48.158,47.385,38.894,36.179,41.848,48.097,47.463,39.0,36.174,41.739,48.061,47.548,39.093,36.145,41.621,48.027,47.619,39.201,36.117,41.5,47.985,47.697,39.316,36.083,41.397,47.912,47.763,39.434,36.065,41.297:4
-0.021571,0.0089226,0.0012882,-0.023145,0.016133,-0.026356,-0.0010788,-0.0062223,-0.019495,0.018057,-0.01909,0.0013386,9.9357E-6,-0.022399,0.01559,-0.019862,0.0056189,24.132,41.744,34.636,42.259,47.529,48.16,40.617,35.678,41.521,47.695,48.196,40.377,35.835,41.319,47.68,48.19,40.332,35.862,41.234,47.691,48.177,40.311,35.837,41.158,47.645,48.137,40.305,35.807,41.124,47.6,48.12,40.299,35.764,41.071,47.552,48.095,40.288,35.756,41.027,47.526,48.106,40.283,35.746,40.961,47.47,48.059,40.247,35.704,40.891,47.44,48.04,40.28,35.702,40.863,47.429,48.011,40.294,35.662,40.846,47.379,47.996,40.287,35.636,40.825,47.318,48.023,40.303,35.632,40.787,47.309,48.032,40.3,35.638,40.779,47.297,48.052,40.319,35.62,40.742,47.292,48.062,40.346,35.643,40.753,47.294,48.089,40.389,35.644,40.742,47.277,48.13,40.416,35.65,40.738,47.275,48.147,40.429,35.647,40.69,47.24,48.151,40.405,35.639,40.66,47.252,48.142,40.441,35.653,40.625,47.256,48.135,40.461,35.658,40.592,47.263,48.15,40.482,35.656,40.588,47.233,48.131,40.513,35.646,40.586,47.25,48.157,40.538,35.639,40.564,47.176,48.18,40.555,35.64,40.565,47.161,48.182,40.557,35.632,40.527,47.138,48.205,40.57,35.633,40.5,47.146,48.174,40.579,35.626,40.469,47.113,48.16,40.593,35.602,40.43,47.086,48.185,40.625,35.612,40.437,47.068,48.178,40.613,35.61,40.429,47.064,48.223,40.633,35.616,40.4,47.063,48.239,40.658,35.638,40.386,47.097,48.222,40.675,35.636,40.361,47.071,48.246,40.677,35.621:4
0.0034258,-0.0018568,-0.02184,0.021837,-0.019377,0.0093777,0.0038733,-0.01907,0.015703,-0.017539,0.0027183,0.0073569,-0.022796,0.018491,-0.019047,-0.001043,0.0028787,-0.018541,0.018093,-0.016784,17.221,47.848,37.627,37.452,41.707,48.559,47.333,38.808,36.358,42.303,48.136,47.249,38.993,36.14,42.399,48.261,47.218,39.031,36.05,42.353,48.201,47.205,39.026,36.03,42.28,48.187,47.156,38.994,35.961,42.198,48.142,47.101,38.989,35.926,42.163,48.101,47.064,38.976,35.867,42.119,48.031,47.063,39.006,35.847,42.118,47.999,47.084,39.012,35.837,42.08,47.973,47.094,38.992,35.806,42.018,47.897,47.043,38.949,35.752,41.933,47.864,47.056,38.981,35.757,41.937,47.877,47.056,39.002,35.758,41.922,47.886,47.094,39.026,35.755,41.895,47.878,47.115,39.028,35.752,41.874,47.863,47.131,39.038,35.738,41.841,47.836,47.109,39.043,35.718,41.829,47.824,47.135,39.06,35.715,41.792,47.807,47.117,39.05,35.692,41.736,47.773,47.117,39.073,35.693,41.719,47.808,47.143,39.09,35.671,41.697,47.784,47.153,39.113,35.664,41.671,47.747,47.161,39.131,35.677,41.676,47.744,47.222,39.175,35.677,41.695,47.74,47.244,39.205,35.667,41.657,47.717,47.241,39.205,35.65,41.608,47.671,47.264,39.2,35.641,41.561,47.64,47.255,39.188,35.614,41.526,47.636,47.266,39.211,35.624,41.48,47.656,47.272,39.238,35.635,41.46,47.676,47.281,39.265,35.623,41.469,47.684,47.302,39.32,35.642,41.496,47.705,47.309,39.338,35.608,41.446,47.657,47.362,39.404,35.633,41.475,47.636,47.381,39.397,35.595,41.431:4
0.021229,-0.021227,-0.0072321,0.007037,-0.028142,0.0097155,-0.017716,-0.012041,0.020341,-0.026683,0.019319,-0.022337,4.0432,40.008,34.386,35.842,43.42,45.588,39.605,33.633,35.536,42.74,45.171,39.316,33.274,35.163,42.358,44.771,39.047,33.051,34.901,42.064,44.553,38.934,32.903,34.686,41.826,44.336,38.815,32.774,34.52,41.652,44.212,38.761,32.695,34.387,41.473,44.112,38.71,32.629,34.28,41.346,44.056,38.705,32.586,34.162,41.226,43.966,38.668,32.531,34.038,41.093,43.943,38.716,32.54,33.997,41.043,43.916,38.732,32.557,33.944,40.961,43.917,38.77,32.552,33.879,40.926,43.896,38.834,32.583,33.714,40.765,43.857,38.872,32.584,33.76,40.818,43.845,38.928,32.609,33.716,40.731,43.857,38.996,32.605,33.662,40.701,43.809,39.055,32.635,33.638,40.611,43.844,39.136,32.64,33.555,40.466,43.785,39.133,32.641,33.55,40.496,43.822,39.222,32.69,33.496,40.469,43.78,39.281,32.739,33.473,40.391,43.84,39.362,32.747,33.415,40.366,43.819,39.424,32.806,33.388,40.268,43.843,39.483,32.82,33.316,40.277,43.816,39.544,32.872,33.3,40.214,43.796,39.608,32.885,33.26,40.187,43.769,39.693,32.939,33.229,40.099,43.782,39.748,32.936,33.188,40.075,43.765,39.81,32.97,33.108,39.959,43.775,39.864,32.995,33.097,39.946,43.748,39.902,33.057,33.077,39.858,43.748,40.005,33.067,33.033,39.84,43.74,40.059,33.11,33.003,39.746,43.744,40.071,33.121,32.966,39.714,43.734,40.157,33.165,32.921,39.66,43.758,40.227,33.218,32.904,39.645,43.7,40.258,33.253:4
-0.0069818,-0.01763,0.016837,-0.030151,0.017361,-0.010707,-0.01549,0.010983,-0.031769,0.0064818,-0.0082513,-0.011761,0.016833,-0.023275,0.014704,-0.013904,-0.013079,0.013021,-0.031951,6.1474,44.647,43.498,36.94,32.885,39.781,44.779,43.295,35.805,33.113,38.963,44.495,42.96,35.308,32.967,38.556,44.143,42.685,35.038,32.782,38.327,43.9,42.425,34.85,32.621,38.104,43.717,42.275,34.672,32.501,37.978,43.58,42.145,34.604,32.43,37.876,43.515,42.053,34.506,32.369,37.837,43.454,41.99,34.467,32.346,37.816,43.396,41.979,34.435,32.3,37.771,43.371,41.915,34.398,32.293,37.748,43.342,41.89,34.369,32.275,37.765,43.329,41.889,34.397,32.286,37.725,43.38,41.897,34.379,32.277,37.76,43.348,41.862,34.395,32.286,37.738,43.32,41.876,34.383,32.283,37.756,43.334,41.842,34.355,32.264,37.734,43.232,41.824,34.307,32.233,37.724,43.242,41.844,34.341,32.263,37.735,43.335,41.847,34.311,32.283,37.779,43.347,41.864,34.388,32.298,37.801,43.345,41.883,34.343,32.288,37.828,43.345,41.876,34.353,32.308,37.798,43.329,41.871,34.326,32.3,37.782,43.366,41.859,34.315,32.318,37.818,43.39,41.864,34.313,32.317,37.832,43.398,41.841,34.358,32.335,37.836,43.42,41.856,34.336,32.317,37.841,43.36,41.857,34.336,32.346,37.84,43.392,41.863,34.31,32.314,37.843,43.404,41.839,34.321,32.351,37.884,43.419,41.86,34.344,32.362,37.899,43.443,41.85,34.34,32.35,37.89,43.393,41.813,34.303,32.32,37.893,43.387,41.817,34.28,32.331,37.897,43.373,41.821,34.273,32.335,37.895:4
28.221,32.291,37.423,38.024,31.8,28.247,32.309,37.439,38.026,31.751,28.165,32.213,37.286,37.925,31.703,28.13,32.116,37.264,37.905,31.712,28.136,32.13,37.328,37.903,31.752,28.155,32.158,37.423,37.929,31.834,28.201,32.27,37.412,37.964,31.856,28.184,32.246,37.356,37.966,31.833,28.16,32.225,37.321,37.95,31.819,28.138,32.207,37.282,37.966,31.825,28.149,32.264,37.326,38.031,31.86,28.193,32.283,37.283,38.051,31.826,28.18,32.205,37.246,38.025,31.77,28.175,32.112,37.285,37.974,31.779,28.181,32.093,37.407,37.946,31.819,28.176,32.11,37.408,37.901,31.882,28.142,32.157,37.383,37.952,31.899,28.135,32.195,37.309,37.978,31.876,28.115,32.144,37.203,37.924,31.837,28.103,32.115,37.18,37.961,31.832,28.126,32.131,37.26,38.013,31.852,28.147,32.141,37.242,38.005,31.837,28.134,32.062,37.18,37.963,31.791,28.127,32.01,37.199,37.922,31.798,28.103,31.978,37.199,37.873,31.807,28.086,31.968,37.21,37.862,31.833,28.08,32.032,37.196,37.898,31.849,28.078,32.02,37.174,37.879,31.806,28.055,31.944,37.165,37.867,31.817,28.037,31.923,37.161,37.831,31.848,28.042,31.977,37.177,37.874,31.9,28.072,32.047,37.154,37.917,31.88,28.035,32.013,37.026,37.897,31.834,28.033,31.955,37.058,37.915,31.81,28.069,31.95,37.133,37.898,31.836,28.07,31.924,37.179,37.92,31.873,28.091,31.958,37.167,37.945,31.901,28.091,31.944,37.136,37.938,31.877,28.07,31.902,37.118,37.89,31.863,28.047,31.862,37.113,37.841,31.901:4
-0.0058963,0.012397,-0.0078613,0.0061241,0.0052823,-0.0083536,0.013248,-0.011516,0.0051351,0.0023398,-0.0043362,0.0095021,-0.012241,3.4025E-4,9.2192E-4,-0.0043758,0.0041589,-0.0056936,7.3526,17.155,27.269,33.148,28.14,37.972,38.958,35.165,29.898,30.08,36.652,38.763,35.287,29.149,30.22,36.174,38.495,35.154,28.873,30.177,35.945,38.386,35.045,28.743,30.093,35.816,38.333,34.911,28.667,29.996,35.71,38.248,34.82,28.586,29.897,35.617,38.143,34.767,28.538,29.831,35.538,38.034,34.739,28.496,29.824,35.516,38.063,34.705,28.509,29.808,35.503,38.06,34.67,28.509,29.765,35.518,38.004,34.678,28.497,29.722,35.507,37.924,34.678,28.464,29.691,35.457,37.879,34.696,28.426,29.705,35.409,37.934,34.706,28.444,29.738,35.387,38.003,34.7,28.475,29.735,35.449,38.005,34.674,28.492,29.688,35.45,37.933,34.673,28.482,29.674,35.432,37.901,34.688,28.451,29.662,35.381,37.947,34.712,28.443,29.691,35.364,37.995,34.7,28.466,29.696,35.376,38.014,34.726,28.488,29.675,35.359,37.955,34.711,28.48,29.626,35.341,37.882,34.717,28.449,29.588,35.278,37.863,34.71,28.446,29.594,35.316,37.873,34.726,28.466,29.593,35.334,37.867,34.768,28.459,29.561,35.299,37.81,34.768,28.43,29.571,35.243,37.811,34.767,28.415,29.594,35.22,37.878,34.763,28.453,29.603,35.209,37.925,34.735,28.471,29.551,35.245,37.908,34.727,28.48,29.523,35.285,37.842,34.755,28.466,29.508,35.261,37.785,34.784,28.46,29.547,35.22,37.801,34.802,28.427,29.535,35.202,37.864,34.798,28.473,29.579,35.248,37.894:4
8.8546E-5,0.015987,18.525,9.731,15.302,17.342,33.795,28.608,38.817,39.556,35.188,30.294,30.692,37.374,39.316,35.554,29.525,30.893,36.853,39.136,35.526,29.255,30.755,36.514,38.999,35.46,29.133,30.573,36.286,38.89,35.393,29.096,30.404,36.174,38.804,35.387,29.092,30.284,36.114,38.68,35.482,29.095,30.21,36.051,38.615,35.559,29.08,30.141,35.916,38.555,35.595,29.057,30.054,35.788,38.545,35.634,29.08,30.001,35.719,38.569,35.705,29.114,29.953,35.638,38.547,35.777,29.141,29.884,35.554,38.523,35.82,29.181,29.839,35.478,38.511,35.849,29.183,29.717,35.339,38.443,35.852,29.2,29.623,35.287,38.406,35.926,29.255,29.592,35.307,38.415,36.057,29.315,29.563,35.262,38.398,36.153,29.347,29.535,35.164,38.379,36.22,29.366,29.476,35.071,38.354,36.256,29.415,29.432,35.054,38.338,36.352,29.481,29.405,35.036,38.33,36.47,29.567,29.411,34.979,38.323,36.581,29.574,29.403,34.883,38.358,36.609,29.572,29.314,34.69,38.357,36.584,29.626,29.264,34.63,38.374,36.643,29.718,29.223,34.631,38.334,36.719,29.784,29.162,34.598,38.24,36.818,29.837,29.12,34.535,38.201,36.895,29.871,29.074,34.406,38.163,36.94,29.994,29.145,34.47,38.339,37.155,30.092,29.164,34.455,38.362,37.244,30.143,29.143,34.354,38.319,37.296,30.195,29.102,34.265,38.361,37.342,30.269,29.057,34.169,38.311,37.336,30.314,29.001,34.109,38.308,37.411,30.419,28.997,34.13,38.287,37.535,30.486,28.98,34.075,38.228,37.642,30.543,28.979,33.959,38.225:4
2.9867E-6,1.9533E-6,3.18E-6,-1.2133E-6,5.0167E-6,2.53E-6,2.27E-6,3.4267E-6,3.8333E-7,4.8067E-6,2.71E-6,2.3133E-6,3.7433E-6,-1.3133E-6,5.1133E-6,3.31E-6,2.1033E-6,4.35E-6,4.3333E-8,5.45E-6,2.7933E-6,1.9967E-6,3.74E-6,-2.9333E-7,4.5767E-6,3.67E-6,3.34E-6,4.1467E-6,-7.8333E-7,5.3867E-6,3.56E-6,2.8367E-6,3.9667E-6,-1.0333E-7,5.3433E-6,2.34E-6,2.7267E-6,4.0567E-6,-3.3335E-9,5.2733E-6,3.9367E-6,3.1E-6,0.0098751,0.013524,0.010914,0.013942,0.016923,0.015277,0.012929,0.0112,0.013816,0.016826,0.015336,0.012709,0.011337,0.013555,0.016913,0.015106,0.012751,0.01138,0.013596,0.01683,0.015176,0.012684,0.011341,0.013712,0.016995,0.015292,0.012811,0.011419,0.013799,0.01693,0.015192,0.012686,0.011363,0.013622,0.016816,0.015044,0.012563,0.011396,0.01382,0.016894,0.01505,0.012606,0.011204,0.013895,0.016906,0.015081,0.012578,0.011197,0.013905,0.016885,0.014994,0.012535,0.011207,0.013826,0.016845,0.014907,0.012482,0.011404,0.013838,0.016842,0.015068,0.012673,0.011308,0.013669,0.017003,0.014971,0.012533,0.011178,0.014051,0.016869,0.014841,0.012397,0.01136,0.013908,0.016781,0.014979,0.01264,0.011236,0.013723,0.016979,0.014876,0.012456,0.011197,0.013947,0.016869,0.01472,0.012578,0.011346,0.013861,0.016999,0.014867,0.012436,0.011258,0.013872,0.016827,0.014633,0.01234,0.011347,0.013957,0.016755,0.014789,0.012521,0.011226,0.014033,0.016913,0.014685,0.012383,0.011356,0.014141,0.0168,0.014518,0.012477,0.01126,0.013882,0.01691,0.014612,0.012351,0.011163,0.014204,0.016809,0.014527,0.012464,0.011339,0.014036,0.016985,0.014642,0.012354,0.011193,0.014292,0.016915,0.01446,0.012223,0.011329,0.01413,0.016775,0.014562,0.01237,0.011213,0.014178,0.016863,0.014428,0.012258,0.011332,0.014341,0.016746,0.014525,0.012371,0.011237,0.014077,0.016857,0.014414,0.012205,0.011165,0.014364,0.01679,0.014303,0.012332,0.011329:5
8.9333E-7,4.1333E-6,2.9333E-6,4.1967E-6,5.4533E-6,-3.2E-7,4.9167E-6,3.2033E-6,4.8533E-6,4.5733E-6,-5.0333E-7,4.7767E-6,2.7233E-6,3.0367E-6,4.65E-6,-1.6E-7,4.7067E-6,4.5767E-6,4.82E-6,3.4767E-6,-4.7667E-7,4.4633E-6,3.0267E-6,3.34E-6,4.2267E-6,5.1E-7,4.52E-6,2.62E-6,3.7167E-6,3.9733E-6,2.4333E-7,4.72E-6,3.56E-6,3.5333E-6,5.07E-6,-4.3333E-7,4.7433E-6,3.6667E-6,3.3967E-6,5.3833E-6,-6.0667E-7,5.8433E-6,3.7E-6,3.6E-6,0.0096301,0.01352,0.010928,0.013596,0.016832,0.015653,0.013182,0.011183,0.013288,0.016714,0.015479,0.013003,0.011167,0.013261,0.01666,0.01554,0.012962,0.011383,0.013167,0.016794,0.015547,0.012995,0.011386,0.013044,0.016667,0.015369,0.012725,0.011202,0.013137,0.016695,0.015209,0.012589,0.01139,0.013548,0.016816,0.015256,0.012695,0.011222,0.013245,0.016901,0.015404,0.012717,0.011295,0.013369,0.016714,0.01525,0.012782,0.011231,0.01341,0.016913,0.015221,0.012647,0.011264,0.013634,0.016863,0.015079,0.012552,0.011229,0.013802,0.016877,0.01498,0.012427,0.011344,0.013757,0.016756,0.015048,0.012652,0.011261,0.013638,0.016978,0.014945,0.012492,0.011193,0.014023,0.016853,0.014728,0.012337,0.011341,0.013936,0.016736,0.014859,0.012534,0.011252,0.014014,0.016922,0.014718,0.012416,0.011135,0.014109,0.016803,0.014574,0.012474,0.011315,0.013983,0.016981,0.014584,0.012343,0.011197,0.014336,0.016855,0.014428,0.012245,0.011324,0.014227,0.01677,0.014543,0.012386,0.011222,0.014285,0.016896,0.014373,0.012196,0.011348,0.014391,0.01676,0.014322,0.012307,0.011218,0.014433,0.016944,0.014232,0.012207,0.01112,0.014558,0.016831,0.01412,0.012267,0.01123,0.014366,0.016904,0.014174,0.012137,0.011152,0.014716,0.016802,0.013958,0.01222,0.011335,0.014502,0.016986,0.014073,0.012134,0.011175,0.014836,0.01684,0.013896,0.012285,0.011368,0.0147,0.016713,0.013947,0.012187,0.011246,0.014832,0.016843,0.013766:5
4.3233E-6,5.8367E-6,5.8667E-7,4.0067E-6,2.59E-6,5.97E-6,6.43E-6,5.9333E-7,4.5233E-6,3.0933E-6,5.9633E-6,5.3E-6,3.1667E-7,5.2867E-6,3.5667E-6,5.2333E-6,6.4633E-6,-5.7333E-7,5.08E-6,2.86E-6,5.4733E-6,5.9933E-6,1.3667E-7,4.1933E-6,4.7333E-6,4.76E-6,4.8967E-6,1.7467E-6,4.4567E-6,3.4133E-6,5.3967E-6,5.3333E-6,-2.4333E-7,4.4167E-6,3.9567E-6,5.8333E-6,5.46E-6,1.1E-7,4.7633E-6,2.77E-6,5.2567E-6,5.52E-6,4.9667E-7,5.2467E-6,2.9933E-6,5.77E-6,4.98E-6,5.5E-7,4.5667E-6,3.3833E-6,5.5033E-6,4.8767E-6,-1.0333E-7,4.6E-6,2.16E-6,4.6233E-6,4.7667E-6,-4.0333E-7,4.2333E-6,4.0267E-6,5.32E-6,5.2967E-6,-1.3333E-8,4.4367E-6,4.1467E-6,5.7533E-6,0.0087812,0.014342,0.010862,0.012497,0.016007,0.01641,0.013894,0.011178,0.012135,0.015999,0.016264,0.013736,0.011121,0.012233,0.01607,0.01638,0.01375,0.011181,0.012146,0.016167,0.016254,0.013487,0.011259,0.012104,0.016118,0.016379,0.013583,0.011313,0.012231,0.016239,0.016311,0.013569,0.011269,0.012188,0.016094,0.016249,0.013344,0.011107,0.011985,0.016071,0.016281,0.013455,0.01124,0.012105,0.015942,0.016257,0.013484,0.011227,0.01212,0.016033,0.016016,0.013409,0.011244,0.01213,0.016069,0.01625,0.013379,0.01117,0.012078,0.016265,0.016122,0.013334,0.011113,0.012198,0.016347,0.016046,0.013242,0.011077,0.012406,0.016269,0.016027,0.013132,0.01129,0.012312,0.016207,0.01586,0.013304,0.011203,0.012141,0.01617,0.016033,0.013273,0.011125,0.012317,0.016355,0.015952,0.013161,0.011079,0.012437,0.016325,0.015809,0.013236,0.011247,0.012354,0.016238,0.015981,0.013197,0.011131,0.012196,0.016427,0.015881,0.013009,0.011067,0.012552,0.016305,0.015737,0.012941,0.011209,0.012442,0.01629,0.015912,0.013114,0.011135,0.012327,0.016433,0.015769,0.013,0.011048,0.012713,0.016391,0.015643,0.012847,0.011196,0.012528,0.016299,0.015769,0.013066,0.011121,0.012482,0.016501,0.015702,0.012884,0.011075,0.012775:5
2.3767E-6,2.51E-6,1.1767E-6,-1.3E-7,2.02E-6,1.5933E-6,2.3967E-6,1.8533E-6,1.1633E-6,1.97E-6,5.3333E-8,2.3367E-6,3.6633E-6,4.4667E-7,2.3E-6,1.0967E-6,1.9767E-6,2.1967E-6,7.2E-7,1.1933E-6,1.04E-6,2.1433E-6,2.7133E-6,1.0133E-6,2.57E-6,8.6333E-7,1.9067E-6,2.3733E-6,1.4533E-6,9.7089E-4,0.0059779,0.0069767,0.0069116,0.0059024,0.005099,0.0060795,0.0069448,0.0068835,0.0059526,0.0050623,0.0061362,0.0069385,0.0068861,0.005963,0.0050338,0.005337,0.010434,0.010437,0.0090801,0.0076112,0.0092412,0.010445,0.010448,0.0090518,0.0076168,0.0092348,0.010448,0.010482,0.0090827,0.0076325,0.0092341,0.010452,0.010472,0.0090836,0.0076491,0.0092427,0.010458,0.010543,0.009104,0.0076578,0.0092345,0.010502,0.010548,0.0091214,0.007668,0.0092375,0.010492,0.01056,0.0091591,0.0076797,0.0092496,0.010554,0.010567,0.009192,0.0076698,0.0092538,0.010493,0.010568,0.009203,0.0076451,0.0092595,0.010518,0.010568,0.0092236,0.0076765,0.0092202,0.010497,0.010578,0.0092126,0.007663,0.0092311,0.010494,0.010573,0.0092385,0.0076468,0.0092072,0.010516,0.010592,0.0092467,0.0076582,0.0091946,0.010478,0.010579,0.0092535,0.0076928,0.0091808,0.01047,0.010612,0.0092711,0.0076927,0.0091844,0.010468,0.010603,0.0092663,0.0076711,0.0091728,0.010437,0.010573,0.0093092,0.0076734,0.0091627,0.010411,0.010625,0.009289,0.0076494,0.0091473,0.010444,0.010648,0.0093008,0.0076743,0.0091279,0.010403,0.010628,0.0093335,0.0076597,0.0091143,0.01042,0.010642,0.0092979,0.0076796,0.009097,0.010395,0.010655,0.0093452,0.007662,0.0091114,0.010397,0.010651,0.0093939,0.0076873,0.0090621,0.010374,0.010648,0.0093425,0.0076661,0.0090794,0.010388,0.010663,0.0093576,0.0076664,0.009109,0.010374,0.010659,0.009388,0.0076641,0.0090805,0.01034,0.010684,0.0093989,0.0076568,0.0090712,0.01033,0.010668,0.0094177,0.007657,0.0090852,0.01035,0.010691,0.0094238,0.0076831,0.0090393,0.010327,0.010682,0.0094429,0.0076713,0.0090377,0.010319,0.010715,0.0094478,0.0076822,0.0090345,0.010335,0.010714,0.0094706,0.0076736,0.009039,0.010299,0.010713,0.0094579,0.0077103,0.0090129,0.010297,0.010706,0.009484,0.0076702,0.0090118,0.010285,0.010703,0.0095006,0.0076616,0.0090273,0.010237,0.010707,0.0095055,0.0076917,0.0089571,0.010301,0.010799,0.0095187,0.0076786,0.0089556,0.010285,0.010764,0.0095377,0.0076862,0.0089608,0.010267,0.010756,0.0095545,0.0076621,0.0089423,0.010275,0.010716,0.0095289,0.0076843,0.0089658,0.010244,0.010712,0.0095605,0.0076787,0.0089274,0.010227,0.010753,0.0095686,0.0077224,0.0089371,0.010255,0.010751,0.0095824,0.0076936,0.0089332,0.010292,0.010761,0.0096087,0.0077129,0.0089155,0.010276,0.010769,0.0095948,0.0077238,0.008904,0.010226,0.010768,0.0096201,0.0077097,0.0089132,0.010233,0.010766,0.0096441,0.0077049,0.0089056,0.010239,0.010808,0.0096255,0.0077302,0.0088678,0.010242,0.010788,0.0096479,0.0077278,0.0089104,0.010203,0.010823,0.0096909,0.0077519,0.0088788,0.010198,0.010814,0.0096611,0.0077314,0.0088368,0.010204,0.010784,0.0096934,0.0077345,0.0088211,0.0102,0.010792,0.0097199,0.0077357,0.0088456,0.010146,0.010784,0.0097013,0.0077237,0.0088236,0.010167,0.010802,0.0097171,0.0077215,0.0088404,0.010178,0.010794,0.0097529,0.0077581,0.0088283,0.010123,0.010801,0.0097304,0.0077372,0.0088078,0.010124,0.010799,0.0097827,0.0077366,0.0088062,0.010148,0.010796,0.0098015,0.0077718,0.0087801,0.010117,0.010815,0.0097779,0.007785,0.0088083,0.010158,0.010798,0.009777,0.0077584,0.0087614,0.010085,0.010808,0.0098016,0.0077783,0.0087888,0.010078,0.010815,0.009826,0.0077556,0.0087368,0.010059,0.010795,0.0098503,0.0077441,0.0087268,0.010066,0.010817,0.0098396,0.0077825,0.0087582,0.010044,0.010805,0.0098481,0.007796,0.0087123,0.010029,0.010819,0.0098457,0.0077938,0.0087052,0.010042,0.010832,0.0099052,0.0078008,0.0087112,0.01006,0.010837,0.0099323,0.0077995,0.008699,0.010024,0.010809,0.0099189,0.0078143,0.0086961,0.010025,0.010867,0.0099163,0.0078192,0.0086641,0.010007,0.010801,0.0099304,0.0078178,0.0086768,0.0099785,0.01085,0.0099363,0.0078179,0.0086736,0.0099843,0.010842,0.0099706,0.0078453,0.00865,0.010008,0.010871,0.01002,0.0078436,0.0086239,0.0099257,0.010798,0.0099422,0.0078416,0.0086453,0.0099393,0.010817,0.009977,0.0078301,0.0085956,0.009905,0.010826,0.010026,0.0078151,0.0086358,0.0098806,0.010828,0.010025,0.0078824,0.008595,0.0099141,0.01083,0.010002,0.0078613,0.0086051,0.0098974,0.010846,0.010001,0.0078591,0.0085892,0.0098759,0.010816,0.010029,0.007883,0.0085871,0.009856,0.010821,0.010042,0.0078749,0.0085674,0.0098842,0.010809,0.010093,0.0078743,0.0085424,0.009879,0.010827,0.010085,0.0079129,0.0085674,0.0098271,0.010846,0.010089,0.0078745,0.0085183,0.0098269,0.010828,0.010105,0.0078811,0.0085669,0.0098378,0.010815,0.010111,0.0078831,0.0085483,0.0098084,0.010817,0.010094,0.00791,0.0084898,0.0097867,0.010812,0.010136,0.0079163,0.0085392,0.0097549,0.010839,0.010098,0.0079278,0.008508,0.0097651,0.010818,0.010151,0.0079292,0.0084995,0.009763,0.01081,0.01014,0.0079101,0.0085133,0.0097438,0.010815,0.010152,0.0079414,0.0085028,0.009709,0.010817,0.010163,0.0079634,0.0085024,0.009722,0.01083,0.010158,0.0079744,0.008503,0.0097521,0.01082,0.010195,0.0079483,0.0084806,0.0097051,0.010811,0.010195,0.0079741,0.0084796,0.0097048,0.010835,0.010227,0.0079628,0.0084552,0.0096798,0.010813,0.010235,0.0079851,0.0084592,0.0096737,0.010821,0.010196,0.0079787,0.0084552,0.0096542,0.010858,0.01024,0.0079538,0.0084452,0.009671,0.010841,0.010252,0.008,0.0084335,0.009613,0.010837,0.01024,0.0080072,0.0084298,0.009624,0.010799,0.010291,0.008028,0.0084432,0.009589,0.010818,0.01026,0.0080361,0.0084147,0.0073027:5
1.1E-7,1.1E-6,1.6667E-8,1.9767E-6,6.7333E-7,5.1667E-7,1.36E-6,1.49E-6,4.9E-7,1.91E-6,4.5333E-7,1.6167E-6,1.1033E-6,1.3433E-6,1.29E-6,1.2267E-6,1.6367E-6,9.8333E-7,8.1E-7,1.9333E-6,6.3333E-7,1.6767E-6,8.5333E-7,1.6433E-6,2.1E-6,-3.7E-7,1.5133E-6,4.3333E-8,2.18E-6,1.41E-6,-6.5E-7,1.78E-6,1.3767E-6,1.4867E-6,1.3033E-6,-1.2E-7,1.68E-6,7.5333E-7,8.8667E-7,0.0050573,0.005886,0.0050524,0.0067558,0.007143,0.0064921,0.0056671,0.004944,0.0026333,0.010676,0.0096629,0.0088798,0.0076611,0.010174,0.010787,0.0098306,0.0085624,0.0078627,0.010034,0.010809,0.011764,0.013185,0.012263,0.015429,0.016692,0.015349,0.013147,0.012282,0.015421,0.016729,0.015315,0.013144,0.012299,0.015438,0.016691,0.015302,0.013125,0.012281,0.015392,0.016695,0.015318,0.01313,0.012279,0.01539,0.016704,0.015289,0.013135,0.012257,0.015401,0.016655,0.015337,0.013157,0.012289,0.015428,0.016724,0.015309,0.013159,0.01224,0.015403,0.016759,0.015348,0.013182,0.01223,0.015405,0.016726,0.015341,0.013153,0.012254,0.015449,0.016681,0.015354,0.013176,0.012234,0.015437,0.016738,0.015334,0.013211,0.01228,0.015398,0.016708,0.015318,0.013201,0.01225,0.015407,0.016722,0.015328,0.013157,0.012245,0.01544,0.016726,0.015375,0.013191,0.012268,0.015441,0.016687,0.015358,0.013168,0.012284,0.015422,0.016702,0.015382,0.013178,0.012264,0.015372,0.016715,0.015379,0.013156,0.012272,0.015403,0.016749,0.015414,0.013135,0.012247,0.015466,0.016718,0.01534,0.013219,0.012275,0.015409,0.016733,0.015324,0.013183,0.012271,0.015391,0.016713,0.015375,0.013156,0.012263,0.01538,0.01665,0.015291,0.013155,0.012258,0.015388,0.016722,0.015345,0.013125,0.012227,0.015383,0.016727,0.015332,0.013156,0.012263,0.015403,0.016688,0.015317,0.01315,0.01227,0.01542,0.016712,0.015339,0.013139,0.012295,0.015415,0.016698,0.015324,0.013174,0.012262,0.015417,0.016612,0.015318,0.013153,0.01225,0.015411,0.01665,0.015292,0.013074,0.012251,0.015377,0.016669,0.015328,0.013148,0.012237,0.015386,0.016678,0.015266,0.013127,0.012199,0.015366,0.016674,0.015331,0.013147,0.012232,0.015384,0.016624,0.015268,0.013123,0.012218,0.015354,0.016657,0.015264,0.013135,0.012253,0.015383,0.016631,0.015324,0.013078,0.012269,0.015345,0.016689,0.015324,0.013113,0.012252,0.015373,0.016642,0.015342,0.013164,0.012258,0.01537,0.016694,0.015329,0.013139,0.012265,0.015412,0.016647,0.015334,0.013134,0.01226,0.015382,0.016662,0.015272,0.013135,0.012247,0.015353,0.016741,0.015312,0.01312,0.012207,0.015388,0.016679,0.015343,0.013143,0.012232,0.015385,0.016641,0.01529,0.013122,0.012222,0.015415,0.016711,0.015333,0.013125,0.012234,0.015373,0.016682,0.015296,0.013129,0.01223,0.015364,0.016694,0.015325,0.013124,0.012233,0.015364,0.016623,0.015295,0.013125,0.01226,0.015433,0.016678,0.015275,0.013156,0.012256,0.015416,0.016696,0.015328,0.013192,0.012264,0.015384,0.016622,0.015328,0.013118,0.012239,0.015381,0.016666,0.01527,0.013124,0.012262,0.015384,0.016651,0.015257,0.013133,0.012238,0.01536,0.016656,0.015337,0.013134,0.012228,0.015384,0.016698,0.015318,0.013106,0.01223,0.015359,0.016694,0.015322,0.013147,0.012232,0.01538,0.016702,0.015294,0.013127,0.012209,0.015376,0.016681,0.015271,0.013139,0.012238,0.015382,0.016697,0.015307,0.013103,0.012233,0.0154,0.016644,0.015328,0.013132,0.012254,0.015349,0.016659,0.015257,0.013135,0.01227,0.015393,0.016671,0.015287,0.013139,0.012228,0.015332,0.016687,0.015331,0.013138,0.012228,0.015364,0.016644,0.015289,0.013107,0.012285,0.01539,0.016662,0.015291,0.013065,0.012204,0.015397,0.016675,0.015324,0.013129,0.012278,0.015444,0.016646,0.015288,0.013149,0.012238,0.015378,0.016681,0.015274,0.013102,0.012242,0.015397,0.016675,0.015348,0.013141,0.01223,0.015393,0.016689,0.015283,0.01313,0.012238,0.015382,0.01665,0.015262,0.013157,0.012248,0.015403,0.016673,0.015287,0.013132,0.012244,0.015356,0.016676,0.015269,0.01318,0.012221,0.015365,0.016651,0.015288,0.013105,0.012242,0.015399,0.016665,0.015324,0.013119,0.012282,0.015421,0.016694,0.015287,0.013153,0.012264,0.015348,0.016697,0.015279,0.013094,0.012231,0.015461,0.01668,0.015327,0.013084,0.012232,0.015418,0.016653,0.015296,0.01309,0.012234,0.015397,0.016699,0.015281,0.013128,0.011128:5
1.2233E-6,2.6533E-6,-1.8667E-6,2.2033E-6,-2.6E-7,-1.9333E-7,1.3767E-6,-2.4033E-6,1.8067E-6,5.6E-7,7.8333E-7,2.08E-6,-7.7667E-7,3.13E-6,-1.0133E-6,6.6333E-7,1.4567E-6,-2.0133E-6,1.8867E-6,-7.7E-7,3.9333E-7,2.71E-6,4.106E-4,3.8418E-4,4.0815E-4,4.7769E-4,4.8875E-4,3.653E-4,3.6622E-4,4.1522E-4,4.8445E-4,0.0048089,0.0059445,0.0054646,0.0072131,0.0074734,0.006241,0.005737,0.0057002,0.0098095,0.016345,0.013547,0.012554,0.012365,0.015707,0.016373,0.013748,0.012465,0.012558,0.015791,0.016525,0.013961,0.012576,0.012744,0.015873,0.016685,0.014129,0.01268,0.012861,0.016082,0.016848,0.014194,0.012799,0.012996,0.016238,0.016995,0.014379,0.012927,0.013056,0.016361,0.017105,0.014423,0.013003,0.013184,0.016455,0.017254,0.014579,0.013098,0.013338,0.016652,0.017429,0.014695,0.013215,0.013443,0.016734,0.01755,0.014823,0.013287,0.013491,0.016839,0.017674,0.014851,0.013387,0.013558,0.016962,0.017763,0.014968,0.013466,0.013613,0.017054,0.01783,0.015074,0.013579,0.01376,0.017154,0.017979,0.015152,0.013659,0.013815,0.017216,0.018123,0.015257,0.013678,0.013916,0.017381,0.018127,0.015294,0.013837,0.013931,0.017432,0.018261,0.015354,0.013927,0.014103,0.017564,0.018396,0.015532,0.013876,0.014099,0.017609,0.018509,0.015528,0.014032,0.014228,0.017716,0.018489,0.015655,0.014077,0.014308,0.017856,0.018673,0.015706,0.014114,0.014272,0.017874,0.018738,0.015786,0.01418,0.014394,0.017942,0.018806,0.015878,0.014251,0.01443,0.018018,0.018911,0.015916,0.014327,0.014532,0.018182,0.019002,0.015955,0.014399,0.014567,0.018198,0.019083,0.015983,0.014469,0.014638,0.01825,0.019115,0.016085,0.014481,0.014749,0.018334,0.019145,0.016231,0.014559,0.014685,0.018419,0.019265,0.016217,0.014623,0.014773,0.018499,0.019345,0.016323,0.014678,0.014805,0.018531,0.019383,0.016348,0.01472,0.014904,0.018594,0.019452,0.016422,0.01477,0.014883,0.018615,0.019507,0.016484,0.014876,0.01495,0.018709,0.019504,0.016504,0.014811,0.015038,0.018746,0.01957,0.016509,0.014929,0.015074,0.018843,0.019652,0.016629,0.01494,0.015077,0.01887,0.019748,0.016659,0.014967,0.015112,0.018912,0.019781,0.016743,0.014988,0.015149,0.018936,0.019814,0.01674,0.015092,0.015193,0.019082,0.019925,0.016855,0.015108,0.01525,0.019033,0.019947,0.016854,0.015136,0.015326,0.019096,0.019949,0.016895,0.015182,0.015307,0.019178,0.020049,0.016949,0.015208,0.015372,0.019181,0.020014,0.016948,0.015209,0.015321,0.019259,0.020074,0.016983,0.015218,0.015438,0.019263,0.020136,0.017071,0.015237,0.015464,0.01923,0.02017,0.017036,0.015373,0.015545,0.019389,0.020231,0.017127,0.015333,0.015524,0.019349,0.02029,0.017133,0.01536,0.015521,0.019425,0.020352,0.017214,0.015404,0.015576,0.019404,0.020388,0.017256,0.015417,0.015555,0.019472,0.020379,0.017246,0.015486,0.015547,0.019504,0.020401,0.017259,0.01548,0.015605,0.01951,0.020388,0.017345,0.015519,0.015648,0.019526,0.020508,0.017347,0.015502,0.015686,0.019601,0.020465,0.017382,0.015542,0.015722,0.019596,0.020515,0.017412,0.015527,0.015776,0.019604,0.020628,0.017436,0.015623,0.015769,0.019707,0.020617,0.017465,0.01568,0.015755,0.019669,0.020607,0.017477,0.015665,0.015813,0.019734,0.020753,0.017535,0.015665,0.015816,0.019802,0.020719,0.017561,0.01574,0.015846,0.019751,0.020795,0.017497,0.015733,0.015914,0.019786,0.020753,0.01758,0.01578,0.015879,0.019826,0.020805,0.017548,0.015772,0.015919,0.019912,0.020758,0.01762,0.015806,0.01589,0.019883,0.020821,0.01764,0.015837,0.016022,0.019912,0.020818,0.017722,0.015848,0.015915,0.019961,0.020957,0.01771,0.015876,0.015974,0.019954,0.020922,0.017747,0.015932,0.016,0.020041,0.020937,0.017741,0.015918,0.016046,0.019987,0.020956,0.017706,0.015853,0.016013,0.020027,0.020998,0.017758,0.015948,0.0058732:5
1.3833E-6,2.14E-6,-2.9667E-7,1.9267E-6,6.6667E-9,1.2767E-6,8.0E-7,-6.0333E-7,2.43E-6,-1.6667E-7,2.2667E-7,-1.4667E-7,-1.04E-6,1.8633E-6,-3.4E-7,2.3E-7,1.5E-6,-7.9E-7,1.2467E-6,-6.0E-7,8.9333E-7,1.2267E-6,-3.6667E-8,1.5233E-6,1.6667E-8,1.41E-6,1.83E-6,-2.53E-6,3.9117E-4,3.9834E-4,4.0422E-4,4.8952E-4,4.7229E-4,3.3752E-4,3.8725E-4,4.0516E-4,4.9713E-4,4.6648E-4,3.4761E-4,0.0041759,0.0085853,0.0088416,0.0077262,0.006354,0.0075186,0.0086232,0.0089685,0.0078397,0.007753,0.015651,0.018278,0.018711,0.016337,0.01353,0.015828,0.018279,0.018817,0.016579,0.013559,0.015994,0.018334,0.019017,0.016696,0.013693,0.016106,0.018487,0.019214,0.016981,0.013715,0.016234,0.018623,0.019339,0.017054,0.013865,0.016307,0.018675,0.019456,0.017188,0.01397,0.016386,0.018792,0.019621,0.017335,0.014068,0.016433,0.018855,0.01965,0.017454,0.014058,0.016492,0.018912,0.019774,0.017523,0.014153,0.016627,0.018999,0.019907,0.017697,0.014247,0.016586,0.019109,0.020024,0.017729,0.014345,0.01671,0.019166,0.020113,0.017878,0.014397,0.016743,0.019178,0.020265,0.017998,0.014481,0.016797,0.019271,0.020325,0.018057,0.014561,0.016835,0.019354,0.020449,0.018207,0.014604,0.016911,0.01944,0.02051,0.018313,0.01467,0.017037,0.019485,0.02061,0.018407,0.01474,0.017008,0.019491,0.0207,0.018503,0.014749,0.017101,0.019617,0.020792,0.018638,0.014858,0.017052,0.01966,0.020774,0.01866,0.014879,0.017126,0.019671,0.02092,0.01877,0.014973,0.017126,0.019625,0.021006,0.018839,0.015019,0.017172,0.019693,0.020975,0.018963,0.01506,0.017186,0.01972,0.021093,0.01901,0.015051,0.017147,0.019729,0.021126,0.019058,0.015195,0.017178,0.019771,0.02118,0.019164,0.015162,0.017252,0.019757,0.021251,0.019241,0.015238,0.017256,0.019793,0.021262,0.019276,0.015231,0.01727,0.01984,0.021278,0.019387,0.015303,0.017302,0.01974,0.021416,0.019421,0.01529,0.017271,0.01984,0.021447,0.01946,0.015382,0.017344,0.019895,0.021469,0.019602,0.015429,0.017296,0.019852,0.021554,0.019649,0.015459,0.017346,0.01993,0.021558,0.019712,0.015484,0.017372,0.019932,0.021614,0.019758,0.015535,0.017246,0.019856,0.021652,0.019782,0.015562,0.017349,0.019906,0.021611,0.019846,0.015639,0.017401,0.01985,0.021682,0.019922,0.015649,0.017341,0.019962,0.021742,0.020039,0.015631,0.017379,0.019927,0.021785,0.020072,0.015742,0.01732,0.019908,0.021728,0.020079,0.015721,0.017301,0.019827,0.021776,0.02014,0.015781,0.017273,0.019788,0.021802,0.020185,0.015779,0.017238,0.01976,0.021815,0.020284,0.015783,0.017296,0.019795,0.021863,0.020391,0.015873,0.017332,0.019814,0.021853,0.020361,0.015857,0.017331,0.019837,0.021898,0.020368,0.015916,0.017299,0.019751,0.021925,0.020412,0.015996,0.017299,0.01981,0.021912,0.020554,0.016014,0.017309,0.019751,0.021965,0.020474,0.015968,0.017315,0.019728,0.022002,0.020555,0.016064,0.017225,0.019654,0.021972,0.020579,0.016042,0.017246,0.019686,0.021919,0.020592,0.016049,0.017218,0.01964,0.022,0.020732,0.016056,0.017219,0.019595,0.021977,0.020703,0.016106,0.017205,0.019573,0.022001,0.020789,0.016081,0.017177,0.019613,0.021989,0.020752,0.016222,0.017141,0.019498,0.021977,0.020764,0.01622,0.017148,0.019454,0.021943,0.020813,0.016219,0.01718,0.019424,0.021983,0.020839,0.016213,0.01716,0.019434,0.022019,0.020937,0.01632,0.017057,0.019399,0.022033,0.020948,0.016316,0.017097,0.01934,0.021977,0.021051,0.016349,0.017004,0.019334,0.022002,0.020987,0.016359,0.017048,0.019377,0.021943,0.021075,0.016395,0.017035,0.019299,0.022051,0.021018,0.016343,0.017022,0.01922,0.021939,0.021145,0.016399,0.017025,0.019138,0.021949,0.021219,0.016383,0.016985,0.019114,0.021949,0.021079,0.016435,0.01696,0.019076,0.021932,0.02115,0.016464,0.016959,0.019032,0.021869,0.021159,0.016452,0.016929,0.018997,0.021963,0.021201,0.016518,0.01696,0.018972,0.021947,0.021223,0.016577,0.01695,0.018979,0.021922,0.021277,0.016517,0.016907,0.018894,0.02191,0.021246,0.016579,0.016898,0.018811,0.021829,0.021306,0.016588,0.01689,0.018837,0.021896,0.021268,0.016614,0.016829,0.018765,0.021978,0.021325,0.016641,0.016901,0.018752,0.021846,0.021337,0.016701,0.016809,0.018757,0.02187,0.021386,0.016694,0.016835,0.018701,0.02185,0.021437,0.016699,0.016816,0.018688,0.021843,0.021415,0.016783,0.016798,0.018602,0.021846,0.021449,0.016786,0.016781,0.018547,0.021859,0.021392,0.01684,0.01672,0.0186,0.021814,0.02141,0.016892,0.016696,0.018456,0.021736,0.021465,0.016784,0.016749,0.018488,0.021762,0.021492,0.01694,0.016757,0.018395,0.021729,0.021512,0.01691,0.016745,0.018452,0.021745,0.021482,0.016925,0.016737,0.018359,0.021733,0.02156,0.016929,0.016673,0.018343,0.02171,0.021529,0.016933,0.01664,0.018237,0.021669,0.02152,0.016925,0.01664,0.018308,0.021558,0.021503,0.0019732:5
6.51E-6,1.8167E-6,3.3267E-6,5.02E-6,4.6333E-7,4.6233E-6,2.6467E-6,4.5967E-6,5.2833E-6,-1.4667E-7,5.65E-6,3.7233E-6,2.9133E-6,6.18E-6,-7.6667E-8,5.41E-6,3.1533E-6,3.4267E-6,4.68E-6,2.4E-7,5.5233E-6,3.6033E-6,0.0081909,0.010493,0.0090082,0.0099341,0.011802,0.012191,0.010305,0.0092587,0.0097317,0.011911,0.012202,0.010258,0.009319,0.009697,0.011915,0.012204,0.010301,0.009311,0.0096764,0.01191,0.012204,0.010253,0.0093346,0.0096268,0.011896,0.012201,0.01031,0.0093553,0.0096369,0.011914,0.012219,0.010303,0.0093234,0.0096109,0.011872,0.012199,0.010321,0.009352,0.0096623,0.011902,0.012241,0.010341,0.0093732,0.0095763,0.011879,0.012225,0.010354,0.0093555,0.0095478,0.011899,0.012257,0.01036,0.0093781,0.009579,0.011863,0.012261,0.01038,0.0093827,0.0095615,0.011841,0.012216,0.010403,0.0093737,0.0095495,0.011833,0.012224,0.010437,0.0093666,0.0095229,0.011807,0.012231,0.010422,0.009371,0.009528,0.011777,0.012238,0.010432,0.0093561,0.0095062,0.011773,0.012238,0.010451,0.0093676,0.0095121,0.011807,0.012229,0.010463,0.0093852,0.0094929,0.011805,0.012251,0.010497,0.0093908,0.0094493,0.011761,0.012239,0.010494,0.009372,0.0094883,0.011794,0.012247,0.01051,0.0093854,0.0094347,0.011763,0.012216,0.010542,0.0093812,0.009432,0.011769,0.012253,0.010542,0.0094053,0.0094593,0.01175,0.012244,0.010548,0.0094078,0.0094107,0.011721,0.012242,0.010557,0.0093967,0.0094229,0.011745,0.012244,0.010602,0.0094057,0.0094132,0.01172,0.012229,0.010619,0.0094392,0.0093811,0.011707,0.012264,0.010609,0.0094381,0.0093678,0.011696,0.012247,0.010624,0.009419,0.0093586,0.0117,0.012224,0.010667,0.0094258,0.0093651,0.011699,0.012226,0.010684,0.0094532,0.0093555,0.011668,0.012227,0.010681,0.0094285,0.0093047,0.011681,0.012222,0.010711,0.0094549,0.0093094,0.011654,0.012208,0.010733,0.0094559,0.0092834,0.011645,0.012242,0.010743,0.009481,0.0092746,0.011648,0.012245,0.010761,0.0094492,0.0092781,0.011586,0.012252,0.010759,0.009471,0.0092413,0.011637,0.012248,0.01081,0.0094931,0.0092775,0.011614,0.012255,0.01081,0.0095015,0.0092665,0.011621,0.012254,0.010832,0.0095039,0.0092469,0.011596,0.012228,0.010817,0.0094734,0.0092241,0.011556,0.012243,0.010839,0.0095058,0.0092088,0.01157,0.012202,0.010862,0.0094811,0.0092128,0.01154,0.012237,0.010875,0.0094945,0.0092325,0.011525,0.012229,0.010892,0.0095164,0.009183,0.01157,0.012242,0.01092,0.0094936,0.0092016,0.01153,0.012207,0.010899,0.0095343,0.0091944,0.011511,0.012227,0.010952,0.0095474,0.0091912,0.011517,0.012239,0.010961,0.0095207,0.009153,0.011509,0.012211,0.010944,0.0095464,0.0091455,0.011502,0.012204,0.01099,0.0095759,0.0091532,0.011478,0.012198,0.010985,0.0095585,0.0091133,0.011459,0.012216,0.010999,0.0095984,0.0091151,0.01146,0.012192,0.011044,0.009582,0.0091283,0.011452,0.012197,0.011061,0.009576,0.0090829,0.011445,0.012222,0.011031,0.0096037,0.0090948,0.011415,0.012195,0.011092,0.0095868,0.0090775,0.011424,0.012191,0.011084,0.0096074,0.0090715,0.011399,0.012191,0.011101,0.0096297,0.0090427,0.011403,0.012216,0.011084,0.0096152,0.0090502,0.011381,0.012217,0.011122,0.0096502,0.0090324,0.011365,0.012196,0.011132,0.0096635,0.0090386,0.01134,0.012184,0.011164,0.0096534,0.0090421,0.011318,0.012203,0.011174,0.0096643,0.0089855,0.011322,0.012197,0.011201,0.0097053,0.0089842,0.011322,0.012153,0.011208,0.009721,0.0089969,0.011305,0.012205,0.011202,0.0097115,0.0089682,0.011279,0.012175,0.01121,0.0097458,0.0089912,0.011248,0.012192,0.011181,0.0097432,0.008945,0.0088312:5
5.08E-6,1.2467E-6,5.3867E-6,2.7433E-6,4.0567E-6,4.57E-6,3.6667E-8,6.36E-6,1.09E-6,3.72E-6,5.1767E-6,3.8333E-7,5.7967E-6,1.7133E-6,5.0033E-6,1.59E-6,-1.4667E-7,6.4433E-6,2.91E-6,4.3167E-6,5.7767E-6,5.8667E-7,5.9633E-6,0.0029756,0.011853,0.010832,0.0098132,0.0085584,0.011179,0.011899,0.010944,0.0096013,0.0087124,0.011079,0.011936,0.01098,0.0095552,0.0088099,0.011066,0.011929,0.011004,0.0095068,0.0087518,0.011038,0.01192,0.011018,0.0095184,0.008763,0.011015,0.011916,0.011001,0.0095507,0.0087474,0.011038,0.011913,0.011021,0.0095258,0.0087404,0.011011,0.011909,0.01103,0.0095452,0.0087661,0.010998,0.011917,0.011009,0.0095741,0.0087229,0.010982,0.011925,0.011029,0.0095481,0.0087381,0.011014,0.011902,0.011059,0.0095567,0.0087312,0.010982,0.011907,0.011086,0.009541,0.0087466,0.010984,0.011913,0.01106,0.009574,0.0087216,0.010997,0.011934,0.011074,0.0095791,0.0087122,0.01096,0.011932,0.011062,0.009599,0.0087046,0.010958,0.011885,0.011091,0.0095668,0.0087431,0.010969,0.011908,0.011088,0.0095956,0.0087085,0.010948,0.011899,0.011097,0.0095872,0.0086836,0.010929,0.011901,0.011124,0.0095842,0.0087115,0.010932,0.011885,0.01113,0.0096179,0.0087479,0.010931,0.011929,0.011145,0.0096009,0.0087092,0.010916,0.011909,0.011125,0.009621,0.0086892,0.010907,0.011941,0.011154,0.0096259,0.008703,0.010955,0.011929,0.01115,0.0096232,0.0087012,0.010926,0.011921,0.011137,0.0096401,0.0087024,0.010897,0.011924,0.011146,0.0096257,0.0086918,0.010914,0.011888,0.011175,0.0096367,0.0087147,0.010901,0.011891,0.011169,0.0096416,0.0087111,0.010886,0.011887,0.011161,0.0096434,0.008688,0.01086,0.011919,0.011192,0.0096414,0.0086657,0.010881,0.011917,0.011176,0.009671,0.0086698,0.010881,0.011913,0.011184,0.0096563,0.0086908,0.010899,0.011905,0.011186,0.0097009,0.0086876,0.010869,0.011898,0.011217,0.0096592,0.0086811,0.010876,0.01191,0.011197,0.0096823,0.0087056,0.010878,0.011904,0.011251,0.009667,0.0086701,0.01084,0.011892,0.011229,0.0096955,0.0086587,0.010825,0.011896,0.011231,0.0096696,0.0086556,0.010832,0.011875,0.011226,0.0097358,0.0086462,0.010856,0.011862,0.011259,0.0097192,0.0086555,0.010803,0.011878,0.011239,0.009696,0.0086436,0.010791,0.011874,0.011242,0.0097001,0.008632,0.010785,0.011847,0.011244,0.0097424,0.0086257,0.010774,0.011843,0.011269,0.0097412,0.0086651,0.01076,0.011836,0.011262,0.0097142,0.0086576,0.010761,0.011876,0.01128,0.0097412,0.0086517,0.010757,0.011888,0.01129,0.0097446,0.00862,0.010754,0.011855,0.011291,0.0097324,0.0086476,0.010738,0.011838,0.011248,0.009724,0.0086262,0.010729,0.011893,0.01129,0.0097835,0.0086553,0.010762,0.011857,0.011296,0.0097724,0.0086008,0.010736,0.011832,0.011308,0.0097556,0.008628,0.010744,0.01186,0.011318,0.0097794,0.0086235,0.010715,0.011812,0.011237,0.0097626,0.0085926,0.010689,0.011838,0.011304,0.0097591,0.0086114,0.01066,0.011809,0.011293,0.0097862,0.0085832,0.010685,0.011829,0.011303,0.0097908,0.00861,0.010658,0.011828,0.011253,0.0097802,0.0085847,0.010642,0.011807,0.011277,0.0097834,0.0086041,0.010652,0.011812,0.011302,0.00979,0.0085794,0.010669,0.011834,0.011356,0.0097977,0.0085698,0.010638,0.011818:5
1.9267E-6,5.4733E-6,1.94E-6,5.0533E-6,5.7733E-6,1.6667E-7,6.1767E-6,-7.8667E-7,5.9633E-6,4.8733E-6,-2.6667E-7,5.81E-6,4.3667E-7,5.0667E-6,2.54E-6,2.9567E-6,5.66E-6,-9.0333E-7,5.05E-6,4.4333E-6,9.0333E-7,5.0233E-6,1.3767E-6,4.85E-6,3.6733E-6,2.21E-6,5.92E-6,0.0073831,0.011521,0.011993,0.010856,0.008803,0.009694,0.011359,0.01202,0.010966,0.008752,0.0097757,0.011313,0.01199,0.01096,0.0087204,0.0097472,0.011287,0.012007,0.011009,0.0087127,0.009778,0.01129,0.011996,0.011003,0.0087373,0.0097464,0.011271,0.011994,0.011028,0.0087404,0.0097581,0.011228,0.012019,0.01104,0.0087213,0.0097507,0.011237,0.012007,0.011019,0.0087339,0.0097256,0.011204,0.011978,0.011048,0.0087046,0.0097094,0.011201,0.011973,0.011046,0.0087551,0.009668,0.011186,0.01199,0.011052,0.0087405,0.0096776,0.011162,0.011966,0.011032,0.0087257,0.0096806,0.011163,0.011999,0.011123,0.0087551,0.0096973,0.011171,0.011992,0.011128,0.0087535,0.0096806,0.011161,0.01201,0.011097,0.0087761,0.0096825,0.011154,0.01201,0.011146,0.0088097,0.0096632,0.011194,0.012042,0.011175,0.0087859,0.0096843,0.011119,0.012023,0.011168,0.0087989,0.0096211,0.011114,0.011964,0.011173,0.0087996,0.0096609,0.01111,0.012001,0.011167,0.0088317,0.0096244,0.0111,0.012002,0.011177,0.0088018,0.009597,0.011031,0.012007,0.011184,0.0088188,0.0096262,0.01104,0.012004,0.011202,0.0088194,0.0095987,0.011066,0.012023,0.01126,0.0088416,0.0095769,0.011057,0.012021,0.011242,0.0088385,0.0095736,0.01101,0.011978,0.011234,0.0088411,0.0096257,0.011032,0.012012,0.011216,0.0088796,0.0095911,0.011026,0.011963,0.011272,0.0088712,0.009552,0.011007,0.01203,0.011291,0.008843,0.0095624,0.010994,0.012029,0.011275,0.008866,0.0095675,0.010971,0.012029,0.011299,0.0088943,0.0095472,0.01096,0.012004,0.011286,0.0089265,0.0095544,0.010961,0.012024,0.011292,0.0088665,0.0095131,0.010955,0.01203,0.011337,0.008902,0.0095294,0.010945,0.012025,0.01134,0.0089187,0.0095292,0.01095,0.012075,0.011354,0.0089207,0.0095056,0.010912,0.012019,0.011338,0.0089081,0.0094904,0.010907,0.012019,0.011385,0.0089439,0.0095029,0.010889,0.012033,0.011358,0.0089431,0.0094675,0.010878,0.011999,0.011359,0.0089659,0.0095151,0.010885,0.012,0.011389,0.0089689,0.0094841,0.010871,0.012002,0.011366,0.0089494,0.0094708,0.010831,0.012006,0.011409,0.0089684,0.0094657,0.010815,0.011998,0.011417,0.0090098,0.0094574,0.010836,0.012019,0.011435,0.0089588,0.0094453,0.010803,0.012026,0.011439,0.0089928,0.0094543,0.010764,0.012019,0.011449,0.0090001,0.009434,0.010788,0.012004,0.011435,0.0090322,0.0094508,0.010803,0.012024,0.01145,0.0089989,0.0094377,0.010754,0.012007,0.011476,0.0090461,0.0094318,0.010748,0.012067,0.011472,0.0090332,0.0094197,0.010746,0.012039,0.011458,0.0090562,0.0094286,0.010764,0.012057,0.011504,0.0090429,0.0094279,0.010717,0.012053,0.011513,0.0090542,0.0094413,0.010731,0.012029,0.01153,0.009072,0.0094159,0.01076,0.012021,0.011545,0.0090786,0.0094069,0.010708,0.01203,0.011555,0.0090829,0.0094133,0.010697,0.011992,0.011534,0.0090556,0.0093767,0.010661,0.011996,0.011544,0.0091101,0.0093878,0.010686,0.012026,0.011533,0.0091075,0.0093528,0.010652,0.012014,0.01155,0.009111,0.0093789,0.010635,0.012004,0.011547,0.0091112,0.0093723,0.010612,0.012042,0.011576,0.0091343,0.0093608,0.010621,0.012011,0.011573,0.0091297,0.009361,0.010572,0.011974,0.011611,0.0091446,0.0093541,0.010556,0.011996,0.011602,0.0091787,0.0093318,0.010589,0.012,0.011604,0.0091598,0.0093523,0.010541,0.012032,0.011626,0.0091835,0.0093403,0.010528,0.012003,0.011602,0.0091745,0.0093584,0.010545,0.011995,0.011639,0.0092024,0.0093601,0.01055,0.012018,0.011636,0.0091884,0.0093193,0.010511,0.012009,0.01165,0.0092257,0.0093442,0.010516,0.01205,0.011651,0.0092238,0.0093044,0.010491,0.012044,0.011662,0.0092327,0.0093394,0.010468,0.012008,0.011702,0.0092482,0.0093343,0.01046,0.012044,0.011689,0.0092669,0.0093021,0.010471,0.012009,0.011721,0.0092723,0.0093043,0.0048939:5
-4.2333E-6,-1.558E-5,-1.7397E-5,-1.85E-5,-1.6777E-5,-4.3367E-6,-1.6593E-5,-1.8453E-5,-2.0987E-5,-1.6727E-5,-4.44E-6,-1.6623E-5,-1.7623E-5,-2.018E-5,-1.6857E-5,-5.1133E-6,-1.711E-5,-1.8027E-5,-1.9917E-5,-1.6853E-5,-5.0067E-6,0.0039458,0.020193,0.016296,0.015613,0.015632,0.019605,0.02012,0.016513,0.01544,0.015702,0.019585,0.020025,0.016605,0.015333,0.015719,0.019551,0.019884,0.016721,0.015354,0.015772,0.019491,0.020042,0.016686,0.015296,0.015713,0.019553,0.02002,0.016659,0.01531,0.015657,0.019505,0.020029,0.01674,0.015292,0.015669,0.019493,0.019954,0.016826,0.01527,0.015676,0.019347,0.02006,0.01677,0.015332,0.015665,0.019287,0.020115,0.016791,0.015354,0.015525,0.019362,0.020089,0.016814,0.015293,0.015485,0.019326,0.019976,0.01692,0.015314,0.015474,0.019205,0.020017,0.016883,0.015361,0.015453,0.019266,0.020087,0.016852,0.015347,0.01535,0.019309,0.019995,0.01698,0.01536,0.015368,0.019265,0.020021,0.017087,0.015277,0.015406,0.019262,0.020044,0.017094,0.015358,0.015353,0.019182,0.020103,0.017041,0.015374,0.015291,0.019192,0.019974,0.017141,0.015322,0.015323,0.01921,0.020022,0.017207,0.015363,0.01533,0.019095,0.020154,0.017153,0.015407,0.01523,0.019083,0.020192,0.017177,0.015476,0.015133,0.019135,0.020064,0.017222,0.015462,0.015154,0.019071,0.020008,0.0173,0.015482,0.015167,0.018964,0.020123,0.017292,0.015486,0.015092,0.019032,0.020054,0.017326,0.01549,0.014991,0.019035,0.02001,0.017473,0.015462,0.015051,0.019026,0.019966,0.017495,0.015451,0.015048,0.018903,0.020089,0.017501,0.015525,0.015011,0.018866,0.020076,0.017499,0.015553,0.014975,0.018956,0.020015,0.017583,0.015558,0.014979,0.018868,0.020091,0.017581,0.015537,0.015001,0.01874,0.020147,0.017612,0.015586,0.014892,0.018793,0.020148,0.017558,0.015652,0.014833,0.018858,0.020051,0.017682,0.015587,0.014829,0.018834,0.019974,0.017763,0.015649:5
-1.7177E-5,-1.6407E-5,-2.0613E-5,-2.609E-5,-1.277E-5,-1.4967E-5,-1.7097E-5,-2.1867E-5,-2.421E-5,-1.375E-5,-1.615E-5,-1.661E-5,-2.2223E-5,-2.4443E-5,-1.412E-5,-1.586E-5,-1.62E-5,-2.194E-5,-2.3053E-5,-1.3233E-5,-1.5503E-5,-1.701E-5,-2.241E-5,-2.4197E-5,-1.444E-5,-1.5807E-5,-1.6483E-5,-2.2373E-5,-2.406E-5,-1.476E-5,-1.5753E-5,-1.7503E-5,-2.2327E-5,-2.413E-5,-1.4403E-5,-1.5463E-5,-1.633E-5,-2.1783E-5,-2.4203E-5,-1.4833E-5,-1.4933E-5,-1.6173E-5,-2.0467E-5,-2.432E-5,-1.5397E-5,-1.5847E-5,-1.6643E-5,-2.1207E-5,0.013809,0.015187,0.016152,0.019432,0.019833,0.017451,0.014474,0.016619,0.019215,0.019856,0.017537,0.014303,0.016694,0.019249,0.019709,0.017683,0.014255,0.016787,0.019134,0.019798,0.017686,0.014215,0.016753,0.019032,0.019906,0.017672,0.014323,0.016731,0.019103,0.019882,0.017669,0.014262,0.016687,0.019097,0.019813,0.017746,0.014225,0.016684,0.01899,0.019847,0.017687,0.014257,0.016643,0.019143,0.019892,0.017677,0.01429,0.016605,0.01908,0.019737,0.017807,0.014215,0.016676,0.018981,0.019804,0.017763,0.014269,0.016596,0.018983,0.01992,0.017749,0.014319,0.01652,0.019041,0.019799,0.017921,0.014285,0.016571,0.01893,0.019819,0.01787,0.014268,0.01665,0.018832,0.019897,0.017853,0.014267,0.016498,0.018895,0.019841,0.017876,0.014244,0.016499,0.018901,0.019877,0.017958,0.014302,0.016528,0.018807,0.019989,0.017873,0.014318,0.016473,0.018829,0.019906,0.017911,0.014346,0.016431,0.018924,0.019836,0.017995,0.014269,0.016475,0.018823,0.01991,0.017958,0.014322,0.016403,0.018748,0.019916,0.017955,0.014353,0.016384,0.018862,0.019885,0.018016,0.014322,0.016375,0.018749,0.019831,0.018039,0.014335,0.016424,0.018684,0.019937,0.017965,0.01431,0.016335,0.018795,0.019913,0.018022,0.014351,0.016332,0.018645,0.019904,0.018068,0.014322,0.016361,0.018607,0.019999,0.018032,0.014331,0.016315,0.018633,0.020013,0.018076,0.01437,0.016283,0.018752,0.019861,0.018159,0.014325:5
-2.314E-5,-3.6627E-5,-3.292E-5,-1.1063E-5,-1.7953E-5,-2.377E-5,-3.7717E-5,-3.3697E-5,-1.165E-5,-1.7077E-5,-2.3017E-5,-3.6567E-5,-3.378E-5,-1.1887E-5,-1.836E-5,-2.285E-5,-3.7047E-5,-3.348E-5,-1.1507E-5,-1.8083E-5,-2.2747E-5,-3.5593E-5,-3.3323E-5,-1.078E-5,-1.777E-5,-2.3683E-5,-3.665E-5,-3.345E-5,-1.1837E-5,-1.8523E-5,-2.4E-5,-3.6417E-5,-3.3657E-5,-1.1357E-5,-1.8303E-5,-2.2983E-5,-3.722E-5,-3.247E-5,-1.1297E-5,-1.79E-5,-2.2887E-5,-3.741E-5,-3.3073E-5,-1.128E-5,-1.692E-5,-2.4473E-5,-3.5977E-5,-3.3203E-5,-1.0917E-5,-1.7093E-5,-2.411E-5,-3.739E-5,-3.3603E-5,-1.0647E-5,-1.7913E-5,-2.293E-5,-3.7137E-5,-3.2633E-5,-1.0987E-5,-1.726E-5,-2.4187E-5,-3.739E-5,-3.3607E-5,-1.1247E-5,-1.742E-5,-2.346E-5,-3.68E-5,-3.2513E-5,-1.0643E-5,-1.7687E-5,-2.3693E-5,-3.6643E-5,5.0043E-4,2.8898E-4,0.0038208,0.004583,0.0042067,0.0034286,0.0033906,0.0040576,0.0046425,0.0041927,0.0035746,0.0033624,0.0041658,0.0081678,0.0083454,0.007151,0.0066707,0.00827,0.0093624,0.0084497,0.0072713,0.0067668,0.0084366,0.0094947,0.0085706,0.0073734,0.0068644,0.0085663,0.0096328,0.0087015,0.0074945,0.006974,0.008749,0.0097953,0.0088344,0.0076147,0.0070592,0.0088653,0.0099343,0.0089189,0.0077185,0.0071915,0.0089662,0.010048,0.0090307,0.0077948,0.0072829,0.0091262,0.010157,0.0091553,0.0078723,0.00735,0.0091915,0.010285,0.0092569,0.0079853,0.0074455,0.0092904,0.010426,0.0093981,0.00807,0.0075198,0.0094322,0.010504,0.0094673,0.0081336,0.0076086,0.0095224,0.01061,0.0095863,0.0082592,0.0076958,0.0096419,0.010765,0.0096775,0.0083253,0.0077531,0.0097176,0.010886,0.0098103,0.0084128,0.0078846,0.0098372,0.010978,0.0098763,0.0084953,0.0079244,0.0099122,0.011061,0.0099382,0.0085699,0.0079794,0.010032,0.01116,0.010041,0.0086139,0.0080672,0.010086,0.011252,0.010132,0.0086628,0.0081126,0.010156,0.011354,0.010211,0.0087759,0.0082158,0.010238,0.011445,0.010276,0.0088532,0.0082742,0.010335,0.011501,0.010331,0.0089004,0.0083028,0.010436,0.011595,0.010424,0.0089639,0.0083812,0.010505,0.011703,0.010497,0.0090524,0.0084631,0.010577,0.011767,0.010556,0.0091139,0.0085192,0.010679,0.011823,0.010647,0.0091729,0.00859,0.010755,0.011975,0.010727,0.0092368,0.008667,0.010825,0.012021,0.010775,0.0093065,0.0087253,0.01088,0.01215,0.010862,0.0093164,0.0087854,0.010974,0.012211,0.010953,0.0094119,0.0088616,0.010994,0.012291,0.010974,0.0094764,0.0088662,0.011088,0.012396,0.011091,0.0095326,0.008931,0.011173,0.012479,0.011121,0.0095733,0.0089967,0.011235,0.012538,0.011195,0.0096626,0.0090293,0.01136,0.012614,0.011237,0.0096889,0.0090993,0.011389,0.012617,0.011336,0.009775,0.0091378,0.01141,0.012723,0.011377,0.0097855,0.0092051,0.011523,0.0128,0.011413,0.0098524,0.0092409,0.011598,0.012869,0.011492,0.0099203,0.009329,0.011643,0.012969,0.011541,0.0099654,0.0093656,0.011727,0.012944,0.011569,0.0099898,0.0094279,0.011767,0.01306,0.011677,0.010079,0.0094701,0.011858,0.013142,0.011696,0.010125,0.0095091,0.011867,0.013228,0.011747,0.01017,0.0095405,0.011935,0.013255,0.011828,0.010184,0.0095679,0.011989,0.013346,0.011907,0.010272,0.0096806,0.012026,0.013392,0.011914,0.010286,0.0096753,0.012084,0.01342,0.011981,0.01034,0.0097164,0.01211,0.013471,0.012046,0.010385,0.0097565,0.012179,0.013552,0.012087,0.010424,0.009805,0.012228,0.013599,0.012139,0.01044,0.0098528,0.012281,0.013662,0.01215,0.010478,0.009887,0.012352,0.013724,0.0122,0.010546,0.0099536,0.012424,0.013767,0.012256,0.010555,0.010003,0.012458,0.013797,0.012302,0.010597,0.010014,0.012532,0.013891,0.012372,0.010657,0.01006,0.012526,0.013935,0.012417,0.010731,0.010092,0.012565,0.013996,0.012405,0.01073,0.010121,0.012686,0.014053,0.012488,0.010761,0.010164,0.012674,0.014066,0.012524,0.010763,0.010184,0.012674,0.014098,0.012513,0.010837,0.010213,0.012714,0.014159,0.012595,0.010871,0.010271,0.012792,0.014203,0.012623,0.010866,0.010298,0.012843,0.014269,0.01267,0.010931,0.010312,0.012889,0.014277,0.012727,0.010974,0.010377,0.012953,0.014329,0.012731,0.010958,0.01041,0.012983,0.014347,0.012739,0.011002,0.010469,0.012952,0.014397,0.012832,0.011015,0.010472,0.013064,0.014448,0.012853,0.011044,0.010445,0.013067,0.014519,0.012888,0.011127,0.010512,0.013104,0.014551,0.012908,0.011178,0.010548,0.013135,0.014617,0.012968,0.01114,0.010559,0.013196,0.014585,0.01293,0.011212,0.010589,0.013194,0.014652,0.012971,0.01121,0.010604,0.013212,0.014658,0.012991,0.011223,0.01063,0.013278,0.014736,0.013056,0.011298,0.010689,0.013314,0.014765,0.013066,0.011289,0.010714,0.013347,0.014751,0.013111,0.011316,0.010736,0.013347,0.01477,0.013091,0.011318,0.010743,0.013379,0.014832,0.013115,0.011344,0.010775,0.013434,0.014857,0.013098,0.011402,0.010779,0.013439,0.014905,0.013201,0.011431,0.010822,0.013519,0.014941,0.013239,0.011393,0.010821,0.013497,0.014948,0.013228,0.011447,0.010861,0.013547,0.015002,0.013247,0.0115,0.010892,0.013597,0.015007,0.0064152:5
-1.7233E-5,-1.2257E-5,-1.2897E-5,-3.0143E-5,-3.5983E-5,-1.7243E-5,-1.139E-5,-1.416E-5,-3.0453E-5,-3.674E-5,-1.827E-5,-1.12E-5,-1.43E-5,-2.9803E-5,-3.7063E-5,-1.7507E-5,-1.1707E-5,-1.3357E-5,-2.9217E-5,-3.612E-5,-1.862E-5,-1.1277E-5,-1.33E-5,-2.9693E-5,-3.7073E-5,-1.826E-5,-1.0677E-5,-1.2863E-5,-3.064E-5,-3.807E-5,-1.909E-5,-1.1677E-5,-1.2687E-5,-3.0213E-5,-3.731E-5,-1.877E-5,-1.164E-5,-1.2863E-5,-2.9957E-5,-3.6623E-5,-1.8427E-5,-1.0913E-5,-1.328E-5,-2.8907E-5,-3.624E-5,-1.9193E-5,-1.153E-5,-1.323E-5,6.0383E-5,2.9865E-4,2.0167E-4,0.0032984,0.004289,0.0044371,0.0037465,0.0032167,0.0036476,0.0042809,0.0045185,0.0038659,0.0032287,0.0037349,0.0068831,0.0090404,0.0076987,0.0064725,0.0074498,0.0086787,0.0091688,0.0078473,0.0065305,0.0075878,0.0088053,0.0093278,0.0080028,0.0066145,0.0077251,0.0089104,0.009455,0.0081333,0.0067109,0.0078388,0.0090866,0.0095906,0.008285,0.0068076,0.0078895,0.0091632,0.0097445,0.0083912,0.0069314,0.0079959,0.0092538,0.009843,0.0084547,0.0069786,0.0081082,0.0093389,0.009938,0.0085905,0.0070609,0.0082048,0.0094692,0.010046,0.0087159,0.007175,0.0082575,0.0095621,0.010222,0.0088169,0.0072576,0.0083544,0.0096679,0.010351,0.0089318,0.0073328,0.0084235,0.0097987,0.010425,0.0090603,0.0074537,0.0085265,0.0098165,0.010551,0.0091824,0.0075111,0.0085754,0.009934,0.010661,0.0092458,0.0075774,0.0086641,0.010021,0.010768,0.0093416,0.0076107,0.0087396,0.010081,0.010888,0.0094432,0.0077029,0.0087831,0.01016,0.010942,0.0095229,0.0077373,0.0088626,0.010219,0.011043,0.0096601,0.0078229,0.0089154,0.010332,0.011107,0.0097055,0.0079043,0.0089836,0.010395,0.011237,0.0098294,0.007955,0.0090323,0.010456,0.011328,0.0099234,0.0080229,0.0091257,0.010503,0.011424,0.0099871,0.0080729,0.0091422,0.010556,0.011529,0.010083,0.0081717,0.0092076,0.010635,0.011604,0.010171,0.0082582,0.0092887,0.010714,0.011678,0.010226,0.0082532,0.0093111,0.010763,0.011754,0.010344,0.0083247,0.0093658,0.010816,0.011823,0.010422,0.0083982,0.0094637,0.010845,0.011893,0.010501,0.0084237,0.0094583,0.010901,0.011977,0.010593,0.0085132,0.009505,0.010964,0.012088,0.010688,0.0085548,0.0095915,0.01104,0.012125,0.01075,0.0086561,0.0096508,0.011075,0.012251,0.010858,0.0087252,0.0096725,0.011145,0.012293,0.010946,0.0087489,0.0096885,0.01119,0.012402,0.011013,0.0087965,0.009747,0.011221,0.012476,0.011092,0.0088648,0.0098066,0.011281,0.012543,0.011222,0.0089082,0.0098376,0.011334,0.0126,0.011289,0.0089635,0.009904,0.011369,0.012693,0.011336,0.009043,0.0099259,0.011378,0.012735,0.011377,0.0090889,0.0099583,0.01146,0.012822,0.011491,0.0091322,0.010029,0.011469,0.012825,0.011542,0.0091892,0.010067,0.011547,0.012885,0.011642,0.0092413,0.010068,0.011544,0.012973,0.011714,0.0092625,0.010129,0.011638,0.013011,0.011765,0.0093488,0.010152,0.011649,0.013132,0.01187,0.0094181,0.010163,0.011675,0.013173,0.011954,0.009435,0.010196,0.011728,0.01322,0.012018,0.0094935,0.01025,0.01173,0.013278,0.012097,0.0095523,0.010256,0.011774,0.013311,0.0121,0.009594,0.010307,0.011769,0.013338,0.012202,0.0096293,0.010347,0.011816,0.01343,0.012283,0.0096912,0.010351,0.011844,0.013447,0.012344,0.0097571,0.010412,0.011916,0.013507,0.012388,0.0097457,0.010441,0.011895,0.013559,0.012454,0.0098239,0.010498,0.011919,0.013593,0.012558,0.0098796,0.010457,0.01196,0.013668,0.012648,0.0099029,0.010546,0.012024,0.013738,0.012644,0.0099359,0.010548,0.012025,0.013759,0.012715,0.0099885,0.01054,0.01202,0.013816,0.012807,0.010074,0.010583,0.012068,0.013859,0.012879,0.010093,0.010608,0.012025,0.013885,0.012906,0.01012,0.010672,0.012028,0.013954,0.012976,0.010211,0.010656,0.012082,0.014009,0.013031,0.010213,0.010714,0.012103,0.014039,0.013084,0.010232,0.01068,0.012124,0.014079,0.013174,0.010291,0.010716,0.01215,0.014077,0.013248,0.010391,0.010748,0.012144,0.014148,0.013296,0.010352,0.010762,0.012172,0.014099,0.013315,0.010432,0.010775,0.01219,0.01411,0.013377,0.010461,0.010744,0.012197,0.014189,0.013465,0.010488,0.010833,0.012159,0.014231,0.013513,0.010538,0.010833,0.012184,0.014256,0.013556,0.010552,0.010834,0.012177,0.014259,0.013536,0.010587,0.010828,0.012127,0.014266,0.013592,0.010628,0.010839,0.012178,0.014312,0.013687,0.010676,0.010878,0.012197,0.014322,0.013712,0.010743,0.010876,0.012218,0.014362,0.013747,0.010755,0.010942,0.012219,0.014383,0.013798,0.010775,0.010917,0.012181,0.014404,0.013856,0.010831,0.01096,0.012236,0.014395,0.013925,0.010871,0.010958,0.012217,0.014442,0.013965,0.010897,0.010974,0.012231,0.014451,0.013989,0.010948,0.011034,0.012216,0.014498,0.014088,0.010999,0.011004,0.012252,0.014512,0.014135,0.011037,0.011069,0.012224,0.014516,0.014131,0.011085,0.011023,0.012219,0.014556,0.014161,0.011103,0.01104,0.012237,0.014574,0.014241,0.011174,0.011085,0.012254,0.014619,0.014251,0.011217,0.011072,0.012229,0.014626,0.014354,0.011228,0.011118,0.012225,0.014628,0.014356,0.011208,0.011139,0.012249,0.01465,0.014473,0.011293,0.011147,0.01225,0.014684,0.014495,0.011367,0.011159,0.012225,0.01471,0.014546,0.01141,0.011168,0.01224,0.014683,0.014564,0.011431,0.011225,0.012261,0.014762,0.014586,0.011442,0.011197,0.012257,0.014749,0.014687:5
-1.8743E-5,-1.357E-5,-1.7327E-5,-3.166E-5,-3.788E-5,-2.03E-5,-1.558E-5,-1.6757E-5,-3.1967E-5,-3.8343E-5,-1.97E-5,-1.511E-5,-1.675E-5,-3.113E-5,-3.925E-5,-2.0463E-5,-1.534E-5,-1.6247E-5,-3.1907E-5,-3.952E-5,-2.0327E-5,-1.4033E-5,-1.6727E-5,-3.152E-5,-3.9097E-5,-2.0317E-5,-1.3837E-5,-1.6223E-5,-3.1433E-5,-3.824E-5,-2.0813E-5,-1.3907E-5,-1.5853E-5,-3.0777E-5,-3.9263E-5,-2.1263E-5,-1.5317E-5,-1.5117E-5,-3.102E-5,-3.9283E-5,-2.097E-5,-1.437E-5,-1.6177E-5,-3.185E-5,-3.09E-6,2.422E-4,2.3137E-4,0.0013049,0.0045288,0.0037821,0.0032978,0.0036468,0.004335,0.0045711,0.0039408,0.0032757,0.003758,0.0068847,0.0091834,0.007863,0.0065475,0.007512,0.0087682,0.0093262,0.0080778,0.0066545,0.0076785,0.0088613,0.0095202,0.008213,0.0067395,0.0077723,0.0089943,0.0096427,0.008353,0.0068368,0.0078923,0.009101,0.0097522,0.0084682,0.0069546,0.007983,0.0092393,0.0099324,0.008605,0.0070374,0.0080538,0.0093112,0.010056,0.0087755,0.0071177,0.0081439,0.0094035,0.010174,0.0088767,0.0072355,0.0082467,0.0095137,0.010336,0.0090085,0.0073301,0.0083283,0.0096212,0.010415,0.0090934,0.0073916,0.0083922,0.0097145,0.010541,0.0092163,0.0074669,0.0084801,0.0097943,0.010675,0.0093359,0.0075591,0.0085871,0.0098789,0.010752,0.0094737,0.0076637,0.0086455,0.0099898,0.010938,0.0095438,0.0077562,0.00874,0.010052,0.011006,0.0097298,0.0078078,0.0087951,0.010128,0.011158,0.0098043,0.0079035,0.0088848,0.010248,0.011227,0.0099241,0.0079608,0.0089011,0.010291,0.011306,0.009968,0.0080046,0.0089942,0.010322,0.011409,0.010127,0.0081281,0.0090535,0.0104,0.011515,0.010223,0.0081645,0.0091162,0.010478,0.01159,0.010344,0.0082132,0.009142,0.010546,0.01169,0.010389,0.0082963,0.0092278,0.010604,0.01179,0.010508,0.0084068,0.0092534,0.010644,0.011869,0.010605,0.0084452,0.0093116,0.010726,0.011953,0.010711,0.008537,0.0093857,0.010771,0.012013,0.010796,0.008599,0.0094213,0.010822,0.012148,0.010892,0.0086675,0.009474,0.010871,0.012224,0.010972,0.0087146,0.0095195,0.010955,0.012304,0.011098,0.0088086,0.009571,0.011007,0.012387,0.011202,0.0088548,0.0096075,0.011063,0.012449,0.011284,0.0089082,0.0096817,0.011089,0.0125,0.011369,0.0089868,0.0097123,0.011122,0.012582,0.011468,0.0090392,0.0097781,0.011171,0.012674,0.011571,0.0091008,0.0098001,0.011232,0.012735,0.011625,0.0091958,0.0098623,0.011246,0.012819,0.01172,0.0091955,0.0099179,0.011288,0.01288,0.011811,0.0092817,0.0099371,0.011347,0.012916,0.011881,0.0093227,0.010028,0.011363,0.01302,0.011951,0.0094212,0.010021,0.011404,0.013064,0.012062,0.0094597,0.01008,0.01145,0.013109,0.012129,0.0095103,0.010128,0.011497,0.013154,0.012204,0.0095899,0.010133,0.011584,0.013231,0.012298,0.0096313,0.010196,0.011571,0.013291,0.012364,0.0096995,0.010238,0.011606,0.013376,0.012423,0.0097688,0.01027,0.011645,0.013433,0.012549,0.0098218,0.010325,0.011638,0.013519,0.012611,0.0098945,0.010364,0.011678,0.013544,0.0127,0.0099636,0.01037,0.011753,0.013629,0.012763,0.010007,0.010415,0.011754,0.013743,0.012857,0.010108,0.010476,0.011845,0.01378,0.012925,0.010182,0.010513,0.011828,0.013774,0.012979,0.010165,0.01049,0.011854,0.013813,0.013031,0.010201,0.010504,0.011882,0.013889,0.013075,0.0103,0.01052,0.011896,0.013918,0.013197,0.010333,0.010581,0.01191,0.013961,0.013269,0.010408,0.010634,0.011943,0.014011,0.013304,0.010428,0.010652,0.011911,0.014071,0.013383,0.010541,0.010714,0.011962,0.014092,0.013488,0.010539,0.010755,0.011979,0.014092,0.01353,0.010644,0.010759,0.011968,0.014165,0.013551,0.010661,0.010771,0.012018,0.014229,0.013619,0.010684,0.010826,0.012013,0.014272,0.013716,0.01078,0.010793,0.01202,0.014288,0.013732,0.010828,0.010865,0.012045,0.014301,0.013802,0.010839,0.010838,0.011987,0.014319,0.013859,0.010855,0.010872,0.012008,0.014346,0.013888,0.010916,0.010864,0.012013,0.014368,0.013985,0.010966,0.010918,0.012022,0.014396,0.014038,0.011004,0.010922,0.012012,0.014389,0.014033,0.011044,0.010928,0.01202,0.014396,0.014124,0.01108,0.010963,0.012061,0.014422,0.014145,0.01109,0.010955,0.012068,0.014457,0.014194,0.011225,0.011022,0.012043,0.014505,0.014273,0.011216,0.011003,0.012032,0.014567,0.014307,0.011278,0.011031,0.012045,0.014524,0.014368,0.011291,0.011038,0.012045,0.014553,0.014378,0.011389,0.011051,0.012051,0.014547,0.014482,0.011405,0.011081,0.012095,0.014599,0.014498,0.011458,0.011115,0.012039,0.014633,0.014566,0.011532,0.011161,0.012051,0.014626,0.014584,0.011549,0.011169,0.012072,0.014669,0.014649,0.011554,0.011146,0.012056,0.014673,0.014709,0.011664,0.011206,0.012079,0.014703,0.014769,0.0117,0.011193,0.012048,0.0147,0.014784,0.011765,0.011193,0.012068,0.014742,0.01482,0.01181,0.011251,0.012078,0.014779,0.014891,0.011851,0.011277,0.012086,0.014725,0.014919,0.011919,0.011283,0.01207,0.014767,0.014982,0.011943,0.011341,0.01203,0.014774,0.014983,0.011995,0.011324,0.012061,0.014807,0.015072,0.012016,0.011375,0.012072,0.014778,0.015052,0.012047,0.011366,0.012087,0.014823,0.015142,0.012134,0.011383,0.01204,0.014837,0.015166,0.012162,0.011403,0.01202,0.014851,0.015206,0.012209,0.011432,0.012026,0.014819,0.015198,0.012289,0.011437,0.012084,0.014835,0.015276,0.012306,0.011466,0.012027,0.014885,0.015318,0.012359,0.011511,0.012055,0.014905,0.01536,0.012422,0.011551,0.012061,0.014917,0.015429,0.012454,0.011611,0.012029,0.014929,0.015463,0.012539,0.011576,0.012052,0.014891,0.015448,0.01255,0.01158,0.012026,0.014929,0.015482,0.012617,0.011606,0.012086,0.014949,0.015597,0.012692,0.011642,0.012021,0.014986,0.01562,0.012711,0.01169,0.012045,0.014953,0.015631,0.012777,0.011691,0.012024,0.014924,0.015703,0.012871,0.011708,0.012059,0.015012,0.015708,0.012849,0.011752,0.012052,0.014993,0.015758,0.012944,0.011819,0.012044,0.014973,0.01579,0.013024,0.011807,0.012067,0.014992,0.015836,0.013066,0.011843,0.012075,0.015009,0.015852,0.013134,0.011862,0.012043,0.014991,0.015887,0.013154,0.011884,0.01206,0.015019,0.015916,0.013256,0.011901,0.012027,0.015,0.015939,0.013238,0.011887,0.012027,0.014954,0.015922,0.013351,0.011914,0.012049,0.015004,0.015969,0.013348,0.011925,0.012045,0.015007,0.016032,0.013399,0.012018,0.011985,0.01504,0.016022,0.01344,0.011995,0.011965,0.014978,0.01609,0.013483,0.012024,0.012013,0.01499,0.016081,0.013533,0.012012,0.011978,0.015003,0.016118,0.013568,0.012107,0.012009,0.014959,0.016095:5
4.5583E-4,-6.5526E-4,7.5421E-4,6.8757E-5,1.564E-5,9.3449E-4,-7.6884E-4,6.6795E-4,-7.121E-5,-2.5613E-4,0.62529,3.9861,4.6316,5.3736,5.4886,4.585,4.0976,4.56,5.3953,5.4994,4.5632,4.1205,4.5336,5.3974,5.501,4.5596,4.1256,4.5233,5.3937,5.498,4.5556,4.1209,4.513,5.387,5.4924,4.5589,4.1216,4.5116,5.3815,5.4969,4.5602,4.1211,4.504,5.3822,5.4963,4.5604,4.1178,4.5015,5.3763,5.4957,4.5637,4.1144,4.4933,5.3698,5.4883,4.5621,4.114,4.4891,5.3661,5.4924,4.5637,4.1103,4.4838,5.3598,5.4896,4.5644,4.1092,4.4757,5.357,5.4887,4.5655,4.1094,4.4757,5.3528,5.49,4.5658,4.1059,4.4737,5.3471,5.4899,4.57,4.107,4.4695,5.3417,5.4842,4.5676,4.1072,4.4602,5.3362,5.4861,4.5708,4.1034,4.457,5.339,5.487,4.5739,4.1028,4.4556,5.3292,5.4909,4.5749,4.1041,4.4507,5.331,5.4879,4.5747,4.1018,4.4453,5.3313,5.4875,4.5784,4.0999,4.442,5.3241,5.4834,4.5791,4.0997,4.4355,5.3192,5.4814,4.5799,4.0985,4.4334,5.316,5.4825,4.5798,4.0963,4.4272,5.31,5.483,4.5825,4.0933,4.4213,5.3066,5.4803,4.5822,4.0942,4.4189,5.3059,5.4824,4.5828,4.0924,4.4156,5.3002,5.4814,4.5855,4.0891,4.4115,5.2945,5.4823,4.5854,4.0929,4.4064,5.2935,5.4772,4.5866,4.0899,4.4054,5.2877,5.4808,4.5912,4.0896,4.4041,5.2883,5.4764,4.5861,4.0865,4.4005,5.286,5.4715,4.5892,4.0846,4.3967,5.2779,5.4679,4.5864,4.0825,4.3912,5.2726,5.4699,4.5864,4.0777,4.3884,5.2699,5.467,4.5894,4.076,4.3838,5.269,5.4668,4.5893,4.0764,4.3758,5.2612,5.4634,4.5854,4.0755,4.3745,5.2582,5.4634:5
-4.2433E-4,6.0432E-4,5.3384E-4,-4.2131E-4,0.0010327,-5.2879E-4,4.2256E-4,1.3622E-4,-3.3463E-4,6.3283E-4,-7.4978E-4,7.0082E-4,-1.0102E-4,-4.9387E-4,8.6146E-4,-6.8372E-4,7.126E-4,-2.1256E-4,-1.5612E-4,6.5306E-4,-5.9764E-4,5.7018E-4,1.9344E-4,2.8463,4.5192,4.4816,5.291,5.9397,5.5092,4.4766,4.5151,5.2748,5.9441,5.5132,4.4739,4.524,5.273,5.9432,5.511,4.4641,4.5203,5.2672,5.9343,5.5033,4.4596,4.5174,5.2627,5.9306,5.4907,4.4519,4.5106,5.2556,5.9233,5.4858,4.4472,4.5053,5.2523,5.9173,5.4819,4.4436,4.503,5.2493,5.9127,5.4777,4.4379,4.5004,5.2464,5.9073,5.4714,4.4361,4.4988,5.2432,5.9011,5.4654,4.4306,4.4941,5.2409,5.901,5.4667,4.4287,4.4957,5.2371,5.8997,5.4621,4.423,4.4952,5.2401,5.897,5.4601,4.4234,4.497,5.2409,5.8994,5.4552,4.4229,4.4944,5.237,5.895,5.4534,4.4167,4.4922,5.2346,5.8933,5.4497,4.4158,4.4888,5.2381,5.8939,5.4481,4.4144,4.4912,5.2371,5.892,5.4465,4.4161,4.4886,5.2371,5.8856,5.4421,4.4136,4.4901,5.2351,5.8843,5.442,4.4054,4.4856,5.2287,5.8814,5.4362,4.4051,4.4873,5.2293,5.8833,5.4347,4.4065,4.4859,5.2289,5.879,5.4321,4.401,4.4855,5.2246,5.8732,5.428,4.3967,4.4829,5.2246,5.8763,5.4233,4.399,4.4806,5.2253,5.8722,5.4201,4.3928,4.4806,5.2218,5.8718,5.4182,4.3897,4.4828,5.2276,5.862,5.4102,4.3884,4.4751,5.2198,5.8643,5.4107,4.3849,4.4759,5.2207,5.8581,5.4028,4.3873,4.4776,5.2235,5.8598,5.4015,4.3828,4.4746,5.2235,5.8539,5.4021,4.3766,4.4714,5.2159,5.8528,5.3947,4.3741,4.4716,5.2118,5.8552,5.3931,4.3708,4.4703,5.2135,5.8497,5.3906,4.3662:5
-0.0017999,0.0011245,7.3489E-4,-0.0023437,0.0036093,-0.0027038,5.1876E-4,6.84E-4,-0.0018919,0.0023608,-0.0018909,8.196E-4,9.6892E-4,-0.0019954,0.0019322,10.621,3.5897,1.8525,1.2604,1.0664,1.0165,1.2168,1.2332,1.0144,0.87202,0.9469,1.1321,1.2069,1.0021,0.8599,0.92891,1.105,1.181,0.98738,0.83947,0.88947,1.0567,1.129,1.0008,0.85836,0.97367,1.1025,1.2005,0.97816,0.85714,0.92107,1.0544,1.1114,0.93531,0.79672,0.85681,1.0123,1.1047,0.92247,0.77654,0.78289,0.88171,0.93012,0.79263,0.66616,0.71311,0.845,0.90006,0.77279,0.64529,0.68838,0.81716,0.87458,0.75299,0.63254,0.67504,0.80399,0.86543,0.74812,0.62336,0.66142,0.78416,0.84179,0.72887,0.60987,0.65032,0.77433,0.83841,0.72891,0.60942,0.64704,0.77057,0.8362,0.72878,0.60855,0.64357,0.76822,0.83452,0.72934,0.60833,0.64312,0.76667,0.83413,0.72976,0.60678,0.6412,0.76257,0.83392,0.73008,0.60788,0.63865,0.76011,0.83214,0.73175,0.60835,0.63728,0.75835,0.83286,0.73285,0.60672,0.63564,0.75753,0.83173,0.73341,0.60722,0.63471,0.75477,0.83128,0.73487,0.60696,0.63255,0.75203,0.82886,0.73596,0.60693,0.6314,0.75005,0.82884,0.73525,0.60672,0.62936,0.74801,0.82764,0.73625,0.60773,0.62664,0.74477,0.82615,0.7373,0.60717,0.62535,0.74339,0.82451,0.73742,0.60698,0.62384,0.74162,0.8243,0.73909,0.60723,0.6232,0.74194,0.82834,0.74525,0.61386,0.62768,0.74575,0.83131,0.74908,0.61536,0.62749,0.74343,0.82934,0.74856,0.6131,0.62374,0.7386,0.82785,0.74983,0.61355,0.62218,0.73659,0.82791,0.75071,0.61427,0.62252,0.73462,0.82708,0.75158,0.61544,0.62012,0.73432,0.82637,0.75315,0.61531,0.61895,0.73115,0.82611,0.75521,0.61606,0.61845,0.73029,0.82585,0.75694,0.61602:6
-0.0020014,6.8542E-4,-4.1681E-4,-9.7832E-4,0.0018363,-0.0018948,0.001755,-6.005E-4,-0.0010795,0.0023384,-0.0021744,0.0021194,-4.531E-4,-1.9062E-4,0.0013168,-0.0022956,0.0019891,-7.7773E-5,-6.0677E-5,0.0014961,-0.0020926,0.0023876,1.7775,2.507,1.3608,1.3082,1.0367,1.2816,1.1631,0.89196,0.85815,0.92554,1.1146,1.0733,0.87479,0.81362,0.92068,1.1036,1.0834,0.89094,0.82259,0.92483,1.1182,1.0855,0.89483,0.82481,0.92746,1.1122,1.085,0.89155,0.82126,0.92262,1.1102,1.0873,0.89406,0.82154,0.92467,1.1068,1.0781,0.88405,0.80927,0.91207,1.107,1.09,0.89832,0.82756,0.92534,1.1118,1.0955,0.90322,0.82517,0.92211,1.1073,1.093,0.89903,0.82173,0.91887,1.1052,1.095,0.9021,0.82295,0.91796,1.1056,1.0957,0.90567,0.82507,0.91852,1.1035,1.0985,0.90545,0.82373,0.91642,1.1037,1.0991,0.90698,0.82398,0.9145,1.1027,1.1017,0.90997,0.82419,0.91372,1.1018,1.1026,0.91041,0.82439,0.91286,1.1015,1.1046,0.91431,0.82478,0.91224,1.1025,1.1072,0.91557,0.82446,0.91039,1.0991,1.1071,0.91793,0.82476,0.91044,1.1007,1.1095,0.91931,0.82599,0.91044,1.1,1.1126,0.92285,0.82751,0.9093,1.0991,1.1132,0.92448,0.82637,0.90576,1.0977,1.1114,0.92422,0.82587,0.90496,1.0956,1.1129,0.92513,0.82535,0.90343,1.0941,1.1122,0.92721,0.82558,0.89979,1.0922,1.1128,0.92756,0.82381,0.89864,1.0889,1.1136,0.92954,0.82485,0.89764,1.0887,1.1151,0.93255,0.82561,0.89576,1.0874,1.1176,0.93397,0.82732,0.89694,1.0867,1.1184,0.93728,0.82579,0.89383,1.0854,1.1186,0.9377,0.82679,0.89224,1.085,1.1185,0.93942,0.82785,0.89153,1.0826,1.1203,0.94155,0.82603,0.88987,1.0814,1.1205,0.94281,0.8275,0.88831,1.081,1.1221,0.94427:6
9.8554E-4,0.0022028,-0.0020015,0.0022559,-0.0025244,9.4964E-4,2.7616E-4,-0.0017301,0.0029237,-0.0018215,-6.3982E-4,6.5089E-4,-0.0024925,0.0026282,-0.0019589,3.9881E-4,0.0013315,-0.0031904,0.0026055,-0.0020782,-6.3829E-4,0.0014134,-0.0020499,0.002143,-0.0015607,0.0013733,6.377E-4,-0.002709,0.0021966,-0.002,-9.148E-5,2.7371,2.1129,1.1494,1.4722,1.3822,1.1799,0.97443,0.87068,1.0363,1.1815,1.0747,0.87925,0.85157,0.98525,1.1553,1.0636,0.86486,0.84756,0.97273,1.1464,1.057,0.85629,0.83934,0.96234,1.1415,1.0562,0.85805,0.83602,0.95976,1.138,1.0556,0.85733,0.83546,0.95424,1.131,1.0653,0.85389,0.83341,0.94593,1.1192,1.0338,0.837,0.79738,0.91929,1.0782,1.0008,0.81965,0.7774,0.90186,1.052,0.98087,0.80458,0.7646,0.88571,1.0369,0.97226,0.80013,0.75279,0.87642,1.0282,0.97052,0.7995,0.751,0.87356,1.0268,0.97062,0.7997,0.75045,0.87236,1.0262,0.97272,0.80087,0.74907,0.86962,1.0236,0.97262,0.8017,0.74799,0.86886,1.023,0.97435,0.8028,0.74806,0.86558,1.0198,0.97626,0.80381,0.74727,0.86436,1.0215,0.97701,0.80514,0.74452,0.86206,1.0184,0.97852,0.80618,0.7453,0.86062,1.0169,0.97953,0.80743,0.74546,0.85859,1.017,0.98102,0.80873,0.74434,0.85798,1.0171,0.98345,0.81074,0.74535,0.8554,1.0152,0.98465,0.81335,0.74444,0.85442,1.0134,0.98593,0.81416,0.74401,0.85237,1.0146,0.9886,0.8166,0.74308,0.85341,1.0135,0.9903,0.81954,0.74568,0.85148,1.0136,0.9923,0.8216,0.74489,0.85147,1.0128,0.99399,0.82299,0.74482,0.8487,1.0123,0.99461,0.82467,0.74488,0.84734,1.0125,0.99826,0.82795,0.74502,0.84639,1.009,0.99899,0.82726,0.7445,0.84429,1.0095,0.99782,0.82934,0.74545,0.84313,1.0091,1.0009,0.83098,0.74458,0.84217:6
5.6333E-7,-9.5E-7,1.6133E-6,2.1E-7,4.3E-7,8.9333E-7,-7.7333E-7,1.0167E-6,1.4667E-7,2.0667E-7,1.01E-6,-5.5333E-7,1.4467E-6,-5.5333E-7,-6.5E-7,9.2667E-7,-5.8E-7,9.6E-7,-3.4667E-7,3.1333E-7,7.8667E-7,1.7667E-7,9.5667E-7,7.0E-7,8.1333E-7,1.2633E-6,-1.46E-6,1.67E-6,4.7667E-7,3.5333E-7,6.3E-7,-1.2333E-6,9.9333E-7,-6.0667E-7,8.3667E-7,-1.8333E-7,-6.2E-7,2.6267E-6,-9.8E-7,9.5667E-7,1.1E-7,-1.32E-6,1.2067E-6,-1.4333E-7,-4.6667E-8,1.4633E-6,0.0012339,8.9207E-4,6.1363E-4,6.0798E-4,4.7916E-4,3.6638E-4,4.2044E-4,4.7628E-4,4.9099E-4,4.0545E-4,3.6406E-4,3.9139E-4,4.7233E-4,4.8567E-4,4.0094E-4,3.6564E-4,3.8981E-4,4.7161E-4,4.8539E-4,3.9952E-4,3.6608E-4,3.9108E-4,4.7188E-4,4.8596E-4,3.9899E-4,3.6695E-4,3.9299E-4,4.7327E-4,4.8681E-4,3.9684E-4,3.6768E-4,3.9185E-4,4.749E-4,4.856E-4,3.9681E-4,3.676E-4,3.9483E-4,4.761E-4,4.8644E-4,3.9668E-4,3.6806E-4,3.9635E-4,4.7612E-4,4.8697E-4,3.9296E-4,3.6767E-4,3.9633E-4,4.7838E-4,4.8706E-4,3.9339E-4,3.6739E-4,3.9742E-4,4.7872E-4,4.8739E-4,3.9229E-4,3.6815E-4,3.9882E-4,4.7866E-4,4.8492E-4,3.9241E-4,3.6796E-4,4.0188E-4,4.8027E-4,4.8764E-4,3.8969E-4,3.6814E-4,4.0111E-4,4.8251E-4,4.887E-4,3.9123E-4,3.6968E-4,4.0354E-4,4.8136E-4,4.8788E-4,3.89E-4,3.7043E-4,4.0521E-4,4.8172E-4,4.8827E-4,3.896E-4,3.6928E-4,4.0455E-4,4.8093E-4,4.8531E-4,3.8704E-4,3.6949E-4,4.0565E-4,4.8248E-4,4.8534E-4,3.8799E-4,3.6991E-4,4.0584E-4,4.8326E-4,4.8718E-4,3.8451E-4,3.6945E-4,4.0582E-4,4.8284E-4,4.8743E-4,3.8377E-4,3.6931E-4,4.0836E-4,4.8328E-4,4.856E-4,3.826E-4,3.7116E-4,4.1169E-4,4.8505E-4,4.8459E-4,3.8317E-4,3.7131E-4,4.1122E-4,4.8358E-4,4.8308E-4,3.8003E-4,3.7046E-4,4.1238E-4,4.8588E-4,4.8348E-4,3.8073E-4,3.6988E-4,4.1279E-4,4.8592E-4,4.8221E-4,3.7897E-4,3.7157E-4,4.1344E-4,4.8598E-4,4.8095E-4,3.7696E-4,3.7294E-4,4.141E-4,4.8617E-4,4.8186E-4,3.7715E-4,3.7349E-4,4.1711E-4,4.8708E-4,4.8063E-4,3.7568E-4,3.7407E-4,4.1814E-4,4.8726E-4,4.7962E-4,3.7678E-4,3.739E-4,4.2066E-4,4.8961E-4,4.7978E-4,3.7409E-4,3.7269E-4,4.1986E-4,4.875E-4,4.7726E-4,3.7427E-4,3.7516E-4,4.2095E-4,4.8821E-4,4.7647E-4,3.7379E-4,3.7444E-4,4.2218E-4,4.8873E-4,4.7649E-4,3.7285E-4,3.7616E-4,4.2254E-4,4.889E-4,4.7702E-4,3.7183E-4,3.7471E-4,4.2352E-4,4.8921E-4,4.7589E-4,3.6936E-4,3.7495E-4,4.2613E-4,4.8964E-4,4.7503E-4,3.7007E-4,3.7518E-4,4.2611E-4,4.8916E-4,4.7366E-4,3.6928E-4,3.7788E-4,4.2769E-4,4.9083E-4,4.7394E-4,3.6881E-4,3.7595E-4,4.2719E-4,4.8833E-4,4.7184E-4,3.6743E-4,3.7858E-4,4.285E-4,4.9078E-4,4.7234E-4,3.6625E-4,3.7655E-4,4.2959E-4,4.8887E-4,4.7007E-4,3.6667E-4,3.7841E-4,4.3088E-4,4.9179E-4,4.6969E-4,3.6593E-4,3.7893E-4,4.3307E-4,4.9011E-4,4.6903E-4,3.6322E-4,3.7892E-4,4.3406E-4,4.9116E-4,4.6741E-4,3.6349E-4,3.795E-4,4.355E-4,4.9143E-4,4.6745E-4,3.6365E-4,3.8153E-4,4.3544E-4,4.907E-4,4.6647E-4,3.6249E-4,3.8289E-4,4.356E-4,4.918E-4,4.6421E-4,3.628E-4,3.8319E-4,4.3734E-4,4.9255E-4,4.6392E-4,3.6118E-4,3.8417E-4,4.3897E-4,4.9292E-4,4.6281E-4,3.6086E-4,3.8338E-4,4.3784E-4,4.9285E-4,4.6175E-4,3.5942E-4,3.8439E-4,4.3966E-4,4.9189E-4,4.5969E-4,3.5927E-4,3.844E-4,4.4075E-4,4.9221E-4,4.5792E-4,3.5768E-4,3.8565E-4,4.4255E-4,4.9161E-4,4.57E-4:6
-2.8E-7,1.2667E-6,-4.4E-7,1.1967E-6,9.0E-7,-1.4333E-7,-1.3333E-8,-9.8E-7,2.03E-6,9.0E-7,-2.3333E-7,1.4633E-6,-8.3333E-8,3.6667E-7,8.3333E-7,4.3E-7,4.3333E-7,-7.9667E-7,6.4E-7,1.6E-7,1.2933E-6,7.2333E-7,-1.08E-6,1.3233E-6,7.3333E-8,-6.0E-7,1.2067E-6,-4.0E-7,1.02E-6,4.6667E-8,-8.0333E-7,0.0011628,8.663E-4,5.7451E-4,6.3679E-4,5.5639E-4,3.8847E-4,4.1234E-4,4.3481E-4,5.0203E-4,4.8737E-4,3.7138E-4,3.8348E-4,4.2962E-4,4.9297E-4,4.7961E-4,3.7157E-4,3.8075E-4,4.2768E-4,4.9205E-4,4.7919E-4,3.7026E-4,3.8228E-4,4.295E-4,4.9123E-4,4.7942E-4,3.7021E-4,3.81E-4,4.3044E-4,4.9196E-4,4.775E-4,3.6763E-4,3.8102E-4,4.3114E-4,4.924E-4,4.7697E-4,3.685E-4,3.8338E-4,4.3328E-4,4.9294E-4,4.7538E-4,3.6802E-4,3.8371E-4,4.3486E-4,4.9443E-4,4.7436E-4,3.6684E-4,3.8259E-4,4.3493E-4,4.9504E-4,4.734E-4,3.6672E-4,3.8326E-4,4.3598E-4,4.9256E-4,4.7228E-4,3.6602E-4,3.8308E-4,4.3672E-4,4.9378E-4,4.7156E-4,3.658E-4,3.852E-4,4.3889E-4,4.9314E-4,4.7173E-4,3.6585E-4,3.8432E-4,4.3822E-4,4.9394E-4,4.6955E-4,3.6512E-4,3.8581E-4,4.3779E-4,4.9319E-4,4.692E-4,3.6331E-4,3.8609E-4,4.3988E-4,4.9295E-4,4.6755E-4,3.6371E-4,3.8701E-4,4.4082E-4,4.9472E-4,4.6603E-4,3.2489E-4,4.0391E-4,4.6451E-4,4.9296E-4,4.3754E-4,3.52E-4,4.056E-4,4.6324E-4,4.9416E-4,4.3743E-4,3.5286E-4,4.054E-4,4.6327E-4,4.9036E-4,4.3577E-4,3.4958E-4,4.0829E-4,4.6574E-4,4.9136E-4,4.3423E-4,3.5297E-4,4.0752E-4,4.6539E-4,4.9258E-4,4.334E-4,3.5142E-4,4.0735E-4,4.6653E-4,4.9313E-4,4.3212E-4,3.5094E-4,4.096E-4,4.6743E-4,4.9234E-4,4.3257E-4,3.5076E-4,4.0835E-4,4.6707E-4,4.9148E-4,4.3154E-4,3.5203E-4,4.0997E-4,4.6857E-4,4.9259E-4,4.3131E-4,3.5014E-4,4.1261E-4,4.6903E-4,4.9053E-4,4.2825E-4,3.5056E-4,4.1128E-4,4.7169E-4,4.9017E-4,4.2781E-4,3.5045E-4,4.1209E-4,4.707E-4,4.8987E-4,4.2688E-4,3.5056E-4,4.1294E-4,4.7139E-4,4.9018E-4,4.2669E-4,3.5048E-4,4.1427E-4,4.7241E-4,4.9103E-4,4.2368E-4,3.5073E-4,4.1484E-4,4.7188E-4,4.9041E-4,4.2626E-4,3.5038E-4,4.1434E-4,4.7494E-4,4.883E-4,4.2347E-4,3.4977E-4,4.1741E-4,4.7498E-4,4.9013E-4,4.2349E-4,3.4969E-4,4.1605E-4,4.754E-4,4.8933E-4,4.2282E-4,3.4998E-4,4.173E-4,4.7472E-4,4.8776E-4,4.2132E-4,3.499E-4,4.1782E-4,4.7446E-4,4.8913E-4,4.211E-4,3.5079E-4,4.1812E-4,4.7587E-4,4.8775E-4,4.1944E-4,3.5028E-4,4.2072E-4,4.769E-4,4.8705E-4,4.1851E-4,3.5061E-4,4.2068E-4,4.7851E-4,4.8628E-4,4.1637E-4,3.5078E-4,4.193E-4,4.7722E-4,4.8603E-4,4.1603E-4,3.5037E-4,4.2173E-4,4.7729E-4,4.8538E-4,4.1635E-4,3.4935E-4,4.2321E-4,4.8151E-4,4.8387E-4,4.1328E-4,3.5076E-4,4.2507E-4,4.7844E-4,4.8426E-4,4.1571E-4,3.5201E-4,4.2435E-4,4.8037E-4,4.8163E-4,4.1034E-4,3.5153E-4,4.2364E-4,4.8128E-4,4.8361E-4,4.1265E-4,3.5001E-4,4.2377E-4,4.8186E-4,4.8423E-4,4.1313E-4,3.5187E-4,4.2567E-4,4.8136E-4,4.8278E-4,4.0942E-4,3.5086E-4,4.2483E-4,4.8089E-4,4.8186E-4,4.1007E-4,3.5045E-4,4.2455E-4,4.819E-4,4.8091E-4,4.0974E-4,3.5094E-4,4.27E-4,4.8381E-4,4.7927E-4,4.091E-4,3.5156E-4,4.2649E-4,4.843E-4,4.7842E-4,4.0808E-4,3.5127E-4,4.2979E-4,4.837E-4,4.7981E-4,4.0586E-4,3.5164E-4,4.2677E-4,4.8544E-4,4.7763E-4,4.0566E-4,3.5071E-4,4.3012E-4,4.8511E-4,4.7717E-4,4.0382E-4,3.5202E-4,4.3124E-4,4.8489E-4,4.7587E-4,4.0503E-4,3.5401E-4,4.3115E-4,4.8459E-4,4.7589E-4,4.0253E-4,3.5328E-4,4.3327E-4,4.8605E-4,4.7635E-4,4.0344E-4,3.5211E-4,4.3222E-4,4.8878E-4,4.7587E-4,4.0044E-4,3.5221E-4,4.3186E-4,4.8779E-4,4.7447E-4,4.0073E-4,3.5303E-4,4.3352E-4,4.8704E-4,4.7208E-4,4.0043E-4,3.5536E-4,4.3432E-4,4.8921E-4,4.7269E-4,4.0008E-4,3.5399E-4,4.3702E-4,4.8863E-4,4.7251E-4,4.0015E-4,3.548E-4,4.369E-4,4.8977E-4,4.7153E-4,3.9712E-4,3.5468E-4,4.3729E-4,4.8886E-4,4.6841E-4,3.9827E-4,3.5453E-4,4.3865E-4,4.8811E-4,4.7058E-4,3.9543E-4,3.5489E-4,4.3728E-4,4.9075E-4,4.6844E-4,3.9511E-4,3.5574E-4,4.3945E-4,4.8809E-4,4.6718E-4,3.9409E-4,3.5584E-4,4.3861E-4,4.8922E-4,4.6706E-4,3.9455E-4,3.5746E-4,4.4113E-4,4.9057E-4,4.6453E-4,3.9458E-4,3.5819E-4,4.4073E-4,4.911E-4,4.6416E-4,3.9418E-4,3.5654E-4,4.4064E-4,4.9138E-4,4.6364E-4,3.9265E-4,3.574E-4,4.4177E-4,4.9278E-4,4.6344E-4,3.9239E-4,3.5717E-4,4.4419E-4,4.9367E-4,4.6259E-4,3.9242E-4,3.5679E-4,4.4509E-4,4.9348E-4,4.635E-4,3.9088E-4,3.5844E-4,4.4683E-4,4.9232E-4,4.6097E-4:6
7.5E-7,1.7667E-7,6.2E-7,1.0867E-6,1.7E-7,4.0E-7,4.5333E-7,8.9E-7,6.1E-7,5.0E-7,1.0367E-6,1.9667E-7,-3.1333E-7,1.0033E-6,-2.4253E-14,6.7333E-7,-2.1E-7,-1.2667E-7,1.07E-6,9.4E-7,-5.6667E-8,4.2333E-7,1.5333E-7,1.11E-6,1.8667E-7,1.2333E-6,-5.5E-7,9.4667E-7,1.5533E-6,1.0667E-7,1.12E-6,9.0667E-7,7.4667E-7,1.4133E-6,-2.7333E-7,7.9667E-7,1.3E-7,6.4667E-7,8.2333E-7,-9.6667E-8,6.5667E-7,4.5E-7,-3.2667E-7,5.9333E-7,-5.0667E-7,7.8333E-7,5.7667E-7,-6.4E-7,7.4667E-7,-6.6667E-9,5.8E-7,4.6667E-7,8.1333E-7,1.1867E-6,-4.0333E-7,7.0667E-7,5.4667E-7,2.6667E-7,1.3567E-6,1.0E-8,1.5533E-6,-2.4667E-7,2.0667E-7,1.7367E-6,-3.8333E-7,1.2933E-6,1.4667E-7,5.6333E-7,1.8933E-6,6.8333E-7,2.2467E-6,8.9667E-7,1.7E-7,4.8667E-7,-2.2E-7,4.7333E-7,2.8333E-7,4.1667E-7,7.7E-7,-1.3E-7,3.7E-7,8.5667E-7,9.9333E-7,5.8667E-7,4.0E-7,9.5E-7,-1.6667E-7,1.7667E-7,1.44E-6,-9.7E-7,1.2167E-6,1.0467E-6,9.0E-7,1.3333E-7,-6.9667E-7,9.8333E-7,-3.0E-8,8.6E-7,1.54E-6,-4.3333E-8,2.1433E-6,1.1733E-6,1.46E-6,9.2667E-7,-1.8E-7,1.23E-6,6.1E-7,3.6667E-8,6.1E-7,3.3333E-8,1.9133E-6,-8.3333E-8,4.6333E-7,1.21E-6,-8.6E-7,9.6667E-7,2.1667E-7,-2.6667E-8,5.7333E-7,9.6333E-7,-2.7667E-7,3.0667E-7,6.3667E-7,1.6933E-6,-9.8667E-7,1.3733E-6,5.0E-7,8.5E-7,2.2667E-7,-4.8667E-7,3.5E-7,3.8E-7,4.7E-7,9.1667E-7,2.3333E-8,8.9E-7,4.0667E-7,5.3333E-8,3.2333E-7,-1.1E-6,1.3433E-6,1.1333E-6,1.3667E-7,3.7667E-7,-6.6666E-9,3.9667E-7,5.1333E-7,-9.9999E-9,1.1E-7,1.67E-6,1.8333E-6,1.2E-6,1.6267E-6,1.9367E-6,-2.3E-7,1.1467E-6,3.0E-8,-5.4333E-7,1.33E-6,-5.2E-7,5.8E-7,2.0333E-6,1.5833E-6,1.43E-6,-6.8333E-7,9.6667E-8,5.5667E-7,-2.0667E-7,3.1333E-7,-4.1667E-7,1.4833E-6,1.2E-7,6.9E-7,1.6033E-6,3.5333E-7,8.7333E-7,-6.6667E-8,-3.2E-7,1.38E-6,-6.6E-7,1.2867E-6,1.77E-6,4.1667E-7,1.8667E-7,-4.2667E-7,1.1133E-6,1.0533E-6,6.1667E-7,1.1667E-6,-1.9333E-7,1.3667E-6,1.04E-6,-3.9E-7,5.5667E-7,1.2E-7,1.71E-6,1.5E-7,1.3333E-6,1.0633E-6,-1.5667E-7,6.9E-7,4.5333E-7,-2.0E-8,1.0833E-6,7.0E-8,3.8E-7,1.0967E-6,1.95E-6,1.2533E-6,-1.8333E-7,5.2958E-4,7.5791E-4,4.9644E-4,3.389E-4,2.6747E-4,2.5968E-4,3.2678E-4,3.178E-4,2.6729E-4,2.2845E-4,2.3276E-4,2.9025E-4,2.9724E-4,2.5913E-4,2.2389E-4,2.3216E-4,2.8778E-4,2.9778E-4,2.5721E-4,2.2473E-4,2.3135E-4,2.8726E-4,2.9718E-4,2.5806E-4,2.2515E-4,2.315E-4,2.8647E-4,2.9696E-4,2.5861E-4,2.2571E-4,2.3171E-4,2.893E-4,2.998E-4,2.5789E-4,2.2535E-4,2.3225E-4,2.8879E-4,2.9832E-4,2.5883E-4,2.2525E-4,2.3224E-4,2.8888E-4,2.9995E-4,2.5836E-4,2.2659E-4,2.3186E-4,2.9024E-4,3.0078E-4,2.5796E-4,2.2647E-4,2.322E-4,2.8914E-4,3.0001E-4,2.5926E-4,2.2667E-4,2.3212E-4,2.9006E-4,3.0004E-4,2.6014E-4,2.2701E-4,2.3218E-4,2.8953E-4,3.0018E-4,2.5765E-4,2.2889E-4,2.3179E-4,2.895E-4,3.0162E-4,2.5964E-4,2.265E-4,2.3254E-4,2.8962E-4,3.0166E-4,2.5997E-4,2.2622E-4,2.33E-4,2.8993E-4,3.017E-4,2.5954E-4,2.2645E-4,2.327E-4,2.8982E-4,3.0223E-4,2.5946E-4,2.2729E-4,2.3361E-4,2.9057E-4,3.0168E-4,2.6037E-4,2.2657E-4,2.3255E-4,2.9039E-4,3.0322E-4,2.5891E-4,2.2723E-4,2.3339E-4,2.8965E-4,3.0148E-4,2.6027E-4,2.2809E-4,2.3455E-4,2.9085E-4,3.0287E-4,2.6128E-4,2.2678E-4,2.3373E-4,2.9122E-4,3.0233E-4,2.594E-4,2.265E-4,2.3384E-4,2.8996E-4,3.0299E-4,2.5903E-4,2.2696E-4,2.3406E-4,2.9139E-4,3.017E-4,2.5883E-4,2.2768E-4,2.3425E-4,2.9157E-4,3.027E-4,2.6024E-4,2.273E-4,2.3432E-4,2.9152E-4,3.0384E-4,2.6167E-4,2.2653E-4,2.339E-4,2.9039E-4,3.0304E-4,2.58E-4,2.2743E-4,2.3354E-4,2.9246E-4,3.043E-4,2.5957E-4,2.2837E-4,2.3338E-4,2.9178E-4,3.0367E-4,2.607E-4,2.2691E-4,2.3614E-4,2.9163E-4,3.0289E-4,2.5964E-4,2.2708E-4,2.3401E-4,2.9087E-4,3.0356E-4,2.6017E-4,2.262E-4,2.3476E-4,2.9203E-4,3.0327E-4,2.5974E-4,2.274E-4,2.3555E-4,2.9246E-4,3.0365E-4,2.5946E-4,2.2706E-4,2.3353E-4,2.9254E-4,3.0314E-4,2.5918E-4,2.2759E-4,2.3416E-4,2.9289E-4,3.0507E-4,2.6024E-4,2.2901E-4,2.3492E-4,2.9203E-4,3.0404E-4,2.5961E-4,2.2751E-4,2.3555E-4,2.9302E-4,3.0465E-4,2.6026E-4,2.2845E-4,2.3528E-4,2.9197E-4,3.0317E-4,2.6017E-4,2.2754E-4,2.3564E-4,2.9247E-4,3.0454E-4,2.6058E-4,2.2676E-4,2.3543E-4,2.9102E-4,3.0472E-4,2.5917E-4,2.2708E-4,2.3535E-4,2.9223E-4,3.0486E-4,2.5938E-4,2.2693E-4,2.3591E-4,2.9358E-4,3.0426E-4,2.5996E-4,2.2863E-4,2.35E-4,2.9287E-4,3.0392E-4,2.6011E-4,2.2818E-4,2.3585E-4,2.917E-4,3.0338E-4,2.6005E-4,2.2821E-4,2.3646E-4,2.9372E-4,3.058E-4,2.5974E-4,2.2912E-4,2.3664E-4,2.931E-4,3.0396E-4,2.5848E-4,2.2783E-4,2.3514E-4,2.932E-4,3.0336E-4,2.5916E-4,2.2878E-4,2.3613E-4,2.9284E-4,3.0356E-4,2.5921E-4,2.2862E-4,2.3442E-4,2.9283E-4,3.0349E-4,2.5929E-4,2.2769E-4,2.3539E-4,2.9259E-4,3.0479E-4,2.5904E-4,2.2899E-4,2.3497E-4,2.927E-4,3.0533E-4,2.594E-4,2.2796E-4,2.3728E-4,2.9197E-4,3.0368E-4,2.6001E-4,2.289E-4,2.3534E-4,2.9293E-4,3.0601E-4,2.6005E-4,2.2858E-4,2.346E-4,2.9362E-4,3.0515E-4,2.5933E-4,2.274E-4,2.3591E-4,2.9179E-4,3.0431E-4,2.607E-4,2.2786E-4,2.3559E-4,2.9309E-4,3.048E-4,2.6077E-4,2.2819E-4,2.3621E-4,2.9296E-4,3.0436E-4,2.591E-4,2.2709E-4,2.3646E-4,2.9381E-4,3.0589E-4,2.5957E-4,2.2836E-4:6
6.0667E-7,-6.6666E-9,1.2033E-6,1.07E-6,-2.7333E-7,4.5795E-4,6.2478E-4,4.426E-4,3.5109E-4,2.7794E-4,2.2329E-4,2.6895E-4,3.0002E-4,2.8311E-4,2.4472E-4,2.0994E-4,2.5711E-4,2.9338E-4,2.8128E-4,2.4394E-4,2.1005E-4,2.5752E-4,2.9251E-4,2.818E-4,2.4476E-4,2.0923E-4,2.5653E-4,2.9391E-4,2.8171E-4,2.4347E-4,2.0997E-4,2.5805E-4,2.9449E-4,2.8267E-4,2.4378E-4,2.1052E-4,2.5971E-4,2.935E-4,2.831E-4,2.4344E-4,2.1089E-4,2.59E-4,2.949E-4,2.833E-4,2.4378E-4,2.1246E-4,2.5923E-4,2.9596E-4,2.837E-4,2.442E-4,2.1166E-4,2.5898E-4,2.9617E-4,2.8365E-4,2.4359E-4,2.1301E-4,2.6035E-4,2.965E-4,2.8464E-4,2.4288E-4,2.1299E-4,2.6065E-4,2.947E-4,2.8359E-4,2.443E-4,2.1259E-4,2.5899E-4,2.971E-4,2.8537E-4,2.4311E-4,2.1217E-4,2.6048E-4,2.9573E-4,2.8296E-4,2.4228E-4,2.1321E-4,2.609E-4,2.966E-4,2.8575E-4,2.4221E-4,2.1305E-4,2.6117E-4,2.9613E-4,2.8557E-4,2.4341E-4,2.1413E-4,2.6091E-4,2.9702E-4,2.8519E-4,2.4228E-4,2.1422E-4,2.6251E-4,2.9657E-4,2.8568E-4,2.4324E-4,2.1403E-4,2.6147E-4,2.9845E-4,2.8551E-4,2.4261E-4,2.134E-4,2.6373E-4,2.972E-4,2.8368E-4,2.4376E-4,2.1379E-4,2.6272E-4,2.9707E-4,2.8551E-4,2.421E-4,2.1441E-4,2.6312E-4,2.978E-4,2.8492E-4,2.4275E-4,2.1471E-4,2.6417E-4,2.9912E-4,2.8337E-4,2.4208E-4,2.1484E-4,2.6408E-4,2.9824E-4,2.8552E-4,2.419E-4,2.1485E-4,2.6517E-4,2.9939E-4,2.8535E-4,2.4046E-4,2.1401E-4,2.6492E-4,2.9859E-4,2.8339E-4,2.4182E-4,2.1536E-4,2.6492E-4,2.9931E-4,2.8508E-4,2.4185E-4,2.1471E-4,2.664E-4,2.9838E-4,2.8428E-4,2.4262E-4,2.1586E-4,2.653E-4,2.9884E-4,2.8489E-4,2.4211E-4,2.1515E-4,2.6553E-4,2.9841E-4,2.8427E-4,2.4168E-4,2.1624E-4,2.6577E-4,2.9914E-4,2.8429E-4,2.4049E-4,2.1554E-4,2.6653E-4,2.984E-4,2.8437E-4,2.3957E-4,2.17E-4,2.6653E-4,2.9938E-4,2.8405E-4,2.4011E-4,2.1601E-4,2.6781E-4,2.9951E-4,2.8446E-4,2.3872E-4,2.1635E-4,2.6766E-4,3.0075E-4,2.8247E-4,2.3992E-4,2.1648E-4,2.6731E-4,3.0119E-4,2.8295E-4,2.3986E-4,2.161E-4,2.6827E-4,3.0184E-4,2.8345E-4,2.393E-4,2.1641E-4,2.6932E-4,2.9948E-4,2.8231E-4,2.3866E-4,2.1655E-4,2.6859E-4,2.9907E-4,2.8326E-4,2.3961E-4,2.1704E-4,2.6831E-4,3.0069E-4,2.8213E-4,2.3711E-4,2.1746E-4,2.6814E-4,3.0023E-4,2.8123E-4,2.3879E-4,2.1623E-4,2.6894E-4,3.0039E-4,2.8153E-4,2.3858E-4,2.174E-4,2.6912E-4,3.0067E-4,2.8159E-4,2.3763E-4,2.1642E-4,2.7098E-4,3.0176E-4,2.8196E-4,2.378E-4,2.1649E-4,2.7081E-4,3.0189E-4,2.821E-4,2.3892E-4,2.1847E-4,2.6999E-4,3.008E-4,2.8097E-4,2.3844E-4,2.1767E-4,2.7202E-4,3.0038E-4,2.8078E-4,2.3805E-4,2.1856E-4,2.7047E-4,3.0182E-4,2.8083E-4,2.3713E-4,2.1878E-4,2.7235E-4,3.0141E-4,2.8023E-4,2.3684E-4,2.1864E-4,2.7152E-4,3.0169E-4,2.799E-4,2.3801E-4,2.189E-4,2.707E-4,3.0242E-4,2.7968E-4,2.3823E-4,2.1819E-4,2.7235E-4,3.0082E-4,2.7974E-4,2.3743E-4,2.1918E-4,2.7266E-4,3.03E-4,2.7959E-4,2.3602E-4,2.2005E-4,2.7283E-4,3.0144E-4,2.7962E-4,2.348E-4,2.177E-4,2.7211E-4,3.019E-4,2.7925E-4,2.3553E-4:6
1.2233E-6,2.29E-6,3.6667E-6,-1.4467E-6,1.79E-6,-8.5333E-7,7.2333E-7,3.0267E-6,-2.48E-6,2.96E-6,1.8133E-6,8.4E-7,6.16E-6,-5.0667E-7,4.0667E-6,8.8E-7,-7.0333E-7,3.6467E-6,-8.0E-8,2.8567E-6,0.0029416,0.0045953,0.0022393,0.0021454,0.0015836,0.0020413,0.0019143,0.0014797,0.0013702,0.0013571,0.0016518,0.001688,0.0013849,0.0012465,0.0013218,0.0015712,0.0016416,0.00137,0.0012258,0.0013158,0.0015607,0.0016425,0.0013603,0.0012219,0.0013068,0.0015574,0.0016371,0.0013745,0.0012163,0.0013055,0.0015593,0.0016379,0.0013734,0.0012165,0.0013074,0.0015599,0.0016403,0.0013792,0.0012169,0.0013013,0.0015592,0.001641,0.0013808,0.0012191,0.0012997,0.0015555,0.0016376,0.0013809,0.0012157,0.0012957,0.0015576,0.0016412,0.0013849,0.0012203,0.0012948,0.0015536,0.0016413,0.0013878,0.0012203,0.0012929,0.0015541,0.0016408,0.001389,0.001218,0.0012882,0.0015472,0.0016415,0.0013943,0.0012189,0.0012868,0.0015463,0.0016416,0.0013978,0.0012186,0.0012865,0.0015484,0.0016416,0.0014017,0.0012201,0.0012804,0.0015454,0.0016413,0.0014036,0.0012198,0.0012834,0.0015472,0.0016418,0.0014067,0.0012199,0.0012801,0.0015405,0.0016403,0.0014093,0.0012219,0.0012775,0.0015352,0.0016389,0.0014109,0.0012219,0.0012706,0.0015352,0.0016407,0.0014148,0.0012244,0.0012701,0.0015322,0.0016433,0.0014195,0.0012258,0.0012717,0.0015303,0.0016439,0.0014209,0.001226,0.0012644,0.0015276,0.0016447,0.0014231,0.0012253,0.0012675,0.0015261,0.0016461,0.0014279,0.0012287,0.0012631,0.0015271,0.0016444,0.0014294,0.0012276,0.0012603,0.0015223,0.0016424,0.001429,0.0012279,0.0012593,0.0015207,0.0016425,0.0014363,0.0012287,0.0012576,0.001518,0.0016448,0.0014415,0.0012313,0.0012545,0.0015187,0.0016441,0.0014421,0.0012293,0.0012519,0.0015149,0.0016422,0.0014418,0.0012325,0.0012513,0.0015138,0.0016412,0.0014486,0.0012347,0.0012497,0.0015131,0.0016405,0.0014495,0.0012327,0.0012454,0.0015047,0.0016404,0.0014525,0.0012347,0.0012431,0.0015038,0.0016386,0.0014574,0.0012361,0.0012421,0.0015011,0.0016396,0.0014582,0.0012396,0.0012374,0.0014974,0.0016362,0.001461,0.0012364,0.0012336,0.0014958,0.0016378,0.0014631,0.0012379,0.0012374,0.0014918,0.0016389,0.0014686,0.0012405,0.0012325,0.001488,0.001639,0.0014694,0.0012402,0.0012281,0.0014871,0.0016382,0.0014761,0.0012426,0.0012296,0.001486,0.0016356,0.0014794,0.0012457,0.0012247,0.0014858,0.0016396,0.0014829,0.0012457,0.001224,0.0014832,0.0016335,0.0014805,0.0012474,0.0012229,0.0014821,0.0016342,0.0014904,0.0012506,0.0012242,0.001479,0.0016347,0.0014914,0.0012506,0.00122,0.0014742,0.0016346,0.0014937,0.0012541,0.0012166,0.0014692,0.0016324,0.0014967,0.0012568,0.0012167,0.0014717,0.0016379,0.0015013,0.0012575,0.0012174,0.001471,0.0016355,0.0015043,0.0012555,0.0012126,0.0014618,0.0016333,0.0015021,0.0012588,0.0012121,0.0014681,8.9368E-4:6
1.33E-6,3.3367E-6,1.4E-7,2.84E-6,-2.2867E-6,1.6333E-6,4.9633E-6,7.0333E-7,3.2167E-6,1.0733E-6,-2.0667E-7,1.9933E-6,5.2333E-7,4.7033E-6,-8.7333E-7,3.6733E-6,2.9433E-6,-1.34E-6,2.15E-6,-1.5567E-6,3.2033E-6,3.8633E-6,2.5033E-6,3.5E-6,-8.8E-7,2.1867E-6,4.3367E-6,-3.2333E-7,1.8967E-6,-7.0E-8,3.4333E-6,2.5033E-6,1.4833E-6,1.4033E-6,0.0041337,0.0029741,0.0021131,0.0014881,0.0013481,0.0011526,0.00144,0.0014348,0.0012101,0.0010244,0.0010748,0.0012748,0.0013347,0.0011736,9.7074E-4,0.0010593,0.0012417,0.0013205,0.0011696,9.637E-4,0.0010555,0.0012376,0.0013168,0.0011733,9.633E-4,0.001053,0.0012328,0.001316,0.0011715,9.6164E-4,0.0010484,0.0012303,0.0013161,0.0011773,9.6408E-4,0.0010482,0.0012263,0.0013176,0.0011833,9.6448E-4,0.0010466,0.0012245,0.0013191,0.001183,9.6562E-4,0.0010441,0.001221,0.0013183,0.0011853,9.6467E-4,0.0010393,0.0012199,0.0013195,0.0011917,9.7008E-4,0.0010391,0.0012205,0.0013197,0.0011945,9.7E-4,0.0010383,0.0012172,0.0013183,0.0011956,9.7213E-4,0.0010345,0.0012133,0.0013184,0.0012027,9.7389E-4,0.001032,0.0012145,0.00132,0.0012073,9.7884E-4,0.0010322,0.0012097,0.0013203,0.0012071,9.7703E-4,0.0010276,0.0012046,0.0013197,0.0012096,9.7653E-4,0.0010267,0.0012023,0.0013216,0.0012136,9.825E-4,0.0010286,0.0012022,0.0013203,0.0012138,9.7862E-4,0.0010223,0.001194,0.0013184,0.0012145,9.8141E-4,0.0010192,0.0011949,0.0013215,0.0012195,9.8472E-4,0.0010212,0.0011928,0.00132,0.0012251,9.8629E-4,0.0010164,0.0011907,0.0013174,0.0012268,9.8456E-4,0.0010144,0.0011873,0.001316,0.0012296,9.8821E-4,0.0010147,0.0011842,0.0013188,0.0012344,9.9031E-4,0.0010166,0.0011849,0.0013231,0.0012366,9.9428E-4,0.0010114,0.0011791,0.0013165,0.001236,9.927E-4,0.0010078,0.0011747,0.0013164,0.0012394,9.9808E-4,0.0010083,0.0011751,0.0013178,0.0012414,9.9767E-4,0.0010059,0.0011711,0.0013146,0.0012435,9.9636E-4,0.001003,0.0011662,0.0013131,0.0012484,0.001001,0.0010044,0.0011653,0.0013163,0.0012505,0.0010052,0.001006,0.0011626,0.001312,0.0012533,0.0010039,0.0010009,0.0011596,0.0013111,0.0012519,0.0010075,0.0010007,0.001157,0.0013142,0.0012602,0.001008,9.9901E-4,0.0011537,0.0013116,0.00126,0.0010115,9.952E-4,0.0011493,0.0013073,0.0012612,0.0010134,9.9304E-4,0.0011468,0.0013122,0.0012618,0.0010171,9.9854E-4,0.0011492,0.001313,0.0012676,0.0010168,9.9709E-4,0.0011453,0.0013078,0.0012683,0.0010192,9.9383E-4,0.0011415,0.001306,0.001271,0.0010209,9.9359E-4,0.0011405,0.0013069,0.0012729,0.0010223,9.9145E-4,0.0011346,0.0013011,0.0012746,0.0010236,9.9069E-4,0.0011306,0.0013057,0.0012761,0.0010244,9.8745E-4,0.0011282,0.0013033,0.0012795,0.0010278,9.8892E-4,0.0011288,0.0013006,0.0012851,0.0010292,9.9036E-4,0.0011229,0.0013002,0.0012828,0.001033,9.8911E-4,0.0011201,0.0013019,0.0012865,0.0010367,9.8769E-4,0.0011217,0.0013045,0.0012915,0.0010394,9.8685E-4,0.001119,0.0012975,0.0012891,0.0010431,9.8607E-4,0.0011123,0.0012974,0.0012925,0.0010436,9.8257E-4,0.001112,0.0012981,0.0012978,1.2132E-4:6
-2.6667E-7,8.3334E-8,2.1133E-6,-1.2333E-7,4.2467E-6,7.1667E-7,1.9E-7,2.2133E-6,-2.4833E-6,1.15E-6,-5.0667E-7,2.7667E-7,2.1233E-6,-9.2333E-7,5.4667E-6,2.5E-7,1.94E-6,2.4067E-6,-1.6833E-6,2.6967E-6,1.1133E-6,1.3167E-6,7.8867E-6,3.4333E-7,2.5567E-6,-3.7E-7,-5.3333E-7,2.5867E-6,-6.3E-7,3.6533E-6,1.02E-6,1.36E-6,2.1833E-6,-8.4E-7,2.3967E-6,1.04E-6,4.3E-7,2.1433E-6,-6.0667E-7,3.3767E-6,6.2667E-7,6.4333E-7,2.87E-6,-1.5067E-6,3.1733E-6,1.5567E-6,1.18E-6,3.1033E-6,-2.1233E-6,3.3233E-6,1.19E-6,-2.7333E-7,3.14E-6,-5.5667E-7,3.5867E-6,1.2133E-6,2.2933E-6,2.88E-6,-1.32E-6,2.2767E-6,2.1633E-6,1.0233E-6,3.94E-6,-1.8833E-6,1.8833E-6,1.19E-6,5.6667E-7,4.6E-6,-1.3E-6,0.003476,0.0033721,0.0023864,0.0016318,0.0013752,0.0013081,0.0015211,0.0015248,0.0012304,0.0010889,0.0011359,0.0013527,0.0014155,0.0011744,0.0010435,0.0011074,0.0013284,0.0013923,0.0011669,0.001036,0.0010997,0.0013176,0.0013892,0.0011656,0.001033,0.0010921,0.0013141,0.0013895,0.001168,0.0010323,0.0010957,0.0013128,0.0013897,0.0011687,0.0010317,0.0010941,0.0013097,0.0013843,0.0011714,0.0010312,0.0010895,0.0013115,0.0013881,0.0011746,0.0010314,0.0010861,0.0013077,0.0013876,0.0011769,0.0010327,0.001085,0.0013067,0.0013919,0.0011809,0.0010345,0.0010846,0.0013022,0.0013892,0.0011807,0.0010306,0.0010794,0.0013036,0.0013882,0.0011846,0.0010337,0.0010799,0.0013006,0.0013868,0.001187,0.0010337,0.0010746,0.0013027,0.0013862,0.0011872,0.0010347,0.0010753,0.0012983,0.0013856,0.0011896,0.0010351,0.0010734,0.0012985,0.0013884,0.0011924,0.0010395,0.0010727,0.001297,0.0013895,0.0011994,0.0010386,0.0010685,0.0012944,0.0013886,0.0011979,0.0010387,0.0010695,0.0012932,0.0013911,0.0012034,0.0010415,0.0010678,0.0012892,0.0013905,0.0012058,0.0010426,0.0010637,0.0012907,0.0013867,0.0012073,0.0010391,0.0010632,0.0012863,0.0013863,0.0012107,0.0010395,0.0010612,0.0012851,0.0013868,0.0012126,0.0010424,0.0010595,0.0012866,0.0013888,0.0012145,0.0010432,0.0010567,0.0012776,0.0013874,0.0012183,0.0010432,0.0010568,0.0012822,0.0013864,0.0012227,0.001045,0.0010547,0.0012794,0.0013869,0.0012236,0.0010466,0.0010517,0.0012776,0.0013891,0.0012256,0.0010441,0.0010487,0.001278,0.0013842,0.0012279,0.0010506,0.0010493,0.0012759,0.0013872,0.0012315,0.0010489,0.001048,0.0012725,0.0013856,0.0012297,0.0010496,0.0010455,0.0012701,0.0013843,0.0012337,0.0010478,0.0010426,0.0012697,0.0013859,0.001237,0.0010527,0.0010443,0.0012677,0.0013858,0.0012395,0.0010529,0.0010379,0.0012642,0.0013841,0.0012384,0.0010509,0.0010375,0.0012614,0.0013826,0.0012454,0.0010536,0.0010354,0.0012601,0.0013814,0.0012447,0.0010557,0.0010337,0.0012563,0.0013815,0.0012469,0.0010562,0.0010335,0.0012538,0.0013806,0.0012504,0.0010567,0.0010347,0.0012533,0.0013846,0.001254,0.0010599,0.0010306,0.001254,0.0013823,0.0012536,0.0010588,0.00103,0.0012504,0.0013792,0.0012546,0.0010601,0.0010282,0.0012515,0.0013831,0.0012617,0.001062,0.0010284,0.0012506,0.0013853,0.0012625,0.001064,0.0010262,0.0012474,0.0013814,0.0012659,0.0010633,0.0010218,0.001241,0.0013824,0.0012693,0.0010667,0.0010243,0.0012446,0.0013813,0.001273,0.0010662,0.0010238,0.0012399,0.0013782,0.0012716,0.0010694,0.0010204,0.0012391,0.0013762,0.0012726,0.0010704,0.0010201,0.0012406,0.0013771,0.0012747,0.0010742,0.0010197,0.0012375,0.0013812,0.0012796,0.0010736,0.0010192,0.0012365,0.0013761,0.0012816,0.0010728,0.0010158,0.0012286,0.0013776,0.0012843,0.0010752,0.0010142,0.0012318,0.0013768,0.0012844,0.0010799,0.0010132,0.0012281,0.0013754,0.0012883,0.0010797,0.0010114,0.0012243,0.0013736,0.0012884,0.0010793,0.0010135,0.0012225,0.0013722,0.0012925,0.001084,0.0010112,0.0012238,0.0013732,0.0012951,0.0010843,0.0010112,0.0012203,0.0013713,0.0012951,0.0010879,0.0010099,0.0012194,0.001372,0.0012993,0.0010889,0.0010079,0.0012204,0.0013737,0.0013058,0.0010909,0.0010103,0.0012201,0.00138,0.0013217,1.044E-4:6
1.9983E-5,1.9197E-5,8.13E-6,1.6463E-5,1.34E-6,1.415E-5,1.6017E-5,8.7467E-6,1.973E-5,5.6867E-6,1.254E-5,2.0653E-5,1.3433E-5,1.729E-5,5.7667E-7,1.959E-5,1.5867E-5,1.6393E-5,1.1713E-5,4.0833E-6,1.728E-5,1.7817E-5,0.0071567,0.0030855,0.0022486,0.0024084,0.0025403,0.002206,0.0018558,0.001668,0.0020313,0.0023051,0.0021163,0.0017926,0.0016484,0.0020157,0.0023096,0.0021118,0.0017987,0.0016464,0.0020222,0.0023066,0.0021177,0.0017985,0.0016518,0.0020155,0.0023092,0.0021202,0.0018016,0.001662,0.0020204,0.0023124,0.0021261,0.0018074,0.0016624,0.0020345,0.0023146,0.0021236,0.0018002,0.0016592,0.0020332,0.0023196,0.0021342,0.0018017,0.0016686,0.0020351,0.0023217,0.0021387,0.0018144,0.00166,0.002038,0.0023053,0.0021436,0.0018034,0.0016665,0.0020342,0.0023171,0.0021399,0.0018116,0.001667,0.002036,0.0023243,0.0021466,0.0018107,0.0016667,0.0020438,0.0023226,0.0021562,0.0018095,0.0016764,0.0020431,0.0023288,0.00215,0.0018013,0.0016769,0.0020346,0.0023287,0.0021448,0.0018113,0.0016755,0.002042,0.0023341,0.00215,0.0018095,0.0016713,0.002039,0.0023348,0.0021506,0.0018105,0.0016758,0.0020445,0.0023242,0.0021501,0.0018157,0.0016758,0.0020454,0.0023327,0.0021501,0.001812,0.0016798,0.0020483,0.0023319,0.0021576,0.0018116,0.0016885,0.0020487,0.0023343,0.0021636,0.0018145,0.00169,0.0020504,0.0023383,0.0021649,0.0018149,0.001691,0.0020496,0.0023362,0.002161,0.0018175,0.0016882,0.0020527,0.0023377,0.0021639,0.0018131,0.0016932,0.0020502,0.002343,0.0021588,0.00181,0.001684,0.002054,0.0023398,0.0021693,0.0018091,0.0016861,0.0020616,0.002339,0.0021696,0.0018129,0.0016868,0.0020598,0.0023493,0.0021686,0.0018035,0.0016911,0.0020676,0.002339,0.0021657,0.0018112,0.0016901,0.0020647,0.0023449,0.0021673,0.0018188,0.0017032,0.002058,0.0023493,0.0021715,0.0018122,0.0016972,0.0020629,0.002343,0.0021614,0.001809,0.0016986,0.0020684,0.002342,0.002166,0.0018089,0.0016901,0.0020639,0.0023455,0.0021601,0.0018137,0.001692,0.0020655,0.0023515,0.00216,0.001808,0.0016865,0.002076,0.0023521,0.0021655,0.0018094,0.0016963,0.0020635,0.0023474,0.0021664,0.0018044,0.001708,0.0020667,0.0023507,0.0021829,0.0018094,0.0017043,0.0020688,0.0023489,0.0021677,0.0018077,0.0017007,0.0020697,0.0023481,0.0021624,0.0018037,0.0016942,0.0020684,0.0023487,0.0021631,0.0018116,0.0016916,0.0020761,0.0023503,0.0021644,0.0018096,0.001692,0.0020775,0.0023435,0.0021523,0.0018051,0.0016935,0.0020729,0.002359,0.0021602,0.0018049,0.0017049,0.0020707,0.0023516,0.0021708,0.0018001,0.0017035,0.0020738,0.0023451,0.0021646,0.0018065,0.0017007,0.0020741,0.0023493,0.0021603,0.0018005,0.0017034,0.0020736,0.0023496,0.0021623,0.0018064,0.0017003,0.0020778,0.00235,0.0021591,0.0018091,0.001698,0.0020907,0.002353,0.0021581,0.0018068,0.0017024,0.0020851,0.0023422,0.0021592,0.0017967,0.0017072,0.0020717,0.0023609,0.0021691,0.0017968,0.0017018,0.0020843,0.0023465,0.0021655,0.0018039,0.0017105,0.0020826,0.0023533,0.0021605,0.0018028,0.0017106,0.0020768,0.0023505,0.00215,0.0017908,0.0017017,0.0020762,0.0023548,0.0021512,0.0018042,0.0017082,0.0020827,0.0023557,0.0021551,0.0017939,0.0017067,0.0020856,0.0023453,0.0021542,0.0018043,0.0017096,0.0020873,0.0023573,0.0021522,0.0017942,0.0017132,0.0020922,0.0023521,0.00215,0.0017976,0.0017143,0.0020829,0.0023539,0.0021621,0.0017959,0.0017093,0.0020832,0.0023561,0.0021545,0.0017964,0.0017158,0.002092,0.0012829:6
1.6337E-5,1.4787E-5,3.61E-6,1.4537E-5,8.9767E-6,2.3913E-5,1.138E-5,7.2933E-6,1.083E-5,1.1373E-5,1.9673E-5,7.8467E-6,4.22E-6,1.685E-5,4.6967E-6,1.9583E-5,1.857E-5,-1.0367E-6,1.6187E-5,8.62E-6,2.523E-5,1.7093E-5,6.6333E-7,1.3303E-5,6.0867E-6,2.423E-5,8.6967E-6,2.77E-6,1.5317E-5,6.69E-6,0.0057438,0.0040813,0.002191,0.0022475,0.0022932,0.002404,0.0021162,0.001677,0.0017633,0.0020902,0.0022669,0.0020418,0.0016599,0.0017541,0.0020927,0.0022706,0.0020399,0.0016636,0.0017413,0.0020855,0.0022732,0.0020417,0.0016708,0.0017534,0.0020942,0.0022759,0.0020545,0.0016646,0.001769,0.0020942,0.0022786,0.0020666,0.0016622,0.0017598,0.0020967,0.0022835,0.0020588,0.0016665,0.0017796,0.0021074,0.0022912,0.0020605,0.0016712,0.0017707,0.0021037,0.0022874,0.002069,0.0016699,0.001771,0.002115,0.0022927,0.0020658,0.0016735,0.0017806,0.002118,0.0022974,0.0020636,0.0016751,0.0017735,0.0021136,0.0023024,0.0020631,0.0016696,0.0017801,0.0021252,0.0023066,0.0020635,0.001678,0.0017841,0.0021218,0.0023038,0.0020702,0.0016775,0.0017806,0.0021222,0.0022996,0.0020692,0.00168,0.0017812,0.0021292,0.0023063,0.002069,0.001687,0.0017798,0.0021338,0.002304,0.0020765,0.0016769,0.001791,0.0021252,0.0023151,0.0020752,0.0016761,0.0017891,0.0021316,0.0023094,0.0020735,0.0016826,0.0017842,0.0021412,0.0023105,0.0020697,0.0016807,0.0017917,0.0021359,0.0023106,0.0020673,0.0016802,0.001795,0.0021483,0.0023166,0.0020723,0.0016776,0.0017919,0.0021399,0.0023117,0.0020734,0.0016779,0.0017977,0.0021311,0.002326,0.0020771,0.0016749,0.0018011,0.0021352,0.0023237,0.0020739,0.0016902,0.0018062,0.0021418,0.0023215,0.0020733,0.0016842,0.0018053,0.0021417,0.0023299,0.0020677,0.0016903,0.0017988,0.0021499,0.0023164,0.0020646,0.0016915,0.0017983,0.0021547,0.0023151,0.0020642,0.0016802,0.0018012,0.0021466,0.0023186,0.0020646,0.001688,0.0018007,0.0021511,0.0023253,0.0020688,0.0016819,0.0018111,0.002154,0.0023221,0.0020714,0.0016784,0.0018145,0.0021531,0.0023246,0.0020702,0.0016806,0.001813,0.0021541,0.0023235,0.0020587,0.001685,0.0018152,0.0021571,0.0023272,0.0020662,0.0016857,0.0018084,0.0021567,0.0023369,0.0020633,0.0016773,0.0018185,0.0021614,0.0023232,0.0020617,0.0016849,0.0018129,0.0021599,0.0023211,0.0020603,0.0016784,0.001818,0.0021619,0.002324,0.0020646,0.0016722,0.0018226,0.002165,0.0023287,0.0020642,0.0016848,0.001816,0.002168,0.0023267,0.0020598,0.0016832,0.0018258,0.002174,0.002335,0.0020605,0.0016864,0.0018217,0.002178,0.0023311,0.0020533,0.001686,0.0018253,0.0021729,0.002331,0.0020592,0.0016836,0.0018178,0.002176,0.00233,0.0020618,0.0016796,0.0018241,0.0021692,0.0023316,0.0020643,0.0016824,0.0018342,0.0021796,0.0023276,0.0020571,0.0016789,0.0018322,0.0021676,0.002337,0.00206,0.0016792,0.001831,0.0021754,0.002336,0.0020496,0.0016807,0.0018323,0.002175,0.0023295,0.0020628,0.0016873,0.0018337,0.0021734,0.0023358,0.002049,0.0016846,0.0018274,0.0021771,0.0023358,0.0020523,0.0016857,0.0018392,0.0021768,0.0023227,0.0020559,0.0016825,0.0017983,0.0021457,0.0022974,0.0020287,0.0016599,0.0018136,0.0021662,0.0023109,0.0020338,0.0016686,0.0018188,0.0021521,0.002308,0.0020252,0.0016632,0.0018226,0.0021555,0.0023088,0.0020259,0.0016623,0.0018324,0.0021636,0.002303,0.0020342,0.0016686,0.0018304,0.0021636,0.0023119,0.0020322,0.0016759,0.001828,0.0021752,0.0023197,0.0020313,0.0016726,0.0018296,0.0021743,0.0023096,0.0020351,0.0016611,0.0018252,0.0021674,0.0023163,0.0020314,0.0016646,0.0018321,0.0021696,0.002319,0.0020274,0.0016672,0.0018281,0.0021682,0.0023155,0.0020289,0.001664,0.0018348,0.002169,0.0023283,0.0020358,0.0016714,0.0018411,0.0021982,0.0023434,0.0020324,0.0016847,0.0018393,0.0021969,0.0023349,0.0020386,0.0016823,0.0018462,0.0021861,0.002335,0.0020426,0.0016778,0.0018368,0.0021943,0.0023245,0.0020379,0.0016749,0.0018542,0.0021931,0.0023273,0.0020438,0.0016686,0.0018491,0.0021871,0.002332,0.0020399,0.0016719,0.0018496,0.0021847,0.0023291,0.0020446,0.0016736,6.7765E-4:6
5.6667E-8,3.0367E-6,7.6E-7,-7.0E-8,2.75E-6,-2.0767E-6,1.6233E-6,1.9403E-13,8.1E-7,2.4267E-6,-4.7333E-7,1.9667E-6,7.6333E-7,4.0333E-7,1.82E-6,-2.4253E-14,2.1533E-6,1.52E-6,1.48E-6,1.8633E-6,-1.5633E-6,3.2733E-6,9.0E-8,1.5133E-6,1.5633E-6,5.9667E-7,2.52E-6,6.3667E-7,-2.2667E-7,1.1067E-6,-7.4E-7,2.0267E-6,7.0E-8,1.4E-7,2.08E-6,-1.0333E-6,1.9367E-6,6.8667E-7,4.1E-7,1.81E-6,-3.9333E-7,2.7333E-6,1.6867E-6,-1.0E-7,1.61E-6,-1.47E-6,1.38E-6,5.5E-7,9.6667E-7,6.6333E-7,-2.6E-7,1.8667E-6,-2.0E-7,0.0015096,0.0010341,5.892E-4,5.831E-4,6.0683E-4,6.0242E-4,5.1027E-4,4.2247E-4,4.2835E-4,5.2449E-4,5.4332E-4,4.7796E-4,4.1022E-4,4.172E-4,5.1754E-4,5.3848E-4,4.7471E-4,4.0954E-4,4.1651E-4,5.1909E-4,5.3834E-4,4.7578E-4,4.122E-4,4.1494E-4,5.1792E-4,5.4132E-4,4.7783E-4,4.1268E-4,4.1479E-4,5.1977E-4,5.4044E-4,4.7785E-4,4.1165E-4,4.1738E-4,5.1727E-4,5.4101E-4,4.7993E-4,4.1144E-4,4.1727E-4,5.1793E-4,5.4212E-4,4.7933E-4,4.1179E-4,4.1643E-4,5.1584E-4,5.4339E-4,4.7706E-4,4.14E-4,4.1554E-4,5.1645E-4,5.4632E-4,4.7776E-4,4.134E-4,4.1367E-4,5.1596E-4,5.456E-4,4.7687E-4,4.1721E-4,4.1372E-4,5.166E-4,5.4499E-4,4.7825E-4,4.1605E-4,4.1427E-4,5.1929E-4,5.4623E-4,4.7881E-4,4.1625E-4,4.1264E-4,5.1748E-4,5.4341E-4,4.7975E-4,4.1509E-4,4.1324E-4,5.186E-4,5.4433E-4,4.8112E-4,4.1517E-4,4.1378E-4,5.1486E-4,5.4263E-4,4.8219E-4,4.1724E-4,4.1414E-4,5.1745E-4,5.4574E-4,4.8237E-4,4.1538E-4,4.1194E-4,5.1525E-4,5.4676E-4,4.8379E-4,4.1668E-4,4.1158E-4,5.1551E-4,5.4344E-4,4.8376E-4,4.1662E-4,4.1133E-4,5.1337E-4,5.4523E-4,4.8244E-4,4.173E-4,4.1251E-4,5.1515E-4,5.4586E-4,4.8296E-4,4.1754E-4,4.1324E-4,5.1268E-4,5.4672E-4,4.8329E-4,4.1662E-4,4.1206E-4,5.1118E-4,5.4699E-4,4.8335E-4,4.1791E-4,4.1124E-4,5.1215E-4,5.4908E-4,4.8501E-4,4.1954E-4,4.1117E-4,5.1208E-4,5.4607E-4,4.845E-4,4.2035E-4,4.0927E-4,5.1245E-4,5.4648E-4,4.8526E-4,4.1955E-4,4.0826E-4,5.1421E-4,5.4593E-4,4.8493E-4,4.1932E-4,4.0981E-4,5.1588E-4,5.4666E-4,4.8869E-4,4.2036E-4,4.0889E-4,5.1275E-4,5.444E-4,4.8809E-4,4.1971E-4,4.1106E-4,5.1148E-4,5.4668E-4,4.8696E-4,4.1857E-4,4.0964E-4,5.1116E-4,5.4603E-4,4.8918E-4,4.1901E-4,4.0886E-4,5.1145E-4,5.4896E-4,4.8756E-4,4.1936E-4,4.0815E-4,5.0993E-4,5.471E-4,4.8875E-4,4.2085E-4,4.0582E-4,5.0984E-4,5.4444E-4,4.89E-4,4.2211E-4,4.0721E-4,5.0942E-4,5.4464E-4,4.9042E-4,4.2E-4,4.0861E-4,5.1085E-4,5.4763E-4,4.9267E-4,4.22E-4,4.0741E-4,5.1009E-4,5.468E-4,4.9061E-4,4.2208E-4,4.0795E-4,5.0875E-4,5.4904E-4,4.9152E-4,4.2356E-4,4.0683E-4,5.0782E-4,5.4766E-4,4.9228E-4,4.224E-4,4.0595E-4,5.0868E-4,5.4908E-4,4.937E-4,4.2496E-4,4.0749E-4,5.0815E-4,5.4702E-4,4.9352E-4,4.2402E-4,4.0621E-4,5.0647E-4,5.4829E-4,4.9389E-4,4.2294E-4,4.0666E-4,5.0514E-4,5.4655E-4,4.9432E-4,4.2317E-4,4.0498E-4,5.0619E-4,5.4844E-4,4.9465E-4,4.2463E-4,4.0511E-4,5.0378E-4,5.4875E-4,4.943E-4,4.2451E-4,4.0435E-4,5.0697E-4,5.4938E-4,4.9454E-4,4.2466E-4,4.0268E-4,5.0737E-4,5.4592E-4,4.9631E-4,4.2496E-4,4.0407E-4,5.0667E-4,5.4574E-4,4.9534E-4,4.2597E-4,4.0473E-4,5.061E-4,5.4607E-4,4.99E-4,4.2251E-4,4.05E-4,5.0435E-4,5.4603E-4,4.9979E-4,4.244E-4,4.0482E-4,5.0196E-4,5.4756E-4,4.973E-4,4.2338E-4,4.0415E-4,5.0318E-4,5.49E-4,4.9891E-4,4.2358E-4,4.0384E-4,5.0364E-4,5.4553E-4,4.9644E-4,4.2523E-4,4.0159E-4,5.0299E-4,5.4755E-4,4.9642E-4,4.2546E-4,4.0253E-4,5.0294E-4,5.4707E-4,4.977E-4:6
-3.0E-8,1.2633E-6,-1.36E-6,2.4233E-6,7.0E-7,-5.2667E-7,1.2433E-6,-4.2667E-7,2.1333E-6,1.3167E-6,-1.3333E-8,1.6233E-6,-4.0E-8,1.1567E-6,-1.24E-6,-5.5667E-7,2.2867E-6,-1.4533E-6,1.9833E-6,1.39E-6,1.4333E-7,9.1667E-7,-1.6367E-6,1.9033E-6,5.3333E-8,-3.6666E-8,1.8233E-6,-3.6E-7,1.9167E-6,1.5667E-7,-4.5E-7,1.5733E-6,-5.3667E-7,1.97E-6,1.1333E-6,-1.03E-6,1.1167E-6,-7.7667E-7,1.7667E-6,3.4333E-7,1.2333E-6,2.1533E-6,-2.2667E-7,1.9E-6,1.01E-6,0.0013302,0.0011102,5.0604E-4,6.863E-4,6.134E-4,6.0292E-4,5.0229E-4,4.1201E-4,4.6427E-4,5.4114E-4,5.4865E-4,4.5809E-4,4.1224E-4,4.4325E-4,5.3662E-4,5.4619E-4,4.5382E-4,4.1175E-4,4.4272E-4,5.3642E-4,5.4751E-4,4.5333E-4,4.1327E-4,4.413E-4,5.3579E-4,5.4798E-4,4.5443E-4,4.144E-4,4.4066E-4,5.3933E-4,5.4745E-4,4.5296E-4,4.1456E-4,4.4014E-4,5.4066E-4,5.4734E-4,4.5649E-4,4.1574E-4,4.4107E-4,5.4016E-4,5.4503E-4,4.5664E-4,4.14E-4,4.4159E-4,5.4131E-4,5.49E-4,4.5692E-4,4.1436E-4,4.4308E-4,5.408E-4,5.4872E-4,4.5625E-4,4.1539E-4,4.4362E-4,5.3945E-4,5.4979E-4,4.5826E-4,4.1666E-4,4.4126E-4,5.4013E-4,5.5159E-4,4.5708E-4,4.1508E-4,4.4196E-4,5.4171E-4,5.4988E-4,4.5745E-4,4.1611E-4,4.4369E-4,5.424E-4,5.5104E-4,4.5695E-4,4.168E-4,4.4265E-4,5.43E-4,5.4984E-4,4.5672E-4,4.1582E-4,4.4281E-4,5.4087E-4,5.5321E-4,4.5742E-4,4.1647E-4,4.4318E-4,5.4109E-4,5.5375E-4,4.5801E-4,4.1688E-4,4.4157E-4,5.4126E-4,5.5136E-4,4.5767E-4,4.1486E-4,4.4067E-4,5.4081E-4,5.5179E-4,4.5591E-4,4.1713E-4,4.4018E-4,5.4494E-4,5.4932E-4,4.5909E-4,4.1726E-4,4.4277E-4,5.4221E-4,5.5147E-4,4.5917E-4,4.1666E-4,4.4303E-4,5.4339E-4,5.504E-4,4.5928E-4,4.1634E-4,4.4357E-4,5.4227E-4,5.5208E-4,4.6047E-4,4.1544E-4,4.4374E-4,5.3944E-4,5.5303E-4,4.5822E-4,4.1677E-4,4.4404E-4,5.4035E-4,5.5362E-4,4.561E-4,4.1678E-4,4.4238E-4,5.4035E-4,5.5318E-4,4.5733E-4,4.174E-4,4.4225E-4,5.442E-4,5.5436E-4,4.5599E-4,4.1773E-4,4.4271E-4,5.4345E-4,5.511E-4,4.589E-4,4.1877E-4,4.4251E-4,5.4341E-4,5.521E-4,4.5885E-4,4.1816E-4,4.4397E-4,5.439E-4,5.5262E-4,4.5903E-4,4.1516E-4,4.4446E-4,5.4573E-4,5.5234E-4,4.594E-4,4.1745E-4,4.4226E-4,5.4255E-4,5.5359E-4,4.5804E-4,4.1816E-4,4.4343E-4,5.45E-4,5.5201E-4,4.5809E-4,4.1761E-4,4.4147E-4,5.4439E-4,5.5287E-4,4.5823E-4,4.1751E-4,4.4568E-4,5.4308E-4,5.5318E-4,4.5813E-4,4.1566E-4,4.4467E-4,5.4424E-4,5.5354E-4,4.5924E-4,4.1617E-4,4.456E-4,5.4E-4,5.5459E-4,4.5873E-4,4.1713E-4,4.462E-4,5.4186E-4,5.5485E-4,4.5675E-4,4.1748E-4,4.4425E-4,5.4161E-4,5.556E-4,4.5719E-4,4.1943E-4,4.4126E-4,5.4223E-4,5.5396E-4,4.5684E-4,4.1878E-4,4.4388E-4,5.4446E-4,5.5133E-4,4.5703E-4,4.1914E-4,4.4159E-4,5.4539E-4,5.5263E-4,4.5808E-4,4.1698E-4,4.4518E-4,5.4363E-4,5.5198E-4,4.6029E-4,4.1712E-4,4.4481E-4,5.4304E-4,5.5525E-4,4.5859E-4,4.1671E-4,4.4467E-4,5.4197E-4,5.536E-4,4.5824E-4,4.1726E-4,4.4365E-4,5.4292E-4,5.5414E-4,4.5667E-4,4.1572E-4,4.4378E-4,5.4444E-4,5.5449E-4,4.573E-4,4.1763E-4,4.4453E-4,5.4391E-4,5.5013E-4,4.5699E-4,4.1957E-4,4.4438E-4,5.4551E-4,5.5105E-4,4.5818E-4,4.1712E-4,4.4447E-4,5.4268E-4,5.5365E-4,4.5761E-4,4.1658E-4,4.4384E-4,5.4213E-4,5.5316E-4,4.5577E-4,4.161E-4,4.4497E-4,5.4184E-4,5.5429E-4,4.5845E-4,4.1947E-4,4.4233E-4,5.4373E-4,5.54E-4,4.5609E-4,4.1891E-4,4.429E-4,5.4581E-4,5.5227E-4,4.5905E-4,4.1884E-4,4.435E-4,5.4661E-4,5.5108E-4,4.5675E-4,4.1799E-4,4.4349E-4,5.4352E-4,5.5176E-4,4.588E-4,4.1627E-4,4.4681E-4,5.4387E-4,5.5048E-4,4.5847E-4,4.1641E-4,4.4672E-4,5.4265E-4,5.5403E-4,4.5829E-4,4.1803E-4,4.4697E-4,5.428E-4,5.5547E-4,4.5628E-4,4.1746E-4,1.8205E-4:6
-1.45E-6,2.1067E-6,2.0E-8,3.0967E-6,1.0467E-6,-2.5333E-7,1.63E-6,-2.7367E-6,1.6133E-6,4.6333E-7,-9.1667E-7,2.2867E-6,-6.8333E-7,2.2133E-6,8.3333E-7,-1.17E-6,2.24E-6,-9.8E-7,1.7067E-6,2.0567E-6,-1.0E-8,2.0167E-6,-1.1733E-6,1.87E-6,6.9E-7,-9.0E-7,2.6267E-6,-4.7333E-7,2.2033E-6,2.1467E-6,-7.0333E-7,2.13E-6,-2.01E-6,1.92E-6,1.05E-6,2.3333E-7,3.1033E-6,-7.7E-7,2.9867E-6,1.32E-6,-7.0667E-7,2.3633E-6,-1.3567E-6,2.3967E-6,1.49E-6,-7.9667E-7,1.5733E-6,-1.2967E-6,1.7833E-6,1.1367E-6,1.7333E-7,2.2733E-6,-8.5E-7,1.97E-6,1.47E-6,-1.7133E-6,2.79E-6,-1.72E-6,2.15E-6,1.9167E-6,0.0014419,0.0010148,5.3616E-4,7.3921E-4,6.4631E-4,5.338E-4,4.527E-4,4.3313E-4,5.2857E-4,5.6E-4,5.0122E-4,4.0582E-4,4.3514E-4,5.1114E-4,5.5223E-4,4.9802E-4,4.0118E-4,4.3463E-4,5.0939E-4,5.485E-4,4.9995E-4,3.989E-4,4.3454E-4,5.0885E-4,5.51E-4,4.9966E-4,3.9861E-4,4.3597E-4,5.0875E-4,5.4947E-4,4.9891E-4,3.9736E-4,4.3714E-4,5.0911E-4,5.5106E-4,5.0062E-4,4.0055E-4,4.3509E-4,5.101E-4,5.5406E-4,4.995E-4,3.995E-4,4.3699E-4,5.0746E-4,5.5247E-4,4.9956E-4,3.997E-4,4.3767E-4,5.1072E-4,5.5382E-4,4.9969E-4,4.0243E-4,4.3391E-4,5.1103E-4,5.5295E-4,5.0108E-4,4.0172E-4,4.3584E-4,5.1172E-4,5.5086E-4,5.0286E-4,4.0059E-4,4.3687E-4,5.1255E-4,5.4977E-4,5.0289E-4,3.9947E-4,4.3729E-4,5.1112E-4,5.5062E-4,5.0147E-4,3.9983E-4,4.3819E-4,5.1153E-4,5.5321E-4,5.0278E-4,4.0003E-4,4.3766E-4,5.1128E-4,5.5301E-4,5.0181E-4,4.0226E-4,4.3731E-4,5.1146E-4,5.5373E-4,5.0048E-4,4.0049E-4,4.3862E-4,5.1289E-4,5.5232E-4,5.0149E-4,3.9981E-4,4.3825E-4,5.1259E-4,5.5227E-4,5.0177E-4,4.0238E-4,4.3783E-4,5.1165E-4,5.517E-4,5.0123E-4,4.0007E-4,4.3636E-4,5.113E-4,5.5474E-4,5.0012E-4,4.0136E-4,4.3744E-4,5.1186E-4,5.5375E-4,5.0144E-4,4.0144E-4,4.3806E-4,5.1277E-4,5.5489E-4,4.986E-4,4.0187E-4,4.3765E-4,5.1444E-4,5.5198E-4,5.0118E-4,4.0051E-4,4.3685E-4,5.1493E-4,5.5225E-4,5.0292E-4,3.998E-4,4.3928E-4,5.1518E-4,5.5158E-4,5.03E-4,4.0002E-4,4.3976E-4,5.1275E-4,5.5122E-4,5.0183E-4,3.9904E-4,4.4045E-4,5.1298E-4,5.5379E-4,5.0181E-4,3.9946E-4,4.4024E-4,5.1145E-4,5.5534E-4,5.0095E-4,4.0087E-4,4.4E-4,5.119E-4,5.5491E-4,4.9954E-4,4.0128E-4,4.3698E-4,5.124E-4,5.5487E-4,5.0103E-4,4.023E-4,4.3744E-4,5.1416E-4,5.5432E-4,5.0213E-4,4.0091E-4,4.3687E-4,5.1386E-4,5.5073E-4,5.0149E-4,4.0168E-4,4.3983E-4,5.1298E-4,5.5288E-4,4.9993E-4,3.9991E-4,4.3864E-4,5.1205E-4,5.5352E-4,5.0274E-4,4.0049E-4,4.3892E-4,5.1351E-4,5.5238E-4,5.0231E-4,3.9931E-4,4.3834E-4,5.1454E-4,5.5393E-4,5.0018E-4,4.0073E-4,4.37E-4,5.1351E-4,5.5127E-4,5.0169E-4,4.0046E-4,4.3902E-4,5.1462E-4,5.5176E-4,5.0172E-4,3.9879E-4,4.3945E-4,5.1491E-4,5.542E-4,5.0278E-4,3.9913E-4,4.4088E-4,5.1366E-4,5.5297E-4,5.0077E-4,3.9924E-4,4.4022E-4,5.1301E-4,5.5402E-4,4.9821E-4,4.0152E-4,4.3859E-4,5.121E-4,5.5286E-4,4.9906E-4,4.0173E-4,4.4026E-4,5.1267E-4,5.521E-4,4.9731E-4,4.0134E-4,4.3831E-4,5.1498E-4,5.5131E-4,5.0071E-4,4.0123E-4,4.3924E-4,5.1499E-4,5.5163E-4,5.0222E-4,3.9965E-4,4.3929E-4,5.1605E-4,5.538E-4,5.0217E-4,3.9972E-4,4.3781E-4,5.1568E-4,5.5175E-4,5.0226E-4,4.0029E-4,4.4061E-4,5.1392E-4,5.5455E-4,5.0219E-4,3.9868E-4,4.4135E-4,5.1449E-4,5.5376E-4,5.0029E-4,3.9911E-4,4.397E-4,5.1424E-4,5.5372E-4,5.0137E-4,4.0179E-4,4.3929E-4,5.1621E-4,5.5373E-4,5.0155E-4,4.0108E-4,4.3965E-4,5.168E-4,5.5306E-4,5.0234E-4,3.9946E-4,4.3952E-4,5.1374E-4,5.5441E-4,5.0312E-4,4.0098E-4,4.4159E-4,5.1485E-4,5.5561E-4,5.0051E-4,3.9997E-4,4.3953E-4,5.1662E-4,5.5554E-4,5.02E-4,4.0062E-4,4.4199E-4,5.131E-4,5.5231E-4,4.9861E-4,4.0021E-4,4.4006E-4,5.1792E-4,5.5289E-4,5.0117E-4,4.0182E-4,4.4102E-4,5.189E-4,5.522E-4,5.0317E-4,4.0156E-4,4.4039E-4,5.1596E-4,5.5139E-4,5.0425E-4,3.9945E-4,4.4245E-4,5.1637E-4,5.5212E-4,5.0208E-4,4.0026E-4,4.404E-4,5.1488E-4,5.5374E-4:6
1.93E-6,-4.2667E-7,2.4667E-6,-4.6E-7,3.22E-6,1.02E-6,-5.5333E-7,3.7433E-6,7.6E-7,2.2633E-6,2.74E-6,-1.1367E-6,2.79E-6,7.0E-8,2.0433E-6,5.3333E-8,2.3767E-6,3.62E-6,-8.9333E-7,2.2367E-6,3.37E-6,1.9533E-6,7.3667E-7,0.0032174,0.0023362,0.0016871,0.0014016,0.0011497,9.2544E-4,0.0011609,0.0012332,0.0011439,9.3494E-4,8.9247E-4,0.0010602,0.0011864,0.0011178,9.0708E-4,8.95E-4,0.0010511,0.0011835,0.0011182,9.034E-4,8.9268E-4,0.0010526,0.0011814,0.0011165,9.0318E-4,8.95E-4,0.0010505,0.00118,0.0011111,9.0283E-4,8.9562E-4,0.0010537,0.001176,0.0011087,9.0019E-4,8.9593E-4,0.0010497,0.0011806,0.0011082,8.9599E-4,8.9745E-4,0.001052,0.0011743,0.0011077,8.9287E-4,8.9488E-4,0.0010556,0.001178,0.0011056,8.9323E-4,8.9807E-4,0.0010575,0.0011772,0.0011031,8.9152E-4,8.9641E-4,0.0010571,0.0011796,0.001101,8.8671E-4,8.9854E-4,0.0010587,0.0011755,0.0011005,8.9106E-4,8.9474E-4,0.0010628,0.0011774,0.0011016,8.8575E-4,8.9838E-4,0.0010678,0.0011776,0.0010997,8.8592E-4,9.0167E-4,0.0010664,0.0011749,0.0010985,8.8615E-4,9.0292E-4,0.0010683,0.0011754,0.0010946,8.832E-4,9.0348E-4,0.0010688,0.0011789,0.0010929,8.818E-4,9.0488E-4,0.0010702,0.001178,0.0010907,8.8169E-4,9.0653E-4,0.0010698,0.0011721,0.0010894,8.7949E-4,9.083E-4,0.0010749,0.0011767,0.0010912,8.7839E-4,9.0829E-4,0.0010786,0.0011736,0.0010907,8.7889E-4,9.0981E-4,0.001081,0.0011712,0.0010852,8.7341E-4,9.0693E-4,0.0010802,0.0011802,0.001087,8.7632E-4,9.1071E-4,0.0010804,0.0011767,0.0010823,8.7543E-4,9.1118E-4,0.0010836,0.0011782,0.00108,8.7427E-4,9.1204E-4,0.0010836,0.0011757,0.0010797,8.7252E-4,9.1742E-4,0.0010868,0.001175,0.0010797,8.6918E-4,9.1618E-4,0.0010871,0.0011764,0.0010759,8.7072E-4,9.1445E-4,0.0010895,0.0011764,0.0010745,8.6745E-4,9.2147E-4,0.0010936,0.0011742,0.0010757,8.6787E-4,9.1973E-4,0.0010941,0.0011752,0.0010717,8.6513E-4,9.2061E-4,0.0010964,0.0011743,0.0010708,8.6511E-4,9.216E-4,0.0010976,0.0011744,0.0010693,8.634E-4,9.2043E-4,0.0010955,0.0011729,0.0010632,8.6098E-4,9.2569E-4,0.0010994,0.0011738,0.0010641,8.6165E-4,9.2606E-4,0.0011016,0.0011748,0.0010622,8.6098E-4,9.2504E-4,0.0011041,0.0011701,0.0010583,8.6097E-4,9.2625E-4,0.0011017,0.0011738,0.0010575,8.5751E-4,9.2921E-4,0.0011043,0.0011753,0.001055,8.6289E-4,9.3309E-4,0.0011078,0.0011715,0.0010503,8.5812E-4,9.3034E-4,0.0011107,0.0011749,0.0010504,8.6032E-4,9.3397E-4,0.0011121,0.0011733,0.0010518,8.5867E-4,9.3478E-4,0.0011126,0.00117,0.0010456,8.5623E-4,9.3641E-4,0.0011135,0.0011666,0.0010435,8.5606E-4,9.39E-4,0.0011161,0.0011705,0.0010397,8.5809E-4,9.3792E-4,0.0011161,0.0011712,0.0010434,8.5777E-4,9.4293E-4,0.0011189,0.0011691,0.0010411,8.5374E-4,9.4409E-4,0.0011222,0.0011708,0.0010381,8.5172E-4,9.4284E-4,0.0011221,0.0011701,0.0010358,8.5451E-4,9.4338E-4,0.0011231,0.0011697,0.0010345,8.5307E-4,9.4803E-4,0.0011215,0.0011716,0.0010305,8.5234E-4,9.4694E-4,0.0011232,0.0011706,0.001029,8.5286E-4,9.5143E-4,0.001129,0.0011684,0.0010283,8.5017E-4,9.5043E-4,0.0011255,0.0011663,0.0010254,8.5044E-4,9.5208E-4,0.0011272,0.0011658,0.0010234,8.5109E-4,9.5599E-4,0.0011301,0.0011636,0.0010213,8.5086E-4,9.5672E-4,0.0011307,0.0011674,0.0010228,8.4998E-4,9.5673E-4,0.0011335,0.0011615,0.0010154,8.4889E-4,9.5905E-4,0.0011358,0.0011629,0.001016,8.4935E-4,9.6275E-4,0.0011338,0.0011626,0.0010105,8.5093E-4,9.6371E-4,0.0011359,0.0011602,0.0010087,8.4832E-4,9.6593E-4,0.0011396,0.0011621,0.0010092,8.4907E-4,9.6378E-4,0.0011394,0.0011575,0.0010052,8.5029E-4,9.715E-4,0.0011427,0.0011588,0.0010027,8.4835E-4,9.7094E-4,0.0011424,0.0011574,0.0010034,8.4628E-4,9.7296E-4,0.0011416,0.0011582,0.0010027,8.5132E-4,9.7584E-4,0.0011476,0.0011614,0.001,8.4783E-4,9.7843E-4,0.0011426,0.0011587,5.5094E-4:6
2.2433E-6,2.3533E-6,3.3033E-6,4.2667E-6,-1.6667E-7,4.64E-6,5.2667E-7,0.0,-4.0667E-7,1.9933E-6,3.1133E-6,9.7667E-7,2.5467E-6,2.3667E-6,-4.5667E-7,2.45E-6,2.6367E-6,4.3E-7,4.01E-6,-5.5E-7,5.2233E-6,0.0022198,0.0027803,0.0012637,0.0014344,0.0012342,0.0013662,0.0012265,9.103E-4,9.6086E-4,0.0010815,0.0011878,0.0011224,8.8489E-4,9.1352E-4,0.001067,0.0011728,0.0011052,8.8506E-4,9.0575E-4,0.0010653,0.0011683,0.0011054,8.7956E-4,9.0431E-4,0.0010681,0.0011703,0.0011039,8.7669E-4,9.0439E-4,0.0010698,0.0011699,0.001099,8.7891E-4,9.0433E-4,0.0010735,0.0011681,0.0010975,8.8007E-4,9.0681E-4,0.0010712,0.0011704,0.0010982,8.7645E-4,9.0352E-4,0.0010724,0.0011687,0.001091,8.7515E-4,9.0564E-4,0.0010731,0.0011686,0.0010925,8.758E-4,9.0558E-4,0.0010755,0.0011655,0.0010912,8.7508E-4,9.0804E-4,0.0010755,0.0011664,0.0010913,8.7166E-4,9.0607E-4,0.0010777,0.0011663,0.0010871,8.7336E-4,9.0756E-4,0.0010772,0.0011681,0.001086,8.7064E-4,9.0912E-4,0.0010812,0.001167,0.0010888,8.6967E-4,9.1044E-4,0.0010796,0.0011696,0.0010861,8.6952E-4,9.1509E-4,0.0010806,0.0011685,0.0010835,8.6684E-4,9.1255E-4,0.0010858,0.00117,0.0010812,8.6614E-4,9.1474E-4,0.0010828,0.0011665,0.0010814,8.6878E-4,9.1447E-4,0.0010868,0.0011679,0.0010839,8.6368E-4,9.1444E-4,0.0010891,0.0011705,0.0010804,8.6628E-4,9.1571E-4,0.0010893,0.00117,0.0010755,8.6729E-4,9.1787E-4,0.0010929,0.0011698,0.0010757,8.6499E-4,9.1705E-4,0.001091,0.0011682,0.0010743,8.6374E-4,9.2046E-4,0.0010915,0.0011662,0.0010729,8.6194E-4,9.2002E-4,0.0010912,0.0011694,0.0010705,8.6372E-4,9.2213E-4,0.0010952,0.0011666,0.0010687,8.6077E-4,9.2102E-4,0.0010954,0.001169,0.0010669,8.6037E-4,9.2142E-4,0.0010984,0.001169,0.0010688,8.6095E-4,9.2607E-4,0.0010983,0.0011681,0.0010653,8.5874E-4,9.2455E-4,0.0011006,0.0011684,0.001065,8.6006E-4,9.2676E-4,0.0011008,0.0011659,0.001064,8.5809E-4,9.2832E-4,0.0011019,0.0011668,0.0010639,8.5475E-4,9.2866E-4,0.0011058,0.0011675,0.0010593,8.5851E-4,9.3421E-4,0.0011043,0.0011669,0.0010553,8.601E-4,9.2935E-4,0.0011057,0.0011671,0.0010576,8.5436E-4,9.2874E-4,0.0011066,0.0011674,0.0010582,8.5593E-4,9.334E-4,0.0011107,0.0011694,0.0010548,8.559E-4,9.3037E-4,0.0011119,0.0011645,0.0010539,8.5502E-4,9.3253E-4,0.0011114,0.0011665,0.0010516,8.5688E-4,9.367E-4,0.0011117,0.0011666,0.0010517,8.5378E-4,9.3492E-4,0.0011149,0.0011661,0.0010496,8.5515E-4,9.3731E-4,0.0011163,0.0011653,0.0010477,8.5444E-4,9.3895E-4,0.0011153,0.0011634,0.0010458,8.5471E-4,9.4035E-4,0.0011182,0.0011655,0.0010438,8.5257E-4,9.4228E-4,0.0011186,0.0011657,0.0010451,8.5064E-4,9.4288E-4,0.0011171,0.0011631,0.0010424,8.5114E-4,9.4542E-4,0.0011188,0.0011662,0.0010411,8.5187E-4,9.4385E-4,0.0011235,0.0011646,0.0010379,8.5169E-4,9.49E-4,0.0011229,0.0011629,0.0010365,8.5077E-4,9.4725E-4,0.0011269,0.0011601,0.0010332,8.4919E-4,9.4837E-4,0.0011245,0.0011635,0.0010362,8.5094E-4,9.4829E-4,0.0011259,0.0011593,0.0010311,8.4913E-4,9.501E-4,0.0011283,0.0011635,0.0010311,8.4882E-4,9.4893E-4,0.0011279,0.0011616,0.0010298,8.4884E-4,9.5626E-4,0.0011293,0.0011631,0.0010293,8.4712E-4,9.5523E-4,0.0011302,0.001162,0.0010278,8.4738E-4,9.5943E-4,0.0011314,0.0011612,0.0010243,8.4813E-4,9.5801E-4,0.0011307,0.0011612,0.0010254,8.4756E-4,9.5799E-4,0.001132,0.0011608,0.001022,8.484E-4,9.602E-4,0.001134,0.0011569,0.0010195,8.4672E-4,9.6343E-4,0.001134,0.0011599,0.0010179,8.455E-4,9.6197E-4,0.0011328,0.0011622,0.0010169,8.4714E-4,9.5974E-4,0.0011372,0.0011555,0.0010163,8.4755E-4,9.6326E-4,0.0011374,0.0011582,0.0010128,8.4578E-4,9.6485E-4:6
0.025477,-0.036257,0.027635,0.0088128,-0.025096,0.027828,-0.026614,0.021302,0.0036894,-0.020016,0.026721,-0.030063,0.024695,0.0063985,-0.022028,0.033995,-0.031722,0.022466,0.0072532,-0.022267,0.026817,-0.031111,0.020691,0.008459,-0.024344,0.030493,-0.031789,0.019445,-0.0054231,-0.021919,0.025285,-0.034088,0.015856,0.0045916,-0.020854,0.023205,-0.032608,0.017804,0.0068088,-0.026795,0.024632,-0.031113,7.8455,16.43,8.7358,7.3598,5.1763,6.8951,6.7063,5.6853,4.8897,4.6359,5.7376,6.1548,5.4344,4.5806,4.5908,5.5912,6.0748,5.4161,4.5486,4.6015,5.5843,6.0735,5.4107,4.5481,4.6019,5.5717,6.055,5.4053,4.5278,4.5962,5.5742,6.0671,5.4086,4.533,4.6065,5.5928,6.0642,5.4331,4.5376,4.613,5.5928,6.0732,5.4298,4.5372,4.6088,5.5942,6.0652,5.4286,4.5446,4.6164,5.5931,6.0608,5.4237,4.5256,4.6065,5.5894,6.0694,5.4211,4.5283,4.5991,5.5805,6.0706,5.4244,4.5345,4.6139,5.5883,6.0511,5.3953,4.5255,4.6085,5.5971,6.0637,5.4112,4.5218,4.6013,5.5866,6.0433,5.4134,4.5338,4.6016,5.5936,6.0655,5.4214,4.5276,4.6087,5.5812,6.0407,5.4062,4.5326,4.6151,5.6014,6.0443,5.4239,4.5249,4.6118,5.5979,6.0512,5.4026,4.5229,4.6066,5.5852,6.0512,5.4124,4.5196,4.5907,5.5836,6.0512,5.3934,4.5242,4.6092,5.6019,6.0639,5.4004,4.5219,4.5972,5.5903,6.0487,5.4149,4.5289,4.6156,5.6066,6.0436,5.3862,4.5114,4.6085,5.6009,6.0459,5.4075,4.5225,4.607,5.5826,6.0268,5.3966,4.517,4.616,5.5954,6.0413,5.3908,4.5139,4.614,5.5961,6.0567,5.4022,4.5238,4.614,5.5917,6.062,5.4035,4.5121,4.6057,5.6015,6.0702,5.4109,4.5312,4.6166,5.6006,6.0448,5.4098,4.5285,4.6163,5.6207,6.0478,5.3973,4.5184,4.6134,5.6104,6.0561,5.4146,4.5203,4.615,5.6112,6.0661,5.4056,4.5196,4.6185,5.6099,6.0623,5.4118,4.5138,4.6117,5.5952,6.0465,5.4096,4.5188,4.6135,5.5931,6.0539,5.3999,4.5199,4.6103,5.5977,6.0509,5.403,4.5245,4.6139,5.609,6.0593,5.3947,4.5227,4.6097,5.6071,6.0513,5.4044,4.519,4.6122,5.573,5.9876,5.3457,4.4906,4.6099,5.6062,6.0341,5.3746,4.4822,4.5906,5.5781,6.0268,5.3788,4.4975,4.5976,5.5689,6.0129,5.3685,4.4919,4.6001,5.5732,6.027,5.3632,4.4844,4.5878,5.5777,6.0423,5.3808,4.5024,4.6031,5.5855,6.0374,5.3838,4.5009,4.5986,5.5858,6.0251,5.3713,4.4969,4.603,5.5862,6.031,5.3785,4.4948,4.6056,5.5917,6.0232,5.3884,4.4995,4.6103,5.5919,6.0326,5.38,4.4968,4.604,5.584,6.0282,5.3785,4.5034,4.6055,5.5831,6.0327,5.3805,4.4982,4.6062,5.5873,6.0332,5.3746,4.5002,4.603,5.5856,6.0309,5.3681,4.4968,4.6054,5.5867,6.0348,5.375,4.5018,4.5995,5.593,6.0321,5.3708,4.4874,4.6015,5.5911,6.0283,5.3641,4.4957,4.5948,5.5889,6.0168,5.3727,4.4942,4.5967,5.579,6.0243,5.3667,4.488,4.6013,5.5882,6.0322,5.3709,4.4878,4.5957,5.5918,6.017,5.3592,4.4856,4.5992,5.5865,6.0301,5.3709,4.4982,4.61,5.6003,6.028,5.3717,4.4851,4.6023,5.5845,6.0193,5.3577,4.4936,4.6033,5.5955,6.0251,5.3652,4.4941,4.61,5.5887,6.025,5.3652,4.4906,4.6077,5.585,6.0225,5.3641,4.4971,4.6018,5.5823,6.0156,5.3627,4.4845,4.6029,5.584,6.0189,5.355,4.4845,4.6008,5.5822,6.0166,5.3537,4.484,4.6128,5.592,6.0129,5.3579,4.4922,4.6007,5.5882,6.0184,5.3517,4.4834,4.6061,5.5928,6.0174,5.3581,4.4889,4.2027:6
0.013735,0.013206,-0.030907,0.032702,-0.022706,0.014665,0.015098,-0.03772,0.033067,-0.021124,0.011596,0.013873,-0.036563,0.044442,-0.020466,0.0086868,0.013855,-0.034804,0.035559,-0.024471,0.010924,0.011288,-0.032454,0.03549,-0.021455,0.01425,0.010839,-0.037552,0.044356,-0.014032,0.011565,0.021389,-0.036619,0.034601,-0.016667,0.010241,0.018152,-0.041198,0.041493,-0.025783,0.0080314,0.017357,-0.039751,0.035504,-0.019369,0.012746,0.011937,-0.035065,0.03722,-0.022438,0.014651,0.012016,-0.038426,0.040808,-0.024269,0.0091133,0.013126,-0.029496,0.043149,-0.024616,0.00986,0.011558,-0.041027,0.036322,-0.027342,0.010498,0.0040392,-0.03796,0.035941,-0.023479,0.0089259,0.013409,-0.030707,0.040576,-0.031191,12.004,14.039,6.509,7.3654,6.1109,7.1653,6.4666,4.7831,4.9252,5.3651,6.1861,5.8663,4.6754,4.6244,5.3242,6.0763,5.8212,4.6798,4.5757,5.308,6.0492,5.7908,4.6722,4.5593,5.2987,6.0541,5.7984,4.6837,4.558,5.3091,6.0525,5.8154,4.685,4.5678,5.3015,6.0495,5.8142,4.6874,4.5592,5.2923,6.0548,5.8143,4.6897,4.5591,5.2875,6.054,5.8189,4.7053,4.5574,5.2866,6.0523,5.8058,4.6948,4.5504,5.2726,6.0471,5.8174,4.7195,4.5634,5.2746,6.0625,5.8296,4.7092,4.5527,5.2705,6.0382,5.8187,4.7237,4.546,5.2676,6.0391,5.823,4.7095,4.542,5.2518,6.0408,5.8322,4.7093,4.5411,5.2392,6.0305,5.8298,4.7195,4.5425,5.2358,6.0381,5.8267,4.7278,4.5354,5.227,5.9826,5.7701,4.698,4.5155,5.2203,6.0297,5.8205,4.7097,4.5035,5.189,6.003,5.8174,4.7246,4.5105,5.1941,6.0008,5.8163,4.7229,4.5062,5.1888,5.9992,5.8263,4.7288,4.503,5.1796,5.9893,5.826,4.7341,4.5103,5.1818,6.0061,5.8345,4.7365,4.5128,5.1784,6.012,5.8316,4.7405,4.5058,5.1773,6.0034,5.836,4.7514,4.4993,5.1639,6.0005,5.8367,4.74,4.4964,5.1727,5.9565,5.776,4.7291,4.4803,5.1577,5.9864,5.826,4.7388,4.4664,5.1456,5.9627,5.8338,4.7592,4.4777,5.1421,5.9584,5.8326,4.7589,4.474,5.1312,5.9578,5.8365,4.7478,4.4796,5.1003,5.9401,5.8265,4.7429,4.4517,5.0854,5.9343,5.811,4.7446,4.4479,5.081,5.9343,5.8179,4.7518,4.4541,5.0832,5.9391,5.8098,4.7611,4.4419,5.0771,5.9265,5.8339,4.7785,4.4471,5.0838,5.9402,5.8463,4.7897,4.4499,5.0954,5.9331,5.8471,4.7903,4.4523,5.0882,5.9462,5.8485,4.7908,4.4517,5.0767,5.9312,5.8603,4.7958,4.4543,5.0647,5.9344,5.855,4.8026,4.449,5.0662,5.9334,5.8561,4.8043,4.4469,5.0594,5.9321,5.8611,4.8111,4.4443,5.0489,5.9315,5.8638,4.8144,4.4497,5.0541,5.9234,5.8696,4.8225,4.4466,5.0455,5.922,5.8699,4.831,4.4473,5.0407,5.9231,5.8782,4.8389,4.4498,5.0367,5.9244,5.8881,4.832,4.4441,5.028,5.9204,5.8907,4.8501,4.4396,5.0332,5.9234,5.8839,4.8474,4.4424,5.0209,5.9183,5.8856,4.8522,4.4429,5.0159,5.908,5.8976,4.851,4.433,5.0094,5.9004,5.8952,4.8645,4.4398,5.0029,5.8956,5.9025,4.8648,4.4361,4.9994,5.8983,5.8975,4.8691,4.4368,4.9864,5.8957,5.9029,4.8757,4.4341,4.9881,5.8968,5.8989,4.8836,4.434,4.9865,5.9051,5.9104,4.8915,4.4406,4.9834,5.9088,5.91,4.9011,4.4356,4.9827,5.8916,5.9189,4.909,4.4331,4.9834,5.8968,5.9177,4.9078,4.4354,4.98,5.8935,5.9208,4.9224,4.4398,4.9686,5.8923,5.9373,4.9279,4.4395,4.9638,5.8953,5.9396,4.9267,4.4385,4.9542,5.8819,5.9428,4.9391,4.4445,4.9494,5.8799,5.9352,4.9446,4.4374,4.9415,5.8785,5.9417,4.96,4.4315,4.9431,5.88,5.9381,4.9517,4.4369,4.9354,5.875,5.94,4.9609,4.4421,4.9333,5.8727,5.938,4.969,4.4259,4.9281,5.8634,5.9515,4.9784,4.441,4.9228,5.8629,5.9457,4.976,4.4324,4.9216,5.8543,2.857:6
0.023744,2.7766E-4,-0.016759,0.027736,-0.024082,0.022894,0.0046374,-0.015695,0.02247,-0.029611,0.019471,-0.003363,-0.01717,0.025341,-0.025169,0.022297,0.001942,-0.021472,0.029947,-0.02688,0.030274,-0.0020575,-0.020213,0.028599,-0.031105,0.025057,0.0018302,-0.01522,0.031957,-0.031781,0.027155,-0.005428,-0.025328,13.07,11.99,8.6612,8.3487,6.8301,4.9649,5.1672,5.8294,6.2375,5.5851,4.5573,4.6395,5.5706,6.0138,5.4681,4.5227,4.5919,5.5447,6.0078,5.4629,4.5207,4.5676,5.5233,5.9826,5.4461,4.5112,4.5726,5.5357,5.9961,5.446,4.5097,4.5747,5.5221,5.9787,5.4336,4.4965,4.5648,5.5184,5.9935,5.442,4.5022,4.5612,5.5116,5.9884,5.4367,4.5002,4.5635,5.5143,5.9902,5.4281,4.4968,4.558,5.5166,5.9877,5.4269,4.5022,4.5506,5.5098,5.9881,5.425,4.4982,4.553,5.5139,5.974,5.4352,4.499,4.5621,5.5127,5.9752,5.4353,4.4908,4.5634,5.5178,5.9848,5.4293,4.4985,4.5546,5.5159,5.9863,5.4302,4.4983,4.5516,5.5113,5.9837,5.4326,4.498,4.5555,5.5197,5.9852,5.4324,4.5045,4.5595,5.5175,5.9861,5.4413,4.5051,4.5643,5.5197,5.9852,5.4295,4.4971,4.5694,5.52,5.9904,5.4359,4.4925,4.5619,5.5142,5.9772,5.4295,4.4905,4.56,5.5104,5.986,5.4221,4.4952,4.5623,5.5131,5.9931,5.4296,4.5016,4.5609,5.5229,5.9971,5.4257,4.5015,4.5633,5.5282,5.9963,5.4247,4.4992,4.5644,5.5219,5.9853,5.4278,4.4991,4.5624,5.5212,5.981,5.4254,4.5006,4.5598,5.5234,5.9895,5.4251,4.4911,4.5569,5.5155,5.9757,5.4222,4.4946,4.5593,5.5202,5.9969,5.4272,4.4934,4.5597,5.5146,5.983,5.4162,4.4899,4.5546,5.5155,5.9905,5.4144,4.4912,4.5562,5.5166,5.9912,5.4141,4.4956,4.5543,5.5082,5.9757,5.4163,4.4892,4.5596,5.5305,5.9885,5.4206,4.4857,4.5629,5.5211,5.9826,5.4266,4.4878,4.5575,5.5313,5.9882,5.4195,4.4894,4.5668,5.5243,5.9866,5.4243,4.4921,4.5705,5.5241,5.9933,5.4237,4.4931,4.564,5.5192,5.998,5.4193,4.4956,4.5679,5.523,5.9878,5.4118,4.4913,4.5626,5.5147,5.9884,5.419,4.4913,4.5595,5.5097,5.9891,5.4213,4.4878,4.562,5.5285,5.9898,5.4144,4.4849,4.5592,5.5147,5.9795,5.4133,4.486,4.5622,5.5111,5.9802,5.4115,4.491,4.5637,5.519,5.9883,5.4085,4.4843,4.5597,5.5182,5.9964,5.4081,4.4962,4.5578,5.5229,5.989,5.4083,4.4918,4.5543,5.522,5.9818,5.4063,4.4893,4.5519,5.5252,5.9829,5.4097,4.493,4.5571,5.5324,5.9935,5.4144,4.4849,4.5605,5.5312,5.9967,5.4235,4.4886,4.5655,5.5229,5.9854,5.4109,4.4873,4.5664,5.5218,5.9856,5.4082,4.5084,4.6034,5.56,6.026,5.4221,4.5034,4.5805,5.5523,6.0281,5.4346,4.5094,4.5763,5.5417,6.0054,5.4315,4.5147,4.5756,5.5568,6.0042,5.4232,4.5077,4.5769,5.5615,6.0126,5.433,4.5102,4.579,5.559,6.0036,5.4433,4.508,4.5952,5.5586,6.0111,5.4311,4.5018,4.5884,5.5511,6.0156,5.429,4.5073,4.588,5.5508,6.0152,5.4299,4.4991,4.5912,5.5491,6.0211,5.4222,4.5047,4.5903,5.5464,6.0215,5.4269,4.5129,4.5842,5.5506,6.0195,5.4135,4.5003,4.5822,5.5501,6.015,5.4247,4.5,4.5812,5.5576,6.0098,5.4194,4.5025,4.5908,5.5671,6.0157,5.4257,4.5039,4.5906,5.5653,6.0159,5.4286,4.5059,4.594,5.5655,6.022,5.4276,4.5022,4.599,5.5568,6.0105,5.419,4.5001,4.5851,5.5678,6.0151,5.4168,4.4984,4.5903,5.5649,6.0256,5.4205,0.3955:6
-0.0024556,1.8846E-4,0.0019859,-0.002018,0.0038002,-0.0029182,0.0011542,-2.1632E-4,-0.0029662,0.0011771,-0.0037221,9.1765E-4,1.2756E-4,-0.0026742,0.0036919,-0.0026975,0.0029508,0.0010936,-0.0018102,0.0019126,-0.0020958,0.0023249,-2.9622E-4,-0.0013967,0.0014516,-0.003627,8.4501E-4,-0.0013894,-0.0026118,0.0019909,-0.0021763,8.9048E-4,0.0021359,-0.0017907,0.0015031,-0.0032535,0.0015522,4.2498,5.7005,2.6459,2.8182,2.5011,2.736,2.4243,1.8245,1.8944,2.1288,2.3696,2.2011,1.7651,1.7868,2.0896,2.3211,2.1744,1.7556,1.7687,2.0835,2.3126,2.1714,1.7606,1.765,2.0795,2.3126,2.1735,1.7607,1.7638,2.0795,2.3101,2.1743,1.7622,1.7619,2.0747,2.3109,2.1788,1.7628,1.7584,2.0756,2.3114,2.181,1.7645,1.7584,2.0715,2.3111,2.1837,1.7674,1.7572,2.0715,2.3107,2.1849,1.7687,1.7582,2.0673,2.3113,2.1882,1.7695,1.7555,2.0685,2.312,2.1889,1.7719,1.7563,2.0665,2.3114,2.1926,1.7737,1.7537,2.063,2.3102,2.1936,1.775,1.7546,2.062,2.3096,2.1953,1.7771,1.7542,2.0594,2.3115,2.1988,1.7806,1.7524,2.0586,2.3109,2.201,1.78,1.7517,2.0562,2.3105,2.2032,1.7838,1.7486,2.0539,2.3086,2.205,1.7835,1.7474,2.0518,2.3059,2.2055,1.7859,1.7452,2.0492,2.3049,2.2104,1.7866,1.7444,2.0447,2.3076,2.2104,1.7892,1.7467,2.0436,2.3066,2.2131,1.7856,1.7437,2.0402,2.3046,2.2142,1.7915,1.7416,2.0375,2.302,2.216,1.791,1.741,2.0375,2.3026,2.2162,1.7947,1.7401,2.0354,2.3037,2.2214,1.7961,1.7399,2.0327,2.3043,2.2206,1.8,1.7395,2.0321,2.3042,2.2244,1.7984,1.7381,2.0301,2.2988,2.2259,1.8028,1.7372,2.0271,2.2999,2.2278,1.8031,1.7357,2.0252,2.2983,2.229,1.8052,1.7348,2.023,2.2977,2.2333,1.8063,1.7335,2.0198,2.2992,2.2326,1.8089,1.7345,2.017,2.2953,2.2348,1.8074,1.7304,2.0114,2.2942,2.2363,1.8121,1.7323,2.0112,2.294,2.2377,1.8135,1.73,2.0106,2.2949,2.2395,1.8149,1.7297,2.0071,2.2932,2.2388,1.8151,1.7276,2.0047,2.2924,2.243,1.8171,1.7271,2.0052,2.2902,2.2431,1.819,1.7252,2.0004,2.2871,2.2449,1.8234,1.7255,1.9977,2.2893,2.249,1.8227,1.7237,1.9982,2.2875,2.2511,1.8244,1.726,1.9947,2.287,2.2514,1.8277,1.724,1.993,2.2857,2.2516,1.8281,1.7227,1.9881,2.2873,2.2544,1.8287,1.7224,1.99,2.2861,2.2564,1.8338,1.7249,1.9855,2.2855,2.2589,1.8357,1.7214,1.986,2.2863,2.2579,1.8378,1.7223,1.9831,2.2853,2.26,1.8406,1.7207,1.9819,2.2801,2.2629,1.8405,1.7215,1.9792,2.2804,2.2643,1.8418,1.72,1.9782,2.278,2.2657,1.8445,1.72,1.9753,2.2787,2.2681,1.846,1.7194,1.9735,2.2782,2.2701,1.8466,1.7214,1.9712,2.2786,2.2699,1.8492,1.7175,1.9678,2.2781,2.27,1.8514,1.7174,1.964,2.2785,2.273,1.8542,1.7176,1.9634,2.2755,2.2715,1.8566,1.7172,1.9604,2.2762,2.2732,1.8591,1.7154,1.9603,2.2725,2.2742,1.8615,1.715,1.9558,2.2706,2.2776,1.8628,1.7139,1.9557,2.2687,2.2764,1.866,1.7139,1.9508,2.2687,2.2783,1.8646,1.7147,1.9496,2.2688,2.2817,1.8683,1.7147,1.9463,2.2667,2.2828,1.8701,1.7128,1.9457,2.2641,2.2836,1.8732,1.7151,1.9426,2.2661,2.2853,1.8755,1.7138,1.9428,2.2646,2.2861,1.8779,1.7153,1.9375,2.2648,2.2889,1.8801,1.7111,1.9386,2.264,2.2887,1.8817,1.7128,1.9374,2.2613,2.2916,1.8843,1.7142,1.9362,2.262,2.2919,1.8873,1.7137,1.9308,2.2609,2.2938,1.8875,1.7131,1.9327,2.2583,2.2898,1.8898,1.7132,1.9283,2.2555,2.2979,1.8926,1.7136,1.9276,2.2582,2.2972,1.8936,1.7128,1.9248,2.2573,2.2978,1.8988,1.7165,1.6493:6
-0.0017724,0.0015708,-0.002662,0.0016422,1.6369E-4,-0.0010844,0.0012534,-0.0019492,0.0015852,-0.0027837,-6.7889E-4,7.3592E-4,-0.0036317,0.00255,4.0702E-4,-9.0644E-4,0.0016486,-0.0034169,-1.0792E-4,-3.2625E-4,8.6898E-4,0.0023038,-0.0024708,0.0026368,8.2563E-5,-0.0013136,3.882E-4,-0.0039091,6.0389E-4,-3.9678E-4,-2.9344E-4,0.0017806,-0.0030648,0.0031508,2.2408E-4,1.5923E-4,0.0029001,5.5481,4.2154,3.1275,2.7717,2.1855,1.6835,2.0002,2.1806,2.1752,1.7964,1.5835,1.8059,2.091,2.1133,1.7468,1.5739,1.7804,2.0826,2.1053,1.7426,1.574,1.7751,2.0817,2.1029,1.7416,1.576,1.7757,2.0797,2.1025,1.7437,1.5762,1.7766,2.0821,2.1045,1.7443,1.5755,1.7777,2.084,2.1048,1.7459,1.576,1.7754,2.0809,2.1061,1.7457,1.5766,1.7764,2.0809,2.1079,1.7485,1.5768,1.7745,2.0802,2.1095,1.7471,1.5769,1.7753,2.0822,2.1096,1.7492,1.5781,1.7738,2.0807,2.1113,1.749,1.5775,1.7708,2.0814,2.1113,1.7502,1.5786,1.7703,2.0801,2.1132,1.7484,1.5761,1.7698,2.0795,2.1115,1.7515,1.5791,1.7702,2.08,2.1136,1.7531,1.5764,1.77,2.081,2.1109,1.7567,1.5772,1.7689,2.0809,2.113,1.754,1.5761,1.7687,2.078,2.1111,1.7565,1.5765,1.7649,2.0768,2.1147,1.7553,1.5767,1.7668,2.0763,2.1142,1.7597,1.5785,1.7647,2.0763,2.1181,1.7577,1.5769,1.7637,2.0757,2.1148,1.7585,1.5784,1.7625,2.0751,2.1168,1.759,1.5786,1.7634,2.0757,2.1165,1.7628,1.579,1.7628,2.0767,2.1168,1.7625,1.5802,1.7642,2.0757,2.1188,1.7645,1.58,1.7622,2.0783,2.119,1.7666,1.5793,1.7621,2.0752,2.1201,1.7679,1.5792,1.7616,2.0755,2.1203,1.7666,1.5787,1.7605,2.0744,2.1207,1.7696,1.579,1.7581,2.074,2.1213,1.7687,1.5803,1.7577,2.0741,2.1251,1.7705,1.579,1.7553,2.0726,2.1244,1.7694,1.5794,1.757,2.0717,2.1212,1.7705,1.5795,1.7527,2.071,2.123,1.7706,1.5799,1.7545,2.0729,2.1229,1.7732,1.5784,1.7508,2.0725,2.123,1.7744,1.5778,1.7505,2.0691,2.1239,1.7759,1.5779,1.7509,2.0706,2.1225,1.7758,1.5803,1.7527,2.0691,2.1242,1.7805,1.5798,1.7481,2.0669,2.1257,1.7795,1.5796,1.7512,2.0664,2.1262,1.7797,1.5793,1.746,2.0665,2.1283,1.7808,1.5795,1.7477,2.0658,2.1265,1.7843,1.5809,1.7446,2.0662,2.1265,1.7865,1.5807,1.7432,2.0644,2.1283,1.7845,1.5807,1.7405,2.0666,2.1266,1.7867,1.5802,1.7411,2.0638,2.1258,1.7885,1.5816,1.7394,2.0636,2.1273,1.7883,1.5784,1.7393,2.0624,2.1267,1.7905,1.5804,1.7378,2.0611,2.1283,1.7927,1.5803,1.7387,2.0597,2.1291,1.7956,1.5797,1.736,2.0598,2.1291,1.7939,1.5796,1.7385,2.0576,2.1301,1.7961,1.5814,1.7347,2.0614,2.1316,1.7944,1.5818,1.7338,2.0588,2.1304,1.7997,1.5816,1.7313,2.0599,2.1326,1.7977,1.58,1.7319,2.0606,2.1328,1.8009,1.5829,1.7292,2.0596,2.1311,1.8007,1.5815,1.7312,2.0562,2.1314,1.8036,1.5824,1.7291,2.0586,2.1287,1.8031,1.5815,1.7299,2.0573,2.134,1.805,1.5822,1.7268,2.0552,2.1332,1.8048,1.5819,1.7265,2.0535,2.1331,1.8071,1.5816,1.7247,2.0504,2.1346,1.806,1.583,1.7247,2.0515,2.134,1.8077,1.581,1.7234,2.0511,2.1338,1.8089,1.5828,1.7241,2.0511,2.1345,1.8098,1.5813,1.7205,2.0497,2.1341,1.8109,1.5838,1.7219,2.0515,2.1344,1.8105,1.5825,1.7193,2.0513,2.1352,1.8109,1.5823,1.7196,2.0509,2.1336,1.8141,1.5836,1.7193,2.0484,2.1365,1.8137,1.5828,1.7174,2.0464,2.1352,1.8172,1.5826,1.7173,2.048,2.136,1.817,1.5831,1.717,2.047,2.1355,1.8167,1.5821,1.7143,2.0458,2.1364,1.8153,1.5828,1.7137,2.0448,2.1353,1.8198,1.584,1.7116,2.0447,2.1365,1.8187,1.5814,1.7122,2.0442,2.1372,0.96264:6
-0.017363,0.018293,-0.01375,0.010777,0.0080939,-0.013828,0.017529,-0.013852,0.0090352,0.0041251,-0.018283,0.021562,-0.015991,0.0057907,0.012159,-0.018878,0.019555,-0.01507,0.0033056,0.0066692,-0.019702,0.019572,-0.018188,0.012416,0.0051526,-0.018788,0.018799,-0.017756,0.002645,0.012373,-0.015839,0.020598,-0.014767,0.0073523,0.010776,-0.013932,0.027002,-0.013403,0.011302,0.0045497,-0.015519,0.021927,-0.011409,0.0063214,0.0053765,-0.014178,0.017452,-0.014189,0.0078986,0.010334,-0.010916,0.022816,-0.012585,0.0021169,0.012151,-0.019228,0.018588,-0.008402,0.0087616,0.0039097,-0.011077,0.017869,-0.010948,0.012009,0.0017462,-0.017077,0.014137,3.619,11.014,6.5366,5.0816,3.1839,4.2651,4.2492,3.9946,3.3442,2.9213,3.4732,3.9356,3.7913,3.1614,2.9121,3.3777,3.9039,3.7852,3.1465,2.9104,3.3677,3.8996,3.7892,3.1484,2.9087,3.3659,3.893,3.7875,3.1533,2.9129,3.349,3.8926,3.7978,3.1598,2.9072,3.3518,3.8901,3.7985,3.1674,2.9051,3.3397,3.8831,3.8006,3.1659,2.9017,3.3409,3.8844,3.811,3.1684,2.9041,3.3364,3.8779,3.8101,3.1704,2.9043,3.3308,3.8866,3.8169,3.1772,2.902,3.3237,3.881,3.8185,3.1776,2.8988,3.3239,3.8683,3.8203,3.185,2.9052,3.3163,3.8674,3.8295,3.1945,2.9021,3.3102,3.8664,3.8284,3.1982,2.902,3.3049,3.8641,3.8336,3.1985,2.9062,3.294,3.8635,3.8377,3.2056,2.8994,3.297,3.8603,3.8368,3.2101,2.8979,3.2985,3.8592,3.8505,3.218,2.8954,3.2861,3.8465,3.848,3.2239,2.8967,3.2858,3.8494,3.8557,3.2299,2.8999,3.2832,3.8417,3.8573,3.233,2.9003,3.2766,3.8458,3.8577,3.244,2.8956,3.2668,3.8412,3.8595,3.2432,2.8977,3.2687,3.8463,3.864,3.2434,2.9028,3.2613,3.8435,3.8618,3.2549,2.8958,3.2542,3.8403,3.8648,3.2659,2.896,3.2544,3.8255,3.8738,3.2637,2.8935,3.2544,3.8273,3.8755,3.2672,2.8988,3.2514,3.8222,3.8832,3.27,2.8953,3.2389,3.8248,3.8867,3.2815,2.8995,3.2417,3.825,3.8862,3.2843,2.8952,3.2326,3.8236,3.8844,3.2917,2.8997,3.2311,3.8213,3.8951,3.3004,2.9011,3.2204,3.8112,3.8932,3.3049,2.8964,3.215,3.8135,3.8929,3.3141,2.9004,3.2111,3.8062,3.8987,3.3115,2.8979,3.2033,3.7979,3.903,3.3183,2.8967,3.2003,3.7962,3.9001,3.3234,2.9045,3.1961,3.7946,3.9087,3.3337,2.8954,3.1897,3.796,3.9027,3.3381,2.8972,3.189,3.7848,3.9076,3.3453,2.9,3.1816,3.7926,3.9088,3.3395,2.9039,3.1839,3.7784,3.912,3.352,2.9072,3.1717,3.7771,3.9116,3.3589,2.9042,3.1652,3.7739,3.912,3.3604,2.9042,3.1621,3.7732,3.9124,3.3619,2.9013,3.1648,3.7678,3.9242,3.3649,2.9062,3.1572,3.7676,3.916,3.3728,2.9061,3.1481,3.7648,3.9148,3.3881,2.9089,3.1454,3.7567,3.9192,3.3866,2.9059,3.1417,3.7611,3.9238,3.3993,2.9115,3.1393,3.7488,3.9239,3.4064,2.9124,3.1311,3.7504,3.9219,3.4082,2.9141,3.1338,3.749,3.929,3.4116,2.9155,3.13,3.7414,3.9295,3.4211,2.9164,3.1266,3.7316,3.9284,3.4238,2.9178,3.1227,3.7305,3.9318,3.4288,2.919,3.1146,3.7385,3.9341,3.4311,2.921,3.1023,3.7291,3.9303,3.4488,2.9204,3.1068,3.7269,3.9309,3.4597,2.9211,3.103,3.7177,3.9347,3.463,2.9234,3.099,3.7095,3.9424,3.4619,2.9256,3.095,3.7085,3.9349,3.4617,2.9255,3.086,3.7065,3.9353,3.4809,2.9284,3.0866,3.7024,3.937,3.4773,2.9333,3.0805,3.7003,3.941,3.4851,2.9304,3.0751,3.693,3.9354,3.4892,2.9342,3.0713,3.6933,3.9319,3.4983,2.9345,3.0711,3.6847,3.9271,3.5003,2.9351,3.0708,3.6838,3.9409,3.5007,2.9395,3.0645,3.675,3.941,3.5133,2.9444,3.0577,3.6829,3.9487,3.5138,2.9502,3.0507,3.6726,3.9358,3.5207,2.9487,3.0526,3.6692,3.934,3.5312,2.9485,3.0522,3.6725,3.9365,3.5309,2.9535,3.053,3.6625,3.9374,3.5371,2.1727:6
3.1481,3.7013,3.8859,3.453,2.8614,3.1482,3.6966,3.8818,3.4547,2.8604,3.1433,3.6997,3.8872,3.4562,2.865,3.1385,3.7015,3.8922,3.4618,2.8658,3.1457,3.6958,3.8989,3.4525,2.8701,3.1401,3.6978,3.9001,3.4541,2.8652,3.1347,3.6919,3.9016,3.4581,2.8771,3.1347,3.6963,3.9066,3.4663,2.8693,3.1393,3.6897,3.9013,3.467,2.8764,3.1442,3.6935,3.9078,3.4662,2.874,3.1361,3.6834,3.9047,3.4702,2.8722,3.1386,3.6805,3.9154,3.465,2.8797,3.1379,3.6896,3.9174,3.4731,2.8812,3.1338,3.6888,3.9148,3.4737,2.8797,3.1359,3.6876,3.9164,3.4713,2.8755,3.1297,3.6952,3.9164,3.4769,2.8763,3.1363,3.6931,3.919,3.479,2.8774,3.1303,3.6904,3.9091,3.4775,2.8797,3.127,3.6812,3.9145,3.4794,2.8797,3.132,3.6855,3.9273,3.4825,2.8841,3.1322,3.6827,3.9275,3.4766,2.8881,3.1275,3.6811,3.9237,3.4759,2.8879,3.1313,3.6907,3.9209,3.4808,2.8838,3.1271,3.6897,3.9247,3.485,2.8915,3.1309,3.6856,3.9258,3.486,2.8907,3.1289,3.6838,3.9277,3.488,2.8948,3.1255,3.6811,3.9229,3.493,2.8925,3.1264,3.6878,3.926,3.494,2.8872,3.1236,3.6856,3.9253,3.4968,2.8884,3.1255,3.688,3.9317,3.4929,2.8898,3.125,3.6762,3.9344,3.4905,2.8936,3.1298,3.6772,3.9377,3.4942,2.8855,3.1231,3.6848,3.9297,3.4942,2.895,3.1239,3.6803,3.9331,3.4961,2.8964,3.1244,3.6825,3.9305,3.4952,2.895,3.1209,3.679,3.9336,3.5005,2.8962,3.1213,3.6849,3.9395,3.5054,2.8962,3.1192,3.6886,3.941,3.5058,2.8907,3.118,3.6799,3.9336,3.5087,2.8963,3.1192,3.6745,3.9323,3.499,2.8939,3.1259,3.6759,3.9397,3.5062,2.9007,3.121,3.6833,3.9326,3.5068,2.8976,3.1148,3.6843,3.9355,3.5036,2.8947,3.113,3.6788,3.933,3.5134,2.8969,3.1205,3.6761,3.9354,3.5117,2.8983,3.1202,3.6754,3.9416,3.5071,2.8963,3.1163,3.674,3.9375,3.5092,2.8975,3.1189,3.6749,3.9386,3.5082,2.9005,3.1173,3.6766,3.9456,3.509,2.9001,3.1205,3.6691,3.9428,3.5065,2.8952,3.1116,3.6782,3.9393,3.5136,2.9019,3.1121,3.68,3.9386,3.5114,2.9039,3.1147,3.6807,3.9419,3.5035,2.9033,3.1084,3.6751,3.9437,3.5169,2.9022,3.1109,3.6771,3.9357,3.5126,2.9066,3.1113,3.6741,3.9386,3.5147,2.9021,3.1101,3.6757,3.9402,3.5159,2.9015,3.112,3.6766,3.9408,3.5152,2.9,3.1158,3.6736,3.944,3.5163,2.9018,3.1152,3.672,3.9489,3.5183,2.9047,3.1109,3.6748,3.9454,3.5222,2.9023,3.1122,3.6695,3.9426,3.518,2.9111,3.11,3.6739,3.9452,3.5209,2.9068,3.1068,3.673,3.9474,3.5211,2.9083,3.1067,3.6757,3.9454,3.5219,2.9099,3.112,3.6791,3.9434,3.528,2.9052,3.1018,3.6723,3.9353,3.5255,2.9036,3.1095,3.6658,3.9488,3.5208,2.9035:6
0.0062009,0.0099347,-0.017877,0.021267,-0.011932,0.0070789,0.012165,-0.013739,0.023021,-0.011122,1.3867E-4,0.0090386,-0.022199,0.018171,-0.014978,-0.0028627,0.012016,-0.016655,0.019637,-0.0081152,0.0032996,0.012811,-0.016258,0.019052,-0.013704,0.0042432,0.0095433,-0.019429,0.017819,-0.020444,1.4007E-4,0.0079657,-0.01212,0.018239,-0.015649,0.0060818,0.015621,-0.019989,0.01959,-0.0054626,0.0069613,0.011826,-0.01524,0.018762,-0.014467,-0.0015229,0.0029453,-0.019019,0.017764,-0.010649,-0.001472,0.016518,-0.016816,0.023734,-0.0087811,0.0049522,0.0074913,-0.019937,0.020326,-0.010627,4.5044E-4,0.015251,-0.01495,0.017684,-0.015151,0.0010894,0.0072435,10.169,7.7546,4.9746,5.4501,4.5169,3.109,3.437,3.6813,4.0435,3.7248,2.9527,3.0632,3.5747,3.9116,3.6466,2.9395,3.0265,3.5662,3.8967,3.6273,2.9418,3.0235,3.567,3.8987,3.6291,2.9383,3.0236,3.5603,3.9048,3.6267,2.9379,3.0238,3.5636,3.9171,3.6253,2.9447,3.023,3.5631,3.9063,3.6207,2.9455,3.0209,3.5722,3.9125,3.6207,2.9438,3.017,3.568,3.9105,3.6288,2.9487,3.019,3.5699,3.9136,3.6233,2.9427,3.0176,3.5671,3.9183,3.6292,2.9459,3.0273,3.573,3.9202,3.626,2.9457,3.0229,3.5686,3.921,3.6292,2.9509,3.0217,3.5671,3.9253,3.6271,2.9459,3.0307,3.5669,3.9188,3.6257,2.9471,3.0263,3.5718,3.9248,3.6168,2.9449,3.0206,3.5643,3.9258,3.6194,2.9504,3.0176,3.5667,3.9237,3.6235,2.9495,3.0254,3.5711,3.9304,3.6144,2.9495,3.0217,3.5705,3.9297,3.6244,2.9505,3.0285,3.5767,3.9237,3.6216,2.9473,3.0221,3.5793,3.9246,3.6226,2.9499,3.0238,3.5722,3.9271,3.6183,2.9432,3.0261,3.5744,3.9282,3.6273,2.944,3.0265,3.5677,3.9296,3.6212,2.9473,3.0313,3.57,3.9347,3.6199,2.942,3.0284,3.5686,3.9353,3.6145,2.9487,3.0202,3.5736,3.9343,3.6196,2.9514,3.0201,3.5761,3.9354,3.6178,2.9552,3.0327,3.583,3.9332,3.6246,2.9536,3.0219,3.5732,3.9312,3.622,2.9574,3.0242,3.5726,3.9319,3.6223,2.9502,3.0224,3.5729,3.9328,3.6272,2.9549,3.0286,3.5824,3.9407,3.633,2.9532,3.0299,3.5786,3.9395,3.6321,2.9497,3.027,3.578,3.94,3.6293,2.9604,3.0254,3.5761,3.94,3.6331,2.9546,3.0233,3.5815,3.9378,3.6357,2.958,3.0305,3.5786,3.9363,3.6281,2.957,3.0309,3.5729,3.9451,3.6325,2.9541,3.0288,3.5773,3.9425,3.6296,2.9597,3.0263,3.5838,3.9394,3.626,2.9569,3.0233,3.5807,3.9302,3.6316,2.9524,3.0267,3.5755,3.9376,3.6309,2.9593,3.0281,3.5746,3.9412,3.6295,2.9528,3.0289,3.5727,3.9425,3.6267,2.9551,3.0299,3.579,3.9429,3.6254,2.956,3.0302,3.5768,3.9379,3.6329,2.9483,3.0237,3.5768,3.9379,3.6215,2.9538,3.0258,3.5815,3.934,3.6211,2.9513,3.0265,3.579,3.9375,3.628,2.9531,3.0258,3.5792,3.9331,3.6184,2.9559,3.0284,3.5832,3.9452,3.62,2.9523,3.0293,3.5771,3.946,3.6211,2.9525,3.0278,3.5813,3.9408,3.6242,2.9556,3.0278,3.5852,3.9396,3.6221,2.9593,3.0248,3.5838,3.9358,3.6197,2.9497,3.0237,3.5818,3.9364,3.6218,2.9526,3.0283,3.5753,3.9416,3.6193,2.9531,3.027,3.5739,3.9457,3.6268,2.9574,3.0247,3.5811,3.9417,3.6127,2.9509,3.0285,3.5803,3.9445,3.6278,2.9485,3.0306,3.5823,3.9362,3.6212,2.9507,3.0337,3.5819,3.9464,3.6233,2.9544,3.0329,3.5741,3.9439,3.6235,2.9507,3.037,3.5834,3.9449,3.6269,2.9526,3.0329,3.5864,3.9419,3.6212,2.9547,3.0365,3.5839,3.9432,3.62,2.9553,3.033,3.5768,3.9458,3.6138,2.9543,3.0308,3.5836,3.9532,3.6248,2.9584,3.0346,3.5944,3.9446,3.6263,2.9521,3.0282,3.5861,3.9411,3.6157,2.9484,3.0336,3.578,3.9437,3.6198,2.9526,3.0345,3.5865,3.9411,3.6108,2.9484,3.0333,3.582,3.9487,3.6179,2.9522,3.0327,3.5891:6
0.0018443,-0.0024029,0.0024315,-0.0016503,5.9616E-4,0.0025166,-0.003961,0.0010117,-0.0010343,-0.0017568,0.0047247,-0.0048848,0.0015692,-0.0021932,-0.0022765,0.0023417,-0.0014716,0.002209,7.7783E-4,-6.0944E-4,0.002953,-0.0032212,0.0036531,-8.1373E-4,-0.0011434,0.0038465,-0.0028164,0.0014524,8.9734E-4,-0.0031002,0.0034244,-0.0029077,0.0031488,-3.8498E-4,4.011E-5,0.0037085,-0.0031302,0.0016262,-3.3806E-4,-0.0014554,0.0032495,-0.0044405,0.0039007,4.6268E-4,-6.8491E-4,0.0032272,-0.0029693,0.0039477,1.2403,5.2077,2.1586,1.904,1.7258,1.9024,1.7339,1.3141,1.24,1.39,1.5801,1.5412,1.2284,1.1657,1.3497,1.543,1.5118,1.2144,1.156,1.3386,1.5335,1.5103,1.2107,1.1555,1.3378,1.5353,1.5053,1.2116,1.1558,1.3415,1.5389,1.5052,1.2106,1.1563,1.3416,1.542,1.5042,1.2128,1.1557,1.3452,1.5388,1.5037,1.2103,1.1593,1.3464,1.5409,1.502,1.2106,1.1584,1.3495,1.5405,1.5026,1.2081,1.1586,1.3501,1.5416,1.504,1.2094,1.1602,1.3517,1.5426,1.5016,1.207,1.1597,1.3556,1.5432,1.5026,1.2051,1.162,1.354,1.5445,1.5004,1.2055,1.1593,1.3571,1.5433,1.501,1.2051,1.1627,1.3574,1.547,1.4957,1.2041,1.1616,1.3606,1.5482,1.4985,1.2024,1.1634,1.3609,1.55,1.4956,1.2032,1.165,1.3638,1.5494,1.4944,1.2016,1.1646,1.3647,1.5479,1.4925,1.1974,1.1658,1.3675,1.5479,1.4957,1.199,1.1678,1.3679,1.5497,1.4921,1.1967,1.1664,1.3704,1.551,1.4907,1.1972,1.1678,1.3687,1.5504,1.4881,1.1941,1.1681,1.3717,1.5524,1.4879,1.1976,1.1683,1.3719,1.5504,1.4868,1.1953,1.1692,1.3734,1.5548,1.4832,1.1967,1.1681,1.375,1.5517,1.4819,1.1937,1.1685,1.3768,1.5517,1.4795,1.1928,1.1689,1.3777,1.5509,1.4804,1.1921,1.1708,1.3787,1.5536,1.4798,1.1903,1.1707,1.3868,1.5612,1.4854,1.1944,1.1764,1.3874,1.5613,1.4835,1.1913,1.1779,1.3871,1.5599,1.4817,1.1922,1.1789,1.3872,1.5627,1.4812,1.1908,1.1796,1.3878,1.5629,1.4762,1.1904,1.1785,1.39,1.5616,1.4782,1.1887,1.1795,1.3904,1.5656,1.4774,1.1901,1.1812,1.3921,1.5616,1.4765,1.1874,1.1812,1.3941,1.5654,1.4752,1.1863,1.1832,1.3971,1.5659,1.4725,1.186,1.1837,1.3957,1.5629,1.472,1.1846,1.184,1.3967,1.5663,1.4706,1.1839,1.1842,1.398,1.5653,1.4694,1.1815,1.1859,1.4004,1.566,1.4682,1.1808,1.1861,1.4014,1.5651,1.4667,1.181,1.187,1.4022,1.5644,1.4624,1.1804,1.1874,1.4028,1.5651,1.4647,1.1797,1.1904,1.4043,1.5658,1.4615,1.1787,1.1892,1.4084,1.5657,1.4617,1.1769,1.1915,1.41,1.5688,1.4604,1.1774,1.1916,1.4098,1.5672,1.4583,1.1773,1.1931,1.4104,1.5672,1.4561,1.1754,1.1943,1.4145,1.5694,1.4559,1.1764,1.1939,1.414,1.5676,1.4546,1.1755,1.1959,1.414,1.567,1.4524,1.1755,1.1946,1.4182,1.5688,1.4509,1.1742,1.1967,1.4181,1.5691,1.4485,1.1746,1.1952,1.421,1.5691,1.4476,1.174,1.1989,1.4211,1.5686,1.4487,1.1716,1.2003,1.4261,1.5696,1.4461,1.1716,1.2002,1.4244,1.5704,1.4456,1.1699,1.2014,1.4244,1.5716,1.4423,1.1693,1.2002,1.4259,1.5711,1.4423,1.1694,1.2038,1.4251,1.57,1.4385,1.1692,1.2027,1.4275,1.573,1.4366,1.1668,1.2027,1.4266,1.574,1.4344,1.1684,1.2046,1.4313,1.5718,1.4333,1.1679,1.2059,1.4296,1.5727,1.4313,1.1679,1.2045,1.4367,1.5715,1.4326,1.165,1.207,1.4322,1.569,1.43,1.1658,1.2063,1.437,1.5705,1.43,1.1645,1.2096,1.4361,1.5718,1.4282,1.1629,1.2099,1.4362,1.5712,1.4262,1.1632,1.211,1.4354,1.5743,1.426,1.1624,1.212,1.4378,1.5756,1.4235,1.1623,1.215,1.4387,1.5765,1.4206,1.1589,1.2146,1.4387,1.577,1.418,1.1601,1.2151,1.4414,1.5759,1.419,1.1612,1.2172,1.4417,1.5753,1.419:6
-4.431E-4,-8.084E-4,0.0028609,-0.0022852,0.0048572,-0.002538,9.5191E-4,0.0040417,-0.0025207,0.0034174,-7.646E-4,-5.6536E-4,0.0042085,-0.0031944,0.003321,-0.0018495,0.0014457,0.0027078,-0.0030824,0.0029054,2.116,4.3701,2.4129,1.9826,1.3666,1.8114,1.759,1.5292,1.2749,1.2156,1.482,1.5841,1.4422,1.1903,1.1919,1.4351,1.5589,1.4269,1.1761,1.1859,1.4316,1.5612,1.4254,1.1754,1.1891,1.4339,1.5585,1.4252,1.1738,1.1874,1.4324,1.5579,1.4253,1.1756,1.1892,1.4376,1.559,1.4258,1.1761,1.1928,1.4371,1.5606,1.4249,1.1767,1.1915,1.4382,1.5617,1.4242,1.1741,1.1941,1.4381,1.5635,1.4243,1.176,1.1962,1.4407,1.5648,1.4233,1.1736,1.1974,1.4404,1.5697,1.4203,1.1743,1.197,1.4399,1.568,1.4192,1.175,1.1969,1.4423,1.5697,1.4161,1.1749,1.1999,1.4439,1.5714,1.4157,1.1788,1.2011,1.4479,1.573,1.4161,1.1758,1.2019,1.4502,1.5724,1.416,1.1756,1.2018,1.4524,1.573,1.4147,1.1752,1.2035,1.4538,1.5717,1.416,1.1764,1.2048,1.4534,1.5724,1.4157,1.176,1.2059,1.4519,1.5721,1.4116,1.1733,1.2081,1.4532,1.5732,1.4111,1.1728,1.2076,1.4523,1.5736,1.4102,1.1725,1.2081,1.4533,1.5768,1.4054,1.1725,1.2084,1.4539,1.5754,1.406,1.1733,1.2099,1.4545,1.5754,1.4031,1.1724,1.2087,1.4577,1.5741,1.4029,1.1693,1.2092,1.4561,1.5729,1.4024,1.1706,1.2095,1.4579,1.5702,1.402,1.1693,1.211,1.4594,1.5731,1.4003,1.1693,1.2102,1.4592,1.5729,1.3999,1.1674,1.2134,1.4616,1.5735,1.3987,1.1699,1.2138,1.4582,1.5723,1.3982,1.167,1.215,1.4608,1.5737,1.3934,1.1667,1.2148,1.4607,1.5745,1.3938,1.1668,1.2153,1.4622,1.57,1.3945,1.1668,1.2154,1.4634,1.5726,1.3917,1.1667,1.215,1.464,1.5721,1.3918,1.1659,1.2172,1.4657,1.5737,1.3917,1.1678,1.2177,1.467,1.5714,1.3909,1.1652,1.2198,1.4656,1.5738,1.3887,1.1653,1.2187,1.4684,1.5732,1.387,1.1648,1.2189,1.4647,1.5738,1.3877,1.1644,1.2199,1.4676,1.5749,1.383,1.1645,1.2201,1.4702,1.5748,1.3818,1.1654,1.2213,1.4708,1.5765,1.3838,1.167,1.2219,1.4736,1.5746,1.3852,1.1643,1.2241,1.4728,1.576,1.3789,1.1653,1.2239,1.4741,1.5758,1.3798,1.1646,1.2251,1.4732,1.5768,1.3788,1.1665,1.2281,1.4768,1.5779,1.3784,1.1645,1.2293,1.4749,1.5789,1.3762,1.1655,1.2259,1.4752,1.5788,1.3743,1.1628,1.2269,1.4776,1.5747,1.3737,1.1633,1.229,1.4793,1.5779,1.3714,1.1644,1.2297,1.4788,1.5762,1.3741,1.1623,1.2296,1.4809,1.5763,1.3714,1.1619,1.23,1.4817,1.5753,1.3722,1.1592,1.2361,1.481,1.579,1.3686,1.1609,1.2352:6
0.0038903,0.0036635,0.0016298,0.0036404,0.0022971,0.0030122,0.0036355,0.0015059,0.0038606,0.0024449,0.0028646,0.0030728,0.0011755,0.0034915,0.0018959,0.0037099,0.0038703,0.0011507,0.0038349,0.0015745,0.0035772,0.0037513,0.0014477,0.0039203,0.0023453,0.0029684,0.0029398,0.0011517,0.0033195,0.0021858,0.0036519,0.31173,0.45325,0.28463,0.28515,0.27215,0.22474,0.18347,0.18544,0.22306,0.24082,0.21213,0.17703,0.18225,0.22126,0.24066,0.21182,0.17799,0.1827,0.22122,0.24156,0.21279,0.17763,0.18298,0.22085,0.24107,0.21291,0.17791,0.183,0.22128,0.24131,0.21289,0.17793,0.18334,0.22192,0.24284,0.21494,0.17973,0.18317,0.22178,0.24261,0.21474,0.17907,0.18383,0.22209,0.24315,0.21467,0.17899,0.18403,0.22247,0.24378,0.21601,0.17935,0.18373,0.22247,0.24314,0.21575,0.17925,0.18375,0.22193,0.24327,0.21702,0.17955,0.18443,0.22268,0.243,0.21684,0.17972,0.18419,0.2223,0.24356,0.21661,0.18011,0.18407,0.22272,0.24407,0.21737,0.17994,0.18446,0.22292,0.2443,0.21779,0.18048,0.18472,0.22365,0.24472,0.21821,0.18052,0.1842,0.22289,0.24416,0.21817,0.18082,0.18449,0.22329,0.24454,0.2188,0.18126,0.18366,0.22357,0.24456,0.21897,0.18061,0.18413,0.22358,0.24427,0.21804,0.18076,0.18418,0.22356,0.2447,0.21863,0.18048,0.18457,0.22319,0.24537,0.21953,0.18215,0.18401,0.22327,0.24429,0.21941,0.18038,0.1844,0.22304,0.24497,0.21931,0.18175,0.18379,0.22381,0.24554,0.22021,0.18209,0.18507,0.22302,0.24563,0.22019,0.18205,0.18421,0.2226,0.24559,0.21958,0.18251,0.18489,0.22366,0.24562,0.22035,0.1822,0.18476,0.22378,0.24503,0.21997,0.18227,0.18434,0.2231,0.24583,0.22054,0.18219,0.18479,0.22299,0.24531,0.22053,0.18232,0.18436,0.22358,0.24557,0.22102,0.1828,0.18444,0.2228,0.24562,0.22118,0.18282,0.18473,0.22319,0.24516,0.22174,0.18264,0.1848,0.22367,0.24537,0.22228,0.18237,0.18506,0.22329,0.24678,0.22168,0.18268,0.18553,0.22404,0.24668,0.22204,0.18313,0.18405,0.22291,0.24549,0.22153,0.18315,0.18432,0.2235,0.24585,0.22248,0.18303,0.18515,0.22276,0.24596,0.22209,0.18331,0.18458,0.22299,0.24538,0.2218,0.18297,0.18439,0.2228,0.2458,0.223,0.1829,0.18434,0.22296,0.24589,0.22196,0.18323,0.18475,0.22285,0.24582,0.22271,0.18336,0.18484,0.22324,0.24698,0.22294,0.18344,0.18445,0.22318,0.2472,0.22225,0.18371,0.18461,0.22346,0.24622,0.22347,0.1828,0.18413,0.22316,0.24608,0.22299,0.18358,0.18416,0.22302,0.24598,0.22315,0.18427,0.18389,0.2229,0.2456,0.22358,0.18361,0.18493,0.22335,0.24656,0.22264,0.18374,0.18503,0.22341,0.24586,0.22383,0.18372,0.18532,0.22363,0.24552,0.22346,0.18357,0.18425,0.22285,0.24613,0.22329,0.18376,0.18443,0.22275,0.24664,0.22367,0.18396,0.18516,0.22286,0.24683,0.2234,0.18423,0.18464,0.22294,0.2466,0.22405,0.18359,0.18388,0.22316,0.24682,0.22416,0.18393,0.18472,0.2232,0.24607,0.22391,0.18455,0.18495,0.22248,0.24548,0.22405,0.18393,0.1849,0.22311,0.24674,0.22383,0.18409,0.18473,0.22262,0.24656,0.22439,0.18511,0.18433,0.22304,0.24704,0.22441,0.18464,0.18456,0.22295,0.24685,0.22404,0.1849,0.1849,0.22226,0.2468,0.22416,0.18469,0.18444,0.22278,0.24627,0.22556,0.18387,0.18506,0.22288,0.24691,0.22471,0.1851,0.18419,0.22347,0.24733,0.22553,0.18392,0.18408,0.2227,0.24709,0.22472,0.18477,0.18524,0.22312,0.24764,0.22559,0.185,0.18417,0.22342,0.24713,0.22571,0.18467,0.18413,0.2224,0.24687,0.22505,0.18523,0.18451,0.22256,0.24646,0.22568,0.18477,0.1844,0.22221,0.24603,0.22554,0.18545,0.18434,0.22244,0.2473,0.22575,0.18532,0.18392,0.22257,0.24665,0.22587,0.18461,0.18479,0.22244,0.24638,0.22582,0.18481,0.18422,0.22257,0.24639,0.22589,0.18503,0.1845,0.2228,0.24605,0.22618,0.18505,0.1852,0.22265,0.24694,0.22651,0.18514,0.18464,0.22165,0.2469,0.22632,0.18498,0.051714:6
0.0038651,0.0028667,0.0034099,0.0033542,0.0037747,0.0059635,0.0027615,0.0038384,0.002512,0.0034772,0.0046946,0.0031272,0.0039712,0.0035586,0.0031618,0.0053309,0.002934,0.0038761,0.0027164,0.00393,0.0048277,0.0023305,0.0039832,0.0034973,0.70029,0.3801,0.26574,0.19152,0.22547,0.24968,0.23154,0.19827,0.1738,0.20365,0.2402,0.22789,0.19691,0.17444,0.2029,0.23976,0.22879,0.19707,0.17421,0.20303,0.24072,0.23025,0.19701,0.1747,0.20405,0.24116,0.23022,0.19726,0.17551,0.20448,0.24068,0.23034,0.19692,0.17475,0.20333,0.24109,0.23156,0.19725,0.17558,0.20459,0.24144,0.23101,0.19831,0.17528,0.20405,0.24131,0.23177,0.19692,0.17556,0.2045,0.24089,0.23238,0.19756,0.17608,0.20388,0.24138,0.23203,0.19735,0.1766,0.20461,0.24108,0.23281,0.19814,0.17622,0.20456,0.24092,0.23356,0.19756,0.17685,0.20432,0.2422,0.23339,0.19829,0.17688,0.2048,0.24173,0.23304,0.19815,0.17683,0.2043,0.24219,0.23405,0.19866,0.17606,0.20511,0.24159,0.23364,0.19885,0.17714,0.2051,0.24217,0.23451,0.19855,0.17709,0.20577,0.24294,0.2343,0.19886,0.17674,0.20555,0.24295,0.23415,0.1986,0.17673,0.2054,0.24284,0.23476,0.19817,0.17691,0.20517,0.24244,0.23493,0.19791,0.17742,0.20423,0.24278,0.23491,0.19916,0.17712,0.20429,0.24221,0.23495,0.19832,0.17675,0.20479,0.24248,0.23516,0.19849,0.1775,0.20525,0.24264,0.23609,0.19919,0.17772,0.20529,0.24278,0.23608,0.19891,0.17789,0.20448,0.24244,0.23585,0.19966,0.17749,0.20542,0.24263,0.23662,0.1997,0.17795,0.2049,0.24274,0.23693,0.19929,0.17749,0.20542,0.24313,0.23632,0.19938,0.17737,0.20439,0.2417,0.23619,0.1994,0.17782,0.20534,0.24243,0.23649,0.19926,0.17739,0.20518,0.24231,0.23596,0.19967,0.17756,0.20442,0.24252,0.23632,0.19979,0.17732,0.20546,0.2428,0.23694,0.20027,0.1778,0.205,0.24371,0.23705,0.1994,0.17772,0.20524,0.24252,0.23623,0.20002,0.17777,0.20477,0.24258,0.23707,0.19959,0.17822,0.2053,0.24288,0.23726,0.20027,0.17827,0.20479,0.24299,0.23643,0.19903,0.17827,0.20461,0.24286,0.23712,0.20068,0.17871,0.20553,0.24375,0.23825,0.1996,0.17831,0.20538,0.24338,0.23674,0.20014,0.17843,0.20474,0.24247,0.2372,0.20043,0.17789,0.20595,0.24345,0.23777,0.19987,0.17872,0.20521,0.24302,0.23728,0.20011,0.17878,0.20544,0.24249,0.23741,0.20044,0.17839,0.20534,0.24273,0.23767,0.20012,0.17808,0.20562,0.24326,0.23794,0.20016,0.17752,0.20522,0.24301,0.23712,0.19989,0.1787,0.20448,0.24301,0.23803,0.20011,0.17791,0.2048,0.24312,0.23776,0.20019,0.17875,0.20437,0.24313,0.23828,0.20057,0.1776,0.20447,0.24275,0.23753,0.20057,0.17858,0.2051,0.24223,0.23849,0.20028,0.17903,0.20474,0.24256,0.2379,0.20054,0.1779,0.20523,0.24279,0.23801,0.20073,0.17849,0.20451,0.24243,0.23794,0.20071,0.17825,0.20434,0.24254,0.23788,0.20031,0.17847,0.20461,0.24256,0.23834,0.20049,0.17863,0.20519,0.24316,0.23846,0.20027,0.17864,0.20455,0.24299,0.23844,0.20104,0.17865,0.20427,0.24213,0.23829,0.20103,0.17829,0.20482,0.2425,0.23862,0.20054,0.17818,0.20431,0.24235,0.23806,0.20044,0.17837,0.20408,0.24236,0.23895,0.20179,0.1784,0.20444,0.24268,0.2386,0.20143,0.17865,0.20464,0.24312,0.23895,0.20115,0.1787,0.20433,0.24172,0.23853,0.20159,0.17854,0.20399,0.24225,0.23836,0.20094,0.17842,0.20284,0.24302,0.23892,0.20144,0.17869,0.20472,0.24269,0.23888,0.20117,0.17858,0.20382,0.24231,0.23913,0.2018,0.17798,0.20409,0.24174,0.23945,0.202,0.17837,0.20424,0.24251,0.23946,0.20107,0.17875,0.20402,0.24287,0.23952,0.20171,0.17884,0.20385,0.24229,0.23979,0.20166,0.17802,0.20283,0.2429,0.23962,0.20225,0.17848,0.20386,0.24176,0.23951,0.20221,0.17908,0.2039,0.24215,0.24007,0.20216,0.17801,0.20385,0.24246,0.24005,0.20217,0.17896,0.20347,0.24172,0.24024,0.20321,0.17883,0.20396,0.24307,0.23933,0.20259,0.17864,0.2044,0.2423,0.23935,0.20233,0.17882,0.20382,0.24136,0.23964,0.11632:6
0.0010054,0.0041277,0.0029855,0.0037637,0.0041508,0.0015026,0.0040081,0.0027278,0.0035163,0.0048079,9.9672E-4,0.0042454,0.0022078,0.0035607,0.0041596,0.0021871,0.0039254,0.0023334,0.0038547,0.0042321,0.0016669,0.0042888,0.0028376,0.0029106,0.0040157,0.0015477,0.0041146,0.0022386,0.0038399,0.0046231,0.0012147,0.0037444,0.0023514,0.0032123,0.0038573,0.0014006,0.0039859,0.0026869,0.0040436,0.0040297,9.8759E-4,0.0040432,0.003005,0.0031028,0.0041301,0.0013506,0.0034531,0.0028535,0.0033516,0.0036024,0.0018746,0.0037555,0.0025196,0.0029838,0.0036694,0.001509,0.004255,0.32956,0.52482,0.2944,0.23006,0.1896,0.23493,0.24518,0.21102,0.17643,0.17835,0.21765,0.2361,0.20868,0.1764,0.17846,0.21769,0.23718,0.21052,0.17545,0.17924,0.21696,0.23695,0.21126,0.17696,0.17882,0.21756,0.2369,0.21194,0.17633,0.17965,0.21638,0.23728,0.21261,0.17685,0.1791,0.21683,0.23867,0.21372,0.17771,0.17978,0.21705,0.23798,0.21521,0.17765,0.17915,0.21649,0.23912,0.21538,0.17761,0.17916,0.2164,0.2388,0.21527,0.17869,0.17883,0.21619,0.23816,0.21648,0.17923,0.17842,0.21618,0.23926,0.21707,0.17945,0.17915,0.21592,0.23925,0.21741,0.17948,0.17892,0.21536,0.23933,0.21827,0.17968,0.17915,0.21516,0.24072,0.2185,0.17989,0.17788,0.2152,0.23971,0.21969,0.1805,0.1782,0.2155,0.23951,0.21941,0.18113,0.17864,0.21455,0.23978,0.21981,0.18074,0.17866,0.21383,0.23979,0.22046,0.18188,0.17847,0.21394,0.23997,0.22081,0.18228,0.17807,0.21386,0.23961,0.22195,0.18231,0.17823,0.21328,0.24048,0.22075,0.18298,0.17782,0.21365,0.24053,0.22262,0.18247,0.17787,0.21345,0.23942,0.22238,0.18317,0.17756,0.21289,0.23979,0.22256,0.18308,0.17789,0.21246,0.23931,0.22406,0.18386,0.17779,0.21238,0.24013,0.22359,0.18505,0.17732,0.21116,0.24044,0.22411,0.18509,0.17756,0.21144,0.23965,0.22466,0.18495,0.17739,0.21156,0.24012,0.22527,0.18545,0.17756,0.2105,0.24016,0.22511,0.18519,0.1769,0.21025,0.24028,0.22516,0.18563,0.17687,0.21006,0.24049,0.22616,0.18638,0.1767,0.21039,0.24028,0.22631,0.18639,0.17637,0.20944,0.24036,0.22697,0.18704,0.17667,0.20938,0.24035,0.22718,0.18667,0.17647,0.209,0.24013,0.22768,0.18821,0.17658,0.20837,0.24032,0.22808,0.18779,0.17646,0.20879,0.23954,0.22859,0.18821,0.17657,0.2083,0.23982,0.22874,0.1885,0.17661,0.20854,0.24016,0.22934,0.18921,0.17655,0.20763,0.24056,0.22874,0.18916,0.17651,0.20713,0.24046,0.22937,0.19029,0.17589,0.2072,0.23992,0.22977,0.19058,0.17612,0.20606,0.23968,0.23033,0.19027,0.1761,0.20644,0.23959,0.23065,0.19078,0.17576,0.20557,0.23974,0.22985,0.19116,0.17589,0.20615,0.23951,0.23096,0.19138,0.17562,0.20568,0.23894,0.2315,0.19172,0.17571,0.20503,0.23894,0.23144,0.19276,0.17516,0.20483,0.23919,0.23185,0.19294,0.17569,0.20392,0.23935,0.23173,0.1927,0.17545,0.20351,0.2392,0.23211,0.19299,0.1753,0.2041,0.23926,0.23261,0.19414,0.17563,0.20367,0.2387,0.2324,0.19402,0.17518,0.20291,0.23908,0.2325,0.19546,0.17494,0.20275,0.23961,0.23351,0.19524,0.17623,0.20218,0.23881,0.23331,0.1952,0.17521,0.20187,0.23874,0.23423,0.19602,0.1756,0.2016,0.23869,0.23412,0.1966,0.17581,0.2013,0.23819,0.23543,0.19677,0.1751,0.20147,0.23814,0.234,0.19749,0.17542,0.20023,0.2383,0.23386,0.19764,0.17498,0.20054,0.23832,0.23533,0.19913,0.17485,0.19912,0.23748,0.2356,0.19868,0.17497,0.19951,0.23709,0.23579,0.19897,0.17543,0.19912,0.23737,0.23556,0.19939,0.17621,0.19857,0.23804,0.23613,0.19932,0.17506,0.19855,0.23789,0.2358,0.20055,0.17572,0.19798,0.23676,0.23589,0.2009,0.17549,0.19792,0.23656,0.23594,0.20152,0.17462,0.19778,0.2359,0.23602,0.20133,0.17469,0.1969,0.236,0.23738,0.20255,0.17522,0.1962,0.23589,0.23698:6
-1.9E-7,1.5833E-6,1.6333E-7,4.0E-8,7.5667E-7,-9.7333E-7,1.5067E-6,1.47E-6,-6.3333E-7,8.8333E-7,-1.5767E-6,5.3E-7,7.8E-7,-1.0633E-6,8.5667E-7,-7.5667E-7,7.9E-7,2.3667E-7,-6.7E-7,9.8E-7,-7.6333E-7,1.3333E-6,5.7333E-7,-4.2333E-7,7.2E-7,-1.5667E-7,7.8667E-7,1.0467E-6,1.9E-7,1.3567E-6,-7.4E-7,4.6667E-7,1.29E-6,-6.6667E-7,5.4667E-7,-3.1667E-7,6.4208E-4,0.0010696,5.8254E-4,5.0913E-4,3.8339E-4,4.9643E-4,4.9276E-4,4.2235E-4,3.4916E-4,3.6902E-4,4.366E-4,4.6869E-4,4.1976E-4,3.38E-4,3.6878E-4,4.315E-4,4.6795E-4,4.2116E-4,3.3575E-4,3.7345E-4,4.3097E-4,4.6805E-4,4.2106E-4,3.3653E-4,3.6975E-4,4.3132E-4,4.6875E-4,4.2061E-4,3.3598E-4,3.7241E-4,4.3043E-4,4.6698E-4,4.2157E-4,3.3648E-4,3.7091E-4,4.3031E-4,4.6265E-4,4.2089E-4,3.36E-4,3.7046E-4,4.2995E-4,4.654E-4,4.2287E-4,3.3557E-4,3.6994E-4,4.3158E-4,4.6709E-4,4.2519E-4,3.3493E-4,3.6969E-4,4.2975E-4,4.6829E-4,4.2491E-4,3.3614E-4,3.6947E-4,4.2843E-4,4.6551E-4,4.2388E-4,3.3563E-4,3.69E-4,4.2836E-4,4.651E-4,4.2461E-4,3.3722E-4,3.6753E-4,4.2712E-4,4.6626E-4,4.2667E-4,3.356E-4,3.7E-4,4.2699E-4,4.676E-4,4.2505E-4,3.3804E-4,3.6911E-4,4.2631E-4,4.6659E-4,4.2416E-4,3.3604E-4,3.6806E-4,4.259E-4,4.5967E-4,4.2511E-4,3.4133E-4,3.7015E-4,4.283E-4,4.687E-4,4.2907E-4,3.3738E-4,3.6912E-4,4.2762E-4,4.6781E-4,4.3E-4,3.3746E-4,3.6711E-4,4.2665E-4,4.6921E-4,4.2996E-4,3.3898E-4,3.6789E-4,4.2566E-4,4.6703E-4,4.2963E-4,3.3944E-4,3.6672E-4,4.2547E-4,4.6723E-4,4.3089E-4,3.3935E-4,3.6739E-4,4.2524E-4,4.6689E-4,4.3039E-4,3.3959E-4,3.661E-4,4.2336E-4,4.6863E-4,4.3011E-4,3.3866E-4,3.6617E-4,4.2157E-4,4.6487E-4,4.308E-4,3.3803E-4,3.5092E-4,4.2419E-4,4.6641E-4,4.2868E-4,3.386E-4,3.5873E-4,4.2823E-4,4.6517E-4,4.336E-4,3.3935E-4,3.66E-4,4.2279E-4,4.6472E-4,4.3233E-4,3.3826E-4,3.6664E-4,4.2171E-4,4.675E-4,4.3176E-4,3.4078E-4,3.6526E-4,4.2344E-4,4.6792E-4,4.2654E-4,2.8948E-4,3.0671E-4,4.017E-4,4.4704E-4,4.1923E-4,3.4559E-4,3.7024E-4,4.2993E-4,4.7296E-4,4.3794E-4,3.4315E-4,3.642E-4,4.2099E-4,4.6602E-4,4.3427E-4,3.4076E-4,3.6451E-4,4.1957E-4,4.6631E-4,4.3395E-4,3.4082E-4,3.2775E-4,3.7219E-4,4.3801E-4,4.5047E-4,3.4659E-4,3.6753E-4,4.2378E-4,4.7009E-4,4.3749E-4,3.4155E-4,3.6284E-4,4.1832E-4,4.6805E-4,4.367E-4,3.4309E-4,3.624E-4,4.1749E-4,4.6721E-4,4.3722E-4,3.4238E-4,3.6222E-4,4.1796E-4,4.6543E-4,4.3569E-4,3.4171E-4,3.622E-4,4.1599E-4,4.6607E-4,4.3583E-4,3.4147E-4,3.6288E-4,4.1783E-4,4.6747E-4,4.3596E-4,3.4398E-4,3.6079E-4,4.1695E-4,4.6604E-4,4.3597E-4,3.4377E-4,3.4563E-4,4.1644E-4,4.7061E-4,4.3995E-4,3.4418E-4,3.6251E-4,4.1656E-4,4.61E-4,4.4029E-4,3.4386E-4,3.6217E-4,4.1717E-4,4.6737E-4,4.3978E-4,3.4428E-4,3.6194E-4,4.1585E-4,4.6819E-4,4.4117E-4,3.4402E-4,3.5879E-4,4.1479E-4,4.6873E-4,4.4029E-4,3.4456E-4,3.6131E-4,4.1491E-4,4.6674E-4,4.3945E-4,3.4458E-4,3.6015E-4,4.1351E-4,4.5945E-4,4.4438E-4,3.4576E-4,3.6084E-4,4.1502E-4,4.689E-4,4.4057E-4,3.4489E-4,3.6169E-4,4.1265E-4,4.6727E-4,4.4367E-4,3.4561E-4,3.594E-4,4.1121E-4,4.6699E-4,4.4136E-4,3.4479E-4,3.4172E-4,4.1086E-4,4.6742E-4,4.4342E-4,3.4804E-4,3.6052E-4,4.1237E-4,4.672E-4,4.4408E-4,3.4048E-4,3.5896E-4,4.1362E-4,4.6637E-4,4.4482E-4,3.4797E-4,3.6065E-4,4.1046E-4,4.6881E-4,4.4232E-4,3.4945E-4,3.5961E-4,4.1102E-4,4.6845E-4,4.4429E-4,3.4906E-4,3.5898E-4,4.1253E-4,4.6767E-4,4.4396E-4,3.4837E-4,3.587E-4,4.1109E-4,4.6797E-4,4.4418E-4,3.4936E-4,3.5789E-4,4.0903E-4,4.6849E-4,4.444E-4,3.4827E-4,3.5772E-4,3.1762E-4:6
-2.0233E-6,1.01E-6,-9.5667E-7,1.0867E-6,1.27E-6,5.4E-7,1.08E-6,-1.4167E-6,1.6933E-6,3.0E-8,-3.0333E-7,5.0667E-7,-6.7333E-7,1.3567E-6,9.8333E-7,-4.5667E-7,4.4E-7,-8.1E-7,1.97E-6,1.9333E-7,-7.8333E-7,8.8667E-7,3.4333E-7,1.32E-6,1.52E-6,-2.4133E-6,1.5967E-6,-8.5667E-7,1.4E-6,-1.8667E-7,-6.3333E-8,7.0333E-7,-7.3E-7,1.43E-6,-4.6E-7,-7.9667E-7,1.02E-6,0.0011335,8.1643E-4,5.9864E-4,5.5536E-4,4.3955E-4,3.5386E-4,4.1436E-4,4.7515E-4,4.6604E-4,3.794E-4,3.522E-4,3.8594E-4,4.6549E-4,4.5943E-4,3.7238E-4,3.4989E-4,3.6022E-4,4.593E-4,4.4899E-4,3.7993E-4,3.5856E-4,3.8533E-4,4.6573E-4,4.6158E-4,3.7635E-4,3.5372E-4,3.8421E-4,4.638E-4,4.5973E-4,3.7513E-4,3.517E-4,3.8281E-4,4.6147E-4,4.6022E-4,3.7431E-4,3.5202E-4,3.8067E-4,4.6198E-4,4.6138E-4,3.7593E-4,3.5173E-4,3.8121E-4,4.6187E-4,4.6073E-4,3.7581E-4,3.521E-4,3.8022E-4,4.603E-4,4.6145E-4,3.7539E-4,3.5307E-4,3.7862E-4,4.6067E-4,4.6186E-4,3.7642E-4,3.5109E-4,3.7859E-4,4.6156E-4,4.6189E-4,3.7647E-4,3.528E-4,3.7883E-4,4.6119E-4,4.6296E-4,3.7775E-4,3.5188E-4,3.7805E-4,4.6154E-4,4.6283E-4,3.7716E-4,3.5139E-4,3.7683E-4,4.5687E-4,4.6149E-4,3.7831E-4,3.5029E-4,3.7586E-4,4.5914E-4,4.6093E-4,3.7915E-4,3.5133E-4,3.7534E-4,4.5868E-4,4.6448E-4,3.7783E-4,3.5099E-4,3.7543E-4,4.5648E-4,4.627E-4,3.7995E-4,3.5211E-4,3.7558E-4,4.5847E-4,4.6103E-4,3.7994E-4,3.513E-4,3.7433E-4,4.5924E-4,4.6324E-4,3.8026E-4,3.5144E-4,3.7352E-4,4.5761E-4,4.6271E-4,3.8108E-4,3.5222E-4,3.7321E-4,4.5755E-4,4.6153E-4,3.8064E-4,3.5344E-4,3.7418E-4,4.565E-4,4.6512E-4,3.8224E-4,3.518E-4,3.7355E-4,4.5891E-4,4.657E-4,3.8343E-4,3.5098E-4,3.7232E-4,4.5753E-4,4.6452E-4,3.8206E-4,3.516E-4,3.7089E-4,4.5597E-4,4.6418E-4,3.8322E-4,3.5076E-4,3.7006E-4,4.5095E-4,4.6499E-4,3.8426E-4,3.5174E-4,3.7045E-4,4.5638E-4,4.6386E-4,3.8429E-4,3.5089E-4,3.6931E-4,4.5504E-4,4.6545E-4,3.8512E-4,3.5486E-4,3.6791E-4,4.549E-4,4.6553E-4,3.8539E-4,3.5318E-4,3.7047E-4,4.5472E-4,4.6357E-4,3.8549E-4,3.536E-4,3.7155E-4,4.5463E-4,4.6598E-4,3.8536E-4,3.5414E-4,3.6932E-4,4.5733E-4,4.6391E-4,3.8678E-4,3.53E-4,3.6996E-4,4.5377E-4,4.6656E-4,3.8766E-4,3.5247E-4,3.6972E-4,4.5485E-4,4.664E-4,3.8703E-4,3.5232E-4,3.6829E-4,4.5679E-4,4.678E-4,3.8814E-4,3.5268E-4,3.6828E-4,4.5366E-4,4.6708E-4,3.8835E-4,3.5045E-4,3.6577E-4,4.5346E-4,4.679E-4,3.8945E-4,3.5185E-4,3.6699E-4,4.548E-4,4.674E-4,3.8937E-4,3.5058E-4,3.6637E-4,4.5315E-4,4.682E-4,3.9071E-4,3.5355E-4,3.6602E-4,4.5437E-4,4.6613E-4,3.9131E-4,3.5179E-4,3.6588E-4,4.5542E-4,4.6852E-4,3.9182E-4,3.5228E-4,3.6603E-4,4.5314E-4,4.6984E-4,3.9246E-4,3.5296E-4,3.6635E-4,4.5343E-4,4.6918E-4,3.9209E-4,3.5305E-4,3.6391E-4,4.5071E-4,4.6804E-4,3.9321E-4,3.5187E-4,3.6582E-4,4.5113E-4,4.6979E-4,3.9362E-4,3.5472E-4,3.6415E-4,4.5198E-4,4.686E-4,3.9326E-4,3.5349E-4,3.6494E-4,4.514E-4,4.6877E-4,3.9385E-4,3.5281E-4,3.646E-4,4.5152E-4,4.6649E-4,3.9393E-4,3.5121E-4,3.627E-4,4.5156E-4,4.6726E-4,3.9447E-4,3.5434E-4,3.6429E-4,4.5296E-4,4.6813E-4,3.9393E-4,3.5165E-4,3.6374E-4,4.535E-4,4.6873E-4,3.9527E-4,3.5406E-4,3.6269E-4,4.5115E-4,4.6875E-4,3.9404E-4,3.5453E-4,3.6384E-4,4.5095E-4,4.6842E-4,3.9595E-4,3.5262E-4,3.635E-4,4.5271E-4,4.6816E-4,3.9674E-4,3.5313E-4,3.632E-4,4.4926E-4,4.6805E-4,3.9763E-4,3.5347E-4,3.626E-4,4.5016E-4:6
-1.51E-6,-2.87E-6,-1.0467E-6,-2.12E-6,-1.8E-7,-8.7333E-7,-1.2467E-6,4.6333E-7,-1.42E-6,-1.3333E-8,-2.49E-6,-9.8333E-7,-7.7667E-7,-2.35E-6,5.1E-7,-1.66E-6,-2.1967E-6,7.6E-7,-2.1467E-6,4.7333E-7,-1.3733E-6,-1.9633E-6,1.0E-8,-1.9733E-6,-6.7333E-7,-6.6E-7,-8.6E-7,-8.8333E-7,-2.8633E-6,-3.1667E-7,-1.6833E-6,-1.66E-6,-8.5E-7,-1.92E-6,-4.4333E-7,-1.1633E-6,-1.0133E-6,-1.0E-6,-1.1E-6,6.1667E-7,-1.9767E-6,-1.2133E-6,-4.6E-7,-1.88E-6,2.8667E-7,-8.1667E-7,-1.35E-6,-3.1333E-7,-1.8033E-6,-4.9333E-7,-2.14E-6,-6.8E-7,0.0020081,0.001647,7.4634E-4,0.0011327,9.5957E-4,7.8056E-4,7.0111E-4,5.8322E-4,7.6144E-4,7.9265E-4,7.0515E-4,6.124E-4,5.6792E-4,7.1703E-4,7.699E-4,6.9807E-4,6.0349E-4,5.6445E-4,7.1089E-4,7.6651E-4,6.9947E-4,6.0245E-4,5.6448E-4,7.1119E-4,7.6803E-4,6.9995E-4,6.0019E-4,5.6432E-4,7.0727E-4,7.6896E-4,7.0038E-4,6.0248E-4,5.6476E-4,7.0434E-4,7.6816E-4,7.0337E-4,6.0415E-4,5.6494E-4,7.0761E-4,7.6866E-4,7.0295E-4,6.0269E-4,5.6281E-4,7.0652E-4,7.6753E-4,7.0365E-4,6.0452E-4,5.6175E-4,7.0474E-4,7.6951E-4,7.0477E-4,6.0569E-4,5.6294E-4,7.0137E-4,7.7162E-4,7.0826E-4,6.0864E-4,5.6374E-4,7.0357E-4,7.7E-4,7.0939E-4,6.0733E-4,5.6213E-4,7.0062E-4,7.6888E-4,7.1005E-4,6.0945E-4,5.6053E-4,6.9972E-4,7.679E-4,7.1054E-4,6.0761E-4,5.588E-4,6.978E-4,7.6956E-4,7.1324E-4,6.096E-4,5.5878E-4,7.0077E-4,7.6796E-4,7.1488E-4,6.0807E-4,5.5863E-4,6.9617E-4,7.6731E-4,7.1379E-4,6.1174E-4,5.5759E-4,6.9459E-4,7.6661E-4,7.1739E-4,6.1372E-4,5.5758E-4,6.9752E-4,7.6911E-4,7.1804E-4,6.1095E-4,5.5869E-4,6.947E-4,7.6858E-4,7.1929E-4,6.1416E-4,5.5908E-4,6.9041E-4,7.6657E-4,7.2003E-4,6.1642E-4,5.5609E-4,6.9332E-4,7.6704E-4,7.2132E-4,6.1744E-4,5.5631E-4,6.911E-4,7.6651E-4,7.2258E-4,6.1913E-4,5.5375E-4,6.9094E-4,7.6597E-4,7.2451E-4,6.1769E-4,5.5658E-4,6.8944E-4,7.6469E-4,7.2425E-4,6.1972E-4,5.5551E-4,6.8975E-4,7.6467E-4,7.2549E-4,6.213E-4,5.547E-4,6.8394E-4,7.6503E-4,7.2727E-4,6.218E-4,5.5381E-4,6.8546E-4,7.6223E-4,7.2523E-4,6.2282E-4,5.5237E-4,6.8436E-4,7.6539E-4,7.3022E-4,6.2214E-4,5.5307E-4,6.8073E-4,7.6273E-4,7.3135E-4,6.2342E-4,5.5439E-4,6.8144E-4,7.6497E-4,7.2949E-4,6.2639E-4,5.5116E-4,6.8337E-4,7.6343E-4,7.3309E-4,6.2525E-4,5.5232E-4,6.8177E-4,7.6293E-4,7.3425E-4,6.2556E-4,5.515E-4,6.7788E-4,7.6189E-4,7.3153E-4,6.3035E-4,5.5332E-4,6.7698E-4,7.6213E-4,7.3285E-4,6.2814E-4,5.518E-4,6.7622E-4,7.6212E-4,7.3407E-4,6.3133E-4,5.5051E-4,6.7539E-4,7.5965E-4,7.371E-4,6.317E-4,5.4985E-4,6.7453E-4,7.6063E-4,7.3806E-4,6.3202E-4,5.4688E-4,6.7414E-4,7.6068E-4,7.3785E-4,6.3147E-4,5.4968E-4,6.7195E-4,7.5852E-4,7.3849E-4,6.3469E-4,5.4897E-4,6.7025E-4,7.6242E-4,7.4067E-4,6.3801E-4,5.4881E-4,6.709E-4,7.5766E-4,7.4306E-4,6.3705E-4,5.4934E-4,6.6884E-4,7.5797E-4,7.4101E-4,6.3623E-4,5.4934E-4,6.6375E-4,7.555E-4,7.4347E-4,6.4033E-4,5.4959E-4,6.6619E-4,7.5828E-4,7.4571E-4,6.3806E-4,5.4846E-4,6.6479E-4,7.5522E-4,7.4267E-4,6.4178E-4,5.4928E-4,6.6257E-4,7.5726E-4,7.4685E-4,6.4281E-4,5.4825E-4,6.6237E-4,7.5839E-4,7.452E-4,6.4477E-4,5.4987E-4,6.6155E-4,7.5537E-4,7.4778E-4,6.4608E-4,5.4809E-4,6.5844E-4,7.5516E-4,7.4972E-4,6.483E-4,5.4801E-4,6.5914E-4,7.5398E-4,7.4974E-4,6.4789E-4,5.4897E-4,6.5767E-4,7.5399E-4,7.5212E-4,6.4892E-4,5.4768E-4,6.5739E-4,7.5045E-4,7.5086E-4,6.5058E-4,5.466E-4,6.5562E-4,7.5132E-4,7.5033E-4,6.5184E-4,5.4604E-4,6.5527E-4,7.5038E-4,7.5319E-4,6.5183E-4,5.4489E-4,6.5582E-4,7.5101E-4,7.5348E-4,6.5239E-4,5.468E-4,6.522E-4,7.5206E-4,7.5514E-4,6.5359E-4,5.4801E-4,6.5327E-4,7.4832E-4,7.5739E-4,8.3407E-5:6
-7.4E-7,-2.9E-7,-1.9467E-6,5.0E-8,-5.6333E-7,-9.1333E-7,-1.2167E-6,-2.1067E-6,8.6667E-8,-1.7467E-6,-4.0667E-7,-3.1E-7,-2.1667E-6,-2.0E-8,-7.4667E-7,-1.2633E-6,-6.3E-7,-1.8533E-6,-6.0667E-7,-1.72E-6,-3.3333E-7,-6.4333E-7,-3.0667E-6,3.7667E-7,-9.1333E-7,-6.3333E-7,-7.0667E-7,-2.5567E-6,8.9667E-7,-2.1267E-6,-1.6367E-6,-1.12E-6,-2.84E-6,7.3333E-8,-2.0467E-6,-1.7967E-6,-1.4567E-6,-2.3133E-6,1.8333E-7,-1.9133E-6,-7.5333E-7,-2.0333E-7,-3.0133E-6,-6.6E-7,-1.6067E-6,-1.4867E-6,4.6328E-4,0.002175,0.0011793,0.0010816,0.0010413,8.7872E-4,7.0018E-4,6.203E-4,7.4491E-4,8.0629E-4,7.441E-4,6.2907E-4,5.6908E-4,7.0224E-4,7.7537E-4,7.2757E-4,6.2062E-4,5.6036E-4,6.9574E-4,7.7056E-4,7.2442E-4,6.1808E-4,5.59E-4,6.9163E-4,7.6728E-4,7.2584E-4,6.158E-4,5.5962E-4,6.9177E-4,7.6803E-4,7.2593E-4,6.2093E-4,5.5832E-4,6.9182E-4,7.6499E-4,7.2485E-4,6.2236E-4,5.5898E-4,6.8948E-4,7.6912E-4,7.3114E-4,6.2304E-4,5.5581E-4,6.9017E-4,7.6812E-4,7.2748E-4,6.2423E-4,5.5525E-4,6.8887E-4,7.6826E-4,7.3084E-4,6.2577E-4,5.5536E-4,6.8828E-4,7.6846E-4,7.337E-4,6.2672E-4,5.5637E-4,6.8599E-4,7.6756E-4,7.3583E-4,6.2868E-4,5.5404E-4,6.861E-4,7.6759E-4,7.3258E-4,6.281E-4,5.5533E-4,6.8187E-4,7.6681E-4,7.3399E-4,6.2768E-4,5.5487E-4,6.8313E-4,7.6688E-4,7.3883E-4,6.3003E-4,5.5463E-4,6.8179E-4,7.6666E-4,7.3589E-4,6.3156E-4,5.5453E-4,6.789E-4,7.6253E-4,7.4009E-4,6.3177E-4,5.5183E-4,6.7678E-4,7.6604E-4,7.3989E-4,6.3289E-4,5.5005E-4,6.7664E-4,7.6651E-4,7.4189E-4,6.3555E-4,5.5247E-4,6.7337E-4,7.6393E-4,7.4183E-4,6.3759E-4,5.502E-4,6.7739E-4,7.6165E-4,7.4325E-4,6.3619E-4,5.5345E-4,6.7264E-4,7.6276E-4,7.4374E-4,6.3804E-4,5.491E-4,6.7391E-4,7.6068E-4,7.449E-4,6.4141E-4,5.5088E-4,6.7076E-4,7.6063E-4,7.4428E-4,6.4024E-4,5.5128E-4,6.7009E-4,7.5906E-4,7.4737E-4,6.4016E-4,5.5222E-4,6.7014E-4,7.5603E-4,7.4594E-4,6.4404E-4,5.4982E-4,6.6701E-4,7.5505E-4,7.4814E-4,6.4363E-4,5.5103E-4,6.6374E-4,7.5685E-4,7.474E-4,6.4554E-4,5.515E-4,6.6229E-4,7.5666E-4,7.4831E-4,6.4607E-4,5.4859E-4,6.6162E-4,7.5474E-4,7.5047E-4,6.4806E-4,5.4803E-4,6.6321E-4,7.545E-4,7.5245E-4,6.4778E-4,5.498E-4,6.6048E-4,7.5297E-4,7.4951E-4,6.4965E-4,5.4966E-4,6.6094E-4,7.535E-4,7.525E-4,6.5182E-4,5.47E-4,6.5713E-4,7.5575E-4,7.517E-4,6.5198E-4,5.4971E-4,6.5791E-4,7.511E-4,7.5318E-4,6.513E-4,5.4879E-4,6.5673E-4,7.53E-4,7.5113E-4,6.541E-4,5.4908E-4,6.5465E-4,7.4961E-4,7.5639E-4,6.554E-4,5.4773E-4,6.5294E-4,7.5174E-4,7.5514E-4,6.5564E-4,5.4677E-4,6.5473E-4,7.4929E-4,7.5772E-4,6.5863E-4,5.4812E-4,6.528E-4,7.4815E-4,7.5561E-4,6.589E-4,5.487E-4,6.4994E-4,7.4863E-4,7.5864E-4,6.6143E-4,5.4845E-4,6.4869E-4,7.4821E-4,7.5929E-4,6.6384E-4,5.4882E-4,6.4919E-4,7.4638E-4,7.5871E-4,6.6359E-4,5.4976E-4,6.4808E-4,7.4639E-4,7.6015E-4,6.6611E-4,5.4739E-4,6.491E-4,7.4399E-4,7.6171E-4,6.6319E-4,5.4966E-4,6.4568E-4,7.4454E-4,7.5872E-4,6.6575E-4,5.4838E-4,6.4527E-4,7.4495E-4,7.6158E-4,6.6834E-4,5.4848E-4,6.4124E-4,7.4225E-4,7.6156E-4,6.674E-4,5.4858E-4,6.4305E-4,7.4184E-4,7.6293E-4,6.721E-4,5.4876E-4,6.4358E-4,7.4139E-4,7.6073E-4,6.714E-4,5.4928E-4,6.4299E-4,7.398E-4,7.6365E-4,6.7421E-4,5.4902E-4,6.3693E-4,7.4082E-4,3.8386E-4:6
6.6667E-7,-1.6767E-6,-6.2E-7,-7.9667E-7,-2.04E-6,-1.1667E-7,-2.4033E-6,-5.8333E-7,-1.2E-7,-2.2667E-6,-3.4667E-7,-2.2933E-6,-1.9333E-7,-1.3433E-6,-2.69E-6,-4.6667E-8,-1.37E-6,6.3333E-8,-6.6666E-9,-2.2833E-6,8.3333E-8,-7.0E-7,-4.0333E-7,-8.8667E-7,-1.3067E-6,4.8333E-7,-2.16E-6,4.2333E-7,-3.8667E-7,-1.89E-6,4.6667E-8,-1.1467E-6,-1.2167E-6,-1.7033E-6,-3.17E-6,-2.7E-7,-9.5667E-7,0.0025697,0.0015047,0.0010827,6.6281E-4,8.1306E-4,8.1853E-4,8.3093E-4,7.2627E-4,5.6187E-4,6.5368E-4,7.4087E-4,7.6571E-4,6.8458E-4,5.4568E-4,6.2947E-4,7.2783E-4,7.5737E-4,6.7673E-4,5.4511E-4,6.2829E-4,7.2492E-4,7.5604E-4,6.755E-4,5.4688E-4,6.2441E-4,7.2537E-4,7.5429E-4,6.773E-4,5.4469E-4,6.2508E-4,7.2335E-4,7.5994E-4,6.7945E-4,5.4769E-4,6.2539E-4,7.2367E-4,7.5887E-4,6.788E-4,5.4698E-4,6.2449E-4,7.2357E-4,7.5888E-4,6.7983E-4,5.4869E-4,6.2434E-4,7.2453E-4,7.5802E-4,6.8125E-4,5.4824E-4,6.2429E-4,7.2305E-4,7.6068E-4,6.8004E-4,5.484E-4,6.2347E-4,7.2071E-4,7.6095E-4,6.809E-4,5.4745E-4,6.214E-4,7.2158E-4,7.6349E-4,6.8421E-4,5.4895E-4,6.2133E-4,7.2301E-4,7.6135E-4,6.8289E-4,5.4905E-4,6.231E-4,7.2161E-4,7.6082E-4,6.8473E-4,5.4585E-4,6.2332E-4,7.2124E-4,7.6078E-4,6.8719E-4,5.4742E-4,6.1906E-4,7.2333E-4,7.6124E-4,6.8618E-4,5.4889E-4,6.2292E-4,7.1982E-4,7.6364E-4,6.8688E-4,5.4838E-4,6.2074E-4,7.2106E-4,7.6402E-4,6.8607E-4,5.4851E-4,6.218E-4,7.1907E-4,7.6433E-4,6.8829E-4,5.4856E-4,6.2039E-4,7.1895E-4,7.6567E-4,6.8479E-4,5.49E-4,6.1647E-4,7.1911E-4,7.6157E-4,6.8781E-4,5.5184E-4,6.1837E-4,7.18E-4,7.6091E-4,6.8907E-4,5.4965E-4,6.1971E-4,7.1898E-4,7.6394E-4,6.8901E-4,5.4976E-4,6.1733E-4,7.1818E-4,7.6217E-4,6.9174E-4,5.5186E-4,6.1619E-4,7.1787E-4,7.618E-4,6.9074E-4,5.5182E-4,6.1714E-4,7.1411E-4,7.6295E-4,6.9154E-4,5.4956E-4,6.162E-4,7.143E-4,7.6457E-4,6.9159E-4,5.5086E-4,6.1653E-4,7.1355E-4,7.6194E-4,6.9151E-4,5.5209E-4,6.1561E-4,7.1398E-4,7.6465E-4,6.9416E-4,5.4985E-4,6.1504E-4,7.1718E-4,7.6326E-4,6.9308E-4,5.4995E-4,6.1592E-4,7.1646E-4,7.6298E-4,6.926E-4,5.5435E-4,6.1523E-4,7.1345E-4,7.6275E-4,6.942E-4,5.5063E-4,6.1431E-4,7.1497E-4,7.6621E-4,6.9545E-4,5.5382E-4,6.122E-4,7.154E-4,7.6436E-4,6.9682E-4,5.5118E-4,6.1096E-4,7.1445E-4,7.6511E-4,6.9594E-4,5.5111E-4,6.1546E-4,7.1019E-4,7.6477E-4,6.9724E-4,5.5354E-4,6.1041E-4,7.1308E-4,7.6543E-4,6.982E-4,5.5389E-4,6.1131E-4,7.0875E-4,7.6514E-4,6.9686E-4,5.5375E-4,6.1249E-4,7.0815E-4,7.6468E-4,6.9857E-4,5.5472E-4,6.1083E-4,7.0835E-4,7.6641E-4,6.981E-4,5.5261E-4,6.1302E-4,7.0751E-4,7.66E-4,6.9796E-4,5.5296E-4,6.1135E-4,7.0721E-4,7.6492E-4,7.0344E-4,5.5745E-4,6.1026E-4,7.0926E-4,7.676E-4,7.0205E-4,5.5466E-4,6.127E-4,7.0592E-4,7.6756E-4,7.0336E-4,5.534E-4,6.1271E-4,7.0757E-4,7.6868E-4,7.0174E-4,5.5502E-4,6.1292E-4,7.0567E-4,7.684E-4,7.0423E-4,5.5562E-4,6.1031E-4,7.0544E-4,7.6949E-4,7.0627E-4,5.5602E-4,6.1056E-4,7.0506E-4,7.674E-4,7.0628E-4,5.5637E-4,6.0853E-4,7.0596E-4,7.6661E-4,7.0739E-4,5.5451E-4,6.0811E-4,7.0248E-4,7.6933E-4,7.0508E-4,5.576E-4,6.0818E-4,7.009E-4,7.6625E-4,7.0523E-4,5.5899E-4,6.0721E-4,7.0294E-4,7.6445E-4,7.0568E-4,5.5778E-4,6.0746E-4,7.051E-4,7.6808E-4,7.0793E-4,5.5579E-4,6.0505E-4,7.0193E-4,7.6955E-4,7.0804E-4,5.5845E-4,6.0681E-4,7.0013E-4,7.6519E-4,7.1015E-4,5.5814E-4,6.0743E-4,6.9976E-4,7.6761E-4,7.0977E-4,5.5743E-4,6.0514E-4,6.9876E-4,7.6744E-4,7.1072E-4,5.5946E-4,6.0579E-4,6.9896E-4,7.6785E-4,7.1134E-4,5.5964E-4,6.0549E-4,6.9825E-4,7.6559E-4,7.1051E-4,5.5839E-4,6.0442E-4,6.9964E-4,7.6895E-4,7.1211E-4,5.5855E-4,6.0551E-4,6.9646E-4,3.6635E-4:6
3.638E-14,5.8667E-7,5.8E-7,3.2667E-7,3.4667E-7,7.1E-7,7.7333E-7,7.5E-7,1.68E-6,1.5067E-6,8.6667E-8,7.1333E-7,1.2333E-7,4.6667E-7,1.6967E-6,1.3067E-6,6.4333E-7,1.6533E-6,1.2867E-6,1.1267E-6,2.5E-7,1.5197E-4,0.0013697,8.9369E-4,6.5204E-4,4.2135E-4,4.8061E-4,5.183E-4,5.4066E-4,4.7118E-4,3.9735E-4,4.0573E-4,4.9894E-4,5.2108E-4,4.5851E-4,3.9815E-4,3.994E-4,4.9784E-4,5.199E-4,4.5611E-4,3.9789E-4,3.9784E-4,4.9796E-4,5.2067E-4,4.6088E-4,3.9899E-4,3.9792E-4,4.975E-4,5.2118E-4,4.6008E-4,3.9982E-4,3.987E-4,5.0007E-4,5.2167E-4,4.606E-4,3.986E-4,3.9754E-4,4.9794E-4,5.2054E-4,4.6178E-4,3.9951E-4,3.9685E-4,4.9773E-4,5.221E-4,4.6437E-4,3.9953E-4,3.9777E-4,4.9778E-4,5.2339E-4,4.6242E-4,4.0232E-4,3.9848E-4,4.9788E-4,5.2156E-4,4.6323E-4,4.0165E-4,3.9732E-4,4.9952E-4,5.229E-4,4.6412E-4,4.0089E-4,3.9781E-4,4.9671E-4,5.2482E-4,4.6586E-4,4.029E-4,3.953E-4,4.9698E-4,5.2532E-4,4.6607E-4,4.0282E-4,3.9547E-4,4.9765E-4,5.2498E-4,4.661E-4,4.0265E-4,3.9573E-4,4.9636E-4,5.2442E-4,4.6588E-4,4.0198E-4,3.9603E-4,4.951E-4,5.2616E-4,4.6771E-4,4.0494E-4,3.9529E-4,4.9678E-4,5.2375E-4,4.6805E-4,4.0396E-4,3.9544E-4,4.9589E-4,5.2433E-4,4.6942E-4,4.036E-4,3.9475E-4,4.9549E-4,5.2589E-4,4.7008E-4,4.0418E-4,3.9374E-4,4.9516E-4,5.2429E-4,4.7058E-4,4.0449E-4,3.9393E-4,4.966E-4,5.2475E-4,4.7163E-4,4.0491E-4,3.9274E-4,4.9542E-4,5.2403E-4,4.6933E-4,4.0663E-4,3.9187E-4,4.936E-4,5.2644E-4,4.7276E-4,4.0614E-4,3.9223E-4,4.9461E-4,5.2464E-4,4.7137E-4,4.0698E-4,3.9212E-4,4.943E-4,5.2416E-4,4.7383E-4,4.0648E-4,3.9249E-4,4.9292E-4,5.2369E-4,4.7294E-4,4.071E-4,3.8994E-4,4.9241E-4,5.2602E-4,4.7363E-4,4.0699E-4,3.9147E-4,4.9306E-4,5.2346E-4,4.7463E-4,4.0709E-4,3.9017E-4,4.9243E-4,5.2494E-4,4.7602E-4,4.0872E-4,3.9136E-4,4.9053E-4,5.2462E-4,4.7761E-4,4.0911E-4,3.9045E-4,4.8997E-4,5.2452E-4,4.7743E-4,4.074E-4,3.89E-4,4.9081E-4,5.2711E-4,4.7822E-4,4.0856E-4,3.8924E-4,4.8992E-4,5.2412E-4,4.7684E-4,4.0952E-4,3.8739E-4,4.8846E-4,5.261E-4,4.7726E-4,4.0893E-4,3.8961E-4,4.8953E-4,5.2417E-4,4.7925E-4,4.0903E-4,3.8843E-4,4.8779E-4,5.2482E-4,4.798E-4,4.1116E-4,3.8895E-4,4.9028E-4,5.2581E-4,4.8319E-4,4.105E-4,3.8782E-4,4.8775E-4,5.2687E-4,4.8196E-4,4.1053E-4,3.8683E-4,4.8651E-4,5.2671E-4,4.8227E-4,4.0985E-4,3.8615E-4,4.8715E-4,5.2387E-4,4.8289E-4,4.1253E-4,3.8639E-4,4.8538E-4,5.2479E-4,4.8362E-4,4.1188E-4,3.8592E-4,4.8781E-4,5.2579E-4,4.8428E-4,4.1277E-4,3.8618E-4,4.8575E-4,5.2662E-4,4.841E-4,4.126E-4,3.8608E-4,4.8494E-4,5.2556E-4,4.8406E-4,4.1285E-4,3.8381E-4,4.8487E-4,5.2535E-4,4.861E-4,4.1486E-4,3.8749E-4,4.8315E-4,2.4746E-4:6
1.35E-6,1.2467E-6,1.56E-6,2.2E-7,8.3333E-7,4.7E-7,1.25E-6,1.2133E-6,4.7E-7,1.36E-6,8.8E-7,1.21E-6,7.5333E-7,1.2E-7,8.2E-7,1.5033E-6,1.1333E-6,1.4033E-6,5.1667E-7,2.7333E-7,1.04E-6,4.9667E-7,6.9667E-7,1.0433E-6,7.7E-7,5.8E-7,0.0011372,0.0010006,5.8533E-4,4.9732E-4,5.2732E-4,5.6396E-4,5.2032E-4,4.3268E-4,3.8466E-4,4.7034E-4,5.2069E-4,4.9334E-4,4.2247E-4,3.7807E-4,4.6609E-4,5.171E-4,4.9298E-4,4.2279E-4,3.7491E-4,4.6501E-4,5.1678E-4,4.9406E-4,4.2305E-4,3.7695E-4,4.6485E-4,5.1772E-4,4.9567E-4,4.2457E-4,3.7522E-4,4.6418E-4,5.1773E-4,4.9685E-4,4.237E-4,3.7511E-4,4.6492E-4,5.1651E-4,4.9844E-4,4.252E-4,3.765E-4,4.6309E-4,5.172E-4,4.9746E-4,4.251E-4,3.7477E-4,4.6423E-4,5.1767E-4,4.9903E-4,4.271E-4,3.7761E-4,4.6344E-4,5.1893E-4,4.9892E-4,4.2702E-4,3.7597E-4,4.6233E-4,5.1851E-4,4.988E-4,4.3031E-4,3.7569E-4,4.6152E-4,5.1658E-4,5.004E-4,4.2875E-4,3.7521E-4,4.5932E-4,5.1751E-4,5.0092E-4,4.3109E-4,3.7635E-4,4.594E-4,5.1661E-4,5.0268E-4,4.315E-4,3.7558E-4,4.599E-4,5.1889E-4,5.0196E-4,4.3161E-4,3.7477E-4,4.5834E-4,5.1851E-4,5.0098E-4,4.3143E-4,3.7642E-4,4.5766E-4,5.1788E-4,5.0303E-4,4.3369E-4,3.7629E-4,4.5769E-4,5.1941E-4,5.0646E-4,4.3295E-4,3.7617E-4,4.5735E-4,5.1744E-4,5.0404E-4,4.3394E-4,3.7528E-4,4.5663E-4,5.1698E-4,5.0564E-4,4.3626E-4,3.7475E-4,4.5511E-4,5.1644E-4,5.0555E-4,4.367E-4,3.7589E-4,4.5671E-4,5.1751E-4,5.0598E-4,4.3788E-4,3.7696E-4,4.5614E-4,5.1823E-4,5.0713E-4,4.3679E-4,3.7531E-4,4.56E-4,5.1821E-4,5.0699E-4,4.3846E-4,3.7505E-4,4.5544E-4,5.156E-4,5.0674E-4,4.3823E-4,3.7482E-4,4.5357E-4,5.1677E-4,5.0856E-4,4.3996E-4,3.7439E-4,4.5441E-4,5.1607E-4,5.0988E-4,4.3891E-4,3.7529E-4,4.515E-4,5.1483E-4,5.0885E-4,4.3924E-4,3.7317E-4,4.5292E-4,5.1472E-4,5.1043E-4,4.403E-4,3.7627E-4,4.5165E-4,5.1751E-4,5.1184E-4,4.4324E-4,3.7352E-4,4.5272E-4,5.1473E-4,5.1143E-4,4.4255E-4,3.7271E-4,4.507E-4,5.1343E-4,5.1105E-4,4.4331E-4,3.7422E-4,4.4905E-4,5.1471E-4,5.1162E-4,4.4573E-4,3.7509E-4,4.4791E-4,5.1207E-4,5.1291E-4,4.4573E-4,3.7423E-4,4.5128E-4,5.1487E-4,5.1081E-4,4.4741E-4,3.7428E-4,4.4921E-4,5.1349E-4,5.1198E-4,4.444E-4,3.7319E-4,4.4862E-4,5.1313E-4,5.135E-4,4.474E-4,3.7413E-4,4.4703E-4,5.1383E-4,5.1242E-4,4.4914E-4,3.7359E-4,4.4474E-4,5.1419E-4,5.1421E-4,4.4748E-4,3.7204E-4,4.4464E-4,3.1884E-4:6
-2.3667E-7,1.1733E-6,8.2333E-7,-4.4667E-7,1.41E-6,-7.3333E-7,1.0667E-6,8.7333E-7,-7.5667E-7,2.3867E-6,5.0667E-7,2.7967E-6,1.2867E-6,-6.7667E-7,1.1067E-6,-8.6667E-7,1.2033E-6,5.9E-7,-2.2E-7,1.5267E-6,7.4E-7,8.0667E-7,1.9333E-7,8.6667E-8,2.05E-6,7.3E-7,1.0733E-6,9.0667E-7,-1.1133E-6,6.6333E-7,-8.1667E-7,8.9993E-4,4.9623E-4,3.2424E-4,2.4212E-4,2.7189E-4,2.9544E-4,2.8095E-4,2.2835E-4,2.1172E-4,2.3694E-4,2.7972E-4,2.7369E-4,2.2262E-4,2.0961E-4,2.3556E-4,2.7937E-4,2.7379E-4,2.2362E-4,2.0976E-4,2.3432E-4,2.7863E-4,2.7546E-4,2.2294E-4,2.1046E-4,2.3452E-4,2.7784E-4,2.7737E-4,2.2551E-4,2.1139E-4,2.344E-4,2.7823E-4,2.7634E-4,2.2575E-4,2.1158E-4,2.3468E-4,2.7972E-4,2.7813E-4,2.2732E-4,2.113E-4,2.3306E-4,2.7951E-4,2.7936E-4,2.2769E-4,2.1299E-4,2.3294E-4,2.7854E-4,2.8053E-4,2.2795E-4,2.126E-4,2.3328E-4,2.8064E-4,2.8046E-4,2.2891E-4,2.1226E-4,2.3204E-4,2.7946E-4,2.813E-4,2.3009E-4,2.122E-4,2.3258E-4,2.7826E-4,2.8157E-4,2.3046E-4,2.1324E-4,2.3171E-4,2.8016E-4,2.8118E-4,2.3091E-4,2.1443E-4,2.3128E-4,2.7818E-4,2.8303E-4,2.31E-4,2.1411E-4,2.3027E-4,2.7927E-4,2.838E-4,2.3223E-4,2.139E-4,2.3063E-4,2.8036E-4,2.8209E-4,2.343E-4,2.1427E-4,2.3014E-4,2.7945E-4,2.8296E-4,2.3285E-4,2.1504E-4,2.2894E-4,2.7989E-4,2.8347E-4,2.3524E-4,2.1364E-4,2.2959E-4,2.7781E-4,2.8414E-4,2.3546E-4,2.136E-4,2.2863E-4,2.7887E-4,2.8457E-4,2.3611E-4,2.141E-4,2.2852E-4,2.7759E-4,2.839E-4,2.3732E-4,2.1503E-4,2.2842E-4,2.7886E-4,2.849E-4,2.3764E-4,2.1574E-4,2.2885E-4,2.7695E-4,2.87E-4,2.3873E-4,2.1564E-4,2.2721E-4,2.7704E-4,2.8543E-4,2.3855E-4,2.1619E-4,2.2544E-4,2.7705E-4,2.8745E-4,2.3959E-4,2.157E-4,2.2638E-4,2.7768E-4,2.8639E-4,2.406E-4,2.1476E-4,2.254E-4,2.7687E-4,2.8689E-4,2.4081E-4,2.1566E-4,2.2433E-4,2.7732E-4,2.8689E-4,2.422E-4,2.1561E-4,2.2458E-4,2.7692E-4,2.8654E-4,2.44E-4,2.1587E-4,2.2407E-4,2.772E-4,2.8777E-4,2.4244E-4,2.1627E-4,2.2291E-4,2.7587E-4,2.8715E-4,2.4338E-4,2.176E-4,2.2409E-4,2.7586E-4,2.8797E-4,2.4507E-4,2.1688E-4,2.2343E-4,2.7638E-4,2.9042E-4,2.4557E-4,2.1637E-4,2.2199E-4,2.7551E-4,2.8931E-4,2.4622E-4,2.1749E-4,2.2159E-4,2.7516E-4,2.8782E-4,2.4766E-4,2.1843E-4,2.2281E-4,2.7399E-4,2.8737E-4,2.4811E-4,2.167E-4,2.2229E-4,2.7456E-4,2.889E-4,2.4867E-4,2.178E-4,2.2184E-4,2.7309E-4,2.8907E-4,2.4978E-4,2.1834E-4,2.2099E-4,2.7314E-4,2.8883E-4,2.5019E-4,2.1846E-4,2.2005E-4,2.7249E-4,2.894E-4,2.5102E-4,2.1789E-4,2.1945E-4,2.7309E-4,2.8902E-4,2.5238E-4,2.1936E-4,2.1927E-4,2.7184E-4,2.9012E-4,2.5188E-4,2.2005E-4,2.1861E-4,2.7284E-4,2.9038E-4,2.5212E-4,2.186E-4,2.1891E-4,2.7341E-4,2.8962E-4,2.5419E-4,2.1866E-4,2.173E-4,2.7166E-4,2.8961E-4,2.538E-4,2.202E-4,2.1664E-4,2.7054E-4,2.901E-4,2.5494E-4,2.2058E-4,2.1702E-4,2.6997E-4,2.8997E-4,2.5589E-4,2.2007E-4,2.1707E-4,2.7038E-4,2.903E-4,2.5627E-4,2.2044E-4,2.1715E-4,2.6954E-4,2.8887E-4,2.5714E-4,2.2175E-4,2.1631E-4,2.6967E-4,2.9081E-4,2.5769E-4,2.2066E-4,2.1696E-4,2.6937E-4,2.9087E-4,2.5878E-4,2.2255E-4,2.1603E-4,2.6981E-4,2.9009E-4,2.6023E-4,2.2285E-4,2.159E-4,2.6706E-4,2.8978E-4,2.5972E-4,2.2143E-4,2.153E-4,2.6934E-4,2.9127E-4,2.6079E-4,2.2095E-4,2.1481E-4,2.6869E-4,2.8852E-4,2.6099E-4,2.2266E-4,2.1416E-4,2.6735E-4,2.8896E-4,2.6156E-4,2.2242E-4,2.1439E-4,2.6786E-4,2.8967E-4,2.6235E-4,2.2333E-4,2.1351E-4,2.6783E-4,2.8869E-4,2.6387E-4,2.2348E-4,2.1424E-4,2.6557E-4,2.8846E-4,2.6217E-4,2.2349E-4,2.1328E-4,2.6633E-4,2.9012E-4,2.6437E-4,2.2354E-4,2.1257E-4,2.6514E-4,2.8895E-4,2.6412E-4,2.2403E-4,2.1239E-4,2.6467E-4,2.8847E-4,2.654E-4,2.2496E-4,2.1175E-4,2.0698E-4:6
4.1333E-7,8.4333E-7,1.7867E-6,-4.7E-7,4.5667E-7,6.2E-7,7.1333E-7,1.1967E-6,6.6E-7,1.5467E-6,6.2333E-7,4.3333E-8,7.6667E-7,-5.2667E-7,1.09E-6,6.6333E-7,1.52E-6,8.2E-7,-9.5E-7,7.8667E-7,1.0E-8,1.1833E-6,5.2E-7,-1.0667E-7,2.9667E-7,2.3333E-8,1.08E-6,7.7667E-7,3.1E-7,1.1633E-6,-5.2E-7,1.0333E-6,1.7067E-6,-2.7667E-7,1.43E-6,4.8E-7,6.9667E-7,1.04E-6,5.3667E-7,6.4333E-7,-2.1667E-7,1.1667E-6,7.7667E-7,-2.3E-7,2.2333E-7,-5.6667E-8,1.1833E-6,7.7667E-7,-4.7E-7,7.8667E-7,1.9653E-4,7.4808E-4,4.9105E-4,3.5742E-4,2.198E-4,2.726E-4,2.8401E-4,2.9073E-4,2.6051E-4,2.0661E-4,2.3695E-4,2.7393E-4,2.8529E-4,2.5591E-4,2.051E-4,2.3426E-4,2.7073E-4,2.8638E-4,2.5453E-4,2.0603E-4,2.3414E-4,2.7176E-4,2.8625E-4,2.5679E-4,2.0752E-4,2.322E-4,2.708E-4,2.8545E-4,2.5871E-4,2.0738E-4,2.3238E-4,2.7137E-4,2.8617E-4,2.5846E-4,2.088E-4,2.3209E-4,2.7157E-4,2.8784E-4,2.6169E-4,2.0826E-4,2.3261E-4,2.7009E-4,2.8873E-4,2.6151E-4,2.0868E-4,2.311E-4,2.7022E-4,2.8814E-4,2.6211E-4,2.0951E-4,2.316E-4,2.7019E-4,2.8766E-4,2.6301E-4,2.0932E-4,2.3214E-4,2.7014E-4,2.8876E-4,2.6379E-4,2.0945E-4,2.3121E-4,2.6976E-4,2.9096E-4,2.6535E-4,2.0944E-4,2.3108E-4,2.6929E-4,2.9044E-4,2.6705E-4,2.1022E-4,2.3109E-4,2.69E-4,2.9146E-4,2.6765E-4,2.1079E-4,2.3086E-4,2.6802E-4,2.9173E-4,2.6791E-4,2.1251E-4,2.3014E-4,2.6783E-4,2.9155E-4,2.6797E-4,2.1212E-4,2.2953E-4,2.6686E-4,2.9148E-4,2.706E-4,2.1294E-4,2.2978E-4,2.6609E-4,2.9063E-4,2.712E-4,2.1247E-4,2.2839E-4,2.6623E-4,2.9019E-4,2.7158E-4,2.1345E-4,2.2786E-4,2.6556E-4,2.9142E-4,2.7152E-4,2.1335E-4,2.2737E-4,2.6415E-4,2.9118E-4,2.714E-4,2.132E-4,2.2486E-4,2.6195E-4,2.8717E-4,2.6995E-4,2.1185E-4,2.2428E-4,2.605E-4,2.8806E-4,2.7226E-4,2.1193E-4,2.2366E-4,2.5953E-4,2.8847E-4,2.7139E-4,2.1292E-4,2.2249E-4,2.5952E-4,2.8639E-4,2.7354E-4,2.1331E-4,2.233E-4,2.5784E-4,2.8879E-4,2.7462E-4,2.1645E-4,2.2651E-4,2.6224E-4,2.9223E-4,2.7779E-4,2.1681E-4,2.2508E-4,2.5982E-4,2.9131E-4,2.7817E-4,2.1724E-4,2.2523E-4,2.6067E-4,2.9159E-4,2.7936E-4,2.1728E-4,2.2513E-4,2.5967E-4,2.9157E-4,2.7975E-4,2.1783E-4,2.2466E-4,2.5823E-4,2.9118E-4,2.802E-4,2.1846E-4,2.2318E-4,2.5763E-4,2.9245E-4,2.7983E-4,2.2048E-4,2.2414E-4,2.573E-4,2.8988E-4,2.8133E-4,2.1887E-4,2.2367E-4,2.57E-4,2.9099E-4,2.815E-4,2.1954E-4,2.2193E-4,2.5491E-4,2.9024E-4,2.828E-4,2.1971E-4,2.2402E-4,2.5536E-4,2.92E-4,2.8258E-4,2.2137E-4,2.211E-4,2.5477E-4,2.9132E-4,2.8449E-4,2.2107E-4,2.221E-4,2.5363E-4,2.9079E-4,2.8567E-4,2.2187E-4,2.2251E-4,2.5386E-4,2.9117E-4,2.8728E-4,2.231E-4,2.2268E-4,2.5253E-4,2.913E-4,2.8615E-4,2.2324E-4,2.2114E-4,2.5197E-4,2.9075E-4,2.8684E-4,2.2484E-4,2.2264E-4,2.5142E-4,2.8965E-4,2.8731E-4,2.2435E-4,2.2157E-4,2.5005E-4,2.9043E-4,2.8804E-4,2.2637E-4,2.2276E-4,2.4904E-4,2.9113E-4,2.8912E-4,2.2572E-4,2.2217E-4,2.4945E-4,2.8926E-4,2.894E-4,2.2741E-4,2.22E-4,2.47E-4,2.8884E-4,2.8925E-4,2.2821E-4,2.2157E-4,2.4692E-4,2.9002E-4,2.9085E-4,2.2756E-4,2.2126E-4,2.4547E-4,2.8979E-4,2.9072E-4,2.2888E-4,2.2127E-4,2.453E-4,2.8989E-4,2.9144E-4,2.2851E-4,2.2064E-4,2.4608E-4,2.8757E-4,2.9243E-4,2.2902E-4,2.205E-4,2.4421E-4,2.8812E-4,2.9285E-4,2.3104E-4,2.2029E-4,2.4454E-4,2.8798E-4,2.9276E-4,2.3151E-4,2.2072E-4,2.4295E-4,2.8913E-4,2.9375E-4,2.3194E-4,2.1994E-4,2.4183E-4,2.8792E-4,2.9416E-4,2.3324E-4,2.2162E-4,2.4216E-4,2.8721E-4,2.9454E-4,2.33E-4,2.2002E-4,2.4194E-4,2.8731E-4,2.9464E-4,2.3408E-4,2.2032E-4,2.3986E-4,2.8763E-4,2.945E-4,2.3523E-4,2.1957E-4,2.398E-4,2.8765E-4,2.9355E-4,2.3582E-4,2.1946E-4,2.4046E-4,2.8531E-4,2.9486E-4,2.3616E-4,2.2057E-4,2.3891E-4,2.866E-4,2.9558E-4,2.381E-4,2.191E-4,2.3804E-4,2.8563E-4,2.9641E-4,2.3654E-4,2.2087E-4,2.3581E-4,2.8703E-4,2.9735E-4,2.3844E-4,2.1998E-4,2.3617E-4,2.8491E-4,2.9646E-4,2.3938E-4,2.2074E-4,2.3548E-4,2.8478E-4,2.9762E-4,2.3945E-4,2.2044E-4,2.3517E-4,2.8338E-4,2.9798E-4,2.411E-4,2.2118E-4,2.3493E-4,2.8441E-4,2.9782E-4,2.4083E-4,2.2037E-4,2.0533E-4:6
9.1333E-7,-2.1E-7,1.15E-6,1.2633E-6,-2.0667E-7,9.2667E-7,8.3333E-8,8.6667E-7,1.83E-6,-6.6667E-9,2.6667E-7,-3.6333E-7,1.21E-6,1.16E-6,3.6333E-7,1.17E-6,-3.8E-7,1.0167E-6,2.0667E-6,-4.4E-7,1.21E-6,1.49E-6,9.4667E-7,7.2667E-7,7.9667E-7,1.0767E-6,7.7667E-7,1.0133E-6,-7.0E-8,-4.5667E-7,6.4695E-4,5.7314E-4,3.6968E-4,3.5451E-4,2.9412E-4,2.0505E-4,2.5987E-4,2.82E-4,2.8337E-4,2.518E-4,2.0476E-4,2.4119E-4,2.7904E-4,2.8442E-4,2.4921E-4,2.0496E-4,2.3984E-4,2.7724E-4,2.8334E-4,2.4903E-4,2.0529E-4,2.3969E-4,2.7778E-4,2.8326E-4,2.5068E-4,2.0758E-4,2.3883E-4,2.7747E-4,2.8435E-4,2.5104E-4,2.0633E-4,2.3722E-4,2.7662E-4,2.8497E-4,2.5102E-4,2.0524E-4,2.3737E-4,2.7705E-4,2.8624E-4,2.5449E-4,2.0607E-4,2.374E-4,2.7641E-4,2.8782E-4,2.5414E-4,2.0833E-4,2.3618E-4,2.7557E-4,2.8691E-4,2.5587E-4,2.0756E-4,2.3677E-4,2.745E-4,2.8799E-4,2.5692E-4,2.0778E-4,2.3627E-4,2.7653E-4,2.8876E-4,2.5658E-4,2.0816E-4,2.3546E-4,2.7568E-4,2.8862E-4,2.5802E-4,2.0841E-4,2.3454E-4,2.7422E-4,2.8966E-4,2.5829E-4,2.0938E-4,2.3508E-4,2.7411E-4,2.8952E-4,2.6089E-4,2.0902E-4,2.3357E-4,2.729E-4,2.8903E-4,2.6045E-4,2.0963E-4,2.334E-4,2.7416E-4,2.9013E-4,2.6134E-4,2.1056E-4,2.3256E-4,2.7266E-4,2.8993E-4,2.6261E-4,2.0942E-4,2.3371E-4,2.7236E-4,2.9023E-4,2.6396E-4,2.1113E-4,2.3352E-4,2.7141E-4,2.895E-4,2.6586E-4,2.1052E-4,2.3317E-4,2.6972E-4,2.9189E-4,2.6639E-4,2.1169E-4,2.3186E-4,2.7127E-4,2.9145E-4,2.6656E-4,2.1143E-4,2.3176E-4,2.6934E-4,2.9163E-4,2.6542E-4,2.1124E-4,2.305E-4,2.6969E-4,2.9226E-4,2.6783E-4,2.128E-4,2.3171E-4,2.6988E-4,2.9141E-4,2.6927E-4,2.1284E-4,2.3101E-4,2.6918E-4,2.9045E-4,2.6984E-4,2.1311E-4,2.3125E-4,2.7004E-4,2.9153E-4,2.7053E-4,2.1235E-4,2.2932E-4,2.6937E-4,2.914E-4,2.7215E-4,2.1386E-4,2.2851E-4,2.6688E-4,2.9185E-4,2.7237E-4,2.1364E-4,2.2821E-4,2.6628E-4,2.918E-4,2.73E-4,2.1408E-4,2.2767E-4,2.6584E-4,2.9243E-4,2.7347E-4,2.1347E-4,2.2775E-4,2.6548E-4,2.9171E-4,2.7525E-4,2.1442E-4,2.2782E-4,2.6489E-4,2.9214E-4,2.7517E-4,2.1594E-4,2.2766E-4,2.6454E-4,2.9216E-4,2.7589E-4,2.1612E-4,2.2596E-4,2.6419E-4,2.9277E-4,2.7759E-4,2.1715E-4,2.2687E-4,2.63E-4,2.9307E-4,2.7773E-4,2.176E-4,2.2646E-4,2.6369E-4,2.9208E-4,2.7918E-4,2.1782E-4,2.2528E-4,2.6217E-4,2.932E-4,2.7954E-4,2.1743E-4,2.2633E-4,2.6111E-4,2.9159E-4,2.7933E-4,2.1828E-4,2.2514E-4,2.5955E-4,2.9315E-4,2.7909E-4,2.1942E-4,2.245E-4,2.5913E-4,2.9181E-4,2.8035E-4,2.1881E-4,2.2546E-4,2.598E-4,2.9213E-4,2.7922E-4,2.1868E-4,2.2466E-4,2.5753E-4,2.9173E-4,2.8283E-4,2.2023E-4,2.2398E-4,2.579E-4,2.9153E-4,2.8319E-4,2.2075E-4,2.2452E-4,2.5808E-4,2.9256E-4,2.8254E-4,2.2134E-4,2.2148E-4,2.5675E-4,2.9113E-4,2.8329E-4,2.2185E-4,2.2405E-4,2.5498E-4,2.9178E-4,2.8424E-4,2.2321E-4,2.2248E-4,2.5505E-4,2.9081E-4,2.8558E-4,2.2358E-4,2.2258E-4,2.5474E-4,2.9151E-4,2.8549E-4,2.2404E-4,2.2334E-4,2.5454E-4,2.9138E-4,2.8428E-4,2.2313E-4,2.2135E-4,2.5311E-4,2.9132E-4,2.8687E-4,2.2422E-4,2.212E-4,2.5342E-4,2.9052E-4,2.854E-4,2.2435E-4,2.2227E-4,2.5331E-4,2.9048E-4,2.8813E-4,2.2458E-4,2.2223E-4,2.5228E-4,2.9074E-4,2.8846E-4,2.2573E-4,2.219E-4,2.5055E-4,2.9099E-4,2.8893E-4,2.2781E-4,2.2116E-4,2.4966E-4,2.9023E-4,2.899E-4,2.2631E-4,2.2268E-4,2.4981E-4,2.8973E-4,2.8916E-4,2.2895E-4,2.2127E-4,2.4743E-4,2.9126E-4,2.9109E-4,2.2846E-4,2.2088E-4,2.4751E-4,2.9155E-4,2.9104E-4,2.2973E-4,2.2129E-4,2.4708E-4,2.8916E-4,2.9187E-4,2.2971E-4,2.2141E-4,2.4795E-4,1.551E-4:6
0.0012447,-8.3728E-4,-0.0024855,0.0019096,-0.0036442,0.0015522,-7.6476E-4,-0.0020268,0.0016738,-0.0031471,0.0016027,-0.0020202,-0.0024333,0.0013366,-0.0031166,0.0020323,-4.8488E-4,-0.0018396,0.0012818,-0.0032945,0.0018022,-0.0013588,-0.0022415,0.0014168,-0.0022792,0.0013808,1.6135,1.4325,0.777,0.69746,0.67089,0.73567,0.66991,0.51728,0.48969,0.55687,0.63098,0.60374,0.48651,0.46229,0.53953,0.61349,0.59244,0.47978,0.45745,0.53483,0.6112,0.589,0.47829,0.46308,0.54127,0.6176,0.59411,0.48264,0.46698,0.5456,0.62227,0.59723,0.48379,0.46316,0.54241,0.61882,0.59392,0.48197,0.4629,0.54201,0.61778,0.59236,0.48018,0.46217,0.54134,0.61832,0.59081,0.47852,0.46111,0.5416,0.61717,0.58912,0.4778,0.46085,0.54109,0.61613,0.58839,0.47676,0.4607,0.54102,0.61597,0.58694,0.47588,0.46078,0.54205,0.61472,0.58548,0.47509,0.46105,0.54244,0.61545,0.58508,0.4744,0.46209,0.54253,0.61593,0.58444,0.47346,0.46103,0.54273,0.61579,0.58423,0.47266,0.46114,0.54327,0.61617,0.58245,0.47295,0.4609,0.54423,0.61613,0.5812,0.47176,0.46099,0.54419,0.61595,0.58057,0.47122,0.46206,0.5449,0.61544,0.57931,0.4702,0.46146,0.5455,0.61633,0.57989,0.46979,0.46245,0.54526,0.61543,0.57889,0.46946,0.46224,0.54668,0.61518,0.57852,0.46813,0.46254,0.54636,0.61577,0.57761,0.46815,0.46347,0.54662,0.61604,0.57609,0.46777,0.4632,0.547,0.61744,0.57596,0.46641,0.46256,0.54826,0.61616,0.57509,0.46692,0.46334,0.54883,0.61633,0.57404,0.46601,0.46385,0.54993,0.61604,0.57254,0.46558,0.46382,0.55042,0.61561,0.57235,0.46498,0.46378,0.55152,0.61748,0.57136,0.4643,0.46466,0.55184,0.61553,0.57049,0.46357,0.46434,0.5521,0.61707,0.56856,0.46312,0.4656,0.55228,0.6171,0.56889,0.46249,0.46523:6
-1.77E-4,-0.0024937,0.0019289,-0.0024401,0.0011372,-2.9625E-4,-0.0019015,0.0020763,-0.0033585,0.0015931,-0.0012429,-0.0022458,0.0026758,-0.0033592,0.0015568,-9.8204E-4,-0.0016243,0.0015124,-0.0029085,0.0010821,-0.0014878,-0.0020505,0.0022308,-0.0030741,0.0012701,1.1982E-4,-0.0019802,1.904,1.4035,0.9132,1.0779,0.97785,0.66776,0.71296,0.74908,0.8379,0.75487,0.5948,0.60131,0.69975,0.77804,0.71262,0.57413,0.57442,0.68371,0.75897,0.69549,0.56604,0.57188,0.67968,0.75498,0.68958,0.56162,0.57019,0.67768,0.75172,0.6851,0.55775,0.56958,0.67678,0.74959,0.67898,0.55521,0.56778,0.67758,0.74772,0.6756,0.55375,0.56852,0.67857,0.7467,0.67186,0.55168,0.56797,0.67814,0.74561,0.66842,0.54978,0.56928,0.68018,0.74427,0.66521,0.54727,0.57008,0.68195,0.74298,0.66194,0.54651,0.57109,0.68313,0.74327,0.65968,0.5453,0.57246,0.6837,0.74162,0.65722,0.54449,0.57259,0.68608,0.74244,0.65391,0.54262,0.57421,0.6857,0.74153,0.65098,0.54225,0.57481,0.68745,0.74127,0.64754,0.54125,0.57665,0.68889,0.73989,0.6458,0.54096,0.57752,0.69008,0.73939,0.64445,0.53881,0.57958,0.69176,0.74008,0.64056,0.53913,0.58039,0.69322,0.73786,0.63776,0.53731,0.58272,0.69476,0.73874,0.63566,0.53752,0.58305,0.69575,0.73652,0.63329,0.5364,0.5845,0.69729,0.7359,0.63079,0.5365,0.58637,0.69858,0.73607,0.62899,0.53533,0.58798,0.70072,0.73449,0.62622,0.53565,0.58998,0.70269,0.73341,0.62473,0.53541,0.59223,0.70374,0.73233,0.62144,0.53357,0.59344,0.70575,0.73257,0.61996,0.53409,0.5951,0.70666,0.73147,0.61742,0.53399,0.59714,0.70747,0.73061,0.61514,0.53362,0.59798,0.70837,0.73026,0.61351,0.53456,0.60067,0.7115,0.72933,0.6113,0.53446,0.60162,0.7131,0.72682,0.6093,0.53436,0.604,0.71347:6
-0.01545,0.01488,-0.016919,-0.0010778,0.0053404,-0.014243,0.010564,-0.017544,0.0037588,0.0035519,-0.016284,0.011231,-0.0092417,-0.0062147,0.0072606,-0.018476,0.010532,-0.016573,4.7683E-4,0.0044541,-0.018313,0.0080019,-0.015865,-3.1483E-4,0.0077896,-0.014415,0.012773,-0.014963,-0.00127,0.0024879,-0.01357,0.012613,-0.013258,-0.0092893,0.0076633,-0.022493,0.01522,4.2917,10.709,5.9492,4.7733,3.2443,4.2151,4.2375,3.6813,3.0672,2.8876,3.4538,3.8668,3.4837,2.8938,2.8503,3.3738,3.8117,3.4774,2.8804,2.844,3.3547,3.8115,3.4846,2.8777,2.8491,3.3546,3.8141,3.4817,2.8814,2.8471,3.3445,3.8221,3.4916,2.8872,2.8404,3.3474,3.815,3.4915,2.8887,2.8375,3.3473,3.814,3.4939,2.8905,2.8383,3.3454,3.8133,3.5034,2.9031,2.8342,3.3421,3.8044,3.5129,2.896,2.8341,3.3381,3.7976,3.5219,2.9033,2.8251,3.3357,3.7884,3.5215,2.9034,2.8304,3.3391,3.7909,3.5315,2.902,2.8287,3.3277,3.7898,3.5353,2.9067,2.83,3.3203,3.8001,3.5456,2.9182,2.8317,3.3216,3.7984,3.5416,2.9161,2.8231,3.3135,3.8025,3.5514,2.9232,2.8252,3.316,3.8036,3.544,2.9323,2.8193,3.3101,3.8023,3.554,2.9332,2.8202,3.3117,3.8017,3.5647,2.9386,2.8131,3.3139,3.7928,3.575,2.9367,2.8089,3.304,3.7897,3.5752,2.9407,2.8162,3.3053,3.7851,3.5824,2.9439,2.816,3.3018,3.7801,3.583,2.9446,2.8177,3.2914,3.7787,3.5884,2.945,2.8171,3.2877,3.788,3.5939,2.9519,2.8183,3.2869,3.7894,3.5912,2.9577,2.8115,3.278,3.789,3.5968,2.9629,2.8089,3.2823,3.7885,3.5939,2.9674,2.8051,3.2827,3.7846,3.5985,2.973,2.8062,3.2816,3.7845,3.6059,2.972,2.8048,3.2828,3.7775,3.6127:6
-0.0074214,-0.012206,0.017609,-0.016028,0.0011953,-0.0074055,-0.01316,0.011708,-0.016844,0.0063682,-0.0018239,-0.012812,0.012234,-0.017008,0.0098649,-0.0025989,-0.011643,0.010331,-0.022545,2.4922,12.432,5.8435,4.5828,3.4028,4.2565,4.1508,3.5622,2.9635,2.9278,3.5408,3.7599,3.3819,2.8099,2.8825,3.4659,3.7335,3.3635,2.8091,2.8756,3.4534,3.7316,3.3642,2.7996,2.8659,3.4483,3.7349,3.3702,2.8114,2.861,3.4565,3.7325,3.3647,2.8121,2.8615,3.4675,3.7268,3.3669,2.8152,2.8617,3.4678,3.7291,3.3816,2.8165,2.8641,3.4695,3.724,3.389,2.8148,2.8644,3.4676,3.7225,3.3901,2.8138,2.874,3.4646,3.7305,3.3968,2.8158,2.8764,3.4559,3.732,3.3949,2.8143,2.8704,3.4527,3.7473,3.3914,2.8126,2.8691,3.4501,3.7503,3.3977,2.8168,2.8603,3.4553,3.7522,3.3929,2.8235,2.868,3.4514,3.7535,3.3944,2.8321,2.8642,3.4584,3.7522,3.4034,2.8334,2.86,3.4616,3.7538,3.3994,2.8313,2.8559,3.4643,3.7371,3.4073,2.8286,2.8595,3.4694,3.7377,3.413,2.8301,2.8631,3.4629,3.7369,3.4131,2.8258,2.864,3.4506,3.745,3.4197,2.8253,2.8682,3.4538,3.7481,3.4149,2.8274,2.8638,3.4441,3.7513,3.4123,2.8233,2.8666,3.4373,3.7617,3.4129,2.827,2.8639,3.4415,3.7572,3.4126,2.8324,2.8577,3.4436,3.7613,3.4145,2.8428,2.8549,3.4499,3.7572,3.4204,2.8364,2.8527,3.4548,3.754,3.4287,2.8404,2.8584,3.4568,3.7578,3.4345,2.8363,2.8595,3.456,3.7453,3.4413,2.835,2.8565,3.4522,3.7438,3.4443,2.8362,2.8605,3.4453,3.7529,3.4413,2.8373,2.863,3.4466,3.7608,3.4345,2.8458,2.858,3.4378,3.7649,3.4403,2.8432,2.8573,3.4373:6
-0.019534,0.014617,-0.014557,-0.0020398,-5.2273E-4,-0.018324,0.011939,-0.016808,6.2044E-5,0.0037882,-0.01435,0.012777,-0.013239,-1.6375E-4,0.0027452,-0.023047,0.014132,-0.023001,-0.0027306,0.0069202,-0.019584,0.01477,-0.015949,12.201,7.0811,4.5858,3.7008,4.1409,4.243,3.785,3.0263,2.9112,3.4335,3.7791,3.5302,2.8833,2.8291,3.3625,3.7332,3.5105,2.8584,2.8319,3.3555,3.7269,3.5136,2.858,2.8317,3.3439,3.7317,3.505,2.8552,2.8379,3.3415,3.7567,3.5078,2.8553,2.8347,3.3436,3.7612,3.5029,2.8544,2.8423,3.3405,3.7601,3.4998,2.8617,2.8388,3.3428,3.7736,3.4944,2.8658,2.844,3.3479,3.7685,3.4922,2.8665,2.8305,3.3609,3.7638,3.4945,2.8681,2.8334,3.3659,3.7576,3.5017,2.8613,2.8387,3.3689,3.7492,3.5069,2.8622,2.8381,3.3673,3.7509,3.5105,2.8587,2.8461,3.3641,3.7585,3.5098,2.8534,2.8512,3.3594,3.7662,3.5109,2.8541,2.8509,3.3562,3.7741,3.5083,2.8579,2.855,3.3532,3.7866,3.4975,2.8597,2.8534,3.361,3.7872,3.4969,2.8604,2.8526,3.369,3.7892,3.492,2.8638,2.8462,3.3734,3.7802,3.4872,2.8601,2.8488,3.3824,3.7765,3.4957,2.8625,2.85,3.3884,3.7674,3.5019,2.8604,2.8485,3.3884,3.7728,3.5052,2.8499,2.8643,3.3938,3.7721,3.5028,2.8506,2.8685,3.3797,3.7774,3.5011,2.8458,2.8644,3.3728,3.7848,3.4961,2.8475,2.869,3.3768,3.7971,3.4903,2.8496,2.8676,3.3732,3.8011,3.4791,2.854,2.8693,3.3849,3.8012,3.482,2.8602,2.8637,3.3938,3.7946,3.4762,2.857,2.8612,3.4019,3.7877,3.4819,2.8603,2.8588,3.4048,3.782,3.4921,2.8586,2.8654,3.4067,3.7745,3.4941,2.8424,2.8727,3.4067,3.7785,3.4957:6
0.0056299,-0.0050099,0.025421,-0.018199,0.020641,0.0072522,-0.0096435,0.026382,-0.012138,0.027631,0.0060825,-0.0079566,0.02513,-0.017655,0.020172,0.0067798,-0.0055406,0.023439,-0.01591,0.017492,0.0088537,-0.0081177,0.020719,15.388,16.311,11.45,8.8179,6.701,5.7672,6.749,6.9949,6.4066,5.1432,4.9367,5.8575,6.362,6.0104,4.9013,4.7479,5.6808,6.2318,5.9292,4.8523,4.7089,5.6374,6.2023,5.9344,4.8461,4.6862,5.6159,6.2068,5.9397,4.8525,4.6862,5.5984,6.201,5.952,4.8672,4.6725,5.5957,6.2012,5.9584,4.8767,4.6693,5.5792,6.1938,5.9769,4.8933,4.6563,5.5738,6.2057,5.9879,4.8984,4.6605,5.5611,6.1996,6.0075,4.9116,4.6557,5.5522,6.1938,6.0139,4.9217,4.6493,5.5409,6.1966,6.0334,4.934,4.6502,5.5258,6.1943,6.0354,4.9407,4.6433,5.5144,6.1865,6.0542,4.9613,4.6392,5.5171,6.1935,6.0697,4.9675,4.6353,5.5095,6.1746,6.073,4.975,4.6274,5.4803,6.1836,6.0799,4.9867,4.6261,5.4746,6.1793,6.0971,4.9881,4.6215,5.467,6.1754,6.1076,5.0076,4.6214,5.4509,6.1679,6.1173,5.0216,4.6163,5.4418,6.1685,6.1326,5.0353,4.6155,5.4241,6.1553,6.1385,5.0501,4.6084,5.416,6.1605,6.1541,5.0539,4.6088,5.4038,6.154,6.1569,5.0659,4.6077,5.3952,6.1396,6.1709,5.0799,4.6098,5.3775,6.141,6.1779,5.0943,4.5942,5.3802,6.1331,6.1888,5.1091,4.605,5.3588,6.1322,6.1966,5.1186,4.5933,5.3521,6.1282,6.2012,5.1367,4.5995,5.3381,6.1108,6.2063,5.1499,4.5981,5.3232,6.1183,6.2178,5.1642,4.593,5.3189,6.1095,6.2278,5.1735,4.592,5.295,6.105,6.2229,5.1903,4.5979,5.2863,6.1015,6.2388,5.2089,4.5905,5.2728:6
-0.019935,0.030523,-0.0087438,0.013074,0.011769,-0.016332,0.031858,-0.010232,0.010882,0.012886,-0.017527,12.097,16.863,12.224,9.4585,6.8116,6.0002,6.6362,7.1749,6.6784,5.3173,4.9948,5.7719,6.5103,6.2352,5.0515,4.8087,5.5936,6.3635,6.1507,5.0052,4.7605,5.5475,6.341,6.1477,4.992,4.7514,5.5294,6.3238,6.1523,4.9991,4.7437,5.5256,6.3224,6.1517,5.0102,4.7465,5.5121,6.319,6.1567,5.0126,4.7391,5.5066,6.3148,6.1643,5.0249,4.7363,5.4943,6.3034,6.1657,5.0268,4.7374,5.486,6.3116,6.1783,5.0328,4.7349,5.483,6.2961,6.1854,5.0402,4.7235,5.4688,6.2999,6.1869,5.0553,4.7239,5.4625,6.288,6.1978,5.0559,4.7277,5.4541,6.2998,6.2076,5.0615,4.7284,5.4436,6.2869,6.2136,5.0681,4.7168,5.4293,6.2826,6.2164,5.0758,4.7169,5.4275,6.279,6.2309,5.0837,4.7136,5.4188,6.2816,6.2347,5.0874,4.7106,5.4122,6.2698,6.2292,5.0985,4.7095,5.4116,6.2703,6.2483,5.1081,4.711,5.3954,6.2609,6.2467,5.1186,4.7033,5.398,6.2582,6.2545,5.1271,4.7112,5.377,6.2583,6.2646,5.1333,4.7034,5.3744,6.2497,6.2636,5.1449,4.7008,5.3652,6.2509,6.2758,5.1471,4.6998,5.3561,6.2395,6.2735,5.1632,4.696,5.3535,6.2399,6.2826,5.1642,4.6958,5.3486,6.2385,6.2831,5.1796,4.6936,5.334,6.2231,6.2931,5.187,4.6934,5.3289,6.2285,6.2897,5.1996,4.6939,5.3277,6.2216,6.3015,5.2059,4.6973,5.314,6.2202,6.2926,5.2071,4.6929,5.309,6.2103,6.3108,5.2213,4.6924,5.3012,6.2106,6.3071,5.2259,4.6951,5.2968,6.2051,6.3105,5.2384,4.6927,5.2819,6.2073,6.3243,5.2487,4.696,5.28,6.1943,6.3166:6
-0.012479,0.028763,-0.012887,0.010234,0.0098267,-0.012033,0.02511,-0.016951,0.016294,0.0076316,-0.0084826,5.5054,4.6648,2.9973,2.9655,2.4125,1.8314,2.0697,2.3924,2.4378,2.1184,1.8236,1.9518,2.3804,2.4256,2.1203,1.8294,1.9432,2.3746,2.4284,2.1193,1.8288,1.9404,2.379,2.4374,2.13,1.8336,1.9344,2.3697,2.4382,2.1435,1.8371,1.935,2.3673,2.4409,2.1423,1.8475,1.9325,2.3671,2.4496,2.1629,1.8529,1.9302,2.3622,2.4511,2.1633,1.8527,1.9255,2.3602,2.4498,2.1783,1.8522,1.9161,2.3568,2.4579,2.1758,1.8549,1.9123,2.3559,2.4572,2.1896,1.8592,1.9024,2.3459,2.4554,2.2008,1.864,1.9059,2.3432,2.4587,2.2063,1.8599,1.8988,2.3462,2.4605,2.2133,1.8699,1.8944,2.331,2.4608,2.2249,1.8711,1.8938,2.3314,2.4637,2.2358,1.8732,1.8889,2.3266,2.4617,2.2361,1.8776,1.8875,2.3216,2.4608,2.2437,1.8784,1.8805,2.3185,2.4627,2.2519,1.8838,1.8765,2.319,2.4647,2.2613,1.8835,1.872,2.3082,2.4678,2.2609,1.8816,1.8754,2.3072,2.4678,2.2711,1.8916,1.8726,2.298,2.4688,2.2935,1.8934,1.8651,2.2977,2.4651,2.2858,1.8925,1.8641,2.2925,2.464,2.2956,1.8995,1.8554,2.2825,2.4636,2.3012,1.9072,1.8558,2.2809,2.4645,2.3139,1.9021,1.8544,2.2801,2.4617,2.3147,1.9125,1.8455,2.268,2.4591,2.3223,1.9114,1.8437,2.2676,2.4623,2.3275,1.9223,1.8378,2.2621,2.4558,2.3333,1.9209,1.8389,2.2611,2.4662,2.3361,1.9249,1.8337,2.2573,2.4653,2.3492,1.9327,1.8332,2.2505,2.4637,2.3506,1.9384,1.8246,2.2417,2.4661,2.3621,1.9436,1.8308,2.2471,2.4601,2.3632,1.9486,1.8346,2.2316,2.4638:6
-0.0188,0.024606,0.0037786,-8.0738E-4,0.027441,-0.022919,0.019503,0.006286,-0.0095324,6.0953,4.232,2.7786,2.9524,2.5205,1.9166,1.8731,2.2501,2.4091,2.2501,1.8738,1.7956,2.2207,2.3955,2.2559,1.8815,1.782,2.2157,2.4009,2.2598,1.8841,1.7863,2.21,2.4005,2.2764,1.9037,1.7863,2.2031,2.4053,2.2834,1.9066,1.7767,2.2041,2.4067,2.3017,1.9108,1.7812,2.1974,2.4099,2.305,1.9247,1.7795,2.1937,2.4071,2.3144,1.9179,1.7794,2.187,2.4089,2.3246,1.9352,1.7759,2.1766,2.4057,2.335,1.9439,1.7722,2.1804,2.4018,2.3473,1.9492,1.7703,2.1655,2.4113,2.3471,1.9608,1.7688,2.1616,2.4047,2.3562,1.9677,1.7724,2.1561,2.4027,2.3711,1.9744,1.7673,2.1609,2.3999,2.3785,1.9821,1.7642,2.145,2.3993,2.3775,1.9838,1.7675,2.141,2.4001,2.3944,1.9928,1.7667,2.1376,2.3983,2.3955,2.003,1.7603,2.1249,2.3938,2.4055,2.017,1.7658,2.1183,2.3929,2.4116,2.0204,1.7675,2.1167,2.3949,2.4142,2.0294,1.7587,2.1049,2.3871,2.4216,2.0397,1.7641,2.1036,2.3896,2.4178,2.0501,1.7656,2.103,2.3789,2.4278,2.0606,1.7643,2.089,2.3842,2.43,2.0671,1.7587,2.0841,2.3673,2.4401,2.0831,1.7622,2.0806,2.3793,2.4362,2.0874,1.7657,2.0679,2.3693,2.4465,2.0946,1.7674,2.055,2.3674,2.4405,2.1062,1.7671,2.0496,2.3628,2.4436,2.1159,1.77,2.0483,2.3572,2.4545,2.126,1.7764,2.0378,2.3607,2.4535,2.1338,1.7756,2.0342,2.3516,2.4523,2.1455,1.7777,2.0275,2.3427,2.4563,2.1557,1.7799,2.018,2.3415,2.4587,2.1619,1.7842,2.0138,2.3353,2.4653,2.1728,1.7797,2.0103,2.335,2.4643,2.1809:6
0.018151,0.013472,-0.014977,0.029534,-0.0075228,0.018648,0.0099822,-0.010926,0.027017,-0.0093715,0.01629,0.016913,-0.012156,5.7647,4.7371,3.2013,2.8288,2.2226,1.8499,2.1928,2.4856,2.3512,1.943,1.8183,2.0842,2.4503,2.3549,1.9413,1.827,2.0819,2.4528,2.3633,1.9495,1.8214,2.0699,2.4479,2.3679,1.9537,1.8241,2.0634,2.4413,2.3826,1.9742,1.8251,2.0659,2.4375,2.3916,1.972,1.8228,2.0478,2.4436,2.3959,1.9802,1.824,2.0494,2.4333,2.3994,1.9971,1.8234,2.0415,2.4303,2.4088,2.008,1.822,2.0363,2.4266,2.4138,2.0191,1.8268,2.0255,2.43,2.4189,2.0275,1.8233,2.0199,2.4178,2.4289,2.0421,1.8222,2.0152,2.4178,2.4282,2.0485,1.8313,2.0075,2.4139,2.4332,2.059,1.8286,1.9993,2.4038,2.4364,2.0714,1.83,1.99,2.4052,2.4389,2.0722,1.822,1.9882,2.4044,2.4392,2.0858,1.8291,1.9794,2.4004,2.4453,2.095,1.831,1.9691,2.3951,2.4459,2.104,1.8372,1.9662,2.3935,2.4476,2.1185,1.8409,1.9563,2.3795,2.4448,2.1303,1.8338,1.9597,2.3822,2.4564,2.1401,1.8425,1.9498,2.3797,2.4577,2.1507,1.8466,1.9377,2.374,2.4565,2.1547,1.8475,1.9343,2.3708,2.4558,2.1631,1.8511,1.9313,2.3624,2.4605,2.1772,1.8542,1.9245,2.3576,2.4632,2.1884,1.8565,1.9172,2.3463,2.4567,2.1954,1.8595,1.9123,2.3476,2.4595,2.2074,1.8622,1.9038,2.3385,2.4647,2.2154,1.8623,1.893,2.3287,2.459,2.2237,1.873,1.8907,2.328,2.4577,2.2402,1.8754,1.886,2.3177,2.4614,2.242,1.8772,1.8847,2.3121,2.4614,2.2579,1.8734,1.8817,2.3065,2.465,2.2658,1.8826,1.8754,2.2955,2.4656,2.27,1.8804,1.8696:6
-0.020316,0.0017175,-0.013172,-0.018538,0.011578,-0.019418,0.0027107,-0.014369,-0.016205,0.0062815,-0.017025,0.0023066,-0.010833,-0.02391,0.0064617,-0.018311,0.0043536,-0.0072232,-0.012127,0.0069843,-0.021498,0.0052771,-0.0086254,-0.015751,2.959E-4,-0.021094,0.0037773,-0.0077844,5.2284,4.9756,2.8914,3.4861,3.0884,2.469,2.039,1.888,2.3019,2.3734,2.0869,1.7496,1.736,2.1321,2.2479,2.0166,1.7023,1.7099,2.1062,2.2303,2.0026,1.6913,1.7008,2.0983,2.2261,2.0002,1.6859,1.7008,2.0965,2.2329,2.0086,1.687,1.7049,2.0963,2.2376,2.0042,1.6872,1.7056,2.1012,2.2413,2.007,1.6885,1.7064,2.0995,2.2507,2.0104,1.6947,1.7061,2.1042,2.245,2.0078,1.6927,1.7128,2.1045,2.2478,2.0078,1.6964,1.7163,2.107,2.2518,2.0132,1.6926,1.7171,2.1049,2.2538,2.0152,1.6964,1.7157,2.104,2.2465,2.0158,1.6939,1.7194,2.1083,2.2482,2.0109,1.6968,1.7191,2.1032,2.2556,2.0154,1.6918,1.7245,2.1108,2.2555,2.0184,1.6897,1.7201,2.1115,2.2634,2.0109,1.6976,1.7211,2.1154,2.2657,2.0122,1.7006,1.7177,2.1171,2.268,2.0147,1.6956,1.721,2.1192,2.2572,2.0132,1.6915,1.7239,2.112,2.2582,2.0133,1.696,1.7273,2.1142,2.266,2.0116,1.6965,1.7308,2.1173,2.2675,2.0158,1.6961,1.7265,2.1215,2.2682,2.0131,1.699,1.7271,2.1228,2.2717,2.0103,1.6992,1.7285,2.124,2.2631,2.0121,1.6962,1.7272,2.1264,2.2669,2.0109,1.7029,1.7276,2.1224,2.2664,2.0152,1.7004,1.7384,2.1245,2.2738,2.0086,1.7001,1.7331,2.1223,2.2643,2.0063,1.6986,1.7333,2.123,2.2647,2.0109,1.6977,1.7346,2.1244,2.2637,2.0065,1.6947,1.7374,2.1326,2.2717,2.0014,1.6966:6
-0.021859,0.0091795,-0.021094,6.728E-4,-0.0037346,-0.023758,0.0061998,-0.026992,-6.4593E-4,-0.0053069,-0.021487,0.0096547,-0.024892,-8.5541E-4,-0.0025644,-0.018411,0.0066493,-0.023526,-0.0057709,-0.0073152,-0.019746,0.013647,-0.02122,8.2698,5.0677,3.4533,2.2952,2.5205,2.6853,2.5074,2.0749,1.7696,1.9157,2.2696,2.2352,1.8989,1.6689,1.8283,2.1986,2.1842,1.8702,1.6519,1.813,2.1835,2.1785,1.861,1.6473,1.8085,2.1815,2.1835,1.8667,1.6444,1.8096,2.1653,2.1833,1.8659,1.6422,1.8112,2.1806,2.1947,1.8714,1.6494,1.8048,2.1822,2.1902,1.8638,1.6484,1.8141,2.1835,2.1955,1.8749,1.6528,1.8079,2.1816,2.1916,1.8735,1.6528,1.8073,2.1792,2.1976,1.8734,1.6549,1.8054,2.1765,2.1984,1.8774,1.6523,1.8108,2.1867,2.2026,1.8837,1.6512,1.81,2.1781,2.2046,1.8799,1.6573,1.8063,2.1778,2.1967,1.8836,1.6484,1.8025,2.1853,2.2076,1.885,1.6532,1.806,2.1791,2.1974,1.8769,1.6486,1.8029,2.1824,2.2013,1.8797,1.6552,1.8005,2.1803,2.2006,1.8868,1.6479,1.8061,2.1772,2.2085,1.8864,1.6456,1.8103,2.1767,2.2031,1.9007,1.6502,1.811,2.1714,2.2095,1.8926,1.654,1.802,2.1811,2.2141,1.8903,1.6617,1.8014,2.1847,2.2099,1.8861,1.6526,1.7976,2.1836,2.204,1.8985,1.6622,1.8043,2.18,2.2136,1.8863,1.6565,1.8024,2.1803,2.214,1.8957,1.6625,1.8014,2.1851,2.2084,1.8908,1.656,1.8019,2.1765,2.2203,1.8939,1.6624,1.7993,2.1875,2.2196,1.8984,1.6573,1.7981,2.184,2.214,1.8994,1.6648,1.7932,2.188,2.2244,1.8986,1.6577,1.7957,2.1826,2.2101,1.8988,1.6599,1.7915,2.1727,2.2116,1.8984,1.6554,1.7928,2.1774,2.2023:6
-0.0028987,-0.022735,0.0044014,-0.023865,-0.0061535,-0.0047151,-0.0182,0.013847,-0.016504,-0.0031554,9.6554,7.8915,4.1983,5.2715,4.9356,4.3777,3.6024,3.2134,3.8552,4.3367,4.0388,3.3351,3.1737,3.7314,4.2888,4.0144,3.3169,3.1662,3.7263,4.286,4.0119,3.3086,3.1689,3.7247,4.2786,4.0177,3.3094,3.169,3.7293,4.2753,4.0194,3.3056,3.1711,3.7315,4.2802,4.0194,3.3068,3.1742,3.7315,4.2672,4.0117,3.2982,3.1715,3.7384,4.269,4.0169,3.2935,3.1811,3.7333,4.2758,4.0118,3.2918,3.1789,3.736,4.2745,4.0139,3.29,3.1762,3.7406,4.2765,4.0089,3.288,3.1771,3.7421,4.2821,4.0071,3.2901,3.1807,3.7455,4.2783,4.0115,3.2742,3.1789,3.7534,4.2705,4.0111,3.2854,3.1822,3.7529,4.2766,4.0086,3.2892,3.1781,3.7564,4.2778,4.0078,3.2896,3.1874,3.7624,4.2794,4.0157,3.2802,3.1865,3.7617,4.2793,4.0003,3.2756,3.196,3.7591,4.2812,4.0089,3.2794,3.1962,3.7663,4.2839,4.0035,3.2749,3.195,3.765,4.285,4.0021,3.2722,3.2026,3.7711,4.2855,4.0042,3.2661,3.1937,3.7661,4.2813,3.9979,3.2709,3.1943,3.7663,4.2795,3.9923,3.2643,3.1931,3.77,4.2765,3.993,3.2676,3.1953,3.7798,4.2727,3.9917,3.2646,3.1967,3.7772,4.2809,3.9895,3.2567,3.1976,3.7873,4.2767,3.9797,3.2626,3.1922,3.7719,4.2841,3.9922,3.259,3.1984,3.785,4.282,3.9845,3.2541,3.196,3.7825,4.2783,3.9829,3.2516,3.2013,3.7892,4.2792,3.9802,3.2505,3.2039,3.7933,4.2821,3.9761,3.2477,3.2063,3.8042,4.2821,3.9747,3.2516,3.2061,3.7922,4.2873,3.9683,3.2489,3.2047,3.7953,4.2796,3.9718,3.2454,3.2116,3.8043,4.2842:6
-0.0094784,0.0037857,-0.021881,0.0078464,-0.019164,-0.0045535,0.0045535,-0.022199,0.0067187,-0.018188,-0.0045081,-0.0011134,-0.022141,0.0092533,-0.015323,-0.0091764,0.0037961,-0.021945,0.0075693,-0.015602,-0.0059285,4.4194,9.3557,5.9087,5.4323,5.1306,4.2897,3.3545,3.427,4.0218,4.2691,3.8324,3.1381,3.2784,3.9235,4.2108,3.7878,3.1198,3.2744,3.9243,4.2081,3.7841,3.1206,3.2712,3.9205,4.21,3.7848,3.1169,3.2781,3.9332,4.2116,3.7712,3.122,3.2888,3.937,4.2132,3.7704,3.1211,3.2905,3.9418,4.2147,3.7622,3.1129,3.3002,3.956,4.2106,3.7612,3.1065,3.2985,3.9541,4.2224,3.7552,3.1149,3.3093,3.9669,4.2144,3.7507,3.1055,3.3059,3.9673,4.2135,3.7407,3.1076,3.3095,3.9668,4.2045,3.7373,3.0978,3.3178,3.9751,4.2172,3.7366,3.1046,3.3281,3.9788,4.222,3.7335,3.102,3.3242,3.979,4.2206,3.7226,3.0978,3.3322,3.9858,4.2133,3.7169,3.0941,3.3334,3.9943,4.2237,3.714,3.0987,3.3441,3.997,4.2194,3.7021,3.0978,3.3464,4.0082,4.2213,3.6982,3.1,3.356,4.0116,4.2198,3.691,3.0956,3.359,4.0126,4.2245,3.6845,3.0933,3.3626,4.0193,4.2239,3.6819,3.0868,3.3698,4.0254,4.213,3.6709,3.0862,3.369,4.0335,4.2142,3.67,3.0901,3.3763,4.0301,4.2181,3.6638,3.0825,3.3832,4.0376,4.2123,3.6502,3.0862,3.3837,4.037,4.2143,3.6462,3.0839,3.3925,4.0357,4.2094,3.6384,3.0838,3.4013,4.045,4.2118,3.6352,3.0801,3.4012,4.0501,4.215,3.6302,3.0813,3.4064,4.0556,4.205,3.6236,3.0835,3.4111,4.0519,4.2115,3.6211,3.0846,3.4152,4.0615,4.2127,3.6088,3.0802,3.4232,4.0665,4.2047,3.6045,3.0845,3.4281,4.0649:6
-0.0011011,-5.825E-4,-0.022672,0.010023,-0.017398,-0.0094553,3.5318E-4,-0.023339,0.007818,-0.016354,-0.010824,-0.001526,-0.022214,0.0068361,-0.013673,-0.0065702,0.0023529,-0.017426,0.011873,-0.014281,-0.0045266,0.0053817,-0.024865,0.0078601,-0.018749,-0.008956,9.9535,7.7425,4.1362,5.3877,4.9373,4.1515,3.4832,3.232,3.9166,4.3083,3.8597,3.2082,3.1919,3.8052,4.2555,3.8409,3.183,3.1912,3.8136,4.2544,3.8294,3.1866,3.1924,3.8174,4.2487,3.8355,3.1799,3.1961,3.8276,4.2444,3.8336,3.1747,3.2054,3.8355,4.2441,3.8266,3.1639,3.2066,3.8344,4.2411,3.8298,3.1632,3.2108,3.8387,4.2368,3.8153,3.1564,3.2086,3.8362,4.2379,3.8148,3.1561,3.2129,3.8478,4.2355,3.8102,3.1459,3.2154,3.8592,4.2412,3.8189,3.1502,3.2288,3.8632,4.2452,3.8095,3.1457,3.2324,3.8663,4.244,3.8043,3.1403,3.2448,3.8727,4.2502,3.7993,3.142,3.2491,3.882,4.2537,3.7964,3.1367,3.2527,3.8838,4.2524,3.7872,3.1448,3.2568,3.9026,4.25,3.7842,3.1319,3.2591,3.9036,4.2517,3.787,3.1299,3.2627,3.9045,4.2479,3.7773,3.1293,3.272,3.9182,4.2447,3.7713,3.1262,3.2773,3.9189,4.2486,3.7627,3.128,3.2815,3.9191,4.2539,3.7587,3.1241,3.2908,3.9336,4.2585,3.7523,3.1207,3.2857,3.9349,4.2488,3.7439,3.1147,3.2944,3.9395,4.2528,3.742,3.1138,3.2926,3.9527,4.2479,3.7374,3.1104,3.3129,3.9562,4.2466,3.7261,3.1079,3.3133,3.957,4.2419,3.7177,3.1082,3.3164,3.9673,4.2439,3.715,3.1061,3.3194,3.9771,4.2441,3.7123,3.107,3.3282,3.9698,4.2393,3.7044,3.0965,3.3236,3.9758,4.2521,3.6969,3.1002,3.338,3.9831,4.2473,3.6933,3.096,3.3451,3.988:6
-0.024147,0.0063661,-0.0064947,-0.019115,0.013104,-0.02688,0.0048358,-0.007416,-0.017077,0.010702,-0.021163,5.3535E-4,-0.01174,-0.018875,0.0085502,-0.021958,0.0060429,3.264E-4,-0.018896,0.015022,-0.021965,-0.0038314,-0.0028876,-0.01805,0.021199,1.8379,11.203,6.9125,5.0548,3.1932,3.8668,4.0524,4.2068,3.6602,2.9986,3.2465,3.89,4.0436,3.555,3.0027,3.1958,3.8851,4.0437,3.5497,2.999,3.1842,3.8873,4.0315,3.5491,3.0051,3.1847,3.8751,4.036,3.5554,3.0092,3.1822,3.8735,4.0429,3.5494,3.0098,3.1765,3.8798,4.0325,3.5537,3.0134,3.1709,3.8672,4.0504,3.5569,3.0137,3.1683,3.8669,4.0507,3.5644,3.0116,3.1695,3.8589,4.0472,3.5736,3.0191,3.1512,3.8521,4.0564,3.5768,3.0126,3.1569,3.8563,4.051,3.5802,3.0214,3.1558,3.8585,4.0627,3.5905,3.0172,3.1496,3.8489,4.0565,3.5835,3.0226,3.1507,3.8511,4.052,3.5949,3.0272,3.1461,3.8304,4.0424,3.5976,3.0296,3.1503,3.8349,4.0557,3.6031,3.0286,3.1419,3.8313,4.0512,3.6038,3.0314,3.1467,3.8286,4.0573,3.6113,3.0313,3.1238,3.8269,4.054,3.6181,3.0342,3.1342,3.8245,4.0627,3.6202,3.0321,3.124,3.8197,4.0553,3.6311,3.0366,3.1221,3.8198,4.0524,3.6337,3.0389,3.1207,3.8137,4.056,3.6365,3.0427,3.1195,3.8055,4.0661,3.6438,3.0362,3.1097,3.8098,4.0701,3.6512,3.0441,3.1084,3.7939,4.0612,3.655,3.0479,3.1051,3.8018,4.06,3.6546,3.0511,3.0983,3.7859,4.0576,3.6607,3.0503,3.0982,3.7982,4.0614,3.663,3.0555,3.0962,3.7836,4.0642,3.674,3.0544,3.0946,3.7857,4.0663,3.6691,3.0595,3.0996,3.7734,4.0715,3.6845,3.0618,3.0879,3.7818,4.064,3.675,3.0639:6
-0.027024,0.0020678,-0.0017167,-0.018059,0.017909,-0.025308,0.012358,-0.0027368,-0.024811,0.012367,-0.02696,0.0018139,-0.0063785,-0.019433,0.01092,10.297,8.0188,5.7194,4.0298,3.5763,3.2958,4.0667,4.1307,3.4548,3.0182,3.1698,3.8581,4.0271,3.4327,2.9798,3.1762,3.8441,4.0147,3.4381,2.976,3.1756,3.8484,4.0272,3.4349,2.9783,3.1835,3.852,4.0256,3.4391,2.9845,3.1898,3.8545,4.0346,3.4369,2.9875,3.1932,3.863,4.0328,3.4431,2.9841,3.1933,3.8742,4.01,3.4096,2.9735,3.2042,3.8701,4.0317,3.4361,2.9827,3.1982,3.8704,4.038,3.4368,2.9871,3.2054,3.8721,4.0333,3.4397,2.9813,3.208,3.8787,4.0314,3.4413,2.9896,3.2079,3.8826,4.0452,3.447,2.9848,3.2119,3.8823,4.0429,3.4393,2.9895,3.2114,3.8809,4.0379,3.4415,2.9828,3.2104,3.8857,4.0381,3.4371,2.9859,3.2135,3.893,4.0352,3.4303,2.9864,3.2031,3.8815,4.0352,3.4332,2.9889,3.2142,3.8952,4.0421,3.4384,2.9852,3.2222,3.8897,4.0459,3.4357,2.9894,3.225,3.8901,4.0393,3.4327,2.9799,3.2267,3.904,4.043,3.4359,2.9843,3.2357,3.9013,4.0442,3.4306,2.9901,3.2292,3.9059,4.0495,3.4341,2.9862,3.245,3.9072,4.0412,3.4317,2.9881,3.2365,3.9171,4.0411,3.4255,2.9902,3.2495,3.9085,4.048,3.4293,2.9994,3.2417,3.9069,4.0403,3.4248,2.9863,3.2391,3.9148,4.0416,3.4226,2.9918,3.245,3.9142,4.0337,3.4207,2.9902,3.2445,3.916,4.0412,3.4179,2.9885,3.2481,3.9231,4.0315,3.4121,2.9796,3.2575,3.9187,4.0378,3.4131,2.993,3.2595,3.9258,4.0417,3.4129,2.9855,3.2574,3.9198,4.033,3.416,2.9881,3.2582,3.9249,4.0412,3.409,2.9852:6
0.068134,0.078193,0.082513,0.14812,0.083516,0.078531,0.082815,0.075322,0.1532,0.079734,0.070167,0.078963,0.084964,0.15179,0.078154,0.08104,0.0833,0.072988,0.14859,0.079134,0.06918,0.079287,0.081321,0.14644,0.078937,0.073163,0.079356,0.075297,0.1519,0.072851,0.067893,0.084037,0.075878,0.15087,0.079724,0.070347,0.082709,0.070128,0.13986,0.077074,0.064888,0.079839,0.075622,0.142,0.076892,0.07317,0.082981,0.069218,0.15415,0.11379,0.15522,0.20033,0.21315,0.31826,0.11752,0.16104,0.1463,0.11767,0.22421,0.11276,0.13529,0.10088,0.09393,0.19953,0.084967,0.11356,0.11259,0.09468,0.23835,0.13326,0.1302,0.13225,0.1285,0.31453,0.12647,0.1266,0.18759,0.20901,0.26474,0.13548,0.13577,0.1755,0.13785,0.26737,0.15223,0.14218,0.15189,0.15156,0.3163,0.14145,0.13499,0.15015,0.12132,0.33276,0.13649,0.12022,0.12238,0.17769,0.2822,0.13032,0.1199,0.2011,0.17528,0.27457,0.14403,0.15899,0.15287,0.1351,0.28109,0.14391,0.13933,0.14183,0.12727,0.33358,0.13682,0.12906,0.12896,0.19761,0.30036,0.12906,0.11632,0.17661,0.14975,0.24362,0.12339,0.15284,0.21776,0.15632,0.35338,0.16213,0.14227,0.15243,0.12259,0.32457,0.13679,0.12213,0.12572,0.16509,0.27043,0.13142,0.11351,0.18104,0.13832,0.23426,0.11694,0.14376,0.14117,0.11016,0.26359,0.13342,0.11034,0.18107,0.16982,0.30739,0.12903,0.12648,0.10923,0.15023,0.25639,0.12863,0.11823,0.16722,0.13832,0.24629,0.12373,0.15909,0.14613,0.11618,0.2644,0.12918,0.11161,0.13286,0.12543,0.29072,0.1159,0.11536,0.16486,0.22315,0.27631,0.17409,0.1844,0.21681,0.17926,0.21988,0.11322,0.15731,0.1415,0.12321,0.28348,0.12833,0.10488,0.13693,0.13272,0.30911,0.12213,0.13223,0.13997,0.19113,0.30016,0.12969:7
1.8288,0.78624,0.92397,1.0379,1.0391,2.0569,0.84462,0.97387,0.97476,1.0511,1.8438,0.75057,0.90725,0.86205,0.94878,1.7525,0.769,0.83847,0.88322,1.2846,2.6808,2.1121,2.3879,2.3143,2.7375,2.4713,1.4389,1.3495,1.9173,2.3375,2.5814,1.8982,2.5249,2.3852,3.4324,3.0508,2.2142,2.2267,2.6653,2.7563,2.7644,1.4606,1.4962,1.2688,2.5835,2.4724,1.7631,1.5971,2.0646,2.194,2.3938,1.3938,1.8031,1.4999,2.2045,2.3201,1.5901,1.6032,1.5487,2.0716,2.6926,1.4286,1.3895,1.2296,2.5614,1.9971,1.5096,1.419,1.7015,2.5735,2.0911,1.7577,2.0755,1.64,2.3529,2.4105,1.79,1.6282,1.5726,2.157,2.5585,1.4849,1.3766,1.31,2.7187,2.2453,1.6703,1.9105,2.3821,2.7873,1.9197,1.0039,1.8332,1.6959,2.0171,2.2372,2.2063,2.1156,1.6806,2.4381,2.5369,1.3818,1.5822,1.562,2.6326,2.2711,1.4174,1.336,1.8693,2.721,1.9168,0.98574,1.9383,1.8011,1.8304,1.8317,1.715,1.649,1.5381,2.025,2.4384,1.986,1.9783,1.5334,2.9758,1.7709,1.0083,1.1414,1.7824,2.7796,1.8278,1.0819,1.8226,1.7438,1.8341,1.8426,2.1133,1.5632,1.4818,2.2674,2.089,1.5788,1.4214,1.0826,2.8197,1.7303,1.4619,1.7164,2.226,2.685,1.7854,0.97129,1.9076,1.7918,1.9197,1.8476,1.8134,1.5253,1.6022,2.2172,2.492,1.5497,1.3498,1.227,3.0378,1.7518,1.5364,1.4334,1.7187,2.9008,1.7132,1.3449,2.3938,1.8294,2.8042,1.8116,1.9202,1.431,1.4909,2.2093,2.2943,1.5813,1.3436,1.1991,3.1137,1.6818,0.98481,1.1544,1.9293,2.8956,1.8381,1.0096,1.7889,1.8025,2.0055,1.6464,2.1052,2.2004,2.2092,3.7225:7
3.7844,1.9299,1.8958,1.9887,2.0105,3.7717,1.9328,1.8308,1.9034,2.0436,3.8113,1.9147,1.8334,1.9606,1.9664,3.7703,1.894,1.8198,2.0152,1.9926,3.7621,1.9408,1.835,2.0131,2.0088,3.8892,2.01,1.8707,2.0177,2.1483,4.8065,2.4651,2.5059,2.7525,2.5865,4.4997,2.2157,2.2238,2.55,2.3449,4.2633,2.4584,2.2418,2.2439,2.2164,4.5236,2.1245,2.0665,2.2058,2.2751,4.895,2.2282,2.0947,2.3271,2.6007,4.9427,2.2625,2.4077,2.5359,2.4976,4.3862,2.4124,2.366,2.2479,2.5268,5.057,2.4209,2.2421,2.3376,2.5671,4.6812,2.2183,2.2178,2.4548,2.5076,4.3737,2.1498,2.2557,2.4396,2.3721,4.9191,2.6157,2.2823,2.3619,2.4083,4.6346,2.0471,2.0371,2.1752,2.1721,4.6286,2.0919,1.8956,2.1929,2.6274,4.0758,1.8957,2.1287,1.9295,1.7637,2.5815,1.7113,1.6642,1.3673,1.2263,3.8187,1.5322,1.5147,1.5505,1.857,3.6169,1.3421,1.0934,1.5633,2.1042,2.649,1.1471,1.5881,1.7084,1.6131,2.6273,1.6727,1.7867,1.4534,1.1895,3.3407,1.4063,1.4492,1.5446,1.4061,4.3216,1.4718,1.6199,1.8896,1.8911,2.6405,1.0858,1.5461,1.5653,1.5308,2.5389,1.6219,1.7072,1.3954,1.1851,3.4318,1.9044,1.9703,2.166,1.5053,3.5447,1.4009,1.1324,1.5245,1.9278,3.5957,1.4564,1.6769,1.6845,1.9863,3.0286,1.7157,1.834,1.3928,1.2629,3.4052,1.3319,1.4588,1.5648,1.5112,3.6027,1.4652,1.195,1.6004,2.1019,2.6292,1.1222,1.6208,1.7674,1.6428,3.4986,2.2005,1.6705,1.6408,1.7336,3.4738,1.3031,1.3188,1.532,1.6108,3.4106,1.3294,1.1894,1.4815,1.8433,2.7208,1.1292,1.6492,1.7457,1.636:7
0.041914,0.040896,0.048961,0.087213,0.03545,0.048259,0.043241,0.04211,0.10018,0.031641,0.039955,0.042539,0.055088,0.091608,0.036655,0.04641,0.04448,0.044665,0.092404,0.042558,0.040275,0.038683,0.041979,0.11243,0.043098,0.055944,0.059344,0.092773,0.14008,0.042781,0.049232,0.070207,0.086347,0.10452,0.046218,0.06427,0.085838,0.089155,0.17439,0.061947,0.086393,0.068281,0.061473,0.14845,0.067044,0.071406,0.062809,0.067238,0.16613,0.053906,0.063322,0.05813,0.072641,0.16168,0.049178,0.069136,0.074038,0.097473,0.15327,0.087096,0.076764,0.073871,0.067552,0.14427,0.079794,0.071713,0.05494,0.081942,0.16695,0.049851,0.056742,0.071711,0.071707,0.15906,0.057698,0.068197,0.067541,0.099222,0.13377,0.059688,0.059481,0.08235,0.078843,0.15669,0.066454,0.072003,0.06088,0.061988,0.22017,0.068863,0.07191,0.10481,0.11967,0.2271,0.096996,0.1201,0.092327,0.07917,0.13928,0.07402,0.083528,0.068979,0.067462,0.14633,0.070885,0.076319,0.062684,0.065462,0.17989,0.056947,0.057669,0.079984,0.073477,0.16889,0.055877,0.074829,0.069092,0.08286,0.14638,0.07659,0.087161,0.064687,0.066828,0.15413,0.074291,0.064222,0.063257,0.080616,0.16374,0.061606,0.059408,0.084601,0.087331,0.14344,0.064859,0.063572,0.075001,0.096399,0.14235,0.066663,0.070917,0.078592,0.06969,0.16185,0.069005,0.06756,0.087564,0.068066,0.15344,0.069577,0.062436,0.07539,0.088777,0.15518,0.053574,0.053069,0.084083,0.10076,0.15639,0.050611,0.080309,0.072935,0.069971,0.15024,0.056013,0.077742,0.067908,0.071886,0.16923,0.067668,0.064645,0.075143,0.099114,0.14319,0.064415,0.06518,0.076529,0.074794,0.1274,0.064026,0.078588,0.070242,0.063514,0.15215,0.080455,0.085526,0.081381,0.10153,0.20656,0.080512,0.071179,0.086656,0.091214,0.19555,0.075713,0.086033,0.086576,0.092179,0.19976,0.073122:7
0.033465,0.039682,0.043564,0.039987,0.10217,0.031205,0.030493,0.043826,0.047266,0.090706,0.03542,0.035078,0.05243,0.040446,0.099186,0.036005,0.03375,0.045066,0.042305,0.098287,0.039099,0.033857,0.046842,0.042442,0.093533,0.037916,0.035036,0.05492,0.050805,0.11471,0.056938,0.062598,0.059847,0.061174,0.14954,0.036381,0.045058,0.058458,0.045017,0.1406,0.053558,0.048427,0.058891,0.078606,0.12411,0.049582,0.05896,0.068279,0.062366,0.12851,0.063303,0.052979,0.073818,0.060941,0.12173,0.03861,0.063516,0.066291,0.060711,0.13244,0.062076,0.045007,0.062571,0.053832,0.13944,0.044607,0.040566,0.065989,0.061647,0.13901,0.06715,0.06061,0.083665,0.070387,0.21715,0.1464,0.12578,0.13785,0.14118,0.28709,0.14757,0.12694,0.14038,0.14638,0.28758,0.12685,0.12311,0.14416,0.15107,0.28205,0.13994,0.13819,0.14355,0.13912,0.28042,0.1289,0.13231,0.14703,0.13952,0.28356,0.14652,0.12492,0.14085,0.14431,0.28454,0.1298,0.13073,0.14327,0.1464,0.27666,0.13854,0.13118,0.14922,0.14119,0.27724,0.13591,0.12891,0.1434,0.142,0.28536,0.14894,0.12854,0.13568,0.1525,0.28881,0.063533,0.049098,0.082278,0.091739,0.13895,0.084894,0.084305,0.079041,0.062116,0.15151,0.079888,0.050849,0.055457,0.060455,0.11966,0.081871,0.056252,0.054368,0.066397,0.12192,0.069913,0.057298,0.060492,0.070772,0.12053,0.075503,0.071986,0.072514,0.053209,0.12054,0.087325,0.052234,0.051882,0.06836,0.11792,0.065137,0.046056,0.070779,0.1051,0.23927,0.082448,0.057419,0.082946,0.072963,0.15825,0.085887,0.075906,0.079193,0.070395,0.14052,0.066837,0.068935,0.074195,0.062348,0.15736,0.10325,0.05846,0.075275,0.082652,0.14174,0.069404,0.054575,0.073975,0.06692,0.15245,0.090095,0.070323,0.079813,0.070677,0.1312,0.093138,0.059308,0.061749,0.057273,0.13259:7
0.3726,0.56151,0.29154,0.2808,0.34515,0.60284,0.774,0.43891,0.42669,0.35649,0.59366,0.5936,0.26185,0.26898,0.32933,0.32051,0.52749,0.24361,0.2426,0.39326,0.36553,0.53287,0.25369,0.24765,0.39508,0.35755,0.51313,0.255,0.35742,0.38885,0.46579,0.67482,0.56749,0.71827,0.76123,1.0705,1.0434,0.7283,0.73191,0.72469,0.78613,0.66147,0.25271,0.35584,0.38757,0.4488,0.53565,0.23372,0.2434,0.25079,0.29713,0.63127,0.28824,0.25347,0.28041,0.38323,0.57068,0.31142,0.25398,0.24484,0.26551,0.53128,0.35105,0.29453,0.32029,0.39413,0.75926,0.31343,0.29356,0.42842,0.58632,0.92787,0.43053,0.28479,0.26463,0.44444,0.78669,0.25986,0.24617,0.3309,0.49402,0.61681,0.26409,0.247,0.34318,0.34767,0.53488,0.25671,0.30086,0.34446,0.29041,0.55746,0.31223,0.34284,0.27516,0.28199,0.55761,0.3803,0.38804,0.30471,0.29994,0.7314,0.31888,0.24906,0.32503,0.28499,0.66288,0.24152,0.26017,0.33069,0.4008,0.69429,0.33183,0.32189,0.31567,0.41384,0.56031,0.22442,0.27489,0.45432,0.4007,0.55069,0.23284,0.36089,0.32754,0.27525,0.51382,0.30905,0.31709,0.28466,0.27661,0.71227,0.30412,0.27989,0.25533,0.26008,0.68354,0.23917,0.31663,0.40731,0.55299,1.154,0.55428,0.61311,0.65026,0.85323,1.1719,0.57541,0.64118,0.66845,0.45777,0.67096,0.34949,0.4113,0.35817,0.27281,0.67463,0.32299,0.33939,0.28193,0.27879,0.65148,0.36465,0.31888,0.33651,0.30602,0.73017,0.28772,0.24681,0.28962,0.31393,0.6992,0.28215,0.37203,0.46733,0.61209,0.98545,0.37778,0.29626,0.47099,0.43349,0.71057,0.28633,0.49745,0.60524,0.4053,0.63003,0.30399,0.44006,0.33081,0.31666,0.64197,0.35485,0.32123,0.29432,0.28888,0.75953,0.29178,0.27748,0.29846:7
0.64284,0.2343,0.26557,0.27843,0.30228,0.67515,0.28016,0.32623,0.32964,0.36917,1.2038,0.68272,0.72265,0.63738,0.38055,1.0464,0.43926,0.37899,0.34994,0.35447,0.64303,0.28746,0.2848,0.34956,0.31983,0.65705,0.32311,0.35981,0.53746,0.57109,1.0946,0.78683,0.79634,0.68966,0.49208,1.1308,0.46802,0.32147,0.4245,0.36512,0.96951,0.31492,0.3372,0.35722,0.39255,0.86939,0.47763,0.50679,0.50991,0.60364,1.4641,0.59133,0.41848,0.3243,0.43393,0.82733,0.4915,0.3702,0.3059,0.31875,0.79523,0.34667,0.29064,0.33246,0.33415,0.80816,0.32512,0.31549,0.31625,0.32346,0.89933,0.34783,0.32248,0.30307,0.43342,1.1586,0.3359,0.36946,0.44838,0.71382,1.3004,0.70924,0.63186,0.72335,0.41512,0.67019,0.46505,0.63483,0.38091,0.33218,0.83957,0.45049,0.41914,0.36541,0.33078,0.70015,0.46082,0.42475,0.39459,0.44703,0.98357,0.41057,0.3304,0.40108,0.36349,0.86884,0.39373,0.33226,0.34202,0.50934,0.7247,0.43633,0.35508,0.53381,0.66394,1.5907,0.74535,0.68188,0.75099,0.73157,1.4345,0.48266,0.55735,0.46775,0.454,0.68049,0.69948,0.48308,0.34041,0.32063,0.72385,0.53243,0.29631,0.39269,0.56252,1.1278,0.87661,0.86197,0.82928,1.7772,0.53928,0.82178,0.26102,0.49498,0.66517,0.69131,0.53335,0.39306,0.47454,0.48948,0.66271,0.59412,0.56213,0.45336,0.39594,0.53132,0.57458,0.44139,0.38447,0.42846,0.66203,0.60692,0.44748,0.43088,0.43934,0.74108,0.61317,0.35846,0.3465,0.40115,0.89794,0.73802,0.46051,0.39245,0.88922,0.69591,0.64408,0.40198,0.46791,0.54362,0.64119,0.61751,0.44956,0.48448,0.57157,0.68802,0.70666,0.59835,0.47371,0.41831,0.60315,0.91932,0.475,0.37381,0.42139,0.71909,0.75549,0.36212,0.36528,0.44198:7
0.15493,0.18103,0.18994,0.22601,0.38668,0.16617,0.18159,0.18918,0.19499,0.41836,0.15836,0.17646,0.18313,0.18175,0.36694,0.1568,0.17192,0.17052,0.18441,0.37184,0.14987,0.16719,0.16694,0.18554,0.36733,0.16187,0.20211,0.19714,0.19197,0.51312,0.18245,0.18072,0.17217,0.20106,0.49034,0.1511,0.18035,0.19255,0.25364,0.44766,0.16817,0.20787,0.22948,0.25509,0.42593,0.1543,0.18354,0.19112,0.27619,0.46649,0.15997,0.21129,0.20772,0.24859,0.50588,0.17776,0.18998,0.18051,0.21095,0.47268,0.16824,0.20097,0.19026,0.24193,0.48931,0.15549,0.18525,0.18172,0.27183,0.58034,0.29205,0.33795,0.38187,0.4837,0.97638,0.36671,0.34405,0.30347,0.25467,0.45064,0.17787,0.33243,0.22805,0.21526,0.40614,0.23913,0.23889,0.19459,0.19861,0.4539,0.20627,0.21394,0.19977,0.22208,0.47031,0.17243,0.18922,0.17414,0.19778,0.51073,0.20143,0.21919,0.24036,0.48646,0.84658,0.39062,0.4326,0.40377,0.22108,0.44757,0.17321,0.25424,0.24312,0.21061,0.43856,0.2148,0.23471,0.19691,0.21201,0.40717,0.22266,0.22517,0.19599,0.19949,0.46971,0.19522,0.1837,0.18139,0.21024,0.51443,0.17884,0.20236,0.18506,0.22454,0.43173,0.1832,0.20469,0.20984,0.23434,0.44081,0.17811,0.2355,0.27991,0.23314,0.61657,0.20635,0.30132,0.21691,0.20085,0.4355,0.2328,0.22905,0.20713,0.20983,0.64039,0.29818,0.29613,0.39324,0.43632,0.89351,0.35905,0.41213,0.28654,0.3436,0.43317,0.17494,0.21437,0.19065,0.30991,0.43116,0.18433,0.22058,0.247,0.22041,0.39081,0.20517,0.26239,0.28564,0.40826,0.77638,0.36992,0.49368,0.47527,0.40294,0.50068,0.26124,0.21243,0.18373,0.18966,0.44545,0.1998,0.20476,0.20252,0.1881,0.48203,0.19001,0.19521,0.19957,0.23744,0.49441:7
-1.0353E-5,-2.335E-5,-1.5443E-5,-2.2767E-5,-3.279E-5,-9.3133E-6,-2.512E-5,-2.0183E-5,-2.3007E-5,-3.1767E-5,-1.0923E-5,-2.591E-5,-1.796E-5,-2.5827E-5,-3.314E-5,-1.0157E-5,-3.0353E-5,-2.0317E-5,-2.2033E-5,-3.2137E-5,-1.0823E-5,-2.759E-5,-2.0157E-5,-2.3183E-5,-3.4517E-5,-1.119E-5,-2.5433E-5,-1.6683E-5,-2.1737E-5,-3.1563E-5,-1.0857E-5,-2.9427E-5,-1.7093E-5,-2.21E-5,-3.5353E-5,-1.0627E-5,-2.3457E-5,-1.539E-5,-1.9887E-5,-3.5603E-5,-8.7567E-6,-2.7933E-5,-2.044E-5,-2.453E-5,-3.435E-5,-1.1333E-5,-2.472E-5,-1.552E-5,-2.1933E-5,-3.709E-5,-8.66E-6,-2.734E-5,-1.796E-5,-1.747E-5,-3.7933E-5,-1.063E-5,-2.652E-5,-1.7693E-5,-2.228E-5,-3.539E-5,-9.2567E-6,-2.7183E-5,-1.6523E-5,-2.3993E-5,-3.486E-5,-1.328E-5,-2.6243E-5,-1.8617E-5,-2.067E-5,-3.6493E-5,-7.9833E-6,-2.7363E-5,-1.6177E-5,-2.4823E-5,-3.9377E-5,-9.8767E-6,-2.962E-5,-1.676E-5,-2.1487E-5,-3.5037E-5,-8.19E-6,-2.9237E-5,-1.5837E-5,-2.4727E-5,-3.561E-5,-6.1867E-6,-2.6457E-5,-1.6587E-5,-2.4833E-5,-3.538E-5,-1.088E-5,-2.439E-5,-1.7793E-5,-2.2177E-5,-3.3643E-5,-1.2143E-5,-2.8673E-5,-1.802E-5,-2.13E-5,-3.475E-5,-8.7433E-6,-2.678E-5,-1.6807E-5,-2.295E-5,-3.7767E-5,-9.94E-6,-3.009E-5,-1.7873E-5,-2.3887E-5,-3.5007E-5,-9.3633E-6,-2.397E-5,-1.9703E-5,-2.324E-5,-3.4343E-5,1.467E-5,0.0014342,9.6596E-4,-1.514E-5,-3.3677E-5,-8.6733E-6,-2.7207E-5,-1.5487E-5,-2.4543E-5,-3.369E-5,-9.11E-6,-3.0347E-5,-1.569E-5,-2.5E-5,-3.9333E-5,-8.3333E-6,-2.6003E-5,-1.2783E-5,-2.2783E-5,-3.28E-5,-1.2007E-5,-2.64E-5,-1.8767E-5,-2.1957E-5,-3.4377E-5,-9.0067E-6,-2.2707E-5,-1.475E-5,-2.4493E-5,-3.1113E-5,-1.0457E-5,-3.144E-5,-1.5353E-5,-2.1477E-5,-3.4517E-5,-8.8333E-6,-2.745E-5,-1.598E-5,-2.2467E-5,-3.421E-5,-8.38E-6,-2.8527E-5,-1.773E-5,-2.3247E-5,-3.5663E-5,-9.1433E-6,-2.6463E-5,-1.708E-5,-2.2743E-5,-3.3327E-5,-1.0117E-5,-2.4317E-5,-1.565E-5,-2.1157E-5,-3.8333E-5,-7.7367E-6,-2.958E-5,-1.5603E-5,-2.1113E-5,-3.5463E-5,-7.7367E-6,4.62E-6,4.5926E-4,7.2204E-4,3.3376E-4,4.2349E-4,4.1249E-4,5.0191E-4,7.6004E-4,3.6647E-4,4.1434E-4,4.0744E-4,4.9577E-4,7.5211E-4,3.4859E-4,4.4851E-4,4.1702E-4,4.8699E-4,7.6801E-4,3.5497E-4,4.0216E-4,3.9088E-4,5.03E-4,7.5793E-4,3.5624E-4,4.306E-4,4.3169E-4,5.017E-4,7.7483E-4,4.8099E-4,5.9193E-4,5.9407E-4,8.6024E-4,9.3363E-4,5.2592E-4,5.8422E-4,6.2346E-4,8.9122E-4,9.5955E-4,5.3779E-4,5.9452E-4,4.9846E-4,5.9098E-4,9.1628E-4,4.0819E-4,4.9018E-4,5.7595E-4,6.4963E-4,9.3938E-4,4.5093E-4,5.0506E-4,4.8672E-4,6.3657E-4,9.4249E-4,4.5877E-4,5.2873E-4,5.1239E-4,7.2619E-4,9.1503E-4,4.4363E-4,5.2794E-4,5.2472E-4,6.85E-4,8.1586E-4,4.9385E-4,4.8521E-4,5.7835E-4,8.465E-4,7.9274E-4,5.1536E-4,5.3687E-4,5.4996E-4,6.7771E-4,0.0010285,9.4077E-4,0.0012818,0.0012121,0.00108,0.0010293,6.0184E-4,6.5075E-4,6.6835E-4,9.8261E-4,0.0010447,5.6227E-4,6.1901E-4,6.348E-4,9.1372E-4,0.0010054,5.5072E-4,5.8623E-4,6.0102E-4,8.3E-4,0.0010021,5.3677E-4,5.915E-4,6.0761E-4,8.6683E-4,9.9773E-4,5.3096E-4,5.8279E-4,6.0064E-4,8.4019E-4,9.8161E-4,5.2811E-4,5.8276E-4,6.015E-4,0.0012162,0.0014962,7.9041E-4,4.9125E-4,4.8656E-4,5.5839E-4,8.5864E-4,3.9332E-4,4.5974E-4,4.6048E-4,5.6505E-4,8.8692E-4,4.0105E-4,4.4315E-4,4.4005E-4,5.3415E-4,8.5751E-4,3.871E-4,4.6141E-4,4.448E-4,5.3933E-4,8.6053E-4,3.8794E-4,4.5664E-4,4.3498E-4,5.1461E-4,8.2379E-4,3.8971E-4,4.5083E-4,4.4854E-4,5.5895E-4,8.7397E-4,4.0798E-4,4.4722E-4,4.311E-4,5.2439E-4,8.7516E-4,4.0199E-4,4.4389E-4,4.616E-4,5.1476E-4,8.7157E-4,4.1361E-4,4.5164E-4,4.3959E-4,5.0255E-4,8.7061E-4,4.0073E-4,4.5922E-4,4.4834E-4,6.1195E-4,8.4659E-4,3.7923E-4,4.4243E-4,4.3569E-4,4.9546E-4,9.0871E-4,3.9325E-4,4.3284E-4,4.406E-4,5.1982E-4,8.6696E-4,4.1474E-4,4.4028E-4,4.3385E-4,5.1101E-4,8.62E-4,3.6873E-4,4.4553E-4,4.4306E-4,4.9983E-4,8.5239E-4,4.1177E-4,4.4828E-4,4.3206E-4,5.1671E-4,8.503E-4,3.8226E-4,4.4809E-4,4.2511E-4,4.7766E-4,8.4735E-4,4.066E-4,4.8188E-4,7.7149E-4,0.0018449,9.7379E-4,3.9982E-4,4.7869E-4,4.5099E-4,5.0116E-4,8.6875E-4,4.0832E-4,4.6534E-4,4.339E-4,5.0629E-4,8.7356E-4,3.8537E-4,4.3966E-4,4.2097E-4,4.9126E-4,8.5712E-4,4.0204E-4,4.4906E-4,4.6602E-4,5.1727E-4,8.6662E-4,3.7641E-4,4.2304E-4,4.2686E-4,4.6987E-4,8.5389E-4,3.8214E-4,4.8649E-4,4.6206E-4,4.773E-4,8.7645E-4,3.9201E-4,4.3817E-4,4.4288E-4,4.8457E-4,8.8095E-4,4.0996E-4,4.4739E-4,4.4347E-4,4.8251E-4,8.7856E-4,3.7631E-4,4.4843E-4,4.3973E-4,4.9956E-4,8.7421E-4,3.8329E-4,4.4776E-4,4.5913E-4,4.4762E-4,8.1564E-4,3.597E-4,4.1651E-4,4.239E-4,4.9909E-4,8.8506E-4,4.2683E-4,4.8329E-4,4.852E-4,5.2051E-4,9.2037E-4,4.0568E-4,4.6178E-4,4.6266E-4,5.3625E-4,9.0923E-4,4.5237E-4,4.8622E-4,4.7865E-4,5.4819E-4,9.0455E-4,3.9076E-4,4.6667E-4,4.7491E-4,5.1838E-4,9.0667E-4,4.1644E-4,4.5747E-4,4.6783E-4,5.4025E-4,9.5502E-4,4.7517E-4,5.7797E-4,7.1983E-4,8.3553E-4,0.0011451,5.9273E-4,6.2559E-4,6.4376E-4,8.5233E-4,0.0011067,5.8072E-4,6.4659E-4,6.7677E-4,8.9602E-4,0.0011531,5.357E-4,5.1142E-4,4.5746E-4,4.8673E-4,8.6791E-4,3.7308E-4,4.2942E-4,4.5418E-4,4.5105E-4,8.5708E-4,3.8271E-4,4.2451E-4,4.2495E-4,4.603E-4,8.5438E-4,3.751E-4,4.2165E-4,4.1751E-4,4.4346E-4,8.3603E-4,3.7779E-4,4.2894E-4,5.8033E-4,0.0013348,9.284E-4,3.7375E-4,4.42E-4,4.1773E-4,4.6994E-4,8.3938E-4,3.9686E-4,4.091E-4,4.1769E-4,4.5545E-4,8.484E-4,3.8591E-4,4.2365E-4,4.1931E-4,4.3849E-4,8.5055E-4,3.8866E-4,4.1085E-4,4.1091E-4,4.6524E-4,8.6077E-4,3.6455E-4,4.2153E-4,4.2558E-4,4.4658E-4,8.4379E-4,3.6831E-4,4.1275E-4,4.1916E-4,4.4693E-4,0.0010372,3.9552E-4,4.1339E-4,4.9236E-4,4.6226E-4,8.7607E-4,3.8145E-4,4.5005E-4,4.2448E-4,4.4686E-4,9.1598E-4,3.7193E-4,4.1971E-4,4.1713E-4,4.5519E-4,8.6859E-4,3.9166E-4,4.3011E-4,4.1653E-4,4.731E-4,8.8962E-4,3.646E-4,4.3133E-4,4.3853E-4,4.4203E-4,8.353E-4,3.7782E-4,4.1382E-4,4.0906E-4,4.3837E-4,8.6957E-4,3.6517E-4,4.1316E-4,4.299E-4,4.4468E-4,8.4513E-4,3.8468E-4,4.0965E-4,4.0949E-4,4.44E-4,8.5794E-4,3.7747E-4,4.1179E-4,4.2262E-4,4.3475E-4,9.5841E-4,3.955E-4,4.2945E-4,4.4454E-4,5.0693E-4,8.9022E-4,4.0039E-4,4.8795E-4,4.6491E-4,4.2888E-4,8.4676E-4,3.6724E-4,4.2046E-4,4.2474E-4,4.3236E-4,8.5276E-4,3.7613E-4,4.1172E-4,4.2112E-4,4.3335E-4,8.6005E-4,3.6848E-4,4.1656E-4,4.276E-4,4.4E-4,8.463E-4,3.6087E-4,4.2074E-4,4.2954E-4,4.3372E-4,8.5638E-4,3.7161E-4,4.0621E-4,4.1217E-4:7
-1.5193E-5,-3.1593E-5,-1.3093E-5,-3.1063E-5,-3.0317E-5,-1.383E-5,-2.8127E-5,-1.1047E-5,-2.552E-5,-3.1103E-5,-1.4027E-5,-2.593E-5,-7.8567E-6,-2.4247E-5,-3.2443E-5,-1.2733E-5,-2.9283E-5,-1.2163E-5,-2.4447E-5,-3.2603E-5,-1.4257E-5,-2.7067E-5,-1.4867E-5,-2.663E-5,-3.3663E-5,-1.4E-5,-2.7537E-5,-1.3417E-5,-2.4393E-5,-3.5287E-5,-1.2847E-5,-2.974E-5,-9.8333E-6,-2.7103E-5,-2.729E-5,-1.244E-5,-2.897E-5,-8.2267E-6,-2.5717E-5,-3.079E-5,-1.4543E-5,-3.0183E-5,-7.6833E-6,-2.5073E-5,-3.5227E-5,-1.4293E-5,-2.8267E-5,-1.1387E-5,-2.1763E-5,-3.666E-5,-1.5837E-5,-2.9313E-5,-1.537E-5,-2.2797E-5,-3.5127E-5,-1.5067E-5,-2.606E-5,-1.0933E-5,-4.64E-6,-1.82E-5,5.1E-7,-1.3323E-5,9.2433E-6,1.2627E-5,-2.0867E-5,7.73E-6,-1.295E-5,6.62E-6,-1.7253E-5,-2.5283E-5,-8.6567E-6,-2.575E-5,-8.9467E-6,-1.59E-5,-2.6147E-5,-1.1533E-5,-2.453E-5,-6.7533E-6,-1.1523E-5,-2.6917E-5,-1.338E-5,-2.5517E-5,-9.3367E-6,-1.929E-5,-2.937E-5,-9.3633E-6,-2.568E-5,-6.9067E-6,-1.928E-5,-2.9007E-5,-9.9967E-6,-2.4033E-5,-8.7833E-6,-1.5393E-5,-3.047E-5,-6.75E-6,-2.5447E-5,-8.3133E-6,-1.7797E-5,-3.1563E-5,-8.6433E-6,-2.086E-5,-4.51E-6,-1.8577E-5,-2.6127E-5,-8.4567E-6,-1.8963E-5,-1.136E-5,-1.671E-5,-2.961E-5,-8.69E-6,-2.4427E-5,-8.0933E-6,-2.0193E-5,-3.219E-5,-1.2403E-5,-2.5957E-5,0.0043404,0.004074,-7.6763E-5,8.49E-5,-6.8263E-5,3.2667E-5,-1.1957E-5,-3.074E-5,-4.3133E-6,-2.638E-5,-3.8433E-6,-2.021E-5,-3.6853E-5,-1.2717E-5,-3.067E-5,-9.77E-6,-2.7897E-5,-3.368E-5,-1.405E-5,-2.521E-5,-1.2253E-5,-2.6073E-5,-3.2647E-5,-9.5033E-6,-3.074E-5,-1.1903E-5,-2.4923E-5,-3.579E-5,-1.1397E-5,-2.7023E-5,-1.4173E-5,-2.891E-5,-3.6057E-5,-1.4693E-5,-2.6493E-5,-1.108E-5,-2.448E-5,-3.665E-5,-1.2713E-5,-2.5633E-5,-7.9933E-6,-2.557E-5,-3.394E-5,-1.4533E-5,-2.7243E-5,-1.2653E-5,-2.6267E-5,-3.0507E-5,-1.4217E-5,-2.4967E-5,-1.0457E-5,-2.3987E-5,-3.6587E-5,-1.1433E-5,-2.9687E-5,3.3423E-4,7.917E-4,3.4785E-4,3.8695E-4,3.7673E-4,4.4142E-4,8.652E-4,3.826E-4,4.0512E-4,3.8744E-4,4.1747E-4,8.7122E-4,3.6482E-4,3.8009E-4,3.8061E-4,4.4593E-4,9.2462E-4,4.0982E-4,3.9196E-4,3.8941E-4,4.2228E-4,8.4049E-4,3.6561E-4,3.8397E-4,3.9352E-4,4.2938E-4,8.4158E-4,3.9907E-4,4.1128E-4,3.8861E-4,4.0917E-4,8.3843E-4,3.5756E-4,3.8159E-4,4.0289E-4,4.2751E-4,8.9859E-4,4.2583E-4,4.3862E-4,4.6492E-4,4.7952E-4,0.0010622,4.5465E-4,4.4488E-4,4.3243E-4,5.0313E-4,0.0010011,4.1478E-4,4.796E-4,4.6159E-4,4.6213E-4,0.0010606,5.064E-4,4.6329E-4,4.772E-4,4.7711E-4,0.0010091,4.852E-4,5.0732E-4,5.5301E-4,5.0663E-4,0.0010566,4.5892E-4,4.5122E-4,4.988E-4,5.3241E-4,0.0010512,4.2511E-4,5.0606E-4,4.8763E-4,5.2183E-4,0.0011702,5.5926E-4,5.4911E-4,6.4813E-4,9.4882E-4,0.0022258,0.0012429,7.1111E-4,5.9546E-4,6.2316E-4,0.0012028,5.3385E-4,5.6699E-4,5.8307E-4,6.1353E-4,0.0012033,5.2593E-4,5.6725E-4,6.1427E-4,6.2869E-4,0.0012003,5.2457E-4,5.5828E-4,5.832E-4,6.1158E-4,0.0011915,5.1984E-4,5.6667E-4,6.105E-4,6.2575E-4,0.0011065,3.6064E-4,3.9703E-4,4.1036E-4,4.4113E-4,8.4406E-4,3.7901E-4,4.0029E-4,4.2679E-4,6.3167E-4,9.4968E-4,3.9269E-4,4.1896E-4,4.3039E-4,4.7328E-4,8.9296E-4,3.7275E-4,4.3077E-4,4.4047E-4,4.564E-4,9.2692E-4,3.8669E-4,4.1834E-4,4.2826E-4,4.5287E-4,9.1347E-4,3.899E-4,4.2654E-4,4.2307E-4,4.6987E-4,9.1164E-4,3.9849E-4,4.1178E-4,4.1022E-4,4.4473E-4,8.667E-4,3.7681E-4,4.1659E-4,4.1779E-4,4.6844E-4,0.0010061,3.7439E-4,4.0218E-4,4.04E-4,4.4369E-4,8.7433E-4,3.6438E-4,4.1831E-4,4.1594E-4,4.5076E-4,9.0458E-4,4.0295E-4,4.0524E-4,4.1579E-4,4.4772E-4,8.9882E-4,3.6699E-4,4.1438E-4,4.2132E-4,4.3958E-4,9.0683E-4,3.5658E-4,4.0086E-4,4.1171E-4,4.4567E-4,8.7983E-4,3.5753E-4,4.0734E-4,4.1586E-4,4.3593E-4,9.3475E-4,3.5647E-4,3.9362E-4,3.8454E-4,4.2525E-4,8.2326E-4,3.4085E-4,3.9739E-4,3.8572E-4,4.0465E-4,8.9568E-4,3.4013E-4,3.8042E-4,3.8498E-4,4.2196E-4,8.2884E-4,3.3287E-4,3.9058E-4,4.0864E-4,4.0769E-4,8.9491E-4,3.4551E-4,3.7363E-4,3.9278E-4,4.1836E-4,8.1966E-4,3.5284E-4,3.8909E-4,3.8174E-4,4.0692E-4,8.691E-4,3.578E-4,3.7762E-4,3.8804E-4,4.1523E-4,8.4196E-4,3.5153E-4,3.8512E-4,3.8519E-4,4.2516E-4,8.8885E-4,3.5623E-4,3.8805E-4,3.9611E-4,4.1286E-4,8.2298E-4,3.2703E-4,3.8618E-4,3.914E-4,4.0832E-4,8.777E-4,3.6031E-4,3.9198E-4,3.8716E-4,4.0946E-4,8.4806E-4,3.2957E-4,3.975E-4,3.9374E-4,4.1241E-4,8.433E-4,3.6522E-4,3.9432E-4,3.8146E-4,4.1541E-4,8.3286E-4,3.1726E-4,3.896E-4,3.9517E-4,4.129E-4,8.4476E-4,3.7709E-4,4.0407E-4,3.8103E-4,4.1244E-4,8.3021E-4,3.2793E-4,3.9589E-4,3.8281E-4,3.9315E-4,8.3495E-4,3.5987E-4,4.0367E-4,3.8218E-4,4.1377E-4,8.3534E-4,3.5032E-4,3.9343E-4,3.8687E-4,4.0466E-4,8.2364E-4,3.473E-4,4.0582E-4,3.9163E-4,4.9913E-4,0.0011056,3.3476E-4,3.8988E-4,3.9078E-4,4.1881E-4,8.5237E-4,3.4426E-4,4.0453E-4,4.1605E-4,4.1248E-4,8.2107E-4,5.9014E-4,5.9091E-4,5.721E-4,6.2282E-4,0.0011737,5.1165E-4,5.7436E-4,6.1007E-4,6.2605E-4,0.0011693,5.1236E-4,5.5756E-4,5.8517E-4,6.2972E-4,0.0011732,5.0649E-4,5.6966E-4,6.1042E-4,6.3796E-4,0.0011642,5.1068E-4,5.6131E-4,5.8586E-4,6.2751E-4,0.001172,5.1324E-4,5.5898E-4,6.1046E-4,6.4611E-4,0.0011656,5.1244E-4,5.6206E-4,5.8684E-4,6.3099E-4,0.0011725,5.1285E-4,5.6049E-4,6.0461E-4,6.5545E-4,0.0011606,5.1423E-4,5.5887E-4,5.8252E-4,6.3198E-4,0.0011599,5.1157E-4,5.5656E-4,5.9733E-4,6.6512E-4,0.001158,5.1589E-4,5.627E-4,5.8521E-4,6.2968E-4,0.0011635,5.1245E-4,5.5596E-4,5.8845E-4,6.6576E-4,0.0010132,3.5322E-4,4.0646E-4,4.113E-4,4.207E-4,9.622E-4,3.5273E-4,3.7802E-4,4.0214E-4,4.6371E-4,8.4636E-4,3.6088E-4,4.0554E-4,4.0431E-4,4.1046E-4,8.5637E-4,3.4658E-4,3.8788E-4,3.9366E-4,4.5081E-4,8.5835E-4,3.6378E-4,4.0497E-4,3.9519E-4,4.1545E-4,8.4545E-4,3.4736E-4,3.9038E-4,3.9024E-4,4.3157E-4,8.535E-4,3.4299E-4,3.9684E-4,3.8636E-4,4.2256E-4,8.6186E-4,3.4489E-4,3.9534E-4,4.045E-4,4.2593E-4,8.5864E-4,3.5587E-4,3.8978E-4,3.8627E-4,4.1478E-4,8.2845E-4,3.3735E-4,3.8845E-4,3.8596E-4,4.4135E-4,8.7274E-4,3.4219E-4,3.9068E-4,3.9954E-4,4.2969E-4,0.0010288,5.2078E-4,5.4718E-4,5.9051E-4,6.6033E-4,0.001165,5.1116E-4,5.5712E-4,5.8559E-4,6.6276E-4,0.0011319,5.0845E-4,5.5678E-4,5.8406E-4,6.6627E-4,0.0011651,5.1889E-4,5.6093E-4,5.8785E-4,6.63E-4,0.0011336,5.0799E-4,5.6038E-4,5.8327E-4,6.6598E-4,0.0011512,5.2694E-4,5.6589E-4,5.8815E-4,6.5148E-4,0.0011486,5.1491E-4,5.5792E-4,5.8656E-4,6.6592E-4,0.0011393,5.2392E-4,4.661E-4,3.9618E-4,4.149E-4,8.5619E-4,3.3871E-4,3.9541E-4,3.9906E-4,4.3604E-4,8.2421E-4,3.8954E-4,4.071E-4,3.9012E-4,4.1661E-4,8.6575E-4,3.4863E-4,3.8653E-4,3.9476E-4:7
3.1154E-4,4.8288E-4,4.77E-4,2.8875E-4,3.2492E-4,3.1751E-4,4.8885E-4,4.73E-4,2.838E-4,3.2262E-4,3.1291E-4,4.8491E-4,4.6774E-4,2.8938E-4,3.2072E-4,3.0988E-4,5.0582E-4,4.737E-4,2.8786E-4,3.2271E-4,3.1003E-4,4.9575E-4,4.6526E-4,2.9072E-4,3.1981E-4,3.1032E-4,4.9779E-4,4.6007E-4,2.8646E-4,3.2303E-4,3.2172E-4,5.0387E-4,4.6115E-4,2.8871E-4,3.2175E-4,3.1088E-4,5.0322E-4,5.1629E-4,2.9699E-4,3.1576E-4,3.4115E-4,5.1282E-4,4.5712E-4,2.8919E-4,3.2493E-4,3.1013E-4,5.1057E-4,4.4916E-4,3.0803E-4,3.249E-4,3.101E-4,5.1347E-4,4.5145E-4,2.9347E-4,3.2816E-4,3.1242E-4,5.1433E-4,4.4609E-4,2.8329E-4,3.2029E-4,3.1192E-4,5.1551E-4,4.4277E-4,2.8657E-4,3.2267E-4,3.1069E-4,5.1666E-4,4.3986E-4,2.8555E-4,3.1834E-4,3.1089E-4,5.2068E-4,4.4721E-4,2.8242E-4,3.2427E-4,3.4662E-4,5.3421E-4,4.6495E-4,4.2447E-4,4.734E-4,4.5698E-4,8.0751E-4,4.6915E-4,2.9042E-4,3.3481E-4,3.1332E-4,5.3675E-4,4.2207E-4,2.8659E-4,3.2031E-4,3.0906E-4,5.5446E-4,4.4244E-4,2.9251E-4,3.3292E-4,3.1254E-4,5.372E-4,4.2132E-4,2.8832E-4,3.3389E-4,3.1497E-4,5.2903E-4,4.2244E-4,2.8589E-4,3.2771E-4,3.1711E-4,5.3494E-4,4.163E-4,2.8663E-4,3.2026E-4,3.1056E-4,5.3251E-4,4.1486E-4,2.8745E-4,3.2569E-4,3.0902E-4,5.3809E-4,4.1404E-4,2.9206E-4,3.2955E-4,3.1326E-4,5.3719E-4,4.1177E-4,2.9036E-4,3.1959E-4,3.0855E-4,5.6032E-4,4.25E-4,2.9076E-4,3.2871E-4,3.1902E-4,5.5497E-4,4.108E-4,2.8525E-4,3.1906E-4,3.1568E-4,5.5017E-4,4.8886E-4,3.8917E-4,3.4444E-4,3.0673E-4,5.4865E-4,4.0394E-4,2.876E-4,3.2048E-4,3.1095E-4,5.5696E-4,3.9782E-4,3.1546E-4,3.2871E-4,3.1037E-4,5.5473E-4,3.9274E-4,2.8634E-4,3.228E-4,3.1163E-4,5.5568E-4,3.9628E-4,2.866E-4,3.2084E-4,3.1084E-4,5.5686E-4,3.9409E-4,2.8942E-4,3.2148E-4,3.0974E-4,5.5924E-4,3.8806E-4,2.8486E-4,3.2126E-4,3.093E-4,5.62E-4,4.6734E-4,3.0883E-4,3.1879E-4,3.2145E-4,5.7654E-4,3.8427E-4,2.8843E-4,3.3244E-4,3.3651E-4,5.6964E-4,5.0349E-4,4.2634E-4,4.5764E-4,4.6304E-4,7.6872E-4,3.8937E-4,2.9466E-4,3.2657E-4,3.1077E-4,6.1186E-4,3.8321E-4,2.902E-4,3.2447E-4,3.2452E-4,5.7583E-4,3.7879E-4,2.8562E-4,3.1658E-4,3.087E-4,5.6842E-4,3.7261E-4,2.8785E-4,3.2907E-4,3.1678E-4,5.686E-4,3.8412E-4,2.9913E-4,3.386E-4,3.2812E-4,5.911E-4,3.7292E-4,2.9676E-4,3.3113E-4,3.1307E-4,5.9126E-4,3.789E-4,2.9634E-4,3.4847E-4,3.2139E-4,5.9643E-4,3.7571E-4,2.9492E-4,3.3209E-4,3.2013E-4,6.0343E-4,3.7139E-4,2.9059E-4,3.3325E-4,3.2088E-4,5.9754E-4,3.8653E-4,3.0245E-4,3.2735E-4,3.1363E-4,5.9118E-4,4.2521E-4,3.1822E-4,3.3987E-4,3.2384E-4,6.0245E-4,3.7051E-4,2.9876E-4,3.2915E-4,3.1562E-4,6.0136E-4,3.6075E-4,3.016E-4,3.3451E-4,3.1749E-4,5.9639E-4,3.5616E-4,2.9325E-4,3.2515E-4,3.1673E-4,5.9635E-4,3.5656E-4,2.9036E-4,3.2474E-4,3.1453E-4,5.9764E-4,3.4976E-4,2.9423E-4,3.2822E-4,3.1689E-4,6.1764E-4,3.5423E-4,2.9226E-4,3.2244E-4,3.124E-4,6.0542E-4,3.7526E-4,3.0583E-4,3.2732E-4,3.1391E-4,5.9308E-4,3.4431E-4,2.8646E-4,3.2386E-4,3.2078E-4,6.3122E-4,3.4611E-4,2.8982E-4,3.2166E-4,3.0975E-4,6.6189E-4,5.005E-4,4.2976E-4,4.8996E-4,4.6345E-4,7.1375E-4,3.5302E-4,2.9867E-4,3.2975E-4,3.2827E-4,3.1894E-4:7
3.5929E-4,2.8798E-4,3.2316E-4,3.0953E-4,5.9949E-4,3.6047E-4,2.9331E-4,3.2536E-4,3.1108E-4,5.945E-4,3.5446E-4,2.8494E-4,3.2125E-4,3.1215E-4,6.004E-4,3.4839E-4,2.9039E-4,3.2485E-4,3.1458E-4,6.0456E-4,3.4555E-4,2.9152E-4,3.2516E-4,3.1411E-4,6.0311E-4,3.4322E-4,2.9093E-4,3.2367E-4,3.1104E-4,6.0376E-4,3.5168E-4,2.9146E-4,3.2679E-4,3.1117E-4,6.9539E-4,4.936E-4,4.3777E-4,4.781E-4,4.6267E-4,7.0065E-4,3.4368E-4,2.9418E-4,3.2803E-4,3.1702E-4,6.1039E-4,3.3386E-4,2.9205E-4,3.221E-4,3.1107E-4,6.1536E-4,3.6072E-4,2.9745E-4,3.2429E-4,3.1155E-4,6.1653E-4,3.374E-4,2.8907E-4,3.2867E-4,3.1034E-4,6.1221E-4,3.3183E-4,2.8908E-4,3.2315E-4,3.1322E-4,6.1721E-4,3.3847E-4,2.9188E-4,3.2711E-4,3.1189E-4,6.2495E-4,3.2655E-4,2.9375E-4,3.2669E-4,3.0875E-4,6.3268E-4,3.2927E-4,2.927E-4,3.2981E-4,3.0558E-4,6.2166E-4,3.3293E-4,2.9549E-4,3.243E-4,3.1613E-4,6.1994E-4,3.2286E-4,2.8788E-4,3.2433E-4,3.1017E-4,6.1665E-4,3.2108E-4,2.9145E-4,3.2668E-4,3.1647E-4,6.2085E-4,3.1822E-4,3.02E-4,3.3088E-4,3.3652E-4,6.2236E-4,3.1566E-4,2.8947E-4,3.247E-4,3.078E-4,6.2648E-4,3.2428E-4,2.8985E-4,3.2566E-4,3.0889E-4,6.2552E-4,3.3474E-4,2.923E-4,3.2116E-4,3.1146E-4,6.2314E-4,3.295E-4,2.9702E-4,3.2712E-4,3.1334E-4,6.4323E-4,3.1566E-4,2.9775E-4,3.2445E-4,3.0991E-4,6.27E-4,3.1139E-4,2.9524E-4,3.2605E-4,3.0999E-4,6.2441E-4,3.1624E-4,2.9342E-4,3.2547E-4,3.1139E-4,6.3729E-4,3.0941E-4,2.8997E-4,3.3565E-4,3.337E-4,8.139E-4,4.6648E-4,4.294E-4,4.7614E-4,4.6177E-4,6.5295E-4,3.1535E-4,2.9609E-4,3.3215E-4,3.1333E-4,6.2926E-4,3.2849E-4,3.0024E-4,3.2363E-4,3.1135E-4,6.5897E-4,3.1144E-4,2.9428E-4,3.2881E-4,3.1022E-4,6.3502E-4,3.0288E-4,2.9049E-4,3.24E-4,3.0971E-4,6.3429E-4,3.065E-4,2.9324E-4,3.2406E-4,3.0683E-4,6.2765E-4,3.0258E-4,2.9221E-4,3.2775E-4,3.1162E-4,6.3543E-4,3.0191E-4,3.2263E-4:7
3.2631E-4,3.3987E-4,6.0907E-4,3.0143E-4,2.9278E-4,3.248E-4,3.3463E-4,6.051E-4,3.0498E-4,2.9689E-4,3.2179E-4,3.4181E-4,6.0151E-4,3.0062E-4,2.8936E-4,3.2122E-4,3.4455E-4,5.9239E-4,3.2244E-4,2.9979E-4,3.2501E-4,3.5243E-4,6.0732E-4,3.0394E-4,2.9149E-4,3.2757E-4,3.5436E-4,5.8141E-4,3.0021E-4,2.9561E-4,3.2687E-4,3.6193E-4,5.7059E-4,3.0008E-4,2.9705E-4,3.2701E-4,3.7118E-4,5.7475E-4,2.9809E-4,2.9262E-4,3.2481E-4,4.0084E-4,5.6802E-4,3.2033E-4,3.0753E-4,3.4408E-4,4.5631E-4,5.8285E-4,3.0621E-4,3.0713E-4,3.341E-4,3.9108E-4,5.6135E-4,3.0414E-4,2.9626E-4,3.5351E-4,4.0276E-4,5.5002E-4,3.0819E-4,3.0422E-4,3.3022E-4,4.0774E-4,5.4587E-4,3.0452E-4,3.0047E-4,3.2867E-4,4.1082E-4,5.3826E-4,3.0364E-4,3.1047E-4,3.4419E-4,4.4008E-4,5.2758E-4,2.9854E-4,2.9438E-4,3.2721E-4,4.3222E-4,5.4007E-4,3.1818E-4,3.0529E-4,3.342E-4,4.2749E-4,5.2293E-4,3.082E-4,3.1942E-4,3.375E-4,4.44E-4,5.0892E-4,3.0719E-4,3.0285E-4,3.2733E-4,4.4149E-4,4.9646E-4,3.0277E-4,3.0206E-4,4.7772E-4,7.2355E-4,6.5517E-4,4.5825E-4,3.6304E-4,3.4266E-4,4.8698E-4,4.9567E-4,3.0321E-4,2.953E-4,3.2393E-4,4.5026E-4,4.9466E-4,3.1506E-4,2.9606E-4,3.3169E-4,4.6065E-4,4.8054E-4,3.0562E-4,2.9728E-4,3.2249E-4,4.5818E-4,4.7501E-4,3.0567E-4,3.0149E-4,3.4692E-4,4.7123E-4,5.3151E-4,3.8146E-4,3.212E-4,3.4886E-4,4.9069E-4,4.6974E-4,3.1146E-4,3.0503E-4,3.3282E-4,4.8359E-4,4.6566E-4,3.1239E-4,3.0771E-4,3.4142E-4,5.0273E-4,4.6272E-4,3.2315E-4,4.1207E-4,5.06E-4,6.643E-4,5.2056E-4,3.0997E-4,3.053E-4,3.3871E-4,5.0928E-4,4.5179E-4,3.1014E-4,3.0461E-4,3.3836E-4,5.1853E-4,4.5214E-4,3.0941E-4,2.9845E-4,3.2667E-4,5.2519E-4,4.3348E-4,3.1272E-4,3.0259E-4,3.2524E-4,5.0585E-4,4.264E-4,3.0487E-4,2.9752E-4,3.2599E-4,5.497E-4,4.7499E-4,3.1284E-4,3.0419E-4,3.2824E-4,5.165E-4,4.1933E-4,3.05E-4,3.0088E-4,3.325E-4,5.1445E-4,4.133E-4,3.0447E-4,3.0158E-4,3.485E-4,5.4633E-4,4.0206E-4,3.0897E-4,3.0582E-4,3.2678E-4,5.2892E-4,4.0294E-4,3.0709E-4,3.001E-4,3.2641E-4,5.2825E-4,3.9417E-4,3.0182E-4,2.9866E-4,3.2903E-4,5.3617E-4,3.9184E-4,3.0608E-4,3.7799E-4,4.7742E-4,8.4892E-4,5.5706E-4,4.1238E-4,3.2527E-4,3.4372E-4,5.6734E-4,3.9924E-4,3.3366E-4,3.1532E-4,3.3251E-4,5.6102E-4,3.8236E-4,3.1167E-4,3.0414E-4,3.308E-4,5.5744E-4,3.8526E-4,3.0929E-4,3.0475E-4,3.3569E-4,5.9456E-4,3.932E-4,3.151E-4,3.028E-4,3.3593E-4,5.6238E-4,3.7893E-4,3.0875E-4,3.0546E-4,3.3476E-4,5.893E-4,3.6384E-4,3.062E-4,3.0332E-4,3.2986E-4,5.7113E-4,3.6609E-4,3.0624E-4,3.0223E-4,3.297E-4,5.9698E-4,3.5558E-4,3.0434E-4,3.0113E-4,3.2287E-4,5.75E-4,3.595E-4,3.0494E-4,3.0131E-4,3.3162E-4,5.7033E-4,3.4638E-4,3.0446E-4,3.0105E-4,3.2786E-4,6.1164E-4,3.5472E-4,3.1347E-4,2.9929E-4,3.2927E-4,5.8589E-4,3.4139E-4,3.1136E-4,2.9804E-4,3.2451E-4,5.8179E-4,3.4047E-4,3.096E-4,3.0152E-4,3.2698E-4,5.8776E-4,3.7215E-4,3.8089E-4,3.2191E-4,3.2845E-4,5.9038E-4,3.3802E-4,3.1073E-4,3.0126E-4,3.328E-4,5.9056E-4,3.3263E-4,3.0597E-4,3.1768E-4,3.3304E-4,5.9893E-4,3.2769E-4,3.0784E-4,3.0114E-4,3.259E-4,5.9539E-4,3.236E-4,3.0775E-4,3.0107E-4,3.2938E-4,5.9889E-4,3.2332E-4,3.0673E-4,3.0266E-4,3.3009E-4,6.5047E-4,3.1877E-4,3.631E-4,4.335E-4,5.0014E-4,8.8839E-4,4.315E-4,3.3541E-4,3.0323E-4,3.3328E-4,6.2154E-4,3.1375E-4,3.0912E-4,3.0346E-4,3.2531E-4,6.0975E-4,3.1372E-4,3.0903E-4,3.164E-4,3.3159E-4,6.1145E-4,3.3633E-4,3.1421E-4,3.0154E-4,3.3078E-4,6.1029E-4,3.0964E-4,3.1108E-4,3.0114E-4,3.226E-4,6.1215E-4,3.0435E-4,3.1097E-4,3.0043E-4,3.2619E-4,6.2218E-4,3.0116E-4,3.0974E-4,3.0005E-4,4.4054E-4,8.29E-4,3.3308E-4,3.6525E-4,3.4686E-4,4.2276E-4,6.6454E-4,3.0887E-4,3.144E-4,3.2289E-4,3.3745E-4,6.288E-4,3.0002E-4,3.162E-4,3.0919E-4,3.4042E-4,6.691E-4,3.2092E-4,3.256E-4,3.1221E-4,3.3591E-4,6.4453E-4,3.0354E-4,3.2185E-4,3.0907E-4,3.3162E-4,6.3768E-4,3.0183E-4,3.1401E-4,3.1742E-4,3.3701E-4,6.5206E-4,2.9881E-4,3.1484E-4,3.0544E-4,3.3019E-4,6.1981E-4,2.8788E-4,3.0978E-4,3.0597E-4,3.3575E-4,6.2236E-4,2.8764E-4,3.0973E-4,3.0883E-4,3.2724E-4,6.3307E-4,2.8542E-4,3.0957E-4,3.03E-4,3.2573E-4,6.278E-4,2.8153E-4,3.0829E-4,3.0526E-4,3.8987E-4,7.16E-4,2.933E-4,3.1762E-4,3.1901E-4,3.4222E-4,7.0045E-4,3.0769E-4,3.285E-4,3.1446E-4,3.3769E-4,6.4075E-4,3.1774E-4,4.5328E-4,4.6379E-4,5.0856E-4,9.2759E-4,3.1088E-4,3.2093E-4,3.2263E-4,3.3939E-4,6.501E-4,2.9084E-4,3.2033E-4,3.1405E-4,3.3613E-4,6.4904E-4,3.0124E-4,3.2082E-4,3.4082E-4,3.4255E-4,6.4363E-4,2.8828E-4,3.1949E-4,3.1137E-4,3.4767E-4,6.6256E-4,2.842E-4,3.1641E-4,3.078E-4,3.3353E-4,2.9366E-4:7
2.309E-4,2.5868E-4,2.3297E-4,2.2759E-4,2.6404E-4,5.0699E-4,6.3653E-4,4.2862E-4,2.6935E-4,2.6165E-4,3.7936E-4,5.5369E-4,4.7869E-4,3.4222E-4,2.8874E-4,4.5961E-4,5.9279E-4,4.1854E-4,2.7518E-4,2.6743E-4,3.8388E-4,4.8798E-4,3.8451E-4,3.1311E-4,3.1252E-4,4.0234E-4,5.0265E-4,3.8867E-4,3.0727E-4,3.032E-4,3.718E-4,2.7017E-4,1.316E-4,9.757E-5,1.2125E-4,2.1196E-4,2.8366E-4,2.0977E-4,1.6206E-4,1.6396E-4,2.1823E-4,2.6437E-4,2.3253E-4,1.8751E-4,2.4834E-4,3.7816E-4,2.7109E-4,1.3304E-4,6.25E-6,-6.79E-6,-2.76E-6,-7.2533E-6,-1.047E-5,-9.2933E-6,-4.86E-6,1.8715E-4,0.0020994,6.223E-4,2.638E-5,3.2541E-4,3.1213E-4,2.5867E-4,1.0193E-4,3.56E-5,5.7787E-5,1.1846E-4,2.7083E-4,4.4467E-4,4.6976E-4,4.1765E-4,4.0043E-4,3.891E-4,2.9427E-4,1.4286E-4,1.0974E-4,1.2301E-4,1.4875E-4,1.6317E-4,2.1407E-4,2.7293E-4,2.9876E-4,2.1919E-4,1.1904E-4,9.3127E-5,1.1571E-4,1.8881E-4,3.0137E-4,2.4744E-4,1.8151E-4,1.8293E-4,2.1438E-4,1.9823E-4,5.6663E-5,-9.43E-6,-3.99E-6,-5.0633E-6,-6.7267E-6,-1.09E-5,1.7079E-4,3.0117E-4,0.0017113,0.001167,3.4382E-4,3.8901E-4,3.5175E-4,4.4198E-4,2.6265E-4,1.6517E-4,2.2487E-4,3.503E-4,5.0299E-4,5.3611E-4,3.612E-4,2.6746E-4,2.8721E-4,4.021E-4,4.8995E-4,4.5132E-4,4.2312E-4,3.7462E-4,3.8439E-4,3.8824E-4,3.7044E-4,3.2708E-4,3.2005E-4,4.0409E-4,5.8581E-4,4.9536E-4,3.0524E-4,2.6134E-4,3.3483E-4,4.6678E-4,4.1107E-4,3.0985E-4,2.938E-4,3.7975E-4,4.6102E-4,3.8142E-4,3.1072E-4,3.1875E-4,3.9875E-4,4.5997E-4,3.6909E-4,3.0748E-4,3.1428E-4,3.8574E-4,4.7092E-4,3.9857E-4,3.0604E-4,3.074E-4,4.5639E-4,5.7805E-4,4.233E-4,2.8334E-4,2.8003E-4,3.8634E-4,4.8785E-4,4.0467E-4,3.1643E-4,3.1477E-4,3.7971E-4,4.5413E-4,3.9721E-4,3.1822E-4,3.1005E-4,3.8899E-4,4.6708E-4,3.9423E-4,3.1977E-4,3.2102E-4,3.8982E-4,4.7148E-4,3.9304E-4,3.1232E-4,3.233E-4,3.6156E-4,1.2247E-5,-5.2067E-6,-1.243E-5,1.4635E-4,3.0744E-4,6.2206E-4,2.9126E-4,2.9318E-4,2.989E-4,3.1489E-4,6.1357E-4,2.7985E-4,2.9934E-4,2.9415E-4,3.1889E-4,6.2236E-4,2.7984E-4,2.9926E-4,3.0036E-4,3.2197E-4,6.2292E-4,2.8184E-4,2.9918E-4,2.9796E-4,3.1639E-4,6.1522E-4,7.0298E-4,0.0020738,5.3623E-4,4.852E-4,4.6261E-4,3.3598E-4,2.7215E-4,2.3362E-4,1.6647E-4,3.3582E-4,4.7227E-4,4.1323E-4,3.8125E-4,5.016E-4,5.979E-4,3.9406E-4,3.051E-4,3.6239E-4,4.3439E-4,4.514E-4,3.6405E-4,3.0525E-4,3.0802E-4,3.8245E-4,5.2971E-4,5.8985E-4,3.8395E-4,2.6883E-4,2.9461E-4,4.0905E-4,4.3147E-4,3.3965E-4,3.0715E-4,3.5406E-4,5.346E-4,7.3976E-4,4.9883E-4,2.9406E-4,2.8116E-4,3.9456E-4,4.7783E-4,3.6558E-4,3.077E-4,3.2741E-4,5.0037E-4,5.7034E-4,3.915E-4,2.7959E-4,2.999E-4,4.0053E-4,4.2041E-4,3.4088E-4,3.2734E-4,5.0361E-4,6.0782E-4,4.0518E-4,2.6666E-4,2.6646E-4,3.6476E-4,4.6871E-4,4.1561E-4,3.1039E-4,2.9463E-4,3.6881E-4,4.7588E-4,4.28E-4,4.0294E-4,4.0199E-4,4.0377E-4,4.1584E-4,3.7199E-4,3.1609E-4,3.0262E-4,3.6795E-4,4.5927E-4,4.247E-4,4.4429E-4,4.571E-4,4.2009E-4,3.9835E-4,3.5461E-4,3.1091E-4,3.1642E-4,3.7929E-4,4.3892E-4,4.0573E-4,4.2643E-4,4.2321E-4,4.1253E-4,4.216E-4,3.6805E-4,3.2233E-4,3.1222E-4,3.5278E-4,4.3201E-4,4.1908E-4,4.4359E-4,4.3864E-4,4.1892E-4,4.1295E-4,3.4803E-4,3.001E-4,3.0886E-4,3.8445E-4,4.9349E-4,4.4319E-4,4.6131E-4,4.4362E-4,4.1903E-4,4.2986E-4,4.3247E-4,3.2557E-4,2.9655E-4,3.4716E-4,4.4607E-4,4.2788E-4,4.4589E-4,4.2017E-4,3.9769E-4,4.0649E-4,3.7321E-4,3.2915E-4,3.4125E-4,4.3726E-4,4.7497E-4,3.9366E-4,3.8247E-4,3.8087E-4,4.1231E-4,5.7566E-4,6.0326E-4,2.0777E-5:7
2.7808E-4,2.0478E-4,1.7026E-4,2.7741E-4,4.7125E-4,3.1306E-4,1.8529E-4,1.6255E-4,2.1216E-4,2.3386E-4,1.8668E-4,1.6639E-4,1.8221E-4,2.3233E-4,2.2868E-4,3.4499E-4,3.8414E-4,3.0038E-4,1.8329E-4,1.1307E-4,8.6613E-5,1.6391E-4,4.2698E-4,6.6162E-4,4.7924E-4,4.0565E-4,3.9658E-4,3.9994E-4,4.2622E-4,3.8328E-4,3.1897E-4,3.0836E-4,3.6986E-4,4.5148E-4,4.3206E-4,4.7107E-4,4.5673E-4,4.519E-4,4.1041E-4,3.3899E-4,3.1089E-4,3.2846E-4,3.9712E-4,4.727E-4,4.6679E-4,4.9374E-4,4.3748E-4,3.9727E-4,3.6866E-4,3.4581E-4,3.2938E-4,3.5414E-4,4.7961E-4,6.2918E-4,5.7667E-4,3.3819E-4,2.6282E-4,3.1464E-4,4.5453E-4,4.229E-4,3.2461E-4,3.034E-4,3.6074E-4,4.5041E-4,4.3147E-4,4.6564E-4,4.3942E-4,4.2118E-4,3.9114E-4,3.7218E-4,3.3004E-4,3.4074E-4,3.9996E-4,4.4961E-4,4.0887E-4,4.6231E-4,4.5202E-4,4.2341E-4,3.8189E-4,3.3747E-4,3.1348E-4,3.3048E-4,3.9341E-4,4.6065E-4,4.252E-4,5.1437E-4,4.579E-4,4.0325E-4,3.758E-4,3.4087E-4,3.3252E-4,3.3782E-4,3.8308E-4,4.4885E-4,4.3461E-4,4.7298E-4,4.3519E-4,4.0582E-4,3.5918E-4,2.0129E-4,1.1363E-4,1.2198E-4,2.0235E-4,3.0417E-4,2.8205E-4,1.912E-4,1.5311E-4,1.6574E-4,2.2938E-4,2.2871E-4,1.7219E-4,1.6471E-4,1.9633E-4,2.4002E-4,2.138E-4,1.7885E-4,2.7094E-4,4.3172E-4,5.4671E-4,4.2756E-4,2.7817E-4,2.7472E-4,3.5058E-4,3.1004E-4,1.7754E-4,1.0228E-4,1.146E-4,1.6584E-4,1.0063E-5,-6.9633E-6,-1.0867E-5,-4.2633E-6,-6.7033E-6,4.2357E-5,1.5182E-4,1.3681E-4,1.3679E-4,2.0548E-4,3.3633E-4,1.4009E-4,1.4348E-4,1.5171E-4,1.6457E-4,3.3033E-4,1.4711E-4,1.4829E-4,1.4068E-4,1.5343E-4,3.0247E-4,1.427E-4,1.401E-4,1.4792E-4,1.725E-4,3.3185E-4,1.4611E-4,1.4061E-4,1.4778E-4,1.5218E-4,2.9738E-4,1.4454E-4,1.3698E-4,1.3644E-4,1.5261E-4,2.9047E-4,1.373E-4,1.3985E-4,1.3624E-4,1.4492E-4,2.9562E-4,1.465E-4,1.3056E-4,1.4663E-4,1.5443E-4,2.9773E-4,1.5544E-4,1.3637E-4,1.3938E-4,1.5829E-4,3.0342E-4,1.8042E-4,1.4842E-4,1.6374E-4,1.7795E-4,2.9238E-4,1.5971E-4,1.3899E-4,1.4198E-4,1.528E-4,3.0195E-4,1.531E-4,1.3057E-4,1.3903E-4,1.5422E-4,2.8611E-4,1.7604E-4,1.3679E-4,1.3905E-4,1.48E-4,2.7986E-4,1.5753E-4,1.2916E-4,1.4086E-4,1.4731E-4,2.8314E-4,1.5612E-4,1.3985E-4,1.3666E-4,1.4611E-4,2.7738E-4,1.5528E-4,1.4436E-4,1.3718E-4,1.4239E-4,2.756E-4,1.6185E-4,1.3277E-4,1.4959E-4,1.54E-4,2.8383E-4,1.6945E-4,1.3976E-4,1.4755E-4,1.8655E-4,3.0953E-4,1.9229E-4,1.4634E-4,1.4352E-4,1.4733E-4,2.6408E-4,1.9514E-4,1.339E-4,1.6163E-4,1.5262E-4,2.5179E-4,2.0023E-4,1.4008E-4,1.3877E-4,1.618E-4,2.5453E-4,1.9642E-4,1.2831E-4,1.3196E-4,1.4187E-4,2.3945E-4,1.9157E-4,1.2281E-4,1.3685E-4,1.4246E-4,2.2942E-4,2.0342E-4,1.302E-4,1.3376E-4,1.4671E-4,2.4404E-4,2.1453E-4,1.2925E-4,1.3225E-4,1.427E-4,2.2435E-4,2.0421E-4,1.2736E-4,1.3402E-4,1.4007E-4,2.2773E-4,2.0008E-4,1.3678E-4,1.3431E-4,1.4572E-4,2.203E-4,2.1936E-4,1.3821E-4,1.4225E-4,1.557E-4,2.3039E-4,2.1664E-4,1.3443E-4,1.3674E-4,1.5013E-4,2.0931E-4,2.2289E-4,1.3002E-4,1.7166E-4,2.0769E-4,2.1729E-4,2.3401E-4,1.3099E-4,1.3124E-4,1.4315E-4,1.9293E-4,2.3464E-4,1.2761E-4,1.3411E-4,1.4242E-4,1.9885E-4,2.3404E-4,1.2358E-4,1.3457E-4,1.4351E-4,2.9127E-4,3.239E-4,2.4178E-4,2.4873E-4,2.2846E-4,2.4298E-4,2.641E-4,1.5271E-4,1.476E-4,1.5597E-4,2.0078E-4,2.6982E-4,1.3101E-4,1.3157E-4,2.2044E-4,3.6058E-4,2.6616E-4,1.3878E-4,1.3813E-4,1.4914E-4,2.0799E-4,2.7758E-4,1.3845E-4,1.3434E-4,0.0014463,0.0011825,1.857E-4,1.7809E-4,1.2344E-4,1.5798E-4,1.1681E-4,3.552E-5,1.8453E-5,3.0707E-5,1.095E-4,4.2607E-4,6.654E-4,2.9602E-4,1.1633E-4,7.7E-5,8.7957E-5,1.3587E-4,1.9075E-4,2.0341E-4,2.2794E-4,3.3397E-4,3.9892E-4,2.018E-4,1.1539E-4,1.0601E-4,1.5397E-4,2.1415E-4,7.16E-5,-5.79E-6,-6.2167E-6,-2.9633E-6,-9.7267E-6,7.6063E-5,1.4678E-4,1.5465E-4,2.4061E-4,3.9798E-4,1.9607E-4,1.6238E-4,1.5527E-4,1.6058E-4,4.0884E-4,2.814E-4,1.7732E-4,1.768E-4,1.9069E-4,3.1846E-4,1.3576E-4,1.4563E-4,1.5962E-4,1.6265E-4,3.1968E-4,1.5328E-4,0.0017576,9.3809E-4,2.2988E-4,1.9375E-4,2.01E-4,1.2742E-4,1.7366E-4,7.3587E-5,3.7847E-5,2.9177E-5,1.119E-4,4.5418E-4,5.4043E-4,3.6527E-4:7
1.8899E-4,3.7494E-4,1.8623E-4,1.8372E-4,1.759E-4,1.9172E-4,3.7616E-4,1.8844E-4,1.797E-4,1.7551E-4,1.8942E-4,3.7529E-4,1.8845E-4,1.7773E-4,1.8819E-4,1.98E-4,3.6789E-4,1.8598E-4,1.7928E-4,1.7478E-4,1.9086E-4,3.6446E-4,1.8742E-4,1.788E-4,1.7709E-4,1.9326E-4,3.6782E-4,2.0899E-4,1.8296E-4,1.7124E-4,1.9003E-4,4.024E-4,2.3052E-4,2.2545E-4,3.0391E-4,2.9718E-4,4.3767E-4,2.1403E-4,2.2105E-4,2.0268E-4,2.0524E-4,3.8372E-4,1.9987E-4,1.9023E-4,1.8237E-4,1.8829E-4,3.681E-4,1.9219E-4,1.8485E-4,1.7502E-4,1.8769E-4,3.7523E-4,1.8963E-4,1.8356E-4,1.7441E-4,1.8753E-4,3.78E-4,1.857E-4,1.8044E-4,1.724E-4,1.9156E-4,3.6981E-4,1.8645E-4,1.7752E-4,1.7628E-4,1.8942E-4,3.6776E-4,1.8691E-4,1.7765E-4,1.7379E-4,1.8962E-4,3.7024E-4,1.9821E-4,1.8209E-4,1.747E-4,1.8755E-4,3.6593E-4,1.8873E-4,1.7942E-4,1.7924E-4,2.0074E-4,3.8881E-4,1.8642E-4,1.8375E-4,1.812E-4,1.9223E-4,3.8086E-4,1.9982E-4,1.8285E-4,1.7542E-4,1.9015E-4,3.7012E-4,2.0923E-4,1.9087E-4,1.8287E-4,1.9321E-4,3.8951E-4,1.9736E-4,1.8151E-4,1.9075E-4,1.9982E-4,3.802E-4,1.8678E-4,1.8908E-4,1.9228E-4,2.0173E-4,3.8984E-4,1.8943E-4,1.9178E-4,1.8623E-4,1.976E-4,3.8403E-4,1.8682E-4,1.7813E-4,1.7539E-4,1.9255E-4,3.7435E-4,1.8957E-4,1.7964E-4,1.738E-4,2.6431E-4,5.1215E-4,2.1103E-4,2.6969E-4,2.0895E-4,1.9014E-4,3.8995E-4,2.069E-4,1.9138E-4,1.7432E-4,1.9145E-4,3.7807E-4,2.3081E-4,2.3302E-4,2.3922E-4,3.1688E-4,7.0762E-4,3.231E-4,2.8529E-4,2.6706E-4,3.7578E-4,5.6212E-4,2.3446E-4,2.7985E-4,2.2484E-4,2.0895E-4,4.483E-4,2.0568E-4,2.2633E-4,2.0399E-4,2.24E-4,4.4932E-4,2.0322E-4,2.2096E-4,1.9777E-4,2.2231E-4,4.2467E-4,2.0486E-4,2.12E-4,1.9556E-4,2.1019E-4,4.076E-4,1.929E-4,1.9758E-4,1.8497E-4,2.0049E-4,3.7958E-4,1.9547E-4,1.8633E-4,1.7892E-4,1.9956E-4,3.8374E-4,2.0454E-4,1.8885E-4,1.7938E-4,1.991E-4,3.8097E-4,1.9261E-4,1.832E-4,1.7771E-4,1.9981E-4,3.8124E-4,1.9198E-4,2.0818E-4,2.279E-4,2.3588E-4,3.8104E-4,2.259E-4,2.0188E-4,2.1187E-4,2.4658E-4,4.6665E-4,2.4656E-4,3.0567E-4,3.0023E-4,3.2586E-4,6.581E-4,3.1143E-4,3.3081E-4,3.3183E-4,3.5959E-4,6.3236E-4,2.4716E-4,2.648E-4,2.279E-4,2.611E-4,4.997E-4,2.472E-4,2.4212E-4,2.1636E-4,2.3467E-4,4.6924E-4,2.0658E-4,2.1132E-4,2.1113E-4,2.1282E-4,4.1631E-4,2.1295E-4,2.0073E-4,1.9416E-4,2.106E-4,4.1863E-4,2.0718E-4,2.1048E-4,1.9036E-4,2.0694E-4,4.1272E-4,2.1278E-4,2.0489E-4,1.891E-4,2.0891E-4,4.5224E-4,2.0801E-4,1.9587E-4,2.1834E-4,2.9521E-4,5.1828E-4,2.5134E-4,3.2845E-4,3.2917E-4,3.7767E-4,6.9791E-4,3.4897E-4,3.3164E-4,2.3669E-4,2.3705E-4,4.7443E-4,2.3736E-4,2.43E-4,1.9974E-4,2.5362E-4,4.7082E-4,2.1652E-4,2.204E-4,2.0173E-4,2.0525E-4,4.1281E-4,2.0913E-4,2.031E-4,1.8747E-4,2.0321E-4,3.924E-4,1.9408E-4,-7.9333E-6:7
2.9701E-4,4.1991E-4,2.7439E-4,3.2271E-4,3.4016E-4,5.124E-4,5.4869E-4,2.9614E-4,3.3011E-4,3.2926E-4,3.3375E-4,4.1572E-4,1.9134E-4,2.095E-4,2.1532E-4,2.7648E-4,3.9345E-4,1.7516E-4,1.905E-4,1.9135E-4,2.7262E-4,3.8667E-4,1.6034E-4,1.9549E-4,1.9688E-4,2.6295E-4,3.7797E-4,1.6031E-4,1.8684E-4,1.9002E-4,2.3785E-4,3.7668E-4,1.5821E-4,1.8297E-4,1.9983E-4,2.6665E-4,3.716E-4,1.6128E-4,1.8495E-4,1.8795E-4,2.4278E-4,3.6801E-4,1.7061E-4,1.9552E-4,1.8725E-4,2.4635E-4,3.7251E-4,1.5883E-4,1.8262E-4,1.9061E-4,2.4012E-4,3.6413E-4,1.5462E-4,1.8281E-4,1.8832E-4,2.4766E-4,3.6526E-4,1.5917E-4,1.8256E-4,1.8831E-4,2.3822E-4,3.6872E-4,1.6249E-4,2.2411E-4,2.3464E-4,3.2743E-4,4.6289E-4,2.1528E-4,2.0914E-4,2.2555E-4,2.9112E-4,4.0007E-4,1.7333E-4,1.9986E-4,1.9085E-4,2.5119E-4,3.8765E-4,1.8268E-4,2.0304E-4,2.1651E-4,2.9397E-4,4.2785E-4,1.6518E-4,1.8934E-4,1.9952E-4,2.5744E-4,3.7561E-4,1.5876E-4,1.8408E-4,1.9071E-4,2.3531E-4,3.6666E-4,1.5852E-4,1.8405E-4,1.9355E-4,2.4178E-4,3.6151E-4,1.5972E-4,1.846E-4,1.8892E-4,2.3922E-4,3.6311E-4,1.6566E-4,1.9001E-4,1.8903E-4,2.4453E-4,3.6503E-4,1.5525E-4,1.8761E-4,1.8774E-4,2.441E-4,3.6172E-4,1.5854E-4,1.8349E-4,1.8956E-4,2.4576E-4,3.6279E-4,1.5704E-4,1.8523E-4,1.9063E-4,2.4364E-4,3.649E-4,1.5825E-4,1.8375E-4,1.9176E-4,2.4594E-4,3.7081E-4,1.6438E-4,1.8572E-4,1.8826E-4,2.3974E-4,3.608E-4,1.5774E-4,1.8465E-4,1.9242E-4,2.4027E-4,3.6528E-4,1.5584E-4,1.8469E-4,1.869E-4,2.4343E-4,3.5613E-4,1.6572E-4,1.8964E-4,1.8743E-4,2.4396E-4,3.629E-4,1.5874E-4,1.8237E-4,1.8751E-4,2.3893E-4,3.594E-4,1.5405E-4,1.8238E-4,1.8692E-4,2.505E-4,3.5532E-4,1.5772E-4,1.8527E-4,1.8664E-4,2.4477E-4,3.5851E-4,1.6295E-4,1.8392E-4,1.9109E-4,2.8361E-4,4.0893E-4,1.6334E-4,1.8486E-4,1.9827E-4,2.4526E-4,3.6642E-4,1.6015E-4,1.8223E-4,1.8837E-4,2.3947E-4,3.6176E-4,1.5644E-4,1.8543E-4,1.8974E-4,2.4501E-4,3.606E-4,1.5897E-4,1.8146E-4,1.9418E-4,2.5515E-4,3.5625E-4,1.5595E-4,1.8508E-4,1.9224E-4,2.4767E-4,3.5586E-4,1.5808E-4,1.8392E-4,1.9123E-4,2.5608E-4,3.4779E-4,1.5674E-4,1.9292E-4,1.9328E-4,2.4995E-4,3.5203E-4,1.556E-4,1.9385E-4,1.9364E-4,2.5471E-4,3.5228E-4,1.5628E-4,1.8046E-4,1.9002E-4,2.4933E-4,3.5633E-4,1.5464E-4,1.8231E-4,1.8939E-4,2.558E-4,3.5661E-4,1.5826E-4,1.813E-4,1.8841E-4,2.533E-4,3.5184E-4,1.5687E-4,1.8308E-4,1.9232E-4,2.7336E-4,3.5263E-4,1.5769E-4,1.9647E-4,1.953E-4,2.5095E-4,3.5141E-4,1.5558E-4,1.8018E-4,1.9103E-4,2.5046E-4,3.4769E-4,1.5525E-4,1.8318E-4,1.8998E-4,2.4589E-4,3.4905E-4,1.6685E-4,1.882E-4,1.9164E-4,2.5618E-4,3.5082E-4,1.6474E-4,2.0726E-4,2.0658E-4,2.671E-4,3.4941E-4,1.5926E-4,1.8363E-4,1.9088E-4,2.6697E-4,3.5033E-4,1.5847E-4,1.8294E-4,2.0449E-4,2.7547E-4,3.5612E-4,1.8701E-4,2.0011E-4,2.3383E-4,3.6129E-4,4.9423E-4,2.409E-4,2.3816E-4,2.4124E-4,3.5632E-4,4.1781E-4,1.7797E-4,2.0893E-4,2.1478E-4,3.0346E-4,1.328E-4:7
6.5467E-4,3.8417E-4,4.0185E-4,4.6764E-4,4.2617E-4,8.6288E-4,4.6134E-4,4.1252E-4,4.0773E-4,3.3092E-4,6.8561E-4,4.2486E-4,4.0584E-4,4.4318E-4,4.2174E-4,7.2996E-4,4.206E-4,4.0332E-4,4.3815E-4,4.2014E-4,7.6825E-4,4.1243E-4,3.6087E-4,4.0049E-4,3.5909E-4,7.4591E-4,3.8451E-4,3.1633E-4,3.586E-4,3.617E-4,7.4821E-4,3.5677E-4,2.9538E-4,3.3588E-4,3.3218E-4,6.1218E-4,3.3839E-4,3.0059E-4,3.3857E-4,3.2324E-4,6.1961E-4,3.4077E-4,3.1343E-4,4.0664E-4,3.9761E-4,7.4311E-4,4.1476E-4,3.6711E-4,4.2273E-4,4.0182E-4,8.1241E-4,4.3966E-4,3.6889E-4,4.3575E-4,3.9639E-4,7.386E-4,3.9294E-4,3.5454E-4,4.0405E-4,3.8189E-4,7.6645E-4,4.0817E-4,3.7402E-4,4.3403E-4,3.9267E-4,7.8034E-4,4.2984E-4,4.1892E-4,4.7017E-4,4.3867E-4,8.5427E-4,4.1973E-4,3.7769E-4,4.6565E-4,4.6966E-4,8.5749E-4,4.2632E-4,3.7789E-4,4.2389E-4,4.016E-4,8.0121E-4,4.2975E-4,3.8751E-4,4.389E-4,4.0934E-4,7.7915E-4,4.0869E-4,3.5483E-4,3.9676E-4,3.9353E-4,8.1365E-4,4.3664E-4,3.4619E-4,3.9076E-4,3.8048E-4,6.7979E-4,3.954E-4,3.3742E-4,3.7688E-4,3.9116E-4,7.2223E-4,3.7799E-4,3.337E-4,4.076E-4,3.9869E-4,7.7663E-4,4.3841E-4,3.9814E-4,3.5966E-4,3.0878E-4,8.0136E-4,4.2091E-4,3.7104E-4,4.1114E-4,3.9087E-4,7.1355E-4,3.8044E-4,4.2397E-4,4.9426E-4,4.806E-4,9.0188E-4,4.6803E-4,4.2649E-4,4.8417E-4,4.5767E-4,8.4147E-4,4.8486E-4,4.0319E-4,4.6302E-4,4.6472E-4,8.6628E-4,4.6883E-4,4.1834E-4,4.8633E-4,5.0284E-4,8.8655E-4,4.6137E-4,4.088E-4,4.7455E-4,4.3262E-4,8.2544E-4,4.1372E-4,3.7077E-4,4.3224E-4,4.0713E-4,8.3304E-4,4.7503E-4,3.9381E-4,4.389E-4,4.0555E-4,6.3459E-4,3.2841E-4,2.8375E-4,3.0494E-4,2.515E-4,6.4874E-4,2.885E-4,2.5102E-4,3.9435E-4,3.8411E-4,7.3422E-4,3.7925E-4,3.6042E-4,4.0098E-4,3.6871E-4,7.3836E-4,4.3032E-4,3.7044E-4,4.2852E-4,3.9299E-4,7.062E-4,2.6668E-4,2.3789E-4,2.6098E-4,2.4166E-4,4.2554E-4,2.2652E-4,2.0327E-4,2.5106E-4,2.239E-4,4.5332E-4,2.3329E-4,1.9479E-4,2.4536E-4,2.4391E-4,4.1309E-4,2.1458E-4,1.9751E-4,2.5068E-4,2.357E-4,4.2848E-4,2.1144E-4,2.1365E-4,2.611E-4,2.3119E-4,4.383E-4,2.0915E-4,1.9055E-4,2.3291E-4,1.9652E-4,3.9095E-4,2.108E-4,1.8804E-4,2.3468E-4,2.0303E-4,3.9912E-4,2.2643E-4,1.9776E-4,2.2301E-4,1.9736E-4,4.3069E-4,2.4399E-4,2.494E-4,2.5168E-4,2.2903E-4,5.9948E-4,2.3917E-4,2.0407E-4,2.6205E-4,2.201E-4,4.0915E-4,2.2052E-4,1.9842E-4,2.264E-4,2.3121E-4,4.4792E-4,2.2506E-4,1.8694E-4,2.0685E-4,1.9734E-4,3.857E-4,2.1011E-4,1.8439E-4,2.0169E-4,2.0277E-4,3.9968E-4,2.0447E-4,1.886E-4,2.1011E-4,1.9428E-4,4.1809E-4,2.1605E-4,2.0029E-4,2.2656E-4,2.2134E-4,4.2751E-4,2.1189E-4,1.8131E-4,2.0798E-4,1.9434E-4,4.2786E-4,2.2008E-4,2.0469E-4,2.4976E-4,2.3905E-4,4.7299E-4,2.5025E-4,2.4648E-4,2.7215E-4,2.416E-4,4.1854E-4,2.1285E-4,1.8981E-4,2.1637E-4,2.0205E-4,4.4271E-4,2.1476E-4,1.9833E-4,2.1868E-4,1.99E-4,3.9652E-4,2.1413E-4,2.2004E-4,2.505E-4,2.2237E-4,5.395E-4,2.3451E-4,2.0875E-4,2.866E-4,2.8479E-4,5.1791E-4,2.1401E-4,2.0171E-4,2.4605E-4,2.2342E-4,4.6557E-4,2.2404E-4,1.9527E-4,2.356E-4,2.1057E-4,4.3419E-4,2.1637E-4,1.9008E-4,2.2407E-4,1.922