set(simage_VERSION "1.7.1")
set(simage_VERSION_MAJOR "1")
set(simage_VERSION_MINOR "7")
set(simage_VERSION_PATCH "1")


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was simage-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
include(GNUInstallDirs)

if (ON)
	if(1)
		find_dependency(Qt5Core)
		find_dependency(Qt5Gui)
	elseif()
		find_dependency(Qt4)
	endif()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/simage-export.cmake")

if(ON)
	set(simage_DEFINITIONS "-DSIMAGE_DLL")
else()
	set(simage_DEFINITIONS "-DSIMAGE_NOT_DLL")
endif()

set(simage_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/${CMAKE_INSTALL_INCLUDEDIR}")
set(simage_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/${CMAKE_INSTALL_LIBDIR}")
set(simage_LIBRARIES "simage::simage")
