#  tests for shapely-1.8.2-py310h3578588_1 (this is a generated file);
print('===== testing package: shapely-1.8.2-py310h3578588_1 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import platform
import py
import os
import sys

implementation = platform.python_implementation()
print('implementation: {}'.format(implementation))
target_platform = os.environ["target_platform"]
print(f'target platform: {target_platform}')
py_version = sys.version_info[:2]
print(f'python version: {py_version}')

pytest_args = ['tests']

if implementation != 'PyPy':
    from shapely import speedups
    import shapely.speedups._speedups
    import shapely.vectorized
    import shapely.vectorized._vectorized

    assert speedups.available;

    speedups.enable()
    pytest_args.append('--with-speedups')

py.test.cmdline.main(pytest_args)

from shapely.geometry import LineString

ls = LineString([(0, 0), (10, 0)])
# On OSX causes an abort trap, due to https://github.com/shapely/shapely/issues/177
r = ls.wkt
area = ls.buffer(10).area

# Check if we can import lgeos.
# https://github.com/conda-forge/shapely-feedstock/issues/17
from shapely.geos import lgeos
#  --- run_test.py (end) ---

print('===== shapely-1.8.2-py310h3578588_1 OK =====');
print("import: 'shapely'")
import shapely

print("import: 'shapely.geometry'")
import shapely.geometry

print("import: 'shapely.algorithms'")
import shapely.algorithms

print("import: 'shapely.examples'")
import shapely.examples

print("import: 'shapely.geos'")
import shapely.geos

