/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*    Copyright (C) 2002-2022 Konrad-Zuse-Zentrum                            */
/*                            fuer Informationstechnik Berlin                */
/*                                                                           */
/*  SCIP is distributed under the terms of the ZIB Academic License.         */
/*                                                                           */
/*  You should have received a copy of the ZIB Academic License.             */
/*  along with SCIP; see the file COPYING. If not visit scipopt.org.         */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   objscip.h
 * @brief  C++ wrapper classes for SCIP
 * @author Tobias Achterberg
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#ifndef __SCIP_OBJSCIP_H__
#define __SCIP_OBJSCIP_H__


#include "objscip/objbenders.h"
#include "objscip/objbenderscut.h"
#include "objscip/objbranchrule.h"
#include "objscip/objconshdlr.h"
#include "objscip/objcutsel.h"
#include "objscip/objdialog.h"
#include "objscip/objdisp.h"
#include "objscip/objeventhdlr.h"
#include "objscip/objheur.h"
#include "objscip/objmessagehdlr.h"
#include "objscip/objnodesel.h"
#include "objscip/objpresol.h"
#include "objscip/objpricer.h"
#include "objscip/objprobdata.h"
#include "objscip/objprop.h"
#include "objscip/objreader.h"
#include "objscip/objrelax.h"
#include "objscip/objsepa.h"
#include "objscip/objvardata.h"
#include "objscip/objcloneable.h"

#endif
