/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*    Copyright (C) 2002-2021 Konrad-Zuse-Zentrum                            */
/*                            fuer Informationstechnik Berlin                */
/*                                                                           */
/*  SCIP is distributed under the terms of the ZIB Academic License.         */
/*                                                                           */
/*  You should have received a copy of the ZIB Academic License              */
/*  along with SCIP; see the file COPYING. If not visit scipopt.org.         */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   type_cutpool.h
 * @brief  type definitions for storing cuts in a cut pool
 * @author Tobias Achterberg
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#ifndef __SCIP_TYPE_CUTPOOL_H__
#define __SCIP_TYPE_CUTPOOL_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct SCIP_Cutpool SCIP_CUTPOOL;         /**< storage for pooled cuts */
typedef struct SCIP_Cut SCIP_CUT;                 /**< datastructure for cuts in a cut pool */

#ifdef __cplusplus
}
#endif

#endif
