/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.imageplus;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ShortProcessor;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class ShortImagePlus<T extends NativeType<T>>
extends ImagePlusImg<T, ShortArray> {
    final ImagePlus imp;

    public ShortImagePlus(long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        if (entitiesPerPixel.getRatio() == 1.0) {
            ImageStack stack = new ImageStack(this.width, this.height);
            for (int i = 0; i < this.numSlices; ++i) {
                stack.addSlice("", new ShortProcessor(this.width, this.height));
            }
            this.imp = new ImagePlus("image", stack);
            this.imp.setDimensions(this.channels, this.depth, this.frames);
            if (this.numSlices > 1) {
                this.imp.setOpenAsHyperStack(true);
            }
            this.mirror.clear();
            for (int t = 0; t < this.frames; ++t) {
                for (int z = 0; z < this.depth; ++z) {
                    for (int c = 0; c < this.channels; ++c) {
                        this.mirror.add(new ShortArray((short[])this.imp.getStack().getProcessor(this.imp.getStackIndex(c + 1, z + 1, t + 1)).getPixels()));
                    }
                }
            }
        } else {
            this.imp = null;
            this.mirror.clear();
            for (int i = 0; i < this.numSlices; ++i) {
                this.mirror.add(new ShortArray(this.numEntities(entitiesPerPixel)));
            }
        }
    }

    public ShortImagePlus(ImagePlus imp) {
        super(imp);
        this.imp = imp;
        this.mirror.clear();
        for (int t = 0; t < this.frames; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int c = 0; c < this.channels; ++c) {
                    this.mirror.add(new ShortArray((short[])imp.getStack().getProcessor(imp.getStackIndex(c + 1, z + 1, t + 1)).getPixels()));
                }
            }
        }
    }

    public void setPlane(int no, ShortArray plane) {
        System.arraycopy(plane.getCurrentStorageArray(), 0, ((ShortArray)this.mirror.get(no)).getCurrentStorageArray(), 0, plane.getCurrentStorageArray().length);
    }

    @Override
    public void close() {
        if (this.imp != null) {
            this.imp.close();
        }
    }

    @Override
    public ImagePlus getImagePlus() throws ImgLibException {
        if (this.imp == null) {
            throw new ImgLibException((Object)this, "has no ImagePlus instance, it is not a standard type of ImagePlus (" + this.entitiesPerPixel + " entities per pixel)");
        }
        return this.imp;
    }
}

