/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.img.display.imagej.ImageJVirtualStack;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import net.imglib2.view.Views;

public class ImageJVirtualStackFloat<S>
extends ImageJVirtualStack<S, FloatType> {
    public ImageJVirtualStackFloat(RandomAccessibleInterval<S> source, Converter<S, FloatType> converter) {
        this(source, converter, null);
    }

    public ImageJVirtualStackFloat(RandomAccessibleInterval<S> source, Converter<S, FloatType> converter, ExecutorService service) {
        super(source, converter, new FloatType(), 2, service);
        this.imageProcessor.setMinAndMax(0.0, 1.0);
    }

    public void setMinMax(RandomAccessibleInterval<S> source, Converter<S, FloatType> converter) {
        if (this.service != null) {
            this.setMinMaxMT((RandomAccessibleInterval<S>)source, converter);
            return;
        }
        RandomAccessibleIntervalCursor cursor = new RandomAccessibleIntervalCursor((RandomAccessible)(Views.isZeroMin(source) ? source : Views.zeroMin(source)));
        FloatType t = new FloatType();
        if (cursor.hasNext()) {
            float min;
            converter.convert(cursor.next(), (Object)t);
            float max = min = t.get();
            while (cursor.hasNext()) {
                converter.convert(cursor.next(), (Object)t);
                float value = t.get();
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            System.out.println("fmax = " + max);
            System.out.println("fmin = " + min);
            this.imageProcessor.setMinAndMax(min, max);
        }
    }

    private void setMinMaxMT(final RandomAccessibleInterval<S> source, final Converter<S, FloatType> converter) {
        final long nTasks = Runtime.getRuntime().availableProcessors();
        long size = 1L;
        for (int d = 0; d < source.numDimensions(); ++d) {
            size *= source.dimension(d);
        }
        final long portionSize = size / nTasks;
        ArrayList<1> tasks = new ArrayList<1>();
        final AtomicInteger ai = new AtomicInteger();
        final ArrayList mins = new ArrayList((int)nTasks);
        final ArrayList maxs = new ArrayList((int)nTasks);
        int t = 0;
        while ((long)t < nTasks) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int i = ai.getAndIncrement();
                    RandomAccessibleIntervalCursor cursor = new RandomAccessibleIntervalCursor((RandomAccessible)(Views.isZeroMin((Interval)source) ? source : Views.zeroMin((RandomAccessibleInterval)source)));
                    FloatType t = new FloatType();
                    long stepsTaken = 0L;
                    cursor.jumpFwd((long)i * portionSize);
                    float min = Float.MAX_VALUE;
                    float max = -3.4028235E38f;
                    while ((long)i != nTasks - 1L && stepsTaken < portionSize || (long)i == nTasks - 1L && cursor.hasNext()) {
                        ++stepsTaken;
                        converter.convert(cursor.next(), (Object)t);
                        float value = t.get();
                        if (value < min) {
                            min = value;
                        }
                        if (!(value > max)) continue;
                        max = value;
                    }
                    mins.add(Float.valueOf(min));
                    maxs.add(Float.valueOf(max));
                    return null;
                }
            });
            ++t;
        }
        try {
            List futures = this.service.invokeAll(tasks);
            for (Future f : futures) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        int t2 = 0;
        while ((long)t2 < nTasks) {
            if (min > ((Float)mins.get(t2)).floatValue()) {
                min = ((Float)mins.get(t2)).floatValue();
            }
            if (max < ((Float)maxs.get(t2)).floatValue()) {
                max = ((Float)maxs.get(t2)).floatValue();
            }
            ++t2;
        }
        System.out.println("fmax = " + max);
        System.out.println("fmin = " + min);
        this.imageProcessor.setMinAndMax(min, max);
    }
}

