/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import ij.VirtualStack;
import ij.measure.Calibration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.ComplexPowerGLogFloatConverter;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.converter.RealUnsignedByteConverter;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJVirtualStackARGB;
import net.imglib2.img.display.imagej.ImageJVirtualStackFloat;
import net.imglib2.img.display.imagej.ImageJVirtualStackUnsignedByte;
import net.imglib2.img.display.imagej.ImageJVirtualStackUnsignedShort;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class ImageJFunctions {
    static final AtomicInteger ai = new AtomicInteger();

    public static <T extends NumericType<T> & NativeType<T>> Img<T> wrap(ImagePlus imp) {
        return ImagePlusAdapter.wrap(imp);
    }

    public static <T extends RealType<T>> Img<T> wrapReal(ImagePlus imp) {
        return ImagePlusAdapter.wrapReal(imp);
    }

    public static <T extends RealType<T> & NativeType<T>> Img<T> wrapRealNative(ImagePlus imp) {
        return ImagePlusAdapter.wrapReal(imp);
    }

    public static <T extends NumericType<T>> Img<T> wrapNumeric(ImagePlus imp) {
        return ImagePlusAdapter.wrapNumeric(imp);
    }

    public static <T extends NumericType<T> & NativeType<T>> Img<T> wrapNumericNative(ImagePlus imp) {
        return ImageJFunctions.wrap(imp);
    }

    public static Img<UnsignedByteType> wrapByte(ImagePlus imp) {
        return ImagePlusAdapter.wrapByte(imp);
    }

    public static Img<UnsignedShortType> wrapShort(ImagePlus imp) {
        return ImagePlusAdapter.wrapShort(imp);
    }

    public static Img<ARGBType> wrapRGBA(ImagePlus imp) {
        return ImagePlusAdapter.wrapRGBA(imp);
    }

    public static Img<FloatType> wrapFloat(ImagePlus imp) {
        return ImagePlusAdapter.wrapFloat(imp);
    }

    public static Img<FloatType> convertFloat(ImagePlus imp) {
        return ImagePlusAdapter.convertFloat(imp);
    }

    public static <T extends NumericType<T>> ImagePlus show(RandomAccessibleInterval<T> img, ExecutorService service) {
        return ImageJFunctions.show(img, "Image " + ai.getAndIncrement(), service);
    }

    public static <T extends NumericType<T>> ImagePlus show(RandomAccessibleInterval<T> img) {
        return ImageJFunctions.show(img, (ExecutorService)null);
    }

    public static <T extends ComplexType<T>> ImagePlus show(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, ExecutorService service) {
        return ImageJFunctions.show(img, converter, "Complex image " + ai.getAndIncrement(), service);
    }

    public static <T extends ComplexType<T>> ImagePlus show(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter) {
        return ImageJFunctions.show(img, converter, "Complex image " + ai.getAndIncrement(), null);
    }

    public static <T extends ComplexType<T>> ImagePlus show(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title, ExecutorService service) {
        ImageJVirtualStackFloat<T> stack = new ImageJVirtualStackFloat<T>(img, converter, service);
        ImagePlus imp = new ImagePlus(title, stack);
        imp.show();
        return imp;
    }

    public static <T extends ComplexType<T>> ImagePlus show(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title) {
        return ImageJFunctions.show(img, converter, title, null);
    }

    public static <T extends NumericType<T>> ImagePlus wrap(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        ImagePlus target;
        NumericType t = (NumericType)Util.getTypeFromInterval(img);
        RandomAccessibleInterval<T> oImg = img;
        if (ARGBType.class.isInstance(t)) {
            target = ImageJFunctions.wrapRGB(oImg, title, service);
        } else if (UnsignedByteType.class.isInstance(t)) {
            target = ImageJFunctions.wrapUnsignedByte(oImg, title, service);
        } else if (BitType.class.isInstance(t)) {
            target = ImageJFunctions.wrapBit(oImg, title, service);
        } else if (IntegerType.class.isInstance(t)) {
            target = ImageJFunctions.wrapUnsignedShort(oImg, title, service);
        } else if (RealType.class.isInstance(t)) {
            target = ImageJFunctions.wrapFloat(oImg, title, service);
        } else if (ComplexType.class.isInstance(t)) {
            target = ImageJFunctions.wrapFloat(oImg, new ComplexPowerGLogFloatConverter(), title, service);
        } else {
            System.out.println("Do not know how to display Type " + t.getClass().getSimpleName());
            target = null;
        }
        if (null != target && img instanceof ImgPlus) {
            int taxis;
            int zaxis;
            int yaxis;
            ImgPlus imgplus = (ImgPlus)img;
            Calibration impcal = target.getCalibration();
            int xaxis = imgplus.dimensionIndex(Axes.X);
            if (xaxis >= 0) {
                impcal.pixelWidth = imgplus.averageScale(xaxis);
                impcal.xOrigin = ((CalibratedAxis)imgplus.axis(xaxis)).calibratedValue(0.0);
            }
            if ((yaxis = imgplus.dimensionIndex(Axes.Y)) >= 0) {
                impcal.pixelHeight = imgplus.averageScale(yaxis);
                impcal.yOrigin = ((CalibratedAxis)imgplus.axis(yaxis)).calibratedValue(0.0);
            }
            if ((zaxis = imgplus.dimensionIndex(Axes.Z)) >= 0) {
                impcal.pixelDepth = imgplus.averageScale(zaxis);
                impcal.zOrigin = ((CalibratedAxis)imgplus.axis(zaxis)).calibratedValue(0.0);
            }
            if ((taxis = imgplus.dimensionIndex(Axes.TIME)) >= 0) {
                impcal.frameInterval = imgplus.averageScale(taxis);
            }
            target.setTitle(imgplus.getName());
        }
        return target;
    }

    public static <T extends NumericType<T>> ImagePlus wrap(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.wrap(img, title, null);
    }

    public static <T extends NumericType<T>> ImagePlus show(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        ImagePlus imp = ImageJFunctions.wrap(img, title, service);
        if (null == imp) {
            return null;
        }
        imp.show();
        imp.getProcessor().resetMinAndMax();
        imp.updateAndRepaintWindow();
        return imp;
    }

    public static <T extends NumericType<T>> ImagePlus show(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.show(img, title, null);
    }

    public static <T extends RealType<T>> ImagePlus wrapFloat(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        ImageJVirtualStackFloat<T> stack = new ImageJVirtualStackFloat<T>(img, new RealFloatConverter(), service);
        return ImageJFunctions.makeImagePlus(img, stack, title);
    }

    public static <T extends RealType<T>> ImagePlus wrapFloat(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.wrapFloat(img, title, null);
    }

    private static ImagePlus makeImagePlus(Dimensions dims, VirtualStack stack, String title) {
        ImagePlus imp = new ImagePlus(title, stack);
        int n = dims.numDimensions();
        if (n > 2) {
            int f;
            int s;
            imp.setOpenAsHyperStack(true);
            int c = (int)dims.dimension(2);
            if (n > 3) {
                s = (int)dims.dimension(3);
                f = n > 4 ? (int)dims.dimension(4) : 1;
            } else {
                s = 1;
                f = 1;
            }
            imp.setDimensions(c, s, f);
        }
        return imp;
    }

    public static <T> ImagePlus wrapFloat(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title, ExecutorService service) {
        ImageJVirtualStackFloat<T> stack = new ImageJVirtualStackFloat<T>(img, converter, service);
        return ImageJFunctions.makeImagePlus(img, stack, title);
    }

    public static <T> ImagePlus wrapFloat(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title) {
        return ImageJFunctions.wrapFloat(img, converter, title, null);
    }

    public static <T> ImagePlus showFloat(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title, ExecutorService service) {
        ImagePlus imp = ImageJFunctions.wrapFloat(img, converter, title, service);
        imp.show();
        imp.getProcessor().resetMinAndMax();
        imp.updateAndRepaintWindow();
        return imp;
    }

    public static <T> ImagePlus showFloat(RandomAccessibleInterval<T> img, Converter<T, FloatType> converter, String title) {
        return ImageJFunctions.showFloat(img, converter, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showFloat(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.showFloat(img, new RealFloatConverter(), title, service);
    }

    public static <T extends RealType<T>> ImagePlus showFloat(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.showFloat(img, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showFloat(RandomAccessibleInterval<T> img, ExecutorService service) {
        return ImageJFunctions.showFloat(img, "Image " + ai.getAndIncrement(), service);
    }

    public static <T extends RealType<T>> ImagePlus showFloat(RandomAccessibleInterval<T> img) {
        return ImageJFunctions.showFloat(img, (ExecutorService)null);
    }

    public static ImagePlus wrapRGB(RandomAccessibleInterval<ARGBType> img, String title, ExecutorService service) {
        return ImageJFunctions.wrapRGB(img, new TypeIdentity(), title, service);
    }

    public static ImagePlus wrapRGB(RandomAccessibleInterval<ARGBType> img, String title) {
        return ImageJFunctions.wrapRGB(img, title, null);
    }

    public static <T> ImagePlus wrapRGB(RandomAccessibleInterval<T> img, Converter<T, ARGBType> converter, String title, ExecutorService service) {
        ImageJVirtualStackARGB<T> stack = new ImageJVirtualStackARGB<T>(img, converter, service);
        return ImageJFunctions.makeImagePlus(img, stack, title);
    }

    public static <T> ImagePlus wrapRGB(RandomAccessibleInterval<T> img, Converter<T, ARGBType> converter, String title) {
        return ImageJFunctions.wrapRGB(img, converter, title, null);
    }

    public static <T> ImagePlus showRGB(RandomAccessibleInterval<T> img, Converter<T, ARGBType> converter, String title, ExecutorService service) {
        ImagePlus imp = ImageJFunctions.wrapRGB(img, converter, title, service);
        imp.show();
        imp.getProcessor().resetMinAndMax();
        imp.updateAndRepaintWindow();
        return imp;
    }

    public static <T> ImagePlus showRGB(RandomAccessibleInterval<T> img, Converter<T, ARGBType> converter, String title) {
        return ImageJFunctions.showRGB(img, converter, title, null);
    }

    public static <T extends RealType<T>> ImagePlus wrapUnsignedByte(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.wrapUnsignedByte(img, new RealUnsignedByteConverter(0.0, 255.0), title, service);
    }

    public static <T extends RealType<T>> ImagePlus wrapUnsignedByte(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.wrapUnsignedByte(img, title, null);
    }

    public static <T extends RealType<T>> ImagePlus wrapBit(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.wrapUnsignedByte(img, new RealUnsignedByteConverter(0.0, 1.0), title, service);
    }

    public static <T extends RealType<T>> ImagePlus wrapBit(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.wrapBit(img, title, null);
    }

    public static <T> ImagePlus wrapUnsignedByte(RandomAccessibleInterval<T> img, Converter<T, UnsignedByteType> converter, String title, ExecutorService service) {
        ImageJVirtualStackUnsignedByte<T> stack = new ImageJVirtualStackUnsignedByte<T>(img, converter, service);
        return ImageJFunctions.makeImagePlus(img, stack, title);
    }

    public static <T> ImagePlus wrapUnsignedByte(RandomAccessibleInterval<T> img, Converter<T, UnsignedByteType> converter, String title) {
        return ImageJFunctions.wrapUnsignedByte(img, converter, title, null);
    }

    public static <T> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img, Converter<T, UnsignedByteType> converter, String title, ExecutorService service) {
        ImagePlus imp = ImageJFunctions.wrapUnsignedByte(img, converter, title, service);
        imp.show();
        imp.getProcessor().resetMinAndMax();
        imp.updateAndRepaintWindow();
        return imp;
    }

    public static <T> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img, Converter<T, UnsignedByteType> converter, String title) {
        return ImageJFunctions.showUnsignedByte(img, converter, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.showUnsignedByte(img, new RealUnsignedByteConverter(0.0, 255.0), title, service);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.showUnsignedByte(img, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img, ExecutorService service) {
        return ImageJFunctions.showUnsignedByte(img, "Image " + ai.getAndIncrement(), service);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedByte(RandomAccessibleInterval<T> img) {
        return ImageJFunctions.showUnsignedByte(img, (ExecutorService)null);
    }

    public static <T extends RealType<T>> ImagePlus wrapUnsignedShort(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.wrapUnsignedShort(img, new RealUnsignedShortConverter(0.0, 65535.0), title, service);
    }

    public static <T extends RealType<T>> ImagePlus wrapUnsignedShort(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.wrapUnsignedShort(img, title, null);
    }

    public static <T> ImagePlus wrapUnsignedShort(RandomAccessibleInterval<T> img, Converter<T, UnsignedShortType> converter, String title, ExecutorService service) {
        ImageJVirtualStackUnsignedShort<T> stack = new ImageJVirtualStackUnsignedShort<T>(img, converter, service);
        return ImageJFunctions.makeImagePlus(img, stack, title);
    }

    public static <T> ImagePlus wrapUnsignedShort(RandomAccessibleInterval<T> img, Converter<T, UnsignedShortType> converter, String title) {
        return ImageJFunctions.wrapUnsignedShort(img, converter, title, null);
    }

    public static <T> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img, Converter<T, UnsignedShortType> converter, String title, ExecutorService service) {
        ImagePlus imp = ImageJFunctions.wrapUnsignedShort(img, converter, title, service);
        imp.show();
        imp.getProcessor().resetMinAndMax();
        imp.updateAndRepaintWindow();
        return imp;
    }

    public static <T> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img, Converter<T, UnsignedShortType> converter, String title) {
        return ImageJFunctions.showUnsignedShort(img, converter, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img, String title, ExecutorService service) {
        return ImageJFunctions.showUnsignedShort(img, new RealUnsignedShortConverter(0.0, 65535.0), title, service);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img, String title) {
        return ImageJFunctions.showUnsignedShort(img, title, null);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img, ExecutorService service) {
        return ImageJFunctions.showUnsignedShort(img, "Image " + ai.getAndIncrement(), service);
    }

    public static <T extends RealType<T>> ImagePlus showUnsignedShort(RandomAccessibleInterval<T> img) {
        return ImageJFunctions.showUnsignedShort(img, (ExecutorService)null);
    }
}

