/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.fileformat.writer;

import io.scif.jj2000.j2k.fileformat.FileFormatBoxes;
import io.scif.jj2000.j2k.io.BEBufferedRandomAccessFile;
import io.scif.media.imageioimpl.plugins.jpeg2000.Box;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NodeList;

public class FileFormatWriter
implements FileFormatBoxes {
    private File file;
    private ImageOutputStream stream;
    private int height;
    private int width;
    private int nc;
    private int[] bpc;
    private boolean bpcVaries;
    private int clength;
    private static final int CSB_LENGTH = 15;
    private static final int FTB_LENGTH = 20;
    private static final int IHB_LENGTH = 22;
    private static final int BPC_LENGTH = 8;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private J2KMetadata metadata;
    private boolean isIndexed = false;
    private int otherLength;
    J2KMetadataFormat format;

    public FileFormatWriter(File file, ImageOutputStream stream, int height, int width, int nc, int[] bpc, int clength, ColorModel colorModel, SampleModel sampleModel, J2KMetadata metadata) {
        this.height = height;
        this.width = width;
        this.nc = nc;
        this.bpc = bpc;
        this.file = file;
        this.stream = stream;
        this.clength = clength;
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
        this.metadata = metadata;
        if (colorModel instanceof IndexColorModel) {
            this.isIndexed = true;
        }
        this.bpcVaries = false;
        int fixbpc = bpc[0];
        for (int i = nc - 1; i > 0; --i) {
            if (bpc[i] == fixbpc) continue;
            this.bpcVaries = true;
        }
    }

    public int writeFileFormat() throws IOException {
        this.writeMetadata(this.metadata);
        this.writeContiguousCodeStreamBox();
        return 15 + this.otherLength;
    }

    private void writeMetadata(J2KMetadata metadata) throws IOException {
        if (metadata == null) {
            return;
        }
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        if (root == null) {
            return;
        }
        this.format = (J2KMetadataFormat)metadata.getMetadataFormat("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        this.writeSuperBox(root);
    }

    private void writeSuperBox(IIOMetadataNode node) throws IOException {
        NodeList list = node.getChildNodes();
        String name = node.getNodeName();
        if (name.startsWith("JPEG2000")) {
            this.stream.writeInt(this.computeLength(node));
            this.stream.writeInt(Box.getTypeInt(Box.getTypeByName(name)));
            this.otherLength += 8;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            IIOMetadataNode child = (IIOMetadataNode)list.item(i);
            name = child.getNodeName();
            if (name.startsWith("JPEG2000") && this.format.isLeaf(name)) {
                this.writeBox(child);
                continue;
            }
            this.writeSuperBox(child);
        }
    }

    private void writeBox(IIOMetadataNode node) throws IOException {
        int type = Box.getTypeInt((String)Box.getAttribute(node, "Type"));
        int length = new Integer((String)Box.getAttribute(node, "Length"));
        Box box = Box.createBox(type, node);
        this.otherLength += length;
        this.stream.writeInt(length);
        this.stream.writeInt(type);
        byte[] data = box.getContent();
        this.stream.write(data, 0, data.length);
    }

    private int computeLength(IIOMetadataNode root) {
        NodeList list = root.getChildNodes();
        int length = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            IIOMetadataNode node = (IIOMetadataNode)list.item(i);
            String name = node.getNodeName();
            if (this.format.isLeaf(name)) {
                length += new Integer((String)Box.getAttribute(node, "Length")).intValue();
                continue;
            }
            length += this.computeLength(node);
        }
        return length + (root.getNodeName().startsWith("JPEG2000") ? 8 : 0);
    }

    public void writeContiguousCodeStreamBox() throws IOException {
        int len;
        if (this.metadata != null) {
            this.stream.writeInt(this.clength + 8);
            this.stream.writeInt(1785737827);
        }
        BEBufferedRandomAccessFile fi = new BEBufferedRandomAccessFile(this.file, "rw+");
        byte[] codestream = new byte[1024];
        for (int remainder = this.clength; remainder > 0; remainder -= len) {
            len = remainder > 1024 ? 1024 : remainder;
            fi.readFully(codestream, 0, len);
            this.stream.write(codestream, 0, len);
        }
        fi.close();
    }
}

