/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class ArrangeToolBar
extends AbstractToolBar {
    @Nullable
    private SelectionComponentDisplayer displayer;

    public ArrangeToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString(this.getID() + ".toolbar"));
    }

    @Override
    public void setEditor(DrawingEditor newValue) {
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
            this.displayer.setVisibleIfCreationTool(false);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                AbstractSelectedAction d = new BringToFrontAction(this.editor);
                JButton btn = new JButton(d);
                this.disposables.add(d);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setText(null);
                labels.configureToolBarButton(btn, "edit.bringToFront");
                btn.putClientProperty("hideActionText", Boolean.TRUE);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 13;
                p.add((Component)btn, gbc);
                d = new SendToBackAction(this.editor);
                btn = new JButton(d);
                this.disposables.add(d);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setText(null);
                labels.configureToolBarButton(btn, "edit.sendToBack");
                btn.putClientProperty("hideActionText", Boolean.TRUE);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 11;
                gbc.weighty = 1.0;
                p.add((Component)btn, gbc);
            }
        }
        return p;
    }

    private void initComponents() {
        this.setOpaque(false);
    }

    @Override
    protected String getID() {
        return "arrange";
    }
}

