/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.HandleException;
import io.scif.io.IStreamAccess;
import io.scif.io.StreamHandle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.scijava.Context;
import org.scijava.plugin.Plugin;

@Plugin(type=IStreamAccess.class)
public class URLHandle
extends StreamHandle {
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"http:", "https:", "file:"};
    private String url;
    private URLConnection conn;

    public URLHandle() {
    }

    public URLHandle(Context context) {
        super(context);
    }

    public URLHandle(Context context, String url) throws IOException {
        super(context);
        this.setURL(url);
    }

    public void setURL(String url) throws IOException {
        if (!this.isConstructable(url)) {
            throw new HandleException(url + " is not a valid url.");
        }
        boolean hasSupportedProtocol = false;
        for (String protocol : SUPPORTED_PROTOCOLS) {
            if (!url.startsWith(protocol)) continue;
            hasSupportedProtocol = true;
            break;
        }
        if (!hasSupportedProtocol) {
            url = "http://" + url;
        }
        this.url = url;
        this.resetStream();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.getFp() && pos >= this.getMark()) {
            this.getStream().reset();
            this.setFp(this.getMark());
            this.skip(pos - this.getFp());
        } else {
            super.seek(pos);
        }
    }

    @Override
    public boolean isConstructable(String id) throws IOException {
        for (String protocol : SUPPORTED_PROTOCOLS) {
            if (!id.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFile(String file) throws IOException {
        super.setFile(file);
        this.setURL(file);
    }

    @Override
    public void resetStream() throws IOException {
        this.conn = new URL(this.url).openConnection();
        this.setStream(new DataInputStream(new BufferedInputStream(this.conn.getInputStream(), 0x100000)));
        this.setFp(0L);
        this.setMark(0L);
        this.setLength(this.conn.getContentLength());
        if (this.getStream() != null) {
            this.getStream().mark(0x100000);
        }
    }

    private void skip(long bytes) throws IOException {
        int n;
        while (bytes >= Integer.MAX_VALUE) {
            bytes -= (long)this.skipBytes(Integer.MAX_VALUE);
        }
        int skipped = this.skipBytes((int)bytes);
        while ((long)skipped < bytes && (n = this.skipBytes((int)(bytes - (long)skipped))) != 0) {
            skipped += n;
        }
    }
}

