/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.AbstractNIOHandle;
import io.scif.io.NIOService;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class NIOFileHandle
extends AbstractNIOHandle {
    private static int defaultBufferSize = 0x100000;
    private static int defaultRWBufferSize = 8192;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private long position = 0L;
    private long bufferStartPosition = 0L;
    private final int bufferSize;
    private ByteBuffer buffer;
    private FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
    private ByteOrder order;
    private final NIOService nioService;

    public NIOFileHandle(NIOService nioService, File file, String mode, int bufferSize) throws IOException {
        this.nioService = nioService;
        this.bufferSize = bufferSize;
        this.validateMode(mode);
        if (mode.equals("rw")) {
            this.mapMode = FileChannel.MapMode.READ_WRITE;
        }
        this.raf = new RandomAccessFile(file, mode);
        this.channel = this.raf.getChannel();
        this.buffer(this.position, 0);
    }

    public NIOFileHandle(NIOService nioService, File file, String mode) throws IOException {
        this(nioService, file, mode, mode.equals("rw") ? defaultRWBufferSize : defaultBufferSize);
    }

    public NIOFileHandle(NIOService nioService, String name, String mode) throws IOException {
        this(nioService, new File(name), mode);
    }

    public static void setDefaultBufferSize(int size) {
        defaultBufferSize = size;
    }

    public static void setDefaultReadWriteBufferSize(int size) {
        defaultRWBufferSize = size;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setLength(long length) throws IOException {
        this.raf.seek(length - 1L);
        this.raf.write(0);
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long getFilePointer() {
        return this.position;
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public ByteOrder getOrder() {
        return this.buffer == null ? this.order : this.buffer.order();
    }

    @Override
    public void setOrder(ByteOrder order) {
        this.order = order;
        if (this.buffer != null) {
            this.buffer.order(order);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b), off, len);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, 0, buf.capacity());
    }

    @Override
    public int read(ByteBuffer buf, int off, int len) throws IOException {
        buf.position(off);
        buf.limit(off + len);
        this.channel.position(this.position);
        int readLength = this.channel.read(buf);
        this.buffer(this.position + (long)readLength, 0);
        return readLength == -1 ? 0 : readLength;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.mapMode == FileChannel.MapMode.READ_WRITE && pos > this.length()) {
            this.setLength(pos);
        }
        this.buffer(pos, 0);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.buffer(this.position, 1);
        ++this.position;
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public char readChar() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public double readDouble() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public float readFloat() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public String readLine() throws IOException {
        this.raf.seek(this.position);
        String line = this.raf.readLine();
        this.buffer(this.raf.getFilePointer(), 0);
        return line;
    }

    @Override
    public long readLong() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public short readShort() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        this.raf.seek(this.position);
        String utf8 = this.raf.readUTF();
        this.buffer(this.raf.getFilePointer(), 0);
        return utf8;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n < 1) {
            return 0;
        }
        long oldPosition = this.position;
        long newPosition = oldPosition + Math.min((long)n, this.length());
        this.buffer(newPosition, 0);
        return (int)(this.position - oldPosition);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b), off, len);
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    @Override
    public void write(ByteBuffer buf, int off, int len) throws IOException {
        this.writeSetup(len);
        buf.limit(off + len);
        buf.position(off);
        this.position += (long)this.channel.write(buf, this.position);
        this.buffer = null;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeSetup(1);
        this.buffer.put((byte)v);
        this.doWrite(1);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes("UTF-8"));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putChar((char)v);
        this.doWrite(2);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.write(s.getBytes("UTF-16BE"));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeSetup(8);
        this.buffer.putDouble(v);
        this.doWrite(8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeSetup(4);
        this.buffer.putFloat(v);
        this.doWrite(4);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeSetup(4);
        this.buffer.putInt(v);
        this.doWrite(4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeSetup(8);
        this.buffer.putLong(v);
        this.doWrite(8);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putShort((short)v);
        this.doWrite(2);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int strlen = str.getBytes("UTF-8").length + 2;
        this.writeSetup(strlen);
        this.raf.seek(this.position);
        this.raf.writeUTF(str);
        this.position += (long)strlen;
        this.buffer = null;
    }

    private void buffer(long offset, int size) throws IOException {
        this.position = offset;
        long newPosition = offset + (long)size;
        if (newPosition < this.bufferStartPosition || newPosition > this.bufferStartPosition + (long)this.bufferSize || this.buffer == null) {
            long newSize;
            this.bufferStartPosition = offset;
            long currentLength = this.length();
            if (currentLength > 0L && currentLength - 1L < this.bufferStartPosition) {
                this.bufferStartPosition = currentLength - 1L;
            }
            if ((newSize = Math.min(currentLength - this.bufferStartPosition, (long)this.bufferSize)) < (long)size && newSize == (long)this.bufferSize) {
                newSize = size;
            }
            if (newSize + this.bufferStartPosition > currentLength) {
                newSize = currentLength - this.bufferStartPosition;
            }
            offset = this.bufferStartPosition;
            ByteOrder byteOrder = this.buffer == null ? this.order : this.getOrder();
            this.buffer = this.nioService.allocate(this.channel, this.mapMode, this.bufferStartPosition, (int)newSize);
            if (byteOrder != null) {
                this.setOrder(byteOrder);
            }
        }
        this.buffer.position((int)(offset - this.bufferStartPosition));
        if (this.buffer.position() + size > this.buffer.limit() && this.mapMode == FileChannel.MapMode.READ_WRITE) {
            this.buffer.limit(this.buffer.position() + size);
        }
    }

    private void writeSetup(int length) throws IOException {
        this.validateLength(length);
        this.buffer(this.position, length);
    }

    private void doWrite(int length) throws IOException {
        this.buffer.position(this.buffer.position() - length);
        this.channel.write(this.buffer, this.position);
        this.position += (long)length;
    }
}

