/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.ByteArrayPlane;
import io.scif.DefaultImageMetadata;
import io.scif.DefaultMetadata;
import io.scif.DefaultWriter;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Translator;
import io.scif.Writer;
import io.scif.config.SCIFIOConfig;
import io.scif.img.AbstractImgIOComponent;
import io.scif.img.ImgIOException;
import io.scif.img.SCIFIOImgPlus;
import io.scif.services.FormatService;
import io.scif.services.TranslatorService;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.RandomAccess;
import net.imglib2.exception.ImgLibException;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.plugin.Parameter;
import org.scijava.util.Bytes;

public class ImgSaver
extends AbstractImgIOComponent {
    @Parameter
    private StatusService statusService;
    @Parameter
    private FormatService formatService;
    @Parameter
    private TranslatorService translatorService;

    public ImgSaver() {
    }

    public ImgSaver(Context context) {
        super(context);
    }

    public Metadata saveImg(String id, Img<?> img) throws ImgIOException, IncompatibleTypeException {
        return this.saveImg(id, img, null);
    }

    public Metadata saveImg(String id, SCIFIOImgPlus<?> img, int imageIndex) throws ImgIOException, IncompatibleTypeException {
        return this.saveImg(id, img, imageIndex, null);
    }

    public Metadata saveImg(String id, Img<?> img, SCIFIOConfig config) throws ImgIOException, IncompatibleTypeException {
        return this.saveImg(id, this.utils().makeSCIFIOImgPlus(img), 0, config);
    }

    public Metadata saveImg(String id, SCIFIOImgPlus<?> img, int imageIndex, SCIFIOConfig config) throws ImgIOException, IncompatibleTypeException {
        return this.writeImg(id, null, img, imageIndex, config);
    }

    public void saveImg(Writer w, Img<?> img) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(w, img, null);
    }

    public void saveImg(Writer w, SCIFIOImgPlus<?> img, int imageIndex) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(w, img, imageIndex, null);
    }

    public void saveImg(Writer w, Img<?> img, SCIFIOConfig config) throws ImgIOException, IncompatibleTypeException {
        this.saveImg(w, this.utils().makeSCIFIOImgPlus(img), 0, config);
    }

    public void saveImg(Writer w, SCIFIOImgPlus<?> img, int imageIndex, SCIFIOConfig config) throws ImgIOException, IncompatibleTypeException {
        this.writeImg(img.getSource(), w, img, imageIndex, config);
    }

    public static String guessDimOrder(CalibratedAxis[] axes, long[] dimLengths, long[] newLengths) {
        int i;
        String oldOrder = "";
        String newOrder = "";
        for (int i2 = 0; i2 < newLengths.length; ++i2) {
            newLengths[i2] = 1L;
        }
        boolean[] haveDim = new boolean[5];
        int contiguousUnknown = 0;
        int missingAxisCount = 0;
        boolean unknownBlock = false;
        block18: for (int i3 = 0; i3 < axes.length; ++i3) {
            switch (axes[i3].type().getLabel().toUpperCase().charAt(0)) {
                case 'X': {
                    oldOrder = oldOrder + "X";
                    haveDim[0] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Y': {
                    oldOrder = oldOrder + "Y";
                    haveDim[1] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'Z': {
                    oldOrder = oldOrder + "Z";
                    haveDim[2] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'C': {
                    oldOrder = oldOrder + "C";
                    haveDim[3] = true;
                    unknownBlock = false;
                    continue block18;
                }
                case 'T': {
                    oldOrder = oldOrder + "T";
                    haveDim[4] = true;
                    unknownBlock = false;
                    continue block18;
                }
                default: {
                    oldOrder = oldOrder + "U";
                    if (dimLengths[i3] <= 1L || unknownBlock) continue block18;
                    unknownBlock = true;
                    ++contiguousUnknown;
                }
            }
        }
        for (boolean d : haveDim) {
            if (d) continue;
            ++missingAxisCount;
        }
        if (contiguousUnknown > missingAxisCount) {
            return null;
        }
        int axesPlaced = 0;
        unknownBlock = false;
        boolean sizeOneUnknown = false;
        block20: for (i = 0; i < axes.length; ++i) {
            switch (oldOrder.charAt(0)) {
                case 'U': {
                    if (dimLengths[i] <= 1L && contiguousUnknown >= missingAxisCount) continue block20;
                    if (!unknownBlock) {
                        unknownBlock = true;
                        if (contiguousUnknown < missingAxisCount) {
                            ++contiguousUnknown;
                            sizeOneUnknown = true;
                        }
                        if (!haveDim[0]) {
                            newOrder = newOrder + "X";
                            haveDim[0] = true;
                        } else if (!haveDim[1]) {
                            newOrder = newOrder + "Y";
                            haveDim[1] = true;
                        } else if (!haveDim[2]) {
                            newOrder = newOrder + "Z";
                            haveDim[2] = true;
                        } else if (!haveDim[3]) {
                            newOrder = newOrder + "C";
                            haveDim[3] = true;
                        } else if (!haveDim[4]) {
                            newOrder = newOrder + "T";
                            haveDim[4] = true;
                        }
                    } else if (dimLengths[i] > 1L && sizeOneUnknown) {
                        sizeOneUnknown = false;
                        --contiguousUnknown;
                    }
                    int n = axesPlaced;
                    newLengths[n] = newLengths[n] * dimLengths[i];
                    continue block20;
                }
                default: {
                    if (unknownBlock) {
                        ++axesPlaced;
                        unknownBlock = false;
                        sizeOneUnknown = false;
                    }
                    newOrder = newOrder + oldOrder.charAt(i);
                    newLengths[axesPlaced] = dimLengths[i];
                    ++axesPlaced;
                }
            }
        }
        block21: for (i = 0; i < haveDim.length; ++i) {
            if (haveDim[i]) continue;
            switch (i) {
                case 0: {
                    newOrder = newOrder + "X";
                    continue block21;
                }
                case 1: {
                    newOrder = newOrder + "Y";
                    continue block21;
                }
                case 2: {
                    newOrder = newOrder + "Z";
                    continue block21;
                }
                case 3: {
                    newOrder = newOrder + "C";
                    continue block21;
                }
                case 4: {
                    newOrder = newOrder + "T";
                }
            }
        }
        return newOrder;
    }

    private Metadata writeImg(String id, Writer w, SCIFIOImgPlus<?> img, int imageIndex, SCIFIOConfig config) throws ImgIOException, IncompatibleTypeException {
        if (config == null) {
            config = new SCIFIOConfig();
        }
        int sliceCount = this.countSlices(img);
        if (w == null) {
            if (id == null || id.length() == 0) {
                throw new ImgIOException("No output destination or pre-configured Writer was provided, and no way to determine the desired output path. Default value: ImgPlus's source.");
            }
            return this.writeImg(id, img, imageIndex, config, sliceCount);
        }
        return this.writeImg(w, id, img, imageIndex, config, sliceCount);
    }

    private Metadata writeImg(String id, SCIFIOImgPlus<?> imgPlus, int imageIndex, SCIFIOConfig config, int sliceCount) throws ImgIOException, IncompatibleTypeException {
        Writer w = null;
        try {
            File f;
            boolean matches = false;
            for (Format format : this.formatService.getFormatList(id)) {
                if (format.getWriterClass().equals(DefaultWriter.class)) continue;
                matches = true;
                break;
            }
            if (matches && (f = new File(id)).exists()) {
                f.delete();
            }
            w = this.formatService.getWriterByExtension(id);
        }
        catch (FormatException e) {
            throw new ImgIOException(e);
        }
        return this.writeImg(w, id, imgPlus, imageIndex, config, sliceCount);
    }

    private Metadata writeImg(Writer w, String id, SCIFIOImgPlus<?> imgPlus, int imageIndex, SCIFIOConfig config, int sliceCount) throws ImgIOException, IncompatibleTypeException {
        if (w.getMetadata() == null) {
            if (id == null || id.length() == 0) {
                throw new ImgIOException("A Writer with no Metadata was provided, with no way to determine the desired output path. Default value: ImgPlus's source.");
            }
            try {
                this.populateMeta(w, imgPlus, config, id, imageIndex);
            }
            catch (FormatException e) {
                throw new ImgIOException(e, "SCIFIO exception when writing to file " + id + ":\n" + e.getMessage());
            }
            catch (IOException e) {
                throw new ImgIOException(e, "I/O exception writing to file " + id + ":\n" + e.getMessage());
            }
        }
        return this.writeImg(w, imgPlus, imageIndex, sliceCount);
    }

    private Metadata writeImg(Writer w, SCIFIOImgPlus<?> imgPlus, int imageIndex, int sliceCount) throws ImgIOException, IncompatibleTypeException {
        if (imgPlus.numDimensions() > 0) {
            long startTime = System.currentTimeMillis();
            this.writePlanes(w, imageIndex, imgPlus);
            long endTime = System.currentTimeMillis();
            float time = (float)(endTime - startTime) / 1000.0f;
            this.statusService.showStatus(sliceCount, sliceCount, w.getMetadata().getDatasetName() + ": wrote " + sliceCount + " planes in " + time + " s");
        }
        return w.getMetadata();
    }

    private int countSlices(SCIFIOImgPlus<?> img) {
        int sliceCount = 1;
        for (int i = 0; i < img.numDimensions(); ++i) {
            if (((CalibratedAxis)img.axis(i)).type().equals(Axes.X) || ((CalibratedAxis)img.axis(i)).type().equals(Axes.Y)) continue;
            sliceCount = (int)((long)sliceCount * img.dimension(i));
        }
        return sliceCount;
    }

    private void writePlanes(Writer w, int imageIndex, SCIFIOImgPlus<?> imgPlus) throws ImgIOException, IncompatibleTypeException {
        Metadata mOut = w.getMetadata();
        this.validate(mOut, w);
        int rgbChannelCount = mOut.get(imageIndex).isMultichannel() ? (int)mOut.get(imageIndex).getAxisLength(Axes.CHANNEL) : 1;
        boolean interleaved = mOut.get(imageIndex).getInterleavedAxisCount() > 0;
        byte[] sourcePlane = null;
        long planeOutCount = w.getMetadata().get(imageIndex).getPlaneCount();
        Img img = imgPlus.getImg();
        int planeCount = this.getPlaneCount(img);
        if (planeOutCount < (long)(planeCount / rgbChannelCount)) {
            this.statusService.showStatus(0, 0, "Source dataset contains: " + planeCount + " planes, but writer format only supports: " + (long)rgbChannelCount * planeOutCount, true);
        }
        int planeIndex = 0;
        while ((long)planeIndex < planeOutCount) {
            this.statusService.showStatus(planeIndex, (int)planeOutCount, "Saving plane " + (planeIndex + 1) + "/" + planeOutCount);
            try {
                Metadata meta = w.getMetadata();
                long[] planarLengths = meta.get(imageIndex).getAxesLengthsPlanar();
                long[] planarMin = SCIFIOMetadataTools.modifyPlanar(imageIndex, meta, new long[planarLengths.length]);
                ByteArrayPlane destPlane = new ByteArrayPlane(this.getContext(), meta.get(imageIndex), planarMin, planarLengths);
                for (int cIndex = 0; cIndex < rgbChannelCount; ++cIndex) {
                    Object curPlane = this.getPlaneArray(img, rgbChannelCount, cIndex, planeIndex);
                    Class<?> planeClass = curPlane.getClass();
                    if (planeClass == int[].class) {
                        sourcePlane = Bytes.fromInts((int[])((int[])curPlane), (boolean)false);
                    } else if (planeClass == byte[].class) {
                        sourcePlane = (byte[])curPlane;
                    } else if (planeClass == short[].class) {
                        sourcePlane = Bytes.fromShorts((short[])((short[])curPlane), (boolean)false);
                    } else if (planeClass == long[].class) {
                        sourcePlane = Bytes.fromLongs((long[])((long[])curPlane), (boolean)false);
                    } else if (planeClass == double[].class) {
                        sourcePlane = Bytes.fromDoubles((double[])((double[])curPlane), (boolean)false);
                    } else if (planeClass == float[].class) {
                        sourcePlane = Bytes.fromFloats((float[])((float[])curPlane), (boolean)false);
                    } else {
                        throw new IncompatibleTypeException((Object)new ImgLibException(), "Plane data type: " + planeClass + " not supported.");
                    }
                    if (interleaved) {
                        int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
                        for (int i = 0; i < sourcePlane.length / bpp; i += bpp) {
                            System.arraycopy(sourcePlane, i, destPlane.getData(), (i * rgbChannelCount + cIndex) * bpp, bpp);
                        }
                        continue;
                    }
                    System.arraycopy(sourcePlane, 0, destPlane.getData(), cIndex * sourcePlane.length, sourcePlane.length);
                }
                w.savePlane(imageIndex, planeIndex, destPlane);
            }
            catch (FormatException e) {
                throw new ImgIOException(e);
            }
            catch (IOException e) {
                throw new ImgIOException(e);
            }
            ++planeIndex;
        }
        try {
            w.close();
        }
        catch (IOException e) {
            throw new ImgIOException(e);
        }
    }

    private void validate(Metadata meta, Writer w) {
        if (meta == null) {
            throw new IllegalStateException("No Metadata attached to " + w.getFormat().getFormatName() + " writer.");
        }
    }

    private Object getPlaneArray(Img<?> img, int rgbChannelCount, int cIndex, int planeIndex) {
        if (PlanarImg.class.isAssignableFrom(img.getClass())) {
            PlanarImg planarImg = (PlanarImg)img;
            return planarImg.getPlane(cIndex + planeIndex * rgbChannelCount).getCurrentStorageArray();
        }
        int planeSize = (int)(img.dimension(0) * img.dimension(1));
        if (ArrayImg.class.isAssignableFrom(img.getClass())) {
            ArrayImg arrayImg = (ArrayImg)img;
            Object store = arrayImg.update(null);
            if (store instanceof ByteArray) {
                byte[] source = ((ByteArray)store).getCurrentStorageArray();
                byte[] bytes = new byte[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), bytes, 0, bytes.length);
                return bytes;
            }
            if (store instanceof ShortArray) {
                short[] source = ((ShortArray)store).getCurrentStorageArray();
                short[] shorts = new short[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), shorts, 0, shorts.length);
                return shorts;
            }
            if (store instanceof LongArray) {
                long[] source = ((LongArray)store).getCurrentStorageArray();
                long[] longs = new long[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), longs, 0, longs.length);
                return longs;
            }
            if (store instanceof CharArray) {
                char[] source = ((CharArray)store).getCurrentStorageArray();
                char[] chars = new char[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), chars, 0, chars.length);
                return chars;
            }
            if (store instanceof DoubleArray) {
                double[] source = ((DoubleArray)store).getCurrentStorageArray();
                double[] doubles = new double[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), doubles, 0, doubles.length);
                return doubles;
            }
            if (store instanceof FloatArray) {
                float[] source = ((FloatArray)store).getCurrentStorageArray();
                float[] floats = new float[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), floats, 0, floats.length);
                return floats;
            }
            if (store instanceof IntArray) {
                int[] source = ((IntArray)store).getCurrentStorageArray();
                int[] ints = new int[planeSize];
                System.arraycopy(source, planeSize * (cIndex + planeIndex * rgbChannelCount), ints, 0, ints.length);
                return ints;
            }
        }
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        long[] lengths = Arrays.copyOfRange(dimensions, 2, dimensions.length);
        long[] planePosition = FormatTools.rasterToPosition(lengths, cIndex + planeIndex * rgbChannelCount);
        System.arraycopy(planePosition, 0, dimensions, 2, planePosition.length);
        dimensions[1] = 0L;
        dimensions[0] = 0L;
        Class<?> typeClass = img.firstElement().getClass();
        Object[] array = null;
        if (GenericIntType.class.isAssignableFrom(typeClass)) {
            array = new int[planeSize];
        } else if (GenericByteType.class.isAssignableFrom(typeClass)) {
            array = new byte[planeSize];
        } else if (GenericShortType.class.isAssignableFrom(typeClass)) {
            array = new short[planeSize];
        } else if (LongType.class.isAssignableFrom(typeClass)) {
            array = new long[planeSize];
        } else if (DoubleType.class.isAssignableFrom(typeClass)) {
            array = new double[planeSize];
        } else if (FloatType.class.isAssignableFrom(typeClass)) {
            array = new float[planeSize];
        }
        if (array == null) {
            throw new IllegalArgumentException("Unsupported ImgPlus data type: " + typeClass);
        }
        RandomAccess randomAccess = img.randomAccess();
        randomAccess.setPosition(dimensions);
        int idx = 0;
        int i = 0;
        while ((long)i < img.dimension(1)) {
            int j = 0;
            while ((long)j < img.dimension(0)) {
                Object value = randomAccess.get();
                if (GenericIntType.class.isAssignableFrom(typeClass)) {
                    array[idx++] = (int)((ComplexType)value).getRealDouble();
                } else if (GenericByteType.class.isAssignableFrom(typeClass)) {
                    ((byte[])array)[idx++] = (byte)((ComplexType)value).getRealDouble();
                } else if (GenericShortType.class.isAssignableFrom(typeClass)) {
                    ((short[])array)[idx++] = (short)((ComplexType)value).getRealDouble();
                } else if (LongType.class.isAssignableFrom(typeClass)) {
                    ((long[])array)[idx++] = (long)((ComplexType)value).getRealDouble();
                } else if (DoubleType.class.isAssignableFrom(typeClass)) {
                    ((double[])array)[idx++] = ((ComplexType)value).getRealDouble();
                } else if (FloatType.class.isAssignableFrom(typeClass)) {
                    ((float[])array)[idx++] = (float)((ComplexType)value).getRealDouble();
                }
                randomAccess.fwd(0);
                ++j;
            }
            dimensions[1] = dimensions[1] + 1L;
            randomAccess.setPosition(dimensions);
            ++i;
        }
        return array;
    }

    private int getPlaneCount(Img<?> img) {
        if (PlanarImg.class.isAssignableFrom(img.getClass())) {
            PlanarImg planarImg = (PlanarImg)img;
            return planarImg.numSlices();
        }
        int count = 1;
        for (int d = 2; d < img.numDimensions(); ++d) {
            count = (int)((long)count * img.dimension(d));
        }
        return count;
    }

    private void populateMeta(Writer w, SCIFIOImgPlus<?> img, SCIFIOConfig config, String id, int imageIndex) throws FormatException, IOException, ImgIOException {
        this.statusService.showStatus("Initializing " + img.getName());
        Metadata meta = w.getFormat().createMetadata();
        Metadata imgMeta = img.getMetadata();
        ArrayList<ImageMetadata> imageMeta = new ArrayList<ImageMetadata>();
        if (imgMeta == null) {
            imgMeta = new DefaultMetadata();
            imgMeta.createImageMetadata(1);
            imageMeta.add(imgMeta.get(0));
        } else {
            for (int i = 0; i < imgMeta.getImageCount(); ++i) {
                imageMeta.add(new DefaultImageMetadata());
            }
        }
        int pixelType = this.utils().makeType(img.firstElement());
        CalibratedAxis[] axes = new CalibratedAxis[img.numDimensions()];
        img.axes((Axis[])axes);
        long[] axisLengths = new long[img.numDimensions()];
        img.dimensions(axisLengths);
        for (ImageMetadata iMeta : imageMeta) {
            iMeta.populate(img.getName(), Arrays.asList(axes), axisLengths, pixelType, true, false, false, false, true);
            if (img.getCompositeChannelCount() <= 1) continue;
            if (config.imgSaverGetWriteRGB()) {
                iMeta.setPlanarAxisCount(3);
            }
            iMeta.setAxisType(2, Axes.CHANNEL);
            if (iMeta.getAxisLength(Axes.CHANNEL) <= (long)img.getCompositeChannelCount()) continue;
            iMeta.addAxis(Axes.get((String)"Channel-planes", (boolean)false), iMeta.getAxisLength(Axes.CHANNEL) / (long)img.getCompositeChannelCount());
            iMeta.setAxisLength(Axes.CHANNEL, (long)img.getCompositeChannelCount());
        }
        Translator t = this.translatorService.findTranslator(imgMeta, meta, false);
        t.translate(imgMeta, imageMeta, meta);
        w.setMetadata(meta);
        w.setDest(id, imageIndex, config);
    }
}

