/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.gui.AWTImageTools;
import io.scif.services.InitializeService;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.imagej.axis.CalibratedAxis;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class PreviewPane
extends JPanel
implements PropertyChangeListener,
Runnable {
    @Parameter
    LogService logService;
    @Parameter
    InitializeService initializeService;
    private Reader reader;
    private String loadId;
    private String lastId;
    private Thread loader;
    private boolean loaderAlive;
    private Runnable refresher;
    private final JLabel iconLabel;
    private final JLabel formatLabel;
    private final JLabel resLabel;
    private final JLabel zctLabel;
    private final JLabel typeLabel;
    private ImageIcon icon;
    private String iconText;
    private String formatText;
    private String resText;
    private String npText;
    private String typeText;
    private String iconTip;
    private String formatTip;
    private String resTip;
    private String zctTip;
    private String typeTip;

    public PreviewPane(Context context, JFileChooser jc) {
        context.inject((Object)this);
        this.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(128, -1));
        this.iconLabel.setAlignmentX(0.5f);
        this.add(this.iconLabel);
        this.add(Box.createVerticalStrut(7));
        this.formatLabel = new JLabel();
        this.formatLabel.setAlignmentX(0.5f);
        this.add(this.formatLabel);
        this.add(Box.createVerticalStrut(5));
        this.resLabel = new JLabel();
        this.resLabel.setAlignmentX(0.5f);
        this.add(this.resLabel);
        this.zctLabel = new JLabel();
        this.zctLabel.setAlignmentX(0.5f);
        this.add(this.zctLabel);
        this.typeLabel = new JLabel();
        this.typeLabel.setAlignmentX(0.5f);
        this.add(this.typeLabel);
        Font font = this.formatLabel.getFont();
        font = font.deriveFont(font.getSize2D() - 3.0f);
        this.formatLabel.setFont(font);
        this.resLabel.setFont(font);
        this.zctLabel.setFont(font);
        this.typeLabel.setFont(font);
        this.icon = null;
        this.typeText = "";
        this.npText = "";
        this.resText = "";
        this.formatText = "";
        this.iconText = "";
        this.typeTip = null;
        this.zctTip = null;
        this.resTip = null;
        this.formatTip = null;
        this.iconTip = null;
        if (jc != null) {
            jc.setAccessory(this);
            jc.addPropertyChangeListener(this);
            this.refresher = new Runnable(){

                @Override
                public void run() {
                    PreviewPane.this.iconLabel.setIcon(PreviewPane.this.icon);
                    PreviewPane.this.iconLabel.setText(PreviewPane.this.iconText);
                    PreviewPane.this.iconLabel.setToolTipText(PreviewPane.this.iconTip);
                    PreviewPane.this.formatLabel.setText(PreviewPane.this.formatText);
                    PreviewPane.this.formatLabel.setToolTipText(PreviewPane.this.formatTip);
                    PreviewPane.this.resLabel.setText(PreviewPane.this.resText);
                    PreviewPane.this.resLabel.setToolTipText(PreviewPane.this.resTip);
                    PreviewPane.this.zctLabel.setText(PreviewPane.this.npText);
                    PreviewPane.this.zctLabel.setToolTipText(PreviewPane.this.zctTip);
                    PreviewPane.this.typeLabel.setText(PreviewPane.this.typeText);
                    PreviewPane.this.typeLabel.setToolTipText(PreviewPane.this.typeTip);
                }
            };
            this.loaderAlive = true;
            this.loader = new Thread((Runnable)this, "Preview");
            this.loader.start();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        return new Dimension(148, prefSize.height);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("JFileChooserDialogIsClosingProperty")) {
            this.loaderAlive = false;
        }
        if (!prop.equals("SelectedFileChangedProperty")) {
            return;
        }
        File f = (File)e.getNewValue();
        if (f != null && (f.isDirectory() || !f.exists())) {
            f = null;
        }
        this.loadId = f == null ? null : f.getAbsolutePath();
    }

    @Override
    public void run() {
        while (this.loaderAlive) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                this.logService.info((Object)"", (Throwable)exc);
            }
            try {
                String format;
                String id = this.loadId;
                if (id == this.lastId) continue;
                this.lastId = id;
                this.icon = null;
                this.iconText = id == null ? "" : "Reading...";
                this.typeText = "";
                this.npText = "";
                this.resText = "";
                this.formatText = "";
                this.iconTip = id;
                this.typeTip = "";
                this.zctTip = "";
                this.resTip = "";
                this.formatTip = "";
                if (id == null) {
                    SwingUtilities.invokeLater(this.refresher);
                    continue;
                }
                try {
                    this.reader = this.initializeService.initializeReader(id);
                    this.reader.setNormalized(true);
                }
                catch (FormatException exc) {
                    this.logService.debug((Object)("Failed to initialize " + id), (Throwable)exc);
                    boolean badFormat = exc.getMessage().startsWith("Unknown file format");
                    this.iconText = "Unsupported " + (badFormat ? "format" : "file");
                    this.resText = "";
                    this.formatText = "";
                    SwingUtilities.invokeLater(this.refresher);
                    this.lastId = null;
                    continue;
                }
                catch (IOException exc) {
                    this.logService.debug((Object)("Failed to initialize " + id), (Throwable)exc);
                    this.iconText = "Unsupported file";
                    this.resText = "";
                    this.formatText = "";
                    SwingUtilities.invokeLater(this.refresher);
                    this.lastId = null;
                    continue;
                }
                if (id != this.loadId) {
                    SwingUtilities.invokeLater(this.refresher);
                    continue;
                }
                this.icon = new ImageIcon(this.makeImage("Loading..."));
                this.iconText = "";
                this.formatText = format = this.reader.getFormat().getFormatName();
                this.formatTip = format;
                ImageMetadata iMeta = this.reader.getMetadata().get(0);
                this.resText = this.getText(iMeta, iMeta.getAxesPlanar());
                this.npText = this.getText(iMeta, iMeta.getAxesNonPlanar());
                SwingUtilities.invokeLater(this.refresher);
                long planeIndex = iMeta.getPlaneCount() / 2L;
                Plane thumbPlane = null;
                try {
                    thumbPlane = this.reader.openPlane(0, planeIndex);
                }
                catch (FormatException exc) {
                    this.logService.debug((Object)("Failed to read thumbnail #" + planeIndex + " from " + id), (Throwable)exc);
                }
                catch (IOException exc) {
                    this.logService.debug((Object)("Failed to read thumbnail #" + planeIndex + " from " + id), (Throwable)exc);
                }
                BufferedImage thumb = AWTImageTools.openThumbImage(thumbPlane, this.reader, 0, iMeta.getAxesLengthsPlanar(), (int)iMeta.getThumbSizeX(), (int)iMeta.getThumbSizeY(), false);
                this.icon = new ImageIcon(thumb == null ? this.makeImage("Failed") : thumb);
                this.iconText = "";
                SwingUtilities.invokeLater(this.refresher);
            }
            catch (Exception exc) {
                this.logService.info((Object)"", (Throwable)exc);
                this.icon = null;
                this.iconText = "Thumbnail failure";
                this.typeText = "";
                this.npText = "";
                this.resText = "";
                this.formatText = "";
                this.iconTip = this.loadId;
                this.typeTip = "";
                this.zctTip = "";
                this.resTip = "";
                this.formatTip = "";
                SwingUtilities.invokeLater(this.refresher);
            }
        }
    }

    private String getText(ImageMetadata meta, List<CalibratedAxis> axes) {
        String text = "";
        for (CalibratedAxis axis : axes) {
            if (text.length() > 0) {
                text = text + " x ";
            }
            text = text + meta.getAxisLength(axis) + " " + axis.type().getLabel();
        }
        return text;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private BufferedImage makeImage(String message) {
        ImageMetadata iMeta = this.reader.getMetadata().get(0);
        int w = (int)iMeta.getThumbSizeX();
        int h = (int)iMeta.getThumbSizeY();
        if (w < 128) {
            w = 128;
        }
        if (h < 32) {
            h = 32;
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        Rectangle2D.Float r = (Rectangle2D.Float)g.getFont().getStringBounds(message, g.getFontRenderContext());
        g.drawString(message, ((float)w - r.width) / 2.0f, ((float)h - r.height) / 2.0f + r.height);
        g.dispose();
        return image;
    }
}

