/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.BufferedImagePlane;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.config.SCIFIOConfig;
import io.scif.gui.AWTImageTools;
import io.scif.gui.BufferedImageReader;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;

public abstract class ImageIOFormat
extends AbstractFormat {

    @Plugin(type=Translator.class, priority=-100.0)
    public static class ImageIOTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        protected void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            dest.createImageMetadata(1);
            ImageMetadata imgMeta = source.get(0);
            dest.setImg(AWTImageTools.blankImage(imgMeta, imgMeta.getAxesLengthsPlanar(), imgMeta.getPixelType()));
        }
    }

    public static class Writer<M extends Metadata>
    extends AbstractWriter<M> {
        private final String kind;

        public Writer(String kind) {
            this.kind = kind;
        }

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            if (!SCIFIOMetadataTools.wholePlane(imageIndex, meta, planeMin, planeMax)) {
                throw new FormatException("ImageIOWriter does not support writing tiles");
            }
            BufferedImage img = null;
            if (!(plane instanceof BufferedImagePlane)) {
                int type = meta.get(imageIndex).getPixelType();
                img = AWTImageTools.makeImage(plane.getBytes(), (int)meta.get(imageIndex).getAxisLength(Axes.X), (int)meta.get(imageIndex).getAxisLength(Axes.Y), (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL), plane.getImageMetadata().getInterleavedAxisCount() > 0, FormatTools.getBytesPerPixel(type), FormatTools.isFloatingPoint(type), meta.get(imageIndex).isLittleEndian(), FormatTools.isSigned(type));
            } else {
                img = (BufferedImage)((BufferedImagePlane)plane).getData();
            }
            ImageIO.write((RenderedImage)img, this.kind, this.getStream());
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{1, 3};
        }
    }

    public static class Reader<M extends Metadata>
    extends BufferedImageReader<M> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public BufferedImagePlane openPlane(int imageIndex, long planeIndex, BufferedImagePlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            plane.setData(AWTImageTools.getSubimage(meta.getImg(), meta.get(imageIndex).isLittleEndian(), planeMin, planeMax));
            return plane;
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            return ((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
        }
    }

    public static class Parser<M extends Metadata>
    extends AbstractParser<M> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, M meta, SCIFIOConfig config) throws IOException, FormatException {
            this.log().info((Object)"Populating metadata");
            DataInputStream dis = new DataInputStream(stream);
            BufferedImage img = ImageIO.read(dis);
            if (img == null) {
                throw new FormatException("Invalid image stream");
            }
            ((Metadata)meta).setImg(img);
            ((AbstractMetadata)meta).createImageMetadata(1);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private BufferedImage img;

        public BufferedImage getImg() {
            return this.img;
        }

        public void setImg(BufferedImage img) {
            this.img = img;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            if (this.img != null) {
                iMeta.setAxisLength(Axes.X, (long)this.img.getWidth());
                iMeta.setAxisLength(Axes.Y, (long)this.img.getHeight());
                iMeta.setPlanarAxisCount(2);
                int channels = this.img.getRaster().getNumBands();
                if (channels > 1) {
                    iMeta.setPlanarAxisCount(3);
                    iMeta.setAxisLength(Axes.CHANNEL, (long)this.img.getRaster().getNumBands());
                }
                iMeta.setPixelType(AWTImageTools.getPixelType(this.img));
            }
            iMeta.setLittleEndian(false);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.img = null;
            }
        }
    }
}

