/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.FormatException;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.io.RandomAccessInputStream;
import java.io.IOException;
import java.util.Random;

public abstract class AbstractCodec
extends AbstractSCIFIOPlugin
implements Codec {
    public void test() throws FormatException {
        int i;
        byte[] testdata = new byte[50000];
        Random r = new Random();
        this.log().info((Object)("Testing " + this.getClass().getName()));
        this.log().info((Object)"Generating random data");
        r.nextBytes(testdata);
        this.log().info((Object)"Compressing data");
        byte[] compressed = this.compress(testdata, null);
        this.log().info((Object)("Compressed size: " + compressed.length));
        this.log().info((Object)"Decompressing data");
        byte[] decompressed = this.decompress(compressed);
        this.log().info((Object)"Comparing data...");
        if (testdata.length != decompressed.length) {
            this.log().info((Object)"Test data differs in length from uncompressed data");
            this.log().info((Object)"Exiting...");
            System.exit(-1);
        } else {
            boolean equalsFlag = true;
            for (i = 0; i < testdata.length; ++i) {
                if (testdata[i] == decompressed[i]) continue;
                this.log().info((Object)("Test data and uncompressed data differ at byte " + i));
                equalsFlag = false;
            }
            if (!equalsFlag) {
                this.log().info((Object)"Comparison failed. Exiting...");
                System.exit(-1);
            }
        }
        this.log().info((Object)"Success.");
        this.log().info((Object)"Generating 2D byte array test");
        byte[][] twoDtest = new byte[100][500];
        for (i = 0; i < 100; ++i) {
            System.arraycopy(testdata, 500 * i, twoDtest[i], 0, 500);
        }
        byte[] twoDcompressed = this.compress(twoDtest, null);
        this.log().info((Object)"Comparing compressed data...");
        if (twoDcompressed.length != compressed.length) {
            this.log().info((Object)"1D and 2D compressed data not same length");
            this.log().info((Object)"Exiting...");
            System.exit(-1);
        }
        boolean equalsFlag = true;
        for (int i2 = 0; i2 < twoDcompressed.length; ++i2) {
            if (twoDcompressed[i2] != compressed[i2]) {
                this.log().info((Object)("1D data and 2D compressed data differs at byte " + i2));
                equalsFlag = false;
            }
            if (equalsFlag) continue;
            this.log().info((Object)"Comparison failed. Exiting...");
            System.exit(-1);
        }
        this.log().info((Object)"Success.");
        this.log().info((Object)"Test complete.");
    }

    @Override
    public byte[] compress(byte[][] data, CodecOptions options) throws FormatException {
        int len = 0;
        for (int i = 0; i < data.length; ++i) {
            len += data[i].length;
        }
        byte[] toCompress = new byte[len];
        int curPos = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, toCompress, curPos, data[i].length);
            curPos += data[i].length;
        }
        return this.compress(toCompress, options);
    }

    @Override
    public byte[] decompress(byte[] data) throws FormatException {
        return this.decompress(data, null);
    }

    @Override
    public byte[] decompress(byte[][] data) throws FormatException {
        return this.decompress(data, null);
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws FormatException {
        try {
            RandomAccessInputStream r = new RandomAccessInputStream(this.getContext(), data);
            byte[] t = this.decompress(r, options);
            r.close();
            return t;
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
    }

    @Override
    public abstract byte[] decompress(RandomAccessInputStream var1, CodecOptions var2) throws FormatException, IOException;

    @Override
    public byte[] decompress(byte[][] data, CodecOptions options) throws FormatException {
        if (data == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        int len = 0;
        for (byte[] aData1 : data) {
            len += aData1.length;
        }
        byte[] toDecompress = new byte[len];
        int curPos = 0;
        for (byte[] aData : data) {
            System.arraycopy(aData, 0, toDecompress, curPos, aData.length);
            curPos += aData.length;
        }
        return this.decompress(toDecompress, options);
    }
}

