/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.beanshell;

import bsh.Interpreter;
import bsh.NameSpace;
import bsh.UtilEvalError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

public class BeanshellBindings
implements Bindings {
    protected final Interpreter interpreter;
    protected final NameSpace nameSpace;

    public BeanshellBindings(Interpreter interpreter) {
        this.interpreter = interpreter;
        this.nameSpace = interpreter.getNameSpace();
    }

    @Override
    public int size() {
        return this.nameSpace.getVariableNames().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object value2 : this.values()) {
            if (!value.equals(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        try {
            return this.nameSpace.get((String)key, this.interpreter);
        }
        catch (UtilEvalError e) {
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.get(key);
        try {
            this.nameSpace.setVariable(key, value, false);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result = this.get(key);
        this.nameSpace.unsetVariable((String)key);
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.nameSpace.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (String name : this.nameSpace.getVariableNames()) {
            result.add(name);
        }
        return result;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : this.nameSpace.getVariableNames()) {
            try {
                result.add(this.nameSpace.get(name, this.interpreter));
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (final String name : this.nameSpace.getVariableNames()) {
            result.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return name;
                }

                @Override
                public Object getValue() {
                    return BeanshellBindings.this.get(name);
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return result;
    }
}

