/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.log.LogService;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.widget.SpinnerNumberModelFactory;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.NumberWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingNumberWidget
extends SwingInputWidget<Number>
implements NumberWidget<JPanel>,
AdjustmentListener,
ChangeListener,
MouseWheelListener {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private LogService log;
    private JScrollBar scrollBar;
    private JSlider slider;
    private JSpinner spinner;

    public Number getValue() {
        return (Number)this.spinner.getValue();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        Number min = model.getMin();
        Number max = model.getMax();
        Number softMin = model.getSoftMin();
        Number softMax = model.getSoftMax();
        Number stepSize = model.getStepSize();
        if (model.isStyle("scroll bar")) {
            this.addScrollBar(softMin, softMax, stepSize);
        } else if (model.isStyle("slider")) {
            this.addSlider(softMin, softMax, stepSize);
        }
        Class type = model.getItem().getType();
        Number value = (Number)model.getValue();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModelFactory().createModel(value, min, max, stepSize);
        this.spinner = new JSpinner(spinnerModel);
        this.fixSpinner(type);
        this.setToolTip(this.spinner);
        this.getComponent().add(this.spinner);
        this.limitWidth(200);
        this.spinner.addChangeListener(this);
        this.refreshWidget();
        this.syncSliders();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isNumber();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = this.scrollBar.getValue();
        this.spinner.setValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.slider) {
            int value = this.slider.getValue();
            this.spinner.setValue(value);
        } else if (source == this.spinner) {
            this.syncSliders();
        }
        this.updateModel();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int value = this.getValue().intValue() + e.getWheelRotation();
        value = Math.min(value, this.get().getMax().intValue());
        value = Math.max(value, this.get().getMin().intValue());
        this.spinner.setValue(value);
        this.syncSliders();
    }

    private void addScrollBar(Number min, Number max, Number step) {
        int mx;
        if (min == null || max == null || step == null) {
            this.log.warn((Object)"Invalid min/max/step; cannot render scroll bar");
            return;
        }
        int mn = min.intValue();
        if (mn == Integer.MIN_VALUE) {
            mn = -2147483647;
        }
        if ((mx = max.intValue()) < Integer.MAX_VALUE) {
            ++mx;
        }
        int st = step.intValue();
        this.scrollBar = new JScrollBar(0, mn, 1, mn, mx);
        this.scrollBar.setUnitIncrement(st);
        this.setToolTip(this.scrollBar);
        this.getComponent().add(this.scrollBar);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.addMouseWheelListener(this);
    }

    private void addSlider(Number min, Number max, Number step) {
        if (min == null || max == null || step == null) {
            this.log.warn((Object)"Invalid min/max/step; cannot render slider");
            return;
        }
        int mn = min.intValue();
        int mx = max.intValue();
        int st = step.intValue();
        if ((long)mx - (long)mn > Integer.MAX_VALUE) {
            this.log.warn((Object)"Slider span too large; max - min < 2^31 required.");
            return;
        }
        int span = mx - mn;
        this.slider = new JSlider(mn, mx, mn);
        int labelWidth = Math.max(("" + mn).length(), ("" + mx).length());
        this.slider.setMajorTickSpacing(labelWidth < 5 ? span / 4 : span);
        this.slider.setPaintLabels(labelWidth < 10);
        int stepCount = span / st + 1;
        this.slider.setMinorTickSpacing(st);
        this.slider.setPaintTicks(stepCount < 100);
        this.setToolTip(this.slider);
        this.getComponent().add(this.slider);
        this.slider.addChangeListener(this);
        this.slider.addMouseWheelListener(this);
    }

    private void limitWidth(int maxWidth) {
        Dimension minSize = this.spinner.getMinimumSize();
        if (minSize.width > maxWidth) {
            minSize.width = maxWidth;
            this.spinner.setMinimumSize(minSize);
        }
        Dimension prefSize = this.spinner.getPreferredSize();
        if (prefSize.width > maxWidth) {
            prefSize.width = maxWidth;
            this.spinner.setPreferredSize(prefSize);
        }
    }

    private void fixSpinner(Class<?> type) {
        this.fixSpinnerType(type);
        this.fixSpinnerFocus();
    }

    private void fixSpinnerType(Class<?> type) {
        if (!BigDecimal.class.isAssignableFrom(type) && !BigInteger.class.isAssignableFrom(type)) {
            return;
        }
        JComponent editor = this.spinner.getEditor();
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setParseBigDecimal(true);
    }

    private void fixSpinnerFocus() {
        for (Component c : this.spinner.getEditor().getComponents()) {
            if (!(c instanceof JTextField)) continue;
            final JTextField textField = (JTextField)c;
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.queueSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.queueSelection();
                }

                private void queueSelection() {
                    SwingNumberWidget.this.threadService.queue(new Runnable(){

                        @Override
                        public void run() {
                            textField.selectAll();
                        }
                    });
                }
            });
        }
    }

    private void syncSliders() {
        int value;
        if (this.slider != null) {
            value = this.getValue().intValue();
            if (value < this.slider.getMinimum()) {
                value = this.slider.getMinimum();
            } else if (value > this.slider.getMaximum()) {
                value = this.slider.getMaximum();
            }
            this.slider.removeChangeListener(this);
            this.slider.setValue(value);
            this.slider.addChangeListener(this);
        }
        if (this.scrollBar != null) {
            value = this.getValue().intValue();
            if (value < this.scrollBar.getMinimum()) {
                value = this.scrollBar.getMinimum();
            } else if (value > this.scrollBar.getMaximum()) {
                value = this.scrollBar.getMaximum();
            }
            this.scrollBar.removeAdjustmentListener(this);
            this.scrollBar.setValue(this.getValue().intValue());
            this.scrollBar.addAdjustmentListener(this);
        }
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (this.spinner.getValue().equals(value)) {
            return;
        }
        this.spinner.setValue(value);
    }
}

