/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.widget.SwingFileWidget;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.FileListWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingFileListWidget
extends SwingInputWidget<File[]>
implements FileListWidget<JPanel>,
ActionListener,
MouseListener {
    @Parameter
    private UIService uiService;
    @Parameter
    private LogService logService;
    private JList<File> paths;
    private JButton addFilesButton;
    private JButton removeFilesButton;
    private JButton clearButton;

    public File[] getValue() {
        DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
        ArrayList fileList = Collections.list(listModel.elements());
        return fileList.toArray(new File[fileList.size()]);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.paths = new JList(new DefaultListModel());
        this.paths.setDragEnabled(true);
        String style = model.getItem().getWidgetStyle();
        this.paths.setTransferHandler(new FileListTransferHandler(style));
        JScrollPane scrollPane = new JScrollPane(this.paths);
        scrollPane.setPreferredSize(new Dimension(350, 100));
        this.paths.addMouseListener(this);
        this.setToolTip(scrollPane);
        this.getComponent().add(scrollPane);
        this.getComponent().add(Box.createHorizontalStrut(3));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
        this.addFilesButton = new JButton("Add files...");
        this.setToolTip(this.addFilesButton);
        buttonPanel.add((Component)this.addFilesButton, "wrap, grow");
        this.addFilesButton.addActionListener(this);
        this.removeFilesButton = new JButton("Remove selected");
        this.setToolTip(this.removeFilesButton);
        buttonPanel.add((Component)this.removeFilesButton, "wrap, grow");
        this.removeFilesButton.addActionListener(this);
        this.clearButton = new JButton("Clear list");
        this.setToolTip(this.clearButton);
        buttonPanel.add((Component)this.clearButton, "grow");
        this.clearButton.addActionListener(this);
        this.getComponent().add(buttonPanel);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(File[].class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
        List fileList = Collections.list(listModel.elements());
        if (e.getSource() == this.addFilesButton) {
            String style;
            WidgetModel widgetModel = this.get();
            String widgetStyle = widgetModel.getItem().getWidgetStyle();
            FileFilter filter = SwingFileWidget.createFileFilter(widgetStyle);
            if ((fileList = this.uiService.chooseFiles(null, fileList, filter, style = widgetModel.isStyle("both") ? "both" : (widgetModel.isStyle("directories") ? "directories" : "files"))) == null) {
                return;
            }
            for (File file : fileList) {
                listModel.addElement(file);
            }
        } else if (e.getSource() == this.removeFilesButton) {
            List<File> selected = this.paths.getSelectedValuesList();
            for (File f : selected) {
                listModel.removeElement(f);
            }
        } else if (e.getSource() == this.clearButton) {
            listModel.removeAllElements();
        }
        this.paths.setModel(listModel);
        this.updateModel();
    }

    protected void doRefresh() {
        File[] files = (File[])this.get().getValue();
        DefaultListModel<File> listModel = new DefaultListModel<File>();
        if (files != null) {
            for (File file : files) {
                listModel.addElement(file);
            }
        }
        this.paths.setModel(listModel);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            DefaultListModel listModel = (DefaultListModel)this.paths.getModel();
            List<File> selected = this.paths.getSelectedValuesList();
            for (File f : selected) {
                listModel.removeElement(f);
            }
            this.paths.setModel(listModel);
            this.updateModel();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class FileListTransferHandler
    extends TransferHandler {
        private final String style;

        public FileListTransferHandler(String style) {
            this.style = style;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return SwingFileWidget.hasFiles(support);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List<File> allFiles = SwingFileWidget.getFiles(support);
            if (allFiles == null) {
                return false;
            }
            FileFilter filter = SwingFileWidget.createFileFilter(this.style);
            List<File> files = SwingFileWidget.filterFiles(allFiles, filter);
            if (allFiles.size() != files.size()) {
                SwingFileListWidget.this.logService.warn((Object)("Some files were excluded for not matching the input requirements (" + this.style + ")"));
            }
            JList jlist = (JList)support.getComponent();
            DefaultListModel model = (DefaultListModel)jlist.getModel();
            files.forEach(f -> model.addElement(f));
            jlist.setModel(model);
            SwingFileListWidget.this.updateModel();
            return true;
        }
    }
}

