/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.console.OutputEvent;
import org.scijava.log.LogListener;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.thread.ThreadService;
import org.scijava.ui.console.AbstractConsolePane;
import org.scijava.ui.swing.console.ConsolePanel;
import org.scijava.ui.swing.console.LoggingPanel;

public class SwingConsolePane
extends AbstractConsolePane<JPanel> {
    public static final String LOG_FORMATTING_SETTINGS_KEY = "/log-formatting";
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService logService;
    @Parameter
    private PrefService prefService;
    private ConsolePanel consolePanel;
    private LoggingPanel loggingPanel;
    private Component window;
    private JPanel component;

    public SwingConsolePane(Context context) {
        super(context);
    }

    public void setWindow(Component window) {
        this.window = window;
    }

    public void clear() {
        this.consolePanel().clear();
    }

    public void append(OutputEvent event) {
        this.consolePanel().outputOccurred(event);
    }

    public void show() {
        if (this.window == null || this.window.isVisible()) {
            return;
        }
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                SwingConsolePane.this.window.setVisible(true);
            }
        });
    }

    public JPanel getComponent() {
        if (this.consolePanel == null) {
            this.initLoggingPanel();
        }
        return this.component;
    }

    public Class<JPanel> getComponentType() {
        return JPanel.class;
    }

    private ConsolePanel consolePanel() {
        if (this.consolePanel == null) {
            this.initLoggingPanel();
        }
        return this.consolePanel;
    }

    private synchronized void initLoggingPanel() {
        if (this.consolePanel != null) {
            return;
        }
        this.consolePanel = new ConsolePanel(this.threadService);
        this.loggingPanel = new LoggingPanel(this.threadService, this.prefService, LOG_FORMATTING_SETTINGS_KEY);
        this.logService.addLogListener((LogListener)this.loggingPanel);
        this.component = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Console", this.consolePanel);
        tabs.addTab("Log", this.loggingPanel);
        this.component.add((Component)tabs, "grow");
    }

    JTextPane getTextPane() {
        return this.consolePanel().getTextPane();
    }
}

