/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import java.awt.Font;

public class FontUtil {
    public static Font getFont(String fontFamilyName, int style, float size) {
        Font font = new Font(fontFamilyName, style, (int)size);
        if (!font.getFamily().startsWith(fontFamilyName)) {
            String[] similarFonts = FontUtil.getSimilarFontsList(fontFamilyName);
            font = FontUtil.getFont(similarFonts, style, (int)size);
        }
        if (size != (float)((int)size)) {
            font = font.deriveFont(size);
        }
        return font;
    }

    private static Font getFont(String[] fontNames, int style, int size) {
        String fontName;
        int iSize = size;
        Font font = null;
        String[] arr$ = fontNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(font = new Font(fontName = arr$[i$], style, iSize)).getFamily().startsWith(fontName); ++i$) {
        }
        return font;
    }

    public static String[] getSimilarFontsList(String fontFamily) {
        if (fontFamily.indexOf("Times") >= 0 || fontFamily.indexOf("Serif") >= 0) {
            return new String[]{"Times New Roman", "Times", "Liberation Serif", "Serif"};
        }
        if (fontFamily.indexOf("Arial") >= 0 || fontFamily.indexOf("Helvetica") >= 0 || fontFamily.indexOf("Sans") >= 0) {
            return new String[]{"Arial", "Helvetica", "Helvetica Neue", "Liberation Sans", "SansSerif"};
        }
        if (fontFamily.indexOf("Courier") >= 0 || fontFamily.indexOf("Mono") >= 0) {
            return new String[]{"Courier New", "Courier", "Liberation Mono", "Monospaced"};
        }
        return new String[]{fontFamily};
    }
}

