/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook.converter;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.HTMLNotebookOutputConverter;
import org.scijava.notebook.converter.HTMLTableBuilder;
import org.scijava.notebook.converter.output.HTMLTableNotebookOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class ListMapToHTMLTableNotebookConverter<K, V>
extends HTMLNotebookOutputConverter<List<Map<K, V>>, HTMLTableNotebookOutput> {
    @Override
    public Class<List<Map<K, V>>> getInputType() {
        return List.class;
    }

    @Override
    public Class<HTMLTableNotebookOutput> getOutputType() {
        return HTMLTableNotebookOutput.class;
    }

    @Override
    public boolean canConvert(ConversionRequest request) {
        Object src = request.sourceObject();
        if (src != null && src instanceof List && ((List)src).get(0) instanceof Map) {
            return super.canConvert(request);
        }
        return false;
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return false;
        }
        if (src instanceof List && ((List)src).get(0) instanceof Map) {
            Class<?> srcClass = src.getClass();
            return super.canConvert(srcClass, dest);
        }
        return false;
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        if (src instanceof List && ((List)src).get(0) instanceof Map) {
            Class<?> srcClass = src.getClass();
            return super.canConvert(srcClass, dest);
        }
        return false;
    }

    @Override
    public HTMLTableNotebookOutput convert(Object object) {
        int i;
        List table = (List)object;
        String htmlTable = HTMLTableBuilder.startTable();
        Object[] headers = ((Map)table.get(0)).keySet().toArray();
        int numCols = headers.length;
        for (i = 0; i < numCols; ++i) {
            htmlTable = htmlTable + HTMLTableBuilder.appendHeadings(this.asHTML(headers[i]), i == numCols - 1);
        }
        for (i = 0; i < table.size(); ++i) {
            for (int j = 0; j < numCols; ++j) {
                Map row = (Map)table.get(i);
                htmlTable = row.containsKey(headers[j]) ? htmlTable + HTMLTableBuilder.appendData(this.asHTML(row.get(headers[j])), j == 0, j == numCols - 1) : htmlTable + HTMLTableBuilder.appendData("&nbsp;", j == 0, j == numCols - 1);
            }
        }
        htmlTable = htmlTable + HTMLTableBuilder.endTable();
        return new HTMLTableNotebookOutput(HTMLTableBuilder.getTableStyle(false) + htmlTable);
    }
}

