/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook;

import groovy.json.JsonSlurper;
import org.scijava.notebook.converter.output.HTMLNotebookOutput;
import org.scijava.notebook.converter.output.HTMLTableNotebookOutput;
import org.scijava.notebook.converter.output.ImageNotebookOutput;
import org.scijava.notebook.converter.output.JPGImageNotebookOutput;
import org.scijava.notebook.converter.output.JSONNotebookOutput;
import org.scijava.notebook.converter.output.LatexNotebookOutput;
import org.scijava.notebook.converter.output.MarkdownNotebookOutput;
import org.scijava.notebook.converter.output.NotebookOutput;
import org.scijava.notebook.converter.output.PNGImageNotebookOutput;
import org.scijava.notebook.converter.output.PlainNotebookOutput;
import org.scijava.service.SciJavaService;

public interface NotebookService
extends SciJavaService {
    default public Object display(Object object) {
        return this.display(object, NotebookOutput.class);
    }

    default public Object display(Object object, OutputType outputType) {
        return this.display(object, outputType.outputType());
    }

    public Object display(Object var1, Class<? extends NotebookOutput> var2);

    public Object displayMimetype(String var1, String var2);

    public Object displayMimetype(String var1, Object var2);

    default public Object html(String content) {
        return this.display((Object)content, HTMLNotebookOutput.class);
    }

    default public Object markdown(String content) {
        return this.display((Object)content, MarkdownNotebookOutput.class);
    }

    default public Object latex(String content) {
        return this.display((Object)content, LatexNotebookOutput.class);
    }

    default public Object table(Object table) {
        return this.display(table, HTMLTableNotebookOutput.class);
    }

    default public Object vega(String content) {
        JsonSlurper jsonSlurper = new JsonSlurper();
        Object json = jsonSlurper.parseText(content);
        return this.displayMimetype("application/vnd.vega.v2+json", json);
    }

    default public Object vegalite(String content) {
        JsonSlurper jsonSlurper = new JsonSlurper();
        Object json = jsonSlurper.parseText(content);
        return this.displayMimetype("application/vnd.vegalite.v1+json", json);
    }

    public static enum OutputType {
        HTML(HTMLNotebookOutput.class),
        IMAGE(ImageNotebookOutput.class),
        JPEG_IMAGE(JPGImageNotebookOutput.class),
        JSON(JSONNotebookOutput.class),
        LATEX(LatexNotebookOutput.class),
        MARKDOWN(MarkdownNotebookOutput.class),
        PLAIN(PlainNotebookOutput.class),
        PNG_IMAGE(PNGImageNotebookOutput.class),
        TABLE(HTMLTableNotebookOutput.class);

        private final Class<? extends NotebookOutput> outputType;

        private OutputType(Class<? extends NotebookOutput> outputType) {
            this.outputType = outputType;
        }

        public Class<? extends NotebookOutput> outputType() {
            return this.outputType;
        }
    }
}

