/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook;

import com.twosigma.beakerx.mimetype.MIMEContainer;
import net.imagej.notebook.ImageJNotebookService;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.notebook.NotebookService;
import org.scijava.notebook.converter.output.NotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultNotebookService
extends AbstractService
implements NotebookService {
    @Parameter
    private LogService log;
    @Parameter
    private ConvertService convertService;
    @Parameter
    private ImageJNotebookService ijNotebookService;

    @Override
    public Object display(Object object, Class<? extends NotebookOutput> outputType) {
        if (this.convertService.supports(object, outputType)) {
            return this.convertService.convert(object, outputType);
        }
        return object;
    }

    @Override
    public Object displayMimetype(String mimetype, String content) {
        return new MIMEContainer(mimetype, (Object)content);
    }

    @Override
    public Object displayMimetype(String mimetype, Object content) {
        return new MIMEContainer(mimetype, content);
    }

    public Object tiles(int[] gridLayout, RandomAccessibleInterval ... images) {
        RandomAccessibleInterval rai = this.ijNotebookService.mosaic(gridLayout, images);
        return this.convertService.convert(rai, NotebookOutput.class);
    }
}

