/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.service;

import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.kernel.KernelRunner;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.KernelSocketsFactoryImpl;
import com.twosigma.beakerx.kernel.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.scijava.Context;
import org.scijava.command.CommandService;
import org.scijava.jupyter.commands.InstallScijavaKernel;
import org.scijava.jupyter.kernel.ScijavaKernel;
import org.scijava.jupyter.kernel.configuration.ScijavaKernelConfigurationFile;
import org.scijava.jupyter.kernel.evaluator.ScijavaEvaluator;
import org.scijava.jupyter.service.JupyterService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultJupyterService
extends AbstractService
implements JupyterService {
    @Parameter
    private transient LogService log;
    @Parameter
    private transient Context context;
    @Parameter
    private transient CommandService command;

    @Override
    public void installKernel(String ... args) {
        Map<String, Object> parameters = this.parseArgumentsInstall(args);
        this.installKernel((String)parameters.get("logLevel"), (String)parameters.get("pythonBinaryPath"), (String)parameters.get("classpath"), (String)parameters.get("javaBinaryPath"));
    }

    @Override
    public void installKernel(String logLevel, String pythonBinaryPath) {
        this.installKernel(logLevel, Paths.get(pythonBinaryPath, new String[0]));
    }

    @Override
    public void installKernel(String logLevel, Path pythonBinaryPath) {
        this.installKernel(logLevel, pythonBinaryPath.toFile());
    }

    @Override
    public void installKernel(String logLevel, File pythonBinaryPath) {
        this.installKernel(logLevel, pythonBinaryPath, null, null);
    }

    @Override
    public void installKernel(String logLevel, String pythonBinaryPath, String classpath, String javaBinaryPath) {
        this.installKernel(logLevel, new File(pythonBinaryPath), classpath, javaBinaryPath);
    }

    @Override
    public void installKernel(String logLevel, File pythonBinaryPath, String classpath, String javaBinaryPath) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("logLevel", logLevel);
        parameters.put("pythonBinaryPath", pythonBinaryPath);
        parameters.put("classpath", classpath);
        parameters.put("javaBinaryPath", new File(javaBinaryPath));
        this.command.run(InstallScijavaKernel.class, true, parameters);
    }

    @Override
    public void runKernel(String ... args) {
        Map<String, Object> parameters = this.parseArgumentsRun(args);
        this.runKernel((String)parameters.get("logLevel"), (String)parameters.get("connectionFile"));
    }

    @Override
    public void runKernel(String logLevel, String connectionFile) {
        this.runKernel(logLevel, Paths.get(connectionFile, new String[0]));
    }

    @Override
    public void runKernel(String logLevel, File connectionFile) {
        this.runKernel(logLevel, connectionFile.toPath());
    }

    @Override
    public void runKernel(String logLevel, Path connectionFile) {
        KernelRunner.run(() -> {
            String id = Utils.uuid();
            ScijavaKernelConfigurationFile config = new ScijavaKernelConfigurationFile(this.context, logLevel, connectionFile);
            KernelSocketsFactoryImpl kernelSocketsFactory = new KernelSocketsFactoryImpl((ConfigurationFile)config);
            ScijavaEvaluator evaluator = new ScijavaEvaluator(this.context, id, id);
            return new ScijavaKernel(this.context, id, evaluator, config, (KernelSocketsFactory)kernelSocketsFactory);
        });
    }

    private Map<String, Object> parseArgumentsRun(String ... args) {
        if (args.length > 0) {
            try {
                Options options = new Options();
                options.addOption("connectionFile", true, "Connection File Path");
                options.addOption("verbose", true, "Verbose Mode");
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(options, args);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("connectionFile", cmd.getOptionValue("connectionFile"));
                parameters.put("logLevel", cmd.getOptionValue("verbose"));
                return parameters;
            }
            catch (ParseException ex) {
                this.log.error("Error parsing arguments : " + ex.toString());
            }
        } else {
            this.log.error("No parameters passed to the Scijava kernel.");
        }
        return null;
    }

    private Map<String, Object> parseArgumentsInstall(String ... args) {
        if (args.length > 0) {
            try {
                Options options = new Options();
                options.addOption("pythonBinaryPath", true, "Python Binary Path");
                options.addOption("verbose", true, "Verbose Mode");
                options.addOption("classpath", true, "Additional JAVA classpath ?");
                options.addOption("javaBinaryPath", true, "Java Binary Path");
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(options, args);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("pythonBinaryPath", cmd.getOptionValue("pythonBinaryPath"));
                parameters.put("logLevel", cmd.getOptionValue("verbose"));
                if (cmd.getOptionValue("classpath") != null) {
                    parameters.put("classpath", cmd.getOptionValue("classpath"));
                } else {
                    parameters.put("classpath", null);
                }
                if (cmd.getOptionValue("javaBinaryPath") != null) {
                    parameters.put("javaBinaryPath", cmd.getOptionValue("javaBinaryPath"));
                } else {
                    parameters.put("javaBinaryPath", null);
                }
                return parameters;
            }
            catch (ParseException ex) {
                this.log.error("Error parsing arguments : " + ex.toString());
            }
        } else {
            this.log.error("No parameters passed to the Scijava kernel.");
        }
        return null;
    }
}

