/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.evaluator;

import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleRunner;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.notebook.converter.output.NotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.util.ClassUtils;

public class Worker
implements Runnable {
    @Parameter
    private LogService log;
    @Parameter
    private Context context;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ConvertService convertService;
    private final Map<String, ScriptEngine> scriptEngines;
    private final Map<String, ScriptLanguage> scriptLanguages;
    private String languageName;
    SimpleEvaluationObject seo = null;
    String code = null;

    Worker(Context context, Map<String, ScriptEngine> scriptEngines, Map<String, ScriptLanguage> scriptLanguages) {
        context.inject(this);
        this.scriptEngines = scriptEngines;
        this.scriptLanguages = scriptLanguages;
    }

    public void setup(SimpleEvaluationObject seo, String code, String languageName) {
        this.seo = seo;
        this.code = code;
        this.languageName = languageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScriptLanguage scriptLanguage = this.scriptLanguages.get(this.languageName);
        ScriptEngine scriptEngine = this.scriptEngines.get(this.languageName);
        StringReader input = new StringReader(this.code);
        ScriptInfo info = new ScriptInfo(this.context, "dummy.py", input);
        info.setLanguage(scriptLanguage);
        this.seo.setOutputHandler();
        try {
            Object output2;
            block10: {
                ScriptModule module = info.createModule();
                this.context.inject(module);
                Field f = ClassUtils.getField(ScriptModule.class, "scriptEngine");
                ClassUtils.setValue(f, module, scriptEngine);
                List<PreprocessorPlugin> pre = this.pluginService.createInstancesOfType(PreprocessorPlugin.class);
                List<PostprocessorPlugin> post = this.pluginService.createInstancesOfType(PostprocessorPlugin.class);
                ModuleRunner runner = new ModuleRunner(this.context, module, pre, post);
                runner.run();
                LinkedHashMap outputTable = new LinkedHashMap();
                info.outputs().forEach(output -> {
                    String name = output.getName();
                    Object value = output.getValue(module);
                    if (value != null) {
                        outputTable.put(name, value);
                    }
                });
                output2 = null;
                try {
                    if (outputTable.size() == 0) {
                        output2 = null;
                        break block10;
                    }
                    if (outputTable.size() == 1) {
                        output2 = outputTable.values().toArray()[0];
                        if (!(output2 instanceof MIMEContainer) && (output2 = this.convertService.convert(output2, NotebookOutput.class)) == null) {
                            this.log.warn("[WARNING] No suitable converter found");
                            output2 = outputTable.values().toArray()[0];
                        }
                        break block10;
                    }
                    output2 = this.convertService.convert(outputTable, NotebookOutput.class);
                    if (output2 != null) break block10;
                    this.log.warn("[WARNING] No suitable converter found");
                    output2 = outputTable;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        output2 = "[ERROR]";
                    }
                    catch (Throwable throwable) {
                        this.seo.finished(output2);
                        throw throwable;
                    }
                    this.seo.finished(output2);
                }
            }
            this.seo.finished(output2);
            this.syncBindings(scriptEngine, scriptLanguage);
        }
        catch (ThreadDeath ex) {
            this.seo.error((Object)"Execution canceled");
            this.log.error(ex);
        }
        catch (ModuleException t) {
            this.seo.error((Object)t.getMessage());
            this.log.error(t);
        }
        this.seo.clrOutputHandler();
        this.seo.executeCodeCallback();
    }

    private void syncBindings(ScriptEngine scriptEngine, ScriptLanguage scriptLanguage) {
        Bindings currentBindings = scriptEngine.getBindings(100);
        this.scriptEngines.forEach((name, engine) -> {
            Bindings bindings = engine.getBindings(100);
            currentBindings.keySet().forEach(key -> bindings.put((String)key, scriptLanguage.decode(currentBindings.get(key))));
        });
    }
}

