/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.UploaderService;
import net.imagej.util.MediaWikiClient;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.swing.StaticSwingUtils;

public class SitesDialog
extends JDialog
implements ActionListener {
    protected UpdaterFrame updaterFrame;
    protected FilesCollection files;
    protected List<UpdateSite> sites;
    protected DataModel tableModel;
    protected JTable table;
    protected JScrollPane scrollpane;
    protected JButton addNewSite;
    protected JButton addPersonalSite;
    protected JButton remove;
    protected JButton close;
    private static final String PERSONAL_SITES_URL = "http://sites.imagej.net/";

    public SitesDialog(UpdaterFrame owner, final FilesCollection files) {
        super((Frame)owner, "Manage update sites");
        this.updaterFrame = owner;
        this.files = files;
        this.sites = new ArrayList<UpdateSite>(files.getUpdateSites(true));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        this.tableModel = new DataModel();
        this.table = new JTable(this.tableModel){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                SitesDialog.this.remove.setEnabled(this.getSelectedRow() > 0);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 0 && column < this.getColumnCount() && row >= 0 && row < this.getRowCount();
            }

            @Override
            public TableCellEditor getCellEditor(final int row, final int column) {
                if (column == 0) {
                    return super.getCellEditor(row, column);
                }
                final JTextField field = new JTextField();
                return new DefaultCellEditor(field){

                    @Override
                    public boolean stopCellEditing() {
                        UpdateSite site;
                        String value = field.getText();
                        if (!(column != 2 && column != 4 || value.equals("") || value.endsWith("/"))) {
                            value = value + "/";
                        }
                        if (column == 1) {
                            if (value.equals(SitesDialog.this.getUpdateSiteName(row))) {
                                return super.stopCellEditing();
                            }
                            if (files.getUpdateSite(value, true) != null) {
                                SitesDialog.this.error("Update site '" + value + "' exists already!");
                                return false;
                            }
                        } else if (column == 2) {
                            UpdateSite site2;
                            if ("/".equals(value)) {
                                value = "";
                            }
                            if (value.equals((site2 = SitesDialog.this.getUpdateSite(row)).getURL())) {
                                return super.stopCellEditing();
                            }
                            if (SitesDialog.this.validURL(value)) {
                                site2.setURL(value);
                                boolean wasActive = site2.isActive();
                                SitesDialog.this.activateUpdateSite(site2);
                                if (!wasActive && site2.isActive()) {
                                    SitesDialog.this.tableModel.rowChanged(row);
                                }
                            } else {
                                if (site2.getHost() == null || site2.getHost().equals("")) {
                                    SitesDialog.this.error("URL does not refer to an update site: " + value + "\nIf you want to initialize that site, you need to provide upload information first.");
                                    return false;
                                }
                                if (!SitesDialog.this.showYesNoQuestion("Initialize upload site?", "It appears that the URL\n\t" + value + "\nis not (yet) valid. Do you want to initialize it (host: " + site2.getHost() + "; directory: " + site2.getUploadDirectory() + ")?")) {
                                    return false;
                                }
                                if (!SitesDialog.this.initializeUpdateSite(site2.getName(), value, site2.getHost(), site2.getUploadDirectory())) {
                                    return false;
                                }
                            }
                        } else if (column == 3) {
                            UpdateSite site3 = SitesDialog.this.getUpdateSite(row);
                            if (value.equals(site3.getHost())) {
                                return super.stopCellEditing();
                            }
                            int colon = value.indexOf(58);
                            if (colon > 0) {
                                String protocol = value.substring(0, colon);
                                UploaderService uploaderService = SitesDialog.this.updaterFrame.getUploaderService();
                                if (null == uploaderService.installUploader(protocol, files, SitesDialog.this.updaterFrame.getProgress(null))) {
                                    SitesDialog.this.error("Unknown upload protocol: " + protocol);
                                    return false;
                                }
                            }
                        } else if (column == 4 && value.equals((site = SitesDialog.this.getUpdateSite(row)).getUploadDirectory())) {
                            return super.stopCellEditing();
                        }
                        SitesDialog.this.updaterFrame.enableApplyOrUpload();
                        return super.stopCellEditing();
                    }
                };
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                UpdateSite site = SitesDialog.this.getUpdateSite(row);
                if (column == 0) {
                    if (Boolean.TRUE.equals(value)) {
                        if (column == 0 || column == 2) {
                            SitesDialog.this.activateUpdateSite(site);
                        }
                    } else {
                        SitesDialog.this.deactivateUpdateSite(site);
                    }
                } else {
                    String string = (String)value;
                    switch (column) {
                        case 1: {
                            String name = site.getName();
                            if (name.equals(string)) {
                                return;
                            }
                            files.renameUpdateSite(name, string);
                            break;
                        }
                        case 2: {
                            if (site.getURL().equals(string)) {
                                return;
                            }
                            boolean active = site.isActive();
                            if (active) {
                                SitesDialog.this.deactivateUpdateSite(site);
                            }
                            site.setURL(string);
                            if (!active || !SitesDialog.this.validURL(string)) break;
                            SitesDialog.this.activateUpdateSite(site);
                            break;
                        }
                        case 3: {
                            if (string.equals(site.getHost())) {
                                return;
                            }
                            site.setHost(string);
                            break;
                        }
                        case 4: {
                            if (string.equals(site.getUploadDirectory())) {
                                return;
                            }
                            site.setUploadDirectory(string);
                            break;
                        }
                        default: {
                            SitesDialog.this.updaterFrame.log.error((Object)("Whoa! Column " + column + " is not handled!"));
                        }
                    }
                }
                files.setUpdateSitesChanged(true);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                UpdateSite site;
                Component component = super.prepareRenderer(renderer, row, column);
                if (component instanceof JComponent && (site = SitesDialog.this.getUpdateSite(row)) != null) {
                    JComponent jcomponent = (JComponent)component;
                    jcomponent.setToolTipText(SitesDialog.wrapToolTip(site.getDescription(), site.getMaintainer()));
                }
                return component;
            }
        };
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.tableModel.setColumnWidths();
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setPreferredSize(new Dimension(this.tableModel.tableWidth, 400));
        contentPane.add(this.scrollpane);
        JPanel buttons = new JPanel();
        this.addPersonalSite = SwingTools.button("Add my site", "Add my personal update site", this, buttons);
        this.addNewSite = SwingTools.button("Add update site", "Add update site", this, buttons);
        this.remove = SwingTools.button("Remove", "Remove", this, buttons);
        this.remove.setEnabled(false);
        this.close = SwingTools.button("Close", "Close", this, buttons);
        contentPane.add(buttons);
        this.getRootPane().setDefaultButton(this.close);
        SitesDialog.escapeCancels(this);
        this.pack();
        this.addNewSite.requestFocusInWindow();
        this.setLocationRelativeTo(owner);
    }

    private static String wrapToolTip(String description, String maintainer) {
        if (description == null) {
            return null;
        }
        return "<html><p width='400'>" + description.replaceAll("\n", "<br />") + (maintainer != null ? "</p><p>Maintainer: " + maintainer + "</p>" : "") + "</p></html>";
    }

    protected String getUpdateSiteName(int row) {
        return this.sites.get(row).getName();
    }

    protected UpdateSite getUpdateSite(int row) {
        return this.sites.get(row);
    }

    private void addNew() {
        this.add(new UpdateSite(this.makeUniqueSiteName("New"), "", "", "", null, null, 0L));
        this.table.changeSelection(this.table.getRowCount() - 1, 2, false, false);
        if (this.table.editCellAt(this.table.getRowCount() - 1, 2)) {
            Component editor = this.table.getEditorComponent();
            editor.requestFocusInWindow();
        }
    }

    private void addPersonalSite() {
        PersonalSiteDialog dialog = new PersonalSiteDialog();
        String user = dialog.name;
        if (user == null) {
            return;
        }
        String url = PERSONAL_SITES_URL + user;
        UpdateSite site = new UpdateSite(this.makeUniqueSiteName("My Site"), url, "webdav:" + user, "", null, null, 0L);
        this.add(site);
        this.activateUpdateSite(site);
    }

    private void add(UpdateSite site) {
        int row = this.sites.size();
        this.files.addUpdateSite(site);
        this.sites.add(site);
        this.tableModel.rowsChanged();
        this.tableModel.rowChanged(row);
        this.table.setRowSelectionInterval(row, row);
        StaticSwingUtils.scrollToBottom((JScrollPane)this.scrollpane);
    }

    private String makeUniqueSiteName(String prefix) {
        HashSet<String> names = new HashSet<String>();
        for (UpdateSite site : this.sites) {
            names.add(site.getName());
        }
        if (!names.contains(prefix)) {
            return prefix;
        }
        int i = 2;
        while (names.contains(prefix + "-" + i)) {
            ++i;
        }
        return prefix + "-" + i;
    }

    protected void delete(int row) {
        UpdateSite site = this.getUpdateSite(row);
        String name = site.getName();
        if (!this.showYesNoQuestion("Remove " + name + "?", "Do you really want to remove the site '" + name + "' from the list?\nURL: " + this.getUpdateSite(row).getURL())) {
            return;
        }
        this.files.removeUpdateSite(site.getName());
        this.sites.remove(row);
        this.tableModel.rowChanged(row);
    }

    private void deactivateUpdateSite(UpdateSite site) {
        int count = this.files.deactivateUpdateSite(site);
        if (count > 0) {
            this.info("" + count + (count == 1 ? " file is" : " files are") + " installed from the site '" + site.getName() + "' and will be updated/uninstalled\n");
            this.updaterFrame.updateFilesTable();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addNewSite) {
            this.addNew();
        } else if (source == this.addPersonalSite) {
            this.addPersonalSite();
        } else if (source == this.remove) {
            this.delete(this.table.getSelectedRow());
        } else if (source == this.close) {
            this.dispose();
        }
    }

    protected boolean validURL(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            return this.files.util.getLastModified(new URL(url + "db.xml.gz")) != -1L;
        }
        catch (MalformedURLException e) {
            this.updaterFrame.log.error((Throwable)e);
            return false;
        }
    }

    protected boolean activateUpdateSite(UpdateSite updateSite) {
        try {
            this.files.activateUpdateSite(updateSite, this.updaterFrame.getProgress(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("Not a valid URL: " + updateSite.getURL());
            return false;
        }
        this.updaterFrame.filesChanged();
        return true;
    }

    protected boolean initializeUpdateSite(String siteName, String url, String host, String uploadDirectory) {
        boolean result;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!uploadDirectory.endsWith("/")) {
            uploadDirectory = uploadDirectory + "/";
        }
        try {
            result = this.updaterFrame.initializeUpdateSite(url, host, uploadDirectory) && this.validURL(url);
        }
        catch (InstantiationException e) {
            this.updaterFrame.log.error((Throwable)e);
            result = false;
        }
        if (result) {
            this.info("Initialized update site '" + siteName + "'");
        } else {
            this.error("Could not initialize update site '" + siteName + "'");
        }
        return result;
    }

    @Override
    public void dispose() {
        this.table.editCellAt(0, 0);
        super.dispose();
        this.updaterFrame.updateFilesTable();
        this.updaterFrame.enableApplyOrUpload();
        this.updaterFrame.addCustomViewOptions();
    }

    public void info(String message) {
        SwingTools.showMessageBox(this, message, 1);
    }

    public void error(String message) {
        SwingTools.showMessageBox(this, message, 0);
    }

    public boolean showYesNoQuestion(String title, String message) {
        return SwingTools.showYesNoQuestion(this, title, message);
    }

    public static void escapeCancels(final JDialog dialog) {
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }

    private class PersonalSiteDialog
    extends JDialog
    implements ActionListener {
        private String name;
        private JLabel userLabel;
        private JLabel realNameLabel;
        private JLabel emailLabel;
        private JLabel passwordLabel;
        private JTextField userField;
        private JTextField realNameField;
        private JTextField emailField;
        private JPasswordField passwordField;
        private JButton cancel;
        private JButton okay;

        public PersonalSiteDialog() {
            super((Dialog)SitesDialog.this, "Add Personal Site");
            this.setLayout((LayoutManager)new MigLayout("wrap 2"));
            this.add((Component)new JLabel("<html><style type='text/css'>p { text-indent: 10px; }</style><h2>Personal update site setup</h2><p width=400>For security reasons, personal update sites are associated with a ImageJ Wiki account. Please provide the account name of your ImageJ Wiki account.</p><p width=400>If your personal update site was not yet initialized, you can initialize it in this dialog.</p><p width=400>You can register a ImageJ Wiki account here if  you do not have one yet.</p></html>"), "span 2");
            this.userLabel = new JLabel("ImageJ Wiki account");
            this.add(this.userLabel);
            this.userField = new JTextField();
            this.userField.setColumns(30);
            this.add(this.userField);
            this.realNameLabel = new JLabel("Real Name");
            this.add(this.realNameLabel);
            this.realNameField = new JTextField();
            this.realNameField.setColumns(30);
            this.add(this.realNameField);
            this.emailLabel = new JLabel("Email");
            this.add(this.emailLabel);
            this.emailField = new JTextField();
            this.emailField.setColumns(30);
            this.add(this.emailField);
            this.passwordLabel = new JLabel("Password");
            this.add(this.passwordLabel);
            this.passwordField = new JPasswordField();
            this.passwordField.setColumns(30);
            this.add(this.passwordField);
            JPanel panel = new JPanel();
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(this);
            panel.add(this.cancel);
            this.okay = new JButton("OK");
            this.okay.addActionListener(this);
            panel.add(this.okay);
            this.add((Component)panel, "span 2, right");
            this.setWikiAccountFieldsEnabled(false);
            this.setChangePasswordEnabled(false);
            this.pack();
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        PersonalSiteDialog.this.dispose();
                    } else if (e.getKeyCode() == 10) {
                        PersonalSiteDialog.this.actionPerformed(new ActionEvent(PersonalSiteDialog.this.okay, -1, null));
                    }
                }
            };
            this.userField.addKeyListener(keyListener);
            this.realNameField.addKeyListener(keyListener);
            this.emailField.addKeyListener(keyListener);
            this.passwordField.addKeyListener(keyListener);
            this.cancel.addKeyListener(keyListener);
            this.okay.addKeyListener(keyListener);
            this.setModal(true);
            this.setVisible(true);
        }

        private void setWikiAccountFieldsEnabled(boolean enabled) {
            this.realNameLabel.setEnabled(enabled);
            this.realNameField.setEnabled(enabled);
            this.emailLabel.setEnabled(enabled);
            this.emailField.setEnabled(enabled);
            if (enabled) {
                this.realNameField.requestFocusInWindow();
            }
        }

        private void setChangePasswordEnabled(boolean enabled) {
            this.passwordLabel.setEnabled(enabled);
            this.passwordField.setEnabled(enabled);
            if (enabled) {
                this.passwordField.requestFocusInWindow();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.okay) {
                String newName = this.userField.getText();
                if (!MediaWikiClient.isCapitalized((String)newName)) {
                    newName = MediaWikiClient.capitalize((String)newName);
                    this.userField.setText(newName);
                }
                if ("".equals(newName)) {
                    SitesDialog.this.error("Please provide a ImageJ Wiki account name!");
                    return;
                }
                if (SitesDialog.this.validURL(SitesDialog.PERSONAL_SITES_URL + newName)) {
                    this.name = newName;
                    this.dispose();
                    return;
                }
                MediaWikiClient wiki = new MediaWikiClient();
                try {
                    if (!wiki.userExists(newName)) {
                        if (this.realNameLabel.isEnabled()) {
                            String realName = this.realNameField.getText();
                            String email = this.emailField.getText();
                            if ("".equals(realName) || "".equals(email)) {
                                SitesDialog.this.error("<html><p width=400>Please provide your name and email address to register an account on the ImageJ Wiki!</p></html>");
                            } else if (wiki.createUser(newName, realName, email, "Wants a personal site")) {
                                this.setWikiAccountFieldsEnabled(false);
                                this.setChangePasswordEnabled(true);
                                SitesDialog.this.info("<html><p width=400>An email with the activation code was sent. Please provide your ImageJ Wiki password after activating the account.</p></html>");
                            } else {
                                SitesDialog.this.error("<html><p width=400>There was a problem creating the user account!</p></html>");
                            }
                        } else {
                            this.setWikiAccountFieldsEnabled(true);
                            SitesDialog.this.error("<html><p width=400>Please provide your name and email address to register an account on the ImageJ Wiki</p></html>");
                        }
                        return;
                    }
                    if (!this.passwordField.isEnabled()) {
                        this.setChangePasswordEnabled(true);
                        SitesDialog.this.error("<html><p width=400>Please type in your the password for your account on the Fiji/ImageJ Wiki</p></html>");
                        return;
                    }
                    String password = new String(this.passwordField.getPassword());
                    if (!wiki.login(newName, password)) {
                        SitesDialog.this.error("Could not log in (incorrect password?)");
                        return;
                    }
                    if (!wiki.changeUploadPassword(password)) {
                        SitesDialog.this.error("Could not initialize the personal update site");
                        return;
                    }
                    wiki.logout();
                    this.name = newName;
                    this.dispose();
                }
                catch (IOException e2) {
                    SitesDialog.this.updaterFrame.log.error((Throwable)e2);
                    SitesDialog.this.error("<html><p width=400>There was a problem contacting the ImageJ Wiki: " + e2 + "</p></html>");
                    return;
                }
            }
        }
    }

    protected class DataModel
    extends DefaultTableModel {
        protected int tableWidth;
        protected int[] widths = new int[]{20, 150, 280, 125, 125};
        protected String[] headers = new String[]{"Active", "Name", "URL", "Host", "Directory on Host"};

        protected DataModel() {
        }

        public void setColumnWidths() {
            TableColumnModel columnModel = SitesDialog.this.table.getColumnModel();
            for (int i = 0; i < SitesDialog.this.tableModel.widths.length && i < this.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(SitesDialog.this.tableModel.widths[i]);
                column.setMinWidth(SitesDialog.this.tableModel.widths[i]);
                this.tableWidth += SitesDialog.this.tableModel.widths[i];
            }
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getRowCount() {
            return SitesDialog.this.sites.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 1) {
                return SitesDialog.this.getUpdateSiteName(row);
            }
            UpdateSite site = SitesDialog.this.getUpdateSite(row);
            if (col == 0) {
                return site.isActive();
            }
            if (col == 2) {
                return site.getURL();
            }
            if (col == 3) {
                return site.getHost();
            }
            if (col == 4) {
                return site.getUploadDirectory();
            }
            return null;
        }

        public void rowChanged(int row) {
            this.rowsChanged(row, row + 1);
        }

        public void rowsChanged() {
            this.rowsChanged(0, SitesDialog.this.sites.size());
        }

        public void rowsChanged(int firstRow, int lastRow) {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

