/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.plugins.tools.FloodFillTool;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Flood Fill Tool")
public class FloodFillToolConfig
implements Command {
    private static final String FOUR = "4-connected";
    private static final String EIGHT = "8-connected";
    @Parameter(type=ItemIO.BOTH)
    private FloodFillTool tool;
    @Parameter(label="Flood Type:", choices={"8-connected", "4-connected"}, initializer="init", persist=false)
    private String connectivity;

    public void run() {
        if (this.connectivity.equals(FOUR)) {
            this.tool.setConnectivity(FloodFillTool.Connectivity.FOUR);
        } else {
            this.tool.setConnectivity(FloodFillTool.Connectivity.EIGHT);
        }
    }

    protected void init() {
        FloodFillTool.Connectivity neighCount = this.tool.getConnectivity();
        this.connectivity = neighCount.equals((Object)FloodFillTool.Connectivity.FOUR) ? FOUR : EIGHT;
    }
}

