/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.stats.internals.distributions.Normal;

public class SignRank {
    public static double DBL_EPSILON = Math.pow(2.0, -52.0);
    private static double[] w;
    private static int allocated_n;

    public static double R_D__0(boolean lower_tail, boolean log_p) {
        return log_p ? Double.NEGATIVE_INFINITY : 0.0;
    }

    public static double R_D__1(boolean lower_tail, boolean log_p) {
        return log_p ? 0.0 : 1.0;
    }

    public static double R_DT_0(boolean lower_tail, boolean log_p) {
        return lower_tail ? SignRank.R_D__0(lower_tail, log_p) : SignRank.R_D__1(lower_tail, log_p);
    }

    public static double R_DT_1(boolean lower_tail, boolean log_p) {
        return lower_tail ? SignRank.R_D__1(lower_tail, log_p) : SignRank.R_D__0(lower_tail, log_p);
    }

    public static double R_DT_val(double x, boolean lower_tail, boolean log_p) {
        return lower_tail ? SignRank.R_D_val(x, lower_tail, log_p) : SignRank.R_D_Clog(x, lower_tail, log_p);
    }

    public static double R_D_val(double x, boolean lower_tail, boolean log_p) {
        return log_p ? Math.log(x) : x;
    }

    public static double R_D_Clog(double p, boolean lower_tail, boolean log_p) {
        return log_p ? Math.log1p(-p) : 0.5 - p + 0.5;
    }

    public static double R_D_exp(double x, boolean lower_tail, boolean log_p) {
        return log_p ? x : Math.exp(x);
    }

    public static double R_DT_Clog(double p, boolean lower_tail, boolean log_p) {
        return lower_tail ? SignRank.R_D_LExp(p, lower_tail, log_p) : SignRank.R_D_log(p, lower_tail, log_p);
    }

    public static double R_D_log(double p, boolean lower_tail, boolean log_p) {
        return log_p ? p : Math.log(p);
    }

    public static double R_D_LExp(double x, boolean lower_tail, boolean log_p) {
        return log_p ? SignRank.R_Log1_Exp(x, lower_tail, log_p) : Math.log1p(-x);
    }

    public static double R_Log1_Exp(double x, boolean lower_tail, boolean log_p) {
        return x > -Math.log(2.0) ? Math.log(-Math.expm1(x)) : Math.log1p(-Math.exp(x));
    }

    public static boolean R_D_nonint(double x, boolean lower_tail, boolean log_p) {
        return Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7;
    }

    public static double R_D_forceint(double x) {
        return Math.floor(x + 0.5);
    }

    public static double R_D_fexp(double f, double x, boolean lower_tail, boolean log_p) {
        return log_p ? -0.5 * Math.log(f) + x : Math.exp(x) / Math.sqrt(f);
    }

    public static double rsignrank(Session context, double n) {
        if (Double.isNaN(n)) {
            return n;
        }
        if ((n = Math.floor(n + 0.5)) < 0.0) {
            return Double.NaN;
        }
        if (n == 0.0) {
            return 0.0;
        }
        double r = 0.0;
        int k = (int)n;
        int i = 0;
        while (i < k) {
            r += (double)(++i) * Math.floor(context.rng.unif_rand() + 0.5);
        }
        return r;
    }

    private static void w_init_maybe(int n) {
        int u = n * (n + 1) / 2;
        int c2 = u / 2;
        w = new double[c2 + 1];
        allocated_n = w.length;
    }

    public static double csignrank(int k, int n) {
        int u = n * (n + 1) / 2;
        int c2 = u / 2;
        if (k < 0 || k > u) {
            return 0.0;
        }
        if (k > c2) {
            k = u - k;
        }
        if (n == 1) {
            return 1.0;
        }
        if (w[0] == 1.0) {
            return w[k];
        }
        SignRank.w[1] = 1.0;
        SignRank.w[0] = 1.0;
        for (int j = 2; j < n + 1; ++j) {
            int end;
            for (int i = end = Math.min(j * (j + 1) / 2, c2); i >= j; --i) {
                int n2 = i;
                w[n2] = w[n2] + w[i - j];
            }
        }
        return w[k];
    }

    public static double qsignrank(double x, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return x + n;
        }
        if (Double.isInfinite(x) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        if (log_p && x > 0.0 || !log_p && (x < 0.0 || x > 1.0)) {
            return Double.NaN;
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0) {
            return Double.NaN;
        }
        if (x == SignRank.R_DT_0(lower_tail, log_p)) {
            return 0.0;
        }
        if (x == SignRank.R_DT_1(lower_tail, log_p)) {
            return n * (n + 1.0) / 2.0;
        }
        if (log_p || !lower_tail) {
            x = Normal.R_DT_qIv(x, log_p ? 1.0 : 0.0, lower_tail ? 1.0 : 0.0);
        }
        SignRank.w_init_maybe((int)n);
        double f = Math.exp(-n * Math.log(2.0));
        double p = 0.0;
        double q = 0.0;
        if (x <= 0.5) {
            x -= 10.0 * DBL_EPSILON;
            while (!((p += SignRank.csignrank((int)q, (int)n) * f) >= x)) {
                q += 1.0;
            }
        } else {
            x = 1.0 - x + 10.0 * DBL_EPSILON;
            while (true) {
                if ((p += SignRank.csignrank((int)q, (int)n) * f) > x) {
                    q = n * (n + 1.0) / 2.0 - q;
                    break;
                }
                q += 1.0;
            }
        }
        return q;
    }

    public static double psignrank(double x, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return x + n;
        }
        if (Double.isInfinite(n)) {
            return Double.NaN;
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0) {
            return Double.NaN;
        }
        if ((x = Math.floor(x + 1.0E-7)) < 0.0) {
            return SignRank.R_DT_0(lower_tail, log_p);
        }
        if (x >= n * (n + 1.0) / 2.0) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        SignRank.w_init_maybe((int)n);
        double f = Math.exp(-n * Math.log(2.0));
        double p = 0.0;
        if (x <= n * (n + 1.0) / 4.0) {
            int i = 0;
            while ((double)i <= x) {
                p += SignRank.csignrank(i, (int)n) * f;
                ++i;
            }
        } else {
            x = n * (n + 1.0) / 2.0 - x;
            int i = 0;
            while ((double)i < x) {
                p += SignRank.csignrank(i, (int)n) * f;
                ++i;
            }
            lower_tail = !lower_tail;
        }
        return SignRank.R_DT_val(p, lower_tail, log_p);
    }

    public static double dsignrank(double x, double n, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(n)) {
            return x + n;
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return SignRank.R_D__0(true, give_log);
        }
        if ((x = Math.floor(x + 0.5)) < 0.0 || x > n * (n + 1.0) / 2.0) {
            return SignRank.R_D__0(true, give_log);
        }
        SignRank.w_init_maybe((int)n);
        double d = SignRank.R_D_exp(Math.log(SignRank.csignrank((int)x, (int)n)) - n * Math.log(2.0), true, give_log);
        return d;
    }
}

