/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;
import org.renjin.util.RInternalDSL;

public class ComplexArrayVector
extends ComplexVector {
    private final Complex[] values;

    public ComplexArrayVector(Complex ... values) {
        this.values = Arrays.copyOf(values, values.length);
    }

    public ComplexArrayVector(double[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = new Complex[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = RInternalDSL.complex(values[i]);
        }
    }

    public ComplexArrayVector(Complex[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = Arrays.copyOf(values, values.length);
    }

    public ComplexArrayVector(Complex[] values, int length2, AttributeMap attributes2) {
        super(attributes2);
        this.values = Arrays.copyOf(values, length2);
    }

    public ComplexArrayVector(Complex[] values, int length2) {
        this.values = Arrays.copyOf(values, length2);
    }

    public static ComplexVector newMatrix(Complex[] values, int nRows, int nCols) {
        return new ComplexArrayVector(values, AttributeMap.builder().setDim(nRows, nCols).build());
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public Complex getElementAsComplex(int index) {
        return this.values[index];
    }

    public boolean equals(Object x) {
        if (x instanceof ComplexArrayVector) {
            ComplexArrayVector that = (ComplexArrayVector)x;
            if (this.length() != that.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.values[i].equals((Object)that.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new ComplexArrayVector(this.values, attributes2);
    }

    @Override
    public boolean isElementNA(int index) {
        return ComplexArrayVector.isNA(this.values[index]);
    }

    @Override
    public Iterator<Complex> iterator() {
        return Iterators.forArray((Object[])this.values);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public String toString() {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Complex z : this.values) {
            list2.add(z.getReal() + "+" + z.getImaginary() + "i");
        }
        return list2.toString();
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private static final int MIN_INITIAL_CAPACITY = 50;
        private Complex[] values;
        private int size;

        public Builder(int initialSize, int initialCapacity) {
            if (initialCapacity < 50) {
                initialCapacity = 50;
            }
            if (initialSize > initialCapacity) {
                initialCapacity = initialSize;
            }
            this.values = new Complex[initialCapacity];
            this.size = initialSize;
            Arrays.fill(this.values, ComplexVector.NA);
        }

        public Builder() {
            this(0, 50);
        }

        public Builder(int initialSize) {
            this(initialSize, initialSize);
        }

        public Builder(ComplexVector toCopy) {
            this.values = new Complex[toCopy.length()];
            for (int i = 0; i != this.values.length; ++i) {
                this.values[i] = toCopy.getElementAsComplex(i);
            }
            this.size = this.values.length;
            this.copyAttributesFrom(toCopy);
        }

        public static Builder withInitialSize(int size) {
            return new Builder(size, size);
        }

        public static Builder withInitialCapacity(int capacity) {
            return new Builder(0, capacity);
        }

        private Builder(ComplexArrayVector exp2) {
            this.values = Arrays.copyOf(exp2.values, exp2.values.length);
            this.size = this.values.length;
            this.copyAttributesFrom(exp2);
        }

        public Builder set(int index, Complex value) {
            this.ensureCapacity(index + 1);
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
            this.values[index] = value;
            return this;
        }

        public Builder add(Complex value) {
            return this.set(this.size, value);
        }

        @Override
        public Builder add(Number value) {
            return this.add(new Complex(value.doubleValue(), 0.0));
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, ComplexVector.NA);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsComplex(sourceIndex));
        }

        @Override
        public int length() {
            return this.size;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.values.length;
            if (minCapacity > oldCapacity) {
                Complex[] oldData = this.values;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.values = Arrays.copyOf(oldData, newCapacity);
                Arrays.fill(this.values, oldCapacity, this.values.length, ComplexVector.NA);
            }
        }

        @Override
        public ComplexVector build() {
            return new ComplexArrayVector(this.values, this.size, this.buildAttributes());
        }
    }
}

