/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.InvokeAsCharacter;
import org.renjin.primitives.Types;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Attributes {
    private Attributes() {
    }

    public static SEXP validateAttribute(SEXP expression2, Symbol name, SEXP attributeValue) {
        if (attributeValue == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (name.equals(Symbols.CLASS)) {
            return Attributes.validateClassAttributes(attributeValue);
        }
        if (name.equals(Symbols.NAMES)) {
            return Attributes.validateNamesAttributes(expression2, attributeValue);
        }
        if (name.equals(Symbols.ROW_NAMES)) {
            return Attributes.validateRowNames(attributeValue);
        }
        if (name.equals(Symbols.DIM)) {
            return Attributes.validateDim(expression2, attributeValue);
        }
        return attributeValue;
    }

    public static IntVector validateDim(SEXP sexp, SEXP attributeValue) {
        if (!(attributeValue instanceof Vector)) {
            throw new EvalException("Invalid dim: " + attributeValue, new Object[0]);
        }
        Vector vector2 = (Vector)attributeValue;
        int[] dim2 = new int[vector2.length()];
        int prod2 = 1;
        for (int i = 0; i != vector2.length(); ++i) {
            dim2[i] = vector2.getElementAsInt(i);
            if (dim2[i] < 0) {
                throw new EvalException("the dims contain negative values", new Object[0]);
            }
            prod2 *= dim2[i];
        }
        if (prod2 != sexp.length()) {
            throw new EvalException("dims [product %d] do not match the length of object [%d]", prod2, sexp.length());
        }
        return new IntArrayVector(dim2);
    }

    public static StringVector validateNamesAttributes(SEXP expression2, SEXP names2) {
        if (names2.length() > expression2.length()) {
            throw new EvalException("'names' attribute [%d] must be the same length as the vector [%d]", names2.length(), expression2.length());
        }
        if (!(names2 instanceof StringVector) || names2.length() < expression2.length()) {
            return StringArrayVector.coerceFrom(names2).setLength(expression2.length());
        }
        if (names2.hasAttributes()) {
            return (StringVector)names2.setAttributes(AttributeMap.EMPTY);
        }
        return (StringVector)names2;
    }

    public static SEXP validateClassAttributes(SEXP classNames) {
        return classNames.length() == 0 ? Null.INSTANCE : StringArrayVector.coerceFrom(classNames);
    }

    public static Vector validateRowNames(SEXP rowNames) {
        if (rowNames == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (RowNamesVector.isOldCompactForm(rowNames)) {
            return RowNamesVector.fromOldCompactForm(rowNames);
        }
        if (rowNames instanceof Vector) {
            return (Vector)rowNames;
        }
        throw new EvalException("row names must be 'character' or 'integer', not '%s'", rowNames.getTypeName());
    }

    public static PairList expandAttributes(PairList attributes2) {
        PairList.Builder result = new PairList.Builder();
        for (PairList.Node node : attributes2.nodes()) {
            result.add(node.getTag(), Attributes.postProcessAttributeValue(node.getTag(), node.getValue()));
        }
        return result.build();
    }

    public static SEXP postProcessAttributeValue(Symbol name, SEXP value) {
        return value;
    }

    @Generic
    @Builtin(value="dim")
    public static SEXP getDimensions(SEXP sexp) {
        return sexp.getAttribute(Symbols.DIM);
    }

    @Generic
    @Builtin(value="dim<-")
    public static SEXP setDimensions(SEXP exp2, AtomicVector vector2) {
        AttributeMap.Builder newAttributes = exp2.getAttributes().copy();
        newAttributes.remove(Symbols.NAMES);
        if (vector2 == Null.INSTANCE) {
            newAttributes.removeDim();
        } else {
            newAttributes.setDim(Attributes.validateDim(exp2, vector2));
        }
        return exp2.setAttributes(newAttributes.build());
    }

    @Generic
    @Builtin(value="dimnames")
    public static SEXP getDimensionNames(SEXP exp2) {
        return exp2.getAttribute(Symbols.DIMNAMES);
    }

    @Generic
    @Builtin(value="dimnames<-")
    public static SEXP setDimensionNames(@Current Context context, SEXP exp2, ListVector dimnames2) {
        Vector dim2 = (Vector)exp2.getAttribute(Symbols.DIM);
        if (dim2.length() != dimnames2.length()) {
            throw new EvalException("length of 'dimnames' [%d] not equal to array extent [%d]", dimnames2.length(), dim2.length());
        }
        ListVector.Builder dn = new ListVector.Builder();
        for (SEXP names2 : dimnames2) {
            if (names2 != Null.INSTANCE && !(names2 instanceof StringVector)) {
                names2 = context.evaluate(FunctionCall.newCall(Symbol.get("as.character"), names2));
            }
            dn.add(names2);
        }
        return exp2.setAttribute(Symbols.DIMNAMES, (SEXP)dn.build());
    }

    @Generic
    @Builtin(value="dimnames<-")
    public static SEXP setDimensionNames(@Current Context context, SEXP exp2, Null nz) {
        return exp2.setAttribute(Symbols.DIMNAMES, (SEXP)Null.INSTANCE);
    }

    @Builtin
    public static Vector attributes(SEXP sexp) {
        AttributeMap attributes2 = sexp.getAttributes();
        if (attributes2 == AttributeMap.EMPTY) {
            return Null.INSTANCE;
        }
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        for (Symbol name : attributes2.names()) {
            list2.add(name, Attributes.postProcessAttributeValue(name, attributes2.get(name)));
        }
        return list2.build();
    }

    @Builtin(value="attr")
    public static SEXP getAttribute(SEXP exp2, String which2, boolean exact) {
        SEXP partialMatch = null;
        int partialMatchCount = 0;
        AttributeMap attributes2 = exp2.getAttributes();
        for (Symbol name : attributes2.names()) {
            if (name.getPrintName().equals(which2)) {
                return Attributes.postProcessAttributeValue(name, attributes2.get(name));
            }
            if (exact || !name.getPrintName().startsWith(which2)) continue;
            partialMatch = Attributes.postProcessAttributeValue(name, attributes2.get(name));
            ++partialMatchCount;
        }
        return partialMatchCount == 1 ? partialMatch : Null.INSTANCE;
    }

    @Builtin(value="attr")
    public static SEXP getAttribute(SEXP exp2, String which2) {
        return Attributes.getAttribute(exp2, which2, false);
    }

    @Builtin(value="attributes<-")
    public static SEXP setAttributes(SEXP exp2, ListVector attributes2) {
        return Attributes.setAttributes(exp2, attributes2.namedValues());
    }

    @Builtin(value="attributes<-")
    public static SEXP setAttributes(SEXP exp2, PairList list2) {
        return Attributes.setAttributes(exp2, list2.nodes());
    }

    public static SEXP setAttributes(SEXP exp2, Iterable<? extends NamedValue> attributes2) {
        AttributeMap.Builder builder = AttributeMap.builder();
        for (NamedValue namedValue : attributes2) {
            Symbol name = Symbol.get(namedValue.getName());
            builder.set(name, Attributes.validateAttribute(exp2, name, namedValue.getValue()));
        }
        return exp2.setAttributes(builder.build());
    }

    @Generic
    @Builtin(value="names")
    public static SEXP getNames(SEXP exp2) {
        if (exp2.getAttributes().getDim().length() == 1) {
            return exp2.getAttributes().getDimNames(0);
        }
        return exp2.getNames();
    }

    @Generic
    @Builtin(value="names<-")
    public static SEXP setNames(@Current Context context, SEXP exp2, @InvokeAsCharacter Vector names2) {
        if (Types.isS4(exp2)) {
            String className = ((StringVector)exp2.getAttribute(Symbols.CLASS)).getElementAsString(0);
            if (exp2 instanceof S4Object) {
                if (exp2.getAttribute(Symbols.NAMES) == Null.INSTANCE) {
                    throw new EvalException("class '%s' has no 'names' slot", className);
                }
                throw new EvalException("invalid to use names()<- to set the 'names' slot in a non-vector class ('%s')", className);
            }
            if (exp2.getAttribute(Symbols.NAMES) == Null.INSTANCE) {
                context.warn(String.format("class '%s' has no 'names' slot; assigning a names attribute will create an invalid object", className));
            }
        }
        if (exp2.getAttributes().getDim().length() == 1) {
            return exp2.setAttributes(exp2.getAttributes().copy().setArrayNames(names2).build());
        }
        return exp2.setAttribute("names", (SEXP)names2);
    }

    @Generic
    @Builtin(value="levels<-")
    public static SEXP setLabels(SEXP exp2, SEXP levels2) {
        return exp2.setAttribute(Symbols.LEVELS, levels2);
    }

    @Builtin(value="class")
    public static StringVector getClass(SEXP exp2) {
        SEXP classAttribute = exp2.getAttribute(Symbols.CLASS);
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        SEXP dim2 = exp2.getAttribute(Symbols.DIM);
        if (dim2.length() == 2) {
            return StringVector.valueOf("matrix");
        }
        if (dim2.length() > 0) {
            return StringVector.valueOf("array");
        }
        return StringVector.valueOf(exp2.getImplicitClass());
    }

    @Internal(value="comment")
    public static SEXP getComment(SEXP exp2) {
        return exp2.getAttribute(Symbols.COMMENT);
    }

    @Internal(value="comment<-")
    public static SEXP setComment(StringVector exp2) {
        return exp2.setAttribute(Symbols.COMMENT, (SEXP)exp2);
    }

    @Builtin(value="class<-")
    public static SEXP setClass(SEXP exp2, Vector classes) {
        return exp2.setAttribute("class", (SEXP)classes);
    }

    @Builtin(value="oldClass<-")
    public static SEXP setOldClass(SEXP exp2, Vector classes) {
        return exp2.setAttribute(Symbols.CLASS, (SEXP)classes);
    }

    @Builtin
    public static SEXP unclass(SEXP exp2) {
        return exp2.setAttributes(exp2.getAttributes().copy().remove(Symbols.CLASS).build());
    }

    @Builtin(value="attr<-")
    public static SEXP setAttribute(SEXP exp2, String which2, SEXP value) {
        return exp2.setAttribute(which2, value);
    }

    @Builtin
    public static SEXP oldClass(SEXP exp2) {
        if (!exp2.hasAttributes()) {
            return Null.INSTANCE;
        }
        return exp2.getAttribute(Symbols.CLASS);
    }

    @Internal
    public static boolean inherits(SEXP exp2, StringVector what) {
        StringVector classes = Attributes.getClass(exp2);
        for (String whatClass : what) {
            if (!Iterables.contains((Iterable)classes, (Object)whatClass)) continue;
            return true;
        }
        return false;
    }

    @Internal
    public static boolean inherits(SEXP exp2, String what) {
        return Iterables.contains((Iterable)Attributes.getClass(exp2), (Object)what);
    }

    @Internal
    public static SEXP inherits(SEXP exp2, StringVector what, boolean which2) {
        if (!which2) {
            return new LogicalArrayVector(Attributes.inherits(exp2, what));
        }
        StringVector classes = Attributes.getClass(exp2);
        int[] result = new int[what.length()];
        for (int i = 0; i != what.length(); ++i) {
            result[i] = Iterables.indexOf((Iterable)classes, (Predicate)Predicates.equalTo((Object)what.getElementAsString(i))) + 1;
        }
        return new IntArrayVector(result);
    }
}

