/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.util.Util;

public class EllipseCursor<T>
implements Cursor<T> {
    private final RandomAccessible<T> rai;
    private final RandomAccess<T> ra;
    private final Localizable center;
    private final long radiusX;
    private final long radiusY;
    private final int dimX;
    private final int dimY;
    private long x;
    private long y;
    private double px;
    private double py;
    private double p;
    private Octant octant;
    private boolean hasNext;

    public EllipseCursor(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY) {
        this(rai, center, radiusX, radiusY, 0, 1);
    }

    public EllipseCursor(RandomAccessible<T> rai, Localizable center, long radiusX, long radiusY, int dimX, int dimY) {
        int d;
        this.rai = rai;
        this.center = center;
        if (radiusX > radiusY) {
            this.radiusX = radiusY;
            this.radiusY = radiusX;
            this.dimX = dimY;
            this.dimY = dimX;
        } else {
            this.radiusX = radiusX;
            this.radiusY = radiusY;
            this.dimX = dimX;
            this.dimY = dimY;
        }
        int numDimensions = rai.numDimensions();
        long[] minmax = new long[2 * numDimensions];
        for (d = 0; d < numDimensions; ++d) {
            minmax[d] = d == dimX ? center.getLongPosition(d) - radiusX : (d == dimY ? center.getLongPosition(d) - radiusY : center.getLongPosition(d));
        }
        for (d = 0; d < numDimensions; ++d) {
            minmax[d + numDimensions] = d == dimX ? center.getLongPosition(d) + radiusX : (d == dimY ? center.getLongPosition(d) + radiusY : center.getLongPosition(d));
        }
        FinalInterval interval = FinalInterval.createMinMax((long[])minmax);
        this.ra = rai.randomAccess((Interval)interval);
        this.reset();
    }

    public void reset() {
        this.x = 0L;
        this.y = this.radiusY;
        this.px = 0.0;
        this.py = 2.0 * (double)this.radiusX * (double)this.radiusX * (double)this.y;
        this.p = (double)(this.radiusY * this.radiusY - this.radiusX * this.radiusX * this.radiusY) + 0.25 * (double)this.radiusX * (double)this.radiusX;
        this.octant = Octant.INIT;
        this.ra.setPosition(this.center);
        this.hasNext = true;
    }

    public void fwd() {
        switch (this.octant) {
            default: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.radiusY, this.dimY);
                this.octant = Octant.NORTH;
                break;
            }
            case NORTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.radiusY, this.dimY);
                this.octant = Octant.SOUTH;
                break;
            }
            case SOUTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.radiusX, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY), this.dimY);
                this.octant = Octant.WEST;
                break;
            }
            case WEST: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.radiusX, this.dimX);
                this.octant = Octant.EAST;
                if (this.radiusX != 1L || this.radiusY != 1L) break;
                this.hasNext = false;
                break;
            }
            case EAST: {
                ++this.x;
                this.px += 2.0 * (double)this.radiusY * (double)this.radiusY;
                if (this.p < 0.0) {
                    this.p += (double)(this.radiusY * this.radiusY) + this.px;
                } else {
                    --this.y;
                    this.py -= (double)(2L * (this.radiusX * this.radiusX));
                    this.p += (double)(this.radiusY * this.radiusY) + this.px - this.py;
                }
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                this.octant = Octant.REGION1_Q1;
                break;
            }
            case REGION1_Q1: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.x, this.dimX);
                this.octant = Octant.REGION1_Q2;
                break;
            }
            case REGION1_Q2: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.y, this.dimY);
                this.octant = Octant.REGION1_Q3;
                break;
            }
            case REGION1_Q3: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.octant = Octant.REGION1_Q4;
                if (this.y != 1L || this.x > 2L) break;
                this.hasNext = false;
                break;
            }
            case REGION1_Q4: {
                if (this.px < this.py) {
                    ++this.x;
                    this.px += 2.0 * (double)this.radiusY * (double)this.radiusY;
                    if (this.p < 0.0) {
                        this.p += (double)(this.radiusY * this.radiusY) + this.px;
                    } else {
                        --this.y;
                        this.py -= (double)(2L * (this.radiusX * this.radiusX));
                        this.p += (double)(this.radiusY * this.radiusY) + this.px - this.py;
                    }
                    this.octant = Octant.REGION1_Q1;
                } else {
                    this.p = (double)(this.radiusY * this.radiusY) * ((double)this.x + 0.5) * ((double)this.x + 0.5) + (double)(this.radiusX * this.radiusX * (this.y - 1L) * (this.y - 1L)) - (double)(this.radiusX * this.radiusX * this.radiusY * this.radiusY);
                    --this.y;
                    this.py -= 2.0 * (double)this.radiusX * (double)this.radiusX;
                    if (this.p > 0.0) {
                        this.p += (double)(this.radiusX * this.radiusX) - this.py;
                    } else {
                        ++this.x;
                        this.px += 2.0 * (double)this.radiusY * (double)this.radiusY;
                        this.p += (double)(this.radiusX * this.radiusX) - this.py + this.px;
                    }
                    this.octant = Octant.REGION2_Q1;
                }
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                break;
            }
            case REGION2_Q1: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.x, this.dimX);
                this.octant = Octant.REGION2_Q2;
                break;
            }
            case REGION2_Q2: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.y, this.dimY);
                this.octant = Octant.REGION2_Q3;
                break;
            }
            case REGION2_Q3: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.octant = Octant.REGION2_Q4;
                if (this.y > 1L) break;
                this.hasNext = false;
                break;
            }
            case REGION2_Q4: {
                --this.y;
                this.py -= 2.0 * (double)this.radiusX * (double)this.radiusX;
                if (this.p > 0.0) {
                    this.p += (double)(this.radiusX * this.radiusX) - this.py;
                } else {
                    ++this.x;
                    this.px += 2.0 * (double)this.radiusY * (double)this.radiusY;
                    this.p += (double)(this.radiusX * this.radiusX) - this.py + this.px;
                }
                this.octant = Octant.REGION2_Q1;
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void localize(float[] position) {
        this.ra.localize(position);
    }

    public void localize(double[] position) {
        this.ra.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    public int numDimensions() {
        return this.ra.numDimensions();
    }

    public T get() {
        return (T)this.ra.get();
    }

    public Sampler<T> copy() {
        return this.ra.copy();
    }

    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    public T next() {
        this.fwd();
        return this.get();
    }

    public void localize(int[] position) {
        this.ra.localize(position);
    }

    public void localize(long[] position) {
        this.ra.localize(position);
    }

    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    public Cursor<T> copyCursor() {
        return new EllipseCursor<T>(this.rai, this.center, this.radiusX, this.radiusY, this.dimX, this.dimY);
    }

    public String toString() {
        return super.toString() + " pos=" + Util.printCoordinates((RealLocalizable)this) + ",\t" + (Object)((Object)this.octant) + ",\tx = " + this.x + ",\ty = " + this.y;
    }

    private static enum Octant {
        INIT,
        EAST,
        NORTH,
        WEST,
        SOUTH,
        REGION1_Q1,
        REGION1_Q2,
        REGION1_Q3,
        REGION1_Q4,
        REGION2_Q1,
        REGION2_Q2,
        REGION2_Q3,
        REGION2_Q4;

    }
}

