/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;

public class CircleCursor<T>
implements Cursor<T> {
    private final RandomAccessible<T> rai;
    private final RandomAccess<T> ra;
    private final Localizable center;
    private final long radius;
    private final int dimX;
    private final int dimY;
    private long x;
    private long y;
    private long dx;
    private long dy;
    private long f;
    private Octant octant;
    private boolean hasNext;

    public CircleCursor(RandomAccessible<T> rai, Localizable center, long radius) {
        this(rai, center, radius, 0, 1);
    }

    public CircleCursor(RandomAccessible<T> rai, Localizable center, long radius, int dimX, int dimY) {
        int d;
        this.rai = rai;
        this.center = center;
        this.radius = radius;
        this.dimX = dimX;
        this.dimY = dimY;
        int numDimensions = rai.numDimensions();
        long[] minmax = new long[2 * numDimensions];
        for (d = 0; d < numDimensions; ++d) {
            minmax[d] = d == dimX || d == dimY ? center.getLongPosition(d) - radius : center.getLongPosition(d);
        }
        for (d = 0; d < numDimensions; ++d) {
            minmax[d + numDimensions] = d == dimX || d == dimY ? center.getLongPosition(d) + radius : center.getLongPosition(d);
        }
        FinalInterval interval = FinalInterval.createMinMax((long[])minmax);
        this.ra = rai.randomAccess((Interval)interval);
        this.reset();
    }

    public void reset() {
        this.x = 0L;
        this.y = this.radius;
        this.f = 1L - this.radius;
        this.dx = 1L;
        this.dy = -2L * this.radius;
        this.octant = Octant.INIT;
        this.ra.setPosition(this.center);
        this.hasNext = true;
    }

    public void fwd() {
        switch (this.octant) {
            default: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.radius, this.dimY);
                this.octant = Octant.NORTH;
                break;
            }
            case NORTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.radius, this.dimY);
                this.octant = Octant.SOUTH;
                break;
            }
            case SOUTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.radius, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY), this.dimY);
                this.octant = Octant.WEST;
                break;
            }
            case WEST: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.radius, this.dimX);
                this.octant = Octant.EAST;
                break;
            }
            case EAST: {
                ++this.x;
                this.dx += 2L;
                this.f += this.dx;
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                this.octant = Octant.O1;
                break;
            }
            case O1: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.x, this.dimX);
                this.octant = Octant.O2;
                break;
            }
            case O2: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.y, this.dimY);
                this.octant = Octant.O3;
                break;
            }
            case O3: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.octant = Octant.O4;
                if (this.x < this.y) break;
                this.hasNext = false;
                break;
            }
            case O4: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.y, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.x, this.dimY);
                this.octant = Octant.O5;
                break;
            }
            case O5: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.y, this.dimX);
                this.octant = Octant.O6;
                break;
            }
            case O6: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.x, this.dimY);
                this.octant = Octant.O7;
                break;
            }
            case O7: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.y, this.dimX);
                this.octant = Octant.O8;
                if (this.x < this.y - 1L) break;
                this.hasNext = false;
                break;
            }
            case O8: {
                if (this.f > 0L) {
                    --this.y;
                    this.dy += 2L;
                    this.f += this.dy;
                }
                ++this.x;
                this.dx += 2L;
                this.f += this.dx;
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                this.octant = Octant.O1;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void localize(float[] position) {
        this.ra.localize(position);
    }

    public void localize(double[] position) {
        this.ra.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    public int numDimensions() {
        return this.ra.numDimensions();
    }

    public T get() {
        return (T)this.ra.get();
    }

    public Sampler<T> copy() {
        return this.ra.copy();
    }

    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    public T next() {
        this.fwd();
        return this.get();
    }

    public void localize(int[] position) {
        this.ra.localize(position);
    }

    public void localize(long[] position) {
        this.ra.localize(position);
    }

    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    public Cursor<T> copyCursor() {
        return new CircleCursor<T>(this.rai, this.center, this.radius, this.dimX, this.dimY);
    }

    private static enum Octant {
        INIT,
        EAST,
        NORTH,
        WEST,
        SOUTH,
        O1,
        O2,
        O3,
        O4,
        O5,
        O6,
        O7,
        O8;

    }
}

