/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.labeling;

import java.util.List;
import java.util.PriorityQueue;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.labeling.AllConnectedComponents;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingOutOfBoundsRandomAccessFactory;
import net.imglib2.labeling.LabelingType;
import net.imglib2.labeling.NativeImgLabeling;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.view.Views;

public class Watershed<T extends RealType<T>, L extends Comparable<L>>
implements OutputAlgorithm<Labeling<L>> {
    protected RandomAccessibleInterval<T> image;
    protected Labeling<L> seeds;
    long[][] structuringElement;
    protected Labeling<L> output;
    String errorMessage;

    public void setIntensityImage(RandomAccessibleInterval<T> image) {
        this.image = image;
    }

    public void setSeeds(Labeling<L> seeds) {
        this.seeds = seeds;
    }

    public void setStructuringElement(long[][] structuringElement) {
        this.structuringElement = structuringElement;
    }

    public void setOutputLabeling(Labeling<L> outputLabeling) {
        this.output = outputLabeling;
    }

    @Override
    public boolean process() {
        if (!this.checkInput()) {
            return false;
        }
        if (this.output == null) {
            long[] dimensions = new long[this.seeds.numDimensions()];
            this.seeds.dimensions(dimensions);
            NativeImgLabeling o = new NativeImgLabeling(new ArrayImgFactory().create(dimensions, (NativeType)new IntType()));
            this.output = o;
        }
        LabelingOutOfBoundsRandomAccessFactory factory = new LabelingOutOfBoundsRandomAccessFactory();
        OutOfBounds outputAccess = factory.create(this.output);
        RealType maxVal = (RealType)((RealType)Views.iterable(this.image).firstElement()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        OutOfBoundsConstantValueFactory oobImageFactory = new OutOfBoundsConstantValueFactory((Type)maxVal);
        OutOfBounds imageAccess = oobImageFactory.create(this.image);
        PriorityQueue pq = new PriorityQueue();
        Cursor c = this.seeds.localizingCursor();
        long[] dimensions = new long[this.image.numDimensions()];
        this.output.dimensions(dimensions);
        long[] position = new long[this.image.numDimensions()];
        long[] destPosition = new long[this.image.numDimensions()];
        long age = 0L;
        while (c.hasNext()) {
            LabelingType tSrc = (LabelingType)c.next();
            List<Object> l = tSrc.getLabeling();
            if (l.isEmpty()) continue;
            c.localize(position);
            imageAccess.setPosition(position);
            if (imageAccess.isOutOfBounds()) continue;
            outputAccess.setPosition(position);
            if (outputAccess.isOutOfBounds()) continue;
            LabelingType tDest = (LabelingType)outputAccess.get();
            l = tDest.intern(l);
            tDest.setLabeling(l);
            double intensity = ((RealType)imageAccess.get()).getRealDouble();
            pq.add(new PixelIntensity(position, dimensions, intensity, age++, l));
        }
        long[][] strelMoves = new long[this.structuringElement.length][];
        long[] currentOffset = new long[this.image.numDimensions()];
        for (int i = 0; i < this.structuringElement.length; ++i) {
            strelMoves[i] = new long[this.image.numDimensions()];
            for (int j = 0; j < this.image.numDimensions(); ++j) {
                strelMoves[i][j] = this.structuringElement[i][j] - currentOffset[j];
                if (i > 0) {
                    int n = j;
                    currentOffset[n] = currentOffset[n] + (this.structuringElement[i][j] - this.structuringElement[i - 1][j]);
                    continue;
                }
                int n = j;
                currentOffset[n] = currentOffset[n] + this.structuringElement[i][j];
            }
        }
        while (!pq.isEmpty()) {
            PixelIntensity currentPI = (PixelIntensity)pq.remove();
            List l = currentPI.getLabeling();
            currentPI.getPosition(position, dimensions);
            outputAccess.setPosition(position);
            imageAccess.setPosition(position);
            for (long[] offset : strelMoves) {
                LabelingType outputLabelingType;
                outputAccess.move(offset);
                imageAccess.move(offset);
                if (outputAccess.isOutOfBounds() || imageAccess.isOutOfBounds() || !(outputLabelingType = (LabelingType)outputAccess.get()).getLabeling().isEmpty()) continue;
                outputLabelingType.setLabeling(l);
                double intensity = ((RealType)imageAccess.get()).getRealDouble();
                outputAccess.localize(destPosition);
                pq.add(new PixelIntensity(destPosition, dimensions, intensity, age++, l));
            }
        }
        return true;
    }

    @Override
    public boolean checkInput() {
        if (this.seeds == null) {
            this.errorMessage = "The seed labeling was not provided. Call \"setSeeds\" to do this";
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "The intensity image was not provided. Call \"setIntensityImage\" to do this";
            return false;
        }
        if (this.seeds.numDimensions() != this.image.numDimensions()) {
            this.errorMessage = String.format("The dimensionality of the seed labeling (%dD) does not match that of the intensity image (%dD)", this.seeds.numDimensions(), this.image.numDimensions());
            return false;
        }
        if (this.output != null && this.seeds.numDimensions() != this.output.numDimensions()) {
            this.errorMessage = String.format("The dimensionality of the seed labeling (%dD) does not match that of the output labeling (%dD)", this.seeds.numDimensions(), this.output.numDimensions());
            return false;
        }
        if (this.structuringElement == null) {
            this.structuringElement = AllConnectedComponents.getStructuringElement(this.image.numDimensions());
        }
        for (int i = 0; i < this.structuringElement.length; ++i) {
            if (this.structuringElement[i].length == this.seeds.numDimensions()) continue;
            this.errorMessage = "Some or all of the structuring element offsets do not have the same number of dimensions as the image";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Labeling<L> getResult() {
        return this.output;
    }

    protected static class PixelIntensity<U extends Comparable<U>>
    implements Comparable<PixelIntensity<U>> {
        protected final long index;
        protected final long age;
        protected final double intensity;
        protected final List<U> labeling;

        public PixelIntensity(long[] position, long[] dimensions, double intensity, long age, List<U> labeling) {
            long index = position[0];
            long multiplier = dimensions[0];
            for (int i = 1; i < dimensions.length; ++i) {
                index += position[i] * multiplier;
                multiplier *= dimensions[i];
            }
            this.index = index;
            this.intensity = intensity;
            this.labeling = labeling;
            this.age = age;
        }

        @Override
        public int compareTo(PixelIntensity<U> other) {
            int result = Double.compare(this.intensity, other.intensity);
            if (result == 0) {
                result = Double.compare(this.age, other.age);
            }
            return result;
        }

        void getPosition(long[] position, long[] dimensions) {
            long idx = this.index;
            for (int i = 0; i < dimensions.length; ++i) {
                position[i] = (int)(idx % dimensions[i]);
                idx /= dimensions[i];
            }
        }

        List<U> getLabeling() {
            return this.labeling;
        }
    }
}

