/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.SeparableSymmetricConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.type.numeric.NumericType;

public final class Gauss3 {
    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        int n = source.numDimensions();
        double[] s = new double[n];
        for (int d = 0; d < n; ++d) {
            s[d] = sigma;
        }
        Gauss3.gauss(s, source, target);
    }

    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        int numthreads = Runtime.getRuntime().availableProcessors();
        ExecutorService service = Executors.newFixedThreadPool(numthreads);
        Gauss3.gauss(sigma, source, target, service);
        service.shutdown();
    }

    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target, int numThreads) throws IncompatibleTypeException {
        double[][] halfkernels = Gauss3.halfkernels(sigma);
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, service);
        service.shutdown();
    }

    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ExecutorService service) throws IncompatibleTypeException {
        double[][] halfkernels = Gauss3.halfkernels(sigma);
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, service);
    }

    public static double[][] halfkernels(double[] sigma) {
        int n = sigma.length;
        double[][] halfkernels = new double[n][];
        int[] size = Gauss3.halfkernelsizes(sigma);
        for (int i = 0; i < n; ++i) {
            halfkernels[i] = Gauss3.halfkernel(sigma[i], size[i], true);
        }
        return halfkernels;
    }

    public static int[] halfkernelsizes(double[] sigma) {
        int n = sigma.length;
        int[] size = new int[n];
        for (int i = 0; i < n; ++i) {
            size[i] = Math.max(2, (int)(3.0 * sigma[i] + 0.5) + 1);
        }
        return size;
    }

    public static double[] halfkernel(double sigma, int size, boolean normalize) {
        double two_sq_sigma = 2.0 * sigma * sigma;
        double[] kernel = new double[size];
        kernel[0] = 1.0;
        for (int x = 1; x < size; ++x) {
            kernel[x] = Math.exp((double)(-(x * x)) / two_sq_sigma);
        }
        if (normalize) {
            int x;
            double sum = 0.5;
            for (x = 1; x < size; ++x) {
                sum += kernel[x];
            }
            sum *= 2.0;
            x = 0;
            while (x < size) {
                int n = x++;
                kernel[n] = kernel[n] / sum;
            }
        }
        return kernel;
    }
}

