/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fill;

import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.fill.Filter;
import net.imglib2.algorithm.fill.TypeWriter;
import net.imglib2.algorithm.fill.Writer;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.type.Type;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

public class FloodFill {
    private static final int CLEANUP_THRESHOLD = 100000;

    public static <T extends Type<T>, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter) {
        RandomAccess access = source.randomAccess();
        access.setPosition(seed);
        FloodFill.fill(source, target, seed, ((Type)access.get()).copy(), fillLabel, shape, filter);
    }

    public static <T, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, T seedLabel, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter) {
        FloodFill.fill(source, target, seed, seedLabel, fillLabel, shape, filter, new TypeWriter());
    }

    public static <T, U> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, T seedLabel, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter, Writer<U> writer) {
        int n = source.numDimensions();
        ValuePair reference = new ValuePair(seedLabel, fillLabel);
        RandomAccessible paired = Views.pair(source, target);
        TLongList[] coordinates = new TLongList[n];
        for (int d = 0; d < n; ++d) {
            coordinates[d] = new TLongArrayList();
            coordinates[d].add(seed.getLongPosition(d));
        }
        RandomAccessible neighborhood = shape.neighborhoodsRandomAccessible(paired);
        RandomAccess neighborhoodAccess = neighborhood.randomAccess();
        RandomAccess targetAccess = target.randomAccess();
        targetAccess.setPosition(seed);
        writer.write(fillLabel, targetAccess.get());
        for (int i = 0; i < coordinates[0].size(); ++i) {
            for (int d = 0; d < n; ++d) {
                neighborhoodAccess.setPosition(coordinates[d].get(i), d);
            }
            Cursor neighborhoodCursor = ((Neighborhood)neighborhoodAccess.get()).cursor();
            while (neighborhoodCursor.hasNext()) {
                Pair p = (Pair)neighborhoodCursor.next();
                if (!filter.accept((Pair<Pair, ValuePair>)p, (Pair<Pair, ValuePair>)reference)) continue;
                writer.write(fillLabel, p.getB());
                for (int d = 0; d < n; ++d) {
                    coordinates[d].add(neighborhoodCursor.getLongPosition(d));
                }
            }
            if (i <= 100000) continue;
            for (int d = 0; d < coordinates.length; ++d) {
                TLongList c = coordinates[d];
                coordinates[d] = c.subList(i, c.size());
            }
            i = 0;
        }
    }
}

