/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.integer.Mixed;

public final class MixedRandomAccess<T>
extends AbstractLocalizable
implements RandomAccess<T> {
    private final RandomAccess<T> s;
    private final int m;
    private final long[] translation;
    private final boolean[] sourceZero;
    private final boolean[] sourceInv;
    private final int[] sourceComponent;
    private final long[] tmpPosition;
    private final long[] tmpDistance;

    MixedRandomAccess(RandomAccess<T> source, Mixed transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.m = transformToSource.numTargetDimensions();
        this.translation = new long[this.m];
        boolean[] targetZero = new boolean[this.m];
        boolean[] targetInv = new boolean[this.m];
        int[] targetComponent = new int[this.m];
        transformToSource.getTranslation(this.translation);
        transformToSource.getComponentZero(targetZero);
        transformToSource.getComponentMapping(targetComponent);
        transformToSource.getComponentInversion(targetInv);
        this.sourceZero = new boolean[this.n];
        this.sourceInv = new boolean[this.n];
        this.sourceComponent = new int[this.n];
        for (int e = 0; e < this.n; ++e) {
            this.sourceZero[e] = true;
        }
        for (int d = 0; d < this.m; ++d) {
            if (targetZero[d]) {
                this.s.setPosition(this.translation[d], d);
                continue;
            }
            int e = targetComponent[d];
            this.sourceZero[e] = false;
            this.sourceInv[e] = targetInv[d];
            this.sourceComponent[e] = d;
        }
        this.tmpPosition = (long[])this.translation.clone();
        this.tmpDistance = new long[this.m];
    }

    protected MixedRandomAccess(MixedRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.s = randomAccess.s.copyRandomAccess();
        this.m = randomAccess.m;
        this.translation = (long[])randomAccess.translation.clone();
        this.sourceZero = (boolean[])randomAccess.sourceZero.clone();
        this.sourceInv = (boolean[])randomAccess.sourceInv.clone();
        this.sourceComponent = (int[])randomAccess.sourceComponent.clone();
        this.tmpPosition = (long[])this.translation.clone();
        this.tmpDistance = new long[this.m];
    }

    @Override
    public void fwd(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + 1L;
        if (!this.sourceZero[d]) {
            if (this.sourceInv[d]) {
                this.s.bck(this.sourceComponent[d]);
            } else {
                this.s.fwd(this.sourceComponent[d]);
            }
        }
    }

    @Override
    public void bck(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] - 1L;
        if (!this.sourceZero[d]) {
            if (this.sourceInv[d]) {
                this.s.fwd(this.sourceComponent[d]);
            } else {
                this.s.bck(this.sourceComponent[d]);
            }
        }
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        if (!this.sourceZero[d]) {
            this.s.move(this.sourceInv[d] ? -distance : distance, this.sourceComponent[d]);
        }
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (!this.sourceZero[d]) {
            this.s.move(this.sourceInv[d] ? -distance : distance, this.sourceComponent[d]);
        }
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long distance = localizable.getLongPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpDistance[td] = this.sourceInv[d] ? -distance : distance;
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpDistance[td] = this.sourceInv[d] ? (long)(-distance[d]) : (long)distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpDistance[td] = this.sourceInv[d] ? -distance[d] : distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = localizable.getLongPosition(d);
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpPosition[td] = this.translation[td] + (this.sourceInv[d] ? -p : p);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = (long)position[d];
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpPosition[td] = this.translation[td] + (this.sourceInv[d] ? -p : p);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = position[d];
            if (this.sourceZero[d]) continue;
            int td = this.sourceComponent[d];
            this.tmpPosition[td] = this.translation[td] + (this.sourceInv[d] ? -p : p);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d < this.n);
        this.position[d] = position;
        if (!this.sourceZero[d]) {
            int td = this.sourceComponent[d];
            long targetPos = this.translation[td] + (long)(this.sourceInv[d] ? -position : position);
            this.s.setPosition(targetPos, td);
        }
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d < this.n);
        this.position[d] = position;
        if (!this.sourceZero[d]) {
            int td = this.sourceComponent[d];
            long targetPos = this.translation[td] + (this.sourceInv[d] ? -position : position);
            this.s.setPosition(targetPos, td);
        }
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public MixedRandomAccess<T> copy() {
        return new MixedRandomAccess<T>(this);
    }

    @Override
    public MixedRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

