/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.util.Fraction;

public class ShortType
extends GenericShortType<ShortType> {
    public ShortType(NativeImg<?, ? extends ShortAccess> img) {
        super(img);
    }

    public ShortType(short value) {
        super(value);
    }

    public ShortType(ShortAccess access) {
        super(access);
    }

    public ShortType() {
        this(0);
    }

    @Override
    public NativeImg<ShortType, ? extends ShortAccess> createSuitableNativeImg(NativeImgFactory<ShortType> storageFactory, long[] dim) {
        NativeImg<ShortType, ShortAccess> container = storageFactory.createShortInstance(dim, new Fraction());
        ShortType linkedType = new ShortType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public ShortType duplicateTypeOnSameNativeImg() {
        return new ShortType(this.img);
    }

    public short get() {
        return this.getShort();
    }

    @Override
    public void set(short b) {
        this.setShort(b);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set((short)f);
    }

    @Override
    public void setInteger(long f) {
        this.set((short)f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.shortValue());
    }

    @Override
    public double getMaxValue() {
        return 32767.0;
    }

    @Override
    public double getMinValue() {
        return -32768.0;
    }

    @Override
    public ShortType createVariable() {
        return new ShortType(0);
    }

    @Override
    public ShortType copy() {
        return new ShortType(this.getShort());
    }
}

