/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericShortType<T extends GenericShortType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<?, ? extends ShortAccess> img;
    protected ShortAccess dataAccess;

    public GenericShortType(NativeImg<?, ? extends ShortAccess> shortStorage) {
        this.img = shortStorage;
    }

    public GenericShortType(short value) {
        this.img = null;
        this.dataAccess = new ShortArray(1);
        this.setShort(value);
    }

    public GenericShortType(ShortAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericShortType() {
        this(0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Deprecated
    protected short getValue() {
        return this.dataAccess.getValue(this.i);
    }

    @Deprecated
    protected void setValue(short f) {
        this.dataAccess.setValue(this.i, f);
    }

    public short getShort() {
        return this.dataAccess.getValue(this.i);
    }

    public void setShort(short f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        short a = this.getShort();
        this.setShort((short)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        short a = this.getShort();
        this.setShort((short)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        short a = this.getShort();
        this.setShort((short)(a + ((GenericShortType)c).getShort()));
    }

    @Override
    public void div(T c) {
        short a = this.getShort();
        this.setShort((short)(a / ((GenericShortType)c).getShort()));
    }

    @Override
    public void mul(T c) {
        short a = this.getShort();
        this.setShort((short)(a * ((GenericShortType)c).getShort()));
    }

    @Override
    public void sub(T c) {
        short a = this.getShort();
        this.setShort((short)(a - ((GenericShortType)c).getShort()));
    }

    @Override
    public int hashCode() {
        return this.getShort();
    }

    @Override
    public int compareTo(T c) {
        short b;
        short a = this.getShort();
        if (a > (b = ((GenericShortType)c).getShort())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setShort(((GenericShortType)c).getShort());
    }

    @Override
    public void setOne() {
        this.setShort((short)1);
    }

    @Override
    public void setZero() {
        this.setShort((short)0);
    }

    @Override
    public void inc() {
        short a = this.getShort();
        a = (short)(a + 1);
        this.setShort(a);
    }

    @Override
    public void dec() {
        short a = this.getShort();
        a = (short)(a - 1);
        this.setShort(a);
    }

    @Override
    public String toString() {
        return "" + this.getShort();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 16;
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getShort() == ((GenericShortType)t).getShort();
    }
}

